/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['./ConditionModelPropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/model/ChangeReason','sap/ui/mdc/base/FilterOperatorConfig','sap/base/util/merge','sap/base/util/deepEqual','sap/base/Log','sap/ui/mdc/base/Condition'],function(C,J,F,c,d,m,e,L,f){"use strict";var g=J.extend("sap.ui.mdc.base.ConditionModel",{constructor:function(){J.apply(this,arguments);this.setSizeLimit(1000);this._oMessageBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){this._oMessageBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}.bind(this));if(!this.getProperty("/conditions")){this.setProperty("/conditions",{});}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{});}this._mFieldPath={};}});g.prototype.bindProperty=function(p,o,P){if(p.startsWith("/conditions/")){var s=p.slice(12);this._getFieldPathProperty(s);s=k.call(this,s);p="/conditions/"+s;}var b=new C(this,p,o,P);return b;};g.prototype.getContext=function(p){if(p.startsWith("/conditions/")){var s=p.slice(12);s=k.call(this,s);p="/conditions/"+s;}return J.prototype.getContext.apply(this,[p]);};g.prototype.bindList=function(p,o,s,a,P){var b=J.prototype.bindList.apply(this,arguments);b.enableExtendedChangeDetection(true);return b;};g._mModels={};g.prototype.destroy=function(){if(this._oListBinding){delete g._mModels[g._createKey(this._oListBinding,this._sName)];this._oListBinding=undefined;this._sName=undefined;}J.prototype.destroy.apply(this,arguments);delete this._mFieldPath;delete this._oMessageBundle;};g.prototype.clone=function(s){var o=new g();o._oListBinding=this._oListBinding;o._sName=this._sName+"_clone";if(s===undefined){var a=this.getFilterFields();if(a){a.forEach(function(b){o.addFilterField(b);},this);}}else{var b=this.getFilterField(s);if(b){o.addFilterField(b);}else{L.error("ConditionModel","clone of ConditionModel for fieldPath '"+s+"' failed!");return o;}}var j={};if(typeof s==="string"){var l=this.getConditions(s);for(var i=0;i<l.length;i++){var n=l[i];var M=k.call(this,s);if(!j[M]){j[M]=[];}j[M].push(m({},n));}}else{j=m({},this.getAllConditions());}o.setConditions(j);return o;};g.prototype.merge=function(s,S,a){this.removeAllConditions(s);var o=m({},S.getAllConditions());for(var M in o){if(!(typeof a==="string")||M===a){var b=f._removeEmptyConditions(o[M]);for(var i=0;i<b.length;i++){var j=b[i];this.addCondition(M,j);}}}this.checkUpdate(true,true);};g.getFor=function(l,n){var K=g._createKey(l,n);var o=g._mModels[K];if(!o){o=new g();o._oListBinding=l;o._sName=n;g._mModels[K]=o;}else if(o._oListBinding!==l){o._oListBinding=l;o._sName=n;}return o;};g._createKey=function(l,n){if(!l){return n;}return l.getModel().getId()+"--"+l.getPath()+"#"+(n===undefined?"":n);};g.prototype.setFor=function(l,n){delete g._mModels[g._createKey(this._oListBinding,n)];this._oListBinding=l;this._sName=n;g._mModels[g._createKey(this._oListBinding,n)]=this;return this;};g.destroyCM=function(o,n){o.destroy();};g._getAll=function(l){var o=[];var K=g._createKey(l);K=K.slice(0,K.length-1);for(var a in g._mModels){if(a.indexOf(K)===0){var b=g._mModels[a];o.push(b);}}return o;};g._getAllKeys=function(l){var o=[];var K=g._createKey(l);K=K.slice(0,K.length-1);for(var a in g._mModels){if(a.indexOf(K)===0){o.push(a);}}return o;};g.prototype.getConditions=function(s){return _.call(this,s);};function _(s,b){var o=this.getProperty("/conditions");var a;if(typeof s=="string"){s=k.call(this,s);if(!o[s]&&b){o[s]=[];}a=o[s]||[];}else{L.error("ConditionModel","getConditions without FieldPath is not supported!");a=[];for(var M in o){for(var i=0;i<o[M].length;i++){var j=o[M][i];a.push(j);}}}return a;}function h(){var o=this.getProperty("/conditions");for(var M in o){if(o[M].length>0){return true;}}return false;}g.prototype.getAllConditions=function(s){var o=this.getProperty("/conditions");var r={};for(var M in o){var a=this.getProperty("/fieldPath");var b=a[M];var s=b?b.fieldPath:M;r[s]=m([],o[M]);}return r;};g.prototype.indexOf=function(s,o){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var I=-1;var a=this.getConditions(s);var b=JSON.stringify(o,['operator','values']);a.some(function(o,i){if(JSON.stringify(o,['operator','values'])===b){I=i;return true;}return false;});return I;};g.prototype.exist=function(o,s){if(typeof s==="string"){return this.indexOf(s,o)>=0;}else{throw new Error("sFieldPath must be provided "+this);}};g.prototype.setConditions=function(o){var i=0;var a;this.setProperty("/conditions",{});if(Array.isArray(o)){throw new Error("setConditions with an Array of condition is not supported! "+this);}else{this._bNoSingleEvent=true;for(var M in o){this._getFieldPathProperty(M);for(i=0;i<o[M].length;i++){a=o[M][i];this.insertCondition(M,-1,a,true);}M=k.call(this,M);this.firePropertyChange({reason:c.Add,path:"/conditions/"+M,context:undefined,value:o[M]});}this.checkUpdate(true,true);this._bNoSingleEvent=false;}return this;};g.prototype.addCondition=function(s,o,b){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}return this.insertCondition(s,-1,o,b);};g.prototype.insertCondition=function(s,I,o,b){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var a;this._checkIsEmpty(o);this._updateValues(o);this._getFieldPathProperty(s);if(!b){var i=this.indexOf(s,o);if(i>=0){return this;}}a=_.call(this,s,true);if(I==-1){a.push(o);}else{a.splice(I,0,o);}this._checkMaxConditions(s);if(!this._bNoSingleEvent){this.checkUpdate(true,true);s=k.call(this,s);this.firePropertyChange({reason:c.Add,path:"/conditions/"+s,context:undefined,value:a});}return this;};g.prototype.createItemCondition=function(s,K,D){L.error("ConditionModel","createItemCondition is deprecated");return f.createItemCondition(K,D);};g.prototype.createCondition=function(s,o,v){L.error("ConditionModel","createCondition is deprecated");return f.createCondition(o,v);};g.prototype.removeCondition=function(s,v){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var i=-1;if(typeof v==="object"){i=this.indexOf(s,v);}else if(typeof v==="number"){i=v;}var a=this.getConditions(s);if(a.length>i){a.splice(i,1);this.checkUpdate(true,true);this._checkMaxConditions(s);s=k.call(this,s);this.firePropertyChange({reason:c.Remove,path:"/conditions/"+s,context:undefined,value:a});return true;}return false;};g.prototype.removeAllConditions=function(s){var o=this.getProperty("/conditions");if(typeof s==="string"){s=k.call(this,s);delete o[s];this.firePropertyChange({reason:c.Remove,path:"/conditions/"+s,context:undefined,value:o[s]});}else{for(var M in o){delete o[M];M=k.call(this,M);this.firePropertyChange({reason:c.Remove,path:"/conditions/"+M,context:undefined,value:o[M]});}}this.checkUpdate(true,true);return this;};g.prototype.deleteConditions=function(o,B){var s;if(!o||!B){return;}if(!Array.isArray(o)){o=[o];}var D=B.oModel.getProperty(B.getPath(),B.getContext())||[];if(Array.isArray(o)&&D.length>0){var I=[],l,i,n;if(Array.isArray(D)){for(i=0;i<o.length;i++){for(var j=0;j<D.length;j++){if(e(D[j],o[i].getProperty())){I.push(j);break;}}}I.sort(function(a,b){return a-b;});l=function(a){s=D[a].fieldPath;D.splice(a,1);};}else if(typeof D==="object"){for(n in D){var p=o[i].getPath();p=p.substring(o[i].getPath().lastIndexOf("/")+1);I.push(n);}l=function(p){delete D[p];};}for(i=I.length-1;i>-1;i--){l(I[i]);}}B.getModel().checkUpdate(true,true);this._checkMaxConditions(s);};g.prototype._checkIsEmpty=function(a){var o=this.getFilterOperatorConfig();a=a||this.getConditions();f.checkIsEmpty(a,o);};g.prototype._updateValues=function(a){var o=this.getFilterOperatorConfig();a=a||this.getConditions();f.updateValues(a,o);};g.prototype._checkRequiredConditions=function(s,a){var b=a?[a]:Object.keys(this._mFieldPath||{});var E=false;var M=this._oMessageBundle.getText("conditionmodel.REQUIRED_CONDITION_MISSING");b.forEach(function(a){if(this._mFieldPath&&this._mFieldPath[a]){var o=this._mFieldPath[a];if(o.getRequired()&&this.getConditions(a).length<=0){if(s){this.addFieldPathMessage(a,M);}E=true;}else{this.removeFieldPathMessage(a,M);}}},this);return!E;};g.prototype._checkMaxConditions=function(s){var a=s?[s]:Object.keys(this._mFieldPath||{});var E=false;var S=false;if(S){var M=this._oMessageBundle.getText("conditionmodel.TOO_MANY_CONDITIONS");a.forEach(function(s){if(this._mFieldPath&&this._mFieldPath[s]){var o=this._mFieldPath[s];if(o.getMaxConditions()>=0&&this.getConditions(s).length>o.getMaxConditions()){this.addFieldPathMessage(s,M);E=true;}else{this.removeFieldPathMessage(s,M);}}},this);}else{a.forEach(function(s){if(this._mFieldPath&&this._mFieldPath[s]){var o=this._mFieldPath[s];var b=this.getConditions(s);var l=0;for(var i=0;i<b.length;i++){if(!b[i].isEmpty){l++;}}while(o.getMaxConditions()>=0&&l>o.getMaxConditions()){this.removeCondition(s,0);l--;E=false;}}},this);}return E;};g.prototype.addFilterField=function(o){var s=o.getFieldPath();this._mFieldPath[s]=o;this._getFieldPathProperty(s);};g.prototype.getFilterField=function(s){var a=Object.keys(this._mFieldPath||{});return this._mFieldPath[s||a[0]];};g.prototype.getFilterFields=function(){var a=Object.keys(this._mFieldPath||{});var b=[];a.forEach(function(s){b.push(this._mFieldPath[s]);},this);return b;};g.prototype.removeFilterField=function(o){var s=o.getFieldPath();if(this._mFieldPath&&this._mFieldPath[s]){delete this._mFieldPath[s];}var a=this.getProperty("/fieldPath");if(a&&a[s]){delete a[s];}};g.prototype._getFieldPathProperty=function(s){var E=k.call(this,s);var o=this.getProperty("/fieldPath");if(!o[E]){o[E]={fieldPath:s,valueState:"None",valueStateText:"",messages:[]};}var a=this.getProperty("/conditions");if(!a[E]){a[E]=[];}return o[E];};g.prototype.addFieldPathMessage=function(s,M){var o=this._getFieldPathProperty(s);if(!o.messages.some(function(I,i){if(I===M){return true;}return false;})){o.messages.push(M);}this._updateValueState(s);};g.prototype.setUIMessage=function(s,M){var o=this._getFieldPathProperty(s);o.uiMessage=M;this._updateValueState(s);};g.prototype.removeFieldPathMessage=function(s,M){var I;var o=this._getFieldPathProperty(s);if(o.messages.some(function(a,i){if(a===M){I=i;return true;}return false;})){o.messages.splice(I,1);this._updateValueState(s);}};g.prototype.removeUIMessage=function(s){var o=this._getFieldPathProperty(s);delete o.uiMessage;this._updateValueState(s);};g.prototype._updateValueState=function(s){var u=false,o=this._getFieldPathProperty(s),v="None",V="";if(o.uiMessage){v="Error";V=o.uiMessage;}else if(o.messages.length>0){v="Error";V=o.messages[o.messages.length-1];}if(o.valueState!==v){o.valueState=v;u=true;}if(o.valueStateText!==V){o.valueStateText=V;u=true;}if(u){this.checkUpdate(true,true);}};g.prototype.isValid=function(v,s){var a=s?[s]:Object.keys(this._mFieldPath||{});var V=this._checkRequiredConditions(v);a.forEach(function(s){var o=this._getFieldPathProperty(s);V=V&&o.valueState=="None";},this);return V;};g.prototype.applyFilters=function(l,v,a){if(l===undefined||typeof l==="boolean"){if(typeof l==="boolean"){a=v;v=l;}l=this._oListBinding;}if(!l){L.error("ConditionModel","applyFilters without ListBinding can not be applied!");return false;}if(this.isValid(v)){var H=false;if(l.changeParameters){if(!l.isSuspended()){H=true;l.suspend();}if(this.getConditions("$search").length){var V=this.getConditions("$search")[0].values[0];l.changeParameters({$search:V});}else{l.changeParameters({$search:undefined});}}var o;if(a){o=this.getAllFilters();}else{o=this.getFilters();}if(o){l.filter(o);}else{l.filter();}if(H){l.resume();}if(o){window.console.log("CM-Filter:"+this._prettyPrintFilters(o));}return true;}return false;};g.prototype.getAllFilters=function(){var o=g._getAll(this._oListBinding);var O=[];o.forEach(function(b){var a=b.getFilters();if(a){O.push(a);}});var a=null;if(O.length===1){a=O[0];}else if(O.length>1){a=new F({filters:O,and:true});}return a;};g.prototype._prettyPrintFilters=function(o){var r;if(!o){return"";}if(o._bMultiFilter){r="";var a=o.bAnd;o.aFilters.forEach(function(o,i,b){r+=this._prettyPrintFilters(o);if(b.length-1!=i){r+=a?" and ":" or ";}},this);return"("+r+")";}else{r=o.sPath+" "+o.sOperator+" '"+o.oValue1+"'";if(o.sOperator==="BT"){r+="...'"+o.oValue2+"'";}return r;}};g.prototype.getFilterOperatorConfig=function(){var M=this._oListBinding&&this._oListBinding.getModel();return d.getFor(M);};g.prototype.getFilters=function(s){var i,l,a,o=[],b,t,S,n,p;var q=this.getFilterOperatorConfig();if(s===undefined){b=this.getAllConditions();}else if(typeof s==="string"){b={};b[s]=this.getConditions(s);}else{b={};}var O,r;for(var M in b){l=[];a=[];t=null;var u=b[M];var v=this.getProperty("/fieldPath");var w=v[M];var x=w?w.fieldPath:M;for(i=0;i<u.length;i++){O=q.getOperator(u[i].operator);r=O.getModelFilter(u[i],x);if(!(O.exclude&&u[i].operator==="NE")){if(r.sPath==="$search"){continue;}var $=/^\*(.+)\*$/.exec(r.sPath);if($){var y=$[1].split(',');for(var j=0;j<y.length;j++){l.push(new F(y[j],r.sOperator,r.oValue1));}continue;}if(r.sPath&&r.sPath.indexOf('*/')>-1){S=r.sPath.split('*/');if(S.length===2){n=S[0];p=S[1];r.sPath='L1/'+p;if(!t){t={path:n,operator:'Any',variable:'L1'};}l.push(r);}else{throw new Error("Not Implemented");}}else{l.push(r);}}}for(i=0;i<u.length;i++){O=q.getOperator(u[i].operator);r=O.getModelFilter(u[i],x);if(O.exclude&&u[i].operator==="NE"){a.push(r);}}if(t){if(l.length===1){t.condition=l[0];}else if(l.length>1){t.condition=new F({filters:l,and:false});}l=[new F(t)];}if(l.length===1){o.push(l[0]);}else if(l.length>1){o.push(new F({filters:l,and:false}));}if(a.length===1){o.push(a[0]);}else if(a.length>1){o=o.merge(a);}}if(o.length===1){return o[0];}else if(o.length>1){return new F({filters:o,and:true});}else{return null;}};g.prototype.serialize=function(){var o=m({},this.getAllConditions());for(var M in o){var a=o[M];a.forEach(function(b){delete b.isEmpty;},this);if(a.length===0){delete o[M];}}return'{"conditions":'+JSON.stringify(o)+"}";};g.prototype.serializeMeta=function(){var a=Object.keys(this._mFieldPath||{});var r="";a.forEach(function(s){if(this.getData().fieldPath[s].valueState!=="None"){r+=JSON.stringify(this.getData().fieldPath[s]);}},this);return'{"fieldPath":'+r+"}";};g.prototype.parse=function(o){var b=function(i,v){var a;if(!isNaN(parseInt(i))&&(typeof v==='string')){a=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(v);if(a){return new Date(v);}}return v;};this.setConditions(JSON.parse(o,b).conditions);};g.serialize=function(l){var o=g._getAllKeys(l);var r="";o.forEach(function(a){var b=g._mModels[a];if(h.call(b)){r+=">>>"+a+"<<<";r+=b.serialize();}});return r;};g.serializeMeta=function(l){var o=g._getAllKeys(l);var r="";o.forEach(function(a){var b=g._mModels[a];r+=b.serializeMeta();});return r;};g.parse=function(o){var a=o.split(">>>");a.forEach(function(s){var p=s.split("<<<");if(p.length>1){if(g._mModels[p[0]]){g._mModels[p[0]].parse(p[1]);}else{var b=new g();b.parse(p[1]);g._mModels[p[0]]=b;}}});};function k(s){if(s){var p=s.split("/");if(p.length>1){s="";for(var i=0;i<p.length;i++){var P=p[i];if(i>0){if(!isNaN(P)||!isNaN(p[i-1])){s=s+"/";}else{s=s+"_";}}s=s+P;}}}return s;}return g;},true);
