/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/library','sap/ui/mdc/base/FieldBaseRenderer','sap/ui/mdc/base/FilterOperatorConfig','sap/ui/mdc/base/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/message/MessageMixin','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/base/util/isEmptyObject','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver',"sap/ui/base/SyncPromise",'sap/ui/events/KeyCodes'],function(q,D,l,F,a,C,b,c,d,e,M,O,f,m,L,g,h,k,n,o,S,K){"use strict";var E=l.EditMode;var p=l.FieldDisplay;var V=d.ValueState;var r=d.CalendarType;var s=e.extend("sap.ui.mdc.base.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.FieldDisplay",defaultValue:p.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_onlyEEQ:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.base.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.base.FieldHelpBase",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{}},publicMethods:[],defaultAggregation:"content"},_oManagedObjectModel:null});M.call(s.prototype);var t={"default":{edit:"sap/m/Input",editMulti:["sap/m/MultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Text",createEdit:d1,createEditMulti:f1,createEditMultiLine:g1,createDisplay:h1},search:{edit:"sap/m/SearchField",display:"sap/m/Text",createEdit:e1,createDisplay:h1},date:{edit:"sap/m/DatePicker",editMulti:["sap/m/MultiInput","sap/m/Token"],display:"sap/m/Text",createEdit:i1,createEditMulti:f1,createDisplay:h1},time:{edit:"sap/m/TimePicker",editMulti:["sap/m/MultiInput","sap/m/Token"],display:"sap/m/Text",createEdit:i1,createEditMulti:f1,createDisplay:h1},dateTime:{edit:"sap/m/DateTimePicker",editMulti:["sap/m/MultiInput","sap/m/Token"],display:"sap/m/Text",createEdit:i1,createEditMulti:f1,createDisplay:h1},link:{edit:"sap/m/Input",editMulti:["sap/m/MultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Link",createEdit:d1,createEditMulti:f1,createEditMultiLine:g1,createDisplay:j1},bool:{edit:"sap/m/Input",display:"sap/m/Text",createEdit:k1,createDisplay:h1},unit:{edit:"sap/m/Input",editMulti:["sap/m/MultiInput","sap/m/Input","sap/m/Token"],display:"sap/m/Text",createEdit:l1,createEditMulti:m1,createDisplay:h1}};var u={};var v={bool:{name:"sap/ui/mdc/base/BoolFieldHelp",id:"BoolDefaultHelp",control:undefined}};s.prototype.init=function(){this._oManagedObjectModel=new n(this);this._oObserver=new o(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","_onlyEEQ"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];};s.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",L1,this);}var j=this.getContent();if(j){Z.call(this,j);}var U1=this.getContentEdit();if(U1){Z.call(this,U1);}var V1=this.getContentDisplay();if(V1){Z.call(this,V1);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._oFilterOperatorConfig){this._oFilterOperatorConfig.destroy();delete this._oFilterOperatorConfig;}if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType){this._oConditionsType.destroy();this._oConditionsType=undefined;}var W1=T.call(this);if(W1){W1.removeFilterField(this);}var X1=A1.call(this);if(X1){X1.detachEvent("dataUpdate",F1,this);if(this._bConnected){G1.call(this);X1.connect();}}if(this.iLiveChangeTimer){clearTimeout(this.iLiveChangeTimer);}};s.prototype.onBeforeRendering=function(){$.call(this);};s.prototype.onAfterRendering=function(){if(A1.call(this)&&this.getEditMode()!=E.Display){var j=this.getAggregation("_content",[]);for(var i=0;i<j.length;i++){var U1=j[i];var V1=U1.getFocusDomRef();q(V1).attr("autocomplete","off");}}};s.prototype.onfocusin=function(i){H1.call(this);};s.prototype.onsapup=function(i){var j=A1.call(this);var U1=i.srcControl;if(j&&(!this._bIsMeasure||U1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(-1);}};s.prototype.onsapdown=function(i){var j=A1.call(this);var U1=i.srcControl;if(j&&(!this._bIsMeasure||U1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(1);}};s.prototype.onsapenter=function(i){var j=A1.call(this);if(j&&j.isOpen(true)){j.close();}};s.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var U1=this.getContent();if(U1){Z.call(this,U1);}var V1=this.getContentEdit();if(V1){Z.call(this,V1);}var W1=this.getContentDisplay();if(W1){Z.call(this,W1);}var X1=this.getFieldInfo();if(X1){X1.detachEvent("dataUpdate",L1,this);}var Y1=e.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(U1){Y.call(this,U1);}if(V1){Y.call(this,V1);}if(W1){Y.call(this,W1);}if(X1){X1.attachEvent("dataUpdate",L1,this);}return Y1;};s.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};function _(i,j,U1,V1){if(!V1){if(j){V1=Promise.resolve(this._getResultForPromise(i));}else{V1=Promise.reject(U1);}}this._fireChange(i,j,U1,V1);}s.prototype._fireChange=function(i,j,U1,V1){};s.mapEdmTypes={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};function w(i){var j=x.call(this,i);if(j){return new j(G.call(this,i,this.getDataTypeFormatOptions(),this.getDataTypeConstraints()),this.getDataTypeConstraints());}else{return null;}}function x(i){var j;while(!j){j=O.get(i||"");if(!j){i=s.mapEdmTypes[i];if(!i){break;}}}return j;}function y(){if(!this._oDataType){this._oDataType=this.getDataType();if(typeof this._oDataType==="string"){this._oDataType=w.call(this,this._oDataType);}}return this._oDataType;}s.prototype._initDataType=function(){if(this._oDataType){this._oDataType.destroy();this._oDataType=undefined;}if(this._oDateOriginalType){this._oDateOriginalType.destroy();this._oDateOriginalType=undefined;}if(this._oUnitOriginalType){this._oUnitOriginalType.destroy();this._oUnitOriginalType=undefined;}delete this._sDisplayFormat;delete this._sValueFormat;delete this._sCalendarType;};s.prototype._getDataType=function(){return y.call(this);};function z(){if(this._oDataType&&typeof this._oDataType==="object"){return this._oDataType.getMetadata().getName();}else{return this.getDataType();}}function A(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oConstraints){return this._oDataType.oConstraints;}else{return this.getDataTypeConstraints();}}function B(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oFormatOptions){return this._oDataType.oFormatOptions;}else{return this.getDataTypeFormatOptions();}}function G(i,j,U1){if(this.getMaxConditions()!==1||this.getEditMode()===E.Display){return j;}switch(i){case"Edm.Date":case"sap.ui.model.type.Date":case"sap.ui.model.odata.type.Date":this._sValueFormat="yyyy-MM-dd";break;case"Edm.DateTime":case"sap.ui.model.odata.type.DateTime":if(U1&&(U1.displayFormat==="Date"||U1.isDateOnly)){this._sValueFormat="yyyy-MM-dd";}else{this._sValueFormat="yyyy-MM-dd'T'HH:mm:ss";}break;case"Edm.DateTimeOffset":case"sap.ui.model.type.DateTime":case"sap.ui.model.odata.type.DateTimeOffset":this._sValueFormat="yyyy-MM-dd'T'HH:mm:ss";break;case"Edm.TimeOfDay":case"sap.ui.model.type.Time":case"sap.ui.model.odata.type.TimeOfDay":this._sValueFormat="HH:mm:ss";break;default:return j;}this._sDisplayFormat="medium";if(j){j=m({},j);if(j.style){this._sDisplayFormat=j.style;delete j.style;}else if(j.pattern){this._sDisplayFormat=j.pattern;}if(j.calendarType){this._sCalendarType=j.calendarType;}j.pattern=this._sValueFormat;j.calendarType=r.Gregorian;}else{j={pattern:this._sValueFormat,calendarType:r.Gregorian};}return j;}function H(){var i=y.call(this);var j=i.getMetadata().getName();var U1=i.oFormatOptions;var V1=i.oConstraints;if(!U1||U1.style||!U1.pattern||U1.pattern!==this._sValueFormat||!U1.calendarType||U1.calendarType!==r.Gregorian){if(V1&&V1.isDateOnly){V1=m({},V1);delete V1.isDateOnly;V1.displayFormat="Date";}var W1=O.get(j);this._oDateOriginalType=this._oDataType;this._oDataType=new W1(G.call(this,j,U1,V1),V1);M1.call(this);}}function I(){var i=y.call(this);var j=i.getMetadata().getName();var U1=i.oFormatOptions;var V1=g(i.oConstraints)?undefined:i.oConstraints;if(!U1||!U1.hasOwnProperty("showMeasure")||U1.showMeasure){U1=m({},U1);U1.showMeasure=false;U1.strictParsing=true;if(U1.customCurrencies){delete U1.customCurrencies;}if(U1.customUnits){delete U1.customUnits;}var W1=O.get(j);this._oUnitOriginalType=this._oDataType;this._oDataType=new W1(U1,V1);if(this._mCustomUnits){this._oDataType.formatValue([null,null,this._mCustomUnits],"string");}M1.call(this);}}function J(i,j){var U1=A1.call(this);if(U1&&this._bConnected){B1.call(this,i,U1);}}s.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};function N(i){if(i&&i===E.Editable){return true;}else{return false;}}function P(i){if(i&&i!==E.Disabled){return true;}else{return false;}}function Q(i){if(i&&i!==E.Editable){return true;}else{return false;}}function R(){var i=z.call(this);if(i==="Edm.Boolean"||i==="sap.ui.model.type.Boolean"||i==="sap.ui.model.odata.type.Boolean"||i==="sap.ui.mdc.base.type.Boolean"){return true;}else{return this.getProperty("_onlyEEQ");}}s.prototype._getOnlyEEQ=function(){return R.call(this);};s.prototype._handleModelContextChange=function(i){if(!this._bFFAdded){var j=T.call(this);if(j){j.addFilterField(this);this._bFFAdded=true;}}};function T(){var i=this.getBinding("conditions");if(i){var j=i.getModel();if(j.isA("sap.ui.mdc.base.ConditionModel")){return j;}}return undefined;}s.prototype._getFilterOperatorConfig=function(){var i=T.call(this);if(i){return i.getFilterOperatorConfig();}else if(this._oFilterOperatorConfig){return this._oFilterOperatorConfig;}else{this._oFilterOperatorConfig=a.getFor();return this._oFilterOperatorConfig;}};function U(i){var j=T.call(this);if(j){j.setUIMessage(this.getFieldPath(),i);}else{this.setValueState(V.Error);this.setValueStateText(i);}}function W(){var i=T.call(this);if(i){i.removeUIMessage(this.getFieldPath());}else{this.setValueState(V.None);this.setValueStateText();}}s.prototype._observeChanges=function(j){if(j.name==="editMode"){if(this.getAggregation("_content")){$.call(this);}}if(j.name==="multipleLines"){if(this.getAggregation("_content")){$.call(this);}}if(j.name==="dataType"){if(this._oDataType){var U1=x.call(this,j.current);if(!(this._oDataType instanceof U1)){this._initDataType();this.destroyAggregation("_content");M1.call(this);}}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oDataType){this._initDataType();this.destroyAggregation("_content");M1.call(this);}}if(j.name==="maxConditions"){if(this.getAggregation("_content")){$.call(this);}M1.call(this);}if(j.name==="conditions"){this._bParseError=false;J.call(this,j.current,j.old);var V1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var W1=this._aAsyncChanges[i];if(W1.waitForUpdate&&f(W1.result,j.current)){u1.call(this,W1);V1=true;break;}}if(V1){this._aAsyncChanges.splice(i,1);}}if(j.name==="display"){a1.call(this);M1.call(this);}if(j.name==="fieldHelp"&&j.ids){z1.call(this,j.ids,j.mutation);M1.call(this);}if(j.name==="fieldInfo"&&j.child){K1.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){X.call(this,j.child,j.mutation);}if(j.name==="contentEdit"&&j.child){X.call(this,j.child,j.mutation);}if(j.name==="contentDisplay"&&j.child){X.call(this,j.child,j.mutation);}if(j.name==="_onlyEEQ"){M1.call(this);}};s.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};s.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=this.getId();}return i;};s.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._bIsMeasure){return i[1];}else{return i[0];}}else{return this;}};s.prototype.getMaxConditionsForHelp=function(){if(this._bIsMeasure){return 1;}else{return this.getMaxConditions();}};s.prototype.enhanceAccessibilityState=function(i,j){var U1=this.getParent();if(U1&&U1.enhanceAccessibilityState){U1.enhanceAccessibilityState(this,j);}return j;};s.prototype.connectLabel=function(i){c1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};function X(i,j){if(j==="remove"){Z.call(this,i);o1.call(this,i);}else if(j==="insert"){n1.call(this,i);c1.call(this,i);Y.call(this,i);if(this.getAggregation("_content")){a1.call(this);}var U1;var V1;for(V1 in i.getMetadata().getAllProperties()){if(i.getBindingPath(V1)==="/conditions"){U1=i.getBindingInfo(V1);if(U1&&U1.type&&U1.type instanceof c){this._oConditionsType=U1.type;M1.call(this);}this._sBoundProperty=V1;}if(V1==="editable"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/editMode",formatter:N});}if(V1==="enabled"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/editMode",formatter:P});}if(V1==="displayOnly"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/editMode",formatter:Q});}if(V1==="required"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/required"});}if(V1==="textAlign"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/textAlign"});}if(V1==="textDirection"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/textDirection"});}if(V1==="valueState"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/valueState"});}if(V1==="valueStateText"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/valueStateText"});}if(V1==="placeholder"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/placeholder"});}if(V1==="tooltip"&&!i.getBindingPath(V1)&&i.isPropertyInitial(V1)){i.bindProperty(V1,{path:"$field>/tooltip"});}}for(var W1 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(W1)==="/conditions"){U1=i.getBindingInfo(W1);if(U1&&U1.template){for(V1 in U1.template.getMetadata().getAllProperties()){var X1=U1.template.getBindingInfo(V1);if(X1&&X1.type&&X1.type instanceof b){this._oConditionType=X1.type;M1.call(this);break;}}}break;}}}}function Y(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",t1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",w1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",x1,this);}}function Z(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",t1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",w1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",x1,this);}}function $(){var j=this.getEditMode();if(this.getContent()||this._bIsBeingDestroyed||(j===E.Display&&this.getContentDisplay())||(j!==E.Display&&this.getContentEdit())){a1.call(this);return;}var U1=z.call(this);var V1=A.call(this);var W1=B.call(this);var X1=this.getMaxConditions();var Y1;var Z1;var $1;var _1=this.getAggregation("_content",[]);var a2;var b2;if(_1.length>0){a2=_1[0];b2=a2.getMetadata().getName().replace(/\./g,"/");}switch(U1){case"Edm.Date":case"sap.ui.model.type.Date":case"sap.ui.model.odata.type.Date":Y1=t.date;break;case"Edm.DateTime":case"sap.ui.model.odata.type.DateTime":if(V1&&(V1.displayFormat==="Date"||V1.isDateOnly)){Y1=t.date;}else{Y1=t.dateTime;}break;case"Edm.DateTimeOffset":case"sap.ui.model.type.DateTime":case"sap.ui.model.odata.type.DateTimeOffset":Y1=t.dateTime;break;case"Edm.TimeOfDay":case"sap.ui.model.type.Time":case"sap.ui.model.odata.type.TimeOfDay":Y1=t.time;break;case"Edm.Boolean":case"sap.ui.model.type.Boolean":case"sap.ui.model.odata.type.Boolean":case"sap.ui.mdc.base.type.Boolean":Y1=t.bool;break;case"sap.ui.model.odata.type.Unit":case"sap.ui.model.odata.type.Currency":case"sap.ui.model.type.Unit":case"sap.ui.model.type.Currency":if(!W1||!W1.hasOwnProperty("showMeasure"||W1.showMeasure)){Y1=t.unit;}else{Y1=t.default;}break;default:if(this.getFieldInfo()&&this._bTriggerable){Y1=t.link;}else{var c2=new RegExp("^\\*(.*)\\*|\\$search$");if(c2.test(this.getFieldPath())&&this.getMaxConditions()===1){Y1=t.search;}else{Y1=t.default;}}break;}if(j===E.Display){Z1=Y1.display;$1=Y1.createDisplay;}else if(X1!==1){Z1=Y1.editMulti;$1=Y1.createEditMulti;}else if(this.getMultipleLines()){Z1=Y1.editMultiLine;$1=Y1.createEditMultiLine;}else{Z1=Y1.edit;$1=Y1.createEdit;}if(!Z1){throw new Error("No control defined for type "+U1+" in "+this);}var d2;if(Array.isArray(Z1)){d2=Z1;Z1=d2[0];}else{d2=[Z1];}if(Z1!==b2){this._bHideOperator=false;if(a2){a1.call(this);if(a2.isA("sap.m.DateTimeField")){this._initDataType();}M1.call(this);}var e2;var i=0;for(i=0;i<d2.length;i++){var f2=d2[i];if(!u[f2]){u[f2]={};}else if(!u[f2].control){u[f2].control=sap.ui.require(f2);if(!u[f2].control){e2=undefined;}}else if(i===0){e2=u[f2].control;}}if(!e2){if(u[Z1].promise){u[Z1].promise.then($.bind(this));return;}else{u[Z1].promise=new Promise(function(j2){u[Z1].resolve=j2;sap.ui.require(d2,b1.bind(this));}.bind(this)).then($.bind(this));return;}}var g2=this.getId()+"-inner";var h2=$1.call(this,e2,g2);for(i=0;i<h2.length;i++){var i2=h2[i];i2.attachEvent("parseError",r1,this);i2.attachEvent("validationError",s1,this);n1.call(this,i2);c1.call(this,i2);if(this._bConnected&&((i===0&&!this._bIsMeasure)||(i===1&&this._bIsMeasure))){I1.call(this,i2);}this.addAggregation("_content",i2);}}}function a1(){this.destroyAggregation("_content");if(this._oDateOriginalType){this._oDataType=this._oDateOriginalType;this._oDateOriginalType=undefined;}else if(this._oUnitOriginalType){this._oDataType=this._oUnitOriginalType;this._oUnitOriginalType=undefined;}}function b1(){for(var i=0;i<arguments.length;i++){var j=arguments[i];var U1=j.getMetadata().getName();U1=U1.replace(/\./g,"/");u[U1].control=j;if(u[U1].resolve){u[U1].resolve();delete u[U1].resolve;}}}function c1(i){i.setModel(this._oManagedObjectModel,"$field");}function d1(i,j){var U1=O1.call(this);var V1=new i(j,{value:{path:"$field>/conditions",type:U1},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",width:"100%",tooltip:"{$field>/tooltip}",change:t1.bind(this),liveChange:w1.bind(this),valueHelpRequest:C1.bind(this),showSuggestion:true});J1.call(this,V1);this._sBoundProperty="value";return[V1];}function e1(i,j){this._bHideOperator=true;var U1=N1.call(this);var V1=new i(j,{value:{path:"$field>/conditions/0",type:U1,mode:"OneWay"},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:t1.bind(this)});return[V1];}function f1(i,j){var U1=sap.ui.require("sap/m/Token");var V1=N1.call(this);var W1=new U1(j+"-token",{text:{path:'$field>',type:V1}});var X1=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:W1},dependents:[W1],change:t1.bind(this),liveChange:w1.bind(this),tokenUpdate:y1.bind(this),valueHelpRequest:C1.bind(this)});J1.call(this,X1);return[X1];}function g1(i,j){var U1=O1.call(this);var V1=new i(j,{value:{path:"$field>/conditions",type:U1},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:t1.bind(this),liveChange:w1.bind(this)});this._sBoundProperty="value";return[V1];}function h1(i,j){var U1=O1.call(this);var V1=new i(j,{text:{path:"$field>/conditions",type:U1},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}"});this._sBoundProperty="text";return[V1];}function i1(i,j){this._bHideOperator=true;var U1=O1.call(this);H.call(this);var V1=new i(j,{value:{path:"$field>/conditions",type:U1},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:t1.bind(this)});if(V1.setDisplayFormatType){V1.setDisplayFormatType(this._sCalendarType);}this._sBoundProperty="value";return[V1];}function j1(i,j){var U1=O1.call(this);var V1=new i(j,{text:{path:"$field>/conditions",type:U1},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:x1.bind(this)});this._sBoundProperty="text";return[V1];}function k1(i,j){if(!this.getFieldHelp()){p1.call(this,"bool");}return d1.call(this,i,j);}function l1(i,j){I.call(this);this._bIsMeasure=true;var U1=O1.call(this);var V1=new i(j,{value:{path:"$field>/conditions",type:U1},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",change:t1.bind(this),liveChange:w1.bind(this)});U1=P1.call(this);var W1=new i(j+"-unit",{value:{path:"$field>/conditions",type:U1},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",width:"30%",tooltip:"{$field>/tooltip}",change:t1.bind(this),liveChange:w1.bind(this),valueHelpRequest:C1.bind(this)});J1.call(this,W1);this._sBoundProperty="value";return[V1,W1];}function m1(i,j){I.call(this);this._bIsMeasure=true;var U1=sap.ui.require("sap/m/Token");var V1=sap.ui.require("sap/m/Input");var W1=N1.call(this);var X1=new U1(j+"-token",{text:{path:'$field>',type:W1}});var Y1=new k({path:"values",test:function(a2){if(!Array.isArray(a2[0])||a2[0][0]){return true;}else{return false;}}});var Z1=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:X1,filters:[Y1]},dependents:[X1],change:t1.bind(this),liveChange:w1.bind(this),tokenUpdate:y1.bind(this)});var $1=P1.call(this);var _1=new V1(j+"-unit",{value:{path:"$field>/conditions",type:$1},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:N},enabled:{path:"$field>/editMode",formatter:P},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",width:"30%",tooltip:"{$field>/tooltip}",change:t1.bind(this),liveChange:w1.bind(this),valueHelpRequest:C1.bind(this)});J1.call(this,_1);this._sBoundProperty="value";return[Z1,_1];}function n1(i){if(i.onsapprevious){i._origOnsapprevious=i.onsapprevious;i.onsapprevious=function(j){var U1=A1.call(this);if(j.keyCode!==K.ARROW_UP&&(!U1||!U1.isOpen())){var i=this._getContent()[0];i._origOnsapprevious(j);}}.bind(this);}if(i.onsapnext){i._origOnsapnext=i.onsapnext;i.onsapnext=function(j){var U1=A1.call(this);if(j.keyCode!==K.ARROW_DOWN&&(!U1||!U1.isOpen())){var i=this._getContent()[0];i._origOnsapnext(j);}}.bind(this);}if(i.onsapup){i._origOnsapup=i.onsapup;i.onsapup=function(j){var U1=A1.call(this);if(!U1||!U1.isOpen()){var i=this._getContent()[0];i._origOnsapup(j);}}.bind(this);}if(i.onsapdown){i._origOnsapdown=i.onsapdown;i.onsapdown=function(j){var U1=A1.call(this);if(!U1||!U1.isOpen()){var i=this._getContent()[0];i._origOnsapdown(j);}}.bind(this);}if(i.onsapbackspace){i._origOnsapbackspace=i.onsapbackspace;i.onsapbackspace=function(j){var U1=A1.call(this);if(!U1||!U1.isOpen()){var i=this._getContent()[0];i._origOnsapbackspace(j);}}.bind(this);}}function o1(i){if(i._origOnsapprevious){i.onsapprevious=i._origOnsapprevious;delete i._origOnsapprevious;}if(i._origOnsapnext){i.onsapnext=i._origOnsapnext;delete i._origOnsapnext;}if(i._origOnsapup){i.onsapup=i._origOnsapup;delete i._origOnsapup;}if(i._origOnsapdown){i.onsapdown=i._origOnsapdown;delete i._origOnsapdown;}if(i._origOnsapbackspace){i.onsapbackspace=i._origOnsapbackspace;delete i._origOnsapbackspace;}}function p1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=v[i].id;var j=v[i].control;if(!j){if(v[i].promise){v[i].promise.then(q1.bind(this));}var U1=sap.ui.require(v[i].name);if(!U1&&!v[i].promise){v[i].promise=new Promise(function(V1){v[i].resolve=V1;sap.ui.require([v[i].name],function(W1){p1.call(this,i);}.bind(this));}.bind(this)).then(q1.bind(this));}if(U1){j=new U1(v[i].id);v[i].control=j;j.connect(this);if(v[i].resolve){v[i].resolve();delete v[i].resolve;}if(!v[i].promise){q1.call(this);}}}}function q1(){z1.call(this,"BoolDefaultHelp","insert");J1.call(this,this.getAggregation("_content",[])[0]);}function r1(i){this._bParseError=true;}function s1(U1){this._bParseError=true;var V1=U1.getParameter("newValue");var W1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var X1=this._aAsyncChanges[i];if(X1.waitForUpdate&&Array.isArray(X1.result)){for(var j=0;j<X1.result.length;j++){var Y1=X1.result[j];if(f(Y1.values[0],V1)||(Y1.operator==="BT"&&f(Y1.values[1],V1))){X1.reject(U1.getParameter("exception"));W1=true;break;}}if(W1){break;}}}if(W1){this._aAsyncChanges.splice(i,1);}}function t1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var U1=this._aAsyncChanges.length;if(U1>0&&!this._aAsyncChanges[U1-1].changeFired){this._aAsyncChanges[U1-1].changeFired=true;this._aAsyncChanges[U1-1].changeEvent=j;_.call(this,undefined,undefined,undefined,this._aAsyncChanges[U1-1].promise);return;}var V1={changeEvent:j};u1.call(this,V1);}function u1(i){var j=this.getConditions();var U1;var V1=true;var W1;var X1;var Y1=i.changeEvent.source;var Z1=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){V1=i.changeEvent.parameters["valid"];if(!V1&&i.changeEvent.parameters.hasOwnProperty("value")){W1=i.changeEvent.parameters["value"];}}var $1=false;var _1=this._sBoundProperty&&Y1.getBindingInfo(this._sBoundProperty);if(_1&&_1.binding&&_1.binding.sPath==="/conditions"&&V1){X1=j[0];U1=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){U1=i.changeEvent.parameters["value"];if(V1){$1=true;}}else if(i.changeEvent.parameters.hasOwnProperty("query")){U1=i.changeEvent.parameters["query"];$1=true;}else{X1=j[0];U1=j[0]&&j[0].values[0];}if($1){W.call(this);var a2;var b2;X1=S.resolve().then(function(){if(this._oNavigateCondition){V1=true;return this._oNavigateCondition;}else{a2=N1.call(this);var d2=a2.parseValue(U1);var e2=this._aAsyncChanges.length;if(e2>0&&!this._aAsyncChanges[e2-1].changeFired){b2=this._aAsyncChanges[e2-1];b2.changeFired=true;b2.changeEvent=i.changeEvent;_.call(this,undefined,undefined,undefined,b2.promise);}return d2;}}.bind(this)).then(function(X1){v1.call(this,X1,j,a2,V1,U1,Y1,b2||i);return X1;}.bind(this)).catch(function(d2){V1=false;W1=U1;U.call(this,d2.message);if(b2&&b2.reject){if(T1.call(this,b2)){b2.reject(d2);}}else if(Z1){_.call(this,j,V1,W1);}}.bind(this)).unwrap();if(X1 instanceof Promise){Z1=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){W1=i.changeEvent.parameters["value"];V1=false;}var c2=A1.call(this);if(c2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===Y1.getId()){c2.close();}c2.setFilterValue("");if(!Z1&&V1){B1.call(this,j,c2);c2.onFieldChange();}if(this.iLiveChangeTimer){clearTimeout(this.iLiveChangeTimer);}}if(this._oNavigateCondition){this._oNavigateCondition=undefined;M1.call(this);}if(i.resolve){S1.call(this,i);}else if(!Z1){_.call(this,j,V1,W1);}}function v1(i,j,U1,V1,W1,X1,Y1){if(U1){U1.validateValue(i);}var Z1=this.getMaxConditions();if(V1){if(i){if(this._bIsMeasure&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(C.indexOfCondition(i,j)>=0){throw new Error(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[W1]));}else{if(Z1>0&&Z1<=j.length){j.splice(0,j.length-Z1+1);}j.push(i);}}else if(Z1===1){j=[];}if(!f(j,this.getConditions())){this.setProperty("conditions",j,true);}if(Z1!==1){X1.setValue("");}}if(Y1.resolve){var $1=A1.call(this);if($1&&this._bConnected){B1.call(this,j,$1);$1.onFieldChange();}Y1.result=j;S1.call(this,Y1);T1.call(this,Y1);}}function w1(i){var j;var U1;var V1=false;var W1=i.getSource();this._oNavigateCondition=undefined;M1.call(this);if("value"in i.getParameters()){j=i.getParameter("value");}if("escPressed"in i.getParameters()){V1=i.getParameter("escPressed");}if("previousValue"in i.getParameters()){U1=i.getParameter("previousValue");}else{var X1=this.getConditions();U1=X1[0]&&X1[0].values[0];}var Y1=A1.call(this);if(Y1&&Y1.openByTyping()&&(!this._bIsMeasure||W1.getShowValueHelp())){var Z1;if(j[0]==="="&&j[1]==="="){Z1=j.slice(2);}else if(j[0]==="="){Z1=j.slice(1);}else{Z1=j;}var $1=this.getDisplay();if($1!==p.Value){var _1=this._getFilterOperatorConfig().getOperator("EEQ");var a2=_1.splitText(Z1,$1);Z1="";if(a2[0]){Z1=a2[0];if(a2[1]){Z1=Z1+" ";}}if(a2[1]){Z1=Z1+a2[1];}}if(this.iLiveChangeTimer){clearTimeout(this.iLiveChangeTimer);delete this.iLiveChangeTimer;}this.iLiveChangeTimer=setTimeout(function(){if(this._bConnected&&this._getContent()[0]&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){Y1.setFilterValue(Z1);if(Y1.getConditions().length>0){Y1.setConditions([]);}Y1.open(true);}}.bind(this),300);}this.fireLiveChange({value:j,escPressed:V1,previousValue:U1});}function x1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(U1){if(U1){window.location.href=U1;}else{j.open(this._getContent()[0]);}}.bind(this));}this.firePress();}function y1(j){if(j.getParameter("type")==="removed"){var U1=j.getParameter("removedTokens");var V1=this.getConditions();var W1;var i;for(i=0;i<U1.length;i++){var X1=U1[i];var Y1=X1.getBindingContext("$field").sPath;var Z1=parseInt(Y1.slice(Y1.lastIndexOf("/")+1));V1[Z1].delete=true;}for(i=V1.length-1;i>=0;i--){if(V1[i].delete){if(this._bIsMeasure){W1=V1[i].values[0][1];}V1.splice(i,1);}}if(this._bIsMeasure&&W1&&V1.length===0){V1=[C.createItemCondition([undefined,W1],undefined)];}this.setProperty("conditions",V1,true);_.call(this,V1,true);}}function z1(i,j){var U1=sap.ui.getCore().byId(i);if(j==="remove"){U1.detachEvent("select",D1,this);U1.detachEvent("navigate",E1,this);U1.detachEvent("dataUpdate",F1,this);U1.detachEvent("disconnect",G1,this);this.setProperty("_fieldHelpEnabled",false,true);}else if(j==="insert"){if(U1){U1.attachEvent("dataUpdate",F1,this);this.setProperty("_fieldHelpEnabled",true,true);}}J.call(this,this.getConditions());}function A1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}function B1(j,U1){if(!U1){U1=A1.call(this);}if(this._bIsMeasure){var V1=[];for(var i=0;i<j.length;i++){var W1=j[i];if(W1.values[0]&&W1.values[0][1]){var X1=C.createItemCondition(W1.values[0][1],undefined,W1.inParameters,W1.outParameters);V1.push(X1);}}U1.setConditions(V1);}else{U1.setConditions(j);}}function C1(i){var j=A1.call(this);if(j){j.setFilterValue("");var U1=this.getConditions();B1.call(this,U1,j);j.toggleOpen(false);}}function D1(j){var U1=this.getConditions();var V1=j.getParameter("conditions");var W1=j.getParameter("add");var X1=j.oSource;var Y1=this.getMaxConditions();var Z1=R.call(this);var $1;var _1=this.getControlForSuggestion();var a2;var i=0;if(this._bIsMeasure){if(V1.length>1){throw new Error("Only one item must be selected! "+this);}if(V1[0].operator!=="EEQ"){throw new Error("Only EEQ allowed! "+this);}if(U1.length>0){for(i=0;i<U1.length;i++){U1[i].values[0][1]=V1[0].values[0];if(U1[i].operator==="BT"){U1[i].values[1][1]=V1[0].values[0];}if(V1[0].inParameters){U1[i].inParameters=V1[0].inParameters;}if(V1[0].outParameters){U1[i].outParameters=V1[0].outParameters;}}}else{$1=m({},V1[0]);$1.values[0]=[undefined,$1.values[0]];$1.values[1]=undefined;U1.push($1);if(this._oConditionType){a2=this._oConditionType.formatValue($1);}else if(this._oConditionsType){a2=this._oConditionsType.formatValue(U1);}}}else{if(!W1){U1=[];}for(i=0;i<V1.length;i++){$1=V1[i];if(Z1&&$1.operator!=="EQ"&&$1.operator!=="EEQ"){continue;}if(!W1||C.indexOfCondition($1,U1)===-1){U1.push($1);}}}if(Y1>0&&Y1<U1.length){U1.splice(0,U1.length-Y1);}if(f(U1,this.getConditions())){if(_1&&_1.setDOMValue&&this.getMaxConditionsForHelp()===1&&U1.length>0){if(this._bIsMeasure&&this._oUnitConditionsType){a2=this._oUnitConditionsType.formatValue(U1);}else if(this._oConditionType){a2=this._oConditionType.formatValue(U1[0]);}else if(this._oConditionsType){a2=this._oConditionsType.formatValue(U1);}_1.setDOMValue(a2);}}else{if(_1&&_1.setDOMValue){if(Y1!==1){_1.setDOMValue("");}}this._oNavigateCondition=undefined;M1.call(this);this.setProperty("conditions",U1,true);X1.onFieldChange();_.call(this,U1,true);}}function E1(i){var j=i.getParameter("value");var U1=i.getParameter("key");var V1=i.getParameter("condition");var W1;var X1;var Y1=this.getControlForSuggestion();if(V1){this._oNavigateCondition=m({},V1);U1=V1.values[0];j=V1.values[1];}else{this._oNavigateCondition=C.createItemCondition(U1,j);}if(this._bIsMeasure){var Z1=this.getConditions();if(Z1.length>0){this._oNavigateCondition.operator=Z1[0].operator;this._oNavigateCondition.values[0]=[Z1[0].values[0][0],this._oNavigateCondition.values[0]];if(Z1[0].operator==="BT"){this._oNavigateCondition.values[1]=[Z1[0].values[1][0],this._oNavigateCondition.values[0][1]];}else{this._oNavigateCondition.values[1]=undefined;}}else{this._oNavigateCondition.values=[[undefined,this._oNavigateCondition.values[0]],undefined];}}M1.call(this);if(this.getDisplay()!==p.Value){W1=U1;}else if(j){W1=j;}else{W1=U1;}if(Y1&&Y1.setDOMValue){if(!X1){if(this._bIsMeasure&&this._oUnitConditionsType&&this._oNavigateCondition){X1=this._oUnitConditionsType.formatValue([this._oNavigateCondition]);}else if(this._oConditionType&&this._oNavigateCondition){X1=this._oConditionType.formatValue(this._oNavigateCondition);}else if(this._oConditionsType&&this._oNavigateCondition){X1=this._oConditionsType.formatValue([this._oNavigateCondition]);}else{X1=j||U1;}}Y1.setDOMValue(X1);Y1._doSelect();}this.fireLiveChange({value:W1});}function F1(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==p.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}function G1(i){var j=A1.call(this);j.detachEvent("select",D1,this);j.detachEvent("navigate",E1,this);j.detachEvent("disconnect",G1,this);this._bConnected=false;}function H1(){var i=A1.call(this);if(i&&!this._bConnected){i.connect(this);this._bConnected=true;i.attachEvent("select",D1,this);i.attachEvent("navigate",E1,this);i.attachEvent("disconnect",G1,this);var j=this.getConditions();B1.call(this,j,i);var U1=this.getControlForSuggestion();I1.call(this,U1);}}function I1(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var U1=A1.call(this.getParent());if(U1){var V1=sap.ui.getCore().byId(j.relatedControlId);if(V1&&h(U1.getDomRef(),V1.getFocusDomRef())){j.stopPropagation();return;}}this.orgOnsapfocusleave(j);};}}function J1(i){var j=A1.call(this);if(j&&i&&i.addEndIcon){var U1=j.getIcon();var V1=i.getAggregation("_endIcon",[])[0];if(V1){V1.setSrc(U1);}else{i.addEndIcon({id:i.getId()+"-vhi",src:U1,useIconTooltip:false,noTabStop:true,press:function(W1){if(!this.getValueHelpOnly()){var X1;if(D.support.touch){X1=this.$('inner');X1.attr('readonly','readonly');this.focus();X1.removeAttr('readonly');}else{this.focus();}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});}}.bind(i)});}}}function K1(i,j){if(j==="remove"){i.detachEvent("dataUpdate",L1,this);}else if(j==="insert"){i.attachEvent("dataUpdate",L1,this);L1.call(this);}}function L1(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(U1){j._bTriggerable=U1;if(j.getAggregation("_content")&&j.getEditMode()===E.Display){$.call(j);}});}s.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=R1.bind(this);}return{onlyEEQ:R.call(this),valueType:y.call(this),originalDateType:this._oDateOriginalType||this._oUnitOriginalType,display:this._bIsMeasure?p.Value:this.getDisplay(),fieldHelpID:this._bIsMeasure?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,filterOperatorConfig:this._getFilterOperatorConfig(),hideOperator:this._bHideOperator,maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition};};function M1(){if(this._oConditionType||this._oConditionsType){var i=this._getFormatOptions();if(this._oConditionType){this._oConditionType.setFormatOptions(i);}if(this._oConditionsType){this._oConditionsType.setFormatOptions(i);}if(this._oUnitConditionsType){i=Q1.call(this);this._oUnitConditionsType.setFormatOptions(i);}}}function N1(){if(!this._oConditionType){this._oConditionType=new b();M1.call(this);}return this._oConditionType;}function O1(){if(!this._oConditionsType){this._oConditionsType=new c();M1.call(this);}return this._oConditionsType;}s.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""){var j=y.call(this);var U1=j.parseValue(i,"string");if(U1===i){return true;}else{try{j.validateValue(U1);}catch(V1){return true;}}}else{var W1=z.call(this);if((W1==="sap.ui.model.odata.type.Unit"||W1==="sap.ui.model.odata.type.Currency"||W1==="sap.ui.model.type.Unit"||W1==="sap.ui.model.type.Currency")&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};function P1(){if(!this._oUnitConditionsType){var i=Q1.call(this);this._oUnitConditionsType=new c(i);}return this._oUnitConditionsType;}function Q1(){if(!this._asyncParsingCall){this._asyncParsingCall=R1.bind(this);}return{onlyEEQ:true,valueType:undefined,originalDateType:y.call(this),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,filterOperatorConfig:this._getFilterOperatorConfig(),hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,isUnit:true,getConditions:this.getConditions.bind(this)};}function R1(i){var j=A1.call(this);if(j&&j.isOpen()){var U1=document.activeElement;if(U1&&(h(this.getDomRef(),U1)||h(j.getDomRef(),U1))){j.close();}}var V1={};var W1=new Promise(function(X1,Y1){V1.resolve=X1;V1.reject=Y1;i.then(function(Z1){V1.result=Z1;var $1=this.getConditions();if(f(Z1,$1)){S1.call(this,V1);T1.call(this,V1);}else{V1.waitForUpdate=true;}}.bind(this)).catch(function(Z1){this._bParseError=true;Y1(Z1);T1.call(this,V1);}.bind(this));}.bind(this));V1.promise=W1;this._aAsyncChanges.push(V1);}s.prototype._getResultForPromise=function(i){return i;};function S1(i){i.resolve(this._getResultForPromise(i.result));}function T1(j){var U1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){U1=true;break;}}if(U1){this._aAsyncChanges.splice(i,1);}return U1;}return s;},true);
