/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/core/XMLComposite','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/base/ManagedObjectObserver','sap/base/Log','sap/ui/Device','sap/ui/model/json/JSONModel','sap/m/MessageBox'],function(X,F,c,M,L,D,J,d){"use strict";var A=X.extend("sap.ui.mdc.base.filterbar.AdaptFiltersDialog",{metadata:{library:"sap.ui.mdc",properties:{showReset:{type:"boolean",defaultValue:false,invalidate:true},showResetEnabled:{type:"boolean",defaultValue:false,invalidate:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.base.filterbar.AdaptFiltersDialogItem",multiple:true,singularName:"item"}},events:{visibilityChanged:{key:{type:"string"},visible:{type:"boolean"}},positionChanged:{key:{type:"string"},relativePosition:{type:"integer"}},ok:{},cancel:{},reset:{}}}});A.prototype.init=function(){var o=new J(D);o.setDefaultBindingMode("OneWay");this.setModel(o,"device");this._sKeyOfMarkedItem=null;};A.prototype.open=function(){this.initialize();this._getCompositeAggregation().open();};A.prototype.initialize=function(){this._removeMarkedStyleFromTableItem(this._getMarkedTableItem());this._updateCountOfItems();this._initVisualIndex();this._sortTableItemsByVisualIndex();this._updateTableItems();var t=this._getVisibleTableItems()[0];this._toggleMarkedTableItem(t);this._updateEnableOfMoveButtons(t);};A.prototype.close=function(){this._getCompositeAggregation().close();};A.prototype.onSelectionChange=function(e){e.getParameter("listItems").forEach(function(t){this._selectTableItem(t);},this);};A.prototype.onItemPressed=function(e){var t=e.getParameter('listItem');this._toggleMarkedTableItem(t);this._updateEnableOfMoveButtons(t);};A.prototype.onSearchFieldLiveChange=function(e){var s=e.getSource();this._filterTableItemsByText(s?s.getValue():"");};A.prototype.onSwitchButtonShowSelected=function(){this._filterTableItemsByText(this._getSearchText());};A.prototype.onPressButtonMoveToTop=function(){this._moveTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};A.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};A.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};A.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveTableItem(this._getMarkedTableItem(),v[v.length-1]);};A.prototype.onPressOk=function(){this.fireOk();};A.prototype.onPressCancel=function(){this.fireCancel();};A.prototype.onPressReset=function(){this.fireReset();};A.prototype.onAfterClose=function(){this.fireCancel();};A.prototype._selectTableItem=function(t){this._toggleMarkedTableItem(t);this._updateEnableOfMoveButtons(t);this._updateCountOfItems();this.fireVisibilityChanged({key:this._getKeyByTableItem(t),visible:t.getSelected()});var r=this._getRelativePositionOf(t);if(r>0){this.firePositionChanged({key:this._getKeyByTableItem(t),relativePosition:r});}};A.prototype._moveTableItem=function(t,T){this._removeMarkedStyleFromTableItem(this._getMarkedTableItem());var i=this._getItemByKey(this._getKeyByTableItem(t));var I=this._getItemByKey(this._getKeyByTableItem(T));i.visualIndex=I.visualIndex+(i.visualIndex<I.visualIndex?1:-1);var r=this._getRelativePositionOf(t);this._sortTableItemsByVisualIndex();var s=this._getSelectedTableItems();this._getTable().getItems().forEach(function(a,b){var o=this._getItemByKey(this._getKeyByTableItem(a));o.visualIndex=b;o.setRelativePosition(s.indexOf(a));a.insertCell(o.getControls()[0].clone(),1);}.bind(this));this._toggleMarkedTableItem(this._getMarkedTableItem());this._updateEnableOfMoveButtons(this._getMarkedTableItem());var k=this._getKeyByTableItem(T);var o=this._getItemByKey(k);if(r!==o.getRelativePosition()&&o.getRelativePosition()>-1){this.firePositionChanged({key:k,relativePosition:o.getRelativePosition()});}};A.prototype._initVisualIndex=function(){var i=this.getItems().filter(function(o){return o.getVisible();}).sort(function(a,b){return a.getRelativePosition()-b.getRelativePosition();});i.forEach(function(o,a){o.visualIndex=a;});var I=this.getItems().filter(function(o){return!o.getVisible();}).sort(function(a,b){if(a.getText()<b.getText()){return-1;}else if(a.getText()>b.getText()){return 1;}else{return 0;}});var e=i.length;I.forEach(function(o,a){o.visualIndex=a+e;});};A.prototype._sortTableItemsByVisualIndex=function(){this._getTableBinding().sort(new sap.ui.model.Sorter({path:'',descending:false,group:false,comparator:function(a,b){return a.visualIndex-b.visualIndex;}}));};A.prototype._updateTableItems=function(){this._getTable().getItems().forEach(function(t){var i=this._getItemByKey(this._getKeyByTableItem(t));t.insertCell(i.getControls()[0].clone(),1);}.bind(this));};A.prototype._isFilteredByShowSelected=function(){return sap.ui.getCore().byId(this.getId()+"--idShowSelected").getPressed();};A.prototype._getSearchText=function(){var s=sap.ui.getCore().byId(this.getId()+"--idSearchField")||null;return s?s.getValue():"";};A.prototype._getTable=function(){return sap.ui.getCore().byId(this.getId()+"--idList")||null;};A.prototype._getTableBinding=function(){return this._getTable().getBinding("items");};A.prototype._getTableBindingContext=function(){return this._getTableBinding().getContexts();};A.prototype._setMarkedTableItem=function(t){this._sKeyOfMarkedItem=this._getKeyByTableItem(t);};A.prototype._getMarkedTableItem=function(){return this._getTableItemByKey(this._sKeyOfMarkedItem);};A.prototype._getVisibleTableItems=function(){return this._getTable().getItems().filter(function(t){return!!t.getVisible();});};A.prototype._getSelectedTableItems=function(){return this._getTable().getItems().filter(function(t){return!!t.getSelected();});};A.prototype._getTableItemByKey=function(k){var C=this._getTableBindingContext();var t=this._getTable().getItems().filter(function(T,i){return C[i].getObject().getKey()===k;});return t[0];};A.prototype._getKeyByTableItem=function(t){var i=this._getTable().indexOfItem(t);return i<0?null:this._getTableBindingContext()[i].getObject().getKey();};A.prototype._getItemByKey=function(k){var i=this.getItems().filter(function(I){return I.getKey()===k;});return i[0];};A.prototype._filterTableItemsByText=function(s){this._removeMarkedStyleFromTableItem(this._getMarkedTableItem());var f=[];if(this._isFilteredByShowSelected()===true){f.push(new sap.ui.model.Filter("visible","EQ",true));}if(s){f.push(new F([new F("text",c.Contains,s),new F("tooltip",c.Contains,s)],false));}this._getTableBinding().filter(f);this._sortTableItemsByVisualIndex();this._updateTableItems();this._toggleMarkedTableItem(this._getMarkedTableItem());this._updateEnableOfMoveButtons(this._getMarkedTableItem());};A.prototype._toggleMarkedTableItem=function(t){this._removeMarkedStyleFromTableItem(this._getMarkedTableItem());var k=this._getKeyByTableItem(t);if(k){this._setMarkedTableItem(t);this._addMarkedStyleToTableItem(t);}};A.prototype._addMarkedStyleToTableItem=function(t){if(t){t.addStyleClass("sapUiMdcBaseFilterBarAdaptFiltersDialogMarked");}};A.prototype._removeMarkedStyleFromTableItem=function(t){if(t){t.removeStyleClass("sapUiMdcBaseFilterBarAdaptFiltersDialogMarked");}};A.prototype._updateCountOfItems=function(){this._getManagedObjectModel().setProperty("/@custom/countOfSelectedItems",this._getSelectedTableItems().length);};A.prototype._updateEnableOfMoveButtons=function(t){var v=this._getVisibleTableItems();this._getManagedObjectModel().setProperty("/@custom/isMoveUpButtonEnabled",v.indexOf(t)>0);this._getManagedObjectModel().setProperty("/@custom/isMoveDownButtonEnabled",v.indexOf(t)>-1&&v.indexOf(t)<v.length-1);};A.prototype._getRelativePositionOf=function(t){return this._getSelectedTableItems().indexOf(t);};A._getItemByKey=function(k,a){return a.filter(function(m){return m.key===k;})[0];};return A;},true);
