/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/BindingMode','sap/ui/model/Model','./ResourcePropertyBinding',"sap/base/i18n/ResourceBundle","sap/base/Log"],function(B,M,R,a,L){"use strict";var b=M.extend("sap.ui.model.resource.ResourceModel",{constructor:function(d){M.apply(this,arguments);this.aCustomBundles=[];this.bReenhance=false;this.bAsync=!!(d&&d.async);this.sDefaultBindingMode=d.defaultBindingMode||B.OneWay;this.mSupportedBindingModes={"OneWay":true,"TwoWay":false,"OneTime":!this.bAsync};if(this.bAsync&&this.sDefaultBindingMode==B.OneTime){L.warning("Using binding mode OneTime for asynchronous ResourceModel is not supported!");}this.oData=d;if(d&&d.bundle){this._oResourceBundle=d.bundle;}else if(d&&(d.bundleUrl||d.bundleName)){_(this);}else{throw new Error("At least bundle, bundleName or bundleUrl must be provided!");}if(d&&Array.isArray(d.enhanceWith)&&d.enhanceWith.length>0){if(this.bAsync){this._pEnhanced=d.enhanceWith.reduce(function(e,f){return e.then(this.enhance.bind(this,f));}.bind(this),Promise.resolve());}else{d.enhanceWith.forEach(this.enhance.bind(this));}}},metadata:{publicMethods:["getResourceBundle"]}});b.loadResourceBundle=function(d,A){var C=sap.ui.getCore().getConfiguration(),r,u,l,i;l=d.bundleLocale;if(!l){l=C.getLanguage();}i=C.getOriginInfo();u=c(d.bundleUrl,d.bundleName);r=a.create({url:u,locale:l,includeInfo:i,async:A});return r;};b.prototype.enhance=function(d){var t=this,r,p=this.bAsync?new Promise(function(f){r=f;}):null;function e(){if(d instanceof a){t._oResourceBundle._enhance(d);t.checkUpdate(true);if(p){r(true);}}else{var f=b.loadResourceBundle(d,t.bAsync);if(f instanceof Promise){f.then(function(g){t._oResourceBundle._enhance(g);t.checkUpdate(true);r(true);},function(){r(true);});}else if(f){t._oResourceBundle._enhance(f);t.checkUpdate(true);}}}if(this._oPromise){Promise.resolve(this._oPromise).then(e);}else{e();}if(!this.bReenhance){this.aCustomBundles.push(d);}return p;};b.prototype.bindProperty=function(p){var o=new R(this,p);return o;};b.prototype.getProperty=function(p){return this._oResourceBundle?this._oResourceBundle.getText(p):null;};b.prototype.getResourceBundle=function(){if(!this.bAsync){return this._oResourceBundle;}else{var p=this._oPromise;if(p){return new Promise(function(r,d){function e(o){r(o);}p.then(e,e);});}else{return Promise.resolve(this._oResourceBundle);}}};b.prototype._handleLocalizationChange=function(){_(this);};b.prototype._reenhance=function(){this.bReenhance=true;this.aCustomBundles.forEach(function(d){this.enhance(d);}.bind(this));this.bReenhance=false;};function _(m){var d=m.oData;if(d&&(d.bundleUrl||d.bundleName)){var r=b.loadResourceBundle(d,d.async);if(r instanceof Promise){var e={url:c(d.bundleUrl,d.bundleName),async:true};m.fireRequestSent(e);m._oPromise=r;m._oPromise.then(function(o){m._oResourceBundle=o;m._reenhance();delete m._oPromise;m.checkUpdate(true);m.fireRequestCompleted(e);});}else{m._oResourceBundle=r;m._reenhance();m.checkUpdate(true);}}}function c(d,e){var u=d;if(e){if(/^\/|^\./.test(e)){L.error('Incorrect resource bundle name "'+e+'"','Leading slashes or dots in resource bundle names are ignored, since such names are invalid UI5 module names. Please check whether the resource model "'+e+'" is actually needed by your application.',"sap.ui.model.resource.ResourceModel");e=e.replace(/^(?:\/|\.)*/,"");}e=e.replace(/\./g,"/");u=sap.ui.require.toUrl(e)+".properties";}return u;}return b;});
