/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment"],function(C,D,L,a,U,l,I,b,R,c,d,e,q,f){"use strict";var g=l.CalendarDayType;var h=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var m=l.CalendarIntervalType;var n=l.CalendarAppointmentHeight;var o=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:m.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:h.Standard},appointmentHeight:{type:"string",group:"Appearance",defaultValue:n.Regular,visibility:"hidden"}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});o.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};o.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};o.prototype.onBeforeRendering=function(){t.call(this);w.call(this);A.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(!this.getAppointments().length){this.aSelectedAppointments=[];}else{this.getAppointments().forEach(function(i){this._updateSelectedAppointmentsArray(i);}.bind(this));}};o.prototype.onAfterRendering=function(){B.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};o.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};o.prototype.invalidate=function(j){if(j&&j instanceof f){var k=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==j){k=true;break;}}if(k){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(j);}C.prototype.invalidate.apply(this,arguments);};o.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};o.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};o.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};o.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};o.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};o.prototype._getAppointmentReducedHeight=function(i){var j=!D.system.phone&&this.getAppointmentsReducedHeight()&&i.size===n.Regular;return j;};o.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){K.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var p;for(var i=0;i<V.length;i++){p=V[i].appointment;if(e(p.getDomRef(),j.target)){k=true;p.focus();break;}}if(!k){p=this.getFocusedAppointment();if(p){p.focus();}}}};o.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};o.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){M.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};o.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){M.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};o.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};o.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};o.prototype.onsaphome=function(i){N.call(this,i);i.preventDefault();i.stopPropagation();};o.prototype.onsapend=function(i){N.call(this,i);i.preventDefault();i.stopPropagation();};o.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){E.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};o.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var p=false;for(k=0;k<j.length;k++){var Q=j[k];if(!this._isOneMonthsRowOnSmallSizes()&&e(Q,i.target)){p=true;break;}}if(p){O.call(this,k,i.target);}else{this.onsapselect(i);}};o.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};o.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");B.call(this);return this;};o.prototype.updateCurrentTimeVisualization=function(){var $=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var p=S.getTime();var Q=this._oUTCEndDate;var T=Q.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=T&&i.getTime()>=p){var V=y.call(this,k,j,S,Q,p,i);var W=0;if(this._bRTL){$.css("right",V+"%");}else{$.css("left",V+"%");}$.css("display","");if(this.getUpdateCurrentTime()){switch(k){case m.Hour:W=60000;break;case m.Day:case m.Week:case m.OneMonth:W=1800000;break;default:W=-1;break;}if(W>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),W);}}}else{$.css("display","none");}return this;};o.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var p;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){p=k[i];break;}}if(!p){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){p=j[i];break;}}}return p;};o.prototype.focusAppointment=function(i){if(!i||!(i instanceof f)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){K.call(this,j);}else{i.focus();}return this;};o.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var p;var Q;var S;for(var i=0;i<k.length;i++){p=k[i];if(p.getStartDate()>j){if(i>0){Q=k[i-1];}else{Q=p;}break;}}if(p){if(Q&&Math.abs(p.getStartDate()-j)>=Math.abs(Q.getStartDate()-j)){S=Q;}else{S=p;}this.focusAppointment(S);}return this;};o.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};o.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};o.prototype._getNonWorkingDays=function(){var j=this.getNonWorkingDays();if(!j){var k=s.call(this);var W=k.getWeekendStart();var p=k.getWeekendEnd();j=[];for(var i=0;i<=6;i++){if((W<=p&&i>=W&&i<=p)||(W>p&&(i>=W||i<=p))){j.push(i);}}}else if(!Array.isArray(j)){j=[];}return j;};o.prototype._isOneMonthsRowOnSmallSizes=function(){return this.getIntervalType()===m.OneMonth&&this.getIntervals()===1;};o.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=P;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};o.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};o.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),p=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),Q=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),S=this.getIntervalType(),T=this.getStartDate(),V=S==="Hour"?new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()):new U(T.getFullYear(),T.getMonth(),T.getDate()),W=this.getIntervals(),X;switch(S){case"Hour":X=new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()+W);break;case"Day":case"Week":case"One Month":X=new U(T.getFullYear(),T.getMonth(),T.getDate()+W);break;case"Month":X=new U(T.getFullYear(),T.getMonth()+W,T.getDate());break;default:break;}return{appTimeUnitsDifRowStart:V.getTime()-p.getTime(),appTimeUnitsDifRowEnd:Q.getTime()-X.getTime()};};o.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};function _(j,k){var p=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<p.length;++i){if(k===p[i]){return true;}}return false;}function r(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function s(){if(!this._oLocaleData){var i=r.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function t(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=u.call(this,S);switch(k){case m.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case m.Day:case m.Week:case m.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case m.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}function u(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case m.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Day:case m.Week:case m.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function v(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function w(){var p=this._getAppointmentsSorted();var Q;var S;var T;var V=this.getIntervals();var W=this.getIntervalType();var X=this._getStartDate();var Y=X.getTime();var Z=this._oUTCEndDate;var $=Z.getTime();var a1=[];var b1=false;var i=0;var j=0;var c1=v.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<p.length;i++){Q=p[i];var d1=a._createUniversalUTCDate(Q.getStartDate(),undefined,true);var e1=d1.getTime();d1.setUTCSeconds(0);d1.setUTCMilliseconds(0);var f1=Q.getEndDate()?a._createUniversalUTCDate(Q.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);var g1=f1.getTime();f1.setUTCSeconds(0);f1.setUTCMilliseconds(0);var h1=false;if(d1.getTime()<Y&&f1.getTime()>=Y){d1=new U(Y);h1=true;}if(f1.getTime()>$&&d1.getTime()<=$){f1=new U($);h1=true;}var i1=d1.getUTCHours()*60+d1.getUTCMinutes();d1.setUTCMinutes(d1.getUTCMinutes()-(i1%this._iMinDelta));var j1=(f1.getTime()-d1.getTime())/60000;if(h1&&j1==0){continue;}var k1=0;var l1=0;var m1=-1;S=undefined;T=undefined;if(d1&&d1.getTime()<=$&&f1&&f1.getTime()>=Y&&e1<=g1){if(c1&&(W==m.Month)&&((f1.getTime()-d1.getTime())<604800000)){S=x.call(this,d1,Q,W,V,X,Z,Y,a1);var n1=a._createUniversalUTCDate(S.getEndDate(),undefined,true);if(f1.getTime()>n1.getTime()){T=x.call(this,f1,Q,W,V,X,Z,Y,a1);}}k1=y.call(this,W,V,X,Z,Y,d1);l1=z.call(this,W,V,X,Z,Y,f1);if(S){S._iBegin=k1;S._iEnd=l1;S._iLevel=m1;if(T){T._iBegin=k1;T._iEnd=l1;T._iLevel=m1;}continue;}a1.push({appointment:Q,begin:k1,end:l1,calculatedEnd:l1,level:m1,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==Q.getId()){b1=true;}}}var o1=this.getAggregation("groupAppointments",[]);if(o1.length>0){for(i=0;i<a1.length;i++){Q=a1[i];if(Q.appointment._aAppointments&&Q.appointment._aAppointments.length<=1){S=Q.appointment;var p1=false;if(S._aAppointments.length==0){p1=true;}else{for(j=0;j<a1.length;j++){if(a1[j].appointment==S._aAppointments[0]){p1=true;break;}}}if(!p1){for(j=0;j<o1.length;j++){T=o1[j];if(S!=T){for(var k=0;k<T._aAppointments.length;k++){if(S._aAppointments[0]==T._aAppointments[k]){T._aAppointments.splice(k,1);if(T._aAppointments.length==1){this.removeAggregation("groupAppointments",T);T.destroy();o1=this.getAggregation("groupAppointments",[]);}else{T.setProperty("title",T._aAppointments.length,true);}break;}}}}Q.begin=S._iBegin;Q.end=S._iEnd;Q.calculatedEnd=S._iEnd;Q.level=S._iLevel;Q.appointment=S._aAppointments[0];}else{a1.splice(i,1);i--;}this.removeAggregation("groupAppointments",S);S.destroy();o1=this.getAggregation("groupAppointments",[]);}}}if(!b1){if(a1.length>0){this._sFocusedAppointmentId=a1[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=a1;return this._aVisibleAppointments;}function x(i,k,p,Q,S,T,V,W){var X=this.getAggregation("groupAppointments",[]);var Y;var Z=s.call(this);var $=Z.getFirstDayOfWeek();var a1=i.getUTCDay();var b1=new U(i.getTime());b1.setUTCHours(0);b1.setUTCMinutes(0);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);if($<=a1){b1.setDate(b1.getDate()-(a1-$));}else{b1.setDate(b1.getDate()-(7-a1-$));}for(var j=0;j<X.length;j++){Y=X[j];var c1=a._createUniversalUTCDate(Y.getStartDate(),undefined,true);if(c1.getTime()==b1.getTime()){break;}Y=undefined;}if(!Y){var d1=new U(b1.getTime());d1.setDate(d1.getDate()+7);d1.setMilliseconds(-1);Y=new f(this.getId()+"-Group"+X.length,{type:k.getType(),startDate:a._createLocalDate(new Date(b1.getTime()),true),endDate:a._createLocalDate(new Date(d1.getTime()),true)});Y._aAppointments=[];this.addAggregation("groupAppointments",Y,true);var e1=y.call(this,p,Q,S,T,V,b1);var f1=z.call(this,p,Q,S,T,V,d1);W.push({appointment:Y,begin:e1,end:f1,calculatedEnd:f1,level:-1});}Y._aAppointments.push(k);if(Y.getType()!=g.None&&Y.getType()!=k.getType()){Y.setType(g.None);}Y.setProperty("title",Y._aAppointments.length,true);return Y;}function y(i,j,S,k,p,Q){var T=0;if(i!=m.Month){T=100*(Q.getTime()-p)/this._iRowSize;}else{var V=new U(Q.getTime());V.setUTCDate(1);V.setUTCHours(0);V.setUTCMinutes(0);V.setUTCSeconds(0);V.setUTCMilliseconds(0);var W=new U(V.getTime());W.setUTCMonth(W.getUTCMonth()+1);W.setMilliseconds(-1);var X=W.getTime()-V.getTime();var Y=(V.getUTCFullYear()-S.getUTCFullYear())*12+V.getUTCMonth()-S.getUTCMonth();T=(100*Y/j)+(100*(Q.getTime()-V.getTime())/X)/j;}if(T<0){T=0;}T=Math.round(T*100000)/100000;return T;}function z(i,j,S,k,p,Q){var T=0;if(i!=m.Month){T=100-(100*(Q.getTime()-p)/this._iRowSize);}else{var V=new U(Q.getTime());V.setUTCDate(1);V.setUTCHours(0);V.setUTCMinutes(0);V.setUTCSeconds(0);V.setUTCMilliseconds(0);var W=new U(V.getTime());W.setUTCMonth(W.getUTCMonth()+1);W.setMilliseconds(-1);var X=W.getTime()-V.getTime();var Y=(V.getUTCFullYear()-S.getUTCFullYear())*12+V.getUTCMonth()-S.getUTCMonth();T=100-((100*Y/j)+(100*(Q.getTime()-V.getTime())/X)/j);}if(T<0){T=0;}T=Math.round(T*100000)/100000;return T;}function A(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var p;var Q=this.getIntervals();var S=this.getIntervalType();var T=this._getStartDate();var W=T.getTime();var X=this._oUTCEndDate;var Y=X.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){p=k[i];var Z=a._createUniversalUTCDate(p.getStartDate(),undefined,true);Z.setUTCSeconds(0);Z.setUTCMilliseconds(0);var $=p.getEndDate()?a._createUniversalUTCDate(p.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);$.setUTCSeconds(0);$.setUTCMilliseconds(0);if(Z&&Z.getTime()<=Y&&$&&$.getTime()>=W){var a1=new U(T.getTime());var b1=new U(T.getTime());b1.setUTCMinutes(b1.getUTCMinutes()-1);var c1=-1;var d1=-1;for(j=0;j<Q;j++){switch(S){case m.Hour:b1.setUTCHours(b1.getUTCHours()+1);if(j>0){a1.setUTCHours(a1.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:b1.setUTCDate(b1.getUTCDate()+1);if(j>0){a1.setUTCDate(a1.getUTCDate()+1);}break;case m.Month:b1.setUTCDate(1);b1.setUTCMonth(b1.getUTCMonth()+2);b1.setUTCDate(0);if(j>0){a1.setUTCMonth(a1.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+S+"; "+this);}if(Z&&Z.getTime()<=a1.getTime()&&$&&$.getTime()>=b1.getTime()){if(c1<0){c1=j;}d1=j;}}if(c1>=0){V.push({interval:c1,appointment:p,last:d1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function B(){if(this._isOneMonthsRowOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var p=this.$("DummyApp");var Q=p.outerHeight(true);if(Q<=0){return;}var S=p.outerWidth();var T=S/k*100;var V=Math.ceil(1000*T)/1000;var W;var X;var Y=0;var Z=0;var i=0;if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){Y=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){W=this._aVisibleAppointments[i];X=W.appointment.$();var a1=Math.floor(1000*(100-W.calculatedEnd-W.begin))/1000;var b1=false;if(a1<V){W.end=100-W.begin-T;if(W.end<0){W.end=0;}W.level=-1;b1=true;X.addClass("sapUiCalendarAppSmall");}else if(X.hasClass("sapUiCalendarAppSmall")){W.end=W.calculatedEnd;b1=true;X.removeClass("sapUiCalendarAppSmall");}if(b1){if(this._bRTL){X.css("left",W.end+"%");}else{X.css("right",W.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){W=this._aVisibleAppointments[i];X=W.appointment.$();var c1={};if(W.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var d1=this._aVisibleAppointments[j];if(W!=d1&&W.begin<(Math.floor(1000*(100-d1.end))/1000)&&(Math.floor(1000*(100-W.end))/1000)>d1.begin&&d1.level>=0){this._setBlockedLevelsForAppointment(d1,c1);}}W.level=this._getAppointmetLevel(c1,W);X.attr("data-sap-level",W.level);}X.css("top",(Q*W.level+Y)+"px");var e1=W.level;e1+=this._getAppointmentRowCount(W)-1;if(Z<e1){Z=e1;}}Z++;Q=Q*Z+Y;if(!this.getHeight()){$.outerHeight(Q);}else{var f1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<f1.length;i++){var g1=q(f1[i]);g1.outerHeight(Q);}}p.css("display","none");}o.prototype._setBlockedLevelsForAppointment=function(V,i){var j=this._getAppointmentRowCount(V);for(var k=0;k<j;k++){i[V.level+k]=true;}return i;};o.prototype._getAppointmentRowCount=function(V){var i,j=this._getAppointmentReducedHeight(V);switch(V.size){case n.HalfSize:i=1;break;case n.Regular:i=2;if(j&&!V.appointment.getText()&&!V.appointment.getProperty("description")){i=1;}break;case n.Large:i=3;break;case n.Automatic:i=1;if(V.appointment.getText()){i+=1;}if(V.appointment.getProperty("description")){i+=1;}break;}return i;};o.prototype._getAppointmetLevel=function(i,j){var k=0;var p=this._getAppointmentRowCount(j);var Q=true;while(Q){Q=this._isPosibleToPositionAppointment(k,i,p);if(!Q){Q=true;k+=1;}else{Q=false;}}return k;};o.prototype._isPosibleToPositionAppointment=function(i,j,k){for(var p=i;p<k+i;p++){if(j[p]){return false;}}return true;};function E(j,k){var i=0;var p;var Q;var S;var T;var V=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var W=this.getAppointments();var X=this.getAggregation("groupAppointments",[]);q.merge(W,X);for(i=0;i<W.length;i++){p=W[i];if(p.getId()!==j.getId()&&p.getSelected()){p.setProperty("selected",false,true);p.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==p.getId()){this.aSelectedAppointments.splice(i);}}Q=p.$().attr("aria-labelledby");S=Q?Q.replace(V,""):"";p.$().attr("aria-labelledby",S);}}}T=j.$().attr("aria-labelledby")+" "+V;S=j.$().attr("aria-labelledby").replace(V,"").trim();if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",S);H(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",T);H(this,k);}this._updateSelectedAppointmentsArray(j);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){p=j._aAppointments[i];p.setProperty("selected",true,true);T=p.$().attr("aria-labelledby")+" "+V;p.$().attr("aria-labelledby",T);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function F(i){var p=this._getPlanningCalendar();if(p){p["_onRow"+i]();}}o.prototype._getPlanningCalendar=function(){var p=this;while(p.getParent()!==null){if(p.getMetadata().getName()==="sap.m.PlanningCalendar"){return p;}p=p.getParent();}};function H(i,j){if(j){F.call(i,"DeselectAppointment");}}function J(k){var p=this.getAggregation("groupAppointments",[]);var Q;var S=false;for(var i=0;i<p.length;i++){var T=p[i]._aAppointments;for(var j=0;j<T.length;j++){if(T[j].getId()==k){Q=p[i];S=true;break;}}if(S){break;}}return Q;}function K(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var p;var i=0;p=J.call(this,j);if(p){j=p.getId();p=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){p=V[i].appointment;break;}}if(p){var $=this.getFocusedAppointment().$();var Q=p.$();this._sFocusedAppointmentId=p.getId();$.attr("tabindex","-1");Q.attr("tabindex","0");Q.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){p=k[i];break;}}if(p){this._sFocusedAppointmentId=p.getId();var S=u.call(this,p.getStartDate());this.setStartDate(a._createLocalDate(S,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}function M(j,S){var k=this._sFocusedAppointmentId;var p=this._getAppointmentsSorted();var Q=this.getAggregation("groupAppointments",[]);var T;var V=0;var i=0;for(i=0;i<Q.length;i++){if(Q[i].getId()==k){var W=Q[i]._aAppointments;if(j){k=W[W.length-1].getId();}else{k=W[0].getId();}break;}}for(i=0;i<p.length;i++){if(p[i].getId()==k){V=i;break;}}if(j){V=V+S;}else{V=V-S;}if(V<0){V=0;}else if(V>=p.length){V=p.length-1;}T=p[V];K.call(this,T.getId());}function N(j){var k=this._getAppointmentsSorted();var p;var S=new U(this._getStartDate());var Q=new U(this._oUTCEndDate);var T=this.getIntervalType();var V;var W;S.setUTCHours(0);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);switch(T){case m.Hour:Q.setUTCDate(Q.getUTCDate()+1);Q.setUTCMilliseconds(-1);break;case m.Day:case m.Week:case m.OneMonth:S.setUTCDate(1);Q.setUTCMonth(Q.getUTCMonth()+1);Q.setUTCDate(1);Q.setUTCMilliseconds(-1);break;case m.Month:S.setUTCMonth(0);S.setUTCDate(1);Q.setUTCFullYear(Q.getUTCFullYear()+1);Q.setUTCMonth(1);Q.setUTCDate(1);Q.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+T+"; "+this);}var X=a._createLocalDate(S,true);var Y=a._createLocalDate(Q,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=X&&k[i].getStartDate()<=Y){p=k[i];V=p.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>Y){break;}}W=J.call(this,V);if(W){p=W;V=p.getId();}if(V&&V!=this._sFocusedAppointmentId){K.call(this,V);}else if(j._bPlanningCalendar&&p){p.focus();}else{this.fireLeaveRow({type:j.type});}}function O(i,j){var k=this.getIntervalType();var S=this._getStartDate();var p=new U(S.getTime());var Q;var T=false;var V=0;var W=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){T=true;var X=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");W=X.length;for(V=0;V<W;V++){var Y=X[V];if(Y==j){break;}}}switch(k){case m.Hour:p.setUTCHours(p.getUTCHours()+i);if(T){p.setUTCMinutes(p.getUTCMinutes()+V*60/W);Q=new U(p.getTime());Q.setUTCMinutes(Q.getUTCMinutes()+60/W);}else{Q=new U(p.getTime());Q.setUTCHours(Q.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:p.setUTCDate(p.getUTCDate()+i);if(T){p.setUTCHours(p.getUTCHours()+V*24/W);Q=new U(p.getTime());Q.setUTCHours(Q.getUTCHours()+24/W);}else{Q=new U(p.getTime());Q.setUTCDate(Q.getUTCDate()+1);}break;case m.Month:p.setUTCMonth(p.getUTCMonth()+i);if(T){p.setUTCDate(p.getUTCDate()+V);Q=new U(p.getTime());Q.setUTCDate(Q.getUTCDate()+1);}else{Q=new U(p.getTime());Q.setUTCMonth(Q.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}Q.setUTCMilliseconds(Q.getUTCMilliseconds()-1);p=a._createLocalDate(p,true);Q=a._createLocalDate(Q,true);this.fireIntervalSelect({startDate:p,endDate:Q,subInterval:T});}function P(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}return o;});
