/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library','./NavigationBarRenderer','sap/ui/commons/Menu','sap/ui/commons/MenuItem','sap/ui/core/Popup','sap/ui/events/jquery/EventSimulation','sap/ui/dom/denormalizeScrollLeftRTL','sap/ui/util/ActivityDetection','sap/ui/Device','sap/base/assert','sap/ui/dom/jquery/scrollRightRTL','sap/ui/dom/jquery/scrollLeftRTL'],function(q,C,I,l,N,M,b,P,E,d,A,D,c){"use strict";var e=P.Dock;var f=C.extend("sap.ui.ux3.NavigationBar",{metadata:{library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});f.SCROLL_STEP=250;f.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=new I().setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(E.touchEventMode==="ON"){var T=function(h){h.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=h.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var a=function(h){var i=h.touches[0].pageX-t.startTouchX;var L=t.getDomRef("list");var o=L.scrollLeft;var n=t.startScrollX-i;L.scrollLeft=n;t._bTouchNotMoved=false;var j=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(j>0){t._velocity=(n-o)/j;}h.preventDefault();};var g=function(h){if(t._bTouchNotMoved===false){h.preventDefault();var L=t.getDomRef("list");var i=50;var j=Math.abs(t._velocity/10);t._iInertiaIntervalId=setInterval(function(){t._velocity=t._velocity*0.80;var k=t._velocity*i;L.scrollLeft=L.scrollLeft+k;if(Math.abs(t._velocity)<j){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},i);}else if(t._bTouchNotMoved===true){t.onclick(h);h.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.ontouchstart=T;this.ontouchend=g;this.ontouchmove=a;}};f.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}};f.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}this._iSoredScrollPosition=this.$("list").scrollLeft();if(D.browser.firefox){this.$().unbind("DOMMouseScroll",this._handleScroll);}else{this.$().unbind("mousewheel",this._handleScroll);}var a=this.getDomRef("arrow");this._iLastArrowPos=a?parseInt(this._bRtl?a.style.right:a.style.left):-100;};f.prototype.invalidate=function(s){if(s instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true;}C.prototype.invalidate.apply(this,arguments);};f.prototype._calculatePositions=function(){var o=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(o.firstChild,this.getDomRef("ofb"),this.getDomRef("off"));};f.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions();}};f.prototype.onAfterRendering=function(){var o=this.getDomRef();var L=o.firstChild;var a=this.getDomRef("ofb");var g=this.getDomRef("off");this._checkOverflowIntervalId=setInterval(this._checkOverflow.bind(this,L,a,g),350);if(D.browser.firefox){q(o).bind("DOMMouseScroll",q.proxy(this._handleScroll,this));}else{q(o).bind("mousewheel",q.proxy(this._handleScroll,this));}this._calculatePositions();this._updateItemNavigation();var n=this.$();n.on("scroll",function(){n.children().scrollTop(0);n.scrollTop(0);});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition);}};f.prototype._updateItemNavigation=function(){var o=this.getDomRef();if(o){var s=-1;var S=this.getSelectedItem();var i=q(o).children().children("li").children().not(".sapUiUx3NavBarDummyItem");i.each(function(a,g){if(g.id==S){s=a;}});this._oItemNavigation.setRootDomRef(o);this._oItemNavigation.setItemDomRefs(i.toArray());this._oItemNavigation.setSelectedIndex(s);}};f.prototype.onsapspace=function(o){this._handleActivation(o);};f.prototype.onclick=function(o){this._handleActivation(o);};f.prototype.setOverflowItemsToUpperCase=function(v){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",v);return this.setProperty("overflowItemsToUpperCase",v);};f.prototype._handleActivation=function(o){var t=o.target.id;if(t){var i=this.getId();o.preventDefault();if(t==i+"-ofb"){this._scroll(-f.SCROLL_STEP,500);}else if(t==i+"-off"){this._scroll(f.SCROLL_STEP,500);}else if(t==i+"-oflt"||t==i+"-ofl"){this._showOverflowMenu();}else{var a=sap.ui.getCore().byId(t);if(a&&(t!=this.getSelectedItem())&&(sap.ui.getCore().byId(t)instanceof sap.ui.ux3.NavigationItem)){if(this.fireSelect({item:a,itemId:t})){this.setAssociation("selectedItem",a,true);this._updateSelection(t);}}}}};f.prototype._getOverflowMenu=function(){var m=this.getAggregation("overflowMenu");if(!m||this._menuInvalid){if(m){m.destroyAggregation("items",true);}else{m=new M();}var a=this._getCurrentItems();var t=this;var s=this.getSelectedItem();for(var i=0;i<a.length;++i){var n=a[i];var o=new b(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:s==n.getId()?"sap-icon://accept":null,select:(function(n){return function(g){t._handleActivation({target:{id:n.getId()},preventDefault:function(){}});};})(n)});m.addAggregation("items",o,true);}this.setAggregation("overflowMenu",m,true);this._menuInvalid=false;}return m;};f.prototype._getCurrentItems=function(){var a=this.getItems();if(a.length<1){a=this.getAssociatedItems();var o=sap.ui.getCore();for(var i=0;i<a.length;++i){a[i]=o.byId(a[i]);}}return a;};f.prototype._showOverflowMenu=function(){var m=this._getOverflowMenu();var t=this.$("ofl").get(0);m.open(true,t,e.EndTop,e.CenterCenter,t);};f.prototype._updateSelection=function(i){this._menuInvalid=true;var $=q(document.getElementById(i));$.attr("tabindex","0").attr("aria-checked","true");$.parent().addClass("sapUiUx3NavBarItemSel");$.parent().parent().children().each(function(){var a=this.firstChild;if(a&&(a.id!=i)&&(a.className.indexOf("Dummy")==-1)){q(a).attr("tabindex","-1");q(a).parent().removeClass("sapUiUx3NavBarItemSel");q(a).attr("aria-checked","false");}});var s=$.parent().index();if(s>0){s--;}this._oItemNavigation.setSelectedIndex(s);var g=this.$("arrow");var h=g.outerWidth();var t=f._getArrowTargetPos(i,h,this._bRtl);g.stop();var j=this._bRtl?{right:t+"px"}:{left:t+"px"};g.animate(j,500,"linear");var k=this;window.setTimeout(function(){t=f._getArrowTargetPos(i,h,k._bRtl);g.stop();var a=k._bRtl?{right:t+"px"}:{left:t+"px"};g.animate(a,200,"linear",function(){var m=i?window.document.getElementById(i):null;k._scrollItemIntoView(m);});},300);};f.prototype._scrollItemIntoView=function(i){if(!i){return;}var a=q(i.parentNode);var u=a.parent();var t;var r=sap.ui.getCore().getConfiguration().getRTL();var g=a.index()-1;if(g==0){t=r?(u[0].scrollWidth-u.innerWidth()+20):0;}else if(g==a.siblings().length-2){t=r?0:(u[0].scrollWidth-u.innerWidth()+20);}else{var h=a.position().left;var j=r?u.scrollLeftRTL():u.scrollLeft();if(h<0){t=j+h;}else{var k=u.innerWidth()-(h+a.outerWidth(true));if(k<0){t=j-k;t=Math.min(t,j+h);}}}if(t!==undefined){if(r){t=d(t,u.get(0));}u.stop(true,true).animate({scrollLeft:t});}};f._getArrowTargetPos=function(t,a,r){var i=q(document.getElementById(t));if(i.length>0){var w=i.outerWidth();var g=Math.round(i[0].offsetLeft+(w/2)-(a/2));if(!r){return g;}else{return i.parent().parent().innerWidth()-g-a;}}else{return-100;}};f.prototype._handleScroll=function(o){if(o.type=="DOMMouseScroll"){var s=o.originalEvent.detail*40;this._scroll(s,50);}else{var s=-o.originalEvent.wheelDelta;this._scroll(s,50);}o.preventDefault();};f.prototype._scroll=function(i,a){var o=this.$()[0].firstChild;var s=o.scrollLeft;if(!D.browser.msie&&this._bRtl){i=-i;}var S=s+i;q(o).stop(true,true).animate({scrollLeft:S},a);};f.prototype._checkOverflow=function(L,o,a){function i(){return D.os.macintosh&&D.browser.chrome;}if(L&&this.getDomRef()&&A.isActive()){var s=L.scrollLeft;var S=false;var g=false;var r=L.scrollWidth;var h=L.clientWidth;var j=i()?5:0;if(Math.abs(r-h)==1){r=h;}if(!this._bRtl){if(s>j){S=true;}if((r>h)&&(r-(s+h)>j)){g=true;}}else{var $=q(L);if($.scrollLeftRTL()>j){g=true;}if($.scrollRightRTL()>j){S=true;}}if((g!=this._bPreviousScrollForward)||(S!=this._bPreviousScrollBack)){this._bPreviousScrollForward=g;this._bPreviousScrollBack=S;this.$().toggleClass("sapUiUx3NavBarScrollBack",S).toggleClass("sapUiUx3NavBarScrollForward",g);if(!f._bMenuLoaded&&(S||g)){f._bMenuLoaded=true;}}var k=sap.ui.getCore().byId(this.getSelectedItem());if(k){var m=this.$("arrow");var n=m.outerWidth();var t=f._getArrowTargetPos(k.getId(),n,this._bRtl)+"px";if(!this._bRtl){if(m[0].style.left!=t){m[0].style.left=t;}}else{if(m[0].style.right!=t){m[0].style.right=t;}}}}};f.prototype.setSelectedItem=function(i){this.setAssociation("selectedItem",i,true);if(this.getDomRef()){var s=(!i||(typeof(i)=="string"))?i:i.getId();this._updateSelection(s);}return this;};f.prototype.addItem=function(i){this._menuInvalid=true;return this.addAggregation("items",i);};f.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items");};f.prototype.insertItem=function(i,a){this._menuInvalid=true;return this.insertAggregation("items",i,a);};f.prototype.removeItem=function(i){this._menuInvalid=true;return this.removeAggregation("items",i);};f.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items");};f.prototype.addAssociatedItem=function(i){this._menuInvalid=true;return this.addAssociation("associatedItems",i);};f.prototype.removeAssociatedItem=function(i){this._menuInvalid=true;return this.removeAssociation("associatedItems",i);};f.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems");};f.prototype.setAssociatedItems=function(a){c(Array.isArray(a),"aItems must be an array");var L=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<a.length;i++){this.addAssociation("associatedItems",a[i],true);}if(L){var F=q(L).find(":focus");var g=(F.length>0)?F.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100;}else{var h=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?h.style.right:h.style.left);}L.innerHTML="";var r=sap.ui.getCore().createRenderManager();N.renderItems(r,this);r.flush(L,true);r.destroy();var n=g?document.getElementById(g):null;if(n){n.focus();}this._updateSelection(this.getSelectedItem());this._updateItemNavigation();}return this;};f.prototype.isSelectedItemValid=function(){var s=this.getSelectedItem();if(!s){return false;}var a=this.getItems();if(!a||a.length==0){a=this.getAssociatedItems();for(var i=0;i<a.length;i++){if(a[i]==s){return true;}}}else{for(var i=0;i<a.length;i++){if(a[i].getId()==s){return true;}}}return false;};return f;});
