/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/commons/Menu','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','./ShellRenderer','./ShellPersonalization','./NavigationBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/RenderManager','sap/ui/core/Popup','./ToolPopup','sap/ui/commons/SearchField','sap/ui/commons/Label','./Feeder','sap/ui/commons/library','sap/ui/commons/Button','sap/ui/commons/MenuItem','./NotificationBar','sap/ui/base/Object','sap/ui/Device','sap/base/Log','sap/base/assert','sap/ui/dom/jquery/Focusable'],function(q,M,C,P,l,S,a,N,I,R,b,T,c,L,F,d,B,g,j,k,D,m,n){"use strict";var o=l.NotificationBarStatus;var p=l.FeederType;var r=b.Dock;var s=l.ShellDesignType;var t=l.ShellHeaderType;var u=C.extend("sap.ui.ux3.Shell",{metadata:{library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:t.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:s.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});u.WSI_MENU_DELAY=200;u.WSI_OVERFLOW_SCROLL_STEP=250;u.TOOL_PREFIX="-tool-";u.FIRST_RENDERING=true;u.SIDE_BAR_BASE_WIDTH=null;u.PANE_OVERFLOW_BUTTON_HEIGHT=null;u.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new N(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new N(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new M());var e=this;this._checkResizeClosure=function(){e._checkResize();};this.currentToolPaletteWidth=0;this._updateThemeVariables();};u.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar;}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar;}this._oSearchField=null;q(window).unbind("resize",this._checkResizeClosure);clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=null;};u.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").unbind("focusin");if(window.FileReader){var $=this.$("hdr");$.unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);var e=this.$("bgImg");e.unbind('dragover',q.proxy(this._handleDragover)).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};u.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").focusin(this._mSyncRefs[this._topSyncRefId].focusLast);}if(window.FileReader){var $=this.$("hdr");$.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));var e=this.$("bgImg");e.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}var f=(this._oFacetBar.getAssociatedItems().length>0);var h=this.$("facetBar");h.css("display",(f?"block":"none"));this._adaptContentHeight();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings);}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=new I().setCycling(false);this.addDelegate(this._oPaneItemNavigation);}var i=this.$("paneBarEntries");this._updatePaneBarItemNavigation(i);this._setNotifyVisibility();if(u.FIRST_RENDERING){q(window).bind("resize",this._checkResizeClosure);}this._checkResize();u.FIRST_RENDERING=false;if(D.browser.firefox&&D.browser.version==17){setTimeout(this._checkResize.bind(this),500);}};u.prototype._updateThemeVariables=function(){u.SIDE_BAR_BASE_WIDTH=parseInt(P.get("sapUiUx3ShellSideBarBaseWidth"));u.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(P.get("sapUiUx3ShellPaneOverflowButtonHeight"));u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=u.PANE_OVERFLOW_BUTTON_HEIGHT;};u.prototype._checkResize=function(){if(!this.getDomRef()){return;}clearTimeout(this._checkResizeDelayId);this._checkResizeDelayId=setTimeout(function(){this._rerenderPaneBarItems();this._checkToolPaletteSize();}.bind(this),100);};u.prototype._checkToolPaletteSize=function(h){if(!this.getDomRef()){return;}if(h===undefined){h=!this.getShowTools();}var e=this.$("tp");var i=1;var f=9999999;var w=0;var K=true;if(h){i=0;K=false;}do{var x=i*u.SIDE_BAR_BASE_WIDTH;var y=Math.floor(x/2);var z=Math.floor(x/4);var A=this._bRtl?"right":"left";this.$("canvas").css(A,x+"px");this.$("canvasBackground").css(A,x+"px");this.$("wBar").css("margin-"+A,x+"px");var E={};E[A]=x+"px";this.$("notify").css(E);e.css("width",x+"px");var E={};E["width"]=y+"px";E["margin-"+A]=z+"px";this.$("tp-separator").css(E);if(!K){break;}R.forceRepaint(e[0]);w=e.children().last()[0].offsetTop;if(w>=f){i--;K=false;continue;}f=w;i++;if(i>10){m.error("The ToolPalette is growing too much, this must be a bug.");break;}}while(w>e.height());this.currentToolPaletteWidth=this.getShowTools()?x:0;this._updateOverlaysOnToolPaletteChange();};u.prototype._updateOverlaysOnToolPaletteChange=function(){var O=this._getSyncRefs();if(this._bRtl){O.css("right",this.currentToolPaletteWidth+"px");}else{O.css("left",this.currentToolPaletteWidth+"px");}};u.prototype._updatePaneBarItemNavigation=function($){this._oPaneItemNavigation.setRootDomRef($[0]);var e=$.children().toArray();this._oPaneItemNavigation.setItemDomRefs(e);if(this._oPaneItemNavigation.getFocusedIndex()>e.length){this._oPaneItemNavigation.setFocusedIndex(-1);}this._checkPaneBarOverflow($);};u.prototype._checkPaneBarOverflow=function($){clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=setTimeout(function(){this._delayedCheckPaneBarOverflow($);}.bind(this),200);};u.prototype._delayedCheckPaneBarOverflow=function($){if(!$){$=this.$("paneBarEntries");}if($.length==0){this._checkPaneBarOverflow();return;}var e=$.parent().height()-(this._bRtl?$.innerHeight():0);var f=0;var E=$.children();E.css("display","inline-block");var h=false;var w=E.length;for(var i=w-1;i>=0;--i){var x=E[i];if(this._bRtl){f=(0-x.offsetLeft);}else{f=x.offsetLeft+x.offsetWidth;}var y=f<e;q(x).css("display",y?"inline-block":"none");var z=sap.ui.getCore().byId(x.id+"-overflow");z&&z.setVisible(!y);if(y){continue;}else{h=true;}}var O=this.$("paneBarOverflowButton");if(h){O.css("display","block");}else{O.css("display","none");if(D.browser.firefox&&D.browser.version==17){R.forceRepaint(document.getElementsByTagName("body")[0]);}}var A=this._changeOverflowButton();if(A){this._checkPaneBarOverflow();}};u.prototype._adaptOverflowButtonHeight=function(){var $=this.$("paneBarOverflowButton");var e=this.$("paneBarOverflowWrapper");var f=this.$("paneBarOverflowText");var h=this.$("paneBarRight");f.css("width","");var O=u.PANE_OVERFLOW_BUTTON_HEIGHT;var i=f[0].scrollWidth+5;if(i>u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){u.PANE_OVERFLOW_BUTTON_HEIGHT=u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT;}else{u.PANE_OVERFLOW_BUTTON_HEIGHT=i;}$.css("height",u.PANE_OVERFLOW_BUTTON_HEIGHT);e.css("width",u.PANE_OVERFLOW_BUTTON_HEIGHT);f.css("width","100%");h.css("padding-bottom",u.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return(O!=u.PANE_OVERFLOW_BUTTON_HEIGHT);};u.prototype._changeOverflowButton=function(){var O=null;if(this._sOpenPaneId){O=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow");}var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var f=false;if(O&&O.getVisible()){e=O.getText();f=true;}e=e.toUpperCase();var h=this.$("paneBarOverflowText");h.text(e);h.attr("title",e);h.toggleClass("sapUiUx3ShellPaneEntrySelected",f);return this._adaptOverflowButtonHeight();};u.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu");};u.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{'sFocusId':e.id,'oFocusedElement':e}:{};}catch(f){return{};}};u.prototype.applyFocusInfo=function(f){var e=(f.sFocusId?window.document.getElementById(f.sFocusId):null)||f.oFocusedElement;if(e){e.focus();}};u._updateToolIcon=function(e){if(e&&e.firstChild){var $=q(e);var f=e.id.substr(e.id.indexOf(u.TOOL_PREFIX)+6);var h=sap.ui.getCore().byId(f);var i;if($.is(".sapUiUx3ShellToolSelected")){i=h.getIconSelected();}else if($.is(".sapUiUx3ShellToolHover")){i=h.getIconHover();}else{i=h.getIcon();}e.firstChild.src=i;}};u.prototype.onclick=function(e){this.onUserActivation(e);};u.prototype.onsapspace=function(e){this.onUserActivation(e);};u.prototype.onsapenter=function(e){this.onUserActivation(e);};u.prototype.onUserActivation=function(e){var f=e.target.id;var h=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout();}else if(h&&h.parentNode&&h.parentNode.className&&h.parentNode.className.indexOf&&h.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(f);}else if(h&&h.parentNode&&h.parentNode.parentNode&&h.parentNode.parentNode.className&&h.parentNode.parentNode.className.indexOf&&h.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(h.id);}else if(f===i+"-paneBarOverflowText"){var w=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,w,(this._bRtl?"left":"right")+" bottom","center center",w);}else if(f){if(h&&h.className&&h.className.indexOf&&h.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(f);}}};u.prototype._handleWorksetBarSelect=function(e){var f=this._handleWorksetItemClick(e.getParameter("item"));if(!f){e.preventDefault();}};u.prototype._handleFacetBarSelect=function(e){var f=this._handleWorksetItemClick(e.getParameter("item"));if(!f){e.preventDefault();}};u.prototype._handleWorksetItemClick=function(e){var f=e.getParent(),i=e.getId(),h=i,w=true;if(f instanceof u){if(i!=this._sSelectedWorksetId){var x=e.getSubItems();if(x.length>0){h=x[0].getId();}w=this._fireWorksetItemSelected(h);if(w){this._sSelectedWorksetId=i;if(x.length>0){this._sSelectedFacetId=x[0].getId();i=this._sSelectedFacetId;}else{this._sSelectedFacetId=null;}var x=e.getSubItems();this._oFacetBar.setAssociatedItems(x,true);var $=this.$("facetBar");var y=this._calcFacetBarHeight($);if(x.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(x[0]);this._sSelectedFacetId=x[0].getId();}$.slideDown();this._adaptContentHeight(null,true,y);}else{this._oFacetBar.setSelectedItem(null);$.slideUp();this._adaptContentHeight(null,true,y);}}}}else{if(i!=this._sSelectedFacetId){w=this._fireWorksetItemSelected(h);if(w){this._sSelectedFacetId=i;}}}return w;};u.prototype._fireWorksetItemSelected=function(i){var e=sap.ui.getCore().byId(i);var f=(e?e.getKey():null);var h=this.fireWorksetItemSelected({id:i,item:e,key:f});if(h){this.setAssociation("selectedWorksetItem",i,true);}return h;};u.prototype._closeCurrentToolPopup=function(){var O;if(this._oOpenToolPopup){O=this._oOpenToolPopup.getId();q(document.getElementById(this.getId()+u.TOOL_PREFIX+this._oOpenToolPopup.getId())).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(O===this.getId()+"-feederTool"){var f=sap.ui.getCore().byId(this.getId()+"-feeder");f.setText("");f.rerender();}this._oOpenToolPopup.close();this._oOpenToolPopup=null;}return O;};u.prototype._handleToolItemClick=function(i){var A=this._closeCurrentToolPopup();var e;var f=i.substr(i.indexOf(u.TOOL_PREFIX)+6);if(f==(this.getId()+"-searchTool")){e=this._getSearchTool();}else if(f==(this.getId()+"-feederTool")){e=this._getFeederTool();}else{e=sap.ui.getCore().byId(f);}if(e&&(e.getId()!=A)){this._oOpenToolPopup=e;e.setPosition(r.BeginTop,r.EndTop,document.getElementById(i),"13 -6","fit");e.open();q(document.getElementById(i)).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");u._updateToolIcon(document.getElementById(i));var h=this;var O=function(E){e.detachClosed(O);if(h._oOpenToolPopup&&h._oOpenToolPopup.getId()===E.getParameter("id")){h._closeCurrentToolPopup();}q(document.getElementById(i)).removeClass("sapUiUx3ShellToolSelected");u._updateToolIcon(document.getElementById(i));};e.attachClosed(O);}else if(e.getId()==A){u._updateToolIcon(document.getElementById(i));}};u.prototype._hasDarkDesign=function(){return(this.getDesignType()!==s.Light&&this.getDesignType()!==s.Crystal);};u.prototype._getSearchTool=function(){if(!this._oSearchPopup){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new T(this.getId()+"-searchTool",{tooltip:e.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var i=this._hasDarkDesign();this._oSearchPopup.setInverted(i);var f=this;var h=new c(this.getId()+"-searchField",{enableListSuggest:false,search:function(E){f.fireSearch({text:E.getParameter("query")});}});var w=new L({text:e.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(h);this._oSearchPopup.addContent(w).addContent(h);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){h.focus();},100);});this._oSearchField=h;}return this._oSearchPopup;};u.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool();}return this._oSearchField;};u.prototype._getFeederTool=function(){if(!this._oFeederPopup){var e=this;var h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new T(this.getId()+"-feederTool",{tooltip:h.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var i=this._hasDarkDesign();this._oFeederPopup.setInverted(i);var f=new F(this.getId()+"-feeder",{type:p.Medium,submit:function(E){e.fireFeedSubmit({text:E.getParameter("text")});f.setText("");f.rerender();e._oFeederPopup.close();}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){f.setText("");});this._oFeederPopup.addContent(f);}return this._oFeederPopup;};u.prototype.openPane=function(e){var f=this;n(typeof e==="string","sPaneId must be given as string");var i=sap.ui.getCore().byId(e);if(i&&(e!=this._sOpenPaneId)&&this.getShowPane()){var h;if(i){if(i.getKey()==""){h=null;}else{h=i.getKey();}}else{h=null;}this.firePaneBarItemSelected({"id":e,"item":i,"key":h});var w=q(document.getElementById(e));w.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");w.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){f.focusPaneStart();});}else{q(document.getElementById(this.getId()+"-pb_"+this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");}this._sOpenPaneId=e;}return this;};u.prototype.closePane=function(){this._closePane();return this;};u.prototype.isPaneOpen=function(){return(this._sOpenPaneId!=null);};u.prototype._handlePaneBarItemClick=function(e){if(e===this._sOpenPaneId){this.closePane();}else{this.openPane(e);}this._checkPaneBarOverflow();};u._SHELL_OFFSET_RIGHT=0;u.prototype._closePane=function(f){if(!this._sOpenPaneId){if(f){f();}return;}var O=this._sOpenPaneId;var e=this;var h=this.getShowPane()?(this.$("paneBarRight").outerWidth()+u._SHELL_OFFSET_RIGHT):u._SHELL_OFFSET_RIGHT;var i={};i[this._bRtl?"left":"right"]=h+"px";var w={};w[this._bRtl?"marginLeft":"marginRight"]=(h-u._SHELL_OFFSET_RIGHT)+"px";this.$("content").css("overflow-x","hidden");this.$("canvas").stop().animate(i);this.$("notify").stop().animate(i);this._getSyncRefs().stop(false,true).animate(i);this.$("wBar").stop().animate(w);this.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");this.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(i,function(){e.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpen");e.$("content").css("overflow-x","");if(f){f();}e.firePaneClosed({"id":O});});q(document.getElementById(this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null;};u.prototype._openPane=function(O){var e=this;var f=this.getPaneWidth();var i=this.$("paneBarRight").outerWidth();this.$("content").css("overflow-x","hidden");if(this._bRtl){this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginLeft:(f+i)+"px"});this.$("canvas").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("notify").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("canvasBackground").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"},function(){e.$("content").css("overflow-x","");e.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");e.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(O){O();}});}else{this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginRight:(f+i)+"px"});this.$("canvas").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("notify").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("canvasBackground").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"},function(){e.$("content").css("overflow-x","");e.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");e.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(O){O();}});}};u.prototype.setPaneWidth=function(w){if(typeof w=="number"&&(w>0)){w=Math.max(w,50);if(this.getDomRef()){this.$("paneContent").css("width",w+"px");this.$("paneBar").css("width",(w+u.SIDE_BAR_BASE_WIDTH)+"px");if(!!this._sOpenPaneId){if(this._bRtl){this.$("wBar").css("marginLeft",(w+u.SIDE_BAR_BASE_WIDTH)+"px");this.$("canvas").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("notify").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("canvasBackground").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");}else{this.$("wBar").css("marginRight",(w+u.SIDE_BAR_BASE_WIDTH)+"px");this.$("canvas").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("notify").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("canvasBackground").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");}}}this.setProperty("paneWidth",w,true);}return this;};u.prototype.setOffsetRight=function(e,f,h){if(e<0){e=0;}if(e>600){e=600;}u._SHELL_OFFSET_RIGHT=e;var i=e+"px";var w=this._bRtl?{"left":i}:{"right":i};this.$("hdr").stop().animate(w);this.$("hdrImg").stop().animate(w);this.$("bg").stop().animate(w,function(){if(f){f();}});this.$("bgImg").stop().animate(w);this.$("wBar").stop().animate(w);this.$("paneBar").stop().animate(w);q(document.getElementById(h)).stop().animate({"width":i});if(!this.$().hasClass("sapUiUx3ShellNoPane")){i=(e+(this._sOpenPaneId?this.getPaneWidth():0)+u.SIDE_BAR_BASE_WIDTH)+"px";}w=this._bRtl?{"left":i}:{"right":i};this.$("notify").stop().animate(w);this._getSyncRefs().stop(false,true).animate(w);this.$("canvas").stop().animate(w);this.$("canvasBackground").stop().animate(w);};u.prototype._refreshCanvasOffsetRight=function(e){var f=this._bRtl?"left":"right";var h=u._SHELL_OFFSET_RIGHT;if(e){var i=this.$("paneBarRight").outerWidth();h=h+(this._sOpenPaneId?this.getPaneWidth():0)+i;}h=h+"px";this.$("notify").css(f,h);this.$("canvas").css(f,h);this.$("canvasBackground").css(f,h);this._getSyncRefs().css(f,h);};u.prototype._setNotifyVisibility=function(V){var e=this.getNotificationBar();if(!e){return;}if(!V){V=e.getVisibleStatus();}var $=this.$("notify");var f=this._topSyncRefId?q(document.getElementById(this._topSyncRefId)):q(null);var i=f.hasClass("sapUiUx3TI");var h=0;var w=0;if(V===o.Min){h=10;}else if(V===o.Max||V===o.Default){if(this.getHeaderType()===t.BrandOnly&&i){h=parseInt(e.getHeightOfStatus(o.Default));}else{h=10;}w=h;}$.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({"bottom":w+"px"},"fast");if(w>0){$.addClass(i?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay");}}if(V===o.Min){$.css("height",h+"px").css("z-index",1);}else{$.css("height",h+"px").css("z-index",100000);}if(h>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible");}else if(h==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible");}this._adaptContentHeight(V);};u.prototype.syncWithCanvasSize=function(i,e,f,h,A){var w=this._aSyncRefStack.indexOf(i);if(e){var x={id:i,focusFirst:f,focusLast:h,applyChanges:A};if(w<0){this._aSyncRefStack.push(i);}this._mSyncRefs[i]=x;x.applyChanges({showOverlay:this.getHeaderType()!==t.BrandOnly});}else{if(w>=0){delete this._mSyncRefs[i];this._aSyncRefStack.splice(w,1);}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyPane").removeAttr("tabindex").unbind("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var x=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var $=this._getSyncRefs();var y=this.getDomRef("canvas");$.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var z=u._SHELL_OFFSET_RIGHT;if(this.getShowPane()){z+=u.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){z+=this.getPaneWidth();}}$.css(this._bRtl?"left":"right",z+"px");$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");$.css("bottom","0");q(y).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").focusin(x.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").focusin(q.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").focusin(q.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").focusin(x.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=x.id;}if(this._sUpdateNotificationZIndex){clearTimeout(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex;}this._sUpdateNotificationZIndex=setTimeout(function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var E=q(document.getElementById(this._topSyncRefId));this._oOpenToolPopup.$().css("z-index",parseInt(E.css("z-index"))+1);}}.bind(this),0);};u.prototype._getSyncRefs=function(){var e=[];var f;for(var i=0;i<this._aSyncRefStack.length;i++){f=this._aSyncRefStack[i]?window.document.getElementById(this._aSyncRefStack[i]):null;if(f){e.push(f);}}return q(e);};u.prototype.focusFirstHdr=function(){var e=this.$("hdr-items").firstFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=t.BrandOnly){if(e){e.focus();}}else{this.focusFirstTool();}};u.prototype.focusLastHdr=function(){var e=this.$("hdr-items").lastFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=t.BrandOnly){if(e){e.focus();}}else{this.focusPaneEnd();}};u.prototype.focusFirstTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").first();if($.length&&this.getShowTools()){$[0].focus();}else{this._mSyncRefs[this._topSyncRefId].focusFirst();}};u.prototype.focusLastTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").last();if($.length&&this.getShowTools()){$[0].focus();}else{this.focusPaneEnd();}};u.prototype.focusPaneStart=function(){var e=this.$("paneBar").firstFocusableDomRef();if(e){e.focus();}else{this.focusFirstTool();}};u.prototype.focusPaneEnd=function(){var e=this.$("paneBar").lastFocusableDomRef();if(e){e.focus();}else{this._mSyncRefs[this._topSyncRefId].focusLast();}};u.prototype.setAppTitle=function(A){this.setProperty("appTitle",A,true);this._rerenderHeader();return this;};u.prototype.setAppIcon=function(A){this.setProperty("appIcon",A,true);this._rerenderHeader();return this;};u.prototype.setShowLogoutButton=function(e){this.setProperty("showLogoutButton",e,true);this._rerenderHeader();return this;};u.prototype.setLogoutButtonTooltip=function(e){this.setProperty("logoutButtonTooltip",e,true);this._rerenderHeader();return this;};u.prototype.insertHeaderItem=function(h,i){if(k.isA(h,"sap.ui.commons.Button")){h.setStyled(false);}this.insertAggregation("headerItems",h,i,true);this._rerenderHeader();return this;};u.prototype.addHeaderItem=function(h){if(k.isA(h,"sap.ui.commons.Button")){h.setStyled(false);}this.addAggregation("headerItems",h,true);this._rerenderHeader();return this;};u.prototype.removeHeaderItem=function(i){var e=this.removeAggregation("headerItems",i,true);this._rerenderHeader();return e;};u.prototype.removeAllHeaderItems=function(){var e=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return e;};u.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this;};u.prototype.setShowSearchTool=function(e){this.setProperty("showSearchTool",e,true);this._rerenderToolPalette();return this;};u.prototype.setShowFeederTool=function(e){this.setProperty("showFeederTool",e,true);this._rerenderToolPalette();return this;};u.prototype.setHeaderType=function(h){var e=this.getHeaderType();this.setProperty("headerType",h,true);this.$().removeClass("sapUiUx3ShellHead"+e).addClass("sapUiUx3ShellHead"+this.getHeaderType());var $=this._getSyncRefs();if($.length){$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");}var f={showOverlay:h!==t.BrandOnly};q.each(this._mSyncRefs,function(i,w){w.applyChanges(f);});return this;};u.prototype.setAllowOverlayHeaderAccess=function(A){this.setProperty("allowOverlayHeaderAccess",A,true);var $=this._getSyncRefs();if($.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");}return this;};u.prototype.setDesignType=function(e){var f=this.getDesignType();this.setProperty("designType",e,true);var h=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(h);}if(this._oFeederPopup){this._oFeederPopup.setInverted(h);}var w=this.getToolPopups();for(var i=0;i<w.length;++i){w[i].setInverted(h);}this.$().removeClass("sapUiUx3ShellDesign"+f).addClass("sapUiUx3ShellDesign"+e).toggleClass("sapUiUx3ShellDesignLight",!h);return this;};u.prototype.setShowTools=function(e){this.setProperty("showTools",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize();}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","");}this._checkToolPaletteSize(true);return this;};u.prototype.setShowPane=function(e){this.setProperty("showPane",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow();}else{var f=this;this._closePane(function(){f._refreshCanvasOffsetRight(false);f.$().addClass("sapUiUx3ShellNoPane");});}return this;};u.prototype.insertToolPopup=function(e,i){this.insertAggregation("toolPopups",e,i,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};u.prototype.addToolPopup=function(e){var i=this._hasDarkDesign();e.setInverted(i);this.addAggregation("toolPopups",e,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};u.prototype.removeToolPopup=function(i){var e=this.removeAggregation("toolPopups",i,true);if(e===this._oOpenToolPopup){this._closeCurrentToolPopup();}this._rerenderToolPalette();return e;};u.prototype.removeAllToolPopups=function(){var e=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return e;};u.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this;};u.prototype.insertContent=function(e,i){this.insertAggregation("content",e,i,true);this._rerenderContent();return this;};u.prototype.addContent=function(e){this.addAggregation("content",e,true);this._rerenderContent();return this;};u.prototype.removeContent=function(i){var e=this.removeAggregation("content",i,true);this._rerenderContent();return e;};u.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content",true);this._rerenderContent();return e;};u.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this;};u.prototype.addPaneBarItem=function(e){this.addAggregation("paneBarItems",e,true);this._rerenderPaneBarItems();return this;};u.prototype.insertPaneBarItem=function(e,i){this.insertAggregation("paneBarItems",e,i,true);this._rerenderPaneBarItems();return this;};u.prototype.removePaneBarItem=function(e){var f=this.removeAggregation("paneBarItems",e,true);if(f){var i=sap.ui.getCore().byId(f.getId()+"-overflow");if(i){i.destroy();}}this._rerenderPaneBarItems();return f;};u.prototype.removeAllPaneBarItems=function(){var e=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return e;};u.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this;};u.prototype.addWorksetItem=function(w){this.addAggregation("worksetItems",w,true);this._rerenderWorksetItems();return this;};u.prototype.insertWorksetItem=function(w,i){this.insertAggregation("worksetItems",w,i,true);this._rerenderWorksetItems();return this;};u.prototype.removeWorksetItem=function(w){var e=this.removeAggregation("worksetItems",w,true);this._rerenderWorksetItems();return e;};u.prototype.removeAllWorksetItems=function(){var e=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return e;};u.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this;};function v(e){var O=e.getNotificationBar();if(O){e._setNotifyVisibility(o.None);O.setVisibleStatus=O.__orig_setVisibleStatus;O.detachDisplay(O.__fHandleNotifyDisplay);delete O.__orig_setVisibleStatus;delete O.__fHandleNotifyDisplay;}}u.prototype.setNotificationBar=function(e){v(this);if(e){var f=this;e.__orig_setVisibleStatus=e.setVisibleStatus;e.setVisibleStatus=function(V){this.__orig_setVisibleStatus.apply(this,arguments);f._setNotifyVisibility();};}this.setAggregation("notificationBar",e,true);this._rerenderNotificationArea();if(e){e.__fHandleNotifyDisplay=function(E){var h=E?E.getParameter("show"):e.hasItems();e.setVisibleStatus(h?o.Default:o.None);};e.attachDisplay(e.__fHandleNotifyDisplay);e.__fHandleNotifyDisplay();}return this;};u.prototype.destroyNotificationBar=function(){v(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this;};u.prototype._rerenderNotificationArea=function(){var $=this.$("notify");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderNotificationArea(e,this);e.flush($[0],true);e.destroy();}};u.prototype._rerenderHeader=function(){var $=this.$("hdr");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderHeader(e,this);e.flush($[0],true);e.destroy();}};u.prototype._rerenderToolPalette=function(){var $=this.$("tp");if($.length>0){var e=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();S.renderToolPalette(e,this);e.flush($[0],true);this._afterRenderingToolPalette();e.destroy();this._checkResize();}};u.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").unbind("mouseenter mouseleave");this.$("focusDummyTPEnd").unbind("focusin");this.$("focusDummyTPStart").unbind("focusin");};u.prototype._afterRenderingToolPalette=function(){var e=this.getId()+u.TOOL_PREFIX;var f=this.getToolPopups();var V=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(r.BeginTop,r.EndTop,e+this._oOpenToolPopup.getId()?window.document.getElementById(e+this._oOpenToolPopup.getId()):null,"13 -6","fit");var h=document.getElementById(e+this._oOpenToolPopup.getId());q(h).toggleClass("sapUiUx3ShellToolSelected",true);u._updateToolIcon(h);V=true;}if(!V&&this._oOpenToolPopup){this._closeCurrentToolPopup();}for(var i=0;i<f.length;i++){var w=f[i];if(w instanceof T){q(document.getElementById(e+w.getId())).hover(function(x){q(this).toggleClass("sapUiUx3ShellToolHover",(x.type==="mouseenter"));u._updateToolIcon(this);});}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").focusin(this._mSyncRefs[this._topSyncRefId].focusFirst);}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));}};u.prototype._rerenderContent=function(e){var $=this.$("content");if($.length>0){var f=this.getContent(),h=sap.ui.getCore().createRenderManager();for(var i=0;i<f.length;i++){h.renderControl(f[i]);}h.flush($[0],e);h.destroy();}};u.prototype._rerenderPane=function(e){var $=this.$("paneContent");if($.length>0){var f=this.getPaneContent(),h=sap.ui.getCore().createRenderManager();for(var i=0;i<f.length;i++){h.renderControl(f[i]);}h.flush($[0],e);h.destroy();}};u.prototype._rerenderPaneBarItems=function(){var $=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderPaneBarItems(e,this);e.flush($[0]);e.destroy();this._updatePaneBarItemNavigation($);}var f=this;var h=this._getPaneOverflowMenu();var w=this.getPaneBarItems();var O=function(E){var A={overflowItem:E.getParameter("item"),target:{id:E.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};f.onUserActivation(A);};for(var i=0;i<w.length;++i){var x=w[i].getId()+"-overflow";var y=sap.ui.getCore().byId(x);if(!y){var z=new g(x,{text:w[i].getText(),visible:false,select:O});h.addItem(z);}}this._checkPaneBarOverflow($);};u.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){S.renderWorksetItems(null,this);S.renderFacetBar(null,this);var i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}};u.prototype.forceInvalidation=C.prototype.invalidate;u.prototype.invalidate=function(e){if(!e){this.forceInvalidation();}else if(e instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var w=this.getSelectedWorksetItem();if(w){var i;var f=sap.ui.getCore().byId(w);if(f&&f.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(f.getParent().getSubItems());}else if(f&&(i=f.getSubItems())){if(i&&(i.length>0)){this._oFacetBar.setAssociatedItems(i);}}i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}}}else if((e instanceof sap.ui.core.Item)&&(e.getParent()==this)){this.forceInvalidation();}else if(e instanceof T){this._rerenderToolPalette();}else if(this.indexOfHeaderItem(e)>=0){this._rerenderHeader();}};u.prototype._setParent=C.prototype.setParent;u.prototype.setParent=function(e,A,f){this._setParent(e,A,f);this.forceInvalidation();};u.prototype.setContent=function(e,f){n(e===null||(e instanceof C)||((Array.isArray(e)&&((e.length>0)?(e[0]instanceof C):true))),"vContent must be a control or array of controls or null");n((f===undefined||f===true||f===false),"bDestruct must be true, false, or undefined");var h=[];var $=this.$("content");var w=false;if(!f){h=this.removeAllAggregation("content",true);if($.length>0){R.preserveContent($[0]);w=true;$.empty();}}else{this.destroyAggregation("content",true);}if(e instanceof C){this.addAggregation("content",e,true);}else if(e&&typeof(e)=="object"&&e.length){for(var i=0;i<e.length;i++){this.addAggregation("content",e[i],true);}}this._rerenderContent(w);return h;};u.prototype.setPaneContent=function(e,f){n((e instanceof C)||((Array.isArray(e)&&((e.length>0)?(e[0]instanceof C):true))),"vContent must be a control or array of controls");n((f===undefined||f===true||f===false),"bDestruct must be true, false, or undefined");var h=[];var $=this.$("paneContent");var w=false;if(!f){h=this.removeAllAggregation("paneContent",true);if($.length>0){R.preserveContent($[0]);w=true;$.empty();}}else{this.destroyAggregation("paneContent",true);}if(e instanceof C){this.addAggregation("paneContent",e,true);}else if(e&&typeof(e)=="object"&&e.length){for(var i=0;i<e.length;i++){this.addAggregation("paneContent",e[i],true);}}this._rerenderPane(w);return h;};u.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem");};u.prototype.setSelectedWorksetItem=function(e){var f=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",e,true);var h=this.getSelectedWorksetItem();if(f!=h){var i=sap.ui.getCore().byId(h);if(i){this._sSelectedWorksetId=h;this._sSelectedFacetId=null;var w=i.getSubItems();if(w.length>0){i=w[0];}if(i&&(i.getParent()instanceof sap.ui.ux3.NavigationItem)){var x=i.getParent();this._sSelectedWorksetId=x.getId();this._sSelectedFacetId=i.getId();this._oWorksetBar.setSelectedItem(x);this._oFacetBar.setAssociatedItems(x.getSubItems());this._oFacetBar.setSelectedItem(i);if(this.getDomRef()){var $=this.$("facetBar");var y=this._calcFacetBarHeight($);$.slideDown();this._adaptContentHeight(null,true,y);}}else if(i){this._oWorksetBar.setSelectedItem(i);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var $=this.$("facetBar");var y=this._calcFacetBarHeight($);$.slideUp();this._adaptContentHeight(null,true,y);}}}else{throw new Error("WorksetItem with ID "+h+" cannot be found.");}}return this;};u.prototype.setApplyContentPadding=function(A){this.setProperty("applyContentPadding",A,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!A);this._adaptContentHeight();return this;};u.prototype.setFullHeightContent=function(f){this.setProperty("fullHeightContent",f,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",f);this._adaptContentHeight();return this;};u.prototype._calcFacetBarHeight=function(f){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0;}if(!f){f=this.$("facetBar");}if(f.length>0){var h=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,h);}return this._iFacetBarHeight;};u.prototype._adaptContentHeight=function(e,A,f){if(!this.getDomRef()){return;}var $=this.$("content");var h=this.$("canvas");if(this.getFullHeightContent()){var i=this.getApplyContentPadding();var w=!i?0:parseInt(h.css("paddingTop"));var x=!i?0:parseInt(h.css("paddingLeft"));var y=!i?0:parseInt(h.css("paddingRight"));var _=f?f:this._calcFacetBarHeight();var z=(w+(this._oFacetBar.getAssociatedItems().length>0?_:0))+"px";if(A){$.stop().animate({top:z});}else{$.stop().css("top",z);}var E=this.getNotificationBar();if(E&&!e){e=E.getVisibleStatus();}if(e===o.Default||e===o.Max){$.css("bottom",E.getHeightOfStatus(o.Default));}else{var G=!i?0:parseInt(h.css("paddingBottom"));if(E&&e===o.Min){G+=j.HOVER_ITEM_HEIGHT;}$.css("bottom",G+"px");}$.css(this._bRtl?"right":"left",x+"px");$.css(this._bRtl?"left":"right",y+"px");}else{$.removeAttr("style");}if(D.browser.webkit){R.forceRepaint(this.getId()+"-canvas");}};u.prototype._handleDragover=function(e){var i=e.target.id;if(!this._dragOverBlinking){var $=q(document.getElementById(i));$.css("opacity","0.5");this._dragOverBlinking=true;var f=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){f._dragOverBlinking=null;},300);},300);}return false;};u.prototype._handleDragend=function(e){return false;};u.prototype._handleDrop=function(f){var i=f.target.id;f.preventDefault();var e=f.originalEvent;var h=e.dataTransfer.files[0];if(h){var w=new window.FileReader();w.onload=q.proxy(function(x){var y=x.target.result;if(i==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(y,true);}else if(i==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(y,true);}else if(i==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(y,true);}w=null;},this);w.readAsDataURL(h);}};u.prototype._getPersonalization=function(){if(!this.oPersonalization){this.oPersonalization=new a(this);}return this.oPersonalization;};u.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog();};u.prototype.initializePersonalization=function(e){this._getPersonalization().initializeSettings(e);};u.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return;}var i="";if(!this.getAppIcon()){i=P._getThemeImage('sapUiUx3ShellApplicationImageURL',true);this.$("logoImg").attr('src',i);}i=P._getThemeImage('sapUiUx3ShellHeaderImageURL',true);this.$("hdrImg").attr('src',i);i=P._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);this.$("bgImg").attr('src',i);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize();};return u;});
