//@ui5-bundle sap/ui/ux3/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/ux3/ActionBar',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library','./ActionBarRenderer','sap/ui/core/ResizeHandler','sap/ui/ux3/ThingAction','sap/ui/ux3/ToolPopup','sap/ui/ux3/Feeder','sap/ui/core/Popup','sap/ui/commons/MenuItem','sap/ui/commons/Menu','sap/ui/commons/MenuButton','sap/ui/commons/Button','sap/ui/Device','sap/base/Log'],function(q,C,I,l,A,R,T,a,F,P,M,b,c,B,D,L){"use strict";var d=P.Dock;var e=l.FeederType;var f=l.ActionBarSocialActions;var g=l.FollowActionState;
var h=C.extend("sap.ui.ux3.ActionBar",{metadata:{library:"sap.ui.ux3",properties:{followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:g.Default},flagState:{type:"boolean",group:"Misc",defaultValue:null},favoriteState:{type:"boolean",group:"Misc",defaultValue:null},updateState:{type:"boolean",group:"Misc",defaultValue:null},thingIconURI:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alwaysShowMoreMenu:{type:"boolean",group:"Misc",defaultValue:true},showUpdate:{type:"boolean",group:"Misc",defaultValue:true},showFollow:{type:"boolean",group:"Misc",defaultValue:true},showFlag:{type:"boolean",group:"Misc",defaultValue:true},showFavorite:{type:"boolean",group:"Misc",defaultValue:true},showOpen:{type:"boolean",group:"Misc",defaultValue:true},dividerWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null}},aggregations:{businessActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"businessAction"},_businessActionButtons:{type:"sap.ui.commons.Button",multiple:true,singularName:"_businessActionButton",visibility:"hidden"},_socialActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"_socialAction",visibility:"hidden"}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});
h.prototype.init=function(){this.mActionMap={};this.mActionKeys=f;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),true);if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);}};
h.prototype.exit=function(){this.closePopups();if(this._oUpdatePopup){this._oUpdatePopup.destroy();this._oUpdatePopup=null;}if(this._oMoreMenuButton){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;}if(this._oMoreMenu){this._oMoreMenu.destroy();this._oMoreMenu=null;}if(this._oHoldItem){this._oHoldItem.destroy();}if(this._oUnFollowItem){this._oUnFollowItem.destroy();}if(this._oUnHoldItem){this._oUnHoldItem.destroy();}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.mActionKeys=null;this.oRb=null;this.destroyAggregation("_socialActions");this.destroyAggregation("_businessActionButtons");if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
h.prototype.isActive=function(){var r=this.getDomRef()!=null;return r;};
h.prototype._getLocalizedText=function(k,i){var t;if(this.oRb){t=this.oRb.getText(k);}if(t&&i){for(var j=0;j<i.length;j++){t=t.replace("{"+j+"}",i[j]);}}return t?t:k;};
h.prototype._getSocialAction=function(s){var r=this.mActionMap[s];if(!r){r=new T({id:this.getId()+"-"+s});switch(s){case this.mActionKeys.Update:r.name=this.mActionKeys.Update;r.tooltipKey="ACTIONBAR_UPDATE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarUpdateAction";r.fnInit=function(o){o._oUpdatePopup=new a({id:o.getId()+"-UpdateActionPopup"}).addStyleClass("sapUiUx3ActionBarUpdatePopup");o._oUpdatePopup._ensurePopup().setAutoClose(true);o._feeder=new F({id:o.getId()+"-Feeder",type:e.Comment,thumbnailSrc:o.getThingIconURI(),text:"",submit:q.proxy(function(E){var m=E.getParameter("text");this.fireFeedSubmit({text:m});this._oUpdatePopup.close();},o)});o._feeder.addStyleClass("sapUiUx3ActionBarFeeder");o._oUpdatePopup.addContent(o._feeder);};r.fnActionSelected=function(E,o){o._setUpdateState(!o.getUpdateState());if(o._oUpdatePopup.isOpen()){o._oUpdatePopup.close();}else{var m,t,n;o._oUpdatePopup.setPosition(d.BeginBottom,d.BeginTop,E.getSource().getDomRef(),"-8 -13","none");o._oUpdatePopup.open();m=q(o._oUpdatePopup.getDomRef());t=q(window).height();n=q(o.getDomRef()).offset().top;m.css("top","auto").css("bottom",(t-n+7)+"px");setTimeout(function(){if(o._feeder.getFocusDomRef()){o._feeder.getFocusDomRef().focus();}},1000);}o._updateSocialActionDomRef(r);};r.fnExit=function(o){if(o._oUpdatePopup){o._oUpdatePopup.destroy();o._oUpdatePopup=null;}};r.fnCalculateState=function(o){var m=null;if(o.getUpdateState()){m="Selected";}return m;};break;case this.mActionKeys.Follow:var i=r;r.name=this.mActionKeys.Follow;r.tooltipKey="ACTIONBAR_FOLLOW_ACTION_TOOLTIP_FOLLOW";r.cssClass="sapUiUx3ActionBarFollowAction";r.isMenu=function(o){return o.getFollowState()!=g.Default;};r.fnActionSelected=function(E,o){if(o.getFollowState()==g.Default){o._setFollowState(g.Follow);o.fireActionSelected({id:i.name,state:"followState",action:i});this._fnPrepareFollowMenu(E,o);}else{o._oMenu.open(false,i.getFocusDomRef(),d.BeginBottom,d.BeginTop,i.getDomRef());}};r.fnCalculateState=function(o){return o.getFollowState();};r._fnPrepareFollowMenu=function(E,o){var m=sap.ui.resource("sap.ui.ux3","themes/"+sap.ui.getCore().getConfiguration().getTheme());if(o.mActionMap[o.mActionKeys.Follow]){if(!o._oUnFollowItem){o._oUnFollowItem=new M({id:o.getId()+"-unfollowState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNFOLLOW"),icon:m+"/img/menu_unlisten.png"});}if(!o._oHoldItem){o._oHoldItem=new M({id:o.getId()+"-holdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_HOLD"),icon:m+"/img/menu_hold.png"});}if(!o._oUnHoldItem){o._oUnHoldItem=new M({id:o.getId()+"-unholdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNHOLD"),icon:m+"/img/menu_follow.png"});}if(!o._oMenu){o._oMenu=new b({id:o.getId()+"-followActionMenu"});o._oMenu.attachItemSelect(q.proxy(function(n){this._fnFollowMenuSelected(n,o);},this));o._oMenu.addItem(o._oHoldItem);o._oMenu.addItem(o._oUnHoldItem);o._oMenu.addItem(o._oUnFollowItem);}if(o.getFollowState()==g.Default){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(false);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==g.Follow){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPPAUSE_FOLLOW"));o._oHoldItem.setVisible(true);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==g.Hold){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPCONTINUE_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(true);}o._updateSocialActionDomRef(r);}};r._fnFollowMenuSelected=function(E,o){if(o.mActionMap[o.mActionKeys.Follow]){var m=E.getParameters().item.getId();if(m==o.getId()+"-followState"){o._setFollowState(g.Follow);}else if(m==o.getId()+"-unfollowState"){o._setFollowState(g.Default);}else if(m==o.getId()+"-holdState"){o._setFollowState(g.Hold);}else if(m+"-unholdState"){o._setFollowState(g.Follow);}o.fireActionSelected({id:i.name,state:m,action:i});this._fnPrepareFollowMenu(E,o);}};break;case this.mActionKeys.Favorite:var j=r;r.name=this.mActionKeys.Favorite;r.tooltipKey="ACTIONBAR_FAVORITE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFavoriteAction";r.fnActionSelected=function(E,o){if(o.getFavoriteState()==true){o._setFavoriteState(false);}else{o._setFavoriteState(true);}o.fireActionSelected({id:j.name,state:o.getFavoriteState(),action:j});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var m=null;if(o.getFavoriteState()){m="Selected";}return m;};break;case this.mActionKeys.Flag:var k=r;r.name=this.mActionKeys.Flag;r.tooltipKey="ACTIONBAR_FLAG_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFlagAction";r.fnActionSelected=function(E,o){o._setFlagState(!o.getFlagState());o.fireActionSelected({id:k.name,state:o.getFlagState(),action:k});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var m=null;if(o.getFlagState()){m="Selected";}return m;};break;case this.mActionKeys.Open:r.name=this.mActionKeys.Open;r.tooltipKey="ACTIONBAR_OPEN_THING_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarOpenThingAction";break;default:L.warning("Function \"sap.ui.ux3.ActionBar.prototype._getSocialAction\" was called with unknown action key \""+s+"\".\n\tNo action will not be rendered.");return undefined;}}return r;};
h.prototype._updateSocialActionDomRef=function(s){var i=s.$();if(i){i.attr("class",s.cssClass);if(s.fnCalculateState){i.addClass("sapUiUx3ActionBarAction");i.addClass(s.fnCalculateState(this));}if(s.name==this.mActionKeys.Update||s.name==this.mActionKeys.Flag||s.name==this.mActionKeys.Favorite){i.attr("aria-pressed",s.fnCalculateState(this)=="Selected"?"true":"false");}if(s.isMenu){i.attr("aria-haspopup",s.isMenu(this)?"true":"false");}}};
h.prototype._rerenderSocialActions=function(){var i=this.$("socialActions");if(i.length>0){var r=sap.ui.getCore().createRenderManager();A.renderSocialActions(r,this);r.flush(i[0]);r.destroy();}};
h.prototype._rerenderBusinessAction=function(o){var i=o.$();if(i.length>0){var r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(i[0].parentNode);r.destroy();}};
h.prototype._rerenderBusinessActions=function(){if(!this.getAlwaysShowMoreMenu()){var i=this.$("businessActions");if(i&&i.length>0){var r=sap.ui.getCore().createRenderManager();A.renderBusinessActionButtons(r,this);r.flush(i[0]);r.destroy();}}this._onresize();};
h.prototype.setFollowState=function(o){this.setProperty("followState",o);if(!this._oMenu){var i=this._getSocialAction(this.mActionKeys.Follow);i._fnPrepareFollowMenu(null,this);}return this;};
h.prototype.setShowUpdate=function(i){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),i);this.setProperty("showUpdate",i,true);return this;};
h.prototype.setShowFollow=function(i){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),i);this.setProperty("showFollow",i,true);return this;};
h.prototype.setShowFlag=function(i){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),i);this.setProperty("showFlag",i,true);return this;};
h.prototype.setShowFavorite=function(i){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),i);this.setProperty("showFavorite",i,true);return this;};
h.prototype.setShowOpen=function(i){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),i);this.setProperty("showOpen",i,true);return this;};
h.prototype._setFollowState=function(o){this.setProperty("followState",o,true);return this;};
h.prototype._setFlagState=function(o){this.setProperty("flagState",o,true);return this;};
h.prototype._setUpdateState=function(u){this.setProperty("updateState",u,true);return this;};
h.prototype._setFavoriteState=function(o){this.setProperty("favoriteState",o,true);return this;};
h.prototype.setThingIconURI=function(i){this.setProperty("thingIconURI",i,true);var u=this.mActionMap[this.mActionKeys.Update];if(u&&this._feeder){this._feeder.setThumbnailSrc(i);}else{L.warning("Function \"sap.ui.ux3.ActionBar.setThingIconURI\": failed to set new icon \""+i+"\".\n\tReason: either updateAction "+u+" or feeder "+this._feeder+" is not defined.");}return this;};
h.prototype.setDividerWidth=function(w){this._iSocActListWidth=null;this.setProperty("dividerWidth",w);return this;};
h.prototype.setAlwaysShowMoreMenu=function(j){var o=this.getProperty("alwaysShowMoreMenu");var k=this.getAggregation("businessActions",[]);this.setProperty("alwaysShowMoreMenu",j,true);if(o!=j&&k){if(!j){for(var i=0;i<k.length;i++){var m=k[i];this._createButtonForAction(m,this._oMoreMenu._getMenuItemForAction(m));}}else{var n=this._getBusinessActionButtons();for(var p=0;p<n.length;p++){if(n[p].oMenuItem){n[p].oMenuItem.setVisible(true);n[p].oMenuItem=null;}}this.destroyAggregation("_businessActionButtons");}this._styleMoreMenuButton();}this._bCallOnresize=true;this._rerenderBusinessActions();return this;};
h.prototype.closePopups=function(){if(this._oUpdatePopup){this._oUpdatePopup.close();}if(this._oMoreMenu){this._oMoreMenu.close();}if(this._oMenu){this._oMenu.close();}};
h.prototype._removeSocialAction=function(s){var r=null;if(s.name&&this.mActionMap[s.name]){if(this.mActionMap[s.name].fnExit){this.mActionMap[s.name].fnExit(this);}r=this.removeAggregation("_socialActions",this.mActionMap[s.name],true);this.mActionMap[s.name].destroy();delete this.mActionMap[s.name];this._rerenderSocialActions();this._iSocActListWidth=null;}return r;};
h.prototype._removeAllSocialActions=function(){for(var k in this.mActionMap){if(this.mActionMap[k]&&this.mActionMap[k].fnExit){this.mActionMap[k].fnExit(this);}}this.mActionMap={};var r=this.removeAllAggregation("_socialActions",true);this._iSocActListWidth=null;this._rerenderSocialActions();return r;};
h.prototype._addSocialAction=function(s,i){var r=null;if(!this.mActionMap[s.name]){r=this._prepareSocialAction(s,i);if(s.fnInit){s.fnInit(this);}this._iSocActListWidth=null;}if(r){this._rerenderSocialActions();}return r;};
h.prototype._prepareSocialAction=function(s,i){s.attachSelect(q.proxy(function(o){if(s.fnActionSelected){s.fnActionSelected(o,this);}else{this.fireActionSelected({id:s.name,action:s});}},this));s.setTooltip(this._getLocalizedText(s.tooltipKey));this.mActionMap[s.name]=s;if(i){this.insertAggregation("_socialActions",s,i,true);}else{this.addAggregation("_socialActions",s,true);}return s;};
h.prototype._setShowSocialAction=function(s,i){return i?this._addSocialAction(s):this._removeSocialAction(s);};
h.prototype.addBusinessAction=function(o){return this._addBusinessAction(o);};
h.prototype.insertBusinessAction=function(o,i){return this._addBusinessAction(o,i);};
h.prototype.removeBusinessAction=function(o){return this._removeBusinessAction(o,true);};
h.prototype._removeBusinessAction=function(o,r){if(typeof o==="string"){var j;var s=o;for(var i=0;i<this.getBusinessActions().length;i++){var k=this.getBusinessActions()[i];if(k.getId()===s){j=k;break;}}o=j;}if(this._oMoreMenu){var m=this._oMoreMenu._getMenuItemForAction(o);if(m){this._oMoreMenu.removeItem(m);m.destroy();}if(this._oMoreMenu.getItems().length==0){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;this._oMoreMenu.destroy();this._oMoreMenu=null;}}if(!this.getAlwaysShowMoreMenu()){var n=this._getButtonForAction(o);if(n){this.removeAggregation("_businessActionButtons",n,true);n.destroy();}}var p=this.removeAggregation("businessActions",o,true);if(r){this._rerenderBusinessActions();}return p;};
h.prototype.removeAllBusinessActions=function(){var j=this.getAggregation("businessActions",[]);if(j){for(var i=0;i<j.length;i++){this._removeBusinessAction(j[i],false);}}this._rerenderBusinessActions();var r=this.removeAllAggregation("businessActions",true);return r;};
h.prototype.destroyBusinessActions=function(){var j=this.getAggregation("businessActions",[]);if(j){for(var i=0;i<j.length;i++){var k=this._removeBusinessAction(j[i],false);if(k instanceof sap.ui.core.Element){k.destroy(true);}}}this._rerenderBusinessActions();var r=this.destroyAggregation("businessActions",true);return r;};
h.prototype._getBusinessActionButtons=function(){return this.getAggregation("_businessActionButtons",[]);};
h.prototype._addBusinessAction=function(o,j){var r;if(!j&&j!=0){r=this.addAggregation("businessActions",o,true);}else{r=this.insertAggregation("businessActions",o,j,true);}if(!this._oMoreMenuButton){this._oMoreMenuButton=new c(this.getId()+"-MoreMenuButton");this._oMoreMenuButton.setText(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TEXT"));this._oMoreMenuButton.setTooltip(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP"));this._oMoreMenuButton.setDockButton(d.EndTop);this._oMoreMenuButton.setDockMenu(d.EndBottom);this._styleMoreMenuButton();this._oMoreMenu=new b(this.getId()+"-MoreMenu",{ariaDescription:this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP")});this._oMoreMenu._getMenuItemForAction=function(n){for(var i=0;i<this.getItems().length;i++){var k=this.getItems()[i];if(k.action==n){return k;}}return null;};this._oMoreMenuButton.setMenu(this._oMoreMenu);}var m=this._oMoreMenu.getId()+"-MenuItem-"+o.getId();var k=new M(m,{text:o.getText(),enabled:o.getEnabled()});k.action=o;k.attachSelect(q.proxy(function(i){this.fireActionSelected({id:o.getId(),action:o});},this));if(j){this._oMoreMenu.insertItem(k,j);}else{this._oMoreMenu.addItem(k);}this._createButtonForAction(o,k,j);this._rerenderBusinessActions();return r;};
h.prototype._getMoreMenuButton=function(){return this._oMoreMenuButton;};
h.prototype._onresize=function(E){var o=this.$();if(o){var s=this.getActionBarMinWidth()+"px";if(o.css('minWidth')!=s){o.css('minWidth',s);}}if(!this.getAlwaysShowMoreMenu()&&this._oMoreMenuButton){var S=false;if(this._getBusinessActionButtons().length>1){var m=this._oMoreMenuButton.$().outerWidth();var i=o.outerWidth()-this._getSocialActionListMinWidth()-m;var j=this._getBusinessActionButtons();var k=0;for(var n=0;n<j.length;n++){var p=j[n].$().parent();k+=p.outerWidth();if(n==j.length-1){k-=m;}if(k>=i){if(p.length>0){p.css('display','none');if(j[n].oMenuItem){j[n].oMenuItem.setVisible(true);}S=true;}}else{if(p.length>0){p.css('display','');if(D.browser.msie){this._rerenderBusinessAction(j[n]);}if(j[n].oMenuItem){j[n].oMenuItem.setVisible(false);}}}}S|=this.getAggregation("businessActions").length>j.length;}var r=this._oMoreMenuButton.$().parent();if(r.length>0){S?r.css('display',''):r.css('display','none');}if(!S&&this._oMoreMenu){this._oMoreMenu.close();}}this._setItemNavigation();};
h.prototype.onBeforeRendering=function(){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;};
h.prototype.onAfterRendering=function(){this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._onresize,this));if(this._bCallOnresize){this._onresize();}this._setItemNavigation();};
h.prototype._getSocialActionListMinWidth=function(){if(!this._iSocActListWidth){if(this.getDividerWidth()){this._iSocActListWidth=parseInt(this.getDividerWidth());}else{var s=this.getAggregation("_socialActions",[]);var i=s.length;this._iSocActListWidth=24*i+12;}}return this._iSocActListWidth;};
h.prototype.getActionBarMinWidth=function(){var r=this._getSocialActionListMinWidth();var o=this._oMoreMenuButton;if(!this.getAlwaysShowMoreMenu()&&this._getBusinessActionButtons().length==1){o=this._getBusinessActionButtons()[0];}if(o){var p=o.$().parent();if(p){r+=p.outerWidth()-3;}}return r;};
h.prototype._getButtonForAction=function(o){for(var i=0;i<this._getBusinessActionButtons().length;i++){var j=this._getBusinessActionButtons()[i];if(j.action==o){return j;}}return null;};
h.prototype._createButtonForAction=function(o,m,i){if(!this.getAlwaysShowMoreMenu()&&!o.showInMoreMenu){var j=new B({id:this.getId()+"-"+o.getId()+"Button",text:o.getText(),tooltip:o.getTooltip(),enabled:o.getEnabled()});j.attachPress(q.proxy(function(k){this.fireActionSelected({id:o.getId(),action:o});},this));j.oMenuItem=m;j.action=o;if(i){this.insertAggregation("_businessActionButtons",j,i,true);}else{this.addAggregation("_businessActionButtons",j,true);}return j;}return null;};
h.prototype._styleMoreMenuButton=function(){if(this._oMoreMenuButton){if(this.getAlwaysShowMoreMenu()){this._oMoreMenuButton.setLite(true);this._oMoreMenuButton.addStyleClass("sapUiUx3ActionBarLiteMoreButton");}else{this._oMoreMenuButton.setLite(false);this._oMoreMenuButton.removeStyleClass("sapUiUx3ActionBarLiteMoreButton");}}};
h.prototype._setItemNavigation=function(){if(this.getDomRef()){this._oItemNavigation.setRootDomRef(q(this.getDomRef()).get(0));var j=[];var o=this.getAggregation("_socialActions",[]);for(var i=0;i<o.length;i++){j.push(o[i].getDomRef());}o=this.getAggregation("_businessActionButtons",[]);for(var i=0;i<o.length;i++){j.push(o[i].getDomRef());}if(this._oMoreMenuButton&&this._oMoreMenuButton.getDomRef()){j.push(this._oMoreMenuButton.getDomRef());}this._oItemNavigation.setItemDomRefs(j);}};
h.prototype.invalidate=function(o){if(o instanceof T){var i=sap.ui.getCore().byId(this.getId()+"-"+o.getId()+"Button");var j=this._oMoreMenu&&this._oMoreMenu._getMenuItemForAction(o);if(i){i.setTooltip(o.getTooltip());i.setText(o.getText());i.setEnabled(o.getEnabled());}if(j){j.setTooltip(o.getTooltip());j.setText(o.getText());j.setEnabled(o.getEnabled());}if(!i&&!j){C.prototype.invalidate.apply(this,arguments);}}C.prototype.invalidate.apply(this,arguments);};
return h;});
sap.ui.predefine('sap/ui/ux3/ActionBarRenderer',["./library"],function(l){"use strict";var A=l.ActionBarSocialActions;var a={apiVersion:2};
a.render=function(r,c){r.openStart("div",c);r.class("sapUiUx3ActionBar");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.attr('role','toolbar');}r.openEnd();r.openStart("ul",c.getId()+"-socialActions");r.class("sapUiUx3ActionBarSocialActions");r.style("min-width",c._getSocialActionListMinWidth()+"px");r.openEnd();this.renderSocialActions(r,c);r.close("ul");r.openStart("ul",c.getId()+'-businessActions');r.class("sapUiUx3ActionBarBusinessActions");r.openEnd();this.renderBusinessActionButtons(r,c);r.close("ul");r.close("div");};
a.renderBusinessActionButtons=function(r,c){var b=c._getBusinessActionButtons();var m=c._getMoreMenuButton();if(b&&b.length>0){for(var i=0;i<b.length;i++){var B=b[i];r.openStart("li");r.class("sapUiUx3ActionBarItemRight");r.openEnd();r.renderControl(B);r.close("li");}this._renderMoreMenuButton(r,m);}else if(m){this._renderMoreMenuButton(r,m);}};
a._renderMoreMenuButton=function(r,m){if(m){r.openStart("li");r.class("sapUiUx3ActionBarItemRight");r.class("sapUiUx3ActionBarMoreButton");r.openEnd();r.renderControl(m);r.close("li");}};
a.renderSocialActions=function(r,c){var m=c.mActionMap;var k=c.mActionKeys;if(m[k.Update]){this._renderSocialActionListItem(r,c,m[k.Update]);}if(m[k.Follow]){this._renderSocialActionListItem(r,c,m[k.Follow]);}if(m[k.Flag]){this._renderSocialActionListItem(r,c,m[k.Flag]);}if(m[k.Favorite]){this._renderSocialActionListItem(r,c,m[k.Favorite]);}if(m[k.Open]){this._renderSocialActionListItem(r,c,m[k.Open]);}for(var K in m){if(!(K in A)){this._renderSocialActionListItem(r,c,m[K]);}}};
a._renderSocialActionListItem=function(r,c,b){if(b&&!b.hide){r.openStart("li");r.class("sapUiUx3ActionBarItem");r.openEnd();this._renderSocialAction(r,c,b);r.close("li");}};
a._renderSocialAction=function(r,c,b){r.openStart("a",b);r.attr("role","button");r.attr("aria-disabled","false");r.attr("aria-haspopup",b.isMenu&&b.isMenu(c)?"true":"false");if(b.name===c.mActionKeys.Flag||b.name===c.mActionKeys.Favorite){r.attr("aria-pressed",b.fnCalculateState(c)==="Selected"?"true":"false");}r.attr("tabindex","0");r.class(b.cssClass);if(b.fnCalculateState){r.class(b.fnCalculateState(c));}r.class("sapUiUx3ActionBarAction");if(b.getTooltip()){r.attr("title",b.getTooltip());}if(b.text){r.attr("text",c.getLocalizedText(b.getText()));}r.openEnd();r.close("a");};
return a;});
sap.ui.predefine('sap/ui/ux3/Collection',['sap/ui/core/Element','sap/ui/model/SelectionModel','./library'],function(E,S,l){"use strict";
var C=E.extend("sap.ui.ux3.Collection",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Appearance",defaultValue:null},editable:{type:"boolean",group:"Appearance",defaultValue:false},multiSelection:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChanged:{},propertyChanged:{}}}});
C.prototype.init=function(){this.oCollectionSelection=new S(S.SINGLE_SELECTION);};
C.prototype.setMultiSelection=function(m){if(m){this.oCollectionSelection.setSelectionMode(S.MULTI_SELECTION);}else{this.oCollectionSelection.setSelectionMode(S.SINGLE_SELECTION);this.removeAllSelectedItems();}return this.setProperty("multiSelection",m);};
C.prototype.setEditable=function(e){this.setProperty("editable",e,true);this.firePropertyChanged();return this;};
C.prototype.setTitle=function(t){this.setProperty("title",t);this.fireEvent('_titleChanged',{newTitle:this.getProperty("title")});return this;};
C.prototype.addSelectedItem=function(s){var o;if(typeof s=="object"){o=s;}else{o=sap.ui.getCore().byId(s);}if(this.getSelectedItems().indexOf(o.getId())>=0){return this;}var i=this.indexOfItem(o);if(i>-1){if(this.oCollectionSelection.getSelectionMode()==S.SINGLE_SELECTION){this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();}this.oCollectionSelection.addSelectionInterval(i,i);}this.addAssociation("selectedItems",s,true);this.fireSelectionChanged();return this;};
C.prototype.removeSelectedItem=function(s){if(this.getSelectedItems().length<=1){return;}var r=this.removeAssociation("selectedItems",s,true);var i;if(typeof s=="object"){i=this.indexOfItem(s);}else{i=this.indexOfItem(sap.ui.getCore().byId(s));}if(i>-1){this.oCollectionSelection.removeSelectionInterval(i,i);}this.fireSelectionChanged();return r;};
C.prototype.removeAllSelectedItems=function(){var r=this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();if(this.getItems().length>0){this.addSelectedItem(this.getItems()[0]);}else{this.fireSelectionChanged();}return r;};
return C;});
sap.ui.predefine('sap/ui/ux3/CollectionInspector',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library','./CollectionInspectorRenderer','sap/ui/commons/ToggleButton','sap/ui/commons/SegmentedButton','sap/ui/commons/Button'],function(q,C,I,l,a,T,S,B){"use strict";
var b=C.extend("sap.ui.ux3.CollectionInspector",{metadata:{library:"sap.ui.ux3",properties:{sidebarVisible:{type:"boolean",group:"Appearance",defaultValue:true},fitParent:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{collections:{type:"sap.ui.ux3.Collection",multiple:true,singularName:"collection"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{selectedCollection:{type:"sap.ui.ux3.Collection",multiple:false}},events:{collectionSelected:{},itemSelectionChanged:{},editCollection:{}}}});
b.prototype.init=function(){var t=this;if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);}var o=new T(this.getId()+"-toggleButton");o.setParent(this);o.setTooltip("This button opens and closes the sidebar");o.attachPress(function(){if(o.getPressed()){t.openSidebar();}else{t.closeSidebar();}});this._oToggleButton=o;var c=new S(this.getId()+"-selector");c.attachSelect(function(E){var i=this.indexOfButton(sap.ui.getCore().byId(this.getSelectedButton()));var d=t.getCollections()[i];t.setSelectedCollection(d);t.fireCollectionSelected({collection:d});t.openSidebar();});this._oCollectionSelector=c;var e=new B();e.addStyleClass("sapUiUx3EditCollectionButton");e.setText("Collection");e.setTooltip("This button opens an edit dialog for the current collection");e.attachPress(function(){t.fireEditCollection();});this._oEditButton=e;};
b.prototype.exit=function(){this._oToggleButton.destroy();this._oToggleButton=null;this._oEditButton.destroy();this._oEditButton=null;this._oCollectionSelector.destroy();this._oCollectionSelector=null;if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
b.prototype.onBeforeRendering=function(){this._oToggleButton.setPressed(this.getSidebarVisible());};
b.prototype.onAfterRendering=function(){if(!this.getSelectedCollection()){if(this.getCollections().length>0){this.setSelectedCollection(this.getCollections()[0]);}}else{var s=sap.ui.getCore().byId(this.getSelectedCollection());if(s.getSelectedItems().length==0&&s.getItems().length>0){s.addSelectedItem(s.getItems()[0]);}}this.setElementsHeight();this.updateItemNavigation();this.refreshSelectionHighlighting();};
b.prototype.onclick=function(e){var t=e.target;if(q(t).hasClass("sapUiUx3CICollectionListItem")){var s=sap.ui.getCore().byId(this.getSelectedCollection());if(s.getSelectedItems().indexOf(t.id)>=0){s.removeSelectedItem(t.id);}else{s.addSelectedItem(t.id);}this.refreshSelectionHighlighting();this.fireItemSelectionChanged({selectedItems:s.getSelectedItems()});}};
b.prototype.getToggleButton=function(){return this._oToggleButton;};
b.prototype.getCollectionSelector=function(){return this._oCollectionSelector;};
b.prototype.rerenderSidebar=function(){var c=sap.ui.getCore().byId(this.getSelectedCollection());if(c&&c.getEditable()){this._oEditButton.setVisible(true);}else{this._oEditButton.setVisible(false);}var $=this.$("sidebar");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderSidebar(r,this);r.flush($[0]);r.destroy();}if(c&&c.getEditable()){this.$("sidebar").addClass("sapUiUx3CIWithEditButton");}else{this.$("sidebar").removeClass("sapUiUx3CIWithEditButton");}this.updateItemNavigation();this.refreshSelectionHighlighting();};
b.prototype.updateItemNavigation=function(){var i=[];var $=this.$("sidebar").find('li');q.each($,function(c,d){i.push(d);});this._oItemNavigation.setItemDomRefs(i);this._oItemNavigation.setRootDomRef(this.$("sidebar ul")[0]);};
b.prototype.rerenderContent=function(){var c=this.$("content");if(c.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderContent(r,this);r.flush(c[0]);r.destroy();}this.setElementsHeight();};
b.prototype.setElementsHeight=function(){if(this.getFitParent()){return;}var s=this.$("sidebar");var c=this.$("content");var i=c.outerHeight(true);var d=c.outerHeight(true)-c.height();var e=s.outerHeight(true)-s.height();s.height(Math.max(200,i)-e);c.height(Math.max(200,i)-d);};
b.prototype.openSidebar=function(){var $=this.$();var s=this.$("sidebar");var c=this.$("content");s.stop(true,true).animate({width:150},300,function(){s.css('width','');});c.stop(true,true).animate({left:150},300,function(){c.css('left','');});$.removeClass("sapUiUx3CISidebarClosed");$.addClass("sapUiUx3CISidebarOpened");this._oToggleButton.setPressed(true);};
b.prototype.closeSidebar=function(){var $=this.$();var s=this.$("sidebar");var c=this.$("content");s.stop(true,true).animate({width:0},300,function(){s.css('width','');});c.stop(true,true).animate({left:0},300,function(){c.css('left','');});$.removeClass("sapUiUx3CISidebarOpened");$.addClass("sapUiUx3CISidebarClosed");this._oToggleButton.setPressed(false);};
b.prototype.insertCollection=function(c,i){var o=new B();o.setText(c.getTitle());c.attachEvent('_titleChanged',function(e){o.setText(e.getParameter("newTitle"));});var t=this;c.attachSelectionChanged(function(){t.refreshSelectionHighlighting();});c.attachPropertyChanged(function(){t.rerenderSidebar();});this._oCollectionSelector.insertButton(o,i);return this.insertAggregation("collections",c,i);};
b.prototype.addCollection=function(c){var o=new B();o.setText(c.getTitle());c.attachEvent('_titleChanged',function(e){o.setText(e.getParameter("newTitle"));});var t=this;c.attachSelectionChanged(function(){t.refreshSelectionHighlighting();});c.attachPropertyChanged(function(){t.rerenderSidebar();});this._oCollectionSelector.addButton(o);return this.addAggregation("collections",c);};
b.prototype.removeCollection=function(c){var i;if(typeof c=="object"){i=this.indexOfCollection(c);}else{i=this.indexOfCollection(sap.ui.getCore().byId(c));}var o=this._oCollectionSelector.getButtons()[i];this._oCollectionSelector.removeButton(o);var r=this.removeAggregation("collections",c);if(r&&this.getSelectedCollection()==r.getId()){this.setSelectedCollection(null);}return r;};
b.prototype.removeAllCollections=function(){this._oCollectionSelector.removeAllButtons();this.setSelectedCollection(null);return this.removeAllAggregation("collections");};
b.prototype.destroyCollections=function(){this._oCollectionSelector.destroyButtons();this.setSelectedCollection(null);return this.destroyAggregation("collections");};
b.prototype.setSelectedCollection=function(c){this.setAssociation("selectedCollection",c,true);if(!c){this._oEditButton.setVisible(false);}else{this._oCollectionSelector.setSelectedButton(this._oCollectionSelector.getButtons()[this.indexOfCollection(c)]);var s=sap.ui.getCore().byId(this.getSelectedCollection());if(s.getSelectedItems().length==0&&s.getItems().length>0){s.addSelectedItem(s.getItems()[0]);}}this.rerenderSidebar();this.refreshSelectionHighlighting();return this;};
b.prototype.insertContent=function(c,i){this.insertAggregation("content",c,i,true);this.rerenderContent();return this;};
b.prototype.addContent=function(c){this.addAggregation("content",c,true);this.rerenderContent();return this;};
b.prototype.removeContent=function(c){var r=this.removeAggregation("content",c,true);this.rerenderContent();return r;};
b.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);this.rerenderContent();return r;};
b.prototype.destroyContent=function(){this.destroyAggregation("content",true);this.rerenderContent();return this;};
b.prototype.onfocusout=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CICollectionListItem")){t.removeClass("sapUiUx3CISidebarFoc");}};
b.prototype.onfocusin=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CICollectionListItem")){t.addClass("sapUiUx3CISidebarFoc");}};
b.prototype.onsapenter=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CISidebarFoc")){this.onclick(e);}e.stopPropagation();};
b.prototype.onsapspace=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CISidebarFoc")){this.onclick(e);}e.stopPropagation();};
b.prototype.refreshSelectionHighlighting=function(){var i=this.$("sidebar").find('.sapUiUx3CICollectionListItem');var s;if(this.getSelectedCollection()){s=sap.ui.getCore().byId(this.getSelectedCollection()).getSelectedItems();}else{s=[];}i.each(function(c,o){if(s.indexOf(o.id)>=0){q(o).addClass("sapUiUx3CICollectionListItemSelected");q(o).attr("aria-selected",true);}else{q(o).removeClass("sapUiUx3CICollectionListItemSelected");q(o).attr("aria-selected",false);}});};
b.prototype.getEditButton=function(){return this._oEditButton;};
return b;});
sap.ui.predefine('sap/ui/ux3/CollectionInspectorRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.addClass("sapUiUx3CI");if(c.getSidebarVisible()){r.addClass("sapUiUx3CISidebarOpened");}else{r.addClass("sapUiUx3CISidebarClosed");}if(c.getFitParent()){r.addClass("sapUiUx3CIFitParent");}r.writeClasses();r.writeControlData(c);r.write(">");r.write("<div");r.addClass("sapUiUx3CIToolBar");r.writeClasses();r.write(">");this.renderToggleButton(r,c);this.renderCollectionSelector(r,c);r.write("</div>");r.write('<div');r.addClass("sapUiUx3CISidebar");r.writeClasses();r.writeAttribute("id",c.getId()+"-sidebar");r.write(">");this.renderSidebar(r,c);r.write("</div>");r.write("<div");r.addClass("sapUiUx3CIContent");r.writeAttribute("id",c.getId()+"-content");r.writeClasses();r.write(">");this.renderContent(r,c);r.write("</div>");r.write("<div");r.addClass("sapUiUx3CIClear");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
C.renderToggleButton=function(r,c){if(c.getToggleButton()){r.write("<div");r.writeAttribute("id",c.getId()+"-togglebutton");r.addClass("sapUiUx3CIToggleButton");r.writeClasses();r.write(">");r.renderControl(c.getToggleButton());r.write("</div>");}};
C.renderCollectionSelector=function(r,c){if(c.getCollectionSelector()){r.write("<div");r.addClass("sapUiUx3CICollectionSelector");r.writeClasses();r.write(">");r.renderControl(c.getCollectionSelector());r.write("</div>");}};
C.renderSidebar=function(r,c){r.write("<div");r.addClass("sapUiUx3CICollectionListContainer");r.writeClasses();r.write(">");r.write('<ul tabindex="-1"');r.addClass("sapUiUx3CICollectionList");r.writeClasses();var o=sap.ui.getCore().byId(c.getSelectedCollection());if(c.getSelectedCollection()){r.writeAccessibilityState(o,{role:"listbox",multiselectable:o.getMultiSelection()});}r.write(">");if(c.getSelectedCollection()){var i=o.getItems().length;o.getItems().forEach(function(a,I){r.write('<li tabindex="-1"');r.writeElementData(a);r.writeAttributeEscaped("title",a.getText());r.addClass("sapUiUx3CICollectionListItem");r.writeClasses();r.writeAccessibilityState(a,{role:"option",selected:o.getSelectedItems().indexOf(a.getId())>=0,setsize:i,posinset:I});r.write(">");r.writeEscaped(a.getText());r.write("</li>");});}r.write("</ul></div>");r.renderControl(c.getEditButton());};
C.renderContent=function(r,c){c.getContent().forEach(function(o){r.renderControl(o);});};
return C;},true);
sap.ui.predefine('sap/ui/ux3/DataSet',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library','./DataSetRenderer','sap/ui/model/SelectionModel','sap/ui/commons/SegmentedButton','sap/ui/commons/SearchField','sap/ui/commons/Toolbar','sap/ui/commons/Button','sap/base/Log'],function(q,C,R,a,D,S,b,c,T,B,L){"use strict";
var d=C.extend("sap.ui.ux3.DataSet",{metadata:{library:"sap.ui.ux3",properties:{showToolbar:{type:"boolean",group:"Misc",defaultValue:true},showFilter:{type:"boolean",group:"Misc",defaultValue:true},showSearchField:{type:"boolean",group:"Misc",defaultValue:true},multiSelect:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.ux3.DataSetItem",multiple:true,singularName:"item",bindable:"bindable"},views:{type:"sap.ui.ux3.DataSetView",multiple:true,singularName:"view"},filter:{type:"sap.ui.core.Control",multiple:true,singularName:"filter"},_viewSwitches:{type:"sap.ui.core.Control",multiple:true,singularName:"_viewSwitch",visibility:"hidden"},_toolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.ux3.DataSetView",multiple:false}},events:{selectionChanged:{parameters:{oldLeadSelectedIndex:{type:"int"},newLeadSelectedIndex:{type:"int"}}},search:{parameters:{query:{type:"string"}}}}}});
d.prototype.init=function(){var t=this,o;this.selectionModel=new S(S.SINGLE_SELECTION);this._oSegBut=new b();this._oSegBut.attachSelect(function(e){t.press(e);},t);this._oSegBut.show=false;this._oSearchField=new c(this.getId()+"-searchValue");this._oSearchField.setShowListExpander(false);this._oSearchField.setEnableListSuggest(false);this._oSearchField.setEnableFilterMode(true);this._oSearchField.setEnableClear(true);this._oSearchField.show=false;t=this;this._oSearchField.attachSearch(function(e){t.fireSearch(e.getParameters());});this.selectionModel.attachSelectionChanged(function(e){var f,n;var p=e.getParameters();if(p){n=p.leadIndex;f=p.oldIndex;}t.fireSelectionChanged({oldLeadSelectedIndex:f,newLeadSelectedIndex:n});L.debug("Selection Change fired");});o=new T();this._setToolbar(o);this._iShiftStart=null;};
d.prototype.exit=function(){this._oSegBut.destroy();this._oSearchField.destroy();this.destroyAggregation("_toolbar");};
d.prototype._prepareToolbar=function(){var v=this.getViews().length,t=this._getToolbar();if(v>1&&this._oSegBut.show==false){t.insertItem(this._oSegBut,0);this._oSegBut.show=true;}else if(v<=1&&this._oSegBut.show){t.removeItem(this._oSegBut);this._oSegBut.show=false;}if(this.getShowSearchField()&&this._oSearchField.show==false){t.insertRightItem(this._oSearchField,t.getRightItems().length);this._oSearchField.show=true;}else if(!this.getShowSearchField()&&this._oSearchField.show==true){t.removeRightItem(this._oSearchField);this._oSearchField.show=false;}};
d.prototype.press=function(e,s){var o=e.getParameters().selectedButtonId,v=o.substring(o.lastIndexOf('-')+1),f=sap.ui.getCore().byId(this.getSelectedView());f.exitView(this.getItems());this.setSelectedView(v);};
d.prototype.filter=function(){this.fireFilter({filterValue:this.getFilterValue()});};
d.prototype.sort=function(){this.fireSort();};
d.prototype.addSelectionInterval=function(i,I){this.selectionModel.addSelectionInterval(i,I);return this;};
d.prototype.setSelectionInterval=function(i,I){this.selectionModel.setSelectionInterval(i,I);return this;};
d.prototype.removeSelectionInterval=function(i,I){this.selectionModel.removeSelectionInterval(i,I);return this;};
d.prototype.getSelectedIndex=function(){return this.selectionModel.getLeadSelectedIndex();};
d.prototype.getSelectedIndices=function(){return this.selectionModel.getSelectedIndices()||[];};
d.prototype.clearSelection=function(){this.selectionModel.clearSelection();return this;};
d.prototype.selectItem=function(e){var p=e.getParameters(),i=e.getParameters().itemId,I=sap.ui.getCore().byId(i),f=this.getItems(),g=f.indexOf(I),o=this.getLeadSelection();if(!this.getMultiSelect()){if(o==g&&!p.shift){this.setLeadSelection(-1);}else{this.setLeadSelection(g);}this._iShiftStart=null;}else{if(p.ctrl){if(!this.isSelectedIndex(g)){this.addSelectionInterval(g,g);}else{this.removeSelectionInterval(g,g);}if(this._iShiftStart>=0){this._iShiftStart=g;}}if(p.shift){if(!this._iShiftStart&&this._iShiftStart!==0){this._iShiftStart=o;}if(this._iShiftStart>=0&&p.ctrl){this.addSelectionInterval(this._iShiftStart,g);}else if(this._iShiftStart>=0&!p.ctrl){this.setSelectionInterval(this._iShiftStart,g);}else{this.setLeadSelection(g);this._iShiftStart=g;}}if(!p.shift&&!p.ctrl){if(o==g&&g!=this._iShiftStart){this.setLeadSelection(-1);}else{this.setLeadSelection(g);}this._iShiftStart=null;}}};
d.prototype.prepareRendering=function(){var v,V=this.getViews().length;if(V==0){return;}this._prepareToolbar();if(this._bDirty){v=sap.ui.getCore().byId(this.getSelectedView());if(v.exitView){v.exitView(this.getItems());}if(v.initView){v.initView(this.getItems());}this._bDirty=false;}};
d.prototype.getLeadSelection=function(){return this.selectionModel.getLeadSelectedIndex();};
d.prototype.setLeadSelection=function(i){this.selectionModel.setLeadSelectedIndex(i);};
d.prototype.isSelectedIndex=function(i){return(this.selectionModel.isSelectedIndex(i));};
d.prototype.getSelectedItemId=function(i){return this.getItems()[i].getId();};
d.prototype.createViewSwitch=function(v,i){var V;if(v.getIcon()){V=new B({id:this.getId()+"-view-"+v.getId(),lite:true,icon:v.getIcon(),iconHovered:v.getIconHovered(),iconSelected:v.getIconSelected()});}else if(v.getName()){V=new B({id:this.getId()+"-view-"+v.getId(),text:v.getName(),lite:true});}else{V=new B({id:this.getId()+"-view-"+v.getId(),text:v.getId(),lite:true});}V._viewIndex=i;return V;};
d.prototype._rerenderToolbar=function(){var $=this.$("toolbar");this._prepareToolbar();if($.length>0){var r=sap.ui.getCore().createRenderManager();D.renderToolbar(r,this);r.flush($[0]);r.destroy();}};
d.prototype._rerenderFilter=function(){var $=this.$("filter");if($.length>0){var r=sap.ui.getCore().createRenderManager();D.renderFilterArea(r,this);r.flush($[0]);if(this.getShowFilter()){$.removeClass("noPadding");}else{$.addClass("noPadding");}r.destroy();}};
d.prototype.setMultiSelect=function(m){this.clearSelection();if(!m){this.setProperty("multiSelect",false);if(!!this.selectionModel){this.selectionModel.setSelectionMode(S.SINGLE_SELECTION);}}else{this.setProperty("multiSelect",true);if(!!this.selectionModel){this.selectionModel.setSelectionMode(S.MULTI_SELECTION);}}return this;};
d.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);if(r){r.detachSelected(this.selectItem,this);r.destroyAggregation("_template",true);this._bDirty=true;}return r;};
d.prototype.removeAllItems=function(){var I=this.getItems(),r;q.each(I,function(i,o){o.destroyAggregation("_template",true);o.detachSelected(this.selectItem,this);});r=this.removeAllAggregation("items");this._bDirty=true;return r;};
d.prototype.destroyItems=function(){var r=this.destroyAggregation("items");this._bDirty=true;this.invalidate();return r;};
d.prototype.addItem=function(i){this.addAggregation("items",i,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};
d.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};
d.prototype.setFilterValue=function(f){this.setProperty("filterValue",f,true);return this;};
d.prototype.getFilterValue=function(){return this.getProperty("filterValue");};
d.prototype.insertView=function(v,i){var V=this.createViewSwitch(v,i,true);if(!this.getSelectedView()){this.setSelectedView(v);}this.insertAggregation("views",v,i);this._oSegBut.insertButton(V,i);this._rerenderToolbar();return this;};
d.prototype.addView=function(v){var i=this.getViews().length,V=this.createViewSwitch(v,i);if(!this.getSelectedView()){this.setSelectedView(v);}this.addAggregation("views",v,true);this._oSegBut.addButton(V);this._rerenderToolbar();return this;};
d.prototype.removeView=function(v){var r=this.removeAggregation("views",v,true);if(r){if(this.getSelectedView()==r.getId()){this.setSelectedView(this.getViews()[0]);this._bDirty=true;r.invalidate();}else{this._rerenderToolbar();}this._oSegBut.removeButton(this.getId()+"-view-"+r.getId()).destroy();}return r;};
d.prototype.destroyViews=function(){this._oSegBut.destroyButtons();this.destroyAggregation("views");return this;};
d.prototype.removeAllViews=function(){var r=this.removeAllAggregation("views");this._oSegBut.destroyButtons();return r;};
d.prototype.setEnableSorting=function(e){this.setProperty("enableSorting",e,true);this._rerenderToolbar();return this;};
d.prototype.setEnableFiltering=function(e){this.setProperty("enableFiltering",e,true);this._rerenderToolbar();return this;};
d.prototype.setSelectedView=function(v){var o=this.getSelectedView();this.setAssociation("selectedView",v);if(o!=this.getSelectedView()){this._bDirty=true;}if(this.getId()+"-view-"+this.getSelectedView()!==this._oSegBut.getSelectedButton()){this._oSegBut.setSelectedButton(this.getId()+"-view-"+this.getSelectedView());}return this;};
d.prototype.addToolbarItem=function(t){this._getToolbar().addItem(t);this._rerenderToolbar();};
d.prototype.removeToolbarItem=function(t){this._getToolbar().removeItem(t);this._rerenderToolbar();};
d.prototype.setShowToolbar=function(s){this.setProperty("showToolbar",s,true);this._rerenderToolbar();return this;};
d.prototype.setShowFilter=function(s){this.setProperty("showFilter",s,true);this._rerenderFilter();return this;};
d.prototype.setShowSearchField=function(s){this.setProperty("showSearchField",s,true);this._rerenderToolbar();return this;};
d.prototype._setToolbar=function(t){this.setAggregation("_toolbar",t,true);this._rerenderToolbar();};
d.prototype._getToolbar=function(){return this.getAggregation("_toolbar");};
d.prototype.refreshItems=function(){var o=this.getBinding("items"),s=sap.ui.getCore().byId(this.getSelectedView());o.bUseExtendedChangeDetection=true;if(s&&s.getItemCount&&s.getItemCount()){var i=Math.max(s.getItemCount(),this.getItems().length);if(i){o.getContexts(0,i);}else{o.getContexts();}}else{o.getContexts();}};
d.prototype.updateItems=function(s){var o=this.mBindingInfos["items"],A=this.getMetadata().getAggregation("items"),e=sap.ui.getCore().byId(this.getSelectedView()),f=o.binding,F=o.factory,g,I,h,j,t=this,k=[];f.bUseExtendedChangeDetection=true;if(e&&e.getItemCount&&e.getItemCount()){var m=Math.max(e.getItemCount(),this.getItems().length);if(m){k=f.getContexts(0,m);}else{k=f.getContexts();}}else{k=f.getContexts();}if(k.diff&&s){var n=k.diff;for(var i=0;i<n.length;i++){I=this.getItems();j=n[i].index;if(n[i].type==="delete"){h=I[j];n[i].item=h;this.removeItem(h);}else if(k.diff[i].type==="insert"){h=F("",k[j]);h.setBindingContext(k[j],o.model);n[i].item=h;this.insertItem(h,j);}}if(e&&e.updateView){e.updateView(n);}}else{this[A._sDestructor]();q.each(k,function(j,p){var r=t.getId()+"-"+j;g=F(r,p);g.setBindingContext(p,o.model);t[A._sMutator](g);});}I=this.getItems();for(var i=0,l=k.length;i<l;i++){I[i].setBindingContext(k[i],o.model);}};
return d;});
sap.ui.predefine('sap/ui/ux3/DataSetItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var D=E.extend("sap.ui.ux3.DataSetItem",{metadata:{library:"sap.ui.ux3",properties:{iconSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:'Title'},checkable:{type:"boolean",group:"Misc",defaultValue:true},subtitle:{type:"string",group:"Misc",defaultValue:'Subtitle'}},aggregations:{_template:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{selected:{parameters:{itemId:{type:"string"}}}}}});
D.prototype.onclick=function(e){e.stopPropagation();var s=e.shiftKey;var c=!!(e.metaKey||e.ctrlKey);this.fireSelected({itemId:this.getId(),shift:s,ctrl:c});};
D.prototype.ondblclick=function(e){this.onclick(e);};
return D;});
sap.ui.predefine('sap/ui/ux3/DataSetRenderer',["sap/ui/thirdparty/jquery"],function(q){"use strict";var D={};
D.render=function(r,c){var v=null;c.prepareRendering();r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3DS");r.writeClasses();r.writeStyles();r.write(">");r.write("<div id='"+c.getId()+"-toolbar'");r.addClass('sapUiUx3DSToolbar');if(!c.getShowToolbar()){r.addClass('noPadding');}r.writeClasses();r.write(">");this.renderToolbar(r,c);r.write("</div>");r.write("<div id='"+c.getId()+"-filter'");r.addClass('sapUiUx3DSFilterArea');if(!c.getShowFilter()){r.addClass('noPadding');}r.writeClasses();r.write(">");this.renderFilterArea(r,c);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-items");r.addClass("sapUiUx3DSItems");r.writeClasses();r.write(">");v=sap.ui.getCore().byId(c.getSelectedView());r.renderControl(v);r.write("</div>");r.write("</div>");};
D.renderToolbar=function(r,c){if(c.getShowToolbar()){r.renderControl(c._getToolbar());}};
D.renderFilterArea=function(r,c){var f=c.getFilter();if(c.getShowFilter()){q.each(f,function(i,F){r.renderControl(F);});}};
return D;},true);
sap.ui.predefine('sap/ui/ux3/DataSetSimpleView',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library','./DataSetSimpleViewRenderer','sap/base/Log',"sap/ui/model/ChangeReason"],function(q,C,R,l,D,L,a){"use strict";
var b=C.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{floating:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:"Name of this View"},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},responsive:{type:"boolean",group:"Misc",defaultValue:false},itemMinWidth:{type:"int",group:"Misc",defaultValue:0},initialItemCount:{type:"int",group:"Appearance",defaultValue:0},reloadItemCount:{type:"int",group:"Appearance",defaultValue:0},scrollArea:{type:"any",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false}}}});
b.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount());}this._bUsePagination=false;};
b.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.handleSelection=function(e){var d=this.getParent();var i=d.getItems(),s=d.getSelectedIndices();if(s.length>1){this._clearTextSelection();}q.each(i,function(c,f){if(d.isSelectedIndex(c)){f.$().addClass("sapUiUx3DSSVSelected");}else{f.$().removeClass("sapUiUx3DSSVSelected");}});};
b.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};
b.prototype.isItemSelected=function(i){var I=this.items.indexOf(i);if(I==-1){return false;}return this.getParent().isSelectedIndex(I);};
b.prototype.initView=function(I){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(I);for(var i=0;i<I.length;i++){var t=this.getTemplate().clone();I[i].setAggregation('_template',t,true);}};
b.prototype.updateView=function(d){var i;if(!this.getDomRef()){for(i=0;i<d.length;i++){if(d[i].type==="delete"){d[i].item.destroy();}}return;}var r=sap.ui.getCore().createRenderManager(),c=this.items.length;for(i=0;i<d.length;i++){var I=d[i].item;var e=d[i].index;if(d[i].type==="insert"){var t=this.getTemplate().clone();I.setAggregation('_template',t,true);if(i==d.length-1&&c==0){var o={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(a.Change);t.removeDelegate(o);}};t.addDelegate(o,false,this);}this.getRenderer().renderItem(r,this,I);r.flush(this.$()[0],false,e);this.items.splice(e,0,I);}else{this.items.splice(e,1);I.$().remove();I.destroy();}}if(d.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true);}r.destroy();};
b.prototype.exitView=function(I){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var i=0;i<I.length;i++){I[i].destroyAggregation("_template",true);}this.items=[];};
b.prototype.initScrollArea=function(){var $=this.getScrollArea(),t=this;var s=function(e){t.getParent().updateItems(a.Change);};if(typeof $==='string'){$=q(document.getElementById($));}if(!$){$=this.$();}else if($.is('html')){$=q(document);}if(!this._bUsePagination){$.off('scroll',s);}else{$.on('scroll',s);}};
b.prototype.checkScrollItems=function(){if(!this._bRendered){return;}var B=this.getParent().mBindingInfos["items"],$=this.getScrollArea(),o=B.binding,p=this.getParent(),A=0,f,s,c,S;if(p.getItems().length===o.getLength()){return A;}if(typeof $==='string'){$=q(document.getElementById($));}if(!$){$=this.$();}if(!$||$.length==0){return A;}s=$[0];c=s.clientHeight;S=s.scrollHeight;if($.is('html')){$=q(document);}if(c==S){f=c+this._iScrollTrigger;}else{f=c+this._iScrollTrigger+$.scrollTop();}if(f>0){var n=Math.floor(f/this._iRowHeight)*this._iItemsPerRow;var i=p.getItems().length;n=Math.ceil(n/this._iItemsPerRow)*this._iItemsPerRow;A=n-i;}return A;};
b.prototype.getItemCount=function(){if(this._bUsePagination){var i=this.getParent().getItems().length,A=this.checkScrollItems();if(i==0){i+=this.getInitialItemCount();}else{i+=A;}return i;}else{return null;}};
b.prototype.setInitialItemCount=function(v){this.setProperty("initialItemCount",v);this._bUsePagination=(v!=0);return this;};
b.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
b.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if((this.getFloating()&&this.getResponsive())||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=R.register(this.getDomRef(),q.proxy(this.onresize,this));}};
b.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(a.Change);}};
b.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}if(this.getFloating()&&this.getResponsive()){this._computeWidths();}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(a.Change);}};
b.prototype.setTemplate=function(t){this.setAggregation("template",t,true);if(this.getParent()){this.getParent().updateItems();}return this;};
b.prototype.calculateItemCounts=function(){if(this.getDomRef()&&sap.ui.getCore().isThemeApplied()){var $=this.$(),c=$.children().first();this._iItemsPerRow=Math.floor($.outerWidth(true)/c.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=c.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight;}};
b.prototype._computeWidths=function(i){var t=this.$();var I=Math.floor(t.width()/this.getItemMinWidth());var c=Math.floor(100/I);if(t.width()*c/100<this.getItemMinWidth()){I--;c=Math.floor(100/I);}if(i||this._height!=t.height()||this._itemsPerRow!=I){var d=-1;var e=this.getParent().getItems();var f,w;for(var j=0;j<e.length;j++){if(d==-1||d+1>I){d=0;f=100-(I*c);}var w=c;if(f>0){w++;f--;}e[j].$().css("width",w+"%");d++;}this._height=t.height();this._itemsPerRow=I;}};
b.prototype.setScrollArea=function(s,S){if(typeof s!=='string'&&!(s instanceof q)){L.error('You can only pass a string (ID of scroll area DOM) or a jQuery object as scrollarea');}this.setProperty('scrollArea',s,S);return this;};
return b;});
sap.ui.predefine('sap/ui/ux3/DataSetSimpleViewRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3DSSV");if(c.getFloating()){if(c.getResponsive()){r.addClass("sapUiUx3DSSVResponsive");}else{r.addClass("sapUiUx3DSSVFloating");}}else{r.addClass("sapUiUx3DSSVSingleRow");}if(c.getHeight()){r.addStyle("height",c.getHeight());r.addClass("sapUiUx3DSSVSA");}r.writeClasses();r.writeStyles();r.write(">");if(c.items){for(var i=0;i<c.items.length;i++){this.renderItem(r,c,c.items[i]);}}r.write("</div>");};
D.renderItem=function(r,c,i){r.write("<div");r.addClass("sapUiUx3DSSVItem");if(c.getFloating()){r.addClass("sapUiUx3DSSVFlow");if(c.getItemMinWidth()>0){r.writeAttribute("style","min-width:"+c.getItemMinWidth()+"px");}}if(c.isItemSelected(i)){r.addClass("sapUiUx3DSSVSelected");}r.writeClasses();r.writeElementData(i);r.write(">");r.renderControl(i.getAggregation("_template"));r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/ui/ux3/Exact',['sap/ui/commons/Button','sap/ui/commons/Menu','sap/ui/commons/SearchField','sap/ui/commons/TextView','sap/ui/core/Control','./ExactArea','./ExactAttribute','./ExactBrowser','./library','./ExactRenderer','sap/ui/commons/library'],function(B,M,S,T,C,E,a,b,l,c,d){"use strict";var e=d.TextViewDesign;
var f=C.extend("sap.ui.ux3.Exact",{metadata:{library:"sap.ui.ux3",properties:{resultText:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"attributes",aggregations:{settingsMenu:{type:"sap.ui.commons.Menu",multiple:false,forwarding:{idSuffix:"-browser",aggregation:"optionsMenu"}},attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-browser",aggregation:"attributes"}},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},events:{search:{parameters:{query:{type:"string"}}},refineSearch:{parameters:{query:{type:"string"},changedAttribute:{type:"sap.ui.ux3.ExactAttribute"},allSelectedAttributes:{type:"object"}}}}}});
f.prototype.init=function(){var t=this;this._searchArea=new E(this.getId()+"-searchArea",{toolbarVisible:false});this._searchArea.addStyleClass("sapUiUx3ExactSearchArea");this.addAggregation("controls",this._searchArea);this._search_input=new S(this.getId()+"-searchTF",{enableListSuggest:false});this._search_input.attachSearch(function(o){_(t,o);});this._search_input.addStyleClass("sapUiUx3ExactSearchText");this._searchArea.addContent(this._search_input);this._browser=new b(this.getId()+"-browser",{title:"Attributes"});this._browser.addStyleClass("sapUiUx3ExactBrowseArea");this.addAggregation("controls",this._browser);this._browser.attachAttributeSelected(function(o){g(t,o);});this._resultArea=new E(this.getId()+"-resultArea");this.addAggregation("controls",this._resultArea);this._resultText=new T(this.getId()+"-resultAreaTitle",{design:e.Bold});this._resultText.addStyleClass("sapUiUx3ExactViewTitle");this.addAggregation("controls",this._resultText);this._bDetailsVisible=false;};
f.prototype.getResultText=function(){return this._resultText.getText();};
f.prototype.setResultText=function(r){this._resultText.setText(r);return this;};
f.prototype.getResultArea=function(){return this._resultArea;};
f.prototype.getSearchField=function(){return this._search_input;};
var _=function(t,o){t._sSearchQuery=o.getParameter("query");t.fireSearch({query:t._sSearchQuery});t._bDetailsVisible=true;t.invalidate();};var g=function(t,o){t.fireRefineSearch({query:t._sSearchQuery,changedAttribute:o.getParameter("attribute"),allSelectedAttributes:o.getParameter("allAttributes")});};return f;});
sap.ui.predefine('sap/ui/ux3/ExactArea',['sap/ui/commons/Toolbar','sap/ui/core/Control','./library','./ExactAreaRenderer','sap/ui/core/Element'],function(T,C,l,E,a){"use strict";
var b=C.extend("sap.ui.ux3.ExactArea",{metadata:{library:"sap.ui.ux3",properties:{toolbarVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolbarItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"toolbarItem"}}}});
a.extend("sap.ui.ux3.ExactAreaToolbarTitle",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],properties:{text:{name:"text",type:"string",group:"Appearance",defaultValue:''}}}});
return b;});
sap.ui.predefine('sap/ui/ux3/ExactAreaRenderer',["sap/ui/commons/ToolbarRenderer","sap/base/security/encodeXML"],function(T,e){"use strict";var E={};
E.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3ExactArea");r.writeClasses();r.write(">");if(c.getToolbarVisible()){r.write("<div id=\""+c.getId()+"-tb\" class=\"sapUiTb sapUiTbDesignFlat sapUiTbStandalone\" role=\"toolbar\">");r.write("<div class=\"sapUiTbCont\"><div class=\"sapUiTbInner\">");var t=c.getToolbarItems();for(var i=0;i<t.length;i++){var o=t[i];if(o instanceof sap.ui.commons.ToolbarSeparator){T.renderSeparator(r,o);}else if(o instanceof sap.ui.ux3.ExactAreaToolbarTitle){r.write("<div class=\"sapUiUx3ExactAreaTbTitle\">"+e(o.getText())+"</div>");}else{r.renderControl(o);}}r.write("</div></div></div>");}r.write("<div id=\""+c.getId()+"-ct\" class=\"sapUiUx3ExactAreaCont\">");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");r.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactAttribute',['sap/ui/core/Element','./library'],function(E,l){"use strict";var a=l.ExactOrder;
var b=E.extend("sap.ui.ux3.ExactAttribute",{metadata:{library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Misc",defaultValue:null},width:{type:"int",group:"Misc",defaultValue:168},listOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:a.Select},showSubAttributesIndicator:{type:"boolean",group:"Misc",defaultValue:true},additionalData:{type:"object",group:"Misc",defaultValue:null},supplyActive:{type:"boolean",group:"Misc",defaultValue:true},autoActivateSupply:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute"}},events:{supplyAttributes:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"}}}}}});
b._MINWIDTH=70;b._MAXWIDTH=500;
b.prototype.init=function(){this._getAttributesCallCount=0;};
b.prototype.scrollTo=function(A){if(!(A instanceof b)){this._scrollToAttributeId=undefined;return;}var L=this.getChangeListener();if(L){L=sap.ui.getCore().byId(L.id);if(L&&L._lb){var i=this.indexOfAttribute(A);if(i>=0){L._lb.scrollToIndex(i,true);}this._scrollToAttributeId=undefined;return;}}this._scrollToAttributeId=A.getId();};
b.prototype.setText=function(t){this.setProperty("text",t,true);this._handleChange(this,"text");return this;};
b.prototype.setWidth=function(w){this._setWidth(w);this._handleChange(this,"width");return this;};
b.prototype.setTooltip=function(t){E.prototype.setTooltip.apply(this,arguments);this._handleChange(this,"tooltip",true);return this;};
b.prototype.setSelected=function(s){this.setProperty("selected",s,true);if(!this.getSelected()){this._clearSelection();}this._handleChange(this,"selected");return this;};
b.prototype.setSupplyActive=function(s){this.setProperty("supplyActive",s,true);return this;};
b.prototype.setAutoActivateSupply=function(A){this.setProperty("autoActivateSupply",A,true);return this;};
b.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);return this;};
b.prototype.setListOrder=function(L){this.setProperty("listOrder",L,true);this._handleChange(this,"order");return this;};
b.prototype.getAttributes=function(){this._getAttributesCallCount++;if(this._getAttributesCallCount>1){this.setSupplyActive(false);}if(this.hasListeners("supplyAttributes")&&this.getSupplyActive()){this._bSuppressChange=true;this._bChangedHappenedDuringSuppress=false;this.fireSupplyAttributes({attribute:this});this.setSupplyActive(false);this._bSuppressChange=undefined;if(this._bChangedHappenedDuringSuppress){this._handleChange(this,"attributes");}this._bChangedHappenedDuringSuppress=undefined;}this._getAttributesCallCount--;return this.getAttributesInternal();};
b.prototype.insertAttribute=function(A,i){this.insertAggregation("attributes",A,i,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this;};
b.prototype.addAttribute=function(A){this.addAggregation("attributes",A,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this;};
b.prototype.removeAttribute=function(e){var A=this.removeAggregation("attributes",e,true);if(A){A.setChangeListener(null);this._handleChange(this,"attributes");}return A;};
b.prototype.removeAllAttributes=function(){var A=this.getAttributesInternal();for(var i=0;i<A.length;i++){A[i].setChangeListener(null);}var r=this.removeAllAggregation("attributes",true);if(A.length>0){this._handleChange(this,"attributes");}return r;};
b.prototype.destroyAttributes=function(){var A=this.getAttributesInternal();for(var i=0;i<A.length;i++){A[i].setChangeListener(null);}this.destroyAggregation("attributes",true);if(A.length>0){this._handleChange(this,"attributes");}return this;};
b.prototype.getShowSubAttributesIndicator_Computed=function(){return this.hasListeners("supplyAttributes")&&this.getSupplyActive()?this.getShowSubAttributesIndicator():this.getAttributesInternal().length>0;};
b.prototype.attachSupplyAttributes=function(d,f,L){this.attachEvent("supplyAttributes",d,f,L);if(this.getSelected()){this.getAttributesInternal(true);}return this;};
b.prototype._setProperty_Orig=b.prototype.setProperty;
b.prototype.setProperty=function(p,v,s){this._setProperty_Orig(p,v,s);if(p=="selected"){if(v){this.getAttributesInternal(true);}else{if(this.getAutoActivateSupply()){this.setSupplyActive(true);}}}return this;};
b.prototype.setChangeListener=function(c){this._oChangeListener=c;};
b.prototype.getChangeListener=function(c){return this._oChangeListener;};
b.prototype.getAttributesInternal=function(f){return f?this.getAttributes():this.getAggregation("attributes",[]);};
b.prototype._handleChange=function(s,t){if(this._bSuppressChange){this._bChangedHappenedDuringSuppress=true;return;}if(this.getChangeListener()){this.getChangeListener()._notifyOnChange(t,s);}else if(this.getParent()&&this.getParent()._handleChange){this.getParent()._handleChange(s,t);}};
b.prototype._clearSelection=function(){this.setProperty("selected",false,true);var v=this.getAttributesInternal();for(var i=0;i<v.length;i++){v[i]._clearSelection();}};
b.prototype._setWidth=function(w){w=Math.round(b._checkWidth(w));this.setProperty("width",w,true);};
b._checkWidth=function(w){w=Math.max(w,b._MINWIDTH);w=Math.min(w,b._MAXWIDTH);return w;};
return b;});
sap.ui.predefine('sap/ui/ux3/ExactBrowser',['sap/ui/commons/Button','sap/ui/commons/Menu','sap/ui/core/Control','./ExactAttribute','./ExactList','./library','./ExactBrowserRenderer','sap/ui/core/Popup'],function(B,M,C,E,a,l,b,P){"use strict";var D=P.Dock;var c=l.ExactOrder;
var d=C.extend("sap.ui.ux3.ExactBrowser",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},headerTitle:{type:"string",group:"Misc",defaultValue:null},topListOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:c.Select},enableListClose:{type:"boolean",group:"Misc",defaultValue:false},listHeight:{type:"int",group:"Appearance",defaultValue:290},showHeader:{type:"boolean",group:"Misc",defaultValue:false},showTopList:{type:"boolean",group:"Misc",defaultValue:true},enableReset:{type:"boolean",group:"Misc",defaultValue:true},enableSave:{type:"boolean",group:"Misc",defaultValue:false},topListWidth:{type:"int",group:"Misc",defaultValue:168}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-rootAttribute",aggregation:"attributes"}},optionsMenu:{type:"sap.ui.commons.Menu",multiple:false},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"},rootAttribute:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{followUpControl:{type:"sap.ui.core.Control",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}},save:{}}}});
d.prototype.init=function(){var t=this;this.data("sap-ui-fastnavgroup","true",true);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._attributeRoot=new E(this.getId()+"-rootAttribute");this.setAggregation("rootAttribute",this._attributeRoot);this._rootList=new a(this.getId()+"-rootlist");this._rootList.setData(this._attributeRoot);this.addAggregation("controls",this._rootList);this._resetButton=new B(this.getId()+"-RstBtn",{text:this._rb.getText("EXACT_BRWSR_RESET"),lite:true});this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");this.addAggregation("controls",this._resetButton);this._resetButton.attachPress(function(){t.reset();});this._saveButton=new B(this.getId()+"-SvBtn",{text:this._rb.getText("EXACT_BRWSR_SAVE"),lite:true});this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");this.addAggregation("controls",this._saveButton);this._saveButton.attachPress(function(){t.fireSave();});this._rootList.attachAttributeSelected(function(e){t.fireAttributeSelected({attribute:e.getParameter("attribute"),allAttributes:e.getParameter("allAttributes")});});this._rootList.attachEvent("_headerPress",function(e){var m=t.getOptionsMenu();if(m){var o=e.getParameter("domRef");m.open(e.getParameter("keyboard"),o,D.BeginTop,D.BeginBottom,o);}});};
d.prototype.exit=function(){this._rootList.destroy();this._attributeRoot.destroy();this._rootList=null;this._attributeRoot=null;this._resetButton=null;this._saveButton=null;this._saveDialog=null;this._saveTextField=null;this._rb=null;};
d.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
d.prototype.getTitle=function(){return this._rootList.getTopTitle();};
d.prototype.setTitle=function(t){this._rootList.setTopTitle(t);return this;};
d.prototype.setTopListOrder=function(L){this.setProperty("topListOrder",L,true);this._attributeRoot.setListOrder(L);return this;};
d.prototype.getTopListWidth=function(){return this._attributeRoot.getWidth();};
d.prototype.setTopListWidth=function(w){this._attributeRoot.setWidth(w);return this;};
d.prototype.getHeaderTitle=function(){var t=this.getProperty("headerTitle");return t?t:this._rb.getText("EXACT_BRWSR_TITLE");};
d.prototype.getEnableListClose=function(){return this._rootList.getShowClose();};
d.prototype.setEnableListClose=function(e){this._rootList.setShowClose(e);return this;};
d.prototype.getListHeight=function(){return this._rootList.getTopHeight();};
d.prototype.setListHeight=function(L){this._rootList.setTopHeight(L);return this;};
d.prototype.reset=function(){this._rootList._closeAll();};
d.prototype.hasOptionsMenu=function(){return!!this.getOptionsMenu();};
return d;});
sap.ui.predefine('sap/ui/ux3/ExactBrowserRenderer',["sap/base/security/encodeXML"],function(e){"use strict";var E={};
E.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3ExactBrwsr");r.writeClasses();r.writeAttribute("role","region");if(c.getShowHeader()){r.writeAttribute("aria-labelledby",c.getId()+"-hdtitle");}if(c.getFollowUpControl()){r.writeAttribute("aria-controls",c.getFollowUpControl());}var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(c.getShowHeader()){r.write("<div class=\"sapUiUx3ExactBrwsrHd\"><h2 id=\""+c.getId()+"-hdtitle\">");r.write(e(c.getHeaderTitle()));r.write("</h2><div class=\"sapUiUx3ExactBrwsrHdTool\" role=\"toolbar\">");if(c.getEnableSave()){r.renderControl(c._saveButton);}if(c.getEnableReset()){r.renderControl(c._resetButton);}r.write("</div></div>");}r.renderControl(c._rootList);r.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactList',['sap/ui/thirdparty/jquery','sap/ui/commons/ListBox','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./library','./ExactListRenderer','sap/ui/core/delegate/ItemNavigation','sap/ui/ux3/ExactAttribute','sap/ui/core/ListItem','sap/ui/dom/getScrollbarSize','sap/ui/events/KeyCodes','sap/ui/dom/containsOrEquals','sap/ui/events/ControlEvents','sap/ui/Device','sap/base/security/encodeXML'],function(q,L,C,P,a,l,E,I,b,c,g,K,d,e,D,f){"use strict";var h=l.ExactOrder;
var j=C.extend("sap.ui.ux3.ExactList",{metadata:{library:"sap.ui.ux3",properties:{showClose:{type:"boolean",group:"Misc",defaultValue:false},topTitle:{type:"string",group:"Misc",defaultValue:null},topHeight:{type:"int",group:"Appearance",defaultValue:290}},aggregations:{subLists:{type:"sap.ui.ux3.ExactList",multiple:true,singularName:"subList"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},associations:{data:{type:"sap.ui.ux3.ExactAttribute",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}}}}});
L.extend("sap.ui.ux3.ExactList.LB",{
init:function(){L.prototype.init.apply(this,arguments);this.setAllowMultiSelect(true);this.setDisplayIcons(true);this.addStyleClass("sapUiUx3ExactLstLb");},
invalidate:function(){L.prototype.invalidate.apply(this,arguments);if(!this.bInvalidated&&this.getParent()){this.getParent().invalidate();}this.bInvalidated=true;},
_handleUserActivation:function(i){i.metaKey=true;L.prototype._handleUserActivation.apply(this,[i]);},
onclick:function(i){L.prototype.onclick.apply(this,arguments);this.getParent().onclick(i);},
onAfterRendering:function(){L.prototype.onAfterRendering.apply(this,arguments);this.bInvalidated=false;var s=this.getParent();var S=this.getItems();var T=s._isTop();var U=false;for(var i=0;i<S.length;i++){var V=S[i];var W=sap.ui.getCore().byId(V.getKey());var X=V.$();U=false;if(T||(!W||!W.getShowSubAttributesIndicator_Computed())){X.addClass("sapUiUx3ExactLstNoIco");U=T;}else{U=true;}if(U&&!T){X.attr("aria-label",s._rb.getText(X.hasClass("sapUiLbxISel")?"EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL":"EXACT_LST_LIST_ITEM_ARIA_LABEL",[V.getText()]));}}var Y=s._bRTL?"left":"right";q(".sapUiLbxITxt",this.getDomRef()).css("margin-"+Y,20+g().width+"px");q(".sapUiLbxIIco",this.getDomRef()).css(Y,5+g().width+"px");q(this.getDomRef()).attr("tabindex","-1");var Z;if(T){Z=s.getTopTitle();}else{Z=s._rb.getText("EXACT_LST_LIST_ARIA_LABEL",[s._iLevel,s._getAtt().getText()]);}q(this.getFocusDomRef()).attr("aria-label",Z).attr("aria-expanded","true");this.oItemNavigation.iActiveTabIndex=-1;this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.onsapnext=function($){if($.keyCode!=K.ARROW_DOWN){return;}I.prototype.onsapnext.apply(this,arguments);};this.oItemNavigation.onsapprevious=function($){if($.keyCode!=K.ARROW_UP){return;}I.prototype.onsapprevious.apply(this,arguments);};},
renderer:"sap.ui.commons.ListBoxRenderer"
});
j.prototype.init=function(){var i=this;this._iLevel=0;this._bCollapsed=false;this._bIsFirstRendering=true;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._lb=new j.LB(this.getId()+"-lb",{select:function(s){z(i);var S=s.getParameter("selectedItem").getKey();var T=sap.ui.getCore().byId(S);var U=s.getParameter("selectedIndex");if(i._lb.isIndexSelected(U)){T.setProperty("selected",true,true);var V=M(i,T);if(V){var W=r(i,T);if(W<0){i.addSubList(V);}else{i.insertSubList(V,W);}}}else{N(i,T,U);}Q(i)._selectionChanged(T);}});this.addAggregation("controls",this._lb);this._closeHandle=q.proxy(this.onForceVerticalClose,this);};
j.prototype.exit=function(){if(this.bIsDestroyed){return;}O(this);this._lb.removeAllItems();this._lb=null;this._closeHandle=null;this._scrollCheckHandle=null;this._rb={getText:function(){return"";}};this._oTopList=null;if(this._dirtyListsCleanupTimer){clearTimeout(this._dirtyListsCleanupTimer);this._dirtyListsCleanupTimer=null;this._dirtyLists=null;}};
j.prototype.getFocusDomRef=function(){if(this._isTop()&&this.$().hasClass("sapUiUx3ExactLstTopHidden")){return this.getDomRef("foc");}return this._bCollapsed?this.getDomRef("head"):this._lb.getFocusDomRef();};
j.prototype.onBeforeRendering=function(){this._oTopList=null;if(!this._bIsFirstRendering){return;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(!this._isTop()){this._bCollapsed=true;this._oCollapseStyles={"cntnt":"margin-"+(this._bRTL?"right":"left")+":"+a.get("sapUiUx3ExactLstCollapseWidth")+";border-top-width:0px;","lst":"width:0px;"};}else{this._bIsFirstRendering=false;}};
j.prototype.onAfterRendering=function(){var i=this;var s=this._isTop();if(!this._iCurrentWidth){this._iCurrentWidth=this._getAtt().getWidth();}if(s){this._iScrollWidthDiff=-1;this.onCheckScrollbar();this.$("lst").css("bottom",g().height+"px");this.$("cntnt").bind("scroll",function(S){if(S.target.id===i.getId()+"-cntnt"&&S.target.scrollTop!=0){S.target.scrollTop=0;}});}if(!this._bCollapsed){y(this,this._iCurrentWidth);}z(this);if(this._bIsFirstRendering){this._bIsFirstRendering=false;F(this,false,null,true);}else{t(this);G(this);}if(this._bRefreshList){this._bRefreshList=false;setTimeout(function(){i._lb.invalidate();},0);}};
j.prototype.onfocusin=function(i){if(i.target===this.getDomRef()){this.getFocusDomRef().focus();}var $=this.$("head");if(this._isTop()){$.attr("tabindex","-1");this.$("foc").attr("tabindex","-1");if(!o(this)&&i.target===$[0]){this.getFocusDomRef().focus();}if(this.$().hasClass("sapUiUx3ExactLstTopHidden")&&i.target===this.getDomRef("foc")){var s=this.getSubLists();if(s.length>0){s[0].getFocusDomRef().focus();}}}if(!i.__exactHandled){$.addClass("sapUiUx3ExactLstHeadFocus");i.__exactHandled=true;}};
j.prototype.onfocusout=function(i){var $=this.$("head");if(this._isTop()){$.attr("tabindex","0");this.$("foc").attr("tabindex","0");}$.removeClass("sapUiUx3ExactLstHeadFocus");};
j.prototype.onclick=function(i){var s=this._lb.getScrollTop();if(q(i.target).attr("id")==this.getId()+"-exp"){H(this);this.focus();i.stopPropagation();}else if(q(i.target).attr("id")==this.getId()+"-close"){J(this);}else if(q(i.target).attr("id")==this.getId()+"-hide"){F(this,!this._bCollapsed,i);}else if(this._isTop()&&o(this)&&d(this.$("head")[0],i.target)){n(this,i,false);return;}else if(!d(this.$("cntnt")[0],i.target)){this.focus();}this._lb.setScrollTop(s);};
j.prototype.onkeydown=function(i){function _(i,T){if(q(T).hasClass("sapUiUx3ExactLstFoc")){return;}if(T){T.focus();}i.preventDefault();i.stopPropagation();}switch(i.keyCode){case K.ENTER:case K.SPACE:if(this._isTop()&&o(this)&&d(this.$("head")[0],i.target)){n(this,i,true);}break;case K.DELETE:if(!this._isTop()&&this.getShowClose()){J(this);_(i,this.getParent().getFocusDomRef());}break;case K.NUMPAD_MINUS:if(i.shiftKey){if(!this._bCollapsed){y(this,this._iCurrentWidth-10);_(i);}}else if(!this._bCollapsed){F(this,true,i);}break;case K.NUMPAD_PLUS:if(i.shiftKey){if(!this._bCollapsed){y(this,this._iCurrentWidth+10);_(i);}}else if(this._bCollapsed){F(this,false,i);}break;case K.TAB:if(this._iLevel==0){var s=o(this);if(!i.shiftKey&&s&&d(this.$("head")[0],i.target)){_(i,this.getFocusDomRef());}else if(d(this.getFocusDomRef(),i.target)){if(i.shiftKey&&s){_(i,this.$("head")[0]);}else if(!i.shiftKey){var S=m(this);if(S){_(i,S.getFocusDomRef());}}}return;}if(this._iLevel==1){var S=null;if(i.shiftKey){if(d(this.$("cntnt")[0],i.target)){S=this;}else{S=k(this);}}else{S=m(this);}if(S){_(i,S.getFocusDomRef());}i.stopPropagation();}break;case K.ARROW_LEFT:case K.ARROW_RIGHT:var S=null;if(this._iLevel>=1){if((this._bRTL&&i.keyCode===K.ARROW_LEFT)||(!this._bRTL&&i.keyCode===K.ARROW_RIGHT)){S=m(this,true);}else{S=k(this,true);}if(S){_(i,S.getFocusDomRef());}i.stopPropagation();}break;}};
j.prototype.onmousedown=function(i){if(i.target.id===this.getId()+"-rsz"){q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiUx3ExactLstRSzGhost\" style =\" z-index:"+P.getNextZIndex()+"\" ></div>");q(document.body).bind("selectstart."+this.getId(),v);var s=D.browser.msie?q(document.body):this.$("ghost");s.bind("mouseup."+this.getId(),q.proxy(x,this)).bind("mousemove."+this.getId(),q.proxy(w,this));this._iStartDragX=i.pageX;this._iStartWidth=this.$("lst").width();this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag");}};
j.prototype.onForceVerticalClose=function(i){if(i.type=="mousedown"||i.type=="click"||i.type=="dblclick"||i.type=="focusin"||i.type=="focusout"||i.type=="keydown"||i.type=="keypress"||i.type=="keyup"||i.type=="mousedown"||i.type=="mouseup"){var s=this.$("lst");if(!d(s[0],i.target)||i.target.tagName=="BODY"){if(s.hasClass("sapUiUx3ExactLstExpanded")){this._oPopup.close(true);}}}};
j.prototype.onCheckScrollbar=function(i){this._scrollCheckTimer=null;var s=this.$("cntnt");var S=s[0];if(S){var T=S.scrollWidth-S.clientWidth;if(this._iScrollWidthDiff!=T){this._iScrollWidthDiff=T;if(T<=0){s.css({"overflow-x":"hidden","bottom":g().height+"px"});}else{s.css({"overflow-x":"scroll","bottom":"0px"});}}this._scrollCheckTimer=setTimeout(this.onCheckScrollbar.bind(this),300);}};
j.prototype.insertSubList=function(s,i){this.insertAggregation("subLists",s,i);if(s){A(s,this._iLevel+1);}return this;};
j.prototype.addSubList=function(s){this.addAggregation("subLists",s);if(s){A(s,this._iLevel+1);}return this;};
j.prototype.setData=function(s){if(s!=null&&typeof(s)!="string"){s=s.getId();}if(s){this.setAssociation("data",s);s=this._getAtt();this._lb.removeAllItems();if(!s){return this;}var S=s.getAttributesInternal(true);var T=[];var U=[];for(var i=0;i<S.length;i++){var V=R(S[i]);this._lb.addItem(V);if(S[i].getSelected()){var W=M(this,S[i]);if(W){U.push(W);}T.push(V.getKey());}}this._lb.setSelectedKeys(T);var X=this.getSubLists();for(var i=0;i<X.length;i++){var Y=U.indexOf(X[i]);if(Y>=0){if(s.getListOrder()!=h.Fixed){U.splice(Y,1);}}else{X[i]._lb.removeAllItems();X[i].destroy();}}if(s.getListOrder()===h.Fixed){this.removeAllSubLists();}for(var i=0;i<U.length;i++){this.addSubList(U[i]);}var Z=this;s.setChangeListener({id:Z.getId(),_notifyOnChange:function($,_){if($==="width"){if(Z._getAtt()===_&&Z.getDomRef()){y(Z,_.getWidth());}return;}var a1=Q(Z);if(!a1._dirtyLists){a1._dirtyLists={};}if(!a1._dirtyLists[Z.getId()]){a1._dirtyLists[Z.getId()]=Z;}if(!a1._dirtyListsCleanupTimer){a1._dirtyListsCleanupTimer=setTimeout(function(){this._dirtyListsCleanupTimer=null;q.each(this._dirtyLists,function(i,W){if(W._lb&&W.getParent()){if(!W._isTop()){W.getParent().setData(W.getParent().getData());}else{W.setData(W.getData());}}});this._dirtyLists=null;}.bind(a1),0);}}});}return this;};
j.prototype.setShowClose=function(s){if(this._isTop()){this.setProperty("showClose",s);}return this;};
j.prototype.getShowClose=function(){return Q(this).getProperty("showClose");};
j.prototype.getTopTitle=function(){var T=this.getProperty("topTitle");return T?T:this._rb.getText("EXACT_BRWSR_LST_TITLE");};
j.prototype._getAtt=function(){return sap.ui.getCore().byId(this.getData());};
j.prototype._isTop=function(){return!(this.getParent()instanceof j);};
j.prototype._selectionChanged=function(i){if(!this._isTop()){return;}i=sap.ui.getCore().byId(i.getId());var _=function(U,V){if(!U.getSelected()){return;}V.push(U);var W=U.getAttributesInternal();for(var S=0;S<W.length;S++){_(W[S],V);}};var s=[];var T=this._getAtt().getAttributesInternal();for(var S=0;S<T.length;S++){_(T[S],s);}this.fireAttributeSelected({attribute:i,allAttributes:s});};
j.prototype._closeAll=function(){if(!this._isTop()){return;}var s=this;var S=function(){s._getAtt()._clearSelection();s._lb.clearSelection();s.fireAttributeSelected({attribute:undefined,allAttributes:[]});};var T=this.getSubLists();if(T.length>0){for(var i=0;i<T.length;i++){J(T[i],true,i==T.length-1?S:null);}}else{S();}};
var k=function(i,s){function S(W){var X=W.getParent();var Y=X.getSubLists();var Z=X.indexOfSubList(W)-1;if(Z>=0){return Y[Z];}return null;}function T(W){var X=W.getSubLists();if(X.length>0){return T(X[X.length-1]);}return W;}if(i._iLevel==0){return null;}else if(i._iLevel==1){if(s){return null;}var U=S(i);if(U){return U;}return i.getParent();}else if(i._iLevel>1){var U=S(i);if(U){return T(U);}var V=i.getParent();if(V._iLevel>=1){return V;}}return null;};var m=function(i,s){function S(W){var X=W.getParent();var Y=X.getSubLists();var Z=X.indexOfSubList(W)+1;if(Z<Y.length){return Y[Z];}return null;}function T(W){var X=W.getSubLists();if(X.length>0){return X[0];}return null;}function U(W){var X=S(W);if(X){return X;}var Y=W.getParent();if(Y._iLevel>(s?1:0)){return U(Y);}else{return null;}}if(i._iLevel==0){return T(i);}else if(i._iLevel==1){return s?T(i):S(i);}else if(i._iLevel>1){var V=T(i);if(V){return V;}return U(i);}return null;};var n=function(i,s,S){i.fireEvent("_headerPress",{kexboard:S,domRef:i.$("head")});s.stopPropagation();};var o=function(i){return!p(i)&&i.$().hasClass("sapUiUx3ExactLstTopActive");};var p=function(i){return i.$().hasClass("sapUiUx3ExactLstTopHidden");};var r=function(s,S){if(s._getAtt().getListOrder()!=h.Fixed){return-1;}var T=s._getAtt().getAttributes();var U=0;for(var i=0;i<T.length;i++){if(T[i]===S){break;}if(T[i].getChangeListener()){U++;}}return U;};var t=function(i){if(B(i)){i.$("lst").addClass("sapUiUx3ExactLstLstExp");if(!i._oPopup){var s=function(S){i._handleEvent(S);};i._oPopup=new P();if(!D.browser.firefox){i._oPopup._fixPositioning=function(S,T){P.prototype._fixPositioning.apply(this,arguments);if(T){var $=this._$();var U=q(S.of);var V=0;if(S.offset){V=parseInt(S.offset.split(" ")[0]);}$.css("right",(q(window).width()-U.outerWidth()-U.offset().left+V)+"px");}};}i._oPopup.open=function(){var S=i.$("lst");u(S,false,-1,function(T){S.addClass("sapUiUx3ExactLstExpanded");i.$("exp").html(E.getExpanderSymbol(true,false));i.__sOldHeight=S.css("height");S.css("height",i.__sOldHeight);var U=i.$("head");var V=q(i._lb.getDomRef());var W=V[0].scrollHeight+i.$("exp").height()+V.outerHeight()-V.height()+1;var X=q(window).height()-parseInt(V.offset().top)+q(window).scrollTop()-U.outerHeight();var Y=Math.min(W,X);i._oPopup.setContent(S[0]);var Z=a.get()["sapUiUx3ExactLst"+(i._isTop()?"Root":"")+"ExpandOffset"]||"0 0";P.prototype.open.apply(i._oPopup,[0,P.Dock.BeginTop,P.Dock.BeginBottom,U[0],Z,"none none"]);i._bPopupOpened=true;return Y;},function(T){S.addClass("sapUiUx3ExactLstExpandedBL");B(i);i.getFocusDomRef().focus();e.bindAnyEvent(i._closeHandle);T.bind(e.events.join(" "),s);});};i._oPopup.close=function(S){var T=i.$("lst");T.removeClass("sapUiUx3ExactLstExpandedBL");u(T,false,i.__sOldHeight,function(U){e.unbindAnyEvent(i._closeHandle);U.unbind(e.events.join(" "),s);T.removeClass("sapUiUx3ExactLstExpanded");i.$("exp").html(E.getExpanderSymbol(false,false));},function(U){U.detach();T.removeClass("sapUiShd");U.attr("style","width:"+i._iCurrentWidth+"px;");q(i.getDomRef()).prepend(U);i._oPopup.setContent(null);i._bPopupOpened=undefined;i.__sOldHeight=null;if(i._isTop()){U.css("bottom",g().height+"px");}B(i);P.prototype.close.apply(i._oPopup,[0]);if(!S){i.getFocusDomRef().focus();}});};}}};var u=function(i,W,V,s,S){if(s){var T=s(i);if(T!=undefined){V=T;}}var _=S?function(){S(i);}:function(){};if(q.fx.off){if(W){i.width(V);}else{i.height(V);}_();}else{var U=W?{width:V}:{height:V};i.stop(true,true).animate(U,200,'linear',_);}};var v=function(i){i.preventDefault();i.stopPropagation();return false;};var w=function(i){var s=i.pageX;var S=this._bRTL?(this._iStartDragX-s):(s-this._iStartDragX);y(this,this._iStartWidth+S);};var x=function(i){q(document.body).unbind("selectstart."+this.getId()).unbind("mouseup."+this.getId()).unbind("mousemove."+this.getId());this.$("ghost").remove();this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");this._iStartWidth=undefined;this._iStartDragX=undefined;this.focus();};var y=function(i,W){W=b._checkWidth(W);var s=i._bRTL?"right":"left";i._iCurrentWidth=W;i._getAtt()._setWidth(i._iCurrentWidth);i.$("lst").css("width",W+"px");i.$("rsz").css(s,(W-4)+"px");if(i._isTop()){if(!p(i)){i.$("head").css("width",W+"px");i.$("cntnt").css(s,(W+8)+"px");i.$("scroll").css(s,(W+8)+"px");}}else{if(!i.$().hasClass("sapUiUx3ExactLstCollapsed")){i.$("cntnt").css("margin-"+s,W+"px");}}};var z=function(i){var s=i._getAtt();if(s&&!i._isTop()){i.$("head-txt").html(f(s.getText())+"<span class=\"sapUiUx3ExactLstHeadInfo\">&nbsp;("+i._lb.getSelectedIndices().length+"/"+i._lb.getItems().length+")</span>");}};var A=function(s,S){s._iLevel=S;var T=s.getSubLists();for(var i=0;i<T.length;i++){A(T[i],S+1);}};var B=function(i){if(i._lb){var s=q(i._lb.getDomRef());i.$("lst").removeClass("sapUiUx3ExactLstScroll");if(s.length>0&&s.outerHeight()<s[0].scrollHeight){i.$("lst").addClass("sapUiUx3ExactLstScroll");return true;}}return false;};var F=function(i,s,S,T){if(S){S.preventDefault();S.stopPropagation();}if(i._isTop()){return;}if(i._bCollapsed!=s){var U=!!S;var V={};V["margin-"+(i._bRTL?"right":"left")]=(i._bCollapsed?(i._iCurrentWidth+"px"):a.get("sapUiUx3ExactLstCollapseWidth"));V["border-top-width"]=(i._bCollapsed?a.get("sapUiUx3ExactLstContentTop"):"0px");var $=i.$("cntnt");if(q.fx.off){for(var W in V){$.css(W,V[W]);}}else{$.stop(true,true).animate(V,200,'linear');}if(i._bCollapsed){u(i.$("lst"),true,i._iCurrentWidth+"px",function(){q(i.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");i.$("head").css("overflow","hidden");},function(Z){i.$("hide").html(E.getExpanderSymbol(true,true)).attr("title",i._rb.getText("EXACT_LST_LIST_COLLAPSE"));if(U){i.focus();}var _=i.$("head");i.$("head-txt").removeAttr("style");_.removeAttr("style");Z.removeAttr("style");t(i);y(i,i._iCurrentWidth);G(i);_.removeAttr("role");_.removeAttr("aria-label");_.removeAttr("aria-expanded");var a1=i._getAtt();if(a1&&a1._scrollToAttributeId){a1.scrollTo(sap.ui.getCore().byId(a1._scrollToAttributeId));}});i._oCollapseStyles=undefined;}else{i._oCollapseStyles={};u(i.$("lst"),true,0,null,function(){q(i.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");i.$("hide").html(E.getExpanderSymbol(false,true)).attr("title",i._rb.getText("EXACT_LST_LIST_EXPAND"));if(U){i.focus();}G(i);var Z=i.$("head");Z.attr("role","region");Z.attr("aria-label",i._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[i._iLevel,i._getAtt().getText()]));Z.attr("aria-expanded","false");});var X=[];for(var W in V){X.push(W,":",V[W],";");}i._oCollapseStyles["cntnt"]=X.join("");i._oCollapseStyles["lst"]="width:0px;";}i._bCollapsed=!i._bCollapsed;}if(T){return;}var Y=i.getParent();if(!i._isTop()&&Y&&Y._isTop&&!Y._isTop()){F(Y,s);}};var G=function(s){if(s._bCollapsed){var W=s.$("cntnt").height()-50;var $=s.$("head-txt");$.css("width",W+"px");}var S=s.getSubLists();for(var i=0;i<S.length;i++){G(S[i]);}};var H=function(i){var s=i.$("lst");if(s.hasClass("sapUiUx3ExactLstExpanded")){i._oPopup.close();}else{i._oPopup.open();}};var J=function(i,s,S){var T=function(V){if(!s){var W=i._getAtt();var X=W.getParent().indexOfAttribute(W);N(i.getParent(),W,X,true);z(i.getParent());Q(i)._selectionChanged(W);}i.destroy();if(S){S();}};var U=i.getDomRef();if(U){u(q(U),true,0,function(V){V.css("overflow","hidden");},T);}else{T();}};var M=function(i,s){if(s.getSelected()){var S=s.getAttributesInternal(true);if(S.length>0){var T;if(s.getChangeListener()){T=sap.ui.getCore().byId(s.getChangeListener().id);}else{T=new j();}T.setData(s);return T;}}return null;};var N=function(s,S,T,U){s._lb.removeSelectedIndex(T);S._clearSelection();if(!U){var V=s.getSubLists();for(var i=0;i<V.length;i++){if(V[i].getData()===S.getId()){J(V[i],true);}}}};var O=function(i){var s=i._getAtt();if(s&&s.getChangeListener()&&s.getChangeListener().id===i.getId()){s.setChangeListener(null);}};var Q=function(i){if(i._isTop()){return i;}if(!i._oTopList){i._oTopList=Q(i.getParent());}return i._oTopList;};var R=function(i){var s;if(i.__oItem){s=i.__oItem;if(s.getText()!=i.getText()){s.setText(i.getText());}if(s.getKey()!=i.getId()){s.setKey(i.getId());}}else{s=new c({text:i.getText(),key:i.getId()});i.exit=function(){if(b.prototype.exit){b.prototype.exit.apply(i,[]);}this.__oItem.destroy();this.__oItem=null;};i.__oItem=s;}return s;};return j;});
sap.ui.predefine('sap/ui/ux3/ExactListRenderer',[],function(){"use strict";var E={};
E.render=function(r,c){var s=c.getSubLists();var a=c._getAtt();if(!a){return;}var I=c._isTop();r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3ExactLst");var A=false;var t=false;if(I){var b=c.getParent();if(b){if(b.hasOptionsMenu){A=b.hasOptionsMenu();if(A){r.addClass("sapUiUx3ExactLstTopActive");}}if(b.getShowTopList&&!b.getShowTopList()){r.addClass("sapUiUx3ExactLstTopHidden");t=true;}}r.addClass("sapUiUx3ExactLstTop");r.addStyle("height",c.getTopHeight()+"px");}if(c._bCollapsed){r.addClass("sapUiUx3ExactLstCollapsed");}r.addClass("sapUiUx3ExactLstLvl_"+c._iLevel);r.writeClasses();r.writeStyles();r.write(">");if(t){r.write("<div id=\""+c.getId()+"-foc\" class=\"sapUiUx3ExactLstFoc\" tabindex=\"0\"></div>");}if(!c._bPopupOpened){r.write("<div id=\""+c.getId()+"-lst\" class=\"sapUiUx3ExactLstLst\"");if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["lst"]){r.write(" style=\""+c._oCollapseStyles["lst"]+"\"");}r.write(">");r.renderControl(c._lb);r.write("<a id=\""+c.getId()+"-exp\" class=\"sapUiUx3ExactLstExp\">"+this.getExpanderSymbol(false,false)+"</a>");r.write("</div>");}else{c._bRefreshList=true;}r.write("<div id=\""+c.getId()+"-cntnt\" ");r.write("class=\"sapUiUx3ExactLstCntnt");if(s.length==0){r.write(" sapUiUx3ExactLstCntntEmpty");}r.write("\"");if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["cntnt"]){r.write(" style=\""+c._oCollapseStyles["cntnt"]+"\"");}r.write(">");for(var i=0;i<s.length;i++){r.renderControl(s[i]);}r.write("</div>");r.write("<header id=\""+c.getId()+"-head\" class=\"sapUiUx3ExactLstHead\"");if(I&&A){r.write(" role=\"button\" aria-haspopup=\"true\"");}if(!I&&c._bCollapsed&&a){r.writeAttribute("role","region");r.writeAttribute("aria-expanded","false");r.writeAttributeEscaped("aria-label",c._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[c._iLevel,a.getText()]));}r.write(" tabindex=\""+(I?"0":"-1")+"\">");if(I){r.write("<h3 id=\""+c.getId()+"-head-txt\" class=\"sapUiUx3ExactLstHeadTopTxt\"><span class=\"sapUiUx3ExactLstHeadTopTxtTxt\">");if(c.getTopTitle()){r.writeEscaped(c.getTopTitle());}r.write("</span>");if(A){r.write("<span class=\"sapUiUx3ExactLstHeadTopIco\"></span>");}r.write("</h3>");}else{r.write("<h3 id=\""+c.getId()+"-head-txt\" class=\"sapUiUx3ExactLstHeadTxt\"");if(a&&a.getTooltip_AsString()){r.writeAttributeEscaped("title",a.getTooltip_AsString());}else if(a&&a.getText()){r.writeAttributeEscaped("title",a.getText());}if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["head-txt"]){r.write(" style=\""+c._oCollapseStyles["head-txt"]+"\"");}r.write(">");if(a){r.writeEscaped(a.getText());}r.write("</h3>");r.write("<div id=\""+c.getId()+"-head-action\" class=\"sapUiUx3ExactLstHeadAct"+(c.getShowClose()?"":" sapUiUx3ExactLstHeadActNoClose")+"\">");r.write("<a id=\""+c.getId()+"-hide\" class=\"sapUiUx3ExactLstHide\" role=\"presentation\"");r.writeAttributeEscaped("title",c._rb.getText(c._bCollapsed?"EXACT_LST_LIST_EXPAND":"EXACT_LST_LIST_COLLAPSE"));r.write(">",this.getExpanderSymbol(!c._bCollapsed,true),"</a>");r.write("<a id=\""+c.getId()+"-close\" role=\"presentation\" class=\"sapUiUx3ExactLstClose\"");r.writeAttributeEscaped("title",c._rb.getText("EXACT_LST_LIST_CLOSE"));r.write(">X</a>");r.write("</div>");}r.write("</header>");r.write("<div id=\""+c.getId()+"-rsz\" class=\"sapUiUx3ExactLstRSz\"></div>");r.write("</div>");};
E.getExpanderSymbol=function(e,h){if(h){if(sap.ui.getCore().getConfiguration().getRTL()){return e?"&#9654;":"&#9664;";}else{return e?"&#9664;":"&#9654;";}}else{return e?"&#9650;":"&#9660;";}};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactRenderer',[],function(){"use strict";var E={};
E.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3Exact");r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");r.renderControl(c._searchArea);if(c._bDetailsVisible){r.renderControl(c._browser);r.renderControl(c._resultText);r.renderControl(c._resultArea);}r.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilter',['sap/ui/core/Control','./library','./FacetFilterRenderer'],function(C,l,F){"use strict";var V=l.VisibleItemCountMode;
var a=C.extend("sap.ui.ux3.FacetFilter",{metadata:{library:"sap.ui.ux3",properties:{visibleItemCountMode:{type:"sap.ui.ux3.VisibleItemCountMode",group:"Appearance",defaultValue:V.Fixed}},aggregations:{lists:{type:"sap.ui.ux3.FacetFilterList",multiple:true,singularName:"list"}}}});
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
return a;});
sap.ui.predefine('sap/ui/ux3/FacetFilterList',['sap/ui/thirdparty/jquery','sap/ui/commons/ListBox','sap/ui/core/Control','./library','./FacetFilterListRenderer','sap/ui/core/ListItem'],function(q,L,C,l,F,a){"use strict";
var b=C.extend("sap.ui.ux3.FacetFilterList",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKeys:{type:"string[]",group:"Misc",defaultValue:null},showCounter:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},events:{select:{parameters:{id:{type:"string"},selectedIndices:{type:"int[]"},selectedItems:{type:"sap.ui.core.ListItem[]"},all:{type:"boolean"}}}}}});
b.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oListBox=new L(this.getId()+"-lb");this._oListBox.setScrollTop(0);this._oListBox.setValueTextAlign("Begin");this._oListBox.setDisplaySecondaryValues(this.getDisplaySecondaryValues());this._oListBox.setDisplayIcons(false);this._oListBox.setEditable(true);this._oListBox.setEnabled(true);this._oListBox.setVisible(true);this._oListBox.setAllowMultiSelect(this.getMultiSelect());this._oListBox.addAriaLabelledBy(this.getId()+"-head-txt");var t=this;this._oListBox.attachSelect(function(e){t.onSelect(t,e);});this.addAggregation("controls",this._oListBox);this._oItemAll=new a({text:this._oResBundle.getText("FACETFILTER_ALL",[0]),key:"sapUiFacetFilter_ALL"});this._oListBox.addItem(this._oItemAll);};
b.prototype.setMultiSelect=function(m){this._oListBox.setAllowMultiSelect(m);this.setProperty("multiSelect",m,true);return this;};
b.prototype.setDisplaySecondaryValues=function(d){this._oListBox.setDisplaySecondaryValues(d);this.setProperty("displaySecondaryValues",d,true);return this;};
b.prototype.addItem=function(i){this._oListBox.addItem(i);if(!i.getKey()||q.trim(i.getKey())==""){i.setKey("generatedkey"+this.indexOfItem(i));}this.updateText4All();return this;};
b.prototype.insertItem=function(i,I){this._oListBox.insertItem(i,I+1);if(!i.getKey()||q.trim(i.getKey())==""){i.setKey("generatedkey"+this.indexOfItem(i));}this.updateText4All();return this;};
b.prototype.removeItem=function(i){var r=this._oListBox.removeItem(i);this.updateText4All();return r;};
b.prototype.removeAllItems=function(){this._oListBox.removeAllItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();};
b.prototype.destroyItems=function(){this._oListBox.removeItem(this._oItemAll);this._oListBox.destroyItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();return this;};
b.prototype.indexOfItem=function(i){var I=this._oListBox.indexOfItem(i);if(I>-1){I=I-1;}return I;};
b.prototype.getItems=function(){var c=this._oListBox.getItems();var I=[];for(var i=1;i<c.length;i++){I.push(c[i]);}return I;};
b.prototype.setSelectedKeys=function(s){this.setProperty("selectedKeys",s);this.invalidate();return this;};
b.prototype.setShowCounter=function(s){this.setProperty("showCounter",s);this.updateText4All();return this;};
b.prototype.updateText4All=function(){if(this.getShowCounter()){this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_ALL",[this._oListBox.getItems().length-1]));}else{this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_NO_COUNT"));}};
b.prototype.onBeforeRendering=function(){if(!this.bFullHeight){this._oListBox.setVisibleItems(5);}var k=this.getSelectedKeys();if(k&&k.length>0){this._oListBox.setSelectedKeys(k);this._bAllOnly=false;}else{this._oListBox.setSelectedKeys(["sapUiFacetFilter_ALL"]);this._bAllOnly=true;}};
b.prototype.updateItems=function(){this.updateAggregation("items");var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s);}};
b.prototype.onSelect=function(f,e){var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s);}var I=s.indexOf("sapUiFacetFilter_ALL");if(I>-1){if(s.length==1){this._bAllOnly=true;}else{if(this._bAllOnly){s.splice(I,1);this._bAllOnly=false;}else{s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;}this._oListBox.setSelectedKeys(s);}}else{this._bAllOnly=false;}this.setProperty("selectedKeys",s,true);var S=[];var c=[];var A=this._oListBox.getSelectedItems();if(!this._bAllOnly){for(var i=0;i<A.length;i++){if(A[i]!=this._oItemAll){S.push(this.indexOfItem(A[i]));c.push(A[i]);}}}this.fireSelect({id:f.getId(),all:this._bAllOnly,selectedIndices:S,selectedItems:c});};
return b;});
sap.ui.predefine('sap/ui/ux3/FacetFilterListRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){r.write("<div ");r.writeControlData(c);r.addClass("sapUiUx3FFLst");r.writeClasses();r.writeAttribute("style","width:"+c.sWidth);r.write(">");r.write("<header id=\""+c.getId()+"-head\"  class=\"sapUiUx3FFLstHead\"");if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.write(">");r.write("<h3 id=\""+c.getId()+"-head-txt\"  class=\"sapUiUx3FFLstHeadTxt\">");if(c.getTitle()){r.writeEscaped(c.getTitle());}r.write("</h3>");r.write("</header>");r.renderControl(c._oListBox);r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilterRenderer',["./library"],function(l){"use strict";var V=l.VisibleItemCountMode;var F={};
F.render=function(r,c){var f=(c.getVisibleItemCountMode()===V.Auto);r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3FacetFilter");r.writeClasses();if(f){r.writeAttribute("style","height:100%");}r.write(">");var L=c.getLists();if(L){for(var i=0;i<L.length;i++){L[i].sWidth=100/L.length+"%";L[i].bFullHeight=f;r.renderControl(L[i]);}}r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/ux3/Feed',['sap/ui/commons/DropdownBox','sap/ui/commons/MenuButton','sap/ui/commons/SearchField','sap/ui/commons/ToggleButton','sap/ui/core/Control','./Feeder','./library','./FeedRenderer','sap/ui/commons/Menu','sap/ui/core/theming/Parameters','./FeedChunk'],function(D,M,S,T,C,F,l,a,b,P,c){"use strict";var d=l.FeederType;
var e=C.extend("sap.ui.ux3.Feed",{metadata:{library:"sap.ui.ux3",properties:{feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},live:{type:"boolean",group:"Behavior",defaultValue:true},title:{type:"string",group:"Data",defaultValue:null}},aggregations:{filterItems:{type:"sap.ui.core.ListItem",multiple:true,singularName:"filterItem",bindable:"bindable"},chunks:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"chunk",bindable:"bindable"},toolsMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"toolsMenuItem",bindable:"bindable"}},events:{filterChange:{parameters:{newValue:{type:"string"}}},search:{parameters:{query:{type:"string"}}},chunkAdded:{parameters:{chunk:{type:"sap.ui.ux3.FeedChunk"}}},toolsItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}},toggleLive:{parameters:{live:{type:"boolean"}}}}}});
e.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.data("sap-ui-fastnavgroup","true",true);this.oFeeder=new F(this.getId()+'-Feeder',{type:d.Medium}).setParent(this);this.oFeeder.attachEvent('submit',this.handleFeederSubmit,this);this.oLiveButton=new T(this.getId()+'-liveButton',{text:this.rb.getText('FEED_LIVE'),pressed:this.getLive(),lite:true}).setParent(this);this.oLiveButton.attachEvent('press',this.handleLiveButtonPress,this);this.oFilter=new D(this.getId()+'-filter').setParent(this);this.oFilter.attachEvent('change',this.handleFilterChange,this);this.oSearchField=new S(this.getId()+'-search',{enableListSuggest:false}).setParent(this);this.oSearchField.attachEvent('search',this.handleSearchFieldSearch,this);};
e.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new b(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleLtoolsButtonSelected,this);var i=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconUrl');var I=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};
e.prototype.exit=function(){if(this.oFeeder){this.oFeeder.destroy();delete this.oFeeder;}if(this.oLiveButton){this.oLiveButton.destroy();delete this.oLiveButton;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}if(this.oFilter){this.oFilter.destroy();delete this.oFilter;}if(this.oSearchField){this.oSearchField.destroy();delete this.oSearchField;}this.rb=undefined;};
e.prototype.handleFeederSubmit=function(E){var o=new Date();var s=String(o);var n=new c(this.getId()+'-new-'+this.getChunks().length,{text:E.getParameter('text'),commentChunk:false,deletionAllowed:true,timestamp:s,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.insertChunk(n,0);this.fireChunkAdded({chunk:n});};
e.prototype.handleLiveButtonPress=function(E){var p=E.getParameter("pressed");this.setProperty("live",p,true);this.fireToggleLive({live:p});};
e.prototype.handleLtoolsButtonSelected=function(E){this.fireToolsItemSelected(E.mParameters);};
e.prototype.handleFilterChange=function(E){this.fireFilterChange(E.mParameters);};
e.prototype.handleSearchFieldSearch=function(E){this.fireSearch(E.mParameters);};
e.prototype.setFeederThumbnailSrc=function(f){this.setProperty("feederThumbnailSrc",f,true);this.oFeeder.setThumbnailSrc(f);return this;};
e.prototype.setLive=function(L){this.setProperty("live",L,true);this.oLiveButton.setPressed(L);return this;};
e.prototype.getToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().getItems();}};
e.prototype.insertToolsMenuItem=function(t,i){this.initToolsButton();this.oToolsButton.getMenu().insertItem(t,i);return this;};
e.prototype.addToolsMenuItem=function(t){this.initToolsButton();this.oToolsButton.getMenu().addItem(t);return this;};
e.prototype.removeToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(t);}};
e.prototype.removeAllToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().removeAllItems();}};
e.prototype.indexOfToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().indexOfItem(t);}};
e.prototype.destroyToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().destroyItems();}return this;};
e.prototype.bindToolsMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};
e.prototype.unbindToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};
e.prototype.getFilterItems=function(){return this.oFilter.getItems();};
e.prototype.insertFilterItem=function(f,i){this.oFilter.insertItem(f,i);return this;};
e.prototype.addFilterItem=function(f){this.oFilter.addItem(f);return this;};
e.prototype.removeFilterItem=function(f){return this.oFilter.removeItem(f);};
e.prototype.removeAllFilterItems=function(){return this.oFilter.removeAllItems();};
e.prototype.indexOfFilterItem=function(f){return this.oFilter.indexOfItem(f);};
e.prototype.destroyFilterItems=function(){this.oFilter.destroyItems();return this;};
e.prototype.bindFilterItems=function(p,t,s,f){this.oFilter.bindItems(p,t,s,f);return this;};
e.prototype.unbindFilterItems=function(){this.oFilter.unbindItems();return this;};
return e;});
sap.ui.predefine('sap/ui/ux3/FeedChunk',['sap/ui/thirdparty/jquery','sap/ui/commons/MenuButton','sap/ui/core/Control','sap/ui/core/theming/Parameters','./Feeder','./library','./FeedChunkRenderer','sap/ui/commons/Menu','sap/ui/commons/MenuItem'],function(q,M,C,P,F,l,a,b,c){"use strict";var d=l.FeederType;
var e=C.extend("sap.ui.ux3.FeedChunk",{metadata:{library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
e.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false;};
e.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new F(this.getId()+'-CommentFeeder',{type:d.Comment}).setParent(this);this.oCommentFeeder.attachEvent('submit',this.handleCommentFeederSubmit,this);this.showCommentFeeder=true;}};
e.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new b(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleToolsButtonSelected,this);var i=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconUrl');var I=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};
e.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton;}};
e.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var f=this.$().children(".sapUiFeedChunkByline").get(0);q(f).append(a.renderExpander(this));if(this.expanded){q(this.oText).css('height','auto');}}};
e.prototype.onclick=function(E){var t=E.target.getAttribute('ID');if(t){switch(t){case(this.getId()+'-delete'):this.fireDeleted();break;case(this.getId()+'-sender'):this.fireSenderClicked();break;case(this.getId()+'-thumb'):this.fireSenderClicked();break;case(this.getId()+'-exp'):var n='';if(this.expanded){q(this.oText).css('height','');n=this.rb.getText("FEED_EXPAND");this.expanded=false;}else{q(this.oText).css('height','auto');n=this.rb.getText("FEED_COLLAPSE");this.expanded=true;}q(document.getElementById(t)).attr('title',n).toggleClass('sapUiFeedChunkExpand sapUiFeedChunkCollapse');break;case(this.getId()+'-all'):this.showAllComments();break;case(this.getId()+'-ActComment'):if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender();}break;case(this.getId()+'-ActFlag'):this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case(this.getId()+'-ActFavorite'):this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case(this.getId()+'-ActInspect'):this.fireInspect();break;case(this.getId()+'-ActShare'):this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+'-Ref')!=-1){this.fireReferenceClicked({text:q(E.target).text()});}break;}}E.preventDefault();E.stopPropagation();};
e.prototype.showAllComments=function(){this.allComments=!this.allComments;var $=this.$().children("section");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(r,this);r.flush($[0]);r.destroy();}};
e.prototype.handleCommentFeederSubmit=function(E){var D=new Date();var s=String(D);var n=new e(this.getId()+'-new-'+this.getComments().length,{text:E.getParameter('text'),commentChunk:true,deletionAllowed:true,timestamp:s,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n});};
e.prototype.handleToolsButtonSelected=function(E){if(E.getParameter('itemId')==this.getId()+'-actDelete'){this.fireDeleted();}else{this.fireActionItemSelected(E.mParameters);}};
e.prototype.insertComment=function(o,i){this.insertAggregation("comments",o,i);this.initCommentFeeder();return this;};
e.prototype.addComment=function(o){this.addAggregation("comments",o);this.initCommentFeeder();return this;};
e.prototype.setDeletionAllowed=function(D){if(D==this.getDeletionAllowed()){return this;}this.setProperty("deletionAllowed",D);if(D){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new c(this.getId()+'-actDelete',{text:this.rb.getText('FEED_DELETE')}),0);}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+'-actDelete');}}return this;};
e.prototype.getActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){i.shift();}return i;}};
e.prototype.insertActionMenuItem=function(A,i){this.initToolsButton();var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i++;}this.oToolsButton.getMenu().insertItem(A,i);return this;};
e.prototype.addActionMenuItem=function(A){this.initToolsButton();this.oToolsButton.getMenu().addItem(A);return this;};
e.prototype.removeActionMenuItem=function(A){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(A);}};
e.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){I.shift();for(var i=0;i<I.length;i++){this.oToolsButton.getMenu().removeItem(I[i]);}return I;}else{return this.oToolsButton.getMenu().removeAllItems();}}};
e.prototype.indexOfActionMenuItem=function(A){if(this.oToolsButton){var i=this.oToolsButton.getMenu().indexOfItem(A);var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i--;}return i;}};
e.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){this.removeAllActionMenuItems();}else{this.oToolsButton.getMenu().destroyItems();}}return this;};
e.prototype.bindActionMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};
e.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};
e.prototype.getFeederThumbnailSrc=function(){var t=this.getProperty("feederThumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof e)){t=p.getFeederThumbnailSrc();}}return t;};
e.prototype.getFeederSender=function(){var s=this.getProperty("feederSender");if(!s||s==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof e)){s=p.getFeederSender();}}return s;};
e.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new M(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent('itemSelected',this.handleHCMMenuButtonSelected,this);}};
e.prototype.setHCMMenu=function(m){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(m);return this;};
e.prototype.handleHCMMenuButtonSelected=function(E){this.fireEvent("HCMMenuItemSelected",E.mParameters);};
return e;});
sap.ui.predefine('sap/ui/ux3/FeedChunkRenderer',["sap/ui/core/theming/Parameters","sap/base/security/encodeXML","sap/base/security/URLWhitelist"],function(P,e,U){"use strict";var F={};
F.render=function(r,c){if(c.getParent()instanceof sap.ui.ux3.FeedChunk){c.bComment=true;}else{c.bComment=false;}var m=c.getId();r.write('<article');r.writeControlData(c);r.addClass('sapUiFeedChunk');if(c.bComment){r.addClass('sapUiFeedChunkComment');}r.writeClasses();r.write('>');r.write('<img id='+m+'-thumb');var t=c.getThumbnailSrc();if(!t){t=P._getThemeImage('_sap_ui_ux3_FeedChunk_PersonPlaceholder');}r.writeAttributeEscaped('src',t);r.writeAttributeEscaped('alt',c.getSender());r.writeClasses();r.write('>');r.write('<div class= "sapUiFeedChunkText" >');r.write('<a id='+m+'-sender ');r.writeAttribute('href','#');r.write('>');r.writeEscaped(c.getSender());r.write('</a> ');if(c.oHCMMenuButton){r.renderControl(c.oHCMMenuButton);}this.renderText(r,c);r.write('</div>');if(!c.bComment){r.write('<ul class= "sapUiFeedChunkStatusIcons" >');if(c.getFlagged()){r.write('<li class= "sapUiFeedChunkFlagged" title="'+c.rb.getText('FEED_FLAGGED')+'" >&#9873</li>');}if(c.getFavorite()){r.write('<li class= "sapUiFeedChunkFavorite" title="'+c.rb.getText('FEED_FAVORITE')+'" >&#9733</li>');}if(c.getShared()){r.write('<li class= "sapUiFeedChunkShared" title="'+c.rb.getText('FEED_SHARED')+'" >&#8635</li>');}r.write('</ul>');}r.write('<span class= "sapUiFeedChunkByline" >');r.writeEscaped(c.getTimestamp());r.write('</span>');if(!c.bComment){if(c.oToolsButton){r.renderControl(c.oToolsButton);}if(c.getEnableShare()){r.write('<button type = "button" id='+m+'-ActShare class= "sapUiFeedChunkAct sapUiFeedChunkActShare" title="'+c.rb.getText('FEED_ACT_SHARE')+'" >&#8635</BUTTON>');}if(c.getEnableInspect()){r.write('<button type = "button" id='+m+'-ActInspect class= "sapUiFeedChunkAct sapUiFeedChunkActInspect" title="'+c.rb.getText('FEED_ACT_INSPECT')+'" >i</BUTTON>');}if(c.getEnableFavorite()){r.write('<button type = "button" id='+m+'-ActFavorite class= "sapUiFeedChunkAct sapUiFeedChunkActFavorite" title="'+c.rb.getText('FEED_ACT_FAVORITE')+'" >&#9733</BUTTON>');}if(c.getEnableFlag()){r.write('<button type = "button" id='+m+'-ActFlag class= "sapUiFeedChunkAct sapUiFeedChunkActFlag" title="'+c.rb.getText('FEED_ACT_FLAG')+'" >&#9873</BUTTON>');}if(c.getEnableComment()){r.write('<button type = "button" id='+m+'-ActComment class= "sapUiFeedChunkAct sapUiFeedChunkActComment" title="'+c.rb.getText('FEED_ACT_COMMENT')+'" >C</BUTTON>');}}if(c.getDeletionAllowed()&&c.bComment){r.write('<button type = "button" id='+m+'-delete class= "sapUiFeedChunkDel" title="'+c.rb.getText('FEED_DELETE')+'" >X</BUTTON>');}if(c.getComments().length>0||c.showCommentFeeder){r.write("<section>");this.renderComments(r,c);r.write("</section>");}r.write('</article>');};
F.renderText=function(r,c){var t=c.getText();var i=0;var p=0;do{p=t.search(/\s/);var s="",w="";if(p<0){w=t;}else{w=t.slice(0,p);s=t.slice(p,p+1);t=t.slice(p+1);}if(/^@/.test(w)){r.write('<a id='+c.getId()+'-Ref'+i);r.writeAttribute('href','#');r.write('>');r.writeEscaped(w,true);r.write('</a>',s);i++;}else if(/^(https?|ftp):\/\//i.test(w)&&U.validate(w)){r.write('<a');r.writeAttribute('href',e(w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else if(/^(www\.)/i.test(w)&&U.validate("http://"+w)){r.write('<a');r.writeAttribute('href',e("http://"+w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else if(/^[\w\.=-]+@[\w\.-]+\.[\w]{2,5}$/.test(w)){r.write('<a');r.writeAttribute('href',"mailto:"+e(w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else{r.writeEscaped(w+s,true);}}while(p>=0);};
F.renderComments=function(r,c){var C=c.getComments();var l=C.length;r.write('<header class= "sapUiFeedChunkComments" >');if(c.rb){r.write(c.rb.getText('FEED_NO_COMMENTS',[l]));if(l>c.maxComments){r.write('<a id='+c.getId()+'-all ');r.writeAttribute('href','#');r.write('>');if(!c.allComments){r.write(c.rb.getText('FEED_ALL_COMMENTS'));}else{r.write(c.rb.getText('FEED_MAX_COMMENTS'));}r.write('</a>');}}r.write("</header>");var n=l;if(!c.allComments&&c.maxComments<n){n=c.maxComments;}for(var i=0;i<n;i++){r.renderControl(C[l-n+i]);}if(c.oCommentFeeder){r.renderControl(c.oCommentFeeder);}};
F.renderExpander=function(c){if(c.expanded){return"<button id= '"+c.getId()+"-exp' class='sapUiFeedChunkCollapse' title='"+c.rb.getText("FEED_COLLAPS")+"'>&#9660</button>";}else{return"<button id= '"+c.getId()+"-exp' class='sapUiFeedChunkExpand' title='"+c.rb.getText("FEED_EXPAND")+"'>&#9660</button>";}};
return F;},true);
sap.ui.predefine('sap/ui/ux3/FeedRenderer',[],function(){"use strict";var F={};
F.render=function(r,f){r.write('<div');r.writeControlData(f);r.addClass('sapUiFeed');r.writeClasses();r.write('>');r.renderControl(f.oFeeder);r.write('<header class=sapUiFeedTitle ><h4>');var t=f.getTitle();if(!t||t==""){t=f.rb.getText('FEED_TITLE');}r.writeEscaped(t);if(f.oToolsButton){r.renderControl(f.oToolsButton);}r.renderControl(f.oLiveButton);r.write('</h4>');r.write('<div class="sapUiFeedToolbar" >');r.renderControl(f.oFilter);r.renderControl(f.oSearchField);r.write('</div>');r.write('</header>');r.write('<section>');for(var i=0;i<f.getChunks().length;i++){var c=f.getChunks()[i];r.renderControl(c);}r.write('</section>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/ux3/Feeder',['sap/ui/thirdparty/jquery','sap/ui/commons/Button','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','./FeederRenderer','sap/ui/commons/library','sap/ui/Device'],function(q,B,C,P,l,F,c,D){"use strict";var a=c.ButtonStyle;var b=l.FeederType;
var d=C.extend("sap.ui.ux3.Feeder",{metadata:{library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},type:{type:"sap.ui.ux3.FeederType",group:"Appearance",defaultValue:b.Large},placeholderText:{type:"string",group:"Appearance",defaultValue:null}},events:{submit:{parameters:{text:{type:"string"}}}}}});
d.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.oSendButton=new B(this.getId()+"-send",{style:a.Emph,icon:"sap-icon://feeder-arrow"}).setParent(this);this.oSendButton.attachEvent('press',this.handleSendButtonPress,this);};
d.prototype.initSendButton=function(){if(this.getText()==""){this.oSendButton.setProperty('enabled',false,true);}};
d.prototype.exit=function(){this.rb=undefined;this.oInput=undefined;if(this.oSendButton){this.oSendButton.destroy();delete this.oSendButton;}};
d.prototype.onAfterRendering=function(){this.oInput=this.$("input");};
d.prototype.onclick=function(e){var t=e.target.getAttribute('ID');switch(t){case(this.getId()+'-send'):break;case(this.getId()+'-input'):break;default:break;}};
d.prototype.onfocusin=function(e){this.oInput.find(".sapUiFeederEmptyText").remove();};
d.prototype.onfocusout=function(e){var t=this.oInput.text();if(t==""){this.oInput.empty();this.oInput.append(F.getEmptyTextInfo(this));}this.setProperty("text",t,true);};
d.prototype.getFocusDomRef=function(){return this.getDomRef("input");};
d.prototype.onkeyup=function(e){if(this.oInput.text()==""){this.oSendButton.setEnabled(false);}else{this.oSendButton.setEnabled(true);}};
d.prototype.handleSendButtonPress=function(e){var t=this.getMultilineText(this.oInput);this.setProperty("text",t,true);this.fireSubmit({text:t});this.setText('');};
d.prototype.getMultilineText=function(I){function p(n){var e;var t='';for(var i=0;i<n.length;i++){e=n[i];if(e.nodeType===3||e.nodeType===4){if(!((D.browser.msie||D.browser.edge)&&e.nodeValue==='\xA0')){t+=e.nodeValue.replace(/\n/g,'');}}if(e.nodeName==='DIV'||e.nodeName==='P'||(e.nodeName==='BR'&&!D.browser.webkit)){if(e.nodeName==='BR'&&D.browser.firefox&&i===n.length-1&&q(e).attr("type")==="_moz"){continue;}if(!((D.browser.msie||D.browser.edge)&&t==='')&&!((D.browser.firefox||D.browser.webkit)&&t===''&&e.nodeName==='P')&&!(D.browser.webkit&&e.nodeName==='P'&&e.textContent.match(/^(\n)*$/))){t+='\n';}}if(e.nodeType!==8){t+=p(e.childNodes);}}return t;}return p(I.get(0).childNodes);};
d.prototype.getThumbnailSrc=function(){var t=this.getProperty("thumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof sap.ui.ux3.FeedChunk)){t=p.getFeederThumbnailSrc();}}return t;};
d.prototype.onpaste=function(e){if(D.browser.firefox){setTimeout(this.onAfterPaste.bind(this),10);}};
d.prototype.onAfterPaste=function(){var e=this.oInput.get(0).childNodes;for(var i=0;i<e.length;i++){var o=e[i];if(o.nodeName=="PRE"){q(o).css("overflow","hidden");}}};
return d;});
sap.ui.predefine('sap/ui/ux3/FeederRenderer',["./library","sap/ui/core/theming/Parameters","sap/base/security/encodeXML"],function(l,P,e){"use strict";var F=l.FeederType;var a={};
a.render=function(r,f){r.write('<div');r.writeControlData(f);r.addClass('sapUiFeeder');switch(f.getType()){case F.Medium:r.addClass('sapUiFeederMedium');break;case F.Comment:r.addClass('sapUiFeederComment');break;default:r.addClass('sapUiFeederLarge');break;}r.writeClasses();r.write('>');r.write('<img id='+f.getId()+'-thumb');var t=f.getThumbnailSrc();if(!t){t=P._getThemeImage("_sap_ui_ux3_Feeder_PersonPlaceholder");}r.writeAttributeEscaped('src',t);r.writeClasses();r.write('>');r.write('<div id='+f.getId()+'-input contenteditable="true" class="sapUiFeederInput" >');if(f.getText()==''){r.write(this.getEmptyTextInfo(f));}else{r.writeEscaped(f.getText(),true);}r.write('</div>');f.initSendButton();r.renderControl(f.oSendButton);r.write('</div>');};
a.getEmptyTextInfo=function(f){return"<span class='sapUiFeederEmptyText'>"+e(f.getPlaceholderText()||f.rb.getText("FEED_EMPTY_FEEDER"))+"</span>";};
return a;},true);
sap.ui.predefine('sap/ui/ux3/NavigationBar',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library','./NavigationBarRenderer','sap/ui/commons/Menu','sap/ui/commons/MenuItem','sap/ui/core/Popup','sap/ui/events/jquery/EventSimulation','sap/ui/dom/denormalizeScrollLeftRTL','sap/ui/util/ActivityDetection','sap/ui/Device','sap/base/assert','sap/ui/dom/jquery/scrollRightRTL','sap/ui/dom/jquery/scrollLeftRTL'],function(q,C,I,l,N,M,b,P,E,d,A,D,c){"use strict";var e=P.Dock;
var f=C.extend("sap.ui.ux3.NavigationBar",{metadata:{library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});
f.SCROLL_STEP=250;
f.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=new I().setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(E.touchEventMode==="ON"){var T=function(h){h.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=h.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var a=function(h){var i=h.touches[0].pageX-t.startTouchX;var L=t.getDomRef("list");var o=L.scrollLeft;var n=t.startScrollX-i;L.scrollLeft=n;t._bTouchNotMoved=false;var j=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(j>0){t._velocity=(n-o)/j;}h.preventDefault();};var g=function(h){if(t._bTouchNotMoved===false){h.preventDefault();var L=t.getDomRef("list");var i=50;var j=Math.abs(t._velocity/10);t._iInertiaIntervalId=setInterval(function(){t._velocity=t._velocity*0.80;var k=t._velocity*i;L.scrollLeft=L.scrollLeft+k;if(Math.abs(t._velocity)<j){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},i);}else if(t._bTouchNotMoved===true){t.onclick(h);h.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.ontouchstart=T;this.ontouchend=g;this.ontouchmove=a;}};
f.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}};
f.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}this._iSoredScrollPosition=this.$("list").scrollLeft();if(D.browser.firefox){this.$().unbind("DOMMouseScroll",this._handleScroll);}else{this.$().unbind("mousewheel",this._handleScroll);}var a=this.getDomRef("arrow");this._iLastArrowPos=a?parseInt(this._bRtl?a.style.right:a.style.left):-100;};
f.prototype.invalidate=function(s){if(s instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true;}C.prototype.invalidate.apply(this,arguments);};
f.prototype._calculatePositions=function(){var o=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(o.firstChild,this.getDomRef("ofb"),this.getDomRef("off"));};
f.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions();}};
f.prototype.onAfterRendering=function(){var o=this.getDomRef();var L=o.firstChild;var a=this.getDomRef("ofb");var g=this.getDomRef("off");this._checkOverflowIntervalId=setInterval(this._checkOverflow.bind(this,L,a,g),350);if(D.browser.firefox){q(o).bind("DOMMouseScroll",q.proxy(this._handleScroll,this));}else{q(o).bind("mousewheel",q.proxy(this._handleScroll,this));}this._calculatePositions();this._updateItemNavigation();var n=this.$();n.on("scroll",function(){n.children().scrollTop(0);n.scrollTop(0);});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition);}};
f.prototype._updateItemNavigation=function(){var o=this.getDomRef();if(o){var s=-1;var S=this.getSelectedItem();var i=q(o).children().children("li").children().not(".sapUiUx3NavBarDummyItem");i.each(function(a,g){if(g.id==S){s=a;}});this._oItemNavigation.setRootDomRef(o);this._oItemNavigation.setItemDomRefs(i.toArray());this._oItemNavigation.setSelectedIndex(s);}};
f.prototype.onsapspace=function(o){this._handleActivation(o);};
f.prototype.onclick=function(o){this._handleActivation(o);};
f.prototype.setOverflowItemsToUpperCase=function(v){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",v);return this.setProperty("overflowItemsToUpperCase",v);};
f.prototype._handleActivation=function(o){var t=o.target.id;if(t){var i=this.getId();o.preventDefault();if(t==i+"-ofb"){this._scroll(-f.SCROLL_STEP,500);}else if(t==i+"-off"){this._scroll(f.SCROLL_STEP,500);}else if(t==i+"-oflt"||t==i+"-ofl"){this._showOverflowMenu();}else{var a=sap.ui.getCore().byId(t);if(a&&(t!=this.getSelectedItem())&&(sap.ui.getCore().byId(t)instanceof sap.ui.ux3.NavigationItem)){if(this.fireSelect({item:a,itemId:t})){this.setAssociation("selectedItem",a,true);this._updateSelection(t);}}}}};
f.prototype._getOverflowMenu=function(){var m=this.getAggregation("overflowMenu");if(!m||this._menuInvalid){if(m){m.destroyAggregation("items",true);}else{m=new M();}var a=this._getCurrentItems();var t=this;var s=this.getSelectedItem();for(var i=0;i<a.length;++i){var n=a[i];var o=new b(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:s==n.getId()?"sap-icon://accept":null,select:(function(n){return function(g){t._handleActivation({target:{id:n.getId()},preventDefault:function(){}});};})(n)});m.addAggregation("items",o,true);}this.setAggregation("overflowMenu",m,true);this._menuInvalid=false;}return m;};
f.prototype._getCurrentItems=function(){var a=this.getItems();if(a.length<1){a=this.getAssociatedItems();var o=sap.ui.getCore();for(var i=0;i<a.length;++i){a[i]=o.byId(a[i]);}}return a;};
f.prototype._showOverflowMenu=function(){var m=this._getOverflowMenu();var t=this.$("ofl").get(0);m.open(true,t,e.EndTop,e.CenterCenter,t);};
f.prototype._updateSelection=function(i){this._menuInvalid=true;var $=q(document.getElementById(i));$.attr("tabindex","0").attr("aria-checked","true");$.parent().addClass("sapUiUx3NavBarItemSel");$.parent().parent().children().each(function(){var a=this.firstChild;if(a&&(a.id!=i)&&(a.className.indexOf("Dummy")==-1)){q(a).attr("tabindex","-1");q(a).parent().removeClass("sapUiUx3NavBarItemSel");q(a).attr("aria-checked","false");}});var s=$.parent().index();if(s>0){s--;}this._oItemNavigation.setSelectedIndex(s);var g=this.$("arrow");var h=g.outerWidth();var t=f._getArrowTargetPos(i,h,this._bRtl);g.stop();var j=this._bRtl?{right:t+"px"}:{left:t+"px"};g.animate(j,500,"linear");var k=this;window.setTimeout(function(){t=f._getArrowTargetPos(i,h,k._bRtl);g.stop();var a=k._bRtl?{right:t+"px"}:{left:t+"px"};g.animate(a,200,"linear",function(){var m=i?window.document.getElementById(i):null;k._scrollItemIntoView(m);});},300);};
f.prototype._scrollItemIntoView=function(i){if(!i){return;}var a=q(i.parentNode);var u=a.parent();var t;var r=sap.ui.getCore().getConfiguration().getRTL();var g=a.index()-1;if(g==0){t=r?(u[0].scrollWidth-u.innerWidth()+20):0;}else if(g==a.siblings().length-2){t=r?0:(u[0].scrollWidth-u.innerWidth()+20);}else{var h=a.position().left;var j=r?u.scrollLeftRTL():u.scrollLeft();if(h<0){t=j+h;}else{var k=u.innerWidth()-(h+a.outerWidth(true));if(k<0){t=j-k;t=Math.min(t,j+h);}}}if(t!==undefined){if(r){t=d(t,u.get(0));}u.stop(true,true).animate({scrollLeft:t});}};
f._getArrowTargetPos=function(t,a,r){var i=q(document.getElementById(t));if(i.length>0){var w=i.outerWidth();var g=Math.round(i[0].offsetLeft+(w/2)-(a/2));if(!r){return g;}else{return i.parent().parent().innerWidth()-g-a;}}else{return-100;}};
f.prototype._handleScroll=function(o){if(o.type=="DOMMouseScroll"){var s=o.originalEvent.detail*40;this._scroll(s,50);}else{var s=-o.originalEvent.wheelDelta;this._scroll(s,50);}o.preventDefault();};
f.prototype._scroll=function(i,a){var o=this.$()[0].firstChild;var s=o.scrollLeft;if(!D.browser.msie&&this._bRtl){i=-i;}var S=s+i;q(o).stop(true,true).animate({scrollLeft:S},a);};
f.prototype._checkOverflow=function(L,o,a){function i(){return D.os.macintosh&&D.browser.chrome;}if(L&&this.getDomRef()&&A.isActive()){var s=L.scrollLeft;var S=false;var g=false;var r=L.scrollWidth;var h=L.clientWidth;var j=i()?5:0;if(Math.abs(r-h)==1){r=h;}if(!this._bRtl){if(s>j){S=true;}if((r>h)&&(r-(s+h)>j)){g=true;}}else{var $=q(L);if($.scrollLeftRTL()>j){g=true;}if($.scrollRightRTL()>j){S=true;}}if((g!=this._bPreviousScrollForward)||(S!=this._bPreviousScrollBack)){this._bPreviousScrollForward=g;this._bPreviousScrollBack=S;this.$().toggleClass("sapUiUx3NavBarScrollBack",S).toggleClass("sapUiUx3NavBarScrollForward",g);if(!f._bMenuLoaded&&(S||g)){f._bMenuLoaded=true;}}var k=sap.ui.getCore().byId(this.getSelectedItem());if(k){var m=this.$("arrow");var n=m.outerWidth();var t=f._getArrowTargetPos(k.getId(),n,this._bRtl)+"px";if(!this._bRtl){if(m[0].style.left!=t){m[0].style.left=t;}}else{if(m[0].style.right!=t){m[0].style.right=t;}}}}};
f.prototype.setSelectedItem=function(i){this.setAssociation("selectedItem",i,true);if(this.getDomRef()){var s=(!i||(typeof(i)=="string"))?i:i.getId();this._updateSelection(s);}return this;};
f.prototype.addItem=function(i){this._menuInvalid=true;return this.addAggregation("items",i);};
f.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items");};
f.prototype.insertItem=function(i,a){this._menuInvalid=true;return this.insertAggregation("items",i,a);};
f.prototype.removeItem=function(i){this._menuInvalid=true;return this.removeAggregation("items",i);};
f.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items");};
f.prototype.addAssociatedItem=function(i){this._menuInvalid=true;return this.addAssociation("associatedItems",i);};
f.prototype.removeAssociatedItem=function(i){this._menuInvalid=true;return this.removeAssociation("associatedItems",i);};
f.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems");};
f.prototype.setAssociatedItems=function(a){c(Array.isArray(a),"aItems must be an array");var L=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<a.length;i++){this.addAssociation("associatedItems",a[i],true);}if(L){var F=q(L).find(":focus");var g=(F.length>0)?F.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100;}else{var h=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?h.style.right:h.style.left);}L.innerHTML="";var r=sap.ui.getCore().createRenderManager();N.renderItems(r,this);r.flush(L,true);r.destroy();var n=g?document.getElementById(g):null;if(n){n.focus();}this._updateSelection(this.getSelectedItem());this._updateItemNavigation();}return this;};
f.prototype.isSelectedItemValid=function(){var s=this.getSelectedItem();if(!s){return false;}var a=this.getItems();if(!a||a.length==0){a=this.getAssociatedItems();for(var i=0;i<a.length;i++){if(a[i]==s){return true;}}}else{for(var i=0;i<a.length;i++){if(a[i].getId()==s){return true;}}}return false;};
return f;});
sap.ui.predefine('sap/ui/ux3/NavigationBarRenderer',["sap/base/security/encodeXML"],function(e){"use strict";var N={};
N.render=function(r,c){var i=c.getId();r.addClass("sapUiUx3NavBar").addClass("sapUiUx3NavBarUpperCaseText");if(c.getToplevelVariant()){r.addClass("sapUiUx3NavBarToplevel");}r.write("<nav");r.writeControlData(c);r.writeClasses();r.write("role='navigation'>");r.write("<ul id='"+i+"-list' role='menubar' class='sapUiUx3NavBarList'");r.addStyle("white-space","nowrap");r.writeStyles();r.write(">");N.renderItems(r,c);r.write("</ul>");r.write("<a id='"+i+"-ofb' role='presentation' class='sapUiUx3NavBarBack' href='#'></a>");r.write("<a id='"+i+"-off' role='presentation' class='sapUiUx3NavBarForward' href='#'></a>");r.write("<a id='"+i+"-ofl' role='presentation' class='sapUiUx3NavBarOverflowBtn' href='#'>");r.writeIcon("sap-icon://overflow",[],{id:i+"-oflt"});r.write("</a>");r.write("</nav>");};
N.renderItems=function(r,c){var I=c.getItems();var n=false;if(!I||I.length==0){I=c.getAssociatedItems();n=true;}var a=I.length;r.write("<li");r.addStyle("display","inline-block");r.writeStyles();r.write(">");r.write("<a id='"+c.getId()+"-dummyItem' class='sapUiUx3NavBarDummyItem sapUiUx3NavBarItem'>&nbsp;</a></li>");var s=c.getSelectedItem();for(var i=0;i<a;i++){var b=n?sap.ui.getCore().byId(I[i]):I[i];if(b.getVisible()){var d=b.getId();var f=d==s;r.write("<li");r.addStyle("display","inline-block");r.writeStyles();if(f){r.write(" class='sapUiUx3NavBarItemSel'");}r.write("><a ");r.writeElementData(b);r.writeAttributeEscaped("href",b.getHref()||'#');r.write(" aria-setsize='"+a+"' aria-posinset='"+(i+1)+"' role='menuitemradio' class='sapUiUx3NavBarItem'");if(f){r.write(" tabindex='0'");}r.write(" aria-checked='"+(f?"true":"false")+"'");var t=b.getTooltip_AsString();if(t){r.write(" title='"+e(t)+"'");}r.write(">");r.write(e(b.getText()));r.write("</a></li>");}}var g;if(c._bRtl){g="right:"+c._iLastArrowPos;}else{g="left:"+c._iLastArrowPos;}r.write("<span id='"+c.getId()+"-arrow' style='"+g+"px;");r.write("' class='sapUiUx3NavBarArrow'></span>");};
return N;},true);
sap.ui.predefine('sap/ui/ux3/NavigationItem',['sap/ui/core/Item','./library'],function(I,l){"use strict";
var N=I.extend("sap.ui.ux3.NavigationItem",{metadata:{library:"sap.ui.ux3",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null}},defaultAggregation:"subItems",aggregations:{subItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"subItem"}}}});
return N;});
sap.ui.predefine('sap/ui/ux3/NotificationBar',["sap/ui/thirdparty/jquery",'sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','./library',"./NotificationBarRenderer","sap/ui/core/Message","sap/ui/core/library","sap/ui/Device","sap/base/Log"],function(q,C,I,P,l,N,M,c,D,L){"use strict";var a=c.MessageType;var b=l.NotificationBarStatus;
var d=C.extend("sap.ui.ux3.NotificationBar",{metadata:{library:"sap.ui.ux3",properties:{visibleStatus:{type:"sap.ui.ux3.NotificationBarStatus",group:"Misc",defaultValue:b.Default},resizeEnabled:{type:"boolean",group:"Misc",defaultValue:true},alwaysShowToggler:{type:"boolean",defaultValue:false,since:"1.24.5"}},aggregations:{messageNotifier:{type:"sap.ui.core.Element",multiple:false},notifiers:{type:"sap.ui.core.Element",multiple:true,singularName:"notifier"}},events:{display:{parameters:{show:{type:"boolean"}}},resize:{parameters:{status:{type:"sap.ui.ux3.NotificationBarStatus"}}}}}});
C.extend("sap.ui.ux3.NotificationBar.NotifierView",{
renderMessages:function(j){j.write("<div");j.writeAttribute("id",this.getId()+"-content");j.addClass("sapUiNotifierContent");j.writeClasses();j.write(">");var u=this.getMessages();var i=u.length-1;var F=true;for(;i>=0;i--){if(!F||(i==0&&u.length>1)){j.write("<div");j.addClass("sapUiNotificationBarCltSep");j.writeClasses();j.write(">");j.write("</div>");}else{F=false;}var v=u[i];if(v._message&&v._message.getReadOnly()){v.addStyleClass("sapUiNotifierMessageReadOnly");}j.renderControl(v);}j.write("</div>");},
metadata:{properties:{"title":"string","visibleItems":"int","renderMode":{type:"string",defaultValue:"callout"}},aggregations:{"messages":"sap.ui.ux3.NotificationBar.MessageView"}},
init:function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");},
exit:function(){if(this._renderedControl){delete this._renderedControl;}delete this._oResBundle;},
getTitle:function(){var T=this.getProperty("title");var i=this.getMessages().length;if(i>0){var K="NOTIBAR_NOTIFIER_VIEW_TITLE";T=this._oResBundle.getText(K,[T,i]);}return T;},
renderer:function(i,j){i.write("<div");i.addClass("sapUiNotifierContainer");i.writeControlData(j);i.writeClasses();i.write(">");i.write("<div");i.writeAttribute("id",j.getId()+"-title");i.addClass("sapUiNotifierTitle");i.writeClasses();i.write(">");i.writeEscaped(j.getTitle());i.write("</div>");if(j.getMessages().length>0){j.renderMessages(i);}i.write("</div>");},
onAfterRendering:function(){var $=this.$("content"),i=$.children(".sapUiNotifierMessage"),j=i.length,v=this.getVisibleItems();if(j>v){setTimeout(this._fnAfterRenderingCallback.bind(this,i,$,v),0);}},
_fnAfterRenderingCallback:function($,i,v){var T=v-1,j=0;$.each(function(){if(j===v){i.css("max-height",T);return;}T+=q(this).outerHeight();j++;});}
});
C.extend("sap.ui.ux3.NotificationBar.MessageView",{
metadata:{properties:{"text":"string","timestamp":"string","icon":"sap.ui.core.URI"}},
renderer:function(i,j){var u=j.getId();i.write("<div");i.writeControlData(j);i.addClass("sapUiNotifierMessage");i.writeClasses();i.writeAttribute("tabindex","0");i.write(">");if(j.getIcon()){i.write("<div");i.writeAttribute("id",u+"-icon");i.addClass("sapUiNotifierMessageIcon");i.writeClasses();i.write(">");i.write("<img");i.writeAttributeEscaped("src",j.getIcon());i.write(">");i.write("</div>");}i.write("<div");i.writeAttribute("id",u+"-text");i.addClass("sapUiNotifierMessageText");i.writeClasses();i.write(">");i.writeEscaped(j.getText());i.write("</div>");i.write("<div");i.writeAttribute("id",u+"-timestamp");i.addClass("sapUiNotifierMessageTimestamp");i.writeClasses();i.write(">");i.writeEscaped(j.getTimestamp());i.write("</div>");i.write("</div>");},
onclick:function(i){if(!this._message.getReadOnly()){var j=this._message.getParent();j.fireMessageSelected({message:this._message,notifier:j});}},
onsapselect:function(i){this.onclick(i);},
exit:function(i){if(this._message){delete this._message;}}
});
var f=function(i){var j=i.hasItems();var u=i.getVisibleStatus();if(j&&u==="None"){return true;}else if(!j&&u!=="None"){return true;}else if(!j&&u!=="Min"){return true;}else{return false;}};var s=function(i,j){var u=j.getMessages().concat([]);if(u.length>0){u.sort(M.compareByType);var v=u.length-1;i._sSeverestMessageLevel=u[v].getLevel();}};var e=function(j){var u=j.getParameter("callout");switch(j.getParameter("type")){case"added":case"removed":var v=j.getParameter("notifier");if(this.getMessageNotifier()&&this.getMessageNotifier().getId()===v.getId()){s(this,this.getMessageNotifier());}if(f(this)){var x=this.hasItems();this.fireDisplay({show:x});}else{this.invalidate();if(j.getParameter("type")==="removed"){if(u.getContent().length>0){var y=u.getContent()[0];var z=j.getParameter("message");var A=y.getMessages();var B;for(var i=0;i<A.length;i++){B=A[i];if(z.getId()===B._message.getId()){B.destroy();u.rerender();u.adjustPosition();break;}}}}}break;case"openCallout":u.destroyContent();var v=j.getParameter("notifier");v.destroyAggregation("views",true);var F=v.getId();var G=this.getMessageNotifier();if(G&&F===G.getId()){F+="-messageNotifierView";}else{F+="-messageView";}var H=new d.NotifierView(F,{title:v.getTitle(),visibleItems:this._visibleItems});if(v._bEnableMessageSelect){H.addStyleClass("sapUiNotifierSelectable");}var J=v.getMessages();for(var i=0;i<J.length;i++){var V=g(J[i],v,this);H.addMessage(V);}v.addAggregation("views",H,true);u.addContent(H);break;}};d.HOVER_ITEM_HEIGHT=16;
d.prototype.init=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._iCalloutWidth=parseInt(250);this._iCalloutHeight=parseInt(200);this._visibleItems=5;this._eventListener=q.proxy(e,this);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._togglerPosition="50%";this._gapMessageArea="5";this._sSeverestMessageLevel=a.None;q(window).bind("resize",q.proxy(O,this));this._proxyEnableMessageSelect=q.proxy(E,this);this.data("sap-ui-fastnavgroup","true",true);this.setAlwaysShowToggler(false);};
d.prototype.exit=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;delete this._iCalloutWidth;delete this._iCalloutHeight;delete this._visibleItems;delete this._eventListener;if(this.getMessageNotifier()){var i=this.getMessageNotifier();i._oMessageArea.destroy();delete i._oMessageArea;}delete this._resizeFrom;delete this._resizeTo;delete this._oResBundle;delete this._formerVisibleStatus;delete this._togglerPosition;delete this._gapMessageArea;delete this._isHovered;delete this._togglerClicked;delete this._sSeverestMessageLevel;q(window).unbind("resize",O);delete this._proxyEnableMessageSelect;};
var g=function(i,j,u){var v=new d.MessageView(j.getId()+"-messageView-"+i.getId(),{text:i.getText(),timestamp:i.getTimestamp()});v._message=i;if(j.sParentAggregationName=="messageNotifier"){if(u.getVisibleStatus()==b.Max){v.setIcon(i.getIcon()||i.getDefaultIcon("32x32"));}else{v.setIcon(i.getIcon()||i.getDefaultIcon());}}else{v.setIcon(i.getIcon());}return v;};var r=function(i,j){j.attachEvent("_childControlCalling",i._eventListener,i);};var h=function(i,j){j.detachEvent("_childControlCalling",i._eventListener,i);};
d.prototype.addNotifier=function(i){if(i){var j=(this.getVisibleStatus()==b.None)?true:false;this.addAggregation("notifiers",i,j);r(this,i);}return this;};
d.prototype.insertNotifier=function(i,j){if(i){this.insertAggregation("notifiers",i,j);r(this,i);}return this;};
d.prototype.removeNotifier=function(i){var j=this.removeAggregation("notifiers",i);h(this,j);return j;};
d.prototype.removeAllNotifiers=function(){var j=this.removeAllAggregation("notifiers");for(var i=0;i<j.length;i++){var u=j[i];h(this,u);}return j;};
d.prototype.destroyNotifiers=function(){var j=this.getNotifiers();for(var i=0;i<j.length;i++){var u=j[i];h(this,u);}this.destroyAggregation("notifiers");return this;};
var E=function(i){var j=this.getMessageNotifier();if(j&&j.getId()===i.getParameter("notifier").getId()){j.invalidate();}};
d.prototype.setMessageNotifier=function(i){var j=this.getMessageNotifier();if(j){j._oMessageArea.destroy();delete j._oMessageArea;j.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);h(this,j);}this.setAggregation("messageNotifier",i);if(i){i._oMessageArea=new d.MessageView(this.getId()+"-inplaceMessage");i._oMessageArea.setParent(i);i.attachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);r(this,i);}return this;};
d.prototype.destroyMessageNotifier=function(i){var j=this.getMessageNotifier();if(j){j._oMessageArea.destroy();delete j._oMessageArea;j.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);h(this,j);}this.destroyAggregation("messageNotifier");return this;};
var S=function(i,j){var T=i.$();switch(j){case b.Min:T.addClass("sapUiNotificationBarMinimized");break;case b.Max:var H=i.getHeightOfStatus(i.getVisibleStatus());T.addClass("sapUiNotificationBarMaximized");T.css("height",H);var $=i.$("containers");$.css("max-height",H);break;case b.None:if(!i._resizeTo){T.css("display","none");}break;case b.Default:default:T.removeClass("sapUiNotificationBarMaximized");T.removeClass("sapUiNotificationBarMinimized");break;}};var R=function(T){if(w(T)){var F=T.getHeightOfStatus(T._resizeFrom);var $=T.$();$.css("height",F);var j=T.getHeightOfStatus(T._resizeTo);$.stop(true,true).animate({height:j},"fast",function(){var u=T.getVisibleStatus();if(u==="None"){$.css("display","none");if(T.hasItems()){if(T.getMessageNotifier()){var v=T.getMessageNotifier();v.$().css("display","none");}if(T.getNotifiers().length>0){var x=T.getNotifiers();for(var i=0;i<x.length;i++){x[i].$().css("display","none");}}}}S(T,u);p(T,u);});}else{var u=T.getVisibleStatus();S(T,u);}delete T._resizeFrom;delete T._resizeTo;};var k=function(j){if(j.getMessageNotifier()&&j.getMessageNotifier().hasItems()){var $;var u=j.getId()+"-notifiers";var v=q(document.getElementById(u));if(v.length>0){var T=parseInt(v.width());var x=v.children();for(var i=0;i<x.length;i++){var y=q(x[i]);if(y.hasClass("sapUiNotifier")){T-=y.width();}else if(y.hasClass("sapUiNotifierSeparator")){T-=y.width();}else if(y.hasClass("sapUiInPlaceMessage")){$=y;}}if($){T-=j._gapMessageArea+2;$.css("width",T+"px");}}}};
d.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());var u=[];var v=this.getVisibleStatus()===b.Max;if(v){var x=this.getMessageNotifier();if(x!=null){var y=x.getMessages();var z=x.getId()+"-messageNotifierView-messageView-";for(var i=y.length-1;i>=0;i--){var A=document.getElementById(z+y[i].getId());if(A){u.push(A);}}}var B=this.getNotifiers();for(var i=0;i<B.length;i++){var y=B[i].getMessages();var z=B[i].getId()+"-notifierView-messageView-";for(var j=y.length-1;j>=0;j--){var A=document.getElementById(z+y[j].getId());if(A){u.push(A);}}}}else{var B=this.getNotifiers();for(var i=0;i<B.length;i++){var A=B[i].getDomRef();if(A){u.push(A);}}var x=this.getMessageNotifier();if(x!=null){var A=x.getDomRef();if(A){u.push(A);}A=this.getDomRef("inplaceMessage");if(A&&q(A).hasClass("sapUiInPlaceMessageSelectable")){u.push(A);}}}this._oItemNavigation.setItemDomRefs(u);R(this);k(this);m(this,this.getMessageNotifier());n(this);if(D.browser.mobile){var $=this.$("toggler");if(this.getVisibleStatus()!==b.None){$.css("display","block");}else{$.css("display","none");}}};
var m=function(T,i){if(i&&i.hasItems()){var $=i.$("counter");$.removeClass("sapUiMessageInformation");$.removeClass("sapUiMessageSuccess");$.removeClass("sapUiMessageWarning");$.removeClass("sapUiMessageError");s(T,i);var j=T._sSeverestMessageLevel;$.addClass("sapUiMessage"+j);var u=i.getMessages().length;var K="NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_"+j.toUpperCase()+(u===1?"_SING":"_PL");o(T,i,K,u);}};var n=function(T){var j=T.getNotifiers();for(var i=0;i<j.length;i++){var u=j[i].getMessages().length;var K="NOTIBAR_NOTIFIER_COUNT_TEXT_"+(u===1?"SING":"PL");o(T,j[i],K,u);}};var o=function(T,i,K,j){var $=i.$("description");var u=T._oResBundle.getText(K,[j]);$.html(u);};var O=function(i){k(this);};var w=function(i){if(i._resizeFrom&&i._resizeTo){if(i._resizeFrom!=i._resizeTo){return true;}}return false;};
d.prototype.hasItems=function(){var j=this.getNotifiers();if(j.length>0){for(var i=0;i<j.length;i++){var u=j[i];if(u.hasItems()){return true;}}}if(this.getMessageNotifier()){if(this.getMessageNotifier().hasItems()){return true;}}return false;};
var p=function(i,j){var u="none";var $=i.$();switch(j){case b.Max:case b.None:break;case b.Min:$.stop().animate({height:i.getHeightOfStatus(j)},{duration:"fast",queue:true});$.addClass("sapUiNotificationBarMinimized");i.$("notifiers").css("display","none");u="block";break;default:case b.Default:$.stop().animate({height:i.getHeightOfStatus(j)},{duration:"fast",queue:true});$.removeClass("sapUiNotificationBarMaximized");$.removeClass("sapUiNotificationBarMinimized");break;}var v=i.$("hoverItem");v.css("display",u);};
d.prototype.onfocusin=function(i){if(this._togglerClicked){delete this._togglerClicked;i.stopImmediatePropagation(true);}};
d.prototype.onclick=function(i){this._togglerClicked=true;this.$().blur();var $=q(document.activeElement);t(this);var j=i.target.id;var u=j.split("-");if(u){var v=this.getVisibleStatus();var x=u.length-1;switch(u[x]){case"ArrowUp":if(v==="Min"){this.setVisibleStatus("Default");}else{this.setVisibleStatus("Max");}break;case"ArrowDown":if(v==="Max"){this.setVisibleStatus("Default");}else{this.setVisibleStatus("Min");}i.preventDefault();break;case"BarUp":if(this._formerVisibleStatus){this.setVisibleStatus(this._formerVisibleStatus);}else{this.setVisibleStatus("Default");}break;case"BarDown":this._formerVisibleStatus=v;this.setVisibleStatus("Min");$.blur();break;default:if($.hasClass("sapUiNotifier")){$.focus();}else{if(this.hasItems()){var y=this.getNotifiers();if(y.length>0){var z=q(y[0]);z.focus();}else{var A=this.getMessageNotifier();if(A){q(A).focus();}}}}break;}}};
d.prototype.onThemeChanged=function(i){if(this.getDomRef()){this.invalidate();}};
var t=function(j){var u=j.getNotifiers();for(var i=0;i<u.length;i++){var v=u[i];v._oCallout.close();}if(j.getMessageNotifier()){j.getMessageNotifier()._oCallout.close();}};
d.prototype.getHeightOfStatus=function(i){var j="";if(i==b.Min){j="sapUiNotificationBarHeightMinimized";}else if(i==b.Default){j="sapUiNotificationBarHeight";}else if(i==b.Max){j="sapUiNotificationBarHeightMaximized";j=P.get(j);var u=j.indexOf("%");if(u!=-1){var v=j.substring(0,u);var H=q(window).height();H=parseInt(H/100*v);var _=parseInt(this.getHeightOfStatus(b.Default));if(H<_){H=_+1;}}else{var x="No valid percantage value given for maximized size. 400px is used";L.warning(x);H=400;}return H+"px";}else{return"0px";}j=P.get(j);return j;};
d.prototype.setVisibleStatus=function(i){this._resizeFrom=this.getVisibleStatus();this._resizeTo=i;if(this._resizeFrom!==this._resizeTo){if(i===b.None){t(this);if(this.getDomRef()){p(this,i);}else{this.$().css({"height":"0px","display":"none"});}}this.setProperty("visibleStatus",i);this.fireResize({status:i});}return this;};
d.prototype.setAlwaysShowToggler=function(A){if(D.browser.mobile){A=true;}this.setProperty("alwaysShowToggler",A,true);var $=this.$("toggler");if(A){$.css("display","block");}else{$.css("display","none");}return this;};
return d;});
sap.ui.predefine('sap/ui/ux3/NotificationBarRenderer',["sap/ui/thirdparty/jquery",'sap/ui/core/Icon',"sap/ui/ux3/library"],function(q,I,l){"use strict";var N=l.NotificationBarStatus;var a;var b={};
b.render=function(o,i){a=a||sap.ui.require("sap/ui/ux3/NotificationBar");w(o,i);W(o,i);e(o,i);};
var w=function(o,i){o.write("<div");o.writeControlData(i);if(i.getVisibleStatus()===N.None){if(i.$().length>0){if(i._resizeFrom){i.$().stop().animate({height:0},"fast",function(){i.$().css("display","none");o.addStyle("display","none");o.writeAttribute("aria-hidden","true");});}else{o.addStyle("display","none");o.writeAttribute("aria-hidden","true");}}else{o.addStyle("display","none");o.writeAttribute("aria-hidden","true");}}else{o.writeAttribute("aria-hidden","false");o.addStyle("display","block");}o.writeStyles();o.addClass("sapUiNotificationBar");if(i._resizeTo){if(i._resizeFrom==N.Max){if(i._resizeTo==N.Default){o.addClass("sapUiNotificationBarMaximized");}}}o.writeClasses();o.write(">");f(o,i);};var r=function(o,i){var s=i.getVisibleStatus();if(s!=="None"){var n=i.getId()+"-toggler";o.write("<div");o.writeAttribute("id",n);o.addClass("sapUiBarToggle");if(s!=="Min"){o.addClass("sapUiBarToggleWide");}o.writeClasses();if(i.getAlwaysShowToggler()){o.addStyle("display","block");o.writeStyles();}o.write(">");R(o,i,"ArrowUp");R(o,i,"ArrowDown");R(o,i,"BarUp");R(o,i,"BarDown");o.write("</div>");}else{o.addStyle("display","none");o.writeStyles();}};var R=function(o,i,s){o.write("<div");var n=i.getId()+"-"+s;o.writeAttribute("id",n);var S=i.getVisibleStatus();var H=true;var t="";switch(s){case"ArrowUp":if(S==="Default"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_ENLARGE");break;case"ArrowDown":if(S==="Max"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_MINIMIZE");break;case"BarUp":if(S==="Min"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_BAR_UP");break;case"BarDown":if(S==="Max"||S==="Default"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_BAR_DOWN");break;}o.writeAttributeEscaped("title",t);if(H){o.addClass("sapUiBarToggleHide");}o.addClass("sapUiBarToggle"+s);o.addClass("sapUiBarToggleItem");o.writeClasses();o.write(">");o.write("</div>");};var f=function(o,i){o.write("<div");var s=i.getId()+"-hoverItem";o.writeAttribute("id",""+s);var S=i.getVisibleStatus();if(S==="Min"){o.addStyle("top","-"+a.HOVER_ITEM_HEIGHT+"px");o.addStyle("display","block");}else{o.addStyle("display","none");}if(i.getDomRef()){var $=q(i.getDomRef());var n=$.width()+"px";o.addStyle("width",n);}o.writeStyles();o.addClass("sapUiNotiHover");o.writeClasses();o.write(">");o.write("</div>");};var W=function(o,i){if(i.getResizeEnabled()){r(o,i);}if(i.hasItems()){if(i.getVisibleStatus()==N.Max){c(o,i);}else{d(o,i);}}};var c=function(o,n){var p=n.getNotifiers();var M=n.getMessageNotifier();var s="";o.write("<div");o.writeAttribute("id",n.getId()+"-containers");o.addClass("sapUiNotifierContainers");o.writeClasses();o.write(">");if(M&&M.hasItems()){M.destroyAggregation("views",true);s=M.getId()+"-messageNotifierView";var t=C(s,M);M.addAggregation("views",t,true);o.renderControl(t);}if(p.length>0){for(var i=0;i<p.length;i++){if(p[i].hasItems()){p[i].destroyAggregation("views",true);s=p[i].getId()+"-notifierView";var v=C(s,p[i]);p[i].addAggregation("views",v,true);o.renderControl(v);}}}o.write("</div");};var d=function(o,n){var p=n.getNotifiers();var M=n.getMessageNotifier();o.write("<ul");o.writeAttribute("id",n.getId()+"-notifiers");o.addClass("sapUiNotifiers");o.writeClasses();o.write(">");var s=false;for(var i=0;i<p.length;i++){if(p[i].hasItems()){s=true;break;}}var t=(M&&M.hasItems())?true:false;if(s){h(o,p);}if(s&&t){o.write("<li");o.addClass("sapUiNotifierSeparator");o.writeClasses();o.write(">");o.write("&nbsp;");o.write("</li>");}if(t){k(o,M,n);}o.write("</ul>");};var e=function(o,i){o.write("</div>");};var g=function(o,n,M){var i=n.getId();o.write("<li");o.writeElementData(n);o.addClass("sapUiNotifier");o.writeClasses();o.writeAttribute("tabindex","-1");o.writeAttribute("aria-describedby",i+'-description>');o.write(">");j(o,n.getIcon(),M);o.write('<div id="'+i+'-description"');o.addStyle("display","none");o.writeStyles();o.write(">");o.write("</div>");var p=n.getMessages().length;if(p>0){o.write('<div id="'+i+'-counter" role="tooltip"');o.addClass("sapUiNotifierMessageCount");if(M){o.addClass("sapUiMessage");}o.writeClasses();o.write(">");if(p>99){p=">99";}o.write(p);o.write("</div>");}o.write("</li>");};var C=function(s,n){var o=new a.NotifierView(s,{title:n.getTitle(),renderMode:"maximized"});if(n._bEnableMessageSelect){o.addStyleClass("sapUiNotifierSelectable");}var M=n.getMessages();for(var i=0;i<M.length;i++){var p=M[i];var t=new a.MessageView(s+"-messageView-"+p.getId(),{text:p.getText(),timestamp:p.getTimestamp()});t._message=p;t.setIcon(p.getIcon()||p.getDefaultIcon("32x32"));o.addMessage(t);}return o;};var h=function(o,n){for(var i=0;i<n.length;i++){g(o,n[i],false);}};var j=function(o,u,M){if(u==null||u==""){var i=new I({useIconTooltip:false});i.addStyleClass("sapUiNotifierIcon");if(M){i.setSrc("sap-icon://alert");}else{i.setSrc("sap-icon://notification-2");}o.renderControl(i);return;}o.write("<img alt=\"\"");o.addClass("sapUiNotifierIcon");o.writeClasses();o.writeAttributeEscaped("src",u);o.write(">");};var k=function(o,n,i){g(o,n,true);m(o,n,i);};var m=function(o,M,n){if(M.hasItems()){var i=M.getMessages();var p=i[i.length-1];var s=M._oMessageArea;s._message=p;var t=n.getId()+"-inplaceMessage-"+s._message.getId();o.write("<li");o.writeAttribute("id",t);o.addClass("sapUiInPlaceMessage");o.writeClasses();if(n._gapMessageArea){var u=n._gapMessageArea+"px";o.addStyle("margin-left",u);o.writeStyles();}o.write(">");if(p.getText()!=""){o.write("<div");o.writeControlData(s);o.writeAttribute("tabindex","-1");o.addClass("sapUiNotifierMessageText");o.addClass("sapUiInPlaceMessage");if(M._bEnableMessageSelect&&!s._message.getReadOnly()){o.addClass("sapUiInPlaceMessageSelectable");}o.writeClasses();o.write(">");o.writeEscaped(p.getText());o.write("</div>");}if(p.getTimestamp()!=""){o.write("<div");o.addClass("sapUiNotifierMessageTimestamp");o.addClass("sapUiInPlaceMessage");o.writeClasses();o.write(">");o.writeEscaped(p.getTimestamp());o.write("</div>");}o.write("</li>");}};return b;},true);
sap.ui.predefine('sap/ui/ux3/Notifier',['sap/ui/thirdparty/jquery','sap/ui/commons/Callout','sap/ui/core/Element','./library','sap/ui/core/library','sap/ui/Device','sap/base/Log',"sap/ui/base/EventProvider"],function(q,C,E,l,c,D,L,a){"use strict";var M=c.MessageType;
var N=E.extend("sap.ui.ux3.Notifier",{metadata:{library:"sap.ui.ux3",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:null}},aggregations:{messages:{type:"sap.ui.core.Message",multiple:true,singularName:"message"},views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},events:{messageSelected:{parameters:{message:{type:"sap.ui.core.Message"},notifier:{type:"sap.ui.ux3.Notifier"}}}}}});
var b=function(){this.fireEvent("_childControlCalling",{type:"openCallout",callout:this._oCallout,notifier:this});};var f=function(o){if(o.getSource()){o.getSource().destroyContent();}if(this._oCallout){this._oCallout.$().css("display","none");}};
N.prototype.hasItems=function(){if(this.getMessages().length>0){return true;}return false;};
N.prototype.init=function(){this._oCallout=new C(this.getId()+"-callout",{beforeOpen:q.proxy(b,this),open:function(o){this.$().css({position:"fixed",display:"block"});},close:q.proxy(f,this),collision:"none"});this._oCallout.addStyleClass("sapUiNotifierCallout");if(D.browser.mobile){this._oCallout.setOpenDelay(0);}this._oCallout.setMyPosition("begin bottom");this._oCallout.setAtPosition("begin top");this._oCallout.setTip=function(){C.prototype.setTip.apply(this,arguments);var $=this.$("arrow");$.css("bottom","-24px");var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){$.css("left","6px");}};this.setTooltip(this._oCallout);this.setTooltip=function(){L.warning("Setting toolstips for notifiers deactivated");return this;};this._proxyEnableMessageSelect=q.proxy(e,this);this.attachEvent(a.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect);};
var e=function(o){var s=o.getParameter("EventId");if(s==="messageSelected"){if(o.getParameter("type")==="listenerAttached"){this._bEnableMessageSelect=true;}else if(o.getParameter("type")==="listenerDetached"){this._bEnableMessageSelect=false;}this.fireEvent("_enableMessageSelect",{enabled:this._bEnableMessageSelect,notifier:this});}};
N.prototype.exit=function(o){this._oCallout=undefined;if(this._oMessageView){this._oMessageView.destroy();delete this._oMessageView;}this.detachEvent(a.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect);delete this._proxyEnableMessageSelect;};
N.prototype.onclick=function(o){o.preventDefault();this.$().trigger("mouseover");};
var F=function(t,m,T){var s=m?m.getLevel():M.None;T.fireEvent("_childControlCalling",{type:t,notifier:T,level:s,message:m,callout:T._oCallout});};
N.prototype.addMessage=function(m){this.addAggregation("messages",m);F("added",m,this);return this;};
N.prototype.insertMessage=function(m,i){this.insertAggregation("messages",m,i);F("added",m,this);return this;};
N.prototype.removeMessage=function(m){var r=this.removeAggregation("messages",m);if(r){F("removed",r,this);}return r;};
N.prototype.removeAllMessages=function(){var r=this.removeAllAggregation("messages");if(r.length>0){F("removed",null,this);}return r;};
N.prototype.destroyMessages=function(){var i=this.getMessages().length;this.destroyAggregation("messages");if(i>0){F("removed",null,this);}return this;};
return N;});
sap.ui.predefine('sap/ui/ux3/Overlay',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/Popup','./library','./OverlayRenderer','sap/ui/core/library','sap/ui/dom/jquery/control','sap/ui/dom/jquery/Focusable'],function(q,C,P,l,O,c){"use strict";var a=c.OpenState;
var b=C.extend("sap.ui.ux3.Overlay",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{openButtonVisible:{type:"boolean",group:"Misc",defaultValue:true},closeButtonVisible:{type:"boolean",group:"Misc",defaultValue:true}},events:{close:{allowPreventDefault:true,parameters:{id:{type:"string"}}},closed:{allowPreventDefault:true,parameters:{id:{type:"string"}}},openNew:{parameters:{id:{type:"string"}}},open:{parameters:{id:{type:"string"}}}}}});
b.prototype.init=function(){var t=this;this._oPopup=new P(this,false,true);this._oPopup.attachOpened(function(e){var d=q(document.getElementById(t._initialFocusId))[0];if(!d&&t._getShell()&&t.getOpenButtonVisible()){d=document.getElementById(t._getOpenButtonId());}else if(!d&&t._getShell()&&t.getCloseButtonVisible()){d=document.getElementById(t._getCloseButtonId());}else if(!d){d=t.$("content").firstFocusableDomRef();}if(!d){d=t.$().firstFocusableDomRef();}if(d){d.focus();}});this._oPopup.attachClosed(function(e){t.fireClosed({id:t.getId()});});this._overridePopupEventing();};
b.prototype._overridePopupEventing=function(){this._oPopup.onmousedown=function(e){return;};};
b.prototype._getShell=function(){var s=q(".sapUiUx3Shell").control();if(s.length>0&&!this._oShell){this._oShell=s.length?s[0]:null;}return this._oShell;};
b.prototype._getCloseButtonId=function(){return this.getId()+"-close";};
b.prototype._getOpenButtonId=function(){return this.getId()+"-openNew";};
b.prototype._initDom=function(f,F,A){var s=q(".sapUiUx3Shell").control();this._oShell=s.length?s[0]:null;s=this._oShell;this.$().css("position","fixed");if(s){this._bFocusEventsRegistered=true;s.syncWithCanvasSize(this.getId(),true,f,F,A);this.$("firstFocusDummyPaneFw").attr("tabindex","0").focusin(q.proxy(s.focusFirstHdr,s));this.$("firstFocusDummyPaneBw").attr("tabindex","0").focusin(q.proxy(s.focusLastTool,s));this.$("LastFocusDummyPane").attr("tabindex","0").focusin(q.proxy(s.focusPaneStart,s));}else{this.$().css("bottom","0").css("top","0").css("left","0").css("right","0");}};
b.prototype._cleanupDom=function(){if(this._oShell){this._oShell.syncWithCanvasSize(this.getId(),false);}if(this._bFocusEventsRegistered){this._bFocusEventsRegistered=false;this.$("firstFocusDummyPaneFw").removeAttr("tabindex").unbind("focusin");this.$("firstFocusDummyPaneBw").removeAttr("tabindex").unbind("focusin");this.$("LastFocusDummyPane").removeAttr("tabindex").unbind("focusin");}};
b.prototype.onAfterRendering=function(){var p=this._oPopup.getOpenState();if(p===a.OPEN||p===a.OPENING){this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));}};
b.prototype.onBeforeRendering=function(){};
b.prototype.exit=function(){this.close();this._oPopup.destroy();this._oPopup=null;this._oShell=null;};
b.prototype.open=function(i){this._initialFocusId=i;if(this._oPopup.isOpen()){return;}if(i){this._oPopup.setInitialFocusId(i);}this._oPreviousFocus=P.getCurrentFocusInfo();this._oPopup.open(400);this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));this.fireOpen({id:this.getId()});};
b.prototype.close=function(){if(!this._oPopup.isOpen()){return;}this._oPopup.close(400);setTimeout(this.restorePreviousFocus.bind(this),400);this._cleanupDom();};
b.prototype.onclick=function(e){this._handleButtonEvent(e);};
b.prototype.onsapselect=function(e){this._handleButtonEvent(e);};
b.prototype._handleButtonEvent=function(e){var d=e.target.id;if(d===this._getCloseButtonId()){if(this.fireClose({id:this.getId()})){this.close();}}else if(d===this._getOpenButtonId()){this.fireOpenNew({id:this.getId()});}};
b.prototype._getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var t;if(r){t=r.getText(k);}if(t&&A){for(var i=0;i<A.length;i++){t=t.replace("{"+i+"}",A[i]);}}return t?t:k;};
b.prototype._setFocusFirst=function(){var e=document.getElementById(this._getOpenButtonId());if(e){e.focus();}};
b.prototype._setFocusLast=function(){var e=document.getElementById(this._getCloseButtonId());if(e){e.focus();}};
b.prototype._applyChanges=function(o){return this;};
b.prototype.isOpen=function(){return this._oPopup.isOpen();};
b.prototype.restorePreviousFocus=function(){P.applyFocusInfo(this._oPreviousFocus);};
return b;});
sap.ui.predefine('sap/ui/ux3/OverlayContainer',['./Overlay','./library','./OverlayContainerRenderer','sap/ui/dom/jquery/Focusable'],function(O,l,a){"use strict";
var b=O.extend("sap.ui.ux3.OverlayContainer",{metadata:{library:"sap.ui.ux3",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
b.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}else if(!f&&this.getOpenButtonVisible()){f=this.getDomRef("openNew");}if(f){f.focus();}};
b.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()){if(this.getDomRef("openNew")){this.getDomRef("openNew").focus();}}else if(this.getCloseButtonVisible()){if(this.getDomRef("close")){this.getDomRef("close").focus();}}else{if(this.$("content").firstFocusableDomRef()){this.$("content").firstFocusableDomRef().focus();}}};
return b;});
sap.ui.predefine('sap/ui/ux3/OverlayContainerRenderer',['sap/ui/core/Renderer','./OverlayRenderer'],function(R,O){"use strict";var a=R.extend(O);
a.renderContent=function(r,c){r.write("<div role='Main' class='sapUiUx3OCContent' id='"+c.getId()+"-content'>");var b=c.getContent();for(var i=0;i<b.length;i++){var d=b[i];r.renderControl(d);}r.write("</div>");};
a.addRootClasses=function(r,c){r.addClass("sapUiUx3OC");};
a.addOverlayClasses=function(r,c){r.addClass("sapUiUx3OCOverlay");};
return a;},true);
sap.ui.predefine('sap/ui/ux3/OverlayDialog',['sap/ui/core/IntervalTrigger','./Overlay','./library','./OverlayDialogRenderer','sap/base/Log','sap/ui/dom/jquery/Focusable'],function(I,O,l,a,L){"use strict";
var b=O.extend("sap.ui.ux3.OverlayDialog",{metadata:{library:"sap.ui.ux3",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
b.prototype.init=function(){O.prototype.init.apply(this);this.setProperty("openButtonVisible",false);b.Trigger=new I(300);};
b.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}if(f){f.focus();}};
b.prototype._setFocusFirst=function(){var f;if(this.getCloseButtonVisible()){f=this.getDomRef("close");}else{f=this.$("content").firstFocusableDomRef();}if(f){f.focus();}};
b.prototype.setOpenButtonVisible=function(v){L.warning("OverlayDialog does not support an openButton.");return this;};
b.prototype.setWidth=function(w){if(w=="auto"||w=="inherit"){w="auto";}return this.setProperty("width",w);};
b.prototype.setHeight=function(h){if(h=="auto"||h=="inherit"){h="auto";}return this.setProperty("height",h);};
b.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);this._cleanup();};
b.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);b.Trigger.addListener(this._checkChange,this);};
b.prototype._cleanup=function(){b.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null;};
b.prototype.exit=function(){this._cleanup();O.prototype.exit.apply(this,arguments);};
b.prototype._checkChange=function(){if(!this.getDomRef()){return;}var $=this.$("content"),c=this.$(),A=this.getWidth()==="auto",d=this.getHeight()==="auto";var e=A?Math.round(c.width()/2):$.width(),f=d?Math.round(c.height()/2):$.height(),o=c.width(),g=c.height();if(e!=this.contentWidth||f!=this.contentHeight||o!=this.overlayWidth||g!=this.overlayHeight){$.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=e;this.contentHeight=f;this.overlayWidth=o;this.overlayHeight=g;var h=this.$("close");if(this.contentWidth<this.overlayWidth){$.css("left","50%");$.css("right","auto");$.css("margin-left",Math.round((-1)*this.contentWidth/2)+"px");$.css("width",d?this.contentWidth:this.getWidth());h.css("right","50%");h.css("margin-right",Math.round((-1)*this.contentWidth/2-10)+"px");}else{$.css("left","0");$.css("right","10px");$.css("margin-left","0");$.css("width","auto");h.css("right","0");h.css("margin-right","0");}if(this.contentHeight<this.overlayHeight-30){$.css("top","50%");$.css("bottom","auto");$.css("margin-top",Math.round((-1)*this.contentHeight/2)+"px");$.css("height",d?this.contentHeight:this.getHeight());h.css("top","50%");h.css("margin-top",Math.round((-1)*this.contentHeight/2-10)+"px");}else{$.css("top","10px");$.css("bottom","30px");$.css("margin-top","0");$.css("height","auto");h.css("top","0");h.css("margin-top","0");}}};
return b;});
sap.ui.predefine('sap/ui/ux3/OverlayDialogRenderer',['sap/ui/core/Renderer','./OverlayRenderer'],function(R,O){"use strict";var a=R.extend(O);
a.renderContent=function(r,c){r.write("<div role='Main' class='sapUiUx3ODContent' id='"+c.getId()+"-content'>");var b=c.getContent();for(var i=0;i<b.length;i++){var d=b[i];r.renderControl(d);}r.write("</div>");};
a.addRootClasses=function(r,c){r.addClass("sapUiUx3OD");};
a.addOverlayClasses=function(r,c){r.addClass("sapUiUx3ODOverlay");};
return a;},true);
sap.ui.predefine('sap/ui/ux3/OverlayRenderer',[],function(){"use strict";var O={};
O.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3Overlay");if(this.addRootClasses){this.addRootClasses(r,c);}r.writeClasses();r.write(">");r.write("<div role='presentation'");r.addClass("sapUiUx3OverlayOverlay");if(this.addOverlayClasses){this.addOverlayClasses(r,c);}r.writeClasses();r.write(">");r.write("</div>");r.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-firstFocusDummyPaneFw'></span>");r.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-firstFocusDummyPaneBw'></span>");if(c.getOpenButtonVisible()){r.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayOpenButton' id='"+c.getId()+"-openNew' tabindex=\"0\" title=\""+c._getText("OVERLAY_OPEN_BUTTON_TOOLTIP")+"\">"+c._getText("OVERLAY_OPEN_BUTTON_TEXT")+"</a>");}if(c.getCloseButtonVisible()){r.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayCloseButton' id='"+c.getId()+"-close' tabindex=\"0\" aria-label='"+c._getText("OVERLAY_CLOSE_BUTTON_TOOLTIP")+"'></a>");}if(this.renderContent){this.renderContent(r,c);}r.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-LastFocusDummyPane'></span>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/ui/ux3/QuickView',['sap/ui/thirdparty/jquery','sap/ui/commons/CalloutBase','sap/ui/core/delegate/ItemNavigation','./ActionBar','./library','./QuickViewRenderer','sap/ui/core/TooltipBase'],function(q,C,I,A,l,Q,T){"use strict";var F=l.FollowActionState;
var a=C.extend("sap.ui.ux3.QuickView",{metadata:{library:"sap.ui.ux3",properties:{type:{type:"string",group:"Misc",defaultValue:null},firstTitle:{type:"string",group:"Misc",defaultValue:null},firstTitleHref:{type:"string",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showActionBar:{type:"boolean",group:"Misc",defaultValue:true},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:F.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},openActionEnabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}},navigate:{allowPreventDefault:true,parameters:{href:{type:"string"}}}}}});
a.prototype.init=function(){var o;function b(d){var p=d.getParameters();this.fireActionSelected(p);}function c(d){var p=d.getParameters();this.fireFeedSubmit(p);}C.prototype.init.call(this);if(!this.getActionBar()){o=new A();o.attachActionSelected(q.proxy(b,this));o.attachFeedSubmit(q.proxy(c,this));this.setAggregation("actionBar",o,true);}};
a.prototype.onmouseover=function(e){var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}return;}T.prototype.onmouseover.call(this,e);};
a.prototype.onAfterRendering=function(){var f=this.getDomRef(),d=[];var r=this.$("title");d.push(r);r=this.$("link");if(!r.length){r=this.$("name");}if(!r.length){return;}d.push(r);r=this.$("descr");if(r.length){d.push(r);}if(!this.oItemNavigation){this.oItemNavigation=new I(null,null,false);this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(false);this.oItemNavigation.setSelectedIndex(1);this.oItemNavigation.setPageSize(d.length);};
a.prototype.onclick=function(e){var t=e.target;if(!t||!t.hasAttribute("href")){return;}if(!this.fireEvent("navigate",{href:t.href},true,false)){e.preventDefault();}};
a.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};
a.prototype.insertAction=function(o,i){if(this.getActionBar()){this.getActionBar().insertBusinessAction(o,i);}return this;};
a.prototype.addAction=function(o){if(this.getActionBar()){this.getActionBar().addBusinessAction(o);}return this;};
a.prototype.removeAction=function(o){if(this.getActionBar()){this.getActionBar().removeBusinessAction(o);}return this;};
a.prototype.removeAllActions=function(){if(this.getActionBar()){this.getActionBar().removeAllBusinessActions();}return this;};
a.prototype.getActions=function(){if(this.getActionBar()){this.getActionBar().getBusinessActions();}return this;};
a.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions();}return this;};
a.prototype.setFollowState=function(f){if(this.getActionBar()){this.getActionBar().setFollowState(f);}return this;};
a.prototype.getFollowState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFollowState();}return r;};
a.prototype.setFlagState=function(f){if(this.getActionBar()){this.getActionBar().setFlagState(f);}return this;};
a.prototype.getFlagState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFlagState();}return r;};
a.prototype.setFavoriteState=function(f){if(this.getActionBar()){this.getActionBar().setFavoriteState(f);}return this;};
a.prototype.getFavoriteState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFavoriteState();}return r;};
a.prototype.setFavoriteActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFavorite(e);}return this;};
a.prototype.getFavoriteActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFavorite();}return r;};
a.prototype.setFlagActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFlag(e);}return this;};
a.prototype.getFlagActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFlag();}return r;};
a.prototype.setUpdateActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowUpdate(e);}return this;};
a.prototype.getUpdateActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowUpdate();}return r;};
a.prototype.setFollowActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFollow(e);}return this;};
a.prototype.getFollowActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFollow();}return r;};
a.prototype.setOpenActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowOpen(e);}return this;};
a.prototype.getOpenActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowOpen();}return r;};
a.prototype.setIcon=function(i){this.setProperty("icon",i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}return this;};
a.prototype.setActionBar=function(o){this.setAggregation("actionBar",o,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon());}return this;};
return a;});
sap.ui.predefine('sap/ui/ux3/QuickViewRenderer',['sap/ui/commons/CalloutBaseRenderer','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(C,R,I){"use strict";var Q=R.extend(C);
Q.renderContent=function(r,c){var a=sap.ui.getCore().getConfiguration().getAccessibility();var t=c.getType(),n=c.getFirstTitle(),h=c.getFirstTitleHref(),i=c.getIcon(),d=c.getSecondTitle(),w=c.getWidth(),s=c.getId(),b=c.getTooltip_AsString(),o;r.write("<div");if(b){r.writeAttributeEscaped("title",b);}if(a){r.writeAttribute("role","dialog");r.writeAttribute("aria-labelledby",s+"-title");}r.addClass("sapUiUx3QV");r.writeClasses();if(w){r.addStyle("width",w);r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",s+"-title");r.writeAttribute("tabindex","-1");r.addClass("sapUiUx3QVHeader");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");if(i||n||d){r.write("<div");if(a){r.writeAttribute("role","heading");}r.addClass("sapUiUx3QVHeading");r.writeClasses();r.write(">");if(i){if(I.isIconURI(i)){o={title:n,tabindex:"-1"};}r.writeIcon(i,"sapUiUx3QVIcon",o);}r.write("<span");r.writeAttribute("id",s+"-name");if(a&&d){r.writeAttribute("aria-describedby",s+"-descr");}r.addClass("sapUiUx3QVTitle1");r.writeClasses();r.write(">");if(h){r.write("<a");r.writeAttribute("id",s+"-link");r.writeAttributeEscaped("href",h);r.writeAttribute("tabindex","-1");r.write(">");}r.writeEscaped(n||"");if(h){r.write("</a>");}r.write("</span>");if(d){r.write("<br><span");r.writeAttribute("id",s+"-descr");r.writeAttribute("tabindex","-1");r.addClass("sapUiUx3QVTitle2");r.writeClasses();r.write(">");r.writeEscaped(d);r.write("</span>");}r.write("</div>");}r.write("<div id=\""+s+"-content\">");this.renderBody(r,c);r.write("</div>");r.write("</div>");if(c.getShowActionBar()&&c.getActionBar()){r.renderControl(c.getActionBar());}};
Q.renderBody=function(r,c){var a=c.getContent();for(var i=0;i<a.length;i++){r.write("<div class=\"sapUiUx3QVBody\">");if(a[i]instanceof sap.ui.core.Control){r.renderControl(a[i]);}else if(a[i].getContent&&typeof a[i].getContent=="function"){var b=a[i].getContent();for(var j=0;j<b.length;j++){if(b[j]instanceof sap.ui.core.Control){r.renderControl(b[j]);}}}r.write("</div>");}};
return Q;},true);
sap.ui.predefine('sap/ui/ux3/Shell',['sap/ui/thirdparty/jquery','sap/ui/commons/Menu','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','./ShellRenderer','./ShellPersonalization','./NavigationBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/RenderManager','sap/ui/core/Popup','./ToolPopup','sap/ui/commons/SearchField','sap/ui/commons/Label','./Feeder','sap/ui/commons/library','sap/ui/commons/Button','sap/ui/commons/MenuItem','./NotificationBar','sap/ui/base/Object','sap/ui/Device','sap/base/Log','sap/base/assert','sap/ui/dom/jquery/Focusable'],function(q,M,C,P,l,S,a,N,I,R,b,T,c,L,F,d,B,g,j,k,D,m,n){"use strict";var o=l.NotificationBarStatus;var p=l.FeederType;var r=b.Dock;var s=l.ShellDesignType;var t=l.ShellHeaderType;
var u=C.extend("sap.ui.ux3.Shell",{metadata:{library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:t.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:s.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});
u.WSI_MENU_DELAY=200;u.WSI_OVERFLOW_SCROLL_STEP=250;u.TOOL_PREFIX="-tool-";u.FIRST_RENDERING=true;u.SIDE_BAR_BASE_WIDTH=null;u.PANE_OVERFLOW_BUTTON_HEIGHT=null;
u.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new N(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new N(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new M());var e=this;this._checkResizeClosure=function(){e._checkResize();};this.currentToolPaletteWidth=0;this._updateThemeVariables();};
u.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar;}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar;}this._oSearchField=null;q(window).unbind("resize",this._checkResizeClosure);clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=null;};
u.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").unbind("focusin");if(window.FileReader){var $=this.$("hdr");$.unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);var e=this.$("bgImg");e.unbind('dragover',q.proxy(this._handleDragover)).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};
u.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").focusin(this._mSyncRefs[this._topSyncRefId].focusLast);}if(window.FileReader){var $=this.$("hdr");$.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));var e=this.$("bgImg");e.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}var f=(this._oFacetBar.getAssociatedItems().length>0);var h=this.$("facetBar");h.css("display",(f?"block":"none"));this._adaptContentHeight();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings);}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=new I().setCycling(false);this.addDelegate(this._oPaneItemNavigation);}var i=this.$("paneBarEntries");this._updatePaneBarItemNavigation(i);this._setNotifyVisibility();if(u.FIRST_RENDERING){q(window).bind("resize",this._checkResizeClosure);}this._checkResize();u.FIRST_RENDERING=false;if(D.browser.firefox&&D.browser.version==17){setTimeout(this._checkResize.bind(this),500);}};
u.prototype._updateThemeVariables=function(){u.SIDE_BAR_BASE_WIDTH=parseInt(P.get("sapUiUx3ShellSideBarBaseWidth"));u.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(P.get("sapUiUx3ShellPaneOverflowButtonHeight"));u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=u.PANE_OVERFLOW_BUTTON_HEIGHT;};
u.prototype._checkResize=function(){if(!this.getDomRef()){return;}clearTimeout(this._checkResizeDelayId);this._checkResizeDelayId=setTimeout(function(){this._rerenderPaneBarItems();this._checkToolPaletteSize();}.bind(this),100);};
u.prototype._checkToolPaletteSize=function(h){if(!this.getDomRef()){return;}if(h===undefined){h=!this.getShowTools();}var e=this.$("tp");var i=1;var f=9999999;var w=0;var K=true;if(h){i=0;K=false;}do{var x=i*u.SIDE_BAR_BASE_WIDTH;var y=Math.floor(x/2);var z=Math.floor(x/4);var A=this._bRtl?"right":"left";this.$("canvas").css(A,x+"px");this.$("canvasBackground").css(A,x+"px");this.$("wBar").css("margin-"+A,x+"px");var E={};E[A]=x+"px";this.$("notify").css(E);e.css("width",x+"px");var E={};E["width"]=y+"px";E["margin-"+A]=z+"px";this.$("tp-separator").css(E);if(!K){break;}R.forceRepaint(e[0]);w=e.children().last()[0].offsetTop;if(w>=f){i--;K=false;continue;}f=w;i++;if(i>10){m.error("The ToolPalette is growing too much, this must be a bug.");break;}}while(w>e.height());this.currentToolPaletteWidth=this.getShowTools()?x:0;this._updateOverlaysOnToolPaletteChange();};
u.prototype._updateOverlaysOnToolPaletteChange=function(){var O=this._getSyncRefs();if(this._bRtl){O.css("right",this.currentToolPaletteWidth+"px");}else{O.css("left",this.currentToolPaletteWidth+"px");}};
u.prototype._updatePaneBarItemNavigation=function($){this._oPaneItemNavigation.setRootDomRef($[0]);var e=$.children().toArray();this._oPaneItemNavigation.setItemDomRefs(e);if(this._oPaneItemNavigation.getFocusedIndex()>e.length){this._oPaneItemNavigation.setFocusedIndex(-1);}this._checkPaneBarOverflow($);};
u.prototype._checkPaneBarOverflow=function($){clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=setTimeout(function(){this._delayedCheckPaneBarOverflow($);}.bind(this),200);};
u.prototype._delayedCheckPaneBarOverflow=function($){if(!$){$=this.$("paneBarEntries");}if($.length==0){this._checkPaneBarOverflow();return;}var e=$.parent().height()-(this._bRtl?$.innerHeight():0);var f=0;var E=$.children();E.css("display","inline-block");var h=false;var w=E.length;for(var i=w-1;i>=0;--i){var x=E[i];if(this._bRtl){f=(0-x.offsetLeft);}else{f=x.offsetLeft+x.offsetWidth;}var y=f<e;q(x).css("display",y?"inline-block":"none");var z=sap.ui.getCore().byId(x.id+"-overflow");z&&z.setVisible(!y);if(y){continue;}else{h=true;}}var O=this.$("paneBarOverflowButton");if(h){O.css("display","block");}else{O.css("display","none");if(D.browser.firefox&&D.browser.version==17){R.forceRepaint(document.getElementsByTagName("body")[0]);}}var A=this._changeOverflowButton();if(A){this._checkPaneBarOverflow();}};
u.prototype._adaptOverflowButtonHeight=function(){var $=this.$("paneBarOverflowButton");var e=this.$("paneBarOverflowWrapper");var f=this.$("paneBarOverflowText");var h=this.$("paneBarRight");f.css("width","");var O=u.PANE_OVERFLOW_BUTTON_HEIGHT;var i=f[0].scrollWidth+5;if(i>u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){u.PANE_OVERFLOW_BUTTON_HEIGHT=u.PANE_OVERFLOW_BUTTON_MAX_HEIGHT;}else{u.PANE_OVERFLOW_BUTTON_HEIGHT=i;}$.css("height",u.PANE_OVERFLOW_BUTTON_HEIGHT);e.css("width",u.PANE_OVERFLOW_BUTTON_HEIGHT);f.css("width","100%");h.css("padding-bottom",u.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return(O!=u.PANE_OVERFLOW_BUTTON_HEIGHT);};
u.prototype._changeOverflowButton=function(){var O=null;if(this._sOpenPaneId){O=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow");}var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var f=false;if(O&&O.getVisible()){e=O.getText();f=true;}e=e.toUpperCase();var h=this.$("paneBarOverflowText");h.text(e);h.attr("title",e);h.toggleClass("sapUiUx3ShellPaneEntrySelected",f);return this._adaptOverflowButtonHeight();};
u.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu");};
u.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{'sFocusId':e.id,'oFocusedElement':e}:{};}catch(f){return{};}};
u.prototype.applyFocusInfo=function(f){var e=(f.sFocusId?window.document.getElementById(f.sFocusId):null)||f.oFocusedElement;if(e){e.focus();}};
u._updateToolIcon=function(e){if(e&&e.firstChild){var $=q(e);var f=e.id.substr(e.id.indexOf(u.TOOL_PREFIX)+6);var h=sap.ui.getCore().byId(f);var i;if($.is(".sapUiUx3ShellToolSelected")){i=h.getIconSelected();}else if($.is(".sapUiUx3ShellToolHover")){i=h.getIconHover();}else{i=h.getIcon();}e.firstChild.src=i;}};
u.prototype.onclick=function(e){this.onUserActivation(e);};
u.prototype.onsapspace=function(e){this.onUserActivation(e);};
u.prototype.onsapenter=function(e){this.onUserActivation(e);};
u.prototype.onUserActivation=function(e){var f=e.target.id;var h=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout();}else if(h&&h.parentNode&&h.parentNode.className&&h.parentNode.className.indexOf&&h.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(f);}else if(h&&h.parentNode&&h.parentNode.parentNode&&h.parentNode.parentNode.className&&h.parentNode.parentNode.className.indexOf&&h.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(h.id);}else if(f===i+"-paneBarOverflowText"){var w=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,w,(this._bRtl?"left":"right")+" bottom","center center",w);}else if(f){if(h&&h.className&&h.className.indexOf&&h.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(f);}}};
u.prototype._handleWorksetBarSelect=function(e){var f=this._handleWorksetItemClick(e.getParameter("item"));if(!f){e.preventDefault();}};
u.prototype._handleFacetBarSelect=function(e){var f=this._handleWorksetItemClick(e.getParameter("item"));if(!f){e.preventDefault();}};
u.prototype._handleWorksetItemClick=function(e){var f=e.getParent(),i=e.getId(),h=i,w=true;if(f instanceof u){if(i!=this._sSelectedWorksetId){var x=e.getSubItems();if(x.length>0){h=x[0].getId();}w=this._fireWorksetItemSelected(h);if(w){this._sSelectedWorksetId=i;if(x.length>0){this._sSelectedFacetId=x[0].getId();i=this._sSelectedFacetId;}else{this._sSelectedFacetId=null;}var x=e.getSubItems();this._oFacetBar.setAssociatedItems(x,true);var $=this.$("facetBar");var y=this._calcFacetBarHeight($);if(x.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(x[0]);this._sSelectedFacetId=x[0].getId();}$.slideDown();this._adaptContentHeight(null,true,y);}else{this._oFacetBar.setSelectedItem(null);$.slideUp();this._adaptContentHeight(null,true,y);}}}}else{if(i!=this._sSelectedFacetId){w=this._fireWorksetItemSelected(h);if(w){this._sSelectedFacetId=i;}}}return w;};
u.prototype._fireWorksetItemSelected=function(i){var e=sap.ui.getCore().byId(i);var f=(e?e.getKey():null);var h=this.fireWorksetItemSelected({id:i,item:e,key:f});if(h){this.setAssociation("selectedWorksetItem",i,true);}return h;};
u.prototype._closeCurrentToolPopup=function(){var O;if(this._oOpenToolPopup){O=this._oOpenToolPopup.getId();q(document.getElementById(this.getId()+u.TOOL_PREFIX+this._oOpenToolPopup.getId())).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(O===this.getId()+"-feederTool"){var f=sap.ui.getCore().byId(this.getId()+"-feeder");f.setText("");f.rerender();}this._oOpenToolPopup.close();this._oOpenToolPopup=null;}return O;};
u.prototype._handleToolItemClick=function(i){var A=this._closeCurrentToolPopup();var e;var f=i.substr(i.indexOf(u.TOOL_PREFIX)+6);if(f==(this.getId()+"-searchTool")){e=this._getSearchTool();}else if(f==(this.getId()+"-feederTool")){e=this._getFeederTool();}else{e=sap.ui.getCore().byId(f);}if(e&&(e.getId()!=A)){this._oOpenToolPopup=e;e.setPosition(r.BeginTop,r.EndTop,document.getElementById(i),"13 -6","fit");e.open();q(document.getElementById(i)).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");u._updateToolIcon(document.getElementById(i));var h=this;var O=function(E){e.detachClosed(O);if(h._oOpenToolPopup&&h._oOpenToolPopup.getId()===E.getParameter("id")){h._closeCurrentToolPopup();}q(document.getElementById(i)).removeClass("sapUiUx3ShellToolSelected");u._updateToolIcon(document.getElementById(i));};e.attachClosed(O);}else if(e.getId()==A){u._updateToolIcon(document.getElementById(i));}};
u.prototype._hasDarkDesign=function(){return(this.getDesignType()!==s.Light&&this.getDesignType()!==s.Crystal);};
u.prototype._getSearchTool=function(){if(!this._oSearchPopup){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new T(this.getId()+"-searchTool",{tooltip:e.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var i=this._hasDarkDesign();this._oSearchPopup.setInverted(i);var f=this;var h=new c(this.getId()+"-searchField",{enableListSuggest:false,search:function(E){f.fireSearch({text:E.getParameter("query")});}});var w=new L({text:e.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(h);this._oSearchPopup.addContent(w).addContent(h);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){h.focus();},100);});this._oSearchField=h;}return this._oSearchPopup;};
u.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool();}return this._oSearchField;};
u.prototype._getFeederTool=function(){if(!this._oFeederPopup){var e=this;var h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new T(this.getId()+"-feederTool",{tooltip:h.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var i=this._hasDarkDesign();this._oFeederPopup.setInverted(i);var f=new F(this.getId()+"-feeder",{type:p.Medium,submit:function(E){e.fireFeedSubmit({text:E.getParameter("text")});f.setText("");f.rerender();e._oFeederPopup.close();}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){f.setText("");});this._oFeederPopup.addContent(f);}return this._oFeederPopup;};
u.prototype.openPane=function(e){var f=this;n(typeof e==="string","sPaneId must be given as string");var i=sap.ui.getCore().byId(e);if(i&&(e!=this._sOpenPaneId)&&this.getShowPane()){var h;if(i){if(i.getKey()==""){h=null;}else{h=i.getKey();}}else{h=null;}this.firePaneBarItemSelected({"id":e,"item":i,"key":h});var w=q(document.getElementById(e));w.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");w.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){f.focusPaneStart();});}else{q(document.getElementById(this.getId()+"-pb_"+this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");}this._sOpenPaneId=e;}return this;};
u.prototype.closePane=function(){this._closePane();return this;};
u.prototype.isPaneOpen=function(){return(this._sOpenPaneId!=null);};
u.prototype._handlePaneBarItemClick=function(e){if(e===this._sOpenPaneId){this.closePane();}else{this.openPane(e);}this._checkPaneBarOverflow();};
u._SHELL_OFFSET_RIGHT=0;
u.prototype._closePane=function(f){if(!this._sOpenPaneId){if(f){f();}return;}var O=this._sOpenPaneId;var e=this;var h=this.getShowPane()?(this.$("paneBarRight").outerWidth()+u._SHELL_OFFSET_RIGHT):u._SHELL_OFFSET_RIGHT;var i={};i[this._bRtl?"left":"right"]=h+"px";var w={};w[this._bRtl?"marginLeft":"marginRight"]=(h-u._SHELL_OFFSET_RIGHT)+"px";this.$("content").css("overflow-x","hidden");this.$("canvas").stop().animate(i);this.$("notify").stop().animate(i);this._getSyncRefs().stop(false,true).animate(i);this.$("wBar").stop().animate(w);this.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");this.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(i,function(){e.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpen");e.$("content").css("overflow-x","");if(f){f();}e.firePaneClosed({"id":O});});q(document.getElementById(this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null;};
u.prototype._openPane=function(O){var e=this;var f=this.getPaneWidth();var i=this.$("paneBarRight").outerWidth();this.$("content").css("overflow-x","hidden");if(this._bRtl){this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginLeft:(f+i)+"px"});this.$("canvas").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("notify").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("canvasBackground").stop().animate({left:(f+i+u._SHELL_OFFSET_RIGHT)+"px"},function(){e.$("content").css("overflow-x","");e.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");e.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(O){O();}});}else{this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginRight:(f+i)+"px"});this.$("canvas").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("notify").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"});this.$("canvasBackground").stop().animate({right:(f+i+u._SHELL_OFFSET_RIGHT)+"px"},function(){e.$("content").css("overflow-x","");e.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");e.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(O){O();}});}};
u.prototype.setPaneWidth=function(w){if(typeof w=="number"&&(w>0)){w=Math.max(w,50);if(this.getDomRef()){this.$("paneContent").css("width",w+"px");this.$("paneBar").css("width",(w+u.SIDE_BAR_BASE_WIDTH)+"px");if(!!this._sOpenPaneId){if(this._bRtl){this.$("wBar").css("marginLeft",(w+u.SIDE_BAR_BASE_WIDTH)+"px");this.$("canvas").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("notify").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("canvasBackground").css("left",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");}else{this.$("wBar").css("marginRight",(w+u.SIDE_BAR_BASE_WIDTH)+"px");this.$("canvas").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("notify").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");this.$("canvasBackground").css("right",(w+u.SIDE_BAR_BASE_WIDTH+u._SHELL_OFFSET_RIGHT)+"px");}}}this.setProperty("paneWidth",w,true);}return this;};
u.prototype.setOffsetRight=function(e,f,h){if(e<0){e=0;}if(e>600){e=600;}u._SHELL_OFFSET_RIGHT=e;var i=e+"px";var w=this._bRtl?{"left":i}:{"right":i};this.$("hdr").stop().animate(w);this.$("hdrImg").stop().animate(w);this.$("bg").stop().animate(w,function(){if(f){f();}});this.$("bgImg").stop().animate(w);this.$("wBar").stop().animate(w);this.$("paneBar").stop().animate(w);q(document.getElementById(h)).stop().animate({"width":i});if(!this.$().hasClass("sapUiUx3ShellNoPane")){i=(e+(this._sOpenPaneId?this.getPaneWidth():0)+u.SIDE_BAR_BASE_WIDTH)+"px";}w=this._bRtl?{"left":i}:{"right":i};this.$("notify").stop().animate(w);this._getSyncRefs().stop(false,true).animate(w);this.$("canvas").stop().animate(w);this.$("canvasBackground").stop().animate(w);};
u.prototype._refreshCanvasOffsetRight=function(e){var f=this._bRtl?"left":"right";var h=u._SHELL_OFFSET_RIGHT;if(e){var i=this.$("paneBarRight").outerWidth();h=h+(this._sOpenPaneId?this.getPaneWidth():0)+i;}h=h+"px";this.$("notify").css(f,h);this.$("canvas").css(f,h);this.$("canvasBackground").css(f,h);this._getSyncRefs().css(f,h);};
u.prototype._setNotifyVisibility=function(V){var e=this.getNotificationBar();if(!e){return;}if(!V){V=e.getVisibleStatus();}var $=this.$("notify");var f=this._topSyncRefId?q(document.getElementById(this._topSyncRefId)):q(null);var i=f.hasClass("sapUiUx3TI");var h=0;var w=0;if(V===o.Min){h=10;}else if(V===o.Max||V===o.Default){if(this.getHeaderType()===t.BrandOnly&&i){h=parseInt(e.getHeightOfStatus(o.Default));}else{h=10;}w=h;}$.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({"bottom":w+"px"},"fast");if(w>0){$.addClass(i?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay");}}if(V===o.Min){$.css("height",h+"px").css("z-index",1);}else{$.css("height",h+"px").css("z-index",100000);}if(h>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible");}else if(h==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible");}this._adaptContentHeight(V);};
u.prototype.syncWithCanvasSize=function(i,e,f,h,A){var w=this._aSyncRefStack.indexOf(i);if(e){var x={id:i,focusFirst:f,focusLast:h,applyChanges:A};if(w<0){this._aSyncRefStack.push(i);}this._mSyncRefs[i]=x;x.applyChanges({showOverlay:this.getHeaderType()!==t.BrandOnly});}else{if(w>=0){delete this._mSyncRefs[i];this._aSyncRefStack.splice(w,1);}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyPane").removeAttr("tabindex").unbind("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var x=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var $=this._getSyncRefs();var y=this.getDomRef("canvas");$.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var z=u._SHELL_OFFSET_RIGHT;if(this.getShowPane()){z+=u.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){z+=this.getPaneWidth();}}$.css(this._bRtl?"left":"right",z+"px");$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");$.css("bottom","0");q(y).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").focusin(x.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").focusin(q.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").focusin(q.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").focusin(x.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=x.id;}if(this._sUpdateNotificationZIndex){clearTimeout(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex;}this._sUpdateNotificationZIndex=setTimeout(function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var E=q(document.getElementById(this._topSyncRefId));this._oOpenToolPopup.$().css("z-index",parseInt(E.css("z-index"))+1);}}.bind(this),0);};
u.prototype._getSyncRefs=function(){var e=[];var f;for(var i=0;i<this._aSyncRefStack.length;i++){f=this._aSyncRefStack[i]?window.document.getElementById(this._aSyncRefStack[i]):null;if(f){e.push(f);}}return q(e);};
u.prototype.focusFirstHdr=function(){var e=this.$("hdr-items").firstFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=t.BrandOnly){if(e){e.focus();}}else{this.focusFirstTool();}};
u.prototype.focusLastHdr=function(){var e=this.$("hdr-items").lastFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=t.BrandOnly){if(e){e.focus();}}else{this.focusPaneEnd();}};
u.prototype.focusFirstTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").first();if($.length&&this.getShowTools()){$[0].focus();}else{this._mSyncRefs[this._topSyncRefId].focusFirst();}};
u.prototype.focusLastTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").last();if($.length&&this.getShowTools()){$[0].focus();}else{this.focusPaneEnd();}};
u.prototype.focusPaneStart=function(){var e=this.$("paneBar").firstFocusableDomRef();if(e){e.focus();}else{this.focusFirstTool();}};
u.prototype.focusPaneEnd=function(){var e=this.$("paneBar").lastFocusableDomRef();if(e){e.focus();}else{this._mSyncRefs[this._topSyncRefId].focusLast();}};
u.prototype.setAppTitle=function(A){this.setProperty("appTitle",A,true);this._rerenderHeader();return this;};
u.prototype.setAppIcon=function(A){this.setProperty("appIcon",A,true);this._rerenderHeader();return this;};
u.prototype.setShowLogoutButton=function(e){this.setProperty("showLogoutButton",e,true);this._rerenderHeader();return this;};
u.prototype.setLogoutButtonTooltip=function(e){this.setProperty("logoutButtonTooltip",e,true);this._rerenderHeader();return this;};
u.prototype.insertHeaderItem=function(h,i){if(k.isA(h,"sap.ui.commons.Button")){h.setStyled(false);}this.insertAggregation("headerItems",h,i,true);this._rerenderHeader();return this;};
u.prototype.addHeaderItem=function(h){if(k.isA(h,"sap.ui.commons.Button")){h.setStyled(false);}this.addAggregation("headerItems",h,true);this._rerenderHeader();return this;};
u.prototype.removeHeaderItem=function(i){var e=this.removeAggregation("headerItems",i,true);this._rerenderHeader();return e;};
u.prototype.removeAllHeaderItems=function(){var e=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return e;};
u.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this;};
u.prototype.setShowSearchTool=function(e){this.setProperty("showSearchTool",e,true);this._rerenderToolPalette();return this;};
u.prototype.setShowFeederTool=function(e){this.setProperty("showFeederTool",e,true);this._rerenderToolPalette();return this;};
u.prototype.setHeaderType=function(h){var e=this.getHeaderType();this.setProperty("headerType",h,true);this.$().removeClass("sapUiUx3ShellHead"+e).addClass("sapUiUx3ShellHead"+this.getHeaderType());var $=this._getSyncRefs();if($.length){$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");}var f={showOverlay:h!==t.BrandOnly};q.each(this._mSyncRefs,function(i,w){w.applyChanges(f);});return this;};
u.prototype.setAllowOverlayHeaderAccess=function(A){this.setProperty("allowOverlayHeaderAccess",A,true);var $=this._getSyncRefs();if($.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());$.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");}return this;};
u.prototype.setDesignType=function(e){var f=this.getDesignType();this.setProperty("designType",e,true);var h=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(h);}if(this._oFeederPopup){this._oFeederPopup.setInverted(h);}var w=this.getToolPopups();for(var i=0;i<w.length;++i){w[i].setInverted(h);}this.$().removeClass("sapUiUx3ShellDesign"+f).addClass("sapUiUx3ShellDesign"+e).toggleClass("sapUiUx3ShellDesignLight",!h);return this;};
u.prototype.setShowTools=function(e){this.setProperty("showTools",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize();}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","");}this._checkToolPaletteSize(true);return this;};
u.prototype.setShowPane=function(e){this.setProperty("showPane",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow();}else{var f=this;this._closePane(function(){f._refreshCanvasOffsetRight(false);f.$().addClass("sapUiUx3ShellNoPane");});}return this;};
u.prototype.insertToolPopup=function(e,i){this.insertAggregation("toolPopups",e,i,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};
u.prototype.addToolPopup=function(e){var i=this._hasDarkDesign();e.setInverted(i);this.addAggregation("toolPopups",e,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};
u.prototype.removeToolPopup=function(i){var e=this.removeAggregation("toolPopups",i,true);if(e===this._oOpenToolPopup){this._closeCurrentToolPopup();}this._rerenderToolPalette();return e;};
u.prototype.removeAllToolPopups=function(){var e=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return e;};
u.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this;};
u.prototype.insertContent=function(e,i){this.insertAggregation("content",e,i,true);this._rerenderContent();return this;};
u.prototype.addContent=function(e){this.addAggregation("content",e,true);this._rerenderContent();return this;};
u.prototype.removeContent=function(i){var e=this.removeAggregation("content",i,true);this._rerenderContent();return e;};
u.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content",true);this._rerenderContent();return e;};
u.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this;};
u.prototype.addPaneBarItem=function(e){this.addAggregation("paneBarItems",e,true);this._rerenderPaneBarItems();return this;};
u.prototype.insertPaneBarItem=function(e,i){this.insertAggregation("paneBarItems",e,i,true);this._rerenderPaneBarItems();return this;};
u.prototype.removePaneBarItem=function(e){var f=this.removeAggregation("paneBarItems",e,true);if(f){var i=sap.ui.getCore().byId(f.getId()+"-overflow");if(i){i.destroy();}}this._rerenderPaneBarItems();return f;};
u.prototype.removeAllPaneBarItems=function(){var e=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return e;};
u.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this;};
u.prototype.addWorksetItem=function(w){this.addAggregation("worksetItems",w,true);this._rerenderWorksetItems();return this;};
u.prototype.insertWorksetItem=function(w,i){this.insertAggregation("worksetItems",w,i,true);this._rerenderWorksetItems();return this;};
u.prototype.removeWorksetItem=function(w){var e=this.removeAggregation("worksetItems",w,true);this._rerenderWorksetItems();return e;};
u.prototype.removeAllWorksetItems=function(){var e=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return e;};
u.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this;};
function v(e){var O=e.getNotificationBar();if(O){e._setNotifyVisibility(o.None);O.setVisibleStatus=O.__orig_setVisibleStatus;O.detachDisplay(O.__fHandleNotifyDisplay);delete O.__orig_setVisibleStatus;delete O.__fHandleNotifyDisplay;}}
u.prototype.setNotificationBar=function(e){v(this);if(e){var f=this;e.__orig_setVisibleStatus=e.setVisibleStatus;e.setVisibleStatus=function(V){this.__orig_setVisibleStatus.apply(this,arguments);f._setNotifyVisibility();};}this.setAggregation("notificationBar",e,true);this._rerenderNotificationArea();if(e){e.__fHandleNotifyDisplay=function(E){var h=E?E.getParameter("show"):e.hasItems();e.setVisibleStatus(h?o.Default:o.None);};e.attachDisplay(e.__fHandleNotifyDisplay);e.__fHandleNotifyDisplay();}return this;};
u.prototype.destroyNotificationBar=function(){v(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this;};
u.prototype._rerenderNotificationArea=function(){var $=this.$("notify");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderNotificationArea(e,this);e.flush($[0],true);e.destroy();}};
u.prototype._rerenderHeader=function(){var $=this.$("hdr");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderHeader(e,this);e.flush($[0],true);e.destroy();}};
u.prototype._rerenderToolPalette=function(){var $=this.$("tp");if($.length>0){var e=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();S.renderToolPalette(e,this);e.flush($[0],true);this._afterRenderingToolPalette();e.destroy();this._checkResize();}};
u.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").unbind("mouseenter mouseleave");this.$("focusDummyTPEnd").unbind("focusin");this.$("focusDummyTPStart").unbind("focusin");};
u.prototype._afterRenderingToolPalette=function(){var e=this.getId()+u.TOOL_PREFIX;var f=this.getToolPopups();var V=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(r.BeginTop,r.EndTop,e+this._oOpenToolPopup.getId()?window.document.getElementById(e+this._oOpenToolPopup.getId()):null,"13 -6","fit");var h=document.getElementById(e+this._oOpenToolPopup.getId());q(h).toggleClass("sapUiUx3ShellToolSelected",true);u._updateToolIcon(h);V=true;}if(!V&&this._oOpenToolPopup){this._closeCurrentToolPopup();}for(var i=0;i<f.length;i++){var w=f[i];if(w instanceof T){q(document.getElementById(e+w.getId())).hover(function(x){q(this).toggleClass("sapUiUx3ShellToolHover",(x.type==="mouseenter"));u._updateToolIcon(this);});}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").focusin(this._mSyncRefs[this._topSyncRefId].focusFirst);}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));}};
u.prototype._rerenderContent=function(e){var $=this.$("content");if($.length>0){var f=this.getContent(),h=sap.ui.getCore().createRenderManager();for(var i=0;i<f.length;i++){h.renderControl(f[i]);}h.flush($[0],e);h.destroy();}};
u.prototype._rerenderPane=function(e){var $=this.$("paneContent");if($.length>0){var f=this.getPaneContent(),h=sap.ui.getCore().createRenderManager();for(var i=0;i<f.length;i++){h.renderControl(f[i]);}h.flush($[0],e);h.destroy();}};
u.prototype._rerenderPaneBarItems=function(){var $=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if($.length>0){var e=sap.ui.getCore().createRenderManager();S.renderPaneBarItems(e,this);e.flush($[0]);e.destroy();this._updatePaneBarItemNavigation($);}var f=this;var h=this._getPaneOverflowMenu();var w=this.getPaneBarItems();var O=function(E){var A={overflowItem:E.getParameter("item"),target:{id:E.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};f.onUserActivation(A);};for(var i=0;i<w.length;++i){var x=w[i].getId()+"-overflow";var y=sap.ui.getCore().byId(x);if(!y){var z=new g(x,{text:w[i].getText(),visible:false,select:O});h.addItem(z);}}this._checkPaneBarOverflow($);};
u.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){S.renderWorksetItems(null,this);S.renderFacetBar(null,this);var i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}};
u.prototype.forceInvalidation=C.prototype.invalidate;
u.prototype.invalidate=function(e){if(!e){this.forceInvalidation();}else if(e instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var w=this.getSelectedWorksetItem();if(w){var i;var f=sap.ui.getCore().byId(w);if(f&&f.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(f.getParent().getSubItems());}else if(f&&(i=f.getSubItems())){if(i&&(i.length>0)){this._oFacetBar.setAssociatedItems(i);}}i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}}}else if((e instanceof sap.ui.core.Item)&&(e.getParent()==this)){this.forceInvalidation();}else if(e instanceof T){this._rerenderToolPalette();}else if(this.indexOfHeaderItem(e)>=0){this._rerenderHeader();}};
u.prototype._setParent=C.prototype.setParent;
u.prototype.setParent=function(e,A,f){this._setParent(e,A,f);this.forceInvalidation();};
u.prototype.setContent=function(e,f){n(e===null||(e instanceof C)||((Array.isArray(e)&&((e.length>0)?(e[0]instanceof C):true))),"vContent must be a control or array of controls or null");n((f===undefined||f===true||f===false),"bDestruct must be true, false, or undefined");var h=[];var $=this.$("content");var w=false;if(!f){h=this.removeAllAggregation("content",true);if($.length>0){R.preserveContent($[0]);w=true;$.empty();}}else{this.destroyAggregation("content",true);}if(e instanceof C){this.addAggregation("content",e,true);}else if(e&&typeof(e)=="object"&&e.length){for(var i=0;i<e.length;i++){this.addAggregation("content",e[i],true);}}this._rerenderContent(w);return h;};
u.prototype.setPaneContent=function(e,f){n((e instanceof C)||((Array.isArray(e)&&((e.length>0)?(e[0]instanceof C):true))),"vContent must be a control or array of controls");n((f===undefined||f===true||f===false),"bDestruct must be true, false, or undefined");var h=[];var $=this.$("paneContent");var w=false;if(!f){h=this.removeAllAggregation("paneContent",true);if($.length>0){R.preserveContent($[0]);w=true;$.empty();}}else{this.destroyAggregation("paneContent",true);}if(e instanceof C){this.addAggregation("paneContent",e,true);}else if(e&&typeof(e)=="object"&&e.length){for(var i=0;i<e.length;i++){this.addAggregation("paneContent",e[i],true);}}this._rerenderPane(w);return h;};
u.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem");};
u.prototype.setSelectedWorksetItem=function(e){var f=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",e,true);var h=this.getSelectedWorksetItem();if(f!=h){var i=sap.ui.getCore().byId(h);if(i){this._sSelectedWorksetId=h;this._sSelectedFacetId=null;var w=i.getSubItems();if(w.length>0){i=w[0];}if(i&&(i.getParent()instanceof sap.ui.ux3.NavigationItem)){var x=i.getParent();this._sSelectedWorksetId=x.getId();this._sSelectedFacetId=i.getId();this._oWorksetBar.setSelectedItem(x);this._oFacetBar.setAssociatedItems(x.getSubItems());this._oFacetBar.setSelectedItem(i);if(this.getDomRef()){var $=this.$("facetBar");var y=this._calcFacetBarHeight($);$.slideDown();this._adaptContentHeight(null,true,y);}}else if(i){this._oWorksetBar.setSelectedItem(i);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var $=this.$("facetBar");var y=this._calcFacetBarHeight($);$.slideUp();this._adaptContentHeight(null,true,y);}}}else{throw new Error("WorksetItem with ID "+h+" cannot be found.");}}return this;};
u.prototype.setApplyContentPadding=function(A){this.setProperty("applyContentPadding",A,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!A);this._adaptContentHeight();return this;};
u.prototype.setFullHeightContent=function(f){this.setProperty("fullHeightContent",f,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",f);this._adaptContentHeight();return this;};
u.prototype._calcFacetBarHeight=function(f){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0;}if(!f){f=this.$("facetBar");}if(f.length>0){var h=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,h);}return this._iFacetBarHeight;};
u.prototype._adaptContentHeight=function(e,A,f){if(!this.getDomRef()){return;}var $=this.$("content");var h=this.$("canvas");if(this.getFullHeightContent()){var i=this.getApplyContentPadding();var w=!i?0:parseInt(h.css("paddingTop"));var x=!i?0:parseInt(h.css("paddingLeft"));var y=!i?0:parseInt(h.css("paddingRight"));var _=f?f:this._calcFacetBarHeight();var z=(w+(this._oFacetBar.getAssociatedItems().length>0?_:0))+"px";if(A){$.stop().animate({top:z});}else{$.stop().css("top",z);}var E=this.getNotificationBar();if(E&&!e){e=E.getVisibleStatus();}if(e===o.Default||e===o.Max){$.css("bottom",E.getHeightOfStatus(o.Default));}else{var G=!i?0:parseInt(h.css("paddingBottom"));if(E&&e===o.Min){G+=j.HOVER_ITEM_HEIGHT;}$.css("bottom",G+"px");}$.css(this._bRtl?"right":"left",x+"px");$.css(this._bRtl?"left":"right",y+"px");}else{$.removeAttr("style");}if(D.browser.webkit){R.forceRepaint(this.getId()+"-canvas");}};
u.prototype._handleDragover=function(e){var i=e.target.id;if(!this._dragOverBlinking){var $=q(document.getElementById(i));$.css("opacity","0.5");this._dragOverBlinking=true;var f=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){f._dragOverBlinking=null;},300);},300);}return false;};
u.prototype._handleDragend=function(e){return false;};
u.prototype._handleDrop=function(f){var i=f.target.id;f.preventDefault();var e=f.originalEvent;var h=e.dataTransfer.files[0];if(h){var w=new window.FileReader();w.onload=q.proxy(function(x){var y=x.target.result;if(i==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(y,true);}else if(i==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(y,true);}else if(i==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(y,true);}w=null;},this);w.readAsDataURL(h);}};
u.prototype._getPersonalization=function(){if(!this.oPersonalization){this.oPersonalization=new a(this);}return this.oPersonalization;};
u.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog();};
u.prototype.initializePersonalization=function(e){this._getPersonalization().initializeSettings(e);};
u.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return;}var i="";if(!this.getAppIcon()){i=P._getThemeImage('sapUiUx3ShellApplicationImageURL',true);this.$("logoImg").attr('src',i);}i=P._getThemeImage('sapUiUx3ShellHeaderImageURL',true);this.$("hdrImg").attr('src',i);i=P._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);this.$("bgImg").attr('src',i);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize();};
return u;});
sap.ui.predefine('sap/ui/ux3/ShellColorPicker',['sap/ui/thirdparty/jquery','sap/ui/base/EventProvider','sap/ui/commons/Button','sap/ui/core/Popup','sap/ui/commons/Slider','sap/ui/Device'],function(Q,E,B,P,S,D){"use strict";
var a=E.extend("sap.ui.ux3.ShellColorPicker",{constructor:function(i){E.apply(this);this.id=i;}});
a.M_EVENTS={liveChange:"liveChange"};
a.prototype.attachLiveChange=function(f,l){this.attachEvent(a.M_EVENTS.liveChange,f,l);};
a.prototype.detachLiveChange=function(f,l){this.detachEvent(a.M_EVENTS.liveChange,f,l);};
a.prototype.fireLiveChange=function(c){var p={cssColor:a.hslToCss(c)};this.fireEvent(a.M_EVENTS.liveChange,p);};
a.prototype.isOpen=function(){return(this.oPopup&&this.oPopup.isOpen());};
a.prototype.open=function(c,d,m,b,o,e,f){if(this.oPopup&&this.oPopup.isOpen()){return;}this.oSlider=new S({width:"225px",liveChange:[this.handleSlider,this]});this.oOkBtn=new B({text:"OK",press:[this.handleOk,this]});this.oCancelBtn=new B({text:"Cancel",press:[this.handleCancel,this]});this.oInitialColor=c;this.oCurrentColor=Object.assign({},this.oInitialColor);this.oSlider.setValue(this.oCurrentColor.l);var r=sap.ui.getCore().createRenderManager();var g=document.createElement("div");var s=sap.ui.getCore().getStaticAreaRef();s.appendChild(g);this.renderHtml(r);r.flush(g);r.destroy;this.oPopup=new P(g.firstChild,false,true,true).attachClosed(this.handleClose,this);this.oPopup.setAutoCloseAreas([g.firstChild]);this.oPopup.open(d,m,b,o,e,f);s.removeChild(g);g=null;Q(document.getElementById(this.id)).bind("mousedown",Q.proxy(this.handleGeneralMouseDown,this));Q(document.getElementById(this.id+"-img")).bind("mousedown",Q.proxy(this.handleMouseDown,this));Q(document.getElementById(this.id+"-marker")).bind("mousedown",Q.proxy(this.handleMouseDown,this));this._imgOffset=Q(document.getElementById(this.id+"-img")).offset();this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor);};
a.parseCssRgbString=function(r){r=r.replace(/rgb\(/,"").replace(/\)/,"").trim();var R=r.split(",");var o={r:parseInt(R[0]),g:parseInt(R[1]),b:parseInt(R[2])};return a.rgbToHsl(o);};
a.prototype.renderHtml=function(r){r.write("<div id='"+this.id+"' class='sapUiUx3ShellColorPicker'>");r.write("<img id='"+this.id+"-img' src='"+sap.ui.resource('sap.ui.ux3','img/colors-h.png')+"'>");r.renderControl(this.oSlider);r.write("<div id='"+this.id+"-grad' class='sapUiUx3ShellColorPickerGradient'></div>");r.write("<div id='"+this.id+"-marker' class='sapUiUx3ShellColorPickerMarker'></div>");r.write("<div id='"+this.id+"-preview' class='sapUiUx3ShellColorPickerPreview'></div>");r.renderControl(this.oOkBtn);r.renderControl(this.oCancelBtn);r.write("</div>");};
a.prototype.markColorOnImage=function(c){var x=c.h*225;var y=(1-c.s)*75;Q(document.getElementById(this.id+"-marker")).css("left",x+10).css("top",y+10);};
a.prototype.markColorOnSlider=function(c){this.oSlider.setValue(c.l);};
a.prototype.adaptSliderBar=function(c){var g="";var m=Object.assign({},c);m.l=50;var b=a.hslToCss(m);if(D.browser.firefox){g="-moz-linear-gradient(left, black, "+b+", white)";}else if(D.browser.webkit){g="-webkit-gradient(linear, left center, right center, from(#000), color-stop(0.5, "+b+"), to(#FFF))";}Q(document.getElementById(this.id+"-grad")).css("background-image",g);};
a.prototype.adaptPreview=function(c){Q(document.getElementById(this.id+"-preview")).css("background-color",a.hslToCss(c));};
a.prototype.handleSlider=function(e){var l=e.getParameter("value");this.oCurrentColor.l=l;this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor);};
a.prototype.handleGeneralMouseDown=function(e){e.preventDefault();};
a.prototype.handleMouseDown=function(e){this.handleMousePos(e);e.preventDefault();Q(document).bind("mousemove",Q.proxy(this.handleMousePos,this)).bind("mouseup",Q.proxy(this.handleMouseUp,this));};
a.prototype.handleMouseUp=function(e){this.handleMousePos(e);Q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);};
a.prototype.handleMousePos=function(e){var x=e.pageX-this._imgOffset.left;var y=e.pageY-this._imgOffset.top;x=Math.min(Math.max(x,0),225);y=Math.min(Math.max(y,0),75);var h=x/225;var s=1-y/75;this.oCurrentColor.h=h;this.oCurrentColor.s=s;this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor);};
a.prototype.handleOk=function(){this.fireLiveChange(this.oCurrentColor);this.oPopup.close();};
a.prototype.handleCancel=function(){this.fireLiveChange(this.oInitialColor);this.oPopup.close();};
a.prototype.handleClose=function(){Q(document.getElementById(this.id+"-img")).unbind("mousedown",this.handleMouseDown);Q(document.getElementById(this.id+"-marker")).unbind("mousedown",this.handleMouseDown);Q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);Q(document.getElementById(this.id)).unbind("mousedown",this.handleGeneralMouseDown);this.oSlider.destroy();this.oSlider=null;this.oOkBtn.destroy();this.oOkBtn=null;this.oCancelBtn.destroy();this.oCancelBtn=null;var d=document.getElementById(this.id);d.parentNode.removeChild(d);this.oPopup.destroy();this.oPopup=null;};
a.rgbToHsl=function(c){var r=c.r/255,g=c.g/255,b=c.b/255;var m=Math.max(r,g,b);var e=Math.min(r,g,b);var h,s,l=(m+e)/2;if(m==e){h=s=0;}else{var d=m-e;s=l>0.5?d/(2-m-e):d/(m+e);switch(m){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break;}h/=6;}return{h:h,s:s,l:l*100};};
a.hslToRgb=function(c){var r,g,b;var l=c.l/100;if(c.s==0){r=g=b=l;}else{var q=l<0.5?l*(1+c.s):l+c.s-l*c.s;var p=2*l-q;r=a.hueToRgb(p,q,c.h+1/3);g=a.hueToRgb(p,q,c.h);b=a.hueToRgb(p,q,c.h-1/3);}return[r*255,g*255,b*255];};
a.hueToRgb=function(p,q,t){if(t<0){t+=1;}if(t>1){t-=1;}if(t<1/6){return p+(q-p)*6*t;}if(t<1/2){return q;}if(t<2/3){return p+(q-p)*(2/3-t)*6;}return p;};
a.hslToCss=function(c){var r=a.hslToRgb(c);return"rgb("+Math.round(r[0])+","+Math.round(r[1])+","+Math.round(r[2])+")";};
return a;});
sap.ui.predefine('sap/ui/ux3/ShellPersonalization',['sap/ui/thirdparty/jquery','sap/ui/base/EventProvider','sap/ui/commons/Button','sap/ui/commons/Dialog','sap/ui/core/theming/Parameters','./ShellColorPicker','sap/ui/commons/library','sap/ui/core/HTML','sap/ui/core/Popup','sap/ui/commons/Tab','sap/ui/core/Item','sap/ui/Device','sap/base/security/encodeXML'],function(q,E,B,D,P,S,a,H,b,T,I,f,g){"use strict";var h=b.Dock;
var i=E.extend("sap.ui.ux3.ShellPersonalization",{constructor:function(s){E.apply(this);this.shell=s;this.oSettings={};}});
i.prototype.initializeSettings=function(s){this.oSettings=Object.assign({},s);if(this.shell.getDomRef()){this.applySettings(s);}};
i.M_EVENTS={personalizationChange:"personalizationChange"};
i.prototype.attachPersonalizationChange=function(F,l){this.attachEvent(i.M_EVENTS.personalizationChange,F,l);};
i.prototype.detachPersonalizationChange=function(F,l){this.detachEvent(i.M_EVENTS.personalizationChange,F,l);};
i.prototype.firePersonalizationChange=function(p){this.fireEvent(i.M_EVENTS.personalizationChange,p);};
i.ORIGINAL_SETTINGS={bByDStyle:false,sBgColor:"rgb(17,17,17)",sBgCssImg:null,sBgImgSrc:null,sBgImgPos:"tile",fBgImgOpacity:1,fSidebarOpacity:1,sLineColor:"rgb(239,170,0)",sLogoImageSrc:null,sLogoAlign:"left",bUseLogoSize:false};i.TRANSPARENT_1x1=sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');i.IMAGE_FOLDER_PATH=sap.ui.require.toUrl("sap/ui/ux3/themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/img/shell/");
i.getOriginalSettings=function(){if(!i._bOriginalSettingsInitialized){i._bOriginalSettingsInitialized=true;var A=P.get();var c=A["sap.ui.ux3.Shell:sapUiUx3ShellGradientTop"];var d=A["sap.ui.ux3.Shell:sapUiUx3ShellGradientBottom"];if(f.browser.firefox){i.ORIGINAL_SETTINGS.sBgCssImg="-moz-linear-gradient(top, "+c+" 0, "+d+" 108px, "+d+")";}else if(f.browser.msie){if(f.browser.version==9){i.ORIGINAL_SETTINGS.sBgCssImg="url("+i.IMAGE_FOLDER_PATH+"Workset_bg.png)";}else{i.ORIGINAL_SETTINGS.sBgCssImg="-ms-linear-gradient(top, "+c+" 0, "+d+" 108px, "+d+")";}}else if(f.browser.webkit){i.ORIGINAL_SETTINGS.sBgCssImg="-webkit-linear-gradient(top, "+c+" 0, "+d+" 108px, "+d+")";}}return i.ORIGINAL_SETTINGS;};
i.prototype.hasChanges=function(){var s=0;for(var k in this.oSettings){s++;}return(s>0);};
i.prototype.applySettings=function(s){var A=Object.assign({},i.getOriginalSettings(),s);this.applyByDStyle(A.bByDStyle);this.applyBgColor(A.sBgColor);this.applyBgImage(A.sBgCssImg,A.sBgImgSrc);this.applyBgImageOpacity(A.fBgImgOpacity);if(A.sHeaderImageSrc){this.applyHeaderImage(A.sHeaderImageSrc);}else{this.shell.getDomRef("hdr").style.backgroundImage="";}this.applySidebarOpacity(A.fSidebarOpacity);this.applyBgColor(A.sBgColor);this.applyLineColor(A.sLineColor);this.applyLogoImage(A.sLogoImageSrc);this.applyLogoAlign(A.sLogoAlign);this.applyUseLogoSize(A.bUseLogoSize);};
i.prototype.openDialog=function(){if(this.oDialog&&this._getDialog().isOpen()){return;}this.oTransientSettings=Object.assign({},this.oSettings);this._getDialog().open();this._bindDragAndDrop("bg");this._bindDragAndDrop("hdr");this._bindDragAndDrop("logo");};
i.prototype.getTransientSettingsWithDefaults=function(){return Object.assign({},i.getOriginalSettings(),this.oTransientSettings);};
i.prototype._bindDragAndDrop=function(p){if(window.FileReader){var s=this.shell.getId()+"-p13n_";q(document.getElementById(s+p+"ImageImg")).bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));q(document.getElementById(s+p+"ImageHolder")).bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}};
i.prototype._unbindDragAndDrop=function(p){if(window.FileReader){var s=this.shell.getId()+"-p13n_";q(document.getElementById(s+"hdrImageImg")).unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);q(document.getElementById(s+"hdrImageHolder")).unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};
i.prototype._getDialog=function(){if(!this.oDialog){var s=this.shell.getId()+"-p13n_";var o=Object.assign({},i.getOriginalSettings(),this.oSettings);var c=sap.ui.commons;var t=this;var d=new c.Dialog({title:"Shell Personalization",width:"544px",height:"560px",showCloseButton:false,resizable:false,closed:[function(){this._unbindDragAndDrop("bg");this._unbindDragAndDrop("hdr");this._unbindDragAndDrop("logo");this.oTransientSettings=null;},this]}).addStyleClass("sapUiUx3ShellP13n");var e=new c.TabStrip({width:"100%",height:"100%",select:q.proxy(function(p){var C=sap.ui.getCore().byId(p.getParameter("id"));if(C){var n=p.getParameter("index");C.setSelectedIndex(n);var t=this;if(n==0){window.setTimeout(function(){t.shell.$("bgColor").css("background-color",t.getTransientSettingsWithDefaults().sBgColor);},1);window.setTimeout(q.proxy(function(){this._bindDragAndDrop("bg");},this),0);}else if(n==1){window.setTimeout(function(){t.shell.$("lineColor").css("background-color",t.getTransientSettingsWithDefaults().sLineColor);},1);window.setTimeout(q.proxy(function(){this._bindDragAndDrop("hdr");},this),0);}else if(n==2){window.setTimeout(q.proxy(function(){this._bindDragAndDrop("logo");},this),0);}}},this)});this.oBgImgHtml=new H(s+"bgImageHolder",{preferDOM:true,content:"<div id='"+s+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"bgImageImg' src='"+(this.oTransientSettings.sBackgroundImageSrc?g(this.oTransientSettings.sBackgroundImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>"});this.oBgImgOpacitySlider=new c.Slider({value:(this.oTransientSettings.fBgImgOpacity!==undefined?100-this.oTransientSettings.fBgImgOpacity*100:100-i.getOriginalSettings().fBgImgOpacity*100),liveChange:q.proxy(this._handleBgImageOpacitySliderChange,this)});this.oSidebarOpacitySlider=new c.Slider({value:(this.oTransientSettings.fSidebarOpacity!==undefined?100-this.oTransientSettings.fSidebarOpacity*100:100-i.getOriginalSettings().fSidebarOpacity*100),liveChange:q.proxy(this._handleSidebarOpacitySliderChange,this)});this.oBgColorPicker=new S(s+"bgColorPicker");this.oBgColorPicker.attachLiveChange(function(n){t._handleBgColorChange(n);});var j=new c.Button({text:"Change..."});var t=this;j.attachPress(function(){if(!t.oBgColorPicker.isOpen()){t.oBgColorPicker.open(S.parseCssRgbString(t.getTransientSettingsWithDefaults().sBgColor),h.BeginTop,h.BeginBottom,t.shell.getDomRef("bgColor"));}});this.oBgPreviewHtml=new H({preferDom:true,content:"<div id='"+this.shell.getId()+"-bgColor' style='background-color:"+g(o.sBgColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var k=new T().setText("Background").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Background Image:"}),this.oBgImgHtml).createRow(new c.Label({text:"Image Transparency:"}),this.oBgImgOpacitySlider).createRow(new c.Label({text:"Background Color:"}),new c.layout.MatrixLayoutCell().addContent(this.oBgPreviewHtml).addContent(j)).createRow(null).createRow(new c.Label({text:"Sidebar Transparency:"}),this.oSidebarOpacitySlider));e.addTab(k);this.oByDStyleCb=new c.CheckBox({text:"ByDesign-style Header Bar",checked:this.oTransientSettings.bByDStyle,change:q.proxy(this._handleByDStyleChange,this)});this.oHdrImgHtml=new H(s+"hdrImageHolder",{preferDOM:true,content:"<div id='"+s+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"hdrImageImg' src='"+(this.oTransientSettings.sHeaderImageSrc?g(this.oTransientSettings.sHeaderImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>"});this.oLineColorPicker=new S(s+"lineColorPicker");this.oLineColorPicker.attachLiveChange(function(n){t._handleLineColorChange(n);});var l=new c.Button({text:"Change..."});var t=this;l.attachPress(function(){if(!t.oLineColorPicker.isOpen()){t.oLineColorPicker.open(S.parseCssRgbString(t.getTransientSettingsWithDefaults().sLineColor),h.BeginTop,h.BeginBottom,t.shell.getDomRef("lineColor"));}});this.oLinePreviewHtml=new H({preferDom:true,content:"<div id='"+this.shell.getId()+"-lineColor' style='background-color:"+g(o.sLineColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var m=new T().setText("Header Bar").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Line Color (ByD-style only):"}),new c.layout.MatrixLayoutCell().addContent(this.oLinePreviewHtml).addContent(l)).createRow(null).createRow(new c.Label({text:"Header Image:"}),this.oHdrImgHtml));e.addTab(m);this.oLogoImgHtml=new H(s+"logoImageHolder",{preferDOM:true,content:"<div id='"+s+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"logoImageImg' src='"+(this.oTransientSettings.sLogoImageSrc?g(this.oTransientSettings.sLogoImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>"});this.oLogoRbg=new c.RadioButtonGroup().addItem(new I({text:"Left",key:"left"})).addItem(new I({text:"Center",key:"center"})).attachSelect(this._handleLogoAlignChange,this);this.oUseLogoSizeCb=new c.CheckBox({text:"Use original image size",checked:this.oTransientSettings.bUseLogoSize,change:q.proxy(this._handleUseLogoSizeChange,this)});var L=new T().setText("Logo").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Logo Image:"}),this.oLogoImgHtml).createRow(new c.Label({text:"Position:"}),this.oLogoRbg).createRow(this.oUseLogoSizeCb));e.addTab(L);d.addContent(e);var t=this;d.addButton(new c.Button({text:"Reset All",press:function(){t.applySettings(Object.assign({},i.getOriginalSettings()));t.oSettings={};t.oTransientSettings={};t.updateDialog();t._bindDragAndDrop("bg");t._bindDragAndDrop("hdr");t._bindDragAndDrop("logo");t.firePersonalizationChange({settings:{}});}}));d.addButton(new c.Button({text:"OK",press:function(){t.oSettings=Object.assign({},t.oTransientSettings);t.firePersonalizationChange({settings:t.oSettings});d.close();}}));d.addButton(new c.Button({text:"Cancel",press:function(){d.close();}}));this.oDialog=d;}return this.oDialog;};
i.prototype.updateDialog=function(){var A=Object.assign({},i.getOriginalSettings(),this.oSettings);var s=this.shell.getId()+"-p13n_";this.oBgImgHtml.setContent("<div id='"+s+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"bgImageImg' src='"+(A.sBackgroundImageSrc?g(A.sBackgroundImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>");this.oBgImgOpacitySlider.setValue(100-A.fBgImgOpacity*100);this.oSidebarOpacitySlider.setValue(100-A.fSidebarOpacity*100);this.oByDStyleCb.setChecked(A.bByDStyle);this.oHdrImgHtml.setContent("<div id='"+s+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"hdrImageImg' src='"+(A.sHeaderImageSrc?g(A.sHeaderImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>");this.oLogoRbg.setSelectedIndex((A.sLogoAlign=="center")?1:0);this.oUseLogoSizeCb.setChecked(A.bUseLogoSize);this.oLogoImgHtml.setContent("<div id='"+s+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+s+"logoImageImg' src='"+(A.sLogoImageSrc?g(A.sLogoImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'></div>");};
i.prototype._handleByDStyleChange=function(e){var c=e.getParameter("checked");this.oTransientSettings.bByDStyle=c;this.applyByDStyle(c);};
i.prototype.applyByDStyle=function(c){this.shell.$().toggleClass("sapUiUx3ShellByD",c);};
i.prototype._handleBgColorChange=function(e){var c=e.getParameter("cssColor");this.oTransientSettings.sBgColor=c;this.applyBgColor(c);};
i.prototype.applyBgColor=function(c){this.shell.$("bg").css("background-color",c);this.shell.$("bgColor").css("background-color",c);};
i.prototype._handleBackgroundImageChange=function(u,p){var t=true;if(p){if(t){this.oSettings.sBgCssImg="url("+u+")";this.oSettings.sBgImgSrc=null;}else{this.oSettings.sBgCssImg=null;this.oSettings.sBgImgSrc=u;}this.applyBgImage(this.oSettings.sBgCssImg,this.oSettings.sBgImgSrc);this.firePersonalizationChange({settings:this.oSettings});}else{if(t){this.oTransientSettings.sBgCssImg="url("+u+")";this.oTransientSettings.sBgImgSrc=null;}else{this.oTransientSettings.sBgCssImg=null;this.oTransientSettings.sBgImgSrc=u;}this.applyBgImage(this.oTransientSettings.sBgCssImg,this.oTransientSettings.sBgImgSrc);}};
i.prototype.applyBgImage=function(s,c){s=s?s:"";c=c?c:i.TRANSPARENT_1x1;var o=this.shell.getDomRef("bgImg");o.style.backgroundImage=s;o.src=c;};
i.prototype._handleHeaderImageChange=function(d,p){if(p){this.oSettings.sHeaderImageSrc=d;this.firePersonalizationChange({settings:this.oSettings});}else{this.oTransientSettings.sHeaderImageSrc=d;}this.applyHeaderImage(d);};
i.prototype.applyHeaderImage=function(d){this.shell.$("hdr").css("background-image","url("+d+")");if(this.oDialog&&this.oDialog.isOpen()){this.shell.$("p13n_hdrImageImg").attr("src",d);}};
i.prototype._handleLineColorChange=function(e){var c=e.getParameter("cssColor");this.oTransientSettings.sLineColor=c;this.applyLineColor(c);};
i.prototype.applyLineColor=function(c){this.shell.$("hdr").find("hr").css("background-color",c);this.shell.$("lineColor").css("background-color",c);};
i.prototype._handleBgImageOpacitySliderChange=function(e){var v=(100-e.getParameter("value"))/100;this.oTransientSettings.fBgImgOpacity=v;this.applyBgImageOpacity(v);};
i.prototype.applyBgImageOpacity=function(v){this.shell.$("bgImg").css("opacity",v);};
i.prototype._handleSidebarOpacitySliderChange=function(e){var v=(100-e.getParameter("value"))/100;this.oTransientSettings.fSidebarOpacity=v;this.applySidebarOpacity(v);};
i.prototype.applySidebarOpacity=function(v){this.shell.$("tp").css("opacity",v);this.shell.$("paneBar").children(":nth-child(2)").css("opacity",v);};
i.prototype._handleLogoImageChange=function(u,p){if(p){this.oSettings.sLogoImageSrc=u;this.firePersonalizationChange({settings:this.oSettings});}else{this.oTransientSettings.sLogoImageSrc=u;}this.applyLogoImage(u);};
i.prototype.applyLogoImage=function(u){if(!u){u=this.shell.getAppIcon();if(!u){u=i.TRANSPARENT_1x1;}}this.shell.$("logoImg").attr("src",u);this.shell.$("p13n_logoImageImg").attr("src",u);};
i.prototype._handleLogoAlignChange=function(e){var c=e.getParameter("selectedIndex");var A=["left","center"][c];this.oTransientSettings.sLogoAlign=A;this.applyLogoAlign(A);};
i.prototype.applyLogoAlign=function(l){var r=l;if(sap.ui.getCore().getConfiguration().getRTL()&&(r=="right")){r="left";}this.shell.$("hdr").css("text-align",r);};
i.prototype._handleUseLogoSizeChange=function(e){var u=e.getParameter("checked");this.oTransientSettings.bUseLogoSize=u;this.applyUseLogoSize(u);};
i.prototype.applyUseLogoSize=function(u){this.shell.$("hdr").toggleClass("sapUiUx3ShellHeaderFlex",u);this.shell.$("hdrImg").toggleClass("sapUiUx3ShellHeaderImgFlex",u);};
i.prototype._handleDragover=function(e){var c=e.target.id;if(!this._dragOverBlinking){var $=q(document.getElementById(c));$.css("opacity","0.5");this._dragOverBlinking=true;var t=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){t._dragOverBlinking=null;},250);},250);}return false;};
i.prototype._handleDragend=function(e){return false;};
i.prototype._handleDrop=function(c){var d=c.target.id;c.preventDefault();var e=c.originalEvent;var j=e.dataTransfer.files[0];if(j){var r=new window.FileReader();r.onload=q.proxy(function(k){var l=k.target.result;if((d==this.shell.getId()+"-p13n_bgImageImg")||(d==this.shell.getId()+"-p13n_bgImageHolder")){this._handleBackgroundImageChange(l);}else if((d==this.shell.getId()+"-p13n_hdrImageImg")||(d==this.shell.getId()+"-p13n_hdrImageHolder")){this._handleHeaderImageChange(l);}else if((d==this.shell.getId()+"-p13n_logoImageImg")||(d==this.shell.getId()+"-p13n_logoImageHolder")){this._handleLogoImageChange(l);}r=null;},this);r.readAsDataURL(j);}};
return i;});
sap.ui.predefine('sap/ui/ux3/ShellRenderer',['sap/ui/core/IconPool','sap/ui/core/theming/Parameters','sap/base/security/encodeXML'],function(I,P,e){"use strict";var S;var a={};
a.render=function(r,c){S=S||sap.ui.require("sap/ui/ux3/Shell");var p=c.isPaneOpen();var b=c.getPaneWidth()+S.SIDE_BAR_BASE_WIDTH;var R=sap.ui.getCore().getConfiguration().getRTL();var s=c.getId();if(S.FIRST_RENDERING){document.body.style.margin="0";}r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3Shell");r.addClass("sapUiUx3ShellHead"+c.getHeaderType());r.addClass("sapUiUx3ShellDesign"+c.getDesignType());if(!c._hasDarkDesign()){r.addClass("sapUiUx3ShellDesignLight");}if(c.getFullHeightContent()){r.addClass("sapUiUx3ShellFullHeightContent");}if(!c.getApplyContentPadding()){r.addClass("sapUiUx3ShellNoContentPadding");}if(!c.getShowTools()){r.addClass("sapUiUx3ShellNoTools");}if(!c.getShowPane()){r.addClass("sapUiUx3ShellNoPane");}if(c._topSyncRefId&&!c.getAllowOverlayHeaderAccess()){r.addClass("sapUiUx3ShellBlockHeaderAccess");}r.writeClasses();r.write(">");r.write("<img id='"+s+"-hdrImg' class='sapUiUx3ShellHeaderImg' src='");var d=P._getThemeImage('sapUiUx3ShellHeaderImageURL',true);r.writeEscaped(d);r.write("' >");r.write("<header id='"+s+"-hdr' class='sapUiUx3ShellHeader' role='banner'>");var t=c._topSyncRefId?" tabindex='0'":"";r.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyHdrStart'"+t+"></span>");a.renderHeader(r,c);r.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyHdrEnd'"+t+"></span>");r.write("</header>");r.write("<div id='",s,"-bg' class='sapUiUx3ShellBg'></div>");r.write("<img id='",s,"-bgImg' class='sapUiUx3ShellBgImg' src='");d=P._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);r.writeEscaped(d);r.write("'>");var w=p?" style='margin-"+(R?"left":"right")+":"+(b+22)+"px'":"";r.write("<div id='",s,"-wBar'"+w+" class='sapUiUx3ShellWorksetBar'>");a.renderWorksetItems(r,c);r.write("</div>");r.write("<section id='"+s+"-tp' class='sapUiUx3ShellToolPaletteArea' role='complementary' data-sap-ui-fastnavgroup='true'>");a.renderToolPalette(r,c);r.write("</section>");var f=p?" style='"+(R?"left":"right")+":"+b+"px'":"";r.write("<div class='sapUiUx3ShellCanvas'"+f+" id='"+s+"-canvas'>");a.renderFacetBar(r,c);r.write("<article class='sapUiUx3ShellContent' id='"+s+"-content' role='main' data-sap-ui-fastnavgroup='true'>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</article><div class='sapUiUx3ShellNotifySpace'></div></div>");var t=c._topSyncRefId?" tabindex='0'":"";r.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyPane'"+t+"></span>");r.write("<aside id='"+s+"-paneBar' class='sapUiUx3ShellPaneBar "+(p?" sapUiUx3ShellPaneBarOpen sapUiUx3ShellPaneBarOpened":" sapUiUx3ShellPaneBarClose")+"' role='complementary' style='width:"+b+"px;'>");r.write("<section id='"+s+"-paneContent' style='width:"+c.getPaneWidth()+"px;' class='sapUiUx3ShellPaneBarContent' role='tabpanel'>");var g=c.getPaneContent();for(var i=0;i<g.length;i++){r.renderControl(g[i]);}r.write("</section>");r.write("<div id='"+s+"-paneBarRight' class='sapUiUx3ShellPaneBarRight' data-sap-ui-fastnavgroup='true'>");r.write("<ul id='"+s+"-paneBarEntries' class='sapUiUx3ShellPaneEntries' role='tablist'>");a.renderPaneBarItems(r,c);r.write("</ul>");r.write("<div id='"+s+"-paneBarOverflowButton' class='sapUiUx3ShellPaneOverflowButton'");r.addStyle("display","none;");r.writeStyles();r.write(">");r.write("<div id='"+s+"-paneBarOverflowWrapper' class='sapUiUx3ShellPaneOverflowWrapper'>");r.write("<span id='"+s+"-paneBarOverflowText' class='sapUiUx3ShellPaneOverflowText sapUiUx3ShellPaneEntry'>");r.write(sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON"));r.write("</span>");r.write("</div>");r.write("</div>");r.write("</div>");r.write("</aside>");r.write("<div class='sapUiUx3ShellCanvasBackground "+(p?"sapUiUx3ShellCanvasBackgroundOpen":"sapUiUx3ShellCanvasBackgroundClosed")+"' id='"+s+"-canvasBackground'"+f+">");r.write("<div class='sapUiUx3ShellCanvasBackgroundRight'></div>");r.write("</div>");r.write("<div id='"+s+"-notify' class='sapUiUx3ShellNotify'>");a.renderNotificationArea(r,c);r.write("</div>");r.write("</div>");};
a.renderHeader=function(r,c){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var d=c.getAppIcon();r.write("<hr id='"+c.getId()+"-hdrLine'>");r.write("<span id='"+c.getId()+"-hdr-items' class='sapUiUx3ShellHeaderTitleRight'>");var h=c.getHeaderItems();for(var i=0;i<h.length;i++){if(h[i]instanceof sap.ui.commons.MenuButton){if(h[i].getMenu()){h[i].getMenu().addStyleClass("sapUiMnuTop",true);}}r.renderControl(h[i]);if((i<(h.length-1))||(c.getShowLogoutButton())){r.write("<span class='sapUiUx3ShellHeaderSep'></span>");}}if(c.getShowLogoutButton()){r.write("<a id='"+c.getId()+"-logout' title='");r.write(c.getLogoutButtonTooltip()?e(c.getLogoutButtonTooltip()):b.getText("SHELL_LOGOUT"));r.write("' tabindex='0' role='button' class='sapUiUx3ShellHeaderButton sapUiUx3ShellHeader-logout'></a>");}r.write("</span>");r.write("<span class='sapUiUx3ShellHeaderTitleLeft' ");r.writeAttributeEscaped("title",c.getAppTitle());r.write(">");r.write("<img id='"+c.getId()+"-logoImg' src='");if(d){r.writeEscaped(c.getAppIcon());}else{var s=P._getThemeImage('sapUiUx3ShellApplicationImageURL',true);r.writeEscaped(s);}r.write("'");var f=c.getAppIconTooltip()||b.getText("SHELL_LOGO");r.writeAttributeEscaped("alt",f);r.writeAttributeEscaped("title",f);r.write(">");r.write("<span>");r.writeEscaped(c.getAppTitle());r.write("</span>");r.write("</span>");};
a.renderToolPalette=function(r,c){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var s=c.getId();var t=c._topSyncRefId?" tabindex='0'":"";r.write("<span class='sapUiUx3ShellFocusDummy' id='"+c.getId()+"-focusDummyTPStart'"+t+"></span>");var A=b.getText("SHELL_TOOLPANE_GENERIC"),d=false,f=true,g="";if(c.getShowSearchTool()){d=true;g+="<a id='"+s+S.TOOL_PREFIX+s+"-searchTool' title='"+b.getText("SHELL_SEARCH")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-search' tabindex='0' role='button' aria-pressed='false'></a>";if(f){f=false;}else{A+=",";}A+=" "+b.getText("SHELL_SEARCH");}if(c.getShowFeederTool()){d=true;g+="<a id='"+s+S.TOOL_PREFIX+s+"-feederTool' title='"+b.getText("SHELL_FEEDER")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-feeder' tabindex='0' role='button' aria-pressed='false'></a>";if(f){f=false;}else{A+=",";}A+=" "+b.getText("SHELL_FEEDER");}if(d){r.write("<div role='toolbar'aria-describedby='"+s+"-genericToolsDescr'>");r.write("<span id='"+s+"-genericToolsDescr' style='display:none;'>"+A+"</span>");r.write(g+"</div>");}var T=c.getToolPopups();if(d&&(T.length>0)){r.write("<hr id='"+s+"-tp-separator' class='sapUiUx3ShellToolSep'>");}if(T.length>0){r.write("<div role='toolbar' aria-describedby='"+s+"-appToolsDescr'>");r.write("<span id='"+s+"-appToolsDescr' style='display:none;'>"+b.getText("SHELL_TOOLPANE_APP")+"</span>");for(var i=0;i<T.length;i++){var o=T[i];if(o instanceof sap.ui.core.SeparatorItem){r.write("<hr class='sapUiUx3ShellToolSep'>");}else{r.write("<a id='"+s+"-tool-"+o.getId()+"' class='sapUiUx3ShellTool'");var h=o.getTooltip_AsString();if(!h){h=o.getTitle();}if(h){r.write(" title='");r.writeEscaped(h);r.write("' ");}r.write(" tabindex='0' role='button' aria-pressed='false'>");var j=o.getIcon();if(I.isIconURI(j)){r.writeIcon(j,["sapUiUx3ShellToolFontIcon"],{"title":null,"aria-label":null});}else{r.write("<img src='");r.writeEscaped(j);r.write("' alt='' role='presentation'>");}r.write("</a>");}}r.write("</div>");}r.write("<span class='sapUiUx3ShellFocusDummy' id='"+c.getId()+"-focusDummyTPEnd'"+t+"></span>");};
a.renderPaneBarItems=function(r,c){var s=c.getId();var p=c.getPaneBarItems();var n=p.length;for(var i=0;i<n;i++){var b=p[i];var d=b.getId();r.write("<li");r.writeElementData(b);r.write(" role='tab' aria-controls='"+s+"-paneContent' aria-setsize='"+n+"' aria-posinset='"+(i+1)+"' tabindex='-1' class='sapUiUx3ShellPaneEntry");if(c._sOpenPaneId===d){r.write(" sapUiUx3ShellPaneEntrySelected");}r.write("'");if(b.getTooltip_AsString()){r.writeAttributeEscaped("title",b.getTooltip_AsString());}r.write(">");r.writeEscaped(b.getText().toUpperCase());r.write("</li>");}};
a.renderNotificationArea=function(r,c){r.write("<div class='sapUiUx3ShellNotifyBG'></div>");if(c.getNotificationBar()){r.renderControl(c.getNotificationBar());}};
a.renderWorksetItems=function(r,c){var i=c.getWorksetItems();c._oWorksetBar.setAssociatedItems(i);if(!c._oWorksetBar.isSelectedItemValid()&&(i.length>0)){c.setAssociation("selectedWorksetItem",i[0],true);c._oWorksetBar.setSelectedItem(i[0]);}if(r){r.renderControl(c._oWorksetBar);}};
a.renderFacetBar=function(r,c){var s=sap.ui.getCore().byId(c.getSelectedWorksetItem());if(s){var p=s.getParent();if(p&&p instanceof sap.ui.ux3.NavigationItem){s=p;}var b=s.getSubItems();c._oFacetBar.setAssociatedItems(b);if(!c._oFacetBar.isSelectedItemValid()&&(b.length>0)){c._oFacetBar.setSelectedItem(b[0]);}}if(r){r.renderControl(c._oFacetBar);}};
return a;},true);
sap.ui.predefine('sap/ui/ux3/ThingAction',['sap/ui/core/Element','./library'],function(E){"use strict";
var T=E.extend("sap.ui.ux3.ThingAction",{metadata:{library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true}},events:{select:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}}}}});
T.prototype.onclick=function(e){this.fireSelect({id:this.getId(),action:this});};
T.prototype.onsapselect=function(e){this.fireSelect({id:this.getId(),action:this});};
return T;});
sap.ui.predefine('sap/ui/ux3/ThingGroup',['sap/ui/core/Element','./library'],function(E){"use strict";
var T=E.extend("sap.ui.ux3.ThingGroup",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},colspan:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"action"}}}});
return T;});
sap.ui.predefine('sap/ui/ux3/ThingInspector',['./ActionBar','./Overlay','./ThingViewer','./ThingInspectorRenderer','./library','./ThingAction','sap/ui/dom/jquery/Selectors','sap/ui/dom/jquery/Focusable'],function(A,O,T,a,l,b){"use strict";var c=l.ActionBarSocialActions;var d=l.ThingViewerHeaderType;var F=l.FollowActionState;
var e=O.extend("sap.ui.ux3.ThingInspector",{metadata:{library:"sap.ui.ux3",properties:{firstTitle:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:F.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:d.Standard}},aggregations:{actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},thingViewer:{type:"sap.ui.ux3.ThingViewer",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}},facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});
e.prototype.init=function(){var o,t=this;O.prototype.init.apply(this);this._oThingViewer=new T(this.getId()+"-thingViewer");this.setAggregation("thingViewer",this._oThingViewer);this._oThingViewer.attachFacetSelected(function(E){var i=E.getParameters().item;if(t.fireFacetSelected({id:i.getId(),key:i.getKey(),item:i})){t.setSelectedFacet(i);}else{E.preventDefault();}});this._oSocialActions={};if(this.getActionBar()==null){o=new A(this.getId()+"-actionBar");o.setShowOpen(false);o.setAlwaysShowMoreMenu(false);o.setDividerWidth("252px");o.attachActionSelected(function(E){var s=E.getParameters().id,B=E.getParameters().action,f;if(s.indexOf(c.Favorite)!==-1||s.indexOf(c.Follow)!==-1||s.indexOf(c.Flag)!==-1){if(t._oSocialActions[s]){f=t._oSocialActions[s];}else{f=new b({id:t.getId()+"-"+s.toLowerCase(),text:B.text,enabled:B.enabled});t._oSocialActions[s]=f;}t.fireActionSelected({id:s.toLowerCase(),action:f});}else{t.fireActionSelected({id:E.getParameters().id,action:E.getParameters().action});}});o.attachFeedSubmit(function(E){t.fireFeedSubmit({text:E.getParameters().text});});this.setActionBar(o);}};
e.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);var s=this._getShell();this._bShell=!!s;if(!s){this._applyChanges({showOverlay:false});}};
e.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);};
e.prototype.exit=function(){this._oThingViewer.exit(arguments);this._oThingViewer.destroy();this._oThingViewer=null;O.prototype.exit.apply(this,arguments);};
e.prototype.open=function(i){if(this.getDomRef()){this.rerender();}O.prototype.open.apply(this,arguments);this._selectDefault();};
e.prototype._getNavBar=function(){return this._oThingViewer._oNavBar;};
e.prototype._selectDefault=function(){this._oThingViewer._selectDefault();};
e.prototype._equalColumns=function(){this._oThingViewer._equalColumns();};
e.prototype._setTriggerValue=function(){this._oThingViewer._setTriggerValue();};
e.prototype._setFocusLast=function(){var f=this.$("thingViewer-toolbar").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){f=this.getDomRef("close");}else if(!f&&this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){f=this.getDomRef("openNew");}if(f){f.focus();}};
e.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){if(this.getDomRef("openNew")){this.getDomRef("openNew").focus();}}else if(this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){if(this.getDomRef("close")){this.getDomRef("close").focus();}}else{if(this.$("thingViewer-content").firstFocusableDomRef()){this.$("thingViewer-content").firstFocusableDomRef().focus();}}};
e.prototype.insertAction=function(o,i){if(this.getActionBar()){this.getActionBar().insertBusinessAction(o,i);}return this;};
e.prototype.addAction=function(o){if(this.getActionBar()){this.getActionBar().addBusinessAction(o);}return this;};
e.prototype.removeAction=function(o){var r;if(this.getActionBar()){r=this.getActionBar().removeBusinessAction(o);}return r;};
e.prototype.removeAllActions=function(){var r;if(this.getActionBar()){r=this.getActionBar().removeAllBusinessActions();}return r;};
e.prototype.getActions=function(){var r;if(this.getActionBar()){r=this.getActionBar().getBusinessActions();}return r;};
e.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions();}return this;};
e.prototype.indexOfAction=function(o){var r=-1;if(this.getActionBar()){r=this.getActionBar().indexOfBusinessAction(o);}return r;};
e.prototype.getFacets=function(){return this._oThingViewer.getFacets();};
e.prototype.insertFacet=function(f,i){this._oThingViewer.insertFacet(f,i);return this;};
e.prototype.addFacet=function(f){this._oThingViewer.addFacet(f);return this;};
e.prototype.removeFacet=function(E){return this._oThingViewer.removeFacet(E);};
e.prototype.removeAllFacets=function(){return this._oThingViewer.removeAllFacets();};
e.prototype.destroyFacets=function(){this._oThingViewer.destroyFacets();return this;};
e.prototype.indexOfFacet=function(f){return this._oThingViewer.indexOfFacet(f);};
e.prototype.setFollowState=function(f){if(this.getActionBar()){this.getActionBar().setFollowState(f);}return this;};
e.prototype.getFollowState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFollowState();}return r;};
e.prototype.setFlagState=function(f){if(this.getActionBar()){this.getActionBar().setFlagState(f);}return this;};
e.prototype.getFlagState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFlagState();}return r;};
e.prototype.setFavoriteState=function(f){if(this.getActionBar()){this.getActionBar().setFavoriteState(f);}return this;};
e.prototype.getFavoriteState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFavoriteState();}return r;};
e.prototype.setIcon=function(i){this._oThingViewer.setIcon(i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}return this;};
e.prototype.getIcon=function(){return this._oThingViewer.getIcon();};
e.prototype.setType=function(t){this._oThingViewer.setType(t);return this;};
e.prototype.getType=function(){return this._oThingViewer.getType();};
e.prototype.insertFacetContent=function(f,i){this._oThingViewer.insertFacetContent(f,i);return this;};
e.prototype.addFacetContent=function(f){this._oThingViewer.addFacetContent(f);return this;};
e.prototype.removeFacetContent=function(f){var r=this._oThingViewer.removeFacetContent(f);return r;};
e.prototype.removeAllFacetContent=function(){var r=this._oThingViewer.removeAllFacetContent();return r;};
e.prototype.destroyFacetContent=function(){this._oThingViewer.destroyFacetContent();return this;};
e.prototype.getFacetContent=function(){return this._oThingViewer.getFacetContent();};
e.prototype.indexOfFacetContent=function(f){return this._oThingViewer.indexOfFacetContent(f);};
e.prototype.setActionBar=function(o){this._oThingViewer.setActionBar(o);return this;};
e.prototype.getActionBar=function(){return this._oThingViewer.getActionBar();};
e.prototype.destroyActionBar=function(){this._oThingViewer.destroyActionBar();return this;};
e.prototype.insertHeaderContent=function(h,i){this._oThingViewer.insertHeaderContent(h,i);return this;};
e.prototype.addHeaderContent=function(h){this._oThingViewer.addHeaderContent(h);return this;};
e.prototype.getHeaderContent=function(){return this._oThingViewer.getHeaderContent();};
e.prototype.removeHeaderContent=function(h){var r=this._oThingViewer.removeHeaderContent(h);return r;};
e.prototype.removeAllHeaderContent=function(){var r=this._oThingViewer.removeAllHeaderContent();return r;};
e.prototype.destroyHeaderContent=function(){this._oThingViewer.destroyHeaderContent();return this;};
e.prototype.indexOfHeaderContent=function(h){return this._oThingViewer.indexOfHeaderContent(h);};
e.prototype.setSelectedFacet=function(s){this._oThingViewer.setSelectedFacet(s);return this;};
e.prototype.getSelectedFacet=function(s){return this._oThingViewer.getSelectedFacet();};
e.prototype.setFavoriteActionEnabled=function(E){if(this.getActionBar()){this.getActionBar().setShowFavorite(E);}return this;};
e.prototype.getFavoriteActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFavorite();}return r;};
e.prototype.setFlagActionEnabled=function(E){if(this.getActionBar()){this.getActionBar().setShowFlag(E);}return this;};
e.prototype.getFlagActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFlag();}return r;};
e.prototype.setUpdateActionEnabled=function(E){if(this.getActionBar()){this.getActionBar().setShowUpdate(E);}return this;};
e.prototype.getUpdateActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowUpdate();}return r;};
e.prototype.setFollowActionEnabled=function(E){if(this.getActionBar()){this.getActionBar().setShowFollow(E);}return this;};
e.prototype.getFollowActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFollow();}return r;};
e.prototype.setFirstTitle=function(t){this._oThingViewer.setTitle(t);return this;};
e.prototype.getFirstTitle=function(){return this._oThingViewer.getTitle();};
e.prototype.setSecondTitle=function(t){this._oThingViewer.setSubtitle(t);return this;};
e.prototype.getSecondTitle=function(){return this._oThingViewer.getSubtitle();};
e.prototype.setHeaderType=function(h){this._oThingViewer.setHeaderType(h);return this;};
e.prototype.getHeaderType=function(){var r=this._oThingViewer.getHeaderType();return r;};
e.prototype._applyChanges=function(C){this.oChanges=C;if(C.showOverlay){this.$().removeClass("sapUiUx3TINoFrame");}else{this.$().addClass("sapUiUx3TINoFrame");}return this;};
return e;});
sap.ui.predefine('sap/ui/ux3/ThingInspectorRenderer',['sap/ui/core/Renderer','./OverlayRenderer'],function(R,O){"use strict";var T=R.extend(O);
T.renderContent=function(r,c){r.write("<div role='Main' class='sapUiUx3TIContent' id='"+c.getId()+"-content'>");r.renderControl(c._oThingViewer);r.write("</div>");};
T.addRootClasses=function(r,c){r.addClass("sapUiUx3TI");};
T.addOverlayClasses=function(r,c){r.addClass("sapUiUx3TIOverlay");};
return T;},true);
sap.ui.predefine('sap/ui/ux3/ThingViewer',['sap/ui/thirdparty/jquery','sap/ui/core/Control','./ThingViewerRenderer','./library','./NavigationBar','sap/ui/core/ResizeHandler'],function(q,C,T,l,N,R){"use strict";var a=l.ThingViewerHeaderType;
var b=C.extend("sap.ui.ux3.ThingViewer",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},subtitle:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:a.Standard}},aggregations:{headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},navBar:{type:"sap.ui.ux3.NavigationBar",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}}}}});
b.prototype.init=function(){var t=this;this._oNavBar=new N();this.setAggregation("navBar",this._oNavBar);this._oNavBar.attachSelect(function(c){var i=c.getParameters().item;if(t.fireFacetSelected({id:i.getId(),key:i.getKey(),item:i})){t.setSelectedFacet(i);}else{c.preventDefault();}});};
b.prototype.onAfterRendering=function(){this._resize=false;if(this.getActionBar()){this._adjustStyles();}if(this.$().find(".sapUiUx3TVFacetContent").length<=0){return;}this._resizeListenerId=R.register(this.$().find(".sapUiUx3TVFacetContent")[0],q.proxy(this._onresize,this));this._setTriggerValue();this._setHeaderPosition();this._onresize();};
b.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
b.prototype._setHeaderPosition=function(){if(this.getHeaderType()===a.Standard){var $=this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),c=this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");c.css("top",$.outerHeight());}};
b.prototype._onresize=function(e){var w;if(e){w=q(e.target).width();}if(!w){w=q(this.$().find(".sapUiUx3TVFacetContent")[0]).width();}if(w<this._triggerValue&&this._resize==false){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"100%"},"fast");}this._resize=true;}else if(w>this._triggerValue&&this._resize==true){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"50%"},"fast");}this._resize=false;}if(this.getActionBar()){var m=this.getActionBar().getActionBarMinWidth(),c=m;if(this._bShell){m+=36;c=m+60;}this.$().find(".sapUiUx3TV").css("min-width",c+"px");this.$().find(".sapUiUx3TVContent").css("min-width",m+"px");}};
b.prototype.exit=function(){this._oNavBar.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
b.prototype._getNavBar=function(){return this._oNavBar;};
b.prototype._selectDefault=function(){var n=this._oNavBar.getItems();if(n.length&&!this._oNavBar.getSelectedItem()){if(!this.getSelectedFacet()){this.setSelectedFacet(n[0]);}var i=this._oNavBar.getSelectedItem(),c=sap.ui.getCore().byId(i);this.fireFacetSelected({id:c.getId(),key:c.getKey(),item:c});}};
b.prototype._equalColumns=function(){var h=this.$().find(".sapUiUx3TVHeader"),f=this.$().find(".sapUiUx3TVFacets"),s=this.$().find(".sapUiUx3TVContentScrollContainer"),c=s.get(0).scrollHeight;f.height(c);h.height(c);};
b.prototype._rerenderHeader=function(){var $=this.$("header");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderHeader(r,this);r.flush($[0]);r.destroy();}};
b.prototype._rerenderHeaderContent=function(){var $=this.$("headerContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderHeaderContent(r,this);r.flush($[0]);r.destroy();}};
b.prototype._rerenderToolbar=function(){var $=this.$("toolbar");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderToolbar(r,this);r.flush($[0]);r.destroy();}};
b.prototype._rerenderFacetContent=function(){var $=this.$("facetContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderFacetContent(r,this);r.flush($[0]);r.destroy();this._resize=false;this._setTriggerValue();this._onresize();}};
b.prototype._setTriggerValue=function(){var f,m,$=this.$("facetContent");if($.length>0){f=this.$().find(".sapUiUx3TVFacetThingGroup");m=q(f[0]).css("min-width");if(m){this._triggerValue=parseInt(m)*2;}}};
b.prototype.getFacets=function(){return this._oNavBar.getItems();};
b.prototype.insertFacet=function(f,i){this._oNavBar.insertItem(f,i);return this;};
b.prototype.addFacet=function(f){this._oNavBar.addItem(f);return this;};
b.prototype.removeFacet=function(e){return this._oNavBar.removeItem(e);};
b.prototype.removeAllFacets=function(){return this._oNavBar.removeAllItems();};
b.prototype.destroyFacets=function(){this._oNavBar.destroyItems();return this;};
b.prototype.setIcon=function(i){this.setProperty("icon",i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}this._rerenderHeader();return this;};
b.prototype.insertFacetContent=function(f,i){this.insertAggregation("facetContent",f,i,true);this._rerenderFacetContent();return this;};
b.prototype.addFacetContent=function(f){this.addAggregation("facetContent",f,true);this._rerenderFacetContent();return this;};
b.prototype.removeFacetContent=function(f){var r=this.removeAggregation("facetContent",f,true);this._rerenderFacetContent();return r;};
b.prototype.removeAllFacetContent=function(){var r=this.removeAllAggregation("facetContent",true);this._rerenderFacetContent();return r;};
b.prototype.destroyFacetContent=function(){this.destroyAggregation("facetContent",true);this._rerenderFacetContent();return this;};
b.prototype.insertHeaderContent=function(h,i){this.insertAggregation("headerContent",h,i,true);this._rerenderHeaderContent();return this;};
b.prototype.addHeaderContent=function(h){this.addAggregation("headerContent",h,true);this._rerenderHeaderContent();return this;};
b.prototype.removeHeaderContent=function(h){var r=this.removeAggregation("headerContent",h,true);this._rerenderHeaderContent();return r;};
b.prototype.removeAllHeaderContent=function(){var r=this.removeAllAggregation("headerContent",true);this._rerenderHeaderContent();return r;};
b.prototype.destroyHeaderContent=function(){this.destroyAggregation("headerContent",true);this._rerenderHeaderContent();return this;};
b.prototype.setSelectedFacet=function(s){var o=this.getSelectedFacet();this.setAssociation("selectedFacet",s,true);var n=this.getSelectedFacet();if(o!=n){this._oNavBar.setSelectedItem(n);}return this;};
b.prototype.setTitle=function(t){this.setProperty("title",t,true);this._rerenderHeader();return this;};
b.prototype.setSubtitle=function(t){this.setProperty("subtitle",t,true);this._rerenderHeader();return this;};
b.prototype.setActionBar=function(A){this.setAggregation("actionBar",A,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon());}this._rerenderToolbar();this._adjustStyles();return this;};
b.prototype._adjustStyles=function(){var $=this.$().find(".sapUiUx3TVHeader"),c=this.$().find(".sapUiUx3TVFacets");if($.length>0){$.addClass("sapUiUx3TVActionBar");$.removeClass("sapUiUx3TVNoActionBar");}if(c.length>0){c.addClass("sapUiUx3TVActionBar");c.removeClass("sapUiUx3TVNoActionBar");}};
return b;});
sap.ui.predefine('sap/ui/ux3/ThingViewerRenderer',["./library"],function(l){"use strict";var T=l.ThingViewerHeaderType;var a={};
a.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeAttributeEscaped("style","width:"+c.getWidth()+"; height:"+c.getHeight());r.addClass('sapUiUx3TV');r.writeClasses();r.write(">");this.renderContent(r,c);r.write("</div>");};
a.renderContent=function(r,c){var h=c.getHeaderType();r.write("<div role='Main' class='sapUiUx3TVContent' id='"+c.getId()+"-content'>");r.write("<div class='sapUiUx3TVHeader sapUiUx3TVNoActionBar");if(c.getHeaderType()===T.Standard){r.write("'>");}else{r.write(" sapUiUx3TVhorizontal'>");}r.write("<div class='sapUiUx3TVHeaderContainerIdentifier'>");r.write("<span role='heading' aria-level='1' class='sapUiUx3TVIdentifier'");r.writeAttributeEscaped("title",c.getType());r.write(">");r.writeEscaped(c.getType());r.write("</span>");r.write("</div>");if(h===T.Standard){r.write("<div class='sapUiUx3TVHeaderGroupScrollContainer'>");r.write("<div id='"+c.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(r,c);r.write("</div>");}else{r.write("<div id='"+c.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(r,c);r.write("</div>");r.write("<div class='sapUiUx3TVHeaderGroupScrollContainer sapUiUx3TVhorizontal'>");}r.write("<div id='"+c.getId()+"-headerContent'");if(h===T.Standard){r.write(">");}else{r.write("style='height:100%; white-space:nowrap'>");}this.renderHeaderContent(r,c);r.write("</div>");r.write("</div>");r.write("</div>");r.write("<div class='sapUiUx3TVFacets sapUiUx3TVNoActionBar");if(h===T.Standard){r.write("'>");}else{r.write(" sapUiUx3TVhorizontal'>");}r.write("<div role='Navigation' class='sapUiUx3TVFacetBar'>");r.renderControl(c._getNavBar());r.write("</div>");r.write("<div id='"+c.getId()+"-facetContent' class='sapUiUx3TVFacetContent sapUiBodyBackground'>");this.renderFacetContent(r,c);r.write("</div>");r.write("</div>");this.renderToolbar(r,c);r.write("</div>");};
a.addRootClasses=function(r,c){r.addClass("sapUiUx3TV");};
a.addOverlayClasses=function(r,c){r.addClass("sapUiUx3TVOverlay");};
a.renderHeader=function(r,c){r.write("<div class='sapUiUx3TVIconBar'>");r.writeIcon(c.getIcon(),["sapUiUx3TVIcon"],{role:'presentation',id:c.getId()+'-swatch',title:null});r.write("<div class='sapUiUx3TVTitle'>");r.write("<span role='heading' aria-level='2' class='sapUiUx3TVTitleFirst'");r.writeAttributeEscaped("title",c.getTitle());r.write(">");r.writeEscaped(c.getTitle());r.write("</span><br>");r.write("</div><div class='sapUiUx3TVTitle'>");r.write("<span role='heading' aria-level='3' class='sapUiUx3TVTitleSecond'");r.writeAttributeEscaped("title",c.getSubtitle());r.write(">");r.writeEscaped(c.getSubtitle());r.write("</span>");r.write("</div>");r.write("</div>");};
a.renderToolbar=function(r,c){if(c.getActionBar()){r.write("<div id='"+c.getId()+"-toolbar' class='sapUiUx3TVToolbar'>");r.renderControl(c.getActionBar());r.write("</div>");}};
a.renderHeaderContent=function(r,c){var h=c.getHeaderContent(),b=c.getHeaderType();for(var i=0;i<h.length;i++){var d=h[i];if(b===T.Standard){r.write("<hr class='sapUiUx3TVHRWhite'>");}r.write("<div class='sapUiUx3TVHeaderContainer");if(b===T.Standard){r.write("' role='form'>");}else{r.write(" sapUiUx3TVhorizontal' role='form'>");}if(d.getTitle()){r.write("<div class='sapUiUx3TVHeaderGroupTitle'");r.writeAttributeEscaped("title",d.getTooltip_AsString()?d.getTooltip_AsString():d.getTitle());r.write("><span role='heading' aria-level='4'>");r.writeEscaped(d.getTitle());r.write("</span>");r.write("</div>");}r.write("<div class='sapUiUx3TVHeaderGroupContent'>");var e=d.getContent();for(var j=0;j<e.length;j++){var f=e[j];r.renderControl(f);}r.write("</div>");r.write("</div>");}};
a.renderFacetContent=function(r,c){var f=c.getFacetContent();var t=true;if(f.length==1){t=false;}for(var i=0;i<f.length;i++){var g=f[i];if(g.getColspan()){r.write("<div class='sapUiUx3TVFacetThingGroupSpan' role='form'>");}else{r.write("<div class='sapUiUx3TVFacetThingGroup' role='form'>");}if(t){r.write("<div class='sapUiUx3TVFacetThingGroupContentTitle'");r.writeAttributeEscaped("title",g.getTooltip_AsString()?g.getTooltip_AsString():g.getTitle());r.write("><span role='heading'>");r.writeEscaped(g.getTitle());r.write("</span></div>");}r.write("<div class='sapUiUx3TVFacetThingGroupContent'>");var b=g.getContent();for(var j=0;j<b.length;j++){r.renderControl(b[j]);}r.write("</div></div>");}};
return a;},true);
sap.ui.predefine('sap/ui/ux3/ToolPopup',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager','./library','./ToolPopupRenderer','sap/ui/core/ResizeHandler','sap/ui/core/library','sap/base/assert','sap/base/Log','sap/ui/dom/jquery/rect','sap/ui/dom/jquery/control','sap/ui/dom/jquery/Selectors'],function(q,C,I,P,a,R,l,T,b,c,d,L){"use strict";var O=c.OpenState;
var e=C.extend("sap.ui.ux3.ToolPopup",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});
e.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);e.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);e.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);e.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){
e.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=q.proxy(p,this);this._proxyClosed=q.proxy(o,this);this._proxyFixSize=q.proxy(F,this);this._proxyOnResize=q.proxy(j,this);s(this);};
e.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup;}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId;};
var _=function(i){var t=i;d(!!t,"No ToolPopup instance given for _fnGetInitialFocus");if(!t._bFocusSet){f(t);}else{t._sInitialFocusId=t.oPopup._sInitialFocusId;}return t._sInitialFocusId;};var f=function(n){var E;var t;var v=n;var w=[v._mParameters.firstFocusable,v._mParameters.lastFocusable];var x=q(":sapTabbable",v.$()).get();for(var i=0;i<x.length;i++){if(w.indexOf(x[i].id)===-1){E=x[i];break;}}t=q(E).control();if(t[0]){var y=t[0].getFocusDomRef();E=y||E;}else{E=w[0]?window.document.getElementById(w[0]):null;}if(E){if(E){E.focus();}v._sInitialFocusId=E.id;}};
function g(t,i){var n,v;if(!i){return null;}n=sap.ui.getCore().byId(i);while(!n&&n!==t){if(!i||!document.getElementById(i)){return null;}v=document.getElementById(i).parentNode;i=v.id;n=sap.ui.getCore().byId(i);}return n;}
e.prototype.getFocusDomRef=function(){var i;var n=g(this,this._sInitialFocusId);if(!n){this._bFocusSet=false;i=_(this);n=g(this,i);}return n?n.getDomRef():this.getDomRef();};
e.prototype.onfocusin=function(E){this._mParameters.event=E;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters);};
var F=function(){var t=this.$();var v=0;var M=this.getMaxHeight();var i=M?parseInt(M):0;var n=this.getMaxWidth();if(n){var w=parseInt(n);var B=t.css("border-left-width");var x=parseInt(B);var y=t.css("border-right-width");var z=parseInt(y);var A=t.css("padding-left");var D=parseInt(A);var E=t.css("padding-right");var H=parseInt(E);w-=x+D+H+z;t.css("max-width",w+"px");}else{t.css("max-width","");}var J=t.css("padding-top");var K=parseInt(J);var N=t.css("padding-bottom");var Q=parseInt(N);var U=t.css("border-top-width");var V=parseInt(U);var W=t.css("border-bottom-width");var X=parseInt(W);var Y=K+Q+V+X;var Z=q(document).scrollTop();var $=t.rect();var a1=$.top-Z+t.outerHeight(true);var b1=q(window).height();var c1=(a1>b1)&&(i===0);var d1=0;if(c1){var e1=q(document.getElementById(this.getOpener()));var f1=e1.rect();var g1=f1.top-Z+e1.outerHeight(true);var h1=this.oPopup._getPositionOffset();if(a1>g1&&h1.length>0){d1=Math.abs(parseInt(h1[1]));if((a1-d1)<b1){c1=false;var i1="Offset of "+d1+" pushes ToolPopup out of the window";L.warning(i1,"","sap.ui.ux3.ToolPopup");}}i=i?i:b1-$.top;}t.toggleClass("sapUiUx3TPLargeContent",c1);if(i||c1){t.css("max-height",i+"px");var j1=this.$("title");var k1=this.$("title-separator");var l1=this.$("buttons");var m1=this.$("buttons-separator");v=i>0?i:b1-$.top-Q-d1;v-=Y;v-=j1.outerHeight(true);v-=k1.outerHeight(true);v-=m1.outerHeight(true);v-=l1.length>0?l1.outerHeight(true):0;v=parseInt(v);var n1=this.$("content");n1.css("max-height",v+"px");n1.toggleClass("sapUiUx3TPLargeContent",true);}S(this);};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var i=_(this);if(i!==sap.ui.getCore().getCurrentFocusedControlId()){var n=q(document.getElementById(i));n.focus();}}if(!this._sResizeID){this._sResizeID=b.register(this.$('content')[0],this._proxyOnResize);}this.fireOpened();};
e.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN");};
e.prototype.willBeClosed=function(){var i=this.oPopup&&this.oPopup.getOpenState();return i!==O.OPENING&&i!==O.OPEN;};
e.prototype.open=function(i,n){this._my=i;this._at=n;this._sArrowDir=G(this);var $=null;this.sOffset="";u(this);if(!this._bPositionSet){var t=0;var v=0;if(!this._my){this._my=P.Dock.BeginTop;}if(!this._at){this._at=P.Dock.EndTop;}$=this.getOpener()?window.document.getElementById(this.getOpener()):null;if($){switch(this._sArrowDir){case"Up":t=0;v=this.iArrowWidth;break;case"Down":t=0;v=-this.iArrowWidth;break;case"Right":t=-this.iArrowWidth;break;default:case"Left":t=this.iArrowWidth;break;}t=parseInt(t);v=parseInt(v);this.sOffset=""+t+" "+v;this.setPosition(this._my,this._at,$,this.sOffset,"none");}else{this.setPosition(P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","fit");L.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup");}this._bPositionSet=false;}this._ensurePopup();var A=this.getAutoClose();var M=this.getModal();if(A&&M){L.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");A=false;}this.oPopup.setAutoClose(A);this.oPopup.setModal(M);this._oPreviousFocus=P.getCurrentFocusInfo();this.fireOpen();h(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,$,this.sOffset,"",true);S(this);return this;};
var h=function(t){if(!t.getOpener()){var i="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){i=t.oPopup._oPosition.of.getId();}else{if(t.oPopup._oPosition.of.length>0){i=t.oPopup._oPosition.of[0].id;}else{i=t.oPopup._oPosition.of.id;}}}if(i!==""){t.setAssociation("opener",i,true);}else{L.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup");}}};var s=function(t){var i="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=a.get(i);t.iArrowWidth=parseInt(t.sArrowWidth);i="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=a.get(i);t.iArrowHeight=parseInt(t.sArrowHeight);i="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=a.get(i);t.iArrowPadding=parseInt(t.sArrowPadding);i="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=a.get(i);t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted);};var G=function(t){var D="Left";var i=t._my;var n=t._at;if(!i&&t.oPopup){i=t.oPopup._oPosition.my;}if(!n&&t.oPopup){n=t.oPopup._oPosition.at;}t._bHorizontalArrow=false;if(i&&n){var M=i.split(" ");var A=n.split(" ");var v="my:"+M[0]+"|"+M[1];v+=" at:"+A[0]+"|"+A[1];if(e.ARROW_LEFT.exec(v)){t._bHorizontalArrow=true;D="Left";}else if(e.ARROW_RIGHT.exec(v)){t._bHorizontalArrow=true;D="Right";}else if(e.ARROW_UP.exec(v)){D="Up";}else if(e.ARROW_DOWN.exec(v)){D="Down";}if(t.getDomRef()&&t.isOpen()){var $=t.$();var w=$.rect();var x=q(document.getElementById(t.getOpener()));var y=x.rect();if(y){if(t._bHorizontalArrow){var z=w.left+$.outerWidth(true)+t.iArrowWidth;var B=y.left+x.outerWidth(true);if(z<=B){D="Right";}else{D="Left";}}else{var E=w.top+$.outerHeight(true)+t.iArrowWidth;var H=y.top+x.outerHeight(true);if(E<=H){D="Down";}else{D="Up";}}}}}return D;};var S=function(t){var K="",v=0,z=0,H=t.iArrowHeight/2,i=sap.ui.getCore().getConfiguration().getRTL(),A,n=t.$().rect(),w=q(document.getElementById(t.getOpener())),x=w.rect(),y=0,$=t.$("arrow");if(!t.getDomRef()){return;}t._sArrowDir=G(t);A=t._sArrowDir;if(i){if(t._sArrowDir==="Right"){A="Left";}else if(t._sArrowDir==="Left"){A="Right";}}if(!x){L.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup");}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my;}if(t._bHorizontalArrow){K="top";if(x){y=parseInt(t.$().css('border-top-width'))||0;z=parseInt(x.top-y-n.top);v=Math.round(z+x.height/2-H);v=v+H>n.height?v-t.iArrowHeight:v;}}else{K="left";if(x){if(i){K="right";y=parseInt(t.$().css('border-right-width'))||0;z=parseInt(n.left+n.width-x.left-x.width-y);}else{y=parseInt(t.$().css('border-left-width'))||0;z=parseInt(x.left-n.left-y);}v=Math.round(z+x.width/2-H);v=v+H>n.width?v-t.iArrowHeight:v;}}if(!x){v=t.iArrowHeight;}var B="";if($.hasClass("sapUiUx3TPNewArrow")){B="sapUiUx3TPNewArrow sapUiUx3TPNewArrow";}else{B=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow";}$.attr("class",B+A);if(A==="Right"){var W=n.width;if(t.isInverted()){W+=t.iArrowPaddingInverted;}else{W+=t.iArrowPadding;}if(i){$.css("right",W+"px");}else{$.css("left",W+"px");}}else{$.css({"left":"","right":""});}v=parseInt(v);v=v<-y?-y:v;$.css(K,v+"px");};
e.prototype.onsapescape=function(){if(this.fireClose()){this.close();}};
var o=function(E){if(!this._bPreventRestoreFocus){P.applyFocusInfo(this._oPreviousFocus);}if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}this.fireClosed();};
e.prototype.close=function(i){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){b.deregister(this._sResizeID);delete this._sResizeID;}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=i;}return this;};
e.prototype.getEnabled=function(){var i=this.oPopup?this.oPopup.getOpenState():O.CLOSED;return i===O.OPENING||i===O.OPEN;};
e.prototype.onsapenter=function(E){var i=this.getDefaultButton();var n=sap.ui.getCore().byId(i);if(i&&n&&q.contains(this.getDomRef(),n.getDomRef())){if(n instanceof sap.ui.commons.Button){var $=n.$();$.click();$.focus();}}E.preventDefault();E.stopPropagation();};
e.prototype.onBeforeRendering=function(){var i=this.getInitialFocus()||this._sInitialFocusId;var D=this.getDefaultButton();this._bFocusSet=true;if(i){this.oPopup.setInitialFocusId(i);}else if(D){this.oPopup.setInitialFocusId(D);}else{this._bFocusSet=false;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();};
e.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){P.prototype._applyPosition.apply(t.oPopup,arguments);var i=t.oPopup._oLastPosition.of;if(!i){t.oPopup.close();}else{var $=q(document.getElementById(i.id));if(t._bPositionSet){if(!$.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at;}}S(t);}};}return this.oPopup;};
var j=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition);}};
e.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;h(this);return this;};
var k=function(i,t){var n=i;if(t==="content"){r(n);}else if(t==="buttons"){m(n);}n._proxyFixSize();n.oPopup._applyPosition(n.oPopup._oLastPosition);};var r=function(t){var n=t.getDomRef("content");n.innerHTML="";var v=t.getContent();var w=sap.ui.getCore().createRenderManager();for(var i=0;i<v.length;i++){w.renderControl(v[i]);}w.flush(n,true);w.destroy();};var m=function(t){var B=t.getDomRef("buttons");var n=t.getDomRef("buttons-separator");var v=t.getButtons();if(v.length===0){q(B).addClass("sapUiUx3TPButtonRowHidden");q(n).addClass("sapUiUx3TPButtonRowHidden");}else{q(B).removeClass("sapUiUx3TPButtonRowHidden");q(n).removeClass("sapUiUx3TPButtonRowHidden");B.innerHTML="";var w=sap.ui.getCore().createRenderManager();for(var i=0;i<v.length;i++){w.renderControl(v[i]);}w.flush(B,true);w.destroy();}};
e.prototype.addContent=function(i){this.addAggregation("content",i,true);if(this.isOpen()){k(this,"content");}return this;};
e.prototype.insertContent=function(i,n){this.insertAggregation("content",i,n,true);if(this.isOpen()){k(this,"content");}return this;};
e.prototype.removeContent=function(i){this.removeAggregation("content",i,true);if(this.isOpen()){k(this,"content");}return this;};
e.prototype.addButton=function(B){this.addAggregation("buttons",B,true);if(this.isOpen()){k(this,"buttons");}return this;};
e.prototype.insertButton=function(B,i){this.insertAggregation("buttons",B,i,true);if(this.isOpen()){k(this,"buttons");}return this;};
e.prototype.removeButton=function(B){this.removeAggregation("button",B,true);if(this.isOpen()){k(this,"buttons");}return this;};
var u=function(t){var i="sapUiUx3ToolPopupInverted";i=a.get(i);t._bThemeInverted=i==="true";};
e.prototype.onThemeChanged=function(){u(this);};
e.prototype.isInverted=function(){u(this);return this.getInverted()&&this._bThemeInverted;};
e.prototype.setAutoCloseAreas=function(A){this._ensurePopup();return this.oPopup.setAutoCloseAreas(A);};
e.prototype.addFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:i});return this;}else{L.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};
e.prototype.removeFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:i});return this;}else{L.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};
}());
e.prototype.setIcon=function(i){this.setProperty("icon",i,true);this.fireIconChanged();return this;};
e.prototype.setIconHover=function(i){this.setProperty("iconHover",i,true);this.fireIconChanged();return this;};
e.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,true);this.fireIconChanged();return this;};
e.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover");};
e.prototype.setMaxWidth=function(m){var p=/[0-9]+px/;if(p.test(m)){this.setProperty("maxWidth",m);}else{L.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup");}return this;};
return e;});
sap.ui.predefine('sap/ui/ux3/ToolPopupRenderer',[],function(){"use strict";var T={};
T.render=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var I=c.getId();var C=c.getContent();var b=c.getButtons();var t=c.getTitle();var s=sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3TP");if(t===""){r.addClass("sapUiUx3TPNoTitle");}if(b.length===0){r.addClass("sapUiUx3TPNoButtons");}if(c.isInverted()){r.addClass("sapUiTPInverted");r.addClass("sapUiInverted-CTX");}r.writeClasses();r.write(" aria-labelledby='",I,"-title ",I,"-acc' role='dialog'");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div id='"+I+"-arrow' class='sapUiUx3TPArrow sapUiUx3TPArrowLeft'><div class='sapUiUx3TPArrowBorder'></div></div>");r.write("<span style='display:none;' id='",I,"-acc'>");r.writeEscaped(a.getText("DIALOG_CLOSE_HELP"));r.write("</span>");r.write('<span id="'+I+'-firstFocusable'+'" tabindex="0" class="sapUiUxTPFocus">');r.write('<img src="'+s+'">');r.write('</span>');if(t&&(t.length!=="")){r.write('<div class="sapUiUx3TPTitle" id="'+I+'-title">');r.write('<span class="sapUiUx3TPTitleText">');r.writeEscaped(t);r.write('</span>');r.write('</div>');r.write('<div class="sapUiUx3TPTitleSep" id="'+I+'-title-separator"></div>');}else{var d=c.getTooltip_AsString();if(d){r.write("<h1 id='"+I+"-title' style='display:none;'>");r.writeEscaped(d);r.write("</h1>");}}r.write('<div id="'+I+'-content"');r.addClass("sapUiUx3TPContent");r.writeClasses();r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write('</div>');if(b.length>0){r.write('<div class="sapUiUx3TPButtonsSep" id="'+I+'-buttons-separator"></div>');r.write('<div class="sapUiUx3TPBtnRow" id="'+I+'-buttons">');for(var i=0;i<b.length;i++){r.renderControl(b[i].addStyleClass("sapUiUx3TPBtn"));}}else{r.write('<div class="sapUiUx3TPButtonsSep sapUiUx3TPButtonRowHidden" id="'+I+'-buttons-separator"></div>');r.write('<div class="sapUiUx3TPBtnRow sapUiUx3TPButtonRowHidden" id="'+I+'-buttons">');}r.write("</div>");r.write('<span id="'+I+'-lastFocusable'+'" tabindex="0" class="sapUiUxTPFocus">');r.write('<img src="'+s+'">');r.write('</span>');r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/ux3/library',['sap/ui/core/library','sap/ui/commons/library'],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.ux3",version:"1.71.34",dependencies:["sap.ui.core","sap.ui.commons"],types:["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],interfaces:["sap.ui.ux3.DataSetView"],controls:["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],elements:["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"]});sap.ui.ux3.ActionBarSocialActions={Update:"Update",Follow:"Follow",Flag:"Flag",Favorite:"Favorite",Open:"Open"};sap.ui.ux3.ExactOrder={Select:"Select",Fixed:"Fixed"};sap.ui.ux3.FeederType={Large:"Large",Medium:"Medium",Comment:"Comment"};sap.ui.ux3.FollowActionState={Follow:"Follow",Hold:"Hold",Default:"Default"};sap.ui.ux3.NotificationBarStatus={Default:"Default",Min:"Min",Max:"Max",None:"None"};sap.ui.ux3.ShellDesignType={Standard:"Standard",Light:"Light",Crystal:"Crystal"};sap.ui.ux3.ShellHeaderType={Standard:"Standard",BrandOnly:"BrandOnly",NoNavigation:"NoNavigation",SlimNavigation:"SlimNavigation"};sap.ui.ux3.ThingViewerHeaderType={Standard:"Standard",Horizontal:"Horizontal"};sap.ui.ux3.VisibleItemCountMode={Fixed:"Fixed",Auto:"Auto"};return sap.ui.ux3;});
sap.ui.require.preload({
	"sap/ui/ux3/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.ux3","type":"library","embeds":[],"applicationVersion":{"version":"1.71.34"},"title":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","description":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"},"sap.ui.commons":{"minVersion":"1.71.34"},"sap.ui.unified":{"minVersion":"1.71.34","lazy":true}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],"elements":["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"],"types":["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],"interfaces":["sap.ui.ux3.DataSetView"]}}}}'
},"sap/ui/ux3/library-preload"
);
//# sourceMappingURL=library-preload.js.map