/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Element","sap/ui/base/ManagedObjectObserver","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/m/ResponsivePopover","sap/ui/vbm/Viewport","./adapter3d/ObjectFactory","./adapter3d/VBIJSONParser","./adapter3d/SceneBuilder","./adapter3d/Utilities","sap/m/HBox","sap/m/VBox","sap/m/Link","sap/m/Button","sap/m/Text","sap/m/Image","./adapter3d/thirdparty/three"],function(q,l,E,O,M,c,P,V,d,e,S,U,H,f,L,B,T,I,h){"use strict";var t="sap.ui.vbm.adapter3d.Adapter3D";var j=q.sap.log;var k;var A=E.extend("sap.ui.vbm.Adapter3D",{metadata:{library:"sap.ui.vbm",associations:{viewport:{type:"sap.ui.vbm.Viewport"}},events:{submit:{parameters:{data:{type:"string"}}}}}});var n=A.getMetadata().getParent().getClass().prototype;A.prototype.init=function(){if(n.init){n.init.call(this);}this._viewport=null;this._context={resources:new Map(),dataTypes:[],data:{},windows:[],scenes:[],actions:[],voQueues:{toAdd:new Map(),toUpdate:new Map(),toRemove:new Map(),clear:function(){this.toAdd.clear();this.toUpdate.clear();this.toRemove.clear();}},sceneQueues:{toAdd:[],toUpdate:[],toRemove:[],clear:function(){this.toAdd.length=0;this.toUpdate.length=0;this.toRemove.length=0;}},windowQueues:{toAdd:[],toUpdate:[],toRemove:[],clear:function(){this.toAdd.length=0;this.toUpdate.length=0;this.toRemove.length=0;}},setupView:undefined};this._update=Promise.resolve();this._parser=null;this._sceneBuilder=null;this._hoverInstance=null;this._hoverTimeOutId=null;this._clickTimerId=null;this._mouseDown=false;this._lastXY={x:0,y:0};this._viewportObserver=new O(this._observeChanges.bind(this));this._detail={popover:undefined,anchor:undefined,pending:undefined};this._raycaster=new h.Raycaster();};A.prototype.exit=function(){if(this._clickTimerId){clearTimeout(this._clickTimerId);this._clickTimerId=null;}if(this._hoverTimeOutId){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=null;}this._disconnectViewport();this._viewportObserver.disconnect();this._viewportObserver=null;if(this._sceneBuilder){this._sceneBuilder.destroy();this._sceneBuilder=null;}if(this._parser){this._parser.destroy();this._parser=null;}this._context=null;if(n.exit){n.exit.call(this);}};A.prototype.setViewport=function(v){this.setAssociation("viewport",v,true);this._configureViewport();};A.prototype._configureViewport=function(){var a=sap.ui.getCore().byId(this.getViewport())||null;if(a!==this._viewport){this._disconnectViewport();this._viewport=a;this._connectViewport();}};A.prototype._connectViewport=function(){if(this._viewport){this._viewportObserver.observe(this._viewport,{destroy:true});this._viewport.addEventDelegate(k,this);}};A.prototype._disconnectViewport=function(){if(this._viewport){this._viewport.removeEventDelegate(k);k.onBeforeRendering.call(this);this._viewportObserver.unobserve(this._viewport,{destroy:true});this._viewport=null;}};A.prototype._observeChanges=function(a){if(a.type==='destroy'&&a.object===this._viewport){this._disconnectViewport();}};A.prototype.load=function(a){var b=this;b._configureViewport();if(!b._viewport){return Promise.reject();}var p=null;if(!b._parser){b._parser=new e(b._context);}if(!b._sceneBuilder){b._sceneBuilder=new S(b._context,b._viewport);}if(typeof a==="string"){try{p=JSON.parse(a);}catch(g){j.error("sap.ui.vbm.Adapter: attempt to load invalid JSON string.");return Promise.resolve();}}else if(typeof a==="object"){p=a;}if(!(p&&p.SAPVB)){j.error("sap.ui.vbm.Adapter3D: attempt to load null.");return Promise.resolve();}b._viewport.setBusy(true);b._update=b._update.then(function(){b._parser.loadVBIJSON(p);return b._sceneBuilder.synchronize();}).then(function(){b._processAutomation(p);b._processDetailWindow();b._context.voQueues.toRemove.forEach(function(i){i.forEach(function(m){if(b._hoverInstance===m){b._hoverInstance=null;}},b);},b);b._context.voQueues.clear();b._context.sceneQueues.clear();b._context.windowQueues.clear();b._viewport._resetBBox();b._viewport._updateCamera();b._viewport.setBusy(false);});return b._update;};A.prototype._processDetailWindow=function(p){var w=sap.ui.vbm.findInArray(this._context.windowQueues.toAdd,function(w){return w.type==="callout";});var s=w&&sap.ui.vbm.findInArray(this._context.scenes,function(s){return s.id===w.refScene;});if(w&&s){this._closeDetailWindow();var a=this._createDetailWindow(w);this._fillDetailWindow(a,s);this._openDetailWindow(a,w);}};A.prototype._closeDetailWindow=function(){if(this._detail.popover){this._detail.popover.close();this._detail.popover.destroy();this._detail.popover=undefined;}if(this._detail.anchor){this._detail.anchor.style.visibility="hidden";}};A.prototype._createDetailWindow=function(w){var a;if(w.caption!==""){var b=new sap.m.Text({width:"100%",textAlign:sap.ui.core.TextAlign.Center,text:w.caption,tooltip:w.caption});a=new sap.m.Bar({contentLeft:[b]});}var p=new sap.m.ResponsivePopover({placement:sap.m.PlacementType.Auto,showCloseButton:true,verticalScrolling:true,contentWidth:w.width+"px"});p.addStyleClass("sapUiVbmDetailWindow");if(a){p.setCustomHeader(a);}return p;};A.prototype._getAnchor=function(x,y){if(!this._detail.anchor){var a=document.createElement("div");a.setAttribute("role",sap.ui.core.AccessibleRole.Note);a.classList.add("sapUiVbmDetailWindowAnchor");this._viewport.getDomRef().appendChild(a);this._detail.anchor=a;}this._detail.anchor.style.left=x+"px";this._detail.anchor.style.top=y+"px";return this._detail.anchor;};A.prototype._openDetailWindow=function(p,a){var b=a.pos.split(";");var w=new h.Vector3(parseFloat(b[0]),parseFloat(b[1]),parseFloat(b[2]));if(!this._viewport.getDomRef()){if(this._detail.pending){this._detail.pending.popover.destroy();}this._detail.pending={world:w,popover:p};}else{var g=this._viewport.getDomRef().getBoundingClientRect();var s=this._viewport.worldToScreen(U.vbToThreeJs(w));s.x=U.clamp(s.x,5,g.width-5);s.y=U.clamp(s.y,5,g.height-5);p.openBy(this._getAnchor(s.x,s.y));p.attachAfterClose(function(){this._closeDetailWindow();}.bind(this));this._detail.popover=p;}};A.prototype._openDetailPending=function(){if(this._detail.pending&&this._viewport.getDomRef()){var s=this._viewport.worldToScreen(U.vbToThreeJs(this._detail.pending.world));this._detail.pending.popover.openBy(this._getAnchor(s.x,s.y));this._detail.popover=this._detail.pending.popover;this._detail.pending=undefined;}};A.prototype._fillDetailWindow=function(p,s){var m=function(a){var b;switch(a){case"1":b=sap.m.FlexJustifyContent.Start;break;case"2":b=sap.m.FlexJustifyContent.Center;break;case"4":b=sap.m.FlexJustifyContent.End;break;default:b=sap.m.FlexJustifyContent.Inherit;break;}return b;};var u=function(i){var a;switch(i.type){case"{00100000-2013-1000-1100-50059A6A47FA}":a=new T({text:i.vo.text,tooltip:i.vo.tooltip});a.addStyleClass("sapUiVbmDetailWindowBase sapUiVbmDetailWindowCaption");if(i.vo.level==="3"){a.addStyleClass("sapUiVbmDetailWindowCaption3");}break;case"{00100000-2013-1000-3700-AD84DDBBB31B}":a=new T({text:i.vo.text,tooltip:i.vo.tooltip});a.addStyleClass("sapUiVbmDetailwindowBase");break;case"{00100000-2013-1000-2400-D305F7942B98}":a=new L({text:i.vo.text,tooltip:i.vo.tooltip,href:i.vo.autoexecute?i.vo.reference:""});a.addStyleClass("sapUiVbmDetailWindowBase");break;case"{00100000-2013-1000-1200-855B919BB0E9}":a=new B({text:i.vo.text,tooltip:i.vo.tooltip});break;case"{00100000-2013-1000-2200-6B060A330B2C}":if(i.vo.image&&i.vo.image!==""){a=new I({src:U.makeDataUri(this._context.resources.get(i.vo.image)),tooltip:i.vo.tooltip});}break;default:j.error("sap.ui.vbm.Adapter3D: attempt to create unknown element of detail window: "+i.type);}return a;};var w=s.voGroups.map(function(a){return a.vos.map(function(v){return{type:a.type,vo:v};});}).reduce(function(a,b){return a.concat(b);}).sort(function(a,b){return parseInt(a.vo.top,10)-parseInt(b.vo.top,10);}).reduce(function(g,a){var b=a.vo.top?a.vo.top:"0";g[b]=g[b]||[];g[b].push(a);return g;},{});var x=new f();for(var y in w){if(w.hasOwnProperty(y)){var z=new H({width:Math.max.apply(null,w[y].map(function(i){return parseInt(i.vo.right,10);}))+"px"});var C=0;w[y].sort(function(a,b){return parseInt(a.vo.left,10)-parseInt(b.vo.left,10);}).map(function(i){var a=[];if((parseInt(i.vo.left,10)-C)>1){a.push(new H({width:(parseInt(i.vo.left,10)-C)+"px"}));}var b=new H({width:(parseInt(i.vo.right,10)-parseInt(i.vo.left,10))+"px",justifyContent:m(i.vo.align)});C=parseInt(i.vo.right,10);b.addItem(u.bind(this)(i));a.push(b);return a;},this).reduce(function(a,b){return a.concat(b);}).forEach(z.addItem,z);x.addItem(z);}}p.addContent(x);};A.prototype._processAutomation=function(a){var b=this;var g=function(m,p,z,C,v){var D=new c({text:p.text,enabled:p.disabled==="X"?false:true,startsSection:v,select:b._menuItemSelectionHandler.bind(b,p.id,z.instance,C,z.object)});if(p.MenuItem){var F=new M();v=false;[].concat(p.MenuItem).forEach(function(G){if(G.hasOwnProperty("Separator")){v=true;}else{g(F,G,z,C,v);v=false;}});D.setSubmenu(F);}m.addItem(D);};if(a&&a.SAPVB&&a.SAPVB.Automation&&a.SAPVB.Automation.Call&&a.SAPVB.Automation.Call){if(a.SAPVB.Automation.Call.handler&&a.SAPVB.Automation.Call.handler==="CONTEXTMENUHANDLER"){var x=[].concat(a.SAPVB.Automation.Call.Param).filter(function(p){return p.name==="x";});var y=[].concat(a.SAPVB.Automation.Call.Param).filter(function(p){return p.name==="y";});var i;if(x.length>0&&y.length>0){i=x[0]["#"]+" "+y[0]["#"];}if(a.SAPVB&&a.SAPVB.Menus&&a.SAPVB.Menus.Set){var s=[].concat(a.SAPVB.Menus.Set).filter(function(m){return m.Menu.id===a.SAPVB.Automation.Call.refID;});if(s.length>0){var u=new M();var v=false;[].concat(s[0].Menu.MenuItem).forEach(function(m){if(m.hasOwnProperty("Separator")){v=true;}else{g(u,m,a.SAPVB.Automation.Call,s[0].Menu.action,v);v=false;}});var w=sap.ui.core.Popup.Dock;u.open(false,this._viewport,w.BeginTop,w.BeginTop,this._viewport,i,"fit fit");}}}}};A.prototype._menuItemSelectionHandler=function(i,a,b,v){var p={version:"2.0","xmlns:VB":"VB",Action:{id:i,instance:a,name:b,object:v}};this.fireSubmit({data:JSON.stringify(p)});};A.prototype._genericEventHandler=function(a,b){var i=b.instance;var g=i?i.voGroup.id:b.voGroupId;var m=sap.ui.vbm.findInArray(this._context.actions,function(v){return v.refVO===g&&v.refEvent===a;});if(m){var p=[];var s={version:"2.0","xmlns:VB":"VB",Action:{id:m.id,name:m.name,object:m.refVO,instance:i&&i.id?i.voGroup.datasource+"."+i.id:"",Params:{Param:p}}};if(m.name==="KEY_PRESS"){if(b.keyCode==72){this._viewport.applyCameraHome(false);}if(b.key=="Shift"||b.code==16||b.key=="Control"||b.code==17||b.key=="Alt"||b.code==18||b.key=="Meta"||b.code==91){return;}else{p.push({"name":"code","#":b.keyCode},{"name":"shift","#":b.shiftKey},{"name":"ctrl","#":b.ctrlKey},{"name":"alt","#":b.altKey},{"name":"meta","#":b.metaKey});}}else if(b&&b.cursor){p.push({name:"x","#":b.cursor.x},{name:"y","#":b.cursor.y});}if(m.AddActionProperty){var u=[];[].concat(m.AddActionProperty).forEach(function(v){switch(v.name){case"pos":if(b.hitPoint){var w=U.threeJsToVb(b.hitPoint);u.push({name:v.name,"#":w.x.toFixed(5)+";"+w.y.toFixed(5)+";"+w.z.toFixed(5)});}break;case"zoom":var x=this._viewport._getCameraState();var z=this._sceneBuilder._getZoomFactor(x.position,x.target);u.push({name:v.name,"#":z.toFixed(5)});break;default:break;}},this);if(u.length>0){s.Action.AddActionProperties={AddActionProperty:u};}}if(i&&a==="Click"&&b.selectionChanges){s.Data={Merge:{N:[{name:i.voGroup.datasource,E:b.selectionChanges.selected.map(function(i){return{K:i?i.id:"","VB:s":"true"};}).concat(b.selectionChanges.deselected.map(function(i){return{K:i?i.id:"","VB:s":"false"};}))}]}};}this.fireSubmit({data:JSON.stringify(s)});}};A.prototype._propagateClick=function(a){this._genericEventHandler("Click",a);};A.prototype._propagateDoubleClick=function(a){this._genericEventHandler("DoubleClick",a);};A.prototype._propagateContextMenu=function(a){this._genericEventHandler("ContextMenu",a);};A.prototype._propagateKeyPress=function(a){this._genericEventHandler("KeyPress",a);};A.prototype._propogateHoverChange=function(a){this._genericEventHandler("HoverChange",a);};A.prototype._handleClick=function(a){var i=a.instance;j.trace("click","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._extendEventWithSelection(a);if(a.selectionChanges){this._sceneBuilder.updateSelection(a.selectionChanges.selected,a.selectionChanges.deselected);}this._propagateClick(a);};A.prototype._handleDoubleClick=function(a){var i=a.instance;j.trace("double click","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._propagateDoubleClick(a);};A.prototype._handleContextMenu=function(a){var i=a.instance;if(!i){a.voGroupId="Scene";}j.trace("context menu","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);this._propagateContextMenu(a);};A.prototype._handleHover=function(a){var b;var i=a.instance||null;j.trace("hover","x: "+a.cursor.x+", y: "+a.cursor.y+", instance: "+(i?i.id:"")+", tooltip: "+(i?i.tooltip:""),t);if(i){b=i.tooltip;if(!b){b=i.text;}}var g=this._viewport.getDomRef();if(g){if(b){g.setAttribute("title",b);}else{g.removeAttribute("title");}}if(i!==this._hoverInstance){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=setTimeout(function(){this._propogateHoverChange(a);this._hoverTimeOutId=undefined;}.bind(this),500);this._hoverInstance=i;this._sceneBuilder.updateHotInstance(this._hoverInstance);}};A.prototype._handleKeyPress=function(a){j.trace("keypress",a.key,t);this._propagateKeyPress(a);};A.prototype._getXY=function(a){var b=this._viewport.getDomRef().getBoundingClientRect();return{x:(a.pageX||a.originalEvent.pageX)-window.pageXOffset-b.left,y:(a.pageY||a.originalEvent.pageY)-window.pageYOffset-b.top};};A.prototype._hitTest=function(a){var s=this._viewport.getScene();var b=this._viewport.getCamera();var p=a.cursor||this._getXY(a);var g=this._viewport.getDomRef().getBoundingClientRect();var i=new h.Vector2(p.x/g.width*2-1,-p.y/g.height*2+1);this._raycaster.layers.set(0);this._raycaster.setFromCamera(i,b);var m=this._raycaster.intersectObjects(s.children,true);if(m&&m.length>0){var u=m[0],v=u.object,w=null;if(v){if(v._instanceHitTest instanceof Function){w=v._instanceHitTest(u);}else{w=u.object._sapInstance;}return{info:u,point:u.point,instance:w};}}else if(this._context.scene){m=this._viewport._intersectMapPlane(this._raycaster);if(m&&m.length>0){return{instance:null,info:m[0],point:m[0].point};}}return undefined;};A.prototype._extendEventWithCursor=function(a){a.cursor=a.cursor||this._getXY(a);};A.prototype._extendEventWithInstance=function(a){this._extendEventWithCursor(a);var b=this._hitTest(a);if(b){a.instance=b.instance;a.hitPoint=b.point;}else{a.instance=null;}};var o=3;k={onkeydown:function(a){if(!a.originalEvent.repeat){this._handleKeyPress(a);}},oncontextmenu:function(a){this._extendEventWithInstance(a);if(this._skipClick){this._skipClick=false;this._handleHover(a);}else{this._handleContextMenu(a);}},onmousedown:function(a){if(this._hoverTimeOutId){clearTimeout(this._hoverTimeOutId);this._hoverTimeOutId=null;}this._mouseDown=true;this._extendEventWithCursor(a);j.trace("mousedown","x: "+a.cursor.x+", y: "+a.cursor.y,t);this._lastXY.x=a.cursor.x;this._lastXY.y=a.cursor.y;},onmouseup:function(a){this._mouseDown=false;},onhover:function(a){if(this._mouseDown){this._extendEventWithCursor(a);j.trace("hover","x: "+a.cursor.x+", y: "+a.cursor.y,t);if(Math.abs(this._lastXY.x-a.cursor.x)>o||Math.abs(this._lastXY.y-a.cursor.y)>o){this._skipClick=true;}}else{this._extendEventWithInstance(a);this._handleHover(a);}},onmouseout:function(a){this._extendEventWithInstance(a);delete a.instance;this._handleHover(a);},onBeforeRendering:function(a){if(this._onhoverProxy){this._viewport.$().off(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"pointermove":"mousemove",this._onhoverProxy);}if(this._onpointerdownProxy){this._viewport.$().off("pointerdown",this._onpointerdownProxy);}if(this._onpointerupProxy){this._viewport.$().off("pointerup",this._onpointerupProxy);}},onAfterRendering:function(a){if(!this._onhoverProxy){this._onhoverProxy=k.onhover.bind(this);}this._viewport.$().on(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"pointermove":"mousemove",this._onhoverProxy);if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){if(!this._onpointerdownProxy){this._onpointerdownProxy=k.onmousedown.bind(this);}this._viewport.$().on("pointerdown",this._onpointerdownProxy);if(!this._onpointerupProxy){this._onpointerupProxy=k.onmouseup.bind(this);}this._viewport.$().on("pointerup",this._onpointerupProxy);}if(this._detail.anchor){this._viewport.getDomRef().appendChild(this._detail.anchor);}this._openDetailPending();}};k[sap.ui.Device.browser.msie||sap.ui.Device.browser.edge?"onclick":"ontap"]=function(a){j.trace("onclick","",t);this._extendEventWithInstance(a);if(this._skipClick){this._skipClick=false;this._handleHover(a);}else if(this._clickTimerId){clearTimeout(this._clickTimerId);this._clickTimerId=null;this._handleDoubleClick(a);}else{this._clickTimerId=setTimeout(function(){this._clickTimerId=null;this._handleClick(a);}.bind(this),200);}};var r=sap.ui.Device.os.macintosh?"metaKey":"ctrlKey";A.prototype._extendEventWithSelection=function(a){var i=a.instance;if(i){if(a.originalEvent.type==="click"){if(!(a[r]&&a.shiftKey)){var b;var g;if(a[r]){b="toggle";g=false;}else if(a.shiftKey){b="select";g=false;}else{b="select";g=true;}a.selectionChanges=this._changeSelection(i,b,g);}}else{a.selectionChanges=this._changeSelection(i,"toggle",false);}}};A.prototype._changeSelection=function(i,a,b){var s=[];var g=[];var m=i.voGroup;var w=U.toBoolean(i["VB:s"]);var p;if(a==="select"){if(m.maxSel!=="0"){if(w){if(b){p=m.selected.indexOf(i);g=m.selected.splice(p+1).concat(m.selected.splice(0,p));}}else{if(b||m.maxSel==="1"){g=m.selected.splice(0);}m.selected.push(i);s=[i];}}}else if(a==="toggle"){if(w){if(m.minSel==="0"||m.selected.length>1){p=m.selected.indexOf(i);g=m.selected.splice(p,1);}}else if(m.maxSel!=="0"){if(m.maxSel==="1"){g=m.selected.splice(0);}m.selected.push(i);s=[i];}}s.forEach(function(i){i["VB:s"]="true";});g.forEach(function(i){i["VB:s"]="false";});return{selected:s,deselected:g};};return A;});
