/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(['sap/ui/core/theming/Parameters','./GeoMap','./library','./VoBase'],function(P,G,l,V){"use strict";var A=G.extend("sap.ui.vbm.AnalyticMap",{metadata:{library:"sap.ui.vbm",properties:{},aggregations:{regions:{type:"sap.ui.vbm.Region",multiple:true,singularName:"region"}},events:{regionClick:{parameters:{code:{type:"string"}}},regionContextMenu:{parameters:{code:{type:"string"}}},regionSelect:{},regionDeselect:{}}}});A.DefaultABAPGeoJSONURL="/sap/bc/vbi/geojson/L0.json";A.DefaultGeoJSONURL="media/analyticmap/L0.json";A.DefaultRegionColor=(P&&P.get("_sap_ui_vbm_shared_ChoroplethRegionBG"))?P.get("_sap_ui_vbm_shared_ChoroplethRegionBG"):"rgb(213,218,221)";A.DefaultRegionColorBorder=(P&&P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder"))?P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder"):"rgb(255,255,255)";A.DefaultRegionSelectColor="RHLSA(0;1;1;1)";A.DefaultHotDeltaColor="RHLSA(0;1;1;1.0)";A.AltBorderColor=(P&&P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"))?P.get("_sap_ui_vbm_shared_ChartDataPointBorderHoverSelectedColor"):"#676767";var n=(P&&P.get("_sap_ui_vbm_shared_ChartDataPointNotSelectedBackgroundOpacity")?P.get("_sap_ui_vbm_shared_ChartDataPointNotSelectedBackgroundOpacity"):"0.6");A.DefaultRegionNonSelectColor="RHLSA(0;1;1;"+n+")";A.prototype.exit=function(){G.prototype.exit.apply(this,arguments);this.detachEvent('submit',A.prototype.onAnalyticsSubmit,this);};A.prototype.onAfterRendering=function(){sap.ui.vbm.VBI.prototype.onAfterRendering.apply(this,arguments);};A.prototype.destroyRegions=function(){this.mbRegionsDirty=true;this.destroyAggregation("regions");};A.prototype.addRegion=function(o){this.mbRegionsDirty=true;this.addAggregation("regions",o);};A.prototype.removeRegion=function(o){this.mbRegionsDirty=true;this.removeAggregation("regions",o);};A.prototype.insertRegion=function(o,i){this.mbRegionsDirty=true;this.insertAggregation("regions",o,i);};A.prototype.removeAllRegions=function(){this.mbRegionsDirty=true;this.removeAllAggregation("regions");};A.prototype.destroyLegend=function(){this.mbLegendDirty=true;this.destroyAggregation("legend");};A.prototype.setLegend=function(o){this.mbLegendDirty=true;this.setAggregation("legend",o);};A.prototype.onAnalyticsSubmit=function(e){var d=JSON.parse(e.mParameters.data);var c,o,p;switch(d.Action.name){case"RGN_CONTEXTMENU":c=d.Action.instance.split(".")[1];p={code:c};if((o=this.findRegionInAggregation(c))){o.fireContextMenu(p);}this.fireRegionContextMenu(p);break;case"RGN_CLICK":c=d.Action.instance.split(".")[1];p={code:c};if((o=this.findRegionInAggregation(c))){o.fireClick(p);}this.fireRegionClick(p);if(d.Data&&d.Data.Merge){this.setSelectionPropFireSelect(d.Data.Merge);}break;default:break;}};A.prototype.init=function(){this.mProperties.scaleVisible=false;G.prototype.init.apply(this,arguments);this.mbRegionsDirty=false;this.mbLegendDirty=false;this.mbThemingDirty=true;this.attachEvent('submit',A.prototype.onAnalyticsSubmit,this);this.createRegions();};A.prototype.createRegions=function(){var c=this.mColC=A.DefaultRegionColor;var a=this.mColCB=A.DefaultRegionColorBorder;function _(K,L,M,N,O,Q,R){var S={};S.K=K;S.P=[];S.T=Q;S.C=N;S.CB=O;S.HDC=A.DefaultHotDeltaColor;S.ACB=S.CB;S.G=R;S.S="false";var T,U,W;for(var F=0,X=L.length;F<X;++F){U=L[F];W=[];for(var q=0,Y=U.length;q<Y;++q){T="";for(var H=0,Z=U[q].length;H<Z;++H){if(H){(T+=";");}T+=U[q][H];}W.push(T);}S.P.push(W);}return S;}var d=null,p=[],r,s="";p[0]=A.GeoJSONURL;var u=window.URI(A.DefaultABAPGeoJSONURL);u.addQuery("sap-language",sap.ui.getCore().getConfiguration().getLanguage());p[1]=u.toString();p[2]=sap.ui.resource("sap.ui.vbm",A.DefaultGeoJSONURL);for(var i=0;i<3;++i){s=p[i];if(!d&&s){r=jQuery.sap.syncGetJSON(s);if(r.statusCode===200&&r.data&&!r.error){d=r.data;break;}}}if(!d){jQuery.sap.log.error("The GeoJSON file at location "+s+" is invalid or could not be parsed.\r\nPlease contact your Administrator.");return;}var E=[];this.mRegionApplicationTable=E;this.mRegionBox=[];this.mNames=[];this.mRegionProps=[];var m,b,e,g;var h=d.features,t='',v;var j;var k;var o;for(var q=0,w=h.length;q<w;++q){v=[];k=[];o=[];j=[];var f=h[q];if(f.id2==="AQ"){continue;}if(!f.id2){f.id2=f.id;}t=(f.properties&&f.properties.name)?f.properties.name:"";this.mNames[f.id2]=t;this.mRegionProps[f.id2]=f.properties;var z=f.geometry.coordinates;var B,x,y,C,D;var F,H;switch(f.geometry.type){case"Polygon":e=Number.MAX_VALUE;g=-Number.MAX_VALUE;m=Number.MAX_VALUE;b=-Number.MAX_VALUE;D=z.length;for(F=0;F<D;++F){B=z[F];v=[];for(H=0;H<B.length;++H){C=B[H];if(!F){if((x=C[0])<m){m=x;}if(x>b){b=x;}if((y=C[1])<e){e=y;}if(y>g){g=y;}}v.push(C[0],C[1],"0");}o.push(v);}k.push(o);j.push([m,b,e,g]);break;case"MultiPolygon":for(var I=0,J=z.length;I<J;++I){e=Number.MAX_VALUE;g=-Number.MAX_VALUE;m=Number.MAX_VALUE;b=-Number.MAX_VALUE;o=[];D=z[I].length;for(F=0;F<D;++F){B=z[I][F];v=[];for(H=0;H<B.length;++H){C=B[H];if(!F){if((x=C[0])<m){m=x;}if(x>b){b=x;}if((y=C[1])<e){e=y;}if(y>g){g=y;}}v.push(C[0],C[1],"0");}o.push(v);}j.push([m,b,e,g]);k.push(o);}break;default:continue;}E.push(_(f.id2,k,f.geometry.type,c,a,t,f.id2));this.mRegionBox[f.id2]=window.VBI.MathLib.GetSurroundingBox(j);}};A.prototype.getRegionsTemplateObject=function(){return{"id":"Region","type":"{00100000-2012-0004-B001-F311DE491C77}","entity.bind":"Regions.Entity","datasource":"Regions","posarraymulti.bind":"Regions.PosList","color.bind":"Regions.Color","selectColor":A.DefaultRegionSelectColor,"nonSelectColor":A.DefaultRegionNonSelectColor,"colorBorder.bind":"Regions.BorderColor","tooltip.bind":"Regions.ToolTip","hotDeltaColor.bind":"Regions.HotDeltaColor","altBorderDeltaColor.bind":"Regions.AltBorderColor","select.bind":"Regions.VB:s","labelText.bind":"Regions.LT","labelPos.bind":"Regions.LP","labelBgColor.bind":"Regions.LBC","labelBorderColor.bind":"Regions.LBBC","labelArrow.bind":"Regions.AR","labelType.bind":"Regions.LabelType"};};A.prototype.getRegionsTypeObject=function(){var a=[{"name":"Key","alias":"K","type":"string"},{"name":"PosList","alias":"P","type":"vectorarraymulti"},{"name":"ToolTip","alias":"T","type":"string"},{"name":"Color","alias":"C","type":"color"},{"name":"BorderColor","alias":"CB","type":"color"},{"name":"HotDeltaColor","alias":"HDC","type":"string"},{"name":"AltBorderColor","alias":"ACB","type":"color"},{"name":"Entity","alias":"G","type":"string"},{"name":"VB:s","alias":"S","type":"boolean"},{"name":"LT","alias":"LT","type":"string"},{"name":"LP","alias":"LP","type":"string"},{"name":"LBC","alias":"LBC","type":"color"},{"name":"LBBC","alias":"LBBC","type":"color"},{"name":"AR","alias":"AR","type":"boolean"},{"name":"LabelType","alias":"LabelType","type":"string"}];return{"name":"Regions","minSel":"0","maxSel":"-1","key":"Key","A":a};};A.prototype.getRegionsDataObjects=function(){var e=[];var E=[];var a=[];var b=[];jQuery.extend(true,e,this.mRegionApplicationTable);if(!e.length){return null;}var r=this.getRegionMap();for(var c=0,d=e.length,R,i,t;c<d;++c){i=e[c];if((R=r[i.K])){i.HDC="RHLSA(0;1.0;1.0;0.4)";i.ACB=A.AltBorderColor;if((t=R.getColor())){i.C=(this.getPlugin())?window.VBI.Utilities.String2VBColor(t):t;}if((t=R.getTooltip())){i.T=t;}i.LT=R.getLabelText();i.S=R.getSelect();i.LP="0";i.LBC=R.getLabelBgColor();i.LBBC=R.getLabelBorderColor();i.AR=R.getLabelArrow();var f=R.getLabelType();var o=V.prototype.getLabelProps(f);if(o&&i.LT){if(o.LBC){i.LBC=o.LBC;}if(o.LBBC){i.LBBC=o.LBBC;}if(o.LIC){i.LIC=o.LIC;}if(o.LICC){i.LICC=o.LICC;}if(o.LICTC){i.LICTC=o.LICTC;}}if(!i.LBC){i.LBC="rgba(255,255,255,1.0)";}if(i.LBBC==""){i.LBBC=i.LBC;}E.push(i);}else{a.push(i);}}b=a.concat(E);return{"name":"Regions","type":"N","E":b};};A.prototype.addRegionsActions=function(a){a.push({"id":"AMap1","name":"RGN_CLICK","refScene":"MainScene","refVO":"Region","refEvent":"Click"});a.push({"id":"AMap2","name":"RGN_CONTEXTMENU","refScene":"MainScene","refVO":"Region","refEvent":"ContextMenu"});return a;};A.prototype.findSelected=function(s,d){var c=this.getRegions();if(!c){return null;}var S=[];if(jQuery.type(d)=='object'){if(d.S==(s?"true":"false")){for(var a=0;a<c.length;++a){if(c[a].sId==d.K){S.push(c[a]);}}}}else if(jQuery.type(d)=='array'){for(var b=0;b<d.length;++b){if(d[b].S==(s?"true":"false")){for(var e=0;e<c.length;++e){if(c[e].mProperties.code===d[b].K){S.push(c[e]);}}}}}return S;};A.prototype.setSelectionPropFireSelect=function(d){var g={};g.N=[];var N=d.N;for(var a=0;a<N.length;++a){var o=N[a];var e=o.E;var c,C;var b=false;if(o.name=="Regions"){c=[];C=[];var r=this.getRegionMap();for(var f=0;f<e.length;++f){var E=e[f];var h=(E.S=="true"?true:false);var R=r[E.K];if(R){var m=R.getSelect();if(h!=m){R.setProperty("select",h,true);if(h&&this.mEventRegistry["regionSelect"]){c.push(R);}else if(!h&&this.mEventRegistry["regionDeselect"]){C.push(R);}}}else{b=true;}}if(C.length){this.fireRegionDeselect({deselected:C});}if(c.length){this.fireRegionSelect({selected:c});}if(b){this.invalidate();this.mbForceDataUpdate=true;}}else{g.N.push(o);}}if(g.N.length){G.prototype.setSelectionPropFireSelect.call(this,g);}};A.prototype.getSelectedItems=function(d){var s=[];if(!d){return null;}for(var a=0;a<d.length;++a){if(d[a].name==="Regions"){var r=this.findSelected(true,d[a].E);if(r&&r.length){s=s.concat(r);}}else{var c=this.getAggregatorContainer(d[a].name);var C=c.findSelected(true,d[a].E);if(C&&C.length){s=s.concat(C);}}}return s;};A.prototype.findRegionInAggregation=function(c){var C=this.getRegions();if(C){for(var a=0,b=C.length;a<b;++a){if(C[a].mProperties.code===c){return C[a];}}}return null;};A.prototype.updateVOData=function(s,a,b,c,d){if(this.mbThemingDirty){this.applyTheming(this.mRegionApplicationTable);}s.push(this.getRegionsTemplateObject());c.push(this.getRegionsTypeObject());b.push({name:"Regions",type:"N"});a.push(this.getRegionsDataObjects());G.prototype.updateVOData.apply(this,arguments);this.addRegionsActions(d);};A.prototype.resetDirtyStates=function(){G.prototype.resetDirtyStates.apply(this,arguments);this.mbRegionsDirty=false;};A.prototype.minimizeApp=function(a){G.prototype.minimizeApp.apply(this,arguments);var t,r;if(!this.getMapConfiguration()){(t=a)&&(t=t.SAPVB)&&(t=t.Scenes)&&((r=t.Set)||(r=t.Merge))&&(t=r.SceneGeo)&&(t.refMapLayerStack)&&(t.refMapLayerStack="");}return a;};A.prototype.invalidate=function(s){if(s instanceof sap.ui.vbm.Region){this.mbRegionsDirty=true;}G.prototype.invalidate.apply(this,arguments);};A.prototype.getRegionMap=function(){var r={};var c=this.getRegions();for(var a=0,b=c?c.length:0,i;a<b;++a){i=c[a];r[i.getCode()]=i;}return r;};A.prototype.zoomToRegions=function(c,C){if(C==undefined){C=0.9999;}var a=[];for(var b=0,d=c.length;b<d;++b){var r=this.mRegionBox[c[b]];if(r!=undefined){a.push(r);}}if(!a.length){return;}var s=null;if((s=this.mVBIContext.GetMainScene())){s.ZoomToAreas(a,C);}};A.prototype.getRegionsInfo=function(c){var r=[];for(var a=0,b=c.length,d;a<b;++a){d=c[a];r[d]={};r[d].BBox=this.mRegionBox[d];r[d].Midpoint=[(this.mRegionBox[d][0]+this.mRegionBox[d][1])/2,(this.mRegionBox[d][2]+this.mRegionBox[d][3])/2];r[d].Name=this.mNames[d];r[d].Properties=this.mRegionProps[d];}return r;};A.prototype.onThemeChanged=function(e){this.mbThemingDirty=true;this.invalidate();};A.prototype.applyTheming=function(r){if(sap.ui.core.theming&&P){var c=A.DefaultRegionColor;if(P.get("_sap_ui_vbm_shared_ChoroplethRegionBG")!=undefined){c=A.DefaultRegionColor=P.get("_sap_ui_vbm_shared_ChoroplethRegionBG");}var C=A.DefaultRegionColorBorder;if(P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder")!=undefined){C=A.DefaultRegionColorBorder=P.get("_sap_ui_vbm_shared_ChoroplethRegionBorder");}if(this.getPlugin()){c=window.VBI.Utilities.String2VBColor(c);C=window.VBI.Utilities.String2VBColor(C);}if(c!=this.mColC||C!=this.mColCB){for(var i=0;i<r.length;++i){if(r[i].C===this.mColC){r[i].C=c;}if(r[i].CB===this.mColCB){r[i].CB=C;}}this.mColC=c;this.mColCB=C;}this.mbThemingDirty=false;}};A.prototype.isRegionSubscribed=function(e,r){if(r){var i=this.findRegionInAggregation(r);return i&&i.hasListeners(e);}return false;};return A;});
