/*!
 * SAP UI development toolkit for HTML5 (SAPUI5) (c) Copyright 2009-2012 SAP AG. All rights reserved
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/Object","./thirdparty/three"],function(q,B,T){"use strict";var t="sap.ui.vbm.adapter3d.Utilities";var l=q.sap.log;var C=T.Color;var V=T.Vector3;var M=T.Matrix4;var d=T.Math.degToRad;var U=B.extend("sap.ui.vbm.adapter3d.Utilities",{});U.refCountPropertyName="_sapRefCount";U.refCountable=function(o){return o.hasOwnProperty(U.refCountPropertyName);};U.refCountableDispose=function(o){return o.hasOwnProperty(U.refCountPropertyName)&&o[U.refCountPropertyName]===0;};U.addRef=function(o){if(!o.hasOwnProperty(U.refCountPropertyName)){o[U.refCountPropertyName]=0;}o[U.refCountPropertyName]+=1;};U.subRef=function(o){if(o.hasOwnProperty(U.refCountPropertyName)){o[U.refCountPropertyName]-=1;return o[U.refCountPropertyName]===0;}return false;};U.toArray=function(i){return i===undefined?[]:[].concat(i);};U.toBoolean=function(v){var f=v.charAt(0);return f==="t"||f!==""&&f!=="f"&&f!==" "&&f!=="0";};U.toFloat=function(v){return parseFloat(v);};U.toVector3=function(v,o){var a=v.split(";");if(a.length!==3){return o?o.set(0,0,0):new V(0,0,0);}var x=parseFloat(a[0]),y=parseFloat(a[1]),z=parseFloat(a[2]);return o?o.set(x,y,z):new V(x,y,z);};U.threeJsToVb=function(p){return new V(-p.x,p.z,-p.y);};U.vbToThreeJs=function(p){return new V(-p.x,-p.z,p.y);};U.toColor=(function(){var a="\\s*(\\d+)\\s*";var h="\\s*(?:0[xX])([\\da-fA-F]+)\\s*";var b=a+"(,|;)"+a+"\\2"+a;var f=a+"(,|;)"+a+"\\2"+a+"\\2"+a;var c=h+"(,|;)"+h+"\\2"+h;var e=h+"(,|;)"+h+"\\2"+h+"\\2"+h;var r=new RegExp("^\\s*RGB\\("+b+"\\)\\s*$");var g=new RegExp("^\\s*RGB\\("+c+"\\)\\s*$");var i=new RegExp("^\\s*RGBA\\("+f+"\\)\\s*$");var j=new RegExp("^\\s*RGBA\\("+e+"\\)\\s*$");var k=new RegExp("^\\s*ARGB\\("+f+"\\)\\s*$");var n=new RegExp("^\\s*ARGB\\("+e+"\\)\\s*$");var o=new RegExp("^\\s*HLS\\("+b+"\\)\\s*$");var p=new RegExp("^\\s*HLS\\("+c+"\\)\\s*$");var s=new RegExp("^\\s*HLSA\\("+f+"\\)\\s*$");var u=new RegExp("^\\s*HLSA\\("+e+"\\)\\s*$");var v=new RegExp("^"+a+"$");var w=new RegExp("^"+h+"$");return function(x){var m;var y;var z=1;if((m=x.match(r))){y=new C(parseInt(m[1],10)/255,parseInt(m[3],10)/255,parseInt(m[4],10)/255);}else if((m=x.match(g))){y=new C(parseInt(m[1],16)/255,parseInt(m[3],16)/255,parseInt(m[4],16)/255);}else if((m=x.match(i))){y=new C(parseInt(m[1],10)/255,parseInt(m[3],10)/255,parseInt(m[4],10)/255);z=m[5]/255;}else if((m=x.match(j))){y=new C(parseInt(m[1],16)/255,parseInt(m[3],16)/255,parseInt(m[4],16)/255);z=m[5]/255;}else if((m=x.match(k))){y=new C(parseInt(m[3],10)/255,parseInt(m[4],10)/255,parseInt(m[5],10)/255);z=m[1]/255;}else if((m=x.match(n))){y=new C(parseInt(m[3],16)/255,parseInt(m[4],16)/255,parseInt(m[5],16)/255);z=m[1]/255;}else{l.warning("Cannot convert color, use default",x,t);y=new C(0.5,0.5,0.5);}return{rgb:y,opacity:z};};})();U.toColorDelta=(function(){var f="\\s*([-+]?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?)\\s*";var r=new RegExp("^\\s*RHLS\\("+f+";"+f+";"+f+"\\)\\s*$");var a=new RegExp("^\\s*RHLSA\\("+f+";"+f+";"+f+";"+f+"\\)\\s*$");return function(b){var m;var h;var o=1;if((m=b.match(r))){h=new V(parseFloat(m[1]),parseFloat(m[2]),parseFloat(m[3]));}else if((m=b.match(a))){h=new V(parseFloat(m[1]),parseFloat(m[2]),parseFloat(m[3]));o=parseFloat(m[4]);}else{l.warning("Cannot convert color delta, use default",b,t);h=new V(1,1,1);}return{hls:h,opacity:o};};})();U.multiplyColors=function(x,y,o){o.r=U.clamp(x.r*y.r,0.0,1.0);o.g=U.clamp(x.g*y.g,0.0,1.0);o.b=U.clamp(x.b*y.b,0.0,1.0);};U.isColorDelta=function(v){return v.startsWith("RHLS");};U.applyDeltaHLS=function(c,h){var a=c.getHSL({});a.h=a.h+h.x;a.s=U.clamp(a.s*h.z,0.0,1.0);a.l=U.clamp(a.l*h.y,0.0,1.0);c.setHSL(a.h,a.s,a.l);};U.rgbaToString=function(c){return c.rgb.getHexString()+Math.round(c.opacity*255).toString(16);};U.equalsRGBA=function(a,r){return a.rgb.equals(r.rgb)&&a.opacity===r.opacity;};U.getColor=function(i,s,h){var c=U.toColor(s);var a=U.toBoolean(i["VB:s"]);if(a){var b=U.isColorDelta(i.selectColor);var e=b?U.toColorDelta(i.selectColor):U.toColor(i.selectColor);if(b){U.applyDeltaHLS(c.rgb,e.hls);c.opacity=U.clamp(c.opacity*e.opacity,0.0,1.0);}else{c.rgb.copy(e.rgb);c.opacity=e.opacity;}}if(h){var f=U.isColorDelta(i.hotDeltaColor);var g=f?U.toColorDelta(i.hotDeltaColor):U.toColor(i.hotDeltaColor);if(f){U.applyDeltaHLS(c.rgb,g.hls);c.opacity=U.clamp(c.opacity*g.opacity,0.0,1.0);}else{c.rgb.copy(g.rgb);c.opacity=g.opacity;}}return c;};U.applyColor=function(i,s,o,h,a){var c=U.toColor(s);var b=U.toBoolean(i["VB:s"]);var e,f,g,j;if(b){e=U.isColorDelta(i.selectColor);f=e?U.toColorDelta(i.selectColor):U.toColor(i.selectColor);}if(h){g=U.isColorDelta(i.hotDeltaColor);j=g?U.toColorDelta(i.hotDeltaColor):U.toColor(i.hotDeltaColor);}var r="_sapReference";U.toArray(o).forEach(function(k){k.traverse(function(n){U.toArray(n.material).forEach(function(m){if(a!==undefined){m.map=a;}var p=m[r]||(m[r]={rgb:m.color.clone(),opacity:m.opacity});U.multiplyColors(p.rgb,c.rgb,m.color);m.opacity=U.clamp(p.opacity*c.opacity,0.0,1.0);if(b){if(e){U.applyDeltaHLS(m.color,f.hls);m.opacity=U.clamp(m.opacity*f.opacity,0.0,1.0);}else{m.color.copy(f.rgb);m.opacity=f.opacity;}}if(h){if(g){U.applyDeltaHLS(m.color,j.hls);m.opacity=U.clamp(m.opacity*j.opacity,0.0,1.0);}else{m.color.copy(j.rgb);m.opacity=j.opacity;}}m.transparent=m.opacity<1;});});});};U.clamp=function(v,m,a){if(v<m){return m;}if(v>a){return a;}return v;};U.swap=function(o,a,b){var c=o[a];o[a]=o[b];o[b]=c;};U.makeDataUri=function(a){return a&&"data:text/plain;base64,"+a;};U.base64ToArrayBuffer=function(s){var a=atob(s);var b=new Uint8Array(a.length);for(var i=0;i<a.length;++i){b[i]=a.charCodeAt(i);}return b.buffer;};U.getInstanceTransform=function(i,p,r,s,b){U.toVector3(i.pos,p);U.toVector3(i.scale,s);var a=U.toVector3(i.rot);r.set(d(a.x),d(a.y),d(a.z),"YXZ");var c;if(i.isPolygon){c=new V(0,0,0);}else if(i.isBox||i.isCylinder){c=new V(0,0,-1);}else if(i.isModel){c=new V(0,0,-1.0*(b.min.z>0?b.min.z:b.max.z));}else{l.error("Unsupported instance type","",t);}if(r.x!==0||r.y!==0||r.z!==0||s.x!==1||s.y!==1||s.z!==1){var m=new M();m.makeRotationFromEuler(r);var o=new M();o.makeScale(s.x,s.y,s.z);o.multiply(m);c.applyMatrix4(o);}c.z=-c.z;p.sub(c);};U.getInstanceMatrix=function(i,m,b){var p=new V(),r=new T.Euler(),s=new V();U.getInstanceTransform(i,p,r,s,b);if(p.x!==0||p.y!==0||p.z!==0||r.x!==0||r.y!==0||r.z!==0||s.x!==1||s.y!==1||s.z!==1){var a=new T.Quaternion();a.setFromEuler(r,false);m.compose(p,a,s);m._identity=false;}else{m.identity();m._identity=true;}};U.createMaterial=function(a){return new T.MeshPhongMaterial({color:0xffffff,opacity:1.0,shininess:1,specular:0x101009,side:a?T.DoubleSide:T.FrontSide});};U.createLineMaterial=function(){return new T.LineBasicMaterial({color:0xffffff,opacity:1.0,linewidth:1});};U.propertyAdded=function(i,p){return i[p]&&!i._last[p];};U.propertyRemoved=function(i,p){return!i[p]&&i._last[p];};U.propertyChanged=function(a,p){if(Array.isArray(p)){for(var i=0;i<p.length;++i){if(a[p[i]]!==a._last[p[i]]){return true;}}return false;}else{return a[p]!==a._last[p];}};U.updateProperty=function(i,p){if(Array.isArray(p)){p.forEach(function(a){i._last[a]=i[a];});}else{i._last[p]=i[p];}};U.normalizeObject3D=function(r,m,b){var a=new T.Box3().setFromObject(r);var c=a.getCenter(new V());a.min.sub(new V(c.x,c.y,-c.z));a.max.sub(new V(c.x,c.y,-c.z));var s=Math.max(Math.abs(a.min.x),Math.abs(a.min.y),Math.abs(a.min.z),Math.abs(a.max.x),Math.abs(a.max.y),Math.abs(a.max.z));if(s){s=1/s;}a.min.set(a.min.x*s,a.min.y*s,-a.min.z*s);a.max.set(a.max.x*s,a.max.y*s,-a.max.z*s);U.swap(a,"min","max");if(b){b.copy(a);}var e=new M().makeScale(s,s,s);var f=new M().makeTranslation(-c.x,-c.y,-c.z);r.updateMatrix();e.multiply(f);e.multiply(r.matrix);if(m){m.copy(e);}else{e.decompose(r.position,r.quaternion,r.scale);}};U.cloneMaterials=function(m){if(m){if(Array.isArray(m)){return m.map(function(a){return a.clone();});}return m.clone();}return m;};return U;});
