
VBI.LinearProjection=function(t){"use strict";var p={};p.vbiclass="Projection/Linear";p.m_nXYRatio=2;p.m_nXMin=-2;p.m_nXMax=2;p.m_nGeometrySize=4;p.m_nUCSMin=-0.5;p.m_nUCSMax=1.5;p.m_bIsIsogonal=true;p.LonLatToUCS=function(l,u){var x=u[0];var y=u[1];u[0]=x*(0.5+l[0]/Math.PI);u[1]=y*(0.5-l[1]/Math.PI);return u;};p.UCSToLonLat=function(u,l){l[0]=Math.PI*(p.m_nUCSMin+u[0]/2);l[1]=-Math.PI*(u[1]/2);return l;};return p;};
VBI.MercatorProjection=function(t){"use strict";var p={};p.vbiclass="Projection/Mercator";p.m_nXYRatio=1;p.m_nXMin=-1;p.m_nXMax=1;p.m_nGeometrySize=2;p.m_nUCSMin=0;p.m_nUCSMax=1;p.m_bIsIsogonal=true;p.LonLatToUCS=VBI.MathLib.LonLatToUCS;p.UCSToLonLat=VBI.MathLib.UCSToLonLat;return p;};
VBI.ElliMercatorProjection=function(t){"use strict";var p={};p.vbiclass="Projection/EllipticalMercator";p.m_nXYRatio=1;p.m_nXMin=-1;p.m_nXMax=1;p.m_nGeometrySize=2;p.m_nUCSMin=0;p.m_nUCSMax=1;p.m_bIsIsogonal=true;p.m_rmajor=6378137;p.m_rminor=6356752.3142;var r=p.m_rminor/p.m_rmajor;p.m_eccent=Math.sqrt(1.0-(r*r));p.m_halfEccent=0.5*p.m_eccent;p.m_PI_Div_180=Math.PI/180.0;p.m_PI_Div_2=Math.PI/2;p.m_PI_Div_4=Math.PI/4;p.m_majMultPIDiv180=p.m_PI_Div_180*p.m_rmajor;p.m_tolerance=0.0000000001;p.m_EllipticalBorder=89.5*p.m_PI_Div_180;p.m_PIx2=2.0*Math.PI;p.m_yMax=2.0*Math.PI*p.m_rmajor;p.LonLatToUCS=function(l,u){var a=l[0],b=Math.max(Math.min(l[1],p.m_EllipticalBorder),-p.m_EllipticalBorder);var c=p.m_eccent*Math.sin(b);c=Math.pow((1-c)/(1+c),p.m_halfEccent);var x=0.5+a/p.m_PIx2;var y=0.5+Math.log(Math.tan(p.m_PI_Div_4-b/2)/c)/p.m_PIx2;u[0]=u[0]*x;u[1]=u[1]*y;return u;};p.UCSToLonLat=function(u,l){l[0]=Math.PI*u[0];l[1]=this.CalcPhi(Math.exp(Math.PI*u[1]));return l;};p.CalcPhi=function(a){var j=15,d,c,b=p.m_PI_Div_2-2.0*Math.atan(a);do{c=p.m_eccent*Math.sin(b);d=p.m_PI_Div_2-2.0*Math.atan(a*Math.pow((1.0-c)/(1.0+c),p.m_halfEccent))-b;b+=d;}while(Math.abs(d)>p.m_tolerance&&--j);return b;};return p;};
