/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/EventProvider","./Messages","./getResourceBundle"],function(q,E,M,g){"use strict";var D=E.extend("sap.ui.vk.DownloadManager",{metadata:{events:{itemSucceeded:{parameters:{source:{type:"any"},response:{type:"object"}}},itemProgress:{parameters:{source:{type:"any"},loaded:{type:"int"},total:{type:"int"}}},itemFailed:{parameters:{source:{type:"any"},status:{type:"any"},statusText:{type:"string"}}},allItemsCompleted:{}}},constructor:function(s,m,a){E.apply(this);this._maxParallelTasks=m||5;this._sourcesToProcess=s.slice();this._sourcesBeingProcessed=[];this._authorizationHandler=a;}});D.prototype.start=function(){while(this._pickAndDispatchTask()){}return this;};D.prototype.queue=function(s){this._sourcesToProcess.push(s);this._pickAndDispatchTask();return this;};D.prototype._pickAndDispatchTask=function(){if(this._sourcesToProcess.length>0&&this._sourcesBeingProcessed.length<this._maxParallelTasks){var s=this._sourcesToProcess.shift();this._sourcesBeingProcessed.push(s);var t=this;if(this._authorizationHandler){this._authorizationHandler(s).then(function(a){var b=null;if(a!=null){b=a.token_type+" "+a.access_token;}t._runTask(s,b);}).catch(function(r){t.fireItemFailed({source:s,status:0,statusText:r});t._taskFinished(s);if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}});}else{this._runTask(s);}return true;}return false;};D.prototype._taskFinished=function(s){var i=this._sourcesBeingProcessed.indexOf(s);if(i>=0){this._sourcesBeingProcessed.splice(i,1);}return this;};D.prototype._queueIsEmpty=function(){return this._sourcesToProcess.length===0&&this._sourcesBeingProcessed.length===0;};D.prototype._runTask=function(s,a){var t=this;if(typeof s==="string"){var x=new(typeof sinon==="object"&&sinon.xhr&&sinon.xhr.XMLHttpRequest||XMLHttpRequest);x.onerror=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemFailed({source:s,status:x.status,statusText:x.statusText});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};x.onload=function(e){t._taskFinished(s);t._pickAndDispatchTask();if(x.status===200||x.status===0){t.fireItemSucceeded({source:s,response:x.response});}else{t.fireItemFailed({source:s,status:x.status,statusText:x.statusText});}if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};x.onprogress=function(e){t.fireItemProgress({source:s,loaded:e.loaded,total:e.total});};x.open("GET",s,true);x.responseType="arraybuffer";if(a){x.setRequestHeader("Authorization",a);}x.send(null);}else if(s instanceof File){var f=new FileReader();f.onload=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemSucceeded({source:s,response:f.result});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};f.onerror=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemFailed({source:s,status:f.error.name,statusText:f.error.message});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};f.onprogress=function(e){t.fireItemProgress({source:s.name,loaded:e.loaded,total:e.total});};f.readAsArrayBuffer(s);}else{q.sap.log.error(g().getText(M.VIT5.summary),M.VIT5.code,"sap.ui.vk.DownloadManager");}return this;};D.prototype._asyncFireAllItemsCompleted=function(){q.sap.delayedCall(0,this,this.fireAllItemsCompleted);};D.prototype.attachItemSucceeded=function(d,f,l){return this.attachEvent("itemSucceeded",d,f,l);};D.prototype.detachItemSucceeded=function(f,l){return this.detachEvent("itemSucceeded",f,l);};D.prototype.fireItemSucceeded=function(p,a,e){return this.fireEvent("itemSucceeded",p,a,e);};D.prototype.attachItemFailed=function(d,f,l){return this.attachEvent("itemFailed",d,f,l);};D.prototype.detachItemFailed=function(f,l){return this.detachEvent("itemFailed",f,l);};D.prototype.fireItemFailed=function(p,a,e){return this.fireEvent("itemFailed",p,a,e);};D.prototype.attachAllItemsCompleted=function(d,f,l){return this.attachEvent("allItemsCompleted",d,f,l);};D.prototype.detachAllItemsCompleted=function(f,l){return this.detachEvent("allItemsCompleted",f,l);};D.prototype.fireAllItemsCompleted=function(p,a,e){return this.fireEvent("allItemsCompleted",p,a,e);};D.prototype.attachItemProgress=function(d,f,l){return this.attachEvent("itemProgress",d,f,l);};D.prototype.detachItemProgress=function(f,l){return this.detachEvent("itemProgress",f,l);};D.prototype.fireItemProgress=function(p,a,e){return this.fireEvent("itemProgress",p,a,e);};return D;});
