/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./Messages","./ContentManager","./getResourceBundle"],function(q,M,C,g){"use strict";var I=C.extend("sap.ui.vk.ImageContentManager",{metadata:{library:"sap.ui.vk"}});var b=I.getMetadata().getParent().getClass().prototype;I.prototype.init=function(){if(b.init){b.init.call(this);}this._handleLoadSucceededProxy=this._handleLoadSucceeded.bind(this);this._handleLoadFailedProxy=this._handleLoadFailed.bind(this);};I.prototype.exit=function(){if(b.exit){b.exit.call(this);}};I.prototype.loadContent=function(c,a){if(a.length!==1){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_ONLY_LOAD_SINGLE_IMAGE")}});});}else if(a[0].getContentResources().length>0){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_CANNOT_LOAD_IMAGE_HIERARCHY")}});});}else{var d=a[0],s=d.getSource(),e=d.getSourceType();if(s instanceof File){var f=new FileReader();f.onload=function(h){this._loadImageFromUrl(c,f.result,e);}.bind(this);f.readAsDataURL(s);}else{var t=new sap.m.Image({src:s});s=t.getSrc();t.destroy();this._loadImageFromUrl(c,s,e);}}};I.prototype._addEventListeners=function(h){h.addEventListener("load",this._handleLoadSucceededProxy);h.addEventListener("error",this._handleLoadFailedProxy);};I.prototype._removeEventListeners=function(h){h.removeEventListener("error",this._handleLoadFailedProxy);h.removeEventListener("load",this._handleLoadSucceededProxy);};I.prototype._addSvgQuirks=function(h){h.style.setProperty("visibility","collapse");h.style.setProperty("width","0");h.style.setProperty("height","0");h.style.setProperty("position","absolute");document.body.appendChild(h);return this;};I.prototype._removeSvgQuirks=function(h){h.parentElement.removeChild(h);h.style.removeProperty("visibility");h.style.removeProperty("width");h.style.removeProperty("height");h.style.removeProperty("position");return this;};I.prototype._loadImageFromUrl=function(c,u,s){this.fireContentChangesStarted();switch(s.toLowerCase()){case"svg":var a=document.createElement("object");this._addEventListeners(a);a.type="image/svg+xml";a.data=u;a.className="SVGImage";this._addSvgQuirks(a);break;case"jpg":case"jpeg":case"png":case"gif":case"bmp":case"tif":case"tiff":var i=document.createElement("img");this._addEventListeners(i);i.src=u;break;default:q.sap.delayedCall(0,this,function(){this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_UNSUPPORTED_IMAGE_TYPE"),sourcesFailedToDownload:[{source:u}]}});});break;}};I.prototype._handleLoadSucceeded=function(e){var c=e.target;this._removeEventListeners(c);if(c instanceof HTMLObjectElement){this._removeSvgQuirks(c);}this.fireContentChangesFinished({content:c});};I.prototype._handleLoadFailed=function(e){var c=e.target;this._removeEventListeners(c);if(c instanceof HTMLObjectElement){this._removeSvgQuirks(c);}this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_IMAGE_LOAD_FAILED"),sourcesFailedToDownload:[{source:c instanceof HTMLImageElement?c.src:c.data}]}});};return I;});
