/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/m/library","./ListPanelRenderer"],function(v,C,m,L){"use strict";var a=C.extend("sap.ui.vk.ListPanel",{metadata:{library:"sap.ui.vk",properties:{"headerText":{type:"string",group:"Misc"},"headerIcon":{type:"sap.ui.core.URI",group:"Misc"},"expanded":{type:"boolean",group:"Misc",defaultValue:true},"expandAnimation":{type:"boolean",group:"Misc",defaultValue:true},"selectionMode":{type:"sap.m.ListMode",group:"Misc",defaultValue:sap.m.ListMode.MultiSelect}},aggregations:{"items":{type:"sap.m.ListItemBase",multiple:true,singularName:"item"},"panel":{type:"sap.m.Panel",multiple:false,visibility:"hidden"}},events:{headerIconPress:{},expand:{},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}}}}});a.prototype.getSelectedItem=function(){return this._oList.getSelectedItem();};a.prototype.setSelectedItem=function(l,s,f){this._oList.setSelectedItem(l,s,f);};a.prototype.getSelectedItems=function(){return this._oList.getSelectedItems();};a.prototype.init=function(){this._oList=new sap.m.ListBase({mode:this.getSelectionMode(),itemPress:this.fireItemPress.bind(this),selectionChange:this.fireSelectionChange.bind(this)});this._oPanel=new sap.m.Panel({expandable:true,expanded:true,expandAnimation:true,headerToolbar:new sap.m.Toolbar({active:false}),content:[this._oList],expand:this.fireExpand.bind(this)});this._oPanel.getHeaderToolbar().addStyleClass("sapUiVkLPTb");this.setAggregation("panel",this._oPanel,true);this._oHeaderIcon=null;this._oHeaderText=null;this._bHeaderToolbarChanged=true;};a.prototype.exit=function(){this._destroyControl(this._oList);this._destroyControl(this._oPanel);this._destroyControl(this._oHeaderIcon);this._destroyControl(this._oHeaderText);};a.prototype.getItems=function(){return this._oList.getItems();};a.prototype.addItem=function(o){return this._oList.addItem(o);};a.prototype.insertItem=function(o,i){return this._oList.insertItem(o,i);};a.prototype.removeItem=function(o){return this._oList.removeItem(o);};a.prototype.removeAllItems=function(){return this._oList.removeAllItems();};a.prototype.setHeaderText=function(b){if(!this._oHeaderText){this._oHeaderText=new sap.m.Title();}this._oHeaderText.setText(b);this._bHeaderToolbarChanged=true;if(this._oHeaderIcon){this._oHeaderIcon.setTooltip(b);this._oHeaderIcon.addAriaLabelledBy(this._oHeaderText);this._oHeaderIcon.addAriaDescribedBy(this._oHeaderText);}return this.setProperty("headerText",b);};a.prototype.getExpanded=function(){return this._oPanel.getExpanded();};a.prototype.setExpanded=function(b){return this._oPanel.setExpanded(b);};a.prototype.getExpandAnimation=function(){return this._oPanel.getExpandAnimation();};a.prototype.setExpandAnimation=function(b){return this._oPanel.setExpandAnimation(b);};a.prototype.setHeaderIcon=function(b){if(!this._oHeaderIcon){this._oHeaderIcon=new sap.m.Button({press:this.fireHeaderIconPress.bind(this),type:sap.m.ButtonType.Transparent,tooltip:this.getHeaderText()});}this._oHeaderIcon.setIcon(b);this._bHeaderToolbarChanged=true;if(this._oHeaderText){this._oHeaderIcon.addAriaLabelledBy(this._oHeaderText);this._oHeaderIcon.addAriaDescribedBy(this._oHeaderText);}return this.setProperty("headerIcon",b);};a.prototype.setSelectionMode=function(b){this._oList.setMode(b);return this.setProperty("selectionMode",b);};a.prototype.onBeforeRendering=function(){if(this._bHeaderToolbarChanged){var t=this._oPanel.getHeaderToolbar();t.removeAllContent();if(this._oHeaderIcon){t.addContent(this._oHeaderIcon);}if(this._oHeaderText){t.addContent(this._oHeaderText);}this._bHeaderToolbarChanged=false;}};a.prototype._destroyControl=function(c){if(c){c.destroy();c=undefined;}};return a;});
