/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/base/EventProvider"],function(E){"use strict";var L=E.extend("sap.ui.vk.Loco",{metadata:{publicMethods:["addHandler","removeHandler"]},constructor:function(v){if(L._instance&&this.viewport===v){return L._instance;}E.apply(this);this._handlers=[];this._gesture=false;this._n=0;this._touchStart=0;this._touchOrigin={x:0,y:0};this._touchMoved=false;this._clickTimer=0;if(v){this.attachViewportEventHandlers(v);}L._instance=this;}});L.prototype.destroy=function(){};function e(a){var p=[];var b={points:p,buttons:a.buttons||0,handled:false,event:a,timeStamp:a.timeStamp,scroll:a.wheelDelta};if(a.touches&&a.touches.length>0){for(var i=0;i<a.touches.length;i++){var t=a.touches[i];p.push({x:t.pageX,y:t.pageY});}}else if(a.pageX!==undefined){p.push({x:a.pageX,y:a.pageY});}else{p.push({x:a.originalEvent.pageX,y:a.originalEvent.pageY});}if((a.buttons&2)&&p.length===1){p.push(p[0]);}b.n=p.length;if(b.n===2){var d=p[0].x-p[1].x,c=p[0].y-p[1].y;b.x=(p[0].x+p[1].x)*0.5;b.y=(p[0].y+p[1].y)*0.5;b.d=Math.sqrt(d*d+c*c);}else{b.x=p[0].x;b.y=p[0].y;b.d=0;}return b;}L.prototype.attachViewportEventHandlers=function(v){this.viewport=v;v.ontouchstart=function(a){if(!a.isMarked()){var i=e(a);if(this._gesture){this._endGesture(i);i.handled=false;}this._beginGesture(i);}}.bind(this);v.ontouchend=function(a){var i=e(a);this._endGesture(i);if(a.touches.length>0){i.handled=false;this._beginGesture(i);}}.bind(this);if(sap.ui.Device.support.touch){v.attachBrowserEvent("touchmove",function(a){this._move(e(a));}.bind(this));}v.attachBrowserEvent("mousemove",function(a){this._move(e(a));}.bind(this));v.ontap=function(a){if(!a.isMarked()&&!this._touchMoved){if(this._clickTimer>0){clearTimeout(this._clickTimer);this._click(e(a),true);}else{this._clickTimer=setTimeout(function(l){l._click(e(a),false);},250,this);}}}.bind(this);v.attachBrowserEvent(sap.ui.Device.browser.firefox?"DOMMouseScroll":"mousewheel",function(a){if(!a.isMarked()){var o=a.originalEvent;var i={x:o.pageX,y:o.pageY,d:0,buttons:a.buttons,scroll:o.detail?o.detail*(-40):o.wheelDelta,n:2,points:[{x:o.pageX,y:o.pageY},{x:o.pageX,y:o.pageY}],handled:false};this._beginGesture(i);i.points[0].y-=i.scroll*0.2;i.points[1].y+=i.scroll*0.2;i.d=Math.abs(i.scroll)*0.4;i.handled=false;this._move(i);i.handled=false;this._endGesture(i);if(i.handled){a.setMarked();a.preventDefault();}}},this);v.oncontextmenu=function(a){var i=e(a);this._contextMenu(i);}.bind(this);v.attachBrowserEvent("keyup",function(a){this._keyEventHandler(a);},this);};L.prototype.addHandler=function(h,p){if(!this.viewport){this.attachViewportEventHandlers(h.getViewport());}h.priority=p|0;if(this._handlers.indexOf(h)===-1){this._handlers.push(h);}this._handlers.sort(function(a,b){return a.priority-b.priority;});};L.prototype.removeHandler=function(h){var i=this._handlers.indexOf(h);if(i>=0){this._handlers.splice(i,1);}};L.prototype._handleInput=function(h,a){for(var i=this._handlers.length-1;i>=0&&!a.handled;i--){if(this._handlers[i][h]){this._handlers[i][h](a);}}if(a.handled&&a.event){a.event.preventDefault();}};L.prototype._beginGesture=function(i){this._handleInput("beginGesture",i);this._touchStart=i.timeStamp;this._touchMoved=false;this._gesture=true;this._touchOrigin.x=i.x;this._touchOrigin.y=i.y;this._n=i.n;};L.prototype._move=function(i){if(this._gesture&&this._n===i.n){if(!this._touchMoved){this._touchMoved=(i.timeStamp-this._touchStart>200)&&(Math.abs(this._touchOrigin.x-i.x)>3||Math.abs(this._touchOrigin.y-i.y)>3);}this._handleInput("move",i);}else{this._handleInput("hover",i);}};L.prototype._endGesture=function(i){if(!this._gesture){return;}this._handleInput("endGesture",i);this._gesture=false;};L.prototype._click=function(i,a){this._clickTimer=0;this._handleInput(a?"doubleClick":"click",i);};L.prototype._contextMenu=function(i){this._handleInput("contextMenu",i);};L.prototype._keyEventHandler=function(a){this._handleInput("keyEventHandler",a);};return L;});
