/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/vbm/library","sap/ui/vbm/lib/sapvbi","./Messages","./OverlayRenderer","./getResourceBundle","./OverlayArea"],function(q,v,C,a,b,M,O,g,c){"use strict";var d=C.extend("sap.ui.vk.Overlay",{metadata:{library:"sap.ui.vk",properties:{zoomOnResize:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{areas:{type:"sap.ui.vk.OverlayArea",multiple:true,singularName:"area"}},associations:{target:{type:"sap.ui.core.Control",cardinality:"0..1"}},events:{click:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pos:{type:"string"}}},contextMenu:{parameters:{pos:{type:"string"},menu:{type:"sap.ui.unified.Menu"}}}}}});d.prototype.getPositionInteractive=function(p,e){if(!this.mIACreateCB&&e&&typeof(e)==="function"){this.mIACreateCB=e;var t="POS";if(p){t+="ARRAY";}var l={"SAPVB":{"Automation":{"Call":{"handler":"OBJECTCREATIONHANDLER","name":"CreateObject","object":"MainScene","scene":"MainScene","instance":"","Param":{"name":"data","#":"{"+t+"}"}}}}};this._load(l);return true;}else{return false;}};d.prototype.openContextMenu=function(m){this._openContextMenu("Overlay",this,m);};d.prototype.setPanAndZoom=function(n,e,z){if(n===0&&e===0&&z===1){return;}var s=this.mVBIContext.GetMainScene();this.totalCenterOffset.dx+=n;this.totalCenterOffset.dy+=e;if(z===1){s.MoveMap(n,e);}else{var f=s.m_Canvas[0];var h=f.m_nExactLOD+Math.log(z)*Math.LOG2E;s.ZoomToGeoPosition(VBI.MathLib.DegToRad([0.5,0.5]),h);s.MoveMap(this.totalCenterOffset.dx,this.totalCenterOffset.dy);}};d.prototype.reset=function(){this.totalCenterOffset.dx=this.totalCenterOffset.dy=0;var s=this.mVBIContext.GetMainScene();if(s){s.ZoomToGeoPosition(VBI.MathLib.DegToRad([0.5,0.5]),this.initialZoom);}return this;};d.prototype.init=function(){this.aLoadQueue=null;this.oTargetDomRef=null;this.mVBIContext=new VBI.VBIContext(this);this.resizeID="";this.resizeIDTarget="";this.bVosDirty=true;this.bWindowsDirty=true;this.bSceneDirty=true;this.bDataDeltaUpdate=false;this.bHandleDataChangeActive=false;this.bForceDataUpdate=false;this.mAddMenuItems=[];this.totalCenterOffset={dx:0,dy:0};this.initialZoom=10;};d.prototype.exit=function(){if(this.mVBIContext){this.mVBIContext.clear();}if(this.resizeID!=""){sap.ui.core.ResizeHandler.deregister(this.resizeID);this.resizeID="";}if(this.resizeIDTarget!=""){sap.ui.core.ResizeHandler.deregister(this.resizeIDTarget);this.resizeIDTarget="";}};d.prototype.resize=function(e){var f=(this.oControl!=undefined)?this.oControl:this;var h=f.mVBIContext;if(h){var s=h.GetMainScene();if(s){if(f.getZoomOnResize()&&e&&e.oldSize.width>0){var z=Math.log(e.size.width/e.oldSize.width)*Math.LOG2E;s.ZoomToGeoPosition(s.GetCenterPos(),s.GetCurrentZoomlevel()+z,false,true,true);}s.resizeCanvas(e,true,true);}}};d.prototype.setTarget=function(t){if(!t){return;}this.setAssociation("target",t);this.reset();if(t instanceof sap.m.Image){t.addDelegate({onAfterRendering:function(e){this.oTargetDomRef=t.getDomRef();this.oTargetDomRef.addEventListener("load",q.proxy(this._adaptSizeOfTarget,this));}.bind(this)});}else{t.addDelegate({onAfterRendering:function(e){this.oTargetDomRef=t.getDomRef();this._adaptSizeOfTarget();}.bind(this)});}if(this.resizeIDTarget!=""){sap.ui.core.ResizeHandler.deregister(this.resizeIDTarget);this.resizeIDTarget="";}this.resizeIDTarget=sap.ui.core.ResizeHandler.register(t,this._adaptSizeOfTarget.bind(this));};d.prototype._adaptSizeOfTarget=function(){var t=this.oTargetDomRef;var f=this.getDomRef();if(t){try{var T=q(t);var p={top:T.offset().top,left:T.offset().left,width:T.outerWidth(),height:T.outerHeight()};q(f).width(p.width).height(p.height).css("position","absolute");q(f).css("top","0px").css("left","0px").css("visibility","");}catch(e){q.sap.log.error(e);}}else{q(f).css("position","fixed").width("0px").height("0px").css("top","0px").css("left","0px").css("visibility","hidden");}};d.prototype.onAfterRendering=function(){if(this.$oldContent.length>0){this.$().append(this.$oldContent);}this._adaptSizeOfTarget();if(this.aLoadQueue){var n;for(n=0;n<this.aLoadQueue.length;++n){this._load(this.aLoadQueue[n]);}this.aLoadQueue=null;}if(this.resizeID==""){this.resize();this.resizeID=sap.ui.core.ResizeHandler.register(this,this.resize);}var o=this.getId();if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.Awake(o);}};d.prototype.onBeforeRendering=function(){this.$oldContent=sap.ui.core.RenderManager.findPreservedContent(this.getId());};d.prototype.invalidate=function(s){this.bSceneDirty=true;if(s instanceof c){this.bVosDirty=true;this.bDataDeltaUpdate=this.bHandleDataChangeActive;}sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};d.prototype._load=function(e){if(!this.isRendered()){if(!this.aLoadQueue){this.aLoadQueue=[];}this.aLoadQueue.push(e);return;}this._loadHtml(e);};d.prototype._loadHtml=function(e){var o=this.getId();var f=null;if(typeof e=="string"){f=JSON.parse(e.indexOf("{")?e.substr(e.indexOf("{")):e);}else if(typeof e=="object"){f=e;}if(!f){return;}if(!f["SAPVB"]){var m;if(this.mVBIContext&&(m=(new VBI.Adaptor(this.mVBIContext)).CreateLoadData(f))){this.loadHtml(m);return;}else{return;}}var h=false;var i=false;var j=false;if(q.type(f)=="object"){if(f.SAPVB){if(f.SAPVB.Config){this.mVBIContext.GetConfig().load(f.SAPVB.Config,this.mVBIContext);}if(f.SAPVB.Resources){this.mVBIContext.GetResources().load(f.SAPVB.Resources,this.mVBIContext);}if(f.SAPVB.DataTypes){if(!this.mVBIContext["m_DataTypeProvider"]){this.mVBIContext["m_DataTypeProvider"]=new VBI.DataTypeProvider();}this.mVBIContext["m_DataTypeProvider"].load(f.SAPVB.DataTypes,this.mVBIContext);}if(f.SAPVB.Data){if(!this.mVBIContext["m_DataProvider"]){this.mVBIContext["m_DataProvider"]=new VBI.DataProvider();}this.mVBIContext["m_DataProvider"].load(f.SAPVB.Data,this.mVBIContext);h=true;}if(f.SAPVB.Windows){if(!this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"]=new VBI.Windows();}this.mVBIContext["m_Windows"].load(f.SAPVB.Windows,this.mVBIContext);j=true;}if(f.SAPVB.Actions){if(!this.mVBIContext["m_Actions"]){this.mVBIContext["m_Actions"]=new VBI.Actions();}this.mVBIContext["m_Actions"].load(f.SAPVB.Actions,this.mVBIContext);}if(f.SAPVB.Automation){if(!this.mVBIContext["m_Automations"]){this.mVBIContext["m_Automations"]=new VBI.Automations();}this.mVBIContext["m_Automations"].load(f.SAPVB.Automation,this.mVBIContext);}if(f.SAPVB.Menus){if(!this.mVBIContext["m_Menus"]){this.mVBIContext["m_Menus"]=new VBI.Menus();}this.mVBIContext["m_Menus"].load(f.SAPVB.Menus,this.mVBIContext);}if(f.SAPVB.Scenes){if(!this.mVBIContext["m_SceneManager"]){this.mVBIContext["m_SceneManager"]=new VBI.SceneManager();}this.mVBIContext["m_SceneManager"].load(f.SAPVB.Scenes,this.mVBIContext);i=true;}}if(h){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].NotifyDataChange();}}if(i||j){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].Awake(o);}}if(i||h){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].RenderAsync();}}}};d.prototype._openContextMenu=function(t,i,m){if(m&&m.vbi_data&&m.vbi_data.VBIName=="DynContextMenu"){if(!this.mVBIContext["m_Menus"]){this.mVBIContext["m_Menus"]=new window.VBI.Menus();}for(var n=0;n<this.mAddMenuItems.length;++n){m.addItem(this.mAddMenuItems[n]);}this.mVBIContext.m_Menus.m_menus.push(m);this._loadHtml({"SAPVB":{"version":"2.0","Automation":{"Call":{"earliest":"0","handler":"CONTEXTMENUHANDLER","instance":i.sId,"name":"SHOW","object":t,"refID":"CTM","Param":[{"name":"x","#":i.mClickPos[0]},{"name":"y","#":i.mClickPos[1]},{"name":"scene","#":"MainScene"}]}}}});}this.mAddMenuItems=[];};d.prototype._update=function(){var A={SAPVB:{}};if(this.bSceneDirty){this._updateScene(A);}this._updateWindows(A);if(A.SAPVB.Actions){Array.prototype.push.apply(A.SAPVB.Actions.Set.Action,this._getActionArray());}return this._minimizeApp(A);};d.prototype._minimizeApp=function(A){var t,s;var e;s=null;if(!this.bWindowsDirty){e=(t=A)&&(t=t.SAPVB)&&(t=t.Windows)&&(s=JSON.stringify(t))&&(s==this.mCurWindows)&&(delete A.SAPVB.Windows);if(!e){this.mCurWindows=s?s:this.mCurWindows;}}else{this.bWindowsDirty=false;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Scenes)&&(s=JSON.stringify(t))&&(s==this.mCurScenes)&&(delete A.SAPVB.Scenes);if(!e){this.mCurScenes=s?s:this.mCurScenes;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Actions)&&(s=JSON.stringify(t))&&(s==this.mCurActions)&&(delete A.SAPVB.Actions);if(!e){this.mCurActions=s?s:this.mCurActions;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.DataTypes)&&(s=JSON.stringify(t))&&(s==this.mCurDataTypes)&&(delete A.SAPVB.DataTypes);if(!e){this.mCurDataTypes=s?s:this.mCurDataTypes;}if(!this.bForceDataUpdate){s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Data)&&(s=JSON.stringify(t))&&(s==this.mCurData)&&(delete A.SAPVB.Data);if(!e){this.mCurData=s?s:this.mCurData;}}else{this.bForceDataUpdate=false;}return A;};d.prototype._updateWindows=function(A){A.SAPVB.Windows={"Set":[{"name":"Main","Window":{"id":"Main","caption":"MainWindow","type":"geo","refParent":"","refScene":"MainScene","modal":"true"}}]};};d.prototype._updateScene=function(A){var s=[];var e=[];var f=[];var h=[];this._updateVOData(s,e,f,h);var _=JSON.stringify(s);var m=true;if(!this.saVO){((((A.SAPVB.Scenes={}).Set={}).SceneGeo={id:"MainScene",scaleVisible:"false",navControlVisible:"false",VisualFrame:{minLOD:5},NavigationDisablement:{move:"true",zoom:"true"},initialZoom:this.initialZoom.toString(),initialStartPosition:"0.5;0.5;0"}).VO=s);}else if(this.bRefMapLayerStackDirty||!(this.saVO===_)){(A.SAPVB.Scenes=this._getSceneVOdelta(JSON.parse(this.m_saVO),s));}else{m=false;}this.saVO=_;if(this.bDataDeltaUpdate){A.SAPVB.Data=[];for(var n=0;n<e.length;++n){A.SAPVB.Data.push({Set:{name:e[n].name,type:"N",N:e[n]}});}}else{((A.SAPVB.Data={}).Set={}).N=e;}if(m){(((A.SAPVB.DataTypes={}).Set={}).N=f);}(((A.SAPVB.Actions={}).Set={}).Action=h);this.bSceneDirty=this.bVosDirty=this.bDataDeltaUpdate=false;};d.prototype._isEventRegistered=function(A,e){var f=this.getAggregation(A);if(!f){return false;}for(var n=0;n<f.length;++n){var i=f[n];if(i.hasListeners(e)){return true;}}return false;};d.prototype._getTemplateBindingInfo=function(A){var B=this.getBindingInfo(A);if(B&&B.template){return B.template.mBindingInfos;}};d.prototype._getBindInfo=function(A){var B={};var t=this._getTemplateBindingInfo(A);B.C=(t)?t.hasOwnProperty("color"):true;B.CB=(t)?t.hasOwnProperty("colorBorder"):true;B.DCH=(t)?t.hasOwnProperty("deltaColorHot"):true;B.CS=(t)?t.hasOwnProperty("colorSelect"):true;B.CNS=(t)?t.hasOwnProperty("colorNonSelect"):true;B.TT=(t)?t.hasOwnProperty("tooltip"):true;B.M=(t)?t.hasOwnProperty("changeable"):true;B.hasTemplate=(t)?true:false;return B;};d.prototype._updateVOData=function(s,e,f,h){var B,V;this.AreaBindInfo=B=(this.AreaBindInfo)?this.AreaBindInfo:this._getBindInfo("areas");V=(B.hasTemplate)?this.getBindingInfo("areas").template:null;var o={id:"OverlayArea",datasource:"OverlayArea",type:"{00100000-2012-0004-B001-F311DE491C77}"};o["posarray.bind"]=o.id+".P";if(B.C){o["color.bind"]=o.id+".C";}else{o.color=V.getColor();}if(B.CB){o["colorBorder.bind"]=o.id+".C";}else{o.colorBorder=V.getColorBorder();}if(B.DCH){o["hotDeltaColor.bind"]=o.id+".DCH";}else{o.hotDeltaColor=V.getDeltaColorHot();}if(B.CS){o["colorSelect.bind"]=o.id+".C";}else{o.colorSelect=V.getColorSelect();}if(B.CNS){o["colorNonSelect.bind"]=o.id+".C";}else{o.colorNonSelect=V.getColorNonSelect();}if(!B.M){o["VB:c"]=V.getChangeable();}s.push(o);var i={name:o.id,key:"K"};i.A=[{"name":"K","alias":"K","type":"string"},{"name":"VB:s","alias":"VB:s","type":"boolean"},{"name":"P","alias":"P","type":"vectorarray","changeable":"true"}];if(B.C){i.A.push({"name":"C","alias":"C","type":"color"});}if(B.CB){i.A.push({"name":"CB","alias":"CB","type":"string"});}if(B.DCH){i.A.push({"name":"DCH","alias":"DCH","type":"string"});}if(B.CS){i.A.push({"name":"CS","alias":"CS","type":"string"});}if(B.CNS){i.A.push({"name":"CNS","alias":"CNS","type":"string"});}if(B.TT){i.A.push({"name":"TT","alias":"TT","type":"string"});}f.push(i);var j=o.id;if(this._isEventRegistered("areas","click")){h.push({"id":j+"1","name":"click","refScene":"MainScene","refVO":j,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this._isEventRegistered("areas","contextMenu")){h.push({"id":j+"2","name":"contextMenu","refScene":"MainScene","refVO":j,"refEvent":"ContextMenu"});}if(this._isEventRegistered("areas","edgeClick")){h.push({"id":j+"7","name":"edgeClick","refScene":"MainScene","refVO":j,"refEvent":"EdgeClick"});}h.push({"id":j+"4","name":"handleMoved","refScene":"MainScene","refVO":j,"refEvent":"HandleMoved"});h.push({"id":j+"5","name":"handleContextMenu","refScene":"MainScene","refVO":j,"refEvent":"HandleContextMenu"});h.push({"id":j+"8","name":"edgeContextMenu","refScene":"MainScene","refVO":j,"refEvent":"EdgeContextMenu"});if(this._isEventRegistered("areas","handleClick")){h.push({"id":j+"6","name":"handleClick","refScene":"MainScene","refVO":j,"refEvent":"HandleClick"});}var k={name:o.id,E:[]};var l=this.getAreas();for(var n=0;n<l.length;++n){k.E.push(l[n].getDataElement());}e.push(k);};d.prototype._getSceneVOdelta=function(o,n){var V=[];var r=[];var e={};for(var f=0,l=o.length;f<l;++f){e[o[f].id]=o[f];}for(var h=0;h<n.length;++h){if(e[n[h].id]){if(JSON.stringify(n[h])!=JSON.stringify(e[n[h].id])){r.push({"id":n[h].id,"type":"VO"});V.push(n[h]);}}else{V.push(n[h]);}delete e[n[h].id];}for(var i in e){r.push({"id":i,"type":"VO"});}var j={"Merge":{"name":"MainScene","type":"SceneGeo","SceneGeo":{"id":"MainScene"}}};if(r.length){j.Merge.SceneGeo.Remove=r;}if(V.length){j.Merge.SceneGeo.VO=V;}return j;};d.prototype._getActionArray=function(){var A=[];if(this.mEventRegistry["click"]){A.push({"id":"Overlay1","name":"click","refScene":"MainScene","refVO":"Map","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]){A.push({"id":"Overlay2","name":"contextMenu","refScene":"MainScene","refVO":"Map","refEvent":"ContextMenu","AddActionProperty":[{"name":"pos"}]});}A.push({"id":"Overlay3","name":"GetPosComplete","refScene":"MainScene","refVO":"General","refEvent":"CreateComplete"});return A;};d.prototype._handleChangedData=function(n){try{this.bHandleDataChangeActive=true;if(n&&n.length){for(var e=0,N;e<n.length;++e){N=n[e];if(N.E&&N.E.length){for(var f=0,E,i;f<N.E.length;++f){E=N.E[f];i=this._findInstance(E.K);if(i){i.handleChangedData(E);}}}}}this.bHandleDataChangeActive=false;}catch(h){this.bHandleDataChangeActive=false;throw h;}};d.prototype._findInstance=function(i){var I=(i.indexOf(".")!==-1)?i.split(".")[1]:i;var A=this.getAreas();for(var n=0;n<A.length;++n){var e=A[n];if(e.getId()===I){return e;}}return null;};d.prototype._handleAggregationEvent=function(e){var E;if((E=this._findInstance(e.Action.instance))){try{E.handleEvent(e);}catch(f){q.sap.log.error(g().getText(M.VIT11.summary),M.VIT11.code,"sap.ui.vk.Overlay");}}};d.prototype.isRendered=function(){return this.getDomRef()?true:false;};d.prototype.fireSubmit=function(e){var f=JSON.parse(e.data);if(f.Data&&f.Data.Merge){this._handleChangedData(f.Data.Merge.N);}if(f.Action.object==="OverlayArea"){this._handleAggregationEvent(f);}else{var A=f.Action.name,h;if(A==="click"||A==="contextMenu"){h=[f.Action.Params.Param[0]["#"],f.Action.Params.Param[1]["#"]];}switch(A){case"GetPosComplete":if(this.mIACreateCB){try{this.mIACreateCB(f.Action.Params.Param[0]["#"]);this.mIACreateCB=null;}catch(i){this.mIACreateCB=null;throw i;}}break;case"click":this.fireClick({clientX:h[0],clientY:h[1],pos:f.Action.AddActionProperties.AddActionProperty[0]["#"]});break;case"contextMenu":if(this.mVBIContext.m_Menus){this.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}sap.ui.getCore().loadLibrary("sap.ui.unified");var m=new sap.ui.unified.Menu();m["vbi_data"]={};m["vbi_data"].menuRef="CTM";m["vbi_data"].VBIName="DynContextMenu";this.mClickPos=h;this.fireContextMenu({pos:f.Action.AddActionProperties.AddActionProperty[0]["#"],menu:m});break;default:break;}}};d.prototype.fireRender=function(e){};d.prototype.fireMove=function(e){};d.prototype.fireZoom=function(e){};d.prototype.fireOpenWindow=function(e){};d.prototype.fireCloseWindow=function(e){};return d;});
