/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/base/EventProvider","sap/ui/core/ResizeHandler","./NativeViewport"],function(E,R,N){"use strict";var a=E.extend("sap.ui.vk.RedlineGesturesHandler",{metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},constructor:function(r){this._redlineDesign=r;this._x=0;this._y=0;this._d=0;this._zoomFactor=1;this._gesture=false;}});a.prototype.destroy=function(){this._redlineDesign=null;this._rect=null;this._gesture=false;};a.prototype._getOffset=function(d){var r=d.getBoundingClientRect();return{x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};};a.prototype._inside=function(e,r){var b=r.getDomRef(),i=false;if(b!==null){var c=this._getOffset(b);var d={x:c.x,y:c.y,width:b.getBoundingClientRect().width,height:b.getBoundingClientRect().height};i=(e.x>=d.x&&e.x<=d.x+d.width&&e.y>=d.y&&e.y<=d.y+d.height);}return i;};a.prototype._onresize=function(e){this._gesture=false;};a.prototype.beginGesture=function(e){var v=this.getViewport();if(this._inside(e,v)){this._gesture=true;this._x=e.x;this._y=e.y;this._d=e.d;this._initd=e.d;e.handled=true;}return this;};a.prototype._pan=function(e){var v=this.getViewport(),d=e.x-this._x,b=e.y-this._y;if(d||b){this._x=e.x;this._y=e.y;var p=v.getPanningRatio();v.firePan({deltaX:d*p,deltaY:b*p});v.getRedlineElements().forEach(function(c){c.setOriginX(c.getOriginX()+v._toVirtualSpace(d));c.setOriginY(c.getOriginY()+v._toVirtualSpace(b));});this._manualRender(v);}};a.prototype._zoom=function(e){var v=this.getViewport(),z=1;var d=e.d-this._d;this._d=e.d;if(this._initd>0){z=1+d*(1/this._initd);}else if(e.n===2){if(e.points[0].y>e.points[1].y){z=Math.max(1-d*0.005,0.333);}else{z=Math.min(1+d*0.005,3);}}z=Math.min(Math.max(z,0.88),1.12);var t=v._getTargetViewport();var b=32;var c=1/8;if(t instanceof N){b=t._getZoomInLimit();c=t._getZoomOutLimit();this._zoomFactor=t._getZoomFactor();}z=Math.min(Math.max(this._zoomFactor*z,c),b)/this._zoomFactor;this._zoomFactor*=z;var o=this._getOffset(v.getDomRef());var s=1-z,p=v._toVirtualSpace(e.x-o.x,e.y-o.y);v.getRedlineElements().forEach(function(f){f.applyZoom(z);var g=f.getOriginX(),h=f.getOriginY();g+=(p.x-g)*s;h+=(p.y-h)*s;f.setOriginX(g);f.setOriginY(h);});this._manualRender(v);v.fireZoom({originX:e.x-o.x,originY:e.y-o.y,zoomFactor:z});};a.prototype.move=function(e){if(this.getViewport().getDomRef()){if(e.n===1||e.n===2){this._pan(e);}if(e.n===2&&!e.buttons){this._zoom(e);}}e.handled=true;return this;};a.prototype._manualRender=function(r){if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){r.invalidate();}else{var b=sap.ui.getCore().createRenderManager();r.getRedlineElements().forEach(function(e){e.render(b);});b.flush(r.getDomRef(),false,false);b.destroy();var x=r.$();x.html(x.html());}};a.prototype.endGesture=function(e){this._gesture=false;e.handled=true;return this;};a.prototype.contextMenu=function(e){e.handled=true;};a.prototype.getViewport=function(){return this._redlineDesign;};return a;});
