/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/base/EventProvider","sap/ui/core/ResizeHandler"],function(E,R){"use strict";var S=E.extend("sap.ui.vk.Smart2DHandler",{metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},constructor:function(v,a){this._viewport=v;this._rect=null;this._x=0;this._y=0;this._gesture=false;this._hitEndTimer=0;this._lastRender=0;this._viewport.attachEvent("resize",this,this._onresize);this._viewStateManager=a;this._previousColoring={nodeRef:null,nodeId:null,color:null};}});S.prototype.destroy=function(){this._viewport=null;this._rect=null;this._gesture=false;this._viewport.detachEvent("resize",this,this._onresize);this._viewStateManager=null;this._previousColoring=null;};S.prototype._getOffset=function(d){var r=d.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};S.prototype._inside=function(e){var v=this._viewport.getDomRef();if(v==null){return false;}var a=this._getOffset(v);this._rect={x:a.x,y:a.y,w:v.offsetWidth,h:v.offsetHeight};return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};S.prototype._onresize=function(e){this._gesture=false;this._rect=null;};S.prototype.beginGesture=function(e){if(this._inside(e)){this._gesture=true;this._x=e.x;this._y=e.y;}};S.prototype.callbackHover=function(){var n=this._viewStateManager.getNodeHierarchy();this._lastRender=Date.now();this._hitEndTimer=0;var h=this._viewport.hitTest(this._x,this._y);if(this._highlightedNodeRef!==h){if(this._highlightedNodeRef!==sap.ve.dvl.DVLID_INVALID){var t=this._highlightedNodeRef===this._previousColoring.nodeRef?this._previousColoring.color:0;this._viewport.showHotspots(this._highlightedNodeRef,true,t);}if(n.getHotspotNodeIds().indexOf(h)!==-1){var a=n.createNodeProxy(h);this._previousColoring={nodeRef:h,nodeId:h,color:a.getTintColorABGR()};n.destroyNodeProxy(a);this._viewport.showHotspots(h,true);}this._highlightedNodeRef=h;}this._viewport.renderFrame();};S.prototype.hover=function(e){if(e.n==1&&this._inside(e)){this._x=e.x-this._rect.x;this._y=e.y-this._rect.y;if(!this.getViewport().getShowAllHotspots()){var t=Date.now();if(t-this._lastRender>20){this.callbackHover();}if(this._hitEndTimer!=0){clearTimeout(this._hitEndTimer);}this._hitEndTimer=setTimeout(this.callbackHover.bind(this),20);}e.handled=true;}};S.prototype.move=function(e){if(this._gesture&&e.n==1){this._viewport.pan(e.x-this._x,e.y-this._y);this._x=e.x;this._y=e.y;e.handled=true;}};S.prototype.endGesture=function(e){this._gesture=false;};S.prototype.click=function(e){};S.prototype.doubleClick=function(e){};S.prototype.contextMenu=function(e){};S.prototype.getViewport=function(){return this._viewport;};return S;});
