/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","./library","./Messages","./DvlException","./ContentConnector","./StepNavigationRenderer","./dvl/GraphicsCoreApi","./dvl/getPointer","./dvl/getJSONObject","./dvl/Scene","./getResourceBundle"],function(q,C,v,M,D,a,S,G,g,b,c,d){"use strict";var f=C.extend("sap.ui.vk.StepNavigation",{metadata:{library:"sap.ui.vk",properties:{settings:"object",width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},showThumbnails:{type:"boolean",group:"Appearance",defaultValue:true},showToolbar:{type:"boolean",group:"Appearance",defaultValue:true},showStepInfo:{type:"boolean",group:"Appearance",defaultValue:false}},publicMethods:["setScene","playStep","pauseStep","playAllSteps","getStep","getNextStep","getPreviousStep","getProceduresAndSteps","refresh","clear"],associations:{contentConnector:{type:"sap.ui.vk.ContentConnector"}},aggregations:{procedureItemTemplate:{type:"sap.ui.core.Item",multiple:false},stepInfoPopup:{type:"sap.ui.core.Control",multiple:false},layout:{type:"sap.m.Toolbar",multiple:false},thumbnailsContainer:{type:"sap.m.ScrollContainer",multiple:false}},events:{"resize":{parameters:{oldSize:"object",size:"object"}},"stepChanged":{parameters:{clientId:"object",type:"object",stepId:"object"}}}}});f.prototype._onStepEvent=function(p){var s=this.getSettings();this.instanceSettings.currentStepId=p.stepId;switch(p.type){case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_FINISHED:s.currentStepFinished=true;s.currentStepPaused=false;s.playAllActive=false;s.isPlaying=false;this._togglePlayPause(true);break;case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_SWITCHED:case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_STARTED:s.currentStepId=p.stepId;s.currentStepFinished=false;this._highlightStep(p.stepId);if(s.currentStepPaused){this.pauseStep();}break;default:q.sap.log.error(d().getText(M.VIT12.summary),M.VIT12.code,"sap.ui.vk.StepNavigation");}this.fireStepChanged({clientId:p.clientId,type:p.type,stepId:p.stepId});};f.prototype.setScene=function(s){if(this._scene){this.oDvl.Client.detachStepEvent(this._onStepEvent,this);this.oDvl=null;}if(s){var e=s.getMetadata().getName();if(e!=="sap.ui.vk.dvl.Scene"){return;}}this._scene=s;this.instanceSettings={};if(this._scene){this.oDvl=s.getGraphicsCore().getApi(G.LegacyDvl);this.oDvl.Client.attachStepEvent(this._onStepEvent,this);}delete this._procedures;var p=this.getProcedureList();var o=this.getSettings();o.reset();p.unbindItems();p.setSelectedItem(p.getFirstItem());if(o.stepInfo.stepMessagePopup){if(!o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}o.stepInfo.stepMessagePopup.destroy();o.stepInfo.stepMessagePopup=null;this.getShowStepInfoButton().setText(d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"));}var i=this._getStepThumbnails();this.oModel.setData(i);this._togglePlayPause(true);this._refreshControl();this.refresh();};f.prototype.init=function(){this._emptyThumbnail="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";if(C.prototype.init){C.prototype.init.call(this);}if(this.getSettings()==undefined){this.setSettings(new this._settings());}this._scene=null;this.oModel=new sap.ui.model.json.JSONModel();this.setModel(this.oModel);this._layout=new sap.m.Toolbar({design:sap.m.ToolbarDesign.Solid});this.setAggregation("layout",this._layout);if(this.getShowThumbnails()){this._thumbnailsScroller=new sap.m.ScrollContainer(this.getId()+"-scroller",{width:"100%",horizontal:true,vertical:false,focusable:true});this.setAggregation("thumbnailsContainer",this._thumbnailsScroller);}this.playPreviousButton=new sap.m.Button(this.getId()+"-playPreviousButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://slim-arrow-left",tooltip:d().getText("STEP_NAV_PREVIOUSSTEPBUTTON"),press:function(e){var s=this.getSettings();var p=this.getPreviousStep(s.currentProcedureIndex);if(p){s.currentStepPaused=false;this.playStep(p.id,true,s.playAllActive);this._togglePlayPause(false);}}.bind(this)});this.playNextButton=new sap.m.Button(this.getId()+"-playNextButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://slim-arrow-right",tooltip:d().getText("STEP_NAV_NEXTSTEPBUTTON"),press:function(e){var s=this.getSettings();var n=this.getNextStep(s.currentProcedureIndex);if(n){s.currentStepPaused=false;this.playStep(n.id,true,s.playAllActive);this._togglePlayPause(false);}}.bind(this)});this.playOptionButton=new sap.m.Button(this.getId()+"-playOptionButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://media-play",tooltip:d().getText("STEP_NAV_PLAYBUTTON_PLAY"),visible:true,press:function(e){var k=this.getPlayMenuButton().getSelectedKey();var s=this.getSettings();var i=null;switch(k){case"0":if(!s.currentStepId){i=this.getNextStep(s.currentProcedureIndex);if(i){s.currentStepId=i.id;}else{return;}}s.playAllActive=false;this.playStep(s.currentStepId,!s.currentStepPaused,s.playAllActive);s.isPlaying=true;s.currentStepPaused=false;this._togglePlayPause(false);break;case"1":s.playAllActive=true;s.currentStepPaused=false;this.playAllSteps(s.currentProcedureId);s.isPlaying=true;this._togglePlayPause(false);break;case"2":if(!s.currentStepId){i=this.getNextStep(s.currentProcedureIndex);if(i){s.currentStepId=i.id;}else{return;}}s.playAllActive=true;var p=!s.currentStepPaused;s.currentStepPaused=false;this.playStep(s.currentStepId,p,s.playAllActive);s.isPlaying=true;this._togglePlayPause(false);break;default:break;}}.bind(this)});this.procedureList=new sap.m.Select(this.getId()+"-procedureList",{tooltip:d().getText("STEP_NAV_PROCEDURESLISTHEADING"),selectedKey:"0",type:sap.m.SelectType.Default,enabled:true,width:"30%",autoAdjustWidth:true,change:function(o){var p=this.getProcedureList();var s=this.getSettings();s.currentProcedureIndex=0;s.currentProcedureId=this.instanceSettings.currentProcedureId=p.getSelectedKey();s.currentStepId=this.instanceSettings.currentStepId=null;for(var i=0;i<this.oModel.oData.procedures.length;i++){if(this.oModel.oData.procedures[i].id==s.currentProcedureId){s.currentProcedureIndex=i;s.currentProcedure=this.oModel.oData.procedures[i];break;}}if(s.stepInfo.stepMessagePopup){if(!s.stepInfo.stepMessagePopup.isOpen()){s.stepInfo.stepMessagePopup.close();}s.stepInfo.stepMessagePopup.destroy();s.stepInfo.stepMessagePopup=null;}this._refreshItems();}.bind(this)});this.procedureList.addStyleClass("sapVizKitStepNavigationProcedureList");this.setAggregation("procedureItemTemplate",(new sap.ui.core.ListItem().bindProperty("text","name").bindProperty("key","id").bindProperty("tooltip","name")));this.playMenuButton=(new sap.m.Select(this.getId()+"-playMenuButtonIcon",{selectedKey:"0",type:sap.m.SelectType.Default,tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYOPTIONS"),enabled:true,autoAdjustWidth:false,items:[new sap.ui.core.ListItem({key:"0",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAY"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAY")}),new sap.ui.core.ListItem({key:"1",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAYALL"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYALL")}),new sap.ui.core.ListItem({key:"2",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAYALLREMAINING"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYALLREMAINING")})]}));this.playMenuButton.addStyleClass("sapVizKitStepNavigationPlayOptionsSelect");this.pauseButton=new sap.m.Button(this.getId()+"-pauseButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://media-pause",visible:false,tooltip:d().getText("STEP_NAV_PLAYMENU_PAUSE"),press:function(e){var s=this.getSettings();this.pauseStep();s.currentStepPaused=true;s.isPlaying=false;this._togglePlayPause(true);}.bind(this)});this.showStepInfoButton=new sap.m.ToggleButton(this.getId()+"-showStepInfoButton",{icon:"sap-icon://hide",type:sap.m.ButtonType.Transparent,pressed:false,text:d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"),tooltip:d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"),press:function(e){var t=e.getSource();if(t.getPressed()){this.setShowStepInfo(true);t.setIcon("sap-icon://show");t.setTooltip(d().getText("STEP_NAV_HIDESTEPDESCRIPTIONBUTTON"));}else{this.setShowStepInfo(false);t.setIcon("sap-icon://hide");t.setTooltip(d().getText("STEP_NAV_SHOWSTEPDESCRIPTIONBUTTON"));}}.bind(this)});this._layout.addContent(this.playPreviousButton).addContent(this.playOptionButton).addContent(this.pauseButton).addContent(this.playMenuButton).addContent(this.procedureList).addContent(this.showStepInfoButton).addContent(new sap.m.ToolbarSpacer()).addContent(this.playNextButton);};f.prototype.destroy=function(){return C.prototype.destroy.call(this);};f.prototype.getScroller=function(){return this._thumbnailsScroller;};f.prototype.getProcedureList=function(){var i=this.getId()+"-procedureList";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getPlayMenuButton=function(){var i=this.getId()+"-playMenuButtonIcon";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getPlayOptionButton=function(){var i=this.getId()+"-playOptionButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getPauseButton=function(){var i=this.getId()+"-pauseButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getPlayNextButton=function(){var i=this.getId()+"-playNextButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getPlayPreviousButton=function(){var i=this.getId()+"-playPreviousButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype.getShowStepInfoButton=function(){var i=this.getId()+"-showStepInfoButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};f.prototype._settings=function(){return{enabled:false,toggle:{addCss:function(k,p,o,e){if(!this.targets[k]){this.targets[k]={"type":"css","property":p,"onValue":o,"offValue":e};}},addMethod:function(t,m,o,e,u){var k=t.getId();if(!this.targets[k]){this.targets[k]={"type":"method","target":t,"method":m,"onValue":o,"offValue":e,"useJQuery":u};}},targets:{}},currentProcedureIndex:0,currentProcedureId:"",currentProcedure:null,currentStepId:null,currentStep:null,currentStepPaused:false,isPlaying:false,currentStepFinished:true,playAllActive:false,showToolbar:true,showThumbnails:true,portfolioMode:false,reset:function(){this.currentStep=null;this.currentProcedure=null;this.currentProcedureIndex=0;this.currentProcedureId="";this.currentStepId=null;this.currentStepPaused=false;this.currentStepFinished=true;this.playAllActive=false;this.portfolioMode=false;},stepInfo:{lastTop:null,lastLeft:null,stepMessagePopup:null,openPopup:function(p,t,e,i){this._customHeaderText=this._customHeaderText||new sap.m.Text({width:"100%",textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapVizKitStepNavigationPopoverTitle");this._customHeaderText.setText(p);this._customHeaderText.setTooltip(p);this._customHeader=this._customHeader||new sap.m.Bar({contentLeft:[this._customHeaderText]});this._textContent=this._textContent||new sap.m.Text({});this._textContent.addStyleClass("sapVizKitStepNavigationPopoverContent");this._textContent.setText(t);this.stepMessagePopup=this.stepMessagePopup||new sap.m.ResponsivePopover({placement:i,showCloseButton:true,verticalScrolling:true,contentHeight:"10%",contentWidth:"30%",content:[this._textContent],customHeader:this._customHeader});this.stepMessagePopup.addStyleClass("sapVizKitStepNavigationPopoverStepInfo");this.stepMessagePopup.openBy(e);}}};};f.prototype.refresh=function(s){q.sap.log.info("StepNavigation refresh() called.");if(this.getVisible()&&(this["_getStepThumbnails"]&&this._scene!=null)){var p=this.getProcedureList();var o=this.getSettings();o.reset();p.setSelectedItem(p.getFirstItem());var e=this._getStepThumbnails();if(o.stepInfo.stepMessagePopup){if(!o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}o.stepInfo.stepMessagePopup.destroy();o.stepInfo.stepMessagePopup=null;}this.oModel.setData(e);this._togglePlayPause(true);this._refreshControl();}else if(this.getVisible()){this._refreshControl();}return true;};f.prototype.clear=function(){q.sap.log.info("StepNavigation clear() called.");return true;};f.prototype.onBeforeRendering=function(){if(this.getShowToolbar()){var p=this.getProcedureList();p.setModel(this.oModel);var P=this.getProcedureItemTemplate();p.bindItems("/procedures",P);}};f.prototype.onAfterRendering=function(){var s=this.getSettings();this._togglePlayPause(!s.isPlaying);if(s.currentStepId){this._highlightStep(s.currentStepId);}};var h={onAfterRendering:function(e){e.srcControl.focus();e.srcControl.removeEventDelegate(this);}};f.prototype._togglePlayPause=function(p){this.togglePlayPauseActive=true;if(this.getSettings().showToolbar){var e=this.getPlayOptionButton(),i=this.getPauseButton();if(p){if(sap.ui.getCore().getCurrentFocusedControlId()===i.getId()){e.addEventDelegate(h);}i.setVisible(false);e.setVisible(true);}else{if(sap.ui.getCore().getCurrentFocusedControlId()===e.getId()){i.addEventDelegate(h);}e.setVisible(false);i.setVisible(true);}}};f.prototype._refreshControl=function(){if(!this.oModel.oData.procedures){return;}var p=this.getProcedureList();var P=this.getProcedureItemTemplate();var s=this.getSettings();if(s.stepInfo.stepMessagePopup){if(!s.stepInfo.stepMessagePopup.isOpen()){s.stepInfo.stepMessagePopup.close();}s.stepInfo.stepMessagePopup.destroy();s.stepInfo.stepMessagePopup=null;this.getShowStepInfoButton().setText(d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"));}p.unbindItems();if(this.oModel.oData.procedures.length>0){var e=this.oModel.oData.procedures[0];if(this.getShowToolbar()){p.bindItems("/procedures",P);p.selectedKey=e.id;p.enabled=true;}this._refreshItems();}else{if(this.getShowToolbar()){p.bindItems("/procedures",P);p.enabled=false;}if(this.getShowThumbnails()){var o=this.getScroller();o.destroyContent();}}};f.prototype._refreshItems=function(){var t=this;var s=[];var p=this.getProcedureList();var o=t.getSettings();var e=new sap.m.HBox();if(!o.currentProcedure){o.currentProcedure=t.oModel.oData.procedures[o.currentProcedureIndex];p.setSelectedItem(p.getFirstItem());}if(o.currentProcedureId!=""||t.oModel.oData.procedures.length>0){if(t.getShowThumbnails()){var j=t.getScroller();j.removeAllContent();s=t.oModel.oData.procedures[o.currentProcedureIndex].steps;var k=function(n){o.currentStepPaused=false;var r=sap.ui.getCore().byId(n.getSource().getId());t.playStep(r.getCustomData()[0].getValue("stepId"));o.playAllActive=false;t._togglePlayPause(false);};var l=function(n){var r=80;var m=n.getSource();var u=m.getDomRef().width;var w=m.getDomRef().height;var x=u/w;if(u>w){m.setWidth(r+"px");m.setHeight(r/x+"px");}else{m.setHeight(r+"px");m.setWidth(r*x+"px");}};for(var i=0;i<s.length;i++){var m=new sap.m.Image({alt:s[i].name,src:"data:image/"+s[i].thumbnailType+";base64,"+s[i].thumbnailData,densityAware:false,tooltip:s[i].name,press:k.bind(t),load:l,layoutData:new sap.m.FlexItemData({shrinkFactor:0})});m.data("stepId",s[i].id);m.addCustomData(new sap.ui.core.CustomData({key:"stepId",value:s[i].id}));m.addStyleClass("sapVizKitStepNavigationStepItem");e.addItem(m);}j.addContent(e);}}};f.prototype._getPopupPlacement=function(e){var p=null;var y=0;while(e){y+=e.offsetTop;e=e.offsetParent;}if(y>200){p=sap.m.PlacementType.Top;}else{p=sap.m.PlacementType.Bottom;}return p;};f.prototype._isScrollingNecessary=function(i,s){var e;if(i&&s){var j=q(i).offset().left+q(i).width();var t=q(s).width();if(j-q(i).width()<0){e=true;}else if((t-j)<q(i).width()){e=true;}else{e=false;}}else{e=false;}return e;};f.prototype._scrollToItem=function(i,s){var p={},o=q(i).offset(),e=q(s).scrollLeft();p.scrollLeft=o.left+(e-q(s).offset().left);p.scrollLeft-=parseInt(q(i).css("marginLeft"),10)||0;p.scrollLeft-=parseInt(q(i).css("borderLeftWidth"),10)||0;q(s).animate(p,50);};f.prototype._highlightStep=function(s){var t=this;if(t.getVisible()){var o=t.getSettings();var e=t.getStep(0,o.currentProcedureIndex,s);if(!o.currentProcedure){o.currentProcedure=t.oModel.oData.procedures[t.oSettings.currentProcedureIndex];}var j=t.getShowStepInfoButton();var p;var k=document.getElementById(j.getId());p=t._getPopupPlacement(k);if(t.getShowStepInfo()){o.stepInfo.openPopup.call(this,e.name,e.description,j,p);}else if(o.stepInfo.stepMessagePopup&&o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}if(t.getShowThumbnails()){var l=t.getScroller();var T=l.getContent()[0].getItems();for(var i=0;i<T.length;i++){if(T[i].getCustomData()[0].getValue("stepId")==s){T[i].addStyleClass("selected");if(t._isScrollingNecessary(T[i].$()[0],q("#"+l.sId)[0])){t._scrollToItem(T[i].$()[0],q("#"+l.sId)[0]);}}else{T[i].removeStyleClass("selected");}}}}};f.prototype.getProceduresAndSteps=function(){return this._getStepThumbnails();};f.prototype._getStepThumbnails=function(){var p=function(s,i,j){var t,k,l;try{var m=i.Scene.RetrieveThumbnail(s,j.id);if(m===sap.ve.dvl.DVLRESULT.NOTFOUND){t=this._emptyThumbnail;}else{t=g(m);}l=t.substring(0,3);if(l==="iVB"){k="png";}else{k="jpg";}j.thumbnailData=t;j.thumbnailType=k;}catch(n){if(n.code!==sap.ve.dvl.DVLRESULT.NOTFOUND){q.sap.log.error(n.message,n.code,"sap.ui.vk.StepNavigation");}j.thumbnailData=null;j.thumbnailType=null;}};var e=this._retrieveProcedures();if(e.sceneId!=null){e.procedures.forEach(function(i){i.steps.forEach(p.bind(this,e.sceneId,this.oDvl));},this);e.portfolios.forEach(function(i){i.steps.forEach(p.bind(this,e.sceneId,this.oDvl));},this);e.hasThumbnails=true;}this._procedures=e;return e;};f.prototype._retrieveProcedures=function(i){var t=this;var p={};if(!t._procedures){p={sceneId:null,hasThumbnails:false,"procedures":[],"portfolios":[]};}else{p=t._procedures;}if(t._scene&&(p.sceneId!=(i||t._scene._dvlSceneRef))){var s=i||t._scene._dvlSceneRef;if(s!=null){p={sceneId:null,hasThumbnails:false,"procedures":[],"portfolios":[]};try{var j=b(t.oDvl.Scene.RetrieveProcedures(s));if(j!=null){p.hasThumbnails=false;p.sceneId=t._scene._dvlSceneRef;p.procedures=j.procedures;p.portfolios=j.portfolios;}}catch(e){if(!(e instanceof D&&e.code===sap.ve.dvl.DVLRESULT.NOTIMPLEMENTED)){throw e;}}}}return p;};f.prototype.getStep=function(r,e,s){var t=this;var i=t.oDvl.Settings.LastLoadedSceneId;var j=null;if(i!=null){e=e!=null?e:0;var k=s?s:t.instanceSettings.currentStepId;var p=t._retrieveProcedures(i);var l=p.procedures[e];if(l&&l.steps.length>0){j=l.steps[0];}else{return null;}if(k!=""){for(var m=0;m<l.steps.length;m++){var _=l.steps[m];if(_.id==k){var x=m+r;if(x<l.steps.length&&x>=0){j=l.steps[x];}else{j=null;}break;}}}}return j;};f.prototype.pauseStep=function(){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;if(s!=null){t.oDvl.Scene.PauseCurrentStep(s);}};f.prototype._stepCount=function(e){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;var i=0;if(s!=null){var p=t._retrieveProcedures(s);for(var j=0;j<p.procedures.length;j++){if(p.procedures[j].id==e){i=p.procedures[j].steps.length;break;}else if(e==null){i+=p.procedures[j].steps.length;}}}return i;};f.prototype.getPreviousStep=function(p){var t=this;return t.getStep(-1,p);};f.prototype.getNextStep=function(p){var t=this;return t.getStep(1,p);};f.prototype.playStep=function(e,i,j){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;if(s!=null){t.instanceSettings.currentStepId=e;t.oDvl.Scene.ActivateStep(s,e,i!=null?i:true,j!=null?j:false);}};f.prototype.playAllSteps=function(p){var t=this;var e=t.oDvl.Settings.LastLoadedSceneId;if(e!=null){var i=t._retrieveProcedures(e);var j=0;if(p!=null&&i.procedures.length>1){for(var k=0;k<i.procedures.length;k++){if(i.procedures[k].id==p){j=k;break;}}}if(i.procedures.length>0){var s=i.procedures[j].steps[0];if(s){t.instanceSettings.currentStepId=s.id;t.oDvl.Scene.ActivateStep(e,s.id,true,true);}}}};f.prototype._setContent=function(e){var s=null;if(e&&e instanceof c){s=e;}this.setScene(s);};f.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};f.prototype._onBeforeClearContentConnector=function(){this.setScene(null);};f.prototype._handleContentReplaced=function(e){var i=e.getParameter("newContent");this._setContent(i);};a.injectMethodsIntoClass(f);return f;});
