/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./library","sap/ui/core/Control","./ToolbarRenderer","./getResourceBundle"],function(v,C,T,g){"use strict";var a=C.extend("sap.ui.vk.Toolbar",{metadata:{library:"sap.ui.vk",properties:{title:{type:"string",group:"Appearance",defaultValue:""}},events:{},associations:{viewer:{type:"sap.ui.vk.Viewer",cardinality:"0..1"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"content",forwardBinding:true}},_toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_helpButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_stepNavigationButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_sceneTreeButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_enterFullScreenButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_exitFullScreenButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_toolbarTitle:{type:"sap.m.Title",multiple:false,visibility:"hidden"}}}});a.prototype._getToolbar=function(){return this._toolbar;};a.prototype._onSceneTree=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){this.oViewer._componentsState.sceneTree.userInteractionShow=this._sceneTreeButton.getPressed();this.oViewer.setShowSceneTree(this.oViewer._componentsState.sceneTree.userInteractionShow);}};a.prototype._onStepNavigation=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){this.oViewer._componentsState.stepNavigation.userInteractionShow=this._stepNavigationButton.getPressed();this.oViewer.setShowStepNavigation(this.oViewer._componentsState.stepNavigation.userInteractionShow);}};a.prototype._onFullScreen=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){var n=this._enterFullScreenButton.getPressed();this.oViewer.activateFullScreenMode(n);}};a.prototype._fullScreenHandler=function(e){var f=e.mParameters.isFullScreen;this._enterFullScreenButton.setPressed(f);if(f){this._enterFullScreenButton.setIcon("sap-icon://exit-full-screen");}else{this._enterFullScreenButton.setIcon("sap-icon://full-screen");}};a.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}var _=new sap.m.Button({icon:"sap-icon://sys-help",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_HELPBUTTONTOOLTIP")});this.setAggregation("_helpButton",_);this._stepNavigationButton=new sap.m.ToggleButton({icon:"sap-icon://step",type:sap.m.ButtonType.Transparent,enabled:false,tooltip:g().getText("STEP_NAV_MENUBUTTONTOOLTIP"),press:this._onStepNavigation.bind(this)});this.setAggregation("_stepNavigationButton",this._stepNavigationButton);this._sceneTreeButton=new sap.m.ToggleButton({icon:"sap-icon://tree",type:sap.m.ButtonType.Transparent,tooltip:g().getText("SCENETREE_MENUBUTTONTOOLTIP"),press:this._onSceneTree.bind(this)});this.setAggregation("_sceneTreeButton",this._sceneTreeButton);this._toolbarTitle=new sap.m.Title();this.setAggregation("_toolbarTitle",this._toolbarTitle);this._enterFullScreenButton=new sap.m.ToggleButton({icon:"sap-icon://full-screen",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_FULLSCREENBUTTONTOOLTIP"),press:this._onFullScreen.bind(this)});this.setAggregation("_enterFullScreenButton",this._enterFullScreenButton);var b=new sap.m.Button({icon:"sap-icon://exit-full-screen",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_FULLSCREENBUTTONTOOLTIP")});this.setAggregation("_exitFullScreenButton",b);var t=t=[new sap.m.ToolbarSpacer(),this._toolbarTitle,new sap.m.ToolbarSpacer(),new sap.m.ToolbarSeparator(),this._sceneTreeButton,new sap.m.ToolbarSeparator(),this._stepNavigationButton,new sap.m.ToolbarSeparator(),this._enterFullScreenButton];this._toolbar=new sap.m.Toolbar({design:sap.m.ToolbarDesign.Solid,content:t});this.setAggregation("_toolbar",this._toolbar,true);};a.prototype.exit=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer){this.oViewer.detachFullScreen(this._fullScreenHandler.bind(this));}};a.prototype.onBeforeRendering=function(){this._toolbar.setVisible(true);this._toolbarTitle.setText(this.getTitle());};a.prototype.refresh=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());this._stepNavigationButton.setPressed(this.oViewer.getShowStepNavigation());this._stepNavigationButton.setEnabled(this.oViewer.getEnableStepNavigation());this._sceneTreeButton.setPressed(this.oViewer.getShowSceneTree());this._sceneTreeButton.setEnabled(this.oViewer.getEnableSceneTree());this.oViewer.attachFullScreen(this._fullScreenHandler.bind(this));return true;};a.prototype.onAfterRendering=function(){this.refresh();};return a;});
