/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/core/Control","./library","./ContentConnector","./AnimationTimeSlider","./ViewGalleryRenderer","./getResourceBundle","./ViewGalleryThumbnail","sap/m/HBox","sap/m/VBox","sap/m/FormattedText","sap/m/FlexItemData","sap/m/Image","sap/m/ScrollContainer","sap/m/Button","sap/m/ToggleButton","sap/m/Toolbar","sap/m/Popover","sap/m/Title","sap/m/SelectList","sap/m/ToolbarSpacer","sap/ui/model/json/JSONModel","sap/ui/core/dnd/DropInfo","sap/ui/core/dnd/DragInfo"],function(C,v,a,A,V,g,b,H,c,F,d,I,S,B,T,e,P,f,h,j,J,D,k){"use strict";var l=C.extend("sap.ui.vk.ViewGallery",{metadata:{library:"sap.ui.vk",properties:{showAnimationTimeSlider:{type:"boolean",defaultValue:true},showToolbar:{type:"boolean",defaultValue:true},showThumbnailContainer:{type:"boolean",defaultValue:true},selectedViewIndex:{type:"int",defaultValue:-1},selectedViewGroupIndex:{type:"int",defaultValue:-1},enableViewReordering:{type:"boolean",defaultValue:false}},associations:{viewport:{type:"sap.ui.vk.Viewport"},contentConnector:{type:"sap.ui.vk.ContentConnector"}},aggregations:{toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},container:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},animationTimeSlider:{type:"sap.ui.vk.AnimationTimeSlider",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{item:"sap.ui.core.Control"}},viewOrderChange:{parameters:{view:"sap.ui.vk.View",viewIndex:"int"}}}}});l.prototype.init=function(){if(C.prototype.init){C.prototype.init.call(this);}var t=this;window.addEventListener("resize",function(){t.resizeToolbarSpacer();},true);this._scene=null;this._viewItems=[];this._cdsLoader=null;this._selectedGroupIndex=-1;this._previousOrientationVertical=false;this._playingAnimation=true;this._draggedModelView={};sap.ui.core.IconPool.addIcon("landscape-text","vk-icons","vk-icons","e019");sap.ui.core.IconPool.addIcon("portrait-text","vk-icons","vk-icons","e01a");this.oModel=new J();if(this.getShowThumbnailContainer()){this.createThumbnailContainer();}if(this.getShowToolbar()){this.createToolbar();}if(this.getShowAnimationTimeSlider()){this.setAggregation("animationTimeSlider",new A());if(this.getViewport()){var i=sap.ui.getCore().byId(this.getViewport());this._linkViewportAndAnimationTimeSlider(i,this.getAnimationTimeSlider());}}};l.prototype.setVisible=function(i){if(C.prototype.setVisible){C.prototype.setVisible.call(this,i);}this.setDescription();};l.prototype.resizeToolbarSpacer=function(){if(this.getDomRef()){var i=this._nextItemButton.getDomRef().getBoundingClientRect().width;i+=this._playButton.getDomRef().getBoundingClientRect().width;i+=this._previousItemButton.getDomRef().getBoundingClientRect().width;var t=this.toolbar.getDomRef().getBoundingClientRect().width;var w=(i/t)*100;var n=50-w;this._toolbarSpacer.setWidth(n+"%");}};l.prototype.onAfterRendering=function(){this.resizeToolbarSpacer();var i=null;if(this.getViewport()){i=sap.ui.getCore().byId(this.getViewport());if(i.getContent().indexOf(this)!==-1){this.toolbar.addStyleClass("sapVizKitViewGalleryToolbar");this.adjustStepDescriptionBoxes();}}};l.prototype.setShowAnimationTimeSlider=function(i){this.setProperty("showAnimationTimeSlider",i);var n=null;if(this.getViewport()){n=sap.ui.getCore().byId(this.getViewport());}if(i){this._deLinkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());this.setAggregation("animationTimeSlider",new A());this._linkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());}else{this._deLinkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());this.destroyAggregation("animationTimeSlider");}};l.prototype.getAnimationTimeSlider=function(){return this.getAggregation("animationTimeSlider");};l.prototype.destroyToolbar=function(){this.destroyAggregation("toolbar");};l.prototype.destroyThumbnailContainer=function(){this.destroyAggregation("container");};l.prototype.createThumbnailContainer=function(){var t=this;this._hbox=new H();if(this.getEnableViewReordering()){this._hbox.addDragDropConfig(new D({dropEffect:sap.ui.core.dnd.DropEffect.Move,dropPosition:sap.ui.core.dnd.DropPosition.On,targetAggregation:"items",drop:function(E){var i=E.getParameter("droppedControl");t.reorderViews(i);t.fireViewOrderChange({view:t._draggedModelView,viewIndex:t._viewItems.indexOf(i)});}}));this._hbox.getMetadata().getAggregation().dnd.droppable=true;}this._scrollContainer=new S(this.getId()+"-scroller",{width:"100%",horizontal:true,vertical:false,focusable:true,content:[this._hbox]});this._scrollContainer.addStyleClass("sapVizKitViewGalleryScrollContainer");this.setAggregation("container",this._scrollContainer);};l.prototype.reorderViews=function(i){var n=this._modelViews.indexOf(this._draggedModelView);this._modelViews.splice(n,1);var o=this._viewItems.indexOf(i);this._modelViews.splice(o,0,this._draggedModelView);this._refreshItems();};l.prototype.createToolbar=function(){var t=this;this.toolbar=new e({design:sap.m.ToolbarDesign.Solid});this.setAggregation("toolbar",this.toolbar);this._previousItemButton=new B(this.getId()+"-previousItemButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://close-command-field",tooltip:g().getText("STEP_NAV_PREVIOUSSTEPBUTTON"),press:function(n){var i=t.getSelectedViewIndex();if(i>0){t.setSelectedItem(t._viewItems[i-1]);}}});this._nextItemButton=new B(this.getId()+"-nextItemButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://open-command-field",tooltip:g().getText("STEP_NAV_NEXTSTEPBUTTON"),press:function(n){var i=t.getSelectedViewIndex();if(i>=0&&i+1<t._viewItems.length){t.setSelectedItem(t._viewItems[i+1]);}}});this._viewGroupSelector=new P({showHeader:false,contentWidth:"20%",placement:sap.m.PlacementType.Top,horizontalScrolling:false,verticalScrolling:false,content:[new S({horizontal:false,vertical:true,content:[this._procedureList=new h({width:"100%",itemPress:function(o){t._clearUI();var i=this.indexOfItem(o.getParameter("item"));t.setSelectedViewGroupIndex(i);}})]})]});this._playButton=new T(this.getId()+"-playButton",{type:sap.m.ButtonType.Transparent,pressed:false,icon:"sap-icon://media-play",visible:true,tooltip:g().getText("STEP_NAV_PLAYMENU_PLAY"),press:function(E){this._setPlayState(E.getSource().getPressed());if(E.getSource().getPressed()){this._playProcedure();}else{this._pauseAnimation();}}.bind(this)});this._stepCount=new f({textAlign:sap.ui.core.TextAlign.Right,level:"H5",titleStyle:"H5"});this._currentGroupTitle=new f({text:g().getText("STEP_NAV_PROCEDURES"),tooltip:g().getText("STEP_NAV_PROCEDURES"),level:"H5",titleStyle:"H5"}).addStyleClass("sapVizKitViewGalleryCurrentGroupTitle");this._separatorTitle=new f({width:(5/1920)*100+"%",level:"H5",titleStyle:"H5"});this._currentStepTitle=new f({level:"H5",titleStyle:"H5"}).addStyleClass("sapVizKitViewGalleryCurrentStepTitle");this._currentGroupTitle.addEventDelegate({ontap:function(){this._viewGroupSelector.openBy(this._currentGroupTitle);}.bind(this)});this._toolbarSpacer=new j();this.toolbar.addContent(this._currentGroupTitle).addContent(this._separatorTitle).addContent(this._currentStepTitle).addContent(new j()).addContent(this._stepCount).addContent(this._toolbarSpacer).addContent(this._previousItemButton).addContent(this._playButton).addContent(this._nextItemButton);};l.prototype._setPlayState=function(i){if(this.getAggregation("toolbar")){this._playButton.setPressed(i);if(i){this._playButton.setIcon("sap-icon://media-pause");this._playButton.setTooltip(g().getText("STEP_NAV_PLAYMENU_PAUSE"));}else{this._playButton.setIcon("sap-icon://media-play");this._playButton.setTooltip(g().getText("STEP_NAV_PLAYMENU_PLAY"));}}};l.prototype._createStepDescriptionBoxes=function(){this._stepDescription=new c({renderType:sap.m.FlexRendertype.Bare,fitContainer:false,alignContent:sap.m.FlexAlignContent.Start,alignItems:sap.m.FlexAlignItems.Start,justifyContent:sap.m.FlexJustifyContent.End,items:[this._stepDescriptionToolbar=new e({design:sap.m.ToolbarDesign.Solid,content:[this._stepDescriptionIcon=new sap.ui.core.Icon({src:"sap-icon://navigation-up-arrow",press:function(i){this._toggleViewDescription();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionIcon sapVizKitViewGalleryStepDescriptionIconTransform"),new j(),this._stepDescriptionOrientationIcon=new sap.ui.core.Icon({src:"sap-icon://vk-icons/landscape-text",press:function(i){this._toggleOrientation();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionOrientationIcon")],layoutData:new d({shrinkFactor:0})}).addStyleClass("sapVizKitViewGalleryStepDescriptionToolbar"),this._stepDescriptionScroll=new S({horizontal:false,vertical:true,content:[this._stepDescriptionText=new F({visible:true}).addStyleClass("sapVizKitViewGalleryStepDescriptionText")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionScroll")]}).addStyleClass("sapVizKitViewGalleryStepDescription");this._stepDescription.vitId="VIT-StepDescription";this._stepDescriptionVertical=new H({renderType:sap.m.FlexRendertype.Bare,fitContainer:false,alignContent:sap.m.FlexAlignContent.Start,alignItems:sap.m.FlexAlignItems.Start,justifyContent:sap.m.FlexJustifyContent.End,items:[this._stepDescriptionVerticalScroll=new S({horizontal:false,vertical:true,content:[this._stepDescriptionVerticalText=new F({visible:false}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalText")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalScroll"),this._stepDescriptionVerticalToolbar=new e({design:sap.m.ToolbarDesign.Solid,content:[this._stepDescriptionVerticalIcon=new sap.ui.core.Icon({src:"sap-icon://navigation-right-arrow",press:function(i){this._toggleViewDescriptionVertical();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalIcon sapVizKitViewGalleryStepDescriptionIconTransform"),this._stepDescriptionVerticalOrientationIcon=new sap.ui.core.Icon({src:"sap-icon://vk-icons/portrait-text",press:function(i){this._toggleOrientation();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalOrientationIcon")],layoutData:new d({shrinkFactor:0})}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalToolbar")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionVertical");this._stepDescriptionVertical.vitId="VIT-StepDescriptionVertical";};l.prototype.adjustStepDescriptionBoxes=function(){if(this._stepDescription.getDomRef()){var i=this.getDomRef().getBoundingClientRect().height;var s=this._stepDescription.getDomRef().id;var n=this._stepDescriptionVertical.getDomRef().id;document.getElementById(s).style.bottom=i+"px";document.getElementById(n).style.bottom=i+"px";var o=sap.ui.getCore().byId(this.getViewport());var p=o.getDomRef().getBoundingClientRect().height;document.getElementById(n).style.height=p-i+"px";}};l.prototype._toggleOrientation=function(){if(this._stepDescriptionToolbar.getVisible()){this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(true);this._previousOrientationVertical=true;if(this._stepDescriptionText.getVisible()){this._stepDescriptionVerticalText.setVisible(true);}this._stepDescriptionText.setVisible(false);}else{this._stepDescriptionToolbar.setVisible(true);this._previousOrientationVertical=false;if(this._stepDescriptionVerticalText.getVisible()){this._stepDescriptionText.setVisible(true);}this._stepDescriptionVerticalToolbar.setVisible(false);this._stepDescriptionVerticalText.setVisible(false);}this._stepDescription.rerender();this._stepDescriptionVertical.rerender();var i=null;if(this.getViewport()){i=sap.ui.getCore().byId(this.getViewport());if(i.getContent().indexOf(this)!==-1){this.adjustStepDescriptionBoxes();}}};l.prototype._toggleViewDescription=function(){if(!this._stepDescriptionText.getVisible()){this._stepDescriptionText.setVisible(true);this._stepDescriptionIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionVerticalIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}else{this._stepDescriptionText.setVisible(false);this._stepDescriptionIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionVerticalIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}this._stepDescriptionText.rerender();};l.prototype._toggleViewDescriptionVertical=function(){if(!this._stepDescriptionVerticalText.getVisible()){this._stepDescriptionVerticalText.setVisible(true);this._stepDescriptionVerticalIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}else{this._stepDescriptionVerticalText.setVisible(false);this._stepDescriptionVerticalIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}this._stepDescriptionVerticalText.rerender();};l.prototype._getHBox=function(){return this._hbox;};l.prototype._playProcedure=function(){if(this._modelViews){var i=sap.ui.getCore().byId(this.getViewport());var s=this.getSelectedViewIndex();if(s===-1){s=0;}i.playProcedure(this._modelViews,s,!this._playingAnimation);}};l.prototype._pauseAnimation=function(){var i=sap.ui.getCore().byId(this.getViewport());i.pauseAnimation();};l.prototype.setPlayingAnimation=function(p){this._playingAnimation=p;};l.prototype.setScene=function(s){if(s&&s.getSceneRef()===this._scene){return;}if(s&&s.loaders){for(var i=0;i<s.loaders.length;i++){var n=s.loaders[i];if(n&&n.getMetadata&&n.getMetadata().getName()==="sap.ui.vk.threejs.ContentDeliveryService"){this._cdsLoader=n;this._cdsLoader.detachLoadingFinished(this._handleCdsViewGroupUpdate,this);this._cdsLoader.attachLoadingFinished(this._handleCdsViewGroupUpdate,this);break;}}}this._scene=s?s.getSceneRef():null;this._refreshProcedures();};l.prototype.setViewport=function(n){if(this.getViewport()){var o=sap.ui.getCore().byId(this.getViewport());this._deLinkViewportAndAnimationTimeSlider(o,this.getAnimationTimeSlider());}this.setAssociation("viewport",n,true);if(n){var t=this;n.attachViewActivated(function(q){var r=q.getParameter("viewIndex");var s=q.getParameter("view");if(t._viewportGroups&&t._viewportGroups.length>0){var u=t._viewportGroups[t.getSelectedViewGroupIndex()];if(u&&u.originalId!=s.viewGroupId){for(var i=0;i<t._viewportGroups.length;i++){if(t._viewportGroups[i].originalId===s.viewGroupId){t.setSelectedViewGroupIndex(i,r);break;}}}else{t.viewActivated(r,s);}}});n.attachProcedureFinished(function(i){t._setPlayState(false);});n.attachViewFinished(function(i){t._setPlayState(false);});if(n.getContent()){var p=function(q){var r=n.getContent();for(var i=0;i<r.length;i++){if(r[i].vitId==q){return i;}}};n.removeContent(p("VIT-StepDescription"));n.removeContent(p("VIT-StepDescriptionVertical"));}this._createStepDescriptionBoxes();n.addContent(this._stepDescription);n.addContent(this._stepDescriptionVertical);this._linkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());}};l.prototype._linkViewportAndAnimationTimeSlider=function(i,n){if(!i||!n){return;}if(i._implementation){i=i._implementation;}i.attachAnimationStarted(n.handleAnimationStarted,n);i.attachAnimationFinished(n.handleAnimationFinished,n);i.attachAnimationUpdated(n.handleAnimationUpdated,n);n.attachChange(i.handleCompleteDraggingAnimation,i);n.attachLiveChange(i.handleDragAnimation,i);};l.prototype._deLinkViewportAndAnimationTimeSlider=function(i,n){if(!i||!n){return;}if(i._implementation){i=i._implementation;}i.detachAnimationStarted(n.handleAnimationStarted,n);i.detachAnimationFinished(n.handleAnimationFinished,n);i.detachAnimationUpdated(n.handleAnimationUpdated,n);n.detachChange(i.handleCompleteDraggingAnimation,i);n.detachLiveChange(i.handleDragAnimation,i);};l.prototype._refreshProcedures=function(i){if(this.getAggregation("toolbar")){this._procedureList.removeAllItems();}this._viewportGroups=null;this._modelViews=null;if(this._scene&&this._scene.userData){this._viewportGroups=this._scene.userData.viewportGroups;if(this._viewportGroups&&this._viewportGroups.length>0){this._selectedGroupIndex=0;var n=0;this._viewportGroups.forEach(function(o){o.id=THREE.Math.generateUUID();if(this.getAggregation("toolbar")){this._procedureList.addItem(new sap.ui.core.Item({key:o.id,text:o.name}));}if(i&&o.originalId===i){this._selectedGroupIndex=n;}n++;}.bind(this));this._modelViews=this._viewportGroups[this._selectedGroupIndex].modelViews;if(this.getAggregation("toolbar")){this._currentGroupTitle.setText(this._viewportGroups[0].name).setTooltip(this._viewportGroups[0].name);}}else if(this.getAggregation("toolbar")){this._currentGroupTitle.setText(g().getText("STEP_NAV_PROCEDURES"));}}this._refreshItems();};l.prototype.refresh=function(s){this.setScene(s);};var m="data:image/png;base64,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";l.prototype._clearUI=function(){if(this.getAggregation("toolbar")){this._currentStepTitle.setText("");this._separatorTitle.setText("");this._viewGroupSelector.close();this._nextItemButton.setEnabled(false);this._previousItemButton.setEnabled(false);this._stepCount.setText("");this._stepDescriptionText.setHtmlText("");this._stepDescriptionVerticalText.setHtmlText("");}if(this.getAggregation("container")){this._hbox.removeAllItems();}this._viewItems=[];this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(false);};l.prototype._refreshItems=function(){this._clearUI();var t=this;if(this._modelViews){var p=function(i){this.setSelectedItem(i.getSource());}.bind(this);this._modelViews.forEach(function(n){var o=true;var q=n.name||n.getName&&n.getName();var r=new b({alt:q,densityAware:false,tooltip:q,viewGallery:this,source:n.thumbnailData||m,press:function(i){r.detachBrowserEvent("mouseenter",function(i){t.startAnimate();});r.setSource(n.thumbnailData||m);clearInterval(i.getSource().interval);p(i);},layoutData:new d({shrinkFactor:0})});var s=function(u,w){var y=u.width/w;var z=u.height;var E=w;var G=z;var K=document.createElement("canvas");var L=K.getContext("2d");var M=[];K.width=E;K.height=G;for(var i=0;i<y;i++){var x=E*i;L.clearRect(0,0,E,G);L.drawImage(u,x,0,E,G,0,0,E,G);M.push(K.toDataURL());}t.startAnimate=function(){if(o){o=false;r.detachBrowserEvent("mouseenter",function(O){t.startAnimate();});var i=0;var N=function(){if(i<y){r.setSource(M[i]);i++;}else{r.setSource(M[0]);i=0;}};r.interval=setInterval(function(){N();},250);}};r.attachBrowserEvent("mouseenter",function(N){t.startAnimate();});r.attachBrowserEvent("mouseout",function(N){o=true;r.attachBrowserEvent("mouseenter",function(N){t.startAnimate();});clearInterval(r.interval);r.setSource(n.thumbnailData);});};if(n.animatedThumbnailData!==undefined){var u=document.createElement("img");u.onload=function(){s(u,n.tileWidth);};u.src=n.animatedThumbnailData;}if(this.getEnableViewReordering()){r.addDragDropConfig(new k({dragStart:function(){t._draggedModelView=n;}}));r.getMetadata().dnd.draggable=true;}r.data("modelView",n);this._viewItems.push(r);if(this.getAggregation("container")){this._hbox.addItem(r);}}.bind(this));this.rerender();}};l.prototype.setSelectedItem=function(i){var n=sap.ui.getCore().byId(this.getViewport());if(n&&i.getCustomData().length>0){var o=i.getCustomData()[0].getValue();n.activateView(o,!this._playingAnimation);}return this;};l.prototype.setDescription=function(){if(!this._selectedItem){return;}if(!this.getVisible()){this._stepDescription.setVisible(false);this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVertical.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(false);return;}var i=sap.ui.getCore().byId(this.getViewport());if(i&&this._selectedItem.getCustomData().length>0){var n=this._selectedItem.getCustomData()[0].getValue();var o=n.getDescription();if(o){if(this._previousOrientationVertical===false){this._stepDescription.setVisible(true);this._stepDescriptionToolbar.setVisible(true);this._stepDescriptionVerticalToolbar.setVisible(false);}else{this._stepDescriptionVertical.setVisible(true);this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(true);this._previousOrientationVertical=true;}}else if(this._previousOrientationVertical===true){this._stepDescriptionVertical.setVisible(false);}else{this._stepDescription.setVisible(false);this._previousOrientationVertical=false;}if(o!=null){this._stepDescriptionText.setHtmlText(o);this._stepDescriptionVerticalText.setHtmlText(o);}}};l.prototype.viewActivated=function(i){if(this._selectedItem){if(this.getSelectedViewIndex()!==i){this._selectedItem.removeStyleClass("selected");}}this._selectedItem=this._viewItems[i];if(!this._selectedItem){return this;}if(this.getAggregation("toolbar")){var t=g().getText("VIEWS_TITLE_WITH_COUNT",[i+1,this._viewItems.length]);this._stepCount.setText(t);this._previousItemButton.setEnabled(this._selectedItem!==this._viewItems[0]&&this._viewItems.length>1);this._nextItemButton.setEnabled(this._selectedItem!==this._viewItems[this._viewItems.length-1]&&this._viewItems.length>1);this._setPlayState(true);}this._selectedItem.addStyleClass("selected");if(this._isScrollingNecessary(this._selectedItem.getDomRef(),this._scrollContainer.getDomRef())){this._scrollContainer.scrollToElement(this._selectedItem,500);}var n=sap.ui.getCore().byId(this.getViewport());if(n&&this._selectedItem.getCustomData().length>0){var o=this._selectedItem.getCustomData()[0].getValue();var p=o.getPlaybacks();var s=this.getAnimationTimeSlider();if(s){if(!p){s.setEnabled(false);s.setValue(0);}else{s.setEnabled(true);}}var q=o.name||o.getName&&o.getName();if(this.getAggregation("toolbar")){this._separatorTitle.setText("/");this._currentStepTitle.setText(q).setTooltip(q);}}this.setDescription();this.fireSelectionChange({item:this._selectedItem});return this;};l.prototype.getSelectedItem=function(){return this._selectedItem;};l.prototype.getSelectedViewIndex=function(){for(var n=0;n<this._viewItems.length;n++){if(this._viewItems[n]===this.getSelectedItem()){return n;}}return-1;};l.prototype.setSelectedViewIndex=function(i){if(this._viewItems.length>i){this.setSelectedItem(this._viewItems[i]);}};l.prototype.getSelectedViewGroupIndex=function(){return this._selectedGroupIndex;};l.prototype.setSelectedViewGroupIndex=function(i,n){if(this._viewportGroups&&this._viewportGroups.length>i){this._selectedGroupIndex=i;if(n==null){n=0;}this._currentGroupTitle.setText(this._viewportGroups[i].name).setTooltip(this._viewportGroups[i].name);this._separatorTitle.setVisible(true);this._modelViews=this._viewportGroups[i].modelViews;if((!this._modelViews||this._modelViews.length===0)&&this._cdsLoader){var o=this._viewportGroups[i].originalId;var s=this._viewportGroups[i].sceneId;var t=this;this._cdsLoader.loadViewGroup(s,o).then(function(p){t._viewportGroups[i].modelViews=p;t._modelViews=p;t._refreshItems();t.setSelectedViewIndex(n);});}else{this._refreshItems();this.setSelectedViewIndex(n);}}};l.prototype._isScrollingNecessary=function(i,s){if(i&&s){var r=i.getBoundingClientRect();return r.left<0||r.right>s.clientWidth;}return false;};l.prototype._setContent=function(o){var p=o&&o.getMetadata&&o.getMetadata().getName()==="sap.ui.vk.threejs.Scene";this.setScene(p?o:null);if(p&&o.builders){for(var i=0;i<o.builders.length;i++){o.builders[i]._fireThumbnailLoaded=function(r){var s=null;for(var n=0;n<this._viewItems.length;n++){if(this._viewItems[n].data("modelView")==r.modelView){s=this._viewItems[n];break;}}if(s){s.setSource(r.modelView.thumbnailData);}}.bind(this);}}if(this.getViewport()){var q=sap.ui.getCore().byId(this.getViewport());this._linkViewportAndAnimationTimeSlider(q,this.getAnimationTimeSlider());}};l.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};l.prototype._handleContentChangesStarted=function(){if(this.getViewport()){var o=sap.ui.getCore().byId(this.getViewport());this._deLinkViewportAndAnimationTimeSlider(o,this.getAnimationTimeSlider());}this.setScene(null);};l.prototype._handleContentReplaced=function(i){var n=i.getParameter("newContent");this._setContent(n);};l.prototype._handleCdsViewGroupUpdate=function(n){var o=n.getParameter("currentViewGroupId");if(this._modelViews&&this._modelViews.length){this._refreshItems();}else{this._refreshProcedures(o);}if(this.getViewport()){var p=sap.ui.getCore().byId(this.getViewport());var q=p.getCurrentView();if(q&&q.userData&&q.userData.viewInfo&&this._viewItems){for(var i=0;i<this._viewItems.length;i++){var r=this._viewItems[i];var s=r.getCustomData()[0].getValue();if(s&&s.userData&&s.userData.viewInfo&&s.userData.viewInfo.viewId===q.userData.viewInfo.viewId){this.viewActivated(i);break;}}}}};a.injectMethodsIntoClass(l);return l;});
