//@ui5-bundle sap/ui/vk/library-preload.js
sap.ui.predefine('sap/ui/vk/AnimationInterpolationType',[],function(){"use strict";var A=function(){};A.discrete="discrete";A.cubic="cubic";A.linear="linear";return A;});
sap.ui.predefine('sap/ui/vk/AnimationRotateType',[],function(){"use strict";var A=function(){};A.angleAxis="angleAxis";A.euler="euler";A.quaternion="quaternion";return A;});
sap.ui.predefine('sap/ui/vk/AnimationTrackType',[],function(){"use strict";var A=function(){};A.rotate="rotate";A.translate="translate";A.scale="scale";A.opacity="opacity";A.color="color";return A;});
sap.ui.predefine('sap/ui/vk/DrawerToolbarButton',[],function(){"use strict";var D=function(){};D.crossSection="VIT-Cross-Section";D.crossSectionAxis="VIT-Cross-Section-Axis";D.turntable="VIT-Turntable";D.orbit="VIT-Orbit";D.pan="VIT-Pan";D.zoom="VIT-Zoom";D.show="VIT-Show";D.hide="VIT-Hide";D.fitToView="VIT-Fit-To-View";D.rectangularSelection="VIT-Rectangular-Selection";D.predefinedViews="VIT-Predefined-Views";D.fullscreen="VIT-Fullscreen";return D;});
sap.ui.predefine('sap/ui/vk/threejs/BBoxSubdivider',[],function(){"use strict";var U=function(){this.unpack=function(p){if(!p||(p.bytelength<1)){return false;}try{this.nLevel=p[0];if(this.nLevel>5){return false;}this.numDivision=Math.pow(2,this.nLevel);this.octree=new Uint8Array(Math.pow(this.numDivision,3));this.streamOffset=1;this._decodeRecursive(p,0,0,0,0);}catch(e){return false;}return true;};this.getUnpacked=function(){return this.octree;};this._setValue=function(g,a,b,v){this.octree[b*this.numDivision*this.numDivision+a*this.numDivision+g]=v?1:0;};this._decodeRecursive=function(p,g,a,b,l){if(l===this.nLevel){this._setValue(g,a,b,true);return true;}if(this.streamOffset>=p.length){return false;}var c=p[this.streamOffset];this.streamOffset++;g*=2;a*=2;b*=2;if(l>=this.nLevel){return true;}for(var z=0;z<2;z++){for(var y=0;y<2;y++){for(var x=0;x<2;x++){if((c&(1<<(z*4+y*2+x)))!==0){if(!this._decodeRecursive(p,g+x,a+y,b+z,l+1)){return false;}}else{this._clearBitsRecursive(g+x,a+y,b+z,l+1);}}}}return true;};this._clearBitsRecursive=function(g,a,b,l){if(l===this.nLevel){this._setValue(g,a,b,false);return;}g*=2;a*=2;b*=2;if(l>=this.nLevel){return;}for(var z=0;z<2;z++){for(var y=0;y<2;y++){for(var x=0;x<2;x++){this._clearBitsRecursive(g+x,a+y,b+z,l+1);}}}};};var C=function(n){this.numDivision=n;this.xyzToIndexMap=new Map();this.points=[];this.getOrCreatePointAt=function(x,y,z,f,d){var k=x+":"+y+":"+z+":"+f+":"+d;var i=this.xyzToIndexMap.get(k);if(i){return i;}this.points.push(x/this.numDivision-0.5,y/this.numDivision-0.5,z/this.numDivision-0.5);i=this.points.length/3-1;this.xyzToIndexMap.set(k,i);return i;};};var S=function(l,n,u){this.level=l;this.numDivision=n;this.unpacked=u;this.getValue=function(g,a,b){if(g<0||a<0||b<0||g>=this.numDivision||a>=this.numDivision||b>=this.numDivision){return 0;}return this.unpacked[b*this.numDivision*this.numDivision+a*this.numDivision+g];};};var B=function(){};
B.unpackSubDividedBoundingBox=function(p){var u=new U();if(u.unpack(p)){return new S(u.nLevel,u.numDivision,u.getUnpacked());}return null;};
B.makeSubDividedBoundingBoxGeometry=function(s){if(!s){return null;}var i=[];var n=s.level;var e=Math.pow(2,n);var m=new C(e);var x,y,z,f,a,b,c,d;for(x=0;x<=e;x++){for(y=0;y<e;y++){for(z=0;z<e;z++){f=s.getValue(x,y,z)-s.getValue(x-1,y,z);if(f!==0){a=m.getOrCreatePointAt(x,y,z,0,f);b=m.getOrCreatePointAt(x,y+1,z,0,f);c=m.getOrCreatePointAt(x,y+1,z+1,0,f);d=m.getOrCreatePointAt(x,y,z+1,0,f);if(f<0){i.push(a,b,c);i.push(a,c,d);}else{i.push(c,b,a);i.push(d,c,a);}}}}}for(y=0;y<=e;y++){for(x=0;x<e;x++){for(z=0;z<e;z++){f=s.getValue(x,y,z)-s.getValue(x,y-1,z);if(f!==0){a=m.getOrCreatePointAt(x,y,z,1,f);b=m.getOrCreatePointAt(x+1,y,z,1,f);c=m.getOrCreatePointAt(x+1,y,z+1,1,f);d=m.getOrCreatePointAt(x,y,z+1,1,f);if(f>0){i.push(a,b,c);i.push(a,c,d);}else{i.push(c,b,a);i.push(d,c,a);}}}}}for(z=0;z<=e;z++){for(x=0;x<e;x++){for(y=0;y<e;y++){f=s.getValue(x,y,z)-s.getValue(x,y,z-1);if(f!==0){a=m.getOrCreatePointAt(x,y,z,2,f);b=m.getOrCreatePointAt(x+1,y,z,2,f);c=m.getOrCreatePointAt(x+1,y+1,z,2,f);d=m.getOrCreatePointAt(x,y+1,z,2,f);if(f<0){i.push(a,b,c);i.push(a,c,d);}else{i.push(c,b,a);i.push(d,c,a);}}}}}var g=new THREE.BufferGeometry();var h=new THREE.BufferAttribute(new Uint16Array(i),1);var p=new THREE.BufferAttribute(new Float32Array(m.points),3);g.setIndex(h);g.addAttribute("position",p);g.computeFaceNormals();g.computeVertexNormals();g.computeBoundingSphere();return g;};
return B;});
sap.ui.predefine('sap/ui/vk/threejs/UsageCounter',["./thirdparty/three"],function(t){"use strict";var U=function(){};
U.increaseMaterialUsed=function(m){if(m&&m.userData&&m.userData.materialUsed!==undefined){m.userData.materialUsed++;return true;}return false;};
U.decreaseMaterialUsed=function(m){if(m&&m.userData&&m.userData.materialUsed!==undefined){m.userData.materialUsed--;return true;}return false;};
U.increaseGeometryUsed=function(g){if(g&&g.userData&&g.userData.geometryUsed!==undefined){g.userData.geometryUsed++;return true;}return false;};
U.decreaseGeometryUsed=function(g){if(g&&g.userData&&g.userData.geometryUsed!==undefined){g.userData.geometryUsed--;return true;}return false;};
return U;});
sap.ui.predefine('sap/ui/vk/tools/AnchorPointToolHandler',["sap/ui/base/EventProvider","sap/m/Menu","sap/m/MenuItem","../getResourceBundle","../threejs/thirdparty/three"],function(E,M,a,g,t){"use strict";
var A=E.extend("sap.ui.vk.tools.AnchorPointToolHandler",{
metadata:{},
constructor:function(b){this._tool=b;this._gizmo=b.getGizmo();this._rect=null;this._rayCaster=new THREE.Raycaster();this._handleIndex=-1;this._gizmoIndex=-1;this._handleAxis=new THREE.Vector3();this._gizmoOrigin=new THREE.Vector3();this._gizmoScale=1;this._matrixOrigin=new THREE.Matrix4();this._rotationOrigin=new THREE.Matrix4();this._mouse=new THREE.Vector2();this._mouseOrigin=new THREE.Vector2();}
});
A.prototype._updateMouse=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
A.prototype._updateHandles=function(e,h){var p=this._handleIndex;this._handleIndex=-1;if(e.n===1||(e.event&&e.event.type==="contextmenu")){for(var i=0,l=this._gizmo.getGizmoCount();i<l;i++){var b=this._gizmo.getTouchObject(i);var c=this._rayCaster.intersectObject(b,true);if(c.length>0){this._handleIndex=b.children.indexOf(c[0].object);if(this._handleIndex>=0){this._gizmoIndex=i;this._gizmoOrigin.setFromMatrixPosition(b.matrixWorld);this._matrixOrigin.copy(b.matrixWorld);this._gizmoScale=b.scale.x;this._rotationOrigin.extractRotation(b.matrixWorld);if(this._handleIndex<3){this._handleAxis.setFromMatrixColumn(b.matrixWorld,this._handleIndex).normalize();}else if(this._handleIndex<6){this._handleAxis.setFromMatrixColumn(b.matrixWorld,this._handleIndex-3).normalize();}else if(this._handleIndex<9){this._handleAxis.setFromMatrixColumn(b.matrixWorld,this._handleIndex-6).normalize();}}}}}this._gizmo.highlightHandle(this._handleIndex,h||this._handleIndex===-1);if(p!==this._handleIndex){this.getViewport().setShouldRenderFrame();}};
A.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);e.handled|=this._handleIndex>=0;}};
A.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);this._gizmo.selectHandle(this._handleIndex);e.handled|=this._handleIndex>=0;}};
var d=new THREE.Vector3();
A.prototype._getAxisOffset=function(){var r=this._rayCaster.ray;var b=this._handleAxis.clone().cross(r.direction).cross(r.direction).normalize();d.copy(r.origin).sub(this._gizmoOrigin);return b.dot(d)/b.dot(this._handleAxis);};
A.prototype._getPlaneOffset=function(){var r=this._rayCaster.ray;d.copy(this._gizmoOrigin).sub(r.origin);var b=this._handleAxis.dot(d)/this._handleAxis.dot(r.direction);return r.direction.clone().multiplyScalar(b).sub(d);};
A.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,false);if(this._handleIndex>=0){e.handled=true;this._gesture=true;this._mouseOrigin.copy(e);this._gizmo.selectHandle(this._handleIndex);this._gizmo.beginGesture();if(this._handleIndex<3){this._dragOrigin=this._getAxisOffset();}else if(this._handleIndex<6){this._dragOrigin=this._getPlaneOffset();}else if(this._handleIndex<9){this._dragOrigin=this._getPlaneOffset().normalize();}var b=new THREE.Vector3().setFromMatrixColumn(this._matrixOrigin,(this._handleIndex+1)%3).normalize();var c=new THREE.Vector3().setFromMatrixColumn(this._matrixOrigin,(this._handleIndex+2)%3).normalize();var r=new THREE.Vector3().crossVectors(b,c).normalize();var f=new THREE.Vector3().setFromMatrixPosition(this._matrixOrigin);var l=b.clone();var m=2;for(var i=0;i<3;i++){var h=new THREE.Vector3().setComponent(i,1);var j=r.dot(h);if(m>j){m=j;l.copy(h);}}l.sub(r.clone().multiplyScalar(l.dot(r))).normalize();this._levelAngle=Math.atan2(l.dot(c),l.dot(b));var k=this._rayCaster.ray;var d=f.clone().sub(k.origin);var n=r.dot(d)/r.dot(k.direction);var o=k.direction.clone().multiplyScalar(n).sub(d).normalize();this._startAngle=Math.atan2(o.dot(c),o.dot(b));var u=new THREE.Vector3().setFromMatrixColumn(this.getViewport().getCamera().getCameraRef().matrixWorld,1);var p=new THREE.Vector3().crossVectors(o,r);this._rotationDelta=u.dot(p)<0?-0.01:0.01;}}};
A.prototype._setOffset=function(o){if(this._tool.getEnableStepping()){var s=Math.pow(10,Math.round(Math.log10(this._gizmoScale)))*0.1;var m=new THREE.Matrix4().getInverse(this._rotationOrigin);var b=this._gizmoOrigin.clone().applyMatrix4(m);var p=this._gizmoOrigin.clone().add(o).applyMatrix4(m);for(var i=0;i<3;i++){var c=p.getComponent(i);if(Math.abs(c-b.getComponent(i))>s*1e-5){var e=Math.round(c/s)*s;d.setFromMatrixColumn(this._rotationOrigin,i).multiplyScalar(e-c);o.add(d);}}}this._gizmo._setOffset(o,this._gizmoIndex);};
A.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateMouse(e);if(this._handleIndex<3){if(isFinite(this._dragOrigin)){this._setOffset(this._handleAxis.clone().multiplyScalar(this._getAxisOffset()-this._dragOrigin));}}else if(this._handleIndex<6){if(isFinite(this._dragOrigin.x)&&isFinite(this._dragOrigin.y)&&isFinite(this._dragOrigin.z)){this._setOffset(this._getPlaneOffset().sub(this._dragOrigin));}}else if(this._handleIndex<9){var b=this._startAngle;var c=b+(e.y-this._mouseOrigin.y)*this._rotationDelta;if(this._tool.getEnableStepping()){var s=THREE.Math.degToRad(5);var f=c-b-this._levelAngle;c+=Math.round(f/s)*s-f;}if(isFinite(b)&&isFinite(c)){this._gizmo._setRotationAxisAngle(this._handleIndex-6,b,c);}}}};
A.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateMouse(e);this._gizmo.endGesture();this._dragOrigin=undefined;this._updateHandles(e,true);this.getViewport().setShouldRenderFrame();}};
A.prototype.contextMenu=function(e){if(this._inside(e)){this._updateMouse(e);this._updateHandles(e,true);if(this._handleIndex>=0){e.handled=true;var m=new M({items:[new a({text:g().getText("ANCHOR_POINT_TOOL_MOVE_TO_WORLD_ORIGIN")}),new a({text:g().getText("ANCHOR_POINT_TOOL_MOVE_TO_SELECTION_CENTER")}),new a({text:g().getText("ANCHOR_POINT_TOOL_MOVE_TO_SCENE_CENTER")}),new a({text:g().getText("ANCHOR_POINT_TOOL_MOVE_TO_SELECTED_OBJECTS_ORIGIN")})],itemSelected:function(e){var i=e.getParameters("item").item;var b=e.getSource().indexOfItem(i);var p=new THREE.Vector3();var v=this.getViewport();if(v){var c=new THREE.Box3();switch(b){default:case 0:break;case 1:if(v._viewStateManager){v._viewStateManager.enumerateSelection(function(n){c.expandByObject(n);});c.getCenter(p);}break;case 2:var s=v.getScene()?v.getScene().getSceneRef():null;if(s){s._expandBoundingBox(c,false,true);c.getCenter(p);}break;case 3:if(v._viewStateManager){var f=0;var h=new THREE.Vector3();v._viewStateManager.enumerateSelection(function(n){p.add(h.setFromMatrixPosition(n.matrixWorld));f++;});p.multiplyScalar(1/f);}break;}}this._gizmo.setPosition(p);}.bind(this)});m.openAsContextMenu(e.event,this.getViewport());}}};
A.prototype.getViewport=function(){return this._tool._viewport;};
A.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
A.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var b=document.getElementById(i);if(b===null){return false;}var o=this._getOffset(b);this._rect={x:o.x,y:o.y,w:b.offsetWidth,h:b.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return A;});
sap.ui.predefine('sap/ui/vk/tools/MoveToolHandler',["sap/ui/base/EventProvider","sap/m/Menu","sap/m/MenuItem","../getResourceBundle","../threejs/thirdparty/three","./CoordinateSystem"],function(E,M,a,g,t,C){"use strict";
var b=E.extend("sap.ui.vk.tools.MoveToolHandler",{
metadata:{},
constructor:function(c){this._tool=c;this._gizmo=c.getGizmo();this._rect=null;this._rayCaster=new THREE.Raycaster();this._handleIndex=-1;this._gizmoIndex=-1;this._handleAxis=new THREE.Vector3();this._gizmoOrigin=new THREE.Vector3();this._gizmoScale=1;this._objectSpace=new THREE.Matrix4();this._mouse=new THREE.Vector2();}
});
b.prototype._updateMouse=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
b.prototype._updateHandles=function(e,h){var p=this._handleIndex;this._handleIndex=-1;if(e.n===1||(e.event&&e.event.type==="contextmenu")){for(var i=0,l=this._gizmo.getGizmoCount();i<l;i++){var c=this._gizmo.getTouchObject(i);var f=this._rayCaster.intersectObject(c,true);if(f.length>0){this._handleIndex=c.children.indexOf(f[0].object);if(this._handleIndex>=0){this._gizmoIndex=i;this._gizmoOrigin.setFromMatrixPosition(c.matrixWorld);this._gizmoScale=c.scale.x;this._objectSpace.extractRotation(c.matrixWorld);if(this._gizmo._coordinateSystem!==C.World){this._objectSpace.copyPosition(c.matrixWorld);}if(this._handleIndex<3){this._handleAxis.setFromMatrixColumn(c.matrixWorld,this._handleIndex).normalize();}else if(this._handleIndex<6){this._handleAxis.setFromMatrixColumn(c.matrixWorld,this._handleIndex-3).normalize();}}}}}this._gizmo.highlightHandle(this._handleIndex,h||this._handleIndex===-1);if(p!==this._handleIndex){this.getViewport().setShouldRenderFrame();}};
b.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);e.handled|=this._handleIndex>=0;}};
b.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);e.handled|=this._handleIndex>=0;}};
var d=new THREE.Vector3();
b.prototype._getAxisOffset=function(){var r=this._rayCaster.ray;var c=this._handleAxis.clone().cross(r.direction).cross(r.direction).normalize();d.copy(r.origin).sub(this._gizmoOrigin);return c.dot(d)/c.dot(this._handleAxis);};
b.prototype._getPlaneOffset=function(){var r=this._rayCaster.ray;d.copy(this._gizmoOrigin).sub(r.origin);var c=this._handleAxis.dot(d)/this._handleAxis.dot(r.direction);return r.direction.clone().multiplyScalar(c).sub(d);};
b.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,false);if(this._handleIndex>=0){this._gesture=true;e.handled=true;this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);this._gizmo.beginGesture();if(this._handleIndex<3){this._dragOrigin=this._getAxisOffset();}else if(this._handleIndex<6){this._dragOrigin=this._getPlaneOffset();}}}};
b.prototype._setOffset=function(o){if(this._tool.getEnableStepping()){var s=Math.pow(10,Math.round(Math.log10(this._gizmoScale)))*0.1;var m=new THREE.Matrix4().getInverse(this._objectSpace);var c=this._gizmoOrigin.clone().applyMatrix4(m);var p=this._gizmoOrigin.clone().add(o).applyMatrix4(m);for(var i=0;i<3;i++){var e=p.getComponent(i);if(Math.abs(e-c.getComponent(i))>s*1e-5){var f=Math.round(e/s)*s;d.setFromMatrixColumn(this._objectSpace,i).multiplyScalar(f-e);o.add(d);}}}if(isFinite(o.x)&&isFinite(o.y)&&isFinite(o.z)){this._gizmo._setOffset(o,this._gizmoIndex);}};
b.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateMouse(e);if(this._handleIndex<3){if(isFinite(this._dragOrigin)){this._setOffset(this._handleAxis.clone().multiplyScalar(this._getAxisOffset()-this._dragOrigin));}}else if(this._handleIndex<6){if(isFinite(this._dragOrigin.x)&&isFinite(this._dragOrigin.y)&&isFinite(this._dragOrigin.z)){this._setOffset(this._getPlaneOffset().sub(this._dragOrigin));}}}};
b.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateMouse(e);this._gizmo.endGesture();this._dragOrigin=undefined;this._updateHandles(e,true);this.getViewport().setShouldRenderFrame();}};
b.prototype.contextMenu=function(e){if(this._inside(e)){this._updateMouse(e);this._updateHandles(e,true);if(this._handleIndex>=0){e.handled=true;var m=new M({items:[new a({text:g().getText("TOOL_COORDINATE_SYSTEM_WORLD"),key:C.World}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_LOCAL"),key:C.Local}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_SCREEN"),key:C.Screen}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_CUSTOM"),key:C.Custom})],itemSelected:function(e){var i=e.getParameters("item").item;this._tool.setCoordinateSystem(i.getKey());}.bind(this)});m.openAsContextMenu(e.event,this.getViewport());}}};
b.prototype.getViewport=function(){return this._tool._viewport;};
b.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
b.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var c=document.getElementById(i);if(c===null){return false;}var o=this._getOffset(c);this._rect={x:o.x,y:o.y,w:c.offsetWidth,h:c.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return b;});
sap.ui.predefine('sap/ui/vk/tools/RectSelectToolHandler',["sap/ui/base/EventProvider"],function(E){"use strict";
var R=E.extend("sap.ui.vk.tools.RectSelectToolHandler",{
metadata:{publicMethods:["beginGesture","endGesture","move","click","doubleClick","contextMenu"]},
constructor:function(T){this._tool=T;this._rect=null;this._gesture=false;this._nomenu=false;this._selectionRect=null;}
});
R.prototype.destroy=function(){this._tool=null;this._rect=null;this._gesture=false;};
R.prototype.activate=function(v){this._deactivate=false;if(v._loco){this._viewport=v;v._loco.addHandler(this,1);}};
R.prototype.deactivate=function(){if(this._gesture){this._deactivate=true;}else if(this._viewport){this._deactivate=false;this._viewport._loco.removeHandler(this);this._viewport=null;}};
R.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
R.prototype._inside=function(a){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d==null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};if(document.activeElement){try{document.activeElement.blur();}catch(e){}}d.focus();return(a.x>=this._rect.x&&a.x<=this._rect.x+this._rect.w&&a.y>=this._rect.y&&a.y<=this._rect.y+this._rect.h);};
R.prototype.beginGesture=function(e){if(e.n===1&&this._inside(e)&&!this._gesture){this._gesture=true;e.handled=true;var x=e.x-this._rect.x,y=e.y-this._rect.y;this._selectionRect={x1:x,y1:y,x2:x,y2:y};return;}};
R.prototype.move=function(e){if(this._gesture){e.handled=true;this._nomenu=true;if(this._selectionRect){this._selectionRect.x2=e.x-this._rect.x;this._selectionRect.y2=e.y-this._rect.y;if(this._viewport){this._viewport.setSelectionRect(this._selectionRect);}}}};
R.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;if(this._selectionRect){if(this._viewport){var x=e.x-this._rect.x,y=e.y-this._rect.y;if(this._tool.isViewportType("sap.ui.vk.dvl.Viewport")){this._tool.select(this._selectionRect.x1,this._selectionRect.y1,x,y,null,null);}else if(this._tool.isViewportType("sap.ui.vk.threejs.Viewport")){this._tool.select(this._selectionRect.x1,this._selectionRect.y1,x,y,this._viewport.getScene(),this._viewport.getCamera());}}this._viewport.setSelectionRect(null);this._selectionRect=null;}if(this._deactivate){this.deactivate();}}};
R.prototype.getViewport=function(){return this._viewport;};
return R;});
sap.ui.predefine('sap/ui/vk/tools/RotateToolHandler',["sap/ui/base/EventProvider","sap/m/Menu","sap/m/MenuItem","../getResourceBundle","../threejs/thirdparty/three","./CoordinateSystem"],function(E,M,a,g,t,C){"use strict";
var R=E.extend("sap.ui.vk.tools.RotateToolHandler",{
metadata:{},
constructor:function(b){this._tool=b;this._gizmo=b.getGizmo();this._rect=null;this._rayCaster=new THREE.Raycaster();this._rayCaster.linePrecision=0.2;this._handleIndex=-1;this._gizmoIndex=-1;this._matrixOrigin=new THREE.Matrix4();this._levelingQuaternion=new THREE.Quaternion();this._mouse=new THREE.Vector2();this._mouseOrigin=new THREE.Vector2();}
});
R.prototype._updateMouse=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
R.prototype._updateHandles=function(e,h){var p=this._handleIndex;this._handleIndex=-1;if(e.n===1||(e.event&&e.event.type==="contextmenu")){for(var i=0,l=this._gizmo.getGizmoCount();i<l;i++){var b=this._gizmo.getTouchObject(i);var c=this._rayCaster.intersectObject(b,true);if(c.length>0){this._handleIndex=b.children.indexOf(c[0].object);if(this._handleIndex>=0&&this._handleIndex<3){this._gizmoIndex=i;this._matrixOrigin.copy(b.matrixWorld);this._gizmo._getLevelingQuaternion(this._levelingQuaternion,i);this._objectSize=this._gizmo._getObjectSize(i)/this._gizmo._getGizmoScale(b.position);}}}}this._gizmo.highlightHandle(this._handleIndex,h||this._handleIndex===-1);if(p!==this._handleIndex){this.getViewport().setShouldRenderFrame();}};
R.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);e.handled|=this._handleIndex>=0;}};
R.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);e.handled|=this._handleIndex>=0;}};
R.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,false);if(this._handleIndex>=0&&this._handleIndex<3){e.handled=true;this._gesture=true;this._mouseOrigin.copy(e);this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);this._gizmo.beginGesture();var b=new THREE.Vector3().setFromMatrixColumn(this._matrixOrigin,(this._handleIndex+1)%3).normalize();var c=new THREE.Vector3().setFromMatrixColumn(this._matrixOrigin,(this._handleIndex+2)%3).normalize();var r=new THREE.Vector3().crossVectors(b,c).normalize();var d=new THREE.Vector3().setFromMatrixPosition(this._matrixOrigin);var l=new THREE.Matrix4().makeRotationFromQuaternion(this._levelingQuaternion);var f=new THREE.Vector3(1,0,0);var m=2;for(var i=0;i<3;i++){var h=new THREE.Vector3().setFromMatrixColumn(l,i).normalize();var j=r.dot(h);if(m>j){m=j;f.copy(h);}}f.sub(r.clone().multiplyScalar(f.dot(r))).normalize();this._levelAngle=Math.atan2(f.dot(c),f.dot(b));var k=this._rayCaster.ray;var n=d.clone().sub(k.origin);var o=r.dot(n)/r.dot(k.direction);var p=k.direction.clone().multiplyScalar(o).sub(n).normalize();this._startAngle=Math.atan2(p.dot(c),p.dot(b));var u=new THREE.Vector3().setFromMatrixColumn(this.getViewport().getCamera().getCameraRef().matrixWorld,1);var q=new THREE.Vector3().crossVectors(p,r);this._rotationDelta=u.dot(q)<0?-0.01:0.01;}}};
R.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateMouse(e);var b=this._startAngle;var c=b+(e.y-this._mouseOrigin.y)*this._rotationDelta;if(this._tool.getEnableStepping()){var s=5;if(this._objectSize>0){var d=[0.1,1,5,15];var f=[2000,1000,300,0];for(var i=0;i<4;i++){if(this._objectSize>=f[i]){s=d[i];break;}}}s=THREE.Math.degToRad(s);var h=c-b-this._levelAngle;c+=Math.round(h/s)*s-h;}if(isFinite(b)&&isFinite(c)){this._gizmo._setRotationAxisAngle(this._handleIndex,b,c);}}};
R.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateMouse(e);this._gizmo.endGesture();this._updateHandles(e,true);this.getViewport().setShouldRenderFrame();}};
R.prototype.contextMenu=function(e){if(this._inside(e)){this._updateMouse(e);this._updateHandles(e,true);if(this._handleIndex>=0){e.handled=true;var m=new M({items:[new a({text:g().getText("TOOL_COORDINATE_SYSTEM_WORLD"),key:C.World}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_LOCAL"),key:C.Local}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_SCREEN"),key:C.Screen}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_CUSTOM"),key:C.Custom})],itemSelected:function(e){var i=e.getParameters("item").item;this._tool.setCoordinateSystem(i.getKey());}.bind(this)});m.openAsContextMenu(e.event,this.getViewport());}}};
R.prototype.getViewport=function(){return this._tool._viewport;};
R.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
R.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d===null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return R;});
sap.ui.predefine('sap/ui/vk/tools/ScaleToolHandler',["sap/ui/base/EventProvider","sap/m/Menu","sap/m/MenuItem","../getResourceBundle","../threejs/thirdparty/three","./CoordinateSystem"],function(E,M,a,g,t,C){"use strict";
var S=E.extend("sap.ui.vk.tools.ScaleToolHandler",{
metadata:{},
constructor:function(b){this._tool=b;this._gizmo=b.getGizmo();this._rect=null;this._rayCaster=new THREE.Raycaster();this._handleIndex=-1;this._gizmoIndex=-1;this._handleAxis=new THREE.Vector3();this._handleDirection=new THREE.Vector3();this._gizmoOrigin=new THREE.Vector3();this._mouse=new THREE.Vector2();this._mouseOrigin=new THREE.Vector2();this._originScale=1;this._objectSize=1;}
});
S.prototype._updateMouse=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
S.prototype._updateHandles=function(e,h){var p=this._handleIndex;this._handleIndex=-1;if(e.n===1||(e.event&&e.event.type==="contextmenu")){for(var i=0,l=this._gizmo.getGizmoCount();i<l;i++){var b=this._gizmo.getTouchObject(i);var c=this._rayCaster.intersectObjects(b.children,false);if(c.length>0){this._handleIndex=b.children.indexOf(c[0].object);if(this._handleIndex>=0){this._gizmoIndex=i;this._gizmoOrigin.setFromMatrixPosition(b.matrixWorld);this._handleAxis.setFromMatrixColumn(b.matrixWorld,this._handleIndex%3).normalize();this._originScale=this._gizmo._getObjectScale(i).x;this._objectSize=(this._gizmo._getObjectSize(i)/b.scale.x)||1;var d=new THREE.Vector3().setFromMatrixColumn(b.matrixWorld,(this._handleIndex+1)%3).normalize();var f=new THREE.Vector3().setFromMatrixColumn(b.matrixWorld,(this._handleIndex+2)%3).normalize();this._handleDirection.addVectors(d,f).normalize();}}}}this._gizmo.highlightHandle(this._handleIndex,h||this._handleIndex===-1);if(p!==this._handleIndex){this.getViewport().setShouldRenderFrame();}};
S.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);e.handled|=this._handleIndex>=0;}};
S.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,true);this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);e.handled|=this._handleIndex>=0;}};
S.prototype._getAxisOffset=function(){var r=this._rayCaster.ray;var d=this._handleAxis.clone().cross(r.direction).cross(r.direction).normalize();var b=r.origin.clone().sub(this._gizmoOrigin);return d.dot(b)/d.dot(this._handleAxis);};
S.prototype._getPlaneOffset=function(){var r=this._rayCaster.ray;var d=this._gizmoOrigin.clone().sub(r.origin);var b=this._handleAxis.dot(d)/this._handleAxis.dot(r.direction);return r.direction.clone().multiplyScalar(b).sub(d);};
S.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateMouse(e);this._updateHandles(e,false);if(this._handleIndex>=0){this._gesture=true;e.handled=true;this._mouseOrigin.set(e.x,e.y);this._gizmo.selectHandle(this._handleIndex,this._gizmoIndex);this._gizmo.beginGesture();if(this._handleIndex<3){this._dragOrigin=this._getAxisOffset();}else if(this._handleIndex<6){this._dragOrigin=this._handleDirection.dot(this._getPlaneOffset());}}}};
S.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateMouse(e);var s=new THREE.Vector3().setScalar(1);if(this._handleIndex<3){if(this._tool.getNonUniformScaleEnabled()){s.setComponent(this._handleIndex,this._getAxisOffset()/this._dragOrigin);}else{s.setScalar(this._getAxisOffset()/this._dragOrigin);}}else if(this._handleIndex<6){s.setScalar(this._handleDirection.dot(this._getPlaneOffset())/this._dragOrigin).setComponent(this._handleIndex-3,1);}else{var d=(this._mouseOrigin.y-e.y)/60;s.setScalar(d>=0?1+d:1/(1-d));}if(s.x&&s.y&&s.z&&isFinite(s.x)&&isFinite(s.y)&&isFinite(s.z)){if(this._tool.getEnableStepping()){var b=Math.pow(10,Math.round(Math.log10(this._originScale/this._objectSize)))/this._originScale;if(b>0&&isFinite(b)){s.setScalar(Math.max(Math.round(s.x/b),1)*b);}}this._gizmo._setScale(s);}}};
S.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateMouse(e);this._gizmo.endGesture();this._dragOrigin=undefined;this._updateHandles(e,true);this.getViewport().setShouldRenderFrame();}};
S.prototype.contextMenu=function(e){if(this._inside(e)){this._updateMouse(e);this._updateHandles(e,true);if(this._handleIndex>=0){e.handled=true;var m=new M({items:[new a({text:g().getText("TOOL_COORDINATE_SYSTEM_WORLD"),key:C.World}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_LOCAL"),key:C.Local}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_SCREEN"),key:C.Screen}),new a({text:g().getText("TOOL_COORDINATE_SYSTEM_CUSTOM"),key:C.Custom})],itemSelected:function(e){var i=e.getParameters("item").item;this._tool.setCoordinateSystem(i.getKey());}.bind(this)});m.openAsContextMenu(e.event,this.getViewport());}}};
S.prototype.getViewport=function(){return this._tool._viewport;};
S.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
S.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d===null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return S;});
sap.ui.predefine('sap/ui/vk/totara/CallbackHandler',[],function(){"use strict";var C=function(){this.callbacks=[];};
C.prototype.attach=function(c){this.callbacks.push(c);};
C.prototype.detach=function(c){var i=this.callbacks.indexOf(c);if(i!==-1){this.callbacks.splice(i,1);return true;}return false;};
C.prototype.execute=function(a){for(var i=0;i<this.callbacks.length;i++){this.callbacks[i](a);}};
C.prototype.detachAll=function(){this.callbacks=[];};
return C;});
sap.ui.predefine('sap/ui/vk/totara/GeometryFactory',["./IndexCompressor"],function(I){"use strict";var a=1;var H=2;var b=4;var V=0;var c=3;var G=function(){};
G.getGeometryInfo=function(g,f){var h=new DataView(f.buffer,f.byteOffset,f.byteLength);var o=0;var k=(g.flags&H)>0;var l=(g.flags&b)>0;var m=(g.flags&a)>0;var n=false;var p=[];var q=[];var u=[];var r=[];var s=1;var t=1;var v=1;var w=new THREE.Vector3(0,0,0);var x=[w.x-s/2,w.y-t/2,w.z-v/2,w.x+s/2,w.y+t/2,w.z+v/2];var y=new I(f,f.length);y.setCurByte(o);if(!y.ReadCommand()){throw"buffer over flow";}var z=y.rvalue;var A;if(z){A=U(y,g.pointCount,z,x,p);if(A.isOk){p=A.array;n=true;}else{return false;}}var B=1;if(k){if(!y.ReadCommand()){return false;}B=y.rvalue;if(B){A=d(y,g.pointCount,B);if(A.isOk){q=A.array;}else{return false;}}}var C=1;var N=false;if(l){if(!y.ReadCommand()){return false;}C=y.rvalue;if(C){A=e(y,g.pointCount,C);if(A.isOk){N=true;u=A.array;}else{return false;}}}if(!z||!B||!C||N){if(N){o=y.getCurByte();var D=h.getFloat32(o,true);var E=h.getFloat32(o+4,true);y.moveCurByte(8);if((D!==0.0)||(E!==1.0)){var F=E-D;for(var J=0;J<g.pointCount*2;J++){u[J]=u[J]*F+D;}}}var K;if(!z){o=y.getCurByte();for(K=0;K<g.pointCount;K++){p.push(h.getFloat32(o+K*4,true));p.push(h.getFloat32(o+(K+g.pointCount)*4,true));p.push(h.getFloat32(o+(K+g.pointCount*2)*4,true));}y.moveCurByte(g.pointCount*3*4);}if(!B){o=y.getCurByte();for(K=0;K<g.pointCount;K++){q.push(h.getFloat32(o+(K)*4,true));q.push(h.getFloat32(o+(K+g.pointCount*1)*4,true));q.push(h.getFloat32(o+(K+g.pointCount*2)*4,true));}y.moveCurByte(g.pointCount*3*4);}if(!C){if(l){o=y.getCurByte();for(K=0;K<g.pointCount;K++){u.push(h.getFloat32(o+(K)*4,true));u.push(h.getFloat32(o+(K+g.pointCount*1)*4,true));}y.moveCurByte(g.pointCount*2*4);}}}var L=y.getCurByte();y.Reset();y.setCurByte(L);var M=[0,0,0];var O=m?2:3;for(var i=0;i<g.elementCount;i++){for(var j=0;j<O;j++){if(!y.ReadCommand(M[j])){throw"UIC1 Decompression error!!!";}else{r.push(y.rvalue);M[j]=y.rvalue;}}}return{id:g.id,isPolyline:m,isPositionQuantized:n,data:{indices:r,points:p,normals:q,uvs:u}};};
function U(f,p,n,g){var r={array:new Array(p*3),isOk:false};for(var x=0;x<3;x++){var v=g[V+x];var q=(g[c+x]-v)/n;for(var i=0;i<p;i++){if(!f.ReadCommand()){return r;}r.array[i*3+x]=q*f.rvalue+v;}}r.isOk=true;return r;}
function d(i,p,n){var r={array:[],isOk:false};var t=[];var f;for(f=0;f<p;f++){if(!i.ReadCommand()){return r;}t.push(i.rvalue);}var q=2*Math.PI/n;var g;var h;var k;for(f=0;f<p;f++){if(!i.ReadCommand()){return r;}g=q*t[f];h=q*i.rvalue;k=Math.sin(h);r.array.push(k*Math.cos(g));r.array.push(k*Math.sin(g));r.array.push(Math.cos(h));}r.isOk=true;return r;}
function e(f,p,n){var r={array:new Array(p*2),isOk:false};var q=1.0/n;for(var u=0;u<2;u++){for(var i=0;i<p;i++){if(!f.ReadCommand()){return false;}r.array[i*2+u]=q*f.rvalue;}}r.isOk=true;return r;}
return G;});
sap.ui.predefine('sap/ui/vk/totara/IndexCompressor',[],function(){"use strict";var I=function(b,a){var V=32;var c=16;var C=13;var e=14;var f=0;var g=1;var h=3;var i=4;var k=5;var l=6;var m=7;var n=8;var o=9;var p=10;var q=11;var r=12;var s=15;var E=0;var t=1;var u=2;var v=3;var w=4;var x=5;var y=6;var z=7;var A=8;var B=9;var D=10;var F=11;var G=12;var H=13;var J=4294967295;var K=0;this.rvalue=0;var L=0;var M=b;var N=a;var O=0;var P=new Array(V);var Q=new Array(c);var R=V-1;var S=c-1;var T=false;this.Reset=function(){K=0;this.rvalue=0;L=0;O=0;var j;for(j=0;j<V;j++){P[j]=V-j-1;}for(j=0;j<c;j++){Q[j]=1;}R=V-1;S=c-1;};this.Reset();function U(d){return P[(R>=d)?(R-d):(V+R-d)];}function W(d){return Q[(S>=d)?(S-d):(c+S-d)];}function X(d){R++;if(R>=V){R=0;}P[R]=d;}function Y(d){S++;if(S>=c){S=0;}Q[S]=d;}function Z(){if(O<N){return M[O++];}T=true;return 0;}function $(){return Z()+Z()*256;}function _(){return Z()+Z()*256+Z()*65536+Z()*16777216;}this.ReadCommand=function(j){if(j===undefined){j=J;}T=false;var a1=this.rvalue;if(K){K--;this.rvalue=U(L);}else{var b1=Z();if(T){b1=g;}var c1=b1>>>4;switch(b1&0xF){case f:this.rvalue=U(c1);break;case k:this.rvalue=U(16+c1);break;case C:this.rvalue=U(c1>>>2);L=c1&3;K=1;break;case e:this.rvalue=U(0);L=0;K=c1+2;break;case l:this.rvalue+=W(c1);break;case g:if(b1&16){this.rvalue+=(b1>>>5)+1;}else{this.rvalue-=(b1>>>5)+1;}break;case h:this.rvalue=j+(c1+1);break;case i:this.rvalue=j-(c1+1);break;case m:this.rvalue=j+(c1+17);break;case n:this.rvalue=j-(c1+17);break;case o:this.rvalue+=c1+((Z())<<4)+3;break;case p:this.rvalue-=c1+((Z())<<4)+3;break;case q:this.rvalue=c1+((Z())<<4);break;case r:var d1=$();this.rvalue=c1+(d1<<4);break;case s:switch(b1>>>4){case E:case t:case u:case v:case w:this.rvalue=b1>>>4;break;case x:this.rvalue=0x000000FF;break;case y:this.rvalue=0x0000FF00;break;case z:this.rvalue=0x00FF0000;break;case A:this.rvalue=0xFF000000;break;case B:this.rvalue=0x00FFFFFF;break;case D:this.rvalue=0xFFFFFFFF;break;case H:L=0;K=$()+36;break;case F:{var bl=Z();this.rvalue=($()<<8)+bl;}break;case G:this.rvalue=_();break;default:return false;}break;default:return false;}}if(this.rvalue>0xFFFFFFFF){this.rvalue=this.rvalue-0xFFFFFFFF-1;}X(this.rvalue);var d;if(this.rvalue!=a1){if(this.rvalue>a1){d=this.rvalue-a1;if(d<0x7FFFFFFF){Y(d);}}else{d=a1-this.rvalue;if(d<0x7FFFFFFF){Y(-d);}}}if(T){K=0;this.rvalue=0;return false;}return true;};this.getCurByte=function(){return O;};this.setCurByte=function(d){O=d;};this.moveCurByte=function(d){O=O+d;};};return I;});
sap.ui.predefine('sap/ui/vk/totara/ProgressCounter',[],function(){"use strict";
function C(){this._count=0;this._total=0;var o;this.setOnValueChanged=function(c){o=c;};this.callOnValueChanged=function(){if(o){o();}};}
var p=C.prototype;Object.defineProperty(p,"count",{get:function(){return this._count;},set:function(v){if(v!==this._count){this._count=v;this.callOnValueChanged();}}});Object.defineProperty(p,"total",{get:function(){return this._total;},set:function(v){if(v!==this._total){this._total=v;this.callOnValueChanged();}}});var P=function(){var o;function a(){if(o){o(this);}}this.mesh=new C();this.geometry=new C();this.mesh.setOnValueChanged(a);this.geometry.setOnValueChanged(a);this.setOnProgressChanged=function(c){o=c;};};return P;});
sap.ui.predefine('sap/ui/vk/totara/RequestQueue',["./TotaraUtils","./Command"],function(T,C){"use strict";
function R(b){this.batchSize=b;this.globalList=new Set();this.requestedList=[];this.waitingList=new Set();}
R.prototype.push=function(i,r){i=i.toString();if(!this.globalList.has(i)){this.globalList.add(i);this.requestedList.push(r||i);this.waitingList.add(i);}};
R.prototype.fetchBatch=function(){return this.requestedList.splice(0,this.batchSize);};
R.prototype.pop=function(i){i=i.toString();return this.waitingList.delete(i);};
R.prototype.isReady=function(i){i=i.toString();return this.globalList.has(i)&&!this.waitingList.has(i);};
R.prototype.clear=function(){this.globalList.clear();this.requestedList=[];this.waitingList.clear();};
R.prototype.isEmpty=function(){return this.requestedList.length===0;};
R.prototype.isWaiting=function(){return this.waitingList.size>0;};
function P(b){R.call(this,b);this.priorityMap=new Map();}
P.prototype=Object.create(R.prototype);P.prototype.constructor=P;
P.prototype.push=function(i,p){if(!this.globalList.has(i)){this.globalList.add(i);this.requestedList.push(i);this.waitingList.add(i);this.priorityMap.set(i,p);}};
P.prototype.clear=function(){R.prototype.clear.call(this);this.priorityMap.clear();};
P.prototype.fetchBatch=function(){var p=this.priorityMap;this.requestedList.sort(function(a,b){return p.get(b)-p.get(a);});var d=R.prototype.fetchBatch.call(this);d.forEach(p.delete,p);return d;};
var c=function(a,s){this.context=a;this.sceneId=s;this.token=a.token||T.generateToken();this.meshes=new R(128);this.materials=new R(128);this.images=new R(1);this.geometries=new P(32);this.geomMeshes=new P(32);this.annotations=new R(128);this.views=new R(1);this.tracks=new R(128);this.sequences=new R(128);this.highlights=new R(1);};
c.prototype.isEmpty=function(){return this.meshes.isEmpty()&&this.annotations.isEmpty()&&this.materials.isEmpty()&&this.images.isEmpty()&&this.geometries.isEmpty()&&this.geomMeshes.isEmpty()&&this.views.isEmpty()&&this.tracks.isEmpty()&&this.sequences.isEmpty()&&this.highlights.isEmpty();};
c.prototype.isWaitingForContent=function(){return this.meshes.isWaiting()||this.images.isWaiting()||this.materials.isWaiting()||this.geometries.isWaiting()||this.geomMeshes.isWaiting()||this.annotations.isWaiting()||this.views.isWaiting()||this.tracks.isWaiting()||this.sequences.isWaiting()||this.highlights.isWaiting();};
c.prototype.clearContent=function(){this.meshes.clear();this.annotations.clear();this.materials.clear();this.images.clear();this.geometries.clear();this.geomMeshes.clear();this.views.clear();this.tracks.clear();this.sequences.clear();this.highlights.clear();};
c.prototype.createGetContentCommand=function(a,i,e){var o={sceneId:this.sceneId,ids:i.map(function(b){return parseInt(b,10);}),token:this.token};return T.createRequestCommand(a,e?Object.assign(o,e):o);};
c.prototype.generateRequestCommand=function(){var i;var a=null;if(!this.meshes.isEmpty()){i=this.meshes.fetchBatch();a=this.createGetContentCommand(C.getMesh,i);}else if(!this.annotations.isEmpty()){i=this.annotations.fetchBatch();a=this.createGetContentCommand(C.getAnnotation,i);}else if(!this.materials.isEmpty()){i=this.materials.fetchBatch();a=this.createGetContentCommand(C.getMaterial,i);}else if(!this.geometries.isEmpty()){i=this.geometries.fetchBatch();a=this.createGetContentCommand(C.getGeometry,i);a.sceneId=this.sceneId;a.geometryIds=i;}else if(!this.geomMeshes.isEmpty()){i=this.geomMeshes.fetchBatch();a=this.createGetContentCommand(C.getMesh,i,{$expand:"geometry"});a.sceneId=this.sceneId;a.meshIds=i;}else if(!this.images.isEmpty()){i=this.images.fetchBatch();a=this.createGetContentCommand(C.getImage,[i[0].imageId]);a.sceneId=this.sceneId;a=Object.assign(a,i[0]);}else if(!this.sequences.isEmpty()){i=this.sequences.fetchBatch();a=this.createGetContentCommand(C.getSequence,i);}else if(!this.tracks.isEmpty()){i=this.tracks.fetchBatch();a=this.createGetContentCommand(C.getTrack,i);}else if(!this.views.isEmpty()){i=this.views.fetchBatch();a=T.createRequestCommand(C.getView,{sceneId:this.sceneId,groupId:i[0].viewGroupId,id:i[0].viewId,includeHidden:this.context.includeHidden!==undefined?this.context.includeHidden:false,includeAnimation:this.context.includeAnimation!==undefined?this.context.includeAnimation:true,token:this.token});}else if(!this.highlights.isEmpty()){i=this.highlights.fetchBatch();a=T.createRequestCommand(C.getHighlightStyle,{sceneId:this.sceneId,id:i[0],token:this.token});}return a;};
return c;});
sap.ui.predefine('sap/ui/vk/totara/SceneContext',["sap/base/Log","./CallbackHandler","./TotaraUtils","./GeometryFactory","./ProgressCounter","./RequestQueue"],function(L,C,T,G,P,R){"use strict";var S=function(s,p,l){this.root=null;this.onActiveCameraCallbacks=new C();this.onInitialSceneFinishedCallbacks=new C();this.onPartialRetrievalFinishedCallbacks=new C();this.onSceneCompletedCallbacks=new C();this.onSetPlaybackCallbacks=new C();this.onViewFinishedCallbacks=new C();this.onViewPartialRetrievalFinishedCallbacks=new C();this.onViewGroupFinishedCallbacks=new C();Object.assign(this,p);this.sceneId=s;this.loader=l;this.sceneBuilder=l.sceneBuilder;this.requestQueue=new R(this,s);this.phase=S.Phase.Started;this.retrievalType=S.RetrievalType.Initial;this.rootNodeId=null;this.annotationNodeMap=new Map();this.leaderLineMaterialIdMap=new Map();this.imageNoteMaterialIdMap=new Map();this.thumbnailViewMap=new Map();this.viewThumbnailMap=new Map();this.viewAnimatedThumbnailMap=new Map();this.texturesToUpdate=new Map();this.geometryIdMaterialIdMap=new Map();this.progressCount=new P();this.treeNodes=[];this.viewIdTreeNodesMap=new Map();this.nodeSidsForPartialTree=new Set();this.replacedNodes=new Map();this.updatedNodes=new Set();this.authorizationHandler=null;this.currentViewId=null;this.initialViewId=null;this.initialViewDecided=false;};S.Phase={Started:0,FinishedHierarchy:1,FinishedMesh:2,FinishedGeometry:3};S.RetrievalType={Initial:0,Partial:1};
S.prototype.setOnProgressChanged=function(c){this.progressCount.setOnProgressChanged(c);};
S.prototype.isLoadingFinished=function(){if(!this.requestQueue.isEmpty()||this.requestQueue.isWaitingForContent()||this.texturesToUpdate.size>0||this.thumbnailViewMap.size>0||this.viewThumbnailMap.size>0||this.viewAnimatedThumbnailMap.size>0||this.annotationNodeMap.size>0||this.leaderLineMaterialIdMap.size>0||this.imageNoteMaterialIdMap.size>0||this.viewIdTreeNodesMap.size>0||this.nodeSidsForPartialTree.size>0){return false;}return true;};
S.prototype.isSceneCompleted=function(){return!this.requestQueue.meshes.isWaiting()&&!this.requestQueue.materials.isWaiting()&&!this.requestQueue.geomMeshes.isWaiting()&&!this.requestQueue.geometries.isWaiting()&&!this.requestQueue.images.isWaiting();};
S.prototype._checkSceneCompletion=function(){if(this.isSceneCompleted()){this.sceneBuilder.finalizeHighlightsInViews();this.onSceneCompletedCallbacks.execute();L.info("Scene completed.");T.mark("sceneCompleted");this.logPerformance("sceneCompleted");}};
S.prototype.dispose=function(){this.sceneId=null;this.progressCount=null;this.requestQueue=null;this.suppressedBoundingBoxListMap=null;this.treeNodes=null;this.nodeSidsForPartialTree=null;this.annotationNodeMap=null;this.leaderLineMaterialIdMap=null;this.imageNoteMaterialIdMap=null;this.thumbnailViewMap=null;this.viewThumbnailMap=null;this.viewAnimatedThumbnailMap=null;this.texturesToUpdate=null;this.geometryIdMaterialIdMap=null;this.replacedNodes=null;this.updatedNodes=null;this.viewIdTreeNodesMap=null;this.onActiveCameraCallbacks=null;this.onInitialSceneFinishedCallbacks=null;this.onPartialRetrievalFinishedCallbacks=null;this.onViewPartialRetrievalFinishedCallbacks=null;this.onSceneCompletedCallbacks=null;this.onViewFinishedCallbacks=null;this.onSetPlaybackCallbacks=null;};
S.prototype.logPerformance=function(n){if(this.progressLogger&&this.token){this.progressLogger.logPerformance(n,this.token);}};
S.prototype.setCameraSingle=function(c){this.sceneBuilder.createCamera(c,this.sceneId);return this.sceneBuilder.getCamera(c.id);};
S.prototype.getPartialTreeNodes=function(t){var p=[];var a=[];var i,j,b;if(t&&t.length){for(i=0;i<t.length;i++){b=t[i];if(b==null){continue;}if(b&&b.children){if(b.entityId!=null&&b.children.length===1){var r=b.children[0];var c=t[r];if(c.entityId==null){c.name=b.name;b.visualisable=false;}}if(b.children){for(j=0;j<b.children.length;j++){var d=b.children[j];t[d].parentNode=b;if(b.renderOrder){t[d].renderOrder=b.renderOrder;}}}}}}if(t&&t.length){for(i=0;i<t.length;i++){b=t[i];if(b==null){continue;}if(b.parent){p.push(b);}else if(!b.parentNode){p.push(b);if(this.rootNodeId){b.parent=this.rootNodeId;}}if(this.nodeSidsForPartialTree.has(b.sid)){a.push(b);}}}this.nodeSidsForPartialTree.clear();if(!a.length){return p;}p=[];for(j=0;j<a.length;j++){var n=a[j];var e=n.parentNode;while(e){if(this.sceneBuilder.getNode(e.sid,this.sceneId)){n.parent=e.sid;p.push(n);break;}else{n=e;e=e.parentNode;}}}return p.length?p:a;};
S.prototype.buildTree=function(){var r={};if(!this.treeNodes||!this.treeNodes.length){r.error="no tree information";return r;}var t=this.treeNodes;var p=this.getPartialTreeNodes(t);this.replacedNodes.clear();var a=[];var i;var b;for(i=0;i<p.length;i++){b=p[i].parent;if(this.sceneBuilder.getNode(b,this.sceneId)){this.buildNode(p[i],b);}else{a.push(p[i]);}}for(i=0;i<a.length;i++){b=a[i].parent;if(this.sceneBuilder.getNode(b,this.sceneId)){this.buildNode(p[i],b);}else{r.error=(r.error||"")+"parent ${parentSid} does not exist in the scene. \n";}}this.treeNodes=[];this.progressCount.mesh.total=this.requestQueue.meshes.globalList.size;return r;};
S.prototype.buildNode=function(t,p){if(!t||!p){this.loader.reportError(this,"SceneContext - buildNode - invalid args");return;}var e=this.sceneBuilder.getNode(t.sid,this.sceneId);if(e){this.sceneBuilder.remove(t.sid,this.sceneId);}if(t.suppressed===true){return;}if(!t.sid){this.loader.reportError(this,"sid is missing in treeNode");return;}t.parentId=p;this.sceneBuilder.createNode(t,this.sceneId);if(t.meshId&&!this.sceneBuilder.hasMesh(t.meshId)){this.requestQueue.meshes.push(t.meshId);}if(t.annotationId){this.annotationNodeMap.set(t.annotationId,t.sid);this.requestQueue.annotations.push(t.annotationId);}var n=this.sceneBuilder.getNode(t.sid,this.sceneId);if(e&&n){this.replacedNodes.set(e,n);}if(t.children){var a=this.treeNodes;for(var i=0;i<t.children.length;i++){var b=t.children[i];this.buildNode(a[b],t.sid);}}};
S.prototype.setTree=function(j){if(j.sid){var r=this.sceneBuilder.getNode(j.sid,this.sceneId);if(!r||r!==this.root){var a=this.root;a.userData.treeNode={sid:j.sid,name:this.root.name?this.root.name:"root"};a.userData.skipIt=!this.root.name;this.sceneBuilder.setRootNode(a,j.sid,this.sceneId,this.vkScene);this.rootNodeId=j.sid;}}if(j.camera){j.camera.id="initial";var c=this.setCameraSingle(j.camera);if(c){this.onActiveCameraCallbacks.execute(c);}}T.measure("setTreeMeasure-"+this.sceneId,"setTree-"+this.sceneId);};
S.prototype.setTreeNode=function(j){if(!Array.isArray(j.nodes)){return{error:"setTreeNode error: nodes are not properly defined"};}this.treeNodes=this.treeNodes.concat(j.nodes);return{};};
S.prototype.notifyFinishedTree=function(c){this.buildTree();this.phase=S.Phase.FinishedHierarchy;if(!this.loader._pushMesh){if(!this.requestQueue.meshes.isWaiting()){if(this.retrievalType===S.RetrievalType.Initial){this.onInitialSceneFinishedCallbacks.execute(this.initialView);}if(this.retrievalType===S.RetrievalType.Partial){this.onPartialRetrievalFinishedCallbacks.execute();}this.onViewPartialRetrievalFinishedCallbacks.execute();this._checkSceneCompletion();}}return{};};
S.prototype.setViewGroup=function(j){this.sceneBuilder.insertViewGroup(j,this.sceneId);if(!Array.isArray(j.views)){return;}var v=j.id;var i,a;if(!this.currentViewGroupId){if(this.currentViewId){for(i=0;i<j.views.length;i++){a=j.views[i];if(a.id===this.currentViewId){this.currentViewGroupId=v;break;}}}else{this.currentViewGroupId=v;}}if(this.currentViewGroupId!==v){return;}for(i=0;i<j.views.length;i++){a=j.views[i];var e=this.sceneBuilder.getView(a.id,this.sceneId);for(var t=0;t<1;t++){var p=["thumbnailId","animatedThumbnailId"][t];var b=a[p];if(b!==undefined){a[p]=b=b.toString();if(this.sceneBuilder.hasImage(b)){this.sceneBuilder.setViewThumbnail(b,a.id,this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();}else{this.thumbnailViewMap.set(b,a.id);this.requestQueue.images.push(b,{imageId:b,viewId:a.id});}if(!e){this[["viewThumbnailMap","viewAnimatedThumbnailMap"][t]].set(a.id,b);}}}if(e){e.userData.viewInfo.thumbnailId=a.thumbnailId;continue;}this.requestQueue.views.push(a.id,{viewId:a.id,viewGroupId:v});}if(!this.requestQueue.views.isWaiting()){this.sceneBuilder.finalizeViewGroups(this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();if(this.requestQueue.sequences.isEmpty()){this.onViewGroupFinishedCallbacks.execute();}this.sceneBuilder.finalizeHighlightsInViews();}T.measure("setViewGroupMeasure-"+v,"setViewGroup-"+v);};
S.prototype.setView=function(j){var v=j.viewId;if(!v){this.setTree(j);this.initialViewDecided=true;return;}if(!this.initialViewId&&!this.initialViewDecided){this.initialViewId=v;this.currentViewId=v;this.initialViewDecided=true;}var c;if(this.initialViewId===v){if(j.camera){c=j.camera.id;}this.setTree(j);}var t=this.viewThumbnailMap.get(v);if(t){this.viewThumbnailMap.delete(v);j.thumbnailId=t;}var a=this.viewAnimatedThumbnailMap.get(v);if(a){this.viewAnimatedThumbnailMap.delete(v);j.animatedThumbnailId=a;}this.sceneBuilder.insertView(j,this.sceneId);var b=[];this.viewIdTreeNodesMap.set(v,b);if(j.camera){if(c){j.camera.id=c;}this.setCameraSingle(j.camera);this.sceneBuilder.setViewCamera(j.camera.id,v,this.sceneId);}this.logPerformance("setView");T.measure("setViewMeasure-"+v,"setView-"+v);};
S.prototype.setViewNode=function(c){var r={context:this};if(!c.viewId){this.setTreeNode(c);return r;}if(this.initialViewId===c.viewId){this.setTreeNode(c);}var v=this.sceneBuilder.getView(c.viewId,c.sceneId);if(!v){r.error="setViewNode error: setViewNode - no setView was in the chain";return r;}if(this.initialViewId===c.viewId){this.initialView=v;}var t=this.viewIdTreeNodesMap.get(c.viewId);t=t.concat(c.nodes);this.viewIdTreeNodesMap.set(c.viewId,t);return r;};
S.prototype.notifyFinishedView=function(j){var v=j.viewId;if(!v){return this.notifyFinishedTree(j);}this.requestQueue.views.pop(v);if(this.initialViewId===v){this.notifyFinishedTree(j);this.initialViewId=null;}var a=this.sceneBuilder.getView(v,this.sceneId);if(!a){return{error:"notifyFinishedView error: setViewNode - no setView was in the chain"};}if(a.activeCameraId!==undefined){a.camera=this.sceneBuilder.getCamera(a.activeCameraId);}this.updatedNodes.clear();var b=this.buildView(v);this.sceneBuilder.setViewNodeInfos(b.nodeInfos,v,this.sceneId);a.updatedNodes=Array.from(this.updatedNodes);if(!this.requestQueue.views.isWaiting()){this.sceneBuilder.finalizeViewGroups(this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();if(this.requestQueue.sequences.isEmpty()){this.onViewGroupFinishedCallbacks.execute();}this.sceneBuilder.finalizeHighlightsInViews();}if(!this.requestQueue.meshes.isWaiting()){this.onViewFinishedCallbacks.execute(a);}else{var c=function(){setTimeout(function(){this.onViewPartialRetrievalFinishedCallbacks.detach(c);}.bind(this),0);this.onViewFinishedCallbacks.execute(a);}.bind(this);this.onViewPartialRetrievalFinishedCallbacks.attach(c);this.logPerformance("notifyFinishedView");}};
S.prototype.buildView=function(v){var r={};this.treeNodes=this.viewIdTreeNodesMap.get(v);if(!this.treeNodes||!this.treeNodes.length){r.error="no tree information in view";return r;}var p=this.getPartialTreeNodes(this.treeNodes);var n=[];for(var i=0;i<p.length;i++){var a=p[i].parent;this.processNode(v,p[i],n,a);}r.nodeInfos=n;this.treeNodes=[];this.viewIdTreeNodesMap.delete(v);return r;};
S.prototype.buildViewNode=function(v,t,n){if(!t){this.loader.reportError(this,"ViewBuilder - buildViewNode - invalid args");return;}var a=this.sceneBuilder.getNode(t.sid,this.sceneId);if(t.materialId){if(!this.sceneBuilder.checkMaterialExists(t.materialId,true)){this.requestQueue.materials.push(t.materialId);}}var b={target:a,visible:t.visible!==undefined?t.visible:true,materialId:t.materialId,opacity:t.opacity,meshId:t.meshId,transform:Array.isArray(t.transform)?T.arrayToColumnMajorMatrixArray16(t.transform):[1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0]};n.push(b);var c=this.treeNodes;var e=this.sceneBuilder.getChildNodeIds(t.sid,this.sceneId);var d=t.children?t.children.map(function(o){return c[o].sid;}):[];var f;var i;for(i=0;i<e.length;i++){f=e[i];for(var j=0;j<d.length;j++){if(f===d[j]){e[i]=undefined;break;}}}for(i=0;i<e.length;i++){var g=e[i];if(g!==undefined){var h=this.sceneBuilder.getNode(g,this.sceneId);var k=false;n.push({target:h,visible:k});}}if(t.children){for(i=0;i<t.children.length;i++){var l=t.children[i];var m=this.treeNodes[l];this.processNode(v,m,n,t.sid);}}};
S.prototype.processNode=function(v,t,n,p){var a=this.sceneBuilder.getNode(t.sid,this.sceneId);if(a){this.buildViewNode(v,t,n);}else{this.buildNode(t,p);var b=this.sceneBuilder.getNode(t.sid,this.sceneId);if(b){b.visible=false;n.push({target:b,visible:t.visible===undefined?true:t.visible});}}if(t.highlightStyleId){this.sceneBuilder.recordHighlightedNodeInView(t.highlightStyleId,t.sid,v,this.sceneId);if(!this.sceneBuilder.highlightStyleExists(t.highlightStyleId)){this.requestQueue.highlights.push(t.highlightStyleId);}}};
S.prototype.setAnnotationSingle=function(a){var n=this.annotationNodeMap.get(a.id);if(n){a.nodeId=n;if(a.detailView||a.cutaway){this.sceneBuilder.createDetailView(a,this.sceneId);}else if(a.labelMaterialId||(a.label&&a.label.materialId)){var m=a.labelMaterialId||a.label.materialId;if(this.sceneBuilder.checkMaterialExists(m,false)){this.sceneBuilder.createImageNote(a,this.sceneId);}else{this.requestQueue.materials.push(m);T.pushElementIntoMapArray(this.imageNoteMaterialIdMap,m,a);}}else{this.sceneBuilder.createAnnotation(a,this.sceneId);var b=a.leaderLines;if(b){for(var i=0,l=b.length;i<l;i++){var c=b[i];c.annotationId=a.id;if(this.sceneBuilder.checkMaterialExists(c.materialId,false)){this.sceneBuilder.insertLeaderLine(c,this.sceneId);}else{this.requestQueue.materials.push(c.materialId);T.pushElementIntoMapArray(this.leaderLineMaterialIdMap,c.materialId,{annotationId:a.id,leaderLine:c});}}}}this.annotationNodeMap.delete(a.id);this.requestQueue.annotations.pop(a.id);}};
S.prototype.setCamera=function(j){if(!Array.isArray(j.cameras)){return{error:"setCamera error: cameras are not properly defined"};}j.cameras.forEach(this.setCameraSingle.bind(this));};
S.prototype.setMeshSingle=function(m){var a=m.id;if(this.requestQueue.meshes.pop(a)){if(Array.isArray(m.submeshes)){var b=new THREE.Box3();var p=new THREE.Vector3();for(var i=0;i<m.submeshes.length;i++){var s=m.submeshes[i];s.meshId=a;if(!this.sceneBuilder.checkMaterialExists(s.materialId,true)){this.requestQueue.materials.push(s.materialId);}this.sceneBuilder.insertSubmesh(s);var l=s.lods;if(Array.isArray(l)){for(var c=0;c<l.length;c++){var d=l[c].boundingBox;if(Array.isArray(d)&&d.length===6){b.min.min(p.fromArray(d));b.max.max(p.fromArray(d,3));}}}}b.getSize(p);this.requestQueue.geomMeshes.push(a,p.length());}this.progressCount.mesh.count++;if(!this.requestQueue.meshes.isWaiting()){this.phase=S.Phase.FinishedMesh;this.logPerformance("meshFinished");if(this.retrievalType===S.RetrievalType.Initial){this.onInitialSceneFinishedCallbacks.execute(this.initialView);}else if(this.retrievalType===S.RetrievalType.Partial){this.onPartialRetrievalFinishedCallbacks.execute();}this.onViewPartialRetrievalFinishedCallbacks.execute();this.progressCount.geometry.total=this.requestQueue.geometries.globalList.size;}}else{this.requestQueue.geomMeshes.pop(a);}};
S.prototype.setMesh=function(j,b){if(!Array.isArray(j.meshes)){return{error:"setMesh error: meshes are not properly defined"};}if(b){var d=new DataView(b.buffer);var a=d.getUint16(2,true),o=0;while(a-->0&&o<b.byteLength){var g={sceneId:this.sceneId,id:d.getUint32(o+4,true).toString(),box:[d.getFloat32(o+14,true),d.getFloat32(o+18,true),d.getFloat32(o+22,true),d.getFloat32(o+26,true),d.getFloat32(o+30,true),d.getFloat32(o+34,true)]};var c=d.getUint16(o+12,true);o+=38;if(c!==3){g.flags=d.getUint16(o,true);g.quality=d.getFloat32(o+4,true);g.pointCount=d.getUint16(o+8,true);g.elementCount=d.getUint16(o+10,true);o+=14;}var e=d.getUint32(o,true);var f=b.subarray(o+4,o+4+e);o+=e;this.setGeometry(g,f);}}j.meshes.forEach(this.setMeshSingle.bind(this));T.measure("setMeshMeasure-"+this.sceneId,"setMesh-"+this.sceneId);this._checkSceneCompletion();};
S.prototype.setMaterialSingle=function(m){var a=m.id;this.requestQueue.materials.pop(a);var t=this.sceneBuilder.createMaterial(m);var b=this.sceneBuilder.getMaterial(a);if(!b.userData.idsOfImagesToRead){b.userData.idsOfImagesToRead=new Set();}else{b.userData.idsOfImagesToRead.clear();}if(t.length){for(var c=0;c<t.length;c++){var p=t[c];var d=this.texturesToUpdate;var e=d.get(p.imageId);if(!e){e=[];d.set(p.imageId,e);}e.push({textureType:p.textureType,materialId:a});if(!this.sceneBuilder.hasImage(p.imageId)){this.requestQueue.images.push(p.imageId,{imageId:p.imageId,materialId:a});b.userData.idsOfImagesToRead.add(p.imageId);}}}var i;var l=this.leaderLineMaterialIdMap.get(a);if(l){this.leaderLineMaterialIdMap.delete(a);for(i=0;i<l.length;i++){this.sceneBuilder.insertLeaderLine(l[i].leaderLine,this.sceneId);}}var f=this.imageNoteMaterialIdMap.get(a);if(f){this.imageNoteMaterialIdMap.delete(a);for(i=0;i<f.length;i++){this.sceneBuilder.createImageNote(f[i],this.sceneId);}}this.loader.onMaterialFinishedCallbacks.execute(a);};
S.prototype.setMaterial=function(j){if(!Array.isArray(j.materials)){return{error:"setMaterial error: materials are not properly defined"};}j.materials.forEach(this.setMaterialSingle.bind(this));T.measure("setMaterialMeasure-"+this.sceneId,"setMaterial-"+this.sceneId);this._checkSceneCompletion();};
S.prototype.setGeometry=function(j,b){var g=j.id;this.requestQueue.geometries.pop(g);if(j.data&&!b){b=T.base64ToUint8Array(j.data);}if(!b||b.length===0){return{error:"setGeometry error: no data for geometry "+g};}var a=G.getGeometryInfo(j,b);if(!a){return{error:"setGeometry error: failed to parse geometry "+g+" data"};}this.sceneBuilder.setGeometry(a);this.loader.onSetGeometryCallbacks.execute({id:g});if(!this.requestQueue.geometries.isWaiting()){this.phase=S.Phase.FinishedGeometry;this.logPerformance("geometryFinished");}this.progressCount.geometry.count++;T.measure("setGeometryMeasure-"+g,"setGeometry-"+g);this._checkSceneCompletion();};
S.prototype.setImage=function(j,b){var a=j.id;var t=j.tileWidth;this.requestQueue.images.pop(a);if(!b){return{error:"setImage error: no image content for "+a};}j.binaryData=b;this.sceneBuilder.createImage(j);var v=this.thumbnailViewMap.get(a);if(v){this.thumbnailViewMap.delete(a);this.sceneBuilder.setViewThumbnail(a,v,this.sceneId,t);this.loader.onViewGroupUpdatedCallbacks.execute();}if(t){this.sceneBuilder._imageIdsAndTileWidths.set(a,t);}var c=this.texturesToUpdate.get(a);if(c){this.texturesToUpdate.delete(a);for(var i=0,l=c.length;i<l;i++){var d=c[i];this.sceneBuilder.updateTextureMap(d.materialId,d.textureType);}}this.loader.onImageFinishedCallbacks.execute({id:a});T.measure("setImageMeasure-"+a,"setImage-"+a);this._checkSceneCompletion();};
S.prototype.setAnnotation=function(j){if(!Array.isArray(j.annotations)){return{error:"setAnnotation error: annotations are not properly defined"};}j.annotations.forEach(this.setAnnotationSingle.bind(this));};
S.prototype.setHighlightStyle=function(j){this.sceneBuilder.insertHighlightStyle(j);this.requestQueue.highlights.pop(j.id);if(!this.requestQueue.highlights.isWaiting()){this.sceneBuilder.finalizeHighlightsInViews();}};
S.prototype.setPlayback=function(a){if(!Array.isArray(a.playbacks)){return{error:"setPlayback error: playbacks are not properly defined"};}var v=this.sceneBuilder.getView(a.viewId,this.sceneId);var o=false;var i,p;if(this.playbackIds){for(i=0;i<a.playbacks.length;i++){p=a.playbacks[i];for(var j=0;j<this.playbackIds.length;j++){if(p.id===this.playbackIds[j]){p.notLoading=false;break;}}if(p.notLoading===undefined){p.notLoading=true;}}delete this.playbackIds;o=true;}for(i=0;i<a.playbacks.length;i++){p=a.playbacks[i];if(p.notLoading){continue;}if(p.id==null){p.id=a.viewId+"-playback";p.sequence.id=a.viewId+"-cont";p.sequenceId=p.sequence.id;this.setSequence({sequences:[p.sequence]});}this.sceneBuilder.insertPlayback(p,a.viewId,this.sceneId);if(p.sequenceId){var e=this.sceneBuilder.getSequence(p.sequenceId);if(e){continue;}else{this.requestQueue.sequences.push(p.sequenceId);}}}if(!this.requestQueue.sequences.isEmpty()){this.loader.hasAnimation=true;}else{this.sceneBuilder.finalizeAnimation();this.sceneBuilder.finalizePlaybacks();this.sceneBuilder.finalizeHighlightsInViews();this.loader.hasAnimation=false;if(o){this.onSetPlaybackCallbacks.execute(v);}}};
S.prototype.setSequenceSingle=function(s){var a=s.id;this.requestQueue.sequences.pop(a);if(s.nodes){var n=[];var i=[];for(var b=0;b<s.nodes.length;b++){var c=s.nodes[b];if(c.rotate){var r={};if(c.rotate.trackId){r.trackId=c.rotate.trackId;this.requestQueue.tracks.push(c.rotate.trackId);}else{r.trackId=a+"ROTATE"+c.sid;c.rotate.id=r.trackId;i.push(c.rotate);}r.sid=c.sid;r.binding="ROTATE";if(c.rotate.pivot){r.pivot=c.rotate.pivot;}n.push(r);}if(c.translate){var t={};if(c.translate.trackId){t.trackId=c.translate.trackId;this.requestQueue.tracks.push(c.translate.trackId);}else{t.trackId=a+"TRANSLATE"+c.sid;c.translate.id=t.trackId;i.push(c.translate);}t.sid=c.sid;t.binding="TRANSLATE";if(c.translate.pivot){t.pivot=c.translate.pivot;}n.push(t);}if(c.scale){var d={};if(c.scale.trackId){d.trackId=c.scale.trackId;this.requestQueue.tracks.push(c.scale.trackId);}else{d.trackId=a+"SCALE"+c.sid;c.scale.id=d.trackId;i.push(c.scale);}d.sid=c.sid;d.binding="SCALE";if(c.scale.pivot){d.pivot=c.scale.pivot;}n.push(d);}if(c.opacity){var o={};if(c.opacity.trackId){o.trackId=c.opacity.trackId;this.requestQueue.tracks.push(c.opacity.trackId);}else{o.trackId=a+"OPACITY"+c.sid;c.opacity.id=o.trackId;i.push(c.opacity);}o.sid=c.sid;o.binding="OPACITY";n.push(o);}}if(i.length>0){this.setTrack({tracks:i});}s.nodes=n;}this.sceneBuilder.insertSequence(s);};
S.prototype.setSequence=function(j){if(!Array.isArray(j.sequences)){return{error:"setSequence error: sequences are not properly defined"};}j.sequences.forEach(this.setSequenceSingle.bind(this));if(this.requestQueue.tracks.isEmpty()){this.loader.hasAnimation=false;this.loader.onSetSequenceCallbacks.execute();if(!this.requestQueue.views.isWaiting()){this.onViewGroupFinishedCallbacks.execute();}}};
S.prototype.setTrack=function(j){if(!Array.isArray(j.tracks)){return{error:"setTrack error: tracks are not properly defined"};}var t=[];for(var a=0;a<j.tracks.length;a++){var b=j.tracks[a];this.requestQueue.tracks.pop(b.id);b.times=b.time;if(b.vector3){b.values=b.vector3;}else if(b.quaternion){b.values=b.quaternion;b.rotateType="quaternion";for(var v=3;v<b.values.length;v=v+4){b.values[v]=-b.values[v];}}else if(b.angleAxis){b.values=b.angleAxis;b.rotateType="angleAxis";}else if(b.euler){b.values=b.euler;b.rotateType="euler";}else if(b.scalar){b.values=b.scalar;}b.cyclicInfo={};b.cyclicInfo.cyclicStart=b.cyclicStart;b.cyclicInfo.cyclicEnd=b.cyclicEnd;t.push(b);}this.sceneBuilder.insertTracks(t);if(!this.requestQueue.tracks.isWaiting()){this.sceneBuilder.finalizeAnimation();this.sceneBuilder.finalizePlaybacks();this.sceneBuilder.finalizeHighlightsInViews();this.loader.onSetTrackCallbacks.execute();if(!this.requestQueue.views.isWaiting()&&!this.requestQueue.sequences.isWaiting()){this.onViewGroupFinishedCallbacks.execute();}}};
S.prototype.notifyError=function(j){if(!j.error){j.error="Unknown error";}return j;};
return S;});
sap.ui.predefine('sap/ui/vk/totara/TotaraLoader',["sap/base/Log","./SceneContext","./CallbackHandler","./Command","./TotaraUtils","../threejs/SceneBuilder","sap/ui/thirdparty/URI"],function(L,S,C,a,T,b,U){"use strict";var c=T.mark;var d=function(){this._pushMesh=false;this._url=null;this._cid=null;this._performanceTimingMsg=[];this._isPostable=true;this.currentSceneInfo={};this.sceneBuilder=new b();this.contextMap=new Map();this.tokenContextMap=new Map();this.onErrorCallbacks=new C();this.onImageFinishedCallbacks=new C();this.onMaterialFinishedCallbacks=new C();this.onSetGeometryCallbacks=new C();this.onSetSequenceCallbacks=new C();this.onSetTrackCallbacks=new C();this.onViewGroupUpdatedCallbacks=new C();this.onLoadingFinishedCallbacks=new C();};
d.prototype.init=function(e,f){this._url=e;this._cid=f;var t=this;return new Promise(function(r){if(!t._worker){var u=new U(sap.ui.require.toUrl("sap/ui/vk/totara/TotaraLoaderWorker.js"));if(u.is("relative")){u=u.absoluteTo(new U(location.href));}var g="'"+u.toString()+"'";if(sap.ui.Device.browser.internet_explorer){var p=new U(sap.ui.require.toUrl("sap/ui/thirdparty/es6-promise.js"));var h=new U(sap.ui.require.toUrl("sap/ui/thirdparty/es6-string-methods.js"));var i=new U(sap.ui.require.toUrl("sap/ui/vk/thirdparty/ie-polyfills.js"));if(p.is("relative")){var j=new U(location.href);p=p.absoluteTo(j);h=h.absoluteTo(j);i=i.absoluteTo(j);}g="'"+p.toString()+"','"+h.toString()+"','"+i.toString()+"',"+g;}t._worker=new Worker((window.URL||window.webkitURL).createObjectURL(new Blob(["importScripts("+g+");"],{"type":"application/javascript"})));t._worker.onmessage=function(k){var m;var n=k.data;if(n.ready){return;}if(n.name==="getAuthorization"){if(n.sceneId){m=t.getContext(n.sceneId);}if(m&&m.authorizationHandler){m.authorizationHandler(n.jsonContent.url).then(function(o){t.postMessage({"method":"setAuthorization","authorizationToken":o});}).catch(function(o){t.postMessage({"method":"setAuthorization","authorizationToken":null,"error":o.toString()});});}else{t.postMessage({"method":"setAuthorization","authorizationToken":null});}return;}if(n.name==="protocol"){t.protocolVersion=n.jsonContent.version.split(".").map(function(s){return parseInt(s,10);});return;}m=t.processCommand(n.name,n.jsonContent,n.binaryContent);if(m){t.sendRequest(m.requestQueue);}};t._worker.onerror=function(k){};}});};
d.prototype.dispose=function(){this.contextMap.forEach(function(e){e.dispose();});this.contextMap.clear();this.tokenContextMap.clear();this.postMessage({method:"close"});this._worker=undefined;this.currentSceneInfo=null;this.sceneBuilder.cleanup();this.sceneBuilder=null;this.onErrorCallbacks=null;this.onMaterialFinishedCallbacks=null;this.onImageFinishedCallbacks=null;this.onSetGeometryCallbacks=null;this.onSetTrackCallbacks=null;this.onSetSequenceCallbacks=null;};
d.prototype.cleanup=function(){this.currentSceneInfo={};this.contextMap.clear();this.tokenContextMap.clear();this.sceneBuilder.cleanup();};
d.prototype.enablePushMesh=function(e){this._pushMesh=e;};
d.prototype.getUrl=function(){return this._url;};
d.prototype.getSceneBuilder=function(){return this.sceneBuilder;};
d.prototype.getContext=function(s){return this.contextMap.get(s);};
d.prototype.createContext=function(s,p){var e=new S(s,p,this);this.contextMap.set(s,e);this.tokenContextMap.set(e.requestQueue.token,e);if(e.onActiveCamera){e.onActiveCameraCallbacks.attach(e.onActiveCamera);delete e.onActiveCamera;}if(e.onInitialSceneFinished){e.onInitialSceneFinishedCallbacks.attach(e.onInitialSceneFinished);delete e.onInitialSceneFinished;}if(e.onPartialRetrievalFinished){e.onPartialRetrievalFinishedCallbacks.attach(e.onPartialRetrievalFinished);delete e.onPartialRetrievalFinished;}if(e.onViewPartialRetrievalFinished){e.onViewPartialRetrievalFinishedCallbacks.attach(e.onViewPartialRetrievalFinished);delete e.onViewPartialRetrievalFinished;}if(e.onViewFinished){e.onViewFinishedCallbacks.attach(e.onViewFinished);delete e.onViewFinished;}if(e.onSceneCompleted){e.onSceneCompletedCallbacks.attach(e.onSceneCompleted);delete e.onSceneCompleted;}if(e.onProgressChanged){e.setOnProgressChanged(e.onProgressChanged);delete e.onProgressChanged;}if(e.onLoadingFinished){this.onLoadingFinishedCallbacks.detachAll();this.onLoadingFinishedCallbacks.attach(e.onLoadingFinished);delete e.onLoadingFinished;}return e;};
d.prototype.isLoadingFinished=function(){var e=this.contextMap.values();var f=e.next();while(!f.done){if(!f.value.isLoadingFinished()){return false;}f=e.next();}return true;};
d.prototype.decrementResourceCountersForDeletedTreeNode=function(e,n){if(e){this.sceneBuilder.decrementResourceCountersForDeletedTreeNode(n,e.sceneId);}};
function l(e,n){if(e.progressLogger){e.progressLogger.logPerformance(n,e.token);}}
d.prototype.request=function(s,e,f){if(!e.root){throw"context must include root where three js objects are attached to";}var g=this.createContext(s,e);g.token=g.requestQueue.token;this.currentSceneInfo.id=s;g.retrievalType=S.RetrievalType.Initial;g.authorizationHandler=f;g.initialRequestTime=Date.now();if(g.enableLogger){T.createLogger(s,g,this);}var i=e.includeHidden!==undefined?e.includeHidden:true;var h=e.includeAnimation!==undefined?e.includeAnimation:true;var j=e.$select!==undefined?e.$select:"name,transform,meshId,annotationId,materialId,contentType,visible,opacity,renderOrder,entityId,highlightStyleId";var p=e.pushViewGroups!==undefined?e.pushViewGroups:true;var v={pushMaterials:true,pushMeshes:this._pushMesh,sceneId:s,token:g.token,includeHidden:i,includeAnimation:h,pushViewGroups:p,pushPMI:e.pushPMI||false,metadataFilter:e.metadataFilter,$select:j};v.context=s;var k;if(e.activateView){v.id=e.activateView;g.initialViewId=e.activateView;g.currentViewId=e.activateView;g.initialViewDecided=true;}k=T.createCommand(a.getView,v);l(g,"modelRequested");c("modelRequested");this.postMessage({method:"initializeConnection",url:this._url,cid:this._cid,useSecureConnection:e.useSecureConnection,token:g.token,command:k,sceneId:s});};
d.prototype.postMessage=function(m){if(this._worker){this._worker.postMessage(m);}};
d.prototype.update=function(s,e,v){this.currentSceneInfo.id=s;var f=this.getContext(s);if(!f){return Promise.reject("no context for ${sceneVeId}");}var t=this;return new Promise(function(r,g){f.nodeSidsForPartialTree=new Set(e);f.retrievalType=S.RetrievalType.Partial;var i=f.includeHidden!==undefined?f.includeHidden:true;var h=f.includeAnimation!==undefined?f.includeAnimation:true;var j=f.$select!==undefined?f.$select:"name,transform,meshId,annotationId,materialId,contentType,visible,opacity,renderOrder,entityId";var p=f.pushViewGroups!==undefined?f.pushViewGroups:true;var o={sceneId:s,token:f.token,pushMaterials:true,pushMeshes:t._pushMesh,filter:e.join(),includeAnimation:h,includeHidden:i,pushPMI:f.pushPMI||false,metadataFilter:f.metadataFilter,pushViewGroups:p,$select:j,breadcrumbs:true};if(v){o.activateView=v;}var k=T.createCommand(a.getTree,o);var m=function(){f.onPartialRetrievalFinishedCallbacks.detach(m);l(f,"updateFinished(mesh)");var n=[];var q=[];f.replacedNodes.forEach(function(x,y){q.push(x);n.push(y);});var u=n;var w=q;r({sceneVeId:s,sids:e,replacedNodeRefs:u,replacementNodeRefs:w});};f.onPartialRetrievalFinishedCallbacks.attach(m);l(f,"updateRequested");t.postMessage({method:"update",command:k});});};
d.prototype.requestViewGroup=function(s,v,i){if(!v){return Promise.reject("invalid arg: viewGroupId undefined");}var e=this.getContext(s);if(!e){return Promise.reject("no context for ${sceneVeId}");}if(i!==undefined){e.includeAnimation=i;}var t=this;var p=new Promise(function(r,f){var g=t.sceneBuilder.getViewGroup(v,s);if(g&&g.length){r(g);return;}var o={sceneId:s,id:v,token:e.token};var h=function(){e.onViewGroupFinishedCallbacks.detach(h);l(e,"onViewGroupFinished");var j=t.sceneBuilder.getViewGroup(v,s);if(j&&j.length){r(j);}else{f("no view ground data");}};e.onViewGroupFinishedCallbacks.attach(h);e.currentViewGroupId=v;t.postMessage(T.createRequestCommand(a.getViewGroups,o));});return p;};
d.prototype.requestView=function(s,v,e,p,i){this.currentSceneInfo.id=s;if(v!=="static"&&v!=="dynamic"){return Promise.reject("invalid arg: supported type - static, dynamic");}if(!e){return Promise.reject("invalid arg: viewId undefined");}var f=this.getContext(s);if(!f){return Promise.reject("no context for ${sceneVeId}");}f.currentViewId=e;var g=f.includeHidden!==undefined?f.includeHidden:false;var h;if(i){h=i;}else{h=f.includeAnimation!==undefined?f.includeAnimation:true;}var j=f.$select!==undefined?f.$select:undefined;this.hasAnimation=false;var t=this;var k=new Promise(function(r,m){var n,o;if(v==="static"){n=a.getView;o={sceneId:s,id:e,token:f.token,includeHidden:g,includeAnimation:h,$select:j};if(p&&p.length){o.$expand="playback";f.playbackIds=p;}}else{n=a.getDynamicView;o={sceneId:s,type:e,token:f.token};}f.onSetPlaybackCallbacks.detachAll();var q=function(y){f.onSetPlaybackCallbacks.detach(q);l(f,"onSetPlayback");if(y){r(y);}else{m("no view data");}};f.onSetPlaybackCallbacks.attach(q);f.onViewFinishedCallbacks.detachAll();var u=function(y){f.onViewFinishedCallbacks.detach(u);l(f,"onViewFinished");if(!t.hasAnimation){if(y){r(y);}else{m("no view data");}}else{f.currentView=y;}};f.onViewFinishedCallbacks.attach(u);t.onSetSequenceCallbacks.detachAll();var w=function(){t.onSetSequenceCallbacks.detach(w);l(f,"onSetSequence");if(f.currentView){r(f.currentView);}else{m("no view data");}};t.onSetSequenceCallbacks.attach(w);t.onSetTrackCallbacks.detachAll();var x=function(y){t.onSetTrackCallbacks.detach(x);l(f,"onSetTrack");if(f.currentView){r(f.currentView);}else{m("no view data");}};t.onSetTrackCallbacks.attach(x);l(f,"viewRequested");t.postMessage(T.createRequestCommand(n,o));});return k;};
d.prototype.requestMaterial=function(s,e){if(!e){return Promise.reject("invalid arg: materialId undefined");}var f=this.getContext(s);if(!f){return Promise.reject("no context for ${sceneVeId}");}var t=this;var p=new Promise(function(r,g){var h=f.sceneBuilder.getMaterial(e);if(h){r(h);return;}f.requestQueue.materials.push(e);var i=function(k){var m=t.sceneBuilder.getMaterial(e);if(m&&m.userData&&m.userData.idsOfImagesToRead){if(!m.userData.idsOfImagesToRead.has(k.id)){return;}else{m.userData.idsOfImagesToRead.delete(k.id);}if(m.userData.idsOfImagesToRead.size){return;}else{r(m);}}else{g("no material data");}t.onImageFinishedCallbacks.detach(i);};var j=function(n){if(e!=n){return;}t.onMaterialFinishedCallbacks.detach(j);var m=t.sceneBuilder.getMaterial(e);if(m&&m.userData&&m.userData.idsOfImagesToRead&&m.userData.idsOfImagesToRead.size){return;}t.onImageFinishedCallbacks.detach(i);if(m!=null){r(m);}else{g("no material data");}};t.onMaterialFinishedCallbacks.attach(j);t.onImageFinishedCallbacks.attach(i);t.sendRequest(f.requestQueue);});return p;};
d.prototype.sendRequest=function(r){if(!this._worker){return false;}var s=false;while(!r.isEmpty()){var n=r.generateRequestCommand();this.postMessage(n);s=true;}return s;};
d.prototype.timestamp=function(j){};
d.prototype.performanceTiming=function(j){};
d.prototype.checkError=function(j){if(!j){return true;}var r=j.result==="failure";if(r){if(j.message){j.error=j.message;delete j.message;}else{j.error="Unknown error";}}return r;};
d.prototype.reportError=function(e,f){this.onErrorCallbacks.execute({error:f,context:e});};
d.prototype.processContextCommand=function(e,n,j,f){if(!e){var g=n+" error: unknown context - "+JSON.stringify(j);this.contextMap.forEach(function(e){e[n].call(e,j,f);});return{error:g};}return e[n].call(e,j,f);};
d.prototype.processCommand=function(n,j,e){if(this.checkError(j)){if(n===a.setTree){if(j.events&&j.events.length){var f=j.events[0];if(f.values&&f.values.id){this.contextMap.delete(f.values.id);}}}this.onErrorCallbacks.execute(j);return null;}var g=null;if(j.sceneId!==undefined){g=this.getContext(j.sceneId);}else if(j.token!==undefined){g=this.tokenContextMap.get(j.token);}if(g){this.currentSceneInfo.id=g.sceneId;}this.setPerformance(n,j,g?g.sceneId:null);var r;switch(n){case a.setTree:case a.setTreeNode:case a.notifyFinishedTree:case a.setView:case a.setViewNode:case a.setViewGroup:case a.notifyFinishedView:case a.setCamera:case a.setMesh:case a.setMaterial:case a.setGeometry:case a.setImage:case a.setAnnotation:case a.setPlayback:case a.setHighlightStyle:case a.setSequence:case a.setTrack:r=this.processContextCommand(g,n,j,e);break;case a.notifyError:r={error:j};break;case a.timestamp:r=this.timestamp(j);break;case a.performanceTiming:r=this.performanceTiming(j);break;default:r={error:"Unknown command: "+n};break;}if(n!==a.setView&&n!==a.setViewNode&&n!==a.timestamp&&n!==a.performanceTiming&&this.isLoadingFinished()){this.onLoadingFinishedCallbacks.execute();L.info("Loading is finished - all streaming requests are fulfilled.");}if(r&&r.error){L.error(r.error);this.onErrorCallbacks.execute(r);}return g;};
d.prototype.setPerformance=function(n,j,s){var i;switch(n){case a.setGeometry:i=j.id;c("setGeometry-"+i);break;case a.setImage:i=j.id;c("setImage-"+i);break;case a.setView:i=j.viewId;c("setView-"+i);break;case a.setViewGroup:i=j.id;c("setViewGroup-"+i);break;case a.setMesh:c("setMesh-"+s);break;case a.setMaterial:c("setMaterial-"+s);break;case a.setTree:c("setTree-"+s);break;case a.performanceTiming:this._isPostable=true;this.postPerformanceTiming();break;default:break;}};
d.prototype.postPerformanceTiming=function(m){if(m){this._performanceTimingMsg.push(m);}if(this._isPostable&&this._performanceTimingMsg.length>0){this.postMessage(this._performanceTimingMsg.shift());this._isPostable=false;}};
d.prototype.printLogTokens=function(){this.contextMap.forEach(function(e,s){L.info("log tokens for scene => "+s);L.info("---------------------------------------");if(e.progressLogger){e.progressLogger.getTokens().forEach(function(t){L.info(t);});}L.info("---------------------------------------");});};
return d;});
sap.ui.predefine('sap/ui/vk/totara/TotaraUtils',["./Command"],function(C){"use strict";var T=function(){};
T.createCommand=function(c,o){var r=JSON.stringify(o);return c+("["+r.length+"]")+r;};
T.createRequestCommand=function(c,o){return{command:T.createCommand(c,o),method:c};};
function P(i,c,t){if(!i||!c||!t){throw"ProgressLogger: invalid args";}this.context=c;this.loader=t;var d=new Set();this.logPerformance=function(n,a){if(!n||!a){return;}d.add(a);var o={name:n,timestamp:Date.now(),token:a};var m={method:C.addClientLog,url:this.loader.getUrl(),authorizationHandler:c.authorizationHandler,token:c.token,command:T.createCommand(C.addClientLog,o)};this.loader.postMessage(m);};this.getTokens=function(){return d;};this.logPerformanceTiming=function(m,p){var e=this;m.sort(function(a,b){return a.timestamp-b.timestamp;});if(!m.length){return;}d.add(c.token);var f=[];while(m.length){f.push(m.splice(0,10));}f.forEach(function(a){var o={records:[],timestamp:Date.now()};a.forEach(function(h){o.records.push({name:h.name,timestamp:h.timestamp,uuid:h.uuid,duration:h.duration,value:h.value,parent_uuid:p});});var b=T.createCommand(C.performanceTiming,o);e.loader.postPerformanceTiming({method:C.performanceTiming,url:e.loader.getUrl(),authorizationHandler:c.authorizationHandler,token:c.token,command:b});});};}
T.mark=function(t){window.performance.mark(t);};
T.measure=function(n,s,e){var p=window.performance;if(performance.getEntriesByName(s).length!==0){if(!e){p.measure(n,s);}else{p.measure(n,s,e);}}p.clearMarks(s);if(e){p.clearMarks(e);}p.clearMeasures(n);};
T.perfObserve=function(c){if(!window.PerformanceObserver){return;}var _=[];var s;var a=performance.timing.navigationStart;var p=new window.PerformanceObserver(function(l){l.getEntries().forEach(function(e){e.uuid=T.generateToken();e.timestamp=a+e.startTime;if(e.name==="sceneMeasure"){s=e.uuid;}_.push(e);});if(_.find(function(b){return b.name==="sceneCompleted";})){T.measure("sceneMeasure","modelRequested","sceneCompleted");}if(s){_=_.filter(function(b){return b instanceof PerformanceMeasure;});c.progressLogger.logPerformanceTiming(_,s);s="";}});p.observe({entryTypes:["mark","measure"]});};
T.createLogger=function(i,c,a){if(!c){return null;}c.progressLogger=new P(i,c,a);T.perfObserve(c);return c.progressLogger;};
T.base64ToUint8Array=function(b){var a=atob(b);var l=a.length;var c=new Uint8Array(l);for(var i=0;i<l;i++){c[i]=a.charCodeAt(i);}return c;};
T.arrayToColumnMajorMatrixArray16=function(a){if(a.length===16){return[a[0],a[4],a[8],a[12],a[1],a[5],a[9],a[13],a[2],a[6],a[10],a[14],a[3],a[7],a[11],a[15]];}if(a.length===12){return[a[0],a[3],a[6],a[9],a[1],a[4],a[7],a[10],a[2],a[5],a[8],a[11],0.0,0.0,0.0,1.0];}if(a.length===3){return[1,0,0,a[0],0,1,0,a[1],0,0,1,a[2],0,0,0,1];}return null;};
T.pushElementIntoMapArray=function(m,k,e){var a=m.get(k);if(!a){a=[];m.set(k,a);}else if(a.length>0&&a[a.length-1]===e){return;}a.push(e);};
T.generateToken=function(){return g();};
function g(){function s(){return Math.floor((1+Math.random())*0x10000).toString(16).substring(1);}return s()+s()+"-"+s()+"-"+s()+"-"+s()+"-"+s()+s()+s();}
return T;});
/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.predefine('sap/ui/vk/ContainerBase',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/m/library","./ContainerBaseRenderer","./MapContainerButtonType","./getResourceBundle"],function(q,v,C,I,P,R,S,D,m,a,M,g){"use strict";
var b=C.extend("sap.ui.vk.ContainerBase",{metadata:{library:"sap.ui.vk",properties:{"showFullScreen":{type:"boolean",group:"Misc",defaultValue:true},"showSettings":{type:"boolean",group:"Misc",defaultValue:true},"showSelection":{type:"boolean",group:"Misc",defaultValue:true},"fullScreen":{type:"boolean",group:"Misc",defaultValue:false},"title":{type:"string",group:"Misc",defaultValue:""},"autoAdjustHeight":{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.vk.ContainerContent",multiple:true,singularName:"content"},"toolbar":{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"}},associations:{},events:{"contentChange":{parameters:{selectedItemId:"string"}},"settingsPressed":{}}}});
b.prototype.switchContent=function(c){this.setSelectedContent(c);this.rerender();};
b.prototype.updateContainer=function(){this._contentChanged=true;this.rerender();};
b.prototype.setSelectedContent=function(c){this._oSelectedContent=c;};
b.prototype.getSelectedContent=function(){return this._oSelectedContent;};
b.prototype.init=function(){this._selectionState="SINGLE";this._firstTime=true;this._aContentIcons=[];this._selectedContent=null;this._oSelectedContent=null;this._bSegmentedButtonSaveSelectState=false;this._oMenu=null;this._customButtons=[];var l=new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.High});var c=sap.m.ButtonType.Transparent;this._oFullScreenButton=new sap.m.OverflowToolbarButton({layoutData:l,type:c,icon:"sap-icon://full-screen",text:g().getText("CONTAINERBASE_FULLSCREEN"),tooltip:g().getText("CONTAINERBASE_FULLSCREEN"),press:function(){this._bSegmentedButtonSaveSelectState=true;this._toggleFullScreen();}.bind(this)});this._oSettingsButton=new sap.m.OverflowToolbarButton({layoutData:l.clone(),type:c,icon:"sap-icon://action-settings",text:g().getText("CONTAINERBASE_SETTINGS"),tooltip:g().getText("CONTAINERBASE_SETTINGS"),press:function(){this._bSegmentedButtonSaveSelectState=true;this.fireSettingsPressed();}.bind(this)});this._oSelectionButtonSingle=new sap.m.SegmentedButtonItem({icon:"sap-icon://map-container/selection-single",tooltip:g().getText("CONTAINERBASE_MENU_SINGLE"),press:this._handleSelection.bind(this,"SINGLE")});this._oSelectionButtonRectangle=new sap.m.SegmentedButtonItem({icon:"sap-icon://map-container/selection-rectangle",tooltip:g().getText("CONTAINERBASE_MENU_RECT"),press:this._handleSelection.bind(this,"RECT")});this._oSelectionButtonLasso=new sap.m.SegmentedButtonItem({icon:"sap-icon://map-container/selection-lasso",tooltip:g().getText("CONTAINERBASE_MENU_LASSO"),press:this._handleSelection.bind(this,"LASSO")});this._selectionMenu=new sap.m.SegmentedButton({items:[this._oSelectionButtonSingle,this._oSelectionButtonRectangle,this._oSelectionButtonLasso]});this._oPopup=new P({modal:true,shadow:false,autoClose:false});this._oContentSegmentedButton=new sap.m.SegmentedButton({layoutData:l.clone(),select:this._onContentButtonSelect.bind(this)});this._oContTitle=new sap.m.Label();this._oToolbar=new sap.m.OverflowToolbar({width:"auto"}).addStyleClass("sapUiVkContainerBaseToolbar");this.setAggregation("toolbar",this._oToolbar);this.sResizeListenerId=null;if(D.system.desktop){this.sResizeListenerId=R.register(this,q.proxy(this._performHeightChanges,this));}else{D.orientation.attachHandler(this._performHeightChanges,this);D.resize.attachHandler(this._performHeightChanges,this);}var d=[{name:"selection-lasso",unicode:"E000"},{name:"selection-rectangle",unicode:"E001"},{name:"selection-single",unicode:"E002"}],e="map-container",f="map-container";d.forEach(function(i){I.addIcon(i.name,e,f,i.unicode);});};
b.prototype.exit=function(){if(this._oFullScreenButton){this._oFullScreenButton.destroy();this._oFullScreenButton=undefined;}if(this._oPopup){this._oPopup.destroy();this._oPopup=undefined;}if(this._oContentSegmentedButton){this._oContentSegmentedButton.destroy();this._oContentSegmentedButton=undefined;}if(this._oSelectedContent){this._oSelectedContent.destroy();this._oSelectedContent=undefined;}if(this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(D.system.desktop&&this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}else{D.orientation.detachHandler(this._performHeightChanges,this);D.resize.detachHandler(this._performHeightChanges,this);}};
b.prototype.setFullScreen=function(f){if(this._firstTime){return;}if(this.getFullScreen()==f){return;}var c=this.getProperty("fullScreen");if(c!==f){this._toggleFullScreen();}};
b.prototype.onAfterRendering=function(){var t=this;if((this.sResizeListenerId===null)&&(D.system.desktop)){this.sResizeListenerId=R.register(this,q.proxy(this._performHeightChanges,this));}if(this.getAutoAdjustHeight()||this.getFullScreen()){q.sap.delayedCall(500,this,function(){t._performHeightChanges();});}this._firstTime=false;if(this.getSelectedContent()!==null){var c=this.getSelectedContent().getContent();if(c instanceof sap.ui.vbm.GeoMap||c instanceof sap.ui.vbm.AnalyticMap){if(this.getShowSelection()){if(this._selectionState==="LASSO"){c.setLassoSelection(true);}else if(this._selectionState==="RECT"){c.setRectangularSelection(true);}else if(this._selectionState==="SINGLE"){c.setRectangularSelection(false);c.setLassoSelection(false);}}}}};
b.prototype.onBeforeRendering=function(){var t=this;if(t._contentChanged){t._contentChange();}t._oToolbar.getContent().forEach(function(e){var c=e.getId();var d=e["getPressed"]?e.getPressed():null;for(var i in t._customButtons){if(t._customButtons[i].button&&t._customButtons[i].button.getId()==c){t._customButtons[i].toggled=d;}}});t._oToolbar.removeAllContent();t._addToolbarContent();};
b.prototype.setTitle=function(V){this._oContTitle.setText(V);this.setProperty("title",V,true);};
b.prototype.addContent=function(o){this.addAggregation("content",o);this._contentChanged=true;};
b.prototype.insertContent=function(o,i){this.insertAggregation("content",o,i);this._contentChanged=true;};
b.prototype.updateContent=function(){this.updateAggregation("content");this._contentChanged=true;};
b.prototype._toggleFullScreen=function(){var f=this.getProperty("fullScreen");var s;var h;var c;if(f){this._closeFullScreen();this.setProperty("fullScreen",false,true);c=this.getSelectedContent().getContent();s=c.getId();c.setWidth("100%");h=this._contentHeight[s];if(h){c.setHeight(h);}this.invalidate();}else{var o=this.getAggregation("content");this._contentHeight={};if(o){for(var i=0;i<o.length;i++){c=o[i].getContent();s=c.getId();if(q.isFunction(c.getHeight)){h=c.getHeight();}else{h=0;}this._contentHeight[s]=h;}}this._openFullScreen(true);this.setProperty("fullScreen",true,true);}var d=(f?"sap-icon://full-screen":"sap-icon://exit-full-screen");this._oFullScreenButton.setIcon(d);this._oFullScreenButton.focus();};
b.prototype._openFullScreen=function(n){if((n!==null)&&(n===true)){this._oScrollEnablement=new S(this,this.getId()+"-wrapper",{horizontal:true,vertical:true});}this.$content=this.$();if(this.$content){this.$tempNode=q("<div></div>");this.$content.before(this.$tempNode);this._$overlay=q("<div id='"+q.sap.uid()+"'></div>");this._$overlay.addClass("sapUiVkContainerBaseOverlay");this._$overlay.append(this.$content);this._oPopup.setContent(this._$overlay);}else{q.sap.log.warn("Overlay: content does not exist or contains more than one child");}this._oPopup.open(200,undefined,undefined,q("body"));};
b.prototype._closeFullScreen=function(){if(this._oScrollEnablement!==null){this._oScrollEnablement.destroy();this._oScrollEnablement=null;}this.$tempNode.replaceWith(this.$content);this._oToolbar.setDesign(sap.m.ToolbarDesign.Auto);this._oPopup.close();this._$overlay.remove();};
b.prototype._performHeightChanges=function(){if(this.getAutoAdjustHeight()||this.getFullScreen()){var $=this.$();if(($.find(".sapUiVkContainerBaseToolbarArea").children()[0])&&($.find(".sapUiVkContainerBaseContentArea").children()[0])){var o=this.getSelectedContent().getContent();if(o.getDomRef().offsetWidth!==this.getDomRef().clientWidth){this.rerender();}}}};
b.prototype._switchContent=function(c){var o=this._findContentById(c);this.setSelectedContent(o);this.fireContentChange({selectedItemId:c});this.rerender();};
b.prototype._contentChange=function(){var c=this.getContent();this._oContentSegmentedButton.removeAllButtons();this._destroyButtons(this._aContentIcons);this._aContentIcons=[];if(c.length===0){this._oContentSegmentedButton.removeAllButtons();this._setDefaultOnSegmentedButton();this.switchContent(null);}if(c){for(var i=0;i<c.length;i++){var d=c[i].getContent();if(d.setWidth){d.setWidth("100%");}var B=new sap.m.SegmentedButtonItem({icon:c[i].getIcon(),tooltip:c[i].getTitle(),key:d.getId()});this._aContentIcons.push(B);this._oContentSegmentedButton.addItem(B);if(i===0){this.setSelectedContent(c[i]);}}}this._contentChanged=false;};
b.prototype._onContentButtonSelect=function(e){var c=e.getParameter("key");this._switchContent(c);};
b.prototype._findContentById=function(s){var c=null;var o=this.getAggregation("content");if(o){for(var i=0;!c&&i<o.length;i++){if(o[i].getContent().getId()===s){c=o[i];}}}return c;};
b.prototype._addToolbarContent=function(){this._oToolbar.addContent(new sap.m.ToolbarSpacer());if(this._aContentIcons.length>1){this._oToolbar.addContent(this._oContentSegmentedButton);}if(this.getSelectedContent()!==null){var c=this.getSelectedContent().getContent();if(c instanceof sap.ui.vbm.GeoMap||c instanceof sap.ui.vbm.AnalyticMap){if(this.getShowSelection()){this._oToolbar.addContent(this._selectionMenu);}}}this._customButtons.forEach(function(i){if(i.visible){var s={type:sap.m.ButtonType.Transparent,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.High})};if("active"in i){s.enabled=i.active;}if("icon"in i){s.icon=i.icon;}if("activeIcon"in i){s.activeIcon=i.activeIcon;}if("text"in i){s.text=i.text;}if("tooltip"in i){s.tooltip=i.tooltip;}if("press"in i){s.press=i.press;}if("toggled"in i){s.pressed=i.toggled;}if("overflow"in i){s.overflow=i.overflow;}switch(i.type){case M.Click:i.button=s.overflow?new sap.m.OverflowToolbarButton(s):new sap.m.Button(s);break;default:i.button=s.overflow?new sap.m.OverflowToolbarToggleButton(s):new sap.m.ToggleButton(s);break;}this._oToolbar.addContent(i.button);}},this);if(this.getShowSettings()){this._oToolbar.addContent(this._oSettingsButton);}if(!D.system.phone&&this.getShowFullScreen()){this._oToolbar.addContent(this._oFullScreenButton);}};
b.prototype._setDefaultOnSegmentedButton=function(){if(!this._bSegmentedButtonSaveSelectState){this._oContentSegmentedButton.setSelectedButton(null);}this._bSegmentedButtonSaveSelectState=false;};
b.prototype._destroyButtons=function(c){c.forEach(function(B){B.destroy();});};
b.prototype._handleSelection=function(c){var d=this.getSelectedContent().getContent();if(d instanceof sap.ui.vbm.GeoMap||d instanceof sap.ui.vbm.AnalyticMap){if(c==="LASSO"){d.setLassoSelection(true);this._selectionState=c;}else if(c==="RECT"){d.setRectangularSelection(true);this._selectionState=c;}else if(c==="SINGLE"){d.setRectangularSelection(false);d.setLassoSelection(false);this._selectionState=c;}}};
return b;});
sap.ui.predefine('sap/ui/vk/ContainerBaseRenderer',function(){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkContainerBase");r.writeClasses(c);r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-wrapper");r.addClass("sapUiVkContainerBaseWrapper");r.writeClasses();r.write(">");this.writeContentArea(r,c);this.writeToolbarArea(r,c);r.write("</div>");r.write("</div>");};
C.writeContentArea=function(r,c){var s=c.getSelectedContent();r.write("<div");r.addClass("sapUiVkContainerBaseContentArea");r.writeClasses();r.write(">");if(s!==null){r.renderControl(s);}else if(c.getContent().length>0){s=c.getContent()[0];r.renderControl(s);}r.write("</div>");};
C.writeToolbarArea=function(r,c){r.write("<div");r.addClass("sapUiVkContainerBaseToolbarArea");r.writeClasses();r.write(">");r.renderControl(c._oToolbar);r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/vk/ContainerContent',["./library","sap/ui/core/Control","./ContainerContentRenderer"],function(v,C,a){"use strict";
var b=C.extend("sap.ui.vk.ContainerContent",{metadata:{library:"sap.ui.vk",properties:{"icon":{type:"string",group:"Misc",defaultValue:null},"title":{type:"string",group:"Misc",defaultValue:null}},aggregations:{"content":{type:"sap.ui.core.Control",multiple:false}}}});
b.prototype.setContent=function(c){if(c instanceof sap.ui.vbm.GeoMap){c.setNavcontrolVisible(false);c.setWidth("100%");c.setHeight("100%");}this.setAggregation("content",c);return this;};
return b;});
sap.ui.predefine('sap/ui/vk/ContainerContentRenderer',function(){"use strict";var C={};
C.render=function(r,c){r.renderControl(c.getContent());};
return C;},true);
sap.ui.predefine('sap/ui/vk/LegendItem',["sap/m/StandardListItem","./LegendItemRenderer"],function(S,L){"use strict";
var a=S.extend("sap.ui.vk.LegendItem",{metadata:{library:"sap.ui.vk",properties:{color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},semanticSpotType:{type:"sap.ui.vbm.SemanticType",group:"Behavior",defaultValue:null}},aggregations:{}}});
return a;});
sap.ui.predefine('sap/ui/vk/LegendItemRenderer',["sap/m/StandardListItemRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var L=R.extend(B);
L.renderLIContent=function(r,c){var s=c.getColor();var t=c.getSemanticSpotType();var i=null;if(s){r.write("<span");r.addClass("sapUiVkLegendItemSquare");r.addStyle("background-color",s);r.writeStyles();r.writeClasses();r.write(">");r.write("</span>");}if(t){switch(t){case sap.ui.vbm.SemanticType.Error:i=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_Red.png");break;case sap.ui.vbm.SemanticType.Warning:i=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_Orange.png");break;case sap.ui.vbm.SemanticType.Success:i=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_Green.png");break;case sap.ui.vbm.SemanticType.Default:i=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_Blue.png");break;case sap.ui.vbm.SemanticType.Inactive:i=sap.ui.resource("sap.ui.vbm","themes/base/img/Pin_Grey.png");break;default:break;}if(i){c.addStyleClass("sapUiVkLegendItemSpotType");c.setIcon(i);}}B.renderLIContent(r,c);};
return L;},true);
sap.ui.predefine('sap/ui/vk/ListPanel',["./library","sap/ui/core/Control","sap/m/library","./ListPanelRenderer"],function(v,C,m,L){"use strict";
var a=C.extend("sap.ui.vk.ListPanel",{metadata:{library:"sap.ui.vk",properties:{"headerText":{type:"string",group:"Misc"},"headerIcon":{type:"sap.ui.core.URI",group:"Misc"},"expanded":{type:"boolean",group:"Misc",defaultValue:true},"expandAnimation":{type:"boolean",group:"Misc",defaultValue:true},"selectionMode":{type:"sap.m.ListMode",group:"Misc",defaultValue:sap.m.ListMode.MultiSelect}},aggregations:{"items":{type:"sap.m.ListItemBase",multiple:true,singularName:"item"},"panel":{type:"sap.m.Panel",multiple:false,visibility:"hidden"}},events:{headerIconPress:{},expand:{},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}}}}});
a.prototype.getSelectedItem=function(){return this._oList.getSelectedItem();};
a.prototype.setSelectedItem=function(l,s,f){this._oList.setSelectedItem(l,s,f);};
a.prototype.getSelectedItems=function(){return this._oList.getSelectedItems();};
a.prototype.init=function(){this._oList=new sap.m.ListBase({mode:this.getSelectionMode(),itemPress:this.fireItemPress.bind(this),selectionChange:this.fireSelectionChange.bind(this)});this._oPanel=new sap.m.Panel({expandable:true,expanded:true,expandAnimation:true,headerToolbar:new sap.m.Toolbar({active:false}),content:[this._oList],expand:this.fireExpand.bind(this)});this._oPanel.getHeaderToolbar().addStyleClass("sapUiVkLPTb");this.setAggregation("panel",this._oPanel,true);this._oHeaderIcon=null;this._oHeaderText=null;this._bHeaderToolbarChanged=true;};
a.prototype.exit=function(){this._destroyControl(this._oList);this._destroyControl(this._oPanel);this._destroyControl(this._oHeaderIcon);this._destroyControl(this._oHeaderText);};
a.prototype.getItems=function(){return this._oList.getItems();};
a.prototype.addItem=function(o){return this._oList.addItem(o);};
a.prototype.insertItem=function(o,i){return this._oList.insertItem(o,i);};
a.prototype.removeItem=function(o){return this._oList.removeItem(o);};
a.prototype.removeAllItems=function(){return this._oList.removeAllItems();};
a.prototype.setHeaderText=function(b){if(!this._oHeaderText){this._oHeaderText=new sap.m.Title();}this._oHeaderText.setText(b);this._bHeaderToolbarChanged=true;if(this._oHeaderIcon){this._oHeaderIcon.setTooltip(b);this._oHeaderIcon.addAriaLabelledBy(this._oHeaderText);this._oHeaderIcon.addAriaDescribedBy(this._oHeaderText);}return this.setProperty("headerText",b);};
a.prototype.getExpanded=function(){return this._oPanel.getExpanded();};
a.prototype.setExpanded=function(b){return this._oPanel.setExpanded(b);};
a.prototype.getExpandAnimation=function(){return this._oPanel.getExpandAnimation();};
a.prototype.setExpandAnimation=function(b){return this._oPanel.setExpandAnimation(b);};
a.prototype.setHeaderIcon=function(b){if(!this._oHeaderIcon){this._oHeaderIcon=new sap.m.Button({press:this.fireHeaderIconPress.bind(this),type:sap.m.ButtonType.Transparent,tooltip:this.getHeaderText()});}this._oHeaderIcon.setIcon(b);this._bHeaderToolbarChanged=true;if(this._oHeaderText){this._oHeaderIcon.addAriaLabelledBy(this._oHeaderText);this._oHeaderIcon.addAriaDescribedBy(this._oHeaderText);}return this.setProperty("headerIcon",b);};
a.prototype.setSelectionMode=function(b){this._oList.setMode(b);return this.setProperty("selectionMode",b);};
a.prototype.onBeforeRendering=function(){if(this._bHeaderToolbarChanged){var t=this._oPanel.getHeaderToolbar();t.removeAllContent();if(this._oHeaderIcon){t.addContent(this._oHeaderIcon);}if(this._oHeaderText){t.addContent(this._oHeaderText);}this._bHeaderToolbarChanged=false;}};
a.prototype._destroyControl=function(c){if(c){c.destroy();c=undefined;}};
return a;});
sap.ui.predefine('sap/ui/vk/ListPanelRenderer',function(){"use strict";var L={};
L.render=function(r,c){var p=c._oPanel;p.addStyleClass("sapUiVkListPanel");r.write("<div");r.writeControlData(c);r.write(">");r.renderControl(p);r.write("</div>");};
return L;},true);
sap.ui.predefine('sap/ui/vk/ListPanelStack',["./library","sap/ui/core/Control","sap/ui/layout/library","./ListPanelStackRenderer"],function(v,C,l,L){"use strict";
var a=C.extend("sap.ui.vk.ListPanelStack",{metadata:{library:"sap.ui.vk",properties:{"width":{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},"expanded":{type:"boolean",group:"Misc",defaultValue:true},"expandAnimation":{type:"boolean",group:"Misc",defaultValue:true},"collapsible":{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{"content":{type:"sap.ui.vk.ListPanel",multiple:true,singularName:"content"},"layout":{type:"sap.ui.layout.VerticalLayout",multiple:false,visibility:"hidden"}}}});
a.prototype.init=function(){this._oLayout=new sap.ui.layout.VerticalLayout();this._oLayout.addStyleClass("sapUiVkLPSTrans");this.setAggregation("layout",this._oLayout,true);this._bFirstTime=true;};
a.prototype.exit=function(){if(this._oLayout){this._oLayout.destroy();this._oLayout=undefined;}};
a.prototype.getContent=function(){return this._oLayout.getContent();};
a.prototype.addContent=function(o){o.attachExpand(this._onContentExpand.bind(this));o.attachHeaderIconPress(this._onContentHeaderIconPress.bind(this));return this._oLayout.addContent(o);};
a.prototype.removeContent=function(o){return this._oLayout.removeContent(o);};
a.prototype.insertContent=function(o,i){return this._oLayout.insertContent(o,i);};
a.prototype.removeAllContent=function(){return this._oLayout.removeAllContent();};
a.prototype.getWidth=function(){return this._oLayout.getWidth();};
a.prototype.setWidth=function(b){this.setProperty("width",b,true);return this._oLayout.setWidth(b);};
a.prototype.setExpanded=function(b){if(b!=this.getExpanded()){if(b){this._expand();}else{this._collapse();}}return this;};
a.prototype.setExpandAnimation=function(b){this._oLayout.removeStyleClass("sapUiVkLPSTrans");if(b){this._oLayout.addStyleClass("sapUiVkLPSTrans");}return this.setProperty("expandAnimation",b,true);};
a.prototype.onBeforeRendering=function(){if(this._bFirstTime){var e=false;var c=this.getContent();for(var i=0;i<c.length;++i){if(c[i].getExpanded()){e=true;}}this.setExpanded(e);this._bFirstTime=false;}};
a.prototype.onAfterRendering=function(){if(!this.getExpanded()){this._updateCollapsedLayoutWidth();}};
a.prototype._onContentExpand=function(e){var b=false;var c=this._oLayout.getContent();for(var i=0;i<c.length;++i){if(c[i].getExpanded()){b=true;}}this.setExpanded(b);};
a.prototype._onContentHeaderIconPress=function(e){var b=e.oSource.getExpanded()?false:true;e.oSource.setExpanded(b);var E=false;var c=this._oLayout.getContent();for(var i=0;i<c.length;++i){if(c[i].getExpanded()){E=true;break;}}this.setExpanded(E);};
a.prototype._expand=function(){this._oLayout.removeStyleClass("sapUiVkLPSCollapse");this._oLayout.setWidth(this.getProperty("width"));this.setProperty("expanded",true,true);};
a.prototype._collapse=function(){if(!this.getCollapsible()){return;}var c=this.getContent();for(var i=0;i<c.length;++i){c[i].setExpanded(false);}this._oLayout.addStyleClass("sapUiVkLPSCollapse");this._updateCollapsedLayoutWidth();this.setProperty("expanded",false,true);};
a.prototype._updateCollapsedLayoutWidth=function(){if(this._oLayout.$().closest(".sapUiSizeCompact").length===0){this._oLayout.setWidth("3rem");}else{this._oLayout.setWidth("2.5rem");}};
return a;});
sap.ui.predefine('sap/ui/vk/ListPanelStackRenderer',function(){"use strict";var L={};
L.render=function(r,c){c._oLayout.addStyleClass("sapUiVkListPanelStack");r.renderControl(c._oLayout);};
return L;},true);
sap.ui.predefine('sap/ui/vk/MapContainer',["jquery.sap.global","./ContainerBase","sap/ui/core/IconPool","sap/ui/vbm/lib/sapvbi","sap/ui/Device","./MapContainerRenderer","./MapContainerButtonType","./getResourceBundle"],function(q,C,I,s,D,M,a,g){"use strict";
var b=C.extend("sap.ui.vk.MapContainer",{metadata:{library:"sap.ui.vk",properties:{"showNavbar":{type:"boolean",group:"Misc",defaultValue:true},"showHome":{type:"boolean",group:"Misc",defaultValue:true},"showMapLayer":{type:"boolean",group:"Misc",defaultValue:true},"showRectangularZoom":{type:"boolean",group:"Misc",defaultValue:true},"showZoom":{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{"listPanelStack":{type:"sap.ui.vk.ListPanelStack",multiple:false},"scrollCont":{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"}},associations:{},events:{}}});
b.prototype.init=function(){this._currentText=new sap.m.Text({}).addStyleClass("mapLayerSelectedText");C.prototype.init.apply(this,arguments);var m=new sap.ui.model.json.JSONModel();m.setData({rectZoom:false});this.setModel(m,"rectZoom");this._oNavbar=new sap.m.Toolbar({width:"auto"});this._oScrollCont=new sap.m.ScrollContainer({horizontal:false,vertical:true,focusable:false});this.setAggregation("scrollCont",this._oScrollCont,true);this._oHomeButton=new sap.m.Button({icon:"sap-icon://home",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_HOME"),press:this._onNavbarHome.bind(this)});this._oRectZoomButton=new sap.m.ToggleButton({icon:"sap-icon://draw-rectangle",type:sap.m.ButtonType.Transparent,pressed:"{rectZoom>/rectZoom}",tooltip:g().getText("MAPCONTAINER_RECT_ZOOM")}).setModel(m,"rectZoom");this._oZoomInButton=new sap.m.Button({icon:"sap-icon://add",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_ZOOMIN"),press:this._onNavbarZoomIn.bind(this)});this._oZoomOutButton=new sap.m.Button({icon:"sap-icon://less",type:sap.m.ButtonType.Transparent,tooltip:g().getText("MAPCONTAINER_ZOOMOUT"),press:this._onNavbarZoomOut.bind(this)});if(D.system.phone){this._oMenuOpenButton=new sap.m.Button({layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),icon:"sap-icon://menu2",type:sap.m.ButtonType.Transparent,tooltip:g().getText("CONTAINERBASE_MENU"),press:function(){this._bSegmentedButtonSaveSelectState=true;this._showListPanelStack();}.bind(this)});this._oMenuCloseButton=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:"sap-icon://nav-back",press:function(){this._bSegmentedButtonSaveSelectState=true;this._hideListPanelStack();}.bind(this)});}};
b.prototype.exit=function(){if(this._oNavbar){this._oNavbar.destroy();this._oNavbar=undefined;}if(this._oScrollCont){this._oScrollCont.destroy();this._oScrollCont=undefined;}C.prototype.exit.apply(this,arguments);};
b.prototype.getListPanelStack=function(){return this._oScrollCont.getContent()[0];};
b.prototype.setListPanelStack=function(p){if(D.system.phone){p.setCollapsible(false);p.setWidth("100%");}this._oScrollCont.removeAllContent();return this._oScrollCont.addContent(p);};
b.prototype.onBeforeRendering=function(){C.prototype.onBeforeRendering.apply(this,arguments);this._oNavbar.removeAllContent();var c=this.getSelectedContent();if(c!==null){var d=c.getContent();this._isInstanceGeoAnalytic=d instanceof sap.ui.vbm.GeoMap||d instanceof sap.ui.vbm.AnalyticMap;if(this._isInstanceGeoAnalytic){if(this.getShowHome()){this._oNavbar.addContent(this._oHomeButton);}if(!D.system.phone&&this.getShowRectangularZoom()){this._oNavbar.addContent(this._oRectZoomButton);}if(this.getShowZoom()){this._oNavbar.addContent(this._oZoomInButton);this._oNavbar.addContent(this._oZoomOutButton);}this._shouldRenderListPanel=true;}else{this._shouldRenderListPanel=false;}this._isSupportingMapLayerSwitch=d instanceof sap.ui.vbm.GeoMap&&!(d instanceof sap.ui.vbm.AnalyticMap);if(this._isSupportingMapLayerSwitch&&d.getMapConfiguration()!==null&&this.getShowMapLayer()){var e=d.getMapConfiguration();var l=[].concat(e.MapLayerStacks);if(l.length>1){this._box=new sap.m.HBox({}).addStyleClass("mapContainerHboxPopover");this._popover=new sap.m.Popover({enableScrolling:false,placement:sap.m.PlacementType.Horizontal,content:this._box,showHeader:false});this._selectionMap=new sap.m.Image({width:"4.7rem",press:function(f){if(this._popover.isOpen()){this._popover.close();}else{this._popover.openBy(this._selectionMap);}}.bind(this)}).addStyleClass("mapLayerPopoverItem");}this._shouldRenderMapLayerSwitch=true;}else{this._shouldRenderMapLayerSwitch=false;}}};
b.prototype.onAfterRendering=function(){if(D.system.phone){var l=document.getElementById(this.getId()+"-LPW");this.getDomRef().appendChild(l);}C.prototype.onAfterRendering.apply(this,arguments);if(this.getSelectedContent()!==null){var c=this.getSelectedContent().getContent();if(this._isSupportingMapLayerSwitch===true&&c.getMapConfiguration()){var d=c.getMapConfiguration();var e=[].concat(d.MapLayerStacks);if(e.length>1){e.forEach(function(v,i){var f=new sap.ui.layout.VerticalLayout({});var h=c.mVBIContext.GetMainScene();var j=c.mVBIContext.m_MapLayerStackManager.GetMapLayerStack(v.name);var o=new sap.m.Image({width:"4.5rem",press:function(m){this._popover.close();o.setAlt(v.name);var p=m.getSource();var t=p.getAlt();c.setRefMapLayerStack(t);this._currentText.setText(v.name);h.GetPreviewImage(j,function(r){q(".mapLayerPopoverItem").attr("src",r.src);});this._currentMapLayerStackIndex=i;}.bind(this)});var k=new sap.m.Text({text:v.name}).addStyleClass("mapLayerPopoverItemText");o.addStyleClass("layerType");h.GetPreviewImage(j,function(m){o.setSrc(m.src);});h.GetPreviewImage(h.m_MapLayerStack,function(m){q(".mapLayerPopoverItem").attr("src",m.src);});var n=e[this._currentMapLayerStackIndex||0].name;this._currentText.setText(n);this._box.addItem(f);f.addContent(o);f.addContent(k);},this);}}}};
b.prototype.setToolbarItem=function(c){if(!c||!c.id){return null;}var o;for(var i=0;i<this._customButtons.length;++i){if(c.id===this._customButtons[i].id){o=this._customButtons[i];o.index=i;this._customButtons.splice(i,1);break;}}if(!o){o={id:c.id,visible:true,active:true,index:this._customButtons.length,type:a.Click};}if("index"in c){o.index=c.index;}if("visible"in c){o.visible=c.visible;}if("overflow"in c){o.overflow=c.overflow;}if("active"in c){o.active=c.active;}if("text"in c){o.text=c.text;}if("tooltip"in c){o.tooltip=c.tooltip;}if("icon"in c){o.icon=c.icon;}if("activeIcon"in c){o.activeIcon=c.activeIcon;}if("press"in c){o.press=c.press;}if("toggled"in c){o.toggled=c.toggled;if(o.button){o.button.setPressed(c.toggled);}}if("type"in c){o.type=c.type;}if(o.index>this._customButtons.length){o.index=this._customButtons.length;}else if(o.index<0){o.index=0;}this._customButtons.splice(o.index,0,o);this.invalidate();return o;};
b.prototype.setSelectedContent=function(c){var o;if(this._oSelectedContent){if((o=this._oSelectedContent.getContent())instanceof sap.ui.vbm.GeoMap){o.unbindProperty("rectZoom","rectZoom>/rectZoom");}}C.prototype.setSelectedContent.apply(this,arguments);var n=this._oSelectedContent.getContent();if(n instanceof sap.ui.vbm.GeoMap){n.bindProperty("rectZoom","rectZoom>/rectZoom");}};
b.prototype._addToolbarContent=function(){if(D.system.phone){this._oToolbar.addContent(this._oMenuOpenButton);}C.prototype._addToolbarContent.apply(this,arguments);};
b.prototype._onNavbarZoomIn=function(e){var c=this.getSelectedContent().getContent();if(c.getZoomlevel&&c.setZoomlevel&&c.setEnableAnimation){c.setEnableAnimation(true);c.setZoomlevel(c.getZoomlevel()+1);}};
b.prototype._onNavbarZoomOut=function(e){var c=this.getSelectedContent().getContent();if(c.getZoomlevel&&c.setZoomlevel&&c.setEnableAnimation){c.setEnableAnimation(true);c.setZoomlevel(c.getZoomlevel()-1);}};
b.prototype._onNavbarHome=function(e){var c=this.getSelectedContent().getContent();if(c.goToStartPosition){c.goToStartPosition();}};
b.prototype._showListPanelStack=function(){q("#"+this.getId()+"-LPW").addClass("sapUiVkMapContainerLPWIn");q("#"+this.getId()+"-wrapper").addClass("sapUiVkMapContainerMapOut");};
b.prototype._hideListPanelStack=function(){q("#"+this.getId()+"-LPW").removeClass("sapUiVkMapContainerLPWIn");q("#"+this.getId()+"-wrapper").removeClass("sapUiVkMapContainerMapOut");};
return b;});
sap.ui.predefine('sap/ui/vk/MapContainerRenderer',["./ContainerBaseRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(B,R,D){"use strict";var M=R.extend(B);
M.render=function(r,c){c.addStyleClass("sapUiVkMapContainer");B.render.apply(this,arguments);};
M.writeToolbarArea=function(r,c){r.write("<div");r.addClass("sapUiVkMapContainerOverlay");r.writeClasses();r.write(">");if(c.getShowNavbar()){r.write("<div");r.addClass("sapUiVkMapContainerNavbarArea");r.writeClasses();r.write(">");if(c.getShowMapLayer()&&c._shouldRenderMapLayerSwitch){r.renderControl(c._currentText);r.renderControl(c._selectionMap);}r.write("<div");r.addClass("sapUiVkMapContainerNavbarContainer");r.writeClasses();r.write(">");r.renderControl(c._oNavbar);r.write("</div>");r.write("</div>");}if(!D.system.phone&&c._shouldRenderListPanel){c._oScrollCont.addStyleClass("sapUiVkMapContainerListPanelArea");r.renderControl(c._oScrollCont);}B.writeToolbarArea(r,c);r.write("</div>");if(D.system.phone){r.write("<div id="+c.getId()+"-LPW");r.addClass("sapUiVkMapContainerLPW");r.writeClasses();r.write(">");r.renderControl(c._oMenuCloseButton);c._oScrollCont.addStyleClass("sapUiVkMapContainerListPanelArea");r.renderControl(c._oScrollCont);r.write("</div>");}};
return M;},true);
sap.ui.predefine('sap/ui/vk/NativeViewport',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","./Loco","./ViewportHandler","./Messages","./ContentConnector","./NativeViewportRenderer","./getResourceBundle"],function(q,v,C,R,L,V,M,a,N,g){"use strict";
var b=C.extend("sap.ui.vk.NativeViewport",{metadata:{library:"sap.ui.vk",properties:{limitZoomOut:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false}},events:{"resize":{parameters:{oldSize:"object",size:"object"}},"move":{parameters:{pan:"object",zoom:"float"}}}}});
b.prototype.init=function(){if(C.prototype.init){C.prototype.init.call(this);}this._canvas=null;this._canvas=document.createElement("div");this._canvas.style.textAlign="left";this._canvas.id=q.sap.uid();this._resizeListenerId=null;this._viewportHandler=new V(this);this._loco=new L(this);this._loco.addHandler(this._viewportHandler);this._reset();this._svgid=this.getId()+"-svg";};
b.prototype.exit=function(){this._loco.removeHandler(this._viewportHandler);this._viewportHandler.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(C.prototype.exit){C.prototype.exit.call(this);}};
b.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
b.prototype.onAfterRendering=function(){if(this._canvas){var d=this.getDomRef();d.appendChild(this._canvas);this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:d.clientWidth,height:d.clientHeight}});}};
b.prototype._handleResize=function(e){this.fireResize({oldSize:e.oldSize,size:e.size});if(!e.oldSize||!e.oldSize.width||!e.oldSize.height||this._svgError){this._bestFit();}else{this._update();}};
b.prototype._reset=function(){this._img=null;this._svg=null;this._svgError=null;this._imageW=0;this._imageH=0;this._s4BestFit=1;this._s=1;this._x=0;this._y=0;this._gx=0;this._gy=0;this._canvas.style.visibility="hidden";while(this._canvas.lastChild){this._canvas.removeChild(this._canvas.lastChild);}};
b.prototype._update=function(){var i=this._svgError||this._img||this._svg;if(i){var x=this._x-(this._imageW-this._canvas.clientWidth)/2;var y=this._y-(this._imageH-this._canvas.clientHeight)/2;var t="matrix("+this._s+",0,0,"+this._s+","+x+","+y+")";i.style.transform=t;i.style.webkitTransform=t;i.style.msTransform=t;i.style.MozTransform=t;i.style.OTransform=t;}};
b.prototype._bestFit=function(){if(this._svgError){this._imageW=550;this._imageH=512;}else if(this._svg){this._imageW=this._svg.clientWidth;this._imageH=this._svg.clientHeight;}else if(this._img){this._imageW=this._img.width;this._imageH=this._img.height;}else{return;}if(!this._imageW||!this._imageH||!this._canvas.clientWidth||!this._canvas.clientHeight){return;}var s=Math.min(this._canvas.clientWidth/this._imageW,this._canvas.clientHeight/this._imageH);this._s4BestFit=s;this._s=s;this._x=0;this._y=0;this._update();this._canvas.style.visibility="visible";};
b.prototype.loadUrl=function(u,o,c,d,e){if(/^(svg)$/.test(e.toLowerCase())){this._reset();this._svg=document.createElement("object");this._svg.setAttribute("type","image/svg+xml");this._svg.setAttribute("data",u);this._svg.setAttribute("id",this._svgid);this._svg.setAttribute("class","SVGImage");this._canvas.appendChild(this._svg);var s=document.createElement("div");s.style.position="absolute";s.style.top=0;s.style.left=0;s.style.height="100%";s.style.width="100%";this._canvas.appendChild(s);this._svg.onload=function(){this._svg.onload=null;setTimeout(function(){this._bestFit();if(o){o();}}.bind(this),0);}.bind(this);this._svg.onerror=function(){q.sap.log.error(g().getText(M.VIT1.summary),M.VIT1.code,"sap.ui.vk.NativeViewport");this._reset();if(c){c();}}.bind(this);this._svg.src=u;return this;}else if(/^(jpg|jpeg|png|gif|bmp|tif|tiff)$/.test(e.toLowerCase())){this._reset();this._img=new Image();this._img.draggable=false;this._img.onload=function(){setTimeout(function(){this._bestFit();this._canvas.appendChild(this._img);if(o){o();}}.bind(this),0);}.bind(this);this._img.onerror=function(){q.sap.log.error(g().getText(M.VIT2.summary),M.VIT2.code,"sap.ui.vk.NativeViewport");if(c){c();}};this._img.src=u;return this;}else{q.sap.log.error(g().getText(M.VIT3.summary),M.VIT3.code,"sap.ui.vk.NativeViewport");if(c){c();}}};
b.prototype.loadFailed=function(t){this._reset();this._svgError=document.createElement("div");this._svgError.className="svgErrorContainer";this._svgErrorElement=document.createElementNS("http://www.w3.org/2000/svg","svg");this._svgErrorElement.setAttribute("width","550px");this._svgErrorElement.setAttribute("height","512px");this._svgErrorElement.setAttribute("viewBox","-244 -244 512 512");this._svgErrorElement.setAttribute("enable-background","new -244 -244 512 512");this._svgErrorElement.setAttribute("id","SVGError");var c=document.createElementNS("http://www.w3.org/2000/svg","rect");c.setAttribute("fill","#FFFFFF");c.setAttribute("x","-244");c.setAttribute("y","-244");c.setAttribute("width","512");c.setAttribute("height","512");c.setAttribute("opacity","0.1");this._svgErrorElement.appendChild(c);var d=document.createElementNS("http://www.w3.org/2000/svg","path");d.setAttribute("fill","#474747");d.setAttribute("d","M12.833,89.742c-70.781,0-128.366-57.584-128.366-128.366c0-70.781,57.584-128.365,128.366-128.365 s128.365,57.584,128.365,128.365C141.198,32.158,83.614,89.742,12.833,89.742z M12.833-146.989 c-59.753,0-108.366,48.612-108.366,108.365c0,59.752,48.613,108.366,108.366,108.366S121.198,21.129 121.198-38.624 C121.198-98.376,72.586-146.989,12.833-146.989z");d.setAttribute("opacity","0.3");this._svgErrorElement.appendChild(d);var e=document.createElementNS("http://www.w3.org/2000/svg","rect");e.setAttribute("fill","#474747");e.setAttribute("x","-2.167");e.setAttribute("y","-120.847");e.setAttribute("width","30");e.setAttribute("height","119.447");e.setAttribute("fill","#474747");e.setAttribute("opacity","0.3");this._svgErrorElement.appendChild(e);var f=document.createElementNS("http://www.w3.org/2000/svg","rect");f.setAttribute("fill","#474747");f.setAttribute("x","-2.167");f.setAttribute("y","13.6");f.setAttribute("width","30");f.setAttribute("height","30");f.setAttribute("opacity","0.3");this._svgErrorElement.appendChild(f);var h=document.createElementNS("http://www.w3.org/2000/svg","path");h.setAttribute("fill","#474747");h.setAttribute("d","M10.833,87.33c-70.781,0-128.366-57.584-128.366-128.365c0-70.781,57.584-128.365,128.366-128.365 s128.365,57.584,128.365,128.365C139.198,29.746,81.614,87.33,10.833,87.33z M10.833-149.4 c-59.753,0-108.366,48.612-108.366,108.365S-48.92,67.33,10.833,67.33S119.198,18.718,119.198-41.035S70.586-149.4,10.833-149.4z");this._svgErrorElement.appendChild(h);var i=document.createElementNS("http://www.w3.org/2000/svg","rect");i.setAttribute("fill","#474747");i.setAttribute("x","-4.167");i.setAttribute("y","-123.259");i.setAttribute("width","30");i.setAttribute("height","119.447");i.setAttribute("fill","#474747");this._svgErrorElement.appendChild(i);var j=document.createElementNS("http://www.w3.org/2000/svg","rect");j.setAttribute("fill","#474747");j.setAttribute("x","-4.167");j.setAttribute("y","11.188");j.setAttribute("width","30");j.setAttribute("height","30");j.setAttribute("fill","#474747");this._svgErrorElement.appendChild(j);var k=document.createElementNS("http://www.w3.org/2000/svg","text");k.setAttribute("id","textError");k.setAttribute("left","auto");k.setAttribute("right","auto");k.setAttribute("y","150");k.setAttribute("x","10");k.setAttribute("display","block");k.setAttribute("text-anchor","middle");k.setAttribute("fill","#474747");k.setAttribute("style","font-family:Arial");k.setAttribute("font-size","32");k.textContent=t?t:g().getText("VIEWPORT_MESSAGEUNSUPPORTEDFILEFORMAT");this._svgErrorElement.appendChild(k);this._svgError.appendChild(this._svgErrorElement);this._bestFit();this._canvas.appendChild(this._svgError);return this;};
b.prototype.beginGesture=function(x,y){this._gx=(x-this._canvas.clientWidth/2-this._x)/this._s;this._gy=(y-this._canvas.clientHeight/2-this._y)/this._s;return this;};
b.prototype.endGesture=function(){this._gx=0;this._gy=0;return this;};
b.prototype.pan=function(d,c){if(this._svgError){return this;}this._x+=d;this._y+=c;this._update();this.fireMove({pan:{x:d,y:c},zoom:1.0});return this;};
b.prototype.rotate=function(d,c){if(this._svgError){return this;}this._x+=d;this._y+=c;this._update();this.fireMove({pan:{x:d,y:c},zoom:1.0});return this;};
b.prototype._getZoomInLimit=function(){return 500;};
b.prototype._getZoomOutLimit=function(){return(this.getLimitZoomOut())?this._s4BestFit*0.25:0.0001;};
b.prototype._getZoomFactor=function(){return this._s;};
b.prototype.zoom=function(z){if(this._svgError){return this;}var c=this._gx*this._s;var d=this._gy*this._s;var o=this._s;this._s=Math.min(Math.max(this._s*z,this._getZoomOutLimit()),this._getZoomInLimit());z=this._s/o;var e=this._gx*this._s;var f=this._gy*this._s;var h=c-e;var i=d-f;this._x+=h;this._y+=i;this._update();this.fireMove({pan:{x:h,y:i},zoom:z});return this;};
b.prototype.tap=function(x,y,i){if(i){this._bestFit();}return this;};
b.prototype.queueCommand=function(c){c();return this;};
b.prototype.getViewInfo=function(){var c={};c.camera=[this._s,0,0,this._s,this._x,this._y];return c;};
b.prototype.setViewInfo=function(c){if(this._svgError){return this;}var d=c.camera;this._s=d[0];this._x=d[4];this._y=d[5];this._update();return this;};
b.prototype.getOutputSize=function(){var c=this.getViewInfo().camera,d=this.getDomRef().getBoundingClientRect();return{left:d.width/2+c[4],top:d.height/2+c[5],sideLength:this._canvas.children[0].getBoundingClientRect().width};};
b.prototype._onAfterUpdateContentConnector=function(){this._setImage(this._contentConnector.getContent());};
b.prototype._onBeforeClearContentConnector=function(){this._setImage(null);};
b.prototype._handleContentReplaced=function(e){this._setImage(e.getParameter("newContent"));};
b.prototype._setImage=function(i){this._reset();if(i instanceof HTMLObjectElement){this._svg=i;i.setAttribute("id",this._svgid);i.onload=function(){i.onload=null;setTimeout(function(){this._bestFit();}.bind(this),0);}.bind(this);if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){setTimeout(function(){this._bestFit();}.bind(this),0);}this._canvas.appendChild(i);var s=document.createElement("div");s.style.position="absolute";s.style.top=0;s.style.left=0;s.style.height="100%";s.style.width="100%";this._canvas.appendChild(s);}else if(i instanceof HTMLImageElement){this._img=i;i.draggable=false;setTimeout(function(){this._bestFit();this._canvas.appendChild(i);}.bind(this),0);}};
var r=2;var p=2;[{key:"left",dx:-p,dy:0},{key:"right",dx:+p,dy:0},{key:"up",dx:0,dy:-p},{key:"down",dx:0,dy:+p}].forEach(function(i){b.prototype["onsap"+i.key]=function(e){this.beginGesture(this.$().width()/2,this.$().height()/2);this.pan(i.dx,i.dy);this.endGesture();e.preventDefault();e.stopPropagation();};});[{key:"left",dx:-r,dy:0},{key:"right",dx:+r,dy:0},{key:"up",dx:0,dy:-r},{key:"down",dx:0,dy:+r}].forEach(function(i){b.prototype["onsap"+i.key+"modifiers"]=function(e){if(e.shiftKey&&!(e.ctrlKey||e.altKey||e.metaKey)){this.beginGesture(this.$().width()/2,this.$().height()/2);this.rotate(i.dx,i.dy);this.endGesture();e.preventDefault();e.stopPropagation();}};});[{key:"minus",d:0.98},{key:"plus",d:1.02}].forEach(function(i){b.prototype["onsap"+i.key]=function(e){this.beginGesture(this.$().width()/2,this.$().height()/2);this.zoom(i.d);this.endGesture();e.preventDefault();e.stopPropagation();};});a.injectMethodsIntoClass(b);return b;});
sap.ui.predefine('sap/ui/vk/Notifications',["sap/base/Log","./library","sap/ui/core/Control","./Messages","sap/m/ToggleButton","./NotificationsRenderer","./getResourceBundle"],function(L,v,C,M,T,N,g){"use strict";
var a=C.extend("sap.ui.vk.Notifications",{metadata:{library:"sap.ui.vk",publicMethods:["clearAllMessages"],aggregations:{_messagePopover:{type:"sap.m.MessagePopover",multiple:false,visibility:"hidden"},_messagePopoverToggleButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"}},events:{allMessagesCleared:{},messageAdded:{}}}});
a.prototype.init=function(){if(C.prototype.init){C.prototype.init.call(this);}var m;var b=new T({icon:"sap-icon://message-popup",type:sap.m.ButtonType.Emphasized,tooltip:g().getText("MESSAGEPOPOVERBUTTON"),text:"0",press:function(e){if(b.getPressed()){m.openBy(b);}else{m.close();}}});b.addStyleClass("messagePopoverButton");this.setAggregation("_messagePopoverToggleButton",b);m=new sap.m.MessagePopover({headerButton:new sap.m.Button({text:g().getText("MESSAGEPOPOVER_CLEARBUTTON"),type:sap.m.ButtonType.Emphasized,tooltip:g().getText("MESSAGEPOPOVER_CLEARBUTTON"),press:function(e){m.getParent().clearAllMessages();}}),afterClose:b.setPressed.bind(b,false)});m.addStyleClass("sapVizKitNotificationPopover");this.setAggregation("_messagePopover",m);L.addLogListener(this);};
a.prototype.exit=function(){L.removeLogListener(this);if(C.prototype.exit){C.prototype.exit.call(this);}};
a.prototype.onLogEntry=function(e){if(e.component.startsWith("sap.ui.vk")&&(e.level===L.Level.WARNING||e.level===L.Level.ERROR||e.level===L.Level.FATAL)){var m=e.details,c,r,b;if(M[e.details]){m=g().getText(M[e.details].summary);c=g().getText(M[e.details].cause);r=g().getText(M[e.details].resolution);b=g().getText("ERROR_DESCRIPTION_CODE");}var d=g().getText("ERROR_DESCRIPTION_COMPONENT");var f=g().getText("ERROR_DESCRIPTION_DATE");var t=g().getText("ERROR_DESCRIPTION_TIME");var l=g().getText("ERROR_DESCRIPTION_LEVEL");var h=g().getText("ERROR_DESCRIPTION_MESSAGE");var i=g().getText("ERROR_DESCRIPTION_CAUSE");var j=g().getText("ERROR_DESCRIPTION_RESOLUTION");var k="<div><b>"+d+":</b><br>"+e.component+"</div><br>"+"<div><b>"+f+":</b><br>"+e.date+"</div><br>"+(b?"<div><b>"+b+":</b><br>"+e.details+"</div><br>":"")+"<div><b>"+t+":</b><br>"+e.time.slice(0,e.time.indexOf("."))+"</div><br>"+"<div><b>"+l+":</b><br>"+e.level+"</div><br>"+"<div><b>"+h+":</b><br>"+m+"</div><br>"+(c?"<div><b>"+i+":</b><br>"+c+"</div><br>":"")+(r?"<div><b>"+j+":</b><br>"+r+"</div>":"");var n=new sap.m.MessagePopoverItem({markupDescription:true,title:e.message,description:k});var o=this.getAggregation("_messagePopover");o.addItem(n);this.getAggregation("_messagePopoverToggleButton").setText(o.getItems().length);this.fireMessageAdded();}};
a.prototype.clearAllMessages=function(){var m=this.getAggregation("_messagePopover");m.removeAllItems();m.close();this.getAggregation("_messagePopoverToggleButton").setText(m.getItems().length);this.fireAllMessagesCleared();return this;};
return a;});
sap.ui.predefine('sap/ui/vk/Overlay',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/vbm/library","sap/ui/vbm/lib/sapvbi","./Messages","./OverlayRenderer","./getResourceBundle","./OverlayArea"],function(q,v,C,a,b,M,O,g,c){"use strict";
var d=C.extend("sap.ui.vk.Overlay",{metadata:{library:"sap.ui.vk",properties:{zoomOnResize:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{areas:{type:"sap.ui.vk.OverlayArea",multiple:true,singularName:"area"}},associations:{target:{type:"sap.ui.core.Control",cardinality:"0..1"}},events:{click:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pos:{type:"string"}}},contextMenu:{parameters:{pos:{type:"string"},menu:{type:"sap.ui.unified.Menu"}}}}}});
d.prototype.getPositionInteractive=function(p,e){if(!this.mIACreateCB&&e&&typeof(e)==="function"){this.mIACreateCB=e;var t="POS";if(p){t+="ARRAY";}var l={"SAPVB":{"Automation":{"Call":{"handler":"OBJECTCREATIONHANDLER","name":"CreateObject","object":"MainScene","scene":"MainScene","instance":"","Param":{"name":"data","#":"{"+t+"}"}}}}};this._load(l);return true;}else{return false;}};
d.prototype.openContextMenu=function(m){this._openContextMenu("Overlay",this,m);};
d.prototype.setPanAndZoom=function(n,e,z){if(n===0&&e===0&&z===1){return;}var s=this.mVBIContext.GetMainScene();this.totalCenterOffset.dx+=n;this.totalCenterOffset.dy+=e;if(z===1){s.MoveMap(n,e);}else{var f=s.m_Canvas[0];var h=f.m_nExactLOD+Math.log(z)*Math.LOG2E;s.ZoomToGeoPosition(VBI.MathLib.DegToRad([0.5,0.5]),h);s.MoveMap(this.totalCenterOffset.dx,this.totalCenterOffset.dy);}};
d.prototype.reset=function(){this.totalCenterOffset.dx=this.totalCenterOffset.dy=0;var s=this.mVBIContext.GetMainScene();if(s){s.ZoomToGeoPosition(VBI.MathLib.DegToRad([0.5,0.5]),this.initialZoom);}return this;};
d.prototype.init=function(){this.aLoadQueue=null;this.oTargetDomRef=null;this.mVBIContext=new VBI.VBIContext(this);this.resizeID="";this.resizeIDTarget="";this.bVosDirty=true;this.bWindowsDirty=true;this.bSceneDirty=true;this.bDataDeltaUpdate=false;this.bHandleDataChangeActive=false;this.bForceDataUpdate=false;this.mAddMenuItems=[];this.totalCenterOffset={dx:0,dy:0};this.initialZoom=10;};
d.prototype.exit=function(){if(this.mVBIContext){this.mVBIContext.clear();}if(this.resizeID!=""){sap.ui.core.ResizeHandler.deregister(this.resizeID);this.resizeID="";}if(this.resizeIDTarget!=""){sap.ui.core.ResizeHandler.deregister(this.resizeIDTarget);this.resizeIDTarget="";}};
d.prototype.resize=function(e){var f=(this.oControl!=undefined)?this.oControl:this;var h=f.mVBIContext;if(h){var s=h.GetMainScene();if(s){if(f.getZoomOnResize()&&e&&e.oldSize.width>0){var z=Math.log(e.size.width/e.oldSize.width)*Math.LOG2E;s.ZoomToGeoPosition(s.GetCenterPos(),s.GetCurrentZoomlevel()+z,false,true,true);}s.resizeCanvas(e,true,true);}}};
d.prototype.setTarget=function(t){if(!t){return;}this.setAssociation("target",t);this.reset();if(t instanceof sap.m.Image){t.addDelegate({onAfterRendering:function(e){this.oTargetDomRef=t.getDomRef();this.oTargetDomRef.addEventListener("load",q.proxy(this._adaptSizeOfTarget,this));}.bind(this)});}else{t.addDelegate({onAfterRendering:function(e){this.oTargetDomRef=t.getDomRef();this._adaptSizeOfTarget();}.bind(this)});}if(this.resizeIDTarget!=""){sap.ui.core.ResizeHandler.deregister(this.resizeIDTarget);this.resizeIDTarget="";}this.resizeIDTarget=sap.ui.core.ResizeHandler.register(t,this._adaptSizeOfTarget.bind(this));};
d.prototype._adaptSizeOfTarget=function(){var t=this.oTargetDomRef;var f=this.getDomRef();if(t){try{var T=q(t);var p={top:T.offset().top,left:T.offset().left,width:T.outerWidth(),height:T.outerHeight()};q(f).width(p.width).height(p.height).css("position","absolute");q(f).css("top","0px").css("left","0px").css("visibility","");}catch(e){q.sap.log.error(e);}}else{q(f).css("position","fixed").width("0px").height("0px").css("top","0px").css("left","0px").css("visibility","hidden");}};
d.prototype.onAfterRendering=function(){if(this.$oldContent.length>0){this.$().append(this.$oldContent);}this._adaptSizeOfTarget();if(this.aLoadQueue){var n;for(n=0;n<this.aLoadQueue.length;++n){this._load(this.aLoadQueue[n]);}this.aLoadQueue=null;}if(this.resizeID==""){this.resize();this.resizeID=sap.ui.core.ResizeHandler.register(this,this.resize);}var o=this.getId();if(this.mVBIContext.m_Windows){this.mVBIContext.m_Windows.Awake(o);}};
d.prototype.onBeforeRendering=function(){this.$oldContent=sap.ui.core.RenderManager.findPreservedContent(this.getId());};
d.prototype.invalidate=function(s){this.bSceneDirty=true;if(s instanceof c){this.bVosDirty=true;this.bDataDeltaUpdate=this.bHandleDataChangeActive;}sap.ui.core.Control.prototype.invalidate.apply(this,arguments);};
d.prototype._load=function(e){if(!this.isRendered()){if(!this.aLoadQueue){this.aLoadQueue=[];}this.aLoadQueue.push(e);return;}this._loadHtml(e);};
d.prototype._loadHtml=function(e){var o=this.getId();var f=null;if(typeof e=="string"){f=JSON.parse(e.indexOf("{")?e.substr(e.indexOf("{")):e);}else if(typeof e=="object"){f=e;}if(!f){return;}if(!f["SAPVB"]){var m;if(this.mVBIContext&&(m=(new VBI.Adaptor(this.mVBIContext)).CreateLoadData(f))){this.loadHtml(m);return;}else{return;}}var h=false;var i=false;var j=false;if(q.type(f)=="object"){if(f.SAPVB){if(f.SAPVB.Config){this.mVBIContext.GetConfig().load(f.SAPVB.Config,this.mVBIContext);}if(f.SAPVB.Resources){this.mVBIContext.GetResources().load(f.SAPVB.Resources,this.mVBIContext);}if(f.SAPVB.DataTypes){if(!this.mVBIContext["m_DataTypeProvider"]){this.mVBIContext["m_DataTypeProvider"]=new VBI.DataTypeProvider();}this.mVBIContext["m_DataTypeProvider"].load(f.SAPVB.DataTypes,this.mVBIContext);}if(f.SAPVB.Data){if(!this.mVBIContext["m_DataProvider"]){this.mVBIContext["m_DataProvider"]=new VBI.DataProvider();}this.mVBIContext["m_DataProvider"].load(f.SAPVB.Data,this.mVBIContext);h=true;}if(f.SAPVB.Windows){if(!this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"]=new VBI.Windows();}this.mVBIContext["m_Windows"].load(f.SAPVB.Windows,this.mVBIContext);j=true;}if(f.SAPVB.Actions){if(!this.mVBIContext["m_Actions"]){this.mVBIContext["m_Actions"]=new VBI.Actions();}this.mVBIContext["m_Actions"].load(f.SAPVB.Actions,this.mVBIContext);}if(f.SAPVB.Automation){if(!this.mVBIContext["m_Automations"]){this.mVBIContext["m_Automations"]=new VBI.Automations();}this.mVBIContext["m_Automations"].load(f.SAPVB.Automation,this.mVBIContext);}if(f.SAPVB.Menus){if(!this.mVBIContext["m_Menus"]){this.mVBIContext["m_Menus"]=new VBI.Menus();}this.mVBIContext["m_Menus"].load(f.SAPVB.Menus,this.mVBIContext);}if(f.SAPVB.Scenes){if(!this.mVBIContext["m_SceneManager"]){this.mVBIContext["m_SceneManager"]=new VBI.SceneManager();}this.mVBIContext["m_SceneManager"].load(f.SAPVB.Scenes,this.mVBIContext);i=true;}}if(h){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].NotifyDataChange();}}if(i||j){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].Awake(o);}}if(i||h){if(this.mVBIContext["m_Windows"]){this.mVBIContext["m_Windows"].RenderAsync();}}}};
d.prototype._openContextMenu=function(t,i,m){if(m&&m.vbi_data&&m.vbi_data.VBIName=="DynContextMenu"){if(!this.mVBIContext["m_Menus"]){this.mVBIContext["m_Menus"]=new window.VBI.Menus();}for(var n=0;n<this.mAddMenuItems.length;++n){m.addItem(this.mAddMenuItems[n]);}this.mVBIContext.m_Menus.m_menus.push(m);this._loadHtml({"SAPVB":{"version":"2.0","Automation":{"Call":{"earliest":"0","handler":"CONTEXTMENUHANDLER","instance":i.sId,"name":"SHOW","object":t,"refID":"CTM","Param":[{"name":"x","#":i.mClickPos[0]},{"name":"y","#":i.mClickPos[1]},{"name":"scene","#":"MainScene"}]}}}});}this.mAddMenuItems=[];};
d.prototype._update=function(){var A={SAPVB:{}};if(this.bSceneDirty){this._updateScene(A);}this._updateWindows(A);if(A.SAPVB.Actions){Array.prototype.push.apply(A.SAPVB.Actions.Set.Action,this._getActionArray());}return this._minimizeApp(A);};
d.prototype._minimizeApp=function(A){var t,s;var e;s=null;if(!this.bWindowsDirty){e=(t=A)&&(t=t.SAPVB)&&(t=t.Windows)&&(s=JSON.stringify(t))&&(s==this.mCurWindows)&&(delete A.SAPVB.Windows);if(!e){this.mCurWindows=s?s:this.mCurWindows;}}else{this.bWindowsDirty=false;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Scenes)&&(s=JSON.stringify(t))&&(s==this.mCurScenes)&&(delete A.SAPVB.Scenes);if(!e){this.mCurScenes=s?s:this.mCurScenes;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Actions)&&(s=JSON.stringify(t))&&(s==this.mCurActions)&&(delete A.SAPVB.Actions);if(!e){this.mCurActions=s?s:this.mCurActions;}s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.DataTypes)&&(s=JSON.stringify(t))&&(s==this.mCurDataTypes)&&(delete A.SAPVB.DataTypes);if(!e){this.mCurDataTypes=s?s:this.mCurDataTypes;}if(!this.bForceDataUpdate){s=null;e=(t=A)&&(t=t.SAPVB)&&(t=t.Data)&&(s=JSON.stringify(t))&&(s==this.mCurData)&&(delete A.SAPVB.Data);if(!e){this.mCurData=s?s:this.mCurData;}}else{this.bForceDataUpdate=false;}return A;};
d.prototype._updateWindows=function(A){A.SAPVB.Windows={"Set":[{"name":"Main","Window":{"id":"Main","caption":"MainWindow","type":"geo","refParent":"","refScene":"MainScene","modal":"true"}}]};};
d.prototype._updateScene=function(A){var s=[];var e=[];var f=[];var h=[];this._updateVOData(s,e,f,h);var _=JSON.stringify(s);var m=true;if(!this.saVO){((((A.SAPVB.Scenes={}).Set={}).SceneGeo={id:"MainScene",scaleVisible:"false",navControlVisible:"false",VisualFrame:{minLOD:5},NavigationDisablement:{move:"true",zoom:"true"},initialZoom:this.initialZoom.toString(),initialStartPosition:"0.5;0.5;0"}).VO=s);}else if(this.bRefMapLayerStackDirty||!(this.saVO===_)){(A.SAPVB.Scenes=this._getSceneVOdelta(JSON.parse(this.m_saVO),s));}else{m=false;}this.saVO=_;if(this.bDataDeltaUpdate){A.SAPVB.Data=[];for(var n=0;n<e.length;++n){A.SAPVB.Data.push({Set:{name:e[n].name,type:"N",N:e[n]}});}}else{((A.SAPVB.Data={}).Set={}).N=e;}if(m){(((A.SAPVB.DataTypes={}).Set={}).N=f);}(((A.SAPVB.Actions={}).Set={}).Action=h);this.bSceneDirty=this.bVosDirty=this.bDataDeltaUpdate=false;};
d.prototype._isEventRegistered=function(A,e){var f=this.getAggregation(A);if(!f){return false;}for(var n=0;n<f.length;++n){var i=f[n];if(i.hasListeners(e)){return true;}}return false;};
d.prototype._getTemplateBindingInfo=function(A){var B=this.getBindingInfo(A);if(B&&B.template){return B.template.mBindingInfos;}};
d.prototype._getBindInfo=function(A){var B={};var t=this._getTemplateBindingInfo(A);B.C=(t)?t.hasOwnProperty("color"):true;B.CB=(t)?t.hasOwnProperty("colorBorder"):true;B.DCH=(t)?t.hasOwnProperty("deltaColorHot"):true;B.CS=(t)?t.hasOwnProperty("colorSelect"):true;B.CNS=(t)?t.hasOwnProperty("colorNonSelect"):true;B.TT=(t)?t.hasOwnProperty("tooltip"):true;B.M=(t)?t.hasOwnProperty("changeable"):true;B.hasTemplate=(t)?true:false;return B;};
d.prototype._updateVOData=function(s,e,f,h){var B,V;this.AreaBindInfo=B=(this.AreaBindInfo)?this.AreaBindInfo:this._getBindInfo("areas");V=(B.hasTemplate)?this.getBindingInfo("areas").template:null;var o={id:"OverlayArea",datasource:"OverlayArea",type:"{00100000-2012-0004-B001-F311DE491C77}"};o["posarray.bind"]=o.id+".P";if(B.C){o["color.bind"]=o.id+".C";}else{o.color=V.getColor();}if(B.CB){o["colorBorder.bind"]=o.id+".C";}else{o.colorBorder=V.getColorBorder();}if(B.DCH){o["hotDeltaColor.bind"]=o.id+".DCH";}else{o.hotDeltaColor=V.getDeltaColorHot();}if(B.CS){o["colorSelect.bind"]=o.id+".C";}else{o.colorSelect=V.getColorSelect();}if(B.CNS){o["colorNonSelect.bind"]=o.id+".C";}else{o.colorNonSelect=V.getColorNonSelect();}if(!B.M){o["VB:c"]=V.getChangeable();}s.push(o);var i={name:o.id,key:"K"};i.A=[{"name":"K","alias":"K","type":"string"},{"name":"VB:s","alias":"VB:s","type":"boolean"},{"name":"P","alias":"P","type":"vectorarray","changeable":"true"}];if(B.C){i.A.push({"name":"C","alias":"C","type":"color"});}if(B.CB){i.A.push({"name":"CB","alias":"CB","type":"string"});}if(B.DCH){i.A.push({"name":"DCH","alias":"DCH","type":"string"});}if(B.CS){i.A.push({"name":"CS","alias":"CS","type":"string"});}if(B.CNS){i.A.push({"name":"CNS","alias":"CNS","type":"string"});}if(B.TT){i.A.push({"name":"TT","alias":"TT","type":"string"});}f.push(i);var j=o.id;if(this._isEventRegistered("areas","click")){h.push({"id":j+"1","name":"click","refScene":"MainScene","refVO":j,"refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this._isEventRegistered("areas","contextMenu")){h.push({"id":j+"2","name":"contextMenu","refScene":"MainScene","refVO":j,"refEvent":"ContextMenu"});}if(this._isEventRegistered("areas","edgeClick")){h.push({"id":j+"7","name":"edgeClick","refScene":"MainScene","refVO":j,"refEvent":"EdgeClick"});}h.push({"id":j+"4","name":"handleMoved","refScene":"MainScene","refVO":j,"refEvent":"HandleMoved"});h.push({"id":j+"5","name":"handleContextMenu","refScene":"MainScene","refVO":j,"refEvent":"HandleContextMenu"});h.push({"id":j+"8","name":"edgeContextMenu","refScene":"MainScene","refVO":j,"refEvent":"EdgeContextMenu"});if(this._isEventRegistered("areas","handleClick")){h.push({"id":j+"6","name":"handleClick","refScene":"MainScene","refVO":j,"refEvent":"HandleClick"});}var k={name:o.id,E:[]};var l=this.getAreas();for(var n=0;n<l.length;++n){k.E.push(l[n].getDataElement());}e.push(k);};
d.prototype._getSceneVOdelta=function(o,n){var V=[];var r=[];var e={};for(var f=0,l=o.length;f<l;++f){e[o[f].id]=o[f];}for(var h=0;h<n.length;++h){if(e[n[h].id]){if(JSON.stringify(n[h])!=JSON.stringify(e[n[h].id])){r.push({"id":n[h].id,"type":"VO"});V.push(n[h]);}}else{V.push(n[h]);}delete e[n[h].id];}for(var i in e){r.push({"id":i,"type":"VO"});}var j={"Merge":{"name":"MainScene","type":"SceneGeo","SceneGeo":{"id":"MainScene"}}};if(r.length){j.Merge.SceneGeo.Remove=r;}if(V.length){j.Merge.SceneGeo.VO=V;}return j;};
d.prototype._getActionArray=function(){var A=[];if(this.mEventRegistry["click"]){A.push({"id":"Overlay1","name":"click","refScene":"MainScene","refVO":"Map","refEvent":"Click","AddActionProperty":[{"name":"pos"}]});}if(this.mEventRegistry["contextMenu"]){A.push({"id":"Overlay2","name":"contextMenu","refScene":"MainScene","refVO":"Map","refEvent":"ContextMenu","AddActionProperty":[{"name":"pos"}]});}A.push({"id":"Overlay3","name":"GetPosComplete","refScene":"MainScene","refVO":"General","refEvent":"CreateComplete"});return A;};
d.prototype._handleChangedData=function(n){try{this.bHandleDataChangeActive=true;if(n&&n.length){for(var e=0,N;e<n.length;++e){N=n[e];if(N.E&&N.E.length){for(var f=0,E,i;f<N.E.length;++f){E=N.E[f];i=this._findInstance(E.K);if(i){i.handleChangedData(E);}}}}}this.bHandleDataChangeActive=false;}catch(h){this.bHandleDataChangeActive=false;throw h;}};
d.prototype._findInstance=function(i){var I=(i.indexOf(".")!==-1)?i.split(".")[1]:i;var A=this.getAreas();for(var n=0;n<A.length;++n){var e=A[n];if(e.getId()===I){return e;}}return null;};
d.prototype._handleAggregationEvent=function(e){var E;if((E=this._findInstance(e.Action.instance))){try{E.handleEvent(e);}catch(f){q.sap.log.error(g().getText(M.VIT11.summary),M.VIT11.code,"sap.ui.vk.Overlay");}}};
d.prototype.isRendered=function(){return this.getDomRef()?true:false;};
d.prototype.fireSubmit=function(e){var f=JSON.parse(e.data);if(f.Data&&f.Data.Merge){this._handleChangedData(f.Data.Merge.N);}if(f.Action.object==="OverlayArea"){this._handleAggregationEvent(f);}else{var A=f.Action.name,h;if(A==="click"||A==="contextMenu"){h=[f.Action.Params.Param[0]["#"],f.Action.Params.Param[1]["#"]];}switch(A){case"GetPosComplete":if(this.mIACreateCB){try{this.mIACreateCB(f.Action.Params.Param[0]["#"]);this.mIACreateCB=null;}catch(i){this.mIACreateCB=null;throw i;}}break;case"click":this.fireClick({clientX:h[0],clientY:h[1],pos:f.Action.AddActionProperties.AddActionProperty[0]["#"]});break;case"contextMenu":if(this.mVBIContext.m_Menus){this.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}sap.ui.getCore().loadLibrary("sap.ui.unified");var m=new sap.ui.unified.Menu();m["vbi_data"]={};m["vbi_data"].menuRef="CTM";m["vbi_data"].VBIName="DynContextMenu";this.mClickPos=h;this.fireContextMenu({pos:f.Action.AddActionProperties.AddActionProperty[0]["#"],menu:m});break;default:break;}}};
d.prototype.fireRender=function(e){};
d.prototype.fireMove=function(e){};
d.prototype.fireZoom=function(e){};
d.prototype.fireOpenWindow=function(e){};
d.prototype.fireCloseWindow=function(e){};
return d;});
sap.ui.predefine('sap/ui/vk/OverlayArea',["sap/ui/core/Element","./getResourceBundle"],function(E,g){"use strict";
var O=E.extend("sap.ui.vk.OverlayArea",{metadata:{library:"sap.ui.vk",properties:{key:{type:"string",group:"Misc",defaultValue:null},position:{type:"string",group:"Misc",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Misc",defaultValue:"rgba(200, 50, 50, 0.3)"},colorBorder:{type:"sap.ui.core.CSSColor",group:"Misc",defaultValue:"rgba(200, 50, 50, 1.0)"},colorSelect:{type:"string",group:"Misc",defaultValue:null},colorNonSelect:{type:"string",group:"Misc",defaultValue:null},deltaColorHot:{type:"string",group:"Misc",defaultValue:"RHLSA(0;1.3;1.0;1.0)"},select:{type:"boolean",group:"Misc",defaultValue:false},changeable:{type:"boolean",group:"Misc",defaultValue:false}},events:{click:{clientX:{type:"int"},clientY:{type:"int"}},contextMenu:{parameters:{menu:{type:"sap.ui.unified.Menu"}}},edgeClick:{parameters:{index:{type:"int"}}},edgeContextMenu:{parameters:{index:{type:"int"},menu:{type:"sap.ui.unified.Menu"}}},handleMoved:{},handleContextMenu:{parameters:{index:{type:"int"},menu:{type:"sap.ui.unified.Menu"}}},handleClick:{index:{type:"int"}}}}});
O.prototype.openContextMenu=function(m){this.getParent().openContextMenu("OverlayArea",this,m);};
O.prototype.getDataElement=function(){var e={};var b=this.getParent().AreaBindInfo;e.K=this.getId();if(b.C){e.C=this.getColor();}if(b.CB){e.CB=this.getColorBorder();}if(b.DCH){e.DCH=this.getDeltaColorHot();}if(b.CS){e.CS=this.getColorSelect();}if(b.CNS){e.CNS=this.getColorNonSelect();}if(b.TT){e.TT=this.getTooltip();}e["VB:s"]=this.getSelect();e.P=this.getPosition();if(b.M){e["VB:c"]=this.getChangeable();}return e;};
O.prototype.handleChangedData=function(e){if(e.P){this.setPosition(e.P);}};
O.prototype.handleEvent=function(e){var a=e.Action.name;var f="fire"+a[0].toUpperCase()+a.slice(1);if(a==="contextMenu"||a==="edgeContextMenu"||a==="handleContextMenu"){var p=this.getParent();this.mClickPos=[e.Action.Params.Param[0]["#"],e.Action.Params.Param[1]["#"]];if(p.mVBIContext.m_Menus){p.mVBIContext.m_Menus.deleteMenu("DynContextMenu");}sap.ui.getCore().loadLibrary("sap.ui.unified");var m=new sap.ui.unified.Menu();m["vbi_data"]={};m["vbi_data"].menuRef="CTM";m["vbi_data"].VBIName="DynContextMenu";if(this.getChangeable()){if(a==="edgeContextMenu"){var s=e.Action.Params.Param[2]["#"];p.mAddMenuItems.push(new sap.ui.unified.MenuItem({text:g().getText("OVL_AREA_EDGE_SPLIT"),select:this._handleCtxFunction.bind(this,"SPLIT",s)}));}else if(a==="handleContextMenu"){var h=e.Action.Params.Param[2]["#"];p.mAddMenuItems.push(new sap.ui.unified.MenuItem({text:g().getText("OVL_AREA_HANDLE_REMOVE"),select:this._handleCtxFunction.bind(this,"REMOVE",h)}));}}if(this.hasListeners(a)){if(a==="contextMenu"){this.firecontextMenu({menu:m});}else{this[f]({index:e.Action.Params.Param[2]["#"],menu:m});}}else{p._openContextMenu(e.Action.object,this,m);}}else if(a=="click"){this.mClickPos=e.Action.AddActionProperties.AddActionProperty[0]["#"];this.fireClick({clientX:e.Action.Params.Param[0]["#"],clientY:e.Action.Params.Param[1]["#"]});}else if(a.indexOf("Click")>-1){this[f]({index:e.Action.Params.Param[2]["#"]});}else{this[f]();}};
O.prototype.getKey=function(){var k=this.getProperty("key");if(!k){k=this.getId();}return k;};
O.prototype._handleCtxFunction=function(f,c){var p=this.getPosition().split(";");var o=c*3;if(f==="REMOVE"){p.splice(o,3);}else if(f==="SPLIT"){var s=[p[o],p[o+1]];var e=(o+3<p.length)?[p[o+3],p[o+4]]:[p[0],p[1]];var m=[parseFloat(s[0])+(e[0]-s[0])/2,parseFloat(s[1])+(e[1]-s[1])/2];p.splice(o+3,0,m[0].toString(),m[1].toString(),"0");}this.setPosition(p.toString().replace(/,/g,";"));};
return O;});
sap.ui.predefine('sap/ui/vk/OverlayRenderer',function(){"use strict";var O={};
O.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkOverlay");r.writeClasses(c);r.write(">");r.write("</div>");var a;if((a=c._update())){c._load(a);}};
return O;},true);
sap.ui.predefine('sap/ui/vk/ViewGalleryThumbnail',["jquery.sap.global","sap/ui/core/Control","sap/m/Image"],function(q,C,I){"use strict";
var V=I.extend("sap.ui.vk.ViewGalleryThumbnail",{metadata:{associations:{viewGallery:{type:"sap.ui.vk.ViewGallery"}},properties:{enabled:{type:"boolean",defaultValue:true},thumbnailWidth:{type:"sap.ui.core.CSSSize",defaultValue:"5rem"},thumbnailHeight:{type:"sap.ui.core.CSSSize",defaultValue:"5rem"},source:{type:"string",defaultValue:""},tooltip:{type:"string",defaultValue:""},selected:{type:"boolean",defaultValue:false},processing:{type:"boolean",defaultValue:false},animated:{type:"boolean",defaultValue:false}}}});
V.prototype.init=function(){};
V.prototype.getViewGallery=function(){var a=sap.ui.getCore().byId(this.getAssociation("viewGallery"));if(a instanceof sap.ui.vk.ViewGallery){return a;}};
V.prototype._getIndex=function(){var a=this.getViewGallery();var i=a._viewItems.indexOf(this);return i;};
return V;});
sap.ui.predefine('sap/ui/vk/Viewer',["jquery.sap.global","./library","sap/ui/core/Control","./Scene","./ContentResource","./ContentConnector","./dvl/ContentManager","./FlexibleControl","sap/m/VBox","sap/m/FlexItemData","sap/ui/layout/Splitter","sap/ui/layout/SplitterLayoutData","./DvlException","./Messages","./ProgressIndicator","./Notifications","./ViewStateManager","./Toolbar","./SceneTree","./StepNavigation","./ViewGallery","./Viewport","./NativeViewport","./RedlineDesign","./ViewerRenderer","./SelectionMode","./getResourceBundle","./cssColorToColor","./colorToCSSColor","./abgrToColor","./colorToABGR"],function(q,v,C,S,a,b,D,F,V,c,d,e,f,M,P,N,g,T,h,j,k,m,n,R,o,p,r,s,t,u,w){"use strict";var x=q.sap.log;
var y=C.extend("sap.ui.vk.Viewer",{metadata:{library:"sap.ui.vk",properties:{enableOverlay:{type:"boolean",defaultValue:false},enableSceneTree:{type:"boolean",defaultValue:true},showSceneTree:{type:"boolean",defaultValue:true},enableStepNavigation:{type:"boolean",defaultValue:true},enableNotifications:{type:"boolean",defaultValue:true},showStepNavigation:{type:"boolean",defaultValue:false},showStepNavigationThumbnails:{type:"boolean",defaultValue:true},overlayStepNavigation:{type:"boolean",defaultValue:false},enableToolbar:{type:"boolean",defaultValue:true},enableProgressIndicator:{type:"boolean",defaultValue:true},width:{type:"sap.ui.core.CSSSize",defaultValue:null},height:{type:"sap.ui.core.CSSSize",defaultValue:null},toolbarTitle:{type:"string",defaultValue:""},shouldTrackVisibilityChanges:{type:"boolean",defaultValue:false},recursiveSelection:{type:"boolean",defaultValue:false},runtimeSettings:{type:"object",defaultValue:{}},webGLContextAttributes:{type:"object",defaultValue:{antialias:true,alpha:true,premultipliedAlpha:false}},showAllHotspots:{type:"boolean",defaultValue:false},hotspotColorABGR:{type:"int",defaultValue:0xc00000ff},hotspotColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(255, 0, 0, 0.7529411764705882)"}},aggregations:{contentResources:{type:"sap.ui.vk.ContentResource",forwarding:{getter:"_getContentConnector",aggregation:"contentResources"}},overlay:{type:"sap.ui.vk.Overlay",multiple:false},progressIndicator:{type:"sap.ui.vk.ProgressIndicator",multiple:false,visibility:"hidden"},layout:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false,visibility:"hidden"},viewStateManager:{type:"sap.ui.vk.ViewStateManager",multiple:false,visibility:"hidden"}},defaultAggregation:"contentResources",events:{contentResourceChangesProcessed:{},sceneLoadingSucceeded:{parameters:{scene:{type:"sap.ui.vk.Scene"}}},sceneLoadingFailed:{parameters:{reason:{type:"object"}}},sceneDestroying:{parameters:{scene:{type:"sap.ui.vk.Scene"},preventGarbageCollection:{type:"function"}}},selectionChanged:{parameters:{selected:{type:"any[]"},unselected:{type:"any[]"}}},fullScreen:{parameters:{isFullScreen:{type:"boolean"}}},urlClicked:{parameters:{nodeRef:"any",url:"string"}},nodeClicked:{parameters:{nodeRef:"any",x:"int",y:"int"}}}}});
y.prototype.applySettings=function(i){this._inApplySettings=true;C.prototype.applySettings.apply(this,arguments);delete this._inApplySettings;if(this._viewStateManager){this._viewStateManager.setShouldTrackVisibilityChanges(this.getShouldTrackVisibilityChanges());this._viewStateManager.setRecursiveSelection(this.getRecursiveSelection());}this._componentsState={sceneTree:{defaultEnable:this.getEnableSceneTree(),shouldBeEnabled:true,userInteractionShow:this.getShowSceneTree()},stepNavigation:{defaultEnable:this.getEnableStepNavigation(),userInteractionShow:this.getShowStepNavigation()},progressIndicator:{defaultEnable:this.getEnableProgressIndicator()},messagePopover:{defaultEnable:this.getEnableNotifications()}};this.setEnableSceneTree(false);this.setEnableStepNavigation(false);};
y.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}this._contentConnector=new b(this.getId()+"-contentconnector");this.setAggregation("contentConnector",this._contentConnector);this._contentConnector.attachContentReplaced(this._handleContentReplaced,this);this._contentConnector.attachContentChangesStarted(this._handleContentChangesStarted,this);this._contentConnector.attachContentChangesFinished(this._handleContentChangesFinished,this);this._contentConnector.attachContentChangesProgress(this._handleContentChangesProgress,this);this._viewStateManager=new g(this.getId()+"-viewstatemanager",{contentConnector:this._contentConnector});this.setAggregation("viewStateManager",this._viewStateManager);x.debug("sap.ui.vk.Viewer.init() called.");this._mainScene=null;this._busyIndicatorCounter=0;this._viewport=null;this._nativeViewport=null;this._redlineDesign=null;this._stepNavigation=null;this._sceneTree=null;this._overlayManager={initialized:false,changed:false,control:null,onNativeViewportMove:function(i){var l=i.getParameter("pan");var A=i.getParameter("zoom");this.control.setPanAndZoom(l.x,l.y,A);},onViewportZoom:function(i){var l=i.getParameter("zoomFactor");this.control.setPanAndZoom(0,0,l);},onViewportPan:function(i){var l=i.getParameter("dx");var A=i.getParameter("dy");this.control.setPanAndZoom(l,A,1);}};this._overlayManager.delegate={onAfterRendering:this._onAfterRenderingOverlay.bind(this,this._viewport,this._nativeViewport,this._overlayManager)};this._toolbar=new T({title:this.getToolbarTitle(),visible:this.getEnableToolbar(),viewer:this});this._stackedViewport=new F(this.getId()+"-stackedViewport",{width:"100%",height:"100%",layout:"Stacked",layoutData:new e({size:"auto",minSize:200})});this._splitter=new d(this.getId()+"-splitter",{layoutData:new sap.m.FlexItemData({growFactor:1,minHeight:"200px"}),contentAreas:[this._stackedViewport]}).addStyleClass("sapUiVizKitSplitter");this._messagePopover=new N({visible:true});this._messagePopover.attachAllMessagesCleared(this._updateLayout,this);this._messagePopover.attachMessageAdded(this._updateLayout,this);this._layout=new V(this.getId()+"-vbox",{height:"100%",items:[this._toolbar,this._splitter,this._messagePopover]}).addStyleClass("sapUiVizKitLayout");this.setAggregation("layout",this._layout);this.setTooltip(r().getText("VIEWER_TITLE"));if(this.getEnableProgressIndicator()){this._progressIndicator=new P({visible:false}).addStyleClass("sapUiVizKitProgressIndicator");this.setAggregation("progressIndicator",this._progressIndicator);}};
y.prototype.exit=function(){x.debug("sap.ui.vk.Viewer.exit() called.");if(this._viewport){this._viewport.detachEvent("viewActivated",this._onViewportViewActivated,this);this._viewport.destroy();this._viewport=null;}if(this._nativeViewport){this._nativeViewport.destroy();this._nativeViewport=null;}this._setMainScene(null);this._toolbar=null;this._messagePopover=null;this._sceneTree=null;this._stepNavigation=null;this._componentsState=null;this._viewStateManager=null;this._contentConnector=null;if(C.prototype.exit){C.prototype.exit.apply(this);}};
y.prototype._setMainScene=function(i){if(i){if(i!==this._mainScene){this._mainScene=i;this._showViewport();if(this._componentsState.sceneTree.defaultEnable){this._instantiateSceneTree();this.setEnableSceneTree(true);if(this._componentsState.sceneTree.userInteractionShow&&this._componentsState.sceneTree.shouldBeEnabled){this.setShowSceneTree(true);this._sceneTree.setVisible(true);}else{this.setShowSceneTree(false);}}else if(this._sceneTree&&this._viewStateManager){this._sceneTree.setScene(i,this._viewStateManager);}this.setEnableStepNavigation(this.getEnableStepNavigation()||this._componentsState.stepNavigation.defaultEnable);if(this.getEnableStepNavigation()){this._instantiateStepNavigation();this.setShowStepNavigation(this._componentsState.stepNavigation.userInteractionShow);}}if(this._stepNavigation){this._stepNavigation.refresh(i);}}else{this._mainScene=null;this.setEnableSceneTree(false);this.setEnableStepNavigation(false);}return this;};
y.prototype.getGraphicsCore=function(){return this._mainScene instanceof v.dvl.Scene?this._mainScene.getGraphicsCore():null;};
y.prototype.getScene=function(){return this._mainScene;};
y.prototype.getViewStateManager=function(){return this._viewStateManager;};
y.prototype.getViewport=function(){if(!this._viewport){this._viewport=new m(this.getId()+"-viewport",{viewStateManager:this._viewStateManager,selectionMode:p.Exclusive,contentConnector:this._contentConnector});this._viewport.attachEvent("viewActivated",this._onViewportViewActivated,this);}return this._viewport;};
y.prototype.getNativeViewport=function(){return this._nativeViewport;};
y.prototype.getToolbar=function(){return this._toolbar;};
y.prototype.getSceneTree=function(){return this._sceneTree;};
y.prototype.getRedlineDesign=function(){return this._redlineDesign;};
y.prototype.getOverlay=function(){return this._overlayManager.control;};
y.prototype.setEnableOverlay=function(i){if(i!==this.getProperty("enableOverlay")){this.setProperty("enableOverlay",i);this._overlayManager.changed=true;}return this;};
y.prototype.setEnableSceneTree=function(i){this.setProperty("enableSceneTree",i,true);if(!i){this.setProperty("showSceneTree",false);}this._updateLayout();return this;};
y.prototype.setEnableNotifications=function(i){this.setProperty("enableNotifications",i,true);this._messagePopover.setVisible(false);this._updateLayout();return this;};
y.prototype.setShowSceneTree=function(i){this.setProperty("showSceneTree",i,true);this._updateLayout();return this;};
y.prototype.setEnableStepNavigation=function(i){this.setProperty("enableStepNavigation",i,true);if(!i){this.setProperty("showStepNavigation",false);}this._updateLayout();return this;};
y.prototype.setShowStepNavigation=function(i){this.setProperty("showStepNavigation",i,true);this._updateLayout();return this;};
y.prototype.setEnableToolbar=function(i){this.setProperty("enableToolbar",i,true);this._toolbar.setVisible(i);return this;};
y.prototype.setRecursiveSelection=function(i){this.setProperty("recursiveSelection",i,true);if(this._viewStateManager){this._viewStateManager.setRecursiveSelection(i);}return this;};
y.prototype.setToolbarTitle=function(i){this.setProperty("toolbarTitle",i);this._toolbar.setTitle(i);return this;};
y.prototype.activateFullScreenMode=function(i){var l=function(E){return!!(E.fullScreen||E.webkitIsFullScreen||E.mozFullScreen||E.msFullscreenElement);};if(i){if(!l(document)){if(!this._fullScreenHandler){var A=this;this._fullScreenHandler=function(E){var G=l(document);if(!G){A.removeStyleClass("sapVizKitViewerFullScreen");document.removeEventListener("fullscreenchange",A._fullScreenHandler);document.removeEventListener("mozfullscreenchange",A._fullScreenHandler);document.removeEventListener("webkitfullscreenchange",A._fullScreenHandler);document.removeEventListener("MSFullscreenChange",A._fullScreenHandler);}A.fireFullScreen({isFullScreen:G});};}var B=document.getElementsByTagName("body")[0];if(B.requestFullScreen){document.addEventListener("fullscreenchange",this._fullScreenHandler);B.requestFullScreen();}else if(B.webkitRequestFullScreen){document.addEventListener("webkitfullscreenchange",this._fullScreenHandler);B.webkitRequestFullScreen();}else if(B.mozRequestFullScreen){document.addEventListener("mozfullscreenchange",this._fullScreenHandler);B.mozRequestFullScreen();}else if(B.msRequestFullscreen){document.addEventListener("MSFullscreenChange",this._fullScreenHandler);B.msRequestFullscreen();}}this.addStyleClass("sapVizKitViewerFullScreen");}else{if(l(document)){if(document.cancelFullScreen){document.cancelFullScreen();}else if(document.webkitCancelFullScreen){document.webkitCancelFullScreen();}else if(document.mozCancelFullScreen){document.mozCancelFullScreen();}else if(document.msExitFullscreen){document.msExitFullscreen();}}this.removeStyleClass("sapVizKitViewerFullScreen");}return this;};
function z(i){if(!i){return false;}return i instanceof v.dvl.Viewport;}
y.prototype.getShowAllHotspots=function(){var i=this.getViewport().getImplementation();return z(i)?i.getShowAllHotspots():this.getProperty("showAllHotspots");};
y.prototype.setShowAllHotspots=function(i){this.setProperty("showAllHotspots",i,true);var l=this.getViewport().getImplementation();if(z(l)){l.setShowAllHotspots(i);}return this;};
y.prototype.getHotspotColorABGR=function(){var i=this.getViewport().getImplementation();return z(i)?i.getHotspotColorABGR():this.getProperty("hotspotColorABGR");};
y.prototype.setHotspotColorABGR=function(i){this.setProperty("hotspotColorABGR",i,true);this.setProperty("hotspotColor",t(u(i)),true);var l=this.getViewport().getImplementation();if(z(l)){l.setHotspotColorABGR(i);}return this;};
y.prototype.getHotspotColor=function(){var i=this.getViewport().getImplementation();return z(i)?i.getHotspotColor():this.getProperty("hotspotColor");};
y.prototype.setHotspotColor=function(i){this.setProperty("hotspotColor",i,true);this.setProperty("hotspotColorABGR",w(s(i)),true);var l=this.getViewport().getImplementation();if(z(l)){l.setHotspotColor(i);}return this;};
y.prototype.setRuntimeSettings=function(i){if(this._inApplySettings){this.setProperty("runtimeSettings",i,true);D.setRuntimeSettings(i);}else{x.error(r().getText(M.VIT29.summary),M.VIT29.code,"sap.ui.vk.Viewer");}return this;};
y.prototype.setWebGLContextAttributes=function(i){if(this._inApplySettings){this.setProperty("webGLContextAttributes",i,true);D.setWebGLContextAttributes(i);}else{x.error(r().getText(M.VIT30.summary),M.VIT30.code,"sap.ui.vk.Viewer");}return this;};
y.prototype.invalidate=function(i){if(i instanceof a){this._contentConnector.invalidate(i);return;}C.prototype.invalidate.apply(this,arguments);};
y.prototype._getContentConnector=function(){return this._contentConnector;};
y.prototype.onBeforeRendering=function(){this._showOverlay();};
y.prototype.isTreeBinding=function(i){return i==="contentResources";};
y.prototype.setBusy=function(i){if(i){if(this._busyIndicatorCounter===0){this.setBusyIndicatorDelay(0);C.prototype.setBusy.call(this,true);}this._busyIndicatorCounter+=1;}else{this._busyIndicatorCounter-=1;if(this._busyIndicatorCounter==0){C.prototype.setBusy.call(this,false);}}};
y.prototype._updateLayout=function(){if(this._sceneTree){if(this.getShowSceneTree()&&this.getEnableSceneTree()){this._sceneTree.setVisible(true);if(this._splitter.indexOfContentArea(this._sceneTree)<0){this._splitter.insertContentArea(this._sceneTree,0);}}else{if(this._splitter.indexOfContentArea(this._sceneTree)>=0){this._splitter.removeContentArea(this._sceneTree);}this._sceneTree.setVisible(false);}}if(this._stepNavigation){this._stepNavigation.setVisible(this.getShowStepNavigation()&&this.getEnableStepNavigation());}if(this._messagePopover){this._messagePopover.setVisible(this.getEnableNotifications()&&this._messagePopover.getAggregation("_messagePopover").getItems().length>0);}if(this._toolbar){this._toolbar.refresh();}};
y.prototype._instantiateSceneTree=function(){if(!this._sceneTree){this._sceneTree=new h({layoutData:new e({size:"320px",minSize:200}),viewStateManager:this._viewStateManager,contentConnector:this._contentConnector});}return this;};
y.prototype._instantiateStepNavigation=function(){if(this._stepNavigation){this._layout.removeItem(this._stepNavigation);this._viewport.removeContent(this._stepNavigation);this._splitter.detachResize(this._handleSplitterResize,this);this._stepNavigation=null;}if(this._mainScene instanceof v.dvl.Scene){this._stepNavigation=new j({showThumbnails:this.getShowStepNavigationThumbnails(),contentConnector:this._contentConnector});this._layout.insertItem(this._stepNavigation,3);}else if(this._mainScene instanceof v.threejs.Scene){this._stepNavigation=new k({viewport:this.getViewport(),contentConnector:this._contentConnector});if(!this.getOverlayStepNavigation()){this._layout.insertItem(this._stepNavigation,3);}else{this._stepNavigation.addStyleClass("sapVizKitViewGallery");this._viewport.addContent(this._stepNavigation);this._splitter.attachResize(this._handleSplitterResize,this);}}return this;};
y.prototype._handleSplitterResize=function(){this._stepNavigation.resizeToolbarSpacer();};
y.prototype._showViewport=function(){var i=this.getViewport().getImplementation();if(z(i)){i.setHotspotColor(this.getProperty("hotspotColor"));i.setHotspotColorABGR(this.getProperty("hotspotColorABGR"));i.setShowAllHotspots(this.getProperty("showAllHotspots"));}if(this._nativeViewport){this._nativeViewport.setVisible(false);}this._stackedViewport.removeAllContent();this._stackedViewport.addContent(this._viewport);this._viewport.setVisible(true);return this;};
y.prototype._showNativeViewport=function(){if(!this._nativeViewport){this._nativeViewport=new n(this.getId()+"-nativeViewport",{limitZoomOut:true,contentConnector:this._contentConnector});}if(this._viewport){this._viewport.setVisible(false);}this._stackedViewport.removeAllContent();this._stackedViewport.addContent(this._nativeViewport);this._nativeViewport.setVisible(true);return this;};
y.prototype._showOverlay=function(){var O=this._overlayManager;if(O.changed){var i;if(this.getEnableOverlay()){sap.ui.require(["sap/ui/vk/Overlay"],function(l){if(!O.initialized){if(!(i=this.getAggregation("overlay"))){i=new l();}i.setZoomOnResize(false);O.control=i;O.initialized=true;}else{i=O.control;i.reset();}if(this._nativeViewport&&this._nativeViewport.getVisible()){i.setTarget(this._nativeViewport);O.savedLimitZoomOutState=this._nativeViewport.getLimitZoomOut();this._nativeViewport.setLimitZoomOut(true);this._nativeViewport.attachEvent("move",O.onNativeViewportMove,O);}else if(this._viewport&&this._viewport.getVisible()){i.setTarget(this._viewport);O.savedLimitZoomOutState=false;this._viewport.attachEvent("zoom",O.onViewportZoom,O);this._viewport.attachEvent("pan",O.onViewportPan,O);}this._stackedViewport.addContent(i);this._stackedViewport.addDelegate(O.delegate);}.bind(this));}else{this._nativeViewport.detachEvent("move",O.onNativeViewportMove,O);this._stackedViewport.removeDelegate(O.delegate);this._stackedViewport.removeContent(O.control);this._nativeViewport.setLimitZoomOut(O.savedLimitZoomOutState);}O.changed=false;}};
y.prototype._onAfterRenderingOverlay=function(E){var i=this._overlayManager.control.getDomRef();if(i&&(this._nativeViewport||this._viewport)){var l=this._nativeViewport&&this._nativeViewport.getVisible()?this._nativeViewport.getDomRef():this._viewport.getDomRef();if(i.parentNode!==l){i.parentNode.style.display="none";}l.appendChild(i);i.style.width="100%";i.style.height="100%";}};
y.prototype.setDecryptionHandler=function(i){this._contentConnector.setDecryptionHandler(i);return this;};
y.prototype.setAuthorizationHandler=function(i){this._contentConnector.setAuthorizationHandler(i);return this;};
y.prototype._instantiateRedlineDesign=function(i){var l=this.getViewport().getImplementation();if((l&&l.getVisible())||(this.getNativeViewport()&&this.getNativeViewport().getVisible())){var A=l&&l.getVisible()?l:this.getNativeViewport();var B=A.getOutputSize();this._redlineDesign=new R({visible:false,virtualTop:B.top,virtualLeft:B.left,virtualSideLength:B.sideLength,redlineElements:i});this._redlineDesign._setTargetViewport(A);}return this;};
y.prototype.activateRedlineDesign=function(i){var l=this.getViewport().getImplementation();if(l instanceof v.threejs.Viewport){l._viewportGestureHandler._activateRedline();}if(l instanceof v.dvl.Viewport&&l.getViewInfo().camera&&l.getViewInfo().camera.projectionType==="perspective"){l._activateRedline();}i=i||[];this._instantiateRedlineDesign(i);this.getRedlineDesign().placeAt(this._stackedViewport);this.getRedlineDesign().setVisible(true);var A=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");l.queueCommand(function(K,L){l.pan(K,L);l.endGesture();}.bind(this,K,L));};var B=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");l.queueCommand(function(K,L,O){l.beginGesture(K,L);l.zoom(O);l.endGesture();}.bind(this,K,L,O));};var E=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");this.getNativeViewport().queueCommand(function(){this.getNativeViewport().pan(K,L);this.getNativeViewport().endGesture();}.bind(this));};var G=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");this.getNativeViewport().queueCommand(function(K,L,O){this.getNativeViewport().beginGesture(K,L);this.getNativeViewport().zoom(O);this.getNativeViewport().endGesture();}.bind(this,K,L,O));};var H=function(J){var K=J.getParameter("deltaX"),L=J.getParameter("deltaY");l.queueCommand(function(K,L){l._viewportGestureHandler._cameraController.beginGesture(K,L);l._viewportGestureHandler._cameraController.pan(K,L);l._viewportGestureHandler._cameraController.endGesture();}.bind(this,K,L));};var I=function(J){var K=J.getParameter("originX"),L=J.getParameter("originY"),O=J.getParameter("zoomFactor");l.queueCommand(function(K,L,O){l._viewportGestureHandler._cameraController.beginGesture(K,L);l._viewportGestureHandler._cameraController.zoom(O);l._viewportGestureHandler._cameraController.endGesture();}.bind(this,K,L,O));};if(this.getNativeViewport()&&this.getNativeViewport().getVisible()){this.getRedlineDesign().attachEvent("pan",E.bind(this));this.getRedlineDesign().attachEvent("zoom",G.bind(this));}else if(l&&z(l)&&l.getVisible()){this.getRedlineDesign().attachEvent("pan",A.bind(this));this.getRedlineDesign().attachEvent("zoom",B.bind(this));}else if(l instanceof v.threejs.Viewport&&l.getVisible()){this.getRedlineDesign().attachEvent("pan",H.bind(this));this.getRedlineDesign().attachEvent("zoom",I.bind(this));}else{q.sap.log.Error("Error: Viewport not supported");}return this;};
y.prototype.destroyRedlineDesign=function(){if(this.getRedlineDesign()){var i=this.getViewport().getImplementation();if(i instanceof v.dvl.Viewport){i._deactivateRedline();}else if(i instanceof v.threejs.Viewport){i._viewportGestureHandler._deactivateRedline();}this.getRedlineDesign().destroy();this._redlineDesign=null;}return this;};
y.prototype._onViewportViewActivated=function(i){this._componentsState.sceneTree.shouldBeEnabled=i.getParameter("type")==="3D";};
y.prototype._handleContentReplaced=function(i){var l=i.getParameter("newContent");if(l&&l instanceof v.Scene){this._showViewport();if(this.getRedlineDesign()){this.getRedlineDesign().updatePanningRatio();}this._setMainScene(l);}else if(l instanceof HTMLImageElement||l instanceof HTMLObjectElement){this._setMainScene(null);this._showNativeViewport();if(this.getEnableOverlay()){this._overlayManager.changed=true;this._showOverlay();}}else{this._setMainScene(null);if(this._viewport){this._viewport.setVisible(false);}if(this._nativeViewport){this._nativeViewport.setVisible(false);}this._stackedViewport.removeAllContent();}};
y.prototype._handleContentChangesStarted=function(i){this.setBusy(true);if(this._componentsState.progressIndicator.defaultEnable){this._progressIndicator.setPercentValue(0.0);this._progressIndicator.setVisible(true);this.getViewport().stopAnimation();}};
y.prototype._handleContentChangesFinished=function(i){x.info("Finished");setTimeout(function(){this._progressIndicator.setVisible(false);this._progressIndicator.setDisplayValue("");this._progressIndicator.setPercentValue(0);}.bind(this),0);this.setBusy(false);var l=i.getParameter("content");if(l){this.fireSceneLoadingSucceeded({scene:l});}var A=i.getParameter("failureReason");if(A){this.fireSceneLoadingFailed({reason:A});this._showNativeViewport();var B=r().getText("VIEWER_UNKNOWN_CONTENT_RESOURCE_TYPE_CAUSE");if(A.errorMessage===B){this._nativeViewport.loadFailed();}else{var E=r().getText("VIEWPORT_MESSAGEERRORLOADINGFILE");this._nativeViewport.loadFailed(E);}(Array.isArray(A)?A:[A]).forEach(function(G){x.error(r().getText(M.VIT13.summary),G.errorMessage,"sap.ui.vk.Viewer");});}this.fireContentResourceChangesProcessed();};
y.prototype._handleContentChangesProgress=function(A){function B(K,E){for(var i=0,l=K.length;i<l;i++){var L=K[i];var O=L.getSource();if((O===E)||(O instanceof File&&O.name===E)){return L;}L=B(L.getContentResources(),E);if(L){return L;}}return null;}if(this._progressIndicator.getVisible()){var E=A.getParameter("source"),G=A.getParameter("percentage"),H=A.getParameter("phase");var I=B(this.getContentResources(),E);if(I&&I.getName()!==undefined){E=I.getName();}else{var J=E.match(/\..{3,4}$/);E=J&&J[0]?E.split(/\\|\//).pop():"";}this._progressIndicator.setPercentValue(G);this._progressIndicator.setDisplayValue(E+" "+H+" "+(G?Math.floor(G)+"%":""));}};
y.prototype._handleContentDestroying=function(i){this.fireSceneDestroying({scene:i.getParameter("content").scene,preventGarbageCollection:i.getParameter("preventGarbageCollection")});};
return y;});
sap.ui.predefine('sap/ui/vk/library',["sap/base/util/ObjectPath","./BillboardBorderLineStyle","./BillboardCoordinateSpace","./BillboardHorizontalAlignment","./BillboardStyle","./BillboardTextEncoding","./CameraFOVBindingType","./CameraProjectionType","./ContentResourceSourceCategory","./ContentResourceSourceTypeToCategoryMap","./DetailViewShape","./DetailViewType","./DvlException","./LeaderLineMarkStyle","./MapContainerButtonType","./Redline","./RenderMode","./SelectionMode","./TransformationMatrix","./VisibilityMode","./ZoomTo","./abgrToColor","./colorToABGR","./cssColorToColor","./colorToCSSColor","./getResourceBundle","./utf8ArrayBufferToString","./dvl/GraphicsCoreApi","./dvl/checkResult","./dvl/getJSONObject","./dvl/getPointer","./tools/AxisColours","./tools/CoordinateSystem","./tools/HitTestClickType","./tools/HitTestIdMode","./tools/PredefinedView"],function(O){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.vk",dependencies:["sap.ui.core"],interfaces:["sap.ui.vk.AuthorizationHandler","sap.ui.vk.DecryptionHandler"],types:[],controls:["sap.ui.vk.AnimationTimeSlider","sap.ui.vk.ContainerBase","sap.ui.vk.ContainerContent","sap.ui.vk.DrawerToolbar","sap.ui.vk.FlexibleControl","sap.ui.vk.LegendItem","sap.ui.vk.ListPanel","sap.ui.vk.ListPanelStack","sap.ui.vk.MapContainer","sap.ui.vk.NativeViewport","sap.ui.vk.Notifications","sap.ui.vk.Overlay","sap.ui.vk.ProgressIndicator","sap.ui.vk.RedlineDesign","sap.ui.vk.RedlineSurface","sap.ui.vk.SceneTree","sap.ui.vk.StepNavigation","sap.ui.vk.Toolbar","sap.ui.vk.Viewer","sap.ui.vk.ViewGallery","sap.ui.vk.Viewport","sap.ui.vk.ViewportBase","sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport","sap.ui.vk.tools.AnchorPointToolGizmo","sap.ui.vk.tools.CrossSectionToolGizmo","sap.ui.vk.tools.Gizmo","sap.ui.vk.tools.MoveToolGizmo","sap.ui.vk.tools.RotateToolGizmo","sap.ui.vk.tools.ScaleToolGizmo","sap.ui.vk.tools.SceneOrientationToolGizmo","sap.ui.vk.tools.TooltipToolGizmo"],elements:["sap.ui.vk.ContentConnector","sap.ui.vk.FlexibleControlLayoutData","sap.ui.vk.OverlayArea","sap.ui.vk.RedlineElement","sap.ui.vk.RedlineElementEllipse","sap.ui.vk.RedlineElementFreehand","sap.ui.vk.RedlineElementLine","sap.ui.vk.RedlineElementRectangle","sap.ui.vk.RedlineElementText","sap.ui.vk.ViewStateManager","sap.ui.vk.ViewStateManagerBase","sap.ui.vk.dvl.ViewStateManager","sap.ui.vk.threejs.NodesTransitionHelper","sap.ui.vk.threejs.ViewStateManager","sap.ui.vk.tools.AnchorPointTool","sap.ui.vk.tools.CrossSectionTool","sap.ui.vk.tools.HitTestTool","sap.ui.vk.tools.MoveTool","sap.ui.vk.tools.RectSelectTool","sap.ui.vk.tools.RotateOrbitTool","sap.ui.vk.tools.RotateTool","sap.ui.vk.tools.RotateTurntableTool","sap.ui.vk.tools.ScaleTool","sap.ui.vk.tools.SceneOrientationTool","sap.ui.vk.tools.Tool","sap.ui.vk.tools.TooltipTool"],noLibraryCSS:false,version:"1.71.8",designtime:"sap/ui/vk/designtime/library.designtime"});var v=O.get("sap.ui.vk");var s={};s["sap/ui/vk/threejs/thirdparty/three"]={exports:"THREE",amd:true};s["sap/ui/vk/thirdparty/html2canvas"]={exports:"html2canvas",amd:true};sap.ui.loader.config({shim:s});var l=function(a,b){var m="new extend getMetadata";if(b){m+=" "+b;}sap.ui.lazyRequire("sap.ui.vk."+a,m);};l("AnimationPlayback");l("AnimationSequence");l("BaseNodeProxy");l("Camera");l("ContentConnector","registerSourceType");l("ContentManager");l("ContentResource");l("Core");l("DownloadManager");l("ImageContentManager");l("LayerProxy");l("Loco");l("Material");l("NodeHierarchy");l("NodeProxy");l("OrthographicCamera");l("PerspectiveCamera");l("RedlineDesignHandler");l("RedlineGesturesHandler");l("Scene");l("Smart2DHandler");l("Texture");l("View");l("ViewportHandler");l("dvl.BaseNodeProxy");l("dvl.ContentManager","getRuntimeSettings setRuntimeSettings getWebGLContextAttributes setWebGLContextAttributes getDecryptionHandler setDecryptionHandler");l("dvl.GraphicsCore");l("dvl.LayerProxy");l("dvl.NodeHierarchy");l("dvl.NodeProxy");l("dvl.Scene");l("helpers.RotateOrbitHelperDvl");l("helpers.RotateOrbitHelperThree");l("helpers.RotateTurntableHelperDvl");l("helpers.RotateTurntableHelperThree");l("threejs.AnimationSequence");l("threejs.BaseNodeProxy");l("threejs.Billboard");l("threejs.Callout");l("threejs.ContentDeliveryService");l("threejs.ContentManager","registerLoader");l("threejs.DetailView");l("threejs.LayerProxy");l("threejs.Material");l("threejs.NodeHierarchy");l("threejs.NodeProxy");l("threejs.OrthographicCamera");l("threejs.PerspectiveCamera");l("threejs.Scene");l("threejs.Texture");l("threejs.Thrustline");l("threejs.ViewportGestureHandler");l("tools.AnchorPointToolHandler");l("tools.CrossSectionToolHandler");l("tools.HitTestToolHandler");l("tools.MoveToolHandler");l("tools.RectSelectToolHandler");l("tools.RotateToolHandler");l("tools.ScaleToolHandler");l("tools.TooltipToolHandler");return v;});
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.predefine('sap/ui/vk/AnimationPlayback',["jquery.sap.global","sap/ui/base/ManagedObject"],function(q,M){"use strict";
var A=M.extend("sap.ui.vk.AnimationPlayback",{metadata:{library:"sap.ui.vk",properties:{pid:{type:"string"},sequenceId:{type:"string"},timeScale:{type:"float",defaultValue:1},preDelay:{type:"float",defaultValue:0},postDelay:{type:"float",defaultValue:0},repeat:{type:"int",defaultValue:1},reversed:{type:"boolean",defaultValue:false},startTime:{type:"float",defaultValue:0},infinite:{type:"boolean",defaultValue:false}}}});
return A;});
sap.ui.predefine('sap/ui/vk/AnimationSequence',["jquery.sap.global","sap/ui/base/ManagedObject","./AnimationTrackType","./AnimationRotateType","./AnimationInterpolationType"],function(q,M,A,a,b){"use strict";
var c=M.extend("sap.ui.vk.AnimationSequence",{metadata:{library:"sap.ui.vk",properties:{name:{type:"string"},sequenceId:{type:"string"}},events:{keyFrameAdded:{parameters:{sequenceId:"string",targetNodeRef:"object",trackType:"sap.ui.vk.AnimationTrackType",keyFrameValue:"float[]",keyFrameTime:"float"},enableEventBubbling:true},keyFrameUpdated:{parameters:{sequenceId:"string",targetNodeRef:"object",trackType:"sap.ui.vk.AnimationTrackType",keyFrameValue:"float[]",keyFrameTime:"float",keyFrameIndex:"int"},enableEventBubbling:true},keyFrameDeleted:{parameters:{sequenceId:"string",targetNodeRef:"object",trackType:"sap.ui.vk.AnimationTrackType",keyFrameValue:"float[]",keyFrameTime:"float",keyFrameIndex:"int",lastKeyFrame:"boolean"},enableEventBubbling:true}}}});
return c;});
sap.ui.predefine('sap/ui/vk/AnimationTimeSlider',["sap/m/Slider","./AnimationTimeSliderRenderer"],function(S,A){"use strict";
var a=S.extend("sap.ui.vk.AnimationTimeSlider",{metadata:{library:"sap.ui.vk"}});
a.prototype.init=function(){if(S.prototype.init){S.prototype.init.call(this);}};
a.prototype.handleAnimationStarted=function(e){this.setProgress(true);this.setValue(0);this.setStep(0.1);};
a.prototype.handleAnimationUpdated=function(e){var v=e.getParameter("value");this.setValue(v);};
a.prototype.handleAnimationFinished=function(e){this.setValue(100);};
return a;});
sap.ui.predefine('sap/ui/vk/AnimationTimeSliderRenderer',["sap/m/SliderRenderer"],function(S){"use strict";return S;},true);
sap.ui.predefine('sap/ui/vk/BaseNodeProxy',["sap/ui/base/Object"],function(B){"use strict";
var a=B.extend("sap.ui.vk.BaseNodeProxy",{metadata:{"abstract":true}});
return a;});
sap.ui.predefine('sap/ui/vk/BillboardBorderLineStyle',[],function(){"use strict";var B={None:"None",Solid:"Solid",Dash:"Dash",Dot:"Dot",DashDot:"DashDot",DashDotDot:"DashDotDot"};return B;},true);
sap.ui.predefine('sap/ui/vk/BillboardCoordinateSpace',[],function(){"use strict";var B={Viewport:"Viewport",Screen:"Screen",World:"World"};return B;},true);
sap.ui.predefine('sap/ui/vk/BillboardHorizontalAlignment',[],function(){"use strict";var B={Left:"left",Center:"center",Right:"right"};return B;},true);
sap.ui.predefine('sap/ui/vk/BillboardStyle',[],function(){"use strict";var B={RectangularShape:"RectangularShape",CircularShape:"CircularShape",None:"None",TextGlow:"TextGlow"};return B;},true);
sap.ui.predefine('sap/ui/vk/BillboardTextEncoding',[],function(){"use strict";var B={PlainText:"PlainText",HtmlText:"HtmlText"};return B;},true);
sap.ui.predefine('sap/ui/vk/Camera',["sap/ui/base/ManagedObject"],function(M){"use strict";
var C=M.extend("sap.ui.vk.Camera",{metadata:{properties:{"position":{type:"float[]"},"targetDirection":{type:"float[]"},"upDirection":{type:"float[]"},"nearClipPlane":{type:"float"},"farClipPlane":{type:"float"}}}});
C.prototype.getCameraRef=function(){return null;};
C.prototype.getIsModified=function(){return!!this._isModified;};
C.prototype.setIsModified=function(v){this._isModified=v;};
return C;});
sap.ui.predefine('sap/ui/vk/CameraFOVBindingType',[],function(){"use strict";var C={Minimum:"minimum",Maximum:"maximum",Horizontal:"horizontal",Vertical:"vertical"};return C;},true);
sap.ui.predefine('sap/ui/vk/CameraProjectionType',[],function(){"use strict";var C={Perspective:"perspective",Orthographic:"orthographic"};return C;},true);
sap.ui.predefine('sap/ui/vk/ContentConnector',["jquery.sap.global","sap/ui/base/ManagedObjectObserver","sap/ui/core/Element","./Messages","./Core","./getResourceBundle","./ContentResource"],function(q,M,E,a,v,g,C){"use strict";var l=q.sap.log;
var b=E.extend("sap.ui.vk.ContentConnector",{metadata:{library:"sap.ui.vk",aggregations:{contentResources:{type:"sap.ui.vk.ContentResource",bindable:"bindable"},viewStateManagers:{type:"sap.ui.vk.ViewStateManager"},contentManagers:{type:"sap.ui.vk.ContentManager",visibility:"hidden"}},defaultAggregation:"contentResources",events:{contentChangesStarted:{parameters:{}},contentChangesFinished:{parameters:{content:{type:"any"},failureReason:{type:"any"}}},contentChangesProgress:{parameters:{phase:{type:"string"},percentage:{type:"float"},source:{type:"any"}}},contentReplaced:{parameters:{newContent:{type:"any"},oldContent:{type:"any"}}},contentDestroying:{parameters:{content:{type:"any"},preventGarbageCollection:{type:"function"}}}}}});
v.registerClass(b);var c=b.getMetadata().getParent().getClass().prototype;
b.prototype.isTreeBinding=function(n){return n==="contentResources";};
b.prototype.init=function(){if(c.init){c.init.call(this);}this._inLoading=false;this._delayContentResourcesUpdate=false;this._scheduleContentResourcesUpdateTimerId=null;this._content=null;this._contentManager=null;this._decryptionHandler=null;this._authorizationHandler=null;this._selfObserver=new M(this._observeChanges.bind(this));this._selfObserver.observe(this,{aggregations:["contentResources","viewStateManagers"]});};
b.prototype.exit=function(){b._cleanAssociatedLoaders();this._selfObserver.disconnect();this._selfObserver=null;if(this._scheduleContentResourcesUpdateTimerId){q.sap.clearDelayedCall(this._scheduleContentResourcesUpdateTimerId);this._scheduleContentResourcesUpdateTimerId=null;}this._delayContentResourcesUpdate=false;this._setContent(null,null);if(c.exit){c.exit.call(this);}};
b.prototype._observeChanges=function(e){if(e.name==="contentResources"){this._scheduleContentResourcesUpdate();}else if(e.name==="viewStateManagers"){if(e.mutation==="insert"){e.child.setContentConnector(this);}else if(e.mutation==="remove"){e.child.setContentConnector(null);}}};
b.prototype.invalidate=function(o){if(o instanceof C){this._scheduleContentResourcesUpdate();return;}c.invalidate.apply(this,arguments);};
b.prototype._scheduleContentResourcesUpdate=function(){if(this._inLoading){this._delayContentResourcesUpdate=true;return this;}if(!this._scheduleContentResourcesUpdateTimerId){this._scheduleContentResourcesUpdateTimerId=q.sap.delayedCall(0,this,function(){this._scheduleContentResourcesUpdateTimerId=null;var e=this.getContentResources();if(e.length>0){this._collectContentResourceSourceTypeInformation(e).then(function(i){if(i.dimensions.length>1){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this._setContent(null,null);this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText(a.VIT17.cause)}});l.error(g().getText(a.VIT17.summary),a.VIT17.code,"sap.ui.vk.ContentConnector");});}else if(i.contentManagerClassNames.length>1){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this._setContent(null,null);this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText(a.VIT35.cause)}});l.error(g().getText(a.VIT35.summary),a.VIT35.code,"sap.ui.vk.ContentConnector");});}else if(i.contentManagerClassNames.length===0){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this._setContent(null,null);this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText(a.VIT36.cause)}});l.error(g().getText(a.VIT36.summary),a.VIT36.code,"sap.ui.vk.ContentConnector");});}else if(i.contentManagerClassNames.length===1){var t=this;this._getContentManagerByClassName(i.contentManagerClassNames[0]).then(function(h){if(t._contentManager&&h!==t._contentManager){t.fireContentChangesStarted();t._setContent(null,null);t.fireContentChangesFinished({content:null});}h.loadContent(t._content,e);});}}.bind(this));}else{q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this._setContent(null,null);this.fireContentChangesFinished({content:null});});}});}return this;};
b.prototype._handleContentChangesStarted=function(e){this._inLoading=true;this.fireContentChangesStarted();};
b.prototype._handleContentChangesFinished=function(e){var h=e.getParameter("content");this._setContent(h,e.getSource());this.fireContentChangesFinished({content:h,failureReason:e.getParameter("failureReason")});this._inLoading=false;if(this._delayContentResourcesUpdate){this._delayContentResourcesUpdate=false;this._scheduleContentResourcesUpdate();}};
b.prototype._handleContentChangesProgress=function(e){this.fireContentChangesProgress({phase:e.getParameter("phase"),source:e.getParameter("source"),percentage:e.getParameter("percentage")});};
b.prototype._getContentManagerByClassName=function(e){var h,j=this.getAggregation("contentManagers",[]);for(var i=0,k=j.length;i<k;++i){h=j[i];if(h.getMetadata().getName()===e){return Promise.resolve(h);}}var t=this;return new Promise(function(n,o){sap.ui.require([e.replace(/\./g,"/")],function(p){var h=new p();t.addAggregation("contentManagers",h);h.attachContentChangesStarted(t._handleContentChangesStarted,t);h.attachContentChangesFinished(t._handleContentChangesFinished,t);h.attachContentChangesProgress(t._handleContentChangesProgress,t);t._assignDecryptionHandler([h]);t._assignAuthorizationHandler([h]);n(h);});});};
b.prototype.getContent=function(){return this._content;};
b.prototype.getContentManager=function(){return this._contentManager;};
b.prototype._assignDecryptionHandler=function(e){for(var i=0;i<e.length;i++){e[i].setDecryptionHandler(this._decryptionHandler);}};
b.prototype._assignAuthorizationHandler=function(e){for(var i=0;i<e.length;i++){e[i].setAuthorizationHandler(this._authorizationHandler);}};
b.prototype.setDecryptionHandler=function(h){this._decryptionHandler=h;this._assignDecryptionHandler(this.getAggregation("contentManagers",[]));return this;};
b.prototype.setAuthorizationHandler=function(h){this._authorizationHandler=h;this._assignAuthorizationHandler(this.getAggregation("contentManagers",[]));return this;};
b.prototype._setContent=function(n,e){var o=this._content,h=this._contentManager;if(o!==n){this._content=n;this._contentManager=e;this.fireContentReplaced({oldContent:o,newContent:n});if(o){var p=false;this.fireContentDestroying({content:o,preventGarbageCollection:function(i){p=i;}});h.destroyContent(o);if(!p){h.collectGarbage();}}}return this;};
var r=[{pattern:/(^threejs[:.])|(^(threejs|stream|vds4)$)/,dimension:3,contentManagerClassName:"sap.ui.vk.threejs.ContentManager"},{pattern:/^vdsl?$/,dimension:3,contentManagerClassName:"sap.ui.vk.dvl.ContentManager"},{pattern:/^(png|jpg|jpeg|gif|bmp|tiff?|svg)$/,dimension:2,contentManagerClassName:"sap.ui.vk.ImageContentManager"},{pattern:"cgm",dimension:2,contentManagerClassName:"sap.ui.vk.dvl.ContentManager"}];var d=function(e){return new Promise(function(h,i){var j=r.slice();var t=function(k){if(k>=j.length){i();return;}var n=j[k];(function(){var s=e.getSourceType();if(s){s=s.toLowerCase();}if(typeof n==="function"){return n(e);}else if(typeof n.pattern==="string"){var p=n.pattern.toLowerCase();if(p===s){return Promise.resolve(n);}}else if(n.pattern instanceof RegExp){if(n.pattern.test(s)){return Promise.resolve(n);}}return Promise.reject();})().then(function(o){h({dimension:o.dimension,contentManagerClassName:o.contentManagerClassName,settings:o.settings});},function(){t(k+1);});};t(0);});};
b.addContentManagerResolver=function(e){if(typeof e==="function"){r.unshift(e);}else{r.unshift({pattern:e.pattern,dimension:e.dimension,contentManagerClassName:e.contentManagerClassName,settings:e.settings});}return this;};
b.removeAllContentManagerResolvers=function(){r=[];return this;};
b.removeContentManagerResolver=function(e){var h=typeof e==="function",j=typeof e==="string",k=e instanceof RegExp;for(var i=0,n=r.length;i<n;++i){if(h||j){if(r[i]===e){r.splice(i,1);return true;}}else if(k){if(typeof r[i]==="object"&&r[i].pattern instanceof RegExp&&r[i].pattern.source===e.source){r.splice(i,1);return true;}}}return false;};
b._cleanAssociatedLoaders=function(){for(var i=0,e=r.length;i<e;++i){var h=r[i];if(h.settings&&h.settings.loader&&h.settings.loader.exit){h.settings.loader.exit();}}};
b.prototype._collectContentResourceSourceTypeInformation=function(e){var n=false,u=false,h={},j={},k=[];e.forEach(function flatten(i){k.push(i);i.getContentResources().forEach(flatten);});return Promise.all(k.map(function(i){return d(i).then(function(o){h[o.dimension]=true;j[o.contentManagerClassName]=true;return o;},function(){if(i.getSourceType()){u=true;}else{n=true;}return false;});})).then(function(o){for(var i=0,p=k.length;i<p;++i){if(o[i]){k[i]._contentManagerResolver=o[i];}}return{noSourceTypes:n,unknownSourceTypes:u,dimensions:Object.getOwnPropertyNames(h).sort(),contentManagerClassNames:Object.getOwnPropertyNames(j)};});};
var f=b.getMetadata().getName();var m={init:function(){this._contentConnector=null;v.attachEvent(f+"-created",this._handleContentConnectorCreated,this).attachEvent(f+"-destroying",this._handleContentConnectorDestroying,this);},exit:function(){this.setContentConnector(null);v.detachEvent(f+"-destroying",this._handleContentConnectorDestroying,this).detachEvent(f+"-created",this._handleContentConnectorCreated,this);},setContentConnector:function(e){this.setAssociation("contentConnector",e,true);this._updateContentConnector();return this;},_updateContentConnector:function(){var n=this.getContentConnector(),e=n&&sap.ui.getCore().byId(n)||null;if(this._contentConnector!==e){this._clearContentConnector();if(e){if(this._handleContentChangesStarted){e.attachContentChangesStarted(this._handleContentChangesStarted,this);}if(this._handleContentChangesFinished){e.attachContentChangesFinished(this._handleContentChangesFinished,this);}if(this._handleContentChangesProgress){e.attachContentChangesProgress(this._handleContentChangesProgress,this);}if(this._handleContentReplaced){e.attachContentReplaced(this._handleContentReplaced,this);}if(this._handleContentDestroying){e.attachContentDestroying(this._handleContentDestroying,this);}this._contentConnector=e;if(this._onAfterUpdateContentConnector){this._onAfterUpdateContentConnector();}}}return this;},_clearContentConnector:function(){if(this._contentConnector){if(this._onBeforeClearContentConnector){this._onBeforeClearContentConnector();}if(this._handleContentDestroying){this._contentConnector.detachContentDestroying(this._handleContentDestroying,this);}if(this._handleContentReplaced){this._contentConnector.detachContentReplaced(this._handleContentReplaced,this);}if(this._handleContentChangesProgress){this._contentConnector.detachContentChangesProgress(this._handleContentChangesProgress,this);}if(this._handleContentChangesFinished){this._contentConnector.detachContentChangesFinished(this._handleContentChangesFinished,this);}if(this._handleContentChangesStarted){this._contentConnector.detachContentChangesStarted(this._handleContentChangesStarted,this);}this._contentConnector=null;}return this;},_handleContentConnectorCreated:function(e){if(this.getContentConnector()===e.getParameter("object").getId()){this._updateContentConnector();}},_handleContentConnectorDestroying:function(e){if(this.getContentConnector()===e.getParameter("object").getId()){this._clearContentConnector();}}};
b.injectMethodsIntoClass=function(e){var p=e.prototype,i=p.init,h=p.exit;p.init=function(){if(i){i.call(this);}m.init.call(this);};p.exit=function(){m.exit.call(this);if(h){h.call(this);}};p.setContentConnector=m.setContentConnector;p._updateContentConnector=m._updateContentConnector;p._clearContentConnector=m._clearContentConnector;p._handleContentConnectorCreated=m._handleContentConnectorCreated;p._handleContentConnectorDestroying=m._handleContentConnectorDestroying;};
return b;});
sap.ui.predefine('sap/ui/vk/ContentManager',["sap/ui/base/ManagedObject"],function(M){"use strict";
var C=M.extend("sap.ui.vk.ContentManager",{metadata:{"abstract":true,library:"sap.ui.vk",events:{contentChangesStarted:{parameters:{}},contentChangesFinished:{parameters:{content:{type:"any"},failureReason:{type:"object"}}},contentChangesProgress:{parameters:{phase:{type:"string"},percentage:{type:"float"},source:{type:"any"}}}}}});
var b=C.getMetadata().getParent().getClass().prototype;
C.prototype.init=function(){if(b.init){b.init.call(this);}this._decryptionHandler=null;this._authorizationHandler=null;};
C.prototype.destroyContent=function(c){return this;};
C.prototype.collectGarbage=function(){return this;};
C.prototype.createOrthographicCamera=function(){return null;};
C.prototype.createPerspectiveCamera=function(){return null;};
C.prototype.destroyCamera=function(c){return this;};
C.prototype.setDecryptionHandler=function(h){this._decryptionHandler=h;return this;};
C.prototype.setAuthorizationHandler=function(h){this._authorizationHandler=h;return this;};
return C;});
sap.ui.predefine('sap/ui/vk/ContentResource',["sap/ui/base/ManagedObject","./ContentResourceSourceTypeToCategoryMap"],function(M,C){"use strict";
var a=M.extend("sap.ui.vk.ContentResource",{
metadata:{properties:{source:"any",sourceType:"string",sourceId:"string",localMatrix:"sap.ui.vk.TransformationMatrix",name:"string",password:"string",useSecureConnection:{type:"boolean",defaultValue:true},veid:"string",includeHidden:"boolean",includeAnimation:"boolean",pushPMI:"boolean",metadataFilter:"string",activateView:"string",enableLogger:"boolean",pushViewGroups:"boolean"},aggregations:{contentResources:"sap.ui.vk.ContentResource"}},
constructor:function(i,s,S){M.apply(this,arguments);}
});
a.prototype.isTreeBinding=function(n){return n==="contentResources";};
a.prototype.destroy=function(){M.prototype.destroy.call(this);};
a.prototype.setLocalMatrix=function(v){var n=this.getNodeProxy();if(n){n.setLocalMatrix(v);}this.setProperty("localMatrix",v,true);return this;};
a.prototype.getSourceProperties=function(){return this._shadowContentResource&&this._shadowContentResource.sourceProperties||{};};
a.prototype.getNodeProxy=function(){return this._shadowContentResource&&this._shadowContentResource.nodeProxy||null;};
a.collectCategories=function(r){var c=[];var m={};function g(b){var s=(b.getSourceType()||"").toLowerCase();if(s){var d=C[s]||"unknown";if(!m.hasOwnProperty(d)){m[d]=true;c.push(d);}}b.getContentResources().forEach(g);}r.forEach(g);return c;};
return a;});
sap.ui.predefine('sap/ui/vk/ContentResourceSourceCategory',[],function(){"use strict";var C={"3D":"3D","2D":"2D"};return C;},true);
sap.ui.predefine('sap/ui/vk/ContentResourceSourceTypeToCategoryMap',["./ContentResourceSourceCategory"],function(C){"use strict";var a={"vds":C["3D"],"vdsl":C["3D"],"cgm":C["3D"],"png":C["2D"],"jpg":C["2D"],"jpeg":C["2D"],"gif":C["2D"],"bmp":C["2D"],"tiff":C["2D"],"tif":C["2D"],"svg":C["2D"]};return a;},true);
sap.ui.predefine('sap/ui/vk/Core',["sap/ui/base/ManagedObject","./library"],function(M,v){"use strict";
var C=M.extend("sap.ui.vk.Core",{
metadata:{publicMethods:["registerClass"]},
constructor:function(){if(v.getCore){return v.getCore();}M.call(this);var t=this;v.getCore=function(){return t;};this._classes=[];}
});
C.prototype.registerClass=function(c){if(this._classes.indexOf(c)>=0){return this;}var t=this,f=c.getMetadata().getName(),e=f+"-created",a=f+"-destroying",b=c.prototype.register,d=c.prototype.deregister;c.prototype.register=function(){if(b){b.call(this);}t.fireEvent(e,{object:this});};c.prototype.deregister=function(){t.fireEvent(a,{object:this});if(d){d.call(this);}};this._classes.push(c);return this;};
return new C();});
sap.ui.predefine('sap/ui/vk/DetailViewShape',[],function(){"use strict";var D={Box:"Box",Circle:"Circle",CircleLine:"CircleLine",CirclePointer:"CirclePointer",CircleArrow:"CircleArrow",CircleBubbles:"CircleBubbles",BoxLine:"BoxLine",BoxNoOutline:"BoxNoOutline",SolidPointer:"SolidPointer",SolidArrow:"SolidArrow"};return D;},true);
sap.ui.predefine('sap/ui/vk/DetailViewType',[],function(){"use strict";var D={DetailView:"DetailView",Cutaway:"Cutaway"};return D;},true);
sap.ui.predefine('sap/ui/vk/DownloadManager',["jquery.sap.global","sap/ui/base/EventProvider","./Messages","./getResourceBundle"],function(q,E,M,g){"use strict";
var D=E.extend("sap.ui.vk.DownloadManager",{
metadata:{events:{itemSucceeded:{parameters:{source:{type:"any"},response:{type:"object"}}},itemProgress:{parameters:{source:{type:"any"},loaded:{type:"int"},total:{type:"int"}}},itemFailed:{parameters:{source:{type:"any"},status:{type:"any"},statusText:{type:"string"}}},allItemsCompleted:{}}},
constructor:function(s,m,a){E.apply(this);this._maxParallelTasks=m||5;this._sourcesToProcess=s.slice();this._sourcesBeingProcessed=[];this._authorizationHandler=a;}
});
D.prototype.start=function(){while(this._pickAndDispatchTask()){}return this;};
D.prototype.queue=function(s){this._sourcesToProcess.push(s);this._pickAndDispatchTask();return this;};
D.prototype._pickAndDispatchTask=function(){if(this._sourcesToProcess.length>0&&this._sourcesBeingProcessed.length<this._maxParallelTasks){var s=this._sourcesToProcess.shift();this._sourcesBeingProcessed.push(s);var t=this;if(this._authorizationHandler){this._authorizationHandler(s).then(function(a){var b=null;if(a!=null){b=a.token_type+" "+a.access_token;}t._runTask(s,b);}).catch(function(r){t.fireItemFailed({source:s,status:0,statusText:r});t._taskFinished(s);if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}});}else{this._runTask(s);}return true;}return false;};
D.prototype._taskFinished=function(s){var i=this._sourcesBeingProcessed.indexOf(s);if(i>=0){this._sourcesBeingProcessed.splice(i,1);}return this;};
D.prototype._queueIsEmpty=function(){return this._sourcesToProcess.length===0&&this._sourcesBeingProcessed.length===0;};
D.prototype._runTask=function(s,a){var t=this;if(typeof s==="string"){var x=new(typeof sinon==="object"&&sinon.xhr&&sinon.xhr.XMLHttpRequest||XMLHttpRequest);x.onerror=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemFailed({source:s,status:x.status,statusText:x.statusText});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};x.onload=function(e){t._taskFinished(s);t._pickAndDispatchTask();if(x.status===200||x.status===0){t.fireItemSucceeded({source:s,response:x.response});}else{t.fireItemFailed({source:s,status:x.status,statusText:x.statusText});}if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};x.onprogress=function(e){t.fireItemProgress({source:s,loaded:e.loaded,total:e.total});};x.open("GET",s,true);x.responseType="arraybuffer";if(a){x.setRequestHeader("Authorization",a);}x.send(null);}else if(s instanceof File){var f=new FileReader();f.onload=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemSucceeded({source:s,response:f.result});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};f.onerror=function(e){t._taskFinished(s);t._pickAndDispatchTask();t.fireItemFailed({source:s,status:f.error.name,statusText:f.error.message});if(t._queueIsEmpty()){t._asyncFireAllItemsCompleted();}};f.onprogress=function(e){t.fireItemProgress({source:s.name,loaded:e.loaded,total:e.total});};f.readAsArrayBuffer(s);}else{q.sap.log.error(g().getText(M.VIT5.summary),M.VIT5.code,"sap.ui.vk.DownloadManager");}return this;};
D.prototype._asyncFireAllItemsCompleted=function(){q.sap.delayedCall(0,this,this.fireAllItemsCompleted);};
D.prototype.attachItemSucceeded=function(d,f,l){return this.attachEvent("itemSucceeded",d,f,l);};
D.prototype.detachItemSucceeded=function(f,l){return this.detachEvent("itemSucceeded",f,l);};
D.prototype.fireItemSucceeded=function(p,a,e){return this.fireEvent("itemSucceeded",p,a,e);};
D.prototype.attachItemFailed=function(d,f,l){return this.attachEvent("itemFailed",d,f,l);};
D.prototype.detachItemFailed=function(f,l){return this.detachEvent("itemFailed",f,l);};
D.prototype.fireItemFailed=function(p,a,e){return this.fireEvent("itemFailed",p,a,e);};
D.prototype.attachAllItemsCompleted=function(d,f,l){return this.attachEvent("allItemsCompleted",d,f,l);};
D.prototype.detachAllItemsCompleted=function(f,l){return this.detachEvent("allItemsCompleted",f,l);};
D.prototype.fireAllItemsCompleted=function(p,a,e){return this.fireEvent("allItemsCompleted",p,a,e);};
D.prototype.attachItemProgress=function(d,f,l){return this.attachEvent("itemProgress",d,f,l);};
D.prototype.detachItemProgress=function(f,l){return this.detachEvent("itemProgress",f,l);};
D.prototype.fireItemProgress=function(p,a,e){return this.fireEvent("itemProgress",p,a,e);};
return D;});
sap.ui.predefine('sap/ui/vk/DrawerToolbar',["./library","./DrawerToolbarRenderer","sap/ui/core/Control","sap/m/VBox","sap/m/FlexItemData","sap/m/OverflowToolbar","sap/ui/core/Icon","sap/m/Button","sap/m/ToolbarSeparator","sap/m/ToggleButton","sap/m/MenuButton","./tools/Tool","./tools/RotateTurntableTool","./tools/RotateOrbitTool","./tools/RectSelectTool","./tools/CrossSectionTool","sap/m/Menu","sap/m/MenuItem","./ZoomTo","./getResourceBundle","./threejs/Viewport","./Viewport","./DrawerToolbarButton","sap/ui/base/ManagedObjectObserver"],function(v,D,C,V,F,O,I,B,T,a,M,b,R,c,d,e,f,g,Z,h,j,k,l,m){"use strict";
var n=C.extend("sap.ui.vk.DrawerToolbar",{
metadata:{properties:{expanded:{type:"boolean",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"content",forwardBinding:true}}},associations:{viewport:{type:"sap.ui.vk.Viewport",multiple:false}},events:{expanded:{parameters:{expand:{type:"boolean"}}}}},
constructor:function(i,S){C.apply(this,arguments);}
});
var o=[{name:"show",unicode:"e000"},{name:"hide",unicode:"e001"},{name:"turntable",unicode:"e002"},{name:"orbit",unicode:"e003"},{name:"pan",unicode:"e004"},{name:"zoom",unicode:"e005"},{name:"fit-to-view",unicode:"e006"},{name:"rectangular-selection",unicode:"e007"},{name:"structure-browser",unicode:"e008"},{name:"configuration",unicode:"e009"},{name:"setting",unicode:"e00a"},{name:"full-screen",unicode:"e00b"},{name:"predefined-views",unicode:"e00c"},{name:"authoring-app",unicode:"e00d"},{name:"dot",unicode:"e00e"},{name:"empty",unicode:"e00f"},{name:"right-panel-menu",unicode:"e010"},{name:"viewer-app",unicode:"e011"},{name:"hide-association",unicode:"e012"},{name:"cross-section",unicode:"e013"},{name:"cross-section-x",unicode:"e014"},{name:"cross-section-z",unicode:"e015"},{name:"cross-section-y",unicode:"e016"},{name:"reverse-direction",unicode:"e017"},{name:"create-editable-visualisation",unicode:"e018"},{name:"cross-section-z-",unicode:"e019"}],q="vk-icons",r="vk-icons";o.forEach(function(i){sap.ui.core.IconPool.addIcon(i.name,q,r,i.unicode);});var s="sap-icon://vk-icons/";
n.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}this._toolbar=new O({width:"auto",design:sap.m.ToolbarDesign.Solid,layoutData:new F({growFactor:0,shrinkFactor:0}),content:this.createButtons()});this._toolbar.ontouchstart=function(i){i.setMarked();};this._toolbarObserver=new m(this._toolbarContentChanged.bind(this));this._toolbarObserver.observe(this._toolbar,{aggregations:["content"]});this._container=new V({renderType:sap.m.FlexRendertype.Bare,alignContent:sap.m.FlexAlignContent.Center,alignItems:sap.m.FlexAlignItems.Center,items:[this._toolbar,new I({src:"sap-icon://navigation-up-arrow",noTabStop:true,press:function(i){this._toggleExpanded();}.bind(this),layoutData:new F({growFactor:0,shrinkFactor:0})}).addStyleClass("drawerToolbarIcon")]});};
n.prototype._toolbarContentChanged=function(){var p=this._toolbar.getContent();for(var i=0;i<p.length;i++){if(p[i].getMetadata().getName()=="sap.m.ToolbarSeparator"){if(p[i-1]==undefined||p[i+1]==undefined||p[i-1].getMetadata().getName()=="sap.m.ToolbarSeparator"){this._toolbar.removeContent(i);}}}};
n.prototype._getViewport=function(){var i=sap.ui.getCore().byId(this.getViewport());if(i instanceof j){return i;}if(i instanceof k&&i._implementation instanceof j){return i._implementation;}return null;};
var t=[null,new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),0),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),-Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),-Math.PI/2),new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),Math.PI/2)];
n.prototype.createButtons=function(){var i=this;var p,x;function y(S,U,W){p.setPressed(true);if(i._crossSectionTool){i._crossSectionTool.setActive(true,S);if(U!==undefined){i._crossSectionTool.setAxis(U);x.setIcon(s+"cross-section-"+["x","y","z"][U]);}}}p=new a({icon:s+"cross-section",type:sap.m.ButtonType.Transparent,tooltip:"Cross Section",press:function(S){var U=i._getViewport();if(U){if(this.getPressed()){y(U);}else if(i._crossSectionTool){i._crossSectionTool.setActive(false,U);}}}});p.vitId=l.crossSection;x=new M({type:sap.m.ButtonType.Transparent,tooltip:"Cross Section Axis",icon:s+"cross-section-x",menu:new f({items:[new g({icon:s+"cross-section-x",text:"X",press:function(S){var U=i._getViewport();if(U){y(U,0,false);}}}),new g({icon:s+"cross-section-y",text:"Y",press:function(S){var U=i._getViewport();if(U){y(U,1,false);}}}),new g({icon:s+"cross-section-z",text:"Z",press:function(S){var U=i._getViewport();if(U){y(U,2,false);}}}),new g({icon:s+"reverse-direction",text:"Flip",startsSection:true,press:function(S){var U=i._getViewport();if(U&&i._crossSectionTool&&i._crossSectionTool.getActive()){i._crossSectionTool.setFlip(!i._crossSectionTool.getFlip());}}})]})});x.vitId=l.crossSectionAxis;var z=new a({icon:s+"turntable",type:sap.m.ButtonType.Transparent,tooltip:"Turntable",press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,0);}}});z.vitId=l.turntable;var A=new a({icon:s+"orbit",type:sap.m.ButtonType.Transparent,tooltip:"Orbit",pressed:false,press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,1);}}});A.vitId=l.orbit;var E=new a({icon:s+"pan",type:sap.m.ButtonType.Transparent,tooltip:"Pan",press:function(S){var U=i._getViewport();if(U){i._activateGesture(U,2);}}});E.vitId=l.pan;var G=new a({icon:s+"zoom",type:sap.m.ButtonType.Transparent,tooltip:"Zoom",press:function(){var S=i._getViewport();if(S){i._activateGesture(S,3);}}});G.vitId=l.zoom;this._gestureButtons=[z,A,E,G];var H=new B({icon:s+"show",type:sap.m.ButtonType.Transparent,tooltip:"Show",press:function(){var S=i._getViewport();if(S){var U=S._viewStateManager;var W=[];U.enumerateSelection(function(X){W.push(X);});U.setVisibilityState(W,true,false);}}});H.vitId=l.show;var J=new B({icon:s+"hide",type:sap.m.ButtonType.Transparent,tooltip:"Hide",press:function(){var S=i._getViewport();if(S){var U=S._viewStateManager;var W=[];U.enumerateSelection(function(X){W.push(X);});U.setVisibilityState(W,false,false);}}});J.vitId=l.hide;var K=new B({icon:s+"fit-to-view",type:sap.m.ButtonType.Transparent,tooltip:"Fit to View",press:function(){var S=i._getViewport();if(S){S.zoomTo(Z.All,null,0.5,0);}}});K.vitId=l.fitToView;var L=new a({icon:s+"rectangular-selection",type:sap.m.ButtonType.Transparent,tooltip:"Rectangular Selection",press:function(S){var U=i._getViewport();if(U&&i._rectSelectTool){i._rectSelectTool.setActive(this.getPressed(),U);}}});L.vitId=l.rectangularSelection;var N=new M({icon:s+"predefined-views",activeIcon:s+"predefined-views",type:sap.m.ButtonType.Transparent,tooltip:h().getText("PREDEFINED_VIEW_MENUBUTTONTOOLTIP"),menu:new f({items:[new g({text:h().getText("PREDEFINED_VIEW_INITIAL")}),new g({text:h().getText("PREDEFINED_VIEW_FRONT"),startsSection:true}),new g({text:h().getText("PREDEFINED_VIEW_BACK")}),new g({text:h().getText("PREDEFINED_VIEW_LEFT")}),new g({text:h().getText("PREDEFINED_VIEW_RIGHT")}),new g({text:h().getText("PREDEFINED_VIEW_TOP")}),new g({text:h().getText("PREDEFINED_VIEW_BOTTOM")})]}).attachItemSelected(function(S){var U=i._getViewport();if(U){var W=S.getParameters("item").item;var X=this.indexOfItem(W);U._viewportGestureHandler.setView(t[X],1000);}})});N.vitId=l.predefinedViews;var P=new a({icon:s+"full-screen",type:sap.m.ButtonType.Transparent,tooltip:h().getText("VIEWER_FULLSCREENBUTTONTOOLTIP"),press:function(S){var U=i._getViewport();var W=function(Y){return!!(Y.fullScreen||Y.webkitIsFullScreen||Y.mozFullScreen||Y.msFullscreenElement);};if(this.getPressed()){if(!W(document)){if(!i._fullScreenHandler){i._fullScreenHandler=function(S){var Y=W(document);if(!Y){document.removeEventListener("fullscreenchange",i._fullScreenHandler);document.removeEventListener("mozfullscreenchange",i._fullScreenHandler);document.removeEventListener("webkitfullscreenchange",i._fullScreenHandler);document.removeEventListener("MSFullscreenChange",i._fullScreenHandler);this.setPressed(false);U.removeStyleClass("sapVizKitViewerFullScreen");}}.bind(this);}var X=document.getElementsByTagName("body")[0];if(X.requestFullscreen){document.addEventListener("fullscreenchange",i._fullScreenHandler);X.requestFullscreen();}else if(X.webkitRequestFullScreen){document.addEventListener("webkitfullscreenchange",i._fullScreenHandler);X.webkitRequestFullscreen();}else if(X.mozRequestFullScreen){document.addEventListener("mozfullscreenchange",i._fullScreenHandler);X.mozRequestFullScreen();}else if(X.msRequestFullscreen){document.addEventListener("MSFullscreenChange",i._fullScreenHandler);X.msRequestFullscreen();}}U.addStyleClass("sapVizKitViewerFullScreen");}else{if(W(document)){if(document.cancelFullScreen){document.cancelFullScreen();}else if(document.msExitFullscreen){document.msExitFullscreen();}else if(document.mozCancelFullScreen){document.mozCancelFullScreen();}else if(document.webkitCancelFullScreen){document.webkitCancelFullScreen();}}U.removeStyleClass("sapVizKitViewerFullScreen");}}});P.vitId=l.fullscreen;var Q=[H,J,new T(),this._gestureButtons[0],this._gestureButtons[1],this._gestureButtons[2],this._gestureButtons[3],new T(),K,new T(),L,new T(),p,x,new T(),N,new T(),P];return Q;};
var u=["drawerToolbarIconTurntable","drawerToolbarIconOrbit","drawerToolbarIconPan","drawerToolbarIconZoom"];var w=function(i,p){this.viewport=i;this._toolbar=p;this._mode=1;this._gesture=false;this._x=0;this._y=0;};
w.prototype.beginGesture=function(i){this._gesture=true;if(this._mode<3){this._x=i.points[0].x;this._y=i.points[0].y;}else{this._x=i.x;this._y=i.y;}if(i.event&&(sap.ui.Device.os.macintosh?i.event.metaKey:i.event.ctrlKey)&&this._toolbar._rectSelectTool){var p=this.viewport.getDomRef().getBoundingClientRect();this._selectionRect={x1:this._x-p.left,y1:this._y-p.top,x2:this._x-p.left,y2:this._x-p.top};}};
w.prototype.endGesture=function(){this._gesture=false;if(this._selectionRect){this._toolbar._rectSelectTool._select(this._selectionRect.x1,this._selectionRect.y1,this._selectionRect.x2,this._selectionRect.y2,this.viewport,this.viewport.getScene(),this.viewport.getCamera());this._selectionRect=null;this.viewport.setSelectionRect(null);}else{this.viewport.removeStyleClass(u[this._mode]);}};
w.prototype.move=function(i){if(this._gesture&&i.n==1){var p=i.points[0];if(this._selectionRect){var x=this.viewport.getDomRef().getBoundingClientRect();this._selectionRect.x2=p.x-x.left;this._selectionRect.y2=p.y-x.top;this.viewport.setSelectionRect(this._selectionRect);}else{this.viewport.addStyleClass(u[this._mode]);var y=p.x-this._x;var z=p.y-this._y;var A=this.viewport._viewportGestureHandler._cameraController;switch(this._mode){case 0:A.rotate(y,z,true);break;case 1:A.rotate(y,z,false);break;case 2:A.pan(y,z);break;case 3:A.zoom(1+z*0.005);break;default:break;}this._x=p.x;this._y=p.y;}i.handled=true;}};
w.prototype.hover=function(){};
w.prototype.getViewport=function(){return this.viewport;};
n.prototype._activateGesture=function(i,p){this._gestureButtons.forEach(function(x,y){x.setPressed(y===p);});if(!this._cameraHandler){this._cameraHandler=new w(i,this);i._loco.addHandler(this._cameraHandler,0);}this._cameraHandler._mode=p;};
n.prototype._getToolbar=function(){return this._toolbar;};
n.prototype._toggleExpanded=function(){var i=!this.getExpanded();this.setExpanded(i);this.fireExpanded({expand:i});};
n.prototype.setExpanded=function(E){this.setProperty("expanded",E,true);var i=this.getDomRef();if(i){if(!E){i.classList.add("drawerToolbarCollapsed");i.classList.remove("drawerToolbarExpanded");this._container.addStyleClass("vboxCollapsed");}else{i.classList.add("drawerToolbarExpanded");i.classList.remove("drawerToolbarCollapsed");this._container.removeStyleClass("vboxCollapsed");}}return this;};
n.prototype.onAfterRendering=function(){var i=this._getViewport();if(i){this._activateGesture(i,1);if(!this._crossSectionTool){this._crossSectionTool=new e();i.addTool(this._crossSectionTool);}if(!this._rectSelectTool){this._rectSelectTool=new d();}}};
return n;});
sap.ui.predefine('sap/ui/vk/DrawerToolbarRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){r.write("<div ");r.writeControlData(d);r.addClass("drawerToolbar");if(!d.getExpanded()){r.addClass("drawerToolbarCollapsed");}else{r.addClass("drawerToolbarExpanded");}r.writeClasses();r.write(">");r.renderControl(d._container);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/ui/vk/DvlException',["sap/ui/base/Exception"],function(E){"use strict";var D=function(c,m){this.name="DvlException";this.code=c;this.message=m;};D.prototype=Object.create(E.prototype);return D;});
sap.ui.predefine('sap/ui/vk/FlexibleControl',["./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","./FlexibleControlRenderer"],function(v,C,E,F){"use strict";
var a=C.extend("sap.ui.vk.FlexibleControl",{metadata:{library:"sap.ui.vk",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},layout:{type:"string",group:"Behavior",defaultValue:"Stacked"},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designTime:true}});
E.call(a.prototype);return a;});
sap.ui.predefine('sap/ui/vk/FlexibleControlLayoutData',["sap/ui/core/LayoutData"],function(L){"use strict";
var F=L.extend("sap.ui.vk.FlexibleControlLayoutData",{metadata:{library:"sap.ui.vk",properties:{size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"0px"},marginTop:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"0px"},marginBottom:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"0px"}}}});
return F;});
sap.ui.predefine('sap/ui/vk/FlexibleControlRenderer',[],function(){"use strict";var F={};
F.render=function(r,f){var a=r;a.write("<div");a.writeControlData(f);a.addClass("sapUiFlexControl");if(f.getWidth()&&f.getWidth()!=""){a.addStyle("width",f.getWidth());}if(f.getHeight()&&f.getHeight()!=""){a.addStyle("height",f.getHeight());}a.writeStyles();a.writeClasses();a.write(">");var c=f.getContent();var l=f.getLayout();var b="sapUiFlexCellStacked";if(l=="Vertical"){b="sapUiFlexCellVertical";}for(var i=0;i<c.length;i++){var d=c[i];a.write("<div id=\""+f.getId()+"Content_"+i+"\" class=\""+b+"\"");var e=d.getLayoutData();if(e&&l!="Stacked"){a.write(" style=\"");if(e.getSize()&&e.getSize()!=""){a.write("height: "+e.getSize()+";");}if(e.getMinSize()&&e.getMinSize()!=""){a.write("min-height: "+e.getMinSize()+";");}if(e.getMarginTop()&&e.getMarginTop()!=""){a.write("margin-top: "+e.getMarginTop()+";");}if(e.getMarginBottom()&&e.getMarginBottom()!=""){a.write("margin-bottom: "+e.getMarginBottom()+";");}a.write("\"");}a.write(">");a.renderControl(d);a.write("</div>");}a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/vk/ImageContentManager',["jquery.sap.global","./Messages","./ContentManager","./getResourceBundle"],function(q,M,C,g){"use strict";
var I=C.extend("sap.ui.vk.ImageContentManager",{metadata:{library:"sap.ui.vk"}});
var b=I.getMetadata().getParent().getClass().prototype;
I.prototype.init=function(){if(b.init){b.init.call(this);}this._handleLoadSucceededProxy=this._handleLoadSucceeded.bind(this);this._handleLoadFailedProxy=this._handleLoadFailed.bind(this);};
I.prototype.exit=function(){if(b.exit){b.exit.call(this);}};
I.prototype.loadContent=function(c,a){if(a.length!==1){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_ONLY_LOAD_SINGLE_IMAGE")}});});}else if(a[0].getContentResources().length>0){q.sap.delayedCall(0,this,function(){this.fireContentChangesStarted();this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_CANNOT_LOAD_IMAGE_HIERARCHY")}});});}else{var d=a[0],s=d.getSource(),e=d.getSourceType();if(s instanceof File){var f=new FileReader();f.onload=function(h){this._loadImageFromUrl(c,f.result,e);}.bind(this);f.readAsDataURL(s);}else{var t=new sap.m.Image({src:s});s=t.getSrc();t.destroy();this._loadImageFromUrl(c,s,e);}}};
I.prototype._addEventListeners=function(h){h.addEventListener("load",this._handleLoadSucceededProxy);h.addEventListener("error",this._handleLoadFailedProxy);};
I.prototype._removeEventListeners=function(h){h.removeEventListener("error",this._handleLoadFailedProxy);h.removeEventListener("load",this._handleLoadSucceededProxy);};
I.prototype._addSvgQuirks=function(h){h.style.setProperty("visibility","collapse");h.style.setProperty("width","0");h.style.setProperty("height","0");h.style.setProperty("position","absolute");document.body.appendChild(h);return this;};
I.prototype._removeSvgQuirks=function(h){h.parentElement.removeChild(h);h.style.removeProperty("visibility");h.style.removeProperty("width");h.style.removeProperty("height");h.style.removeProperty("position");return this;};
I.prototype._loadImageFromUrl=function(c,u,s){this.fireContentChangesStarted();switch(s.toLowerCase()){case"svg":var a=document.createElement("object");this._addEventListeners(a);a.type="image/svg+xml";a.data=u;a.className="SVGImage";this._addSvgQuirks(a);break;case"jpg":case"jpeg":case"png":case"gif":case"bmp":case"tif":case"tiff":var i=document.createElement("img");this._addEventListeners(i);i.src=u;break;default:q.sap.delayedCall(0,this,function(){this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_UNSUPPORTED_IMAGE_TYPE"),sourcesFailedToDownload:[{source:u}]}});});break;}};
I.prototype._handleLoadSucceeded=function(e){var c=e.target;this._removeEventListeners(c);if(c instanceof HTMLObjectElement){this._removeSvgQuirks(c);}this.fireContentChangesFinished({content:c});};
I.prototype._handleLoadFailed=function(e){var c=e.target;this._removeEventListeners(c);if(c instanceof HTMLObjectElement){this._removeSvgQuirks(c);}this.fireContentChangesFinished({content:null,failureReason:{errorMessage:g().getText("IMAGECONTENTMANAGER_IMAGE_LOAD_FAILED"),sourcesFailedToDownload:[{source:c instanceof HTMLImageElement?c.src:c.data}]}});};
return I;});
sap.ui.predefine('sap/ui/vk/LayerProxy',["sap/ui/base/Object"],function(B){"use strict";
var L=B.extend("sap.ui.vk.LayerProxy",{metadata:{"abstract":true}});
return L;});
sap.ui.predefine('sap/ui/vk/LeaderLineMarkStyle',[],function(){"use strict";var L={None:"None",Point:"Point",Arrow:"Arrow"};return L;},true);
sap.ui.predefine('sap/ui/vk/Loco',["sap/ui/base/EventProvider"],function(E){"use strict";
var L=E.extend("sap.ui.vk.Loco",{
metadata:{publicMethods:["addHandler","removeHandler"]},
constructor:function(v){if(L._instance&&this.viewport===v){return L._instance;}E.apply(this);this._handlers=[];this._gesture=false;this._n=0;this._touchStart=0;this._touchOrigin={x:0,y:0};this._touchMoved=false;this._clickTimer=0;if(v){this.attachViewportEventHandlers(v);}L._instance=this;}
});
L.prototype.destroy=function(){};
function e(a){var p=[];var b={points:p,buttons:a.buttons||0,handled:false,event:a,timeStamp:a.timeStamp,scroll:a.wheelDelta};if(a.touches&&a.touches.length>0){for(var i=0;i<a.touches.length;i++){var t=a.touches[i];p.push({x:t.pageX,y:t.pageY});}}else if(a.pageX!==undefined){p.push({x:a.pageX,y:a.pageY});}else{p.push({x:a.originalEvent.pageX,y:a.originalEvent.pageY});}if((a.buttons&2)&&p.length===1){p.push(p[0]);}b.n=p.length;if(b.n===2){var d=p[0].x-p[1].x,c=p[0].y-p[1].y;b.x=(p[0].x+p[1].x)*0.5;b.y=(p[0].y+p[1].y)*0.5;b.d=Math.sqrt(d*d+c*c);}else{b.x=p[0].x;b.y=p[0].y;b.d=0;}return b;}
L.prototype.attachViewportEventHandlers=function(v){this.viewport=v;v.ontouchstart=function(a){if(!a.isMarked()){var i=e(a);if(this._gesture){this._endGesture(i);i.handled=false;}this._beginGesture(i);}}.bind(this);v.ontouchend=function(a){var i=e(a);this._endGesture(i);if(a.touches.length>0){i.handled=false;this._beginGesture(i);}}.bind(this);if(sap.ui.Device.support.touch){v.attachBrowserEvent("touchmove",function(a){this._move(e(a));}.bind(this));}v.attachBrowserEvent("mousemove",function(a){this._move(e(a));}.bind(this));v.ontap=function(a){if(!a.isMarked()&&!this._touchMoved){if(this._clickTimer>0){clearTimeout(this._clickTimer);this._click(e(a),true);}else{this._clickTimer=setTimeout(function(l){l._click(e(a),false);},250,this);}}}.bind(this);v.attachBrowserEvent(sap.ui.Device.browser.firefox?"DOMMouseScroll":"mousewheel",function(a){if(!a.isMarked()){var o=a.originalEvent;var i={x:o.pageX,y:o.pageY,d:0,buttons:a.buttons,scroll:o.detail?o.detail*(-40):o.wheelDelta,n:2,points:[{x:o.pageX,y:o.pageY},{x:o.pageX,y:o.pageY}],handled:false};this._beginGesture(i);i.points[0].y-=i.scroll*0.2;i.points[1].y+=i.scroll*0.2;i.d=Math.abs(i.scroll)*0.4;i.handled=false;this._move(i);i.handled=false;this._endGesture(i);if(i.handled){a.setMarked();a.preventDefault();}}},this);v.oncontextmenu=function(a){var i=e(a);this._contextMenu(i);}.bind(this);v.attachBrowserEvent("keyup",function(a){this._keyEventHandler(a);},this);};
L.prototype.addHandler=function(h,p){if(!this.viewport){this.attachViewportEventHandlers(h.getViewport());}h.priority=p|0;if(this._handlers.indexOf(h)===-1){this._handlers.push(h);}this._handlers.sort(function(a,b){return a.priority-b.priority;});};
L.prototype.removeHandler=function(h){var i=this._handlers.indexOf(h);if(i>=0){this._handlers.splice(i,1);}};
L.prototype._handleInput=function(h,a){for(var i=this._handlers.length-1;i>=0&&!a.handled;i--){if(this._handlers[i][h]){this._handlers[i][h](a);}}if(a.handled&&a.event){a.event.preventDefault();}};
L.prototype._beginGesture=function(i){this._handleInput("beginGesture",i);this._touchStart=i.timeStamp;this._touchMoved=false;this._gesture=true;this._touchOrigin.x=i.x;this._touchOrigin.y=i.y;this._n=i.n;};
L.prototype._move=function(i){if(this._gesture&&this._n===i.n){if(!this._touchMoved){this._touchMoved=(i.timeStamp-this._touchStart>200)&&(Math.abs(this._touchOrigin.x-i.x)>3||Math.abs(this._touchOrigin.y-i.y)>3);}this._handleInput("move",i);}else{this._handleInput("hover",i);}};
L.prototype._endGesture=function(i){if(!this._gesture){return;}this._handleInput("endGesture",i);this._gesture=false;};
L.prototype._click=function(i,a){this._clickTimer=0;this._handleInput(a?"doubleClick":"click",i);};
L.prototype._contextMenu=function(i){this._handleInput("contextMenu",i);};
L.prototype._keyEventHandler=function(a){this._handleInput("keyEventHandler",a);};
return L;});
sap.ui.predefine('sap/ui/vk/MapContainerButtonType',[],function(){"use strict";var M={Click:"Click",Toggle:"Toggle"};return M;},true);
sap.ui.predefine('sap/ui/vk/Material',["sap/ui/base/ManagedObject"],function(M){"use strict";
var a=M.extend("sap.ui.vk.Material",{metadata:{properties:{"id":{type:"string"},"name":{type:"string"},"ambientColour":{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 1)"},"diffuseColour":{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 1)"},"specularColour":{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 1)"},"emissiveColour":{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 1)"},"opacity":{type:"float",defaultValue:1.0},"glossiness":{type:"float",defaultValue:0.0},"lineColour":{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 1)"},"lineWidth":{type:"float",defaultValue:0.0},"textureDiffuse":{type:"sap.ui.vk.Texture",defaultValue:null},"textureBump":{type:"sap.ui.vk.Texture",defaultValue:null},"textureOpacity":{type:"sap.ui.vk.Texture",defaultValue:null},"textureReflection":{type:"sap.ui.vk.Texture",defaultValue:null},"textureEmissive":{type:"sap.ui.vk.Texture",defaultValue:null},"textureAmbientOcclusion":{type:"sap.ui.vk.Texture",defaultValue:null}}}});
a.prototype.getMaterialRef=function(){return null;};
return a;});
sap.ui.predefine('sap/ui/vk/Messages',[],function(){"use strict";var M={VIT1:{summary:"NATIVEVIEWPORT_MSG_NOTBELOADED_SUMMARY",cause:"NATIVEVIEWPORT_MSG_NOTBELOADED_NOTFOUND_CAUSE",resolution:"NATIVEVIEWPORT_MSG_NOTBELOADED_NOTFOUND_CHECKEXISTS_RESOLUTION",code:"VIT1"},VIT2:{summary:"NATIVEVIEWPORT_MSG_NOTBELOADED_SUMMARY",cause:"NATIVEVIEWPORT_MSG_NOTBELOADED_NOTFOUND_CAUSE",resolution:"NATIVEVIEWPORT_MSG_NOTBELOADED_NOTFOUND_CHECKEXISTS_RESOLUTION",code:"VIT2"},VIT3:{summary:"NATIVEVIEWPORT_MSG_NOTBELOADED_SUMMARY",cause:"NATIVEVIEWPORT_MSG_NOTBELOADED_UNSUPPORTEDFILEFORMAT_CAUSE",resolution:"NATIVEVIEWPORT_MSG_NOTBELOADED_UNSUPPORTEDFILEFORMAT_CHECKFILEFORMAT_RESOLUTION",code:"VIT3"},VIT4:{summary:"NATIVEVIEWPORT_MSG_NOTBELOADED_SUMMARY",cause:"NATIVEVIEWPORT_MSG_NOTBELOADED_UNSUPPORTEDFILEFORMAT_CAUSE",resolution:"NATIVEVIEWPORT_MSG_NOTBELOADED_UNSUPPORTEDFILEFORMAT_CHECKFILEFORMAT_RESOLUTION",code:"VIT4"},VIT5:{summary:"DOWNLOADMANAGER_MSG_NOTBELOADED_SUMMARY",cause:"DOWNLOADMANAGER_MSG_NOTBELOADED_VALUESOURCEUNSUPPORTED_CAUSE",resolution:"DOWNLOADMANAGER_MSG_NOTBELOADED_VALUESOURCEUNSUPPORTED_CHECKSOURCEISURLORFILE_RESOLUTION",code:"VIT5"},VIT6:{summary:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_SUMMARY",cause:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INVALIDQUERY_CAUSE",resolution:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INVALIDQUERY_SPECIFYVALUEPROPERTY_RESOLUTION",code:"VIT6"},VIT7:{summary:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_SUMMARY",cause:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_PREDICATENOTSPECIFIED_CAUSE",resolution:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_PREDICATENOTSPECIFIED_SPECIFYPREDICATE_RESOLUTION",code:"VIT7"},VIT8:{summary:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_SUMMARY",cause:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INCORRECTPREDICATEVALUE_CAUSE",resolution:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INCORRECTPREDICATEVALUE_INVALIDPREDICATE_RESOLUTION",code:"VIT8"},VIT9:{summary:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_SUMMARY",cause:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INCORRECTPREDICATEVALUE_CAUSE",resolution:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_INCORRECTPREDICATEVALUE_INVALIDPREDICATE_RESOLUTION",code:"VIT9"},VIT10:{summary:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_SUMMARY",cause:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_NOMETADATASPECIFIED_CAUSE",resolution:"NODEHIERARCHY_MSG_COULDNOTSEARCHNODES_NOMETADATASPECIFIED_SPECIFYMETADATACATEGORY_RESOLUTION",code:"VIT10"},VIT11:{summary:"OVERLAY_MSG_EVENTHANDLERFAILED_SUMMARY",cause:"OVERLAY_MSG_EVENTHANDLERFAILED_UNSUPPORTEDEVENTTYPE_CAUSE",resolution:"OVERLAY_MSG_EVENTHANDLERFAILED_UNSUPPORTEDEVENTTYPE_CHECKEVENTTYPE_RESOLUTION",code:"VIT11"},VIT12:{summary:"STEPNAVIGATION_MSG_STEPCOULDNOTBEPLAYED_SUMMARY",cause:"STEPNAVIGATION_MSG_STEPCOULDNOTBEPLAYED_INCORRECTSTEPEVENTTYPE_CAUSE",resolution:"STEPNAVIGATION_MSG_STEPCOULDNOTBEPLAYED_INCORRECTSTEPEVENTTYPE_CHECKSTEPEVENTTYPEVALUE_RESOLUTION",code:"VIT12"},VIT13:{summary:"VIEWER_MSG_CONTENTRESOURCESNOTLOADED_SUMMARY",cause:"VIEWER_MSG_CONTENTRESOURCESNOTLOADED_NONEXISTINGORUNSUPPORTEDFILE_CAUSE",resolution:"VIEWER_MSG_CONTENTRESOURCESNOTLOADED_NONEXISTINGORUNSUPPORTEDFILE_CHECKFILEEXISTSANDIFSUPPORT_RESOLUTION",code:"VIT13"},VIT14:{summary:"VIEWER_MSG_FAILEDTOBUILDSCENE_SUMMARY",cause:"VIEWER_MSG_FAILEDTOBUILDSCENE_COULDNOTCREATESCENE_CAUSE",resolution:"VIEWER_MSG_FAILEDTOBUILDSCENE_COULDNOTCREATESCENE_RELOADORSELECTANOTHERFILE_RESOLUTION",code:"VIT14"},VIT15:{summary:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_SUMMARY",cause:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_LOADINGMULTIPLE2DNOTSUPPORTED_CAUSE",resolution:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_LOADINGMULTIPLE2DNOTSUPPORTED_LOADONE2D_RESOLUTION",code:"VIT15"},VIT16:{summary:"VIEWER_MSG_NOTBELOADED_SUMMARY",cause:"VIEWER_MSG_NOTBELOADED_NONATIVESUPPORT_CAUSE",resolution:"VIEWER_MSG_NOTBELOADED_NONATIVESUPPORT_CHECKFILEFORMATSUPPORT_RESOLUTION",code:"VIT16"},VIT17:{summary:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_SUMMARY",cause:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_COMBINATIONOF2D3DNOTSUPPORTED_CAUSE",resolution:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_COMBINATIONOF2D3DNOTSUPPORTED_MULTIPLESUPPORTFOR3DONLY_RESOLUTION",code:"VIT17"},VIT18:{summary:"VIEWPORT_MSG_ERRORLOADINGVIEWPORT_SUMMARY",cause:"VIEWPORT_MSG_ERRORLOADINGVIEWPORT_CREATINGMULTIPLEVIEWPORTINSTANCES_CAUSE",resolution:"VIEWPORT_MSG_ERRORLOADINGVIEWPORT_CREATINGMULTIPLEVIEWPORTINSTANCES_ONEINSTANCEOFVIEWPORTSUPPORTED_RESOLUTION",code:"VIT18"},VIT19:{summary:"VIEWPORT_MSG_COULDNOTSETCAMERAPROJECTION_SUMMARY",cause:"VIEWPORT_MSG_COULDNOTSETCAMERAPROJECTION_SPECIFIEDCAMERAPROJECTIONNOTSUPPORTED_CAUSE",resolution:"VIEWPORT_MSG_COULDNOTSETCAMERAPROJECTION_SPECIFIEDCAMERAPROJECTIONNOTSUPPORTED_CHECKPROJECTIONTYPESUPPORTED_RESOLUTION",code:"VIT19"},VIT20:{summary:"DOWNLOADMANAGER_MSG_VDS4_BETA_WARNING_SUMMARY",cause:"DOWNLOADMANAGER_MSG_VDS4_BETA_WARNING_CAUSE",resolution:"DOWNLOADMANAGER_MSG_VDS4_BETA_WARNING_RESOLUTION",code:"VIT20"},VIT21:{summary:"VIEWER_MSG_FAILEDTOBUILDSCENE_SUMMARY",cause:"VIEWER_MSG_FAILEDTOBUILDSCENE_MISSINGPASSWORD_CAUSE",resolution:"VIEWER_MSG_FAILEDTOBUILDSCENE_MISSINGPASSWORD_PROVIDEPASSWORD_RESOLUTION",code:"VIT21"},VIT22:{summary:"GRAPHICSCORE_MSG_VDSL_NOFILEPROPERTY_SUMMARY",cause:"GRAPHICSCORE_MSG_VDSL_EMPTY_CAUSE",resolution:"GRAPHICSCORE_MSG_VDSL_FIRSTLINE_WRONGFORMAT_RESOLUTION",code:"VIT22"},VIT23:{summary:"GRAPHICSCORE_MSG_VDSL_FIRSTLINE_WRONGFORMAT_SUMMARY",cause:"GRAPHICSCORE_MSG_VDSL_WRONGFORMAT_CAUSE",resolution:"GRAPHICSCORE_MSG_VDSL_FIRSTLINE_WRONGFORMAT_RESOLUTION",code:"VIT23"},VIT24:{summary:"GRAPHICSCORE_MSG_VDSL_RELATIVE_IN_LOCAL_SUMMARY",cause:"GRAPHICSCORE_MSG_VDSL_WRONGFORMAT_CAUSE",resolution:"GRAPHICSCORE_MSG_VDSL_RELATIVE_IN_LOCAL_RESOLUTION",code:"VIT24"},VIT25:{summary:"GRAPHICSCORE_MSG_VDS3ENCRYPTED_SUMMARY",cause:"GRAPHICSCORE_MSG_VDS3ENCRYPTED_CAUSE",resolution:"GRAPHICSCORE_MSG_VDS3ENCRYPTED_RESOLUTION",code:"VIT25"},VIT26:{summary:"VIEWPORT_UNSUPPORTED_STEP_INDEX_SUMMARY",cause:"VIEWPORT_UNSUPPORTED_STEP_INDEX_CAUSE",resolution:"VIEWPORT_UNSUPPORTED_STEP_INDEX_RESOLUTION",code:"VIT26"},VIT27:{summary:"VIEWPORT_UNSUPPORTED_PROCEDURE_INDEX_SUMMARY",cause:"VIEWPORT_UNSUPPORTED_PROCEDURE_INDEX_CAUSE",resolution:"VIEWPORT_UNSUPPORTED_PROCEDURE_INDEX_RESOLUTION",code:"VIT27"},VIT28:{summary:"VIEWPORT_UNSUPPORTED_VISIBILITY_MODE_SUMMARY",cause:"VIEWPORT_UNSUPPORTED_VISIBILITY_MODE_CAUSE",resolution:"VIEWPORT_UNSUPPORTED_VISIBILITY_MODE_RESOLUTION",code:"VIT28"},VIT29:{summary:"VIEWER_RUNTIME_SETTINGS_NOT_CHANGEABLE_SUMMARY",cause:"VIEWER_RUNTIME_SETTINGS_NOT_CHANGEABLE_CAUSE",resolution:"VIEWER_RUNTIME_SETTINGS_NOT_CHANGEABLE_RESOLUTION",code:"VIT29"},VIT30:{summary:"VIEWER_WEBGLCONTEXTATTRIBUTES_NOT_CHANGEABLE_SUMMARY",cause:"VIEWER_WEBGLCONTEXTATTRIBUTES_NOT_CHANGEABLE_CAUSE",resolution:"VIEWER_WEBGLCONTEXTATTRIBUTES_NOT_CHANGEABLE_RESOLUTION",code:"VIT30"},VIT31:{summary:"VIEWPORT_UNSUPPORTED_RESET_OPTIONS_SUMMARY",cause:"VIEWPORT_UNSUPPORTED_RESET_OPTIONS_CAUSE",resolution:"VIEWPORT_UNSUPPORTED_RESET_OPTIONS_RESOLUTION",code:"VIT31"},VIT32:{summary:"VIEWPORT_UNSUPPORTED_VISIBILITY_TRACKING_SUMMARY",cause:"VIEWPORT_UNSUPPORTED_VISIBILITY_TRACKING_CAUSE",resolution:"VIEWPORT_UNSUPPORTED_VISIBILITY_TRACKING_RESOLUTION",code:"VIT32"},VIT33:{summary:"VIEWER_SOURCE_FAILED_TO_DOWNLOAD_SUMMARY",cause:"VIEWER_SOURCE_FAILED_TO_DOWNLOAD_CAUSE",resolution:"VIEWER_SOURCE_FAILED_TO_DOWNLOAD_RESOLUTION",code:"VIT33"},VIT34:{summary:"VIEWER_SOURCE_FAILED_TO_LOAD_SUMMARY",cause:"VIEWER_SOURCE_FAILED_TO_LOAD_CAUSE",resolution:"VIEWER_SOURCE_FAILED_TO_LOAD_RESOLUTION",code:"VIT34"},VIT35:{summary:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_SUMMARY",cause:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_COMBINATIONOFDIFFRENTCONTENTMANAGERSNOTSUPPORTED_CAUSE",resolution:"VIEWER_MSG_ERRORLOADINGMULTIPLEFILES_COMBINATIONOFDIFFRENTCONTENTMANAGERSNOTSUPPORTED_MULTIPLESUPPORTFORSAMECONTENTMANAGER_RESOLUTION",code:"VIT35"},VIT36:{summary:"VIEWER_UNKNOWN_CONTENT_RESOURCE_TYPE_SUMMARY",cause:"VIEWER_UNKNOWN_CONTENT_RESOURCE_TYPE_CAUSE",resolution:"VIEWER_UNKNOWN_CONTENT_RESOURCE_TYPE_RESOLUTION",code:"VIT36"},VIT37:{summary:"VIEWER_MSG_FAILEDTOLOADCONTENT_SUMMARY",cause:"VIEWER_MSG_FAILEDTOLOADCONTENT_URLORAUTHENTICATION_CAUSE",resolution:"VIEWER_MSG_FAILEDTOLOADCONTENT_URLORAUTHENTICATION_RESOLUTION",code:"VIT37"}};return M;},true);
sap.ui.predefine('sap/ui/vk/NativeViewportRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitNativeViewport");r.writeClasses();r.writeAttribute("tabindex",0);r.write(">");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/ui/vk/NodeHierarchy',["jquery.sap.global","sap/ui/base/ManagedObject","./Messages","./getResourceBundle"],function(q,M,a,g){"use strict";
var N=M.extend("sap.ui.vk.NodeHierarchy",{metadata:{"abstract":true,events:{changed:{},nodeCreated:{parameters:{nodeRef:{type:"any"},nodeId:{type:"string"}}},nodeRemoving:{parameters:{nodeRef:{type:"any"},nodeId:{type:"string"}}},nodeReplaced:{parameters:{ReplacedNodeRef:{type:"any"},ReplacementNodeRef:{type:"any"},ReplacedNodeId:{type:"string"},ReplacementNodeId:{type:"string"}}},nodeUpdated:{parameters:{nodeRef:{type:"any"},nodeId:{type:"string"}}}}}});
N.prototype.findNodesById=function(b){if(b.fields.some(function(h){return!h.caseSensitive;})){b=q.extend(true,{},b);b.fields.forEach(function(h){if(!h.caseSensitive){h.value=h.value.toLowerCase();}});}var c=function(p,h,v,j){var m;p=p||"equals";j=j||"";var k=h?v:v.toLowerCase();switch(p){case"equals":m=(k===j);break;case"contains":m=(k.indexOf(j)!==-1);break;case"startsWith":m=(k.indexOf(j)===0);break;default:m=false;q.sap.log.error(g().getText(a.VIT8.summary),a.VIT8.code,"sap.ui.vk.dvl.NodeHierarchy");}return m;};var i=function(l,h){return!l.some(function(v){return h.name===v.name?c(h.predicate,h.caseSensitive,v.value,h.value):false;});};var f=function(b,v){return b.source===v.source&&b.type===v.type&&!b.fields.some(i.bind(undefined,v.fields));};var d=this.findNodesByName();var e=d.filter(function(n){var h=this.createNodeProxy(n);var v=h.getVeIds();this.destroyNodeProxy(h);return v.some(f.bind(undefined,b));}.bind(this));return e;};
N.prototype.findNodesByMetadata=function(b){var c=function(m,k,l,v,i,j){if(m&&m.hasOwnProperty(k)){var n=m[k];if(n.hasOwnProperty(l)){var o=n[l];if(!j){o=o.toLowerCase();}return v.some(i.bind(undefined,o));}}return false;};var d=function(m,k){return m&&m.hasOwnProperty(k);};var e=function(f,h,k,l,v,i,j){var n=this._baseNodeProxyPool.borrowObject();var r=f.filter(function(m){n.init(this,m);var o=n.getNodeMetadata();var s=h(o,k,l,v,i,j);n.reset();return s;}.bind(this));this._baseNodeProxyPool.returnObject(n);return r;};var f=this.findNodesByName(),r=[];if(b===undefined||b===null||q.isEmptyObject(b)){r=f;}else if(b.category!==null&&b.category!==undefined&&b.category!==""){var h,v,p,i,j=!!(b&&b.caseSensitive);if(b.key===undefined||b.key===null){h=d;}else{v=b.value;p=b.predicate||"equals";if(v===undefined||v===null){v="";p="contains";}if(!Array.isArray(v)){v=[v];}if(!j){v=v.map(function(k){return k.toLowerCase();});}switch(p){case"equals":i=function(m,k){return m===k;};break;case"contains":i=function(m,k){return m.indexOf(k)!==-1;};break;case"startsWith":i=function(m,k){return m.indexOf(k)===0;};break;default:q.sap.log.error(g().getText(a.VIT9.summary),a.VIT9.code,"sap.ui.vk.dvl.NodeHierarchy");}h=c;}r=e.bind(this)(f,h,b.category,b.key,v,i,j);}else{q.sap.log.error(g().getText(a.VIT10.summary),a.VIT10.code,"sap.ui.vk.dvl.NodeHierarchy");}return q.sap.unique(r);};
N.prototype._appendAncestors=function(n,s){s=s?new Set(s):null;var b=new Set(n);n.forEach(function(d){var e=this.getAncestors(d);e.forEach(function(f){if(s===null||!s.has(f)){b.add(f);}});},this);var c=[];b.forEach(function(d){c.push(d);});return c;};
return N;});
sap.ui.predefine('sap/ui/vk/NodeProxy',["sap/ui/base/ManagedObject"],function(M){"use strict";
var N=M.extend("sap.ui.vk.NodeProxy",{metadata:{properties:{nodeRef:"any",veIds:"object[]",name:"string",localMatrix:{type:"sap.ui.vk.TransformationMatrix",bindable:"bindable"},worldMatrix:{type:"sap.ui.vk.TransformationMatrix",bindable:"bindable"},material:{type:"sap.ui.vk.Material"},opacity:{type:"float",bindable:"bindable"},tintColorABGR:{type:"int",bindable:"bindable"},tintColor:{type:"sap.ui.core.CSSColor",bindable:"bindable"},nodeMetadata:"object",hasChildren:"boolean",closed:"boolean"}}});
N.prototype.setClosed=function(v){return this;};
N.prototype.setHasChildren=function(v){return this;};
N.prototype.setName=function(v){return this;};
N.prototype.setNodeId=function(v){return this;};
N.prototype.setNodeMetadata=function(v){return this;};
N.prototype.setVeIds=function(v){return this;};
N.prototype.assignMaterial=function(v){return this;};
N.prototype.getLocalTranslate=function(){return[0,0,0];};
N.prototype.getLocalScale=function(){return[1,1,1];};
N.prototype.getLocalRotationInQuaternion=function(){return[1,0,0,1];};
N.prototype.getLocalRotationInAngleAxis=function(){return[1,0,0,0];};
N.prototype.getLocalRotationInEuler=function(){return[0,0,0,0];};
return N;});
sap.ui.predefine('sap/ui/vk/NotificationsRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitNotifications");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_messagePopoverToggleButton"));r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/ui/vk/ObjectType',[],function(){"use strict";var O={PMI:0,Hotspot:1};return O;},true);
sap.ui.predefine('sap/ui/vk/OrthographicCamera',["./Camera"],function(C){"use strict";
var O=C.extend("sap.ui.vk.OrthographicCamera",{metadata:{properties:{"zoomFactor":{type:"float"}}}});
return O;});
sap.ui.predefine('sap/ui/vk/PerspectiveCamera',["./Camera"],function(C){"use strict";
var P=C.extend("sap.ui.vk.PerspectiveCamera",{metadata:{properties:{"fov":{type:"float"}}}});
return P;});
sap.ui.predefine('sap/ui/vk/ProgressIndicator',["jquery.sap.global","sap/m/ProgressIndicator","./ProgressIndicatorRenderer"],function(q,M,P){"use strict";
var a=M.extend("sap.ui.vk.ProgressIndicator");
a.prototype.setPercentValue=function(p){var i=function i(v){return(typeof(v)==="number")&&!isNaN(v)&&v>=0&&v<=100;};var t=this,$,f,b=this.$(),A,u=false;if(!i(p)){p=0;q.sap.log.warning(this+": percentValue ("+p+") is not correct! Setting the default percentValue:0.");}if(this.getPercentValue()!==p){f=this.getPercentValue()-p;this.setProperty("percentValue",p,true);if(!b.length){return this;}["sapMPIValueMax","sapMPIValueMin","sapMPIValueNormal","sapMPIValueGreaterHalf"].forEach(function(c){b.removeClass(c);});b.addClass(this._getCSSClassByPercentValue(p));b.addClass("sapMPIAnimate").attr("aria-valuenow",p).attr("aria-valuetext",this._getAriaValueText({fPercent:p}));A=u?Math.abs(f)*20:0;$=this.$("bar");$.animate({"flex-basis":p+"%"},A,"linear",function(){t._setText.apply(t);t.$().removeClass("sapMPIAnimate");});}return this;};
return a;});
sap.ui.predefine('sap/ui/vk/ProgressIndicatorRenderer',["sap/m/ProgressIndicatorRenderer"],function(P){"use strict";return P;},true);
sap.ui.predefine('sap/ui/vk/Redline',[],function(){"use strict";var R={ElementType:{Line:"line",Rectangle:"rectangle",Ellipse:"ellipse",Freehand:"freehand",Text:"text"},svgNamespace:"http://www.w3.org/2000/svg"};return R;},true);
sap.ui.predefine('sap/ui/vk/RedlineDesign',["sap/ui/core/Control","./RedlineSurface","./RedlineElement","./RedlineGesturesHandler","./RedlineDesignHandler","./Loco","./RedlineDesignRenderer"],function(C,R,a,b,c,L,d){"use strict";
var e=R.extend("sap.ui.vk.RedlineDesign",{metadata:{library:"sap.ui.vk",events:{elementCreated:{parameters:{element:"object"}}},aggregations:{activeElementInstance:{type:"sap.ui.vk.RedlineElement",multiple:false,visibility:"hidden"}}}});
e.prototype.init=function(){this._isAddingModeActive=false;this._isDrawingOn=false;this._activeElementInstance=null;this.addStyleClass("sapUiVizkitRedlineInteractionMode");this._gestureHandler=new b(this);this._designHandler=new c(this);this._loco=new L(this);};
e.prototype.onBeforeRendering=function(){if(this._loco){this._loco.removeHandler(this._gestureHandler);this._loco.removeHandler(this._designHandler);}};
e.prototype.onAfterRendering=function(){var f=this.getDomRef();f.style.width="100%";f.style.height="100%";if(this._isAddingModeActive){this._loco.addHandler(this._designHandler);}else{this._loco.addHandler(this._gestureHandler);}this.updatePanningRatio();};
e.prototype._editElement=function(f,o,g){f.edit(o,g);return this;};
e.prototype._getIsDrawingOn=function(){return this._isDrawingOn;};
e.prototype._setIsDrawingOn=function(i){this._isDrawingOn=i;return this;};
e.prototype.startAdding=function(f){this._isAddingModeActive=true;this._activeElementInstance=f;this.setAggregation("activeElementInstance",this._activeElementInstance);this.addStyleClass("sapUiVizkitRedlineDesignMode");this.removeStyleClass("sapUiVizkitRedlineInteractionMode");return this;};
e.prototype.stopAdding=function(){this._isAddingModeActive=false;this._setIsDrawingOn(false);this.setAggregation("activeElementInstance",null);this._activeElementInstance=null;this.addStyleClass("sapUiVizkitRedlineInteractionMode");this.removeStyleClass("sapUiVizkitRedlineDesignMode");return this;};
e.prototype._getOffset=function(o){var r=o.getBoundingClientRect();return{x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};};
e.prototype._getTargetViewport=function(){return this._targetViewport;};
e.prototype._setTargetViewport=function(v){this._targetViewport=v;this._targetViewport.attachEvent("resize",this,this._onresize,this);};
e.prototype._onresize=function(f){var v=f.oSource.getOutputSize();this.setProperty("virtualLeft",v.left,true);this.setProperty("virtualTop",v.top,true);this.setProperty("virtualSideLength",v.sideLength,true);this.invalidate();};
return e;});
sap.ui.predefine('sap/ui/vk/RedlineDesignHandler',["sap/ui/base/EventProvider","sap/ui/core/ResizeHandler"],function(E,R){"use strict";
var a=E.extend("sap.ui.vk.RedlineDesignHandler",{
metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},
constructor:function(r){this._redlineDesign=r;this._x=0;this._y=0;this._gesture=false;}
});
a.prototype.destroy=function(){this._redlineDesign=null;this._rect=null;this._gesture=false;};
a.prototype._getOffset=function(d){var r=d.getBoundingClientRect();return{x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};};
a.prototype._inside=function(e,r){var b=r.getDomRef(),i=false;if(b!==null){var c=this._getOffset(b);var d={x:c.x,y:c.y,width:b.getBoundingClientRect().width,height:b.getBoundingClientRect().height};i=(e.x>=d.x&&e.x<=d.x+d.width&&e.y>=d.y&&e.y<=d.y+d.height);}return i;};
a.prototype._onresize=function(e){this._gesture=false;};
a.prototype.beginGesture=function(e){var v=this.getViewport();if(this._inside(e,v)&&v._activeElementInstance){this._gesture=true;this._x=e.x;this._y=e.y;v._setIsDrawingOn(true);var d=v.getDomRef();var t=v._toVirtualSpace(e.x-d.getBoundingClientRect().left-window.pageXOffset,e.y-d.getBoundingClientRect().top-window.pageYOffset);v._activeElementInstance.setOriginX(t.x);v._activeElementInstance.setOriginY(t.y);if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){v.invalidate();}else{var r=sap.ui.getCore().createRenderManager();v._activeElementInstance.render(r);r.flush(v.getDomRef(),false,true);r.destroy();var x=v.$();x.html(x.html());}e.handled=true;}return this;};
a.prototype.move=function(e){var v=this.getViewport();if(v._activeElementInstance&&v._getIsDrawingOn()){var b=v.getDomRef().getBoundingClientRect(),o=e.x-b.left-window.pageXOffset,c=e.y-b.top-window.pageYOffset;v._editElement(v._activeElementInstance,o,c);e.handled=true;}return this;};
a.prototype.endGesture=function(e){var v=this.getViewport();this._gesture=false;if(v._activeElementInstance){v.addRedlineElement(v._activeElementInstance);v.fireElementCreated({element:v._activeElementInstance});v.stopAdding();e.handled=true;}return this;};
a.prototype.contextMenu=function(e){e.handled=true;};
a.prototype.getViewport=function(){return this._redlineDesign;};
return a;});
sap.ui.predefine('sap/ui/vk/RedlineDesignRenderer',["./RedlineSurfaceRenderer","sap/ui/core/Renderer"],function(R,a){"use strict";var b=a.extend(R);
b.render=function(r,c){R.render.call(this,r,c);};
b.renderAfterRedlineElements=function(r,c){if(c._activeElementInstance&&c._getIsDrawingOn()){c._activeElementInstance.render(r);}};
return b;},true);
sap.ui.predefine('sap/ui/vk/RedlineElement',["sap/ui/core/Element"],function(E){"use strict";
var R=E.extend("sap.ui.vk.RedlineElement",{metadata:{library:"sap.ui.vk",properties:{elementId:{type:"string"},originX:{type:"float",defaultValue:0},originY:{type:"float",defaultValue:0},opacity:{type:"float",defaultValue:1},strokeWidth:{type:"float",defaultValue:2},strokeColor:{type:"sap.ui.core.CSSColor",defaultValue:"#e6600d"},strokeDashArray:{type:"float[]",defaultValue:[]},halo:{type:"boolean",defaultValue:false}}}});
R.prototype.init=function(){var g=function(){var s=function(){return Math.floor((1+Math.random())*0x10000).toString(16).substring(1);};return s()+s()+"-"+s()+"-"+s()+"-"+s()+"-"+s()+s()+s();};this.setElementId(g());};
R.prototype.applyZoom=function(){};
R.prototype.render=function(r){this.renderElement(r,this.getHalo());};
R.prototype.renderElement=function(r,h){};
R.prototype.exportJSON=function(){var j={originX:this.getOriginX(),originY:this.getOriginY(),opacity:this.getOpacity(),strokeColor:this.getStrokeColor(),strokeWidth:this.getStrokeWidth(),elementId:this.getElementId(),halo:this.getHalo()};if(this.getStrokeDashArray().length>0){j["strokeDashArray"]=this.getStrokeDashArray();}return j;};
R.prototype.importJSON=function(j){if(j.hasOwnProperty("originX")){this.setOriginX(j.originX);}if(j.hasOwnProperty("originY")){this.setOriginY(j.originY);}if(j.hasOwnProperty("opacity")){this.setOpacity(j.opacity);}if(j.hasOwnProperty("strokeColor")){this.setStrokeColor(j.strokeColor);}if(j.hasOwnProperty("strokeWidth")){this.setStrokeWidth(j.strokeWidth);}if(j.hasOwnProperty("strokeDashArray")){this.setStrokeDashArray(j.strokeDashArray);}if(j.hasOwnProperty("elementId")){this.setElementId(j.elementId);}if(j.hasOwnProperty("halo")){this.setHalo(j.halo);}return this;};
R.prototype.exportSVG=function(){return null;};
R.prototype.importSVG=function(s){if(s.getAttribute("x")){this.setOriginX(parseFloat(s.getAttribute("x")));}if(s.getAttribute("y")){this.setOriginY(parseFloat(s.getAttribute("y")));}if(s.getAttribute("opacity")){this.setOpacity(parseFloat(s.getAttribute("opacity")));}if(s.getAttribute("stroke")){this.setStrokeColor(s.getAttribute("stroke"));}if(s.getAttribute("stroke-width")){this.setStrokeWidth(parseFloat(s.getAttribute("stroke-width")));}if(s.getAttribute("stroke-dasharray")){this.setStrokeDashArray(s.getAttribute("stroke-dasharray").split(",").map(parseFloat));}if(s.getAttribute("data-sap-element-id")){this.setElementId(s.getAttribute("data-sap-element-id"));}this.setHalo(s.getAttribute("data-sap-halo")==="true");return this;};
return R;});
sap.ui.predefine('sap/ui/vk/RedlineElementEllipse',["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";
var b=R.extend("sap.ui.vk.RedlineElementEllipse",{metadata:{library:"sap.ui.vk",properties:{radiusX:{type:"float",defaultValue:0.0001},radiusY:{type:"float",defaultValue:0.0001},fillColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 0)"}}}});
b.prototype.edit=function(o,c){var p=this.getParent(),t=p._toVirtualSpace(o,c),r=t.x-this.getOriginX(),d=t.y-this.getOriginY();this.setRadiusX(r>0?r:-r);this.setRadiusY(d>0?d:-d);return this;};
b.prototype.applyZoom=function(z){this.setProperty("radiusX",this.getRadiusX()*z,true);this.setProperty("radiusY",this.getRadiusY()*z,true);return this;};
b.prototype.setRadiusX=function(r){this.setProperty("radiusX",r,true);var d=this.getDomRef();if(d){d.setAttribute("rx",this.getParent()._toPixelSpace(r));}};
b.prototype.setRadiusY=function(r){this.setProperty("radiusY",r,true);var d=this.getDomRef();if(d){d.setAttribute("ry",this.getParent()._toPixelSpace(r));}};
b.prototype.renderElement=function(r,h){var p=this.getParent();r.write("<ellipse");r.writeElementData(this);var o=p._toPixelSpace(this.getOriginX(),this.getOriginY());r.writeAttribute("cx",o.x);r.writeAttribute("cy",o.y);r.writeAttribute("rx",p._toPixelSpace(this.getRadiusX()));r.writeAttribute("ry",p._toPixelSpace(this.getRadiusY()));r.writeAttribute("fill",this.getFillColor());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());if(h){r.writeAttribute("filter","url(#halo)");}r.write("></ellipse>");};
b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Ellipse,version:1,radiusX:this.getRadiusX(),radiusY:this.getRadiusY(),fillColor:this.getFillColor()});};
b.prototype.importJSON=function(j){if(j.type===a.ElementType.Ellipse){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("radiusX")){this.setRadiusX(j.radiusX);}if(j.hasOwnProperty("radiusY")){this.setRadiusY(j.radiusY);}if(j.hasOwnProperty("fillColor")){this.setFillColor(j.fillColor);}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};
b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"ellipse");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());e.setAttribute("rx",this.getRadiusX());e.setAttribute("ry",this.getRadiusY());e.setAttribute("fill",this.getFillColor());e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());return e;};
b.prototype.importSVG=function(s){if(s.tagName==="ellipse"){R.prototype.importSVG.call(this,s);if(s.getAttribute("rx")){this.setRadiusX(parseFloat(s.getAttribute("rx")));}if(s.getAttribute("ry")){this.setRadiusY(parseFloat(s.getAttribute("ry")));}if(s.getAttribute("fill")){this.setFillColor(s.getAttribute("fill"));}}else{q.sap.log("Redlining SVG import: Wrong element type");}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/RedlineElementFreehand',["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";
var b=R.extend("sap.ui.vk.RedlineElementFreehand",{metadata:{library:"sap.ui.vk",properties:{path:{type:"float[]",defaultValue:null}}}});
b.prototype.setPath=function(p){this.setProperty("path",p,true);var d=this.getDomRef();if(d){d.setAttribute("d",this._getProcessedPath());}};
b.prototype.edit=function(o,c){var p=this.getParent();var t=p._toVirtualSpace(o,c);var d=this.getPath()||[];d.push(t.x-this.getOriginX(),t.y-this.getOriginY());this.setPath(d);var e=this.getDomRef();if(e){e.setAttribute("d",this._getProcessedPath());}return this;};
b.prototype.applyZoom=function(z){this.setProperty("path",this.getPath().map(function(v){return v*z;}),true);return this;};
b.prototype._getProcessedPath=function(){var p=this.getParent(),o=p._toPixelSpace(this.getOriginX(),this.getOriginY());var d="";(this.getPath()||[]).forEach(function(e,i){e=p._toPixelSpace(e);if(i===0){d+="M "+(o.x+e);}else if(i===1){d+=" "+(o.y+e);}else{d+=" "+(i%2===0?"L "+(o.x+e):(o.y+e));}});return d;};
b.prototype.renderElement=function(r,h){r.write("<path");r.writeElementData(this);r.writeAttribute("d",this._getProcessedPath());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());r.writeAttribute("fill","none");if(h){r.writeAttribute("filter","url(#halo)");}r.write("></path>");};
b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Freehand,version:1,path:(this.getPath()||[]).slice()});};
b.prototype.importJSON=function(j){if(j.type===a.ElementType.Freehand){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("path")){this.setPath(j.path.slice());}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};
b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"path");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());e.setAttribute("d",this.getPath());e.setAttribute("fill","none");e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());return e;};
b.prototype.importSVG=function(s){if(s.tagName==="path"){R.prototype.importSVG.call(this,s);if(s.getAttribute("d")){this.setPath(s.getAttribute("d").split(",").map(parseFloat));}}else{q.sap.log.error("Redlining SVG import: Wrong element type");}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/RedlineElementLine',["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";
var b=R.extend("sap.ui.vk.RedlineElementLine",{metadata:{library:"sap.ui.vk",properties:{deltaX:{type:"float",defaultValue:0},deltaY:{type:"float",defaultValue:0}}}});
b.prototype.edit=function(o,c){var p=this.getParent(),t=p._toVirtualSpace(o,c);this.setDeltaX(t.x-this.getOriginX());this.setDeltaY(t.y-this.getOriginY());return this;};
b.prototype.applyZoom=function(z){this.setProperty("deltaX",this.getDeltaX()*z);this.setProperty("deltaY",this.getDeltaY()*z);return this;};
b.prototype.getP2=function(v){return this.getParent()._toPixelSpace(this.getOriginX()+this.getDeltaX(),this.getOriginY()+this.getDeltaY());};
b.prototype.setDeltaX=function(v){this.setProperty("deltaX",v);var d=this.getDomRef();if(d){d.setAttribute("x2",this.getP2().x);}};
b.prototype.setDeltaY=function(v){this.setProperty("deltaY",v);var d=this.getDomRef();if(d){d.setAttribute("y2",this.getP2().y);}};
b.prototype.renderElement=function(r,h){var p=this.getParent()._toPixelSpace(this.getOriginX(),this.getOriginY());var c=this.getP2();r.write("<line");r.writeElementData(this);r.writeAttribute("x1",p.x);r.writeAttribute("y1",p.y);r.writeAttribute("x2",c.x);r.writeAttribute("y2",c.y);r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());if(h){r.writeAttribute("filter","url(#halo)");}r.write("></line>");};
b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Line,version:1,deltaX:this.getDeltaX(),deltaY:this.getDeltaY()});};
b.prototype.importJSON=function(j){if(j.type===a.ElementType.Line){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("deltaX")){this.setDeltaX(j.deltaX);}if(j.hasOwnProperty("deltaY")){this.setDeltaY(j.deltaY);}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};
b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"line");e.setAttribute("x1",this.getOriginX());e.setAttribute("y1",this.getOriginY());e.setAttribute("x2",this.getOriginX()+this.getDeltaX());e.setAttribute("y2",this.getOriginY()+this.getDeltaY());e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());return e;};
b.prototype.importSVG=function(s){if(s.tagName==="line"){R.prototype.importSVG.call(this,s);if(s.getAttribute("x1")){this.setOriginX(parseFloat(s.getAttribute("x1")));}if(s.getAttribute("y1")){this.setOriginY(parseFloat(s.getAttribute("y1")));}if(s.getAttribute("x2")){this.setDeltaX(parseFloat(s.getAttribute("x2"))-this.getOriginX());}if(s.getAttribute("y2")){this.setDeltaY(parseFloat(s.getAttribute("y2"))-this.getOriginY());}}else{q.sap.log("Redlining SVG import: Wrong element type");}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/RedlineElementRectangle',["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";
var b=R.extend("sap.ui.vk.RedlineElementRectangle",{metadata:{library:"sap.ui.vk",properties:{width:{type:"float",defaultValue:0.001},height:{type:"float",defaultValue:0.001},fillColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 0, 0)"}}}});
b.prototype.init=function(){R.prototype.init.apply(this);this._originX=0;this._originY=0;};
b.prototype.setOriginX=function(o){this.setProperty("originX",o);this._originX=o;};
b.prototype.setOriginY=function(o){this.setProperty("originY",o);this._originY=o;};
b.prototype.edit=function(o,c){var p=this.getParent(),t=p._toVirtualSpace(o,c),w=t.x-this._originX,h=t.y-this._originY;this.setProperty("originX",w<0?t.x:this._originX);this.setProperty("originY",h<0?t.y:this._originY);this.setWidth(Math.abs(w));this.setHeight(Math.abs(h));return this;};
b.prototype.applyZoom=function(z){this.setProperty("width",this.getWidth()*z,true);this.setProperty("height",this.getHeight()*z,true);return this;};
b.prototype.setWidth=function(w){this.setProperty("width",w,true);var d=this.getDomRef();if(d){d.setAttribute("width",this.getParent()._toPixelSpace(w));}};
b.prototype.setHeight=function(h){this.setProperty("height",h,true);var d=this.getDomRef();if(d){d.setAttribute("height",this.getParent()._toPixelSpace(h));}};
b.prototype.renderElement=function(r,h){var p=this.getParent();r.write("<rect");r.writeElementData(this);var o=p._toPixelSpace(this.getOriginX(),this.getOriginY());r.writeAttribute("x",o.x);r.writeAttribute("y",o.y);r.writeAttribute("width",p._toPixelSpace(this.getWidth()));r.writeAttribute("height",p._toPixelSpace(this.getHeight()));r.writeAttribute("fill",this.getFillColor());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());if(h){r.writeAttribute("filter","url(#halo)");}r.write("></rect>");};
b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Rectangle,version:1,width:this.getWidth(),height:this.getHeight(),fillColor:this.getFillColor()});};
b.prototype.importJSON=function(j){if(j.type===a.ElementType.Rectangle){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("width")){this.setWidth(j.width);}if(j.hasOwnProperty("height")){this.setHeight(j.height);}if(j.hasOwnProperty("fillColor")){this.setFillColor(j.fillColor);}}else{q.sap.log("wrong version number");}}else{q.sap.log("Redlining JSON import: Wrong element type");}return this;};
b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"rect");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());e.setAttribute("height",this.getHeight());e.setAttribute("width",this.getWidth());e.setAttribute("fill",this.getFillColor());e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());return e;};
b.prototype.importSVG=function(s){if(s.tagName==="rect"){R.prototype.importSVG.call(this,s);if(s.getAttribute("width")){this.setWidth(parseFloat(s.getAttribute("width")));}if(s.getAttribute("height")){this.setHeight(parseFloat(s.getAttribute("height")));}if(s.getAttribute("fill")){this.setFillColor(s.getAttribute("fill"));}}else{q.sap.log("Redlining SVG import: Wrong element type");}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/RedlineElementText',["jquery.sap.global","./RedlineElement","./Redline"],function(q,R,a){"use strict";
var b=R.extend("sap.ui.vk.RedlineElementText",{metadata:{library:"sap.ui.vk",properties:{text:{type:"string",defaultValue:"Text"},font:{type:"string",defaultValue:""},fontSize:{type:"float",defaultValue:32},fillColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0,0,0,0)"}}}});
b.prototype.edit=function(p,c){var d=this.getParent(),e=d._toVirtualSpace(p,c);this.setOriginX(e.x);this.setOriginY(e.y);return this;};
b.prototype.applyZoom=function(z){this.setFontSize(this.getFontSize()*z);return this;};
b.prototype.renderElement=function(r,h){var p=this.getParent()._toPixelSpace(this.getOriginX(),this.getOriginY());r.write("<text");r.writeElementData(this);r.writeAttribute("x",p.x);r.writeAttribute("y",p.y);if(this.getFont()){r.writeAttribute("font-family",this.getFont());}r.writeAttribute("font-size",this.getFontSize());r.writeAttribute("fill",this.getFillColor());r.writeAttribute("stroke",this.getStrokeColor());r.writeAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){r.writeAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}r.writeAttribute("opacity",this.getOpacity());if(h){r.writeAttribute("filter","url(#halo)");}r.write(">");r.write(this.getText());r.write("</text>");};
b.prototype.exportJSON=function(){return q.extend(true,R.prototype.exportJSON.call(this),{type:a.ElementType.Text,version:1,text:this.getText(),font:this.getFont(),fontSize:this.getFontSize(),fillColor:this.getFillColor()});};
b.prototype.importJSON=function(j){if(j.type===a.ElementType.Text){if(j.version===1){R.prototype.importJSON.call(this,j);if(j.hasOwnProperty("text")){this.setText(j.text);}if(j.hasOwnProperty("font")){this.setFont(j.font);}if(j.hasOwnProperty("fontSize")){this.setFontSize(j.fontSize);}if(j.hasOwnProperty("fillColor")){this.setFillColor(j.fillColor);}}else{q.sap.log.error("wrong version number");}}else{q.sap.log.error("Redlining JSON import: Wrong element type");}return this;};
b.prototype.exportSVG=function(){var e=document.createElementNS(a.svgNamespace,"text");e.setAttribute("x",this.getOriginX());e.setAttribute("y",this.getOriginY());if(this.getFont()){e.setAttribute("font-family",this.getFont());}e.setAttribute("font-size",this.getFontSize());e.setAttribute("fill",this.getFillColor());e.setAttribute("stroke",this.getStrokeColor());e.setAttribute("stroke-width",this.getStrokeWidth());if(this.getStrokeDashArray().length>0){e.setAttribute("stroke-dasharray",this.getStrokeDashArray().toString());}if(this.getOpacity()<1){e.setAttribute("opacity",this.getOpacity());}e.setAttribute("data-sap-element-id",this.getElementId());e.setAttribute("data-sap-halo",this.getHalo());e.textContent=this.getText();return e;};
b.prototype.importSVG=function(e){if(e.tagName==="text"){R.prototype.importSVG.call(this,e);if(e.getAttribute("x")){this.setOriginX(parseFloat(e.getAttribute("x")));}if(e.getAttribute("y")){this.setOriginY(parseFloat(e.getAttribute("y")));}if(e.getAttribute("text")){this.setText(e.getAttribute("text"));}if(e.getAttribute("font-family")){this.setFont(e.getAttribute("font-family"));}if(e.getAttribute("font-size")){this.setFontSize(parseFloat(e.getAttribute("font-size")));}if(e.getAttribute("fill")){this.setFillColor(e.getAttribute("fill"));}}else{q.sap.log("Redlining SVG import: Wrong element type");}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/RedlineGesturesHandler',["sap/ui/base/EventProvider","sap/ui/core/ResizeHandler","./NativeViewport"],function(E,R,N){"use strict";
var a=E.extend("sap.ui.vk.RedlineGesturesHandler",{
metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},
constructor:function(r){this._redlineDesign=r;this._x=0;this._y=0;this._d=0;this._zoomFactor=1;this._gesture=false;}
});
a.prototype.destroy=function(){this._redlineDesign=null;this._rect=null;this._gesture=false;};
a.prototype._getOffset=function(d){var r=d.getBoundingClientRect();return{x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};};
a.prototype._inside=function(e,r){var b=r.getDomRef(),i=false;if(b!==null){var c=this._getOffset(b);var d={x:c.x,y:c.y,width:b.getBoundingClientRect().width,height:b.getBoundingClientRect().height};i=(e.x>=d.x&&e.x<=d.x+d.width&&e.y>=d.y&&e.y<=d.y+d.height);}return i;};
a.prototype._onresize=function(e){this._gesture=false;};
a.prototype.beginGesture=function(e){var v=this.getViewport();if(this._inside(e,v)){this._gesture=true;this._x=e.x;this._y=e.y;this._d=e.d;this._initd=e.d;e.handled=true;}return this;};
a.prototype._pan=function(e){var v=this.getViewport(),d=e.x-this._x,b=e.y-this._y;if(d||b){this._x=e.x;this._y=e.y;var p=v.getPanningRatio();v.firePan({deltaX:d*p,deltaY:b*p});v.getRedlineElements().forEach(function(c){c.setOriginX(c.getOriginX()+v._toVirtualSpace(d));c.setOriginY(c.getOriginY()+v._toVirtualSpace(b));});this._manualRender(v);}};
a.prototype._zoom=function(e){var v=this.getViewport(),z=1;var d=e.d-this._d;this._d=e.d;if(this._initd>0){z=1+d*(1/this._initd);}else if(e.n===2){if(e.points[0].y>e.points[1].y){z=Math.max(1-d*0.005,0.333);}else{z=Math.min(1+d*0.005,3);}}z=Math.min(Math.max(z,0.88),1.12);var t=v._getTargetViewport();var b=32;var c=1/8;if(t instanceof N){b=t._getZoomInLimit();c=t._getZoomOutLimit();this._zoomFactor=t._getZoomFactor();}z=Math.min(Math.max(this._zoomFactor*z,c),b)/this._zoomFactor;this._zoomFactor*=z;var o=this._getOffset(v.getDomRef());var s=1-z,p=v._toVirtualSpace(e.x-o.x,e.y-o.y);v.getRedlineElements().forEach(function(f){f.applyZoom(z);var g=f.getOriginX(),h=f.getOriginY();g+=(p.x-g)*s;h+=(p.y-h)*s;f.setOriginX(g);f.setOriginY(h);});this._manualRender(v);v.fireZoom({originX:e.x-o.x,originY:e.y-o.y,zoomFactor:z});};
a.prototype.move=function(e){if(this.getViewport().getDomRef()){if(e.n===1||e.n===2){this._pan(e);}if(e.n===2&&!e.buttons){this._zoom(e);}}e.handled=true;return this;};
a.prototype._manualRender=function(r){if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){r.invalidate();}else{var b=sap.ui.getCore().createRenderManager();r.getRedlineElements().forEach(function(e){e.render(b);});b.flush(r.getDomRef(),false,false);b.destroy();var x=r.$();x.html(x.html());}};
a.prototype.endGesture=function(e){this._gesture=false;e.handled=true;return this;};
a.prototype.contextMenu=function(e){e.handled=true;};
a.prototype.getViewport=function(){return this._redlineDesign;};
return a;});
sap.ui.predefine('sap/ui/vk/RedlineSurface',["jquery.sap.global","./library","sap/ui/core/Control","./Loco","./RedlineGesturesHandler","./RedlineSurfaceRenderer","./Redline"],function(q,v,C,L,R,a,b){"use strict";
var c=C.extend("sap.ui.vk.RedlineSurface",{metadata:{library:"sap.ui.vk",aggregations:{redlineElements:{type:"sap.ui.vk.RedlineElement"}},properties:{virtualLeft:{type:"float"},virtualTop:{type:"float"},virtualSideLength:{type:"float"},panningRatio:{type:"float",defaultValue:1}},events:{pan:{parameters:{deltaX:"float",deltaY:"float"}},zoom:{parameters:{originX:"float",originY:"float",zoomFactor:"float"}}}}});
c.prototype.init=function(){};
c.prototype.onAfterRendering=function(){};
c.prototype.exportJSON=function(){return this.getRedlineElements().map(function(e){return e.exportJSON();});};
c.prototype.importJSON=function(j){if(!q.isArray(j)){j=[j];}j.forEach(function(d){var E;switch(d.type){case b.ElementType.Rectangle:E=sap.ui.vk.RedlineElementRectangle;break;case b.ElementType.Ellipse:E=sap.ui.vk.RedlineElementEllipse;break;case b.ElementType.Freehand:E=sap.ui.vk.RedlineElementFreehand;break;case b.ElementType.Line:E=sap.ui.vk.RedlineElementLine;break;case b.ElementType.Text:E=sap.ui.vk.RedlineElementText;break;default:q.sap.log.warning("Unsupported JSON element type "+d.type);}if(E!=null){this.addRedlineElement(new E().importJSON(d));}}.bind(this));return this;};
c.prototype._toVirtualSpace=function(x,y){if(arguments.length===1){return x/this.getVirtualSideLength();}else{return{x:(x-this.getVirtualLeft())/this.getVirtualSideLength(),y:(y-this.getVirtualTop())/this.getVirtualSideLength()};}};
c.prototype._toPixelSpace=function(x,y){if(arguments.length===1){return x*this.getVirtualSideLength();}else{return{x:x*this.getVirtualSideLength()+this.getVirtualLeft(),y:y*this.getVirtualSideLength()+this.getVirtualTop()};}};
c.prototype.setPanningRatio=function(p){this.setProperty("panningRatio",p,true);};
c.prototype.updatePanningRatio=function(){var d=this.getVirtualLeft(),e=this.getVirtualTop(),r=this.getDomRef(),f=r.getBoundingClientRect(),h=f.height,w=f.width,p;if(d===0&&(h<w&&e<0||(h>w&&e>0))){p=h/w;}else{p=1;}this.setPanningRatio(p);return this;};
c.prototype.exportSVG=function(){var s=document.createElementNS(b.svgNamespace,"svg");this.getRedlineElements().map(function(e){s.appendChild(e.exportSVG());});return s;};
c.prototype.importSVG=function(s){s.childNodes.forEach(function(t){if(t.getAttribute){var E;switch(t.tagName){case"rect":E=sap.ui.vk.RedlineElementRectangle;break;case"ellipse":E=sap.ui.vk.RedlineElementEllipse;break;case"path":E=sap.ui.vk.RedlineElementFreehand;break;case"line":E=sap.ui.vk.RedlineElementLine;break;case"text":E=sap.ui.vk.RedlineElementText;break;default:q.sap.log.warning("Unsupported SVG element type "+E);}if(E){this.addRedlineElement(new E().importSVG(t));}}}.bind(this));return this;};
return c;});
sap.ui.predefine('sap/ui/vk/RedlineSurfaceRenderer',[],function(){"use strict";var R={};
R.render=function(r,c){r.write("<svg");r.writeControlData(c);r.addClass("sapUiVizkitRedlineSurface");r.writeClasses();r.write(">");r.write("			<defs>				<filter id='halo' filterUnits='userSpaceOnUse' >					<feGaussianBlur in='SourceAlpha' stdDeviation='4' result='blur' />					<feMerge>						<feMergeNode in='blur' />						<feMergeNode in='SourceGraphic' />					</feMerge>				</filter>			</defs>		");c.getRedlineElements().forEach(function(a){a.render(r);});this.renderAfterRedlineElements(r,c);r.write("</svg>");};
R.renderAfterRedlineElements=function(r,c){};
return R;},true);
sap.ui.predefine('sap/ui/vk/RenderMode',[],function(){"use strict";var R={Default:"Default",XRay:"XRay",LineIllustration:"LineIllustration",ShadedIllustration:"ShadedIllustration",SolidOutline:"SolidOutline"};return R;},true);
sap.ui.predefine('sap/ui/vk/Scene',["sap/ui/base/ManagedObject"],function(M){"use strict";
var S=M.extend("sap.ui.vk.Scene",{metadata:{"abstract":true,properties:{doubleSided:{type:"boolean",defaultValue:false}}}});
return S;});
sap.ui.predefine('sap/ui/vk/SceneTree',["./library","sap/ui/core/Control","sap/ui/table/TreeTable","sap/ui/table/Column","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/m/Title","sap/m/SearchField","sap/m/Toolbar","sap/m/ToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/ui/core/Icon","./ContentConnector","./ViewStateManager","./SceneTreeRenderer","./getResourceBundle"],function(v,C,T,a,J,R,b,S,c,d,e,f,I,g,V,h,j){"use strict";
var k=C.extend("sap.ui.vk.SceneTree",{metadata:{library:"sap.ui.vk",properties:{title:{type:"string",defaultValue:j().getText("SCENETREE_TITLE")},showTitle:{type:"boolean",defaultValue:true},showSearchField:{type:"boolean",defaultValue:true}},aggregations:{treeTable:{type:"sap.ui.table.TreeTable",multiple:false}},associations:{contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false},viewStateManager:{type:"sap.ui.vk.ViewStateManager",multiple:false}},events:{contentChanged:{enableEventBubbling:true}}}});
var m="sap-icon://show",n="sap-icon://hide";var t=j().getText("SCENETREE_VISIBILITYSTATEVISIBLE"),o=j().getText("SCENETREE_VISIBILITYSTATEHIDDEN");
k.prototype._createNodeForSceneTree=function(i,l,p){var q=p.getVisibilityState(l);return{name:i,id:l,visible:q};};
k.prototype.setScene=function(s,i){this.setViewStateManager(i);this._setScene(s);};
k.prototype._setScene=function(s){this._scene=s;this.refresh();};
k.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}var i=this;this._title=new b({width:"100%",textAlign:sap.ui.core.TextAlign.Center,text:this.getTitle()});this._searchField=new S({layoutData:new d({shrinkable:true,maxWidth:"400px"}),search:function(p){var q=p.getParameter("query"),r=i._scene.getDefaultNodeHierarchy(),s=i._viewStateManager;if(r&&s){var u=!q?[]:r.findNodesByName({value:q,predicate:"contains"});var w=new Set(u);var x=[];s.enumerateSelection(function(y){if(!w.has(y)){x.push(y);}});s.setSelectionState(x,false,false);s.setSelectionState(u,true,false);}}});this._toolbar=new c({content:[this._title,new e(),this._searchField]});var l=new I({src:m,tooltip:t,width:"2em",height:"1.3em",size:"1.2em",press:function(p){var q=this.getSrc()!==m;this.setSrc(q?m:n);this.setTooltip(q?t:o);i._toggleVisibilityForAllChildren(i._model.getData(),q);}});this._tree=new T({title:this._toolbar,columnHeaderHeight:32,columns:[new a({label:j().getText("SCENETREE_NAME"),tooltip:j().getText("SCENETREE_NAME"),template:new f({text:"{name}",maxLines:1,tooltip:"{name}"}),resizable:false}),new a(this.getId()+"-visibilityColumn",{label:l,template:new I({src:{path:"",formatter:function(p){if(!p){return null;}return p.visible?m:n;}},tooltip:{path:"",formatter:function(p){if(!p){return null;}return p.visible?t:o;}},height:"1.3em",size:"1.2em",press:function(p){var q=i._tree.getContextByIndex(this.getParent().getIndex());var r=q?q.getObject():null;if(r){i._viewStateManager.setVisibilityState(r.id,!r.visible,false);}}}),width:"2.5em",resizable:false,hAlign:"Center"})],enableSelectAll:false,selectionMode:"MultiToggle",selectionBehavior:"RowSelector",visibleRowCountMode:"Fixed",expandFirstLevel:false,collapseRecursive:false,rowHeight:32});this.setAggregation("treeTable",this._tree);this.attachContentChanged(function(p){l.setSrc(m);l.setTooltip(t);});this._scene=null;this._syncing=false;this._updateSelectionTimer=0;this._updateVisibilityTimer=0;this._model=new J();this._tree.setModel(this._model);this._tree.bindRows({path:"/"});this._tree.attachRowSelectionChange(this._handleRowSelectionChange.bind(this));this._tree.attachFirstVisibleRowChanged(this._updateSelection.bind(this));this._tree.getBinding("rows").attachChange(this._dataChange.bind(this));};
k.prototype.setTitle=function(i){this.setProperty("title",i,true);this._title.setText(i);return this;};
k.prototype.setShowTitle=function(i){this.setProperty("showTitle",i,true);this._title.setVisible(i);this._updateTitleBar();return this;};
k.prototype.setShowSearchField=function(i){this.setProperty("showSearchField",i,true);this._searchField.setVisible(i);this._updateTitleBar();return this;};
k.prototype._updateTitleBar=function(){this._tree.setTitle(this.getShowTitle()||this.getShowSearchField()?this._toolbar:null);this._handleResize();};
k.prototype.onBeforeRendering=function(){this._tree.setVisible(true);if(!this._resizeListenerId){this._resizeListenerId=R.register(this,this._handleResize.bind(this));}};
k.prototype._handleRowSelectionChange=function(l){if(this._syncing||this._tree.getBinding("rows")._aSelectedContexts!=undefined){return;}var s=[];var p=[];var r=l.getParameter("rowIndices");for(var i in r){var q=r[i];var u=this._tree.getContextByIndex(q);var w=u?u.getObject().id:null;if(w){(this._tree.isIndexSelected(q)?s:p).push(w);}}if(s.length>0){this._viewStateManager.setSelectionState(s,true);}if(p.length>0){this._viewStateManager.setSelectionState(p,false);}};
k.prototype._handleSelectionChanged=function(p){if(this._syncing){return;}function q(r,u){var w=r.getBinding("rows");if(w){for(var i=r.getFirstVisibleRow(),l=Math.min(i+r.getVisibleRowCount(),w.getLength());i<l;i++){var x=w.getContextByIndex(i);if(x&&x.getObject().id===u){return true;}}}return false;}var s=p.getParameter("selected");if(s.length===1&&!q(this._tree,s[0])){if(this._updateSelectionTimer>0){clearTimeout(this._updateSelectionTimer);this._updateSelectionTimer=0;}this._expandToNode(s[0],this._updateSelection.bind(this));}else if(this._updateSelectionTimer===0){this._updateSelectionTimer=setTimeout(this._updateSelection.bind(this),0);}};
k.prototype._updateSelection=function(){this._updateSelectionTimer=0;if(this._syncing){return;}this._syncing=true;var p=this._viewStateManager,q=this._tree,r=q.getBinding("rows");if(p&&r){for(var i=q.getFirstVisibleRow(),l=Math.min(i+q.getVisibleRowCount(),r.getLength());i<l;i++){var s=r.getContextByIndex(i);if(s){var u=s.getObject().id;if(u){var w=p.getSelectionState(u);if(w!=q.isIndexSelected(i)){q[w?"addSelectionInterval":"removeSelectionInterval"](i,i);}}}}}this._syncing=false;};
k.prototype._expandToNode=function(i,l){var p={tree:this._tree,rows:this._tree.getBinding("rows"),index:0,nodeRef:i,ancestors:new Set(this._scene.getDefaultNodeHierarchy().getAncestors(i)),callback:l};function s(r,u,w){var x=r.getFirstVisibleRow(),y=r.getVisibleRowCount();if((u<x)||(u>=(x+y))){x=Math.min(Math.max(u-(y>>1),0),w-y);setTimeout(function(){r.setFirstVisibleRow(x);},0);}}function q(p,r){if(r&&r.getParameter("reason")!=="expand"){return;}var u=p.rows.getLength();while(p.index<u){var w=p.rows.getContextByIndex(p.index);if(!w){break;}var i=w.getObject().id;if(i===p.nodeRef){s(p.tree,p.index,u);break;}if(p.ancestors.has(i)&&!p.tree.isExpanded(p.index)){p.tree.expand(p.index++);return;}p.index++;}p.rows.detachChange(p.expandHandlerProxy);p.callback();}p.expandHandlerProxy=q.bind(this,p);p.rows.attachChange(p.expandHandlerProxy);q(p);};
k.prototype._dataChange=function(i){var r=i.getParameter("reason");if((r==="expand"||r==="collapse")&&this._updateSelectionTimer===0){this._updateSelectionTimer=setTimeout(this._updateSelection.bind(this),0);}};
k.prototype._toggleVisibilityForAllChildren=function(l,p){var q=l.hasOwnProperty("children")?l.children:l;for(var i=0;q[i]!=null;i++){this._viewStateManager.setVisibilityState(q[i].id,p,false);}};
k.prototype._handleVisibilityChanged=function(i){if(this._updateVisibilityTimer===0){this._updateVisibilityTimer=setTimeout(this._updateVisibility.bind(this),0);}};
k.prototype._updateVisibility=function(){this._updateVisibilityTimer=0;this._getNodeVisibilityRecursive(this._model.getData());this._tree.getModel().refresh(true);};
k.prototype._getNodeVisibilityRecursive=function(l){if(l.id!=null){l.visible=this._viewStateManager.getVisibilityState(l.id);}var p=l.hasOwnProperty("children")?l.children:l;for(var i=0;p[i]!=null;i++){this._getNodeVisibilityRecursive(p[i]);}};
k.prototype._handleResize=function(i){var l=i?i.size.height:this.getDomRef().clientHeight;var p=this._tree.getTitle()?2.1:1.1;this._tree.setVisibleRowCount(Math.max(Math.floor(l/(this._tree.getRowHeight()+1)-p),0));this._updateSelection();};
k.prototype.refresh=function(){if(!this._scene||!this._viewStateManager||!this._viewStateManager.getNodeHierarchy()){this._model.setData([]);return;}var i=this._scene.getDefaultNodeHierarchy();var l=[];var p=function(l,q){q.forEach(function(r){if(r.userData&&r.userData.skipIt){p(l,i.getChildren(r));}else{var s=i.createNodeProxy(r);var u=this._createNodeForSceneTree(s.getName(),s.getNodeRef(),this._viewStateManager);l.push(u);i.destroyNodeProxy(s);u.children=[];p(u.children,i.getChildren(r));}}.bind(this));}.bind(this);p(l,i.getChildren());this._model.setData(l);this._tree.setModel(this._model);this._tree.bindRows({path:"/",parameters:{arrayNames:["children"]}});this._tree.getBinding("rows").attachChange(this._dataChange.bind(this));this.fireContentChanged();};
k.prototype._onBeforeClearContentConnector=k.prototype._onBeforeClearViewStateManager=function(){this._setScene(null);};k.prototype._onAfterUpdateContentConnector=k.prototype._onAfterUpdateViewStateManager=function(){if(this._contentConnector){this._setContent(this._contentConnector.getContent());}};
k.prototype._setContent=function(i){this._setScene(i);};
k.prototype._handleContentReplaced=function(i){this._setContent(i.getParameter("newContent"));};
k.prototype._handleNodeHierarchyReplaced=function(i){this._setScene(this._scene);};
k.prototype._handleContentChangesFinished=function(i){this.refresh();};
g.injectMethodsIntoClass(k);V.injectMethodsIntoClass(k);return k;});
sap.ui.predefine('sap/ui/vk/SceneTreeRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiSizeCompact");r.addClass("sapUiVkSceneTree");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("treeTable"));r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/vk/SelectionMode',[],function(){"use strict";var S={None:"none",Exclusive:"exclusive",Sticky:"sticky"};return S;},true);
sap.ui.predefine('sap/ui/vk/Smart2DHandler',["sap/ui/base/EventProvider","sap/ui/core/ResizeHandler"],function(E,R){"use strict";
var S=E.extend("sap.ui.vk.Smart2DHandler",{
metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},
constructor:function(v,a){this._viewport=v;this._rect=null;this._x=0;this._y=0;this._gesture=false;this._hitEndTimer=0;this._lastRender=0;this._viewport.attachEvent("resize",this,this._onresize);this._viewStateManager=a;this._previousColoring={nodeRef:null,nodeId:null,color:null};}
});
S.prototype.destroy=function(){this._viewport=null;this._rect=null;this._gesture=false;this._viewport.detachEvent("resize",this,this._onresize);this._viewStateManager=null;this._previousColoring=null;};
S.prototype._getOffset=function(d){var r=d.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
S.prototype._inside=function(e){var v=this._viewport.getDomRef();if(v==null){return false;}var a=this._getOffset(v);this._rect={x:a.x,y:a.y,w:v.offsetWidth,h:v.offsetHeight};return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
S.prototype._onresize=function(e){this._gesture=false;this._rect=null;};
S.prototype.beginGesture=function(e){if(this._inside(e)){this._gesture=true;this._x=e.x;this._y=e.y;}};
S.prototype.callbackHover=function(){var n=this._viewStateManager.getNodeHierarchy();this._lastRender=Date.now();this._hitEndTimer=0;var h=this._viewport.hitTest(this._x,this._y);if(this._highlightedNodeRef!==h){if(this._highlightedNodeRef!==sap.ve.dvl.DVLID_INVALID){var t=this._highlightedNodeRef===this._previousColoring.nodeRef?this._previousColoring.color:0;this._viewport.showHotspots(this._highlightedNodeRef,true,t);}if(n.getHotspotNodeIds().indexOf(h)!==-1){var a=n.createNodeProxy(h);this._previousColoring={nodeRef:h,nodeId:h,color:a.getTintColorABGR()};n.destroyNodeProxy(a);this._viewport.showHotspots(h,true);}this._highlightedNodeRef=h;}this._viewport.renderFrame();};
S.prototype.hover=function(e){if(e.n==1&&this._inside(e)){this._x=e.x-this._rect.x;this._y=e.y-this._rect.y;if(!this.getViewport().getShowAllHotspots()){var t=Date.now();if(t-this._lastRender>20){this.callbackHover();}if(this._hitEndTimer!=0){clearTimeout(this._hitEndTimer);}this._hitEndTimer=setTimeout(this.callbackHover.bind(this),20);}e.handled=true;}};
S.prototype.move=function(e){if(this._gesture&&e.n==1){this._viewport.pan(e.x-this._x,e.y-this._y);this._x=e.x;this._y=e.y;e.handled=true;}};
S.prototype.endGesture=function(e){this._gesture=false;};
S.prototype.click=function(e){};
S.prototype.doubleClick=function(e){};
S.prototype.contextMenu=function(e){};
S.prototype.getViewport=function(){return this._viewport;};
return S;});
sap.ui.predefine('sap/ui/vk/StepNavigation',["jquery.sap.global","sap/ui/core/Control","./library","./Messages","./DvlException","./ContentConnector","./StepNavigationRenderer","./dvl/GraphicsCoreApi","./dvl/getPointer","./dvl/getJSONObject","./dvl/Scene","./getResourceBundle"],function(q,C,v,M,D,a,S,G,g,b,c,d){"use strict";
var f=C.extend("sap.ui.vk.StepNavigation",{metadata:{library:"sap.ui.vk",properties:{settings:"object",width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},showThumbnails:{type:"boolean",group:"Appearance",defaultValue:true},showToolbar:{type:"boolean",group:"Appearance",defaultValue:true},showStepInfo:{type:"boolean",group:"Appearance",defaultValue:false}},publicMethods:["setScene","playStep","pauseStep","playAllSteps","getStep","getNextStep","getPreviousStep","getProceduresAndSteps","refresh","clear"],associations:{contentConnector:{type:"sap.ui.vk.ContentConnector"}},aggregations:{procedureItemTemplate:{type:"sap.ui.core.Item",multiple:false},stepInfoPopup:{type:"sap.ui.core.Control",multiple:false},layout:{type:"sap.m.Toolbar",multiple:false},thumbnailsContainer:{type:"sap.m.ScrollContainer",multiple:false}},events:{"resize":{parameters:{oldSize:"object",size:"object"}},"stepChanged":{parameters:{clientId:"object",type:"object",stepId:"object"}}}}});
f.prototype._onStepEvent=function(p){var s=this.getSettings();this.instanceSettings.currentStepId=p.stepId;switch(p.type){case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_FINISHED:s.currentStepFinished=true;s.currentStepPaused=false;s.playAllActive=false;s.isPlaying=false;this._togglePlayPause(true);break;case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_SWITCHED:case sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_STARTED:s.currentStepId=p.stepId;s.currentStepFinished=false;this._highlightStep(p.stepId);if(s.currentStepPaused){this.pauseStep();}break;default:q.sap.log.error(d().getText(M.VIT12.summary),M.VIT12.code,"sap.ui.vk.StepNavigation");}this.fireStepChanged({clientId:p.clientId,type:p.type,stepId:p.stepId});};
f.prototype.setScene=function(s){if(this._scene){this.oDvl.Client.detachStepEvent(this._onStepEvent,this);this.oDvl=null;}if(s){var e=s.getMetadata().getName();if(e!=="sap.ui.vk.dvl.Scene"){return;}}this._scene=s;this.instanceSettings={};if(this._scene){this.oDvl=s.getGraphicsCore().getApi(G.LegacyDvl);this.oDvl.Client.attachStepEvent(this._onStepEvent,this);}delete this._procedures;var p=this.getProcedureList();var o=this.getSettings();o.reset();p.unbindItems();p.setSelectedItem(p.getFirstItem());if(o.stepInfo.stepMessagePopup){if(!o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}o.stepInfo.stepMessagePopup.destroy();o.stepInfo.stepMessagePopup=null;this.getShowStepInfoButton().setText(d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"));}var i=this._getStepThumbnails();this.oModel.setData(i);this._togglePlayPause(true);this._refreshControl();this.refresh();};
f.prototype.init=function(){this._emptyThumbnail="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";if(C.prototype.init){C.prototype.init.call(this);}if(this.getSettings()==undefined){this.setSettings(new this._settings());}this._scene=null;this.oModel=new sap.ui.model.json.JSONModel();this.setModel(this.oModel);this._layout=new sap.m.Toolbar({design:sap.m.ToolbarDesign.Solid});this.setAggregation("layout",this._layout);if(this.getShowThumbnails()){this._thumbnailsScroller=new sap.m.ScrollContainer(this.getId()+"-scroller",{width:"100%",horizontal:true,vertical:false,focusable:true});this.setAggregation("thumbnailsContainer",this._thumbnailsScroller);}this.playPreviousButton=new sap.m.Button(this.getId()+"-playPreviousButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://slim-arrow-left",tooltip:d().getText("STEP_NAV_PREVIOUSSTEPBUTTON"),press:function(e){var s=this.getSettings();var p=this.getPreviousStep(s.currentProcedureIndex);if(p){s.currentStepPaused=false;this.playStep(p.id,true,s.playAllActive);this._togglePlayPause(false);}}.bind(this)});this.playNextButton=new sap.m.Button(this.getId()+"-playNextButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://slim-arrow-right",tooltip:d().getText("STEP_NAV_NEXTSTEPBUTTON"),press:function(e){var s=this.getSettings();var n=this.getNextStep(s.currentProcedureIndex);if(n){s.currentStepPaused=false;this.playStep(n.id,true,s.playAllActive);this._togglePlayPause(false);}}.bind(this)});this.playOptionButton=new sap.m.Button(this.getId()+"-playOptionButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://media-play",tooltip:d().getText("STEP_NAV_PLAYBUTTON_PLAY"),visible:true,press:function(e){var k=this.getPlayMenuButton().getSelectedKey();var s=this.getSettings();var i=null;switch(k){case"0":if(!s.currentStepId){i=this.getNextStep(s.currentProcedureIndex);if(i){s.currentStepId=i.id;}else{return;}}s.playAllActive=false;this.playStep(s.currentStepId,!s.currentStepPaused,s.playAllActive);s.isPlaying=true;s.currentStepPaused=false;this._togglePlayPause(false);break;case"1":s.playAllActive=true;s.currentStepPaused=false;this.playAllSteps(s.currentProcedureId);s.isPlaying=true;this._togglePlayPause(false);break;case"2":if(!s.currentStepId){i=this.getNextStep(s.currentProcedureIndex);if(i){s.currentStepId=i.id;}else{return;}}s.playAllActive=true;var p=!s.currentStepPaused;s.currentStepPaused=false;this.playStep(s.currentStepId,p,s.playAllActive);s.isPlaying=true;this._togglePlayPause(false);break;default:break;}}.bind(this)});this.procedureList=new sap.m.Select(this.getId()+"-procedureList",{tooltip:d().getText("STEP_NAV_PROCEDURESLISTHEADING"),selectedKey:"0",type:sap.m.SelectType.Default,enabled:true,width:"30%",autoAdjustWidth:true,change:function(o){var p=this.getProcedureList();var s=this.getSettings();s.currentProcedureIndex=0;s.currentProcedureId=this.instanceSettings.currentProcedureId=p.getSelectedKey();s.currentStepId=this.instanceSettings.currentStepId=null;for(var i=0;i<this.oModel.oData.procedures.length;i++){if(this.oModel.oData.procedures[i].id==s.currentProcedureId){s.currentProcedureIndex=i;s.currentProcedure=this.oModel.oData.procedures[i];break;}}if(s.stepInfo.stepMessagePopup){if(!s.stepInfo.stepMessagePopup.isOpen()){s.stepInfo.stepMessagePopup.close();}s.stepInfo.stepMessagePopup.destroy();s.stepInfo.stepMessagePopup=null;}this._refreshItems();}.bind(this)});this.procedureList.addStyleClass("sapVizKitStepNavigationProcedureList");this.setAggregation("procedureItemTemplate",(new sap.ui.core.ListItem().bindProperty("text","name").bindProperty("key","id").bindProperty("tooltip","name")));this.playMenuButton=(new sap.m.Select(this.getId()+"-playMenuButtonIcon",{selectedKey:"0",type:sap.m.SelectType.Default,tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYOPTIONS"),enabled:true,autoAdjustWidth:false,items:[new sap.ui.core.ListItem({key:"0",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAY"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAY")}),new sap.ui.core.ListItem({key:"1",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAYALL"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYALL")}),new sap.ui.core.ListItem({key:"2",icon:"sap-icon://media-play",text:d().getText("STEP_NAV_PLAYMENU_PLAYALLREMAINING"),tooltip:d().getText("STEP_NAV_PLAYMENU_PLAYALLREMAINING")})]}));this.playMenuButton.addStyleClass("sapVizKitStepNavigationPlayOptionsSelect");this.pauseButton=new sap.m.Button(this.getId()+"-pauseButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://media-pause",visible:false,tooltip:d().getText("STEP_NAV_PLAYMENU_PAUSE"),press:function(e){var s=this.getSettings();this.pauseStep();s.currentStepPaused=true;s.isPlaying=false;this._togglePlayPause(true);}.bind(this)});this.showStepInfoButton=new sap.m.ToggleButton(this.getId()+"-showStepInfoButton",{icon:"sap-icon://hide",type:sap.m.ButtonType.Transparent,pressed:false,text:d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"),tooltip:d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"),press:function(e){var t=e.getSource();if(t.getPressed()){this.setShowStepInfo(true);t.setIcon("sap-icon://show");t.setTooltip(d().getText("STEP_NAV_HIDESTEPDESCRIPTIONBUTTON"));}else{this.setShowStepInfo(false);t.setIcon("sap-icon://hide");t.setTooltip(d().getText("STEP_NAV_SHOWSTEPDESCRIPTIONBUTTON"));}}.bind(this)});this._layout.addContent(this.playPreviousButton).addContent(this.playOptionButton).addContent(this.pauseButton).addContent(this.playMenuButton).addContent(this.procedureList).addContent(this.showStepInfoButton).addContent(new sap.m.ToolbarSpacer()).addContent(this.playNextButton);};
f.prototype.destroy=function(){return C.prototype.destroy.call(this);};
f.prototype.getScroller=function(){return this._thumbnailsScroller;};
f.prototype.getProcedureList=function(){var i=this.getId()+"-procedureList";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getPlayMenuButton=function(){var i=this.getId()+"-playMenuButtonIcon";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getPlayOptionButton=function(){var i=this.getId()+"-playOptionButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getPauseButton=function(){var i=this.getId()+"-pauseButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getPlayNextButton=function(){var i=this.getId()+"-playNextButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getPlayPreviousButton=function(){var i=this.getId()+"-playPreviousButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype.getShowStepInfoButton=function(){var i=this.getId()+"-showStepInfoButton";var e=this._layout;var j=sap.ui.getCore().byId(i);return e.getContent()[e.indexOfContent(j)];};
f.prototype._settings=function(){return{enabled:false,toggle:{addCss:function(k,p,o,e){if(!this.targets[k]){this.targets[k]={"type":"css","property":p,"onValue":o,"offValue":e};}},addMethod:function(t,m,o,e,u){var k=t.getId();if(!this.targets[k]){this.targets[k]={"type":"method","target":t,"method":m,"onValue":o,"offValue":e,"useJQuery":u};}},targets:{}},currentProcedureIndex:0,currentProcedureId:"",currentProcedure:null,currentStepId:null,currentStep:null,currentStepPaused:false,isPlaying:false,currentStepFinished:true,playAllActive:false,showToolbar:true,showThumbnails:true,portfolioMode:false,reset:function(){this.currentStep=null;this.currentProcedure=null;this.currentProcedureIndex=0;this.currentProcedureId="";this.currentStepId=null;this.currentStepPaused=false;this.currentStepFinished=true;this.playAllActive=false;this.portfolioMode=false;},stepInfo:{lastTop:null,lastLeft:null,stepMessagePopup:null,openPopup:function(p,t,e,i){this._customHeaderText=this._customHeaderText||new sap.m.Text({width:"100%",textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapVizKitStepNavigationPopoverTitle");this._customHeaderText.setText(p);this._customHeaderText.setTooltip(p);this._customHeader=this._customHeader||new sap.m.Bar({contentLeft:[this._customHeaderText]});this._textContent=this._textContent||new sap.m.Text({});this._textContent.addStyleClass("sapVizKitStepNavigationPopoverContent");this._textContent.setText(t);this.stepMessagePopup=this.stepMessagePopup||new sap.m.ResponsivePopover({placement:i,showCloseButton:true,verticalScrolling:true,contentHeight:"10%",contentWidth:"30%",content:[this._textContent],customHeader:this._customHeader});this.stepMessagePopup.addStyleClass("sapVizKitStepNavigationPopoverStepInfo");this.stepMessagePopup.openBy(e);}}};};
f.prototype.refresh=function(s){q.sap.log.info("StepNavigation refresh() called.");if(this.getVisible()&&(this["_getStepThumbnails"]&&this._scene!=null)){var p=this.getProcedureList();var o=this.getSettings();o.reset();p.setSelectedItem(p.getFirstItem());var e=this._getStepThumbnails();if(o.stepInfo.stepMessagePopup){if(!o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}o.stepInfo.stepMessagePopup.destroy();o.stepInfo.stepMessagePopup=null;}this.oModel.setData(e);this._togglePlayPause(true);this._refreshControl();}else if(this.getVisible()){this._refreshControl();}return true;};
f.prototype.clear=function(){q.sap.log.info("StepNavigation clear() called.");return true;};
f.prototype.onBeforeRendering=function(){if(this.getShowToolbar()){var p=this.getProcedureList();p.setModel(this.oModel);var P=this.getProcedureItemTemplate();p.bindItems("/procedures",P);}};
f.prototype.onAfterRendering=function(){var s=this.getSettings();this._togglePlayPause(!s.isPlaying);if(s.currentStepId){this._highlightStep(s.currentStepId);}};
var h={onAfterRendering:function(e){e.srcControl.focus();e.srcControl.removeEventDelegate(this);}};
f.prototype._togglePlayPause=function(p){this.togglePlayPauseActive=true;if(this.getSettings().showToolbar){var e=this.getPlayOptionButton(),i=this.getPauseButton();if(p){if(sap.ui.getCore().getCurrentFocusedControlId()===i.getId()){e.addEventDelegate(h);}i.setVisible(false);e.setVisible(true);}else{if(sap.ui.getCore().getCurrentFocusedControlId()===e.getId()){i.addEventDelegate(h);}e.setVisible(false);i.setVisible(true);}}};
f.prototype._refreshControl=function(){if(!this.oModel.oData.procedures){return;}var p=this.getProcedureList();var P=this.getProcedureItemTemplate();var s=this.getSettings();if(s.stepInfo.stepMessagePopup){if(!s.stepInfo.stepMessagePopup.isOpen()){s.stepInfo.stepMessagePopup.close();}s.stepInfo.stepMessagePopup.destroy();s.stepInfo.stepMessagePopup=null;this.getShowStepInfoButton().setText(d().getText("STEP_NAV_STEPDESCRIPTIONHEADING"));}p.unbindItems();if(this.oModel.oData.procedures.length>0){var e=this.oModel.oData.procedures[0];if(this.getShowToolbar()){p.bindItems("/procedures",P);p.selectedKey=e.id;p.enabled=true;}this._refreshItems();}else{if(this.getShowToolbar()){p.bindItems("/procedures",P);p.enabled=false;}if(this.getShowThumbnails()){var o=this.getScroller();o.destroyContent();}}};
f.prototype._refreshItems=function(){var t=this;var s=[];var p=this.getProcedureList();var o=t.getSettings();var e=new sap.m.HBox();if(!o.currentProcedure){o.currentProcedure=t.oModel.oData.procedures[o.currentProcedureIndex];p.setSelectedItem(p.getFirstItem());}if(o.currentProcedureId!=""||t.oModel.oData.procedures.length>0){if(t.getShowThumbnails()){var j=t.getScroller();j.removeAllContent();s=t.oModel.oData.procedures[o.currentProcedureIndex].steps;var k=function(n){o.currentStepPaused=false;var r=sap.ui.getCore().byId(n.getSource().getId());t.playStep(r.getCustomData()[0].getValue("stepId"));o.playAllActive=false;t._togglePlayPause(false);};var l=function(n){var r=80;var m=n.getSource();var u=m.getDomRef().width;var w=m.getDomRef().height;var x=u/w;if(u>w){m.setWidth(r+"px");m.setHeight(r/x+"px");}else{m.setHeight(r+"px");m.setWidth(r*x+"px");}};for(var i=0;i<s.length;i++){var m=new sap.m.Image({alt:s[i].name,src:"data:image/"+s[i].thumbnailType+";base64,"+s[i].thumbnailData,densityAware:false,tooltip:s[i].name,press:k.bind(t),load:l,layoutData:new sap.m.FlexItemData({shrinkFactor:0})});m.data("stepId",s[i].id);m.addCustomData(new sap.ui.core.CustomData({key:"stepId",value:s[i].id}));m.addStyleClass("sapVizKitStepNavigationStepItem");e.addItem(m);}j.addContent(e);}}};
f.prototype._getPopupPlacement=function(e){var p=null;var y=0;while(e){y+=e.offsetTop;e=e.offsetParent;}if(y>200){p=sap.m.PlacementType.Top;}else{p=sap.m.PlacementType.Bottom;}return p;};
f.prototype._isScrollingNecessary=function(i,s){var e;if(i&&s){var j=q(i).offset().left+q(i).width();var t=q(s).width();if(j-q(i).width()<0){e=true;}else if((t-j)<q(i).width()){e=true;}else{e=false;}}else{e=false;}return e;};
f.prototype._scrollToItem=function(i,s){var p={},o=q(i).offset(),e=q(s).scrollLeft();p.scrollLeft=o.left+(e-q(s).offset().left);p.scrollLeft-=parseInt(q(i).css("marginLeft"),10)||0;p.scrollLeft-=parseInt(q(i).css("borderLeftWidth"),10)||0;q(s).animate(p,50);};
f.prototype._highlightStep=function(s){var t=this;if(t.getVisible()){var o=t.getSettings();var e=t.getStep(0,o.currentProcedureIndex,s);if(!o.currentProcedure){o.currentProcedure=t.oModel.oData.procedures[t.oSettings.currentProcedureIndex];}var j=t.getShowStepInfoButton();var p;var k=document.getElementById(j.getId());p=t._getPopupPlacement(k);if(t.getShowStepInfo()){o.stepInfo.openPopup.call(this,e.name,e.description,j,p);}else if(o.stepInfo.stepMessagePopup&&o.stepInfo.stepMessagePopup.isOpen()){o.stepInfo.stepMessagePopup.close();}if(t.getShowThumbnails()){var l=t.getScroller();var T=l.getContent()[0].getItems();for(var i=0;i<T.length;i++){if(T[i].getCustomData()[0].getValue("stepId")==s){T[i].addStyleClass("selected");if(t._isScrollingNecessary(T[i].$()[0],q("#"+l.sId)[0])){t._scrollToItem(T[i].$()[0],q("#"+l.sId)[0]);}}else{T[i].removeStyleClass("selected");}}}}};
f.prototype.getProceduresAndSteps=function(){return this._getStepThumbnails();};
f.prototype._getStepThumbnails=function(){var p=function(s,i,j){var t,k,l;try{var m=i.Scene.RetrieveThumbnail(s,j.id);if(m===sap.ve.dvl.DVLRESULT.NOTFOUND){t=this._emptyThumbnail;}else{t=g(m);}l=t.substring(0,3);if(l==="iVB"){k="png";}else{k="jpg";}j.thumbnailData=t;j.thumbnailType=k;}catch(n){if(n.code!==sap.ve.dvl.DVLRESULT.NOTFOUND){q.sap.log.error(n.message,n.code,"sap.ui.vk.StepNavigation");}j.thumbnailData=null;j.thumbnailType=null;}};var e=this._retrieveProcedures();if(e.sceneId!=null){e.procedures.forEach(function(i){i.steps.forEach(p.bind(this,e.sceneId,this.oDvl));},this);e.portfolios.forEach(function(i){i.steps.forEach(p.bind(this,e.sceneId,this.oDvl));},this);e.hasThumbnails=true;}this._procedures=e;return e;};
f.prototype._retrieveProcedures=function(i){var t=this;var p={};if(!t._procedures){p={sceneId:null,hasThumbnails:false,"procedures":[],"portfolios":[]};}else{p=t._procedures;}if(t._scene&&(p.sceneId!=(i||t._scene._dvlSceneRef))){var s=i||t._scene._dvlSceneRef;if(s!=null){p={sceneId:null,hasThumbnails:false,"procedures":[],"portfolios":[]};try{var j=b(t.oDvl.Scene.RetrieveProcedures(s));if(j!=null){p.hasThumbnails=false;p.sceneId=t._scene._dvlSceneRef;p.procedures=j.procedures;p.portfolios=j.portfolios;}}catch(e){if(!(e instanceof D&&e.code===sap.ve.dvl.DVLRESULT.NOTIMPLEMENTED)){throw e;}}}}return p;};
f.prototype.getStep=function(r,e,s){var t=this;var i=t.oDvl.Settings.LastLoadedSceneId;var j=null;if(i!=null){e=e!=null?e:0;var k=s?s:t.instanceSettings.currentStepId;var p=t._retrieveProcedures(i);var l=p.procedures[e];if(l&&l.steps.length>0){j=l.steps[0];}else{return null;}if(k!=""){for(var m=0;m<l.steps.length;m++){var _=l.steps[m];if(_.id==k){var x=m+r;if(x<l.steps.length&&x>=0){j=l.steps[x];}else{j=null;}break;}}}}return j;};
f.prototype.pauseStep=function(){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;if(s!=null){t.oDvl.Scene.PauseCurrentStep(s);}};
f.prototype._stepCount=function(e){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;var i=0;if(s!=null){var p=t._retrieveProcedures(s);for(var j=0;j<p.procedures.length;j++){if(p.procedures[j].id==e){i=p.procedures[j].steps.length;break;}else if(e==null){i+=p.procedures[j].steps.length;}}}return i;};
f.prototype.getPreviousStep=function(p){var t=this;return t.getStep(-1,p);};
f.prototype.getNextStep=function(p){var t=this;return t.getStep(1,p);};
f.prototype.playStep=function(e,i,j){var t=this;var s=t.oDvl.Settings.LastLoadedSceneId;if(s!=null){t.instanceSettings.currentStepId=e;t.oDvl.Scene.ActivateStep(s,e,i!=null?i:true,j!=null?j:false);}};
f.prototype.playAllSteps=function(p){var t=this;var e=t.oDvl.Settings.LastLoadedSceneId;if(e!=null){var i=t._retrieveProcedures(e);var j=0;if(p!=null&&i.procedures.length>1){for(var k=0;k<i.procedures.length;k++){if(i.procedures[k].id==p){j=k;break;}}}if(i.procedures.length>0){var s=i.procedures[j].steps[0];if(s){t.instanceSettings.currentStepId=s.id;t.oDvl.Scene.ActivateStep(e,s.id,true,true);}}}};
f.prototype._setContent=function(e){var s=null;if(e&&e instanceof c){s=e;}this.setScene(s);};
f.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
f.prototype._onBeforeClearContentConnector=function(){this.setScene(null);};
f.prototype._handleContentReplaced=function(e){var i=e.getParameter("newContent");this._setContent(i);};
a.injectMethodsIntoClass(f);return f;});
sap.ui.predefine('sap/ui/vk/StepNavigationRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){if(!c.getVisible()){return;}if(c.getShowToolbar()||c.getShowThumbnails){var w=c.getWidth()!=="auto"?c.getWidth():"100%";var h=c.getHeight()!=="auto"?c.getHeight():"auto";r.write("<div");r.addStyle("width",w);r.addStyle("height",h);r.writeControlData(c);r.addClass("sapVizKitStepNavigation");r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(!c.getVisible()){r.addStyle("visibility","hidden");}r.writeStyles();r.write(">");r.renderControl(c.getAggregation("layout"));if(c.getShowThumbnails()){S._renderScrollerDiv(r,c);}r.write("</div>");}};
S._renderScrollerDiv=function(r,c){r.renderControl(c.getAggregation("thumbnailsContainer"));};
return S;},true);
sap.ui.predefine('sap/ui/vk/Texture',["sap/ui/base/ManagedObject"],function(M){"use strict";
var T=M.extend("sap.ui.vk.Texture",{metadata:{properties:{"id":{type:"string"},"filterMode":{type:"int",defaultValue:0},"uvRotationAngle":{type:"float",defaultValue:0.0},"uvHorizontalOffset":{type:"float",defaultValue:0.0},"uvVerticalOffset":{type:"float",defaultValue:0.0},"uvHorizontalScale":{type:"float",defaultValue:0.0},"uvVerticalScale":{type:"float",defaultValue:0.0},"uvHorizontalTilingEnabled":{type:"bloolean",defaultValue:true},"uvVerticalTilingEnabled":{type:"bloolean",defaultValue:true}}}});
T.prototype.load=function(i){return this;};
T.prototype.getTextRef=function(){return null;};
return T;});
sap.ui.predefine('sap/ui/vk/Toolbar',["./library","sap/ui/core/Control","./ToolbarRenderer","./getResourceBundle"],function(v,C,T,g){"use strict";
var a=C.extend("sap.ui.vk.Toolbar",{metadata:{library:"sap.ui.vk",properties:{title:{type:"string",group:"Appearance",defaultValue:""}},events:{},associations:{viewer:{type:"sap.ui.vk.Viewer",cardinality:"0..1"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"content",forwardBinding:true}},_toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_helpButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_stepNavigationButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_sceneTreeButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_enterFullScreenButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_exitFullScreenButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_toolbarTitle:{type:"sap.m.Title",multiple:false,visibility:"hidden"}}}});
a.prototype._getToolbar=function(){return this._toolbar;};
a.prototype._onSceneTree=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){this.oViewer._componentsState.sceneTree.userInteractionShow=this._sceneTreeButton.getPressed();this.oViewer.setShowSceneTree(this.oViewer._componentsState.sceneTree.userInteractionShow);}};
a.prototype._onStepNavigation=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){this.oViewer._componentsState.stepNavigation.userInteractionShow=this._stepNavigationButton.getPressed();this.oViewer.setShowStepNavigation(this.oViewer._componentsState.stepNavigation.userInteractionShow);}};
a.prototype._onFullScreen=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer!=null){var n=this._enterFullScreenButton.getPressed();this.oViewer.activateFullScreenMode(n);}};
a.prototype._fullScreenHandler=function(e){var f=e.mParameters.isFullScreen;this._enterFullScreenButton.setPressed(f);if(f){this._enterFullScreenButton.setIcon("sap-icon://exit-full-screen");}else{this._enterFullScreenButton.setIcon("sap-icon://full-screen");}};
a.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this);}var _=new sap.m.Button({icon:"sap-icon://sys-help",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_HELPBUTTONTOOLTIP")});this.setAggregation("_helpButton",_);this._stepNavigationButton=new sap.m.ToggleButton({icon:"sap-icon://step",type:sap.m.ButtonType.Transparent,enabled:false,tooltip:g().getText("STEP_NAV_MENUBUTTONTOOLTIP"),press:this._onStepNavigation.bind(this)});this.setAggregation("_stepNavigationButton",this._stepNavigationButton);this._sceneTreeButton=new sap.m.ToggleButton({icon:"sap-icon://tree",type:sap.m.ButtonType.Transparent,tooltip:g().getText("SCENETREE_MENUBUTTONTOOLTIP"),press:this._onSceneTree.bind(this)});this.setAggregation("_sceneTreeButton",this._sceneTreeButton);this._toolbarTitle=new sap.m.Title();this.setAggregation("_toolbarTitle",this._toolbarTitle);this._enterFullScreenButton=new sap.m.ToggleButton({icon:"sap-icon://full-screen",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_FULLSCREENBUTTONTOOLTIP"),press:this._onFullScreen.bind(this)});this.setAggregation("_enterFullScreenButton",this._enterFullScreenButton);var b=new sap.m.Button({icon:"sap-icon://exit-full-screen",type:sap.m.ButtonType.Transparent,tooltip:g().getText("VIEWER_FULLSCREENBUTTONTOOLTIP")});this.setAggregation("_exitFullScreenButton",b);var t=t=[new sap.m.ToolbarSpacer(),this._toolbarTitle,new sap.m.ToolbarSpacer(),new sap.m.ToolbarSeparator(),this._sceneTreeButton,new sap.m.ToolbarSeparator(),this._stepNavigationButton,new sap.m.ToolbarSeparator(),this._enterFullScreenButton];this._toolbar=new sap.m.Toolbar({design:sap.m.ToolbarDesign.Solid,content:t});this.setAggregation("_toolbar",this._toolbar,true);};
a.prototype.exit=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());if(this.oViewer){this.oViewer.detachFullScreen(this._fullScreenHandler.bind(this));}};
a.prototype.onBeforeRendering=function(){this._toolbar.setVisible(true);this._toolbarTitle.setText(this.getTitle());};
a.prototype.refresh=function(){this.oViewer=sap.ui.getCore().byId(this.getViewer());this._stepNavigationButton.setPressed(this.oViewer.getShowStepNavigation());this._stepNavigationButton.setEnabled(this.oViewer.getEnableStepNavigation());this._sceneTreeButton.setPressed(this.oViewer.getShowSceneTree());this._sceneTreeButton.setEnabled(this.oViewer.getEnableSceneTree());this.oViewer.attachFullScreen(this._fullScreenHandler.bind(this));return true;};
a.prototype.onAfterRendering=function(){this.refresh();};
return a;});
sap.ui.predefine('sap/ui/vk/ToolbarRenderer',[],function(){"use strict";var T={};
T.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitToolbar");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_toolbar"));r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/vk/TransformationMatrix',["jquery.sap.global","sap/ui/base/DataType"],function(q,D){"use strict";var T=D.getType("float[]");
T.parseValue=function(v){var c=T.getComponentType();return v.split(/\s*,\s*|\s+/).map(c.parseValue.bind(c));};
T.convertTo4x4=function(a){var m=a;return[m[0],m[1],m[2],0,m[3],m[4],m[5],0,m[6],m[7],m[8],0,m[9],m[10],m[11],1];};
T.convertTo4x3=function(a){var m=a;return[m[0],m[1],m[2],m[4],m[5],m[6],m[8],m[9],m[10],m[12],m[13],m[14]];};
return T;},true);
sap.ui.predefine('sap/ui/vk/View',["sap/ui/base/ManagedObject"],function(M){"use strict";
var V=M.extend("sap.ui.vk.View",{metadata:{library:"sap.ui.vk",properties:{name:{type:"string"},description:{type:"string"},cameraInfo:{type:"object"},nodeInfos:{type:"object[]"},playbacks:{type:"object[]"}}}});
return V;});
sap.ui.predefine('sap/ui/vk/ViewGallery',["sap/ui/core/Control","./library","./ContentConnector","./AnimationTimeSlider","./ViewGalleryRenderer","./getResourceBundle","./ViewGalleryThumbnail","sap/m/HBox","sap/m/VBox","sap/m/FormattedText","sap/m/FlexItemData","sap/m/Image","sap/m/ScrollContainer","sap/m/Button","sap/m/ToggleButton","sap/m/Toolbar","sap/m/Popover","sap/m/Title","sap/m/SelectList","sap/m/ToolbarSpacer","sap/ui/model/json/JSONModel","sap/ui/core/dnd/DropInfo","sap/ui/core/dnd/DragInfo"],function(C,v,a,A,V,g,b,H,c,F,d,I,S,B,T,e,P,f,h,j,J,D,k){"use strict";
var l=C.extend("sap.ui.vk.ViewGallery",{metadata:{library:"sap.ui.vk",properties:{showAnimationTimeSlider:{type:"boolean",defaultValue:true},showToolbar:{type:"boolean",defaultValue:true},showThumbnailContainer:{type:"boolean",defaultValue:true},selectedViewIndex:{type:"int",defaultValue:-1},selectedViewGroupIndex:{type:"int",defaultValue:-1},enableViewReordering:{type:"boolean",defaultValue:false}},associations:{viewport:{type:"sap.ui.vk.Viewport"},contentConnector:{type:"sap.ui.vk.ContentConnector"}},aggregations:{toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},container:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},animationTimeSlider:{type:"sap.ui.vk.AnimationTimeSlider",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{item:"sap.ui.core.Control"}},viewOrderChange:{parameters:{view:"sap.ui.vk.View",viewIndex:"int"}}}}});
l.prototype.init=function(){if(C.prototype.init){C.prototype.init.call(this);}var t=this;window.addEventListener("resize",function(){t.resizeToolbarSpacer();},true);this._scene=null;this._viewItems=[];this._cdsLoader=null;this._selectedGroupIndex=-1;this._previousOrientationVertical=false;this._playingAnimation=true;this._draggedModelView={};sap.ui.core.IconPool.addIcon("landscape-text","vk-icons","vk-icons","e019");sap.ui.core.IconPool.addIcon("portrait-text","vk-icons","vk-icons","e01a");this.oModel=new J();if(this.getShowThumbnailContainer()){this.createThumbnailContainer();}if(this.getShowToolbar()){this.createToolbar();}if(this.getShowAnimationTimeSlider()){this.setAggregation("animationTimeSlider",new A());if(this.getViewport()){var i=sap.ui.getCore().byId(this.getViewport());this._linkViewportAndAnimationTimeSlider(i,this.getAnimationTimeSlider());}}};
l.prototype.setVisible=function(i){if(C.prototype.setVisible){C.prototype.setVisible.call(this,i);}this.setDescription();};
l.prototype.resizeToolbarSpacer=function(){if(this.getDomRef()){var i=this._nextItemButton.getDomRef().getBoundingClientRect().width;i+=this._playButton.getDomRef().getBoundingClientRect().width;i+=this._previousItemButton.getDomRef().getBoundingClientRect().width;var t=this.toolbar.getDomRef().getBoundingClientRect().width;var w=(i/t)*100;var n=50-w;this._toolbarSpacer.setWidth(n+"%");}};
l.prototype.onAfterRendering=function(){this.resizeToolbarSpacer();var i=null;if(this.getViewport()){i=sap.ui.getCore().byId(this.getViewport());if(i.getContent().indexOf(this)!==-1){this.toolbar.addStyleClass("sapVizKitViewGalleryToolbar");this.adjustStepDescriptionBoxes();}}};
l.prototype.setShowAnimationTimeSlider=function(i){this.setProperty("showAnimationTimeSlider",i);var n=null;if(this.getViewport()){n=sap.ui.getCore().byId(this.getViewport());}if(i){this._deLinkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());this.setAggregation("animationTimeSlider",new A());this._linkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());}else{this._deLinkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());this.destroyAggregation("animationTimeSlider");}};
l.prototype.getAnimationTimeSlider=function(){return this.getAggregation("animationTimeSlider");};
l.prototype.destroyToolbar=function(){this.destroyAggregation("toolbar");};
l.prototype.destroyThumbnailContainer=function(){this.destroyAggregation("container");};
l.prototype.createThumbnailContainer=function(){var t=this;this._hbox=new H();if(this.getEnableViewReordering()){this._hbox.addDragDropConfig(new D({dropEffect:sap.ui.core.dnd.DropEffect.Move,dropPosition:sap.ui.core.dnd.DropPosition.On,targetAggregation:"items",drop:function(E){var i=E.getParameter("droppedControl");t.reorderViews(i);t.fireViewOrderChange({view:t._draggedModelView,viewIndex:t._viewItems.indexOf(i)});}}));this._hbox.getMetadata().getAggregation().dnd.droppable=true;}this._scrollContainer=new S(this.getId()+"-scroller",{width:"100%",horizontal:true,vertical:false,focusable:true,content:[this._hbox]});this._scrollContainer.addStyleClass("sapVizKitViewGalleryScrollContainer");this.setAggregation("container",this._scrollContainer);};
l.prototype.reorderViews=function(i){var n=this._modelViews.indexOf(this._draggedModelView);this._modelViews.splice(n,1);var o=this._viewItems.indexOf(i);this._modelViews.splice(o,0,this._draggedModelView);this._refreshItems();};
l.prototype.createToolbar=function(){var t=this;this.toolbar=new e({design:sap.m.ToolbarDesign.Solid});this.setAggregation("toolbar",this.toolbar);this._previousItemButton=new B(this.getId()+"-previousItemButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://close-command-field",tooltip:g().getText("STEP_NAV_PREVIOUSSTEPBUTTON"),press:function(n){var i=t.getSelectedViewIndex();if(i>0){t.setSelectedItem(t._viewItems[i-1]);}}});this._nextItemButton=new B(this.getId()+"-nextItemButton",{type:sap.m.ButtonType.Transparent,icon:"sap-icon://open-command-field",tooltip:g().getText("STEP_NAV_NEXTSTEPBUTTON"),press:function(n){var i=t.getSelectedViewIndex();if(i>=0&&i+1<t._viewItems.length){t.setSelectedItem(t._viewItems[i+1]);}}});this._viewGroupSelector=new P({showHeader:false,contentWidth:"20%",placement:sap.m.PlacementType.Top,horizontalScrolling:false,verticalScrolling:false,content:[new S({horizontal:false,vertical:true,content:[this._procedureList=new h({width:"100%",itemPress:function(o){t._clearUI();var i=this.indexOfItem(o.getParameter("item"));t.setSelectedViewGroupIndex(i);}})]})]});this._playButton=new T(this.getId()+"-playButton",{type:sap.m.ButtonType.Transparent,pressed:false,icon:"sap-icon://media-play",visible:true,tooltip:g().getText("STEP_NAV_PLAYMENU_PLAY"),press:function(E){this._setPlayState(E.getSource().getPressed());if(E.getSource().getPressed()){this._playProcedure();}else{this._pauseAnimation();}}.bind(this)});this._stepCount=new f({textAlign:sap.ui.core.TextAlign.Right,level:"H5",titleStyle:"H5"});this._currentGroupTitle=new f({text:g().getText("STEP_NAV_PROCEDURES"),tooltip:g().getText("STEP_NAV_PROCEDURES"),level:"H5",titleStyle:"H5"}).addStyleClass("sapVizKitViewGalleryCurrentGroupTitle");this._separatorTitle=new f({width:(5/1920)*100+"%",level:"H5",titleStyle:"H5"});this._currentStepTitle=new f({level:"H5",titleStyle:"H5"}).addStyleClass("sapVizKitViewGalleryCurrentStepTitle");this._currentGroupTitle.addEventDelegate({ontap:function(){this._viewGroupSelector.openBy(this._currentGroupTitle);}.bind(this)});this._toolbarSpacer=new j();this.toolbar.addContent(this._currentGroupTitle).addContent(this._separatorTitle).addContent(this._currentStepTitle).addContent(new j()).addContent(this._stepCount).addContent(this._toolbarSpacer).addContent(this._previousItemButton).addContent(this._playButton).addContent(this._nextItemButton);};
l.prototype._setPlayState=function(i){if(this.getAggregation("toolbar")){this._playButton.setPressed(i);if(i){this._playButton.setIcon("sap-icon://media-pause");this._playButton.setTooltip(g().getText("STEP_NAV_PLAYMENU_PAUSE"));}else{this._playButton.setIcon("sap-icon://media-play");this._playButton.setTooltip(g().getText("STEP_NAV_PLAYMENU_PLAY"));}}};
l.prototype._createStepDescriptionBoxes=function(){this._stepDescription=new c({renderType:sap.m.FlexRendertype.Bare,fitContainer:false,alignContent:sap.m.FlexAlignContent.Start,alignItems:sap.m.FlexAlignItems.Start,justifyContent:sap.m.FlexJustifyContent.End,items:[this._stepDescriptionToolbar=new e({design:sap.m.ToolbarDesign.Solid,content:[this._stepDescriptionIcon=new sap.ui.core.Icon({src:"sap-icon://navigation-up-arrow",press:function(i){this._toggleViewDescription();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionIcon sapVizKitViewGalleryStepDescriptionIconTransform"),new j(),this._stepDescriptionOrientationIcon=new sap.ui.core.Icon({src:"sap-icon://vk-icons/landscape-text",press:function(i){this._toggleOrientation();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionOrientationIcon")],layoutData:new d({shrinkFactor:0})}).addStyleClass("sapVizKitViewGalleryStepDescriptionToolbar"),this._stepDescriptionScroll=new S({horizontal:false,vertical:true,content:[this._stepDescriptionText=new F({visible:true}).addStyleClass("sapVizKitViewGalleryStepDescriptionText")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionScroll")]}).addStyleClass("sapVizKitViewGalleryStepDescription");this._stepDescription.vitId="VIT-StepDescription";this._stepDescriptionVertical=new H({renderType:sap.m.FlexRendertype.Bare,fitContainer:false,alignContent:sap.m.FlexAlignContent.Start,alignItems:sap.m.FlexAlignItems.Start,justifyContent:sap.m.FlexJustifyContent.End,items:[this._stepDescriptionVerticalScroll=new S({horizontal:false,vertical:true,content:[this._stepDescriptionVerticalText=new F({visible:false}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalText")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalScroll"),this._stepDescriptionVerticalToolbar=new e({design:sap.m.ToolbarDesign.Solid,content:[this._stepDescriptionVerticalIcon=new sap.ui.core.Icon({src:"sap-icon://navigation-right-arrow",press:function(i){this._toggleViewDescriptionVertical();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalIcon sapVizKitViewGalleryStepDescriptionIconTransform"),this._stepDescriptionVerticalOrientationIcon=new sap.ui.core.Icon({src:"sap-icon://vk-icons/portrait-text",press:function(i){this._toggleOrientation();}.bind(this)}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalOrientationIcon")],layoutData:new d({shrinkFactor:0})}).addStyleClass("sapVizKitViewGalleryStepDescriptionVerticalToolbar")]}).addStyleClass("sapVizKitViewGalleryStepDescriptionVertical");this._stepDescriptionVertical.vitId="VIT-StepDescriptionVertical";};
l.prototype.adjustStepDescriptionBoxes=function(){if(this._stepDescription.getDomRef()){var i=this.getDomRef().getBoundingClientRect().height;var s=this._stepDescription.getDomRef().id;var n=this._stepDescriptionVertical.getDomRef().id;document.getElementById(s).style.bottom=i+"px";document.getElementById(n).style.bottom=i+"px";var o=sap.ui.getCore().byId(this.getViewport());var p=o.getDomRef().getBoundingClientRect().height;document.getElementById(n).style.height=p-i+"px";}};
l.prototype._toggleOrientation=function(){if(this._stepDescriptionToolbar.getVisible()){this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(true);this._previousOrientationVertical=true;if(this._stepDescriptionText.getVisible()){this._stepDescriptionVerticalText.setVisible(true);}this._stepDescriptionText.setVisible(false);}else{this._stepDescriptionToolbar.setVisible(true);this._previousOrientationVertical=false;if(this._stepDescriptionVerticalText.getVisible()){this._stepDescriptionText.setVisible(true);}this._stepDescriptionVerticalToolbar.setVisible(false);this._stepDescriptionVerticalText.setVisible(false);}this._stepDescription.rerender();this._stepDescriptionVertical.rerender();var i=null;if(this.getViewport()){i=sap.ui.getCore().byId(this.getViewport());if(i.getContent().indexOf(this)!==-1){this.adjustStepDescriptionBoxes();}}};
l.prototype._toggleViewDescription=function(){if(!this._stepDescriptionText.getVisible()){this._stepDescriptionText.setVisible(true);this._stepDescriptionIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionVerticalIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}else{this._stepDescriptionText.setVisible(false);this._stepDescriptionIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionVerticalIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}this._stepDescriptionText.rerender();};
l.prototype._toggleViewDescriptionVertical=function(){if(!this._stepDescriptionVerticalText.getVisible()){this._stepDescriptionVerticalText.setVisible(true);this._stepDescriptionVerticalIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionIcon.addStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}else{this._stepDescriptionVerticalText.setVisible(false);this._stepDescriptionVerticalIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");this._stepDescriptionIcon.removeStyleClass("sapVizKitViewGalleryStepDescriptionIconTransform");}this._stepDescriptionVerticalText.rerender();};
l.prototype._getHBox=function(){return this._hbox;};
l.prototype._playProcedure=function(){if(this._modelViews){var i=sap.ui.getCore().byId(this.getViewport());var s=this.getSelectedViewIndex();if(s===-1){s=0;}i.playProcedure(this._modelViews,s,!this._playingAnimation);}};
l.prototype._pauseAnimation=function(){var i=sap.ui.getCore().byId(this.getViewport());i.pauseAnimation();};
l.prototype.setPlayingAnimation=function(p){this._playingAnimation=p;};
l.prototype.setScene=function(s){if(s&&s.getSceneRef()===this._scene){return;}if(s&&s.loaders){for(var i=0;i<s.loaders.length;i++){var n=s.loaders[i];if(n&&n.getMetadata&&n.getMetadata().getName()==="sap.ui.vk.threejs.ContentDeliveryService"){this._cdsLoader=n;this._cdsLoader.detachLoadingFinished(this._handleCdsViewGroupUpdate,this);this._cdsLoader.attachLoadingFinished(this._handleCdsViewGroupUpdate,this);break;}}}this._scene=s?s.getSceneRef():null;this._refreshProcedures();};
l.prototype.setViewport=function(n){if(this.getViewport()){var o=sap.ui.getCore().byId(this.getViewport());this._deLinkViewportAndAnimationTimeSlider(o,this.getAnimationTimeSlider());}this.setAssociation("viewport",n,true);if(n){var t=this;n.attachViewActivated(function(q){var r=q.getParameter("viewIndex");var s=q.getParameter("view");if(t._viewportGroups&&t._viewportGroups.length>0){var u=t._viewportGroups[t.getSelectedViewGroupIndex()];if(u&&u.originalId!=s.viewGroupId){for(var i=0;i<t._viewportGroups.length;i++){if(t._viewportGroups[i].originalId===s.viewGroupId){t.setSelectedViewGroupIndex(i,r);break;}}}else{t.viewActivated(r,s);}}});n.attachProcedureFinished(function(i){t._setPlayState(false);});n.attachViewFinished(function(i){t._setPlayState(false);});if(n.getContent()){var p=function(q){var r=n.getContent();for(var i=0;i<r.length;i++){if(r[i].vitId==q){return i;}}};n.removeContent(p("VIT-StepDescription"));n.removeContent(p("VIT-StepDescriptionVertical"));}this._createStepDescriptionBoxes();n.addContent(this._stepDescription);n.addContent(this._stepDescriptionVertical);this._linkViewportAndAnimationTimeSlider(n,this.getAnimationTimeSlider());}};
l.prototype._linkViewportAndAnimationTimeSlider=function(i,n){if(!i||!n){return;}if(i._implementation){i=i._implementation;}i.attachAnimationStarted(n.handleAnimationStarted,n);i.attachAnimationFinished(n.handleAnimationFinished,n);i.attachAnimationUpdated(n.handleAnimationUpdated,n);n.attachChange(i.handleCompleteDraggingAnimation,i);n.attachLiveChange(i.handleDragAnimation,i);};
l.prototype._deLinkViewportAndAnimationTimeSlider=function(i,n){if(!i||!n){return;}if(i._implementation){i=i._implementation;}i.detachAnimationStarted(n.handleAnimationStarted,n);i.detachAnimationFinished(n.handleAnimationFinished,n);i.detachAnimationUpdated(n.handleAnimationUpdated,n);n.detachChange(i.handleCompleteDraggingAnimation,i);n.detachLiveChange(i.handleDragAnimation,i);};
l.prototype._refreshProcedures=function(i){if(this.getAggregation("toolbar")){this._procedureList.removeAllItems();}this._viewportGroups=null;this._modelViews=null;if(this._scene&&this._scene.userData){this._viewportGroups=this._scene.userData.viewportGroups;if(this._viewportGroups&&this._viewportGroups.length>0){this._selectedGroupIndex=0;var n=0;this._viewportGroups.forEach(function(o){o.id=THREE.Math.generateUUID();if(this.getAggregation("toolbar")){this._procedureList.addItem(new sap.ui.core.Item({key:o.id,text:o.name}));}if(i&&o.originalId===i){this._selectedGroupIndex=n;}n++;}.bind(this));this._modelViews=this._viewportGroups[this._selectedGroupIndex].modelViews;if(this.getAggregation("toolbar")){this._currentGroupTitle.setText(this._viewportGroups[0].name).setTooltip(this._viewportGroups[0].name);}}else if(this.getAggregation("toolbar")){this._currentGroupTitle.setText(g().getText("STEP_NAV_PROCEDURES"));}}this._refreshItems();};
l.prototype.refresh=function(s){this.setScene(s);};
var m="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAE4AAAA8CAYAAADIQIzXAAAACXBIWXMAAAsTAAALEwEAmpwYAAAFFmlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS42LWMxNDAgNzkuMTYwNDUxLCAyMDE3LzA1LzA2LTAxOjA4OjIxICAgICAgICAiPiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgeG1sbnM6cGhvdG9zaG9wPSJodHRwOi8vbnMuYWRvYmUuY29tL3Bob3Rvc2hvcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZUV2ZW50IyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ0MgKE1hY2ludG9zaCkiIHhtcDpDcmVhdGVEYXRlPSIyMDE4LTA2LTA1VDEzOjU1OjAzKzEyOjAwIiB4bXA6TW9kaWZ5RGF0ZT0iMjAxOC0wNi0wNVQxNDowMDo1MCsxMjowMCIgeG1wOk1ldGFkYXRhRGF0ZT0iMjAxOC0wNi0wNVQxNDowMDo1MCsxMjowMCIgZGM6Zm9ybWF0PSJpbWFnZS9wbmciIHBob3Rvc2hvcDpDb2xvck1vZGU9IjMiIHBob3Rvc2hvcDpJQ0NQcm9maWxlPSJzUkdCIElFQzYxOTY2LTIuMSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDoyNGZiYjQ5MS1mNzFkLTRmMTgtODA2Zi1iYjcxZjhhZTdhNjAiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MjRmYmI0OTEtZjcxZC00ZjE4LTgwNmYtYmI3MWY4YWU3YTYwIiB4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ9InhtcC5kaWQ6MjRmYmI0OTEtZjcxZC00ZjE4LTgwNmYtYmI3MWY4YWU3YTYwIj4gPHhtcE1NOkhpc3Rvcnk+IDxyZGY6U2VxPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0iY3JlYXRlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNGZiYjQ5MS1mNzFkLTRmMTgtODA2Zi1iYjcxZjhhZTdhNjAiIHN0RXZ0OndoZW49IjIwMTgtMDYtMDVUMTM6NTU6MDMrMTI6MDAiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCBDQyAoTWFjaW50b3NoKSIvPiA8L3JkZjpTZXE+IDwveG1wTU06SGlzdG9yeT4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6QcBQiAAAGO0lEQVR4nO2ca1MbRxaGn+6emR7dzMUEOxRbla04H+LE+f+/YlO1oWIiA8IGhGQZJCSkkeZ28mEsOxtYRxoGIVx6vwip5tI8OrfuPho1DuIzoMZK82igxkEsDz2KxygNDB56EI9QA/3QI3isWoHLqRW4nHLmOdgYg1IgX0E6USp7TZKUNJVP72fVXOCiKEJEUPPeZUklIhhj0Hp+Y5gJnFIKx9EcHBxzeXmJtTbPOJdKIkIcx7x48QObm0+YTJK5zp/b4iaTyVw3WFZNwaVpmuv8uWOc4zg4zlynLaXko2/mDTuFEJBHki2KjM13AqeUIkkSoiieOystUiKgtcJ13cKueSdwYRiyvr7O8+fPiOMUWE7LM8YQBAHNZhMoxvLuBC5JYqz12dhcyz5YTm6gYDQscXZ2lr19aHBTV5UUoihd2ljneYYwDAu95mrKlVMrcDn1qAqyLDtqXFehFCQJxPF8FX9RWig4EXAcgzFZTJx3cu2XDEkMvd6AJEkol8uUKx5xJMRxutCSaGHgRMB1DXGcMByOqVQqwOwJxfMMve6Ak5MTrq+vSdMUz/PY2dnh22+f4zh6ofAWEuNEwPUMIsL+/mt+/fU/XF1d4Vk906qEtYbBYMje3h69Xg/HcbDWEscx9Xqdw6MG2ii0XpzJ3Ts4ETBGYwy8e3dCt9vFdV0ajSPCMMH3zUzwWq0WaZpSLpc/1WGu61KplGm3WvS6fTxvcbnu3u+ktcL1FCfvzmk2m1QqFXzfZzwOqP9RJ0kEx/n/w8iq/pjB4BrP8264ttYGgPE4gAXGuHsH51lN67zD4eEBruugtUZE8P0SnU6Hs7NzHFfNYHVfPmDRtfe9gRMB6xtGw5Dj4wbWWhzH+R+LKZVKtFrnBMMQv3S7y6Zpil9yqFSqhGF4Y7qUpsmnay1yyncv4ESy0mE0GrO3t0eayq1u5rouURSx/8c+cZTieTfhiQgI7O7u4jgOo9GIKaE4jhmNRuzu7rKx8YQwzLcomUeFgxMRrG9IYuH17/tMJmOstbeWHZnL+vT7VzQax2jDrZkxDBOqVZ+XL3+kVqsxmYSMx2OUUnz//Qu+++5fJImQposzuULruKxWc1AK3rw5ZDgcUqlUvliriQjlcoV2u8Xm5lOebq0xDpIb9dhkkrC+8YSfq6/o9XrEcUy1WqVa84lCIUkecQFsjMI4cFA/pt1u/SO0qbTWGGM4OjqkWv0Fax0mk5vwxkGCMZqtrXVQkCYwGWcxbtELqYW6qutpTk/anDVPKZfLM58nInieJQgCDg+PUCqr/f4upbJkMR4nRKGgTZaArG8+Zusi/5svqzBwntVcXlzx9m0D31q0nu/SmcuW6XTec3raxvXUjSwpkq0B+iWD1ormWZs39SPety/QOvvccWYrqO+qQlxVabgeBNTr9WwP1nVzLWoqpbDWcnr6ls3NDcoVj3GQuaIxOoMJdN5f0GyeMxj0SdOUdrvN2toaW99ssbmxiV9yQCCKJPf23z+psBg3HI6I4xjf93OvBIsIrusSBAEHB2/46eeXWGtQGpIYPnS6dD50uPhwkVmeX0IphYjQ7/fpdrtUq1W2t7+hVntCpVLF2vuxwMLAGWMwxty5RUJEKJVK9Ho9Dg8avPjh33x43+X8vEm/n7Xy2Y+hQEQ+fUnT7oIwDGk0jnEch1KpxM7ODtvbTwtv21jKhczP8Lr89t8R19dDIKv5/nrMbZpumIsIl5eXKKXYfva08DEuJTjISpQ0TRmNRnieO7fFTOOl53n3Mr6lBTd1+SI3kYvUarMmp1bgcmoFLqdW4HJqBS6nCsuqItn0Jk3TpekRno7nPlQYuCms7HU5wEGxzYR/VQHgsoHVajVevfplaawNPneVQ/Ff5Z3AZUVq9rfnGaw/+xrcwjSdmRW8WX0ncJ5nGQz6vP69vrS9cfC5j08pVZhH3AmcMYYoihiNRkvlon+XiHzsclqSHuDpgL6GH4zMq1Udl1MzW5xS2SJhEIyWOp7NKhEhiqKszssRZWYGlyTC9vYzarUaxiztatQcygp23/dJcvy6Xo2DuM8MDzMQEax1UF+Zc+fczB7M4aqKMHyYftv7Vp6C4Cuzn8VpBS6nVuByavXAlpxygCarRwTNq8GfDrbV1CI5dZUAAAAASUVORK5CYII=";
l.prototype._clearUI=function(){if(this.getAggregation("toolbar")){this._currentStepTitle.setText("");this._separatorTitle.setText("");this._viewGroupSelector.close();this._nextItemButton.setEnabled(false);this._previousItemButton.setEnabled(false);this._stepCount.setText("");this._stepDescriptionText.setHtmlText("");this._stepDescriptionVerticalText.setHtmlText("");}if(this.getAggregation("container")){this._hbox.removeAllItems();}this._viewItems=[];this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(false);};
l.prototype._refreshItems=function(){this._clearUI();var t=this;if(this._modelViews){var p=function(i){this.setSelectedItem(i.getSource());}.bind(this);this._modelViews.forEach(function(n){var o=true;var q=n.name||n.getName&&n.getName();var r=new b({alt:q,densityAware:false,tooltip:q,viewGallery:this,source:n.thumbnailData||m,press:function(i){r.detachBrowserEvent("mouseenter",function(i){t.startAnimate();});r.setSource(n.thumbnailData||m);clearInterval(i.getSource().interval);p(i);},layoutData:new d({shrinkFactor:0})});var s=function(u,w){var y=u.width/w;var z=u.height;var E=w;var G=z;var K=document.createElement("canvas");var L=K.getContext("2d");var M=[];K.width=E;K.height=G;for(var i=0;i<y;i++){var x=E*i;L.clearRect(0,0,E,G);L.drawImage(u,x,0,E,G,0,0,E,G);M.push(K.toDataURL());}t.startAnimate=function(){if(o){o=false;r.detachBrowserEvent("mouseenter",function(O){t.startAnimate();});var i=0;var N=function(){if(i<y){r.setSource(M[i]);i++;}else{r.setSource(M[0]);i=0;}};r.interval=setInterval(function(){N();},250);}};r.attachBrowserEvent("mouseenter",function(N){t.startAnimate();});r.attachBrowserEvent("mouseout",function(N){o=true;r.attachBrowserEvent("mouseenter",function(N){t.startAnimate();});clearInterval(r.interval);r.setSource(n.thumbnailData);});};if(n.animatedThumbnailData!==undefined){var u=document.createElement("img");u.onload=function(){s(u,n.tileWidth);};u.src=n.animatedThumbnailData;}if(this.getEnableViewReordering()){r.addDragDropConfig(new k({dragStart:function(){t._draggedModelView=n;}}));r.getMetadata().dnd.draggable=true;}r.data("modelView",n);this._viewItems.push(r);if(this.getAggregation("container")){this._hbox.addItem(r);}}.bind(this));this.rerender();}};
l.prototype.setSelectedItem=function(i){var n=sap.ui.getCore().byId(this.getViewport());if(n&&i.getCustomData().length>0){var o=i.getCustomData()[0].getValue();n.activateView(o,!this._playingAnimation);}return this;};
l.prototype.setDescription=function(){if(!this._selectedItem){return;}if(!this.getVisible()){this._stepDescription.setVisible(false);this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVertical.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(false);return;}var i=sap.ui.getCore().byId(this.getViewport());if(i&&this._selectedItem.getCustomData().length>0){var n=this._selectedItem.getCustomData()[0].getValue();var o=n.getDescription();if(o){if(this._previousOrientationVertical===false){this._stepDescription.setVisible(true);this._stepDescriptionToolbar.setVisible(true);this._stepDescriptionVerticalToolbar.setVisible(false);}else{this._stepDescriptionVertical.setVisible(true);this._stepDescriptionToolbar.setVisible(false);this._stepDescriptionVerticalToolbar.setVisible(true);this._previousOrientationVertical=true;}}else if(this._previousOrientationVertical===true){this._stepDescriptionVertical.setVisible(false);}else{this._stepDescription.setVisible(false);this._previousOrientationVertical=false;}if(o!=null){this._stepDescriptionText.setHtmlText(o);this._stepDescriptionVerticalText.setHtmlText(o);}}};
l.prototype.viewActivated=function(i){if(this._selectedItem){if(this.getSelectedViewIndex()!==i){this._selectedItem.removeStyleClass("selected");}}this._selectedItem=this._viewItems[i];if(!this._selectedItem){return this;}if(this.getAggregation("toolbar")){var t=g().getText("VIEWS_TITLE_WITH_COUNT",[i+1,this._viewItems.length]);this._stepCount.setText(t);this._previousItemButton.setEnabled(this._selectedItem!==this._viewItems[0]&&this._viewItems.length>1);this._nextItemButton.setEnabled(this._selectedItem!==this._viewItems[this._viewItems.length-1]&&this._viewItems.length>1);this._setPlayState(true);}this._selectedItem.addStyleClass("selected");if(this._isScrollingNecessary(this._selectedItem.getDomRef(),this._scrollContainer.getDomRef())){this._scrollContainer.scrollToElement(this._selectedItem,500);}var n=sap.ui.getCore().byId(this.getViewport());if(n&&this._selectedItem.getCustomData().length>0){var o=this._selectedItem.getCustomData()[0].getValue();var p=o.getPlaybacks();var s=this.getAnimationTimeSlider();if(s){if(!p){s.setEnabled(false);s.setValue(0);}else{s.setEnabled(true);}}var q=o.name||o.getName&&o.getName();if(this.getAggregation("toolbar")){this._separatorTitle.setText("/");this._currentStepTitle.setText(q).setTooltip(q);}}this.setDescription();this.fireSelectionChange({item:this._selectedItem});return this;};
l.prototype.getSelectedItem=function(){return this._selectedItem;};
l.prototype.getSelectedViewIndex=function(){for(var n=0;n<this._viewItems.length;n++){if(this._viewItems[n]===this.getSelectedItem()){return n;}}return-1;};
l.prototype.setSelectedViewIndex=function(i){if(this._viewItems.length>i){this.setSelectedItem(this._viewItems[i]);}};
l.prototype.getSelectedViewGroupIndex=function(){return this._selectedGroupIndex;};
l.prototype.setSelectedViewGroupIndex=function(i,n){if(this._viewportGroups&&this._viewportGroups.length>i){this._selectedGroupIndex=i;if(n==null){n=0;}this._currentGroupTitle.setText(this._viewportGroups[i].name).setTooltip(this._viewportGroups[i].name);this._separatorTitle.setVisible(true);this._modelViews=this._viewportGroups[i].modelViews;if((!this._modelViews||this._modelViews.length===0)&&this._cdsLoader){var o=this._viewportGroups[i].originalId;var s=this._viewportGroups[i].sceneId;var t=this;this._cdsLoader.loadViewGroup(s,o).then(function(p){t._viewportGroups[i].modelViews=p;t._modelViews=p;t._refreshItems();t.setSelectedViewIndex(n);});}else{this._refreshItems();this.setSelectedViewIndex(n);}}};
l.prototype._isScrollingNecessary=function(i,s){if(i&&s){var r=i.getBoundingClientRect();return r.left<0||r.right>s.clientWidth;}return false;};
l.prototype._setContent=function(o){var p=o&&o.getMetadata&&o.getMetadata().getName()==="sap.ui.vk.threejs.Scene";this.setScene(p?o:null);if(p&&o.builders){for(var i=0;i<o.builders.length;i++){o.builders[i]._fireThumbnailLoaded=function(r){var s=null;for(var n=0;n<this._viewItems.length;n++){if(this._viewItems[n].data("modelView")==r.modelView){s=this._viewItems[n];break;}}if(s){s.setSource(r.modelView.thumbnailData);}}.bind(this);}}if(this.getViewport()){var q=sap.ui.getCore().byId(this.getViewport());this._linkViewportAndAnimationTimeSlider(q,this.getAnimationTimeSlider());}};
l.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
l.prototype._handleContentChangesStarted=function(){if(this.getViewport()){var o=sap.ui.getCore().byId(this.getViewport());this._deLinkViewportAndAnimationTimeSlider(o,this.getAnimationTimeSlider());}this.setScene(null);};
l.prototype._handleContentReplaced=function(i){var n=i.getParameter("newContent");this._setContent(n);};
l.prototype._handleCdsViewGroupUpdate=function(n){var o=n.getParameter("currentViewGroupId");if(this._modelViews&&this._modelViews.length){this._refreshItems();}else{this._refreshProcedures(o);}if(this.getViewport()){var p=sap.ui.getCore().byId(this.getViewport());var q=p.getCurrentView();if(q&&q.userData&&q.userData.viewInfo&&this._viewItems){for(var i=0;i<this._viewItems.length;i++){var r=this._viewItems[i];var s=r.getCustomData()[0].getValue();if(s&&s.userData&&s.userData.viewInfo&&s.userData.viewInfo.viewId===q.userData.viewInfo.viewId){this.viewActivated(i);break;}}}}};
a.injectMethodsIntoClass(l);return l;});
sap.ui.predefine('sap/ui/vk/ViewGalleryRenderer',[],function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c.getAggregation("animationTimeSlider"));r.renderControl(c.getAggregation("toolbar"));r.renderControl(c.getAggregation("container"));r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/ViewGalleryThumbnailRenderer',["./library","sap/ui/Device"],function(l,D){"use strict";var V={};
V.render=function(r,i){r.write("<div ");r.writeControlData(i);r.addStyle("height",i.getThumbnailHeight());r.addStyle("width",i.getThumbnailWidth());r.addStyle("background-image","url("+i.getSource()+")");r.writeStyles();r.addClass("sapVizKitViewGalleryThumbnail");r.writeClasses();var t=i.getTooltip();if(t){r.attr("title",t);}r.write(">");var a=i._getIndex()+1;if(a>0){r.write("<div class='sapVizKitViewGalleryStepNumberText'>");r.writeEscaped(a.toString());r.write("</div>");}r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/ViewStateManager',["jquery.sap.global","sap/base/util/ObjectPath","sap/ui/core/Element","./ContentConnector","./Scene","./ViewStateManagerBase","./Core"],function(q,O,E,C,S,V,v){"use strict";
var a=V.extend("sap.ui.vk.ViewStateManager",{metadata:{}});
var b=a.getMetadata().getParent().getClass().prototype;
a.prototype.init=function(){if(b.init){b.init.call(this);}this._implementation=null;};
a.prototype.exit=function(){this._destroyImplementation();if(b.exit){b.exit.call(this);}};
a.prototype._destroyImplementation=function(){if(this._implementation){this._implementation.destroy();this._implementation=null;}return this;};
a.prototype.getImplementation=function(){return this._implementation;};
a.prototype._setContent=function(c){var s=null;if(c&&c instanceof S){s=c;}this._setScene(s);};
a.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
a.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};
a.prototype._handleContentReplaced=function(e){this._setContent(e.getParameter("newContent"));};
a.prototype._setScene=function(s){if(s&&s instanceof S){var c=s.getMetadata().getName(),i=this._implementation&&this._implementation.getMetadata().getName(),r=c==="sap.ui.vk.dvl.Scene"&&i==="sap.ui.vk.dvl.ViewStateManager"||c==="sap.ui.vk.threejs.Scene"&&i==="sap.ui.vk.threejs.ViewStateManager";if(!r){this._destroyImplementation();var n;if(c==="sap.ui.vk.dvl.Scene"){n="sap.ui.vk.dvl.ViewStateManager";}else if(c==="sap.ui.vk.threejs.Scene"){n="sap.ui.vk.threejs.ViewStateManager";}if(n){var t=this;var d=O.get(n);this._implementation=new d({shouldTrackVisibilityChanges:this.getShouldTrackVisibilityChanges(),recursiveSelection:this.getRecursiveSelection(),contentConnector:this.getContentConnector(),visibilityChanged:function(e){t.fireVisibilityChanged({visible:e.getParameter("visible"),hidden:e.getParameter("hidden")});},selectionChanged:function(e){t.fireSelectionChanged({selected:e.getParameter("selected"),unselected:e.getParameter("unselected")});},opacityChanged:function(e){t.fireOpacityChanged({changed:e.getParameter("changed"),opacity:e.getParameter("opacity")});},tintColorChanged:function(e){t.fireTintColorChanged({changed:e.getParameter("changed"),tintColor:e.getParameter("tintColor"),tintColorABGR:e.getParameter("tintColorABGR")});},nodeHierarchyReplaced:function(e){t.fireNodeHierarchyReplaced({oldNodeHierarchy:e.getParameter("oldNodeHierarchy"),newNodeHierarchy:e.getParameter("newNodeHierarchy")});}});}}}else{this._destroyImplementation();}return this;};
a.prototype.getNodeHierarchy=function(){return this._implementation&&this._implementation.getNodeHierarchy();};
a.prototype.getVisibilityChanges=function(){return this._implementation&&this._implementation.getVisibilityChanges();};
a.prototype.getVisibilityComplete=function(){return this._implementation&&this._implementation.getVisibilityComplete();};
a.prototype.getVisibilityState=function(n){return this._implementation&&this._implementation.getVisibilityState(n);};
a.prototype.setVisibilityState=function(n,c,r){if(this._implementation){this._implementation.setVisibilityState(n,c,r);}return this;};
a.prototype.resetVisibility=function(){return this._implementation&&this._implementation.resetVisibility();};
a.prototype.enumerateSelection=function(c){if(this._implementation){this._implementation.enumerateSelection(c);}return this;};
a.prototype.setShowSelectionBoundingBox=function(c){if(this._implementation){this._implementation.setShowSelectionBoundingBox(c);}};
a.prototype.getShowSelectionBoundingBox=function(){if(this._implementation){return this._implementation.getShowSelectionBoundingBox();}};
a.prototype.getSelectionState=function(n){return this._implementation&&this._implementation.getSelectionState(n);};
a.prototype.setSelectionState=function(n,s,r){if(this._implementation){this._implementation.setSelectionState(n,s,r);}return this;};
a.prototype.setSelectionStates=function(s,u,r){if(this._implementation){this._implementation.setSelectionStates(s,u,r);}return this;};
a.prototype.getOpacity=function(n){return this._implementation&&this._implementation.getOpacity(n);};
a.prototype.setOpacity=function(n,o,r){if(this._implementation){this._implementation.setOpacity(n,o,r);}return this;};
a.prototype.getTintColor=function(n,i){return this._implementation&&this._implementation.getTintColor(n,i);};
a.prototype.setTintColor=function(n,t,r){if(this._implementation){this._implementation.setTintColor(n,t,r);}return this;};
a.prototype.setHighlightColor=function(c){if(this._implementation&&this._implementation.setHighlightColor){this._implementation.setHighlightColor(c);}return this;};
a.prototype.getHighlightColor=function(i){if(this._implementation&&this._implementation.getHighlightColor){return this._implementation.getHighlightColor(i);}};
a.prototype.setRecursiveSelection=function(p){this.setProperty("recursiveSelection",p,true);if(this._implementation){this._implementation.setRecursiveSelection(p);}return this;};
var f=a.getMetadata().getName();var m={init:function(){this._viewStateManager=null;v.attachEvent(f+"-created",this._handleViewStateManagerCreated,this).attachEvent(f+"-destroying",this._handleViewStateManagerDestroying,this);},exit:function(){this.setViewStateManager(null);v.detachEvent(f+"-destroying",this._handleViewStateManagerDestroying,this).detachEvent(f+"-created",this._handleViewStateManagerCreated,this);},setViewStateManager:function(c){this.setAssociation("viewStateManager",c,true);this._updateViewStateManager();return this;},_updateViewStateManager:function(){var n=this.getViewStateManager(),c=n&&sap.ui.getCore().byId(n)||null;if(this._viewStateManager!==c){this._clearViewStateManager();if(c){if(this._handleNodeHierarchyReplaced){c.attachNodeHierarchyReplaced(this._handleNodeHierarchyReplaced,this);}if(this._handleVisibilityChanged){c.attachVisibilityChanged(this._handleVisibilityChanged,this);}if(this._handleSelectionChanged){c.attachSelectionChanged(this._handleSelectionChanged,this);}if(this._handleOpacityChanged){c.attachOpacityChanged(this._handleOpacityChanged,this);}if(this._handleTintColorChanged){c.attachTintColorChanged(this._handleTintColorChanged,this);}this._viewStateManager=c;if(this._onAfterUpdateViewStateManager){this._onAfterUpdateViewStateManager();}}}return this;},_clearViewStateManager:function(){if(this._viewStateManager){if(this._onBeforeClearViewStateManager){this._onBeforeClearViewStateManager();}if(this._handleTintColorChanged){this._viewStateManager.detachTintColorChanged(this._handleTintColorChanged,this);}if(this._handleOpacityChanged){this._viewStateManager.detachOpacityChanged(this._handleOpacityChanged,this);}if(this._handleSelectionChanged){this._viewStateManager.detachSelectionChanged(this._handleSelectionChanged,this);}if(this._handleVisibilityChanged){this._viewStateManager.detachVisibilityChanged(this._handleVisibilityChanged,this);}if(this._handleNodeHierarchyReplaced){this._viewStateManager.detachNodeHierarchyReplaced(this._handleNodeHierarchyReplaced,this);}this._viewStateManager=null;}return this;},_handleViewStateManagerCreated:function(e){if(this.getViewStateManager()===e.getParameter("object").getId()){this._updateViewStateManager();}},_handleViewStateManagerDestroying:function(e){if(this.getViewStateManager()===e.getParameter("object").getId()){this._clearViewStateManager();}}};
a.injectMethodsIntoClass=function(c){var p=c.prototype,i=p.init,e=p.exit;p.init=function(){if(i){i.call(this);}m.init.call(this);};p.exit=function(){m.exit.call(this);if(e){e.call(this);}};p.setViewStateManager=m.setViewStateManager;p._updateViewStateManager=m._updateViewStateManager;p._clearViewStateManager=m._clearViewStateManager;p._handleViewStateManagerCreated=m._handleViewStateManagerCreated;p._handleViewStateManagerDestroying=m._handleViewStateManagerDestroying;};
v.registerClass(a);C.injectMethodsIntoClass(a);return a;});
sap.ui.predefine('sap/ui/vk/ViewStateManagerBase',["sap/ui/core/Element","./ContentConnector","./Scene"],function(E,C,S){"use strict";
var V=E.extend("sap.ui.vk.ViewStateManagerBase",{metadata:{"abstract":true,properties:{shouldTrackVisibilityChanges:{type:"boolean",defaultValue:false},recursiveSelection:{type:"boolean",defaultValue:false}},associations:{contentConnector:{type:"sap.ui.vk.ContentConnector"}},events:{visibilityChanged:{parameters:{visible:{type:"any[]"},hidden:{type:"any[]"}},enableEventBubbling:true},selectionChanged:{parameters:{selected:{type:"any[]"},unselected:{type:"any[]"}},enableEventBubbling:true},opacityChanged:{parameters:{changed:{type:"any[]"},opacity:{type:"float"}},enableEventBubbling:true},tintColorChanged:{parameters:{changed:{type:"any[]"},tintColor:{type:"sap.ui.core.CSSColor"},tintColorABGR:{type:"int"}},enableEventBubbling:true},nodeHierarchyReplaced:{parameters:{oldNodeHierarchy:{type:"sap.ui.vk.NodeHierarchy"},newNodeHierarchy:{type:"sap.ui.vk.NodeHierarchy"}}},highlightColorChanged:{parameters:{highlightColor:{type:"sap.ui.core.CSSColor"},highlightColorABGR:{type:"int"}},enableEventBubbling:true}}}});
return V;});
sap.ui.predefine('sap/ui/vk/ViewerRenderer',[],function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitViewer");r.writeClasses();if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getHeight()){r.addStyle("height",c.getHeight());}r.writeStyles();r.write(">");r.renderControl(c._layout);r.renderControl(c._progressIndicator);r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/Viewport',["jquery.sap.global","sap/base/util/ObjectPath","./ViewportBase","./ContentConnector","./ViewStateManager","./ViewportRenderer","./VisibilityMode","./RenderMode","./Scene","./Camera"],function(q,O,V,C,a,b,c,R,S,d){"use strict";
var e=V.extend("sap.ui.vk.Viewport",{metadata:{library:"sap.ui.vk",designtime:"sap/ui/vk/designtime/Viewport.designtime"}});
var f=e.getMetadata().getParent().getClass().prototype;
e.prototype.init=function(){if(f.init){f.init.call(this);}this._implementation=null;};
e.prototype.exit=function(){this._destroyImplementation();if(f.exit){f.exit.call(this);}};
e.prototype.getImplementation=function(){return this._implementation;};
e.prototype._destroyImplementation=function(){if(this._implementation){this._implementation.destroy();this._implementation=null;}return this;};
e.prototype.getShowDebugInfo=function(){if(this._implementation){return this._implementation.getShowDebugInfo();}return f.getShowDebugInfo.call(this);};
e.prototype.setShowDebugInfo=function(v){f.setShowDebugInfo.call(this,v);if(this._implementation){this._implementation.setShowDebugInfo(v);}return this;};
e.prototype.getBackgroundColorTop=function(){if(this._implementation){return this._implementation.getBackgroundColorTop();}return f.getBackgroundColorTop.call(this);};
e.prototype.setBackgroundColorTop=function(v){f.setBackgroundColorTop.call(this,v);if(this._implementation){this._implementation.setBackgroundColorTop(v);}return this;};
e.prototype.getBackgroundColorBottom=function(){if(this._implementation){return this._implementation.getBackgroundColorBottom();}return f.getBackgroundColorBottom.call(this);};
e.prototype.setBackgroundColorBottom=function(v){f.setBackgroundColorBottom.call(this,v);if(this._implementation){this._implementation.setBackgroundColorBottom(v);}return this;};
e.prototype.setWidth=function(v){f.setWidth.call(this,v);if(this._implementation){this._implementation.setWidth(v);}return this;};
e.prototype.setHeight=function(v){f.setHeight.call(this,v);if(this._implementation){this._implementation.setHeight(v);}return this;};
e.prototype.setSelectionMode=function(v){f.setSelectionMode.call(this,v);if(this._implementation){this._implementation.setSelectionMode(v);}return this;};
e.prototype.getSelectionMode=function(){if(this._implementation){return this._implementation.getSelectionMode();}return f.getSelectionMode.call(this);};
e.prototype.setCamera=function(v){f.setCamera.call(this,v);if(this._implementation){this._implementation.setCamera(v);return this;}return this;};
e.prototype.getCamera=function(){if(this._implementation){return this._implementation.getCamera();}return f.getCamera.call(this);};
e.prototype.setShouldRenderFrame=function(){if(this._implementation){this._implementation.setShouldRenderFrame();}return this;};
e.prototype.shouldRenderFrame=function(){if(this._implementation){this._implementation.shouldRenderFrame();}};
e.prototype.setRenderMode=function(v){if(this._implementation&&this._implementation.setRenderMode){this._implementation.setRenderMode(v);}return this;};
e.prototype.getRenderMode=function(){if(this._implementation&&this._implementation.getRenderMode){return this._implementation.getRenderMode();}return R.Default;};
e.prototype.setFreezeCamera=function(v){f.setFreezeCamera.call(this,v);if(this._implementation){this._implementation.setFreezeCamera(v);}return this;};
e.prototype.showHotspots=function(n,l,m){if(this._implementation&&this._implementation.showHotspots){this._implementation.showHotspots(n,l,m);}return this;};
e.prototype.addTool=function(t){this.addAssociation("tools",t);if(this._implementation){this._implementation.addTool(t);}};
e.prototype.removeTool=function(t){this.removeAssociation("tools",t);if(this._implementation){this._implementation.removeTool(t);}};
e.prototype.getTools=function(){if(this._implementation){return this._implementation.getTools();}return this.getAssociation("tools",[]);};
e.prototype.removeAllTools=function(){this.removeAllAssociation("tools");if(this._implementation){this._implementation.removeAllTools();}};
e.prototype.addContent=function(l){if(this._implementation){this._implementation.addContent(l);}else{this.addAggregation("content",l);}};
e.prototype.removeContent=function(l){if(this._implementation){this._implementation.removeContent(l);}else{this.removeAggregation("content",l);}};
e.prototype.getContent=function(){if(this._implementation){return this._implementation.getContent();}return this.getAggregation("content");};
e.prototype.removeAllContent=function(){if(this._implementation){this._implementation.removeAllContent();}else{this.removeAggregation("content");}};
e.prototype.startAnimation=function(p){if(this._implementation&&this._implementation.startAnimation){this._implementation.startAnimation(p);}};
e.prototype.stopAnimation=function(){if(this._implementation&&this._implementation.stopAnimation){this._implementation.stopAnimation();}};
e.prototype.playProcedure=function(m,v,n){if(this._implementation&&this._implementation.playProcedure){this._implementation.playProcedure(m,v,n);}};
e.prototype.activateView=function(v,n){if(this._implementation&&this._implementation.activateView){this._implementation.activateView(v,n);}};
e.prototype.getCurrentView=function(){if(this._implementation&&this._implementation.getCurrentView){return this._implementation.getCurrentView();}return null;};
e.prototype.pan=function(l,m){if(this._implementation&&this._implementation.pan){this._implementation.pan(l,m);}};
e.prototype.rotate=function(l,m){if(this._implementation&&this._implementation.rotate){this._implementation.rotate(l,m);}};
e.prototype.zoom=function(l){if(this._implementation&&this._implementation.zoom){this._implementation.zoom(l);}};
e.prototype.pauseAnimation=function(){if(this._implementation&&this._implementation.pauseAnimation){return this._implementation.pauseAnimation();}};
e.prototype.resumeAnimation=function(){if(this._implementation&&this._implementation.resumeAnimation){return this._implementation.resumeAnimation();}};
e.prototype.handleDragAnimation=function(l){if(this._implementation&&this._implementation.handleDragAnimation){this._implementation.handleDragAnimation(l);}};
e.prototype.handleCompleteDraggingAnimation=function(l){if(this._implementation&&this._implementation.handleCompleteDraggingAnimation){this._implementation.handleCompleteDraggingAnimation(l);}};
e.prototype.AddHandlersToAnimationSequenceEvents=function(l){if(this._implementation&&this._implementation.AddHandlersToAnimationSequenceEvents){this._implementation.AddHandlersToAnimationSequenceEvents(l);}};
e.prototype._setContent=function(l){var m=null;var n=null;if(l){m=l;if(!(m instanceof S)){m=null;}n=l.camera;if(!(n instanceof d)){n=null;}}this._setScene(m);if(n){this.setCamera(n);}};
e.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
e.prototype._onBeforeClearContentConnector=function(){if(f._onBeforeClearContentConnector){f._onBeforeClearContentConnector.call(this);}this._setScene(null);};
e.prototype._handleContentReplaced=function(l){var m=l.getParameter("newContent");this._setContent(m);};
e.prototype._setScene=function(l){if(l instanceof S){var m=l.getMetadata().getName(),n=this._implementation&&this._implementation.getMetadata().getName(),r=m==="sap.ui.vk.dvl.Scene"&&n==="sap.ui.vk.dvl.Viewport"||m==="sap.ui.vk.threejs.Scene"&&n==="sap.ui.vk.threejs.Viewport";if(!r){this._destroyImplementation();var o;var p=this.getCamera();if(m==="sap.ui.vk.dvl.Scene"){o="sap.ui.vk.dvl.Viewport";}else if(m==="sap.ui.vk.threejs.Scene"){o="sap.ui.vk.threejs.Viewport";}if(o){var t=O.get(o);this._implementation=new t({viewStateManager:this.getViewStateManager(),tools:this.getAssociation("tools"),content:this.getContent(),showDebugInfo:this.getShowDebugInfo(),width:this.getWidth(),height:this.getHeight(),backgroundColorTop:this.getBackgroundColorTop(),backgroundColorBottom:this.getBackgroundColorBottom(),selectionMode:this.getSelectionMode(),freezeCamera:this.getFreezeCamera(),contentConnector:this.getContentConnector()});if(p){this._camera=null;this._implementation.setCamera(p);}this._implementation.setParent(this);}this.invalidate();}}else{this._destroyImplementation();this.invalidate();}return this;};
e.prototype._onAfterUpdateViewStateManager=function(){if(this._implementation){this._implementation.setViewStateManager(this._viewStateManager);}};
e.prototype._onBeforeClearViewStateManager=function(){if(this._implementation){this._implementation.setViewStateManager(null);}};
e.prototype.activateView=function(v,n){if(this._implementation){this._implementation.activateView(v,n);return this;}else{q.sap.log.error("no implementation");return this;}};
e.prototype.resetCurrentView=function(l){if(this._implementation&&this._implementation.resetCurrentView){this._implementation.resetCurrentView(l);return this;}else{q.sap.log.error("no implementation");return this;}};
e.prototype.zoomTo=function(w,n,l,m){if(this._implementation){this._implementation.zoomTo(w,n,l,m);}else{q.sap.log.error("zoomTo: no implementation");}return this;};
e.prototype.tap=function(x,y,l){if(this._implementation){this._implementation.tap(x,y,l);}return this;};
var s=function(l){l.camera={};};var g=function(l){if(typeof l.camera==="object"&&l.camera!==null){l.camera.matrices=false;}};var h=function(l){if(typeof l.camera==="object"&&l.camera!==null){l.camera.useTransitionCamera=false;}};var i=function(l){l.animation=true;};var j=function(l){l.visibility=false;};var k=function(l){if(typeof l.visibility==="object"&&l.visibility!==null){l.visibility.mode=c.Complete;}};
e.prototype.getViewInfo=function(l){if(!this._implementation){q.sap.log.error("no implementation");return null;}var m={};if(typeof l!=="object"||l===null){s(m);g(m);h(m);i(m);j(m);k(m);}else{if(typeof l.camera==="object"&&l.camera!==null){m.camera={};if(typeof l.camera.matrices==="boolean"){m.camera.matrices=l.camera.matrices;}else if("matrices"in l.camera){m.camera.matrices=false;}else{g(m);}if(typeof l.camera.useTransitionCamera==="boolean"){m.camera.useTransitionCamera=l.camera.useTransitionCamera;}else if("useTransitionCamera"in l.camera){m.camera.useTransitionCamera=false;}else{h(m);}}else if(typeof l.camera==="boolean"){if(l.camera===true){m.camera={};g(m);h(m);}else{m.camera=false;}}else if("camera"in l){m.camera=false;}else{s(m);g(m);h(m);}if(typeof l.animation==="boolean"){m.animation=l.animation;}else if("animation"in l){m.animation=false;}else{i(m);}if(typeof l.visibility==="object"&&l.visibility!==null){m.visibility={};if(l.visibility.mode===c.Complete||l.visibility.mode===c.Differences){m.visibility.mode=l.visibility.mode;}else{k(m);}}else if(typeof l.visibility==="boolean"){if(l.visibility===true){m.visibility={};k(m);}else{m.visibility=false;}}else if("visibility"in l){m.visibility=false;}else{j(m);k(m);}}return this._implementation.getViewInfo(m);};
e.prototype.setViewInfo=function(v,l){if(this._implementation){this._implementation.setViewInfo(v,l);}else{q.sap.log.error("no implementation");}return this;};
e.prototype.updateNodeInfoInCurrentView=function(n,o){if(this._implementation&&this._implementation.updateNodeInfoInCurrentView){this._implementation.updateNodeInfoInCurrentView(n,o);}else{q.sap.log.error("no implementation");}};
e.prototype.getImage=function(w,l,t,m,n){if(this._implementation&&this._implementation.getImage){return this._implementation.getImage(w,l,t,m,n);}return null;};
C.injectMethodsIntoClass(e);a.injectMethodsIntoClass(e);return e;});
sap.ui.predefine('sap/ui/vk/ViewportBase',["sap/ui/core/Control","./library","./SelectionMode","./RenderMode"],function(C,v,S,R){"use strict";
var V=C.extend("sap.ui.vk.ViewportBase",{metadata:{library:"sap.ui.vk","abstract":true,properties:{showDebugInfo:{type:"boolean",defaultValue:false},backgroundColorTop:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(50, 50, 50, 1)"},backgroundColorBottom:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(255, 255, 255, 1)"},width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},selectionMode:{type:"sap.ui.vk.SelectionMode",defaultValue:S.Sticky},freezeCamera:{type:"boolean",defaultValue:false},renderMode:{type:"sap.ui.vk.RenderMode",defaultValue:R.Default}},associations:{contentConnector:{type:"sap.ui.vk.ContentConnector",multiple:false},viewStateManager:{type:"sap.ui.vk.ViewStateManager",multiple:false},tools:{type:"sap.ui.vk.tools.Tool",multiple:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{urlClicked:{parameters:{nodeRef:"any",url:"string"},enableEventBubbling:true},nodeClicked:{parameters:{nodeRef:"any",x:"int",y:"int"},enableEventBubbling:true},resize:{parameters:{size:"object"},enableEventBubbling:true},nodesPicked:{parameters:{picked:{type:"any[]"}},enableEventBubbling:true},nodeZoomed:{parameters:{zoomed:{type:"any"},isZoomIn:{type:"boolean"}},enableEventBubbling:true},viewActivated:{parameters:{viewIndex:"int",view:"sap.ui.vk.View",type:{type:"string"}},enableEventBubbling:true},procedureFinished:{enableEventBubbling:true},viewFinished:{parameters:{viewIndex:"int"},enableEventBubbling:true},animationStarted:{enableEventBubbling:true},animationFinished:{enableEventBubbling:true},animationUpdated:{parameters:{value:"float"},enableEventBubbling:true}}}});
var b=V.getMetadata().getParent().getClass().prototype;
V.prototype.init=function(){if(b.init){b.init.call(this);}this._camera=null;};
V.prototype.exit=function(){if(this._camera){if(this._contentConnector){var c=this._contentConnector.getContentManager();if(c){c.destroyCamera(this._camera);}this._camera=null;}}if(b.exit){b.exit.call(this);}};
V.prototype.getImage=function(w,h){return null;};
V.prototype.stickySelectionHandler=function(n){if(this._viewStateManager==null){return;}if(n.length===0){var c=[];this._viewStateManager.enumerateSelection(function(e){c.push(e);});if(c.length>0){this._viewStateManager.setSelectionStates([],c);}}else{var s=[];var d=[];var i=this._viewStateManager.getSelectionState(n);for(var a=0;a<i.length;a++){if(i[a]){d.push(n[a]);}else{s.push(n[a]);}}this._viewStateManager.setSelectionStates(s,d);}};
V.prototype.exclusiveSelectionHandler=function(n){if(this._viewStateManager==null){return;}var a=true;if(n.length===1){a=!this._viewStateManager.getSelectionState(n[0]);}else if(n.length>1){var i=this._viewStateManager.getSelectionState(n);for(var c=0;c<i.length;c++){if(i[c]){a=false;break;}}}var u=[];if(n.length===0||a){this._viewStateManager.enumerateSelection(function(s){u.push(s);});}this._viewStateManager.setSelectionStates(n,u);};
V.prototype.setCamera=function(c){if(c!==this._camera){if(this._camera&&this._contentConnector){var a=this._contentConnector.getContentManager();if(a){a.destroyCamera(this._camera);}}}this._camera=c;return this;};
V.prototype.getCamera=function(){return this._camera;};
V.prototype._onBeforeClearContentConnector=function(){this.setCamera(null);};
V.prototype.activateView=function(a,n){return this;};
V.prototype.pan=function(d,a){return this;};
V.prototype.rotate=function(d,a){return this;};
V.prototype.zoom=function(d){return this;};
return V;});
sap.ui.predefine('sap/ui/vk/ViewportHandler',["jquery.sap.global","sap/ui/base/EventProvider"],function(q,E){"use strict";
var V=E.extend("sap.ui.vk.ViewportHandler",{
metadata:{publicMethods:["beginGesture","move","endGesture","click","doubleClick","contextMenu","getViewport"]},
constructor:function(a){this._viewport=a;this._rect=null;this._evt={x:0,y:0,z:0,d:0,tdx:0,tdy:0,tdd:0,initd:0};this._gesture=false;this._viewport.attachEvent("resize",this,this._onresize);this._nomenu=false;}
});
V.prototype.destroy=function(){this._viewport=null;this._rect=null;this._evt=null;this._gesture=false;};
V.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
V.prototype._inside=function(e){if(this._rect==null||true){var i=this._viewport.getIdForLabel();var d=document.getElementById(i);if(d==null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
V.prototype._onresize=function(e){this._gesture=false;this._rect=null;};
V.prototype.beginGesture=function(a){if(this._inside(a)&&!this._gesture){this._gesture=true;var x=a.x-this._rect.x,y=a.y-this._rect.y;this._evt.tdx=0;this._evt.tdy=0;this._evt.tdd=0;this._evt.x=x;this._evt.y=y;this._evt.d=a.d;this._evt.initd=a.d;this._evt.avgd=a.d;this._evt.avgx=0;this._evt.avgy=0;q.sap.log.debug("Loco: beginGesture: "+x+", "+y);this._viewport.queueCommand(function(){this._viewport.beginGesture(x,y);}.bind(this));a.handled=true;if(document.activeElement){try{document.activeElement.blur();}catch(e){}}var d=document.getElementById(this._viewport.getIdForLabel());d.focus();}this._nomenu=false;};
V.prototype.move=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;var d=x-this._evt.x;var a=y-this._evt.y;var b=e.d-this._evt.d;this._evt.tdx=this._evt.tdx+d;this._evt.tdy=this._evt.tdy+a;this._evt.tdd=this._evt.tdd+b;this._evt.x=x;this._evt.y=y;this._evt.d=e.d;this._evt.avgx=this._evt.avgx*0.99+d*0.01;this._evt.avgy=this._evt.avgy*0.99+a*0.01;var z=1.0;if(this._evt.initd>0){z=1.0+b*(1.0/this._evt.initd);}else if(e.n==2){if(e.points[0].y>e.points[1].y){z=1.0-b*0.005;if(z<0.333){z=0.333;}}else{z=1.0+b*0.005;if(z>3){z=3;}}}if(this._evt.initd>0){var c=Math.sqrt(this._evt.avgx*this._evt.avgx+this._evt.avgy*this._evt.avgy);q.sap.log.debug("AvgDist: "+c);if((Math.abs(e.d-this._evt.avgd)/this._evt.avgd)<(c/10)){z=1.0;}}this._evt.avgd=this._evt.avgd*0.97+e.d*0.03;this._evt.n=e.n;switch(e.n){case 1:q.sap.log.debug("Loco: Rotate: "+(d)+", "+(a));this._viewport.queueCommand(function(){this._viewport.rotate(d,a);}.bind(this));break;case 2:q.sap.log.debug("Loco: Pan: "+(d)+", "+(a));if(z!=0&&z!=1.0){q.sap.log.debug("Loco: Zoom: "+(z));}this._viewport.queueCommand(function(){if(this._evt.tdx!==0&&this._evt.tdy!==0){this._viewport.pan(d,a);}if((d<10&&a<10&&z!=0&&z!=1.0)&&this._evt.tdd!==0){this._viewport.zoom(z);}}.bind(this));break;default:break;}this._nomenu=true;e.handled=true;}};
V.prototype.endGesture=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: endGesture: "+x+", "+y);this._viewport.queueCommand(function(){this._viewport.endGesture();}.bind(this));this._gesture=false;e.handled=true;}};
V.prototype.click=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: click: "+(x)+", "+(y));this._viewport.queueCommand(function(){this._viewport.tap(x,y,false);}.bind(this));e.handled=true;}};
V.prototype.doubleClick=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: doubleClick: "+(x)+", "+(y));this._viewport.queueCommand(function(){this._viewport.tap(x,y,true);}.bind(this));e.handled=true;}};
V.prototype.contextMenu=function(e){if(this._inside(e)||this._nomenu||e.buttons==5){this._nomenu=false;e.handled=true;}};
V.prototype.keyEventHandler=function(e){};
V.prototype.getViewport=function(){return this._viewport;};
return V;});
sap.ui.predefine('sap/ui/vk/ViewportRenderer',[],function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitViewport");r.writeClasses();r.writeAttribute("tabindex",0);r.writeAttribute("aria-label","Image");var a=false;var w=c.getWidth();if(w){r.addStyle("width",w);a=true;}var h=c.getHeight();if(h){r.addStyle("height",h);a=true;}if(a){r.writeStyles();}r.write(">");if(c._implementation){r.renderControl(c._implementation);}else if(c.getContent()){var C=c.getContent();for(var i=0,l=C.length;i<l;i++){r.renderControl(C[i]);}}r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/VisibilityMode',[],function(){"use strict";var V={Complete:"complete",Differences:"differences"};return V;},true);
sap.ui.predefine('sap/ui/vk/ZoomTo',[],function(){"use strict";var Z={All:"all",Visible:"visible",Selected:"selected",Node:"node",NodeSetIsolation:"node_setisolation",Restore:"restore",RestoreRemoveIsolation:"restore_removeisolation",ViewLeft:"view_left",ViewRight:"view_right",ViewTop:"view_top",ViewBottom:"view_bottom",ViewBack:"view_back",ViewFront:"view_front"};return Z;},true);
sap.ui.predefine('sap/ui/vk/abgrToColor',[],function(){"use strict";var a=function(b){return{red:b&0xff,green:b>>>8&0xff,blue:b>>>16&0xff,alpha:(b>>>24&0xff)/255};};return a;},true);
sap.ui.predefine('sap/ui/vk/colorToABGR',[],function(){"use strict";var c=function(a){return(a.alpha*255<<24|a.blue<<16|a.green<<8|a.red)>>>0;};return c;},true);
sap.ui.predefine('sap/ui/vk/colorToCSSColor',[],function(){"use strict";var c=function(a){return"rgba("+a.red+","+a.green+","+a.blue+","+a.alpha+")";};return c;},true);
sap.ui.predefine('sap/ui/vk/cssColorToColor',[],function(){"use strict";var c=(function(){var i=false;var d=document.createElement("div");d.id="sap.ui.vk.colorConverter";d.style.setProperty("display","none","important");return function(a){if(!i){if(document.body){document.body.appendChild(d);i=true;}else{return{red:0,green:0,blue:0,alpha:1};}}d.style.setProperty("color","rgba(0, 0, 0, 0)","important");d.style.setProperty("color",a,"important");var e=window.getComputedStyle(d).color;if(e==="transparent"){return{red:0,green:0,blue:0,alpha:0};}else{var b=e.split("(")[1].split(")")[0].split(",");return{red:parseInt(b[0],10),green:parseInt(b[1],10),blue:parseInt(b[2],10),alpha:b.length===4?parseFloat(b[3]):1};}};})();return c;},true);
sap.ui.predefine('sap/ui/vk/dvl/BaseNodeProxy',["../BaseNodeProxy","./getJSONObject"],function(B,g){"use strict";
var a=B.extend("sap.ui.vk.dvl.BaseNodeProxy",{metadata:{}});
a.prototype.init=function(n,b){this._dvl=n?n.getGraphicsCore()._getDvl():null;this._dvlSceneRef=n?n.getSceneRef():null;this._dvlNodeRef=b;};
a.prototype.reset=function(){this._dvlNodeRef=null;this._dvlSceneRef=null;this._dvl=null;};
a.prototype.getNodeRef=function(){return this._dvlNodeRef;};
a.prototype.getNodeId=function(){return this._dvlNodeRef;};
a.prototype.getName=function(){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_NAME)).NodeName;};
a.prototype.getNodeMetadata=function(){return g(this._dvl.Scene.RetrieveMetadata(this._dvlSceneRef,this._dvlNodeRef)).metadata;};
a.prototype.getHasChildren=function(){return(g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS)).Flags&(sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_MAPPED_HASCHILDREN|sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_CLOSED))===sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_MAPPED_HASCHILDREN;};
a.prototype.getSceneRef=function(){return this._dvlNodeRef;};
return a;});
sap.ui.predefine('sap/ui/vk/dvl/ContentManager',["../ContentManager","../getResourceBundle"],function(C,g){"use strict";
var a=C.extend("sap.ui.vk.dvl.ContentManager",{metadata:{library:"sap.ui.vk"}});
var b=a.getMetadata().getParent().getClass().prototype;
a.prototype.init=function(){if(b.init){b.init.call(this);}this._handleDownloadingProgressProxy=this._handleDownloadingProgress.bind(this);this._graphicsCore=null;this._failedSources=[];};
a.prototype.exit=function(){if(this._graphicsCore){this._graphicsCore.destroy();this._graphicsCore=null;}if(b.exit){b.exit.call(this);}};
var r={},w={antialias:true,alpha:true,premultipliedAlpha:true};
a.getRuntimeSettings=function(){return r;};
a.setRuntimeSettings=function(s){r=s;};
a.getWebGLContextAttributes=function(){return w;};
a.setWebGLContextAttributes=function(c){w=Object.assign(w,c);};
a.prototype._getGraphicsCore=function(){var t=this;return new Promise(function(c,d){if(t._graphicsCore){c(t._graphicsCore);}else{sap.ui.require(["sap/ui/vk/dvl/GraphicsCore"],function(G){G.create(r,w).then(function(e){t._graphicsCore=e;t._graphicsCore.attachSceneLoadingStarted(t._handleDvlSceneLoadingStarted,t);t._graphicsCore.attachSceneLoadingFinished(t._handleDvlSceneLoadingFinished,t);t._graphicsCore.attachSceneLoadingProgress(t._handleDvlSceneLoadingProgress,t);c(t._graphicsCore);});});}});};
a.prototype._handleDownloadingProgress=function(e){var s=e.getParameter("source"),l=e.getParameter("loaded"),t=e.getParameter("total"),v=t?l/t*50:0;this.fireContentChangesProgress({phase:g().getText("PROGRESS_INDICATOR_DOWNLOADING"),source:s,percentage:v});};
a.prototype._handleDvlSceneLoadingProgress=function(e){this.fireContentChangesProgress({phase:g().getText("PROGRESS_INDICATOR_RENDERING"),source:e.getParameter("source"),percentage:50+e.getParameter("percentage")*50});};
a.prototype._handleDvlSceneLoadingStarted=function(e){};
a.prototype._handleDvlSceneLoadingFinished=function(e){};
a.prototype.loadContent=function(c,d){this.fireContentChangesStarted();var t=this;this._getGraphicsCore().then(function(e){e.setDecryptionHandler(t._decryptionHandler);e.setAuthorizationHandler(t._authorizationHandler);e.loadContentResourcesAsync(d,function(s){var f=[];if(s){s.forEach(function(i){f.push({error:i,errorMessage:"Failed to download source '"+((i.source instanceof File)?i.source.name:i.source)+"'."});});}var l=c?c:undefined;e.updateSceneTreeAsync(l,d).then(function(h){var i={content:h.scene};if(h.failureReason){f=f.concat(h.failureReason);}if(f.length>0){i.failureReason=f;}sap.ui.require(["sap/ui/vk/dvl/Viewport","sap/ui/vk/dvl/ViewStateManager"],function(){t.fireContentChangesFinished(i);});}).catch(function(h){if(typeof h==="string"){f.push({error:h,errorMessage:h});}else{f.push({error:h,errorMessage:h.message?h.message:h.errorMessage});}t.fireContentChangesFinished({content:null,failureReason:f});});},t._handleDownloadingProgressProxy);},function(e){t.fireContentChangesFinished({content:null,failureReason:{error:e,errorMessage:"Failed to create DVL graphics core object."}});});return this;};
a.prototype.destroyContent=function(c){if(c){this._graphicsCore.destroyScene(c);}return this;};
a.prototype.collectGarbage=function(){this._graphicsCore.collectGarbage();return this;};
return a;});
sap.ui.predefine('sap/ui/vk/dvl/GraphicsCoreApi',[],function(){"use strict";var G={LegacyDvl:"LegacyDvl"};return G;},true);
sap.ui.predefine('sap/ui/vk/dvl/LayerProxy',["../LayerProxy","./getJSONObject"],function(L,g){"use strict";
var a=L.extend("sap.ui.vk.dvl.LayerProxy",{
metadata:{publicMethods:["getDescription","getLayerId","getLayerMetadata","getName","getNodes","getVeIds"]},
constructor:function(n,l){L.call(this);this._dvl=n?n.getGraphicsCore()._getDvl():null;this._dvlSceneRef=n?n.getSceneRef():null;this._dvlLayerId=l;}
});
a.prototype.destroy=function(){this._dvlLayerId=null;this._dvlSceneRef=null;this._dvl=null;L.prototype.destroy.call(this);};
a.prototype.getLayerId=function(){return this._dvlLayerId;};
a.prototype.getVeIds=function(){return g(this._dvl.Scene.RetrieveVEIDs(this._dvlSceneRef,this._dvlLayerId));};
a.prototype.getName=function(){return g(this._dvl.Scene.RetrieveLayerInfo(this._dvlSceneRef,this._dvlLayerId)).name;};
a.prototype.getDescription=function(){return g(this._dvl.Scene.RetrieveLayerInfo(this._dvlSceneRef,this._dvlLayerId)).description;};
a.prototype.getLayerMetadata=function(){return g(this._dvl.Scene.RetrieveMetadata(this._dvlSceneRef,this._dvlLayerId)).metadata;};
a.prototype.getNodes=function(){return g(this._dvl.Scene.RetrieveLayerInfo(this._dvlSceneRef,this._dvlLayerId)).nodes;};
return a;});
sap.ui.predefine('sap/ui/vk/dvl/NodeHierarchy',["jquery.sap.global","../NodeHierarchy","sap/ui/base/ObjectPool","./BaseNodeProxy","./NodeProxy","./LayerProxy","../Messages","../DvlException","./checkResult","./getJSONObject","../getResourceBundle"],function(q,N,O,B,a,L,M,D,c,g,b){"use strict";var l=q.sap.log;var s={modeDictionary:{equals:function(i){return i?sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_EQUAL:sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_EQUAL_CASE_INSENSITIVE;},contains:function(i){return i?sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_SUBSTRING:sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_SUBSTRING_CASE_INSENSITIVE;},startsWith:function(i){return i?sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_STARTS_WITH:sap.ve.dvl.DVLFINDNODEMODE.DVLFINDNODEMODE_STARTS_WITH_CASE_INSENSITIVE;}}};
var d=N.extend("sap.ui.vk.dvl.NodeHierarchy",{
metadata:{},
_baseNodeProxyPool:new O(B),
constructor:function(e){N.call(this);this._graphicsCore=e.getGraphicsCore();this._scene=e;this._dvlSceneRef=this._scene.getSceneRef();this._dvl=this._graphicsCore._getDvl();this._nodeProxies=[];this._layerProxies=[];}
});
d.prototype.destroy=function(){this._layerProxies.slice().forEach(this.destroyLayerProxy,this);this._nodeProxies.slice().forEach(this.destroyNodeProxy,this);this._dvl=null;this._dvlSceneRef=null;this._scene=null;this._graphicsCore=null;N.prototype.destroy.call(this);};
d.prototype.getGraphicsCore=function(){return this._graphicsCore;};
d.prototype.getScene=function(){return this._scene;};
d.prototype.getSceneRef=function(){return this._dvlSceneRef;};
d.prototype.enumerateChildren=function(n,e,f,p){if(typeof n==="function"){p=f;f=e;e=n;n=undefined;}var h;if(n){if(f||(g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS)).Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_CLOSED)===0){h=g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_CHILDREN)).ChildNodes;}else{h=[];}}else{h=g(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_CHILDREN)).ChildNodes;}if(p){h.forEach(e);}else{var i=this._baseNodeProxyPool.borrowObject();try{h.forEach(function(n){i.init(this,n);e(i);i.reset();}.bind(this));}finally{this._baseNodeProxyPool.returnObject(i);}}return this;};
d.prototype.enumerateAncestors=function(n,e,p){var f=g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_PARENTS)).ParentNodes;if(p){f.forEach(e);}else{var h=this._baseNodeProxyPool.borrowObject();try{f.forEach(function(n){h.init(this,n);e(h);h.reset();}.bind(this));}finally{this._baseNodeProxyPool.returnObject(h);}}return this;};
d.prototype.createNodeProxy=function(n){var e=new a(this,n);this._nodeProxies.push(e);return e;};
d.prototype.destroyNodeProxy=function(n){var i=this._nodeProxies.indexOf(n);if(i>=0){this._nodeProxies.splice(i,1)[0].destroy();}return this;};
d.prototype.getChildren=function(n,e){if(typeof n==="boolean"){e=n;n=undefined;}if(n){if(e||(g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS)).Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_CLOSED)===0){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_CHILDREN)).ChildNodes;}else{return[];}}else{return g(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_CHILDREN)).ChildNodes;}};
d.prototype.getAncestors=function(n){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_PARENTS)).ParentNodes;};
d.prototype.findNodesByName=function(e){var f=sap.ve.dvl.DVLFINDNODETYPE.DVLFINDNODETYPE_NODE_NAME,h=[],j,k;if(e===undefined||e===null||q.isEmptyObject(e)){j=s.modeDictionary.contains(false);k=[""];}else{if(e.value===undefined||e.value===null||e.value===""){q.sap.log.error(b().getText(M.VIT6.summary),M.VIT6.code,"sap.ui.vk.dvl.NodeHierarchy");return[];}var p=e.hasOwnProperty("predicate")?e.predicate:"equals";if(p===undefined||p===null||p===""){q.sap.log.error(b().getText(M.VIT7.summary),M.VIT7.code,"sap.ui.vk.dvl.NodeHierarchy");return[];}else if(["equals","contains","startsWith"].indexOf(p)===-1){q.sap.log.error(b().getText(M.VIT8.summary),M.VIT8.code,"sap.ui.vk.dvl.NodeHierarchy");return[];}j=s.modeDictionary[p](e.caseSensitive);k=(typeof e.value==="string")?[e.value]:e.value;}for(var i=0;i<k.length;i++){h=h.concat(g(this._dvl.Scene.FindNodes(this._dvlSceneRef,f,j,k[i])).nodes);}return q.sap.unique(h);};
d.prototype.createLayerProxy=function(e){var f=new L(this,e);this._layerProxies.push(f);return f;};
d.prototype.destroyLayerProxy=function(e){var i=this._layerProxies.indexOf(e);if(i>=0){this._layerProxies.splice(i,1)[0].destroy();}return this;};
d.prototype.getLayers=function(){return g(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_LAYERS)).Layers;};
d.prototype.getHotspotNodeIds=function(){var h=g(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_HOTSPOTS).ChildNodes);return h.length>0?h:this._getLegacyHotspotNodeIds();};
d.prototype._getLegacyHotspotNodeIds=function(){var e=this.getLayers(),h=[];for(var i=0;i<e.length;i++){var f=this.createLayerProxy(e[i]),j=f.getName();if(j.toLowerCase()==="hotspots"){h=f.getNodes();this.destroyLayerProxy(f);break;}this.destroyLayerProxy(f);}return h;};
d.prototype.createNode=function(p,n,i){var e=this._dvl.Scene.CreateNode(this._dvlSceneRef,p,n,i);this.fireNodeCreated({nodeRef:e,nodeId:e});this.fireChanged();return e;};
d.prototype.createNodeCopy=function(n,p,e,i){var f=this._dvl.Scene.CreateNodeCopy(this._dvlSceneRef,n,p,sap.ve.dvl.DVLCREATENODECOPYFLAG.COPY_CHILDREN,e,i);this.fireNodeCreated({nodeRef:f,nodeId:f});this.fireChanged();return f;};
d.prototype.removeNode=function(n){var f=[].concat(n);f.forEach(function(n){this.fireNodeRemoving({nodeRef:n,nodeId:n});try{c(this._dvl.Scene.DeleteNode(this._dvlSceneRef,n));}catch(e){var m="Failed to delete node with ID = "+n+".";if(e instanceof D){m+=" Error code: "+e.code+". Message: "+e.message+".";}l.error(m);}}.bind(this));this.fireChanged();return this;};
return d;});
sap.ui.predefine('sap/ui/vk/dvl/NodeProxy',["../NodeProxy","./getJSONObject","../cssColorToColor","../colorToCSSColor","../abgrToColor","../colorToABGR","../TransformationMatrix"],function(N,g,c,a,b,d,T){"use strict";
var e=N.extend("sap.ui.vk.dvl.NodeProxy",{
metadata:{},
constructor:function(n,f){N.call(this);this._dvl=n?n.getGraphicsCore()._getDvl():null;this._dvlSceneRef=n?n.getSceneRef():null;this._dvlNodeRef=f;}
});
e.prototype.destroy=function(){this._dvlNodeRef=null;this._dvlSceneRef=null;this._dvl=null;N.prototype.destroy.call(this);};
e.prototype.getNodeRef=function(){return this._dvlNodeRef;};
e.prototype.getNodeId=function(){return this._dvlNodeRef;};
e.prototype.getVeIds=function(){return g(this._dvl.Scene.RetrieveVEIDs(this._dvlSceneRef,this._dvlNodeRef));};
e.prototype.getName=function(){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_NAME)).NodeName;};
e.prototype.getLocalMatrix=function(){return T.convertTo4x3(g(this._dvl.Scene.GetNodeLocalMatrix(this._dvlSceneRef,this._dvlNodeRef)).matrix);};
e.prototype.setLocalMatrix=function(v){this._dvl.Scene.SetNodeLocalMatrix(this._dvlSceneRef,this._dvlNodeRef,v&&T.convertTo4x4(v));this.setProperty("localMatrix",v,true);return this;};
e.prototype.getWorldMatrix=function(){return T.convertTo4x3(g(this._dvl.Scene.GetNodeWorldMatrix(this._dvlSceneRef,this._dvlNodeRef)).matrix);};
e.prototype.setWorldMatrix=function(v){this._dvl.Scene.SetNodeWorldMatrix(this._dvlSceneRef,this._dvlNodeRef,v&&T.convertTo4x4(v));this.setProperty("worldMatrix",v,true);return this;};
e.prototype.getOpacity=function(){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_OPACITY)).Opacity;};
e.prototype.setOpacity=function(v){this._dvl.Scene.SetNodeOpacity(this._dvlSceneRef,this._dvlNodeRef,v);this.setProperty("opacity",v,true);return this;};
e.prototype.getTintColorABGR=function(){return g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_HIGHLIGHT_COLOR)).HighlightColor;};
e.prototype.setTintColorABGR=function(v){this._dvl.Scene.SetNodeHighlightColor(this._dvlSceneRef,this._dvlNodeRef,v);this.setProperty("tintColorABGR",v,true);this.setProperty("tintColor",a(b(v)),true);return this;};
e.prototype.getTintColor=function(){return a(b(this.getTintColorABGR()));};
e.prototype.setTintColor=function(v){var f=d(c(v));this._dvl.Scene.SetNodeHighlightColor(this._dvlSceneRef,this._dvlNodeRef,f);this.setProperty("tintColorABGR",f,true);this.setProperty("tintColor",v,true);return this;};
e.prototype.getNodeMetadata=function(){return g(this._dvl.Scene.RetrieveMetadata(this._dvlSceneRef,this._dvlNodeRef)).metadata;};
e.prototype.getHasChildren=function(){return(g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS)).Flags&(sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_MAPPED_HASCHILDREN|sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_CLOSED))===sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_MAPPED_HASCHILDREN;};
e.prototype.getClosed=function(){return(g(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,this._dvlNodeRef,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS)).Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_CLOSED)!==0;};
return e;});
sap.ui.predefine('sap/ui/vk/dvl/Scene',["jquery.sap.global","../Scene","./NodeHierarchy"],function(q,S,N){"use strict";
var a=S.extend("sap.ui.vk.dvl.Scene",{
metadata:{},
constructor:function(g,d){S.call(this);this._id=q.sap.uid();this._graphicsCore=g;this._dvlSceneRef=d;this._defaultNodeHierarchy=null;}
});
a.prototype.destroy=function(){if(this._defaultNodeHierarchy){this._defaultNodeHierarchy.destroy();this._defaultNodeHierarchy=null;}this._dvlSceneRef=null;this._graphicsCore=null;S.prototype.destroy.call(this);};
a.prototype.getId=function(){return this._id;};
a.prototype.getGraphicsCore=function(){return this._graphicsCore;};
a.prototype.getDefaultNodeHierarchy=function(){if(!this._defaultNodeHierarchy){this._defaultNodeHierarchy=new N(this);}return this._defaultNodeHierarchy;};
a.prototype.getSceneRef=function(){return this._dvlSceneRef;};
a.prototype.setDoubleSided=function(v){this.setProperty("doubleSided",v,true);this._graphicsCore._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_SHOW_BACKFACING,v);return this;};
return a;});
sap.ui.predefine('sap/ui/vk/dvl/ViewStateManager',["jquery.sap.global","sap/ui/core/Element","../ContentConnector","../ViewStateManagerBase","./GraphicsCoreApi","../cssColorToColor","../colorToCSSColor","../abgrToColor","../colorToABGR","./Scene"],function(q,E,C,V,G,c,a,b,d,S){"use strict";var e;
var f=V.extend("sap.ui.vk.dvl.ViewStateManager",{metadata:{}});
var g=f.getMetadata().getParent().getClass().prototype;
f.prototype.init=function(){if(g.init){g.init.call(this);}this._nodeHierarchy=null;this._dvl=null;this._nodeStates=new Map();this._selectedNodes=new Set();this._visibilityTracker=new e();this._closedNodeProcessed=false;};
f.prototype._setContent=function(i){var j=null;if(i&&i instanceof S){j=i;}this._setScene(j);};
f.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
f.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};
f.prototype._handleContentReplaced=function(i){var j=i.getParameter("newContent");this._setContent(j);};
f.prototype._setScene=function(i){if(i){this._setNodeHierarchy(i.getDefaultNodeHierarchy());}else{this._setNodeHierarchy(null);}return this;};
f.prototype._setNodeHierarchy=function(n){var o=this._nodeHierarchy;if(this._nodeHierarchy){this._nodeHierarchy.detachNodeCreated(this._handleNodeCreated,this);this._nodeHierarchy.detachNodeRemoving(this._handleNodeRemoving,this);this._dvl.Client.detachStepEvent(this._handleStepEvent,this);this._nodeHierarchy=null;this._dvl=null;this._nodeStates.clear();this._selectedNodes.clear();this._visibilityTracker.clear();}if(n){var i=n.getScene(),j=i.getSceneRef();this._nodeHierarchy=n;this._dvl=i.getGraphicsCore().getApi(G.LegacyDvl);this._dvl.Client.attachStepEvent(this._handleStepEvent,this);this._nodeHierarchy.attachNodeCreated(this._handleNodeCreated,this);this._nodeHierarchy.attachNodeRemoving(this._handleNodeRemoving,this);this._populateNodeStates(this._dvl.Scene.RetrieveSceneInfo(j,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_CHILDREN|sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_HOTSPOTS).ChildNodes);}if(n!==o){this.fireNodeHierarchyReplaced({oldNodeHierarchy:o,newNodeHierarchy:n});}return this;};
f.prototype._populateNodeStates=function(n){var t=this,v=[],i=[],j=[],u=[],k=this._nodeHierarchy.getScene(),l=k.getSceneRef();n.forEach(function addNodeRecursive(m){var o=t._dvl.Scene.RetrieveNodeInfo(l,m,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS|sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_CHILDREN);t._nodeStates.set(m,{flags:o.Flags,visible:o.Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE});if(o.Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED){t._selectedNodes.add(m);}(o.Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE?v:i).push(m);(o.Flags&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED?j:u).push(m);o.ChildNodes.forEach(addNodeRecursive);});this.fireSelectionChanged({selected:j,unselected:u});this.fireVisibilityChanged({visible:v,hidden:i});return this;};
f.prototype._handleNodeCreated=function(i){this._populateNodeStates([i.getParameter("nodeRef")]);};
f.prototype._handleNodeRemoving=function(i){var n=i.getParameter("nodeRef"),t=this;var r=function(n){t._nodeHierarchy.enumerateChildren(n,r,true,true);t._nodeStates.delete(n);};r(n);};
f.prototype.getNodeHierarchy=function(){return this._nodeHierarchy;};
f.prototype.getVisibilityChanges=function(){return this.getShouldTrackVisibilityChanges()?this._visibilityTracker.getInfo(this.getNodeHierarchy()):null;};
f.prototype.getVisibilityComplete=function(){var n=this.getNodeHierarchy(),i=n.findNodesByName(),v=[],j=[];i.forEach(function(k){var l=n.createNodeProxy(k),m=q.grep(l.getVeIds(),function(m){return m.type==="VE_LOCATOR";});m=Array.isArray(m)&&m.length>0?m[0].fields[0].value:null;n.destroyNodeProxy(l);if(m){if(this.getVisibilityState(k)){v.push(m);}else{j.push(m);}}},this);return{visible:v,hidden:j};};
f.prototype.resetVisibility=function(){this._dvl.Renderer.ResetView(sap.ve.dvl.DVLRESETVIEWFLAG.VISIBILITY,this._scene);return this;};
var h=function(n,i,j){return n.has(j)&&(n.get(j).flags&i)!==0;};
f.prototype._getVisibilityFlagState=function(n){return h(this._nodeStates,sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE,n);};
f.prototype._getSelectionFlagState=function(n){return h(this._nodeStates,sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED,n);};
var s=function(n,i,j,k){if(n.has(k)){var l=n.get(k);l.flags=l.flags&~j|i&j;}else{n.set(k,{flags:i&j});}};
f.prototype._setFlags=function(n,i,j){if(j&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE){this.setVisibilityState(n,(i&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE)!==0,false);}if(j&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED){this.setSelectionState(n,(i&sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED)!==0,false);}s(this._nodeStates,i,j&~(sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE|sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED),n);return this;};
f.prototype._getFlags=function(n,i){var j=this._nodeStates.get(n),k=j&&j.flags;return k!==undefined?k&i:null;};
f.prototype.getVisibilityState=function(n){return Array.isArray(n)?n.map(this._getVisibilityFlagState,this):this._getVisibilityFlagState(n);};
f.prototype.setVisibilityState=function(n,v,r){if(!Array.isArray(n)){n=[n];}var i=q.sap.unique(r?this._collectNodesRecursively(n,true):n).filter(function(j){return j&&this._getVisibilityFlagState(j)!==v;},this);var u=function(j,v){var k=[];this._nodeHierarchy.enumerateChildren(j,function(l){k.push(l);},true,true);k.forEach(function(l){var m=this._nodeStates.get(l);if(v){if(m.visible){m.flags|=sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE;u(l,v);}}else{m.flags&=~sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE;u(l,v);}},this);}.bind(this);if(i.length>0){i.forEach(function(j){var k=this._nodeStates.get(j);if(k){if(k.flags===undefined){k.flags=0;}if(v){k.flags|=sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE;}else{k.flags&=~sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE;}}else{k={flags:v?sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_VISIBLE:0};this._nodeStates.set(j,k);}k.visible=v;u(j,v);},this);if(this.getShouldTrackVisibilityChanges()){i.forEach(this._visibilityTracker.trackNodeRef,this._visibilityTracker);}this.fireVisibilityChanged({visible:v?i:[],hidden:v?[]:i});}return this;};
f.prototype.enumerateSelection=function(i){this._selectedNodes.forEach(i);return this;};
f.prototype.getSelectionState=function(n){return Array.isArray(n)?n.map(this._getSelectionFlagState,this):this._getSelectionFlagState(n);};
f.prototype.setSelectionState=function(n,i,r,j){if(!Array.isArray(n)){n=[n];}var k=q.sap.unique(r||this.getRecursiveSelection()?this._collectNodesRecursively(n):n);if(this.getRecursiveSelection()&&!i){k=this._nodeHierarchy._appendAncestors(k);}k=k.filter(function(l){return l&&this._getSelectionFlagState(l)!==i;},this);if(k.length>0){k.forEach(function(l){var m=this._nodeStates.get(l);if(m){if(m.flags===undefined){m.flags=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),l,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;}if(i){m.flags|=sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED;}else{m.flags&=~sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED;}}else{var o=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),l,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;this._nodeStates.set(l,{flags:o|(i?sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED:0)});}this._selectedNodes[i?"add":"delete"](l);},this);if(!j){this.fireSelectionChanged({selected:i?k:[],unselected:i?[]:k});}}return this;};
f.prototype.setSelectionStates=function(i,u,r,j){if(!Array.isArray(i)){i=[i];}if(!Array.isArray(u)){u=[u];}var k=q.sap.unique(r||this.getRecursiveSelection()?this._collectNodesRecursively(i):i);var l=q.sap.unique(r||this.getRecursiveSelection()?this._collectNodesRecursively(u):u);if(this.getRecursiveSelection()){l=this._nodeHierarchy._appendAncestors(l,k);}k=k.filter(function(n){return n&&this._getSelectionFlagState(n)===false;},this);l=l.filter(function(n){return n&&this._getSelectionFlagState(n)===true;},this);if(k.length>0){k.forEach(function(n){var m=this._nodeStates.get(n);if(m){if(m.flags===undefined){m.flags=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;}m.flags|=sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED;}else{var o=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;this._nodeStates.set(n,{flags:o|sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED});}this._selectedNodes["add"](n);},this);}if(l.length>0){l.forEach(function(n){var m=this._nodeStates.get(n);if(m){if(m.flags===undefined){m.flags=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;}m.flags&=~sap.ve.dvl.DVLNODEFLAG.DVLNODEFLAG_SELECTED;}else{var o=this._dvl.Scene.RetrieveNodeInfo(this._nodeHierarchy.getScene().getSceneRef(),n,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_FLAGS).Flags;this._nodeStates.set(n,{flags:o});}this._selectedNodes["delete"](n);},this);}if(!j){if(k.length>0||l.length>0){this.fireSelectionChanged({selected:k,unselected:l});}}return this;};
f.prototype._handleStepEvent=function(i){if(i.type===sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_STARTED){this._visibilityTracker.clear();}};
f.prototype._collectNodesRecursively=function(n,i){var r=[],t=this;if(i===undefined){i=false;}n.forEach(function collectChildNodes(j){r.push(j);t._nodeHierarchy.enumerateChildren(j,collectChildNodes,i,true);});return r;};
f.prototype._getOpacity=function(n){if(this._nodeStates.has(n)){var o=this._nodeStates.get(n).opacity;return o===undefined?null:o;}else{return null;}};
f.prototype.getOpacity=function(n){if(Array.isArray(n)){return n.map(this._getOpacity,this);}else{return this._getOpacity(n);}};
f.prototype.setOpacity=function(n,o,r){if(!Array.isArray(n)){n=[n];}var i=q.sap.unique(r?this._collectNodesRecursively(n,true):n).filter(function(j){return j&&this._getOpacity(j)!==o;},this);if(i.length>0){i.forEach(function(j){var k=this._nodeStates.get(j);if(k){if(o===null){delete k.opacity;}else{k.opacity=o;}}else if(o!==null){this._nodeStates.set(j,{opacity:o});}},this);this.fireOpacityChanged({changed:i,opacity:o});}return this;};
f.prototype._getTintColorABGR=function(n){if(this._nodeStates.has(n)){var t=this._nodeStates.get(n).tintColorABGR;return t===undefined?null:t;}else{return null;}};
f.prototype._getTintColor=function(n){if(this._nodeStates.has(n)){var t=this._nodeStates.get(n).tintColorABGR;return t===undefined?null:a(b(t));}else{return null;}};
f.prototype.getTintColor=function(n,i){var j=i?"_getTintColorABGR":"_getTintColor";if(Array.isArray(n)){return n.map(this[j],this);}else{return this[j](n);}};
f.prototype.setTintColor=function(n,t,r){if(!Array.isArray(n)){n=[n];}var i=null;switch(typeof t){case"number":i=t;break;case"string":if(sap.ui.core.CSSColor.isValid(t)){i=d(c(t));}break;default:t=null;break;}var j=q.sap.unique(r?this._collectNodesRecursively(n,true):n).filter(function(k){return k&&this._getTintColorABGR(k)!==i;},this);if(j.length>0){j.forEach(function(k){var l=this._nodeStates.get(k);if(l){if(i===null){delete l.tintColorABGR;}else{l.tintColorABGR=i;}}else if(i!==null){this._nodeStates.set(k,{tintColorABGR:i});}},this);this.fireTintColorChanged({changed:j,tintColor:t,tintColorABGR:i});}return this;};
e=function(){this._visibilityChanges=new Set();};
e.prototype.getInfo=function(n){var i=function(v){return v.type==="VE_LOCATOR";};var j=[];this._visibilityChanges.forEach(function(k){var l=n.createNodeProxy(k),v=q.grep(l.getVeIds(),i);v=Array.isArray(v)&&v.length>0?v[0].fields[0].value:null;n.destroyNodeProxy(l);if(v){j.push(v);}});return j;};
e.prototype.clear=function(){this._visibilityChanges.clear();};
e.prototype.trackNodeRef=function(n){if(this._visibilityChanges.has(n)){this._visibilityChanges.delete(n);}else{this._visibilityChanges.add(n);}};
C.injectMethodsIntoClass(f);return f;});
sap.ui.predefine('sap/ui/vk/dvl/Viewport',["jquery.sap.global","sap/ui/core/ResizeHandler","../abgrToColor","../CameraFOVBindingType","../CameraProjectionType","../colorToABGR","../colorToCSSColor","../ContentConnector","../cssColorToColor","../getResourceBundle","../Loco","../Messages","../SelectionMode","../Smart2DHandler","../ViewportBase","../ViewportHandler","../ViewStateManager","../VisibilityMode","../ZoomTo","./getJSONObject","./Scene","./ViewportRenderer"],function(q,R,a,C,b,c,d,e,g,h,L,M,S,k,V,l,n,o,Z,p,r,s){"use strict";var t;var u=function(){if(t){return;}t={encodedProjectionType:{},decodedProjectionType:{},encodedBindingType:{},decodedBindingType:{},decodedZoomTo:{}};t.decodedProjectionType[b.Perspective]=sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE;t.decodedProjectionType[b.Orthographic]=sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC;t.encodedProjectionType[sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE]=b.Perspective;t.encodedProjectionType[sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC]=b.Orthographic;t.decodedBindingType[C.Minimum]=sap.ve.dvl.DVLCAMERAFOVBINDING.MIN;t.decodedBindingType[C.Maximum]=sap.ve.dvl.DVLCAMERAFOVBINDING.Max;t.decodedBindingType[C.Horizontal]=sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ;t.decodedBindingType[C.Vertical]=sap.ve.dvl.DVLCAMERAFOVBINDING.VERT;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.MIN]=C.Minimum;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.MAX]=C.Maximum;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ]=C.Horizontal;t.encodedBindingType[sap.ve.dvl.DVLCAMERAFOVBINDING.VERT]=C.Vertical;t.decodedZoomTo[Z.All]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_ALL;t.decodedZoomTo[Z.Visible]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_VISIBLE;t.decodedZoomTo[Z.Selected]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_SELECTED;t.decodedZoomTo[Z.Node]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_NODE;t.decodedZoomTo[Z.NodeSetIsolation]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_NODE_SETISOLATION;t.decodedZoomTo[Z.Restore]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_RESTORE;t.decodedZoomTo[Z.RestoreRemoveIsolation]=sap.ve.dvl.DVLZOOMTO.DVLZOOMTO_RESTORE_REMOVEISOLATION;t.decodedZoomTo[Z.ViewLeft]=sap.ve.dvl.DVLZOOMTO.VIEW_LEFT;t.decodedZoomTo[Z.ViewRight]=sap.ve.dvl.DVLZOOMTO.VIEW_RIGHT;t.decodedZoomTo[Z.ViewTop]=sap.ve.dvl.DVLZOOMTO.VIEW_TOP;t.decodedZoomTo[Z.ViewBottom]=sap.ve.dvl.DVLZOOMTO.VIEW_BOTTOM;t.decodedZoomTo[Z.ViewBack]=sap.ve.dvl.DVLZOOMTO.VIEW_BACK;t.decodedZoomTo[Z.ViewFront]=sap.ve.dvl.DVLZOOMTO.VIEW_FRONT;};
var v=V.extend("sap.ui.vk.dvl.Viewport",{metadata:{library:"sap.ui.vk",properties:{showAllHotspots:{type:"boolean",defaultValue:false},hotspotColorABGR:{type:"int",defaultValue:0xc00000ff},hotspotColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(255, 0, 0, 0.7529411764705882)"},backgroundColorTopABGR:{type:"int",defaultValue:0xff000000},backgroundColorBottomABGR:{type:"int",defaultValue:0xffffffff}},events:{pan:{parameters:{dx:"int",dy:"int"}},zoom:{parameters:{zoomFactor:"float"}},rotate:{parameters:{dx:"int",dy:"int"}},frameRenderingFinished:{}}}});
var w=v.getMetadata().getParent().getClass().prototype;
v.prototype.init=function(){u();if(w.init){w.init.call(this);}this._graphicsCore=null;this._dvl=null;this._dvlRendererId=null;this._viewStateManager=null;this._canvas=null;this._resizeListenerId=null;this._is2D=false;this._viewportHandler=new l(this);this._loco=new L(this);this._loco.addHandler(this._viewportHandler,-1);this._smart2DHandler=null;this._lastPlayedStep=null;this._contentConnector=null;};
v.prototype.exit=function(){this._loco.removeHandler(this._viewportHandler);this._viewportHandler.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._clearContentConnector();this.setViewStateManager(null);this.setScene(null);this.setGraphicsCore(null);if(w.exit){w.exit.call(this);}};
v.prototype.setGraphicsCore=function(f){if(f!=this._graphicsCore){if(this._graphicsCore){this._dvl.Client.detachFrameFinished(this._handleFrameFinished,this);this._dvl.Client.detachStepEvent(this._updateLastPlayedStep,this);this._dvl.Renderer.SetViewStateManager(null,this._dvlRendererId);this._graphicsCore._deregisterViewport(this);this._dvl=null;}this._graphicsCore=f;if(this._graphicsCore){this._dvl=this._graphicsCore._getDvl();this._graphicsCore._registerViewport(this);this.setShowDebugInfo(this.getShowDebugInfo());this._dvl.Client.attachStepEvent(this._updateLastPlayedStep,this);this._dvl.Client.attachFrameFinished(this._handleFrameFinished,this);this._dvl.Renderer.SetViewStateManager(this._viewStateManager,this._dvlRendererId);}}return this;};
v.prototype.getGraphicsCore=function(){return this._graphicsCore;};
v.prototype._setCanvas=function(f){var i=this.getDomRef()&&this._canvas!==f;this._canvas=f;if(i){this.invalidate();}return this;};
v.prototype._setRenderer=function(f){this._dvlRendererId=f;return this;};
v.prototype._updateLastPlayedStep=function(f){if(f.type===sap.ve.dvl.DVLSTEPEVENT.DVLSTEPEVENT_STARTED){this._lastPlayedStep=f.stepId;}};
v.prototype.setScene=function(f){if(this._dvlRendererId){this._dvl.Renderer.AttachScene(f&&f.getSceneRef()||null,this._dvlRendererId);this._dvlSceneRef=f?f.getSceneRef():null;if(f){this._dvl.Client.attachUrlClicked(this._fireUrlClicked,this);var i=this._isSmart2DContent()||this._isSmart2DContentLegacy();if(i){this._dvl.Renderer.SetBackgroundColor(1,1,1,1,1,1,1,1,this._dvlRendererId);}else{var j=this._getDecomposedABGR(this.getBackgroundColorTopABGR());var m=this._getDecomposedABGR(this.getBackgroundColorBottomABGR());this._dvl.Renderer.SetBackgroundColor(j.red,j.green,j.blue,j.alpha,m.red,m.green,m.blue,m.alpha,this._dvlRendererId);}this.fireViewActivated({type:i?"2D":"3D"});}else{this._dvl.Client.detachUrlClicked(this._fireUrlClicked,this);if(this._smart2DHandler){this._loco.removeHandler(this._smart2DHandler);}this.invalidate();}}return this;};
v.prototype._isSmart2DContent=function(){var f=p(this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_HOTSPOTS).ChildNodes);return f&&f.length>0;};
v.prototype._isSmart2DContentLegacy=function(){var f=this._dvl.Scene.GetCurrentCamera(this._dvlSceneRef),i=this._dvl.Camera.GetRotation(f),j=this._dvl.Camera.GetProjection(f);return i[0]===90&&i[1]===-90&&i[2]===0&&j===sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC;};
v.prototype._initializeSmart2DHandler=function(){if(this._viewStateManager){if(this._smart2DHandler){this._loco.removeHandler(this._smart2DHandler);}this._smart2DHandler=new k(this,this._viewStateManager);this._loco.addHandler(this._smart2DHandler,0);}if(this.getShowAllHotspots()){var f=this._viewStateManager.getNodeHierarchy(),i=f.getHotspotNodeIds();this.showHotspots(i,true);}};
v.prototype._fireUrlClicked=function(f){this.fireUrlClicked({url:f.url,nodeRef:f.nodeId});};
v.prototype.setHotspotColorABGR=function(f){this.setProperty("hotspotColorABGR",f,true);this.setProperty("hotspotColor",d(a(this.getProperty("hotspotColorABGR"))),true);return this;};
v.prototype.setHotspotColor=function(f){this.setProperty("hotspotColor",f,true);this.setProperty("hotspotColorABGR",c(g(this.getProperty("hotspotColor"))),true);return this;};
v.prototype._getStepAndProcedureIndexes=function(f,m){var x=-1,y=-1,N=false;for(var i=0;i<f.length;i++){if(!N){for(var j=0;j<f[i].steps.length;j++){if(f[i].steps[j].id===m){y=j;x=i;N=true;break;}}}else{break;}}return{stepIndex:y,procedureIndex:x};};
v.prototype._getStepVeIdById=function(f){if(f){var i=this._dvl.Scene.RetrieveVEIDs(this._dvlSceneRef,f);if(Array.isArray(i)){for(var j=0,m=i.length;j<m;++j){var x=i[j];if(x.source==="SAP"&&x.type==="VE_VIEWPORT"&&Array.isArray(x.fields)){for(var y=0,N=x.fields.length;y<N;++y){var O=x.fields[y];if(O.name==="ID"){return O.value;}}}}}}return null;};
v.prototype._getStepIdByVeId=function(f,i){for(var j=0,m=f.length;j<m;++j){var x=f[j].steps;for(var y=0,N=x.length;y<N;++y){var O=x[y].id;if(this._getStepVeIdById(O)===i){return O;}}}return null;};
var z=function(f){f.camera={};};var A=function(f){if(typeof f.camera==="object"&&f.camera!==null){f.camera.matrices=false;}};var B=function(f){if(typeof f.camera==="object"&&f.camera!==null){f.camera.useTransitionCamera=false;}};var D=function(f){f.animation=true;};var E=function(f){f.visibility=false;};var F=function(f){if(typeof f.visibility==="object"&&f.visibility!==null){f.visibility.mode=o.Complete;}};
v.prototype.getViewInfo=function(f){if(!this._dvlSceneRef){return null;}var i={};if(typeof f!=="object"||f===null){z(i);A(i);B(i);D(i);E(i);F(i);}else{if(typeof f.camera==="object"&&f.camera!==null){i.camera={};if(typeof f.camera.matrices==="boolean"){i.camera.matrices=f.camera.matrices;}else if("matrices"in f.camera){i.camera.matrices=false;}else{A(i);}if(typeof f.camera.useTransitionCamera==="boolean"){i.camera.useTransitionCamera=f.camera.useTransitionCamera;}else if("useTransitionCamera"in f.camera){i.camera.useTransitionCamera=false;}else{B(i);}}else if(typeof f.camera==="boolean"){if(f.camera===true){i.camera={};A(i);B(i);}else{i.camera=false;}}else if("camera"in f){i.camera=false;}else{z(i);A(i);B(i);}if(typeof f.animation==="boolean"){i.animation=f.animation;}else if("animation"in f){i.animation=false;}else{D(i);}if(typeof f.visibility==="object"&&f.visibility!==null){i.visibility={};if(f.visibility.mode===o.Complete||f.visibility.mode===o.Differences){i.visibility.mode=f.visibility.mode;}else{F(i);}}else if(typeof f.visibility==="boolean"){if(f.visibility===true){i.visibility={};F(i);}else{i.visibility=false;}}else if("visibility"in f){i.visibility=false;}else{E(i);F(i);}}var j={};if(i.camera){var m=null;if(i.camera.useTransitionCamera){m=this._dvl.Renderer.GetTransitionCamera(this._dvlRendererId);if(m===sap.ve.dvl.DVLID_INVALID){m=null;}}if(m===null){m=this._dvl.Renderer.GetCurrentCamera(this._dvlRendererId);}var x=this._dvl.Camera.GetRotation(m),y=this._dvl.Camera.GetOrigin(m);j.camera={rotation:{yaw:x[0],pitch:x[1],roll:x[2]},position:{x:y[0],y:y[1],z:y[2]},projectionType:t.encodedProjectionType[this._dvl.Camera.GetProjection(m)],bindingType:t.encodedBindingType[this._dvl.Camera.GetFOVBinding(m)]};if(this._matView){j.viewMatrix=this._matView.slice();}if(this._matProj){j.projectionMatrix=this._matProj.slice();}if(j.camera.projectionType===b.Perspective){j.camera.fieldOfView=this._dvl.Camera.GetFOV(m);}else if(j.camera.projectionType===b.Orthographic){j.camera.zoomFactor=this._dvl.Camera.GetOrthoZoomFactor(m);}if(i.camera.matrices){var N=this._dvl.Renderer.GetCameraMatrices(this._dvlRendererId);j.camera.matrices={view:N.view,projection:N.projection};}}if(i.animation){var O=this._dvl.Scene.RetrieveSceneInfo(this._dvlSceneRef,sap.ve.dvl.DVLSCENEINFO.DVLSCENEINFO_STEP_INFO),P=O.StepId!==sap.ve.dvl.DVLID_INVALID;var Q=P?O.StepId:this._lastPlayedStep,T=P?O.StepTime:0,U=this._dvl.Scene.RetrieveProcedures(this._dvlSceneRef),W=this._getStepAndProcedureIndexes(U.procedures,Q),X=this._getStepVeIdById(Q);j.animation={animationTime:T,stepIndex:W.stepIndex,procedureIndex:W.procedureIndex};if(X){j.animation.stepVeId=X;}}if(i.visibility&&this._viewStateManager){j.visibility={mode:i.visibility.mode};if(i.visibility.mode===o.Complete){var Y=this._viewStateManager.getVisibilityComplete();j.visibility.visible=Y.visible;j.visibility.hidden=Y.hidden;}else if(this._viewStateManager.getShouldTrackVisibilityChanges()){j.visibility.changes=this._viewStateManager.getVisibilityChanges();}else{q.sap.log.warning(h().getText(M.VIT32.summary),M.VIT32.code,"sap.ui.vk.dvl.Viewport");}}return j;};
v.prototype.setViewInfo=function(f,i){var j=false;if(f.animation){var m=this._dvl.Scene.RetrieveProcedures(this._dvlSceneRef),x=f.animation.procedureIndex,y=f.animation.stepIndex,N=f.animation.stepVeId,O,P=f.animation.animationTime||0;if(N||y>=0&&x>=0){if(N){O=this._getStepIdByVeId(m.procedures,f.animation.stepVeId);}else if(x>=0&&x<m.procedures.length){if(y>=0&&y<m.procedures[x].steps.length){O=m.procedures[x].steps[y].id;}else{q.sap.log.error(h().getText(M.VIT26.summary),M.VIT26.code,"sap.ui.vk.dvl.Viewport");}}else{q.sap.log.error(h().getText(M.VIT27.summary),M.VIT27.code,"sap.ui.vk.dvl.Viewport");}if(O){this._dvl.Renderer.ActivateStep(this._dvlRendererId,O,false,false,P);this._dvl.Renderer.PauseCurrentStep(this._dvlRendererId);}}else{j=true;}}if(f.camera){var Q;if(f.camera.projectionType===b.Perspective||f.camera.projectionType===b.Orthographic){Q=t.decodedProjectionType[f.camera.projectionType];}else{q.sap.log.error(h().getText(M.VIT19.summary),M.VIT19.code,"sap.ui.vk.dvl.Viewport");Q=sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE;}var T=this._dvl.Scene.CreateCamera(this._dvlSceneRef,Q,sap.ve.dvl.DVLID_INVALID);if(Q===sap.ve.dvl.DVLCAMERAPROJECTION.PERSPECTIVE){this._dvl.Camera.SetFOV(T,f.camera.fieldOfView);}else if(Q===sap.ve.dvl.DVLCAMERAPROJECTION.ORTHOGRAPHIC){this._dvl.Camera.SetOrthoZoomFactor(T,f.camera.zoomFactor);}if(f.camera.position){this._dvl.Camera.SetOrigin(T,f.camera.position.x,f.camera.position.y,f.camera.position.z);}if(f.camera.rotation){this._dvl.Camera.SetRotation(T,f.camera.rotation.yaw,f.camera.rotation.pitch,f.camera.rotation.roll);}if(f.camera.bindingType){var U=t.decodedBindingType[f.camera.bindingType]||sap.ve.dvl.DVLCAMERAFOVBINDING.MIN;this._dvl.Camera.SetFOVBinding(T,U);}i=i||0;this._dvl.Renderer.ActivateCamera(this._dvlRendererId,T,i);this._dvl.Scene.DeleteNode(this._dvlSceneRef,T);}if(f.viewMatrix){this._matView=f.viewMatrix.slice();}if(f.projectionMatrix){this._matProj=f.projectionMatrix.slice();}if(f.visibility){var W=this._viewStateManager.getNodeHierarchy(),X=new Map(),Y=W.findNodesByName();Y.forEach(function(a1){var b1=W.createNodeProxy(a1),c1=q.grep(b1.getVeIds(),function(c1){return c1.type==="VE_LOCATOR";});c1=Array.isArray(c1)&&c1.length>0?c1[0].fields[0].value:null;W.destroyNodeProxy(b1);if(c1){X.set(c1,a1);}});switch(f.visibility.mode){case o.Complete:var $=f.visibility.visible,_=f.visibility.hidden;$.forEach(function(a1){this._viewStateManager.setVisibilityState(X.get(a1),true,false);},this);_.forEach(function(a1){this._viewStateManager.setVisibilityState(X.get(a1),false,false);},this);break;case o.Differences:if(j){this.resetView({camera:false,visibility:true,transition:false});}f.visibility.changes.forEach(function(a1){var b1=X.get(a1);if(b1){this._viewStateManager.setVisibilityState(b1,!this._viewStateManager.getVisibilityState(b1),false);}},this);break;default:q.sap.log.error(h().getText(M.VIT28.summary),M.VIT28.code,"sap.ui.vk.dvl.Viewport");break;}}return this;};
v.prototype.setSelectionRect=function(f){if(!f){this._dvl.Renderer.DrawSelectionRect(0,0,0,0,this._dvlRendererId);}else{this._dvl.Renderer.DrawSelectionRect(f.x1,f.y1,f.x2,f.y2,this._dvlRendererId);}};
v.prototype.getOutputSize=function(){var f=this.getViewInfo().camera.bindingType,i=this.getDomRef().getBoundingClientRect(),j=i.width,m=i.height,x;switch(t.decodedBindingType[f]){case sap.ve.dvl.DVLCAMERAFOVBINDING.MIN:x=Math.min(j,m);break;case sap.ve.dvl.DVLCAMERAFOVBINDING.MAX:x=Math.max(j,m);break;case sap.ve.dvl.DVLCAMERAFOVBINDING.HORZ:x=j;break;case sap.ve.dvl.DVLCAMERAFOVBINDING.VERT:x=m;break;default:break;}return{left:(j-x)/2,top:(m-x)/2,sideLength:x};};
v.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
v.prototype.onAfterRendering=function(){var f=this.getDomRef();if(this._canvas){f.appendChild(this._canvas);}this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:f.clientWidth,height:f.clientHeight}});};
v.prototype._handleResize=function(f){if(this._dvlRendererId&&this._canvas){var i=f.size.width*window.devicePixelRatio;var j=f.size.height*window.devicePixelRatio;if(this._matProj){var m=this._matProj[0];var x=this._matProj[5];var y=Math.max(m,x);if(i>j){m=y*j/i;x=y;}else{m=y;x=y*i/j;}this._matProj[8]*=m/this._matProj[0];this._matProj[9]*=x/this._matProj[5];this._matProj[0]=m;this._matProj[5]=x;}this._dvl.Renderer.SetDimensions(i,j,this._dvlRendererId);this._dvl.Renderer.SetOptionF(sap.ve.dvl.DVLRENDEROPTIONF.DVLRENDEROPTIONF_DPI,96*window.devicePixelRatio,this._dvlRendererId);this._canvas.width=i;this._canvas.height=j;this._canvas.style.width=f.size.width+"px";this._canvas.style.height=f.size.height+"px";this.fireResize({size:{width:f.size.width,height:f.size.height}});return true;}};
v.prototype._handleVisibilityChanged=v.prototype._handleSelectionChanged=v.prototype._handleOpacityChanged=v.prototype._handleTintColorChanged=function(f){if(this._dvlRendererId){this._dvl.Renderer.ForceRenderFrame(this._dvlRendererId);}};
v.prototype.showHotspots=function(f,i,j){var m=sap.ui.vk.dvl.NodeProxy.prototype[typeof j==="string"?"setTintColor":"setTintColorABGR"];var x=function(N,j,T){var U=N.createNodeProxy(T);m.call(U,j);N.destroyNodeProxy(U);};if(!Array.isArray(f)){f=[f];}var y=j===undefined?this.getHotspotColorABGR():j;if(!i){y=0;}var N=this._viewStateManager.getNodeHierarchy();if(this._isSmart2DContent()){var O=[];f.forEach(function(T){var U=p(this._dvl.Scene.RetrieveNodeInfo(this._dvlSceneRef,T,sap.ve.dvl.DVLNODEINFO.DVLNODEINFO_CHILDREN).ChildNodes);Array.prototype.push.apply(O,U);}.bind(this));Array.prototype.push.apply(O,f);O.forEach(x.bind(null,N,y));}else{var P=[];var Q=function(T){var O=N.getChildren(T);Array.prototype.push.apply(P,O);O.forEach(Q);};f.forEach(Q);Array.prototype.push.apply(P,f);P.forEach(x.bind(null,N,y));}return this;};
v.prototype._getDecomposedABGR=function(i){return{red:(i>>>0&0xff)/255,green:(i>>>8&0xff)/255,blue:(i>>>16&0xff)/255,alpha:(i>>>24&0xff)/255};};
v.prototype._setBackgroundColor=function(){if(this._dvl){var f=this._getDecomposedABGR(this.getBackgroundColorTopABGR()),i=this._getDecomposedABGR(this.getBackgroundColorBottomABGR());this._dvl.Renderer.SetBackgroundColor(f.red,f.green,f.blue,f.alpha,i.red,i.green,i.blue,i.alpha,this._dvlRendererId);}};
v.prototype.setBackgroundColorTopABGR=function(i){this.setProperty("backgroundColorTopABGR",i,true);this._setBackgroundColor();return this;};
v.prototype.setBackgroundColorTop=function(f){this.setProperty("backgroundColorTop",f,true);return this.setBackgroundColorTopABGR(c(g(f)));};
v.prototype.setBackgroundColorBottomABGR=function(i){this.setProperty("backgroundColorBottomABGR",i,true);this._setBackgroundColor();return this;};
v.prototype.setBackgroundColorBottom=function(f){this.setProperty("backgroundColorBottom",f,true);return this.setBackgroundColorBottomABGR(c(g(f)));};
v.prototype.setShouldRenderFrame=function(){if(this._dvlRendererId){this._dvl.Renderer.ForceRenderFrame(this._dvlRendererId);}return this;};
v.prototype.shouldRenderFrame=function(){return this._dvlRendererId&&this._dvl.Renderer.ShouldRenderFrame(this._dvlRendererId);};
v.prototype.renderFrame=function(){if(this._dvlRendererId){if(this._matView&&this._matProj){this.renderFrameEx(this._matView,this._matProj,this._dvlRendererId);}else{this._dvl.Renderer.RenderFrame(this._dvlRendererId);}}return this;};
v.prototype.renderFrameEx=function(f,i){if(this._dvlRendererId){this._dvl.Renderer.RenderFrameEx.apply(this,[].concat(f,i),this._dvlRendererId);}return this;};
v.prototype.resetView=function(f){if(f!==undefined&&!q.isPlainObject(f)){q.sap.log.error(h().getText(M.VIT31.summary),M.VIT31.code,"sap.ui.vk.dvl.Viewport");}var i={camera:true,transition:true,visibility:false};q.extend(i,f);if(i.camera||i.visibility){var j=(i.camera?sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA:0)|(i.transition?sap.ve.dvl.DVLRESETVIEWFLAG.SMOOTHTRANSITION:0)|(i.visibility?sap.ve.dvl.DVLRESETVIEWFLAG.VISIBILITY:0);if(this._dvlRendererId){this._dvl.Renderer.ResetView(j,this._dvlRendererId);this._lastPlayedStep=null;}}return this;};
v.prototype.canIsolateNode=function(f){if(this._dvlRendererId){return this._dvl.Renderer.CanIsolateNode(f,this._dvlRendererId);}else{return false;}};
v.prototype.setIsolatedNode=function(f){if(this._dvlRendererId){this._dvl.Renderer.SetIsolatedNode(f,this._dvlRendererId);}return this;};
v.prototype.getIsolatedNode=function(){if(this._dvlRendererId){return this._dvl.Renderer.GetIsolatedNode(this._dvlRendererId);}else{return sap.ve.dvl.DVLID_INVALID;}};
v.prototype.hitTest=function(x,y){if(this._dvlRendererId){var f=this._dvl.Renderer.HitTest(x*window.devicePixelRatio,y*window.devicePixelRatio,this._dvlRendererId).id;this.setShouldRenderFrame();return f;}else{return null;}};
v.prototype.setShowDebugInfo=function(f){this.setProperty("showDebugInfo",f,true);if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_SHOW_DEBUG_INFO,f,this._dvlRendererId);}return this;};
v.prototype._handleFrameFinished=function(f){if(f.rendererId===this._dvlRendererId){this.fireFrameRenderingFinished();}};
v.prototype.beginGesture=function(x,y){if(this._dvlRendererId){this._gesturePoint={x:x,y:y};this._dvl.Renderer.BeginGesture(x*window.devicePixelRatio,y*window.devicePixelRatio,this._dvlRendererId);}return this;};
v.prototype.endGesture=function(){if(this._dvlRendererId){this._dvl.Renderer.EndGesture(this._dvlRendererId);}return this;};
v.prototype._activateRedline=function(){this.renderFrame();var m=this._dvl.Renderer.GetCameraMatrices();this._matView=m.view;this._matProj=m.projection;};
v.prototype._deactivateRedline=function(){this._matView=null;this._matProj=null;};
v.prototype.pan=function(f,i){if(this._dvlRendererId&&!this.getFreezeCamera()){if(this._matProj){var j=this.getDomRef();this._matProj[8]-=f*2/j.clientWidth;this._matProj[9]+=i*2/j.clientHeight;this.setShouldRenderFrame();}else{this._dvl.Renderer.Pan(f*window.devicePixelRatio,i*window.devicePixelRatio,this._dvlRendererId);}this.firePan({dx:f,dy:i});}return this;};
v.prototype.rotate=function(f,i){if(this._dvlRendererId&&!this.getFreezeCamera()){this._dvl.Renderer.Rotate(f*window.devicePixelRatio,i*window.devicePixelRatio,this._dvlRendererId);this.fireRotate({dx:f,dy:i});}return this;};
function G(f){var m=f;var i=m[15]===1;var j=2/m[0];var x=2/m[5];var y,N;if(i){y=-m[12]*j;N=-m[13]*x;}else{y=m[8]*j;N=m[9]*x;}var O=(j+y)*0.5;var P=y-O;var Q=(x+N)*0.5;var T=N-Q;return{left:P,top:Q,right:O,bottom:T};}
function H(f,i){var m=f;var j=m[15]===1;m[0]=2/(i.right-i.left);m[5]=2/(i.top-i.bottom);if(j){m[12]=-(i.right+i.left)/(i.right-i.left);m[13]=-(i.top+i.bottom)/(i.top-i.bottom);}else{m[8]=(i.right+i.left)/(i.right-i.left);m[9]=(i.top+i.bottom)/(i.top-i.bottom);}}
v.prototype.zoom=function(i){if(this._dvlRendererId&&!this.getFreezeCamera()){if(this._matProj){var j=this.getDomRef();var m=G(this._matProj);var x=m.left+(m.right-m.left)*this._gesturePoint.x/j.clientWidth;var y=m.top+(m.bottom-m.top)*this._gesturePoint.y/j.clientHeight;var f=1/i;m.left=x+(m.left-x)*f;m.right=x+(m.right-x)*f;m.top=y+(m.top-y)*f;m.bottom=y+(m.bottom-y)*f;H(this._matProj,m);this.setShouldRenderFrame();}else{this._dvl.Renderer.Zoom(i,this._dvlRendererId);}this.fireZoom({zoomFactor:i});}return this;};
v.prototype.zoomTo=function(f,j,m,x){if(this._dvlRendererId){var y=0;if(Array.isArray(f)){for(var i in f){y|=t.decodedZoomTo[f[i]];}}else{y=t.decodedZoomTo[f];}this._dvl.Renderer.ZoomTo(y,j,m,x,this._dvlRendererId);}return this;};
v.prototype.tap=function(x,y,i){if(this._dvlRendererId){var f=x*window.devicePixelRatio,j=y*window.devicePixelRatio;if(!i){var m=this.hitTest(x,y);var N={picked:m===sap.ve.dvl.DVLID_INVALID||m==null?[]:[m]};this.fireNodesPicked(N);if(this.getSelectionMode()===S.Exclusive){this.exclusiveSelectionHandler(N.picked);}else if(this.getSelectionMode()===S.Sticky){this.stickySelectionHandler(N.picked);}if(m!==sap.ve.dvl.DVLID_INVALID){this.fireNodeClicked({nodeRef:m,nodeId:m,x:x,y:y},true,true);}this._dvl.Renderer.Tap(f,j,false,false,this._dvlRendererId);}else if(!this.getFreezeCamera()){this._dvl.Renderer.Tap(f,j,true,false,this._dvlRendererId);}}return this;};
v.prototype.rectSelect=function(x,y,f,i){var j=[];if(this._dvlRendererId){var m=p(this._dvl.Renderer.RectSelect(x,y,f,i,this._dvlRendererId));if(m.SelectedNodes){j=m.SelectedNodes;}}return j;};
v.prototype.queueCommand=function(f){if(this._dvlRendererId){this._dvl.Renderer._queueCommand(f,this._dvlRendererId);}return this;};
v.prototype._setContent=function(f){var i=null;if(f&&f instanceof r){i=f;}this._setScene(i);};
v.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
v.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};
v.prototype._handleContentReplaced=function(f){var i=f.getParameter("newContent");this._setContent(i);};
v.prototype._setScene=function(f){var i=f&&f.getGraphicsCore();this.setGraphicsCore(i);this.setScene(f);if(f&&(this._isSmart2DContent()||this._isSmart2DContentLegacy())){this._initializeSmart2DHandler();}};
v.prototype._handleContentChangesFinished=function(f){if(f.getSource().getContentResources().length>1){this.zoomTo(Z.Visible,sap.ve.dvl.DVLID_INVALID,0,0);}this.setShouldRenderFrame();};
v.prototype._onAfterUpdateViewStateManager=function(){if(this._dvl){this._dvl.Renderer.SetViewStateManager(this._viewStateManager,this._dvlRendererId);}};
v.prototype._onBeforeClearViewStateManager=function(){if(this._dvl){this._dvl.Renderer.SetViewStateManager(null,this._dvlRendererId);}};
var I={x:-2,y:-2};var J=2;var K=5;[{key:"left",dx:-J,dy:0},{key:"right",dx:+J,dy:0},{key:"up",dx:0,dy:-J},{key:"down",dx:0,dy:+J}].forEach(function(i){v.prototype["onsap"+i.key]=function(f){this.beginGesture(I.x,I.y);this.rotate(i.dx,i.dy);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();};});[{key:"left",dx:-K,dy:0},{key:"right",dx:+K,dy:0},{key:"up",dx:0,dy:-K},{key:"down",dx:0,dy:+K}].forEach(function(i){v.prototype["onsap"+i.key+"modifiers"]=function(f){if(f.shiftKey&&!(f.ctrlKey||f.altKey||f.metaKey)){this.beginGesture(I.x,I.y);this.pan(i.dx,i.dy);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();}};});[{key:"minus",d:0.98},{key:"plus",d:1.02}].forEach(function(i){v.prototype["onsap"+i.key]=function(f){this.beginGesture(this.$().width()/2,this.$().height()/2);this.zoom(i.d);this.endGesture();this.setShouldRenderFrame();f.preventDefault();f.stopPropagation();};});e.injectMethodsIntoClass(v);n.injectMethodsIntoClass(v);return v;});
sap.ui.predefine('sap/ui/vk/dvl/ViewportRenderer',[],function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitViewport");r.writeClasses();r.writeAttribute("tabindex",0);r.writeAttribute("aria-label","Image");var a=false;var w=c.getWidth();if(w){r.addStyle("width",w);a=true;}var h=c.getHeight();if(h){r.addStyle("height",h);a=true;}if(a){r.writeStyles();}r.write(">");var i,l;var t=c.getTools();for(i=0,l=t.length;i<l;i++){var _=sap.ui.getCore().byId(t[i]);var b=_.getGizmoForContainer(c);if(b&&b.render===undefined){r.renderControl(b);}}var C=c.getContent();for(i=0,l=C.length;i<l;i++){r.renderControl(C[i]);}r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/dvl/checkResult',["sap/base/Log","../DvlException"],function(L,D){"use strict";var c=function(r){if(r<0){var m=sap.ve.dvl.DVLRESULT.getDescription?sap.ve.dvl.DVLRESULT.getDescription(r):"";L.error(m,JSON.stringify({errorCode:r}),"sap.ve.dvl");throw new D(r,m);}return r;};return c;},true);
sap.ui.predefine('sap/ui/vk/dvl/getJSONObject',["sap/base/Log","../DvlException"],function(L,D){"use strict";var g=function(o){if(typeof o==="number"){var r=o;var m=sap.ve.dvl.DVLRESULT.getDescription?sap.ve.dvl.DVLRESULT.getDescription(r):"";L.error(m,JSON.stringify({errorCode:r}),"sap.ve.dvl");throw new D(r,m);}return o;};return g;},true);
sap.ui.predefine('sap/ui/vk/dvl/getPointer',["sap/base/Log","../DvlException"],function(L,D){"use strict";var g=function(p){if(typeof p==="number"){var r=p;var m=sap.ve.dvl.DVLRESULT.getDescription?sap.ve.dvl.DVLRESULT.getDescription(r):"";L.error(m,JSON.stringify({errorCode:r}),"sap.ve.dvl");throw new D(r,m);}return p;};return g;},true);
sap.ui.predefine('sap/ui/vk/getResourceBundle',["sap/ui/core/Core","sap/base/util/ObjectPath"],function(c,O){"use strict";var g=function(){var r=c.getLibraryResourceBundle("sap.ui.vk.i18n");O.get("sap.ui.vk").getResourceBundle=function(){return r;};return r;};return g;},true);
sap.ui.predefine('sap/ui/vk/helpers/RotateOrbitHelperDvl',["sap/ui/base/EventProvider"],function(E){"use strict";
var R=E.extend("sap.ui.vk.helpers.RotateOrbitHelperDvl",{
metadata:{publicMethods:["rotate"]},
constructor:function(a,D){this._tool=a;this._dvl=D;this._dvlRendererId=this._tool._viewport._dvlRendererId;}
});
R.prototype.destroy=function(){this._rotateOrbitTool=null;};
R.prototype.activateOrbitMode=function(){if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_CAMERA_ROTATION_MODE_ORBIT,true);}return this;};
R.prototype.deactivateOrbitMode=function(){if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_CAMERA_ROTATION_MODE_ORBIT,false);}return this;};
R.prototype.rotate=function(d,a){if(this._dvlRendererId){this._dvl.Renderer.Rotate(d*window.devicePixelRatio,a*window.devicePixelRatio,this._dvlRendererId);this._tool.fireRotate({dx:d,dy:a});}return this;};
return R;});
sap.ui.predefine('sap/ui/vk/helpers/RotateOrbitHelperThree',["sap/ui/base/EventProvider"],function(E){"use strict";
var R=E.extend("sap.ui.vk.helpers.RotateOrbitHelperThree",{
metadata:{publicMethods:["rotate"]},
constructor:function(r){this._tool=r;}
});
R.prototype.destroy=function(){this._tool=null;};
R.prototype.activateOrbitMode=function(){this._tool._viewport._viewportGestureHandler._cameraController.isTurnTableMode=false;return this;};
R.prototype.deactivateOrbitMode=function(){this._tool._viewport._viewportGestureHandler._cameraController.isTurnTableMode=true;return this;};
R.prototype.rotate=function(d,a){this._tool._viewport._viewportGestureHandler._cameraController.rotate(d,a,false);return this;};
return R;});
sap.ui.predefine('sap/ui/vk/helpers/RotateTurntableHelperDvl',["sap/ui/base/EventProvider"],function(E){"use strict";
var R=E.extend("sap.ui.vk.helpers.RotateTurntableHelperDvl",{
metadata:{publicMethods:["rotate"]},
constructor:function(a,D){this._tool=a;this._dvl=D;this._dvlRendererId=this._tool._viewport._dvlRendererId;}
});
R.prototype.destroy=function(){this._rotateOrbitTool=null;};
R.prototype.activateTurntableMode=function(){if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_CAMERA_ROTATION_MODE_ORBIT,false);}return this;};
R.prototype.deactivateTurntableMode=function(){if(this._dvlRendererId){this._dvl.Renderer.SetOption(sap.ve.dvl.DVLRENDEROPTION.DVLRENDEROPTION_CAMERA_ROTATION_MODE_ORBIT,true);}return this;};
R.prototype.rotate=function(d,a){if(this._dvlRendererId){this._dvl.Renderer.Rotate(d*window.devicePixelRatio,a*window.devicePixelRatio,this._dvlRendererId);this._tool.fireRotate({dx:d,dy:a});}return this;};
return R;});
sap.ui.predefine('sap/ui/vk/helpers/RotateTurntableHelperThree',["sap/ui/base/EventProvider"],function(E){"use strict";
var R=E.extend("sap.ui.vk.helpers.RotateTurntableHelperThree",{
metadata:{publicMethods:["rotate"]},
constructor:function(r){this._tool=r;}
});
R.prototype.destroy=function(){this._tool=null;};
R.prototype.activateTurntableMode=function(){this._tool._viewport._viewportGestureHandler._cameraController.isTurnTableMode=true;return this;};
R.prototype.deactivateTurntableMode=function(){this._tool._viewport._viewportGestureHandler._cameraController.isTurnTableMode=false;return this;};
R.prototype.rotate=function(d,a){this._tool._viewport._viewportGestureHandler._cameraController.rotate(d,a,true);this._tool.fireRotate({dx:d,dy:a});return this;};
return R;});
sap.ui.predefine('sap/ui/vk/threejs/AnimationHelper',["./thirdparty/three","../View","../AnimationPlayback"],function(t,V,A){"use strict";var a=function(){};
a.prototype._getChildNodesWithMaterial=function(p,c){for(var b=0;p.children&&b<p.children.length;b++){var d=p.children[b];if(d&&d.material&&d.material.color){c.push(d);}this._getChildNodesWithMaterial(d,c);}};
a.prototype.addAnimationTracksToHighlight=function(h){var d=h.duration;if(!h.cycles){h.cycles=0;}else{d/=2;}var n=false;var o;for(o=0;h.opacities&&o<h.opacities.length;o++){if(h.opacities[o]!==1){n=true;break;}}var b;var k,e;if(n){b={};b.times=[];b.values=[];e=h.duration/h.opacities.length;for(k=0;k<h.cycles+1;k++){for(o=0;o<h.opacities.length;o++){b.values.push(h.opacities[o]);b.times.push(e*(k*h.opacities.length+o));if(h.type==="STATIC"){break;}}if(h.type==="STATIC"){break;}}b.data={};b.data.type="OPACITY";b.data.highlight=h;h.duration=b.times[b.times.length-1];}var f=false;var g;for(g=0;h.colours&&g<h.colours.length;g++){var c=h.colours[g];if(c[3]!==0&&(c[0]!==0||c[1]!==0||c[2]!==0)){f=true;break;}}var i;if(f){if(h.type==="INFINITE"&&h.colours.length===1){var j=[0,0,0,0];h.colours.push(j);}i={};i.times=[];i.values=[];e=h.duration/h.colours.length;for(k=0;k<h.cycles+1;k++){for(g=0;g<h.colours.length;g++){var l=h.colours[g];i.values.push(l[0],l[1],l[2],l[3]);i.times.push(e*(k*h.opacities.length+g));if(h.type==="STATIC"){break;}}if(h.type==="STATIC"){break;}}i.data={};i.data.type="COLOR";i.data.highlight=h;h.duration=i.times[i.times.length-1];}if(i){h.colorTrack=i;}if(b){h.opacityTrack=b;}};
a.prototype.processHighlights=function(v,b,s){if(!v.highlights||!v.highlights.length){return;}var m=0;var h;var c;var d=false;for(h=0;h<v.highlights.length;h++){c=v.highlights[h];if(m<c.duration){m=c.duration;}if(c.type==="INFINITE"){d=true;}}var p=v.getPlaybacks();var e=b+"-"+"highlightSequence";var f=b+"-"+"highlightPlayback";var g=s.getAnimationSequence(e);var i;if(!g){g=s.createAnimationSequence(e);g.setHasHighlight(true);if(!p){p=[];}i=new A({sequenceId:e,pid:f,infinite:d,startTime:0});p.push(i);v.setPlaybacks(p);}for(var j=0;p&&j<p.length;j++){var k=p[j];var l=s.getAnimationSequence(k.getSequenceId());if(l){var n=l.getDuration();if(n>m){m=n;}if(!i&&k.getPid()===f){i=k;}}}if(!i){i=new A({sequenceId:e,pid:f,infinite:d,startTime:0});if(!p){p=[];}p.push(i);v.setPlaybacks(p);}if(Math.abs(m-0.0)<1e-6){m=0.001;}if(d){i.setInfinite(true);}if(!g.userData){g.userData={};}var r=true;if(!g.userData.maxDuration||Math.abs(g.userData.maxDuration-m)<1e-6){g.userData.maxDuration=m;}else{r=false;}for(h=0;h<v.highlights.length;h++){c=v.highlights[h];this._processHighlight(c,g,r);}};
a.prototype._processHighlight=function(h,b,r){if(!h||(!h.opacityTrack&&!h.colorTrack)||!b){return;}if(!b.userData.highlights){b.userData.highlights=new Map();}for(var c=0;h.highlightNodes&&c<h.highlightNodes.length;c++){var n=h.highlightNodes[c];var d=[];if(n.material&&n.material.color){d.push(n);}else{this._getChildNodesWithMaterial(n,d);}if(d.length===0){continue;}var s=b.userData.highlights.get(n);if(s&&(!r)){continue;}else{b.userData.highlights.set(n,h);}if(h.opacityTrack){if(h.type==="STATIC"&&h.opacityTrack.values.length===1){h.opacityTrack.times.push(b.userData.maxDuration);h.opacityTrack.values.push(h.opacityTrack.values[h.opacityTrack.values.length-1]);}b.setOpacityTrack(n,h.opacityTrack.times,h.opacityTrack.values,"linear",true);}if(h.colorTrack){var e=false;if(h.colorTrack.times.length>1&&h.type!=="INFINITE"){e=true;}for(var f=0;f<d.length;f++){var N=d[f];var g=N.material;if(N.userData&&N.userData.originalMaterial){g=N.userData.originalMaterial;}var i=new THREE.Color();var j;var k={};k.times=[];k.values=[];k.data=h.colorTrack.data;var l=0.0;if(e){l=0.05;k.times.push(0.0);k.values.push(g.color.r,g.color.g,g.color.b);}for(j=0;j<h.colorTrack.times.length;j++){k.times.push(h.colorTrack.times[j]+l);i.fromArray(h.colorTrack.values,j*4).lerp(g.color,1-h.colorTrack.values[j*4+3]);k.values.push(i.r,i.g,i.b);}if(e){k.times.push(k.times[k.times.length-1]+0.05);k.values.push(g.color.r,g.color.g,g.color.b);}if(h.type==="INFINITE"){var m=0.05;if(k.times.length>1){m=k.times[k.times.length-1]-k.times[k.times.length-2];}l=k.times[k.times.length-1]+m;var o=l;while(o<b.userData.maxDuration){for(j=0;j<h.colorTrack.times.length&&o<b.userData.maxDuration;j++){o=h.colorTrack.times[j]+l;k.times.push(o);i.fromArray(h.colorTrack.values,j*4).lerp(g.color,1-h.colorTrack.values[j*4+3]);k.values.push(i.r,i.g,i.b);}l=o+m;}}if(h.type==="STATIC"&&k.values.length===1){k.times.push(b.userData.maxDuration);var v=k.values[k.values.length-3];var p=k.values[k.values.length-2];var q=k.values[k.values.length-1];k.values.push(v,p,q);}b.setColorTrack(N,k.times,k.values,"linear",true);}}}};
a.prototype.insertTracks=function(b,c,n,s){var d=new Map();var e,f,g;var h,i;for(h=0;h<b.length;h++){e=b[h];var j=c.get(e.id);if(!j||!j.length){continue;}for(i=0;i<j.length;i++){f=n.get(j[i].targetId);if(!f){continue;}var N=d.get(j[i].sequenceId);if(!N){N=new Map();}g=N.get(f);if(!g){g=[];}e.data=j[i];g.push(e);N.set(f,g);d.set(j[i].sequenceId,N);}c.delete(e.id);}var k=d.entries();var l=k.next();while(!l.done){var m=l.value[0];var o=l.value[1];l=k.next();var p=s.getAnimationSequence(m);if(!p){continue;}var q=o.entries();var r=q.next();while(!r.done){f=r.value[0];g=r.value[1];r=q.next();var u=null;for(h=0;h<g.length;h++){e=g[h];if(e.data.pivot){u=e.data.pivot;break;}}var v={};var w={};var x={};for(h=0;h<g.length;h++){e=g[h];if(e.data.type==="TRANSLATE"){v=e;}else if(e.data.type==="ROTATE"){x=e;}else if(e.data.type==="SCALE"){w=e;}else if(e.data.type==="OPACITY"){p.setOpacityTrack(f,e.times,e.values,e.interpolation,e.cyclicInfo);}else if(e.data.type==="COLOR"){p.setColorTrack(f,e.times,e.values,e.interpolation,e.cyclicInfo);}}p.setPositionTracks(f,x.times,v.times,w.times,x.rotateType,x.values,v.values,w.values,u,x.interpolation,v.interpolation,w.interpolation,x.cyclicInfo,v.cyclicInfo,w.cyclicInfo);}}return this;};
a.prototype.setInitialNodePositionsFromSubsequentViews=function(v,s,o){if(!v||!v.length){return;}var b,n,c;var d=new Map();for(var e=v.length-1;e>0;e--){var f=v[e];var g;if(f){g=f.getPlaybacks();}if(g){for(var p=g.length-1;p>=0;p--){var h=g[p];if(h){b=s.getAnimationSequence(h.getSequenceId());if(b){if(o&&!b.hasHighlight()){continue;}if(!h.getReversed()){n=b.getNodesStartValues().entries();}else{n=b.getNodesEndValues().entries();}c=n.next();while(!c.done){d.set(c.value[0],c.value[1]);c=n.next();}}}}}var i=v[e-1];if(i){if(!i.userData){i.userData={};}if(!i.userData.nodeStartDataByAnimation){i.userData.nodeStartDataByAnimation=new Map();}n=d.entries();c=n.next();while(!c.done){i.userData.nodeStartDataByAnimation.set(c.value[0],c.value[1]);c=n.next();}}}};
a.prototype.setInitialNodePositionsFromPreviousViews=function(v,s,o){if(!v||!v.length){return;}var b,n,c;var d=new Map();for(var e=0;e<v.length-1;e++){var p=v[e];var f;if(p){f=p.getPlaybacks();}if(f){for(var g=0;g<f.length;g++){var h=f[g];if(h){b=s.getAnimationSequence(h.getSequenceId());if(b){if(o&&!b.hasHighlight()){continue;}if(!h.getReversed()){n=b.getNodesEndValues().entries();}else{n=b.getNodesStartValues().entries();}c=n.next();while(!c.done){d.set(c.value[0],c.value[1]);c=n.next();}}}}}var i=v[e+1];if(i){if(!i.userData){i.userData={};}if(!i.userData.nodeStartDataByAnimation){i.userData.nodeStartDataByAnimation=new Map();}n=d.entries();c=n.next();while(!c.done){i.userData.nodeStartDataByAnimation.set(c.value[0],c.value[1]);c=n.next();}}}};
a.prototype.setInitialNodePositionsOnView=function(v,s,o){if(!v){return;}var n,b;var c=0;var d=null;d=v.getPlaybacks();if(!d||!d.length){return;}if(!v.userData){v.userData={};}if(!v.userData.nodeStartDataByAnimation){v.userData.nodeStartDataByAnimation=new Map();}for(var e=d.length-1;e>=c;e--){var p=d[e];var f=s.getAnimationSequence(p.getSequenceId());if(f){if(o&&!f.hasHighlight()){continue;}if(p.getReversed()){n=f.getNodesEndValues().entries();}else{n=f.getNodesStartValues().entries();}b=n.next();while(!b.done){v.userData.nodeStartDataByAnimation.set(b.value[0],b.value[1]);b=n.next();}}}};
a.prototype.setInitialNodePositionsFromCurrenetViews=function(v,s,o){if(!v||!v.length){return;}for(var b=0;b<v.length;b++){var c=v[b];if(!c){continue;}this.setInitialNodePositionsOnView(c,s,o);}};
a.prototype.setPlaybackStartTimes=function(v,s){if(!v||!v.length){return;}for(var b=0;b<v.length;b++){var c=v[b];if(!c){continue;}var d=null;if(c){d=c.getPlaybacks();}if(!d||!d.length){continue;}var e=0;for(var f=0;f<d.length;f++){var p=d[f];var g=s.getAnimationSequence(p.getSequenceId());if(g&&g.hasHighlight()){continue;}var h;if(g){h=g.getNativeAnimationClip();}if(h&&!h.hasOptimized){h.resetDuration();h.optimize();h.hasOptimized=true;}if(h){p.setStartTime(e);var i=1;if(p.getTimeScale()&&p.getTimeScale()>0){i=1/p.getTimeScale();}var r=1;if(p.getRepeat()>1){r=p.getRepeat();}e+=p.getPreDelay()+r*g.getDuration()*i+p.getPostDelay();}}}};
a.prototype.prepareViewForAnimation=function(v){var n;if(v&&v.getNodeInfos){n=v.getNodeInfos();}if(!n){return;}if(!v.userData){v.userData={};}if(!v.userData.nodesDataByView){v.userData.nodesDataByView=new Map();}else{return;}function b(g){return new THREE.Matrix4().set(g[0],g[1],g[2],g[3],g[4],g[5],g[6],g[7],g[8],g[9],g[10],g[11],0,0,0,1);}for(var c=0;c<n.length;c++){var d=n[c];if(!d||!d.target){continue;}var e={};if(d.transform){e.position=new THREE.Vector3();e.scale=new THREE.Vector3();e.quaternion=new THREE.Quaternion();var f=b(d.transform);f.decompose(e.position,e.quaternion,e.scale);v.userData.nodesDataByView.set(d.target,e);}}};
a.prototype.getNodePositionByView=function(v,n){var d;if(!v){return d;}if(!v.userData||!v.userData.nodesDataByView){this.prepareViewForAnimation(v);}if(v.userData&&v.userData.nodesDataByView){d=v.userData.nodesDataByView.get(n);}return d;};
a.prototype.getNodePositionFromNearestPlayback=function(s,v,b,n){var d;if(!v||!s){return d;}var p=v.getPlaybacks();if(!p){return d;}var c,e;var f=0;for(c=0;c<p.length;c++){e=p[c];if(b==e.getSequenceId()){f=e.getStartTime();break;}}var m=0;for(c=0;c<p.length;c++){e=p[c];var g=e.getStartTime();if(f<=g){continue;}if(b==e.getSequenceId()){continue;}var h=s.getAnimationSequence(e.getSequenceId());if(h){var i;if(e.getReversed()){i=h.getNodesStartValues();}else{i=h.getNodesEndValues();}var j=i.get(n);if(j&&g>=m){d=j;m=g;}}}return d;};
return a;});
sap.ui.predefine('sap/ui/vk/threejs/AnimationSequence',["jquery.sap.global","../AnimationSequence","../AnimationTrackType","../AnimationRotateType","../AnimationInterpolationType"],function(Q,A,a,b,d){"use strict";
var f=A.extend("sap.ui.vk.threejs.AnimationSequence",{
metaData:{},
constructor:function(i,n,c){A.call(this);var t=[];this._animationClip=new THREE.AnimationClip(n,-1,t);if(c){this._duration=c;this._animationClip.duration=c;}else{this._duration=0;}this._nodesEndData=new Map();this._nodesStartData=new Map();this._nodesPositionTracksMap=new Map();this._nodesOpacityTrackMap=new Map();this._nodesColorTrackMap=new Map();this._hasHighlight=false;this.setName(n);this.setSequenceId(i);}
});
var M=4;
f.prototype._getMatrixFromEulerRotationAngles=function(x,y,z,o){var g=function(j,k){var c=Math.cos(j);var s=Math.sin(j);var l=1;var n=0;var p=0;var q=0;var t=1;var u=0;var v=0;var w=0;var B=1;if(k===0){t=c;u=-s;w=s;B=c;}else if(k===1){l=c;p=s;v=-s;B=c;}else{l=c;n=-s;q=s;t=c;}var m=new THREE.Matrix4();m.set(l,n,p,0,q,t,u,0,v,w,B,0,0,0,0,1);return m;};o=Math.round(o);var r=new THREE.Matrix4();var e;for(var h=0;h<3;h++){var i=(o>>(h*2))&3;var j=z;if(i===0){j=x;}else if(i===1){j=y;}e=g(j,i);r.premultiply(e);}return r;};
f.prototype._getRotationMatrix=function(i,c,r,t,e){var x,y,z;var v,g;if(t===b.euler){v=[r[i*4],r[i*4+1],r[i*4+2],r[i*4+3]];if(i===c){return this._getMatrixFromEulerRotationAngles(v[0],v[1],v[2],v[3]);}g=[r[c*4],r[c*4+1],r[c*4+2],r[c*4+3]];var o=v[3];x=v[0]*(1-e)+g[0]*e;y=v[1]*(1-e)+g[1]*e;z=v[2]*(1-e)+g[2]*e;return this._getMatrixFromEulerRotationAngles(x,y,z,o);}else if(t===b.angleAxis){var h=new THREE.Matrix4();var j,k,l;for(var m=0;m<=i;m++){x=r[m*4];y=r[m*4+1];z=r[m*4+2];j=r[m*4+3];k=new THREE.Vector3(x,y,z);l=new THREE.Matrix4();l.makeRotationAxis(k,j);h.premultiply(l);}if(i===c){return h;}x=r[c*4];y=r[c*4+1];z=r[c*4+2];j=r[c*4+3]*e;k=new THREE.Vector3(x,y,z);var n=new THREE.Matrix4();n.makeRotationAxis(k,j);n.multiply(h);return n;}else{var q;v=[r[i*4],r[i*4+1],r[i*4+2],r[i*4+3]];if(i===c){q=new THREE.Quaternion(v[0],v[1],v[2],v[3]);}var p=new THREE.Matrix4();if(q){p.makeRotationFromQuaternion(q);return p;}g=[r[c*4],r[c*4+1],r[c*4+2],r[c*4+3]];var E=0.001;var s;var u;var B;var F;var C=v[0];var D=v[1];var G=v[2];var H=v[3];var I=g[0];var J=g[1];var K=g[2];var L=g[3];var N;var O;N=C*I+D*J+G*K+H*L;if(N<0.0){N=-N;F=true;}else{F=false;}if(N>1.0){N=1.0;}if((1.0-N)<E){s=1.0-e;}else{u=Math.acos(N);B=u;O=Math.sin(u);s=Math.sin(u-e*B)/O;e=Math.sin(e*B)/O;}if(F){e=-e;}x=s*C+e*I;y=s*D+e*J;z=s*G+e*K;var w=s*H+e*L;q=new THREE.Quaternion(x,y,z,w);p.makeRotationFromQuaternion(q);return p;}};
f.prototype._getScaleMatrix=function(v,c,e){var x=1,y=1,z=1;if(v&&!c){x=v[0];y=v[1];z=v[2];}else if(!v&&c){x=c[0];y=c[1];z=c[2];}else if(v&&c){x=v[0]*(1-e)+c[0]*e;y=v[1]*(1-e)+c[1]*e;z=v[2]*(1-e)+c[2]*e;}var s=new THREE.Matrix4();s.makeScale(x,y,z);return s;};
f.prototype._getTranslateMatrix=function(v,c,e){var x=0,y=0,z=0;if(v&&!c){x=v[0];y=v[1];z=v[2];}else if(!v&&c){x=c[0];y=c[1];z=c[2];}else if(v&&c){x=v[0]*(1-e)+c[0]*e;y=v[1]*(1-e)+c[1]*e;z=v[2]*(1-e)+c[2]*e;}var t=new THREE.Matrix4();t.makeTranslation(x,y,z);return t;};
f.prototype.getTrack=function(t,c){var e=this._nodesPositionTracksMap.get(t);var g;if(c===a.scale&&e&&e.scale&&e.scale.times&&e.scale.times.length){g={};g.times=e.scale.times.slice();g.values=e.scale.values.slice();g.interpolation=e.scale.interpolation;g.cyclicEnd=e.scale.cyclicEnd;g.cyclicStart=e.scale.cyclicStart;}else if(c===a.translate&&e&&e.translate&&e.translate.times&&e.translate.times.length){g={};g.times=e.translate.times.slice();g.values=e.translate.values.slice();g.interpolation=e.translate.interpolation;g.cyclicEnd=e.translate.cyclicEnd;g.cyclicStart=e.translate.cyclicStart;}else if(c===a.rotate&&e&&e.rotate&&e.rotate.times&&e.rotate.times.length){g={};g.times=e.rotate.times.slice();g.values=e.rotate.values.slice();g.interpolation=e.rotate.interpolation;g.rotateType=e.rotate.rotateType;g.cyclicEnd=e.rotate.cyclicEnd;g.cyclicStart=e.rotate.cyclicStart;}else if(c===a.opacity){var o=this._nodesOpacityTrackMap.get(t);if(o){g={};g.times=o.times.slice();g.values=o.values.slice();g.interpolation=o.interpolation;g.cyclicEnd=o.cyclicEnd;g.cyclicStart=o.cyclicStart;}}else if(c===a.color){var h=this._nodesColorTrackMap.get(t);if(h){g={};g.times=h.times.slice();g.values=h.values.slice();g.interpolation=h.interpolation;g.cyclicEnd=h.cyclicEnd;g.cyclicStart=h.cyclicStart;}}return g;};
f.prototype._resetDuration=function(){this._animationClip.resetDuration();if(this._duration>0){this._animationClip.duration=this._duration;}};
f.prototype.setPositionTracks=function(t,c,e,g,r,h,i,s,p,j,k,l,m,n,o){if(!t){return;}var q=this._nodesPositionTracksMap.get(t);if(!q){q={};q.rotate={};q.translate={};q.scale={};}var u=false;if(c&&h&&c.length>0&&c.length*4===h.length){q.rotate.times=c.slice();q.rotate.values=h.slice();q.rotate.rotateType=r;if(j){q.rotate.interpolation=j;}else{q.rotate.interpolation=d.linear;}u=true;if(m){q.rotate.cyclicStart=m.cyclicStart;q.rotate.cyclicEnd=m.cyclicEnd;}}if(e&&i&&e.length>0&&e.length*3===i.length){q.translate.times=e.slice();q.translate.values=i.slice();if(k){q.translate.interpolation=k;}else{q.translate.interpolation=d.linear;}u=true;if(n){q.translate.cyclicStart=n.cyclicStart;q.translate.cyclicEnd=n.cyclicEnd;}}if(g&&s&&g.length>0&&g.length*3===s.length){q.scale.times=g.slice();q.scale.values=s.slice();if(l){q.scale.interpolation=l;}else{q.scale.interpolation=d.linear;}u=true;if(o){q.scale.cyclicStart=o.cyclicStart;q.scale.cyclicEnd=o.cyclicEnd;}}if(!u){return;}if(p){q.pivot=p.slice();}this._nodesPositionTracksMap.set(t,q);this._setNativePositionTracks(t);this._resetDuration();};
f.prototype.getPivot=function(t){var p;var c=this._nodesPositionTracksMap.get(t);if(c&&c.pivot){p=c.pivot.slice();}return p;};
f.prototype.setPivot=function(t,p){var c=this._nodesPositionTracksMap.get(t);if(!c){return;}c.pivot=p.slice();this._setNativePositionTracks(t);this._resetDuration();};
f.prototype.resetOriginalPosition=function(t,q,p,s){var c=this._nodesPositionTracksMap.get(t);if(!c){return;}if(!c.originalData){c.originalData={};}if(q){c.originalData.quaternion=new THREE.Quaternion(q[0],q[1],q[2],q[3]);}else if(!c.originalData.quaternion){c.originalData.quaternion=t.quaternion.clone();}if(p){c.originalData.position=new THREE.Vector3(p[0],p[1],p[2]);}else if(!c.originalData.position){c.originalData.position=t.position.clone();}if(s){c.originalData.scale=new THREE.Vector3(s[0],s[1],s[2]);}else if(!c.originalData.scale){c.originalData.scale=t.scale.clone();}this._setNativePositionTracks(t);};
f.prototype._extendTrackForCyclicStart=function(t,v,c,C){if(!t||t.length===0||!v||v.length===0){return;}var i=C.length/c.length;var s=t[0];var k,e;while(s>0){var m=0;for(k=c.length-1;k>=0;--k){var g=0;if(c.length!==1){if(k===c.length-1){g=0;}else{g=c[k+1]-c[k];}s=s-g;if(g>m){m=g;}}else{s=0;}for(e=i-1;e>=0;e--){v.unshift(C[k*i+e]);}if(s>=0){t.unshift(s);}else{t.unshift(0);break;}}if(s>0&&Math.abs(m-0)<1e-6){s=0;t.unshift(s);for(e=i-1;e>=0;e--){v.unshift(C[e]);}}}};
f.prototype._extendTrackForCyclicEnd=function(t,v,c,C){if(!t||t.length===0||!v||v.length===0){return;}var i=C.length/c.length;var e=t[t.length-1];var g=this.getDuration();var k,h;while(e<g){var m=0;for(k=0;k<c.length;++k){var j=0;if(c.length!==1){if(k===0){j=0.0;}else{j=c[k]-c[k-1];}e=e+j;if(j>m){m=j;}}else{e=g;}for(h=0;h<i;h++){v.push(C[k*i+h]);}t.push(e);if(e>=g){break;}}if(e<g&&Math.abs(m-0)<1e-6){e=g;t.push(e);for(h=i;h>0;h--){v.push(C[C.length-h]);}}}};
f.prototype._resetRotateTimes=function(r,c,e,t,s){var g=[];if(!r||r.length===0){return g;}var m=Math.PI/6;var h,k;g.push(r[0]);for(k=1;k<r.length;k++){var i=r[k-1];var j=r[k];if(e===b.angleAxis){var l=c[k*4+3];h=Math.ceil(l/m);}else if(e===b.euler){var n=0;for(var o=0;o<3;o++){var p=Math.abs(c[(k)*4+o]-c[(k-1)*4+o]);if(n<p){n=p;}}h=Math.ceil(n/m);}else{h=Math.ceil((j-i)/0.25);if(h<M){h=M;}}if(h<2){g.push(j);continue;}var q=(j-i)/h;if(Math.abs(q)<1e-6){g.push(j);continue;}for(var u=1;u<h;u++){g.push(i+u*q);}g.push(j);}var v;var w,x;if(t){w=g[0];x=g[g.length-1];for(v=0;v<t.length;v++){if(t[v]>x+1e-6){g.push(t[v]);}}for(v=t.length-1;v>=0;v--){if(t[v]<w-1e-6){g.unshift(t[v]);}}}if(s){w=g[0];x=g[g.length-1];for(v=0;v<s.length;v++){if(s[v]>x+1e-6){g.push(s[v]);}}for(v=s.length-1;v>=0;v--){if(s[v]<w-1e-6){g.unshift(s[v]);}}}return g;};
f.prototype._setNativePositionTracks=function(t){var c=this._nodesPositionTracksMap.get(t);if(!c){return;}if(!c.originalData){c.originalData={};c.originalData.quaternion=t.quaternion.clone();c.originalData.position=t.position.clone();c.originalData.scale=t.scale.clone();}var k,e;if(c.scale.nativeTrack){for(k=0;k<this._animationClip.tracks.length;k++){e=this._animationClip.tracks[k];if(e===c.scale.nativeTrack){this._animationClip.tracks.splice(k,1);break;}}}if(c.rotate.nativeTrack){for(k=0;k<this._animationClip.tracks.length;k++){e=this._animationClip.tracks[k];if(e===c.rotate.nativeTrack){this._animationClip.tracks.splice(k,1);break;}}}if(c.translate.nativeTrack){for(k=0;k<this._animationClip.tracks.length;k++){e=this._animationClip.tracks[k];if(e===c.translate.nativeTrack){this._animationClip.tracks.splice(k,1);break;}}}var n=this._nodesEndData.get(t);var g=this._nodesStartData.get(t);if(n){n.position=null;n.scale=null;n.quaternion=null;}if(g){g.position=null;g.scale=null;g.quaternion=null;}if((!c.rotate.times||c.rotate.times.length===0)&&(!c.scale.times||c.scale.times.length===0)&&(!c.translate.times||c.translate.times.length===0)){this._nodesPositionTracksMap.delete(t);return;}var h=function(l1){var m1=false;var n1=l1.name+" offset geometry";for(var l=0;l<l1.children.length;l++){var o=l1.children[l];if(o.name===n1&&o.type==="Group"){m1=true;break;}var o1=o.name+" offset geometry";for(var p1=0;p1<o.children.length;p1++){var q1=o.children[p1];if(q1.name===o1&&q1.type==="Group"){m1=true;break;}}if(m1){break;}}return m1;};var i=false;var p;if(c.pivot){p=c.pivot.slice();var j=false;if(t.children){j=h(t);if(!j){for(var l=0;l<t.children.length;l++){var o=t.children[l];if(o.isMesh){var q=new THREE.Vector3(p[0],p[1],p[2]);q.applyMatrix4(o.matrix);p[0]=q.x;p[1]=q.y;p[2]=q.z;j=false;break;}}}}if(j){i=true;}}else{i=true;}if(!i){if(Math.abs(p[0]-0.0)<1e-6&&Math.abs(p[1]-0.0)<1e-6&&Math.abs(p[2]-0.0)<1e-6){i=true;}}var r,s;if(c.rotate.times&&c.rotate.times.length>0){r=c.rotate.times.slice(0);s=c.rotate.values.slice(0);}var u,v;if(c.translate.times&&c.translate.times.length>0){u=c.translate.times.slice(0);v=c.translate.values.slice(0);}var w,x;if(c.scale.times&&c.scale.times.length>0){w=c.scale.times.slice(0);x=c.scale.values.slice(0);}var y;if(r){if(y===undefined||y>r[0]){y=r[0];}}if(u&&!i){if(y===undefined||y>u[0]){y=u[0];}}if(w&&!i){if(y===undefined||y>w[0]){y=w[0];}}if(!r){if(!i){r=[y];s=[c.originalData.quaternion.x,c.originalData.quaternion.y,c.originalData.quaternion.z,c.originalData.quaternion.w];c.rotate.rotateType=b.quaternion;c.rotate.interpolation=d.linear;}}if(!u){if(!i){u=[y];v=[c.originalData.position.x,c.originalData.position.y,c.originalData.position.z];c.translate.interpolation=d.linear;}}if(!w){if(!i){w=[y];x=[c.originalData.scale.x,c.originalData.scale.y,c.originalData.scale.z];c.scale.interpolation=d.linear;}}var z=t.uuid;var B=[];if(r){B=this._resetRotateTimes(r,s,c.rotate.rotateType,u,w);}var C=[];var D=[];var E=[];var F=[];var G=[];var H=new THREE.Matrix4();var I=new THREE.Matrix4();if(!i){H.makeTranslation(p[0],p[1],p[2]);I.makeTranslation(-p[0],-p[1],-p[2]);}var J=new THREE.Matrix4();var K=new THREE.Matrix4();var L=new THREE.Matrix4();var N,O,P;for(P=0;P<B.length;P++){var R=B[P];var S=0;var T=0;var U=0;if(r){if(R<=r[0]){S=0;T=0;}else if(R>=r[r.length-1]){if(r.length>1){U=1;}S=r.length-1;T=r.length-1;}else{for(k=0;k<r.length-1;k++){N=r[k];O=r[k+1];if(R>=N&&R<=O){U=(R-N)/(O-N);S=k;T=k+1;break;}}}J=this._getRotationMatrix(S,T,s,c.rotate.rotateType,U);}var V=null;var W=null;U=0;if(w){if(R<=w[0]){V=[x[0],x[1],x[2]];}else if(R>=w[w.length-1]){W=[x[x.length-3],x[x.length-2],x[x.length-1]];}else{for(k=0;k<w.length-1;k++){N=w[k];O=w[k+1];if(R>=N&&R<=O){V=[x[k*3],x[k*3+1],x[k*3+2]];W=[x[k*3+3],x[k*3+4],x[k*3+5]];U=(R-N)/(O-N);break;}}}K=this._getScaleMatrix(V,W,U);}var X=null;var Y=null;U=0;if(u){if(R<=u[0]){X=[v[0],v[1],v[2]];}else if(R>=u[u.length-1]){Y=[v[v.length-3],v[v.length-2],v[v.length-1]];}else{for(k=0;k<u.length-1;k++){N=u[k];O=u[k+1];if(R>=N&&R<=O){X=[v[k*3],v[k*3+1],v[k*3+2]];Y=[v[k*3+3],v[k*3+4],v[k*3+5]];U=(R-N)/(O-N);break;}}}L=this._getTranslateMatrix(X,Y,U);}var m=new THREE.Matrix4();m.multiply(L);m.multiply(J);m.multiply(K);m.multiply(I);var Z=new THREE.Quaternion();var $=new THREE.Vector3();var _=new THREE.Vector3();m.decompose($,Z,_);E.push(Z.x,Z.y,Z.z,Z.w);if(!i){D.push($.x,$.y,$.z);F.push(_.x,_.y,_.z);C.push(R);G.push(R);}}if(i){D=v;C=u;F=x;G=w;}var a1,b1;if(r&&(c.rotate.cyclicStart||c.rotate.cyclicEnd)){a1=B.slice(0);b1=E.slice(0);if(c.rotate.cyclicStart){this._extendTrackForCyclicStart(B,E,a1,b1);}if(c.rotate.cyclicEnd){this._extendTrackForCyclicEnd(B,E,a1,b1);}}if(u&&(c.translate.cyclicStart||c.translate.cyclicEnd)){a1=C.slice(0);b1=D.slice(0);if(c.translate.cyclicStart){this._extendTrackForCyclicStart(C,D,a1,b1);}if(c.translate.cyclicEnd){this._extendTrackForCyclicEnd(C,D,a1,b1);}}if(w&&(c.scale.cyclicStart||c.scale.cyclicEnd)){a1=G.slice(0);b1=F.slice(0);if(c.scale.cyclicStart){this._extendTrackForCyclicStart(G,F,a1,b1);}if(c.scale.cyclicEnd){this._extendTrackForCyclicEnd(G,F,a1,b1);}}if(!n){n={};}if(!g){g={};}if(w){if(G[0]>0){F.unshift(F[0],F[1],F[2]);G.unshift(G[0]);g.scale=null;}else{var c1=new THREE.Vector3(F[0],F[1],F[2]);g.scale=c1;}var d1=new THREE.Vector3(F[F.length-3],F[F.length-2],F[F.length-1]);n.scale=d1;var e1=z+".scale";c.scale.nativeTrack=new THREE.VectorKeyframeTrack(e1,G,F);c.scale.nativeTrack.userData={};c.scale.nativeTrack.userData.originalValue=t.scale.clone();if(c.scale.interpolation===d.discrete){c.scale.nativeTrack.setInterpolation(THREE.InterpolateDiscrete);}else if(c.scale.interpolation===d.cubic){c.scale.nativeTrack.setInterpolation(THREE.InterpolateSmooth);}else{c.scale.nativeTrack.setInterpolation(THREE.InterpolateLinear);}c.scale.nativeTrack.userData.targetNode=t;this._animationClip.tracks.push(c.scale.nativeTrack);}if(r){if(B[0]>0){E.unshift(E[0],E[1],E[2],E[3]);B.unshift(B[0]);g.quaternion=null;}else{var f1=new THREE.Quaternion(E[0],E[1],E[2],E[3]);g.quaternion=f1;}var g1=new THREE.Quaternion(E[E.length-4],E[E.length-3],E[E.length-2],E[E.length-1]);n.quaternion=g1;var h1=z+".quaternion";c.rotate.nativeTrack=new THREE.QuaternionKeyframeTrack(h1,B,E);c.rotate.nativeTrack.userData={};c.rotate.nativeTrack.userData.originalValue=t.quaternion.clone();if(c.rotate.interpolation===d.discrete){c.rotate.nativeTrack.setInterpolation(THREE.InterpolateDiscrete);}else if(c.rotate.interpolation===d.cubic){c.rotate.nativeTrack.setInterpolation(THREE.InterpolateSmooth);}else{c.rotate.nativeTrack.setInterpolation(THREE.InterpolateLinear);}c.rotate.nativeTrack.userData.targetNode=t;this._animationClip.tracks.push(c.rotate.nativeTrack);}if(u){if(C[0]>0){D.unshift(D[0],D[1],D[2]);C.unshift(C[0]);g.position=null;}else{var i1=new THREE.Vector3(D[0],D[1],D[2]);g.position=i1;}var j1=new THREE.Vector3(D[D.length-3],D[D.length-2],D[D.length-1]);n.position=j1;var k1=z+".position";c.translate.nativeTrack=new THREE.VectorKeyframeTrack(k1,C,D);c.translate.nativeTrack.userData={};c.translate.nativeTrack.userData.originalValue=t.position.clone();if(c.translate.interpolation===d.discrete){c.translate.nativeTrack.setInterpolation(THREE.InterpolateDiscrete);}else if(c.translate.interpolation===d.cubic){c.translate.nativeTrack.setInterpolation(THREE.InterpolateSmooth);}else{c.translate.nativeTrack.setInterpolation(THREE.InterpolateLinear);}c.translate.nativeTrack.userData.targetNode=t;this._animationClip.tracks.push(c.translate.nativeTrack);this._nodesPositionTracksMap.set(t,c);}this._nodesEndData.set(t,n);this._nodesStartData.set(t,g);};
f.prototype.setOpacityTrack=function(t,c,v,i,e,g){if(c.length!==v.length){return;}if(i&&i!==d.linear&&i!==d.cubic&&i!==d.discrete){return;}var o=this._nodesOpacityTrackMap.get(t);if(!o){o={};}o.times=c.slice();o.values=v.slice();if(i){o.interpolation=i;}else{o.interpolation=d.linear;}if(e){o.isHighlight=true;this._hasHighlight=true;}else{o.isHighlight=false;}if(g){o.cyclicStart=g.cyclicStart;o.cyclicEnd=g.cyclicEnd;}this._nodesOpacityTrackMap.set(t,o);this._setNativeOpacityTrack(t);this._resetDuration();};
f.prototype._getNodesWithMaterialColor=function(p,n){if(p&&p.material&&p.material.color){n.push(p);}for(var c=0;p.children&&c<p.children.length;c++){var e=p.children[c];this._getNodesWithMaterialColor(e,n);}};
f.prototype._getNodesWithMaterialOpacity=function(p,n){if(p&&p.material&&p.material.opacity!==undefined){n.push(p);}for(var c=0;p.children&&c<p.children.length;c++){var e=p.children[c];this._getNodesWithMaterialOpacity(e,n);}};
f.prototype._resetMaterialTransparentForOpacityTrack=function(){var t=this._nodesOpacityTrackMap.values();var n=t.next();while(!n.done){var o=n.value;if(o.nativeTracks){for(var c=0;c<o.nativeTracks.length;c++){var e=o.nativeTracks[c];if(e.userData&&e.userData.targetNode&&e.userData.targetNode.material){e.userData.targetNode.material.transparent=true;}}}n=t.next();}};
f.prototype._setNativeOpacityTrack=function(t){var o=this._nodesOpacityTrackMap.get(t);if(!o){return;}if(o.nativeTracks){for(var c=0;c<o.nativeTracks.length;c++){var e=o.nativeTracks[c];for(var i=0;i<this._animationClip.tracks.length;i++){var g=this._animationClip.tracks[i];if(e===g){this._animationClip.tracks.splice(i,1);break;}}}}o.nativeTracks=[];var n=[];this._getNodesWithMaterialOpacity(t,n);var N,h,j,k;if(!o.times||o.times.length==0){for(h=0;h<n.length;h++){N=n[h];if(N.userData&&N.userData.originalMaterial){if(!N.userData.highlightColor&&!N.userData.animatedColor){N.material.color.copy(N.userData.originalMaterial.color);if(N.material.emissive!==undefined){N.material.emissive.copy(N.userData.originalMaterial.emissive);}if(N.material.specular!==undefined){N.material.specular.copy(N.userData.originalMaterial.specular);}}N.material.opacity=N.userData.originalMaterial.opacity;N.material.transparent=N.userData.originalMaterial.transparent;delete N.userData.animatedOpacity;}j=this._nodesEndData.get(N);if(j&&j.opacity){delete j.opacity;}k=this._nodesStartData.get(N);if(k&&k.opacity){delete k.opacity;}}this._nodesOpacityTrackMap.delete(t);return;}var l=o.times.slice(0);var v=o.values.slice(0);if(l.length===0){return;}if(o.cyclicStart||o.cyclicEnd){var m=o.times.slice(0);var C=o.values.slice(0);if(o.cyclicStart){this._extendTrackForCyclicStart(l,v,m,C);}if(o.cyclicEnd){this._extendTrackForCyclicEnd(l,v,m,C);}}if(l[0]>0){v.unshift(v[0]);l.unshift(l[0]-1e-4);}for(h=0;h<n.length;h++){N=n[h];if(!N.userData){N.userData={};}if(!N.userData.originalMaterial){N.userData.originalMaterial=N.material;N.material=N.material.clone();}if(l[0]>0){if(N.userData.originalMaterial.opacity!==undefined){v[0]=N.userData.originalMaterial.opacity;}else{v[0]=1;}}N.userData.animatedOpacity=true;var p=N.uuid+".material.opacity";var q=N.material.opacity;N.material.transparent=true;j=this._nodesEndData.get(N);if(!j){j={};}k=this._nodesStartData.get(N);if(!k){k={};}if(o.isHighlight){j.opacity=N.material.opacity;}else{j.opacity=v[v.length-1];}this._nodesEndData.set(N,j);if(o.isHighlight){k.opacity=N.material.opacity;}else{k.opacity=v[0];}this._nodesStartData.set(N,k);var r=new THREE.NumberKeyframeTrack(p,l,v);if(o.interpolation===d.discrete){r.setInterpolation(THREE.InterpolateDiscrete);}else if(o.interpolation===d.cubic){r.setInterpolation(THREE.InterpolateSmooth);}else{r.setInterpolation(THREE.InterpolateLinear);}r.userData={};r.userData.targetNode=N;r.userData.originalValue=q;this._animationClip.tracks.push(r);o.nativeTracks.push(r);}};
f.prototype.setColorTrack=function(t,c,v,i,e,g){if(c.length*3!==v.length){return;}if(i&&i!==d.linear&&i!==d.cubic&&i!==d.discrete){return;}var h=this._nodesColorTrackMap.get(t);if(!h){h={};}h.times=c.slice();h.values=v.slice();if(i){h.interpolation=i;}else{h.interpolation=d.linear;}if(e){h.isHighlight=true;this._hasHighlight=true;}else{h.isHighlight=false;}if(g){h.cyclicStart=g.cyclicStart;h.cyclicEnd=g.cyclicEnd;}this._nodesColorTrackMap.set(t,h);this._setNativeColorTrack(t);this._resetDuration();};
f.prototype._setNativeColorTrack=function(t){var c=this._nodesColorTrackMap.get(t);if(!c){return;}if(c.nativeTracks){for(var o=0;o<c.nativeTracks.length;o++){var e=c.nativeTracks[o];for(var i=0;i<this._animationClip.tracks.length;i++){var g=this._animationClip.tracks[i];if(e===g){this._animationClip.tracks.splice(i,1);break;}}}}c.nativeTracks=[];var n=[];this._getNodesWithMaterialColor(t,n);var h,N,j,k;if(!c.times||c.times.length==0){for(h=0;h<n.length;h++){N=n[h];if(N.userData&&N.userData.originalMaterial){if(!N.userData.highlightColor){N.material.color.copy(N.userData.originalMaterial.color);if(N.material.emissive!==undefined){N.material.emissive.copy(N.userData.originalMaterial.emissive);}if(N.material.specular!==undefined){N.material.specular.copy(N.userData.originalMaterial.specular);}}delete N.userData.animatedColor;}j=this._nodesEndData.get(N);if(j&&j.color){delete j.color;}k=this._nodesStartData.get(N);if(k&&k.color){delete k.color;}}this._nodesColorTrackMap.delete(t);return;}var l=c.times.slice(0);var v=c.values.slice(0);if(l.length===0){return;}if(c.cyclicStart||c.cyclicEnd){var m=c.times.slice(0);var C=c.values.slice(0);if(c.cyclicStart){this._extendTrackForCyclicStart(l,v,m,C);}if(c.cyclicEnd){this._extendTrackForCyclicEnd(l,v,m,C);}}if(l[0]>0){v.unshift(v[0],v[1],v[2]);l.unshift(l[0]-1e-4);}for(h=0;h<n.length;h++){N=n[h];if(!N.userData){N.userData={};}if(!N.userData.originalMaterial){N.userData.originalMaterial=N.material;N.material=N.material.clone();}if(l[0]>0&&N.userData.originalMaterial.color){v[0]=N.userData.originalMaterial.color.r;v[1]=N.userData.originalMaterial.color.g;v[2]=N.userData.originalMaterial.color.b;}N.userData.animatedColor=true;var p=N.uuid+".material.color";var q=N.material.color.clone();j=this._nodesEndData.get(N);if(!j){j={};}k=this._nodesStartData.get(N);if(!k){k={};}if(c.isHighlight){j.color=N.material.color.clone();}else{j.color=new THREE.Color(v[v.length-3],v[v.length-2],v[v.length-1]);}this._nodesEndData.set(N,j);if(c.isHighlight){k.color=N.material.color.clone();}else{k.color=new THREE.Color(v[0],v[1],v[2]);}this._nodesStartData.set(N,k);var r=new THREE.ColorKeyframeTrack(p,l,v);if(c.interpolation===d.discrete){r.setInterpolation(THREE.InterpolateDiscrete);}else if(c.interpolation===d.cubic){r.setInterpolation(THREE.InterpolateSmooth);}else{r.setInterpolation(THREE.InterpolateLinear);}r.userData={};r.userData.targetNode=N;r.userData.originalValue=q;this._animationClip.tracks.push(r);c.nativeTracks.push(r);}};
f.prototype.getInterpolation=function(t,c){var i;var e=this._nodesPositionTracksMap.get(t);if(c===a.rotate&&e){i=e.rotate.interpolation;}else if(c===a.translate&&e){i=e.translate.interpolation;}else if(c===a.scale&&e){i=e.scale.interpolation;}else if(c===a.opacity){var o=this._nodesOpacityTrackMap.get(t);if(o){i=o.interpolation;}}else if(c===a.color){var g=this._nodesColorTrackMap.get(t);if(g){i=g.interpolation;}}return i;};
f.prototype.setTrackCyclicStyle=function(t,c,e,g){var h=this._nodesPositionTracksMap.get(t);if(c===a.rotate&&h&&h.rotate){h.rotate.cyclicStart=e;h.rotate.cyclicEnd=g;this._setNativePositionTracks(t);}else if(c===a.translate&&h&&h.translate){h.translate.cyclicStart=e;h.translate.cyclicEnd=g;this._setNativePositionTracks(t);}else if(c===a.scale&&h&&h.scale){h.scale.cyclicStart=e;h.scale.cyclicEnd=g;this._setNativePositionTracks(t);}else if(c===a.opacity){var o=this._nodesOpacityTrackMap.get(t);if(o){o.cyclicStart=e;o.cyclicEnd=g;this._setNativeOpacityTrack(t);}}else if(c===a.color){var i=this._nodesColorTrackMap.get(t);if(i){i.cyclicStart=e;i.cyclicEnd=g;this._setNativeColorTrack(t);}}this._resetDuration();};
f.prototype.setInterpolation=function(t,c,i){var e=this._nodesPositionTracksMap.get(t);var n=[];if(c===a.rotate&&e&&e.rotate){e.rotate.interpolation=i;n.push(e.rotate.nativeTrack);}else if(c===a.translate&&e&&e.translate){e.translate.interpolation=i;n.push(e.translate.nativeTrack);}else if(c===a.scale&&e&&e.scale){e.scale.interpolation=i;n.push(e.scale.nativeTrack);}else if(c===a.opacity){var o=this._nodesOpacityTrackMap.get(t);if(o){o.interpolation=i;n=o.nativeTracks;}}else if(c===a.color){var g=this._nodesColorTrackMap.get(t);if(g){g.interpolation=i;n=g.nativeTracks;}}for(var h=0;h<n.length;h++){var j=n[h];if(j){if(i===d.discrete){j.setInterpolation(THREE.InterpolateDiscrete);}else if(i===d.cubic){j.setInterpolation(THREE.InterpolateSmooth);}else{j.setInterpolation(THREE.InterpolateLinear);}}}this._resetDuration();};
f.prototype.getNearestKeyFrame=function(c,e,g,h){var i,v,r;if(e===a.rotate||e===a.translate||e===a.scale){var j=this._nodesPositionTracksMap.get(c);if(e===a.rotate&&j&&j.rotate.times&&j.rotate.times.length){i=j.rotate.times;v=j.rotate.values;r=j.rotate.rotateType;}else if(e===a.translate&&j&&j.translate.times&&j.translate.times.length){i=j.translate.times;v=j.translate.values;}else if(e===a.scale&&j&&j.scale.times&&j.scale.times.length){i=j.scale.times;v=j.scale.values;}}else if(e===a.opacity){var o=this._nodesOpacityTrackMap.get(c);if(o&&o.times&&o.values){i=o.times;v=o.values;}}else if(e===a.color){var k=this._nodesColorTrackMap.get(c);if(k&&k.times&&k.values){i=k.times;v=k.values;}}var l;if(i&&v){var m=Math.abs(g-i[0]);var n=0;for(var p=1;p<i.length;p++){var t=i[p];if(Math.abs(t-g)<m){m=Math.abs(t-g);n=p;}}if(h!=null){if(m>h){return l;}}l={};l.index=n;l.time=i[n];if(e===a.translate||e===a.scale||e===a.color){l.value=[v[n*3],v[n*3+1],v[n*3+2]];}else if(e===a.rotate){l.value=[v[n*4],v[n*4+1],v[n*4+2],v[n*4+3]];}else{l.value=[v[n]];}if(r){l.rotateType=r;}}return l;};
f.prototype.getRotateKeyFrameInQuaternion=function(t,i){var v;var c=this._nodesPositionTracksMap.get(t);if(c&&c.rotate&&c.rotate.times.length>i){var r=[c.rotate.values[i*4],c.rotate.values[i*4+1],c.rotate.values[i*4+2],c.rotate.values[i*4+3]];v=this._convertRotationForm(c.rotate.rotateType,b.quaternion,r);}return v;};
f.prototype.addKeyFrame=function(c,e,g,v,r,n){if(v.length!==3&&(e===a.color||e===a.translate||e===a.scale)){return;}else if(v.length!==1&&e===a.opacity){return;}else if(v.length!==4&&e===a.rotate){return;}var h,j;if(e===a.rotate||e===a.translate||e===a.scale){var k=this._nodesPositionTracksMap.get(c);if(!k){k={};k.rotate={};k.translate={};k.scale={};this._nodesPositionTracksMap.set(c,k);}if(e===a.rotate){if(!k.rotate.times){k.rotate.times=[];k.rotate.values=[];}h=k.rotate.times;j=k.rotate.values;if(r){if(!k.rotate.rotateType){k.rotate.rotateType=r;}else if(k.rotate.rotateType!==r){v=this._convertRotationForm(r,k.rotate.rotateType,v);}}}else if(e===a.translate){if(!k.translate.times){k.translate.times=[];k.translate.values=[];}h=k.translate.times;j=k.translate.values;}else if(e===a.scale){if(!k.scale.times){k.scale.times=[];k.scale.values=[];}h=k.scale.times;j=k.scale.values;}}else if(e===a.opacity){var o=this._nodesOpacityTrackMap.get(c);if(!o){o={};o.times=[];o.values=[];this._nodesOpacityTrackMap.set(c,o);}h=o.times;j=o.values;}else if(e===a.color){var l=this._nodesColorTrackMap.get(c);if(!l){l={};l.times=[];l.values=[];this._nodesColorTrackMap.set(c,l);}h=l.times;j=l.values;}var m;if(h&&j){if(g<=h[0]||h.length===0){h.unshift(g);for(m=v.length-1;m>=0;m--){j.unshift(v[m]);}}else if(g>=h[h.length-1]){h.push(g);for(m=0;m<v.length;m++){j.push(v[m]);}}else{for(var p=1;p<h.length;p++){if(g<h[p]){h.splice(p,0,g);if(e===a.translate||e===a.scale||e===a.color){j.splice(p*3,0,v[0],v[1],v[2]);}else if(e===a.rotate){j.splice(p*4,0,v[0],v[1],v[2],v[3]);}else{j.splice(p,0,v[0]);}break;}}}}if(e===a.rotate||e===a.translate||e===a.scale){this._setNativePositionTracks(c);}else if(e===a.opacity){this._setNativeOpacityTrack(c);}else if(e===a.color){this._setNativeColorTrack(c);}this._resetDuration();if(e===a.rotate&&r!==b.quaternion){var q=this._nodesPositionTracksMap.get(c);if(q&&q.rotate.nativeTrack){for(var i=0;i<q.rotate.nativeTrack.times.length;i++){var t=q.rotate.nativeTrack.times[i];if(Math.abs(t-g)<1e-9){v=[q.rotate.nativeTrack.values[i*4],q.rotate.nativeTrack.values[i*4+1],q.rotate.nativeTrack.values[i*4+2],q.rotate.nativeTrack.values[i*4+3]];}}}}if(!n){this.fireKeyFrameAdded({sequenceId:this.getSequenceId(),targetNodeRef:c,trackType:e,keyFrameValue:v,keyFrameTime:g});}};
f.prototype.deleteKeyFrame=function(t,c,i,n){var e,v,g;if(c===a.rotate||c===a.translate||c===a.scale){g=this._nodesPositionTracksMap.get(t);if(!g){return;}if(c===a.rotate&&g&&g.rotate.times&&g.rotate.times.length){e=g.rotate.times;v=g.rotate.values;}else if(c===a.translate&&g&&g.translate.times&&g.translate.times.length){e=g.translate.times;v=g.translate.values;}else if(c===a.scale&&g&&g.scale.times&&g.scale.times.length){e=g.scale.times;v=g.scale.values;}}else if(c===a.opacity){var o=this._nodesOpacityTrackMap.get(t);if(!o){return;}e=o.times;v=o.values;}else if(c===a.color){var h=this._nodesColorTrackMap.get(t);if(!h){return;}e=h.times;v=h.values;}var j,k;if(e&&v){if(i<0||i>=e.length){return;}k=e[i];e.splice(i,1);if(c===a.translate||c===a.scale||c===a.color){j=[v[i*3],v[i*3+1],v[i*3+2]];v.splice(i*3,3);}else if(c===a.rotate){var r=[v[i*4],v[i*4+1],v[i*4+2],v[i*4+3]];j=this._convertRotationForm(g.rotate.rotateType,b.quaternion,r);v.splice(i*4,4);}else{j=[v[i]];v.splice(i,1);}}var l=true;if(c===a.rotate||c===a.translate||c===a.scale){this._setNativePositionTracks(t);var p=this._nodesPositionTracksMap.get(t);if(p){if(c===a.rotate&&p.rotate.times&&p.rotate.times.length>0){l=false;}else if(c===a.translate&&p.translate.times&&p.translate.times.length>0){l=false;}else if(c===a.scale&&p.scale.times&&p.scale.times.length>0){l=false;}}}else if(c===a.opacity){this._setNativeOpacityTrack(t);var T=this._nodesOpacityTrackMap.get(t);if(T){l=false;}}else if(c===a.color){this._setNativeColorTrack(t);var m=this._nodesColorTrackMap.get(t);if(m){l=false;}}this._resetDuration();if(!n){this.fireKeyFrameDeleted({sequenceId:this.getSequenceId(),targetNodeRef:t,trackType:c,keyFrameValue:j,keyFrameTime:k,keyFrameIndex:i,lastTrack:l});}};
f.prototype.updateKeyFrame=function(c,e,g,h,v,r,n){this.deleteKeyFrame(c,e,g,true);this.addKeyFrame(c,e,h,v,r,true);if(e===a.rotate&&r!==b.quaternion){var j=this._nodesPositionTracksMap.get(c);if(j.rotate.nativeTrack){for(var i=0;i<j.rotate.nativeTrack.times.length;i++){var t=j.rotate.nativeTrack.times[i];if(Math.abs(t-h)<1e-9){v=[j.rotate.nativeTrack.values[i*4],j.rotate.nativeTrack.values[i*4+1],j.rotate.nativeTrack.values[i*4+2],j.rotate.nativeTrack.values[i*4+3]];}}}}if(!n){this.fireKeyFrameUpdated({sequenceId:this.getSequenceId(),targetNodeRef:c,trackType:e,keyFrameValue:v,keyFrameTime:h,keyFrameIndex:g});}};
f.prototype._getAngleAxisFromQuaternion=function(c,e,g,h){var q=new THREE.Quaternion(c,e,g,h);if(q.w>1){q.normalise();}var i=2*Math.acos(q.w);var s=Math.sqrt(1-q.w*q.w);var x,y,z;if(s<0.001){x=q.x;y=q.y;z=q.z;}else{x=q.x/s;y=q.y/s;z=q.z/s;}return[x,y,z,i];};
f.prototype._getEnulerFromQuaternion=function(c,e,g,h){var q=new THREE.Quaternion(c,e,g,h);if(q.w>1){q.normalise();}var o=26;var t=q.x*q.y+q.z*q.w;var i,j,k;if(t>0.499){i=2*Math.atan2(q.x,q.w);j=Math.PI/2;k=0;}if(t<-0.499){i=-2*Math.atan2(q.x,q.w);j=-Math.PI/2;k=0;}else{var s=q.x*q.x;var l=q.y*q.y;var m=q.z*q.z;i=Math.atan2(2*q.y*q.w-2*q.x*q.z,1-2*l-2*m);j=Math.asin(2*t);k=Math.atan2(2*q.x*q.w-2*q.y*q.z,1-2*s-2*m);}return[i,j,k,o];};
f.prototype._convertRotationForm=function(s,c,g){var h;var q,e,o,i,j,k;if(c===b.quaternion){q=new THREE.Quaternion();if(s===b.angleAxis){j=new THREE.Vector3(g[0],g[1],g[2]);j.normalize();q.setFromAxisAngle(j,g[3]);h=[q.x,q.y,q.z,q.w];}else if(s===b.euler){o=Math.round(g[3]);i="";for(k=0;k<3;k++){if((o>>(k*2)&3)===0){i.push("X");}else if((o>>(k*2)&3)===1){i.push("Y");}else if((o>>(k*2)&3)===2){i.push("Z");}}e=new THREE.Euler(g[0],g[1],g[2],i);q.setFromEuler(e);h=[q.x,q.y,q.z,q.w];}else{h=g.slice();}}else if(c===b.angleAxis){if(s===b.quaternion){h=this._getAngleAxisFromQuaternion(g);}else if(s===b.euler){o=Math.round(g[3]);i="";for(k=0;k<3;k++){if((o>>(k*2)&3)===0){i.push("X");}else if((o>>(k*2)&3)===1){i.push("Y");}else if((o>>(k*2)&3)===2){i.push("Z");}}e=new THREE.Euler(g[0],g[1],g[2],i);q.setFromEuler(e);h=this._getAngleAxisFromQuaternion(g);}else{h=g.slice();}}else if(c===b.euler){if(s===b.quaternion){h=this._getEnulerFromQuaternion(g);}else if(s===b.angleAxis){q=new THREE.Quaternion();j=new THREE.Vector3(g[0],g[1],g[2]);j.normalize();q.setFromAxisAngle(j,g[3]);h=this._getAngleAxisFromQuaternion(q);}else{h=g.slice();}}return h;};
f.prototype.addKeyFrameByNodeProperty=function(t,c,e,n){var v;var m;var r;if(c===a.rotate){v=[t.quaternion.x,t.quaternion.y,t.quaternion.z,t.quaternion.w];r=b.quaternion;}else if(c===a.translate){v=[t.position.x,t.position.y,t.position.z];}else if(c===a.scale){v=[t.scale.x,t.scale.y,t.scale.z];}else if(c===a.opacity){if(t){m=t.material;if(m&&m.opacity!==undefined){v=[m.opacity];}}}else if(c===a.color){if(t){m=t.material;if(m&&m.color){v=[m.color.r,m.color.g,m.color.b];}}}if(v){this.addKeyFrame(t,c,e,v,r,n);}return v;};
f.prototype.updateKeyFrameByNodeProperty=function(t,c,e,i,n){this.deleteKeyFrame(t,c,i,true);var v=this.addKeyFrameByNodeProperty(t,c,e,true);if(!n){this.fireKeyFrameUpdated({sequenceId:this.getSequenceId(),targetNodeRef:t,trackType:c,keyFrameValue:v,keyFrameTime:e,keyFrameIndex:i});}};
f.prototype.getNodesEndValues=function(){return this._nodesEndData;};
f.prototype.getNodesStartValues=function(){return this._nodesStartData;};
f.prototype.hasHighlight=function(){return this._hasHighlight;};
f.prototype.setHasHighlight=function(h){this._hasHighlight=h;};
f.prototype._cloneKeyFrameTrack=function(t){var c=THREE.AnimationUtils.arraySlice(t.times,0);var v=THREE.AnimationUtils.arraySlice(t.values,0);var T=t.constructor;var e=new T(t.name,c,v);e.createInterpolant=t.createInterpolant;return e;};
f.prototype._cloneAnimationClip=function(c){var t=[];for(var i=0;c.tracks&&i<c.tracks.length;i++){t.push(this._cloneKeyFrameTrack(c.tracks[i]));}return new THREE.AnimationClip(c.name,c.duration,t);};
f.prototype.clone=function(s,i){this.setName(s.getName());this._hasHighlight=s._hasHighlight;var e,n,m,c;this._nodesEndData=new Map();e=s._nodesEndData.entries();n=e.next();while(!n.done){m=n.value[0];c=n.value[1];this._nodesEndData.set(m,c);n=e.next();}this._nodesStartData=new Map();e=s._nodesStartData.entries();n=e.next();while(!n.done){m=n.value[0];c=n.value[1];this._nodesStartData.set(m,c);n=e.next();}var t;this._nodesPositionTracksMap=new Map();e=s._nodesPositionTracksMap.entries();n=e.next();while(!n.done){t=n.value[0];var g=n.value[1];n=e.next();this.setPositionTracks(t,g.rotate.times,g.translate.times,g.scale.times,g.rotate.rotateType,g.rotate.values,g.translate.values,g.scale.values,g.pivot,g.rotate.interpolation,g.translate.interpolation,g.scale.interpolation);}this._nodesOpacityTrackMap=new Map();e=s._nodesOpacityTrackMap.entries();n=e.next();while(!n.done){t=n.value[0];var o=n.value[1];n=e.next();if(!o.isHighlight||(o.isHighlight&&i)){this.setOpacityTrack(t,o.times,o.values,o.interpolation,o.isHighlight);}}this._nodesColorTrackMap=new Map();e=s._nodesColorTrackMap.entries();n=e.next();while(!n.done){t=n.value[0];var h=n.value[1];n=e.next();if(!h.isHighlight||(h.isHighlight&&i)){this.setColorTrack(t,h.times,h.values,h.interpolation,h.isHighlight);}}this.setDuration(s.getDuration());};
f.prototype.getDuration=function(){if(this._duration===0){return this._animationClip.duration;}else{return this._duration;}};
f.prototype.setInitialStatusToTargetNodesValues=function(){var k,t,n,c,e;k=this._nodesOpacityTrackMap.keys();n=k.next();while(!n.done){t=n.value;var o=this._nodesOpacityTrackMap.get(t);if(o&&o.nativeTracks){for(var i=0;i<o.nativeTracks.length;i++){c=o.nativeTracks[i];e=c.userData.targetNode;if(c.times[0]>0){if(e&&e.material&&e.material.opacity!==undefined){c.values[0]=e.material.opacity;}else{c.values[0]=1;}}}}n=k.next();}k=this._nodesColorTrackMap.keys();n=k.next();while(!n.done){t=n.value;var g=this._nodesColorTrackMap.get(t);if(g&&g.nativeTracks){for(var h=0;h<g.nativeTracks.length;h++){c=g.nativeTracks[h];e=c.userData.targetNode;if(c.times[0]>0&&e&&e.material&&e.material.color){c.values[0]=e.material.color.r;c.values[1]=e.material.color.g;c.values[2]=e.material.color.b;}}}n=k.next();}k=this._nodesPositionTracksMap.keys();n=k.next();while(!n.done){t=n.value;var j=this._nodesPositionTracksMap.get(t);if(j&&j.scale.nativeTrack){if(j.scale.nativeTrack.times[0]>0){j.scale.nativeTrack.values[0]=t.scale.x;j.scale.nativeTrack.values[1]=t.scale.y;j.scale.nativeTrack.values[2]=t.scale.z;}}if(j&&j.rotate.nativeTrack){if(j.rotate.nativeTrack.times[0]>0){j.rotate.nativeTrack.values[0]=t.quaternion.x;j.rotate.nativeTrack.values[1]=t.quaternion.y;j.rotate.nativeTrack.values[2]=t.quaternion.z;j.rotate.nativeTrack.values[3]=t.quaternion.w;}}if(j.translate.nativeTrack){if(j.translate.nativeTrack.times[0]>0){j.translate.nativeTrack.values[0]=t.position.x;j.translate.nativeTrack.values[1]=t.position.y;j.translate.nativeTrack.values[2]=t.position.z;}}n=k.next();}};
f.prototype._resetNativeTracks=function(){var e,t,c,n;e=this._nodesOpacityTrackMap.entries();n=e.next();while(!n.done){t=n.value[0];c=n.value[1];if(c.cyclicEnd||c.cyclicStart){this._setNativeOpacityTrack(t);}n=e.next();}e=this._nodesColorTrackMap.entries();n=e.next();while(!n.done){t=n.value[0];c=n.value[1];if(c.cyclicEnd||c.cyclicStart){this._setNativeColorTrack(t);}n=e.next();}e=this._nodesPositionTracksMap.entries();n=e.next();while(!n.done){t=n.value[0];var g=n.value[1];if((g.rotate&&(g.rotate.cyclicEnd||g.rotate.cyclicStart))||(g.translate&&(g.translate.cyclicEnd||g.translate.cyclicStart))||(g.scale&&(g.scale.cyclicEnd||g.scale.cyclicStart))){this._setNativePositionTracks(t);}n=e.next();}this._resetDuration();};
f.prototype.setDuration=function(c){this._duration=c;if(c>0){this._animationClip.duration=c;}else{this._animationClip.resetDuration();}this._resetNativeTracks();};
f.prototype.getNativeAnimationClip=function(){this._resetMaterialTransparentForOpacityTrack();return this._animationClip;};
return f;});
sap.ui.predefine('sap/ui/vk/threejs/AnimationTimeController',["sap/ui/base/ManagedObject"],function(M){"use strict";
var A=M.extend("sap.ui.vk.AnimationTimeController",{metadata:{library:"sap.ui.vk",associations:{viewport:{type:"sap.ui.vk.threejs.Viewport"}}}});
A.status={playing:1,pausing:2,stopped:3,completed:4,dragging:5,none:6};
A.prototype.reset=function(){this._totalDuration=0;this._startTime=0;this._currentStatus=A.status.stopped;this._previousStatus=A.status.none;this._previousProgress=0;this._currentProgress=0;this._justStarted=false;this._infinite=false;};
A.prototype.init=function(){if(M.prototype.init){M.prototype.init.call(this);}this.reset();};
A.prototype.setInfinite=function(i){this._infinite=i;};
A.prototype.getInfinite=function(){return this._infinite;};
A.prototype.startAnimation=function(d,a){this._totalDuration=d;this._startTime=Date.now();if(this._currentStatus===A.status.dragging||this._currentStatus===A.status.pausing||a){this._previousProgress=0;}else{this._currentStatus=A.status.playing;this._currentProgress=0;this._previousProgress=0;}this._justStarted=true;};
A.prototype.stopAnimation=function(){this._currentStatus=A.status.stopped;this._previousStatus=A.status.none;};
A.prototype.isAnimationStopped=function(){return this._currentStatus===A.status.stopped;};
A.prototype.getCurrentStatus=function(){if(this._currentStatus===A.status.playing){var c=Date.now();this._currentProgress=(c-this._startTime)/this._totalDuration/10;}else if(this._currentStatus===A.status.stopped){this._currentProgress=0;this._previousProgress=0;}else if(this._currentStatus===A.status.completed){this._currentProgress=100;this._previousProgress=100;}if(this._currentProgress>=100&&!this._infinite){this._currentProgress=100;this._currentStatus=A.status.completed;}var r={};r.delta=this._totalDuration*(this._currentProgress-this._previousProgress)/100;if(r.delta<0){r.progress=-1;}else{r.progress=this._currentProgress;}this._previousProgress=this._currentProgress;if(this._justStarted&&r.delta===0){r.delta=this._totalDuration*0.00001;}if(r.delta>=0){this._justStarted=false;}return r;};
A.prototype.pause=function(){if(this._currentStatus===A.status.playing){this._currentStatus=A.status.pausing;var c=Date.now();this._currentProgress=(c-this._startTime)/this._totalDuration/10;}};
A.prototype.resume=function(){if(this._currentStatus===A.status.pausing){this._currentStatus=A.status.playing;var c=Date.now();this._startTime=c-this._previousProgress*this._totalDuration*10;}};
A.prototype.drag=function(p){if(this._previousStatus===A.status.none){this._previousStatus=this._currentStatus;}this._currentProgress=p;this._currentStatus=A.status.dragging;};
A.prototype.completeDragging=function(p){if(this._currentStatus!==A.status.dragging){return;}if(this._previousStatus===A.status.playing){var c=Date.now();this._startTime=c-p*this._totalDuration*10;}else{this._currentProgress=p;}this._currentStatus=this._previousStatus;this._previousStatus=A.status.none;if(this._currentStatus===A.status.stopped||this._currentStatus===A.status.completed){this._currentStatus=A.status.pausing;}};
return A;});
sap.ui.predefine('sap/ui/vk/threejs/BaseNodeProxy',["../BaseNodeProxy"],function(B){"use strict";
var a=B.extend("sap.ui.vk.threejs.BaseNodeProxy",{metadata:{}});
a.prototype.init=function(n,b){this._object3D=b;};
a.prototype.reset=function(){this._object3D=null;};
a.prototype.getNodeRef=function(){return this._object3D;};
a.prototype.getNodeId=function(){return this._object3D;};
a.prototype.getName=function(){return this._object3D.name||("<"+this._object3D.type+">");};
a.prototype.getNodeMetadata=function(){return this._object3D.userData.metadata||{};};
a.prototype.getHasChildren=function(){return this._object3D.children.length>0;};
a.prototype.getSceneRef=function(){return this._object3D;};
return a;});
sap.ui.predefine('sap/ui/vk/threejs/Billboard',["./thirdparty/three","sap/ui/base/ManagedObject","../thirdparty/html2canvas","../BillboardCoordinateSpace","../BillboardTextEncoding","../BillboardStyle","../BillboardBorderLineStyle","../BillboardHorizontalAlignment"],function(t,B,h,b,c,d,e,f){"use strict";
var g=B.extend("sap.ui.vk.threejs.Billboard",{metadata:{properties:{node:{type:"any",defaultValue:new THREE.Group()},text:{type:"string",defaultValue:""},font:{type:"string",defaultValue:""},fontSize:{type:"float",defaultValue:20},fontWeight:{type:"string",defaultValue:"normal"},fontItalic:{type:"boolean",defaultValue:false},textColor:{type:"sap.ui.core.CSSColor",defaultValue:"#fff"},borderColor:{type:"sap.ui.core.CSSColor",defaultValue:"#fff"},borderOpacity:{type:"float",defaultValue:1},backgroundColor:{type:"sap.ui.core.CSSColor",defaultValue:"#fff"},backgroundOpacity:{type:"float",defaultValue:0.5},encoding:{type:"sap.ui.vk.BillboardTextEncoding",defaultValue:c.PlainText},width:{type:"float",defaultValue:100},height:{type:"float",defaultValue:100},style:{type:"sap.ui.vk.BillboardStyle",defaultValue:d.None},borderLineStyle:{type:"sap.ui.vk.BillboardBorderLineStyle",defaultValue:e.Solid},borderWidth:{type:"float",defaultValue:2},horizontalAlignment:{type:"sap.ui.vk.BillboardHorizontalAlignment",defaultValue:f.Left},texture:{type:"any",defaultValue:null},material:{type:"any"},link:{type:"string",defaultValue:""},coordinateSpace:{type:"sap.ui.vk.BillboardCoordinateSpace",defaultValue:b.Viewport},position:{type:"any",defaultValue:new THREE.Vector3(0,0,0)},renderOrder:{type:"int",defaultValue:0}}}});
g.prototype.init=function(){if(B.prototype.init){B.prototype.init.call(this);}var a=new THREE.BufferGeometry();a.setIndex([0,1,2,2,1,3]);a.addAttribute("position",new THREE.Float32BufferAttribute([-0.5,-0.5,0,0.5,-0.5,0,-0.5,0.5,0,0.5,0.5,0],3));a.addAttribute("normal",new THREE.Float32BufferAttribute([0,0,1,0,0,1,0,0,1,0,0,1],3));a.addAttribute("uv",new THREE.Float32BufferAttribute([0,0,1,0,0,1,1,1],2));var i=new THREE.MeshBasicMaterial({depthTest:false,depthWrite:false,transparent:true,alphaTest:0.05,premultipliedAlpha:true,side:THREE.DoubleSide});this.setProperty("material",i,true);this._billboard=new THREE.Mesh(a,i);this._needUpdateTexture=true;};
g.prototype.setNode=function(n){if(n instanceof THREE.Object3D){this.setProperty("node",n,true);n.add(this._billboard);n.matrixAutoUpdate=false;n.isBillboard=true;n.userData.billboard=this;}return this;};
g.prototype.setEncoding=function(v){this.setProperty("encoding",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setText=function(v){this.setProperty("text",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setFont=function(v){this.setProperty("font",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setFontSize=function(v){this.setProperty("fontSize",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setFontWeight=function(v){this.setProperty("fontWeight",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setFontItalic=function(v){this.setProperty("fontItalic",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setStyle=function(v){this.setProperty("style",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setWidth=function(v){this.setProperty("width",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setHeight=function(v){this.setProperty("height",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setTextColor=function(v){this.setProperty("textColor",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBackgroundColor=function(v){this.setProperty("backgroundColor",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBackgroundOpacity=function(v){this.setProperty("backgroundOpacity",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBorderWidth=function(v){this.setProperty("borderWidth",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBorderLineStyle=function(v){this.setProperty("borderLineStyle",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBorderColor=function(v){this.setProperty("borderColor",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setBorderOpacity=function(v){this.setProperty("borderOpacity",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setHorizontalAlignment=function(v){this.setProperty("horizontalAlignment",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setLink=function(v){this.setProperty("link",v,true);this._needUpdateTexture=true;return this;};
g.prototype.setTexture=function(v){this.setProperty("texture",v,true);this._billboard.material.map=v;return this;};
g.prototype.setMaterial=function(v){this.setProperty("material",v,true);this._billboard.material=v;return this;};
g.prototype.setRenderOrder=function(v){this.setProperty("renderOrder",v,true);this._billboard.renderOrder=v;return this;};
g.prototype._renderBackground=function(a,w,i,n){a.fillStyle=this.getBackgroundColor();a.strokeStyle=this.getBorderColor();a.lineWidth=n;switch(this.getBorderLineStyle()){default:a.setLineDash([]);break;case e.Dash:a.setLineDash([n*5,n]);break;case e.Dot:a.setLineDash([n*2,n]);break;case e.DashDot:a.setLineDash([n*5,n,n*2,n]);break;case e.DashDotDot:a.setLineDash([n*5,n,n*2,n,n*2,n]);break;}var o=n/2;if(this.getStyle()===d.RectangularShape){a.globalAlpha=this.getBackgroundOpacity();if(a.globalAlpha>0){a.fillRect(0,0,w,i);}a.globalAlpha=n>0?this.getBorderOpacity():0;if(a.globalAlpha>0){a.strokeRect(o,o,w-n,i-n);}}else if(this.getStyle()===d.CircularShape){var x=w/2;var y=i/2;var r=w/2;a.beginPath();a.arc(x,y,r-o,0,2*Math.PI);a.closePath();a.globalAlpha=this.getBackgroundOpacity();if(a.globalAlpha>0){a.fill();}a.globalAlpha=n>0?this.getBorderOpacity():0;if(a.globalAlpha>0){a.stroke();}}a.globalAlpha=1;a.setLineDash([]);};
g.prototype._getFont=function(a){return(this.getFontItalic()?"italic ":"")+this.getFontWeight()+" "+(this.getFontSize()*a)+"px "+(this.getFont()||"Arial");};
g.prototype._renderPlainText=function(n){var o=document.createElement("canvas");var r=o.getContext("2d");var s=this.getFontSize()*n;var u=this._getFont(n);r.font=u;var v=Math.ceil(s);var w=this.getBorderLineStyle()!==e.None?this.getBorderWidth()*n:0;var z=Math.ceil(s*0.2+w);var A=this.getText().split("\n");var C=0;A.forEach(function(I){C=Math.max(C,r.measureText(I).width);});var D=this.getLink();if(D.length>0){C=Math.max(C,r.measureText(D).width);}C=Math.ceil(C*0.5)*2;var E=A.length+(D.length>0?1:0);var F=Math.ceil(v*E*0.5)*2;var G=C+z*2;var H=F+z*2;if(this.getStyle()===d.CircularShape){G=H=Math.max(G,H);}this._width=G/n;this._height=H/n;o.width=THREE.Math.ceilPowerOfTwo(G);o.height=THREE.Math.ceilPowerOfTwo(H);this._renderBackground(r,G,H,w);r.font=u;r.textAlign=this.getHorizontalAlignment();r.textBaseline="middle";var a=["left","center","right"].indexOf(r.textAlign);var x=(G+C*(a-1))>>1;var y=(H-(E-1)*v)>>1;r.fillStyle=this.getTextColor();r.filter="blur(0px)";for(var i in A){r.fillText(A[i],x,y+v*i);}if(D.length>0){r.fillStyle="#00f";r.textAlign="right";r.textBaseline="bottom";r.fillText(D,G-z,H-z);}this._setBillboardTexture(o,G,H);};
g.prototype._renderHtmlText=function(a){var i=document.createElement("canvas");var n=i.getContext("2d");var o=this.getBorderLineStyle()!==e.None?this.getBorderWidth()*a:0;var r=Math.ceil(o);var w=Math.ceil(this.getWidth()*a)+r*2;var s=Math.ceil(this.getHeight()*a)+r*2;if(this.getStyle()===d.CircularShape){w=s=Math.max(w,s);}this._width=w/a;this._height=s/a;i.width=THREE.Math.ceilPowerOfTwo(w);i.height=THREE.Math.ceilPowerOfTwo(s);this._renderBackground(n,w,s,o);var u=this.getLink();if(u.length>0){n.font=this._getFont(a);n.fillStyle="#00f";n.textAlign="right";n.textBaseline="bottom";n.fillText(u,w-r,s-r);}var v=document.createElement("iframe");v.style.visibility="hidden";v.width=(w-r*2)/a;v.height=(s-r*2)/a;document.body.appendChild(v);var x=v.contentDocument||v.contentWindow.document;x.open();x.close();x.body.innerHTML=this.getText();var y=document.createElement("canvas");y.width=v.width*a;y.height=v.height*a;y.style.width=v.width+"px";y.style.height=v.height+"px";var z=y.getContext("2d");z.scale(a,a);this._billboard.material.visible=false;h(x.body,{canvas:y,backgroundColor:null}).then(function(y){if(y.width>0&&y.height>0){i.getContext("2d").drawImage(y,r,r);}setTimeout(this._setBillboardTexture.bind(this,i,w,s),0);document.body.removeChild(v);}.bind(this));};
g.prototype._setBillboardTexture=function(a,w,i){var u=w/a.width,v=i/a.height;this._billboard.geometry.addAttribute("uv",new THREE.Float32BufferAttribute([0,1-v,u,1-v,0,1,u,1],2));var n=new THREE.CanvasTexture(a);n.magFilter=THREE.NearestFilter;this._billboard.material.map=n;this._billboard.material.needsUpdate=true;this._billboard.material.visible=true;};
var p=new THREE.Vector4(),j=new THREE.Vector3(),k=new THREE.Vector3(),l=new THREE.Vector3(),q=new THREE.Quaternion(),m=new THREE.Vector3();
g.prototype._updateTexture=function(){this._width=this.getWidth();this._height=this.getHeight();if(this.getText()&&!this.getTexture()){switch(this.getEncoding()){default:case c.PlainText:this._renderPlainText(window.devicePixelRatio);break;case c.HtmlText:this._renderHtmlText(window.devicePixelRatio);break;}}};
g.prototype._update=function(r,a){if(this._needUpdateTexture){this._needUpdateTexture=false;this._updateTexture();}var n=this.getNode();n.parent.updateMatrixWorld();n.matrix.getInverse(n.parent.matrixWorld);n.matrix.decompose(n.position,n.quaternion,n.scale);n.matrixWorld.identity();this._billboard.quaternion.copy(a.quaternion);var v=r.getSize(),s=this.getPosition(),i=this._billboard.position,o=1;if(s){i.copy(s);}else{i.setScalar(0);}var u=this.getCoordinateSpace();if(u===b.Screen){o=THREE.Math.lerp(a.near,a.far,1e-4);i.multiplyScalar(2/a.projectionMatrix.elements[5]);i.z=-1;i.multiplyScalar(o).applyMatrix4(a.matrixWorld);}else if(u===b.Viewport){if(v.width>v.height){i.x*=v.height/v.width;}else{i.y*=v.width/v.height;}i.z=-0.9999;i.unproject(a);p.copy(i).applyMatrix4(a.matrixWorldInverse).applyMatrix4(a.projectionMatrix);var w=(p.x/p.w)*0.5*v.width,x=(p.y/p.w)*0.5*v.height;o=p.w*2/(v.width*a.projectionMatrix.elements[0]);j.setFromMatrixColumn(a.matrixWorld,0).multiplyScalar(o*(Math.round(w)-w));k.setFromMatrixColumn(a.matrixWorld,1).multiplyScalar(o*(Math.round(x)-x));i.add(j).add(k);}this._billboard.scale.set(this._width*o,this._height*o,1);this._billboard.updateMatrixWorld();};
g.prototype._ortho2DUpdate=function(r,a){var o=this.userData.originalTransform;var z=Math.min(a.near*(1+o.s.length()),(a.near+a.far)*0.5);this.position.copy(o.p).multiplyScalar(2/a.projectionMatrix.elements[5]);this.position.z=-1;this.position.multiplyScalar(z).applyMatrix4(a.matrixWorld);this.quaternion.copy(a.quaternion).multiply(o.q);this.scale.copy(o.s).multiplyScalar(z*0.5);this.scale.z=Math.min(z-a.near,this.scale.z*0.001);this.matrixWorld.compose(this.position,this.quaternion,this.scale);this.matrix.getInverse(this.parent.matrixWorld).multiply(this.matrixWorld);this.matrix.decompose(this.position,this.quaternion,this.scale);this.updateMatrixWorld(true);};
g.prototype._billboardViewUpdate=function(r,a){this.parent.matrixWorld.decompose(l,q,m);q.inverse().multiply(a.quaternion);this.quaternion.copy(q);};
g.prototype._lockToViewportUpdate=function(r,a){var s=THREE.Math.lerp(a.near,a.far,1e-4);this.position.setFromMatrixColumn(a.matrixWorld,2).multiplyScalar(-s);this.position.add(a.position);this.scale.setScalar(s*2/a.projectionMatrix.elements[5]);this.matrixWorld.compose(this.position,a.quaternion,this.scale);this.matrix.getInverse(this.parent.matrixWorld).multiply(this.matrixWorld);this.matrix.decompose(this.position,this.quaternion,this.scale);};
return g;});
sap.ui.predefine('sap/ui/vk/threejs/Callout',["./thirdparty/three","sap/ui/base/ManagedObject","./Billboard","../thirdparty/html2canvas","./PolylineGeometry","./PolylineMaterial","./PolylineMesh","../BillboardStyle","../LeaderLineMarkStyle"],function(a,B,b,c,P,d,e,f,L){"use strict";
var C=b.extend("sap.ui.vk.threejs.Callout",{metadata:{properties:{anchorNode:{type:"any",defaultValue:null},depthTest:{type:"boolean",defaultValue:true}}}});
C.prototype.init=function(){if(b.prototype.init){b.prototype.init.call(this);}this._lines=[];};
C.prototype.setRenderOrder=function(h){b.prototype.setRenderOrder.call(this,h);this._lines.forEach(function(l){l.renderOrder=h;});return this;};
C.prototype.setDepthTest=function(h){this.setProperty("depthTest",h,true);this._billboard.material.depthTest=h;this._lines.forEach(function(l){l.material.depthTest=h;});return this;};
var g=new THREE.Vector4(),j=new THREE.Vector4(),k=new THREE.Vector4(),m=new THREE.Vector2(),n=new THREE.Vector2(),o=new THREE.Vector2(),q=new THREE.Quaternion(),r=new THREE.Matrix4(),u=new THREE.Vector2(),v=new THREE.Vector3(),w=new THREE.Vector3(),z=new THREE.Vector3(0,0,1),A=new THREE.Vector2(),D=new THREE.Matrix4(),E=new THREE.Matrix4();
C.prototype._update=function(h,i,l){if(this._needUpdateTexture){this._needUpdateTexture=false;this._updateTexture();}var s=this.getNode();s.matrix.getInverse(s.parent.matrixWorld);s.matrix.decompose(s.position,s.quaternion,s.scale);s.matrixWorld.identity();var x=this.getPosition(),y=this._billboard.position;if(x){y.copy(x);}else{y.setScalar(0);}var F=this.getAnchorNode();if(F){y.applyMatrix4(F.matrixWorld);}this._billboard.quaternion.copy(i.quaternion);if(l){A.copy(l);}else{l=h.getSize();A.set(l.width,l.height);}D.multiplyMatrices(i.projectionMatrix,i.matrixWorldInverse);g.copy(y).applyMatrix4(D);m.copy(g).multiplyScalar(1/g.w).multiply(A);var G=g.w*2/(A.x*i.projectionMatrix.elements[0]);this._billboard.scale.set(G*this._width,G*this._height,1);v.setFromMatrixColumn(i.matrixWorld,0).multiplyScalar(G*(Math.round(m.x*0.5)-m.x*0.5));w.setFromMatrixColumn(i.matrixWorld,1).multiplyScalar(G*(Math.round(m.y*0.5)-m.y*0.5));y.add(v).add(w);this._billboard.updateMatrixWorld();var H=this.getStyle()===f.CircularShape;var I=i.near;function J(p,t,K){if(p<t){return p-t;}else if(p>K){return p-K;}return 0;}this._lines.forEach(function(p){if(p.userData.targetNode){p.matrix.copy(p.userData.targetNode.matrixWorld);}else{p.matrix.identity();}p.matrixWorld.copy(p.matrix);if(p.isPolylineMesh){p.material.resolution.copy(A);}if(p.isHaloMesh){return;}var K=p.geometry.vertices;var M=K[0];var N=K[K.length-2];var O=K[K.length-1];var Q=p.userData.startPointMesh;var R=false;var S=[0,K.length-1];if(Q!==undefined){M.copy(Q.userData.targetVertex);}E.multiplyMatrices(D,p.matrixWorld);if(p.userData.extensionLength>0&&K.length>2){S.push(K.length-2);g.copy(K[K.length-3]).applyMatrix4(E);n.copy(g).multiplyScalar(1/g.w).multiply(A);N.set(Math.sign(n.x-m.x)*0.5*(1+p.userData.extensionLength/this._width),0,0);N.applyMatrix4(this._billboard.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}g.copy(N).applyMatrix4(E);n.copy(g).multiplyScalar(1/g.w).multiply(A);if(H){var T=u.copy(n).sub(m).length();R=T<this._width;u.multiplyScalar(0.5/T);O.set(u.x,u.y,0);}else{var U=J(n.x,m.x-this._width,m.x+this._width),V=J(n.y,m.y-this._height,m.y+this._height);R=(U===0&&V===0);if(Math.abs(U)>Math.abs(V)){O.set(Math.sign(U)*0.5,0,0);}else{O.set(0,Math.sign(V)*0.5,0);}}if(R){O.copy(N);}else{O.applyMatrix4(this._billboard.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}p.geometry.verticesNeedUpdate=true;if(Q!==undefined){Q.position.copy(Q.userData.targetVertex).applyMatrix4(p.matrixWorld);g.copy(Q.position).applyMatrix4(D);var W=g.w/(A.x*i.projectionMatrix.elements[0]);Q.scale.setScalar(W);Q.visible=false;var X=false;if(g.w>=I){j.copy(g);k.copy(K[1]).applyMatrix4(E);if(k.w<I){var t=(j.w-I)/(j.w-k.w);k.sub(j).multiplyScalar(t).add(j);}o.copy(j).multiplyScalar(1/j.w);n.copy(k).multiplyScalar(1/k.w);u.copy(n).sub(o).multiply(A);X=u.length()<Q.userData.lineOffset;q.setFromAxisAngle(z,Math.atan2(u.y,u.x));Q.quaternion.copy(i.quaternion).multiply(q);Q.matrix.compose(Q.position,Q.quaternion,Q.scale);Q.matrixWorld.copy(Q.matrix);o.multiply(A).sub(m);Q.visible=H?o.length()>this._width:Math.abs(o.x)>this._width||Math.abs(o.y)>this._height;if(X||!Q.visible){M.copy(K[1]);}else{M.set(Q.userData.lineOffset,0,0).applyMatrix4(Q.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}}}p.geometry._updateVertices(S);p.computeLineDistances(E,A,i instanceof THREE.PerspectiveCamera?I:undefined);if(p.userData.haloMesh){p.userData.haloMesh.material.lineLength=p.material.lineLength;}}.bind(this));};
C.prototype._createMarkMesh=function(p,t,F,G){var H=F===L.Arrow;var I=window.devicePixelRatio;var J=t.width;var K=J*t.haloWidth;G=(Array.isArray(G)||G instanceof Float32Array)&&G.length===2?G:[1,1];var M,N;if(H){M=Math.max(35*G[0],J*5);N=Math.max(15*G[1],J*2);}else{M=N=Math.max(2*G[0],J*2);}M=Math.ceil(M+K*2);N=Math.ceil(N+K*2);var O=document.createElement("canvas");O.width=THREE.Math.ceilPowerOfTwo(M*I);O.height=THREE.Math.ceilPowerOfTwo(N*I);var Q=O.getContext("2d");var x=M/2,y=N/2;Q.fillStyle="#FFF";Q.scale(I,I);if(H){Q.beginPath();Q.moveTo(0,y);Q.lineTo(M,0);Q.lineTo(M,N);Q.closePath();Q.fill();var h=M*y/Math.sqrt(M*M+y*y),s=(h-K)/h;var R=M-M*s,S=y*(M*s-K)/M;Q.fillStyle=p.getStyle();Q.beginPath();Q.moveTo(R,y);Q.lineTo(M-K,y-S);Q.lineTo(M-K,y+S);Q.closePath();Q.fill();}else{var T=M*0.5,U=T-K;Q.beginPath();Q.ellipse(x,y,T,T,0,0,Math.PI*2);Q.fill();Q.fillStyle=p.getStyle();Q.beginPath();Q.ellipse(x,y,U,U,0,0,Math.PI*2);Q.fill();}Q.fillRect(M-K,y-J*0.5,K,J);var V=new THREE.MeshBasicMaterial({map:new THREE.CanvasTexture(O),flatShading:true,transparent:true,alphaTest:0.05,premultipliedAlpha:true,side:THREE.DoubleSide,depthTest:this.getDepthTest()});var W=new THREE.PlaneBufferGeometry(M*2,N*2);if(H){W.translate(M,0,0);}var X=new THREE.Mesh(W,V);X.matrixAutoUpdate=false;X.renderOrder=this.getRenderOrder();X.userData.lineOffset=(H?M*2-1:M-K*2);var Y=new THREE.Vector2(M*I/O.width,N*I/O.height);var Z=X.geometry.attributes.uv.array;for(var i=0,l=Z.length;i<l;i+=2){Z[i]*=Y.x;Z[i+1]=1-(1-Z[i+1])*Y.y;}return X;};
C.prototype.addLeaderLine=function(h,t,i,s,l,p,x){var y=this.getNode();if(x>0&&h.length<3){h.push(h[h.length-1].clone());}var F=i.userData.lineStyle||{};F.width=F.width||1;F.haloWidth=F.haloWidth||0;F.endCapStyle=F.endCapStyle||0;var G=F.endCapStyle||h.length>2?1:0;var H=(G&&(s!==L.None||F.endCapStyle===0)?1:0)|(G&&(l!==L.None||F.endCapStyle===0)?2:0);var I=new P();I.setVertices(h);var J;if(F.haloWidth>0){var K=new d({color:0xFFFFFF,lineColor:0xFFFFFF,linewidth:F.width*(F.haloWidth*2+1),dashCapStyle:F.endCapStyle,segmentCapStyle:G,trimStyle:H,transparent:true,depthTest:this.getDepthTest()});J=new e(I,K);J.userData.targetNode=t;J.matrixAutoUpdate=false;J.renderOrder=this.getRenderOrder();J.isHaloMesh=true;y.add(J);this._lines.push(J);}var M=new d({color:0xFFFFFF,lineColor:i.color,linewidth:F.width,dashCapStyle:F.endCapStyle,segmentCapStyle:G,trimStyle:H,dashPattern:F.dashPattern||[],dashScale:F.dashPatternScale||1,transparent:true,depthTest:this.getDepthTest()});var N=new e(I,M);N.userData.targetNode=t;N.userData.extensionLength=x;N.userData.haloMesh=J;N.matrixAutoUpdate=false;N.renderOrder=this.getRenderOrder();y.add(N);this._lines.push(N);if(s!==L.None){var O=this._createMarkMesh(i.color,F,s,p);O.userData.targetVertex=I.vertices[0].clone();N.userData.startPointMesh=O;y.add(O);}return N;};
return C;});
sap.ui.predefine('sap/ui/vk/threejs/ContentDeliveryService',["jquery.sap.global","sap/ui/base/ManagedObject","../totara/TotaraLoader","./Material","./thirdparty/three","../getResourceBundle","../ObjectType"],function(q,M,T,a,t,g,O){"use strict";
var C=M.extend("sap.ui.vk.threejs.ContentDeliveryService",{metadata:{properties:{authorizationHandler:"any"},events:{cameraChanged:{parameters:{sceneId:{type:"string"},camera:{type:"any"}},enableEventBubbling:true},sceneUpdated:{parameters:{},enableEventBubbling:true},viewGroupUpdated:{parameters:{currentViewGroupId:"string"},enableEventBubbling:true},sceneCompleted:{parameters:{sceneId:{type:"string"}},enableEventBubbling:true},loadingFinished:{parameters:{currentViewId:"string",currentViewGroupId:"string"},enableEventBubbling:true},errorReported:{parameters:{error:{type:"any"}}}}}});
var b=C.getMetadata().getParent().getClass().prototype;
C.prototype.init=function(){if(b.init){b.init.call(this);}this._loader=null;this._transientSceneMap=new Map();this._currentNodeHierarchy=null;};
C.prototype.initUrl=function(u,k,c){var d=this;function n(){d.fireSceneUpdated({});}function e(){var h;if(d._loader&&d._loader.currentSceneInfo){var i=d._loader.getContext(d._loader.currentSceneInfo.id);if(i){h=i.currentViewGroupId;}}d.fireViewGroupUpdated({currentViewGroupId:h});}if(!this._loader||this._loader.getUrl()!==u){if(this._loader){this._loader.dispose();}this._loader=new T();this._loader.onErrorCallbacks.attach(this._reportError.bind(d));this._loader.onMaterialFinishedCallbacks.attach(n);this._loader.onImageFinishedCallbacks.attach(n);this._loader.onSetGeometryCallbacks.attach(n);this._loader.onViewGroupUpdatedCallbacks.attach(e);var f=c?c:THREE.Math.generateUUID().toLowerCase();return this._loader.init(u,f);}else if(!k){this._loader.cleanup();}return Promise.resolve("Loader is ready");};
C.prototype._reportError=function(e){this.fireErrorReported(e);};
C.prototype._createLoadParam=function(r,c,p,d){var e=this;var i;var s=false;var f;if(this._currentNodeHierarchy){f=this._currentNodeHierarchy.getScene();}var h={root:p,includeHidden:d.getIncludeHidden(),includeAnimation:d.getIncludeAnimation(),pushPMI:d.getPushPMI(),metadataFilter:d.getMetadataFilter(),useSecureConnection:d.getUseSecureConnection(),activateView:d.getActivateView(),enableLogger:d.getEnableLogger()===true,pushViewGroups:d.getPushViewGroups(),vkScene:f,onActiveCamera:function(n){var k=false;var l=e._loader.getContext(d.getVeid());if(l&&l.phase<2){i=n;k=true;}if(!k){e.fireCameraChanged({sceneId:d.getVeid(),camera:n});}},onInitialSceneFinished:function(k){s=true;r({node:p,camera:i,contentResource:d,initialView:k,loader:e});},onSceneCompleted:function(){e.fireSceneCompleted({sceneId:d.getVeid()});},onLoadingFinished:function(){var k,l;if(e._loader&&e._loader.currentSceneInfo){var m=e._loader.getContext(e._loader.currentSceneInfo.id);if(m){k=m.currentViewId;l=m.currentViewGroupId;}}e.fireLoadingFinished({currentViewId:k,currentViewGroupId:l});}};var j=function(k){var l;if(k.getParameter("errorText")){l=k.getParameter("errorText");}else if(k.getParameter("error")){l=k.getParameter("error");}else if(k.getParameter("reason")){l=k.getParameter("reason");}else{l="failed to load: unknown reason";}if(s){var m=k.getParameter("error");if(m&&m===4){e.initUrl(this._loader.getUrl(),true);}}else{e.detachErrorReported(j);if(k.getParameter("events")){l=l+"\n"+JSON.stringify(k.getParameter("events"));}c(l);}};e.attachErrorReported(j);return h;};
C.prototype.load=function(p,c,d){var e=this;var n=c.getNodeProxy();if(n){this._currentNodeHierarchy=n.getNodeHierarchy();}return new Promise(function(r,f){if(!c.getSource()||!c.getVeid()){f(g().getText("CONTENTDELIVERYSERVICE_MSG_NOURLORVEID"));return;}e.initUrl(c.getSource(),true);var h=e._createLoadParam(r,f,p,c);if(e._loader){e._loader.request(c.getVeid(),h,d);}});};
C.prototype.getSceneBuilder=function(){if(this._loader){return this._loader.getSceneBuilder();}return null;};
C.prototype.decrementResourceCountersForDeletedTreeNode=function(s){var c=this._loader.getContext(this._loader.currentSceneInfo.id);this._loader.decrementResourceCountersForDeletedTreeNode(c,s);};
C.prototype.loadTransientScene=function(s,p,u){var c=this;return new Promise(function(r,d){if(!s||!p){d(g().getText("CONTENTDELIVERYSERVICE_MSG_INVALIDARGUMENTS"));return;}if(c._transientSceneMap.has(s)){var e=c._transientSceneMap.get(s).clone();p.add(e);r({nodeRef:e});return;}if(!c._loader){d(g().getText("CONTENTDELIVERYSERVICE_MSG_CONTENTDELIVERYSERVICENOTINITIALISED"));return;}var f=new THREE.Object3D();f.name="transient";var o=function(){var i=c._loader.getContext(s);i.onSceneCompletedCallbacks.detach(o);c._transientSceneMap.set(s,f);var e=f.clone();p.add(e);r({nodeRef:e});};var h={root:f,onSceneCompleted:o,useSecureConnection:u};c._loader.request(s,h);});};
C.prototype.update=function(s,c,v){var d=this;return new Promise(function(r,e){if(!d._loader){e(g().getText("CONTENTDELIVERYSERVICE_MSG_CONTENTDELIVERYSERVICENOTINITIALISED"));return;}d._loader.update(s,c,v).then(function(f){if(d._currentNodeHierarchy){for(var i=0;i<f.replacedNodeRefs.length;i++){d._currentNodeHierarchy.fireNodeReplaced({ReplacedNodeRef:f.replacedNodeRefs[i],ReplacementNodeRef:f.replacementNodeRefs[i],ReplacedNodeId:f.replacedNodeRefs[i],ReplacementNodeId:f.replacementNodeRefs[i]});}}r({sceneVeId:f.sceneVeId,sids:f.sidArray});}).catch(function(f){return e(f);});});};
C.prototype.exit=function(){if(b.exit){b.exit.call(this);}if(this._loader){this._loader.dispose();this._loader=null;}this._transientSceneMap=null;};
C.prototype.loadView=function(s,v,c,d){if(typeof c==="undefined"){c="static";}var e=this;return this._loader.requestView(s,c,v,null,d).then(function(f){if(e._currentNodeHierarchy&&f.updatedNodes){for(var i=0;i<f.updatedNodes.length;i++){e._currentNodeHierarchy.fireNodeUpdated({nodeRef:f.updatedNodes[i]});}}e.fireSceneUpdated({});return f;}).catch(function(f){q.sap.log.error(f);return null;});};
C.prototype.updatePlaybacks=function(s,v,p){var c=this;return this._loader.requestView(s,"static",v,p,true).then(function(d){if(c._currentNodeHierarchy&&d.updatedNodes){for(var i=0;i<d.updatedNodes.length;i++){c._currentNodeHierarchy.fireNodeUpdated({nodeRef:d.updatedNodes[i]});}}c.fireSceneUpdated({});return d;}).catch(function(e){q.sap.log.error(e);return null;});};
C.prototype.loadViewGroup=function(s,v,i){var c=this;return this._loader.requestViewGroup(s,v,i).then(function(d){c.fireSceneUpdated({});return d;}).catch(function(e){q.sap.log.error(e);return null;});};
C.prototype.assignMaterialToNodes=function(s,m,n,c){var d=this;return this._loader.requestMaterial(s,m).then(function(e){function f(e,l,r){if(!l){return;}if(l.userData.markedForNotAssigningMaterial){delete l.userData.markedForNotAssigningMaterial;return;}if(d._currentNodeHierarchy){var o=d._currentNodeHierarchy.createNodeProxy(l);var p=new a();p.setMaterialRef(e);o.assignMaterial(p);d._currentNodeHierarchy.destroyNodeProxy(o);}if(r){l.children.forEach(function(u){if(!u||u.userData.objectType===O.PMI||u.userData.objectType===O.Hotspot){return;}f(e,u,r);});}}if(!c){for(var i=0;i<n.length;i++){f(e,n[i],true);}}else{for(var j=0;j<n.length;j++){n[j].userData.markedForNotAssigningMaterial=true;}var h=d._loader.getContext(s);var k=h.root;f(e,k,true);}d.fireSceneUpdated({});return true;}).catch(function(e){q.sap.log.error(e);return false;});};
C.prototype.printLogTokens=function(){if(this._loader){this._loader.printLogTokens();return true;}else{return false;}};
return C;});
sap.ui.predefine('sap/ui/vk/threejs/ContentManager',["sap/base/Log","./thirdparty/three","../ContentManager","./Scene","../TransformationMatrix","./PerspectiveCamera","./OrthographicCamera","../Messages","../getResourceBundle","./ContentDeliveryService","./Viewport","./ViewStateManager"],function(L,t,C,S,T,P,O,M,g,a){"use strict";
var b=C.extend("sap.ui.vk.threejs.ContentManager",{metadata:{library:"sap.ui.vk"}});
var c=b.getMetadata().getParent().getClass().prototype;
b.prototype.init=function(){if(c.init){c.init.call(this);}};
b.prototype.exit=function(){if(this.defaultCdsLoader){this.defaultCdsLoader.destroy();this.defaultCdsLoader=null;}if(c.exit){c.exit.call(this);}};
function s(o){if(o&&o.isMesh){o.castShadow=true;o.receiveShadow=false;}if(o&&o.children){for(var n=0;n<o.children.length;n++){s(o.children[n]);}}}
function e(n,f){if(n){var h=new THREE.Group();n.add(h);h.name="DefaultLights";h.private=true;var i=new THREE.Box3().setFromObject(n);var j=new THREE.Vector3();i.getSize(j);var m=j.length();var p=new THREE.PointLight();p.color.setRGB(0.72,0.72,0.81);i.getCenter(p.position);p.visible=true;p.private=true;h.add(p);var k=[new THREE.Color(0.2,0.2,0.2),new THREE.Color(0.32,0.32,0.36),new THREE.Color(0.36,0.36,0.36)];var o=[new THREE.Vector3(2.0,1.5,0.5),new THREE.Vector3(-2.0,-1.1,2.5),new THREE.Vector3(-0.04,-0.01,-2.0)];for(var l=0,q=k.length;l<q;l++){var r=new THREE.DirectionalLight();r.color.copy(k[l]);r.position.copy(o[l]);r.private=true;h.add(r);}if(f){s(n);var u=new THREE.DirectionalLight();u.color.setRGB(0.5,0.5,0.5);u.position.set(0,1,0);u.castShadow=true;u.shadow.mapSize.width=512;u.shadow.mapSize.height=512;var d=2000;u.shadow.camera.left=-d;u.shadow.camera.right=d;u.shadow.camera.top=d;u.shadow.camera.bottom=-d;u.shadow.camera.far=3500;u.shadow.bias=-0.0001;u.private=true;h.add(u);var v=new THREE.PlaneBufferGeometry(i.getSize().x,i.getSize().z);var w=new THREE.ShadowMaterial();w.opacity=0.2;var x=new THREE.Mesh(v,w);x.rotation.x=-Math.PI/2;x.position.x=i.getCenter().x;x.position.y=i.min.y-m*0.1;x.position.z=i.getCenter().z;n.add(x);x.receiveShadow=true;}}}
b.prototype.loadContent=function(d,f){var h=this;var l=function(){h.fireContentChangesStarted();var j=new THREE.Scene(),k=new S(j);h._loadContentResources(k,f).then(function(v){if(v&&v.length>0&&v[0].initialView){k.setInitialView(v[0].initialView);}for(var n=0;n<v.length;n++){if(v[n].camera){k.camera=v[n].camera;break;}}if(v.length>0){var m=v[0];k.backgroundTopColor=m.backgroundTopColor;k.backgroundBottomColor=m.backgroundBottomColor;k.renderMode=m.renderMode;}for(var i=0;i<v.length;i++){if(v[i].loader){k.loaders=k.loaders||[];k.loaders.push(v[i].loader);}if(v[i].builder){k.builders=k.builders||[];k.builders.push(v[i].builder);}}if(k.loaders){h._initSceneWithCDSLoaderIfExists(k,k.loaders);}e(k.getSceneRef(),false);h.fireContentChangesFinished({content:k});},function(r){var i;if(typeof r==="string"){i=r;}else if(r.errorText){i=r.errorText;}else if(r.message){i=r.message;}i=i||g().getText(M.VIT37.summary);L.error(g().getText("CONTENTMANAGER_MSG_CONTENTRESOURCESFAILEDTOLOAD"),i);h.fireContentChangesFinished({content:null,failureReason:[{error:r,errorMessage:i}]});});};l();return this;};
b.prototype._findLoader=function(d){if(d.getSourceType()==="vds4"){return new Promise(function(r){sap.ui.require(["sap/ui/vk/threejs/MataiLoader"],function(i){r(i);});});}if(d._contentManagerResolver&&d._contentManagerResolver.settings&&d._contentManagerResolver.settings.loader){return Promise.resolve(d._contentManagerResolver.settings.loader);}if(d.getSource()){var f=d.getSourceType();if(f==="stream"){if(this.defaultCdsLoader==null){var h=this;return new Promise(function(r){var i="sap/ui/vk/threejs/ContentDeliveryService";sap.ui.require([i],function(j){r(h.defaultCdsLoader=new j({authorizationHandler:h._authorizationHandler}));});});}return Promise.resolve(this.defaultCdsLoader);}}return Promise.resolve(null);};
b.prototype._loadContentResources=function(d,f){var p=[];f.forEach(function loadContentResource(h,i){var n=new THREE.Group();n.name=i.getName();n.sourceId=i.getSourceId();i._shadowContentResource={nodeProxy:d.getDefaultNodeHierarchy().createNodeProxy(n)};var l=i.getLocalMatrix();if(l){n.applyMatrix(new THREE.Matrix4().fromArray(T.convertTo4x4(l)));}h.add(n);var j=this;p.push(this._findLoader(i).then(function(k){if(typeof k==="function"){return k(n,i,j._authorizationHandler);}else if(k&&k.load){return k.load(n,i,j._authorizationHandler);}else{return Promise.resolve({node:n,contentResource:i});}}));i.getContentResources().forEach(loadContentResource.bind(this,n));}.bind(this,d.getSceneRef()));return Promise.all(p);};
b.prototype._initSceneWithCDSLoaderIfExists=function(d,l){if(l){var f;for(var i=0;i<l.length;i++){if(l[i]instanceof a){f=l[i].getSceneBuilder();break;}}if(f){d._setSceneBuilder(f);d.getDefaultNodeHierarchy().attachNodeRemoving(function(h){var r=h.getParameter("nodeRef");if(r.userData.treeNode&&r.userData.treeNode.sid){f.decrementResourceCountersForDeletedTreeNode(r.userData.treeNode.sid);}});return true;}}return false;};
b.prototype.createOrthographicCamera=function(){return new O();};
b.prototype.createPerspectiveCamera=function(){return new P();};
return b;});
sap.ui.predefine('sap/ui/vk/threejs/DetailView',["./thirdparty/three","sap/ui/base/ManagedObject","../thirdparty/html2canvas","../DetailViewType","../DetailViewShape","./OrthographicCamera","./PerspectiveCamera"],function(t,B,c,D,d,O,P){"use strict";
var e=B.extend("sap.ui.vk.threejs.DetailView",{metadata:{properties:{name:{type:"string",defaultValue:""},camera:{type:"any",defaultValue:null},type:{type:"sap.ui.vk.DetailViewType",defaultValue:D.DetailView},shape:{type:"sap.ui.vk.DetailViewShape",defaultValue:d.Box},borderWidth:{type:"float",defaultValue:2},backgroundColor:{type:"sap.ui.core.CSSColor",defaultValue:"#fff"},borderColor:{type:"sap.ui.core.CSSColor",defaultValue:"#000"},origin:{type:"any",defaultValue:new THREE.Vector3(0,0)},size:{type:"any",defaultValue:new THREE.Vector3(0.5,0.5)},attachmentPoint:{type:"any",defaultValue:null},metadata:{type:"any",defaultValue:{}},veId:{type:"any",defaultValue:{}}}}});
e.prototype.init=function(){if(B.prototype.init){B.prototype.init.call(this);}this._backgroundColor=new THREE.Color();this._node=new THREE.Group();var b=new THREE.MeshBasicMaterial({depthTest:false});this._line=new THREE.Mesh(new THREE.BufferGeometry(),b);this._line.renderOrder=0;this._node.add(this._line);var a=new THREE.BufferGeometry();a.setIndex([0,1,2]);var f=new THREE.MeshBasicMaterial({color:this._backgroundColor,depthTest:false});this._triangle=new THREE.Mesh(a,f);this._triangle.renderOrder=1;this._node.add(this._triangle);this._billboard=new THREE.Mesh(new THREE.BufferGeometry(),new THREE.MeshBasicMaterial({depthTest:false}));this._billboard.renderOrder=2;this._node.add(this._billboard);this._border=new THREE.Mesh(new THREE.BufferGeometry(),b);this._border.renderOrder=3;this._node.add(this._border);};
e.prototype.setCamera=function(a){if(a instanceof P||a instanceof O){this.setProperty("camera",a,true);}return this;};
e.prototype.setShape=function(a){this.setProperty("shape",a,true);return this;};
e.prototype.setBackgroundColor=function(a){this.setProperty("backgroundColor",a,true);this._backgroundColor.setStyle(a);this._triangle.material.color.copy(this._backgroundColor);return this;};
e.prototype.setBorderColor=function(a){this.setProperty("borderColor",a,true);this._border.material.map=null;return this;};
e.prototype.setBorderWidth=function(a){this.setProperty("borderWidth",a,true);this._border.material.map=null;return this;};
e.prototype.setOrigin=function(a){if(a instanceof THREE.Vector2){this.setProperty("origin",a,true);}return this;};
e.prototype.setSize=function(a){if(a instanceof THREE.Vector2){this.setProperty("size",a,true);}return this;};
var g=-0.5,j=1.5,p=new THREE.Vector4(),k=new THREE.Vector3(),n=new THREE.Vector3(),o=new THREE.Vector3(),q=new THREE.Vector2(),s=new THREE.Vector2(),r=new THREE.Vector2(),v=new THREE.Matrix4();
function z(a,b){return Math.PI*(3*(a+b)-Math.sqrt((3*a+b)*(a+3*b)));}
function A(a,b,h,i,l,m){var u=a[b],w=a[b+1],x=a[l],y=a[l+1],J=a[m],K=a[m+1],L=i-w,M=u-h;var f=((x-u)*L+(y-w)*M)/((x-J)*L+(y-K)*M);a[l]=x+(J-x)*f;a[l+1]=y+(K-y)*f;}
function C(f,a,b,h){q.set(f[b+1]-f[a+1],f[a]-f[b]).normalize().multiplyScalar(h);f[a]+=q.x;f[a+1]+=q.y;f[b]+=q.x;f[b+1]+=q.y;}
function E(a,b){var f=a.length;for(var h=0;h<6;h+=3){var l=h===0?b*g:b*j;var m=a[h],u=a[h+1];for(var i=h;i<f-6;i+=6){var w=a[i],x=a[i+1];a[i]=m;a[i+1]=u;m=a[i+6];u=a[i+7];C(a,i,i+6,l);if(i>h){A(a,i-6,w,x,i,i+6);}}}}
e.prototype._createBoxViewport=function(a,b,f,h){var l=[-a,-b,0,a,-b,0,a,b,0,-a,b,0];var m=this._billboard.geometry;m.setIndex([0,1,2,0,2,3]);m.addAttribute("position",new THREE.Float32BufferAttribute(l,3));m.addAttribute("uv",new THREE.Float32BufferAttribute([0,0,1,0,1,1,0,1],2));if(this._border.visible){var u=[],i;for(i=0;i<l.length;i+=3){var x=l[i],y=l[i+1];u.push(x,y,0,x,y,0);}u.push(u[0],u[1],0,u[0],u[1],0);E(u,this._borderWidth);i=u.length-6;u[0]=u[i];u[i+1]=u[1];u[3]=u[i+3];u[i+4]=u[4];this._createBorderGeometry(this._border.geometry,u);}};
e.prototype._createCircleViewport=function(b,f,h,l){var m=[0,0,0],u=[0.5,0.5],w=[];var x=THREE.Math.clamp(Math.round(z(b,f)/24),32,256);var y=2*Math.PI/x;for(var i=0;i<x;i++){var a=i*y,J=Math.cos(a),K=Math.sin(a);m.push(J*b,K*f,0);u.push(J*0.5+0.5,K*0.5+0.5);w.push(0,i+1,i+1<x?i+2:1);}var L=this._billboard.geometry;L.setIndex(w);L.addAttribute("position",new THREE.Float32BufferAttribute(m,3));L.addAttribute("uv",new THREE.Float32BufferAttribute(u,2));var M=this._borderWidth*j;this._createCircleBorder(m,b,f,h&&q.set(h.x/(b+M),h.y/(f+M)).length()>1?h:null,l);};
e.prototype._createCircleBorder=function(b,f,h,m,u){var w=this._borderWidth,J=[],i,x,y;if(m&&(u!==d.Circle&&u!==d.CircleLine)){J.push(m.x,m.y,0,m.x,m.y,0);var K=Math.PI*0.05;var L=Math.atan2(m.y*f,m.x*h)+K;var M=(b.length/3)-3;K=2*(Math.PI-K)/M;for(i=0;i<=M;i++){var a=L+i*K;x=Math.cos(a)*f;y=Math.sin(a)*h;J.push(x,y,0,x,y,0);}var N=[m.x,m.y,0,J[6],J[7],0,J[J.length-3],J[J.length-2],0];J.push(m.x,m.y,0,m.x,m.y,0);E(J,w);i=J.length-6;var Q=q.set(J[9],J[10]).sub(m).length();var R=q.set(J[9]-J[i-3],J[10]-J[i-2]).length()*0.5;var l=m.length();l=1-w*2*Q/(R*l);J[i+0]=J[0]=m.x*l;J[i+1]=J[1]=m.y*l;J[i+3]=J[3]=m.x;J[i+4]=J[4]=m.y;var S=this._triangle.geometry;l=(1+l)*0.5;N[0]*=l;N[1]*=l;S.addAttribute("position",new THREE.Float32BufferAttribute(N,3));this._triangle.visible=true;this._triangle.material.color.set(u===d.SolidPointer||u===d.SolidArrow?this.getBorderColor():this._backgroundColor);}else{this._line.visible=this._line.visible&&m!==null;for(i=3;i<b.length;i+=3){x=b[i];y=b[i+1];J.push(x,y,0,x,y,0);}J.push(J[0],J[1],0,J[0],J[1],0);E(J,w);i=J.length-6;J[i]=J[0]=b[3]+w*g;J[i+3]=J[3]=b[3]+w*j;J[i+1]=J[1]=b[4];J[i+4]=J[4]=b[4];}this._createBorderGeometry(this._border.geometry,J);};
e.prototype._createBorderGeometry=function(a,b){var i,f=b.length/3;var h=[];for(i=2;i<f;i+=2){h.push(i-1,i,i-2,i+1,i,i-1);}var l=[];var u=this._borderU;for(i=0;i<f;i+=2){l.push(0,0.5,u,0.5);}a.setIndex(h);a.addAttribute("position",new THREE.Float32BufferAttribute(b,3));a.addAttribute("uv",new THREE.Float32BufferAttribute(l,2));};
e.prototype._createLine=function(a){var b=[0,0,0,0,0,0,a.x,a.y,0,a.x,a.y,0];C(b,0,6,-this._borderWidth);C(b,3,9,this._borderWidth);this._createBorderGeometry(this._line.geometry,b);};
e.prototype._updateGeometry=function(s,a,b){var f=this.getShape(),h=this.getAttachmentPoint(),i=this.getOrigin();this._border.visible=f!==d.BoxNoOutline;this._line.visible=f===d.BoxLine||f===d.CircleLine;this._triangle.visible=false;if(h){p.copy(h).applyMatrix4(b.matrixWorldInverse).applyMatrix4(b.projectionMatrix);h=p.w>0?h:null;var l=(p.x/p.w)*a.width/a.height,m=p.y/p.w;o.set(l-i.x,m-i.y,0).multiplyScalar(a.height);}switch(f){default:case d.Box:case d.BoxLine:case d.BoxNoOutline:this._createBoxViewport(s.x,s.y,h?o:null,f);break;case d.Circle:case d.CircleLine:case d.CirclePointer:case d.CircleArrow:case d.CircleBubbles:case d.SolidPointer:case d.SolidArrow:this._createCircleViewport(s.x,s.y,h?o:null,f);break;}if(this._line.visible){this._createLine(o);}};
e.prototype._updateBorderTexture=function(a){var b=Math.round(this.getBorderWidth()*a);this._borderWidth=b+2;var f=THREE.Math.ceilPowerOfTwo(this._borderWidth);this._borderU=this._borderWidth/f;this._borderWidth/=a;var h=new ArrayBuffer(f*4);var l=new Uint32Array(h);var m=new THREE.Color(this.getBorderColor());m=(m.r*255)|((m.g*255)<<8)|((m.b*255)<<16)|0xFF000000;l.fill(m&0xFFFFFF);for(var i=1;i<=b;i++){l[i]=m;}var u=new THREE.DataTexture(new Uint8Array(h),f,1,THREE.RGBAFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.LinearFilter,THREE.LinearFilter);u.needsUpdate=true;this._border.material.map=u;this._border.material.needsUpdate=true;this._line.material=this._border.material;};
function F(a){var m=a.elements;var i=m[15]===1;var b=2/m[0];var f=2/m[5];var h,l;if(i){h=-m[12]*b;l=-m[13]*f;}else{h=m[8]*b;l=m[9]*f;}var u=(b+h)*0.5;var w=h-u;var x=(f+l)*0.5;var y=l-x;return{left:w,top:x,right:u,bottom:y};}
function G(a,b){var m=a.elements;var i=m[15]===1;m[0]=2/(b.right-b.left);m[5]=2/(b.top-b.bottom);if(i){m[12]=-(b.right+b.left)/(b.right-b.left);m[13]=-(b.top+b.bottom)/(b.top-b.bottom);}else{m[8]=(b.right+b.left)/(b.right-b.left);m[9]=(b.top+b.bottom)/(b.top-b.bottom);}}
function H(a,b,s,f){var w=s.x/f.width;var h=s.y/f.height;p.copy(b).applyMatrix4(a.matrixWorldInverse).applyMatrix4(a.projectionMatrix);var x=((p.x/p.w)-w)*0.5+0.5;var y=((p.y/p.w)-h)*0.5+0.5;var i=F(a.projectionMatrix);var l={};l.left=THREE.Math.lerp(i.left,i.right,x);l.right=THREE.Math.lerp(i.left,i.right,x+w);l.top=THREE.Math.lerp(i.top,i.bottom,1-y-h);l.bottom=THREE.Math.lerp(i.top,i.bottom,1-y);G(a.projectionMatrix,l);}
function I(a,b){for(var i=0,l=a.length;i<l;i++){a[i].visible=b;}}
e.prototype._render=function(a,b,f,h,i){var l=a.getSize(),m=a.getPixelRatio(),u=this.getOrigin(),w=this._node,x=w.position;if(!this._border.material.map){this._updateBorderTexture(m);}s.copy(this.getSize()).multiplyScalar(l.height*0.5);s.set(Math.round(s.x)<<1,Math.round(s.y)<<1);x.set(u.x*l.height/l.width,u.y,0).unproject(b);p.copy(x).applyMatrix4(b.matrixWorldInverse).applyMatrix4(b.projectionMatrix);var y=((p.x/p.w)*0.5+0.5)*l.width,J=((p.y/p.w)*0.5+0.5)*l.height;var K=p.w/(l.width*b.projectionMatrix.elements[0]);w.scale.setScalar(K);k.setFromMatrixColumn(b.matrixWorld,0).multiplyScalar(K*2*(Math.round(y)-y));n.setFromMatrixColumn(b.matrixWorld,1).multiplyScalar(K*2*(Math.round(J)-J));x.add(k).add(n);w.quaternion.copy(b.quaternion);w.updateMatrixWorld();this._updateGeometry(s,l,b);r.copy(s).multiplyScalar(m);if(!this._renderTarget||this._renderTarget.width!==r.x||this._renderTarget.height!==r.y){this._renderTarget=new THREE.WebGLRenderTarget(r.x,r.y,{minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBFormat});this._billboard.material.map=this._renderTarget.texture;this._billboard.material.needsUpdate=true;}var L;if(this.getType()===D.Cutaway){L=b;v.copy(L.projectionMatrix);H(L,x,s,l);}else{L=this.getCamera();L.adjustClipPlanes(h);L.update(s.x,s.y);L=L.getCameraRef();}f.children.forEach(function(M){if(M.userData._vkDynamicObjects){M.userData._vkDynamicObjects.forEach(function(N){if(N.visible){if(N.isBillboard){I(N.children,false);}else{N._vkUpdate(a,L,s);}}});}});if(i){i.position.copy(L.position);}a.setClearColor(this._backgroundColor,1);a.render(f,L,this._renderTarget,true);if(L===b){b.projectionMatrix.copy(v);}a.render(this._node,b);f.children.forEach(function(M){if(M.userData._vkDynamicObjects){M.userData._vkDynamicObjects.forEach(function(N){if(N.visible&&N.isBillboard){I(N.children,true);}});}});};
return e;});
sap.ui.predefine('sap/ui/vk/threejs/MataiLoader',["sap/base/Log","./SceneBuilder"],function(L,S){"use strict";var o=function(e){var d=e.data;if(d.ready){o.resolve();}else{var s=S.getById(d.sceneBuilderId);s[d.method].apply(s,d.args);}};var a=function(e){L.error("Error in WebWorker",e);};var g=(function(){var p;return function(){return p||(p=new Promise(function(r){var w=new Worker(sap.ui.require.toUrl("sap/ui/vk/threejs/MataiLoaderWorker.js"));o.resolve=r.bind(null,w);w.onmessage=o;w.onerror=a;}));};})();var l=function(b,u,p,c,r,d){g().then(function(w){var s=new S(p,c,r,d);w.postMessage({method:"loadSceneFromArrayBuffer",sceneBuilderId:s.getId(),buffer:b,fileName:u,sourceLocation:"remote"},[b]);});};return function(p,c){return new Promise(function(r,b){if(typeof c.getSource()==="string"){var u=c.getSource();fetch(u).then(function(e){if(e.ok){return e.arrayBuffer();}throw(new Error(e.statusText));}).then(function(e){l(e,u,p,c,r,b);}).catch(function(e){b(e);});}else if(c.getSource()instanceof File){var d=new FileReader();d.onload=function(e){l(e.target.result,c.getSource().name,p,c,r,b);};d.onerror=function(e){b(e);};d.readAsArrayBuffer(c.getSource());}});};});
sap.ui.predefine('sap/ui/vk/threejs/Material',["../Material","./thirdparty/three","./Texture","../cssColorToColor","../colorToCSSColor"],function(M,t,T,a,b){"use strict";
var d=M.extend("sap.ui.vk.threejs.Material",{
metadata:{},
constructor:function(i){if(i){this._nativeMaterial=new THREE.LineBasicMaterial({color:0xaaaaaa});}else{this._nativeMaterial=new THREE.MeshPhongMaterial({color:0xaaaaaa});}M.call(this);}
});
var e=d.getMetadata().getParent().getClass().prototype;
d.prototype.init=function(){if(e.init){e.init.call(this);}};
d.prototype.getMaterialRef=function(){return this._nativeMaterial;};
d.prototype.setMaterialRef=function(m){this._nativeMaterial=m;return this;};
d.prototype.getId=function(){if(this._nativeMaterial.userData&&this._nativeMaterial.userData.materialId){return this._nativeMaterial.userData.materialId;}};
d.prototype.setId=function(v){this._nativeMaterial.userData.materialId=v;return this;};
d.prototype.getName=function(){if(this._nativeMaterial.userData&&this._nativeMaterial.userData.name){return this._nativeMaterial.userData.name;}};
d.prototype.setName=function(v){this._nativeMaterial.userData.name=v;return this;};
d.prototype.getAmbientColour=function(){};
d.prototype.setAmbientColour=function(v){return this;};
d.prototype.getDiffuseColour=function(){if(this._nativeMaterial.isMeshPhongMaterial&&this._nativeMaterial.color){var c={red:Math.round(this._nativeMaterial.color.r*255),green:Math.round(this._nativeMaterial.color.g*255),blue:Math.round(this._nativeMaterial.color.b*255),alpha:1.0};return b(c);}};
d.prototype.setDiffuseColour=function(v){if(this._nativeMaterial.isMeshPhongMaterial){var c=a(v);this._nativeMaterial.color=new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0);}return this;};
d.prototype.getEmissiveColour=function(){if(this._nativeMaterial.isMeshPhongMaterial&&this._nativeMaterial.emissive){var c={red:Math.round(this._nativeMaterial.emissive.r*255),green:Math.round(this._nativeMaterial.emissive.g*255),blue:Math.round(this._nativeMaterial.emissive.b*255),alpha:1.0};return b(c);}};
d.prototype.setEmissiveColour=function(v){if(this._nativeMaterial.isMeshPhongMaterial){var c=a(v);this._nativeMaterial.emissive=new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0);}return this;};
d.prototype.getSpecularColour=function(){if(this._nativeMaterial.isMeshPhongMaterial&&this._nativeMaterial.specular){var c={red:Math.round(this._nativeMaterial.specular.r*255),green:Math.round(this._nativeMaterial.specular.g*255),blue:Math.round(this._nativeMaterial.specular.b*255),alpha:1.0};return b(c);}};
d.prototype.setSpecularColour=function(v){if(this._nativeMaterial.isMeshPhongMaterial){var c=a(v);this._nativeMaterial.specular=new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0);}return this;};
d.prototype.getOpacity=function(){if(this._nativeMaterial.opacity){return this._nativeMaterial.opacity;}};
d.prototype.setOpacity=function(v){if(v>=0.0&&v<=1.0){this._nativeMaterial.opacity=v;this._nativeMaterial.transparent=this._nativeMaterial.opacity<1;}return this;};
d.prototype.getGlossness=function(){if(this._nativeMaterial.isMeshPhongMaterial&&this._nativeMaterial.shininess){return this._nativeMaterial.shininess/100.0;}};
d.prototype.setGlossness=function(v){if(this._nativeMaterial.isMeshPhongMaterial){this._nativeMaterial.shininess=v*100.0;}return this;};
d.prototype.getLineColour=function(){if(this._nativeMaterial.isLineBasicMaterial&&this._nativeMaterial.color){var c={red:Math.round(this._nativeMaterial.color.r*255),green:Math.round(this._nativeMaterial.color.g*255),blue:Math.round(this._nativeMaterial.color.b*255),alpha:1.0};return b(c);}};
d.prototype.setLineColour=function(v){if(this._nativeMaterial.isLineBasicMaterial){var c=a(v);this._nativeMaterial.color=new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0);}return this;};
d.prototype.getLineWidth=function(){if(this._nativeMaterial.isLineBasicMaterial&&this._nativeMaterial.linewidth!==undefined){return this._nativeMaterial.linewidth;}};
d.prototype.setLineWidth=function(v){if(this._nativeMaterial.isLineBasicMaterial){this._nativeMaterial.linewidth=v;}return this;};
d.prototype.getTextureDiffuse=function(){if(this._nativeMaterial.map){var c=new T();c.setTextureRef(this._nativeMaterial.map);return c;}};
d.prototype.setTextureDiffuse=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.map=v.getTextureRef();}return this;};
d.prototype.getTextureBump=function(){if(this._nativeMaterial.bumpMap){var c=new T();c.setTextureRef(this._nativeMaterial.bumpMap);return c;}};
d.prototype.setTextureBump=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.bumpMap=v.getTextureRef();}return this;};
d.prototype.getTextureOpacity=function(){if(this._nativeMaterial.alphaMap){var c=new T();c.setTextureRef(this._nativeMaterial.alphaMap);return c;}};
d.prototype.setTextureOpacity=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.alphaMap=v.getTextureRef();}return this;};
d.prototype.getTextureReflection=function(){if(this._nativeMaterial.envMap){var c=new T();c.setTextureRef(this._nativeMaterial.envMap);return c;}};
d.prototype.setTextureReflection=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.envMap=v.getTextureRef();if(this._nativeMaterial.envMap){this._nativeMaterial.envMap.mapping=THREE.SphericalReflectionMapping;this._nativeMaterial.combine=THREE.AddOperation;}}return this;};
d.prototype.getTextureEmissive=function(){if(this._nativeMaterial.emissiveMap){var c=new T();c.setTextureRef(this._nativeMaterial.emissiveMap);return c;}};
d.prototype.setTextureEmissive=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.emissiveMap=v.getTextureRef();}return this;};
d.prototype.getTextureAmbientOcclusion=function(){if(this._nativeMaterial.aoMap){var c=new T();c.setTextureRef(this._nativeMaterial.aoMap);return c;}};
d.prototype.setTextureAmbientOcclusion=function(v){if(this._nativeMaterial.isMeshPhongMaterial&&v){this._nativeMaterial.aoMap=v.getTextureRef();}return this;};
return d;});
sap.ui.predefine('sap/ui/vk/threejs/NodeHierarchy',["jquery.sap.global","../NodeHierarchy","sap/ui/base/ObjectPool","./BaseNodeProxy","./NodeProxy","../Messages","../getResourceBundle"],function(q,N,O,B,a,M,g){"use strict";var s={equals:function(c,d){return c===d;},contains:function(c,d){return c.indexOf(d)!==-1;},startsWith:function(c,d){return c.indexOf(d)===0;}};
var b=N.extend("sap.ui.vk.threejs.NodeHierarchy",{
metadata:{},
_baseNodeProxyPool:new O(B),
constructor:function(c){N.call(this);this._scene=c;this._nodeProxies=[];}
});
b.prototype.destroy=function(){this._nodeProxies.slice().forEach(this.destroyNodeProxy,this);this._scene=null;N.prototype.destroy.call(this);};
b.prototype.getScene=function(){return this._scene;};
b.prototype.getSceneRef=function(){return this._scene.getSceneRef();};
b.prototype.enumerateChildren=function(n,c,d,p){if(typeof n==="function"){p=d;d=c;c=n;n=undefined;}var e=this.getChildren(n,d);if(p){e.forEach(c);}else{var f=this._baseNodeProxyPool.borrowObject();try{e.forEach(function(n){f.init(this,n);c(f);f.reset();}.bind(this));}finally{this._baseNodeProxyPool.returnObject(f);}}return this;};
b.prototype.enumerateAncestors=function(n,c,p){var d=this.getAncestors(n);if(p){d.forEach(c);}else{var e=this._baseNodeProxyPool.borrowObject();try{d.forEach(function(n){e.init(this,n);c(e);e.reset();}.bind(this));}finally{this._baseNodeProxyPool.returnObject(e);}}return this;};
b.prototype.createNodeProxy=function(n){var c=new a(this,n);this._nodeProxies.push(c);return c;};
b.prototype.destroyNodeProxy=function(n){var i=this._nodeProxies.indexOf(n);if(i>=0){this._nodeProxies.splice(i,1)[0].destroy();}return this;};
b.prototype.getChildren=function(n,c){if(typeof n==="boolean"){c=n;n=undefined;}if(!n){n=this._scene.getSceneRef();}var d=[];if(c||!n.userData.closed){n.children.forEach(function(e){if(!e.private&&(e.geometry===undefined||e.name||e.children.length>0)){d.push(e);}});}return d;};
b.prototype.getAncestors=function(n){var c=[];n.traverseAncestors(function(p){c.unshift(p);});if(c.length>0&&c[0]===this._scene.getSceneRef()){c.shift();}return c;};
b.prototype.findNodesByName=function(c){var r=[];if(c===undefined||c===null||c===""||q.isEmptyObject(c)){this._scene.getSceneRef().children.forEach(function(f){f.traverse(function(o){if(!o.private&&(o.geometry===undefined||o.name||o.children.length>0)){r.push(o);}});});}else{var d=s[c.predicate||"equals"];if(d===undefined){q.sap.log.error(g().getText(M.VIT8.summary),M.VIT8.code,"sap.ui.vk.threejs.NodeHierarchy");}else if(!Array.isArray(c.value)&&typeof c.value!=="string"){q.sap.log.error(g().getText(M.VIT6.summary),M.VIT6.code,"sap.ui.vk.threejs.NodeHierarchy");}else{var e=Array.isArray(c.value)?c.value:[c.value];if(!c.caseSensitive){for(var i in e){e[i]=e[i].toLowerCase();}}this._scene.getSceneRef().children.forEach(function(f){f.traverse(function(o){if(!o.private&&(o.geometry===undefined||o.name||o.children.length>0)){var n=o.name||"";if(!c.caseSensitive){n=n.toLowerCase();}for(var i in e){if(d(n,e[i])){r.push(o);break;}}}});});}}return r;};
b.prototype.createLayerProxy=function(l){return null;};
b.prototype.destroyLayerProxy=function(l){return this;};
b.prototype.getLayers=function(){return[];};
b.prototype.getHotspotNodeIds=function(){return null;};
b.prototype.attachChanged=function(d,f,l){return this.attachEvent("changed",d,f,l);};
b.prototype.detachChanged=function(d,f,l){return this.detachEvent("changed",d,f,l);};
b.prototype.fireChanged=function(p,c,e){return this.fireEvent("changed",p,c,e);};
b.prototype.attachNodeCreated=function(d,f,l){return this.attachEvent("nodeCreated",d,f,l);};
b.prototype.detachNodeCreated=function(d,f,l){return this.detachEvent("nodeCreated",d,f,l);};
b.prototype.fireNodeCreated=function(p,c,e){return this.fireEvent("nodeCreated",p,c,e);};
b.prototype.attachNodeRemoving=function(d,f,l){return this.attachEvent("nodeRemoving",d,f,l);};
b.prototype.detachNodeRemoving=function(d,f,l){return this.detachEvent("nodeRemoving",d,f,l);};
b.prototype.fireNodeRemoving=function(p,c,e){return this.fireEvent("nodeRemoving",p,c,e);};
b.prototype.attachNodeReplaced=function(d,f,l){return this.attachEvent("nodeReplaced",d,f,l);};
b.prototype.detachNodeReplaced=function(d,f,l){return this.detachEvent("nodeReplaced",d,f,l);};
b.prototype.fireNodeReplaced=function(p,c,e){return this.fireEvent("nodeReplaced",p,c,e);};
b.prototype.attachNodeUpdated=function(d,f,l){return this.attachEvent("nodeUpdated",d,f,l);};
b.prototype.detachNodeUpdated=function(d,f,l){return this.detachEvent("nodeUpdated",d,f,l);};
b.prototype.fireNodeUpdated=function(p,c,e){return this.fireEvent("nodeUpdated",p,c,e);};
b.prototype.createNode=function(p,n,i){if(!p){p=this._scene.getSceneRef();}var c=p.children.indexOf(i);var o=new THREE.Group();o.name=n;p.add(o);if(c>=0){p.children.splice(c,0,p.children.pop());}this.fireNodeCreated({nodeRef:o,nodeId:o});this.fireChanged();return o;};
b.prototype.createNodeCopy=function(n,p,c,i){if(!p){p=this._scene.getSceneRef();}var d=p.children.indexOf(i);var e=n.clone(true);e.name=c;p.add(e);if(d>=0){p.children.splice(d,0,p.children.pop());}this.fireNodeCreated({nodeRef:e,nodeId:e});this.fireChanged();return e;};
b.prototype.removeNode=function(n){var c=[].concat(n);c.forEach(function(n){if(n&&n.parent){this.fireNodeRemoving({nodeRef:n,nodeId:n});n.parent.remove(n);}}.bind(this));this.fireChanged();return this;};
return b;});
sap.ui.predefine('sap/ui/vk/threejs/NodeProxy',["../NodeProxy","./Material","../cssColorToColor","../colorToCSSColor","../abgrToColor","../colorToABGR","../TransformationMatrix","./ThreeExtensions","../ObjectType"],function(N,M,a,b,d,e,T,f,O){"use strict";
var g=N.extend("sap.ui.vk.threejs.NodeProxy",{
metadata:{},
constructor:function(n,o){N.call(this);this._object3D=o;this._nodeHierarchy=n;}
});
g.prototype.destroy=function(){this._object3D=null;N.prototype.destroy.call(this);};
g.prototype.getNodeHierarchy=function(){return this._nodeHierarchy;};
g.prototype.getNodeRef=function(){return this._object3D;};
g.prototype.getNodeId=function(){return this._object3D;};
g.prototype.getVeId=function(){if(this._object3D.userData.treeNode){return this._object3D.userData.treeNode.sid;}else{return null;}};
g.prototype.getMaterialId=function(){var r=this._object3D;if(this._object3D&&!this._object3D.geometry){if(this._object3D.children.length===1&&this._object3D.children[0].geometry&&(this._object3D.children[0].name===""||this._object3D.children[0].name===undefined)){r=this._object3D.children[0];}}if(r.material!==undefined&&r.material.userData!==undefined&&r.material.userData.materialId!==undefined){return r.material.userData.materialId;}else if(r.userData.originalMaterial!==undefined&&r.userData.originalMaterial.userData!==undefined&&r.userData.originalMaterial.userData.materialId!==undefined){return r.userData.originalMaterial.userData.materialId;}return undefined;};
g.prototype.getName=function(){return this._object3D.name||("<"+this._object3D.type+">");};
g.prototype._updateAncestorsBoundingBox=function(){var p=this._object3D.parent;while(p){if(p.userData.boundingBox!==undefined){p._vkCalculateObjectOrientedBoundingBox();}p=p.parent;}};
g.prototype.getLocalMatrix=function(){return T.convertTo4x3(this._object3D.matrix.elements);};
g.prototype.setLocalMatrix=function(v){if(v){var o=this._object3D;o.matrix.fromArray(T.convertTo4x4(v));o.matrix.decompose(o.position,o.quaternion,o.scale);o.updateMatrixWorld(true);this._updateAncestorsBoundingBox();}this.setProperty("localMatrix",v,true);return this;};
g.prototype.setLocalMatrixNotUpdatingBBox=function(v){if(v){var o=this._object3D;o.matrix.fromArray(T.convertTo4x4(v));o.matrix.decompose(o.position,o.quaternion,o.scale);o.updateMatrixWorld(true);}this.setProperty("localMatrix",v,true);return this;};
g.prototype.getWorldMatrix=function(){return T.convertTo4x3(this._object3D.matrixWorld.elements);};
g.prototype.setWorldMatrix=function(v){if(v){var o=this._object3D;o.matrixWorld.fromArray(T.convertTo4x4(v));if(o.parent){o.matrix.multiplyMatrices(new THREE.Matrix4().getInverse(o.parent.matrixWorld),o.matrixWorld);}else{o.matrix.copy(o.matrixWorld);}o.matrix.decompose(o.position,o.quaternion,o.scale);o.updateMatrixWorld(true);this._updateAncestorsBoundingBox();}this.setProperty("worldMatrix",v,true);return this;};
g.prototype.getOpacity=function(){return this._object3D.userData.opacity;};
g.prototype.setOpacity=function(v){var c=this._nodeHierarchy.getScene().getViewStateManager();if(c){c.setOpacity(this._object3D,v);}else{this._object3D._vkSetOpacity(v);}this.setProperty("opacity",v,true);return this;};
g.prototype.getTintColorABGR=function(){return this._object3D.userData.tintColor;};
g.prototype.setTintColorABGR=function(v){var c=this._nodeHierarchy.getScene().getViewStateManager();if(c){c.setTintColor(this._object3D,v);}else{this._object3D._vkSetTintColor(v);}this.setProperty("tintColorABGR",v,true);this.setProperty("tintColor",b(d(v)),true);return this;};
g.prototype.getTintColor=function(){return b(d(this._object3D.userData.tintColor));};
g.prototype.setTintColor=function(v){var c=e(a(v));var h=this._nodeHierarchy.getScene().getViewStateManager();if(h){h.setTintColor(this._object3D,c);}else{this._object3D._vkSetTintColor(c);}this.setProperty("tintColorABGR",c,true);this.setProperty("tintColor",v,true);return this;};
g.prototype.getNodeMetadata=function(){return this._object3D.userData.metadata||{};};
g.prototype.getHasChildren=function(){return this._object3D.children.length>0;};
g.prototype.getClosed=function(){return!!this._object3D.userData.closed;};
g.prototype.assignMaterial=function(v){var s=function(m,n){var h;if(m.userData){h=m.userData.materialId;n.userData.materialId=h;}if(n.material!==undefined){if(n.userData.highlightColor!==undefined){if(n.userData.originalMaterial.side){m.side=n.userData.originalMaterial.side;}n.userData.originalMaterial=m;m.userData.materialUsed++;n.material=m.clone();var c=d(n.userData.highlightColor);n.material.color.lerp(new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0),c.alpha);if(m.userData.defaultHighlightingEmissive){n.material.emissive.copy(m.userData.defaultHighlightingEmissive);}if(m.userData.defaultHighlightingSpecular){n.material.specular.copy(m.userData.defaultHighlightingSpecular);}}else{if(n.material.side){m.side=n.material.side;}n.material=m;m.userData.materialUsed++;delete n.userData.originalMaterial;}if(n.userData.opacity){if(!n.userData.originalMaterial){n.userData.originalMaterial=m;n.material=m.clone();}n.material.opacity*=n.userData.opacity;n.material.transparent=n.material.opacity<0.99;}}};s(v.getMaterialRef(),this._object3D);if(!this._object3D.children){return this;}this._object3D.children.forEach(function(c){if(!c||c.userData.objectType===O.PMI||c.userData.objectType===O.Hotspot){return;}s(v.getMaterialRef(),c);});return this;};
g.prototype.enumerateMaterials=function(r){var c=function(n,l,r){if(n){if(n.userData.originalMaterial){l.add(n.userData.originalMaterial);}else if(n.material){l.add(n.material);}if(n.children){n.children.forEach(function(o){if(o){if(r){c(o,l,r);}else if(o.userData.originalMaterial){l.add(o.userData.originalMaterial);}else if(o.material){l.add(o.material);}}});}}};var m=new Set();c(this._object3D,m,r);var h=[];m.forEach(function(v){h.push(v);});var j=[];for(var i=0;i<h.length;i++){var k=new M();k.setMaterialRef(h[i]);j.push(k);}return j;};
g.prototype.replaceMaterial=function(m,c){var h=m.getMaterialRef();var i=c.getMaterialRef();if(this._object3D.userData.originalMaterial&&this._object3D.userData.originalMaterial===h){this._object3D.userData.originalMaterial=i;}else if(this._object3D.material&&this._object3D.material===h){this._object3D.material=i;}if(!this._object3D.children){return this;}this._object3D.children.forEach(function(j){if(j&&j.userData.originalMaterial&&j.userData.originalMaterial===h){j.userData.originalMaterial=i;}else if(j&&j.material&&j.material===h){j.material=i;}});return this;};
g.prototype.getLocalTranslate=function(){var o=this._object3D;return[o.position.x,o.position.y,o.position.z];};
g.prototype.getLocalScale=function(){var o=this._object3D;return[o.scale.x,o.scale.y,o.scale.z];};
g.prototype.getLocalRotationInQuaternion=function(){var o=this._object3D;return[o.quaternion.x,o.quaternion.y,o.quaternion.z,o.quaternion.w];};
g.prototype.getLocalRotationInAngleAxis=function(){var o=this._object3D;var q=o.quaternion;if(q.w>1){q.normalise();}var c=2*Math.acos(q.w);var s=Math.sqrt(1-q.w*q.w);var x,y,z;if(s<0.001){x=q.x;y=q.y;z=q.z;}else{x=q.x/s;y=q.y/s;z=q.z/s;}return[x,y,z,c];};
g.prototype.getLocalRotationInEuler=function(){var o=this._object3D;var q=o.quaternion;if(q.w>1){q.normalise();}var c=26;var t=q.x*q.y+q.z*q.w;var h,i,j;if(t>0.499){h=2*Math.atan2(q.x,q.w);i=Math.PI/2;j=0;}if(t<-0.499){h=-2*Math.atan2(q.x,q.w);i=-Math.PI/2;j=0;}else{var s=q.x*q.x;var k=q.y*q.y;var l=q.z*q.z;h=Math.atan2(2*q.y*q.w-2*q.x*q.z,1-2*k-2*l);i=Math.asin(2*t);j=Math.atan2(2*q.x*q.w-2*q.y*q.z,1-2*s-2*l);}return[h,i,j,c];};
return g;});
sap.ui.predefine('sap/ui/vk/threejs/NodesTransitionHelper',["sap/ui/core/Element","../TransformationMatrix"],function(E,T){"use strict";
var N=E.extend("sap.ui.vk.threejs.NodesTransitionHelper",{metadata:{properties:{},publicMethods:["setViewport","setNodeForDisplay","setDisappearingNode","setAppearingNode","clear","startDisplay","displayNodesMoving"],events:{displaying:{},displayed:{}}}});
N.prototype.init=function(){this._viewport=null;this._nodeLocalmMatrixMap=new Map();this._nodeLocalMatrixMapForVisibility=new Map();this._timeIntervalForDisplay=500;this._startTimeForDisplay=0;};
N.prototype.destroy=function(){this._viewport=null;this._nodeLocalmMatrixMap=null;this._nodeLocalMatrixMapForVisibility=new Map();};
N.prototype.setViewport=function(v){this._viewport=v;};
N.prototype.setNodeForDisplay=function(n){this._nodeLocalmMatrixMap.set(n,{oldMatrix:n.getLocalMatrix(),newMatrix:null});};
N.prototype.setDisappearingNode=function(n){var o=n.getLocalMatrix();var a=[o[0]*0.0001,o[1],o[2],o[3],o[4]*0.0001,o[5],o[6],o[7],o[8]*0.0001,o[9],o[10],o[11]];this._nodeLocalMatrixMapForVisibility.set(n,{oldMatrix:o,newMatrix:a,visible:false});var b=n.getNodeRef();b.visible=true;};
N.prototype.setAppearingNode=function(n){var o=n.getLocalMatrix();var a=[o[0]*0.0001,o[1],o[2],o[3],o[4]*0.0001,o[5],o[6],o[7],o[8]*0.0001,o[9],o[10],o[11]];this._nodeLocalMatrixMapForVisibility.set(n,{oldMatrix:a,newMatrix:o,visible:true});};
N.prototype._interpolateNodePositionForVisibility=function(n,d,i){this._interpolateNodePosition(n,d.oldMatrix,d.newMatrix,i);if(i>=1){var a=n.getNodeRef();a.visible=d.visible;if(!a.visible){n.setLocalMatrixNotUpdatingBBox(d.oldMatrix);}}};
N.prototype._interpolateNodePosition=function(n,o,a,i){var b=new THREE.Matrix4().fromArray(T.convertTo4x4(o));var c=new THREE.Vector3();var d=new THREE.Quaternion();var e=new THREE.Vector3();b.decompose(c,d,e);var f=new THREE.Matrix4().fromArray(T.convertTo4x4(a));var g=new THREE.Vector3();var h=new THREE.Quaternion();var j=new THREE.Vector3();f.decompose(g,h,j);var p=new THREE.Vector3().lerpVectors(c,g,i);var q=new THREE.Quaternion().copy(d).slerp(h,i);var s=new THREE.Vector3().lerpVectors(e,j,i);var t=new THREE.Matrix4().compose(p,q,s);n.setLocalMatrixNotUpdatingBBox(T.convertTo4x3(t.elements));};
N.prototype.startDisplay=function(t){if(this._nodeLocalmMatrixMap.size===0){return;}this._timeIntervalForDisplay=t!==undefined?t:500;this._startTimeForDisplay=Date.now();this._nodeLocalmMatrixMap.forEach(function(m,n){m.newMatrix=n.getLocalMatrix();});this.fireDisplaying();};
N.prototype.displayNodesMoving=function(){if(this._startTimeForDisplay===0||this._nodeLocalmMatrixMap===null||this._nodeLocalmMatrixMap.size===0){return;}var i=Math.min((Date.now()-this._startTimeForDisplay)/this._timeIntervalForDisplay,1);i=1-Math.pow(1-i,3);this._nodeLocalmMatrixMap.forEach(function(m,n){if(n&&m.oldMatrix&&m.newMatrix){this._interpolateNodePosition(n,m.oldMatrix,m.newMatrix,i);}}.bind(this));this._nodeLocalMatrixMapForVisibility.forEach(function(d,n){if(n&&d){this._interpolateNodePositionForVisibility(n,d,i);}}.bind(this));if(i===1){this.clear();this.fireDisplayed();}this._viewport.setShouldRenderFrame();};
N.prototype.clear=function(){this._nodeLocalmMatrixMap.clear();this._nodeLocalMatrixMapForVisibility.clear();this._startTimeForDisplay=0;};
return N;});
sap.ui.predefine('sap/ui/vk/threejs/OrthographicCamera',["../OrthographicCamera","./thirdparty/three"],function(O,t){"use strict";
var T=O.extend("sap.ui.vk.threejs.OrthographicCamera",{metadata:{}});
var b=O.getMetadata().getParent().getClass().prototype;
T.prototype.init=function(){if(b.init){b.init.call(this);}var n=1;var f=200000;this._nativeCamera=new THREE.OrthographicCamera(-1,1,1,-1,n,f);this._nativeCamera.position.set(0,0,10000);this._nativeCamera.zoom=-1;this.setUsingDefaultClipPlanes(true);};
T.prototype.update=function(w,h){var f=1/Math.min(w,h);this.setLeft(w*-f);this.setRight(w*f);this.setTop(h*f);this.setBottom(h*-f);this._nativeCamera.updateProjectionMatrix();};
T.prototype.exit=function(){if(b.exit){b.exit.call(this);}this._nativeCamera=null;};
T.prototype.getLeft=function(){return this._nativeCamera.left;};
T.prototype.setLeft=function(v){this._nativeCamera.left=v;return this;};
T.prototype.getRight=function(){return this._nativeCamera.right;};
T.prototype.setRight=function(v){this._nativeCamera.right=v;return this;};
T.prototype.getTop=function(){return this._nativeCamera.top;};
T.prototype.setTop=function(v){this._nativeCamera.top=v;return this;};
T.prototype.getBottom=function(){return this._nativeCamera.bottom;};
T.prototype.setBottom=function(v){this._nativeCamera.bottom=v;return this;};
T.prototype.getZoomFactor=function(){return this._nativeCamera.zoom;};
T.prototype.setZoomFactor=function(v){this._nativeCamera.zoom=v;return this;};
T.prototype.getCameraRef=function(){return this._nativeCamera;};
T.prototype.setCameraRef=function(c){this._nativeCamera=c;return this;};
T.prototype.getNearClipPlane=function(){return this._nativeCamera.near;};
T.prototype.setNearClipPlane=function(v){this._nativeCamera.near=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};
T.prototype.getFarClipPlane=function(){return this._nativeCamera.far;};
T.prototype.setFarClipPlane=function(v){this._nativeCamera.far=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};
T.prototype.getPosition=function(){return this._nativeCamera.position.toArray();};
T.prototype.setPosition=function(v){this._nativeCamera.position.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};
T.prototype.getUpDirection=function(){return this._nativeCamera.up.toArray();};
T.prototype.setUpDirection=function(v){this._nativeCamera.up.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};
T.prototype.getTargetDirection=function(){return this._nativeCamera.getWorldDirection().toArray();};
T.prototype.setTargetDirection=function(v){var a=new THREE.Vector3().fromArray(v);a.add(this._nativeCamera.position);this._nativeCamera.lookAt(a);return this;};
T.prototype.setUsingDefaultClipPlanes=function(v){this._nativeCamera.userData.usingDefaultClipPlanes=v;return this;};
T.prototype.getUsingDefaultClipPlanes=function(){return this._nativeCamera.userData.usingDefaultClipPlanes;};
T.prototype.adjustClipPlanes=function(a){var c=this._nativeCamera;c.updateMatrixWorld();a=a.clone().applyMatrix4(c.matrixWorldInverse);c.near=-a.max.z;c.far=-a.min.z;var e=Math.max((c.far-c.near)*0.0025,0.001);c.near-=e;c.far+=e;var p=1.0/(c.far-c.near);var z=(c.far+c.near)*p;c.projectionMatrix.elements[10]=-2*p;c.projectionMatrix.elements[14]=-z;return this;};
T.prototype.adjustZoom=function(a){var c=this._nativeCamera;c.updateMatrixWorld();a=a.clone().applyMatrix4(c.matrixWorldInverse);c.zoom=1/Math.max(a.min.x/c.left,a.max.y/c.top,a.max.x/c.right,a.min.y/c.bottom);c.updateProjectionMatrix();return this;};
return T;});
sap.ui.predefine('sap/ui/vk/threejs/PerspectiveCamera',["../PerspectiveCamera","./thirdparty/three"],function(P,t){"use strict";
var T=P.extend("sap.ui.vk.threejs.PerspectiveCamera",{metadata:{}});
var b=P.getMetadata().getParent().getClass().prototype;
T.prototype.init=function(){if(b.init){b.init.call(this);}var n=1;var f=10000;this._nativeCamera=new THREE.PerspectiveCamera(30,1,n,f);this._nativeCamera.position.set(0,0,100);this.setUsingDefaultClipPlanes(true);};
T.prototype.update=function(w,h){var o=this._nativeCamera.aspect;var a=this._nativeCamera.zoom;this._nativeCamera.aspect=w/h;this._nativeCamera.zoom=Math.min(this._nativeCamera.aspect,1);var v=this._nativeCamera.view;if(v&&v.enabled){var s=w/v.fullWidth;var c=h/v.fullHeight;var d=this._nativeCamera.zoom/a;var e=d*o/this._nativeCamera.aspect;v.offsetX=(v.offsetX*e+(v.fullWidth-v.width)*(1-e)*0.5)*s;v.offsetY=(v.offsetY*d+(v.fullHeight-v.height)*(1-d)*0.5)*c;v.width*=s;v.height*=c;v.fullWidth=w;v.fullHeight=h;}this._nativeCamera.updateProjectionMatrix();};
T.prototype.exit=function(){if(b.exit){b.exit.call(this);}this._nativeCamera=null;};
T.prototype.getFov=function(){return this._nativeCamera.fov;};
T.prototype.setFov=function(v){this._nativeCamera.fov=v;this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};
T.prototype.getCameraRef=function(){return this._nativeCamera;};
T.prototype.setCameraRef=function(c){this._nativeCamera=c;return this;};
T.prototype.getNearClipPlane=function(){return this._nativeCamera.near;};
T.prototype.setNearClipPlane=function(v){this._nativeCamera.near=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};
T.prototype.getFarClipPlane=function(){return this._nativeCamera.far;};
T.prototype.setFarClipPlane=function(v){this._nativeCamera.far=v;this.setUsingDefaultClipPlanes(false);this._nativeCamera.updateProjectionMatrix();this.setIsModified(true);return this;};
T.prototype.getPosition=function(){return this._nativeCamera.position.toArray();};
T.prototype.setPosition=function(v){this._nativeCamera.position.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};
T.prototype.getUpDirection=function(){return this._nativeCamera.up.toArray();};
T.prototype.setUpDirection=function(v){this._nativeCamera.up.fromArray(v);this._nativeCamera.updateMatrixWorld();return this;};
T.prototype.getTargetDirection=function(){return this._nativeCamera.getWorldDirection().toArray();};
T.prototype.setTargetDirection=function(v){var a=new THREE.Vector3().fromArray(v);a.add(this._nativeCamera.position);this._nativeCamera.lookAt(a);return this;};
T.prototype.setUsingDefaultClipPlanes=function(v){this._nativeCamera.userData.usingDefaultClipPlanes=v;return this;};
T.prototype.getUsingDefaultClipPlanes=function(){return this._nativeCamera.userData.usingDefaultClipPlanes;};
T.prototype.adjustClipPlanes=function(a){var e=this._nativeCamera;e.updateMatrixWorld();a=a.clone().applyMatrix4(e.matrixWorldInverse);e.near=-a.max.z;e.far=-a.min.z;var f=Math.max((e.far-e.near)*0.0025,0.001);e.far=Math.max(e.far,0.1);f=Math.max(f,e.far*0.0025);e.near-=f;e.far+=f;e.near=Math.max(e.near,e.far*0.0025);var c=-(e.far+e.near)/(e.far-e.near);var d=-2*e.far*e.near/(e.far-e.near);e.projectionMatrix.elements[10]=c;e.projectionMatrix.elements[14]=d;return this;};
return T;});
sap.ui.predefine('sap/ui/vk/threejs/PolylineGeometry',["./thirdparty/three"],function(t){"use strict";
function P(){THREE.InstancedBufferGeometry.call(this);this.type="PolylineGeometry";var p=[-1,2,0,1,2,0,-1,1,0,1,1,0,-1,0,0,1,0,0,-1,-1,0,1,-1,0];var u=[2,-1,2,1,1,-1,1,1,-1,-1,-1,1,-2,-1,-2,1];var i=[0,2,1,2,3,1,2,4,3,4,5,3,4,6,5,6,7,5];this.setIndex(i);this.addAttribute("position",new THREE.Float32BufferAttribute(p,3));this.addAttribute("uv",new THREE.Float32BufferAttribute(u,2));}
P.prototype=Object.assign(Object.create(THREE.InstancedBufferGeometry.prototype),{constructor:P,isPolylineGeometry:true,setVertices:function(v){this.vertices=v;var l=v.length-1;var d=new Float32Array(6*l);for(var i=0,c=0;i<l;i++){var a=v[i],b=v[i+1];d[c++]=a.x;d[c++]=a.y;d[c++]=a.z;d[c++]=b.x;d[c++]=b.y;d[c++]=b.z;}var e=new THREE.InstancedInterleavedBuffer(d,6,1);this.addAttribute("instanceStart",new THREE.InterleavedBufferAttribute(e,3,0));this.addAttribute("instanceEnd",new THREE.InterleavedBufferAttribute(e,3,3));var f=new THREE.InstancedInterleavedBuffer(new Float32Array(2*l),2,1);this.addAttribute("instanceDistance",new THREE.InterleavedBufferAttribute(f,2,0));this.computeBoundingBox();this.computeBoundingSphere();return this;},computeBoundingBox:function(){if(this.boundingBox===null){this.boundingBox=new THREE.Box3();}this.boundingBox.setFromPoints(this.vertices);},computeBoundingSphere:function(){if(this.boundingSphere===null){this.boundingSphere=new THREE.Sphere();}this.boundingSphere.setFromPoints(this.vertices);},_updateVertices:function(a){var b=this.vertices;var d=this.attributes.instanceStart.data;var c=d.array;a.forEach(function(e){var v=b[e];var i=e*6-3;if(i>=0){c[i+0]=v.x;c[i+1]=v.y;c[i+2]=v.z;}if(i+5<c.length){c[i+3]=v.x;c[i+4]=v.y;c[i+5]=v.z;}});d.needsUpdate=true;this.computeBoundingBox();this.computeBoundingSphere();}});return P;});
sap.ui.predefine('sap/ui/vk/threejs/PolylineMaterial',["./thirdparty/three"],function(t){"use strict";var p={lineColor:{value:new THREE.Color(1,1,1)},linewidth:{value:1},resolution:{value:new THREE.Vector2(1,1)},dashScale:{value:1},dashPeriod:{value:new THREE.Vector3(1,1,1)},dashAtlas:{value:null},lineLength:{value:1e5}};var u=THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,p]);var v=["#include <common>","#include <color_pars_vertex>","#include <fog_pars_vertex>","#include <logdepthbuf_pars_vertex>","#include <clipping_planes_pars_vertex>","","uniform float linewidth;","uniform vec2 resolution;","","attribute vec3 instanceStart;","attribute vec3 instanceEnd;","","varying vec2 vTC;","","#if defined(USE_DASH) || TRIM_STYLE","attribute vec2 instanceDistance;","varying float vLineDistance;","#endif","","void trimSegment(const in vec4 start, inout vec4 end) {","	// trim end segment so it terminates between the camera plane and the near plane","","	// conservative estimate of the near plane","	float a = projectionMatrix[ 2 ][ 2 ]; // 3nd entry in 3th column","	float b = projectionMatrix[ 3 ][ 2 ]; // 3nd entry in 4th column","	float nearEstimate = -0.5 * b / a;","","	float t = (nearEstimate - start.z) / (end.z - start.z);","","	end.xyz = mix(start.xyz, end.xyz, t);","}","","void main() {","	vTC = uv * linewidth;","","	// camera space","	vec4 start = modelViewMatrix * vec4(instanceStart, 1.0);","	vec4 end = modelViewMatrix * vec4(instanceEnd, 1.0);","","	// special case for perspective projection, and segments that terminate either in, or behind, the camera plane","	// clearly the gpu firmware has a way of addressing this issue when projecting into ndc space","	// but we need to perform ndc-space calculations in the shader, so we must address this issue directly","	// perhaps there is a more elegant solution -- WestLangley","","	bool perspective = (projectionMatrix[ 2 ][ 3 ] == -1.0); // 4th entry in the 3rd column","	if (perspective) {","		if (start.z < 0.0 && end.z >= 0.0) {","			trimSegment(start, end);","		} else if (end.z < 0.0 && start.z >= 0.0) {","			trimSegment(end, start);","		}","	}","","	// clip space","	vec4 clipStart = projectionMatrix * start;","	vec4 clipEnd = projectionMatrix * end;","","	// ndc space","	vec2 ndcStart = clipStart.xy / clipStart.w;","	vec2 ndcEnd = clipEnd.xy / clipEnd.w;","","	// direction","	vec2 dir = (ndcEnd - ndcStart) * resolution;","	float l = length(dir);","	dir = normalize(dir);","","	// perpendicular to dir","	vec2 offset = vec2(dir.y, -dir.x) * position.x;","","#if defined(USE_DASH) || TRIM_STYLE","	vLineDistance = mix(instanceDistance.x, instanceDistance.y, position.y);","#endif","","	// endcaps","	if ( position.y < 0.0 ) {","		offset -= dir;","#if defined(USE_DASH)","		vLineDistance = mix(instanceDistance.x, instanceDistance.y, position.y * linewidth / l);","#endif","	} else if ( position.y > 1.0 ) {","		offset += dir;","#if defined(USE_DASH)","		vLineDistance = mix(instanceDistance.x, instanceDistance.y, 1.0 + (position.y - 1.0) * linewidth / l);","#endif","	}","","	// select end","	vec4 clip = (position.y < 0.5) ? clipStart : clipEnd;","	clip /= clip.w; // remove perspective correction","","	clip.xy += offset * (linewidth / resolution);","","	gl_Position = clip;","","	vec4 mvPosition = (position.y < 0.5) ? start : end; // this is an approximation","","#include <logdepthbuf_vertex>","#include <clipping_planes_vertex>","#include <fog_vertex>","}"].join("\n");var f=["uniform vec3 diffuse;","uniform vec3 lineColor;","uniform float opacity;","uniform float linewidth;","","#ifdef USE_DASH","uniform float dashScale;","uniform vec3 dashPeriod;","uniform sampler2D dashAtlas;","#endif","","#if (TRIM_STYLE & 2)","uniform float lineLength;","#endif","","varying float vLineDistance;","","#include <common>","#include <color_pars_fragment>","#include <fog_pars_fragment>","#include <logdepthbuf_pars_fragment>","#include <clipping_planes_pars_fragment>","","varying vec2 vTC;","","void main() {","","#include <clipping_planes_fragment>","","	vec4 diffuseColor = vec4(diffuse * lineColor, opacity);","","	vec2 uv = abs(vTC);","	diffuseColor.a *= clamp(linewidth + 0.5 - uv.y, 0.0, 1.0); // line antialiasing","","#if (TRIM_STYLE & 1)","	if (vLineDistance < 0.0)","		discard;","#endif","","#if (TRIM_STYLE & 2)","	if (vLineDistance > lineLength)","		discard;","#endif","","	if (uv.x > linewidth) { // apply segment cap","#if (SEGMENT_CAP_STYLE == 1) // round cap","		vec2 delta = vec2(uv.y, uv.x - linewidth);","		diffuseColor.a *= clamp(linewidth - length(delta), 0.0, 1.0);","#else","		diffuseColor.a *= clamp(linewidth + 1.0 - uv.x, 0.0, 1.0);","#endif","	}","","#include <logdepthbuf_fragment>","#include <color_fragment>","","#ifdef USE_DASH","	float x = fract(vLineDistance * dashPeriod.y / dashScale);","	vec4 dash = texture2D(dashAtlas, vec2(x * dashPeriod.z, 0.5));","	dash.zw *= 255.0;","	x *= dashPeriod.x;","	dash.zw = vec2(dash.z - x, x - dash.w);","	x = min(dash.z, dash.w) * dashScale;","#if (DASH_CAP_STYLE == 1) // round cap","	vec2 delta = vec2(x * 2.0, uv.y);","	diffuseColor.a *= max(step(x / linewidth, 0.0), clamp(linewidth + 0.5 - length(delta), 0.0, 1.0));","#else // no cap","	diffuseColor.a *= clamp(0.5 - x, 0.0, 1.0);","#endif","#endif","","	gl_FragColor = diffuseColor;","","#include <premultiplied_alpha_fragment>","#include <tonemapping_fragment>","#include <encodings_fragment>","#include <fog_fragment>","}"].join("\n");
function P(a){THREE.ShaderMaterial.call(this,{type:"PolylineMaterial",uniforms:THREE.UniformsUtils.clone(u),vertexShader:v,fragmentShader:f});this.defines.DASH_CAP_STYLE=0;this.defines.SEGMENT_CAP_STYLE=0;this.defines.TRIM_STYLE=0;this._dashPattern=[];Object.defineProperties(this,{color:{enumerable:true,get:function(){return this.uniforms.diffuse.value;},set:function(b){this.uniforms.diffuse.value=b;}},lineColor:{enumerable:true,get:function(){return this.uniforms.lineColor.value;},set:function(b){this.uniforms.lineColor.value=b;}},linewidth:{enumerable:true,get:function(){return this.uniforms.linewidth.value;},set:function(b){this.uniforms.linewidth.value=b;}},dashCapStyle:{enumerable:true,get:function(){return this.defines.DASH_CAP_STYLE;},set:function(b){this.defines.DASH_CAP_STYLE=b;}},segmentCapStyle:{enumerable:true,get:function(){return this.defines.SEGMENT_CAP_STYLE;},set:function(b){this.defines.SEGMENT_CAP_STYLE=b;}},trimStyle:{enumerable:true,get:function(){return this.defines.TRIM_STYLE;},set:function(b){this.defines.TRIM_STYLE=b;}},dashScale:{enumerable:true,get:function(){return this.uniforms.dashScale.value;},set:function(b){this.uniforms.dashScale.value=b;}},dashPattern:{enumerable:true,get:function(){return this._dashPattern;},set:function(b){this._dashPattern=b;this._updateDashAtlas();}},resolution:{enumerable:true,get:function(){return this.uniforms.resolution.value;},set:function(b){this.uniforms.resolution.value.copy(b);}},lineLength:{enumerable:true,get:function(){return this.uniforms.lineLength.value;},set:function(b){this.uniforms.lineLength.value=b;}}});this.setValues(a);}
P.prototype=Object.create(THREE.ShaderMaterial.prototype);P.prototype.constructor=P;P.prototype.isLineMaterial=true;
P.prototype._updateDashAtlas=function(){if(!this._dashPattern.length){delete this.defines.USE_DASH;this.uniforms.dashAtlas.value=null;this.needsUpdate=true;return;}var d=Array.from(this._dashPattern);if(d.length&1){d=d.concat(d);}var a=d.reduce(function(l,n){return l+Math.ceil(n);});var b=THREE.Math.ceilPowerOfTwo(a);this.uniforms.dashPeriod.value.set(a,1/a,a/b);var e=new Uint8Array(b*4);for(var i=0,x=0,c=0;i<d.length;i++){var w=d[i];var g=(i&1)?x+w:x;var h=(i&1)?x:x+w;var j=(i&1)?0:255;while(w-->0){e[c++]=j;e[c++]=0;e[c++]=g;e[c++]=h;x++;}}var k=new THREE.DataTexture(e,b,1,THREE.RGBAFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.NearestFilter,THREE.NearestFilter);k.needsUpdate=true;this.defines.USE_DASH="";this.uniforms.dashAtlas.value=k;this.needsUpdate=true;};
P.prototype.copy=function(s){THREE.ShaderMaterial.prototype.copy.call(this,s);this.color.copy(s.color);this.lineColor.copy(s.lineColor);this.linewidth=s.linewidth;this.dashCapStyle=s.dashCapStyle;this.segmentCapStyle=s.segmentCapStyle;this.trimStyle=s.trimStyle;this.dashPattern=s.dashPattern;this.resolution=s.resolution;this.lineLength=s.lineLength;return this;};
return P;});
sap.ui.predefine('sap/ui/vk/threejs/PolylineMesh',["./thirdparty/three","./PolylineGeometry","./PolylineMaterial"],function(c,P,d){"use strict";
function e(g,m){THREE.Mesh.call(this);this.type="PolylineMesh";this.geometry=g!==undefined?g:new P();this.material=m!==undefined?m:new d();}
e.prototype=Object.assign(Object.create(THREE.Mesh.prototype),{constructor:e,isPolylineMesh:true,computeLineDistances:(function(){var a=new THREE.Vector4();var b=new THREE.Vector4();var f=new THREE.Vector2();var g=new THREE.Vector2();return function(m,v,n){var h=this.geometry;var k=h.attributes.instanceDistance.data;var o=k.array;var p=h.vertices;var q=0,t;a.copy(p[0]).applyMatrix4(m);for(var i=0,j=0,l=k.count;i<l;i++,j+=2){b.copy(p[i+1]).applyMatrix4(m);if(n!==undefined){if(a.w>=n){f.copy(a).multiplyScalar(1/a.w);if(b.w>=n){g.copy(b).multiplyScalar(1/b.w);}else{t=(a.w-n)/(a.w-b.w);g.copy(b).sub(a).multiplyScalar(t).add(a).multiplyScalar(1/n);}}else if(b.w>=n){g.copy(b).multiplyScalar(1/b.w);t=(b.w-n)/(b.w-a.w);f.copy(a).sub(b).multiplyScalar(t).add(b).multiplyScalar(1/n);}else{f.set(0,0,0);g.set(0,0,0);}}else{f.copy(a);g.copy(b);}o[j]=q;q+=g.sub(f).multiply(v).length()*0.5;o[j+1]=q;a.copy(b);}this.material.lineLength=q;k.needsUpdate=true;return this;};}())});return e;});
sap.ui.predefine('sap/ui/vk/threejs/Scene',["jquery.sap.global","../Scene","./NodeHierarchy","../RenderMode","./ThreeExtensions","./AnimationSequence"],function(q,S,N,R,T,A){"use strict";
var c=S.extend("sap.ui.vk.threejs.Scene",{
metadata:{},
constructor:function(a){S.call(this);this._id=q.sap.uid();this._scene=a;this._sceneBuilder=null;this._defaultNodeHierarchy=null;this._currentViewStateManager=null;this._animationSequenceMap=new Map();this._initialView=null;this._materialMap=new Map();}
});
c.prototype.init=function(){var a=["attribute vec3 normal1;","attribute vec3 normal2;","#include <clipping_planes_pars_vertex>","uniform vec4 color;","varying vec4 vColor;","void main() {","	#include <begin_vertex>","	#include <project_vertex>","	#include <clipping_planes_vertex>","	vec3 eyeDirection = mvPosition.xyz;","	vec3 n1 = normalMatrix * normal1;","	vec3 n2 = normalMatrix * normal2;","	vColor = color;","	vColor.a *= step(dot(eyeDirection, n1) * dot(eyeDirection, n2), 0.0);","}"].join("\n");var b=["#include <clipping_planes_pars_fragment>","varying vec4 vColor;","void main() {","	#include <clipping_planes_fragment>","	if (vColor.a < ALPHATEST) discard;","	gl_FragColor = vColor;","}"].join("\n");this._outlineColor=new THREE.Vector4(0,0,0,1);this._outlineMaterial=new THREE.ShaderMaterial({uniforms:{color:{value:this._outlineColor}},vertexShader:a,fragmentShader:b,depthWrite:false,depthFunc:THREE.LessEqualDepth,polygonOffset:true,polygonOffsetFactor:-4,blending:THREE.NormalBlending,alphaTest:0.01,clipping:true});this._solidWhiteMaterial=new THREE.MeshBasicMaterial({color:0xFFFFFF});};
c.prototype.destroy=function(){if(this._defaultNodeHierarchy){this._defaultNodeHierarchy.destroy();this._defaultNodeHierarchy=null;}this._sceneBuilder=null;this._scene=null;this._animationSequenceMap.clear();S.prototype.destroy.call(this);};
c.prototype.setDoubleSided=function(v){this.setProperty("doubleSided",v,true);this._scene.traverse(function(a){if(a.material!==undefined){var u=a.userData;var b=THREE.FrontSide;var e;if(u.originalMaterial){if(u.originalMaterial.userData===undefined){u.originalMaterial.userData={};}e=u.originalMaterial.userData;if(e.originalMaterialSide===undefined){e.originalMaterialSide=u.originalMaterial.side;}b=e.originalMaterialSide;}else{if(a.material.userData===undefined){a.material.userData={};}e=a.material.userData;if(e.originalMaterialSide===undefined){e.originalMaterialSide=a.material.side;}b=e.originalMaterialSide;}a.material.side=v?THREE.DoubleSide:b;}});return this;};
c.prototype.setViewStateManager=function(v){this._currentViewStateManager=v;return this;};
c.prototype.getViewStateManager=function(){return this._currentViewStateManager;};
c.prototype.getId=function(){return this._id;};
c.prototype.getDefaultNodeHierarchy=function(){if(!this._defaultNodeHierarchy){this._defaultNodeHierarchy=new N(this);}return this._defaultNodeHierarchy;};
c.prototype._computeBoundingBox=function(v,i){var b=new THREE.Box3();if(this._scene){this._scene._expandBoundingBox(b,v,i);}return b;};
c.prototype.getSceneRef=function(){return this._scene;};
c.prototype._setSceneBuilder=function(a){this._sceneBuilder=a;};
c.prototype.nodeRefToPersistentId=function(a){return Array.isArray(a)?a.map(function(b){return b._vkPersistentId();}):a._vkPersistentId();};
c.prototype.persistentIdToNodeRef=function(a){var b=this._sceneBuilder;if(Array.isArray(a)){return a.map(function(e){return b?b.getNode(e):null;});}else{return b?b.getNode(a):null;}};
c.prototype.setNodePersistentId=function(a,b,e){return this._sceneBuilder?this._sceneBuilder.setNodePersistentId(a,b,e):false;};
c.prototype.enumerateMaterials=function(){if(!this._defaultNodeHierarchy){return[];}var t=this._defaultNodeHierarchy.createNodeProxy(this._scene);if(t){return t.enumerateMaterials(true);}else{return[];}};
var d=0;
function f(a,b){var e=a.x-b.x;if(e<-d){return true;}if(e>d){return false;}var i=a.y-b.y;if(i<-d){return true;}if(i>d){return false;}return a.z-b.z<-d;}
function g(a,b,e){if(b<e){var i=p(a,b,e);g(a,b,i-1);g(a,i+1,e);}return a;}
function p(a,b,e){var j=a[e],l=b;for(var i=b;i<e;i++){if(f(a[i],j)){s(a,i,l);l++;}}s(a,e,l);return l;}
function s(a,i,j){if(i!=j){var t=a[i];a[i]=a[j];a[j]=t;}}
var h=new THREE.Vector3();
function m(a){a.computeBoundingBox();a.boundingBox.getSize(h);d=Math.max(h.x,h.y,h.z)*1e-4;var v=a.vertices,b=v.length,e=a.faces.length;if(b===0||e===0){return;}var i,j;for(i=0;i<b;i++){v[i].index=i;}g(v,0,v.length-1);var u=[],l=[];u.push(v[0]);l[v[0].index]=u.length-1;for(i=1;i<b;i++){if(f(u[u.length-1],v[i])){u.push(v[i]);}l[v[i].index]=u.length-1;}a.vertices=u;for(i=0,e=a.faces.length,j=0;i<e;i++){var t=a.faces[i];var w=a.faces[j];w.a=l[t.a];w.b=l[t.b];w.c=l[t.c];if(w.a!==w.b&&w.b!==w.c&&w.c!==w.a){j++;}}a.faces.length=j;}
function O(a,t){THREE.BufferGeometry.call(this);this.type="OutlineGeometry";var b=Math.cos(THREE.Math.DEG2RAD*((t!==undefined)?t:1));var u={},w,x;var y,z=["a","b","c"];var v=new THREE.Vector3();var B;if(a.isBufferGeometry){B=new THREE.Geometry();B.fromBufferGeometry(a);}else{B=a.clone();}m(B);B.computeFaceNormals();var C=B.vertices;var D=B.faces;for(var E=0,l=D.length;E<l;E++){var F=D[E];for(var i=0,j=2;i<3;j=i++){w=F[z[j]];x=F[z[i]];y=Math.min(w,x)+","+Math.max(w,x);if(u[y]===undefined){u[y]={index1:w,index2:x,face1:E,face2:undefined};}else{u[y].face2=E;}}}var G=[];var H=[];var I=[];for(y in u){var e=u[y];if(e.face2===undefined||(D[e.face1].normal.dot(D[e.face2].normal)<=b&&v.copy(C[e.index2]).sub(C[e.index1]).cross(D[e.face1].normal).dot(D[e.face2].normal)>0)){var J=C[e.index1];G.push(J.x,J.y,J.z);J=C[e.index2];G.push(J.x,J.y,J.z);var K=D[e.face1].normal;H.push(K.x,K.y,K.z);H.push(K.x,K.y,K.z);if(e.face2!==undefined){var L=D[e.face2].normal;I.push(L.x,L.y,L.z);I.push(L.x,L.y,L.z);}else{I.push(0,0,0);I.push(0,0,0);}}}this.addAttribute("position",new THREE.Float32BufferAttribute(G,3));this.addAttribute("normal1",new THREE.Float32BufferAttribute(H,3));this.addAttribute("normal2",new THREE.Float32BufferAttribute(I,3));}
O.prototype=Object.create(THREE.BufferGeometry.prototype);O.prototype.constructor=O;
function k(b){return(b===null)||(b.min.x>=b.max.x&&b.min.y>=b.max.y&&b.min.z>=b.max.z);}
function n(a){var b=null;if(a.isMesh&&a.geometry&&!k(a.geometry.boundingBox)&&(a.name||a.children.length>0)){b=a.geometry;if(b.isBufferGeometry){b=new THREE.Geometry().fromBufferGeometry(b);}}for(var i=0,l=a.children.length;i<l;i++){var e=a.children[i];if(e.isMesh&&e.geometry&&!k(e.geometry.boundingBox)&&!e.name&&e.children.length===0){if(b===null){b=new THREE.Geometry();}var j=e.geometry;if(j.isBufferGeometry){j=new THREE.Geometry().fromBufferGeometry(j);}b.merge(j,e.matrix);}}return b;}
function o(a,b){var u=a.userData;if(u.defaultMaterial===undefined){u.defaultMaterial=u.originalMaterial||a.material;}a.material=b;u.originalMaterial=null;a._vkUpdateMaterialColor();a._vkUpdateMaterialOpacity();}
function r(a){var u=a.userData;if(u.defaultMaterial){a.material=u.defaultMaterial;delete u.defaultMaterial;u.originalMaterial=null;a._vkUpdateMaterialColor();a._vkUpdateMaterialOpacity();}}
c.prototype._createOutlineGeometry=function(a){if(this._scene){this._scene._vkTraverseMeshNodes(function(b){if(b.isOutline){b.visible=true;}else{if(!b.hasOutline){var e;try{e=n(b);}catch(i){e=null;}if(e!==null){b.hasOutline=true;var j=new O(e);j.boundingBox=new THREE.Box3();var l=new THREE.LineSegments(j,this._outlineMaterial);l.isOutline=true;l.renderOrder=b.renderOrder+0.5;b.add(l);}}if(b.isMesh&&b.material&&!b.material.isLineBasicMaterial&&!b.material.isLineMaterial){switch(a){case R.LineIllustration:o(b,this._solidWhiteMaterial);break;case R.ShadedIllustration:var t=(b.userData.defaultMaterial||b.userData.originalMaterial||b.material).clone();if(t.emissive){t.color.multiplyScalar(0.5);t.emissive.multiplyScalar(0.5).addScalar(0.5);}else{t.color.multiplyScalar(0.5).addScalar(0.5);}o(b,t);break;default:r(b);break;}}}}.bind(this));}};
c.prototype._hideOutlineGeometry=function(){if(this._scene){this._scene._vkTraverseMeshNodes(function(a){if(a.isOutline){a.visible=false;}if(a.isMesh){r(a);}});}};
c.prototype.createAnimationSequence=function(i,a,b){var e=new A(i,a,b);this._animationSequenceMap.set(i,e);return e;};
c.prototype.getAnimationSequence=function(i){var a=this._animationSequenceMap.get(i);return a;};
c.prototype.getInitialView=function(){return this._initialView;};
c.prototype.setInitialView=function(v){this._initialView=v;};
c.prototype.getMaterial=function(a){return this._materialMap.get(a);};
c.prototype.setMaterial=function(a,b){this._materialMap.set(a,b);};
c.prototype.clearMaterials=function(){this._materialMap.clear();};
return c;});
sap.ui.predefine('sap/ui/vk/threejs/SceneBuilder',["jquery.sap.global","./thirdparty/three","sap/base/Log","./BBoxSubdivider","./UsageCounter","../totara/TotaraUtils","./OrthographicCamera","./PerspectiveCamera","./DetailView","./AnimationHelper","./Thrustline","../View","./Billboard","./Callout","../BillboardCoordinateSpace","../BillboardTextEncoding","../BillboardStyle","../BillboardBorderLineStyle","../BillboardHorizontalAlignment","../LeaderLineMarkStyle","../DetailViewType","../DetailViewShape","./AnimationSequence","../AnimationPlayback","../RenderMode","./Material","../ObjectType","../thirdparty/ie-polyfills"],function(q,t,L,B,U,T,O,P,D,A,a,V,c,C,d,f,g,h,j,k,m,n,o,p,R,M,r,s){"use strict";var S=function(b,e,i,l){this._id=S._nextId++;S._add(this);this._callouts=new Map();this._cameras=new Map();this._images=new Map();this._imageIdsAndTileWidths=new Map();this._geometries=new Map();this._meshNodes=new Map();this._meshSubmeshes=new Map();this._geometryMeshes=new Map();this._materialMeshes=new Map();this._materialClones=new Map();if(b){this._rootNode=b;this._nodes=new Map();this._tracks=new Map();this._trackIdSequenceNodeMap=new Map();this._viewGroups=new Map();this._views=new Map();}else{this._rootNode=null;this._nodes=null;this._tracks=null;this._trackIdSequenceNodeMap=null;this._viewGroups=null;this._views=null;}this._currentSceneId=null;this._sceneIdTreeNodesMap=new Map();this._sceneIdRootNodeMap=new Map();this._sceneIdViewGroupMap=new Map();this._sceneIdViewMap=new Map();this._highlightStyles=new Map();this._animationHelper=new A(this);if(e){this._countentResource=e;var g1=e.getNodeProxy();var h1=g1.getNodeHierarchy();this._vkScene=h1.getScene();var i1=e.getSource();if(i1&&i1.name){this._sceneIdTreeNodesMap.set(i1.name,this._nodes);this._sceneIdRootNodeMap.set(i1.name,b);this._sceneIdViewGroupMap.set(i1.name,this._viewGroups);this._sceneIdViewMap.set(i1.name,this._views);this._currentSceneId=i1.name;}if(this._rootNode){if(!this._rootNode.userData){this._rootNode.userData={};}this._rootNode.userData.skipIt=!e.name;}}this._viewThumbnails=new Map();this._thrustlines=new Map();this._animations=new Map();this._animationTracks=new Map();this._resolve=i;this._reject=l;};S._nextId=1;S._map=new Map();
S.prototype.getId=function(){return this._id;};
S.getById=function(i){return this._map.get(i);};
S._add=function(b){S._map.set(b.getId(),b);return this;};
var u=[R.Default,R.Default,R.Default,R.LineIllustration,R.SolidOutline,R.ShadedIllustration];
S.prototype.setScene=function(i){if(i.result!==1){this._reject(i.result);}else{var b=this._cameras.get(i.cameraId);this._resolve({node:this._parentNode,camera:b,backgroundTopColor:i.backgroundTopColor,backgroundBottomColor:i.backgroundBottomColor,contentResource:this._contentResource,builder:this});}};
S.prototype.setRootNode=function(b,e,i,l){this._rootNode=b;this._nodes=new Map();this._nodes.set(e,b);if(!this._rootNode.userData){this._rootNode.userData={};}this._tracks=new Map();this._trackIdSequenceNodeMap=new Map();this._viewGroups=new Map();this._views=new Map();if(i){this._sceneIdTreeNodesMap.set(i,this._nodes);this._sceneIdRootNodeMap.set(i,b);this._sceneIdViewGroupMap.set(i,this._viewGroups);this._sceneIdViewMap.set(i,this._views);this._currentSceneId=i;}if(l){this._vkScene=l;}return this;};
S.prototype._resetCurrentScene=function(b){if(b&&b!==this._currentSceneId){var e=this._sceneIdTreeNodesMap.get(b);if(e){this._nodes=e;}else{this._nodes=null;}var i=this._sceneIdRootNodeMap.get(b);if(i){this._rootNode=i;}else{this._rootNode=null;}this._currentSceneId=b;}};
S.prototype.getNode=function(b,e){if(e){this._resetCurrentScene(e);if(this._nodes){return this._nodes.get(b);}}else{var i=this._sceneIdTreeNodesMap.values();var l=i.next();while(!l.done){var g1=l.value.get(b);if(g1){return g1;}l=i.next();}}return null;};
S.prototype.hasMesh=function(b){return this._meshSubmeshes.has(b);};
S.prototype.hasImage=function(i){return this._images.has(i);};
S.prototype.setNodePersistentId=function(b,e,i){if((b.userData.treeNode&&b.userData.treeNode.sid)||this.getNode(e,i)){return false;}this._resetCurrentScene(i);if(!b.userData.treeNode){b.userData.treeNode={};}b.userData.treeNode.sid=e;if(this._nodes){this._nodes.set(e,b);}return true;};
var v=function(b){var e=new THREE.Matrix4();if(b.length===3){e.setPosition(new THREE.Vector3().fromArray(b));}else if(b.length===12){e.set(b[0],b[3],b[6],b[9],b[1],b[4],b[7],b[10],b[2],b[5],b[8],b[11],0.0,0.0,0.0,1.0);}else if(b.length===16){e.set(b[0],b[4],b[8],b[12],b[1],b[5],b[9],b[13],b[2],b[6],b[10],b[14],b[3],b[7],b[11],b[15]);}else{throw"Invalid matrix format";}return e;};var w={r:0.0235,g:0.0235,b:0.0235};var x={r:0.0602,g:0.0602,b:0.0602};
S.prototype._createTemporaryMaterial=function(b){var e=new THREE.MeshPhongMaterial({color:0xaaaaaa});e.userData.defaultHighlightingEmissive=w;e.userData.defaultHighlightingSpecular=x;e.userData.materialUsed=0;e.userData.materialId=b;e.userData.toBeUpdated=true;var i=new M();i.setMaterialRef(e);this._vkScene.setMaterial(b,i);return e;};
S.prototype._getMaterialRef=function(b){var e=this._vkScene.getMaterial(b);return e?e.getMaterialRef():null;};
S.prototype.checkMaterialExists=function(b,e){if(this._getMaterialRef(b)===null){if(e){this._createTemporaryMaterial(b);}return false;}return true;};
S.prototype._attachMaterialClone=function(b,e){T.pushElementIntoMapArray(this._materialClones,b,e);};
S.prototype._addDynamicObject=function(b,e){var i=this._rootNode.userData;if(!i._vkDynamicObjects){i._vkDynamicObjects=[];}if(i._vkDynamicObjects.indexOf(b)<0){i._vkDynamicObjects.push(b);}b._vkUpdate=e;};
S.prototype.createNode=function(b,e){this._resetCurrentScene(e);var i=new THREE.Group();var l=i.userData;l.treeNode=b;l.closed=b.closed;l.selectable=b.selectable;l.metadata=b.metadata;if(b.name){i.name=b.name;}if(b.visible!==undefined){i.visible=b.visible;}if(b.renderOrder){i.renderOrder=b.renderOrder;}if(b.visualisable===false){l.skipIt=true;}if(b.opacity!==undefined){l.opacity=b.opacity;}if(b.transform){i.applyMatrix(v(b.transform));if(!isFinite(i.quaternion.x)||!isFinite(i.quaternion.y)||!isFinite(i.quaternion.z)||!isFinite(i.quaternion.w)){i.quaternion.set(0,0,0,1);}}if(b.transformType){l.transformType=b.transformType;switch(b.transformType){case"ORTHO2D":l.originalTransform={p:i.position.clone(),q:i.quaternion.clone(),s:i.scale.clone()};this._addDynamicObject(i,c.prototype._ortho2DUpdate);break;case"BILLBOARD_VIEW":this._addDynamicObject(i,c.prototype._billboardViewUpdate);break;case"LOCK_TOVIEWPORT":this._addDynamicObject(i,c.prototype._lockToViewportUpdate);break;default:break;}}this._nodes.set(b.sid,i);if(b.meshId){this.setMeshNode(b.sid,b.meshId);}var g1=this._nodes.get(b.parentId);(g1||this._rootNode).add(i);if(i.visible){while(g1){g1.visible=i.visible;g1=g1.parent;}}if(i.parent.userData.objectType===r.Hotspot){l.objectType=r.Hotspot;}else if(i.parent.userData.objectType===r.PMI){l.objectType=r.PMI;}else if(b.contentType==="HOTSPOT"){l.objectType=r.Hotspot;}else if(b.contentType==="PMI"){l.objectType=r.PMI;}return i;};
function y(b,e,l){var i;if(b.isPolyline){var g1=new THREE.LineBasicMaterial({color:0xff0000,linewidth:1});if(e){g1.color.copy(e.color);}i=new THREE.LineSegments(b,g1);}else{i=new THREE.Mesh(b,e);}if(b.isPositionQuantized){F(i,l.boundingBox);}U.increaseGeometryUsed(b);return i;}
S.prototype.getChildNodeIds=function(b,e,l){this._resetCurrentScene(e);var g1=this._nodes.get(b);var h1=[];if(!g1){return h1;}if(g1&&g1.children){for(var i=0;i<g1.children.length;i++){var i1=g1.children[i];if(i1.userData.treeNode&&i1.userData.treeNode.sid){h1.push(i1.userData.treeNode.sid);}else if(l&&i1.userData.submeshInfo&&i1.userData.submeshInfo.id){h1.push(i1.userData.submeshInfo.id);}}}return h1;};
function z(l){for(var i=0;i<l.length;i++){if(l[i].type==="box"&&l[i].data){return l[i];}}return null;}
function E(l){if(Array.isArray(l)){for(var i=0;i<l.length;i++){if(l[i].type===undefined||l[i].type==="mesh"||l[i].type==="line"){return l[i];}}}return null;}
function F(b,e){if(Array.isArray(e)&&e.length===6){b.position.set((e[3]+e[0])*0.5,(e[4]+e[1])*0.5,(e[5]+e[2])*0.5);b.scale.set(Math.max(e[3]-e[0],Number.EPSILON),Math.max(e[4]-e[1],Number.EPSILON),Math.max(e[5]-e[2],Number.EPSILON));}else{b.position.setScalar(0);b.scale.setScalar(1);}}
var G=new Float32Array([0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0]);var H=new Uint16Array([0,1,2,2,1,3,4,6,5,5,6,7,8+0,8+1,8+2,8+2,8+1,8+3,8+4,8+6,8+5,8+5,8+6,8+7,16+0,16+1,16+2,16+2,16+1,16+3,16+4,16+6,16+5,16+5,16+6,16+7]);
S.prototype.insertSubmesh=function(i){var l=this._getMaterialRef(i.materialId)||this._createTemporaryMaterial(i.materialId);var g1,h1;if(i.lods){var i1=E(i.lods);if(!i1){return false;}h1=this._geometries.get(i1.id);if(h1){g1=y(h1,l,i1);if(h1.userData&&h1.userData.noNormal&&i.materialId){this.updateMaterialForGeometryWithoutNormal(i.materialId);}}else{var j1;try{var k1=z(i.lods);if(k1&&k1.data){var l1=T.base64ToUint8Array(k1.data);var m1=B.unpackSubDividedBoundingBox(l1);j1=B.makeSubDividedBoundingBoxGeometry(m1);}}catch(e){}g1=new THREE.Mesh(j1?j1:new THREE.BoxBufferGeometry(1,1,1),l);F(g1,i1.boundingBox);g1.userData.geometryId=i1.id;g1.userData.lodInfo=i1;T.pushElementIntoMapArray(this._geometryMeshes,i1.id,i.meshId);}}else if(i.boundingBox){var b=i.boundingBox;var n1=new Float32Array([b[0],b[1],b[5],b[3],b[1],b[5],b[0],b[4],b[5],b[3],b[4],b[5],b[0],b[1],b[2],b[3],b[1],b[2],b[0],b[4],b[2],b[3],b[4],b[2],b[0],b[4],b[5],b[3],b[4],b[5],b[0],b[4],b[2],b[3],b[4],b[2],b[0],b[1],b[5],b[3],b[1],b[5],b[0],b[1],b[2],b[3],b[1],b[2],b[3],b[1],b[5],b[3],b[1],b[2],b[3],b[4],b[5],b[3],b[4],b[2],b[0],b[1],b[5],b[0],b[1],b[2],b[0],b[4],b[5],b[0],b[4],b[2]]);h1=new THREE.BufferGeometry();h1.setIndex(new THREE.BufferAttribute(H,1));h1.addAttribute("position",new THREE.BufferAttribute(n1,3));h1.addAttribute("normal",new THREE.BufferAttribute(G,3));g1=new THREE.Mesh(h1,l);}else{return false;}if(i.transform){g1.applyMatrix(v(i.transform));}g1.userData.submeshId=i.id;g1.userData.initialMaterialId=i.materialId;g1.userData.meshId=i.meshId;g1.userData.materialId=i.materialId;g1.userData.submeshInfo=i;T.pushElementIntoMapArray(this._materialMeshes,i.materialId,i.meshId);T.pushElementIntoMapArray(this._meshSubmeshes,i.meshId,g1);var o1=this._meshNodes.get(i.meshId);if(o1){o1.forEach(function(p1){p1.add(g1.clone());K(p1,i.materialId,this._materialClones);}.bind(this));}return true;};
function I(b,e,l,g1){for(var i=0;i<b.length;i++){var h1=b[i];if(e&&h1.userData.geometryId===e&&h1.geometry!==l){if(h1.type==="Mesh"&&!l.isPolyline){h1.geometry=l;var i1=h1.parent&&h1.parent.userData.transformType==="ORTHO2D";F(h1,l.isPositionQuantized&&!i1?h1.userData.lodInfo.boundingBox:null);U.increaseGeometryUsed(l);}else{var j1=y(l,h1.material,h1.userData.lodInfo);j1.userData=h1.userData;j1.parent=h1.parent;b[i]=j1;h1.parent=null;}}}}
function J(b,e,i,l){var g1=b.userData.opacity!==undefined?b.userData.opacity:1;var h1=b.children;h1.forEach(function(i1){if(i1.userData.materialId===e){U.increaseMaterialUsed(i);i1.material=i;i1.userData.opacity=g1;i1._vkUpdateMaterialOpacity();if(i1.material!==i){T.pushElementIntoMapArray(l,e,i1.material);}}});}
function K(b,e,i){var l=b.userData.opacity!==undefined?b.userData.opacity:1;b.children.forEach(function(g1){if(g1.material&&(!e||e===g1.material.userData.materialId)){var h1=g1.material;g1.userData.opacity=l;g1._vkUpdateMaterialOpacity();if(g1.material!==h1){T.pushElementIntoMapArray(i,g1.material.userData.materialId,g1.material);}}});}
S.prototype.setGeometry=function(b){var e=new THREE.BufferGeometry();var g1=new THREE.BufferAttribute(new Uint16Array(b.data.indices),1);var h1=new THREE.BufferAttribute(new Float32Array(b.data.points),3);e.setIndex(g1);e.addAttribute("position",h1);if(!e.userData){e.userData={};}if(!b.isPolyline){if(b.data.normals.length===b.data.points.length){var i1=new THREE.BufferAttribute(new Float32Array(b.data.normals),3);e.addAttribute("normal",i1);}else{e.userData.noNormal=true;}if(b.data.uvs&&b.data.uvs.length*3===b.data.points.length*2){e.addAttribute("uv",new THREE.BufferAttribute(new Float32Array(b.data.uvs),2));}}else{e.isPolyline=true;}if(!b.id&&b.meshId){var j1=this._meshSubmeshes.get(b.meshId);if(j1){for(var mc=0;mc<j1.length;mc++){var l1=j1[mc];if(l1.userData.geometryId){continue;}if(!b.isPolyline){l1.geometry.copy(e);}else{for(var i=0,l=l1.parent.children.length;i<l;i++){if(l1.parent.children[i]===l1){var m1=new THREE.LineSegments(e,new THREE.LineBasicMaterial({color:l1.material.color}));l1.parent.children[i]=m1;m1.parent=l1.parent;l1.parent=null;j1[0]=m1;break;}}}}}if(this._fireSceneUpdated){this._fireSceneUpdated();}return this;}try{e.computeBoundingSphere();}catch(n1){return this;}e.isPositionQuantized=b.isPositionQuantized;e.userData.geometryId=b.id;e.userData.geometryUsed=0;this._geometries.set(b.id,e);var o1=this._geometryMeshes.get(b.id);if(o1){for(var mi=0;mi<o1.length;mi++){var q1=o1[mi];var r1=this._meshNodes.get(q1);if(r1){for(var ni=0;ni<r1.length;ni++){I(r1[ni].children,b.id,e);}}var t1=this._meshSubmeshes.get(q1);if(t1){I(t1,b.id,e);}}}return this;};
S.prototype.setMeshNode=function(b,e){var i=this._nodes.get(b);if(i){T.pushElementIntoMapArray(this._meshNodes,e,i);var l=this._meshSubmeshes.get(e);if(l){l.forEach(function(g1){i.add(g1.clone());});if(i.userData.opacity!==undefined&&i.userData.opacity<0.99){K(i,null,this._materialClones);}}}};
S.prototype.progress=function(b){L.log("reading progress:",b);};
S.prototype.loadingFinished=function(i){if(this._fireLoadingFinished){this._fireLoadingFinished(i);}};
S.prototype.getGeometry=function(b){return this._geometries.get(b);};
var N={rect:g.RectangularShape,circle:g.CircularShape,none:g.None,textGlow:g.TextGlow};var Q={none:h.None,solid:h.Solid,dash:h.Dash,dot:h.Dot,dashdot:h.DashDot,dashdotdot:h.DashDotDot};var W={left:j.Left,center:j.Center,right:j.Right};var X={none:k.None,point:k.Point,arrow:k.Arrow};var _=new THREE.Color();
S.prototype.createAnnotation=function(b,e){this._resetCurrentScene(e);var i=this._nodes.get(b.nodeId);if(!i){L.warning("Annotation node not found",b);return;}var l=i.userData.originalTransform;if(l){i.position.copy(l.p);i.scale.copy(l.s);}var g1=b.type;if(g1===undefined){this.createLegacyAnnotation(b,i);return;}if(g1==="html"){return;}var h1=b.label||{};var i1=b.text||{};var j1=h1.colour||[1,1,1,1];var k1=h1.borderColour||[0,0,0,1];var l1={node:i,renderOrder:i.renderOrder||0,style:N[h1.shape]||g.RectangularShape,width:h1.width||64,height:h1.height||64,backgroundColor:_.fromArray(j1).getStyle(),backgroundOpacity:j1[3],borderColor:_.fromArray(k1).getStyle(),borderOpacity:k1[3],borderWidth:h1.borderColour?(h1.borderWidth||0):0,borderLineStyle:Q[h1.borderLineStyle]||h.Solid,horizontalAlignment:W[i1.align]};if(i1.html){l1.encoding=f.HtmlText;l1.text=i1.html;}else{l1.encoding=f.PlainText;l1.text=i1.text;l1.font=i1.fontFace||"Arial";l1.fontSize=Math.abs(i1.fontSize)||16;l1.fontWeight=Math.min(i1.fontWeight,900);l1.fontItalic=i1.fontItalic;l1.textColor=_.fromArray(i1.colour||[0,0,0]).getStyle();}if(g1==="text"){var m1=i.position;l1.position=new THREE.Vector3(m1.x*2,m1.y*2,m1.z);var n1=new c(l1);n1.setText(l1.text);this._addDynamicObject(i,n1._update.bind(n1));}else if(g1==="note"){var o1=b.attachment||{};l1.position=new THREE.Vector3().fromArray(o1.position||[0,0,0]);l1.anchorNode=this._nodes.get(o1.sid)||this._rootNode;l1.depthTest=false;var p1=new C(l1);p1.setText(l1.text);this._callouts.set(b.id,p1);this._addDynamicObject(i,p1._update.bind(p1));}else{L.warning("Unsupported annotation type",b);}};
var Y=[g.RectangularShape,g.CircularShape,g.None,g.TextGlow];var Z=[d.Viewport,d.Screen,d.World];var $=[h.None,h.Solid,h.Dash,h.Dot,h.DashDot,h.DashDotDot];var a1=[k.None,k.Point,k.Arrow];var b1=[j.Left,j.Center,j.Right];
function c1(b){var e=b.toString(16);if(b.length>=3){e=(((b[0]*255)<<16)|((b[1]*255)<<8)|(b[2]*255)).toString(16);}return"#"+"000000".substring(e.length)+e;}
function d1(b){for(var i=0,l=b.length;i<l;i++){if(!isFinite(b[i])){return false;}}return true;}
S.prototype.createLegacyAnnotation=function(b,e){var i=b.position;if(!d1(i)){L.warning("Incorrect annotation position",b);return;}b.coordinateSpace|=0;var l=b.backgroundOpacity;if(!l){l=b.backgroundColour?b.backgroundColour[3]:0;}var g1=b.borderOpacity;if(!g1){g1=b.borderColour?b.borderColour[3]:0;}var h1={node:e,coordinateSpace:Z[b.coordinateSpace],style:Y[b.shape||0],width:b.width,height:b.height,backgroundColor:b.backgroundColour?c1(b.backgroundColour):"#fff",backgroundOpacity:l,borderColor:b.borderColour?c1(b.borderColour):"#000",borderOpacity:g1,borderWidth:b.borderWidth,borderLineStyle:$[b.borderLineStyle]};if(b.encoding!==undefined){h1.encoding=b.encoding?f.HtmlText:f.PlainText;h1.font=b.font;h1.fontSize=b.fontSize;h1.fontWeight=Math.min(b.fontWeight,900);h1.fontItalic=b.fontItalic;h1.textColor=c1(b.textColor);h1.link=b.link;h1.horizontalAlignment=b1[b.textHorizontalAlignment];h1.position=new THREE.Vector3().fromArray(i);}else if(b.fontFace){h1.encoding=f.PlainText;h1.font=b.fontFace;h1.fontSize=Math.abs(b.fontSize);h1.fontWeight=Math.min(b.fontWeight,900);h1.textColor=c1(b.textColour);}else{h1.encoding=f.HtmlText;}if(b.coordinateSpace<2){if(!h1.positions){h1.position=new THREE.Vector3(i[0]*2-1,i[1]*-2+1,i[2]);}h1.renderOrder=(b.order|0)+1000;var i1=new c(h1);i1.setText(b.text);this._addDynamicObject(e,i1._update.bind(i1));}else{h1.anchorNode=this._nodes.get(b.sid)||this._rootNode;if(!h1.postion){h1.position=new THREE.Vector3().fromArray(i);}h1.depthTest=false;h1.renderOrder=b.order|0;if(b.alwaysOnTop){h1.renderOrder=1;}var j1=new C(h1);j1.setText(b.text);this._callouts.set(b.id,j1);this._addDynamicObject(e,j1._update.bind(j1));}};
S.prototype.createImageNote=function(b,e){this._resetCurrentScene(e);var i=this._nodes.get(b.nodeId);if(!i){L.warning("Image annotation node not found",b);return;}if(b.type==="image"){var l=b.label||{};var g1=this._getMaterialRef(l.materialId);if(!g1){L.warning("Image annotation material not found",b);return;}var h1=i.userData.originalTransform;if(h1){i.position.copy(h1.p);i.scale.copy(h1.s);}var i1=new c({node:i,renderOrder:i.renderOrder||0,coordinateSpace:d.Screen,position:new THREE.Vector3(i.position.x,i.position.y,0),width:(l.width||200)*i.scale.x*0.5,height:(l.height||200)*i.scale.y*0.5});i.position.setScalar(0);i.scale.setScalar(1);i.updateMatrix();i1.setMaterial(g1);this._addDynamicObject(i,i1._update.bind(i1));}else{this.createLegacyImageNote(b,i);}};
S.prototype.createLegacyImageNote=function(b,e){var i=new THREE.Vector3().fromArray(b.position);var l=b.width;var g1=b.height;if(!b.properlyAligned){i.x+=b.width*0.5;i.y+=b.height*0.5;i.applyMatrix4(e.matrix);l=b.width*0.5*e.matrix.elements[0];g1=b.height*0.5*e.matrix.elements[5];}var h1=new c({node:e,coordinateSpace:d.Screen,renderOrder:(b.order|0)+1000,position:i,width:l,height:g1});var i1=this._getMaterialRef(b.labelMaterialId);h1.setMaterial(i1);this._addDynamicObject(e,h1._update.bind(h1));};
S.prototype.insertLeaderLine=function(b,e){this._resetCurrentScene(e);var g1=this._callouts.get(b.annotationId);if(g1){var h1=this._getMaterialRef(b.materialId);if(!h1){L.warning("Leader line material not found",b);return;}var i1=[];var j1=b.points;for(var i=0,l=j1.length;i<l;i++){i1.push(new THREE.Vector3().fromArray(j1[i]));}var k1;if(b.start){var l1=b.start||{};var m1=b.end||{};var n1=b.extension||{};k1=this._nodes.get(b.start.sid)||this._rootNode;g1.addLeaderLine(i1,k1,h1,X[l1.style]||k.None,X[m1.style]||k.None,l1.size,n1.length||0);}else{k1=this._nodes.get(b.startPointSid)||this._rootNode;g1.addLeaderLine(i1,k1,h1,a1[b.startPointHeadStyle],a1[b.endPointHeadStyle],b.pointHeadConstant,b.extensionLength);}}};
S.prototype.createDetailView=function(i,b){this._resetCurrentScene(b);var e=this._nodes.get(i.nodeId);if(!e){L.warning("Detail view node not found",i);return;}var l=i.label;if(!l){this.createLegacyDetailView(i,e);return;}var g1=i.attachment;var h1={name:i.name,camera:l.camera?this.createCamera(l.camera):null,type:i.cutaway?m.Cutaway:m.DetailView,borderWidth:l.borderWidth||0,backgroundColor:_.fromArray(l.colour||[1,1,1]).getStyle(),borderColor:_.fromArray(l.borderColour||[1,1,1]).getStyle(),origin:new THREE.Vector2(e.position.x*2-1+e.scale.x,e.position.y*-2+1-e.scale.x),size:new THREE.Vector2(e.scale.x,e.scale.y),attachmentPoint:new THREE.Vector3().fromArray(g1.position||[0,0,0]),veId:i.veid};if(l.shape==="rect"){h1.shape=!l.leaderStyle||l.leaderStyle==="none"?n.Box:n.BoxLine;}else{h1.shape={none:n.Circle,line:n.CircleLine,pointer:n.CirclePointer,arrow:n.CircleArrow,bubbles:n.CircleBubbles}[l.leaderStyle]||n.Circle;}var i1=new D(h1);if(!this._rootNode.userData._vkDetailViews){this._rootNode.userData._vkDetailViews=[];}this._rootNode.userData._vkDetailViews.push({detailView:i1,node:e,renderOrder:i.renderOrder||e.renderOrder||0});};
S.prototype.createLegacyDetailView=function(i,b){if(!i.properlyAligned){if(!i.shape){i.shape=i.leaderStyle?n.BoxLine:n.Box;}else{i.shape=[n.Circle,n.CircleLine,n.CirclePointer,n.CircleArrow,n.CircleBubbles][i.leaderStyle||0];}i.type=i.cutaway?m.Cutaway:m.DetailView;i.camera=i.camera?this.createCamera(i.camera):null;i.origin=new THREE.Vector2(b.position.x*2-1+b.scale.x,b.position.y*-2+1-b.scale.x);i.size=new THREE.Vector2(b.scale.x,b.scale.y);i.renderOrder=b.renderOrder;}else{i.type=[m.DetailView,m.Cutaway][i.type];i.shape=[n.Box,n.Circle,n.CircleLine,n.CirclePointer,n.CircleArrow,n.CircleBubbles,n.BoxLine,n.BoxNoOutline,n.SolidPointer,n.SolidArrow][i.shape];i.camera=this._cameras.get(i.cameraId);i.origin=new THREE.Vector2().fromArray(i.origin);i.size=new THREE.Vector2().fromArray(i.size);}var e=new D({name:i.name,camera:i.camera,type:i.type,shape:i.shape,borderWidth:i.borderWidth||0,backgroundColor:i.backgroundColour?c1(i.backgroundColour):"#fff",borderColor:i.borderColour?c1(i.borderColour):"#000",origin:i.origin,size:i.size,attachmentPoint:new THREE.Vector3().fromArray(i.attachment),metadata:i.metadata,veId:i.veid});if(!this._rootNode.userData._vkDetailViews){this._rootNode.userData._vkDetailViews=[];}this._rootNode.userData._vkDetailViews.push({detailView:e,node:b,renderOrder:i.renderOrder||0});};
S.prototype.insertThrustline=function(i){var b=this._nodes.get(i.thrustlineId);if(b&&!this._thrustlines.get(i.thrustlineId)){var e=new a({node:b,principleAxis:new THREE.Vector3().fromArray(i.principleAxis),material:this._getMaterialRef(i.materialId)});var l=[];var g1=0;var h1=0;var i1=0;for(var ii=0;ii<i.itemCount;ii++){var k1={};k1.target=this._nodes.get(i.targets[ii]);k1.majorAxisIndex=i.itemMajorAxisesIndices[ii];var bi;k1.basisAxises=[];i1=g1+i.itemBasisAxisesCounts[ii];for(bi=g1;bi<i1;bi++){var m1={};m1.x=i.itemBasisAxisesCoordinates[bi*3];m1.y=i.itemBasisAxisesCoordinates[bi*3+1];m1.z=i.itemBasisAxisesCoordinates[bi*3+2];k1.basisAxises.push(m1);}g1=i1;k1.dimension={};k1.dimension.x=i.itemDimensionsCoordinates[ii*3];k1.dimension.y=i.itemDimensionsCoordinates[ii*3+1];k1.dimension.z=i.itemDimensionsCoordinates[ii*3+2];k1.center={};k1.center.x=i.itemCentersCoordinates[ii*3];k1.center.y=i.itemCentersCoordinates[ii*3+1];k1.center.z=i.itemCentersCoordinates[ii*3+2];k1.boundPoints=[];i1=h1+i.itemBoundPointsCounts[ii];for(bi=h1;bi<i1;bi++){var n1={};n1.x=i.itemBoundPointsCoordinates[bi*3];n1.y=i.itemBoundPointsCoordinates[bi*3+1];n1.z=i.itemBoundPointsCoordinates[bi*3+2];k1.boundPoints.push(n1);}h1=i1;l.push(k1);}e.setItems(l);var o1=0;var p1=[];for(var si=0;si<i.segmentCount;si++){var r1={};r1.startItemIndex=i.segmentsStartItemIndices[si];r1.endItemIndex=i.segmentsEndItemIndices[si];r1.startBoundIndex=i.segmentsStartBoundIndices[si];r1.endBoundIndex=i.segmentsEndBoundIndices[si];r1.ratios=[];i1=o1+i.segmentRatioCounts[si];for(var ri=0;ri<i1;ri++){var t1={};t1.x=i.segmentRatiosCoordinates[ri*2];t1.y=i.segmentRatiosCoordinates[ri*2+1];r1.ratios.push(t1);}o1=i1;p1.push(r1);}e.setSegments(p1);this._thrustlines.set(i.thrustlineId,e);this._addDynamicObject(b,e._update.bind(e));}};
S.prototype._decrementResourceCounters=function(b){b.traverse(function(e){if(e.isMesh){U.decreaseMaterialUsed(e.material);U.decreaseGeometryUsed(e.geometry);}});};
S.prototype.decrementResourceCountersForDeletedTreeNode=function(b,e){this._resetCurrentScene(e);var i=this;b=[].concat(b);b.forEach(function(l){var g1=i._nodes.get(l);if(g1){i._decrementResourceCounters(g1);i._nodes.delete(l);}});return this;};
S.prototype.remove=function(b,e){this._resetCurrentScene(e);var l=this;b=[].concat(b);b.forEach(function(id){var g1=l._nodes.get(id);if(g1){l._decrementResourceCounters(g1);if(g1.parent){g1.parent.remove(g1);}l._nodes.delete(id);for(var i=0;i<g1.children.length;i++){var h1=g1.children[i];if(h1.userData&&h1.userData.treeNode&&h1.userData.treeNode.sid){l.remove(h1.userData.treeNode.sid,e);}}}});return this;};
S.prototype.resourcesCleanUp=function(){var b=this._geometries;b.forEach(function(e){var i=e.userData.geometryUsed;if(i<=0){e.dispose();}});return this;};
S.prototype.createCamera=function(b,e){this._resetCurrentScene(e);var i=b.near||1;var l=b.far||200000;var g1;if(b.ortho){g1=new THREE.OrthographicCamera(-1,1,1,-1,i,l);g1.zoom=b.zoom||-1;}else{g1=new THREE.PerspectiveCamera(THREE.Math.radToDeg(b.fov),1,i,l);}if(b.origin){var h1=new THREE.Vector3().fromArray(b.origin);g1.position.copy(h1);}if(b.up){var up=new THREE.Vector3().fromArray(b.up);if(b.notUseDirectionVector){up.sub(g1.position);}g1.up.copy(up.normalize());}if(b.target){if(b.notUseDirectionVector){g1.lookAt(new THREE.Vector3().fromArray(b.target));}else{g1.lookAt((new THREE.Vector3().fromArray(b.target)).add(g1.position));}}this._rootNode.userData.camera=g1;var j1=null;if(g1.isOrthographicCamera){j1=new O();}else if(g1.isPerspectiveCamera){j1=new P();}j1.setCameraRef(g1);j1.setUsingDefaultClipPlanes(true);j1.cameraInfo=b;var k1=b.id;if(k1){this._cameras.set(k1,j1);}this._rootNode.userData.camera=j1;return j1;};
S.prototype.insertCamera=function(b,e,i){this._resetCurrentScene(i);var l=this._nodes.get(b);var g1=this._cameras.get(e);if(l&&g1){(l||this._rootNode).add(g1.parent?g1.clone():g1);}return this;};
S.prototype.getCamera=function(b){return this._cameras.get(b);};
S.prototype.updateMaterialForGeometryWithoutNormal=function(b){var e=this._getMaterialRef(b);if(e&&e.emissive){e.emissive.copy(e.color);e.side=THREE.DoubleSide;}return this;};
S.prototype.createMaterial=function(b){var e=[];var i=this._getMaterialRef(b.id);if(b.lineWidth>0){if(!i||!i.isLineBasicMaterial){i=new THREE.LineBasicMaterial();var l=new M(true);l.setMaterialRef(i);this._vkScene.setMaterial(b.id,l);}i.color=new THREE.Color(b.lineColour[0],b.lineColour[1],b.lineColour[2]);i.linewidth=b.lineWidth;i.userData.lineStyle={width:b.lineWidth,haloWidth:b.lineHaloWidth||0,endCapStyle:b.lineEndRound?1:0,dashPattern:b.lineDashPattern||[],dashPatternScale:b.lineDashPatternScale,widthCoordinateSpace:b.lineWidthCoordinateSpace};i.userData.materialInfo=b;i.userData.materialId=b.id;return e;}if(!i){i=this._createTemporaryMaterial(b.id);}delete i.userData.toBeUpdated;i.userData.materialInfo=b;if(b.diffuseColour){i.color.fromArray(b.diffuseColour);}if(b.specularColour){i.specular.fromArray(b.specularColour);}var g1=true;if(b.emissiveColour){i.emissive.fromArray(b.emissiveColour);if(i.emissive.r!==0||i.emissive.g!==0||i.emissive.b!==0){g1=false;i.depthFunc=THREE.LessDepth;}}if(g1&&b.ambientColour){i.emissive.fromArray(b.ambientColour);i.emissive.multiplyScalar(0.2);}if(i.opacity!==undefined){i.opacity=b.opacity;i.transparent=b.opacity<0.99;if(i.transparent){i.side=THREE.DoubleSide;}}var h1=i.glossiness?i.glossiness:0;var i1=i.specularLevel?i.specularLevel:0;i.shininess=h1*2+i1*3;i.userData.defaultHighlightingEmissive=w;i.userData.defaultHighlightingSpecular=x;e=this.updateTextureMaps(b.id);var j1=this._materialMeshes.get(b.id);if(j1){for(var mi=0;mi<j1.length;mi++){var l1=j1[mi];var m1=this._meshNodes.get(l1);if(m1){for(var ni=0;ni<m1.length;ni++){J(m1[ni],b.id,i,this._materialClones);}}}}return e;};
S.prototype.getMaterial=function(b){return this._getMaterialRef(b);};
var e1=function(b){var i="";try{var l=0x8000;var g1=0;var h1=b.length;var i1;while(g1<h1){i1=b.slice(g1,Math.min(g1+l,h1));i+=String.fromCharCode.apply(null,i1);g1+=l;}}catch(e){i="";}return i;};
S.prototype.createImage=function(i){var b=new DataView(i.binaryData.buffer);var e=true;if(b.getUint8(0,true)===parseInt("0xFF",16)&&b.getUint8(1,true)===parseInt("0xD8",16)){e=false;}var l=e1(i.binaryData);var g1="data:image/"+(e?"png":"jpeg")+";base64,"+btoa(l);this._images.set(i.id,g1);return this;};
var f1=new THREE.TextureLoader();S.TextureType={Diffuse:0,Bump:1,Opacity:2,Reflection:3,Refraction:4,Specular:5,Ambient:6,Emissive:7,SpecularLevel:8,Glosiness:9,AmbientOcclusion:10,Decal:11};
S.prototype.updateTextureMaps=function(b){var e=[];var i=this._getMaterialRef(b);if(!i){return e;}var l=i.userData.materialInfo;if(!l){return e;}if(l.textureDiffuse){var g1=this.updateTextureMap(l.id,S.TextureType.Diffuse);if(g1.imageId){e.push(g1);}}if(l.textureBump){var h1=this.updateTextureMap(l.id,S.TextureType.Bump);if(h1.imageId){e.push(h1);}}if(l.textureOpacity){var i1=this.updateTextureMap(l.id,S.TextureType.Opacity);if(i1.imageId){e.push(i1);}}if(l.textureEmissive){var j1=this.updateTextureMap(l.id,S.TextureType.Emissive);if(j1.imageId){e.push(j1);}}if(l.textureAmbientOcclusion){var k1=this.updateTextureMap(l.id,S.TextureType.AmbientOcclusion);if(k1.imageId){e.push(k1);}}if(l.textureReflection){var l1=this.updateTextureMap(l.id,S.TextureType.Reflection);if(l1.imageId){e.push(l1);}}return e;};
S.prototype.updateTextureMap=function(b,e){var i={textureType:e,imageId:null};var l=this._getMaterialRef(b);if(!l){return i;}var g1=l.userData.materialInfo;if(!g1){return i;}var h1=null;switch(e){case S.TextureType.Diffuse:h1=g1.textureDiffuse;break;case S.TextureType.Bump:h1=g1.textureBump;break;case S.TextureType.Opacity:h1=g1.textureOpacity;break;case S.TextureType.Reflection:h1=g1.textureReflection;break;case S.TextureType.Emissive:h1=g1.textureEmissive;break;case S.TextureType.AmbientOcclusion:h1=g1.textureAmbientOcclusion;break;default:break;}if(!h1){return i;}var i1=h1[0];if(!i1){i1=h1;}var j1=this._images.get(i1.imageId);if(!j1){i.imageId=i1.imageId;return i;}var k1=f1.load(j1);k1.wrapS=i1.uvHorizontalTilingEnabled?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;k1.wrapT=i1.uvVerticalTilingEnabled?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;k1.magFilter=i1.filterMode===1?THREE.NearestFilter:THREE.LinearFilter;k1.minFilter=i1.filterMode===1?THREE.NearestFilter:THREE.LinearMipMapLinearFilter;k1.anisotropy=4;var l1=i1.influence!==undefined?i1.influence:0;var m1=i1.uvHorizontalScale!==undefined?i1.uvHorizontalScale:1;var n1=i1.uvVerticalScale!==undefined?i1.uvVerticalScale:1;var o1=i1.uvHorizontalOffset!==undefined?i1.uvHorizontalOffset:0;var p1=i1.uvVerticalOffset!==undefined?i1.uvVerticalOffset:0;k1.repeat.set(m1,n1);k1.center.set(-o1,-p1);k1.offset.set(o1,p1);k1.rotation=-i1.uvRotationAngle;switch(e){case S.TextureType.Diffuse:l.map=k1;l.transparent|=j1.startsWith("data:image/png");break;case S.TextureType.Bump:l.bumpMap=k1;l.bumpScale=l1;break;case S.TextureType.Opacity:l.alphaMap=k1;break;case S.TextureType.Reflection:k1.mapping=THREE.SphericalReflectionMapping;l.envMap=k1;l.combine=THREE.AddOperation;l.reflectivity=l1;break;case S.TextureType.Emissive:l.emissiveMap=k1;l.emissive.setRGB(1,1,1);break;case S.TextureType.AmbientOcclusion:l.aoMap=k1;break;default:}l.userData.textureAdded=true;l.needsUpdate=true;var q1=this._materialClones.get(b);if(q1){q1.forEach(function(r1){r1.copy(l);r1.needsUpdate=true;});}return i;};
S.prototype.insertPlayback=function(b,e,i){this._resetCurrentScene(i);var l=new p({pid:b.id,sequenceId:b.sequenceId,timeScale:b.speed?b.speed:1,preDelay:b.preDelay?b.preDelay:0,postDelay:b.postDelay?b.postDelay:0,repeat:b.repeat?Math.abs(b.repeat):0,reversed:b.reversed?true:false,startTime:b.start?b.start:0});var g1=this._views.get(e);if(g1){var h1=g1.getPlaybacks();if(!h1){h1=[];}h1.push(l);g1.setPlaybacks(h1);}return this;};
S.prototype.insertSequence=function(i){var b;if(i.endTime){b=i.endTime;}else{b=1.0;}this._vkScene.createAnimationSequence(i.id,i.name,b);if(i.nodes&&i.nodes.length>0){for(var e=0;e<i.nodes.length;e++){var l=i.nodes[e];T.pushElementIntoMapArray(this._trackIdSequenceNodeMap,l.trackId,{sequenceId:i.id,targetId:l.sid,type:l.binding,pivot:l.pivot});}}return this;};
S.prototype.insertTracks=function(b){this._animationHelper.insertTracks(b,this._trackIdSequenceNodeMap,this._nodes,this._vkScene);return this;};
S.prototype.finalizeAnimation=function(){var b=this._rootNode;if(b){while(b.parent){b=b.parent;}if(!b.userData){b.userData={};}b.userData.tracks=this._tracks;}return this;};
S.prototype.finalizePlaybacks=function(){var b=this._rootNode;if(b){while(b.parent){b=b.parent;}if(!b.userData){b.userData={};}}else{return this;}if(!b.userData.animationNodeOriginalData){b.userData.animationNodeOriginalData=new Map();}var e;var i=this._viewGroups.entries();var l=i.next();while(!l.done){e=l.value[1];l=i.next();var g1=[];for(var vi=0;vi<e.views.length;vi++){if(e.views[vi].id){var i1=this._views.get(e.views[vi].id);if(i1){g1.push(i1);}}}}return this;};
S.prototype.finalizeViewGroups=function(b){this._resetCurrentScene(b);var e=this._viewGroups.entries();var i=e.next();while(!i.done){var l=i.value[1];var g1=i.value[0];if(!l||!l.views||!l.views.length){i=e.next();continue;}for(var vi=0;vi<l.views.length;vi++){var i1=l.views[vi].id;var j1=this._views.get(i1);if(j1&&j1.userData.viewInfo.thumbnailId&&!j1.thumbnailData){var k1=this._images.get(j1.userData.viewInfo.thumbnailId);if(k1){j1.thumbnailData=k1;}}if(j1){j1.viewGroupId=g1;l.modelViews.push(j1);}}i=e.next();}return this;};
S.prototype.insertViewGroup=function(i,b){this._resetCurrentScene(b);var e=this._rootNode;if(e){while(e.parent){e=e.parent;}if(!e.userData){e.userData={};}}else{return this;}e.userData.viewportGroups=e.userData.viewportGroups||[];var l={name:i.name,type:i.type,description:i.description,metadata:i.metadata,veids:i.veids,originalId:i.id,modelViews:[],views:i.views,sceneId:i.sceneId};e.userData.viewportGroups.push(l);this._viewGroups.set(i.id,l);return this;};
S.prototype.getViewGroup=function(b,e){this._resetCurrentScene(e);var i=this._viewGroups.get(b);var l=[];if(i&&i.views){for(var vi=0;vi<i.views.length;vi++){var g1=i.views[vi].id;var h1=this._views.get(g1);if(h1){l.push(h1);}}}return l;};
S.prototype.insertView=function(b,e){this._resetCurrentScene(e);var i=new V({name:b.name,description:b.description?"<pre style=\"white-space: pre-wrap;\">"+b.description+"</pre>":b.description});i.userData={};i.userData.viewInfo=b;if(b.thumbnailId){var l=this._images.get(b.thumbnailId);if(l){i.thumbnailData=l;}else{this._viewThumbnails.set(b.thumbnailId,i);}}if(b.animatedThumbnailId){var g1=this._images.get(b.animatedThumbnailId);if(g1){i.animatedThumbnailData=g1;i.tileWidth=this._imageIdsAndTileWidths.get(b.animatedThumbnailId);}}if(b.cameraId){i.camera=this._cameras.get(b.cameraId);}i.type=b.type;i.flyToTime=b.flyToTime;i.preDelay=b.preDelay;i.postDelay=b.postDelay;i.navigationMode=b.navigationMode;i.topColor=b.topColor;i.bottomColor=b.bottomColor;i.renderMode=u[b.renderMethod];i.dimension=b.dimension;i.query=b.query;i.metadata=b.metadata;i.veids=b.veids;i.highlights=[];i.viewGroupId=b.viewGroupId;i.id=b.viewId;this._views.set(b.viewId,i);if(i.viewGroupId){var h1=this._viewGroups.get(i.viewGroupId);if(h1){h1.modelViews.push(i);}}return this;};
S.prototype.setModelViewVisibilitySet=function(i){var b=this._views.get(i.viewId);var e=new Set();i.visibleNodes.forEach(function(l){var g1=this._nodes.get(l);if(g1){while(g1&&!e.has(g1)){e.add(g1);g1=g1.parent;}}else{}}.bind(this));b.visibleNodes=Array.from(e);};
S.prototype.recordHighlightedNodeInView=function(b,e,i,l){this._resetCurrentScene(l);var g1=this._views.get(i);if(!g1){return this;}var h1=this._nodes.get(e);if(!h1){return this;}if(!g1.highlightIdNodesMap){g1.highlightIdNodesMap=new Map();}var i1=g1.highlightIdNodesMap.get(b);if(!i1){i1=[];}i1.push(h1);g1.highlightIdNodesMap.set(b,i1);return this;};
S.prototype.insertHighlightStyle=function(i){var b=this._highlightStyles.get(i.id);if(b){return this;}b=i;this._animationHelper.addAnimationTracksToHighlight(b);this._highlightStyles.set(i.id,b);return this;};
S.prototype.insertModelViewHighlight=function(i){var b=this._views.get(i.viewId);if(b){var e=[];i.highlightNodes.forEach(function(i1){var j1=this._nodes.get(i1);if(j1){e.push(j1);}else{}}.bind(this));var l={highlightNodes:e,color1:i.color1,color2:i.color2,opacity1:i.opacity1,opacity2:i.opacity2,duration:i.duration,cycles:i.cycles};if(i.duration===0){l.type="STATIC";}else if(i.duration>0&&i.cycles===0){l.type="INFINITE";}else{l.type="FINITE";}var g1=new THREE.Color(i.color1).toArray();var h1=new THREE.Color(i.color2).toArray();g1[3]=((i.color1>>>24)&255)/255;h1[3]=((i.color2>>>24)&255)/255;l.colours=[g1,h1];l.opacities=[i.opacity1,i.opacity2];this._animationHelper.addAnimationTracksToHighlight(l);b.highlights.push(l);}};
S.prototype.createThumbnail=function(i){var b=this._viewThumbnails.get(i.imageId);if(b){b.thumbnailData="data:image/"+"jpeg"+";base64,"+window.btoa(String.fromCharCode.apply(null,i.data));if(this._fireThumbnailLoaded){this._fireThumbnailLoaded({modelView:b});}}};
S.prototype.highlightStyleExists=function(i){var b=this._highlightStyles.get(i);return b!==undefined;};
S.prototype.finalizeHighlightsInViews=function(){var b,e;var i=this._views.entries();var l=i.next();while(!l.done){b=l.value[1];e=l.value[0];l=i.next();if(b&&b.highlightIdNodesMap){b.highlights=[];var g1=b.highlightIdNodesMap.entries();var h1=g1.next();while(!h1.done){var i1=h1.value[1];var id=h1.value[0];var k1=this._highlightStyles.get(id);if(k1){k1.highlightNodes=i1;b.highlights.push(k1);}h1=g1.next();}this._animationHelper.processHighlights(b,e,this._vkScene);this._animationHelper.setInitialNodePositionsOnView(b,this._vkScene,true);}}var l1=this._viewGroups.entries();var m1=l1.next();while(!m1.done){var n1=m1.value[1];m1=l1.next();if(!n1||!n1.views||!n1.views.length){continue;}var o1=[];for(var vi=0;vi<n1.views.length;vi++){b=this._views.get(e);if(b){o1.push(b);}}if(o1.length>0){this._animationHelper.setInitialNodePositionsFromSubsequentViews(o1,this._vkScene,true);this._animationHelper.setInitialNodePositionsFromPreviousViews(o1,this._vkScene,true);}}return this;};
S.prototype.getView=function(b,e){this._resetCurrentScene(e);return this._views.get(b);};
S.prototype.getSequence=function(b){return this._vkScene.getAnimationSequence(b);};
S.prototype.setViewCamera=function(b,e,i){this._resetCurrentScene(i);var l=this._cameras.get(b);var g1=this._views.get(e);if(l&&g1){g1.camera=l;var h1=l.getCameraRef();if(l.cameraInfo&&h1){var i1=true;var j1=false;if(l.cameraInfo.zoom===-1){j1=true;}var k1=new THREE.Vector3();h1.getWorldDirection(k1);if(h1.type==="PerspectiveCamera"){g1.setCameraInfo({type:h1.type,fov:l.cameraInfo.fov*180/Math.PI,position:h1.position.toArray(),nearClipPlane:h1.near,farClipPlane:h1.far,upDirection:h1.up.toArray(),targetDirection:k1.toArray(),usingDefaultClipPlanes:i1});}if(h1.type==="OrthographicCamera"){g1.setCameraInfo({type:h1.type,zoomFactor:h1.zoom,position:h1.position.toArray(),nearClipPlane:h1.near,farClipPlane:h1.far,upDirection:h1.up.toArray(),targetDirection:k1.toArray(),usingDefaultClipPlanes:i1,zoomNeedRecalculate:j1});}}}return this;};
S.prototype.setViewNodeInfos=function(b,e,i){this._resetCurrentScene(i);var l=this._views.get(e);l.setNodeInfos(b);return this;};
S.prototype.setViewThumbnail=function(i,b,e,l){this._resetCurrentScene(e);var g1=this._views.get(b);var h1=this._images.get(i);if(g1&&h1){if(g1.userData!==undefined){if(g1.userData.viewInfo.thumbnailId===i){g1.thumbnailData=h1;}else if(g1.userData.viewInfo.animatedThumbnailId===i){g1.animatedThumbnailData=h1;g1.tileWidth=l;}}}return this;};
S.prototype.cleanup=function(){this._rootNode=null;if(this._vkScene){this._vkScene.clearMaterials();}this._callouts.clear();this._cameras.clear();this._images.clear();this._imageIdsAndTileWidths.clear();this._geometries.clear();this._meshNodes.clear();this._meshSubmeshes.clear();this._geometryMeshes.clear();this._materialMeshes.clear();this._materialClones.clear();this._currentSceneId=null;if(this._nodes){this._nodes.clear();}if(this._tracks){this._tracks.clear();}if(this._trackIdSequenceNodeMap){this._trackIdSequenceNodeMap.clear();}if(this._viewGroups){this._viewGroups.clear();}if(this._views){this._views.clear();}this._sceneIdTreeNodesMap.clear();this._sceneIdRootNodeMap.clear();this._sceneIdViewGroupMap.clear();this._sceneIdViewMap.clear();this._highlightStyles.clear();S._map.delete(this._id);};
S.prototype.insertAnimationGroup=function(i){var b=this._vkScene.getAnimationSequence(i.animationGroupRef.toString());if(!b){var e;if(i.endTime){if(!i.startTime){i.startTime=0;}e=i.endTime-i.startTime;}b=this._vkScene.createAnimationSequence(i.animationGroupRef.toString(),i.name,e);if(!b.userData){b.userData={};}b.userData.animations=[];}if(i.modelViewRef){var l=this._views.get(i.modelViewRef);if(l){var g1=new p({sequenceId:i.animationGroupRef.toString(),timeScale:i.playbackSpeed?i.playbackSpeed:1,preDelay:i.playbackPreDelay?i.playbackPreDelay:0,postDelay:i.playbackPostDelay?i.playbackPostDelay:0,repeat:i.playbackRepeat?Math.abs(i.playbackRepeat):0,reversed:i.playbackReversed?true:false,startTime:0});var h1=l.getPlaybacks();if(!h1){h1=[];}h1.push(g1);l.setPlaybacks(h1);}}};
S.prototype.insertAnimation=function(i){var b=this._animations.get(i.animationRef);if(!b){b={};b.type=i.animationType;b.targetRefs=[];b.targetPivots=[];b.sequenceId=i.animationGroupRef.toString();b.animationTracks=new Set();this._animations.set(i.animationRef,b);}if(i.animationGroupRef){var e=this._vkScene.getAnimationSequence(i.animationGroupRef.toString());if(!e.userData.animations.includes(i.animationRef)){e.userData.animations.push(i.animationRef);}}};
S.prototype.insertAnimationTarget=function(i){var b=this._animations.get(i.animationRef);if(b){if(!b.targetRefs.includes(i.targetRef)){b.targetRefs.push(i.targetRef);b.targetPivots.push({x:i.targetPivotX,y:i.targetPivotY,z:i.targetPivotZ});}}};
S.prototype.insertAnimationTrack=function(i){var b=this._animationTracks.get(i.animationTrackRef);var e=i.animationRef;if(!b){delete i.animationRef;b=i;this._animationTracks.set(i.animationTrackRef,b);}if(!e){return;}var l=this._animations.get(e);if(!l||!l.sequenceId){return;}if(l.animationTracks.has(b.animationTrackRef)){return;}else{l.animationTracks.add(b.animationTrackRef);}var g1=this._vkScene.getAnimationSequence(l.sequenceId);if(!g1){return;}if(!g1.userData){g1.userData={};}if(!g1.userData.tracks){g1.userData.tracks=[];}for(var ti=0;l.targetRefs&&ti<l.targetRefs.length;ti++){var i1=l.targetRefs[ti];var j1=l.targetPivots[ti];var k1=this._nodes.get(i1);if(!k1){continue;}var l1;if(j1.x!==0||j1.y!==0||j1.z!==0){l1=[j1.x,j1.y,j1.z];}var m1=["OPACITY","COLOUR","TRANSLATE","SCALE","ROTATE"][b.type]||"";T.pushElementIntoMapArray(this._trackIdSequenceNodeMap,i.animationTrackRef,{sequenceId:l.sequenceId,targetId:i1,type:m1,pivot:l1});var n1={};n1.times=Array.prototype.slice.call(b.times);n1.values=Array.prototype.slice.call(b.values);n1.id=i.animationTrackRef;n1.cyclicInfo={};n1.cyclicInfo.cyclicStart=b.cyclicStart;n1.cyclicInfo.cyclicEnd=b.cyclicEnd;var ki;if(l.type===0){if(b.dataType===0){if(b.values.length!==b.keyCount||b.times.length!==b.keyCount){continue;}if(b.type===3){n1.values=[];for(ki=0;ki<b.keyCount;ki++){n1.values.push(b.values[ki]);n1.values.push(b.values[ki]);n1.values.push(b.values[ki]);}}}else if(b.dataType===1||b.dataType===3){if(b.values.length!==3*b.keyCount||b.times.length!==b.keyCount){continue;}}else if(b.dataType===4||b.dataType===5||b.dataType===6){if(b.values.length!==4*b.keyCount||b.times.length!==b.keyCount){continue;}if(b.dataType===4){n1.rotateType="angleAxis";}else if(b.dataType===6){n1.rotateType="euler";}else{n1.rotateType="quaternion";for(var vi=3;vi<n1.values.length;vi=vi+4){n1.values[vi]=-n1.values[vi];}}}}g1.userData.tracks.push(n1);}};
S.prototype.setAnimationTracks=function(b){var e=this._animations.get(b);if(!e||!e.sequenceId){return;}var i=this._vkScene.getAnimationSequence(e.sequenceId);if(i){if(i.userData&&i.userData.tracks){this._animationHelper.insertTracks(i.userData.tracks,this._trackIdSequenceNodeMap,this._nodes,this._vkScene);}}};
S.prototype.setAnimationPlaybacks=function(i){var b=this._viewGroups.get(i.viewGroupId);for(var e=0;e<b.modelViews.length;e++){var l=b.modelViews[e];this._animationHelper.processHighlights(l,l.id,this._vkScene);}this._animationHelper.setInitialNodePositionsFromSubsequentViews(b.modelViews,this._vkScene);this._animationHelper.setInitialNodePositionsFromPreviousViews(b.modelViews,this._vkScene);this._animationHelper.setInitialNodePositionsFromCurrenetViews(b.modelViews,this._vkScene);this._animationHelper.setPlaybackStartTimes(b.modelViews,this._vkScene);};
return S;});
sap.ui.predefine('sap/ui/vk/threejs/Texture',["../Texture","./thirdparty/three"],function(T,t){"use strict";
var a=T.extend("sap.ui.vk.threejs.Texture",{
metadata:{},
constructor:function(i){if(i){var c=new THREE.TextureLoader();this._nativeTexture=c.load(i);if(!this._nativeTexture.userData){this._nativeTexture.userData={};}}}
});
var b=a.getMetadata().getParent().getClass().prototype;
a.prototype.init=function(){if(b.init){b.init.call(this);}};
a.prototype.load=function(i){var c=new THREE.TextureLoader();this._nativeTexture=c.load(i);if(!this._nativeTexture.userData){this._nativeTexture.userData={};}return this;};
a.prototype.getTextureRef=function(){return this._nativeTexture;};
a.prototype.setTextureRef=function(c){this._nativeTexture=c;if(!this._nativeTexture.userData){this._nativeTexture.userData={};}return this;};
a.prototype.getId=function(){if(this._nativeTexture&&this._nativeTexture.userData&&this._nativeTexture.userData.id){return this._nativeTexture.userData.id;}};
a.prototype.setId=function(v){if(this._nativeTexture){if(!this._nativeTexture.userData){this._nativeTexture.userData={};}this._nativeTexture.userData.id=v;}return this;};
a.prototype.getFilterMode=function(){if(this._nativeTexture){return this._nativeTexture.magFilter===THREE.NearestFilter?1:0;}};
a.prototype.setFilterMode=function(v){if(this._nativeTexture){this._nativeTexture.magFilter=v===1?THREE.NearestFilter:THREE.LinearFilter;}};
a.prototype.getUvRotationAngle=function(){if(this._nativeTexture){return this._nativeTexture.rotation;}};
a.prototype.setUvRotationAngle=function(v){if(this._nativeTexture){this._nativeTexture.rotation=v;}};
a.prototype.getUvHorizontalOffset=function(){if(this._nativeTexture){return this._nativeTexture.offset.x;}};
a.prototype.setUvHorizontalOffset=function(v){if(this._nativeTexture){this._nativeTexture.offset.x=v;}};
a.prototype.getUvVerticalOffset=function(){if(this._nativeTexture){return this._nativeTexture.offset.y;}};
a.prototype.setUvVerticalOffset=function(v){if(this._nativeTexture){this._nativeTexture.offset.y=v;}};
a.prototype.getUvHorizontalScale=function(){if(this._nativeTexture){return this._nativeTexture.repeat.x;}};
a.prototype.setUvHorizontalScale=function(v){if(this._nativeTexture){this._nativeTexture.repeat.x=v;}};
a.prototype.getUvVerticalScale=function(){if(this._nativeTexture){return this._nativeTexture.repeat.y;}};
a.prototype.setUvVerticalScale=function(v){if(this._nativeTexture){this._nativeTexture.repeat.y=v;}};
a.prototype.getUvHorizontalTilingEnabled=function(){if(this._nativeTexture){return this._nativeTexture.wrapS===THREE.RepeatWrapping;}};
a.prototype.setUvHorizontalTilingEnabled=function(v){if(this._nativeTexture){this._nativeTexture.wrapS=v?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;}};
a.prototype.getUvVerticalTilingEnabled=function(){if(this._nativeTexture){return this._nativeTexture.wrapT===THREE.RepeatWrapping;}};
a.prototype.setUvVerticalTilingEnabled=function(v){if(this._nativeTexture){this._nativeTexture.wrapT=v?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;}};
return a;});
sap.ui.predefine('sap/ui/vk/threejs/ThreeExtensions',["../abgrToColor","../ObjectType","./thirdparty/three"],function(a,O,t){"use strict";THREE.Object3D.prototype.defaultEmissive={r:0.0235,g:0.0235,b:0.0235};THREE.Object3D.prototype.defaultSpecular={r:0.0602,g:0.0602,b:0.0602};
THREE.Box3.prototype._setFromObjectExcludingHotSpotAndPMI=function(o){this.makeEmpty();var v=new THREE.Vector3();var c=this;o.updateMatrixWorld(true);o.traverse(function(n){if(n.userData.objectType===O.Hotspot||n.userData.objectType===O.PMI){return;}var i,l;var g=n.geometry;if(g!==undefined){if(g.isGeometry){var d=g.vertices;for(i=0,l=d.length;i<l;i++){v.copy(d[i]);v.applyMatrix4(n.matrixWorld);c.expandByPoint(v);}}else if(g.isBufferGeometry){var e=g.attributes.position;if(e!==undefined){for(i=0,l=e.count;i<l;i++){v.fromBufferAttribute(e,i).applyMatrix4(n.matrixWorld);c.expandByPoint(v);}}}}});return this;};
THREE.Object3D.prototype._vkCalculateObjectOrientedBoundingBox=function(){var p=this.parent,m=this.matrix.clone(),c=this.matrixAutoUpdate;this.parent=null;this.matrix.identity();this.matrixAutoUpdate=false;this.userData.boundingBox._setFromObjectExcludingHotSpotAndPMI(this);this.matrixAutoUpdate=c;this.matrix.copy(m);this.parent=p;this.updateMatrixWorld(true);};
THREE.Object3D.prototype._vkTraverseNodeGeometry=function(c){c(this);for(var i=0,l=this.children.length;i<l;i++){var d=this.children[i];if(d.geometry!==undefined&&!d.name&&d.children.length===0){c(d);}}};
THREE.Object3D.prototype._vkSetTintColor=function(c){this._vkTraverseNodeGeometry(function(n){n.userData.tintColor=c;n._vkUpdateMaterialColor();});};
THREE.Object3D.prototype._vkSetOpacity=function(o){this._vkTraverseNodeGeometry(function(n){n.userData.opacity=o;n._vkUpdateMaterialOpacity();});};
THREE.Object3D.prototype._vkUpdateMaterialColor=function(){if(!this.material||!this.material.color){return;}var u=this.userData;if(u.originalMaterial){if(u.originalMaterial.color.r===undefined){u.originalMaterial=null;}else if(u.originalMaterial.userData&&u.originalMaterial.userData.textureAdded){this.material=u.originalMaterial.clone();if(u.opacity){this.material.opacity*=u.opacity;this.material.transparent=this.material.transparent||this.material.opacity<0.99;}delete u.originalMaterial.userData.textureAdded;}else{this.material.color.copy(u.originalMaterial.color);if(this.material.emissive!==undefined){this.material.emissive.copy(u.originalMaterial.emissive);}if(this.material.specular!==undefined){this.material.specular.copy(u.originalMaterial.specular);}}}if(u.highlightColor!==undefined||u.tintColor!==undefined){if(!u.originalMaterial){u.originalMaterial=this.material;this.material=this.material.clone();}var c;if(u.tintColor!==undefined){c=a(u.tintColor);this.material.color.lerp(new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0),c.alpha);if(this.material.emissive!==undefined){if(this.material.userData.defaultHighlightingEmissive){this.material.emissive.copy(this.material.userData.defaultHighlightingEmissive);}else{this.material.emissive.copy(THREE.Object3D.prototype.defaultEmissive);}}if(this.material.specular!==undefined){if(this.material.userData.defaultHighlightingSpecular){this.material.specular.copy(this.material.userData.defaultHighlightingSpecular);}else{this.material.specular.copy(THREE.Object3D.prototype.defaultSpecular);}}}if(u.highlightColor!==undefined){c=a(u.highlightColor);this.material.color.lerp(new THREE.Color(c.red/255.0,c.green/255.0,c.blue/255.0),c.alpha);if(this.material.emissive!==undefined){if(this.material.userData.defaultHighlightingEmissive){this.material.emissive.copy(this.material.userData.defaultHighlightingEmissive);}else{this.material.emissive.copy(THREE.Object3D.prototype.defaultEmissive);}}if(this.material.specular!==undefined){if(this.material.userData.defaultHighlightingSpecular){this.material.specular.copy(this.material.userData.defaultHighlightingSpecular);}else{this.material.specular.copy(THREE.Object3D.prototype.defaultSpecular);}}}}};
THREE.Object3D.prototype._vkUpdateMaterialOpacity=function(){if(!this.material){return;}var u=this.userData;if(u.originalMaterial){this.material.opacity=u.originalMaterial.opacity;this.material.transparent=u.originalMaterial.transparent;}if(u.opacity!==undefined){if(!u.originalMaterial){u.originalMaterial=this.material;this.material=this.material.clone();}if(this.material.opacity){this.material.opacity*=u.opacity;this.material.transparent=this.material.transparent||this.material.opacity<0.99;}}};
THREE.Object3D.prototype._vkTraverseMeshNodes=function(c){if(this._vkUpdate!==undefined||this.isDetailView){return;}c(this);var d=this.children;for(var i=0,l=d.length;i<l;i++){d[i]._vkTraverseMeshNodes(c);}};
function b(c,d){var e=c.min,f=c.max,m=d.elements,g=(e.x+f.x)*0.5,h=(e.y+f.y)*0.5,i=(e.z+f.z)*0.5,j=f.x-g,k=f.y-h,l=f.z-i;var n=m[0]*g+m[4]*h+m[8]*i+m[12];var o=m[1]*g+m[5]*h+m[9]*i+m[13];var p=m[2]*g+m[6]*h+m[10]*i+m[14];var q=Math.abs(m[0]*j)+Math.abs(m[4]*k)+Math.abs(m[8]*l);var r=Math.abs(m[1]*j)+Math.abs(m[5]*k)+Math.abs(m[9]*l);var s=Math.abs(m[2]*j)+Math.abs(m[6]*k)+Math.abs(m[10]*l);e.set(n-q,o-r,p-s);f.set(n+q,o+r,p+s);}
THREE.Object3D.prototype._expandBoundingBox=function(c,v,d){var n=new THREE.Box3();function e(g){var h=g.geometry;if(h!==undefined){if(!h.boundingBox){h.computeBoundingBox();}if(!h.boundingBox.isEmpty()){n.copy(h.boundingBox);b(n,g.matrixWorld);if(isFinite(n.min.x)&&isFinite(n.min.y)&&isFinite(n.min.z)&&isFinite(n.max.x)&&isFinite(n.max.y)&&isFinite(n.max.z)){c.min.min(n.min);c.max.max(n.max);}}}var s=g.userData.boundingBox;if(s!==undefined&&!s.isEmpty()&&!v){n.copy(s);b(n,g.matrixWorld);c.min.min(n.min);c.max.max(n.max);}}function f(g){if((v&&g.visible===false)||(d&&g._vkUpdate!==undefined)){return;}e(g);var h=g.children;for(var i=0,l=h.length;i<l;i++){f(h[i]);}}this.updateMatrixWorld();f(this);return c;};
THREE.Object3D.prototype._vkPersistentId=function(){var o=this;do{if(o.userData.treeNode&&o.userData.treeNode.sid){return o.userData.treeNode.sid;}o=o.parent;}while(o);return null;};
});
sap.ui.predefine('sap/ui/vk/threejs/Thrustline',["jquery.sap.global","./thirdparty/three","sap/ui/base/ManagedObject","./PolylineGeometry","./PolylineMaterial","./PolylineMesh","../LeaderLineMarkStyle"],function(q,t,B,P,a,b,L){"use strict";
var T=B.extend("sap.ui.vk.threejs.Thrustline",{metadata:{properties:{node:{type:"object"},renderOrder:{type:"int",defaultValue:0},depthTest:{type:"boolean",defaultValue:true},principleAxis:{type:"object",defaultValue:new THREE.Vector3(0,0,0)},material:{type:"object"},items:{type:"object[]"},segments:{type:"object[]"}}}});
T.prototype.init=function(){if(B.prototype.init){B.prototype.init.call(this);}this._needUpdateMeshes=false;};
T.prototype.setNode=function(n){if(n instanceof THREE.Object3D){this.setProperty("node",n,true);this._needUpdateMeshes=true;}return this;};
T.prototype.setRenderOrder=function(h){this.setProperty("renderOrder",h,true);this._needUpdateMeshes=true;return this;};
T.prototype.setDepthTest=function(h){this.setProperty("depthTest",h,true);this._needUpdateMeshes=true;return this;};
T.prototype.setMaterial=function(h){if(h instanceof THREE.Material){this.setProperty("material",h,true);this._needUpdateMeshes=true;}return this;};
T.prototype.setItems=function(h){this.setProperty("items",h,true);this._needUpdateMeshes=true;return this;};
T.prototype.setSegments=function(h){this.setProperty("segments",h,true);this._needUpdateMeshes=true;return this;};
T.prototype._updateMeshes=function(v){var n=this.getNode();var h=this.getMaterial();var j=this.getDepthTest();var r=this.getRenderOrder();var k=h&&h.userData.lineStyle?h.userData.lineStyle:{};var o=k.width;var p=k.dashPatternScale;if(k.widthCoordinateSpace===3){o=o?o*v.y:1;p=p?p*v.y:1;}o=o||1;k.haloWidth=k.haloWidth||0;k.endCapStyle=k.endCapStyle||0;this.getSegments().forEach(function(s){if(s.polylineMesh){n.remove(s.polylineMesh);s.polylineMesh=null;}if(s.haloMesh){n.remove(s.haloMesh);s.haloMesh=null;}var u=[];for(var i=0,l=s.ratios.length;i<l;i++){u.push(new THREE.Vector3());}var w=new P();w.setVertices(u);var x=k.endCapStyle||u.length>2?1:0;var y=(x&&k.endCapStyle===0?1:0)|(x&&k.endCapStyle===0?2:0);if(k.haloWidth>0){var z=new a({color:0xFFFFFF,lineColor:0xFFFFFF,linewidth:o*(k.haloWidth*2+1),dashCapStyle:k.endCapStyle,segmentCapStyle:x,trimStyle:y,transparent:true,depthTest:j});var A=new b(w,z);A.matrixAutoUpdate=false;A.renderOrder=r;s.haloMesh=A;n.add(A);}var C=new a({color:0xFFFFFF,lineColor:h.color,linewidth:o,dashCapStyle:k.endCapStyle,segmentCapStyle:x,trimStyle:y,dashPattern:k.dashPattern||[],dashScale:p||1,transparent:true,depthTest:j,polygonOffset:true,polygonOffsetFactor:-4});var D=new b(w,C);D.matrixAutoUpdate=false;D.renderOrder=r;s.polylineMesh=D;n.add(D);});};
var v=new THREE.Vector2(),m=new THREE.Matrix4(),c=new THREE.Matrix4(),d=new THREE.Vector3(),e=new THREE.Vector3(),f=new THREE.Vector3(),g=new THREE.Vector3();
T.prototype._update=function(r,h){var n=this.getNode();if(!n||!n.visible){return;}var j=r.getSize();v.set(j.width,j.height);if(this._needUpdateMeshes){this._needUpdateMeshes=false;this._updateMeshes(v);}m.multiplyMatrices(h.projectionMatrix,h.matrixWorldInverse);c.copy(m);var k=h instanceof THREE.PerspectiveCamera?h.near:undefined;var o=this.getItems();d.copy(this.getPrincipleAxis()).normalize();this.getSegments().forEach(function(s){var p=s.polylineMesh;if(p){var u=p.geometry;var w=o[s.startItemIndex];var x=new THREE.Vector3().copy(w.boundPoints[s.startBoundIndex]).applyMatrix4(w.target.matrixWorld);var y=o[s.endItemIndex];var z=new THREE.Vector3().copy(y.boundPoints[s.endBoundIndex]).applyMatrix4(y.target.matrixWorld);e.copy(z).sub(x);f.copy(d).multiplyScalar(e.dot(d));g.copy(e).sub(f);var A=u.vertices;var C=[];for(var i=0,l=s.ratios.length;i<l;i++){C.push(i);var D=s.ratios[i];var E=A[i];E.copy(x);e.copy(f).multiplyScalar(D.x);E.add(e);e.copy(g).multiplyScalar(D.y);E.add(e);}u._updateVertices(C);p.material.resolution.copy(v);p.computeLineDistances(c,v,k);}var F=s.haloMesh;if(F){F.material.resolution.copy(v);F.computeLineDistances(c,v,k);}});};
return T;});
sap.ui.predefine('sap/ui/vk/threejs/ViewStateManager',["sap/ui/core/Element","../ContentConnector","../ViewStateManagerBase","./thirdparty/three","../cssColorToColor","../colorToCSSColor","../abgrToColor","../colorToABGR","./Scene","./ThreeExtensions","../ObjectType"],function(E,C,V,t,c,a,b,d,S,T,O){"use strict";var e;
var f=V.extend("sap.ui.vk.threejs.ViewStateManager",{metadata:{}});
var g=f.getMetadata().getParent().getClass().prototype;
f.prototype.init=function(){if(g.init){g.init.call(this);}this._nodeHierarchy=null;this._nodeStates=new Map();this._selectedNodes=new Set();this._visibilityTracker=new e();this._showSelectionBoundingBox=true;this._boundingBoxesScene=new THREE.Scene();this._selectionColor=new THREE.Color(0xC0C000);this.setHighlightColor("rgba(255, 0, 0, 1.0)");};
f.prototype._setContent=function(h){var s=null;if(h&&h instanceof S){s=h;}this._setScene(s);};
f.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
f.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};
f.prototype._handleContentReplaced=function(h){var i=h.getParameter("newContent");this._setContent(i);};
f.prototype._setScene=function(s){this._boundingBoxesScene=new THREE.Scene();this._setNodeHierarchy(s?s.getDefaultNodeHierarchy():null);if(s){s.setViewStateManager(this);}return this;};
f.prototype._setNodeHierarchy=function(n){var o=this._nodeHierarchy;if(this._nodeHierarchy){this._nodeHierarchy=null;this._nodeStates.clear();this._selectedNodes.clear();this._visibilityTracker.clear();}if(n){this._nodeHierarchy=n;this._nodeHierarchy.attachNodeReplaced(this._handleNodeReplaced,this);this._nodeHierarchy.attachNodeUpdated(this._handleNodeUpdated,this);this._initialState={visible:[],hidden:[]};var h=this;var i=n.findNodesByName();i.forEach(function(j){(j.visible?h._initialState.visible:h._initialState.hidden).push(j);});this.fireVisibilityChanged({visible:this._initialState.visible,hidden:this._initialState.hidden});}if(n!==o){this.fireNodeHierarchyReplaced({oldNodeHierarchy:o,newNodeHierarchy:n});}return this;};
f.prototype._handleNodeReplaced=function(h){var r=h.getParameter("ReplacedNodeRef");var i=h.getParameter("ReplacementNodeRef");if(this.getSelectionState(r)){this.setSelectionState(i,true);this.setSelectionState(r,false);}};
f.prototype._handleNodeUpdated=function(h){var n=h.getParameter("nodeRef");if(this.getSelectionState(n)){this.setSelectionState(n,false);this.setSelectionState(n,true);}};
f.prototype.getNodeHierarchy=function(){return this._nodeHierarchy;};
f.prototype.getVisibilityChanges=function(){return this.getShouldTrackVisibilityChanges()?this._visibilityTracker.getInfo(this.getNodeHierarchy()):null;};
f.prototype.getVisibilityComplete=function(){var n=this.getNodeHierarchy(),h=n.findNodesByName(),v=[],i=[];h.forEach(function(j){var k=n.createNodeProxy(j);var l=k.getVeId();n.destroyNodeProxy(k);if(l){if(this.getVisibilityState(j)){v.push(l);}else{i.push(l);}}},this);return{visible:v,hidden:i};};
f.prototype.resetVisibility=function(){this.setVisibilityState(this._initialState.visible,true,false);this.setVisibilityState(this._initialState.hidden,false,false);this._visibilityTracker.clear();};
f.prototype.getVisibilityState=function(n){return Array.isArray(n)?n.map(function(h){return h.visible;}):n.visible;};
f.prototype.setVisibilityState=function(n,v,r){if(!Array.isArray(n)){n=[n];}n=(r?this._collectNodesRecursively(n):n).filter(function(i,j,s){return s.indexOf(i)===j;});var h=n.filter(function(i){return i?i.visible!=v:false;},this);if(h.length>0){h.forEach(function(i){i.visible=v;if(v){var j=this._nodeHierarchy.getAncestors(i);this.setVisibilityState(j,true,false);}},this);if(this.getShouldTrackVisibilityChanges()){h.forEach(this._visibilityTracker.trackNodeRef,this._visibilityTracker);}this.fireVisibilityChanged({visible:v?h:[],hidden:v?[]:h});}return this;};
f.prototype.enumerateSelection=function(h){this._selectedNodes.forEach(h);return this;};
f.prototype.getSelectionState=function(n){var s=this._selectedNodes;function i(h){return s.has(h);}return Array.isArray(n)?n.map(i):i(n);};
f.prototype._isAChild=function(h,n){var i=h.parent;while(i){if(n.has(i)){return true;}i=i.parent;}return false;};
f.prototype._AddBoundingBox=function(n){if(n.userData.boundingBox===undefined){n.userData.boundingBox=new THREE.Box3();n._vkCalculateObjectOrientedBoundingBox();}if(!n.userData.boundingBox.isEmpty()&&this._boundingBoxesScene&&n.userData.boxHelper===undefined){var h=new THREE.Box3Helper(n.userData.boundingBox,0xffff00);h.material.color=this._selectionColor;this._boundingBoxesScene.add(h);h.parent=n;n.userData.boxHelper=h;}};
f.prototype._RemoveBoundingBox=function(n){if(n.userData.boundingBox!==undefined){delete n.userData.boundingBox;}if(n.userData.boxHelper!==undefined){this._boundingBoxesScene.remove(n.userData.boxHelper);delete n.userData.boxHelper;}};
f.prototype._updateBoundingBoxesIfNeeded=function(){var u=new Set();this._selectedNodes.forEach(function(n){var p=n.parent;while(p){if(this._selectedNodes.has(p)){u.add(p);}p=p.parent;}}.bind(this));u.forEach(function(n){n._vkCalculateObjectOrientedBoundingBox();});};
f.prototype._updateBoundingBoxes=function(){this._selectedNodes.forEach(function(n){if(n.userData.boundingBox){n._vkCalculateObjectOrientedBoundingBox();}});};
f.prototype.setShowSelectionBoundingBox=function(v){this._showSelectionBoundingBox=v;if(this._showSelectionBoundingBox){this._selectedNodes.forEach(function(n){this._AddBoundingBox(n);}.bind(this));}else{this._selectedNodes.forEach(function(n){this._RemoveBoundingBox(n);}.bind(this));}this.fireSelectionChanged({selected:this._selectedNodes,unselected:[]});};
f.prototype.getShowSelectionBoundingBox=function(){return this._showSelectionBoundingBox;};
f.prototype._isAncestorSelected=function(n){n=n.parent;while(n){if(this._selectedNodes.has(n)){return true;}n=n.parent;}return false;};
f.prototype._updateHighlightColor=function(n,p){var s=p||this._selectedNodes.has(n);n.userData.highlightColor=s?this._highlightColorABGR:undefined;n._vkUpdateMaterialColor();var h=n.children;for(var i=0,l=h.length;i<l;i++){var u=h[i].userData;if(u&&u.objectType===O.Hotspot){continue;}this._updateHighlightColor(h[i],s);}};
f.prototype.setSelectionState=function(n,s,r,h){if(!Array.isArray(n)){n=[n];}n=(r||this.getRecursiveSelection()?this._collectNodesRecursively(n):n).filter(function(v,j,k){return k.indexOf(v)===j;});if(this.getRecursiveSelection()&&!s){n=this._nodeHierarchy._appendAncestors(n);}var i=n.filter(function(j){return this._selectedNodes.has(j)!==s;},this);if(i.length>0){i.forEach(function(j){if(j){this._selectedNodes[s?"add":"delete"](j);if(this._showSelectionBoundingBox){this[s?"_AddBoundingBox":"_RemoveBoundingBox"](j);}}},this);i.forEach(function(j){if(j){this._updateHighlightColor(j,s||this._isAncestorSelected(j));}},this);if(!h){this.fireSelectionChanged({selected:s?i:[],unselected:s?[]:i});}}return this;};
f.prototype.setSelectionStates=function(s,u,r,h){if(!Array.isArray(s)){s=[s];}if(!Array.isArray(u)){u=[u];}s=(r||this.getRecursiveSelection()?this._collectNodesRecursively(s):s);u=(r||this.getRecursiveSelection()?this._collectNodesRecursively(u):u);if(this.getRecursiveSelection()){u=this._nodeHierarchy._appendAncestors(u,s);}var i=s.filter(function(n){return this._selectedNodes.has(n)===false;},this);var j=u.filter(function(n){return this._selectedNodes.has(n)===true;},this);if(i.length>0||j.length>0){i.forEach(function(n){this._selectedNodes.add(n);this._updateHighlightColor(n,true);if(this._showSelectionBoundingBox){this._AddBoundingBox(n);}},this);j.forEach(function(n){this._selectedNodes.delete(n);if(this._showSelectionBoundingBox){this._RemoveBoundingBox(n);}},this);j.forEach(function(n){this._updateHighlightColor(n,this._isAncestorSelected(n));},this);if(!h){this.fireSelectionChanged({selected:i,unselected:j});}}return this;};
f.prototype._collectNodesRecursively=function(n){var r=[],h=this;n.forEach(function collectChildNodes(i){r.push(i);h._nodeHierarchy.enumerateChildren(i,collectChildNodes,false,true);});return r;};
f.prototype._getOpacity=function(n){return n.userData.opacity!==undefined?n.userData.opacity:null;};
f.prototype.getOpacity=function(n){if(Array.isArray(n)){return n.map(this._getOpacity,this);}else{return this._getOpacity(n);}};
f.prototype.setOpacity=function(n,o,r){if(!Array.isArray(n)){n=[n];}n=(r?this._collectNodesRecursively(n):n).filter(function(v,i,s){return s.indexOf(v)===i;});if(o===null){o=undefined;}var h=n.filter(function(i){return i.userData.opacity!==o;},this);if(h.length>0){h.forEach(function(i){i._vkSetOpacity(o);},this);this.fireOpacityChanged({changed:h,opacity:o});}return this;};
f.prototype._getTintColorABGR=function(n){return n.userData.tintColor!==undefined?n.userData.tintColor:null;};
f.prototype._getTintColor=function(n){return n.userData.tintColor!==undefined?a(b(n.userData.tintColor)):null;};
f.prototype.getTintColor=function(n,i){var h=i?"_getTintColorABGR":"_getTintColor";if(Array.isArray(n)){return n.map(this[h],this);}else{return this[h](n);}};
f.prototype.setTintColor=function(n,h,r){if(!Array.isArray(n)){n=[n];}var i=null;switch(typeof h){case"number":i=h;break;case"string":if(sap.ui.core.CSSColor.isValid(h)){i=d(c(h));}break;default:h=null;break;}n=(r?this._collectNodesRecursively(n):n).filter(function(v,k,s){return s.indexOf(v)===k;});var j=n.filter(function(k){return k.userData.tintColor!==i;},this);if(j.length>0){j.forEach(function(k){k._vkSetTintColor(i);},this);this.fireTintColorChanged({changed:j,tintColor:h,tintColorABGR:i});}return this;};
f.prototype.setHighlightColor=function(h){switch(typeof h){case"number":this._highlightColorABGR=h;break;case"string":if(sap.ui.core.CSSColor.isValid(h)){this._highlightColorABGR=d(c(h));}break;default:return this;}if(this._selectedNodes.size>0){this._selectedNodes.forEach(function(n){this._updateHighlightColor(n,true);},this);}this.fireHighlightColorChanged({highlightColor:a(b(this._highlightColorABGR)),highlightColorABGR:this._highlightColorABGR});return this;};
f.prototype.getHighlightColor=function(i){return i?this._highlightColorABGR:a(b(this._highlightColorABGR));};
e=function(){this._visibilityChanges=new Set();};
e.prototype.getInfo=function(n){var h=[];this._visibilityChanges.forEach(function(i){var j=n.createNodeProxy(i);var v=j.getVeId();n.destroyNodeProxy(j);if(v){h.push(v);}else{h.push(n.getScene().nodeRefToPersistentId(i));}});return h;};
e.prototype.clear=function(){this._visibilityChanges.clear();};
e.prototype.trackNodeRef=function(n){if(this._visibilityChanges.has(n)){this._visibilityChanges.delete(n);}else{this._visibilityChanges.add(n);}};
C.injectMethodsIntoClass(f);return f;});
sap.ui.predefine('sap/ui/vk/threejs/Viewport',["jquery.sap.global","../ViewportBase","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","../Loco","./thirdparty/three","../ContentConnector","../ViewStateManager","./ViewportGestureHandler","./OrthographicCamera","./PerspectiveCamera","./NodesTransitionHelper","../Messages","sap/ui/base/ManagedObjectObserver","./ViewportRenderer","../CameraProjectionType","../CameraFOVBindingType","../VisibilityMode","../ZoomTo","../SelectionMode","../RenderMode","../getResourceBundle","../cssColorToColor","../ViewStateManager","./ViewStateManager","./Scene","./ContentDeliveryService","./AnimationTimeController","./AnimationHelper","../AnimationTrackType"],function(Q,V,R,K,L,c,C,d,f,O,P,N,M,g,k,l,n,o,Z,S,r,u,v,z,T,A,B,D,E,F){"use strict";
var G=V.extend("sap.ui.vk.threejs.Viewport",{metadata:{library:"sap.ui.vk",events:{cameraChanged:{parameters:{position:"float[]",quaternion:"float[]",zoom:"float"},enableEventBubbling:true},frameRenderingFinished:{}}}});
var H=G.getMetadata().getParent().getClass().prototype;THREE.PropertyBinding.prototype.GetterByBindingType[0]=function(b,a){b[a]=this.targetObject[this.propertyName];};
THREE.AnimationMixer.prototype.updateWithoutMixing=function(a){a*=this.timeScale;var b=this._actions,e=this._nActiveActions,t=this.time+=a,h=Math.sign(a),p=this._accuIndex^=1;var q=this._bindings,s=this._nActiveBindings;var i;for(i=0;i!==s;++i){q[i].realCumulativeWeight=0;}for(i=0;i!==e;++i){var w=b[i];var x=w._propertyBindings;var j,m;if(x){for(j=0,m=x.length;j!==m;++j){x[j].cumulativeWeight=0;}}w._update(t,a,h,p);if(x){for(j=0,m=x.length;j!==m;++j){x[j].realCumulativeWeight+=x[j].cumulativeWeight;}}}for(i=0;i!==s;++i){if(q[i].realCumulativeWeight){q[i].cumulativeWeight=1;}q[i].apply(p);}return this;};
G.prototype.init=function(){if(H.init){H.init.call(this);}this._resizeListenerId=null;this._renderLoopRequestId=0;this._renderLoopFunction=this._renderLoop.bind(this);this._shouldRenderFrame=true;this._clippingPlanes=[];this._animationMixer=null;this._renderer=new THREE.WebGLRenderer({antialias:true,alpha:true});this._renderer.setPixelRatio(window.devicePixelRatio);this._renderer.setSize(1,1);this._renderer.shadowMap.enabled=true;this._camera=new P();var b=["varying float vPos;","void main() {","	gl_Position = vec4(position, 1.0);","	vPos = position.y * -0.5 + 0.5;","}"].join("\n");var a=["uniform vec4 topColor;","uniform vec4 bottomColor;","varying float vPos;","void main() {","	gl_FragColor = mix(topColor, bottomColor, vPos);","}"].join("\n");var e=new THREE.Vector4();var h=new THREE.Vector4();this._updateColor(e,this.getBackgroundColorTop());this._updateColor(h,this.getBackgroundColorBottom());this._checkBackgroundColor();this._backgroundMaterial=new THREE.ShaderMaterial({uniforms:{topColor:{value:e},bottomColor:{value:h}},vertexShader:b,fragmentShader:a,side:THREE.DoubleSide,depthTest:false,depthWrite:false,blending:THREE.NoBlending});var i=new THREE.Geometry();i.vertices.push(new THREE.Vector3(-1,1,0),new THREE.Vector3(1,1,0),new THREE.Vector3(-1,-1,0),new THREE.Vector3(1,-1,0));i.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));this._backgroundCamera=new THREE.Camera();this._backgroundScene=new THREE.Scene();this._backgroundScene.add(new THREE.Mesh(i,this._backgroundMaterial));var x=["#include <clipping_planes_pars_vertex>","varying vec3 vNormal;","void main() {","#include <begin_vertex>","#include <project_vertex>","#include <clipping_planes_vertex>","#include <beginnormal_vertex>","#include <defaultnormal_vertex>","	vNormal = normalize( transformedNormal );","}"].join("\n");var j=["#include <clipping_planes_pars_fragment>","uniform vec4 color1;","uniform vec4 color2;","varying vec3 vNormal;","void main() {","#include <clipping_planes_fragment>","	gl_FragColor = mix(color1, color2, abs(normalize(vNormal).z));","}"].join("\n");this._xrayColor1=new THREE.Vector4(0,0.75,1,0.45);this._xrayColor2=new THREE.Vector4(0,0,1,0);this._xrayMaterial=new THREE.ShaderMaterial({uniforms:{color1:{value:this._xrayColor1},color2:{value:this._xrayColor2}},vertexShader:x,fragmentShader:j,side:THREE.DoubleSide,depthWrite:false,depthFunc:THREE.LessDepth,blending:THREE.NormalBlending,clipping:true,transparent:true});this._viewportGestureHandler=new f(this);this._loco=new L(this);this._loco.addHandler(this._viewportGestureHandler,-1);this._zoomedObject=null;this._nodesTransitionHelper=new N();this._nodesTransitionHelper.setViewport(this);this._cdsLoader=null;this._animationTimeController=new D();this._animationHelper=new E();this.attachCameraChanged(function(m){this.setShouldRenderFrame();});this._sceneObserver=new g(this.setShouldRenderFrame.bind(this));this._currentViews=null;this._currentViewIndex=0;this._currentView=null;this._playingProcedure=false;this._playingPlaybacks=false;this._totalTimeOfPlaybacks=0;this._startTimeOfPlaybacks=0;this._notPlayingAnimations=false;this._currentAnimationActions=[];};
G.prototype.cameraUpdateCompleted=function(p){var a=function(b){var e;if(b._currentView){e=b._currentView.getPlaybacks();}if(e&&e.length&&!b._notPlayingAnimations){b._startAnimation();}else if(!e||b._notPlayingAnimations){b.fireViewFinished({viewIndex:this._currentViewIndex});b._playNextStep();}else{b._playNextStep();}};if(this._playingPlaybacks){setTimeout(a,10,this);}else{this.fireViewFinished({viewIndex:this._currentViewIndex});}this._playingPlaybacks=false;};
G.prototype.exit=function(){this._loco.removeHandler(this._viewportGestureHandler);this._viewportGestureHandler.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();this.setScene(null);this.setCamera(null);this._renderer=null;this._backgroundCamera=null;this._backgroundMaterial=null;this._backgroundScene=null;this._loco=null;this._viewportGestureHandler=null;if(this._cdsLoader){this._cdsLoader.detachSceneUpdated(this._handleCdsSceneUpdate,this);}if(H.exit){H.exit.call(this);}};
G.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};
G.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=0;}return this;};
G.prototype.setBackgroundColorTop=function(a){H.setBackgroundColorTop.call(this,a);if(this._backgroundMaterial!==null){this._updateColor(this._backgroundMaterial.uniforms.topColor.value,a);this._checkBackgroundColor();}return this;};
G.prototype.pauseAnimation=function(){this._animationTimeController.pause();this.setShouldRenderFrame();};
G.prototype.resumeAnimation=function(){this._animationTimeController.resume();this.setShouldRenderFrame();};
G.prototype.handleDragAnimation=function(e){var p=e.getParameter("value");if(this._animationTimeController.isAnimationStopped()||!this._animationMixer){if(!this._startAnimation(true)){return;}}this._animationTimeController.drag(p);this.setShouldRenderFrame();};
G.prototype.handleCompleteDraggingAnimation=function(e){var p=e.getParameter("value");if(!this._animationTimeController.isAnimationStopped()){this._animationTimeController.completeDragging(p);}this.setShouldRenderFrame();};
G.prototype.handleKeyFrameAdded=function(e){var a=e.getParameters();if(a.trackType===F.rotate){a.targetNodeRef.quaternion.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2],a.keyFrameValue[3]);}else if(a.trackType===F.translate){a.targetNodeRef.position.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}else if(a.trackType===F.scale){a.targetNodeRef.scale.set(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}else if(a.trackType===F.opacity){a.targetNodeRef.traverse(function(b){if(b.material&&b.material.opacity){b.userData.opacity=a.keyFrameValue[0];b._vkUpdateMaterialOpacity();}});}else if(a.trackType===F.color){a.targetNodeRef.traverse(function(b){if(b.material&&b.material.color){b.material.color.setRGB(a.keyFrameValue[0],a.keyFrameValue[1],a.keyFrameValue[2]);}});}this.setShouldRenderFrame();};
G.prototype.handleKeyFrameUpdated=function(e){this.handleKeyFrameAdded(e);this.setShouldRenderFrame();};
G.prototype.handleKeyFrameDeleted=function(e){var a=e.getParameters();var b=this._scene.getAnimationSequence(a.sequenceId);if(!b){return;}var h=b.getNearestKeyFrame(a.targetNodeRef,a.trackType,a.keyFrameTime);if(h){if(a.trackType===F.rotate){var i=b.getRotateKeyFrameInQuaternion(a.targetNodeRef,h.index);if(i){a.targetNodeRef.quaternion.set(i[0],i[1],i[2],i[3]);}}else if(a.trackType===F.translate){a.targetNodeRef.position.set(h.value[0],h.value[1],h.value[2]);}else if(a.trackType===F.scale){a.targetNodeRef.scale.set(h.value[0],h.value[1],h.value[2]);}else if(a.trackType===F.opacity){a.targetNodeRef.traverse(function(m){if(m.material&&m.material.opacity){m.userData.opacity=h.value[0];m._vkUpdateMaterialOpacity();}});}else if(a.trackType===F.color){a.targetNodeRef.traverse(function(m){if(m.material&&m.material.color){m.material.color.setRGB(h.value[0],h.value[1],h.value[2]);}});}}else{var j;if(a.trackType===F.rotate||a.trackType===F.translate||a.trackType===F.scale){j=this._animationHelper.getNodePositionFromNearestPlayback(this._scene,this._currentView,a.sequenceId,a.targetNodeRef);if(!j){j=this._animationHelper.getNodePositionByView(this._currentView,a.targetNodeRef);}}if(j){if(a.trackType===F.rotate){a.targetNodeRef.quaternion.copy(j.quaternion);var q=[j.quaternion.x,j.quaternion.y,j.quaternion.z,j.quaternion.w];b.resetOriginalPosition(a.targetNodeRef,q,null,null);}else if(a.trackType===F.translate){a.targetNodeRef.position.copy(j.position);var p=[j.position.x,j.position.y,j.position.z];b.resetOriginalPosition(a.targetNodeRef,null,p,null);}else if(a.trackType===F.scale){a.targetNodeRef.scale.copy(j.scale);var s=[j.scale.x,j.scale.y,j.scale.z];b.resetOriginalPosition(a.targetNodeRef,null,null,s);}}}this.setShouldRenderFrame();};
G.prototype.AddHandlersToAnimationSequenceEvents=function(a){a.detachKeyFrameAdded(this.handleKeyFrameAdded,this);a.detachKeyFrameUpdated(this.handleKeyFrameUpdated,this);a.detachKeyFrameDeleted(this.handleKeyFrameDeleted,this);a.attachKeyFrameAdded(this.handleKeyFrameAdded,this);a.attachKeyFrameUpdated(this.handleKeyFrameUpdated,this);a.attachKeyFrameDeleted(this.handleKeyFrameDeleted,this);};
G.prototype.setBackgroundColorBottom=function(a){H.setBackgroundColorBottom.call(this,a);if(this._backgroundMaterial!==null){this._updateColor(this._backgroundMaterial.uniforms.bottomColor.value,a);this._checkBackgroundColor();}return this;};
G.prototype.setClippingPlanes=function(a){this._clippingPlanes=a;return this;};
G.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._stopRenderLoop();};
G.prototype.onAfterRendering=function(){var a=this.getDomRef();a.appendChild(this._renderer.domElement);this._resizeListenerId=R.register(this,this._handleResize.bind(this));this._handleResize({size:{width:a.clientWidth,height:a.clientHeight}});this._startRenderLoop();};
G.prototype._handleResize=function(e){if(!this._camera||!this._renderer){return false;}var w=e.size.width;var h=e.size.height;if(this._camera){this._camera.update(w,h);}this._renderer.setSize(w,h);this.fireResize({size:{width:w,height:h}});this.setShouldRenderFrame();return true;};
G.prototype.setScene=function(s){this._scene=s;this._homeCamera=null;this._sceneObserver.disconnect();var a=this._scene?this._scene.getSceneRef():undefined;if(a){this._sceneObserver.observe(this._scene,{properties:["doubleSided"]});var b;for(var i=0;i<a.children.length;i++){b=a.children[i];if(b.private&&b.name==="DefaultLights"&&b.children.length){if(b.children[0]instanceof THREE.PointLight){this._eyePointLight=b.children[0];}}}}this._animationTimeController.reset();this.fireAnimationUpdated({value:0});this.setShouldRenderFrame();return this;};
G.prototype.getScene=function(){return this._scene;};
G.prototype.setCamera=function(a){if(H.setCamera){H.setCamera.call(this,a);}var b=this.getCamera();if(b&&this._renderer){var s=this._renderer.getSize();b.update(s.width,s.height);if(!this._homeCamera&&b.getCameraRef()){this._homeCamera=b.getCameraRef().clone();}}this.setShouldRenderFrame();return this;};
G.prototype.getRenderer=function(){return this._renderer;};
G.prototype._getViewStateManagerThreeJS=function(){if(this._viewStateManager){if(this._viewStateManager instanceof T){return this._viewStateManager;}if(this._viewStateManager instanceof z&&this._viewStateManager._implementation instanceof T){return this._viewStateManager._implementation;}}return null;};
G.prototype._updateBoundingBoxesIfNeeded=function(){var a=this._getViewStateManagerThreeJS();if(a){a._updateBoundingBoxesIfNeeded();}};
G.prototype._updateColor=function(a,b){var e=v(b);a.color=new THREE.Color(e.red/255,e.green/255,e.blue/255);a.alpha=e.alpha;a.x=a.color.r*a.alpha;a.y=a.color.g*a.alpha;a.z=a.color.b*a.alpha;a.w=a.alpha;};
G.prototype._checkBackgroundColor=function(){var a=this.getBackgroundColorTop();if(a===this.getBackgroundColorBottom()){if(this._backgroundColor===null){this._backgroundColor=new THREE.Vector4();}this._updateColor(this._backgroundColor,a);}else{this._backgroundColor=null;}this.setShouldRenderFrame();};
G.prototype._handleCdsSceneUpdate=function(){this.setShouldRenderFrame();};
G.prototype.setShouldRenderFrame=function(){this._shouldRenderFrame=true;return this;};
G.prototype.shouldRenderFrame=function(){return this._shouldRenderFrame;};
G.prototype.setRenderMode=function(a){this.setProperty("renderMode",a,true);if(this._scene){switch(a){case r.LineIllustration:case r.ShadedIllustration:case r.SolidOutline:this._scene._createOutlineGeometry(a);break;default:this._scene._hideOutlineGeometry();break;}}this.setShouldRenderFrame();return this;};
G.prototype.hitTest=function(x,y){var a=this._scene?this._scene.getSceneRef():undefined;var b=this._camera?this._camera.getCameraRef():undefined;if(!b||!a){return null;}var e=this._renderer.domElement;var m=new THREE.Vector2((x-e.clientLeft)/e.clientWidth*2-1,(e.clientTop-y)/e.clientHeight*2+1);var h=new THREE.Raycaster();h.setFromCamera(m,b);if(this._clippingPlanes){for(var p in this._clippingPlanes){var j=this._clippingPlanes[p];var q=j.distanceToPoint(h.ray.origin),t=-q/j.normal.dot(h.ray.direction);if(t>0){if(q<0){h.near=Math.max(h.near,t);}else{h.far=Math.min(h.far,t);}}else if(q<0){return null;}}}var s=h.intersectObjects(a.children,true);if(s){for(var i in s){var w=s[i];var X=w.object;var Y=X.parent;while(Y){if(Y.userData.closed){X=Y;}Y=Y.parent;}while(X.parent&&((X.userData.treeNode&&X.userData.treeNode.skipIt)||(!X.name&&X.children.length===0))){X=X.parent;}if(!X.isBillboard&&!X.isDetailView){w.object=X;return w;}}}return null;};
G.prototype.tap=function(x,y,i){if(!i){if(this._viewStateManager){var h=this.hitTest(x,y);var a=h&&h.object;var p={picked:a?[a]:[]};this.fireNodesPicked(p);if(this.getSelectionMode()===S.Exclusive){this.exclusiveSelectionHandler(p.picked);}else if(this.getSelectionMode()===S.Sticky){this.stickySelectionHandler(p.picked);}if(a!==null){this.fireNodeClicked({nodeRef:a,x:x,y:y},true,true);}}}else if(!this.getFreezeCamera()){var b=this.hitTest(x,y);if(b&&(this._zoomedObject===null||this._zoomedObject!==b.object)){this._zoomedObject=b.object;this._viewportGestureHandler.zoomObject(this._zoomedObject,true);}else{this._viewportGestureHandler.zoomObject(this._zoomedObject,false);this._zoomedObject=null;}}return this;};
var I={x:-2,y:-2};var J=2;var U=5;
G.prototype.onkeydown=function(e){if(!e.isMarked()){var a;switch(e.keyCode){case K.ARROW_LEFT:case K.ARROW_RIGHT:case K.ARROW_UP:case K.ARROW_DOWN:if(e.ctrlKey||e.altKey||e.metaKey){break;}var b={x:0,y:0};switch(e.keyCode){case K.ARROW_LEFT:b.x=-1;break;case K.ARROW_RIGHT:b.x=+1;break;case K.ARROW_UP:b.y=-1;break;case K.ARROW_DOWN:b.y=+1;break;default:break;}a=this._viewportGestureHandler._cameraController;a.beginGesture(I.x,I.y);if(e.shiftKey){a.pan(U*b.x,U*b.y);}else{a.rotate(J*b.x,J*b.y,true);}a.endGesture();this.setShouldRenderFrame();e.preventDefault();e.stopPropagation();break;case 189:case K.PLUS:case K.NUMPAD_MINUS:case K.NUMPAD_PLUS:a=this._viewportGestureHandler._cameraController;a.beginGesture(this.$().width()/2,this.$().height()/2);a.zoom(e.keyCode===K.PLUS||e.keyCode===K.NUMPAD_PLUS?1.02:0.98);a.endGesture();this.setShouldRenderFrame();e.preventDefault();e.stopPropagation();break;default:break;}}};
G.prototype._handleVisibilityChanged=G.prototype._handleOpacityChanged=G.prototype._handleTintColorChanged=G.prototype._handleHighlightColorChanged=function(e){this.setShouldRenderFrame();};
G.prototype._handleSelectionChanged=function(e){var t=this.getTools();for(var i=0;i<t.length;i++){var a=sap.ui.getCore().byId(t[i]);var b=a.getGizmoForContainer(this);if(b&&b.handleSelectionChanged){b.handleSelectionChanged(e);}}this.setShouldRenderFrame();};
G.prototype.setSelectionRect=function(a){this.setShouldRenderFrame();if(!a){this._selectionRect=null;return;}var s=this._renderer.getSize();var x=(a.x1/s.width)*2-1,y=(a.y1/s.height)*-2+1,b=(a.x2/s.width)*2-1,e=(a.y2/s.height)*-2+1;if(!this._selectionRect){var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(x,e,-1),new THREE.Vector3(b,e,-1),new THREE.Vector3(b,y,-1),new THREE.Vector3(x,y,-1));this._selectionRect=new THREE.LineLoop(h,new THREE.LineBasicMaterial({color:0xC0C000,linewidth:window.devicePixelRatio}));}else{var i=this._selectionRect.geometry.vertices;i[0].set(x,e,-1);i[1].set(b,e,-1);i[2].set(b,y,-1);i[3].set(x,y,-1);this._selectionRect.geometry.verticesNeedUpdate=true;}};
G.prototype._renderLoop=function(){if(!this._renderer||!this.getDomRef()){this._renderLoopRequestId=0;return;}if(this._viewportGestureHandler){this._viewportGestureHandler.animateCameraUpdate();}if(this._nodesTransitionHelper){this._nodesTransitionHelper.displayNodesMoving();}if(this.getCamera()){var a=this.getCamera().getCameraRef();if(this._eyePointLight&&a){this._eyePointLight.position.copy(a.position);}if(this.getCamera().getIsModified()){this.getCamera().setIsModified(false);this._shouldRenderFrame=true;}}if(this._shouldRenderFrame){this._shouldRenderFrame=false;this.render();}this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};
function _(a,b,s){s.children.forEach(function(e){if(e.userData._vkDynamicObjects){e.userData._vkDynamicObjects.forEach(function(h){if(h.visible){h._vkUpdate(a,b);}});}});}
function W(e,h,s,i,j){s.children.forEach(function(m){if(m.userData._vkDetailViews){m.userData._vkDetailViews.sort(function(a,b){return a.renderOrder-b.renderOrder;});m.userData._vkDetailViews.forEach(function(a){if(a.node.visible){a.detailView._render(e,h,s,i,j);}});}});}
G.prototype.render=function(){var a=this._renderer;if(!a){return;}var b=this._scene?this._scene.getSceneRef():null;var e=this._camera?this._camera.getCameraRef():null;if(!b||!e){return;}if(this._animationMixer){var h=this._animationTimeController.getCurrentStatus();if(h.progress<0){this._animationMixer.dispatchEvent({type:"restart"});this._shouldRenderFrame=false;return;}else if(h.delta>0){for(var j=0;j<this._currentAnimationActions.length;j++){var m=this._currentAnimationActions[j];if(!m.enabled||m.paused){m.enabled=true;m.paused=false;}}this._animationMixer.updateWithoutMixing(h.delta);this.setShouldRenderFrame();this.fireAnimationUpdated({value:h.progress});if(h.progress>=100&&!this._animationTimeController.getInfinite()){this._animationMixer.dispatchEvent({type:"complete"});this.fireAnimationFinished();}}else if(h.progress>=100){this._shouldRenderFrame=false;}}var t=this.getTools();var p=this._getViewStateManagerThreeJS();var i,q,s,w;if(this._camera.getUsingDefaultClipPlanes()||(e.isOrthographicCamera&&e.zoom<=0)){w=this._scene._computeBoundingBox(true,false);if(!w.isEmpty()){if(e.isOrthographicCamera&&e.zoom<=0){this._camera.adjustZoom(w);}if(this._camera.getUsingDefaultClipPlanes()){for(i=0;i<t.length;i++){q=sap.ui.getCore().byId(t[i]);s=q.getGizmoForContainer(this);if(s&&s.expandBoundingBox){s.expandBoundingBox(w);}}this._camera.adjustClipPlanes(w);}}}_(a,e,b);a.clippingPlanes=this._clippingPlanes;switch(this.getRenderMode()){case r.XRay:if(p){var x=b.children[b.children.length-1].clone();p._selectedNodes.forEach(function(X){if(X.visible){X.add(x);a.render(X,e);a.autoClear=false;X.remove(x);}});}b.overrideMaterial=this._xrayMaterial;break;case r.LineIllustration:case r.ShadedIllustration:case r.SolidOutline:this._scene._outlineMaterial.linewidth=this._renderer.getPixelRatio();break;default:break;}a.autoClear=this._backgroundColor!=null;if(a.autoClear){a.setClearColor(this._backgroundColor.color,this._backgroundColor.alpha);}else{a.render(this._backgroundScene,this._backgroundCamera);}if(this.getRenderMode()===r.XRay){a.autoClear=false;}a.render(b,e);a.autoClear=false;a.clippingPlanes=[];b.overrideMaterial=null;W(a,e,b,w,this._eyePointLight);if(p){var y=p._boundingBoxesScene;if(y){p._updateBoundingBoxes();a.render(y,e);}}for(i=0;i<t.length;i++){q=sap.ui.getCore().byId(t[i]);s=q.getGizmoForContainer(this);if(s&&s.render){s.render(this);}}if(this._selectionRect){a.render(this._selectionRect,this._backgroundCamera);}this.fireFrameRenderingFinished();};
G.prototype.getImage=function(a,b,t,e,i){if(this._scene===null){return null;}a=Math.min(a||16,2048);b=Math.min(b||16,2048);var j=new THREE.WebGLRenderer({preserveDrawingBuffer:true,antialias:true,alpha:true});j.setPixelRatio(window.devicePixelRatio);j.setSize(a,b);var m=this.getBackgroundColorTop();var p=this.getBackgroundColorBottom();if(t&&!e){j.setClearColor(t,1);}else if(!t&&e){j.setClearColor(e,1);}else{if(t&&e){this.setBackgroundColorTop(t);this.setBackgroundColorBottom(e);}j.render(this._backgroundScene,this._backgroundCamera);j.autoClear=false;}document.body.appendChild(j.domElement);var q=this.getCamera().getCameraRef().clone();var s=a/b;if(q.isOrthographicCamera){var w=q.right-q.left;var h=q.top-q.bottom;if(w>h){q.top=w/s/2;q.bottom=-w/s/2;}else{q.left=-h*s/2;q.right=h*s/2;}}else{var x=2*Math.atan(q.aspect*Math.tan(q.fov*Math.PI/360));if(q.fov<x*180/Math.PI){q.fov=360*Math.atan(Math.tan(x*0.5)/s)/Math.PI;}q.aspect=s;}q.updateProjectionMatrix();var y=[];var X=this._getViewStateManagerThreeJS();if(!i){if(X!==null){X.enumerateSelection(function($){y.push($);});X.setSelectionState(y,false,false,true);}}j.render(this._scene.getSceneRef(),q);var Y=j.getContext().canvas.toDataURL();if(X!==null&&y.length>0){X.setSelectionState(y,true,false,true);}document.body.removeChild(j.domElement);j.dispose();if(p&&t){this.setBackgroundColorBottom(p);}if(m&&e){this.setBackgroundColorTop(m);}return Y;};
G.prototype._setContent=function(a){var s;var b;if(a){s=a;if(!(s instanceof A)){s=null;}b=a.camera;if(!(b instanceof O||b instanceof P)){b=new P();}if(b instanceof O){var e=new THREE.Box3().setFromObject(s.getSceneRef());var h=e.getCenter();var j=b.getTargetDirection();var p=b.getPosition();var m=[h.x-p[0],h.y-p[1],h.z-p[2]];var q=m[0]*j[0]+m[1]*j[1]+m[2]*j[2];if(q<0){var t=e.getSize().length()/2;t-=q;p[0]-=j[0]*t;p[1]-=j[1]*t;p[2]-=j[2]*t;b.setPosition(p);}}var i;if(a.loaders){for(i=0;i<a.loaders.length;i++){if(a.loaders[i]instanceof B){this._cdsLoader=a.loaders[i];this._cdsLoader.attachSceneUpdated(this._handleCdsSceneUpdate,this);break;}}}if(a.builders){for(i=0;i<a.builders.length;i++){a.builders[i]._fireSceneUpdated=this.setShouldRenderFrame.bind(this);a.builders[i]._fireLoadingFinished=function($){this.setRenderMode(this.getRenderMode());}.bind(this);}}}if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this.setScene(s);if(s){var w=s.getInitialView();if(w){this._currentView=w;this._resetNodesMaterialAndOpacityByCurrentView();var x=this._currentView.getPlaybacks();if(x){for(var y=0;y<x.length;y++){var X=x[y];var Y=s.getAnimationSequence(X.getSequenceId());if(Y){this.AddHandlersToAnimationSequenceEvents(Y);}}}}}if(b){this.setCamera(b);}if(a){if(a.backgroundTopColor!==undefined){this.setBackgroundColorTop(new THREE.Color(a.backgroundTopColor).getStyle());}if(a.backgroundBottomColor!==undefined){this.setBackgroundColorBottom(new THREE.Color(a.backgroundBottomColor).getStyle());}if(a.renderMode!==undefined){this.setRenderMode(a.renderMode);}}};
G.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};
G.prototype._onBeforeClearContentConnector=function(){if(H._onBeforeClearContentConnector){H._onBeforeClearContentConnector.call(this);}this.setScene(null);};
G.prototype._handleContentReplaced=function(e){var a=e.getParameter("newContent");this._setContent(a);};
G.prototype._onAfterUpdateViewStateManager=function(){};
G.prototype._onBeforeClearViewStateManager=function(){};
C.injectMethodsIntoClass(G);d.injectMethodsIntoClass(G);
G.prototype._restoreOriginalValueAfterAnimation=function(){var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){return;}for(var a=0;a<p.length;a++){var b=this._scene.getAnimationSequence(p[a].getSequenceId());var e;if(b){e=b.getNativeAnimationClip();}if(e){if(e&&e.tracks){for(var t=0;t<e.tracks.length;t++){var h=e.tracks[t];var i=h.userData;if(!i){continue;}var j=i.originalValue;if(!j){continue;}var m=i.targetNode;if(!m){continue;}if(i.type==="SCALE"){m.scale.copy(j);}else if(i.type==="TRANSLATE"){m.position.copy(j);}else if(i.type==="ROTATE"){m.quaternion.copy(j);}}}}}};
G.prototype._resetNodePositionsForAnimation=function(){var a;if(this._currentView&&this._currentView.userData&&this._currentView.userData.nodeStartDataByAnimation){a=this._currentView.userData.nodeStartDataByAnimation.entries();}if(a){var b=a.next();while(!b.done){var e=b.value[0];var h=b.value[1];b=a.next();if(!h){continue;}if(h.scale){e.scale.copy(h.scale);}if(h.position){e.position.copy(h.position);}if(h.quaternion){e.quaternion.copy(h.quaternion);}if(h.opacity!==undefined){e.userData.opacity=h.opacity;e._vkUpdateMaterialOpacity();}if(h.color){e.material.color=h.color.clone();e.material.needsUpdate=true;}}}return;};
G.prototype._runAnimation=function(a){var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){return false;}this.fireAnimationStarted();this._animationTimeController.setInfinite(false);var b=0;this._currentAnimationActions=[];var t=[];var e,h,i;for(i=0;i<p.length;i++){e=p[i];h=this._scene.getAnimationSequence(e.getSequenceId());if(h){if(!h.userData){h.userData={};}h.userData.playbackCount=0;}}for(i=0;i<p.length;i++){e=p[i];h=this._scene.getAnimationSequence(e.getSequenceId());var j;if(h){if(h.userData.playbackCount===0){j=h.getNativeAnimationClip();h.userData.playbackCount=1;}else{var m=e.getSequenceId()+h.userData.playbackCount.toString();var q=this._scene.getAnimationSequence(m);if(!q){q=this._scene.createAnimationSequence(m);q.clone(h,true);}j=q.getNativeAnimationClip();h.userData.playbackCount++;}this.AddHandlersToAnimationSequenceEvents(h);}if(j){var s=this._animationMixer.clipAction(j);var w=e.getRepeat();if(!w){w=1;}if(e.getInfinite()){if(this._playingProcedure){w=Math.round(10/h.getDuration());if(w<10){w=10;}s.setLoop(THREE.LoopRepeat,w);}else{s.setLoop(THREE.LoopRepeat,Infinity);this._animationTimeController.setInfinite(true);}}else if(w>0){if(!e.getReversed()){s.setLoop(THREE.LoopRepeat,w);}else if(w>1){s.setLoop(THREE.LoopRepeat,w-1);}else{s.setLoop(THREE.LoopOnce,1);}}else{s.setLoop(THREE.LoopOnce,1);}var x=e.getTimeScale();if(x<=0){x=1;}if(e.getReversed()){s.timeScale=-1;s.time=j.duration/x;}s.clampWhenFinished=true;s.timeScale*=x;this._currentAnimationActions.push(s);t.push(e.getStartTime()+e.getPreDelay());var y=e.getStartTime()+e.getPreDelay()+w*h.getDuration()/x+e.getPostDelay();if(y>b){b=y;}}}if(b==0){this._animationMixer=null;this.fireViewFinished({viewIndex:this._currentViewIndex});this._playNextStep();return false;}this._animationTimeController.startAnimation(b,a);for(var X=0;X<this._currentAnimationActions.length;X++){this._currentAnimationActions[X].play().startAt(t[X]);}this.setShouldRenderFrame();return true;};
G.prototype.startAnimation=function(){this.resumeAnimation();this._startAnimation();};
G.prototype._startAnimation=function(a){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}var p;if(this._currentView){p=this._currentView.getPlaybacks();}if(!p||!p.length){this._playingPlaybacks=false;return false;}var b=this._scene?this._scene.getSceneRef():undefined;if(!b){return false;}this._resetNodesStatusByCurrenView();this._resetNodePositionsForAnimation();this._animationMixer=new THREE.AnimationMixer(b);if(!this._animationMixer.userData){this._animationMixer.userData={};}this._animationMixer.userData.completed=false;this._animationMixer.userData.viewport=this;this._animationMixer.addEventListener("complete",function(e){if(this.userData.viewport){this.userData.completed=true;if(this.userData.viewport._currentView){this.userData.viewport._currentView.animationCompleted=true;}var h=function(i){i.fireViewFinished({viewIndex:this._currentViewIndex});i._playNextStep();};setTimeout(h,10,this.userData.viewport);Q.sap.log.debug("Animation completed");}},false);this._animationMixer.addEventListener("restart",function(e){if(this.userData.viewport){this.userData.completed=true;if(this.userData.viewport._currentView){this.userData.viewport._currentView.animationCompleted=true;}var h=function(i){var p;if(i._currentView){p=i._currentView.getPlaybacks();}if(p&&p.length){i._startAnimation();}};setTimeout(h,10,this.userData.viewport);Q.sap.log.debug("Animation restart");}},false);return this._runAnimation(a);};
G.prototype.stopAnimation=function(){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this._resetNodesStatusByCurrenView();this._resetNodePositionsForAnimation();this._animationTimeController.stopAnimation();this.fireAnimationUpdated({value:0});this._playingProcedure=false;this.setShouldRenderFrame();};
G.prototype.getCurrentView=function(){return this._currentView;};
G.prototype._activateSingleView=function(a){if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}if(this._scene._scene.userData.viewportGroups){var b=this._scene._scene.userData.viewportGroups;var t=this;b.forEach(function(d1){d1.modelViews.forEach(function(e1){if(e1===a){t._currentViewIndex=d1.modelViews.indexOf(e1);}});});}this.fireViewActivated({viewIndex:this._currentViewIndex,view:a});this._animationTimeController.reset();this.fireAnimationUpdated({value:0});this._currentView=a;if(a.topColor!==undefined){this.setBackgroundColorTop(new THREE.Color(a.topColor).getStyle());}if(a.bottomColor!==undefined){this.setBackgroundColorBottom(new THREE.Color(a.bottomColor).getStyle());}if(a.renderMode!==undefined){this.setRenderMode(a.renderMode);}var e=a.camera;if(!e&&a.getCameraInfo()){var h=a.getCameraInfo();if(h.type==="PerspectiveCamera"){e=new P();e.setFov(h.fov);}if(h.type==="OrthographicCamera"){e=new O();e.setZoomFactor(h.zoomFactor);if(h.zoomNeedRecalculate){e.setZoomNeedRecalculate(true);}}e.setPosition(h.position);e.setNearClipPlane(h.nearClipPlane);e.setFarClipPlane(h.farClipPlane);e.setUpDirection(h.upDirection);e.setTargetDirection(h.targetDirection);e.setUsingDefaultClipPlanes(h.usingDefaultClipPlanes);a.camera=e;}var i=this._scene?this._scene.getSceneRef():undefined;if(e){var j=e.getCameraRef();if(j.type==="OrthographicCamera"&&i){var p=e.getPosition();var s=this.getScene();if(s){var m=new THREE.Box3().setFromObject(i);var q=m.getCenter();var w=e.getTargetDirection();var x=[q.x-p[0],q.y-p[1],q.z-p[2]];var y=x[0]*w[0]+x[1]*w[1]+x[2]*w[2];if(y<0){var X=m.getSize().length()/2;X-=y;p[0]-=w[0]*X;p[1]-=w[1]*X;p[2]-=w[2]*X;}}e.setPosition(p);}}this._resetNodesMaterialAndOpacityByCurrentView();this._animationHelper.setInitialNodePositionsOnView(this._currentView,this._scene);this._resetNodesStatusByCurrenView(true,true,true);this._resetNodePositionsForAnimation();var Y=this._currentView.getPlaybacks();if(Y){for(var $=0;$<Y.length;$++){var a1=Y[$];var b1=this._scene.getAnimationSequence(a1.getSequenceId());if(b1){this.AddHandlersToAnimationSequenceEvents(b1);b1.setInitialStatusToTargetNodesValues();}}}if(e){var c1=2000;if(a.flyToTime!=null){c1=a.flyToTime;}this._playingPlaybacks=true;this._viewportGestureHandler.activateCamera(e.getCameraRef(),c1,this._playingProcedure);}else{this.fireViewFinished();}};
G.prototype._updateMaterialInNode=function(a){var b=a.target;if(!b){return;}var i,e;for(i=0;i<b.children.length;i++){e=b.children[i];if(e.material&&(e.userData.animatedOpacity||e.userData.animatedColor)){e._vkUpdateMaterialColor();e._vkUpdateMaterialOpacity();if(e.userData.animatedOpacity){e.material.transparent=true;}}}var h;if(b.userData.materialId!==undefined){h=a.materialId!==b.userData.materialId;}else{h=a.materialId!==undefined;}var j;if(b.userData.opacity!==undefined){j=a.opacity!==b.userData.opacity;}else{j=a.opacity!==undefined||b.userData.animatedOpacity;}b.userData.materialId=a.materialId;b.userData.opacity=a.opacity;if(h||j){var m=this._scene.getMaterial(b.userData.materialId);for(i=0;i<b.children.length;i++){e=b.children[i];if(e.material){if(h){var p=m?m:this._scene.getMaterial(e.userData.initialMaterialId);if(p){var q=p.getMaterialRef();e.userData.materialId=q.userData.materialId;e.userData.originalMaterial=q;e.material=q.clone();if(this._scene._sceneBuilder){this._scene._sceneBuilder._attachMaterialClone(e.userData.materialId,e.material);}if(e.userData.animatedOpacity){e.material.transparent=true;}}}e._vkUpdateMaterialOpacity();}}}};
G.prototype._resetNodesMaterialAndOpacityByCurrentView=function(){if(!this._currentView){return;}var a;if(this._currentView.getNodeInfos){a=this._currentView.getNodeInfos();}if(a){a.forEach(this._updateMaterialInNode.bind(this));}};
G.prototype._resetNodesStatusByCurrenView=function(i,s,a){if(!this._currentView){return;}function b(x){return new THREE.Matrix4().set(x[0],x[1],x[2],x[3],x[4],x[5],x[6],x[7],x[8],x[9],x[10],x[11],0,0,0,1);}if(this._viewStateManager){var e=this._viewStateManager.getNodeHierarchy();if(e){var p;if(this._currentView){p=this._currentView.getPlaybacks();}var h;if(i&&this._currentView.userData&&this._currentView.userData.nodeStartDataByAnimation){h=this._currentView.userData.nodeStartDataByAnimation;}var j;if(this._currentView.getNodeInfos){j=this._currentView.getNodeInfos();}if(j){j.forEach(function(x){if(x.target===null){return;}function y(a1,b1,c1){for(var ei=0;ei<a1.elements.length;ei++){if(Math.abs(a1.elements[ei]-b1.elements[ei])>c1){return false;}}return true;}if(x.transform){var X=b(x.transform);if(!y(X,x.target.matrix,1e-6)){if(!p&&a){var Y=e.createNodeProxy(x.target);this._nodesTransitionHelper.setNodeForDisplay(Y);}X.decompose(x.target.position,x.target.quaternion,x.target.scale);x.target.updateMatrix();var $;if(h){$=h.get(x.target);}if($){if($.scale){x.target.scale.copy($.scale);}if($.position){x.target.position.copy($.position);}if($.quaternion){x.target.quaternion.copy($.quaternion);}if($.opacity!==undefined){x.userData.opacity=$.opacity;x._vkUpdateMaterialOpacity();}if($.color){x.material.color=$.color.clone();x.material.needsUpdate=true;}x.target.updateMatrix();}}}}.bind(this));}if(s){this._viewStateManager.setVisibilityState(e.getChildren()[0].children,false,false);if(j){var m=[];var q=[];for(var t=0;t<j.length;t++){if(j[t].visible){m.push(j[t].target);}else{q.push(j[t].target);}}this._viewStateManager.setVisibilityState(m,true,false);this._viewStateManager.setVisibilityState(q,false,false);this._nodesTransitionHelper.startDisplay(500);}else if(this._currentView.visibleNodes){var w=this._scene?this._scene.getSceneRef():undefined;if(w){this._viewStateManager.setVisibilityState(w.children[0],false,true);this._viewStateManager.setVisibilityState(w.children[0],true,false);this._viewStateManager.setVisibilityState(this._currentView.visibleNodes,true,false);}}}}}};
G.prototype.resetCurrentView=function(i){if(!this._currentView){return this;}if(this._animationMixer){this._animationMixer.stopAllAction();this._animationMixer=null;}this.fireAnimationUpdated({value:0});this._resetNodesMaterialAndOpacityByCurrentView();if(i){this._animationHelper.setInitialNodePositionsOnView(this._currentView,this._scene);}this._resetNodesStatusByCurrenView(i,false,false);if(i){this._resetNodePositionsForAnimation();}this.setShouldRenderFrame();return this;};
G.prototype.activateView=function(a,b){this._playingProcedure=false;if(this._notPlayingAnimations==undefined){this._notPlayingAnimations=false;}else{this._notPlayingAnimations=b;}this._activateSingleView(a);return this;};
G.prototype.updateNodeInfoInCurrentView=function(a,b){if(!this._currentView){return;}var e;if(this._currentView.getNodeInfos){e=this._currentView.getNodeInfos();}if(e){var h;for(var i=0;i<e.length;i++){var j=e[i];if(j.target===null||j.target!==a){continue;}h=j;break;}if(!h){h={};e.push(h);}var t=new THREE.Matrix4();t.compose(a.position,a.quaternion,a.scale);var m=t.toArray();h.transform=[m[0],m[4],m[8],m[12],m[1],m[5],m[9],m[13],m[2],m[6],m[10],m[14]];if(b!==undefined){h.opacity=b;}}};
G.prototype._playNextStep=function(){if(!this._playingProcedure){return;}this._currentViewIndex++;if(this._currentViews.length<=this._currentViewIndex){this._playingProcedure=false;this.fireProcedureFinished();}else{var a=this._currentViews[this._currentViewIndex];this._activateSingleView(a);}};
G.prototype.playProcedure=function(a,b,e){if(a){this._currentViews=a;}if(b==null){b=0;}if(!this._currentViews||this._currentViews.length<=b){return this;}this._currentViewIndex=b;if(this._notPlayingAnimations==undefined){this._notPlayingAnimations=false;}else{this._notPlayingAnimations=e;}if(this._playingProcedure&&this._animationMixer){this.resumeAnimation();}else{this._playingProcedure=true;var h=this._currentViews[b];this._activateSingleView(h);}return this;};
G.prototype.zoomTo=function(w,a,b,m){var e=this._scene?this._scene.getSceneRef():null;var h=this._camera?this._camera.getCameraRef():null;if(!h||!e){return this;}m=m||0;var i=new THREE.Box3();var q=null;var j=null;(Array.isArray(w)?w:[w]).forEach(function(w){switch(w){case Z.All:e._expandBoundingBox(i,false,true);break;case Z.Visible:e._expandBoundingBox(i,true,true);break;case Z.Selected:var p=this._getViewStateManagerThreeJS();if(p){p.enumerateSelection(function(a){a._expandBoundingBox(i,false,true);});}break;case Z.Node:if(!a){return this;}j=a;if(Array.isArray(a)){a.forEach(function(a){a._expandBoundingBox(i,false,true);});}else{a._expandBoundingBox(i,false,true);}break;case Z.Restore:Q.sap.log.error(u().getText("VIEWPORT_MSG_RESTORENOTIMPLEMENTED"));return this;case Z.NodeSetIsolation:Q.sap.log.error(u().getText("VIEWPORT_MSG_NODESETISOLATIONNOTIMPLEMENTED"));return this;case Z.RestoreRemoveIsolation:Q.sap.log.error(u().getText("VIEWPORT_MSG_RESTOREREMOVEISOLATIONNOTIMPLEMENTED"));return this;case Z.ViewLeft:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),-Math.PI/2);break;case Z.ViewRight:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI/2);break;case Z.ViewTop:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),-Math.PI/2);break;case Z.ViewBottom:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),Math.PI/2);break;case Z.ViewBack:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI);break;case Z.ViewFront:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),0);break;default:break;}}.bind(this));if(!i.isEmpty()){this._viewportGestureHandler.zoomTo(i,q,m,b*1000,j,j!==null);}return this;};
G.prototype.pan=function(a,b){this._viewportGestureHandler._cameraController.pan(a,b);};
G.prototype.rotate=function(a,b){this._viewportGestureHandler._cameraController.rotate(a,b);};
G.prototype.zoom=function(a){this._viewportGestureHandler._cameraController.zoom(a);};
G.prototype.getViewInfo=function(q){var a={};if(q==null){q={};}if(q.camera==null){q.camera=true;}var b=this._camera?this._camera.getCameraRef():null;if(q.camera&&b){var e=b.rotation.clone();e.reorder("YXZ");a.camera={rotation:{yaw:THREE.Math.radToDeg(e.y),pitch:THREE.Math.radToDeg(e.x),roll:THREE.Math.radToDeg(e.z)},position:{x:b.position.x,y:b.position.y,z:b.position.z},projectionType:b.isOrthographicCamera?l.Orthographic:l.Perspective,bindingType:n.Vertical};var h=b.view;if(h&&h.enabled){a.camera.view={fullWidth:h.fullWidth,fullHeight:h.fullHeight,offsetX:h.offsetX,offsetY:h.offsetY,width:h.width,height:h.height};}if(a.camera.projectionType===l.Perspective){a.camera.fieldOfView=b.fov;}else if(a.camera.projectionType===l.Orthographic){a.camera.zoomFactor=b.zoom;}if(q.camera.matrices){a.camera.matrices={view:b.matrixWorldInverse.elements.slice(),projection:b.projectionMatrix.elements.slice()};}}if(q.visibility&&this._viewStateManager){var i=q.visibility.mode==null?o.Complete:q.visibility.mode;a.visibility={mode:i};if(i===o.Complete){var j=this._viewStateManager.getVisibilityComplete();a.visibility.visible=j.visible;a.visibility.hidden=j.hidden;}else if(this._viewStateManager.getShouldTrackVisibilityChanges()){a.visibility.changes=this._viewStateManager.getVisibilityChanges();}else{Q.sap.log.warning(u().getText(M.VIT32.summary),M.VIT32.code,"sap.ui.vk.threejs.Viewport");}}return a;};
G.prototype.setViewInfo=function(a,b){var e=this._camera?this._camera.getCameraRef():null;if(a.camera&&e){var h=a.camera;var i=h.projectionType===l.Orthographic?new THREE.OrthographicCamera():new THREE.PerspectiveCamera();i.userData=e.userData;i.aspect=e.aspect;i.position.copy(h.position);var j=h.rotation;i.quaternion.setFromEuler(new THREE.Euler(THREE.Math.degToRad(j.pitch),THREE.Math.degToRad(j.yaw),THREE.Math.degToRad(j.roll),"YXZ"));i.fov=h.fieldOfView||i.fov;i.zoom=h.zoomFactor||i.zoom;if(e.view&&e.view.enabled){var m=h.view||e.view;i.setViewOffset(m.fullWidth,m.fullHeight,m.offsetX,m.offsetY,m.width,m.height);i.aspect=m.fullWidth/m.fullHeight;i.zoom=Math.min(i.aspect,1);}this._viewportGestureHandler.activateCamera(i,(b||0)*1000);}if(a.visibility){var p=this._viewStateManager.getNodeHierarchy(),q=new Map(),s=p.findNodesByName();s.forEach(function(x){var y=p.createNodeProxy(x);var X=y.getVeId();p.destroyNodeProxy(y);if(X){q.set(X,x);}});switch(a.visibility.mode){case o.Complete:var t=a.visibility.visible,w=a.visibility.hidden;t.forEach(function(x){this._viewStateManager.setVisibilityState(q.get(x),true,false);},this);w.forEach(function(x){this._viewStateManager.setVisibilityState(q.get(x),false,false);},this);break;case o.Differences:this._viewStateManager.resetVisibility();a.visibility.changes.forEach(function(x){var y=q.get(x);if(y){this._viewStateManager.setVisibilityState(y,!this._viewStateManager.getVisibilityState(y),false);}},this);break;default:Q.sap.log.error(u().getText(M.VIT28.summary),M.VIT28.code,"sap.ui.vk.threejs.Viewport");break;}}this.setShouldRenderFrame();return this;};
G.prototype.queueCommand=function(a){if(this instanceof G){a();}return this;};
G.prototype.getOutputSize=function(){var b=this.getDomRef().getBoundingClientRect();var a=b.width;var e=b.height;var h;h=Math.min(a,e);return{left:(a-h)/2,top:(e-h)/2,sideLength:h};};
return G;});
sap.ui.predefine('sap/ui/vk/threejs/ViewportGestureHandler',["jquery.sap.global","sap/ui/base/EventProvider","./PerspectiveCamera","./OrthographicCamera","./thirdparty/three","../getResourceBundle"],function(q,E,P,O,t,g){"use strict";
var V=E.extend("sap.ui.vk.threejs.ViewportGestureHandler",{
metadata:{},
constructor:function(v){this._matProj=null;this._viewport=v;this._rect=null;this._evt={x:0,y:0,z:0,d:0,initd:0};this._gesture=false;this._viewport.attachEvent("resize",this,this._onresize);this._nomenu=false;var T=function(a){var v=a;var b=new THREE.Vector3();var z=new THREE.Vector2();var A=0.001;var M=-Math.PI/2+A;var c=Math.PI/2-A;this.isTurnTableMode=true;this._timeIntervalForCameraAnimation=500;this._startTimeForCameraAnimation=0;this._newCamera=null;this._oldCamera=null;this._animationType=null;this._zoomedNodeRef=null;this._isZoomIn=true;this.beginGesture=function(x,y){var s=v.getScene();if(s==null){return;}var d=s.getSceneRef();var e=v.getCamera().getCameraRef();var f=v.getRenderer().getSize();z.x=x/f.width*2-1;z.y=y/f.height*-2+1;v._gesturePoint={x:x,y:y};var h=v.hitTest(x,y,d,e);if(h){b.copy(h.point);}else{var i=new THREE.Box3();d._expandBoundingBox(i,true,true);if(!i.isEmpty()){i.getCenter(b);}else{b.setScalar(0);}}};this.endGesture=function(){};this.pan=function(d,e){if(v.getFreezeCamera()||v.getCamera()==null){return;}if(d===0&&e===0){return;}var f=v.getCamera().getCameraRef();var s=v.getRenderer().getSize();if(f.view&&f.view.enabled){f.view.offsetX-=d*f.zoom*f.view.width/f.view.fullWidth;f.view.offsetY-=e*f.zoom*f.view.height/f.view.fullHeight;f.updateProjectionMatrix();}else{var o=b.clone().project(f);o.x-=d*2/s.width;o.y+=e*2/s.height;o.unproject(f).sub(b);f.position.add(o);f.updateMatrixWorld();}v.fireCameraChanged({position:f.position.toArray()});};this.rotate=function(d,e,i){if(v.getFreezeCamera()||v.getCamera()==null){return;}if(i!==undefined){this.isTurnTableMode=i;}if(d===0&&e===0){return;}var f=v.getCamera().getCameraRef(),h=d*-0.01,j=e*-0.01;var o=f.position.clone().sub(b);var l=new THREE.Vector3(),u=new THREE.Vector3().setFromMatrixColumn(f.matrixWorld,1).normalize(),r=new THREE.Vector3().setFromMatrixColumn(f.matrixWorld,0).normalize();f.getWorldDirection(l);l.normalize();var k=new THREE.Quaternion(),m=new THREE.Quaternion();if(this.isTurnTableMode){var s=new THREE.Vector3(0,1,0);r.crossVectors(l,s).normalize();u.crossVectors(r,l);var p=Math.atan2(l.y,Math.sqrt(l.x*l.x+l.z*l.z));k.setFromAxisAngle(s,h);m.setFromAxisAngle(r,THREE.Math.clamp(j,M-p,c-p));}else{k.setFromAxisAngle(u,h);m.setFromAxisAngle(r,j);}k.multiply(m);o.applyQuaternion(k);l.applyQuaternion(k);u.applyQuaternion(k);o.add(b);f.position.copy(o);f.up.copy(u);f.lookAt(o.add(l));f.updateMatrixWorld();v.fireCameraChanged({position:f.position.toArray(),quaternion:f.quaternion.toArray()});};this.zoom=function(d){if(d===0||d===1||v.getFreezeCamera()||v.getCamera()===null||v.getScene()===null){return;}var e=v.getCamera().getCameraRef();var h=new THREE.Vector3();if(!e.userData.isRedlineActivated){var i=100;var j=new THREE.Box3();var k=new THREE.Vector3();v.getScene().getSceneRef()._expandBoundingBox(j,true,true);j.applyMatrix4(e.matrixWorldInverse);j.min.z=Math.max(j.min.z,e.near);j.max.z=Math.max(j.max.z,e.near);j.applyMatrix4(e.projectionMatrix);j.getSize(k);var l=v.getRenderer().getSize();var s=k.x*l.width*0.5;var m=k.y*l.height*0.5;if(s<i&&m<i&&d<1){return;}}if(e.isPerspectiveCamera){if(e.view&&e.view.enabled){var n=v.getDomRef();var x=v._gesturePoint.x/n.clientWidth;var y=v._gesturePoint.y/n.clientHeight;var f=1/d;e.view.offsetX+=x*e.view.width;e.view.offsetY+=y*e.view.height;e.view.width*=f;e.view.height*=f;e.view.offsetX-=x*e.view.width;e.view.offsetY-=y*e.view.height;}else{h.set(z.x,z.y,1).unproject(e);h.sub(new THREE.Vector3(z.x,z.y,-1).unproject(e));var o=b.clone().sub(e.position).length()*(1-1/d);h.setLength(o);e.position.add(h);}}else if(e.isOrthographicCamera){h.set(z.x,z.y,1).unproject(e);h.sub(new THREE.Vector3(0,0,1).unproject(e));h.multiplyScalar(1-1/d);e.zoom*=d;e.position.add(h);}else{q.sap.log.error(g().getText("VIEWPORTGESTUREHANDLER_MSG_UNSUPPORTEDCAMERATYPE"));}e.updateProjectionMatrix();e.updateMatrixWorld();var p={position:e.position.toArray()};if(e.isOrthographicCamera){p.zoom=e.zoom;}v.fireCameraChanged(p);};this.animateCameraUpdate=function(){if(this._newCamera===null||this._oldCamera===null){return;}if(v.getCamera()==null){this._newCamera=null;this._oldCamera=null;return;}function s(f,h,x){x=THREE.Math.clamp((x-f)/(h-f),0.0,1.0);return x*x*x*(x*(x*6-15)+10);}var i=Math.min((Date.now()-this._startTimeForCameraAnimation)/this._timeIntervalForCameraAnimation,1);i=s(0,1,i);var d=v.getCamera().getCameraRef();if(d.isOrthographicCamera&&this._newCamera.isOrthographicCamera&&this._oldCamera.isOrthographicCamera){d.left=THREE.Math.lerp(this._oldCamera.left,this._newCamera.left,i);d.right=THREE.Math.lerp(this._oldCamera.right,this._newCamera.right,i);d.top=THREE.Math.lerp(this._oldCamera.top,this._newCamera.top,i);d.bottom=THREE.Math.lerp(this._oldCamera.bottom,this._newCamera.bottom,i);d.zoom=THREE.Math.lerp(this._oldCamera.zoom,this._newCamera.zoom,i);}if(d.isPerspectiveCamera&&this._newCamera.isPerspectiveCamera&&this._oldCamera.isPerspectiveCamera){d.fov=THREE.Math.lerp(this._oldCamera.fov,this._newCamera.fov,i);d.aspect=THREE.Math.lerp(this._oldCamera.aspect,this._newCamera.aspect,i);}d.far=THREE.Math.lerp(this._oldCamera.far,this._newCamera.far,i);d.near=THREE.Math.lerp(this._oldCamera.near,this._newCamera.near,i);d.updateProjectionMatrix();d.position.lerpVectors(this._oldCamera.position,this._newCamera.position,i);d.scale.lerpVectors(this._oldCamera.scale,this._newCamera.scale,i);d.up.lerpVectors(this._oldCamera.up,this._newCamera.up,i);var o=this._oldCamera.getWorldDirection(new THREE.Vector3());var n=this._newCamera.getWorldDirection(new THREE.Vector3());var e=new THREE.Vector3().lerpVectors(o,n,i);d.lookAt(e.add(d.position));if(i===1){this._newCamera=null;this._oldCamera=null;if(this._animationType==="zooming"&&this._zoomedNodeRef){v.fireNodeZoomed({zoomed:this._zoomedNodeRef,isZoomIn:this._isZoomIn});}v.cameraUpdateCompleted({position:d.position.toArray(),quaternion:d.quaternion.toArray()});}v.fireCameraChanged({position:d.position.toArray(),quaternion:d.quaternion.toArray()});};this.zoomObject=function(n,i,d){if(v.getScene()==null){return;}var e=new THREE.Box3();(i&&n?n:v.getScene().getSceneRef())._expandBoundingBox(e,true,true);this.zoomBox(e,0,d,n,i);};this.zoomBox=function(d,m,e,n,f){this._zoomedNodeRef=n;this._isZoomIn=f;this._animationType="zooming";var h=v.getCamera().getCameraRef();var s=new THREE.Vector3();d.getSize(s);if(s.lengthSq()===0){return;}var j=new THREE.Vector3();h.getWorldDirection(j);j.multiplyScalar(s.length());var k=new THREE.Vector3();d.getCenter(k);var l=[new THREE.Vector3(d.min.x,d.min.y,d.min.z),new THREE.Vector3(d.max.x,d.max.y,d.max.z),new THREE.Vector3(d.min.x,d.min.y,d.max.z),new THREE.Vector3(d.min.x,d.max.y,d.max.z),new THREE.Vector3(d.max.x,d.min.y,d.max.z),new THREE.Vector3(d.max.x,d.max.y,d.min.z),new THREE.Vector3(d.min.x,d.max.y,d.min.z),new THREE.Vector3(d.max.x,d.min.y,d.min.z)];var o=new THREE.Matrix4(),p=new THREE.Vector3();function r(h){o.multiplyMatrices(h.projectionMatrix,h.matrixWorldInverse);for(var i in l){p.copy(l[i]).applyMatrix4(o);if(p.x<-1.0||p.x>1.0||p.y<-1.0||p.y>1.0){return false;}}return true;}this._newCamera=h.clone();this._newCamera.position.copy(k).sub(j);this._newCamera.updateMatrixWorld(true);if(h.isPerspectiveCamera){while(!r(this._newCamera)){this._newCamera.position.sub(j);this._newCamera.updateMatrixWorld(true);}var u=10;var w=this._newCamera.position.clone();var x=k.clone();for(var y=0;y<u;y++){this._newCamera.position.copy(w).add(x).multiplyScalar(0.5);this._newCamera.updateMatrixWorld(true);if(r(this._newCamera)){w.copy(this._newCamera.position);}else{x.copy(this._newCamera.position);}}this._newCamera.position.copy(w).sub(k).multiplyScalar(m).add(w);this._newCamera.updateMatrixWorld(true);}if(h.isOrthographicCamera){var B=new THREE.Box2();l.forEach(function(i){p=i.project(this._newCamera);B.expandByPoint(new THREE.Vector2(p.x,p.y));}.bind(this));this._newCamera.zoom/=Math.max(B.getSize().x,B.getSize().y)*0.5*(1+m);this._newCamera.updateProjectionMatrix();}this._startTimeForCameraAnimation=Date.now();this._timeIntervalForCameraAnimation=e!==undefined?e:500;};this.prepareForCameraUpdateAnimation=function(){this._oldCamera=v.getCamera().getCameraRef().clone();};this.startAnimatingCameraUpdate=function(d,e){var f=v.getCamera().getCameraRef();if(!this._oldCamera){return;}if(!e){var h=0.0001;var n=false;if(f.isOrthographicCamera&&this._oldCamera.isOrthographicCamera){if(Math.abs(f.left-this._oldCamera.left)>h||Math.abs(f.right-this._oldCamera.right)>h||Math.abs(f.top-this._oldCamera.top)>h||Math.abs(f.bottom-this._oldCamera.bottom)>h||Math.abs(f.zoom-this._oldCamera.zoom)>h){n=true;}}else if(f.isPerspectiveCamera&&this._oldCamera.isPerspectiveCamera){if(Math.abs(f.fov-this._oldCamera.fov)>h||Math.abs(f.aspect-this._oldCamera.aspect)>h){n=true;}}if(!n){if(Math.abs(f.position.x-this._oldCamera.position.x)>h||Math.abs(f.position.y-this._oldCamera.position.y)>h||Math.abs(f.position.z-this._oldCamera.position.z)>h||Math.abs(f.scale.x-this._oldCamera.scale.x)>h||Math.abs(f.scale.y-this._oldCamera.scale.y)>h||Math.abs(f.scale.z-this._oldCamera.scale.z)>h||Math.abs(f.quaternion.x-this._oldCamera.quaternion.x)>h||Math.abs(f.quaternion.y-this._oldCamera.quaternion.y)>h||Math.abs(f.quaternion.z-this._oldCamera.quaternion.z)>h||Math.abs(f.quaternion.w-this._oldCamera.quaternion.w)>h){n=true;}}if(!n){v.cameraUpdateCompleted({position:f.position.toArray(),quaternion:f.quaternion.toArray()});return;}}this._newCamera=v.getCamera().getCameraRef().clone();this._timeIntervalForCameraAnimation=d!==undefined?d:500;this._startTimeForCameraAnimation=Date.now();};};this._cameraController=new T(v);}
});
V.prototype._activateRedline=function(){var c=this._viewport.getCamera().getCameraRef();c.userData.isRedlineActivated=true;if(c.isPerspectiveCamera){var d=this._viewport.getDomRef();c.setViewOffset(d.clientWidth,d.clientHeight,0,0,d.clientWidth,d.clientHeight);}};
V.prototype._deactivateRedline=function(){var c=this._viewport.getCamera().getCameraRef();c.userData.isRedlineActivated=false;c.clearViewOffset();};
V.prototype.destroy=function(){this._viewport=null;this._rect=null;this._evt=null;this._gesture=false;};
V.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
V.prototype._inside=function(e){if(this._rect===null||true){var i=this._viewport.getIdForLabel();var d=document.getElementById(i);if(!d){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
V.prototype._onresize=function(e){this._gesture=false;this._rect=null;};
V.prototype.beginGesture=function(a){if(this._inside(a)&&!this._gesture){this._gesture=true;var x=a.x-this._rect.x,y=a.y-this._rect.y;this._evt.x=x;this._evt.y=y;this._evt.d=a.d;this._evt.initd=a.d;this._evt.avgd=a.d;this._evt.avgx=0;this._evt.avgy=0;q.sap.log.debug("Loco: beginGesture: "+x+", "+y);this._cameraController.beginGesture(x,y);a.handled=true;if(document.activeElement){try{document.activeElement.blur();}catch(e){}}var d=document.getElementById(this._viewport.getIdForLabel());d.focus();}this._nomenu=false;};
V.prototype.move=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;var d=x-this._evt.x;var a=y-this._evt.y;var b=e.d-this._evt.d;this._evt.x=x;this._evt.y=y;this._evt.d=e.d;this._evt.avgx=this._evt.avgx*0.99+d*0.01;this._evt.avgy=this._evt.avgy*0.99+a*0.01;var z=1.0;if(this._evt.initd>0){z=1.0+b*(1.0/this._evt.initd);}else if(e.n===2){if(e.points[0].y>e.points[1].y){z=1.0-b*0.005;if(z<0.333){z=0.333;}}else{z=1.0+b*0.005;if(z>3){z=3;}}}if(this._evt.initd>0){var c=Math.sqrt(this._evt.avgx*this._evt.avgx+this._evt.avgy*this._evt.avgy);q.sap.log.debug("AvgDist: "+c);if((Math.abs(e.d-this._evt.avgd)/this._evt.avgd)<(c/10)){z=1.0;}}z=THREE.Math.clamp(z,0.88,1.12);this._evt.avgd=this._evt.avgd*0.97+e.d*0.03;switch(e.n){case 1:q.sap.log.debug("Loco: Rotate: "+(d)+", "+(a));this._cameraController.rotate(d,a);break;case 2:q.sap.log.debug("Loco: Pan: "+(d)+", "+(a));if(z!=0&&z!=1.0){q.sap.log.debug("Loco: Zoom: "+(z));}this._cameraController.pan(d,a);if(d<10&&a<10&&z!=0&&z!=1.0){this._cameraController.zoom(z);}break;default:break;}this._nomenu=true;e.handled=true;}};
V.prototype.endGesture=function(e){if(this._gesture){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: endGesture: "+x+", "+y);this._cameraController.endGesture();this._gesture=false;e.handled=true;}};
V.prototype.click=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: click: "+(x)+", "+(y));if(this._viewport){this._viewport.tap(x,y,false);}e.handled=true;}};
V.prototype.doubleClick=function(e){if(this._inside(e)&&e.buttons<=1){var x=e.x-this._rect.x,y=e.y-this._rect.y;q.sap.log.debug("Loco: doubleClick: "+(x)+", "+(y));if(this._viewport){this._viewport.tap(x,y,true);}e.handled=true;}};
V.prototype.contextMenu=function(e){if(this._inside(e)||this._nomenu||e.buttons===5){this._nomenu=false;e.handled=true;}};
V.prototype.keyEventHandler=function(e){};
V.prototype.getViewport=function(){return this._viewport;};
V.prototype.activateCamera=function(c,a,e){this._cameraController.prepareForCameraUpdateAnimation();if(this._viewport.getCamera().getCameraRef().isPerspectiveCamera!=c.isPerspectiveCamera){this._viewport.setCamera(c.isPerspectiveCamera?new P():new O());}this._viewport.getCamera().getCameraRef().copy(c);var s=this._viewport.getRenderer().getSize();this._viewport.getCamera().update(s.width,s.height);this._cameraController.startAnimatingCameraUpdate(a,e);return this;};
V.prototype.setView=function(a,b){this._cameraController.prepareForCameraUpdateAnimation();var c=this._viewport.getCamera().getCameraRef();if(a){c.quaternion.copy(a);c.updateMatrixWorld();c.up.setFromMatrixColumn(c.matrixWorld,1).normalize();this._cameraController.zoomObject(null,false,b);}else{c.copy(this._viewport._homeCamera?this._viewport._homeCamera:new P().getCameraRef());var s=this._viewport.getRenderer().getSize();this._viewport.getCamera().update(s.width,s.height);this._cameraController.startAnimatingCameraUpdate(b);}return this;};
V.prototype.zoomTo=function(b,a,m,c,n,i){this._cameraController.prepareForCameraUpdateAnimation();if(a){var d=this._viewport.getCamera().getCameraRef();d.quaternion.copy(a);d.updateMatrixWorld();d.up.setFromMatrixColumn(d.matrixWorld,1).normalize();}this._cameraController.zoomBox(b,m,c,n,i);return this;};
V.prototype.zoomObject=function(n,i,a){this._cameraController.prepareForCameraUpdateAnimation();this._cameraController.zoomObject(n,i,a);return this;};
V.prototype.animateCameraUpdate=function(){this._cameraController.animateCameraUpdate();};
V.prototype.prepareForCameraUpdateAnimation=function(){this._cameraController.prepareForCameraUpdateAnimation();};
V.prototype.startAnimatingCameraUpdate=function(a){this._cameraController.startAnimatingCameraUpdate(a);};
return V;});
sap.ui.predefine('sap/ui/vk/threejs/ViewportRenderer',[],function(){"use strict";var V={};
V.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapVizKitViewport");r.writeClasses();r.writeAttribute("tabindex",0);r.writeAttribute("aria-label","Image");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");var i,l;var t=c.getTools();for(i=0,l=t.length;i<l;i++){var _=sap.ui.getCore().byId(t[i]);var a=_.getGizmoForContainer(c);if(a&&a.hasDomElement()){r.renderControl(a);}}var C=c.getContent();for(i=0,l=C.length;i<l;i++){r.renderControl(C[i]);}r.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/vk/tools/AnchorPointTool',["./Tool","./AnchorPointToolHandler","./AnchorPointToolGizmo"],function(T,A,a){"use strict";
var b=T.extend("sap.ui.vk.tools.AnchorPointTool",{
metadata:{properties:{enableStepping:{type:"boolean",defaultValue:false},showEditingUI:{type:"boolean",defaultValue:false},enableRotation:{type:"boolean",defaultValue:false}},events:{moving:{parameters:{x:"float",y:"float",z:"float"}},moved:{parameters:{x:"float",y:"float",z:"float"}},rotating:{parameters:{x:"float",y:"float",z:"float"}},rotated:{parameters:{x:"float",y:"float",z:"float"}}}},
constructor:function(i,s){T.apply(this,arguments);this._viewport=null;this._handler=new A(this);this._gizmo=null;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new a());};
b.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(c==null){c=this._viewport;}if(v){this._activateTool(c);}else{this._deactivateTool();}if(c){c.setShouldRenderFrame();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._gizmo=this.getGizmo();if(this._gizmo){this._gizmo.show(this._viewport,this);}this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler,10);o=true;}return o;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}}return this;};
b.prototype.setShowEditingUI=function(v){this.setProperty("showEditingUI",v,true);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.move=function(x,y,z){if(this._gizmo){this._gizmo.move(x,y,z);}if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.rotate=function(x,y,z){if(!this.getEnableRotation()){return this;}if(this._gizmo){this._gizmo.rotate(x,y,z);}if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/AnchorPointToolGizmo',["jquery.sap.global","../getResourceBundle","../threejs/thirdparty/three","./Gizmo","./AnchorPointToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,g,t,G,A,C,c){"use strict";
var d=G.extend("sap.ui.vk.tools.AnchorPointToolGizmo",{metadata:{library:"sap.ui.vk"}});
d.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(null,84);this._gizmoIndex=-1;this._handleIndex=-1;this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._sceneGizmo.add(l);this._sceneGizmo.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._touchAreas=new THREE.Group();this._gizmo=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoOffset=new THREE.Vector3();this._gizmoRotation=new THREE.Vector3();function f(a,b,p){var r=144,s=window.devicePixelRatio*0.5,u=32,v=6,w=48;a.multiplyScalar(1/r);var x=new THREE.CylinderBufferGeometry(s,s,r-u,4);var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(a.y,a.z,a.x),a,new THREE.Vector3(a.z,a.x,a.y));m.setPosition(a.clone().multiplyScalar((r-u)*0.5));x.applyMatrix(m);var y=new THREE.MeshLambertMaterial({color:b,transparent:true});var z=new THREE.Mesh(x,y);z.matrixAutoUpdate=false;z.userData.color=b;var B=new THREE.CylinderBufferGeometry(0,v,u,12,1);m.setPosition(a.clone().multiplyScalar(r-u*0.5));B.applyMatrix(m);var D=new THREE.Mesh(B,y);D.matrixAutoUpdate=false;z.add(D);var E=new THREE.CylinderGeometry(w*0.5,w*0.5,w,12,1);E.applyMatrix(m);var F=new THREE.CylinderGeometry(w*0.5,w*0.2,w,12,1);m.setPosition(a.clone().multiplyScalar(r*0.5));E.merge(F,m);p.add(new THREE.Mesh(E,y));return z;}function h(a,b,m){var p=new Float32Array(9);p[a]=p[b+6]=1;p[a+3]=p[b+3]=0.5;var v=new THREE.Vector3().setComponent(a,0.333);var r=new THREE.Vector3().setComponent(b,0.333);var o=new THREE.Geometry();o.vertices.push(new THREE.Vector3(),v,r,v.clone().add(r));o.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));var s=new THREE.MeshBasicMaterial({color:0xFFFF00,opacity:0.5,transparent:true,visible:false,side:THREE.DoubleSide});var u=new THREE.Mesh(o,s);u.matrixAutoUpdate=false;u.userData.colors=p;var w=new THREE.BufferGeometry();var x=new Float32Array(9);x[a]=x[a+3]=x[b+3]=x[b+6]=0.333;w.addAttribute("position",new THREE.Float32BufferAttribute(x,3));w.addAttribute("color",new THREE.Float32BufferAttribute(p,3));var y=new THREE.Line(w,new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,transparent:true,linewidth:window.devicePixelRatio}));y.matrixAutoUpdate=false;u.add(y);var z=new THREE.Geometry();z.vertices.push(new THREE.Vector3(),v,r,v.clone().add(r));z.faces.push(new THREE.Face3(0,1,2),new THREE.Face3(2,1,3));m.add(new THREE.Mesh(z,new THREE.MeshBasicMaterial({side:THREE.DoubleSide})));return u;}function j(a,b,r,s){var o=new THREE.TorusBufferGeometry(r,window.devicePixelRatio/288,4,s,Math.PI/2);if(a===0){o.rotateY(Math.PI/-2);}else if(a===1){o.rotateX(Math.PI/2);}var m=new THREE.Mesh(o,new THREE.MeshBasicMaterial({color:b,transparent:true}));m.matrixAutoUpdate=false;m.userData.color=b;return m;}function k(a,r,s){var o=new THREE.TorusBufferGeometry(r,24/144,4,s,Math.PI/2);if(a===0){o.rotateY(Math.PI/-2);}else if(a===1){o.rotateX(Math.PI/2);}return new THREE.Mesh(o,new THREE.MeshBasicMaterial({opacity:0.2,transparent:true}));}this._gizmo.add(f(new THREE.Vector3(1,0,0),c.x,this._touchAreas));this._gizmo.add(f(new THREE.Vector3(0,1,0),c.y,this._touchAreas));this._gizmo.add(f(new THREE.Vector3(0,0,1),c.z,this._touchAreas));this._gizmo.add(h(1,2,this._touchAreas));this._gizmo.add(h(2,0,this._touchAreas));this._gizmo.add(h(0,1,this._touchAreas));for(var i=0;i<3;i++){this._gizmo.add(j(i,0xFF<<8*(2-i),1,32));this._touchAreas.add(k(i,1,24));}var n=new THREE.MeshBasicMaterial({color:0x0080FF,opacity:0.5,transparent:true,side:THREE.DoubleSide});this._arcMesh=new THREE.Mesh(new THREE.Geometry(),n);this._arcMesh.drawMode=THREE.TriangleFanDrawMode;this._arcMesh.visible=false;this._gizmo.add(this._arcMesh);this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);var o=new THREE.Geometry();o.vertices.push(new THREE.Vector3(),new THREE.Vector3());this._line=new THREE.LineSegments(o,new THREE.LineBasicMaterial());this._line.frustumCulled=false;this._line.visible=false;this._gizmo.add(this._line);};
d.prototype.hasDomElement=function(){return true;};
d.prototype.show=function(v,a){this._viewport=v;this._tool=a;var b=this._tool.getEnableRotation();for(var i=6;i<9;i++){this._gizmo.children[i].visible=this._touchAreas.children[i].visible=b;}var f=v.getScene().getSceneRef().userData.anchorPoint;if(f){this._gizmo.position.copy(f.position);this._gizmo.quaternion.copy(f.quaternion);}else{v.getScene().getSceneRef().userData.anchorPoint=this._gizmo;}};
d.prototype.hide=function(){this._viewport=null;this._tool=null;};
d.prototype.setPosition=function(p){this._gizmo.position.copy(p);this._viewport.setShouldRenderFrame();};
d.prototype.getGizmoCount=function(){return 1;};
d.prototype.getTouchObject=function(i){this._touchAreas.position.copy(this._gizmo.position);this._touchAreas.quaternion.copy(this._gizmo.quaternion);this._touchAreas.scale.copy(this._gizmo.scale);this._touchAreas.updateMatrixWorld(true);return this._touchAreas;};
var e=[1,2,4,6,5,3,1,2,4];
d.prototype.highlightHandle=function(a,h){var i;for(i=0;i<3;i++){var b=this._gizmo.children[i];var f=e[a]&(1<<i);var j=f?0xFFFF00:b.userData.color;b.material.color.setHex(j);b.children[0].material.color.setHex(j);this._axisTitles.children[i].material.color.setHex(j);}for(i=3;i<6;i++){var p=this._gizmo.children[i];p.material.visible=i===a;var k=p.children[0].geometry.attributes.color;k.copyArray(i===a?[1,1,0,1,1,0,1,1,0]:p.userData.colors);k.needsUpdate=true;p.children[0].material.opacity=(i===a||(h&&a===-1))?1:0.35;p.children[0].visible=(i===a||h);}for(i=6;i<9;i++){var l=this._gizmo.children[i];l.visible=this._tool.getEnableRotation()&&(i===a||h);l.material.color.setHex(i===a?0xFFFF00:l.userData.color);l.material.opacity=(i===a||(h&&a===-1))?1:0.35;}};
d.prototype.selectHandle=function(i){this._handleIndex=i;if(i>=0&&i<3){this._units.setText(g().getText("TOOL_UNITS_MM"));}else if(i>=6&&i<9){this._units.setText(String.fromCharCode(176));}this._editingForm.rerender();this._viewport.setShouldRenderFrame();};
d.prototype.beginGesture=function(){this._isMoved=false;this._isRotated=false;this._originPosition=new THREE.Vector3().setFromMatrixPosition(this._gizmo.matrixWorld);this._originQuaternion=this._gizmo.quaternion.clone();};
d.prototype.endGesture=function(){if(this._isMoved){this._tool.fireMoved({x:this._gizmoOffset.x,y:this._gizmoOffset.y,z:this._gizmoOffset.z});}if(this._isRotated){this._tool.fireRotated({x:this._gizmoRotation.x,y:this._gizmoRotation.y,z:this._gizmoRotation.z});}this._line.visible=false;this._arcMesh.visible=false;};
d.prototype._setOffset=function(o,a){if(this._tool.fireEvent("moving",{x:o.x,y:o.y,z:o.z},true)){this._move(o);var m=new THREE.Matrix4().getInverse(this._gizmo.matrixWorld);var s=new THREE.Vector3().setFromMatrixScale(this._gizmo.matrixWorld);var n=this._gizmo.position.clone().applyMatrix4(m);o.copy(this._originPosition).applyMatrix4(m).sub(n).multiply(s);this._line.geometry.vertices[0].copy(o);this._line.geometry.verticesNeedUpdate=true;this._line.geometry.computeBoundingBox();o.set(Math.abs(o.x),Math.abs(o.y),Math.abs(o.z));o.multiplyScalar(1/Math.max(o.x,o.y,o.z));this._line.material.color.setRGB(o.x,o.y,o.z);this._line.visible=true;}};
d.prototype._move=function(o){this._isMoved=true;this._gizmoOffset.copy(o);this._gizmo.position.copy(this._originPosition).add(o);this._viewport.setShouldRenderFrame();};
d.prototype.move=function(x,y,z){this.beginGesture();this._move(new THREE.Vector3(x,y,z||0));};
d.prototype._setRotationAxisAngle=function(b,f,h){var j=h-f;if(Math.abs(j)>Math.PI){j-=Math.PI*2*Math.sign(j);}var k=[0,0,0];k[b]=j;k=new THREE.Euler().fromArray(k);if(this._tool.fireEvent("rotating",{x:THREE.Math.radToDeg(k.x),y:THREE.Math.radToDeg(k.y),z:THREE.Math.radToDeg(k.z)},true)){this._rotate(k);var v=[0,0,0];var l=new THREE.Vector3();var m=(b+1)%3,o=(b+2)%3;var n=Math.max(Math.ceil(Math.abs(j)*64/Math.PI),1);for(var i=0;i<=n;i++){var a=f-j*(i/n);l.set(0,0,0).setComponent(m,Math.cos(a)).setComponent(o,Math.sin(a));v.push(l.x,l.y,l.z);}this._arcMesh.geometry=new THREE.BufferGeometry().addAttribute("position",new THREE.Float32BufferAttribute(v,3));this._arcMesh.visible=true;}};
d.prototype._rotate=function(a){this._isRotated=true;this._gizmoRotation.set(THREE.Math.radToDeg(a.x),THREE.Math.radToDeg(a.y),THREE.Math.radToDeg(a.z));var b=new THREE.Quaternion().setFromEuler(a);this._gizmo.quaternion.copy(this._originQuaternion).multiply(b);this._viewport.setShouldRenderFrame();};
d.prototype.rotate=function(x,y,z){this.beginGesture();this._rotate(new THREE.Euler(THREE.Math.degToRad(x||0),THREE.Math.degToRad(y||0),THREE.Math.degToRad(z||0)));};
d.prototype.getValue=function(){if(this._handleIndex>=0&&this._handleIndex<3){var a=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return a.dot(this._gizmo.position);}if(this._handleIndex>=6&&this._handleIndex<9){return THREE.Math.radToDeg(this._gizmo.rotation.reorder("YXZ")[["x","y","z"][this._handleIndex-6]]);}return 0;};
d.prototype.setValue=function(v){if(this._handleIndex>=0&&this._handleIndex<3){this.beginGesture();var o=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize().multiplyScalar(v-this._lastEditValue);this._move(o);this.endGesture();}else if(this._handleIndex>=6&&this._handleIndex<9){this.beginGesture();var a=this._gizmo.rotation.clone();a[["x","y","z"][this._handleIndex-6]]=THREE.Math.degToRad(v);var b=new THREE.Quaternion().setFromEuler(a);var f=this._gizmo.quaternion.clone().inverse().multiply(b);a.setFromQuaternion(f);this._rotate(a);this.endGesture();}};
d.prototype.expandBoundingBox=function(b){if(this._viewport){this._expandBoundingBox(b,this._viewport.getCamera().getCameraRef());}};
d.prototype._updateGizmoTransformation=function(i,a){this._matViewProj.multiplyMatrices(a.projectionMatrix,a.matrixWorldInverse);var s=this._getGizmoScale(this._gizmo.position);this._gizmo.scale.setScalar(this._gizmoSize*s);this._gizmo.updateMatrixWorld(true);this._updateAxisTitles(this._axisTitles,this._gizmo,a,this._gizmoSize+18,s);this._line.scale.setScalar(1/(this._gizmoSize*s));};
d.prototype._getEditingFormPosition=function(){var s=this._getGizmoScale(this._gizmo.position);var a=new THREE.Vector3();if(this._handleIndex>=0&&this._handleIndex<3){a.setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();}else if(this._handleIndex>=6&&this._handleIndex<9){var i=this._handleIndex%3;var b=this._extractBasis(this._gizmo.matrixWorld);a.copy(b[(i+1)%3]).add(b[(i+2)%3]).normalize();}return a.clone().multiplyScalar((this._gizmoSize+18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};
d.prototype.render=function(){var r=this._viewport.getRenderer(),a=this._viewport.getCamera().getCameraRef();r.clearDepth();this._updateGizmoTransformation(0,a);r.render(this._sceneGizmo,a);this._updateEditingForm((this._handleIndex>=0&&this._handleIndex<3)||(this._handleIndex>=6&&this._handleIndex<9),this._handleIndex%3);};
return d;});
sap.ui.predefine('sap/ui/vk/tools/AnchorPointToolGizmoRenderer',[],function(){"use strict";var A={};
A.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkTransformationToolEdit");r.writeClasses();r.write(">");r.renderControl(c._editingForm);r.write("</div>");};
return A;},true);
sap.ui.predefine('sap/ui/vk/tools/AxisColours',[],function(){"use strict";var A={x:0xFF2222,y:0x00A745,z:0x488AF7};return A;},true);
sap.ui.predefine('sap/ui/vk/tools/CoordinateSystem',[],function(){"use strict";var C={Local:"Local",World:"World",Screen:"Screen",Custom:"Custom"};return C;},true);
sap.ui.predefine('sap/ui/vk/tools/CrossSectionTool',["./Tool","./CrossSectionToolHandler","./CrossSectionToolGizmo"],function(T,C,a){"use strict";
var b=T.extend("sap.ui.vk.tools.CrossSectionTool",{
metadata:{properties:{showEditingUI:{type:"boolean",defaultValue:false}}},
constructor:function(i,s){if(b._instance){return b._instance;}T.apply(this,arguments);this._viewport=null;this._handler=new C(this);this._gizmo=null;b._instance=this;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new a());};
b.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}if(c){c.setShouldRenderFrame();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._gizmo=this.getGizmo();if(this._gizmo){this._gizmo.show(this._viewport,this);}this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler,20);o=true;}return o;};
b.prototype.setAxis=function(i){if(this._gizmo){this._gizmo.setAxis(i);}return this;};
b.prototype.setFlip=function(f){if(this._gizmo){this._gizmo.setFlip(f);}return this;};
b.prototype.getFlip=function(){return this._gizmo?this._gizmo._flip:undefined;};
b.prototype.setShowEditingUI=function(v){this.setProperty("showEditingUI",v,true);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/CrossSectionToolGizmo',["jquery.sap.global","../getResourceBundle","../threejs/thirdparty/three","./Gizmo","./AxisColours"],function(q,g,t,G,A){"use strict";
var C=G.extend("sap.ui.vk.tools.CrossSectionToolGizmo",{metadata:{library:"sap.ui.vk"}});
C.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(g().getText("TOOL_UNITS_MM"),84);this._handleIndex=-1;this._viewport=null;this._tool=null;this._position=new THREE.Vector3(0,0,0);this._plane=new THREE.Plane(new THREE.Vector3(0,0,1),0);this._flip=false;this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._firstShowPress=true;this.setAxis(0);};
C.prototype.hasDomElement=function(){return true;};
C.prototype.show=function(v,a){this._viewport=v;this._tool=a;if(this._firstShowPress){var b=v._scene?v._scene._computeBoundingBox(true,true):new THREE.Box3();b.getCenter(this._position);this._firstShowPress=false;}this._plane.constant=-this._plane.normal.dot(this._position);v.setClippingPlanes([this._plane]);};
C.prototype.hide=function(){if(this._viewport){this._viewport.setClippingPlanes([]);this._viewport=null;}this._handleIndex=-1;this._tool=null;this._updateEditingForm(false,-1);};
C.prototype._getOffset=function(){return this._position.getComponent(this._axis);};
C.prototype.getAxis=function(){return this._axis;};
C.prototype.setAxis=function(i){this._handleIndex=-1;this._axis=i;var d=new THREE.Vector3().setComponent(i,1);this._plane.normal.set(0,0,0).setComponent(i,this._flip?-1:1);this._plane.constant=-this._plane.normal.dot(this._position);var a=new THREE.BufferGeometry();var v=new Array(15);var b=new THREE.Vector3(d.y,d.z,d.x),c=new THREE.Vector3(d.z,d.x,d.y),p=new THREE.Vector3();p.sub(b).sub(c).multiplyScalar(0.5).toArray(v,0);p.toArray(v,12);p.add(b).toArray(v,3);p.add(c).toArray(v,6);p.sub(b).toArray(v,9);a.addAttribute("position",new THREE.Float32BufferAttribute(v,3));this._gizmoPlane=new THREE.Line(a,new THREE.LineBasicMaterial({color:0x404040,transparent:true,linewidth:window.devicePixelRatio}));var e=144,l=window.devicePixelRatio*0.5,f=32,h=6,j=48;d=this._plane.normal.clone().multiplyScalar(1/e);var k=0;switch(i){case 0:k=A.x;break;case 1:k=A.y;break;case 2:k=A.z;break;default:break;}var n=new THREE.CylinderBufferGeometry(l,l,e-f,4);var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(d.y,d.z,d.x),d,new THREE.Vector3(d.z,d.x,d.y));m.setPosition(d.clone().multiplyScalar((e-f)*0.5));n.applyMatrix(m);this._gizmoArrow=new THREE.Mesh(n,new THREE.MeshBasicMaterial({color:k}));this._gizmoArrow.userData.color=k;var o=new THREE.CylinderBufferGeometry(0,h,f,12,1);m.setPosition(d.clone().multiplyScalar(e-f*0.5));o.applyMatrix(m);var r=new THREE.Mesh(o,new THREE.MeshBasicMaterial({color:k}));r.matrixAutoUpdate=false;this._gizmoArrow.add(r);var u=new THREE.CylinderGeometry(j*0.5,j*0.5,e,12,1);m.setPosition(d.clone().multiplyScalar(e*0.5));u.applyMatrix(m);this._touchMesh=new THREE.Mesh(u,new THREE.MeshBasicMaterial({visible:false,side:THREE.DoubleSide}));this._gizmoArrow.add(this._touchMesh);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
C.prototype.setFlip=function(f){this._flip=!!f;var h=this._handleIndex;this.setAxis(this._axis);this._handleIndex=h;return this;};
C.prototype.getTouchObject=function(){return this._touchMesh;};
var s=new THREE.Vector3();
C.prototype._getDelta=function(){var b=this._viewport._scene._computeBoundingBox(true,true);b.getSize(s);return Math.max(s.x,s.y,s.z);};
C.prototype._setOffset=function(o){var b=this._viewport._scene._computeBoundingBox(true,true);o=THREE.Math.clamp(o,b.min.getComponent(this._axis),b.max.getComponent(this._axis));this._position.setComponent(this._axis,o);this._plane.constant=-this._plane.normal.dot(this._position);this._viewport.setShouldRenderFrame();};
C.prototype.getValue=function(){return this._position.getComponent(this._handleIndex);};
C.prototype.setValue=function(v){if(this._handleIndex>=0){this._position.setComponent(this._handleIndex,v);this._plane.constant=v;this._viewport.setShouldRenderFrame();}};
C.prototype.highlightArrowHandle=function(h){var c=h?0xFFFF00:this._gizmoArrow.userData.color;this._gizmoArrow.material.color.setHex(c);this._gizmoArrow.children[0].material.color.setHex(c);};
C.prototype.selectHandle=function(i){this._handleIndex=i;this._viewport.setShouldRenderFrame();};
C.prototype._adjustBoundingBox=function(b){b.getSize(s);var d=Math.max(s.x,s.y,s.z)*0.2;b.expandByScalar(d);};
C.prototype._updateGizmo=function(b){var i=this._axis;var o=THREE.Math.clamp(this._position.getComponent(i),b.min.getComponent(i),b.max.getComponent(i));this._position.setComponent(i,o);this._plane.constant=-this._plane.normal.dot(this._position);this._adjustBoundingBox(b);b.getCenter(this._gizmoPlane.position);this._gizmoPlane.position.setComponent(i,o);b.getSize(this._gizmoPlane.scale);this._gizmoPlane.updateMatrixWorld(true);var c=this._viewport.getCamera().getCameraRef();this._gizmoArrow.position.copy(this._gizmoPlane.position);this._matViewProj.multiplyMatrices(c.projectionMatrix,c.matrixWorldInverse);this._gizmoArrow.scale.setScalar(this._gizmoSize*this._getGizmoScale(this._gizmoArrow.position));this._gizmoArrow.updateMatrixWorld(true);};
C.prototype.expandBoundingBox=function(b){if(this._viewport){var a=this._viewport._scene._computeBoundingBox(true,true);this._updateGizmo(a);b.min.min(a.min);b.max.max(a.max);b.expandByPoint(this._plane.normal.clone().multiply(this._gizmoArrow.scale).add(this._gizmoArrow.position));}};
C.prototype._getEditingFormPosition=function(){return this._plane.normal.clone().applyMatrix4(this._gizmoArrow.matrixWorld).applyMatrix4(this._matViewProj);};
C.prototype.render=function(){var a=this._viewport._scene._computeBoundingBox(true,true);this._updateGizmo(a);var r=this._viewport.getRenderer(),c=this._viewport.getCamera().getCameraRef();r.render(this._gizmoPlane,c);r.clearDepth();r.render(this._gizmoArrow,c);this._gizmo=this._gizmoArrow;this._updateEditingForm(this._handleIndex>=0,this._handleIndex);};
return C;});
sap.ui.predefine('sap/ui/vk/tools/CrossSectionToolGizmoRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkTransformationToolEdit");r.writeClasses();r.write(">");r.renderControl(c._editingForm);r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/vk/tools/CrossSectionToolHandler',["sap/ui/base/EventProvider"],function(E){"use strict";
var C=E.extend("sap.ui.vk.tools.CrossSectionToolHandler",{
metadata:{},
constructor:function(t){this._tool=t;this._gizmo=t.getGizmo();this._rect=null;this._mouse=new THREE.Vector2();this._rayCaster=new THREE.Raycaster();this._rayCaster.linePrecision=0;this._gizmoAxis=new THREE.Vector3();this._dragOrigin=new THREE.Vector2();this._dragOffset=0;this._dragDelta=0;}
});
C.prototype._updateRayCaster=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
C.prototype._updateArrowHandle=function(e){var t=this._gizmo.getTouchObject();var a=-1;if(e.n===1){this._updateRayCaster(e);var i=this._rayCaster.intersectObject(t,true);a=i.length>0?this._gizmo.getAxis():-1;}if(a!==this._axisIndex){this._axisIndex=a;this._gizmo.highlightArrowHandle(a>=0);if(a>=0){this._gizmoAxis.setScalar(0).setComponent(this._axisIndex,1);}this.getViewport().setShouldRenderFrame();}};
C.prototype.hover=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);e.handled|=this._axisIndex>=0;}};
C.prototype.click=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);this._gizmo.selectHandle(this._axisIndex);e.handled|=this._axisIndex>=0;}};
C.prototype.beginGesture=function(e){if(this._inside(e)&&!this._gesture){this._updateArrowHandle(e);this._gizmo.selectHandle(this._axisIndex);if(this._axisIndex>=0){this._gesture=true;e.handled=true;this._dragOrigin.set(e.x,e.y);this._dragOffset=this._gizmo._getOffset();this._dragDelta=this._gizmo._getDelta()/500;}}};
C.prototype.move=function(e){if(this._gesture){e.handled=true;this._updateRayCaster(e);var d=this._gizmoAxis.clone().applyQuaternion(this.getViewport().getCamera().getCameraRef().quaternion.clone().inverse());d.z=0;d.normalize();if(d.x===0&&d.y===0){d.y=1;}this._gizmo._setOffset(this._dragOffset+((e.x-this._dragOrigin.x)*d.x-(e.y-this._dragOrigin.y)*d.y)*this._dragDelta);}};
C.prototype.endGesture=function(e){if(this._gesture){this._gesture=false;e.handled=true;this._updateArrowHandle(e);}};
C.prototype.getViewport=function(){return this._tool._viewport;};
C.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
C.prototype._inside=function(e){if(this._rect===null||true){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d===null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};}return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return C;});
sap.ui.predefine('sap/ui/vk/tools/Gizmo',["../library","sap/m/library","sap/m/Input","sap/m/Label","./CoordinateSystem","./AxisColours","sap/ui/core/library","sap/ui/core/Control"],function(a,L,I,b,C,A,c,d){"use strict";var e=L.InputType;
var G=d.extend("sap.ui.vk.tools.Gizmo",{metadata:{library:"sap.ui.vk"}});
G.prototype.hasDomElement=function(){return true;};
G.prototype._createAxisTitles=function(s,f,g){s=s||32;f=f||20;function h(t,j){var k=document.createElement("canvas");k.width=k.height=s*window.devicePixelRatio;var l=k.getContext("2d");var m=k.width*0.5;l.font="Bold "+f*window.devicePixelRatio+"px Arial";l.textAlign="center";l.textBaseline="middle";l.fillStyle="#000";l.globalAlpha=0.5;l.filter="blur(3px)";l.fillText(t,m+1,m+1);l.fillStyle="#fff";l.globalAlpha=1;l.filter="blur(0px)";l.fillText(t,m,m);if(g){l.beginPath();l.arc(m,m,m-window.devicePixelRatio,0,2*Math.PI,false);l.closePath();l.lineWidth=window.devicePixelRatio*2;l.strokeStyle="#fff";l.stroke();}var n=new THREE.Texture(k);n.needsUpdate=true;var o=new THREE.MeshBasicMaterial({map:n,color:j,transparent:true,alphaTest:0.05,premultipliedAlpha:true,side:THREE.DoubleSide});var p=new THREE.Mesh(new THREE.PlaneGeometry(s,s),o);p.userData.color=j;return p;}var i=new THREE.Group();i.add(h("X",A.x));i.add(h("Y",A.y));i.add(h("Z",A.z));return i;};
G.prototype._extractBasis=function(m){var f=[new THREE.Vector3(),new THREE.Vector3(),new THREE.Vector3()];m.extractBasis(f[0],f[1],f[2]);f[0].normalize();f[1].normalize();f[2].normalize();return f;};
G.prototype._updateAxisTitles=function(o,g,f,h,s){var j=this._extractBasis(g.matrixWorld);o.children.forEach(function(k,i){k.position.copy(j[i]).multiplyScalar(h.constructor===THREE.Vector3?h.getComponent(i):h);k.quaternion.copy(f.quaternion);});o.position.copy(g.position);o.scale.setScalar(s);};
G.prototype._updateSelection=function(f){var n=[];f.enumerateSelection(function(g){n.push({node:g});});if(this._nodes.length===n.length&&this._nodes.every(function(v,i){return n[i].node===v.node;})){return false;}this._nodes=n;n.forEach(function(g){g.ignore=false;var p=g.node.parent;while(p&&!g.ignore){for(var i=0,l=n.length;i<l;i++){if(n[i].node===p){g.ignore=true;break;}}p=p.parent;}});return true;};
G.prototype._getAnchorPoint=function(){return this._viewport&&this._viewport.getScene()?this._viewport.getScene().getSceneRef().userData.anchorPoint:null;};
G.prototype._getSelectionCenter=function(t){if(this._nodes.length===1){t.setFromMatrixPosition(this._nodes[0].node.matrixWorld);}else{t.setScalar(0);if(this._nodes.length>0){var f=new THREE.Vector3();this._nodes.forEach(function(n){var g=n.node;if(g.userData.boundingBox){g.userData.boundingBox.getCenter(f);t.add(f.applyMatrix4(g.matrixWorld));}else{t.add(f.setFromMatrixPosition(g.matrixWorld));}});t.multiplyScalar(1/this._nodes.length);}}};
G.prototype._getGizmoScale=function(p){var r=this._viewport.getRenderer();var f=this._viewport.getCamera().getCameraRef();var g=new THREE.Vector4();g.copy(p).applyMatrix4(this._matViewProj);return g.w*r.getPixelRatio()/(r.getSize().width*f.projectionMatrix.elements[0]);};
G.prototype._updateGizmoObjectTransformation=function(o,i){var f=this._viewport.getCamera().getCameraRef();var g=this._getAnchorPoint();var n;if(g&&this._coordinateSystem===C.Custom){o.position.copy(g.position);o.quaternion.copy(g.quaternion);}else if(this._coordinateSystem===C.Local){n=this._nodes[i].node;n.matrixWorld.decompose(o.position,o.quaternion,o.scale);}else if(this._nodes.length>0){this._getSelectionCenter(o.position);if(this._coordinateSystem===C.Screen){o.quaternion.copy(f.quaternion);}else{o.quaternion.set(0,0,0,1);}}var s=this._getGizmoScale(o.position);o.scale.setScalar(this._gizmoSize*s);if(n){var h=this._extractBasis(n.matrixWorld);o.matrix.makeBasis(h[0],h[1],h[2]);o.matrix.scale(o.scale);o.matrix.copyPosition(n.matrixWorld);o.matrixAutoUpdate=false;}else{o.matrixAutoUpdate=true;}o.updateMatrixWorld(true);return s;};
G.prototype._expandBoundingBox=function(f,g){var h=this.getGizmoCount();if(h>0){this._matViewProj.multiplyMatrices(g.projectionMatrix,g.matrixWorldInverse);for(var i=0;i<h;i++){this._updateGizmoTransformation(i,g);this._sceneGizmo._expandBoundingBox(f,true);}}};
G.prototype._createEditingForm=function(u,w){this._label=new sap.m.Label({}).addStyleClass("sapUiVkTransformationToolEditLabel");this._units=new sap.m.Label({text:u}).addStyleClass("sapUiVkTransformationToolEditUnits");this._input=new I({width:w+"px",type:e.Number,maxLength:10,textAlign:c.TextAlign.Right,change:function(f){this.setValue(f.getParameter("value"));}.bind(this)});this._editingForm=new sap.m.HBox({items:[this._label,this._input,this._units]}).addStyleClass("sapUiSizeCompact");this._editingForm.onkeydown=this._editingForm.ontap=this._editingForm.ontouchstart=function(f){f.setMarked();};};
G.prototype._updateEditingForm=function(f,g){var h=this.getDomRef();if(h){if(f&&this._tool&&this._tool.getShowEditingUI()){this._label.setText(["X","Y","Z"][g]);var l=this._label.getDomRef();if(l){l.style.color=new THREE.Color(A[["x","y","z"][g]]).getStyle();}this._lastEditValue=this.getValue();this._input.setValue(this._lastEditValue.toLocaleString("fullwide",{useGrouping:false}));var p=this._getEditingFormPosition();var i=this._gizmo.position.clone().applyMatrix4(this._matViewProj).sub(p);var v=this._viewport.getDomRef().getBoundingClientRect();var j=h.getBoundingClientRect();var k=Math.sign(i.x)*j.width;var m=j.height*0.5;var x=THREE.Math.clamp(v.width*(p.x*0.5+0.5)+Math.sign(i.x)*-20,Math.max(k,0),v.width+Math.min(k,0));var y=THREE.Math.clamp(v.height*(p.y*-0.5+0.5),m,v.height-m);h.style.left=Math.round(x)+"px";h.style.top=Math.round(y)+"px";h.style.transform="translate("+(i.x<0?"0%":"-100%")+", -50%)";h.style.display="block";}else{h.style.display="none";}}};
return G;});
sap.ui.predefine('sap/ui/vk/tools/HitTestClickType',[],function(){"use strict";var H={Single:"Single",Double:"Double",Context:"Context"};return H;},true);
sap.ui.predefine('sap/ui/vk/tools/HitTestIdMode',[],function(){"use strict";var H={ThreeJS:"ThreeJS",VEsID:"VEsID",Callback:"Callback"};return H;},true);
sap.ui.predefine('sap/ui/vk/tools/HitTestTool',["./Tool","./HitTestToolHandler","./HitTestIdMode"],function(T,H,a){"use strict";
var b=T.extend("sap.ui.vk.tools.HitTestTool",{
metadata:{properties:{IdMode:{type:"sap.ui.vk.tools.HitTestIdMode",defaultValue:a.ThreeJS}},events:{hit:{parameters:{id:"any",object:"any",point:"any",clickType:"sap.ui.vk.tools.HitTestClickType"}}}},
constructor:function(i,s){if(b._instance){return b._instance;}T.apply(this,arguments);this.setToolid("63150593-75f6-c330-2a7a-c1f85d36b2b9");this._viewport=null;this._handler=new H(this);this._loco=null;b._instance=this;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler);o=true;}if(o){if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){this._dvlRendererId=this._viewport._dvlRendererId;this._dvl=this._viewport._dvl;o=true;}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")&&(this._viewport._scene&&this._viewport._scene.getSceneRef())){o=true;}}return o;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this._dvlRendererId){this._dvl.Renderer._queueCommand(c,this._dvlRendererId);}}return this;};
b.prototype.hitTest=function(x,y,s,c,d){if(this._prepare()){var h=null;if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){return null;}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")){if(!s||!c){h=null;}else if(this._viewport._renderer){var e=this._viewport._renderer.domElement;var m=new THREE.Vector2((x-e.offsetLeft)/e.clientWidth*2-1,(e.offsetTop-y)/e.clientHeight*2+1);var r=new THREE.Raycaster();r.setFromCamera(m,c.getCameraRef());var i=r.intersectObjects(s.getSceneRef().children,true);if(i&&i.length){h=i[0];}}}var f=null;if(h){var g;switch(this.getIdMode()){case a.VEsID:g=this._viewport._scene.nodeRefToPersistentId(h.object);break;case a.ThreeJS:g=h.object.id;break;default:g=h.object.id;break;}f={id:g,object:h.object,point:h.point,clickType:d};this.fireHit(f);}return f;}};
return b;});
sap.ui.predefine('sap/ui/vk/tools/HitTestToolHandler',["sap/ui/base/EventProvider","./HitTestClickType"],function(E,H){"use strict";
var a=E.extend("sap.ui.vk.tools.HitTestToolHandler",{
metadata:{},
constructor:function(T){this._tool=T;this._rect=null;this._gesture=false;this._nomenu=false;}
});
a.prototype.destroy=function(){this._tool=null;this._rect=null;this._gesture=false;};
a.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
a.prototype._inside=function(e){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d==null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
a.prototype.beginGesture=function(e){e.handled=false;};
a.prototype.move=function(e){e.handled=false;};
a.prototype.endGesture=function(e){e.handled=false;};
a.prototype._executeHittest=function(e,c){if(this._inside(e)&&!this._gesture){this._gesture=false;var x=e.x-this._rect.x,y=e.y-this._rect.y;this._gizmo=this._tool.getGizmo();if(this._gizmo){this._gizmo.show(this._tool._viewport);this._gizmo.moveGizmo(x,y);}var s=this._tool._viewport.getScene();var b=this._tool._viewport.getCamera();this._tool.hitTest(x,y,s,b,c);if(this._gizmo){this._gizmo.hide();}}};
a.prototype.click=function(e){this._executeHittest(e,H.Single);e.handled=true;};
a.prototype.doubleClick=function(e){this._executeHittest(e,H.Double);e.handled=false;};
a.prototype.contextMenu=function(e){this._executeHittest(e,H.Context);e.handled=false;};
a.prototype.getViewport=function(){return this._tool._viewport;};
return a;});
sap.ui.predefine('sap/ui/vk/tools/MoveTool',["./Tool","./CoordinateSystem","./MoveToolHandler","./MoveToolGizmo"],function(T,C,M,a){"use strict";
var b=T.extend("sap.ui.vk.tools.MoveTool",{
metadata:{properties:{coordinateSystem:{type:"sap.ui.vk.tools.CoordinateSystem",defaultValue:C.World},enableStepping:{type:"boolean",defaultValue:false},showEditingUI:{type:"boolean",defaultValue:false}},events:{moving:{parameters:{x:"float",y:"float",z:"float"}},moved:{parameters:{x:"float",y:"float",z:"float"}},coordinateSystemChanged:{parameters:{coordinateSystem:"sap.ui.vk.tools.CoordinateSystem"}}}},
constructor:function(i,s){T.apply(this,arguments);this._viewport=null;this._handler=new M(this);this._gizmo=null;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new a());};
b.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}if(c){c.setShouldRenderFrame();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._gizmo=this.getGizmo();this._gizmo.setCoordinateSystem(this.getCoordinateSystem());this._gizmo.show(this._viewport,this);this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler,13);o=true;}return o;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}}return this;};
b.prototype.setCoordinateSystem=function(v){var c=this.getCoordinateSystem();if(c!==v){this.setProperty("coordinateSystem",v,true);this.getGizmo().setCoordinateSystem(v);if(this._viewport){this._viewport.setShouldRenderFrame();}this.fireCoordinateSystemChanged({coordinateSystem:v});}return this;};
b.prototype.setShowEditingUI=function(v){this.setProperty("showEditingUI",v,true);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.move=function(x,y,z){if(this._gizmo){this._gizmo.move(x,y,z);}if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/MoveToolGizmo',["jquery.sap.global","../getResourceBundle","../threejs/thirdparty/three","./Gizmo","./MoveToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,g,t,G,M,C,A){"use strict";
var c=G.extend("sap.ui.vk.tools.MoveToolGizmo",{metadata:{library:"sap.ui.vk"}});
c.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(g().getText("TOOL_UNITS_MM"),84);this._gizmoIndex=-1;this._handleIndex=-1;this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._sceneGizmo.add(l);this._sceneGizmo.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._gizmo=new THREE.Group();this._touchAreas=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._coordinateSystem=C.World;this._nodes=[];this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoOffset=new THREE.Vector3();function e(a,b,i){var j=144,k=window.devicePixelRatio*0.5,n=32,o=6,p=48;a.multiplyScalar(1/j);var r=new THREE.MeshLambertMaterial({color:b,transparent:true});var s=new THREE.CylinderBufferGeometry(k,k,j-n,4);var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(a.y,a.z,a.x),a,new THREE.Vector3(a.z,a.x,a.y));m.setPosition(a.clone().multiplyScalar((j-n)*0.5));s.applyMatrix(m);var u=new THREE.Mesh(s,r);u.matrixAutoUpdate=false;u.userData.color=b;var v=new THREE.CylinderBufferGeometry(0,o,n,12,1);m.setPosition(a.clone().multiplyScalar(j-n*0.5));v.applyMatrix(m);var w=new THREE.Mesh(v,r);w.matrixAutoUpdate=false;u.add(w);var x=new THREE.CylinderGeometry(p*0.5,p*0.5,p,12,1);x.applyMatrix(m);var y=new THREE.CylinderGeometry(p*0.5,p*0.2,p,12,1);m.setPosition(a.clone().multiplyScalar(j*0.5));x.merge(y,m);i.add(new THREE.Mesh(x,r));return u;}function f(a,b,i){var j=new Float32Array(9);j[a]=j[b+6]=1;j[a+3]=j[b+3]=0.5;var v=new THREE.Vector3().setComponent(a,0.333);var k=new THREE.Vector3().setComponent(b,0.333);var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(),v,k,v.clone().add(k));h.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));var m=new THREE.MeshBasicMaterial({color:0xFFFF00,opacity:0.5,transparent:true,visible:false,side:THREE.DoubleSide});var p=new THREE.Mesh(h,m);p.matrixAutoUpdate=false;p.userData.colors=j;var n=new THREE.BufferGeometry();var o=new Float32Array(9);o[a]=o[a+3]=o[b+3]=o[b+6]=0.333;n.addAttribute("position",new THREE.Float32BufferAttribute(o,3));n.addAttribute("color",new THREE.Float32BufferAttribute(j,3));var r=new THREE.Line(n,new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,transparent:true,linewidth:window.devicePixelRatio}));r.matrixAutoUpdate=false;p.add(r);var s=new THREE.Geometry();s.vertices.push(new THREE.Vector3(),v,k,v.clone().add(k));s.faces.push(new THREE.Face3(0,1,2),new THREE.Face3(2,1,3));i.add(new THREE.Mesh(s,new THREE.MeshBasicMaterial({side:THREE.DoubleSide})));return p;}this._gizmo.add(e(new THREE.Vector3(1,0,0),A.x,this._touchAreas));this._gizmo.add(e(new THREE.Vector3(0,1,0),A.y,this._touchAreas));this._gizmo.add(e(new THREE.Vector3(0,0,1),A.z,this._touchAreas));this._gizmo.add(f(1,2,this._touchAreas));this._gizmo.add(f(2,0,this._touchAreas));this._gizmo.add(f(0,1,this._touchAreas));this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(),new THREE.Vector3());this._line=new THREE.LineSegments(h,new THREE.LineBasicMaterial());this._line.frustumCulled=false;this._line.visible=false;this._gizmo.add(this._line);};
c.prototype.hasDomElement=function(){return true;};
c.prototype.setCoordinateSystem=function(a){this._coordinateSystem=a;var s=a===C.Screen;var b=this._gizmo.children,e=this._touchAreas.children;b[2].visible=b[3].visible=b[4].visible=!s;e[2].visible=e[3].visible=e[4].visible=!s;this._axisTitles.children[2].visible=!s;this._gizmoIndex=this._handleIndex=-1;};
c.prototype.show=function(v,a){this._viewport=v;this._tool=a;this._nodes.length=0;this._updateSelection(v._viewStateManager);};
c.prototype.hide=function(){this._viewport=null;this._tool=null;this._gizmoIndex=this._handleIndex=-1;this._updateEditingForm(false);};
c.prototype.getGizmoCount=function(){if(this._coordinateSystem===C.Local){return this._nodes.length;}else{return this._nodes.length>0?1:0;}};
c.prototype.getTouchObject=function(i){if(this._nodes.length===0){return null;}this._updateGizmoObjectTransformation(this._touchAreas,i);return this._touchAreas;};
var d=[1,2,4,6,5,3];
c.prototype.highlightHandle=function(a,h){var i;for(i=0;i<3;i++){var b=this._gizmo.children[i];var e=d[a]&(1<<i);var f=e?0xFFFF00:b.userData.color;b.material.color.setHex(f);b.material.opacity=(e||h)?1:0.35;b.children[0].material.color.setHex(f);b.children[0].material.opacity=(e||h)?1:0.35;var j=this._axisTitles.children[i];j.material.color.setHex(f);j.material.opacity=e||h?1:0.35;}for(i=3;i<6;i++){var p=this._gizmo.children[i];p.material.visible=i===a;var k=p.children[0].geometry.attributes.color;k.copyArray(i===a?[1,1,0,1,1,0,1,1,0]:p.userData.colors);k.needsUpdate=true;p.children[0].material.opacity=(i===a||h)?1:0.35;}};
c.prototype.selectHandle=function(i,a){this._gizmoIndex=a;this._handleIndex=i;this._viewport.setShouldRenderFrame();};
c.prototype.beginGesture=function(){this._matOrigin=this._gizmo.matrixWorld.clone();this._nodes.forEach(function(n){var a=n.node;n.matOrigin=a.matrixWorld.clone();n.originLocal=a.position.clone();n.origin=new THREE.Vector3().setFromMatrixPosition(a.matrixWorld);n.matParentInv=new THREE.Matrix4().getInverse(a.parent.matrixWorld);});};
c.prototype.endGesture=function(){this._line.visible=false;this._tool.fireMoved({x:this._gizmoOffset.x,y:this._gizmoOffset.y,z:this._gizmoOffset.z});};
c.prototype._setOffset=function(o,a){if(this._coordinateSystem===C.Local){var n=this._nodes[a];var m=new THREE.Matrix4().getInverse(n.node.matrixWorld);var s=new THREE.Vector3().setFromMatrixScale(n.node.matrixWorld);var b=n.origin.clone().applyMatrix4(m);o=n.origin.clone().add(o).applyMatrix4(m).sub(b).multiply(s);}else if(this._coordinateSystem===C.Screen){var e=this._viewport.getRenderer().getSize();var p=this._gizmo.position.clone().applyMatrix4(this._matViewProj);var f=this._gizmo.position.clone().add(o).applyMatrix4(this._matViewProj);o.set(Math.round((f.x-p.x)*0.5*e.width),Math.round((f.y-p.y)*0.5*e.height),0);}if(this._tool.fireEvent("moving",{x:o.x,y:o.y,z:o.z},true)){this._move(o);if(this._coordinateSystem===C.Screen){o.set(new THREE.Vector3().setFromMatrixColumn(this._matOrigin,0).normalize().dot(o),new THREE.Vector3().setFromMatrixColumn(this._matOrigin,1).normalize().dot(o),0);}else if(this._coordinateSystem===C.Custom){var h=this._getAnchorPoint();if(h){var i=new THREE.Matrix4().getInverse(h.matrixWorld);var j=new THREE.Vector3().setFromMatrixScale(h.matrixWorld);var k=h.position.clone().applyMatrix4(i);o.copy(h.position.clone().add(o).applyMatrix4(i).sub(k).multiply(j));}}this._line.geometry.vertices[0].setScalar(0).sub(o);this._line.geometry.verticesNeedUpdate=true;this._line.geometry.computeBoundingBox();o.set(Math.abs(o.x),Math.abs(o.y),Math.abs(o.z));o.multiplyScalar(1/Math.max(o.x,o.y,o.z));this._line.material.color.setRGB(o.x,o.y,o.z);this._line.visible=true;}};
c.prototype._move=function(o){this._gizmoOffset.copy(o);if(this._coordinateSystem===C.Local){this._nodes.forEach(function(n){var i=n.node;var j=this._extractBasis(i.matrixWorld);var p=n.origin.clone();p.add(j[0].multiplyScalar(o.x)).add(j[1].multiplyScalar(o.y)).add(j[2].multiplyScalar(o.z));i.matrixWorld.setPosition(p);i.matrix.multiplyMatrices(n.matParentInv,i.matrixWorld);i.position.setFromMatrixPosition(i.matrix);}.bind(this));}else{if(this._coordinateSystem===C.Screen){var s=this._viewport.getRenderer().getSize();var a=this._viewport.getCamera().getCameraRef();var b=new THREE.Vector4().copy(this._gizmo.position).applyMatrix4(this._matViewProj);var e=o.x*2*b.w/(a.projectionMatrix.elements[0]*s.width);var f=o.y*2*b.w/(a.projectionMatrix.elements[5]*s.height);o.setFromMatrixColumn(a.matrixWorld,0).multiplyScalar(e);o.add(new THREE.Vector3().setFromMatrixColumn(a.matrixWorld,1).multiplyScalar(f));}this._gizmo.position.setFromMatrixPosition(this._matOrigin).add(o);if(this._coordinateSystem===C.Custom){var h=this._getAnchorPoint();if(h){h.position.copy(this._gizmo.position);}}this._nodes.forEach(function(n){if(!n.ignore){var i=n.node;i.matrixWorld.setPosition(n.origin.clone().add(o));i.matrix.multiplyMatrices(n.matParentInv,i.matrixWorld);i.position.setFromMatrixPosition(i.matrix);}});}this._viewport.setShouldRenderFrame();};
c.prototype.move=function(x,y,z){this.beginGesture();this._move(new THREE.Vector3(x,y,z||0));};
c.prototype.getValue=function(){var v=0,p,o,a;if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){switch(this._coordinateSystem){default:case C.World:v=this._gizmo.position.getComponent(this._handleIndex);break;case C.Local:var n=this._nodes[this._gizmoIndex].node;p=new THREE.Vector3().setFromMatrixPosition(n.parent.matrixWorld);o=this._gizmo.position.clone().sub(p);a=new THREE.Vector3().setFromMatrixColumn(n.matrixWorld,this._handleIndex).normalize();v=a.dot(o);break;case C.Screen:var r=this._viewport.getRenderer();var s=r.getSize();p=this._gizmo.position.clone().applyMatrix4(this._matViewProj);p.x*=s.width*0.5;p.y*=s.height*0.5;v=p.getComponent(this._handleIndex);break;case C.Custom:var b=this._getAnchorPoint();if(b){p=new THREE.Vector3().setFromMatrixPosition(b.matrixWorld);o=this._gizmo.position.clone().sub(p);a=new THREE.Vector3().setFromMatrixColumn(b.matrixWorld,this._handleIndex).normalize();v=a.dot(o);}break;}}return v;};
c.prototype.setValue=function(v){if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){this.beginGesture();var o=new THREE.Vector3();if(this._coordinateSystem===C.Custom){var a=this._getAnchorPoint();if(a){o.setFromMatrixColumn(a.matrixWorld,this._handleIndex).normalize().multiplyScalar(v-this._lastEditValue);}}else{o.setComponent(this._handleIndex,v-this._lastEditValue);}this._move(o);this.endGesture();}};
c.prototype.expandBoundingBox=function(b){if(this._viewport){this._expandBoundingBox(b,this._viewport.getCamera().getCameraRef());}};
c.prototype.handleSelectionChanged=function(e){if(this._viewport){this._updateSelection(this._viewport._viewStateManager);this._gizmoIndex=this._handleIndex=-1;}};
c.prototype._updateGizmoTransformation=function(i,a){var s=this._updateGizmoObjectTransformation(this._gizmo,i);this._updateAxisTitles(this._axisTitles,this._gizmo,a,this._gizmoSize+18,s);this._line.scale.setScalar(1/(this._gizmoSize*s));};
c.prototype._getEditingFormPosition=function(){var s=this._updateGizmoObjectTransformation(this._gizmo,this._gizmoIndex);var a=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return a.clone().multiplyScalar((this._gizmoSize+18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};
c.prototype.render=function(){if(this._nodes.length>0){var r=this._viewport.getRenderer(),a=this._viewport.getCamera().getCameraRef();this._matViewProj.multiplyMatrices(a.projectionMatrix,a.matrixWorldInverse);r.clearDepth();for(var i=0,l=this.getGizmoCount();i<l;i++){this._updateGizmoTransformation(i,a);r.render(this._sceneGizmo,a);}}this._updateEditingForm(this._nodes.length>0&&this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3,this._handleIndex);};
return c;});
sap.ui.predefine('sap/ui/vk/tools/MoveToolGizmoRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkTransformationToolEdit");r.writeClasses();r.write(">");r.renderControl(c._editingForm);r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/vk/tools/PredefinedView',[],function(){"use strict";var P={Initial:"Initial",Front:"Front",Back:"Back",Left:"Left",Right:"Right",Top:"Top",Bottom:"Bottom"};return P;},true);
sap.ui.predefine('sap/ui/vk/tools/RectSelectTool',["./Tool","./RectSelectToolHandler","../Loco"],function(T,R,L){"use strict";
var a=T.extend("sap.ui.vk.tools.RectSelectTool",{
metadata:{properties:{subtractMode:{type:"boolean",defaultValue:false}}},
constructor:function(i,s){if(a._instance){return a._instance;}T.apply(this,arguments);this._viewport=null;this._handler=new R(this);this._loco=null;a._instance=this;}
});
a.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport"]);};
a.prototype.setActive=function(v,b,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,b,g);}if(v){this._activateTool(b);}else{this._deactivateTool();}if(b){b.setShouldRenderFrame();}return this;};
a.prototype._activateTool=function(b){this._viewport=this.getViewportImplementation(b);if(this._prepare()){this._handler.activate(this._viewport);}};
a.prototype._deactivateTool=function(){this._handler.deactivate();};
a.prototype._prepare=function(){if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){return true;}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")&&this._viewport._scene&&this._viewport._scene.getSceneRef()){return true;}else{return false;}};
a.prototype.queueCommand=function(b){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){b();}}return this;};
function c(b,d,v){var m=b.elements;var i=m[15]===1;var r=2/m[0];var t=2/m[5];var e,f;if(i){e=-m[12]*r;f=-m[13]*t;}else{e=m[8]*r;f=m[9]*t;}var g=(r+e)*0.5;var l=e-g;var h=(t+f)*0.5;var j=f-h;var k=THREE.Math.lerp(l,g,Math.min(d.x1,d.x2)/v.width);var n=THREE.Math.lerp(l,g,Math.max(d.x1,d.x2)/v.width);var o=THREE.Math.lerp(h,j,Math.min(d.y1,d.y2)/v.height);var p=THREE.Math.lerp(h,j,Math.max(d.y1,d.y2)/v.height);m[0]=2/(n-k);m[5]=2/(o-p);if(i){m[12]=-(n+k)/(n-k);m[13]=-(o+p)/(o-p);}else{m[8]=(n+k)/(n-k);m[9]=(o+p)/(o-p);}}
a.prototype.select=function(x,y,b,d,s,e){if(!this._prepare()){return[];}return this._select(x,y,b,d,this._viewport,s,e);};
a.prototype._select=function(x,y,b,d,v,s,e){var n=[];if(v.getMetadata().getName()==="sap.ui.vk.dvl.Viewport"){n=v.rectSelect(x,y,b,d);if(n.length>0){var p={picked:n};v.fireNodesPicked(p);if(this.getSubtractMode()){v._viewStateManager.setSelectionStates([],n);}else{v._viewStateManager.setSelectionStates(n,[]);}}return n;}var f=s?s.getSceneRef():undefined;var g=e?e.getCameraRef():undefined;var h=v._getViewStateManagerThreeJS();if(!g||!f||!h||x===b||y===d){return n;}var r={x1:x,y1:y,x2:b,y2:d};var m=g.projectionMatrix.clone();c(m,r,v._renderer.getSize());var j=new THREE.Matrix4().multiplyMatrices(m,g.matrixWorldInverse);var k=new THREE.Frustum().setFromMatrix(j);var o=new THREE.Vector3();function q(w){var z=w.geometry;if(z!==undefined&&k.intersectsObject(w)){var i,l=0;if(z.isGeometry){var A=z.vertices;for(i=0,l=A.length;i<l;i++){o.copy(A[i]).applyMatrix4(w.matrixWorld);if(!k.containsPoint(o)){break;}}}else if(z.isBufferGeometry){var B=z.attributes.position;if(B!==undefined){for(i=0,l=B.count;i<l;i++){o.fromBufferAttribute(B,i).applyMatrix4(w.matrixWorld);if(!k.containsPoint(o)){break;}}}}return l>0&&i===l;}return false;}function t(l){if(l.visible===false){return;}var w=0,z=0;if(l.geometry!==undefined){w++;if(q(l)){z++;}}var A=l.children;if(A.length>0){for(var i=0;i<A.length;i++){var B=A[i];if(B.geometry!==undefined&&!B.name&&B.children.length===0){if(B.visible===true){w++;if(q(B)){z++;}}}else{t(B);}}}if(z>0&&w===z){n.push(l);}}t(f);if(n.length>0){var u={picked:n};v.fireNodesPicked(u);if(this.getSubtractMode()){h.setSelectionStates([],n);}else{h.setSelectionStates(n,[]);}}return n;};
return a;});
sap.ui.predefine('sap/ui/vk/tools/RotateOrbitTool',["./Tool","../helpers/RotateOrbitHelperDvl","../helpers/RotateOrbitHelperThree"],function(T,R,a){"use strict";
var b=T.extend("sap.ui.vk.tools.RotateOrbitTool",{
metadata:{events:{rotate:{parameters:{dx:"int",dy:"int"}}}},
constructor:function(i,s){if(b._instance){return b._instance;}T.apply(this,arguments);this.setToolid("1a1fced1-9b42-d7f3-5fdf-8d338b3591a6");this._viewport=null;this._rotateOrbitHelper=null;b._instance=this;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport"]);};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);if(this._prepare()){this._rotateOrbitHelper.activateOrbitMode();}};
b.prototype._deactivateTool=function(){if(this._rotateOrbitHelper){this._rotateOrbitHelper.deactivateOrbitMode();this._rotateOrbitHelper=null;}};
b.prototype._prepare=function(){if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){if(this._rotateOrbitHelper==null){this._dvlRendererId=this._viewport._dvlRendererId;this._dvl=this._viewport._dvl;this._rotateOrbitHelper=new R(this,this._dvl);}}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")){if(this._rotateOrbitHelper==null){this._rotateOrbitHelper=new a(this);}}else{return false;}return true;};
b.prototype.rotate=function(d,c){if(this._prepare()){this._rotateOrbitHelper.rotate(d,c);}};
b.prototype.destroy=function(){T.prototype.destroy.call(this);this._viewport=null;this._rotateOrbitHelper=null;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/RotateTool',["./Tool","./CoordinateSystem","./RotateToolHandler","./RotateToolGizmo"],function(T,C,R,a){"use strict";
var b=T.extend("sap.ui.vk.tools.RotateTool",{
metadata:{properties:{coordinateSystem:{type:"sap.ui.vk.tools.CoordinateSystem",defaultValue:C.World},enableStepping:{type:"boolean",defaultValue:false},showEditingUI:{type:"boolean",defaultValue:false}},events:{rotating:{parameters:{x:"float",y:"float",z:"float"}},rotated:{parameters:{x:"float",y:"float",z:"float"}},coordinateSystemChanged:{parameters:{coordinateSystem:"sap.ui.vk.tools.CoordinateSystem"}}}},
constructor:function(i,s){T.apply(this,arguments);this._viewport=null;this._handler=new R(this);this._gizmo=null;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new a());};
b.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}if(c){c.setShouldRenderFrame();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._gizmo=this.getGizmo();this._gizmo.setCoordinateSystem(this.getCoordinateSystem());this._gizmo.show(this._viewport,this);this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler,12);o=true;}return o;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}}return this;};
b.prototype.setCoordinateSystem=function(v){var c=this.getCoordinateSystem();if(c!==v){this.setProperty("coordinateSystem",v,true);this.getGizmo().setCoordinateSystem(v);if(this._viewport){this._viewport.setShouldRenderFrame();}this.fireCoordinateSystemChanged({coordinateSystem:v});}return this;};
b.prototype.setShowEditingUI=function(v){this.setProperty("showEditingUI",v,true);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.rotate=function(x,y,z){if(this._gizmo){this._gizmo.rotate(x,y,z);}if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/RotateToolGizmo',["jquery.sap.global","../threejs/thirdparty/three","./Gizmo","./RotateToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,t,G,R,C,A){"use strict";
var b=G.extend("sap.ui.vk.tools.RotateToolGizmo",{metadata:{library:"sap.ui.vk"}});
b.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(String.fromCharCode(176),84);this._gizmoIndex=-1;this._handleIndex=-1;this._lastAngle=[0,0,0];this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();this._gizmo=new THREE.Group();this._touchAreas=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._coordinateSystem=C.World;this._nodes=[];this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoRotation=new THREE.Vector3();function c(f,d,r,s){var g=new THREE.TorusBufferGeometry(r,window.devicePixelRatio/288,4,s);if(f===0){g.rotateY(Math.PI/2);}else if(f===1){g.rotateX(Math.PI/2);}var h=new THREE.Mesh(g,new THREE.MeshBasicMaterial({color:d,transparent:true}));h.matrixAutoUpdate=false;h.userData.color=d;return h;}function a(f,r,s){var g=new THREE.TorusBufferGeometry(r,24/144,4,s);if(f===0){g.rotateY(Math.PI/2);}else if(f===1){g.rotateX(Math.PI/2);}return new THREE.Mesh(g,new THREE.MeshBasicMaterial({opacity:0.2,transparent:true}));}for(var i=0;i<3;i++){var d=0;switch(i){case 0:d=A.x;break;case 1:d=A.y;break;case 2:d=A.z;break;default:break;}this._gizmo.add(c(i,d,1,128));this._touchAreas.add(a(i,1,24));}this._gizmo.add(new THREE.AxesHelper(0.75));var e=new THREE.MeshBasicMaterial({color:0x0080FF,opacity:0.5,transparent:true,side:THREE.DoubleSide});this._arcMesh=new THREE.Mesh(new THREE.Geometry(),e);this._arcMesh.drawMode=THREE.TriangleFanDrawMode;this._arcMesh.visible=false;this._gizmo.add(this._arcMesh);this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);};
b.prototype.hasDomElement=function(){return true;};
b.prototype.setCoordinateSystem=function(c){this._coordinateSystem=c;var s=c===C.Screen;this._gizmo.children[0].visible=this._gizmo.children[1].visible=!s;this._touchAreas.children[0].visible=this._touchAreas.children[1].visible=!s;this._axisTitles.visible=!s;this._gizmoIndex=this._handleIndex=-1;};
b.prototype.show=function(v,a){this._viewport=v;this._tool=a;this._nodes.length=0;this._updateSelection(v._viewStateManager);};
b.prototype.hide=function(){this._viewport=null;this._tool=null;this._gizmoIndex=this._handleIndex=-1;this._updateEditingForm(false);};
b.prototype.getGizmoCount=function(){if(this._coordinateSystem===C.Local){return this._nodes.length;}else{return this._nodes.length>0?1:0;}};
b.prototype.getTouchObject=function(i){if(this._nodes.length===0){return null;}this._updateGizmoObjectTransformation(this._touchAreas,i);return this._touchAreas;};
b.prototype.getGizmoObject=function(){return this._nodes.length>0?this._gizmo:null;};
b.prototype.highlightHandle=function(a,h){for(var i=0;i<3;i++){var c=this._gizmo.children[i];var d=i===a?0xFFFF00:c.userData.color;c.material.color.setHex(d);c.material.opacity=a===-1||i===a?1:0.35;c.material.visible=h||i===a;var e=this._axisTitles.children[i];e.material.color.setHex(d);e.material.opacity=a===-1||i===a?1:0.35;e.material.visible=h||i===a;}};
b.prototype.selectHandle=function(i,g){this._gizmoIndex=g;this._handleIndex=i;this._viewport.setShouldRenderFrame();};
b.prototype.beginGesture=function(){this._matOrigin=this._gizmo.matrixWorld.clone();this._nodes.forEach(function(n){n.node.parent.updateMatrixWorld(true);n.matOrigin=n.node.matrixWorld.clone();n.matLocalOrigin=n.node.matrix.clone();n.matParentInv=new THREE.Matrix4().getInverse(n.node.parent.matrixWorld);n.quaternion=n.node.quaternion.clone();});};
b.prototype.endGesture=function(){this._arcMesh.visible=false;this._tool.fireRotated({x:this._gizmoRotation.x,y:this._gizmoRotation.y,z:this._gizmoRotation.z});};
b.prototype._rotate=function(e){this._gizmoRotation.set(THREE.Math.radToDeg(e.x),THREE.Math.radToDeg(e.y),THREE.Math.radToDeg(e.z));var a=new THREE.Quaternion();if(this._coordinateSystem===C.Local){a.setFromEuler(e);this._nodes.forEach(function(h){h.node.quaternion.copy(h.quaternion).multiply(a);h.node.matrixWorldNeedsUpdate=true;});}else{e=e.toArray();for(var i=0;i<3;i++){var c=e[i];if(c){var d=e[3].charCodeAt(i)-88;if(d>=0&&d<3){var f=new THREE.Vector3().setFromMatrixColumn(this._matOrigin,d).normalize();var m=new THREE.Matrix4().makeRotationAxis(f,c);var p=new THREE.Vector3().setFromMatrixPosition(this._matOrigin);m.setPosition(p.sub(p.clone().applyMatrix4(m)));for(var n=0,g=this._nodes.length;n<g;n++){var h=this._nodes[n];if(!h.ignore){var j=h.node;j.position.setFromMatrixPosition(h.matOrigin).applyMatrix4(m).applyMatrix4(h.matParentInv);var s=new THREE.Vector3().setFromMatrixScale(h.matOrigin);var l=f.clone().transformDirection(new THREE.Matrix4().getInverse(h.matOrigin)).multiply(s).normalize();a.setFromAxisAngle(l,c);j.quaternion.copy(h.quaternion).multiply(a);j.matrixWorldNeedsUpdate=true;}}}}}}this._viewport.setShouldRenderFrame();};
b.prototype._setRotationAxisAngle=function(c,d,e){var f=this._lastAngle[c]=e-d;if(Math.abs(f)>Math.PI){f-=Math.PI*2*Math.sign(f);}var g=[0,0,0];g[c]=f;g=new THREE.Euler().fromArray(g);if(this._tool.fireEvent("rotating",{x:THREE.Math.radToDeg(g.x),y:THREE.Math.radToDeg(g.y),z:THREE.Math.radToDeg(g.z)},true)){this._rotate(g);var v=[0,0,0];var h=new THREE.Vector3();var j=(c+1)%3,k=(c+2)%3;var n=Math.max(Math.ceil(Math.abs(f)*64/Math.PI),1);f*=this._coordinateSystem===C.Local?-1:1;for(var i=0;i<=n;i++){var a=d+f*(i/n);h.set(0,0,0).setComponent(j,Math.cos(a)).setComponent(k,Math.sin(a));v.push(h.x,h.y,h.z);}this._arcMesh.geometry=new THREE.BufferGeometry().addAttribute("position",new THREE.Float32BufferAttribute(v,3));this._arcMesh.visible=true;}};
b.prototype.rotate=function(x,y,z){this.beginGesture();this._rotate(new THREE.Euler(THREE.Math.degToRad(x||0),THREE.Math.degToRad(y||0),THREE.Math.degToRad(z||0)));};
b.prototype.getValue=function(){this._lastRotation=new THREE.Euler();if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){switch(this._coordinateSystem){case C.World:if(this._nodes.length===1){this._lastRotation.setFromRotationMatrix(this._nodes[0].node.matrixWorld);}break;case C.Local:this._lastRotation.copy(this._nodes[this._gizmoIndex].node.rotation);break;case C.Custom:case C.Screen:this._lastRotation[["x","y","z"][this._handleIndex]]=this._lastAngle[this._handleIndex];break;default:break;}}this._lastRotation.reorder("YXZ");return THREE.Math.radToDeg(this._lastRotation[["x","y","z"][this._handleIndex]]);};
b.prototype.setValue=function(v){if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){if(this._coordinateSystem===C.Screen||this._coordinateSystem===C.Custom){this._lastAngle[this._handleIndex]=THREE.Math.degToRad(v);}this.beginGesture();var a=new THREE.Quaternion().setFromEuler(this._lastRotation);this._lastRotation[["x","y","z"][this._handleIndex]]=THREE.Math.degToRad(v);var c=new THREE.Quaternion().setFromEuler(this._lastRotation);var e=new THREE.Euler().setFromQuaternion(a.inverse().multiply(c));this._rotate(e);this.endGesture();}};
b.prototype.expandBoundingBox=function(a){if(this._viewport){this._expandBoundingBox(a,this._viewport.getCamera().getCameraRef());}};
b.prototype.handleSelectionChanged=function(e){if(this._viewport){this._updateSelection(this._viewport._viewStateManager);this._gizmoIndex=this._handleIndex=-1;}};
b.prototype._getLevelingQuaternion=function(a,o){a.set(0,0,0,1);switch(this._coordinateSystem){case C.Local:a.setFromRotationMatrix(this._nodes[o].node.parent.matrixWorld);break;case C.Screen:a.copy(this._viewport.getCamera().getCameraRef().quaternion);break;case C.Custom:var c=this._getAnchorPoint();if(c){a.copy(c.quaternion);}break;default:break;}return false;};
b.prototype._getObjectSize=function(o){var a=new THREE.Box3();if(this._nodes.length===1){this._nodes[0].node._expandBoundingBox(a,true);}else if(this._coordinateSystem===C.Local){this._nodes[0].node._expandBoundingBox(a,true);}if(a.isEmpty()){return 0;}var s=new THREE.Vector3();a.getSize(s);return s.length();};
b.prototype._updateGizmoTransformation=function(i,c){var s=this._updateGizmoObjectTransformation(this._gizmo,i);this._updateAxisTitles(this._axisTitles,this._gizmo,c,this._gizmoSize-18,s);};
b.prototype._getEditingFormPosition=function(){var s=this._updateGizmoObjectTransformation(this._gizmo,this._gizmoIndex);var d=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return d.clone().multiplyScalar((this._gizmoSize-18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};
b.prototype.render=function(){if(this._nodes.length>0){var r=this._viewport.getRenderer(),c=this._viewport.getCamera().getCameraRef();this._matViewProj.multiplyMatrices(c.projectionMatrix,c.matrixWorldInverse);r.clearDepth();for(var i=0,l=this.getGizmoCount();i<l;i++){this._updateGizmoTransformation(i,c);r.render(this._sceneGizmo,c);}}this._updateEditingForm(this._nodes.length>0&&this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3,this._handleIndex);};
return b;});
sap.ui.predefine('sap/ui/vk/tools/RotateToolGizmoRenderer',[],function(){"use strict";var R={};
R.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkTransformationToolEdit");r.writeClasses();r.write(">");r.renderControl(c._editingForm);r.write("</div>");};
return R;},true);
sap.ui.predefine('sap/ui/vk/tools/RotateTurntableTool',["./Tool","../helpers/RotateTurntableHelperDvl","../helpers/RotateTurntableHelperThree"],function(T,R,a){"use strict";
var b=T.extend("sap.ui.vk.tools.RotateTurntableTool",{
metadata:{events:{rotate:{parameters:{dx:"int",dy:"int"}}}},
constructor:function(i,s){if(b._instance){return b._instance;}T.apply(this,arguments);this.setToolid("f271c082-676c-adc6-167f-0d5ce602aa45");this._viewport=null;this._rotateTurntableHelper=null;b._instance=this;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport"]);};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);if(this._prepare()){this._rotateTurntableHelper.activateTurntableMode();}};
b.prototype._deactivateTool=function(){if(this._rotateTurntableHelper){this._rotateTurntableHelper.deactivateTurntableMode();this._rotateTurntableHelper=null;}};
b.prototype._prepare=function(){if(this.isViewportType("sap.ui.vk.dvl.Viewport")&&this._viewport._dvl){if(this._rotateTurntableHelper==null){this._dvlRendererId=this._viewport._dvlRendererId;this._dvl=this._viewport._dvl;this._rotateTurntableHelper=new R(this,this._dvl);}}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")){if(this._rotateTurntableHelper==null){this._rotateTurntableHelper=new a(this);}}else{return false;}return true;};
b.prototype.rotate=function(d,c){if(this._prepare()){this._rotateTurntableHelper.rotate(d,c);}};
b.prototype.destroy=function(){T.prototype.destroy.call(this);this._viewport=null;this._rotateTurntableHelper=null;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/ScaleTool',["./Tool","./CoordinateSystem","./ScaleToolHandler","./ScaleToolGizmo"],function(T,C,S,a){"use strict";
var b=T.extend("sap.ui.vk.tools.ScaleTool",{
metadata:{properties:{coordinateSystem:{type:"sap.ui.vk.tools.CoordinateSystem",defaultValue:C.World},nonUniformScaleEnabled:{type:"boolean",defaultValue:false},enableStepping:{type:"boolean",defaultValue:false},showEditingUI:{type:"boolean",defaultValue:false}},events:{scaling:{parameters:{x:"float",y:"float",z:"float"}},scaled:{parameters:{x:"float",y:"float",z:"float"}},coordinateSystemChanged:{parameters:{coordinateSystem:"sap.ui.vk.tools.CoordinateSystem"}}}},
constructor:function(i,s){T.apply(this,arguments);this._viewport=null;this._handler=new S(this);this._gizmo=null;}
});
b.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new a());};
b.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
b.prototype.setActive=function(v,c,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,c,g);}if(v){this._activateTool(c);}else{this._deactivateTool();}if(c){c.setShouldRenderFrame();}return this;};
b.prototype._activateTool=function(c){this._viewport=this.getViewportImplementation(c);this._gizmo=this.getGizmo();this._gizmo.setCoordinateSystem(this.getCoordinateSystem());this._gizmo.setNonUniformScaleEnabled(this.getNonUniformScaleEnabled());this._gizmo.show(this._viewport,this);this._prepare();};
b.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
b.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler,11);o=true;}return o;};
b.prototype.queueCommand=function(c){if(this._prepare()){if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}}return this;};
b.prototype.setCoordinateSystem=function(v){var c=this.getCoordinateSystem();if(c!==v){this.setProperty("coordinateSystem",v,true);this.getGizmo().setCoordinateSystem(v);if(this._viewport){this._viewport.setShouldRenderFrame();}this.fireCoordinateSystemChanged({coordinateSystem:v});}return this;};
b.prototype.setNonUniformScaleEnabled=function(v){this.setProperty("nonUniformScaleEnabled",v,true);this.getGizmo().setNonUniformScaleEnabled(v);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.setShowEditingUI=function(v){this.setProperty("showEditingUI",v,true);if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
b.prototype.scale=function(x,y,z){if(this._gizmo){this._gizmo.scale(x,y,z);}if(this._viewport){this._viewport.setShouldRenderFrame();}return this;};
return b;});
sap.ui.predefine('sap/ui/vk/tools/ScaleToolGizmo',["jquery.sap.global","../threejs/thirdparty/three","./Gizmo","./ScaleToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,t,G,S,C,A){"use strict";
var c=G.extend("sap.ui.vk.tools.ScaleToolGizmo",{metadata:{library:"sap.ui.vk"}});
c.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(null,64);this._gizmoIndex=-1;this._handleIndex=-1;this._viewport=null;this._tool=null;this._nonUniformScaleEnabled=false;this._sceneGizmo=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._sceneGizmo.add(l);this._sceneGizmo.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._gizmo=new THREE.Group();this._touchAreas=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._gizmoScale=new THREE.Vector3().setScalar(1);this._coordinateSystem=C.World;this._nodes=[];this._matViewProj=new THREE.Matrix4();this._gizmoSize=132;var e=144,f=24/e,g=48/e;function h(a,b,k){var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(a.y,a.z,a.x),a,new THREE.Vector3(a.z,a.x,a.y));var n=new THREE.BoxBufferGeometry(f,f,f);n.applyMatrix(m);var o=new THREE.MeshLambertMaterial({color:b,transparent:true});var p=new THREE.Mesh(n,o);p.userData.color=b;if(a){p.position.copy(a);var r=window.devicePixelRatio*0.5/e;var s=new THREE.CylinderBufferGeometry(r,r,1,4);m.setPosition(a.clone().multiplyScalar(-0.5));s.applyMatrix(m);var u=new THREE.Mesh(s,o);u.renderOrder=1;p.add(u);m.setPosition(a);}var v=new THREE.BoxBufferGeometry(g,g,g);v.applyMatrix(m);k.add(new THREE.Mesh(v,o));return p;}function i(a,b,k){var m=new THREE.BufferGeometry();var v=new Float32Array(6);v[a]=v[b+3]=0.7;m.addAttribute("position",new THREE.Float32BufferAttribute(v,3));var n=new Float32Array(6);n[a]=n[b+3]=1;m.addAttribute("color",new THREE.Float32BufferAttribute(n,3));var o=new THREE.Line(m,new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,transparent:true,linewidth:window.devicePixelRatio}));o.userData.colors=n;var p=new THREE.Geometry();var r=new THREE.Vector3().setComponent(a,0.7);var s=new THREE.Vector3().setComponent(b,0.7);p.vertices.push(new THREE.Vector3(),r,s);p.faces.push(new THREE.Face3(0,1,2));var u=new THREE.Mesh(p,new THREE.MeshBasicMaterial({color:0xFFFF00,opacity:0.5,transparent:true,side:THREE.DoubleSide,visible:false}));u.renderOrder=1;o.add(u);k.add(u.clone());return o;}this._gizmo.add(h(new THREE.Vector3(1,0,0),A.x,this._touchAreas));this._gizmo.add(h(new THREE.Vector3(0,1,0),A.y,this._touchAreas));this._gizmo.add(h(new THREE.Vector3(0,0,1),A.z,this._touchAreas));this._gizmo.add(i(1,2,this._touchAreas));this._gizmo.add(i(2,0,this._touchAreas));this._gizmo.add(i(0,1,this._touchAreas));f-=0.1/e;var j=new THREE.MeshLambertMaterial({color:0xC0C0C0,transparent:true});this._gizmo.add(new THREE.Mesh(new THREE.BoxBufferGeometry(f,f,f),j));this._touchAreas.add(new THREE.Mesh(new THREE.BoxBufferGeometry(g,g,g),new THREE.MeshBasicMaterial()));this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);this._updateGizmoPartVisibility();};
c.prototype.hasDomElement=function(){return true;};
c.prototype._updateGizmoPartVisibility=function(){var s=this._coordinateSystem===C.Screen;var g=this._gizmo.children,a=this._touchAreas.children;g[2].visible=a[2].visible=!s;g[3].visible=g[4].visible=a[3].visible=a[4].visible=!s&&this._nonUniformScaleEnabled;g[5].visible=a[5].visible=this._nonUniformScaleEnabled;this._axisTitles.children[2].visible=!s;};
c.prototype.setCoordinateSystem=function(a){this._coordinateSystem=a;this._gizmoIndex=this._handleIndex=-1;this._updateGizmoPartVisibility();};
c.prototype.setNonUniformScaleEnabled=function(v){this._nonUniformScaleEnabled=!!v;this._updateGizmoPartVisibility();};
c.prototype.show=function(v,a){this._viewport=v;this._tool=a;this._nodes.length=0;this._updateSelection(v._viewStateManager);};
c.prototype.hide=function(){this._viewport=null;this._tool=null;this._gizmoIndex=this._handleIndex=-1;this._updateEditingForm(false);};
c.prototype.getGizmoCount=function(){if(this._coordinateSystem===C.Local){return this._nodes.length;}else{return this._nodes.length>0?1:0;}};
c.prototype.getTouchObject=function(i){if(this._nodes.length===0){return null;}this._updateGizmoObjectTransformation(this._touchAreas,i);return this._touchAreas;};
var d=[1,2,4,6,5,3];
c.prototype.highlightHandle=function(a,h){var b=(a===6)||(a>=0&&!this._nonUniformScaleEnabled);var i,o;for(i=0;i<3;i++){o=this._gizmo.children[i];var e=b||(d[a]&(1<<i));var f=e?0xFFFF00:o.userData.color;o.material.color.setHex(f);o.children[0].material.color.setHex(f);o.children[0].material.opacity=o.material.opacity=e||h?1:0.35;var g=this._axisTitles.children[i];g.material.color.setHex(f);g.material.opacity=e||h?1:0.35;}for(i=3;i<6;i++){o=this._gizmo.children[i];var j=o.geometry.attributes.color;j.copyArray(b||i===a?[1,1,0,1,1,0]:o.userData.colors);j.needsUpdate=true;o.material.opacity=h||i===a?1:0.35;o.children[0].material.visible=i===a;}o=this._gizmo.children[6];o.material.color.setHex(b?0xFFFF00:0xC0C0C0);o.material.opacity=b||h?1:0.35;};
c.prototype.selectHandle=function(i,g){this._gizmoIndex=g;this._handleIndex=i;this._viewport.setShouldRenderFrame();};
c.prototype.beginGesture=function(){this._matOrigin=this._gizmo.matrixWorld.clone();this._nodes.forEach(function(n){n.scaleOrigin=n.node.scale.clone();n.matOrigin=n.node.matrixWorld.clone();n.matParentInv=new THREE.Matrix4().getInverse(n.node.parent.matrixWorld);});};
c.prototype.endGesture=function(){this._tool.fireScaled({x:this._gizmoScale.x,y:this._gizmoScale.y,z:this._gizmoScale.z});this._gizmoScale.setScalar(1);};
c.prototype._scale=function(s){this._gizmoScale.copy(s);if(this._coordinateSystem===C.Local){this._nodes.forEach(function(n){n.node.scale.copy(n.scaleOrigin).multiply(s);n.node.matrixWorldNeedsUpdate=true;});}else{var m=this._matOrigin.clone().scale(s).multiply(new THREE.Matrix4().getInverse(this._matOrigin));this._nodes.forEach(function(n){if(!n.ignore){var a=n.node;a.matrixWorld.multiplyMatrices(m,n.matOrigin);a.matrix.multiplyMatrices(n.matParentInv,a.matrixWorld);a.matrix.decompose(a.position,new THREE.Quaternion(),a.scale);a.matrixWorldNeedsUpdate=true;}});}this._viewport.setShouldRenderFrame();};
c.prototype.scale=function(x,y,z){this.beginGesture();this._scale(new THREE.Vector3(x,y,z));};
c.prototype._setScale=function(s){if(this._tool.fireEvent("scaling",{x:s.x,y:s.y,z:s.z},true)){this._scale(s);}};
c.prototype.getValue=function(){var v=1;if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){switch(this._coordinateSystem){case C.World:if(this._nodes.length===1){v=new THREE.Vector3().setFromMatrixColumn(this._nodes[0].node.matrixWorld,this._handleIndex).length();}break;case C.Local:v=this._nodes[this._gizmoIndex].node.scale.getComponent(this._handleIndex);break;default:break;}}return v;};
c.prototype.setValue=function(v){if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){this.beginGesture();var s=new THREE.Vector3(1,1,1);if(this._nonUniformScaleEnabled){s.setComponent(this._handleIndex,v/this._lastEditValue);}else{s.setScalar(v/this._lastEditValue);}this._scale(s);this.endGesture();}};
c.prototype.expandBoundingBox=function(b){if(this._viewport){this._expandBoundingBox(b,this._viewport.getCamera().getCameraRef());}};
c.prototype.handleSelectionChanged=function(e){if(this._viewport){this._updateSelection(this._viewport._viewStateManager);this._gizmoIndex=this._handleIndex=-1;}};
c.prototype._getObjectScale=function(o){if(this._nodes.length===1){return this._nodes[0].node.scale;}else if(this._coordinateSystem===C.Local){return this._nodes[o].node.scale;}return new THREE.Vector3(1,1,1);};
c.prototype._getObjectSize=function(o){var b=new THREE.Box3();if(this._nodes.length===1){this._nodes[0].node._expandBoundingBox(b,true);}else if(this._coordinateSystem===C.Local){this._nodes[0].node._expandBoundingBox(b,true);}if(b.isEmpty()){return 0;}var s=new THREE.Vector3();b.getSize(s);return s.length();};
c.prototype._updateGizmoTransformation=function(g,a){var s=this._updateGizmoObjectTransformation(this._gizmo,g);this._updateAxisTitles(this._axisTitles,this._gizmo,a,this._gizmoSize+30,s);};
c.prototype._getEditingFormPosition=function(){var s=this._updateGizmoObjectTransformation(this._gizmo,this._gizmoIndex);var a=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return a.clone().multiplyScalar((this._gizmoSize+18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};
c.prototype.render=function(){if(this._nodes.length>0){var r=this._viewport.getRenderer(),a=this._viewport.getCamera().getCameraRef();this._matViewProj.multiplyMatrices(a.projectionMatrix,a.matrixWorldInverse);r.clearDepth();for(var i=0,l=this.getGizmoCount();i<l;i++){this._updateGizmoTransformation(i,a);r.render(this._sceneGizmo,a);}}this._updateEditingForm(this._nodes.length>0&&this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3,this._handleIndex);};
return c;});
sap.ui.predefine('sap/ui/vk/tools/ScaleToolGizmoRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVkTransformationToolEdit");r.writeClasses();r.write(">");r.renderControl(c._editingForm);r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/vk/tools/SceneOrientationTool',["./Tool","./SceneOrientationToolGizmo"],function(T,S){"use strict";
var a=T.extend("sap.ui.vk.tools.SceneOrientationTool",{
metadata:{properties:{enablePredefinedViews:{type:"boolean",defaultValue:true},enableInitialView:{type:"boolean",defaultValue:true}}},
constructor:function(i,s){if(a._instance){return a._instance;}T.apply(this,arguments);this._viewport=null;this._menu=null;a._instance=this;}
});
a.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new S());};
a.prototype.setActive=function(v,b,g){if(T.prototype.setActive){T.prototype.setActive.call(this,v,b,g);}this._viewport=b;this.getGizmo()._viewport=b.getImplementation?b.getImplementation():b;return this;};
a.prototype.setView=function(v,m){this.getGizmo().setView(v,m);return this;};
a.prototype.setEnableInitialView=function(v){this.setProperty("enableInitialView",v);this.getGizmo().setEnableInitialView(v);};
a.prototype.queueCommand=function(c){if(this.isViewportType("sap.ui.vk.dvl.Viewport")){if(this._dvlRendererId){this._dvl.Renderer._queueCommand(c,this._dvlRendererId);}}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")){c();}return this;};
a.prototype.destroy=function(){T.prototype.destroy.call(this);this._viewport=null;delete a._instance;};
return a;});
sap.ui.predefine('sap/ui/vk/tools/SceneOrientationToolGizmo',["./Gizmo","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","../threejs/thirdparty/three","./SceneOrientationToolGizmoRenderer","../getResourceBundle","./PredefinedView","./AxisColours"],function(G,M,a,b,t,S,g,P,A){"use strict";sap.ui.require("sap.m.Menu");
var c=G.extend("sap.ui.vk.tools.SceneOrientationToolGizmo",{metadata:{library:"sap.ui.vk"}});
function d(e,f){var h=64,l=0.5,i=15,j=3,k=29,n=30;e.multiplyScalar(1/80);var o=new THREE.Vector3(e.y,e.z,e.x),p=new THREE.Vector3(e.z,e.x,e.y);var q=new THREE.MeshLambertMaterial({color:f}),r=new THREE.MeshBasicMaterial({color:0xFFFFFF,transparent:true,opacity:0.8}),s=new THREE.MeshBasicMaterial({color:0x000000,transparent:true,opacity:0.8});var u=new THREE.CylinderBufferGeometry(l,l,h-i,4);var m=new THREE.Matrix4().makeBasis(o,e,p).setPosition(e.clone().multiplyScalar((h-i)*0.5));u.applyMatrix(m);var v=new THREE.Mesh(u,q);var w=new THREE.CylinderBufferGeometry(0,j,i,12,1);m.setPosition(e.clone().multiplyScalar(h-i*0.5));w.applyMatrix(m);v.add(new THREE.Mesh(w,q));var x=new THREE.CylinderBufferGeometry(l,l,k,4);m.makeBasis(e,p,o).setPosition(p.clone().multiplyScalar(0.5).add(e).multiplyScalar(k));x.applyMatrix(m);v.add(new THREE.Mesh(x,r));x=new THREE.CylinderBufferGeometry(l,l,k,4);m.setPosition(p.clone().multiplyScalar(0.5).add(e).add(o).multiplyScalar(k));x.applyMatrix(m);v.add(new THREE.Mesh(x,r));x=new THREE.CylinderBufferGeometry(l,l,k,4);m.makeBasis(p,o,e).setPosition(o.clone().multiplyScalar(0.5).add(e).multiplyScalar(k));x.applyMatrix(m);v.add(new THREE.Mesh(x,r));x=new THREE.CylinderBufferGeometry(l,l,n,4);m.makeBasis(e,p,o).setPosition(p.clone().multiplyScalar(0.5).add(e).multiplyScalar(n));x.applyMatrix(m);v.add(new THREE.Mesh(x,s));x=new THREE.CylinderBufferGeometry(l,l,n,4);m.setPosition(p.clone().multiplyScalar(0.5).add(e).add(o).multiplyScalar(n));x.applyMatrix(m);v.add(new THREE.Mesh(x,s));x=new THREE.CylinderBufferGeometry(l,l,n,4);m.makeBasis(p,o,e).setPosition(o.clone().multiplyScalar(0.5).add(e).multiplyScalar(n));x.applyMatrix(m);v.add(new THREE.Mesh(x,s));return v;}
c.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._enableInitialView=true;this._viewport=null;this._renderer=new THREE.WebGLRenderer({antialias:true,alpha:true});this._renderer.setPixelRatio(window.devicePixelRatio);this._renderer.setSize(1,1);this._camera=new THREE.OrthographicCamera(-1,1,1,-1,0.1,100);this._scene=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._scene.add(l);this._scene.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._scene.add(d(new THREE.Vector3(1,0,0),A.x));this._scene.add(d(new THREE.Vector3(0,1,0),A.y));this._scene.add(d(new THREE.Vector3(0,0,1),A.z));this._scene.traverse(function(o){o.matrixAutoUpdate=false;});this._axisTitles=this._createAxisTitles(32,16);this._scene.add(this._axisTitles);var v=[P.Initial,P.Front,P.Back,P.Left,P.Right,P.Top,P.Bottom];this._menu=new a({items:[new b({text:g().getText("PREDEFINED_VIEW_INITIAL")}),new b({text:g().getText("PREDEFINED_VIEW_FRONT")}),new b({text:g().getText("PREDEFINED_VIEW_BACK")}),new b({text:g().getText("PREDEFINED_VIEW_LEFT")}),new b({text:g().getText("PREDEFINED_VIEW_RIGHT")}),new b({text:g().getText("PREDEFINED_VIEW_TOP")}),new b({text:g().getText("PREDEFINED_VIEW_BOTTOM")})]}).attachItemSelected(function(e){var i=e.getParameters("item").item;var f=e.getSource().indexOfItem(i);this.setView(v[f],1000);},this);this._button=new M({tooltip:g().getText("PREDEFINED_VIEW_MENUBUTTONTOOLTIP"),menu:this._menu}).addStyleClass("sapUiVizKitSceneOrientationGizmoButton").addStyleClass("sapUiSizeCompact");};
c.prototype.setView=function(v,m){var q;switch(v){case P.Initial:q=null;break;case P.Front:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),0);break;case P.Back:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI);break;case P.Left:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),-Math.PI/2);break;case P.Right:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(0,1,0),Math.PI/2);break;case P.Top:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),-Math.PI/2);break;case P.Bottom:q=new THREE.Quaternion().setFromAxisAngle(new THREE.Vector3(1,0,0),Math.PI/2);break;default:return this;}this._viewport._viewportGestureHandler.setView(q,m||0);return this;};
c.prototype.setEnableInitialView=function(v){this._enableInitialView=v;var i=this._menu.getItems();i[0].setVisible(v);i[1].setStartsSection(v);};
c.prototype.render=function(v){this._viewport=v;this._camera.quaternion.copy(v.getCamera().getCameraRef().quaternion);this._camera.position.set(0,0,1).applyQuaternion(this._camera.quaternion);var w=this._renderer.getSize().width;this._updateAxisTitles(this._axisTitles,this._scene,this._camera,w*0.45,2/w);this._renderer.render(this._scene,this._camera);};
c.prototype.onBeforeRendering=function(){};
c.prototype.onAfterRendering=function(){var e=this.getDomRef();this._renderer.setSize(e.clientWidth,e.clientHeight);e.appendChild(this._renderer.domElement);};
return c;});
sap.ui.predefine('sap/ui/vk/tools/SceneOrientationToolGizmoRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVizKitSceneOrientationGizmo");r.writeClasses();r.write(">");if(c.getParent().getEnablePredefinedViews()){r.renderControl(c._button);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/vk/tools/Tool',["sap/ui/core/Element"],function(E){"use strict";
var T=E.extend("sap.ui.vk.tools.Tool",{
metadata:{properties:{targetViewportType:"any",toolid:"string",active:{type:"boolean",defaultValue:false},footprint:{type:"string[]"}},associations:{gizmoContainer:{type:"sap.ui.core.Control",cardinality:"0..1"}},aggregations:{gizmo:{type:"sap.ui.vk.tools.Gizmo",multiple:false}},events:{enabled:{parameters:{enabled:"bool",reason:"string"}}}},
constructor:function(i,s){E.apply(this,arguments);this._viewport=null;this._handler=null;}
});
T.prototype.init=function(){if(E.prototype.init){E.prototype.init.call(this);}};
T.prototype.isViewportType=function(t){if(this._viewport&&this._viewport.getMetadata().getName()===t){return true;}return false;};
T.prototype.getViewportImplementation=function(v){if(v&&typeof v.getImplementation==="function"){return v.getImplementation();}return v;};
T.prototype.setActive=function(v,a,g){if(v){var _=this.getViewportImplementation(a);var b;var c="";b=_&&_.getMetadata().getName();if(this.getFootprint().indexOf(b)>=0){this.setProperty("active",v,true);}else{this.setProperty("active",false,true);c="Tool does not support Viewport type: "+b;jQuery.sap.log.warning(c);}if(this.getGizmo()){if(g){this.setAssociation("gizmoContainer",g);g.rerender();}else{this.setAssociation("gizmoContainer",_);_.rerender();}}this.fireEnabled({enabled:this.getProperty("active"),reason:c});}else{this.setProperty("active",v,true);var d=a||this._viewport;if(d){d.setShouldRenderFrame(true);}this.fireEnabled({enabled:v,reason:"Disabled by application logic."});}};
T.prototype.getGizmoForContainer=function(r){var _=this.getGizmo();if((r.getId()===this.getGizmoContainer())&&_&&this.getActive()){return _;}};
T.prototype.destroy=function(){E.prototype.destroy.call(this);this._viewport=null;this._handler=null;};
return T;});
sap.ui.predefine('sap/ui/vk/tools/TooltipTool',["./Tool","./TooltipToolHandler","./TooltipToolGizmo"],function(T,a,b){"use strict";
var c=T.extend("sap.ui.vk.tools.TooltipTool",{
metadata:{events:{hover:{parameters:{x:"int",y:"int",nodeRef:"any"}}}},
constructor:function(i,s){if(c._instance){return c._instance;}T.apply(this,arguments);this._viewport=null;this._handler=new a(this);c._instance=this;}
});
c.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.setFootprint(["sap.ui.vk.threejs.Viewport"]);this.setAggregation("gizmo",new b());};
c.prototype.setActive=function(v,d,g){T.prototype.setActive.call(this,v,d,g);if(this.getActive()){this._activateTool(d);}else{this._deactivateTool();}return this;};
c.prototype._activateTool=function(d){this._viewport=this.getViewportImplementation(d);this._gizmo=this.getGizmo();if(this._gizmo){this._gizmo.show(this._viewport,this);}this._prepare();};
c.prototype._deactivateTool=function(){if(this._viewport&&this._viewport._loco){this._viewport._loco.removeHandler(this._handler);}if(this._gizmo){this._gizmo.hide();this._gizmo=null;}};
c.prototype._prepare=function(){var o=false;if(this._viewport._loco){this._viewport._loco.addHandler(this._handler);o=true;}return o;};
c.prototype.setTitle=function(t){if(this._gizmo){this._gizmo.setTitle(t);}return this;};
c.prototype.queueCommand=function(d){if(this._prepare()){if(this.isViewportType("sap.ui.vk.dvl.Viewport")){if(this._dvlRendererId){this._dvl.Renderer._queueCommand(d,this._dvlRendererId);}}else if(this.isViewportType("sap.ui.vk.threejs.Viewport")){d();}}return this;};
return c;});
sap.ui.predefine('sap/ui/vk/tools/TooltipToolGizmo',["./Gizmo","./TooltipToolGizmoRenderer"],function(G,T){"use strict";
var a=G.extend("sap.ui.vk.tools.TooltipToolGizmo",{metadata:{library:"sap.ui.vk"}});
a.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._viewport=null;this._tool=null;};
a.prototype.show=function(v,t){this._viewport=v;this._tool=t;var b=this.getDomRef();if(b){b.style.display="none";}};
a.prototype.hide=function(){this._tool=null;var t=this.getDomRef();if(t){t.style.display="none";}};
a.prototype.setTitle=function(t){var b=this.getDomRef();if(b){b.style.display=t?"block":"none";b.innerText=t;}};
a.prototype.update=function(x,y,b,c,n){if(this._tool.fireEvent("hover",{x:x,y:y,nodeRef:n},true)){var t=this.getDomRef();if(t){var o=t.offsetParent;while(o){b-=o.offsetLeft||0;c-=o.offsetTop||0;o=o.offsetParent;}b+=10;c+=15;t.style.left=Math.round(b)+"px";t.style.top=Math.round(c)+"px";var v=this._viewport.getDomRef().getBoundingClientRect();var d=t.getBoundingClientRect();if(d.right>v.right){t.style.left=Math.round(b+v.right-d.right)+"px";}if(d.bottom>v.bottom){t.style.top=Math.round(c+v.bottom-d.bottom)+"px";}}}};
a.prototype.onBeforeRendering=function(){};
a.prototype.onAfterRendering=function(){};
return a;});
sap.ui.predefine('sap/ui/vk/tools/TooltipToolGizmoRenderer',[],function(){"use strict";var T={};
T.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiVizKitTooltip");r.writeClasses();r.write(">");r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/vk/tools/TooltipToolHandler',["sap/ui/base/EventProvider"],function(E){"use strict";
var T=E.extend("sap.ui.vk.tools.TooltipToolHandler",{
metadata:{},
constructor:function(t){this._tool=t;this._rect=null;this._rayCaster=new THREE.Raycaster();this._mouse=new THREE.Vector2();}
});
T.prototype.destroy=function(){this._tool=null;this._rect=null;};
T.prototype._updateMouse=function(e){var s=this.getViewport().getRenderer().getSize();this._mouse.x=((e.x-this._rect.x)/s.width)*2-1;this._mouse.y=((e.y-this._rect.y)/s.height)*-2+1;this._rayCaster.setFromCamera(this._mouse,this.getViewport().getCamera().getCameraRef());};
T.prototype.hover=function(e){var g=this._tool.getGizmo();if(g&&this._inside(e)&&this.getViewport().getScene()){this._updateMouse(e);var i=this._rayCaster.intersectObject(this.getViewport().getScene().getSceneRef(),true);g.update(e.x-this._rect.x,e.y-this._rect.y,e.x,e.y,i.length>0?i[0].object:null);e.handled=i.length>0;}};
T.prototype.beginGesture=function(e){};
T.prototype.move=function(e){};
T.prototype.endGesture=function(e){};
T.prototype.click=function(e){};
T.prototype.doubleClick=function(e){};
T.prototype.contextMenu=function(e){};
T.prototype.getViewport=function(){return this._tool._viewport;};
T.prototype._getOffset=function(o){var r=o.getBoundingClientRect();var p={x:r.left+window.pageXOffset,y:r.top+window.pageYOffset};return p;};
T.prototype._inside=function(e){var i=this._tool._viewport.getIdForLabel();var d=document.getElementById(i);if(d==null){return false;}var o=this._getOffset(d);this._rect={x:o.x,y:o.y,w:d.offsetWidth,h:d.offsetHeight};return(e.x>=this._rect.x&&e.x<=this._rect.x+this._rect.w&&e.y>=this._rect.y&&e.y<=this._rect.y+this._rect.h);};
return T;});
sap.ui.predefine('sap/ui/vk/totara/Command',[],function(){"use strict";var C={addClientLog:"addClientLog",getAnnotation:"getAnnotation",getDynamicView:"getDynamicView",getGeometry:"getGeometry",getHighlightStyle:"getHighlightStyle",getImage:"getImage",getMaterial:"getMaterial",getMesh:"getMesh",getSequence:"getSequence",getTrack:"getTrack",getTree:"getTree",getView:"getView",getViewGroups:"getViewGroups",notifyError:"notifyError",notifyFinishedTree:"notifyFinishedTree",notifyFinishedView:"notifyFinishedView",requestScene:"requestScene",setAnnotation:"setAnnotation",setCamera:"setCamera",setGeometry:"setGeometry",setHighlightStyle:"setHighlightStyle",setImage:"setImage",setMaterial:"setMaterial",setMesh:"setMesh",setPlayback:"setPlayback",setSequence:"setSequence",setStreamingToken:"setStreamingToken",setTrack:"setTrack",setTree:"setTree",setTreeNode:"setTreeNode",setView:"setView",setViewGroup:"setViewGroup",setViewNode:"setViewNode",timestamp:"timestamp",performanceTiming:"performanceTiming"};return C;});
sap.ui.predefine('sap/ui/vk/utf8ArrayBufferToString',[],function(){"use strict";var u=function(a){return decodeURIComponent(escape(String.fromCharCode.apply(null,new Uint8Array(a))));};return u;},true);
sap.ui.require.preload({
	"sap/ui/vk/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.vk","type":"library","embeds":[],"applicationVersion":{"version":"1.71.8"},"title":"SAPUI5 Visualization Toolkit.","description":"SAPUI5 Visualization Toolkit.","ach":"CA-UI5-VTK","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_hcw","sap_belize_plus","sap_bluecrystal","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"},"sap.ui.unified":{"minVersion":"1.71.34","lazy":true},"sap.m":{"minVersion":"1.71.34","lazy":true},"sap.ui.layout":{"minVersion":"1.71.34","lazy":true}}},"library":{"i18n":false,"content":{"controls":["sap.ui.vk.AnimationTimeSlider","sap.ui.vk.ContainerBase","sap.ui.vk.ContainerContent","sap.ui.vk.DrawerToolbar","sap.ui.vk.FlexibleControl","sap.ui.vk.LegendItem","sap.ui.vk.ListPanel","sap.ui.vk.ListPanelStack","sap.ui.vk.MapContainer","sap.ui.vk.NativeViewport","sap.ui.vk.Notifications","sap.ui.vk.Overlay","sap.ui.vk.ProgressIndicator","sap.ui.vk.RedlineDesign","sap.ui.vk.RedlineSurface","sap.ui.vk.SceneTree","sap.ui.vk.StepNavigation","sap.ui.vk.Toolbar","sap.ui.vk.Viewer","sap.ui.vk.ViewGallery","sap.ui.vk.Viewport","sap.ui.vk.ViewportBase","sap.ui.vk.dvl.Viewport","sap.ui.vk.threejs.Viewport","sap.ui.vk.tools.AnchorPointToolGizmo","sap.ui.vk.tools.CrossSectionToolGizmo","sap.ui.vk.tools.Gizmo","sap.ui.vk.tools.MoveToolGizmo","sap.ui.vk.tools.RotateToolGizmo","sap.ui.vk.tools.ScaleToolGizmo","sap.ui.vk.tools.SceneOrientationToolGizmo","sap.ui.vk.tools.TooltipToolGizmo"],"elements":["sap.ui.vk.ContentConnector","sap.ui.vk.FlexibleControlLayoutData","sap.ui.vk.OverlayArea","sap.ui.vk.RedlineElement","sap.ui.vk.RedlineElementEllipse","sap.ui.vk.RedlineElementFreehand","sap.ui.vk.RedlineElementLine","sap.ui.vk.RedlineElementRectangle","sap.ui.vk.RedlineElementText","sap.ui.vk.ViewStateManager","sap.ui.vk.ViewStateManagerBase","sap.ui.vk.dvl.ViewStateManager","sap.ui.vk.threejs.NodesTransitionHelper","sap.ui.vk.threejs.ViewStateManager","sap.ui.vk.tools.AnchorPointTool","sap.ui.vk.tools.CrossSectionTool","sap.ui.vk.tools.HitTestTool","sap.ui.vk.tools.MoveTool","sap.ui.vk.tools.RectSelectTool","sap.ui.vk.tools.RotateOrbitTool","sap.ui.vk.tools.RotateTool","sap.ui.vk.tools.RotateTurntableTool","sap.ui.vk.tools.ScaleTool","sap.ui.vk.tools.SceneOrientationTool","sap.ui.vk.tools.Tool","sap.ui.vk.tools.TooltipTool"],"types":[],"interfaces":["sap.ui.vk.AuthorizationHandler","sap.ui.vk.DecryptionHandler"]}}}}',
	"sap/ui/vk/thirdparty/ie-polyfills.js":function(){
/* the subsequent text seems not to contain a copyright or license statement */
if(!Uint8Array.prototype.slice){Object.defineProperty(Uint8Array.prototype,"slice",{value:function(b,e){return new Uint8Array(Array.prototype.slice.call(this,b,e));}});}if(!Uint8Array.prototype.indexOf){Object.defineProperty(Uint8Array.prototype,"indexOf",{value:function(o,s){for(var i=(s||0),j=this.length;i<j;i++){if(this[i]===o){return i;}}return-1;}});}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{enumerable:false,value:function(o){var n=this.filter(function(e){return e==o;});return n.length>0;}});}
},
	"sap/ui/vk/threejs/MataiLoaderWorker.js":'console.log("MataiLoaderWorker started.");var scriptDirectory=self.location.href.slice(0,self.location.href.lastIndexOf("/")+1);self.importScripts(scriptDirectory+"thirdparty/matai.js");sap.ve.matai.createRuntime({prefixURL:scriptDirectory+"thirdparty/"}).then(function(m){"use strict";console.log("MataiLoaderWorker runtime created.");function S(s){this.sceneBuilderId=s;}S.prototype.setScene=function(i){i.cameraId=i.cameraRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setScene",args:[i]});};S.prototype.createNode=function(i){i.parentId=i.parentRef;if(i.transformType===1){i.transformType="BILLBOARD_VIEW";}else if(i.transformType===257){i.transformType="LOCK_TOVIEWPORT";}i.transform=i.matrix;i.sid=i.nodeRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createNode",args:[i]},[i.transform.buffer]);};S.prototype.createMesh=function(i){i.materialId=i.materialRef;i.transform=i.matrix;i.meshId=i.meshRef;var t=[i.boundingBox.buffer];if(i.transform){t.push(i.transform.buffer);}self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertSubmesh",args:[i]},t);};S.prototype.setMeshGeometry=function(i){i.meshId=i.meshRef;i.data.indices=i.data.index;i.data.points=i.data.position;i.data.normals=i.data.normal;i.data.uvs=i.data.uv;if(i.flags&1){i.isPolyline=true;}var t=[i.data.indices.buffer,i.data.points.buffer];if(i.data.normals){t.push(i.data.normals.buffer);}if(i.data.uvs){t.push(i.data.uvs.buffer);}self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setGeometry",args:[i]},t);};S.prototype.insertMesh=function(n,a){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setMeshNode",args:[n,a]});};S.prototype.createTextAnnotation=function(i){i.coordinateSpace=0;i.nodeId=i.nodeRef;i.fontFace=i.font;i.shape=i.style;i.backgroundColour=i.backgroundColor;i.borderColour=i.borderColor;i.textColour=i.textColor;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createAnnotation",args:[i]});};S.prototype.createTextNote=function(i){i.coordinateSpace=2;i.nodeId=i.nodeRef;i.id=i.nodeRef;i.sid=i.targetNodeRef;i.fontFace=i.font;i.shape=i.style;i.backgroundColour=i.backgroundColor;i.backgroundColour=i.backgroundColor;i.borderColour=i.borderColor;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createAnnotation",args:[i]});};S.prototype.createImageNote=function(i){i.properlyAligned=true;i.nodeId=i.nodeRef;i.labelMaterialId=i.materialRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createImageNote",args:[i]});};S.prototype.insertLeaderLine=function(a){var p=[];for(var i=0;i<a.points.length;i+=3){var b=[a.points[i],a.points[i+1],a.points[i+2]];p.push(b);}a.points=p;a.annotationId=a.nodeRef;a.nodeId=a.nodeRef;a.startPointSid=a.targetNodeRef;a.materialId=a.materialRef;a.startPointHeadStyle=a.startPointStyle;a.endPointHeadStyle=a.endPointStyle;a.pointHeadConstant=a.styleConstant;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertLeaderLine",args:[a]});};S.prototype.createCamera=function(i){i.ortho=i.projection==="orthographic";i.near=i.nearClip;i.far=i.farClip;i.fov=i.fov*Math.PI/180;i.zoom=i.orthoZoomFactor;i.id=i.cameraRef;var t=[i.origin.buffer,i.up.buffer,i.target.buffer];if(i.matrix){t.push(i.transform.buffer);}i.notUseDirectionVector=true;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createCamera",args:[i]},t);};S.prototype.insertCamera=function(n,c){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertCamera",args:[n,c]});};S.prototype.createViewportGroup=function(i){i.id=i.viewportGroupRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertViewGroup",args:[i]});};S.prototype.finalizePlaybacks=function(i){i.viewGroupId=i.viewportGroupRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setAnimationPlaybacks",args:[i]});};S.prototype.insertModelView=function(i){i.viewGroupId=i.viewportGroupRef;i.viewId=i.modelViewRef;i.thumbnailId=i.thumbnail;i.cameraId=i.cameraRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertView",args:[i]});};S.prototype.setModelViewVisibilitySet=function(i){i.viewId=i.modelViewRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setModelViewVisibilitySet",args:[i]});};S.prototype.insertModelViewHighlight=function(i){i.viewId=i.modelViewRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertModelViewHighlight",args:[i]});};S.prototype.createThumbnail=function(i){i.imageId=i.imageRef;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createThumbnail",args:[i]});};S.prototype.createDetailView=function(i){i.nodeId=i.nodeRef;i.detailViewId=i.detailViewRef;i.cameraId=i.cameraRef;i.backgroundColour=i.backgroundColor;i.borderColour=i.borderColor;i.attachment=i.attachmentPoint;var t=[i.origin.buffer,i.size.buffer];if(i.attachment){t.push(i.attachment.buffer);}i.properlyAligned=true;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createDetailView",args:[i]},t);};S.prototype.createMaterial=function(i){i.ambientColour=i.ambient;i.diffuseColour=i.diffuse;i.specularColour=i.specular;i.emissiveColour=i.emissive;i.lineWidth=i.linestyle.width;i.lineHaloWidth=i.linestyle.haloWidth;i.lineColour=i.linestyle.color;i.lineEndRound=i.linestyle.endCapStyle;i.lineDashPatternScale=i.linestyle.dashPatternScale;i.lineDashPattern=i.linestyle.dashPattern;i.lineWidthCoordinateSpace=i.linestyle.widthCoordinateSpace;i.id=i.materialRef;var t=[i.ambientColour.buffer,i.diffuseColour.buffer,i.specularColour.buffer,i.emissiveColour.buffer];if(i.lineColour&&i.lineDashPattern){t.push(i.lineColour.buffer,i.lineDashPattern.buffer);}if(i.textures){for(var a=0;a<i.textures.length;a++){var b=i.textures[a];var c="texture"+b.type.charAt(0).toUpperCase()+b.type.slice(1);i[c]={imageId:b.imageRef,matrix:b.matrix,uvHorizontalScale:b.scaleX,uvVerticalScale:b.scaleY,uvHorizontalOffset:b.offsetX,uvVerticalOffset:b.offsetY,uvRotationAngle:b.angle,influence:b.amount,filterMode:b.filterMode,uvHorizontalTilingEnabled:b.repeatX,uvVerticalTilingEnabled:b.repeatY,uvClampToBordersEnabled:b.clampToBorder,inverted:b.invert,modulate:b.modulate};}}self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createMaterial",args:[i]},t);};S.prototype.createImage=function(i){i.id=i.imageRef;i.binaryData=i.data;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"createImage",args:[i]},[i.binaryData.buffer]);};S.prototype.progress=function(p){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"progress",args:[p]});};S.prototype.insertThrustline=function(i){i.thrustlineId=i.thrustlineRef;i.materialId=i.material;self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertThrustline",args:[i]});};S.prototype.insertAnimationGroup=function(i){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertAnimationGroup",args:[i]});};S.prototype.insertAnimation=function(i){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertAnimation",args:[i]});};S.prototype.insertAnimationTarget=function(i){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertAnimationTarget",args:[i]});};S.prototype.insertAnimationTrack=function(i){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"insertAnimationTrack",args:[i]});};S.prototype.finalizeAnimation=function(a){self.postMessage({sceneBuilderId:this.sceneBuilderId,method:"setAnimationTracks",args:[a]});};self.onmessage=function(e){var d=e.data;switch(d.method){case"loadSceneFromArrayBuffer":var p=new S(d.sceneBuilderId);var r=m.loadSceneFromArrayBuffer(p,d.buffer,d.fileName,null,d.sourceLocation);this.postMessage({sceneBuilderId:d.sceneBuilderId,method:"loadingFinished",args:[{result:r}]});break;default:break;}};self.postMessage({ready:true});console.log("MataiLoaderWorker initialized.");});console.log("MataiLoaderWorker starting runtime.");\n',
	"sap/ui/vk/totara/TotaraLoaderWorker.js":function(){(function(){"use strict";var t=new Map();
function H(){var a,b;var d;var o;var e=[];var m=4;var f=0;function h(a){var p=new Promise(function(i,j){var x=new XMLHttpRequest();x.onload=function(){if(this.status>=200&&this.status<300){i(x.response);if(x.getAllResponseHeaders().includes("tile-width")){var k=x.getResponseHeader("tile-width");var n=new RegExp("[^\/]+$");var q=x.responseURL.match(n);t.set(q[0],k);}}else{j({status:this.status,statusText:x.statusText});}};x.onerror=function(){j({status:this.status,statusText:x.statusText});};x.open("GET",a,true);if(d){x.setRequestHeader("Authorization",d);}x.setRequestHeader("X-CorrelationID",b);x.responseType="arraybuffer";x.send();});return p;}this.getUrl=function(){return a;};this.close=function(){};this.send=function(i,j,k){if(!i){return;}e.push({message:i,context:j,onResponse:k||this.onResponse});if(f<m){_();}};function _(){if(!e.length){return;}var i=e.shift();f++;h(encodeURI(a+i.message)).then(function(j){if(i.onResponse){i.onResponse(j);}f--;_();}).catch(function(j){if(o){o({errorText:"Could not connect to server: "+a,error:j.status,reason:j.message?j.message:j,context:i.context});}f--;_();});}this.init=function(s,i,j){return new Promise(function(k,n){a=s;b=j;if(i!=null){i(s).then(function(p){if(p!=null){d=p.token_type+" "+p.access_token;}else{d=null;}k({});}).catch(function(p){return n(p);});}else{k({});}});};this.setOnErrorCallback=function(i){o=i;};this.onResponse=null;}
function W(){var a;var b=this;var d;var o;function i(){if(d&&d.readyState===1){return true;}return false;}function f(e,p,q){if(o){o({errorText:e,error:q,context:p});}}this.setOnErrorCallback=function(e){o=e;};this.getUrl=function(){return a;};this.close=function(){if(d){d.close();d=null;}};this.send=function(p,q){if(!p){return;}if(!i()){f("websocket connection lost",q,4);}else{try{d.send(p);}catch(e){f(e,q);}}};var h=0;function k(){var e=60000;if(d==null){clearTimeout(h);return;}if(d.readyState==1){d.send("");}h=setTimeout(k,e);}function j(){if(h){clearTimeout(h);h=0;}}var m=false;var n=function(e){var p=JSON.stringify(e);var q="setStreamingToken"+("["+p.length+"]")+p;return q;};this.init=function(s,p){return new Promise(function(q,v){if(s){a=s;}else{s=a;}d=new WebSocket(s);d.binaryType="arraybuffer";d.onopen=function(){m=true;if(p!=null){p(s).then(function(e){if(e!=null){var w=n({"token":e.access_token});d.send(w);}k();q({});}).catch(function(e){return v(e);});}else{k();q({});}};d.onclose=function(){j();};d.onmessage=function(e){var w=e.data;if(b.onResponse){b.onResponse(w);}};d.onerror=function(e){if(!m){v("error connecting to "+s);}else{f(e);}};});};this.onResponse=null;}
function g(a){var b=a.split(",");if(b.length<0||b.length>2){throw"invalid content length";}var j=0;var d=0;try{j=parseInt(b[0],10);if(b.length===2){d=parseInt(b[1],10);}}catch(e){throw"invalid content length";}return{jsonContentLength:j,binaryContentLength:d};}
function c(a){var b="[".charCodeAt(0);var d="]".charCodeAt(0);var f=[];var s=0;var h=0;var i;var j;var k;var m=new Uint8Array(a);while(h<a.byteLength){h=m.indexOf(b,s);if(h===-1){break;}var n=u(a,s,h).replace(/\n|\r|\s/g,"");s=h+1;h=m.indexOf(d,s);if(h===-1){throw"No matching [] for command length. abort";}i=g(u(a,s,h));s=h+1;h=s+i.jsonContentLength;j=u(a,s,h);try{j=JSON.parse(j);}catch(e){var o=n+": "+e;throw o;}if(i.binaryContentLength){s=h;h=s+i.binaryContentLength;k=a.slice(s,h);}else{k=undefined;}s=h;var p={name:n,jsonContent:j};if(k){p.binaryContent=new Uint8Array(k);}f.push(p);}return f;}
function u(a,s,b){var d="";var M=1000;try{while(s<b){var f=Math.min(M,b-s);var h=new Uint8Array(a,s,f);d+=String.fromCharCode.apply(null,h);s+=f;}}catch(e){return"";}return decodeURIComponent(escape(d));}
function L(){this.resolveFunctions=[];this.rejectFunctions=[];this.init=function(d,h,e){this._connection=d;this._connectionHTTP=h;this._sceneBuilderId=e;if(!d){throw"no connection provided for loader!";}this._connection.onResponse=function(f){var i=c(f);p(i);};this._connection.send("getVersion[2]{}");};var a=this;function b(v){a.protocolVersion=v.split(".").map(function(s){return parseInt(s,10);});}function p(d){var e;var v,i;var n=false;for(i=0;i<d.length;i++){e=d[i];if(e.name==="setView"){if(!e.jsonContent.viewId){n=true;}}else if(e.name==="setViewNode"){v=e.jsonContent.viewId;}else if(e.name==="notifyFinishedView"||e.name==="notifyFinishedTree"){break;}}if(v&&n){for(i=0;i<d.length;i++){e=d[i];if(e.name==="setView"){e.jsonContent.viewId=v;break;}}}for(i=0;i<d.length;i++){e=d[i];if(e.name==="protocol"){b(e.jsonContent.version);}if(e.name==="setImage"&&t.get(e.jsonContent.id)){e.jsonContent.tileWidth=t.get(e.jsonContent.id);}if(e.binaryContent){self.postMessage({name:e.name,jsonContent:e.jsonContent,binaryContent:e.binaryContent},[e.binaryContent.buffer]);}else{self.postMessage({name:e.name,jsonContent:e.jsonContent});}}}this.getConnection=function(){return this._connection;};this._sendGetImage=function(d){var e;if(this.protocolVersion&&(this.protocolVersion[0]>1||this.protocolVersion[1]>0)){if(d.materialId){e="scenes/"+d.sceneId+"/materials/"+d.materialId+"/images/"+d.imageId;}else if(d.viewId){e="scenes/"+d.sceneId+"/views/"+d.viewId+"/thumbnail";}}e=e||("images/"+d.imageId);this._connectionHTTP.send(e,d,function(f){p([{name:"setImage",jsonContent:{sceneId:d.sceneId,id:d.imageId},binaryContent:new Uint8Array(f)}]);});};this._sendGetGeometries=function(d){var e=d.geometryIds;var f="geometry?";for(var i=0;i<e.length;i++){f+=(i>0?"&id=":"id=")+e[i];}this._connectionHTTP.send(f,d,function(h){var j=new DataView(h);var k=j.getUint16(2,true),o=0;var m=[];while(k-->0){var n={sceneId:d.sceneId,id:j.getUint32(o+4,true).toString(),box:[j.getFloat32(o+14,true),j.getFloat32(o+18,true),j.getFloat32(o+22,true),j.getFloat32(o+26,true),j.getFloat32(o+30,true),j.getFloat32(o+34,true)]};var q=j.getUint16(o+12,true);o+=38;if(q!==3){n.flags=j.getUint16(o,true);n.quality=j.getFloat32(o+4,true);n.pointCount=j.getUint16(o+8,true);n.elementCount=j.getUint16(o+10,true);o+=14;}var s=j.getUint32(o,true);var v=new Uint8Array(h,o+4,s);o+=s;m.push({name:"setGeometry",jsonContent:n,binaryContent:v.slice()});}p(m);});};this._sendGetGeomMeshes=function(d){var e="scenes/"+d.sceneId+"/meshes?ids=";var m=d.meshIds;for(var i=0;i<m.length;i++){e+=(i>0?",":"")+m[i];}this._connectionHTTP.send(e,d,function(f){var h=c(f);h.forEach(function(s){s.jsonContent.sceneId=d.sceneId;});p(h);});};this.send=function(d){if(this._connectionHTTP){switch(d.method){case"getImage":this._sendGetImage(d);return;case"getGeometry":this._sendGetGeometries(d);return;case"getMesh":if(d.meshIds){this._sendGetGeomMeshes(d);return;}break;default:break;}}if(this._connection){this._connection.send(d.command);}};this.setSceneBuilderId=function(i){this._sceneBuilderId=i;};this.getSceneBuilderId=function(){return this._sceneBuilderId;};this.authorizationHandler=function(d){var a=this;return new Promise(function(e,f){var h={name:"getAuthorization",jsonContent:{"url":d},sceneId:a.sceneId};a.resolveFunctions.push(e);a.rejectFunctions.push(f);self.postMessage(h);});}.bind(this);}
var l=new L();var r=function(e){self.postMessage({name:"notifyError",jsonContent:e});};
self.onmessage=function(e){var d=e.data;switch(d.method){case"initializeConnection":{if(!d.url){break;}if(d.sceneId){l.sceneId=d.sceneId;}var a="";if(d.url[d.url.length-1]!=="/"){d.url+="/";}if(d.url.toLowerCase().startsWith("ws")){a=d.url+"streaming?";}else if(d.url.toLowerCase().startsWith("http")){a=d.url+"streaming-http?request=";}else{a=(d.useSecureConnection?"wss://":"ws://")+d.url+"streaming?";}var b=d.cid;var f=l.getConnection();if(!f||f.getUrl()!==a){if(f){f.close();}var h;var i=null;if(d.url.toLowerCase().startsWith("ws")){h=new W();}else if(d.url.toLowerCase().startsWith("http")){h=new H();i=d.url;}else{h=new W();i=(d.useSecureConnection?"https://":"http://")+d.url;}h.setOnErrorCallback(function(m){r(m);});h.init(a,l.authorizationHandler,b).then(function(){var m=function(h,n){l.init(h,n,d.sceneBuilderId);if(d.command){l.send(d);}};if(i){var n=new H();n.init(i,l.authorizationHandler,b).then(function(){m(h,n);}).catch(function(o){r(o);});}else{m(h,null);}}).catch(function(m){r(m);});}else if(d.command){l.send(d);}break;}case"setAuthorization":{var j=l.resolveFunctions.shift();var k=l.rejectFunctions.shift();if(d.error==null){j(d.authorizationToken);}else{k(d.error);}break;}case"close":{self.close();break;}default:{if(d.command){l.send(d);}break;}}};
self.postMessage({ready:true});})();
},
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
	"sap/ui/vk/dvl/GraphicsCore.js":'/*!\n * SAP UI development toolkit for HTML5 (SAPUI5)\n\n        (c) Copyright 2009-2015 SAP SE. All rights reserved\n    \n */\nvar dvlLib="../ve/dvl";if(sap.ui.Device.browser.internet_explorer){dvlLib="../ve/dvl_asm";}sap.ui.define(["jquery.sap.global","sap/ui/base/EventProvider","../thirdparty/html2canvas",dvlLib,"./Scene","../ContentResource","../DownloadManager","./ViewStateManager","../DvlException","../Messages","sap/ui/thirdparty/URI","./GraphicsCoreApi","./checkResult","./getPointer","./getJSONObject","../getResourceBundle","../utf8ArrayBufferToString"],function(q,E,H,D,S,C,a,V,b,M,U,G,c,d,f,h,u){"use strict";var l=q.sap.log;\nfunction j(e){return e instanceof File?"local":"remote";}\nfunction k(e){return e instanceof File?e.name:e;}\nvar n=function(e){Object.defineProperties(this,{source:{value:e,writable:false,enumerable:true},_refCount:{value:0,writable:true,enumerable:false}});};\nn.prototype.isInUse=function(){return this._refCount>0;};\nn.prototype.addRef=function(){++this._refCount;return this;};\nn.prototype.release=function(){--this._refCount;return this;};\nn.prototype.destroy=function(){};\nvar o=function(e,g,i){n.call(this,e);Object.defineProperties(this,{content:{value:i,writable:false,enumerable:true},vdsSourceDatum:{value:g,writable:false,enumerable:true}});};o.prototype=Object.create(n.prototype);o.prototype.constructor=o;\no.prototype.destroy=function(){if(this.vdsSourceDatum){this.vdsSourceDatum.release();}n.prototype.destroy.call(this);};\nvar p=function(e,g,i){Object.defineProperties(this,{dvlSceneId:{value:e,writable:false,enumerable:true},sourceDatum:{value:g,writable:false,enumerable:true},root:{value:!!i,writable:false,enumerable:true},_refCount:{value:0,writable:true,enumerable:false}});};\np.prototype.isInUse=function(){return this._refCount>0;};\np.prototype.addRef=function(){++this._refCount;return this;};\np.prototype.release=function(){--this._refCount;return this;};\np.prototype.destroy=function(){if(this.sourceDatum){this.sourceDatum.release();}};\nvar r=function(e,g){Object.defineProperties(this,{source:{value:e.getSource()},sourceType:{value:e.getSourceType()},sourceId:{value:e.getSourceId(),writable:true},name:{value:e.getName()},localMatrix:{value:e.getLocalMatrix(),writable:true},password:{value:e.getPassword()},children:{value:e.getContentResources().map(function(e){return new r(e);})},dvlSceneDatum:{value:null,writable:true},nodeProxy:{value:null,writable:true},fake:{value:!!g},sourceProperties:{value:null,writable:true}});e._shadowContentResource=this;};\nr.prototype.destroy=function(){if(this.dvlSceneDatum){this.dvlSceneDatum.release();}};\nvar s=function(e,g){Object.defineProperties(this,{vkScene:{value:e},shadowContentResource:{value:g}});};\nvar t=E.extend("sap.ui.vk.dvl.GraphicsCore",{\nmetadata:{publicMethods:["attachSceneLoadingFinished","attachSceneLoadingProgress","attachSceneLoadingStarted","buildSceneTree","buildSceneTreeAsync","createViewStateManager","destroyScene","destroyViewStateManager","detachSceneLoadingFinished","detachSceneLoadingProgress","detachSceneLoadingStarted","getApi","loadContentResourcesAsync","showDebugInfo","updateSceneTree","updateSceneTreeAsync"]},\nconstructor:function(e,g){E.apply(this);var i=q.extend({},e,{filePackagePrefixURL:q.sap.getResourcePath("sap/ui/vk/ve")+"/"});this._dvlClientId=q.sap.uid();var m=this;this._initialized=new Promise(function(z){m._initResolve=z;});sap.ve.dvl.createRuntime(i).then(function(z){m._dvl=z;m._dvl.CreateCoreInstance(m._dvlClientId);c(m._dvl.Core.Init(m._DVLMajorVersion,m._DVLMinorVersion));var A=sap.ui.getCore();A.attachLocalizationChanged(m._onlocalizationChanged,m);c(m._dvl.Core.SetLocale(A.getConfiguration().getLanguageTag()));m._canvas=m._createRenderingCanvasAndContext(g);m._rendererId=d(m._dvl.Core.CreateRenderer());m._dvl.Renderer.SetOptionF(sap.ve.dvl.DVLRENDEROPTIONF.DVLRENDEROPTIONF_DPI,96*window.devicePixelRatio,m._rendererId);m._initResolve();});this._sourceData=[];this._dvlSceneData=[];this._vkSceneData=[];this._viewports=[];this._renderLoopRequestId=null;this._renderLoopFunction=this._renderLoop.bind(this);this._viewStateManagers=[];},\n_DVLMajorVersion:7,\n_DVLMinorVersion:4\n});\nt.create=function(e,i){return new Promise(function(m,z){try{var g=new t(e,i);g._initialized.then(function(){m(g);});}catch(A){z(A);}});};\nt.prototype.destroy=function(){sap.ui.getCore().detachLocalizationChanged(this._onlocalizationChanged,this);var e=this._viewports.slice();e.reverse();e.forEach(function(g){g.control.setGraphicsCore(null);});this._viewports=null;this._cleanupVkSceneData();this._vkSceneData=null;this._cleanupDvlSceneData();this._dvlSceneData=null;this._cleanupSourceData();this._sourceData=null;this._viewStateManagers.slice().forEach(this.destroyViewStateManager.bind(this));this._viewStateManagers=null;this._webGLContext=null;this._canvas=null;this._dvl.Core.DeleteRenderer(this._rendererId);this._rendererId=null;this._dvl.Core.Release();this._dvl=null;E.prototype.destroy.apply(this);};\nt.prototype._createRenderingCanvasAndContext=function(e){var g=document.createElement("canvas");g.id=q.sap.uid();this._webGLContext=this._dvl.Core.CreateWebGLContext(g,e);return g;};\nt.prototype._getCanvas=function(){return this._canvas;};\nt.prototype._getWebGLContext=function(){return this._webGLContext;};\nt.prototype._getDvl=function(){return this._dvl;};\nt.prototype._getDvlClientId=function(){return this._dvlClientId;};\nt.prototype._findSourceData=function(e){var g=Object.getOwnPropertyNames(e);return this._sourceData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};\nt.prototype._destroySourceDatum=function(e){if(!(e instanceof o)){this._dvl.Core.DeleteFileByUrl(k(e.source),j(e.source));}e.destroy();return this;};\nt.prototype._cleanupSourceData=function(){var e=false;for(var i=this._sourceData.length-1;i>=0;--i){var g=this._sourceData[i];if(!g.isInUse()){var m=g instanceof o?g.vdsSourceDatum:null;this._sourceData.splice(i,1);this._destroySourceDatum(g);if(m&&!m.isInUse()){e=true;}}}if(e){this._cleanupSourceData();}return this;};\nt.prototype._findDvlSceneData=function(e){var g=Object.getOwnPropertyNames(e);return this._dvlSceneData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};\nt.prototype._destroyDvlSceneDatum=function(e){this._dvl.Scene.Release(e.dvlSceneId);e.destroy();return this;};\nt.prototype._cleanupDvlSceneData=function(){for(var i=this._dvlSceneData.length-1;i>=0;--i){var e=this._dvlSceneData[i];if(!e.isInUse()){this._dvlSceneData.splice(i,1);this._destroyDvlSceneDatum(e);}}};\nt.prototype._findVkSceneData=function(e){var g=Object.getOwnPropertyNames(e);return this._vkSceneData.filter(function(i){return g.every(function(m){return e[m]===i[m];});});};\nt.prototype._cleanupVkSceneData=function(){for(var i=this._vkSceneData.length-1;i>=0;--i){this.destroyScene(this._vkSceneData[i].vkScene);}};\nt.prototype._destroyShadowContentResource=function(g,i){if(i.children){i.children.forEach(this._destroyShadowContentResource.bind(this,g));}if(i.nodeProxy){var m=g.getDefaultNodeHierarchy();try{m.removeNode(i.nodeProxy.getNodeRef());}catch(e){var z="Failed to delete node with ID = "+i.nodeProxy.getNodeRef()+".";if(e instanceof b){z+=" Error code: "+e.code+". Message: "+e.message+".";}l.error(z);}m.destroyNodeProxy(i.nodeProxy);}i.destroy();};\nt.prototype._filterContentResources=function(e,g){var i=[];e.forEach(function enumerate(m){if(g(m)){i.push(m);}m.getContentResources().forEach(enumerate);});return i;};\nt.prototype._getContentResourcesWithMissingPasswords=function(g){var i=this._dvl.Library;return this._filterContentResources(g,function(m){var z=m.getSource();try{return z&&(f(i.RetrieveInfo(k(z),j(z))).flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED)&&!m.getPassword();}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file \'"+k(z)+"\'");return false;}});};\nt.prototype._getContentResourcesWithEncryptedVds3=function(g){var i=this._dvl.Library;return this._filterContentResources(g,function(m){var z=m.getSource();if(z){try{var A=f(i.RetrieveInfo(k(z),j(z)));return A.major<=3&&(A.flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED);}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file \'"+k(z)+"\'");return false;}}else{return false;}});};\nt.prototype._collectAndCheckSourceProperties=function(g){var i=g.dvlSceneDatum.sourceDatum;if(!i){return this;}try{if(i instanceof o){i=i.vdsSourceDatum;}var m=f(this._dvl.Library.RetrieveInfo(k(i.source),j(i.source)));g.sourceProperties={version:{major:m.major,minor:m.minor}};if(m.flags&(sap.ve.dvl.DVLFILEFLAG.PAGESCOMPRESSED|sap.ve.dvl.DVLFILEFLAG.WHOLEFILECOMPRESSED)){g.sourceProperties.compressed=true;}if(m.flags&sap.ve.dvl.DVLFILEFLAG.ENCRYPTED){g.sourceProperties.encrypted=true;}}catch(e){l.warning("Failed to get information from Emscripten virtual file system about file \'"+k(g.source)+"\'");}return this;};\nt.prototype.loadContentResourcesAsync=function(e,g,i){var z=this,A=[],B=new Map();e.forEach(function enumerate(m){var K=m.getSource();if(K&&A.indexOf(K)<0&&z._findSourceData({source:K}).length===0){A.push(K);var L=m.getSource();var N;if(L instanceof Object){N=L.name;}else{N=L;}if(m.getSourceType()==="vdsl"||m.getSourceType()==="vds"&&N.split(".").pop()==="vdsl"){B.set(K,{});}}m.getContentResources().forEach(enumerate);});var F=[];if(A.length>0){var I;var J=new a(A,null,this._authorizationHandler).attachItemSucceeded(function(K){var L=K.getParameter("source");var N=K.getParameter("response");if(B.has(L)){var O=u(N);if(O.trim().length===0){I=I||[];I.push({source:L,status:M.VIT22.code,statusText:h().getText(M.VIT22.summary)});l.error(h().getText(M.VIT22.summary),M.VIT22.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var P=O.split(/\\n|\\r\\n/);var m=P[0].match(/^file=(.+)$/);if(!m){I=I||[];I.push({source:L,status:M.VIT23.code,statusText:h().getText(M.VIT23.summary)});l.error(h().getText(M.VIT23.summary),M.VIT23.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var Q=B.get(L);Q.content=P;var R=m[1];var T=R;var W=new U(T);if(W.is("relative")){if(L instanceof File){I=I||[];I.push({source:L,status:M.VIT24.code,statusText:h().getText(M.VIT24.summary)});l.error(h().getText(M.VIT24.summary),M.VIT24.code,"sap.ui.vk.dvl.GraphicsCore");return;}else{var X=new U(L);R=W.absoluteTo(X).href();}}Q.referencedSource=R;Q.content[0]=Q.content[0].replace(T,this._dvl.Core.GetFilename(Q.referencedSource,"remote"));if(A.indexOf(Q.referencedSource)<0&&this._findSourceData({source:Q.referencedSource}).length===0){A.push(Q.referencedSource);J.queue(Q.referencedSource);}}}}else{var Y=L instanceof File;var Z=Y?L.name:L;var $=j(L);this._dvl.Core.CreateFileFromArrayBuffer(N,Z,$);F.push(new n(L));}},this).attachAllItemsCompleted(function(m){Array.prototype.push.apply(this._sourceData,F);B.forEach(function(K,L){var N=this._findSourceData({source:K.referencedSource})[0];if(N){var O=new o(L,N,K.content.join("\\n"));this._sourceData.push(O);N.addRef();}}.bind(this));if(g){g(I);}},this).attachItemFailed(function(m){I=I||[];I.push({source:m.getParameter("source"),status:m.getParameter("status"),statusText:m.getParameter("statusText")});},this);if(i){J.attachItemProgress(i,this);}J.start();}else if(g){g();}return this;};\nt.prototype._buildPlaceholders=function(e,g,i,m){var z=[];m.forEach(function build(g,i,A){var B=e.createNode(g,A.name,i);A.nodeProxy=e.createNodeProxy(B);if(A.localMatrix){A.nodeProxy.setLocalMatrix(A.localMatrix);}if(A.source){z.push(A);}A.children.forEach(build.bind(this,B,null));}.bind(this,g,i));return z;};\nt.prototype._updatePlaceholders=function(e,g,m){var z=this,A=e.getDefaultNodeHierarchy(),B=[];(function update(F,m,I){function J(N,O){if(!N&&!O){return true;}else if(!!N^!!O){return false;}else{return N.source===O.getSource()&&N.sourceType===O.getSourceType()&&N.name===O.getName()&&N.password===O.getPassword();}}function K(N,O){O._shadowContentResource=N;N.sourceId=O.getSourceId();N.localMatrix=O.getLocalMatrix();if(N.nodeProxy){N.nodeProxy.setLocalMatrix(N.localMatrix);}}var i=0;var L=q.sap.arrayDiff(F,m,J,true);L.forEach(function(N){for(;i<N.index;++i){update(F[i].children,m[i].getContentResources(),F[i].nodeProxy.getNodeRef());K(F[i],m[i]);}if(N.type==="delete"){z._destroyShadowContentResource(e,F[N.index]);F.splice(N.index,1);}else if(N.type==="insert"){var O;if(i<F.length&&F[i].nodeProxy){O=F[i].nodeProxy.getNodeRef();}var P=new r(m[N.index]);B=B.concat(z._buildPlaceholders(A,I,O,[P]));F.splice(N.index,0,P);++i;}});for(;i<F.length;++i){update(F[i].children,m[i].getContentResources(),F[i].nodeProxy&&F[i].nodeProxy.getNodeRef());K(F[i],m[i]);}})(g.fake?g.children:[g],m,null);return B;};\nt.prototype._loadAndMergeContentResource=function(g,i){if(i.source){var m=this._findSourceData({source:i.source})[0];if(!m){l.warning("Failed to load content resource with sourceId \'"+i.sourceId+"\' due to failed downloading from URL \'"+k(i.source)+"\'.");}else{var z=i.nodeProxy.getNodeRef();var A=this._findDvlSceneData({sourceDatum:m,root:false})[0];if(!A){try{A=new p(d(m instanceof o?this._dvl.Core.LoadSceneFromVDSL(m.content,i.password):this._dvl.Core.LoadSceneByUrl(k(i.source),i.password,j(i.source))),m,false);}catch(e){l.error(h().getText(M.VIT34.summary)+": "+k(i.source),M.VIT34.code,"sap.ui.vk.dvl.GraphicsCore");return;}this._dvlSceneData.push(A);m.addRef();}i.dvlSceneDatum=A;A.addRef();this._collectAndCheckSourceProperties(i);this._dvl.Renderer.ResetView(sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA,this._rendererId);this._dvl.Scene.Merge(g._dvlSceneRef,A.dvlSceneId,z);}}};\nt.prototype.buildSceneTree=function(g){if(g.length===0){return null;}var i;var m;var z=g.map(function(I){return new r(I);});if(z.length===1&&z[0].name==null){m=z[0];if(m.source){var A=this._findSourceData({source:m.source})[0];try{i=new p(d(A instanceof o?this._dvl.Core.LoadSceneFromVDSL(A.content,m.password):this._dvl.Core.LoadSceneByUrl(k(m.source),m.password,j(m.source))),A,true);}catch(e){l.error(h().getText(M.VIT34.summary)+": "+k(m.source),M.VIT34.code,"sap.ui.vk.dvl.GraphicsCore");return null;}A.addRef();}else{i=new p(this._dvl.Core.CreateEmptyScene(),null,true);}}else{var B=new C({sourceType:"vds",sourceId:q.sap.uid()});m=new r(B,true);B.destroy();B=null;Array.prototype.push.apply(m.children,z);z=[m];i=new p(this._dvl.Core.CreateEmptyScene(),null,true);}this._dvlSceneData.push(i);m.dvlSceneDatum=i;i.addRef();this._collectAndCheckSourceProperties(m);var F=new S(this,i.dvlSceneId);this._vkSceneData.push(new s(F,m));this._buildPlaceholders(F.getDefaultNodeHierarchy(),null,null,m.children).forEach(this._loadAndMergeContentResource.bind(this,F.getDefaultNodeHierarchy()));return F;};\nt.prototype.updateSceneTree=function(e,g,i){if(g.length===0){return null;}var m;var z=this._getContentResourcesWithEncryptedVds3(g);if(z.length>0){l.error(h().getText(M.VIT25.summary),M.VIT25.code,"sap.ui.vk.dvl.GraphicsCore");m=m||{};m.contentResourcesWithEncryptedVds3=z;}var A=this._getContentResourcesWithMissingPasswords(g);if(A.length>0){l.error(h().getText(M.VIT21.summary),M.VIT21.code,"sap.ui.vk.dvl.GraphicsCore");m=m||{};m.contentResourcesWithMissingPasswords=A;}if(m&&i){i(m);}if(!e){return this.buildSceneTree(g);}var B=this._findVkSceneData({vkScene:e})[0].shadowContentResource;var F=!!B.source;var I=g.length===1&&!!g[0].getSource();if(!(F&&I&&B.source===g[0].getSource()||!F&&!I&&B.fake===g.length>1)||!B.fake&&g.length===1&&B.name!==g[0].getName()){return this.buildSceneTree(g);}this._updatePlaceholders(e,B,g).forEach(this._loadAndMergeContentResource.bind(this,e.getDefaultNodeHierarchy()));e.getDefaultNodeHierarchy().fireChanged();return e;};\nt.prototype._loadDvlSceneAsync=function(g,i){return new Promise(function(m,z){var A;var B=function(J){A();this.fireSceneLoadingFinished({source:g.source,sceneId:J.sceneId});m(J.sceneId);};var F=function(J){A();var K=J.errorMessage;if(K==null){K=sap.ve.dvl.DVLRESULT.getDescription?sap.ve.dvl.DVLRESULT.getDescription(J.errorCode):"";}var L={source:g.source,errorCode:J.errorCode,errorMessage:K};this.fireSceneLoadingFinished(L);z(L);};var I=function(J,K){this.fireSceneLoadingProgress({source:k(g.source),percentage:K});return true;}.bind(this);A=function(){this._dvl.Client.NotifyFileLoadProgress=null;this._dvl.Client.detachSceneFailed(F,this);this._dvl.Client.detachSceneLoaded(B,this);}.bind(this);this._dvl.Client.attachSceneLoaded(B,this);this._dvl.Client.attachSceneFailed(F,this);this._dvl.Client.NotifyFileLoadProgress=I;this.fireSceneLoadingStarted({source:k(g.source)});try{c(g instanceof o?this._dvl.Core.LoadSceneFromVDSLAsync(g.content,i):this._dvl.Core.LoadSceneByUrlAsync(k(g.source),i,j(g.source)));}catch(e){A();F.call(this,{errorCode:e instanceof b?e.code:sap.ve.dvl.DVLRESULT.FAIL,errorMessage:e instanceof b?null:e});}}.bind(this));};\nvar v=function(e,g){return new Promise(function(i){(function step(m){if(m>=e.length){i();}else{g(e[m]).catch(function(){}).then(function(){step(m+1);});}})(0);});};\nt.prototype._loadAndMergeContentResourcesAsync=function(e,g){var i,m=this;return v(g,function(z){if(z.source){var A=m._findSourceData({source:z.source})[0];if(!A){var B="Failed to load content resource with sourceId \'"+z.sourceId+"\' due to failed downloading from URL \'"+k(z.source)+"\'.";l.warning(B);i=i||[];i.push({errorMessage:B,source:z.source});return Promise.reject();}return(function(){var F=m._findDvlSceneData({sourceDatum:A,root:false})[0];if(F){return Promise.resolve(F);}else{return m._loadDvlSceneAsync(A,z.password).then(function(I){F=new p(I,A,false);m._dvlSceneData.push(F);A.addRef();return Promise.resolve(F);},function(I){i=i||[];i.push(I);return Promise.reject();});}})().then(function(F){z.dvlSceneDatum=F;F.addRef();m._collectAndCheckSourceProperties(z);var I=z.nodeProxy.getNodeRef();m._dvl.Renderer.ResetView(sap.ve.dvl.DVLRESETVIEWFLAG.CAMERA,m._rendererId);m._dvl.Scene.Merge(e._dvlSceneRef,F.dvlSceneId,I);return Promise.resolve();});}return Promise.resolve();}).then(function(){return Promise.resolve(i);});};\nt.prototype.buildSceneTreeAsync=function(e){if(e.length===0){return Promise.resolve(null);}var g=e.map(function(i){return new r(i);});return function(){var i;if(g.length===1&&g[0].name==null){i=g[0];if(i.source){var m=this._findSourceData({source:i.source})[0];if(m){return this._loadDvlSceneAsync(m,i.password).then(function(A){var B=new p(A,m,true);m.addRef();return Promise.resolve({shadowContentResource:i,dvlSceneDatum:B});});}else{return Promise.reject({errorMessage:"Failed to download the root content resource.",source:i.source});}}return Promise.resolve({shadowContentResource:i,dvlSceneDatum:new p(this._dvl.Core.CreateEmptyScene(),null,true)});}else{var z=new C({sourceType:"vds",sourceId:q.sap.uid()});i=new r(z,true);z.destroy();z=null;Array.prototype.push.apply(i.children,g);g=[i];return Promise.resolve({shadowContentResource:i,dvlSceneDatum:new p(this._dvl.Core.CreateEmptyScene(),null,true)});}}.call(this).then(function(i){this._dvlSceneData.push(i.dvlSceneDatum);i.shadowContentResource.dvlSceneDatum=i.dvlSceneDatum;i.dvlSceneDatum.addRef();this._collectAndCheckSourceProperties(i.shadowContentResource);var m=new S(this,i.dvlSceneDatum.dvlSceneId);this._vkSceneData.push(new s(m,i.shadowContentResource));var z=m.getDefaultNodeHierarchy();return this._loadAndMergeContentResourcesAsync(z,this._buildPlaceholders(m.getDefaultNodeHierarchy(),null,null,i.shadowContentResource.children)).then(function(A){return Promise.resolve({scene:m,failureReason:A});});}.bind(this));};\nt.prototype.updateSceneTreeAsync=function(e,g){if(g.length===0){return Promise.resolve(null);}var i=this._getContentResourcesWithEncryptedVds3(g);if(i.length>0){l.error(h().getText(M.VIT25.summary),M.VIT25.code,"sap.ui.vk.dvl.GraphicsCore");}var m=this._getContentResourcesWithMissingPasswords(g);if(m.length>0){l.error(h().getText(M.VIT21.summary),M.VIT21.code,"sap.ui.vk.dvl.GraphicsCore");}if(!e){return this.buildSceneTreeAsync(g);}var z=this._findVkSceneData({vkScene:e})[0].shadowContentResource;var A=!!z.source;var B=g.length===1&&!!g[0].getSource();if(!(A&&B&&z.source===g[0].getSource()||!A&&!B&&z.fake===g.length>1)||!z.fake&&g.length===1&&z.name!==g[0].getName()){return this.buildSceneTreeAsync(g);}return new Promise(function(F,I){var J=e.getDefaultNodeHierarchy();this._loadAndMergeContentResourcesAsync(J,this._updatePlaceholders(e,z,g)).then(function(K){F({scene:e,failureReason:K});J.fireChanged();});}.bind(this));};\nt.prototype.destroyScene=function(e){var g;for(g=0;g<this._vkSceneData.length;++g){if(this._vkSceneData[g].vkScene===e){break;}}if(g===this._vkSceneData.length){l.warning("Scene with id \'"+e.getId()+"\' is not created by this GraphicsCore.");return this;}var i=this._vkSceneData.splice(g,1)[0];this._destroyShadowContentResource(e,i.shadowContentResource);e.destroy();return this;};\nvar w=function(e,g,m){for(var i=0,z=e.length;i<z;++i){if(g.call(m,e[i],i,e)){return i;}}return-1;};var x=function(e,g){return w(e,function(i){return i.control===g;});};var y=function(e,g){return w(e,function(i){return i.rendererId===g;});};\nt.prototype._registerViewport=function(e){if(x(this._viewports,e)>=0){return false;}var g={control:e,canvas:null,rendererId:null};if(this._viewports.length===0){g.canvas=this._canvas;g.rendererId=this._rendererId;this._startRenderLoop();}else{if(this._viewports.length===1){var i=this._viewports[0];i.control._setCanvas(i.canvas=document.createElement("canvas"));this._dvl.Client.attachFrameFinished(this._handleFrameFinished,this);}g.canvas=document.createElement("canvas");g.rendererId=this._dvl.Core.CreateRenderer();}e._setCanvas(g.canvas);e._setRenderer(g.rendererId);e.attachResize(this._handleViewportResize,this);this._viewports.push(g);return true;};\nt.prototype._deregisterViewport=function(e){var i=x(this._viewports,e);if(i<0){return false;}var g=this._viewports.splice(i,1)[0];if(this._viewports.length===0){this._stopRenderLoop();}else{if(this._viewports.length===1){this._dvl.Client.detachFrameFinished(this._handleFrameFinished,this);var m=this._viewports[1-i];m.control._setCanvas(m.canvas=this._canvas);}this._dvl.Core.DeleteRenderer(g.rendererId);}e.detachResize(this._handleViewportResize,this);e._setRenderer(null);e._setCanvas(null);return true;};\nt.prototype._getViewportCount=function(){return this._viewports.length;};\nt.prototype._handleViewportResize=function(e){if(this._viewports.length>1){this._canvas.width=Math.max.apply(null,this._viewports.map(function(g){return g.canvas.width;}));this._canvas.height=Math.max.apply(null,this._viewports.map(function(g){return g.canvas.height;}));}};\nt.prototype._startRenderLoop=function(){if(!this._renderLoopRequestId){this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);}return this;};\nt.prototype._stopRenderLoop=function(){if(this._renderLoopRequestId){window.cancelAnimationFrame(this._renderLoopRequestId);this._renderLoopRequestId=null;}return this;};\nt.prototype._renderLoop=(function(){var e;return function(){var m=this._viewports.length>1;this._viewports.forEach(function(g){var i=g.canvas,z=g.rendererId;this._dvl.Renderer._processCommandQueue(z);if(i.width>0&&i.height>0&&this._dvl.Renderer.ShouldRenderFrame(z)){if(m&&e!==z){this._dvl.Renderer.SetDimensions(i.width,i.height,z);}g.control.renderFrame();e=z;}},this);this._renderLoopRequestId=window.requestAnimationFrame(this._renderLoopFunction);};})();\nt.prototype._handleFrameFinished=function(e){if(this._viewports.length>1){var i=y(this._viewports,e.rendererId);if(i>=0){var g=this._viewports[i].canvas,m=g.getContext("2d"),z=g.width,A=g.height;m.drawImage(this._canvas,0,this._canvas.height-A,z,A,0,0,z,A);}}};\nt.prototype.createViewStateManager=function(e,g){var i=new V();i._setNodeHierarchy(e).setShouldTrackVisibilityChanges(g);this._viewStateManagers.push(i);return i;};\nt.prototype.destroyViewStateManager=function(e){var i=this._viewStateManagers.indexOf(e);if(i>=0){this._viewStateManagers.splice(i,1)[0].destroy();}return this;};\nt.prototype.showDebugInfo=function(e){this._viewports.forEach(function(g){g.control.setShowDebugInfo(e);});return this;};\nt.prototype.getApi=function(e){switch(e){case G.LegacyDvl:return this._dvl;default:return null;}};\nt.prototype.collectGarbage=function(){this._cleanupDvlSceneData();this._cleanupSourceData();return this;};\nt.prototype._onlocalizationChanged=function(e){if(e.getParameter("changes").language){c(this._dvl.Core.SetLocale(sap.ui.getCore().getConfiguration().getLanguageTag()));}};\nt.prototype.setDecryptionHandler=function(e){this._dvl.Client.setDecryptionHandler(e);return this;};\nt.prototype.setAuthorizationHandler=function(e){this._authorizationHandler=e;return this;};\nt.prototype.getDecryptionHandler=function(){return this._dvl.Client.getDecryptionHandler();};\nt.prototype.attachSceneLoadingFinished=function(e,g,i){return this.attachEvent("sceneLoadingFinished",e,g,i);};\nt.prototype.detachSceneLoadingFinished=function(e,g){return this.detachEvent("sceneLoadingFinished",e,g);};\nt.prototype.fireSceneLoadingFinished=function(e,g,i){return this.fireEvent("sceneLoadingFinished",e,g,i);};\nt.prototype.attachSceneLoadingProgress=function(e,g,i){return this.attachEvent("sceneLoadingProgress",e,g,i);};\nt.prototype.detachSceneLoadingProgress=function(e,g){return this.detachEvent("sceneLoadingProgress",e,g);};\nt.prototype.fireSceneLoadingProgress=function(e,g,i){return this.fireEvent("sceneLoadingProgress",e,g,i);};\nt.prototype.attachSceneLoadingStarted=function(e,g,i){return this.attachEvent("sceneLoadingStarted",e,g,i);};\nt.prototype.detachSceneLoadingStarted=function(e,g){return this.detachEvent("sceneLoadingStarted",e,g);};\nt.prototype.fireSceneLoadingStarted=function(e,g,i){return this.fireEvent("sceneLoadingStarted",e,g,i);};\nreturn t;});\n'
},"sap/ui/vk/library-preload"
);
//# sourceMappingURL=library-preload.js.map