/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./thirdparty/three","../View","../AnimationPlayback"],function(t,V,A){"use strict";var a=function(){};a.prototype._getChildNodesWithMaterial=function(p,c){for(var b=0;p.children&&b<p.children.length;b++){var d=p.children[b];if(d&&d.material&&d.material.color){c.push(d);}this._getChildNodesWithMaterial(d,c);}};a.prototype.addAnimationTracksToHighlight=function(h){var d=h.duration;if(!h.cycles){h.cycles=0;}else{d/=2;}var n=false;var o;for(o=0;h.opacities&&o<h.opacities.length;o++){if(h.opacities[o]!==1){n=true;break;}}var b;var k,e;if(n){b={};b.times=[];b.values=[];e=h.duration/h.opacities.length;for(k=0;k<h.cycles+1;k++){for(o=0;o<h.opacities.length;o++){b.values.push(h.opacities[o]);b.times.push(e*(k*h.opacities.length+o));if(h.type==="STATIC"){break;}}if(h.type==="STATIC"){break;}}b.data={};b.data.type="OPACITY";b.data.highlight=h;h.duration=b.times[b.times.length-1];}var f=false;var g;for(g=0;h.colours&&g<h.colours.length;g++){var c=h.colours[g];if(c[3]!==0&&(c[0]!==0||c[1]!==0||c[2]!==0)){f=true;break;}}var i;if(f){if(h.type==="INFINITE"&&h.colours.length===1){var j=[0,0,0,0];h.colours.push(j);}i={};i.times=[];i.values=[];e=h.duration/h.colours.length;for(k=0;k<h.cycles+1;k++){for(g=0;g<h.colours.length;g++){var l=h.colours[g];i.values.push(l[0],l[1],l[2],l[3]);i.times.push(e*(k*h.opacities.length+g));if(h.type==="STATIC"){break;}}if(h.type==="STATIC"){break;}}i.data={};i.data.type="COLOR";i.data.highlight=h;h.duration=i.times[i.times.length-1];}if(i){h.colorTrack=i;}if(b){h.opacityTrack=b;}};a.prototype.processHighlights=function(v,b,s){if(!v.highlights||!v.highlights.length){return;}var m=0;var h;var c;var d=false;for(h=0;h<v.highlights.length;h++){c=v.highlights[h];if(m<c.duration){m=c.duration;}if(c.type==="INFINITE"){d=true;}}var p=v.getPlaybacks();var e=b+"-"+"highlightSequence";var f=b+"-"+"highlightPlayback";var g=s.getAnimationSequence(e);var i;if(!g){g=s.createAnimationSequence(e);g.setHasHighlight(true);if(!p){p=[];}i=new A({sequenceId:e,pid:f,infinite:d,startTime:0});p.push(i);v.setPlaybacks(p);}for(var j=0;p&&j<p.length;j++){var k=p[j];var l=s.getAnimationSequence(k.getSequenceId());if(l){var n=l.getDuration();if(n>m){m=n;}if(!i&&k.getPid()===f){i=k;}}}if(!i){i=new A({sequenceId:e,pid:f,infinite:d,startTime:0});if(!p){p=[];}p.push(i);v.setPlaybacks(p);}if(Math.abs(m-0.0)<1e-6){m=0.001;}if(d){i.setInfinite(true);}if(!g.userData){g.userData={};}var r=true;if(!g.userData.maxDuration||Math.abs(g.userData.maxDuration-m)<1e-6){g.userData.maxDuration=m;}else{r=false;}for(h=0;h<v.highlights.length;h++){c=v.highlights[h];this._processHighlight(c,g,r);}};a.prototype._processHighlight=function(h,b,r){if(!h||(!h.opacityTrack&&!h.colorTrack)||!b){return;}if(!b.userData.highlights){b.userData.highlights=new Map();}for(var c=0;h.highlightNodes&&c<h.highlightNodes.length;c++){var n=h.highlightNodes[c];var d=[];if(n.material&&n.material.color){d.push(n);}else{this._getChildNodesWithMaterial(n,d);}if(d.length===0){continue;}var s=b.userData.highlights.get(n);if(s&&(!r)){continue;}else{b.userData.highlights.set(n,h);}if(h.opacityTrack){if(h.type==="STATIC"&&h.opacityTrack.values.length===1){h.opacityTrack.times.push(b.userData.maxDuration);h.opacityTrack.values.push(h.opacityTrack.values[h.opacityTrack.values.length-1]);}b.setOpacityTrack(n,h.opacityTrack.times,h.opacityTrack.values,"linear",true);}if(h.colorTrack){var e=false;if(h.colorTrack.times.length>1&&h.type!=="INFINITE"){e=true;}for(var f=0;f<d.length;f++){var N=d[f];var g=N.material;if(N.userData&&N.userData.originalMaterial){g=N.userData.originalMaterial;}var i=new THREE.Color();var j;var k={};k.times=[];k.values=[];k.data=h.colorTrack.data;var l=0.0;if(e){l=0.05;k.times.push(0.0);k.values.push(g.color.r,g.color.g,g.color.b);}for(j=0;j<h.colorTrack.times.length;j++){k.times.push(h.colorTrack.times[j]+l);i.fromArray(h.colorTrack.values,j*4).lerp(g.color,1-h.colorTrack.values[j*4+3]);k.values.push(i.r,i.g,i.b);}if(e){k.times.push(k.times[k.times.length-1]+0.05);k.values.push(g.color.r,g.color.g,g.color.b);}if(h.type==="INFINITE"){var m=0.05;if(k.times.length>1){m=k.times[k.times.length-1]-k.times[k.times.length-2];}l=k.times[k.times.length-1]+m;var o=l;while(o<b.userData.maxDuration){for(j=0;j<h.colorTrack.times.length&&o<b.userData.maxDuration;j++){o=h.colorTrack.times[j]+l;k.times.push(o);i.fromArray(h.colorTrack.values,j*4).lerp(g.color,1-h.colorTrack.values[j*4+3]);k.values.push(i.r,i.g,i.b);}l=o+m;}}if(h.type==="STATIC"&&k.values.length===1){k.times.push(b.userData.maxDuration);var v=k.values[k.values.length-3];var p=k.values[k.values.length-2];var q=k.values[k.values.length-1];k.values.push(v,p,q);}b.setColorTrack(N,k.times,k.values,"linear",true);}}}};a.prototype.insertTracks=function(b,c,n,s){var d=new Map();var e,f,g;var h,i;for(h=0;h<b.length;h++){e=b[h];var j=c.get(e.id);if(!j||!j.length){continue;}for(i=0;i<j.length;i++){f=n.get(j[i].targetId);if(!f){continue;}var N=d.get(j[i].sequenceId);if(!N){N=new Map();}g=N.get(f);if(!g){g=[];}e.data=j[i];g.push(e);N.set(f,g);d.set(j[i].sequenceId,N);}c.delete(e.id);}var k=d.entries();var l=k.next();while(!l.done){var m=l.value[0];var o=l.value[1];l=k.next();var p=s.getAnimationSequence(m);if(!p){continue;}var q=o.entries();var r=q.next();while(!r.done){f=r.value[0];g=r.value[1];r=q.next();var u=null;for(h=0;h<g.length;h++){e=g[h];if(e.data.pivot){u=e.data.pivot;break;}}var v={};var w={};var x={};for(h=0;h<g.length;h++){e=g[h];if(e.data.type==="TRANSLATE"){v=e;}else if(e.data.type==="ROTATE"){x=e;}else if(e.data.type==="SCALE"){w=e;}else if(e.data.type==="OPACITY"){p.setOpacityTrack(f,e.times,e.values,e.interpolation,e.cyclicInfo);}else if(e.data.type==="COLOR"){p.setColorTrack(f,e.times,e.values,e.interpolation,e.cyclicInfo);}}p.setPositionTracks(f,x.times,v.times,w.times,x.rotateType,x.values,v.values,w.values,u,x.interpolation,v.interpolation,w.interpolation,x.cyclicInfo,v.cyclicInfo,w.cyclicInfo);}}return this;};a.prototype.setInitialNodePositionsFromSubsequentViews=function(v,s,o){if(!v||!v.length){return;}var b,n,c;var d=new Map();for(var e=v.length-1;e>0;e--){var f=v[e];var g;if(f){g=f.getPlaybacks();}if(g){for(var p=g.length-1;p>=0;p--){var h=g[p];if(h){b=s.getAnimationSequence(h.getSequenceId());if(b){if(o&&!b.hasHighlight()){continue;}if(!h.getReversed()){n=b.getNodesStartValues().entries();}else{n=b.getNodesEndValues().entries();}c=n.next();while(!c.done){d.set(c.value[0],c.value[1]);c=n.next();}}}}}var i=v[e-1];if(i){if(!i.userData){i.userData={};}if(!i.userData.nodeStartDataByAnimation){i.userData.nodeStartDataByAnimation=new Map();}n=d.entries();c=n.next();while(!c.done){i.userData.nodeStartDataByAnimation.set(c.value[0],c.value[1]);c=n.next();}}}};a.prototype.setInitialNodePositionsFromPreviousViews=function(v,s,o){if(!v||!v.length){return;}var b,n,c;var d=new Map();for(var e=0;e<v.length-1;e++){var p=v[e];var f;if(p){f=p.getPlaybacks();}if(f){for(var g=0;g<f.length;g++){var h=f[g];if(h){b=s.getAnimationSequence(h.getSequenceId());if(b){if(o&&!b.hasHighlight()){continue;}if(!h.getReversed()){n=b.getNodesEndValues().entries();}else{n=b.getNodesStartValues().entries();}c=n.next();while(!c.done){d.set(c.value[0],c.value[1]);c=n.next();}}}}}var i=v[e+1];if(i){if(!i.userData){i.userData={};}if(!i.userData.nodeStartDataByAnimation){i.userData.nodeStartDataByAnimation=new Map();}n=d.entries();c=n.next();while(!c.done){i.userData.nodeStartDataByAnimation.set(c.value[0],c.value[1]);c=n.next();}}}};a.prototype.setInitialNodePositionsOnView=function(v,s,o){if(!v){return;}var n,b;var c=0;var d=null;d=v.getPlaybacks();if(!d||!d.length){return;}if(!v.userData){v.userData={};}if(!v.userData.nodeStartDataByAnimation){v.userData.nodeStartDataByAnimation=new Map();}for(var e=d.length-1;e>=c;e--){var p=d[e];var f=s.getAnimationSequence(p.getSequenceId());if(f){if(o&&!f.hasHighlight()){continue;}if(p.getReversed()){n=f.getNodesEndValues().entries();}else{n=f.getNodesStartValues().entries();}b=n.next();while(!b.done){v.userData.nodeStartDataByAnimation.set(b.value[0],b.value[1]);b=n.next();}}}};a.prototype.setInitialNodePositionsFromCurrenetViews=function(v,s,o){if(!v||!v.length){return;}for(var b=0;b<v.length;b++){var c=v[b];if(!c){continue;}this.setInitialNodePositionsOnView(c,s,o);}};a.prototype.setPlaybackStartTimes=function(v,s){if(!v||!v.length){return;}for(var b=0;b<v.length;b++){var c=v[b];if(!c){continue;}var d=null;if(c){d=c.getPlaybacks();}if(!d||!d.length){continue;}var e=0;for(var f=0;f<d.length;f++){var p=d[f];var g=s.getAnimationSequence(p.getSequenceId());if(g&&g.hasHighlight()){continue;}var h;if(g){h=g.getNativeAnimationClip();}if(h&&!h.hasOptimized){h.resetDuration();h.optimize();h.hasOptimized=true;}if(h){p.setStartTime(e);var i=1;if(p.getTimeScale()&&p.getTimeScale()>0){i=1/p.getTimeScale();}var r=1;if(p.getRepeat()>1){r=p.getRepeat();}e+=p.getPreDelay()+r*g.getDuration()*i+p.getPostDelay();}}}};a.prototype.prepareViewForAnimation=function(v){var n;if(v&&v.getNodeInfos){n=v.getNodeInfos();}if(!n){return;}if(!v.userData){v.userData={};}if(!v.userData.nodesDataByView){v.userData.nodesDataByView=new Map();}else{return;}function b(g){return new THREE.Matrix4().set(g[0],g[1],g[2],g[3],g[4],g[5],g[6],g[7],g[8],g[9],g[10],g[11],0,0,0,1);}for(var c=0;c<n.length;c++){var d=n[c];if(!d||!d.target){continue;}var e={};if(d.transform){e.position=new THREE.Vector3();e.scale=new THREE.Vector3();e.quaternion=new THREE.Quaternion();var f=b(d.transform);f.decompose(e.position,e.quaternion,e.scale);v.userData.nodesDataByView.set(d.target,e);}}};a.prototype.getNodePositionByView=function(v,n){var d;if(!v){return d;}if(!v.userData||!v.userData.nodesDataByView){this.prepareViewForAnimation(v);}if(v.userData&&v.userData.nodesDataByView){d=v.userData.nodesDataByView.get(n);}return d;};a.prototype.getNodePositionFromNearestPlayback=function(s,v,b,n){var d;if(!v||!s){return d;}var p=v.getPlaybacks();if(!p){return d;}var c,e;var f=0;for(c=0;c<p.length;c++){e=p[c];if(b==e.getSequenceId()){f=e.getStartTime();break;}}var m=0;for(c=0;c<p.length;c++){e=p[c];var g=e.getStartTime();if(f<=g){continue;}if(b==e.getSequenceId()){continue;}var h=s.getAnimationSequence(e.getSequenceId());if(h){var i;if(e.getReversed()){i=h.getNodesStartValues();}else{i=h.getNodesEndValues();}var j=i.get(n);if(j&&g>=m){d=j;m=g;}}}return d;};return a;});
