/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./thirdparty/three","sap/ui/base/ManagedObject","./Billboard","../thirdparty/html2canvas","./PolylineGeometry","./PolylineMaterial","./PolylineMesh","../BillboardStyle","../LeaderLineMarkStyle"],function(a,B,b,c,P,d,e,f,L){"use strict";var C=b.extend("sap.ui.vk.threejs.Callout",{metadata:{properties:{anchorNode:{type:"any",defaultValue:null},depthTest:{type:"boolean",defaultValue:true}}}});C.prototype.init=function(){if(b.prototype.init){b.prototype.init.call(this);}this._lines=[];};C.prototype.setRenderOrder=function(h){b.prototype.setRenderOrder.call(this,h);this._lines.forEach(function(l){l.renderOrder=h;});return this;};C.prototype.setDepthTest=function(h){this.setProperty("depthTest",h,true);this._billboard.material.depthTest=h;this._lines.forEach(function(l){l.material.depthTest=h;});return this;};var g=new THREE.Vector4(),j=new THREE.Vector4(),k=new THREE.Vector4(),m=new THREE.Vector2(),n=new THREE.Vector2(),o=new THREE.Vector2(),q=new THREE.Quaternion(),r=new THREE.Matrix4(),u=new THREE.Vector2(),v=new THREE.Vector3(),w=new THREE.Vector3(),z=new THREE.Vector3(0,0,1),A=new THREE.Vector2(),D=new THREE.Matrix4(),E=new THREE.Matrix4();C.prototype._update=function(h,i,l){if(this._needUpdateTexture){this._needUpdateTexture=false;this._updateTexture();}var s=this.getNode();s.matrix.getInverse(s.parent.matrixWorld);s.matrix.decompose(s.position,s.quaternion,s.scale);s.matrixWorld.identity();var x=this.getPosition(),y=this._billboard.position;if(x){y.copy(x);}else{y.setScalar(0);}var F=this.getAnchorNode();if(F){y.applyMatrix4(F.matrixWorld);}this._billboard.quaternion.copy(i.quaternion);if(l){A.copy(l);}else{l=h.getSize();A.set(l.width,l.height);}D.multiplyMatrices(i.projectionMatrix,i.matrixWorldInverse);g.copy(y).applyMatrix4(D);m.copy(g).multiplyScalar(1/g.w).multiply(A);var G=g.w*2/(A.x*i.projectionMatrix.elements[0]);this._billboard.scale.set(G*this._width,G*this._height,1);v.setFromMatrixColumn(i.matrixWorld,0).multiplyScalar(G*(Math.round(m.x*0.5)-m.x*0.5));w.setFromMatrixColumn(i.matrixWorld,1).multiplyScalar(G*(Math.round(m.y*0.5)-m.y*0.5));y.add(v).add(w);this._billboard.updateMatrixWorld();var H=this.getStyle()===f.CircularShape;var I=i.near;function J(p,t,K){if(p<t){return p-t;}else if(p>K){return p-K;}return 0;}this._lines.forEach(function(p){if(p.userData.targetNode){p.matrix.copy(p.userData.targetNode.matrixWorld);}else{p.matrix.identity();}p.matrixWorld.copy(p.matrix);if(p.isPolylineMesh){p.material.resolution.copy(A);}if(p.isHaloMesh){return;}var K=p.geometry.vertices;var M=K[0];var N=K[K.length-2];var O=K[K.length-1];var Q=p.userData.startPointMesh;var R=false;var S=[0,K.length-1];if(Q!==undefined){M.copy(Q.userData.targetVertex);}E.multiplyMatrices(D,p.matrixWorld);if(p.userData.extensionLength>0&&K.length>2){S.push(K.length-2);g.copy(K[K.length-3]).applyMatrix4(E);n.copy(g).multiplyScalar(1/g.w).multiply(A);N.set(Math.sign(n.x-m.x)*0.5*(1+p.userData.extensionLength/this._width),0,0);N.applyMatrix4(this._billboard.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}g.copy(N).applyMatrix4(E);n.copy(g).multiplyScalar(1/g.w).multiply(A);if(H){var T=u.copy(n).sub(m).length();R=T<this._width;u.multiplyScalar(0.5/T);O.set(u.x,u.y,0);}else{var U=J(n.x,m.x-this._width,m.x+this._width),V=J(n.y,m.y-this._height,m.y+this._height);R=(U===0&&V===0);if(Math.abs(U)>Math.abs(V)){O.set(Math.sign(U)*0.5,0,0);}else{O.set(0,Math.sign(V)*0.5,0);}}if(R){O.copy(N);}else{O.applyMatrix4(this._billboard.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}p.geometry.verticesNeedUpdate=true;if(Q!==undefined){Q.position.copy(Q.userData.targetVertex).applyMatrix4(p.matrixWorld);g.copy(Q.position).applyMatrix4(D);var W=g.w/(A.x*i.projectionMatrix.elements[0]);Q.scale.setScalar(W);Q.visible=false;var X=false;if(g.w>=I){j.copy(g);k.copy(K[1]).applyMatrix4(E);if(k.w<I){var t=(j.w-I)/(j.w-k.w);k.sub(j).multiplyScalar(t).add(j);}o.copy(j).multiplyScalar(1/j.w);n.copy(k).multiplyScalar(1/k.w);u.copy(n).sub(o).multiply(A);X=u.length()<Q.userData.lineOffset;q.setFromAxisAngle(z,Math.atan2(u.y,u.x));Q.quaternion.copy(i.quaternion).multiply(q);Q.matrix.compose(Q.position,Q.quaternion,Q.scale);Q.matrixWorld.copy(Q.matrix);o.multiply(A).sub(m);Q.visible=H?o.length()>this._width:Math.abs(o.x)>this._width||Math.abs(o.y)>this._height;if(X||!Q.visible){M.copy(K[1]);}else{M.set(Q.userData.lineOffset,0,0).applyMatrix4(Q.matrixWorld).applyMatrix4(r.getInverse(p.matrixWorld));}}}p.geometry._updateVertices(S);p.computeLineDistances(E,A,i instanceof THREE.PerspectiveCamera?I:undefined);if(p.userData.haloMesh){p.userData.haloMesh.material.lineLength=p.material.lineLength;}}.bind(this));};C.prototype._createMarkMesh=function(p,t,F,G){var H=F===L.Arrow;var I=window.devicePixelRatio;var J=t.width;var K=J*t.haloWidth;G=(Array.isArray(G)||G instanceof Float32Array)&&G.length===2?G:[1,1];var M,N;if(H){M=Math.max(35*G[0],J*5);N=Math.max(15*G[1],J*2);}else{M=N=Math.max(2*G[0],J*2);}M=Math.ceil(M+K*2);N=Math.ceil(N+K*2);var O=document.createElement("canvas");O.width=THREE.Math.ceilPowerOfTwo(M*I);O.height=THREE.Math.ceilPowerOfTwo(N*I);var Q=O.getContext("2d");var x=M/2,y=N/2;Q.fillStyle="#FFF";Q.scale(I,I);if(H){Q.beginPath();Q.moveTo(0,y);Q.lineTo(M,0);Q.lineTo(M,N);Q.closePath();Q.fill();var h=M*y/Math.sqrt(M*M+y*y),s=(h-K)/h;var R=M-M*s,S=y*(M*s-K)/M;Q.fillStyle=p.getStyle();Q.beginPath();Q.moveTo(R,y);Q.lineTo(M-K,y-S);Q.lineTo(M-K,y+S);Q.closePath();Q.fill();}else{var T=M*0.5,U=T-K;Q.beginPath();Q.ellipse(x,y,T,T,0,0,Math.PI*2);Q.fill();Q.fillStyle=p.getStyle();Q.beginPath();Q.ellipse(x,y,U,U,0,0,Math.PI*2);Q.fill();}Q.fillRect(M-K,y-J*0.5,K,J);var V=new THREE.MeshBasicMaterial({map:new THREE.CanvasTexture(O),flatShading:true,transparent:true,alphaTest:0.05,premultipliedAlpha:true,side:THREE.DoubleSide,depthTest:this.getDepthTest()});var W=new THREE.PlaneBufferGeometry(M*2,N*2);if(H){W.translate(M,0,0);}var X=new THREE.Mesh(W,V);X.matrixAutoUpdate=false;X.renderOrder=this.getRenderOrder();X.userData.lineOffset=(H?M*2-1:M-K*2);var Y=new THREE.Vector2(M*I/O.width,N*I/O.height);var Z=X.geometry.attributes.uv.array;for(var i=0,l=Z.length;i<l;i+=2){Z[i]*=Y.x;Z[i+1]=1-(1-Z[i+1])*Y.y;}return X;};C.prototype.addLeaderLine=function(h,t,i,s,l,p,x){var y=this.getNode();if(x>0&&h.length<3){h.push(h[h.length-1].clone());}var F=i.userData.lineStyle||{};F.width=F.width||1;F.haloWidth=F.haloWidth||0;F.endCapStyle=F.endCapStyle||0;var G=F.endCapStyle||h.length>2?1:0;var H=(G&&(s!==L.None||F.endCapStyle===0)?1:0)|(G&&(l!==L.None||F.endCapStyle===0)?2:0);var I=new P();I.setVertices(h);var J;if(F.haloWidth>0){var K=new d({color:0xFFFFFF,lineColor:0xFFFFFF,linewidth:F.width*(F.haloWidth*2+1),dashCapStyle:F.endCapStyle,segmentCapStyle:G,trimStyle:H,transparent:true,depthTest:this.getDepthTest()});J=new e(I,K);J.userData.targetNode=t;J.matrixAutoUpdate=false;J.renderOrder=this.getRenderOrder();J.isHaloMesh=true;y.add(J);this._lines.push(J);}var M=new d({color:0xFFFFFF,lineColor:i.color,linewidth:F.width,dashCapStyle:F.endCapStyle,segmentCapStyle:G,trimStyle:H,dashPattern:F.dashPattern||[],dashScale:F.dashPatternScale||1,transparent:true,depthTest:this.getDepthTest()});var N=new e(I,M);N.userData.targetNode=t;N.userData.extensionLength=x;N.userData.haloMesh=J;N.matrixAutoUpdate=false;N.renderOrder=this.getRenderOrder();y.add(N);this._lines.push(N);if(s!==L.None){var O=this._createMarkMesh(i.color,F,s,p);O.userData.targetVertex=I.vertices[0].clone();N.userData.startPointMesh=O;y.add(O);}return N;};return C;});
