/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["./thirdparty/three","sap/ui/base/ManagedObject","../thirdparty/html2canvas","../DetailViewType","../DetailViewShape","./OrthographicCamera","./PerspectiveCamera"],function(t,B,c,D,d,O,P){"use strict";var e=B.extend("sap.ui.vk.threejs.DetailView",{metadata:{properties:{name:{type:"string",defaultValue:""},camera:{type:"any",defaultValue:null},type:{type:"sap.ui.vk.DetailViewType",defaultValue:D.DetailView},shape:{type:"sap.ui.vk.DetailViewShape",defaultValue:d.Box},borderWidth:{type:"float",defaultValue:2},backgroundColor:{type:"sap.ui.core.CSSColor",defaultValue:"#fff"},borderColor:{type:"sap.ui.core.CSSColor",defaultValue:"#000"},origin:{type:"any",defaultValue:new THREE.Vector3(0,0)},size:{type:"any",defaultValue:new THREE.Vector3(0.5,0.5)},attachmentPoint:{type:"any",defaultValue:null},metadata:{type:"any",defaultValue:{}},veId:{type:"any",defaultValue:{}}}}});e.prototype.init=function(){if(B.prototype.init){B.prototype.init.call(this);}this._backgroundColor=new THREE.Color();this._node=new THREE.Group();var b=new THREE.MeshBasicMaterial({depthTest:false});this._line=new THREE.Mesh(new THREE.BufferGeometry(),b);this._line.renderOrder=0;this._node.add(this._line);var a=new THREE.BufferGeometry();a.setIndex([0,1,2]);var f=new THREE.MeshBasicMaterial({color:this._backgroundColor,depthTest:false});this._triangle=new THREE.Mesh(a,f);this._triangle.renderOrder=1;this._node.add(this._triangle);this._billboard=new THREE.Mesh(new THREE.BufferGeometry(),new THREE.MeshBasicMaterial({depthTest:false}));this._billboard.renderOrder=2;this._node.add(this._billboard);this._border=new THREE.Mesh(new THREE.BufferGeometry(),b);this._border.renderOrder=3;this._node.add(this._border);};e.prototype.setCamera=function(a){if(a instanceof P||a instanceof O){this.setProperty("camera",a,true);}return this;};e.prototype.setShape=function(a){this.setProperty("shape",a,true);return this;};e.prototype.setBackgroundColor=function(a){this.setProperty("backgroundColor",a,true);this._backgroundColor.setStyle(a);this._triangle.material.color.copy(this._backgroundColor);return this;};e.prototype.setBorderColor=function(a){this.setProperty("borderColor",a,true);this._border.material.map=null;return this;};e.prototype.setBorderWidth=function(a){this.setProperty("borderWidth",a,true);this._border.material.map=null;return this;};e.prototype.setOrigin=function(a){if(a instanceof THREE.Vector2){this.setProperty("origin",a,true);}return this;};e.prototype.setSize=function(a){if(a instanceof THREE.Vector2){this.setProperty("size",a,true);}return this;};var g=-0.5,j=1.5,p=new THREE.Vector4(),k=new THREE.Vector3(),n=new THREE.Vector3(),o=new THREE.Vector3(),q=new THREE.Vector2(),s=new THREE.Vector2(),r=new THREE.Vector2(),v=new THREE.Matrix4();function z(a,b){return Math.PI*(3*(a+b)-Math.sqrt((3*a+b)*(a+3*b)));}function A(a,b,h,i,l,m){var u=a[b],w=a[b+1],x=a[l],y=a[l+1],J=a[m],K=a[m+1],L=i-w,M=u-h;var f=((x-u)*L+(y-w)*M)/((x-J)*L+(y-K)*M);a[l]=x+(J-x)*f;a[l+1]=y+(K-y)*f;}function C(f,a,b,h){q.set(f[b+1]-f[a+1],f[a]-f[b]).normalize().multiplyScalar(h);f[a]+=q.x;f[a+1]+=q.y;f[b]+=q.x;f[b+1]+=q.y;}function E(a,b){var f=a.length;for(var h=0;h<6;h+=3){var l=h===0?b*g:b*j;var m=a[h],u=a[h+1];for(var i=h;i<f-6;i+=6){var w=a[i],x=a[i+1];a[i]=m;a[i+1]=u;m=a[i+6];u=a[i+7];C(a,i,i+6,l);if(i>h){A(a,i-6,w,x,i,i+6);}}}}e.prototype._createBoxViewport=function(a,b,f,h){var l=[-a,-b,0,a,-b,0,a,b,0,-a,b,0];var m=this._billboard.geometry;m.setIndex([0,1,2,0,2,3]);m.addAttribute("position",new THREE.Float32BufferAttribute(l,3));m.addAttribute("uv",new THREE.Float32BufferAttribute([0,0,1,0,1,1,0,1],2));if(this._border.visible){var u=[],i;for(i=0;i<l.length;i+=3){var x=l[i],y=l[i+1];u.push(x,y,0,x,y,0);}u.push(u[0],u[1],0,u[0],u[1],0);E(u,this._borderWidth);i=u.length-6;u[0]=u[i];u[i+1]=u[1];u[3]=u[i+3];u[i+4]=u[4];this._createBorderGeometry(this._border.geometry,u);}};e.prototype._createCircleViewport=function(b,f,h,l){var m=[0,0,0],u=[0.5,0.5],w=[];var x=THREE.Math.clamp(Math.round(z(b,f)/24),32,256);var y=2*Math.PI/x;for(var i=0;i<x;i++){var a=i*y,J=Math.cos(a),K=Math.sin(a);m.push(J*b,K*f,0);u.push(J*0.5+0.5,K*0.5+0.5);w.push(0,i+1,i+1<x?i+2:1);}var L=this._billboard.geometry;L.setIndex(w);L.addAttribute("position",new THREE.Float32BufferAttribute(m,3));L.addAttribute("uv",new THREE.Float32BufferAttribute(u,2));var M=this._borderWidth*j;this._createCircleBorder(m,b,f,h&&q.set(h.x/(b+M),h.y/(f+M)).length()>1?h:null,l);};e.prototype._createCircleBorder=function(b,f,h,m,u){var w=this._borderWidth,J=[],i,x,y;if(m&&(u!==d.Circle&&u!==d.CircleLine)){J.push(m.x,m.y,0,m.x,m.y,0);var K=Math.PI*0.05;var L=Math.atan2(m.y*f,m.x*h)+K;var M=(b.length/3)-3;K=2*(Math.PI-K)/M;for(i=0;i<=M;i++){var a=L+i*K;x=Math.cos(a)*f;y=Math.sin(a)*h;J.push(x,y,0,x,y,0);}var N=[m.x,m.y,0,J[6],J[7],0,J[J.length-3],J[J.length-2],0];J.push(m.x,m.y,0,m.x,m.y,0);E(J,w);i=J.length-6;var Q=q.set(J[9],J[10]).sub(m).length();var R=q.set(J[9]-J[i-3],J[10]-J[i-2]).length()*0.5;var l=m.length();l=1-w*2*Q/(R*l);J[i+0]=J[0]=m.x*l;J[i+1]=J[1]=m.y*l;J[i+3]=J[3]=m.x;J[i+4]=J[4]=m.y;var S=this._triangle.geometry;l=(1+l)*0.5;N[0]*=l;N[1]*=l;S.addAttribute("position",new THREE.Float32BufferAttribute(N,3));this._triangle.visible=true;this._triangle.material.color.set(u===d.SolidPointer||u===d.SolidArrow?this.getBorderColor():this._backgroundColor);}else{this._line.visible=this._line.visible&&m!==null;for(i=3;i<b.length;i+=3){x=b[i];y=b[i+1];J.push(x,y,0,x,y,0);}J.push(J[0],J[1],0,J[0],J[1],0);E(J,w);i=J.length-6;J[i]=J[0]=b[3]+w*g;J[i+3]=J[3]=b[3]+w*j;J[i+1]=J[1]=b[4];J[i+4]=J[4]=b[4];}this._createBorderGeometry(this._border.geometry,J);};e.prototype._createBorderGeometry=function(a,b){var i,f=b.length/3;var h=[];for(i=2;i<f;i+=2){h.push(i-1,i,i-2,i+1,i,i-1);}var l=[];var u=this._borderU;for(i=0;i<f;i+=2){l.push(0,0.5,u,0.5);}a.setIndex(h);a.addAttribute("position",new THREE.Float32BufferAttribute(b,3));a.addAttribute("uv",new THREE.Float32BufferAttribute(l,2));};e.prototype._createLine=function(a){var b=[0,0,0,0,0,0,a.x,a.y,0,a.x,a.y,0];C(b,0,6,-this._borderWidth);C(b,3,9,this._borderWidth);this._createBorderGeometry(this._line.geometry,b);};e.prototype._updateGeometry=function(s,a,b){var f=this.getShape(),h=this.getAttachmentPoint(),i=this.getOrigin();this._border.visible=f!==d.BoxNoOutline;this._line.visible=f===d.BoxLine||f===d.CircleLine;this._triangle.visible=false;if(h){p.copy(h).applyMatrix4(b.matrixWorldInverse).applyMatrix4(b.projectionMatrix);h=p.w>0?h:null;var l=(p.x/p.w)*a.width/a.height,m=p.y/p.w;o.set(l-i.x,m-i.y,0).multiplyScalar(a.height);}switch(f){default:case d.Box:case d.BoxLine:case d.BoxNoOutline:this._createBoxViewport(s.x,s.y,h?o:null,f);break;case d.Circle:case d.CircleLine:case d.CirclePointer:case d.CircleArrow:case d.CircleBubbles:case d.SolidPointer:case d.SolidArrow:this._createCircleViewport(s.x,s.y,h?o:null,f);break;}if(this._line.visible){this._createLine(o);}};e.prototype._updateBorderTexture=function(a){var b=Math.round(this.getBorderWidth()*a);this._borderWidth=b+2;var f=THREE.Math.ceilPowerOfTwo(this._borderWidth);this._borderU=this._borderWidth/f;this._borderWidth/=a;var h=new ArrayBuffer(f*4);var l=new Uint32Array(h);var m=new THREE.Color(this.getBorderColor());m=(m.r*255)|((m.g*255)<<8)|((m.b*255)<<16)|0xFF000000;l.fill(m&0xFFFFFF);for(var i=1;i<=b;i++){l[i]=m;}var u=new THREE.DataTexture(new Uint8Array(h),f,1,THREE.RGBAFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.LinearFilter,THREE.LinearFilter);u.needsUpdate=true;this._border.material.map=u;this._border.material.needsUpdate=true;this._line.material=this._border.material;};function F(a){var m=a.elements;var i=m[15]===1;var b=2/m[0];var f=2/m[5];var h,l;if(i){h=-m[12]*b;l=-m[13]*f;}else{h=m[8]*b;l=m[9]*f;}var u=(b+h)*0.5;var w=h-u;var x=(f+l)*0.5;var y=l-x;return{left:w,top:x,right:u,bottom:y};}function G(a,b){var m=a.elements;var i=m[15]===1;m[0]=2/(b.right-b.left);m[5]=2/(b.top-b.bottom);if(i){m[12]=-(b.right+b.left)/(b.right-b.left);m[13]=-(b.top+b.bottom)/(b.top-b.bottom);}else{m[8]=(b.right+b.left)/(b.right-b.left);m[9]=(b.top+b.bottom)/(b.top-b.bottom);}}function H(a,b,s,f){var w=s.x/f.width;var h=s.y/f.height;p.copy(b).applyMatrix4(a.matrixWorldInverse).applyMatrix4(a.projectionMatrix);var x=((p.x/p.w)-w)*0.5+0.5;var y=((p.y/p.w)-h)*0.5+0.5;var i=F(a.projectionMatrix);var l={};l.left=THREE.Math.lerp(i.left,i.right,x);l.right=THREE.Math.lerp(i.left,i.right,x+w);l.top=THREE.Math.lerp(i.top,i.bottom,1-y-h);l.bottom=THREE.Math.lerp(i.top,i.bottom,1-y);G(a.projectionMatrix,l);}function I(a,b){for(var i=0,l=a.length;i<l;i++){a[i].visible=b;}}e.prototype._render=function(a,b,f,h,i){var l=a.getSize(),m=a.getPixelRatio(),u=this.getOrigin(),w=this._node,x=w.position;if(!this._border.material.map){this._updateBorderTexture(m);}s.copy(this.getSize()).multiplyScalar(l.height*0.5);s.set(Math.round(s.x)<<1,Math.round(s.y)<<1);x.set(u.x*l.height/l.width,u.y,0).unproject(b);p.copy(x).applyMatrix4(b.matrixWorldInverse).applyMatrix4(b.projectionMatrix);var y=((p.x/p.w)*0.5+0.5)*l.width,J=((p.y/p.w)*0.5+0.5)*l.height;var K=p.w/(l.width*b.projectionMatrix.elements[0]);w.scale.setScalar(K);k.setFromMatrixColumn(b.matrixWorld,0).multiplyScalar(K*2*(Math.round(y)-y));n.setFromMatrixColumn(b.matrixWorld,1).multiplyScalar(K*2*(Math.round(J)-J));x.add(k).add(n);w.quaternion.copy(b.quaternion);w.updateMatrixWorld();this._updateGeometry(s,l,b);r.copy(s).multiplyScalar(m);if(!this._renderTarget||this._renderTarget.width!==r.x||this._renderTarget.height!==r.y){this._renderTarget=new THREE.WebGLRenderTarget(r.x,r.y,{minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBFormat});this._billboard.material.map=this._renderTarget.texture;this._billboard.material.needsUpdate=true;}var L;if(this.getType()===D.Cutaway){L=b;v.copy(L.projectionMatrix);H(L,x,s,l);}else{L=this.getCamera();L.adjustClipPlanes(h);L.update(s.x,s.y);L=L.getCameraRef();}f.children.forEach(function(M){if(M.userData._vkDynamicObjects){M.userData._vkDynamicObjects.forEach(function(N){if(N.visible){if(N.isBillboard){I(N.children,false);}else{N._vkUpdate(a,L,s);}}});}});if(i){i.position.copy(L.position);}a.setClearColor(this._backgroundColor,1);a.render(f,L,this._renderTarget,true);if(L===b){b.projectionMatrix.copy(v);}a.render(this._node,b);f.children.forEach(function(M){if(M.userData._vkDynamicObjects){M.userData._vkDynamicObjects.forEach(function(N){if(N.visible&&N.isBillboard){I(N.children,true);}});}});};return e;});
