/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["sap/ui/core/Element","../TransformationMatrix"],function(E,T){"use strict";var N=E.extend("sap.ui.vk.threejs.NodesTransitionHelper",{metadata:{properties:{},publicMethods:["setViewport","setNodeForDisplay","setDisappearingNode","setAppearingNode","clear","startDisplay","displayNodesMoving"],events:{displaying:{},displayed:{}}}});N.prototype.init=function(){this._viewport=null;this._nodeLocalmMatrixMap=new Map();this._nodeLocalMatrixMapForVisibility=new Map();this._timeIntervalForDisplay=500;this._startTimeForDisplay=0;};N.prototype.destroy=function(){this._viewport=null;this._nodeLocalmMatrixMap=null;this._nodeLocalMatrixMapForVisibility=new Map();};N.prototype.setViewport=function(v){this._viewport=v;};N.prototype.setNodeForDisplay=function(n){this._nodeLocalmMatrixMap.set(n,{oldMatrix:n.getLocalMatrix(),newMatrix:null});};N.prototype.setDisappearingNode=function(n){var o=n.getLocalMatrix();var a=[o[0]*0.0001,o[1],o[2],o[3],o[4]*0.0001,o[5],o[6],o[7],o[8]*0.0001,o[9],o[10],o[11]];this._nodeLocalMatrixMapForVisibility.set(n,{oldMatrix:o,newMatrix:a,visible:false});var b=n.getNodeRef();b.visible=true;};N.prototype.setAppearingNode=function(n){var o=n.getLocalMatrix();var a=[o[0]*0.0001,o[1],o[2],o[3],o[4]*0.0001,o[5],o[6],o[7],o[8]*0.0001,o[9],o[10],o[11]];this._nodeLocalMatrixMapForVisibility.set(n,{oldMatrix:a,newMatrix:o,visible:true});};N.prototype._interpolateNodePositionForVisibility=function(n,d,i){this._interpolateNodePosition(n,d.oldMatrix,d.newMatrix,i);if(i>=1){var a=n.getNodeRef();a.visible=d.visible;if(!a.visible){n.setLocalMatrixNotUpdatingBBox(d.oldMatrix);}}};N.prototype._interpolateNodePosition=function(n,o,a,i){var b=new THREE.Matrix4().fromArray(T.convertTo4x4(o));var c=new THREE.Vector3();var d=new THREE.Quaternion();var e=new THREE.Vector3();b.decompose(c,d,e);var f=new THREE.Matrix4().fromArray(T.convertTo4x4(a));var g=new THREE.Vector3();var h=new THREE.Quaternion();var j=new THREE.Vector3();f.decompose(g,h,j);var p=new THREE.Vector3().lerpVectors(c,g,i);var q=new THREE.Quaternion().copy(d).slerp(h,i);var s=new THREE.Vector3().lerpVectors(e,j,i);var t=new THREE.Matrix4().compose(p,q,s);n.setLocalMatrixNotUpdatingBBox(T.convertTo4x3(t.elements));};N.prototype.startDisplay=function(t){if(this._nodeLocalmMatrixMap.size===0){return;}this._timeIntervalForDisplay=t!==undefined?t:500;this._startTimeForDisplay=Date.now();this._nodeLocalmMatrixMap.forEach(function(m,n){m.newMatrix=n.getLocalMatrix();});this.fireDisplaying();};N.prototype.displayNodesMoving=function(){if(this._startTimeForDisplay===0||this._nodeLocalmMatrixMap===null||this._nodeLocalmMatrixMap.size===0){return;}var i=Math.min((Date.now()-this._startTimeForDisplay)/this._timeIntervalForDisplay,1);i=1-Math.pow(1-i,3);this._nodeLocalmMatrixMap.forEach(function(m,n){if(n&&m.oldMatrix&&m.newMatrix){this._interpolateNodePosition(n,m.oldMatrix,m.newMatrix,i);}}.bind(this));this._nodeLocalMatrixMapForVisibility.forEach(function(d,n){if(n&&d){this._interpolateNodePositionForVisibility(n,d,i);}}.bind(this));if(i===1){this.clear();this.fireDisplayed();}this._viewport.setShouldRenderFrame();};N.prototype.clear=function(){this._nodeLocalmMatrixMap.clear();this._nodeLocalMatrixMapForVisibility.clear();this._startTimeForDisplay=0;};return N;});
