/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","../Scene","./NodeHierarchy","../RenderMode","./ThreeExtensions","./AnimationSequence"],function(q,S,N,R,T,A){"use strict";var c=S.extend("sap.ui.vk.threejs.Scene",{metadata:{},constructor:function(a){S.call(this);this._id=q.sap.uid();this._scene=a;this._sceneBuilder=null;this._defaultNodeHierarchy=null;this._currentViewStateManager=null;this._animationSequenceMap=new Map();this._initialView=null;this._materialMap=new Map();}});c.prototype.init=function(){var a=["attribute vec3 normal1;","attribute vec3 normal2;","#include <clipping_planes_pars_vertex>","uniform vec4 color;","varying vec4 vColor;","void main() {","	#include <begin_vertex>","	#include <project_vertex>","	#include <clipping_planes_vertex>","	vec3 eyeDirection = mvPosition.xyz;","	vec3 n1 = normalMatrix * normal1;","	vec3 n2 = normalMatrix * normal2;","	vColor = color;","	vColor.a *= step(dot(eyeDirection, n1) * dot(eyeDirection, n2), 0.0);","}"].join("\n");var b=["#include <clipping_planes_pars_fragment>","varying vec4 vColor;","void main() {","	#include <clipping_planes_fragment>","	if (vColor.a < ALPHATEST) discard;","	gl_FragColor = vColor;","}"].join("\n");this._outlineColor=new THREE.Vector4(0,0,0,1);this._outlineMaterial=new THREE.ShaderMaterial({uniforms:{color:{value:this._outlineColor}},vertexShader:a,fragmentShader:b,depthWrite:false,depthFunc:THREE.LessEqualDepth,polygonOffset:true,polygonOffsetFactor:-4,blending:THREE.NormalBlending,alphaTest:0.01,clipping:true});this._solidWhiteMaterial=new THREE.MeshBasicMaterial({color:0xFFFFFF});};c.prototype.destroy=function(){if(this._defaultNodeHierarchy){this._defaultNodeHierarchy.destroy();this._defaultNodeHierarchy=null;}this._sceneBuilder=null;this._scene=null;this._animationSequenceMap.clear();S.prototype.destroy.call(this);};c.prototype.setDoubleSided=function(v){this.setProperty("doubleSided",v,true);this._scene.traverse(function(a){if(a.material!==undefined){var u=a.userData;var b=THREE.FrontSide;var e;if(u.originalMaterial){if(u.originalMaterial.userData===undefined){u.originalMaterial.userData={};}e=u.originalMaterial.userData;if(e.originalMaterialSide===undefined){e.originalMaterialSide=u.originalMaterial.side;}b=e.originalMaterialSide;}else{if(a.material.userData===undefined){a.material.userData={};}e=a.material.userData;if(e.originalMaterialSide===undefined){e.originalMaterialSide=a.material.side;}b=e.originalMaterialSide;}a.material.side=v?THREE.DoubleSide:b;}});return this;};c.prototype.setViewStateManager=function(v){this._currentViewStateManager=v;return this;};c.prototype.getViewStateManager=function(){return this._currentViewStateManager;};c.prototype.getId=function(){return this._id;};c.prototype.getDefaultNodeHierarchy=function(){if(!this._defaultNodeHierarchy){this._defaultNodeHierarchy=new N(this);}return this._defaultNodeHierarchy;};c.prototype._computeBoundingBox=function(v,i){var b=new THREE.Box3();if(this._scene){this._scene._expandBoundingBox(b,v,i);}return b;};c.prototype.getSceneRef=function(){return this._scene;};c.prototype._setSceneBuilder=function(a){this._sceneBuilder=a;};c.prototype.nodeRefToPersistentId=function(a){return Array.isArray(a)?a.map(function(b){return b._vkPersistentId();}):a._vkPersistentId();};c.prototype.persistentIdToNodeRef=function(a){var b=this._sceneBuilder;if(Array.isArray(a)){return a.map(function(e){return b?b.getNode(e):null;});}else{return b?b.getNode(a):null;}};c.prototype.setNodePersistentId=function(a,b,e){return this._sceneBuilder?this._sceneBuilder.setNodePersistentId(a,b,e):false;};c.prototype.enumerateMaterials=function(){if(!this._defaultNodeHierarchy){return[];}var t=this._defaultNodeHierarchy.createNodeProxy(this._scene);if(t){return t.enumerateMaterials(true);}else{return[];}};var d=0;function f(a,b){var e=a.x-b.x;if(e<-d){return true;}if(e>d){return false;}var i=a.y-b.y;if(i<-d){return true;}if(i>d){return false;}return a.z-b.z<-d;}function g(a,b,e){if(b<e){var i=p(a,b,e);g(a,b,i-1);g(a,i+1,e);}return a;}function p(a,b,e){var j=a[e],l=b;for(var i=b;i<e;i++){if(f(a[i],j)){s(a,i,l);l++;}}s(a,e,l);return l;}function s(a,i,j){if(i!=j){var t=a[i];a[i]=a[j];a[j]=t;}}var h=new THREE.Vector3();function m(a){a.computeBoundingBox();a.boundingBox.getSize(h);d=Math.max(h.x,h.y,h.z)*1e-4;var v=a.vertices,b=v.length,e=a.faces.length;if(b===0||e===0){return;}var i,j;for(i=0;i<b;i++){v[i].index=i;}g(v,0,v.length-1);var u=[],l=[];u.push(v[0]);l[v[0].index]=u.length-1;for(i=1;i<b;i++){if(f(u[u.length-1],v[i])){u.push(v[i]);}l[v[i].index]=u.length-1;}a.vertices=u;for(i=0,e=a.faces.length,j=0;i<e;i++){var t=a.faces[i];var w=a.faces[j];w.a=l[t.a];w.b=l[t.b];w.c=l[t.c];if(w.a!==w.b&&w.b!==w.c&&w.c!==w.a){j++;}}a.faces.length=j;}function O(a,t){THREE.BufferGeometry.call(this);this.type="OutlineGeometry";var b=Math.cos(THREE.Math.DEG2RAD*((t!==undefined)?t:1));var u={},w,x;var y,z=["a","b","c"];var v=new THREE.Vector3();var B;if(a.isBufferGeometry){B=new THREE.Geometry();B.fromBufferGeometry(a);}else{B=a.clone();}m(B);B.computeFaceNormals();var C=B.vertices;var D=B.faces;for(var E=0,l=D.length;E<l;E++){var F=D[E];for(var i=0,j=2;i<3;j=i++){w=F[z[j]];x=F[z[i]];y=Math.min(w,x)+","+Math.max(w,x);if(u[y]===undefined){u[y]={index1:w,index2:x,face1:E,face2:undefined};}else{u[y].face2=E;}}}var G=[];var H=[];var I=[];for(y in u){var e=u[y];if(e.face2===undefined||(D[e.face1].normal.dot(D[e.face2].normal)<=b&&v.copy(C[e.index2]).sub(C[e.index1]).cross(D[e.face1].normal).dot(D[e.face2].normal)>0)){var J=C[e.index1];G.push(J.x,J.y,J.z);J=C[e.index2];G.push(J.x,J.y,J.z);var K=D[e.face1].normal;H.push(K.x,K.y,K.z);H.push(K.x,K.y,K.z);if(e.face2!==undefined){var L=D[e.face2].normal;I.push(L.x,L.y,L.z);I.push(L.x,L.y,L.z);}else{I.push(0,0,0);I.push(0,0,0);}}}this.addAttribute("position",new THREE.Float32BufferAttribute(G,3));this.addAttribute("normal1",new THREE.Float32BufferAttribute(H,3));this.addAttribute("normal2",new THREE.Float32BufferAttribute(I,3));}O.prototype=Object.create(THREE.BufferGeometry.prototype);O.prototype.constructor=O;function k(b){return(b===null)||(b.min.x>=b.max.x&&b.min.y>=b.max.y&&b.min.z>=b.max.z);}function n(a){var b=null;if(a.isMesh&&a.geometry&&!k(a.geometry.boundingBox)&&(a.name||a.children.length>0)){b=a.geometry;if(b.isBufferGeometry){b=new THREE.Geometry().fromBufferGeometry(b);}}for(var i=0,l=a.children.length;i<l;i++){var e=a.children[i];if(e.isMesh&&e.geometry&&!k(e.geometry.boundingBox)&&!e.name&&e.children.length===0){if(b===null){b=new THREE.Geometry();}var j=e.geometry;if(j.isBufferGeometry){j=new THREE.Geometry().fromBufferGeometry(j);}b.merge(j,e.matrix);}}return b;}function o(a,b){var u=a.userData;if(u.defaultMaterial===undefined){u.defaultMaterial=u.originalMaterial||a.material;}a.material=b;u.originalMaterial=null;a._vkUpdateMaterialColor();a._vkUpdateMaterialOpacity();}function r(a){var u=a.userData;if(u.defaultMaterial){a.material=u.defaultMaterial;delete u.defaultMaterial;u.originalMaterial=null;a._vkUpdateMaterialColor();a._vkUpdateMaterialOpacity();}}c.prototype._createOutlineGeometry=function(a){if(this._scene){this._scene._vkTraverseMeshNodes(function(b){if(b.isOutline){b.visible=true;}else{if(!b.hasOutline){var e;try{e=n(b);}catch(i){e=null;}if(e!==null){b.hasOutline=true;var j=new O(e);j.boundingBox=new THREE.Box3();var l=new THREE.LineSegments(j,this._outlineMaterial);l.isOutline=true;l.renderOrder=b.renderOrder+0.5;b.add(l);}}if(b.isMesh&&b.material&&!b.material.isLineBasicMaterial&&!b.material.isLineMaterial){switch(a){case R.LineIllustration:o(b,this._solidWhiteMaterial);break;case R.ShadedIllustration:var t=(b.userData.defaultMaterial||b.userData.originalMaterial||b.material).clone();if(t.emissive){t.color.multiplyScalar(0.5);t.emissive.multiplyScalar(0.5).addScalar(0.5);}else{t.color.multiplyScalar(0.5).addScalar(0.5);}o(b,t);break;default:r(b);break;}}}}.bind(this));}};c.prototype._hideOutlineGeometry=function(){if(this._scene){this._scene._vkTraverseMeshNodes(function(a){if(a.isOutline){a.visible=false;}if(a.isMesh){r(a);}});}};c.prototype.createAnimationSequence=function(i,a,b){var e=new A(i,a,b);this._animationSequenceMap.set(i,e);return e;};c.prototype.getAnimationSequence=function(i){var a=this._animationSequenceMap.get(i);return a;};c.prototype.getInitialView=function(){return this._initialView;};c.prototype.setInitialView=function(v){this._initialView=v;};c.prototype.getMaterial=function(a){return this._materialMap.get(a);};c.prototype.setMaterial=function(a,b){this._materialMap.set(a,b);};c.prototype.clearMaterials=function(){this._materialMap.clear();};return c;});
