/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","./thirdparty/three","sap/base/Log","./BBoxSubdivider","./UsageCounter","../totara/TotaraUtils","./OrthographicCamera","./PerspectiveCamera","./DetailView","./AnimationHelper","./Thrustline","../View","./Billboard","./Callout","../BillboardCoordinateSpace","../BillboardTextEncoding","../BillboardStyle","../BillboardBorderLineStyle","../BillboardHorizontalAlignment","../LeaderLineMarkStyle","../DetailViewType","../DetailViewShape","./AnimationSequence","../AnimationPlayback","../RenderMode","./Material","../ObjectType","../thirdparty/ie-polyfills"],function(q,t,L,B,U,T,O,P,D,A,a,V,c,C,d,f,g,h,j,k,m,n,o,p,R,M,r,s){"use strict";var S=function(b,e,i,l){this._id=S._nextId++;S._add(this);this._callouts=new Map();this._cameras=new Map();this._images=new Map();this._imageIdsAndTileWidths=new Map();this._geometries=new Map();this._meshNodes=new Map();this._meshSubmeshes=new Map();this._geometryMeshes=new Map();this._materialMeshes=new Map();this._materialClones=new Map();if(b){this._rootNode=b;this._nodes=new Map();this._tracks=new Map();this._trackIdSequenceNodeMap=new Map();this._viewGroups=new Map();this._views=new Map();}else{this._rootNode=null;this._nodes=null;this._tracks=null;this._trackIdSequenceNodeMap=null;this._viewGroups=null;this._views=null;}this._currentSceneId=null;this._sceneIdTreeNodesMap=new Map();this._sceneIdRootNodeMap=new Map();this._sceneIdViewGroupMap=new Map();this._sceneIdViewMap=new Map();this._highlightStyles=new Map();this._animationHelper=new A(this);if(e){this._countentResource=e;var g1=e.getNodeProxy();var h1=g1.getNodeHierarchy();this._vkScene=h1.getScene();var i1=e.getSource();if(i1&&i1.name){this._sceneIdTreeNodesMap.set(i1.name,this._nodes);this._sceneIdRootNodeMap.set(i1.name,b);this._sceneIdViewGroupMap.set(i1.name,this._viewGroups);this._sceneIdViewMap.set(i1.name,this._views);this._currentSceneId=i1.name;}if(this._rootNode){if(!this._rootNode.userData){this._rootNode.userData={};}this._rootNode.userData.skipIt=!e.name;}}this._viewThumbnails=new Map();this._thrustlines=new Map();this._animations=new Map();this._animationTracks=new Map();this._resolve=i;this._reject=l;};S._nextId=1;S._map=new Map();S.prototype.getId=function(){return this._id;};S.getById=function(i){return this._map.get(i);};S._add=function(b){S._map.set(b.getId(),b);return this;};var u=[R.Default,R.Default,R.Default,R.LineIllustration,R.SolidOutline,R.ShadedIllustration];S.prototype.setScene=function(i){if(i.result!==1){this._reject(i.result);}else{var b=this._cameras.get(i.cameraId);this._resolve({node:this._parentNode,camera:b,backgroundTopColor:i.backgroundTopColor,backgroundBottomColor:i.backgroundBottomColor,contentResource:this._contentResource,builder:this});}};S.prototype.setRootNode=function(b,e,i,l){this._rootNode=b;this._nodes=new Map();this._nodes.set(e,b);if(!this._rootNode.userData){this._rootNode.userData={};}this._tracks=new Map();this._trackIdSequenceNodeMap=new Map();this._viewGroups=new Map();this._views=new Map();if(i){this._sceneIdTreeNodesMap.set(i,this._nodes);this._sceneIdRootNodeMap.set(i,b);this._sceneIdViewGroupMap.set(i,this._viewGroups);this._sceneIdViewMap.set(i,this._views);this._currentSceneId=i;}if(l){this._vkScene=l;}return this;};S.prototype._resetCurrentScene=function(b){if(b&&b!==this._currentSceneId){var e=this._sceneIdTreeNodesMap.get(b);if(e){this._nodes=e;}else{this._nodes=null;}var i=this._sceneIdRootNodeMap.get(b);if(i){this._rootNode=i;}else{this._rootNode=null;}this._currentSceneId=b;}};S.prototype.getNode=function(b,e){if(e){this._resetCurrentScene(e);if(this._nodes){return this._nodes.get(b);}}else{var i=this._sceneIdTreeNodesMap.values();var l=i.next();while(!l.done){var g1=l.value.get(b);if(g1){return g1;}l=i.next();}}return null;};S.prototype.hasMesh=function(b){return this._meshSubmeshes.has(b);};S.prototype.hasImage=function(i){return this._images.has(i);};S.prototype.setNodePersistentId=function(b,e,i){if((b.userData.treeNode&&b.userData.treeNode.sid)||this.getNode(e,i)){return false;}this._resetCurrentScene(i);if(!b.userData.treeNode){b.userData.treeNode={};}b.userData.treeNode.sid=e;if(this._nodes){this._nodes.set(e,b);}return true;};var v=function(b){var e=new THREE.Matrix4();if(b.length===3){e.setPosition(new THREE.Vector3().fromArray(b));}else if(b.length===12){e.set(b[0],b[3],b[6],b[9],b[1],b[4],b[7],b[10],b[2],b[5],b[8],b[11],0.0,0.0,0.0,1.0);}else if(b.length===16){e.set(b[0],b[4],b[8],b[12],b[1],b[5],b[9],b[13],b[2],b[6],b[10],b[14],b[3],b[7],b[11],b[15]);}else{throw"Invalid matrix format";}return e;};var w={r:0.0235,g:0.0235,b:0.0235};var x={r:0.0602,g:0.0602,b:0.0602};S.prototype._createTemporaryMaterial=function(b){var e=new THREE.MeshPhongMaterial({color:0xaaaaaa});e.userData.defaultHighlightingEmissive=w;e.userData.defaultHighlightingSpecular=x;e.userData.materialUsed=0;e.userData.materialId=b;e.userData.toBeUpdated=true;var i=new M();i.setMaterialRef(e);this._vkScene.setMaterial(b,i);return e;};S.prototype._getMaterialRef=function(b){var e=this._vkScene.getMaterial(b);return e?e.getMaterialRef():null;};S.prototype.checkMaterialExists=function(b,e){if(this._getMaterialRef(b)===null){if(e){this._createTemporaryMaterial(b);}return false;}return true;};S.prototype._attachMaterialClone=function(b,e){T.pushElementIntoMapArray(this._materialClones,b,e);};S.prototype._addDynamicObject=function(b,e){var i=this._rootNode.userData;if(!i._vkDynamicObjects){i._vkDynamicObjects=[];}if(i._vkDynamicObjects.indexOf(b)<0){i._vkDynamicObjects.push(b);}b._vkUpdate=e;};S.prototype.createNode=function(b,e){this._resetCurrentScene(e);var i=new THREE.Group();var l=i.userData;l.treeNode=b;l.closed=b.closed;l.selectable=b.selectable;l.metadata=b.metadata;if(b.name){i.name=b.name;}if(b.visible!==undefined){i.visible=b.visible;}if(b.renderOrder){i.renderOrder=b.renderOrder;}if(b.visualisable===false){l.skipIt=true;}if(b.opacity!==undefined){l.opacity=b.opacity;}if(b.transform){i.applyMatrix(v(b.transform));if(!isFinite(i.quaternion.x)||!isFinite(i.quaternion.y)||!isFinite(i.quaternion.z)||!isFinite(i.quaternion.w)){i.quaternion.set(0,0,0,1);}}if(b.transformType){l.transformType=b.transformType;switch(b.transformType){case"ORTHO2D":l.originalTransform={p:i.position.clone(),q:i.quaternion.clone(),s:i.scale.clone()};this._addDynamicObject(i,c.prototype._ortho2DUpdate);break;case"BILLBOARD_VIEW":this._addDynamicObject(i,c.prototype._billboardViewUpdate);break;case"LOCK_TOVIEWPORT":this._addDynamicObject(i,c.prototype._lockToViewportUpdate);break;default:break;}}this._nodes.set(b.sid,i);if(b.meshId){this.setMeshNode(b.sid,b.meshId);}var g1=this._nodes.get(b.parentId);(g1||this._rootNode).add(i);if(i.visible){while(g1){g1.visible=i.visible;g1=g1.parent;}}if(i.parent.userData.objectType===r.Hotspot){l.objectType=r.Hotspot;}else if(i.parent.userData.objectType===r.PMI){l.objectType=r.PMI;}else if(b.contentType==="HOTSPOT"){l.objectType=r.Hotspot;}else if(b.contentType==="PMI"){l.objectType=r.PMI;}return i;};function y(b,e,l){var i;if(b.isPolyline){var g1=new THREE.LineBasicMaterial({color:0xff0000,linewidth:1});if(e){g1.color.copy(e.color);}i=new THREE.LineSegments(b,g1);}else{i=new THREE.Mesh(b,e);}if(b.isPositionQuantized){F(i,l.boundingBox);}U.increaseGeometryUsed(b);return i;}S.prototype.getChildNodeIds=function(b,e,l){this._resetCurrentScene(e);var g1=this._nodes.get(b);var h1=[];if(!g1){return h1;}if(g1&&g1.children){for(var i=0;i<g1.children.length;i++){var i1=g1.children[i];if(i1.userData.treeNode&&i1.userData.treeNode.sid){h1.push(i1.userData.treeNode.sid);}else if(l&&i1.userData.submeshInfo&&i1.userData.submeshInfo.id){h1.push(i1.userData.submeshInfo.id);}}}return h1;};function z(l){for(var i=0;i<l.length;i++){if(l[i].type==="box"&&l[i].data){return l[i];}}return null;}function E(l){if(Array.isArray(l)){for(var i=0;i<l.length;i++){if(l[i].type===undefined||l[i].type==="mesh"||l[i].type==="line"){return l[i];}}}return null;}function F(b,e){if(Array.isArray(e)&&e.length===6){b.position.set((e[3]+e[0])*0.5,(e[4]+e[1])*0.5,(e[5]+e[2])*0.5);b.scale.set(Math.max(e[3]-e[0],Number.EPSILON),Math.max(e[4]-e[1],Number.EPSILON),Math.max(e[5]-e[2],Number.EPSILON));}else{b.position.setScalar(0);b.scale.setScalar(1);}}var G=new Float32Array([0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0,-1.0,0.0,0.0]);var H=new Uint16Array([0,1,2,2,1,3,4,6,5,5,6,7,8+0,8+1,8+2,8+2,8+1,8+3,8+4,8+6,8+5,8+5,8+6,8+7,16+0,16+1,16+2,16+2,16+1,16+3,16+4,16+6,16+5,16+5,16+6,16+7]);S.prototype.insertSubmesh=function(i){var l=this._getMaterialRef(i.materialId)||this._createTemporaryMaterial(i.materialId);var g1,h1;if(i.lods){var i1=E(i.lods);if(!i1){return false;}h1=this._geometries.get(i1.id);if(h1){g1=y(h1,l,i1);if(h1.userData&&h1.userData.noNormal&&i.materialId){this.updateMaterialForGeometryWithoutNormal(i.materialId);}}else{var j1;try{var k1=z(i.lods);if(k1&&k1.data){var l1=T.base64ToUint8Array(k1.data);var m1=B.unpackSubDividedBoundingBox(l1);j1=B.makeSubDividedBoundingBoxGeometry(m1);}}catch(e){}g1=new THREE.Mesh(j1?j1:new THREE.BoxBufferGeometry(1,1,1),l);F(g1,i1.boundingBox);g1.userData.geometryId=i1.id;g1.userData.lodInfo=i1;T.pushElementIntoMapArray(this._geometryMeshes,i1.id,i.meshId);}}else if(i.boundingBox){var b=i.boundingBox;var n1=new Float32Array([b[0],b[1],b[5],b[3],b[1],b[5],b[0],b[4],b[5],b[3],b[4],b[5],b[0],b[1],b[2],b[3],b[1],b[2],b[0],b[4],b[2],b[3],b[4],b[2],b[0],b[4],b[5],b[3],b[4],b[5],b[0],b[4],b[2],b[3],b[4],b[2],b[0],b[1],b[5],b[3],b[1],b[5],b[0],b[1],b[2],b[3],b[1],b[2],b[3],b[1],b[5],b[3],b[1],b[2],b[3],b[4],b[5],b[3],b[4],b[2],b[0],b[1],b[5],b[0],b[1],b[2],b[0],b[4],b[5],b[0],b[4],b[2]]);h1=new THREE.BufferGeometry();h1.setIndex(new THREE.BufferAttribute(H,1));h1.addAttribute("position",new THREE.BufferAttribute(n1,3));h1.addAttribute("normal",new THREE.BufferAttribute(G,3));g1=new THREE.Mesh(h1,l);}else{return false;}if(i.transform){g1.applyMatrix(v(i.transform));}g1.userData.submeshId=i.id;g1.userData.initialMaterialId=i.materialId;g1.userData.meshId=i.meshId;g1.userData.materialId=i.materialId;g1.userData.submeshInfo=i;T.pushElementIntoMapArray(this._materialMeshes,i.materialId,i.meshId);T.pushElementIntoMapArray(this._meshSubmeshes,i.meshId,g1);var o1=this._meshNodes.get(i.meshId);if(o1){o1.forEach(function(p1){p1.add(g1.clone());K(p1,i.materialId,this._materialClones);}.bind(this));}return true;};function I(b,e,l,g1){for(var i=0;i<b.length;i++){var h1=b[i];if(e&&h1.userData.geometryId===e&&h1.geometry!==l){if(h1.type==="Mesh"&&!l.isPolyline){h1.geometry=l;var i1=h1.parent&&h1.parent.userData.transformType==="ORTHO2D";F(h1,l.isPositionQuantized&&!i1?h1.userData.lodInfo.boundingBox:null);U.increaseGeometryUsed(l);}else{var j1=y(l,h1.material,h1.userData.lodInfo);j1.userData=h1.userData;j1.parent=h1.parent;b[i]=j1;h1.parent=null;}}}}function J(b,e,i,l){var g1=b.userData.opacity!==undefined?b.userData.opacity:1;var h1=b.children;h1.forEach(function(i1){if(i1.userData.materialId===e){U.increaseMaterialUsed(i);i1.material=i;i1.userData.opacity=g1;i1._vkUpdateMaterialOpacity();if(i1.material!==i){T.pushElementIntoMapArray(l,e,i1.material);}}});}function K(b,e,i){var l=b.userData.opacity!==undefined?b.userData.opacity:1;b.children.forEach(function(g1){if(g1.material&&(!e||e===g1.material.userData.materialId)){var h1=g1.material;g1.userData.opacity=l;g1._vkUpdateMaterialOpacity();if(g1.material!==h1){T.pushElementIntoMapArray(i,g1.material.userData.materialId,g1.material);}}});}S.prototype.setGeometry=function(b){var e=new THREE.BufferGeometry();var g1=new THREE.BufferAttribute(new Uint16Array(b.data.indices),1);var h1=new THREE.BufferAttribute(new Float32Array(b.data.points),3);e.setIndex(g1);e.addAttribute("position",h1);if(!e.userData){e.userData={};}if(!b.isPolyline){if(b.data.normals.length===b.data.points.length){var i1=new THREE.BufferAttribute(new Float32Array(b.data.normals),3);e.addAttribute("normal",i1);}else{e.userData.noNormal=true;}if(b.data.uvs&&b.data.uvs.length*3===b.data.points.length*2){e.addAttribute("uv",new THREE.BufferAttribute(new Float32Array(b.data.uvs),2));}}else{e.isPolyline=true;}if(!b.id&&b.meshId){var j1=this._meshSubmeshes.get(b.meshId);if(j1){for(var mc=0;mc<j1.length;mc++){var l1=j1[mc];if(l1.userData.geometryId){continue;}if(!b.isPolyline){l1.geometry.copy(e);}else{for(var i=0,l=l1.parent.children.length;i<l;i++){if(l1.parent.children[i]===l1){var m1=new THREE.LineSegments(e,new THREE.LineBasicMaterial({color:l1.material.color}));l1.parent.children[i]=m1;m1.parent=l1.parent;l1.parent=null;j1[0]=m1;break;}}}}}if(this._fireSceneUpdated){this._fireSceneUpdated();}return this;}try{e.computeBoundingSphere();}catch(n1){return this;}e.isPositionQuantized=b.isPositionQuantized;e.userData.geometryId=b.id;e.userData.geometryUsed=0;this._geometries.set(b.id,e);var o1=this._geometryMeshes.get(b.id);if(o1){for(var mi=0;mi<o1.length;mi++){var q1=o1[mi];var r1=this._meshNodes.get(q1);if(r1){for(var ni=0;ni<r1.length;ni++){I(r1[ni].children,b.id,e);}}var t1=this._meshSubmeshes.get(q1);if(t1){I(t1,b.id,e);}}}return this;};S.prototype.setMeshNode=function(b,e){var i=this._nodes.get(b);if(i){T.pushElementIntoMapArray(this._meshNodes,e,i);var l=this._meshSubmeshes.get(e);if(l){l.forEach(function(g1){i.add(g1.clone());});if(i.userData.opacity!==undefined&&i.userData.opacity<0.99){K(i,null,this._materialClones);}}}};S.prototype.progress=function(b){L.log("reading progress:",b);};S.prototype.loadingFinished=function(i){if(this._fireLoadingFinished){this._fireLoadingFinished(i);}};S.prototype.getGeometry=function(b){return this._geometries.get(b);};var N={rect:g.RectangularShape,circle:g.CircularShape,none:g.None,textGlow:g.TextGlow};var Q={none:h.None,solid:h.Solid,dash:h.Dash,dot:h.Dot,dashdot:h.DashDot,dashdotdot:h.DashDotDot};var W={left:j.Left,center:j.Center,right:j.Right};var X={none:k.None,point:k.Point,arrow:k.Arrow};var _=new THREE.Color();S.prototype.createAnnotation=function(b,e){this._resetCurrentScene(e);var i=this._nodes.get(b.nodeId);if(!i){L.warning("Annotation node not found",b);return;}var l=i.userData.originalTransform;if(l){i.position.copy(l.p);i.scale.copy(l.s);}var g1=b.type;if(g1===undefined){this.createLegacyAnnotation(b,i);return;}if(g1==="html"){return;}var h1=b.label||{};var i1=b.text||{};var j1=h1.colour||[1,1,1,1];var k1=h1.borderColour||[0,0,0,1];var l1={node:i,renderOrder:i.renderOrder||0,style:N[h1.shape]||g.RectangularShape,width:h1.width||64,height:h1.height||64,backgroundColor:_.fromArray(j1).getStyle(),backgroundOpacity:j1[3],borderColor:_.fromArray(k1).getStyle(),borderOpacity:k1[3],borderWidth:h1.borderColour?(h1.borderWidth||0):0,borderLineStyle:Q[h1.borderLineStyle]||h.Solid,horizontalAlignment:W[i1.align]};if(i1.html){l1.encoding=f.HtmlText;l1.text=i1.html;}else{l1.encoding=f.PlainText;l1.text=i1.text;l1.font=i1.fontFace||"Arial";l1.fontSize=Math.abs(i1.fontSize)||16;l1.fontWeight=Math.min(i1.fontWeight,900);l1.fontItalic=i1.fontItalic;l1.textColor=_.fromArray(i1.colour||[0,0,0]).getStyle();}if(g1==="text"){var m1=i.position;l1.position=new THREE.Vector3(m1.x*2,m1.y*2,m1.z);var n1=new c(l1);n1.setText(l1.text);this._addDynamicObject(i,n1._update.bind(n1));}else if(g1==="note"){var o1=b.attachment||{};l1.position=new THREE.Vector3().fromArray(o1.position||[0,0,0]);l1.anchorNode=this._nodes.get(o1.sid)||this._rootNode;l1.depthTest=false;var p1=new C(l1);p1.setText(l1.text);this._callouts.set(b.id,p1);this._addDynamicObject(i,p1._update.bind(p1));}else{L.warning("Unsupported annotation type",b);}};var Y=[g.RectangularShape,g.CircularShape,g.None,g.TextGlow];var Z=[d.Viewport,d.Screen,d.World];var $=[h.None,h.Solid,h.Dash,h.Dot,h.DashDot,h.DashDotDot];var a1=[k.None,k.Point,k.Arrow];var b1=[j.Left,j.Center,j.Right];function c1(b){var e=b.toString(16);if(b.length>=3){e=(((b[0]*255)<<16)|((b[1]*255)<<8)|(b[2]*255)).toString(16);}return"#"+"000000".substring(e.length)+e;}function d1(b){for(var i=0,l=b.length;i<l;i++){if(!isFinite(b[i])){return false;}}return true;}S.prototype.createLegacyAnnotation=function(b,e){var i=b.position;if(!d1(i)){L.warning("Incorrect annotation position",b);return;}b.coordinateSpace|=0;var l=b.backgroundOpacity;if(!l){l=b.backgroundColour?b.backgroundColour[3]:0;}var g1=b.borderOpacity;if(!g1){g1=b.borderColour?b.borderColour[3]:0;}var h1={node:e,coordinateSpace:Z[b.coordinateSpace],style:Y[b.shape||0],width:b.width,height:b.height,backgroundColor:b.backgroundColour?c1(b.backgroundColour):"#fff",backgroundOpacity:l,borderColor:b.borderColour?c1(b.borderColour):"#000",borderOpacity:g1,borderWidth:b.borderWidth,borderLineStyle:$[b.borderLineStyle]};if(b.encoding!==undefined){h1.encoding=b.encoding?f.HtmlText:f.PlainText;h1.font=b.font;h1.fontSize=b.fontSize;h1.fontWeight=Math.min(b.fontWeight,900);h1.fontItalic=b.fontItalic;h1.textColor=c1(b.textColor);h1.link=b.link;h1.horizontalAlignment=b1[b.textHorizontalAlignment];h1.position=new THREE.Vector3().fromArray(i);}else if(b.fontFace){h1.encoding=f.PlainText;h1.font=b.fontFace;h1.fontSize=Math.abs(b.fontSize);h1.fontWeight=Math.min(b.fontWeight,900);h1.textColor=c1(b.textColour);}else{h1.encoding=f.HtmlText;}if(b.coordinateSpace<2){if(!h1.positions){h1.position=new THREE.Vector3(i[0]*2-1,i[1]*-2+1,i[2]);}h1.renderOrder=(b.order|0)+1000;var i1=new c(h1);i1.setText(b.text);this._addDynamicObject(e,i1._update.bind(i1));}else{h1.anchorNode=this._nodes.get(b.sid)||this._rootNode;if(!h1.postion){h1.position=new THREE.Vector3().fromArray(i);}h1.depthTest=false;h1.renderOrder=b.order|0;if(b.alwaysOnTop){h1.renderOrder=1;}var j1=new C(h1);j1.setText(b.text);this._callouts.set(b.id,j1);this._addDynamicObject(e,j1._update.bind(j1));}};S.prototype.createImageNote=function(b,e){this._resetCurrentScene(e);var i=this._nodes.get(b.nodeId);if(!i){L.warning("Image annotation node not found",b);return;}if(b.type==="image"){var l=b.label||{};var g1=this._getMaterialRef(l.materialId);if(!g1){L.warning("Image annotation material not found",b);return;}var h1=i.userData.originalTransform;if(h1){i.position.copy(h1.p);i.scale.copy(h1.s);}var i1=new c({node:i,renderOrder:i.renderOrder||0,coordinateSpace:d.Screen,position:new THREE.Vector3(i.position.x,i.position.y,0),width:(l.width||200)*i.scale.x*0.5,height:(l.height||200)*i.scale.y*0.5});i.position.setScalar(0);i.scale.setScalar(1);i.updateMatrix();i1.setMaterial(g1);this._addDynamicObject(i,i1._update.bind(i1));}else{this.createLegacyImageNote(b,i);}};S.prototype.createLegacyImageNote=function(b,e){var i=new THREE.Vector3().fromArray(b.position);var l=b.width;var g1=b.height;if(!b.properlyAligned){i.x+=b.width*0.5;i.y+=b.height*0.5;i.applyMatrix4(e.matrix);l=b.width*0.5*e.matrix.elements[0];g1=b.height*0.5*e.matrix.elements[5];}var h1=new c({node:e,coordinateSpace:d.Screen,renderOrder:(b.order|0)+1000,position:i,width:l,height:g1});var i1=this._getMaterialRef(b.labelMaterialId);h1.setMaterial(i1);this._addDynamicObject(e,h1._update.bind(h1));};S.prototype.insertLeaderLine=function(b,e){this._resetCurrentScene(e);var g1=this._callouts.get(b.annotationId);if(g1){var h1=this._getMaterialRef(b.materialId);if(!h1){L.warning("Leader line material not found",b);return;}var i1=[];var j1=b.points;for(var i=0,l=j1.length;i<l;i++){i1.push(new THREE.Vector3().fromArray(j1[i]));}var k1;if(b.start){var l1=b.start||{};var m1=b.end||{};var n1=b.extension||{};k1=this._nodes.get(b.start.sid)||this._rootNode;g1.addLeaderLine(i1,k1,h1,X[l1.style]||k.None,X[m1.style]||k.None,l1.size,n1.length||0);}else{k1=this._nodes.get(b.startPointSid)||this._rootNode;g1.addLeaderLine(i1,k1,h1,a1[b.startPointHeadStyle],a1[b.endPointHeadStyle],b.pointHeadConstant,b.extensionLength);}}};S.prototype.createDetailView=function(i,b){this._resetCurrentScene(b);var e=this._nodes.get(i.nodeId);if(!e){L.warning("Detail view node not found",i);return;}var l=i.label;if(!l){this.createLegacyDetailView(i,e);return;}var g1=i.attachment;var h1={name:i.name,camera:l.camera?this.createCamera(l.camera):null,type:i.cutaway?m.Cutaway:m.DetailView,borderWidth:l.borderWidth||0,backgroundColor:_.fromArray(l.colour||[1,1,1]).getStyle(),borderColor:_.fromArray(l.borderColour||[1,1,1]).getStyle(),origin:new THREE.Vector2(e.position.x*2-1+e.scale.x,e.position.y*-2+1-e.scale.x),size:new THREE.Vector2(e.scale.x,e.scale.y),attachmentPoint:new THREE.Vector3().fromArray(g1.position||[0,0,0]),veId:i.veid};if(l.shape==="rect"){h1.shape=!l.leaderStyle||l.leaderStyle==="none"?n.Box:n.BoxLine;}else{h1.shape={none:n.Circle,line:n.CircleLine,pointer:n.CirclePointer,arrow:n.CircleArrow,bubbles:n.CircleBubbles}[l.leaderStyle]||n.Circle;}var i1=new D(h1);if(!this._rootNode.userData._vkDetailViews){this._rootNode.userData._vkDetailViews=[];}this._rootNode.userData._vkDetailViews.push({detailView:i1,node:e,renderOrder:i.renderOrder||e.renderOrder||0});};S.prototype.createLegacyDetailView=function(i,b){if(!i.properlyAligned){if(!i.shape){i.shape=i.leaderStyle?n.BoxLine:n.Box;}else{i.shape=[n.Circle,n.CircleLine,n.CirclePointer,n.CircleArrow,n.CircleBubbles][i.leaderStyle||0];}i.type=i.cutaway?m.Cutaway:m.DetailView;i.camera=i.camera?this.createCamera(i.camera):null;i.origin=new THREE.Vector2(b.position.x*2-1+b.scale.x,b.position.y*-2+1-b.scale.x);i.size=new THREE.Vector2(b.scale.x,b.scale.y);i.renderOrder=b.renderOrder;}else{i.type=[m.DetailView,m.Cutaway][i.type];i.shape=[n.Box,n.Circle,n.CircleLine,n.CirclePointer,n.CircleArrow,n.CircleBubbles,n.BoxLine,n.BoxNoOutline,n.SolidPointer,n.SolidArrow][i.shape];i.camera=this._cameras.get(i.cameraId);i.origin=new THREE.Vector2().fromArray(i.origin);i.size=new THREE.Vector2().fromArray(i.size);}var e=new D({name:i.name,camera:i.camera,type:i.type,shape:i.shape,borderWidth:i.borderWidth||0,backgroundColor:i.backgroundColour?c1(i.backgroundColour):"#fff",borderColor:i.borderColour?c1(i.borderColour):"#000",origin:i.origin,size:i.size,attachmentPoint:new THREE.Vector3().fromArray(i.attachment),metadata:i.metadata,veId:i.veid});if(!this._rootNode.userData._vkDetailViews){this._rootNode.userData._vkDetailViews=[];}this._rootNode.userData._vkDetailViews.push({detailView:e,node:b,renderOrder:i.renderOrder||0});};S.prototype.insertThrustline=function(i){var b=this._nodes.get(i.thrustlineId);if(b&&!this._thrustlines.get(i.thrustlineId)){var e=new a({node:b,principleAxis:new THREE.Vector3().fromArray(i.principleAxis),material:this._getMaterialRef(i.materialId)});var l=[];var g1=0;var h1=0;var i1=0;for(var ii=0;ii<i.itemCount;ii++){var k1={};k1.target=this._nodes.get(i.targets[ii]);k1.majorAxisIndex=i.itemMajorAxisesIndices[ii];var bi;k1.basisAxises=[];i1=g1+i.itemBasisAxisesCounts[ii];for(bi=g1;bi<i1;bi++){var m1={};m1.x=i.itemBasisAxisesCoordinates[bi*3];m1.y=i.itemBasisAxisesCoordinates[bi*3+1];m1.z=i.itemBasisAxisesCoordinates[bi*3+2];k1.basisAxises.push(m1);}g1=i1;k1.dimension={};k1.dimension.x=i.itemDimensionsCoordinates[ii*3];k1.dimension.y=i.itemDimensionsCoordinates[ii*3+1];k1.dimension.z=i.itemDimensionsCoordinates[ii*3+2];k1.center={};k1.center.x=i.itemCentersCoordinates[ii*3];k1.center.y=i.itemCentersCoordinates[ii*3+1];k1.center.z=i.itemCentersCoordinates[ii*3+2];k1.boundPoints=[];i1=h1+i.itemBoundPointsCounts[ii];for(bi=h1;bi<i1;bi++){var n1={};n1.x=i.itemBoundPointsCoordinates[bi*3];n1.y=i.itemBoundPointsCoordinates[bi*3+1];n1.z=i.itemBoundPointsCoordinates[bi*3+2];k1.boundPoints.push(n1);}h1=i1;l.push(k1);}e.setItems(l);var o1=0;var p1=[];for(var si=0;si<i.segmentCount;si++){var r1={};r1.startItemIndex=i.segmentsStartItemIndices[si];r1.endItemIndex=i.segmentsEndItemIndices[si];r1.startBoundIndex=i.segmentsStartBoundIndices[si];r1.endBoundIndex=i.segmentsEndBoundIndices[si];r1.ratios=[];i1=o1+i.segmentRatioCounts[si];for(var ri=0;ri<i1;ri++){var t1={};t1.x=i.segmentRatiosCoordinates[ri*2];t1.y=i.segmentRatiosCoordinates[ri*2+1];r1.ratios.push(t1);}o1=i1;p1.push(r1);}e.setSegments(p1);this._thrustlines.set(i.thrustlineId,e);this._addDynamicObject(b,e._update.bind(e));}};S.prototype._decrementResourceCounters=function(b){b.traverse(function(e){if(e.isMesh){U.decreaseMaterialUsed(e.material);U.decreaseGeometryUsed(e.geometry);}});};S.prototype.decrementResourceCountersForDeletedTreeNode=function(b,e){this._resetCurrentScene(e);var i=this;b=[].concat(b);b.forEach(function(l){var g1=i._nodes.get(l);if(g1){i._decrementResourceCounters(g1);i._nodes.delete(l);}});return this;};S.prototype.remove=function(b,e){this._resetCurrentScene(e);var l=this;b=[].concat(b);b.forEach(function(id){var g1=l._nodes.get(id);if(g1){l._decrementResourceCounters(g1);if(g1.parent){g1.parent.remove(g1);}l._nodes.delete(id);for(var i=0;i<g1.children.length;i++){var h1=g1.children[i];if(h1.userData&&h1.userData.treeNode&&h1.userData.treeNode.sid){l.remove(h1.userData.treeNode.sid,e);}}}});return this;};S.prototype.resourcesCleanUp=function(){var b=this._geometries;b.forEach(function(e){var i=e.userData.geometryUsed;if(i<=0){e.dispose();}});return this;};S.prototype.createCamera=function(b,e){this._resetCurrentScene(e);var i=b.near||1;var l=b.far||200000;var g1;if(b.ortho){g1=new THREE.OrthographicCamera(-1,1,1,-1,i,l);g1.zoom=b.zoom||-1;}else{g1=new THREE.PerspectiveCamera(THREE.Math.radToDeg(b.fov),1,i,l);}if(b.origin){var h1=new THREE.Vector3().fromArray(b.origin);g1.position.copy(h1);}if(b.up){var up=new THREE.Vector3().fromArray(b.up);if(b.notUseDirectionVector){up.sub(g1.position);}g1.up.copy(up.normalize());}if(b.target){if(b.notUseDirectionVector){g1.lookAt(new THREE.Vector3().fromArray(b.target));}else{g1.lookAt((new THREE.Vector3().fromArray(b.target)).add(g1.position));}}this._rootNode.userData.camera=g1;var j1=null;if(g1.isOrthographicCamera){j1=new O();}else if(g1.isPerspectiveCamera){j1=new P();}j1.setCameraRef(g1);j1.setUsingDefaultClipPlanes(true);j1.cameraInfo=b;var k1=b.id;if(k1){this._cameras.set(k1,j1);}this._rootNode.userData.camera=j1;return j1;};S.prototype.insertCamera=function(b,e,i){this._resetCurrentScene(i);var l=this._nodes.get(b);var g1=this._cameras.get(e);if(l&&g1){(l||this._rootNode).add(g1.parent?g1.clone():g1);}return this;};S.prototype.getCamera=function(b){return this._cameras.get(b);};S.prototype.updateMaterialForGeometryWithoutNormal=function(b){var e=this._getMaterialRef(b);if(e&&e.emissive){e.emissive.copy(e.color);e.side=THREE.DoubleSide;}return this;};S.prototype.createMaterial=function(b){var e=[];var i=this._getMaterialRef(b.id);if(b.lineWidth>0){if(!i||!i.isLineBasicMaterial){i=new THREE.LineBasicMaterial();var l=new M(true);l.setMaterialRef(i);this._vkScene.setMaterial(b.id,l);}i.color=new THREE.Color(b.lineColour[0],b.lineColour[1],b.lineColour[2]);i.linewidth=b.lineWidth;i.userData.lineStyle={width:b.lineWidth,haloWidth:b.lineHaloWidth||0,endCapStyle:b.lineEndRound?1:0,dashPattern:b.lineDashPattern||[],dashPatternScale:b.lineDashPatternScale,widthCoordinateSpace:b.lineWidthCoordinateSpace};i.userData.materialInfo=b;i.userData.materialId=b.id;return e;}if(!i){i=this._createTemporaryMaterial(b.id);}delete i.userData.toBeUpdated;i.userData.materialInfo=b;if(b.diffuseColour){i.color.fromArray(b.diffuseColour);}if(b.specularColour){i.specular.fromArray(b.specularColour);}var g1=true;if(b.emissiveColour){i.emissive.fromArray(b.emissiveColour);if(i.emissive.r!==0||i.emissive.g!==0||i.emissive.b!==0){g1=false;i.depthFunc=THREE.LessDepth;}}if(g1&&b.ambientColour){i.emissive.fromArray(b.ambientColour);i.emissive.multiplyScalar(0.2);}if(i.opacity!==undefined){i.opacity=b.opacity;i.transparent=b.opacity<0.99;if(i.transparent){i.side=THREE.DoubleSide;}}var h1=i.glossiness?i.glossiness:0;var i1=i.specularLevel?i.specularLevel:0;i.shininess=h1*2+i1*3;i.userData.defaultHighlightingEmissive=w;i.userData.defaultHighlightingSpecular=x;e=this.updateTextureMaps(b.id);var j1=this._materialMeshes.get(b.id);if(j1){for(var mi=0;mi<j1.length;mi++){var l1=j1[mi];var m1=this._meshNodes.get(l1);if(m1){for(var ni=0;ni<m1.length;ni++){J(m1[ni],b.id,i,this._materialClones);}}}}return e;};S.prototype.getMaterial=function(b){return this._getMaterialRef(b);};var e1=function(b){var i="";try{var l=0x8000;var g1=0;var h1=b.length;var i1;while(g1<h1){i1=b.slice(g1,Math.min(g1+l,h1));i+=String.fromCharCode.apply(null,i1);g1+=l;}}catch(e){i="";}return i;};S.prototype.createImage=function(i){var b=new DataView(i.binaryData.buffer);var e=true;if(b.getUint8(0,true)===parseInt("0xFF",16)&&b.getUint8(1,true)===parseInt("0xD8",16)){e=false;}var l=e1(i.binaryData);var g1="data:image/"+(e?"png":"jpeg")+";base64,"+btoa(l);this._images.set(i.id,g1);return this;};var f1=new THREE.TextureLoader();S.TextureType={Diffuse:0,Bump:1,Opacity:2,Reflection:3,Refraction:4,Specular:5,Ambient:6,Emissive:7,SpecularLevel:8,Glosiness:9,AmbientOcclusion:10,Decal:11};S.prototype.updateTextureMaps=function(b){var e=[];var i=this._getMaterialRef(b);if(!i){return e;}var l=i.userData.materialInfo;if(!l){return e;}if(l.textureDiffuse){var g1=this.updateTextureMap(l.id,S.TextureType.Diffuse);if(g1.imageId){e.push(g1);}}if(l.textureBump){var h1=this.updateTextureMap(l.id,S.TextureType.Bump);if(h1.imageId){e.push(h1);}}if(l.textureOpacity){var i1=this.updateTextureMap(l.id,S.TextureType.Opacity);if(i1.imageId){e.push(i1);}}if(l.textureEmissive){var j1=this.updateTextureMap(l.id,S.TextureType.Emissive);if(j1.imageId){e.push(j1);}}if(l.textureAmbientOcclusion){var k1=this.updateTextureMap(l.id,S.TextureType.AmbientOcclusion);if(k1.imageId){e.push(k1);}}if(l.textureReflection){var l1=this.updateTextureMap(l.id,S.TextureType.Reflection);if(l1.imageId){e.push(l1);}}return e;};S.prototype.updateTextureMap=function(b,e){var i={textureType:e,imageId:null};var l=this._getMaterialRef(b);if(!l){return i;}var g1=l.userData.materialInfo;if(!g1){return i;}var h1=null;switch(e){case S.TextureType.Diffuse:h1=g1.textureDiffuse;break;case S.TextureType.Bump:h1=g1.textureBump;break;case S.TextureType.Opacity:h1=g1.textureOpacity;break;case S.TextureType.Reflection:h1=g1.textureReflection;break;case S.TextureType.Emissive:h1=g1.textureEmissive;break;case S.TextureType.AmbientOcclusion:h1=g1.textureAmbientOcclusion;break;default:break;}if(!h1){return i;}var i1=h1[0];if(!i1){i1=h1;}var j1=this._images.get(i1.imageId);if(!j1){i.imageId=i1.imageId;return i;}var k1=f1.load(j1);k1.wrapS=i1.uvHorizontalTilingEnabled?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;k1.wrapT=i1.uvVerticalTilingEnabled?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping;k1.magFilter=i1.filterMode===1?THREE.NearestFilter:THREE.LinearFilter;k1.minFilter=i1.filterMode===1?THREE.NearestFilter:THREE.LinearMipMapLinearFilter;k1.anisotropy=4;var l1=i1.influence!==undefined?i1.influence:0;var m1=i1.uvHorizontalScale!==undefined?i1.uvHorizontalScale:1;var n1=i1.uvVerticalScale!==undefined?i1.uvVerticalScale:1;var o1=i1.uvHorizontalOffset!==undefined?i1.uvHorizontalOffset:0;var p1=i1.uvVerticalOffset!==undefined?i1.uvVerticalOffset:0;k1.repeat.set(m1,n1);k1.center.set(-o1,-p1);k1.offset.set(o1,p1);k1.rotation=-i1.uvRotationAngle;switch(e){case S.TextureType.Diffuse:l.map=k1;l.transparent|=j1.startsWith("data:image/png");break;case S.TextureType.Bump:l.bumpMap=k1;l.bumpScale=l1;break;case S.TextureType.Opacity:l.alphaMap=k1;break;case S.TextureType.Reflection:k1.mapping=THREE.SphericalReflectionMapping;l.envMap=k1;l.combine=THREE.AddOperation;l.reflectivity=l1;break;case S.TextureType.Emissive:l.emissiveMap=k1;l.emissive.setRGB(1,1,1);break;case S.TextureType.AmbientOcclusion:l.aoMap=k1;break;default:}l.userData.textureAdded=true;l.needsUpdate=true;var q1=this._materialClones.get(b);if(q1){q1.forEach(function(r1){r1.copy(l);r1.needsUpdate=true;});}return i;};S.prototype.insertPlayback=function(b,e,i){this._resetCurrentScene(i);var l=new p({pid:b.id,sequenceId:b.sequenceId,timeScale:b.speed?b.speed:1,preDelay:b.preDelay?b.preDelay:0,postDelay:b.postDelay?b.postDelay:0,repeat:b.repeat?Math.abs(b.repeat):0,reversed:b.reversed?true:false,startTime:b.start?b.start:0});var g1=this._views.get(e);if(g1){var h1=g1.getPlaybacks();if(!h1){h1=[];}h1.push(l);g1.setPlaybacks(h1);}return this;};S.prototype.insertSequence=function(i){var b;if(i.endTime){b=i.endTime;}else{b=1.0;}this._vkScene.createAnimationSequence(i.id,i.name,b);if(i.nodes&&i.nodes.length>0){for(var e=0;e<i.nodes.length;e++){var l=i.nodes[e];T.pushElementIntoMapArray(this._trackIdSequenceNodeMap,l.trackId,{sequenceId:i.id,targetId:l.sid,type:l.binding,pivot:l.pivot});}}return this;};S.prototype.insertTracks=function(b){this._animationHelper.insertTracks(b,this._trackIdSequenceNodeMap,this._nodes,this._vkScene);return this;};S.prototype.finalizeAnimation=function(){var b=this._rootNode;if(b){while(b.parent){b=b.parent;}if(!b.userData){b.userData={};}b.userData.tracks=this._tracks;}return this;};S.prototype.finalizePlaybacks=function(){var b=this._rootNode;if(b){while(b.parent){b=b.parent;}if(!b.userData){b.userData={};}}else{return this;}if(!b.userData.animationNodeOriginalData){b.userData.animationNodeOriginalData=new Map();}var e;var i=this._viewGroups.entries();var l=i.next();while(!l.done){e=l.value[1];l=i.next();var g1=[];for(var vi=0;vi<e.views.length;vi++){if(e.views[vi].id){var i1=this._views.get(e.views[vi].id);if(i1){g1.push(i1);}}}}return this;};S.prototype.finalizeViewGroups=function(b){this._resetCurrentScene(b);var e=this._viewGroups.entries();var i=e.next();while(!i.done){var l=i.value[1];var g1=i.value[0];if(!l||!l.views||!l.views.length){i=e.next();continue;}for(var vi=0;vi<l.views.length;vi++){var i1=l.views[vi].id;var j1=this._views.get(i1);if(j1&&j1.userData.viewInfo.thumbnailId&&!j1.thumbnailData){var k1=this._images.get(j1.userData.viewInfo.thumbnailId);if(k1){j1.thumbnailData=k1;}}if(j1){j1.viewGroupId=g1;l.modelViews.push(j1);}}i=e.next();}return this;};S.prototype.insertViewGroup=function(i,b){this._resetCurrentScene(b);var e=this._rootNode;if(e){while(e.parent){e=e.parent;}if(!e.userData){e.userData={};}}else{return this;}e.userData.viewportGroups=e.userData.viewportGroups||[];var l={name:i.name,type:i.type,description:i.description,metadata:i.metadata,veids:i.veids,originalId:i.id,modelViews:[],views:i.views,sceneId:i.sceneId};e.userData.viewportGroups.push(l);this._viewGroups.set(i.id,l);return this;};S.prototype.getViewGroup=function(b,e){this._resetCurrentScene(e);var i=this._viewGroups.get(b);var l=[];if(i&&i.views){for(var vi=0;vi<i.views.length;vi++){var g1=i.views[vi].id;var h1=this._views.get(g1);if(h1){l.push(h1);}}}return l;};S.prototype.insertView=function(b,e){this._resetCurrentScene(e);var i=new V({name:b.name,description:b.description?"<pre style=\"white-space: pre-wrap;\">"+b.description+"</pre>":b.description});i.userData={};i.userData.viewInfo=b;if(b.thumbnailId){var l=this._images.get(b.thumbnailId);if(l){i.thumbnailData=l;}else{this._viewThumbnails.set(b.thumbnailId,i);}}if(b.animatedThumbnailId){var g1=this._images.get(b.animatedThumbnailId);if(g1){i.animatedThumbnailData=g1;i.tileWidth=this._imageIdsAndTileWidths.get(b.animatedThumbnailId);}}if(b.cameraId){i.camera=this._cameras.get(b.cameraId);}i.type=b.type;i.flyToTime=b.flyToTime;i.preDelay=b.preDelay;i.postDelay=b.postDelay;i.navigationMode=b.navigationMode;i.topColor=b.topColor;i.bottomColor=b.bottomColor;i.renderMode=u[b.renderMethod];i.dimension=b.dimension;i.query=b.query;i.metadata=b.metadata;i.veids=b.veids;i.highlights=[];i.viewGroupId=b.viewGroupId;i.id=b.viewId;this._views.set(b.viewId,i);if(i.viewGroupId){var h1=this._viewGroups.get(i.viewGroupId);if(h1){h1.modelViews.push(i);}}return this;};S.prototype.setModelViewVisibilitySet=function(i){var b=this._views.get(i.viewId);var e=new Set();i.visibleNodes.forEach(function(l){var g1=this._nodes.get(l);if(g1){while(g1&&!e.has(g1)){e.add(g1);g1=g1.parent;}}else{}}.bind(this));b.visibleNodes=Array.from(e);};S.prototype.recordHighlightedNodeInView=function(b,e,i,l){this._resetCurrentScene(l);var g1=this._views.get(i);if(!g1){return this;}var h1=this._nodes.get(e);if(!h1){return this;}if(!g1.highlightIdNodesMap){g1.highlightIdNodesMap=new Map();}var i1=g1.highlightIdNodesMap.get(b);if(!i1){i1=[];}i1.push(h1);g1.highlightIdNodesMap.set(b,i1);return this;};S.prototype.insertHighlightStyle=function(i){var b=this._highlightStyles.get(i.id);if(b){return this;}b=i;this._animationHelper.addAnimationTracksToHighlight(b);this._highlightStyles.set(i.id,b);return this;};S.prototype.insertModelViewHighlight=function(i){var b=this._views.get(i.viewId);if(b){var e=[];i.highlightNodes.forEach(function(i1){var j1=this._nodes.get(i1);if(j1){e.push(j1);}else{}}.bind(this));var l={highlightNodes:e,color1:i.color1,color2:i.color2,opacity1:i.opacity1,opacity2:i.opacity2,duration:i.duration,cycles:i.cycles};if(i.duration===0){l.type="STATIC";}else if(i.duration>0&&i.cycles===0){l.type="INFINITE";}else{l.type="FINITE";}var g1=new THREE.Color(i.color1).toArray();var h1=new THREE.Color(i.color2).toArray();g1[3]=((i.color1>>>24)&255)/255;h1[3]=((i.color2>>>24)&255)/255;l.colours=[g1,h1];l.opacities=[i.opacity1,i.opacity2];this._animationHelper.addAnimationTracksToHighlight(l);b.highlights.push(l);}};S.prototype.createThumbnail=function(i){var b=this._viewThumbnails.get(i.imageId);if(b){b.thumbnailData="data:image/"+"jpeg"+";base64,"+window.btoa(String.fromCharCode.apply(null,i.data));if(this._fireThumbnailLoaded){this._fireThumbnailLoaded({modelView:b});}}};S.prototype.highlightStyleExists=function(i){var b=this._highlightStyles.get(i);return b!==undefined;};S.prototype.finalizeHighlightsInViews=function(){var b,e;var i=this._views.entries();var l=i.next();while(!l.done){b=l.value[1];e=l.value[0];l=i.next();if(b&&b.highlightIdNodesMap){b.highlights=[];var g1=b.highlightIdNodesMap.entries();var h1=g1.next();while(!h1.done){var i1=h1.value[1];var id=h1.value[0];var k1=this._highlightStyles.get(id);if(k1){k1.highlightNodes=i1;b.highlights.push(k1);}h1=g1.next();}this._animationHelper.processHighlights(b,e,this._vkScene);this._animationHelper.setInitialNodePositionsOnView(b,this._vkScene,true);}}var l1=this._viewGroups.entries();var m1=l1.next();while(!m1.done){var n1=m1.value[1];m1=l1.next();if(!n1||!n1.views||!n1.views.length){continue;}var o1=[];for(var vi=0;vi<n1.views.length;vi++){b=this._views.get(e);if(b){o1.push(b);}}if(o1.length>0){this._animationHelper.setInitialNodePositionsFromSubsequentViews(o1,this._vkScene,true);this._animationHelper.setInitialNodePositionsFromPreviousViews(o1,this._vkScene,true);}}return this;};S.prototype.getView=function(b,e){this._resetCurrentScene(e);return this._views.get(b);};S.prototype.getSequence=function(b){return this._vkScene.getAnimationSequence(b);};S.prototype.setViewCamera=function(b,e,i){this._resetCurrentScene(i);var l=this._cameras.get(b);var g1=this._views.get(e);if(l&&g1){g1.camera=l;var h1=l.getCameraRef();if(l.cameraInfo&&h1){var i1=true;var j1=false;if(l.cameraInfo.zoom===-1){j1=true;}var k1=new THREE.Vector3();h1.getWorldDirection(k1);if(h1.type==="PerspectiveCamera"){g1.setCameraInfo({type:h1.type,fov:l.cameraInfo.fov*180/Math.PI,position:h1.position.toArray(),nearClipPlane:h1.near,farClipPlane:h1.far,upDirection:h1.up.toArray(),targetDirection:k1.toArray(),usingDefaultClipPlanes:i1});}if(h1.type==="OrthographicCamera"){g1.setCameraInfo({type:h1.type,zoomFactor:h1.zoom,position:h1.position.toArray(),nearClipPlane:h1.near,farClipPlane:h1.far,upDirection:h1.up.toArray(),targetDirection:k1.toArray(),usingDefaultClipPlanes:i1,zoomNeedRecalculate:j1});}}}return this;};S.prototype.setViewNodeInfos=function(b,e,i){this._resetCurrentScene(i);var l=this._views.get(e);l.setNodeInfos(b);return this;};S.prototype.setViewThumbnail=function(i,b,e,l){this._resetCurrentScene(e);var g1=this._views.get(b);var h1=this._images.get(i);if(g1&&h1){if(g1.userData!==undefined){if(g1.userData.viewInfo.thumbnailId===i){g1.thumbnailData=h1;}else if(g1.userData.viewInfo.animatedThumbnailId===i){g1.animatedThumbnailData=h1;g1.tileWidth=l;}}}return this;};S.prototype.cleanup=function(){this._rootNode=null;if(this._vkScene){this._vkScene.clearMaterials();}this._callouts.clear();this._cameras.clear();this._images.clear();this._imageIdsAndTileWidths.clear();this._geometries.clear();this._meshNodes.clear();this._meshSubmeshes.clear();this._geometryMeshes.clear();this._materialMeshes.clear();this._materialClones.clear();this._currentSceneId=null;if(this._nodes){this._nodes.clear();}if(this._tracks){this._tracks.clear();}if(this._trackIdSequenceNodeMap){this._trackIdSequenceNodeMap.clear();}if(this._viewGroups){this._viewGroups.clear();}if(this._views){this._views.clear();}this._sceneIdTreeNodesMap.clear();this._sceneIdRootNodeMap.clear();this._sceneIdViewGroupMap.clear();this._sceneIdViewMap.clear();this._highlightStyles.clear();S._map.delete(this._id);};S.prototype.insertAnimationGroup=function(i){var b=this._vkScene.getAnimationSequence(i.animationGroupRef.toString());if(!b){var e;if(i.endTime){if(!i.startTime){i.startTime=0;}e=i.endTime-i.startTime;}b=this._vkScene.createAnimationSequence(i.animationGroupRef.toString(),i.name,e);if(!b.userData){b.userData={};}b.userData.animations=[];}if(i.modelViewRef){var l=this._views.get(i.modelViewRef);if(l){var g1=new p({sequenceId:i.animationGroupRef.toString(),timeScale:i.playbackSpeed?i.playbackSpeed:1,preDelay:i.playbackPreDelay?i.playbackPreDelay:0,postDelay:i.playbackPostDelay?i.playbackPostDelay:0,repeat:i.playbackRepeat?Math.abs(i.playbackRepeat):0,reversed:i.playbackReversed?true:false,startTime:0});var h1=l.getPlaybacks();if(!h1){h1=[];}h1.push(g1);l.setPlaybacks(h1);}}};S.prototype.insertAnimation=function(i){var b=this._animations.get(i.animationRef);if(!b){b={};b.type=i.animationType;b.targetRefs=[];b.targetPivots=[];b.sequenceId=i.animationGroupRef.toString();b.animationTracks=new Set();this._animations.set(i.animationRef,b);}if(i.animationGroupRef){var e=this._vkScene.getAnimationSequence(i.animationGroupRef.toString());if(!e.userData.animations.includes(i.animationRef)){e.userData.animations.push(i.animationRef);}}};S.prototype.insertAnimationTarget=function(i){var b=this._animations.get(i.animationRef);if(b){if(!b.targetRefs.includes(i.targetRef)){b.targetRefs.push(i.targetRef);b.targetPivots.push({x:i.targetPivotX,y:i.targetPivotY,z:i.targetPivotZ});}}};S.prototype.insertAnimationTrack=function(i){var b=this._animationTracks.get(i.animationTrackRef);var e=i.animationRef;if(!b){delete i.animationRef;b=i;this._animationTracks.set(i.animationTrackRef,b);}if(!e){return;}var l=this._animations.get(e);if(!l||!l.sequenceId){return;}if(l.animationTracks.has(b.animationTrackRef)){return;}else{l.animationTracks.add(b.animationTrackRef);}var g1=this._vkScene.getAnimationSequence(l.sequenceId);if(!g1){return;}if(!g1.userData){g1.userData={};}if(!g1.userData.tracks){g1.userData.tracks=[];}for(var ti=0;l.targetRefs&&ti<l.targetRefs.length;ti++){var i1=l.targetRefs[ti];var j1=l.targetPivots[ti];var k1=this._nodes.get(i1);if(!k1){continue;}var l1;if(j1.x!==0||j1.y!==0||j1.z!==0){l1=[j1.x,j1.y,j1.z];}var m1=["OPACITY","COLOUR","TRANSLATE","SCALE","ROTATE"][b.type]||"";T.pushElementIntoMapArray(this._trackIdSequenceNodeMap,i.animationTrackRef,{sequenceId:l.sequenceId,targetId:i1,type:m1,pivot:l1});var n1={};n1.times=Array.prototype.slice.call(b.times);n1.values=Array.prototype.slice.call(b.values);n1.id=i.animationTrackRef;n1.cyclicInfo={};n1.cyclicInfo.cyclicStart=b.cyclicStart;n1.cyclicInfo.cyclicEnd=b.cyclicEnd;var ki;if(l.type===0){if(b.dataType===0){if(b.values.length!==b.keyCount||b.times.length!==b.keyCount){continue;}if(b.type===3){n1.values=[];for(ki=0;ki<b.keyCount;ki++){n1.values.push(b.values[ki]);n1.values.push(b.values[ki]);n1.values.push(b.values[ki]);}}}else if(b.dataType===1||b.dataType===3){if(b.values.length!==3*b.keyCount||b.times.length!==b.keyCount){continue;}}else if(b.dataType===4||b.dataType===5||b.dataType===6){if(b.values.length!==4*b.keyCount||b.times.length!==b.keyCount){continue;}if(b.dataType===4){n1.rotateType="angleAxis";}else if(b.dataType===6){n1.rotateType="euler";}else{n1.rotateType="quaternion";for(var vi=3;vi<n1.values.length;vi=vi+4){n1.values[vi]=-n1.values[vi];}}}}g1.userData.tracks.push(n1);}};S.prototype.setAnimationTracks=function(b){var e=this._animations.get(b);if(!e||!e.sequenceId){return;}var i=this._vkScene.getAnimationSequence(e.sequenceId);if(i){if(i.userData&&i.userData.tracks){this._animationHelper.insertTracks(i.userData.tracks,this._trackIdSequenceNodeMap,this._nodes,this._vkScene);}}};S.prototype.setAnimationPlaybacks=function(i){var b=this._viewGroups.get(i.viewGroupId);for(var e=0;e<b.modelViews.length;e++){var l=b.modelViews[e];this._animationHelper.processHighlights(l,l.id,this._vkScene);}this._animationHelper.setInitialNodePositionsFromSubsequentViews(b.modelViews,this._vkScene);this._animationHelper.setInitialNodePositionsFromPreviousViews(b.modelViews,this._vkScene);this._animationHelper.setInitialNodePositionsFromCurrenetViews(b.modelViews,this._vkScene);this._animationHelper.setPlaybackStartTimes(b.modelViews,this._vkScene);};return S;});
