/*!
* SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
*/
sap.ui.define(["sap/ui/core/Element","../ContentConnector","../ViewStateManagerBase","./thirdparty/three","../cssColorToColor","../colorToCSSColor","../abgrToColor","../colorToABGR","./Scene","./ThreeExtensions","../ObjectType"],function(E,C,V,t,c,a,b,d,S,T,O){"use strict";var e;var f=V.extend("sap.ui.vk.threejs.ViewStateManager",{metadata:{}});var g=f.getMetadata().getParent().getClass().prototype;f.prototype.init=function(){if(g.init){g.init.call(this);}this._nodeHierarchy=null;this._nodeStates=new Map();this._selectedNodes=new Set();this._visibilityTracker=new e();this._showSelectionBoundingBox=true;this._boundingBoxesScene=new THREE.Scene();this._selectionColor=new THREE.Color(0xC0C000);this.setHighlightColor("rgba(255, 0, 0, 1.0)");};f.prototype._setContent=function(h){var s=null;if(h&&h instanceof S){s=h;}this._setScene(s);};f.prototype._onAfterUpdateContentConnector=function(){this._setContent(this._contentConnector.getContent());};f.prototype._onBeforeClearContentConnector=function(){this._setScene(null);};f.prototype._handleContentReplaced=function(h){var i=h.getParameter("newContent");this._setContent(i);};f.prototype._setScene=function(s){this._boundingBoxesScene=new THREE.Scene();this._setNodeHierarchy(s?s.getDefaultNodeHierarchy():null);if(s){s.setViewStateManager(this);}return this;};f.prototype._setNodeHierarchy=function(n){var o=this._nodeHierarchy;if(this._nodeHierarchy){this._nodeHierarchy=null;this._nodeStates.clear();this._selectedNodes.clear();this._visibilityTracker.clear();}if(n){this._nodeHierarchy=n;this._nodeHierarchy.attachNodeReplaced(this._handleNodeReplaced,this);this._nodeHierarchy.attachNodeUpdated(this._handleNodeUpdated,this);this._initialState={visible:[],hidden:[]};var h=this;var i=n.findNodesByName();i.forEach(function(j){(j.visible?h._initialState.visible:h._initialState.hidden).push(j);});this.fireVisibilityChanged({visible:this._initialState.visible,hidden:this._initialState.hidden});}if(n!==o){this.fireNodeHierarchyReplaced({oldNodeHierarchy:o,newNodeHierarchy:n});}return this;};f.prototype._handleNodeReplaced=function(h){var r=h.getParameter("ReplacedNodeRef");var i=h.getParameter("ReplacementNodeRef");if(this.getSelectionState(r)){this.setSelectionState(i,true);this.setSelectionState(r,false);}};f.prototype._handleNodeUpdated=function(h){var n=h.getParameter("nodeRef");if(this.getSelectionState(n)){this.setSelectionState(n,false);this.setSelectionState(n,true);}};f.prototype.getNodeHierarchy=function(){return this._nodeHierarchy;};f.prototype.getVisibilityChanges=function(){return this.getShouldTrackVisibilityChanges()?this._visibilityTracker.getInfo(this.getNodeHierarchy()):null;};f.prototype.getVisibilityComplete=function(){var n=this.getNodeHierarchy(),h=n.findNodesByName(),v=[],i=[];h.forEach(function(j){var k=n.createNodeProxy(j);var l=k.getVeId();n.destroyNodeProxy(k);if(l){if(this.getVisibilityState(j)){v.push(l);}else{i.push(l);}}},this);return{visible:v,hidden:i};};f.prototype.resetVisibility=function(){this.setVisibilityState(this._initialState.visible,true,false);this.setVisibilityState(this._initialState.hidden,false,false);this._visibilityTracker.clear();};f.prototype.getVisibilityState=function(n){return Array.isArray(n)?n.map(function(h){return h.visible;}):n.visible;};f.prototype.setVisibilityState=function(n,v,r){if(!Array.isArray(n)){n=[n];}n=(r?this._collectNodesRecursively(n):n).filter(function(i,j,s){return s.indexOf(i)===j;});var h=n.filter(function(i){return i?i.visible!=v:false;},this);if(h.length>0){h.forEach(function(i){i.visible=v;if(v){var j=this._nodeHierarchy.getAncestors(i);this.setVisibilityState(j,true,false);}},this);if(this.getShouldTrackVisibilityChanges()){h.forEach(this._visibilityTracker.trackNodeRef,this._visibilityTracker);}this.fireVisibilityChanged({visible:v?h:[],hidden:v?[]:h});}return this;};f.prototype.enumerateSelection=function(h){this._selectedNodes.forEach(h);return this;};f.prototype.getSelectionState=function(n){var s=this._selectedNodes;function i(h){return s.has(h);}return Array.isArray(n)?n.map(i):i(n);};f.prototype._isAChild=function(h,n){var i=h.parent;while(i){if(n.has(i)){return true;}i=i.parent;}return false;};f.prototype._AddBoundingBox=function(n){if(n.userData.boundingBox===undefined){n.userData.boundingBox=new THREE.Box3();n._vkCalculateObjectOrientedBoundingBox();}if(!n.userData.boundingBox.isEmpty()&&this._boundingBoxesScene&&n.userData.boxHelper===undefined){var h=new THREE.Box3Helper(n.userData.boundingBox,0xffff00);h.material.color=this._selectionColor;this._boundingBoxesScene.add(h);h.parent=n;n.userData.boxHelper=h;}};f.prototype._RemoveBoundingBox=function(n){if(n.userData.boundingBox!==undefined){delete n.userData.boundingBox;}if(n.userData.boxHelper!==undefined){this._boundingBoxesScene.remove(n.userData.boxHelper);delete n.userData.boxHelper;}};f.prototype._updateBoundingBoxesIfNeeded=function(){var u=new Set();this._selectedNodes.forEach(function(n){var p=n.parent;while(p){if(this._selectedNodes.has(p)){u.add(p);}p=p.parent;}}.bind(this));u.forEach(function(n){n._vkCalculateObjectOrientedBoundingBox();});};f.prototype._updateBoundingBoxes=function(){this._selectedNodes.forEach(function(n){if(n.userData.boundingBox){n._vkCalculateObjectOrientedBoundingBox();}});};f.prototype.setShowSelectionBoundingBox=function(v){this._showSelectionBoundingBox=v;if(this._showSelectionBoundingBox){this._selectedNodes.forEach(function(n){this._AddBoundingBox(n);}.bind(this));}else{this._selectedNodes.forEach(function(n){this._RemoveBoundingBox(n);}.bind(this));}this.fireSelectionChanged({selected:this._selectedNodes,unselected:[]});};f.prototype.getShowSelectionBoundingBox=function(){return this._showSelectionBoundingBox;};f.prototype._isAncestorSelected=function(n){n=n.parent;while(n){if(this._selectedNodes.has(n)){return true;}n=n.parent;}return false;};f.prototype._updateHighlightColor=function(n,p){var s=p||this._selectedNodes.has(n);n.userData.highlightColor=s?this._highlightColorABGR:undefined;n._vkUpdateMaterialColor();var h=n.children;for(var i=0,l=h.length;i<l;i++){var u=h[i].userData;if(u&&u.objectType===O.Hotspot){continue;}this._updateHighlightColor(h[i],s);}};f.prototype.setSelectionState=function(n,s,r,h){if(!Array.isArray(n)){n=[n];}n=(r||this.getRecursiveSelection()?this._collectNodesRecursively(n):n).filter(function(v,j,k){return k.indexOf(v)===j;});if(this.getRecursiveSelection()&&!s){n=this._nodeHierarchy._appendAncestors(n);}var i=n.filter(function(j){return this._selectedNodes.has(j)!==s;},this);if(i.length>0){i.forEach(function(j){if(j){this._selectedNodes[s?"add":"delete"](j);if(this._showSelectionBoundingBox){this[s?"_AddBoundingBox":"_RemoveBoundingBox"](j);}}},this);i.forEach(function(j){if(j){this._updateHighlightColor(j,s||this._isAncestorSelected(j));}},this);if(!h){this.fireSelectionChanged({selected:s?i:[],unselected:s?[]:i});}}return this;};f.prototype.setSelectionStates=function(s,u,r,h){if(!Array.isArray(s)){s=[s];}if(!Array.isArray(u)){u=[u];}s=(r||this.getRecursiveSelection()?this._collectNodesRecursively(s):s);u=(r||this.getRecursiveSelection()?this._collectNodesRecursively(u):u);if(this.getRecursiveSelection()){u=this._nodeHierarchy._appendAncestors(u,s);}var i=s.filter(function(n){return this._selectedNodes.has(n)===false;},this);var j=u.filter(function(n){return this._selectedNodes.has(n)===true;},this);if(i.length>0||j.length>0){i.forEach(function(n){this._selectedNodes.add(n);this._updateHighlightColor(n,true);if(this._showSelectionBoundingBox){this._AddBoundingBox(n);}},this);j.forEach(function(n){this._selectedNodes.delete(n);if(this._showSelectionBoundingBox){this._RemoveBoundingBox(n);}},this);j.forEach(function(n){this._updateHighlightColor(n,this._isAncestorSelected(n));},this);if(!h){this.fireSelectionChanged({selected:i,unselected:j});}}return this;};f.prototype._collectNodesRecursively=function(n){var r=[],h=this;n.forEach(function collectChildNodes(i){r.push(i);h._nodeHierarchy.enumerateChildren(i,collectChildNodes,false,true);});return r;};f.prototype._getOpacity=function(n){return n.userData.opacity!==undefined?n.userData.opacity:null;};f.prototype.getOpacity=function(n){if(Array.isArray(n)){return n.map(this._getOpacity,this);}else{return this._getOpacity(n);}};f.prototype.setOpacity=function(n,o,r){if(!Array.isArray(n)){n=[n];}n=(r?this._collectNodesRecursively(n):n).filter(function(v,i,s){return s.indexOf(v)===i;});if(o===null){o=undefined;}var h=n.filter(function(i){return i.userData.opacity!==o;},this);if(h.length>0){h.forEach(function(i){i._vkSetOpacity(o);},this);this.fireOpacityChanged({changed:h,opacity:o});}return this;};f.prototype._getTintColorABGR=function(n){return n.userData.tintColor!==undefined?n.userData.tintColor:null;};f.prototype._getTintColor=function(n){return n.userData.tintColor!==undefined?a(b(n.userData.tintColor)):null;};f.prototype.getTintColor=function(n,i){var h=i?"_getTintColorABGR":"_getTintColor";if(Array.isArray(n)){return n.map(this[h],this);}else{return this[h](n);}};f.prototype.setTintColor=function(n,h,r){if(!Array.isArray(n)){n=[n];}var i=null;switch(typeof h){case"number":i=h;break;case"string":if(sap.ui.core.CSSColor.isValid(h)){i=d(c(h));}break;default:h=null;break;}n=(r?this._collectNodesRecursively(n):n).filter(function(v,k,s){return s.indexOf(v)===k;});var j=n.filter(function(k){return k.userData.tintColor!==i;},this);if(j.length>0){j.forEach(function(k){k._vkSetTintColor(i);},this);this.fireTintColorChanged({changed:j,tintColor:h,tintColorABGR:i});}return this;};f.prototype.setHighlightColor=function(h){switch(typeof h){case"number":this._highlightColorABGR=h;break;case"string":if(sap.ui.core.CSSColor.isValid(h)){this._highlightColorABGR=d(c(h));}break;default:return this;}if(this._selectedNodes.size>0){this._selectedNodes.forEach(function(n){this._updateHighlightColor(n,true);},this);}this.fireHighlightColorChanged({highlightColor:a(b(this._highlightColorABGR)),highlightColorABGR:this._highlightColorABGR});return this;};f.prototype.getHighlightColor=function(i){return i?this._highlightColorABGR:a(b(this._highlightColorABGR));};e=function(){this._visibilityChanges=new Set();};e.prototype.getInfo=function(n){var h=[];this._visibilityChanges.forEach(function(i){var j=n.createNodeProxy(i);var v=j.getVeId();n.destroyNodeProxy(j);if(v){h.push(v);}else{h.push(n.getScene().nodeRefToPersistentId(i));}});return h;};e.prototype.clear=function(){this._visibilityChanges.clear();};e.prototype.trackNodeRef=function(n){if(this._visibilityChanges.has(n)){this._visibilityChanges.delete(n);}else{this._visibilityChanges.add(n);}};C.injectMethodsIntoClass(f);return f;});
