/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)
 *  (C) 2016 SAP SE or an SAP affiliate company. All rights reserved.
 */

var sap = sap || {};
sap.ve = sap.ve || {};
sap.ve.matai = sap.ve.matai || {};
sap.ve.matai.createRuntime = function(options) {
	return new Promise(function(resolve, reject) {
		function createModule(options) {
			// Emscripten module definition begins here. It ends in module_end.js.

			var mergeOption = function(optionName, defaultOptionValue) {
				if (!options) {
					return defaultOptionValue;
				}
				return typeof options[optionName] === "undefined" ? defaultOptionValue : options[optionName];
			};

			// Merge any input options with defaults.
			var mergedOptions = {
				totalMemory:          mergeOption("totalMemory",          128 * 1024 * 1024), // 128 MB
				logElementId:         mergeOption("logElementId",         null),
				statusElementId:      mergeOption("statusElementId",      null),
				prefixURL: mergeOption("prefixURL", null)
			};

			//Create initial Module object with defaults
			var Module = {
				TOTAL_MEMORY: mergedOptions.totalMemory,
				prefixURL: mergedOptions.prefixURL,
				preInit: [],
				postRun: [],
				totalDependencies: 0,
				monitorRunDependencies: null,
				noInitialRun: true,
				noFSInit: true, // NB: Do not initialize standard streams (a workaround for cases when a file is opened before standard streams are initialized).
				print: function() {
					var args = Array.prototype.slice.call(arguments);
					var text = args.join(" ");
					if (mergedOptions.logElementId) {
						var element = document.getElementById(mergedOptions.logElementId);
						element.value += text + "\n";
						element.scrollTop = 99999;
					} else if (self.console) {
						self.console.log("print: " + text);
					}
				},
				printf: function() {
					var args = Array.prototype.slice.call(arguments);
					args.push("(printf)");
					Module.print(args);
				},
				printErr: function() {
					var args = Array.prototype.slice.call(arguments);
					args.push("(printErr)");
					Module.print(args);
				},
				// setStatus is called from Emscripten libraries.
				setStatus: function(text) {
					if (mergedOptions.statusElementId) {
						if (Module.setStatus.interval) {
							clearInterval(Module.setStatus.interval);
						}
						var statusElement = document.getElementById(mergedOptions.statusElementId);
						statusElement.innerHTML = text;
					} else if (Module.logElementId) {
						var args = Array.prototype.slice.call(arguments);
						args.push("(setStatus)");
						Module.print(args);
					}
				},
				locateFile: function(path, scriptDirectory) {
					return this.prefixURL + path;
				}
			};

			// NB: Emscripten generated code will be inserted after this line.

var Module=typeof Module!=="undefined"?Module:{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}Module["arguments"]=[];Module["thisProgram"]="./this.program";Module["quit"]=(function(status,toThrow){throw toThrow});Module["preRun"]=[];Module["postRun"]=[];var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}else{return scriptDirectory+path}}if(ENVIRONMENT_IS_NODE){scriptDirectory=__dirname+"/";var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){var ret;ret=tryParseAsDataURI(filename);if(!ret){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);ret=nodeFS["readFileSync"](filename)}return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));process["on"]("unhandledRejection",(function(reason,p){process["exit"](1)}));Module["quit"]=(function(status){process["exit"](status)});Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(typeof read!="undefined"){Module["read"]=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}Module["readBinary"]=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WEB){if(document.currentScript){scriptDirectory=document.currentScript.src}}else{scriptDirectory=self.location.href}if(scriptDirectory.indexOf("blob:")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf("/")+1)}else{scriptDirectory=""}Module["read"]=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)};Module["setWindowTitle"]=(function(title){document.title=title})}else{}var out=Module["print"]||(typeof console!=="undefined"?console.log.bind(console):typeof print!=="undefined"?print:null);var err=Module["printErr"]||(typeof printErr!=="undefined"?printErr:typeof console!=="undefined"&&console.warn.bind(console)||out);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var STACK_ALIGN=16;function staticAlloc(size){var ret=STATICTOP;STATICTOP=STATICTOP+size+15&-16;return ret}function dynamicAlloc(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=ret+size+15&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}function alignMemory(size,factor){if(!factor)factor=STACK_ALIGN;var ret=size=Math.ceil(size/factor)*factor;return ret}function getNativeTypeSize(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return 4}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}function warnOnce(text){if(!warnOnce.shown)warnOnce.shown={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;err(text)}}var jsCallStartIndex=1;var functionPointers=new Array(0);function addFunction(func,sig){var base=0;for(var i=base;i<base+0;i++){if(!functionPointers[i]){functionPointers[i]=func;return jsCallStartIndex+i}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}var funcWrappers={};function dynCall(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}var GLOBAL_BASE=8;var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}var JSfuncs={"stackSave":(function(){stackSave()}),"stackRestore":(function(){stackRestore()}),"arrayToC":(function(arr){var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};function ccall(ident,returnType,argTypes,args,opts){function convertReturnValue(ret){if(returnType==="string")return Pointer_stringify(ret);if(returnType==="boolean")return Boolean(ret);return ret}var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);ret=convertReturnValue(ret);if(stack!==0)stackRestore(stack);return ret}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for getValue: "+type)}return null}var ALLOC_NORMAL=0;var ALLOC_STATIC=2;var ALLOC_NONE=4;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:staticAlloc,stackAlloc,staticAlloc,dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function getMemory(size){if(!staticSealed)return staticAlloc(size);if(!runtimeInitialized)return dynamicAlloc(size);return _malloc(size)}function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return UTF8ToString(ptr)}var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function allocateUTF8(str){var size=lengthBytesUTF8(str)+1;var ret=_malloc(size);if(ret)stringToUTF8Array(str,HEAP8,ret,size);return ret}function demangle(func){return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}var PAGE_SIZE=16384;var WASM_PAGE_SIZE=65536;var ASMJS_PAGE_SIZE=16777216;var MIN_TOTAL_MEMORY=16777216;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}if(!Module["reallocBuffer"])Module["reallocBuffer"]=(function(size){var ret;try{var oldHEAP8=HEAP8;ret=new ArrayBuffer(size);var temp=new Int8Array(ret);temp.set(oldHEAP8)}catch(e){return false}var success=_emscripten_replace_memory(ret);if(!success)return false;return ret});function enlargeMemory(){var PAGE_MULTIPLE=Module["usingWasm"]?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE;var LIMIT=2147483648-PAGE_MULTIPLE;if(HEAP32[DYNAMICTOP_PTR>>2]>LIMIT){return false}var OLD_TOTAL_MEMORY=TOTAL_MEMORY;TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);while(TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2]){if(TOTAL_MEMORY<=536870912){TOTAL_MEMORY=alignUp(2*TOTAL_MEMORY,PAGE_MULTIPLE)}else{TOTAL_MEMORY=Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=Module["reallocBuffer"](TOTAL_MEMORY);if(!replacement||replacement.byteLength!=TOTAL_MEMORY){TOTAL_MEMORY=OLD_TOTAL_MEMORY;return false}updateGlobalBuffer(replacement);updateGlobalBufferViews();return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;if(TOTAL_MEMORY<TOTAL_STACK)err("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}Module["buffer"]=buffer}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){var n=32;var y=x>>16;if(y){n-=16;x=y}y=x>>8;if(y){n-=8;x=y}y=x>>4;if(y){n-=4;x=y}y=x>>2;if(y){n-=2;x=y}y=x>>1;if(y)return n-2;return n-x});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var dataURIPrefix="data:application/octet-stream;base64,";function isDataURI(filename){return String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0}var ASM_CONSTS=[(function($0,$1){console.log("dtParametricPolygon",$0,$1)}),(function($0){console.log("InsertParametricObject: unsupported parametric object of type",$0)}),(function($0){console.log("InsertParametricPathSegment: unsupported path segment of type",$0)}),(function($0){console.log("InsertParametricTextContent: unsupported text content of type",$0)}),(function($0){console.log("RealiseContent: unsupported object of type",$0)}),(function($0,$1,$2){console.log("geometry: failed "+$0+"-"+$1+"-"+$2)}),(function($0,$1,$2){console.log("image: failed "+$0+"-"+$1+"-"+$2)}),(function($0,$1,$2){console.log("metadata: failed "+$0+"-"+$1+"-"+$2)}),(function($0,$1,$2,$3){console.log("metadata for "+$0+"-"+$1+"-"+$2+": "+Pointer_stringify($3))})];function _emscripten_asm_const_ii(code,a0){return ASM_CONSTS[code](a0)}function _emscripten_asm_const_idi(code,a0,a1){return ASM_CONSTS[code](a0,a1)}function _emscripten_asm_const_iiii(code,a0,a1,a2){return ASM_CONSTS[code](a0,a1,a2)}function _emscripten_asm_const_iiiii(code,a0,a1,a2,a3){return ASM_CONSTS[code](a0,a1,a2,a3)}STATIC_BASE=GLOBAL_BASE;STATICTOP=STATIC_BASE+155648;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_ChangeManager_cpp()})},{func:(function(){__GLOBAL__sub_I_GraphSelectorResolver_cpp()})},{func:(function(){__GLOBAL__sub_I_Math_cpp()})},{func:(function(){__GLOBAL__sub_I_MathConstants_cpp()})},{func:(function(){__GLOBAL__sub_I_DataModelSQLiteReader_cpp()})},{func:(function(){__GLOBAL__sub_I_ZIPVFSCompression_cpp()})},{func:(function(){___emscripten_environ_constructor()})});memoryInitializer="data:application/octet-stream;base64,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";var tempDoublePtr=STATICTOP;STATICTOP+=16;var SB={init:(function(){var nextSceneBuilderId=1;var idToSceneBuilder=new Map;var sceneBuilderToId=new Map;var shapes=[];var pathSegments=[];var textContent;var textContents=[];var lineStyle;var fillStyle;SB.add=(function(sceneBuilder){idToSceneBuilder.set(nextSceneBuilderId,sceneBuilder);sceneBuilderToId.set(sceneBuilder,nextSceneBuilderId);return nextSceneBuilderId++});SB.delete=(function(sceneBuilder){idToSceneBuilder.delete(sceneBuilderToId.get(sceneBuilder));sceneBuilderToId.delete(sceneBuilder)});SB.getById=(function(id){return idToSceneBuilder.get(id)});SB.addShape=(function(shape){if(lineStyle){shape.lineStyle=lineStyle}if(fillStyle){shape.fillStyle=fillStyle}shapes.push(shape)});SB.flushShapes=(function(){var result=shapes;shapes=[];return result});SB.addPathSegment=(function(shape){pathSegments.push(shape)});SB.flushPathSegments=(function(){var result=pathSegments;pathSegments=[];return result});SB.setLineStyle=(function(style){lineStyle=style});SB.getLineStyle=(function(style){return lineStyle});SB.setFillStyle=(function(style){fillStyle=style});SB.getFillStyle=(function(style){return fillStyle});SB.beginParametricTextContent=(function(newContext,type){if(textContents.length>0){textContents[textContents.length-1].content.push(newContext)}textContents.push(newContext)});SB.insertParametricTextData=(function(textData){textContents[textContents.length-1].content.push(textData)});SB.endParametricTextContent=(function(){textContent=textContents.pop();if(pathSegments.length>0){textContent.pathSegments=SB.flushPathSegments()}});SB.flushTextContent=(function(){textContents=[];return textContent})})};function _SceneBuilderAdapter_beginParametricTextContent(contentSubtype,size,horizontalAlign,dominantBaseline,linePitch,widthScale,fontFace,isSHXFont,italic,bold,underline,hasOverline,hasStrikethrough,expand,textHeightAs,direction,upsideDown,backward,obliquingAngle,textLength,lengthUnit,lengthAdjust){var style={size:size,horizontalAlign:horizontalAlign,dominantBaseline:dominantBaseline,linePitch:linePitch,widthScale:widthScale,fontFace:UTF8ToString(fontFace),isSHXFont:!!isSHXFont,italic:!!italic,bold:!!bold,underline:!!underline,hasOverline:!!hasOverline,hasStrikethrough:!!hasStrikethrough,expand:expand,textHeightAs:textHeightAs,direction:direction,upsideDown:!!upsideDown,backward:!!backward,obliquingAngle:obliquingAngle,textLength:getArrayF32(textLength,2),lengthUnit:lengthUnit,lengthAdjust:lengthAdjust};var lineStyle=SB.getLineStyle();if(lineStyle){style.lineStyle=lineStyle}var fillStyle=SB.getFillStyle();if(fillStyle){style.fillStyle=fillStyle}SB.beginParametricTextContent({type:contentSubtype,style:style,content:[]})}function _SceneBuilderAdapter_clearFillStyle(){SB.setFillStyle()}function _SceneBuilderAdapter_clearLineStyle(){SB.setLineStyle()}function _SceneBuilderAdapter_createCamera(sceneBuilderId,matrix,isOrtho,aspect,autoEvaluateClipPlanes,nearClip,farClip,fov,fovBinding,orthoZoomFactor,origin,up,target,cameraRef){var builder=SB.getById(sceneBuilderId);builder.createCamera({matrix:matrix?getArrayF64(matrix,16):null,projection:isOrtho?"orthographic":"perspective",aspect:aspect,autoEvaluateClipPlanes:!!autoEvaluateClipPlanes,nearClip:nearClip,farClip:farClip,fov:fov,fovBinding:fovBinding,orthoZoomFactor:orthoZoomFactor,origin:getArrayF32(origin,3),up:getArrayF32(up,3),target:getArrayF32(target,3),cameraRef:cameraRef})}function _SceneBuilderAdapter_createDefaultMaterial(sceneBuilderId){var builder=SB.getById(sceneBuilderId);builder.createMaterial({name:"",ambient:new Float32Array([.12,.12,.12]),diffuse:new Float32Array([.75,.75,.75]),specular:new Float32Array([.75,.75,.75]),emissive:new Float32Array([0,0,0]),opacity:1,glossiness:.2,specularLevel:1,materialRef:0})}function _SceneBuilderAdapter_createDetailView(sceneBuilderId,nodeRef,detailViewRef,name,description,cameraRef,type,shape,borderWidth,backgroundColor,borderColor,renderOrder,origin,size,attachmentPoint,metadata,veids,visibleNodeCount,visibleNodeRefs,targetNodeCount,targetNodeRefs){var builder=SB.getById(sceneBuilderId);builder.createDetailView({nodeRef:nodeRef,detailViewRef:detailViewRef,name:UTF8ToString(name),description:UTF8ToString(description),cameraRef:cameraRef,type:type,shape:shape,borderWidth:borderWidth,backgroundColor:backgroundColor,borderColor:borderColor,renderOrder:renderOrder,origin:getArrayF32(origin,2),size:getArrayF32(size,2),attachmentPoint:attachmentPoint?getArrayF32(attachmentPoint,3):null,metadata:metadata?JSON.parse(UTF8ToString(metadata)):{},veids:veids?JSON.parse(UTF8ToString(veids)):{},visibleNodes:getArrayU32(visibleNodeRefs,visibleNodeCount),targetNodes:getArrayU32(targetNodeRefs,targetNodeCount)})}function _SceneBuilderAdapter_createImage(sceneBuilderId,imageRef,path,width,height,colorDepth,format,data,dataSize){var builder=SB.getById(sceneBuilderId);builder.createImage({imageRef:imageRef,path:UTF8ToString(path),width:width,height:height,colorDepth:colorDepth,format:imageFormat[format],data:(new Uint8Array(Module.buffer,data,dataSize)).slice()})}function _SceneBuilderAdapter_createImageNote(sceneBuilderId,nodeRef,position,width,height,materialRef){var builder=SB.getById(sceneBuilderId);var info={nodeRef:nodeRef,position:getArrayF32(position,3),width:width,height:height,materialRef:materialRef};builder.createImageNote(info)}function _SceneBuilderAdapter_createMaterial(sceneBuilderId,name,ambient,diffuse,specular,emissive,opacity,glossiness,specularLevel,colourMapEnabled,width,haloWidth,color,endCapStyle,dashPatternScale,dashPattern,dashPatternCount,widthCoordinateSpace,textureCount,texturesBuffer,materialRef){var builder=SB.getById(sceneBuilderId);var info={name:UTF8ToString(name),ambient:getArrayF32(ambient,4),diffuse:getArrayF32(diffuse,4),specular:getArrayF32(specular,4),emissive:getArrayF32(emissive,4),opacity:opacity,glossiness:glossiness,specularLevel:specularLevel,colourMapEnabled:colourMapEnabled,linestyle:{width:width,haloWidth:haloWidth,color:getArrayF32(color,4),endCapStyle:endCapStyle,dashPatternScale:dashPatternScale,dashPattern:getArrayF32(dashPattern,dashPatternCount),widthCoordinateSpace:widthCoordinateSpace},materialRef:materialRef};if(textureCount>0){info.textures=[];var p=texturesBuffer;for(var i=0;i<textureCount;i++,p+=56){var flags=getValue(p+54,"i16");info.textures.push({imageRef:getValue(p,"i32"),matrix:getArrayF32(p+4,6),scaleX:getValue(p+28,"float"),scaleY:getValue(p+32,"float"),offsetX:getValue(p+36,"float"),offsetY:getValue(p+40,"float"),angle:getValue(p+44,"float"),amount:getValue(p+48,"float"),type:textureType[getValue(p+52,"i8")],filterMode:getValue(p+53,"i8"),repeatX:(flags&1)!==0,repeatY:(flags&2)!==0,clampToBorder:(flags&3)!==0,invert:(flags&4)!==0,modulate:(flags&5)!==0})}}builder.createMaterial(info)}function _SceneBuilderAdapter_createMesh(sceneBuilderId,materialRef,boundingBox,matrix,meshRef){var builder=SB.getById(sceneBuilderId);var info={materialRef:materialRef,boundingBox:getArrayF32(boundingBox,6),matrix:matrix?getArrayF64(matrix,16):null,meshRef:meshRef};builder.createMesh(info)}function _SceneBuilderAdapter_createNode(sceneBuilderId,parentRef,name,matrix,opacity,visible,closed,selectable,visualisable,transformType,renderOrder,renderMethod,renderStage,metadata,veids,nodeRef){var builder=SB.getById(sceneBuilderId);builder.createNode({parentRef:parentRef,name:UTF8ToString(name),matrix:getArrayF64(matrix,16),opacity:opacity,visible:!!visible,closed:!!closed,selectable:!!selectable,visualisable:!!visualisable,transformType:transformType,renderOrder:renderOrder,renderMethod:renderMethod,renderStage:renderStage,metadata:JSON.parse(UTF8ToString(metadata)),veids:JSON.parse(UTF8ToString(veids)),nodeRef:nodeRef})}function _SceneBuilderAdapter_createTextAnnotation(sceneBuilderId,nodeRef,position,encoding,text,font,fontSize,fontWeight,fontItalic,width,height,style,textColor,backgroundColor,backgroundOpacity,borderWidth,borderLineStyle,borderColor,borderOpacity,horizontalAlignment,verticalAlignment,link){var builder=SB.getById(sceneBuilderId);var info={nodeRef:nodeRef,position:getArrayF32(position,3),encoding:encoding,text:UTF8ToString(text),font:UTF8ToString(font),fontSize:fontSize,fontWeight:fontWeight,fontItalic:!!fontItalic,width:width,height:height,style:style,textColor:textColor,backgroundColor:backgroundColor,backgroundOpacity:backgroundOpacity,borderWidth:borderWidth,borderLineStyle:borderLineStyle,borderColor:borderColor,borderOpacity:borderOpacity,horizontalAlignment:horizontalAlignment,verticalAlignment:verticalAlignment,link:UTF8ToString(link)};builder.createTextAnnotation(info)}function _SceneBuilderAdapter_createTextNote(sceneBuilderId,nodeRef,targetNodeRef,position,alwaysOnTop,encoding,text,font,fontSize,fontWeight,fontItalic,width,height,style,textColor,backgroundColor,backgroundOpacity,borderWidth,borderLineStyle,borderColor,borderOpacity,horizontalAlignment,verticalAlignment,link){var builder=SB.getById(sceneBuilderId);var info={nodeRef:nodeRef,targetNodeRef:targetNodeRef,position:getArrayF32(position,3),alwaysOnTop:!!alwaysOnTop,encoding:encoding,text:UTF8ToString(text),font:UTF8ToString(font),fontSize:fontSize,fontWeight:fontWeight,fontItalic:!!fontItalic,width:width,height:height,style:style,textColor:textColor,backgroundColor:backgroundColor,backgroundOpacity:backgroundOpacity,borderWidth:borderWidth,borderLineStyle:borderLineStyle,borderColor:borderColor,borderOpacity:borderOpacity,horizontalAlignment:horizontalAlignment,verticalAlignment:verticalAlignment,link:UTF8ToString(link)};builder.createTextNote(info)}function _SceneBuilderAdapter_createThumbnail(sceneBuilderId,imageRef,path,width,height,format,data,dataSize){var builder=SB.getById(sceneBuilderId);builder.createThumbnail({imageRef:imageRef,path:UTF8ToString(path),width:width,height:height,format:imageFormat[format],data:(new Uint8Array(Module.buffer,data,dataSize)).slice()})}function _SceneBuilderAdapter_createViewportGroup(sceneBuilderId,viewportGroupRef,name,description,type,metadata,veids){var builder=SB.getById(sceneBuilderId);builder.createViewportGroup({viewportGroupRef:viewportGroupRef,name:UTF8ToString(name),description:UTF8ToString(description),type:type,metadata:metadata?JSON.parse(UTF8ToString(metadata)):{},veids:veids?JSON.parse(UTF8ToString(veids)):{}})}function _SceneBuilderAdapter_endParametricTextContent(){SB.endParametricTextContent()}function _SceneBuilderAdapter_finalizeAnimation(sceneBuilderId,animationRef){var builder=SB.getById(sceneBuilderId);builder.finalizeAnimation(animationRef)}function _SceneBuilderAdapter_finalizePlaybacks(sceneBuilderId,viewportGroupRef){var builder=SB.getById(sceneBuilderId);builder.finalizePlaybacks({viewportGroupRef:viewportGroupRef})}function _SceneBuilderAdapter_insertAnimation(sceneBuilderId,animationGroupRef,animationRef,animationType){var builder=SB.getById(sceneBuilderId);builder.insertAnimation({animationGroupRef:animationGroupRef,animationRef:animationRef,animationType:animationType})}function _SceneBuilderAdapter_insertAnimationGroup(sceneBuilderId,modelViewRef,animationGroupRef,startTime,endTime,frameRate,active,cyclic,currentTime,name,playbackSpeed,playbackPreDelay,playbackPostDelay,playbackRepeat,playbackReversed){var builder=SB.getById(sceneBuilderId);builder.insertAnimationGroup({modelViewRef:modelViewRef,animationGroupRef:animationGroupRef,startTime:startTime,endTime:endTime,frameRate:frameRate,active:active,cyclic:cyclic,currentTime:currentTime,name:UTF8ToString(name),playbackSpeed:playbackSpeed,playbackPreDelay:playbackPreDelay,playbackPostDelay:playbackPostDelay,playbackRepeat:playbackRepeat,playbackReversed:playbackReversed})}function _SceneBuilderAdapter_insertAnimationTarget(sceneBuilderId,animationRef,targetRef,targetPivotX,targetPivotY,targetPivotZ){var builder=SB.getById(sceneBuilderId);builder.insertAnimationTarget({animationRef:animationRef,targetRef:targetRef,targetPivotX:targetPivotX,targetPivotY:targetPivotY,targetPivotZ:targetPivotZ})}function _SceneBuilderAdapter_insertAnimationTrack(sceneBuilderId,animationRef,animationTrackRef,type,dataType,interpolationType,cyclicStart,cyclicEnd,keyCount,valueCount,times,tensions,continuities,biases,easeIns,easeOuts,values){var builder=SB.getById(sceneBuilderId);builder.insertAnimationTrack({animationRef:animationRef,animationTrackRef:animationTrackRef,type:type,dataType:dataType,interpolationType:interpolationType,cyclicStart:cyclicStart,cyclicEnd:cyclicEnd,keyCount:keyCount,valueCount:valueCount,times:getArrayF32(times,keyCount),tensions:getArrayF32(tensions,keyCount),continuities:getArrayF32(continuities,keyCount),biases:getArrayF32(biases,keyCount),easeIns:getArrayF32(easeIns,keyCount),easeOuts:getArrayF32(easeOuts,keyCount),values:getArrayF32(values,valueCount)})}function _SceneBuilderAdapter_insertArcPathSegment(major,minor,angle,followLargeArc,clockwise,numCoords,coords,dimension,relative){SB.addPathSegment({type:"arc",major:major,minor:minor,angle:angle,followLargeArc:followLargeArc,clockwise:clockwise,points:coords?getArrayF32(coords,numCoords):null,dimension:dimension,relative:relative})}function _SceneBuilderAdapter_insertBezierPathSegment(degree,numCoords,coords,dimension,relative){SB.addPathSegment({type:"bezier",degree:degree,points:coords?getArrayF32(coords,numCoords):null,dimension:dimension,relative:relative})}function _SceneBuilderAdapter_insertCamera(sceneBuilderId,nodeRef,cameraRef){var builder=SB.getById(sceneBuilderId);builder.insertCamera(nodeRef,cameraRef)}function _SceneBuilderAdapter_insertClosePathSegment(){SB.addPathSegment({type:"close"})}function _SceneBuilderAdapter_insertLeaderLine(sceneBuilderId,nodeRef,targetNodeRef,materialRef,pointCount,points,startPointStyle,endPointStyle,styleConstant,extensionLength){var builder=SB.getById(sceneBuilderId);builder.insertLeaderLine({nodeRef:nodeRef,targetNodeRef:targetNodeRef,materialRef:materialRef,points:points?getArrayF32(points,pointCount*3):null,startPointStyle:startPointStyle,endPointStyle:endPointStyle,styleConstant:getArrayF32(styleConstant,2),extensionLength:extensionLength})}function _SceneBuilderAdapter_insertLinePathSegment(numCoords,coords,dimension,relative){SB.addPathSegment({type:"line",points:coords?getArrayF32(coords,numCoords):null,dimension:dimension,relative:relative})}function _SceneBuilderAdapter_insertMesh(sceneBuilderId,nodeRef,meshRef){var builder=SB.getById(sceneBuilderId);builder.insertMesh(nodeRef,meshRef)}function _SceneBuilderAdapter_insertModelView(sceneBuilderId,viewportGroupRef,modelViewRef,name,description,thumbnail,cameraRef,type,flyToTime,preDelay,postDelay,navigationMode,topColour,bottomColour,renderMethod,dimension,query,metadata,veids){var builder=SB.getById(sceneBuilderId);builder.insertModelView({viewportGroupRef:viewportGroupRef,modelViewRef:modelViewRef,name:UTF8ToString(name),description:UTF8ToString(description),thumbnail:thumbnail,cameraRef:cameraRef,type:type,flyToTime:flyToTime,preDelay:preDelay,postDelay:postDelay,navigationMode:navigationMode,topColour:topColour,bottomColour:bottomColour,renderMethod:renderMethod,dimension:dimension,query:UTF8ToString(query),metadata:metadata?JSON.parse(UTF8ToString(metadata)):{},veids:veids?JSON.parse(UTF8ToString(veids)):{}})}function _SceneBuilderAdapter_insertModelViewHighlight(sceneBuilderId,modelViewRef,highlightNodeCount,highlightNodeRefs,color1,color2,opacity1,opacity2,duration,cycles){var builder=SB.getById(sceneBuilderId);builder.insertModelViewHighlight({modelViewRef:modelViewRef,highlightNodes:getArrayU32(highlightNodeRefs,highlightNodeCount),color1:color1,color2:color2,opacity1:opacity1,opacity2:opacity2,duration:duration,cycles:cycles})}function _SceneBuilderAdapter_insertMovePathSegment(numCoords,coords,dimension,relative){SB.addPathSegment({type:"move",points:coords?getArrayF32(coords,numCoords):null,dimension:dimension,relative:relative})}function _SceneBuilderAdapter_insertParametricArc(pos,quat,scale,materialRef,rx,ry,startAngle,endAngle,fillStrokeVisibility,closureType){SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"arc",major:rx,minor:ry,start:startAngle,end:endAngle,fillStrokeVisibility:fillStrokeVisibility,closureType:closureType})}function _SceneBuilderAdapter_insertParametricEllipse(pos,quat,scale,materialRef,rx,ry,fillStrokeVisibility){SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"ellipse",major:rx,minor:ry,fillStrokeVisibility:fillStrokeVisibility})}function _SceneBuilderAdapter_insertParametricPath(pos,quat,scale,materialRef,numSegments){var segments=SB.flushPathSegments();SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"path",numSegments:numSegments,segments:segments})}function _SceneBuilderAdapter_insertParametricPolyline(pos,quat,scale,materialRef,numCoords,coords,dimension,closed){coords=getArrayF32(coords,numCoords);if(numCoords===2*dimension){SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"line",x1:coords[0],y1:coords[1],x2:coords[dimension],y2:coords[dimension+1]})}else{SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"polyline",points:coords,dimension:dimension,closed:closed})}}function _SceneBuilderAdapter_insertParametricRectangle(pos,quat,scale,materialRef,width,height){SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"rectangle",width:width,height:height})}function _SceneBuilderAdapter_insertParametricText(pos,quat,scale,materialRef,textTranslate,translateDelta){var content=SB.flushTextContent();SB.addShape({t:pos?getArrayF32(pos,3):null,r:quat?getArrayF32(quat,4):null,s:scale?getArrayF32(scale,3):null,materialID:materialRef,type:"text",textTranslate:textTranslate?getArrayF32(textTranslate,3):null,translateDelta:translateDelta?getArrayF32(translateDelta,3):null,style:content.style,content:content.content})}function _SceneBuilderAdapter_insertParametricTextData(textData,contentSubtype){SB.insertParametricTextData({type:contentSubtype,text:UTF8ToString(textData)})}function _SceneBuilderAdapter_insertThrustline(sceneBuilderId,thrustlineRef,principleAxis,materialRef,itemCount,targets,itemMajorAxisesIndices,itemBasisAxisesCounts,itemBasisAxisesCoordinatesDataSize,itemBasisAxisesCoordinates,itemDimensionsCoordinates,itemCentersCoordinates,itemBoundPointsCounts,itemBoundPointsCoordinatesDataSize,itemBoundPointsCoordinates,segmentCount,segmentsStartItemIndices,segmentsEndItemIndices,segmentsStartBoundIndices,segmentsEndBoundIndices,segmentRatioCounts,segmentRatiosCoordinatesDataSize,segmentRatiosCoordinates){var builder=SB.getById(sceneBuilderId);builder.insertThrustline({thrustlineRef:thrustlineRef,principleAxis:getArrayF32(principleAxis,3),material:materialRef,itemCount:itemCount,targets:getArrayU32(targets,itemCount),itemMajorAxisesIndices:getArrayU32(itemMajorAxisesIndices,itemCount),itemBasisAxisesCounts:getArrayU32(itemBasisAxisesCounts,itemCount),itemBasisAxisesCoordinates:getArrayF32(itemBasisAxisesCoordinates,itemBasisAxisesCoordinatesDataSize),itemDimensionsCoordinates:getArrayF32(itemDimensionsCoordinates,itemCount*3),itemCentersCoordinates:getArrayF32(itemCentersCoordinates,itemCount*3),itemBoundPointsCounts:getArrayU32(itemBoundPointsCounts,itemCount),itemBoundPointsCoordinates:getArrayF32(itemBoundPointsCoordinates,itemBoundPointsCoordinatesDataSize),segmentCount:segmentCount,segmentsStartItemIndices:getArrayU32(segmentsStartItemIndices,segmentCount),segmentsEndItemIndices:getArrayU32(segmentsEndItemIndices,segmentCount),segmentsStartBoundIndices:getArrayU32(segmentsStartBoundIndices,segmentCount),segmentsEndBoundIndices:getArrayU32(segmentsEndBoundIndices,segmentCount),segmentRatioCounts:getArrayU32(segmentRatioCounts,segmentCount),segmentRatiosCoordinates:getArrayF32(segmentRatiosCoordinates,segmentRatiosCoordinatesDataSize)})}function _SceneBuilderAdapter_progress(sceneBuilderId,progress){var builder=SB.getById(sceneBuilderId);builder.progress(progress)}function _SceneBuilderAdapter_setFillStyle(type,start,end,radii,numStops,stopsData,coordinateSpace,gradientTransform,spreadMethod){stopsData=getArrayF32(stopsData,numStops*5);var stops=[];for(var i=0,j=0;i<numStops;i++,j+=5){stops.push({offsetFraction:stopsData[j],color:new Float32Array([stopsData[j+1],stopsData[j+2],stopsData[j+3],stopsData[j+3]])})}SB.setFillStyle({type:type,start:getArrayF32(start,3),end:getArrayF32(end,3),radii:getArrayF32(radii,2),stops:stops,coordinateSpace:coordinateSpace,gradientTransform:gradientTransform?getArrayF64(gradientTransform,16):null,spreadMethod:spreadMethod})}function _SceneBuilderAdapter_setLineStyle(color,width,units,endCapStyle,joinStyle,miterLimit,dashPatternOffset,dashArrayLength,dashArray){SB.setLineStyle({color:getArrayF32(color,4),width:width,units:units,endCapStyle:endCapStyle,joinStyle:joinStyle,miterLimit:miterLimit,dashPatternOffset:dashPatternOffset,dashArray:getArrayF32(dashArray,dashArrayLength)})}function _SceneBuilderAdapter_setMeshGeometry(sceneBuilderId,flags,pointCount,triangleCount,splatCount,data,dataSize,vertexDataSize,indexDataSize,vertexSize,meshRef){var builder=SB.getById(sceneBuilderId);var info={flags:flags,pointCount:pointCount,triangleCount:triangleCount,splatCount:splatCount,meshRef:meshRef};if(data&&dataSize){var indexData=new Uint16Array(Module.buffer,data+vertexDataSize,indexDataSize>>1);var vertexData=new Float32Array(Module.buffer,data,vertexDataSize>>2);var vertexCount=pointCount+splatCount;var vertexSize=vertexSize;var flags=flags;var offset=0;var i;var si;var di;var data={};data.index=new Uint16Array(indexData);var positionData=new Float32Array(vertexCount*3);for(i=0,di=0,si=offset;i<vertexCount;i++,si+=vertexSize){positionData[di++]=vertexData[si+0];positionData[di++]=vertexData[si+1];positionData[di++]=vertexData[si+2]}data.position=positionData;offset+=3;if(flags&2){var normalData=new Float32Array(vertexCount*3);for(i=0,di=0,si=offset;i<vertexCount;i++,si+=vertexSize){normalData[di++]=vertexData[si+0];normalData[di++]=vertexData[si+1];normalData[di++]=vertexData[si+2]}data.normal=normalData;offset+=3}if(flags&4){var uvData=new Float32Array(vertexCount*2);for(i=0,di=0,si=offset;i<vertexCount;i++,si+=vertexSize){uvData[di++]=vertexData[si+0];uvData[di++]=vertexData[si+1]}data.uv=uvData;offset+=2}info.data=data}builder.setMeshGeometry(info)}function _SceneBuilderAdapter_setModelViewVisibility(sceneBuilderId,modelViewRef,visibleNodeCount,visibleNodeRefs){var builder=SB.getById(sceneBuilderId);builder.setModelViewVisibilitySet({modelViewRef:modelViewRef,visibleNodes:getArrayU32(visibleNodeRefs,visibleNodeCount)})}function _SceneBuilderAdapter_setParametricContent(sceneBuilderId,nodeRef){var builder=SB.getById(sceneBuilderId);var shapes=SB.flushShapes();if(shapes.length>0){builder.setParametricContent(nodeRef,shapes.length>1?{shapes:shapes}:shapes[0])}}function _SceneBuilderAdapter_setScene(sceneBuilderId,result,cameraRef,backgroundTopColor,backgroundBottomColor,renderMethod,upAxis,meshCount,imageCount,modelViewCount){var builder=SB.getById(sceneBuilderId);builder.setScene({result:result,cameraRef:cameraRef,backgroundTopColor:backgroundTopColor,backgroundBottomColor:backgroundBottomColor,renderMethod:renderMethod,upAxis:upAxis,meshCount:meshCount,imageCount:imageCount,modelViewCount:modelViewCount})}var ENV={};function ___buildEnvironment(environ){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C.UTF-8";ENV["_"]=Module["thisProgram"];poolPtr=getMemory(TOTAL_ENV_SIZE);envPtr=getMemory(MAX_ENV_VALUES*4);HEAP32[envPtr>>2]=poolPtr;HEAP32[environ>>2]=envPtr}else{envPtr=HEAP32[environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in ENV){if(typeof ENV[key]==="string"){var line=key+"="+ENV[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}function _emscripten_get_now(){abort()}function _emscripten_get_now_is_monotonic(){return ENVIRONMENT_IS_NODE||typeof dateNow!=="undefined"||(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if(clk_id===1&&_emscripten_get_now_is_monotonic()){now=_emscripten_get_now()}else{___setErrNo(ERRNO_CODES.EINVAL);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}function ___clock_gettime(){return _clock_gettime.apply(null,arguments)}function ___cxa_allocate_exception(size){return _malloc(size)}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var key in EXCEPTIONS.infos){var ptr=+key;var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0&&!info.rethrown){if(info.destructor){Module["dynCall_vi"](info.destructor,ptr)}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___cxa_begin_catch(ptr){var info=EXCEPTIONS.infos[ptr];if(info&&!info.caught){info.caught=true;__ZSt18uncaught_exceptionv.uncaught_exception--}if(info)info.rethrown=false;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}function ___cxa_end_catch(){Module["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function ___cxa_rethrow(){var ptr=EXCEPTIONS.caught.pop();ptr=EXCEPTIONS.deAdjust(ptr);if(!EXCEPTIONS.infos[ptr].rethrown){EXCEPTIONS.caught.push(ptr);EXCEPTIONS.infos[ptr].rethrown=true}EXCEPTIONS.last=ptr;throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(setTempRet0(0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(setTempRet0(0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(setTempRet0(typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(setTempRet0(throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0,caught:false,rethrown:false};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_uncaught_exception(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___gxx_personality_v0(){}function ___lock(){}function ___map_file(pathname,size){___setErrNo(ERRNO_CODES.EPERM);return-1}var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var isPosixPlatform=process.platform!="win32";var fd=process.stdin.fd;if(isPosixPlatform){var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}}try{bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null)}catch(e){if(e.toString().indexOf("EOF")!=-1)bytesRead=0;else throw e}if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){out(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){out(UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){err(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){err(UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}if(!req){return callback("Unable to connect to IndexedDB")}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);try{var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}catch(e){return callback(e)}}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/);var flags=process["binding"]("constants");if(flags["fs"]){flags=flags["fs"]}NODEFS.flagsForNodeMap={"1024":flags["O_APPEND"],"64":flags["O_CREAT"],"128":flags["O_EXCL"],"0":flags["O_RDONLY"],"2":flags["O_RDWR"],"4096":flags["O_SYNC"],"512":flags["O_TRUNC"],"1":flags["O_WRONLY"]}}),bufferFrom:(function(arrayBuffer){return Buffer.alloc?Buffer.from(arrayBuffer):new Buffer(arrayBuffer)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&292)>>2}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsForNode:(function(flags){flags&=~2097152;flags&=~2048;flags&=~32768;flags&=~524288;var newFlags=0;for(var k in NODEFS.flagsForNodeMap){if(flags&k){newFlags|=NODEFS.flagsForNodeMap[k];flags^=k}}if(!flags){return newFlags}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsForNode(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;try{return fs.readSync(stream.nfd,NODEFS.bufferFrom(buffer.buffer),offset,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),write:(function(stream,buffer,offset,length,position){try{return fs.writeSync(stream.nfd,NODEFS.bufferFrom(buffer.buffer),offset,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,parts[i],WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};STATICTOP+=16;STATICTOP+=16;STATICTOP+=16;var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){console.log("warning: "+FS.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work")}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(err){assert(FS.syncFSRequests>0);FS.syncFSRequests--;return callback(err)}function done(err){if(err){if(!done.errored){done.errored=true;return doCallback(err)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdirTree:(function(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=ERRNO_CODES.EEXIST)throw e}}}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;err("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}stream.fd=null}),isClosed:(function(stream){return stream.fd===null}),llseek:(function(stream,offset,whence){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";var stream=FS.open(path,opts.flags,opts.mode);if(typeof data==="string"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,undefined,opts.canOwn)}else if(ArrayBuffer.isView(data)){FS.write(stream,data,0,data.byteLength,undefined,opts.canOwn)}else{throw new Error("Unsupported data type")}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto")["randomBytes"](1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno];if(this.stack)Object.defineProperty(this,"stack",{value:(new Error).stack,writable:true})};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;console.log("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})},chunkSize:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:(function(){return this.contents.length})}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);var len=Math.min(bufsize,lengthBytesUTF8(ret));var endChar=HEAP8[buf+len];stringToUTF8(ret,buf,bufsize+1);HEAP8[buf+len]=endChar;return len}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall10(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall118(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall15(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();FS.chmod(path,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall183(which,varargs){SYSCALLS.varargs=varargs;try{var buf=SYSCALLS.get(),size=SYSCALLS.get();if(size===0)return-ERRNO_CODES.EINVAL;var cwd=FS.cwd();var cwdLengthInBytes=lengthBytesUTF8(cwd);if(size<cwdLengthInBytes+1)return-ERRNO_CODES.ERANGE;stringToUTF8(cwd,buf,size);return buf}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall192(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get(),prot=SYSCALLS.get(),flags=SYSCALLS.get(),fd=SYSCALLS.get(),off=SYSCALLS.get();off<<=12;var ptr;var allocated=false;if(fd===-1){ptr=_memalign(PAGE_SIZE,len);if(!ptr)return-ERRNO_CODES.ENOMEM;_memset(ptr,0,len);allocated=true}else{var info=FS.getStream(fd);if(!info)return-ERRNO_CODES.EBADF;var res=FS.mmap(info,HEAPU8,addr,len,off,prot,flags);ptr=res.ptr;allocated=res.allocated}SYSCALLS.mappings[ptr]={malloc:ptr,len:len,allocated:allocated,fd:fd,flags:flags};return ptr}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall194(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),zero=SYSCALLS.getZero(),length=SYSCALLS.get64();FS.ftruncate(fd,length);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall196(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.lstat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall197(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var PROCINFO={ppid:1,pid:42,sid:42,pgid:42};function ___syscall20(which,varargs){SYSCALLS.varargs=varargs;try{return PROCINFO.pid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall202(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall201(){return ___syscall202.apply(null,arguments)}function ___syscall207(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),owner=SYSCALLS.get(),group=SYSCALLS.get();FS.fchown(fd,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall212(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),owner=SYSCALLS.get(),group=SYSCALLS.get();FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall3(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.read(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall33(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),amode=SYSCALLS.get();return SYSCALLS.doAccess(path,amode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall39(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall4(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.write(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall40(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.rmdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21509:case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21510:case 21511:case 21512:case 21506:case 21507:case 21508:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};case 21523:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21524:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall85(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get(),bufsize=SYSCALLS.get();return SYSCALLS.doReadlink(path,buf,bufsize)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall91(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);SYSCALLS.doMsync(addr,stream,len,info.flags);FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall94(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),mode=SYSCALLS.get();FS.fchmod(fd,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___unlock(){}function _abort(){Module["abort"]()}function _clock(){if(_clock.start===undefined)_clock.start=Date.now();return(Date.now()-_clock.start)*(1e6/1e3)|0}function _decrypt(bufIn,sizeIn,bufOut,sizeOut){var handler=null;if(handler&&Module._mataiDerivedKey){var iv=Module.HEAPU8.subarray(bufIn,bufIn+16);var input=Module.HEAPU8.subarray(bufIn+16,bufIn+sizeIn);var decrypted=handler.decrypt(Module._mataiDerivedKey,iv,input);if(decrypted&&decrypted.length!==0&&decrypted.length<=sizeOut){Module.HEAPU8.set(decrypted,bufOut);return decrypted.length}}return 0}function _derive_key(salt,password){var handler=null;if(handler){var saltArray=Module.HEAPU8.subarray(salt,salt+16);var passwordArray=Module.HEAPU8.subarray(password,password+Module._strlen(password));Module._mataiDerivedKey=handler.deriveKey(saltArray,passwordArray);return!!Module._mataiDerivedKey}return false}var DLFCN={error:null,errorMsg:null,loadedLibs:{},loadedLibNames:{}};function _dlclose(handle){if(!DLFCN.loadedLibs[handle]){DLFCN.errorMsg="Tried to dlclose() unopened handle: "+handle;return 1}else{var lib_record=DLFCN.loadedLibs[handle];if(--lib_record.refcount==0){if(lib_record.module.cleanups){lib_record.module.cleanups.forEach((function(cleanup){cleanup()}))}delete DLFCN.loadedLibNames[lib_record.name];delete DLFCN.loadedLibs[handle]}return 0}}function _dlerror(){if(DLFCN.errorMsg===null){return 0}else{if(DLFCN.error)_free(DLFCN.error);var msgArr=intArrayFromString(DLFCN.errorMsg);DLFCN.error=allocate(msgArr,"i8",ALLOC_NORMAL);DLFCN.errorMsg=null;return DLFCN.error}}function _dlopen(filenameAddr,flag){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/kripken/emscripten/wiki/Linking");var searchpaths=[];var filename;if(filenameAddr===0){filename="__self__"}else{filename=Pointer_stringify(filenameAddr);var isValidFile=(function(filename){var target=FS.findObject(filename);return target&&!target.isFolder&&!target.isDevice});if(!isValidFile(filename)){if(ENV["LD_LIBRARY_PATH"]){searchpaths=ENV["LD_LIBRARY_PATH"].split(":")}for(var ident in searchpaths){var searchfile=PATH.join2(searchpaths[ident],filename);if(isValidFile(searchfile)){filename=searchfile;break}}}}if(DLFCN.loadedLibNames[filename]){var handle=DLFCN.loadedLibNames[filename];DLFCN.loadedLibs[handle].refcount++;return handle}var lib_module;if(filename==="__self__"){var handle=-1;lib_module=Module}else{if(Module["preloadedWasm"]!==undefined&&Module["preloadedWasm"][filename]!==undefined){lib_module=Module["preloadedWasm"][filename]}else{var target=FS.findObject(filename);if(!target||target.isFolder||target.isDevice){DLFCN.errorMsg="Could not find dynamic lib: "+filename;return 0}FS.forceLoadFile(target);try{var lib_data=FS.readFile(filename,{encoding:"utf8"});lib_module=eval(lib_data)(alignFunctionTables(),Module)}catch(e){DLFCN.errorMsg="Could not evaluate dynamic lib: "+filename+"\n"+e;return 0}}var handle=1;for(var key in DLFCN.loadedLibs){if(DLFCN.loadedLibs.hasOwnProperty(key))handle++}if(flag&256){for(var ident in lib_module){if(lib_module.hasOwnProperty(ident)){if(ident[0]=="_"){Module[ident]=lib_module[ident]}}}}}DLFCN.loadedLibs[handle]={refcount:1,name:filename,module:lib_module};DLFCN.loadedLibNames[filename]=handle;return handle}function _dlsym(handle,symbol){symbol=Pointer_stringify(symbol);if(!DLFCN.loadedLibs[handle]){DLFCN.errorMsg="Tried to dlsym() from an unopened handle: "+handle;return 0}else{var lib=DLFCN.loadedLibs[handle];symbol="_"+symbol;if(!lib.module.hasOwnProperty(symbol)){DLFCN.errorMsg='Tried to lookup unknown symbol "'+symbol+'" in dynamic lib: '+lib.name;return 0}else{var result=lib.module[symbol];if(typeof result==="function"){return addFunction(result)}return result}}}function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocateUTF8(ENV[name]);return _getenv.ret}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _is_decryption_handler_installed(){return false}function _jsStringify(str){var resStr=JSON.stringify(Pointer_stringify(str));var len=lengthBytesUTF8(resStr)+1;var buf=Module._malloc(len);var len2=stringToUTF8(resStr,buf,len);return buf}var _llvm_ceil_f32=Math_ceil;var _llvm_fabs_f32=Math_abs;var _llvm_fabs_f64=Math_abs;function _llvm_log10_f32(x){return Math.log(x)/Math.LN10}function _llvm_log10_f64(){return _llvm_log10_f32.apply(null,arguments)}function _llvm_stackrestore(p){var self=_llvm_stacksave;var ret=self.LLVM_SAVEDSTACKS[p];self.LLVM_SAVEDSTACKS.splice(p,1);stackRestore(ret)}function _llvm_stacksave(){var self=_llvm_stacksave;if(!self.LLVM_SAVEDSTACKS){self.LLVM_SAVEDSTACKS=[]}self.LLVM_SAVEDSTACKS.push(stackSave());return self.LLVM_SAVEDSTACKS.length-1}function _llvm_trap(){abort("trap!")}var ___tm_current=STATICTOP;STATICTOP+=48;var ___tm_timezone=allocate(intArrayFromString("GMT"),"i8",ALLOC_STATIC);function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[__get_timezone()>>2]=(new Date).getTimezoneOffset()*60;var winter=new Date(2e3,0,1);var summer=new Date(2e3,6,1);HEAP32[__get_daylight()>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());function extractZone(date){var match=date.toTimeString().match(/\(([A-Za-z ]+)\)$/);return match?match[1]:"GMT"}var winterName=extractZone(winter);var summerName=extractZone(summer);var winterNamePtr=allocate(intArrayFromString(winterName),"i8",ALLOC_NORMAL);var summerNamePtr=allocate(intArrayFromString(summerName),"i8",ALLOC_NORMAL);if(summer.getTimezoneOffset()<winter.getTimezoneOffset()){HEAP32[__get_tzname()>>2]=winterNamePtr;HEAP32[__get_tzname()+4>>2]=summerNamePtr}else{HEAP32[__get_tzname()>>2]=summerNamePtr;HEAP32[__get_tzname()+4>>2]=winterNamePtr}}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var summerOffset=(new Date(2e3,6,1)).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=(summerOffset!=winterOffset&&date.getTimezoneOffset()==Math.min(winterOffset,summerOffset))|0;HEAP32[tmPtr+32>>2]=dst;var zonePtr=HEAP32[__get_tzname()+(dst?4:0)>>2];HEAP32[tmPtr+40>>2]=zonePtr;return tmPtr}function _localtime(time){return _localtime_r(time,___tm_current)}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}function _usleep(useconds){var msec=useconds/1e3;if((ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]){var start=self["performance"]["now"]();while(self["performance"]["now"]()-start<msec){}}else{var start=Date.now();while(Date.now()-start<msec){}}return 0}Module["_usleep"]=_usleep;function _nanosleep(rqtp,rmtp){var seconds=HEAP32[rqtp>>2];var nanoseconds=HEAP32[rqtp+4>>2];if(rmtp!==0){HEAP32[rmtp>>2]=0;HEAP32[rmtp+4>>2]=0}return _usleep(seconds*1e6+nanoseconds/1e3)}function _pthread_cond_wait(){return 0}function _pthread_create(){return 11}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _pthread_join(){}var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _pthread_mutex_destroy(){}function _pthread_mutex_init(){}function _pthread_mutexattr_destroy(){}function _pthread_mutexattr_init(){}function _pthread_mutexattr_settype(){}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Module["dynCall_v"](func);_pthread_once.seen[ptr]=1}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){var twelveHour=date.tm_hour;if(twelveHour==0)twelveHour=12;else if(twelveHour>12)twelveHour-=12;return leadingNulls(twelveHour,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>=0&&date.tm_hour<12){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:var maxHeapSize=2*1024*1024*1024-16777216;return maxHeapSize/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _utimes(path,times){var time;if(times){var offset=8+0;time=HEAP32[times+offset>>2]*1e3;offset=8+4;time+=HEAP32[times+offset>>2]/1e3}else{time=Date.now()}path=Pointer_stringify(path);try{FS.utime(path,time,time);return 0}catch(e){FS.handleFSError(e);return-1}}SB.init();if(ENVIRONMENT_IS_NODE){_emscripten_get_now=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now=dateNow}else if(typeof self==="object"&&self["performance"]&&typeof self["performance"]["now"]==="function"){_emscripten_get_now=(function(){return self["performance"]["now"]()})}else if(typeof performance==="object"&&typeof performance["now"]==="function"){_emscripten_get_now=(function(){return performance["now"]()})}else{_emscripten_get_now=Date.now}FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}DYNAMICTOP_PTR=staticAlloc(4);STACK_BASE=STACKTOP=alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}var decodeBase64=typeof atob==="function"?atob:(function(input){var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output});function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}function invoke_di(index,a1){var sp=stackSave();try{return Module["dynCall_di"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_dii(index,a1,a2){var sp=stackSave();try{return Module["dynCall_dii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_i(index){var sp=stackSave();try{return Module["dynCall_i"](index)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_ii(index,a1){var sp=stackSave();try{return Module["dynCall_ii"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iii(index,a1,a2){var sp=stackSave();try{return Module["dynCall_iii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiidii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){var sp=stackSave();try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiid(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){var sp=stackSave();try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){var sp=stackSave();try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){var sp=stackSave();try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){var sp=stackSave();try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_v(index){var sp=stackSave();try{Module["dynCall_v"](index)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vi(index,a1){var sp=stackSave();try{Module["dynCall_vi"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vid(index,a1,a2){var sp=stackSave();try{Module["dynCall_vid"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vii(index,a1,a2){var sp=stackSave();try{Module["dynCall_vii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){var sp=stackSave();try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiidi(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiidi"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){var sp=stackSave();try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"byteLength":byteLength};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"invoke_di":invoke_di,"invoke_dii":invoke_dii,"invoke_i":invoke_i,"invoke_ii":invoke_ii,"invoke_iii":invoke_iii,"invoke_iiid":invoke_iiid,"invoke_iiii":invoke_iiii,"invoke_iiiidii":invoke_iiiidii,"invoke_iiiii":invoke_iiiii,"invoke_iiiiid":invoke_iiiiid,"invoke_iiiiii":invoke_iiiiii,"invoke_iiiiiid":invoke_iiiiiid,"invoke_iiiiiii":invoke_iiiiiii,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_iiiiiiiii":invoke_iiiiiiiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_v":invoke_v,"invoke_vi":invoke_vi,"invoke_vid":invoke_vid,"invoke_vii":invoke_vii,"invoke_viii":invoke_viii,"invoke_viiidi":invoke_viiidi,"invoke_viiii":invoke_viiii,"invoke_viiiid":invoke_viiiid,"invoke_viiiii":invoke_viiiii,"invoke_viiiiii":invoke_viiiiii,"_SceneBuilderAdapter_beginParametricTextContent":_SceneBuilderAdapter_beginParametricTextContent,"_SceneBuilderAdapter_clearFillStyle":_SceneBuilderAdapter_clearFillStyle,"_SceneBuilderAdapter_clearLineStyle":_SceneBuilderAdapter_clearLineStyle,"_SceneBuilderAdapter_createCamera":_SceneBuilderAdapter_createCamera,"_SceneBuilderAdapter_createDefaultMaterial":_SceneBuilderAdapter_createDefaultMaterial,"_SceneBuilderAdapter_createDetailView":_SceneBuilderAdapter_createDetailView,"_SceneBuilderAdapter_createImage":_SceneBuilderAdapter_createImage,"_SceneBuilderAdapter_createImageNote":_SceneBuilderAdapter_createImageNote,"_SceneBuilderAdapter_createMaterial":_SceneBuilderAdapter_createMaterial,"_SceneBuilderAdapter_createMesh":_SceneBuilderAdapter_createMesh,"_SceneBuilderAdapter_createNode":_SceneBuilderAdapter_createNode,"_SceneBuilderAdapter_createTextAnnotation":_SceneBuilderAdapter_createTextAnnotation,"_SceneBuilderAdapter_createTextNote":_SceneBuilderAdapter_createTextNote,"_SceneBuilderAdapter_createThumbnail":_SceneBuilderAdapter_createThumbnail,"_SceneBuilderAdapter_createViewportGroup":_SceneBuilderAdapter_createViewportGroup,"_SceneBuilderAdapter_endParametricTextContent":_SceneBuilderAdapter_endParametricTextContent,"_SceneBuilderAdapter_finalizeAnimation":_SceneBuilderAdapter_finalizeAnimation,"_SceneBuilderAdapter_finalizePlaybacks":_SceneBuilderAdapter_finalizePlaybacks,"_SceneBuilderAdapter_insertAnimation":_SceneBuilderAdapter_insertAnimation,"_SceneBuilderAdapter_insertAnimationGroup":_SceneBuilderAdapter_insertAnimationGroup,"_SceneBuilderAdapter_insertAnimationTarget":_SceneBuilderAdapter_insertAnimationTarget,"_SceneBuilderAdapter_insertAnimationTrack":_SceneBuilderAdapter_insertAnimationTrack,"_SceneBuilderAdapter_insertArcPathSegment":_SceneBuilderAdapter_insertArcPathSegment,"_SceneBuilderAdapter_insertBezierPathSegment":_SceneBuilderAdapter_insertBezierPathSegment,"_SceneBuilderAdapter_insertCamera":_SceneBuilderAdapter_insertCamera,"_SceneBuilderAdapter_insertClosePathSegment":_SceneBuilderAdapter_insertClosePathSegment,"_SceneBuilderAdapter_insertLeaderLine":_SceneBuilderAdapter_insertLeaderLine,"_SceneBuilderAdapter_insertLinePathSegment":_SceneBuilderAdapter_insertLinePathSegment,"_SceneBuilderAdapter_insertMesh":_SceneBuilderAdapter_insertMesh,"_SceneBuilderAdapter_insertModelView":_SceneBuilderAdapter_insertModelView,"_SceneBuilderAdapter_insertModelViewHighlight":_SceneBuilderAdapter_insertModelViewHighlight,"_SceneBuilderAdapter_insertMovePathSegment":_SceneBuilderAdapter_insertMovePathSegment,"_SceneBuilderAdapter_insertParametricArc":_SceneBuilderAdapter_insertParametricArc,"_SceneBuilderAdapter_insertParametricEllipse":_SceneBuilderAdapter_insertParametricEllipse,"_SceneBuilderAdapter_insertParametricPath":_SceneBuilderAdapter_insertParametricPath,"_SceneBuilderAdapter_insertParametricPolyline":_SceneBuilderAdapter_insertParametricPolyline,"_SceneBuilderAdapter_insertParametricRectangle":_SceneBuilderAdapter_insertParametricRectangle,"_SceneBuilderAdapter_insertParametricText":_SceneBuilderAdapter_insertParametricText,"_SceneBuilderAdapter_insertParametricTextData":_SceneBuilderAdapter_insertParametricTextData,"_SceneBuilderAdapter_insertThrustline":_SceneBuilderAdapter_insertThrustline,"_SceneBuilderAdapter_progress":_SceneBuilderAdapter_progress,"_SceneBuilderAdapter_setFillStyle":_SceneBuilderAdapter_setFillStyle,"_SceneBuilderAdapter_setLineStyle":_SceneBuilderAdapter_setLineStyle,"_SceneBuilderAdapter_setMeshGeometry":_SceneBuilderAdapter_setMeshGeometry,"_SceneBuilderAdapter_setModelViewVisibility":_SceneBuilderAdapter_setModelViewVisibility,"_SceneBuilderAdapter_setParametricContent":_SceneBuilderAdapter_setParametricContent,"_SceneBuilderAdapter_setScene":_SceneBuilderAdapter_setScene,"___buildEnvironment":___buildEnvironment,"___clock_gettime":___clock_gettime,"___cxa_allocate_exception":___cxa_allocate_exception,"___cxa_begin_catch":___cxa_begin_catch,"___cxa_end_catch":___cxa_end_catch,"___cxa_find_matching_catch":___cxa_find_matching_catch,"___cxa_free_exception":___cxa_free_exception,"___cxa_pure_virtual":___cxa_pure_virtual,"___cxa_rethrow":___cxa_rethrow,"___cxa_throw":___cxa_throw,"___cxa_uncaught_exception":___cxa_uncaught_exception,"___gxx_personality_v0":___gxx_personality_v0,"___lock":___lock,"___map_file":___map_file,"___resumeException":___resumeException,"___setErrNo":___setErrNo,"___syscall10":___syscall10,"___syscall118":___syscall118,"___syscall140":___syscall140,"___syscall145":___syscall145,"___syscall146":___syscall146,"___syscall15":___syscall15,"___syscall183":___syscall183,"___syscall192":___syscall192,"___syscall194":___syscall194,"___syscall195":___syscall195,"___syscall196":___syscall196,"___syscall197":___syscall197,"___syscall20":___syscall20,"___syscall201":___syscall201,"___syscall202":___syscall202,"___syscall207":___syscall207,"___syscall212":___syscall212,"___syscall221":___syscall221,"___syscall3":___syscall3,"___syscall33":___syscall33,"___syscall39":___syscall39,"___syscall4":___syscall4,"___syscall40":___syscall40,"___syscall5":___syscall5,"___syscall54":___syscall54,"___syscall6":___syscall6,"___syscall85":___syscall85,"___syscall91":___syscall91,"___syscall94":___syscall94,"___unlock":___unlock,"__addDays":__addDays,"__arraySum":__arraySum,"__isLeapYear":__isLeapYear,"_abort":_abort,"_clock":_clock,"_clock_gettime":_clock_gettime,"_decrypt":_decrypt,"_derive_key":_derive_key,"_dlclose":_dlclose,"_dlerror":_dlerror,"_dlopen":_dlopen,"_dlsym":_dlsym,"_emscripten_asm_const_idi":_emscripten_asm_const_idi,"_emscripten_asm_const_ii":_emscripten_asm_const_ii,"_emscripten_asm_const_iiii":_emscripten_asm_const_iiii,"_emscripten_asm_const_iiiii":_emscripten_asm_const_iiiii,"_emscripten_get_now":_emscripten_get_now,"_emscripten_get_now_is_monotonic":_emscripten_get_now_is_monotonic,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_getenv":_getenv,"_gettimeofday":_gettimeofday,"_is_decryption_handler_installed":_is_decryption_handler_installed,"_jsStringify":_jsStringify,"_llvm_ceil_f32":_llvm_ceil_f32,"_llvm_fabs_f32":_llvm_fabs_f32,"_llvm_fabs_f64":_llvm_fabs_f64,"_llvm_log10_f32":_llvm_log10_f32,"_llvm_log10_f64":_llvm_log10_f64,"_llvm_stackrestore":_llvm_stackrestore,"_llvm_stacksave":_llvm_stacksave,"_llvm_trap":_llvm_trap,"_localtime":_localtime,"_localtime_r":_localtime_r,"_nanosleep":_nanosleep,"_pthread_cond_wait":_pthread_cond_wait,"_pthread_create":_pthread_create,"_pthread_getspecific":_pthread_getspecific,"_pthread_join":_pthread_join,"_pthread_key_create":_pthread_key_create,"_pthread_mutex_destroy":_pthread_mutex_destroy,"_pthread_mutex_init":_pthread_mutex_init,"_pthread_mutexattr_destroy":_pthread_mutexattr_destroy,"_pthread_mutexattr_init":_pthread_mutexattr_init,"_pthread_mutexattr_settype":_pthread_mutexattr_settype,"_pthread_once":_pthread_once,"_pthread_setspecific":_pthread_setspecific,"_strftime":_strftime,"_strftime_l":_strftime_l,"_sysconf":_sysconf,"_time":_time,"_tzset":_tzset,"_usleep":_usleep,"_utimes":_utimes,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX};// EMSCRIPTEN_START_ASM
var asm=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"almost asm";var a=global.Int8Array;var b=new a(buffer);var c=global.Int16Array;var d=new c(buffer);var e=global.Int32Array;var f=new e(buffer);var g=global.Uint8Array;var h=new g(buffer);var i=global.Uint16Array;var j=new i(buffer);var k=global.Uint32Array;var l=new k(buffer);var m=global.Float32Array;var n=new m(buffer);var o=global.Float64Array;var p=new o(buffer);var q=global.byteLength;var r=env.DYNAMICTOP_PTR|0;var s=env.tempDoublePtr|0;var t=env.STACKTOP|0;var u=env.STACK_MAX|0;var v=0;var w=0;var x=0;var y=0;var z=global.NaN,A=global.Infinity;var B=0,C=0,D=0,E=0,F=0.0;var G=0;var H=global.Math.floor;var I=global.Math.abs;var J=global.Math.sqrt;var K=global.Math.pow;var L=global.Math.cos;var M=global.Math.sin;var N=global.Math.tan;var O=global.Math.acos;var P=global.Math.asin;var Q=global.Math.atan;var R=global.Math.atan2;var S=global.Math.exp;var T=global.Math.log;var U=global.Math.ceil;var V=global.Math.imul;var W=global.Math.min;var X=global.Math.max;var Y=global.Math.clz32;var Z=env.abort;var _=env.assert;var $=env.enlargeMemory;var aa=env.getTotalMemory;var ba=env.abortOnCannotGrowMemory;var ca=env.invoke_di;var da=env.invoke_dii;var ea=env.invoke_i;var fa=env.invoke_ii;var ga=env.invoke_iii;var ha=env.invoke_iiid;var ia=env.invoke_iiii;var ja=env.invoke_iiiidii;var ka=env.invoke_iiiii;var la=env.invoke_iiiiid;var ma=env.invoke_iiiiii;var na=env.invoke_iiiiiid;var oa=env.invoke_iiiiiii;var pa=env.invoke_iiiiiiii;var qa=env.invoke_iiiiiiiii;var ra=env.invoke_iiiiiiiiii;var sa=env.invoke_iiiiiiiiiii;var ta=env.invoke_v;var ua=env.invoke_vi;var va=env.invoke_vid;var wa=env.invoke_vii;var xa=env.invoke_viii;var ya=env.invoke_viiidi;var za=env.invoke_viiii;var Aa=env.invoke_viiiid;var Ba=env.invoke_viiiii;var Ca=env.invoke_viiiiii;var Da=env._SceneBuilderAdapter_beginParametricTextContent;var Ea=env._SceneBuilderAdapter_clearFillStyle;var Fa=env._SceneBuilderAdapter_clearLineStyle;var Ga=env._SceneBuilderAdapter_createCamera;var Ha=env._SceneBuilderAdapter_createDefaultMaterial;var Ia=env._SceneBuilderAdapter_createDetailView;var Ja=env._SceneBuilderAdapter_createImage;var Ka=env._SceneBuilderAdapter_createImageNote;var La=env._SceneBuilderAdapter_createMaterial;var Ma=env._SceneBuilderAdapter_createMesh;var Na=env._SceneBuilderAdapter_createNode;var Oa=env._SceneBuilderAdapter_createTextAnnotation;var Pa=env._SceneBuilderAdapter_createTextNote;var Qa=env._SceneBuilderAdapter_createThumbnail;var Ra=env._SceneBuilderAdapter_createViewportGroup;var Sa=env._SceneBuilderAdapter_endParametricTextContent;var Ta=env._SceneBuilderAdapter_finalizeAnimation;var Ua=env._SceneBuilderAdapter_finalizePlaybacks;var Va=env._SceneBuilderAdapter_insertAnimation;var Wa=env._SceneBuilderAdapter_insertAnimationGroup;var Xa=env._SceneBuilderAdapter_insertAnimationTarget;var Ya=env._SceneBuilderAdapter_insertAnimationTrack;var Za=env._SceneBuilderAdapter_insertArcPathSegment;var _a=env._SceneBuilderAdapter_insertBezierPathSegment;var $a=env._SceneBuilderAdapter_insertCamera;var ab=env._SceneBuilderAdapter_insertClosePathSegment;var bb=env._SceneBuilderAdapter_insertLeaderLine;var cb=env._SceneBuilderAdapter_insertLinePathSegment;var db=env._SceneBuilderAdapter_insertMesh;var eb=env._SceneBuilderAdapter_insertModelView;var fb=env._SceneBuilderAdapter_insertModelViewHighlight;var gb=env._SceneBuilderAdapter_insertMovePathSegment;var hb=env._SceneBuilderAdapter_insertParametricArc;var ib=env._SceneBuilderAdapter_insertParametricEllipse;var jb=env._SceneBuilderAdapter_insertParametricPath;var kb=env._SceneBuilderAdapter_insertParametricPolyline;var lb=env._SceneBuilderAdapter_insertParametricRectangle;var mb=env._SceneBuilderAdapter_insertParametricText;var nb=env._SceneBuilderAdapter_insertParametricTextData;var ob=env._SceneBuilderAdapter_insertThrustline;var pb=env._SceneBuilderAdapter_progress;var qb=env._SceneBuilderAdapter_setFillStyle;var rb=env._SceneBuilderAdapter_setLineStyle;var sb=env._SceneBuilderAdapter_setMeshGeometry;var tb=env._SceneBuilderAdapter_setModelViewVisibility;var ub=env._SceneBuilderAdapter_setParametricContent;var vb=env._SceneBuilderAdapter_setScene;var wb=env.___buildEnvironment;var xb=env.___clock_gettime;var yb=env.___cxa_allocate_exception;var zb=env.___cxa_begin_catch;var Ab=env.___cxa_end_catch;var Bb=env.___cxa_find_matching_catch;var Cb=env.___cxa_free_exception;var Db=env.___cxa_pure_virtual;var Eb=env.___cxa_rethrow;var Fb=env.___cxa_throw;var Gb=env.___cxa_uncaught_exception;var Hb=env.___gxx_personality_v0;var Ib=env.___lock;var Jb=env.___map_file;var Kb=env.___resumeException;var Lb=env.___setErrNo;var Mb=env.___syscall10;var Nb=env.___syscall118;var Ob=env.___syscall140;var Pb=env.___syscall145;var Qb=env.___syscall146;var Rb=env.___syscall15;var Sb=env.___syscall183;var Tb=env.___syscall192;var Ub=env.___syscall194;var Vb=env.___syscall195;var Wb=env.___syscall196;var Xb=env.___syscall197;var Yb=env.___syscall20;var Zb=env.___syscall201;var _b=env.___syscall202;var $b=env.___syscall207;var ac=env.___syscall212;var bc=env.___syscall221;var cc=env.___syscall3;var dc=env.___syscall33;var ec=env.___syscall39;var fc=env.___syscall4;var gc=env.___syscall40;var hc=env.___syscall5;var ic=env.___syscall54;var jc=env.___syscall6;var kc=env.___syscall85;var lc=env.___syscall91;var mc=env.___syscall94;var nc=env.___unlock;var oc=env.__addDays;var pc=env.__arraySum;var qc=env.__isLeapYear;var rc=env._abort;var sc=env._clock;var tc=env._clock_gettime;var uc=env._decrypt;var vc=env._derive_key;var wc=env._dlclose;var xc=env._dlerror;var yc=env._dlopen;var zc=env._dlsym;var Ac=env._emscripten_asm_const_idi;var Bc=env._emscripten_asm_const_ii;var Cc=env._emscripten_asm_const_iiii;var Dc=env._emscripten_asm_const_iiiii;var Ec=env._emscripten_get_now;var Fc=env._emscripten_get_now_is_monotonic;var Gc=env._emscripten_memcpy_big;var Hc=env._getenv;var Ic=env._gettimeofday;var Jc=env._is_decryption_handler_installed;var Kc=env._jsStringify;var Lc=env._llvm_ceil_f32;var Mc=env._llvm_fabs_f32;var Nc=env._llvm_fabs_f64;var Oc=env._llvm_log10_f32;var Pc=env._llvm_log10_f64;var Qc=env._llvm_stackrestore;var Rc=env._llvm_stacksave;var Sc=env._llvm_trap;var Tc=env._localtime;var Uc=env._localtime_r;var Vc=env._nanosleep;var Wc=env._pthread_cond_wait;var Xc=env._pthread_create;var Yc=env._pthread_getspecific;var Zc=env._pthread_join;var _c=env._pthread_key_create;var $c=env._pthread_mutex_destroy;var ad=env._pthread_mutex_init;var bd=env._pthread_mutexattr_destroy;var cd=env._pthread_mutexattr_init;var dd=env._pthread_mutexattr_settype;var ed=env._pthread_once;var fd=env._pthread_setspecific;var gd=env._strftime;var hd=env._strftime_l;var id=env._sysconf;var jd=env._time;var kd=env._tzset;var ld=env._usleep;var md=env._utimes;var nd=0.0;function od(newBuffer){if(q(newBuffer)&16777215||q(newBuffer)<=16777215||q(newBuffer)>2147483648)return false;b=new a(newBuffer);d=new c(newBuffer);f=new e(newBuffer);h=new g(newBuffer);j=new i(newBuffer);l=new k(newBuffer);n=new m(newBuffer);p=new o(newBuffer);buffer=newBuffer;return true}
// EMSCRIPTEN_START_FUNCS
function DRc(a,b){a=a|0;b=b|0;if(XQc(b)|0)return b|0;if((h[a+200>>0]|0)>1)ERc(a,b);dzc(f[a>>2]|0,b);b=xQc(f[a>>2]|0,120,0,0)|0;return b|0}function ERc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;d=t;t=t+32|0;h=d;e=a+200|0;g=b[e>>0]|0;i=h+12|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[h>>2]=a;f[h+4>>2]=677;f[h+8>>2]=678;b[e>>0]=3;HRc(h,c)|0;b[e>>0]=g;t=d;return}function FRc(a,b){a=a|0;b=b|0;ORc(f[a>>2]|0,0,b);return 0}function GRc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=f[a>>2]|0;if(f[h+36>>2]|0){h=2;return h|0}if(f[c+4>>2]&2097152|0){h=1;return h|0}e=f[c+28>>2]|0;a:do if(e|0){d=0;while(1){if((d|0)>=(f[e>>2]|0))break a;g=f[e+4+(d<<4)+4>>2]|0;if(g|0?(b[e+4+(d<<4)+9>>0]&3)==0:0)ORc(h,0,g);d=d+1|0}}while(0);e=f[c+32>>2]|0;b:do if(e|0){d=0;while(1){if((d|0)>=(f[e>>2]|0))break b;ORc(h,0,f[e+8+(d*72|0)+8>>2]|0);if(HRc(a,f[e+8+(d*72|0)+44>>2]|0)|0){d=2;break}PRc(h,f[e+8+(d*72|0)+48>>2]|0);d=d+1|0}return d|0}while(0);QRc(a,c);h=0;return h|0}function HRc(a,b){a=a|0;b=b|0;if(!b)a=0;else a=IRc(a,b)|0;return a|0}function IRc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;e=b;while(1){b=td[f[c>>2]&1023](a,e)|0;if(b|0){d=3;break}if(f[e+4>>2]&8404992|0)break;b=f[e+12>>2]|0;if(b|0?IRc(a,b)|0:0){b=2;d=16;break}b=f[e+16>>2]|0;if(!b){d=8;break}else e=b}do if((d|0)==3){a=b&2;return a|0}else if((d|0)==8){c=e+4|0;b=f[c>>2]|0;if(b&2048|0){if(!(JRc(a,f[e+20>>2]|0)|0))break;else b=2;return b|0}d=f[e+20>>2]|0;do if(d)if(!(KRc(a,d)|0)){b=f[c>>2]|0;break}else{a=2;return a|0}while(0);if(b&16777216|0?LRc(a,f[e+44>>2]|0,1)|0:0){a=2;return a|0}}else if((d|0)==16)return b|0;while(0);a=0;return a|0}function JRc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;if(!b){g=0;return g|0}e=a+8|0;c=f[e>>2]|0;if(!c){g=0;return g|0}g=a+12|0;while(1){d=td[c&1023](a,b)|0;if(d|0){c=5;break}if(MRc(a,b)|0){b=2;c=12;break}if(NRc(a,b)|0){b=2;c=12;break}c=f[g>>2]|0;if(c|0)Jd[c&1023](a,b);b=f[b+52>>2]|0;if(!b){b=0;c=12;break}c=f[e>>2]|0}if((c|0)==5){g=d&2;return g|0}else if((c|0)==12)return b|0;return 0}function KRc(a,b){a=a|0;b=b|0;var c=0;if(!b){a=0;return a|0}c=b+4|0;b=f[b>>2]|0;while(1){if((b|0)<=0){b=0;c=6;break}if(HRc(a,f[c>>2]|0)|0){b=2;c=6;break}c=c+16|0;b=b+-1|0}if((c|0)==6)return b|0;return 0}function LRc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;while(1){if(!b){b=0;a=10;break}if(KRc(a,f[b+12>>2]|0)|0){b=2;a=10;break}if(KRc(a,f[b+8>>2]|0)|0){b=2;a=10;break}if(HRc(a,f[b+40>>2]|0)|0){b=2;a=10;break}if(HRc(a,f[b+24>>2]|0)|0){b=2;a=10;break}d=HRc(a,f[b+28>>2]|0)|0;if(d|c|0){a=9;break}b=f[b+36>>2]|0}if((a|0)==9){d=(d|0)==0?0:2;return d|0}else if((a|0)==10)return b|0;return 0}function MRc(a,b){a=a|0;b=b|0;var c=0;if(KRc(a,f[b+28>>2]|0)|0){c=2;return c|0}if(HRc(a,f[b+36>>2]|0)|0){c=2;return c|0}if(KRc(a,f[b+40>>2]|0)|0){c=2;return c|0}if(HRc(a,f[b+44>>2]|0)|0){c=2;return c|0}if(KRc(a,f[b+48>>2]|0)|0){c=2;return c|0}if(HRc(a,f[b+60>>2]|0)|0){c=2;return c|0}c=f[a>>2]|0;if(!c){c=0;return c|0}if((h[c+200>>0]|0)<=1){c=0;return c|0}c=LRc(a,f[b+72>>2]|0,0)|0;return c|0}function NRc(a,c){a=a|0;c=c|0;var d=0,e=0;c=f[c+32>>2]|0;if(!c){a=0;return a|0}e=c+8|0;c=f[c>>2]|0;while(1){if((c|0)<=0){c=0;d=9;break}d=f[e+20>>2]|0;if(d|0?JRc(a,d)|0:0){c=2;d=9;break}if(b[e+37>>0]&4?KRc(a,f[e+64>>2]|0)|0:0){c=2;d=9;break}e=e+72|0;c=c+-1|0}if((d|0)==9)return c|0;return 0}function ORc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;a=a+268|0;while(1){a=f[a>>2]|0;if(!a){d=5;break}if((f[a>>2]|0)==(c|0))break;else a=a+12|0}if((d|0)==5)return;f[a>>2]=b;return}function PRc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!b)return;d=b+4|0;c=0;while(1){if((c|0)>=(f[d>>2]|0))break;ORc(a,0,f[(f[b>>2]|0)+(c<<3)>>2]|0);c=c+1|0}return}function QRc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;g=t;t=t+32|0;e=g;c=f[b+64>>2]|0;if(!c){t=g;return}d=e+4|0;b=0;while(1){if((b|0)>=(f[c>>2]|0))break;h=f[c+8+(b*24|0)+8>>2]|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;f[d+16>>2]=0;f[d+20>>2]=0;f[d+24>>2]=0;i=f[a>>2]|0;f[e>>2]=i;RRc(i,h,e);JRc(a,h)|0;SRc(f[a>>2]|0,f[c+8+(b*24|0)+4>>2]|0);b=b+1|0}t=g;return}function RRc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;if(b[(f[a>>2]|0)+83>>0]|0)return;if(f[c+4>>2]&128|0)return;TRc(a,c);e=a+36|0;if(f[e>>2]|0)return;if(b[(f[a>>2]|0)+83>>0]|0)return;URc(a,c,d);if(f[e>>2]|0)return;if(b[(f[a>>2]|0)+83>>0]|0)return;VRc(a,c);return}function SRc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;e=t;t=t+32|0;d=e;if(!c){t=e;return}g=d+8|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[g+16>>2]=0;f[d>>2]=a;f[d+4>>2]=677;KRc(d,c)|0;d=0;while(1){if((d|0)>=(f[c>>2]|0))break;if(!(b[c+4+(d<<4)+9>>0]&3))ORc(a,0,f[c+4+(d<<4)+4>>2]|0);d=d+1|0}t=e;return}function TRc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;h=t;t=t+32|0;g=h;f[g+4>>2]=679;f[g>>2]=a;e=g+8|0;if(!(b[a+22>>0]|0))a=g+12|0;else{f[e>>2]=680;a=g+12|0;f[a>>2]=0;JRc(g,c)|0}f[e>>2]=681;f[a>>2]=755;d[g+20>>1]=0;JRc(g,c)|0;t=h;return}function URc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+32|0;e=d;f[e+4>>2]=682;f[e+8>>2]=683;f[e+12>>2]=0;f[e>>2]=a;f[e+24>>2]=c;JRc(e,b)|0;t=d;return}function VRc(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+32|0;d=c;f[d+8>>2]=684;f[d+12>>2]=756;f[d+4>>2]=679;f[d>>2]=a;JRc(d,b)|0;t=c;return}function WRc(a,b){a=a|0;b=b|0;return 0}function XRc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;c=b+4|0;d=f[c>>2]|0;if(d&128|0)return;f[c>>2]=d|128;h=f[a>>2]|0;g=f[b+32>>2]|0;c=0;d=g+8|0;while(1){if((c|0)>=(f[g>>2]|0))break;b=f[d+16>>2]|0;if(f[b+36>>2]&16384|0?(i=f[d+20>>2]|0,i|0):0){a=i;while(1){e=f[a+52>>2]|0;if(!e)break;else a=e}ZRc(h,b,a,64)}c=c+1|0;d=d+72|0}return}function YRc(a,b){a=a|0;b=b|0;return 0}function ZRc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;w=t;t=t+32|0;s=w;u=f[a>>2]|0;if(b[u+83>>0]|0){t=w;return};f[s>>2]=0;f[s+4>>2]=0;f[s+8>>2]=0;f[s+12>>2]=0;f[s+16>>2]=0;f[s+20>>2]=0;f[s+24>>2]=0;f[s+28>>2]=0;f[s+4>>2]=f[e+32>>2];p=f[e+28>>2]|0;q=c+42|0;r=c+36|0;n=f[c+4>>2]|0;o=0;while(1){if((o|0)>=(d[q>>1]|0))break;j=n+16|0;f[r>>2]=f[r>>2]|d[j>>1]&98;l=f[p+4+(o<<4)>>2]|0;k=_Rc(s,l)|0;e=$Rc(l)|0;m=n+13|0;b[m>>0]=e;if(k){e=Mxc(k)|0;x=f[n>>2]|0;h=Mxc(x)|0;i=e+2+h|0;i=eyc(u,x,i,((i|0)<0)<<31>>31)|0;f[n>>2]=i;if(i|0){Krd(i+(h+1)|0,k|0,e+1|0)|0;d[j>>1]=d[j>>1]|4}e=b[m>>0]|0}if(e<<24>>24<65)b[m>>0]=g;e=NIc(a,l)|0;if(e|0?(v=n+8|0,(f[v>>2]|0)==0):0){x=UIc(u,f[e>>2]|0)|0;f[v>>2]=x}n=n+20|0;o=o+1|0}d[c+48>>1]=1;t=w;return}function _Rc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+32|0;k=l;switch(b[c>>0]|0){case -90:{j=d[c+32>>1]|0;h=c+28|0;c=0;i=0;a:while(1){b:while(1){g=(c|0)==0;if(!(g&(a|0)!=0))break a;g=f[a+4>>2]|0;c=f[g>>2]|0;e=0;while(1){if((e|0)>=(c|0))break;if((f[g+8+(e*72|0)+40>>2]|0)==(f[h>>2]|0))break b;e=e+1|0}a=f[a+12>>2]|0;c=0}c=f[g+8+(e*72|0)+16>>2]|0;i=f[g+8+(e*72|0)+20>>2]|0}e=j<<16>>16;if(g){k=0;t=l;return k|0}if(!i){if(j<<16>>16<0){k=121602;t=l;return k|0}k=cSc((f[c+4>>2]|0)+(e*20|0)|0,0)|0;t=l;return k|0}if(j<<16>>16<=-1){k=0;t=l;return k|0}c=f[i+28>>2]|0;if((f[c>>2]|0)<=(e|0)){k=0;t=l;return k|0}j=f[c+4+(e<<4)>>2]|0;f[k+4>>2]=f[i+32>>2];f[k+12>>2]=a;f[k>>2]=f[a>>2];k=_Rc(k,j)|0;t=l;return k|0}case -119:{i=f[c+20>>2]|0;j=f[(f[i+28>>2]|0)+4>>2]|0;f[k+4>>2]=f[i+32>>2];f[k+12>>2]=a;f[k>>2]=f[a>>2];k=_Rc(k,j)|0;t=l;return k|0}default:{k=0;t=l;return k|0}}return 0}function $Rc(a){a=a|0;var c=0,e=0,g=0;a:while(1){b:do if(!(f[a+4>>2]&135168)){c=b[a>>0]|0;if(c<<24>>24==-119){a=(f[(f[a+20>>2]|0)+28>>2]|0)+4|0;break}if(c<<24>>24==-81)c=h[a+2>>0]|0;else c=c&255;switch((c&255)<<24>>24){case 36:{g=10;break a}case -90:case -88:{g=11;break a}case -79:{a=(f[(f[(f[a+12>>2]|0)+20>>2]|0)+28>>2]|0)+4+(d[a+32>>1]<<4)|0;break b}case -80:{a=(f[a+20>>2]|0)+4|0;break b}default:break a}}else a=a+12|0;while(0);a=f[a>>2]|0}if((g|0)==10){g=aSc(f[a+8>>2]|0,0)|0;return g|0}if((g|0)==11?(e=f[a+44>>2]|0,e|0):0){g=bSc(e,d[a+32>>1]|0)|0;return g|0}g=b[a+1>>0]|0;return g|0}function aSc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;j=l;d=0;g=0;i=67;while(1){e=b[a>>0]|0;if(!(e<<24>>24)){e=i;break}g=g<<8|h[1680+(e&255)>>0];a=a+1|0;a:do if((g|0)<1685026146){if((g|0)<1667785074){switch(g|0){case 1651273570:break;default:{k=14;break a}}switch(i&7){case 5:case 3:break;default:{k=12;break a}}d=(b[a>>0]|0)==40?a:d;e=65;break}if((g|0)<1668050786)switch(g|0){case 1667785074:{d=a;e=66;break a}default:{k=14;break a}}switch(g|0){case 1668050786:break;default:{k=14;break a}}e=66}else{if((g|0)>=1919246700)if((g|0)<1952807028){switch(g|0){case 1919246700:break;default:{k=14;break a}}if(i<<24>>24==67){e=69;break}else{k=12;break}}else{switch(g|0){case 1952807028:break;default:{k=14;break a}}e=66;break}if((g|0)<1718382433){switch(g|0){case 1685026146:break;default:{k=14;break a}}if(i<<24>>24==67){e=69;break}}else{switch(g|0){case 1718382433:break;default:{k=14;break a}}if(i<<24>>24==67){e=69;break}}e=i}while(0);if((k|0)==12){k=0;e=i}else if((k|0)==14){k=0;if((g&16777215|0)==6909556){e=68;break}else e=i}i=e}if(!c){t=l;return e|0}f[j>>2]=0;b:do if(e<<24>>24<67){if(!d){f[j>>2]=16;d=5;k=24;break}while(1){a=b[d>>0]|0;if(!(a<<24>>24)){d=1;k=24;break b}if(((a&255)+-48|0)>>>0<10)break;d=d+1|0}RBc(d,j)|0;d=f[j>>2]|0;if((d|0)<1016){d=((d|0)/4|0)+1|0;k=24}else d=255}else{d=1;k=24}while(0);b[c+14>>0]=d;t=l;return e|0}function bSc(a,c){a=a|0;c=c|0;if((c|0)<=-1){c=68;return c|0}c=b[(f[a+4>>2]|0)+(c*20|0)+13>>0]|0;return c|0}function cSc(a,b){a=a|0;b=b|0;if(!(d[a+16>>1]&4))return b|0;b=f[a>>2]|0;b=b+(udd(b)|0)+1|0;return b|0}function dSc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;G=t;t=t+112|0;D=G+96|0;y=G+88|0;x=G+80|0;w=G+72|0;z=G+56|0;p=G+48|0;n=G+40|0;m=G+32|0;k=G;e=f[a+24>>2]|0;F=f[e>>2]|0;a:do switch(b[c>>0]|0){case 75:{a=f[e+4>>2]|0;b[c>>0]=-90;f[c+44>>2]=f[a+24>>2];f[c+28>>2]=f[a+48>>2];a=c+32|0;d[a>>1]=(d[a>>1]|0)+-1<<16>>16;b[c+1>>0]=68;break}case 50:case 51:{g=e;i=0;while(1){if(!(i>>>0<8&(g|0)!=0))break;f[k+(i<<2)>>2]=f[g+16>>2];g=f[g+12>>2]|0;i=i+1|0}j=c+12|0;HRc(a,f[j>>2]|0)|0;i=f[j>>2]|0;if((eTc(i)|0)==0?(h[F+200>>0]|0)<=1:0){E=(b[c>>0]|0)==51;f[c+8>>2]=E?143389:143383;g=c+4|0;f[g>>2]=f[g>>2]|(E?268435456:536870912);b[c>>0]=-87;g=0;while(1){if(!(g>>>0<8&(e|0)!=0))break;f[e+16>>2]=f[k+(g<<2)>>2];e=f[e+12>>2]|0;g=g+1|0}dzc(f[F>>2]|0,i);f[j>>2]=0}F=1;t=G;return F|0}case 55:case 56:case 52:case 53:case 48:case 54:case 57:{E=98;break}case -85:{r=f[c+20>>2]|0;if(!r)k=0;else k=f[r>>2]|0;g=f[F>>2]|0;i=b[g+80>>0]|0;B=e+24|0;C=f[B>>2]&16385;v=c+4|0;if(!(f[v>>2]&16777216))A=0;else{A=f[c+44>>2]|0;A=(b[A+16>>0]|0)==-91?0:A}s=f[c+8>>2]|0;q=Mxc(s)|0;o=AIc(g,s,k,i,0)|0;b:do if(!o){o=AIc(f[F>>2]|0,s,-2,i,0)|0;l=(o|0)==0;k=l&1;l=(l^1)&1;j=0}else{j=(f[o+20>>2]|0)!=0&1;l=o+4|0;do if(f[l>>2]&1024|0){f[v>>2]=f[v>>2]|262144;if((k|0)!=2){f[c+28>>2]=(b[f[o+32>>2]>>0]|0)==117?8388608:125829120;break}k=hTc(f[r+20>>2]|0)|0;f[c+28>>2]=k;if((k|0)<0){TIc(F,122140,m);m=e+20|0;f[m>>2]=(f[m>>2]|0)+1}}while(0);g=o+32|0;switch(iTc(F,31,0,f[g>>2]|0,0)|0){case 0:{g=f[l>>2]|0;if(g&10240|0)f[v>>2]=f[v>>2]|524288;i=f[B>>2]|0;if(!(g&2048)){if(i&42){fTc(F,e,122246,0);g=f[l>>2]|0}}else{b[c+2>>0]=i&46;if(i&262144)f[v>>2]=f[v>>2]|1073741824}if((g&262144|0?(b[F+18>>0]|0)==0:0)?(f[(f[F>>2]|0)+24>>2]&32|0)==0:0){o=0;k=1;l=0;break b}if(!(g&2621440)){k=0;l=0;break b}if((h[F+200>>0]|0)>1){k=0;l=0;break b}jTc(F,c,o);k=0;l=0;break b}case 1:{f[n>>2]=f[g>>2];TIc(F,122211,n);F=e+20|0;f[F>>2]=(f[F>>2]|0)+1;break}default:{}}b[c>>0]=120;F=1;t=G;return F|0}while(0);m=F+200|0;do if((h[m>>0]|0)>=2)if(!(f[v>>2]&16777216)){KRc(a,r)|0;if(!j){F=1;t=G;return F|0}}else E=69;else{if((o|0)!=0?(A|0)!=0&(f[o+24>>2]|0)==0:0){f[p>>2]=q;f[p+4>>2]=s;TIc(F,122274,p);E=65}else E=52;c:do if((E|0)==52){do if(j|0){i=f[B>>2]|0;g=f[o+4>>2]&65536;if((i&1|0?(u=(A|0)!=0,u|(g|0)==0):0)?!(u&(i&16384|0)==0):0)break;f[z>>2]=(A|0)!=0|(g|0)!=0?122318:122325;f[z+4>>2]=q;f[z+8>>2]=s;TIc(F,122335,z);z=e+20|0;f[z>>2]=(f[z>>2]|0)+1;break c}while(0);if(k|0?(b[(f[F>>2]|0)+169>>0]|0)==0:0){f[w>>2]=q;f[w+4>>2]=s;TIc(F,122364,w);E=65;break}if(l|0){f[x>>2]=q;f[x+4>>2]=s;TIc(F,122387,x);E=65;break}if(!j){if(f[v>>2]&16777216|0){f[y>>2]=q;f[y+4>>2]=s;TIc(F,122432,y);z=e+20|0;f[z>>2]=(f[z>>2]|0)+1}}else E=66}while(0);if((E|0)==65?(z=e+20|0,f[z>>2]=(f[z>>2]|0)+1,j|0):0)E=66;if((E|0)==66){f[B>>2]=f[B>>2]&((A|0)==0^-16385);E=69;break}KRc(a,r)|0;F=1;t=G;return F|0}while(0);if((E|0)==69)KRc(a,r)|0;d:do if(!A){b[c>>0]=-89;g=c+2|0;b[g>>0]=0;if(f[v>>2]&16777216|0)HRc(a,f[(f[c+44>>2]|0)+40>>2]|0)|0;while(1){if(!e)break d;if(lTc(c,f[e+4>>2]|0)|0)break;b[g>>0]=(b[g>>0]|0)+1<<24>>24;e=f[e+12>>2]|0}if(o|0){F=e+24|0;f[F>>2]=f[o+4>>2]&4096|f[F>>2]|16}}else{g=f[e+28>>2]|0;if((h[m>>0]|0)<2){if(!g)e=0;else e=f[g+72>>2]|0;kTc(F,e,A,o);if(b[(f[F>>2]|0)+83>>0]|0)break a}KRc(a,f[A+8>>2]|0)|0;KRc(a,f[A+12>>2]|0)|0;HRc(a,f[A+40>>2]|0)|0;USc(g,A);f[B>>2]=f[B>>2]|32768}while(0);f[B>>2]=f[B>>2]|C;F=1;t=G;return F|0}case 49:case 20:case -119:{g=c+4|0;if(f[g>>2]&2048|0){i=e+16|0;j=f[i>>2]|0;k=e+24|0;if(f[k>>2]&46|0)fTc(F,e,122481,c);JRc(a,f[c+20>>2]|0)|0;if((j|0)!=(f[i>>2]|0)){f[g>>2]=f[g>>2]|32;f[k>>2]=f[k>>2]|64}}break}case -101:{if(f[e+24>>2]&46|0)fTc(F,e,122492,c);break}case -86:case 45:{e=kSc(f[c+16>>2]|0)|0;if(e){switch(b[e>>0]|0){case -87:case 59:break;default:{E=98;break a}}if((dSc(a,e)|0)==2){F=2;t=G;return F|0}if((b[e>>0]|0)==-87){b[c+2>>0]=b[c>>0]|0;b[c>>0]=-82;F=0;t=G;return F|0}else E=98}else E=98;break}case 59:{j=f[c+8>>2]|0;i=0;g=0;E=20;break}case -116:{i=f[c+12>>2]|0;if(f[e+24>>2]&40|0)fTc(F,e,122123,0);j=f[c+16>>2]|0;if((b[j>>0]|0)==59){g=0;l=j}else{g=f[i+8>>2]|0;l=f[j+16>>2]|0;i=f[j+12>>2]|0}k=f[i+8>>2]|0;j=f[l+8>>2]|0;if((h[F+200>>0]|0)>1){ORc(F,c,l);ORc(F,c+44|0,i);i=k;E=20}else{i=k;E=20}break}default:{}}while(0);if((E|0)==20){F=gTc(F,g,i,j,e,c)|0;t=G;return F|0}if((E|0)==98?(b[(f[F>>2]|0)+83>>0]|0)==0:0){i=mTc(f[c+12>>2]|0)|0;if((b[c>>0]|0)==48){g=f[c+20>>2]|0;e=mTc(f[g+4>>2]|0)|0;if((e|0)==(i|0)){e=g+20|0;E=103}}else{e=c+16|0;E=103}if((E|0)==103)e=mTc(f[e>>2]|0)|0;if((i|0)!=(e|0))TIc(F,122503,D)}if(f[F+36>>2]|0){F=2;t=G;return F|0}F=(b[(f[F>>2]|0)+83>>0]|0)==0?0:2;t=G;return F|0}function eSc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=t;t=t+48|0;I=J+8|0;H=J;E=J+16|0;d=f[c+4>>2]|0;if(d&4|0){I=1;t=J;return I|0}F=f[a+24>>2]|0;G=f[a>>2]|0;a=f[G>>2]|0;if(!(d&64)){RRc(G,c,F);if(f[G+36>>2]|0){I=2;t=J;return I|0}I=(b[a+83>>0]|0)==0?1:2;t=J;return I|0}D=(f[c+52>>2]|0)!=0;x=D&1;y=E+28|0;z=(F|0)!=0;A=F+16|0;B=G+240|0;C=G+36|0;p=a+83|0;o=z^1;q=E+24|0;r=E+4|0;s=E+12|0;u=E+8|0;v=G+200|0;w=E+4|0;m=c;n=0;a:while(1){if(!m){d=58;break}l=m+4|0;f[l>>2]=f[l>>2]|4;f[w>>2]=0;f[w+4>>2]=0;f[w+8>>2]=0;f[w+12>>2]=0;f[w+16>>2]=0;f[w+20>>2]=0;f[E>>2]=G;f[y>>2]=m;if(fSc(E,f[m+60>>2]|0)|0){a=2;d=61;break}k=m+32|0;if(f[l>>2]&65536|0){j=m+48|0;f[(f[(f[k>>2]|0)+28>>2]|0)+48>>2]=f[j>>2];f[j>>2]=0}g=0;while(1){i=f[k>>2]|0;if((g|0)>=(f[i>>2]|0))break;a=f[i+8+(g*72|0)+20>>2]|0;do if(a|0?(f[a+4>>2]&4|0)==0:0){if(z)j=f[A>>2]|0;else j=0;d=f[B>>2]|0;e=f[i+8+(g*72|0)+8>>2]|0;if(e|0)f[B>>2]=e;URc(G,a,F);f[B>>2]=d;if(f[C>>2]|0){a=2;d=61;break a}a=(b[p>>0]|0)!=0;if(a|o)if(a){a=2;d=61;break a}else break;else{i=i+8+(g*72|0)+37|0;b[i>>0]=((f[A>>2]|0)>(j|0)&1)<<3&255|b[i>>0]&-9;break}}while(0);g=g+1|0}f[q>>2]=16385;f[r>>2]=i;f[s>>2]=F;i=m+28|0;if(gSc(E,f[i>>2]|0)|0){a=2;d=61;break}d=f[q>>2]|0;a=d&-16385;f[q>>2]=a;g=f[m+40>>2]|0;e=(g|0)!=0;if((d&16|0)==0&(e^1)){a=d&-16386;f[q>>2]=a}else f[l>>2]=d&4096|f[l>>2]|8;d=f[m+44>>2]|0;if(!(e|(d|0)==0)){d=28;break}f[u>>2]=f[i>>2];f[q>>2]=a|128;if(fSc(E,d)|0){a=2;d=61;break}if(fSc(E,f[m+36>>2]|0)|0){a=2;d=61;break}a=0;while(1){d=f[k>>2]|0;if((a|0)>=(f[d>>2]|0))break;if(b[d+8+(a*72|0)+37>>0]&4?gSc(E,f[d+8+(a*72|0)+64>>2]|0)|0:0){a=2;d=61;break a}a=a+1|0}f[s>>2]=0;f[q>>2]=f[q>>2]|16385;if(f[l>>2]&65536|0){l=(f[d+28>>2]|0)+48|0;f[m+48>>2]=f[l>>2];f[l>>2]=0}if(n>>>0>=x>>>0?hSc(E,m,f[m+48>>2]|0,121654)|0:0){a=2;d=61;break}if(b[p>>0]|0){a=2;d=61;break}f[q>>2]=f[q>>2]&-16385;b:do if(e){if(hSc(E,m,g,121660)|0){a=2;d=61;break a}if(b[p>>0]|0){a=2;d=61;break a}e=f[g>>2]|0;a=g+4|0;d=0;while(1){if((d|0)>=(e|0))break b;if(f[(f[a>>2]|0)+4>>2]&16|0){d=47;break a}a=a+16|0;d=d+1|0}}while(0);c:do if((h[v>>0]|0)>1){a=m+72|0;while(1){a=f[a>>2]|0;if(!a)break c;if(gSc(E,f[a+12>>2]|0)|0){a=2;d=61;break a}if(!(gSc(E,f[a+8>>2]|0)|0))a=a+36|0;else{a=2;d=61;break a}}}while(0);a=f[m+56>>2]|0;if(a|0?(f[f[i>>2]>>2]|0)!=(f[f[a+28>>2]>>2]|0):0){d=56;break}m=f[m+52>>2]|0;n=n+1|0}if((d|0)==28){TIc(G,121610,H);I=2;t=J;return I|0}else if((d|0)==47){TIc(G,121666,I);I=2;t=J;return I|0}else if((d|0)==56){iSc(G,a);I=2;t=J;return I|0}else if((d|0)==58){if(D?jSc(G,c)|0:0){I=2;t=J;return I|0}I=1;t=J;return I|0}else if((d|0)==61){t=J;return a|0}return 0}function fSc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;if(!b){g=0;t=h;return g|0}e=a+24|0;g=f[e>>2]|0;f[e>>2]=g&-36881;j=f[a>>2]|0;f[c>>2]=j;f[c+4>>2]=682;f[c+8>>2]=683;f[c+12>>2]=0;f[c+24>>2]=a;d=b+24|0;k=j+208|0;i=(f[k>>2]|0)+(f[d>>2]|0)|0;f[k>>2]=i;if(dTc(j,i)|0){k=1;t=h;return k|0}HRc(c,b)|0;c=f[c>>2]|0;k=c+208|0;f[k>>2]=(f[k>>2]|0)-(f[d>>2]|0);k=f[e>>2]|0;j=b+4|0;f[j>>2]=f[j>>2]|k&32784;f[e>>2]=k|g&36880;if((f[a+20>>2]|0)>0){k=1;t=h;return k|0}k=(f[c+36>>2]|0)>0&1;t=h;return k|0}function gSc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+32|0;k=m;if(!b){l=0;t=m;return l|0}d=f[a>>2]|0;f[k>>2]=d;f[k+4>>2]=682;f[k+8>>2]=683;f[k+12>>2]=0;f[k+24>>2]=a;l=a+24|0;i=f[l>>2]|0;e=i&-36881;f[l>>2]=e;j=a+20|0;a=i&36880;i=0;while(1){if((i|0)>=(f[b>>2]|0)){c=11;break}g=f[b+4+(i<<4)>>2]|0;if(g){c=g+24|0;e=d+208|0;h=(f[e>>2]|0)+(f[c>>2]|0)|0;f[e>>2]=h;if(dTc(d,h)|0){a=2;c=12;break}HRc(k,g)|0;h=f[k>>2]|0;e=h+208|0;f[e>>2]=(f[e>>2]|0)-(f[c>>2]|0);e=f[l>>2]|0;d=e&36880;c=g+4|0;if(!d)c=e;else{g=e&-36881;f[c>>2]=f[c>>2]|e&32784;f[l>>2]=g;a=d|a;c=g}if((f[j>>2]|0)>0){a=2;c=12;break}if((f[h+36>>2]|0)>0){a=2;c=12;break}else d=h}else c=e;i=i+1|0;e=c}if((c|0)==11){f[l>>2]=e|a;l=0;t=m;return l|0}else if((c|0)==12){t=m;return a|0}return 0}function hSc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0;u=t;t=t+16|0;o=u;if(!e){s=0;t=u;return s|0}p=c+28|0;r=f[f[p>>2]>>2]|0;s=f[a>>2]|0;q=0;m=e+4|0;a:while(1){if((q|0)>=(f[e>>2]|0)){i=19;break}l=f[m>>2]|0;h=kSc(l)|0;b:do if(h|0){if((b[g>>0]|0)!=71?(n=nSc(f[p>>2]|0,h)|0,f[o>>2]=n,(n|0)>0):0){d[m+12>>1]=n;break}if(lSc(h,o)|0){h=f[o>>2]|0;if((h+-1|0)>>>0>65534){i=10;break a}d[m+12>>1]=h;break}i=m+12|0;d[i>>1]=0;if(fSc(a,l)|0){h=1;i=20;break a}h=0;while(1){j=f[p>>2]|0;if((h|0)>=(f[j>>2]|0))break b;k=h+1|0;if(!(qSc(0,l,f[j+4+(h<<4)>>2]|0,-1)|0)){XSc(c,l);d[i>>1]=k}h=k}}while(0);q=q+1|0;m=m+16|0}if((i|0)==10){mSc(s,g,q+1|0,r);s=1;t=u;return s|0}else if((i|0)==19){s=YSc(s,c,e,g)|0;t=u;return s|0}else if((i|0)==20){t=u;return h|0}return 0}function iSc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d+8|0;if(!(f[b+4>>2]&512)){b=WSc(h[b>>0]|0)|0;f[c>>2]=b;TIc(a,121929,c);t=d;return}else{TIc(a,121883,d);t=d;return}}function jSc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0;z=t;t=t+16|0;x=z+8|0;s=z+12|0;w=f[c+48>>2]|0;if(!w){y=0;t=z;return y|0}v=f[a>>2]|0;g=f[w>>2]|0;if((g|0)>(f[v+120>>2]|0)){TIc(a,121725,z);y=1;t=z;return y|0}e=0;while(1){if((e|0)>=(g|0))break;r=w+4+(e<<4)+9|0;b[r>>0]=b[r>>0]&-5;e=e+1|0}e=0;while(1){f[c+56>>2]=e;e=f[c+52>>2]|0;if(!e)break;else{r=c;c=e;e=r}}p=w+4|0;q=a+200|0;r=v+83|0;e=1;a:while(1){if(!((e|0)!=0&(c|0)!=0)){y=11;break}o=f[c+28>>2]|0;m=p;e=0;n=0;while(1){if((n|0)>=(g|0))break;f[s>>2]=-1;l=m+9|0;do if((b[l>>0]&4)==0?(u=kSc(f[m>>2]|0)|0,(u|0)!=0):0){if(!(lSc(u,s)|0)){g=nSc(o,u)|0;f[s>>2]=g;if(!g){if((h[q>>0]|0)>1)i=u;else i=oSc(v,u,0)|0;if(!(b[r>>0]|0)){g=pSc(a,c,i)|0;f[s>>2]=g}else g=0;if((h[q>>0]|0)<=1)dzc(v,i)}if((g|0)<=0){e=1;break}}else{g=f[s>>2]|0;i=f[o>>2]|0;if((g|0)<1|(g|0)>(i|0)){y=18;break a}}if((h[q>>0]|0)<=1){k=wQc(v,154,0)|0;if(!k)break a;i=k+4|0;f[i>>2]=f[i>>2]|1024;f[k+8>>2]=g;i=f[m>>2]|0;if((i|0)==(u|0))i=m;else{while(1){j=f[i+12>>2]|0;if((b[j>>0]|0)==112)i=j;else break}i=i+12|0}f[i>>2]=k;dzc(v,u);d[m+12>>1]=g}b[l>>0]=b[l>>0]|4}while(0);m=m+16|0;n=n+1|0;g=f[w>>2]|0}c=f[c+56>>2]|0}if((y|0)==11){e=0;do{if((e|0)>=(g|0)){e=0;y=41;break}v=e;e=e+1|0}while((b[w+4+(v<<4)+9>>0]&4)!=0);if((y|0)==41){t=z;return e|0}f[x>>2]=e;TIc(a,121759,x);y=1;t=z;return y|0}else if((y|0)==18)mSc(a,121654,n+1|0,i);y=1;t=z;return y|0}function kSc(a){a=a|0;var b=0;while(1){if(!a){a=0;b=8;break}b=f[a+4>>2]|0;if(!(b&266240)){b=8;break}if(!(b&262144))a=a+12|0;else a=(f[a+20>>2]|0)+4|0;a=f[a>>2]|0}if((b|0)==8)return a|0;return 0}function lSc(a,c){a=a|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;a:do if(!a)a=0;else{if(f[a+4>>2]&1024|0){f[c>>2]=f[a+8>>2];a=1;break}switch(b[a>>0]|0){case -83:{a=lSc(f[a+12>>2]|0,c)|0;break a}case -84:break;default:{a=0;break a}}if(!(lSc(f[a+12>>2]|0,d)|0))a=0;else{f[c>>2]=0-(f[d>>2]|0);a=1}}while(0);t=e;return a|0}function mSc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=t;t=t+16|0;g=e;f[g>>2]=c;f[g+4>>2]=b;f[g+8>>2]=d;TIc(a,121827,g);t=e;return}function nSc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;if((b[c>>0]|0)!=59){g=0;return g|0}d=f[c+8>>2]|0;e=f[a>>2]|0;c=0;while(1){if((c|0)>=(e|0)){c=0;g=8;break}if((b[a+4+(c<<4)+9>>0]&3)==0?(zHc(f[a+4+(c<<4)+4>>2]|0,d)|0)==0:0)break;c=c+1|0}if((g|0)==8)return c|0;g=c+1|0;return g|0}function oSc(a,b,c){a=a|0;b=b|0;c=c|0;if(!b)a=0;else a=GSc(a,b,c,0)|0;return a|0}function pSc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0;j=t;t=t+32|0;g=j;i=f[c+28>>2]|0;e=g+12|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[g>>2]=a;f[g+4>>2]=f[c+32>>2];f[g+8>>2]=i;f[g+24>>2]=129;f[g+20>>2]=0;c=(f[a>>2]|0)+87|0;e=b[c>>0]|0;if((h[a+200>>0]|0)<2)b[c>>0]=1;g=fSc(g,d)|0;b[c>>0]=e;if(g|0){i=0;t=j;return i|0}e=0;while(1){if((e|0)>=(f[i>>2]|0)){c=0;e=7;break}c=e+1|0;if((qSc(0,f[i+4+(e<<4)>>2]|0,d,-1)|0)<2){e=7;break}else e=c}if((e|0)==7){t=j;return c|0}return 0}function qSc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((c|0)==0|(e|0)==0){g=(e|0)==(c|0)?0:2;return g|0}if((a|0?(b[c>>0]|0)==-101:0)?rSc(a,c,e)|0:0){g=0;return g|0}l=c+4|0;i=f[l>>2]|0;m=e+4|0;n=f[m>>2]|0;o=n|i;if(o&1024|0){if(i&1024&n|0?(f[c+8>>2]|0)==(f[e+8>>2]|0):0){g=0;return g|0}g=2;return g|0}j=b[c>>0]|0;h=b[e>>0]|0;if(j<<24>>24==71?1:j<<24>>24!=h<<24>>24){do if(j<<24>>24==112)if((qSc(a,f[c+12>>2]|0,e,g)|0)<2){g=1;return g|0}else{h=b[e>>0]|0;break}while(0);if(h<<24>>24==112?(qSc(a,c,f[e+12>>2]|0,g)|0)<2:0){g=1;return g|0}g=2;return g|0}a:do switch(j<<24>>24){case -88:case -90:{h=n;break}default:{k=f[c+8>>2]|0;if(!k)h=n;else switch(j<<24>>24){case -89:case -85:{if(wzc(k,f[e+8>>2]|0)|0){g=2;return g|0}h=i&16777216;if((h>>>24|0)!=(n>>>24&1|0)){g=2;return g|0}if(!h){h=n;break a}if(!(sSc(a,f[c+44>>2]|0,f[e+44>>2]|0,1)|0)){i=f[l>>2]|0;h=f[m>>2]|0;break a}else{g=2;return g|0}}case 112:{if(!(zHc(k,f[e+8>>2]|0)|0)){h=n;break a}else h=2;return h|0}case 120:{g=0;return g|0}default:{h=f[e+8>>2]|0;if(!h){h=n;break a}if(!(ncd(k,h)|0)){h=n;break a}else h=2;return h|0}}}}while(0);if((h^i)&514|0){g=2;return g|0}b:do if(!(o&16384)){if(o&2048|0){g=2;return g|0}if((o&8|0)==0?qSc(a,f[c+12>>2]|0,f[e+12>>2]|0,g)|0:0){g=2;return g|0}if(qSc(a,f[c+16>>2]|0,f[e+16>>2]|0,g)|0){g=2;return g|0}if(tSc(f[c+20>>2]|0,f[e+20>>2]|0,g)|0){g=2;return g|0}h=b[c>>0]|0;switch(h<<24>>24){case -87:case 116:break b;default:{}}if(!(o&8192)){if((d[c+32>>1]|0)!=(d[e+32>>1]|0)){g=2;return g|0}if(h<<24>>24==-82?(b[c+2>>0]|0)!=(b[e+2>>0]|0):0){g=2;return g|0}if(h<<24>>24!=49?(c=f[c+28>>2]|0,!((c|0)==(g|0)?1:(c|0)==(f[e+28>>2]|0))):0){g=2;return g|0}}}while(0);g=0;return g|0}function rSc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0;g=t;t=t+16|0;e=g;f[e>>2]=0;uSc(f[a>>2]|0,c,1,65,e)|0;e=f[e>>2]|0;if(!e){e=0;t=g;return e|0}b=d[b+32>>1]|0;vSc(f[a+8>>2]|0,b);a=wSc(f[a+220>>2]|0,b)|0;if(!a)c=0;else{if((GDc(a)|0)==3)Txc(a)|0;c=(vEc(a,e,0)|0)==0&1}Ryc(e);Ryc(a);e=c;t=g;return e|0}function sSc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;if((c|0)==0|(d|0)==0){h=1;return h|0}if((b[c+16>>0]|0)!=(b[d+16>>0]|0)){h=1;return h|0}if((b[c+17>>0]|0)!=(b[d+17>>0]|0)){h=1;return h|0}if((b[c+18>>0]|0)!=(b[d+18>>0]|0)){h=1;return h|0}if((b[c+20>>0]|0)!=(b[d+20>>0]|0)){h=1;return h|0}if(qSc(a,f[c+24>>2]|0,f[d+24>>2]|0,-1)|0){h=1;return h|0}if(qSc(a,f[c+28>>2]|0,f[d+28>>2]|0,-1)|0){h=1;return h|0}g=tSc(f[c+8>>2]|0,f[d+8>>2]|0,-1)|0;if(g|0){h=g;return h|0}g=tSc(f[c+12>>2]|0,f[d+12>>2]|0,-1)|0;if(g|0){h=g;return h|0}if(e|0?(h=qSc(a,f[c+40>>2]|0,f[d+40>>2]|0,-1)|0,h|0):0)return h|0;h=0;return h|0}function tSc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;e=(a|0)==0;g=(c|0)==0;if(e&g){d=0;return d|0}if(e|g){d=1;return d|0}e=f[a>>2]|0;if((e|0)!=(f[c>>2]|0)){d=1;return d|0}g=0;while(1){if((g|0)>=(e|0)){e=0;g=9;break}if((b[a+4+(g<<4)+8>>0]|0)!=(b[c+4+(g<<4)+8>>0]|0)){e=1;g=9;break}e=qSc(0,f[a+4+(g<<4)>>2]|0,f[c+4+(g<<4)>>2]|0,d)|0;if(e|0){g=9;break}g=g+1|0;e=f[a>>2]|0}if((g|0)==9)return e|0;return 0}function uSc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;if(!b){e=0;return e|0}e=zSc(a,b,c,d,e)|0;return e|0}function vSc(a,b){a=a|0;b=b|0;var c=0,d=0;d=(b|0)>31;c=a+208|0;a=a+208|0;f[(d?a:c)>>2]=f[(d?a:c)>>2]|(d?-2147483648:1<<b+-1);return}function wSc(a,b){a=a|0;b=b|0;var c=0,e=0;if(!a){e=0;return e|0}e=f[a+100>>2]|0;c=b+-1|0;if(d[e+(c*40|0)+8>>1]&1){e=0;return e|0}b=EIc(f[a>>2]|0)|0;if(!b){e=0;return e|0}qEc(b,e+(c*40|0)|0)|0;xSc(b,65,1);e=b;return e|0}function xSc(a,b,c){a=a|0;b=b|0;c=c|0;ySc(a,b,c);return}function ySc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,f=0;if(b<<24>>24<=66){if(b<<24>>24!=66)return;e=a+8|0;b=d[e>>1]|0;f=b&65535;if(!((f&2|0)!=0|(f&44|0)==0)){_xc(a,c,1)|0;b=d[e>>1]|0}d[e>>1]=b&-45;return}b=j[a+8>>1]|0;if(b&4|0)return;if(b&8|0){JDc(a);return}if(!(b&2))return;HDc(a,1);return}function zSc(a,c,e,g,i){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;var k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,u=0;u=t;t=t+16|0;r=u;n=u+8|0;f[n>>2]=0;a:while(1){k=b[c>>0]|0;switch(k<<24>>24){case -83:case -76:break;default:break a}c=f[c+12>>2]|0}if(k<<24>>24==-81)k=h[c+2>>0]|0;else k=k&255;b:do switch((k&255)<<24>>24){case 36:{l=aSc(f[c+8>>2]|0,0)|0;c=zSc(a,f[c+12>>2]|0,e,l,i)|0;k=f[i>>2]|0;if(!k){i=c;t=u;return i|0}ASc(k,l,1)|0;xSc(f[i>>2]|0,g,1);i=c;t=u;return i|0}case -84:{c=f[c+12>>2]|0;k=b[c>>0]|0;switch(k<<24>>24){case -104:case -102:break;default:{s=25;break b}}o=121820;q=c;m=k&255;k=-1;l=-1;s=11;break}default:{o=155644;q=c;m=k;k=1;l=0;s=11}}while(0);c:do if((s|0)==11){d:do switch(m|0){case 116:case 152:case 154:{c=BSc(a)|0;f[n>>2]=c;n=c;if(!c)c=0;else{if(!(f[q+4>>2]&1024)){k=f[q+8>>2]|0;f[r>>2]=o;f[r+4>>2]=k;k=YMc(a,121822,r)|0;if(!k)break d;GIc(c,k,1,808)}else{a=f[q+8>>2]|0;a=Brd(k|0,l|0,a|0,((a|0)<0)<<31>>31|0)|0;EDc(c,a,G)}if(g<<24>>24==65&(m|2|0)==154)xSc(c,67,1);else xSc(c,g,1);k=c+8|0;l=j[k>>1]|0;if(l&44|0)d[k>>1]=l&65533;if(e<<24>>24==1){k=0;c=n;break c}k=Xxc(c,e&255)|0;c=n;break c}break}case 172:{c=f[q+12>>2]|0;s=25;break c}case 120:{c=BSc(a)|0;f[n>>2]=c;if(!c)c=0;else{fyc(c);k=0;break c}break}case 153:{c=BSc(a)|0;f[n>>2]=c;if(!c)c=0;else{g=(f[q+8>>2]|0)+2|0;k=(Mxc(g)|0)+-1|0;SDc(c,DSc(a,g,k)|0,(k|0)/2|0,0,808)|0;k=0;break c}break}case 169:{k=BSc(a)|0;f[n>>2]=k;c=k;if(!k){k=0;break c}d[k+8>>1]=4;f[k>>2]=(b[(f[q+8>>2]|0)+4>>0]|0)==0&1;f[k+4>>2]=0;k=0;break c}default:{k=0;c=0;break c}}while(0);Cxc(a);nxc(a,0);Ryc(c);i=7;t=u;return i|0}while(0);if((s|0)==25){a=(zSc(a,c,e,g,n)|0)==0;k=f[n>>2]|0;c=k;if(a&(k|0)!=0){CSc(k);l=k+8|0;m=d[l>>1]|0;do if(!(m&8)){o=k;n=f[o>>2]|0;o=f[o+4>>2]|0;if((n|0)==0&(o|0)==-2147483648){p[k>>3]=9223372036854775808.0;d[l>>1]=m&15936|8;break}else{s=wrd(0,0,n|0,o|0)|0;a=k;f[a>>2]=s;f[a+4>>2]=G;break}}else p[k>>3]=-+p[k>>3];while(0);xSc(k,g,e);k=0}else k=0}f[i>>2]=c;i=k;t=u;return i|0}function ASc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,f=0;f=a+8|0;e=j[f>>1]|0;if(e&1|0){f=0;return f|0}switch(b<<24>>24){case 65:{if(e&16|0){d[f>>1]=e&15952;f=0;return f|0}xSc(a,66,c);a=j[f>>1]|0;if(!(a&2)){f=0;return f|0}d[f>>1]=a&15936|16;f=0;return f|0}case 67:{CSc(a);f=0;return f|0}case 68:{ESc(a);f=0;return f|0}case 69:{FSc(a);f=0;return f|0}default:{d[f>>1]=e>>>3&2|e;xSc(a,66,c);d[f>>1]=d[f>>1]&-16445;f=Xxc(a,c&255)|0;return f|0}}return 0}function BSc(a){a=a|0;return EIc(a)|0}function CSc(a){a=a|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0.0;k=t;t=t+16|0;h=k;i=a+8|0;c=d[i>>1]|0;if(c&45){j=c;j=j&-16403;d[i>>1]=j;t=k;return}e=a+16|0;g=a+12|0;c=a+10|0;if((pyc(f[e>>2]|0,a,f[g>>2]|0,b[c>>0]|0)|0)>>>0<2?(vyc(f[e>>2]|0,h,f[g>>2]|0,b[c>>0]|0)|0)<2:0){c=h;e=f[c>>2]|0;c=f[c+4>>2]|0;j=6}else{l=+p[a>>3];e=~~l>>>0;c=+I(l)>=1.0?(l>0.0?~~+W(+H(l/4294967296.0),4294967295.0)>>>0:~~+U((l-+(~~l>>>0))/4294967296.0)>>>0):0;f[h>>2]=e;f[h+4>>2]=c;if(!(KDc(l,e,c)|0))c=8;else j=6}if((j|0)==6){j=a;f[j>>2]=e;f[j+4>>2]=c;c=4}j=d[i>>1]&15936|c;d[i>>1]=j;j=j&-16403;d[i>>1]=j;t=k;return}function DSc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0,g=0;f=((d|0)/2|0)+1|0;f=uxc(a,f,((f|0)<0)<<31>>31)|0;e=d+-1|0;if(!f)return f|0;d=((e|0)>0?e:0)+1|0;a=0;while(1){if((a|0)>=(e|0))break;g=((SBc(b[c+a>>0]|0)|0)&255)<<4;g=(g|(SBc(b[c+(a|1)>>0]|0)|0)&255)&255;b[f+(a>>>1)>>0]=g;a=a+2|0}b[f+(d>>>1)>>0]=0;return f|0}function ESc(a){a=a|0;var b=0,c=0;c=syc(a)|0;b=a;f[b>>2]=c;f[b+4>>2]=G;a=a+8|0;d[a>>1]=d[a>>1]&15936|4;return}function FSc(a){a=a|0;var b=0.0;b=+nyc(a);p[a>>3]=b;a=a+8|0;d[a>>1]=d[a>>1]&15936|8;return}function GSc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=t;t=t+16|0;n=q;o=(e|0)!=0;if(o){h=134217728;p=f[e>>2]|0}else{p=HSc(c,d)|0;h=0;p=uxc(a,p,((p|0)<0)<<31>>31)|0}f[n>>2]=p;if(!p){t=q;return p|0}j=ISc(c,d)|0;k=j&4095;m=c+4|0;if((f[m>>2]&1024|0)==0?(g=f[c+8>>2]|0,(g|0)!=0):0)i=(Mxc(g)|0)+1|0;else i=0;if(!d){g=JSc(c)|0;Krd(p|0,c|0,g|0)|0;if(g>>>0<52)Mrd(p+g|0,0,52-g|0)|0}else Krd(p|0,c|0,k|0)|0;l=p+4|0;g=j&24576|h|f[l>>2]&-134307841;f[l>>2]=g;if(i){g=p+k|0;f[p+8>>2]=g;Krd(g|0,f[c+8>>2]|0,i|0)|0;g=f[l>>2]|0}h=f[m>>2]|0;do if(!((g|h)&8404992)){g=c+20|0;if(!(h&2048)){k=LSc(a,f[g>>2]|0,d)|0;f[p+20>>2]=k;break}else{k=KSc(a,f[g>>2]|0,d)|0;f[p+20>>2]=k;break}}while(0);g=f[l>>2]|0;if(!(g&16801792)){if(f[m>>2]&8404992|0){t=q;return p|0}g=c+12|0;if((b[p>>0]|0)==-79)f[p+12>>2]=f[g>>2];else{o=oSc(a,f[g>>2]|0,0)|0;f[p+12>>2]=o}c=oSc(a,f[c+16>>2]|0,0)|0;f[p+16>>2]=c;t=q;return p|0}d=p+(MSc(c,d)|0)|0;f[n>>2]=d;if(!(g&8404992)){g=f[c+12>>2]|0;if(!g)g=0;else g=GSc(a,g,1,n)|0;f[p+12>>2]=g;g=f[c+16>>2]|0;if(!g)g=0;else g=GSc(a,g,1,n)|0;f[p+16>>2]=g}if(f[m>>2]&16777216|0){c=NSc(a,p,f[c+44>>2]|0)|0;f[p+44>>2]=c}if(!o){t=q;return p|0}f[e>>2]=f[n>>2];t=q;return p|0}function HSc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!a){c=0;return c|0}c=MSc(a,b)|0;if(!(b&1))return c|0;else{d=HSc(f[a+12>>2]|0,b)|0;return d+c+(HSc(f[a+16>>2]|0,b)|0)|0}return 0}function ISc(a,c){a=a|0;c=c|0;if(!c){c=52;return c|0}if((b[a>>0]|0)==-79){c=52;return c|0}if(f[a+4>>2]&16777216|0){c=52;return c|0}if(!(f[a+12>>2]|0))return ((f[a+20>>2]|0)==0?16396:8220)|0;else{c=8220;return c|0}return 0}function JSc(a){a=a|0;a=f[a+4>>2]|0;return ((a&16384|0)==0?((a&8192|0)==0?52:28):12)|0}function KSc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+16|0;l=m;f[l>>2]=0;k=a+83|0;j=0;g=l;while(1){if(!c){c=8;break}i=uxc(a,76,0)|0;if(!i){c=8;break}h=LSc(a,f[c+28>>2]|0,e)|0;f[i+28>>2]=h;h=OSc(a,f[c+32>>2]|0,e)|0;f[i+32>>2]=h;h=oSc(a,f[c+36>>2]|0,e)|0;f[i+36>>2]=h;h=LSc(a,f[c+40>>2]|0,e)|0;f[i+40>>2]=h;h=oSc(a,f[c+44>>2]|0,e)|0;f[i+44>>2]=h;h=LSc(a,f[c+48>>2]|0,e)|0;f[i+48>>2]=h;b[i>>0]=b[c>>0]|0;f[i+56>>2]=j;h=i+52|0;f[h>>2]=0;j=oSc(a,f[c+60>>2]|0,e)|0;f[i+60>>2]=j;f[i+8>>2]=0;f[i+12>>2]=0;f[i+4>>2]=f[c+4>>2]&-33;f[i+20>>2]=-1;f[i+24>>2]=-1;d[i+2>>1]=d[c+2>>1]|0;j=PSc(a,f[c+64>>2]|0)|0;f[i+64>>2]=j;f[i+68>>2]=0;j=QSc(a,f[c+72>>2]|0)|0;f[i+72>>2]=j;if(f[c+68>>2]|0?(b[k>>0]|0)==0:0)RSc(i);f[i+16>>2]=f[c+16>>2];f[g>>2]=i;j=i;c=f[c+52>>2]|0;g=h}if((c|0)==8){t=m;return f[l>>2]|0}return 0}function LSc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if(!c){e=0;return e|0}g=txc(a,c)|0;g=uxc(a,g,((g|0)<0)<<31>>31)|0;if(!g){e=0;return e|0}f[g>>2]=f[c>>2];j=g+4|0;h=0;k=0;l=c+4|0;while(1){if((k|0)>=(f[c>>2]|0))break;m=f[l>>2]|0;i=oSc(a,m,e)|0;f[j>>2]=i;do if((m|0)!=0?!((i|0)==0|(b[m>>0]|0)!=-79):0)if(!(d[i+32>>1]|0)){h=f[i+16>>2]|0;f[i+12>>2]=h;break}else{f[i+12>>2]=h;break}while(0);i=UIc(a,f[l+4>>2]|0)|0;f[j+4>>2]=i;b[j+8>>0]=b[l+8>>0]|0;i=l+9|0;m=j+9|0;n=b[m>>0]&-8|b[i>>0]&3;b[m>>0]=n;n=n&-37|b[i>>0]&32;b[m>>0]=n;b[m>>0]=n&-21|b[i>>0]&16;f[j+12>>2]=f[l+12>>2];j=j+16|0;k=k+1|0;l=l+16|0}return g|0}function MSc(a,b){a=a|0;b=b|0;var c=0;b=(ISc(a,b)|0)&4095;if((f[a+4>>2]&1024|0)==0?(c=f[a+8>>2]|0,(c|0)!=0):0)b=b+1+((udd(c)|0)&1073741823)|0;return b+7&-8|0}function NSc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;if(!d){e=0;return e|0}e=$Ec(a,100,0)|0;if(!e)return e|0;g=UIc(a,f[d>>2]|0)|0;f[e>>2]=g;g=UIc(a,f[d+4>>2]|0)|0;f[e+4>>2]=g;g=oSc(a,f[d+40>>2]|0,0)|0;f[e+40>>2]=g;f[e+44>>2]=f[d+44>>2];g=LSc(a,f[d+8>>2]|0,0)|0;f[e+8>>2]=g;g=LSc(a,f[d+12>>2]|0,0)|0;f[e+12>>2]=g;b[e+16>>0]=b[d+16>>0]|0;b[e+18>>0]=b[d+18>>0]|0;b[e+17>>0]=b[d+17>>0]|0;b[e+20>>0]=b[d+20>>0]|0;f[e+56>>2]=f[d+56>>2];f[e+52>>2]=f[d+52>>2];f[e+80>>2]=f[d+80>>2];f[e+48>>2]=f[d+48>>2];b[e+96>>0]=b[d+96>>0]|0;g=oSc(a,f[d+24>>2]|0,0)|0;f[e+24>>2]=g;a=oSc(a,f[d+28>>2]|0,0)|0;f[e+28>>2]=a;f[e+72>>2]=c;b[e+19>>0]=b[d+19>>0]|0;return e|0}function OSc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;if(!c){d=0;return d|0}e=f[c>>2]|0;k=(e|0)>0;e=(e*72|0)+8|0;e=uxc(a,k?e:80,k?((e|0)<0)<<31>>31:0)|0;if(!e){d=0;return d|0}k=f[c>>2]|0;f[e+4>>2]=k;f[e>>2]=k;k=e+8|0;j=0;while(1){if((j|0)>=(f[c>>2]|0))break;f[k+(j*72|0)>>2]=f[c+8+(j*72|0)>>2];i=UIc(a,f[c+8+(j*72|0)+4>>2]|0)|0;f[k+(j*72|0)+4>>2]=i;i=UIc(a,f[c+8+(j*72|0)+8>>2]|0)|0;f[k+(j*72|0)+8>>2]=i;i=UIc(a,f[c+8+(j*72|0)+12>>2]|0)|0;f[k+(j*72|0)+12>>2]=i;f[k+(j*72|0)+36>>2]=f[c+8+(j*72|0)+36>>2];f[k+(j*72|0)+40>>2]=f[c+8+(j*72|0)+40>>2];f[k+(j*72|0)+24>>2]=f[c+8+(j*72|0)+24>>2];f[k+(j*72|0)+28>>2]=f[c+8+(j*72|0)+28>>2];i=k+(j*72|0)+37|0;g=b[i>>0]|0;if(g&2){g=UIc(a,f[c+8+(j*72|0)+64>>2]|0)|0;f[k+(j*72|0)+64>>2]=g;g=b[i>>0]|0}h=f[c+8+(j*72|0)+68>>2]|0;f[k+(j*72|0)+68>>2]=h;if(g<<24>>24<0){g=h;f[g>>2]=(f[g>>2]|0)+1;g=b[i>>0]|0}if(g&4){i=LSc(a,f[c+8+(j*72|0)+64>>2]|0,d)|0;f[k+(j*72|0)+64>>2]=i}g=f[c+8+(j*72|0)+16>>2]|0;f[k+(j*72|0)+16>>2]=g;if(g|0){i=g+32|0;f[i>>2]=(f[i>>2]|0)+1}g=KSc(a,f[c+8+(j*72|0)+20>>2]|0,d)|0;f[k+(j*72|0)+20>>2]=g;g=oSc(a,f[c+8+(j*72|0)+44>>2]|0,d)|0;f[k+(j*72|0)+44>>2]=g;g=VSc(a,f[c+8+(j*72|0)+48>>2]|0)|0;f[k+(j*72|0)+48>>2]=g;g=c+8+(j*72|0)+56|0;h=f[g+4>>2]|0;i=k+(j*72|0)+56|0;f[i>>2]=f[g>>2];f[i+4>>2]=h;j=j+1|0}return e|0}function PSc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;if(!b){e=0;return e|0}c=$Ec(a,((f[b>>2]|0)*24|0)+8|0,0)|0;if(!c){e=c;return e|0}f[c>>2]=f[b>>2];e=c+8|0;d=0;while(1){if((d|0)>=(f[b>>2]|0))break;g=KSc(a,f[b+8+(d*24|0)+8>>2]|0,0)|0;f[e+(d*24|0)+8>>2]=g;g=LSc(a,f[b+8+(d*24|0)+4>>2]|0,0)|0;f[e+(d*24|0)+4>>2]=g;g=UIc(a,f[b+8+(d*24|0)>>2]|0)|0;f[e+(d*24|0)>>2]=g;d=d+1|0}return c|0}function QSc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;e=g;f[e>>2]=0;d=e;while(1){if(!b)break;c=NSc(a,0,b)|0;f[d>>2]=c;if(!c)break;d=c+36|0;b=f[b+36>>2]|0}t=g;return f[e>>2]|0}function RSc(a){a=a|0;var b=0,c=0;b=t;t=t+32|0;c=b;f[c+4>>2]=685;f[c+8>>2]=686;f[c+12>>2]=0;f[c>>2]=0;f[c+24>>2]=a;JRc(c,a)|0;t=b;return}function SSc(a,c){a=a|0;c=c|0;if((b[c>>0]|0)!=-85)return 0;if(!(f[c+4>>2]&16777216))return 0;USc(f[a+24>>2]|0,f[c+44>>2]|0);return 0}function TSc(a,b){a=a|0;b=b|0;return (f[a+24>>2]|0)!=(b|0)|0}function USc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!a)return;d=a+68|0;c=f[d>>2]|0;do if(!c)f[b+36>>2]=c;else{if(!(sSc(0,c,b,0)|0)){a=f[d>>2]|0;c=b+36|0;f[c>>2]=a;if(!a)break;f[a+32>>2]=c;break}if(!(tSc(f[b+8>>2]|0,f[(f[d>>2]|0)+8>>2]|0,-1)|0))return;d=a+4|0;f[d>>2]=f[d>>2]|33554432;return}while(0);f[d>>2]=b;f[b+32>>2]=d;return}function VSc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;if(!b){e=0;return e|0}c=uxc(a,8,0)|0;if(!c){e=0;return e|0}e=b+4|0;f[c+4>>2]=f[e>>2];d=uxc(a,f[e>>2]<<3,0)|0;f[c>>2]=d;if(!d){oxc(a,c);e=0;return e|0}d=0;while(1){if((d|0)>=(f[e>>2]|0))break;g=f[c>>2]|0;h=f[b>>2]|0;i=UIc(a,f[h+(d<<3)>>2]|0)|0;f[g+(d<<3)>>2]=i;f[g+(d<<3)+4>>2]=f[h+(d<<3)+4>>2];d=d+1|0}return c|0}function WSc(a){a=a|0;switch(a|0){case 134:{a=122034;break}case 136:{a=122024;break}case 135:{a=122017;break}default:a=122011}return a|0}function XSc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+32|0;c=d;if(!(f[a+68>>2]|0)){t=d;return};f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[c+4>>2]=687;f[c+24>>2]=a;HRc(c,b)|0;t=d;return}function YSc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;k=n;j=f[a>>2]|0;if(!e){m=0;t=n;return m|0}if(b[j+83>>0]|0){m=0;t=n;return m|0}if((h[a+200>>0]|0)>1){m=0;t=n;return m|0}i=f[e>>2]|0;if((i|0)>(f[j+120>>2]|0)){f[k>>2]=g;TIc(a,122044,k);m=1;t=n;return m|0}l=f[c+28>>2]|0;j=e+4|0;k=0;while(1){if((k|0)>=(i|0)){i=0;m=13;break}c=d[j+12>>1]|0;if(c<<16>>16){i=c&65535;c=f[l>>2]|0;if((c|0)<(i|0))break;ZSc(a,l,i+-1|0,f[j>>2]|0,0);i=f[e>>2]|0}j=j+16|0;k=k+1|0}if((m|0)==13){t=n;return i|0}mSc(a,g,k+1|0,c);m=1;t=n;return m|0}function ZSc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=f[a>>2]|0;c=oSc(l,f[c+4+(d<<4)>>2]|0,0)|0;if(!c)return;_Sc(c,g);if((b[e>>0]|0)==112)h=$Sc(a,c,f[e+8>>2]|0)|0;else h=c;g=e+4|0;f[g>>2]=f[g>>2]|134217728;dzc(l,e);c=e;d=h;a=c+52|0;do{f[c>>2]=f[d>>2];c=c+4|0;d=d+4|0}while((c|0)<(a|0));c=f[g>>2]|0;if((c&1024|0)==0?(i=e+8|0,j=f[i>>2]|0,(j|0)!=0):0){c=UIc(l,j)|0;f[i>>2]=c;c=f[g>>2]|65536;f[g>>2]=c}if(c&16777216|0?(k=f[e+44>>2]|0,k|0):0)f[k+72>>2]=e;nxc(l,h);return}function _Sc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+32|0;c=d;if((b|0)<=0){t=d;return};f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[c+4>>2]=688;f[c+24>>2]=b;HRc(c,a)|0;t=d;return}function $Sc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;aTc(e,c);c=QQc(a,b,e,0)|0;t=d;return c|0}function aTc(a,b){a=a|0;b=b|0;f[a>>2]=b;b=Mxc(b)|0;f[a+4>>2]=b;return}function bTc(a,c){a=a|0;c=c|0;if((b[c>>0]|0)!=-89)return 0;c=c+2|0;b[c>>0]=(f[a+24>>2]|0)+(h[c>>0]|0);return 0}function cTc(a,b){a=a|0;b=b|0;if(!(f[b+4>>2]&16777216))return 0;gzc(f[b+44>>2]|0);return 0}function dTc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;e=t;t=t+16|0;d=e;c=f[(f[a>>2]|0)+124>>2]|0;if((c|0)>=(b|0)){d=0;t=e;return d|0}f[d>>2]=c;TIc(a,122075,d);d=1;t=e;return d|0}function eTc(a){a=a|0;var c=0,e=0;while(1){c=b[a>>0]|0;if((c|1)<<24>>24!=-83)break;a=f[a+12>>2]|0}if(c<<24>>24==-81)c=b[a+2>>0]|0;switch(c<<24>>24){case -90:{if(f[a+4>>2]&1048576|0){e=1;return e|0}c=f[a+44>>2]|0;if(!c){e=1;return e|0}e=d[a+32>>1]|0;if(e<<16>>16<=-1){e=0;return e|0}a=f[c+4>>2]|0;if(!a){e=0;return e|0}e=(b[a+((e<<16>>16)*20|0)+12>>0]|0)==0&1;return e|0}case -103:case -104:case 116:case -102:{e=0;return e|0}default:{e=1;return e|0}}return 0}function fTc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;h=t;t=t+16|0;g=h;c=f[c+24>>2]|0;if(!(c&32))c=(c&4|0)==0?((c&8|0)==0?123019:123047):123065;else c=123083;f[g>>2]=d;f[g+4>>2]=c;TIc(a,123101,g);if(!e){t=h;return}b[e>>0]=120;t=h;return}function gTc(a,c,e,g,i,j){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;aa=t;t=t+80|0;X=aa+64|0;W=aa+48|0;Y=aa+32|0;P=aa+24|0;U=aa+16|0;T=aa+8|0;S=aa;_=f[a>>2]|0;R=j+28|0;f[R>>2]=-1;if((c|0)!=0?(f[i+24>>2]&6|0)==0:0){m=f[_+20>>2]|0;n=_+16|0;l=0;while(1){if((l|0)>=(m|0)){k=0;break}k=f[n>>2]|0;if(!(wzc(f[k+(l<<4)>>2]|0,c)|0)){$=6;break}l=l+1|0}if(($|0)==6)k=f[k+(l<<4)+12>>2]|0;if((l|0)==(m|0)?(wzc(120709,c)|0)==0:0){k=f[n>>2]|0;M=f[k>>2]|0;k=f[k+12>>2]|0}else M=c}else{M=0;k=0}I=(M|0)==0;J=(e|0)==0;Q=j+32|0;A=(e|0)!=0;N=a+200|0;E=j+44|0;B=a+120|0;C=a+144|0;F=a+145|0;Z=j+4|0;H=j+1|0;K=a+136|0;L=a+140|0;l=i;m=0;D=0;n=0;a:while(1){z=f[l+4>>2]|0;if(z){x=z+8|0;y=0;c=0;while(1){if((y|0)>=(f[z>>2]|0))break;w=f[x+16>>2]|0;o=f[x+20>>2]|0;if((o|0)!=0?(f[o+4>>2]&2048|0)!=0:0){r=f[o+28>>2]|0;q=f[r>>2]|0;p=0;o=0;while(1){if((p|0)>=(q|0))break;if(rTc(r+4+(p<<4)|0,g,e,M)|0){d[Q>>1]=p;o=1;c=c+1|0;m=2;n=x}p=p+1|0}if(A&(o|0)==0)$=23}else $=23;b:do if(($|0)==23){$=0;if(!I?(f[w+72>>2]|0)!=(k|0):0)break;if(!J){o=f[x+12>>2]|0;p=(o|0)==0;if(p)o=f[w>>2]|0;if(wzc(o,e)|0)break;if(!(p|(h[N>>0]|0)<2))ORc(a,0,E)}v=m+1|0;n=(m|0)==0?x:n;p=sTc(g)|0;q=d[w+42>>1]|0;r=(c|0)==1;s=x+36|0;u=x+48|0;m=f[w+4>>2]|0;o=0;while(1){if((o|0)>=(q|0)){m=v;break b}if((b[m+15>>0]|0)==p<<24>>24?(wzc(f[m>>2]|0,g)|0)==0:0){if(!r)break;if((b[s>>0]&4)==0?(tTc(f[u>>2]|0,g)|0)==0:0)break}m=m+20|0;o=o+1|0}d[Q>>1]=(o|0)==(d[w+40>>1]|0)?-1:o&65535;m=v;c=c+1|0;n=x}while(0);x=x+72|0;y=y+1|0}if(!n){p=m;r=0}else{f[R>>2]=f[n+40>>2];k=f[n+16>>2]|0;f[E>>2]=k;if(b[n+36>>0]&8)f[Z>>2]=f[Z>>2]|1048576;k=f[k+72>>2]|0;p=m;r=n}}else{p=m;c=0;r=n}if(I&(c|0)==0){c=f[B>>2]|0;do if(c){m=b[C>>0]|0;n=m<<24>>24!=127;if(A&n?(wzc(122781,e)|0)==0:0){f[R>>2]=1;break}if(A&m<<24>>24!=126?(wzc(122785,e)|0)==0:0){f[R>>2]=0;break}if((b[F>>0]|0)!=0?(f[l+24>>2]&1024|0)!=0:0)f[R>>2]=n&1;else c=0}else c=0;while(0);if((A&(f[l+24>>2]&512|0)!=0?(O=f[l+8>>2]|0,(O|0)!=0):0)?(wzc(122789,e)|0)==0:0){q=f[(f[O+32>>2]|0)+24>>2]|0;f[R>>2]=2}else q=c;if(q){o=sTc(g)|0;k=f[q+72>>2]|0;m=p+1|0;p=d[q+42>>1]|0;c=0;n=f[q+4>>2]|0;while(1){if((c|0)>=(p|0))break;if((b[n+15>>0]|0)==o<<24>>24?(wzc(f[n>>2]|0,g)|0)==0:0){$=65;break}c=c+1|0;n=n+20|0}if(($|0)==65){$=0;c=(c|0)==(d[q+40>>1]|0)?-1:c}if((c|0)>=(p|0)?(uTc(g)|0)!=0:0)n=(f[q+36>>2]&512|0)==0?-1:c;else n=c;if((n|0)<(p|0)){$=71;break}else c=0}else{m=p;c=0}}else m=p;n=l+24|0;if((r|0)!=0&((m|0)==1&(c|0)==0))if(((f[n>>2]&40|0)==0?(uTc(g)|0)!=0:0)?(f[(f[r+16>>2]|0)+36>>2]&512|0)==0:0){$=86;break}else{c=0;m=1}q=f[n>>2]|0;c:do if(J&((c|0)==0&(q&128|0)!=0)){o=f[l+8>>2]|0;c=f[o>>2]|0;n=0;while(1){if((n|0)>=(c|0))break c;p=f[o+4+(n<<4)+4>>2]|0;if((b[o+4+(n<<4)+9>>0]&3)==0?(zHc(p,g)|0)==0:0){$=92;break a}n=n+1|0}}else switch(c|0){case 1:{$=117;break a}case 0:break;default:{m=122916;$=111;break a}}while(0);l=f[l+12>>2]|0;if(!l){$=104;break}else{D=D+1|0;n=r}}do if(($|0)==71){c=q+42|0;m=f[R>>2]|0;if((m|0)==2)if((h[N>>0]|0)>1){d[Q>>1]=n;f[E>>2]=q;m=1;n=-90;$=119;break}else{m=f[(f[l+8>>2]|0)+36>>2]|0;m=m+((vTc(q,n&65535)|0)<<16>>16)|0;f[R>>2]=m;m=1;n=-81;$=119;break}f[E>>2]=q;if(b[F>>0]|0){$=f[l+8>>2]|0;m=V((d[c>>1]|0)+1|0,m)|0;m=$+1+((vTc(q,n&65535)|0)<<16>>16)+m|0;f[R>>2]=m;m=1;n=-81;$=119;break}d[Q>>1]=n;if((n|0)<0){b[H>>0]=68;m=1;n=77;$=119;break}c=(n|0)>31?-1:1<<n;if(!m){f[K>>2]=f[K>>2]|c;m=1;n=77;$=119;break}else{f[L>>2]=f[L>>2]|c;m=1;n=77;$=119;break}}else if(($|0)==86){d[Q>>1]=-1;b[H>>0]=68;c=1;$=117}else if(($|0)==92){c=f[o+4+(n<<4)>>2]|0;m=f[c+4>>2]|0;if(!((q&1|0)!=0|(m&16|0)==0)){f[S>>2]=p;TIc(a,122798,S);j=2;t=aa;return j|0}if(m&32768|0?!((l|0)==(i|0)&(q&16384|0)!=0):0){f[T>>2]=p;TIc(a,122829,T);j=2;t=aa;return j|0}if((mTc(c)|0)==1){ZSc(a,o,n,j,D);if((h[N>>0]|0)<=1)break;ORc(a,0,j);break}else{TIc(a,122503,U);j=2;t=aa;return j|0}}else if(($|0)==104)if(J){do if(f[Z>>2]&64|0?wTc(_,i)|0:0){if(b[_+170>>0]&8?(wzc(g,f[f[_+172>>2]>>2]|0)|0)==0:0)break;f[P>>2]=g;dxc(28,122866,P);b[j>>0]=116;f[E>>2]=0;j=1;t=aa;return j|0}while(0);if(dQc(j)|0){j=1;t=aa;return j|0}else{l=0;c=0;m=122901;$=111}}else{l=0;c=0;m=122901;$=111}while(0);if(($|0)==111){do if(I)if(J){f[X>>2]=m;f[X+4>>2]=g;TIc(a,122961,X);break}else{f[W>>2]=m;f[W+4>>2]=e;f[W+8>>2]=g;TIc(a,122951,W);break}else{f[Y>>2]=m;f[Y+4>>2]=M;f[Y+8>>2]=e;f[Y+12>>2]=g;TIc(a,122938,Y)}while(0);b[a+17>>0]=1;$=i+20|0;f[$>>2]=(f[$>>2]|0)+1;$=117}if(($|0)==117)if((r|0)!=0&(d[Q>>1]|0)>-1){$=xTc(j)|0;m=r+56|0;Y=m;n=f[Y+4>>2]|G;f[m>>2]=f[Y>>2]|$;f[m+4>>2]=n;m=c;n=-90;$=119}else{m=c;n=-90;$=119}if(($|0)==119){c=f[Z>>2]|0;if(!(c&8404992)){c=j+12|0;dzc(_,f[c>>2]|0);f[c>>2]=0;c=j+16|0;dzc(_,f[c>>2]|0);f[c>>2]=0;c=f[Z>>2]|0}b[j>>0]=n;f[Z>>2]=c|8388608;if((m|0)!=1){j=2;t=aa;return j|0}}d:do if(f[(f[a>>2]|0)+336>>2]|0){switch(b[j>>0]|0){case 77:case -90:break;default:break d}yTc(a,j,k,f[l+4>>2]|0)}while(0);while(1){j=i+16|0;f[j>>2]=(f[j>>2]|0)+1;if((i|0)==(l|0)){i=1;break}i=f[i+12>>2]|0}t=aa;return i|0}function hTc(a){a=a|0;var c=0,d=0.0,e=0;e=t;t=t+16|0;c=e;p[c>>3]=-1.0;if((b[a>>0]|0)==-104?(a=f[a+8>>2]|0,pyc(a,c,Mxc(a)|0,1)|0,d=+p[c>>3],!(d>1.0)):0)a=~~(d*134217728.0);else a=-1;t=e;return a|0}function iTc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;k=t;t=t+16|0;j=k;h=f[a>>2]|0;i=f[h+336>>2]|0;do if(((i|0)!=0?(b[h+169>>0]|0)==0:0)?(b[a+200>>0]|0)==0:0){c=Bd[i&127](f[h+340>>2]|0,c,d,e,g,f[a+240>>2]|0)|0;if((c|0)==1){TIc(a,120542,j);f[a+12>>2]=23;c=1;break}if((c|2|0)!=2){qTc(a);c=1}}else c=0;while(0);t=k;return c|0}function jTc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if(!(f[b+4>>2]&1073741824)){t=e;return}if((f[c+4>>2]&524288|0)==0?!(0==0?(f[(f[a>>2]|0)+32>>2]&128|0)==0:0):0){t=e;return}f[d>>2]=f[c+32>>2];TIc(a,122739,d);t=e;return}function kTc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;j=l+8|0;h=l;g=f[d>>2]|0;k=d+16|0;do if((g|0)!=0?(b[k>>0]|0)==0:0){c=pTc(a,c,g)|0;if(!c){t=l;return}else{g=LSc(f[a>>2]|0,f[c+8>>2]|0,0)|0;f[d+8>>2]=g;g=LSc(f[a>>2]|0,f[c+12>>2]|0,0)|0;f[d+12>>2]=g;g=oSc(f[a>>2]|0,f[c+24>>2]|0,0)|0;f[d+24>>2]=g;g=oSc(f[a>>2]|0,f[c+28>>2]|0,0)|0;f[d+28>>2]=g;b[d+17>>0]=b[c+17>>0]|0;b[d+18>>0]=b[c+18>>0]|0;g=b[c+16>>0]|0;b[k>>0]=g;b[d+20>>0]=b[c+20>>0]|0;c=g;break}}else i=5;while(0);if((i|0)==5){zRc(a,d,c);c=b[k>>0]|0}do if(c<<24>>24==89){if((f[d+24>>2]|0)==0?(f[d+28>>2]|0)==0:0){i=12;break}g=f[d+12>>2]|0;if(g|0?(f[g>>2]|0)==1:0){i=12;break}TIc(a,122521,h)}else i=12;while(0);a:do if((i|0)==12?f[e+4>>2]&65536|0:0){h=f[a>>2]|0;if(f[d+40>>2]|0){TIc(a,122592,j);break}c=e+32|0;g=0;while(1){if(g>>>0>=8)break a;if((f[c>>2]|0)==(f[13232+(g<<4)>>2]|0))break;g=g+1|0}c=d+24|0;dzc(h,f[c>>2]|0);j=d+28|0;dzc(h,f[j>>2]|0);f[c>>2]=0;f[j>>2]=0;b[k>>0]=f[13232+(g<<4)+4>>2];k=f[13232+(g<<4)+8>>2]&255;b[d+17>>0]=k;b[d+18>>0]=f[13232+(g<<4)+12>>2];b[d+20>>0]=0;if(k<<24>>24==86){k=wQc(h,154,121304)|0;f[c>>2]=k}}while(0);f[d+44>>2]=e;t=l;return}function lTc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+48|0;e=g+16|0;d=g;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;f[e+4>>2]=689;f[e+8>>2]=690;f[e+24>>2]=d;f[d>>2]=b;if((b|0)!=0?(f[b>>2]|0)!=0:0)b=f[b+48>>2]|0;else b=2147483647;f[d+4>>2]=b;c=d+8|0;f[c>>2]=0;b=d+12|0;f[b>>2]=0;KRc(e,f[a+20>>2]|0)|0;if(!(f[a+4>>2]&16777216)){a=f[c>>2]|0;a=(a|0)>0;e=f[b>>2]|0;e=(e|0)==0;e=a|e;e=e&1;t=g;return e|0}HRc(e,f[(f[a+44>>2]|0)+40>>2]|0)|0;a=f[c>>2]|0;a=(a|0)>0;e=f[b>>2]|0;e=(e|0)==0;e=a|e;e=e&1;t=g;return e|0}function mTc(a){a=a|0;var c=0;c=b[a>>0]|0;if(c<<24>>24==-81)c=b[a+2>>0]|0;switch(c<<24>>24){case -80:{c=a+20|0;break}case -119:{c=(f[a+20>>2]|0)+28|0;break}default:{a=1;return a|0}}a=f[f[c>>2]>>2]|0;return a|0}function nTc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;switch(b[c>>0]|0){case -88:case -90:break;default:return 0}e=f[a+24>>2]|0;g=f[e>>2]|0;if(!g)d=0;else d=f[g>>2]|0;c=f[c+28>>2]|0;a=0;while(1){if((a|0)>=(d|0))break;if((c|0)==(f[g+8+(a*72|0)+40>>2]|0)){h=7;break}else a=a+1|0}if((h|0)==7){h=e+8|0;f[h>>2]=(f[h>>2]|0)+1;return 0}if((c|0)>=(f[e+4>>2]|0))return 0;h=e+12|0;f[h>>2]=(f[h>>2]|0)+1;return 0}function oTc(a,b){a=a|0;b=b|0;var c=0;c=(f[a+24>>2]|0)+4|0;if((f[c>>2]|0)!=2147483647)return 0;a=f[b+32>>2]|0;if(!a)return 0;if(!(f[a>>2]|0))return 0;f[c>>2]=f[a+48>>2];return 0}function pTc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=t;t=t+16|0;d=g;while(1){if(!b)break;if(!(wzc(f[b>>2]|0,c)|0)){e=6;break}b=f[b+36>>2]|0}if((e|0)==6){t=g;return b|0}f[d>>2]=c;TIc(a,122720,d);e=0;t=g;return e|0}function qTc(a){a=a|0;var b=0;b=t;t=t+16|0;TIc(a,122758,b);f[a+12>>2]=1;t=b;return}function rTc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;if((b[a+9>>0]&3)!=2){d=0;return d|0}g=f[a+4>>2]|0;a=0;a:while(1){switch(b[g+a>>0]|0){case 46:case 0:break a;default:{}}a=a+1|0}if(e|0){if(QBc(g,e,a)|0){d=0;return d|0}if(b[e+a>>0]|0){d=0;return d|0}}g=g+(a+1)|0;a=0;b:while(1){switch(b[g+a>>0]|0){case 46:case 0:break b;default:{}}a=a+1|0}if(d|0){if(QBc(g,d,a)|0){d=0;return d|0}if(b[d+a>>0]|0){d=0;return d|0}}if(c|0?wzc(g+(a+1)|0,c)|0:0){d=0;return d|0}d=1;return d|0}function sTc(a){a=a|0;var c=0,d=0;if(!a){d=0;return d|0}c=0;while(1){d=b[a>>0]|0;if(!(d<<24>>24))break;c=(h[1680+(d&255)>>0]|0)+(c&255)&255;a=a+1|0}return c|0}function tTc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!a){d=0;return d|0}d=f[a+4>>2]|0;c=0;while(1){if((c|0)>=(d|0)){c=0;a=5;break}if(!(wzc(f[(f[a>>2]|0)+(c<<3)>>2]|0,b)|0)){c=1;a=5;break}else c=c+1|0}if((a|0)==5)return c|0;return 0}function uTc(a){a=a|0;if(!(wzc(a,123007)|0)){a=1;return a|0}if(!(wzc(a,122968)|0)){a=1;return a|0}a=(wzc(a,123015)|0)==0&1;return a|0}function vTc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0;if(!(f[a+36>>2]&32)){h=b;return h|0}h=b<<16>>16;if(b<<16>>16<0){h=b;return h|0}g=f[a+4>>2]|0;b=0;c=0;while(1){e=d[g+(c*20|0)+16>>1]&32;if((c|0)==(h|0))break;b=((e&65535)>>>5^1)+b<<16>>16;c=c+1|0}if(!(e<<16>>16)){h=b;return h|0}h=h-(b&65535)+(j[a+44>>1]|0)&65535;return h|0}function wTc(a,c){a=a|0;c=c|0;var d=0;if(b[a+169>>0]|0){c=1;return c|0}if(!(f[c+24>>2]&65536)){c=a+32|0;c=Grd(f[c>>2]|0,f[c+4>>2]|0,30)|0;c=c&1;return c|0}d=(uPc(a)|0)==0;a=a+32|0;c=f[a>>2]|0;a=f[a+4>>2]|0;if(!d){a=Grd(c|0,a|0,29)|0;if(!((c&1073741824|0)==0&0==0)){d=1;return d|0}}else a=Grd(c|0,a|0,29)|0;d=a&1;return d|0}function xTc(a){a=a|0;var b=0;b=d[a+32>>1]|0;a=f[a+44>>2]|0;if(f[a+36>>2]&96|0?d[(f[a+4>>2]|0)+((b<<16>>16)*20|0)+16>>1]&96:0){b=d[a+42>>1]|0;a=b<<16>>16>63;b=Hrd(1,0,b<<16>>16|0)|0;b=vrd(b|0,G|0,-1,-1)|0;G=a?-1:G;return (a?-1:b)|0}b=Hrd(1,0,(b<<16>>16<63?b:63)<<16>>16|0)|0;return b|0}function yTc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;k=zTc(f[a>>2]|0,e)|0;if((k|0)<0)return;do if((b[c>>0]|0)!=77){e=f[g>>2]|0;h=c+28|0;i=0;while(1){if((i|0)>=(e|0)){j=16;break}if((f[h>>2]|0)==(f[g+8+(i*72|0)+40>>2]|0)){j=7;break}i=i+1|0}if((j|0)==7){e=g+8+(i*72|0)+16|0;break}else if((j|0)==16)return}else e=a+120|0;while(0);h=f[e>>2]|0;e=d[c+32>>1]|0;if(!h)return;if(e<<16>>16<=-1){e=d[h+40>>1]|0;if(e<<16>>16>-1){e=e<<16>>16;j=13}else e=122968}else{e=e<<16>>16;j=13}if((j|0)==13)e=f[(f[h+4>>2]|0)+(e*20|0)>>2]|0;if((ATc(a,f[h>>2]|0,e,k)|0)!=2)return;b[c>>0]=120;return}function zTc(a,b){a=a|0;b=b|0;var c=0;if(!b){b=-32768;return b|0}c=f[a+16>>2]|0;a=0;while(1)if((f[c+(a<<4)+12>>2]|0)==(b|0))break;else a=a+1|0;return a|0}function ATc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+32|0;l=m+16|0;k=m+8|0;h=m;i=f[a>>2]|0;j=f[(f[i+16>>2]|0)+(e<<4)>>2]|0;if(b[i+169>>0]|0){l=0;t=m;return l|0}g=Bd[f[i+336>>2]&127](f[i+340>>2]|0,20,c,d,j,f[a+240>>2]|0)|0;if((g|0)==1){f[h>>2]=c;f[h+4>>2]=d;c=WAc(120580,h)|0;if(e|0?1:(f[i+20>>2]|0)>2){f[k>>2]=j;f[k+4>>2]=c;c=WAc(122974,k)|0}f[l>>2]=c;TIc(a,122980,l);f[a+12>>2]=23;l=1;t=m;return l|0}else{if((g|2|0)==2){l=g;t=m;return l|0}qTc(a);l=g;t=m;return l|0}return 0}function BTc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;l=n;m=c+52|0;if(!(f[m>>2]|0)){m=0;t=n;return m|0}h=f[c+48>>2]|0;if(!h){m=0;t=n;return m|0}e=c;a:while(1){if(!e){g=0;i=14;break}switch(b[e>>0]|0){case -119:case -122:break;default:break a}e=f[e+52>>2]|0}if((i|0)==14){t=n;return g|0}if(d[h+16>>1]|0){m=0;t=n;return m|0}e=f[h>>2]|0;do{if((e|0)<=0){g=0;i=14;break}e=e+-1|0}while(!(f[(f[h+4+(e<<4)>>2]|0)+4>>2]&256|0));if((i|0)==14){t=n;return g|0}i=f[a>>2]|0;j=f[i>>2]|0;k=$Ec(j,76,0)|0;if(!k){m=2;t=n;return m|0}e=l;f[e>>2]=0;f[e+4>>2]=0;e=rQc(i,0,0,0,l,k,0,0)|0;if(!e){m=2;t=n;return m|0}g=k;a=c;h=g+76|0;do{f[g>>2]=f[a>>2];g=g+4|0;a=a+4|0}while((g|0)<(h|0));f[c+32>>2]=e;l=tQc(i,0,wQc(j,179,0)|0)|0;f[c+28>>2]=l;b[c>>0]=-119;f[c+36>>2]=0;f[k+40>>2]=0;f[k+44>>2]=0;f[k+48>>2]=0;f[m>>2]=0;f[c+56>>2]=0;f[c+64>>2]=0;f[c+72>>2]=0;m=c+4|0;f[m>>2]=f[m>>2]&-65793|65536;f[(f[k+52>>2]|0)+56>>2]=k;f[k+60>>2]=0;m=0;t=n;return m|0}function CTc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;W=t;t=t+80|0;V=W+64|0;Q=W+56|0;P=W+48|0;O=W+32|0;R=W+24|0;q=W+16|0;p=W+8|0;r=W;L=W+72|0;S=f[a>>2]|0;T=f[S>>2]|0;U=c+4|0;e=f[U>>2]|0;f[U>>2]=e|64;N=T+83|0;if(b[N>>0]|0){V=2;t=W;return V|0}if(e&64|0){V=1;t=W;return V|0}l=a+20|0;if(d[l>>1]|0){K=S+100|0;M=(f[K>>2]|0)+1|0;f[K>>2]=M;f[c+16>>2]=M}H=f[c+32>>2]|0;M=c+28|0;I=f[M>>2]|0;wRc(S,f[c+64>>2]|0,0);FTc(S,H);J=H+8|0;m=T+32|0;K=T+16|0;j=0;k=J;a:while(1){if((j|0)>=(f[H>>2]|0)){G=34;break}i=k+16|0;if(!(f[i>>2]|0)){do if(!(f[k+8>>2]|0)){if(JRc(a,f[k+20>>2]|0)|0){e=2;G=99;break a}if(GTc(S,k)|0){e=2;G=99;break a}}else{e=HTc(S,a,k)|0;if(e|0)if((e|0)>1){e=2;G=99;break a}else break;n=ITc(S,0,k)|0;f[i>>2]=n;if(!n){e=2;G=99;break a}e=n+32|0;g=f[e>>2]|0;if(g>>>0>65534){G=15;break a}f[e>>2]=g+1;e=n+56|0;if(!(f[e>>2]|0)){if(JTc(S,k)|0){e=2;G=99;break a}if((f[e>>2]|0)==0?(f[n+12>>2]|0)==0:0)break}g=d[l>>1]|0;if(KTc(S,n)|0){e=2;G=99;break a}i=n+12|0;if((f[i>>2]|0?(f[m>>2]|0)>-1:0)?(f[n+72>>2]|0)!=(f[(f[K>>2]|0)+28>>2]|0):0){f[p>>2]=f[n>>2];TIc(S,123160,p)}if(((f[e>>2]|0?b[k+37>>0]&64:0)?(o=f[n+64>>2]|0,o|0):0)?(G=h[o+17>>0]|0,F=m,F=Grd(f[F>>2]|0,f[F+4>>2]|0,7)|0,(F&1)>>>0<G>>>0):0){f[q>>2]=f[n>>2];TIc(S,123191,q)}E=KSc(T,f[i>>2]|0,0)|0;f[k+20>>2]=E;G=n+42|0;F=d[G>>1]|0;d[G>>1]=-1;d[l>>1]=1;JRc(a,E)|0;d[l>>1]=g&255;d[G>>1]=F}while(0);if(b[k+37>>0]&2?LTc(S,k)|0:0){e=2;G=99;break}}j=j+1|0;k=k+72|0}if((G|0)==15){f[r>>2]=f[n>>2];TIc(S,123121,r);f[i>>2]=0;V=2;t=W;return V|0}else if((G|0)==34){if(f[S+36>>2]|0){V=2;t=W;return V|0}if(b[N>>0]|0){V=2;t=W;return V|0}if(MTc(S,c)|0){V=2;t=W;return V|0}j=f[I>>2]|0;e=0;g=0;b:while(1){if((e|0)>=(j|0)){G=93;break}i=f[I+4+(e<<4)>>2]|0;switch(b[i>>0]|0){case -77:{G=42;break b}case -116:{if((b[f[i+16>>2]>>0]|0)==-77){G=42;break b}break}default:{}}e=e+1|0;g=f[i+4>>2]|g}if((G|0)==42){E=0==0?(f[(f[S>>2]|0)+32>>2]&68|0)==4:0;F=S+200|0;e=0;D=0;i=j;while(1){if((D|0)>=(i|0))break;j=I+4+(D<<4)|0;i=f[j>>2]|0;g=f[i+4>>2]|g;switch(b[i>>0]|0){case -77:{y=0;G=50;break}case -116:{if((b[f[i+16>>2]>>0]|0)==-77){y=f[(f[i+12>>2]|0)+8>>2]|0;G=50}else G=46;break}default:G=46}do if((G|0)==46){e=tQc(S,e,i)|0;if(e|0){G=I+4+(D<<4)+4|0;C=(f[e>>2]|0)+-1|0;f[e+4+(C<<4)+4>>2]=f[G>>2];C=e+4+(C<<4)+9|0;b[C>>0]=b[C>>0]&-4|b[I+4+(D<<4)+9>>0]&3;f[G>>2]=0}f[j>>2]=0}else if((G|0)==50){B=(y|0)==0;C=(y|0)!=0;i=0;z=0;A=J;while(1){if((z|0)>=(f[H>>2]|0))break;l=f[A+16>>2]|0;k=f[A+20>>2]|0;j=f[A+12>>2]|0;if(!j)j=f[l>>2]|0;if(b[N>>0]|0)break;if((k|0)!=0?(f[k+4>>2]&2048|0)!=0:0){x=0;G=61}else G=57;do if((G|0)==57){G=0;if(!B?wzc(y,j)|0:0)break;k=zTc(T,f[l+72>>2]|0)|0;if((k|0)>-1){x=f[(f[K>>2]|0)+(k<<4)>>2]|0;k=0;G=61}else{x=123224;k=0;G=61}}while(0);c:do if((G|0)==61){G=0;w=l+42|0;s=l+4|0;u=(k|0)!=0;v=C&u;o=k+28|0;r=B&(z|0)!=0;p=A+36|0;q=A+48|0;c=(x|0)==0;a=0;while(1){if((a|0)>=(d[w>>1]|0))break c;k=f[s>>2]|0;l=f[k+(a*20|0)>>2]|0;if(!(v?(rTc((f[o>>2]|0)+4+(a<<4)|0,0,y,0)|0)==0:0))G=65;do if((G|0)==65){G=0;if((f[U>>2]&131072|0)==0?d[k+(a*20|0)+16>>1]&2:0)break;if(r){if(b[p>>0]&4?NTc(H,z,l,0,0,1)|0:0){i=1;break}if((OTc(f[q>>2]|0,l)|0)>-1){i=1;break}}i=wQc(T,59,l)|0;if(!E?(f[H>>2]|0)<=1:0){n=0;m=l}else G=73;do if((G|0)==73){G=0;i=bQc(S,140,wQc(T,59,j)|0,i)|0;if(!c)i=bQc(S,140,wQc(T,59,x)|0,i)|0;if(!E){n=0;m=l;break}f[R>>2]=j;f[R+4>>2]=l;m=YMc(T,120580,R)|0;n=m}while(0);e=tQc(S,e,i)|0;aTc(L,m);uQc(S,e,L,0);do if(e|0){if(!(f[U>>2]&2048))break;if((h[F>>0]|0)>1)break;k=(f[e>>2]|0)+-1|0;l=e+4+(k<<4)+4|0;nxc(T,f[l>>2]|0);if(u)i=UIc(T,f[(f[o>>2]|0)+4+(a<<4)+4>>2]|0)|0;else{f[O>>2]=x;f[O+4>>2]=j;f[O+8>>2]=m;i=YMc(T,123226,O)|0}f[l>>2]=i;m=e+4+(k<<4)+9|0;b[m>>0]=b[m>>0]&-4|2}while(0);nxc(T,n);i=1}while(0);a=a+1|0}}while(0);z=z+1|0;A=A+72|0}if(!i)if(B){TIc(S,123253,Q);break}else{f[P>>2]=y;TIc(S,123235,P);break}}while(0);D=D+1|0;i=f[I>>2]|0}$yc(T,I);f[M>>2]=e}else if((G|0)==93)e=f[M>>2]|0;if(!e){V=0;t=W;return V|0}if((f[e>>2]|0)>(f[T+120>>2]|0)){TIc(S,123273,V);V=2;t=W;return V|0}if(!(g&2097156)){V=0;t=W;return V|0}f[U>>2]=f[U>>2]|262144;V=0;t=W;return V|0}else if((G|0)==99){t=W;return e|0}return 0}function DTc(a,b){a=a|0;b=b|0;var c=0;c=(f[a>>2]|0)+260|0;if(!(f[c>>2]|0))return;if(f[b+52>>2]|0)return;a=(ETc(b)|0)+64|0;a=f[a>>2]|0;if(!a)return;f[c>>2]=f[a+4>>2];return}function ETc(a){a=a|0;var b=0;while(1){b=f[a+56>>2]|0;if(!b)break;else a=b}return a|0}function FTc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;if(!b)return;g=a+40|0;c=b+8|0;d=0;while(1){if((d|0)>=(f[b>>2]|0))break;h=c+40|0;if((f[h>>2]|0)<=-1?(e=f[g>>2]|0,f[g>>2]=e+1,f[h>>2]=e,e=f[c+20>>2]|0,e|0):0)FTc(a,f[e+32>>2]|0);c=c+72|0;d=d+1|0}return}function GTc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0;i=t;t=t+16|0;g=i;c=f[b+20>>2]|0;h=$Ec(f[a>>2]|0,76,0)|0;f[b+16>>2]=h;if(!h){h=7;t=i;return h|0}f[h+32>>2]=1;b=f[b+12>>2]|0;e=f[a>>2]|0;if(!b){f[g>>2]=f[c+16>>2];b=YMc(e,125690,g)|0}else b=UIc(e,b)|0;f[h>>2]=b;while(1){b=f[c+52>>2]|0;if(!b)break;else c=b}VTc(a,f[c+28>>2]|0,h+42|0,h+4|0);d[h+40>>1]=-1;d[h+46>>1]=200;h=h+36|0;f[h>>2]=f[h>>2]|16384;h=(f[a+36>>2]|0)!=0&1;t=i;return h|0}function HTc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=t;t=t+32|0;A=C+16|0;q=C+8|0;h=C;s=C+28|0;B=a+260|0;g=f[B>>2]|0;if(!g){B=0;t=C;return B|0}if(f[e+4>>2]|0){B=0;t=C;return B|0}w=IUc(g,e,s)|0;if(!w){B=0;t=C;return B|0}i=f[a>>2]|0;z=w+12|0;g=f[z>>2]|0;if(g|0){f[h>>2]=f[w>>2];TIc(a,g,h);B=2;t=C;return B|0}if(JTc(a,e)|0){B=2;t=C;return B|0}v=$Ec(i,76,0)|0;if(!v){B=2;t=C;return B|0}h=w+16|0;g=f[h>>2]|0;do if(!g){g=$Ec(i,20,0)|0;f[h>>2]=g;if(g|0?JUc(a,757,g)|0:0){b[g+18>>0]=b[w+20>>0]|0;break}nxc(i,v);B=2;t=C;return B|0}while(0);f[e+16>>2]=v;n=v+32|0;f[n>>2]=1;u=UIc(i,f[w>>2]|0)|0;f[v>>2]=u;d[v+40>>1]=-1;d[v+46>>1]=200;u=v+36|0;f[u>>2]=f[u>>2]|16896;u=KSc(i,f[w+8>>2]|0,0)|0;f[e+20>>2]=u;if(b[i+83>>0]|0){B=2;t=C;return B|0}o=e+37|0;b[o>>0]=b[o>>0]|-128;f[e+68>>2]=g;o=f[g>>2]|0;f[g>>2]=o+1;if((o|0)>0?(j=g+18|0,(b[j>>0]|0)==1):0)b[j>>0]=0;o=((b[u>>0]|0)+123&255)<2;k=a+40|0;g=-1;h=u;a:while(1){if(!o){h=u;break}if((b[h>>0]|0)!=(b[u>>0]|0))break;l=f[h+32>>2]|0;m=h+4|0;j=f[l>>2]|0;e=0;while(1){if((e|0)>=(j|0))break;if(((f[l+8+(e*72|0)+4>>2]|0)==0?(p=f[l+8+(e*72|0)+8>>2]|0,(p|0)!=0):0)?(wzc(p,f[w>>2]|0)|0)==0:0){f[l+8+(e*72|0)+16>>2]=v;f[n>>2]=(f[n>>2]|0)+1;i=l+8+(e*72|0)+37|0;b[i>>0]=b[i>>0]|32;i=f[m>>2]|0;if(i&8192|0){r=29;break a}f[m>>2]=i|8192;if((g|0)<0){g=f[k>>2]|0;f[k>>2]=g+1}f[l+8+(e*72|0)+40>>2]=g}e=e+1|0}if(!(f[m>>2]&8192))break;h=f[h+52>>2]|0}if((r|0)==29){f[q>>2]=f[w>>2];TIc(a,125514,q);B=2;t=C;return B|0}f[z>>2]=125557;e=f[B>>2]|0;g=f[s>>2]|0;f[B>>2]=g;i=u+4|0;if(!(f[i>>2]&8192)){if(JRc(c,u)|0){f[B>>2]=e;B=2;t=C;return B|0}}else{r=h+64|0;f[r>>2]=f[u+64>>2];s=JRc(c,h)|0;f[r>>2]=0;if(s|0){f[B>>2]=e;B=2;t=C;return B|0}}f[B>>2]=g;g=u;while(1){h=f[g+52>>2]|0;if(!h)break;else g=h}g=f[g+28>>2]|0;h=f[w+4>>2]|0;if(h)if((g|0)!=0?(x=f[g>>2]|0,y=f[h>>2]|0,(x|0)!=(y|0)):0){f[A>>2]=f[w>>2];f[A+4>>2]=x;f[A+8>>2]=y;TIc(a,125580,A);f[B>>2]=e;B=2;t=C;return B|0}else g=h;VTc(a,g,v+42|0,v+4|0);if(o){f[z>>2]=(f[i>>2]&8192|0)==0?125618:125656;JRc(c,u)|0}f[z>>2]=0;f[B>>2]=e;B=1;t=C;return B|0}function ITc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=f[c>>2]|0;if(!d)d=c+4|0;else{e=f[a>>2]|0;d=zTc(e,d)|0;d=(f[e+16>>2]|0)+(d<<4)|0}return ZTc(a,b,f[c+8>>2]|0,f[d>>2]|0)|0}function JTc(a,c){a=a|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if(!(b[c+37>>0]&4)){d=0;t=e;return d|0}f[d>>2]=f[c+8>>2];TIc(a,123682,d);d=1;t=e;return d|0}function KTc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=t;t=t+16|0;g=o;n=f[a>>2]|0;l=n+56|0;f[l>>2]=(f[l>>2]|0)+1;m=TTc(a,c)|0;f[l>>2]=(f[l>>2]|0)+-1;if(m|0){n=1;t=o;return n|0}if(f[c+56>>2]|0){n=0;t=o;return n|0}m=c+42|0;e=d[m>>1]|0;if(e<<16>>16>0){n=0;t=o;return n|0}if(e<<16>>16<0){f[g>>2]=f[c>>2];TIc(a,123491,g);n=1;t=o;return n|0}g=KSc(n,f[c+12>>2]|0,0)|0;if(!g)e=1;else{j=a+200|0;k=b[j>>0]|0;b[j>>0]=0;e=a+40|0;p=f[e>>2]|0;FTc(a,f[g+32>>2]|0);d[m>>1]=-1;h=n+280|0;f[h>>2]=(f[h>>2]|0)+1;l=n+284|0;d[l>>1]=0;q=n+336|0;r=f[q>>2]|0;f[q>>2]=0;i=UTc(a,g,64)|0;f[q>>2]=r;f[e>>2]=p;do if(i){e=f[c+24>>2]|0;if(!e){r=i+42|0;d[m>>1]=d[r>>1]|0;e=i+4|0;f[c+4>>2]=f[e>>2];q=c+36|0;f[q>>2]=f[q>>2]|f[i+36>>2]&98;d[r>>1]=0;f[e>>2]=0;e=0;break}VTc(a,e,m,c+4|0);if(((b[n+83>>0]|0)==0?(f[a+36>>2]|0)==0:0)?(f[f[g+28>>2]>>2]|0)==(d[m>>1]|0):0){ZRc(a,c,g,64);e=0}else e=0}else{d[m>>1]=0;e=1}while(0);d[c+44>>1]=d[m>>1]|0;Iyc(n,i);_yc(n,g);r=(f[h>>2]|0)+-1|0;f[h>>2]=r;if(!r)g=d[n+286>>1]|0;else g=0;d[l>>1]=g;b[j>>0]=k}r=(f[c+72>>2]|0)+78|0;d[r>>1]=d[r>>1]|2;if(!(b[n+83>>0]|0)){r=e;t=o;return r|0}Zyc(n,c);f[c+4>>2]=0;d[m>>1]=0;r=e;t=o;return r|0}function LTc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=t;t=t+16|0;h=i;g=f[c+64>>2]|0;d=(f[c+16>>2]|0)+8|0;while(1){d=f[d>>2]|0;if(!d){e=5;break}if(!(wzc(f[d>>2]|0,g)|0)){e=6;break}d=d+20|0}if((e|0)==5){f[h>>2]=g;f[h+4>>2]=0;TIc(a,123473,h);b[a+17>>0]=1;h=1;t=i;return h|0}else if((e|0)==6){f[c+68>>2]=d;h=0;t=i;return h|0}return 0}function MTc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;y=t;t=t+32|0;x=y+16|0;w=y+8|0;v=y;r=y+24|0;s=y+20|0;u=f[b+32>>2]|0;q=b+36|0;l=u+80|0;m=0;n=u+8|0;a:while(1){if((m|0)>=((f[u>>2]|0)+-1|0)){b=0;c=28;break}p=f[l+16>>2]|0;b:do if(!((p|0)==0|(f[n+16>>2]|0)==0)){i=h[l+36>>0]|0;o=i&32;j=(o|0)==0;o=o>>>5;k=l+44|0;c:do if(i&4|0){if(f[k>>2]|0){c=7;break a}if(f[l+48>>2]|0){c=7;break a}c=p+42|0;e=p+4|0;g=m+1|0;b=0;while(1){if((b|0)>=(d[c>>1]|0))break c;i=f[e>>2]|0;if((d[i+(b*20|0)+16>>1]&2)==0?NTc(u,g,f[i+(b*20|0)>>2]|0,r,s,1)|0:0)QTc(a,u,f[r>>2]|0,f[s>>2]|0,g,b,o,q);b=b+1|0}}while(0);b=f[k>>2]|0;c=l+48|0;if(b|0){if(f[c>>2]|0){c=16;break a}if(!j){RTc(b,f[l+40>>2]|0);b=f[k>>2]|0}j=UQc(a,f[q>>2]|0,b)|0;f[q>>2]=j;f[k>>2]=0}c=f[c>>2]|0;if(c|0){e=c+4|0;g=m+1|0;b=0;while(1){if((b|0)>=(f[e>>2]|0))break b;j=f[(f[c>>2]|0)+(b<<3)>>2]|0;i=PTc(p,j)|0;if((i|0)<0){c=26;break a}if(!(NTc(u,g,j,r,s,0)|0)){c=26;break a}QTc(a,u,f[r>>2]|0,f[s>>2]|0,g,i,o,q);b=b+1|0}}}while(0);l=l+72|0;m=m+1|0;n=n+72|0}if((c|0)==7){f[v>>2]=0;TIc(a,123304,v);x=1;t=y;return x|0}else if((c|0)==16){TIc(a,123354,w);x=1;t=y;return x|0}else if((c|0)==26){f[x>>2]=j;TIc(a,123409,x);x=1;t=y;return x|0}else if((c|0)==28){t=y;return b|0}return 0}function NTc(a,b,c,e,g,h){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0;j=(h|0)==0;h=0;while(1){if((h|0)>=(b|0)){h=0;l=9;break}k=f[a+8+(h*72|0)+16>>2]|0;i=PTc(k,c)|0;if((i|0)>-1){if(j)break;if(!(d[(f[k+4>>2]|0)+(i*20|0)+16>>1]&2))break}h=h+1|0}if((l|0)==9)return h|0;if(!e){l=1;return l|0}f[e>>2]=h;f[g>>2]=i;l=1;return l|0}function OTc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!a){d=-1;return d|0}d=f[a+4>>2]|0;c=0;while(1){if((c|0)>=(d|0)){c=-1;a=6;break}if(!(wzc(f[(f[a>>2]|0)+(c<<3)>>2]|0,b)|0)){a=6;break}c=c+1|0}if((a|0)==6)return c|0;return 0}function PTc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;g=sTc(c)|0;h=d[a+42>>1]|0;e=f[a+4>>2]|0;a=0;while(1){if((a|0)>=(h|0)){a=-1;e=6;break}if((b[e+15>>0]|0)==g<<24>>24?(wzc(f[e>>2]|0,c)|0)==0:0){e=6;break}e=e+20|0;a=a+1|0}if((e|0)==6)return a|0;return 0}function QTc(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;j=f[a>>2]|0;c=STc(j,b,c,d)|0;b=STc(j,b,e,g)|0;c=bQc(a,53,c,b)|0;if(!((h|0)!=0&(c|0)!=0)){j=f[i>>2]|0;j=UQc(a,j,c)|0;f[i>>2]=j;return}j=c+4|0;f[j>>2]=f[j>>2]|1;f[c+36>>2]=f[b+28>>2];j=f[i>>2]|0;j=UQc(a,j,c)|0;f[i>>2]=j;return}function RTc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;while(1){if(!a)break;e=a+4|0;f[e>>2]=f[e>>2]|1;f[a+36>>2]=c;a:do if((b[a>>0]|0)==-85?(h=a+20|0,g=f[h>>2]|0,g|0):0){d=0;e=g;while(1){if((d|0)>=(f[e>>2]|0))break a;RTc(f[e+4+(d<<4)>>2]|0,c);d=d+1|0;e=f[h>>2]|0}}while(0);RTc(f[a+12>>2]|0,c);a=f[a+16>>2]|0}return}function STc(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0;a=xQc(a,166,0,0)|0;if(!a)return a|0;g=f[b+8+(c*72|0)+16>>2]|0;f[a+44>>2]=g;f[a+28>>2]=f[b+8+(c*72|0)+40>>2];if((d[g+40>>1]|0)==(e|0)){d[a+32>>1]=-1;return a|0}d[a+32>>1]=e;if(f[g+36>>2]&96|0?d[(f[g+4>>2]|0)+(e*20|0)+16>>1]&96:0){h=d[g+42>>1]|0;g=h<<16>>16>63;h=Hrd(1,0,h<<16>>16|0)|0;h=vrd(h|0,G|0,-1,-1)|0;e=b+8+(c*72|0)+56|0;f[e>>2]=g?-1:h;f[e+4>>2]=g?-1:G;return a|0}g=Hrd(1,0,((e|0)<63?e:63)|0)|0;h=b+8+(c*72|0)+56|0;c=h;e=f[c+4>>2]|G;f[h>>2]=f[c>>2]|g;f[h+4>>2]=e;return a|0}function TTc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;i=j+8|0;e=j;g=j+12|0;h=f[a>>2]|0;if(!(f[b+56>>2]|0)){i=0;t=j;return i|0}if(XTc(h,b)|0){i=0;t=j;return i|0}d=b+60|0;c=HIc(h+360|0,f[f[d>>2]>>2]|0)|0;if(!c){f[e>>2]=f[f[d>>2]>>2];TIc(a,123538,e);i=1;t=j;return i|0}f[g>>2]=0;c=YTc(h,b,c,f[(f[c>>2]|0)+8>>2]|0,g)|0;b=f[g>>2]|0;if(c|0){f[i>>2]=b;TIc(a,118856,i);f[a+12>>2]=c}nxc(h,b);i=c;t=j;return i|0}function UTc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;h=f[a>>2]|0;g=h+32|0;i=g;j=f[i>>2]|0;i=f[i+4>>2]|0;k=g;f[k>>2]=j&-69|64;f[k+4>>2]=i;RRc(a,c,0);f[g>>2]=j;f[g+4>>2]=i;if(f[a+36>>2]|0){k=0;return k|0}while(1){g=f[c+52>>2]|0;if(!g)break;else c=g}g=$Ec(h,76,0)|0;if(!g){k=0;return k|0}f[g+32>>2]=1;f[g>>2]=0;d[g+46>>1]=200;VTc(a,f[c+28>>2]|0,g+42|0,g+4|0);ZRc(a,g,c,e);d[g+40>>1]=-1;if(!(b[h+83>>0]|0)){k=g;return k|0}Iyc(h,g);k=0;return k|0}function VTc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;w=t;t=t+48|0;v=w+8|0;u=w;q=w+40|0;r=w+24|0;s=f[a>>2]|0;hJc(r);if(!c){k=0;n=0;p=0}else{k=f[c>>2]|0;p=$Ec(s,k*20|0,0)|0;k=(k|0)<32767?k:32767;n=p}d[e>>1]=k;f[g>>2]=p;m=s+83|0;l=n;o=0;while(1){if((o|0)>=(k|0))break;if(b[m>>0]|0)break;a=f[c+4+(o<<4)+4>>2]|0;if((a|0)!=0?(b[c+4+(o<<4)+9>>0]&3)==0:0)i=18;else i=8;do if((i|0)==8){i=0;h=kSc(f[c+4+(o<<4)>>2]|0)|0;a:while(1){switch(b[h>>0]|0){case -90:{i=11;break a}case 59:{i=16;break a}case -116:break;default:break a}h=f[h+16>>2]|0}if((i|0)==11){i=f[h+44>>2]|0;if(i){a=d[h+32>>1]|0;if(a<<16>>16<0)a=d[i+40>>1]|0;else a=a<<16>>16;if((a|0)<=-1){a=121236;i=18;break}a=f[(f[i+4>>2]|0)+(a*20|0)>>2]|0}}else if((i|0)==16)a=f[h+8>>2]|0;if(!a)i=20;else i=18}while(0);if((i|0)==18){i=0;if(!(WTc(a)|0))a=UIc(s,a)|0;else i=20}if((i|0)==20){f[u>>2]=o+1;a=YMc(s,123521,u)|0}f[q>>2]=0;while(1){if(!a){i=34;break}if(!(HIc(r,a)|0)){i=32;break}h=Mxc(a)|0;if((h|0)>0){i=h;do{x=i;i=i+-1|0;j=b[a+i>>0]|0;if((x|0)<=1)break}while(((j&255)+-48|0)>>>0<10);h=j<<24>>24==58?i:h}x=(f[q>>2]|0)+1|0;f[q>>2]=x;f[v>>2]=h;f[v+4>>2]=a;f[v+8>>2]=x;a=YMc(s,123530,v)|0;if((f[q>>2]|0)>>>0>3)$Ac(4,q)}if((i|0)==32){f[l>>2]=a;x=sTc(a)|0;b[l+15>>0]=x;if((Wyc(r,a,l)|0)==(l|0))Cxc(s)}else if((i|0)==34){f[l>>2]=0;x=sTc(0)|0;b[l+15>>0]=x}l=l+20|0;o=o+1|0}vzc(r);if(!(b[m>>0]|0)){t=w;return}a=0;while(1){if((a|0)==(o|0))break;nxc(s,f[n+(a*20|0)>>2]|0);a=a+1|0}nxc(s,p);f[g>>2]=0;d[e>>1]=0;t=w;return}function WTc(a){a=a|0;if(!(wzc(a,143389)|0)){a=268435456;return a|0}a=(wzc(a,143383)|0)==0;a=a?536870912:0;return a|0}function XTc(a,b){a=a|0;b=b|0;b=b+64|0;while(1){b=f[b>>2]|0;if(!b){b=0;a=5;break}if((f[b>>2]|0)==(a|0)){a=5;break}b=b+24|0}if((a|0)==5)return b|0;return 0}function YTc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;x=t;t=t+48|0;u=x+24|0;s=x+16|0;r=x+8|0;j=x;l=x+32|0;q=x+28|0;k=c+60|0;o=f[k>>2]|0;m=f[c+56>>2]|0;f[q>>2]=0;p=a+376|0;i=p;while(1){i=f[i>>2]|0;if(!i)break;if((f[i+4>>2]|0)==(c|0)){w=4;break}else i=i+8|0}if((w|0)==4){f[j>>2]=f[c>>2];a=YMc(a,123557,j)|0;f[h>>2]=a;a=6;t=x;return a|0}v=UIc(a,f[c>>2]|0)|0;if(!v){a=7;t=x;return a|0}n=DCc(28,0)|0;if(!n){Cxc(a);nxc(a,v);a=7;t=x;return a|0}f[n>>2]=a;f[n+4>>2]=e;b[n+17>>0]=1;y=zTc(a,f[c+72>>2]|0)|0;f[(f[k>>2]|0)+4>>2]=f[(f[a+16>>2]|0)+(y<<4)>>2];f[l+4>>2]=c;f[l>>2]=n;y=l+8|0;f[y>>2]=f[p>>2];k=l+12|0;f[k>>2]=0;f[p>>2]=l;j=n+8|0;i=Bd[g&127](a,f[e+12>>2]|0,m,o,j,q)|0;f[p>>2]=f[y>>2];a:do switch(i|0){case 7:{Cxc(a);w=10;break}case 0:{i=f[j>>2]|0;if(!i)i=0;else{f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[f[j>>2]>>2]=f[e>>2];y=e+8|0;f[y>>2]=(f[y>>2]|0)+1;f[n+12>>2]=1;if(!(f[k>>2]|0)){f[u>>2]=f[c>>2];i=YMc(a,123629,u)|0;f[h>>2]=i;Tyc(n);i=1;break a}e=c+64|0;f[n+24>>2]=f[e>>2];f[e>>2]=n;e=c+42|0;q=c+4|0;p=c+36|0;k=0;o=0;while(1){if((o|0)>=(d[e>>1]|0)){i=0;break a}m=cSc((f[q>>2]|0)+(o*20|0)|0,155644)|0;n=Mxc(m)|0;l=0;b:while(1){if((l|0)>=(n|0)){w=32;break}g=m+l|0;do if(!(QBc(123675,g,6)|0)){if(l|0?(b[m+(l+-1)>>0]|0)!=32:0)break;i=b[m+(l+6)>>0]|0;switch(i<<24>>24){case 32:case 0:{w=26;break b}default:{}}}while(0);l=l+1|0}if((w|0)==26){w=0;j=i<<24>>24==0?6:7;i=l;while(1){k=i+j|0;if((k|0)>(n|0))break;b[m+i>>0]=b[m+k>>0]|0;i=i+1|0}if((l|0)!=0&(b[g>>0]|0)==0)b[m+(l+-1)>>0]=0;j=(f[q>>2]|0)+(o*20|0)+16|0;d[j>>1]=d[j>>1]|2;j=1024;i=2}else if((w|0)==32){w=0;j=k;i=k&65535}f[p>>2]=f[p>>2]|i;k=j;o=o+1|0}}break}default:w=10}while(0);if((w|0)==10){j=f[q>>2]|0;if(!j){f[r>>2]=v;y=YMc(a,123599,r)|0;f[h>>2]=y}else{f[s>>2]=j;y=YMc(a,118856,s)|0;f[h>>2]=y;qxc(f[q>>2]|0)}nxc(a,n)}nxc(a,v);y=i;t=x;return y|0}function ZTc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+32|0;j=k+16|0;i=k;h=f[a>>2]|0;if((f[h+24>>2]&16|0)==0?_Tc(a)|0:0){j=0;t=k;return j|0}g=$Tc(h,d,e)|0;do if(!g){if(!(b[a+25>>0]|0)){g=HIc(h+360|0,d)|0;if((g|0)==0?(QBc(d,123705,7)|0)==0:0)g=aUc(h,d)|0;if(g|0?bUc(a,g)|0:0){j=f[g+20>>2]|0;t=k;return j|0}}if(!(c&2)){b[a+17>>0]=1;break}else{j=0;t=k;return j|0}}else{if(!(f[g+56>>2]|0)){j=g;t=k;return j|0}if(!(b[a+25>>0]|0)){j=g;t=k;return j|0}}while(0);g=(c&1|0)==0?123713:123727;if(!e){f[j>>2]=g;f[j+4>>2]=d;TIc(a,122961,j);j=0;t=k;return j|0}else{f[i>>2]=g;f[i+4>>2]=e;f[i+8>>2]=d;TIc(a,122951,i);j=0;t=k;return j|0}return 0}function _Tc(a){a=a|0;var c=0,d=0;c=f[a>>2]|0;if(b[c+169>>0]|0){d=0;return d|0}d=pUc(c,a+4|0)|0;if(d|0){f[a+12>>2]=d;c=a+36|0;f[c>>2]=(f[c>>2]|0)+1;return d|0}if(!(b[c+91>>0]|0)){d=0;return d|0}d=c+24|0;f[d>>2]=f[d>>2]|16;d=0;return d|0}function $Tc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;if(!c){e=a+16|0;d=HIc((f[(f[e>>2]|0)+28>>2]|0)+8|0,b)|0;if(d|0){b=d;return b|0}d=HIc((f[(f[e>>2]|0)+12>>2]|0)+8|0,b)|0;if(d|0){b=d;return b|0}c=a+20|0;a=2;while(1){if((a|0)>=(f[c>>2]|0))break;d=HIc((f[(f[e>>2]|0)+(a<<4)+12>>2]|0)+8|0,b)|0;if(d|0){h=23;break}else a=a+1|0}if(d|0){b=d;return b|0}if(QBc(b,125037,7)|0){b=0;return b|0}d=b+7|0;if(!(wzc(d,125071)|0)){b=HIc((f[(f[e>>2]|0)+12>>2]|0)+8|0,125078)|0;return b|0}if(wzc(d,125052)|0){b=0;return b|0}b=HIc((f[(f[e>>2]|0)+28>>2]|0)+8|0,125092)|0;return b|0}e=f[a+20>>2]|0;g=a+16|0;a=0;while(1){if((a|0)>=(e|0)){h=6;break}d=f[g>>2]|0;if(!(wzc(c,f[d+(a<<4)>>2]|0)|0)){c=a;break}a=a+1|0}do if((h|0)==6)if(!(wzc(c,120709)|0)){c=0;d=f[g>>2]|0;break}else{b=0;return b|0}while(0);a=HIc((f[d+(c<<4)+12>>2]|0)+8|0,b)|0;if(a|0){b=a;return b|0}if(QBc(b,125037,7)|0){b=a;return b|0}d=b+7|0;if((c|0)!=1){if(wzc(d,125071)|0){b=a;return b|0}b=HIc((f[(f[g>>2]|0)+(c<<4)+12>>2]|0)+8|0,125078)|0;return b|0}if((wzc(d,125052)|0?wzc(d,125071)|0:0)?wzc(d,125085)|0:0){b=a;return b|0}b=HIc((f[(f[g>>2]|0)+28>>2]|0)+8|0,125092)|0;return b|0}function aUc(a,c){a=a|0;c=c|0;var d=0;d=dUc(c+7|0)|0;if(!d){d=0;return d|0}if(!(b[d+5>>0]&48)){d=0;return d|0}d=wIc(a,c,77716,d,0)|0;return d|0}function bUc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;k=l;g=l+4|0;h=f[b>>2]|0;f[g>>2]=0;i=f[a>>2]|0;j=b+20|0;if(f[j>>2]|0){k=1;t=l;return k|0}e=f[h+4>>2]|0;if(e|0?(e|0)!=(f[h+8>>2]|0):0){k=0;t=l;return k|0}c=$Ec(i,76,0)|0;if(!c){k=0;t=l;return k|0}e=UIc(i,f[b+4>>2]|0)|0;f[c>>2]=e;if(!e){nxc(i,c);k=0;t=l;return k|0}f[j>>2]=c;f[c+32>>2]=1;f[c+72>>2]=f[(f[i+16>>2]|0)+12>>2];d[c+40>>1]=-1;cUc(a,c,UIc(i,e)|0);cUc(a,c,0);cUc(a,c,UIc(i,f[c>>2]|0)|0);if(!(YTc(i,c,b,f[h+8>>2]|0,g)|0)){k=1;t=l;return k|0}j=f[g>>2]|0;f[k>>2]=j;TIc(a,118856,k);nxc(i,j);xIc(i,b);k=0;t=l;return k|0}function cUc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=t;t=t+16|0;d=i;g=b+56|0;e=f[g>>2]|0;h=f[a>>2]|0;if((e+3|0)>=(f[h+120>>2]|0)){f[d>>2]=f[b>>2];TIc(a,123740,d)}b=b+60|0;a=Oxc(h,f[b>>2]|0,(e<<2)+8|0,0)|0;if(!a){nxc(h,c);t=i;return}else{e=f[g>>2]|0;h=e+1|0;f[g>>2]=h;f[a+(e<<2)>>2]=c;f[a+(h<<2)>>2]=0;f[b>>2]=a;t=i;return}}function dUc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;b=64;c=0;while(1){if((c|0)>(b|0)){b=0;g=6;break}d=(b+c|0)/2|0;e=zHc(a,f[13568+(d<<4)>>2]|0)|0;if(!e)break;e=(e|0)<0;b=e?d+-1|0:b;c=e?c:d+1|0}if((g|0)==6)return b|0;g=13568+(d<<4)|0;return g|0}function eUc(a,c,d,e,g,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;q=t;t=t+256|0;p=q+216|0;m=q+208|0;l=q+200|0;n=q+224|0;o=q;fxc(n,0,o,200,0);Lxc(n,123779);k=c+7|0;d=40;e=h[c+6>>0]|0;j=0;while(1){if(j>>>0>=(h[k>>0]|0)>>>0)break;r=f[13360+(e<<2)>>2]|0;f[l>>2]=d;f[l+4>>2]=r;cyc(n,123794,l);d=44;e=e+1|0;j=j+1|0}if(!j){f[m>>2]=f[c>>2];cyc(n,123801,m);k=1}else k=j;j=c+5|0;d=b[j>>0]|0;if(!(d&32))e=0;else{Lxc(n,123807);e=1;d=b[j>>0]|0}if((d&255)>63){Lxc(n,123819);e=e+1|0}Dxc(n,123834,1);hxc(n)|0;d=QFc(a,o)|0;if(d|0){r=TFc(a)|0;f[p>>2]=r;r=WAc(118856,p)|0;f[i>>2]=r;r=d;c=0;f[g>>2]=c;t=q;return r|0}d=Vzc(24)|0;if(!d){r=7;c=d;f[g>>2]=c;t=q;return r|0};f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;f[d+16>>2]=0;f[d+20>>2]=0;f[d+16>>2]=c;f[d+12>>2]=a;b[d+21>>0]=k;b[d+20>>0]=e;r=0;c=d;f[g>>2]=c;t=q;return r|0}function fUc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;j=n;m=c+40|0;p[m>>3]=1.0;if(!(b[a+20>>0]|0)){t=n;return 0}d=f[c+4>>2]|0;f[j>>2]=0;l=j+4|0;f[l>>2]=0;g=f[c>>2]|0;e=a+21|0;a=0;while(1){if((a|0)>=(g|0))break;if((b[d+5>>0]|0?(b[d+4>>0]|0)==2:0)?(i=f[d>>2]|0,k=h[e>>0]|0,(i|0)>=(k|0)):0)f[j+(i-k<<2)>>2]=a+1;a=a+1|0;d=d+12|0}a=f[j>>2]|0;if(!a){p[m>>3]=2147483647.0;m=c+48|0;f[m>>2]=2147483647;f[m+4>>2]=0;t=n;return 0}a=a+-1|0;d=f[c+16>>2]|0;f[d+(a<<3)>>2]=1;b[d+(a<<3)+4>>0]=1;l=f[l>>2]|0;a=l+-1|0;if(!l){t=n;return 0}p[m>>3]=20.0;m=c+48|0;f[m>>2]=20;f[m+4>>2]=0;f[d+(a<<3)>>2]=2;b[d+(a<<3)+4>>0]=1;t=n;return 0}function gUc(a){a=a|0;qxc(a);return 0}function hUc(a,b){a=a|0;b=b|0;var c=0;c=Vzc(24)|0;if(!c){c=7;return c|0};f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;f[c+16>>2]=0;f[c+20>>2]=0;f[c>>2]=a;f[b>>2]=c;c=0;return c|0}function iUc(a){a=a|0;oUc(a);qxc(a);return 0}function jUc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=t;t=t+64|0;q=r+24|0;n=r+16|0;l=r+8|0;i=r;m=r+32|0;p=f[a>>2]|0;oUc(a);k=p+16|0;j=a+16|0;b=0;c=((h[(f[k>>2]|0)+5>>0]|0)>>>5&1^1)&255;while(1){if((b|0)>=(d|0))break;g=Txc(f[e+(b<<2)>>2]|0)|0;if(g|0?(f[i>>2]=g,g=WAc(118856,i)|0,f[j+(c<<2)>>2]=g,(g|0)==0):0){b=7;o=14;break}b=b+1|0;c=c+1|0}if((o|0)==14){t=r;return b|0}g=p+12|0;fxc(m,0,0,0,f[(f[g>>2]|0)+116>>2]|0);Lxc(m,123763);b=f[a+20>>2]|0;if(b|0){f[l>>2]=b;cyc(m,123771,l)}Lxc(m,f[f[k>>2]>>2]|0);b=f[j>>2]|0;if(b|0){f[n>>2]=b;cyc(m,123775,n)}b=hxc(m)|0;if(!b){a=7;t=r;return a|0}c=CGc(f[g>>2]|0,b,-1,a+4|0,0)|0;qxc(b);if(!c){a=kUc(a)|0;t=r;return a|0}else{a=TFc(f[g>>2]|0)|0;f[q>>2]=a;a=WAc(118856,q)|0;f[p+8>>2]=a;a=c;t=r;return a|0}return 0}function kUc(a){a=a|0;var b=0,c=0;b=a+8|0;c=b;c=vrd(f[c>>2]|0,f[c+4>>2]|0,1,0)|0;f[b>>2]=c;f[b+4>>2]=G;b=a+4|0;if((rGc(f[b>>2]|0)|0)==100){c=0;return c|0}c=XFc(f[b>>2]|0)|0;f[b>>2]=0;oUc(a);return c|0}function lUc(a){a=a|0;return (f[a+4>>2]|0)==0|0}function mUc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=h[(f[a>>2]|0)+21>>0]|0;if((d|0)>(c|0)){oEc(b,FFc(f[a+4>>2]|0,c)|0);return 0}else{$Dc(b,f[a+16+(c-d<<2)>>2]|0,-1,-1);return 0}return 0}function nUc(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=f[c+4>>2]|0;f[b>>2]=f[c>>2];f[b+4>>2]=a;return 0}function oUc(a){a=a|0;var b=0,c=0;b=a+4|0;XFc(f[b>>2]|0)|0;f[b>>2]=0;b=0;while(1){if((b|0)==2)break;c=a+16+(b<<2)|0;qxc(f[c>>2]|0);f[c>>2]=0;b=b+1|0}return}function pUc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0;i=(f[a+24>>2]&1|0)==0;j=a+16|0;h=f[(f[j>>2]|0)+12>>2]|0;b[a+80>>0]=b[h+77>>0]|0;if((d[h+78>>1]&1)==0?(g=qUc(a,0,c,0)|0,g|0):0){k=g;return k|0}h=f[a+20>>2]|0;while(1){g=h+-1|0;if((h|0)<=1)break;if((d[(f[(f[j>>2]|0)+(g<<4)+12>>2]|0)+78>>1]&1)==0?(e=qUc(a,g,c,0)|0,e|0):0){k=10;break}h=g}if((k|0)==10)return e|0;if(!i){k=0;return k|0}CJc(a);k=0;return k|0}function qUc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0;z=t;t=t+96|0;v=z+56|0;s=z+32|0;n=z;u=z+64|0;l=a+24|0;w=f[l>>2]|-65;y=a+169|0;b[y>>0]=1;f[s>>2]=123843;q=(c|0)==1?125092:125078;f[s+4>>2]=q;f[s+8>>2]=q;f[s+12>>2]=121304;f[s+16>>2]=125111;f[s+20>>2]=0;f[u>>2]=a;f[u+8>>2]=c;r=u+12|0;f[r>>2]=0;f[u+4>>2]=e;f[u+16>>2]=g;f[u+20>>2]=0;p=u+24|0;f[p>>2]=0;rUc(u,5,s,0)|0;f[l>>2]=f[l>>2]&w;g=f[r>>2]|0;if(!g){s=a+16|0;j=f[s>>2]|0;w=j+(c<<4)+4|0;g=f[w>>2]|0;if(!g){c=(f[j+28>>2]|0)+78|0;d[c>>1]=d[c>>1]|1;c=0;b[y>>0]=0;t=z;return c|0}Fzc(g);g=f[w>>2]|0;if(!(tIc(g)|0)){g=dPc(g,0,0)|0;if(!g){o=1;x=7}else{sUc(e,a,mEc(g)|0);i=g}}else{o=0;x=7}if((x|0)==7){g=0;while(1){if((g|0)==5)break;m=g+1|0;ePc(f[w>>2]|0,m,n+(g<<2)|0);g=m}m=a+32|0;do if((f[m>>2]&33554432|0)==0&0==0){k=f[n+16>>2]|0;j=j+(c<<4)+12|0;g=f[j>>2]|0;f[g>>2]=f[n>>2];if(k){if((c|0)==0?(f[l>>2]&64|0)==0:0){k=k&3;tUc(a,(k|0)==0?1:k&255);k=f[j>>2]|0;x=18;break}if((k&3|0)!=(h[a+80>>0]|0)){sUc(e,a,125183);i=1}else{k=g;x=18}}else{k=g;x=18}}else{f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;f[n+12>>2]=0;f[n+16>>2]=0;j=j+(c<<4)+12|0;k=f[j>>2]|0;f[k>>2]=0;x=18}while(0);do if((x|0)==18){b[k+77>>0]=b[a+80>>0]|0;g=k+80|0;if(!(f[g>>2]|0)){l=hOc(f[n+8>>2]|0)|0;l=(l|0)==0?-2e3:l;f[g>>2]=l;uUc(f[w>>2]|0,l);g=f[j>>2]|0}else g=k;j=f[n+4>>2]|0;k=j&255;g=g+76|0;b[g>>0]=k;if(k<<24>>24){if((k&255)>4){sUc(e,a,125251);i=1;break}}else b[g>>0]=1;if((c|0)==0&(j|0)>3){l=m;n=f[l+4>>2]|0;e=m;f[e>>2]=f[l>>2]&-3;f[e+4>>2]=n}g=bMc(f[w>>2]|0)|0;f[p>>2]=g;f[v>>2]=f[(f[s>>2]|0)+(c<<4)>>2];f[v+4>>2]=q;g=YMc(a,125275,v)|0;v=a+336|0;e=f[v>>2]|0;f[v>>2]=0;j=VFc(a,g,57,u,0)|0;f[v>>2]=e;j=(j|0)==0?f[r>>2]|0:j;nxc(a,g);g=(j|0)==0;if(g)vUc(a,c)|0;if(!(b[a+83>>0]|0)){if(!g){i=j;x=31}}else{uOc(a);i=7;x=31}if((x|0)==31?(f[m>>2]&134217728|0)==0&0==0:0)break;i=(f[(f[s>>2]|0)+(c<<4)+12>>2]|0)+78|0;d[i>>1]=d[i>>1]|1;i=0}while(0);if(o)fPc(f[w>>2]|0)|0}Bzc(f[w>>2]|0)}else i=g;a:do if((i|0)<7){switch(i|0){case 0:break;default:break a}b[y>>0]=0;t=z;return i|0}else{if((i|0)<3082)switch(i|0){case 7:break;default:break a}else switch(i|0){case 3082:break;default:break a}Cxc(a)}while(0);fJc(a,c);c=i;b[y>>0]=0;t=z;return c|0}function rUc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=t;t=t+16|0;l=p;n=f[a>>2]|0;k=f[a+8>>2]|0;j=n+24|0;f[j>>2]=f[j>>2]|64;j=a+20|0;f[j>>2]=(f[j>>2]|0)+1;if(b[n+83>>0]|0){FUc(a,d,0);d=1;t=p;return d|0}if(!d){d=0;t=p;return d|0}h=d+12|0;i=f[h>>2]|0;if(!i){FUc(a,d,0);d=0;t=p;return d|0}j=d+16|0;e=f[j>>2]|0;g=(e|0)==0;if((!g?(b[e>>0]|32)<<24>>24==99:0)?(b[e+1>>0]|32)<<24>>24==114:0){g=n+168|0;h=b[g>>0]|0;b[g>>0]=k;c=n+164|0;if(!(GUc(i,c)|0)){if(b[40721]|0)o=13}else{m=f[a+24>>2]|0;if((f[c>>2]|0)>>>0>m>>>0?(m|0)!=0&(b[40721]|0)!=0:0)o=13}if((o|0)==13)FUc(a,d,125396);o=n+170|0;b[o>>0]=b[o>>0]&-2;f[n+172>>2]=d;f[l>>2]=0;eJc(n,f[j>>2]|0,-1,0,0,l,0)|0;e=f[n+64>>2]|0;b[g>>0]=h;a:do if(e|0?(b[o>>0]&1)==0:0){c=a+12|0;if((e|0)>(f[c>>2]|0))f[c>>2]=e;switch(e|0){case 9:break a;case 7:{Cxc(n);break a}default:{}}if((e&255|0)!=6)FUc(a,d,TFc(n)|0)}while(0);XFc(f[l>>2]|0)|0;d=0;t=p;return d|0}c=f[d+4>>2]|0;do if(c|0){if(!g?b[e>>0]|0:0)break;c=zUc(n,c,f[(f[n+16>>2]|0)+(k<<4)>>2]|0)|0;if(!c){FUc(a,d,125413);d=0;t=p;return d|0}e=c+44|0;if(((GUc(f[h>>2]|0,e)|0)!=0?(m=f[e>>2]|0,m>>>0>=2):0)?m>>>0<=(f[a+24>>2]|0)>>>0:0){n=(HUc(c)|0)!=0;if(!(n&(b[40721]|0)!=0)){d=0;t=p;return d|0}}else o=33;if((o|0)==33?(b[40721]|0)==0:0){d=0;t=p;return d|0}FUc(a,d,125396);d=0;t=p;return d|0}while(0);FUc(a,d,0);d=0;t=p;return d|0}function sUc(a,b,c){a=a|0;b=b|0;c=c|0;nxc(b,f[a>>2]|0);c=UIc(b,c)|0;f[a>>2]=c;return}function tUc(a,c){a=a|0;c=c|0;b[a+80>>0]=c;c=OIc(a,c,120777,0)|0;f[a+8>>2]=c;return}function uUc(a,b){a=a|0;b=b|0;var c=0;c=f[a+4>>2]|0;Fzc(a);DUc(f[c>>2]|0,b);Bzc(a);return}function vUc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0;k=t;t=t+16|0;i=k;j=k+8|0;g=a+16|0;e=f[(f[g>>2]|0)+(c<<4)+12>>2]|0;d=e+16|0;while(1){d=f[d>>2]|0;if(!d)break;l=(f[d+8>>2]|0)+36|0;f[l>>2]=f[l>>2]&-17}d=e+32|0;e=d;while(1){e=f[e>>2]|0;if(!e)break;l=(f[e+8>>2]|0)+55|0;m=(h[l>>0]|h[l+1>>0]<<8)&-129;b[l>>0]=m;b[l+1>>0]=m>>8}f[j>>2]=a;e=f[(f[g>>2]|0)+(c<<4)>>2]|0;f[j+4>>2]=e;if($Tc(a,125309,e)|0){f[i>>2]=e;e=YMc(a,125322,i)|0;if(!e)c=7;else{c=VFc(a,e,58,j,0)|0;nxc(a,e)}}else c=0;while(1){d=f[d>>2]|0;if(!d)break;e=f[d+8>>2]|0;m=e+55|0;if(!((h[m>>0]|h[m+1>>0]<<8)&128))xUc(e)}if((c|0)!=7){t=k;return c|0}Cxc(a);t=k;return c|0}function wUc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var i=0,k=0,l=0,m=0;m=t;t=t+80|0;l=m;if(!e){t=m;return 0}c=f[e>>2]|0;if(!c){t=m;return 0}i=e+8|0;if(!(f[i>>2]|0)){t=m;return 0}g=a+4|0;k=$Tc(f[a>>2]|0,c,f[g>>2]|0)|0;if(!k){t=m;return 0}c=f[e+4>>2]|0;if(c){if(!(zHc(f[e>>2]|0,c)|0))a=yUc(k)|0;else a=zUc(f[a>>2]|0,c,f[g>>2]|0)|0;c=f[i>>2]|0;if(a){e=(j[a+50>>1]|0)+1|0;l=a+55|0;g=(h[l>>0]|h[l+1>>0]<<8)&-5;b[l>>0]=g;b[l+1>>0]=g>>8;g=a+8|0;AUc(c,e,f[g>>2]|0,a);e=h[l>>0]|h[l+1>>0]<<8|128;b[l>>0]=e;b[l+1>>0]=e>>8;if(f[a+36>>2]|0){t=m;return 0}d[k+46>>1]=d[f[g>>2]>>1]|0;l=k+36|0;f[l>>2]=f[l>>2]|16;t=m;return 0}}else c=f[i>>2]|0;e=k+48|0;i=l+48|0;d[i>>1]=d[e>>1]|0;AUc(c,1,k+46|0,l);d[e>>1]=d[i>>1]|0;l=k+36|0;f[l>>2]=f[l>>2]|16;t=m;return 0}function xUc(a){a=a|0;var c=0,e=0,g=0,h=0,i=0;h=f[a+8>>2]|0;i=a+50|0;g=d[i>>1]|0;g=(g&65535)<5?g:5;e=(f[a+12>>2]|0)+46|0;c=d[e>>1]|0;if(c<<16>>16<99){d[e>>1]=99;c=99}d[h>>1]=(f[a+36>>2]|0)==0?c:(c&65535)+65526&65535;Krd(h+2|0,82048,g<<1&65535|0)|0;e=g&65535;while(1){c=e+1|0;g=d[i>>1]|0;if(e>>>0>=(g&65535)>>>0)break;d[h+(c<<1)>>1]=23;e=c}if(!(b[a+54>>0]|0))return;d[h+((g&65535)<<1)>>1]=0;return}function yUc(a){a=a|0;var b=0;a=a+8|0;while(1){a=f[a>>2]|0;if(!a){a=0;b=5;break}b=a+55|0;if(((h[b>>0]|h[b+1>>0]<<8)&3)==2){b=5;break}a=a+20|0}if((b|0)==5)return a|0;return 0}function zUc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=a+20|0;j=a+16|0;k=(c|0)==0;d=0;h=0;while(1){if((h|0)>=(f[i>>2]|0)){l=8;break}e=h^h>>>0<2;g=f[(f[j>>2]|0)+(e<<4)+12>>2]|0;if(!(!k?(CUc(a,e,c)|0)==0:0)){d=HIc(g+24|0,b)|0;if(d)break}h=h+1|0}if((l|0)==8)return d|0;l=d;return l|0}function AUc(a,c,e,f){a=a|0;c=c|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0;g=a;j=0;while(1){a=b[g>>0]|0;if(!((j|0)<(c|0)&a<<24>>24!=0))break;i=0;while(1){if((a+-48&255)>=10)break;k=g+1|0;i=(i*10|0)+-48+(a<<24>>24)|0;g=k;a=b[k>>0]|0}k=BUc(i,0)|0;d[e+(j<<1)>>1]=k;g=(b[g>>0]|0)==32?g+1|0:g;j=j+1|0}c=f+55|0;j=(h[c>>0]|h[c+1>>0]<<8)&-69;b[c>>0]=j;b[c+1>>0]=j>>8;j=f+48|0;a=g;g=b[g>>0]|0;while(1){if(!(g<<24>>24))break;do if(IHc(125363,a)|0){if(!(IHc(125374,a)|0)){k=PBc(a+3|0)|0;k=BUc((k|0)>2?k:2,0)|0;d[j>>1]=k;break}if(!(IHc(125384,a)|0)){k=h[c>>0]|h[c+1>>0]<<8|64;b[c>>0]=k;b[c+1>>0]=k>>8}}else{k=h[c>>0]|h[c+1>>0]<<8|4;b[c>>0]=k;b[c+1>>0]=k>>8}while(0);a:while(1){g=b[a>>0]|0;switch(g<<24>>24){case 32:case 0:break a;default:{}}a=a+1|0}while(1){i=a+1|0;if(g<<24>>24!=32)break;a=i;g=b[i>>0]|0}}return}function BUc(a,b){a=a|0;b=b|0;var c=0,d=0;if(b>>>0<0|(b|0)==0&a>>>0<8){if(b>>>0<0|(b|0)==0&a>>>0<2){a=0;return a|0}c=40;while(1){if(!(b>>>0<0|(b|0)==0&a>>>0<8))break;d=Hrd(a|0,b|0,1)|0;c=(c&65535)+65526&65535;b=G;a=d}}else{c=40;while(1){if(!(b>>>0>0|(b|0)==0&a>>>0>255))break;d=Grd(a|0,b|0,4)|0;b=G;a=d;c=c+40|0}while(1){if(!(b>>>0>0|(b|0)==0&a>>>0>15))break;d=Grd(a|0,b|0,1)|0;c=(c&65535)+10|0;b=G;a=d}c=c&65535}d=(c&65535)+65526+(j[14608+((a&7)<<1)>>1]|0)&65535;return d|0}function CUc(a,b,c){a=a|0;b=b|0;c=c|0;if(!(wzc(f[(f[a+16>>2]|0)+(b<<4)>>2]|0,c)|0)){c=1;return c|0}if(b|0){c=0;return c|0}c=(wzc(120709,c)|0)==0&1;return c|0}function DUc(a,b){a=a|0;b=b|0;EUc(f[a+212>>2]|0,b);return}function EUc(a,b){a=a|0;b=b|0;var c=0,d=0;f[a+16>>2]=b;d=f[10208]|0;c=f[a+44>>2]|0;b=DLc(a)|0;Jd[d&1023](c,b);return}function FUc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+32|0;j=l+24|0;h=l+16|0;g=l;i=f[a>>2]|0;do if(!(b[i+83>>0]|0)){k=a+4|0;if(f[f[k>>2]>>2]|0){t=l;return}e=f[a+16>>2]|0;if(e&3|0){j=f[c+4>>2]|0;f[g>>2]=f[c>>2];f[g+4>>2]=j;f[g+8>>2]=(e&1|0)==0?125426:125438;f[g+12>>2]=d;c=YMc(i,125445,g)|0;f[f[k>>2]>>2]=c;c=1;break}if(!(0==0?(f[i+32>>2]&1|0)==0:0)){c=YJc(130152)|0;break}c=f[c+4>>2]|0;f[h>>2]=(c|0)==0?125473:c;c=YMc(i,125475,h)|0;if((d|0)!=0?(b[d>>0]|0)!=0:0){f[j>>2]=c;f[j+4>>2]=d;c=YMc(i,125506,j)|0}f[f[k>>2]>>2]=c;c=YJc(130159)|0}else c=7;while(0);f[a+12>>2]=c;t=l;return}function GUc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;h=0;d=0;e=0;while(1){g=b[a+h>>0]|0;if(((g&255)+-48|0)>>>0>=10)break;e=Brd(d|0,e|0,10,0)|0;d=g<<24>>24;e=vrd(e|0,G|0,-48,-1)|0;d=vrd(e|0,G|0,d|0,((d|0)<0)<<31>>31|0)|0;e=G;if(e>>>0>1|(e|0)==1&d>>>0>0){d=0;e=0;i=6;break}h=h+1|0}if((i|0)==6){f[c>>2]=e;return d|0}a=(h|0)!=0&g<<24>>24==0;i=a&1;a=a?d:0;f[c>>2]=a;return i|0}function HUc(a){a=a|0;var b=0,c=0;c=a+44|0;b=(f[a+12>>2]|0)+8|0;while(1){b=f[b>>2]|0;if(!b){b=0;a=4;break}if((b|0)==(a|0)?1:(f[b+44>>2]|0)!=(f[c>>2]|0))b=b+20|0;else{b=1;a=4;break}}if((a|0)==4)return b|0;return 0}function IUc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;g=f[b+8>>2]|0;a:while(1){if(!a){b=0;h=8;break}d=f[a>>2]|0;b=0;while(1){if((b|0)>=(d|0))break;e=a+8+(b*24|0)|0;if(!(wzc(g,f[e>>2]|0)|0))break a;else b=b+1|0}a=f[a+4>>2]|0}if((h|0)==8)return b|0;f[c>>2]=a;h=e;return h|0}function JUc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=jxc(f[a>>2]|0,12,0)|0;if(!d){Jd[b&1023](f[a>>2]|0,c);d=0;return d|0}else{a=a+264|0;f[d>>2]=f[a>>2];f[a>>2]=d;f[d+4>>2]=c;f[d+8>>2]=b;d=c;return d|0}return 0}function KUc(a,b){a=a|0;b=b|0;lzc(a,b);nxc(a,b);return}function LUc(a){a=a|0;var b=0,c=0,d=0;b=f[a+244>>2]|0;if(!b)return;c=f[a+228>>2]|0;if(!c)return;d=f[a+248>>2]|0;cUc(a,c,kJc(f[a>>2]|0,b,d,((d|0)<0)<<31>>31)|0);return}function MUc(a){a=a|0;var c=0;c=f[a+116>>2]|0;b[((c|0)==0?a:c)+21>>0]=1;return}function NUc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+128|0;e=m+96|0;j=m+112|0;k=m;f[j>>2]=0;l=f[a>>2]|0;g=a+36|0;if(f[g>>2]|0){t=m;return}f[e>>2]=d;i=FIc(l,c,e)|0;if(i|0){c=a+18|0;b[c>>0]=(b[c>>0]|0)+1<<24>>24;e=a+188|0;d=k;g=e;h=d+84|0;do{b[d>>0]=b[g>>0]|0;d=d+1|0;g=g+1|0}while((d|0)<(h|0));d=e;h=d+84|0;do{b[d>>0]=0;d=d+1|0}while((d|0)<(h|0));lJc(a,i,j)|0;nxc(l,f[j>>2]|0);nxc(l,i);d=e;g=k;h=d+84|0;do{b[d>>0]=b[g>>0]|0;d=d+1|0;g=g+1|0}while((d|0)<(h|0));b[c>>0]=(b[c>>0]|0)+-1<<24>>24;t=m;return}if(!(b[l+83>>0]|0))f[a+12>>2]=18;f[g>>2]=(f[g>>2]|0)+1;t=m;return}function OUc(a){a=a|0;var c=0;c=f[a+8>>2]|0;if(c|0)return c|0;if((f[a+116>>2]|0)==0?(f[(f[a>>2]|0)+76>>2]&8|0)==0:0)b[a+23>>0]=1;c=bVc(a)|0;return c|0}function PUc(a,b){a=a|0;b=b|0;UUc(f[a+8>>2]|0,95,b,1,(f[f[(f[(f[a>>2]|0)+16>>2]|0)+(b<<4)+12>>2]>>2]|0)+1|0)|0;return}function QUc(a,b){a=a|0;b=b|0;return UUc(a,b,0,0,0)|0}function RUc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;XUc(a,144,b,0,0,c,-7)|0;_Uc(a,d);b=0;while(1){if((b|0)>=(f[(f[a>>2]|0)+20>>2]|0))break;$Uc(a,b);b=b+1|0}MUc(f[a+12>>2]|0);return}function SUc(a,b,c){a=a|0;b=b|0;c=c|0;return XUc(a,116,0,b,0,c,0)|0}function TUc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return UUc(a,b,c,d,0)|0}function UUc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0;i=a+108|0;j=f[i>>2]|0;if((f[a+112>>2]|0)>(j|0)){f[i>>2]=j+1;i=f[a+104>>2]|0;b[i+(j*20|0)>>0]=c;d[i+(j*20|0)+2>>1]=0;f[i+(j*20|0)+4>>2]=e;f[i+(j*20|0)+8>>2]=g;f[i+(j*20|0)+12>>2]=h;f[i+(j*20|0)+16>>2]=0;b[i+(j*20|0)+1>>0]=0;return j|0}else{j=VUc(a,c,e,g,h)|0;return j|0}return 0}function VUc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;if(WUc(a)|0){e=1;return e|0}e=UUc(a,b,c,d,e)|0;return e|0}function WUc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;g=f[a+12>>2]|0;h=a+112|0;b=f[h>>2]|0;c=(b|0)==0;b=Hrd(b|0,((b|0)<0)<<31>>31|0,1)|0;b=c?51:b;c=c?0:G;d=f[g>>2]|0;e=f[d+132>>2]|0;i=((e|0)<0)<<31>>31;if((c|0)>(i|0)|(c|0)==(i|0)&b>>>0>e>>>0){Cxc(d);i=7;return i|0}e=a+104|0;i=f[e>>2]|0;a=Brd(b|0,c|0,20,0)|0;a=Oxc(d,i,a,G)|0;b=(a|0)!=0;if(b){i=txc(f[g>>2]|0,a)|0;f[g+48>>2]=i;f[h>>2]=(i>>>0)/20|0;f[e>>2]=a}i=b?0:7;return i|0}function XUc(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;e=UUc(a,b,c,d,e)|0;YUc(a,e,f,g);return e|0}function YUc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;g=f[a>>2]|0;if(b[g+83>>0]|0){if((e|0)==-12)return;Nyc(g,e,d);return}if((c|0)<0)c=(f[a+108>>2]|0)+-1|0;g=f[a+104>>2]|0;h=g+(c*20|0)|0;if((e|0)<=-1?(i=g+(c*20|0)+1|0,(b[i>>0]|0)==0):0){if((e|0)==-3){f[g+(c*20|0)+16>>2]=d;b[i>>0]=-3;return}if(!d)return;f[g+(c*20|0)+16>>2]=d;b[i>>0]=e;if((e|0)!=-12)return;IJc(d);return}ZUc(a,h,d,e);return}function ZUc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;h=c+1|0;g=b[h>>0]|0;if(g<<24>>24){i=c+16|0;Nyc(f[a>>2]|0,g<<24>>24,f[i>>2]|0);b[h>>0]=0;f[i>>2]=0}if((e|0)<0){YUc(a,(c-(f[a+104>>2]|0)|0)/20|0,d,e);return}if(!e)e=Mxc(d)|0;i=kJc(f[a>>2]|0,d,e,((e|0)<0)<<31>>31)|0;f[c+16>>2]=i;b[h>>0]=-7;return}function _Uc(a,b){a=a|0;b=b|0;var c=0;c=f[a+108>>2]|0;if((c|0)<=0)return;d[(f[a+104>>2]|0)+((c+-1|0)*20|0)+2>>1]=b;return}function $Uc(a,b){a=a|0;b=b|0;var c=0,d=0;c=1<<b;d=a+152|0;f[d>>2]=f[d>>2]|c;if((b|0)==1)return;if(!(aVc(f[(f[(f[a>>2]|0)+16>>2]|0)+(b<<4)+4>>2]|0)|0))return;d=a+156|0;f[d>>2]=f[d>>2]|c;return}function aVc(a){a=a|0;return h[a+9>>0]|0|0}function bVc(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a>>2]|0;e=uxc(b,224,0)|0;if(!e){e=0;return e|0}c=e+104|0;d=c+120|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(d|0));f[e>>2]=b;b=b+4|0;c=f[b>>2]|0;if(c|0)f[c+4>>2]=e;f[e+8>>2]=c;f[e+4>>2]=0;f[b>>2]=e;f[e+20>>2]=381479589;f[e+12>>2]=a;f[a+8>>2]=e;TUc(e,62,0,1)|0;return e|0}function cVc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;e=t;t=t+16|0;d=e;c=f[b>>2]|0;if(QBc(c,125037,7)|0){if(!(f[b+36>>2]&4096)){d=0;t=e;return d|0}if(!(gVc(f[a>>2]|0)|0)){d=0;t=e;return d|0}}f[d>>2]=c;TIc(a,126764,d);d=1;t=e;return d|0}function dVc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=t;t=t+16|0;e=g;d=(f[b+56>>2]|0)==0?((f[b+12>>2]|0)==0?0:126692):126697;if(!d){e=0;t=g;return e|0}b=f[b>>2]|0;f[e>>2]=(c|0)==0?126711:126729;f[e+4>>2]=d;f[e+8>>2]=b;TIc(a,126746,e);e=1;t=g;return e|0}function eVc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+8|0;if(!(f[d>>2]|0))return;PUc(a,b);RUc(f[d>>2]|0,b,0,c);if((b|0)==1)return;RUc(f[d>>2]|0,1,0,c);return}function fVc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;i=t;t=t+48|0;h=i+24|0;j=i;b[a+16>>0]=1;f[j>>2]=c;f[j+4>>2]=c;f[j+8>>2]=d;f[j+12>>2]=e;f[j+16>>2]=g;NUc(a,126343,j);if(d|0){t=i;return}f[h>>2]=c;f[h+4>>2]=e;f[h+8>>2]=g;NUc(a,126518,h);t=i;return}function gVc(a){a=a|0;if((!(0==0?(f[a+32>>2]&268435456|0)==0:0)?(f[a+376>>2]|0)==0:0)?(f[a+188>>2]|0)==0:0){a=1;return a|0}a=0;return a|0}function hVc(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0;h=f[a+8>>2]|0;i=e+28|0;lWc(a,c,f[i>>2]|0,(g|0)==98&1,f[e>>2]|0);if(!(f[e+36>>2]&128)){lVc(h,g,b,f[i>>2]|0,c,d[e+44>>1]|0)|0;return}else{i=yUc(e)|0;UUc(h,g,b,f[i+44>>2]|0,c)|0;oWc(a,i);return}}function iVc(a,b,c){a=a|0;b=b|0;c=c|0;return UUc(a,b,c,0,0)|0}function jVc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;e=j[a+52>>1]|0;c=a+4|0;a=0;while(1){if(a>>>0>=e>>>0){a=-1;g=6;break}if((d[(f[c>>2]|0)+(a<<1)>>1]|0)==b<<16>>16)break;a=a+1|0}if((g|0)==6)return a|0;g=a&65535;return g|0}function kVc(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+16|0;l=m;if(!b){UUc(a,90,c,e,g)|0;t=m;return}if((e|0)>=0?(d[b+40>>1]|0)!=(e|0):0){do if(!(f[b+56>>2]|0)){k=f[b+4>>2]|0;j=k+(e*20|0)|0;k=k+(e*20|0)+16|0;h=d[k>>1]|0;if(!(h&32))if(!(f[b+36>>2]&128)){h=90;i=(vTc(b,e&65535)|0)<<16>>16;break}else{h=90;i=(jVc(yUc(b)|0,e&65535)|0)<<16>>16;break}i=pVc(a)|0;h=h&65535;if(!(h&256)){l=i+52|0;e=f[l>>2]|0;d[k>>1]=h|256;f[l>>2]=c+1;qVc(i,j,g);f[l>>2]=e;d[k>>1]=d[k>>1]&-257;t=m;return}else{f[l>>2]=f[j>>2];TIc(i,127109,l);t=m;return}}else{h=169;i=e}while(0);UUc(a,h,c,i,g)|0;rVc(a,b,e,g);t=m;return}TUc(a,130,c,g)|0;t=m;return}function lVc(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;c=UUc(a,c,d,e,g)|0;if(b[(f[a>>2]|0)+83>>0]|0)return c|0;a=f[a+104>>2]|0;b[a+(c*20|0)+1>>0]=-3;f[a+(c*20|0)+16>>2]=h;return c|0}function mVc(a,b){a=a|0;b=b|0;nVc(a,b,f[a+108>>2]|0);return}function nVc(a,b,c){a=a|0;b=b|0;c=c|0;b=(oVc(a,b)|0)+8|0;f[b>>2]=c;return}function oVc(a,c){a=a|0;c=c|0;if((c|0)<0)c=(f[a+108>>2]|0)+-1|0;if(b[(f[a>>2]|0)+83>>0]|0){a=153956;return a|0}a=(f[a+104>>2]|0)+(c*20|0)|0;return a|0}function pVc(a){a=a|0;return f[a+12>>2]|0}function qVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=f[a+8>>2]|0;e=f[a+52>>2]|0;if((e|0)>0)g=UUc(h,21,e+-1|0,0,d)|0;else g=0;uVc(a,f[c+4>>2]|0,d);e=c+13|0;if((b[e>>0]|0)>65)XUc(h,91,d,1,0,e,1)|0;if(!g)return;mVc(h,g);return}function rVc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;i=t;t=t+16|0;h=i;if(!(f[c+12>>2]|0)){f[h>>2]=0;k=sVc(a)|0;g=c+4|0;j=f[g>>2]|0;uSc(k,f[j+(d*20|0)+4>>2]|0,b[k+80>>0]|0,b[j+(d*20|0)+13>>0]|0,h)|0;h=f[h>>2]|0;if(h|0)tVc(a,h,-11)}else g=c+4|0;if((b[(f[g>>2]|0)+(d*20|0)+13>>0]|0)!=69){t=i;return}if(f[c+56>>2]|0){t=i;return}iVc(a,84,e)|0;t=i;return}function sVc(a){a=a|0;return f[a>>2]|0}function tVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;e=f[a>>2]|0;if(!(b[e+83>>0]|0)){g=f[a+104>>2]|0;e=(f[a+108>>2]|0)+-1|0;b[g+(e*20|0)+1>>0]=d;f[g+(e*20|0)+16>>2]=c;return}else{Nyc(e,d,c);return}}function uVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=f[a>>2]|0;c=oSc(e,c,0)|0;if(b[e+83>>0]|0){dzc(e,c);return}vVc(a,c,d);dzc(e,c);return}function vVc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+8|0;if(!(f[d>>2]|0))return;a=wVc(a,b,c)|0;if((a|0)==(c|0))return;TUc(f[d>>2]|0,78-((f[b+4>>2]|0)>>>21&1)|0,a,c)|0;return}function wVc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=t;t=t+160|0;n=A+40|0;k=A+32|0;q=A+24|0;r=A+16|0;m=A+8|0;u=A;v=A+152|0;w=A+148|0;o=A+96|0;s=A+44|0;z=f[a+8>>2]|0;f[v>>2]=0;f[w>>2]=0;y=c;a:while(1){if(!y)g=120;else g=h[y>>0]|0;switch((g&255)<<24>>24){case -88:{x=5;break a}case -90:{x=11;break a}case -102:{x=33;break a}case -87:{x=34;break a}case -104:{x=35;break a}case 116:{x=36;break a}case -103:{x=38;break a}case -101:{x=39;break a}case -81:{x=41;break a}case 36:{x=42;break a}case -86:case 45:{x=45;break a}case 53:case 52:case 57:case 54:case 55:case 56:{i=0;x=46;break a}case 111:case 105:case 104:case 109:case 103:case 102:case 110:case 107:case 108:case 106:case 43:case 44:{x=49;break a}case -84:{x=50;break a}case 19:case 113:{x=54;break a}case -82:{x=55;break a}case 51:case 50:{x=56;break a}case -89:{x=57;break a}case -85:{x=62;break a}case -119:case 20:{x=103;break a}case -79:{x=108;break a}case 49:{x=114;break a}case 48:{x=115;break a}case 77:{x=117;break a}case -80:{x=120;break a}case -78:{x=121;break a}case -100:{x=122;break a}case 71:{x=136;break a}case -83:case 112:case -76:break;default:{x=37;break a}}y=f[y+12>>2]|0}b:switch(x|0){case 5:{c=f[y+40>>2]|0;i=f[c+28>>2]|0;k=d[y+34>>1]|0;if(!(b[c>>0]|0)){a=f[i+(k*20|0)+12>>2]|0;t=A;return a|0}if(!(b[c+1>>0]|0))x=11;else{g=f[i+(k*20|0)>>2]|0;UUc(z,90,f[c+8>>2]|0,d[i+(k*20|0)+18>>1]|0,e)|0;c=d[i+(k*20|0)+16>>1]|0;if(c<<16>>16<0){a=e;t=A;return a|0}if((b[(f[g+4>>2]|0)+((c<<16>>16)*20|0)+13>>0]|0)!=69){a=e;t=A;return a|0}iVc(z,84,e)|0;a=e;t=A;return a|0}break}case 33:{yVc(a,y,0,e);a=e;t=A;return a|0}case 34:{TUc(z,69,zVc(y)|0,e)|0;a=e;t=A;return a|0}case 35:{AVc(z,f[y+8>>2]|0,0,e);a=e;t=A;return a|0}case 36:{SUc(z,e,f[y+8>>2]|0)|0;a=e;t=A;return a|0}case 37:{TUc(z,72,0,e)|0;a=e;t=A;return a|0}case 38:{y=(f[y+8>>2]|0)+2|0;a=(Mxc(y)|0)+-1|0;XUc(z,74,(a|0)/2|0,e,0,DSc(sVc(z)|0,y,a)|0,-7)|0;a=e;t=A;return a|0}case 39:{c=y+32|0;TUc(z,75,d[c>>1]|0,e)|0;if(!(b[(f[y+8>>2]|0)+1>>0]|0)){a=e;t=A;return a|0}y=f[a+216>>2]|0;a=BVc(y,d[c>>1]|0)|0;f[y>>2]=0;tVc(z,a,-1);a=e;t=A;return a|0}case 41:{a=f[y+28>>2]|0;t=A;return a|0}case 42:{c=wVc(a,f[y+12>>2]|0,e)|0;if((c|0)!=(e|0))TUc(z,78,c,e)|0;TUc(z,85,e,(aSc(f[y+8>>2]|0,0)|0)<<24>>24)|0;a=e;t=A;return a|0}case 45:{i=128;g=(g|0)==45?53:52;x=46;break}case 49:{c=EVc(a,f[y+12>>2]|0,v)|0;UUc(z,g,EVc(a,f[y+16>>2]|0,w)|0,c,e)|0;c=e;break}case 50:{c=y+12|0;g=f[c>>2]|0;switch(b[g>>0]|0){case -102:{yVc(a,g,1,e);a=e;t=A;return a|0}case -104:{AVc(z,f[g+8>>2]|0,1,e);a=e;t=A;return a|0}default:{b[o>>0]=-102;f[o+4>>2]=17408;f[o+8>>2]=0;y=EVc(a,o,v)|0;UUc(z,107,EVc(a,f[c>>2]|0,w)|0,y,e)|0;c=e;break b}}}case 54:{TUc(z,g,EVc(a,f[y+12>>2]|0,v)|0,e)|0;c=e;break}case 55:{u=EVc(a,f[y+12>>2]|0,v)|0;c=zVc(f[y+16>>2]|0)|0;lVc(z,88,u,e,(c|0)==0&1,c^(b[y+2>>0]|0)==45)|0;c=e;break}case 56:{TUc(z,69,1,e)|0;c=iVc(z,g,EVc(a,f[y+12>>2]|0,v)|0)|0;TUc(z,69,0,e)|0;mVc(z,c);c=e;break}case 57:{c=f[y+40>>2]|0;if((c|0?(z=d[y+34>>1]|0,l=z<<16>>16,z<<16>>16>=0):0)?(f[c+44>>2]|0)>(l|0):0){a=f[(f[c+40>>2]|0)+(l<<4)+8>>2]|0;t=A;return a|0}f[m>>2]=f[y+8>>2];TIc(a,127147,m);c=e;break}case 62:{q=f[a>>2]|0;c=b[q+80>>0]|0;o=y+4|0;if(f[o>>2]&16777216|0){a=f[(f[y+44>>2]|0)+56>>2]|0;t=A;return a|0}if(b[a+23>>0]|0?GVc(y)|0:0){a=HVc(a,y,-1)|0;t=A;return a|0}p=f[y+20>>2]|0;l=(p|0)!=0;if(l)s=f[p>>2]|0;else s=0;i=f[y+8>>2]|0;g=AIc(q,i,s,c,0)|0;if(g|0?(f[g+20>>2]|0)==0:0){m=g+4|0;c=f[m>>2]|0;if(c&4194304|0){a=IVc(a,p,f[g+8>>2]|0,e)|0;t=A;return a|0}if(c&2621440|0)jTc(a,y,g);n=0;k=0;c=0;while(1){if((k|0)>=(s|0))break;if(k>>>0<32){i=(XQc(f[p+4+(k<<4)>>2]|0)|0)==0;i=(i?0:1<<k)|n}else i=n;if(!((c|0)!=0|(f[m>>2]&32|0)==0))c=NIc(a,f[p+4+(k<<4)>>2]|0)|0;n=i;k=k+1|0}if(l){if(!n)l=JVc(a,s)|0;else{w=a+44|0;l=f[w>>2]|0;f[w>>2]=l+s;l=l+1|0}i=f[m>>2]&192;c:do if(i|0){k=f[p+4>>2]|0;switch(b[k>>0]|0){case -88:case -90:break;default:break c}b[k+2>>0]=i}while(0);KVc(a,p,l,0,3)}else l=0;if((s|0)>1)if(!(f[o>>2]&128))x=94;else{i=p+20|0;x=95}else if((s|0)==1)x=94;if((x|0)==94){i=p+4|0;x=95}if((x|0)==95)g=LVc(q,g,s,f[i>>2]|0)|0;if(f[g+4>>2]&32|0){if(!c)c=f[q+8>>2]|0;XUc(z,82,0,0,0,c,-2)|0}MVc(a,n,l,e,s,g,h[y+2>>0]|0);if(!((s|0)!=0&(n|0)==0)){a=e;t=A;return a|0}NVc(a,l,s);a=e;t=A;return a|0}f[r>>2]=i;TIc(a,127173,r);c=e;break}case 103:{if(b[(f[a>>2]|0)+83>>0]|0){a=0;t=A;return a|0}if((g|0)==137?(i=f[f[(f[y+20>>2]|0)+28>>2]>>2]|0,(i|0)!=1):0){PVc(a,i,1);c=e;break}a=OVc(a,y)|0;t=A;return a|0}case 108:{i=y+12|0;c=f[i>>2]|0;if(!(f[c+28>>2]|0)){z=OVc(a,c)|0;c=f[i>>2]|0;f[c+28>>2]=z}g=f[y+28>>2]|0;if((g|0)!=0?(p=mTc(c)|0,(g|0)!=(p|0)):0){f[q>>2]=g;f[q+4>>2]=p;TIc(a,127196,q);c=f[i>>2]|0}a=(f[c+28>>2]|0)+(d[y+32>>1]|0)|0;t=A;return a|0}case 114:{w=QVc(a)|0;x=QVc(a)|0;TUc(z,72,0,e)|0;RVc(a,y,w,x);TUc(z,69,1,e)|0;SVc(z,w);TUc(z,83,e,0)|0;SVc(z,x);a=e;t=A;return a|0}case 115:{TVc(a,y,e,0,0);a=e;t=A;return a|0}case 117:{s=f[y+44>>2]|0;u=d[y+32>>1]|0;TUc(z,151,(V((d[s+42>>1]|0)+1|0,f[y+28>>2]|0)|0)+(((vTc(s,u)|0)<<16>>16)+1)|0,e)|0;if(u<<16>>16>-1?(b[(f[s+4>>2]|0)+((u<<16>>16)*20|0)+13>>0]|0)==69:0){iVc(z,84,e)|0;c=e}else c=e;break}case 120:{TIc(a,122503,k);c=e;break}case 121:{s=a+23|0;r=b[s>>0]|0;u=iVc(z,21,f[y+28>>2]|0)|0;b[s>>0]=0;c=wVc(a,f[y+12>>2]|0,e)|0;b[s>>0]=r;mVc(z,u);UVc(z,u,c);break}case 122:{o=f[a>>2]|0;p=f[y+20>>2]|0;q=f[p>>2]|0;r=QVc(a)|0;c=f[y+12>>2]|0;n=(c|0)!=0;do if(n){i=oSc(o,c,0)|0;if(!(b[o+83>>0]|0)){WVc(i,VVc(a,i,v)|0);c=s;g=c+52|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(g|0));b[s>>0]=53;f[s+12>>2]=i;f[v>>2]=0;c=s;x=126;break}else{dzc(o,i);break}}else{i=0;c=0;x=126}while(0);if((x|0)==126){m=q+-1|0;l=s+16|0;k=0;while(1){if((k|0)>=(m|0))break;g=f[p+4+(k<<4)>>2]|0;if(n)f[l>>2]=g;else c=g;y=QVc(a)|0;XVc(a,c,y,16);vVc(a,f[p+4+((k|1)<<4)>>2]|0,e);YVc(z,r)|0;SVc(z,y);k=k+2|0}if(!(q&1))TUc(z,72,0,e)|0;else vVc(a,f[p+4+(m<<4)>>2]|0,e);dzc(o,i);ZVc(z);SVc(z,r)}c=e;break}case 136:{i=a+120|0;if((f[i>>2]|0)==0?(b[a+18>>0]|0)==0:0){TIc(a,127226,n);a=0;t=A;return a|0}g=y+1|0;c=b[g>>0]|0;if(c<<24>>24==2){MUc(a);c=b[g>>0]|0}if(c<<24>>24==4){XUc(z,68,0,4,0,f[y+8>>2]|0,0)|0;c=e;break}else{_Vc(a,(f[i>>2]|0)==0?1:1811,c<<24>>24,f[y+8>>2]|0,0,0);c=e;break}}}do if((x|0)==11){c=f[y+28>>2]|0;if(f[y+4>>2]&8|0){g=wVc(a,f[y+12>>2]|0,e)|0;c=f[y+44>>2]|0;if(!c)c=b[y+1>>0]|0;else c=bSc(c,d[y+32>>1]|0)|0;if(c<<24>>24<=65){a=g;t=A;return a|0}XUc(z,91,g,1,0,127139+((c<<24>>24<<1)+-132)|0,-1)|0;a=g;t=A;return a|0}do if((c|0)<0){g=f[a+52>>2]|0;if((g|0)>=0){c=g+-1|0;break}i=f[y+44>>2]|0;c=d[y+32>>1]|0;if(c<<16>>16<0){a=~g;t=A;return a|0}l=c<<16>>16;m=f[i+4>>2]|0;n=m+(l*20|0)|0;i=((vTc(i,c)|0)<<16>>16)-g|0;k=m+(l*20|0)+16|0;g=j[k>>1]|0;if(!(g&96)){if((b[m+(l*20|0)+13>>0]|0)!=69){a=i;t=A;return a|0}TUc(z,78,i,e)|0;iVc(z,84,e)|0;a=e;t=A;return a|0}if(g&256|0){f[u>>2]=f[n>>2];TIc(a,127109,u);a=0;t=A;return a|0}c=(g|256)&65535;d[k>>1]=c;if(g&128){qVc(a,n,i);c=d[k>>1]|0}d[k>>1]=c&-385;a=i;t=A;return a|0}while(0);x=y+44|0;c=xVc(a,f[x>>2]|0,d[y+32>>1]|0,c,e,b[y+2>>0]|0)|0;if(f[x>>2]|0){a=c;t=A;return a|0}if((b[y+1>>0]|0)!=69){a=c;t=A;return a|0}iVc(z,84,c)|0;a=c;t=A;return a|0}else if((x|0)==46){c=f[y+12>>2]|0;if(!(CVc(c)|0)){x=EVc(a,c,v)|0;u=y+16|0;z=EVc(a,f[u>>2]|0,w)|0;FVc(a,c,f[u>>2]|0,g,x,z,e,i|32,(f[y+4>>2]|0)>>>9&1);c=e;break}else{DVc(a,y,e,g&255,i&255);c=e;break}}while(0);$Vc(a,f[v>>2]|0);$Vc(a,f[w>>2]|0);a=c;t=A;return a|0}function xVc(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;a=a+8|0;kVc(f[a>>2]|0,c,g,e,h);if(!(i<<24>>24))return h|0;a=oVc(f[a>>2]|0,-1)|0;if((b[a>>0]|0)!=90)return h|0;d[a+2>>1]=i&255;return h|0}function yVc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;l=n+8|0;j=n;k=f[a+8>>2]|0;if(f[b+4>>2]&1024|0){m=f[b+8>>2]|0;TUc(k,69,(c|0)==0?m:0-m|0,d)|0;t=n;return}b=f[b+8>>2]|0;e=bXc(b,j)|0;g=(c|0)!=0;if(!((e|0)==2|(g|(e|0)!=3)^1)?(i=j,h=f[i>>2]|0,i=f[i+4>>2]|0,!(g&((h|0)==0&(i|0)==-2147483648))):0){if(g){c=(e|0)==3;i=wrd(0,0,h|0,i|0)|0;l=j;f[l>>2]=c?0:i;f[l+4>>2]=c?-2147483648:G}$Wc(k,70,d,j,-14)}else m=5;do if((m|0)==5)if(!(QBc(b,127587,2)|0)){f[l>>2]=g?121820:155644;f[l+4>>2]=b;TIc(a,127590,l);break}else{AVc(k,b,c,d);break}while(0);t=n;return}function zVc(a){a=a|0;a=(aXc(a)|0)+8|0;return (b[(f[a>>2]|0)+4>>0]|0)==0|0}function AVc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;f=t;t=t+16|0;e=f;if(!b){t=f;return}pyc(b,e,Mxc(b)|0,1)|0;if(c|0)p[e>>3]=-+p[e>>3];$Wc(a,152,d,e,-13);t=f;return}function BVc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if(!a){e=0;return e|0}d=f[a+4>>2]|0;c=2;while(1){if((f[a+(c<<2)>>2]|0)==(b|0))break;c=(f[a+(c+1<<2)>>2]|0)+c|0;if((c|0)>=(d|0)){c=0;e=6;break}}if((e|0)==6)return c|0;e=a+(c+2<<2)|0;return e|0}function CVc(a){a=a|0;return (mTc(a)|0)>1|0}function DVc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;x=t;t=t+32|0;s=x+16|0;u=x+12|0;v=x+8|0;w=x+4|0;o=f[a+8>>2]|0;p=f[b+12>>2]|0;q=f[b+16>>2]|0;g=mTc(p)|0;r=QVc(a)|0;k=(f[b+4>>2]|0)>>>9&1;if(f[a+36>>2]|0){t=x;return}if((g|0)!=(mTc(q)|0)){TIc(a,122503,x);t=x;return}i=d<<24>>24==55?56:d;l=ZWc(a,p)|0;m=ZWc(a,q)|0;n=g+-1|0;j=g+-2|0;b=e|32;h=0;g=i<<24>>24==57?54:i;while(1){f[s>>2]=0;f[u>>2]=0;y=_Wc(a,p,h,l,v,s)|0;i=_Wc(a,q,h,m,w,u)|0;e=b&255;FVc(a,f[v>>2]|0,f[w>>2]|0,g&255,y,i,c,e,k);$Vc(a,f[s>>2]|0);$Vc(a,f[u>>2]|0);a:do if((h|0)==(n|0))i=0;else switch(g<<24>>24){case 53:{TUc(o,20,c,r)|0;i=1;b=(e|8)&255;g=53;break a}case 52:{TUc(o,18,c,r)|0;i=1;b=(e|8)&255;g=52;break a}default:{TUc(o,58,0,r)|0;i=1;g=(h|0)==(j|0)?d:g;break a}}while(0);if(i)h=h+1|0;else break}SVc(o,r);t=x;return}function EVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=kSc(c)|0;if(((e|0)!=0&(b[a+23>>0]|0)!=0?(b[e>>0]|0)!=-81:0)?GVc(e)|0:0){f[d>>2]=0;d=HVc(a,e,-1)|0;return d|0}c=hWc(a)|0;e=wVc(a,e,c)|0;if((e|0)!=(c|0)){$Vc(a,c);c=0}f[d>>2]=c;d=e;return d|0}function FVc(a,b,c,d,e,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;if(f[a+36>>2]|0)return;if(!j)j=MIc(a,b,c)|0;else j=MIc(a,c,b)|0;i=YWc(b,c,i)|0;c=a+8|0;XUc(f[c>>2]|0,d,g,h,e,j,-2)|0;_Uc(f[c>>2]|0,i&255);return}function GVc(a){a=a|0;return VWc(a,2,0)|0}function HVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;j=a+68|0;h=f[j>>2]|0;k=(d|0)<0;a:do if(k&(h|0)!=0){e=f[h>>2]|0;g=h+4|0;while(1){if((e|0)<=0)break a;if(b[g+9>>0]&8?(qSc(0,f[g>>2]|0,c,-1)|0)==0:0)break;e=e+-1|0;g=g+16|0}a=f[g+12>>2]|0;return a|0}while(0);i=oSc(f[a>>2]|0,c,0)|0;if(i|0?f[i+4>>2]&4|0:0){g=f[a+8>>2]|0;c=QUc(g,17)|0;h=a+23|0;b[h>>0]=0;e=f[a>>2]|0;if(!(b[e+83>>0]|0)){if(k){k=a+44|0;d=(f[k>>2]|0)+1|0;f[k>>2]=d}vVc(a,i,d);e=f[a>>2]|0}b[h>>0]=1;dzc(e,i);mVc(g,c);a=d;return a|0}g=tQc(a,h,i)|0;if(g){e=(f[g>>2]|0)+-1|0;i=g+4+(e<<4)+9|0;b[i>>0]=b[i>>0]&-9|d>>>28&8;if(k){a=a+44|0;d=(f[a>>2]|0)+1|0;f[a>>2]=d}f[g+4+(e<<4)+12>>2]=d}f[j>>2]=g;a=d;return a|0}function IVc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+64|0;h=k;j=f[a+8>>2]|0;i=f[c>>2]|0;switch(d|0){case 0:{g=QVc(a)|0;vVc(a,f[c+4>>2]|0,e);d=1;while(1){if((d|0)>=(i|0))break;TUc(j,51,e,g)|0;vVc(a,f[c+4+(d<<4)>>2]|0,e);d=d+1|0}ZVc(j);SVc(j,g);t=k;return e|0}case 5:{d=h;g=d+52|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(g|0));b[h>>0]=-100;f[h+20>>2]=c;e=wVc(a,h,e)|0;t=k;return e|0}case 3:{TUc(j,69,qSc(0,f[c+4>>2]|0,f[c+20>>2]|0,-1)|0,e)|0;t=k;return e|0}case 2:{TUc(j,69,RWc(a,f[c+4>>2]|0,f[c+20>>2]|0,-1)|0,e)|0;t=k;return e|0}case 1:{d=f[c+20>>2]|0;if((b[d>>0]|0)==-90){TUc(j,69,SWc(f[c+4>>2]|0,f[d+28>>2]|0)|0,e)|0;t=k;return e|0}else{TUc(j,72,0,e)|0;t=k;return e|0}}default:{e=wVc(a,f[c+4>>2]|0,e)|0;t=k;return e|0}}return 0}function JVc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;if((b|0)==1){g=hWc(a)|0;return g|0}c=a+32|0;d=f[c>>2]|0;e=a+28|0;g=f[e>>2]|0;if((g|0)<(b|0)){e=a+44|0;g=f[e>>2]|0;f[e>>2]=g+b;g=g+1|0;return g|0}else{f[c>>2]=d+b;f[e>>2]=g-b;g=d;return g|0}return 0}function KVc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;n=h&255;t=78-(n&1)|0;u=f[a+8>>2]|0;n=((b[a+23>>0]|0)==0?n&253:h)&255;l=(n&4|0)==0;m=(n&2|0)==0;n=(n&8|0)==0;o=(t|0)==77;k=g+-1|0;j=c+4|0;h=0;g=f[c>>2]|0;while(1){if((h|0)>=(g|0))break;c=f[j>>2]|0;do if(!l?(i=d[j+12>>1]|0,p=i&65535,i<<16>>16!=0):0)if(n){TUc(u,t,k+p|0,h+e|0)|0;break}else{h=h+-1|0;g=g+-1|0;break}else v=8;while(0);do if((v|0)==8){v=0;if(!m?GVc(c)|0:0){HVc(a,c,h+e|0)|0;break}i=h+e|0;c=wVc(a,c,i)|0;if((c|0)!=(i|0)){if((((o?(q=oVc(u,-1)|0,(b[q>>0]|0)==77):0)?(r=q+12|0,s=(f[r>>2]|0)+1|0,(s+(f[q+4>>2]|0)|0)==(c|0)):0)?(s+(f[q+8>>2]|0)|0)==(i|0):0)?(d[q+2>>1]|0)==0:0){f[r>>2]=s;break}TUc(u,t,c,i)|0}}while(0);j=j+16|0;h=h+1|0}return}function LVc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;i=k+4|0;j=k;f[i>>2]=0;f[j>>2]=0;if(!e){j=c;t=k;return j|0}if((b[e>>0]|0)!=-90){j=c;t=k;return j|0}e=f[e+44>>2]|0;if(!e){j=c;t=k;return j|0}if(!(f[e+56>>2]|0)){j=c;t=k;return j|0}e=(XTc(a,e)|0)+8|0;e=f[e>>2]|0;g=f[(f[e>>2]|0)+72>>2]|0;if(!g){j=c;t=k;return j|0}h=c+32|0;if(!(zd[g&127](e,d,f[h>>2]|0,i,j)|0)){j=c;t=k;return j|0}a=$Ec(a,(Mxc(f[h>>2]|0)|0)+41|0,0)|0;if(!a){j=c;t=k;return j|0}d=a;e=c;g=d+40|0;do{f[d>>2]=f[e>>2];d=d+4|0;e=e+4|0}while((d|0)<(g|0));c=a+40|0;f[a+32>>2]=c;h=f[h>>2]|0;Krd(c|0,h|0,(Mxc(h)|0)+1|0)|0;f[a+16>>2]=f[i>>2];f[a+8>>2]=f[j>>2];j=a+4|0;f[j>>2]=f[j>>2]|16;j=a;t=k;return j|0}function MVc(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0;k=f[a+8>>2]|0;j=(g<<2)+28|0;j=uxc(f[a>>2]|0,j,((j|0)<0)<<31>>31)|0;if(!j){Qyc(f[a>>2]|0,h);return}else{f[j>>2]=0;f[j+4>>2]=h;f[j+12>>2]=0;f[j+20>>2]=0;b[j+25>>0]=g;h=vWc(k)|0;f[j+16>>2]=h;XUc(k,(i|0)==0?64:63,c,d,e,j,-16)|0;_Uc(k,i&46);return}}function NVc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((c|0)==1){$Vc(a,b);return}d=a+28|0;if((f[d>>2]|0)>=(c|0))return;f[d>>2]=c;f[a+32>>2]=b;return}function OVc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+48|0;h=n+8|0;g=n;k=n+16|0;m=f[a+8>>2]|0;l=f[c+20>>2]|0;d=c+4|0;e=f[d>>2]|0;do if(!(e&32)){if(!(e&33554432)){f[d>>2]=e|33554432;j=a+44|0;i=(f[j>>2]|0)+1|0;f[j>>2]=i;f[c+48>>2]=i;i=(TUc(m,69,0,i)|0)+1|0;f[c+44>>2]=i;i=QUc(m,17)|0;break}f[g>>2]=f[l+16>>2];mWc(a,0,127548,g);TUc(m,12,f[c+48>>2]|0,f[c+44>>2]|0)|0;m=f[c+28>>2]|0;t=n;return m|0}else i=0;while(0);j=(i|0)!=0;g=f[l+16>>2]|0;f[h>>2]=j?155644:127377;f[h+4>>2]=g;mWc(a,1,127566,h);if((b[c>>0]|0)==-119)d=f[f[l+28>>2]>>2]|0;else d=1;h=a+44|0;tWc(k,0,(f[h>>2]|0)+1|0);f[h>>2]=(f[h>>2]|0)+d;if((b[c>>0]|0)==-119){b[k>>0]=10;h=f[k+4>>2]|0;f[k+12>>2]=h;f[k+16>>2]=d;UUc(m,72,0,h,d+-1+h|0)|0}else{b[k>>0]=3;TUc(m,69,0,f[k+4>>2]|0)|0}e=l+60|0;g=f[a>>2]|0;if(!(f[e>>2]|0)){h=bQc(a,147,wQc(g,154,121304)|0,0)|0;f[e>>2]=h}else{d=wQc(g,154,121302)|0;if(!d)d=0;else{b[d+1>>0]=67;d=bQc(a,52,oSc(g,f[(f[e>>2]|0)+12>>2]|0,0)|0,d)|0}dzc(g,f[(f[e>>2]|0)+12>>2]|0);f[(f[e>>2]|0)+12>>2]=d}f[l+8>>2]=0;if(oQc(a,l,k)|0){m=0;t=n;return m|0}d=f[k+4>>2]|0;f[c+28>>2]=d;if(!j){m=d;t=n;return m|0}mVc(m,i);iVc(m,65,f[c+48>>2]|0)|0;c=(f[c+44>>2]|0)+-1|0;wWc(m,c,(vWc(m)|0)+-1|0);xWc(a);m=d;t=n;return m|0}function PVc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if(f[a+36>>2]|0){t=e;return}f[d>>2]=b;f[d+4>>2]=c;TIc(a,127504,d);t=e;return}function QVc(a){a=a|0;var b=0;b=a+56|0;a=(f[b>>2]|0)+-1|0;f[b>>2]=a;return a|0}function RVc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0;w=t;t=t+16|0;l=w+12|0;j=w+4|0;o=w;f[l>>2]=0;f[j>>2]=0;g=a+23|0;h=b[g>>0]|0;k=c+12|0;n=f[k>>2]|0;if(eWc(a,c)|0){t=w;return}r=fWc(a,c)|0;p=mTc(f[k>>2]|0)|0;s=$Ec(f[a>>2]|0,(p*5|0)+1|0,0)|0;if(!(b[(f[a>>2]|0)+83>>0]|0)){u=f[a+8>>2]|0;m=(d|0)==(e|0);i=gWc(a,c,3,m?0:l,s,j)|0;b[g>>0]=0;v=VVc(a,n,w+8|0)|0;b[g>>0]=h;g=0;while(1){if((g|0)>=(p|0))break;if((f[s+(g<<2)>>2]|0)!=(g|0))break;g=g+1|0}a:do if((g|0)==(p|0))q=v;else{h=JVc(a,p)|0;g=0;while(1){if((g|0)>=(p|0)){q=h;break a}UUc(u,77,g+v|0,(f[s+(g<<2)>>2]|0)+h|0,0)|0;g=g+1|0}}while(0);b:do if((i|0)!=5){if(m){g=d;c=0}else{c=QVc(a)|0;g=c}if(!(f[a+36>>2]|0)){h=0;while(1){if((h|0)>=(p|0))break;if(eTc(iWc(f[k>>2]|0,h)|0)|0)TUc(u,50,h+q|0,g)|0;h=h+1|0}do if((i|0)!=1){XUc(u,91,q,p,0,r,p)|0;g=f[j>>2]|0;if(m){lVc(u,29,g,d,q,p)|0;break b}else{k=lVc(u,30,g,0,q,p)|0;break}}else{g=f[j>>2]|0;UUc(u,31,g,d,q)|0;k=QUc(u,11)|0}while(0);h=f[l>>2]|0;if((p|0)==1&(h|0)!=0)TUc(u,51,h,d)|0;if(m)YVc(u,d)|0;if(c|0)SVc(u,c);i=TUc(u,37,g,d)|0;j=(p|0)>1;if(j)h=QVc(a)|0;else h=d;c=0;while(1){if((c|0)>=(p|0))break;o=hWc(a)|0;m=NIc(a,iWc(n,c)|0)|0;UUc(u,90,g,c,o)|0;XUc(u,52,c+q|0,h,o,m,-2)|0;$Vc(a,o);c=c+1|0}TUc(u,11,0,e)|0;if(j){SVc(u,h);TUc(u,5,g,i+1|0)|0;TUc(u,11,0,d)|0}mVc(u,k)}}else{n=f[c+20>>2]|0;i=NIc(a,f[k>>2]|0)|0;j=QVc(a)|0;k=(e|0)!=(d|0);if(k){c=hWc(a)|0;UUc(u,102,q,q,c)|0}else c=0;l=(c|0)==0;h=0;while(1){if((h|0)>=(f[n>>2]|0))break;g=n+4+(h<<4)|0;m=EVc(a,f[g>>2]|0,o)|0;if(!l?eTc(f[g>>2]|0)|0:0)UUc(u,102,c,m,c)|0;$Vc(a,f[o>>2]|0);g=(q|0)==(m|0);if(k|(h|0)<((f[n>>2]|0)+-1|0)){XUc(u,g?51:53,q,j,m,i,-2)|0;_Uc(u,b[r>>0]|0)}else{XUc(u,g?50:52,q,d,m,i,-2)|0;_Uc(u,(b[r>>0]|16)<<24>>24)}h=h+1|0}if(!l){TUc(u,50,c,e)|0;YVc(u,d)|0}SVc(u,j);$Vc(a,c)}while(0);if((q|0)!=(v|0))$Vc(a,q)}nxc(f[a>>2]|0,s);nxc(f[a>>2]|0,r);t=w;return}function SVc(a,b){a=a|0;b=b|0;var c=0;c=f[a+12>>2]|0;b=~b;if(((f[c+56>>2]|0)+(f[c+60>>2]|0)|0)<0){dWc(c,a,b);return}else{f[(f[c+64>>2]|0)+(b<<2)>>2]=f[a+108>>2];return}}function TVc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+160|0;j=o+108|0;k=o+56|0;l=o+4|0;m=o;f[m>>2]=0;n=f[a>>2]|0;h=k;i=h+52|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));h=l;i=h+52|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));h=j;i=h+52|0;do{f[h>>2]=0;h=h+4|0}while((h|0)<(i|0));h=oSc(n,f[c+12>>2]|0,0)|0;if(b[n+83>>0]|0){dzc(n,h);t=o;return}b[j>>0]=44;f[j+12>>2]=k;f[j+16>>2]=l;b[k>>0]=57;f[k+12>>2]=h;c=f[c+20>>2]|0;f[k+16>>2]=f[c+4>>2];b[l>>0]=55;f[l+12>>2]=h;f[l+16>>2]=f[c+20>>2];WVc(h,VVc(a,h,m)|0);if(!e){l=h+4|0;f[l>>2]=f[l>>2]|1;wVc(a,j,d)|0}else Md[e&31](a,j,d,g);$Vc(a,f[m>>2]|0);dzc(n,h);t=o;return}function UVc(a,b,c){a=a|0;b=b|0;c=c|0;b=(oVc(a,b)|0)+12|0;f[b>>2]=c;return}function VVc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=mTc(c)|0;if((g|0)==1){g=EVc(a,c,d)|0;return g|0}f[d>>2]=0;if((b[c>>0]|0)==-119){g=OVc(a,c)|0;return g|0}e=a+44|0;h=f[e>>2]|0;d=h+1|0;f[e>>2]=h+g;e=c+20|0;c=0;while(1){if((c|0)>=(g|0))break;cWc(a,f[(f[e>>2]|0)+4+(c<<4)>>2]|0,c+d|0);c=c+1|0}return d|0}function WVc(a,c){a=a|0;c=c|0;a=kSc(a)|0;if(!a)return;b[a+2>>0]=b[a>>0]|0;b[a>>0]=-81;f[a+28>>2]=c;c=a+4|0;f[c>>2]=f[c>>2]&-4097;return}function XVc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=t;t=t+16|0;m=n+4|0;j=n;k=f[a+8>>2]|0;f[m>>2]=0;f[j>>2]=0;if((c|0)==0|(k|0)==0){t=n;return}h=b[c>>0]|0;g=(h^1)&255;a:do switch(h<<24>>24){case 43:case 44:{g=aWc(c)|0;if((g|0)!=(c|0)){XVc(a,g,d,e);g=0;break a}if(h<<24>>24==44){XVc(a,f[c+12>>2]|0,d,e);XVc(a,f[c+16>>2]|0,d,e);g=0;break a}else{g=QVc(a)|0;bWc(a,f[c+12>>2]|0,g,e^16);XVc(a,f[c+16>>2]|0,d,e);SVc(k,g);g=0;break a}}case 19:{bWc(a,f[c+12>>2]|0,d,e);g=0;break}case -82:{e=(b[c+2>>0]|0)==-86;k=(zVc(f[c+16>>2]|0)|0)==(e&1|0);g=f[c+12>>2]|0;e=e?0:16;if(k){bWc(a,g,d,e);g=0;break a}else{XVc(a,g,d,e);g=0;break a}}case -86:case 45:{e=128;g=h<<24>>24==45?52:53;l=13;break}case 53:case 52:case 57:case 54:case 55:case 56:{l=13;break}case 51:case 50:{TUc(k,g,EVc(a,f[c+12>>2]|0,m)|0,d)|0;g=0;break}case 48:{TVc(a,c,d,30,e);g=0;break}case 49:if(!e){g=QVc(a)|0;RVc(a,c,d,g);SVc(k,g);g=0;break a}else{RVc(a,c,d,d);g=0;break a}default:l=20}while(0);if((l|0)==13){h=c+12|0;i=f[h>>2]|0;if(!(CVc(i)|0)){i=EVc(a,i,m)|0;o=c+16|0;k=EVc(a,f[o>>2]|0,j)|0;FVc(a,f[h>>2]|0,f[o>>2]|0,g,i,k,d,e,(f[c+4>>2]|0)>>>9&1);g=f[j>>2]|0}else l=20}do if((l|0)==20){g=f[c+4>>2]|0;if((g&536870913|0)==536870912){YVc(k,d)|0;g=0;break}if((g&268435457|0)==268435456)g=0;else{UUc(k,20,EVc(a,c,m)|0,d,(e|0)!=0&1)|0;g=0}}while(0);$Vc(a,f[m>>2]|0);$Vc(a,g);t=n;return}function YVc(a,b){a=a|0;b=b|0;return UUc(a,11,0,b,0)|0}function ZVc(a){a=a|0;var c=0;c=oVc(a,-1)|0;if((b[c>>0]|0)!=77)return;_Uc(a,1);return}function _Vc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0;g=OUc(a)|0;if((c|0)==2)MUc(a);XUc(g,68,b,c,0,d,e<<24>>24)|0;_Uc(g,f&255);return}function $Vc(a,c){a=a|0;c=c|0;var d=0,e=0;if(!c)return;d=a+19|0;e=b[d>>0]|0;if((e&255)>=8)return;b[d>>0]=e+1<<24>>24;f[a+148+((e&255)<<2)>>2]=c;return}function aWc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;c=b[a>>0]|0;if((c+-43&255)>=2){h=a;return h|0}e=aWc(f[a+16>>2]|0)|0;g=aWc(f[a+12>>2]|0)|0;h=f[g+4>>2]|0;if((h&268435457|0)!=268435456?(d=f[e+4>>2]|0,(d&536870913|0)!=536870912):0)return ((h&536870913|0)==536870912|(d&268435457|0)==268435456?(c<<24>>24==44?g:e):a)|0;h=c<<24>>24==44?e:g;return h|0}function bWc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=t;t=t+16|0;m=n+4|0;j=n;k=f[a+8>>2]|0;f[m>>2]=0;f[j>>2]=0;if((c|0)==0|(k|0)==0){t=n;return}h=b[c>>0]|0;g=h&255;a:do switch(h<<24>>24){case 43:case 44:{g=aWc(c)|0;if((g|0)!=(c|0)){bWc(a,g,d,e);g=0;break a}if(h<<24>>24==44){g=QVc(a)|0;XVc(a,f[c+12>>2]|0,g,e^16);bWc(a,f[c+16>>2]|0,d,e);SVc(k,g);g=0;break a}else{bWc(a,f[c+12>>2]|0,d,e);bWc(a,f[c+16>>2]|0,d,e);g=0;break a}}case 19:{XVc(a,f[c+12>>2]|0,d,e);g=0;break}case -82:{e=(b[c+2>>0]|0)==-86;k=(zVc(f[c+16>>2]|0)|0)==(e&1|0);g=f[c+12>>2]|0;e=e?16:0;if(k){XVc(a,g,d,e);g=0;break a}else{bWc(a,g,d,e);g=0;break a}}case -86:case 45:{e=128;g=h<<24>>24==45?53:52;l=13;break}case 53:case 52:case 57:case 54:case 55:case 56:{l=13;break}case 51:case 50:{TUc(k,g,EVc(a,f[c+12>>2]|0,m)|0,d)|0;g=0;break}case 48:{TVc(a,c,d,31,e);g=0;break}case 49:{g=QVc(a)|0;RVc(a,c,g,(e|0)==0?g:d);YVc(k,d)|0;SVc(k,g);g=0;break}default:l=18}while(0);if((l|0)==13){h=c+12|0;i=f[h>>2]|0;if(!(CVc(i)|0)){i=EVc(a,i,m)|0;o=c+16|0;k=EVc(a,f[o>>2]|0,j)|0;FVc(a,f[h>>2]|0,f[o>>2]|0,g,i,k,d,e,(f[c+4>>2]|0)>>>9&1);g=f[j>>2]|0}else l=18}do if((l|0)==18){g=f[c+4>>2]|0;if((g&268435457|0)==268435456){YVc(k,d)|0;g=0;break}if((g&536870913|0)==536870912)g=0;else{UUc(k,18,EVc(a,c,m)|0,d,(e|0)!=0&1)|0;g=0}}while(0);$Vc(a,f[m>>2]|0);$Vc(a,g);t=n;return}function cWc(a,c,d){a=a|0;c=c|0;d=d|0;if(b[a+23>>0]|0?GVc(c)|0:0){HVc(a,c,d)|0;return}uVc(a,c,d);return}function dWc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=10-(f[a+56>>2]|0)|0;g=a+64|0;d=eyc(f[a>>2]|0,f[g>>2]|0,e<<2,0)|0;f[g>>2]=d;a=a+60|0;if(!d){f[a>>2]=0;return}else{f[a>>2]=e;f[d+(c<<2)>>2]=f[b+108>>2];return}}function eWc(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[b+12>>2]|0;d=mTc(c)|0;if(!(f[b+4>>2]&2048)){if((d|0)==1){d=0;return d|0}QWc(a,c);d=1;return d|0}else{b=f[f[(f[b+20>>2]|0)+28>>2]>>2]|0;if((d|0)==(b|0)){d=0;return d|0}PVc(a,b,d);d=1;return d|0}return 0}function fWc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;h=f[c+12>>2]|0;i=mTc(h)|0;if(!(f[c+4>>2]&2048))c=0;else c=f[c+20>>2]|0;e=i+1|0;e=jxc(f[a>>2]|0,e,((e|0)<0)<<31>>31)|0;if(!e)return e|0;g=(c|0)==0;d=c+28|0;a=0;while(1){if((a|0)>=(i|0))break;c=$Rc(iWc(h,a)|0)|0;if(!g)c=nWc(f[(f[d>>2]|0)+4+(a<<4)>>2]|0,c)|0;b[e+a>>0]=c;a=a+1|0}b[e+i>>0]=0;return e|0}function gWc(a,c,e,g,i,k){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0;M=t;t=t+16|0;I=M+8|0;p=M;K=a+40|0;L=f[K>>2]|0;f[K>>2]=L+1;K=OUc(a)|0;J=(e&4|0)!=0;if(g){if(f[c+4>>2]&2048){m=f[(f[c+20>>2]|0)+28>>2]|0;n=f[m>>2]|0;l=0;while(1){if((l|0)>=(n|0))break;if(eTc(f[m+4+(l<<4)>>2]|0)|0)break;l=l+1|0}g=(l|0)==(n|0)?0:g}}else g=0;a:do if((f[a+36>>2]|0)==0?(o=jWc(c)|0,(o|0)!=0):0){E=f[o+28>>2]|0;F=f[E>>2]|0;o=f[(f[o+32>>2]|0)+24>>2]|0;C=zTc(f[a>>2]|0,f[o+72>>2]|0)|0;kWc(a,C);lWc(a,C,f[o+28>>2]|0,0,f[o>>2]|0);D=(F|0)==1;if(D?(d[(f[E+4>>2]|0)+32>>1]|0)<0:0){n=QUc(K,17)|0;hVc(a,L,C,o,97);f[p>>2]=f[o>>2];mWc(a,0,127276,p);mVc(K,n);n=1;break}B=c+12|0;l=1;m=0;while(1){n=(l|0)!=0;if(!((m|0)<(F|0)&n))break;z=iWc(f[B>>2]|0,m)|0;A=bSc(o,d[(f[E+4+(m<<4)>>2]|0)+32>>1]|0)|0;z=(((nWc(z,A)|0)<<24>>24)+-65|0)>>>0<2;l=z?l:A<<24>>24>66&1;m=m+1|0}if(n){w=(i|0)==0;x=Hrd(1,0,F|0)|0;x=vrd(x|0,G|0,-1,-1)|0;y=G;z=(g|0)==0;A=a+44|0;n=0;l=o+8|0;while(1){v=f[l>>2]|0;if(!((n|0)==0&(v|0)!=0)){q=44;break a}u=d[v+52>>1]|0;l=u&65535;do if((F|0)<=(l|0)?!((u&65535)>62|(f[v+36>>2]|0)!=0):0){if(J){if((F|0)<(j[v+50>>1]|0)){n=0;break}if((F|0)<(l|0)?(b[v+54>>0]|0)==0:0){n=0;break}}q=v+4|0;r=v+32|0;p=0;s=0;u=0;while(1){if((p|0)>=(F|0))break;l=iWc(f[B>>2]|0,p)|0;m=f[E+4+(p<<4)>>2]|0;l=MIc(a,l,m)|0;m=m+32|0;n=(l|0)==0;o=0;while(1){if((o|0)>=(F|0))break;if((d[(f[q>>2]|0)+(o<<1)>>1]|0)==(d[m>>1]|0)){if(n)break;if(!(wzc(f[l>>2]|0,f[(f[r>>2]|0)+(o<<2)>>2]|0)|0))break}o=o+1|0}if((o|0)==(F|0))break;l=Hrd(1,0,o|0)|0;m=G;if(!((l&s|0)==0&(m&u|0)==0))break;if(!w)f[i+(p<<2)>>2]=o;p=p+1|0;s=l|s;u=m|u}if((s|0)==(x|0)&(u|0)==(y|0)){l=QUc(K,17)|0;f[I>>2]=f[v>>2];mWc(a,0,127323,I);UUc(K,97,L,f[v+44>>2]|0,C)|0;oWc(a,v);n=(h[f[v+28>>2]>>0]|0)+3|0;if(!z?(H=(f[A>>2]|0)+1|0,f[A>>2]=H,f[g>>2]=H,D):0)pWc(K,L,H);mVc(K,l)}else n=0}else n=0;while(0);l=v+20|0}}else{n=0;q=44}}else{n=0;q=44}while(0);do if((q|0)==44){if((e&1|0)==0|(n|0)!=0){if(n|0)break}else if(!(f[c+4>>2]&2048)){if(!(qWc(c)|0)){n=5;break}if((f[f[c+20>>2]>>2]|0)<3){n=5;break}}m=a+132|0;n=f[m>>2]|0;if(!J)if(g){J=a+44|0;l=(f[J>>2]|0)+1|0;f[J>>2]=l;f[g>>2]=l;rWc(a,c,L);if(l|0)pWc(K,L,l)}else q=52;else{f[m>>2]=0;q=52}if((q|0)==52)rWc(a,c,L);f[m>>2]=n;n=2}while(0);if(!((i|0)!=0&(n+-3|0)>>>0>1)){f[k>>2]=L;t=M;return n|0}m=mTc(f[c+12>>2]|0)|0;l=0;while(1){if((l|0)>=(m|0))break;f[i+(l<<2)>>2]=l;l=l+1|0}f[k>>2]=L;t=M;return n|0}function hWc(a){a=a|0;var c=0,d=0;c=a+19|0;d=b[c>>0]|0;if(!(d<<24>>24)){c=a+44|0;d=(f[c>>2]|0)+1|0;f[c>>2]=d;return d|0}else{d=d+-1<<24>>24;b[c>>0]=d;d=f[a+148+((d&255)<<2)>>2]|0;return d|0}return 0}function iWc(a,c){a=a|0;c=c|0;if(!(CVc(a)|0)){c=a;return c|0}if((b[a>>0]|0)!=-119?(b[a+2>>0]|0)!=-119:0)a=a+20|0;else a=(f[a+20>>2]|0)+28|0;c=f[(f[a>>2]|0)+4+(c<<4)>>2]|0;return c|0}function jWc(a){a=a|0;var c=0,d=0,e=0;if((f[a+4>>2]&2080|0)!=2048){e=0;return e|0}a=f[a+20>>2]|0;if(f[a+52>>2]|0){e=0;return e|0}if(f[a+4>>2]&9|0){e=0;return e|0}if(f[a+60>>2]|0){e=0;return e|0}if(f[a+36>>2]|0){e=0;return e|0}c=f[a+32>>2]|0;if((f[c>>2]|0)!=1){e=0;return e|0}if(f[c+28>>2]|0){e=0;return e|0}if(f[(f[c+24>>2]|0)+56>>2]|0){e=0;return e|0}d=f[a+28>>2]|0;e=f[d>>2]|0;c=0;while(1){if((c|0)>=(e|0)){c=12;break}if((b[f[d+4+(c<<4)>>2]>>0]|0)==-90)c=c+1|0;else{a=0;c=12;break}}if((c|0)==12)return a|0;return 0}function kWc(a,b){a=a|0;b=b|0;var c=0;c=f[a+116>>2]|0;AWc((c|0)==0?a:c,b);return}function lWc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0;if((c|0)==1)return;if(!(aVc(f[(f[(f[a>>2]|0)+16>>2]|0)+(c<<4)+4>>2]|0)|0))return;l=f[a+116>>2]|0;l=(l|0)==0?a:l;j=l+104|0;h=f[j>>2]|0;k=l+108|0;a=0;while(1){if((a|0)>=(h|0))break;i=f[k>>2]|0;if((f[i+(a<<4)>>2]|0)==(c|0)?(f[i+(a<<4)+4>>2]|0)==(d|0):0){m=7;break}a=a+1|0}if((m|0)==7){g=i+(a<<4)+8|0;b[g>>0]=(b[g>>0]|e)<<24>>24!=0&1;return}a=(h<<4)+16|0;a=eyc(f[l>>2]|0,f[k>>2]|0,a,((a|0)<0)<<31>>31)|0;f[k>>2]=a;if(!a){f[j>>2]=0;Cxc(f[l>>2]|0);return}else{m=f[j>>2]|0;f[j>>2]=m+1;f[a+(m<<4)>>2]=c;f[a+(m<<4)+4>>2]=d;b[a+(m<<4)+8>>0]=e;f[a+(m<<4)+12>>2]=g;return}}function mWc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;h=t;t=t+16|0;g=h;if((b[a+199>>0]|0)!=2){t=h;return}f[g>>2]=e;e=FIc(f[a>>2]|0,d,g)|0;i=f[a+8>>2]|0;g=f[i+108>>2]|0;d=a+212|0;XUc(i,177,g,f[d>>2]|0,0,e,-7)|0;if(c<<24>>24)f[d>>2]=g;t=h;return}function nWc(a,b){a=a|0;b=b|0;a=$Rc(a)|0;if(b<<24>>24>64&a<<24>>24>64)return (b<<24>>24>66|a<<24>>24>66?67:65)|0;else return (a<<24>>24<65?b:a)|64|0;return 0}function oWc(a,b){a=a|0;b=b|0;var c=0;c=f[a+8>>2]|0;a=yWc(a,b)|0;if(!a)return;tVc(c,a,-9);return}function pWc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;TUc(a,69,0,c)|0;d=iVc(a,37,b)|0;UUc(a,90,b,0,c)|0;_Uc(a,128);mVc(a,d);return}function qWc(a){a=a|0;var b=0,c=0;b=a+12|0;c=f[b>>2]|0;f[b>>2]=0;a=XQc(a)|0;f[b>>2]=c;return a|0}function rWc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=t;t=t+48|0;k=r+8|0;g=r;m=r+36|0;q=f[a+8>>2]|0;n=c+4|0;e=f[n>>2]|0;do if((e&32|0)==0?(f[a+52>>2]|0)==0:0){if(!(e&33554432)){f[n>>2]=e|33554432;p=a+44|0;e=(f[p>>2]|0)+1|0;f[p>>2]=e;f[c+48>>2]=e;e=(TUc(q,69,0,e)|0)+1|0;f[c+44>>2]=e;e=QUc(q,17)|0;break}e=QUc(q,17)|0;if(f[n>>2]&2048|0){f[g>>2]=f[(f[c+20>>2]|0)+16>>2];mWc(a,0,127354,g)}TUc(q,12,f[c+48>>2]|0,f[c+44>>2]|0)|0;TUc(q,99,d,f[c+28>>2]|0)|0;mVc(q,e);t=r;return}else e=0;while(0);h=c+12|0;j=f[h>>2]|0;i=mTc(j)|0;f[c+28>>2]=d;o=TUc(q,101,d,i)|0;p=sWc(f[a>>2]|0,i,1)|0;if(!(f[n>>2]&2048)){i=f[c+20>>2]|0;if(i){g=$Rc(j)|0;b[m>>0]=g;if(g<<24>>24>=65){if(g<<24>>24==69)b[m>>0]=67}else b[m>>0]=65;if(p|0){l=NIc(a,f[h>>2]|0)|0;f[p+20>>2]=l}k=hWc(a)|0;l=hWc(a)|0;j=i+4|0;h=f[i>>2]|0;while(1){if((h|0)<=0)break;g=f[j>>2]|0;if(e){if(!(XQc(g)|0)){uWc(q,e)|0;f[n>>2]=f[n>>2]&-33554433;e=0}}else e=0;vVc(a,g,k);XUc(q,92,k,1,l,m,1)|0;lVc(q,133,d,l,k,1)|0;j=j+16|0;h=h+-1|0}$Vc(a,k);$Vc(a,l)}}else{g=f[c+20>>2]|0;h=f[g+28>>2]|0;n=f[g+16>>2]|0;f[k>>2]=(e|0)==0?127377:155644;f[k+4>>2]=n;mWc(a,1,127389,k);if((f[h>>2]|0)==(i|0)){tWc(k,11,d);d=fWc(a,c)|0;n=k+20|0;f[n>>2]=d;f[g+8>>2]=0;d=(oQc(a,g,k)|0)==0;nxc(f[a>>2]|0,f[n>>2]|0);if(!d){Pyc(p);t=r;return}g=0;while(1){if((g|0)>=(i|0))break;d=iWc(j,g)|0;d=MIc(a,d,f[h+4+(g<<4)>>2]|0)|0;f[p+20+(g<<2)>>2]=d;g=g+1|0}}}if(p|0)YUc(q,o,p,-9);if(!e){t=r;return}mVc(q,e);iVc(q,65,f[c+48>>2]|0)|0;c=(f[c+44>>2]|0)+-1|0;wWc(q,c,(vWc(q)|0)+-1|0);xWc(a);t=r;return}function sWc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0;e=e+c|0;g=e*5|0;h=uxc(a,g+20|0,0)|0;if(!h){Cxc(a);return h|0}else{f[h+16>>2]=h+20+(e<<2);d[h+6>>1]=c;d[h+8>>1]=e;b[h+4>>0]=b[a+80>>0]|0;f[h+12>>2]=a;f[h>>2]=1;Mrd(h+24|0,0,g+-4|0)|0;return h|0}return 0}function tWc(a,c,d){a=a|0;c=c|0;d=d|0;b[a>>0]=c;f[a+4>>2]=d;d=a+8|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;return}function uWc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;d=f[a>>2]|0;if(b[d+83>>0]|0){d=0;return d|0}a=f[a+104>>2]|0;g=a+(c*20|0)+1|0;e=a+(c*20|0)+16|0;Nyc(d,b[g>>0]|0,f[e>>2]|0);b[g>>0]=0;f[e>>2]=0;b[a+(c*20|0)>>0]=-80;d=1;return d|0}function vWc(a){a=a|0;return f[a+108>>2]|0}function wWc(a,b,c){a=a|0;b=b|0;c=c|0;b=(oVc(a,b)|0)+4|0;f[b>>2]=c;return}function xWc(a){a=a|0;b[a+19>>0]=0;f[a+28>>2]=0;return}function yWc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,k=0,l=0,m=0,n=0;l=j[c+52>>1]|0;e=j[c+50>>1]|0;m=a+36|0;if(f[m>>2]|0){n=0;return n|0}n=c+55|0;d=f[a>>2]|0;if(!((h[n>>0]|h[n+1>>0]<<8)&8))k=sWc(d,l,0)|0;else k=sWc(d,e,l-e|0)|0;if(!k){n=0;return n|0}i=c+32|0;c=c+28|0;g=k+16|0;e=0;while(1){if((e|0)==(l|0))break;d=f[(f[i>>2]|0)+(e<<2)>>2]|0;if((d|0)==120777)d=0;else d=zWc(a,d)|0;f[k+20+(e<<2)>>2]=d;b[(f[g>>2]|0)+e>>0]=b[(f[c>>2]|0)+e>>0]|0;e=e+1|0}if(!(f[m>>2]|0)){n=k;return n|0}d=h[n>>0]|h[n+1>>0]<<8;if(!(d&256)){m=d|256;b[n>>0]=m;b[n+1>>0]=m>>8;f[a+12>>2]=513}Pyc(k);n=0;return n|0}function zWc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;e=f[a>>2]|0;d=b[e+80>>0]|0;g=b[e+169>>0]|0;e=OIc(e,d,c,g&255)|0;if(g<<24>>24){g=e;return g|0}if(e|0?f[e+12>>2]|0:0){g=e;return g|0}g=PIc(a,d,e,c)|0;return g|0}function AWc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+84|0;d=f[c>>2]|0;e=1<<b;if(d&e|0)return;f[c>>2]=d|e;if((b|0)!=1)return;BWc(a)|0;return}function BWc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;c=h+4|0;e=f[a>>2]|0;g=e+16|0;if(f[(f[g>>2]|0)+20>>2]|0){g=0;t=h;return g|0}if(b[a+199>>0]|0){g=0;t=h;return g|0}d=CWc(f[e>>2]|0,0,e,c,0,542)|0;if(d|0){TIc(a,127408,h);f[a+12>>2]=d;g=1;t=h;return g|0}d=f[c>>2]|0;f[(f[g>>2]|0)+20>>2]=d;if((DWc(d,f[e+96>>2]|0,0,0)|0)==7){Cxc(e);g=1;t=h;return g|0}else{g=0;t=h;return g|0}return 0}function CWc(a,c,e,g,i,j){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;y=t;t=t+112|0;v=y;u=(c|0)==0;if(!u){k=(b[c>>0]|0)==0;if(ncd(c,127478)|0)if(k)w=4;else{k=0;w=5}else w=6}else w=4;if((w|0)==4)if(!(kPc(e)|0)){k=1;w=5}else{k=1;w=6}if((w|0)==5)if(!(j&128)){s=0;r=i}else w=6;if((w|0)==6){s=1;r=i|2}q=(j&256|0)!=0&(s|k)?j&-769|512:j;x=DCc(48,0)|0;if(!x){g=7;t=y;return g|0}b[x+8>>0]=0;f[x>>2]=e;f[x+32>>2]=x;f[x+36>>2]=1;if(!k?!((q&131072|0)==0|s&(q&64|0)==0):0){i=(Mxc(c)|0)+1|0;j=(f[a+8>>2]|0)+1|0;p=(j|0)>(i|0)?j:i;p=vxc(p,((p|0)<0)<<31>>31)|0;k=x+9|0;b[k>>0]=1;if(!p){qxc(x);g=7;t=y;return g|0}a:do if(s)Krd(p|0,c|0,i|0)|0;else{i=EWc(a,c,j,p)|0;switch(i|0){case 512:case 0:break a;default:{}}qxc(p);qxc(x);g=i;t=y;return g|0}while(0);i=Mzc(4)|0;axc(i);o=Mzc(2)|0;axc(o);j=153952;while(1){j=f[j>>2]|0;if(!j){j=0;break}l=f[j>>2]|0;if((ncd(p,lOc(l,0)|0)|0)==0?(FWc(l)|0)==(a|0):0){w=20;break}j=j+72|0}do if((w|0)==20){n=e+16|0;m=f[e+20>>2]|0;while(1){l=m+-1|0;if((m|0)<=0){w=25;break}m=f[(f[n>>2]|0)+(l<<4)+4>>2]|0;if(m|0?(f[m+4>>2]|0)==(j|0):0)break;m=l}if((w|0)==25){f[x+4>>2]=j;w=j+68|0;f[w>>2]=(f[w>>2]|0)+1;break}bxc(o);bxc(i);qxc(p);qxc(x);g=19;t=y;return g|0}while(0);bxc(o);qxc(p);if(!j)w=29;else w=45}else{i=0;w=29}b:do if((w|0)==29){j=DCc(92,0)|0;if(j){k=HWc(a,j,c,84,r,q,810)|0;do if(!k){k=e+48|0;IWc(f[j>>2]|0,f[k>>2]|0,f[k+4>>2]|0);k=JWc(f[j>>2]|0,v)|0;if(!k){b[j+16>>0]=r;f[j+4>>2]=e;KWc(f[j>>2]|0,1238,j);f[x+4>>2]=j;f[j+8>>2]=0;f[j+12>>2]=0;m=f[j>>2]|0;if((hPc(m)|0)<<24>>24){c=j+24|0;d[c>>1]=d[c>>1]|1}c=h[v+17>>0]<<16|h[v+16>>0]<<8;n=j+36|0;f[n>>2]=c;if((c+-512|0)>>>0<=65024?(c+16777215&c|0)==0:0){k=b[v+20>>0]|0;l=j+24|0;d[l>>1]=d[l>>1]|2;l=(NJc(v+52|0)|0)!=0&1;b[j+17>>0]=l;l=(NJc(v+64|0)|0)!=0&1;w=39}else{f[n>>2]=0;if(u|s)k=0;else{b[j+17>>0]=0;k=0;l=0;w=39}}if((w|0)==39)b[j+18>>0]=l;l=k&255;k=KLc(m,n,l)|0;if(!k){f[j+40>>2]=(f[n>>2]|0)-l;f[j+68>>2]=1;k=x+9|0;if(!(b[k>>0]|0)){w=61;break b}l=Mzc(2)|0;if(b[40716]|0?(v=Mzc(0)|0,f[j+60>>2]=v,(v|0)==0):0){k=7;l=j;break}axc(l);f[j+72>>2]=f[38488];f[38488]=j;bxc(l);w=45;break b}else l=j}else l=j}else l=j;while(0);l=f[l>>2]|0;if(l)HOc(l,0)}else{k=7;j=0}qxc(j);qxc(x);f[g>>2]=0}while(0);c:do if((w|0)==45)if(!(b[k>>0]|0))w=61;else{n=f[e+20>>2]|0;m=e+16|0;k=0;while(1){if((k|0)>=(n|0)){w=61;break c}l=f[(f[m>>2]|0)+(k<<4)+4>>2]|0;if(l|0?b[l+9>>0]|0:0)break;k=k+1|0}while(1){k=f[l+28>>2]|0;if(!k)break;else l=k}k=f[x+4>>2]|0;if(k>>>0<(f[l+4>>2]|0)>>>0){f[x+24>>2]=l;f[x+28>>2]=0;f[l+28>>2]=x;w=61;break}while(1){m=f[l+24>>2]|0;if(!m){w=56;break}if((f[m+4>>2]|0)>>>0<k>>>0)l=m;else{w=58;break}}if((w|0)==56){f[x+24>>2]=0;f[x+28>>2]=l}else if((w|0)==58){f[x+24>>2]=m;f[x+28>>2]=l;f[m+28>>2]=x}f[l+24>>2]=x;w=61}while(0);if((w|0)==61){f[g>>2]=x;if(!(LWc(x,0,0)|0))uUc(x,-2e3);k=MWc(f[j>>2]|0)|0;if(!(f[k>>2]|0))k=0;else{tNc(k,30,j+4|0);k=0}}if(!i){g=k;t=y;return g|0}bxc(i);g=k;t=y;return g|0}function DWc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;i=f[a+4>>2]|0;Fzc(a);b[i+22>>0]=e;l=i+36|0;k=i+40|0;j=(f[l>>2]|0)-(f[k>>2]|0)|0;j=(j|0)>(e|0)?j:e;h=i+24|0;if(d[h>>1]&2){Bzc(a);l=8;return l|0}if((c+-512|0)>>>0<65025?(c+-1&c|0)==0:0){f[l>>2]=(c|0)==512&(j|0)>32?1024:c;IOc(i)}e=KLc(f[i>>2]|0,l,j)|0;f[k>>2]=(f[l>>2]|0)-(j&65535);if(g|0)d[h>>1]=d[h>>1]|2;Bzc(a);l=e;return l|0}function EWc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;b[e>>0]=0;return xd[f[a+36>>2]&63](a,c,d,e)|0}function FWc(a){a=a|0;return f[a>>2]|0}function GWc(a){a=a|0;var c=0;c=aMc(a)|0;if(!(b[c>>0]|0))return;b[c>>0]=0;if((kOc(a)|0)<=1)return;bOc(c)|0;return}function HWc(a,c,e,g,h,i,j){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=t;t=t+16|0;z=C+4|0;w=C;B=h&1;A=(B|0)!=0;f[z>>2]=4096;p=(NWc(a)|0)+7&-8;f[c>>2]=0;k=(e|0)==0;do if(!(h&2))if(!k)if(!(b[e>>0]|0)){v=0;h=1;n=0;q=0;m=0;o=1}else{m=a+8|0;k=(f[m>>2]|0)+1|0;q=k<<1;q=jxc(0,q,((q|0)<0)<<31>>31)|0;if(!q){B=7;t=C;return B|0}b[q>>0]=0;h=EWc(a,e,k,q)|0;k=(i&16777216|0)==0?0:1550;o=Mxc(q)|0;n=e+((Mxc(e)|0)+1)|0;l=n;while(1){if(!(b[l>>0]|0))break;v=l+((udd(l)|0)+1)|0;l=v+((udd(v)|0)+1)|0}k=(h|0)==512?k:h;h=l+1-n|0;if(!k){if((o+8|0)<=(f[m>>2]|0)){v=0;m=o;o=1;break}k=QAc(56886)|0;if(!k){v=0;m=o;o=1;break}}nxc(0,q);B=k;t=C;return B|0}else{e=0;v=0;h=1;n=0;q=0;m=0;o=0}else if(!k)if(b[e>>0]|0){k=UIc(0,e)|0;if(!k){B=7;t=C;return B|0}else{e=0;v=1;h=1;n=0;q=k;m=Mxc(k)|0;o=0;break}}else{v=1;h=1;n=0;q=0;m=0;o=1}else{e=0;v=1;h=1;n=0;q=0;m=0;o=0}while(0);k=a+4|0;s=DCc((m*3|0)+22+h+(((f[k>>2]|0)+279&-8)+(p<<1)|4)|0,0)|0;if(!s){nxc(0,q);B=7;t=C;return B|0}r=s+212|0;f[r>>2]=s+224;l=s+272|0;u=s+60|0;f[u>>2]=l;k=l+((f[k>>2]|0)+7&-8)|0;f[s+68>>2]=k;k=k+p|0;f[s+64>>2]=k;k=k+p|0;b[k>>0]=s;b[k+1>>0]=s>>8;b[k+2>>0]=s>>16;b[k+3>>0]=s>>24;k=k+4+4|0;p=s+168|0;f[p>>2]=k;if((m|0)<=0){f[s+172>>2]=0;f[s+220>>2]=0;if(m|0)y=23}else{Krd(k|0,q|0,m|0)|0;l=k+(m+1)|0;if(!n)k=1;else{Krd(l|0,n|0,h|0)|0;k=h}y=l+k|0;f[s+172>>2]=y;Krd(y|0,q|0,m|0)|0;y=y+m|0;n=y;l=n;b[l>>0]=45;b[l+1>>0]=106;b[l+2>>0]=111;b[l+3>>0]=117;n=n+4|0;b[n>>0]=114;b[n+1>>0]=110;b[n+2>>0]=97;b[n+3>>0]=108;y=y+9|0;f[s+220>>2]=y;Krd(y|0,q|0,m|0)|0;y=y+m|0;b[y>>0]=45;b[y+1>>0]=119;b[y+2>>0]=97;b[y+3>>0]=108;y=23}if((y|0)==23)nxc(0,q);f[s>>2]=a;f[s+144>>2]=i;do if(o?(b[e>>0]|0)!=0:0){f[w>>2]=0;k=uKc(a,f[p>>2]|0,f[u>>2]|0,i,w)|0;m=f[w>>2]&1;if(k|0)break;k=tKc(f[u>>2]|0)|0;do if((m|0)==0?(NLc(s),x=f[s+148>>2]|0,(f[z>>2]|0)>>>0<x>>>0):0)if(x>>>0>8192){f[z>>2]=8192;break}else{f[z>>2]=x;break}while(0);y=(vBc(f[p>>2]|0,127487,0)|0)&255;b[s+13>>0]=y;if((k&8192|0)==0?(vBc(f[p>>2]|0,127494,0)|0)==0:0){e=0;y=38;break}k=i|1;y=36}else{k=i;y=36}while(0);if((y|0)==36){b[s+16>>0]=1;b[s+17>>0]=4;b[s+13>>0]=1;m=k&1;e=1;y=38}if((y|0)==38){k=KLc(s,z,-1)|0;l=g+7&-8;if(!k){h=(v|0)==0;k=PWc(f[z>>2]|0,l,v^1,h?691:0,s,f[r>>2]|0)|0;if(!k){b[s+6>>0]=B^1;f[s+156>>2]=1073741823;b[s+12>>0]=e;b[s+4>>0]=e;b[s+18>>0]=e;b[s+15>>0]=v;b[s+14>>0]=m;b[s+7>>0]=e;if(!(e<<24>>24)){b[s+8>>0]=1;b[s+9>>0]=0;b[s+10>>0]=2;b[s+11>>0]=10}d[s+140>>1]=l;z=s+160|0;f[z>>2]=-1;f[z+4>>2]=-1;NLc(s);if(A|h^1)b[s+5>>0]=((B&255)<<1&255^2)+2<<24>>24;f[s+200>>2]=j;VKc(s);f[c>>2]=s;B=0;t=C;return B|0}}}DKc(f[u>>2]|0);TLc(f[s+208>>2]|0);qxc(s);B=k;t=C;return B|0}function IWc(a,b,c){a=a|0;b=b|0;c=c|0;a=a+128|0;f[a>>2]=b;f[a+4>>2]=c;return}function JWc(a,c){a=a|0;c=c|0;var d=0,e=0;d=c;e=d+100|0;do{b[d>>0]=0;d=d+1|0}while((d|0)<(e|0));a=f[a+60>>2]|0;if(!(f[a>>2]|0)){c=0;return c|0}c=QLc(a,c,100,0,0)|0;c=(c|0)==522?0:c;return c|0}function KWc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+176|0;f[d>>2]=b;f[a+180>>2]=c;tNc(f[a+60>>2]|0,15,d);return}function LWc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=f[a+4>>2]|0;Fzc(a);e=d+52|0;if(!((b|0)!=0&(f[e>>2]|0)==0)){Bzc(a);e=f[e>>2]|0;return e|0}b=$Ec(0,b,((b|0)<0)<<31>>31)|0;f[e>>2]=b;f[d+56>>2]=c;Bzc(a);e=f[e>>2]|0;return e|0}function MWc(a){a=a|0;return f[a+60>>2]|0}function NWc(a){a=a|0;a=f[a+4>>2]|0;return ((a|0)>64?a:64)|0}function OWc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;if(f[a+40>>2]|0){h=0;return h|0}g=b[a+20>>0]|0;if(g<<24>>24){if(g&3){h=0;return h|0}if(d[c+28>>1]&8){h=0;return h|0}}g=a+196|0;f[g>>2]=(f[g>>2]|0)+1;f[c+16>>2]=0;do if(f[a+216>>2]|0){e=$Jc(c)|0;if(!e){e=nNc(a,c,0,0)|0;h=12}}else{if(!((d[c+28>>1]&8)==0?(b[a+16>>0]|0)!=3:0))h=10;if((h|0)==10?(e=qNc(a,1)|0,e|0):0)break;e=rNc(a,c)|0;h=12}while(0);if((h|0)==12)if(!e){mLc(c);e=0}h=FLc(a,e)|0;return h|0}function PWc(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0;i=h;j=i+48|0;do{f[i>>2]=0;i=i+4|0}while((i|0)<(j|0));f[h+24>>2]=1;f[h+28>>2]=c;b[h+32>>0]=d;b[h+33>>0]=2;f[h+36>>2]=e;f[h+40>>2]=g;f[h+16>>2]=100;f[h+20>>2]=1;return SLc(h,a)|0}function QWc(a,b){a=a|0;b=b|0;var c=0;c=t;t=t+16|0;if(!(f[b+4>>2]&2048)){TIc(a,122503,c);t=c;return}else{PVc(a,f[f[(f[b+20>>2]|0)+28>>2]>>2]|0,1);t=c;return}}function RWc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;if(!(qSc(a,c,d,e)|0)){e=1;return e|0}g=b[d>>0]|0;do if(g<<24>>24==43){if(RWc(a,c,f[d+12>>2]|0,e)|0){e=1;return e|0}if(!(RWc(a,c,f[d+16>>2]|0,e)|0)){g=b[d>>0]|0;break}else{e=1;return e|0}}while(0);if(g<<24>>24==51?UWc(a,c,f[d+12>>2]|0,e,0)|0:0){e=1;return e|0}e=0;return e|0}function SWc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;h=t;t=t+32|0;g=h;a=kSc(a)|0;if(!a){g=0;t=h;return g|0}e=b[a>>0]|0;a:do if(e<<24>>24==51)a=f[a+12>>2]|0;else{while(1){if(e<<24>>24!=44)break a;if(SWc(f[a+12>>2]|0,c)|0){a=1;break}e=f[a+16>>2]|0;a=e;e=b[e>>0]|0}t=h;return a|0}while(0);f[g+4>>2]=692;f[g+8>>2]=0;f[g+12>>2]=0;e=g+20|0;d[e>>1]=0;f[g+24>>2]=c;HRc(g,a)|0;g=j[e>>1]|0;t=h;return g|0}function TWc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;if(f[c+4>>2]&1|0){h=1;return h|0}switch(b[c>>0]|0){case -90:{if((f[a+24>>2]|0)!=(f[c+28>>2]|0)){h=1;return h|0}d[a+20>>1]=1;h=2;return h|0}case 44:{e=a+20|0;if(d[e>>1]|0){h=1;return h|0}HRc(a,f[c+12>>2]|0)|0;if(!(d[e>>1]|0)){h=1;return h|0}d[e>>1]=0;HRc(a,f[c+16>>2]|0)|0;h=1;return h|0}case 48:{h=(HRc(a,f[c+12>>2]|0)|0)==2;h=h?2:1;return h|0}case 57:case 54:case 55:case 56:case 52:case 53:{a=f[c+12>>2]|0;e=f[c+16>>2]|0;if(((b[a>>0]|0)==-90?(g=f[a+44>>2]|0,g|0):0)?f[g+56>>2]|0:0){h=1;return h|0}if(((b[e>>0]|0)==-90?(h=f[e+44>>2]|0,h|0):0)?f[h+56>>2]|0:0){h=1;return h|0}break}case -82:case -85:case 49:case -100:case -80:case 43:case 45:case 51:case 50:case -86:{h=1;return h|0}default:{}}h=0;return h|0}function UWc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;a:while(1){if(!(qSc(a,c,d,e)|0)){h=3;break}switch(b[c>>0]|0){case 49:{if((g|0)!=0?(f[c+4>>2]&2048|0)!=0:0){g=0;h=16;break a}else g=1;break}case 48:{if(g|0){g=0;h=16;break a}g=f[c+20>>2]|0;if(UWc(a,f[g+4>>2]|0,d,e,1)|0){g=1;h=16;break a}if(!(UWc(a,f[g+20>>2]|0,d,e,1)|0))g=1;else{g=1;h=16;break a}break}case 111:case 105:case 104:case 103:case 107:case 106:case 57:case 54:case 55:case 56:case 52:case 53:{g=1;h=12;break}case 109:case 102:case 110:case 108:{h=12;break}case -84:case -83:case 112:case -76:break;case -82:{if(g|0){g=0;h=16;break a}if((b[c+2>>0]|0)==45)g=1;else{g=0;h=16;break a}break}case 19:case 113:{g=1;break}default:{g=0;h=16;break a}}if((h|0)==12){h=0;if(UWc(a,f[c+16>>2]|0,d,e,g)|0){g=1;h=16;break}}c=f[c+12>>2]|0}if((h|0)==3){h=(b[d>>0]|0)!=120&1;return h|0}else if((h|0)==16)return g|0;return 0}function VWc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0;g=t;t=t+32|0;h=g;e=h+20|0;d[e>>1]=b;f[h+4>>2]=693;f[h+8>>2]=694;f[h+24>>2]=c;HRc(h,a)|0;t=g;return j[e>>1]|0|0}function WWc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0;i=a+20|0;h=d[i>>1]|0;if(h<<16>>16==2?f[c+4>>2]&1|0:0){d[i>>1]=0;i=2;return i|0}a:do switch(b[c>>0]|0){case -85:{e=c+4|0;a=f[e>>2]|0;if(!(((a&524288|0)!=0|(h&65535)>3)&(a&16777216|0)==0)){d[i>>1]=0;i=2;return i|0}if(h<<16>>16!=5){i=0;return i|0}f[e>>2]=a|1073741824;i=0;return i|0}case 59:if(!(dQc(c)|0)){e=d[i>>1]|0;g=11;break a}else{i=1;return i|0}case -88:case -89:case -90:{e=h;g=11;break}case -116:case -81:case -78:break;case -101:switch(h<<16>>16){case 5:{b[c>>0]=120;i=0;return i|0}case 4:{d[i>>1]=0;i=2;return i|0}default:{i=0;return i|0}}default:{i=0;return i|0}}while(0);do if((g|0)==11){if(f[c+4>>2]&8|0){if(e<<16>>16==2)break;else e=0;return e|0}if(e<<16>>16==3?(f[c+28>>2]|0)==(f[a+24>>2]|0):0){i=0;return i|0}}while(0);d[i>>1]=0;i=2;return i|0}function XWc(a,b){a=a|0;b=b|0;d[a+20>>1]=0;return 2}function YWc(a,b,c){a=a|0;b=b|0;c=c|0;return ((nWc(a,$Rc(b)|0)|0)&255|c)&255|0}function ZWc(a,c){a=a|0;c=c|0;if((b[c>>0]|0)!=-119){c=0;return c|0}c=OVc(a,c)|0;return c|0}function _Wc(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0;i=b[c>>0]|0;if(i<<24>>24==-81){i=iWc(c,d)|0;f[g>>2]=i;i=(f[c+28>>2]|0)+d|0;return i|0}c=c+20|0;if(i<<24>>24==-119){f[g>>2]=f[(f[(f[c>>2]|0)+28>>2]|0)+4+(d<<4)>>2];i=e+d|0;return i|0}else{i=f[(f[c>>2]|0)+4+(d<<4)>>2]|0;f[g>>2]=i;i=EVc(a,i,h)|0;return i|0}return 0}function $Wc(a,c,d,e,f){a=a|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0;g=uxc(sVc(a)|0,8,0)|0;if(!g){XUc(a,c,0,d,0,g,f)|0;return}i=e;k=i;k=h[k>>0]|h[k+1>>0]<<8|h[k+2>>0]<<16|h[k+3>>0]<<24;i=i+4|0;i=h[i>>0]|h[i+1>>0]<<8|h[i+2>>0]<<16|h[i+3>>0]<<24;e=g;j=e;b[j>>0]=k;b[j+1>>0]=k>>8;b[j+2>>0]=k>>16;b[j+3>>0]=k>>24;e=e+4|0;b[e>>0]=i;b[e+1>>0]=i>>8;b[e+2>>0]=i>>16;b[e+3>>0]=i>>24;XUc(a,c,0,d,0,g,f)|0;return}function aXc(a){a=a|0;var b=0;while(1){if(!a){a=0;b=5;break}if(!(f[a+4>>2]&4096)){b=5;break}a=f[a+12>>2]|0}if((b|0)==5)return a|0;return 0}function bXc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;if((b[a>>0]|0)!=48){i=Mxc(a)|0;c=vyc(a,c,i,1)|0;return c|0}switch(b[a+1>>0]|0){case 88:case 120:break;default:{i=Mxc(a)|0;c=vyc(a,c,i,1)|0;return c|0}}i=2;while(1){d=b[a+i>>0]|0;if(d<<24>>24==48)i=i+1|0;else break}h=i;e=0;g=0;while(1){if(!(b[1424+(d&255)>>0]&8))break;k=Hrd(e|0,g|0,4)|0;j=G;j=vrd(k|0,j|0,(SBc(d<<24>>24)|0)&255|0,0)|0;k=h+1|0;h=k;d=b[a+k>>0]|0;e=j;g=G}k=c;f[k>>2]=e;f[k+4>>2]=g;return ((b[a+h>>0]|0)==0?((h-i|0)>16?2:0):2)|0}function cXc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=t;t=t+16|0;g=e;f[g>>2]=d;f[g+4>>2]=b;f[g+8>>2]=c;NUc(a,128006,g);t=e;return}function dXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;if(!(f[c+56>>2]|0)){c=0;return c|0}g=f[c>>2]|0;e=Mxc(g)|0;if(QBc(d,g,e)|0){g=0;return g|0}e=d+e|0;if((b[e>>0]|0)!=95){g=0;return g|0}d=HIc(a+360|0,f[f[c+60>>2]>>2]|0)|0;if(!d){g=0;return g|0}d=f[d>>2]|0;if((f[d>>2]|0)<3){g=0;return g|0}d=f[d+92>>2]|0;if(!d){g=0;return g|0}g=sd[d&2047](e+1|0)|0;return g|0}function eXc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;j=t;t=t+16|0;h=j+8|0;i=j;g=f[a>>2]|0;if(uPc(g)|0){i=0;t=j;return i|0}if(!((b[g+170>>0]&2)==0&(b[40721]|0)!=0)){i=0;t=j;return i|0}if(b[g+169>>0]|0){g=f[g+172>>2]|0;if(((zHc(d,f[g>>2]|0)|0)==0?(zHc(c,f[g+4>>2]|0)|0)==0:0)?(zHc(e,f[g+8>>2]|0)|0)==0:0){i=0;t=j;return i|0}TIc(a,155644,i);i=1;t=j;return i|0}if(!((b[a+18>>0]|0)==0?!(QBc(c,125037,7)|0):0)){if(!(gVc(g)|0)){i=0;t=j;return i|0}if(!(fXc(g,c)|0)){i=0;t=j;return i|0}}f[h>>2]=c;TIc(a,128957,h);i=1;t=j;return i|0}function fXc(a,c){a=a|0;c=c|0;var d=0,e=0;d=ued(c,95)|0;if(!d){e=0;return e|0}b[d>>0]=0;e=$Tc(a,c,0)|0;b[d>>0]=95;if(!e){e=0;return e|0}if(!(f[e+56>>2]|0)){e=0;return e|0}e=dXc(a,e,c)|0;return e|0}function gXc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;c=f[(f[(f[a>>2]|0)+16>>2]|0)+(b<<4)+12>>2]|0;kXc(a,0,b);e=a+40|0;g=f[e>>2]|0;f[e>>2]=g+3;lXc(a,b,g,0,0);d=(f[a+44>>2]|0)+1|0;e=f[e>>2]|0;c=c+16|0;while(1){c=f[c>>2]|0;if(!c)break;mXc(a,f[c+8>>2]|0,0,g,d,e)}nXc(a,b);return}function hXc(a,b){a=a|0;b=b|0;var c=0;c=DQc(a,b)|0;b=sIc(a,c)|0;nxc(a,c);return b|0}function iXc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0;j=t;t=t+16|0;i=j+8|0;g=f[a>>2]|0;if(!(f[d+4>>2]|0)){i=h[g+168>>0]|0;f[e>>2]=c;t=j;return i|0}if(b[g+169>>0]|0){TIc(a,129145,j);i=-1;t=j;return i|0}f[e>>2]=d;d=hXc(g,c)|0;if((d|0)>=0){i=d;t=j;return i|0}f[i>>2]=c;TIc(a,129162,i);i=-1;t=j;return i|0}function jXc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=zTc(f[a>>2]|0,f[b+72>>2]|0)|0;kXc(a,0,d);e=a+40|0;g=f[e>>2]|0;f[e>>2]=g+3;if(!c)lXc(a,d,g,f[b>>2]|0,123962);else lXc(a,d,g,f[c>>2]|0,123966);mXc(a,b,c,g,(f[a+44>>2]|0)+1|0,f[e>>2]|0);nXc(a,d);return}function kXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=f[a+116>>2]|0;a=(e|0)==0?a:e;AWc(a,d);e=a+80|0;f[e>>2]=f[e>>2]|1<<d;d=a+20|0;b[d>>0]=h[d>>0]|0|c;return}function lXc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0;w=t;t=t+48|0;v=w+16|0;u=w;p=w+32|0;q=w+44|0;r=f[a>>2]|0;s=OUc(a)|0;if(!s){t=w;return}l=(f[r+16>>2]|0)+(c<<4)|0;m=(e|0)==0;n=a+92|0;k=0;while(1){if((k|0)==3)break;o=f[14624+(k<<3)>>2]|0;i=q+k|0;b[i>>0]=0;j=$Tc(r,o,f[l>>2]|0)|0;do if(!j){if(!k){f[u>>2]=f[l>>2];f[u+4>>2]=o;f[u+8>>2]=129076;NUc(a,129053,u);f[p>>2]=f[n>>2];b[i>>0]=16}}else{i=f[j+28>>2]|0;f[p+(k<<2)>>2]=i;lWc(a,c,i,1,o);if(m){TUc(s,140,i,c)|0;break}else{f[v>>2]=f[l>>2];f[v+4>>2]=o;f[v+8>>2]=g;f[v+12>>2]=e;NUc(a,129089,v);break}}while(0);k=k+1|0}v=h[q>>0]|0;lVc(s,98,d,f[p>>2]|0,c,3)|0;_Uc(s,v);t=w;return}function mXc(a,c,e,g,i,k){a=a|0;c=c|0;e=e|0;g=g|0;i=i|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;I=f[a>>2]|0;J=i+1|0;K=i+2|0;L=i+3|0;z=i+4|0;A=i+5|0;B=i+6|0;C=i+7|0;D=i+8|0;E=i+9|0;F=a+44|0;G=f[F>>2]|0;f[F>>2]=(G|0)>(E|0)?G:E;G=OUc(a)|0;if((c|0)==0|(G|0)==0)return;l=c+28|0;if(!(f[l>>2]|0))return;if(!(MHc(128999,f[c>>2]|0,92)|0))return;H=zTc(I,f[c+72>>2]|0)|0;if(iTc(a,28,f[c>>2]|0,0,f[(f[I+16>>2]|0)+(H<<4)>>2]|0)|0)return;lWc(a,H,f[l>>2]|0,0,f[c>>2]|0);v=k+1|0;x=k+2|0;w=a+40|0;y=f[w>>2]|0;f[w>>2]=(y|0)>(x|0)?y:x;hVc(a,k,H,c,97);SUc(G,B,f[c>>2]|0)|0;w=(e|0)==0;x=c+36|0;y=I+468|0;l=c+8|0;m=1;while(1){u=f[l>>2]|0;if(!u)break;do if(w|(u|0)==(e|0)){m=(f[u+36>>2]|0)==0?0:m;l=u+55|0;l=h[l>>0]|h[l+1>>0]<<8;if(!((f[x>>2]&128|0)!=0&(l&3)==2)){o=j[u+52>>1]|0;n=f[u>>2]|0;p=u+50|0;if(!(l&8)){q=o;l=o}else{q=j[p>>1]|0;l=o}}else{p=u+50|0;l=j[p>>1]|0;q=l;n=f[c>>2]|0}t=q+-1|0;SUc(G,C,n)|0;r=f[F>>2]|0;s=t+E|0;f[F>>2]=(r|0)>(s|0)?r:s;UUc(G,97,v,f[u+44>>2]|0,H)|0;oWc(a,u);TUc(G,69,l,K)|0;TUc(G,69,j[p>>1]|0,L)|0;s=iVc(G,37,v)|0;UUc(G,93,v,z,1)|0;TUc(G,69,f[y>>2]|0,A)|0;MVc(a,0,K,J,4,77812,0);TUc(G,69,0,K)|0;l=vWc(G)|0;if(q>>>0>1){q=QVc(a)|0;r=uxc(I,t<<2,0)|0;if(!r)break;QUc(G,11)|0;l=vWc(G)|0;if(((t|0)==1?(d[p>>1]|0)==1:0)?b[u+54>>0]|0:0)TUc(G,51,E,q)|0;o=u+32|0;n=0;while(1){if((n|0)>=(t|0))break;p=zWc(a,f[(f[o>>2]|0)+(n<<2)>>2]|0)|0;TUc(G,69,n,K)|0;UUc(G,90,v,n,z)|0;p=XUc(G,52,z,0,n+E|0,p,-2)|0;f[r+(n<<2)>>2]=p;_Uc(G,128);n=n+1|0}TUc(G,69,t,K)|0;YVc(G,q)|0;mVc(G,l+-1|0);n=0;while(1){if((n|0)>=(t|0))break;mVc(G,f[r+(n<<2)>>2]|0);UUc(G,90,v,n,n+E|0)|0;n=n+1|0}SVc(G,q);nxc(I,r)}MVc(a,1,J,z,2,77852,0);if(!(f[y>>2]|0))TUc(G,5,v,l)|0;else{q=iVc(G,50,z)|0;r=iVc(G,18,z)|0;t=lVc(G,25,v,0,E,1)|0;mVc(G,q);TUc(G,5,v,l)|0;mVc(G,r);mVc(G,t)}oXc(a,J,D);XUc(G,92,B,3,z,129009,0)|0;TUc(G,122,g,i)|0;UUc(G,123,g,z,i)|0;_Uc(G,8);mVc(G,s)}while(0);l=u+20|0}if(m<<24>>24==0|w^1)return;TUc(G,93,k,D)|0;L=iVc(G,20,D)|0;TUc(G,72,0,C)|0;XUc(G,92,B,3,z,129009,0)|0;TUc(G,122,g,i)|0;UUc(G,123,g,z,i)|0;_Uc(G,8);mVc(G,L);return}function nXc(a,b){a=a|0;b=b|0;a=OUc(a)|0;if(!a)return;iVc(a,145,b)|0;return}function oXc(a,b,c){a=a|0;b=b|0;c=c|0;MVc(a,0,b,c,1,77892,0);return}function pXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=t;t=t+16|0;j=k+8|0;e=k;c=gEc(f[d>>2]|0)|0;i=c+20|0;g=((f[i>>2]|0)*25|0)+25|0;g=DCc(g,((g|0)<0)<<31>>31)|0;if(!g){ZDc(a);t=k;return}h=c+8|0;d=e;f[d>>2]=f[((b[c+24>>0]|0)==0?h:c+4|0)>>2];f[d+4>>2]=0;OAc(24,g,129022,e)|0;e=c+32|0;c=g+(Mxc(g)|0)|0;d=0;while(1){if((d|0)>=(f[i>>2]|0))break;m=(f[(f[e>>2]|0)+(d<<2)>>2]|0)+1|0;l=f[h>>2]|0;n=vrd(m|0,0,-1,-1)|0;l=vrd(n|0,G|0,l|0,0)|0;m=Drd(l|0,G|0,m|0,0)|0;l=j;f[l>>2]=m;f[l+4>>2]=G;OAc(24,c,129027,j)|0;c=c+(Mxc(c)|0)|0;d=d+1|0}$Dc(a,g,-1,696);t=k;return}function qXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=gEc(f[d>>2]|0)|0;g=fEc(f[d+4>>2]|0)|0;i=j+8|0;a:do if(!(f[i>>2]|0)){d=j+16|0;e=j+28|0;c=0;while(1){if((c|0)>=(f[d>>2]|0))break a;f[(f[e>>2]|0)+(c<<2)>>2]=1;c=c+1|0}}else{h=j+28|0;c=0;while(1){if((c|0)>=(g|0))break;e=(f[h>>2]|0)+(c<<2)|0;f[e>>2]=(f[e>>2]|0)+1;c=c+1|0}d=j+16|0;e=j+32|0;c=g;while(1){if((c|0)>=(f[d>>2]|0))break a;g=(f[e>>2]|0)+(c<<2)|0;f[g>>2]=(f[g>>2]|0)+1;f[(f[h>>2]|0)+(c<<2)>>2]=1;c=c+1|0}}while(0);g=(f[i>>2]|0)+1|0;f[i>>2]=g;c=f[j+12>>2]|0;if(!c)return;d=j+24|0;e=b[d>>0]|0;if(g>>>0<=(V((e&255)+1|0,c)|0)>>>0)return;b[d>>0]=e+1<<24>>24;DDc(a,(f[f[j+32>>2]>>2]|0)!=0&1);return}function rXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;g=fEc(f[d>>2]|0)|0;h=g+1&-2;i=fEc(f[d+4>>2]|0)|0;e=(h<<3)+36|0;c=LDc(a)|0;e=$Ec(c,e,((e|0)<0)<<31>>31)|0;if(!e){ZDc(a);return}else{f[e>>2]=c;c=ryc(f[d+8>>2]|0)|0;f[e+4>>2]=c;f[e+8>>2]=0;d=ryc(f[d+12>>2]|0)|0;f[e+12>>2]=d;f[e+16>>2]=g;f[e+20>>2]=i;b[e+24>>0]=0;d=e+36|0;f[e+32>>2]=d;f[e+28>>2]=d+(h<<2);DEc(a,e,36,811);return}}function sXc(a){a=a|0;nxc(f[a>>2]|0,a);return}function tXc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;d=f[a>>2]|0;g=d+20|0;d=f[d+16>>2]|0;e=0;while(1){if((e|0)>=(f[g>>2]|0))break;c=(f[d+12>>2]|0)+16|0;while(1){c=f[c>>2]|0;if(!c)break;uXc(a,f[c+8>>2]|0,b)}d=d+16|0;e=e+1|0}return}function uXc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if(f[b+56>>2]|0)return;d=(c|0)==0;e=b+72|0;b=b+8|0;while(1){b=f[b>>2]|0;if(!b)break;if(!(!d?!(EXc(c,b)|0):0)){kXc(a,0,zTc(f[a>>2]|0,f[e>>2]|0)|0);vXc(a,b,-1)}b=b+20|0}return}function vXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=t;t=t+16|0;m=s;g=f[c+12>>2]|0;e=a+40|0;q=f[e>>2]|0;r=q+1|0;f[e>>2]=q+2;p=f[a>>2]|0;k=zTc(p,f[c+24>>2]|0)|0;if(iTc(a,27,f[c>>2]|0,0,f[(f[p+16>>2]|0)+(k<<4)>>2]|0)|0){t=s;return}lWc(a,k,f[g+28>>2]|0,1,f[g>>2]|0);o=OUc(a)|0;if(!o){t=s;return}if((d|0)>-1)i=d;else i=f[c+44>>2]|0;l=yWc(a,c)|0;p=f[e>>2]|0;f[e>>2]=p+1;e=c+50|0;n=j[e>>1]|0;wXc(l)|0;XUc(o,112,p,0,n,l,-9)|0;hVc(a,q,k,g,97);g=TUc(o,37,q,0)|0;n=hWc(a)|0;xXc(a);yXc(a,c,q,n,0,m,0,0)|0;TUc(o,134,p,n)|0;zXc(a,f[m>>2]|0);TUc(o,5,q,g+1|0)|0;mVc(o,g);if((d|0)<0)TUc(o,140,i,k)|0;XUc(o,98,r,i,k,l,-9)|0;_Uc(o,((d>>31)+16&65520|1)&65535);g=TUc(o,35,p,0)|0;if(!(b[c+54>>0]|0)){MUc(a);e=vWc(o)|0}else{l=YVc(o,1)|0;m=vWc(o)|0;lVc(o,127,p,l,n,j[e>>1]|0)|0;AXc(a,2,c);mVc(o,l);e=m}UUc(o,128,p,n,r)|0;c=c+55|0;if(!((h[c>>0]|h[c+1>>0]<<8)&512))iVc(o,132,r)|0;TUc(o,133,r,n)|0;_Uc(o,16);$Vc(a,n);TUc(o,3,p,e)|0;mVc(o,g);iVc(o,117,q)|0;iVc(o,117,r)|0;iVc(o,117,p)|0;t=s;return}function wXc(a){a=a|0;if(!a)return a|0;f[a>>2]=(f[a>>2]|0)+1;return a|0}function xXc(a){a=a|0;var c=0;c=f[a+116>>2]|0;b[((c|0)==0?a:c)+20>>0]=1;return}function yXc(a,b,c,e,g,i,k,l){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;i=i|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;p=f[a+8>>2]|0;if(i){m=b+36|0;if(f[m>>2]|0){o=QVc(a)|0;f[i>>2]=o;o=a+52|0;f[o>>2]=c+1;BXc(a,f[m>>2]|0,f[i>>2]|0);k=0;i=o}f[i>>2]=0}if((g|0)!=0?(o=b+55|0,((h[o>>0]|h[o+1>>0]<<8)&8)!=0):0)i=b+50|0;else i=b+52|0;n=j[i>>1]|0;o=JVc(a,n)|0;do if(!k)i=0;else{if((o|0)==(l|0)?(f[k+36>>2]|0)==0:0){i=k;break}i=0}while(0);g=(i|0)==0;k=i+4|0;m=b+4|0;i=0;while(1){if((i|0)==(n|0))break;if(!(!g?(l=d[(f[k>>2]|0)+(i<<1)>>1]|0,!(l<<16>>16==-2?1:l<<16>>16!=(d[(f[m>>2]|0)+(i<<1)>>1]|0))):0)){CXc(a,b,c,i,i+o|0);DXc(p)}i=i+1|0}if(!e){NVc(a,o,n);return o|0}UUc(p,92,o,n,e)|0;NVc(a,o,n);return o|0}function zXc(a,b){a=a|0;b=b|0;if(!b)return;SVc(f[a+8>>2]|0,b);return}function AXc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+32|0;e=o;m=o+8|0;n=f[c+12>>2]|0;l=f[a>>2]|0;fxc(m,l,0,0,f[l+112>>2]|0);a:do if(!(f[c+40>>2]|0)){g=c+50|0;i=n+4|0;k=c+4|0;e=0;while(1){if(e>>>0>=(j[g>>1]|0)>>>0)break a;l=f[(f[i>>2]|0)+((d[(f[k>>2]|0)+(e<<1)>>1]|0)*20|0)>>2]|0;if(e|0)Dxc(m,129239,2);Lxc(m,f[n>>2]|0);Dxc(m,140851,1);Lxc(m,l);e=e+1|0}}else{f[e>>2]=f[c>>2];cyc(m,129228,e)}while(0);n=hxc(m)|0;m=c+55|0;_Vc(a,((h[m>>0]|h[m+1>>0]<<8)&3)==2?1555:2067,b,n,-7,2);t=o;return}function BXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=f[a>>2]|0;c=oSc(e,c,0)|0;if(b[e+83>>0]|0){dzc(e,c);return}XVc(a,c,d,16);dzc(e,c);return}function CXc(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0;h=d[(f[b+4>>2]|0)+(e<<1)>>1]|0;if(h<<16>>16==-2){h=a+52|0;f[h>>2]=c+1;uVc(a,f[(f[b+40>>2]|0)+4+(e<<4)>>2]|0,g);f[h>>2]=0;return}else{kVc(f[a+8>>2]|0,f[b+12>>2]|0,c,h<<16>>16,g);return}}function DXc(a){a=a|0;var c=0;c=f[a+108>>2]|0;if((c|0)<=0)return;c=c+-1|0;if((b[(f[a+104>>2]|0)+(c*20|0)>>0]|0)!=84)return;uWc(a,c)|0;return}function EXc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;e=b+32|0;g=j[b+52>>1]|0;c=b+4|0;b=0;while(1){if(b>>>0>=g>>>0){b=0;c=6;break}if((d[(f[c>>2]|0)+(b<<1)>>1]|0)>-1?(wzc(f[(f[e>>2]|0)+(b<<2)>>2]|0,a)|0)==0:0){b=1;c=6;break}b=b+1|0}if((c|0)==6)return b|0;return 0}function FXc(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0;l=t;t=t+32|0;j=l;k=f[a>>2]|0;do if((((f[a+36>>2]|0)==0?(m=j+4|0,f[m>>2]=0,f[m+4>>2]=0,f[m+8>>2]=0,f[m+12>>2]=0,f[m+16>>2]=0,f[m+20>>2]=0,f[m+24>>2]=0,f[j>>2]=a,(GXc(j,g)|0)==0):0)?(GXc(j,h)|0)==0:0)?(GXc(j,i)|0)==0:0){if(e|0){if((b[e>>0]|0)==116)e=f[e+8>>2]|0;else e=0;if(iTc(a,c,e,0,0)|0)break}e=OUc(a)|0;j=JVc(a,4)|0;vVc(a,g,j);vVc(a,h,j+1|0);vVc(a,i,j+2|0);if(e|0){j=j+3|0;m=b[d>>0]|0;MVc(a,0,j-m|0,j,m,d,0);iVc(e,161,(c|0)==24&1)|0}}while(0);dzc(k,g);dzc(k,h);dzc(k,i);t=l;return}function GXc(a,c){a=a|0;c=c|0;do if(c)if((b[c>>0]|0)==59){b[c>>0]=116;a=0;break}else{a=fSc(a,c)|0;break}else a=0;while(0);return a|0}function HXc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+160|0;k=o+144|0;j=o+136|0;i=o+128|0;h=o;e=Txc(f[c>>2]|0)|0;n=LDc(a)|0;e=(e|0)==0?155644:e;c=f[n+20>>2]|0;b=n+16|0;d=0;while(1){if((d|0)>=(c|0)){b=6;break}g=f[b>>2]|0;l=g+(d<<4)+4|0;m=f[l>>2]|0;if(m|0?CUc(n,d,e)|0:0){b=7;break}d=d+1|0}do if((b|0)==6){f[i>>2]=e;OAc(128,h,129256,i)|0}else if((b|0)==7){if(d>>>0<2){f[j>>2]=e;OAc(128,h,129277,j)|0;break}if((tIc(m)|0)==0?(IXc(m)|0)==0:0){e=g+(d<<4)+12|0;b=(f[g+28>>2]|0)+48|0;while(1){b=f[b>>2]|0;if(!b)break;c=f[b+8>>2]|0;d=c+24|0;if((f[d>>2]|0)==(f[e>>2]|0))f[d>>2]=f[c+20>>2]}FOc(m);f[l>>2]=0;f[e>>2]=0;vOc(n);t=o;return}f[k>>2]=e;OAc(128,h,129303,k)|0}while(0);ODc(a,h,-1);t=o;return}function IXc(a){a=a|0;return (f[a+16>>2]|0)!=0|0}function JXc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=t;t=t+64|0;w=A+40|0;v=A+32|0;q=A+24|0;p=A+16|0;g=A+8|0;e=A;k=A+60|0;l=A+56|0;m=A+52|0;x=A+48|0;o=A+44|0;y=LDc(a)|0;f[k>>2]=0;f[l>>2]=0;f[x>>2]=0;u=Txc(f[d>>2]|0)|0;n=Txc(f[d+4>>2]|0)|0;u=(u|0)==0?155644:u;n=(n|0)==0?155644:n;s=y+20|0;d=f[s>>2]|0;c=f[y+140>>2]|0;a:do if((d|0)<(c+2|0)){c=0;while(1){if((c|0)>=(d|0))break;if(!(CUc(y,c,n)|0))c=c+1|0;else{z=6;break}}if((z|0)==6){f[g>>2]=n;d=YMc(y,129376,g)|0;f[x>>2]=d;c=0;z=32;break}r=y+16|0;c=f[r>>2]|0;do if((c|0)==(y+432|0)){c=uxc(y,48,0)|0;if(!c){t=A;return}else{j=f[r>>2]|0;f[c>>2]=f[j>>2];f[c+4>>2]=f[j+4>>2];f[c+8>>2]=f[j+8>>2];f[c+12>>2]=f[j+12>>2];f[c+16>>2]=f[j+16>>2];f[c+20>>2]=f[j+20>>2];f[c+24>>2]=f[j+24>>2];f[c+28>>2]=f[j+28>>2];j=c;c=r;break}}else{c=Oxc(y,c,(d<<4)+16|0,0)|0;if(!c){t=A;return}else{j=c;c=r;break}}while(0);f[c>>2]=j;i=f[s>>2]|0;g=j+(i<<4)|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;f[m>>2]=f[y+60>>2];switch(KXc(f[(f[y>>2]|0)+16>>2]|0,u,m,o,k,l)|0){case 0:{c=f[m>>2]|256;f[m>>2]=c;e=f[k>>2]|0;d=j+(i<<4)+4|0;c=CWc(f[o>>2]|0,e,y,d,0,c)|0;f[s>>2]=(f[s>>2]|0)+1;o=UIc(y,n)|0;f[g>>2]=o;b[y+91>>0]=0;switch(c|0){case 19:{c=YMc(y,129406,p)|0;f[x>>2]=c;c=1;z=21;break}case 0:{c=LXc(y,f[d>>2]|0)|0;f[j+(i<<4)+12>>2]=c;if(c)if((b[c+76>>0]|0)!=0?(b[c+77>>0]|0)!=(b[y+80>>0]|0):0){c=YMc(y,125183,q)|0;f[x>>2]=c;c=1}else c=0;else c=7;Fzc(f[d>>2]|0);MXc(Cyc(f[d>>2]|0)|0,h[y+85>>0]|0)|0;NXc(f[d>>2]|0,NXc(f[(f[r>>2]|0)+4>>2]|0,-1)|0)|0;OXc(f[d>>2]|0,f[y+32>>2]&56|3);Bzc(f[d>>2]|0);b[j+(i<<4)+8>>0]=3;if(!c)if(f[g>>2]|0){pIc(e);Byc(y);b[y+168>>0]=0;c=y+24|0;f[c>>2]=f[c>>2]&-17;c=pUc(y,x)|0;Fyc(y);if(!c){t=A;return}}else{c=7;z=24}else z=24;break}default:z=21}if((z|0)==21){b[j+(i<<4)+8>>0]=3;z=24}if((z|0)==24)pIc(e);d=(f[s>>2]|0)+-1|0;e=f[(f[r>>2]|0)+(d<<4)+4>>2]|0;if(e|0){FOc(e);r=f[r>>2]|0;f[r+(d<<4)+4>>2]=0;f[r+(d<<4)+12>>2]=0}uOc(y);f[s>>2]=d;if((c|0)<3082)switch(c|0){case 7:{z=29;break}default:{}}else switch(c|0){case 3082:{z=29;break}default:{}}if((z|0)==29){Cxc(y);nxc(y,f[x>>2]|0);d=YMc(y,120038,v)|0;f[x>>2]=d;z=32;break a}d=f[x>>2]|0;if(d|0){z=33;break a}f[w>>2]=u;d=YMc(y,129435,w)|0;f[x>>2]=d;z=32;break a}case 7:{Cxc(y);break}default:{}}z=f[l>>2]|0;ODc(a,z,-1);qxc(z);t=A;return}else{f[e>>2]=c;d=YMc(y,129339,e)|0;f[x>>2]=d;c=0;z=32}while(0);if((z|0)==32)if(d)z=33;if((z|0)==33){ODc(a,d,-1);nxc(y,f[x>>2]|0)}if(!c){t=A;return}lEc(a,c);t=A;return}function KXc(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=t;t=t+32|0;y=A+24|0;x=A+16|0;w=A+8|0;n=A;m=f[d>>2]|0;j=Mxc(c)|0;if(!(m&64))if((j|0)>4&(b[40718]|0)!=0)z=4;else z=68;else if((j|0)>4)z=4;else z=68;a:do if((z|0)==4)if(!(ocd(c,129463,5)|0)){l=j+8|0;i=0;k=l;l=((l|0)<0)<<31>>31;while(1){if((i|0)>=(j|0))break;s=vrd(k|0,l|0,(b[c+i>>0]|0)==38|0,0)|0;i=i+1|0;k=s;l=G}j=m|64;i=XAc(k,l)|0;if(!i){g=7;t=A;return g|0}b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;k=i+4|0;b:do if((b[c+5>>0]|0)==47?(b[c+6>>0]|0)==47:0){l=7;c:while(1){switch(b[c+l>>0]|0){case 0:case 47:break c;default:{}}l=l+1|0}switch(l&2147483647|0){case 7:{l=7;break b}case 16:{i=c+7|0;if(!(ocd(129469,i,9)|0)){l=16;break b}break}default:i=c+7|0}f[n>>2]=l+-7;f[n+4>>2]=i;l=k;i=1;k=WAc(129479,n)|0;z=74;break a}else l=5;while(0);i=0;m=0;d:while(1){p=k+(i+-1)|0;q=(m|0)==0;r=(m|0)==1;s=(m|0)!=2;e:while(1){n=b[c+l>>0]|0;switch(n<<24>>24){case 0:case 35:break d;default:{}}o=l+1|0;f:do if((n<<24>>24==37?(u=b[c+o>>0]|0,(b[1424+(u&255)>>0]&8)!=0):0)?(v=b[c+(l+2)>>0]|0,(b[1424+(v&255)>>0]&8)!=0):0){n=((SBc(u<<24>>24)|0)&255)<<4;l=l+3|0;n=n+((SBc(v<<24>>24)|0)&255)|0;if(n|0){z=33;break e}while(1){n=b[c+l>>0]|0;switch(n<<24>>24){case 35:case 0:break f;default:{}}if(q&n<<24>>24==63)break f;if(!r){if(!(s|n<<24>>24!=38))break f}else switch(n<<24>>24){case 38:case 61:break f;default:{}}l=l+1|0}}else z=34;while(0);g:do if((z|0)==34){z=0;switch(m|0){case 0:{z=43;break e}case 2:{z=44;break e}case 1:break;default:{l=o;break e}}switch(n<<24>>24){case 38:case 61:break;default:{m=1;l=o;break e}}if(b[p>>0]|0){z=41;break e}l=o;while(1){switch(b[c+l>>0]|0){case 35:case 0:break g;default:{}}if((b[c+(l+-1)>>0]|0)==38)break g;l=l+1|0}}while(0)}if((z|0)==33){z=0;n=n&255}else if((z|0)==41){z=0;if(n<<24>>24==38){b[k+i>>0]=0;n=0;i=i+1|0;m=1;l=o}else{n=0;m=2;l=o}}else if((z|0)==43){z=0;if(n<<24>>24==63)z=45;else{m=0;l=o}}else if((z|0)==44){z=0;if(n<<24>>24==38)z=45;else{m=2;l=o}}if((z|0)==45){z=0;n=0;m=1;l=o}b[k+i>>0]=n;i=i+1|0}if(r){b[k+i>>0]=0;i=i+1|0}i=k+i|0;b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;i=a;m=k;l=Mxc(k)|0;h:while(1){i:while(1){m=m+(l+1)|0;if(!(b[m>>0]|0)){z=72;break a}a=Mxc(m)|0;s=m+(a+1)|0;l=Mxc(s)|0;switch(a|0){case 3:{if(!(ocd(129507,m,3)|0))break i;break}case 5:{if(!(ocd(129511,m,5)|0)){p=393216;q=-393217;r=129511;n=14656;z=57}break}case 4:{if(!(ocd(129517,m,4)|0)){p=j&135;q=-136;r=118657;n=14688;z=57}break}default:{}}if((z|0)==57){z=0;m=0;while(1){o=f[n+(m<<3)>>2]|0;if(!o){z=63;break h}if((l|0)==(Mxc(o)|0)?(ocd(s,o,l)|0)==0:0)break;m=m+1|0}m=f[n+(m<<3)+4>>2]|0;if(!m){z=63;break h}if((m&-129|0)>(p|0)){z=65;break h}j=m|q&j}m=s}i=s;m=s}if((z|0)==63){f[w>>2]=r;f[w+4>>2]=s;l=k;i=1;k=WAc(129522,w)|0;z=74;break}else if((z|0)==65){f[x>>2]=r;f[x+4>>2]=s;l=k;i=3;k=WAc(129542,x)|0;z=74;break}}else z=68;while(0);if((z|0)==68){i=j+8|0;i=XAc(i,((i|0)<0)<<31>>31)|0;if(!i){g=7;t=A;return g|0}b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;k=i+4|0;if(j|0)Krd(k|0,c|0,j|0)|0;i=k+j|0;b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;i=a;j=m&-65;z=72}if((z|0)==72){x=Kzc(i)|0;f[e>>2]=x;if(!x){f[y>>2]=i;l=k;i=1;k=WAc(129566,y)|0;z=74}else i=0}if((z|0)==74){f[h>>2]=k;pIc(l);k=0}f[d>>2]=j;f[g>>2]=k;g=i;t=A;return g|0}function LXc(a,c){a=a|0;c=c|0;if(!c)c=$Ec(0,84,0)|0;else c=LWc(c,84,812)|0;if(!c){Cxc(a);return c|0}if(b[c+76>>0]|0)return c|0;hJc(c+8|0);hJc(c+24|0);hJc(c+40|0);hJc(c+56|0);b[c+77>>0]=1;return c|0}function MXc(a,c){a=a|0;c=c|0;if(((c|0)>-1?(b[a+12>>0]|0)==0:0)?(QXc(f[a+216>>2]|0)|0)==0:0)b[a+4>>0]=c;return h[a+4>>0]|0}function NXc(a,b){a=a|0;b=b|0;var c=0,e=0;if(!a){a=0;return a|0}Fzc(a);e=(f[a+4>>2]|0)+24|0;c=d[e>>1]|0;if((b|0)>-1){c=(b<<2|c&-13&65535)&65535;d[e>>1]=c}Bzc(a);a=(c&65535)>>>2&3;return a|0}function OXc(a,b){a=a|0;b=b|0;var c=0;c=f[a+4>>2]|0;Fzc(a);PXc(f[c>>2]|0,b);Bzc(a);return}function PXc(a,c){a=a|0;c=c|0;var d=0,e=0,f=0,g=0;d=c&7;if(!(b[a+12>>0]|0)){e=(d|0)==4&1;f=(d|0)==1&1;g=d>>>0>2&1}else{e=0;f=1;g=0}b[a+7>>0]=f;b[a+8>>0]=g;b[a+9>>0]=e;e=f<<24>>24==0;do if(e){d=a+10|0;if(!(c&8)){b[d>>0]=2;d=2;break}else{b[d>>0]=3;d=3;break}}else{b[a+10>>0]=0;d=0}while(0);g=(d<<2|(g<<24>>24==0?0:d))&255;b[a+11>>0]=(c&16|0)==0|e^1?g:g|12;a=a+20|0;g=h[a>>0]|0;b[a>>0]=(c&32|0)==0?g|1:g&254;return}
function Swc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0;k=a+88|0;c=f[k>>2]|0;g=a+44|0;e=f[g>>2]|0;l=a+7324+(e<<5)+(b<<1)|0;m=j[l>>1]|0;o=V(c>>>11,m)|0;c=c-o|0;i=a+96|0;n=i;o=vrd(f[n>>2]|0,f[n+4>>2]|0,o|0,0)|0;n=i;f[n>>2]=o;f[n+4>>2]=G;d[l>>1]=m-(m>>>5);if(c>>>0<16777216){Kwc(k);c=c<<8;e=f[g>>2]|0}o=a+7228+(e<<1)|0;n=j[o>>1]|0;c=V(c>>>11,n)|0;d[o>>1]=((2048-n|0)>>>5)+n;if(c>>>0<16777216){Kwc(k);c=c<<8;e=f[g>>2]|0}f[g>>2]=h[118388+e>>0];f[k>>2]=c;Mwc(a+8860|0,k,0,b);c=f[k>>2]|0;o=a+8094|0;n=j[o>>1]|0;e=V(c>>>11,n)|0;c=c-e|0;b=i;e=vrd(f[b>>2]|0,f[b+4>>2]|0,e|0,0)|0;b=G;m=i;f[m>>2]=e;f[m+4>>2]=b;d[o>>1]=n-(n>>>5);if(c>>>0<16777216){Kwc(k);b=i;c=c<<8;e=f[b>>2]|0;b=f[b+4>>2]|0}o=a+8098|0;n=j[o>>1]|0;m=V(c>>>11,n)|0;g=c-m|0;e=vrd(e|0,b|0,m|0,0)|0;c=G;m=i;f[m>>2]=e;f[m+4>>2]=c;d[o>>1]=n-(n>>>5);if(g>>>0<16777216){Kwc(k);c=i;b=g<<8;e=f[c>>2]|0;c=f[c+4>>2]|0}else b=g;o=a+8106|0;n=j[o>>1]|0;m=V(b>>>11,n)|0;b=b-m|0;c=vrd(e|0,c|0,m|0,0)|0;e=G;m=i;f[m>>2]=c;f[m+4>>2]=e;d[o>>1]=n-(n>>>5);if(b>>>0<16777216){Kwc(k);e=i;b=b<<8;c=f[e>>2]|0;e=f[e+4>>2]|0}o=a+8122|0;n=j[o>>1]|0;m=V(b>>>11,n)|0;b=b-m|0;c=vrd(c|0,e|0,m|0,0)|0;e=G;m=i;f[m>>2]=c;f[m+4>>2]=e;d[o>>1]=n-(n>>>5);if(b>>>0<16777216){Kwc(k);e=i;b=b<<8;c=f[e>>2]|0;e=f[e+4>>2]|0}o=a+8154|0;n=j[o>>1]|0;m=V(b>>>11,n)|0;b=b-m|0;c=vrd(c|0,e|0,m|0,0)|0;e=G;m=i;f[m>>2]=c;f[m+4>>2]=e;d[o>>1]=n-(n>>>5);if(b>>>0<16777216){Kwc(k);e=i;b=b<<8;g=f[e>>2]|0;e=f[e+4>>2]|0}else g=c;o=a+8218|0;n=j[o>>1]|0;l=V(b>>>11,n)|0;c=b-l|0;l=vrd(g|0,e|0,l|0,0)|0;m=i;f[m>>2]=l;f[m+4>>2]=G;d[o>>1]=n-(n>>>5);if(c>>>0<16777216){Kwc(k);c=c<<8}b=26;do{e=c>>>1;n=i;n=vrd(f[n>>2]|0,f[n+4>>2]|0,e|0,0)|0;o=i;f[o>>2]=n;f[o+4>>2]=G;if(c>>>0<33554432){Kwc(k);c=e<<8}else c=e;b=b+-1|0}while((b|0)!=0);o=a+7198|0;n=j[o>>1]|0;e=V(c>>>11,n)|0;c=c-e|0;b=i;e=vrd(f[b>>2]|0,f[b+4>>2]|0,e|0,0)|0;b=G;m=i;f[m>>2]=e;f[m+4>>2]=b;d[o>>1]=n-(n>>>5);if(c>>>0<16777216){Kwc(k);b=i;c=c<<8;e=f[b>>2]|0;b=f[b+4>>2]|0}o=a+7202|0;n=j[o>>1]|0;m=V(c>>>11,n)|0;g=c-m|0;c=vrd(e|0,b|0,m|0,0)|0;e=G;m=i;f[m>>2]=c;f[m+4>>2]=e;d[o>>1]=n-(n>>>5);if(g>>>0<16777216){Kwc(k);e=i;b=g<<8;c=f[e>>2]|0;e=f[e+4>>2]|0}else b=g;o=a+7210|0;n=j[o>>1]|0;m=V(b>>>11,n)|0;b=b-m|0;c=vrd(c|0,e|0,m|0,0)|0;e=G;m=i;f[m>>2]=c;f[m+4>>2]=e;d[o>>1]=n-(n>>>5);if(b>>>0<16777216){Kwc(k);e=i;b=b<<8;g=f[e>>2]|0;e=f[e+4>>2]|0}else g=c;o=a+7226|0;n=j[o>>1]|0;l=V(b>>>11,n)|0;c=b-l|0;l=vrd(g|0,e|0,l|0,0)|0;m=i;f[m>>2]=l;f[m+4>>2]=G;d[o>>1]=n-(n>>>5);if(c>>>0>=16777216){o=c;f[k>>2]=o;return}Kwc(k);o=c<<8;f[k>>2]=o;return}function Twc(a){a=a|0;var b=0;b=0;while(1){if((b|0)==5)break;Kwc(a);b=b+1|0}return}function Uwc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=a+172|0;e=(b|0)==0;g=a+184|0;h=a+128|0;i=a+112|0;j=a+120|0;k=a+104|0;while(1){c=Cwc(a,0,0)|0;if(c|0){a=7;break}if(f[d>>2]|0){c=0;a=7;break}if(!e?(n=f[b>>2]|0,l=g,m=f[l>>2]|0,l=f[l+4>>2]|0,o=h,c=(f[i>>2]|0)-(f[j>>2]|0)|0,p=k,o=vrd(f[p>>2]|0,f[p+4>>2]|0,f[o>>2]|0,f[o+4>>2]|0)|0,c=vrd(o|0,G|0,c|0,((c|0)<0)<<31>>31|0)|0,zd[n&127](b,m,l,c,G)|0):0){c=10;a=7;break}}if((a|0)==7)return c|0;return 0}function Vwc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=f[a+204>>2]|0;if((f[d>>2]|0)>>>0<5){c=5;return c|0}f[d>>2]=5;b[c>>0]=((((f[a+156>>2]|0)*5|0)+(f[a+152>>2]|0)|0)*9|0)+(f[a+148>>2]|0);a:do if(e>>>0>4194303)a=e>>>0<4293918720?e+1048575&-1048576:e;else{d=11;while(1){if(d>>>0>=31){a=e;break a}a=2<<d;if(e>>>0<=a>>>0)break a;a=3<<d;if(e>>>0>a>>>0)d=d+1|0;else break}}while(0);d=0;while(1){if((d|0)==4){a=0;break}e=d+1|0;b[c+e>>0]=a>>>(d<<3);d=e}return a|0}function Wwc(a,b,c,d,e,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0;m=t;t=t+16|0;n=m;f[n>>2]=162;f[n+4>>2]=b;k=n+8|0;f[k>>2]=f[c>>2];l=n+12|0;f[l>>2]=0;f[a+168>>2]=g;f[a+124>>2]=n;b=zwc(a,d,e,0,i,j)|0;if(!b){b=Uwc(a,h)|0;if(!b){b=a+184|0;b=((f[b+4>>2]|0)==0?(f[b>>2]|0)==(e|0):0)?0:11}}f[c>>2]=(f[c>>2]|0)-(f[k>>2]|0);t=m;return ((f[l>>2]|0)==0?b:7)|0}function Xwc(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0;l=Avc(j)|0;if(!l){j=2;return j|0}e=svc(l,e)|0;if(!e){e=Vwc(l,f,g)|0;if(!e)e=Wwc(l,a,b,c,d,h,i,j,k)|0}Hvc(l,j,k);j=e;return j|0}function Ywc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;if(a>>>0>9){d=Zwc(21738)|0;return d|0}if(!(134>>>a&1))e=$wc()|0;else e=_wc()|0;axc(e);g=f[153640+(a<<2)>>2]|0;f[b>>2]=g;f[b+4>>2]=0;a=153680+(a<<2)|0;f[c>>2]=f[a>>2];f[c+4>>2]=0;if(d|0)f[a>>2]=g;bxc(e);d=0;return d|0}function Zwc(a){a=a|0;cxc(21,a,118400)|0;return 21}function _wc(){return f[38451]|0}function $wc(){return f[37666]|0}function axc(a){a=a|0;if(!a)return;Hd[f[40792>>2]&1023](a);return}function bxc(a){a=a|0;if(!a)return;Hd[f[40800>>2]&1023](a);return}function cxc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;f[e>>2]=c;f[e+4>>2]=b;f[e+8>>2]=118452;dxc(a,118407,e);t=d;return a|0}function dxc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if(!(f[10237]|0)){t=e;return}f[d>>2]=c;exc(a,b,d);t=e;return}function exc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=t;t=t+240|0;g=d+216|0;fxc(g,0,d,210,0);gxc(g,b,c);e=f[10237]|0;b=f[10238]|0;c=hxc(g)|0;Kd[e&255](b,a,c);t=d;return}function fxc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;f[a+4>>2]=d;f[a>>2]=c;f[a+8>>2]=e;f[a+12>>2]=g;f[a+16>>2]=0;b[a+20>>0]=0;b[a+21>>0]=0;return}function gxc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,q=0.0,r=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0.0,S=0,T=0,U=0,V=0,W=0,X=0;W=t;t=t+96|0;Q=W+72|0;S=W+80|0;T=W;U=a+21|0;if(!(b[U>>0]&2)){F=1;H=0}else{F=(f[d>>2]|0)+(4-1)&~(4-1);H=f[F>>2]|0;f[d>>2]=F+4;F=0}I=a+16|0;J=T+1|0;K=T+2|0;L=T+3|0;M=a+12|0;N=a+20|0;O=a+4|0;P=a+8|0;e=0;a:while(1){switch(b[c>>0]|0){case 0:{C=242;break a}case 37:break;default:{e=c;b:while(1){g=e+1|0;switch(b[g>>0]|0){case 37:case 0:break b;default:e=g}}Dxc(a,c,g-c|0);if(!(b[g>>0]|0)){C=242;break a}else{e=c;c=g}}}g=c+1|0;c=b[g>>0]|0;if(!(c<<24>>24)){C=9;break}i=c<<24>>24;c=-1;j=0;y=0;o=0;r=0;u=0;v=0;w=0;c:while(1){switch(i|0){case 108:{C=19;break c}case 45:{l=1;break}case 43:{o=43;l=y;break}case 32:{o=32;l=y;break}case 35:{r=1;l=y;break}case 33:{u=1;l=y;break}case 48:{v=1;l=y;break}case 44:{w=44;l=y;break}case 57:case 56:case 55:case 54:case 53:case 52:case 51:case 50:case 49:{while(1){j=i+-48|0;l=g+1|0;k=b[l>>0]|0;i=k<<24>>24;if((k+-48&255)>=10)break;i=(j*10|0)+i|0;g=l}j=j&2147483647;switch(k<<24>>24){case 46:case 108:{l=y;break}default:{E=l;B=r;z=u;r=w;D=y;l=0;break c}}break}case 42:{if(F){E=(f[d>>2]|0)+(4-1)&~(4-1);i=f[E>>2]|0;f[d>>2]=E+4}else i=Exc(H)|0;j=(i|0)<0;k=j?1:y;j=j?((i|0)==-2147483648?0:0-i|0):i;i=b[g+1>>0]|0;switch(i<<24>>24){case 46:case 108:{l=k;break}default:{C=39;break c}}break}case 46:{i=g+1|0;c=b[i>>0]|0;if(c<<24>>24==42){if(F){E=(f[d>>2]|0)+(4-1)&~(4-1);c=f[E>>2]|0;f[d>>2]=E+4}else c=Exc(H)|0;k=g+2|0;i=b[k>>0]|0;c=(c|0)<0?((c|0)==-2147483648?-1:0-c|0):c}else{g=0;k=i;while(1){i=c<<24>>24;c=i+-48|0;if(c>>>0>=10)break;E=k+1|0;g=c+(g*10|0)|0;k=E;c=b[E>>0]|0}c=g&2147483647}if((i|0)==108){l=y;g=k+-1|0}else{E=k;B=r;z=u;r=w;D=y;l=0;break c}break}default:{E=g;B=r;z=u;r=w;D=y;l=0;break c}}g=g+1|0;i=b[g>>0]|0;if(!(i<<24>>24)){E=g;B=r;z=u;r=w;D=l;l=0;i=0;break}else{i=i<<24>>24;y=l}}if((C|0)==19){C=0;i=g+1|0;k=b[i>>0]|0;if(k<<24>>24==108){i=g+2|0;E=i;B=r;z=u;r=w;D=y;l=2;i=b[i>>0]|0}else{E=i;B=r;z=u;r=w;D=y;l=1;i=k<<24>>24}}else if((C|0)==39){C=0;E=g+1|0;B=r;z=u;r=w;D=k;l=0;i=i<<24>>24}A=0;while(1){if(A>>>0>=23){C=242;break a}if((i|0)==(b[1088+(A*6|0)>>0]|0))break;A=A+1|0}g=b[1088+(A*6|0)+3>>0]|0;d:do switch(g<<24>>24){case 13:{e=1;C=46;break}case 0:case 15:{e=l;C=46;break}case 16:{z=r;e=l;C=47;break}case 3:case 2:case 1:{if(F){y=(f[d>>2]|0)+(8-1)&~(8-1);m=+p[y>>3];f[d>>2]=y+8}else m=+Gxc(H);i=(c|0)<0?6:c;l=(i|0)<1e8?i:1e8;e=m<0.0;m=e?-m:m;p[Q>>3]=m;r=(A|0)==2|(A|0)==15;i=l+(((i|0)>0&r)<<31>>31)|0;c=i&4095;n=+p[1280+(((c>>>0)%10|0)<<3)>>3];while(1){if((c|0)<=9)break;n=n*1.0e-10;c=c+-10|0}w=e?45:o;e=(A|0)==12;if(e){p[s>>3]=m;y=Grd(f[s>>2]|0,f[s+4>>2]|0,52)|0;x=((((y&2047)+-1023|0)/3|0)+i|0)<15?n+m*3.0e-16:n;m=m+x;p[Q>>3]=m}else x=n;if(!(Hxc(m)|0)){if(m>0.0){n=1.0;k=0;while(1){q=n*1.e+100;if(k>>>0<351&m>=q){n=q;k=k+100|0}else break}while(1){q=n*1.0e10;if(k>>>0<351&m>=q){n=q;k=k+10|0}else break}while(1){q=n*10.0;if(k>>>0<351&m>=q){n=q;k=k+1|0}else break}m=m/n;p[Q>>3]=m;while(1){if(!(m<1.0e-08))break;k=k+-8|0;m=m*1.0e8}p[Q>>3]=m;while(1){if(!(m<1.0))break;k=k+-1|0;m=m*10.0}p[Q>>3]=m;c=w<<24>>24!=0;if((k|0)>350){i=T+(c&1)|0;b[T>>0]=w;b[i>>0]=73;b[i+1>>0]=110;b[i+2>>0]=102;b[i+3>>0]=0;i=c?4:3;e=T;g=0;break d}}else k=0;if(!e?(R=x+m,p[Q>>3]=R,R>=10.0):0){p[Q>>3]=R*.1;k=k+1|0}c=(k|0)<-4|(i|0)<(k|0);u=r?B<<24>>24==0&1:z;i=r?i-(c?0:k)|0:l;r=(r?(c?2:1):g)<<24>>24==2;l=r?0:k;c=vrd(i|0,((i|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;c=vrd(c|0,G|0,((l|0)>0?l:0)|0,0)|0;e=G;if((e|0)>0|(e|0)==0&c>>>0>55){c=vrd(c|0,e|0,15,0)|0;c=Fxc(a,c,G)|0;if(!c){C=242;break a}else{e=c;g=c}}else{e=T;g=0}f[S>>2]=((z&255)*10|0)+16;o=(z|B)&255|(i|0)>0;if(!(w<<24>>24))c=e;else{b[e>>0]=w;c=e+1|0}e:do if((l|0)<0){b[c>>0]=48;c=c+1|0}else while(1){if((l|0)<=-1){l=-1;break e}B=Ixc(Q,S)|0;b[c>>0]=B;c=c+1|0;l=l+-1|0}while(0);o=(o|0)==0;if(!o){b[c>>0]=46;c=c+1|0}while(1){if((l|0)>=-1)break;b[c>>0]=48;i=i+-1|0;c=c+1|0;l=l+1|0}while(1){if((i|0)<=0)break;B=Ixc(Q,S)|0;b[c>>0]=B;i=i+-1|0;c=c+1|0}f:do if(!(u<<24>>24==0|o)){g:while(1){i=c+-1|0;switch(b[i>>0]|0){case 46:break g;case 48:break;default:break f}b[i>>0]=0;c=i}if(!(z<<24>>24)){b[i>>0]=0;c=i;break}else{b[c>>0]=48;c=c+1|0;break}}while(0);if(r){l=c+1|0;b[c>>0]=b[1232+(h[1088+(A*6|0)+4>>0]|0)>>0]|0;i=c+2|0;if((k|0)<0){b[l>>0]=45;k=0-k|0}else b[l>>0]=43;if((k|0)>99){B=(k>>>0)/100|0;b[i>>0]=B+48;i=c+3|0;c=k-(B*100|0)|0}else c=k;B=(c|0)/10|0;b[i>>0]=B+48;b[i+1>>0]=c-(B*10|0)+48;c=i+2|0}b[c>>0]=0;i=c-e|0;if(D<<24>>24==0&v<<24>>24!=0&(j|0)>(i|0)){i=j-i|0;c=j;while(1){if((c|0)<(i|0))break;b[e+c>>0]=b[e+(c-i)>>0]|0;c=c+-1|0}c=w<<24>>24!=0&1;while(1){if(!i){i=j;break d}b[e+c>>0]=48;i=i+-1|0;c=c+1|0}}}else{i=3;e=118547;g=0}break}case 4:{if(F){j=f[I>>2]|0;g=(f[d>>2]|0)+(4-1)&~(4-1);i=f[g>>2]|0;f[d>>2]=g+4;f[i>>2]=j;i=0;j=0;g=0}else{i=0;j=0;g=0}break}case 7:{b[T>>0]=37;i=1;e=T;g=0;break}case 8:{h:do if(F){C=(f[d>>2]|0)+(4-1)&~(4-1);e=f[C>>2]|0;f[d>>2]=C+4;if(e>>>0<128){b[T>>0]=e;i=1;break}if(e>>>0<2048){b[T>>0]=e>>>6&31|192;b[J>>0]=e&63|128;i=2;break}if(e>>>0<65536){b[T>>0]=e>>>12&15|224;b[J>>0]=e>>>6&63|128;b[K>>0]=e&63|128;i=3;break}else{b[T>>0]=e>>>18&7|240;b[J>>0]=e>>>12&63|128;b[K>>0]=e>>>6&63|128;b[L>>0]=e&63|128;i=4;break}}else{e=Jxc(H)|0;if(!e){b[T>>0]=0;i=1;break}C=b[e>>0]|0;b[T>>0]=C;if((C&255)>191){i=1;while(1){e=e+1|0;if(i>>>0>=4){i=4;break h}g=b[e>>0]|0;if((g&-64)<<24>>24!=-128)break h;b[T+i>>0]=g;i=i+1|0}}else i=1}while(0);if((c|0)>1){e=1-c+j|0;if((e|0)<2|D<<24>>24!=0)j=e;else{Kxc(a,e+-1|0,32);j=0}while(1){if((c|0)<=1){e=T;l=1;g=0;C=199;break d}Dxc(a,T,i);c=c+-1|0}}else{e=T;l=1;g=0;C=199}break}case 6:case 5:{if(F){B=(f[d>>2]|0)+(4-1)&~(4-1);e=f[B>>2]|0;f[d>>2]=B+4}else{e=Jxc(H)|0;g=5}if(e)if(g<<24>>24==6)if((f[I>>2]|0)==0?(c|0)<0&((j|0)==0&(f[M>>2]|0)!=0):0)if(!(b[N>>0]|0)){f[O>>2]=e;i=txc(f[a>>2]|0,e)|0;f[P>>2]=i;i=(udd(e)|0)&2147483647;f[I>>2]=i;b[U>>0]=b[U>>0]|4;i=0;j=0;g=0;break d}else{c=e;g=e}else{o=e;g=e;C=184}else{o=e;g=0;C=184}else{o=155644;g=0;C=184}if((C|0)==184){C=0;if((c|0)>-1){if(!(z<<24>>24)){e=0;while(1){if((e|0)>=(c|0)){i=e;e=o;break d}if(!(b[o+e>>0]|0)){i=e;e=o;break d}e=e+1|0}}k=o;while(1){i=c+-1|0;if((c|0)<=0)break;e=b[k>>0]|0;if(!(e<<24>>24))break;c=k+1|0;if((e&255)>191)while(1)if((b[c>>0]&-64)<<24>>24==-128)c=c+1|0;else break;k=c;c=i}e=o;l=z;i=k-o|0;C=199;break d}else c=o}e=c;l=z;i=(udd(c)|0)&2147483647;C=199;break}case 14:case 10:case 9:{w=(A|0)==6?34:39;if(F){C=(f[d>>2]|0)+(4-1)&~(4-1);e=f[C>>2]|0;f[d>>2]=C+4}else e=Jxc(H)|0;l=(e|0)==0;k=(A|0)==5;u=l?(k?118535:118540):e;v=w&255;i=z<<24>>24!=0;g=0;r=0;while(1){if(!c)break;C=b[u+r>>0]|0;e=C<<24>>24;if(!(C<<24>>24))break;g=g+((e|0)==(v|0)&1)|0;if(i&(e&192|0)==192){e=r;do e=e+1|0;while((b[u+e>>0]&-64)<<24>>24==-128)}else e=r+1|0;c=c+-1|0;r=e}o=k&(l^1);c=r+3+g|0;if((c|0)>70){c=Fxc(a,c,((c|0)<0)<<31>>31)|0;if(!c){C=242;break a}else{e=c;g=c}}else{e=T;g=0}if(o){b[e>>0]=w;i=1}else i=0;l=0;while(1){if((l|0)>=(r|0))break;c=b[u+l>>0]|0;k=i+1|0;b[e+i>>0]=c;if((c<<24>>24|0)==(v|0)){b[e+k>>0]=c;i=i+2|0}else i=k;l=l+1|0}if(o){b[e+i>>0]=w;i=i+1|0}b[e+i>>0]=0;l=z;C=199;break}case 11:{if(!(b[U>>0]&1)){C=242;break a}B=(f[d>>2]|0)+(4-1)&~(4-1);c=f[B>>2]|0;f[d>>2]=B+4;if((c|0)!=0?(V=f[c+4>>2]|0,(V|0)!=0):0){Dxc(a,f[c>>2]|0,V);i=0;j=0;g=0}else{i=0;j=0;g=0}break}case 12:{if(!(b[U>>0]&1)){C=242;break a}i=(f[d>>2]|0)+(4-1)&~(4-1);c=f[i>>2]|0;f[d>>2]=i+4;i=(f[d>>2]|0)+(4-1)&~(4-1);g=f[i>>2]|0;f[d>>2]=i+4;i=f[c+8+(g*72|0)+4>>2]|0;if(i|0){Lxc(a,i);Dxc(a,140851,1)}Lxc(a,f[c+8+(g*72|0)+8>>2]|0);i=0;j=0;g=0;break}default:{C=242;break a}}while(0);i:do if((C|0)==46){z=0;C=47}else if((C|0)==199){C=0;if(l<<24>>24!=0&(j|0)>0){k=i;while(1){c=k+-1|0;if((k|0)<=0)break i;k=c;j=j+((b[e+c>>0]&-64)<<24>>24==-128&1)|0}}}while(0);if((C|0)==47){C=0;j:do if(!(4067322>>>A&1)){k:do if(F)switch(e<<24>>24){case 0:{g=(f[d>>2]|0)+(4-1)&~(4-1);e=f[g>>2]|0;f[d>>2]=g+4;g=((e|0)<0)<<31>>31;break k}case 2:{y=(f[d>>2]|0)+(8-1)&~(8-1);g=y;e=f[g>>2]|0;g=f[g+4>>2]|0;f[d>>2]=y+8;break k}default:{g=(f[d>>2]|0)+(4-1)&~(4-1);e=f[g>>2]|0;f[d>>2]=g+4;g=((e|0)<0)<<31>>31;break k}}else{e=Exc(H)|0;g=G}while(0);u=(g|0)<0;r=wrd(0,0,e|0,g|0)|0;y=u?45:o;r=u?r:e;u=u?G:g}else{if(!F){r=Exc(H)|0;y=0;u=G;break}switch(e<<24>>24){case 0:{y=(f[d>>2]|0)+(4-1)&~(4-1);r=f[y>>2]|0;f[d>>2]=y+4;y=0;u=0;break j}case 2:{y=(f[d>>2]|0)+(8-1)&~(8-1);u=y;r=f[u>>2]|0;u=f[u+4>>2]|0;f[d>>2]=y+8;y=0;break j}default:{y=(f[d>>2]|0)+(4-1)&~(4-1);r=f[y>>2]|0;f[d>>2]=y+4;y=0;u=0;break j}}}while(0);w=(r|0)==0&(u|0)==0;o=j-(y<<24>>24!=0&1)|0;v=v<<24>>24==0?c:(c|0)<(o|0)?o:c;if((v|0)>=37){c=vrd(v|0,((v|0)<0)<<31>>31|0,10,0)|0;e=G;if(z<<24>>24){c=vrd(c|0,e|0,(v>>>0)/3|0|0,0)|0;e=G}e=Fxc(a,c,e)|0;if(!e){C=242;break}else{i=e;g=e}}else{i=T;g=0;c=70}k=i+(c+-1)|0;if((A|0)==22){l=Drd(r|0,u|0,10,0)|0;e=G;o=Brd(l|0,e|0,10,0)|0;o=wrd(r|0,u|0,o|0,G|0)|0;e=Erd(l|0,e|0,10,0)|0;o=((o|0)>3|(e|0)==1&(G|0)==0?0:o)<<1;e=k+-1|0;b[e>>0]=b[118519+(o|1)>>0]|0;e=e+-1|0;b[e>>0]=b[118519+o>>0]|0}else e=k;l=1232+(h[1088+(A*6|0)+4>>0]|0)|0;o=h[1088+(A*6|0)+1>>0]|0;i=r;c=u;do{u=i;i=Drd(i|0,c|0,o|0,0)|0;r=c;c=G;X=Brd(i|0,c|0,o|0,0)|0;X=wrd(u|0,r|0,X|0,G|0)|0;e=e+-1|0;b[e>>0]=b[l+X>>0]|0}while(!(r>>>0<0|(r|0)==0&u>>>0<o>>>0));r=k;c=r-e|0;while(1){if((v|0)<=(c|0))break;X=e+-1|0;b[X>>0]=48;c=c+1|0;e=X}l:do if(z<<24>>24){c=c+-1|0;l=(c|0)/3|0;e=e+(0-l)|0;c=c-(l*3|0)+1|0;i=0;while(1){o=(l|0)>0;while(1){if(!o)break l;b[e+i>>0]=b[e+(i+l)>>0]|0;c=c+-1|0;k=i+1|0;if(!c)break;else i=k}b[e+k>>0]=z;c=3;l=l+-1|0;i=i+2|0}}while(0);if(y<<24>>24){e=e+-1|0;b[e>>0]=y}m:do if(!(B<<24>>24==0|w)?(7860991>>>A&1|0)==0:0){i=118528+(h[1088+(A*6|0)+5>>0]|0)|0;while(1){c=b[i>>0]|0;if(!(c<<24>>24))break m;X=e+-1|0;b[X>>0]=c;i=i+1|0;e=X}}while(0);i=r-e|0}c=j-i|0;do if((c|0)>0)if(!(D<<24>>24)){Kxc(a,c,32);Dxc(a,e,i);break}else{Dxc(a,e,i);Kxc(a,c,32);break}else Dxc(a,e,i);while(0);if(g|0)nxc(f[a>>2]|0,g);c=E+1|0}if((C|0)==9){Dxc(a,118517,1);t=W;return}else if((C|0)==242){t=W;return}}function hxc(a){a=a|0;var c=0,d=0;c=a+4|0;d=f[c>>2]|0;if((d|0?(b[d+(f[a+16>>2]|0)>>0]=0,f[a+12>>2]|0):0)?(b[a+21>>0]&4)==0:0){d=ixc(a)|0;return d|0}d=f[c>>2]|0;return d|0}function ixc(a){a=a|0;var c=0,d=0,e=0;c=a+16|0;d=jxc(f[a>>2]|0,(f[c>>2]|0)+1|0,0)|0;if(!d){kxc(a,7);c=a+4|0;f[c>>2]=d;return d|0}else{e=a+4|0;Krd(d|0,f[e>>2]|0,(f[c>>2]|0)+1|0)|0;c=a+21|0;b[c>>0]=b[c>>0]|4;c=e;f[c>>2]=d;return d|0}return 0}function jxc(a,b,c){a=a|0;b=b|0;c=c|0;if(!a){c=vxc(b,c)|0;return c|0}else{c=uxc(a,b,c)|0;return c|0}return 0}function kxc(a,c){a=a|0;c=c|0;b[a+20>>0]=c;if(f[a+12>>2]|0)lxc(a);if(c<<24>>24!=18)return;mxc(f[a>>2]|0,18)|0;return}function lxc(a){a=a|0;var c=0,d=0;c=a+21|0;if(!(b[c>>0]&4))c=a+4|0;else{d=a+4|0;nxc(f[a>>2]|0,f[d>>2]|0);b[c>>0]=b[c>>0]&-5;c=d}f[a+8>>2]=0;f[a+16>>2]=0;f[c>>2]=0;return}function mxc(a,b){a=a|0;b=b|0;if(!a)return b|0;a=f[a+244>>2]|0;if(!a)return b|0;f[a+12>>2]=b;a=a+36|0;f[a>>2]=(f[a>>2]|0)+1;return b|0}function nxc(a,b){a=a|0;b=b|0;if(!b)return;oxc(a,b);return}function oxc(a,b){a=a|0;b=b|0;var c=0;if(a|0){if(f[a+504>>2]|0){pxc(a,b);return}c=b;if((f[a+332>>2]|0)>>>0>c>>>0){if((f[a+324>>2]|0)>>>0<=c>>>0){c=a+320|0;f[b>>2]=f[c>>2];f[c>>2]=b;return}if((f[a+328>>2]|0)>>>0<=c>>>0){c=a+312|0;f[b>>2]=f[c>>2];f[c>>2]=b;return}}}qxc(b);return}function pxc(a,b){a=a|0;b=b|0;var c=0;c=txc(a,b)|0;b=f[a+504>>2]|0;f[b>>2]=(f[b>>2]|0)+c;return}function qxc(a){a=a|0;if(!a)return;if(!(f[10178]|0)){Hd[f[40748>>2]&1023](a);return}else{axc(f[37666]|0);sxc(0,rxc(a)|0);sxc(9,1);Hd[f[40748>>2]&1023](a);bxc(f[37666]|0);return}}function rxc(a){a=a|0;return sd[f[40756>>2]&2047](a)|0}function sxc(a,b){a=a|0;b=b|0;a=153640+(a<<2)|0;f[a>>2]=(f[a>>2]|0)-b;return}function txc(a,b){a=a|0;b=b|0;var c=0;if(a|0?(c=b,(f[a+332>>2]|0)>>>0>c>>>0):0){if((f[a+324>>2]|0)>>>0<=c>>>0){c=128;return c|0}if((f[a+328>>2]|0)>>>0<=c>>>0){c=j[a+286>>1]|0;return c|0}}c=sd[f[40756>>2]&2047](b)|0;return c|0}function uxc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;if(0<d>>>0|(0==(d|0)?(j[a+284>>1]|0)>>>0<c>>>0:0)){if(f[a+280>>2]|0){if(b[a+83>>0]|0){d=0;return d|0}}else{g=a+300|0;f[g>>2]=(f[g>>2]|0)+1}d=Bxc(a,c,d)|0;return d|0}if(d>>>0<0|(d|0)==0&c>>>0<129){e=a+320|0;g=f[e>>2]|0;if(g|0){f[e>>2]=f[g>>2];d=a+296|0;f[d>>2]=(f[d>>2]|0)+1;d=g;return d|0}e=a+316|0;g=f[e>>2]|0;if(g|0){f[e>>2]=f[g>>2];d=a+296|0;f[d>>2]=(f[d>>2]|0)+1;d=g;return d|0}}e=a+312|0;g=f[e>>2]|0;if(g|0){f[e>>2]=f[g>>2];d=a+296|0;f[d>>2]=(f[d>>2]|0)+1;d=g;return d|0}e=a+308|0;g=f[e>>2]|0;if(!g){g=a+304|0;f[g>>2]=(f[g>>2]|0)+1;d=Bxc(a,c,d)|0;return d|0}else{f[e>>2]=f[g>>2];d=a+296|0;f[d>>2]=(f[d>>2]|0)+1;d=g;return d|0}return 0}function vxc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=t;t=t+16|0;c=d;b=vrd(a|0,b|0,-1,-1)|0;e=G;if(e>>>0>0|(e|0)==0&b>>>0>2147483390){f[c>>2]=0;e=0;t=d;return e|0}if(!(f[10178]|0)){e=sd[f[40744>>2]&2047](a)|0;f[c>>2]=e;t=d;return e|0}else{axc(f[37666]|0);wxc(a,c);bxc(f[37666]|0);e=f[c>>2]|0;t=d;return e|0}return 0}function wxc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;e=sd[f[40760>>2]&2047](a)|0;xxc(5,a);c=150672;a=f[c>>2]|0;c=f[c+4>>2]|0;do if((c|0)>0|(c|0)==0&a>>>0>0){g=yxc()|0;h=G;d=((e|0)<0)<<31>>31;c=wrd(a|0,c|0,e|0,d|0)|0;a=G;if((h|0)<(a|0)|(h|0)==(a|0)&g>>>0<c>>>0){f[37672]=0;break}f[37672]=1;zxc(e);c=150680;a=f[c>>2]|0;c=f[c+4>>2]|0;if(!((a|0)==0&(c|0)==0)?(g=yxc()|0,i=G,h=wrd(a|0,c|0,e|0,d|0)|0,d=G,!((i|0)<(d|0)|(i|0)==(d|0)&g>>>0<h>>>0)):0){i=0;f[b>>2]=i;return}}while(0);a=sd[f[40744>>2]&2047](e)|0;if(!a){i=0;f[b>>2]=i;return}Axc(0,rxc(a)|0);Axc(9,1);i=a;f[b>>2]=i;return}function xxc(a,b){a=a|0;b=b|0;a=153680+(a<<2)|0;if((f[a>>2]|0)>>>0>=b>>>0)return;f[a>>2]=b;return}function yxc(){G=0;return f[38410]|0}function zxc(a){a=a|0;var b=0;a=150672;b=f[a+4>>2]|0;if((b|0)<0|(b|0)==0&(f[a>>2]|0)>>>0<1)return;bxc(f[37666]|0);axc(f[37666]|0);return}function Axc(a,b){a=a|0;b=b|0;var c=0,d=0;d=153640+(a<<2)|0;c=(f[d>>2]|0)+b|0;f[d>>2]=c;b=153680+(a<<2)|0;if(c>>>0<=(f[b>>2]|0)>>>0)return;f[b>>2]=c;return}function Bxc(a,b,c){a=a|0;b=b|0;c=c|0;b=vxc(b,c)|0;if(b|0)return b|0;Cxc(a);return b|0}function Cxc(a){a=a|0;var c=0;c=a+83|0;if(b[c>>0]|0)return;if(b[a+84>>0]|0)return;b[c>>0]=1;if((f[a+188>>2]|0)>0)f[a+272>>2]=1;c=a+280|0;f[c>>2]=(f[c>>2]|0)+1;d[a+284>>1]=0;a=f[a+244>>2]|0;if(!a)return;f[a+12>>2]=7;return}function Dxc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=a+16|0;e=f[d>>2]|0;g=e+c|0;if(g>>>0>=(f[a+8>>2]|0)>>>0){xyc(a,b,c);return}if(!c)return;f[d>>2]=g;Krd((f[a+4>>2]|0)+e|0,b|0,c|0)|0;return}function Exc(a){a=a|0;var b=0,c=0;b=a+4|0;c=f[b>>2]|0;if((f[a>>2]|0)<=(c|0)){b=0;c=0;G=b;return c|0}a=f[a+8>>2]|0;f[b>>2]=c+1;c=ryc(f[a+(c<<2)>>2]|0)|0;b=G;G=b;return c|0}function Fxc(a,c,d){a=a|0;c=c|0;d=d|0;if(b[a+20>>0]|0){a=0;return a|0}if(0<(d|0)|(0==(d|0)?(f[a+8>>2]|0)>>>0<c>>>0:0)?0<(d|0)|(0==(d|0)?(f[a+12>>2]|0)>>>0<c>>>0:0):0){kxc(a,18);a=0;return a|0}c=jxc(f[a>>2]|0,c,d)|0;if(c|0){a=c;return a|0}kxc(a,7);a=0;return a|0}function Gxc(a){a=a|0;var b=0,c=0,d=0.0;b=a+4|0;c=f[b>>2]|0;if((f[a>>2]|0)<=(c|0)){d=0.0;return +d}a=f[a+8>>2]|0;f[b>>2]=c+1;d=+myc(f[a+(c<<2)>>2]|0);return +d}function Hxc(a){a=+a;var b=0;p[s>>3]=a;b=f[s+4>>2]|0;return 0==0&(b&2146435072|0)==2146435072&((f[s>>2]|0)!=0|(b&1048575|0)!=0)&1|0}function Ixc(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=f[b>>2]|0;if((c|0)<1){c=48;return c|0}f[b>>2]=c+-1;d=+p[a>>3];c=~~d;p[a>>3]=(d-+(c|0))*10.0;c=c+48&255;return c|0}function Jxc(a){a=a|0;var b=0,c=0;b=a+4|0;c=f[b>>2]|0;if((f[a>>2]|0)<=(c|0)){c=0;return c|0}a=f[a+8>>2]|0;f[b>>2]=c+1;c=Txc(f[a+(c<<2)>>2]|0)|0;return c|0}function Kxc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=a+16|0;g=vrd(f[e>>2]|0,0,c|0,((c|0)<0)<<31>>31|0)|0;h=G;if(!((h|0)<0|((h|0)==0?g>>>0<(f[a+8>>2]|0)>>>0:0))){c=Nxc(a,c)|0;if((c|0)<1)return}a=a+4|0;while(1){if((c|0)<=0)break;g=f[a>>2]|0;h=f[e>>2]|0;f[e>>2]=h+1;b[g+h>>0]=d;c=c+-1|0}return}function Lxc(a,b){a=a|0;b=b|0;Dxc(a,b,Mxc(b)|0);return}function Mxc(a){a=a|0;if(!a){a=0;return a|0}a=(udd(a)|0)&1073741823;return a|0}function Nxc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if(b[a+20>>0]|0){k=0;return k|0}d=f[a+12>>2]|0;if(!d){kxc(a,18);k=(f[a+8>>2]|0)+-1-(f[a+16>>2]|0)|0;return k|0}i=a+21|0;if(!(b[i>>0]&4))h=0;else h=f[a+4>>2]|0;j=a+16|0;e=f[j>>2]|0;n=vrd(c|0,((c|0)<0)<<31>>31|0,1,0)|0;n=vrd(n|0,G|0,e|0,0)|0;l=G;e=vrd(n|0,l|0,e|0,0)|0;g=G;m=(g|0)>0|(g|0)==0&e>>>0>d>>>0;e=m?n:e;g=m?l:g;if((g|0)>0|(g|0)==0&e>>>0>d>>>0){lxc(a);kxc(a,18);n=0;return n|0}g=a+8|0;f[g>>2]=e;d=f[a>>2]|0;if(!d)d=Pxc(h,e,0)|0;else d=Oxc(d,h,e,0)|0;if(!d){lxc(a);kxc(a,7);n=0;return n|0}if((b[i>>0]&4)==0?(k=f[j>>2]|0,k|0):0)Krd(d|0,f[a+4>>2]|0,k|0)|0;f[a+4>>2]=d;n=txc(f[a>>2]|0,d)|0;f[g>>2]=n;b[i>>0]=b[i>>0]|4;n=c;return n|0}function Oxc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;if(!b){e=uxc(a,c,d)|0;return e|0}e=b;do if((f[a+332>>2]|0)>>>0>e>>>0){if((f[a+324>>2]|0)>>>0<=e>>>0){if(!(d>>>0<0|(d|0)==0&c>>>0<129))break;return b|0}if((f[a+328>>2]|0)>>>0<=e>>>0?!(0<d>>>0|(0==(d|0)?(j[a+286>>1]|0)>>>0<c>>>0:0)):0){e=b;return e|0}}while(0);e=Qxc(a,b,c,d)|0;return e|0}function Pxc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;if(!a){i=vxc(b,c)|0;return i|0}if((b|0)==0&(c|0)==0){qxc(a);i=0;return i|0}if(c>>>0>0|(c|0)==0&b>>>0>2147483391){i=0;return i|0}e=rxc(a)|0;d=sd[f[40760>>2]&2047](b)|0;if((d|0)==(e|0)){i=a;return i|0}if(!(f[10178]|0)){i=td[f[40752>>2]&1023](a,d)|0;return i|0}axc(f[37666]|0);xxc(5,b);c=d-e|0;if(((c|0)>0?(g=yxc()|0,h=G,b=150672,i=((c|0)<0)<<31>>31,b=wrd(f[b>>2]|0,f[b+4>>2]|0,c|0,i|0)|0,j=G,!((h|0)<(j|0)|(h|0)==(j|0)&g>>>0<b>>>0)):0)?(zxc(c),k=150680,b=f[k>>2]|0,k=f[k+4>>2]|0,j=wrd(b|0,k|0,c|0,i|0)|0,i=G,!((k|0)<0|(k|0)==0&b>>>0<1|((h|0)<(i|0)|(h|0)==(i|0)&g>>>0<j>>>0))):0){bxc(f[37666]|0);k=0;return k|0}c=td[f[40752>>2]&1023](a,d)|0;if(c|0)Axc(0,(rxc(c)|0)-e|0);bxc(f[37666]|0);k=c;return k|0}function Qxc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;if(b[a+83>>0]|0){a=0;return a|0}if(!(Rxc(a,c)|0)){d=Pxc(c,d,e)|0;if(d|0){a=d;return a|0}Cxc(a);a=0;return a|0}else{d=uxc(a,d,e)|0;if(!d){a=0;return a|0}Krd(d|0,c|0,Sxc(a,c)|0)|0;nxc(a,c);a=d;return a|0}return 0}function Rxc(a,b){a=a|0;b=b|0;if((f[a+328>>2]|0)>>>0>b>>>0){a=0;return a|0}a=(f[a+332>>2]|0)>>>0>b>>>0&1;return a|0}function Sxc(a,b){a=a|0;b=b|0;if((f[a+324>>2]|0)>>>0<=b>>>0){b=128;return b|0}b=j[a+286>>1]|0;return b|0}function Txc(a){a=a|0;return Uxc(a,1)|0}function Uxc(a,c){a=a|0;c=c|0;var e=0;if(!a){e=0;return e|0}e=d[a+8>>1]|0;if((e&514)==514?(b[a+10>>0]|0)==c<<24>>24:0){e=f[a+16>>2]|0;return e|0}if(e&1){e=0;return e|0}e=Vxc(a,c)|0;return e|0}function Vxc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0;i=a+8|0;e=d[i>>1]|0;g=e&65535;if(!(g&18)){_xc(a,c,0)|0;e=a+10|0}else{do if(g&16384)if(!(Wxc(a)|0)){e=d[i>>1]|0;break}else{c=0;return c|0}while(0);d[i>>1]=e|2;e=a+10|0;g=c&255;i=g&247;if((i|0)!=(h[e>>0]|0))Xxc(a,i)|0;if((g&8|0?f[a+16>>2]&1|0:0)?Yxc(a)|0:0){c=0;return c|0}Zxc(a)}if((b[e>>0]|0)!=(c&-9)<<24>>24){c=0;return c|0}c=f[a+16>>2]|0;return c|0}function Wxc(a){a=a|0;var b=0,c=0;c=a+12|0;b=(f[a>>2]|0)+(f[c>>2]|0)|0;if((b|0)<1)if(!(d[a+8>>1]&16)){c=0;return c|0}else b=1;if(dyc(a,b,1)|0){c=7;return c|0}Mrd((f[a+16>>2]|0)+(f[c>>2]|0)|0,0,f[a>>2]|0)|0;f[c>>2]=(f[c>>2]|0)+(f[a>>2]|0);c=a+8|0;d[c>>1]=d[c>>1]&-16897;c=0;return c|0}function Xxc(a,b){a=a|0;b=b|0;if(!(d[a+8>>1]&2)){b=0;return b|0}if((h[a+10>>0]|0|0)==(b|0)){b=0;return b|0}b=jyc(a,b&255)|0;return b|0}function Yxc(a){a=a|0;var b=0,c=0;c=a+8|0;b=j[c>>1]|0;do if(b&18|0){if(b&16384|0?Wxc(a)|0:0){c=7;return c|0}if(f[a+24>>2]|0?(f[a+16>>2]|0)==(f[a+20>>2]|0):0)break;a=iyc(a)|0;if(a|0){c=a;return c|0}}while(0);d[c>>1]=d[c>>1]&-4097;c=0;return c|0}function Zxc(a){a=a|0;if((d[a+8>>1]&514)!=2)return;iyc(a)|0;return}function _xc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0;if(!($xc(a,32)|0)){g=a+16|0;ayc(f[g>>2]|0,a);g=(udd(f[g>>2]|0)|0)&1073741823;f[a+12>>2]=g;b[a+10>>0]=1;g=a+8|0;h=d[g>>1]|514;d[g>>1]=e<<24>>24==0?h:h&-45;Xxc(a,c&255)|0;e=0;return e|0}else{b[a+10>>0]=0;h=7;return h|0}return 0}function $xc(a,b){a=a|0;b=b|0;if((f[a+24>>2]|0)<(b|0)){b=dyc(a,b,0)|0;return b|0}else{f[a+16>>2]=f[a+20>>2];b=a+8|0;d[b>>1]=d[b>>1]&45;b=0;return b|0}return 0}function ayc(a,c){a=a|0;c=c|0;var e=0.0,g=0,h=0,i=0,j=0;j=t;t=t+32|0;i=j;h=j+8|0;g=c+8|0;if(d[g>>1]&4){i=c;byc(f[i>>2]|0,f[i+4>>2]|0,a);t=j;return}fxc(h,0,a,32,0);if(!(d[g>>1]&32))e=+p[c>>3];else{g=c;e=+((f[g>>2]|0)>>>0)+4294967296.0*+(f[g+4>>2]|0)}p[i>>3]=e;cyc(h,118551,i);b[a+(f[h+16>>2]|0)>>0]=0;t=j;return}function byc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=t;t=t+32|0;g=i;h=(c|0)<0;j=(a|0)==0&(c|0)==-2147483648;e=wrd(0,0,a|0,c|0)|0;b[g+21>>0]=0;f=20;e=h?(j?0:e):a;a=h?(j?-2147483648:G):c;while(1){j=e;e=Drd(e|0,a|0,10,0)|0;k=a;a=G;l=Brd(e|0,a|0,10,0)|0;l=wrd(j|0,k|0,l|0,G|0)|0;c=f+-1|0;b[g+f>>0]=l&255|48;if(!(k>>>0>0|(k|0)==0&j>>>0>9))break;else f=c}if(!h){l=c;k=l+1|0;k=g+k|0;l=21-l|0;Krd(d|0,k|0,l|0)|0;t=i;return}b[g+c>>0]=45;l=f+-2|0;k=l+1|0;k=g+k|0;l=21-l|0;Krd(d|0,k|0,l|0)|0;t=i;return}function cyc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;f[e>>2]=c;gxc(a,b,e);t=d;return}function dyc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=a+24|0;e=(f[l>>2]|0)>0;do if((c|0)!=0&e?(j=a+16|0,i=f[j>>2]|0,h=a+20|0,(i|0)==(f[h>>2]|0)):0){e=f[a+32>>2]|0;g=((b|0)<0)<<31>>31;if(e|0){e=eyc(e,i,b,g)|0;f[h>>2]=e;f[j>>2]=e;g=0;break}e=Pxc(i,b,g)|0;f[h>>2]=e;if(!e){qxc(f[j>>2]|0);e=f[h>>2]|0;g=e}else g=e;f[j>>2]=g;g=0}else k=9;while(0);if((k|0)==9){g=a+32|0;if(e){e=a+20|0;oxc(f[g>>2]|0,f[e>>2]|0)}else e=a+20|0;k=jxc(f[g>>2]|0,b,((b|0)<0)<<31>>31)|0;f[e>>2]=k;g=c;h=e;e=k}if(!e){fyc(a);f[a+16>>2]=0;f[l>>2]=0;a=7;return a|0}k=txc(f[a+32>>2]|0,e)|0;f[l>>2]=k;if(g|0?(m=f[a+16>>2]|0,m|0):0)Krd(f[h>>2]|0,m|0,f[a+12>>2]|0)|0;c=a+8|0;e=d[c>>1]|0;if(!(e&1024))g=a+16|0;else{g=a+16|0;Hd[f[a+36>>2]&1023](f[g>>2]|0);e=d[c>>1]|0}f[g>>2]=f[h>>2];d[c>>1]=e&-7169;a=0;return a|0}function eyc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=Oxc(a,b,c,d)|0;if(c|0)return c|0;nxc(a,b);return c|0}function fyc(a){a=a|0;var b=0;b=a+8|0;if(!(d[b>>1]&9216)){d[b>>1]=1;return}else{gyc(a);return}}function gyc(a){a=a|0;var b=0,c=0;c=a+8|0;b=d[c>>1]|0;if(b&8192){hyc(a,f[a>>2]|0)|0;b=d[c>>1]|0}if(!(b&1024)){d[c>>1]=1;return}Hd[f[a+36>>2]&1023](f[a+16>>2]|0);d[c>>1]=1;return}function hyc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0,i=0;i=t;t=t+80|0;h=i+40|0;c=i;e=h+12|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;e=c;g=e+40|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(g|0));d[c+8>>1]=1;e=a+32|0;f[c+32>>2]=f[e>>2];f[h>>2]=c;f[h+8>>2]=a;f[h+4>>2]=b;Hd[f[b+20>>2]&1023](h);if((f[a+24>>2]|0)>0)oxc(f[e>>2]|0,f[a+20>>2]|0);e=a;g=e+40|0;do{f[e>>2]=f[c>>2];e=e+4|0;c=c+4|0}while((e|0)<(g|0));t=i;return f[h+20>>2]|0}function iyc(a){a=a|0;var c=0,e=0;c=a+12|0;if(dyc(a,(f[c>>2]|0)+3|0,1)|0){c=7;return c|0}e=a+16|0;b[(f[e>>2]|0)+(f[c>>2]|0)>>0]=0;b[(f[e>>2]|0)+((f[c>>2]|0)+1)>>0]=0;b[(f[e>>2]|0)+((f[c>>2]|0)+2)>>0]=0;c=a+8|0;d[c>>1]=d[c>>1]|512;c=0;return c|0}function jyc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;u=a+10|0;g=c<<24>>24==1;if(!(g|(b[u>>0]|0)==1)){if(Yxc(a)|0){u=7;return u|0}e=f[a+16>>2]|0;g=e+(f[a+12>>2]&-2)|0;while(1){if(e>>>0>=g>>>0)break;t=b[e>>0]|0;a=e+1|0;b[e>>0]=b[a>>0]|0;b[a>>0]=t;e=e+2|0}b[u>>0]=c;u=0;return u|0}t=a+12|0;e=f[t>>2]|0;if(g){e=e&-2;f[t>>2]=e;i=Hrd(e|0,((e|0)<0)<<31>>31|0,1)|0;i=i|1;j=G}else{i=Hrd(e|0,((e|0)<0)<<31>>31|0,1)|0;i=vrd(i|0,G|0,2,0)|0;j=G}s=a+16|0;g=f[s>>2]|0;p=g+e|0;r=a+32|0;q=jxc(f[r>>2]|0,i,j)|0;if(!q){u=7;return u|0}a:do switch(b[u>>0]|0){case 1:{b:do if(c<<24>>24==2){e=q;while(1){if(g>>>0>=p>>>0)break b;i=g+1|0;n=b[g>>0]|0;g=n&255;if((n&255)>191){l=h[1360+(g+-192)>>0]|0;g=i;while(1){if((g|0)==(p|0)){g=p;break}i=b[g>>0]|0;if((i&-64)<<24>>24!=-128)break;l=l<<6|i&63;g=g+1|0}if(!((l&-2|0)==65534|(l>>>0<128|(l&-2048|0)==55296)))if(l>>>0<65536)o=25;else{j=l+-65536|0;b[e>>0]=j>>>10&192|l>>>10&63;b[e+1>>0]=j>>>18&3|216;b[e+2>>0]=l;j=e+3|0;k=4;i=l>>>8&3|220}else{l=65533;o=25}}else{l=g;g=i;o=25}if((o|0)==25){o=0;b[e>>0]=l;j=e+1|0;k=2;i=l>>>8}b[j>>0]=i;e=e+k|0}}else{e=q;while(1){if(g>>>0>=p>>>0)break b;i=g+1|0;n=b[g>>0]|0;g=n&255;if((n&255)>191){m=h[1360+(g+-192)>>0]|0;g=i;while(1){if((g|0)==(p|0)){g=p;break}i=b[g>>0]|0;if((i&-64)<<24>>24!=-128)break;m=m<<6|i&63;g=g+1|0}if(!((m&-2|0)==65534|(m>>>0<128|(m&-2048|0)==55296)))if(m>>>0<65536)o=36;else{n=m+-65536|0;b[e>>0]=n>>>18&3|216;b[e+1>>0]=n>>>10&192|m>>>10&63;n=m;j=4;k=e+2|0;l=3;i=m>>>8&3|220}else{m=65533;o=36}}else{m=g;g=i;o=36}if((o|0)==36){o=0;n=m;j=2;k=e;l=1;i=m>>>8}b[k>>0]=i;b[e+l>>0]=n;e=e+j|0}}while(0);f[t>>2]=e-q;b[e>>0]=0;e=e+1|0;break}case 2:{e=q;while(1){if(g>>>0>=p>>>0){o=60;break a}j=h[g>>0]|0;k=g+2|0;o=h[g+1>>0]|0;i=o<<8|j;if(k>>>0<p>>>0&(o&248|0)==216){i=(i<<10&983040)+65536|j<<10&64512|h[k>>0]|h[g+3>>0]<<8&768;g=g+4|0}else g=k;if(i>>>0<128){k=e;j=1}else{if(i>>>0<2048){n=e;j=2;k=1;l=192;m=31}else{if(i>>>0<65536){l=e;j=3;k=2;m=1;n=224;o=15}else{b[e>>0]=i>>>18&7|240;l=e+1|0;j=4;k=3;m=2;n=128;o=63}b[l>>0]=i>>>12&o|n;n=e+m|0;l=128;m=63}b[n>>0]=i>>>6&m|l;k=e+k|0;i=i&63|128}b[k>>0]=i;e=e+j|0}}default:{e=q;while(1){if(g>>>0>=p>>>0){o=60;break a}o=h[g>>0]|0;i=g+2|0;j=h[g+1>>0]|0;k=o<<8|j;if(i>>>0<p>>>0&(o&248|0)==216){o=g+4|0;g=(k<<10&983040)+65536|j<<10&64512|h[g+3>>0]|h[i>>0]<<8&768}else{o=i;g=k}if(g>>>0<128){j=e;i=1}else{if(g>>>0<2048){m=e;i=2;j=1;k=192;l=31}else{if(g>>>0<65536){k=e;i=3;j=2;l=1;m=224;n=15}else{b[e>>0]=g>>>18&7|240;k=e+1|0;i=4;j=3;l=2;m=128;n=63}b[k>>0]=g>>>12&n|m;m=e+l|0;k=128;l=63}b[m>>0]=g>>>6&l|k;j=e+j|0;g=g&63|128}b[j>>0]=g;e=e+i|0;g=o}}}while(0);if((o|0)==60)f[t>>2]=e-q;b[e>>0]=0;t=a+8|0;p=d[t>>1]&-32707|514;kyc(a);d[t>>1]=p;b[u>>0]=c;f[s>>2]=q;f[a+20>>2]=q;u=txc(f[r>>2]|0,q)|0;f[a+24>>2]=u;u=0;return u|0}function kyc(a){a=a|0;if((d[a+8>>1]&9216)==0?(f[a+24>>2]|0)==0:0)return;lyc(a);return}function lyc(a){a=a|0;var b=0;if(d[a+8>>1]&9216)gyc(a);b=a+24|0;if(!(f[b>>2]|0)){b=a+16|0;f[b>>2]=0;return}oxc(f[a+32>>2]|0,f[a+20>>2]|0);f[b>>2]=0;b=a+16|0;f[b>>2]=0;return}function myc(a){a=a|0;return +(+nyc(a))}function nyc(a){a=a|0;var b=0,c=0.0;b=j[a+8>>1]|0;if(b&8|0){c=+p[a>>3];return +c}if(b&36|0){b=a;c=+((f[b>>2]|0)>>>0)+4294967296.0*+(f[b+4>>2]|0);return +c}if(!(b&18)){c=0.0;return +c}c=+oyc(a);return +c}function oyc(a){a=a|0;var c=0,d=0;d=t;t=t+16|0;c=d;p[c>>3]=0.0;pyc(f[a+16>>2]|0,c,f[a+12>>2]|0,b[a+10>>0]|0)|0;t=d;return +(+p[c>>3])}function pyc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var f=0,g=0.0,i=0.0,j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,u=0;p[c>>3]=0.0;if(!d){c=0;return c|0}f=e&255;if(e<<24>>24==1){f=a;q=1;n=1;e=d}else{e=d&-2;d=3-f|0;while(1){if((d|0)>=(e|0)){e=1;break}if(b[a+d>>0]|0){e=-100;break}d=d+2|0}f=a+(f&1)|0;q=2;n=e;e=d^1}u=a+e|0;while(1){if(f>>>0>=u>>>0){e=0;s=68;break}e=b[f>>0]|0;if(!(b[1424+(e&255)>>0]&1))break;f=f+q|0}if((s|0)==68)return e|0;switch(e<<24>>24){case 45:{t=-1;f=f+q|0;break}case 43:{t=1;f=f+q|0;break}default:t=1}d=0;j=0;e=0;a=0;a:while(1){k=e;do{if(f>>>0>=u>>>0){r=f;q=1;l=0;m=1;break a}e=b[f>>0]|0;if(((e&255)+-48|0)>>>0>=10){s=25;break a}a=Brd(k|0,a|0,10,0)|0;k=(e<<24>>24)+-48|0;k=vrd(a|0,G|0,k|0,((k|0)<0)<<31>>31|0)|0;a=G;f=f+q|0;d=d+1|0}while(!((a|0)>214748364|(a|0)==214748364&k>>>0>3435973834));e=j;while(1){if(f>>>0>=u>>>0)break;if(((h[f>>0]|0)+-48|0)>>>0>=10)break;e=e+1|0;f=f+q|0}j=e;e=k}b:do if((s|0)==25){c:do if(e<<24>>24==46){l=n+1|0;while(1){f=f+q|0;if(f>>>0>=u>>>0){e=l;o=j;break c}e=b[f>>0]|0;if(((e&255)+-48|0)>>>0>=10){e=l;o=j;break c}r=(a|0)<214748364|(a|0)==214748364&k>>>0<3435973835;o=Brd(k|0,a|0,10,0)|0;s=(e<<24>>24)+-48|0;s=vrd(o|0,G|0,s|0,((s|0)<0)<<31>>31|0)|0;d=d+(r&1)|0;j=j+(r<<31>>31)|0;a=r?G:a;k=r?s:k}}else{e=n;o=j}while(0);if(f>>>0<u>>>0){d:do switch(b[f>>0]|0){case 69:case 101:{f=f+q|0;n=e+1|0;if(f>>>0>=u>>>0){r=f;q=0;l=0;m=1;j=o;break b}switch(b[f>>0]|0){case 45:{m=-1;f=f+q|0;break}case 43:{m=1;f=f+q|0;break}default:m=1}j=0;l=0;while(1){if(f>>>0>=u>>>0){e=n;break d}e=b[f>>0]|0;if(((e&255)+-48|0)>>>0>=10){e=n;break d}j=1;l=(l|0)<1e4?(l*10|0)+-48+(e<<24>>24)|0:1e4;f=f+q|0}}default:{j=1;l=0;m=1}}while(0);while(1){if(f>>>0>=u>>>0){r=f;q=j;n=e;j=o;break b}if(!(b[1424+(h[f>>0]|0)>>0]&1)){r=f;q=j;n=e;j=o;break b}f=f+q|0}}else{r=f;q=1;l=0;m=1;n=e;j=o}}while(0);e=(V(l,m)|0)+j|0;o=(e|0)<0;do if((k|0)==0&(a|0)==0)g=(t|0)<0?-0.0:0.0;else{l=(e>>31|1|0)>0;m=o?0-e|0:e;e=a;a=k;while(1){if((m|0)<=0){s=53;break}if(!l){f=zrd(a|0,e|0,10,0)|0;j=G;s=Brd(f|0,j|0,10,0)|0;s=wrd(a|0,e|0,s|0,G|0)|0;if((s|0)==0&(G|0)==0)e=j;else{s=55;break}}else{if((e|0)>214748364|(e|0)==214748364&a>>>0>3435973835){s=55;break}f=Brd(a|0,e|0,10,0)|0;e=G}m=m+-1|0;a=f}if((s|0)==53){t=(t|0)<0;f=wrd(0,0,a|0,e|0)|0;f=t?f:a;e=t?G:e;if(!m){g=+(f>>>0)+4294967296.0*+(e|0);break}}else if((s|0)==55){t=(t|0)<0;f=wrd(0,0,a|0,e|0)|0;f=t?f:a;e=t?G:e;if((m|0)>307)if((m|0)<342){i=+qyc(m+-308|0);g=+(f>>>0)+4294967296.0*+(e|0);if(o){g=g/i/1.e+308;break}else{g=i*g*1.e+308;break}}else if(o){g=(+(f>>>0)+4294967296.0*+(e|0))*0.0;break}else{g=(+(f>>>0)+4294967296.0*+(e|0))*A;break}}i=+qyc(m);g=+(f>>>0)+4294967296.0*+(e|0);g=o?g/i:i*g}while(0);p[c>>3]=g;f=(d|0)>0;e=(q|0)!=0;if((n|0)>0&(e&(f&(r|0)==(u|0)))){c=n;return c|0}if((n|0)>1?f&(e|(n|0)==3):0){c=-1;return c|0}c=0;return c|0}function qyc(a){a=a|0;var b=0.0,c=0.0;b=1.0;c=10.0;while(1){b=(a&1|0)==0?b:c*b;a=a>>1;if(!a)break;c=c*c}return +b}function ryc(a){a=a|0;a=syc(a)|0;return a|0}function syc(a){a=a|0;var b=0;b=j[a+8>>1]|0;do if(!(b&36)){if(b&8|0){b=tyc(+p[a>>3])|0;a=G;break}if((b&18|0)!=0?(f[a+16>>2]|0)!=0:0){b=uyc(a)|0;a=G}else{a=0;b=0}}else{b=a;a=f[b+4>>2]|0;b=f[b>>2]|0}while(0);G=a;return b|0}function tyc(a){a=+a;var b=0,c=0;if(!(a<=-9223372036854775808.0))if(!(a>=9223372036854775808.0)){c=+I(a)>=1.0?(a>0.0?~~+W(+H(a/4294967296.0),4294967295.0)>>>0:~~+U((a-+(~~a>>>0))/4294967296.0)>>>0):0;b=~~a>>>0}else{c=2147483647;b=-1}else{c=-2147483648;b=0}G=c;return b|0}function uyc(a){a=a|0;var c=0,d=0,e=0;c=t;t=t+16|0;d=c;e=d;f[e>>2]=0;f[e+4>>2]=0;vyc(f[a+16>>2]|0,d,f[a+12>>2]|0,b[a+10>>0]|0)|0;a=d;G=f[a+4>>2]|0;t=c;return f[a>>2]|0}function vyc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=e&255;if(e<<24>>24==1){e=0;n=1;g=a}else{e=d&-2;d=3-g|0;while(1){if((d|0)>=(e|0)){e=0;break}if(b[a+d>>0]|0){e=1;break}d=d+2|0}n=2;g=a+(g&1)|0;d=d^1}m=a+d|0;while(1){if(g>>>0>=m>>>0){j=0;break}d=b[g>>0]|0;if(!(b[1424+(d&255)>>0]&1)){i=11;break}g=g+n|0}a:do if((i|0)==11)switch(d<<24>>24){case 45:{j=1;g=g+n|0;break a}case 43:{j=0;g=g+n|0;break a}default:{j=0;break a}}while(0);l=g;while(1){if(l>>>0>=m>>>0)break;if((b[l>>0]|0)!=48)break;l=l+n|0}k=0;a=0;i=0;while(1){d=l+k|0;if(d>>>0>=m>>>0){d=1;break}d=b[d>>0]|0;if((d+-48&255)>=10){d=0;break}o=Brd(a|0,i|0,10,0)|0;d=d<<24>>24;o=vrd(o|0,G|0,-48,-1)|0;d=vrd(o|0,G|0,d|0,((d|0)<0)<<31>>31|0)|0;k=k+n|0;a=d;i=G}p=(i|0)<0;j=(j|0)!=0;q=wrd(0,0,a|0,i|0)|0;o=c;f[o>>2]=p?(j?0:-1):j?q:a;f[o+4>>2]=p?(j?-2147483648:2147483647):j?G:i;b:do if(!((g|0)==(l|0)&(k|0)==0))if((e|0)!=0|d)d=e;else{e=k;while(1){if(!(b[1424+(h[l+e>>0]|0)>>0]&1)){d=1;break b}e=e+n|0;if((l+e|0)>>>0>=m>>>0){d=0;break}}}else d=-1;while(0);e=n*19|0;if(k>>>0<e>>>0){q=d;return q|0}if(k>>>0>e>>>0){q=c;f[q>>2]=j?0:-1;f[q+4>>2]=j?-2147483648:2147483647;q=2;return q|0}e=wyc(l,n)|0;if((e|0)<0){q=d;return q|0}else{q=c;f[q>>2]=j?0:-1;f[q+4>>2]=j?-2147483648:2147483647;return ((e|0)==0?(j?d:3):2)|0}return 0}function wyc(a,c){a=a|0;c=c|0;var d=0,e=0,f=0;d=0;e=0;while(1){f=(d|0)==0;if(!(e>>>0<18&f))break;d=a+(V(e,c)|0)|0;d=((b[d>>0]|0)-(b[118558+e>>0]|0)|0)*10|0;e=e+1|0}if(!f){f=d;return f|0}f=(b[a+(c*18|0)>>0]|0)+-56|0;return f|0}function xyc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;c=Nxc(a,c)|0;if((c|0)<=0)return;d=a+16|0;Krd((f[a+4>>2]|0)+(f[d>>2]|0)|0,b|0,c|0)|0;f[d>>2]=(f[d>>2]|0)+c;return}function yyc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;h=t;t=t+16|0;e=h+8|0;g=h;i=e;f[i>>2]=0;f[i+4>>2]=0;i=g;f[i>>2]=0;f[i+4>>2]=0;a=Ywc(a,e,g,d)|0;if(a|0){t=h;return a|0}f[b>>2]=f[e>>2];f[c>>2]=f[g>>2];t=h;return a|0}function zyc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+16|0;k=m;l=a+12|0;axc(f[l>>2]|0);switch(b|0){case 0:{d=Ayc(a,d)|0;f[c>>2]=d;if(!e){a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}h=a+312|0;b=f[h>>2]|0;i=b;if(b|0){while(1){g=f[b>>2]|0;if(!g)break;else b=g}d=a+308|0;f[b>>2]=f[d>>2];f[d>>2]=i;f[h>>2]=0}h=a+320|0;b=f[h>>2]|0;i=b;if(!b){a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}while(1){g=f[b>>2]|0;if(!g)break;else b=g}a=a+316|0;f[b>>2]=f[a>>2];f[a>>2]=i;f[h>>2]=0;a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}case 6:case 5:case 4:{f[c>>2]=0;b=a+296+(b+-4<<2)|0;f[d>>2]=f[b>>2];if(!e){a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}f[b>>2]=0;a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}case 1:case 11:{Byc(a);e=a+20|0;k=a+16|0;j=(b|0)==11;b=0;i=0;while(1){if((i|0)>=(f[e>>2]|0))break;h=f[(f[k>>2]|0)+(i<<4)+4>>2]|0;if(h){g=Dyc(Cyc(h)|0)|0;if(j)g=(g|0)/(Eyc(h)|0)|0;b=g+b|0}i=i+1|0}Fyc(a);f[c>>2]=b;f[d>>2]=0;a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}case 2:{f[k>>2]=0;Byc(a);i=a+504|0;f[i>>2]=k;j=a+20|0;e=a+16|0;h=0;while(1){if((h|0)>=(f[j>>2]|0))break;g=f[(f[e>>2]|0)+(h<<4)+12>>2]|0;a:do if(g|0){b=sd[f[40760>>2]&2047](16)|0;b=V((f[g+44>>2]|0)+(f[g+12>>2]|0)+(f[g+28>>2]|0)+(f[g+60>>2]|0)|0,b)|0;f[k>>2]=b+(f[k>>2]|0);b=Gyc(f[g+20>>2]|0)|0;f[k>>2]=(f[k>>2]|0)+b;b=Gyc(f[g+52>>2]|0)|0;f[k>>2]=(f[k>>2]|0)+b;b=Gyc(f[g+36>>2]|0)|0;f[k>>2]=(f[k>>2]|0)+b;b=Gyc(f[g+68>>2]|0)|0;f[k>>2]=(f[k>>2]|0)+b;b=g+48|0;while(1){b=f[b>>2]|0;if(!b)break;Hyc(a,f[b+8>>2]|0)}b=g+16|0;while(1){b=f[b>>2]|0;if(!b)break a;Iyc(a,f[b+8>>2]|0)}}while(0);h=h+1|0}f[i>>2]=0;Fyc(a);f[d>>2]=0;f[c>>2]=f[k>>2];a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}case 3:{f[k>>2]=0;g=a+504|0;f[g>>2]=k;b=a+4|0;while(1){b=f[b>>2]|0;if(!b)break;Jyc(a,b);nxc(a,b);b=b+8|0}f[g>>2]=0;f[d>>2]=0;f[c>>2]=f[k>>2];a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}case 12:{b=10;break}case 9:case 8:case 7:break;case 10:{f[d>>2]=0;d=a+496|0;k=f[d+4>>2]|0;if((k|0)>0|(k|0)==0&(f[d>>2]|0)>>>0>0)b=1;else{b=a+488|0;a=f[b+4>>2]|0;b=((a|0)>0|(a|0)==0&(f[b>>2]|0)>>>0>0)&1}f[c>>2]=b;a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}default:{a=1;l=f[l>>2]|0;bxc(l);t=m;return a|0}}f[k>>2]=0;j=a+20|0;h=a+16|0;g=0;while(1){if((g|0)>=(f[j>>2]|0))break;i=f[(f[h>>2]|0)+(g<<4)+4>>2]|0;if(i|0)Kyc(Cyc(i)|0,b,e,k);g=g+1|0}f[d>>2]=0;f[c>>2]=f[k>>2];a=0;l=f[l>>2]|0;bxc(l);t=m;return a|0}function Ayc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=Jzc(f[a+308>>2]|0)|0;e=Jzc(f[a+312>>2]|0)|0;c=(Jzc(f[a+316>>2]|0)|0)+c|0;d=Jzc(f[a+320>>2]|0)|0;a=a+292|0;if(!b){b=f[a>>2]|0;e=c+e|0;e=e+d|0;e=b-e|0;return e|0}f[b>>2]=(f[a>>2]|0)-c;b=f[a>>2]|0;e=c+e|0;e=e+d|0;e=b-e|0;return e|0}function Byc(a){a=a|0;if(b[a+91>>0]|0)return;Ezc(a);return}function Cyc(a){a=a|0;return f[f[a+4>>2]>>2]|0}function Dyc(a){a=a|0;var b=0,c=0;b=a+152|0;c=(f[b>>2]|0)+60+(j[a+140>>1]|0)|0;c=V(c,Dzc(f[a+212>>2]|0)|0)|0;a=c+(rxc(a)|0)|0;return a+(f[b>>2]|0)|0}function Eyc(a){a=a|0;return f[(f[a+4>>2]|0)+68>>2]|0}function Fyc(a){a=a|0;if(b[a+91>>0]|0)return;Azc(a);return}function Gyc(a){a=a|0;var b=0;if(!a){b=0;a=0;G=b;return a|0}b=sd[f[40756>>2]&2047](a)|0;a=((b|0)<0)<<31>>31;G=a;return b|0}function Hyc(a,c){a=a|0;c=c|0;if(!c)return;if(b[c+10>>0]|0)return;xzc(a,f[c+28>>2]|0);nxc(a,f[c>>2]|0);nxc(a,f[c+4>>2]|0);dzc(a,f[c+12>>2]|0);mzc(a,f[c+16>>2]|0);nxc(a,c);return}function Iyc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!b)return;if(!((a|0)!=0?(f[a+504>>2]|0)!=0:0))c=4;if((c|0)==4?(d=b+32|0,c=(f[d>>2]|0)+-1|0,f[d>>2]=c,c|0):0)return;Vyc(a,b);return}function Jyc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;e=b+116|0;Lyc(f[e>>2]|0,j[b+144>>1]<<1);c=f[b+212>>2]|0;while(1){if(!c)break;g=f[c+24>>2]|0;Myc(a,f[c>>2]|0,f[c+4>>2]|0);nxc(a,c);c=g}if((f[b+20>>2]|0)!=381479589){Lyc(f[b+100>>2]|0,d[b+16>>1]|0);nxc(a,f[b+128>>2]|0);nxc(a,f[b+192>>2]|0)}Myc(a,f[b+104>>2]|0,f[b+108>>2]|0);nxc(a,f[e>>2]|0);nxc(a,f[b+188>>2]|0);return}function Kyc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=a+184+(b+-7<<2)|0;f[d>>2]=(f[d>>2]|0)+(f[a>>2]|0);if(!c)return;f[a>>2]=0;return}function Lyc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;if(!((a|0)!=0&(b|0)!=0))return;e=a+(b*40|0)|0;g=f[a+32>>2]|0;if(f[g+504>>2]|0){b=a;do{if(f[b+24>>2]|0)nxc(g,f[b+20>>2]|0);b=b+40|0}while(b>>>0<e>>>0);return}do{b=a+8|0;if(!(d[b>>1]&9216)){c=a+24|0;if(f[c>>2]|0){oxc(g,f[a+20>>2]|0);f[c>>2]=0}}else kyc(a);d[b>>1]=128;a=a+40|0}while(a>>>0<e>>>0);return}function Myc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;if(!c)return;d=c+((d+-1|0)*20|0)|0;while(1){if(d>>>0<c>>>0)break;e=b[d+1>>0]|0;if(e<<24>>24<-6)Nyc(a,e<<24>>24,f[d+16>>2]|0);d=d+-20|0}oxc(a,c);return}function Nyc(a,b,c){a=a|0;b=b|0;c=c|0;switch(b|0){case -16:{Oyc(a,c);return}case -15:case -17:case -7:case -14:case -13:{nxc(a,c);return}case -9:{if(f[a+504>>2]|0)return;Pyc(c);return}case -8:{Qyc(a,c);return}case -11:if(!(f[a+504>>2]|0)){Ryc(c);return}else{Syc(a,c);return}case -12:{if(f[a+504>>2]|0)return;Tyc(c);return}default:return}}function Oyc(a,b){a=a|0;b=b|0;Qyc(a,f[b+4>>2]|0);oxc(a,b);return}function Pyc(a){a=a|0;var b=0;if(!a)return;b=(f[a>>2]|0)+-1|0;f[a>>2]=b;if(b|0)return;oxc(f[a+12>>2]|0,a);return}function Qyc(a,b){a=a|0;b=b|0;if(!(f[b+4>>2]&16))return;oxc(a,b);return}function Ryc(a){a=a|0;if(!a)return;kyc(a);oxc(f[a+32>>2]|0,a);return}function Syc(a,b){a=a|0;b=b|0;if(f[b+24>>2]|0)nxc(a,f[b+20>>2]|0);oxc(a,b);return}function Tyc(a){a=a|0;var b=0,c=0,d=0;b=f[a>>2]|0;d=a+12|0;c=(f[d>>2]|0)+-1|0;f[d>>2]=c;if(c|0)return;c=f[a+8>>2]|0;Uyc(b,f[a+4>>2]|0);if(c|0)sd[f[(f[c>>2]|0)+16>>2]&2047](c)|0;nxc(b,a);return}function Uyc(a,b){a=a|0;b=b|0;var c=0,d=0;d=b+8|0;c=(f[d>>2]|0)+-1|0;f[d>>2]=c;if(c|0)return;c=f[b+16>>2]|0;if(c|0)Hd[c&1023](f[b+12>>2]|0);nxc(a,b);return}function Vyc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;d=(a|0)==0;e=b+56|0;g=a+504|0;c=f[b+8>>2]|0;while(1){if(!c)break;h=f[c+20>>2]|0;if(!(!d?(f[g>>2]|0)!=0:0))i=5;if((i|0)==5?(i=0,(f[e>>2]|0)==0):0)Wyc((f[c+24>>2]|0)+24|0,f[c>>2]|0,0)|0;Xyc(a,c);c=h}Yyc(a,b);Zyc(a,b);nxc(a,f[b>>2]|0);nxc(a,f[b+20>>2]|0);_yc(a,f[b+12>>2]|0);$yc(a,f[b+24>>2]|0);azc(a,b);nxc(a,b);return}function Wyc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;i=j;d=ozc(a,b,i)|0;e=d+8|0;g=f[e>>2]|0;h=(c|0)==0;if(g|0)if(h){pzc(a,d,f[i>>2]|0);i=g;t=j;return i|0}else{f[e>>2]=c;f[d+12>>2]=b;i=g;t=j;return i|0}if(h){i=0;t=j;return i|0}e=vxc(16,0)|0;if(!e){i=c;t=j;return i|0}f[e+12>>2]=b;f[e+8>>2]=c;c=a+4|0;d=(f[c>>2]|0)+1|0;f[c>>2]=d;if((d>>>0>9?d>>>0>f[a>>2]<<1>>>0:0)?qzc(a,d<<1)|0:0){b=rzc(b)|0;f[i>>2]=(b>>>0)%((f[a>>2]|0)>>>0)|0}b=f[a+12>>2]|0;szc(a,(b|0)==0?0:b+(f[i>>2]<<3)|0,e);i=0;t=j;return i|0}function Xyc(a,b){a=a|0;b=b|0;var c=0;dzc(a,f[b+36>>2]|0);$yc(a,f[b+40>>2]|0);nxc(a,f[b+16>>2]|0);c=b+55|0;if(!((h[c>>0]|h[c+1>>0]<<8)&16)){nxc(a,b);return}nxc(a,f[b+32>>2]|0);nxc(a,b);return}function Yyc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;g=(a|0)==0;h=a+504|0;i=b+72|0;d=f[b+16>>2]|0;while(1){if(!d)break;if(!(!g?(f[h>>2]|0)!=0:0)){e=d+16|0;b=f[e>>2]|0;c=d+12|0;if(!b){b=f[c>>2]|0;Wyc((f[i>>2]|0)+56|0,f[((b|0)==0?d:b)+8>>2]|0,b)|0}else f[b+12>>2]=f[c>>2];b=f[c>>2]|0;if(b|0)f[b+16>>2]=f[e>>2]}nzc(a,f[d+28>>2]|0);nzc(a,f[d+32>>2]|0);e=f[d+4>>2]|0;nxc(a,d);d=e}return}function Zyc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;g=b+4|0;c=f[g>>2]|0;if(!c)return;e=b+42|0;b=c;c=0;while(1){if((c|0)>=(d[e>>1]|0))break;nxc(a,f[b>>2]|0);dzc(a,f[b+4>>2]|0);nxc(a,f[b+8>>2]|0);b=b+20|0;c=c+1|0}nxc(a,f[g>>2]|0);return}function _yc(a,b){a=a|0;b=b|0;if(!b)return;hzc(a,b,1);return}function $yc(a,b){a=a|0;b=b|0;if(!b)return;czc(a,b);return}function azc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!((a|0)!=0?(f[a+504>>2]|0)!=0:0))bzc(0,b)|0;d=b+60|0;if(!(f[d>>2]|0))return;c=b+56|0;b=0;while(1){if((b|0)>=(f[c>>2]|0))break;if((b|0)!=1)nxc(a,f[(f[d>>2]|0)+(b<<2)>>2]|0);b=b+1|0}nxc(a,f[d>>2]|0);return}function bzc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=b+64|0;b=f[h>>2]|0;f[h>>2]=0;g=0;a:while(1){while(1){if(!b)break a;c=f[b>>2]|0;d=b+24|0;e=f[d>>2]|0;if((c|0)==(a|0))break;c=c+384|0;f[d>>2]=f[c>>2];f[c>>2]=b;b=e}f[h>>2]=b;f[d>>2]=0;g=b;b=e}return g|0}function czc(a,b){a=a|0;b=b|0;var c=0,d=0;c=b+4|0;d=f[b>>2]|0;while(1){dzc(a,f[c>>2]|0);nxc(a,f[c+4>>2]|0);if((d|0)>1){c=c+16|0;d=d+-1|0}else break}oxc(a,b);return}function dzc(a,b){a=a|0;b=b|0;if(!b)return;ezc(a,b);return}function ezc(a,c){a=a|0;c=c|0;var d=0,e=0;e=c+4|0;do if(!(f[e>>2]&8404992)){d=f[c+12>>2]|0;if(d|0?(b[c>>0]|0)!=-79:0)ezc(a,d);d=f[c+16>>2]|0;if(d|0){ezc(a,d);break}d=c+20|0;if(f[e>>2]&2048|0){_yc(a,f[d>>2]|0);break}$yc(a,f[d>>2]|0);if(f[e>>2]&16777216|0)fzc(a,f[c+44>>2]|0)}while(0);d=f[e>>2]|0;if(d&65536){nxc(a,f[c+8>>2]|0);d=f[e>>2]|0}if(d&134217728|0)return;oxc(a,c);return}function fzc(a,b){a=a|0;b=b|0;if(!b)return;gzc(b);dzc(a,f[b+40>>2]|0);$yc(a,f[b+8>>2]|0);$yc(a,f[b+12>>2]|0);dzc(a,f[b+28>>2]|0);dzc(a,f[b+24>>2]|0);nxc(a,f[b>>2]|0);nxc(a,f[b+4>>2]|0);nxc(a,b);return}function gzc(a){a=a|0;var b=0,c=0;c=a+32|0;b=f[c>>2]|0;if(!b)return;a=a+36|0;f[b>>2]=f[a>>2];a=f[a>>2]|0;if(a|0)f[a+32>>2]=f[c>>2];f[c>>2]=0;return}function hzc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;while(1){if(!b)break;g=f[b+52>>2]|0;$yc(a,f[b+28>>2]|0);izc(a,f[b+32>>2]|0);dzc(a,f[b+36>>2]|0);$yc(a,f[b+40>>2]|0);dzc(a,f[b+44>>2]|0);$yc(a,f[b+48>>2]|0);dzc(a,f[b+60>>2]|0);d=f[b+64>>2]|0;if(d|0)jzc(a,d);d=f[b+72>>2]|0;if(d|0)kzc(a,d);d=b+68|0;while(1){e=f[d>>2]|0;if(!e)break;gzc(e)}if(c|0)oxc(a,b);b=g;c=1}return}function izc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;if(!c)return;g=c+8|0;h=0;while(1){if((h|0)>=(f[c>>2]|0))break;d=f[g+4>>2]|0;if(d|0)oxc(a,d);nxc(a,f[g+8>>2]|0);d=f[g+12>>2]|0;if(d|0)oxc(a,d);e=g+37|0;d=b[e>>0]|0;if(d&2){nxc(a,f[g+64>>2]|0);d=b[e>>0]|0}if(d&4)$yc(a,f[g+64>>2]|0);Iyc(a,f[g+16>>2]|0);d=f[g+20>>2]|0;if(d|0)_yc(a,d);d=f[g+44>>2]|0;if(d|0)dzc(a,d);d=f[g+48>>2]|0;if(d|0)mzc(a,d);g=g+72|0;h=h+1|0}oxc(a,c);return}function jzc(a,b){a=a|0;b=b|0;var c=0;if(!b)return;c=0;while(1){if((c|0)>=(f[b>>2]|0))break;lzc(a,b+8+(c*24|0)|0);c=c+1|0}nxc(a,b);return}function kzc(a,b){a=a|0;b=b|0;var c=0;while(1){if(!b)break;c=f[b+36>>2]|0;fzc(a,b);b=c}return}function lzc(a,b){a=a|0;b=b|0;$yc(a,f[b+4>>2]|0);_yc(a,f[b+8>>2]|0);nxc(a,f[b>>2]|0);return}function mzc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if(!b)return;d=b+4|0;c=0;while(1){e=f[b>>2]|0;if((c|0)>=(f[d>>2]|0))break;nxc(a,f[e+(c<<3)>>2]|0);c=c+1|0}nxc(a,e);oxc(a,b);return}function nzc(a,b){a=a|0;b=b|0;var c=0;if(!b)return;c=f[b+28>>2]|0;dzc(a,f[c+20>>2]|0);$yc(a,f[c+24>>2]|0);_yc(a,f[c+8>>2]|0);dzc(a,f[b+12>>2]|0);nxc(a,b);return}function ozc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=f[a+12>>2]|0;if(!d){g=0;e=a+4|0;a=a+8|0}else{g=rzc(b)|0;a=(g>>>0)%((f[a>>2]|0)>>>0)|0;g=a;e=d+(a<<3)|0;a=d+(a<<3)+4|0}d=f[e>>2]|0;a=f[a>>2]|0;if(c|0)f[c>>2]=g;while(1){if(!d){a=153828;d=10;break}if(!(wzc(f[a+12>>2]|0,b)|0)){d=10;break}d=d+-1|0;a=f[a>>2]|0}if((d|0)==10)return a|0;return 0}function pzc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;g=f[b+4>>2]|0;d=f[b>>2]|0;if(!g){f[a+8>>2]=d;e=d;h=d}else{f[g>>2]=d;h=f[b>>2]|0;e=h}if(e|0)f[e+4>>2]=g;d=f[a+12>>2]|0;if(d|0){e=d+(c<<3)+4|0;if((f[e>>2]|0)==(b|0))f[e>>2]=h;c=d+(c<<3)|0;f[c>>2]=(f[c>>2]|0)+-1}qxc(b);b=a+4|0;c=(f[b>>2]|0)+-1|0;f[b>>2]=c;if(c|0)return;vzc(a);return}function qzc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;b=b<<3>>>0>1024?128:b;if((b|0)==(f[a>>2]|0)){a=0;return a|0}tzc();d=vxc(b<<3,0)|0;uzc();if(!d){a=0;return a|0}e=a+12|0;qxc(f[e>>2]|0);f[e>>2]=d;e=rxc(d)|0;c=e>>>3;f[a>>2]=c;Mrd(d|0,0,e&-8|0)|0;e=a+8|0;b=f[e>>2]|0;f[e>>2]=0;while(1){if(!b){b=1;break}g=((rzc(f[b+12>>2]|0)|0)>>>0)%(c>>>0)|0;e=f[b>>2]|0;szc(a,d+(g<<3)|0,b);b=e}return b|0}function rzc(a){a=a|0;var c=0,d=0;c=0;while(1){d=b[a>>0]|0;if(!(d<<24>>24))break;a=a+1|0;c=V(c+(h[1680+(d&255)>>0]|0)|0,-1640531535)|0}return c|0}function szc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;do if(b|0){d=f[b>>2]|0;if(!d){f[b>>2]=1;f[b+4>>2]=c;break}g=b+4|0;e=f[g>>2]|0;f[b>>2]=d+1;f[g>>2]=c;if(e|0){f[c>>2]=e;g=e+4|0;f[c+4>>2]=f[g>>2];e=f[g>>2]|0;f[((e|0)==0?a+8|0:e)>>2]=c;f[g>>2]=c;return}}while(0);a=a+8|0;b=f[a>>2]|0;f[c>>2]=b;if(b|0)f[b+4>>2]=c;f[c+4>>2]=0;g=a;f[g>>2]=c;return}function tzc(){var a=0;a=f[38456]|0;if(!a)return;Gd[a&7]();return}function uzc(){var a=0;a=f[38455]|0;if(!a)return;Gd[a&7]();return}function vzc(a){a=a|0;var b=0,c=0;c=a+8|0;b=f[c>>2]|0;f[c>>2]=0;c=a+12|0;qxc(f[c>>2]|0);f[c>>2]=0;f[a>>2]=0;while(1){if(!b)break;c=f[b>>2]|0;qxc(b);b=c}f[a+4>>2]=0;return}function wzc(a,c){a=a|0;c=c|0;var d=0,e=0;e=a;while(1){a=b[e>>0]|0;d=b[c>>0]|0;if(a<<24>>24==d<<24>>24){if(!(a<<24>>24)){a=0;c=6;break}}else{a=(h[1680+(a&255)>>0]|0)-(h[1680+(d&255)>>0]|0)|0;if(a|0){c=6;break}}e=e+1|0;c=c+1|0}if((c|0)==6)return a|0;return 0}function xzc(a,b){a=a|0;b=b|0;var c=0;while(1){if(!b)break;c=f[b+40>>2]|0;dzc(a,f[b+20>>2]|0);$yc(a,f[b+24>>2]|0);_yc(a,f[b+8>>2]|0);mzc(a,f[b+28>>2]|0);yzc(a,f[b+32>>2]|0);izc(a,f[b+16>>2]|0);nxc(a,f[b+36>>2]|0);nxc(a,b);b=c}return}function yzc(a,b){a=a|0;b=b|0;if(!b)return;zzc(a,b);return}function zzc(a,b){a=a|0;b=b|0;var c=0;do{c=b;b=f[b+16>>2]|0;$yc(a,f[c>>2]|0);dzc(a,f[c+4>>2]|0);$yc(a,f[c+8>>2]|0);dzc(a,f[c+12>>2]|0);nxc(a,f[c+24>>2]|0);nxc(a,c)}while((b|0)!=0);return}function Azc(a){a=a|0;var b=0,c=0,d=0;d=a+20|0;b=a+16|0;a=0;while(1){if((a|0)>=(f[d>>2]|0))break;c=f[(f[b>>2]|0)+(a<<4)+4>>2]|0;if(c|0)Bzc(c);a=a+1|0}return}function Bzc(a){a=a|0;var c=0,d=0;if(!(b[a+9>>0]|0))return;d=a+12|0;c=(f[d>>2]|0)+-1|0;f[d>>2]=c;if(c|0)return;Czc(a);return}function Czc(a){a=a|0;bxc(f[(f[a+4>>2]|0)+60>>2]|0);b[a+10>>0]=0;return}function Dzc(a){a=a|0;return sd[f[40836>>2]&2047](f[a+44>>2]|0)|0}function Ezc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;g=a+20|0;h=a+16|0;e=0;c=1;while(1){if((e|0)>=(f[g>>2]|0))break;d=f[(f[h>>2]|0)+(e<<4)+4>>2]|0;if((d|0)!=0?(b[d+9>>0]|0)!=0:0){Fzc(d);c=0}e=e+1|0}b[a+91>>0]=c;return}function Fzc(a){a=a|0;var c=0;if(!(b[a+9>>0]|0))return;c=a+12|0;f[c>>2]=(f[c>>2]|0)+1;if(b[a+10>>0]|0)return;Gzc(a);return}function Gzc(a){a=a|0;var c=0,d=0;c=a+4|0;if(!(Hzc(f[(f[c>>2]|0)+60>>2]|0)|0)){f[(f[c>>2]|0)+4>>2]=f[a>>2];b[a+10>>0]=1;return}c=a+24|0;d=c;while(1){d=f[d>>2]|0;if(!d)break;if(b[d+10>>0]|0)Czc(d);d=d+24|0}Izc(a);while(1){c=f[c>>2]|0;if(!c)break;if(f[c+12>>2]|0)Izc(c);c=c+24|0}return}function Hzc(a){a=a|0;if(!a){a=0;return a|0}a=sd[f[40796>>2]&2047](a)|0;return a|0}function Izc(a){a=a|0;var c=0;c=a+4|0;axc(f[(f[c>>2]|0)+60>>2]|0);f[(f[c>>2]|0)+4>>2]=f[a>>2];b[a+10>>0]=1;return}function Jzc(a){a=a|0;var b=0;b=0;while(1){if(!a)break;b=b+1|0;a=f[a>>2]|0}return b|0}function Kzc(a){a=a|0;var b=0,c=0,d=0;if(Lzc()|0){d=0;return d|0}c=Mzc(2)|0;axc(c);d=(a|0)==0;b=153844;while(1){b=f[b>>2]|0;if(d|(b|0)==0)break;if(!(ncd(a,f[b+16>>2]|0)|0))break;b=b+12|0}bxc(c);d=b;return d|0}function Lzc(){var a=0,c=0,d=0,e=0,g=0;if(f[10230]|0){Nzc();g=0;return g|0}c=Ozc()|0;if(c|0){g=c;return g|0}g=Mzc(2)|0;axc(g);f[10232]=1;if((f[10233]|0)==0?(d=Pzc()|0,(d|0)!=0):0)a=d;else e=6;do if((e|0)==6){f[10233]=1;if((f[10236]|0)==0?(e=Mzc(1)|0,f[10236]=e,!((e|0)!=0|(b[40716]|0)==0)):0){a=7;break}f[10235]=(f[10235]|0)+1;bxc(g);axc(f[10236]|0);if(!(f[10231]|f[10230])){f[10231]=1;c=153848;d=c+92|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(d|0));Qzc();if(!((f[10234]|0)==0?(a=Rzc()|0,(a|0)!=0):0)){f[10234]=1;a=Szc()|0;if(!a){Tzc(f[10224]|0,f[10225]|0,f[10226]|0);Nzc();f[10230]=1;a=0}}f[10231]=0}else a=0;bxc(f[10236]|0);axc(g);e=f[10235]|0;f[10235]=e+-1;if((e|0)<2){Uzc(f[10236]|0);f[10236]=0}bxc(g);g=a;return g|0}while(0);bxc(g);g=a;return g|0}function Mzc(a){a=a|0;if(!(b[40716]|0)){a=0;return a|0}a=sd[f[40784>>2]&2047](a)|0;return a|0}function Nzc(){return}function Ozc(){var a=0,c=0;if(f[10196]|0){a=f[10194]|0;a=rd[a&15]()|0;Nzc();return a|0}c=(b[40716]|0)==0;a=c?78036:78072;f[10194]=c?9:11;f[10195]=f[a+4>>2];f[10197]=f[a+12>>2];f[10198]=f[a+16>>2];f[10199]=f[a+20>>2];f[10200]=f[a+24>>2];f[10201]=f[a+28>>2];f[10202]=f[a+32>>2];Nzc();f[10196]=f[a+8>>2];a=f[10194]|0;a=rd[a&15]()|0;Nzc();return a|0}function Pzc(){var a=0;if(!(f[10186]|0))ZBc();f[37666]=0;f[37667]=0;f[37668]=0;f[37669]=0;f[37670]=0;f[37671]=0;f[37672]=0;f[37673]=0;a=Mzc(3)|0;f[37666]=a;if((f[10224]|0)==0|(f[10225]|0)<512|(f[10226]|0)<1){f[10224]=0;f[10225]=0}a=sd[f[40764>>2]&2047](f[10193]|0)|0;if(!a)return a|0;f[37666]=0;f[37667]=0;f[37668]=0;f[37669]=0;f[37670]=0;f[37671]=0;f[37672]=0;f[37673]=0;return a|0}function Qzc(){FCc();GCc();HCc();ICc(2704,66);return}function Rzc(){var a=0;a=f[10205]|0;if(!a){XBc();a=f[10205]|0}return sd[a&2047](f[10204]|0)|0}function Szc(){var a=0;a=Vzc(10)|0;if(!a){a=7;return a|0}qxc(a);Wzc()|0;a=0;return a|0}function Tzc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;if(!(f[38443]|0))return;h=(a|0)==0;g=h?0:c;h=h|(g|0)==0?0:b&-8;f[38446]=h;f[38453]=g;f[38447]=g;if((g|0)>90)c=10;else c=((g|0)/10|0)+1|0;f[38448]=c;f[38449]=a;f[38452]=0;f[38454]=0;e=V(g,h)|0;d=a;c=g;b=0;while(1){if(!c)break;f[d>>2]=b;f[38452]=d;g=d;d=d+h|0;c=c+-1|0;b=g}f[38450]=a+e;return}function Uzc(a){a=a|0;if(!a)return;Hd[f[40788>>2]&1023](a);return}function Vzc(a){a=a|0;if((a|0)<1|(Lzc()|0)!=0){a=0;return a|0}a=vxc(a,((a|0)<0)<<31>>31)|0;return a|0}function Wzc(){var a=0;a=0;while(1){if((a|0)==4)break;Xzc(1936+(a*88|0)|0,(a|0)==0&1)|0;a=a+1|0}a=Mzc(11)|0;f[38485]=a;return 0}function Xzc(a,b){a=a|0;b=b|0;var c=0,d=0;c=Lzc()|0;if(c|0){a=c;return a|0}d=Mzc(2)|0;axc(d);Yzc(a);c=f[38461]|0;if((b|0)!=0|(c|0)==0){f[a+12>>2]=c;c=153844}else{c=c+12|0;f[a+12>>2]=f[c>>2]}f[c>>2]=a;bxc(d);a=0;return a|0}function Yzc(a){a=a|0;var b=0,c=0;if(!a)return;b=f[38461]|0;if((b|0)==(a|0)){f[38461]=f[a+12>>2];return}if(!b)return;while(1){c=f[b+12>>2]|0;if((c|0)!=(a|0)&(c|0)!=0)b=c;else break}if((c|0)!=(a|0))return;f[b+12>>2]=f[a+12>>2];return}function Zzc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;x=t;t=t+528|0;k=x;o=x+524|0;r=x+520|0;s=x+516|0;j=d&1048320;w=d&8;m=d&4;h=d&1;n=d&2;a:do if(!m)v=0;else{g=j&1048575;b:do if((g|0)>=16384)if((g|0)<524288)switch(g|0){case 16384:{v=1;break a}default:break b}else switch(g|0){case 524288:{v=1;break a}default:break b}else switch(g|0){case 2048:{v=1;break a}default:{}}while(0);v=0}while(0);q=f[38486]|0;if((q|0)!=(Zdd()|0)){q=Zdd()|0;f[38486]=q;$Ac(0,0)}g=c;i=g+52|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(i|0));q=(j|0)==256;if(!q)if(!b){g=YAc(f[a+8>>2]|0,k)|0;if(!g)g=-1;else{c=g;t=x;return c|0}}else{k=b;g=-1}else{g=rBc(b,d)|0;if(!g){g=XAc(12,0)|0;if(!g){c=7;t=x;return c|0}else{i=g;g=-1}}else{i=g;g=f[g>>2]|0}f[c+28>>2]=i;k=b}l=(n|0)!=0;i=n|m<<4|d<<3&128|163840;c:do if((g|0)<0){g=sBc(k,d,o,r,s)|0;if(g|0){c=g;t=x;return c|0}j=f[o>>2]|0;g=PAc(k,i,j)|0;do if((g|0)<0){if((v?(o=Xbd()|0,(f[o>>2]|0)==13):0)?(td[f[2316>>2]&1023](k,0)|0)!=0:0)d=1544;else{o=Xbd()|0;if(l&(f[o>>2]|0)!=21?(p=PAc(k,i&163968,j)|0,(p|0)>=0):0){d=d&-8|1;h=1;g=p;break}else d=0}w=KAc(QAc(40020)|0,118652,k,40020)|0;d=(d|0)==0?w:d;break c}while(0);if(!((j|0)==0|(d&526336|0)==0))tBc(g,f[r>>2]|0,f[s>>2]|0);i=d;u=26}else{i=d;u=26}while(0);if((u|0)==26){if(e|0)f[e>>2]=i;d=f[c+28>>2]|0;if(d|0){f[d>>2]=g;f[d+4>>2]=i&3}if(w|0)sd[f[2484>>2]&2047](k)|0;d=w<<2;d=(h|0)==0?d:d|2;d=q?d:d|128;d=uBc(a,g,c,b,(v?d|8:d)|i&64)|0}if(!d){c=0;t=x;return c|0}qxc(f[c+28>>2]|0);c=d;t=x;return c|0}function _zc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if((sd[f[2484>>2]&2047](b)|0)==-1){d=Xbd()|0;if((f[d>>2]|0)==2){d=5898;t=e;return d|0}KAc(2570,118756,b,40159)|0;d=2570;t=e;return d|0}if(!(c&1)){d=0;t=e;return d|0}if(!(td[f[2496>>2]&1023](b,d)|0)){if(!(gBc(f[d>>2]|0)|0))a=0;else{KAc(1290,119014,b,40169)|0;a=1290}JAc(0,f[d>>2]|0,40171)}else a=0;d=a;t=e;return d|0}function $zc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=t;t=t+80|0;a=e;if(c|0){c=(td[f[2316>>2]&1023](b,6)|0)==0&1;f[d>>2]=c;t=e;return 0}if(!(td[f[2340>>2]&1023](b,a)|0))a=((f[a+36>>2]|0)>0?1:(f[a+12>>2]&61440|0)!=32768)&1;else a=0;f[d>>2]=a;t=e;return 0}function aAc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=t;t=t+80|0;m=p;n=m+12|0;o=d+-1|0;a=0;h=0;a:while(1){do if(!(td[f[2616>>2]&1023](c,m)|0))if((f[n>>2]&61440|0)==40960){l=h+1|0;if(!a){a=Vzc(d)|0;if(!a){a=0;g=7;break a}}else if((h|0)>98?(g=QAc(40352)|0,(g|0)!=0):0)break a;h=vd[f[2604>>2]&255](c,a,o)|0;if((h|0)<0){k=a;h=l;c=KAc(QAc(40358)|0,118835,c,40358)|0;i=0;break}do if((b[a>>0]|0)!=47){j=Mxc(c)|0;while(1){if((j|0)<=0)break;i=j+-1|0;if((b[c+i>>0]|0)==47)break;else j=i}i=j+h|0;if((i|0)<(d|0)){Lrd(a+j|0,a|0,h+1|0)|0;Krd(a|0,c|0,j|0)|0;h=i;c=0;break}else{c=QAc(40364)|0;break}}else c=0;while(0);b[a+h>>0]=0;k=a;h=l;i=0}else{k=c;c=0;i=1}else{l=Xbd()|0;if((f[l>>2]|0)==2){k=c;c=0;i=1}else{k=c;c=KAc(QAc(40340)|0,118844,c,40340)|0;i=1}}while(0);if(!((c|0)!=0|(k|0)==(e|0)))c=pBc(k,e,d)|0;j=(c|0)==0;if(j&(i^1))c=i?k:e;else{g=j;q=24;break}}if((q|0)==24){qxc(a);q=(h|0)!=0;q=g&q;q=q?512:c;t=p;return q|0}e=l;o=a;q=g;d=(g|0)==0;qxc(o);e=(e|0)!=0;e=d&e;q=e?512:q;t=p;return q|0}function bAc(a,b){a=a|0;b=b|0;return yc(b|0,258)|0}function cAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;FAc();a=xc()|0;if(!a){HAc();t=e;return}f[d>>2]=a;OAc(b,c,118856,d)|0;HAc();t=e;return}function dAc(a,b,c){a=a|0;b=b|0;c=c|0;return zc(b|0,c|0)|0}function eAc(a,b){a=a|0;b=b|0;wc(b|0)|0;return}function fAc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+16|0;a=g;Mrd(d|0,0,c|0)|0;e=Zdd()|0;f[38486]=e;e=PAc(119001,0,0)|0;if((e|0)<0){jd(a|0)|0;c=f[a>>2]|0;b[d>>0]=c;b[d+1>>0]=c>>8;b[d+2>>0]=c>>16;b[d+3>>0]=c>>24;d=d+4|0;c=f[38486]|0;b[d>>0]=c;b[d+1>>0]=c>>8;b[d+2>>0]=c>>16;b[d+3>>0]=c>>24;d=8;t=g;return d|0}do{if((vd[f[2388>>2]&255](e,d,c)|0)>=0)break;a=Xbd()|0}while((f[a>>2]|0)==4);JAc(0,e,40489);d=c;t=g;return d|0}function gAc(a,b){a=a|0;b=b|0;b=(b+999999|0)/1e6|0;dfd(b)|0;return b*1e6|0}function hAc(a,b){a=a|0;b=b|0;var c=0,d=0;a=t;t=t+16|0;c=a;d=c;f[d>>2]=0;f[d+4>>2]=0;jAc(0,c)|0;p[b>>3]=(+((f[c>>2]|0)>>>0)+4294967296.0*+(f[c+4>>2]|0))/864.0e5;t=a;return 0}function iAc(a,b,c){a=a|0;b=b|0;c=c|0;c=Xbd()|0;return f[c>>2]|0}function jAc(a,b){a=a|0;b=b|0;var c=0,d=0;a=t;t=t+16|0;c=a;Ic(c|0,0)|0;d=f[c>>2]|0;d=Brd(d|0,((d|0)<0)<<31>>31|0,1e3,0)|0;d=vrd(d|0,G|0,1045635584,49096)|0;c=(f[c+4>>2]|0)/1e3|0;c=vrd(d|0,G|0,c|0,((c|0)<0)<<31>>31|0)|0;f[b>>2]=c;f[b+4>>2]=G;t=a;return 0}function kAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if(!b){a=0;while(1){if((a|0)==29){a=0;break}b=f[2288+(a*12|0)+8>>2]|0;if(b|0)f[2288+(a*12|0)+4>>2]=b;a=a+1|0}return a|0}e=0;while(1){if(e>>>0>=29){a=12;d=14;break}if(!(ncd(b,f[2288+(e*12|0)>>2]|0)|0))break;e=e+1|0}if((d|0)==14)return a|0;b=2288+(e*12|0)+8|0;a=f[b>>2]|0;if(!a){a=f[2288+(e*12|0)+4>>2]|0;f[b>>2]=a}f[2288+(e*12|0)+4>>2]=(c|0)==0?a:c;c=0;return c|0}function lAc(a,b){a=a|0;b=b|0;var c=0;a=0;while(1){if(a>>>0>=29){a=0;c=6;break}if(!(ncd(b,f[2288+(a*12|0)>>2]|0)|0))break;a=a+1|0}if((c|0)==6)return a|0;c=f[2288+(a*12|0)+4>>2]|0;return c|0}function mAc(a,b){a=a|0;b=b|0;var c=0;a:do if(!b)a=-1;else{a=0;while(1){if(a>>>0>=28)break a;if(!(ncd(b,f[2288+(a*12|0)>>2]|0)|0))break a;a=a+1|0}}while(0);do{b=a;a=a+1|0;if((b|0)>=28){a=0;c=10;break}}while(!(f[2288+(a*12|0)+4>>2]|0));if((c|0)==10)return a|0;c=f[2288+(a*12|0)>>2]|0;return c|0}function nAc(a,b){a=a|0;b=b|0;return 76244}function oAc(a){a=a|0;vAc(a,0)|0;qxc(f[a+24>>2]|0);jBc(a);return 0}function pAc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;d=iBc(a,d,e,b,c)|0;a:do if((d|0)==(c|0))d=0;else{if((d|0)>=0){eBc(a,0);Mrd(b+d|0,0,c-d|0)|0;d=522;break}switch(f[a+20>>2]|0){case 6:case 5:case 34:{d=8458;break a}default:{}}d=266}while(0);return d|0}function qAc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;while(1){g=cBc(a,d,e,b,c)|0;h=(c|0)>(g|0);if(!(h&(g|0)>0))break;h=vrd(d|0,e|0,g|0,((g|0)<0)<<31>>31|0)|0;c=c-g|0;b=b+g|0;d=h;e=G}if(!h){a=0;return a|0}if((g|0)<0?(f[a+20>>2]|0)!=28:0){a=778;return a|0}eBc(a,0);a=13;return a|0}function rAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;g=f[a+40>>2]|0;h=((g|0)<0)<<31>>31;d=vrd(b|0,c|0,-1,-1)|0;d=vrd(d|0,G|0,g|0,h|0)|0;e=G;if((g|0)>0){b=Crd(d|0,e|0,g|0,h|0)|0;b=wrd(d|0,e|0,b|0,G|0)|0;c=G}if(!(hBc(f[a+12>>2]|0,b,c)|0)){a=0;return a|0}h=Xbd()|0;eBc(a,f[h>>2]|0);KAc(1546,118682,f[a+32>>2]|0,37663)|0;a=1546;return a|0}function sAc(a,b){a=a|0;b=b|0;var c=0,e=0;e=t;t=t+16|0;c=e;if(gBc(f[a+12>>2]|0)|0){c=Xbd()|0;eBc(a,f[c>>2]|0);KAc(1034,118990,f[a+32>>2]|0,37618)|0;a=1034;t=e;return a|0}b=a+18|0;if(!(d[b>>1]&8)){a=0;t=e;return a|0}if(!(td[f[2496>>2]&1023](f[a+32>>2]|0,c)|0)){gBc(f[c>>2]|0)|0;JAc(a,f[c>>2]|0,37632)}d[b>>1]=d[b>>1]&-9;a=0;t=e;return a|0}function tAc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=t;t=t+80|0;c=d;if(!(td[f[2352>>2]&1023](f[a+12>>2]|0,c)|0)){a=f[c+36>>2]|0;e=(a|0)==1;c=b;f[c>>2]=e?0:a;f[c+4>>2]=e?0:((a|0)<0)<<31>>31;c=0;t=d;return c|0}else{e=Xbd()|0;eBc(a,f[e>>2]|0);e=1802;t=d;return e|0}return 0}function uAc(a,c){a=a|0;c=c|0;var d=0,e=0;d=f[a+24>>2]|0;e=a+16|0;if(b[e>>0]|0){b[e>>0]=c;md(d|0,0)|0;a=0;return a|0}d=td[f[2508>>2]&1023](d,511)|0;if((d|0)>=0){b[e>>0]=c;a=d;return a|0}d=Xbd()|0;d=f[d>>2]|0;if((d|0)==17){a=5;return a|0}c=fBc(d)|0;if((c|0)==5){a=5;return a|0}eBc(a,d);a=c;return a|0}function vAc(a,c){a=a|0;c=c|0;var d=0,e=0;d=f[a+24>>2]|0;e=a+16|0;if((h[e>>0]|0|0)==(c|0)){a=0;return a|0}if((c|0)==1){b[e>>0]=1;a=0;return a|0}if((sd[f[2520>>2]&2047](d)|0)>=0){b[e>>0]=0;a=0;return a|0}c=Xbd()|0;c=f[c>>2]|0;if((c|0)==2){a=0;return a|0}eBc(a,c);a=2058;return a|0}function wAc(a,b){a=a|0;b=b|0;a=(td[f[2316>>2]&1023](f[a+24>>2]|0,0)|0)==0&1;f[b>>2]=a;return 0}function xAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;switch(b|0){case 1:{f[c>>2]=h[a+16>>0];a=0;break}case 4:{f[c>>2]=f[a+20>>2];a=0;break}case 6:{f[a+40>>2]=f[c>>2];a=0;break}case 5:{a=UAc(a,f[c>>2]|0,f[c+4>>2]|0)|0;break}case 10:{VAc(a,4,c);a=0;break}case 13:{VAc(a,16,c);a=0;break}case 12:{f[d>>2]=f[(f[a+4>>2]|0)+16>>2];a=WAc(118856,d)|0;f[c>>2]=a;a=0;break}case 16:{a=a+4|0;b=f[(f[a>>2]|0)+8>>2]|0;b=XAc(b,((b|0)<0)<<31>>31)|0;if(!b)a=0;else{YAc(f[(f[a>>2]|0)+8>>2]|0,b)|0;f[c>>2]=b;a=0}break}case 20:{a=ZAc(a)|0;f[c>>2]=a;a=0;break}default:a=12}t=e;return a|0}function yAc(a){a=a|0;TAc(a);return f[a+44>>2]|0}function zAc(a){a=a|0;TAc(a);return f[a+48>>2]|0}function AAc(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=f[a+36>>2]|0;q=f[g>>2]|0;o=c+b|0;k=1<<b;p=(1<<o)-k|0;r=q+4|0;axc(f[r>>2]|0);a:do if(!(e&1)){if(e&4|0){i=g+10|0;g=j[i>>1]|0;if(p&g|0){e=0;break}h=q+36+(b<<2)|0;e=f[h>>2]|0;if((e|0)<0){e=5;break}if(!e){e=SAc(a,0,b+120|0,c)|0;if(e|0)break;g=j[i>>1]|0;e=f[h>>2]|0}d[i>>1]=p|g;f[h>>2]=e+1;e=0;break}g=g+12|0;e=b;while(1){if((e|0)>=(o|0))break;if((1<<e&(j[g>>1]|0)|0)==0?f[q+36+(e<<2)>>2]|0:0){e=5;break a}e=e+1|0}e=SAc(a,1,b+120|0,c)|0;if(!e){d[g>>1]=p|(j[g>>1]|0);e=b;while(1){if((e|0)>=(o|0)){e=0;break a}f[q+36+(e<<2)>>2]=-1;e=e+1|0}}}else{n=g+12|0;e=d[n>>1]|0;l=g+10|0;g=d[l>>1]|0;m=p&65535;if(!(p&((g|e)&65535)))e=0;else{g=g&65535;h=1;i=b;while(1){if((i|0)>=(o|0))break;h=(f[q+36+(i<<2)>>2]|0)>((1<<i&g|0)!=0|0)?0:h;i=i+1|0}if(!h){h=q+36+(b<<2)|0;if(k&g)f[h>>2]=(f[h>>2]|0)+-1}else{e=SAc(a,2,b+120|0,c)|0;if(e|0)break;Mrd(q+36+(b<<2)|0,0,c<<2|0)|0;g=j[l>>1]|0;e=d[n>>1]|0}b=~m;d[n>>1]=e&65535&b;d[l>>1]=g&b;e=0}}while(0);bxc(f[r>>2]|0);return e|0}function BAc(a){a=a|0;Nzc();FAc();HAc();return}function CAc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;d=a+36|0;e=f[d>>2]|0;if(!e)return 0;g=f[e>>2]|0;h=g+4|0;axc(f[h>>2]|0);c=g+32|0;while(1){i=f[c>>2]|0;if((i|0)==(e|0))break;else c=i+4|0}f[c>>2]=f[e+4>>2];qxc(e);f[d>>2]=0;bxc(f[h>>2]|0);FAc();h=g+28|0;i=(f[h>>2]|0)+-1|0;f[h>>2]=i;if(!i){if(b|0?(f[g+12>>2]|0)>-1:0)sd[f[2484>>2]&2047](f[g+8>>2]|0)|0;GAc(a)}HAc();return 0}function DAc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f[e>>2]=0;return 0}function EAc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function FAc(){axc(f[38485]|0);return}function GAc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;i=f[(f[a+8>>2]|0)+40>>2]|0;if(!i)return;if(f[i+28>>2]|0)return;g=IAc()|0;Uzc(f[i+4>>2]|0);c=i+20|0;h=i+12|0;d=i+24|0;e=i+16|0;b=0;while(1){if((b|0)>=(j[c>>1]|0|0))break;if((f[h>>2]|0)>-1)td[f[2568>>2]&1023](f[(f[d>>2]|0)+(b<<2)>>2]|0,f[e>>2]|0)|0;else qxc(f[(f[d>>2]|0)+(b<<2)>>2]|0);b=b+g|0}qxc(f[d>>2]|0);b=f[h>>2]|0;if((b|0)>-1){JAc(a,b,38297);f[h>>2]=-1}f[(f[i>>2]|0)+40>>2]=0;qxc(i);return}function HAc(){bxc(f[38485]|0);return}function IAc(){var a=0;a=rd[f[2592>>2]&15]()|0;return ((a|0)<32768?1:(a|0)/32768|0)|0}function JAc(a,b,c){a=a|0;b=b|0;c=c|0;if(!(sd[f[2304>>2]&2047](b)|0))return;if(!a)a=0;else a=f[a+32>>2]|0;KAc(4106,118615,a,c)|0;return}function KAc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=t;t=t+32|0;g=e;h=Xbd()|0;h=f[h>>2]|0;f[g>>2]=d;f[g+4>>2]=h;f[g+8>>2]=b;f[g+12>>2]=(c|0)==0?155644:c;f[g+16>>2]=155644;dxc(a,118621,g);t=e;return a|0}function LAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;f[e>>2]=c;c=fdd(a,b,e)|0;t=d;return c|0}function MAc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;g=t;t=t+528|0;h=g+520|0;d=g;f[h>>2]=a;OAc(512,d,118856,h)|0;a=udd(d)|0;while(1){if((a|0)<=0){e=4;break}if((b[d+a>>0]|0)==47)break;else a=a+-1|0}if((e|0)==4)if((b[d>>0]|0)==47)a=1;else{b[d>>0]=46;a=1}b[d+a>>0]=0;h=PAc(d,0,0)|0;f[c>>2]=h;if((h|0)>-1){h=0;t=g;return h|0}h=KAc(QAc(37577)|0,118763,d,37577)|0;t=g;return h|0}function NAc(){return id(30)|0}function OAc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=t;t=t+16|0;g=e;f[g>>2]=d;d=RAc(a,b,c,g)|0;t=e;return d|0}function PAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;j=t;t=t+96|0;g=j;h=j+8|0;i=(c|0)!=0;e=i?c:420;d=b|524288;while(1){b=vd[f[2292>>2]&255](a,d,e)|0;if((b|0)<0){k=Xbd()|0;if((f[k>>2]|0)!=4){d=13;break}}else{if((b|0)>2){d=7;break}sd[f[2304>>2]&2047](b)|0;f[g>>2]=a;f[g+4>>2]=b;dxc(28,118876,g);if((vd[f[2292>>2]&255](118919,0,c)|0)<0){b=-1;d=13;break}}}if((d|0)==7){if(!i){k=b;t=j;return k|0}if(((td[f[2352>>2]&1023](b,h)|0)==0?(f[h+36>>2]|0)==0:0)?(f[h+12>>2]&511|0)!=(c|0):0)td[f[2460>>2]&1023](b,c)|0;k=b;t=j;return k|0}else if((d|0)==13){t=j;return b|0}return 0}function QAc(a){a=a|0;cxc(14,a,118859)|0;return 14}function RAc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;h=t;t=t+32|0;g=h;if((a|0)<1){t=h;return c|0}fxc(g,0,c,a,0);gxc(g,d,e);b[c+(f[g+16>>2]|0)>>0]=0;t=h;return c|0}function SAc(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;var g=0,h=0,i=0;i=t;t=t+32|0;h=i;g=i+8|0;a=f[(f[(f[a+8>>2]|0)+40>>2]|0)+12>>2]|0;if((a|0)<=-1){h=0;t=i;return h|0}d[g>>1]=b;d[g+2>>1]=0;f[g+4>>2]=c;f[g+8>>2]=e;e=f[594]|0;f[h>>2]=g;h=(vd[e&255](a,13,h)|0)==-1;h=h?5:0;t=i;return h|0}function TAc(a){a=a|0;var b=0;b=a+44|0;if(f[b>>2]|0)return;if(d[a+18>>1]&16){a=a+48|0;f[a>>2]=f[a>>2]|4096}f[b>>2]=4096;return}function UAc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=t;t=t+80|0;e=m;d=a+40|0;if((f[d>>2]|0)<=0){a=0;t=m;return a|0}a:do if(!(td[f[2352>>2]&1023](f[a+12>>2]|0,e)|0)){j=f[d>>2]|0;k=((j|0)<0)<<31>>31;b=vrd(b|0,c|0,-1,-1)|0;b=vrd(b|0,G|0,j|0,k|0)|0;l=G;k=Crd(b|0,l|0,j|0,k|0)|0;k=wrd(b|0,l|0,k|0,G|0)|0;l=G;b=f[e+36>>2]|0;j=((b|0)<0)<<31>>31;b:do if((l|0)>(j|0)|(l|0)==(j|0)&k>>>0>b>>>0){j=f[e+40>>2]|0;i=b+-1+j-((b|0)%(j|0)|0)|0;b=((j|0)<0)<<31>>31;c=vrd(k|0,l|0,-1,-1)|0;d=G;e=vrd(c|0,d|0,j|0,b|0)|0;g=G;h=((i|0)<0)<<31>>31;while(1){if(!((h|0)<(g|0)|(h|0)==(g|0)&i>>>0<e>>>0))break b;n=(h|0)<(l|0)|(h|0)==(l|0)&i>>>0<k>>>0;o=n?i:c;n=n?h:d;h=(cBc(a,o,n,155644,1)|0)==1;i=vrd(o|0,n|0,j|0,b|0)|0;if(!h){b=778;break a}else h=G}}while(0);o=0;t=m;return o|0}else b=1802;while(0);o=b;t=m;return o|0}function VAc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0;e=f[c>>2]|0;if((e|0)<0){f[c>>2]=((j[a+18>>1]|0)&(b&255)|0)!=0&1;return}b=b&255;if(!e){e=a+18|0;d[e>>1]=(b^65535)&(j[e>>1]|0);return}else{e=a+18|0;d[e>>1]=j[e>>1]|0|b;return}}function WAc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;if(Lzc()|0){b=0;t=d;return b|0}f[c>>2]=b;b=bBc(a,c)|0;t=d;return b|0}function XAc(a,b){a=a|0;b=b|0;if(Lzc()|0){b=0;return b|0}b=vxc(a,b)|0;return b|0}function YAc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=t;t=t+32|0;i=j+8|0;e=j;b[c>>0]=0;g=_Ac()|0;if(!g){i=6410;t=j;return i|0}h=c+(a+-2)|0;d=0;while(1){$Ac(8,e);b[h>>0]=0;l=e;m=f[l>>2]|0;l=f[l+4>>2]|0;f[i>>2]=g;k=i+8|0;f[k>>2]=m;f[k+4>>2]=l;f[i+16>>2]=0;OAc(a,c,118929,i)|0;if(d>>>0>10|(b[h>>0]|0)!=0){d=1;a=5;break}if(!(td[f[2316>>2]&1023](c,0)|0))d=d+1|0;else{d=0;a=5;break}}if((a|0)==5){t=j;return d|0}return 0}function ZAc(a){a=a|0;var b=0,c=0,d=0;d=t;t=t+80|0;b=d;c=a+8|0;if(!(f[c>>2]|0)){c=0;t=d;return c|0}if(td[f[2340>>2]&1023](f[a+32>>2]|0,b)|0){c=1;t=d;return c|0}c=(f[c>>2]|0)+8|0;c=(f[c+4>>2]|0?1:(f[c>>2]|0)!=(f[b+72>>2]|0))&1;t=d;return c|0}function _Ac(){var a=0,b=0,c=0,d=0,e=0;e=t;t=t+80|0;c=e;a=f[38409]|0;if(!(f[660]|0)){d=Hc(118946)|0;f[660]=d}if(!(f[661]|0)){d=Hc(118960)|0;f[661]=d}d=c+12|0;b=0;while(1){if(((a|0?(td[f[2340>>2]&1023](a,c)|0)==0:0)?(f[d>>2]&61440|0)==16384:0)?(td[f[2316>>2]&1023](a,3)|0)==0:0){b=12;break}if(b>>>0>5){a=0;b=12;break}a=f[2640+(b<<2)>>2]|0;b=b+1|0}if((b|0)==12){t=e;return a|0}return 0}function $Ac(a,c){a=a|0;c=c|0;var d=0,e=0,f=0,g=0,i=0,j=0,k=0,l=0;g=t;t=t+256|0;e=g;if(Lzc()|0){t=g;return}f=Mzc(5)|0;axc(f);if((a|0)<1|(c|0)==0){b[155097]=0;bxc(f);t=g;return}if(!(b[155097]|0)){b[155099]=0;b[155098]=0;aBc(Kzc(0)|0,e);d=0;while(1){if((d|0)==256)break;b[155100+d>>0]=d;d=d+1|0}d=0;while(1){if((d|0)==256)break;i=155100+d|0;l=b[i>>0]|0;k=(h[e+d>>0]|0)+(l&255)+(h[155099]|0)|0;b[155099]=k;k=155100+(k&255)|0;j=b[k>>0]|0;b[k>>0]=l;b[i>>0]=j;d=d+1|0}b[155097]=1}while(1){k=(b[155098]|0)+1<<24>>24;b[155098]=k;k=155100+(k&255)|0;i=b[k>>0]|0;l=i&255;j=(h[155099]|0)+l|0;b[155099]=j;j=155100+(j&255)|0;b[k>>0]=b[j>>0]|0;b[j>>0]=i;b[c>>0]=b[155100+((h[k>>0]|0)+l&255)>>0]|0;a=a+-1|0;if(!a)break;else c=c+1|0}bxc(f);t=g;return}function aBc(a,c){a=a|0;c=c|0;if(!(f[10243]|0)){vd[f[a+56>>2]&255](a,256,c)|0;return}else{Mrd(c|0,0,256)|0;a=f[10243]|0;b[c>>0]=a;b[c+1>>0]=a>>8;b[c+2>>0]=a>>16;b[c+3>>0]=a>>24;return}}function bBc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+96|0;c=d+72|0;if(Lzc()|0){c=0;t=d;return c|0}fxc(c,0,d,70,1e9);gxc(c,a,b);c=hxc(c)|0;t=d;return c|0}function cBc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return dBc(f[a+12>>2]|0,b,c,d,e,a+20|0)|0}function dBc(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0;e=e&131071;do{if((gdd(a,b,0)|0)<0){c=-1;break}c=vd[f[2424>>2]&255](a,d,e)|0;if((c|0)>=0){h=6;break}i=Xbd()|0}while((f[i>>2]|0)==4);if((h|0)==6)return c|0;i=Xbd()|0;f[g>>2]=f[i>>2];i=c;return i|0}function eBc(a,b){a=a|0;b=b|0;f[a+20>>2]=b;return}function fBc(a){a=a|0;switch(a|0){case 37:case 4:case 16:case 110:case 11:case 13:{a=5;break}case 1:{a=3;break}default:a=3850}return a|0}function gBc(a){a=a|0;return afd(a)|0}function hBc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;while(1){d=td[f[2364>>2]&1023](a,b)|0;if((d|0)>=0){c=4;break}c=Xbd()|0;if((f[c>>2]|0)!=4){c=4;break}}if((c|0)==4)return d|0;return 0}function iBc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;j=a+12|0;g=0;while(1){if((gdd(f[j>>2]|0,b,0)|0)<0){k=3;break}h=vd[f[2388>>2]&255](f[j>>2]|0,d,e)|0;if((e|0)==(h|0))break;if((h|0)<0){i=Xbd()|0;if((f[i>>2]|0)==4)i=1;else{k=7;break}}else{b=vrd(b|0,c|0,h|0,((h|0)<0)<<31>>31|0)|0;i=h;g=h+g|0;e=e-h|0;d=(h|0)==0?d:d+h|0;c=G}if((i|0)<=0){e=0;break}}if((k|0)==3){k=Xbd()|0;eBc(a,f[k>>2]|0);k=-1;return k|0}else if((k|0)==7){e=Xbd()|0;eBc(a,f[e>>2]|0);e=h;g=0}k=g+e|0;return k|0}function jBc(a){a=a|0;var b=0,c=0;b=a+12|0;c=f[b>>2]|0;if((c|0)>-1){JAc(a,c,35956);f[b>>2]=-1}qxc(f[a+28>>2]|0);b=a+52|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(b|0));return}function kBc(a,b){a=a|0;b=b|0;return 76320}function lBc(a){a=a|0;jBc(a);return 0}function mBc(a,b){a=a|0;b=b|0;return 0}function nBc(a,b){a=a|0;b=b|0;return 0}function oBc(a,b){a=a|0;b=b|0;f[b>>2]=0;return 0}function pBc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;h=k;j=k+4|0;g=Mxc(a)|0;do if((b[a>>0]|0)==47)e=0;else{if(td[f[2328>>2]&1023](c,d+-2|0)|0){e=Mxc(c)|0;b[c+e>>0]=47;e=e+1|0;break}c=KAc(QAc(40248)|0,118664,a,40248)|0;t=k;return c|0}while(0);if((e+g|0)>=(d|0)){b[c+e>>0]=0;c=QAc(40257)|0;t=k;return c|0}f[h>>2]=a;OAc(d-e|0,c+e|0,118856,h)|0;f[j>>2]=1;a=1;d=1;while(1){g=c+a|0;e=b[g>>0]|0;if(!(e<<24>>24))break;h=d+1|0;b[c+d>>0]=e;e=b[g>>0]|0;while(1){a=a+1|0;if(e<<24>>24!=47)break;if((b[c+a>>0]|0)!=47)break;else e=47}d=h}b[c+d>>0]=0;f[j>>2]=0;e=0;a:while(1){g=c+e|0;b:do switch(b[g>>0]|0){case 0:break a;case 47:{a=e+1|0;if((b[c+a>>0]|0)==46){d=e+2|0;switch(b[c+d>>0]|0){case 47:{e=a;break b}case 46:break;default:{i=19;break b}}if((b[c+(e+3)>>0]|0)==47?(qBc(c,j)|0)!=0:0)e=d;else i=19}else i=19;break}default:i=19}while(0);if((i|0)==19){i=0;a=f[j>>2]|0;if((a|0)>-1)b[c+a>>0]=b[g>>0]|0;f[j>>2]=a+1}e=e+1|0}e=f[j>>2]|0;if(!e){f[j>>2]=1;b[c>>0]=47;e=1}b[c+e>>0]=0;c=0;t=k;return c|0}function qBc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;g=f[c>>2]|0;if((g|0)<1){g=0;return g|0}e=g;while(1){d=e+-1|0;if((e|0)<=1)break;if((b[a+(e+-2)>>0]|0)==47)break;else e=d}if(!d){g=0;return g|0}if(((e|0)==(g+-1|0)?(b[a+d>>0]|0)==46:0)?(b[a+e>>0]|0)==46:0){g=0;return g|0}f[c>>2]=e+-2;g=1;return g|0}function rBc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+80|0;c=h;FAc();if(!(f[38487]|0)){g=0;HAc();t=h;return g|0}if(td[f[2340>>2]&1023](a,c)|0){g=0;HAc();t=h;return g|0}d=f[c>>2]|0;c=f[c+72>>2]|0;a=153948;while(1){a=f[a>>2]|0;if(!a){a=0;g=13;break}if((f[a>>2]|0)==(d|0)?(e=a+8|0,(f[e+4>>2]|0)==0?(f[e>>2]|0)==(c|0):0):0)break;a=a+44|0}if((g|0)==13){HAc();t=h;return a|0}e=a+16|0;axc(f[e>>2]|0);b=b&3;c=a+32|0;while(1){a=f[c>>2]|0;if(!a){a=0;break}d=a+8|0;if((f[a+4>>2]|0)==(b|0)){g=11;break}else c=d}if((g|0)==11)f[c>>2]=f[d>>2];bxc(f[e>>2]|0);g=a;HAc();t=h;return g|0}function sBc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;k=t;t=t+528|0;j=k;f[d>>2]=0;f[e>>2]=0;f[g>>2]=0;do if(!(c&526336)){if(c&8|0){f[d>>2]=384;c=0;break}if((c&64|0)!=0?(h=MBc(a,119185)|0,(h|0)!=0):0)c=VBc(h,d,e,g)|0;else c=0}else{h=Mxc(a)|0;while(1){h=h+-1|0;c=b[a+h>>0]|0;if(c<<24>>24==45){i=5;break}if((h|0)==0|c<<24>>24==46){i=6;break}}if((i|0)==5){Krd(j|0,a|0,h|0)|0;b[j+h>>0]=0;c=VBc(j,d,e,g)|0;break}else if((i|0)==6){c=0;break}}while(0);t=k;return c|0}function tBc(a,b,c){a=a|0;b=b|0;c=c|0;if(rd[f[2544>>2]&15]()|0)return;vd[f[2532>>2]&255](a,b,c)|0;return}function uBc(a,b,c,e,g){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;k=t;t=t+16|0;i=k;f[c+12>>2]=b;f[c+4>>2]=a;f[c+32>>2]=e;h=c+18|0;d[h>>1]=g&255;if(vBc((g&64|0)==0?0:e,119020,1)|0)d[h>>1]=d[h>>1]|16;if(!(ncd(f[a+16>>2]|0,118605)|0))d[h>>1]=d[h>>1]|1;do if(!(g&128)){a=td[f[f[a+20>>2]>>2]&1023](e,c)|0;if((a|0)==76396){FAc();h=wBc(c,c+8|0)|0;if(h){JAc(c,b,39521);b=-1}HAc();a=76396}else{if((a|0)!=76244){j=14;break}a=(udd(e)|0)+6|0;g=XAc(a,((a|0)<0)<<31>>31)|0;if(!g)h=7;else{f[i>>2]=e;OAc(a,g,119025,i)|0;h=0}f[c+24>>2]=g;a=76244}eBc(c,0);if(h){if((b|0)<=-1){j=h;t=k;return j|0}JAc(c,b,39606);j=h;t=k;return j|0}}else{a=76320;j=14}while(0);if((j|0)==14)eBc(c,0);f[c>>2]=a;xBc(c);j=0;t=k;return j|0}function vBc(a,b,c){a=a|0;b=b|0;c=c|0;b=MBc(a,b)|0;a=(c|0)!=0;if(!b){c=a&1;return c|0}else{c=(NBc(b,a&1)|0)&255;return c|0}return 0}function wBc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+96|0;g=h;d=h+16|0;if(td[f[2352>>2]&1023](f[a+12>>2]|0,d)|0){c=Xbd()|0;eBc(a,f[c>>2]|0);c=10;t=h;return c|0}a=g;f[a>>2]=0;f[a+4>>2]=0;f[g>>2]=f[d>>2];a=g+8|0;f[a>>2]=f[d+72>>2];f[a+4>>2]=0;a=153948;while(1){a=f[a>>2]|0;if(!a){d=7;break}if(!(ocd(g,a,16)|0)){d=14;break}a=a+44|0}if((d|0)==7){a=XAc(56,0)|0;if(!a){c=7;t=h;return c|0}d=a+16|0;e=d+40|0;do{f[d>>2]=0;d=d+4|0}while((d|0)<(e|0));f[a>>2]=f[g>>2];f[a+4>>2]=f[g+4>>2];f[a+8>>2]=f[g+8>>2];f[a+12>>2]=f[g+12>>2];if(b[40716]|0?(g=yBc(0)|0,f[a+16>>2]=g,(g|0)==0):0){qxc(a);c=7;t=h;return c|0}f[a+36>>2]=1;d=f[38487]|0;f[a+44>>2]=d;f[a+48>>2]=0;if(d|0)f[d+48>>2]=a;f[38487]=a}else if((d|0)==14){g=a+36|0;f[g>>2]=(f[g>>2]|0)+1}f[c>>2]=a;c=0;t=h;return c|0}function xBc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0,i=0;i=t;t=t+112|0;h=i+24|0;g=i+16|0;e=i+8|0;c=i;b=i+28|0;if(d[a+18>>1]&128){t=i;return}if(td[f[2352>>2]&1023](f[a+12>>2]|0,b)|0){f[c>>2]=f[a+32>>2];dxc(28,119033,c);t=i;return}switch(f[b+16>>2]|0){case 0:{f[e>>2]=f[a+32>>2];dxc(28,119057,e);t=i;return}case 1:{if(!(ZAc(a)|0)){t=i;return}f[h>>2]=f[a+32>>2];dxc(28,119113,h);t=i;return}default:{f[g>>2]=f[a+32>>2];dxc(28,119086,g);t=i;return}}}function yBc(a){a=a|0;if((a|0)<2){if(Lzc()|0){a=0;return a|0}}else if(Ozc()|0){a=0;return a|0}a=sd[f[40784>>2]&2047](a)|0;return a|0}function zBc(a){a=a|0;var b=0,c=0;c=f[a+8>>2]|0;xBc(a);BBc(a,0)|0;FAc();b=c+16|0;axc(f[b>>2]|0);if(f[c+24>>2]|0)KBc(a);bxc(f[b>>2]|0);LBc(a);jBc(a);HAc();return 0}function ABc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=t;t=t+16|0;n=r;p=a+16|0;if((h[p>>0]|0|0)>=(c|0)){q=0;t=r;return q|0}l=f[a+8>>2]|0;q=l+16|0;axc(f[q>>2]|0);g=b[p>>0]|0;o=l+28|0;e=b[o>>0]|0;if(g<<24>>24!=e<<24>>24?(c|0)>1|(e&255)>2:0)e=5;else m=4;a:do if((m|0)==4){k=(c|0)==1;do if(k)if((e+-1&255)<2){b[p>>0]=1;e=l+20|0;f[e>>2]=(f[e>>2]|0)+1;e=l+24|0;f[e>>2]=(f[e>>2]|0)+1;e=0;break a}else{j=n+8|0;f[j>>2]=1;d[n+2>>1]=0;m=10;break}else{e=n+8|0;f[e>>2]=1;d[n+2>>1]=0;if((c|0)==4)if((g&255)<3){j=e;m=10}else{g=e;m=22}else{g=e;m=21}}while(0);b:do if((m|0)==10){d[n>>1]=(k^1)&1;i=n+4|0;f[i>>2]=f[19118];if(IBc(a,n)|0){g=Xbd()|0;g=f[g>>2]|0;e=fBc(g)|0;if((e|0)==5){e=5;break a}eBc(a,g);break a}if(k){f[i>>2]=(f[19118]|0)+2;f[j>>2]=510;if(!(IBc(a,n)|0)){g=0;e=0}else{e=Xbd()|0;e=f[e>>2]|0;g=e;e=fBc(e)|0}f[i>>2]=f[19118];f[j>>2]=1;d[n>>1]=2;c:do if((e|0)==0&(IBc(a,n)|0)!=0){g=Xbd()|0;e=2058;g=f[g>>2]|0}else{switch(e|0){case 5:break a;case 0:break;default:break c}b[p>>0]=1;m=l+24|0;f[m>>2]=(f[m>>2]|0)+1;f[l+20>>2]=1;m=30;break b}while(0);eBc(a,g);break a}else{g=j;m=21}}while(0);if((m|0)==21)if((c|0)!=4){d[n>>1]=1;e=f[19118]|0;if((c|0)==2){i=e+1|0;e=g;g=1;m=27}else m=26}else m=22;if((m|0)==22)if((f[l+20>>2]|0)>1){e=5;m=32}else{d[n>>1]=1;e=f[19118]|0;m=26}if((m|0)==26){i=e+2|0;e=g;g=510;m=27}do if((m|0)==27){f[n+4>>2]=i;f[e>>2]=g;if(IBc(a,n)|0){g=Xbd()|0;g=f[g>>2]|0;e=fBc(g)|0;if((e|0)!=5){eBc(a,g);if(!e){m=30;break}}else e=5;if((c|0)==4)m=32;else break a}else m=30}while(0);if((m|0)==30){e=c&255;b[p>>0]=e;b[o>>0]=e;e=0;break}else if((m|0)==32){b[p>>0]=3;b[o>>0]=3;break}}while(0);bxc(f[q>>2]|0);q=e;t=r;return q|0}function BBc(a,b){a=a|0;b=b|0;return HBc(a,b)|0}function CBc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0;k=t;t=t+32|0;g=k;i=k+8|0;j=a+8|0;axc(f[(f[j>>2]|0)+16>>2]|0);e=f[j>>2]|0;if((h[e+28>>0]|0)<=1)if(!(b[e+29>>0]|0)){d[i+2>>1]=0;f[i+4>>2]=(f[19118]|0)+1;f[i+8>>2]=1;d[i>>1]=1;l=f[594]|0;e=f[a+12>>2]|0;f[g>>2]=i;if(!(vd[l&255](e,12,g)|0)){e=0;a=(d[i>>1]|0)!=2&1}else{e=Xbd()|0;eBc(a,f[e>>2]|0);e=3594;a=0}g=e;e=f[j>>2]|0}else{g=0;a=0}else{g=0;a=1}bxc(f[e+16>>2]|0);f[c>>2]=a;t=k;return g|0}function DBc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0;v=t;t=t+80|0;l=v+4|0;m=v;u=IAc()|0;k=a+36|0;i=f[k>>2]|0;do if(!i){i=EBc(a)|0;if(!i){i=f[k>>2]|0;break}else{h=i;t=v;return h|0}}while(0);r=f[i>>2]|0;s=r+4|0;axc(f[s>>2]|0);i=r+23|0;do if(b[i>>0]|0){k=FBc(a,r)|0;if(!k){b[i>>0]=0;n=8;break}else{i=r+20|0;break}}else n=8;while(0);if((n|0)==8){o=u+c|0;o=o-((o|0)%(u|0)|0)|0;q=r+20|0;if((o|0)>(j[q>>1]|0)){k=V(o,e)|0;f[r+16>>2]=e;p=r+12|0;i=f[p>>2]|0;a:do if((i|0)>-1)if(!(td[f[2352>>2]&1023](i,l)|0)){i=f[l+36>>2]|0;if((i|0)<(k|0))if(!g)i=0;else{k=(k|0)/4096|0;i=(i|0)/4096|0;while(1){if((i|0)>=(k|0)){n=18;break a}f[m>>2]=0;g=i<<12|4095;if((dBc(f[p>>2]|0,g,((g|0)<0)<<31>>31,155644,1,m)|0)!=1)break;i=i+1|0}KAc(4874,118717,f[r+8>>2]|0,38623)|0;i=4874}else n=18}else i=4874;else n=18;while(0);b:do if((n|0)==18){m=r+24|0;i=GBc(f[m>>2]|0,o<<2)|0;if(!i)i=3082;else{f[m>>2]=i;a=V(u,e)|0;l=r+22|0;g=((a|0)<0)<<31>>31;i=d[q>>1]|0;while(1){i=i&65535;if((o|0)<=(i|0)){i=0;break b}k=f[p>>2]|0;if((k|0)>-1){i=V(i,e)|0;i=Bd[f[2556>>2]&127](0,a,(b[l>>0]|0)==0?3:1,1,k,i)|0;if((i|0)==(-1|0))break}else{i=XAc(a,g)|0;if(!i){i=7;break b}Mrd(i|0,0,a|0)|0}k=0;while(1){if((k|0)>=(u|0))break;n=i+(V(k,e)|0)|0;f[(f[m>>2]|0)+(k+(j[q>>1]|0)<<2)>>2]=n;k=k+1|0}i=u+(j[q>>1]|0)&65535;d[q>>1]=i}KAc(5386,118804,f[r+8>>2]|0,38650)|0;i=5386}}while(0);k=i;i=q}else{k=0;i=q}}if((j[i>>1]|0)>(c|0))i=f[(f[r+24>>2]|0)+(c<<2)>>2]|0;else i=0;f[h>>2]=i;h=(k|0)==0&(b[r+22>>0]|0)!=0?8:k;bxc(f[s>>2]|0);t=v;return h|0}function EBc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+80|0;i=o;m=o+4|0;n=XAc(16,0)|0;if(!n){n=7;t=o;return n|0};f[n>>2]=0;f[n+4>>2]=0;f[n+8>>2]=0;f[n+12>>2]=0;FAc();k=a+8|0;l=f[k>>2]|0;d=f[l+40>>2]|0;a:do if(!d){h=a+32|0;e=f[h>>2]|0;b:do if(!(td[f[2352>>2]&1023](f[a+12>>2]|0,m)|0)){g=udd(e)|0;c=g+74|0;d=XAc(c,0)|0;if(!d)c=7;else{Mrd(d|0,0,c|0)|0;j=d+68|0;f[d+8>>2]=j;f[i>>2]=e;OAc(g+6|0,j,119141,i)|0;e=d+12|0;f[e>>2]=-1;k=f[k>>2]|0;f[k+40>>2]=d;f[d>>2]=k;if(b[40716]|0?(k=yBc(0)|0,f[d+4>>2]=k,(k|0)==0):0){c=7;break}if(!(b[l+29>>0]|0)){if(!(vBc(f[h>>2]|0,119148,0)|0)){c=PAc(j,131138,f[m+12>>2]&511)|0;f[e>>2]=c}else c=f[e>>2]|0;do if((c|0)<0){c=PAc(j,131072,f[m+12>>2]&511)|0;f[e>>2]=c;if((c|0)<0){c=KAc(QAc(38479)|0,118652,j,38479)|0;break b}else{b[d+22>>0]=1;break}}while(0);tBc(c,f[m+20>>2]|0,f[m+24>>2]|0);c=FBc(a,d)|0;switch(c|0){case 0:case 1288:break;default:break b}}else c=0;break a}}else c=1802;while(0);GAc(a);qxc(n);HAc();n=c;t=o;return n|0}else c=0;while(0);f[n>>2]=d;m=d+28|0;f[m>>2]=(f[m>>2]|0)+1;f[a+36>>2]=n;HAc();a=d+4|0;axc(f[a>>2]|0);m=d+32|0;f[n+4>>2]=f[m>>2];f[m>>2]=n;bxc(f[a>>2]|0);n=c;t=o;return n|0}function FBc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;i=t;t=t+32|0;j=i;e=i+8|0;d[e+2>>1]=0;f[e+4>>2]=128;f[e+8>>2]=1;d[e>>1]=1;l=f[594]|0;h=c+12|0;k=f[h>>2]|0;f[j>>2]=e;if(vd[l&255](k,12,j)|0){l=3850;t=i;return l|0}switch(d[e>>1]|0){case 2:{g=3;break}case 1:{l=5;t=i;return l|0}default:{}}if((g|0)==3){if(b[c+22>>0]|0){b[c+23>>0]=1;l=1288;t=i;return l|0}e=SAc(a,1,128,1)|0;if(e|0){l=e;t=i;return l|0}if(hBc(f[h>>2]|0,3,0)|0){KAc(4618,118682,f[c+8>>2]|0,38354)|0;l=4618;t=i;return l|0}}l=SAc(a,0,128,1)|0;t=i;return l|0}function GBc(a,b){a=a|0;b=b|0;if(Lzc()|0){b=0;return b|0}b=Pxc(a,(b|0)>0?b:0,0)|0;return b|0}function HBc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+16|0;j=o;l=a+16|0;if((h[l>>0]|0|0)<=(c|0)){n=0;t=o;return n|0}m=f[a+8>>2]|0;n=m+16|0;axc(f[n>>2]|0);a:do if((h[l>>0]|0)>1){if((c|0)==1){d[j>>1]=0;g=j+2|0;d[g>>1]=0;i=j+4|0;f[i>>2]=(f[19118]|0)+2;e=j+8|0;f[e>>2]=510;if(!(IBc(a,j)|0))k=7;else{e=Xbd()|0;eBc(a,f[e>>2]|0);e=2314}}else{g=j+2|0;i=j+4|0;e=j+8|0;k=7}do if((k|0)==7){d[j>>1]=2;d[g>>1]=0;f[i>>2]=f[19118];f[e>>2]=2;if(!(IBc(a,j)|0)){b[m+28>>0]=1;break a}else{e=Xbd()|0;eBc(a,f[e>>2]|0);e=2058;break}}while(0);bxc(f[n>>2]|0);n=e;t=o;return n|0}while(0);if(!c){i=m+20|0;k=(f[i>>2]|0)+-1|0;f[i>>2]=k;if(!k){d[j>>1]=2;d[j+2>>1]=0;f[j+8>>2]=0;f[j+4>>2]=0;if(!(IBc(a,j)|0)){e=0;g=m+28|0}else{e=Xbd()|0;eBc(a,f[e>>2]|0);b[m+28>>0]=0;e=2058;g=l}b[g>>0]=0}else e=0;k=m+24|0;m=(f[k>>2]|0)+-1|0;f[k>>2]=m;if(!m)JBc(a);bxc(f[n>>2]|0);if(e|0){n=e;t=o;return n|0}}else bxc(f[n>>2]|0);b[l>>0]=c;n=0;t=o;return n|0}function IBc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0;j=t;t=t+32|0;e=j+8|0;h=j;g=j+16|0;i=f[a+8>>2]|0;if((d[a+18>>1]&3)!=1){h=f[594]|0;i=f[a+12>>2]|0;f[e>>2]=c;i=vd[h&255](i,13,e)|0;t=j;return i|0}e=i+29|0;if(b[e>>0]|0){i=0;t=j;return i|0}d[g+2>>1]=0;f[g+4>>2]=(f[19118]|0)+2;f[g+8>>2]=510;d[g>>1]=1;k=f[594]|0;c=f[a+12>>2]|0;f[h>>2]=g;c=vd[k&255](c,13,h)|0;if((c|0)<0){k=c;t=j;return k|0}else{b[e>>0]=1;k=i+24|0;f[k>>2]=(f[k>>2]|0)+1;k=c;t=j;return k|0}return 0}function JBc(a){a=a|0;var b=0,c=0,d=0;c=(f[a+8>>2]|0)+32|0;b=f[c>>2]|0;while(1){if(!b)break;d=f[b+8>>2]|0;JAc(a,f[b>>2]|0,35172);qxc(b);b=d}f[c>>2]=0;return}function KBc(a){a=a|0;var b=0,c=0,d=0;b=a+28|0;d=f[b>>2]|0;c=(f[a+8>>2]|0)+32|0;f[d+8>>2]=f[c>>2];f[c>>2]=d;f[a+12>>2]=-1;f[b>>2]=0;return}function LBc(a){a=a|0;var b=0,c=0,d=0,e=0;d=f[a+8>>2]|0;if(!d)return;c=d+36|0;e=(f[c>>2]|0)+-1|0;f[c>>2]=e;if(e|0)return;e=d+16|0;axc(f[e>>2]|0);JBc(a);bxc(f[e>>2]|0);c=f[d+48>>2]|0;b=d+44|0;a=f[b>>2]|0;if(!c)f[38487]=a;else{f[c+44>>2]=a;a=f[b>>2]|0}if(a|0)f[a+48>>2]=c;Uzc(f[e>>2]|0);qxc(d);return}function MBc(a,b){a=a|0;b=b|0;if((a|0)==0|(b|0)==0){b=0;return b|0}b=UBc(TBc(a)|0,b)|0;return b|0}function NBc(a,b){a=a|0;b=b|0;return (OBc(a,1,b)|0)<<24>>24!=0|0}function OBc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0,g=0;if(((h[a>>0]|0)+-48|0)>>>0<10){g=(PBc(a)|0)&255;return g|0}f=Mxc(a)|0;e=(c|0)!=0;c=0;while(1){if(c>>>0>=8){g=10;break}if(((f|0)==(h[119161+c>>0]|0|0)?(QBc(2672+(h[119169+c>>0]|0)|0,a,f)|0)==0:0)?!(e&(c|1|0)==7):0)break;c=c+1|0}if((g|0)==10)return d|0;g=b[119177+c>>0]|0;return g|0}function PBc(a){a=a|0;var b=0,c=0;c=t;t=t+16|0;b=c;f[b>>2]=0;RBc(a,b)|0;t=c;return f[b>>2]|0}function QBc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,f=0;if(!a){f=((c|0)!=0)<<31>>31;return f|0}if(!c){f=1;return f|0}e=d;while(1){if((e|0)<=0){c=0;e=12;break}d=b[a>>0]|0;if(!(d<<24>>24)){e=7;break}d=b[1680+(d&255)>>0]|0;f=b[1680+(h[c>>0]|0)>>0]|0;if(d<<24>>24!=f<<24>>24){e=9;break}c=c+1|0;a=a+1|0;e=e+-1|0}if((e|0)==7){a=0;c=b[1680+(h[c>>0]|0)>>0]|0}else if((e|0)==9){a=d&255;c=f}else if((e|0)==12)return c|0;f=a-(c&255)|0;return f|0}function RBc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;a:do switch(b[a>>0]|0){case 45:{i=1;a=a+1|0;break}case 43:{i=0;a=a+1|0;break}case 48:{switch(b[a+1>>0]|0){case 88:case 120:break;default:{i=0;break a}}d=a+2|0;e=b[d>>0]|0;if(!(b[1424+(e&255)>>0]&8))i=0;else{while(1){a=d+1|0;if(e<<24>>24!=48)break;d=a;e=b[a>>0]|0}g=0;h=0;while(1){a=b[1424+(e&255)>>0]&8;if(!(h>>>0<8&a<<24>>24!=0))break;i=(g<<4)+((SBc(e<<24>>24)|0)&255)|0;j=h+1|0;g=i;h=j;e=b[d+j>>0]|0}if(!((g|0)>-1&a<<24>>24==0)){c=0;return c|0}f[c>>2]=g;c=1;return c|0}break}default:i=0}while(0);d=b[a>>0]|0;if(((d&255)+-48|0)>>>0>=10){c=0;return c|0}while(1){if(d<<24>>24!=48)break;d=a+1|0;a=d;d=b[d>>0]|0}d=0;g=0;h=0;while(1){if(d>>>0>=11){a=0;j=24;break}e=b[a+d>>0]|0;if((e+-48&255)>=10)break;e=(e<<24>>24)+-48|0;k=Brd(g|0,h|0,10,0)|0;e=vrd(k|0,G|0,e|0,((e|0)<0)<<31>>31|0)|0;d=d+1|0;g=e;h=G}if((j|0)==24)return a|0;k=wrd(g|0,h|0,i|0,0)|0;j=G;if((j|0)>0|(j|0)==0&k>>>0>2147483647){k=0;return k|0}f[c>>2]=(i|0)==0?g:0-g|0;k=1;return k|0}function SBc(a){a=a|0;return (0-(a>>>6&1)&9)+a&15|0}function TBc(a){a=a|0;var c=0;while(1){c=a+-1|0;if((((b[c>>0]|0)==0?(b[a+-2>>0]|0)==0:0)?(b[a+-3>>0]|0)==0:0)?(b[a+-4>>0]|0)==0:0)break;a=c}return a|0}function UBc(a,c){a=a|0;c=c|0;var d=0;while(1){a=a+((Mxc(a)|0)+1)|0;if(!(b[a>>0]|0)){a=0;c=4;break}d=ncd(a,c)|0;a=a+((Mxc(a)|0)+1)|0;if(!d){c=4;break}}if((c|0)==4)return a|0;return 0}function VBc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+80|0;e=g;if(td[f[2340>>2]&1023](a,e)|0){e=1802;t=g;return e|0}f[b>>2]=f[e+12>>2]&511;f[c>>2]=f[e+20>>2];f[d>>2]=f[e+24>>2];e=0;t=g;return e|0}function WBc(a,b){a=a|0;b=b|0;return 76396}function XBc(){var a=0,b=0;a=t;t=t+16|0;b=a;f[b>>2]=76476;YBc(18,b)|0;t=a;return}function YBc(a,c){a=a|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;d=e;if(f[10230]|0){c=Zwc(164438)|0;t=e;return c|0}f[d>>2]=c;do switch(a|0){case 1:{b[40716]=0;b[40717]=0;a=0;break}case 2:{b[40716]=1;b[40717]=0;a=0;break}case 3:{b[40716]=1;b[40717]=1;a=0;break}case 10:{a=(f[d>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[d>>2]=a+4;a=40776;d=c;c=a+36|0;do{f[a>>2]=f[d>>2];a=a+4|0;d=d+4|0}while((a|0)<(c|0));a=0;break}case 11:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;d=40776;c=a+36|0;do{f[a>>2]=f[d>>2];a=a+4|0;d=d+4|0}while((a|0)<(c|0));a=0;break}case 4:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10186]=f[a>>2];f[10187]=f[a+4>>2];f[10188]=f[a+8>>2];f[10189]=f[a+12>>2];f[10190]=f[a+16>>2];f[10191]=f[a+20>>2];f[10192]=f[a+24>>2];f[10193]=f[a+28>>2];a=0;break}case 5:{if(!(f[10186]|0))ZBc();c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[a>>2]=f[10186];f[a+4>>2]=f[10187];f[a+8>>2]=f[10188];f[a+12>>2]=f[10189];f[a+16>>2]=f[10190];f[a+20>>2]=f[10191];f[a+24>>2]=f[10192];f[a+28>>2]=f[10193];a=0;break}case 9:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10178]=a;a=0;break}case 27:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;b[40720]=a;a=0;break}case 7:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10224]=a;a=(f[d>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[d>>2]=a+4;f[10225]=c;c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10226]=a;a=0;break}case 24:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[a>>2]=160;a=0;break}case 14:{a=0;break}case 15:{a=1;break}case 18:{a=(f[d>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[d>>2]=a+4;a=40812;d=c;c=a+52|0;do{f[a>>2]=f[d>>2];a=a+4|0;d=d+4|0}while((a|0)<(c|0));a=0;break}case 19:{if(!(f[10205]|0))XBc();c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;d=40812;c=a+52|0;do{f[a>>2]=f[d>>2];a=a+4|0;d=d+4|0}while((a|0)<(c|0));a=0;break}case 13:{a=(f[d>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[d>>2]=a+4;f[10183]=c;c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10184]=a;a=0;break}case 16:{a=(f[d>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[d>>2]=a+4;f[10237]=c;c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10238]=a;a=0;break}case 17:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;b[40718]=a;a=0;break}case 20:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;b[40719]=a;a=0;break}case 22:{f[d>>2]=((f[d>>2]|0)+(8-1)&~(8-1))+8;f[d>>2]=((f[d>>2]|0)+(8-1)&~(8-1))+8;f[10220]=0;f[10221]=0;f[10222]=0;f[10223]=0;a=0;break}case 25:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10229]=a;a=0;break}case 26:{c=(f[d>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[d>>2]=c+4;f[10185]=a;a=0;break}default:a=1}while(0);c=a;t=e;return c|0}function ZBc(){var a=0,b=0;a=t;t=t+16|0;b=a;f[b>>2]=76528;YBc(4,b)|0;t=a;return}function _Bc(a){a=a|0;var b=0,c=0,d=0;d=t;t=t+16|0;c=d;b=Mbd(a+8|0)|0;if(!b){f[c>>2]=a;dxc(7,119228,c);c=0;t=d;return c|0}else{c=b;f[c>>2]=a;f[c+4>>2]=((a|0)<0)<<31>>31;c=b+8|0;t=d;return c|0}return 0}function $Bc(a){a=a|0;Nbd(a+-8|0);return}function aCc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;e=t;t=t+16|0;d=e;c=Obd(a+-8|0,b+8|0)|0;if(!c){c=bCc(a)|0;f[d>>2]=c;f[d+4>>2]=b;dxc(7,119192,d);d=0;t=e;return d|0}else{d=c;f[d>>2]=b;f[d+4>>2]=((b|0)<0)<<31>>31;d=c+8|0;t=e;return d|0}return 0}function bCc(a){a=a|0;return f[a+-8>>2]|0}function cCc(a){a=a|0;return a+7&-8|0}function dCc(a){a=a|0;return 0}function eCc(a){a=a|0;return}function fCc(a){a=a|0;var c=0,d=0;a=153720;c=a+100|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(c|0));a=f[10224]|0;d=b[40716]|0;c=((a|0)==0|d<<24>>24!=0)&1;f[38444]=c;if(d<<24>>24){c=Mzc(6)|0;f[38430]=c;c=Mzc(7)|0;f[38451]=c;c=f[38444]|0;a=f[10224]|0}d=f[10226]|0;f[38445]=(c|0)!=0&(d|0)!=0&(a|0)==0?d:0;f[38433]=10;f[38443]=1;return 0}function gCc(a){a=a|0;var b=0;a=153720;b=a+100|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(b|0));return}function hCc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0;i=((f[38444]|0)*52|0)+68|0;i=DCc(i,((i|0)<0)<<31>>31)|0;if(!i)return i|0;if(!(f[38444]|0))e=153720;else{f[i+80>>2]=10;e=i+68|0}g=e+20|0;h=e+34|0;if(!(d[h>>1]|0)){d[h>>1]=1;f[e+44>>2]=g;f[e+48>>2]=g}f[i>>2]=e;f[i+8>>2]=a;f[i+12>>2]=b;f[i+16>>2]=a+32+b;c=(c|0)!=0;f[i+20>>2]=c&1;zCc(i);if(c){f[i+24>>2]=10;h=e+8|0;c=f[h>>2]|0;f[h>>2]=c+10;f[e+12>>2]=-10-c+10+(f[e+4>>2]|0);f[i+4>>2]=e+16}else f[i+4>>2]=i+40;if(f[i+52>>2]|0)return i|0;oCc(i);i=0;return i|0}function iCc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;if(!(f[a+20>>2]|0))return;d=f[a>>2]|0;c=a+28|0;g=d+4|0;e=(f[g>>2]|0)+(b-(f[c>>2]|0))|0;f[g>>2]=e;f[d+12>>2]=e+10-(f[d+8>>2]|0);f[c>>2]=b;f[a+32>>2]=((b*9|0)>>>0)/10|0;qCc(a);return}function jCc(a){a=a|0;return f[a+48>>2]|0}function kCc(a,b,c){a=a|0;b=b|0;c=c|0;return wCc(a,b,c)|0}function lCc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a>>2]|0;if((c|0)==0?(f[d+16>>2]|0)>>>0<=(f[d+4>>2]|0)>>>0:0){c=d+44|0;f[b+28>>2]=d+20;d=f[c>>2]|0;f[b+24>>2]=d;f[d+28>>2]=b;f[c>>2]=b;d=a+44|0;f[d>>2]=(f[d>>2]|0)+1;return}sCc(b,1);return}function mCc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=f[a+52>>2]|0;h=a+56|0;c=(f[h>>2]|0)+(((c>>>0)%(g>>>0)|0)<<2)|0;while(1){e=f[c>>2]|0;if((e|0)==(b|0))break;else c=e+16|0}e=b+16|0;f[c>>2]=f[e>>2];f[b+8>>2]=d;c=(f[h>>2]|0)+(((d>>>0)%(g>>>0)|0)<<2)|0;f[e>>2]=f[c>>2];f[c>>2]=b;c=a+36|0;if((f[c>>2]|0)>>>0>=d>>>0)return;f[c>>2]=d;return}function nCc(a,b){a=a|0;b=b|0;var c=0;c=a+36|0;if((f[c>>2]|0)>>>0<b>>>0)return;vCc(a,b);f[c>>2]=b+-1;return}function oCc(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a>>2]|0;if(f[a+48>>2]|0)vCc(a,0);e=b+4|0;d=(f[e>>2]|0)-(f[a+28>>2]|0)|0;f[e>>2]=d;e=b+8|0;c=(f[e>>2]|0)-(f[a+24>>2]|0)|0;f[e>>2]=c;f[b+12>>2]=d+10-c;qCc(a);qxc(f[a+64>>2]|0);qxc(f[a+56>>2]|0);qxc(a);return}function pCc(a){a=a|0;var b=0,c=0;if(!(f[a+20>>2]|0))return;b=(f[a>>2]|0)+4|0;c=f[b>>2]|0;f[b>>2]=0;qCc(a);f[b>>2]=c;return}function qCc(a){a=a|0;var b=0,c=0,e=0,g=0;e=f[a>>2]|0;b=e+48|0;c=e+16|0;e=e+4|0;while(1){if((f[c>>2]|0)>>>0<=(f[e>>2]|0)>>>0)break;g=f[b>>2]|0;if(d[g+14>>1]|0)break;rCc(g)|0;sCc(g,1)}if(f[a+48>>2]|0)return;b=a+64|0;c=f[b>>2]|0;if(!c)return;qxc(c);f[a+60>>2]=0;f[b>>2]=0;return}function rCc(a){a=a|0;var b=0,c=0;b=a+24|0;c=f[a+28>>2]|0;f[c+24>>2]=f[b>>2];f[(f[b>>2]|0)+28>>2]=c;f[b>>2]=0;b=(f[a+20>>2]|0)+44|0;f[b>>2]=(f[b>>2]|0)+-1;return a|0}function sCc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;e=f[a+20>>2]|0;c=(f[e+56>>2]|0)+((((f[a+8>>2]|0)>>>0)%((f[e+52>>2]|0)>>>0)|0)<<2)|0;while(1){g=f[c>>2]|0;d=g+16|0;if((g|0)==(a|0))break;else c=d}f[c>>2]=f[d>>2];g=e+48|0;f[g>>2]=(f[g>>2]|0)+-1;if(!b)return;tCc(a);return}function tCc(a){a=a|0;var b=0,c=0;b=f[a+20>>2]|0;if(!(d[a+12>>1]|0))uCc(f[a>>2]|0);else{c=b+60|0;f[a+16>>2]=f[c>>2];f[c>>2]=a}c=f[b+4>>2]|0;f[c>>2]=(f[c>>2]|0)+-1;return}function uCc(a){a=a|0;var b=0;if(!a)return;b=a;if((f[38449]|0)>>>0<=b>>>0&(f[38450]|0)>>>0>b>>>0){axc(f[38451]|0);sxc(1,1);f[a>>2]=f[38452];f[38452]=a;b=(f[38453]|0)+1|0;f[38453]=b;f[38454]=(b|0)<(f[38448]|0)&1;bxc(f[38451]|0);return}else{b=rxc(a)|0;axc(f[38451]|0);sxc(2,b);bxc(f[38451]|0);qxc(a);return}}function vCc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;c=f[a+36>>2]|0;j=a+52|0;d=f[j>>2]|0;if((c-b|0)>>>0<d>>>0){e=(b>>>0)%(d>>>0)|0;h=(c>>>0)%(d>>>0)|0}else{h=d>>>1;e=h;h=h+-1|0}i=a+56|0;g=a+48|0;d=e;while(1){c=(f[i>>2]|0)+(d<<2)|0;a:while(1){while(1){a=f[c>>2]|0;if(!a)break a;if((f[a+8>>2]|0)>>>0<b>>>0)break;f[g>>2]=(f[g>>2]|0)+-1;f[c>>2]=f[a+16>>2];if(f[a+24>>2]|0)rCc(a)|0;tCc(a)}c=a+16|0}if((d|0)==(h|0))break;d=((d+1|0)>>>0)%((f[j>>2]|0)>>>0)|0}return}function wCc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=(f[a+56>>2]|0)+(((b>>>0)%((f[a+52>>2]|0)>>>0)|0)<<2)|0;while(1){d=f[d>>2]|0;if(!d){e=7;break}if((f[d+8>>2]|0)==(b|0)){e=5;break}d=d+16|0}if((e|0)==5){if(!(f[d+24>>2]|0)){c=d;return c|0}rCc(d)|0;c=d;return c|0}else if((e|0)==7){if(!c){c=0;return c|0}c=xCc(a,b,c)|0;return c|0}return 0}function xCc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=f[a>>2]|0;n=a+48|0;i=f[n>>2]|0;g=f[a+44>>2]|0;h=i-g|0;j=(c|0)==1;if(j){if(h>>>0>=(f[l+12>>2]|0)>>>0){b=0;return b|0}if(h>>>0>=(f[a+32>>2]|0)>>>0){b=0;return b|0}if(g>>>0<h>>>0&(yCc(a)|0)!=0){b=0;return b|0}}k=a+52|0;if(i>>>0>=(f[k>>2]|0)>>>0)zCc(a);g=a+20|0;do if((f[g>>2]|0)!=0?(e=f[l+48>>2]|0,(d[e+14>>1]|0)==0):0){if(((f[n>>2]|0)+1|0)>>>0<(f[a+28>>2]|0)>>>0?(yCc(a)|0)==0:0){m=14;break}sCc(e,0);rCc(e)|0;c=e+20|0;h=f[c>>2]|0;if((f[h+16>>2]|0)==(f[a+16>>2]|0)){l=l+16|0;f[l>>2]=(f[g>>2]|0)-(f[h+20>>2]|0)+(f[l>>2]|0);break}else{tCc(e);m=14;break}}else m=14;while(0);do if((m|0)==14){c=ACc(a,j&1)|0;if(!c){b=0;return b|0}else{e=c;c=c+20|0;break}}while(0);m=(b>>>0)%((f[k>>2]|0)>>>0)|0;f[n>>2]=(f[n>>2]|0)+1;f[e+8>>2]=b;n=a+56|0;f[e+16>>2]=f[(f[n>>2]|0)+(m<<2)>>2];f[c>>2]=a;f[e+24>>2]=0;f[f[e+4>>2]>>2]=0;f[(f[n>>2]|0)+(m<<2)>>2]=e;c=a+36|0;if((f[c>>2]|0)>>>0>=b>>>0){b=e;return b|0}f[c>>2]=b;b=e;return b|0}function yCc(a){a=a|0;if(f[38447]|0?((f[a+12>>2]|0)+(f[a+8>>2]|0)|0)<=(f[38446]|0):0){a=f[38454]|0;return a|0}a=ECc()|0;return a|0}function zCc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;d=a+52|0;g=f[d>>2]|0;h=g<<1;h=h>>>0>256?h:256;if(g|0)tzc();g=DCc(h<<2,0)|0;if(f[d>>2]|0)uzc();if(!g)return;e=f[d>>2]|0;c=a+56|0;b=0;while(1){if((b|0)==(e|0))break;a=f[(f[c>>2]|0)+(b<<2)>>2]|0;while(1){if(!a)break;k=a+16|0;i=f[k>>2]|0;j=g+((((f[a+8>>2]|0)>>>0)%(h>>>0)|0)<<2)|0;f[k>>2]=f[j>>2];f[j>>2]=a;a=i}b=b+1|0}qxc(f[c>>2]|0);f[c>>2]=g;f[d>>2]=h;return}function ACc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;e=a+60|0;c=f[e>>2]|0;do if(!c){if((f[a+48>>2]|0)==0?BCc(a)|0:0){c=f[e>>2]|0;g=5;break}if(!b)c=CCc(f[a+16>>2]|0)|0;else{tzc();c=CCc(f[a+16>>2]|0)|0;uzc()}if(!c){g=0;return g|0}else{b=c+(f[a+8>>2]|0)|0;f[b>>2]=c;f[b+4>>2]=b+32;d[b+12>>1]=0;d[b+14>>1]=0;c=b;b=b+28|0;break}}else g=5;while(0);if((g|0)==5){b=c+16|0;f[e>>2]=f[b>>2]}f[b>>2]=0;g=f[a+4>>2]|0;f[g>>2]=(f[g>>2]|0)+1;g=c;return g|0}function BCc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0,i=0;if(!(f[38445]|0)){a=0;return a|0}i=a+28|0;if((f[i>>2]|0)>>>0<3){a=0;return a|0}tzc();b=f[38445]|0;if((b|0)>0){h=a+16|0;e=f[h>>2]|0;c=((e|0)<0)<<31>>31;g=Brd(e|0,c|0,b|0,((b|0)<0)<<31>>31|0)|0;b=e;e=G}else{g=Brd(b|0,((b|0)<0)<<31>>31|0,-1024,-1)|0;h=a+16|0;c=f[h>>2]|0;b=c;c=((c|0)<0)<<31>>31;e=G}b=Brd(b|0,c|0,f[i>>2]|0,0)|0;c=G;i=(e|0)>(c|0)|(e|0)==(c|0)&g>>>0>b>>>0;c=vxc(i?b:g,i?c:e)|0;f[a+64>>2]=c;uzc();if(!c)b=f[a+60>>2]|0;else{e=rxc(c)|0;h=f[h>>2]|0;i=f[a+8>>2]|0;g=a+60|0;e=(e|0)/(h|0)|0;b=f[g>>2]|0;while(1){a=b;b=c+i|0;f[b>>2]=c;f[b+4>>2]=b+32;d[b+12>>1]=1;d[b+14>>1]=0;f[b+16>>2]=a;f[b+28>>2]=0;e=e+-1|0;if(!e)break;else c=c+h|0}f[g>>2]=b}a=(b|0)!=0&1;return a|0}function CCc(a){a=a|0;var b=0,c=0;do if((f[38446]|0)>=(a|0)){axc(f[38451]|0);b=f[38452]|0;if(!b){bxc(f[38451]|0);break}f[38452]=f[b>>2];c=f[38453]|0;f[38453]=c+-1;f[38454]=(c|0)<=(f[38448]|0)&1;xxc(7,a);Axc(1,1);bxc(f[38451]|0);a=b;return a|0}while(0);b=vxc(a,((a|0)<0)<<31>>31)|0;if(!b){c=0;return c|0}c=rxc(b)|0;axc(f[38451]|0);xxc(7,a);Axc(2,c);bxc(f[38451]|0);c=b;return c|0}function DCc(a,b){a=a|0;b=b|0;b=vxc(a,b)|0;if(!b)return b|0;Mrd(b|0,0,a|0)|0;return b|0}function ECc(){return f[37672]|0}function FCc(){ICc(25216,4);return}function GCc(){ICc(24608,15);return}function HCc(){ICc(24144,8);return}function ICc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;g=0;while(1){if((g|0)>=(c|0))break;e=f[a+(g*40|0)+32>>2]|0;d=Mxc(e)|0;d=(d+(b[e>>0]|0)|0)%23|0;e=JCc(d,e)|0;if(!e){f[a+(g*40|0)+12>>2]=0;d=153848+(d<<2)|0;f[a+(g*40|0)+36>>2]=f[d>>2]}else{d=e+12|0;f[a+(g*40|0)+12>>2]=f[d>>2]}f[d>>2]=a+(g*40|0);g=g+1|0}return}function JCc(a,b){a=a|0;b=b|0;a=153848+(a<<2)|0;while(1){a=f[a>>2]|0;if(!a){a=0;b=5;break}if(!(wzc(f[a+32>>2]|0,b)|0)){b=5;break}a=a+36|0}if((b|0)==5)return a|0;return 0}function KCc(a,b,c){a=a|0;b=b|0;c=c|0;$Dc(a,118345,-1,0);return}function LCc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;d=h;e=Txc(f[c>>2]|0)|0;g=LDc(a)|0;f[d>>2]=0;if(0==0?(f[g+32>>2]&131072|0)==0:0){ODc(a,120542,-1);t=h;return}if((b|0)==2)b=Txc(f[c+4>>2]|0)|0;else b=0;if(!e){t=h;return}if(!(NEc(g,e,b,d)|0)){t=h;return}ODc(a,f[d>>2]|0,-1);qxc(f[d>>2]|0);t=h;return}function MCc(a,b,c){a=a|0;b=b|0;c=c|0;b=Txc(f[c>>2]|0)|0;if(!b)return;DDc(a,LEc(b)|0);return}function NCc(a,b,c){a=a|0;b=b|0;c=c|0;$Dc(a,JEc(fEc(f[c>>2]|0)|0)|0,-1,0);return}function OCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=f[d>>2]|0;if((GDc(e)|0)==5)return;g=Txc(e)|0;if(!g)return;e=NDc(f[d>>2]|0)|0;if((c|0)!=1){m=Txc(f[d+4>>2]|0)|0;if(!m)return;c=m;i=0;while(1){d=b[c>>0]|0;if(!(d<<24>>24))break;c=c+1|0;if((d&255)>191)while(1)if((b[c>>0]&-64)<<24>>24==-128)c=c+1|0;else break;i=i+1|0}if(i){l=Brd(i|0,0,5,0)|0;l=pEc(a,l,G)|0;if(!l)return;j=l+(i<<2)|0;k=0;c=m;while(1){if(!(b[c>>0]|0))break;f[l+(k<<2)>>2]=c;d=c+1|0;i=c;if((h[c>>0]|0)>191){c=d;while(1)if((b[c>>0]&-64)<<24>>24==-128)c=c+1|0;else break}else c=d;b[j+k>>0]=c-i;k=k+1|0}if(k){o=l;n=l;p=20}}}else{m=0;o=76560;j=120483;k=1;n=76560;p=20}if((p|0)==20){l=MDc(a)|0;a:do if(l&1)while(1){if((e|0)<=0)break a;c=0;while(1){if(c>>>0>=k>>>0)break a;d=b[j+c>>0]|0;i=d&255;if((e|0)>=(i|0)?(ocd(g,f[o+(c<<2)>>2]|0,i)|0)==0:0)break;c=c+1|0}p=d&255;g=g+p|0;e=e-p|0}while(0);b:do if(l&2)while(1){if((e|0)<=0)break b;c=0;while(1){if(c>>>0>=k>>>0)break b;d=h[j+c>>0]|0;if((e|0)>=(d|0)?(q=e-d|0,(ocd(g+q|0,f[o+(c<<2)>>2]|0,d)|0)==0):0)break;c=c+1|0}e=q}while(0);if(m)qxc(n)}$Dc(a,g,e,-1);return}function PCc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;h=((MDc(a)|0)!=0)<<31>>31;i=uEc(a)|0;if((GDc(f[c>>2]|0)|0)==5)return;d=1;e=0;while(1){if((d|0)>=(b|0))break;g=f[c+(d<<2)>>2]|0;if((GDc(g)|0)==5){j=7;break}g=((vEc(f[c+(e<<2)>>2]|0,g,i)|0)^h|0)>-1;g=g?d:e;d=d+1|0;e=g}if((j|0)==7)return;oEc(a,f[c+(e<<2)>>2]|0);return}function QCc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0;c=f[c>>2]|0;e=WDc(a,40)|0;if(!e)return;g=(GDc(c)|0)==5;b=(d[e+8>>1]|0)!=0;if(g){if(!b)return;IEc(a);return}if(!b){g=LDc(a)|0;f[e+32>>2]=g;qEc(e,c)|0;return}b=uEc(a)|0;g=(MDc(a)|0)!=0;b=vEc(e,c,b)|0;if(!(g&(b|0)<0)?!((b|0)>0&(g^1)):0){IEc(a);return}qEc(e,c)|0;return}function RCc(a){a=a|0;HEc(a,0);return}function SCc(a){a=a|0;HEc(a,1);return}function TCc(a,b,c){a=a|0;b=b|0;c=c|0;c=5536+((GDc(f[c>>2]|0)|0)+-1<<2)|0;$Dc(a,f[c>>2]|0,-1,0);return}function UCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;c=f[d>>2]|0;switch(GDc(c)|0){case 2:case 1:case 4:{DDc(a,NDc(c)|0);return}case 3:{c=Txc(c)|0;if(!c)return;e=c;d=c;a:while(1){c=e;do{e=b[c>>0]|0;if(!(e<<24>>24))break a;c=c+1|0}while((e&255)<=191);while(1){if((b[c>>0]&-64)<<24>>24!=-128)break;c=c+1|0;d=d+1|0}e=c}DDc(a,c-d|0);return}default:{EEc(a);return}}}function VCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c=f[d>>2]|0;e=GDc(c)|0;i=d+4|0;g=GDc(f[i>>2]|0)|0;if((e|0)==5|(g|0)==5)return;h=NDc(c)|0;k=NDc(f[i>>2]|0)|0;a:do if((k|0)>0){do if(!((e|0)==4&(g|0)==4)){c=f[d>>2]|0;if((e|0)!=4&(g|0)!=4){d=Txc(c)|0;e=1;g=Txc(f[i>>2]|0)|0;m=10;break}c=FEc(c)|0;e=Txc(c)|0;if(e){h=NDc(c)|0;d=FEc(f[i>>2]|0)|0;g=Txc(d)|0;if(!g)m=22;else{i=e;j=1;l=NDc(d)|0;e=d}}else{d=0;m=22}}else{d=gEc(f[d>>2]|0)|0;e=0;g=gEc(f[i>>2]|0)|0;m=10}while(0);if((m|0)==10)if((g|0)!=0?!((h|0)!=0&(d|0)==0):0){c=0;i=d;j=e;l=k;e=0}else{d=0;c=0;m=22}if((m|0)==22){ZDc(a);break}k=b[g>>0]|0;j=(j|0)==0;d=1;while(1){if((l|0)>(h|0)){d=0;m=20;break a}if((b[i>>0]|0)==k<<24>>24?(ocd(i,g,l)|0)==0:0){m=20;break a}d=d+1|0;do{h=h+-1|0;i=i+1|0;if(j)break}while((b[i>>0]&-64)<<24>>24==-128)}}else{e=0;c=0;d=1;m=20}while(0);if((m|0)==20){DDc(a,d);d=e}GEc(c);GEc(d);return}function WCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+48|0;j=k;e=k+32|0;g=k+8|0;h=LDc(a)|0;if((c|0)<=0){t=k;return}i=Txc(f[d>>2]|0)|0;if(!i){t=k;return}f[e>>2]=c+-1;f[e+4>>2]=0;f[e+8>>2]=d+4;fxc(g,h,0,0,f[h+112>>2]|0);b[g+21>>0]=2;f[j>>2]=e;cyc(g,i,j);j=f[g+16>>2]|0;$Dc(a,hxc(g)|0,j,808);t=k;return}function XCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+16|0;e=g;c=Txc(f[d>>2]|0)|0;f[e>>2]=c;if(!c){t=g;return}if(!(b[c>>0]|0)){t=g;return}DDc(a,QDc(e)|0);t=g;return}function YCc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=c<<2|1;o=XAc(o,((o|0)<0)<<31>>31)|0;if(!o){ZDc(a);return}m=o;n=0;while(1){if((n|0)>=(c|0))break;e=ryc(f[d+(n<<2)>>2]|0)|0;l=G;e=l>>>0>0|(l|0)==0&e>>>0>1114111?65533:e&2097151;if(e>>>0<128){h=m;g=1}else{if(e>>>0<2048){k=m;g=2;h=1;i=192;j=31}else{if(e>>>0<65536){i=m;g=3;h=2;j=1;k=224;l=15}else{b[m>>0]=e>>>18|240;i=m+1|0;g=4;h=3;j=2;k=128;l=63}b[i>>0]=e>>>12&l|k;k=m+j|0;i=128;j=63}b[k>>0]=e>>>6&j|i;h=m+h|0;e=e&63|128}b[h>>0]=e;m=m+g|0;n=n+1|0}d=m-o|0;hEc(a,o,d,((d|0)<0)<<31>>31,696,1);return}function ZCc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;b=f[c>>2]|0;switch(GDc(b)|0){case 1:{c=ryc(b)|0;b=G;do if((b|0)<0){if(!((c|0)==0&(b|0)==-2147483648)){c=wrd(0,0,c|0,b|0)|0;b=G;break}ODc(a,119828,-1);return}while(0);bEc(a,c,b);return}case 5:{EEc(a);return}default:{d=+myc(b);cEc(a,d<0.0?-d:d);return}}}function _Cc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,g=0,h=0,i=0;i=t;t=t+32|0;g=i+8|0;h=i;do if((b|0)==2){b=f[c+4>>2]|0;if((GDc(b)|0)==5){t=i;return}else{e=fEc(b)|0;e=(e|0)<30?e:30;e=(e|0)>0?e:0;break}}else e=0;while(0);b=f[c>>2]|0;if((GDc(b)|0)==5){t=i;return}d=+myc(b);p[h>>3]=d;do if(!(d<-4503599627370496.0|d>4503599627370496.0)){if(!e){d=d+(d<0.0?-.5:.5);d=+(~~d>>>0>>>0)+4294967296.0*+((+I(d)>=1.0?(d>0.0?~~+W(+H(d/4294967296.0),4294967295.0)>>>0:~~+U((d-+(~~d>>>0))/4294967296.0)>>>0):0)|0);p[h>>3]=d;break}f[g>>2]=e;p[g+8>>3]=d;b=WAc(120450,g)|0;if(b|0){pyc(b,h,Mxc(b)|0,1)|0;qxc(b);d=+p[h>>3];break}ZDc(a);t=i;return}while(0);cEc(a,d);t=i;return}function $Cc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=Txc(f[d>>2]|0)|0;e=NDc(f[d>>2]|0)|0;if(!g)return;d=vrd(e|0,((e|0)<0)<<31>>31|0,1,0)|0;d=pEc(a,d,G)|0;if(!d)return;c=0;while(1){if((c|0)>=(e|0))break;h=b[g+c>>0]|0;b[d+c>>0]=h&~(b[1424+(h&255)>>0]&32);c=c+1|0}$Dc(a,d,e,696);return}function aDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=Txc(f[d>>2]|0)|0;e=NDc(f[d>>2]|0)|0;if(!g)return;d=vrd(e|0,((e|0)<0)<<31>>31|0,1,0)|0;d=pEc(a,d,G)|0;if(!d)return;c=0;while(1){if((c|0)>=(e|0))break;b[d+c>>0]=b[1680+(h[g+c>>0]|0)>>0]|0;c=c+1|0}$Dc(a,d,e,696);return}function bDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0;c=gEc(f[d>>2]|0)|0;i=NDc(f[d>>2]|0)|0;g=Hrd(i|0,((i|0)<0)<<31>>31|0,1)|0;g=pEc(a,g|1,G)|0;if(!g)return;d=0;e=g;while(1){if((d|0)>=(i|0))break;j=h[c>>0]|0;b[e>>0]=b[26416+(j>>>4)>>0]|0;b[e+1>>0]=b[26416+(j&15)>>0]|0;d=d+1|0;e=e+2|0;c=c+1|0}b[e>>0]=0;$Dc(a,g,i<<1,696);return}function cDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=t;t=t+16|0;b=e;$Ac(8,b);d=b;c=f[d>>2]|0;d=f[d+4>>2]|0;if((d|0)>=0){bEc(a,c,d);t=e;return}c=wrd(0,0,c|0,d&2147483647|0)|0;d=G;f[b>>2]=c;f[b+4>>2]=d;bEc(a,c,d);t=e;return}function dDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;b=ryc(f[c>>2]|0)|0;c=G;d=(c|0)>0|(c|0)==0&b>>>0>1;b=d?b:1;c=pEc(a,b,d?c:0)|0;if(!c)return;$Ac(b,c);DEc(a,c,b,696);return}function eDc(a,b,c){a=a|0;b=b|0;c=c|0;b=uEc(a)|0;if(!(vEc(f[c>>2]|0,f[c+4>>2]|0,b)|0))return;oEc(a,f[c>>2]|0);return}function fDc(a,b,c){a=a|0;b=b|0;c=c|0;$Dc(a,118432,-1,0);return}function gDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;b=t;t=t+16|0;a=b;d=fEc(f[c>>2]|0)|0;c=Txc(f[c+4>>2]|0)|0;f[a>>2]=c;dxc(d,118856,a);t=b;return}function hDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0.0,k=0,l=0,m=0,n=0;n=t;t=t+80|0;k=n+72|0;i=n+64|0;e=n+56|0;g=n;c=f[d>>2]|0;switch(GDc(c)|0){case 2:{j=+myc(c);p[i>>3]=j;OAc(50,g,118551,i)|0;pyc(g,e,20,1)|0;if(j!=+p[e>>3]){p[k>>3]=j;OAc(50,g,120443,k)|0}$Dc(a,g,-1,-1);t=n;return}case 1:{oEc(a,c);t=n;return}case 4:{i=gEc(c)|0;e=NDc(f[d>>2]|0)|0;g=pEc(a,vrd(Hrd(e|0,((e|0)<0)<<31>>31|0,1)|0,G|0,4,0)|0,G)|0;if(!g){t=n;return}c=0;while(1){if((c|0)>=(e|0))break;l=i+c|0;m=c<<1;b[g+(m+2)>>0]=b[26416+((h[l>>0]|0)>>>4)>>0]|0;b[g+(m+3)>>0]=b[26416+(b[l>>0]&15)>>0]|0;c=c+1|0}m=e<<1;b[g+(m+2)>>0]=39;b[g+(m+3)>>0]=0;b[g>>0]=88;b[g+1>>0]=39;$Dc(a,g,-1,-1);qxc(g);t=n;return}case 3:{m=Txc(c)|0;if(!m){t=n;return}g=0;c=0;e=0;a:while(1){switch(b[m+g>>0]|0){case 0:break a;case 39:{c=vrd(c|0,e|0,1,0)|0;e=G;break}default:{}}g=g+1|0}l=vrd(c|0,e|0,g+3|0,0)|0;l=pEc(a,l,G)|0;if(!l){t=n;return}b[l>>0]=39;c=1;d=0;while(1){e=m+d|0;g=b[e>>0]|0;i=c+1|0;k=l+c|0;if(!(g<<24>>24))break;b[k>>0]=g;if((b[e>>0]|0)==39){b[l+i>>0]=39;c=c+2|0}else c=i;d=d+1|0}b[k>>0]=39;b[l+i>>0]=0;$Dc(a,l,i,696);t=n;return}default:{$Dc(a,118535,4,0);t=n;return}}}function iDc(a,b,c){a=a|0;b=b|0;c=c|0;c=tEc(LDc(a)|0)|0;bEc(a,c,G);return}function jDc(a,b,c){a=a|0;b=b|0;c=c|0;DDc(a,sEc(LDc(a)|0)|0);return}function kDc(a,b,c){a=a|0;b=b|0;c=c|0;DDc(a,rEc(LDc(a)|0)|0);return}function lDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;e=LDc(a)|0;x=Txc(f[d>>2]|0)|0;if(!x)return;y=NDc(f[d>>2]|0)|0;c=d+4|0;w=Txc(f[c>>2]|0)|0;if(!w)return;if(!(b[w>>0]|0)){oEc(a,f[d>>2]|0);return}v=NDc(f[c>>2]|0)|0;c=d+8|0;u=Txc(f[c>>2]|0)|0;if(!u)return;p=NDc(f[c>>2]|0)|0;d=y+1|0;g=((d|0)<0)<<31>>31;c=pEc(a,d,g)|0;if(!c)return;q=y-v|0;r=(p|0)>(v|0);s=p-v|0;t=((s|0)<0)<<31>>31;l=e+112|0;m=v+-1|0;n=~y;o=((n|0)<0)<<31>>31;k=c;j=0;h=0;i=0;while(1){if((i|0)>(q|0)){c=20;break}c=x+i|0;e=b[c>>0]|0;if(e<<24>>24==(b[w>>0]|0)?(ocd(c,w,v)|0)==0:0){if(r){d=vrd(d|0,g|0,s|0,t|0)|0;g=G;c=vrd(d|0,g|0,-1,-1)|0;A=G;e=f[l>>2]|0;z=((e|0)<0)<<31>>31;if((A|0)>(z|0)|(A|0)==(z|0)&c>>>0>e>>>0){c=14;break}e=j+1|0;if(!(e&j)){A=Frd(0,d|0,32)|0;c=G;z=vrd(d|0,g|0,n|0,o|0)|0;c=vrd(z|0,G|0,A|0,c|0)|0;c=Pxc(k,c,G)|0;if(!c){c=17;break}}else c=k}else{c=k;e=j}Krd(c+h|0,u|0,p|0)|0;h=h+p|0;i=m+i|0}else{b[k+h>>0]=e;h=h+1|0;c=k;e=j}k=c;j=e;i=i+1|0}if((c|0)==14){YDc(a);qxc(k);return}else if((c|0)==17){ZDc(a);qxc(k);return}else if((c|0)==20){A=y-i|0;Krd(k+h|0,x+i|0,A|0)|0;A=h+A|0;b[k+A>>0]=0;$Dc(a,k,A,696);return}}function mDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=ryc(f[c>>2]|0)|0;b=G;c=(b|0)>0|(b|0)==0&d>>>0>0;b=kEc(a,c?d:0,c?b:0)|0;if(!b)return;lEc(a,b);return}function nDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=f[d+4>>2]|0;if((GDc(e)|0)==5)return;i=(c|0)==3;if(i?(GDc(f[d+8>>2]|0)|0)==5:0)return;m=GDc(f[d>>2]|0)|0;j=fEc(e)|0;k=((j|0)<0)<<31>>31;m=(m|0)==4;c=f[d>>2]|0;a:do if(m){e=NDc(c)|0;c=gEc(f[d>>2]|0)|0;if(!c)return}else{c=Txc(c)|0;if(!c)return;if((j|0)<0){h=0;e=c;while(1){g=b[e>>0]|0;if(!(g<<24>>24)){e=h;break a}e=e+1|0;if((g&255)>191)while(1)if((b[e>>0]&-64)<<24>>24==-128)e=e+1|0;else break;h=h+1|0}}else e=0}while(0);if(i){g=fEc(f[d+8>>2]|0)|0;h=((g|0)<0)<<31>>31;l=(g|0)<0;i=wrd(0,0,g|0,h|0)|0;d=g>>>31;g=l?i:g;h=l?G:h}else{h=(LDc(a)|0)+112|0;h=f[h>>2]|0;d=0;g=h;h=((h|0)<0)<<31>>31}do if((j|0)>=0)if(!j){j=((h|0)>0|(h|0)==0&g>>>0>0)<<31>>31;g=vrd(g|0,h|0,j|0,((j|0)<0)<<31>>31|0)|0;j=0;k=0;i=G;break}else{j=vrd(j|0,k|0,-1,-1)|0;k=G;i=h;break}else{j=vrd(e|0,((e|0)<0)<<31>>31|0,j|0,k|0)|0;k=G;n=(k|0)<0;o=vrd(g|0,h|0,j|0,k|0)|0;i=G;l=(i|0)>0|(i|0)==0&o>>>0>0;j=n?0:j;k=n?0:k;g=n?(l?o:0):g;i=n?(l?i:0):h}while(0);n=(d|0)==0;h=wrd(j|0,k|0,g|0,i|0)|0;l=G;o=(l|0)<0;h=n?j:o?0:h;l=n?k:o?0:l;d=n?g:o?j:g;i=n?i:o?k:i;if(m){m=vrd(h|0,l|0,d|0,i|0)|0;n=G;o=((e|0)<0)<<31>>31;m=(n|0)>(o|0)|(n|0)==(o|0)&m>>>0>e>>>0;l=wrd(e|0,o|0,h|0,l|0)|0;o=G;n=(o|0)>0|(o|0)==0&l>>>0>0;iEc(a,c+h|0,m?(n?l:0):d,m?(n?o:0):i,-1);return}e=l;while(1){g=b[c>>0]|0;if(!(((h|0)!=0|(e|0)!=0)&g<<24>>24!=0))break;c=c+1|0;if((g&255)>191)while(1)if((b[c>>0]&-64)<<24>>24==-128)c=c+1|0;else break;o=vrd(h|0,e|0,-1,-1)|0;h=o;e=G}e=c;while(1){if(!(g<<24>>24!=0&((d|0)!=0|(i|0)!=0)))break;h=e+1|0;if((g&255)>191){e=h;while(1){g=b[e>>0]|0;if((g&-64)<<24>>24==-128)e=e+1|0;else break}}else{e=h;g=b[h>>0]|0}o=vrd(d|0,i|0,-1,-1)|0;d=o;i=G}o=e-c|0;hEc(a,c,o,((o|0)<0)<<31>>31,-1,1);return}function oDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0.0;g=WDc(a,32)|0;c=CDc(f[d>>2]|0)|0;if(!((g|0)!=0&(c|0)!=5))return;a=g+16|0;e=a;e=vrd(f[e>>2]|0,f[e+4>>2]|0,1,0)|0;f[a>>2]=e;f[a+4>>2]=G;a=f[d>>2]|0;if((c|0)!=1){h=+myc(a);p[g>>3]=h+ +p[g>>3];b[g+25>>0]=1;return}a=ryc(a)|0;c=G;p[g>>3]=+p[g>>3]+(+(a>>>0)+4294967296.0*+(c|0));d=g+25|0;e=g+24|0;if((b[e>>0]|b[d>>0])<<24>>24)return;if(!(eEc(g+8|0,a,c)|0))return;b[e>>0]=1;b[d>>0]=1;return}function pDc(a){a=a|0;var c=0,d=0,e=0;c=WDc(a,0)|0;if(!c)return;d=c+16|0;e=f[d+4>>2]|0;if(!((e|0)>0|(e|0)==0&(f[d>>2]|0)>>>0>0))return;if(b[c+24>>0]|0){ODc(a,119828,-1);return}if(!(b[c+25>>0]|0)){e=c+8|0;bEc(a,f[e>>2]|0,f[e+4>>2]|0);return}else{cEc(a,+p[c>>3]);return}}function qDc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0.0;a=WDc(a,32)|0;c=CDc(f[d>>2]|0)|0;if(!((a|0)!=0&(c|0)!=5))return;e=a+16|0;g=e;g=vrd(f[g>>2]|0,f[g+4>>2]|0,-1,-1)|0;f[e>>2]=g;f[e+4>>2]=G;if((c|0)==1?(b[a+25>>0]|0)==0:0){d=ryc(f[d>>2]|0)|0;e=G;p[a>>3]=+p[a>>3]-(+(d>>>0)+4294967296.0*+(e|0));g=a+8|0;c=g;e=wrd(f[c>>2]|0,f[c+4>>2]|0,d|0,e|0)|0;f[g>>2]=e;f[g+4>>2]=G;return}h=+myc(f[d>>2]|0);p[a>>3]=+p[a>>3]-h;return}function rDc(a){a=a|0;var b=0,c=0.0;b=WDc(a,0)|0;if(!b)c=0.0;else c=+p[b>>3];cEc(a,c);return}function sDc(a){a=a|0;var b=0,c=0,d=0;b=WDc(a,0)|0;if(!b)return;d=b+16|0;c=f[d>>2]|0;d=f[d+4>>2]|0;if(!((d|0)>0|(d|0)==0&c>>>0>0))return;cEc(a,+p[b>>3]/(+(c>>>0)+4294967296.0*+(d|0)));return}function tDc(a,b,c){a=a|0;b=b|0;c=c|0;a=WDc(a,8)|0;if(!b){if(!a)return}else if(!((a|0)!=0&(GDc(f[c>>2]|0)|0)!=5))return;b=a;b=vrd(f[b>>2]|0,f[b+4>>2]|0,1,0)|0;c=a;f[c>>2]=b;f[c+4>>2]=G;return}function uDc(a){a=a|0;var b=0,c=0;b=WDc(a,0)|0;if(!b){b=0;c=0}else{c=b;b=f[c+4>>2]|0;c=f[c>>2]|0}bEc(a,c,b);return}function vDc(a,b,c){a=a|0;b=b|0;c=c|0;a=WDc(a,8)|0;if(!b){if(!a)return}else if(!((a|0)!=0&(GDc(f[c>>2]|0)|0)!=5))return;b=a;b=vrd(f[b>>2]|0,f[b+4>>2]|0,-1,-1)|0;c=a;f[c>>2]=b;f[c+4>>2]=G;return}function wDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;if((GDc(f[c>>2]|0)|0)==5)return;d=WDc(a,24)|0;if(!d)return;g=LDc(a)|0;e=d+12|0;a=(f[e>>2]|0)==0;f[e>>2]=f[g+112>>2];do if(!a){if((b|0)==2){b=c+4|0;a=Txc(f[b>>2]|0)|0;b=NDc(f[b>>2]|0)|0;if(!a)break}else{b=1;a=119826}Dxc(d,a,b)}while(0);b=Txc(f[c>>2]|0)|0;a=NDc(f[c>>2]|0)|0;if(!b)return;Dxc(d,b,a);return}function xDc(a){a=a|0;var c=0;c=WDc(a,0)|0;if(!c)return;switch(b[c+20>>0]|0){case 18:{YDc(a);return}case 7:{ZDc(a);return}default:{$Dc(a,hxc(c)|0,-1,696);return}}}function yDc(a){a=a|0;var c=0;c=WDc(a,0)|0;if(!c)return;switch(b[c+20>>0]|0){case 18:{YDc(a);return}case 7:{ZDc(a);return}default:{$Dc(a,_Dc(c)|0,-1,-1);return}}}function zDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((GDc(f[c>>2]|0)|0)==5)return;e=WDc(a,24)|0;if(!e)return;d=NDc(f[c>>2]|0)|0;if((b|0)==2)a=NDc(f[c+4>>2]|0)|0;else a=1;a=a+d|0;b=e+16|0;c=f[b>>2]|0;if((c|0)>(a|0)){d=c-a|0;f[b>>2]=d;c=f[e+4>>2]|0;Lrd(c|0,c+a|0,d|0)|0;if(f[b>>2]|0)return}else f[b>>2]=0;f[e+12>>2]=0;return}function ADc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0;j=t;t=t+16|0;i=j+4|0;g=j;k=LDc(a)|0;e=MDc(a)|0;l=NDc(f[d>>2]|0)|0;if((l|0)>(f[k+144>>2]|0)){ODc(a,119725,-1);t=j;return}a:do if((c|0)==3){c=Txc(f[d+8>>2]|0)|0;f[g>>2]=c;do if(c|0){if((PDc(c,-1)|0)!=1){ODc(a,119758,-1);break}c=QDc(g)|0;if(!((c|0)!=(h[e>>0]|0|0)?(c|0)!=(h[e+1>>0]|0|0):0)){e=h[e>>0]|h[e+1>>0]<<8|h[e+2>>0]<<16|h[e+3>>0]<<24;f[i>>2]=e;if((c|0)==(e&255|0))b[i>>0]=0;if((c|0)==(e>>>8&255|0)){b[i+1>>0]=0;e=i}else e=i}i=c;break a}while(0);t=j;return}else i=h[e+2>>0]|0;while(0);g=Txc(f[d>>2]|0)|0;c=Txc(f[d+4>>2]|0)|0;if(!((g|0)!=0&(c|0)!=0)){t=j;return}DDc(a,(RDc(g,c,e,i)|0)==0&1);t=j;return}function BDc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;if(((CDc(f[c>>2]|0)|0)+-1|0)>>>0>1)return;d=+myc(f[c>>2]|0);DDc(a,d<0.0?-1:d>0.0&1);return}function CDc(a){a=a|0;var b=0;b=GDc(a)|0;if((b|0)!=3)return b|0;HDc(a,0);b=GDc(a)|0;return b|0}function DDc(a,b){a=a|0;b=b|0;EDc(f[a>>2]|0,b,((b|0)<0)<<31>>31);return}function EDc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0;e=a+8|0;if(!(d[e>>1]&9216)){f[a>>2]=b;f[a+4>>2]=c;d[e>>1]=4;return}else{FDc(a,b,c);return}}function FDc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0;fyc(a);e=a;f[e>>2]=b;f[e+4>>2]=c;d[a+8>>1]=4;return}function GDc(a){a=a|0;return h[5344+(d[a+8>>1]&63)>>0]|0|0}function HDc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0.0,i=0,j=0;j=t;t=t+16|0;e=j;g=pyc(f[a+16>>2]|0,e,f[a+12>>2]|0,b[a+10>>0]|0)|0;if((g|0)<1){t=j;return}h=+p[e>>3];if((g|0)==1?(IDc(a,h,a)|0)!=0:0){g=a+8|0;e=d[g>>1]|4;d[g>>1]=e}else{p[a>>3]=h;i=a+8|0;e=d[i>>1]|8;d[i>>1]=e;if(!c)g=i;else{JDc(a);g=i;e=d[i>>1]|0}}d[g>>1]=e&-3;t=j;return}function IDc(a,c,d){a=a|0;c=+c;d=d|0;var e=0,g=0;e=~~c>>>0;g=+I(c)>=1.0?(c>0.0?~~+W(+H(c/4294967296.0),4294967295.0)>>>0:~~+U((c-+(~~c>>>0))/4294967296.0)>>>0):0;if(!(KDc(c,e,g)|0)){g=(vyc(f[a+16>>2]|0,d,f[a+12>>2]|0,b[a+10>>0]|0)|0)==0&1;return g|0}else{f[d>>2]=e;f[d+4>>2]=g;g=1;return g|0}return 0}function JDc(a){a=a|0;var b=0,c=0,e=0.0,g=0,h=0;e=+p[a>>3];b=tyc(e)|0;c=G;g=vrd(b|0,c|0,1,-2147483648)|0;h=G;if(!((h>>>0>0|(h|0)==0&g>>>0>1)&e==+(b>>>0)+4294967296.0*+(c|0)))return;h=a;f[h>>2]=b;f[h+4>>2]=c;h=a+8|0;d[h>>1]=d[h>>1]&15936|4;return}function KDc(a,b,c){a=+a;b=b|0;c=c|0;var d=0,e=0,f=0;f=t;t=t+16|0;d=f;e=f+8|0;p[d>>3]=a;p[e>>3]=+(b>>>0)+4294967296.0*+(c|0);if(a==0.0){e=1;t=f;return e|0}e=(ocd(d,e,8)|0)==0;d=vrd(b|0,c|0,0,524288)|0;c=G;e=(c>>>0<1048576|(c|0)==1048576&d>>>0<0)&e&1;t=f;return e|0}function LDc(a){a=a|0;return f[(f[a>>2]|0)+32>>2]|0}function MDc(a){a=a|0;return f[(f[a+4>>2]|0)+8>>2]|0}function NDc(a){a=a|0;return UDc(a,1)|0}function ODc(a,b,c){a=a|0;b=b|0;c=c|0;f[a+20>>2]=1;SDc(f[a>>2]|0,b,c,1,-1)|0;return}function PDc(a,c){a=a|0;c=c|0;var d=0,e=0;e=(c|0)>-1?a+c|0:-1;c=a;d=0;while(1){a=b[c>>0]|0;if(!(c>>>0<e>>>0&a<<24>>24!=0))break;c=c+1|0;if((a&255)>191)while(1)if((b[c>>0]&-64)<<24>>24==-128)c=c+1|0;else break;d=d+1|0}return d|0}function QDc(a){a=a|0;var c=0,d=0,e=0;e=f[a>>2]|0;c=e+1|0;f[a>>2]=c;e=b[e>>0]|0;d=e&255;if((e&255)<=191)return d|0;d=h[1360+(d+-192)>>0]|0;while(1){if((b[c>>0]&-64)<<24>>24!=-128)break;e=c+1|0;f[a>>2]=e;d=d<<6|b[c>>0]&63;c=e}return ((d&-2|0)==65534|(d>>>0<128|(d&-2048|0)==55296)?65533:d)|0}function RDc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=t;t=t+16|0;B=D+4|0;C=D;y=D+8|0;f[B>>2]=a;f[C>>2]=c;j=b[d+1>>0]|0;u=j&255;r=h[d>>0]|0;s=d+2|0;w=(b[d+3>>0]|0)==0;i=0;a:while(1){while(1){a=f[B>>2]|0;c=b[a>>0]|0;if(c<<24>>24>-1){f[B>>2]=a+1;a=c&255}else a=QDc(B)|0;if(!a){x=69;break a}if((a|0)==(r|0)){x=8;break a}if((a|0)!=(e|0)){k=a;l=i;break}if(!(b[s>>0]|0)){x=46;break}g=QDc(C)|0;if(!g){v=1;x=71;break a}a=QDc(B)|0;if((a|0)==94){c=1;a=QDc(B)|0}else c=0;if((a|0)==93){n=0;p=(g|0)==93&1;x=53}else{m=0;o=0;q=a}b:while(1){if((x|0)==53){x=0;m=n;o=p;q=QDc(B)|0}switch(q|0){case 0:{v=1;x=71;break a}case 93:break b;case 45:{x=b[f[B>>2]>>0]|0;if(x<<24>>24!=93?(m|0)!=0&x<<24>>24!=0:0){p=g>>>0<m>>>0|g>>>0>(QDc(B)|0)>>>0;n=0;p=p?o:1;x=53;continue b}break}default:{}}n=q;p=(g|0)==(q|0)?1:o;x=53}if((o|0)==(c|0)){v=1;x=71;break a}}if((x|0)==46){x=0;a=QDc(B)|0;if(!a){v=1;x=71;break}k=a;l=f[B>>2]|0}a=f[C>>2]|0;c=b[a>>0]|0;if(c<<24>>24>-1){f[C>>2]=a+1;a=c&255}else a=QDc(C)|0;do if((k|0)!=(a|0)){if(!w?((a|k)>>>0<128?(b[1680+(k&255)>>0]|0)==(b[1680+(a&255)>>0]|0):0):0)break;if((k|0)!=(u|0)){v=1;x=71;break a}if(!(a|0?(f[B>>2]|0)!=(l|0):0)){v=1;x=71;break a}}while(0);i=l}if((x|0)==8){g=j<<24>>24!=0;while(1){a=f[B>>2]|0;c=b[a>>0]|0;if(c<<24>>24>-1){f[B>>2]=a+1;i=c&255}else i=QDc(B)|0;a=(i|0)==(u|0);if(!((i|0)==(r|0)|g&a))break;if(a?(QDc(C)|0)==0:0){v=2;x=71;break}}if((x|0)==71){t=D;return v|0}if(!i){C=0;t=D;return C|0}do if((i|0)==(e|0)){if(!(b[s>>0]|0)){a=QDc(B)|0;if(!a)v=2;else{i=a;break}t=D;return v|0}c=f[C>>2]|0;while(1){if(!(b[c>>0]|0)){a=2;break}a=RDc((f[B>>2]|0)+-1|0,c,d,e)|0;if((a|0)!=1)break;a=c+1|0;if((h[c>>0]|0)>191)while(1)if((b[a>>0]&-64)<<24>>24==-128)a=a+1|0;else break;c=a}f[C>>2]=c;C=a;t=D;return C|0}while(0);if(i>>>0<129){if(w){b[y>>0]=i;a=0}else{a=i&255;b[y>>0]=i&(~(b[1424+a>>0]&32)&255);a=b[1680+a>>0]|0;b[y+2>>0]=0}b[y+1>>0]=a;a=f[B>>2]|0;c=f[C>>2]|0;while(1){g=c+(Red(c,y)|0)|0;if(!(b[g>>0]|0)){x=33;break}c=g+1|0;z=RDc(a,c,d,e)|0;if((z|0)!=1){x=35;break}}if((x|0)==33){f[C>>2]=g;C=2;t=D;return C|0}else if((x|0)==35){f[C>>2]=c;C=z;t=D;return C|0}}else{g=f[B>>2]|0;while(1){a=f[C>>2]|0;c=b[a>>0]|0;if(c<<24>>24>-1){f[C>>2]=a+1;a=c&255}else a=QDc(C)|0;if(!a){v=2;x=71;break}if((a|0)==(i|0)?(A=RDc(g,f[C>>2]|0,d,e)|0,(A|0)!=1):0){v=A;x=71;break}}if((x|0)==71){t=D;return v|0}}}else if((x|0)==69){C=(b[f[C>>2]>>0]|0)!=0&1;t=D;return C|0}else if((x|0)==71){t=D;return v|0}return 0}function SDc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;if(!c){fyc(a);m=0;return m|0}m=a+32|0;j=f[m>>2]|0;if(!j)k=1e9;else k=f[j+112>>2]|0;l=g<<24>>24==0;i=l?16:2;if((e|0)<0){a:do if(g<<24>>24==1)e=(udd(c)|0)&2147483647;else{e=0;while(1){if((e|0)>(k|0))break a;if(!((b[c+(e|1)>>0]|b[c+e>>0])<<24>>24))break a;e=e+2|0}}while(0);i=i|512}do if((h|0)==(-1|0)){h=((i&512)==0?0:g<<24>>24==1?1:2)+e|0;if((e|0)>(k|0)){mxc(j,18)|0;m=18;return m|0}if(!($xc(a,h>>>0>32?h:32)|0)){Krd(f[a+16>>2]|0,c|0,h|0)|0;break}else{m=7;return m|0}}else{kyc(a);f[a+16>>2]=c;if((h|0)==808){f[a+20>>2]=c;j=txc(f[m>>2]|0,c)|0;f[a+24>>2]=j;break}else{f[a+36>>2]=h;i=(((h|0)==0?2048:1024)|i&65535)&65535;break}}while(0);f[a+12>>2]=e;d[a+8>>1]=i;if(!l){b[a+10>>0]=g;if(g<<24>>24!=1?TDc(a)|0:0){m=7;return m|0}}else b[a+10>>0]=b[(f[m>>2]|0)+80>>0]|0;m=(e|0)>(k|0)?18:0;return m|0}function TDc(a){a=a|0;var c=0,e=0,g=0,h=0,i=0;g=a+12|0;if((f[g>>2]|0)<=1){h=0;return h|0}h=a+16|0;e=f[h>>2]|0;c=b[e>>0]|0;e=b[e+1>>0]|0;if(!(c<<24>>24==-1&e<<24>>24==-2))if(c<<24>>24==-2&e<<24>>24==-1)c=3;else{h=0;return h|0}else c=2;e=Yxc(a)|0;if(e|0){h=e;return h|0}e=(f[g>>2]|0)+-2|0;f[g>>2]=e;i=f[h>>2]|0;Lrd(i|0,i+2|0,e|0)|0;b[(f[h>>2]|0)+(f[g>>2]|0)>>0]=0;b[(f[h>>2]|0)+((f[g>>2]|0)+1)>>0]=0;h=a+8|0;d[h>>1]=d[h>>1]|512;b[a+10>>0]=c;h=0;return h|0}function UDc(a,c){a=a|0;c=c|0;var e=0,g=0;e=d[a+8>>1]|0;if(e&2?(b[a+10>>0]|0)==c<<24>>24:0){a=f[a+12>>2]|0;return a|0}g=e&65535;if(!(g&16)){if(g&1|0){a=0;return a|0}a=VDc(a,c)|0;return a|0}else{e=f[a+12>>2]|0;if(!(g&16384)){a=e;return a|0}a=(f[a>>2]|0)+e|0;return a|0}return 0}function VDc(a,b){a=a|0;b=b|0;if(!(Vxc(a,b)|0)){b=0;return b|0}b=f[a+12>>2]|0;return b|0}function WDc(a,b){a=a|0;b=b|0;var c=0;c=f[a+8>>2]|0;if(!(d[c+8>>1]&8192)){c=XDc(a,b)|0;return c|0}else{c=f[c+16>>2]|0;return c|0}return 0}function XDc(a,b){a=a|0;b=b|0;var c=0;c=f[a+8>>2]|0;if((b|0)<1){fyc(c);f[c+16>>2]=0;b=0;return b|0}$xc(c,b)|0;d[c+8>>1]=8192;f[c>>2]=f[a+4>>2];c=c+16|0;a=f[c>>2]|0;if(!a){b=0;return b|0}Mrd(a|0,0,b|0)|0;b=f[c>>2]|0;return b|0}function YDc(a){a=a|0;f[a+20>>2]=18;SDc(f[a>>2]|0,119803,-1,1,0)|0;return}function ZDc(a){a=a|0;fyc(f[a>>2]|0);f[a+20>>2]=7;Cxc(f[(f[a>>2]|0)+32>>2]|0);return}function _Dc(a){a=a|0;var c=0;if(!a){c=0;return c|0}c=f[a+16>>2]|0;if(!c){c=0;return c|0}a=a+4|0;b[(f[a>>2]|0)+c>>0]=0;c=f[a>>2]|0;return c|0}function $Dc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aEc(a,b,c,1,d);return}function aEc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;if((SDc(f[a>>2]|0,b,c,d,e)|0)!=18)return;YDc(a);return}function bEc(a,b,c){a=a|0;b=b|0;c=c|0;EDc(f[a>>2]|0,b,c);return}function cEc(a,b){a=a|0;b=+b;dEc(f[a>>2]|0,b);return}function dEc(a,b){a=a|0;b=+b;fyc(a);if(Hxc(b)|0)return;p[a>>3]=b;d[a+8>>1]=8;return}function eEc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;e=a;d=f[e>>2]|0;e=f[e+4>>2]|0;if((c|0)>-1|(c|0)==-1&b>>>0>4294967295){g=wrd(-1,2147483647,d|0,e|0)|0;h=G;if(((e|0)>0|(e|0)==0&d>>>0>0)&((h|0)<(c|0)|(h|0)==(c|0)&g>>>0<b>>>0)){h=1;return h|0}}else if((e|0)<0?(g=wrd(1,-2147483648,d|0,e|0)|0,j=G,h=vrd(b|0,c|0,1,0)|0,i=G,(j|0)>(i|0)|(j|0)==(i|0)&g>>>0>h>>>0):0){j=1;return j|0}i=vrd(d|0,e|0,b|0,c|0)|0;j=a;f[j>>2]=i;f[j+4>>2]=G;j=0;return j|0}function fEc(a){a=a|0;a=syc(a)|0;return a|0}function gEc(a){a=a|0;var b=0,c=0,e=0;e=a+8|0;b=d[e>>1]|0;c=b&65535;if(!(c&18)){e=Txc(a)|0;return e|0}do if(c&16384)if(!(Wxc(a)|0)){b=d[e>>1]|0;break}else{e=0;return e|0}while(0);d[e>>1]=b|16;if(!(f[a+12>>2]|0)){e=0;return e|0}e=f[a+16>>2]|0;return e|0}function hEc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;if(d>>>0>0|(d|0)==0&c>>>0>2147483647){jEc(b,e,a);return}else{aEc(a,b,c,f<<24>>24==4?2:f,e);return}}function iEc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;if(d>>>0>0|(d|0)==0&c>>>0>2147483647){jEc(b,e,a);return}else{aEc(a,b,c,0,e);return}}function jEc(a,b,c){a=a|0;b=b|0;c=c|0;switch(b|0){case 0:case -1:break;default:Hd[b&1023](a)}if(!c)return;YDc(c);return}function kEc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;a=f[a>>2]|0;d=f[(f[a+32>>2]|0)+112>>2]|0;e=((d|0)<0)<<31>>31;if(e>>>0<c>>>0|(e|0)==(c|0)&d>>>0<b>>>0){e=18;return e|0}nEc(a,b);e=0;return e|0}function lEc(a,b){a=a|0;b=b|0;f[a+20>>2]=(b|0)==0?-1:b;a=f[a>>2]|0;if(!(d[a+8>>1]&1))return;SDc(a,mEc(b)|0,-1,1,0)|0;return}function mEc(a){a=a|0;switch(a|0){case 516:{a=119904;break}case 100:{a=119882;break}case 101:{a=119859;break}default:{a=a&255;if(a>>>0<29?(515833851>>>a&1|0)!=0:0)a=f[5408+(a<<2)>>2]|0;else a=119845}}return a|0}function nEc(a,c){a=a|0;c=c|0;kyc(a);d[a+8>>1]=16400;f[a+12>>2]=0;f[a>>2]=(c|0)>0?c:0;b[a+10>>0]=1;f[a+16>>2]=0;return}function oEc(a,b){a=a|0;b=b|0;qEc(f[a>>2]|0,b)|0;return}function pEc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=(LDc(a)|0)+112|0;d=f[d>>2]|0;e=((d|0)<0)<<31>>31;if((e|0)<(c|0)|(e|0)==(c|0)&d>>>0<b>>>0){YDc(a);e=0;return e|0}b=vxc(b,c)|0;if(b|0){e=b;return e|0}ZDc(a);e=0;return e|0}function qEc(a,b){a=a|0;b=b|0;var c=0,e=0;c=a+8|0;if(d[c>>1]&9216)gyc(a);f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];f[a+16>>2]=f[b+16>>2];e=d[c>>1]&-1025;d[c>>1]=e;e=e&65535;if(!(e&18)){e=0;return e|0}if(d[b+8>>1]&2048){e=0;return e|0}d[c>>1]=e|4096;e=Yxc(a)|0;return e|0}function rEc(a){a=a|0;return f[a+108>>2]|0}function sEc(a){a=a|0;return f[a+104>>2]|0}function tEc(a){a=a|0;a=a+40|0;G=f[a+4>>2]|0;return f[a>>2]|0}function uEc(a){a=a|0;return f[(f[(f[a+12>>2]|0)+104>>2]|0)+(((f[a+16>>2]|0)+-1|0)*20|0)+16>>2]|0}function vEc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0.0,g=0.0,h=0,i=0,j=0,k=0,l=0;i=d[a+8>>1]|0;k=i&65535;j=d[b+8>>1]|0;l=j&65535;h=(j|i)&65535;if(h&1|0){b=(l&1)-(k&1)|0;return b|0}if(!(h&44)){if(h&2|0){if(!(k&2)){b=1;return b|0}if(!(l&2)){b=-1;return b|0}if(c|0){b=xEc(a,b,c,0)|0;return b|0}}b=yEc(a,b)|0;return b|0}h=j&i&65535;if(h&36|0){l=f[a>>2]|0;a=f[a+4>>2]|0;k=b;b=f[k>>2]|0;k=f[k+4>>2]|0;return ((a|0)<(k|0)|(a|0)==(k|0)&l>>>0<b>>>0?-1:((a|0)>(k|0)|(a|0)==(k|0)&l>>>0>b>>>0)&1)|0}if(h&8|0){g=+p[a>>3];e=+p[b>>3];if(g<e){b=-1;return b|0}b=g>e&1;return b|0}if(!(k&36)){if(!(k&8)){b=1;return b|0}if(!(l&36)){b=-1;return b|0}b=0-(wEc(f[b>>2]|0,f[b+4>>2]|0,+p[a>>3])|0)|0;return b|0}if(l&8|0){l=a;b=wEc(f[l>>2]|0,f[l+4>>2]|0,+p[b>>3])|0;return b|0}if(!(l&36)){b=-1;return b|0}l=f[a>>2]|0;a=f[a+4>>2]|0;k=b;b=f[k>>2]|0;k=f[k+4>>2]|0;b=(a|0)<(k|0)|(a|0)==(k|0)&l>>>0<b>>>0?-1:((a|0)>(k|0)|(a|0)==(k|0)&l>>>0>b>>>0)&1;return b|0}function wEc(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0,f=0;if(c<-9223372036854775808.0){f=1;return f|0}if(c>=9223372036854775808.0){f=-1;return f|0}e=~~c>>>0;f=+I(c)>=1.0?(c>0.0?~~+W(+H(c/4294967296.0),4294967295.0)>>>0:~~+U((c-+(~~c>>>0))/4294967296.0)>>>0):0;if((f|0)>(b|0)|(f|0)==(b|0)&e>>>0>a>>>0){f=-1;return f|0}if((f|0)<(b|0)|(f|0)==(b|0)&e>>>0<a>>>0){f=1;return f|0}d=+(a>>>0)+4294967296.0*+(b|0);if(d<c){f=-1;return f|0}f=d>c&1;return f|0}function xEc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;j=t;t=t+80|0;h=j+40|0;i=j;g=d+4|0;if((b[a+10>>0]|0)==(b[g>>0]|0)){i=zd[f[d+12>>2]&127](f[d+8>>2]|0,f[a+12>>2]|0,f[a+16>>2]|0,f[c+12>>2]|0,f[c+16>>2]|0)|0;t=j;return i|0}k=a+32|0;AEc(h,f[k>>2]|0,1);AEc(i,f[k>>2]|0,1);BEc(h,a,4096);BEc(i,c,4096);c=Uxc(h,b[g>>0]|0)|0;a=Uxc(i,b[g>>0]|0)|0;if((c|0)==0|(a|0)==0)if(!e)a=0;else{b[e>>0]=7;a=0}else a=zd[f[d+12>>2]&127](f[d+8>>2]|0,f[h+12>>2]|0,c,f[i+12>>2]|0,a)|0;kyc(h);kyc(i);k=a;t=j;return k|0}function yEc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0,h=0;e=f[a+12>>2]|0;g=f[b+12>>2]|0;c=d[a+8>>1]|0;h=d[b+8>>1]|0;if(!((h|c)&16384)){h=ocd(f[a+16>>2]|0,f[b+16>>2]|0,(e|0)>(g|0)?g:e)|0;return ((h|0)==0?e-g|0:h)|0}c=c&16384;if((c&h)<<16>>16){h=(f[a>>2]|0)-(f[b>>2]|0)|0;return h|0}if(!(c<<16>>16)){if(!(zEc(f[a+16>>2]|0,e)|0)){h=1;return h|0}h=e-(f[b>>2]|0)|0;return h|0}else{if(!(zEc(f[b+16>>2]|0,g)|0)){h=-1;return h|0}h=(f[a>>2]|0)-g|0;return h|0}return 0}function zEc(a,c){a=a|0;c=c|0;var d=0;d=0;while(1){if((d|0)>=(c|0)){d=1;a=4;break}if(!(b[a+d>>0]|0))d=d+1|0;else{d=0;a=4;break}}if((a|0)==4)return d|0;return 0}function AEc(a,b,c){a=a|0;b=b|0;c=c|0;d[a+8>>1]=c;f[a+32>>2]=b;f[a+24>>2]=0;return}function BEc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0;e=a+8|0;if(d[e>>1]&9216){CEc(a,b,c);return};f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];f[a+16>>2]=f[b+16>>2];if(d[b+8>>1]&2048)return;d[e>>1]=d[e>>1]&-7169&65535|c;return}function CEc(a,b,c){a=a|0;b=b|0;c=c|0;gyc(a);BEc(a,b,c);return}function DEc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aEc(a,b,c,0,d);return}function EEc(a){a=a|0;fyc(f[a>>2]|0);return}function FEc(a){a=a|0;var b=0,c=0;if(!a){c=0;return c|0}c=Vzc(40)|0;if(!c){c=0;return c|0}b=c+20|0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;f[b+12>>2]=0;f[b+16>>2]=0;f[c>>2]=f[a>>2];f[c+4>>2]=f[a+4>>2];f[c+8>>2]=f[a+8>>2];f[c+12>>2]=f[a+12>>2];f[c+16>>2]=f[a+16>>2];a=c+8|0;b=d[a>>1]&-1025;d[a>>1]=b;f[c+32>>2]=0;b=b&65535;if(!(b&18))return c|0;d[a>>1]=b&58367|4096;if(!(Yxc(c)|0))return c|0;Ryc(c);c=0;return c|0}function GEc(a){a=a|0;Ryc(a);return}function HEc(a,b){a=a|0;b=b|0;var c=0;c=WDc(a,0)|0;if(!c)return;if(d[c+8>>1]|0)oEc(a,c);if(b|0)return;kyc(c);return}function IEc(a){a=a|0;f[a+20>>2]=-1;b[a+24>>0]=1;return}function JEc(a){a=a|0;var b=0,c=0;b=t;t=t+16|0;c=b;KEc(c);if(!((a|0)>-1?(f[c>>2]|0)>(a|0):0)){c=0;t=b;return c|0}c=f[76564+(a<<2)>>2]|0;t=b;return c|0}function KEc(a){a=a|0;f[a>>2]=3;return}function LEc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;d=h;KEc(d);g=(QBc(a,120534,7)|0)==0;g=g?a+7|0:a;c=Mxc(g)|0;d=f[d>>2]|0;a=0;while(1){if((a|0)>=(d|0)){a=0;c=6;break}e=f[76564+(a<<2)>>2]|0;if((QBc(g,e,c)|0)==0?(MEc(b[e+c>>0]|0)|0)==0:0){a=1;c=6;break}a=a+1|0}if((c|0)==6){t=h;return a|0}return 0}function MEc(a){a=a|0;return (b[1424+(a&255)>>0]&70)!=0|0}function NEc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;axc(f[e>>2]|0);d=PEc(a,OEc(a,b,c,d)|0)|0;bxc(f[e>>2]|0);return d|0}function OEc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;y=t;t=t+48|0;r=y+32|0;s=y+24|0;l=y+16|0;j=y+8|0;g=y;v=y+36|0;w=f[a>>2]|0;f[v>>2]=0;k=Mxc(c)|0;x=k+300|0;q=((x|0)<0)<<31>>31;n=(e|0)!=0;if(n)f[e>>2]=0;if(0==0?(f[a+32>>2]&65536|0)==0:0){if(!n){a=1;t=y;return a|0}a=WAc(120542,g)|0;f[e>>2]=a;a=1;t=y;return a|0}i=(d|0)==0;g=i?120557:d;u=XEc(w,c)|0;d=1;while(1){h=(u|0)==0;if(!(d&h))break;f[j>>2]=c;f[j+4>>2]=120586;d=WAc(120580,j)|0;if(!d){g=7;m=40;break}u=XEc(w,d)|0;qxc(d);d=0}if((m|0)==40){t=y;return g|0}if(h){if(!n){a=1;t=y;return a|0}g=XAc(x,q)|0;f[v>>2]=g;f[e>>2]=g;if(!g){a=1;t=y;return a|0}f[l>>2]=c;OAc(x,g,120589,l)|0;YEc(w,k+299|0,g);a=1;t=y;return a|0}d=ZEc(w,u,g)|0;if(i&(d|0)==0){g=Mxc(c)|0;i=g+30|0;i=XAc(i,((i|0)<0)<<31>>31)|0;if(!i){_Ec(w,u);a=7;t=y;return a|0}m=i;l=m;b[l>>0]=115;b[l+1>>0]=113;b[l+2>>0]=108;b[l+3>>0]=105;m=m+4|0;b[m>>0]=116;b[m+1>>0]=101;b[m+2>>0]=51;b[m+3>>0]=95;while(1){d=g+-1|0;if((g|0)<=0)break;if((b[c+d>>0]|0)==47)break;else g=d}h=(QBc(c+g|0,120624,3)|0)==0;d=8;h=h?g+3|0:g;a:while(1){g=b[c+h>>0]|0;switch(g<<24>>24){case 0:case 46:break a;default:{}}if(!(b[1424+(g&255)>>0]&2))g=d;else{b[i+d>>0]=b[1680+(g<<24>>24)>>0]|0;g=d+1|0}d=g;h=h+1|0}h=i+d|0;b[h>>0]=b[120628]|0;b[h+1>>0]=b[120629]|0;b[h+2>>0]=b[120630]|0;b[h+3>>0]=b[120631]|0;b[h+4>>0]=b[120632]|0;b[h+5>>0]=b[120633]|0;h=i;d=ZEc(w,u,i)|0;g=i}else h=0;if(!d){if(n?(o=Mxc(g)|0,o=vrd(o|0,((o|0)<0)<<31>>31|0,x|0,q|0)|0,p=XAc(o,G)|0,f[v>>2]=p,f[e>>2]=p,p|0):0){f[s>>2]=g;f[s+4>>2]=c;OAc(o,p,120634,s)|0;YEc(w,o+-1|0,p)}_Ec(w,u);qxc(h);a=1;t=y;return a|0}qxc(h);switch(vd[d&255](a,v,76576)|0){case 0:{d=a+196|0;h=$Ec(a,(f[d>>2]<<2)+4|0,0)|0;if(!h){a=7;t=y;return a|0}g=f[d>>2]|0;if((g|0)>0){x=a+200|0;Krd(h|0,f[x>>2]|0,g<<2|0)|0;g=x}else g=a+200|0;nxc(a,f[g>>2]|0);f[g>>2]=h;a=f[d>>2]|0;f[d>>2]=a+1;f[h+(a<<2)>>2]=u;a=0;t=y;return a|0}case 256:{a=0;t=y;return a|0}default:{if(n){f[r>>2]=f[v>>2];a=WAc(120677,r)|0;f[e>>2]=a}qxc(f[v>>2]|0);_Ec(w,u);a=1;t=y;return a|0}}return 0}function PEc(a,c){a=a|0;c=c|0;if(!((c|0)!=0|(b[a+83>>0]|0)!=0)){c=0;return c|0}c=QEc(a,c)|0;return c|0}function QEc(a,c){a=a|0;c=c|0;if((c|0)==3082|(b[a+83>>0]|0)!=0){REc(a);SEc(a,7);c=7;return c|0}else{c=f[a+68>>2]&c;return c|0}return 0}function REc(a){a=a|0;var c=0,e=0;c=a+83|0;if(!(b[c>>0]|0))return;if(f[a+188>>2]|0)return;b[c>>0]=0;f[a+272>>2]=0;e=a+280|0;c=(f[e>>2]|0)+-1|0;f[e>>2]=c;if(!c)c=d[a+286>>1]|0;else c=0;d[a+284>>1]=c;return}function SEc(a,b){a=a|0;b=b|0;f[a+64>>2]=b;if((b|0)==0?(f[a+268>>2]|0)==0:0)return;TEc(a,b);return}function TEc(a,b){a=a|0;b=b|0;var c=0;c=f[a+268>>2]|0;if(c|0)UEc(c);VEc(a,b);return}function UEc(a){a=a|0;fyc(a);return}function VEc(a,b){a=a|0;b=b|0;if((b|0)==3082)return;if((b&251|4|0)!=14)return;b=WEc(f[a>>2]|0)|0;f[a+72>>2]=b;return}function WEc(a){a=a|0;var b=0;b=f[a+68>>2]|0;if(!b){b=0;return b|0}b=vd[b&255](a,0,0)|0;return b|0}function XEc(a,b){a=a|0;b=b|0;return td[f[a+40>>2]&1023](a,b)|0}function YEc(a,b,c){a=a|0;b=b|0;c=c|0;Kd[f[a+44>>2]&255](a,b,c);return}function ZEc(a,b,c){a=a|0;b=b|0;c=c|0;return vd[f[a+48>>2]&255](a,b,c)|0}function _Ec(a,b){a=a|0;b=b|0;Jd[f[a+52>>2]&1023](a,b);return}function $Ec(a,b,c){a=a|0;b=b|0;c=c|0;a=jxc(a,b,c)|0;if(!a)return a|0;Mrd(a|0,0,b|0)|0;return a|0}function aFc(a){a=a|0;return f[(f[a+8>>2]|0)+12>>2]|0}function bFc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return l3c(a,b,c,d,e,0)|0}function cFc(a,b,c){a=a|0;b=b|0;c=+c;var d=0;d=YIc(a,b)|0;if(d|0)return d|0;dEc((f[a+100>>2]|0)+((b+-1|0)*40|0)|0,c);bxc(f[(f[a>>2]|0)+12>>2]|0);return d|0}function dFc(a,b,c){a=a|0;b=b|0;c=c|0;return eFc(a,b,c,((c|0)<0)<<31>>31)|0}function eFc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=YIc(a,b)|0;if(e|0)return e|0;EDc((f[a+100>>2]|0)+((b+-1|0)*40|0)|0,c,d);bxc(f[(f[a>>2]|0)+12>>2]|0);return e|0}function fFc(a,b){a=a|0;b=b|0;b=YIc(a,b)|0;if(b|0)return b|0;bxc(f[(f[a>>2]|0)+12>>2]|0);return b|0}function gFc(a){a=a|0;if(!a){a=0;return a|0}a=d[a+16>>1]|0;return a|0}function hFc(a,b){a=a|0;b=b|0;return j3c(a,b,Mxc(b)|0)|0}function iFc(a,b){a=a|0;b=b|0;if(!a){b=0;return b|0}b=BVc(f[a+128>>2]|0,b)|0;return b|0}function jFc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return l3c(a,b,c,d,e,1)|0}function kFc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return l3c(a,b,c,d,e,2)|0}function lFc(a,c,e){a=a|0;c=c|0;e=e|0;switch(GDc(e)|0){case 1:{e=eFc(a,c,f[e>>2]|0,f[e+4>>2]|0)|0;return e|0}case 2:{e=cFc(a,c,+p[e>>3])|0;return e|0}case 4:if(!(d[e+8>>1]&16384)){e=bFc(a,c,f[e+16>>2]|0,f[e+12>>2]|0,-1)|0;return e|0}else{e=GGc(a,c,f[e>>2]|0)|0;return e|0}case 3:{e=l3c(a,c,f[e+16>>2]|0,f[e+12>>2]|0,-1,b[e+10>>0]|0)|0;return e|0}default:{e=fFc(a,c)|0;return e|0}}return 0}function mFc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+12|0;axc(f[d>>2]|0);f[a+420>>2]=b;f[a+424>>2]=c;f[a+428>>2]=0;f[a+472>>2]=0;bxc(f[d>>2]|0);return 0}function nFc(a,b){a=a|0;b=b|0;if((b|0)>0){mFc(a,674,a)|0;f[a+472>>2]=b;return 0}else{mFc(a,0,0)|0;return 0}return 0}function oFc(a){a=a|0;return s3c(a,0)|0}function pFc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+12|0;axc(f[d>>2]|0);f[a+256>>2]=c;f[a+260>>2]=0;f[a+264>>2]=b;bxc(f[d>>2]|0);return 0}function qFc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+12|0;axc(f[d>>2]|0);f[a+256>>2]=0;f[a+260>>2]=c;f[a+264>>2]=b;bxc(f[d>>2]|0);return 0}function rFc(a,b){a=a|0;b=b|0;b=gEc(T7c(a,b)|0)|0;U7c(a);return b|0}function sFc(a,b){a=a|0;b=b|0;b=NDc(T7c(a,b)|0)|0;U7c(a);return b|0}function tFc(a,b){a=a|0;b=b|0;b=xGc(T7c(a,b)|0)|0;U7c(a);return b|0}function uFc(a){a=a|0;if(!a){a=0;return a|0}a=j[a+144>>1]|0;return a|0}function vFc(a,b){a=a|0;b=b|0;return V7c(a,b,0,1)|0}function wFc(a,b){a=a|0;b=b|0;return V7c(a,b,1,1)|0}function xFc(a,b){a=a|0;b=b|0;var c=0.0;c=+myc(T7c(a,b)|0);U7c(a);return +c}function yFc(a,b){a=a|0;b=b|0;b=fEc(T7c(a,b)|0)|0;U7c(a);return b|0}function zFc(a,b){a=a|0;b=b|0;var c=0;b=ryc(T7c(a,b)|0)|0;c=G;U7c(a);G=c;return b|0}function AFc(a,b){a=a|0;b=b|0;return V7c(a,b,0,0)|0}function BFc(a,b){a=a|0;b=b|0;return V7c(a,b,1,0)|0}function CFc(a,b){a=a|0;b=b|0;b=Txc(T7c(a,b)|0)|0;U7c(a);return b|0}function DFc(a,b){a=a|0;b=b|0;b=yGc(T7c(a,b)|0)|0;U7c(a);return b|0}function EFc(a,b){a=a|0;b=b|0;b=GDc(T7c(a,b)|0)|0;U7c(a);return b|0}function FFc(a,b){a=a|0;b=b|0;var c=0,e=0;b=T7c(a,b)|0;c=b+8|0;e=j[c>>1]|0;if(!(e&2048)){U7c(a);return b|0}d[c>>1]=e&59391|4096;U7c(a);return b|0}function GFc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=a+12|0;axc(f[e>>2]|0);g=a+220|0;d=f[g>>2]|0;f[a+224>>2]=b;f[g>>2]=c;bxc(f[e>>2]|0);return d|0}function HFc(a){a=a|0;var c=0,d=0,e=0,f=0;f=0;a:while(1){d=b[a>>0]|0;if(!(d<<24>>24)){c=41;break}c=d<<24>>24;b:do switch(c|0){case 59:{c=0;break}case 12:case 10:case 9:case 13:case 32:{c=1;break}case 47:{if((b[a+1>>0]|0)==42){a=a+2|0;while(1)switch(b[a>>0]|0){case 0:{a=0;c=42;break a}case 42:{a=a+1|0;if((b[a>>0]|0)==47){c=1;break b}break}default:a=a+1|0}}else c=2;break}case 45:{if((b[a+1>>0]|0)==45){c=d;while(1){d=c<<24>>24==0;e=a+1|0;if(!(d^c<<24>>24!=10))break;a=e;c=b[e>>0]|0}if(d){c=18;break a}else c=1}else c=2;break}case 91:{do{a=a+1|0;e=b[a>>0]|0;c=e<<24>>24==0}while(c^e<<24>>24!=93);if(c){a=0;c=42;break a}else c=2;break}case 39:case 34:case 96:{do{a=a+1|0;e=b[a>>0]|0;c=e<<24>>24==0}while(e<<24>>24!=d<<24>>24&(c^1));if(c){a=0;c=42;break a}else c=2;break}default:if(!(b[1424+(d&255)>>0]&70))c=2;else{d=1;while(1)if(!(b[1424+(h[a+d>>0]|0)>>0]&70))break;else d=d+1|0;c:do switch(c|0){case 67:case 99:{if((d|0)==6?(QBc(a,139735,6)|0)==0:0){c=4;break c}c=2;break}case 84:case 116:{switch(d&2147483647|0){case 7:{if(!(QBc(a,129781,7)|0)){c=6;break c}break}case 4:{if(!(QBc(a,137739,4)|0)){c=5;break c}break}case 9:{if(!(QBc(a,139742,9)|0)){c=5;break c}break}default:{}}c=2;break}case 69:case 101:{switch(d&2147483647|0){case 3:{if(!(QBc(a,139752,3)|0)){c=7;break c}break}case 7:{if(!(QBc(a,139756,7)|0)){c=3;break c}break}default:{}}c=2;break}default:c=2}while(0);a=a+(d+-1)|0}}while(0);f=b[(c&255)+(24080+((f&255)<<3))>>0]|0;a=a+1|0}if((c|0)==18){f=f<<24>>24==1;f=f&1;return f|0}else if((c|0)==41){f=f<<24>>24==1;f=f&1;return f|0}else if((c|0)==42){f=a&1;return f|0}return 0}function IFc(a){a=a|0;var b=0,c=0;b=Lzc()|0;if(b|0){c=b;return c|0}c=EIc(0)|0;GIc(c,a,2,0);b=Uxc(c,1)|0;if(!b)b=7;else b=(HFc(b)|0)&255;Ryc(c);c=b;return c|0}function JFc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return MGc(a,b,c,d,e,0)|0}function KFc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=a+12|0;axc(f[g>>2]|0);b=bJc(a,b,-1)|0;if(!b)b=0;else{e=o7c(a,b,c&255,d,e,0)|0;nxc(a,b);b=e}a=PEc(a,b)|0;bxc(f[g>>2]|0);return a|0}function LFc(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return yIc(a,b,c,d,e,f,g,h,0,0,0)|0}function MFc(a,b,c,d,e,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0;j=a+12|0;axc(f[j>>2]|0);b=bJc(a,b,-1)|0;i=zIc(a,b,c,d,e,g,h,i,0,0,0)|0;nxc(a,b);i=PEc(a,i)|0;bxc(f[j>>2]|0);return i|0}function NFc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return vIc(a,b,c,d,0)|0}function OFc(a){a=a|0;if(!a){a=0;return a|0}if(!(f[a+120>>2]|0)){a=0;return a|0}a=j[a+144>>1]|0;return a|0}function PFc(a){a=a|0;if(!a)a=0;else a=f[a>>2]|0;return a|0}function QFc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=t;t=t+288|0;g=o;e=o+280|0;m=o+8|0;f[e>>2]=0;n=a+12|0;axc(f[n>>2]|0);h=f[a+376>>2]|0;if(h|0?(k=h+12|0,(f[k>>2]|0)==0):0){j=f[h+4>>2]|0;Mrd(m+4|0,0,268)|0;l=m+200|0;b[l>>0]=1;f[m>>2]=a;f[m+132>>2]=1;if(((((lJc(m,c,e)|0)==0?(i=f[m+228>>2]|0,(i|0)!=0):0)?(b[a+83>>0]|0)==0:0)?(f[i+12>>2]|0)==0:0)?(f[i+56>>2]|0)==0:0){c=j+4|0;if(!(f[c>>2]|0)){e=i+4|0;f[c>>2]=f[e>>2];c=i+42|0;g=d[c>>1]|0;d[j+42>>1]=g;d[j+44>>1]=g;g=i+36|0;p=j+36|0;f[p>>2]=f[p>>2]|f[g>>2]&640;d[c>>1]=0;f[e>>2]=0;if((f[g>>2]&128|0)!=0?(f[(f[f[(f[h>>2]|0)+4>>2]>>2]|0)+52>>2]|0)!=0:0){c=(yUc(i)|0)+50|0;c=(d[c>>1]|0)!=1&1}else c=0;e=i+8|0;g=f[e>>2]|0;if(g){f[j+8>>2]=g;f[e>>2]=0;f[g+12>>2]=j}}else c=0;f[k>>2]=1;e=c}else{e=f[e>>2]|0;f[g>>2]=e;BIc(a,1,(e|0)==0?0:118856,g);nxc(a,e);e=1}b[l>>0]=0;c=f[m+8>>2]|0;if(c|0)oJc(c)|0;Iyc(a,f[m+228>>2]|0);qJc(m);p=PEc(a,e)|0;bxc(f[n>>2]|0);t=o;return p|0}SEc(a,21);bxc(f[n>>2]|0);p=Zwc(142737)|0;t=o;return p|0}function RFc(a){a=a|0;f[10228]=a;return 0}function SFc(a){a=a|0;if(!a){a=7;return a|0}if(!(g3c(a)|0)){a=Zwc(166596)|0;return a|0}if(b[a+83>>0]|0){a=7;return a|0}a=f[a+68>>2]&f[a+64>>2];return a|0}function TFc(a){a=a|0;var c=0,d=0,e=0;if(!a){e=mEc(7)|0;return e|0}if(!(g3c(a)|0)){e=mEc(Zwc(166530)|0)|0;return e|0}d=a+12|0;axc(f[d>>2]|0);if(!(b[a+83>>0]|0)){c=a+64|0;if(f[c>>2]|0){a=Txc(f[a+268>>2]|0)|0;if(!a){a=f[c>>2]|0;e=9}}else{a=0;e=9}}else{a=7;e=9}if((e|0)==9)a=mEc(a)|0;bxc(f[d>>2]|0);e=a;return e|0}function UFc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;e=h;if(!a){g=23968;t=h;return g|0}if(!(g3c(a)|0)){g=24e3;t=h;return g|0}g=a+12|0;axc(f[g>>2]|0);if(!(b[a+83>>0]|0)){d=a+268|0;c=yGc(f[d>>2]|0)|0;if(!c){c=f[a+64>>2]|0;BIc(a,c,mEc(c)|0,e);c=yGc(f[d>>2]|0)|0}REc(a)}else c=23968;bxc(f[g>>2]|0);g=c;t=h;return g|0}function VFc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0;z=t;t=t+16|0;w=z+4|0;x=z;f[x>>2]=0;if(!(aJc(a)|0)){y=Zwc(125239)|0;t=z;return y|0}y=a+12|0;axc(f[y>>2]|0);SEc(a,0);u=(d|0)==0;v=a+32|0;n=0;j=0;c=(c|0)==0?155644:c;i=0;k=0;a:while(1){l=c;while(1){do{if(j|0)break a;if(!(b[l>>0]|0)){j=0;break a}f[x>>2]=0;j=CGc(a,l,-1,x,w)|0}while((j|0)!=0);j=f[x>>2]|0;if(j|0)break;j=0;l=f[w>>2]|0}m=0;p=0;o=0;c=n;q=j;b:while(1){j=rGc(q)|0;c:do if(!u){n=(j|0)==100;if(n)if(!o)s=18;else{n=p;q=k;s=23}else{if((o|0)!=0|(j|0)!=101){n=p;j=q;s=34;break}if((f[v>>2]&256|0)==0&0==0){n=p;o=0;j=q;s=34;break}else s=18}if((s|0)==18){s=0;i=uFc(q)|0;p=jxc(a,i<<3|4,0)|0;if(!p){r=6;n=i;o=0;c=p;k=0;i=0;break}c=0;while(1){if((c|0)>=(i|0))break;r=AFc(q,c)|0;f[p+(c<<2)>>2]=r;c=c+1|0}if(n){n=i;o=1;c=p;q=p;i=p;s=23}else{n=i;o=1;c=p;k=p;i=p}}do if((s|0)==23){m=c+(n<<2)|0;k=0;while(1){if((k|0)>=(n|0)){s=29;break}s=CFc(f[x>>2]|0,k)|0;f[m+(k<<2)>>2]=s;if((s|0)==0?(EFc(f[x>>2]|0,k)|0)!=5:0){s=27;break}k=k+1|0}if((s|0)==27){s=0;Cxc(a);r=6;k=q;break c}else if((s|0)==29){s=0;f[m+(k<<2)>>2]=0;k=q;break}}while(0);if(!(xd[d&63](e,n,m,c)|0))s=32;else{oJc(f[x>>2]|0)|0;f[x>>2]=0;SEc(a,4);r=6;j=4}}else{n=p;s=32}while(0);if((s|0)==32){s=0;if((j|0)==100){r=0;j=100}else{j=f[x>>2]|0;s=34}}if((s|0)==34){s=0;j=oJc(j)|0;f[x>>2]=0;l=f[w>>2]|0;while(1)if(!(b[1424+(h[l>>0]|0)>>0]&1)){r=5;break}else l=l+1|0}switch(r&7){case 6:break a;case 5:{s=38;break b}case 2:break b;case 0:break;default:{c=0;s=47;break a}}p=n;q=f[x>>2]|0}if((s|0)==38){s=0;nxc(a,k);c=0;i=0;k=0}n=c;c=l}if((s|0)==47){t=z;return c|0}c=f[x>>2]|0;if(c|0)oJc(c)|0;nxc(a,i);c=PEc(a,j)|0;i=(g|0)!=0;if(i&(c|0)!=0){x=UIc(0,TFc(a)|0)|0;f[g>>2]=x;if(!x){SEc(a,7);c=7}}else if(i)f[g>>2]=0;bxc(f[y>>2]|0);y=c;t=z;return y|0}function WFc(a){a=a|0;if(!a){a=1;return a|0}a=(d[a+150>>1]&3)!=0&1;return a|0}function XFc(a){a=a|0;var b=0,c=0,d=0;if(!a){b=0;return b|0}b=f[a>>2]|0;if(_Ic(a)|0){b=Zwc(83734)|0;return b|0}axc(f[b+12>>2]|0);c=a+136|0;d=f[c+4>>2]|0;if((d|0)>0|(d|0)==0&(f[c>>2]|0)>>>0>0)L7c(b,a);d=PEc(b,oJc(a)|0)|0;v3c(b);return d|0}function YFc(a){a=a|0;var b=0,c=0,d=0;if(!a)return;b=a+-4|0;c=f[b>>2]|0;a=1;while(1){if((a|0)>=(c|0))break;d=f[b+(a<<2)>>2]|0;if(d|0)qxc(d);a=a+1|0}qxc(b);return}function ZFc(a){a=a|0;return h[a+81>>0]|0|0}function _Fc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+16|0;d=(b|0)<0;a=(f[a+12>>2]|0)+216|0;while(1){a=f[a>>2]|0;if(!a){a=0;e=7;break}if((f[a+4>>2]|0)==(b|0)?d|(f[a>>2]|0)==(f[c>>2]|0):0)break;a=a+16|0}if((e|0)==7)return a|0;e=f[a+8>>2]|0;return e|0}function $Fc(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0;u=t;t=t+32|0;m=u;o=u+4|0;f[c>>2]=0;r=(e|0)!=0;if(r)f[e>>2]=0;s=(d|0)!=0;if(s)f[d>>2]=0;l=(g|0)!=0;if(l)f[g>>2]=0;j=o+4|0;f[j>>2]=0;p=o+12|0;f[p>>2]=0;q=o+16|0;f[q>>2]=0;i=o+20|0;f[i>>2]=1;k=o+8|0;f[k>>2]=20;n=o+24|0;f[n>>2]=0;h=XAc(80,0)|0;f[o>>2]=h;if(!h){f[a+64>>2]=7;a=7;t=u;return a|0}f[h>>2]=0;b=VFc(a,b,51,o,g)|0;f[f[o>>2]>>2]=f[i>>2];if((b&255|0)==4){YFc((f[o>>2]|0)+4|0);b=f[j>>2]|0;if(b|0){if(l){qxc(f[g>>2]|0);f[m>>2]=f[j>>2];b=WAc(118856,m)|0;f[g>>2]=b;b=f[j>>2]|0}qxc(b)}s=f[n>>2]|0;f[a+64>>2]=s;a=s;t=u;return a|0}qxc(f[j>>2]|0);if(b|0){YFc((f[o>>2]|0)+4|0);a=b;t=u;return a|0}b=f[i>>2]|0;do if((f[k>>2]|0)>>>0>b>>>0){b=Pxc(f[o>>2]|0,b<<2,0)|0;if(b|0){f[o>>2]=b;break}YFc((f[o>>2]|0)+4|0);f[a+64>>2]=7;a=7;t=u;return a|0}else b=f[o>>2]|0;while(0);f[c>>2]=b+4;if(r)f[e>>2]=f[q>>2];if(!s){a=0;t=u;return a|0}f[d>>2]=f[p>>2];a=0;t=u;return a|0}function aGc(a){a=a|0;f[a+272>>2]=1;return}function bGc(){return 118345}function cGc(){return 3035003}function dGc(a,b){a=a|0;b=b|0;return n7c(a,b,6,0)|0}function eGc(a,c){a=a|0;c=c|0;var e=0,g=0;f[c>>2]=0;e=Lzc()|0;if(e|0){g=e;return g|0}g=EIc(0)|0;GIc(g,(a|0)==0?155625:a,2,0);e=Uxc(g,1)|0;if(e){e=n7c(e,c,6,0)|0;if(!e){e=f[c>>2]|0;a=f[(f[e+16>>2]|0)+12>>2]|0;if(!(d[a+78>>1]&1)){b[e+80>>0]=2;b[a+77>>0]=2;e=0}else e=0}}else e=7;Ryc(g);g=e&255;return g|0}function fGc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return cJc(a,b,c,0,0,d,e)|0}function gGc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return $Ic(a,b,c,0,d,e)|0}function hGc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=a+12|0;axc(f[g>>2]|0);h=a+216|0;e=f[h>>2]|0;f[a+212>>2]=c;f[h>>2]=d;d=a+90|0;a=b[d>>0]&15;b[d>>0]=(c|0)==0?a:a|-128;bxc(f[g>>2]|0);return e|0}function iGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=a+12|0;axc(f[e>>2]|0);g=(b|0)>0;f[a+344>>2]=g?c:0;f[a+352>>2]=g?b:0;f[a+348>>2]=g?d:0;bxc(f[e>>2]|0);return}function jGc(a){a=a|0;var b=0,c=0,d=0,e=0;if(!a){c=0;return c|0}b=f[a>>2]|0;c=b+12|0;axc(f[c>>2]|0);d=a+136|0;e=f[d+4>>2]|0;if((e|0)>0|(e|0)==0&(f[d>>2]|0)>>>0>0)L7c(b,a);e=rJc(a)|0;c3c(a);e=PEc(b,e)|0;bxc(f[c>>2]|0);return e|0}function kGc(a,b,c){a=a|0;b=b|0;c=c|0;f[a+20>>2]=1;SDc(f[a>>2]|0,b,c,2,-1)|0;return}function lGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aEc(a,b,c,2,d);return}function mGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aEc(a,b,c,3,d);return}function nGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;aEc(a,b,c,2,d);return}function oGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=a+12|0;axc(f[e>>2]|0);g=a+228|0;d=f[g>>2]|0;f[a+232>>2]=b;f[g>>2]=c;bxc(f[e>>2]|0);return d|0}function pGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+12|0;axc(f[d>>2]|0);f[a+336>>2]=b;f[a+340>>2]=c;if(b|0)CIc(a,1);bxc(f[d>>2]|0);return 0}function qGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;h=f[a+12>>2]|0;i=h+216|0;j=a+16|0;g=(b|0)<0;e=i;while(1){e=f[e>>2]|0;if(!e){g=6;break}if((f[e+4>>2]|0)==(b|0)?g|(f[e>>2]|0)==(f[j>>2]|0):0){g=9;break}e=e+16|0}do if((g|0)==6){e=$Ec(f[h>>2]|0,20,0)|0;if(e|0){f[e>>2]=f[j>>2];f[e+4>>2]=b;f[e+16>>2]=f[i>>2];f[i>>2]=e;g=a+20|0;if(f[g>>2]|0)break;f[g>>2]=-1;break}if(!d)return;Hd[d&1023](c);return}else if((g|0)==9){g=f[e+12>>2]|0;if(g)Hd[g&1023](f[e+8>>2]|0)}while(0);f[e+8>>2]=c;f[e+12>>2]=d;return}function rGc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;if(ZIc(a)|0){k=Zwc(84382)|0;return k|0}j=f[a>>2]|0;k=j+12|0;axc(f[k>>2]|0);e=a+149|0;b[e>>0]=0;g=a+36|0;d=0;while(1){c=E7c(a)|0;if((c|0)!=17)break;if(d>>>0>=50){c=17;break}c=f[g>>2]|0;h=F7c(a)|0;if(h|0){i=7;break}jGc(a)|0;if((c|0)>-1)b[e>>0]=1;d=d+1|0}do if((i|0)==7){c=Txc(f[j+268>>2]|0)|0;d=a+124|0;nxc(j,f[d>>2]|0);if(!(b[j+83>>0]|0)){c=UIc(j,c)|0;f[d>>2]=c;c=PEc(j,h)|0;f[a+40>>2]=c;break}else{f[d>>2]=0;f[a+40>>2]=7;c=7;break}}while(0);bxc(f[k>>2]|0);k=c;return k|0}function sGc(a,c,e,g,h,i,j,k,l){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=t;t=t+16|0;z=A+8|0;y=A;x=A+12|0;f[x>>2]=0;u=a+12|0;axc(f[u>>2]|0);Byc(a);v=pUc(a,x)|0;w=(v|0)!=0;a:do if((!w?(s=$Tc(a,e,c)|0,(s|0)!=0):0)?(f[s+12>>2]|0)==0:0){do if(g){o=s+4|0;n=d[s+42>>1]|0;m=0;c=0;while(1){if((m|0)>=(n|0))break;c=(f[o>>2]|0)+(m*20|0)|0;if(!(wzc(f[c>>2]|0,g)|0))break;m=m+1|0}if((m|0)==(n|0)){if(f[s+36>>2]&128|0){r=0;p=0;o=0;n=0;m=0;c=0;break a}if(!(uTc(g)|0)){r=0;p=0;o=0;n=0;m=0;c=0;break a}r=d[s+40>>1]|0;c=r<<16>>16;if(r<<16>>16<=-1){p=0;o=1;n=0;q=0;c=121602;break}m=c;c=(f[o>>2]|0)+(c*20|0)|0}if(c){r=cSc(c,0)|0;q=f[c+8>>2]|0;n=(b[c+12>>0]|0)!=0&1;c=d[c+16>>1]&1;if((m|0)==(d[s+40>>1]|0)){p=(f[s+36>>2]|0)>>>3&1;o=c;c=r}else{p=0;o=c;c=r}}else{p=0;o=1;n=0;q=0;c=121602}}else{p=0;o=1;n=0;q=0;c=121602}while(0);r=s;m=(q|0)==0?120777:q}else{r=0;p=0;o=0;n=0;m=0;c=0}while(0);Fyc(a);if(h|0)f[h>>2]=c;if(i|0)f[i>>2]=m;if(j|0)f[j>>2]=n;if(k|0)f[k>>2]=o;if(l|0)f[l>>2]=p;c=f[x>>2]|0;if(w|(r|0)!=0){y=v;e=c;g=(e|0)==0;g=g?0:118856;f[z>>2]=e;BIc(a,y,g,z);z=f[x>>2]|0;nxc(a,z);z=PEc(a,y)|0;y=f[u>>2]|0;bxc(y);t=A;return z|0}nxc(a,c);f[y>>2]=e;f[y+4>>2]=g;e=YMc(a,138049,y)|0;f[x>>2]=e;y=1;g=(e|0)==0;g=g?0:118856;f[z>>2]=e;BIc(a,y,g,z);z=f[x>>2]|0;nxc(a,z);z=PEc(a,y)|0;y=f[u>>2]|0;bxc(y);t=A;return z|0}function tGc(){return}function uGc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=a+12|0;axc(f[g>>2]|0);h=a+208|0;e=f[h>>2]|0;b[a+90>>0]=(c|0)==0?0:64;f[a+204>>2]=c;f[h>>2]=d;bxc(f[g>>2]|0);return e|0}function vGc(a,b){a=a|0;b=b|0;var c=0;if((d[a+16>>1]|0)!=(d[b+16>>1]|0)){b=1;return b|0}if(f[b+208>>2]|0){c=b+150|0;d[c>>1]=d[c>>1]&-4|1}if(f[a+208>>2]|0){c=a+150|0;d[c>>1]=d[c>>1]&-4|1}D7c(a,b);c=0;return c|0}function wGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=a+12|0;axc(f[e>>2]|0);g=a+236|0;d=f[g>>2]|0;f[a+240>>2]=b;f[g>>2]=c;bxc(f[e>>2]|0);return d|0}function xGc(a){a=a|0;return UDc(a,2)|0}function yGc(a){a=a|0;return Uxc(a,2)|0}function zGc(a){a=a|0;return Uxc(a,3)|0}function AGc(a){a=a|0;return Uxc(a,2)|0}function BGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=t;t=t+16|0;g=a+12|0;axc(f[g>>2]|0);d=(AIc(a,b,c,1,0)|0)==0;bxc(f[g>>2]|0);if(!d){g=0;t=e;return g|0}d=WAc(b,e)|0;if(!d){g=7;t=e;return g|0}g=fHc(a,b,c,1,d,184,0,0,696)|0;t=e;return g|0}function CGc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return cJc(a,b,c,128,0,d,e)|0}function DGc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return $Ic(a,b,c,128,d,e)|0}function EGc(a){a=a|0;var b=0,c=0,e=0,g=0;c=f[(f[a>>2]|0)+12>>2]|0;axc(c);e=a+16|0;g=a+100|0;b=0;while(1){if((b|0)>=(d[e>>1]|0))break;kyc((f[g>>2]|0)+(b*40|0)|0);d[(f[g>>2]|0)+(b*40|0)+8>>1]=1;b=b+1|0}if(!(f[a+208>>2]|0)){bxc(c);return 0}g=a+150|0;d[g>>1]=d[g>>1]&-4|1;bxc(c);return 0}function FGc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return vIc(a,b,c,d,e)|0}function GGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=YIc(a,b)|0;if(d|0)return d|0;nEc((f[a+100>>2]|0)+((b+-1|0)*40|0)|0,c);bxc(f[(f[a>>2]|0)+12>>2]|0);return d|0}function HGc(a){a=a|0;if((a|0)!=0?(f[a+16>>2]|0)!=0:0)a=f[a>>2]|0;else a=0;return a|0}function IGc(a){a=a|0;var b=0,c=0,d=0;if(!a){a=0;return a|0}b=f[a+16>>2]|0;d=f[a+20>>2]|0;c=d+12|0;axc(f[c>>2]|0);nxc(d,a);bxc(f[c>>2]|0);a=XFc(b)|0;return a|0}function JGc(a,c,e,g,h,i,k,l){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;Y=t;t=t+336|0;X=Y+40|0;O=Y+32|0;Q=Y+24|0;P=Y+16|0;N=Y+8|0;M=Y;V=Y+320|0;W=Y+48|0;f[V>>2]=0;f[l>>2]=0;x=(k|0)!=0;y=x&1;T=a+12|0;axc(f[T>>2]|0);U=$Ec(a,32,0)|0;R=(U|0)!=0;z=U+28|0;A=a+16|0;B=U+24|0;C=a+32|0;S=U+16|0;D=U+8|0;E=U+20|0;L=a+83|0;F=W+196|0;G=W+44|0;H=W+40|0;w=0;k=0;while(1){Mrd(W|0,0,272)|0;if(!R){m=44;break}f[W>>2]=a;nxc(a,f[V>>2]|0);f[V>>2]=0;Byc(a);s=ZTc(W,0,e,c)|0;if(!s){m=10;break}if(f[s+56>>2]|0){m=5;break}if(f[s+36>>2]&128|0){m=7;break}if(f[s+12>>2]|0){m=9;break}f[z>>2]=s;m=f[A>>2]|0;u=s+72|0;m=m+((zTc(a,f[u>>2]|0)|0)<<4)|0;f[B>>2]=f[m>>2];m=s+4|0;v=s+42|0;n=d[v>>1]|0;r=0;while(1){if((r|0)>=(n|0))break;if(!(wzc(f[(f[m>>2]|0)+(r*20|0)>>2]|0,g)|0))break;r=r+1|0}if((r|0)==(n|0)){m=18;break}if(x){a:do if((f[C>>2]&16384|0)==0&0==0)m=0;else{n=s+16|0;m=0;while(1){o=f[n>>2]|0;if(!o)break a;p=f[o+20>>2]|0;n=0;while(1){if((n|0)>=(p|0))break;q=(f[o+36+(n<<3)>>2]|0)==(r|0)?137944:m;n=n+1|0;m=q}n=o+4|0}}while(0);n=s+8|0;o=m;while(1){n=f[n>>2]|0;if(!n)break;p=j[n+50>>1]|0;q=n+4|0;m=0;while(1){if((m|0)==(p|0))break;Z=d[(f[q>>2]|0)+(m<<1)>>1]|0;m=m+1|0;o=Z<<16>>16==-2|(r|0)==(Z<<16>>16|0)?137956:o}n=n+20|0}if(o|0){m=34;break}}m=bVc(W)|0;f[S>>2]=m;if((m|0?(J=f[u>>2]|0,I=zTc(a,J)|0,lVc(m,2,I,y,f[J>>2]|0,f[J+4>>2]|0)|0,_Uc(m,1),J=jYc(m,6,23200)|0,$Uc(m,I),(b[L>>0]|0)==0):0)?(f[J+4>>2]=I,K=s+28|0,f[J+8>>2]=f[K>>2],f[J+12>>2]=y,YUc(m,2,f[s>>2]|0,0),(b[L>>0]|0)==0):0){if(x)b[J+20>>0]=98;f[J+28>>2]=f[K>>2];f[J+32>>2]=I;b[J+21>>0]=-3;f[J+36>>2]=(d[v>>1]|0)+1;f[J+68>>2]=d[v>>1];d[F>>1]=0;f[G>>2]=1;f[H>>2]=1;a3c(m,W)}d[D>>1]=r;f[E>>2]=a;Fyc(a);if(b[L>>0]|0){m=43;break}k=y3c(U,h,i,V)|0;w=w+1|0;if(!(w>>>0<50&(k|0)==17)){m=43;break}else k=17}if((m|0)==5){f[M>>2]=e;TIc(W,137857,M);m=10}else if((m|0)==7){f[N>>2]=e;TIc(W,137887,N);m=10}else if((m|0)==9){f[P>>2]=e;TIc(W,137923,P);m=10}else if((m|0)==18){nxc(a,0);f[Q>>2]=g;k=YMc(a,125960,Q)|0;f[V>>2]=k;Fyc(a);k=1;m=46}else if((m|0)==34){nxc(a,0);f[O>>2]=o;k=YMc(a,137964,O)|0;f[V>>2]=k;Fyc(a);k=1;m=46}else if((m|0)==43)if(!k)m=44;else m=46;if((m|0)==10){k=W+4|0;if(f[k>>2]|0){nxc(a,0);f[V>>2]=f[k>>2];f[k>>2]=0}Fyc(a);k=1;m=47}else if((m|0)==44)if(!(b[L>>0]|0)){f[l>>2]=U;Z=0;V=f[V>>2]|0;U=(V|0)==0;U=U?0:118856;f[X>>2]=V;BIc(a,Z,U,X);nxc(a,V);qJc(W);Z=PEc(a,Z)|0;X=f[T>>2]|0;bxc(X);t=Y;return Z|0}else{k=0;m=46}if((m|0)==46)if(R)m=47;if((m|0)==47){m=f[S>>2]|0;if(m)oJc(m)|0}nxc(a,U);Z=k;V=f[V>>2]|0;U=(V|0)==0;U=U?0:118856;f[X>>2]=V;BIc(a,Z,U,X);nxc(a,V);qJc(W);Z=PEc(a,Z)|0;X=f[T>>2]|0;bxc(X);t=Y;return Z|0}function KGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return x7c(a,b,c,d,52)|0}function LGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return x7c(a,b,c,d,53)|0}function MGc(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0;h=a+12|0;axc(f[h>>2]|0);g=PEc(a,o7c(a,b,c&255,d,e,g)|0)|0;bxc(f[h>>2]|0);return g|0}
function NGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;h=a+12|0;axc(f[h>>2]|0);g=r3c(a,b)|0;if(!g){g=1;h=f[h>>2]|0;bxc(h);return g|0}Fzc(g);b=Cyc(g)|0;e=MWc(b)|0;switch(c|0){case 7:{f[d>>2]=e;b=0;break}case 27:{b=FWc(b)|0;f[d>>2]=b;b=0;break}case 28:{b=u7c(b)|0;f[d>>2]=b;b=0;break}case 35:{b=gPc(b)|0;f[d>>2]=b;b=0;break}case 38:{b=f[d>>2]|0;c=T4c(g)|0;f[d>>2]=c;if(b>>>0<256){DWc(g,0,b,0)|0;b=0}else b=0;break}default:{a=a+428|0;i=f[a>>2]|0;b=EKc(e,c,d)|0;f[a>>2]=i}}Bzc(g);i=b;h=f[h>>2]|0;bxc(h);return i|0}function OGc(a){a=a|0;var b=0,c=0;b=t;t=t+16|0;c=b;Ywc(0,b+8|0,c,a)|0;a=c;G=f[a+4>>2]|0;t=b;return f[a>>2]|0}function PGc(){var a=0,b=0;b=t;t=t+16|0;a=b+8|0;Ywc(0,a,b,0)|0;G=f[a+4>>2]|0;t=b;return f[a>>2]|0}function QGc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return n7c(a,b,c,d)|0}function RGc(a){a=a|0;return 0}function SGc(a){a=a|0;var b=0;b=Kzc(0)|0;if(!b){b=0;return b|0}b=(MNc(b,a*1e3|0)|0)/1e3|0;return b|0}function TGc(a){a=a|0;jHc((a|0)>0?a:0,0)|0;return}function UGc(a){a=a|0;var b=0;b=Lzc()|0;if(b|0)return b|0;b=Mzc(2)|0;axc(b);Yzc(a);bxc(b);b=0;return b|0}function VGc(){return 1}function WGc(a,b){a=a|0;b=b|0;nEc(f[a>>2]|0,b);return}function XGc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;g=t;t=t+32|0;e=g;d=g+16|0;f[e>>2]=c;do switch(a|0){case 5:{i7c();e=0;t=g;return e|0}case 6:{j7c();e=0;t=g;return e|0}case 28:{c=(f[e>>2]|0)+(4-1)&~(4-1);a=f[c>>2]|0;f[e>>2]=c+4;c=(f[e>>2]|0)+(4-1)&~(4-1);d=f[c>>2]|0;f[e>>2]=c+4;if(d){e=f[f[(f[d+16>>2]|0)+12>>2]>>2]|0;a=(e|0)==0?a:e}f[10243]=a;$Ac(0,0);e=0;t=g;return e|0}case 8:{a=(f[e>>2]|0)+(4-1)&~(4-1);d=f[a>>2]|0;f[e>>2]=a+4;a=(f[e>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[e>>2]=a+4;e=k7c(d,c)|0;t=g;return e|0}case 9:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;f[10239]=c;e=nMc(0)|0;t=g;return e|0}case 10:{a=(f[e>>2]|0)+(4-1)&~(4-1);d=f[a>>2]|0;f[e>>2]=a+4;a=(f[e>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[e>>2]=a+4;l7c(d,c);e=0;t=g;return e|0}case 11:{a=f[19118]|0;c=(f[e>>2]|0)+(4-1)&~(4-1);d=f[c>>2]|0;f[e>>2]=c+4;if(!d){e=a;t=g;return e|0}f[19118]=d;e=a;t=g;return e|0}case 12:{f[d>>2]=0;e=f[d>>2]|0;t=g;return e|0}case 13:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;e=c;t=g;return e|0}case 22:{e=10;t=g;return e|0}case 15:{a=(f[e>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[e>>2]=a+4;a=(f[e>>2]|0)+(4-1)&~(4-1);d=f[a>>2]|0;f[e>>2]=a+4;f[c+76>>2]=d;e=0;t=g;return e|0}case 18:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;f[10240]=c;e=0;t=g;return e|0}case 17:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;e=c+24|0;f[e>>2]=f[e>>2]^32;e=0;t=g;return e|0}case 20:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;f[10182]=c;e=0;t=g;return e|0}case 29:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;b[40721]=c;e=0;t=g;return e|0}case 19:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;f[10241]=c;e=0;t=g;return e|0}case 31:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;d=(f[e>>2]|0)+(4-1)&~(4-1);a=f[d>>2]|0;f[e>>2]=d+4;switch(c|0){case 0:{f[a>>2]=f[38496];e=0;t=g;return e|0}case 1:{f[38496]=f[a>>2];e=0;t=g;return e|0}case 2:{f[a>>2]=f[38497];e=0;t=g;return e|0}case 3:{f[38497]=f[a>>2];e=0;t=g;return e|0}default:{e=0;t=g;return e|0}}}case 24:{a=(f[e>>2]|0)+(4-1)&~(4-1);c=f[a>>2]|0;f[e>>2]=a+4;a=(f[e>>2]|0)+(4-1)&~(4-1);d=f[a>>2]|0;f[e>>2]=a+4;f[c+160>>2]=d;e=0;t=g;return e|0}case 23:{e=(f[10230]|0)==0&1;t=g;return e|0}case 25:{d=(f[e>>2]|0)+(4-1)&~(4-1);a=f[d>>2]|0;f[e>>2]=d+4;d=a+12|0;axc(f[d>>2]|0);i=(f[e>>2]|0)+(4-1)&~(4-1);c=f[i>>2]|0;f[e>>2]=i+4;c=(sIc(a,c)|0)&255;b[a+168>>0]=c;c=(f[e>>2]|0)+(4-1)&~(4-1);i=f[c>>2]|0;f[e>>2]=c+4;c=a+170|0;i=i&1;b[c>>0]=i<<1&255|b[c>>0]&-3;c=a+169|0;b[c>>0]=i;i=(f[e>>2]|0)+(4-1)&~(4-1);h=f[i>>2]|0;f[e>>2]=i+4;f[a+164>>2]=h;if(!((h|0)==0|(b[c>>0]|0)!=0))uOc(a);bxc(f[d>>2]|0);i=0;t=g;return i|0}case 27:{h=(f[e>>2]|0)+(4-1)&~(4-1);i=f[h>>2]|0;f[e>>2]=h+4;m7c(i);i=0;t=g;return i|0}case 30:{f[e>>2]=((f[e>>2]|0)+(4-1)&~(4-1))+4;h=(f[e>>2]|0)+(4-1)&~(4-1);i=f[h>>2]|0;f[e>>2]=h+4;f[i>>2]=0;f[i+4>>2]=0;i=0;t=g;return i|0}default:{i=0;t=g;return i|0}}while(0);return 0}function YGc(a,b){a=a|0;b=b|0;var c=0;c=a+12|0;axc(f[c>>2]|0);f[a+68>>2]=(b|0)==0?255:-1;bxc(f[c>>2]|0);return 0}function ZGc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if(b>>>0>11){c=-1;return c|0}a=a+112+(b<<2)|0;d=f[a>>2]|0;if((c|0)<=-1){c=d;return c|0}b=f[23152+(b<<2)>>2]|0;f[a>>2]=(b|0)<(c|0)?b:c;c=d;return c|0}function _Gc(a,b){a=a|0;b=b|0;var c=0;c=a+12|0;axc(f[c>>2]|0);b=f[((b|0)==0?a+4|0:b+8|0)>>2]|0;bxc(f[c>>2]|0);return b|0}function $Gc(a){a=a|0;if(!a){a=0;return a|0}a=f[a+188>>2]|0;return a|0}function aHc(a){a=a|0;var b=0,c=0,d=0,e=0;if(!a){e=0;return e|0}d=f[a+20>>2]|0;axc(f[d+12>>2]|0);e=a+24|0;Fzc(f[e>>2]|0);b=f[a>>2]|0;if(b|0?(axc(f[b+12>>2]|0),f[a>>2]|0):0){c=(f[e>>2]|0)+16|0;f[c>>2]=(f[c>>2]|0)+-1}if(f[a+40>>2]|0){b=f7c(Cyc(f[e>>2]|0)|0)|0;while(1){c=f[b>>2]|0;if((c|0)==(a|0))break;else b=c+44|0}f[b>>2]=f[a+44>>2]}sOc(f[a+4>>2]|0,0,0);c=f[a+28>>2]|0;c=(c|0)==101?0:c;b=f[a>>2]|0;if(b|0){SEc(b,c);v3c(f[a>>2]|0)}Bzc(f[e>>2]|0);if(f[a>>2]|0)qxc(a);v3c(d);e=c;return e|0}function bHc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;h=c+12|0;axc(f[h>>2]|0);i=a+12|0;axc(f[i>>2]|0);do if((c|0)==(a|0)){BIc(c,1,137642,j);e=0}else{e=DCc(48,0)|0;if(!e){SEc(a,7);e=0;break}d=g7c(a,c,d)|0;g=e+24|0;f[g>>2]=d;d=g7c(a,a,b)|0;f[e+4>>2]=d;f[e>>2]=a;f[e+20>>2]=c;f[e+16>>2]=1;f[e+40>>2]=0;if(!((d|0)==0|(f[g>>2]|0)==0)?(h7c(a,d)|0)==0:0){c=(f[g>>2]|0)+16|0;f[c>>2]=(f[c>>2]|0)+1;break}qxc(e);e=0}while(0);bxc(f[i>>2]|0);bxc(f[h>>2]|0);t=j;return e|0}function cHc(a){a=a|0;return f[a+36>>2]|0}function dHc(a){a=a|0;return f[a+32>>2]|0}function eHc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0;z=t;t=t+16|0;n=z+4|0;s=z;x=a+20|0;axc(f[(f[x>>2]|0)+12>>2]|0);y=a+24|0;Fzc(f[y>>2]|0);d=f[a>>2]|0;if(d|0)axc(f[d+12>>2]|0);w=a+28|0;e=f[w>>2]|0;if(!(XLc(e)|0)){d=f[y>>2]|0;q=Cyc(d)|0;u=a+4|0;r=Cyc(f[u>>2]|0)|0;if((f[a>>2]|0)!=0?(b[(f[d+4>>2]|0)+20>>0]|0)==2:0){v=0;d=5}else if(!(tIc(d)|0)){v=1;d=dPc(d,0,0)|0}else{v=0;d=0}e=a+12|0;if((f[e>>2]|d|0)==0?(b7c(a)|0)==7:0)d=7;else if(!d)if(!(f[e>>2]|0)){d=dPc(f[u>>2]|0,2,a+8|0)|0;if(!d){f[e>>2]=1;d=0}}else d=0;h=f[y>>2]|0;p=ZLc(h)|0;j=f[u>>2]|0;o=ZLc(j)|0;j=(SMc(Cyc(j)|0)|0)==5;h=bMc(h)|0;i=a+16|0;g=0;d=(p|0)==(o|0)|(d|0)==0&j^1?d:8;while(1){if(g>>>0>=c>>>0)break;e=f[i>>2]|0;if(!((d|0)==0&e>>>0<=h>>>0))break;if((e|0)==((((f[19118]|0)>>>0)/((f[(f[(f[y>>2]|0)+4>>2]|0)+36>>2]|0)>>>0)|0)+1|0))d=0;else{d=GKc(q,e,n,2)|0;if(!d){d=YLc(a,e,$Lc(f[n>>2]|0)|0,0)|0;cMc(f[n>>2]|0)}e=f[i>>2]|0}f[i>>2]=e+1;g=g+1|0}switch(d|0){case 0:{f[a+36>>2]=h;m=f[i>>2]|0;f[a+32>>2]=h+1-m;if(m>>>0<=h>>>0)if(!(f[a+40>>2]|0)){c7c(a);d=0}else d=0;else k=26;break}case 101:{k=26;break}default:{}}a:do if((k|0)==26){if(!h){d=d7c(f[u>>2]|0)|0;switch(d|0){case 0:case 101:{c=1;break}default:break a}}else c=h;d=S3c(f[u>>2]|0,1,(f[a+8>>2]|0)+1|0)|0;if(!d){d=f[a>>2]|0;if(d|0)uOc(d);if(j?(l=E4c(f[u>>2]|0,2)|0,l|0):0){d=l;break}if((p|0)<(o|0)){e=(o|0)/(p|0)|0;e=(c+-1+e|0)/(e|0)|0;e=e+(((e|0)==((((f[19118]|0)>>>0)/((f[(f[(f[u>>2]|0)+4>>2]|0)+36>>2]|0)>>>0)|0)+1|0))<<31>>31)|0;i=((c|0)<0)<<31>>31;m=MWc(r)|0;OJc(r,n);g=f[n>>2]|0;d=0;while(1){h=(d|0)==0;if(e>>>0>g>>>0|h^1)break;if((e|0)!=((((f[19118]|0)>>>0)/((f[(f[(f[u>>2]|0)+4>>2]|0)+36>>2]|0)>>>0)|0)+1|0)){d=GKc(r,e,s,0)|0;if(!d){d=PJc(f[s>>2]|0)|0;cMc(f[s>>2]|0)}}e=e+1|0}l=((p|0)<0)<<31>>31;j=Brd(c|0,i|0,p|0,l|0)|0;k=G;if(h)d=mNc(r,0,1)|0;h=f[19118]|0;i=h+o|0;c=((i|0)<0)<<31>>31;g=(k|0)>(c|0)|(k|0)==(c|0)&j>>>0>i>>>0;i=g?i:j;c=g?c:k;h=h+p|0;g=((h|0)<0)<<31>>31;while(1){e=(d|0)==0;if(!(((g|0)<(c|0)|(g|0)==(c|0)&h>>>0<i>>>0)&e))break;f[s>>2]=0;d=zrd(h|0,g|0,p|0,l|0)|0;d=GKc(q,d+1|0,s,0)|0;if(!d)d=iKc(m,$Lc(f[s>>2]|0)|0,p,h,g)|0;cMc(f[s>>2]|0);o=vrd(h|0,g|0,p|0,l|0)|0;g=G;h=o}if(e){d=e7c(m,j,k)|0;if(!d)d=LLc(r,0)|0}}else{lNc(r,V((p|0)/(o|0)|0,c)|0);d=mNc(r,0,0)|0}if(!d){d=WMc(f[u>>2]|0,0)|0;d=(d|0)==0?101:d}}}while(0);if(v|0){VMc(f[y>>2]|0,0)|0;WMc(f[y>>2]|0,0)|0}e=(d|0)==3082?7:d;f[w>>2]=e}d=f[a>>2]|0;if(!d){y=f[y>>2]|0;Bzc(y);y=f[x>>2]|0;y=y+12|0;y=f[y>>2]|0;bxc(y);t=z;return e|0}bxc(f[d+12>>2]|0);y=f[y>>2]|0;Bzc(y);y=f[x>>2]|0;y=y+12|0;y=f[y>>2]|0;bxc(y);t=z;return e|0}function fHc(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return yIc(a,b,c,d,e,f,g,h,0,0,i)|0}function gHc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;d=k;f[d>>2]=c;switch(b|0){case 1e3:{i=(f[d>>2]|0)+(4-1)&~(4-1);j=f[i>>2]|0;f[d>>2]=i+4;f[f[a+16>>2]>>2]=j;j=0;t=k;return j|0}case 1001:{g=(f[d>>2]|0)+(4-1)&~(4-1);h=f[g>>2]|0;f[d>>2]=g+4;g=(f[d>>2]|0)+(4-1)&~(4-1);i=f[g>>2]|0;f[d>>2]=g+4;g=(f[d>>2]|0)+(4-1)&~(4-1);j=f[g>>2]|0;f[d>>2]=g+4;j=a7c(a,h,i,j)|0;t=k;return j|0}default:{i=0;while(1){if(i>>>0>=16){c=1;j=17;break}if((f[23024+(i<<3)>>2]|0)==(b|0))break;i=i+1|0}if((j|0)==17){t=k;return c|0}g=(f[d>>2]|0)+(4-1)&~(4-1);c=f[g>>2]|0;f[d>>2]=g+4;g=(f[d>>2]|0)+(4-1)&~(4-1);h=f[g>>2]|0;f[d>>2]=g+4;d=a+32|0;g=d;e=f[g>>2]|0;g=f[g+4>>2]|0;if((c|0)<=0)if(!c){c=e&~f[23024+(i<<3)+4>>2];b=g;j=11}else{c=e;b=g}else{c=e|f[23024+(i<<3)+4>>2];b=g;j=11}if((j|0)==11){j=d;f[j>>2]=c;f[j+4>>2]=b}if(!((e|0)==(c|0)&(g|0)==(b|0)))CIc(a,0);if(!h){j=0;t=k;return j|0}f[h>>2]=(0?1:(f[d>>2]&f[23024+(i<<3)+4>>2]|0)!=0)&1;j=0;t=k;return j|0}}return 0}function hHc(a){a=a|0;return f[a+12>>2]|0}function iHc(a){a=a|0;if(!a){a=7;return a|0}if(!(g3c(a)|0)){a=Zwc(166605)|0;return a|0}if(b[a+83>>0]|0){a=7;return a|0}a=f[a+64>>2]|0;return a|0}function jHc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;if(Lzc()|0){c=-1;d=-1;G=c;return d|0}axc(f[37666]|0);c=150672;d=f[c>>2]|0;c=f[c+4>>2]|0;if((b|0)<0){bxc(f[37666]|0);G=c;return d|0}else{g=150680;h=f[g>>2]|0;g=f[g+4>>2]|0;e=((g|0)>0|(g|0)==0&h>>>0>0)&((a|0)==0&(b|0)==0|((g|0)<(b|0)|(g|0)==(b|0)&h>>>0<a>>>0));a=e?h:a;g=e?g:b;b=150672;f[b>>2]=a;f[b+4>>2]=g;b=yxc()|0;e=G;f[37672]=((g|0)>0|(g|0)==0&a>>>0>0)&((g|0)<(e|0)|(g|0)==(e|0)&a>>>0<=b>>>0)&1;bxc(f[37666]|0);PGc()|0;G=c;return d|0}return 0}function kHc(){return 118432}function lHc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=t;t=t+16|0;d=e;if((b|0)==99){g=f[a>>2]|0;c=g+12|0;axc(f[c>>2]|0);f[d>>2]=0;b=g+504|0;f[b>>2]=d;Jyc(g,a);nxc(g,a);f[b>>2]=0;bxc(f[c>>2]|0);d=f[d>>2]|0;t=e;return d|0}a=a+160+(b<<2)|0;b=f[a>>2]|0;f[d>>2]=b;if(!c){g=b;t=e;return g|0}f[a>>2]=0;g=b;t=e;return g|0}function mHc(a,b){a=a|0;b=b|0;if((b|0)>0){oHc(a,54,b)|0;return 0}else{oHc(a,0,0)|0;return 0}return 0}function nHc(a,b){a=a|0;b=b|0;return BHc(a,b,0,0,0)|0}function oHc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;e=a+12|0;axc(f[e>>2]|0);g=a+252|0;d=f[g>>2]|0;f[a+248>>2]=b;f[g>>2]=c;bxc(f[e>>2]|0);return d|0}function pHc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=t;t=t+16|0;e=i;d=i+4|0;if(!a){h=Zwc(94718)|0;t=i;return h|0}g=f[a+20>>2]|0;h=g+12|0;axc(f[h>>2]|0);if(!(f[a+16>>2]|0))a=4;else{a=y3c(a,b,c,d)|0;if(a|0){d=f[d>>2]|0;f[e>>2]=d;BIc(g,a,(d|0)==0?0:118856,e);nxc(g,d)}}g=PEc(g,a)|0;bxc(f[h>>2]|0);h=g;t=i;return h|0}function qHc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=t;t=t+16|0;e=i;h=a+12|0;axc(f[h>>2]|0);g=f[a+376>>2]|0;if(!g)c=Zwc(143213)|0;else{f[e>>2]=d;switch(c|0){case 1:{d=(f[e>>2]|0)+(4-1)&~(4-1);c=f[d>>2]|0;f[e>>2]=d+4;b[(f[g>>2]|0)+16>>0]=c;c=0;break}case 2:{b[(f[g>>2]|0)+17>>0]=0;c=0;break}case 3:{b[(f[g>>2]|0)+17>>0]=2;c=0;break}default:c=Zwc(143231)|0}}if(!c){h=f[h>>2]|0;bxc(h);t=i;return c|0}SEc(a,c);h=f[h>>2]|0;bxc(h);t=i;return c|0}function rHc(a){a=a|0;return h[135543+((h[a+88>>0]|0)+-1)>>0]|0|0}function sHc(a){a=a|0;return s3c(a,1)|0}function tHc(a,b){a=a|0;b=b|0;a=r3c(a,b)|0;if(!a){b=0;return b|0}b=UMc(a)|0;return b|0}function uHc(a,b){a=a|0;b=b|0;a=r3c(a,b)|0;if(!a){b=-1;return b|0}b=M2c(a)|0;return b|0}function vHc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;c=a+12|0;axc(f[c>>2]|0);Byc(a);d=a+20|0;e=a+16|0;b=0;while(1){if((b|0)>=(f[d>>2]|0))break;g=f[(f[e>>2]|0)+(b<<4)+4>>2]|0;if(g|0)p3c(Cyc(g)|0);b=b+1|0}Fyc(a);bxc(f[c>>2]|0);return 0}function wHc(a){a=a|0;return mEc(a)|0}function xHc(a){a=a|0;if(!a){a=0;return a|0}if((f[a+20>>2]|0)!=770837923){a=0;return a|0}a=(f[a+36>>2]|0)>>>31^1;return a|0}function yHc(a){a=a|0;if(!a){a=1;return a|0}a=(j[a+150>>1]|0)>>>7&1;return a|0}function zHc(a,b){a=a|0;b=b|0;if(a)if(!b)a=1;else a=wzc(a,b)|0;else a=((b|0)!=0)<<31>>31;return a|0}function AHc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+16|0;e=g;a=MBc(a,b)|0;if(!a){e=c;G=d;t=g;return e|0}b=(bXc(a,e)|0)==0;d=b?f[e+4>>2]|0:d;e=b?f[e>>2]|0:c;G=d;t=g;return e|0}function BHc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;i=l;if(e|0)f[e>>2]=-1;if(g|0)f[g>>2]=-1;if(d>>>0>3){k=21;t=l;return k|0}k=a+12|0;axc(f[k>>2]|0);if((c|0)!=0?(b[c>>0]|0)!=0:0){h=sIc(a,c)|0;if((h|0)<0){f[i>>2]=c;BIc(a,1,135454,i);h=1}else j=10}else{h=12;j=10}if((j|0)==10){f[a+428>>2]=0;h=m3c(a,h,d,e,g)|0;SEc(a,h)}h=PEc(a,h)|0;if(!(f[a+176>>2]|0))f[a+272>>2]=0;bxc(f[k>>2]|0);k=h;t=l;return k|0}function CHc(a){a=a|0;var b=0,c=0,d=0,e=0;b=Lzc()|0;if(b|0){e=b;return e|0}e=Mzc(2)|0;axc(e);c=f[38495]|0;d=f[38494]|0;b=0;while(1){if(b>>>0>=c>>>0)break;if((f[d+(b<<2)>>2]|0)==(a|0))break;b=b+1|0}if((b|0)==(c|0)){b=GHc(d,(c<<2)+4|0,0)|0;if(!b)b=7;else{f[38494]=b;d=f[38495]|0;f[b+(d<<2)>>2]=a;f[38495]=d+1;b=0}}else b=0;bxc(e);e=b;return e|0}function DHc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;if(e>>>0>0|(e|0)==0&d>>>0>2147483647){jEc(c,f,0);f=18;return f|0}else{f=l3c(a,b,c,d,f,0)|0;return f|0}return 0}function EHc(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;if(e>>>0>0|(e|0)==0&d>>>0>2147483647){jEc(c,f,0);g=18;return g|0}else{g=l3c(a,b,c,d,f,g<<24>>24==4?2:g)|0;return g|0}return 0}function FHc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;g=Mzc(2)|0;axc(g);c=f[38495]|0;d=f[38494]|0;b=c;do{if((b|0)<=0){b=0;h=5;break}b=b+-1|0;e=d+(b<<2)|0}while((f[e>>2]|0)!=(a|0));if((h|0)==5){bxc(g);return b|0}h=c+-1|0;f[38495]=h;f[e>>2]=f[d+(h<<2)>>2];h=1;bxc(g);return h|0}function GHc(a,b,c){a=a|0;b=b|0;c=c|0;if(Lzc()|0){c=0;return c|0}c=Pxc(a,b,c)|0;return c|0}function HHc(){var a=0;if(Lzc()|0)return;a=Mzc(2)|0;axc(a);qxc(f[38494]|0);f[38494]=0;f[38495]=0;bxc(a);return}function IHc(a,b){a=a|0;b=b|0;return RDc(a,b,119689,91)|0}function JHc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;axc(f[(f[a>>2]|0)+12>>2]|0);e=f[a>>2]|0;g=f[e+112>>2]|0;h=((g|0)<0)<<31>>31;if(h>>>0<d>>>0|(h|0)==(d|0)&g>>>0<c>>>0)b=18;else{b=GGc(a,b,c)|0;e=f[a>>2]|0}h=PEc(e,b)|0;bxc(f[(f[a>>2]|0)+12>>2]|0);return h|0}function KHc(a){a=a|0;if((d[a+8>>1]|0)>=0){a=0;return a|0}a=h[a+11>>0]|0;return a|0}function LHc(a,c){a=a|0;c=c|0;a=f[a>>2]|0;b[a+11>>0]=c;c=a+8|0;d[c>>1]=d[c>>1]|-32768;return}function MHc(a,b,c){a=a|0;b=b|0;c=c|0;return RDc(a,b,119698,c)|0}function NHc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;i=a+12|0;axc(f[i>>2]|0);Byc(a);e=a+20|0;g=a+16|0;d=0;b=0;h=0;while(1){if(b|0){c=0;break}if((d|0)>=(f[e>>2]|0)){b=0;c=1;break}b=f[(f[g>>2]|0)+(d<<4)+4>>2]|0;if((b|0)!=0?(tIc(b)|0)==2:0){b=k3c(Cyc(b)|0)|0;c=(b|0)==5;b=c?0:b;c=c?1:h}else{b=0;c=h}d=d+1|0;h=c}Fyc(a);bxc(f[i>>2]|0);return ((h|0)!=0&c?5:b)|0}function OHc(a){a=a|0;if(!a){a=0;return a|0}a=f[a+72>>2]|0;return a|0}function PHc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;g=a+12|0;axc(f[g>>2]|0);d=(c|0)==0?0:d;b[a+90>>0]=(d|0)==0?0:c&255;f[a+204>>2]=d;f[a+208>>2]=e;bxc(f[g>>2]|0);return 0}function QHc(a){a=a|0;var b=0;b=$Gc(a)|0;if(!b){b=0;return b|0}axc(f[(f[a>>2]|0)+12>>2]|0);b=h3c(a,b)|0;bxc(f[(f[a>>2]|0)+12>>2]|0);return b|0}function RHc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+12|0;axc(f[d>>2]|0);a=a+40|0;f[a>>2]=b;f[a+4>>2]=c;bxc(f[d>>2]|0);return}function SHc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return cJc(a,b,c,d&15|128,0,e,f)|0}function THc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return $Ic(a,b,c,d&15|128,e,f)|0}function UHc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=YIc(a,b)|0;if(!g){WIc((f[a+100>>2]|0)+((b+-1|0)*40|0)|0,c,d,e);bxc(f[(f[a>>2]|0)+12>>2]|0);return g|0}if(!e)return g|0;Hd[e&1023](c);return g|0}function VHc(a,b,c,e){a=a|0;b=b|0;c=c|0;e=e|0;a=f[a>>2]|0;kyc(a);d[a+8>>1]=1;WIc(a,b,c,e);return}function WHc(a,c){a=a|0;c=c|0;if(!(c|0?(d[a+8>>1]&-15425)<<16>>16==-32255:0)){c=0;return c|0}if((b[a+11>>0]|0)!=112){c=0;return c|0}if(ncd(f[a>>2]|0,c)|0){c=0;return c|0}c=f[a+16>>2]|0;return c|0}function XHc(a){a=a|0;return YHc(f[a>>2]|0)|0}function YHc(a){a=a|0;return (d[a+8>>1]&16385)==16385|0}function ZHc(a,b){a=a|0;b=b|0;if((b|0)<=-1){a=0;return a|0}if((f[a>>2]|0)<=(b|0)){a=0;return a|0}b=f[(f[(f[a+72>>2]|0)+20>>2]|0)+((f[(f[a+4>>2]|0)+(b*12|0)+8>>2]|0)*48|0)>>2]|0;if(!(f[b+12>>2]|0)){a=120777;return a|0}b=LIc(f[a+76>>2]|0,b)|0;if(!b){a=120777;return a|0}a=f[b>>2]|0;return a|0}function _Hc(){return 147}function $Hc(a,b,c){a=a|0;b=b|0;c=c|0;if(a>>>0>146){c=1;return c|0}f[b>>2]=6160+(j[5856+(a<<1)>>1]|0);f[c>>2]=h[5696+a>>0];c=0;return c|0}function aIc(a,b){a=a|0;b=b|0;return (JIc(a,b)|0)!=59|0}function bIc(a){a=a|0;var b=0;b=XAc(24,0)|0;if(!b){b=77588;return b|0}if(!a)a=1e9;else a=f[a+112>>2]|0;fxc(b,0,0,0,a);return b|0}function cIc(a){a=a|0;var b=0;if(!((a|0)!=0&(a|0)!=77588)){a=0;return a|0}b=hxc(a)|0;qxc(a);a=b;return a|0}function dIc(a){a=a|0;if(!a){a=7;return a|0}a=h[a+20>>0]|0;return a|0}function eIc(a){a=a|0;if(!a){a=0;return a|0}a=f[a+16>>2]|0;return a|0}function fIc(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return yIc(a,b,c,d,e,0,f,g,h,i,j)|0}function gIc(a){a=a|0;if(!a){a=0;return a|0}a=(j[a+150>>1]|0)>>>2&3;return a|0}function hIc(a){a=a|0;return (j[a+8>>1]|0)>>>6&1|0}function iIc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;g=(b|0)==0;c=f[a+368>>2]|0;while(1){if(!c)break;h=f[c>>2]|0;d=(f[c+8>>2]|0)+4|0;a:do if(g)i=7;else{c=0;while(1){e=f[b+(c<<2)>>2]|0;if(!e){i=7;break a}if(!(ncd(e,f[d>>2]|0)|0))break;else c=c+1|0}}while(0);if((i|0)==7){i=0;vIc(a,f[d>>2]|0,0,0,0)|0}c=h}return 0}function jIc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;if(Lzc()|0){c=-1;d=-1;G=c;return d|0}axc(f[37666]|0);c=150680;d=f[c>>2]|0;c=f[c+4>>2]|0;if((b|0)>-1|(b|0)==-1&a>>>0>4294967295?(e=150680,f[e>>2]=a,f[e+4>>2]=b,e=150672,g=f[e>>2]|0,e=f[e+4>>2]|0,(e|0)>(b|0)|(e|0)==(b|0)&g>>>0>a>>>0|(g|0)==0&(e|0)==0):0){g=150672;f[g>>2]=a;f[g+4>>2]=b}bxc(f[37666]|0);e=c;g=d;G=e;return g|0}function kIc(a,c){a=a|0;c=c|0;var d=0;if((a|0)==0|(c|0)<0){d=0;return d|0}d=c;c=TBc(a)|0;while(1){c=c+((Mxc(c)|0)+1)|0;a=(b[c>>0]|0)==0;if(!((d|0)>0&(a^1)))break;d=d+-1|0;c=c+((Mxc(c)|0)+1)|0}d=a?0:c;return d|0}function lIc(a){a=a|0;return TBc(a)|0}function mIc(a){a=a|0;a=TBc(a)|0;while(1){a=a+((Mxc(a)|0)+1)|0;if(!(b[a>>0]|0))break;a=a+((Mxc(a)|0)+1)|0}return a+1|0}function nIc(a){a=a|0;a=mIc(a)|0;return a+((Mxc(a)|0)+1)|0}function oIc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;i=udd(a)|0;h=udd(c)|0;j=e<<1;e=0;h=i+10+h+(udd(d)|0)|0;i=0;while(1){if((e|0)>=(j|0))break;k=vrd(h|0,i|0,(udd(f[g+(e<<2)>>2]|0)|0)+1|0,0)|0;e=e+1|0;h=k;i=G}e=XAc(h,i)|0;if(!e){k=0;return k|0}b[e>>0]=0;b[e+1>>0]=0;b[e+2>>0]=0;b[e+3>>0]=0;i=e+4|0;e=uIc(i,a)|0;h=0;while(1){if((h|0)>=(j|0))break;e=uIc(e,f[g+(h<<2)>>2]|0)|0;h=h+1|0}b[e>>0]=0;k=uIc(uIc(e+1|0,c)|0,d)|0;b[k>>0]=0;b[k+1>>0]=0;k=i;return k|0}function pIc(a){a=a|0;if(!a)return;qxc((TBc(a)|0)+-4|0);return}function qIc(a){a=a|0;var c=0;while(1){c=a+-1|0;if((((b[c>>0]|0)==0?(b[a+-2>>0]|0)==0:0)?(b[a+-3>>0]|0)==0:0)?(b[a+-4>>0]|0)==0:0)break;a=c}return f[(f[a+-8>>2]|0)+60>>2]|0}function rIc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=a+12|0;axc(f[g>>2]|0);if(!b){b=0;e=(f[a+20>>2]|0)+-1|0}else{e=sIc(a,b)|0;b=e;e=(e>>31)+e|0}d=a+16|0;c=-1;while(1){if((b|0)>(e|0))break;a=f[(f[d>>2]|0)+(b<<4)+4>>2]|0;if(!a)a=0;else a=tIc(a)|0;c=(a|0)>(c|0)?a:c;b=b+1|0}bxc(f[g>>2]|0);return c|0}function sIc(a,b){a=a|0;b=b|0;var c=0,d=0;if(!b){b=-1;return b|0}d=(f[a+20>>2]|0)+-1|0;c=(f[a+16>>2]|0)+(d<<4)|0;a=d;while(1){if((a|0)<=-1){c=8;break}if(!(zHc(f[c>>2]|0,b)|0)){c=8;break}if((a|0)==0?(zHc(120709,b)|0)==0:0){a=0;c=8;break}c=c+-16|0;a=a+-1|0}if((c|0)==8)return a|0;return 0}function tIc(a){a=a|0;if(!a){a=0;return a|0}a=h[a+8>>0]|0;return a|0}function uIc(a,b){a=a|0;b=b|0;var c=0;c=udd(b)|0;Krd(a|0,b|0,c+1|0)|0;return a+c+1|0}function vIc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=a+12|0;axc(f[g>>2]|0);wIc(a,b,c,d,e)|0;a=PEc(a,0)|0;if((e|0)!=0&(a|0)!=0)Hd[e&1023](d);bxc(f[g>>2]|0);return a|0}function wIc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;do if(!c){d=0;c=0}else{g=Mxc(b)|0;h=vxc(g+25|0,0)|0;if(h|0){i=h+24|0;Krd(i|0,b|0,g+1|0)|0;f[h+4>>2]=i;f[h>>2]=c;f[h+12>>2]=d;f[h+16>>2]=e;f[h+20>>2]=0;f[h+8>>2]=1;d=h;b=i;c=h;break}Cxc(a);i=0;return i|0}while(0);c=Wyc(a+360|0,b,c)|0;if(!c){i=d;return i|0}if((d|0)==(c|0)){Cxc(a);nxc(a,c);i=0;return i|0}else{xIc(a,c);Uyc(a,c);i=d;return i|0}return 0}function xIc(a,b){a=a|0;b=b|0;var c=0,d=0;b=b+20|0;c=f[b>>2]|0;if(!c)return;d=c+36|0;f[d>>2]=f[d>>2]|16384;Iyc(a,c);f[b>>2]=0;return}function yIc(a,b,c,d,e,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0;n=a+12|0;axc(f[n>>2]|0);do if(l){m=vxc(12,0)|0;if(!m){Cxc(a);Hd[l&1023](e);b=1;break}f[m>>2]=0;f[m+4>>2]=l;f[m+8>>2]=e;b=zIc(a,b,c,d,e,g,h,i,j,k,m)|0;if(!(f[m>>2]|0)){Hd[l&1023](e);qxc(m)}}else b=zIc(a,b,c,d,e,g,h,i,j,k,0)|0;while(0);a=PEc(a,b)|0;bxc(f[n>>2]|0);return a|0}function zIc(a,c,d,e,g,h,i,j,k,l,m){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0;r=t;t=t+16|0;o=r;if((((c|0?(p=(h|0)!=0,!(p&(j|0)!=0)):0)?!((i|0)==0^(j|0)==0):0)?!((d+1|0)>>>0>128|(k|0)==0^(l|0)==0):0)?(Mxc(c)|0)<=255:0){q=e&3672064;switch(e&7){case 4:{e=2;break}case 5:{e=zIc(a,c,d,q|1,g,h,i,j,k,l,m)|0;if(e|0){l=e;t=r;return l|0}e=zIc(a,c,d,q|2,g,h,i,j,k,l,m)|0;if(!e)e=3;else{l=e;t=r;return l|0}break}default:e=e&7}n=e&255;s=AIc(a,c,d,n,0)|0;do if((s|0?(f[s+4>>2]&3|0)==(e|0):0)?(b[s>>0]|0)==(d|0):0){if(!(f[a+176>>2]|0)){CIc(a,0);break}BIc(a,5,120714,o);s=5;t=r;return s|0}while(0);e=AIc(a,c,d,n,1)|0;if(!e){s=7;t=r;return s|0}DIc(a,e);if(m|0)f[m>>2]=(f[m>>2]|0)+1;f[e+36>>2]=m;s=e+4|0;f[s>>2]=(f[s>>2]&3|q)^2097152;f[e+16>>2]=p?h:i;f[e+20>>2]=j;f[e+24>>2]=k;f[e+28>>2]=l;f[e+8>>2]=g;b[e>>0]=d;s=0;t=r;return s|0}s=Zwc(165828)|0;t=r;return s|0}function AIc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;n=Mxc(c)|0;p=a+388|0;j=HIc(p,c)|0;i=0;k=0;while(1){if(!j)break;l=IIc(j,d,e)|0;q=(l|0)>(k|0);r=q?j:i;j=f[j+12>>2]|0;i=r;k=q?l:k}a:do if(!(g<<24>>24)){if(i|0?(f[a+24>>2]&2|0)==0:0){m=i;o=0;l=19;break}j=JCc((n+(h[1680+(h[c>>0]|0)>>0]|0)|0)%23|0,c)|0;k=0;while(1){if(!j){l=10;break a}r=IIc(j,d,e)|0;q=(r|0)>(k|0);l=q?j:i;j=f[j+12>>2]|0;i=l;k=q?r:k}}else l=10;while(0);if((l|0)==10){j=g<<24>>24!=0;if(j&(k|0)<6){g=$Ec(a,n+41|0,0)|0;if(g){i=g+40|0;k=g+32|0;f[k>>2]=i;b[g>>0]=d;f[g+4>>2]=e&255;Krd(i|0,c|0,n+1|0)|0;while(1){j=b[i>>0]|0;if(!(j<<24>>24))break;b[i>>0]=b[1680+(j&255)>>0]|0;i=i+1|0}i=Wyc(p,f[k>>2]|0,g)|0;if((i|0)==(g|0)){nxc(a,g);Cxc(a);r=0;return r|0}else{f[g+12>>2]=i;r=g;return r|0}}else i=g}if(i|0){m=i;o=j;l=19}}if((l|0)==19?o|(f[m+16>>2]|0)!=0:0){r=m;return r|0}r=0;return r|0}function BIc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=t;t=t+16|0;e=g;f[a+64>>2]=b;VEc(a,b);if(!c){SEc(a,b);t=g;return}b=a+268|0;if((f[b>>2]|0)==0?(h=EIc(a)|0,f[b>>2]=h,(h|0)==0):0){t=g;return}f[e>>2]=d;h=FIc(a,c,e)|0;GIc(f[b>>2]|0,h,1,808);t=g;return}function CIc(a,b){a=a|0;b=b|0;var c=0;c=b+1&3;b=a+4|0;while(1){b=f[b>>2]|0;if(!b)break;a=b+150|0;d[a>>1]=d[a>>1]&-4|c;b=b+8|0}return}function DIc(a,b){a=a|0;b=b|0;var c=0;b=f[b+36>>2]|0;if(!b)return;c=(f[b>>2]|0)+-1|0;f[b>>2]=c;if(c|0)return;Hd[f[b+4>>2]&1023](f[b+8>>2]|0);nxc(a,b);return}function EIc(a){a=a|0;var b=0;b=$Ec(a,40,0)|0;if(!b)return b|0;d[b+8>>1]=1;f[b+32>>2]=a;return b|0}function FIc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;e=t;t=t+96|0;g=e+72|0;fxc(g,a,e,70,f[a+112>>2]|0);b[g+21>>0]=1;gxc(g,c,d);c=hxc(g)|0;if((b[g+20>>0]|0)!=7){t=e;return c|0}Cxc(a);t=e;return c|0}function GIc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;if(!a)return;SDc(a,b,-1,c,d)|0;return}function HIc(a,b){a=a|0;b=b|0;b=(ozc(a,b,0)|0)+8|0;return f[b>>2]|0}function IIc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;e=b[a>>0]|0;g=(e<<24>>24|0)==(c|0);do if(!g)if((c|0)==-2){a=(f[a+16>>2]|0)==0?0:6;return a|0}else{if(e<<24>>24>-1)c=0;else break;return c|0}while(0);g=g?4:1;e=d&255;c=f[a+4>>2]|0;if((c&3|0)!=(e|0))return ((c&e)>>>1&1)+g|0;a=g|2;return a|0}function JIc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;f[c>>2]=59;KIc(a,b,c)|0;t=d;return f[c>>2]|0}function KIc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,k=0,l=0,m=0;if((c|0)<=1)return c|0;e=b[a>>0]|0;i=e&-33;k=a+1|0;e=h[5568+((h[1680+(e&255)>>0]<<2^c^(h[1680+(h[a+(c+-1)>>0]|0)>>0]|0)*3|0)%127|0)>>0]|0;a:while(1){g=e+-1|0;if(!e){m=12;break}if(((h[5696+g>>0]|0)==(c|0)?(l=6160+(j[5856+(g<<1)>>1]|0)|0,i<<24>>24==(b[l>>0]|0)):0)?(b[k>>0]&-33)<<24>>24==(b[l+1>>0]|0):0){e=2;while(1){if((e|0)>=(c|0))break a;if((b[a+e>>0]&-33)<<24>>24==(b[l+e>>0]|0))e=e+1|0;else break}}e=h[6992+g>>0]|0}if((m|0)==12)return c|0;f[d>>2]=h[6832+g>>0];return c|0}function LIc(a,b){a=a|0;b=b|0;var c=0;c=(f[b+4>>2]&512|0)==0;return MIc(a,f[(c?b+12|0:b+16|0)>>2]|0,f[(c?b+16|0:b+12|0)>>2]|0)|0}function MIc(a,b,c){a=a|0;b=b|0;c=c|0;if(f[b+4>>2]&256|0){c=NIc(a,b)|0;return c|0}if(c|0?f[c+4>>2]&256|0:0){c=NIc(a,c)|0;return c|0}b=NIc(a,b)|0;if(b|0){c=b;return c|0}c=NIc(a,c)|0;return c|0}function NIc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0;m=f[a>>2]|0;l=m+83|0;a:while(1){if(!c){c=0;break}e=b[c>>0]|0;if(e<<24>>24==-81)e=h[c+2>>0]|0;else e=e&255;switch((e&255)<<24>>24){case 112:{k=12;break a}case 77:case -90:case -88:{g=f[c+44>>2]|0;if(g|0){k=7;break a}if((e|0)==112){k=12;break a}else k=13;break}case 36:case -83:{c=c+12|0;k=22;break}case -80:{c=(f[c+20>>2]|0)+4|0;k=22;break}default:k=13}b:do if((k|0)==13){k=0;g=f[c+4>>2]|0;if(!(g&256)){c=0;break a}e=f[c+12>>2]|0;if(e|0?f[e+4>>2]&256|0:0){c=e;break}j=f[c+16>>2]|0;i=f[c+20>>2]|0;if((i|0)!=0?(g&2048|0)==0&(b[l>>0]|0)==0:0){g=f[i>>2]|0;e=0;while(1){if((e|0)>=(g|0)){c=j;break b}c=f[i+4+(e<<4)>>2]|0;if(!(f[c+4>>2]&256))e=e+1|0;else break}}else c=j}else if((k|0)==22){k=0;c=f[c>>2]|0}while(0)}if((k|0)==7){c=d[c+32>>1]|0;if(c<<16>>16>-1)c=OIc(m,b[m+80>>0]|0,f[(f[g+4>>2]|0)+((c<<16>>16)*20|0)+8>>2]|0,0)|0;else c=0}else if((k|0)==12)c=PIc(a,b[m+80>>0]|0,0,f[c+8>>2]|0)|0;a=(QIc(a,c)|0)==0;return (a?c:0)|0}function OIc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;if(!c)return f[a+8>>2]|0;else{d=VIc(a,c,d)|0;return ((d|0)==0?0:d+(((b&255)+-1|0)*20|0)|0)|0}return 0}function PIc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;i=j;h=f[a>>2]|0;if(!c){c=OIc(h,b,d,0)|0;if(c|0){e=c;g=3}}else{e=c;g=3}if((g|0)==3?f[e+12>>2]|0:0){i=e;t=j;return i|0}RIc(h,b&255,d);c=OIc(h,b,d,0)|0;if(c|0){if(f[c+12>>2]|0){i=c;t=j;return i|0}if(!(SIc(h,c)|0)){i=c;t=j;return i|0}}f[i>>2]=d;TIc(a,120784,i);f[a+12>>2]=257;i=0;t=j;return i|0}function QIc(a,c){a=a|0;c=c|0;if((c|0?(f[c+12>>2]|0)==0:0)?(PIc(a,b[(f[a>>2]|0)+80>>0]|0,c,f[c>>2]|0)|0)==0:0){c=1;return c|0}c=0;return c|0}function RIc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=a+256|0;do if(f[d>>2]|0){e=UIc(a,c)|0;if(!e)return;else{Md[f[d>>2]&31](f[a+264>>2]|0,a,b,e);nxc(a,e);break}}while(0);d=a+260|0;if(!(f[d>>2]|0))return;e=EIc(a)|0;GIc(e,c,1,0);b=Uxc(e,2)|0;if(b|0)Md[f[d>>2]&31](f[a+264>>2]|0,a,h[a+80>>0]|0,b);Ryc(e);return}function SIc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=f[c>>2]|0;d=0;while(1){if(d>>>0>=3){d=1;h=5;break}g=OIc(a,b[120815+d>>0]|0,e,0)|0;if(!(f[g+12>>2]|0))d=d+1|0;else break}if((h|0)==5)return d|0;f[c>>2]=f[g>>2];f[c+4>>2]=f[g+4>>2];f[c+8>>2]=f[g+8>>2];f[c+12>>2]=f[g+12>>2];f[c+16>>2]=0;h=0;return h|0}function TIc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=t;t=t+16|0;h=g;e=f[a>>2]|0;f[h>>2]=d;c=FIc(e,c,h)|0;if(!(b[e+87>>0]|0)){h=a+36|0;f[h>>2]=(f[h>>2]|0)+1;h=a+4|0;nxc(e,f[h>>2]|0);f[h>>2]=c;f[a+12>>2]=1;f[a+260>>2]=0;t=g;return}else{nxc(e,c);t=g;return}}function UIc(a,b){a=a|0;b=b|0;var c=0;if(!b){c=0;return c|0}c=(udd(b)|0)+1|0;a=jxc(a,c,0)|0;if(!a){c=0;return c|0}Krd(a|0,b|0,c|0)|0;c=a;return c|0}function VIc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;g=a+404|0;e=HIc(g,c)|0;if(!((d|0)!=0&(e|0)==0)){a=e;return a|0}d=Mxc(c)|0;e=$Ec(a,d+61|0,0)|0;if(!e){a=e;return a|0}h=e+60|0;f[e>>2]=h;b[e+4>>0]=1;f[e+20>>2]=h;b[e+24>>0]=2;f[e+40>>2]=h;b[e+44>>0]=3;Krd(h|0,c|0,d+1|0)|0;d=Wyc(g,h,e)|0;if(!d){h=e;return h|0}Cxc(a);nxc(a,d);h=0;return h|0}function WIc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;f[a>>2]=(e|0)==0?155644:e;f[a+16>>2]=c;d[a+8>>1]=-31231;b[a+11>>0]=112;f[a+36>>2]=(g|0)==0?809:g;return}function XIc(a){a=a|0;return}function YIc(a,b){a=a|0;b=b|0;var c=0,e=0,g=0;g=t;t=t+16|0;c=g;if(ZIc(a)|0){b=Zwc(84959)|0;t=g;return b|0}axc(f[(f[a>>2]|0)+12>>2]|0);if((f[a+20>>2]|0)==770837923?(f[a+36>>2]|0)<=-1:0){if((b|0)>=1?(d[a+16>>1]|0)>=(b|0):0){c=b+-1|0;e=f[a+100>>2]|0;kyc(e+(c*40|0)|0);d[e+(c*40|0)+8>>1]=1;f[(f[a>>2]|0)+64>>2]=0;e=f[a+208>>2]|0;if(!e){b=0;t=g;return b|0}if(!(e&((b|0)>31?-2147483648:1<<c))){b=0;t=g;return b|0}b=a+150|0;d[b>>1]=d[b>>1]&-4|1;b=0;t=g;return b|0}SEc(f[a>>2]|0,25);bxc(f[(f[a>>2]|0)+12>>2]|0);b=25;t=g;return b|0}SEc(f[a>>2]|0,21);bxc(f[(f[a>>2]|0)+12>>2]|0);f[c>>2]=f[a+188>>2];dxc(21,120818,c);b=Zwc(84967)|0;t=g;return b|0}function ZIc(a){a=a|0;var b=0;b=t;t=t+16|0;if(!a){dxc(21,120858,b);a=1}else a=_Ic(a)|0;t=b;return a|0}function _Ic(a){a=a|0;var b=0;b=t;t=t+16|0;if(!(f[a>>2]|0)){dxc(21,120898,b);a=1}else a=0;t=b;return a|0}function $Ic(a,c,d,e,g,h){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;m=t;t=t+16|0;l=m;f[l>>2]=0;f[g>>2]=0;if((c|0)==0|(aJc(a)|0)==0){a=Zwc(131048)|0;t=m;return a|0}a:do if((d|0)>-1){i=0;while(1){if((i|0)>=(d|0))break a;if((b[c+i>>0]|0)==0?(b[c+(i|1)>>0]|0)==0:0)break a;i=i+2|0}}else i=d;while(0);k=a+12|0;axc(f[k>>2]|0);j=bJc(a,c,i)|0;if(j){i=cJc(a,j,-1,e,0,g,l)|0;d=f[l>>2]|0;if((h|0)!=0&(d|0)!=0){c=c+(dJc(c,PDc(j,d-j|0)|0)|0)|0;f[h>>2]=c}}else i=0;nxc(a,j);a=PEc(a,i)|0;bxc(f[k>>2]|0);t=m;return a|0}function aJc(a){a=a|0;if(a)if((f[a+100>>2]|0)!=-1607883113)if(!(g3c(a)|0))a=0;else{f3c(135353);a=0}else a=1;else{f3c(118535);a=0}return a|0}function bJc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;h=t;t=t+48|0;e=h;g=e;i=g+40|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(i|0));f[e+32>>2]=a;SDc(e,c,d,2,0)|0;Xxc(e,1)|0;if(!(b[a+83>>0]|0)){i=f[e+16>>2]|0;t=h;return i|0}else{kyc(e);f[e+16>>2]=0;i=0;t=h;return i|0}return 0}function cJc(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;var i=0,j=0,k=0;f[g>>2]=0;if((b|0)==0|(aJc(a)|0)==0){k=Zwc(130901)|0;return k|0}k=a+12|0;axc(f[k>>2]|0);Byc(a);a:while(1){i=eJc(a,b,c,d,e,g,h)|0;switch(i|0){case 513:break;case 17:{j=5;break a}default:break a}}b:do if((j|0)==5){fJc(a,-1);c:while(1){i=eJc(a,b,c,d,e,g,h)|0;switch(i|0){case 513:break;case 17:break c;default:break b}}fJc(a,-1);i=17}while(0);Fyc(a);j=PEc(a,i)|0;f[a+428>>2]=0;bxc(f[k>>2]|0);k=j;return k|0}function dJc(a,c){a=a|0;c=c|0;var d=0,e=0,f=0;f=0;d=a+1|0;while(1){if((f|0)>=(c|0))break;e=d+2|0;if((b[d>>0]&-4)<<24>>24==-40)d=(b[e>>0]&-4)<<24>>24==-36?d+4|0:e;else d=e;f=f+1|0}return ~a+d|0}function eJc(a,c,e,g,h,i,j){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0;v=t;t=t+304|0;s=v+16|0;p=v+8|0;o=v;r=v+296|0;u=v+24|0;f[r>>2]=0;Mrd(u|0,0,148)|0;k=u+188|0;l=k+84|0;do{f[k>>2]=0;k=k+4|0}while((k|0)<(l|0));f[u+220>>2]=h;if(g&1|0){b[u+24>>0]=1;m=a+280|0;f[m>>2]=(f[m>>2]|0)+1;d[a+284>>1]=0}b[u+25>>0]=g>>>2&1;a:do if(!(b[a+91>>0]|0)){k=a+20|0;l=a+16|0;h=0;while(1){if((h|0)>=(f[k>>2]|0))break a;m=f[(f[l>>2]|0)+(h<<4)+4>>2]|0;if(m|0?(n=iJc(m)|0,n|0):0)break;h=h+1|0}f[o>>2]=f[(f[l>>2]|0)+(h<<4)>>2];BIc(a,n,120943,o);a=n;qJc(u);t=v;return a|0}while(0);jJc(a);f[u>>2]=a;do if((e|0)>-1){if(e|0?(b[c+(e+-1)>>0]|0)==0:0){q=18;break}if((f[a+116>>2]|0)<(e|0)){BIc(a,18,120973,p);a=PEc(a,18)|0;qJc(u);t=v;return a|0}h=kJc(a,c,e,((e|0)<0)<<31>>31)|0;if(!h){f[u+224>>2]=c+e;break}else{lJc(u,h,r)|0;e=u+224|0;f[e>>2]=c+((f[e>>2]|0)-h);nxc(a,h);break}}else q=18;while(0);if((q|0)==18)lJc(u,c,r)|0;if(j|0)f[j>>2]=f[u+224>>2];if(!(b[a+169>>0]|0))mJc(f[u+8>>2]|0,c,(f[u+224>>2]|0)-c|0,g&255);k=u+12|0;b:do if(!(b[a+83>>0]|0)){switch(f[k>>2]|0){case 101:case 0:break;default:{q=26;break b}}f[i>>2]=f[u+8>>2];pJc(a);h=0}else{f[k>>2]=7;q=26}while(0);do if((q|0)==26){if(b[u+17>>0]|0)nJc(u);h=f[u+8>>2]|0;if(h|0)oJc(h)|0;h=f[k>>2]|0;k=f[r>>2]|0;if(!k){SEc(a,h);break}else{f[s>>2]=k;BIc(a,h,118856,s);nxc(a,k);break}}while(0);k=u+256|0;while(1){l=f[k>>2]|0;if(!l)break;f[k>>2]=f[l+4>>2];nxc(a,l)}qJc(u);t=v;return h|0}function fJc(a,b){a=a|0;b=b|0;var c=0,e=0;if((b|0)>-1){e=f[a+16>>2]|0;c=(f[e+(b<<4)+12>>2]|0)+78|0;d[c>>1]=d[c>>1]|8;e=(f[e+28>>2]|0)+78|0;d[e>>1]=d[e>>1]|8;e=a+24|0;f[e>>2]=f[e>>2]&-17}if(f[a+56>>2]|0)return;e=a+20|0;a=a+16|0;b=0;while(1){if((b|0)>=(f[e>>2]|0))break;c=f[(f[a>>2]|0)+(b<<4)+12>>2]|0;if(d[c+78>>1]&8)gJc(c);b=b+1|0}return}function gJc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0;h=t;t=t+32|0;g=h+16|0;c=h;e=a+8|0;f[g>>2]=f[e>>2];f[g+4>>2]=f[e+4>>2];f[g+8>>2]=f[e+8>>2];f[g+12>>2]=f[e+12>>2];b=a+40|0;f[c>>2]=f[b>>2];f[c+4>>2]=f[b+4>>2];f[c+8>>2]=f[b+8>>2];f[c+12>>2]=f[b+12>>2];hJc(b);vzc(a+24|0);b=c+8|0;while(1){b=f[b>>2]|0;if(!b)break;Hyc(0,f[b+8>>2]|0)}vzc(c);hJc(e);b=g+8|0;while(1){b=f[b>>2]|0;if(!b)break;Iyc(0,f[b+8>>2]|0)}vzc(g);vzc(a+56|0);f[a+72>>2]=0;b=a+78|0;c=d[b>>1]|0;if(!(c&1)){a=c&-10;d[b>>1]=a;t=h;return}a=a+4|0;f[a>>2]=(f[a>>2]|0)+1;a=c&-10;d[b>>1]=a;t=h;return}function hJc(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;return}function iJc(a){a=a|0;var b=0;Fzc(a);b=iPc(a,1,1)|0;Bzc(a);return b|0}function jJc(a){a=a|0;var b=0,c=0;c=a+384|0;b=f[c>>2]|0;if(!b)return;f[c>>2]=0;CIc(a,0);do{c=b;b=f[b+24>>2]|0;Tyc(c)}while((b|0)!=0);return}function kJc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;if(!c){d=0;return d|0}e=vrd(d|0,e|0,1,0)|0;a=uxc(a,e,G)|0;if(!a){d=0;return d|0}Krd(a|0,c|0,d|0)|0;b[a+d>>0]=0;d=a;return d|0}function lJc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=t;t=t+1248|0;j=B+1240|0;w=B+16|0;s=B+8|0;o=B;n=B+1236|0;p=B+24|0;A=f[a>>2]|0;e=f[A+116>>2]|0;k=A+272|0;if(!(f[A+176>>2]|0))f[k>>2]=0;v=a+12|0;f[v>>2]=0;x=a+224|0;f[x>>2]=c;GPc(p,a);y=A+244|0;z=a+124|0;f[z>>2]=f[y>>2];f[y>>2]=a;l=a+188|0;m=a+192|0;i=-1;a:while(1){while(1){h=HPc(c,n)|0;e=e-h|0;if((e|0)<0){u=6;break a}g=f[n>>2]|0;if((g|0)<=162)break;if(f[k>>2]|0){u=9;break a}if((g|0)!=181){u=12;break}c=c+h|0}b:do if((u|0)==12){u=0;if(!(b[c>>0]|0)){switch(i|0){case 0:break a;case 1:{g=0;break}default:g=1}f[n>>2]=g;h=0;break}switch(g|0){case 163:{g=IPc(c+6|0)|0;f[n>>2]=g;break b}case 164:{g=JPc(c+4|0,i)|0;f[n>>2]=g;break b}case 165:{g=KPc(c+6|0,i)|0;f[n>>2]=g;break b}default:{u=20;break a}}}while(0);f[l>>2]=c;f[m>>2]=h;f[j>>2]=f[l>>2];f[j+4>>2]=f[l+4>>2];LPc(p,g,j);c=c+h|0;if(f[v>>2]|0)break;i=f[n>>2]|0}if((u|0)==6)f[v>>2]=18;else if((u|0)==9)f[v>>2]=9;else if((u|0)==20){f[o>>2]=h;f[o+4>>2]=c;TIc(a,121198,o)}MPc(p);if(!(b[A+83>>0]|0)){e=f[v>>2]|0;switch(e|0){case 101:case 0:break;default:{r=e;u=26}}}else{f[v>>2]=7;r=7;u=26}if((u|0)==26?(q=a+4|0,(f[q>>2]|0)==0):0){u=mEc(r)|0;f[s>>2]=u;u=YMc(A,118856,s)|0;f[q>>2]=u}e=a+4|0;g=f[e>>2]|0;if(!g)h=0;else{f[d>>2]=g;h=f[v>>2]|0;d=f[x>>2]|0;f[w>>2]=g;f[w+4>>2]=d;dxc(h,121225,w);f[e>>2]=0;h=1}f[x>>2]=c;e=a+8|0;g=f[e>>2]|0;if((g|0?(f[a+36>>2]|0)>0:0)?(b[a+18>>0]|0)==0:0){sJc(g);f[e>>2]=0}if(!(b[a+18>>0]|0)){x=a+108|0;nxc(A,f[x>>2]|0);f[x>>2]=0;f[a+104>>2]=0}qxc(f[a+252>>2]|0);g=a+200|0;e=b[g>>0]|0;if(!(e<<24>>24)){Iyc(A,f[a+228>>2]|0);e=b[g>>0]|0}if((e&255)>1){a=a+216|0;a=f[a>>2]|0;nxc(A,a);A=f[z>>2]|0;f[y>>2]=A;f[z>>2]=0;t=B;return h|0}Hyc(A,f[a+236>>2]|0);a=a+216|0;a=f[a>>2]|0;nxc(A,a);A=f[z>>2]|0;f[y>>2]=A;f[z>>2]=0;t=B;return h|0}function mJc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;if(!a)return;b[a+148>>0]=e;if(e<<24>>24>-1)f[a+208>>2]=0;e=kJc(f[a>>2]|0,c,d,((d|0)<0)<<31>>31)|0;f[a+188>>2]=e;return}function nJc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;g=k;j=f[a>>2]|0;h=j+20|0;i=j+16|0;e=a+12|0;b=0;a:while(1){if((b|0)>=(f[h>>2]|0)){a=12;break}c=f[(f[i>>2]|0)+(b<<4)+4>>2]|0;if(c|0){if(!(tIc(c)|0)){d=dPc(c,0,0)|0;if((d|0)>=7){a=14;break}switch(d|0){case 0:{a=1;break}default:{a=12;break a}}}else a=0;ePc(c,1,g);if((f[g>>2]|0)!=(f[f[(f[i>>2]|0)+(b<<4)+12>>2]>>2]|0)){fJc(j,b);f[e>>2]=17}if(a|0)fPc(c)|0}b=b+1|0}if((a|0)==12){t=k;return}else if((a|0)==14){b:do if((d|0)<3082){switch(d|0){case 7:break b;default:{}}t=k;return}else{switch(d|0){case 3082:break b;default:{}}t=k;return}while(0);Cxc(j);t=k;return}}function oJc(a){a=a|0;var b=0,c=0;b=f[a+20>>2]|0;if((b|0)<832317811)switch(b|0){case 770837923:{c=2;break}default:b=0}else switch(b|0){case 832317811:{c=2;break}default:b=0}if((c|0)==2)b=rJc(a)|0;sJc(a);return b|0}function pJc(a){a=a|0;f[a+64>>2]=0;a=f[a+268>>2]|0;if(!a)return;UEc(a);return}function qJc(a){a=a|0;var c=0,e=0,g=0;g=f[a>>2]|0;c=a+264|0;while(1){e=f[c>>2]|0;if(!e)break;f[c>>2]=f[e>>2];Jd[f[e+8>>2]&1023](g,f[e+4>>2]|0);oxc(g,e)}nxc(g,f[a+64>>2]|0);c=f[a+68>>2]|0;if(c|0)$yc(g,c);c=a+24|0;if(!g){b[c>>0]=0;return}e=g+280|0;a=(f[e>>2]|0)-(h[c>>0]|0)|0;f[e>>2]=a;if(!a)e=d[g+286>>1]|0;else e=0;d[g+284>>1]=e;b[c>>0]=0;return}function rJc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0;g=t;t=t+16|0;c=g;e=f[a>>2]|0;tJc(a)|0;if((f[a+36>>2]|0)>-1){if((f[e+268>>2]|0)==0?(f[a+124>>2]|0)==0:0)f[e+64>>2]=f[a+40>>2];else uJc(a)|0;b=a+150|0;c=d[b>>1]|0;if(c&32)d[b>>1]=c&-4|1}else{b=f[a+40>>2]|0;if(b|0?d[a+150>>1]&3:0){h=f[a+124>>2]|0;f[c>>2]=h;BIc(e,b,(h|0)==0?0:118856,c)}}b=a+124|0;c=f[b>>2]|0;if(!c){h=a+120|0;f[h>>2]=0;h=a+20|0;f[h>>2]=1224384374;h=a+40|0;h=f[h>>2]|0;e=e+68|0;e=f[e>>2]|0;h=e&h;t=g;return h|0}nxc(e,c);f[b>>2]=0;h=a+120|0;f[h>>2]=0;h=a+20|0;f[h>>2]=1224384374;h=a+40|0;h=f[h>>2]|0;e=e+68|0;e=f[e>>2]|0;h=e&h;t=g;return h|0}function sJc(a){a=a|0;var b=0,c=0,d=0,e=0;d=f[a>>2]|0;Jyc(d,a);e=f[a+4>>2]|0;c=a+8|0;b=f[c>>2]|0;if(!e)f[d+4>>2]=b;else{f[e+8>>2]=b;b=f[c>>2]|0}if(b|0)f[b+4>>2]=e;f[a+20>>2]=1443283912;f[a>>2]=0;oxc(d,a);return}function tJc(a){a=a|0;var c=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0;m=f[a>>2]|0;n=a+20|0;if((f[n>>2]|0)!=770837923){o=0;return o|0}o=m+83|0;if(b[o>>0]|0)f[a+40>>2]=7;vJc(a);k=a+36|0;do if((f[k>>2]|0)>-1){l=a+150|0;if(d[l>>1]&256){wJc(a);h=a+40|0;e=f[h>>2]|0;g=e&255;a:do switch(g<<24>>24){case 13:case 7:case 9:case 10:{c=d[l>>1]|0;if((e&255|0)!=9|(c&128)==0){switch(g<<24>>24){case 7:case 13:{if(c&64){c=2;g=1;break a}break}default:{}}xJc(m,516);yJc(m);b[m+81>>0]=1;f[a+44>>2]=0;c=0;e=f[h>>2]|0;g=1}else{c=0;g=1}break}default:{c=0;g=0}}while(0);if(!((e|0)!=0?g|(b[a+146>>0]|0)!=3:0))zJc(a,0)|0;if((f[m+356>>2]|0)>0?(f[m+380>>2]|0)==0:0)i=29;else if((b[m+81>>0]|0)!=0?(f[m+184>>2]|0)==(((j[l>>1]|0)>>>7&1^1)&65535|0):0){if((f[h>>2]|0)!=0?g|(b[a+146>>0]|0)!=3:0){xJc(m,0);f[a+44>>2]=0}else i=20;b:do if((i|0)==20){c:do if(!(zJc(a,1)|0)){e=BJc(m,a)|0;switch(e|0){case 5:break;case 0:{p=m+488|0;g=m+32|0;f[p>>2]=0;f[p+4>>2]=0;f[p+8>>2]=0;f[p+12>>2]=0;p=g;e=f[p+4>>2]|0;f[g>>2]=f[p>>2]&-524289;f[g+4>>2]=e;CJc(m);break b}default:break c}if(!(d[l>>1]&128))e=5;else{AJc(a);p=5;return p|0}}else if(!(d[l>>1]&128))e=787;else{AJc(a);p=1;return p|0}while(0);f[h>>2]=e;xJc(m,0);f[a+44>>2]=0}while(0);f[m+480>>2]=0;if(!c)c=0;else i=35}else i=29;d:do if((i|0)==29)if(!c)if(!(f[h>>2]|0)){c=1;i=35}else switch(b[a+146>>0]|0){case 3:{c=1;i=35;break d}case 2:{c=2;i=35;break d}default:{xJc(m,516);yJc(m);b[m+81>>0]=1;f[a+44>>2]=0;c=0;break d}}else i=35;while(0);if((i|0)==35){e=DJc(a,c)|0;if(e){p=f[h>>2]|0;if((p|0)==0|(p&255|0)==19){f[h>>2]=e;p=a+124|0;nxc(m,f[p>>2]|0);f[p>>2]=0}xJc(m,516);yJc(m);b[m+81>>0]=1;f[a+44>>2]=0}}if(d[l>>1]&16){if((c|0)==2){EJc(m,0);c=a+44|0}else{c=a+44|0;EJc(m,f[c>>2]|0)}f[c>>2]=0}AJc(a);if((f[k>>2]|0)<=-1)break}c=m+176|0;f[c>>2]=(f[c>>2]|0)+-1;c=d[l>>1]|0;if(!(c&128)){c=m+184|0;f[c>>2]=(f[c>>2]|0)+-1;c=d[l>>1]|0}if(c&256){p=m+180|0;f[p>>2]=(f[p>>2]|0)+-1}}while(0);f[n>>2]=832317811;c=a+40|0;if(!(b[o>>0]|0)){p=(f[c>>2]|0)==5?5:0;return p|0}else{f[c>>2]=7;p=0;return p|0}return 0}function uJc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;g=f[a>>2]|0;h=f[a+40>>2]|0;d=a+124|0;if(!(f[d>>2]|0)){a=f[g+268>>2]|0;if(!a){g=g+64|0;f[g>>2]=h;return h|0}UEc(a);g=g+64|0;f[g>>2]=h;return h|0}else{e=g+84|0;b[e>>0]=(b[e>>0]|0)+1<<24>>24;tzc();c=g+268|0;a=f[c>>2]|0;if(!a){a=EIc(g)|0;f[c>>2]=a}GIc(a,f[d>>2]|0,1,-1);uzc();b[e>>0]=(b[e>>0]|0)+-1<<24>>24;g=g+64|0;f[g>>2]=h;return h|0}return 0}function vJc(a){a=a|0;var b=0,c=0,d=0;d=a+196|0;b=f[d>>2]|0;if(b|0){while(1){c=f[b+4>>2]|0;if(!c)break;else b=c}yOc(b)|0;f[d>>2]=0;f[a+204>>2]=0}zOc(a);b=f[a+88>>2]|0;if(b|0)Lyc(b,f[a+24>>2]|0);b=a+200|0;while(1){c=f[b>>2]|0;if(!c)break;f[b>>2]=f[c+4>>2];AOc(c)}b=a+216|0;if(!(f[b>>2]|0))return;BOc(f[a>>2]|0,b,-1,0);return}function wJc(a){a=a|0;var b=0,c=0,d=0,e=0;d=a+156|0;if(!(f[d>>2]|0))return;c=f[a>>2]|0;b=f[c+16>>2]|0;c=f[c+20>>2]|0;a=0;while(1){if((a|0)>=(c|0))break;if(((a|0)!=1?f[d>>2]&1<<a|0:0)?(e=f[b+(a<<4)+4>>2]|0,e|0):0)Fzc(e);a=a+1|0}return}function xJc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;tzc();Byc(a);if(!(f[a+24>>2]&1))i=0;else i=(b[a+169>>0]|0)==0;k=a+20|0;h=a+16|0;j=(i^1)&1;e=0;g=0;while(1){if((e|0)>=(f[k>>2]|0))break;d=f[(f[h>>2]|0)+(e<<4)+4>>2]|0;if(!d)d=g;else{l=(tIc(d)|0)==2;sOc(d,c,j);d=l?1:g}e=e+1|0;g=d}tOc(a);uzc();if(i){CIc(a,0);uOc(a)}Fyc(a);k=a+488|0;d=a+32|0;f[k>>2]=0;f[k+4>>2]=0;f[k+8>>2]=0;f[k+12>>2]=0;k=d;l=f[k+4>>2]|0;f[d>>2]=f[k>>2]&-524289;f[d+4>>2]=l;d=f[a+232>>2]|0;if(!d)return;if((g|0)==0?b[a+81>>0]|0:0)return;Hd[d&1023](f[a+228>>2]|0);return}function yJc(a){a=a|0;var c=0,d=0;c=a+464|0;while(1){d=f[c>>2]|0;if(!d)break;f[c>>2]=f[d+24>>2];nxc(a,d)}f[a+476>>2]=0;f[a+480>>2]=0;b[a+89>>0]=0;return}function zJc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;g=t;t=t+16|0;e=g;d=f[a>>2]|0;if(!c){d=a+64|0;c=f[d+4>>2]|0;if(!((c|0)>0|(c|0)==0&(f[d>>2]|0)>>>0>0)){e=0;t=g;return e|0}}else{c=d+488|0;d=d+496|0;d=vrd(f[d>>2]|0,f[d+4>>2]|0,f[c>>2]|0,f[c+4>>2]|0)|0;c=G;if(!((c|0)>0|(c|0)==0&d>>>0>0)){e=0;t=g;return e|0}}f[a+40>>2]=787;b[a+146>>0]=2;rOc(a,121164,e);e=1;t=g;return e|0}function AJc(a){a=a|0;if(!(f[a+156>>2]|0))return;qOc(a);return}function BJc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=t;t=t+48|0;r=A+32|0;q=A+24|0;p=A+16|0;o=A;s=A+44|0;k=A+40|0;y=a+20|0;z=a+16|0;h=0;i=0;c=RMc(a,c)|0;e=0;while(1){if(c|0){l=c;x=63;break}if((h|0)>=(f[y>>2]|0))break;g=f[(f[z>>2]|0)+(h<<4)+4>>2]|0;if((tIc(g)|0)==2){Fzc(g);e=Cyc(g)|0;if((b[(f[z>>2]|0)+(h<<4)+8>>0]|0)!=1?(11>>>(SMc(e)|0)&1|0)!=0:0)c=i+((_Lc(e)|0)==0&1)|0;else c=i;e=TMc(e)|0;Bzc(g);g=e;e=1}else{g=0;c=i}h=h+1|0;i=c;c=g}if((x|0)==63){t=A;return l|0}if((e|0?(j=f[a+224>>2]|0,j|0):0)?sd[j&2047](f[a+220>>2]|0)|0:0){z=531;t=A;return z|0}c=UMc(f[(f[z>>2]|0)+4>>2]|0)|0;e=Mxc(c)|0;if((i|0)<2|(e|0)==0){c=0;d=0;while(1){if(d|0)break;if((c|0)>=(f[y>>2]|0)){d=0;break}d=f[(f[z>>2]|0)+(c<<4)+4>>2]|0;if(!d)d=0;else d=VMc(d,0)|0;c=c+1|0}c=0;while(1){if(d|0){l=d;x=63;break}if((c|0)>=(f[y>>2]|0))break;d=f[(f[z>>2]|0)+(c<<4)+4>>2]|0;if(!d)d=0;else d=WMc(d,0)|0;c=c+1|0}if((x|0)==63){t=A;return l|0}XMc(a);z=0;t=A;return z|0}j=f[a>>2]|0;f[s>>2]=0;f[o>>2]=0;f[o+4>>2]=c;f[o+8>>2]=0;l=YMc(a,121047,o)|0;do if(!l)d=7;else{i=l+4|0;e=i+e|0;c=0;while(1){if(c|0){if(c>>>0>100){x=33;break}if((c|0)==1){f[p>>2]=i;dxc(13,121059,p)}}$Ac(4,o);m=f[o>>2]|0;f[r>>2]=m>>>8;f[r+4>>2]=m&255;OAc(13,e,121088,r)|0;m=HLc(j,i,0,k)|0;n=(m|0)==0;if(n&(f[k>>2]|0)!=0)c=c+1|0;else{x=35;break}}if((x|0)==33){f[q>>2]=i;dxc(13,121074,q);uLc(j,i,0)|0;x=36}else if((x|0)==35)if(n)x=36;else d=m;if((x|0)==36){d=ZMc(j,i,s,16406,0)|0;if(!d){h=f[s>>2]|0;g=0;d=0;c=0;while(1){if((g|0)>=(f[y>>2]|0))break;e=f[(f[z>>2]|0)+(g<<4)+4>>2]|0;if((tIc(e)|0)==2?(v=_Mc(e)|0,(v|0)!=0):0){w=iKc(h,v,(Mxc(v)|0)+1|0,d,c)|0;s=(Mxc(v)|0)+1|0;d=vrd(d|0,c|0,s|0,((s|0)<0)<<31>>31|0)|0;if(!w)c=G;else{x=43;break}}g=g+1|0}if((x|0)==43){$Mc(h);uLc(j,i,0)|0;nxc(a,l);d=w;break}if(((tKc(h)|0)&1024|0)==0?(u=sLc(h,2)|0,u|0):0){$Mc(h);uLc(j,i,0)|0;nxc(a,l);d=u;break}d=0;c=0;while(1){if(d|0){x=54;break}if((c|0)>=(f[y>>2]|0))break;d=f[(f[z>>2]|0)+(c<<4)+4>>2]|0;if(!d)d=0;else d=VMc(d,i)|0;c=c+1|0}if((x|0)==54){$Mc(h);nxc(a,l);break}$Mc(h);d=uLc(j,i,1)|0;nxc(a,l);if(d|0)break;tzc();d=0;while(1){if((d|0)>=(f[y>>2]|0))break;c=f[(f[z>>2]|0)+(d<<4)+4>>2]|0;if(c|0)WMc(c,1)|0;d=d+1|0}uzc();XMc(a);z=0;t=A;return z|0}}nxc(a,l)}while(0);z=d;t=A;return z|0}function CJc(a){a=a|0;a=a+24|0;f[a>>2]=f[a>>2]&-2;return}function DJc(a,b){a=a|0;b=b|0;if(!(f[(f[a>>2]|0)+480>>2]|0)){b=0;return b|0}if(!(f[a+48>>2]|0)){b=0;return b|0}b=FJc(a,b)|0;return b|0}function EJc(a,b){a=a|0;b=b|0;f[a+104>>2]=b;a=a+108|0;f[a>>2]=(f[a>>2]|0)+b;return}function FJc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=f[a>>2]|0;h=a+48|0;i=(f[h>>2]|0)+-1|0;j=m+20|0;k=m+16|0;l=(b|0)==2;b=0;d=0;while(1){if((d|0)>=(f[j>>2]|0))break;c=f[(f[k>>2]|0)+(d<<4)+4>>2]|0;if(c){if(l?(e=GJc(c,2,i)|0,(e|0)!=0):0)c=e;else c=GJc(c,1,i)|0;b=(b|0)==0?c:b}d=d+1|0}k=m+480|0;f[k>>2]=(f[k>>2]|0)+-1;f[h>>2]=0;do if(!b){if(l?(g=HJc(m,2,i)|0,g|0):0){b=g;break}b=HJc(m,1,i)|0;n=13}else n=13;while(0);if((n|0)==13)if(!l){n=b;return n|0}k=a+72|0;n=f[k+4>>2]|0;l=m+488|0;f[l>>2]=f[k>>2];f[l+4>>2]=n;l=a+80|0;a=f[l+4>>2]|0;n=m+496|0;f[n>>2]=f[l>>2];f[n+4>>2]=a;n=b;return n|0}function GJc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0;if(!a){a=0;return a|0}if((b[a+8>>0]|0)!=2){a=0;return a|0}h=f[a+4>>2]|0;Fzc(a);if(!((c|0)==2?(g=JJc(h,0,0)|0,(g|0)!=0):0)){g=KJc(f[h>>2]|0,c,e)|0;if(!g){if((e|0)<0?d[h+24>>1]&16:0)f[h+48>>2]=0;g=LJc(h)|0;MJc(h,f[h+12>>2]|0)}}Bzc(a);a=g;return a|0}function HJc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=a+380|0;if(!(f[j>>2]|0)){j=0;return j|0}h=a+356|0;i=c+1|0;a=0;g=0;while(1){if(a|0){d=16;break}if((g|0)>=(f[h>>2]|0)){a=0;d=16;break}e=f[(f[j>>2]|0)+(g<<2)>>2]|0;a=f[f[e+4>>2]>>2]|0;d=e+8|0;if((f[d>>2]|0)!=0?(f[a>>2]|0)>1:0){IJc(e);switch(b|0){case 0:{a=f[a+80>>2]|0;f[e+20>>2]=i;break}case 2:{a=f[a+88>>2]|0;break}default:a=f[a+84>>2]|0}if((a|0)!=0?(f[e+20>>2]|0)>(c|0):0)a=td[a&1023](f[d>>2]|0,c)|0;else a=0;Tyc(e)}else a=0;g=g+1|0}if((d|0)==16)return a|0;return 0}function IJc(a){a=a|0;a=a+12|0;f[a>>2]=(f[a>>2]|0)+1;return}function JJc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;e=(c|0)==0;a=a+8|0;while(1){a=f[a>>2]|0;if(!a)break;if((a|0)!=(d|0)){if(e){g=7;break}if((f[a+64>>2]|0)==(c|0)){g=7;break}}a=a+24|0}if((g|0)==7){g=zMc(a,c,d)|0;return g|0}if(!d){g=0;return g|0}g=d+1|0;b[g>>0]=b[g>>0]&-33;g=0;return g|0}function KJc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0;k=a+40|0;l=f[k>>2]|0;i=(c|0)==1;c=i?0:l;if(c|0){a=c;return a|0}g=a+96|0;c=f[g>>2]|0;if((c|0)<=(d|0)){a=0;return a|0}j=((i^1)&1)+d|0;e=a+92|0;d=j;while(1){if((d|0)>=(c|0))break;rKc(f[(f[e>>2]|0)+(d*48|0)+16>>2]|0);d=d+1|0;c=f[g>>2]|0}f[g>>2]=j;if(i){e=f[e>>2]|0;if(!(f[e+(j*48|0)+28>>2]|0)){a=0;return a|0}c=f[a+68>>2]|0;if(!(f[c>>2]|0)){a=0;return a|0}if(!(SKc(c)|0)){d=0;c=e+(j*48|0)+24|0}else{l=e+(j*48|0)+24|0;d=TKc(c,V((f[a+152>>2]|0)+4|0,f[l>>2]|0)|0,0)|0;c=l}f[a+52>>2]=f[c>>2];a=d;return a|0}if((f[a+216>>2]|0)==0?(f[f[a+64>>2]>>2]|0)==0:0){if((b[a+5>>0]|0)!=2){a=l;return a|0}c=a+16|0;if((h[c>>0]|0)<=2){a=l;return a|0}f[k>>2]=4;b[c>>0]=6;VKc(a);a=l;return a|0}if(!j)c=0;else c=(f[e>>2]|0)+((j+-1|0)*48|0)|0;a=UKc(a,c)|0;return a|0}function LJc(a){a=a|0;var c=0,e=0,g=0,i=0,j=0,k=0;i=a+48|0;if(f[i>>2]|0){k=0;return k|0}j=f[a+12>>2]|0;k=f[j+56>>2]|0;c=PJc(f[j+72>>2]|0)|0;if(c|0){k=c;return k|0}c=k;e=7152;g=c+16|0;do{b[c>>0]=b[e>>0]|0;c=c+1|0;e=e+1|0}while((c|0)<(g|0));c=a+36|0;b[k+16>>0]=(f[c>>2]|0)>>>8;b[k+17>>0]=(f[c>>2]|0)>>>16;b[k+18>>0]=1;b[k+19>>0]=1;b[k+20>>0]=(f[c>>2]|0)-(f[a+40>>2]|0);b[k+21>>0]=64;b[k+22>>0]=32;b[k+23>>0]=32;c=k+24|0;g=c+76|0;do{b[c>>0]=0;c=c+1|0}while((c|0)<(g|0));QJc(j,13);j=a+24|0;d[j>>1]=d[j>>1]|2;RJc(k+52|0,h[a+17>>0]|0);RJc(k+64|0,h[a+18>>0]|0);f[i>>2]=1;b[k+31>>0]=1;k=0;return k|0}function MJc(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;b=NJc((f[b+56>>2]|0)+28|0)|0;f[c>>2]=b;if(!b){OJc(f[a>>2]|0,c);b=f[c>>2]|0}f[a+48>>2]=b;t=d;return}function NJc(a){a=a|0;return (h[a+1>>0]|0)<<16|(h[a>>0]|0)<<24|(h[a+2>>0]|0)<<8|(h[a+3>>0]|0)|0}function OJc(a,b){a=a|0;b=b|0;f[b>>2]=f[a+24>>2];return}function PJc(a){a=a|0;var b=0,c=0;c=f[a+20>>2]|0;if(d[a+28>>1]&4?(f[c+24>>2]|0)>>>0>=(f[a+24>>2]|0)>>>0:0){if(!(f[c+96>>2]|0)){c=0;return c|0}c=$Jc(a)|0;return c|0}b=f[c+40>>2]|0;if(b|0){c=b;return c|0}if((f[c+148>>2]|0)>>>0>(f[c+152>>2]|0)>>>0){c=aKc(a)|0;return c|0}else{c=bKc(a)|0;return c|0}return 0}function QJc(a,c){a=a|0;c=c|0;var e=0,g=0,i=0,j=0,k=0,l=0;j=f[a+56>>2]|0;k=f[a+52>>2]|0;i=h[a+9>>0]|0;if(!(d[k+24>>1]&12)){e=k+40|0;g=j+i|0}else{e=k+40|0;g=j+i|0;Mrd(g|0,0,(f[e>>2]|0)-i|0)|0}b[g>>0]=c;g=(c>>>1&4^12)+i|0;l=j+(i+1)|0;b[l>>0]=0;b[l+1>>0]=0;b[l+2>>0]=0;b[l+3>>0]=0;b[j+(i+7)>>0]=0;i=j+(i+5)|0;b[i>>0]=(f[e>>2]|0)>>>8;b[i+1>>0]=f[e>>2];f[a+20>>2]=(f[e>>2]|0)-g&65535;SJc(a,c)|0;d[a+18>>1]=g;f[a+60>>2]=j+(f[e>>2]|0);f[a+64>>2]=j+g;f[a+68>>2]=j+(h[a+10>>0]|0);b[a+12>>0]=0;d[a+26>>1]=(f[k+36>>2]|0)+65535;d[a+24>>1]=0;b[a>>0]=1;return}function RJc(a,c){a=a|0;c=c|0;b[a>>0]=c>>>24;b[a+1>>0]=c>>>16;b[a+2>>0]=c>>>8;b[a+3>>0]=c;return}function SJc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;e=c>>>3;g=e&255;b[a+8>>0]=g;b[a+10>>0]=4-(e<<2);e=a+76|0;f[e>>2]=675;h=f[a+52>>2]|0;switch(c&-9|0){case 5:{b[a+2>>0]=1;c=a+3|0;if(!(g<<24>>24)){b[c>>0]=0;f[e>>2]=676;c=187}else{b[c>>0]=1;c=186}f[a+80>>2]=c;d[a+14>>1]=d[h+30>>1]|0;c=h+32|0;break}case 2:{b[a+2>>0]=0;b[a+3>>0]=0;f[a+80>>2]=185;d[a+14>>1]=d[h+26>>1]|0;c=h+28|0;break}default:{h=YJc(66842)|0;return h|0}}d[a+16>>1]=d[c>>1]|0;b[a+11>>0]=b[h+21>>0]|0;h=0;return h|0}function TJc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0;g=c+(h[a+10>>0]|0)|0;i=b[g>>0]|0;e=i&255;if(i<<24>>24<0){d=0;e=e&127;do{d=d+1|0;i=b[g+d>>0]|0;e=e<<7|i&127}while(i<<24>>24<0&d>>>0<8);g=g+d|0;i=e}else i=e;if(!(b[a+2>>0]|0))d=g+1|0;else{d=1;do{e=d;d=d+1|0}while((b[g+e>>0]|0)<0&d>>>0<10);d=g+d|0}e=j[a+14>>1]|0;if(i>>>0>e>>>0){g=j[a+16>>1]|0;a=(((i-g|0)>>>0)%(((f[(f[a+52>>2]|0)+40>>2]|0)+-4|0)>>>0)|0)+g|0;c=(d-c&65535)+4+(a>>>0>e>>>0?g:a)|0;c=c&65535;return c|0}else{c=d-c+i|0;c=c>>>0>4?c:4;c=c&65535;return c|0}return 0}function UJc(a,c){a=a|0;c=c|0;var d=0;a=4;do{d=a;a=a+1|0}while((b[c+d>>0]|0)<0&a>>>0<13);return a&65535|0}function VJc(a,b,c){a=a|0;b=b|0;c=c|0;b=((_Jc(b+4|0,c)|0)&255)+4&65535;d[c+18>>1]=b;f[c+12>>2]=0;d[c+16>>1]=0;f[c+8>>2]=0;return}function WJc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,k=0,l=0,m=0,n=0;m=b[c>>0]|0;i=m&255;if(m<<24>>24<0){g=0;i=i&127;do{g=g+1|0;m=b[c+g>>0]|0;i=i<<7|m&127}while(m<<24>>24<0&g>>>0<8);m=c+g|0}else m=c;g=m+1|0;l=b[g>>0]|0;k=l&255;if(l<<24>>24<0){k=Hrd(k|0,0,7)|0;g=m+2|0;l=b[g>>0]|0;k=k&16256|l&127;if(l<<24>>24<=-1){k=Hrd(k|0,0,7)|0;l=G;g=m+3|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){k=Hrd(k|0,l|0,7)|0;l=G;g=m+4|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){k=Hrd(k|0,l|0,7)|0;l=G;g=m+5|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){k=Hrd(k|0,l|0,7)|0;l=G;g=m+6|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){k=Hrd(k|0,l|0,7)|0;l=G;g=m+7|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){k=Hrd(k|0,l|0,7)|0;l=G;g=m+8|0;n=b[g>>0]|0;k=k|n&127;if(n<<24>>24<=-1){l=Hrd(k|0,l|0,8)|0;k=m+9|0;g=k;k=l|(h[k>>0]|0);l=G}}}}}}}else l=0}else l=0;g=g+1|0;n=e;f[n>>2]=k;f[n+4>>2]=l;f[e+12>>2]=i;f[e+8>>2]=g;if(i>>>0>(j[a+14>>1]|0)>>>0){ZJc(a,c,e);return}else{n=g-c+i|0;d[e+18>>1]=(n&65532|0)==0?4:n&65535;d[e+16>>1]=i;return}}function XJc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,k=0,l=0;k=c+(h[a+10>>0]|0)|0;g=b[k>>0]|0;i=g&255;if(g<<24>>24<0){g=0;i=i&127;do{g=g+1|0;l=b[k+g>>0]|0;i=i<<7|l&127}while(l<<24>>24<0&g>>>0<8);g=k+g|0}else g=k;g=g+1|0;l=e;f[l>>2]=i;f[l+4>>2]=0;f[e+12>>2]=i;f[e+8>>2]=g;if(i>>>0>(j[a+14>>1]|0)>>>0){ZJc(a,c,e);return}else{l=g-c+i|0;d[e+18>>1]=(l&65532|0)==0?4:l&65535;d[e+16>>1]=i;return}}function YJc(a){a=a|0;cxc(11,a,120992)|0;return 11}function ZJc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0;h=d[a+16>>1]|0;g=h&65535;e=((((f[c+12>>2]|0)-g|0)>>>0)%(((f[(f[a+52>>2]|0)+40>>2]|0)+-4|0)>>>0)|0)+g|0;a=(e|0)>(j[a+14>>1]|0|0);d[c+16>>1]=a?h:e&65535;d[c+18>>1]=4-b+((f[c+8>>2]|0)+(a?g:e&65535));return}function _Jc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0;d=b[a>>0]|0;do if(d<<24>>24<=-1){e=b[a+1>>0]|0;g=d&255;if(e<<24>>24>-1){l=2;j=0;d=g<<7&16256|e&255;break}d=e&255;l=h[a+2>>0]|0;e=(g<<14|l)&2080895;if(!(l&128)){l=3;j=0;d=e|d<<7&16256;break}l=h[a+3>>0]|0;d=(d<<14|l)&2080895;if(!(l&128)){l=4;j=0;d=d|e<<7;break}k=b[a+4>>0]|0;l=k&255;g=e<<14|l;if(!(l&128)){l=5;j=e>>>18;d=g|d<<7;break}j=d|e<<7;l=h[a+5>>0]|0;i=d<<14|l;if(!(l&128)){l=6;j=j>>>18;d=i|g<<7&266354560;break}l=h[a+6>>0]|0;d=g<<14|l;if(!(l&128)){l=7;j=j>>>11;d=d&-266354561|i<<7&266354560;break}e=d&2080895;l=h[a+7>>0]|0;d=i<<14|l;if(!(l&128)){l=8;j=j>>>4;d=d&-266354561|e<<7;break}else{l=9;j=(k&120)>>>3|j<<4;d=d<<8&532709120|e<<15|(h[a+8>>0]|0);break}}else{l=1;j=0;d=d&255}while(0);f[c>>2]=d;f[c+4>>2]=j;return l|0}function $Jc(a){a=a|0;if(!(PKc(a)|0)){a=0;return a|0}a=QKc(a)|0;return a|0}function aKc(a){a=a|0;var c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=t;t=t+16|0;k=p;n=f[a+20>>2]|0;l=n+152|0;h=((f[n+148>>2]|0)>>>0)/((f[l>>2]|0)>>>0)|0;o=n+20|0;b[o>>0]=b[o>>0]|4;j=a+24|0;c=f[j>>2]|0;g=c+-1|0;a=0-h|0;e=g&a;m=e+1|0;a=~(g&a);g=f[n+24>>2]|0;if(c>>>0>g>>>0)i=c+1+a|0;else i=(e+h|0)>>>0>g>>>0?g+1+a|0:h;h=n+56|0;e=0;g=0;c=0;while(1){a=(e|0)==0;if(!((g|0)<(i|0)&a))break;a=g+m|0;if((a|0)!=(f[j>>2]|0)?(FKc(f[h>>2]|0,a)|0)!=0:0){a=IKc(n,a)|0;f[k>>2]=a;if(!a)a=0;else{c=(d[a+28>>1]&8)==0?c:1;HKc(a);a=0}}else if((a|0)!=(((f[19118]|0)/(f[l>>2]|0)|0)+1|0)){a=GKc(n,a,k,0)|0;if(!a){a=bKc(f[k>>2]|0)|0;e=f[k>>2]|0;c=(d[e+28>>1]&8)==0?c:1;HKc(e)}}else a=0;e=a;g=g+1|0}if(!((c|0)!=0&a)){n=b[o>>0]|0;n=n&-5;b[o>>0]=n;t=p;return e|0}a=0;while(1){if((a|0)>=(i|0))break;c=IKc(n,a+m|0)|0;if(c|0){l=c+28|0;d[l>>1]=d[l>>1]|8;HKc(c)}a=a+1|0}n=b[o>>0]|0;n=n&-5;b[o>>0]=n;t=p;return e|0}function bKc(a){a=a|0;var c=0,e=0,g=0,h=0;h=f[a+20>>2]|0;g=h+16|0;if((b[g>>0]|0)==2?(c=cKc(h)|0,c|0):0){a=c;return a|0}dKc(a);c=f[h+56>>2]|0;do if(c|0?(e=f[a+24>>2]|0,(eKc(c,e)|0)==0):0)if(e>>>0>(f[h+28>>2]|0)>>>0){if((b[g>>0]|0)==4)break;g=a+28|0;d[g>>1]=d[g>>1]|8;break}else{c=fKc(a)|0;if(!c)break;return c|0}while(0);g=a+28|0;d[g>>1]=d[g>>1]|4;if((f[h+96>>2]|0)>0)g=$Jc(a)|0;else g=0;e=h+24|0;c=f[a+24>>2]|0;if((f[e>>2]|0)>>>0>=c>>>0){a=g;return a|0}f[e>>2]=c;a=g;return a|0}function cKc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;h=f[a>>2]|0;c=f[a+40>>2]|0;if(c|0){j=c;return j|0}do if((f[a+216>>2]|0)==0?(d=a+5|0,(b[d>>0]|0)!=2):0){g=lKc(f[a+24>>2]|0)|0;i=a+56|0;f[i>>2]=g;if(!g){j=7;return j|0}g=a+64|0;c=f[g>>2]|0;do if(!(f[c>>2]|0)){if((b[d>>0]|0)==4){nKc(c);j=10;break}d=(b[a+12>>0]|0)==0;e=f[10185]|0;c=oKc(a)|0;if(!c){c=pKc(h,f[a+172>>2]|0,f[g>>2]|0,d?2054:4110,d?0:e)|0;if(!c)j=10}}else j=10;while(0);if((j|0)==10){f[a+44>>2]=0;c=a+72|0;b[a+19>>0]=0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;f[c+12>>2]=0;c=qKc(a)|0;if(!c)break}rKc(f[i>>2]|0);f[i>>2]=0;j=c;return j|0}while(0);b[a+16>>0]=3;j=0;return j|0}function dKc(a){a=a|0;var b=0,c=0,e=0;b=a+28|0;c=j[b>>1]|0;if(!(c&17))return;e=c&65519;d[b>>1]=e;if(!(c&1))return;d[b>>1]=e^3;mKc(a,2);return}function eKc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,i=0;b=b+-1|0;if(b>>>0>=(f[a>>2]|0)>>>0){i=0;return i|0}i=a;while(1){c=f[i+8>>2]|0;if(!c)break;d=(b>>>0)/(c>>>0)|0;a=f[i+12+(d<<2)>>2]|0;if(!a){e=0;g=11;break}b=b-(V(d,c)|0)|0;i=a}if((g|0)==11)return e|0;if((f[i>>2]|0)>>>0<4001){i=(1<<(b&7)&(h[i+12+(b>>>3)>>0]|0)|0)!=0&1;return i|0}c=b+1|0;while(1){b=(b>>>0)%125|0;a=f[i+12+(b<<2)>>2]|0;if(!a){e=0;g=11;break}if((a|0)==(c|0)){e=1;g=11;break}else b=b+1|0}if((g|0)==11)return e|0;return 0}function fKc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=f[a+20>>2]|0;l=k+72|0;c=l;b=f[c>>2]|0;c=f[c+4>>2]|0;e=f[a+4>>2]|0;h=gKc(k,e)|0;i=a+28|0;d[i>>1]=d[i>>1]|8;i=k+64|0;j=a+24|0;a=hKc(f[i>>2]|0,b,c,f[j>>2]|0)|0;if(a|0){l=a;return l|0}m=f[i>>2]|0;g=k+152|0;a=f[g>>2]|0;b=vrd(b|0,c|0,4,0)|0;c=G;a=iKc(m,e,a,b,c)|0;if(a|0){m=a;return m|0}m=f[i>>2]|0;a=f[g>>2]|0;a=vrd(b|0,c|0,a|0,((a|0)<0)<<31>>31|0)|0;a=hKc(m,a,G,h)|0;if(a|0){m=a;return m|0}i=(f[g>>2]|0)+8|0;m=l;i=vrd(f[m>>2]|0,f[m+4>>2]|0,i|0,((i|0)<0)<<31>>31|0)|0;m=l;f[m>>2]=i;f[m+4>>2]=G;m=k+44|0;f[m>>2]=(f[m>>2]|0)+1;m=jKc(f[k+56>>2]|0,f[j>>2]|0)|0;m=kKc(k,f[j>>2]|0)|0|m;return m|0}function gKc(a,b){a=a|0;b=b|0;var c=0,d=0;d=f[a+152>>2]|0;c=f[a+48>>2]|0;while(1){a=d+-200|0;if((d|0)<=200)break;d=a;c=c+(h[b+a>>0]|0)|0}return c|0}function hKc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=t;t=t+16|0;f=e;RJc(f,d);d=iKc(a,f,4,b,c)|0;t=e;return d|0}function iKc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return zd[f[(f[a>>2]|0)+12>>2]&127](a,b,c,d,e)|0}function jKc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if(!a){o=0;return o|0}o=a;g=c+-1|0;while(1){if((f[o>>2]|0)>>>0<=4e3){e=8;break}c=f[o+8>>2]|0;if(!c){e=9;break}d=(g>>>0)/(c>>>0)|0;e=g-(V(d,c)|0)|0;d=o+12+(d<<2)|0;a=f[d>>2]|0;if(!a){a=lKc(c)|0;f[d>>2]=a;if(!a){k=7;e=24;break}}o=a;g=e}if((e|0)==8){o=o+12+(g>>>3)|0;b[o>>0]=1<<(g&7)|(h[o>>0]|0);o=0;return o|0}else if((e|0)==9){i=o+8|0;j=g+1|0;c=(g>>>0)%125|0;g=o+12|0;d=o+12+(c<<2)|0;a=f[d>>2]|0;if(!a){a=o+4|0;c=f[a>>2]|0;if(c>>>0<124){l=d;m=a;n=c;e=23}}else{d=c;do{if((a|0)==(j|0)){k=0;e=24;break}a=d+1|0;d=a>>>0>124?0:a;a=f[o+12+(d<<2)>>2]|0}while((a|0)!=0);if((e|0)==24)return k|0;a=o+4|0;c=f[a>>2]|0;if(c>>>0<=61){l=o+12+(d<<2)|0;m=a;n=c;e=23}}if((e|0)==23){f[m>>2]=n+1;f[l>>2]=j;o=0;return o|0}e=jxc(0,500,0)|0;if(!e){o=7;return o|0}Krd(e|0,g|0,500)|0;Mrd(g|0,0,500)|0;f[i>>2]=(((f[o>>2]|0)+124|0)>>>0)/125|0;a=jKc(o,j)|0;d=0;while(1){if((d|0)==125)break;c=f[e+(d<<2)>>2]|0;if(c)a=jKc(o,c)|0|a;d=d+1|0}nxc(0,e);o=a;return o|0}else if((e|0)==24)return k|0;return 0}function kKc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=a+96|0;e=a+92|0;d=0;a=0;while(1){if((d|0)>=(f[g>>2]|0))break;c=f[e>>2]|0;if((f[c+(d*48|0)+20>>2]|0)>>>0>=b>>>0)a=jKc(f[c+(d*48|0)+16>>2]|0,b)|0|a;d=d+1|0}return a|0}function lKc(a){a=a|0;var b=0;b=DCc(512,0)|0;if(!b)return b|0;f[b>>2]=a;return b|0}function mKc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0;j=f[a+12>>2]|0;i=c&255;do if(i&1|0){e=j+8|0;g=a+36|0;c=f[g>>2]|0;if((f[e>>2]|0)==(a|0))f[e>>2]=c;e=f[a+32>>2]|0;h=(e|0)==0;if(h)f[j+4>>2]=c;else{f[e+36>>2]=c;c=f[g>>2]|0}if(c|0){f[c+32>>2]=e;break}f[j>>2]=e;if(h)b[j+33>>0]=2}while(0);if(!(i&2))return;f[a+36>>2]=0;c=f[j>>2]|0;f[a+32>>2]=c;if(!c){f[j+4>>2]=a;if(b[j+32>>0]|0)b[j+33>>0]=1}else f[c+36>>2]=a;f[j>>2]=a;c=j+8|0;if(f[c>>2]|0)return;if(d[a+28>>1]&8)return;f[c>>2]=a;return}function nKc(a){a=a|0;pKc(0,0,a,0,-1)|0;return}function oKc(a){a=a|0;var c=0,d=0,e=0;e=t;t=t+16|0;c=e;f[c>>2]=0;if(((b[a+12>>0]|0)==0?(f[a+24>>2]|0)!=0:0)?(d=EKc(f[a+60>>2]|0,20,c)|0,(d|0)!=12):0)a=(d|0)==0&(f[c>>2]|0)!=0?1032:d;else a=0;t=e;return a|0}function pKc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=c;h=g+64|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(h|0));if(!e){h=uKc(a,b,c,d,0)|0;return h|0}else{f[c+4>>2]=(e|0)>0?e:1020;f[c>>2]=77612;f[c+8>>2]=e;f[c+48>>2]=d;f[c+56>>2]=b;f[c+52>>2]=a;h=0;return h|0}return 0}function qKc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=f[a+208>>2]|0;k=a+152|0;g=f[k>>2]|0;n=a+148|0;h=f[n>>2]|0;i=g>>>0>h>>>0;j=f[a+96>>2]|0;d=a+92|0;l=a+72|0;c=0;while(1){if((c|0)>=(j|0))break;e=(f[d>>2]|0)+(c*48|0)+8|0;o=e;if((f[o>>2]|0)==0&(f[o+4>>2]|0)==0){q=l;p=f[q+4>>2]|0;o=e;f[o>>2]=f[q>>2];f[o+4>>2]=p}c=c+1|0}g=i?h:g;o=sKc(a)|0;p=G;q=l;f[q>>2]=o;f[q+4>>2]=p;q=a+80|0;f[q>>2]=o;f[q+4>>2]=p;if(((b[a+7>>0]|0)==0?(b[a+5>>0]|0)!=4:0)?((tKc(f[a+60>>2]|0)|0)&512|0)==0:0){c=m;d=c+12|0;do{b[c>>0]=0;c=c+1|0}while((c|0)<(d|0))}else{q=m;p=q;b[p>>0]=-117058087;b[p+1>>0]=-117058087>>8;b[p+2>>0]=-117058087>>16;b[p+3>>0]=-117058087>>24;q=q+4|0;b[q>>0]=-681336544;b[q+1>>0]=-681336544>>8;b[q+2>>0]=-681336544>>16;b[q+3>>0]=-681336544>>24;RJc(m+8|0,-1)}e=a+48|0;$Ac(4,e);RJc(m+12|0,f[e>>2]|0);RJc(m+16|0,f[a+28>>2]|0);RJc(m+20|0,f[n>>2]|0);RJc(m+24|0,f[k>>2]|0);Mrd(m+28|0,0,g+-28|0)|0;e=a+64|0;d=0;c=0;while(1){if(c|0){d=15;break}if(d>>>0>=(f[n>>2]|0)>>>0){c=0;d=15;break}c=l;c=iKc(f[e>>2]|0,m,g,f[c>>2]|0,f[c+4>>2]|0)|0;p=l;p=vrd(f[p>>2]|0,f[p+4>>2]|0,g|0,0)|0;q=l;f[q>>2]=p;f[q+4>>2]=G;d=d+g|0}if((d|0)==15)return c|0;return 0}function rKc(a){a=a|0;var b=0,c=0;if(!a)return;a:do if(f[a+8>>2]|0){c=a+12|0;b=0;while(1){if((b|0)==125)break a;rKc(f[c+(b<<2)>>2]|0);b=b+1|0}}while(0);qxc(a);return}function sKc(a){a=a|0;var b=0,c=0;c=a+72|0;b=f[c>>2]|0;c=f[c+4>>2]|0;if((b|0)==0&(c|0)==0){b=0;c=0;G=b;return c|0}b=vrd(b|0,c|0,-1,-1)|0;c=f[a+148>>2]|0;b=zrd(b|0,G|0,c|0,0)|0;b=vrd(b|0,G|0,1,0)|0;c=Brd(b|0,G|0,c|0,0)|0;b=G;G=b;return c|0}function tKc(a){a=a|0;return sd[f[(f[a>>2]|0)+48>>2]&2047](a)|0}function uKc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return zd[f[a+24>>2]&127](a,b,c,d&17334143,e)|0}function vKc(a){a=a|0;BKc(f[a+12>>2]|0);return 0}function wKc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=vrd(c|0,((c|0)<0)<<31>>31|0,d|0,e|0)|0;n=G;l=a+16|0;k=f[l+4>>2]|0;if((n|0)>(k|0)|((n|0)==(k|0)?m>>>0>(f[l>>2]|0)>>>0:0)){n=522;return n|0}l=a+32|0;k=l;a:do if((d|0)==0&(e|0)==0|((f[k>>2]|0)!=(d|0)?1:(f[k+4>>2]|0)!=(e|0))){j=a+4|0;g=a+12|0;i=0;h=0;while(1){g=f[g>>2]|0;if(!g){g=0;k=j;break a}k=f[j>>2]|0;i=vrd(i|0,h|0,k|0,((k|0)<0)<<31>>31|0)|0;h=G;if((h|0)>(e|0)|(h|0)==(e|0)&i>>>0>d>>>0){k=j;break a}}}else{g=f[a+40>>2]|0;k=a+4|0}while(0);h=f[k>>2]|0;j=Crd(d|0,e|0,h|0,((h|0)<0)<<31>>31|0)|0;while(1){h=h-j|0;i=(c|0)<(h|0)?c:h;Krd(b|0,g+4+j|0,i|0)|0;h=c-h|0;if((h|0)<=-1)break;g=f[g>>2]|0;if(!((h|0)!=0&(g|0)!=0))break;b=b+i|0;j=0;c=h;h=f[k>>2]|0}k=(g|0)==0;f[l>>2]=k?0:m;f[l+4>>2]=k?0:n;f[a+40>>2]=g;n=0;return n|0}function xKc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;g=f[a+8>>2]|0;if((g|0)>0?(k=vrd(c|0,((c|0)<0)<<31>>31|0,d|0,e|0)|0,i=G,j=((g|0)<0)<<31>>31,(i|0)>(j|0)|(i|0)==(j|0)&k>>>0>g>>>0):0){g=CKc(a)|0;if(g|0){k=g;return k|0}k=iKc(a,b,c,d,e)|0;return k|0}i=a+16|0;j=a+24|0;k=a+4|0;h=a+12|0;a=b;while(1){if((c|0)<=0){g=0;d=11;break}g=f[j>>2]|0;b=i;d=f[k>>2]|0;b=Crd(f[b>>2]|0,f[b+4>>2]|0,d|0,((d|0)<0)<<31>>31|0)|0;e=d-b|0;e=(c|0)<(e|0)?c:e;if(!b){d=Vzc(d+4|0)|0;if(!d){g=3082;d=11;break}f[d>>2]=0;f[((g|0)==0?h:g)>>2]=d;f[j>>2]=d;g=d}Krd(g+4+b|0,a|0,e|0)|0;d=i;d=vrd(f[d>>2]|0,f[d+4>>2]|0,e|0,((e|0)<0)<<31>>31|0)|0;b=i;f[b>>2]=d;f[b+4>>2]=G;c=c-e|0;a=a+e|0}if((d|0)==11)return g|0;return 0}function yKc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;if(!((b|0)==0&(c|0)==0)){j=f[a+4>>2]|0;g=((j|0)<0)<<31>>31;d=a+12|0;h=g;i=j;while(1){e=f[d>>2]|0;d=(e|0)!=0;if((h|0)>(c|0)|(h|0)==(c|0)&i>>>0>b>>>0|d^1)break;l=vrd(i|0,h|0,j|0,g|0)|0;d=e;h=G;i=l}if(d){BKc(f[e>>2]|0);d=e;k=8}else d=0}else{e=a+12|0;BKc(f[e>>2]|0);d=0;k=8}if((k|0)==8)f[e>>2]=0;f[a+24>>2]=d;l=a+16|0;f[l>>2]=b;f[l+4>>2]=c;f[a+40>>2]=0;l=a+32|0;f[l>>2]=0;f[l+4>>2]=0;return 0}function zKc(a,b){a=a|0;b=b|0;return 0}function AKc(a,b){a=a|0;b=b|0;var c=0;c=a+16|0;a=f[c+4>>2]|0;f[b>>2]=f[c>>2];f[b+4>>2]=a;return 0}function BKc(a){a=a|0;var b=0;while(1){if(!a)break;b=f[a>>2]|0;qxc(a);a=b}return}function CKc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;C=t;t=t+32|0;w=C;h=f[a>>2]|0;o=a+4|0;p=f[o>>2]|0;q=a+8|0;r=f[q>>2]|0;s=a+12|0;u=f[s>>2]|0;v=a+16|0;B=v;A=f[B>>2]|0;B=f[B+4>>2]|0;x=a+24|0;f[w>>2]=f[x>>2];f[w+4>>2]=f[x+4>>2];f[w+8>>2]=f[x+8>>2];f[w+12>>2]=f[x+12>>2];f[w+16>>2]=f[x+16>>2];f[w+20>>2]=f[x+20>>2];y=a+48|0;z=f[y>>2]|0;i=a+52|0;j=f[i>>2]|0;k=a+56|0;l=f[k>>2]|0;m=a+60|0;n=f[m>>2]|0;b=a;c=b+64|0;do{f[b>>2]=0;b=b+4|0}while((b|0)<(c|0));b=uKc(j,l,a,z,0)|0;a:do if(!b){d=u;b=p;e=0;g=0;while(1){if(!d)break;D=vrd(e|0,g|0,b|0,((b|0)<0)<<31>>31|0)|0;E=G;c=wrd(A|0,B|0,e|0,g|0)|0;c=(E|0)>(B|0)|(E|0)==(B|0)&D>>>0>A>>>0?c:b;b=iKc(a,d+4|0,c,e,g)|0;if(b|0)break a;E=vrd(e|0,g|0,c|0,((c|0)<0)<<31>>31|0)|0;d=f[d>>2]|0;b=c;e=E;g=G}BKc(u);E=0;t=C;return E|0}while(0);DKc(a);f[a>>2]=h;f[o>>2]=p;f[q>>2]=r;f[s>>2]=u;E=v;f[E>>2]=A;f[E+4>>2]=B;f[x>>2]=f[w>>2];f[x+4>>2]=f[w+4>>2];f[x+8>>2]=f[w+8>>2];f[x+12>>2]=f[w+12>>2];f[x+16>>2]=f[w+16>>2];f[x+20>>2]=f[w+20>>2];f[y>>2]=z;f[i>>2]=j;f[k>>2]=l;f[m>>2]=n;E=b;t=C;return E|0}function DKc(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;sd[f[b+4>>2]&2047](a)|0;f[a>>2]=0;return}function EKc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a>>2]|0;if(!d){d=12;return d|0}d=vd[f[d+40>>2]&255](a,b,c)|0;return d|0}function FKc(a,b){a=a|0;b=b|0;if(!a){b=0;return b|0}b=(eKc(a,b)|0)!=0&1;return b|0}function GKc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return xd[f[a+204>>2]&63](a,b,c,d)|0}function HKc(a){a=a|0;if(!(d[a+28>>1]&32)){NKc(a);return}else{MKc(a);return}}function IKc(a,b){a=a|0;b=b|0;var c=0;a=a+212|0;c=JKc(f[a>>2]|0,b,0)|0;if(!c){b=0;return b|0}b=KKc(f[a>>2]|0,b,c)|0;return b|0}function JKc(a,b,c){a=a|0;b=b|0;c=c|0;return vd[f[40840>>2]&255](f[a+44>>2]|0,b,(h[a+33>>0]|0)&c)|0}function KKc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0;e=f[c+4>>2]|0;if(!(f[e>>2]|0)){e=LKc(a,b,c)|0;return e|0}else{c=a+12|0;f[c>>2]=(f[c>>2]|0)+1;c=e+30|0;d[c>>1]=(d[c>>1]|0)+1<<16>>16;return e|0}return 0}function LKc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0;g=f[e+4>>2]|0;h=g+16|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;f[h+12>>2]=0;f[h+16>>2]=0;f[h+20>>2]=0;f[g>>2]=e;f[g+4>>2]=f[e>>2];h=g+40|0;f[g+8>>2]=h;i=h;b[i>>0]=0;b[i+1>>0]=0;b[i+2>>0]=0;b[i+3>>0]=0;h=h+4|0;b[h>>0]=0;b[h+1>>0]=0;b[h+2>>0]=0;b[h+3>>0]=0;f[g+12>>2]=a;f[g+24>>2]=c;d[g+28>>1]=1;return KKc(a,c,e)|0}function MKc(a){a=a|0;var b=0,c=0;b=f[a+20>>2]|0;c=b+120|0;f[c>>2]=(f[c>>2]|0)+-1;b=b+136|0;f[a+16>>2]=f[b>>2];f[b>>2]=a;return}function NKc(a){a=a|0;var b=0,c=0;c=(f[a+12>>2]|0)+12|0;f[c>>2]=(f[c>>2]|0)+-1;c=a+30|0;b=(d[c>>1]|0)+-1<<16>>16;d[c>>1]=b;if(b<<16>>16)return;if(!(d[a+28>>1]&1)){mKc(a,3);return}else{OKc(a);return}}function OKc(a){a=a|0;var c=0;c=f[a+12>>2]|0;if(!(b[c+32>>0]|0))return;Kd[f[40844>>2]&255](f[c+44>>2]|0,f[a>>2]|0,0);return}function PKc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;c=f[a+20>>2]|0;b=f[a+24>>2]|0;d=f[c+96>>2]|0;c=c+92|0;a=0;while(1){if((a|0)>=(d|0)){a=0;g=9;break}e=f[c>>2]|0;if((f[e+(a*48|0)+20>>2]|0)>>>0>=b>>>0?(eKc(f[e+(a*48|0)+16>>2]|0,b)|0)==0:0)break;a=a+1|0}if((g|0)==9)return a|0;while(1){a=a+1|0;if((a|0)>=(d|0)){a=1;break}f[e+(a*48|0)+28>>2]=0}return a|0}function QKc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=f[a+20>>2]|0;if((b[k+5>>0]|0)!=2){c=RKc(k)|0;if(c|0){k=c;return k|0}j=f[a+4>>2]|0;c=k+52|0;e=k+152|0;g=(f[e>>2]|0)+4|0;g=Brd(g|0,((g|0)<0)<<31>>31|0,f[c>>2]|0,0)|0;h=G;i=k+68|0;a=a+24|0;d=hKc(f[i>>2]|0,g,h,f[a>>2]|0)|0;if(d|0){k=d;return k|0}d=vrd(g|0,h|0,4,0)|0;d=iKc(f[i>>2]|0,j,f[e>>2]|0,d,G)|0;if(d){k=d;return k|0}}else{a=a+24|0;c=k+52|0}f[c>>2]=(f[c>>2]|0)+1;k=kKc(k,f[a>>2]|0)|0;return k|0}function RKc(a){a=a|0;var c=0,d=0;d=f[a+68>>2]|0;if(f[d>>2]|0){d=0;return d|0}if((b[a+5>>0]|0)!=4?(b[a+21>>0]|0)==0:0)c=f[10185]|0;else c=-1;d=pKc(f[a>>2]|0,0,d,8222,c)|0;return d|0}function SKc(a){a=a|0;return (f[a>>2]|0)==77612|0}function TKc(a,b,c){a=a|0;b=b|0;c=c|0;return vd[f[(f[a>>2]|0)+16>>2]&255](a,b,c)|0}function UKc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;r=t;t=t+16|0;p=r;l=r+8|0;m=(c|0)!=0;e=c+20|0;if(m){d=lKc(f[e>>2]|0)|0;if(!d){q=7;t=r;return q|0}else q=d}else q=0;f[a+24>>2]=f[(m?e:a+28|0)>>2];b[a+18>>0]=b[a+12>>0]|0;a:do if(m){e=a+72|0;g=e;j=f[g>>2]|0;g=f[g+4>>2]|0;if(!(f[a+216>>2]|0)){i=c+8|0;h=f[i>>2]|0;i=f[i+4>>2]|0;n=(h|0)==0&(i|0)==0;h=n?j:h;i=n?g:i;n=c;o=f[n+4>>2]|0;d=e;f[d>>2]=f[n>>2];f[d+4>>2]=o;d=0;while(1){if(d|0){o=e;n=g;break a}o=e;n=f[o+4>>2]|0;if(!((n|0)<(i|0)|((n|0)==(i|0)?(f[o>>2]|0)>>>0<h>>>0:0))){d=0;o=e;n=g;break a}d=JLc(a,e,q,1,1)|0}}else{h=j;k=12}}else{if(!(f[a+216>>2]|0)){e=a+72|0;g=e;h=f[g>>2]|0;g=f[g+4>>2]|0;k=12;break}q=oMc(a)|0;t=r;return q|0}while(0);if((k|0)==12){d=e;f[d>>2]=0;f[d+4>>2]=0;d=0;o=e;n=g;j=h}h=a+80|0;i=a+148|0;k=a+152|0;while(1){if(d|0)break;g=o;e=f[g+4>>2]|0;if(!((e|0)<(n|0)|((e|0)==(n|0)?(f[g>>2]|0)>>>0<j>>>0:0))){d=0;break}f[p>>2]=0;d=ILc(a,0,j,n,p,l)|0;e=f[p>>2]|0;if(!e){e=h;e=vrd(f[e>>2]|0,f[e+4>>2]|0,f[i>>2]|0,0)|0;g=G;s=o;if((e|0)==(f[s>>2]|0)?(g|0)==(f[s+4>>2]|0):0){s=wrd(j|0,n|0,e|0,g|0)|0;e=(f[k>>2]|0)+8|0;e=zrd(s|0,G|0,e|0,((e|0)<0)<<31>>31|0)|0;f[p>>2]=e}else e=0}g=0;while(1){if(!((d|0)==0&g>>>0<e>>>0))break;s=o;d=f[s+4>>2]|0;if(!((d|0)<(n|0)|((d|0)==(n|0)?(f[s>>2]|0)>>>0<j>>>0:0))){d=0;break}g=g+1|0;d=JLc(a,o,q,1,1)|0}}if(m){h=c+24|0;e=f[h>>2]|0;s=(f[k>>2]|0)+4|0;s=Brd(s|0,((s|0)<0)<<31>>31|0,e|0,0)|0;g=p;f[g>>2]=s;f[g+4>>2]=G;g=f[a+216>>2]|0;if(g){pMc(g,c+32|0);d=0;e=f[h>>2]|0}g=a+52|0;while(1){if(d|0)break;if(e>>>0>=(f[g>>2]|0)>>>0){d=0;break}e=e+1|0;d=JLc(a,p,q,0,1)|0}}rKc(q);if(d|0){s=d;t=r;return s|0}s=o;f[s>>2]=j;f[s+4>>2]=n;s=0;t=r;return s|0}function VKc(a){a=a|0;f[a+204>>2]=(f[a+40>>2]|0)==0?56:55;return}function WKc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;g=k;if(!b){c=YJc(57628)|0;t=k;return c|0}h=a+212|0;e=JKc(f[h>>2]|0,b,3)|0;f[g>>2]=e;if(!e){e=YKc(f[h>>2]|0,b,g)|0;if(!e){e=f[g>>2]|0;if(!e)e=7;else i=6}}else i=6;a:do if((i|0)==6){j=KKc(f[h>>2]|0,b,e)|0;f[c>>2]=j;g=d&1;h=j+20|0;d=(g|0)!=0;if(!(d|(f[h>>2]|0)==0)){c=a+184|0;f[c>>2]=(f[c>>2]|0)+1;c=0;t=k;return c|0}i=a+152|0;e=f[i>>2]|0;do if((((f[19118]|0)/(e|0)|0)+1|0)==(b|0)){e=YJc(57660)|0;if(!j)break a}else{f[h>>2]=a;if(f[f[a+60>>2]>>2]|0?((g|0)==0?(f[a+24>>2]|0)>>>0>=b>>>0:0):0){e=a+188|0;f[e>>2]=(f[e>>2]|0)+1;e=ZKc(j)|0;if(!e)e=0;else break;t=k;return e|0}if((f[a+156>>2]|0)>>>0<b>>>0)e=13;else{if(d){tzc();if((f[a+28>>2]|0)>>>0>=b>>>0)jKc(f[a+56>>2]|0,b)|0;kKc(a,b)|0;uzc();e=f[i>>2]|0}Mrd(f[j+4>>2]|0,0,e|0)|0;c=0;t=k;return c|0}}while(0);_Kc(j)}while(0);$Kc(a);f[c>>2]=0;c=e;t=k;return c|0}function XKc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;f[c>>2]=0;return f[a+40>>2]|0}function YKc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0;if((b[a+33>>0]|0)==2){e=0;return e|0}i=Dzc(a)|0;a:do if((i|0)>(f[a+20>>2]|0)){h=a+8|0;g=h;while(1){g=f[g>>2]|0;if(!g){i=9;break}if((d[g+30>>1]|0)==0?(d[g+28>>1]&8)==0:0){i=8;break}g=g+36|0}b:do if((i|0)==8)f[h>>2]=g;else if((i|0)==9){f[h>>2]=0;g=a+4|0;while(1){g=f[g>>2]|0;if(!g)break a;if(!(d[g+30>>1]|0))break b;g=g+36|0}}while(0);g=td[f[a+36>>2]&1023](f[a+40>>2]|0,g)|0;switch(g|0){case 0:case 5:break a;default:{}}return g|0}while(0);c=vd[f[40840>>2]&255](f[a+44>>2]|0,c,2)|0;f[e>>2]=c;e=(c|0)==0?7:0;return e|0}function ZKc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;d=j;h=f[a+20>>2]|0;f[d>>2]=0;e=h+216|0;c=f[e>>2]|0;g=a+24|0;if(c){c=eMc(c,f[g>>2]|0,d)|0;if(c|0){a=c;t=j;return a|0}c=f[d>>2]|0;if(c)c=fMc(f[e>>2]|0,c,f[h+152>>2]|0,f[a+4>>2]|0)|0;else i=5}else i=5;if((i|0)==5){i=f[h+152>>2]|0;c=Brd((f[g>>2]|0)+-1|0,0,i|0,((i|0)<0)<<31>>31|0)|0;c=QLc(f[h+60>>2]|0,f[a+4>>2]|0,i,c,G)|0;c=(c|0)==522?0:c}if((f[g>>2]|0)!=1){a=c;t=j;return a|0}if(!c){e=h+104|0;c=(f[a+4>>2]|0)+24|0;d=e+16|0;do{b[e>>0]=b[c>>0]|0;e=e+1|0;c=c+1|0}while((e|0)<(d|0));a=0;t=j;return a|0}else{a=h+104|0;f[a>>2]=-1;f[a+4>>2]=-1;f[a+8>>2]=-1;f[a+12>>2]=-1;a=c;t=j;return a|0}return 0}function _Kc(a){a=a|0;var b=0,c=0;if(d[a+28>>1]&2)mKc(a,1);b=f[a+12>>2]|0;c=b+12|0;f[c>>2]=(f[c>>2]|0)+-1;Kd[f[40844>>2]&255](f[b+44>>2]|0,f[a>>2]|0,1);return}function $Kc(a){a=a|0;if(aLc(f[a+212>>2]|0)|0)return;bLc(a);return}function aLc(a){a=a|0;return f[a+12>>2]|0}function bLc(a){a=a|0;switch(b[a+16>>0]|0){case 0:case 6:break;case 1:{if(!(b[a+4>>0]|0))dLc(a,0,0)|0;break}default:{tzc();cLc(a)|0;uzc()}}eLc(a);return}function cLc(a){a=a|0;var c=0,d=0,e=0;d=a+16|0;e=b[d>>0]|0;if(e<<24>>24==6){a=f[a+40>>2]|0;return a|0}if((e&255)<2){a=0;return a|0}do if(!(f[a+216>>2]|0)){if(!(e<<24>>24==2?1:(f[f[a+64>>2]>>2]|0)==0)){c=ELc(a,0)|0;break}c=dLc(a,0,0)|0;if((e&255)>2&(b[a+15>>0]|0)==0){f[a+40>>2]=4;b[d>>0]=6;VKc(a);a=c;return a|0}}else{c=KJc(a,2,-1)|0;e=dLc(a,h[a+19>>0]|0,0)|0;c=(c|0)==0?e:c}while(0);a=FLc(a,c)|0;return a|0}function dLc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0;j=a+16|0;if((h[j>>0]|0)<2?(h[a+17>>0]|0)<2:0){j=0;return j|0}fLc(a);i=a+64|0;g=f[i>>2]|0;a:do if(!(f[g>>2]|0))c=0;else{if(SKc(g)|0){DKc(g);c=0;break}e=b[a+5>>0]|0;switch(e<<24>>24){case 3:{e=a+72|0;c=e;if(!((f[c>>2]|0)==0&(f[c+4>>2]|0)==0)){c=TKc(g,0,0)|0;if(!c)if(!(b[a+8>>0]|0))c=0;else c=sLc(f[i>>2]|0,h[a+10>>0]|0)|0}else c=0;i=e;f[i>>2]=0;f[i+4>>2]=0;break a}case 1:break;default:if(e<<24>>24==5|(b[a+4>>0]|0)==0){i=(b[a+12>>0]|0)==0;DKc(g);if(!i){c=0;break a}c=uLc(f[a>>2]|0,f[a+172>>2]|0,h[a+9>>0]|0)|0;break a}}if(!c)c=(b[a+12>>0]|0)!=0&1;else c=1;c=tLc(a,c)|0;i=a+72|0;f[i>>2]=0;f[i+4>>2]=0}while(0);g=a+56|0;rKc(f[g>>2]|0);f[g>>2]=0;f[a+44>>2]=0;g=(c|0)==0;if(g){if((b[a+15>>0]|0)==0?(vLc(a,d)|0)==0:0){e=a+212|0;xLc(f[e>>2]|0)}else{e=a+212|0;wLc(f[e>>2]|0)}lLc(f[e>>2]|0,f[a+24>>2]|0)}i=a+216|0;e=f[i>>2]|0;if(!e){if((d|0)!=0&g){c=f[a+24>>2]|0;if((f[a+32>>2]|0)>>>0>c>>>0)c=yLc(a,c)|0;else c=0}}else oLc(e);if((d|0)!=0&(c|0)==0){e=EKc(f[a+60>>2]|0,22,0)|0;e=(e|0)==12?0:e}else e=c;do if(!(b[a+4>>0]|0)){c=f[i>>2]|0;if(c|0?(zLc(c,0)|0)==0:0){c=0;break}c=hLc(a,1)|0}else c=0;while(0);b[j>>0]=1;b[a+19>>0]=0;j=(e|0)==0?c:e;return j|0}function eLc(a){a=a|0;var c=0,d=0;c=a+56|0;rKc(f[c>>2]|0);f[c>>2]=0;fLc(a);c=f[a+216>>2]|0;if(!c){if(!(b[a+4>>0]|0)){c=f[a+60>>2]|0;if(!(((f[c>>2]|0)!=0?((tKc(c)|0)&2048|0)!=0:0)?(b[a+5>>0]&5)==1:0))DKc(f[a+64>>2]|0);c=a+16|0;if((hLc(a,0)|0)!=0?(b[c>>0]|0)==6:0){b[a+17>>0]=5;d=11}else d=11}}else{gLc(c);c=a+16|0;d=11}if((d|0)==11)b[c>>0]=0;d=a+40|0;if(!(f[d>>2]|0)){d=a+72|0;a=a+19|0;b[a>>0]=0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;return}if(!(b[a+12>>0]|0)){iLc(a);b[a+18>>0]=0;c=0}else c=(f[f[a+64>>2]>>2]|0)==0&1;b[a+16>>0]=c;f[d>>2]=0;VKc(a);d=a+72|0;a=a+19|0;b[a>>0]=0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;return}function fLc(a){a=a|0;var c=0,d=0,e=0;d=a+96|0;e=a+92|0;c=0;while(1){if((c|0)>=(f[d>>2]|0))break;rKc(f[(f[e>>2]|0)+(c*48|0)+16>>2]|0);c=c+1|0}c=f[a+68>>2]|0;if(!((b[a+4>>0]|0)!=0?!(SKc(c)|0):0))DKc(c);qxc(f[e>>2]|0);f[e>>2]=0;f[d>>2]=0;f[a+52>>2]=0;return}function gLc(a){a=a|0;var b=0,c=0;oLc(a);b=a+40|0;c=d[b>>1]|0;if(c<<16>>16<=-1)return;pLc(a,(c<<16>>16)+3|0);d[b>>1]=-1;return}function hLc(a,c){a=a|0;c=c|0;var d=0,e=0;d=f[a+60>>2]|0;if(f[d>>2]|0){if(!(b[a+13>>0]|0))d=nLc(d,c)|0;else d=0;e=a+17|0;if((b[e>>0]|0)!=5)b[e>>0]=c}else d=0;b[a+18>>0]=b[a+12>>0]|0;return d|0}function iLc(a){a=a|0;var b=0;b=a+100|0;f[b>>2]=(f[b>>2]|0)+1;jLc(f[a+88>>2]|0);kLc(f[a+212>>2]|0);return}function jLc(a){a=a|0;while(1){if(!a)break;f[a+16>>2]=1;a=f[a+44>>2]|0}return}function kLc(a){a=a|0;lLc(a,0);return}function lLc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=a+44|0;if(!(f[g>>2]|0))return;c=f[a>>2]|0;while(1){if(!c)break;e=f[c+32>>2]|0;if((f[c+24>>2]|0)>>>0>b>>>0)mLc(c);c=e}if(!b)if((f[a+12>>2]|0)!=0?(d=vd[f[40840>>2]&255](f[g>>2]|0,1,0)|0,(d|0)!=0):0){Mrd(f[d>>2]|0,0,f[a+24>>2]|0)|0;b=1}else b=0;Jd[f[40852>>2]&1023](f[g>>2]|0,b+1|0);return}function mLc(a){a=a|0;var b=0;mKc(a,1);b=a+28|0;d[b>>1]=d[b>>1]&-16|1;if(d[a+30>>1]|0)return;OKc(a);return}function nLc(a,b){a=a|0;b=b|0;return td[f[(f[a>>2]|0)+32>>2]&1023](a,b)|0}function oLc(a){a=a|0;var c=0;c=a+44|0;if(!(b[c>>0]|0))return;rLc(a,0,1);b[c>>0]=0;f[a+104>>2]=0;b[a+47>>0]=0;return}function pLc(a,c){a=a|0;c=c|0;if(b[a+43>>0]|0)return;qLc(f[a+4>>2]|0,c,1,5)|0;return}function qLc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return xd[f[(f[a>>2]|0)+56>>2]&63](a,b,c,d)|0}function rLc(a,c,d){a=a|0;c=c|0;d=d|0;if(b[a+43>>0]|0)return;qLc(f[a+4>>2]|0,c,d,9)|0;return}function sLc(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}b=td[f[(f[a>>2]|0)+20>>2]&1023](a,b)|0;return b|0}function tLc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;h=j;i=a+72|0;if((f[i>>2]|0)==0&(f[i+4>>2]|0)==0){i=0;t=j;return i|0}g=a+160|0;e=f[g>>2]|0;g=f[g+4>>2]|0;i=a+64|0;d=f[i>>2]|0;if((c|0)!=0|(e|0)==0&(g|0)==0)c=TKc(d,0,0)|0;else c=iKc(d,144464,28,0,0)|0;if(c|0){i=c;t=j;return i|0}if(!(b[a+7>>0]|0))c=sLc(f[i>>2]|0,(b[a+10>>0]|16)&255)|0;else c=0;if(!(((g|0)>0|(g|0)==0&e>>>0>0)&(c|0)==0)){i=c;t=j;return i|0}c=BLc(f[i>>2]|0,h)|0;a=f[h+4>>2]|0;if((c|0)==0&((a|0)>(g|0)|((a|0)==(g|0)?(f[h>>2]|0)>>>0>e>>>0:0)))c=TKc(f[i>>2]|0,e,g)|0;i=c;t=j;return i|0}function uLc(a,b,c){a=a|0;b=b|0;c=c|0;return vd[f[a+28>>2]&255](a,b,c)|0}function vLc(a,c){a=a|0;c=c|0;if(!(b[a+12>>0]|0)){c=1;return c|0}if(!c){c=0;return c|0}if(!(f[f[a+60>>2]>>2]|0)){c=0;return c|0}c=(CLc(f[a+212>>2]|0)|0)>24&1;return c|0}function wLc(a){a=a|0;var b=0;while(1){b=f[a>>2]|0;if(!b)break;mLc(b)}return}function xLc(a){a=a|0;var b=0,c=0;b=a;while(1){b=f[b>>2]|0;if(!b)break;c=b+28|0;d[c>>1]=d[c>>1]&-13;b=b+32|0}f[a+8>>2]=f[a+4>>2];return}function yLc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;g=n;l=a+60|0;e=f[l>>2]|0;if(!(f[e>>2]|0)){m=0;t=n;return m|0}if(((b[a+16>>0]|0)+-1&255)<=2){m=0;t=n;return m|0}k=f[a+152>>2]|0;e=BLc(e,g)|0;h=((k|0)<0)<<31>>31;i=Brd(k|0,h|0,c|0,0)|0;j=G;do if(!e){e=f[g>>2]|0;g=f[g+4>>2]|0;if((e|0)==(i|0)&(g|0)==(j|0))d=0;else{if(!((g|0)>(j|0)|(g|0)==(j|0)&e>>>0>i>>>0)){g=vrd(e|0,g|0,k|0,h|0)|0;e=G;if(!((e|0)>(j|0)|(e|0)==(j|0)&g>>>0>i>>>0)){m=wrd(i|0,j|0,k|0,h|0)|0;d=G;j=f[a+208>>2]|0;Mrd(j|0,0,k|0)|0;d=iKc(f[l>>2]|0,j,k,m,d)|0;m=9}}else{d=TKc(f[l>>2]|0,i,j)|0;m=9}if((m|0)==9?d|0:0)break;f[a+32>>2]=c;d=0}}else d=e;while(0);m=d;t=n;return m|0}function zLc(a,c){a=a|0;c=c|0;do if(!c){c=a+43|0;if(b[c>>0]|0){b[c>>0]=0;if(!(ALc(a,(d[a+40>>1]|0)+3|0)|0)){c=(b[c>>0]|0)==0;break}else{b[c>>0]=1;c=0;break}}else c=0}else if((c|0)>0){pLc(a,(d[a+40>>1]|0)+3|0);b[a+43>>0]=1;c=1;break}else{c=(b[a+43>>0]|0)==0;break}while(0);return c&1|0}function ALc(a,c){a=a|0;c=c|0;if(b[a+43>>0]|0){c=0;return c|0}c=qLc(f[a+4>>2]|0,c,1,6)|0;return c|0}function BLc(a,b){a=a|0;b=b|0;return td[f[(f[a>>2]|0)+24>>2]&1023](a,b)|0}function CLc(a){a=a|0;var b=0,c=0;c=DLc(a)|0;b=0;while(1){a=f[a>>2]|0;if(!a)break;a=a+32|0;b=b+1|0}if(!c){c=0;return c|0}b=Brd(b|0,0,100,0)|0;c=zrd(b|0,G|0,c|0,((c|0)<0)<<31>>31|0)|0;return c|0}function DLc(a){a=a|0;var b=0,c=0;b=f[a+16>>2]|0;if((b|0)>-1)return b|0;c=Brd(b|0,((b|0)<0)<<31>>31|0,-1024,-1)|0;b=(f[a+28>>2]|0)+(f[a+24>>2]|0)|0;b=zrd(c|0,G|0,b|0,((b|0)<0)<<31>>31|0)|0;return b|0}function ELc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=t;t=t+32|0;A=C+8|0;q=C;r=C+28|0;s=C+24|0;z=C+20|0;w=C+16|0;g=f[a>>2]|0;f[s>>2]=0;f[z>>2]=1;u=a+152|0;f[w>>2]=f[u>>2];x=a+64|0;d=BLc(f[x>>2]|0,q)|0;a:do if(!d){v=a+208|0;e=f[v>>2]|0;d=GLc(f[x>>2]|0,e,(f[(f[a>>2]|0)+8>>2]|0)+1|0)|0;if(!d){if(!(b[e>>0]|0))d=0;else d=HLc(g,e,0,z)|0;b:do if((d|0)==0&(f[z>>2]|0)!=0){m=a+72|0;n=m;f[n>>2]=0;f[n+4>>2]=0;n=a+148|0;o=a+80|0;p=a+24|0;e=0;l=c;while(1){d=q;d=ILc(a,c,f[d>>2]|0,f[d+4>>2]|0,r,s)|0;switch(d|0){case 101:break b;case 0:break;default:{B=25;break b}}d=f[r>>2]|0;if((d|0)==-1){k=q;k=wrd(f[k>>2]|0,f[k+4>>2]|0,f[n>>2]|0,0)|0;d=(f[u>>2]|0)+8|0;d=zrd(k|0,G|0,d|0,((d|0)<0)<<31>>31|0)|0;f[r>>2]=d}if(!(d|c)){h=o;j=f[n>>2]|0;h=vrd(f[h>>2]|0,f[h+4>>2]|0,j|0,0)|0;g=G;k=m;i=f[k>>2]|0;k=f[k+4>>2]|0;if((h|0)==(i|0)&(g|0)==(k|0)){i=q;i=wrd(f[i>>2]|0,f[i+4>>2]|0,h|0,g|0)|0;k=(f[u>>2]|0)+8|0;k=zrd(i|0,G|0,k|0,((k|0)<0)<<31>>31|0)|0;f[r>>2]=k;i=h;h=0}else{g=k;h=0;k=d}}else{g=m;i=f[g>>2]|0;j=f[n>>2]|0;g=f[g+4>>2]|0;h=0;k=d}if((i|0)==(j|0)&(g|0)==(h|0)){g=f[s>>2]|0;d=yLc(a,g)|0;if(d|0){B=26;break a}f[p>>2]=g}g=0;d=l;c:while(1){if(g>>>0>=k>>>0)break;if(d|0)iLc(a);d=JLc(a,m,0,1,0)|0;switch(d|0){case 522:break b;case 101:{B=23;break c}case 0:break;default:{B=25;break b}}g=g+1|0;e=e+1|0;d=0}if((B|0)==23){B=0;k=q;l=f[k+4>>2]|0;d=m;f[d>>2]=f[k>>2];f[d+4>>2]=l;d=0}l=d}}else{e=0;B=25}while(0);if((B|0)==25)if(d){B=26;break}d=KLc(a,w,-1)|0;b[a+18>>0]=b[a+12>>0]|0;if(!d){g=f[v>>2]|0;h=g+4|0;d=GLc(f[x>>2]|0,h,(f[(f[a>>2]|0)+8>>2]|0)+1|0)|0;if(!d){if(((b[a+16>>0]|0)+-1&255)>2?(y=LLc(a,0)|0,y|0):0){d=y;break}d=dLc(a,(b[h>>0]|0)!=0&1,0)|0;if(!d)if((b[h>>0]|0)!=0&(f[z>>2]|0)!=0){b[g>>0]=0;b[g+1>>0]=0;b[g+2>>0]=0;b[g+3>>0]=0;d=MLc(a,h)|0}else d=0}}}else{e=0;B=26}}else{e=0;B=26}while(0);if((B|0)==26)b[a+18>>0]=b[a+12>>0]|0;if(!((c|0)!=0&(e|0)!=0)){NLc(a);t=C;return d|0}B=f[a+172>>2]|0;f[A>>2]=e;f[A+4>>2]=B;dxc(539,121012,A);NLc(a);t=C;return d|0}function FLc(a,c){a=a|0;c=c|0;switch((c&255)<<24>>24){case 10:case 13:break;default:return c|0}f[a+40>>2]=c;b[a+16>>0]=6;VKc(a);return c|0}function GLc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=t;t=t+32|0;k=m+12|0;i=m;l=m+8|0;j=m+16|0;b[c>>0]=0;h=BLc(a,i)|0;g=i;e=f[g>>2]|0;g=f[g+4>>2]|0;if((h|0)!=0|((g|0)<0|(g|0)==0&e>>>0<16)){c=h;t=m;return c|0}e=vrd(e|0,g|0,-16,-1)|0;e=ULc(a,e,G,k)|0;if(e|0){c=e;t=m;return c|0}e=f[k>>2]|0;if(e>>>0>=d>>>0){c=0;t=m;return c|0}h=i;g=f[h>>2]|0;h=f[h+4>>2]|0;d=vrd(g|0,h|0,-16,-1)|0;n=G;if((e|0)==0|((n|0)<0|(n|0)==0&d>>>0<e>>>0)){n=0;t=m;return n|0}g=vrd(g|0,h|0,-12,-1)|0;g=ULc(a,g,G,l)|0;if(g|0){n=g;t=m;return n|0}g=i;g=vrd(f[g>>2]|0,f[g+4>>2]|0,-8,-1)|0;g=QLc(a,j,8,g,G)|0;if(g|0){n=g;t=m;return n|0}if(ocd(j,121039,8)|0){n=0;t=m;return n|0}g=i;n=f[g>>2]|0;g=f[g+4>>2]|0;j=wrd(-16,-1,e|0,0)|0;g=vrd(j|0,G|0,n|0,g|0)|0;g=QLc(a,c,e,g,G)|0;if(g|0){n=g;t=m;return n|0}g=0;h=f[l>>2]|0;while(1){if((g|0)==(e|0))break;n=h-(b[c+g>>0]|0)|0;g=g+1|0;h=n}f[l>>2]=h;if(h){f[k>>2]=0;e=0}b[c+e>>0]=0;b[c+(e+1)>>0]=0;n=0;t=m;return n|0}function HLc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return xd[f[a+32>>2]&63](a,b,c,d)|0}function ILc(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=t;t=t+16|0;h=o+8|0;l=o+4|0;k=o;j=sKc(a)|0;i=G;n=a+72|0;m=n;f[m>>2]=j;f[m+4>>2]=i;m=a+148|0;p=vrd(j|0,i|0,f[m>>2]|0,0)|0;q=G;if((q|0)>(d|0)|(q|0)==(d|0)&p>>>0>c>>>0){q=101;t=o;return q|0}if((b|0)==0?(q=a+80|0,(j|0)==(f[q>>2]|0)?(i|0)==(f[q+4>>2]|0):0):0)c=a+64|0;else{b=a+64|0;c=QLc(f[b>>2]|0,h,8,j,i)|0;if(c|0){q=c;t=o;return q|0}if(!(ocd(h,121039,8)|0))c=b;else{q=101;t=o;return q|0}}q=f[c>>2]|0;b=vrd(j|0,i|0,8,0)|0;b=ULc(q,b,G,e)|0;if(b|0){q=b;t=o;return q|0}q=f[c>>2]|0;b=vrd(j|0,i|0,12,0)|0;b=ULc(q,b,G,a+48|0)|0;if(b|0){q=b;t=o;return q|0}q=f[c>>2]|0;b=vrd(j|0,i|0,16,0)|0;b=ULc(q,b,G,g)|0;if(b|0){q=b;t=o;return q|0}d=n;b=f[d>>2]|0;d=f[d+4>>2]|0;do if((b|0)==0&(d|0)==0){q=f[c>>2]|0;b=vrd(j|0,i|0,20,0)|0;b=ULc(q,b,G,k)|0;if(!b){q=f[c>>2]|0;b=vrd(j|0,i|0,24,0)|0;b=ULc(q,b,G,l)|0;if(!b){b=f[l>>2]|0;if(!b){b=f[a+152>>2]|0;f[l>>2]=b}c=f[k>>2]|0;if((!((b+-512|0)>>>0>65024|(c+-32|0)>>>0>65504)?(b+-1&b|0)==0:0)?(c+-1&c|0)==0:0){h=KLc(a,l,-1)|0;f[m>>2]=c;b=n;d=f[b+4>>2]|0;b=f[b>>2]|0;break}else b=101}}q=b;t=o;return q|0}else{h=0;c=f[m>>2]|0}while(0);p=vrd(b|0,d|0,c|0,0)|0;q=n;f[q>>2]=p;f[q+4>>2]=G;q=h;t=o;return q|0}function JLc(a,c,e,g,h){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0;z=t;t=t+16|0;y=z+8|0;m=z+4|0;o=z;x=f[a+208>>2]|0;s=(g|0)!=0;n=f[(s?a+64|0:a+68|0)>>2]|0;i=c;i=ULc(n,f[i>>2]|0,f[i+4>>2]|0,m)|0;if(i|0){y=i;t=z;return y|0}w=a+152|0;u=f[w>>2]|0;i=c;i=vrd(f[i>>2]|0,f[i+4>>2]|0,4,0)|0;i=QLc(n,x,u,i,G)|0;if(i|0){y=i;t=z;return y|0}i=f[w>>2]|0;k=(g<<2)+4+i|0;l=c;k=vrd(f[l>>2]|0,f[l+4>>2]|0,k|0,((k|0)<0)<<31>>31|0)|0;l=G;u=c;f[u>>2]=k;f[u+4>>2]=l;u=f[m>>2]|0;if(!u){y=101;t=z;return y|0}if((u|0)==(((f[19118]|0)/(i|0)|0)+1|0)){y=101;t=z;return y|0}if(u>>>0>(f[a+24>>2]|0)>>>0){y=0;t=z;return y|0}if(FKc(e,u)|0){y=0;t=z;return y|0}if(s){i=vrd(k|0,l|0,-4,-1)|0;i=ULc(n,i,G,o)|0;if(i|0){y=i;t=z;return y|0}if((h|0)==0?(h=gKc(a,x)|0,(h|0)!=(f[o>>2]|0)):0){y=101;t=z;return y|0}}if(e|0?(p=jKc(e,u)|0,p|0):0){y=p;t=z;return y|0}n=(u|0)==1;if(n?(q=a+142|0,r=b[x+20>>0]|0,(d[q>>1]|0)!=(r&255|0)):0)d[q>>1]=r&255;if(!(f[a+216>>2]|0))i=IKc(a,u)|0;else i=0;f[y>>2]=i;if(s)if(!(b[a+7>>0]|0)){s=c;r=f[s+4>>2]|0;k=a+80|0;c=f[k+4>>2]|0;k=((r|0)<(c|0)|((r|0)==(c|0)?(f[s>>2]|0)>>>0<=(f[k>>2]|0)>>>0:0))&1}else k=1;else if(!i)k=1;else k=((j[i+28>>1]|0)>>>3&1^1)&65535;l=f[a+60>>2]|0;do if(f[l>>2]|0){m=b[a+16>>0]|0;if((m&255)>3){if(!k){v=31;break}}else if(!((k|0)!=0&m<<24>>24==0)){v=31;break}g=f[w>>2]|0;k=Brd(g|0,((g|0)<0)<<31>>31|0,u+-1|0,0)|0;l=iKc(l,x,g,k,G)|0;k=a+32|0;if(u>>>0>(f[k>>2]|0)>>>0)f[k>>2]=u;k=f[a+88>>2]|0;if(!k)m=l;else{VLc(k,u,x);m=l}}else v=31;while(0);do if((v|0)==31)if((g|0)==0&(i|0)==0){v=a+20|0;b[v>>0]=b[v>>0]|2;i=GKc(a,u,y,1)|0;b[v>>0]=b[v>>0]&-3;if(!i){dKc(f[y>>2]|0);m=0;i=f[y>>2]|0;break}else{y=i;t=z;return y|0}}else m=0;while(0);if(!i){y=m;t=z;return y|0}i=f[i+4>>2]|0;Krd(i|0,x|0,f[w>>2]|0)|0;Hd[f[a+200>>2]&1023](f[y>>2]|0);if(n){l=a+104|0;i=i+24|0;k=l+16|0;do{b[l>>0]=b[i>>0]|0;l=l+1|0;i=i+1|0}while((l|0)<(k|0))}NKc(f[y>>2]|0);y=m;t=z;return y|0}function KLc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;k=n;l=f[c>>2]|0;if(!((b[a+15>>0]|0)!=0?(f[a+24>>2]|0)!=0:0))h=3;do if(((h|0)==3?(i=a+212|0,(l|0)!=0&(aLc(f[i>>2]|0)|0)==0):0)?(m=a+152|0,(l|0)!=(f[m>>2]|0)):0){h=k;f[h>>2]=0;f[h+4>>2]=0;if(((b[a+16>>0]|0)!=0?(g=f[a+60>>2]|0,(f[g>>2]|0)!=0):0)?(j=BLc(g,k)|0,(j|0)!=0):0){g=0;e=j}else{g=RLc(l+8|0)|0;if(g){h=g+l|0;j=h;b[j>>0]=0;b[j+1>>0]=0;b[j+2>>0]=0;b[j+3>>0]=0;h=h+4|0;b[h>>0]=0;b[h+1>>0]=0;b[h+2>>0]=0;b[h+3>>0]=0;iLc(a);h=SLc(f[i>>2]|0,l)|0;if(!h){j=a+208|0;TLc(f[j>>2]|0);f[j>>2]=g;j=f[k>>2]|0;k=f[k+4>>2]|0;i=vrd(l|0,0,-1,-1)|0;k=vrd(i|0,G|0,j|0,k|0)|0;k=zrd(k|0,G|0,l|0,0)|0;f[a+24>>2]=k;f[m>>2]=l;break}else e=h}else{g=0;e=7}}TLc(g);f[c>>2]=f[m>>2];m=e;t=n;return m|0}while(0);f[c>>2]=f[a+152>>2];g=a+142|0;if((e|0)<0)e=d[g>>1]|0;d[g>>1]=e;m=0;t=n;return m|0}function LLc(a,c){a=a|0;c=c|0;var d=0;d=a+60|0;c=EKc(f[d>>2]|0,21,c)|0;c=(c|0)==12?0:c;if(c|0){d=c;return d|0}if(b[a+7>>0]|0){d=0;return d|0}d=sLc(f[d>>2]|0,h[a+10>>0]|0)|0;return d|0}function MLc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=t;t=t+16|0;k=o;l=o+8|0;m=f[a>>2]|0;d=m+4|0;n=f[d>>2]<<1;n=DCc(n,((n|0)<0)<<31>>31)|0;if(!n){qxc(0);n=7;t=o;return n|0}a=uKc(m,c,n,16385,0)|0;j=n+(f[d>>2]|0)|0;if(!a){a=BLc(n,k)|0;if(!a){h=(f[m+8>>2]|0)+1|0;d=k;d=vrd(f[d>>2]|0,f[d+4>>2]|0,6,0)|0;d=vrd(d|0,G|0,h|0,((h|0)<0)<<31>>31|0)|0;d=vxc(d,G)|0;if(d){e=d+4|0;b[d>>0]=0;b[d+1>>0]=0;b[d+2>>0]=0;b[d+3>>0]=0;a=f[k>>2]|0;i=e+(a+2)|0;a=QLc(n,e,a,0,0)|0;if(!a){b[e+(f[k>>2]|0)>>0]=0;b[e+((f[k>>2]|0)+1)>>0]=0;g=e;while(1){a=e-g|0;q=((a|0)<0)<<31>>31;p=k;r=f[p+4>>2]|0;if(!((r|0)>(q|0)|((r|0)==(q|0)?(f[p>>2]|0)>>>0>a>>>0:0))){e=17;break}a=HLc(m,e,0,l)|0;if(a|0){e=15;break}if(f[l>>2]|0){a=uKc(m,e,j,16385,0)|0;if(a|0){e=15;break}a=GLc(j,i,h)|0;DKc(j);if(a|0){e=15;break}if(b[i>>0]|0?(ncd(i,c)|0)==0:0){a=0;e=15;break}}e=e+((Mxc(e)|0)+1)|0}if((e|0)!=15)if((e|0)==17){DKc(n);a=uLc(m,c,0)|0}qxc(d)}else e=18}else{d=0;a=7;e=18}}else{d=0;e=18}}else{d=0;e=18}if((e|0)==18)qxc(d);DKc(n);qxc(n);r=a;t=o;return r|0}function NLc(a){a=a|0;var c=0;if((b[a+12>>0]|0)==0?(c=a+60|0,((tKc(f[c>>2]|0)|0)&4096|0)==0):0)c=OLc(f[c>>2]|0)|0;else c=512;f[a+148>>2]=c;return}function OLc(a){a=a|0;a=PLc(a)|0;if((a|0)<32)return 512;else return ((a|0)<65536?a:65536)|0;return 0}function PLc(a){a=a|0;var b=0;b=f[(f[a>>2]|0)+44>>2]|0;if(!b){b=4096;return b|0}b=sd[b&2047](a)|0;return b|0}function QLc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return zd[f[(f[a>>2]|0)+8>>2]&127](a,b,c,d,e)|0}function RLc(a){a=a|0;return CCc(a)|0}function SLc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;e=a+24|0;if(!(f[e>>2]|0)){e=0;return e|0}d=vd[f[40828>>2]&255](b,(f[a+28>>2]|0)+40|0,h[a+32>>0]|0)|0;if(!d){e=7;return e|0}g=f[10208]|0;c=DLc(a)|0;Jd[g&1023](d,c);a=a+44|0;c=f[a>>2]|0;if(c|0)Hd[f[40856>>2]&1023](c);f[a>>2]=d;f[e>>2]=b;g=0;return g|0}function TLc(a){a=a|0;uCc(a);return}function ULc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+16|0;e=g;a=QLc(a,e,4,b,c)|0;if(a|0){t=g;return a|0}e=NJc(e)|0;f[d>>2]=e;t=g;return a|0}function VLc(a,b,c){a=a|0;b=b|0;c=c|0;if(!a)return;WLc(a,b,c);return}function WLc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;do{d=a+28|0;if(((XLc(f[d>>2]|0)|0)==0?(f[a+16>>2]|0)>>>0>b>>>0:0)?(axc(f[(f[a>>2]|0)+12>>2]|0),e=YLc(a,b,c,1)|0,bxc(f[(f[a>>2]|0)+12>>2]|0),e|0):0)f[d>>2]=e;a=f[a+44>>2]|0}while((a|0)!=0);return}function XLc(a){a=a|0;switch(a|0){case 0:case 5:{a=0;break}default:a=(a|0)!=6&1}return a|0}function YLc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;v=t;t=t+16|0;r=v;s=a+4|0;n=f[s>>2]|0;u=Cyc(n)|0;q=a+24|0;m=ZLc(f[q>>2]|0)|0;n=ZLc(n)|0;o=(m|0)<(n|0)?m:n;p=((m|0)<0)<<31>>31;j=Brd(m|0,p|0,c|0,0)|0;k=G;if((m|0)==(n|0))a=0;else{a=(_Lc(u)|0)==0;a=a?0:8}h=wrd(j|0,k|0,m|0,p|0)|0;l=((n|0)<0)<<31>>31;i=(e|0)==0;g=G;while(1){if(!(((g|0)<(k|0)|(g|0)==(k|0)&h>>>0<j>>>0)&(a|0)==0))break;f[r>>2]=0;c=zrd(h|0,g|0,n|0,l|0)|0;e=G;if((((f[19118]|0)>>>0)/((f[(f[(f[s>>2]|0)+4>>2]|0)+36>>2]|0)>>>0)|0|0)==(c|0))a=0;else{a=GKc(u,c+1|0,r,0)|0;if(!a){a=PJc(f[r>>2]|0)|0;if(!a){w=Crd(h|0,g|0,m|0,p|0)|0;x=$Lc(f[r>>2]|0)|0;a=Brd(c|0,e|0,n|0,l|0)|0;a=wrd(h|0,g|0,a|0,G|0)|0;a=x+a|0;Krd(a|0,d+w|0,o|0)|0;e=aMc(f[r>>2]|0)|0;b[e>>0]=0;if(i&((h|0)==0&(g|0)==0)){RJc(a+28|0,bMc(f[q>>2]|0)|0);a=0}else a=0}}cMc(f[r>>2]|0)}x=vrd(h|0,g|0,n|0,l|0)|0;g=G;h=x}t=v;return a|0}function ZLc(a){a=a|0;return f[(f[a+4>>2]|0)+36>>2]|0}function _Lc(a){a=a|0;return h[a+12>>0]|0|0}function $Lc(a){a=a|0;return f[a+4>>2]|0}function aMc(a){a=a|0;return f[a+8>>2]|0}function bMc(a){a=a|0;return dMc(f[a+4>>2]|0)|0}function cMc(a){a=a|0;if(!a)return;HKc(a);return}function dMc(a){a=a|0;return f[a+48>>2]|0}function eMc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;x=t;t=t+16|0;u=x;v=f[a+68>>2]|0;do if(v|0){if((d[a+40>>1]|0)==0?(b[a+50>>0]|0)==0:0)break;p=a+100|0;q=gMc(f[p>>2]|0)|0;r=u+8|0;s=u+4|0;o=gMc(v)|0;a:while(1){if((o|0)<(q|0)){g=0;w=18;break}g=hMc(a,o,u)|0;if(g|0)break;k=iMc(c)|0;l=f[u>>2]|0;m=f[r>>2]|0;n=f[s>>2]|0;j=8192;g=0;while(1){i=d[l+(k<<1)>>1]|0;h=i&65535;if(!(i<<16>>16))break;i=m+h|0;if(i>>>0<=v>>>0?i>>>0>=(f[p>>2]|0)>>>0:0)g=(f[n+(h<<2)>>2]|0)==(c|0)?i:g;if(!j){w=14;break a}j=j+-1|0;k=jMc(k)|0}if(!g)o=o+-1|0;else{w=18;break}}if((w|0)==14)g=YJc(62957)|0;else if((w|0)==18){f[e>>2]=g;w=0;t=x;return w|0}w=g;t=x;return w|0}while(0);f[e>>2]=0;w=0;t=x;return w|0}function fMc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=j[a+66>>1]|0;e=e<<16&65536|e&65024;b=Brd(e|24|0,0,b+-1|0,0)|0;b=vrd(b|0,G|0,56,0)|0;return QLc(f[a+8>>2]|0,d,(e|0)<(c|0)?e:c,b,G)|0}function gMc(a){a=a|0;return (a+33|0)>>>12|0}function hMc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=c+4|0;d=kMc(a,b,e)|0;if(d|0)return d|0;a=f[e>>2]|0;f[c>>2]=a+16384;if(!b){a=a+136|0;f[e>>2]=a;b=0}else b=(b<<12)+-34|0;f[c+8>>2]=b;f[e>>2]=a+-4;return d|0}function iMc(a){a=a|0;return a*383&8191|0}function jMc(a){a=a|0;return a+1&8191|0}function kMc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((f[a+24>>2]|0)>(b|0)?(d=f[(f[a+32>>2]|0)+(b<<2)>>2]|0,f[c>>2]=d,d|0):0){d=0;return d|0}d=lMc(a,b,c)|0;return d|0}function lMc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0;g=a+24|0;do if((f[g>>2]|0)<=(c|0)){i=c+1|0;j=a+32|0;e=Pxc(f[j>>2]|0,i<<2,0)|0;if(e|0){k=f[g>>2]|0;Mrd(e+(k<<2)|0,0,i-k<<2|0)|0;f[j>>2]=e;f[g>>2]=i;break}f[d>>2]=0;k=7;return k|0}while(0);do if((b[a+43>>0]|0)!=2){e=a+32|0;g=mMc(f[a+4>>2]|0,c,h[a+44>>0]|0,(f[e>>2]|0)+(c<<2)|0)|0;if(!g){if((c|0)<=0){g=0;break}g=(nMc(600)|0)==0;g=g?0:7;break}else{i=a+46|0;if((g&255|0)!=8)break;b[i>>0]=b[i>>0]|2;g=(g|0)==8?0:g;break}}else{g=DCc(32768,0)|0;e=a+32|0;f[(f[e>>2]|0)+(c<<2)>>2]=g;g=(f[(f[e>>2]|0)+(c<<2)>>2]|0)==0?7:0}while(0);f[d>>2]=f[(f[e>>2]|0)+(c<<2)>>2];k=g;return k|0}function mMc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return zd[f[(f[a>>2]|0)+52>>2]&127](a,b,32768,c,d)|0}function nMc(a){a=a|0;var b=0;b=f[10239]|0;if(!b){b=0;return b|0}b=sd[b&2047](a)|0;return b|0}function oMc(a){a=a|0;var b=0,c=0,d=0;f[a+24>>2]=f[a+28>>2];b=rMc(f[a+216>>2]|0,a)|0;c=sMc(f[a+212>>2]|0)|0;while(1){if(!((c|0)!=0&(b|0)==0))break;d=f[c+16>>2]|0;b=tMc(a,f[c+24>>2]|0)|0;c=d}return b|0}function pMc(a,b){a=a|0;b=b|0;var c=0,d=0;c=b+12|0;d=a+112|0;if((f[c>>2]|0)==(f[d>>2]|0))c=f[b>>2]|0;else{f[b>>2]=0;f[c>>2]=f[d>>2];c=0}d=a+68|0;if(c>>>0>=(f[d>>2]|0)>>>0)return;f[d>>2]=c;f[a+76>>2]=f[b+4>>2];f[a+80>>2]=f[b+8>>2];qMc(a);return}function qMc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;b=a+68|0;c=f[b>>2]|0;if(!c){t=h;return}if(hMc(a,gMc(c)|0,g)|0){t=h;return}b=(f[b>>2]|0)-(f[g+8>>2]|0)|0;c=f[g>>2]|0;a=0;while(1){if((a|0)==8192)break;e=c+(a<<1)|0;if((b|0)<(j[e>>1]|0|0))d[e>>1]=0;a=a+1|0}g=(f[g+4>>2]|0)+(b+1<<2)|0;Mrd(g|0,0,c-g|0)|0;t=h;return}function rMc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;if(!(b[a+44>>0]|0)){i=0;return i|0}h=a+68|0;i=f[h>>2]|0;d=a+52|0;e=xMc(a)|0;g=d+48|0;do{b[d>>0]=b[e>>0]|0;d=d+1|0;e=e+1|0}while((d|0)<(g|0));e=f[h>>2]|0;g=0;while(1){d=e+1|0;if((g|0)!=0|d>>>0>i>>>0)break;e=d;g=tMc(c,yMc(a,d)|0)|0}if((i|0)==(f[h>>2]|0)){i=g;return i|0}qMc(a);i=g;return i|0}function sMc(a){a=a|0;var b=0,c=0;b=f[a>>2]|0;a=b;while(1){if(!a)break;c=f[a+32>>2]|0;f[a+16>>2]=c;a=c}return vMc(b)|0}function tMc(a,b){a=a|0;b=b|0;var c=0;c=IKc(a,b)|0;do if(!c)b=0;else{if((uMc(c)|0)==1){_Kc(c);b=0;break}b=ZKc(c)|0;if(!b)Hd[f[a+200>>2]&1023](c);HKc(c)}while(0);jLc(f[a+88>>2]|0);return b|0}function uMc(a){a=a|0;return d[a+30>>1]|0}function vMc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0;i=t;t=t+128|0;h=i;b=h;c=b+128|0;do{f[b>>2]=0;b=b+4|0}while((b|0)<(c|0));while(1){if(!a)break;d=a+16|0;e=f[d>>2]|0;f[d>>2]=0;d=0;while(1){if(d>>>0>=31){b=9;break}c=h+(d<<2)|0;b=f[c>>2]|0;if(!b){b=6;break}b=wMc(b,a)|0;f[c>>2]=0;d=d+1|0;a=b}if((b|0)==6)f[c>>2]=a;else if((b|0)==9?(0,g=h+(d<<2)|0,(d|0)==31):0){d=wMc(f[g>>2]|0,a)|0;f[g>>2]=d}a=e}c=1;a=f[h>>2]|0;while(1){if((c|0)==32)break;b=f[h+(c<<2)>>2]|0;if(b)if(!a)a=b;else a=wMc(a,b)|0;c=c+1|0}t=i;return a|0}function wMc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+48|0;g=h;c=g;e=a;a:while(1){d=f[e+24>>2]|0;a=c;while(1){a=a+16|0;if(d>>>0<(f[b+24>>2]|0)>>>0)break;f[a>>2]=b;a=f[b+16>>2]|0;if(!a){a=b;b=e;break a}else{c=b;b=a;a=c}}f[a>>2]=e;a=f[e+16>>2]|0;if(!a){a=e;break}else{c=e;e=a}}f[a+16>>2]=b;t=h;return f[g+16>>2]|0}function xMc(a){a=a|0;return f[f[a+32>>2]>>2]|0}function yMc(a,b){a=a|0;b=b|0;var c=0;c=gMc(b)|0;a=f[a+32>>2]|0;if(!c){c=(f[a>>2]|0)+(b+33<<2)|0;c=f[c>>2]|0;return c|0}else{c=(f[a+(c<<2)>>2]|0)+((b+33&4095)<<2)|0;c=f[c>>2]|0;return c|0}return 0}function zMc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;g=(c|0)==0;e=a;a:while(1){b:do if((e|0)!=(d|0)){if(!g?(f[e+64>>2]|0)!=(c|0):0)break;switch(b[e>>0]|0){case 2:case 0:{a=AMc(e)|0;if(!a)break b;else{e=9;break a}}default:{BMc(e);break b}}}while(0);e=f[e+24>>2]|0;if(!e){a=0;e=9;break}}if((e|0)==9)return a|0;return 0}function AMc(a){a=a|0;var c=0,d=0;c=a+1|0;if(b[c>>0]&64){d=2835;return d|0}if((b[a>>0]|0)==2)b[a>>0]=0;else f[a+4>>2]=0;d=DMc(a)|0;if(!d){BMc(a);b[a>>0]=3}b[c>>0]=b[c>>0]&-15;return d|0}function BMc(a){a=a|0;var c=0,d=0,e=0;e=a+68|0;c=b[e>>0]|0;if(c<<24>>24<=-1)return;d=0;while(1){if((d|0)>=(c<<24>>24|0))break;CMc(f[a+120+(d<<2)>>2]|0);d=d+1|0;c=b[e>>0]|0}CMc(f[a+116>>2]|0);b[e>>0]=-1;return}function CMc(a){a=a|0;HKc(f[a+72>>2]|0);return}function DMc(a){a=a|0;var c=0,d=0,e=0;if(b[a+69>>0]|0){d=EMc(a)|0;e=a+56|0;f[e>>2]=d;f[e+4>>2]=G;e=0;return e|0}e=FMc(a)|0;c=a+56|0;d=c;f[d>>2]=e;f[d+4>>2]=0;e=vrd(e|0,0,17,0)|0;e=vxc(e,G)|0;if(!e){e=7;return e|0}d=GMc(a,0,f[c>>2]|0,e)|0;if(!d){c=e+(f[c>>2]|0)|0;d=c+17|0;do{b[c>>0]=0;c=c+1|0}while((c|0)<(d|0));f[a+16>>2]=e;e=0;return e|0}else{qxc(e);e=d;return e|0}return 0}function EMc(a){a=a|0;IMc(a);a=a+32|0;G=f[a+4>>2]|0;return f[a>>2]|0}function FMc(a){a=a|0;IMc(a);return f[a+44>>2]|0}function GMc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return HMc(a,b,c,d,0)|0}function HMc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0;v=t;t=t+16|0;s=v+4|0;u=v;i=f[a+116>>2]|0;r=f[a+20>>2]|0;IMc(a);m=f[a+40>>2]|0;k=r+40|0;l=a+48|0;h=j[l>>1]|0;if((m-(f[i+56>>2]|0)|0)>>>0>((f[k>>2]|0)-h|0)>>>0){u=YJc(69811)|0;t=v;return u|0}if(h>>>0>c>>>0){h=(d+c|0)>>>0>h>>>0?h-c|0:d;n=0;d=d-h|0;p=e+h|0;h=JMc(m+c|0,e,h,g,f[i+72>>2]|0)|0}else{n=c-h|0;p=e;h=0}a:do if((h|0)==0&(d|0)!=0){c=f[k>>2]|0;q=c+-4|0;h=j[l>>1]|0;l=NJc(m+h|0)|0;f[s>>2]=l;k=a+1|0;do if(b[k>>0]&4){c=a+12|0;h=(n>>>0)/(q>>>0)|0;i=f[(f[c>>2]|0)+(h<<2)>>2]|0;if(!i){e=0;h=n;i=l;o=16}else{f[s>>2]=i;e=h;h=n-(V(h,q)|0)|0;o=16}}else{i=((c+-5-h+(f[a+44>>2]|0)|0)>>>0)/(q>>>0)|0;c=a+12|0;h=f[c>>2]|0;if(h){e=i<<2;a=(e|0)>(rxc(h)|0);h=f[c>>2]|0;if(a){e=c;o=11}}else{e=c;o=11}if((o|0)==11){h=Pxc(h,i<<3,0)|0;if(!h){h=7;break}f[e>>2]=h;e=i<<2}Mrd(h|0,0,e|0)|0;b[k>>0]=b[k>>0]|4;e=0;h=n;i=l;o=16}while(0);b:do if((o|0)==16){a=r+48|0;n=(g|0)==0?2:0;m=p;l=h;while(1){if(!i){h=0;o=32;break}if(i>>>0>(f[a>>2]|0)>>>0){o=19;break}h=f[c>>2]|0;f[h+(e<<2)>>2]=i;if(l>>>0<q>>>0){k=(l+d|0)>>>0>q>>>0?q-l|0:d;h=GKc(f[r>>2]|0,i,u,n)|0;if(!h){h=f[u>>2]|0;i=$Lc(h)|0;p=NJc(i)|0;f[s>>2]=p;h=JMc(i+(l+4)|0,m,k,g,h)|0;cMc(f[u>>2]|0);i=0}else i=l;d=d-k|0;if(!d)break b;k=m+k|0;e=e+1|0}else{e=e+1|0;h=f[h+(e<<2)>>2]|0;if(!h)h=KMc(r,i,0,s)|0;else{f[s>>2]=h;h=0}k=m;i=l-q|0}if(h|0){o=32;break}m=k;l=i;i=f[s>>2]|0}if((o|0)==19){h=YJc(69873)|0;break}else if((o|0)==32)break a}while(0);u=h;t=v;return u|0}while(0);if(!((h|0)==0&(d|0)!=0)){u=h;t=v;return u|0}u=YJc(69958)|0;t=v;return u|0}function IMc(a){a=a|0;var c=0;if(d[a+50>>1]|0)return;c=a+1|0;b[c>>0]=b[c>>0]|2;QMc(f[a+116>>2]|0,j[a+70>>1]|0,a+32|0);return}function JMc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;if(d){d=PJc(e)|0;if(!d){Krd(a|0,b|0,c|0)|0;d=0}}else{Krd(b|0,a|0,c|0)|0;d=0}return d|0}function KMc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=t;t=t+16|0;l=o+4|0;i=o;j=o+8|0;f[l>>2]=0;do if(b[a+17>>0]|0){g=((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0;k=c;do{p=k;k=k+1|0}while((LMc(a,k)|0)==(k|0)|(p|0)==(g|0));if(k>>>0<=(dMc(a)|0)>>>0?(h=MMc(a,k,j,i)|0,p=(h|0)==0,m=p&(b[j>>0]|0)==4&(f[i>>2]|0)==(c|0),m|p^1):0){a=m?101:h;g=m?k:0;c=0;break}else{n=7;break}}else n=7;while(0);if((n|0)==7){a=NMc(a,c,l,(d|0)==0?2:0)|0;c=f[l>>2]|0;if(!a){a=0;g=NJc(f[c+56>>2]|0)|0}else g=0}f[e>>2]=g;if(!d){OMc(c);p=(a|0)==101;p=p?0:a;t=o;return p|0}else{f[d>>2]=c;p=(a|0)==101;p=p?0:a;t=o;return p|0}return 0}function LMc(a,b){a=a|0;b=b|0;if(b>>>0<2){b=0;return b|0}b=b+-2|0;b=b-((b>>>0)%(((((f[a+40>>2]|0)>>>0)/5|0)+1|0)>>>0)|0)|0;b=((b+1|0)==(((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0|0)?3:2)+b|0;return b|0}function MMc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;g=k;j=LMc(a,c)|0;a=GKc(f[a>>2]|0,j,g,0)|0;if(a|0){e=a;t=k;return e|0}i=f[g>>2]|0;h=$Lc(i)|0;a=(c-j|0)*5|0;g=a+-5|0;if((g|0)<0){cMc(i);e=YJc(66030)|0;t=k;return e|0}b[d>>0]=b[h+g>>0]|0;if(e|0){j=NJc(h+(a+-4)|0)|0;f[e>>2]=j}cMc(i);if(((b[d>>0]|0)+-1&255)<=4){e=0;t=k;return e|0}e=YJc(66038)|0;t=k;return e|0}function NMc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=t;t=t+16|0;e=g;d=GKc(f[a>>2]|0,b,e,d)|0;if(d|0){e=d;t=g;return e|0}e=PMc(f[e>>2]|0,b,a)|0;f[c>>2]=e;e=0;t=g;return e|0}function OMc(a){a=a|0;if(!a)return;CMc(a);return}function PMc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=aMc(a)|0;g=e+4|0;if((f[g>>2]|0)==(c|0))return e|0;h=$Lc(a)|0;f[e+56>>2]=h;f[e+72>>2]=a;f[e+52>>2]=d;f[g>>2]=c;b[e+9>>0]=(c|0)==1?100:0;return e|0}function QMc(a,b,c){a=a|0;b=b|0;c=c|0;b=(f[a+64>>2]|0)+(b<<1)|0;Kd[f[a+80>>2]&255](a,(f[a+56>>2]|0)+(((h[b>>0]|0)<<8|(h[b+1>>0]|0))&(j[a+26>>1]|0))|0,c);return}function RMc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;g=a+380|0;h=f[g>>2]|0;f[g>>2]=0;d=a+356|0;c=0;a=0;while(1){if(a|0){c=8;break}if((c|0)>=(f[d>>2]|0)){a=0;c=8;break}a=f[(f[h+(c<<2)>>2]|0)+8>>2]|0;if((a|0)!=0?(e=f[(f[a>>2]|0)+60>>2]|0,(e|0)!=0):0){i=sd[e&2047](a)|0;pOc(b,a);a=i}else a=0;c=c+1|0}if((c|0)==8){f[g>>2]=h;return a|0}return 0}function SMc(a){a=a|0;return h[a+5>>0]|0|0}function TMc(a){a=a|0;var b=0;b=f[a+40>>2]|0;if(b|0)return b|0;if(f[a+216>>2]|0){b=0;return b|0}b=mOc(a,4)|0;return b|0}function UMc(a){a=a|0;return lOc(f[f[a+4>>2]>>2]|0,1)|0}function VMc(a,c){a=a|0;c=c|0;var d=0,e=0;if((b[a+8>>0]|0)!=2){e=0;return e|0}e=f[a+4>>2]|0;Fzc(a);if(b[e+17>>0]|0?(d=kNc(e)|0,d|0):0){Bzc(a);e=d;return e|0}if(b[e+19>>0]|0)lNc(f[e>>2]|0,f[e+48>>2]|0);e=mNc(f[e>>2]|0,c,0)|0;Bzc(a);return e|0}function WMc(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+8|0;if(!(b[d>>0]|0)){c=0;return c|0}Fzc(a);do if((b[d>>0]|0)==2){e=f[a+4>>2]|0;d=cNc(f[e>>2]|0)|0;if(!((c|0)==0&(d|0)!=0)){c=a+20|0;f[c>>2]=(f[c>>2]|0)+-1;b[e+20>>0]=1;dNc(e);break}Bzc(a);c=d;return c|0}while(0);eNc(a);Bzc(a);c=0;return c|0}function XMc(a){a=a|0;bNc(a,64);return}function YMc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;f[e>>2]=c;c=FIc(a,b,e)|0;t=d;return c|0}function ZMc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=f[a+4>>2]|0;g=DCc(g,((g|0)<0)<<31>>31)|0;if(!g){g=7;return g|0}a=uKc(a,b,g,d,e)|0;if(!a){f[c>>2]=g;g=0;return g|0}else{qxc(g);g=a;return g|0}return 0}function _Mc(a){a=a|0;return aNc(f[f[a+4>>2]>>2]|0)|0}function $Mc(a){a=a|0;DKc(a);qxc(a);return}function aNc(a){a=a|0;return f[a+172>>2]|0}function bNc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;c=a+380|0;i=f[c>>2]|0;if(!i)return;f[c>>2]=0;e=a+356|0;c=0;while(1){if((c|0)>=(f[e>>2]|0))break;g=f[i+(c<<2)>>2]|0;d=f[g+8>>2]|0;if(d|0?(h=f[(f[d>>2]|0)+b>>2]|0,h|0):0)sd[h&2047](d)|0;f[g+20>>2]=0;Tyc(g);c=c+1|0}nxc(a,i);f[e>>2]=0;return}function cNc(a){a=a|0;var c=0;c=f[a+40>>2]|0;if(c|0){a=c;return a|0}c=a+100|0;f[c>>2]=(f[c>>2]|0)+1;c=a+16|0;if(((b[c>>0]|0)==2?b[a+4>>0]|0:0)?(b[a+5>>0]|0)==1:0){b[c>>0]=1;a=0;return a|0}a=FLc(a,dLc(a,h[a+19>>0]|0,1)|0)|0;return a|0}function dNc(a){a=a|0;a=a+64|0;rKc(f[a>>2]|0);f[a>>2]=0;return}function eNc(a){a=a|0;var c=0,d=0,e=0;c=f[a+4>>2]|0;d=f[a>>2]|0;b[c+19>>0]=0;e=a+8|0;do if(b[e>>0]|0)if((f[d+180>>2]|0)>1){fNc(a);b[e>>0]=1;return}else{gNc(a);a=c+44|0;d=(f[a>>2]|0)+-1|0;f[a>>2]=d;if(d|0)break;b[c+20>>0]=0;break}while(0);b[e>>0]=0;hNc(c);return}function fNc(a){a=a|0;var c=0,e=0;c=f[a+4>>2]|0;e=c+80|0;if((f[e>>2]|0)!=(a|0))return;f[e>>2]=0;a=c+24|0;d[a>>1]=d[a>>1]&-193;a=c+76|0;while(1){a=f[a>>2]|0;if(!a)break;b[a+8>>0]=1;a=a+12|0}return}function gNc(a){a=a|0;var b=0,c=0,e=0,g=0;g=f[a+4>>2]|0;b=g+76|0;a:while(1){while(1){c=f[b>>2]|0;if(!c)break a;e=c+12|0;if((f[c>>2]|0)!=(a|0))break;f[b>>2]=f[e>>2];if((f[c+4>>2]|0)!=1)qxc(c)}b=e}b=g+80|0;if((f[b>>2]|0)!=(a|0))if((f[g+44>>2]|0)==2)b=-129;else return;else{f[b>>2]=0;b=-193}g=g+24|0;d[g>>1]=d[g>>1]&b;return}function hNc(a){a=a|0;var c=0;if(b[a+20>>0]|0)return;a=a+12|0;c=f[a>>2]|0;if(!c)return;f[a>>2]=0;iNc(c);return}function iNc(a){a=a|0;jNc(f[a+72>>2]|0);return}function jNc(a){a=a|0;var b=0;b=f[a+20>>2]|0;NKc(a);$Kc(b);return}function kNc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;j=f[a>>2]|0;UNc(a);if(b[a+18>>0]|0){j=0;return j|0}d=dMc(a)|0;if((LMc(a,d)|0)!=(d|0)?(d|0)!=((((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0)+1|0):0){g=a+12|0;h=NJc((f[(f[g>>2]|0)+56>>2]|0)+36|0)|0;i=VNc(a,d,h)|0;if(i>>>0>d>>>0){j=YJc(68931)|0;return j|0}if(i>>>0<d>>>0)c=JJc(a,0,0)|0;else c=0;while(1){e=(c|0)==0;if(!(e&d>>>0>i>>>0))break;c=WNc(a,i,d,1)|0;d=d+-1|0}if((h|0)!=0&((c|0)==101|e)){c=PJc(f[(f[g>>2]|0)+72>>2]|0)|0;RJc((f[(f[g>>2]|0)+56>>2]|0)+32|0,0);RJc((f[(f[g>>2]|0)+56>>2]|0)+36|0,0);RJc((f[(f[g>>2]|0)+56>>2]|0)+28|0,i);b[a+19>>0]=1;f[a+48>>2]=i}if(!c){j=0;return j|0}cLc(j)|0;j=c;return j|0}j=YJc(68926)|0;return j|0}function lNc(a,b){a=a|0;b=b|0;f[a+24>>2]=b;return}function mNc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;j=n;e=f[a+40>>2]|0;if(e|0){m=e;t=n;return m|0}if(nMc(400)|0){m=10;t=n;return m|0}m=a+16|0;if((h[m>>0]|0)<3){m=0;t=n;return m|0}do if(vLc(a,1)|0){e=a+216|0;if(!(f[e>>2]|0)){g=oNc(a)|0;if(g|0){m=g;t=n;return m|0}g=pNc(a,c)|0;if(g|0){m=g;t=n;return m|0}g=qNc(a,0)|0;if(g|0){m=g;t=n;return m|0}g=a+212|0;i=rNc(a,sMc(f[g>>2]|0)|0)|0;if(i|0){m=i;t=n;return m|0}wLc(f[g>>2]|0);g=f[a+24>>2]|0;if(g>>>0>(f[a+32>>2]|0)>>>0?(k=yLc(a,g-((g|0)==(((f[19118]|0)/(f[a+152>>2]|0)|0)+1|0)&1)|0)|0,k|0):0){m=k;t=n;return m|0}if(d|0)break;g=LLc(a,c)|0}else{f[j>>2]=0;c=a+212|0;g=sMc(f[c>>2]|0)|0;if(!g){g=GKc(a,1,j,0)|0;i=f[j>>2]|0;f[i+16>>2]=0;if(!i)i=0;else{g=i;l=9}}else l=9;if((l|0)==9){g=nNc(a,g,f[a+24>>2]|0,1)|0;i=f[j>>2]|0}cMc(i);if(!g)wLc(f[c>>2]|0)}if(g){m=g;t=n;return m|0}}else{jLc(f[a+88>>2]|0);e=a+216|0}while(0);if(f[e>>2]|0){m=0;t=n;return m|0}b[m>>0]=5;m=0;t=n;return m|0}function nNc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0,l=0;j=t;t=t+16|0;i=j;f[i>>2]=b;if(!d)e=1;else{g=i;e=0;while(1){f[g>>2]=b;if(!b)break;k=(f[b+24>>2]|0)>>>0>c>>>0;l=b+16|0;g=k?g:l;b=f[l>>2]|0;e=e+((k^1)&1)|0}b=f[i>>2]|0}l=a+192|0;f[l>>2]=(f[l>>2]|0)+e;if((f[b+24>>2]|0)==1)uNc(b);g=wNc(f[a+216>>2]|0,f[a+152>>2]|0,b,c,d,h[a+11>>0]|0)|0;if(g|0){t=j;return g|0}e=a+88|0;if(!(f[e>>2]|0)){t=j;return g|0}while(1){if(!b)break;VLc(f[e>>2]|0,f[b+24>>2]|0,f[b+4>>2]|0);b=f[b+16>>2]|0}t=j;return g|0}function oNc(a){a=a|0;var c=0,d=0,e=0;e=t;t=t+16|0;d=e;c=a+18|0;if(b[c>>0]|0){d=0;t=e;return d|0}if(!(f[a+24>>2]|0)){d=0;t=e;return d|0}a=GKc(a,1,d,0)|0;if(!a){a=PJc(f[d>>2]|0)|0;if(!a){uNc(f[d>>2]|0);b[c>>0]=1;a=0}}cMc(f[d>>2]|0);d=a;t=e;return d|0}function pNc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;l=n;if(!c){m=0;t=n;return m|0}if((b[a+5>>0]|0)==4){m=0;t=n;return m|0}m=a+64|0;h=f[m>>2]|0;if(!(f[h>>2]|0)){m=0;t=n;return m|0}b[a+19>>0]=1;i=0;j=0;while(1){d=b[c+j>>0]|0;if(!(d<<24>>24))break;i=i+(d<<24>>24)|0;j=j+1|0}if(!(b[a+8>>0]|0))k=a+72|0;else{e=sKc(a)|0;k=a+72|0;g=k;f[g>>2]=e;f[g+4>>2]=G}g=k;e=f[g>>2]|0;g=f[g+4>>2]|0;d=hKc(h,e,g,((f[19118]|0)/(f[a+152>>2]|0)|0)+1|0)|0;if(d|0){m=d;t=n;return m|0}d=f[m>>2]|0;a=vrd(e|0,g|0,4,0)|0;e=G;d=iKc(d,c,j,a,e)|0;if(d|0){m=d;t=n;return m|0}d=f[m>>2]|0;a=vrd(a|0,e|0,j|0,0)|0;e=G;d=hKc(d,a,e,j)|0;if(d|0){m=d;t=n;return m|0}c=f[m>>2]|0;d=vrd(a|0,e|0,4,0)|0;d=hKc(c,d,G,i)|0;if(d|0){m=d;t=n;return m|0}i=f[m>>2]|0;d=vrd(a|0,e|0,8,0)|0;d=iKc(i,121039,8,d,G)|0;if(d|0){m=d;t=n;return m|0}d=k;j=vrd(f[d>>2]|0,f[d+4>>2]|0,j+20|0,0)|0;d=k;f[d>>2]=j;f[d+4>>2]=G;d=BLc(f[m>>2]|0,l)|0;if(d|0){m=d;t=n;return m|0}j=f[l+4>>2]|0;a=k;d=f[a>>2]|0;a=f[a+4>>2]|0;if(!((j|0)>(a|0)|((j|0)==(a|0)?(f[l>>2]|0)>>>0>d>>>0:0))){m=0;t=n;return m|0}m=TKc(f[m>>2]|0,d,a)|0;t=n;return m|0}function qNc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=t;t=t+32|0;i=p+16|0;k=p;d=TMc(a)|0;if(d|0){a=d;t=p;return a|0}do if(!(b[a+7>>0]|0)){n=a+64|0;if(f[f[n>>2]>>2]|0?(b[a+5>>0]|0)!=4:0){j=tKc(f[a+60>>2]|0)|0;m=(j&512|0)==0;a:do if(m){e=k;f[e>>2]=-117058087;f[e+4>>2]=-681336544;RJc(k+8|0,f[a+44>>2]|0);e=sKc(a)|0;g=G;d=QLc(f[n>>2]|0,i,8,e,g)|0;if(!d)if(!(ocd(i,121039,8)|0)){d=iKc(f[n>>2]|0,155356,1,e,g)|0;e=10}else e=11;else e=10;if((e|0)==10)switch(d|0){case 0:case 522:{e=11;break}default:{}}do if((e|0)==11){e=j&1024;if((e|0)==0&(b[a+8>>0]|0)!=0?(l=sLc(f[n>>2]|0,h[a+10>>0]|0)|0,l|0):0){d=l;break}d=a+80|0;d=iKc(f[n>>2]|0,k,12,f[d>>2]|0,f[d+4>>2]|0)|0;if(!d){d=e;break a}}while(0);a=d;t=p;return a|0}else d=j&1024;while(0);if((d|0)==0?(o=b[a+10>>0]|0,o=sLc(f[n>>2]|0,(o<<24>>24==3?16:0)|o&255)|0,o|0):0){a=o;t=p;return a|0}l=a+72|0;n=f[l+4>>2]|0;o=a+80|0;f[o>>2]=f[l>>2];f[o+4>>2]=n;if((c|0)==0|m^1)break;f[a+44>>2]=0;d=qKc(a)|0;if(!d)break;t=p;return d|0}n=a+72|0;c=f[n+4>>2]|0;o=a+80|0;f[o>>2]=f[n>>2];f[o+4>>2]=c}while(0);vNc(f[a+212>>2]|0);b[a+16>>0]=4;a=0;t=p;return a|0}function rNc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=t;t=t+16|0;j=s;r=a+60|0;e=f[r>>2]|0;if((f[e>>2]|0)==0?(g=sNc(a,e,f[a+144>>2]|0)|0,(g|0)!=0):0)i=a+24|0;else h=4;do if((h|0)==4){e=a+36|0;g=f[e>>2]|0;i=a+24|0;h=f[i>>2]|0;if(g>>>0<h>>>0){if((f[c+16>>2]|0)==0?(f[c+24>>2]|0)>>>0<=g>>>0:0){g=0;break}q=f[a+152>>2]|0;q=Brd(q|0,((q|0)<0)<<31>>31|0,h|0,0)|0;g=j;f[g>>2]=q;f[g+4>>2]=G;tNc(f[r>>2]|0,5,j);f[e>>2]=f[i>>2];g=0}else g=0}while(0);n=a+152|0;o=a+104|0;p=a+32|0;q=a+192|0;m=a+88|0;while(1){if(!((g|0)==0&(c|0)!=0))break;l=f[c+24>>2]|0;if(l>>>0<=(f[i>>2]|0)>>>0?(d[c+28>>1]&16)==0:0){e=f[n>>2]|0;g=Brd(e|0,((e|0)<0)<<31>>31|0,l+-1|0,0)|0;h=G;j=(l|0)==1;if(j){uNc(c);e=f[n>>2]|0}k=c+4|0;a=f[k>>2]|0;g=iKc(f[r>>2]|0,a,e,g,h)|0;if(j){j=o;e=a+24|0;h=j+16|0;do{b[j>>0]=b[e>>0]|0;j=j+1|0;e=e+1|0}while((j|0)<(h|0))}if(l>>>0>(f[p>>2]|0)>>>0)f[p>>2]=l;f[q>>2]=(f[q>>2]|0)+1;VLc(f[m>>2]|0,l,f[k>>2]|0)}else g=0;c=f[c+16>>2]|0}t=s;return g|0}function sNc(a,b,c){a=a|0;b=b|0;c=c|0;return uKc(f[a>>2]|0,0,b,c|30,0)|0}function tNc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a>>2]|0;if(!d)return;vd[f[d+40>>2]&255](a,b,c)|0;return}function uNc(a){a=a|0;var b=0;b=(NJc((f[a+20>>2]|0)+104|0)|0)+1|0;a=a+4|0;RJc((f[a>>2]|0)+24|0,b);RJc((f[a>>2]|0)+92|0,b);RJc((f[a>>2]|0)+96|0,3035003);return}function vNc(a){a=a|0;var b=0,c=0;b=a;while(1){b=f[b>>2]|0;if(!b)break;c=b+28|0;d[c>>1]=d[c>>1]&-9;b=b+32|0}f[a+8>>2]=f[a+4>>2];return}function wNc(a,c,e,g,h,i){a=a|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;X=t;t=t+64|0;P=X+32|0;H=X;k=X+56|0;j=xMc(a)|0;if(!(ocd(a+52|0,j,48)|0))A=0;else A=(f[j+16>>2]|0)+1|0;j=xNc(a)|0;if(j|0){g=j;t=X;return g|0}W=a+68|0;m=f[W>>2]|0;a:do if(!m){RJc(H,931071618);RJc(H+4|0,3007e3);RJc(H+8|0,c);R=a+112|0;RJc(H+12|0,f[R>>2]|0);j=a+84|0;if(!(f[R>>2]|0))$Ac(8,j);N=j;R=f[N+4>>2]|0;j=H+16|0;f[j>>2]=f[N>>2];f[j+4>>2]=R;yNc(1,H,24,0,k);j=f[k>>2]|0;RJc(H+24|0,j);k=f[k+4>>2]|0;RJc(H+28|0,k);f[a+36>>2]=c;b[a+65>>0]=0;f[a+76>>2]=j;f[a+80>>2]=k;b[a+47>>0]=1;k=a+8|0;j=iKc(f[k>>2]|0,H,32,0,0)|0;do if(!j){if(b[a+48>>0]|0?(l=sLc(f[k>>2]|0,i>>>2&3)|0,l|0):0){j=l;break}s=k;break a}while(0);g=j;t=X;return g|0}else s=a+8|0;while(0);f[P>>2]=a;J=f[s>>2]|0;f[P+4>>2]=J;z=P+8|0;M=z;f[M>>2]=0;f[M+4>>2]=0;f[P+16>>2]=i;f[P+20>>2]=c;M=c+24|0;N=((M|0)<0)<<31>>31;k=Brd(m|0,0,M|0,N|0)|0;k=vrd(k|0,G|0,32,0)|0;p=(A|0)==0;q=(h|0)==0;r=a+104|0;L=m;o=e;R=0;m=G;b:while(1){if(!o){K=31;break}do if(p)K=24;else{l=o+16|0;if(!(q|(f[l>>2]|0)!=0)){C=0;E=L+1|0;K=26;break}f[H>>2]=0;eMc(a,f[o+24>>2]|0,H)|0;n=f[H>>2]|0;if(n>>>0<A>>>0){K=24;break}j=Brd(n+-1|0,0,M|0,N|0)|0;j=vrd(j|0,G|0,56,0)|0;if(((f[r>>2]|0)+-1|0)>>>0>=n>>>0)f[r>>2]=n;B=iKc(f[s>>2]|0,f[o+4>>2]|0,c,j,G)|0;if(B|0){K=22;break b}u=o+28|0;d[u>>1]=d[u>>1]&-65;u=L;v=R;w=l;x=k;y=m}while(0);if((K|0)==24){j=L+1|0;if(q){D=0;F=j;K=27}else{C=f[o+16>>2]|0;E=j;K=26}}if((K|0)==26){D=(C|0)==0?g:0;F=E;K=27}if((K|0)==27){K=0;j=zNc(P,o,D,k,m)|0;l=o+28|0;if(j|0){O=j;K=56;break}x=vrd(k|0,m|0,M|0,N|0)|0;d[l>>1]=d[l>>1]|64;u=F;v=o;w=o+16|0;y=G}L=u;o=f[w>>2]|0;R=v;k=x;m=y}if((K|0)==22){g=B;t=X;return g|0}else if((K|0)==31){u=(h|0)!=0;if(u){if(f[r>>2]|0?(I=ANc(a,L)|0,I|0):0){g=I;t=X;return g|0}q=i&3;c:do if(!q){k=0;j=0}else{do if(b[a+49>>0]|0){j=OLc(f[s>>2]|0)|0;n=((j|0)<0)<<31>>31;p=vrd(k|0,m|0,-1,-1)|0;p=vrd(p|0,G|0,j|0,n|0)|0;o=G;n=Crd(p|0,o|0,j|0,n|0)|0;n=wrd(p|0,o|0,n|0,G|0)|0;o=G;p=z;f[p>>2]=n;f[p+4>>2]=o;p=(n|0)==(k|0)&(o|0)==(m|0);j=0;while(1){if(!((m|0)<(o|0)|(m|0)==(o|0)&k>>>0<n>>>0)){K=40;break}l=zNc(P,R,g,k,m)|0;if(l|0){O=l;K=56;break}K=vrd(k|0,m|0,M|0,N|0)|0;j=j+1|0;m=G;k=K}if((K|0)==40)if(p){Q=j;break}else{k=0;break c}else if((K|0)==56){t=X;return O|0}}else Q=0;while(0);k=sLc(J,q)|0;j=Q}while(0);l=a+47|0;if((b[l>>0]|0)!=0?(T=a+16|0,S=f[T>>2]|0,T=f[T+4>>2]|0,U=Brd(j+L|0,0,M|0,N|0)|0,U=vrd(U|0,G|0,32,0)|0,V=G,(T|0)>-1|(T|0)==-1&S>>>0>4294967295):0){Q=(V|0)>(T|0)|(V|0)==(T|0)&U>>>0>S>>>0;BNc(a,Q?U:S,Q?V:T);b[l>>0]=0}}else{k=0;j=0}l=f[W>>2]|0;while(1){if(!((e|0)!=0&(k|0)==0))break;m=l+1|0;if(!(d[e+28>>1]&64))k=0;else{k=CNc(a,m,f[e+24>>2]|0)|0;l=m}e=f[e+16>>2]|0}e=R+24|0;m=k;while(1){k=(m|0)==0;if(!((j|0)>0&k))break;V=l+1|0;m=CNc(a,V,f[e>>2]|0)|0;l=V;j=j+-1|0}if(!k){g=m;t=X;return g|0}d[a+66>>1]=c&65280|c>>>16;f[W>>2]=l;if(!u){g=0;t=X;return g|0}c=a+60|0;f[c>>2]=(f[c>>2]|0)+1;f[a+72>>2]=g;DNc(a);f[a+12>>2]=l;g=0;t=X;return g|0}else if((K|0)==56){t=X;return O|0}return 0}function xNc(a){a=a|0;var b=0,c=0,e=0,g=0;g=t;t=t+16|0;e=g;b=a+40|0;if(d[b>>1]|0){e=0;t=g;return e|0}c=INc(a)|0;if(f[c>>2]|0){$Ac(4,e);c=JNc(a,4,4)|0;switch(c|0){case 0:{KNc(a,f[e>>2]|0);rLc(a,4,4);break}case 5:break;default:{e=c;t=g;return e|0}}}pLc(a,3);d[b>>1]=-1;c=0;do{c=c+1|0;b=LNc(a,e,1,c)|0}while((b|0)==-1);t=g;return b|0}function yNc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;h=b+c|0;if(!d){g=0;c=0}else{g=f[d>>2]|0;c=f[d+4>>2]|0}if(!a){do{g=g+c+(Ird(f[b>>2]|0)|0)|0;c=(Ird(f[b+4>>2]|0)|0)+c+g|0;b=b+8|0}while(b>>>0<h>>>0);f[e>>2]=g;e=e+4|0;f[e>>2]=c;return}else{do{g=g+c+(f[b>>2]|0)|0;c=(f[b+4>>2]|0)+c+g|0;b=b+8|0}while(b>>>0<h>>>0);f[e>>2]=g;e=e+4|0;f[e>>2]=c;return}}function zNc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0;h=t;t=t+32|0;i=h;g=f[b+4>>2]|0;GNc(f[a>>2]|0,f[b+24>>2]|0,c,g,i);b=HNc(a,i,24,d,e)|0;if(b|0){i=b;t=h;return i|0}i=vrd(d|0,e|0,24,0)|0;i=HNc(a,g,f[a+20>>2]|0,i,G)|0;t=h;return i|0}function ANc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+32|0;i=o;m=(f[a+36>>2]|0)+24|0;n=Vzc(m)|0;if(!n){n=7;t=o;return n|0}l=a+104|0;k=f[l>>2]|0;c=(k|0)==1;h=((m|0)<0)<<31>>31;k=Brd(k+-2|0,0,m|0,h|0)|0;k=vrd(k|0,G|0,48,0)|0;j=a+8|0;c=QLc(f[j>>2]|0,n,8,c?24:k,c?0:G)|0;k=NJc(n)|0;f[a+76>>2]=k;k=n+4|0;g=NJc(k)|0;f[a+80>>2]=g;g=f[l>>2]|0;f[l>>2]=0;l=n+24|0;while(1){if(g>>>0>b>>>0|(c|0)!=0)break;d=Brd(g+-1|0,0,m|0,h|0)|0;d=vrd(d|0,G|0,32,0)|0;e=G;c=QLc(f[j>>2]|0,n,m,d,e)|0;if(!c){c=NJc(n)|0;GNc(a,c,NJc(k)|0,l,i);c=iKc(f[j>>2]|0,i,24,d,e)|0}g=g+1|0}qxc(n);n=c;t=o;return n|0}function BNc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;h=t;t=t+16|0;g=h+8|0;i=h;tzc();e=a+8|0;d=BLc(f[e>>2]|0,i)|0;j=f[i+4>>2]|0;if((d|0)==0&((j|0)>(c|0)|((j|0)==(c|0)?(f[i>>2]|0)>>>0>b>>>0:0)))d=TKc(f[e>>2]|0,b,c)|0;uzc();if(!d){t=h;return}f[g>>2]=f[a+108>>2];dxc(d,121101,g);t=h;return}function CNc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;g=j;e=hMc(a,gMc(b)|0,g)|0;if(e|0){c=e;t=j;return c|0}i=b-(f[g+8>>2]|0)|0;if((i|0)==1){b=f[g+4>>2]|0;h=b+4|0;Mrd(h|0,0,(f[g>>2]|0)+16384-h|0)|0}else b=f[g+4>>2]|0;h=b+(i<<2)|0;if(f[h>>2]|0)qMc(a);e=iMc(c)|0;a=f[g>>2]|0;b=i;while(1){g=a+(e<<1)|0;if(!(d[g>>1]|0)){b=11;break}if(!b){b=12;break}b=b+-1|0;e=jMc(e)|0}if((b|0)==11){f[h>>2]=c;d[g>>1]=i;c=0;t=j;return c|0}else if((b|0)==12){c=YJc(60956)|0;t=j;return c|0}return 0}function DNc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;c=xMc(a)|0;d=a+52|0;b[a+64>>0]=1;f[d>>2]=3007e3;yNc(1,d,40,0,a+92|0);e=c+48|0;g=d;h=e+48|0;do{b[e>>0]=b[g>>0]|0;e=e+1|0;g=g+1|0}while((e|0)<(h|0));ENc(a);e=c;g=d;h=e+48|0;do{b[e>>0]=b[g>>0]|0;e=e+1|0;g=g+1|0}while((e|0)<(h|0));return}function ENc(a){a=a|0;if((b[a+43>>0]|0)==2)return;FNc(f[a+4>>2]|0);return}function FNc(a){a=a|0;Hd[f[(f[a>>2]|0)+60>>2]&1023](a);return}function GNc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0;i=a+76|0;RJc(g,c);RJc(g+4|0,d);c=g+8|0;if(!(f[a+104>>2]|0)){j=a+84|0;k=j;k=h[k>>0]|h[k+1>>0]<<8|h[k+2>>0]<<16|h[k+3>>0]<<24;j=j+4|0;j=h[j>>0]|h[j+1>>0]<<8|h[j+2>>0]<<16|h[j+3>>0]<<24;d=c;c=d;b[c>>0]=k;b[c+1>>0]=k>>8;b[c+2>>0]=k>>16;b[c+3>>0]=k>>24;d=d+4|0;b[d>>0]=j;b[d+1>>0]=j>>8;b[d+2>>0]=j>>16;b[d+3>>0]=j>>24;d=(b[a+65>>0]|0)==0&1;yNc(d,g,8,i,i);yNc(d,e,f[a+36>>2]|0,i,i);RJc(g+16|0,f[i>>2]|0);RJc(g+20|0,f[a+80>>2]|0);return}else{d=c+16|0;do{b[c>>0]=0;c=c+1|0}while((c|0)<(d|0));return}}function HNc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;g=a+8|0;h=f[g>>2]|0;g=f[g+4>>2]|0;if((g|0)>(e|0)|(g|0)==(e|0)&h>>>0>d>>>0?(j=vrd(c|0,((c|0)<0)<<31>>31|0,d|0,e|0)|0,i=G,!((i|0)<(g|0)|(i|0)==(g|0)&j>>>0<h>>>0)):0){j=wrd(h|0,g|0,d|0,e|0)|0;i=a+4|0;g=iKc(f[i>>2]|0,b,j,d,e)|0;if(g|0){a=g;return a|0}d=vrd(j|0,((j|0)<0)<<31>>31|0,d|0,e|0)|0;e=G;h=c-j|0;g=sLc(f[i>>2]|0,f[a+16>>2]&3)|0;if((h|0)!=0&(g|0)==0){b=b+j|0;g=d}else{a=g;return a|0}}else{h=c;g=d}a=iKc(f[a+4>>2]|0,b,h,g,e)|0;return a|0}function INc(a){a=a|0;return (f[f[a+32>>2]>>2]|0)+96|0}function JNc(a,c,d){a=a|0;c=c|0;d=d|0;if(b[a+43>>0]|0){d=0;return d|0}d=qLc(f[a+4>>2]|0,c,d,10)|0;return d|0}function KNc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=INc(a)|0;d=a+84|0;e=a+112|0;f[e>>2]=(f[e>>2]|0)+1;f[a+68>>2]=0;RJc(d,(NJc(d)|0)+1|0);f[a+88>>2]=b;DNc(a);f[c>>2]=0;f[c+32>>2]=0;f[c+8>>2]=0;a=2;while(1){if((a|0)==5)break;f[c+4+(a<<2)>>2]=-1;a=a+1|0}return}function LNc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;do if((g|0)>5)if((g|0)>100){a=15;return a|0}else{m=g+-9|0;m=V(m*39|0,m)|0;MNc(f[a>>2]|0,(g|0)>9?m:1)|0;break}while(0);a:do if(!e){g=a+50|0;if(!(b[g>>0]|0)){e=NNc(a,c)|0;b:do if((e|0)==5){if(!(f[f[a+32>>2]>>2]|0)){a=-1;return a|0}e=ALc(a,2)|0;switch(e|0){case 0:break;case 5:{a=261;return a|0}default:break b}pLc(a,2);a=-1;return a|0}while(0);if(e|0){a=e;return a|0}if(!(b[g>>0]|0)){h=INc(a)|0;g=a+52|0;e=a+68|0;if((f[h>>2]|0)!=(f[e>>2]|0)){c=0;break}c=ALc(a,3)|0;ENc(a);switch(c|0){case 5:break a;case 0:break;default:{a=c;return a|0}}if(!(ocd(xMc(a)|0,g,48)|0)){d[a+40>>1]=0;a=0;return a|0}else{pLc(a,3);a=-1;return a|0}}}a=ONc(a,c)|0;return a|0}else{c=0;e=a+68|0;h=INc(a)|0}while(0);k=f[e>>2]|0;l=0;e=1;i=0;while(1){if((e|0)==5)break;j=f[h+4+(e<<2)>>2]|0;g=l>>>0>j>>>0|j>>>0>k>>>0;m=g?i:e;l=g?l:j;e=e+1|0;i=m}m=a+52|0;c:do if(!(b[a+46>>0]&2))if((i|0)==0|l>>>0<k>>>0){j=1;d:while(1){if(j>>>0>=5){n=29;break c}g=j+3|0;e=JNc(a,g,1)|0;switch(e|0){case 0:{n=27;break d}case 5:break;default:{n=37;break d}}j=j+1|0;c=5}if((n|0)==27){f[h+4+(j<<2)>>2]=k;rLc(a,g,1);i=j;c=k;break}else if((n|0)==37)return e|0}else c=l;else n=29;while(0);if((n|0)==29)if(!i){a=(c|0)==5?-1:1288;return a|0}else c=l;e=i+3|0;g=ALc(a,e)|0;if(g|0){a=(g|0)==5?-1:g;return a|0}f[a+100>>2]=(f[h>>2]|0)+1;ENc(a);if((f[h+4+(i<<2)>>2]|0)==(c|0)?(ocd(xMc(a)|0,m,48)|0)==0:0){d[a+40>>1]=i;a=0;return a|0}pLc(a,e);a=-1;return a|0}function MNc(a,b){a=a|0;b=b|0;return td[f[a+60>>2]&1023](a,b)|0}function NNc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;h=k;e=kMc(a,0,h)|0;switch(e|0){case 0:break;case 1288:{b[a+50>>0]=1;b[a+43>>0]=2;f[c>>2]=1;break}default:{a=e;t=k;return a|0}}if(f[h>>2]|0){g=QNc(a,c)|0;if(!g){d=e;j=17}else j=5}else{g=1;j=5}do if((j|0)==5){if((b[a+50>>0]|0)==0?b[a+46>>0]&2:0){d=ALc(a,0)|0;if(d|0)break;pLc(a,0);d=264;break}e=a+44|0;i=(b[e>>0]|0)==0;if(i?(d=JNc(a,0,1)|0,d|0):0)break;b[e>>0]=1;d=kMc(a,0,h)|0;if(!d){d=QNc(a,c)|0;if(!d){g=0;d=0}else{h=RNc(a)|0;f[c>>2]=1;g=d;d=h}}if(i){b[e>>0]=0;rLc(a,0,1)}if(!g)j=17}while(0);if((j|0)==17)if((f[a+52>>2]|0)!=3007e3)d=QAc(62223)|0;e=a+50|0;if(!(b[e>>0]|0)){a=d;t=k;return a|0}if(!d)d=0;else{SNc(a,0);b[e>>0]=0;d=(d|0)==522?-1:d}b[a+43>>0]=0;a=d;t=k;return a|0}function ONc(a,c){a=a|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;y=t;t=t+64|0;u=y+32|0;i=y;v=y+44|0;w=y+40|0;e=ALc(a,3)|0;a:do switch(e|0){case 0:{d[a+40>>1]=0;e=mMc(f[a+4>>2]|0,0,0,y+48|0)|0;switch(e|0){case 8:{e=-1;x=16;break a}case 1288:break;default:{g=0;x=17;break a}}e=a+52|0;g=xMc(a)|0;h=e+48|0;do{b[e>>0]=b[g>>0]|0;e=e+1|0;g=g+1|0}while((e|0)<(h|0));s=a+8|0;e=BLc(f[s>>2]|0,u)|0;if(!e){r=u;q=f[r+4>>2]|0;if((q|0)<0|(q|0)==0&(f[r>>2]|0)>>>0<32){f[c>>2]=1;g=0;e=((f[a+68>>2]|0)!=0)<<31>>31;x=17;break a}e=QLc(f[s>>2]|0,i,32,0,0)|0;if(!e)if(!(ocd(a+84|0,i+16|0,8)|0)){e=a+66|0;m=(j[e>>1]|0)+24|0;g=XAc(m,0)|0;if(!g){e=7;x=16}else{n=g+24|0;o=a+76|0;p=f[o>>2]|0;q=a+80|0;r=f[q>>2]|0;k=Brd((j[e>>1]|0)+24|0,0,f[a+68>>2]|0,0)|0;k=vrd(k|0,G|0,32,0)|0;e=0;l=G;do{h=k;k=vrd(k|0,l|0,m|0,0)|0;i=l;l=G;z=u;A=f[z+4>>2]|0;if((l|0)>(A|0)|((l|0)==(A|0)?k>>>0>(f[z>>2]|0)>>>0:0))break;e=QLc(f[s>>2]|0,g,m,h,i)|0;if(e|0){x=13;break}if(!(PNc(a,v,w,n,g)|0)){e=0;x=13;break}A=(f[w>>2]|0)==0;e=(A^1)<<31>>31}while(A);f[o>>2]=p;f[q>>2]=r;x=17}}else{e=-1;x=16}else x=16}else x=16;break}case 5:{e=-1;x=16;break}default:{g=0;x=17}}while(0);if((x|0)==16)qxc(0);else if((x|0)==17){qxc(g);if(!e){A=0;t=y;return A|0}}h=a+24|0;i=a+32|0;g=0;while(1){if((g|0)>=(f[h>>2]|0))break;qxc(f[(f[i>>2]|0)+(g<<2)>>2]|0);f[(f[i>>2]|0)+(g<<2)>>2]=0;g=g+1|0}b[a+50>>0]=0;gLc(a);f[c>>2]=1;A=e;t=y;return A|0}function PNc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;i=a+76|0;if(ocd(a+84|0,g+8|0,8)|0){i=0;return i|0}h=NJc(g)|0;if(!h){i=0;return i|0}j=(b[a+65>>0]|0)==0&1;yNc(j,g,8,i,i);yNc(j,e,f[a+36>>2]|0,i,i);i=f[i>>2]|0;if((i|0)!=(NJc(g+16|0)|0)){j=0;return j|0}j=f[a+80>>2]|0;if((j|0)!=(NJc(g+20|0)|0)){j=0;return j|0}f[c>>2]=h;j=NJc(g+4|0)|0;f[d>>2]=j;j=1;return j|0}function QNc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0;m=t;t=t+112|0;e=m+96|0;l=m+48|0;g=m;h=xMc(a)|0;d=l;i=h;k=d+48|0;do{b[d>>0]=b[i>>0]|0;d=d+1|0;i=i+1|0}while((d|0)<(k|0));ENc(a);d=g;i=h+48|0;k=d+48|0;do{b[d>>0]=b[i>>0]|0;d=d+1|0;i=i+1|0}while((d|0)<(k|0));if(ocd(l,g,48)|0){l=1;t=m;return l|0}if(!(b[l+12>>0]|0)){l=1;t=m;return l|0}yNc(1,l,40,0,e);if((f[e>>2]|0)!=(f[l+40>>2]|0)){l=1;t=m;return l|0}if((f[e+4>>2]|0)!=(f[l+44>>2]|0)){l=1;t=m;return l|0}d=a+52|0;if(!(ocd(d,l,48)|0)){l=0;t=m;return l|0}f[c>>2]=1;i=l;k=d+48|0;do{f[d>>2]=f[i>>2];d=d+4|0;i=i+4|0}while((d|0)<(k|0));l=j[a+66>>1]|0;f[a+36>>2]=l<<16&65536|l&65024;l=0;t=m;return l|0}function RNc(a){a=a|0;var c=0,e=0,g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0,K=0,L=0,M=0;L=t;t=t+64|0;I=L+40|0;i=L+32|0;g=L;A=L+56|0;B=L+52|0;C=L+48|0;J=h[a+45>>0]|0;K=J+1|0;J=2-J|0;c=JNc(a,K,J)|0;if(c|0){K=c;t=L;return K|0}c=a+52|0;e=c+48|0;do{f[c>>2]=0;c=c+4|0}while((c|0)<(e|0));z=a+8|0;c=BLc(f[z>>2]|0,i)|0;a:do if(!c){y=i;x=f[y+4>>2]|0;b:do if((x|0)>0|(x|0)==0&(f[y>>2]|0)>>>0>32){c=QLc(f[z>>2]|0,g,32,0,0)|0;do if(!c){c=NJc(g)|0;e=NJc(g+8|0)|0;if((((c&-2|0)==931071618?!((e+-512|0)>>>0>65024|(e+-1&e|0)!=0):0)?(y=c&1,b[a+65>>0]=y,f[a+36>>2]=e,w=NJc(g+12|0)|0,f[a+112>>2]=w,w=g+16|0,x=f[w+4>>2]|0,D=a+84|0,f[D>>2]=f[w>>2],f[D+4>>2]=x,D=a+76|0,yNc(y^1,g,24,0,D),y=f[D>>2]|0,(y|0)==(NJc(g+24|0)|0)):0)?(E=a+80|0,y=f[E>>2]|0,(y|0)==(NJc(g+28|0)|0)):0){if((NJc(g+4|0)|0)==3007e3){v=e+24|0;y=XAc(e+32792|0,0)|0;if(!y){c=7;break}w=y+24|0;x=w+e|0;p=i;p=vrd(f[p>>2]|0,f[p+4>>2]|0,-32,-1)|0;o=((v|0)<0)<<31>>31;p=zrd(p|0,G|0,v|0,o|0)|0;q=gMc(p)|0;r=a+32|0;s=a+68|0;u=a+72|0;m=(e&65280|e>>>16)&65535;n=a+66|0;c=0;l=0;e=0;g=0;while(1){if(l>>>0>q>>>0)break;i=l<<12;j=i|4062;j=j>>>0>p>>>0?p:j;k=(l|0)==0;c=kMc(a,l,A)|0;if(c|0){F=15;break}f[(f[r>>2]|0)+(l<<2)>>2]=x;c=k?0:i+-34|0;while(1){i=c+1|0;if(i>>>0>j>>>0){c=0;i=0;break}c=Brd(c|0,0,v|0,o|0)|0;c=vrd(c|0,G|0,32,0)|0;c=QLc(f[z>>2]|0,y,v,c,G)|0;if(c|0){F=23;break}if(!(PNc(a,B,C,w,y)|0)){c=0;F=23;break}c=CNc(a,i,f[B>>2]|0)|0;if(c|0){F=23;break}c=f[C>>2]|0;if(c){f[s>>2]=i;f[u>>2]=c;d[n>>1]=m;e=f[D>>2]|0;g=f[E>>2]|0}c=i}if((F|0)==23){F=0;i=1}M=f[A>>2]|0;f[(f[r>>2]|0)+(l<<2)>>2]=M;k=k?136:0;j=k>>>2;Krd(M+(j<<2)|0,x+(j<<2)|0,32768-k|0)|0;if(i)break;else l=l+1|0}qxc(y)}else{c=QAc(61089)|0;e=0;g=0}if(!c){c=g;break b}else break a}e=0;c=0;break b}while(0);break a}else{e=0;c=0}while(0);f[a+76>>2]=e;f[a+80>>2]=c;DNc(a);i=INc(a)|0;f[i>>2]=0;j=a+68|0;f[i+32>>2]=f[j>>2];f[i+4>>2]=0;k=i+8|0;g=1;c=0;while(1){if(g>>>0>=5)break;e=g+3|0;c=JNc(a,e,1)|0;switch(c|0){case 0:{if((g|0)==1?(H=f[j>>2]|0,(H|0)!=0):0)f[k>>2]=H;else f[i+4+(g<<2)>>2]=-1;rLc(a,e,1);break}case 5:break;default:break a}g=g+1|0}if(f[a+72>>2]|0){M=f[a+108>>2]|0;f[I>>2]=f[j>>2];f[I+4>>2]=M;dxc(283,121127,I)}}while(0);rLc(a,K,J);M=c;t=L;return M|0}function SNc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;e=a+43|0;if(!((b[e>>0]|0)!=2?!(b[a+50>>0]|0):0)){g=a+24|0;h=a+32|0;d=0;while(1){if((d|0)>=(f[g>>2]|0))break;qxc(f[(f[h>>2]|0)+(d<<2)>>2]|0);f[(f[h>>2]|0)+(d<<2)>>2]=0;d=d+1|0}if((b[e>>0]|0)==2)return}TNc(f[a+4>>2]|0,c);return}function TNc(a,b){a=a|0;b=b|0;td[f[(f[a>>2]|0)+64>>2]&1023](a,b)|0;return}function UNc(a){a=a|0;var c=0;a=a+8|0;while(1){a=f[a>>2]|0;if(!a)break;c=a+1|0;b[c>>0]=b[c>>0]&-5;a=a+24|0}return}function VNc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=((f[a+40>>2]|0)>>>0)/5|0;c=b-c-(((c-b+(LMc(a,b)|0)+d|0)>>>0)/(d>>>0)|0)|0;d=(((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0)+1|0;c=c+((d>>>0<b>>>0&c>>>0<d>>>0)<<31>>31)|0;while(1)if((c|0)==(d|0)|(LMc(a,c)|0)==(c|0))c=c+-1|0;else break;return c|0}function WNc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=t;t=t+32|0;h=q+16|0;l=q+12|0;m=q+8|0;p=q+4|0;n=q;a:do if((LMc(a,d)|0)!=(d|0)?((((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0)+1|0)!=(d|0):0){b:do if(NJc((f[(f[a+12>>2]|0)+56>>2]|0)+36|0)|0){g=MMc(a,d,h,l)|0;if(!g){k=b[h>>0]|0;c:do switch(k<<24>>24){case 1:{g=YJc(68763)|0;break b}case 2:{if(!e){g=XNc(a,p,m,d,1)|0;if(!g){OMc(f[p>>2]|0);break c}else break b}break}default:{g=NMc(a,d,p,0)|0;do if(!g){j=(e|0)==0;i=j?2:0;j=j?c:0;h=(e|0)!=0;do{g=XNc(a,n,m,j,i)|0;if(g|0){o=14;break}OMc(f[n>>2]|0);g=f[m>>2]|0}while(h&g>>>0>c>>>0);if((o|0)==14){OMc(f[p>>2]|0);break}p=f[p>>2]|0;g=YNc(a,p,k,f[l>>2]|0,g,e)|0;OMc(p);if(!g)break c}while(0);break b}}while(0);break a}}else g=101;while(0);a=g;t=q;return a|0}while(0);if(e|0){a=0;t=q;return a|0}h=(((f[19118]|0)>>>0)/((f[a+36>>2]|0)>>>0)|0)+1|0;g=d;do g=g+-1|0;while(!((g|0)!=(h|0)?(LMc(a,g)|0)!=(g|0):0));b[a+19>>0]=1;f[a+48>>2]=g;a=0;t=q;return a|0}function XNc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;E=t;t=t+16|0;C=E+4|0;D=E;f[C>>2]=0;m=a+12|0;k=f[m>>2]|0;A=dMc(a)|0;B=k+56|0;y=NJc((f[B>>2]|0)+36|0)|0;if(y>>>0>=A>>>0){c=YJc(70936)|0;t=E;return c|0}a:do if(!y){l=(b[a+19>>0]|0)==0&1;i=PJc(f[k+72>>2]|0)|0;if(i|0){c=i;t=E;return c|0}g=a+48|0;j=f[g>>2]|0;i=j+1|0;f[g>>2]=i;k=a+36|0;if((j|0)==(((f[19118]|0)>>>0)/((f[k>>2]|0)>>>0)|0|0)){i=j+2|0;f[g>>2]=i}do if((b[a+17>>0]|0)!=0?(LMc(a,i)|0)==(i|0):0){f[D>>2]=0;i=gOc(a,i,D,l)|0;if(!i){D=f[D>>2]|0;i=PJc(f[D+72>>2]|0)|0;OMc(D);if(!i){j=f[g>>2]|0;i=j+1|0;f[g>>2]=i;if((j|0)==(((f[19118]|0)>>>0)/((f[k>>2]|0)>>>0)|0|0)){i=j+2|0;f[g>>2]=i}break}}c=i;t=E;return c|0}while(0);RJc((f[(f[m>>2]|0)+56>>2]|0)+28|0,i);i=f[g>>2]|0;f[d>>2]=i;i=gOc(a,i,c,l)|0;if(i|0){c=i;t=E;return c|0}i=PJc(f[(f[c>>2]|0)+72>>2]|0)|0;if(!i){i=0;k=0;j=0}else{OMc(f[c>>2]|0);f[c>>2]=0;k=0;j=0}}else{b:do switch(g<<24>>24){case 1:{if(A>>>0<e>>>0)j=0;else{i=MMc(a,e,D,0)|0;if(!i){j=(b[D>>0]|0)==2&1;break b}c=i;t=E;return c|0}break}case 2:{j=1;break}default:j=0}while(0);i=PJc(f[k+72>>2]|0)|0;if(i|0){c=i;t=E;return c|0}RJc((f[B>>2]|0)+36|0,y+-1|0);v=j<<24>>24!=0;w=a+40|0;s=j<<24>>24==0;u=(e|0)==0;r=g<<24>>24==2;q=v^1;i=0;k=0;while(1){p=(k|0)!=0;if(p)g=NJc(f[k+56>>2]|0)|0;else g=NJc((f[B>>2]|0)+32|0)|0;if(g>>>0<=A>>>0){j=i+1|0;if(i>>>0>y>>>0)z=17;else{i=gOc(a,g,C,0)|0;m=j}}else{j=i;z=17}if((z|0)==17){z=0;i=YJc(70992)|0;m=j}if(i|0){z=20;break}j=f[C>>2]|0;n=f[j+56>>2]|0;o=n+4|0;x=NJc(o)|0;if(!(v|(x|0)!=0)){z=22;break}if(x>>>0>(((f[w>>2]|0)>>>2)+-2|0)>>>0){z=25;break}if(!s?(g|0)==(e|0)|r&g>>>0<e>>>0:0){z=28;break}if(x|0){c:do if(u)g=0;else{if(!r){i=hOc((NJc(n+8|0)|0)-e|0)|0;g=0;l=1;while(1){if((l|0)==(x|0))break c;F=hOc((NJc(n+((l<<2)+8)|0)|0)-e|0)|0;p=(F|0)<(i|0);i=p?F:i;g=p?l:g;l=l+1|0}}i=0;while(1){if(i>>>0>=x>>>0){g=0;break c}if((NJc(n+((i<<2)+8)|0)|0)>>>0<=e>>>0){g=i;break c}i=i+1|0}}while(0);l=n+((g<<2)+8)|0;i=NJc(l)|0;if(i>>>0>A>>>0){z=56;break}if((i|0)==(e|0)|q|r&i>>>0<e>>>0){z=58;break}}OMc(k);if(s){i=0;k=0;break a}else{i=m;k=j}}d:do if((z|0)==20){f[C>>2]=0;j=0;break a}else if((z|0)==22){i=PJc(f[j+72>>2]|0)|0;if(i|0)break a;f[d>>2]=g;i=(f[B>>2]|0)+32|0;F=f[j+56>>2]|0;F=h[F>>0]|h[F+1>>0]<<8|h[F+2>>0]<<16|h[F+3>>0]<<24;b[i>>0]=F;b[i+1>>0]=F>>8;b[i+2>>0]=F>>16;b[i+3>>0]=F>>24;f[c>>2]=j;i=k}else if((z|0)==25){i=YJc(71021)|0;break a}else if((z|0)==28){m=j+56|0;f[d>>2]=g;f[c>>2]=j;i=PJc(f[j+72>>2]|0)|0;if(i|0)break a;if(!x){if(!p){i=(f[B>>2]|0)+32|0;F=f[m>>2]|0;F=h[F>>0]|h[F+1>>0]<<8|h[F+2>>0]<<16|h[F+3>>0]<<24;b[i>>0]=F;b[i+1>>0]=F>>8;b[i+2>>0]=F>>16;b[i+3>>0]=F>>24;i=0;break}i=PJc(f[k+72>>2]|0)|0;if(i|0)break a;i=f[k+56>>2]|0;F=f[m>>2]|0;F=h[F>>0]|h[F+1>>0]<<8|h[F+2>>0]<<16|h[F+3>>0]<<24;b[i>>0]=F;b[i+1>>0]=F>>8;b[i+2>>0]=F>>16;b[i+3>>0]=F>>24;i=k;break}l=NJc((f[m>>2]|0)+8|0)|0;do if(l>>>0<=A>>>0){i=gOc(a,l,D,0)|0;if(!i){g=f[D>>2]|0;i=PJc(f[g+72>>2]|0)|0;if(i|0){OMc(g);break}c=g+56|0;F=f[c>>2]|0;a=f[m>>2]|0;a=h[a>>0]|h[a+1>>0]<<8|h[a+2>>0]<<16|h[a+3>>0]<<24;b[F>>0]=a;b[F+1>>0]=a>>8;b[F+2>>0]=a>>16;b[F+3>>0]=a>>24;F=x+-1|0;RJc((f[c>>2]|0)+4|0,F);Krd((f[c>>2]|0)+8|0,(f[m>>2]|0)+12|0,F<<2|0)|0;OMc(g);if(p){i=PJc(f[k+72>>2]|0)|0;if(i|0)break;RJc(f[k+56>>2]|0,l)}else RJc((f[B>>2]|0)+32|0,l);i=k;break d}}else i=YJc(71055)|0;while(0);break a}else if((z|0)==56){i=YJc(71120)|0;break a}else if((z|0)==58){f[d>>2]=i;i=PJc(f[j+72>>2]|0)|0;if(i|0)break a;i=x+-1|0;if(g>>>0<i>>>0){F=n+((x<<2)+4)|0;F=h[F>>0]|h[F+1>>0]<<8|h[F+2>>0]<<16|h[F+3>>0]<<24;b[l>>0]=F;b[l+1>>0]=F>>8;b[l+2>>0]=F>>16;b[l+3>>0]=F>>24}RJc(o,i);i=f[d>>2]|0;i=gOc(a,i,c,(iOc(a,i)|0)==0&1)|0;if(!i){i=PJc(f[(f[c>>2]|0)+72>>2]|0)|0;if(!i)i=0;else{OMc(f[c>>2]|0);f[c>>2]=0}}OMc(k);k=0;break a}while(0);f[C>>2]=0;OMc(i);i=0;k=0;j=0}while(0);OMc(j);OMc(k);F=i;t=E;return F|0}function YNc(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;k=n+4|0;m=n;i=b+4|0;l=f[i>>2]|0;h=f[a>>2]|0;a:do if(l>>>0>=3){h=ZNc(h,f[b+72>>2]|0,e,g)|0;f[m>>2]=h;if(!h){f[i>>2]=e;switch(c<<24>>24){case 1:case 5:{h=_Nc(b)|0;f[m>>2]=h;if(h|0)break a;if(c<<24>>24==1){h=0;break a}break}default:{h=NJc(f[b+56>>2]|0)|0;if(h|0?($Nc(a,h,4,e,m),j=f[m>>2]|0,j|0):0){h=j;break a}}}h=NMc(a,d,k,0)|0;f[m>>2]=h;if(!h){g=f[k>>2]|0;h=PJc(f[g+72>>2]|0)|0;f[m>>2]=h;if(h|0){OMc(g);break}h=aOc(g,l,e,c)|0;f[m>>2]=h;OMc(g);if(!h){$Nc(a,e,c,d,m);h=f[m>>2]|0}}}}else h=YJc(68665)|0;while(0);t=n;return h|0}function ZNc(a,c,e,g){a=a|0;c=c|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=t;t=t+16|0;m=n;l=a+12|0;if(b[l>>0]|0?(h=PJc(c)|0,h|0):0){m=h;t=n;return m|0}k=c+28|0;h=d[k>>1]|0;do if(h&2){h=$Jc(c)|0;if(!h){h=d[k>>1]|0;break}else{m=h;t=n;return m|0}}while(0);if((g|0)!=0|(h&8)==0)j=0;else j=f[c+24>>2]|0;d[k>>1]=h&-9;g=IKc(a,e)|0;i=(g|0)!=0;do if(i){if((d[g+30>>1]|0)>1){HKc(g);m=YJc(59277)|0;t=n;return m|0}d[k>>1]=d[k>>1]|d[g+28>>1]&8;if(!(b[l>>0]|0)){_Kc(g);break}else{eOc(g,(f[a+24>>2]|0)+1|0);break}}while(0);h=f[c+24>>2]|0;eOc(c,e);dKc(c);if(i&(b[l>>0]|0)!=0){eOc(g,h);HKc(g)}if(!j){m=0;t=n;return m|0}h=GKc(a,j,m,0)|0;if(!h){a=f[m>>2]|0;l=a+28|0;d[l>>1]=d[l>>1]|8;dKc(a);HKc(f[m>>2]|0);m=0;t=n;return m|0}if(j>>>0<=(f[a+28>>2]|0)>>>0)fOc(f[a+56>>2]|0,j,f[a+208>>2]|0);m=h;t=n;return m|0}function _Nc(a){a=a|0;var c=0,d=0,e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0;p=t;t=t+16|0;m=p;n=f[a+52>>2]|0;o=f[a+4>>2]|0;if(!(b[a>>0]|0)){c=bOc(a)|0;f[m>>2]=c;if(c|0){o=c;t=p;return o|0}}else f[m>>2]=0;d=j[a+24>>1]|0;e=a+56|0;g=a+26|0;i=a+64|0;k=a+8|0;c=0;while(1){if((c|0)==(d|0))break;l=(f[i>>2]|0)+(c<<1)|0;l=(f[e>>2]|0)+((h[l>>0]<<8|h[l+1>>0])&j[g>>1])|0;dOc(a,a,l,m);if(!(b[k>>0]|0))$Nc(n,NJc(l)|0,5,o,m);c=c+1|0}if(!(b[k>>0]|0))$Nc(n,NJc((f[e>>2]|0)+((h[a+9>>0]|0)+8)|0)|0,5,o,m);o=f[m>>2]|0;t=p;return o|0}function $Nc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0;k=t;t=t+16|0;j=k;if(f[g>>2]|0){t=k;return}if(!c){j=YJc(65967)|0;f[g>>2]=j;t=k;return}h=LMc(a,c)|0;a=GKc(f[a>>2]|0,h,j,0)|0;if(a|0){f[g>>2]=a;t=k;return}i=f[j>>2]|0;a=aMc(i)|0;do if(!(b[a>>0]|0)){c=(c-h|0)*5|0;a=c+-5|0;if((a|0)<0){e=YJc(65985)|0;f[g>>2]=e;break}h=$Lc(i)|0;a=h+a|0;if((b[a>>0]|0)==d<<24>>24?(NJc(h+(c+-4)|0)|0)==(e|0):0)break;i=PJc(i)|0;f[g>>2]=i;if(!i){b[a>>0]=d;RJc(h+(c+-4)|0,e)}}else{e=YJc(65980)|0;f[g>>2]=e}while(0);cMc(f[j>>2]|0);t=k;return}function aOc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;y=t;t=t+32|0;v=y;if(e<<24>>24==4){g=f[a+56>>2]|0;if((NJc(g)|0)==(c|0)){RJc(g,d);d=0;t=y;return d|0}else{d=YJc(68593)|0;t=y;return d|0}}if((b[a>>0]|0)==0?(g=bOc(a)|0,g|0):0){d=g;t=y;return d|0}k=j[a+24>>1]|0;l=a+56|0;m=a+26|0;n=a+64|0;o=e<<24>>24==3;p=a+80|0;q=v+16|0;r=v+12|0;s=v+18|0;u=a+52|0;i=0;while(1){if(i>>>0>=k>>>0)break;g=(f[n>>2]|0)+(i<<1)|0;g=(f[l>>2]|0)+((h[g>>0]<<8|h[g+1>>0])&j[m>>1])|0;if(o){Kd[f[p>>2]&255](a,g,v);if((f[r>>2]|0)>>>0>(j[q>>1]|0)>>>0){g=g+(j[s>>1]|0)|0;if(g>>>0>((f[l>>2]|0)+(f[(f[u>>2]|0)+40>>2]|0)|0)>>>0){x=12;break}g=g+-4|0;if((NJc(g)|0)==(c|0)){x=17;break}}}else if((NJc(g)|0)==(c|0)){x=16;break}i=i+1|0}if((x|0)==12){d=YJc(68612)|0;t=y;return d|0}else if((x|0)==16)RJc(g,d);else if((x|0)==17)RJc(g,d);if((i|0)!=(k|0)){d=0;t=y;return d|0}if(e<<24>>24==5?(w=(f[l>>2]|0)+((h[a+9>>0]|0)+8)|0,(NJc(w)|0)==(c|0)):0){RJc(w,d);d=0;t=y;return d|0}d=YJc(68630)|0;t=y;return d|0}function bOc(a){a=a|0;var c=0,e=0,g=0,i=0,j=0,k=0;c=f[a+52>>2]|0;e=a+56|0;g=a+9|0;i=(f[e>>2]|0)+(h[g>>0]|0)|0;if(SJc(a,h[i>>0]|0)|0){i=YJc(66992)|0;return i|0}j=f[c+36>>2]|0;d[a+26>>1]=j+65535;b[a+12>>0]=0;k=h[a+10>>0]|0;d[a+18>>1]=(h[g>>0]|0)+8+k;f[a+64>>2]=i+k+8;g=f[e>>2]|0;f[a+60>>2]=g+(f[c+40>>2]|0);f[a+68>>2]=g+k;i=i+3|0;i=(h[i>>0]|0)<<8|(h[i+1>>0]|0);d[a+24>>1]=i;if(i>>>0>(((j+-8|0)>>>0)/6|0)>>>0){k=YJc(67006)|0;return k|0}f[a+20>>2]=-1;b[a>>0]=1;if(0==0?(f[(f[c+4>>2]|0)+32>>2]&2097152|0)==0:0){k=0;return k|0}k=cOc(a)|0;return k|0}function cOc(a){a=a|0;var c=0,e=0,g=0,i=0,k=0,l=0,m=0,n=0,o=0,p=0;l=j[a+18>>1]|0;m=a+24|0;c=d[m>>1]|0;n=((c&65535)<<1)+l|0;g=f[(f[a+52>>2]|0)+40>>2]|0;i=f[a+56>>2]|0;o=((b[a+8>>0]|0)==0?-5:-4)+g|0;k=a+76|0;e=0;while(1){if(e>>>0>=(c&65535)>>>0){c=0;p=7;break}c=i+((e<<1)+l)|0;c=h[c>>0]<<8|h[c+1>>0];if(c>>>0<n>>>0|(c|0)>(o|0)){c=66955;break}if((c+((td[f[k>>2]&1023](a,i+c|0)|0)&65535)|0)>(g|0)){c=66960;break}e=e+1|0;c=d[m>>1]|0}if((p|0)==7)return c|0;p=YJc(c)|0;return p|0}function dOc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+32|0;g=h;if(f[d>>2]|0){t=h;return}Kd[f[a+80>>2]&255](a,c,g);e=j[g+16>>1]|0;if((f[g+12>>2]|0)>>>0<=e>>>0){t=h;return}b=f[b+60>>2]|0;if(b>>>0>=c>>>0?b>>>0<(c+e|0)>>>0:0){g=YJc(66370)|0;f[d>>2]=g;t=h;return}g=NJc(c+((j[g+18>>1]|0)+-4)|0)|0;$Nc(f[a+52>>2]|0,g,3,f[a+4>>2]|0,d);t=h;return}function eOc(a,b){a=a|0;b=b|0;var c=0;c=a+24|0;Md[f[40848>>2]&31](f[(f[a+12>>2]|0)+44>>2]|0,f[a>>2]|0,f[c>>2]|0,b);f[c>>2]=b;if((d[a+28>>1]&10)!=10)return;mKc(a,3);return}function fOc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,i=0,j=0,k=0;if(!a)return;g=c+-1|0;while(1){c=f[a+8>>2]|0;if(!c)break;e=(g>>>0)/(c>>>0)|0;a=f[a+12+(e<<2)>>2]|0;if(!a){i=16;break}g=g-(V(e,c)|0)|0}if((i|0)==16)return;if((f[a>>2]|0)>>>0<4001){d=a+12+(g>>>3)|0;b[d>>0]=(1<<(g&7)^255)&(h[d>>0]|0);return}k=a+12|0;Krd(d|0,k|0,500)|0;Mrd(k|0,0,500)|0;k=a+4|0;f[k>>2]=0;i=g+1|0;g=0;while(1){if((g|0)==125)break;j=d+(g<<2)|0;c=f[j>>2]|0;if(!((c|0)==0|(c|0)==(i|0))){f[k>>2]=(f[k>>2]|0)+1;c=((c+-1|0)>>>0)%125|0;while(1){e=a+12+(c<<2)|0;if(!(f[e>>2]|0))break;e=c+1|0;c=e>>>0>124?0:e}f[e>>2]=f[j>>2]}g=g+1|0}return}function gOc(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;a=NMc(a,c,d,e)|0;if(a|0){f[d>>2]=0;d=a;return d|0}a=f[d>>2]|0;if((kOc(f[a+72>>2]|0)|0)>1){OMc(a);f[d>>2]=0;d=YJc(67248)|0;return d|0}else{b[a>>0]=0;d=0;return d|0}return 0}function hOc(a){a=a|0;if((a|0)>-1)return a|0;else return ((a|0)==-2147483648?2147483647:0-a|0)|0;return 0}function iOc(a,b){a=a|0;b=b|0;a=f[a+64>>2]|0;if(!a){b=0;return b|0}if((jOc(a)|0)>>>0<b>>>0){b=1;return b|0}b=(eKc(a,b)|0)!=0&1;return b|0}function jOc(a){a=a|0;return f[a>>2]|0}function kOc(a){a=a|0;return uMc(a)|0}function lOc(a,c){a=a|0;c=c|0;if(c|0?b[a+15>>0]|0:0){c=155361;return c|0}c=f[a+168>>2]|0;return c|0}function mOc(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=a+176|0;e=a+180|0;while(1){c=nOc(a,b)|0;if((c|0)!=5){a=4;break}if(!(sd[f[d>>2]&2047](f[e>>2]|0)|0)){c=5;a=4;break}}if((a|0)==4)return c|0;return 0}function nOc(a,c){a=a|0;c=c|0;var d=0,e=0;e=a+17|0;d=b[e>>0]|0;if(!(d<<24>>24==5|(d&255|0)<(c|0))){e=0;return e|0}do if(!(b[a+13>>0]|0)){d=oOc(f[a+60>>2]|0,c)|0;if(!d){d=b[e>>0]|0;break}else{e=d;return e|0}}while(0);if(!((c|0)==4|d<<24>>24!=5)){e=0;return e|0}b[e>>0]=c;e=0;return e|0}function oOc(a,b){a=a|0;b=b|0;return td[f[(f[a>>2]|0)+28>>2]&1023](a,b)|0}function pOc(a,b){a=a|0;b=b|0;var c=0;b=b+8|0;if(!(f[b>>2]|0))return;c=f[a>>2]|0;a=a+124|0;nxc(c,f[a>>2]|0);c=UIc(c,f[b>>2]|0)|0;f[a>>2]=c;qxc(f[b>>2]|0);f[b>>2]=0;return}function qOc(a){a=a|0;var b=0,c=0,d=0,e=0;e=f[a>>2]|0;d=f[e+16>>2]|0;e=f[e+20>>2]|0;b=a+156|0;a=0;while(1){if((a|0)>=(e|0))break;if(((a|0)!=1?f[b>>2]&1<<a|0:0)?(c=f[d+(a<<4)+4>>2]|0,c|0):0)Bzc(c);a=a+1|0}return}function rOc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=t;t=t+16|0;g=d;e=a+124|0;nxc(f[a>>2]|0,f[e>>2]|0);f[g>>2]=c;c=FIc(f[a>>2]|0,b,g)|0;f[e>>2]=c;t=d;return}function sOc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;i=t;t=t+16|0;e=i;g=f[a+4>>2]|0;Fzc(a);if(!c){c=JJc(g,0,0)|0;if(c|0){d=0;h=3}}else h=3;if((h|0)==3)wOc(a,c,d)|0;if((b[a+8>>0]|0)!=2){eNc(a);Bzc(a);t=i;return}cLc(f[g>>2]|0)|0;if(!(NMc(g,1,e,0)|0)){h=f[e>>2]|0;MJc(g,h);iNc(h)}b[g+20>>0]=1;dNc(g);eNc(a);Bzc(a);t=i;return}function tOc(a){a=a|0;bNc(a,68);return}function uOc(a){a=a|0;var b=0,c=0,e=0,g=0,h=0;Byc(a);c=a+20|0;e=a+16|0;g=a+56|0;b=0;while(1){if((b|0)>=(f[c>>2]|0))break;h=f[(f[e>>2]|0)+(b<<4)+12>>2]|0;do if(h|0)if(!(f[g>>2]|0)){gJc(h);break}else{h=h+78|0;d[h>>1]=d[h>>1]|8;break}while(0);b=b+1|0}h=a+24|0;f[h>>2]=f[h>>2]&-18;jJc(a);Fyc(a);if(f[g>>2]|0)return;vOc(a);return}function vOc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;g=a+20|0;h=a+16|0;e=2;b=2;while(1){if((e|0)>=(f[g>>2]|0))break;c=f[h>>2]|0;d=c+(e<<4)|0;if(!(f[c+(e<<4)+4>>2]|0)){nxc(a,f[d>>2]|0);f[d>>2]=0}else{if((b|0)<(e|0)){c=c+(b<<4)|0;f[c>>2]=f[d>>2];f[c+4>>2]=f[d+4>>2];f[c+8>>2]=f[d+8>>2];f[c+12>>2]=f[d+12>>2]}b=b+1|0}e=e+1|0}f[g>>2]=b;if((b|0)>=3)return;b=f[h>>2]|0;c=a+432|0;if((b|0)==(c|0))return;f[c>>2]=f[b>>2];f[c+4>>2]=f[b+4>>2];f[c+8>>2]=f[b+8>>2];f[c+12>>2]=f[b+12>>2];f[c+16>>2]=f[b+16>>2];f[c+20>>2]=f[b+20>>2];f[c+24>>2]=f[b+24>>2];f[c+28>>2]=f[b+28>>2];nxc(a,b);f[h>>2]=c;return}function wOc(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;if(!a){h=0;return h|0}Fzc(a);g=(d|0)==0;d=(f[a+4>>2]|0)+8|0;a:while(1){e=f[d>>2]|0;if(!e){d=0;break}b:do if(!g?(b[e+1>>0]&1)==0:0){switch(b[e>>0]|0){case 2:case 0:break;default:break b}d=AMc(e)|0;if(d|0){h=8;break a}}else h=9;while(0);if((h|0)==9){h=0;xOc(e);b[e>>0]=4;f[e+4>>2]=c}BMc(e);d=e+24|0}if((h|0)==8)wOc(a,d,0)|0;Bzc(a);h=d;return h|0}function xOc(a){a=a|0;var c=0;c=a+16|0;qxc(f[c>>2]|0);f[c>>2]=0;b[a>>0]=1;return}function yOc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;c=f[a>>2]|0;zOc(c);f[c+104>>2]=f[a+8>>2];f[c+108>>2]=f[a+52>>2];f[c+88>>2]=f[a+16>>2];f[c+24>>2]=f[a+56>>2];f[c+96>>2]=f[a+20>>2];f[c+28>>2]=f[a+44>>2];g=a+32|0;e=f[g+4>>2]|0;b=f[c>>2]|0;d=b+40|0;f[d>>2]=f[g>>2];f[d+4>>2]=e;f[c+44>>2]=f[a+68>>2];f[b+104>>2]=f[a+72>>2];c=c+216|0;BOc(b,c,-1,0);b=a+40|0;f[c>>2]=f[b>>2];f[b>>2]=0;return f[a+48>>2]|0}function zOc(a){a=a|0;var b=0,c=0,d=0,e=0;c=a+96|0;if(!(f[c>>2]|0))return;d=a+28|0;b=0;while(1){if((b|0)>=(f[d>>2]|0))break;e=f[(f[c>>2]|0)+(b<<2)>>2]|0;if(e|0){COc(a,e);f[(f[c>>2]|0)+(b<<2)>>2]=0}b=b+1|0}return}function AOc(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;c=a+80|0;d=a+60|0;e=c+((f[d>>2]|0)*40|0)|0;g=a+64|0;b=0;while(1){if((b|0)>=(f[g>>2]|0))break;COc(f[a>>2]|0,f[e+(b<<2)>>2]|0);b=b+1|0}Lyc(c,f[d>>2]|0);BOc(f[f[a>>2]>>2]|0,a+40|0,-1,0);nxc(f[f[a>>2]>>2]|0,a);return}function BOc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=(c|0)<0;a:while(1){while(1){g=f[b>>2]|0;if(!g)break a;if(!h){if((f[g>>2]|0)!=(c|0))break;e=f[g+4>>2]|0;if((e|0)<=-1)break;if((e|0)<=31?1<<e&d|0:0)break}e=f[g+12>>2]|0;if(e|0)Hd[e&1023](f[g+8>>2]|0);f[b>>2]=f[g+16>>2];nxc(a,g)}b=g+16|0}return}function COc(a,c){a=a|0;c=c|0;var d=0;if(!c)return;switch(b[c>>0]|0){case 1:{DOc(f[a>>2]|0,c);return}case 0:{EOc(f[c+40>>2]|0);return}case 2:{c=f[c+40>>2]|0;d=f[c>>2]|0;a=f[d>>2]|0;d=d+4|0;f[d>>2]=(f[d>>2]|0)+-1;sd[f[a+28>>2]&2047](c)|0;return}default:return}}function DOc(a,b){a=a|0;b=b|0;var c=0;b=b+40|0;c=f[b>>2]|0;if(!c)return;WOc(a,c);qxc(f[c+40>>2]|0);nxc(a,c);f[b>>2]=0;return}function EOc(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0;e=a+8|0;g=f[e>>2]|0;if(!g)return;h=f[a+20>>2]|0;Fzc(g);i=h+8|0;c=f[i>>2]|0;a:do if((c|0)==(a|0))f[i>>2]=f[a+24>>2];else{while(1){d=f[c+24>>2]|0;if((d|0)==(a|0))break;if(!d)break a;else c=d}f[c+24>>2]=f[a+24>>2]}while(0);BMc(a);hNc(h);qxc(f[a+12>>2]|0);qxc(f[a+16>>2]|0);if((b[h+16>>0]&4)!=0?(f[i>>2]|0)==0:0)FOc(g);else Bzc(g);f[e>>2]=0;return}function FOc(a){a=a|0;var c=0,d=0,e=0,g=0;g=f[a+4>>2]|0;Fzc(a);sOc(a,0,0);Bzc(a);if(!((b[a+9>>0]|0)!=0?!(GOc(g)|0):0)){HOc(f[g>>2]|0,f[a>>2]|0);d=f[g+56>>2]|0;c=g+52|0;if(d|0?(e=f[c>>2]|0,e|0):0)Hd[d&1023](e);nxc(0,f[c>>2]|0);IOc(g);qxc(g)}d=f[a+28>>2]|0;c=a+24|0;if(d|0)f[d+24>>2]=f[c>>2];c=f[c>>2]|0;if(!c){qxc(a);return}f[c+28>>2]=d;qxc(a);return}function GOc(a){a=a|0;var b=0,c=0,d=0;d=Mzc(2)|0;axc(d);b=a+68|0;c=f[b>>2]|0;f[b>>2]=c+-1;if((c|0)>=2){a=0;bxc(d);return a|0}b=f[38488]|0;a:do if((b|0)==(a|0))f[38488]=f[a+72>>2];else{while(1){if(!b)break a;c=f[b+72>>2]|0;if((c|0)==(a|0))break;else b=c}f[b+72>>2]=f[a+72>>2]}while(0);Uzc(f[a+60>>2]|0);a=1;bxc(d);return a|0}function HOc(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;e=f[a+208>>2]|0;tzc();JOc(a);b[a+4>>0]=0;if((c|0)!=0?(0==0?(f[c+32>>2]&2048|0)==0:0):0){d=(oKc(a)|0)==0;d=d?e:0}else d=0;g=a+216|0;KOc(f[g>>2]|0,c,h[a+11>>0]|0,f[a+152>>2]|0,d)|0;f[g>>2]=0;iLc(a);if(!(b[a+15>>0]|0)){d=a+64|0;if(f[f[d>>2]>>2]|0)FLc(a,LOc(a)|0)|0;bLc(a)}else{eLc(a);d=a+64|0}uzc();DKc(f[d>>2]|0);DKc(f[a+60>>2]|0);TLc(e);MOc(f[a+212>>2]|0);qxc(a);return}function IOc(a){a=a|0;var b=0;a=a+84|0;b=f[a>>2]|0;if(!b)return;b=b+-4|0;f[a>>2]=b;TLc(b);f[a>>2]=0;return}function JOc(a){a=a|0;var b=0;a=f[a+136>>2]|0;while(1){if(!a)break;b=f[a+16>>2]|0;qxc(a);a=b}return}function KOc(a,c,d,e,g){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;j=l;if(!a){a=0;t=l;return a|0}if(g){k=a+4|0;i=oOc(f[k>>2]|0,4)|0;if(!i){h=a+43|0;if(!(b[h>>0]|0))b[h>>0]=1;i=NOc(a,c,0,0,0,d,e,g,0,0)|0;if(!i){f[j>>2]=-1;tNc(f[k>>2]|0,10,j);if((f[j>>2]|0)==1){k=a+16|0;j=f[k+4>>2]|0;if((j|0)>-1|(j|0)==-1&(f[k>>2]|0)>>>0>4294967295){BNc(a,0,0);h=0}else h=0}else h=1;i=0}else h=0}else h=0}else{i=0;h=0}SNc(a,h);DKc(f[a+8>>2]|0);if(h|0){tzc();uLc(f[a>>2]|0,f[a+108>>2]|0,0)|0;uzc()}qxc(f[a+32>>2]|0);qxc(a);a=i;t=l;return a|0}function LOc(a){a=a|0;var c=0,d=0;c=a+64|0;if((b[a+7>>0]|0)==0?(d=sLc(f[c>>2]|0,2)|0,d|0):0)return d|0;d=BLc(f[c>>2]|0,a+80|0)|0;return d|0}function MOc(a){a=a|0;Hd[f[40856>>2]&1023](f[a+44>>2]|0);return}function NOc(a,c,d,e,g,h,i,j,k,l){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0;q=t;t=t+16|0;p=q;f[p>>2]=0;if(b[a+46>>0]|0){d=8;t=q;return d|0}n=JNc(a,1,1)|0;a:do if(!n){b[a+45>>0]=1;b:do if(!d){o=0;m=6}else{n=OOc(a,e,g,0,1)|0;switch(n|0){case 5:{o=0;e=0;m=6;break b}case 0:break;default:{o=d;break b}}b[a+44>>0]=1;o=d;m=6}while(0);if((m|0)==6)n=NNc(a,p)|0;if(!n){m=a+68|0;if((f[m>>2]|0)!=0?(POc(a)|0)!=(i|0):0)n=YJc(63676)|0;else n=QOc(a,c,o,e,g,h,j)|0;switch(n|0){case 0:case 5:break;default:break a}if(k|0)f[k>>2]=f[m>>2];if(l){k=INc(a)|0;f[l>>2]=f[k>>2]}}}else o=d;while(0);if(f[p>>2]|0){e=a+52|0;m=e+48|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(m|0))}oLc(a);e=a+45|0;if(b[e>>0]|0){rLc(a,1,1);b[e>>0]=0}d=(o|0)==(d|0)|(n|0)!=0?n:5;t=q;return d|0}function OOc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;g=(b|0)!=0;while(1){f=JNc(a,d,e)|0;if(!(g&(f|0)==5)){a=4;break}if(!(sd[b&2047](c)|0)){f=5;a=4;break}}if((a|0)==4)return f|0;return 0}function POc(a){a=a|0;a=j[a+66>>1]|0;return a<<16&65536|a&65024|0}function QOc(a,c,d,e,g,h,i){a=a|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;E=t;t=t+32|0;n=E+24|0;y=E+20|0;z=E+16|0;D=E+8|0;o=E;f[n>>2]=0;f[y>>2]=0;f[z>>2]=0;v=POc(a)|0;B=INc(a)|0;C=a+68|0;j=f[C>>2]|0;if((f[B>>2]|0)>>>0<j>>>0){w=a+72|0;x=f[w>>2]|0;A=e;e=0;u=j;m=1;a:while(1){if(m>>>0>=5)break;l=B+4+(m<<2)|0;j=f[l>>2]|0;b:do if(u>>>0>j>>>0){k=m+3|0;e=OOc(a,A,g,k,1)|0;switch(e|0){case 5:{k=0;break b}case 0:break;default:{j=0;q=44;break a}}f[l>>2]=(m|0)==1?u:-1;rLc(a,k,1);k=A;e=0;j=u}else{k=A;j=u}while(0);A=k;u=j;m=m+1|0}if((q|0)==44){TOc(j);t=E;return e|0}if((f[B>>2]|0)>>>0<u>>>0){e=ROc(a,f[B>>2]|0,n)|0;j=f[n>>2]|0;if(j){e=OOc(a,A,g,3,1)|0;if(!e){q=f[B>>2]|0;f[B+32>>2]=u;r=a+8|0;s=h>>>2&3;e=sLc(f[r>>2]|0,s)|0;if(!e){h=((v|0)<0)<<31>>31;l=Brd(x|0,0,v|0,h|0)|0;m=G;n=D;f[n>>2]=l;f[n+4>>2]=m;n=a+4|0;EKc(f[n>>2]|0,39,0)|0;e=BLc(f[n>>2]|0,o)|0;do if(!e){k=o;e=f[k>>2]|0;k=f[k+4>>2]|0;if((k|0)<(m|0)|(k|0)==(m|0)&e>>>0<l>>>0){k=vrd(e|0,k|0,65536,0)|0;o=G;p=Brd(f[C>>2]|0,0,v|0,h|0)|0;p=vrd(k|0,o|0,p|0,G|0)|0;o=G;if((o|0)<(m|0)|(o|0)==(m|0)&p>>>0<l>>>0){e=YJc(61874)|0;break}else{tNc(f[n>>2]|0,5,D);e=0;break}}else e=0}while(0);p=v}else{n=a+4|0;p=v;h=((v|0)<0)<<31>>31}l=c+272|0;m=v+24|0;o=((m|0)<0)<<31>>31;while(1){if(e|0){q=29;break}if(SOc(j,y,z)|0){q=22;break}if(f[l>>2]|0){q=24;break}e=f[z>>2]|0;k=f[y>>2]|0;if(!(e>>>0<=q>>>0|e>>>0>u>>>0|k>>>0>x>>>0)){e=Brd(e+-1|0,0,m|0,o|0)|0;e=vrd(e|0,G|0,56,0)|0;e=QLc(f[r>>2]|0,i,v,e,G)|0;if(e|0){q=29;break}e=Brd(p|0,h|0,k+-1|0,0)|0;e=iKc(f[n>>2]|0,i,v,e,G)|0;if(e){q=30;break}}else e=0}do if((q|0)==22){EKc(f[n>>2]|0,37,0)|0;z=(xMc(a)|0)+16|0;if((u|0)==(f[z>>2]|0)){e=Brd(p|0,h|0,f[w>>2]|0,0)|0;e=TKc(f[n>>2]|0,e,G)|0;if(e|0)break;e=sLc(f[n>>2]|0,s)|0;if(e|0)break}f[B>>2]=u;e=0}else if((q|0)==24){e=(b[c+83>>0]|0)==0?9:7;q=29}else if((q|0)==30)EKc(f[n>>2]|0,37,0)|0;while(0);if((q|0)==29)EKc(f[n>>2]|0,37,0)|0;rLc(a,3,1)}}else j=0}else j=0;k=(e|0)==5?0:e;e=A}else{k=0;j=0}if(!((d|0)!=0&(k|0)==0)){a=k;d=j;TOc(d);t=E;return a|0}if((f[B>>2]|0)>>>0<(f[C>>2]|0)>>>0){a=5;d=j;TOc(d);t=E;return a|0}if((d|0)<=1){a=0;d=j;TOc(d);t=E;return a|0}$Ac(4,D);e=OOc(a,e,g,4,4)|0;if(!e){if((d|0)==3){KNc(a,f[D>>2]|0);e=TKc(f[a+8>>2]|0,0,0)|0}else e=0;rLc(a,4,4)}a=e;d=j;TOc(d);t=E;return a|0}function ROc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0;x=t;t=t+16|0;s=x+4|0;u=x;v=f[a+68>>2]|0;w=gMc(v)|0;g=(v<<1)+28+(w*20|0)|0;e=XAc(g,0)|0;if(!e){c=7;t=x;return c|0}Mrd(e|0,0,g|0)|0;n=e+4|0;f[n>>2]=w+1;o=XAc((v>>>0<4096?v:4096)<<1,0)|0;p=s+4|0;q=s+8|0;r=e+8|0;m=gMc(b+1|0)|0;g=(o|0)==0?7:0;while(1){if((m|0)>(w|0)|(g|0)!=0)break;g=hMc(a,m,s)|0;if(!g){i=(f[p>>2]|0)+4|0;f[p>>2]=i;j=i;if((m|0)==(w|0)){l=f[q>>2]|0;b=l;l=v-l|0}else{b=f[q>>2]|0;l=(f[s>>2]|0)-j>>2}f[u>>2]=l;k=r+((f[n>>2]|0)*20|0)+(b<<1)|0;h=b+1|0;f[q>>2]=h;b=0;while(1){if((b|0)>=(l|0))break;d[k+(b<<1)>>1]=b;b=b+1|0}UOc(i,o,k,u);f[r+(m*20|0)+16>>2]=h;f[r+(m*20|0)+12>>2]=f[u>>2];f[r+(m*20|0)+4>>2]=k;f[r+(m*20|0)+8>>2]=j}m=m+1|0}qxc(o);if(g){TOc(e);e=0}f[c>>2]=e;c=g;t=x;return c|0}function SOc(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=f[a>>2]|0;l=-1;e=f[a+4>>2]|0;a:while(1){g=e;while(1){e=g+-1|0;if((g|0)<=0)break a;j=a+8+(e*20|0)|0;k=a+8+(e*20|0)+8|0;h=a+8+(e*20|0)+4|0;g=f[a+8+(e*20|0)+12>>2]|0;i=f[j>>2]|0;while(1){if((i|0)>=(g|0))break;m=d[(f[h>>2]|0)+(i<<1)>>1]|0;n=f[(f[k>>2]|0)+((m&65535)<<2)>>2]|0;if(n>>>0>o>>>0){p=7;break}q=i+1|0;f[j>>2]=q;i=q}if((p|0)==7?(p=0,n>>>0<l>>>0):0)break;g=e}f[c>>2]=(f[a+8+(e*20|0)+16>>2]|0)+(m&65535);l=n}f[a>>2]=l;f[b>>2]=l;return (l|0)==-1|0}function TOc(a){a=a|0;qxc(a);return}function UOc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+112|0;h=l+108|0;i=l+104|0;j=l;k=f[d>>2]|0;f[h>>2]=0;f[i>>2]=0;e=j;g=e+104|0;do{f[e>>2]=0;e=e+4|0}while((e|0)<(g|0));g=0;e=0;while(1){if((g|0)>=(k|0))break;f[h>>2]=1;f[i>>2]=c+(g<<1);e=0;while(1){if(!(1<<e&g))break;VOc(a,f[j+(e<<3)+4>>2]|0,f[j+(e<<3)>>2]|0,i,h,b);e=e+1|0}f[j+(e<<3)+4>>2]=f[i>>2];f[j+(e<<3)>>2]=f[h>>2];g=g+1|0}while(1){e=e+1|0;if(e>>>0>=13)break;if(1<<e&k|0)VOc(a,f[j+(e<<3)+4>>2]|0,f[j+(e<<3)>>2]|0,i,h,b)}f[d>>2]=f[h>>2];t=l;return}function VOc(a,b,c,e,g,h){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;var i=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;p=f[g>>2]|0;q=f[e>>2]|0;i=0;m=0;n=0;while(1){l=(m|0)<(p|0);k=(i|0)<(c|0);if(!(l|k))break;do if(k){k=b+(i<<1)|0;if(l?(o=q+(m<<1)|0,(f[a+((j[k>>1]|0)<<2)>>2]|0)>>>0>=(f[a+((j[o>>1]|0)<<2)>>2]|0)>>>0):0){k=o;r=8;break}i=i+1|0;l=m}else{k=q+(m<<1)|0;r=8}while(0);if((r|0)==8){r=0;l=m+1|0}m=d[k>>1]|0;k=f[a+((m&65535)<<2)>>2]|0;d[h+(n<<1)>>1]=m;if((i|0)<(c|0))i=i+((f[a+((j[b+(i<<1)>>1]|0)<<2)>>2]|0)==(k|0)&1)|0;m=l;n=n+1|0}f[e>>2]=b;f[g>>2]=n;Krd(b|0,h|0,n<<1|0)|0;return}function WOc(a,c){a=a|0;c=c|0;var d=0,e=0;XOc(c,0)|0;d=c+16|0;e=f[d>>2]|0;if(e|0){YOc(e);nxc(a,f[d>>2]|0);f[d>>2]=0}e=c+20|0;ZOc(f[e>>2]|0);f[e>>2]=0;e=c+59|0;d=0;while(1){if(d>>>0>=(h[e>>0]|0)>>>0)break;_Oc(a,c+64+(d*72|0)|0);f[c+64+(d*72|0)+8>>2]=c;d=d+1|0}d=c+36|0;if(!(f[c+40>>2]|0))$Oc(0,f[d>>2]|0);f[d>>2]=0;f[c+44>>2]=0;b[c+56>>0]=0;f[c+48>>2]=0;f[c+8>>2]=0;c=c+32|0;nxc(a,f[c>>2]|0);f[c>>2]=0;return}function XOc(a,b){a=a|0;b=b|0;var c=0,d=0;d=h[a+59>>0]|0;while(1){c=d+-1|0;if((d|0)<=0)break;d=bPc(a+64+(c*72|0)|0)|0;b=(b|0)==0?d:b;d=c}return b|0}function YOc(a){a=a|0;var b=0;qxc(f[a+28>>2]|0);qxc(f[a+36>>2]|0);aPc(f[a+48>>2]|0);b=a+56|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(b|0));return}function ZOc(a){a=a|0;var b=0,c=0;if(!a){qxc(a);return}c=a+12|0;b=0;while(1){if((b|0)>=(f[a>>2]|0))break;YOc((f[c>>2]|0)+(b*56|0)|0);b=b+1|0}qxc(a);return}function _Oc(a,b){a=a|0;b=b|0;nxc(a,f[b+12>>2]|0);a=f[b+20>>2]|0;if(!a)$Oc(0,f[b+16>>2]|0);else qxc(a);a=f[b+40>>2]|0;if(a|0)$Mc(a);a=f[b+56>>2]|0;if(a|0)$Mc(a);a=b;b=a+72|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(b|0));return}function $Oc(a,b){a=a|0;b=b|0;var c=0;while(1){if(!b)break;c=f[b+4>>2]|0;nxc(a,b);b=c}return}function aPc(a){a=a|0;var b=0;if(!a)return;if(f[a+24>>2]|0){bPc(f[a>>2]|0)|0;b=f[a+32>>2]|0;if(b|0)$Mc(b);b=f[a+48>>2]|0;if(b|0)$Mc(b)}ZOc(f[a+4>>2]|0);qxc(a);return}function bPc(a){a=a|0;var b=0,c=0,d=0;d=t;t=t+16|0;b=d;c=f[a>>2]|0;if(!c){c=0;t=d;return c|0}f[b>>2]=1;cPc(c,b);c=f[b>>2]|0;f[a+4>>2]=0;f[a>>2]=0;t=d;return c|0}function cPc(a,b){a=a|0;b=b|0;if(!a)return;if(!(f[a+4>>2]|0))Zc(f[a>>2]|0,b|0)|0;else f[b>>2]=f[a+8>>2];qxc(a);return}function dPc(a,c,e){a=a|0;c=c|0;e=e|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;u=f[a+4>>2]|0;v=f[u>>2]|0;Fzc(a);r=a+8|0;g=b[r>>0]|0;do if(g<<24>>24!=2?(q=(c|0)!=0,q|g<<24>>24!=1):0){if(!(0==0?(f[(f[a>>2]|0)+32>>2]&33554432|0)==0:0)?(hPc(v)|0)<<24>>24==0:0){o=u+24|0;d[o>>1]=d[o>>1]&-2}o=u+24|0;g=d[o>>1]|0;if(q&(g&1)!=0){v=8;Bzc(a);return v|0}a:do if(q)if((g&128)==0&(b[u+20>>0]|0)!=2){if((c|0)>1){g=u+76|0;while(1){g=f[g>>2]|0;if(!g)break a;i=f[g>>2]|0;if((i|0)==(a|0))g=g+12|0;else{j=i;p=15;break}}}}else p=10;else if(g&128)p=10;while(0);if((p|0)==10){j=f[u+80>>2]|0;p=15}if((p|0)==15?f[j>>2]|0:0){v=262;Bzc(a);return v|0}g=iPc(a,1,1)|0;if(g|0){v=g;Bzc(a);return v|0}g=d[o>>1]|0;d[o>>1]=g&-17;n=u+48|0;if(!(f[n>>2]|0))d[o>>1]=g|16;k=u+12|0;l=u+20|0;m=(c|0)>1;j=m&1;g=0;b:while(1){c:do if(!(f[k>>2]|0)){g=jPc(u)|0;if(!g)g=0;else{i=g;p=28}}else{d:do if(q&(g|0)==0){if(d[o>>1]&1){i=8;p=28;break c}g=lPc(v,j,kPc(f[a>>2]|0)|0)|0;switch(g|0){case 0:{g=LJc(u)|0;break d}case 517:{i=(b[l>>0]|0)==0?5:517;p=28;break c}default:break d}}while(0);if(!g){i=0;break b}else{i=0;p=30}}while(0);if((p|0)==28){g=i;i=(i|0)==0;p=30}if((p|0)==30){p=0;hNc(u);if((g&255|0)!=5){p=33;break}if(b[l>>0]|0){p=33;break}if(!(mPc(u)|0)){p=33;break}}}if((p|0)==33)if(i)i=g;else{v=g;Bzc(a);return v|0}if((b[r>>0]|0)==0?(p=u+44|0,f[p>>2]=(f[p>>2]|0)+1,b[a+9>>0]|0):0){b[a+40>>0]=1;p=u+76|0;f[a+44>>2]=f[p>>2];f[p>>2]=a+32}g=q?2:1;b[r>>0]=g;if((g&255)>(h[l>>0]|0))b[l>>0]=g;if(q?(s=f[k>>2]|0,f[u+80>>2]=a,r=d[o>>1]|0,d[o>>1]=m?r|64:r&-65,r=f[n>>2]|0,t=s+56|0,(r|0)!=(NJc((f[t>>2]|0)+28|0)|0)):0){g=PJc(f[s+72>>2]|0)|0;if(!g){RJc((f[t>>2]|0)+28|0,f[n>>2]|0);break}else{v=g;Bzc(a);return v|0}}if(i|0){v=i;Bzc(a);return v|0}}while(0);if(e|0){u=NJc((f[(f[u+12>>2]|0)+56>>2]|0)+40|0)|0;f[e>>2]=u}if(!c){v=0;Bzc(a);return v|0}v=nPc(v,f[(f[a>>2]|0)+476>>2]|0)|0;Bzc(a);return v|0}function ePc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a+4>>2]|0;Fzc(a);if((b|0)==15){d=gPc(f[d>>2]|0)|0;d=(f[a+20>>2]|0)+d|0;f[c>>2]=d;Bzc(a);return}else{d=NJc((f[(f[d+12>>2]|0)+56>>2]|0)+((b<<2)+36)|0)|0;f[c>>2]=d;Bzc(a);return}}function fPc(a){a=a|0;var b=0;Fzc(a);b=VMc(a,0)|0;if(!b)b=WMc(a,0)|0;Bzc(a);return b|0}function gPc(a){a=a|0;return f[a+100>>2]|0}function hPc(a){a=a|0;return b[a+14>>0]|0}
function DZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=KZa(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function EZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=KZa(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function FZa(a){a=a|0;var b=0;f[a>>2]=71644;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function GZa(a){a=a|0;FZa(a);jpd(a);return}function HZa(a){a=a|0;var b=0;b=gpd(20)|0;IZa(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function IZa(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=71644;b=gpd(100)|0;JZa(b);f[a+16>>2]=b;return}function JZa(a){a=a|0;var c=0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;b[a+3>>0]=0;n[a+4>>2]=4.0;n[a+8>>2]=5.0;n[a+12>>2]=10.0;n[a+16>>2]=360.0;f[a+20>>2]=12;f[a+24>>2]=3;n[a+28>>2]=50.0;n[a+32>>2]=-70.0;n[a+36>>2]=-70.0;n[a+40>>2]=10.0;n[a+44>>2]=-70.0;n[a+48>>2]=-70.0;n[a+52>>2]=10.0;f[a+56>>2]=3;n[a+60>>2]=200.0;n[a+64>>2]=10.0;n[a+68>>2]=20.0;f[a+72>>2]=10;n[a+76>>2]=30.0;b[a+80>>0]=1;b[a+81>>0]=0;b[a+82>>0]=0;b[a+83>>0]=1;b[a+84>>0]=0;b[a+85>>0]=0;b[a+86>>0]=1;b[a+87>>0]=0;b[a+88>>0]=1;b[a+89>>0]=0;c=a+90|0;d[c>>1]=257;d[c+2>>1]=257;d[c+4>>1]=257;b[c+6>>0]=1;b[a+97>>0]=0;b[a+98>>0]=0;b[a+99>>0]=0;return}function KZa(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if((b[a+3>>0]|0)!=(b[c+3>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if(!(+n[a+16>>2]==+n[c+16>>2])){c=0;return c|0}if((f[a+20>>2]|0)!=(f[c+20>>2]|0)){c=0;return c|0}if((f[a+24>>2]|0)!=(f[c+24>>2]|0)){c=0;return c|0}if(!(+n[a+28>>2]==+n[c+28>>2])){c=0;return c|0}if(!(+n[a+32>>2]==+n[c+32>>2])){c=0;return c|0}if(!(+n[a+36>>2]==+n[c+36>>2])){c=0;return c|0}if(!(+n[a+40>>2]==+n[c+40>>2])){c=0;return c|0}if(!(+n[a+44>>2]==+n[c+44>>2])){c=0;return c|0}if(!(+n[a+48>>2]==+n[c+48>>2])){c=0;return c|0}if(!(+n[a+52>>2]==+n[c+52>>2])){c=0;return c|0}if((f[a+56>>2]|0)!=(f[c+56>>2]|0)){c=0;return c|0}if(!(+n[a+60>>2]==+n[c+60>>2])){c=0;return c|0}if(!(+n[a+64>>2]==+n[c+64>>2])){c=0;return c|0}if(!(+n[a+68>>2]==+n[c+68>>2])){c=0;return c|0}if((f[a+72>>2]|0)!=(f[c+72>>2]|0)){c=0;return c|0}if(!(+n[a+76>>2]==+n[c+76>>2])){c=0;return c|0}if((b[a+80>>0]|0)!=(b[c+80>>0]|0)){c=0;return c|0}if((b[a+81>>0]|0)!=(b[c+81>>0]|0)){c=0;return c|0}if((b[a+82>>0]|0)!=(b[c+82>>0]|0)){c=0;return c|0}if((b[a+83>>0]|0)!=(b[c+83>>0]|0)){c=0;return c|0}if((b[a+84>>0]|0)!=(b[c+84>>0]|0)){c=0;return c|0}if((b[a+85>>0]|0)!=(b[c+85>>0]|0)){c=0;return c|0}if((b[a+86>>0]|0)!=(b[c+86>>0]|0)){c=0;return c|0}if((b[a+87>>0]|0)!=(b[c+87>>0]|0)){c=0;return c|0}if((b[a+88>>0]|0)!=(b[c+88>>0]|0)){c=0;return c|0}if((b[a+89>>0]|0)!=(b[c+89>>0]|0)){c=0;return c|0}if((b[a+90>>0]|0)!=(b[c+90>>0]|0)){c=0;return c|0}if((b[a+91>>0]|0)!=(b[c+91>>0]|0)){c=0;return c|0}if((b[a+92>>0]|0)!=(b[c+92>>0]|0)){c=0;return c|0}if((b[a+93>>0]|0)!=(b[c+93>>0]|0)){c=0;return c|0}if((b[a+94>>0]|0)!=(b[c+94>>0]|0)){c=0;return c|0}if((b[a+95>>0]|0)!=(b[c+95>>0]|0)){c=0;return c|0}if((b[a+96>>0]|0)!=(b[c+96>>0]|0)){c=0;return c|0}if((b[a+97>>0]|0)!=(b[c+97>>0]|0)){c=0;return c|0}if((b[a+98>>0]|0)!=(b[c+98>>0]|0)){c=0;return c|0}c=(b[a+99>>0]|0)==(b[c+99>>0]|0);return c|0}function LZa(a){a=a|0;return 69}function MZa(a,b){a=a|0;b=b|0;var c=0;if((b|0)==(a|0)){c=1;return c|0}if(!(gSa(a,b)|0)){c=0;return c|0}c=f[a+16>>2]|0;a=f[b+16>>2]|0;b=c+88|0;do{f[c>>2]=f[a>>2];c=c+4|0;a=a+4|0}while((c|0)<(b|0));c=1;return c|0}function NZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=UZa(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function OZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=UZa(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function PZa(a){a=a|0;var b=0;f[a>>2]=71744;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function QZa(a){a=a|0;PZa(a);jpd(a);return}function RZa(a){a=a|0;var b=0;b=gpd(20)|0;SZa(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function SZa(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=71744;b=gpd(88)|0;TZa(b);f[a+16>>2]=b;return}function TZa(a){a=a|0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;b[a+3>>0]=0;n[a+4>>2]=2.0;n[a+8>>2]=.5;n[a+12>>2]=0.0;n[a+16>>2]=720.0;n[a+20>>2]=0.0;n[a+24>>2]=360.0;f[a+28>>2]=18;f[a+32>>2]=10;f[a+36>>2]=1;n[a+40>>2]=0.0;n[a+44>>2]=3.0;n[a+48>>2]=0.0;n[a+52>>2]=0.0;n[a+56>>2]=0.0;b[a+60>>0]=1;b[a+61>>0]=0;b[a+62>>0]=1;b[a+63>>0]=1;b[a+64>>0]=0;b[a+65>>0]=0;b[a+66>>0]=0;a=a+68|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;return}function UZa(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if((b[a+3>>0]|0)!=(b[c+3>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if(!(+n[a+16>>2]==+n[c+16>>2])){c=0;return c|0}if(!(+n[a+20>>2]==+n[c+20>>2])){c=0;return c|0}if(!(+n[a+24>>2]==+n[c+24>>2])){c=0;return c|0}if((f[a+28>>2]|0)!=(f[c+28>>2]|0)){c=0;return c|0}if((f[a+32>>2]|0)!=(f[c+32>>2]|0)){c=0;return c|0}if((f[a+36>>2]|0)!=(f[c+36>>2]|0)){c=0;return c|0}if(!(+n[a+40>>2]==+n[c+40>>2])){c=0;return c|0}if(!(+n[a+44>>2]==+n[c+44>>2])){c=0;return c|0}if(!(+n[a+48>>2]==+n[c+48>>2])){c=0;return c|0}if(!(+n[a+52>>2]==+n[c+52>>2])){c=0;return c|0}if(!(+n[a+56>>2]==+n[c+56>>2])){c=0;return c|0}if((b[a+60>>0]|0)!=(b[c+60>>0]|0)){c=0;return c|0}if((b[a+61>>0]|0)!=(b[c+61>>0]|0)){c=0;return c|0}if((b[a+62>>0]|0)!=(b[c+62>>0]|0)){c=0;return c|0}if((b[a+63>>0]|0)!=(b[c+63>>0]|0)){c=0;return c|0}if((b[a+64>>0]|0)!=(b[c+64>>0]|0)){c=0;return c|0}if((b[a+65>>0]|0)!=(b[c+65>>0]|0)){c=0;return c|0}if((b[a+66>>0]|0)!=(b[c+66>>0]|0)){c=0;return c|0}if(!(+n[a+68>>2]==+n[c+68>>2])){c=0;return c|0}if(!(+n[a+72>>2]==+n[c+72>>2])){c=0;return c|0}if(!(+n[a+76>>2]==+n[c+76>>2])){c=0;return c|0}if(!(+n[a+80>>2]==+n[c+80>>2])){c=0;return c|0}c=+n[a+84>>2]==+n[c+84>>2];return c|0}function VZa(a){a=a|0;return 89}function WZa(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;if((c|0)==(a|0)){g=1;return g|0}if(!(gSa(a,c)|0)){g=0;return g|0}g=f[c+16>>2]|0;c=f[a+16>>2]|0;a=c;d=g;e=a+60|0;do{f[a>>2]=f[d>>2];a=a+4|0;d=d+4|0}while((a|0)<(e|0));b[c+60>>0]=b[g+60>>0]|0;g=1;return g|0}function XZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=c_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function YZa(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=c_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function ZZa(a){a=a|0;var b=0;f[a>>2]=71844;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function _Za(a){a=a|0;ZZa(a);jpd(a);return}function $Za(a){a=a|0;var b=0;b=gpd(20)|0;a_a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function a_a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=71844;b=gpd(64)|0;b_a(b);f[a+16>>2]=b;return}function b_a(a){a=a|0;var c=0,d=0;b[a>>0]=1;b[a+1>>0]=1;n[a+4>>2]=5.0;n[a+8>>2]=10.0;n[a+12>>2]=8.0;f[a+16>>2]=10;n[a+20>>2]=40.0;n[a+24>>2]=3.0;n[a+28>>2]=30.0;n[a+32>>2]=5.0;n[a+36>>2]=300.0;n[a+40>>2]=8.0;n[a+44>>2]=70.0;b[a+48>>0]=0;b[a+49>>0]=1;b[a+50>>0]=0;c=a+51|0;d=c;b[d>>0]=1;b[d+1>>0]=1;b[d+2>>0]=1;b[d+3>>0]=1;c=c+4|0;b[c>>0]=1;b[c+1>>0]=1;b[c+2>>0]=1;b[c+3>>0]=1;b[a+59>>0]=0;b[a+60>>0]=0;return}function c_a(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if((f[a+16>>2]|0)!=(f[c+16>>2]|0)){c=0;return c|0}if(!(+n[a+20>>2]==+n[c+20>>2])){c=0;return c|0}if(!(+n[a+24>>2]==+n[c+24>>2])){c=0;return c|0}if(!(+n[a+28>>2]==+n[c+28>>2])){c=0;return c|0}if(!(+n[a+32>>2]==+n[c+32>>2])){c=0;return c|0}if(!(+n[a+36>>2]==+n[c+36>>2])){c=0;return c|0}if(!(+n[a+40>>2]==+n[c+40>>2])){c=0;return c|0}if(!(+n[a+44>>2]==+n[c+44>>2])){c=0;return c|0}if((b[a+48>>0]|0)!=(b[c+48>>0]|0)){c=0;return c|0}if((b[a+49>>0]|0)!=(b[c+49>>0]|0)){c=0;return c|0}if((b[a+50>>0]|0)!=(b[c+50>>0]|0)){c=0;return c|0}if((b[a+51>>0]|0)!=(b[c+51>>0]|0)){c=0;return c|0}if((b[a+52>>0]|0)!=(b[c+52>>0]|0)){c=0;return c|0}if((b[a+53>>0]|0)!=(b[c+53>>0]|0)){c=0;return c|0}if((b[a+54>>0]|0)!=(b[c+54>>0]|0)){c=0;return c|0}if((b[a+55>>0]|0)!=(b[c+55>>0]|0)){c=0;return c|0}if((b[a+56>>0]|0)!=(b[c+56>>0]|0)){c=0;return c|0}if((b[a+57>>0]|0)!=(b[c+57>>0]|0)){c=0;return c|0}if((b[a+58>>0]|0)!=(b[c+58>>0]|0)){c=0;return c|0}if((b[a+59>>0]|0)!=(b[c+59>>0]|0)){c=0;return c|0}c=(b[a+60>>0]|0)==(b[c+60>>0]|0);return c|0}function d_a(a){a=a|0;return 48}function e_a(a,c){a=a|0;c=c|0;var d=0;if((c|0)==(a|0)){c=1;return c|0}if(!(gSa(a,c)|0)){c=0;return c|0}d=f[c+16>>2]|0;c=f[a+16>>2]|0;f[c>>2]=f[d>>2];f[c+4>>2]=f[d+4>>2];f[c+8>>2]=f[d+8>>2];f[c+12>>2]=f[d+12>>2];f[c+16>>2]=f[d+16>>2];f[c+20>>2]=f[d+20>>2];b[c+24>>0]=b[d+24>>0]|0;c=1;return c|0}function f_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=m_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function g_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=m_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function h_a(a){a=a|0;var b=0;f[a>>2]=71944;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function i_a(a){a=a|0;h_a(a);jpd(a);return}function j_a(a){a=a|0;var b=0;b=gpd(20)|0;k_a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function k_a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=71944;b=gpd(28)|0;l_a(b);f[a+16>>2]=b;return}function l_a(a){a=a|0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;n[a+4>>2]=3.0;n[a+8>>2]=1.0;n[a+12>>2]=0.0;n[a+16>>2]=360.0;f[a+20>>2]=5;b[a+24>>0]=0;return}function m_a(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if(!(+n[a+16>>2]==+n[c+16>>2])){c=0;return c|0}if((f[a+20>>2]|0)!=(f[c+20>>2]|0)){c=0;return c|0}c=(b[a+24>>0]|0)==(b[c+24>>0]|0);return c|0}function n_a(a){a=a|0;return 49}function o_a(a,b){a=a|0;b=b|0;var c=0;if((b|0)==(a|0)){b=1;return b|0}if(!(gSa(a,b)|0)){b=0;return b|0}c=f[b+16>>2]|0;b=f[a+16>>2]|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];f[b+12>>2]=f[c+12>>2];f[b+16>>2]=f[c+16>>2];f[b+20>>2]=f[c+20>>2];f[b+24>>2]=f[c+24>>2];b=1;return b|0}function p_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=w_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function q_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=w_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function r_a(a){a=a|0;var b=0;f[a>>2]=72044;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function s_a(a){a=a|0;r_a(a);jpd(a);return}function t_a(a){a=a|0;var b=0;b=gpd(20)|0;u_a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function u_a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=72044;b=gpd(28)|0;v_a(b);f[a+16>>2]=b;return}function v_a(a){a=a|0;n[a>>2]=5.0;f[a+4>>2]=5;f[a+8>>2]=3;b[a+12>>0]=1;f[a+16>>2]=200;f[a+20>>2]=0;f[a+24>>2]=0;return}function w_a(a,c){a=a|0;c=c|0;if(!(+n[a>>2]==+n[c>>2])){c=0;return c|0}if((f[a+4>>2]|0)!=(f[c+4>>2]|0)){c=0;return c|0}if((f[a+8>>2]|0)!=(f[c+8>>2]|0)){c=0;return c|0}if((b[a+12>>0]|0)!=(b[c+12>>0]|0)){c=0;return c|0}if((f[a+16>>2]|0)!=(f[c+16>>2]|0)){c=0;return c|0}if((f[a+20>>2]|0)!=(f[c+20>>2]|0)){c=0;return c|0}c=(f[a+24>>2]|0)==(f[c+24>>2]|0);return c|0}function x_a(a){a=a|0;return 38}function y_a(a,c){a=a|0;c=c|0;var d=0;if((c|0)==(a|0)){c=1;return c|0}if(!(gSa(a,c)|0)){c=0;return c|0}d=f[c+16>>2]|0;c=f[a+16>>2]|0;f[c>>2]=f[d>>2];f[c+4>>2]=f[d+4>>2];f[c+8>>2]=f[d+8>>2];b[c+12>>0]=b[d+12>>0]|0;c=1;return c|0}function z_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=G_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function A_a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=G_a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function B_a(a){a=a|0;var b=0;f[a>>2]=72144;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function C_a(a){a=a|0;B_a(a);jpd(a);return}function D_a(a){a=a|0;var b=0;b=gpd(20)|0;E_a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function E_a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=72144;b=gpd(16)|0;F_a(b);f[a+16>>2]=b;return}function F_a(a){a=a|0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;b[a+3>>0]=0;n[a+4>>2]=3.0;f[a+8>>2]=16843009;b[a+12>>0]=0;return}function G_a(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if((b[a+3>>0]|0)!=(b[c+3>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if((b[a+8>>0]|0)!=(b[c+8>>0]|0)){c=0;return c|0}if((b[a+9>>0]|0)!=(b[c+9>>0]|0)){c=0;return c|0}if((b[a+10>>0]|0)!=(b[c+10>>0]|0)){c=0;return c|0}if((b[a+11>>0]|0)!=(b[c+11>>0]|0)){c=0;return c|0}c=(b[a+12>>0]|0)==(b[c+12>>0]|0);return c|0}function H_a(a){a=a|0;a=(f[a+4>>2]|0)+20|0;f[a>>2]=(f[a>>2]|0)+1;return}function I_a(a){a=a|0;var b=0,c=0;c=(f[a+4>>2]|0)+20|0;b=f[c>>2]|0;f[c>>2]=b-1;if((a|0)==0|(b|0)>1)return;Hd[f[(f[a>>2]|0)+12>>2]&1023](a);return}function J_a(a){a=a|0;var b=0;f[a>>2]=72248;b=f[a+4>>2]|0;if(b|0){P_a(b);jpd(b)}Q_a(a);return}function K_a(a){a=a|0;J_a(a);jpd(a);return}function L_a(a){a=a|0;return 10}function M_a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if((sd[f[(f[b>>2]|0)+16>>2]&2047](b)|0)!=10){b=0;return b|0}if((a|0)==(b|0)){b=1;return b|0}b=N_a(f[a+4>>2]|0,f[b+4>>2]|0)|0;return b|0}function N_a(a,b){a=a|0;b=b|0;var c=0;c=KCb(a+12|0)|0;if(Mdd(c,KCb(b+12|0)|0)|0){c=0;return c|0}c=O_a(a,b)|0;return c|0}function O_a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;e=h;if((f[a+8>>2]|0)!=(f[b+8>>2]|0)){g=0;t=h;return g|0}g=b+4|0;d=a+4|0;c=f[b>>2]|0;while(1){if((c|0)==(g|0)){b=1;c=14;break}vpd(e,c+16|0);b=xSa(a,e)|0;if((b|0)==(d|0))b=1;else{b=KCb(b+28|0)|0;b=(Mdd(b,KCb(c+28|0)|0)|0)!=0&1}Apd(e);if(b|0){b=0;c=14;break}b=f[c+4>>2]|0;if(!b)while(1){b=f[c+8>>2]|0;if((f[b>>2]|0)==(c|0))break;else c=b}else while(1){c=f[b>>2]|0;if(!c)break;else b=c}c=b}if((c|0)==14){t=h;return b|0}return 0}function P_a(a){a=a|0;ECb(a+12|0);gp(a);return}function Q_a(a){a=a|0;return}function R_a(a){a=a|0;a=(f[a+4>>2]|0)+44|0;f[a>>2]=(f[a>>2]|0)+1;return}function S_a(a){a=a|0;var b=0,c=0;c=(f[a+4>>2]|0)+44|0;b=f[c>>2]|0;f[c>>2]=b-1;if((a|0)==0|(b|0)>1)return;Hd[f[(f[a>>2]|0)+12>>2]&1023](a);return}function T_a(a){a=a|0;var b=0;f[a>>2]=72280;b=f[a+4>>2]|0;if(b|0){f$a(b);jpd(b)}Q_a(a);return}function U_a(a){a=a|0;T_a(a);jpd(a);return}function V_a(a){a=a|0;return 11}function W_a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;j=t;t=t+16|0;h=j;if(!b){i=0;t=j;return i|0}if((sd[f[(f[b>>2]|0)+16>>2]&2047](b)|0)!=11){i=0;t=j;return i|0}if((a|0)==(b|0)){i=1;t=j;return i|0}g=a+4|0;e=b+4|0;if(iZ((f[g>>2]|0)+16|0,(f[e>>2]|0)+16|0)|0){i=0;t=j;return i|0}a=f[g>>2]|0;c=f[e>>2]|0;b=(f[c+40>>2]|0)!=0;do if(!(f[a+40>>2]|0)){if(b){i=0;t=j;return i|0}}else{if(!b){i=0;t=j;return i|0}if(iZ(a+28|0,c+28|0)|0){i=0;t=j;return i|0}else{a=f[g>>2]|0;c=f[e>>2]|0;break}}while(0);k=f[a+8>>2]|0;b=f[a+4>>2]|0;a=f[c+4>>2]|0;d=k;if((k-b|0)!=((f[c+8>>2]|0)-a|0)){k=0;t=j;return k|0}while(1){if((b|0)==(d|0))break;X_a(h,b);k=Y_a(h)|0;c=Y_a(a)|0;if(k)if(c?(c=Z_a(h)|0,l=f[(f[c>>2]|0)+20>>2]|0,k=__a(a)|0,td[l&1023](c,k)|0):0)i=17;else c=0;else if(c)c=0;else i=17;if((i|0)==17){i=0;c=1;a=a+4|0}$_a(h);if(c)b=b+4|0;else{a=0;i=24;break}}if((i|0)==24){t=j;return a|0}l=a$a(f[g>>2]|0)|0;a=a$a(f[e>>2]|0)|0;if(l){if(a){k=b$a(f[g>>2]|0)|0;i=f[(f[k>>2]|0)+24>>2]|0;l=c$a(f[e>>2]|0)|0;l=td[i&1023](k,l)|0;t=j;return l|0}}else if(!a){l=1;t=j;return l|0}l=0;t=j;return l|0}function X_a(a,b){a=a|0;b=b|0;b=f[b>>2]|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Y_a(a){a=a|0;return (e$a(a,0)|0)^1|0}function Z_a(a){a=a|0;return f[a>>2]|0}function __a(a){a=a|0;return f[a>>2]|0}function $_a(a){a=a|0;a=f[a>>2]|0;if(!a)return;Hd[f[(f[a>>2]|0)+4>>2]&1023](a);return}function a$a(a){a=a|0;return (d$a(a,0)|0)^1|0}function b$a(a){a=a|0;return f[a>>2]|0}function c$a(a){a=a|0;return f[a>>2]|0}function d$a(a,b){a=a|0;b=b|0;return (f[a>>2]|0)==(b|0)|0}function e$a(a,b){a=a|0;b=b|0;return (f[a>>2]|0)==(b|0)|0}function f$a(a){a=a|0;g$a(a+4|0);h$a(a);return}function g$a(a){a=a|0;var b=0,c=0,d=0,e=0;c=f[a>>2]|0;if(!c)return;d=a+4|0;b=f[d>>2]|0;while(1){if((b|0)==(c|0))break;e=b+-4|0;$_a(e);b=e}f[d>>2]=c;jpd(f[a>>2]|0);return}function h$a(a){a=a|0;a=f[a>>2]|0;if(!a)return;Hd[f[(f[a>>2]|0)+4>>2]&1023](a);return}function i$a(a){a=a|0;a=(f[a+4>>2]|0)+36|0;f[a>>2]=(f[a>>2]|0)+1;return}function j$a(a){a=a|0;var b=0,c=0;c=(f[a+4>>2]|0)+36|0;b=f[c>>2]|0;f[c>>2]=b-1;if((a|0)==0|(b|0)>1)return;Hd[f[(f[a>>2]|0)+12>>2]&1023](a);return}function k$a(a){a=a|0;var b=0;f[a>>2]=72312;b=f[a+4>>2]|0;if(b|0){s$a(b);jpd(b)}Q_a(a);return}function l$a(a){a=a|0;k$a(a);jpd(a);return}function m$a(a){a=a|0;return 12}function n$a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;j=t;t=t+16|0;e=j;if(!b){i=0;t=j;return i|0}if((sd[f[(f[b>>2]|0)+16>>2]&2047](b)|0)!=12){i=0;t=j;return i|0}if((a|0)==(b|0)){i=1;t=j;return i|0}g=a+4|0;c=f[g>>2]|0;k=f[c+12>>2]|0;c=f[c+8>>2]|0;h=b+4|0;b=f[h>>2]|0;a=f[b+8>>2]|0;d=k;if((k-c|0)!=((f[b+12>>2]|0)-a|0)){k=0;t=j;return k|0}while(1){if((c|0)==(d|0))break;X_a(e,c);k=(__a(e)|0)==0;b=(__a(a)|0)!=0;if(k)if(b)b=0;else i=11;else if(b?(b=Z_a(e)|0,l=f[(f[b>>2]|0)+20>>2]|0,k=__a(a)|0,td[l&1023](b,k)|0):0)i=11;else b=0;if((i|0)==11){i=0;b=1;a=a+4|0}$_a(e);if(b)c=c+4|0;else{a=0;i=24;break}}if((i|0)==24){t=j;return a|0}l=o$a(f[g>>2]|0)|0;a=o$a(f[h>>2]|0)|0;if(l){if(!a){l=0;t=j;return l|0}k=p$a(f[g>>2]|0)|0;i=f[(f[k>>2]|0)+24>>2]|0;l=q$a(f[h>>2]|0)|0;if(!(td[i&1023](k,l)|0)){l=0;t=j;return l|0}}else if(a){l=0;t=j;return l|0}l=a$a((f[g>>2]|0)+4|0)|0;a=a$a((f[h>>2]|0)+4|0)|0;if(l){if(!a){l=0;t=j;return l|0}k=b$a((f[g>>2]|0)+4|0)|0;i=f[(f[k>>2]|0)+24>>2]|0;l=c$a((f[h>>2]|0)+4|0)|0;if(!(td[i&1023](k,l)|0)){l=0;t=j;return l|0}}else if(a){l=0;t=j;return l|0}b=f[g>>2]|0;a=f[h>>2]|0;if(!(+n[b+20>>2]==+n[a+20>>2])){l=0;t=j;return l|0}if((f[b+24>>2]|0)!=(f[a+24>>2]|0)){l=0;t=j;return l|0}l=(f[b+28>>2]|0)==(f[a+28>>2]|0);t=j;return l|0}function o$a(a){a=a|0;return (r$a(a,0)|0)^1|0}function p$a(a){a=a|0;return f[a>>2]|0}function q$a(a){a=a|0;return f[a>>2]|0}function r$a(a,b){a=a|0;b=b|0;return (f[a>>2]|0)==(b|0)|0}function s$a(a){a=a|0;g$a(a+8|0);h$a(a+4|0);t$a(a);return}function t$a(a){a=a|0;a=f[a>>2]|0;if(!a)return;Hd[f[(f[a>>2]|0)+4>>2]&1023](a);return}function u$a(a){a=a|0;return 107}function v$a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=107){b=0;return b|0}if((a|0)==(b|0)){b=1;return b|0}I$a(a+16|0,b+16|0)|0;b=1;return b|0}function w$a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=107){b=0;return b|0}if((a|0)==(b|0)){b=1;return b|0}b=W_a(a+16|0,b+16|0)|0;return b|0}function x$a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=107){b=0;return b|0}if((a|0)==(b|0)){b=1;return b|0}b=W_a(a+16|0,b+16|0)|0;return b|0}function y$a(a){a=a|0;f[a>>2]=72344;T_a(a+16|0);bSa(a);return}function z$a(a){a=a|0;y$a(a);jpd(a);return}function A$a(a){a=a|0;var b=0;b=gpd(24)|0;C$a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function B$a(a){a=a|0;return 13}function C$a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=72344;D$a(a+16|0);return}function D$a(a){a=a|0;var b=0;E$a(a);f[a>>2]=72280;b=gpd(48)|0;F$a(b);f[a+4>>2]=b;return}function E$a(a){a=a|0;Bm(a);f[a>>2]=72444;return}function F$a(a){a=a|0;G$a(a,0);f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;bfa(a+16|0);bfa(a+28|0);f[a+40>>2]=0;f[a+44>>2]=0;return}function G$a(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function H$a(a){a=a|0;Sc()}function I$a(a,b){a=a|0;b=b|0;J$a(a,b)|0;f[a+4>>2]=f[b+4>>2];return a|0}function J$a(a,b){a=a|0;b=b|0;K$a(a,b)|0;return a|0}function K$a(a,b){a=a|0;b=b|0;return a|0}function L$a(a){a=a|0;return 37}function M$a(a,c){a=a|0;c=c|0;var e=0,g=0,h=0;if((c|0)==(a|0)){h=1;return h|0}if(!(gSa(a,c)|0)){h=0;return h|0}h=f[c+16>>2]|0;c=f[a+16>>2]|0;a=c;e=h;g=a+48|0;do{f[a>>2]=f[e>>2];a=a+4|0;e=e+4|0}while((a|0)<(g|0));d[c+48>>1]=d[h+48>>1]|0;b[c+50>>0]=b[h+50>>0]|0;h=1;return h|0}function N$a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=U$a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function O$a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=U$a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function P$a(a){a=a|0;var b=0;f[a>>2]=72476;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function Q$a(a){a=a|0;P$a(a);jpd(a);return}function R$a(a){a=a|0;var b=0;b=gpd(20)|0;S$a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function S$a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=72476;b=gpd(52)|0;T$a(b);f[a+16>>2]=b;return}function T$a(a){a=a|0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;b[a+3>>0]=0;n[a+4>>2]=3.0;n[a+8>>2]=1.0;n[a+12>>2]=0.0;n[a+16>>2]=360.0;n[a+20>>2]=0.0;n[a+24>>2]=360.0;f[a+28>>2]=10;f[a+32>>2]=10;f[a+36>>2]=1;n[a+40>>2]=0.0;b[a+44>>0]=1;b[a+45>>0]=0;b[a+46>>0]=1;a=a+47|0;b[a>>0]=0;b[a+1>>0]=0;b[a+2>>0]=0;b[a+3>>0]=0;return}function U$a(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if((b[a+3>>0]|0)!=(b[c+3>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if(!(+n[a+16>>2]==+n[c+16>>2])){c=0;return c|0}if(!(+n[a+20>>2]==+n[c+20>>2])){c=0;return c|0}if(!(+n[a+24>>2]==+n[c+24>>2])){c=0;return c|0}if((f[a+28>>2]|0)!=(f[c+28>>2]|0)){c=0;return c|0}if((f[a+32>>2]|0)!=(f[c+32>>2]|0)){c=0;return c|0}if((f[a+36>>2]|0)!=(f[c+36>>2]|0)){c=0;return c|0}if(!(+n[a+40>>2]==+n[c+40>>2])){c=0;return c|0}if((b[a+44>>0]|0)!=(b[c+44>>0]|0)){c=0;return c|0}if((b[a+45>>0]|0)!=(b[c+45>>0]|0)){c=0;return c|0}if((b[a+46>>0]|0)!=(b[c+46>>0]|0)){c=0;return c|0}if((b[a+47>>0]|0)!=(b[c+47>>0]|0)){c=0;return c|0}if((b[a+48>>0]|0)!=(b[c+48>>0]|0)){c=0;return c|0}if((b[a+49>>0]|0)!=(b[c+49>>0]|0)){c=0;return c|0}c=(b[a+50>>0]|0)==(b[c+50>>0]|0);return c|0}function V$a(a){a=a|0;return 68}function W$a(a,b){a=a|0;b=b|0;var c=0;if((b|0)==(a|0)){c=1;return c|0}if(!(gSa(a,b)|0)){c=0;return c|0}c=f[a+16>>2]|0;a=f[b+16>>2]|0;b=c+56|0;do{f[c>>2]=f[a>>2];c=c+4|0;a=a+4|0}while((c|0)<(b|0));c=1;return c|0}function X$a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(hSa(a,b)|0)){b=0;return b|0}b=c0a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function Y$a(a,b){a=a|0;b=b|0;if((b|0)==(a|0)){b=1;return b|0}if(!(iSa(a,b)|0)){b=0;return b|0}b=c0a(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function Z$a(a){a=a|0;var b=0;f[a>>2]=72576;b=f[a+16>>2]|0;if(b|0)jpd(b);bSa(a);return}function _$a(a){a=a|0;Z$a(a);jpd(a);return}function $$a(a){a=a|0;var b=0;b=gpd(20)|0;a0a(b,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function a0a(a,b){a=a|0;b=b|0;$Ra(a,b);f[a>>2]=72576;b=gpd(56)|0;b0a(b);f[a+16>>2]=b;return}function b0a(a){a=a|0;var c=0;b[a>>0]=1;b[a+1>>0]=1;b[a+2>>0]=0;b[a+3>>0]=0;n[a+4>>2]=3.0;n[a+8>>2]=3.0;n[a+12>>2]=5.0;n[a+16>>2]=0.0;n[a+20>>2]=360.0;f[a+24>>2]=10;f[a+28>>2]=1;f[a+32>>2]=1;n[a+36>>2]=1.0;n[a+40>>2]=1.0;c=a+44|0;f[c>>2]=16843009;d[c+4>>1]=257;b[a+50>>0]=0;f[a+52>>2]=0;return}function c0a(a,c){a=a|0;c=c|0;if((b[a>>0]|0)!=(b[c>>0]|0)){c=0;return c|0}if((b[a+1>>0]|0)!=(b[c+1>>0]|0)){c=0;return c|0}if((b[a+2>>0]|0)!=(b[c+2>>0]|0)){c=0;return c|0}if((b[a+3>>0]|0)!=(b[c+3>>0]|0)){c=0;return c|0}if(!(+n[a+4>>2]==+n[c+4>>2])){c=0;return c|0}if(!(+n[a+8>>2]==+n[c+8>>2])){c=0;return c|0}if(!(+n[a+12>>2]==+n[c+12>>2])){c=0;return c|0}if(!(+n[a+16>>2]==+n[c+16>>2])){c=0;return c|0}if(!(+n[a+20>>2]==+n[c+20>>2])){c=0;return c|0}if((f[a+24>>2]|0)!=(f[c+24>>2]|0)){c=0;return c|0}if((f[a+28>>2]|0)!=(f[c+28>>2]|0)){c=0;return c|0}if((f[a+32>>2]|0)!=(f[c+32>>2]|0)){c=0;return c|0}if(!(+n[a+36>>2]==+n[c+36>>2])){c=0;return c|0}if(!(+n[a+40>>2]==+n[c+40>>2])){c=0;return c|0}if((b[a+44>>0]|0)!=(b[c+44>>0]|0)){c=0;return c|0}if((b[a+45>>0]|0)!=(b[c+45>>0]|0)){c=0;return c|0}if((b[a+46>>0]|0)!=(b[c+46>>0]|0)){c=0;return c|0}if((b[a+47>>0]|0)!=(b[c+47>>0]|0)){c=0;return c|0}if((b[a+48>>0]|0)!=(b[c+48>>0]|0)){c=0;return c|0}if((b[a+49>>0]|0)!=(b[c+49>>0]|0)){c=0;return c|0}if((b[a+50>>0]|0)!=(b[c+50>>0]|0)){c=0;return c|0}c=(f[a+52>>2]|0)==(f[c+52>>2]|0);return c|0}function d0a(a){a=a|0;return 7}function e0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if(!b){e=0;return e|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=7){e=0;return e|0}p0a(a,b)|0;e=b+16|0;b=f[e>>2]|0;d=a+16|0;a=f[d>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];a=f[e>>2]|0;b=f[d>>2]|0;if((b|0)==(a|0)){c=a;b=a}else{jYa(b+16|0,f[a+16>>2]|0,f[a+20>>2]|0);c=f[e>>2]|0;b=f[d>>2]|0}q0a(b+28|0,c+28|0)|0;q0a((f[d>>2]|0)+32|0,(f[e>>2]|0)+32|0)|0;c=f[e>>2]|0;e=f[d>>2]|0;f[e+36>>2]=f[c+36>>2];f[e+40>>2]=f[c+40>>2];f[e+44>>2]=f[c+44>>2];f[e+48>>2]=f[c+48>>2];f[e+52>>2]=f[c+52>>2];e=1;return e|0}function f0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;if(!b){h=0;return h|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=7){h=0;return h|0}if(!(m0a(a,b)|0)){h=0;return h|0}g=a+16|0;e=b+16|0;if(!(Fn(f[g>>2]|0,f[e>>2]|0)|0)){h=0;return h|0}c=f[g>>2]|0;i=f[e>>2]|0;j=f[c+20>>2]|0;b=f[c+16>>2]|0;a=f[i+16>>2]|0;d=j;if((j-b|0)!=((f[i+20>>2]|0)-a|0)){j=0;return j|0}while(1){if((b|0)==(d|0))break;if(!(+n[b>>2]==+n[a>>2])){a=0;h=23;break}a=a+4|0;b=b+4|0}if((h|0)==23)return a|0;j=n0a(c+28|0)|0;if((j|0)!=(n0a((f[e>>2]|0)+28|0)|0)){if(!(n0a((f[g>>2]|0)+28|0)|0)){j=0;return j|0}if(!(n0a((f[e>>2]|0)+28|0)|0)){j=0;return j|0}i=o0a((f[g>>2]|0)+28|0)|0;h=f[(f[i>>2]|0)+24>>2]|0;j=n0a((f[e>>2]|0)+28|0)|0;if(!(td[h&1023](i,j)|0)){j=0;return j|0}}j=n0a((f[g>>2]|0)+32|0)|0;if((j|0)!=(n0a((f[e>>2]|0)+32|0)|0)){if(!(n0a((f[g>>2]|0)+32|0)|0)){j=0;return j|0}if(!(n0a((f[e>>2]|0)+32|0)|0)){j=0;return j|0}i=o0a((f[g>>2]|0)+32|0)|0;h=f[(f[i>>2]|0)+24>>2]|0;j=n0a((f[e>>2]|0)+32|0)|0;if(!(td[h&1023](i,j)|0)){j=0;return j|0}}b=f[g>>2]|0;a=f[e>>2]|0;if(!(+n[b+36>>2]==+n[a+36>>2])){j=0;return j|0}if(!(+n[b+40>>2]==+n[a+40>>2])){j=0;return j|0}if(!(+n[b+44>>2]==+n[a+44>>2])){j=0;return j|0}if((f[b+48>>2]|0)!=(f[a+48>>2]|0)){j=0;return j|0}j=(f[b+52>>2]|0)==(f[a+52>>2]|0);return j|0}function g0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;if(!b){h=0;return h|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=7){h=0;return h|0}if(!(m0a(a,b)|0)){h=0;return h|0}g=a+16|0;e=b+16|0;if(!(Fn(f[g>>2]|0,f[e>>2]|0)|0)){h=0;return h|0}c=f[g>>2]|0;i=f[e>>2]|0;j=f[c+20>>2]|0;b=f[c+16>>2]|0;a=f[i+16>>2]|0;d=j;if((j-b|0)!=((f[i+20>>2]|0)-a|0)){j=0;return j|0}while(1){if((b|0)==(d|0))break;if(!(+n[b>>2]==+n[a>>2])){a=0;h=23;break}a=a+4|0;b=b+4|0}if((h|0)==23)return a|0;j=n0a(c+28|0)|0;if((j|0)!=(n0a((f[e>>2]|0)+28|0)|0)){if(!(n0a((f[g>>2]|0)+28|0)|0)){j=0;return j|0}if(!(n0a((f[e>>2]|0)+28|0)|0)){j=0;return j|0}i=o0a((f[g>>2]|0)+28|0)|0;h=f[(f[i>>2]|0)+24>>2]|0;j=n0a((f[e>>2]|0)+28|0)|0;if(!(td[h&1023](i,j)|0)){j=0;return j|0}}j=n0a((f[g>>2]|0)+32|0)|0;if((j|0)!=(n0a((f[e>>2]|0)+32|0)|0)){if(!(n0a((f[g>>2]|0)+32|0)|0)){j=0;return j|0}if(!(n0a((f[e>>2]|0)+32|0)|0)){j=0;return j|0}i=o0a((f[g>>2]|0)+32|0)|0;h=f[(f[i>>2]|0)+24>>2]|0;j=n0a((f[e>>2]|0)+32|0)|0;if(!(td[h&1023](i,j)|0)){j=0;return j|0}}b=f[g>>2]|0;a=f[e>>2]|0;if(!(+n[b+36>>2]==+n[a+36>>2])){j=0;return j|0}if(!(+n[b+40>>2]==+n[a+40>>2])){j=0;return j|0}if(!(+n[b+44>>2]==+n[a+44>>2])){j=0;return j|0}if((f[b+48>>2]|0)!=(f[a+48>>2]|0)){j=0;return j|0}j=(f[b+52>>2]|0)==(f[a+52>>2]|0);return j|0}function h0a(a){a=a|0;var b=0;f[a>>2]=72676;b=f[a+16>>2]|0;if(b|0){l0a(b);jpd(b)}em(a);return}function i0a(a){a=a|0;h0a(a);jpd(a);return}function j0a(a,b){a=a|0;b=b|0;f[a+12>>2]=b;return a|0}function k0a(a){a=a|0;return f[a+12>>2]|0}function l0a(a){a=a|0;fSa(a+32|0);fSa(a+28|0);ke(a+16|0);return}function m0a(a,b){a=a|0;b=b|0;return (f[a+12>>2]|0)==(f[b+12>>2]|0)|0}function n0a(a){a=a|0;return f[a>>2]|0}function o0a(a){a=a|0;return f[a>>2]|0}function p0a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}f[a+12>>2]=f[b+12>>2];b=1;return b|0}function q0a(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[f[b>>2]>>2]&1023](b);return a|0}function r0a(a){a=a|0;return 8}function s0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if(!b){e=0;return e|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=8){e=0;return e|0}F0a(a,b)|0;e=b+16|0;c=(f[e>>2]|0)+128|0;d=a+16|0;b=(f[d>>2]|0)+128|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];b=(f[e>>2]|0)+140|0;a=(f[d>>2]|0)+140|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];a=f[e>>2]|0;b=f[d>>2]|0;if((b|0)==(a|0)){c=a;b=a}else{G0a(b+152|0,f[a+152>>2]|0,f[a+156>>2]|0);c=f[e>>2]|0;b=f[d>>2]|0}q0a(b+164|0,c+164|0)|0;c=f[e>>2]|0;a=f[d>>2]|0;f[a+168>>2]=f[c+168>>2];f[a+172>>2]=f[c+172>>2];f[a+176>>2]=f[c+176>>2];eH(a,c)|0;f[(f[d>>2]|0)+180>>2]=f[(f[e>>2]|0)+180>>2];e=1;return e|0}function t0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;if(!b){g=0;return g|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=8){g=0;return g|0}if(!(E0a(a,b)|0)){g=0;return g|0}e=a+16|0;d=b+16|0;if(!(Rn((f[e>>2]|0)+128|0,(f[d>>2]|0)+128|0)|0)){g=0;return g|0}if(!(Rn((f[e>>2]|0)+140|0,(f[d>>2]|0)+140|0)|0)){g=0;return g|0}b=f[e>>2]|0;h=f[d>>2]|0;i=f[b+156>>2]|0;b=f[b+152>>2]|0;a=f[h+152>>2]|0;c=i;if((i-b|0)!=((f[h+156>>2]|0)-a|0)){i=0;return i|0}while(1){if((b|0)==(c|0))break;if(!(C0a(b,a)|0)){a=0;g=20;break}a=a+20|0;b=b+20|0}if((g|0)==20)return a|0;i=n0a((f[e>>2]|0)+164|0)|0;if((i|0)!=(n0a((f[d>>2]|0)+164|0)|0)){if(!(n0a((f[e>>2]|0)+164|0)|0)){i=0;return i|0}if(!(n0a((f[d>>2]|0)+164|0)|0)){i=0;return i|0}h=o0a((f[e>>2]|0)+164|0)|0;g=f[(f[h>>2]|0)+24>>2]|0;i=n0a((f[d>>2]|0)+164|0)|0;if(!(td[g&1023](h,i)|0)){i=0;return i|0}}a=f[e>>2]|0;b=f[d>>2]|0;if(!(+n[a+168>>2]==+n[b+168>>2])){i=0;return i|0}if(!(+n[a+172>>2]==+n[b+172>>2])){i=0;return i|0}if((f[a+176>>2]|0)!=(f[b+176>>2]|0)){i=0;return i|0}if(!(D0a(a,b)|0)){i=0;return i|0}i=(f[(f[e>>2]|0)+180>>2]|0)==(f[(f[d>>2]|0)+180>>2]|0);return i|0}function u0a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;if(!b){g=0;return g|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=8){g=0;return g|0}if(!(B0a(a,b)|0)){g=0;return g|0}e=a+16|0;d=b+16|0;if(!(Rn((f[e>>2]|0)+128|0,(f[d>>2]|0)+128|0)|0)){g=0;return g|0}if(!(Rn((f[e>>2]|0)+140|0,(f[d>>2]|0)+140|0)|0)){g=0;return g|0}b=f[e>>2]|0;h=f[d>>2]|0;i=f[b+156>>2]|0;b=f[b+152>>2]|0;a=f[h+152>>2]|0;c=i;if((i-b|0)!=((f[h+156>>2]|0)-a|0)){i=0;return i|0}while(1){if((b|0)==(c|0))break;if(!(C0a(b,a)|0)){a=0;g=20;break}a=a+20|0;b=b+20|0}if((g|0)==20)return a|0;i=n0a((f[e>>2]|0)+164|0)|0;if((i|0)!=(n0a((f[d>>2]|0)+164|0)|0)){if(!(n0a((f[e>>2]|0)+164|0)|0)){i=0;return i|0}if(!(n0a((f[d>>2]|0)+164|0)|0)){i=0;return i|0}h=o0a((f[e>>2]|0)+164|0)|0;g=f[(f[h>>2]|0)+24>>2]|0;i=n0a((f[d>>2]|0)+164|0)|0;if(!(td[g&1023](h,i)|0)){i=0;return i|0}}a=f[e>>2]|0;b=f[d>>2]|0;if(!(+n[a+168>>2]==+n[b+168>>2])){i=0;return i|0}if(!(+n[a+172>>2]==+n[b+172>>2])){i=0;return i|0}if((f[a+176>>2]|0)!=(f[b+176>>2]|0)){i=0;return i|0}if(!(D0a(a,b)|0)){i=0;return i|0}i=(f[(f[e>>2]|0)+180>>2]|0)==(f[(f[d>>2]|0)+180>>2]|0);return i|0}function v0a(a){a=a|0;var b=0;f[a>>2]=72748;b=f[a+16>>2]|0;if(b|0){z0a(b);jpd(b)}em(a);return}function w0a(a){a=a|0;v0a(a);jpd(a);return}function x0a(a,b){a=a|0;b=b|0;f[a+12>>2]=b;return a|0}function y0a(a){a=a|0;return f[a+12>>2]|0}function z0a(a){a=a|0;fSa(a+164|0);A0a(a+152|0);return}function A0a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function B0a(a,b){a=a|0;b=b|0;return (f[a+12>>2]|0)==(f[b+12>>2]|0)|0}function C0a(a,b){a=a|0;b=b|0;if(!(+n[a>>2]==+n[b>>2])){b=0;return b|0}b=Fn(a+4|0,b+4|0)|0;return b|0}function D0a(a,b){a=a|0;b=b|0;return rP(a,b)|0}function E0a(a,b){a=a|0;b=b|0;return (f[a+12>>2]|0)==(f[b+12>>2]|0)|0}function F0a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}f[a+12>>2]=f[b+12>>2];b=1;return b|0}function G0a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;d=b;k=(c-d|0)/20|0;e=a+8|0;j=f[a>>2]|0;i=j;if(k>>>0>(((f[e>>2]|0)-j|0)/20|0)>>>0){I0a(a);d=J0a(a)|0;if(d>>>0<k>>>0)kqd(a);i=((f[e>>2]|0)-(f[a>>2]|0)|0)/20|0;j=i<<1;K0a(a,i>>>0<d>>>1>>>0?(j>>>0<k>>>0?k:j):d);H0a(a,b,c,k);return}e=a+4|0;h=((f[e>>2]|0)-j|0)/20|0;g=k>>>0>h>>>0;h=g?b+(h*20|0)|0:c;d=h-d|0;if(d|0)Lrd(j|0,b|0,d|0)|0;if(g){H0a(a,h,c,k-(((f[e>>2]|0)-(f[a>>2]|0)|0)/20|0)|0);return}else{f[e>>2]=i+(((d|0)/20|0)*20|0);return}}function H0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=a+4|0;while(1){if((b|0)==(c|0))break;L0a(f[a>>2]|0,b);f[a>>2]=(f[a>>2]|0)+20;b=b+20|0}return}function I0a(a){a=a|0;var b=0,c=0;b=f[a>>2]|0;if(!b)return;c=a+4|0;f[c>>2]=b;jpd(b);f[a+8>>2]=0;f[c>>2]=0;f[a>>2]=0;return}function J0a(a){a=a|0;return 214748364}function K0a(a,b){a=a|0;b=b|0;var c=0;if((J0a(a)|0)>>>0<b>>>0)kqd(a);if(b>>>0>214748364){b=yb(8)|0;qpd(b,113720);f[b>>2]=81900;Fb(b|0,42448,796)}else{c=gpd(b*20|0)|0;f[a+4>>2]=c;f[a>>2]=c;f[a+8>>2]=c+(b*20|0);return}}function L0a(a,b){a=a|0;b=b|0;f[a>>2]=f[b>>2];ns(a+4|0,b+4|0);return}function M0a(a){a=a|0;E1a(a,73100);return}function N0a(a){a=a|0;M0a(a);jpd(a);return}function O0a(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+160|0;i=l+16|0;j=l;k=gpd(36)|0;l1a(k);g=c+20|0;h=ie((f[g>>2]|0)+4|0)|0;e=vd[f[(f[h>>2]|0)+32>>2]&255](h,d,e)|0;if(!e){o1a(k);p1a(a,k);t=l;return}c=sd[f[(f[e>>2]|0)+204>>2]&2047](e)|0;if(c|0){m1a(c+12|0,k);Jd[f[(f[c>>2]|0)+28>>2]&1023](i,c);n1a(k,i);mm(i)}d=sd[f[(f[e>>2]|0)+212>>2]&2047](e)|0;if(d|0){if(f1a(d)|0){c=g1a(f[f[g>>2]>>2]|0,d)|0;if(c|0)m1a(c+16|0,k)}else m1a(d+16|0,k);Jd[f[(f[d>>2]|0)+48>>2]&1023](i,d);n1a(k,i);mm(i)}c=sd[f[(f[e>>2]|0)+208>>2]&2047](e)|0;if(c|0){m1a(c+20|0,k);Jd[f[(f[c>>2]|0)+36>>2]&1023](i,c);n1a(k,i);mm(i)}d=sd[f[(f[e>>2]|0)+188>>2]&2047](e)|0;e=G;h=i+56|0;g=i+4|0;f[i>>2]=36940;f[h>>2]=36960;cgd(i+56|0,g);f[i+128>>2]=0;c=Tk()|0;f[i+132>>2]=c;f[i>>2]=46940;f[h>>2]=46960;fgd(g);f[g>>2]=46976;h=i+36|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[h+(c<<2)>>2]=0;c=c+1|0}f[i+48>>2]=0;f[i+52>>2]=16;qgd(i,d,e)|0;h=gpd(4)|0;um(h,94197,83546);NH(j,g);lm(h,83543,(b[j+11>>0]|0)<0?f[j>>2]|0:j);Apd(j);D1a(k,h);OH(i);o1a(k);p1a(a,k);t=l;return}function P0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+16|0;e=h;g=gpd(36)|0;l1a(g);b=ie((f[b+20>>2]|0)+4|0)|0;b=vd[f[(f[b>>2]|0)+52>>2]&255](b,c,d)|0;if(b|0?((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)+-122|0)>>>0<3:0){m1a(b+12|0,g);Jd[f[(f[b>>2]|0)+28>>2]&1023](e,b);n1a(g,e);mm(e)}o1a(g);p1a(a,g);t=h;return}function Q0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;e=a+20|0;a=ie((f[e>>2]|0)+4|0)|0;a=vd[f[(f[a>>2]|0)+32>>2]&255](a,b,c)|0;if(!a){g=0;return g|0}switch(d|0){case 2:{a=sd[f[(f[a>>2]|0)+204>>2]&2047](a)|0;if(!a){g=0;return g|0}g=wA(a)|0;return g|0}case 3:{a=sd[f[(f[a>>2]|0)+208>>2]&2047](a)|0;if(!a){g=0;return g|0}g=wA(a+8|0)|0;return g|0}default:{a=sd[f[(f[a>>2]|0)+212>>2]&2047](a)|0;if(!a){g=0;return g|0}if(f1a(a)|0?(g=g1a(f[f[e>>2]>>2]|0,a)|0,g|0):0){g=wA(g+4|0)|0;return g|0}g=wA(a+4|0)|0;return g|0}}return 0}function R0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;b=ie((f[b+20>>2]|0)+4|0)|0;Fy(a,vd[f[(f[b>>2]|0)+40>>2]&255](b,c,d)|0);return}function S0a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;i=t;t=t+160|0;g=i+12|0;h=i;if(!c){Fy(a,0);t=i;return};f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;wpd(h,c,Th(c)|0);d=g+60|0;e=g+8|0;f[g>>2]=39460;f[d>>2]=39480;f[g+4>>2]=0;cgd(g+60|0,e);f[g+132>>2]=0;c=Tk()|0;f[g+136>>2]=c;f[g>>2]=73008;f[d>>2]=73028;fgd(e);f[e>>2]=46976;d=g+40|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[d+(c<<2)>>2]=0;c=c+1|0}f[g+52>>2]=0;f[g+56>>2]=8;Hea(e,h);Apd(h);kgd(g,h)|0;b=ie((f[b+20>>2]|0)+4|0)|0;Fy(a,vd[f[(f[b>>2]|0)+40>>2]&255](b,f[h>>2]|0,f[h+4>>2]|0)|0);a1a(g);t=i;return}function T0a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+176|0;g=j+24|0;h=j;i=j+16|0;Om(i,c,83543);d=ICb(i)|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;wpd(h,d,Th(d)|0);d=g+60|0;e=g+8|0;f[g>>2]=39460;f[d>>2]=39480;f[g+4>>2]=0;cgd(g+60|0,e);f[g+132>>2]=0;c=Tk()|0;f[g+136>>2]=c;f[g>>2]=73008;f[d>>2]=73028;fgd(e);f[e>>2]=46976;d=g+40|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[d+(c<<2)>>2]=0;c=c+1|0}f[g+52>>2]=0;f[g+56>>2]=8;Hea(e,h);Apd(h);ECb(i);kgd(g,h)|0;i=h;Md[f[(f[b>>2]|0)+36>>2]&31](a,b,f[i>>2]|0,f[i+4>>2]|0);a1a(g);t=j;return}function U0a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;j=k;i=b+20|0;b=ie((f[i>>2]|0)+4|0)|0;c=vd[f[(f[b>>2]|0)+32>>2]&255](b,c,d)|0;a:do if(c|0)switch(e|0){case 2:{b=sd[f[(f[c>>2]|0)+204>>2]&2047](c)|0;if(b|0){Jd[f[(f[b>>2]|0)+128>>2]&1023](a,b);t=k;return}b=sd[f[(f[c>>2]|0)+216>>2]&2047](c)|0;g=ie((f[i>>2]|0)+4|0)|0;if(!(sd[f[(f[g>>2]|0)+20>>2]&2047](g)|0))break a;i=ie((f[i>>2]|0)+4|0)|0;Kd[f[(f[i>>2]|0)+24>>2]&255](j,i,0);i=vf(j)|0;i=i+((f[(f[i>>2]|0)+-28>>2]|0)+4)|0;b=td[f[(f[i>>2]|0)+36>>2]&1023](i,b)|0;if(b|0?(h=sd[f[(f[b>>2]|0)+204>>2]&2047](b)|0,h|0):0){Jd[f[(f[h>>2]|0)+128>>2]&1023](a,h);uf(j);t=k;return}uf(j);break a}case 3:{b=sd[f[(f[c>>2]|0)+208>>2]&2047](c)|0;if(!b)break a;Jd[f[(f[b>>2]|0)+68>>2]&1023](a,b);t=k;return}default:{b=sd[f[(f[c>>2]|0)+212>>2]&2047](c)|0;if(b|0){jD(a,b+4|0);t=k;return}b=sd[f[(f[c>>2]|0)+216>>2]&2047](c)|0;h=ie((f[i>>2]|0)+4|0)|0;if(!(sd[f[(f[h>>2]|0)+20>>2]&2047](h)|0))break a;i=ie((f[i>>2]|0)+4|0)|0;Kd[f[(f[i>>2]|0)+24>>2]&255](j,i,0);i=vf(j)|0;i=i+((f[(f[i>>2]|0)+-28>>2]|0)+4)|0;b=td[f[(f[i>>2]|0)+36>>2]&1023](i,b)|0;if(b|0?(g=sd[f[(f[b>>2]|0)+212>>2]&2047](b)|0,g|0):0){jD(a,g+4|0);uf(j);t=k;return}uf(j);break a}}while(0);xCb(a);t=k;return}function V0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;O0a(a,b+(f[(f[b>>2]|0)+-32>>2]|0)|0,c,d);return}function W0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;P0a(a,b+(f[(f[b>>2]|0)+-36>>2]|0)|0,c,d);return}function X0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Q0a(a+(f[(f[a>>2]|0)+-40>>2]|0)|0,b,c,d)|0}function Y0a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;R0a(a,b+(f[(f[b>>2]|0)+-44>>2]|0)|0,c,d);return}function Z0a(a,b,c){a=a|0;b=b|0;c=c|0;S0a(a,b+(f[(f[b>>2]|0)+-48>>2]|0)|0,c);return}function _0a(a,b,c){a=a|0;b=b|0;c=c|0;T0a(a,b+(f[(f[b>>2]|0)+-52>>2]|0)|0,c);return}function $0a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;U0a(a,b+(f[(f[b>>2]|0)+-56>>2]|0)|0,c,d,e);return}function a1a(a){a=a|0;b1a(a,73036);qfd(a+60|0);return}function b1a(a,b){a=a|0;b=b|0;var c=0;c=f[b>>2]|0;f[a>>2]=c;f[a+(f[c+-12>>2]|0)>>2]=f[b+12>>2];QH(a+8|0);Qfd(a,b+4|0);return}function c1a(a){a=a|0;a1a(a);jpd(a);return}function d1a(a){a=a|0;a1a(a+(f[(f[a>>2]|0)+-12>>2]|0)|0);return}function e1a(a){a=a|0;c1a(a+(f[(f[a>>2]|0)+-12>>2]|0)|0);return}function f1a(a){a=a|0;var c=0;a=f[a+24>>2]|0;c=b[a+56+11>>0]|0;if(c<<24>>24<0){c=f[a+60>>2]|0;c=(c|0)!=0;return c|0}else{c=c&255;c=(c|0)!=0;return c|0}return 0}function g1a(a,b){a=a|0;b=b|0;var c=0;c=h1a(b)|0;if(c|0){b=c;return b|0}c=i1a(b)|0;if(!c){b=0;return b|0}b=k1a(a,c,j1a(b)|0)|0;return b|0}function h1a(a){a=a|0;return rH((f[a+24>>2]|0)+80|0)|0}function i1a(a){a=a|0;a=(f[a+24>>2]|0)+56|0;if((b[a+11>>0]|0)<0){a=f[a>>2]|0;return a|0}else return a|0;return 0}function j1a(a){a=a|0;a=(f[a+24>>2]|0)+68|0;if((b[a+11>>0]|0)<0){a=f[a>>2]|0;return a|0}else return a|0;return 0}function k1a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;o=t;t=t+32|0;i=o+16|0;j=o+8|0;k=o;if(!a){n=0;t=o;return n|0}l=MN(a)|0;m=(c|0)==0;d=0;g=0;while(1){if(g>>>0>=l>>>0){d=0;n=11;break}e=NN(a,g)|0;Jd[f[(f[e>>2]|0)+48>>2]&1023](i,e);Om(j,i,83543);do if(!(ncd(ICb(j)|0,b)|0))if(!m){Om(k,i,87777);h=(ncd(ICb(k)|0,c)|0)==0;ECb(k);ECb(j);if(h){h=0;d=e;break}else{n=9;break}}else{ECb(j);h=0;d=e;break}else{ECb(j);n=9}while(0);if((n|0)==9){n=0;h=1}mm(i);if(h)g=g+1|0;else{n=11;break}}if((n|0)==11){t=o;return d|0}return 0}function l1a(a){a=a|0;v1a(a);f[a>>2]=73060;a=a+4|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}function m1a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;g=k;h=sd[f[f[a>>2]>>2]&2047](a)|0;i=b+8|0;j=b+12|0;e=b+4|0;b=0;while(1){if((b|0)==(h|0))break;c=td[f[(f[a>>2]|0)+4>>2]&1023](a,b)|0;f[g>>2]=c;d=f[i>>2]|0;if(d>>>0<(f[j>>2]|0)>>>0){f[d>>2]=c;f[i>>2]=(f[i>>2]|0)+4}else q1a(e,g);b=b+1|0}t=k;return}function n1a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;d=h+4|0;g=h;e=gpd(4)|0;sv(e,b);f[d>>2]=e;b=a+20|0;c=f[b>>2]|0;if((c|0)==(f[a+24>>2]|0))kv(a+16|0,d);else{f[c>>2]=e;f[b>>2]=(f[b>>2]|0)+4}b=f[d>>2]|0;f[g>>2]=b;c=a+8|0;d=f[c>>2]|0;if(d>>>0<(f[a+12>>2]|0)>>>0){f[d>>2]=b;f[c>>2]=(f[c>>2]|0)+4;t=h;return}else{q1a(a+4|0,g);t=h;return}}function o1a(a){a=a|0;f[a+28>>2]=f[a+4>>2];f[a+32>>2]=f[a+8>>2];return}function p1a(a,b){a=a|0;b=b|0;f[a>>2]=44792;f[a+4>>2]=b;return}function q1a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=r1a(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;s1a(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;t1a(a,c);u1a(c);t=h;return}}function r1a(a){a=a|0;return 1073741823}function s1a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function t1a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function u1a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function v1a(a){a=a|0;f[a>>2]=73084;return}function w1a(a){a=a|0;var b=0,c=0;c=a+28|0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;return (b|0)!=(f[a+32>>2]|0)|0}function x1a(a){a=a|0;var b=0;b=f[a+28>>2]|0;if((b|0)==(f[a+32>>2]|0)){b=0;return b|0}b=f[b>>2]|0;return b|0}function y1a(a){a=a|0;var b=0;f[a>>2]=73060;b=a+16|0;hv(b);Ov(b);A1a(a+4|0);B1a(a);return}function z1a(a){a=a|0;y1a(a);jpd(a);return}function A1a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function B1a(a){a=a|0;return}function C1a(a){a=a|0;Sc()}function D1a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;c=h;g=h+4|0;f[c>>2]=b;d=a+20|0;e=f[d>>2]|0;if((e|0)==(f[a+24>>2]|0))kv(a+16|0,c);else{f[e>>2]=b;f[d>>2]=(f[d>>2]|0)+4}b=f[c>>2]|0;f[g>>2]=b;c=a+8|0;d=f[c>>2]|0;if(d>>>0<(f[a+12>>2]|0)>>>0){f[d>>2]=b;f[c>>2]=(f[c>>2]|0)+4;t=h;return}else{q1a(a+4|0,g);t=h;return}}function E1a(a,b){a=a|0;b=b|0;var c=0;c=f[b>>2]|0;f[a>>2]=c;f[a+(f[c+-28>>2]|0)>>2]=f[b+12>>2];f[a+(f[(f[a>>2]|0)+-32>>2]|0)>>2]=f[b+16>>2];a=a+20|0;b=f[a>>2]|0;if(!b){f[a>>2]=0;return}F1a(b);jpd(b);f[a>>2]=0;return}function F1a(a){a=a|0;pf(a+4|0);return}function G1a(a){a=a|0;return 222}function H1a(a,b){a=a|0;b=b|0;var c=0;c=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((c|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){c=0;return c|0}Z1a(f[a+12>>2]|0,f[b+12>>2]|0);c=1;return c|0}function I1a(a,b){a=a|0;b=b|0;var c=0;c=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((c|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){c=0;return c|0}c=W1a(f[a+12>>2]|0,f[b+12>>2]|0)|0;return c|0}function J1a(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;if(!(td[f[(f[a>>2]|0)+20>>2]&1023](a,b)|0)){c=0;t=d;return c|0}b=sd[f[(f[b>>2]|0)+32>>2]&2047](b)|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;wpd(c,b,Th(b)|0);b=(Qpd(c,sd[f[(f[a>>2]|0)+32>>2]&2047](a)|0)|0)==0;Apd(c);c=b;t=d;return c|0}function K1a(a){a=a|0;var b=0,c=0;f[a>>2]=73136;b=a+12|0;c=f[b>>2]|0;if(c|0)jpd(c);f[b>>2]=0;dm(a);return}function L1a(a){a=a|0;K1a(a);jpd(a);return}function M1a(a){a=a|0;return 0}function N1a(a){a=a|0;var b=0;b=gpd(16)|0;T1a(b,$l(a)|0,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function O1a(a){a=a|0;return 16}function P1a(a,b,c){a=a|0;b=b|0;c=c|0;if((b|0)==9){a=a+12|0;b=Xo(c,f[(f[a>>2]|0)+24>>2]|0)|0;c=Xo(c,f[(f[a>>2]|0)+20>>2]|0)|0;return (c?(b?2:1):b&1)|0}else return 0;return 0}function Q1a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0;l=t;t=t+16|0;k=l;f[k>>2]=0;if((b|0)!=9){e=0;t=l;return e|0}j=a+12|0;h=f[(f[j>>2]|0)+24>>2]|0;if(h){b=xd[f[f[c>>2]>>2]&63](c,h,k,d)|0;g=f[k>>2]|0;if((b&4|0)!=0&(g|0)!=0)R1a(a,g);if(b&1)i=(Xo(e,h)|0)&1;else i=0}else i=0;h=f[(f[j>>2]|0)+20>>2]|0;if(!h){e=i;t=l;return e|0}g=xd[f[f[c>>2]>>2]&63](c,h,k,d)|0;b=f[k>>2]|0;if((g&4|0)!=0&(b|0)!=0)S1a(a,b);if(!(g&1)){e=i;t=l;return e|0}e=i+((Xo(e,h)|0)&1)|0;t=l;return e|0}function R1a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+24>>2]=b;return}function S1a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+20>>2]=b;return}function T1a(a,b,c){a=a|0;b=b|0;c=c|0;bm(a,b,c);f[a>>2]=73136;c=gpd(28)|0;U1a(c);f[a+12>>2]=c;return}function U1a(a){a=a|0;V1a(a,74640,0.0);b[a+16>>0]=0;b[a+17>>0]=0;f[a+20>>2]=0;f[a+24>>2]=0;return}function V1a(a,b,c){a=a|0;b=b|0;c=+c;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];n[a+12>>2]=c;return}function W1a(a,c){a=a|0;c=c|0;var d=0,e=0.0;d=X1a(a)|0;if(iZ(d,X1a(c)|0)|0){d=0;return d|0}e=+Y1a(a);if(e!=+Y1a(c)){d=0;return d|0}if((f[a+20>>2]|0)!=(f[c+20>>2]|0)){d=0;return d|0}if((f[a+24>>2]|0)!=(f[c+24>>2]|0)){d=0;return d|0}if((b[a+16>>0]|0)!=(b[c+16>>0]|0)){d=0;return d|0}d=(b[a+17>>0]|0)==(b[c+17>>0]|0);return d|0}function X1a(a){a=a|0;return a|0}function Y1a(a){a=a|0;return +(+n[a+12>>2])}function Z1a(a,c){a=a|0;c=c|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];f[a+12>>2]=f[c+12>>2];b[a+16>>0]=b[c+16>>0]|0;b[a+17>>0]=b[c+17>>0]|0;f[a+20>>2]=f[c+20>>2];f[a+24>>2]=f[c+24>>2];return}function _1a(a){a=a|0;return 201}function $1a(a,b){a=a|0;b=b|0;return 0}function a2a(a,b){a=a|0;b=b|0;var c=0,d=0;c=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((c|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){c=0;return c|0}c=sd[f[(f[b>>2]|0)+116>>2]&2047](b)|0;if((c|0)!=(sd[f[(f[a>>2]|0)+116>>2]&2047](a)|0)){c=0;return c|0}d=sd[f[(f[a>>2]|0)+112>>2]&2047](a)|0;c=sd[f[(f[b>>2]|0)+112>>2]&2047](b)|0;c=(ocd(d,c,sd[f[(f[a>>2]|0)+116>>2]&2047](a)|0)|0)==0;return c|0}function b2a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=t;t=t+16|0;c=d;e=sd[f[(f[a>>2]|0)+32>>2]&2047](a)|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;wpd(c,e,Th(e)|0);if(Qpd(c,sd[f[(f[b>>2]|0)+32>>2]&2047](b)|0)|0){e=0;Apd(c);t=d;return e|0}e=td[f[(f[a>>2]|0)+20>>2]&1023](a,b)|0;Apd(c);t=d;return e|0}function c2a(a){a=a|0;var b=0,c=0;f[a>>2]=73236;b=a+12|0;c=f[b>>2]|0;if(c|0){I2a(c);jpd(c)}f[b>>2]=0;dm(a);return}function d2a(a){a=a|0;c2a(a);jpd(a);return}function e2a(a){a=a|0;return 1}function f2a(a){a=a|0;var b=0;b=gpd(16)|0;E2a(b);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function g2a(a){a=a|0;return 1}function h2a(a){a=a|0;return 4}function i2a(a,b,c){a=a|0;b=b|0;c=c|0;D2a(f[a+12>>2]|0,b,c);return}function j2a(a){a=a|0;a=f[a+12>>2]|0;return (f[a>>2]|0)+(f[a+20>>2]|0)|0}function k2a(a,b,c){a=a|0;b=b|0;c=c|0;C2a(f[a+12>>2]|0,b,c);return}function l2a(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;if((sd[f[(f[c>>2]|0)+12>>2]&2047](c)|0)!=201){e=0;return e|0}d=a+12|0;e=f[d>>2]|0;a=c+12|0;c=f[a>>2]|0;if((b[e+16>>0]|0)!=(b[c+16>>0]|0)){e=0;return e|0}k=f[e>>2]|0;g=(f[e+4>>2]|0)-k|0;j=(f[c+4>>2]|0)-(f[c>>2]|0)|0;i=e+20|0;h=j+g-(f[i>>2]|0)|0;l=k+1|0;f[l>>2]=(f[l>>2]|0)+(f[c+12>>2]|0);c=k+5|0;f[c>>2]=j-(f[i>>2]|0)+(f[c>>2]|0);t2a(e,h);e=f[d>>2]|0;Krd((f[e>>2]|0)+g|0,(f[f[a>>2]>>2]|0)+(f[e+20>>2]|0)|0,h-g|0)|0;e=f[d>>2]|0;e=u2a(e,e)|0;f[(f[d>>2]|0)+24>>2]=e;e=1;return e|0}function m2a(a){a=a|0;a=f[a+12>>2]|0;return (f[a+4>>2]|0)-(f[a>>2]|0)-(f[a+20>>2]|0)|0}function n2a(a){a=a|0;return f[(f[a+12>>2]|0)+12>>2]|0}function o2a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+12>>2]=b;return}function p2a(a){a=a|0;return f[f[a+12>>2]>>2]|0}function q2a(a){a=a|0;a=f[a+12>>2]|0;return (f[a+4>>2]|0)-(f[a>>2]|0)|0}function r2a(a){a=a|0;return b[(f[a+12>>2]|0)+16>>0]|0}function s2a(a){a=a|0;return f[(f[a+12>>2]|0)+24>>2]|0}function t2a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[a>>2]|0;e=(f[c>>2]|0)-d|0;if(e>>>0<b>>>0){v2a(a,b-e|0);return}if(e>>>0<=b>>>0)return;f[c>>2]=d+b;return}function u2a(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;g=f[c+4>>2]|0;d=0;e=0;a=f[c>>2]|0;while(1){if((a|0)==(g|0))break;c=b[a>>0]|0;c=rCb(d,e,c,((c|0)<0)<<31>>31)|0;d=c;e=G;a=a+1|0}G=e;return d|0}function v2a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if(((f[g>>2]|0)-c|0)>>>0>=b>>>0){w2a(a,b);t=i;return}c=c-(f[a>>2]|0)+b|0;d=x2a(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=(f[g>>2]|0)-j|0;g=k<<1;y2a(e,k>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,(f[h>>2]|0)-j|0,a+8|0);z2a(e,b);A2a(a,e);B2a(e);t=i;return}function w2a(a,c){a=a|0;c=c|0;var d=0;d=a+4|0;a=c;c=f[d>>2]|0;do{b[c>>0]=0;c=(f[d>>2]|0)+1|0;f[d>>2]=c;a=a+-1|0}while((a|0)!=0);return}function x2a(a){a=a|0;return 2147483647}function y2a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;if(!b)d=0;else d=gpd(b)|0;f[a>>2]=d;c=d+c|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+b;return}function z2a(a,c){a=a|0;c=c|0;var d=0;d=a+8|0;a=c;c=f[d>>2]|0;do{b[c>>0]=0;c=(f[d>>2]|0)+1|0;f[d>>2]=c;a=a+-1|0}while((a|0)!=0);return}function A2a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-e)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function B2a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-1|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function C2a(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;if(!((c|0)!=0&(d|0)!=0))return;t2a(a,d);e=f[a>>2]|0;Krd(e|0,c|0,d|0)|0;d=b[e>>0]|0;b[a+16>>0]=d;f[a+12>>2]=f[e+1>>2];if(d<<24>>24==1)f[a+20>>2]=9;e=u2a(a,a)|0;f[a+24>>2]=e;return}function D2a(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0;if(!((c|0)!=0&(d|0)!=0))return;g=a+16|0;e=a+20|0;if((b[g>>0]|0)==1){f[e>>2]=9;e=9}else e=f[e>>2]|0;t2a(a,e+d|0);e=f[a>>2]|0;b[e>>0]=b[g>>0]|0;f[e+1>>2]=f[a+12>>2];f[e+5>>2]=d;Krd(e+9|0,c|0,d|0)|0;g=u2a(a,a)|0;f[a+24>>2]=g;return}function E2a(a){a=a|0;var b=0;F2a(a);f[a>>2]=73236;b=gpd(28)|0;G2a(b);f[a+12>>2]=b;return}function F2a(a){a=a|0;bm(a,0,0);f[a>>2]=73372;return}function G2a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;b[a+16>>0]=1;f[a+20>>2]=0;f[a+24>>2]=0;return}function H2a(a){a=a|0;Sc()}function I2a(a){a=a|0;J2a(a);return}function J2a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function K2a(a){a=a|0;a=f[a>>2]|0;if(!a)return;Hd[f[(f[a>>2]|0)+36>>2]&1023](a);return}function L2a(a){a=a|0;return f[a>>2]|0}function M2a(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[(f[b>>2]|0)+32>>2]&1023](b);return}function N2a(a){a=a|0;return 32}function O2a(a,b){a=a|0;b=b|0;if((a|0)==(b|0)){b=1;return b|0}if(!(Do(a,b)|0)){b=0;return b|0}b=wr(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function P2a(a,b){a=a|0;b=b|0;if((a|0)==(b|0)){b=1;return b|0}if(!(Eo(a,b)|0)){b=0;return b|0}b=tr(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function Q2a(a,b){a=a|0;b=b|0;if((a|0)==(b|0)){b=1;return b|0}if(!(Fo(a,b)|0)){b=0;return b|0}b=dr(f[a+16>>2]|0,f[b+16>>2]|0)|0;return b|0}function R2a(a){a=a|0;var b=0;f[a>>2]=73508;b=f[a+16>>2]|0;if(b|0){X2a(b);jpd(b)}Go(a);return}function S2a(a){a=a|0;R2a(a);jpd(a);return}function T2a(a){a=a|0;return f[(f[a+16>>2]|0)+4>>2]|0}function U2a(a){a=a|0;return f[(f[a+16>>2]|0)+8>>2]|0}function V2a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=Xl(a,b,c)|0;return (Vq(f[a+16>>2]|0,b,c)|0)+d|0}function W2a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=Am(a,b,c,d,e)|0;return (Mq(f[a+16>>2]|0,b,c,d,e)|0)+g|0}function X2a(a){a=a|0;Yq(a);return}function Y2a(a){a=a|0;return 126}function Z2a(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;if(!c){g=0;return g|0}e=c+12|0;g=f[e>>2]|0;if(!(f[g+48>>2]|0)){d=a+12|0;c=d;a=0;d=f[d>>2]|0}else{c=a+12|0;d=f[c>>2]|0;a=d+96|0;f[a>>2]=f[g+96>>2]}f[d+48>>2]=a;f[d+76>>2]=f[g+76>>2];f[d+80>>2]=f[g+80>>2];f[d+84>>2]=f[g+84>>2];f[d+88>>2]=f[g+88>>2];f[d+92>>2]=f[g+92>>2];f[d+52>>2]=f[g+52>>2];f[d+56>>2]=f[g+56>>2];f[d+60>>2]=f[g+60>>2];f[d+64>>2]=f[g+64>>2];f[d+68>>2]=f[g+68>>2];f[d+72>>2]=f[g+72>>2];b[d+104>>0]=b[g+104>>0]|0;b[d+105>>0]=b[g+105>>0]|0;b[d+106>>0]=b[g+106>>0]|0;b[d+107>>0]=b[g+107>>0]|0;b[d+108>>0]=b[g+108>>0]|0;b[d+109>>0]=b[g+109>>0]|0;b[d+110>>0]=b[g+110>>0]|0;b[d+111>>0]=b[g+111>>0]|0;FCb(d,g)|0;YRa((f[c>>2]|0)+8|0,(f[e>>2]|0)+8|0)|0;VRa((f[c>>2]|0)+12|0,(f[e>>2]|0)+12|0)|0;g=1;return g|0}function _2a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if((sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0)!=126){b=0;return b|0}b=d3a(a,b)|0;return b|0}function $2a(a,b){a=a|0;b=b|0;return _2a(a,b)|0}function a3a(a){a=a|0;var b=0;f[a>>2]=73600;b=f[a+12>>2]|0;if(b|0){c3a(b);jpd(b)}em(a);return}function b3a(a){a=a|0;a3a(a);jpd(a);return}function c3a(a){a=a|0;WRa(a+12|0);ZRa(a+8|0);ECb(a);return}function d3a(a,c){a=a|0;c=c|0;var d=0,e=0,g=0;e=a+12|0;d=f[e>>2]|0;g=c+12|0;c=f[g>>2]|0;a=(f[c+48>>2]|0)!=0;if(!(f[d+48>>2]|0)){if(a){g=0;return g|0}}else{if(!a){g=0;return g|0}if(+n[d+96>>2]!=+n[c+96>>2]){g=0;return g|0}}d=e3a(d+8|0)|0;a=e3a((f[g>>2]|0)+8|0)|0;if(d){if(!a){g=0;return g|0}c=mSa((f[e>>2]|0)+8|0)|0;a=f[(f[c>>2]|0)+24>>2]|0;d=PRa((f[g>>2]|0)+8|0)|0;if(!(td[a&1023](c,d)|0)){g=0;return g|0}}else if(a){g=0;return g|0}d=f3a((f[e>>2]|0)+12|0)|0;a=f3a((f[g>>2]|0)+12|0)|0;if(d){if(!a){g=0;return g|0}c=nSa((f[e>>2]|0)+12|0)|0;a=f[(f[c>>2]|0)+24>>2]|0;d=RRa((f[g>>2]|0)+12|0)|0;if(!(td[a&1023](c,d)|0)){g=0;return g|0}}else if(a){g=0;return g|0}if(!(BMa((f[e>>2]|0)+16|0,(f[g>>2]|0)+16|0,.003921568859368563)|0)){g=0;return g|0}if(!(BMa((f[e>>2]|0)+32|0,(f[g>>2]|0)+32|0,.003921568859368563)|0)){g=0;return g|0}c=f[e>>2]|0;a=f[g>>2]|0;if(!(+I(+(+n[c+76>>2]-+n[a+76>>2]))<1.0000000474974513e-03)){g=0;return g|0}if(!(+I(+(+n[c+80>>2]-+n[a+80>>2]))<1.0000000474974513e-03)){g=0;return g|0}if(!(+I(+(+n[c+84>>2]-+n[a+84>>2]))<1.0000000474974513e-03)){g=0;return g|0}if(!(+I(+(+n[c+88>>2]-+n[a+88>>2]))<1.0000000474974513e-03)){g=0;return g|0}if(!(+I(+(+n[c+92>>2]-+n[a+92>>2]))<1.0000000474974513e-03)){g=0;return g|0}if((f[c+52>>2]|0)!=(f[a+52>>2]|0)){g=0;return g|0}if((f[c+56>>2]|0)!=(f[a+56>>2]|0)){g=0;return g|0}if((f[c+60>>2]|0)!=(f[a+60>>2]|0)){g=0;return g|0}if((f[c+64>>2]|0)!=(f[a+64>>2]|0)){g=0;return g|0}if((f[c+68>>2]|0)!=(f[a+68>>2]|0)){g=0;return g|0}if((f[c+72>>2]|0)!=(f[a+72>>2]|0)){g=0;return g|0}if((b[c+104>>0]|0)!=(b[a+104>>0]|0)){g=0;return g|0}if((b[c+105>>0]|0)!=(b[a+105>>0]|0)){g=0;return g|0}if((b[c+106>>0]|0)!=(b[a+106>>0]|0)){g=0;return g|0}if((b[c+107>>0]|0)!=(b[a+107>>0]|0)){g=0;return g|0}if((b[c+108>>0]|0)!=(b[a+108>>0]|0)){g=0;return g|0}if((b[c+109>>0]|0)!=(b[a+109>>0]|0)){g=0;return g|0}if((b[c+110>>0]|0)!=(b[a+110>>0]|0)){g=0;return g|0}if((b[c+111>>0]|0)!=(b[a+111>>0]|0)){g=0;return g|0}g=HCb(c,a)|0;return g|0}function e3a(a){a=a|0;return (h3a(a,0)|0)^1|0}function f3a(a){a=a|0;return (g3a(a,0)|0)^1|0}function g3a(a,b){a=a|0;b=b|0;return (f[a>>2]|0)==(b|0)|0}function h3a(a,b){a=a|0;b=b|0;return (f[a>>2]|0)==(b|0)|0}function i3a(a){a=a|0;return 31}function j3a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;i=t;t=t+16|0;c=i;if((a|0)==(b|0)){b=1;t=i;return b|0}h=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((h|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){b=0;t=i;return b|0}t3a(a,G3a(b)|0);H3a(c,b);$3a(a,c);a4a(a,I3a(b)|0);h=a+12|0;d=0;while(1){g=f[h>>2]|0;a=g+20|0;c=f[a>>2]|0;if(d>>>0>=(f[g+24>>2]|0)-c>>2>>>0)break;a=f[c+(d<<2)>>2]|0;if(a|0){E3a(a);jpd(a)}d=d+1|0}b4a(a,J3a(b)|0);a=0;while(1){c=f[h>>2]|0;if(a>>>0>=(f[c+24>>2]|0)-(f[c+20>>2]|0)>>2>>>0)break;g=gpd(4)|0;S4a(g,0);f[(f[(f[h>>2]|0)+20>>2]|0)+(a<<2)>>2]=g;g=f[(f[(f[h>>2]|0)+20>>2]|0)+(a<<2)>>2]|0;c4a(g,L3a(b,a)|0);a=a+1|0}e=0;a=c;while(1){c=a+32|0;d=f[c>>2]|0;if(e>>>0>=(f[a+36>>2]|0)-d>>2>>>0)break;c=f[d+(e<<2)>>2]|0;if(c){Hd[f[(f[c>>2]|0)+4>>2]&1023](c);a=f[h>>2]|0}e=e+1|0}d4a(c,K3a(b)|0);g=b+12|0;e=0;while(1){d=f[h>>2]|0;if(e>>>0>=(f[d+36>>2]|0)-(f[d+32>>2]|0)>>2>>>0){a=1;break}a=f[g>>2]|0;a=e4a(a,v3a(N3a(b,e)|0)|0)|0;c=f[g>>2]|0;c=e4a(c,w3a(N3a(b,e)|0)|0)|0;if((a|0)>-1)d=f[(f[(f[h>>2]|0)+20>>2]|0)+(a<<2)>>2]|0;else d=0;if((c|0)>-1)a=f[(f[(f[h>>2]|0)+20>>2]|0)+(c<<2)>>2]|0;else a=0;c=gpd(8)|0;s4a(c,d,a);f[(f[(f[h>>2]|0)+32>>2]|0)+(e<<2)>>2]=c;d=f[(f[(f[h>>2]|0)+32>>2]|0)+(e<<2)>>2]|0;f4a(d,N3a(b,e)|0);e=e+1|0}t=i;return a|0}function k3a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;h=t;t=t+32|0;c=h;d=h+12|0;if((a|0)==(b|0)){b=1;t=h;return b|0}i=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((i|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){i=0;t=h;return i|0}i=G3a(a)|0;if((i|0)!=(G3a(b)|0)){i=0;t=h;return i|0}H3a(c,a);H3a(d,b);if(iZ(c,d)|0){i=0;t=h;return i|0}i=I3a(a)|0;if(i^(I3a(b)|0)){i=0;t=h;return i|0}i=J3a(a)|0;if((i|0)!=(J3a(b)|0)){i=0;t=h;return i|0}i=K3a(a)|0;if((i|0)!=(K3a(b)|0)){i=0;t=h;return i|0}c=0;while(1){if(c>>>0>=(J3a(a)|0)>>>0)break;i=L3a(a,c)|0;if(M3a(i,L3a(b,c)|0)|0)c=c+1|0;else{e=0;g=14;break}}if((g|0)==14){t=h;return e|0}c=0;while(1){if(c>>>0>=(K3a(a)|0)>>>0){e=1;g=14;break}i=N3a(a,c)|0;if(O3a(i,N3a(b,c)|0)|0)c=c+1|0;else{e=0;g=14;break}}if((g|0)==14){t=h;return e|0}return 0}function l3a(a,b){a=a|0;b=b|0;return td[f[(f[a>>2]|0)+20>>2]&1023](a,b)|0}function m3a(a){a=a|0;var b=0,c=0;f[a>>2]=73664;b=a+12|0;c=f[b>>2]|0;if(c|0){B3a(c);jpd(c)}f[b>>2]=0;dm(a);return}function n3a(a){a=a|0;m3a(a);jpd(a);return}function o3a(a){a=a|0;return 1}function p3a(a){a=a|0;var b=0;b=gpd(16)|0;z3a(b,$l(a)|0,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function q3a(a){a=a|0;return 6}function r3a(a,b,c){a=a|0;b=b|0;c=c|0;if((b|0)!=9){c=0;return c|0}a=f[(f[a+12>>2]|0)+16>>2]|0;if(!a){c=0;return c|0}c=(Xo(c,a)|0)&1;return c|0}function s3a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;j=t;t=t+16|0;h=j;f[h>>2]=0;switch(b|0){case 9:{i=f[(f[a+12>>2]|0)+16>>2]|0;if(!i){d=0;t=j;return d|0}g=xd[f[f[c>>2]>>2]&63](c,i,h,d)|0;b=f[h>>2]|0;if((g&4|0)!=0&(b|0)!=0)t3a(a,b);if(!(g&1)){d=0;t=j;return d|0}d=(Xo(e,i)|0)&1;t=j;return d|0}case 4:{i=a+12|0;h=f[i>>2]|0;g=(f[h+24>>2]|0)-(f[h+20>>2]|0)>>2;b=0;while(1){if((b|0)==(g|0))break;u3a(0,c,f[(f[h+20>>2]|0)+(b<<2)>>2]|0,d);b=b+1|0;h=f[i>>2]|0}g=(f[h+36>>2]|0)-(f[h+32>>2]|0)>>2;b=0;while(1){if((b|0)==(g|0)){b=4;break}u3a(0,c,v3a(f[(f[(f[i>>2]|0)+32>>2]|0)+(b<<2)>>2]|0)|0,d);u3a(0,c,w3a(f[(f[(f[i>>2]|0)+32>>2]|0)+(b<<2)>>2]|0)|0,d);b=b+1|0}t=j;return b|0}default:{d=0;t=j;return d|0}}return 0}function t3a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+16>>2]=b;return}function u3a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0;g=t;t=t+16|0;a=g+4|0;e=g;f[a>>2]=0;i=f[(f[b>>2]|0)+8>>2]|0;h=x3a(c)|0;d=xd[i&63](b,h,a,d)|0;Sq(e,f[a>>2]|0);a=f[a>>2]|0;if(!((d&4|0)!=0&(a|0)!=0)){Tq(e);t=g;return}y3a(c,a);Tq(e);t=g;return}function v3a(a){a=a|0;return f[f[a+4>>2]>>2]|0}function w3a(a){a=a|0;return f[(f[a+4>>2]|0)+4>>2]|0}function x3a(a){a=a|0;return rq(f[a>>2]|0)|0}function y3a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;Cq(d,b);Dq(f[a>>2]|0,d)|0;Yp(d);t=c;return}function z3a(a,b,c){a=a|0;b=b|0;c=c|0;bm(a,b,c);f[a>>2]=73664;c=gpd(44)|0;A3a(c);f[a+12>>2]=c;return}function A3a(a){a=a|0;b[a>>0]=0;cfa(a+4|0,0.0);a=a+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;return}function B3a(a){a=a|0;var b=0,c=0,d=0,e=0,g=0;g=a+20|0;d=a+24|0;b=f[d>>2]|0;while(1){if((f[g>>2]|0)==(b|0))break;b=b+-4|0;c=f[b>>2]|0;if(c){E3a(c);jpd(c);b=(f[d>>2]|0)+-4|0}f[d>>2]=b}e=a+32|0;d=a+36|0;b=f[d>>2]|0;while(1){if((f[e>>2]|0)==(b|0))break;b=b+-4|0;c=f[b>>2]|0;if(c){Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=(f[d>>2]|0)+-4|0}f[d>>2]=b}C3a(e);D3a(g);return}function C3a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function D3a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function E3a(a){a=a|0;var b=0;b=f[a>>2]|0;if(b|0){F3a(b);jpd(b)}f[a>>2]=0;return}function F3a(a){a=a|0;FPa(a+44|0);FPa(a+28|0);Yp(a);return}function G3a(a){a=a|0;return f[(f[a+12>>2]|0)+16>>2]|0}function H3a(a,b){a=a|0;b=b|0;b=(f[b+12>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function I3a(a){a=a|0;return (b[f[a+12>>2]>>0]|0)!=0|0}function J3a(a){a=a|0;a=f[a+12>>2]|0;return (f[a+24>>2]|0)-(f[a+20>>2]|0)>>2|0}function K3a(a){a=a|0;a=f[a+12>>2]|0;return (f[a+36>>2]|0)-(f[a+32>>2]|0)>>2|0}function L3a(a,b){a=a|0;b=b|0;return f[(f[(f[a+12>>2]|0)+20>>2]|0)+(b<<2)>>2]|0}function M3a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+64|0;c=k+36|0;i=k+48|0;d=k+24|0;g=k+12|0;j=k;e=(x3a(a)|0)!=0;if(e^(x3a(b)|0)!=0){j=0;t=k;return j|0}if(e?(e=x3a(a)|0,T3a(e,x3a(b)|0)|0):0){j=0;t=k;return j|0}U3a(c,a);U3a(i,b);if(iZ(c,i)|0){j=0;t=k;return j|0}V3a(d,a);V3a(i,b);if(iZ(d,i)|0){j=0;t=k;return j|0}e=W3a(a)|0;if((e|0)!=(W3a(b)|0)){j=0;t=k;return j|0}e=X3a(a)|0;if((e|0)!=(X3a(b)|0)){j=0;t=k;return j|0}e=Y3a(a)|0;if((e|0)!=(Y3a(b)|0)){j=0;t=k;return j|0}c=0;while(1){if(c>>>0>=(X3a(a)|0)>>>0)break;Z3a(g,a,c);Z3a(i,b,c);if(iZ(g,i)|0){f=0;h=15;break}else c=c+1|0}if((h|0)==15){t=k;return f|0}c=0;while(1){if(c>>>0>=(Y3a(a)|0)>>>0){f=1;h=15;break}_3a(j,a,c);_3a(i,b,c);if(iZ(j,i)|0){f=0;h=15;break}else c=c+1|0}if((h|0)==15){t=k;return f|0}return 0}function N3a(a,b){a=a|0;b=b|0;return f[(f[(f[a+12>>2]|0)+32>>2]|0)+(b<<2)>>2]|0}function O3a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;i=t;t=t+16|0;g=i;h=i+8|0;c=v3a(a)|0;d=w3a(a)|0;e=v3a(b)|0;f=w3a(b)|0;if(!((c|0)==(e|0)&(d|0)==(f|0))){if((c|0)==0|(e|0)==0){h=0;t=i;return h|0}if((d|0)==0|(f|0)==0){h=0;t=i;return h|0}if(!(M3a(c,e)|0)){h=0;t=i;return h|0}if(!(M3a(d,f)|0)){h=0;t=i;return h|0}}f=P3a(a)|0;if((f|0)!=(P3a(b)|0)){h=0;t=i;return h|0}f=Q3a(a)|0;if((f|0)!=(Q3a(b)|0)){h=0;t=i;return h|0}f=R3a(a)|0;if((f|0)!=(R3a(b)|0)){h=0;t=i;return h|0}c=0;while(1){if(c>>>0>=(R3a(a)|0)>>>0){c=1;d=12;break}S3a(g,a,c);S3a(h,b,c);if(fZ(g,h)|0){c=0;d=12;break}else c=c+1|0}if((d|0)==12){t=i;return c|0}return 0}function P3a(a){a=a|0;return f[(f[a+4>>2]|0)+8>>2]|0}function Q3a(a){a=a|0;return f[(f[a+4>>2]|0)+12>>2]|0}function R3a(a){a=a|0;a=f[a+4>>2]|0;return (f[a+20>>2]|0)-(f[a+16>>2]|0)>>3|0}function S3a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=(f[(f[b+4>>2]|0)+16>>2]|0)+(c<<3)|0;b=f[d+4>>2]|0;c=a;f[c>>2]=f[d>>2];f[c+4>>2]=b;return}function T3a(a,b){a=a|0;b=b|0;return (mq(f[a+4>>2]|0,f[b+4>>2]|0)|0)^1|0}function U3a(a,b){a=a|0;b=b|0;b=(f[b>>2]|0)+16|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function V3a(a,b){a=a|0;b=b|0;b=(f[b>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function W3a(a){a=a|0;return f[(f[a>>2]|0)+40>>2]|0}function X3a(a){a=a|0;a=f[a>>2]|0;return ((f[a+32>>2]|0)-(f[a+28>>2]|0)|0)/12|0|0}function Y3a(a){a=a|0;a=f[a>>2]|0;return ((f[a+48>>2]|0)-(f[a+44>>2]|0)|0)/12|0|0}function Z3a(a,b,c){a=a|0;b=b|0;c=c|0;c=(f[(f[b>>2]|0)+28>>2]|0)+(c*12|0)|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];return}function _3a(a,b,c){a=a|0;b=b|0;c=c|0;c=(f[(f[b>>2]|0)+44>>2]|0)+(c*12|0)|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];return}function $3a(a,b){a=a|0;b=b|0;a=(f[a+12>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function a4a(a,c){a=a|0;c=c|0;b[f[a+12>>2]>>0]=c&1;return}function b4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[a>>2]|0;e=(f[c>>2]|0)-d>>2;if(e>>>0<b>>>0){U4a(a,b-e|0);return}if(e>>>0<=b>>>0)return;f[c>>2]=d+(b<<2);return}function c4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;e=t;t=t+16|0;d=e;y3a(a,x3a(b)|0);U3a(d,b);F4a(a,d);V3a(d,b);G4a(a,d);H4a(a,W3a(b)|0);I4a(a,X3a(b)|0);J4a(a,Y3a(b)|0);c=0;while(1){if(c>>>0>=(X3a(a)|0)>>>0)break;Z3a(d,b,c);K4a(a,c,d);c=c+1|0}c=0;while(1){if(c>>>0>=(Y3a(a)|0)>>>0)break;_3a(d,b,c);L4a(a,c,d);c=c+1|0}t=e;return}function d4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[a>>2]|0;e=(f[c>>2]|0)-d>>2;if(e>>>0<b>>>0){y4a(a,b-e|0);return}if(e>>>0<=b>>>0)return;f[c>>2]=d+(b<<2);return}function e4a(a,b){a=a|0;b=b|0;var c=0,d=0;d=f[a+20>>2]|0;c=(f[a+24>>2]|0)-d>>2;a=0;while(1){if(a>>>0>=c>>>0){a=-1;c=5;break}if((f[d+(a<<2)>>2]|0)==(b|0)){c=5;break}a=a+1|0}if((c|0)==5)return a|0;return 0}function f4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;e=t;t=t+16|0;d=e;c=a+4|0;g=f[(f[c>>2]|0)+4>>2]|0;c4a(g,w3a(b)|0);c=f[f[c>>2]>>2]|0;c4a(c,v3a(b)|0);g4a(a,Q3a(b)|0);h4a(a,P3a(b)|0);i4a(a,R3a(b)|0);c=0;while(1){if(c>>>0>=(R3a(a)|0)>>>0)break;S3a(d,b,c);j4a(a,c,d);c=c+1|0}t=e;return}function g4a(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+12>>2]=b;return}function h4a(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+8>>2]=b;return}function i4a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a+4>>2]|0)+16|0;k4a(d,0.0);l4a(a,b,d);t=c;return}function j4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=c;d=f[e+4>>2]|0;c=(f[(f[a+4>>2]|0)+16>>2]|0)+(b<<3)|0;f[c>>2]=f[e>>2];f[c+4>>2]=d;return}function k4a(a,b){a=a|0;b=+b;n[a>>2]=b;n[a+4>>2]=b;return}function l4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=a+4|0;e=f[a>>2]|0;g=(f[d>>2]|0)-e>>3;if(g>>>0<b>>>0){m4a(a,b-g|0,c);return}if(g>>>0<=b>>>0)return;f[d>>2]=e+(b<<3);return}function m4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;j=t;t=t+32|0;g=j;h=a+8|0;i=a+4|0;d=f[i>>2]|0;if((f[h>>2]|0)-d>>3>>>0>=b>>>0){do{a=c;g=f[a+4>>2]|0;h=d;f[h>>2]=f[a>>2];f[h+4>>2]=g;d=(f[i>>2]|0)+8|0;f[i>>2]=d;b=b+-1|0}while((b|0)!=0);t=j;return}d=(d-(f[a>>2]|0)>>3)+b|0;e=n4a(a)|0;if(e>>>0<d>>>0)kqd(a);k=f[a>>2]|0;l=(f[h>>2]|0)-k|0;h=l>>2;o4a(g,l>>3>>>0<e>>>1>>>0?(h>>>0<d>>>0?d:h):e,(f[i>>2]|0)-k>>3,a+8|0);p4a(g,b,c);q4a(a,g);r4a(g);t=j;return}function n4a(a){a=a|0;return 536870911}function o4a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>536870911){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<3)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<3)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<3);return}function p4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;d=a+8|0;a=b;b=f[d>>2]|0;do{h=c;g=f[h+4>>2]|0;e=b;f[e>>2]=f[h>>2];f[e+4>>2]=g;b=(f[d>>2]|0)+8|0;f[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function q4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>3)<<3)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function r4a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-8|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function s4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;f[a>>2]=73756;d=gpd(28)|0;t4a(d);f[a+4>>2]=d;f[d>>2]=b;f[d+4>>2]=c;return}function t4a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;return}function u4a(a){a=a|0;var b=0;f[a>>2]=73756;a=a+4|0;b=f[a>>2]|0;if(!b){f[a>>2]=0;return}w4a(b);jpd(b);f[a>>2]=0;return}function v4a(a){a=a|0;u4a(a);jpd(a);return}function w4a(a){a=a|0;x4a(a+16|0);return}function x4a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function y4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if((f[g>>2]|0)-c>>2>>>0>=b>>>0){z4a(a,b);t=i;return}c=(c-(f[a>>2]|0)>>2)+b|0;d=A4a(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=(f[g>>2]|0)-j|0;g=k>>1;B4a(e,k>>2>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,(f[h>>2]|0)-j>>2,a+8|0);C4a(e,b);D4a(a,e);E4a(e);t=i;return}function z4a(a,b){a=a|0;b=b|0;var c=0;c=a+4|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function A4a(a){a=a|0;return 1073741823}function B4a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function C4a(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function D4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function E4a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function F4a(a,b){a=a|0;b=b|0;a=(f[a>>2]|0)+16|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function G4a(a,b){a=a|0;b=b|0;a=(f[a>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function H4a(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+40>>2]=b;return}function I4a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a>>2]|0)+28|0;cfa(d,0.0);M4a(a,b,d);t=c;return}function J4a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a>>2]|0)+44|0;cfa(d,0.0);M4a(a,b,d);t=c;return}function K4a(a,b,c){a=a|0;b=b|0;c=c|0;b=(f[(f[a>>2]|0)+28>>2]|0)+(b*12|0)|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];return}function L4a(a,b,c){a=a|0;b=b|0;c=c|0;b=(f[(f[a>>2]|0)+44>>2]|0)+(b*12|0)|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];return}function M4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=a+4|0;e=f[a>>2]|0;g=((f[d>>2]|0)-e|0)/12|0;if(g>>>0<b>>>0){N4a(a,b-g|0,c);return}if(g>>>0<=b>>>0)return;f[d>>2]=e+(b*12|0);return}function N4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;j=t;t=t+32|0;g=j;h=a+8|0;i=a+4|0;d=f[i>>2]|0;if((((f[h>>2]|0)-d|0)/12|0)>>>0>=b>>>0){do{f[d>>2]=f[c>>2];f[d+4>>2]=f[c+4>>2];f[d+8>>2]=f[c+8>>2];d=(f[i>>2]|0)+12|0;f[i>>2]=d;b=b+-1|0}while((b|0)!=0);t=j;return}d=((d-(f[a>>2]|0)|0)/12|0)+b|0;e=GPa(a)|0;if(e>>>0<d>>>0)kqd(a);k=f[a>>2]|0;l=((f[h>>2]|0)-k|0)/12|0;h=l<<1;O4a(g,l>>>0<e>>>1>>>0?(h>>>0<d>>>0?d:h):e,((f[i>>2]|0)-k|0)/12|0,a+8|0);P4a(g,b,c);Q4a(a,g);R4a(g);t=j;return}function O4a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>357913941){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b*12|0)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c*12|0)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b*12|0);return}function P4a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=a+8|0;a=b;b=f[d>>2]|0;do{f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];b=(f[d>>2]|0)+12|0;f[d>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Q4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(((e|0)/-12|0)*12|0)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function R4a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-12|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function S4a(a,b){a=a|0;b=b|0;var c=0;c=gpd(56)|0;T4a(c,b);f[a>>2]=c;return}function T4a(a,b){a=a|0;b=b|0;Cq(a,b);cfa(a+4|0,0.0);cfa(a+16|0,0.0);f[a+28>>2]=0;f[a+32>>2]=0;f[a+36>>2]=0;f[a+40>>2]=-1;f[a+44>>2]=0;f[a+48>>2]=0;f[a+52>>2]=0;return}function U4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if((f[g>>2]|0)-c>>2>>>0>=b>>>0){V4a(a,b);t=i;return}c=(c-(f[a>>2]|0)>>2)+b|0;d=W4a(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=(f[g>>2]|0)-j|0;g=k>>1;X4a(e,k>>2>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,(f[h>>2]|0)-j>>2,a+8|0);Y4a(e,b);Z4a(a,e);_4a(e);t=i;return}function V4a(a,b){a=a|0;b=b|0;var c=0;c=a+4|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function W4a(a){a=a|0;return 1073741823}function X4a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function Y4a(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=b;b=f[c>>2]|0;do{f[b>>2]=0;b=(f[c>>2]|0)+4|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Z4a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function _4a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function $4a(a){a=a|0;return 220}function a5a(a,b){a=a|0;b=b|0;return 0}function b5a(a,b){a=a|0;b=b|0;return 0}function c5a(a,b){a=a|0;b=b|0;return 0}function d5a(a){a=a|0;var b=0;f[a>>2]=73772;b=f[a+12>>2]|0;if(b|0){l5a(b);jpd(b)}dm(a);return}function e5a(a){a=a|0;d5a(a);jpd(a);return}function f5a(a){a=a|0;return 1}function g5a(a){a=a|0;var b=0;b=gpd(16)|0;j5a(b,$l(a)|0,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function h5a(a){a=a|0;return 1}function i5a(a){a=a|0;return 3}function j5a(a,b,c){a=a|0;b=b|0;c=c|0;bm(a,b,c);f[a>>2]=73772;c=gpd(32)|0;k5a(c);f[a+12>>2]=c;return}function k5a(a){a=a|0;re(a);vk(a+8|0);b[a+24>>0]=0;f[a+28>>2]=0;return}function l5a(a){a=a|0;a=f[a+28>>2]|0;if(!a)return;m5a(a);jpd(a);return}function m5a(a){a=a|0;a=f[a>>2]|0;if(!a)return;n5a(a);jpd(a);return}function n5a(a){a=a|0;zU(a+84|0);Apd(a+12|0);Apd(a);return}function o5a(a){a=a|0;return 221}function p5a(a,b){a=a|0;b=b|0;return 0}function q5a(a,b){a=a|0;b=b|0;return 0}function r5a(a,b){a=a|0;b=b|0;return 0}function s5a(a){a=a|0;var b=0;f[a>>2]=73864;b=f[a+12>>2]|0;if(b|0){y5a(b);jpd(b)}dm(a);return}function t5a(a){a=a|0;s5a(a);jpd(a);return}function u5a(a){a=a|0;return 1}function v5a(a){a=a|0;var b=0;b=gpd(16)|0;w5a(b,$l(a)|0,0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function w5a(a,b,c){a=a|0;b=b|0;c=c|0;bm(a,b,c);f[a>>2]=73864;c=gpd(12)|0;x5a(c);f[a+12>>2]=c;return}function x5a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}function y5a(a){a=a|0;var b=0,c=0,d=0;b=f[a+4>>2]|0;c=f[a>>2]|0;while(1){if((c|0)==(b|0))break;d=f[c>>2]|0;if(d|0)Hd[f[(f[d>>2]|0)+4>>2]&1023](d);c=c+4|0}z5a(a);return}function z5a(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function A5a(a){a=a|0;var b=0;f[a>>2]=73956;b=f[a+24>>2]|0;if(b|0)jpd(b);C5a(a);return}function B5a(a){a=a|0;A5a(a);jpd(a);return}function C5a(a){a=a|0;return}function D5a(a){a=a|0;var b=0;f[a>>2]=73972;b=f[a+24>>2]|0;if(b|0)jpd(b);C5a(a);return}function E5a(a){a=a|0;D5a(a);jpd(a);return}function F5a(a){a=a|0;var b=0;f[a>>2]=73988;b=f[a+24>>2]|0;if(b|0)jpd(b);C5a(a);return}function G5a(a){a=a|0;F5a(a);jpd(a);return}function H5a(a){a=a|0;var b=0;f[a>>2]=74004;b=f[a+24>>2]|0;if(b|0)jpd(b);C5a(a);return}function I5a(a){a=a|0;H5a(a);jpd(a);return}function J5a(a){a=a|0;return 12}function K5a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0;if(!b){a=0;return a|0}h=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((h|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){a=0;return a|0}if((b|0)==(a|0)){a=1;return a|0}d=Z6a(b)|0;h=sd[f[(f[b>>2]|0)+84>>2]&2047](b)|0;c=hpd(h>>>0>1073741823?-1:h<<2)|0;b=0;while(1){if((b|0)==(h|0))break;g=b7a(d+(b<<2)|0)|0;f[c+(b<<2)>>2]=g;b=b+1|0}g=vd[f[(f[a>>2]|0)+88>>2]&255](a,h,c)|0;kpd(c);if(!g){a=0;return a|0}c=0;e=Z6a(a)|0;while(1){if((c|0)==(h|0)){b=1;break}k6a(e,U6a(d)|0);x6a(e,_6a(d)|0);b=f[(f[a>>2]|0)+104>>2]|0;g=g6a(d)|0;Kd[b&255](a,c,g);g=b7a(d)|0;b=0;while(1){if((b|0)==(g|0))break;i=c7a(d,b)|0;j=l6a(e,b)|0;p7a(j,l7a(i)|0);q7a(j,i7a(i)|0);r7a(j,j7a(i)|0);q6a(j,d7a(i)|0);o6a(j,e7a(i)|0);n6a(j,f7a(i)|0);s7a(j,+g7a(i));m6a(j,h7a(i)|0);b=b+1|0}d=d+4|0;c=c+1|0;e=e+4|0}return b|0}function L5a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0.0;y=t;t=t+64|0;r=y+40|0;u=y+28|0;v=y+16|0;w=y+4|0;x=y;if(!b){x=0;t=y;return x|0}s=sd[f[(f[b>>2]|0)+12>>2]&2047](b)|0;if((s|0)!=(sd[f[(f[a>>2]|0)+12>>2]&2047](a)|0)){x=0;t=y;return x|0}if((b|0)==(a|0)){x=1;t=y;return x|0}s=sd[f[(f[a>>2]|0)+84>>2]&2047](a)|0;if((s|0)!=(sd[f[(f[b>>2]|0)+84>>2]&2047](b)|0)){x=0;t=y;return x|0}h=Z6a(a)|0;i=Z6a(b)|0;j=0;a:while(1){if(j>>>0>=s>>>0){c=26;break}m=U6a(h)|0;l=f[(f[m>>2]|0)+20>>2]|0;n=U6a(i)|0;if(!(td[l&1023](m,n)|0)){k=0;c=41;break}c=_6a(h)|0;d=_6a(i)|0;n=$6a(c)|0;if(iZ(n,$6a(d)|0)|0){k=0;c=41;break}n=a7a(c)|0;if(iZ(n,a7a(d)|0)|0){k=0;c=41;break}d=b7a(h)|0;if((d|0)!=(b7a(i)|0)){k=0;c=41;break}c=0;while(1){if(c>>>0>=d>>>0)break;e=c7a(h,c)|0;g=c7a(i,c)|0;n=d7a(e)|0;if(n<<16>>16!=(d7a(g)|0)<<16>>16){k=0;c=41;break a}n=e7a(e)|0;if(n<<16>>16!=(e7a(g)|0)<<16>>16){k=0;c=41;break a}n=f7a(e)|0;if(n<<16>>16!=(f7a(g)|0)<<16>>16){k=0;c=41;break a}z=+g7a(e);if(z!=+g7a(g)){k=0;c=41;break a}n=h7a(e)|0;if(n<<16>>16!=(h7a(g)|0)<<16>>16){k=0;c=41;break a}n=i7a(e)|0;if((n|0)==(i7a(g)|0)?(n=j7a(e)|0,(n|0)!=(j7a(g)|0)):0){k=0;c=41;break a}c=c+1|0}c=g6a(h)|0;d=g6a(i)|0;e=(d|0)!=0;if(!c){if(e){k=0;c=41;break}}else{if(!e){k=0;c=41;break}n=sd[f[(f[c>>2]|0)+12>>2]&2047](c)|0;if((n|0)!=(sd[f[(f[d>>2]|0)+12>>2]&2047](d)|0)){k=0;c=41;break}}h=h+4|0;i=i+4|0;j=j+1|0}if((c|0)==26){a=Z6a(a)|0;k=r+4|0;l=r+8|0;m=u+4|0;n=u+8|0;j=0;i=Z6a(b)|0;b:while(1){if(j>>>0>=s>>>0){k=1;c=41;break}h=b7a(a)|0;g=0;while(1){if(g>>>0>=h>>>0)break;c=c7a(a,g)|0;d=c7a(i,g)|0;e=i7a(c)|0;if(!((e|0)==(j7a(d)|0)?(j7a(c)|0)==(e|0):0)){f[r>>2]=0;f[k>>2]=0;f[l>>2]=0;f[u>>2]=0;f[m>>2]=0;f[n>>2]=0;b=i7a(c)|0;k7a(v,b,j7a(c)|0,r);b=i7a(d)|0;k7a(w,b,j7a(d)|0,u);f[x>>2]=0;b=l7a(c)|0;if(((Bd[f[(f[b>>2]|0)+12>>2]&127](b,v,1,x,r,49)|0)==0?(b=l7a(d)|0,(Bd[f[(f[b>>2]|0)+12>>2]&127](b,w,1,x,u,49)|0)==0):0)?(o=f[r>>2]|0,p=(f[k>>2]|0)-o|0,q=f[u>>2]|0,(p|0)==((f[m>>2]|0)-q|0)):0)c=(ocd(o,q,p)|0)!=0&1;else c=1;BU(u);BU(r);if(c|0){k=0;c=41;break b}}g=g+1|0}c=g6a(a)|0;d=g6a(i)|0;if((c|0)!=0&(d|0)!=0?(h=sd[f[(f[c>>2]|0)+8>>2]&2047](c)|0,b=sd[f[(f[d>>2]|0)+8>>2]&2047](d)|0,ocd(h,b,sd[f[(f[c>>2]|0)+12>>2]&2047](c)|0)|0):0){k=0;c=41;break}j=j+1|0;a=a+4|0;i=i+4|0}if((c|0)==41){t=y;return k|0}}else if((c|0)==41){t=y;return k|0}return 0}function M5a(a,b){a=a|0;b=b|0;return td[f[(f[a>>2]|0)+20>>2]&1023](a,b)|0}function N5a(a){a=a|0;var b=0,c=0;f[a>>2]=74020;f[a+12>>2]=74140;b=a+16|0;c=f[b>>2]|0;if(c|0){Y6a(c);jpd(c)}f[b>>2]=0;dm(a);return}function O5a(a){a=a|0;N5a(a);jpd(a);return}function P5a(a){a=a|0;return 1}function Q5a(a){a=a|0;var b=0;b=gpd(20)|0;V6a(b,0,$l(a)|0);td[f[(f[b>>2]|0)+16>>2]&1023](b,a)|0;return b|0}function R5a(a){a=a|0;return 1}function S5a(a){a=a|0;return f[(f[a+16>>2]|0)+8>>2]|0}function T5a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;if((b|0)!=9){c=0;return c|0}g=a+16|0;b=f[g>>2]|0;a=0;d=0;e=f[b+4>>2]|0;while(1){if(d>>>0>=(f[b>>2]|0)>>>0)break;b=U6a(e)|0;if(b){Xo(c,b)|0;a=a+1|0}d=d+1|0;e=e+4|0;b=f[g>>2]|0}return a|0}function U5a(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=t;t=t+16|0;l=m;f[l>>2]=0;if((b|0)!=9){l=0;t=m;return l|0}k=a+16|0;b=f[k>>2]|0;a=0;i=0;j=f[b+4>>2]|0;while(1){if(i>>>0>=(f[b>>2]|0)>>>0)break;b=U6a(j)|0;if(b){g=xd[f[f[c>>2]>>2]&63](c,b,l,d)|0;h=f[l>>2]|0;if((g&4|0)!=0&(h|0)!=0)k6a(j,h);if(g&1)a=a+((Xo(e,b)|0)&1)|0}i=i+1|0;j=j+4|0;b=f[k>>2]|0}t=m;return a|0}function V5a(a){a=a|0;return f[f[a+16>>2]>>2]|0}function W5a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;h=a+16|0;a=f[h>>2]|0;d=a+4|0;e=f[d>>2]|0;if(e){d=e+-4|0;a=f[d>>2]|0;if(a|0){a=e+(a<<2)|0;do{a=a+-4|0;L6a(a)}while((a|0)!=(e|0))}kpd(d);a=f[h>>2]|0;d=a+4|0}f[d>>2]=0;f[a>>2]=0;if(!b){c=1;return c|0}a=b<<2;a=hpd(b>>>0>1073741823|a>>>0>4294967291?-1:a+4|0)|0;f[a>>2]=b;a=a+4|0;d=a+(b<<2)|0;e=a;do{M6a(e);e=e+4|0}while((e|0)!=(d|0));d=f[h>>2]|0;f[d+4>>2]=a;f[d>>2]=b;g=(c|0)==0;e=0;a=b;while(1){if(e>>>0>=a>>>0){a=1;d=15;break}if(g)a=1;else a=f[c+(e<<2)>>2]|0;if(!(N6a((f[d+4>>2]|0)+(e<<2)|0,a)|0)){a=0;d=15;break}d=f[h>>2]|0;e=e+1|0;a=f[d>>2]|0}if((d|0)==15)return a|0;return 0}function X5a(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;F=t;t=t+64|0;C=F+40|0;D=F+12|0;E=F;if(!((b|0)!=0&(c|0)!=0)){E=1;t=F;return E|0}e=0;g=0;while(1){if(g>>>0>=c>>>0)break;i=f[b+(g*20|0)+8>>2]|0;if(!i){h=1;j=30;break}B=(i>>>0)/21e3|0;e=B+e+((i-(B*21e3|0)|0)!=0&1)|0;g=g+1|0}if((j|0)==30){t=F;return h|0}vd[f[(f[a>>2]|0)+88>>2]&255](a,e,0)|0;e=f[(f[a+16>>2]|0)+4>>2]|0;w=0;h=1;a:while(1){if(w>>>0>=c>>>0){h=0;j=30;break}v=f[b+8>>2]|0;A=(v>>>0)/21e3|0;v=v-(A*21e3|0)|0;z=(v|0)==0;v=z?21e3:v;y=b+12|0;B=f[y>>2]|0;x=(B&2|0)==0?3:6;x=(B&4|0)==0?x:x+2|0;z=A+-1+((z^1)&1)|0;A=b+16|0;B=x<<2;u=0;g=f[b+4>>2]|0;j=f[b>>2]|0;while(1){if(u>>>0>z>>>0)break;l=f[y>>2]&1^3;o=(u|0)==(z|0)?v:21e3;i6a(C);p=V(l,o)|0;j6a(C,p)|0;k6a(e,f[A>>2]|0);m=l6a(e,0)|0;m6a(m,f[y>>2]&65535);n6a(m,0);o6a(m,o&65535);dfa(D);p=p<<1;q=hpd(p)|0;k=0;i=q;s=j;while(1){if(k>>>0>=o>>>0)break;a=0;j=s;while(1){if(a>>>0>=l>>>0)break;me(E,+n[j>>2],+n[j+4>>2],+n[j+8>>2]);r6a(D,E);s=(s6a(C,j)|0)&65535;d[i>>1]=s;a=a+1|0;i=i+2|0;j=j+32|0}k=k+1|0;s=j}r=p6a(C)|0;q6a(m,r&65535);j=gpd(16)|0;t6a(j);a=(f[y>>2]&16|0)!=0;i=(V(B,r)|0)+p|0;k=o<<2;i=u6a(j,i+(a?k:0)|0)|0;if(!i){Hd[f[(f[j>>2]|0)+24>>2]&1023](j);kpd(q);i=0;h=3}else{h6a(e,j);j=i+((V(r,x)|0)<<2)|0;Krd(j|0,q|0,p|0)|0;kpd(q);if(a){Krd(j+p|0,g|0,k|0)|0;g=g+(o<<2)|0}k=0;l=v6a(C)|0;while(1){if((k|0)==(r|0))break;f[i>>2]=f[l>>2];f[i+4>>2]=f[l+4>>2];f[i+8>>2]=f[l+8>>2];a=i+12|0;j=f[y>>2]|0;if(!(j&2))i=a;else{j=l+12|0;f[a>>2]=f[j>>2];f[a+4>>2]=f[j+4>>2];f[a+8>>2]=f[j+8>>2];i=i+24|0;j=f[y>>2]|0}i=(j&8|0)==0?i:i+24|0;if(j&4){o=l+24|0;p=f[o+4>>2]|0;q=i;f[q>>2]=f[o>>2];f[q+4>>2]=p;i=i+8|0}k=k+1|0;l=l+44|0}w6a(C);x6a(e,D);i=1;e=e+4|0}y6a(C);if(i){u=u+1|0;j=s}else{j=30;break a}}b=b+20|0;w=w+1|0}if((j|0)==30){t=F;return h|0}return 0}function Y5a(a){a=a|0;return 1}function Z5a(a,b){a=a|0;b=b|0;a=f[a+16>>2]|0;if((f[a>>2]|0)>>>0<=b>>>0){b=0;return b|0}b=g6a((f[a+4>>2]|0)+(b<<2)|0)|0;return b|0}function _5a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;a=a+16|0;d=f[a>>2]|0;if((f[d>>2]|0)>>>0<=b>>>0)return;if(g6a((f[d+4>>2]|0)+(b<<2)|0)|0){d=g6a((f[(f[a>>2]|0)+4>>2]|0)+(b<<2)|0)|0;Hd[f[(f[d>>2]|0)+4>>2]&1023](d)}h6a((f[(f[a>>2]|0)+4>>2]|0)+(b<<2)|0,c);if(!c)return;Hd[f[f[c>>2]>>2]&1023](c);return}function $5a(a,b){a=a|0;b=b|0;return}function a6a(a,b,c){a=a|0;b=b|0;c=c|0;return W5a(a+-12|0,b,c)|0}function b6a(a,b,c){a=a|0;b=b|0;c=c|0;return X5a(a+-12|0,b,c)|0}function c6a(a){a=a|0;return V5a(a+-12|0)|0}function d6a(a,b){a=a|0;b=b|0;return Z5a(a+-12|0,b)|0}function e6a(a,b,c){a=a|0;b=b|0;c=c|0;_5a(a+-12|0,b,c);return}function f6a(a,b){a=a|0;b=b|0;return}function g6a(a){a=a|0;return f[(f[a>>2]|0)+40>>2]|0}function h6a(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+40>>2]=b;return}function i6a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}function j6a(a,b){a=a|0;b=b|0;var c=0,d=0;f[a+8>>2]=b;d=hpd(b>>>0>97612893?-1:b*44|0)|0;if(b|0){b=d+(b*44|0)|0;c=d;do{J6a(c);c=c+44|0}while((c|0)!=(b|0))}f[a>>2]=d;f[a+4>>2]=0;return 1}function k6a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;Rp(d,b);Sp(f[a>>2]|0,d)|0;Tp(d);t=c;return}function l6a(a,b){a=a|0;b=b|0;return (f[(f[a>>2]|0)+36>>2]|0)+(b<<2)|0}function m6a(a,b){a=a|0;b=b|0;d[(f[a>>2]|0)+14>>1]=b;return}function n6a(a,b){a=a|0;b=b|0;d[(f[a>>2]|0)+12>>1]=b;return}function o6a(a,b){a=a|0;b=b|0;d[(f[a>>2]|0)+10>>1]=b;return}function p6a(a){a=a|0;return f[a+4>>2]|0}function q6a(a,b){a=a|0;b=b|0;d[(f[a>>2]|0)+8>>1]=b;return}function r6a(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0,h=0;d=a+24|0;if(b[d>>0]|0){h=a+12|0;f[h>>2]=f[c>>2];f[h+4>>2]=f[c+4>>2];f[h+8>>2]=f[c+8>>2];Lrd(a|0,c|0,12)|0;b[d>>0]=0;return}e=+n[c>>2];if(e<+n[a>>2])n[a>>2]=e;h=c+4|0;e=+n[h>>2];d=a+4|0;if(e<+n[d>>2])n[d>>2]=e;g=c+8|0;e=+n[g>>2];d=a+8|0;if(e<+n[d>>2])n[d>>2]=e;e=+n[c>>2];d=a+12|0;if(e>+n[d>>2])n[d>>2]=e;e=+n[h>>2];d=a+16|0;if(e>+n[d>>2])n[d>>2]=e;e=+n[g>>2];d=a+20|0;if(!(e>+n[d>>2]))return;n[d>>2]=e;return}function s6a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=H6a(b)|0;c=f[a>>2]|0;i=a+4|0;g=f[i>>2]|0;h=c;do if(g){d=0;e=c;a:while(1){if(!e){j=11;break}a=f[e+40>>2]|0;do if(k>>>0>=a>>>0){if(k>>>0>a>>>0){a=e+36|0;break}a=I6a(e,b)|0;if(!a)break a;if((a|0)>=0)a=e+36|0;else j=9}else j=9;while(0);if((j|0)==9){j=0;a=e+32|0}d=a;e=f[a>>2]|0}if((j|0)==11){c=c+(g*44|0)|0;f[d>>2]=c;break}k=(e-h|0)/44|0;return k|0}while(0);f[c>>2]=f[b>>2];f[c+4>>2]=f[b+4>>2];f[c+8>>2]=f[b+8>>2];f[c+12>>2]=f[b+12>>2];f[c+16>>2]=f[b+16>>2];f[c+20>>2]=f[b+20>>2];f[c+24>>2]=f[b+24>>2];f[c+28>>2]=f[b+28>>2];f[c+40>>2]=k;f[c+32>>2]=0;f[c+36>>2]=0;k=f[i>>2]|0;f[i>>2]=k+1;return k|0}function t6a(a){a=a|0;z6a(a);f[a>>2]=74172;f[a+4>>2]=1;f[a+8>>2]=0;f[a+12>>2]=0;return}function u6a(a,b){a=a|0;b=b|0;var c=0,d=0;c=a+12|0;d=f[c>>2]|0;if(d|0)Nbd(d);d=Mbd(b)|0;f[c>>2]=d;f[a+8>>2]=b;return d|0}function v6a(a){a=a|0;return f[a>>2]|0}function w6a(a){a=a|0;var b=0;b=f[a>>2]|0;if(b|0)kpd(b);f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;return}function x6a(a,c){a=a|0;c=c|0;a=(f[a>>2]|0)+4|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];f[a+12>>2]=f[c+12>>2];f[a+16>>2]=f[c+16>>2];f[a+20>>2]=f[c+20>>2];b[a+24>>0]=b[c+24>>0]|0;return}function y6a(a){a=a|0;w6a(a);return}function z6a(a){a=a|0;f[a>>2]=74208;return}function A6a(a){a=a|0;a=a+4|0;f[a>>2]=(f[a>>2]|0)+1;return}function B6a(a){a=a|0;var b=0,c=0;c=a+4|0;b=(f[c>>2]|0)+-1|0;f[c>>2]=b;if((a|0)==0|(b|0)!=0)return;Hd[f[(f[a>>2]|0)+24>>2]&1023](a);return}function C6a(a){a=a|0;return f[a+12>>2]|0}function D6a(a){a=a|0;return f[a+8>>2]|0}function E6a(a,b,c){a=a|0;b=b|0;c=c|0;Krd(u6a(a,c)|0,b|0,c|0)|0;return 1}function F6a(a){a=a|0;f[a>>2]=74172;a=f[a+12>>2]|0;if(!a)return;Nbd(a);return}function G6a(a){a=a|0;F6a(a);jpd(a);return}function H6a(a){a=a|0;var b=0;b=V((j[a>>1]|0)<<14,j[a+10>>1]|0)|0;b=(V((j[a+4>>1]|0)*78907|0,j[a+8>>1]|0)|0)+b|0;return b+(V((j[a+6>>1]|0)*54463|0,j[a+2>>1]|0)|0)|0}function I6a(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[b+4>>2]|0;d=f[a+4>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}d=f[b+8>>2]|0;c=f[a+8>>2]|0;if((d|0)<(c|0)){b=-1;return b|0}if((d|0)>(c|0)){b=1;return b|0}c=f[b>>2]|0;d=f[a>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}c=f[b+16>>2]|0;d=f[a+16>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}c=f[b+20>>2]|0;d=f[a+20>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}c=f[b+12>>2]|0;d=f[a+12>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}c=f[b+28>>2]|0;d=f[a+28>>2]|0;if((c|0)<(d|0)){b=-1;return b|0}if((c|0)>(d|0)){b=1;return b|0}else{d=f[b+24>>2]|0;b=f[a+24>>2]|0;return ((d|0)<(b|0)?-1:(d|0)>(b|0)&1)|0}return 0}function J6a(a){a=a|0;K6a(a);return}function K6a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}function L6a(a){a=a|0;var b=0;b=f[a>>2]|0;if(b|0){T6a(b);jpd(b)}f[a>>2]=0;return}function M6a(a){a=a|0;var b=0;b=gpd(44)|0;S6a(b);f[a>>2]=b;return}function N6a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=f[a>>2]|0;e=f[c+36>>2]|0;if(e){d=e+-4|0;c=f[d>>2]|0;if(c|0){c=e+(c<<2)|0;do{c=c+-4|0;O6a(c)}while((c|0)!=(e|0))}kpd(d);c=f[a>>2]|0}d=c+32|0;f[d>>2]=0;e=b<<2;e=hpd(b>>>0>1073741823|e>>>0>4294967291?-1:e+4|0)|0;f[e>>2]=b;e=e+4|0;if(!b){a=d;d=c;d=d+36|0;f[d>>2]=e;f[a>>2]=b;return 1}c=e+(b<<2)|0;d=e;do{P6a(d);d=d+4|0}while((d|0)!=(c|0));d=f[a>>2]|0;a=d+32|0;d=d+36|0;f[d>>2]=e;f[a>>2]=b;return 1}function O6a(a){a=a|0;a=f[a>>2]|0;if(!a)return;R6a(a);jpd(a);return}function P6a(a){a=a|0;var b=0;b=gpd(24)|0;Q6a(b);f[a>>2]=b;return}function Q6a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;M2a(a+20|0,0);return}function R6a(a){a=a|0;K2a(a+20|0);return}function S6a(a){a=a|0;Rp(a,0);dfa(a+4|0);f[a+32>>2]=0;f[a+36>>2]=0;f[a+40>>2]=0;return}function T6a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+40>>2]|0;if(b|0)Hd[f[(f[b>>2]|0)+4>>2]&1023](b);d=a+36|0;e=f[d>>2]|0;if(!e){f[d>>2]=0;Tp(a);return}c=e+-4|0;b=f[c>>2]|0;if(b|0){b=e+(b<<2)|0;do{b=b+-4|0;O6a(b)}while((b|0)!=(e|0))}kpd(c);f[d>>2]=0;Tp(a);return}function U6a(a){a=a|0;return Up(f[a>>2]|0)|0}function V6a(a,b,c){a=a|0;b=b|0;c=c|0;bm(a,c,b);c=a+12|0;W6a(c);f[a>>2]=74020;f[c>>2]=74140;c=gpd(12)|0;X6a(c);f[a+16>>2]=c;return}function W6a(a){a=a|0;f[a>>2]=74236;return}function X6a(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=1;return}function Y6a(a){a=a|0;var b=0,c=0,d=0;b=a+4|0;c=f[b>>2]|0;if(!c){f[b>>2]=0;return}d=c+-4|0;a=f[d>>2]|0;if(a|0){a=c+(a<<2)|0;do{a=a+-4|0;L6a(a)}while((a|0)!=(c|0))}kpd(d);f[b>>2]=0;return}function Z6a(a){a=a|0;return f[(f[a+16>>2]|0)+4>>2]|0}function _6a(a){a=a|0;return (f[a>>2]|0)+4|0}function $6a(a){a=a|0;return a|0}function a7a(a){a=a|0;return a+12|0}function b7a(a){a=a|0;return f[(f[a>>2]|0)+32>>2]|0}function c7a(a,b){a=a|0;b=b|0;return (f[(f[a>>2]|0)+36>>2]|0)+(b<<2)|0}function d7a(a){a=a|0;return d[(f[a>>2]|0)+8>>1]|0}function e7a(a){a=a|0;return d[(f[a>>2]|0)+10>>1]|0}function f7a(a){a=a|0;return d[(f[a>>2]|0)+12>>1]|0}function g7a(a){a=a|0;return +(+n[(f[a>>2]|0)+16>>2])}function h7a(a){a=a|0;return d[(f[a>>2]|0)+14>>1]|0}function i7a(a){a=a|0;return f[f[a>>2]>>2]|0}function j7a(a){a=a|0;return f[(f[a>>2]|0)+4>>2]|0}function k7a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;f[a>>2]=b;f[a+4>>2]=c;f[a+8>>2]=d;return}function l7a(a){a=a|0;return L2a((f[a>>2]|0)+20|0)|0}function m7a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;n7a(b,c,c+d|0);return 1}function n7a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=b;k=c-i|0;e=a+8|0;d=f[a>>2]|0;j=d;if(k>>>0>((f[e>>2]|0)-d|0)>>>0){rU(a);d=sU(a)|0;if(d>>>0<k>>>0)kqd(a);i=(f[e>>2]|0)-(f[a>>2]|0)|0;j=i<<1;tU(a,i>>>0<d>>>1>>>0?(j>>>0<k>>>0?k:j):d);o7a(a,b,c,k);return}h=a+4|0;g=(f[h>>2]|0)-d|0;e=k>>>0>g>>>0;g=e?b+g|0:c;d=g-i|0;if(d|0)Lrd(j|0,b|0,d|0)|0;if(e){o7a(a,g,c,k-(f[h>>2]|0)+(f[a>>2]|0)|0);return}else{f[h>>2]=j+d;return}}function o7a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=a+4|0;a=c-b|0;if((a|0)<=0)return;Krd(f[d>>2]|0,b|0,a|0)|0;f[d>>2]=(f[d>>2]|0)+a;return}function p7a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;M2a(d,b);t7a((f[a>>2]|0)+20|0,d)|0;K2a(d);t=c;return}function q7a(a,b){a=a|0;b=b|0;f[f[a>>2]>>2]=b;return}function r7a(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+4>>2]=b;return}function s7a(a,b){a=a|0;b=+b;n[(f[a>>2]|0)+16>>2]=b;return}function t7a(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+36>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[(f[b>>2]|0)+32>>2]&1023](b);return a|0}function u7a(a){a=a|0;a=KCb(qR((f[a>>2]|0)+8|0,f[18059]|0)|0)|0;return (f[a>>2]|0)!=0|0}function v7a(a,b){a=a|0;b=b|0;return qR((f[a>>2]|0)+8|0,b)|0}function w7a(a){a=a|0;return f[a+12>>2]|0}function x7a(a,b){a=a|0;b=b|0;f[f[a+12>>2]>>2]=f[b>>2];return}function y7a(a){a=a|0;return (f[a+12>>2]|0)+4|0}function z7a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+4>>2]=f[b>>2];return}function A7a(a){a=a|0;return (f[a+12>>2]|0)+8|0}function B7a(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+8>>2]=f[b>>2];return}function C7a(a){a=a|0;return (b[(f[a+12>>2]|0)+12>>0]|0)!=0|0}function D7a(a,c){a=a|0;c=c|0;b[(f[a+12>>2]|0)+12>>0]=c&1;return}function E7a(a,c){a=a|0;c=c|0;b[(f[a+12>>2]|0)+13>>0]=c&1;return}function F7a(a){a=a|0;return (b[(f[a+12>>2]|0)+13>>0]|0)!=0|0}function G7a(a){a=a|0;return (f[a+12>>2]|0)+20|0}function H7a(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;if(!b){t=d;return}yCb(c,b);GCb((f[a+12>>2]|0)+20|0,c)|0;ECb(c);t=d;return}function I7a(a,b){a=a|0;b=b|0;if(!b){b=0;return b|0}if(!(J7a((f[a+12>>2]|0)+28|0,b)|0)){b=0;return b|0}Hd[f[f[b>>2]>>2]&1023](b);b=1;return b|0}function J7a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;c=g;f[c>>2]=b;if(K7a(a,b)|0){e=0;t=g;return e|0}d=a+4|0;e=f[d>>2]|0;if((e|0)==(f[a+8>>2]|0)){L7a(a,c);e=1;t=g;return e|0}else{f[e>>2]=b;f[d>>2]=(f[d>>2]|0)+4;e=1;t=g;return e|0}return 0}function K7a(a,b){a=a|0;b=b|0;var c=0;c=f[a+4>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(c|0)){a=c;break}if((f[a>>2]|0)==(b|0))break;a=a+4|0}return (a|0)!=(c|0)|0}function L7a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=M7a(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;N7a(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;O7a(a,c);P7a(c);t=h;return}}function M7a(a){a=a|0;return 1073741823}function N7a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function O7a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function P7a(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function Q7a(a){a=a|0;return +(+n[(f[a+12>>2]|0)+16>>2])}function R7a(a,b){a=a|0;b=b|0;f[a>>2]=43368;f[a+4>>2]=f[b>>2];b=a+8|0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;f[b+12>>2]=0;f[b+16>>2]=0;return}function S7a(a){a=a|0;return a+4|0}function T7a(a){a=a|0;return a+8|0}function U7a(a,b){a=a|0;b=b|0;f[a+8>>2]=f[b>>2];return}function V7a(a){a=a|0;return a+16|0}function W7a(a,b){a=a|0;b=b|0;f[a+16>>2]=f[b>>2];return}function X7a(a){a=a|0;return a+12|0}function Y7a(a,b){a=a|0;b=b|0;f[a+12>>2]=f[b>>2];return}function Z7a(a){a=a|0;return a+20|0}function _7a(a,b){a=a|0;b=b|0;f[a+20>>2]=f[b>>2];return}function $7a(a){a=a|0;return a+24|0}function a8a(a,b){a=a|0;b=b|0;f[a+24>>2]=f[b>>2];return}function b8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74268;f[a+28>>2]=f[c>>2];return}function c8a(a){a=a|0;jpd(a);return}function d8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74284;b=a+28|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];return}function e8a(a){a=a|0;jpd(a);return}function f8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74300;b=a+28|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];f[b+12>>2]=f[c+12>>2];return}function g8a(a){a=a|0;jpd(a);return}function h8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74316;b=a+28|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];f[b+12>>2]=f[c+12>>2];return}function i8a(a){a=a|0;jpd(a);return}function j8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74332;b=a+28|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];f[b+12>>2]=f[c+12>>2];return}function k8a(a){a=a|0;jpd(a);return}function l8a(a,b,c){a=a|0;b=b|0;c=c|0;R7a(a,b);f[a>>2]=74348;ns(a+28|0,c);return}function m8a(a){a=a|0;jpd(a);return}function n8a(a,b){a=a|0;b=+b;n[f[a+4>>2]>>2]=b;return}function o8a(a,b){a=a|0;b=+b;n[(f[a+4>>2]|0)+4>>2]=b;return}function p8a(a,b){a=a|0;b=+b;n[(f[a+4>>2]|0)+8>>2]=b;return}function q8a(a,b){a=a|0;b=b|0;d[(f[a+4>>2]|0)+12>>1]=b;return}function r8a(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+14>>0]=c&1;return}function s8a(a,b){a=a|0;b=b|0;var c=0;c=f[b>>2]|0;f[a>>2]=c;f[a+(f[c+-20>>2]|0)>>2]=f[b+4>>2];b=gpd(20)|0;t8a(b);f[a+4>>2]=b;f[a+8>>2]=0;return}function t8a(a){a=a|0;var c=0;c=t;t=t+16|0;u8a(a,c);f[a+12>>2]=0;b[a+16>>0]=0;b[a+17>>0]=0;t=c;return}function u8a(a,b){a=a|0;b=b|0;f[a+4>>2]=0;f[a+8>>2]=0;f[a>>2]=a+4;return}function v8a(a){a=a|0;return f[(f[a+4>>2]|0)+12>>2]|0}function w8a(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+12>>2]=b;return}function x8a(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+16>>0]=c&1;return}function y8a(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+17>>0]=c&1;return}function z8a(a){a=a|0;return (b[(f[a+4>>2]|0)+16>>0]|0)!=0|0}function A8a(a){a=a|0;return (b[(f[a+4>>2]|0)+17>>0]|0)!=0|0}function B8a(a,b){a=a|0;b=b|0;var c=0;a=f[a+4>>2]|0;if((f[a+8>>2]|0)>>>0<=b>>>0){c=0;return c|0}a=f[a>>2]|0;a:do if((b|0)>-1){c=b;while(1){if((c|0)<=0)break a;b=f[a+4>>2]|0;if(!b)while(1){b=f[a+8>>2]|0;if((f[b>>2]|0)==(a|0)){a=b;break}else a=b}else{a=b;while(1){b=f[a>>2]|0;if(!b)break;else a=b}}c=c+-1|0}}else{c=b;while(1){if((c|0)>=0)break a;b=f[a>>2]|0;if(!b)do{b=a;a=f[a+8>>2]|0}while((f[a>>2]|0)==(b|0));else{a=b;while(1){b=f[a+4>>2]|0;if(!b)break;else a=b}}c=c+1|0}}while(0);c=f[a+16>>2]|0;return c|0}function C8a(a,b,c){a=a|0;b=b|0;c=c|0;return D8a(f[a+4>>2]|0,+n[b>>2],c)|0}function D8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(32)|0;b8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function E8a(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0;j=t;t=t+16|0;h=j+12|0;i=j;d=F8a(c,h,d)|0;g=f[d>>2]|0;if(g|0){i=g;h=0;f[a>>2]=i;i=a+4|0;b[i>>0]=h;t=j;return}G8a(i,c,e);H8a(c,f[h>>2]|0,d,f[i>>2]|0);i=f[i>>2]|0;h=1;f[a>>2]=i;i=a+4|0;b[i>>0]=h;t=j;return}function F8a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;d=a+4|0;g=f[d>>2]|0;e=I8a(a)|0;if(!g){f[b>>2]=d;b=d;return b|0}h=a+8|0;d=e;while(1){a=g+16|0;if(J8a(h,f[c>>2]|0,f[a>>2]|0)|0){a=f[g>>2]|0;if(!a){a=5;break}else d=g}else{if(!(J8a(h,f[a>>2]|0,f[c>>2]|0)|0)){a=9;break}d=g+4|0;a=f[d>>2]|0;if(!a){a=8;break}}g=a}if((a|0)==5){f[b>>2]=g;b=g;return b|0}else if((a|0)==8){f[b>>2]=g;b=d;return b|0}else if((a|0)==9){f[b>>2]=g;b=d;return b|0}return 0}function G8a(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=gpd(20)|0;f[a>>2]=e;f[a+4>>2]=c+4;f[e+16>>2]=f[d>>2];b[a+8>>0]=1;return}function H8a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=b;f[c>>2]=d;b=f[f[a>>2]>>2]|0;if(b){f[a>>2]=b;d=f[c>>2]|0}ai(f[a+4>>2]|0,d);a=a+8|0;f[a>>2]=(f[a>>2]|0)+1;return}function I8a(a){a=a|0;return a+4|0}function J8a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;b=S7a(b)|0;d=+n[b>>2];c=S7a(c)|0;return d<+n[c>>2]|0}function K8a(a,b){a=a|0;b=b|0;return B8a(a,b)|0}function L8a(a,b,c){a=a|0;b=b|0;c=c|0;return M8a(f[a+4>>2]|0,+n[b>>2],c)|0}function M8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(44)|0;l8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function N8a(a,b,c){a=a|0;b=b|0;c=c|0;return O8a(f[a+4>>2]|0,+n[b>>2],c)|0}function O8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(40)|0;d8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function P8a(a,b){a=a|0;b=b|0;return B8a(a,b)|0}function Q8a(a,b,c){a=a|0;b=b|0;c=c|0;return R8a(f[a+4>>2]|0,+n[b>>2],c)|0}function R8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(44)|0;f8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function S8a(a,b){a=a|0;b=b|0;return B8a(a,b)|0}function T8a(a,b,c){a=a|0;b=b|0;c=c|0;return U8a(f[a+4>>2]|0,+n[b>>2],c)|0}function U8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(44)|0;j8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function V8a(a,b){a=a|0;b=b|0;return B8a(a,b)|0}function W8a(a,b,c){a=a|0;b=b|0;c=c|0;return X8a(f[a+4>>2]|0,+n[b>>2],c)|0}function X8a(a,b,c){a=a|0;b=+b;c=c|0;var d=0,e=0,g=0,h=0;e=t;t=t+16|0;h=e;g=e+4|0;n[h>>2]=b;d=gpd(44)|0;h8a(d,h,c);f[g>>2]=d;E8a(e+8|0,a,g,g);t=e;return d|0}function Y8a(a,b){a=a|0;b=b|0;return B8a(a,b)|0}function Z8a(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+12>>2]|0;e=d+12|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+16>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function _8a(a,b,c,d,e,g,h){a=a|0;b=b|0;c=c|0;d=+d;e=+e;g=+g;h=h|0;var i=0;i=gpd(24)|0;Rr(i,b,c,d,e,g,h);f[a>>2]=i;return}function $8a(a,b){a=a|0;b=b|0;return qR((f[a+20>>2]|0)+4|0,b)|0}function a9a(a,b,c){a=a|0;b=b|0;c=c|0;if(!b)return;EQ((f[a+20>>2]|0)+4|0,b,c);return}function b9a(a){a=a|0;return c9a(f[a+24>>2]|0)|0}function c9a(a){a=a|0;return zr(f[a>>2]|0)|0}function d9a(a){a=a|0;return e9a(f[a+24>>2]|0)|0}function e9a(a){a=a|0;return f9a(f[a>>2]|0)|0}function f9a(a){a=a|0;return (f[a+4>>2]|0)-(f[a>>2]|0)>>2|0}function g9a(a,b){a=a|0;b=b|0;return h9a(f[a+24>>2]|0,b)|0}function h9a(a,b){a=a|0;b=b|0;return i9a(f[a>>2]|0,b)|0}function i9a(a,b){a=a|0;b=b|0;b=j9a(a,b)|0;return f[b>>2]|0}function j9a(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if((f[a+4>>2]|0)-c>>2>>>0>b>>>0)return c+(b<<2)|0;else lqd(a);return 0}function k9a(a,b){a=a|0;b=b|0;return h9a(f[a+24>>2]|0,b)|0}function l9a(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;yCb(d,b);GCb((f[a+12>>2]|0)+8|0,d)|0;ECb(d);t=c;return}function m9a(a){a=a|0;return f[a+4>>2]|0}function n9a(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=f[a+4>>2]|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function o9a(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;a=f[c>>2]|0;if((f[c+4>>2]|0)-a>>2>>>0<=b>>>0){c=0;return c|0}c=f[a+(b<<2)>>2]|0;return c|0}function p9a(a,c){a=a|0;c=c|0;c=f[c>>2]|0;if((b[c+11>>0]|0)<0)c=f[c>>2]|0;yCb(a,c);return}function q9a(a,b){a=a|0;b=b|0;return G9a(f[a>>2]|0,b)|0}function r9a(a,b){a=a|0;b=b|0;var c=0;c=gpd(24)|0;E9a(c,f[b>>2]|0);F9a(a,c);return}function s9a(a){a=a|0;return D9a(f[a>>2]|0)|0}function t9a(a){a=a|0;var b=0;b=f[a>>2]|0;a=f[b>>2]|0;if((a|0)==(f[b+4>>2]|0)){b=0;return b|0}b=f[a>>2]|0;return b|0}function u9a(a,c){a=a|0;c=c|0;c=f[c>>2]|0;if((b[c+11>>0]|0)<0)c=f[c>>2]|0;yCb(a,c);return}function v9a(a,c){a=a|0;c=c|0;c=(f[c>>2]|0)+12|0;if((b[c+11>>0]|0)<0)c=f[c>>2]|0;yCb(a,c);return}function w9a(a){a=a|0;return f[(f[a>>2]|0)+24>>2]|0}function x9a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+16|0;e=h;g=gpd(4)|0;A9a(g,b,c,d);f[e>>2]=g;a=f[a>>2]|0;b=a+20|0;c=f[b>>2]|0;if((c|0)==(f[a+24>>2]|0)){B9a(a+16|0,e);t=h;return}else{f[c>>2]=g;f[b>>2]=(f[b>>2]|0)+4;t=h;return}}function y9a(a){a=a|0;a=f[a>>2]|0;if(!a)return;z9a(a);jpd(a);return}function z9a(a){a=a|0;Apd(a+12|0);return}function A9a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=gpd(28)|0;C9a(e,b,c,d);f[a>>2]=e;return}function B9a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=jw(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;kw(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;lw(a,c);mw(c);t=h;return}}function C9a(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;e=0;while(1){if((e|0)==3)break;f[a+(e<<2)>>2]=0;e=e+1|0}g=a+12|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;e=0;while(1){if((e|0)==3)break;f[g+(e<<2)>>2]=0;e=e+1|0}f[a+24>>2]=d;if(b|0)Gpd(a,b)|0;if(!c)return;Gpd(g,c)|0;return}function D9a(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c=a+8|0;if(!(b[c>>0]|0))f[a>>2]=(f[a>>2]|0)+4;else b[c>>0]=0;k=a+12|0;l=k+11|0;e=b[l>>0]|0;if(e<<24>>24<0)c=f[a+16>>2]|0;else c=e&255;a:do if(!c)c=a+4|0;else{d=f[a>>2]|0;c=a+4|0;if((d|0)==(f[c>>2]|0)){a=0;return a|0}j=a+16|0;while(1){g=f[f[d>>2]>>2]|0;i=b[g+11>>0]|0;h=i<<24>>24<0;i=h?f[g+4>>2]|0:i&255;if(e<<24>>24<0){d=f[j>>2]|0;e=f[k>>2]|0}else{d=e&255;e=k}m=i>>>0<d>>>0;h=No(e,h?f[g>>2]|0:g,m?i:d)|0;if(!(((h|0)==0?(d>>>0<i>>>0?-1:m&1):h)|0))break a;d=(f[a>>2]|0)+4|0;f[a>>2]=d;if((d|0)==(f[c>>2]|0)){c=0;break}e=b[l>>0]|0}return c|0}while(0);m=(f[a>>2]|0)!=(f[c>>2]|0);return m|0}function E9a(a,c){a=a|0;c=c|0;f[a>>2]=f[c+16>>2];f[a+4>>2]=f[c+20>>2];b[a+8>>0]=1;c=a+12|0;f[c>>2]=0;f[c+4>>2]=0;f[c+8>>2]=0;a=0;while(1){if((a|0)==3)break;f[c+(a<<2)>>2]=0;a=a+1|0}return}function F9a(a,b){a=a|0;b=b|0;f[a>>2]=b;return}function G9a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;e=g;c=H9a(a,b)|0;if(c|0){e=c;t=g;return e|0}d=gpd(4)|0;I9a(d,b,0);f[e>>2]=d;c=a+4|0;b=f[c>>2]|0;if((b|0)==(f[a+8>>2]|0))J9a(a,e);else{f[b>>2]=d;f[c>>2]=(f[c>>2]|0)+4}e=f[e>>2]|0;t=g;return e|0}function H9a(a,b){a=a|0;b=b|0;var c=0,d=0;c=f[a+4>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(c|0)){a=0;d=6;break}if(!(Qpd(f[f[a>>2]>>2]|0,b)|0))break;a=a+4|0}if((d|0)==6)return a|0;d=f[a>>2]|0;return d|0}function I9a(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=gpd(28)|0;K9a(d,b,c);f[a>>2]=d;return}function J9a(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=aw(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;bw(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;cw(a,c);dw(c);t=h;return}}function K9a(a,c,d){a=a|0;c=c|0;d=d|0;var e=0;e=d&1;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;d=0;while(1){if((d|0)==3)break;f[a+(d<<2)>>2]=0;d=d+1|0}b[a+12>>0]=e;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;if(!c)return;Gpd(a,c)|0;return}function L9a(a){a=a|0;var b=0;b=f[a+4>>2]|0;sd[f[f[b>>2]>>2]&2047](b)|0;return a|0}function M9a(a){a=a|0;a=f[a+4>>2]|0;return sd[f[(f[a>>2]|0)+4>>2]&2047](a)|0}function N9a(a){a=a|0;return L9a(a)|0}function O9a(a){a=a|0;return M9a(a)|0}function P9a(a,c){a=a|0;c=c|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[c+4>>2];f[a+8>>2]=f[c+8>>2];b[a+24>>0]=0;return}function Q9a(a,c){a=a|0;c=c|0;var d=0;d=a+12|0;f[d>>2]=f[c>>2];f[d+4>>2]=f[c+4>>2];f[d+8>>2]=f[c+8>>2];b[a+24>>0]=0;return}function R9a(a,c,d){a=a|0;c=c|0;d=d|0;b[a+24>>0]=1;r6a(a,c);r6a(a,d);return}function S9a(a){a=a|0;return (b[(f[a+12>>2]|0)+52>>0]|0)!=0|0}function T9a(a,c){a=a|0;c=c|0;b[(f[a+12>>2]|0)+52>>0]=c&1;return}function U9a(a,b){a=a|0;b=+b;n[(f[a+12>>2]|0)+44>>2]=b;return}function V9a(a){a=a|0;return +(+n[(f[a+12>>2]|0)+44>>2])}function W9a(a,b){a=a|0;b=+b;n[(f[a+12>>2]|0)+48>>2]=b;return}function X9a(a){a=a|0;return +(+n[(f[a+12>>2]|0)+48>>2])}function Y9a(a,b){a=a|0;b=b|0;a=f[a+12>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Z9a(a){a=a|0;return f[a+12>>2]|0}function _9a(a,b){a=a|0;b=b|0;a=(f[a+12>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function $9a(a){a=a|0;return (f[a+12>>2]|0)+12|0}function aab(a,b){a=a|0;b=b|0;a=(f[a+12>>2]|0)+24|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function bab(a){a=a|0;return (f[a+12>>2]|0)+24|0}function cab(a,b){a=a|0;b=+b;n[(f[a+12>>2]|0)+36>>2]=b;return}function dab(a){a=a|0;return +(+n[(f[a+12>>2]|0)+36>>2])}function eab(a,b){a=a|0;b=+b;n[(f[a+12>>2]|0)+40>>2]=b;return}function fab(a){a=a|0;return +(+n[(f[a+12>>2]|0)+40>>2])}function gab(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+64>>2]=b;return}function hab(a){a=a|0;return f[(f[a+12>>2]|0)+64>>2]|0}function iab(a,c){a=a|0;c=c|0;b[(f[a+12>>2]|0)+60>>0]=c&1;return}function jab(a){a=a|0;return (b[(f[a+12>>2]|0)+60>>0]|0)!=0|0}function kab(a,b){a=a|0;b=+b;n[(f[a+12>>2]|0)+56>>2]=b;return}function lab(a){a=a|0;return +(+n[(f[a+12>>2]|0)+56>>2])}function mab(a){a=a|0;var b=0;bN(a);f[a>>2]=51632;b=gpd(36)|0;nab(b);f[a+8>>2]=b;return}function nab(a){a=a|0;var b=0;b=t;t=t+16|0;oab(a,b);a=a+12|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;t=b;return}function oab(a,b){a=a|0;b=b|0;f[a+4>>2]=0;f[a+8>>2]=0;f[a>>2]=a+4;return}function pab(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=t;t=t+16|0;h=g;wk(h,b,c,d,e);f[a>>2]=f[h>>2];f[a+4>>2]=f[h+4>>2];f[a+8>>2]=f[h+8>>2];f[a+12>>2]=f[h+12>>2];t=g;return}function qab(a){a=a|0;return +n[a+12>>2]!=-1.0|0}function rab(a){a=a|0;return a|0}function sab(a){a=a|0;return a+4|0}function tab(a){a=a|0;return a+8|0}function uab(a){a=a|0;return a+12|0}function vab(a){a=a|0;f[a>>2]=74364;return}function wab(a){a=a|0;Sc()}function xab(a,b){a=a|0;b=b|0;var c=0;c=f[b>>2]|0;f[a>>2]=c;f[a+(f[c+-20>>2]|0)>>2]=f[b+4>>2];f[a+4>>2]=0;return}function yab(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=(f[a+8>>2]|0)+4|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function zab(a){a=a|0;var b=0;b=gpd(12)|0;Aab(b);f[a>>2]=b;return}function Aab(a){a=a|0;var b=0;b=t;t=t+16|0;qba(a,b);t=b;return}function Bab(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;a=f[a>>2]|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;wpd(e,b,Th(b)|0);Gpd(rba(a,e)|0,c)|0;Apd(e);t=d;return}function Cab(a){a=a|0;f[a>>2]=74388;return}function Dab(a){a=a|0;Sc()}function Eab(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;Cab(a);f[a>>2]=60384;e=a+4|0;f[e>>2]=0;f[e+4>>2]=0;f[e+8>>2]=0;f[e+12>>2]=0;f[e+16>>2]=0;f[e+20>>2]=0;b[a+28>>0]=1;f[a+32>>2]=1;return}function Fab(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=gpd(16)|0;Gab(d,b,c);r5(a,d);return d|0}function Gab(a,b,c){a=a|0;b=b|0;c=c|0;xm(a,b,1,c);f[a>>2]=67040;c=gpd(292)|0;Hab(c);f[a+12>>2]=c;return}function Hab(a){a=a|0;var c=0,d=0,e=0,g=0,h=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;c=0;while(1){if((c|0)==3)break;f[a+(c<<2)>>2]=0;c=c+1|0}h=a+12|0;vk(h);g=a+28|0;vk(g);e=a+44|0;vk(e);d=a+60|0;vk(d);c=a+88|0;vk(c);f[a+112>>2]=0;f[a+116>>2]=0;f[a+120>>2]=0;Mrd(a+140|0,0,144)|0;Rp(a+284|0,0);f[h>>2]=f[10700];f[h+4>>2]=f[10701];f[h+8>>2]=f[10702];f[h+12>>2]=f[10703];f[g>>2]=f[10700];f[g+4>>2]=f[10701];f[g+8>>2]=f[10702];f[g+12>>2]=f[10703];f[e>>2]=f[10696];f[e+4>>2]=f[10697];f[e+8>>2]=f[10698];f[e+12>>2]=f[10699];f[d>>2]=f[10692];f[d+4>>2]=f[10693];f[d+8>>2]=f[10694];f[d+12>>2]=f[10695];n[a+76>>2]=.20000000298023224;n[a+80>>2]=.4000000059604645;n[a+84>>2]=1.0;f[c>>2]=f[10692];f[c+4>>2]=f[10693];f[c+8>>2]=f[10694];f[c+12>>2]=f[10695];n[a+104>>2]=0.0;f[a+108>>2]=0;n[a+124>>2]=1.0;f[a+132>>2]=0;n[a+128>>2]=0.0;b[a+136>>0]=1;b[a+288>>0]=0;return}function Iab(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(20)|0;V6a(a,d,c);if(!b)return a|0;Gy(b,a)|0;return a|0}function Jab(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;return}function Kab(a,b){a=a|0;b=b|0;var c=0;c=gpd(24)|0;Lab(c,b);f[a>>2]=c;return}function Lab(a,b){a=a|0;b=b|0;var c=0;c=ZY(b)|0;f[a>>2]=c;Mab(a+4|0,b);cs(a+8|0,0.0,0.0);cs(a+16|0,0.0,0.0);return}function Mab(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Nab(a,b){a=a|0;b=b|0;f[f[a>>2]>>2]=b;return}function Oab(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=(f[a>>2]|0)+8|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function Pab(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=(f[a>>2]|0)+16|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function Qab(a){a=a|0;return (f[a+20>>2]|0)+108|0}function Rab(a,c){a=a|0;c=c|0;b[(f[a+28>>2]|0)+147>>0]=c&1;return}function Sab(a,b){a=a|0;b=b|0;Dq((f[a+28>>2]|0)+196|0,b)|0;return}function Tab(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;Ol(a+4|0,b);L8(a,c);M8(a,d);return}function Uab(a,b,c){a=a|0;b=b|0;c=c|0;a=a+24|0;Pm(b,(f[a>>2]|0)+56|0)|0;Pm(c,(f[a>>2]|0)+68|0)|0;return}function Vab(a,c){a=a|0;c=c|0;b[f[a+24>>2]>>0]=c&1;return}function Wab(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;c=IR(a,b,c)|0;Jd[f[(f[c>>2]|0)+56>>2]&1023](c,d);return c|0}function Xab(a){a=a|0;var b=0,c=0,d=0;b=t;t=t+16|0;c=b;d=f[a+84>>2]|0;a=f[a+88>>2]|0;f[c>>2]=667;rz(d,a,c);t=b;return}function Yab(a,b){a=a|0;b=b|0;a=sd[f[(f[a>>2]|0)+40>>2]&2047](a)|0;return a>>>0<(sd[f[(f[b>>2]|0)+40>>2]&2047](b)|0)>>>0|0}function Zab(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=t;t=t+16|0;e=g;a=a+4|0;if(_ab(f[a>>2]|0,b,c)|0){e=0;t=g;return e|0}d=f[a>>2]|0;$ab(e,b,c);a=d+4|0;b=f[a>>2]|0;if(b>>>0<(f[d+8>>2]|0)>>>0){abb(b,e);f[a>>2]=(f[a>>2]|0)+8}else bbb(d,e);xW(e);e=1;t=g;return e|0}function _ab(a,b,c){a=a|0;b=b|0;c=c|0;c=jbb(a,b,c)|0;return (c|0)!=(f[a+4>>2]|0)|0}function $ab(a,b,c){a=a|0;b=b|0;c=c|0;ibb(a,b);f[a+4>>2]=f[c>>2];return}function abb(a,b){a=a|0;b=b|0;hbb(a,b);f[a+4>>2]=f[b+4>>2];return}function bbb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>3)+1|0;g=cbb(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>2;dbb(c,k>>3>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>3,a+8|0);g=c+8|0;abb(f[g>>2]|0,b);f[g>>2]=(f[g>>2]|0)+8;ebb(a,c);fbb(c);t=h;return}}function cbb(a){a=a|0;return 536870911}function dbb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>536870911){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<3)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<3)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<3);return}function ebb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;e=a+4|0;g=b+4|0;c=f[e>>2]|0;while(1){if((c|0)==(d|0))break;h=c+-8|0;gbb((f[g>>2]|0)+-8|0,h);f[g>>2]=(f[g>>2]|0)+-8;c=h}d=f[a>>2]|0;f[a>>2]=f[g>>2];f[g>>2]=d;d=b+8|0;h=f[e>>2]|0;f[e>>2]=f[d>>2];f[d>>2]=h;d=a+8|0;h=b+12|0;e=f[d>>2]|0;f[d>>2]=f[h>>2];f[h>>2]=e;f[b>>2]=f[g>>2];return}function fbb(a){a=a|0;var b=0,c=0,d=0;b=f[a+4>>2]|0;c=a+8|0;while(1){d=f[c>>2]|0;if((d|0)==(b|0))break;d=d+-8|0;f[c>>2]=d;xW(d)}a=f[a>>2]|0;if(!a)return;jpd(a);return}function gbb(a,b){a=a|0;b=b|0;hbb(a,b);f[a+4>>2]=f[b+4>>2];return}function hbb(a,b){a=a|0;b=b|0;b=f[b>>2]|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function ibb(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function jbb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;d=a+4|0;e=f[d>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(e|0))break;if((kbb(a)|0)==(b|0)?(f[a+4>>2]|0)==(f[c>>2]|0):0){g=7;break}a=a+8|0}if((g|0)==7)return a|0;g=f[d>>2]|0;return g|0}function kbb(a){a=a|0;return f[a>>2]|0}function lbb(a){a=a|0;return f[a>>2]|0}function mbb(a,b,c){a=a|0;b=b|0;c=c|0;f[a>>2]=b;f[a+4>>2]=f[c>>2];return}function nbb(a,b){a=a|0;b=b|0;var c=0;c=gpd(12)|0;obb(c,f[b>>2]|0);f[a>>2]=c;return}function obb(a,b){a=a|0;b=b|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;Yv(a,b)|0;return}function pbb(a){a=a|0;return (f[a+24>>2]|0)+28|0}function qbb(a,b,c){a=a|0;b=b|0;c=c|0;rbb(a,(f[b+24>>2]|0)+28|0,c);return}function rbb(a,c,d){a=a|0;c=c|0;d=d|0;d=sbb(f[c>>2]|0,d)|0;if((d|0)==(f[(f[c>>2]|0)+4>>2]|0)){xCb(a);return}d=d+12|0;if((b[d+11>>0]|0)<0)d=f[d>>2]|0;yCb(a,d);return}function sbb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[c>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(d|0))break;if(!(Qpd(a,b)|0)){e=6;break}a=a+24|0}if((e|0)==6)return a|0;e=f[c>>2]|0;return e|0}function tbb(a,b){a=a|0;b=b|0;b=sbb(f[a>>2]|0,b)|0;return (b|0)!=(f[(f[a>>2]|0)+4>>2]|0)|0}function ubb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;j=k;c=sbb(f[a>>2]|0,c)|0;i=(f[a>>2]|0)+4|0;h=f[i>>2]|0;if((c|0)==(h|0)){j=0;t=k;return j|0}g=c;while(1){e=g+24|0;if((e|0)==(h|0))break;c=g+11|0;if((b[c>>0]|0)<0){d=f[g>>2]|0;b[j>>0]=0;Uh(d,j);f[g+4>>2]=0}else{b[j>>0]=0;Uh(g,j);b[c>>0]=0}Fpd(g,0);f[g>>2]=f[e>>2];f[g+4>>2]=f[e+4>>2];f[g+8>>2]=f[e+8>>2];c=0;while(1){if((c|0)==3)break;f[e+(c<<2)>>2]=0;c=c+1|0}d=g+36|0;c=g+12|0;a=c+11|0;if((b[a>>0]|0)<0){a=f[c>>2]|0;b[j>>0]=0;Uh(a,j);f[g+16>>2]=0}else{b[j>>0]=0;Uh(c,j);b[a>>0]=0}Fpd(c,0);f[c>>2]=f[d>>2];f[c+4>>2]=f[d+4>>2];f[c+8>>2]=f[d+8>>2];c=0;while(1){if((c|0)==3)break;f[d+(c<<2)>>2]=0;c=c+1|0}g=e}c=f[i>>2]|0;while(1){if((c|0)==(g|0))break;j=c+-24|0;Bk(j);c=j}f[i>>2]=g;j=1;t=k;return j|0}function vbb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;GG(d,b);iH((f[a+24>>2]|0)+80|0,d)|0;LG(d);d=b+4|0;d=sd[f[(f[d>>2]|0)+32>>2]&2047](d)|0;Uab(a,d,WN(b)|0);t=c;return}function wbb(a){a=a|0;return (f[a+24>>2]|0)+96|0}function xbb(a){a=a|0;var c=0;a=f[a>>2]|0;c=b[a+11>>0]|0;if(c<<24>>24<0){c=f[a+4>>2]|0;c=(c|0)!=0;return c|0}else{c=c&255;c=(c|0)!=0;return c|0}return 0}function ybb(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=1065353216;return}function zbb(a,b){a=a|0;b=b|0;var c=0;c=gpd(20)|0;ybb(c);f[a>>2]=c;Abb(a,b);return}function Abb(a,b){a=a|0;b=b|0;var c=0,d=0;if(!b)return;d=MN(b)|0;c=0;while(1){if((c|0)==(d|0))break;Bbb(a,NN(b,c)|0)|0;c=c+1|0}return}function Bbb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0;h=t;t=t+48|0;d=h+24|0;i=h+16|0;e=h+8|0;g=h;a=f[a>>2]|0;VN(g,c);JN(e,g);f[e+4>>2]=c;RN(d,a,e);Cbb(i,a,f[d>>2]|0);c=i+4|0;if(b[c>>0]|0){f[d>>2]=0;i=1;QN(e);kC(g);t=h;return i|0}a=f[d>>2]|0;f[d>>2]=0;if(!a){i=0;QN(e);kC(g);t=h;return i|0}if(b[d+8>>0]|0)jC(a+8|0);jpd(a);i=(b[c>>0]|0)!=0;QN(e);kC(g);t=h;return i|0}function Cbb(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0.0,j=0.0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0;p=d+8|0;e=HN(c+12|0,p)|0;s=d+4|0;f[s>>2]=e;q=c+4|0;k=f[q>>2]|0;r=(k|0)==0;a:do if(!r){m=k+-1|0;o=(m&k|0)==0;if(!o)if(e>>>0<k>>>0)h=e;else h=(e>>>0)%(k>>>0)|0;else h=m&e;e=f[(f[c>>2]|0)+(h<<2)>>2]|0;if(!e)e=h;else{l=c+16|0;while(1){e=f[e>>2]|0;if(!e){e=h;break a}g=f[e+4>>2]|0;if(!o){if(g>>>0>=k>>>0)g=(g>>>0)%(k>>>0)|0}else g=g&m;if((g|0)!=(h|0)){e=h;break a}if(EN(l,e+8|0,p)|0){g=0;break}}d=e;f[a>>2]=d;a=a+4|0;b[a>>0]=g;return}}else e=0;while(0);l=c+12|0;i=+(((f[l>>2]|0)+1|0)>>>0);j=+n[c+16>>2];do if(r|j*+(k>>>0)<i){h=k<<1|(k>>>0<3|(k+-1&k|0)!=0)&1;e=~~+U(+(i/j))>>>0;TN(c,h>>>0<e>>>0?e:h);h=f[q>>2]|0;e=f[s>>2]|0;g=h+-1|0;if(!(g&h)){k=h;e=g&e;break}if(e>>>0<h>>>0)k=h;else{k=h;e=(e>>>0)%(h>>>0)|0}}while(0);g=f[(f[c>>2]|0)+(e<<2)>>2]|0;if(!g){s=c+8|0;f[d>>2]=f[s>>2];f[s>>2]=d;f[(f[c>>2]|0)+(e<<2)>>2]=s;e=f[d>>2]|0;if(!e)e=d;else{e=f[e+4>>2]|0;g=k+-1|0;if(g&k){if(e>>>0>=k>>>0)e=(e>>>0)%(k>>>0)|0}else e=e&g;f[(f[c>>2]|0)+(e<<2)>>2]=d;e=d}}else{f[d>>2]=f[g>>2];f[g>>2]=d;e=d}f[l>>2]=(f[l>>2]|0)+1;d=1;c=e;f[a>>2]=c;a=a+4|0;b[a>>0]=d;return}function Dbb(a){a=a|0;var b=0;b=f[a>>2]|0;if(b|0){Ebb(b);jpd(b)}f[a>>2]=0;return}function Ebb(a){a=a|0;Fbb(a);return}function Fbb(a){a=a|0;hC(a);return}function Gbb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;YN(e,b,c);c=Hbb(a,e)|0;kC(e);t=d;return c|0}function Hbb(a,b){a=a|0;b=b|0;a=DN(f[a>>2]|0,b)|0;if(!a){b=0;return b|0}b=f[a+12>>2]|0;return b|0}function Ibb(a){a=a|0;return h7a(c7a(a,(f[(f[a>>2]|0)+32>>2]|0)+-1|0)|0)|0}function Jbb(a,b,c,d,e,g,h,i,j,k,l,m,n,o,p){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=+i;j=+j;k=+k;l=+l;m=+m;n=+n;o=o|0;p=p|0;var q=0,r=0;r=t;t=t+320|0;q=r;Kbb(q,a,b,c,d,e,g,h,i,j,k,l,m,n,o,p);do if(Lbb(q)|0){a=gpd(16)|0;t6a(a);b=Mbb(q)|0;o=u6a(a,b)|0;if(!o){Hd[f[(f[a>>2]|0)+4>>2]&1023](a);a=0;break}else{Krd(o|0,Nbb(q)|0,b|0)|0;break}}else a=0;while(0);Obb(q);t=r;return a|0}function Kbb(a,b,c,e,g,h,i,j,k,l,m,o,p,q,r,s){a=a|0;b=b|0;c=c|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;k=+k;l=+l;m=+m;o=+o;p=+p;q=+q;r=r|0;s=s|0;ncb(a);d[a>>1]=b;d[a+2>>1]=c;d[a+4>>1]=e;g=g?0:2;h=h?g|4:g;g=h|8;d[a+6>>1]=j?(i?g:h)|1:i?g:h;j=ocb(a+8|0)|0;n[j>>2]=k;n[j+4>>2]=l;n[j+8>>2]=m;n[j+12>>2]=o;n[j+16>>2]=p;n[j+20>>2]=q;f[a+32>>2]=r;f[a+36>>2]=s;return}function Lbb(a){a=a|0;var b=0,c=0,e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0;f[a+300>>2]=0;Tbb(a);e=(j[a+4>>1]|0)+(j[a>>1]|0)|0;f[a+312>>2]=e;if(!e){n=0;return n|0}h=j[a+6>>1]|0;i=(h&2|0)==0;k=(h&4|0)!=0;l=h&1;h=h&8;m=(h|0)==0;b=i?6:3;c=a+304|0;f[c>>2]=b;f[a+308>>2]=b;if(k){b=b+2|0;f[c>>2]=b}c=V(b,e)|0;e=a+2|0;g=l^3;h=Ubb(a+40|0,(V((g<<1)+(h>>>1)|0,j[e>>1]|0)|0)+(c<<2)|0)|0;b=a+316|0;f[b>>2]=h;if(!h){n=0;return n|0}if(!(Vbb(a,i,k)|0)){n=0;return n|0}b=(f[b>>2]|0)+(c<<2)|0;if(d[e>>1]|0?(k=j[a>>1]|0,(Wbb(a,b,(l|0)!=0)|0)!=(k|0)):0){n=0;return n|0}if((!m?(n=d[e>>1]|0,n<<16>>16):0)?!(Xbb(a,b+((V(g,n&65535)|0)<<1)|0)|0):0){n=0;return n|0}n=1;return n|0}function Mbb(a){a=a|0;return Sbb(a+40|0)|0}function Nbb(a){a=a|0;return Rbb(a+40|0)|0}function Obb(a){a=a|0;Pbb(a+40|0);return}function Pbb(a){a=a|0;Qbb(a);a=f[a+12>>2]|0;if(!a)return;kpd(a);return}function Qbb(a){a=a|0;var b=0,c=0;b=a+16|0;c=f[b>>2]|0;if(c|0){kpd(c);f[b>>2]=0}f[a+4>>2]=0;return}function Rbb(a){a=a|0;var b=0;b=f[a+16>>2]|0;if(b|0)return b|0;b=f[a+12>>2]|0;return b|0}function Sbb(a){a=a|0;return f[a+4>>2]|0}function Tbb(a){a=a|0;var b=0;b=a+288|0;f[b>>2]=0;f[b+4>>2]=0;f[b+8>>2]=0;b=f[a+300>>2]|0;mcb(a+60|0,(f[a+32>>2]|0)+b|0,(f[a+36>>2]|0)-b|0);return}function Ubb(a,b){a=a|0;b=b|0;Qbb(a);f[a+4>>2]=b;if((f[a>>2]|0)>>>0<b>>>0){b=lcb(a,b)|0;f[a+16>>2]=b;return b|0}else{b=f[a+12>>2]|0;return b|0}return 0}function Vbb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,g=0.0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0;s=t;t=t+16|0;k=s+4|0;h=s;r=a+60|0;if(!(Zbb(r,-1)|0)){r=0;t=s;return r|0}d=f[r>>2]|0;l=(d|0)!=0;if(l?!(fcb(a,d)|0):0){r=0;t=s;return r|0}if(b){if(!(Zbb(r,-1)|0)){r=0;t=s;return r|0}b=f[r>>2]|0;if(b){if(!(gcb(a,b)|0)){r=0;t=s;return r|0}}else b=0}else b=1;if(!c){b=(b|0)!=0;if(l&b){r=1;t=s;return r|0}else{d=0;p=1;o=b}}else{if(!(Zbb(r,-1)|0)){r=0;t=s;return r|0}c=f[r>>2]|0;if(c)if(hcb(a,c)|0)d=1;else{r=0;t=s;return r|0}else d=0;p=(c|0)!=0;o=(b|0)!=0}c=f[a+32>>2]|0;q=c+(f[a+36>>2]|0)|0;c=c+(Ybb(r)|0)|0;if(d){if((c+8|0)>>>0>q>>>0){r=0;t=s;return r|0}icb(c,k,1);c=c+4|0;icb(c,h,1);c=c+4|0;g=+n[k>>2];e=+n[h>>2];a:do if(g!=0.0|e!=1.0){e=e-g;d=f[a+312>>2]|0;h=a+316|0;i=a+304|0;j=a+308|0;b=0;while(1){if((b|0)==(d|0))break a;m=(f[h>>2]|0)+((V(f[i>>2]|0,b)|0)<<2)|0;m=m+(f[j>>2]<<2)|0;n[m>>2]=e*+n[m>>2]+ +n[k>>2];m=m+4|0;n[m>>2]=e*+n[m>>2]+ +n[k>>2];b=b+1|0}}while(0);b=8}else b=0;if(!l){k=a+312|0;d=f[k>>2]|0;if((c+(d*12|0)|0)>>>0>q>>>0){r=0;t=s;return r|0}l=a+316|0;m=a+304|0;j=0;while(1){if((j|0)==3)break;i=(f[l>>2]|0)+(j<<2)|0;h=0;while(1){if(h>>>0>=d>>>0)break;icb(c,i+((V(f[m>>2]|0,h)|0)<<2)|0,1);h=h+1|0;c=c+4|0;d=f[k>>2]|0}j=j+1|0}b=(d*12|0)+b|0}if(!o){k=a+312|0;d=f[k>>2]|0;if((c+(d*12|0)|0)>>>0>q>>>0){r=0;t=s;return r|0}l=a+316|0;m=a+304|0;j=0;while(1){if((j|0)==3)break;i=(f[l>>2]|0)+12+(j<<2)|0;h=0;while(1){if(h>>>0>=d>>>0)break;icb(c,i+((V(f[m>>2]|0,h)|0)<<2)|0,1);h=h+1|0;c=c+4|0;d=f[k>>2]|0}j=j+1|0}b=(d*12|0)+b|0}if(!p){o=a+312|0;d=f[o>>2]|0;if((c+(d<<3)|0)>>>0>q>>>0){r=0;t=s;return r|0}l=a+316|0;m=a+308|0;k=a+304|0;j=0;while(1){if((j|0)==2)break;i=(f[l>>2]|0)+(f[m>>2]<<2)+(j<<2)|0;h=0;while(1){if(h>>>0>=d>>>0)break;icb(c,i+((V(f[k>>2]|0,h)|0)<<2)|0,1);h=h+1|0;c=c+4|0;d=f[o>>2]|0}j=j+1|0}b=(d<<3)+b|0}jcb(r,b);r=1;t=s;return r|0}function Wbb(a,b,c){a=a|0;b=b|0;c=c|0;var e=0,g=0,h=0,i=0,k=0,l=0,m=0,n=0;k=a+60|0;l=Ybb(k)|0;f[a+300>>2]=l;Tbb(a);l=j[a+2>>1]|0;i=c?2:3;h=0;c=0;a:while(1){if(h>>>0>=l>>>0)break;g=0;while(1){if(g>>>0>=i>>>0)break;e=a+288+(g<<2)|0;if(!(Zbb(k,f[e>>2]|0)|0)){c=0;m=9;break a}n=f[k>>2]|0;f[e>>2]=n;d[b>>1]=n;g=g+1|0;b=b+2|0;c=n>>>0>c>>>0?n:c}h=h+1|0}if((m|0)==9)return c|0;n=c+1|0;return n|0}function Xbb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=a+60|0;e=Ybb(d)|0;c=a+300|0;f[c>>2]=(f[c>>2]|0)+e;Tbb(a);c=j[a+2>>1]|0;a=b;b=0;while(1){if(b>>>0>=c>>>0){a=1;b=5;break}if(!(Zbb(d,-1)|0)){a=0;b=5;break}f[a>>2]=f[d>>2];a=a+4|0;b=b+1|0}if((b|0)==5)return a|0;return 0}function Ybb(a){a=a|0;return f[a+12>>2]|0}function Zbb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,i=0,j=0,k=0;k=t;t=t+16|0;i=k;b[i>>0]=0;g=f[a>>2]|0;j=a+220|0;d=f[j>>2]|0;a:do if(!d){e=$bb(a,i)|0;e=(b[i>>0]|0)==0?e&255:1;d=e>>>4;do switch(e&15){case 0:{d=_bb(a,d)|0;f[a>>2]=d;break a}case 5:{d=_bb(a,d|16)|0;f[a>>2]=d;break a}case 13:{e=_bb(a,e>>>6)|0;f[a>>2]=e;b[a+224>>0]=d&3;f[j>>2]=1;d=e;break a}case 14:{e=_bb(a,0)|0;f[a>>2]=e;b[a+224>>0]=0;f[j>>2]=d+2;d=e;break a}case 6:{d=(acb(a,d)|0)+(f[a>>2]|0)|0;f[a>>2]=d;break a}case 1:{d=(e>>>5)+1|0;c=f[a>>2]|0;if(!(e&16)){d=c-d|0;f[a>>2]=d;break a}else{d=c+d|0;f[a>>2]=d;break a}}case 3:{d=d+c+1|0;f[a>>2]=d;break a}case 4:{d=c+-1-d|0;f[a>>2]=d;break a}case 7:{d=d+c+17|0;f[a>>2]=d;break a}case 8:{d=c+-17-d|0;f[a>>2]=d;break a}case 9:{d=((($bb(a,i)|0)&255)<<4|d)+((f[a>>2]|0)+3)|0;f[a>>2]=d;break a}case 10:{d=(($bb(a,i)|0)&255)<<4|d;d=(f[a>>2]|0)+-3-d|0;f[a>>2]=d;break a}case 11:{d=(($bb(a,i)|0)&255)<<4|d;f[a>>2]=d;break a}case 12:{d=((bcb(a,i)|0)&65535)<<4|d;f[a>>2]=d;break a}case 15:do switch(d&15){case 4:case 3:case 2:case 1:case 0:{f[a>>2]=d;break a}case 5:{f[a>>2]=255;d=255;break a}case 6:{f[a>>2]=65280;d=65280;break a}case 7:{f[a>>2]=16711680;d=16711680;break a}case 8:{f[a>>2]=-16777216;d=-16777216;break a}case 9:{f[a>>2]=16777215;d=16777215;break a}case 10:{f[a>>2]=-1;d=-1;break a}case 13:{b[a+224>>0]=0;d=((bcb(a,i)|0)&65535)+36|0;f[j>>2]=d;d=f[a>>2]|0;break a}case 11:{d=($bb(a,i)|0)&255|((bcb(a,i)|0)&65535)<<8;f[a>>2]=d;break a}case 12:{d=ccb(a,i)|0;f[a>>2]=d;break a}default:{j=0;t=k;return j|0}}while(0);default:{j=0;t=k;return j|0}}while(0)}else{f[j>>2]=d+-1;d=_bb(a,h[a+224>>0]|0)|0;f[a>>2]=d}while(0);dcb(a,d);d=f[a>>2]|0;do if((d|0)!=(g|0))if(d>>>0>g>>>0){d=d-g|0;if(d>>>0>=2147483647)break;ecb(a,d);break}else{d=g-d|0;if(d>>>0>=2147483647)break;ecb(a,0-d|0);break}while(0);if(!(b[i>>0]|0)){j=1;t=k;return j|0}f[j>>2]=0;f[a>>2]=0;j=0;t=k;return j|0}function _bb(a,b){a=a|0;b=b|0;var c=0;c=f[a+212>>2]|0;return f[a+20+((c>>>0<b>>>0?c+32|0:c)-b<<2)>>2]|0}function $bb(a,c){a=a|0;c=c|0;var d=0,e=0;d=a+12|0;e=f[d>>2]|0;if(e>>>0<(f[a+8>>2]|0)>>>0){c=f[a+4>>2]|0;f[d>>2]=e+1;e=b[c+e>>0]|0;return e|0}else{b[c>>0]=1;e=0;return e|0}return 0}function acb(a,b){a=a|0;b=b|0;var c=0;c=f[a+216>>2]|0;return f[a+148+((c>>>0<b>>>0?c+16|0:c)-b<<2)>>2]|0}function bcb(a,b){a=a|0;b=b|0;var c=0;c=$bb(a,b)|0;return (($bb(a,b)|0)&255)<<8&65535|c&255|0}function ccb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=$bb(a,b)|0;e=$bb(a,b)|0;c=$bb(a,b)|0;return (e&255)<<8|d&255|(c&255)<<16|(($bb(a,b)|0)&255)<<24|0}function dcb(a,b){a=a|0;b=b|0;var c=0,d=0;d=a+212|0;c=(f[d>>2]|0)+1|0;c=c>>>0>31?0:c;f[d>>2]=c;f[a+20+(c<<2)>>2]=b;return}function ecb(a,b){a=a|0;b=b|0;var c=0,d=0;d=a+216|0;c=(f[d>>2]|0)+1|0;c=c>>>0>15?0:c;f[d>>2]=c;f[a+148+(c<<2)>>2]=b;return}function fcb(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,g=0,h=0.0,i=0,j=0,k=0,l=0,m=0;k=kcb(a+8|0)|0;l=a+316|0;h=+(b>>>0);i=a+312|0;j=a+60|0;g=a+304|0;a=0;a:while(1){if(a>>>0>=3){b=1;a=8;break}c=(f[l>>2]|0)+(a<<2)|0;d=+n[k+(a<<2)>>2];e=(+n[k+(a+3<<2)>>2]-d)/h;b=0;while(1){if(b>>>0>=(f[i>>2]|0)>>>0)break;if(!(Zbb(j,-1)|0)){b=0;a=8;break a}m=c+((V(f[g>>2]|0,b)|0)<<2)|0;n[m>>2]=e*+((f[j>>2]|0)>>>0)+d;b=b+1|0}a=a+1|0}if((a|0)==8)return b|0;return 0}function gcb(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0.0,o=0.0,p=0.0,q=0.0;j=a+316|0;g=(f[j>>2]|0)+12|0;k=a+312|0;l=a+60|0;i=a+304|0;c=0;while(1){a=f[k>>2]|0;if(c>>>0>=a>>>0)break;if(!(Zbb(l,-1)|0)){e=0;h=9;break}a=g+((V(f[i>>2]|0,c)|0)<<2)|0;f[a>>2]=f[l>>2];c=c+1|0}if((h|0)==9)return e|0;d=6.283185307179586/+(b>>>0);c=0;while(1){if(c>>>0>=a>>>0){e=1;h=9;break}if(!(Zbb(l,-1)|0)){e=0;h=9;break}a=(f[j>>2]|0)+((V(f[i>>2]|0,c)|0)<<2)+12|0;p=d*+((f[a>>2]|0)>>>0);m=d*+((f[l>>2]|0)>>>0);o=+M(+m);q=+L(+p)*o;n[a>>2]=q;o=+M(+p)*o;n[a+4>>2]=o;m=+L(+m);n[a+8>>2]=m;c=c+1|0;a=f[k>>2]|0}if((h|0)==9)return e|0;return 0}function hcb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0,g=0,h=0,i=0,j=0,k=0;i=a+316|0;j=a+308|0;e=1.0/+(b>>>0);g=a+312|0;h=a+60|0;d=a+304|0;a=0;a:while(1){if(a>>>0>=2){b=1;a=8;break}c=(f[i>>2]|0)+(f[j>>2]<<2)+(a<<2)|0;b=0;while(1){if(b>>>0>=(f[g>>2]|0)>>>0)break;if(!(Zbb(h,-1)|0)){b=0;a=8;break a}k=c+((V(f[d>>2]|0,b)|0)<<2)|0;n[k>>2]=e*+((f[h>>2]|0)>>>0);b=b+1|0}a=a+1|0}if((a|0)==8)return b|0;return 0}function icb(a,b,c){a=a|0;b=b|0;c=c|0;Krd(b|0,a|0,c<<2|0)|0;return}function jcb(a,b){a=a|0;b=b|0;a=a+12|0;f[a>>2]=(f[a>>2]|0)+b;return}function kcb(a){a=a|0;return a|0}function lcb(a,b){a=a|0;b=b|0;switch(f[a+8>>2]|0){case 4:{b=(b>>>2)+((b&3|0)!=0&1)|0;b=b>>>0>1073741823?-1:b<<2;break}case 0:break;default:{a=0;return a|0}}a=hpd(b)|0;return a|0}function mcb(a,c,d){a=a|0;c=c|0;d=d|0;f[a+220>>2]=0;f[a>>2]=0;b[a+224>>0]=0;f[a+4>>2]=c;f[a+8>>2]=d;f[a+12>>2]=0;c=0;while(1){if((c|0)==32)break;f[a+20+(c<<2)>>2]=31-c;c=c+1|0}f[a+212>>2]=31;c=0;while(1){if((c|0)==16)break;f[a+148+(c<<2)>>2]=1;c=c+1|0}f[a+216>>2]=15;return}function ncb(a){a=a|0;pcb(a+40|0,2752512,4);qcb(a+60|0);return}function ocb(a){a=a|0;return a|0}function pcb(a,b,c){a=a|0;b=b|0;c=c|0;f[a>>2]=b;f[a+4>>2]=0;f[a+8>>2]=c;f[a+16>>2]=0;if(!b){f[a+12>>2]=0;return}c=lcb(a,b)|0;f[a+12>>2]=c;if(c|0)return;f[a>>2]=0;return}function qcb(a){a=a|0;return}function rcb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;xm(a,c,0,d);f[a>>2]=66756;d=gpd(48)|0;scb(d,b);f[a+12>>2]=d;return}function scb(a,c){a=a|0;c=c|0;var d=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;d=0;while(1){if((d|0)==3)break;f[a+(d<<2)>>2]=0;d=d+1|0}d=a+12|0;n[a+40>>2]=0.0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;f[d+12>>2]=0;f[d+16>>2]=0;f[d+20>>2]=0;b[d+24>>0]=0;n[a+44>>2]=1.0;if(!c)return;Gpd(a,c)|0;return}function tcb(a,b){a=a|0;b=+b;var c=0,d=0,e=0,g=0,h=0;h=t;t=t+16|0;c=h;n[c>>2]=b;d=f[a+12>>2]|0;e=d+28|0;g=f[e>>2]|0;if((g|0)==(f[d+32>>2]|0))Ni(d+24|0,c);else{n[g>>2]=b;f[e>>2]=g+4}g=XKa(a)|0;t=h;return g|0}function ucb(a){a=a|0;a=f[a+12>>2]|0;if(+n[a+40>>2]==0.0){a=0;return a|0}a=(b[a+36>>0]|0)==0?2:1;return a|0}function vcb(a,b,c){a=a|0;b=b|0;c=c|0;EQ(f[a+12>>2]|0,b,c);return}function wcb(a,b,c){a=a|0;b=b|0;c=c|0;EQ((f[a+12>>2]|0)+4|0,b,c);return}function xcb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;yCb(d,b);GCb((f[a+12>>2]|0)+8|0,d)|0;ECb(d);t=c;return}function ycb(a){a=a|0;return (f[a+12>>2]|0)+20|0}function zcb(a){a=a|0;return (f[a+12>>2]|0)+24|0}function Acb(a,c){a=a|0;c=c|0;b[(f[a+12>>2]|0)+16>>0]=c&1;return}function Bcb(a,b,c,d,e,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;var h=0,i=0,j=0;j=t;t=t+16|0;h=j;i=gpd(16)|0;sLa(i,e,g);vcb(i,b,0);wcb(i,c,0);xcb(i,d);c=f[a+12>>2]|0;aR(h,i);a=c+8|0;b=f[a>>2]|0;if(b>>>0<(f[c+12>>2]|0)>>>0){bR(b,h);f[a>>2]=(f[a>>2]|0)+4;GQ(h);t=j;return i|0}else{cR(c+4|0,h);GQ(h);t=j;return i|0}return 0}function Ccb(a,b){a=a|0;b=b|0;up(f[a+12>>2]|0,b)|0;return}function Dcb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0){nm(c);jpd(c)}f[a>>2]=f[b>>2];f[b>>2]=0;return a|0}function Ecb(a,b){a=a|0;b=b|0;Fcb(a,b);return}function Fcb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0;c=t;t=t+16|0;e=c+12|0;g=c+8|0;i=c+4|0;h=c;d=gpd(12)|0;b=f[b>>2]|0;f[i>>2]=f[b+24>>2];f[h>>2]=f[b+28>>2];f[g>>2]=f[i>>2];f[e>>2]=f[h>>2];Gcb(d,g,e,1);f[a>>2]=d;t=c;return}function Gcb(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;f[a>>2]=f[c>>2];f[a+4>>2]=f[d>>2];b[a+8>>0]=e&1;return}function Hcb(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=(f[a>>2]|0)+36|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function Icb(a){a=a|0;a=f[a>>2]|0;if(!a)return;jpd(a);return}function Jcb(a){a=a|0;var c=0,d=0,e=0;d=f[a>>2]|0;a=d+8|0;if(!(b[a>>0]|0)){c=f[d>>2]|0;a=f[d+4>>2]|0;if((c|0)==(a|0)){e=c;a=c}else{e=c+24|0;f[d>>2]=e}}else{b[a>>0]=0;e=f[d>>2]|0;a=f[d+4>>2]|0}return (e|0)!=(a|0)|0}function Kcb(a,c){a=a|0;c=c|0;c=f[f[c>>2]>>2]|0;if((b[c+11>>0]|0)<0)c=f[c>>2]|0;yCb(a,c);return}function Lcb(a,c){a=a|0;c=c|0;c=(f[f[c>>2]>>2]|0)+12|0;if((b[c+11>>0]|0)<0)c=f[c>>2]|0;yCb(a,c);return}function Mcb(a){a=a|0;return (X3((f[a+12>>2]|0)+28|0)|0)^1|0}function Ncb(a){a=a|0;f[a>>2]=0;return}function Ocb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=gpd(16)|0;Pcb(d,b,c);f[a>>2]=d;return}function Pcb(a,b,c){a=a|0;b=b|0;c=c|0;Cq(a,b);b=a+4|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];return}function Qcb(a){a=a|0;return (f[a>>2]|0)+4|0}function Rcb(a,b){a=a|0;b=b|0;a=(f[a>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Scb(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;Tcb(a+12|0,0);Ucb(a+16|0,0);Vcb(a+20|0,0);Vcb(a+24|0,0);return}function Tcb(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Ucb(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Vcb(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Wcb(a){a=a|0;var b=0;Bm(a);xab(a,67020);f[a>>2]=66992;b=gpd(28)|0;Scb(b);f[a+8>>2]=b;return}function Xcb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=f[a+8>>2]|0;cfa(d,0.0);Ycb(a,b,d);t=c;return}function Ycb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;i=k;j=a+4|0;e=f[j>>2]|0;d=f[a>>2]|0;while(1){if((d|0)==(e|0))break;g=f[d>>2]|0;if((cMa(g)|0)==(b|0)){h=4;break}else d=d+4|0}if((h|0)==4){Rcb(g,c);t=k;return}e=gpd(4)|0;Ocb(e,b,c);f[i>>2]=e;d=f[j>>2]|0;if(d>>>0<(f[a+8>>2]|0)>>>0){f[d>>2]=e;f[j>>2]=(f[j>>2]|0)+4}else Zcb(a,i);t=k;return}function Zcb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=_cb(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;$cb(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;adb(a,c);bdb(c);t=h;return}}function _cb(a){a=a|0;return 1073741823}function $cb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function adb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function bdb(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function cdb(a,b){a=a|0;b=b|0;var c=0;c=f[a+8>>2]|0;a=f[c>>2]|0;if((f[c+4>>2]|0)-a>>2>>>0<=b>>>0){c=153556;return c|0}c=Qcb(f[a+(b<<2)>>2]|0)|0;return c|0}function ddb(a){a=a|0;return edb((f[a+8>>2]|0)+12|0)|0}function edb(a){a=a|0;return f[a>>2]|0}function fdb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;Tcb(d,b);gdb((f[a+8>>2]|0)+12|0,d)|0;kMa(d);t=c;return}function gdb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[f[b>>2]>>2]&1023](b);return a|0}function hdb(a){a=a|0;return idb((f[a+8>>2]|0)+16|0)|0}function idb(a){a=a|0;return f[a>>2]|0}function jdb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;Ucb(d,b);kdb((f[a+8>>2]|0)+16|0,d)|0;jMa(d);t=c;return}function kdb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[f[b>>2]>>2]&1023](b);return a|0}function ldb(a){a=a|0;return mdb((f[a+8>>2]|0)+20|0)|0}function mdb(a){a=a|0;return f[a>>2]|0}function ndb(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;if(((sd[f[(f[b>>2]|0)+16>>2]&2047](b)|0)+-4|0)>>>0>=3){c=0;t=d;return c|0}Vcb(c,b);odb((f[a+8>>2]|0)+20|0,c)|0;iMa(c);c=1;t=d;return c|0}function odb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[f[b>>2]>>2]&1023](b);return a|0}function pdb(a){a=a|0;return mdb((f[a+8>>2]|0)+24|0)|0}function qdb(a,b){a=a|0;b=b|0;var c=0,d=0;d=t;t=t+16|0;c=d;switch(sd[f[(f[b>>2]|0)+16>>2]&2047](b)|0){case 0:case 3:break;default:{c=0;t=d;return c|0}}Vcb(c,b);odb((f[a+8>>2]|0)+24|0,c)|0;iMa(c);c=1;t=d;return c|0}function rdb(a,b){a=a|0;b=b|0;var c=0,d=0;d=b;c=f[d+4>>2]|0;b=(f[a+12>>2]|0)+244|0;f[b>>2]=f[d>>2];f[b+4>>2]=c;return}function sdb(a){a=a|0;return (f[a>>2]|0)+4|0}function tdb(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+4>>2]=f[b>>2];return}function udb(a){a=a|0;return (f[a>>2]|0)+8|0}function vdb(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+8>>2]=f[b>>2];return}function wdb(a){a=a|0;return f[f[a>>2]>>2]|0}function xdb(a,b){a=a|0;b=b|0;f[f[a>>2]>>2]=b;return}function ydb(a){a=a|0;return (b[(f[a>>2]|0)+60>>0]|0)!=0|0}function zdb(a,c){a=a|0;c=c|0;b[(f[a>>2]|0)+60>>0]=c&1;return}function Adb(a){a=a|0;return (b[(f[a>>2]|0)+32>>0]|0)!=0|0}function Bdb(a,c){a=a|0;c=c|0;b[(f[a>>2]|0)+32>>0]=c&1;return}function Cdb(a,b){a=a|0;b=b|0;ns(a,(f[b>>2]|0)+16|0);return}function Ddb(a,b){a=a|0;b=b|0;a=(f[a>>2]|0)+16|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Edb(a){a=a|0;return f[(f[a>>2]|0)+36>>2]|0}function Fdb(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+36>>2]=b;return}function Gdb(a){a=a|0;return f[(f[a>>2]|0)+56>>2]|0}function Hdb(a,b){a=a|0;b=b|0;f[(f[a>>2]|0)+56>>2]=b;return}function Idb(a,b){a=a|0;b=b|0;ns(a,(f[b>>2]|0)+40|0);return}function Jdb(a,b){a=a|0;b=b|0;a=(f[a>>2]|0)+40|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Kdb(a){a=a|0;return (f[a+12>>2]|0)+8|0}function Ldb(a,b){a=a|0;b=b|0;f[(f[a+12>>2]|0)+16>>2]=b;return}function Mdb(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=+d;e=+e;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;g=k;j=f[a>>2]|0;h=gpd(4)|0;_8a(h,2,(b|0)!=0&1,c,d,e,b);b=h;f[g>>2]=b;h=j+28|0;i=f[h>>2]|0;if(i>>>0<(f[j+32>>2]|0)>>>0){f[g>>2]=0;f[i>>2]=b;f[h>>2]=i+4}else Lr(j+24|0,g);b=f[g>>2]|0;f[g>>2]=0;if(!b){a=f[a>>2]|0;a=a+28|0;a=f[a>>2]|0;a=a+-4|0;a=f[a>>2]|0;t=k;return a|0}Wp(b);jpd(b);a=f[a>>2]|0;a=a+28|0;a=f[a>>2]|0;a=a+-4|0;a=f[a>>2]|0;t=k;return a|0}function Ndb(a,b){a=a|0;b=b|0;b=Uq((f[a>>2]|0)+24|0,b)|0;return f[b>>2]|0}function Odb(a){a=a|0;return (f[a+12>>2]|0)+28|0}function Pdb(a,b){a=a|0;b=b|0;return QT((f[a+16>>2]|0)+44|0,b,1,0,1.0)|0}function Qdb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;Rp(d,b);Sp((f[a+12>>2]|0)+284|0,d)|0;Tp(d);t=c;return}function Rdb(a){a=a|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;return}function Sdb(a){a=a|0;var b=0;Bm(a);xab(a,67220);f[a>>2]=67192;b=gpd(16)|0;Rdb(b);f[a+8>>2]=b;return}function Tdb(a,b){a=a|0;b=b|0;return Udb(f[a+8>>2]|0,b)|0}function Udb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;c=g;f[c>>2]=b;if(Vdb(a,b)|0){e=0;t=g;return e|0}d=a+4|0;e=f[d>>2]|0;if((e|0)==(f[a+8>>2]|0)){Wdb(a,c);e=1;t=g;return e|0}else{f[e>>2]=b;f[d>>2]=(f[d>>2]|0)+4;e=1;t=g;return e|0}return 0}function Vdb(a,b){a=a|0;b=b|0;var c=0;c=f[a+4>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(c|0)){a=c;break}if((f[a>>2]|0)==(b|0))break;a=a+4|0}return (a|0)!=(c|0)|0}function Wdb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=wL(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;xL(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;yL(a,c);zL(c);t=h;return}}function Xdb(a){a=a|0;a=f[a+8>>2]|0;return (f[a+4>>2]|0)-(f[a>>2]|0)>>2|0}function Ydb(a,b){a=a|0;b=b|0;var c=0;c=f[a+8>>2]|0;a=f[c>>2]|0;if((f[c+4>>2]|0)-a>>2>>>0<=b>>>0){c=0;return c|0}c=f[a+(b<<2)>>2]|0;return c|0}function Zdb(a){a=a|0;return f[(f[a+8>>2]|0)+12>>2]|0}function _db(a,b){a=a|0;b=b|0;var c=0;a=a+8|0;c=f[(f[a>>2]|0)+12>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);if(!b){c=f[a>>2]|0;c=c+12|0;f[c>>2]=b;return}Hd[f[f[b>>2]>>2]&1023](b);c=f[a>>2]|0;c=c+12|0;f[c>>2]=b;return}function $db(a,c){a=a|0;c=c|0;b[f[a+16>>2]>>0]=c&1;return}function aeb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function beb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+16|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function ceb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;c=g;if(!b){e=0;t=g;return e|0}e=f[a+16>>2]|0;f[c>>2]=b;a=e+32|0;d=f[a>>2]|0;if(d>>>0<(f[e+36>>2]|0)>>>0){f[c>>2]=0;f[d>>2]=b;f[a>>2]=d+4}else KOa(e+28|0,c);a=f[c>>2]|0;f[c>>2]=0;if(a|0)Hd[f[(f[a>>2]|0)+4>>2]&1023](a);e=1;t=g;return e|0}function deb(a,b){a=a|0;b=b|0;a=f[a+16>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function eeb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function feb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+24|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function geb(a,b){a=a|0;b=b|0;var c=0;if(!b){b=0;return b|0}a=(f[a+16>>2]|0)+36|0;c=f[a>>2]|0;if((c|0)==(b|0)){b=0;return b|0}f[a>>2]=b;if(!c){b=1;return b|0}Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=1;return b|0}function heb(a,c){a=a|0;c=c|0;b[f[a+4>>2]>>0]=c&1;return}function ieb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+1>>0]=c&1;return}function jeb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+2>>0]=c&1;return}function keb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+3>>0]=c&1;return}function leb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+4>>0]=c&1;return}function meb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+5>>0]=c&1;return}function neb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+6>>0]=c&1;return}function oeb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+312>>2]=b;return}function peb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+36>>2]=b;return}function qeb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+8>>3]=b;return}function reb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+16>>3]=b;return}function seb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+24>>3]=b;return}function teb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+32>>2]=b;return}function ueb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+40>>2]=b;return}function veb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+44>>2]=b;return}function web(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+48>>2]=b;return}function xeb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+52>>2]=b;return}function yeb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+56|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function zeb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+72|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Aeb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+88|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Beb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+104|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Ceb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+120|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Deb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+136|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Eeb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+152|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+156>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Feb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+176>>0]=c&1;return}function Geb(a,b){a=a|0;b=+b;n[(f[a+4>>2]|0)+180>>2]=b;return}function Heb(a,b){a=a|0;b=+b;n[(f[a+4>>2]|0)+184>>2]=b;return}function Ieb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+200|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+204>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Jeb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+212>>0]=c&1;return}function Keb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+216|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+220>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Leb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+228|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+232>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Meb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+240>>0]=c&1;return}function Neb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+188>>2]=b;return}function Oeb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+192>>0]=c&1;return}function Peb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+196>>2]=b;return}function Qeb(a,c){a=a|0;c=c|0;b[(f[a+4>>2]|0)+193>>0]=c&1;return}function Reb(a,b){a=a|0;b=b|0;var c=0;c=(f[a+4>>2]|0)+248|0;a=c+48|0;do{f[c>>2]=f[b>>2];c=c+4|0;b=b+4|0}while((c|0)<(a|0));return}function Seb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+296|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+300>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Teb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+308>>2]=b;return}function Ueb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;g=h;d=f[a+4>>2]|0;e=d+164|0;if(c|0){Gpd(e,c)|0;t=h;return}a=e+11|0;if((b[a>>0]|0)<0){e=f[e>>2]|0;b[g>>0]=0;Uh(e,g);f[d+168>>2]=0;t=h;return}else{b[g>>0]=0;Uh(e,g);b[a>>0]=0;t=h;return}}function Veb(a,b){a=a|0;b=+b;p[(f[a+12>>2]|0)+8>>3]=b;return}function Web(a){a=a|0;return f[a+12>>2]|0}function Xeb(a,b){a=a|0;b=b|0;a=f[a+16>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Yeb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Zeb(a,b){a=a|0;b=b|0;f[(f[a+16>>2]|0)+24>>2]=b;return}function _eb(a,b){a=a|0;b=+b;p[(f[a+16>>2]|0)+32>>3]=b;return}function $eb(a,b){a=a|0;b=b|0;var c=0;if(!b){b=0;return b|0}a=(f[a+16>>2]|0)+40|0;c=f[a>>2]|0;if((c|0)==(b|0)){b=0;return b|0}f[a>>2]=b;if(!c){b=1;return b|0}Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=1;return b|0}function afb(a,b){a=a|0;b=b|0;var c=0;a=(f[a+16>>2]|0)+44|0;c=f[a>>2]|0;if((c|0)==(b|0)){b=0;return b|0}f[a>>2]=b;if(!c){b=1;return b|0}Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=1;return b|0}function bfb(a,b){a=a|0;b=b|0;cfb(a,b?4:14);f[a>>2]=67624;b=gpd(48)|0;dfb(b);f[a+8>>2]=b;return}function cfb(a,b){a=a|0;b=b|0;var c=0;f[a>>2]=67652;c=gpd(20)|0;efb(c);f[a+4>>2]=c;f[c>>2]=b;return}function dfb(a){a=a|0;bfa(a);a=a+16|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;return}function efb(a){a=a|0;f[a>>2]=0;bfa(a+4|0);Cq(a+16|0,0);return}function ffb(a,b){a=a|0;b=b|0;a=f[a+8>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function gfb(a,b){a=a|0;b=+b;p[(f[a+8>>2]|0)+16>>3]=b;return}function hfb(a,b){a=a|0;b=+b;p[(f[a+8>>2]|0)+24>>3]=b;return}function ifb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a+8>>2]|0)+32|0;bfa(d);M4a(a,b,d);t=c;return}function jfb(a,b,c){a=a|0;b=b|0;c=c|0;b=(f[(f[a+8>>2]|0)+32>>2]|0)+(b*12|0)|0;f[b>>2]=f[c>>2];f[b+4>>2]=f[c+4>>2];f[b+8>>2]=f[c+8>>2];return}function kfb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=(((f[d>>2]|0)-(f[a>>2]|0)|0)/12|0)+1|0;g=GPa(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=((f[a+8>>2]|0)-i|0)/12|0;j=k<<1;O4a(c,k>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,((f[d>>2]|0)-i|0)/12|0,a+8|0);g=c+8|0;e=f[g>>2]|0;f[e>>2]=f[b>>2];f[e+4>>2]=f[b+4>>2];f[e+8>>2]=f[b+8>>2];f[g>>2]=(f[g>>2]|0)+12;Q4a(a,c);R4a(c);t=h;return}}function lfb(a){a=a|0;var b=0;f[a>>2]=67652;b=gpd(20)|0;efb(b);f[a+4>>2]=b;return}function mfb(a,b){a=a|0;b=b|0;f[f[a+4>>2]>>2]=b;return}function nfb(a,b){a=a|0;b=b|0;a=(f[a+4>>2]|0)+4|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function ofb(a,b){a=a|0;b=b|0;cfb(a,b?2:12);f[a>>2]=67680;b=gpd(36)|0;pfb(b);f[a+8>>2]=b;return}function pfb(a){a=a|0;cfa(a,0.0);cfa(a+12|0,0.0);cfa(a+24|0,0.0);return}function qfb(a,b){a=a|0;b=b|0;a=f[a+8>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function rfb(a,b){a=a|0;b=b|0;a=(f[a+8>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function sfb(a,b){a=a|0;b=b|0;a=(f[a+8>>2]|0)+24|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function tfb(a,b){a=a|0;b=b|0;cfb(a,b?3:13);f[a>>2]=67708;b=gpd(56)|0;ufb(b);f[a+8>>2]=b;return}function ufb(a){a=a|0;bfa(a);bfa(a+12|0);a=a+24|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;f[a+12>>2]=0;f[a+16>>2]=0;f[a+20>>2]=0;f[a+24>>2]=0;f[a+28>>2]=0;return}function vfb(a,b){a=a|0;b=b|0;a=f[a+8>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function wfb(a,b){a=a|0;b=b|0;a=(f[a+8>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function xfb(a,b){a=a|0;b=+b;p[(f[a+8>>2]|0)+24>>3]=b;return}function yfb(a,b){a=a|0;b=b|0;zfb((f[a+8>>2]|0)+44|0,b);return}function zfb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=a+4|0;c=f[g>>2]|0;d=f[a>>2]|0;e=(c-d|0)/12|0;if(e>>>0<b>>>0){Afb(a,b-e|0);return}if(e>>>0<=b>>>0)return;a=d+(b*12|0)|0;while(1){if((c|0)==(a|0))break;e=c+-12|0;FPa(e);c=e}f[g>>2]=a;return}function Afb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if((((f[g>>2]|0)-c|0)/12|0)>>>0>=b>>>0){Bfb(a,b);t=i;return}c=((c-(f[a>>2]|0)|0)/12|0)+b|0;d=gQa(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=((f[g>>2]|0)-j|0)/12|0;g=k<<1;Cfb(e,k>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,((f[h>>2]|0)-j|0)/12|0,a+8|0);Dfb(e,b);Efb(a,e);Ffb(e);t=i;return}function Bfb(a,b){a=a|0;b=b|0;var c=0;a=a+4|0;c=f[a>>2]|0;Mrd(c|0,0,b*12|0)|0;f[a>>2]=c+(b*12|0);return}function Cfb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>357913941){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b*12|0)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c*12|0)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b*12|0);return}function Dfb(a,b){a=a|0;b=b|0;var c=0;a=a+8|0;c=f[a>>2]|0;Mrd(c|0,0,b*12|0)|0;f[a>>2]=c+(b*12|0);return}function Efb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;d=f[a>>2]|0;e=a+4|0;g=b+4|0;c=f[e>>2]|0;while(1){if((c|0)==(d|0))break;k=f[g>>2]|0;i=k+-12|0;h=c+-12|0;f[i>>2]=0;j=k+-8|0;f[j>>2]=0;k=k+-4|0;f[k>>2]=0;f[i>>2]=f[h>>2];i=c+-8|0;f[j>>2]=f[i>>2];j=c+-4|0;f[k>>2]=f[j>>2];f[j>>2]=0;f[i>>2]=0;f[h>>2]=0;f[g>>2]=(f[g>>2]|0)+-12;c=h}i=f[a>>2]|0;f[a>>2]=f[g>>2];f[g>>2]=i;i=b+8|0;k=f[e>>2]|0;f[e>>2]=f[i>>2];f[i>>2]=k;i=a+8|0;k=b+12|0;j=f[i>>2]|0;f[i>>2]=f[k>>2];f[k>>2]=j;f[b>>2]=f[g>>2];return}function Ffb(a){a=a|0;var b=0,c=0,d=0;b=f[a+4>>2]|0;c=a+8|0;while(1){d=f[c>>2]|0;if((d|0)==(b|0))break;d=d+-12|0;f[c>>2]=d;FPa(d)}a=f[a>>2]|0;if(!a)return;jpd(a);return}function Gfb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a+8>>2]|0;a=f[d+44>>2]|0;if((((f[d+48>>2]|0)-a|0)/12|0)>>>0<=b>>>0)return;Hfb(a+(b*12|0)|0,c);return}function Hfb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[a>>2]|0;e=((f[c>>2]|0)-d|0)/12|0;if(e>>>0<b>>>0){Ifb(a,b-e|0);return}if(e>>>0<=b>>>0)return;f[c>>2]=d+(b*12|0);return}
function Ifb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if((((f[g>>2]|0)-c|0)/12|0)>>>0>=b>>>0){Jfb(a,b);t=i;return}c=((c-(f[a>>2]|0)|0)/12|0)+b|0;d=GPa(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=((f[g>>2]|0)-j|0)/12|0;g=k<<1;O4a(e,k>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,((f[h>>2]|0)-j|0)/12|0,a+8|0);Kfb(e,b);Q4a(a,e);R4a(e);t=i;return}function Jfb(a,b){a=a|0;b=b|0;var c=0;c=a+4|0;a=b;b=f[c>>2]|0;do{bfa(b);b=(f[c>>2]|0)+12|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Kfb(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=b;b=f[c>>2]|0;do{bfa(b);b=(f[c>>2]|0)+12|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function Lfb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=f[a+8>>2]|0;e=f[g+44>>2]|0;a=e;if((((f[g+48>>2]|0)-e|0)/12|0)>>>0<=b>>>0)return;e=f[a+(b*12|0)>>2]|0;if((((f[a+(b*12|0)+4>>2]|0)-e|0)/12|0)>>>0<=c>>>0)return;g=e+(c*12|0)|0;f[g>>2]=f[d>>2];f[g+4>>2]=f[d+4>>2];f[g+8>>2]=f[d+8>>2];return}function Mfb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=(((f[d>>2]|0)-(f[a>>2]|0)|0)/12|0)+1|0;g=gQa(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=((f[a+8>>2]|0)-i|0)/12|0;j=k<<1;Cfb(c,k>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,((f[d>>2]|0)-i|0)/12|0,a+8|0);g=c+8|0;e=f[g>>2]|0;f[e>>2]=0;d=e+4|0;f[d>>2]=0;i=e+8|0;f[i>>2]=0;f[e>>2]=f[b>>2];e=b+4|0;f[d>>2]=f[e>>2];d=b+8|0;f[i>>2]=f[d>>2];f[d>>2]=0;f[e>>2]=0;f[b>>2]=0;f[g>>2]=(f[g>>2]|0)+12;Efb(a,c);Ffb(c);t=h;return}}function Nfb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=f[a+8>>2]|0;a=f[d+32>>2]|0;if((((f[d+36>>2]|0)-a|0)/12|0)>>>0<=b>>>0)return;Hfb(a+(b*12|0)|0,c);return}function Ofb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0;g=f[a+8>>2]|0;e=f[g+32>>2]|0;a=e;if((((f[g+36>>2]|0)-e|0)/12|0)>>>0<=b>>>0)return;e=f[a+(b*12|0)>>2]|0;if((((f[a+(b*12|0)+4>>2]|0)-e|0)/12|0)>>>0<=c>>>0)return;g=e+(c*12|0)|0;f[g>>2]=f[d>>2];f[g+4>>2]=f[d+4>>2];f[g+8>>2]=f[d+8>>2];return}function Pfb(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0,i=0,j=0;i=t;t=t+16|0;h=i;a=a+8|0;b=f[a>>2]|0;f[h>>2]=0;c=h+4|0;f[c>>2]=0;d=h+8|0;f[d>>2]=0;e=b+36|0;g=f[e>>2]|0;if(g>>>0<(f[b+40>>2]|0)>>>0){f[g>>2]=0;j=g+4|0;f[j>>2]=0;b=g+8|0;f[b>>2]=0;f[g>>2]=f[h>>2];f[j>>2]=f[c>>2];f[b>>2]=f[d>>2];f[d>>2]=0;f[c>>2]=0;f[h>>2]=0;f[e>>2]=(f[e>>2]|0)+12}else Mfb(b+32|0,h);FPa(h);j=f[a>>2]|0;t=i;return (((f[j+36>>2]|0)-(f[j+32>>2]|0)|0)/12|0)+-1|0}function Qfb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;lfb(a);f[a>>2]=67736;d=gpd(12)|0;f[d>>2]=0;f[d+4>>2]=0;f[d+8>>2]=0;Rfb(d);f[a+8>>2]=d;if(b){mfb(a,c?5:1);return}else{mfb(a,c?15:11);return}}function Rfb(a){a=a|0;bfa(a);return}function Sfb(a,b){a=a|0;b=b|0;a=f[a+8>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Tfb(a,b){a=a|0;b=b|0;a=f[a+16>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Ufb(a,b){a=a|0;b=b|0;a=(f[a+16>>2]|0)+12|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];return}function Vfb(a,b){a=a|0;b=b|0;var c=0;if(!b){b=0;return b|0}a=a+16|0;if((f[(f[a>>2]|0)+24>>2]|0)==(b|0)){b=0;return b|0}if((IPa(b)|0|2|0)!=3){b=0;return b|0}c=(f[a>>2]|0)+24|0;a=f[c>>2]|0;f[c>>2]=b;if(!a){c=1;return c|0}Hd[f[(f[a>>2]|0)+4>>2]&1023](a);c=1;return c|0}function Wfb(a,b){a=a|0;b=b|0;var c=0;c=gpd(40)|0;Xfb(c,b);f[a>>2]=c;return}function Xfb(a,c){a=a|0;c=c|0;var d=0,e=0;d=c&1;e=a+36|0;c=a+36|0;do{f[a>>2]=0;a=a+4|0}while((a|0)<(c|0));b[e>>0]=d;return}function Yfb(a){a=a|0;a=f[a>>2]|0;if(!a)return;Zfb(a);jpd(a);return}function Zfb(a){a=a|0;_fb(a);Ye(a+24|0);$fb(a+12|0);hka(a);return}function _fb(a){a=a|0;var b=0,c=0,d=0,e=0;c=a+4|0;d=f[c>>2]|0;b=f[a>>2]|0;while(1){if((b|0)==(d|0))break;e=f[b>>2]|0;if(e|0){nea(e);jpd(e)}b=b+4|0}f[c>>2]=f[a>>2];return}function $fb(a){a=a|0;var b=0;b=f[a>>2]|0;if(!b)return;f[a+4>>2]=b;jpd(b);return}function agb(a){a=a|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=t;t=t+48|0;d=h+24|0;e=h+12|0;g=h;a=f[a>>2]|0;if(!(b[a+36>>0]|0)){t=h;return}i=(f[(f[a+4>>2]|0)+-4>>2]|0)+12|0;c=f[i>>2]|0;f[i>>2]=c|2;if(c&1|0){t=h;return}c=f[a+12>>2]|0;a=(f[a+16>>2]|0)-c>>5;if((a>>>0)%3|0|0){t=h;return}k=a+-3|0;j=a+-2|0;i=a+-1|0;m=c+(j<<5)|0;l=c+(j<<5)+4|0;a=c+(j<<5)+8|0;me(d,+n[m>>2]-+n[c+(k<<5)>>2],+n[l>>2]-+n[c+(k<<5)+4>>2],+n[a>>2]-+n[c+(k<<5)+8>>2]);me(e,+n[c+(i<<5)>>2]-+n[m>>2],+n[c+(i<<5)+4>>2]-+n[l>>2],+n[c+(i<<5)+8>>2]-+n[a>>2]);bgb(g,d,e);d=f[g>>2]|0;f[c+(k<<5)+12>>2]=d;e=f[g+4>>2]|0;f[c+(k<<5)+16>>2]=e;g=f[g+8>>2]|0;f[c+(k<<5)+20>>2]=g;f[c+(j<<5)+12>>2]=d;f[c+(j<<5)+16>>2]=e;f[c+(j<<5)+20>>2]=g;f[c+(i<<5)+12>>2]=d;f[c+(i<<5)+16>>2]=e;f[c+(i<<5)+20>>2]=g;t=h;return}function bgb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0;e=+n[b+4>>2];h=+n[c+8>>2];i=+n[b+8>>2];g=+n[c+4>>2];d=+n[c>>2];f=+n[b>>2];me(a,e*h-i*g,i*d-h*f,g*f-e*d);return}function cgb(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;dgb(f[a>>2]|0,b,c,d,0.0,0.0,1.0,0.0,0.0);agb(a);return}function dgb(a,b,c,d,e,g,h,i,j){a=a|0;b=+b;c=+c;d=+d;e=+e;g=+g;h=+h;i=+i;j=+j;var k=0;k=a+12|0;a=a+16|0;egb(k,((f[a>>2]|0)-(f[k>>2]|0)>>5)+1|0);a=f[a>>2]|0;n[a+-32>>2]=b;n[a+-28>>2]=c;n[a+-24>>2]=d;n[a+-20>>2]=e;n[a+-16>>2]=g;n[a+-12>>2]=h;n[a+-8>>2]=i;n[a+-4>>2]=j;return}function egb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=a+4|0;d=f[a>>2]|0;e=(f[c>>2]|0)-d>>5;if(e>>>0<b>>>0){fgb(a,b-e|0);return}if(e>>>0<=b>>>0)return;f[c>>2]=d+(b<<5);return}function fgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;i=t;t=t+32|0;e=i;g=a+8|0;h=a+4|0;c=f[h>>2]|0;if((f[g>>2]|0)-c>>5>>>0>=b>>>0){ggb(a,b);t=i;return}c=(c-(f[a>>2]|0)>>5)+b|0;d=hgb(a)|0;if(d>>>0<c>>>0)kqd(a);j=f[a>>2]|0;k=(f[g>>2]|0)-j|0;g=k>>4;igb(e,k>>5>>>0<d>>>1>>>0?(g>>>0<c>>>0?c:g):d,(f[h>>2]|0)-j>>5,a+8|0);jgb(e,b);kgb(a,e);lgb(e);t=i;return}function ggb(a,b){a=a|0;b=b|0;var c=0;c=a+4|0;a=b;b=f[c>>2]|0;do{K6a(b);b=(f[c>>2]|0)+32|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function hgb(a){a=a|0;return 134217727}function igb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>134217727){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<5)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<5)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<5);return}function jgb(a,b){a=a|0;b=b|0;var c=0;c=a+8|0;a=b;b=f[c>>2]|0;do{K6a(b);b=(f[c>>2]|0)+32|0;f[c>>2]=b;a=a+-1|0}while((a|0)!=0);return}function kgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>5)<<5)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function lgb(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-32|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function mgb(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;i=k;ngb(f[a>>2]|0);j=gpd(20)|0;Jab(j);f[i>>2]=j;g=f[a>>2]|0;h=g+4|0;a=f[h>>2]|0;if((a|0)==(f[g+8>>2]|0))ogb(g,i);else{f[a>>2]=j;f[h>>2]=(f[h>>2]|0)+4}j=f[i>>2]|0;f[j+16>>2]=e;i=c?2:0;e=i|4;f[j+12>>2]=b<<24>>24==2?(d?e:i)|1:d?e:i;t=k;return}function ngb(a){a=a|0;var b=0,c=0,d=0,e=0,g=0,h=0;b=f[a+4>>2]|0;if((b|0)==(f[a>>2]|0))return;g=f[b+-4>>2]|0;h=g+8|0;f[h>>2]=0;e=a+12|0;b=f[e>>2]|0;c=a+16|0;d=f[c>>2]|0;if((b|0)!=(d|0)){d=d-b>>5;f[h>>2]=(d|0)/(f[g+12>>2]&1^3|0)|0;tgb(g,d)|0;d=f[e>>2]|0;Krd(f[g>>2]|0,d|0,(f[c>>2]|0)-d|0)|0;f[c>>2]=f[e>>2]}d=a+24|0;b=a+28|0;if((f[d>>2]|0)==(f[b>>2]|0))return;c=f[h>>2]|0;if(!c)return;ugb(g,c)|0;c=g+4|0;Mrd(f[c>>2]|0,0,f[h>>2]<<2|0)|0;e=f[d>>2]|0;a=(f[b>>2]|0)-e>>2;h=f[h>>2]|0;Krd(f[c>>2]|0,e|0,(a>>>0>h>>>0?h:a)<<2|0)|0;h=g+12|0;f[h>>2]=f[h>>2]|16;f[b>>2]=f[d>>2];return}function ogb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;h=t;t=t+32|0;c=h;d=a+4|0;e=((f[d>>2]|0)-(f[a>>2]|0)>>2)+1|0;g=pgb(a)|0;if(g>>>0<e>>>0)kqd(a);else{i=f[a>>2]|0;k=(f[a+8>>2]|0)-i|0;j=k>>1;qgb(c,k>>2>>>0<g>>>1>>>0?(j>>>0<e>>>0?e:j):g,(f[d>>2]|0)-i>>2,a+8|0);g=c+8|0;f[f[g>>2]>>2]=f[b>>2];f[g>>2]=(f[g>>2]|0)+4;rgb(a,c);sgb(c);t=h;return}}function pgb(a){a=a|0;return 1073741823}function qgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=a+12|0;f[e>>2]=0;f[a+16>>2]=d;do if(b)if(b>>>0>1073741823){e=yb(8)|0;qpd(e,113720);f[e>>2]=81900;Fb(e|0,42448,796)}else{d=gpd(b<<2)|0;break}else d=0;while(0);f[a>>2]=d;c=d+(c<<2)|0;f[a+8>>2]=c;f[a+4>>2]=c;f[e>>2]=d+(b<<2);return}function rgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0;d=f[a>>2]|0;h=a+4|0;g=b+4|0;e=(f[h>>2]|0)-d|0;c=(f[g>>2]|0)+(0-(e>>2)<<2)|0;f[g>>2]=c;if((e|0)>0){Krd(c|0,d|0,e|0)|0;d=g;c=f[g>>2]|0}else d=g;g=f[a>>2]|0;f[a>>2]=c;f[d>>2]=g;g=b+8|0;e=f[h>>2]|0;f[h>>2]=f[g>>2];f[g>>2]=e;g=a+8|0;h=b+12|0;a=f[g>>2]|0;f[g>>2]=f[h>>2];f[h>>2]=a;f[b>>2]=f[d>>2];return}function sgb(a){a=a|0;var b=0,c=0,d=0,e=0;b=f[a+4>>2]|0;c=a+8|0;d=f[c>>2]|0;while(1){if((d|0)==(b|0))break;e=d+-4|0;f[c>>2]=e;d=e}a=f[a>>2]|0;if(!a)return;jpd(a);return}function tgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=f[a>>2]|0;if(c|0)kpd(c);c=hpd(b>>>0>134217727?-1:b<<5)|0;if(b|0){d=c+(b<<5)|0;e=c;do{K6a(e);e=e+32|0}while((e|0)!=(d|0))}f[a>>2]=c;Mrd(c|0,0,b<<5|0)|0;return c|0}function ugb(a,b){a=a|0;b=b|0;var c=0;a=a+4|0;c=f[a>>2]|0;if(c|0)kpd(c);c=hpd(b>>>0>1073741823?-1:b<<2)|0;f[a>>2]=c;Mrd(c|0,0,b<<2|0)|0;return c|0}function vgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0;ngb(f[a>>2]|0);e=f[a>>2]|0;c=e+4|0;h=(f[c>>2]|0)-(f[e>>2]|0)|0;d=h>>2;i=d*20|0;i=hpd(d>>>0>214748364|i>>>0>4294967291?-1:i+4|0)|0;f[i>>2]=d;j=i+4|0;if(!h){h=c;c=e;g=e}else{c=j+(d*20|0)|0;d=j;do{Jab(d);d=d+20|0}while((d|0)!=(c|0));g=f[a>>2]|0;h=g+4|0;c=g}e=f[c>>2]|0;d=(f[h>>2]|0)-e>>2;c=0;a=e;while(1){if((c|0)==(d|0))break;a=f[e+(c<<2)>>2]|0;k=j+(c*20|0)|0;f[k>>2]=f[a>>2];f[k+4>>2]=f[a+4>>2];f[k+8>>2]=f[a+8>>2];f[k+12>>2]=f[a+12>>2];f[k+16>>2]=f[a+16>>2];k=f[g>>2]|0;a=k+(c<<2)|0;f[f[a>>2]>>2]=0;f[(f[a>>2]|0)+4>>2]=0;c=c+1|0;a=k;e=k}d=(vd[f[(f[b>>2]|0)+92>>2]&255](b,j,(f[h>>2]|0)-a>>2)|0)==0;c=f[i>>2]|0;if(!c){kpd(i);return d|0}c=j+(c*20|0)|0;do{c=c+-20|0;nea(c)}while((c|0)!=(j|0));kpd(i);return d|0}function wgb(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0;g=gpd(28)|0;xgb(g,b,c,d,e);f[a>>2]=g;return}function xgb(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;g=0;while(1){if((g|0)==3)break;f[a+(g<<2)>>2]=0;g=g+1|0}h=a+12|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;g=0;while(1){if((g|0)==3)break;f[h+(g<<2)>>2]=0;g=g+1|0}f[a+24>>2]=e;if(b|0)Gpd(a,b)|0;if(!c)return;Cpd(h,c,d)|0;return}function ygb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+16|0;e=h;g=gpd(4)|0;wgb(g,b,c,d,4);f[e>>2]=g;a=f[a>>2]|0;b=a+20|0;c=f[b>>2]|0;if((c|0)==(f[a+24>>2]|0)){B9a(a+16|0,e);t=h;return}else{f[c>>2]=g;f[b>>2]=(f[b>>2]|0)+4;t=h;return}}function zgb(a){a=a|0;a=f[a>>2]|0;return (f[a+20>>2]|0)-(f[a+16>>2]|0)>>2|0}function Agb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;a=f[c+16>>2]|0;if((f[c+20>>2]|0)-a>>2>>>0>b>>>0)return f[a+(b<<2)>>2]|0;else{c=yb(8)|0;oCb(c,97866);Fb(c|0,40152,607)}return 0}function Bgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;f[a>>2]=67856;e=gpd(232)|0;Cgb(e,a,b,c,d);f[a+4>>2]=e;return}function Cgb(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var g=0,h=0,i=0,j=0,k=0;k=t;t=t+16|0;j=k;Ncb(a);h=a+4|0;f[h>>2]=0;f[h+4>>2]=0;f[h+8>>2]=0;g=0;while(1){if((g|0)==3)break;f[h+(g<<2)>>2]=0;g=g+1|0}pv(a+16|0,0,0,0,0);i=a+20|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[a+36>>2]=1065353216;i=a+40|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;f[i+12>>2]=0;f[a+56>>2]=1065353216;i=a+152|0;f[i>>2]=0;f[i+4>>2]=0;f[i+8>>2]=0;g=a+60|0;h=g+48|0;do{f[g>>2]=0;g=g+4|0}while((g|0)<(h|0));g=0;while(1){if((g|0)==3)break;f[i+(g<<2)>>2]=0;g=g+1|0}g=a+164|0;h=a+168|0;f[g>>2]=0;f[g+4>>2]=0;f[g+8>>2]=0;f[g+12>>2]=0;g=0;while(1){if((g|0)==3)break;f[h+(g<<2)>>2]=0;g=g+1|0}f[a+180>>2]=0;f[a+188>>2]=0;I_(a+192|0);K_(a+200|0);rW(a+208|0);BY(a+216|0);zab(a+224|0);zab(a+228|0);p[a+112>>3]=1.0;p[a+120>>3]=0.0;f[a+128>>2]=4;f[a+132>>2]=0;f[a+136>>2]=0;p[a+144>>3]=0.0;LCb(j);Lpd(Gpd(i,ICb(j)|0)|0,97900)|0;ECb(j);LCb(j);Lpd(Gpd(h,ICb(j)|0)|0,97900)|0;ECb(j);Dgb(a,c,d,e);j=gpd(8)|0;Egb(j,b);f[a+184>>2]=j;t=k;return}function Dgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+32|0;e=h;g=h+16|0;f[e>>2]=97902;f[e+4>>2]=c;f[e+8>>2]=112234;f[e+12>>2]=d;if((b|0)!=0&(c|0)!=0){pv(g,97902,b,e,(d|0)==0?1:2);Dcb(a+16|0,g)|0;mm(g);t=h;return}else{pv(g,0,0,0,0);Dcb(a+16|0,g)|0;mm(g);t=h;return}}function Egb(a,b){a=a|0;b=b|0;f[a>>2]=70104;f[a+4>>2]=b;return}function Fgb(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0;g=gpd(24)|0;f[a>>2]=g;f[a+4>>2]=c+8;c=a+8|0;b[c>>0]=0;f[g+8>>2]=f[e>>2];a=g+12|0;e=f[e+4>>2]|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;wpd(a,e,Th(e)|0);b[c>>0]=1;f[g+4>>2]=d;f[g>>2]=0;return}function Ggb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)!=1){if(b+-1&b)b=ofd(b)|0}else b=2;d=f[a+4>>2]|0;if(b>>>0>d>>>0){Mgb(a,b);return}if(b>>>0>=d>>>0)return;c=~~+U(+(+((f[a+12>>2]|0)>>>0)/+n[a+16>>2]))>>>0;if(d>>>0>2&(d+-1&d|0)==0){e=1<<32-(Y(c+-1|0)|0);c=c>>>0<2?c:e}else c=ofd(c)|0;b=b>>>0<c>>>0?c:b;if(b>>>0>=d>>>0)return;Mgb(a,b);return}function Hgb(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=gpd(24)|0;f[a>>2]=e;f[a+4>>2]=c+8;g=a+8|0;b[g>>0]=0;a=e+8|0;h=f[d>>2]|0;f[a>>2]=0;f[a+4>>2]=0;f[a+8>>2]=0;wpd(a,h,Th(h)|0);f[e+20>>2]=f[d+4>>2];b[g>>0]=1;d=Jgb(c+12|0,a)|0;f[e+4>>2]=d;f[e>>2]=0;return}function Igb(a,c,d){a=a|0;c=c|0;d=d|0;var e=0,g=0,h=0,i=0.0,j=0.0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;u=d+8|0;e=Jgb(c+12|0,u)|0;x=d+4|0;f[x>>2]=e;v=c+4|0;k=f[v>>2]|0;w=(k|0)==0;a:do if(!w){s=k+-1|0;t=(s&k|0)==0;if(!t){if(e>>>0>=k>>>0)e=(e>>>0)%(k>>>0)|0}else e=s&e;g=f[(f[c>>2]|0)+(e<<2)>>2]|0;if(g){q=u+11|0;r=d+12|0;b:while(1){g=f[g>>2]|0;if(!g)break a;h=f[g+4>>2]|0;if(!t){if(h>>>0>=k>>>0)h=(h>>>0)%(k>>>0)|0}else h=h&s;if((h|0)!=(e|0))break a;l=g+8|0;h=b[l+11>>0]|0;o=h<<24>>24<0;h=h&255;p=o?f[g+12>>2]|0:h;y=b[q>>0]|0;m=y<<24>>24<0;c:do if((p|0)==((m?f[r>>2]|0:y&255)|0)){m=m?f[u>>2]|0:u;if(o)if(!(No(f[l>>2]|0,m,p)|0)){e=0;d=g;g=36;break b}else break;while(1){if(!h){e=0;d=g;g=36;break b}if((b[l>>0]|0)!=(b[m>>0]|0))break c;m=m+1|0;l=l+1|0;h=h+-1|0}}while(0)}if((g|0)==36){y=d;f[a>>2]=y;y=a+4|0;b[y>>0]=e;return}}}else e=0;while(0);l=c+12|0;i=+(((f[l>>2]|0)+1|0)>>>0);j=+n[c+16>>2];do if(w|j*+(k>>>0)<i){h=k<<1|(k>>>0<3|(k+-1&k|0)!=0)&1;e=~~+U(+(i/j))>>>0;Kgb(c,h>>>0<e>>>0?e:h);h=f[v>>2]|0;e=f[x>>2]|0;g=h+-1|0;if(!(g&h)){k=h;e=g&e;break}if(e>>>0<h>>>0)k=h;else{k=h;e=(e>>>0)%(h>>>0)|0}}while(0);g=f[(f[c>>2]|0)+(e<<2)>>2]|0;if(!g){y=c+8|0;f[d>>2]=f[y>>2];f[y>>2]=d;f[(f[c>>2]|0)+(e<<2)>>2]=y;e=f[d>>2]|0;if(e){e=f[e+4>>2]|0;g=k+-1|0;if(g&k){if(e>>>0>=k>>>0)e=(e>>>0)%(k>>>0)|0}else e=e&g;f[(f[c>>2]|0)+(e<<2)>>2]=d}}else{f[d>>2]=f[g>>2];f[g>>2]=d}f[l>>2]=(f[l>>2]|0)+1;c=1;y=d;f[a>>2]=y;y=a+4|0;b[y>>0]=c;return}function Jgb(a,c){a=a|0;c=c|0;var d=0,e=0;a=t;t=t+16|0;d=b[c+11>>0]|0;e=d<<24>>24<0;c=Lh(a,e?f[c>>2]|0:c,e?f[c+4>>2]|0:d&255)|0;t=a;return c|0}function Kgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if((b|0)!=1){if(b+-1&b)b=ofd(b)|0}else b=2;d=f[a+4>>2]|0;if(b>>>0>d>>>0){Lgb(a,b);return}if(b>>>0>=d>>>0)return;c=~~+U(+(+((f[a+12>>2]|0)>>>0)/+n[a+16>>2]))>>>0;if(d>>>0>2&(d+-1&d|0)==0){e=1<<32-(Y(c+-1|0)|0);c=c>>>0<2?c:e}else c=ofd(c)|0;b=b>>>0<c>>>0?c:b;if(b>>>0>=d>>>0)return;Lgb(a,b);return}function Lgb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=a+4|0;if(!c){d=f[a>>2]|0;f[a>>2]=0;if(d|0)jpd(d);f[e>>2]=0;return}if(c>>>0>1073741823){a=yb(8)|0;qpd(a,113720);f[a>>2]=81900;Fb(a|0,42448,796)}t=gpd(c<<2)|0;d=f[a>>2]|0;f[a>>2]=t;if(d|0)jpd(d);f[e>>2]=c;d=0;while(1){if((d|0)==(c|0))break;f[(f[a>>2]|0)+(d<<2)>>2]=0;d=d+1|0}g=a+8|0;d=f[g>>2]|0;if(!d)return;e=f[d+4>>2]|0;s=c+-1|0;t=(s&c|0)==0;if(!t){if(e>>>0>=c>>>0)e=(e>>>0)%(c>>>0)|0}else e=e&s;f[(f[a>>2]|0)+(e<<2)>>2]=g;a:while(1){r=d;b:while(1){while(1){d=f[r>>2]|0;if(!d)break a;g=f[d+4>>2]|0;if(!t){if(g>>>0>=c>>>0)g=(g>>>0)%(c>>>0)|0}else g=g&s;if((g|0)==(e|0))break;h=(f[a>>2]|0)+(g<<2)|0;if(!(f[h>>2]|0))break b;n=d+8|0;o=n+11|0;p=d+12|0;q=d;c:while(1){h=f[q>>2]|0;if(!h){i=39;break}j=h+8|0;i=b[o>>0]|0;l=i<<24>>24<0;i=i&255;m=l?f[p>>2]|0:i;u=b[j+11>>0]|0;k=u<<24>>24<0;if((m|0)!=((k?f[h+12>>2]|0:u&255)|0)){i=39;break}j=k?f[j>>2]|0:j;d:do if(l){if(No(f[n>>2]|0,j,m)|0){i=35;break c}h=f[q>>2]|0}else{k=n;while(1){if(!i)break d;if((b[k>>0]|0)!=(b[j>>0]|0)){i=38;break c}j=j+1|0;k=k+1|0;i=i+-1|0}}while(0);q=h}if((i|0)==35)h=f[q>>2]|0;f[r>>2]=h;f[q>>2]=f[f[(f[a>>2]|0)+(g<<2)>>2]>>2];f[f[(f[a>>2]|0)+(g<<2)>>2]>>2]=d}r=d}f[h>>2]=r;e=g}return}function Mgb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0;d=a+4|0;if(!b){c=f[a>>2]|0;f[a>>2]=0;if(c|0)jpd(c);f[d>>2]=0;return}if(b>>>0>1073741823){a=yb(8)|0;qpd(a,113720);f[a>>2]=81900;Fb(a|0,42448,796)}l=gpd(b<<2)|0;c=f[a>>2]|0;f[a>>2]=l;if(c|0)jpd(c);f[d>>2]=b;c=0;while(1){if((c|0)==(b|0))break;f[(f[a>>2]|0)+(c<<2)>>2]=0;c=c+1|0}e=a+8|0;c=f[e>>2]|0;if(!c)return;d=f[c+4>>2]|0;k=b+-1|0;l=(k&b|0)==0;if(!l){if(d>>>0>=b>>>0)d=(d>>>0)%(b>>>0)|0}else d=d&k;f[(f[a>>2]|0)+(d<<2)>>2]=e;a:while(1){j=c;b:while(1){while(1){c=f[j>>2]|0;if(!c)break a;e=f[c+4>>2]|0;if(!l){if(e>>>0>=b>>>0)e=(e>>>0)%(b>>>0)|0}else e=e&k;if((e|0)==(d|0))break;g=(f[a>>2]|0)+(e<<2)|0;if(!(f[g>>2]|0))break b;h=c+8|0;g=c;while(1){i=f[g>>2]|0;if(!i)break;if((f[h>>2]|0)==(f[i+8>>2]|0))g=i;else break}f[j>>2]=i;f[g>>2]=f[f[(f[a>>2]|0)+(e<<2)>>2]>>2];f[f[(f[a>>2]|0)+(e<<2)>>2]>>2]=c}j=c}f[g>>2]=j;d=e}return}function Ngb(a,c){a=a|0;c=c|0;var d=0,e=0.0,g=0.0,h=0,i=0,j=0,k=0,l=0,m=0,o=0,p=0,q=0,r=0,s=0,u=0,v=0,w=0,x=0,y=0;y=t;t=t+32|0;x=y+16|0;s=y+8|0;u=y;v=c;w=a+4|0;a=f[w>>2]|0;f[x>>2]=0;f[x+4>>2]=0;f[x+8>>2]=0;wpd(x,c,Th(c)|0);a=Ogb(a+40|0,x)|0;Apd(x);if(a|0){x=a+20|0;x=f[x>>2]|0;t=y;return x|0}a=f[w>>2]|0;q=a+20|0;r=a+32|0;p=(f[r>>2]|0)+1|0;f[s>>2]=p;f[s+4>>2]=v;k=a+24|0;l=f[k>>2]|0;m=(l|0)==0;a:do if(!m){i=l+-1|0;j=(i&l|0)==0;if(!j)if(p>>>0<l>>>0)c=p;else c=(p>>>0)%(l>>>0)|0;else c=i&p;d=f[(f[q>>2]|0)+(c<<2)>>2]|0;if(!d)o=18;else do{d=f[d>>2]|0;if(!d){o=18;break a}h=f[d+4>>2]|0;if((h|0)!=(p|0)){if(!j){if(h>>>0>=l>>>0)h=(h>>>0)%(l>>>0)|0}else h=h&i;if((h|0)!=(c|0)){o=18;break a}}}while((f[d+8>>2]|0)!=(p|0))}else{c=0;o=18}while(0);if((o|0)==18){Fgb(x,q,p,s);e=+(((f[r>>2]|0)+1|0)>>>0);g=+n[a+36>>2];do if(m|g*+(l>>>0)<e){c=l<<1|(l>>>0<3|(l+-1&l|0)!=0)&1;d=~~+U(+(e/g))>>>0;Ggb(q,c>>>0<d>>>0?d:c);c=f[k>>2]|0;d=c+-1|0;if(!(d&c)){h=c;c=d&p;break}if(p>>>0<c>>>0){h=c;c=p}else{h=c;c=(p>>>0)%(c>>>0)|0}}else h=l;while(0);d=f[(f[q>>2]|0)+(c<<2)>>2]|0;if(!d){d=a+28|0;f[f[x>>2]>>2]=f[d>>2];f[d>>2]=f[x>>2];f[(f[q>>2]|0)+(c<<2)>>2]=d;d=f[x>>2]|0;a=f[d>>2]|0;if(!a)a=x;else{a=f[a+4>>2]|0;c=h+-1|0;if(c&h){if(a>>>0>=h>>>0)a=(a>>>0)%(h>>>0)|0}else a=a&c;f[(f[q>>2]|0)+(a<<2)>>2]=d;a=x}}else{f[f[x>>2]>>2]=f[d>>2];f[d>>2]=f[x>>2];a=x}f[r>>2]=(f[r>>2]|0)+1;f[a>>2]=0;a=f[w>>2]|0}r=(f[a+52>>2]|0)+1|0;f[u>>2]=v;f[u+4>>2]=r;v=a+40|0;Hgb(x,v,u);Igb(s,v,f[x>>2]|0);if(!(b[s+4>>0]|0)){a=f[x>>2]|0;f[x>>2]=0;if(a|0){if(b[x+8>>0]|0)XQa(a+8|0);jpd(a)}}else f[x>>2]=0;x=(f[w>>2]|0)+32|0;x=f[x>>2]|0;t=y;return x|0}function Ogb(a,c){a=a|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=Jgb(a+12|0,c)|0;n=f[a+4>>2]|0;if(!n){p=0;return p|0}o=n+-1|0;p=(o&n|0)==0;if(!p)if(m>>>0<n>>>0)l=m;else l=(m>>>0)%(n>>>0)|0;else l=o&m;a=f[(f[a>>2]|0)+(l<<2)>>2]|0;if(!a){p=0;return p|0}j=c+11|0;k=c+4|0;a:while(1){a=f[a>>2]|0;if(!a){a=0;d=23;break}d=f[a+4>>2]|0;b:do if((d|0)==(m|0)){e=a+8|0;d=b[e+11>>0]|0;h=d<<24>>24<0;d=d&255;i=h?f[a+12>>2]|0:d;q=b[j>>0]|0;g=q<<24>>24<0;if((i|0)==((g?f[k>>2]|0:q&255)|0)){g=g?f[c>>2]|0:c;if(h)if(!(No(f[e>>2]|0,g,i)|0)){d=23;break a}else break;while(1){if(!d){d=23;break a}if((b[e>>0]|0)!=(b[g>>0]|0))break b;g=g+1|0;e=e+1|0;d=d+-1|0}}}else{if(!p){if(d>>>0>=n>>>0)d=(d>>>0)%(n>>>0)|0}else d=d&o;if((d|0)!=(l|0)){a=0;d=23;break a}}while(0)}if((d|0)==23)return a|0;return 0}function Pgb(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;var g=0;f=t;t=t+16|0;g=f;a=gpd(16)|0;T1a(a,e,0);V1a(g,c,d);Qgb(a,g);if(!b){t=f;return a|0}Gy(b,a)|0;t=f;return a|0}function Qgb(a,b){a=a|0;b=b|0;a=f[a+12>>2]|0;f[a>>2]=f[b>>2];f[a+4>>2]=f[b+4>>2];f[a+8>>2]=f[b+8>>2];f[a+12>>2]=f[b+12>>2];return}function Rgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(24)|0;hs(a,c,d);if(!b)return a|0;Gy(b,a)|0;return a|0}function Sgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(28)|0;As(a,c,d);if(!b)return a|0;Gy(b,a)|0;return a|0}function Tgb(a,b,c){a=a|0;b=b|0;c=c|0;rs(a,b,c);f[a>>2]=73508;c=gpd(12)|0;Ugb(c);f[a+16>>2]=c;c9a(c)|0;return}function Ugb(a){a=a|0;Ds(a);f[a+4>>2]=0;f[a+8>>2]=4;return}function Vgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(24)|0;Ns(a,c,d);if(!b)return a|0;Gy(b,a)|0;return a|0}function Wgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;d=gpd(36)|0;Eab(d,b,a,c);return d|0}function Xgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(16)|0;z3a(a,c,d);if(!b)return a|0;Gy(b,a)|0;return a|0}function Ygb(a,b,c){a=a|0;b=b|0;c=c|0;a=gpd(16)|0;ILa(a,b,c);return a|0}function Zgb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=gpd(16)|0;am(a,c,d);if(!b)return a|0;Gy(b,a)|0;return a|0}function _gb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+112>>3]=b;return}function $gb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+120>>3]=b;return}function ahb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+128>>2]=b;return}function bhb(a){a=a|0;return f[(f[a+4>>2]|0)+128>>2]|0}function chb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+132>>2]=b;return}function dhb(a,b){a=a|0;b=+b;p[(f[a+4>>2]|0)+144>>3]=b;return}function ehb(a,b){a=a|0;b=b|0;f[(f[a+4>>2]|0)+136>>2]=b;return}function fhb(a){a=a|0;var b=0;a=a+4|0;b=f[(f[a>>2]|0)+188>>2]|0;if(b|0)return b|0;b=gpd(4)|0;uO(b);f[(f[a>>2]|0)+188>>2]=b;return b|0}function ghb(a){a=a|0;var b=0,c=0,d=0;c=t;t=t+16|0;b=c+8|0;d=c;a=(f[a+4>>2]|0)+208|0;f[d>>2]=3;hhb(b,a,23,d);t=c;return f[b>>2]|0}function hhb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;e=t;t=t+16|0;g=e;h=e+4|0;f[g>>2]=c;f[h>>2]=0;mbb(a,0,h);ihb(f[b+4>>2]|0,g,d,a)|0;t=e;return}function ihb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;f[d>>2]=0;e=d+4|0;f[e>>2]=0;b=jhb(a,b,c)|0;if((b|0)==(f[a+4>>2]|0)){e=0;return e|0}a=lbb(b)|0;f[d>>2]=a;f[e>>2]=f[b+4>>2];e=1;return e|0}function jhb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=a+4|0;e=f[g>>2]|0;a=f[a>>2]|0;while(1){if((a|0)==(e|0)){d=7;break}d=khb(a)|0;d=sd[f[(f[d>>2]|0)+12>>2]&2047](d)|0;if((d|0)==(f[b>>2]|0)){d=f[c>>2]|0;if(!d){d=8;break}if((f[a+4>>2]|0)==(d|0)){d=8;break}}a=a+8|0}if((d|0)==7){g=f[g>>2]|0;return g|0}else if((d|0)==8)return a|0;return 0}function khb(a){a=a|0;return f[a>>2]|0}function lhb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a+4>>2]|0)+208|0;f[d>>2]=3;mhb(a,23,b,d)|0;t=c;return (b|0)!=0|0}function mhb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;nhb(a,b,d)|0;if(!c){d=1;return d|0}d=Zab(a,c,d)|0;return d|0}function nhb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=t;t=t+16|0;e=d;f[e>>2]=b;c=ohb(f[a+4>>2]|0,e,c)|0;t=d;return c|0}function ohb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=t;t=t+48|0;e=d+40|0;g=d+32|0;k=d+20|0;i=d+28|0;n=d+24|0;m=d+16|0;l=d+8|0;h=d;f[n>>2]=f[a>>2];j=a+4|0;f[m>>2]=f[j>>2];f[l>>2]=f[b>>2];f[l+4>>2]=f[c>>2];f[k>>2]=f[n>>2];f[g>>2]=f[m>>2];f[e>>2]=f[l>>2];f[e+4>>2]=f[l+4>>2];c=phb(k,g,e)|0;f[i>>2]=c;f[h>>2]=f[j>>2];f[g>>2]=f[i>>2];f[e>>2]=f[h>>2];qhb(a,g,e)|0;t=d;return 0}function phb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0,i=0,j=0;j=t;t=t+16|0;d=j+8|0;i=j;h=f[b>>2]|0;e=f[a>>2]|0;while(1){if((e|0)==(h|0)){g=3;break}gbb(d,e);b=thb(c,d)|0;xW(d);if(b)break;e=e+8|0}if((g|0)==3){f[a>>2]=h;i=h;t=j;return i|0}f[a>>2]=e;if((e|0)==(h|0)){i=h;t=j;return i|0}b=e;d=e;a:while(1){do{d=d+8|0;if((d|0)==(h|0))break a;gbb(i,d);g=thb(c,i)|0;xW(i)}while(g);rhb(b,d)|0;g=b+8|0;f[a>>2]=g;b=g}t=j;return b|0}function qhb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=f[a>>2]|0;e=f[b>>2]|0;g=g+(e-g>>3<<3)|0;b=f[c>>2]|0;if((b|0)==(e|0))return g|0;d=a+4|0;c=f[d>>2]|0;a=g;b=g+(b-e>>3<<3)|0;while(1){if((b|0)==(c|0))break;rhb(a,b)|0;a=a+8|0;b=b+8|0}b=f[d>>2]|0;while(1){if((b|0)==(a|0))break;e=b+-8|0;xW(e);b=e}f[d>>2]=a;return g|0}function rhb(a,b){a=a|0;b=b|0;shb(a,b)|0;f[a+4>>2]=f[b+4>>2];return a|0}function shb(a,b){a=a|0;b=b|0;var c=0;c=f[a>>2]|0;if(c|0)Hd[f[(f[c>>2]|0)+4>>2]&1023](c);b=f[b>>2]|0;f[a>>2]=b;if(!b)return a|0;Hd[f[f[b>>2]>>2]&1023](b);return a|0}function thb(a,b){a=a|0;b=b|0;var c=0;c=khb(b)|0;c=sd[f[(f[c>>2]|0)+12>>2]&2047](c)|0;if((c|0)!=(f[a>>2]|0)){c=0;return c|0}a=f[a+4>>2]|0;if(!a){c=1;return c|0}c=(f[b+4>>2]|0)==(a|0);return c|0}function uhb(a,b){a=a|0;b=b|0;var c=0,d=0;c=t;t=t+16|0;d=c;a=(f[a+4>>2]|0)+208|0;f[d>>2]=1;mhb(a,28,b,d)|0;t=c;return (b|0)!=0|0}function vhb(a){a=a|0;return (f[a+4>>2]|0)+208|0}function whb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,g=0,h=0;h=t;t=t+16|0;e=h;g=gpd(16)|0;rcb(g,b,c,d);f[e>>2]=g;a=f[a+4>>2]|0;b=a+100|0;c=f[b>>2]|0;if((c|0)==(f[a+104>>2]|0)){A5(a+96|0,e);g=f[e>>2]|0;t=h;return g|0}else{f[c>>2]=g;f[b>>2]=(f[b>>2]|0)+4;g=f[e>>2]|0;t=h;return g|0}return 0}function xhb(a){a=a|0;return (f[a+4>>2]|0)+192|0}function yhb(a){a=a|0;return (f[a+4>>2]|0)+200|0}function zhb(a){a=a|0;return (f[a+4>>2]|0)+216|0}function Ahb(a){a=a|0;return (f[a+4>>2]|0)+224|0}function Bhb(a){a=a|0;return (f[a+4>>2]|0)+228|0}function Chb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;f[a>>2]=67884;e=gpd(96)|0;Dhb(e,b,c,d);f[a+4>>2]=e;return}function Dhb(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var g=0,h=0;g=t;t=t+16|0;h=g;f[a>>2]=c;f[a+4>>2]=0;f[a+8>>2]=d;f[a+12>>2]=0;f[a+16>>2]=e;b[a+20>>0]=1;e=gpd(12)|0;mab(e);Ehb(a+28|0,e);f[a+32>>2]=0;f[a+36>>2]=0;Fhb(a+40|0,h);j5(a+52|0,h);V4(a+64|0,c);Ghb()|0;f[a+24>>2]=74476;t=g;return}function Ehb(a,b){a=a|0;b=b|0;f[a>>2]=b;if(!b)return;Hd[f[f[b>>2]>>2]&1023](b);return}function Fhb(a,b){a=a|0;b=b|0;f[a+4>>2]=0;f[a+8>>2]=0;f[a>>2]=a+4;return}function Ghb(){(b[147432]|0)==0?ord(147432)|0:0;return 74476}function Hhb(a,c){a=a|0;c=c|0;b[(f[a+20>>2]|0)+56>>0]=c&1;return}function Ihb(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,g=0;g=t;t=t+16|0;d=g;e=gpd(12)|0;R0(e,b);a=f[a+20>>2]|0;G0(d,e);b=a+76|0;c=f[b>>2]|0;if(c>>>0<(f[a+80>>2]|0)>>>0){H0(c,d);f[b>>2]=(f[b>>2]|0)+4;s_(d);t=g;return e|0}else{I0(a+72|0,d);s_(d);t=g;return e|0}return 0}function Jhb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0,h=0;h=t;t=t+16|0;e=h+4|0;g=h;f[e>>2]=-1;a=a+20|0;e=Khb(f[a>>2]|0,b,e)|0;f[g>>2]=e;do if(!e){e=gpd(4)|0;Kab(e,b);f[g>>2]=e;a=f[a>>2]|0;b=a+20|0;d=f[b>>2]|0;if((d|0)==(f[a+24>>2]|0)){Lhb(a+16|0,g);break}else{f[d>>2]=e;f[b>>2]=(f[b>>2]|0)+4;break}}while(0);Nab(f[g>>2]|0,c);t=h;return f[g>>2]|0}function Khb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,g=0;g=f[a+20>>2]|0;d=0;a=f[a+16>>2]|0;while(1){if((a|0)==(g|0)){e=0;d=-1;a=5;break}e=f[a>>2]|0;if((G$(e)|0)==(b|0)){a=5;break}d=d+1|0;a=a+4|0}if((a|0)==5){f[c>>