/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","../getResourceBundle","../threejs/thirdparty/three","./Gizmo","./AnchorPointToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,g,t,G,A,C,c){"use strict";var d=G.extend("sap.ui.vk.tools.AnchorPointToolGizmo",{metadata:{library:"sap.ui.vk"}});d.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(null,84);this._gizmoIndex=-1;this._handleIndex=-1;this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._sceneGizmo.add(l);this._sceneGizmo.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._touchAreas=new THREE.Group();this._gizmo=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoOffset=new THREE.Vector3();this._gizmoRotation=new THREE.Vector3();function f(a,b,p){var r=144,s=window.devicePixelRatio*0.5,u=32,v=6,w=48;a.multiplyScalar(1/r);var x=new THREE.CylinderBufferGeometry(s,s,r-u,4);var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(a.y,a.z,a.x),a,new THREE.Vector3(a.z,a.x,a.y));m.setPosition(a.clone().multiplyScalar((r-u)*0.5));x.applyMatrix(m);var y=new THREE.MeshLambertMaterial({color:b,transparent:true});var z=new THREE.Mesh(x,y);z.matrixAutoUpdate=false;z.userData.color=b;var B=new THREE.CylinderBufferGeometry(0,v,u,12,1);m.setPosition(a.clone().multiplyScalar(r-u*0.5));B.applyMatrix(m);var D=new THREE.Mesh(B,y);D.matrixAutoUpdate=false;z.add(D);var E=new THREE.CylinderGeometry(w*0.5,w*0.5,w,12,1);E.applyMatrix(m);var F=new THREE.CylinderGeometry(w*0.5,w*0.2,w,12,1);m.setPosition(a.clone().multiplyScalar(r*0.5));E.merge(F,m);p.add(new THREE.Mesh(E,y));return z;}function h(a,b,m){var p=new Float32Array(9);p[a]=p[b+6]=1;p[a+3]=p[b+3]=0.5;var v=new THREE.Vector3().setComponent(a,0.333);var r=new THREE.Vector3().setComponent(b,0.333);var o=new THREE.Geometry();o.vertices.push(new THREE.Vector3(),v,r,v.clone().add(r));o.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));var s=new THREE.MeshBasicMaterial({color:0xFFFF00,opacity:0.5,transparent:true,visible:false,side:THREE.DoubleSide});var u=new THREE.Mesh(o,s);u.matrixAutoUpdate=false;u.userData.colors=p;var w=new THREE.BufferGeometry();var x=new Float32Array(9);x[a]=x[a+3]=x[b+3]=x[b+6]=0.333;w.addAttribute("position",new THREE.Float32BufferAttribute(x,3));w.addAttribute("color",new THREE.Float32BufferAttribute(p,3));var y=new THREE.Line(w,new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,transparent:true,linewidth:window.devicePixelRatio}));y.matrixAutoUpdate=false;u.add(y);var z=new THREE.Geometry();z.vertices.push(new THREE.Vector3(),v,r,v.clone().add(r));z.faces.push(new THREE.Face3(0,1,2),new THREE.Face3(2,1,3));m.add(new THREE.Mesh(z,new THREE.MeshBasicMaterial({side:THREE.DoubleSide})));return u;}function j(a,b,r,s){var o=new THREE.TorusBufferGeometry(r,window.devicePixelRatio/288,4,s,Math.PI/2);if(a===0){o.rotateY(Math.PI/-2);}else if(a===1){o.rotateX(Math.PI/2);}var m=new THREE.Mesh(o,new THREE.MeshBasicMaterial({color:b,transparent:true}));m.matrixAutoUpdate=false;m.userData.color=b;return m;}function k(a,r,s){var o=new THREE.TorusBufferGeometry(r,24/144,4,s,Math.PI/2);if(a===0){o.rotateY(Math.PI/-2);}else if(a===1){o.rotateX(Math.PI/2);}return new THREE.Mesh(o,new THREE.MeshBasicMaterial({opacity:0.2,transparent:true}));}this._gizmo.add(f(new THREE.Vector3(1,0,0),c.x,this._touchAreas));this._gizmo.add(f(new THREE.Vector3(0,1,0),c.y,this._touchAreas));this._gizmo.add(f(new THREE.Vector3(0,0,1),c.z,this._touchAreas));this._gizmo.add(h(1,2,this._touchAreas));this._gizmo.add(h(2,0,this._touchAreas));this._gizmo.add(h(0,1,this._touchAreas));for(var i=0;i<3;i++){this._gizmo.add(j(i,0xFF<<8*(2-i),1,32));this._touchAreas.add(k(i,1,24));}var n=new THREE.MeshBasicMaterial({color:0x0080FF,opacity:0.5,transparent:true,side:THREE.DoubleSide});this._arcMesh=new THREE.Mesh(new THREE.Geometry(),n);this._arcMesh.drawMode=THREE.TriangleFanDrawMode;this._arcMesh.visible=false;this._gizmo.add(this._arcMesh);this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);var o=new THREE.Geometry();o.vertices.push(new THREE.Vector3(),new THREE.Vector3());this._line=new THREE.LineSegments(o,new THREE.LineBasicMaterial());this._line.frustumCulled=false;this._line.visible=false;this._gizmo.add(this._line);};d.prototype.hasDomElement=function(){return true;};d.prototype.show=function(v,a){this._viewport=v;this._tool=a;var b=this._tool.getEnableRotation();for(var i=6;i<9;i++){this._gizmo.children[i].visible=this._touchAreas.children[i].visible=b;}var f=v.getScene().getSceneRef().userData.anchorPoint;if(f){this._gizmo.position.copy(f.position);this._gizmo.quaternion.copy(f.quaternion);}else{v.getScene().getSceneRef().userData.anchorPoint=this._gizmo;}};d.prototype.hide=function(){this._viewport=null;this._tool=null;};d.prototype.setPosition=function(p){this._gizmo.position.copy(p);this._viewport.setShouldRenderFrame();};d.prototype.getGizmoCount=function(){return 1;};d.prototype.getTouchObject=function(i){this._touchAreas.position.copy(this._gizmo.position);this._touchAreas.quaternion.copy(this._gizmo.quaternion);this._touchAreas.scale.copy(this._gizmo.scale);this._touchAreas.updateMatrixWorld(true);return this._touchAreas;};var e=[1,2,4,6,5,3,1,2,4];d.prototype.highlightHandle=function(a,h){var i;for(i=0;i<3;i++){var b=this._gizmo.children[i];var f=e[a]&(1<<i);var j=f?0xFFFF00:b.userData.color;b.material.color.setHex(j);b.children[0].material.color.setHex(j);this._axisTitles.children[i].material.color.setHex(j);}for(i=3;i<6;i++){var p=this._gizmo.children[i];p.material.visible=i===a;var k=p.children[0].geometry.attributes.color;k.copyArray(i===a?[1,1,0,1,1,0,1,1,0]:p.userData.colors);k.needsUpdate=true;p.children[0].material.opacity=(i===a||(h&&a===-1))?1:0.35;p.children[0].visible=(i===a||h);}for(i=6;i<9;i++){var l=this._gizmo.children[i];l.visible=this._tool.getEnableRotation()&&(i===a||h);l.material.color.setHex(i===a?0xFFFF00:l.userData.color);l.material.opacity=(i===a||(h&&a===-1))?1:0.35;}};d.prototype.selectHandle=function(i){this._handleIndex=i;if(i>=0&&i<3){this._units.setText(g().getText("TOOL_UNITS_MM"));}else if(i>=6&&i<9){this._units.setText(String.fromCharCode(176));}this._editingForm.rerender();this._viewport.setShouldRenderFrame();};d.prototype.beginGesture=function(){this._isMoved=false;this._isRotated=false;this._originPosition=new THREE.Vector3().setFromMatrixPosition(this._gizmo.matrixWorld);this._originQuaternion=this._gizmo.quaternion.clone();};d.prototype.endGesture=function(){if(this._isMoved){this._tool.fireMoved({x:this._gizmoOffset.x,y:this._gizmoOffset.y,z:this._gizmoOffset.z});}if(this._isRotated){this._tool.fireRotated({x:this._gizmoRotation.x,y:this._gizmoRotation.y,z:this._gizmoRotation.z});}this._line.visible=false;this._arcMesh.visible=false;};d.prototype._setOffset=function(o,a){if(this._tool.fireEvent("moving",{x:o.x,y:o.y,z:o.z},true)){this._move(o);var m=new THREE.Matrix4().getInverse(this._gizmo.matrixWorld);var s=new THREE.Vector3().setFromMatrixScale(this._gizmo.matrixWorld);var n=this._gizmo.position.clone().applyMatrix4(m);o.copy(this._originPosition).applyMatrix4(m).sub(n).multiply(s);this._line.geometry.vertices[0].copy(o);this._line.geometry.verticesNeedUpdate=true;this._line.geometry.computeBoundingBox();o.set(Math.abs(o.x),Math.abs(o.y),Math.abs(o.z));o.multiplyScalar(1/Math.max(o.x,o.y,o.z));this._line.material.color.setRGB(o.x,o.y,o.z);this._line.visible=true;}};d.prototype._move=function(o){this._isMoved=true;this._gizmoOffset.copy(o);this._gizmo.position.copy(this._originPosition).add(o);this._viewport.setShouldRenderFrame();};d.prototype.move=function(x,y,z){this.beginGesture();this._move(new THREE.Vector3(x,y,z||0));};d.prototype._setRotationAxisAngle=function(b,f,h){var j=h-f;if(Math.abs(j)>Math.PI){j-=Math.PI*2*Math.sign(j);}var k=[0,0,0];k[b]=j;k=new THREE.Euler().fromArray(k);if(this._tool.fireEvent("rotating",{x:THREE.Math.radToDeg(k.x),y:THREE.Math.radToDeg(k.y),z:THREE.Math.radToDeg(k.z)},true)){this._rotate(k);var v=[0,0,0];var l=new THREE.Vector3();var m=(b+1)%3,o=(b+2)%3;var n=Math.max(Math.ceil(Math.abs(j)*64/Math.PI),1);for(var i=0;i<=n;i++){var a=f-j*(i/n);l.set(0,0,0).setComponent(m,Math.cos(a)).setComponent(o,Math.sin(a));v.push(l.x,l.y,l.z);}this._arcMesh.geometry=new THREE.BufferGeometry().addAttribute("position",new THREE.Float32BufferAttribute(v,3));this._arcMesh.visible=true;}};d.prototype._rotate=function(a){this._isRotated=true;this._gizmoRotation.set(THREE.Math.radToDeg(a.x),THREE.Math.radToDeg(a.y),THREE.Math.radToDeg(a.z));var b=new THREE.Quaternion().setFromEuler(a);this._gizmo.quaternion.copy(this._originQuaternion).multiply(b);this._viewport.setShouldRenderFrame();};d.prototype.rotate=function(x,y,z){this.beginGesture();this._rotate(new THREE.Euler(THREE.Math.degToRad(x||0),THREE.Math.degToRad(y||0),THREE.Math.degToRad(z||0)));};d.prototype.getValue=function(){if(this._handleIndex>=0&&this._handleIndex<3){var a=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return a.dot(this._gizmo.position);}if(this._handleIndex>=6&&this._handleIndex<9){return THREE.Math.radToDeg(this._gizmo.rotation.reorder("YXZ")[["x","y","z"][this._handleIndex-6]]);}return 0;};d.prototype.setValue=function(v){if(this._handleIndex>=0&&this._handleIndex<3){this.beginGesture();var o=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize().multiplyScalar(v-this._lastEditValue);this._move(o);this.endGesture();}else if(this._handleIndex>=6&&this._handleIndex<9){this.beginGesture();var a=this._gizmo.rotation.clone();a[["x","y","z"][this._handleIndex-6]]=THREE.Math.degToRad(v);var b=new THREE.Quaternion().setFromEuler(a);var f=this._gizmo.quaternion.clone().inverse().multiply(b);a.setFromQuaternion(f);this._rotate(a);this.endGesture();}};d.prototype.expandBoundingBox=function(b){if(this._viewport){this._expandBoundingBox(b,this._viewport.getCamera().getCameraRef());}};d.prototype._updateGizmoTransformation=function(i,a){this._matViewProj.multiplyMatrices(a.projectionMatrix,a.matrixWorldInverse);var s=this._getGizmoScale(this._gizmo.position);this._gizmo.scale.setScalar(this._gizmoSize*s);this._gizmo.updateMatrixWorld(true);this._updateAxisTitles(this._axisTitles,this._gizmo,a,this._gizmoSize+18,s);this._line.scale.setScalar(1/(this._gizmoSize*s));};d.prototype._getEditingFormPosition=function(){var s=this._getGizmoScale(this._gizmo.position);var a=new THREE.Vector3();if(this._handleIndex>=0&&this._handleIndex<3){a.setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();}else if(this._handleIndex>=6&&this._handleIndex<9){var i=this._handleIndex%3;var b=this._extractBasis(this._gizmo.matrixWorld);a.copy(b[(i+1)%3]).add(b[(i+2)%3]).normalize();}return a.clone().multiplyScalar((this._gizmoSize+18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};d.prototype.render=function(){var r=this._viewport.getRenderer(),a=this._viewport.getCamera().getCameraRef();r.clearDepth();this._updateGizmoTransformation(0,a);r.render(this._sceneGizmo,a);this._updateEditingForm((this._handleIndex>=0&&this._handleIndex<3)||(this._handleIndex>=6&&this._handleIndex<9),this._handleIndex%3);};return d;});
