/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","../getResourceBundle","../threejs/thirdparty/three","./Gizmo","./MoveToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,g,t,G,M,C,A){"use strict";var c=G.extend("sap.ui.vk.tools.MoveToolGizmo",{metadata:{library:"sap.ui.vk"}});c.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(g().getText("TOOL_UNITS_MM"),84);this._gizmoIndex=-1;this._handleIndex=-1;this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();var l=new THREE.DirectionalLight(0xFFFFFF,0.5);l.position.set(1,3,2);this._sceneGizmo.add(l);this._sceneGizmo.add(new THREE.AmbientLight(0xFFFFFF,0.5));this._gizmo=new THREE.Group();this._touchAreas=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._coordinateSystem=C.World;this._nodes=[];this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoOffset=new THREE.Vector3();function e(a,b,i){var j=144,k=window.devicePixelRatio*0.5,n=32,o=6,p=48;a.multiplyScalar(1/j);var r=new THREE.MeshLambertMaterial({color:b,transparent:true});var s=new THREE.CylinderBufferGeometry(k,k,j-n,4);var m=new THREE.Matrix4().makeBasis(new THREE.Vector3(a.y,a.z,a.x),a,new THREE.Vector3(a.z,a.x,a.y));m.setPosition(a.clone().multiplyScalar((j-n)*0.5));s.applyMatrix(m);var u=new THREE.Mesh(s,r);u.matrixAutoUpdate=false;u.userData.color=b;var v=new THREE.CylinderBufferGeometry(0,o,n,12,1);m.setPosition(a.clone().multiplyScalar(j-n*0.5));v.applyMatrix(m);var w=new THREE.Mesh(v,r);w.matrixAutoUpdate=false;u.add(w);var x=new THREE.CylinderGeometry(p*0.5,p*0.5,p,12,1);x.applyMatrix(m);var y=new THREE.CylinderGeometry(p*0.5,p*0.2,p,12,1);m.setPosition(a.clone().multiplyScalar(j*0.5));x.merge(y,m);i.add(new THREE.Mesh(x,r));return u;}function f(a,b,i){var j=new Float32Array(9);j[a]=j[b+6]=1;j[a+3]=j[b+3]=0.5;var v=new THREE.Vector3().setComponent(a,0.333);var k=new THREE.Vector3().setComponent(b,0.333);var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(),v,k,v.clone().add(k));h.faces.push(new THREE.Face3(0,2,1),new THREE.Face3(1,2,3));var m=new THREE.MeshBasicMaterial({color:0xFFFF00,opacity:0.5,transparent:true,visible:false,side:THREE.DoubleSide});var p=new THREE.Mesh(h,m);p.matrixAutoUpdate=false;p.userData.colors=j;var n=new THREE.BufferGeometry();var o=new Float32Array(9);o[a]=o[a+3]=o[b+3]=o[b+6]=0.333;n.addAttribute("position",new THREE.Float32BufferAttribute(o,3));n.addAttribute("color",new THREE.Float32BufferAttribute(j,3));var r=new THREE.Line(n,new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,transparent:true,linewidth:window.devicePixelRatio}));r.matrixAutoUpdate=false;p.add(r);var s=new THREE.Geometry();s.vertices.push(new THREE.Vector3(),v,k,v.clone().add(k));s.faces.push(new THREE.Face3(0,1,2),new THREE.Face3(2,1,3));i.add(new THREE.Mesh(s,new THREE.MeshBasicMaterial({side:THREE.DoubleSide})));return p;}this._gizmo.add(e(new THREE.Vector3(1,0,0),A.x,this._touchAreas));this._gizmo.add(e(new THREE.Vector3(0,1,0),A.y,this._touchAreas));this._gizmo.add(e(new THREE.Vector3(0,0,1),A.z,this._touchAreas));this._gizmo.add(f(1,2,this._touchAreas));this._gizmo.add(f(2,0,this._touchAreas));this._gizmo.add(f(0,1,this._touchAreas));this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);var h=new THREE.Geometry();h.vertices.push(new THREE.Vector3(),new THREE.Vector3());this._line=new THREE.LineSegments(h,new THREE.LineBasicMaterial());this._line.frustumCulled=false;this._line.visible=false;this._gizmo.add(this._line);};c.prototype.hasDomElement=function(){return true;};c.prototype.setCoordinateSystem=function(a){this._coordinateSystem=a;var s=a===C.Screen;var b=this._gizmo.children,e=this._touchAreas.children;b[2].visible=b[3].visible=b[4].visible=!s;e[2].visible=e[3].visible=e[4].visible=!s;this._axisTitles.children[2].visible=!s;this._gizmoIndex=this._handleIndex=-1;};c.prototype.show=function(v,a){this._viewport=v;this._tool=a;this._nodes.length=0;this._updateSelection(v._viewStateManager);};c.prototype.hide=function(){this._viewport=null;this._tool=null;this._gizmoIndex=this._handleIndex=-1;this._updateEditingForm(false);};c.prototype.getGizmoCount=function(){if(this._coordinateSystem===C.Local){return this._nodes.length;}else{return this._nodes.length>0?1:0;}};c.prototype.getTouchObject=function(i){if(this._nodes.length===0){return null;}this._updateGizmoObjectTransformation(this._touchAreas,i);return this._touchAreas;};var d=[1,2,4,6,5,3];c.prototype.highlightHandle=function(a,h){var i;for(i=0;i<3;i++){var b=this._gizmo.children[i];var e=d[a]&(1<<i);var f=e?0xFFFF00:b.userData.color;b.material.color.setHex(f);b.material.opacity=(e||h)?1:0.35;b.children[0].material.color.setHex(f);b.children[0].material.opacity=(e||h)?1:0.35;var j=this._axisTitles.children[i];j.material.color.setHex(f);j.material.opacity=e||h?1:0.35;}for(i=3;i<6;i++){var p=this._gizmo.children[i];p.material.visible=i===a;var k=p.children[0].geometry.attributes.color;k.copyArray(i===a?[1,1,0,1,1,0,1,1,0]:p.userData.colors);k.needsUpdate=true;p.children[0].material.opacity=(i===a||h)?1:0.35;}};c.prototype.selectHandle=function(i,a){this._gizmoIndex=a;this._handleIndex=i;this._viewport.setShouldRenderFrame();};c.prototype.beginGesture=function(){this._matOrigin=this._gizmo.matrixWorld.clone();this._nodes.forEach(function(n){var a=n.node;n.matOrigin=a.matrixWorld.clone();n.originLocal=a.position.clone();n.origin=new THREE.Vector3().setFromMatrixPosition(a.matrixWorld);n.matParentInv=new THREE.Matrix4().getInverse(a.parent.matrixWorld);});};c.prototype.endGesture=function(){this._line.visible=false;this._tool.fireMoved({x:this._gizmoOffset.x,y:this._gizmoOffset.y,z:this._gizmoOffset.z});};c.prototype._setOffset=function(o,a){if(this._coordinateSystem===C.Local){var n=this._nodes[a];var m=new THREE.Matrix4().getInverse(n.node.matrixWorld);var s=new THREE.Vector3().setFromMatrixScale(n.node.matrixWorld);var b=n.origin.clone().applyMatrix4(m);o=n.origin.clone().add(o).applyMatrix4(m).sub(b).multiply(s);}else if(this._coordinateSystem===C.Screen){var e=this._viewport.getRenderer().getSize();var p=this._gizmo.position.clone().applyMatrix4(this._matViewProj);var f=this._gizmo.position.clone().add(o).applyMatrix4(this._matViewProj);o.set(Math.round((f.x-p.x)*0.5*e.width),Math.round((f.y-p.y)*0.5*e.height),0);}if(this._tool.fireEvent("moving",{x:o.x,y:o.y,z:o.z},true)){this._move(o);if(this._coordinateSystem===C.Screen){o.set(new THREE.Vector3().setFromMatrixColumn(this._matOrigin,0).normalize().dot(o),new THREE.Vector3().setFromMatrixColumn(this._matOrigin,1).normalize().dot(o),0);}else if(this._coordinateSystem===C.Custom){var h=this._getAnchorPoint();if(h){var i=new THREE.Matrix4().getInverse(h.matrixWorld);var j=new THREE.Vector3().setFromMatrixScale(h.matrixWorld);var k=h.position.clone().applyMatrix4(i);o.copy(h.position.clone().add(o).applyMatrix4(i).sub(k).multiply(j));}}this._line.geometry.vertices[0].setScalar(0).sub(o);this._line.geometry.verticesNeedUpdate=true;this._line.geometry.computeBoundingBox();o.set(Math.abs(o.x),Math.abs(o.y),Math.abs(o.z));o.multiplyScalar(1/Math.max(o.x,o.y,o.z));this._line.material.color.setRGB(o.x,o.y,o.z);this._line.visible=true;}};c.prototype._move=function(o){this._gizmoOffset.copy(o);if(this._coordinateSystem===C.Local){this._nodes.forEach(function(n){var i=n.node;var j=this._extractBasis(i.matrixWorld);var p=n.origin.clone();p.add(j[0].multiplyScalar(o.x)).add(j[1].multiplyScalar(o.y)).add(j[2].multiplyScalar(o.z));i.matrixWorld.setPosition(p);i.matrix.multiplyMatrices(n.matParentInv,i.matrixWorld);i.position.setFromMatrixPosition(i.matrix);}.bind(this));}else{if(this._coordinateSystem===C.Screen){var s=this._viewport.getRenderer().getSize();var a=this._viewport.getCamera().getCameraRef();var b=new THREE.Vector4().copy(this._gizmo.position).applyMatrix4(this._matViewProj);var e=o.x*2*b.w/(a.projectionMatrix.elements[0]*s.width);var f=o.y*2*b.w/(a.projectionMatrix.elements[5]*s.height);o.setFromMatrixColumn(a.matrixWorld,0).multiplyScalar(e);o.add(new THREE.Vector3().setFromMatrixColumn(a.matrixWorld,1).multiplyScalar(f));}this._gizmo.position.setFromMatrixPosition(this._matOrigin).add(o);if(this._coordinateSystem===C.Custom){var h=this._getAnchorPoint();if(h){h.position.copy(this._gizmo.position);}}this._nodes.forEach(function(n){if(!n.ignore){var i=n.node;i.matrixWorld.setPosition(n.origin.clone().add(o));i.matrix.multiplyMatrices(n.matParentInv,i.matrixWorld);i.position.setFromMatrixPosition(i.matrix);}});}this._viewport.setShouldRenderFrame();};c.prototype.move=function(x,y,z){this.beginGesture();this._move(new THREE.Vector3(x,y,z||0));};c.prototype.getValue=function(){var v=0,p,o,a;if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){switch(this._coordinateSystem){default:case C.World:v=this._gizmo.position.getComponent(this._handleIndex);break;case C.Local:var n=this._nodes[this._gizmoIndex].node;p=new THREE.Vector3().setFromMatrixPosition(n.parent.matrixWorld);o=this._gizmo.position.clone().sub(p);a=new THREE.Vector3().setFromMatrixColumn(n.matrixWorld,this._handleIndex).normalize();v=a.dot(o);break;case C.Screen:var r=this._viewport.getRenderer();var s=r.getSize();p=this._gizmo.position.clone().applyMatrix4(this._matViewProj);p.x*=s.width*0.5;p.y*=s.height*0.5;v=p.getComponent(this._handleIndex);break;case C.Custom:var b=this._getAnchorPoint();if(b){p=new THREE.Vector3().setFromMatrixPosition(b.matrixWorld);o=this._gizmo.position.clone().sub(p);a=new THREE.Vector3().setFromMatrixColumn(b.matrixWorld,this._handleIndex).normalize();v=a.dot(o);}break;}}return v;};c.prototype.setValue=function(v){if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){this.beginGesture();var o=new THREE.Vector3();if(this._coordinateSystem===C.Custom){var a=this._getAnchorPoint();if(a){o.setFromMatrixColumn(a.matrixWorld,this._handleIndex).normalize().multiplyScalar(v-this._lastEditValue);}}else{o.setComponent(this._handleIndex,v-this._lastEditValue);}this._move(o);this.endGesture();}};c.prototype.expandBoundingBox=function(b){if(this._viewport){this._expandBoundingBox(b,this._viewport.getCamera().getCameraRef());}};c.prototype.handleSelectionChanged=function(e){if(this._viewport){this._updateSelection(this._viewport._viewStateManager);this._gizmoIndex=this._handleIndex=-1;}};c.prototype._updateGizmoTransformation=function(i,a){var s=this._updateGizmoObjectTransformation(this._gizmo,i);this._updateAxisTitles(this._axisTitles,this._gizmo,a,this._gizmoSize+18,s);this._line.scale.setScalar(1/(this._gizmoSize*s));};c.prototype._getEditingFormPosition=function(){var s=this._updateGizmoObjectTransformation(this._gizmo,this._gizmoIndex);var a=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return a.clone().multiplyScalar((this._gizmoSize+18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};c.prototype.render=function(){if(this._nodes.length>0){var r=this._viewport.getRenderer(),a=this._viewport.getCamera().getCameraRef();this._matViewProj.multiplyMatrices(a.projectionMatrix,a.matrixWorldInverse);r.clearDepth();for(var i=0,l=this.getGizmoCount();i<l;i++){this._updateGizmoTransformation(i,a);r.render(this._sceneGizmo,a);}}this._updateEditingForm(this._nodes.length>0&&this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3,this._handleIndex);};return c;});
