/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","../threejs/thirdparty/three","./Gizmo","./RotateToolGizmoRenderer","./CoordinateSystem","./AxisColours"],function(q,t,G,R,C,A){"use strict";var b=G.extend("sap.ui.vk.tools.RotateToolGizmo",{metadata:{library:"sap.ui.vk"}});b.prototype.init=function(){if(G.prototype.init){G.prototype.init.apply(this);}this._createEditingForm(String.fromCharCode(176),84);this._gizmoIndex=-1;this._handleIndex=-1;this._lastAngle=[0,0,0];this._viewport=null;this._tool=null;this._sceneGizmo=new THREE.Scene();this._gizmo=new THREE.Group();this._touchAreas=new THREE.Group();this._sceneGizmo.add(this._gizmo);this._coordinateSystem=C.World;this._nodes=[];this._matViewProj=new THREE.Matrix4();this._gizmoSize=144;this._gizmoRotation=new THREE.Vector3();function c(f,d,r,s){var g=new THREE.TorusBufferGeometry(r,window.devicePixelRatio/288,4,s);if(f===0){g.rotateY(Math.PI/2);}else if(f===1){g.rotateX(Math.PI/2);}var h=new THREE.Mesh(g,new THREE.MeshBasicMaterial({color:d,transparent:true}));h.matrixAutoUpdate=false;h.userData.color=d;return h;}function a(f,r,s){var g=new THREE.TorusBufferGeometry(r,24/144,4,s);if(f===0){g.rotateY(Math.PI/2);}else if(f===1){g.rotateX(Math.PI/2);}return new THREE.Mesh(g,new THREE.MeshBasicMaterial({opacity:0.2,transparent:true}));}for(var i=0;i<3;i++){var d=0;switch(i){case 0:d=A.x;break;case 1:d=A.y;break;case 2:d=A.z;break;default:break;}this._gizmo.add(c(i,d,1,128));this._touchAreas.add(a(i,1,24));}this._gizmo.add(new THREE.AxesHelper(0.75));var e=new THREE.MeshBasicMaterial({color:0x0080FF,opacity:0.5,transparent:true,side:THREE.DoubleSide});this._arcMesh=new THREE.Mesh(new THREE.Geometry(),e);this._arcMesh.drawMode=THREE.TriangleFanDrawMode;this._arcMesh.visible=false;this._gizmo.add(this._arcMesh);this._axisTitles=this._createAxisTitles();this._sceneGizmo.add(this._axisTitles);};b.prototype.hasDomElement=function(){return true;};b.prototype.setCoordinateSystem=function(c){this._coordinateSystem=c;var s=c===C.Screen;this._gizmo.children[0].visible=this._gizmo.children[1].visible=!s;this._touchAreas.children[0].visible=this._touchAreas.children[1].visible=!s;this._axisTitles.visible=!s;this._gizmoIndex=this._handleIndex=-1;};b.prototype.show=function(v,a){this._viewport=v;this._tool=a;this._nodes.length=0;this._updateSelection(v._viewStateManager);};b.prototype.hide=function(){this._viewport=null;this._tool=null;this._gizmoIndex=this._handleIndex=-1;this._updateEditingForm(false);};b.prototype.getGizmoCount=function(){if(this._coordinateSystem===C.Local){return this._nodes.length;}else{return this._nodes.length>0?1:0;}};b.prototype.getTouchObject=function(i){if(this._nodes.length===0){return null;}this._updateGizmoObjectTransformation(this._touchAreas,i);return this._touchAreas;};b.prototype.getGizmoObject=function(){return this._nodes.length>0?this._gizmo:null;};b.prototype.highlightHandle=function(a,h){for(var i=0;i<3;i++){var c=this._gizmo.children[i];var d=i===a?0xFFFF00:c.userData.color;c.material.color.setHex(d);c.material.opacity=a===-1||i===a?1:0.35;c.material.visible=h||i===a;var e=this._axisTitles.children[i];e.material.color.setHex(d);e.material.opacity=a===-1||i===a?1:0.35;e.material.visible=h||i===a;}};b.prototype.selectHandle=function(i,g){this._gizmoIndex=g;this._handleIndex=i;this._viewport.setShouldRenderFrame();};b.prototype.beginGesture=function(){this._matOrigin=this._gizmo.matrixWorld.clone();this._nodes.forEach(function(n){n.node.parent.updateMatrixWorld(true);n.matOrigin=n.node.matrixWorld.clone();n.matLocalOrigin=n.node.matrix.clone();n.matParentInv=new THREE.Matrix4().getInverse(n.node.parent.matrixWorld);n.quaternion=n.node.quaternion.clone();});};b.prototype.endGesture=function(){this._arcMesh.visible=false;this._tool.fireRotated({x:this._gizmoRotation.x,y:this._gizmoRotation.y,z:this._gizmoRotation.z});};b.prototype._rotate=function(e){this._gizmoRotation.set(THREE.Math.radToDeg(e.x),THREE.Math.radToDeg(e.y),THREE.Math.radToDeg(e.z));var a=new THREE.Quaternion();if(this._coordinateSystem===C.Local){a.setFromEuler(e);this._nodes.forEach(function(h){h.node.quaternion.copy(h.quaternion).multiply(a);h.node.matrixWorldNeedsUpdate=true;});}else{e=e.toArray();for(var i=0;i<3;i++){var c=e[i];if(c){var d=e[3].charCodeAt(i)-88;if(d>=0&&d<3){var f=new THREE.Vector3().setFromMatrixColumn(this._matOrigin,d).normalize();var m=new THREE.Matrix4().makeRotationAxis(f,c);var p=new THREE.Vector3().setFromMatrixPosition(this._matOrigin);m.setPosition(p.sub(p.clone().applyMatrix4(m)));for(var n=0,g=this._nodes.length;n<g;n++){var h=this._nodes[n];if(!h.ignore){var j=h.node;j.position.setFromMatrixPosition(h.matOrigin).applyMatrix4(m).applyMatrix4(h.matParentInv);var s=new THREE.Vector3().setFromMatrixScale(h.matOrigin);var l=f.clone().transformDirection(new THREE.Matrix4().getInverse(h.matOrigin)).multiply(s).normalize();a.setFromAxisAngle(l,c);j.quaternion.copy(h.quaternion).multiply(a);j.matrixWorldNeedsUpdate=true;}}}}}}this._viewport.setShouldRenderFrame();};b.prototype._setRotationAxisAngle=function(c,d,e){var f=this._lastAngle[c]=e-d;if(Math.abs(f)>Math.PI){f-=Math.PI*2*Math.sign(f);}var g=[0,0,0];g[c]=f;g=new THREE.Euler().fromArray(g);if(this._tool.fireEvent("rotating",{x:THREE.Math.radToDeg(g.x),y:THREE.Math.radToDeg(g.y),z:THREE.Math.radToDeg(g.z)},true)){this._rotate(g);var v=[0,0,0];var h=new THREE.Vector3();var j=(c+1)%3,k=(c+2)%3;var n=Math.max(Math.ceil(Math.abs(f)*64/Math.PI),1);f*=this._coordinateSystem===C.Local?-1:1;for(var i=0;i<=n;i++){var a=d+f*(i/n);h.set(0,0,0).setComponent(j,Math.cos(a)).setComponent(k,Math.sin(a));v.push(h.x,h.y,h.z);}this._arcMesh.geometry=new THREE.BufferGeometry().addAttribute("position",new THREE.Float32BufferAttribute(v,3));this._arcMesh.visible=true;}};b.prototype.rotate=function(x,y,z){this.beginGesture();this._rotate(new THREE.Euler(THREE.Math.degToRad(x||0),THREE.Math.degToRad(y||0),THREE.Math.degToRad(z||0)));};b.prototype.getValue=function(){this._lastRotation=new THREE.Euler();if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){switch(this._coordinateSystem){case C.World:if(this._nodes.length===1){this._lastRotation.setFromRotationMatrix(this._nodes[0].node.matrixWorld);}break;case C.Local:this._lastRotation.copy(this._nodes[this._gizmoIndex].node.rotation);break;case C.Custom:case C.Screen:this._lastRotation[["x","y","z"][this._handleIndex]]=this._lastAngle[this._handleIndex];break;default:break;}}this._lastRotation.reorder("YXZ");return THREE.Math.radToDeg(this._lastRotation[["x","y","z"][this._handleIndex]]);};b.prototype.setValue=function(v){if(this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3){if(this._coordinateSystem===C.Screen||this._coordinateSystem===C.Custom){this._lastAngle[this._handleIndex]=THREE.Math.degToRad(v);}this.beginGesture();var a=new THREE.Quaternion().setFromEuler(this._lastRotation);this._lastRotation[["x","y","z"][this._handleIndex]]=THREE.Math.degToRad(v);var c=new THREE.Quaternion().setFromEuler(this._lastRotation);var e=new THREE.Euler().setFromQuaternion(a.inverse().multiply(c));this._rotate(e);this.endGesture();}};b.prototype.expandBoundingBox=function(a){if(this._viewport){this._expandBoundingBox(a,this._viewport.getCamera().getCameraRef());}};b.prototype.handleSelectionChanged=function(e){if(this._viewport){this._updateSelection(this._viewport._viewStateManager);this._gizmoIndex=this._handleIndex=-1;}};b.prototype._getLevelingQuaternion=function(a,o){a.set(0,0,0,1);switch(this._coordinateSystem){case C.Local:a.setFromRotationMatrix(this._nodes[o].node.parent.matrixWorld);break;case C.Screen:a.copy(this._viewport.getCamera().getCameraRef().quaternion);break;case C.Custom:var c=this._getAnchorPoint();if(c){a.copy(c.quaternion);}break;default:break;}return false;};b.prototype._getObjectSize=function(o){var a=new THREE.Box3();if(this._nodes.length===1){this._nodes[0].node._expandBoundingBox(a,true);}else if(this._coordinateSystem===C.Local){this._nodes[0].node._expandBoundingBox(a,true);}if(a.isEmpty()){return 0;}var s=new THREE.Vector3();a.getSize(s);return s.length();};b.prototype._updateGizmoTransformation=function(i,c){var s=this._updateGizmoObjectTransformation(this._gizmo,i);this._updateAxisTitles(this._axisTitles,this._gizmo,c,this._gizmoSize-18,s);};b.prototype._getEditingFormPosition=function(){var s=this._updateGizmoObjectTransformation(this._gizmo,this._gizmoIndex);var d=new THREE.Vector3().setFromMatrixColumn(this._gizmo.matrixWorld,this._handleIndex).normalize();return d.clone().multiplyScalar((this._gizmoSize-18)*s).add(this._gizmo.position).applyMatrix4(this._matViewProj);};b.prototype.render=function(){if(this._nodes.length>0){var r=this._viewport.getRenderer(),c=this._viewport.getCamera().getCameraRef();this._matViewProj.multiplyMatrices(c.projectionMatrix,c.matrixWorldInverse);r.clearDepth();for(var i=0,l=this.getGizmoCount();i<l;i++){this._updateGizmoTransformation(i,c);r.render(this._sceneGizmo,c);}}this._updateEditingForm(this._nodes.length>0&&this._gizmoIndex>=0&&this._handleIndex>=0&&this._handleIndex<3,this._handleIndex);};return b;});
