sap.ui.define(["sap/base/Log","./CallbackHandler","./TotaraUtils","./GeometryFactory","./ProgressCounter","./RequestQueue"],function(L,C,T,G,P,R){"use strict";var S=function(s,p,l){this.root=null;this.onActiveCameraCallbacks=new C();this.onInitialSceneFinishedCallbacks=new C();this.onPartialRetrievalFinishedCallbacks=new C();this.onSceneCompletedCallbacks=new C();this.onSetPlaybackCallbacks=new C();this.onViewFinishedCallbacks=new C();this.onViewPartialRetrievalFinishedCallbacks=new C();this.onViewGroupFinishedCallbacks=new C();Object.assign(this,p);this.sceneId=s;this.loader=l;this.sceneBuilder=l.sceneBuilder;this.requestQueue=new R(this,s);this.phase=S.Phase.Started;this.retrievalType=S.RetrievalType.Initial;this.rootNodeId=null;this.annotationNodeMap=new Map();this.leaderLineMaterialIdMap=new Map();this.imageNoteMaterialIdMap=new Map();this.thumbnailViewMap=new Map();this.viewThumbnailMap=new Map();this.viewAnimatedThumbnailMap=new Map();this.texturesToUpdate=new Map();this.geometryIdMaterialIdMap=new Map();this.progressCount=new P();this.treeNodes=[];this.viewIdTreeNodesMap=new Map();this.nodeSidsForPartialTree=new Set();this.replacedNodes=new Map();this.updatedNodes=new Set();this.authorizationHandler=null;this.currentViewId=null;this.initialViewId=null;this.initialViewDecided=false;};S.Phase={Started:0,FinishedHierarchy:1,FinishedMesh:2,FinishedGeometry:3};S.RetrievalType={Initial:0,Partial:1};S.prototype.setOnProgressChanged=function(c){this.progressCount.setOnProgressChanged(c);};S.prototype.isLoadingFinished=function(){if(!this.requestQueue.isEmpty()||this.requestQueue.isWaitingForContent()||this.texturesToUpdate.size>0||this.thumbnailViewMap.size>0||this.viewThumbnailMap.size>0||this.viewAnimatedThumbnailMap.size>0||this.annotationNodeMap.size>0||this.leaderLineMaterialIdMap.size>0||this.imageNoteMaterialIdMap.size>0||this.viewIdTreeNodesMap.size>0||this.nodeSidsForPartialTree.size>0){return false;}return true;};S.prototype.isSceneCompleted=function(){return!this.requestQueue.meshes.isWaiting()&&!this.requestQueue.materials.isWaiting()&&!this.requestQueue.geomMeshes.isWaiting()&&!this.requestQueue.geometries.isWaiting()&&!this.requestQueue.images.isWaiting();};S.prototype._checkSceneCompletion=function(){if(this.isSceneCompleted()){this.sceneBuilder.finalizeHighlightsInViews();this.onSceneCompletedCallbacks.execute();L.info("Scene completed.");T.mark("sceneCompleted");this.logPerformance("sceneCompleted");}};S.prototype.dispose=function(){this.sceneId=null;this.progressCount=null;this.requestQueue=null;this.suppressedBoundingBoxListMap=null;this.treeNodes=null;this.nodeSidsForPartialTree=null;this.annotationNodeMap=null;this.leaderLineMaterialIdMap=null;this.imageNoteMaterialIdMap=null;this.thumbnailViewMap=null;this.viewThumbnailMap=null;this.viewAnimatedThumbnailMap=null;this.texturesToUpdate=null;this.geometryIdMaterialIdMap=null;this.replacedNodes=null;this.updatedNodes=null;this.viewIdTreeNodesMap=null;this.onActiveCameraCallbacks=null;this.onInitialSceneFinishedCallbacks=null;this.onPartialRetrievalFinishedCallbacks=null;this.onViewPartialRetrievalFinishedCallbacks=null;this.onSceneCompletedCallbacks=null;this.onViewFinishedCallbacks=null;this.onSetPlaybackCallbacks=null;};S.prototype.logPerformance=function(n){if(this.progressLogger&&this.token){this.progressLogger.logPerformance(n,this.token);}};S.prototype.setCameraSingle=function(c){this.sceneBuilder.createCamera(c,this.sceneId);return this.sceneBuilder.getCamera(c.id);};S.prototype.getPartialTreeNodes=function(t){var p=[];var a=[];var i,j,b;if(t&&t.length){for(i=0;i<t.length;i++){b=t[i];if(b==null){continue;}if(b&&b.children){if(b.entityId!=null&&b.children.length===1){var r=b.children[0];var c=t[r];if(c.entityId==null){c.name=b.name;b.visualisable=false;}}if(b.children){for(j=0;j<b.children.length;j++){var d=b.children[j];t[d].parentNode=b;if(b.renderOrder){t[d].renderOrder=b.renderOrder;}}}}}}if(t&&t.length){for(i=0;i<t.length;i++){b=t[i];if(b==null){continue;}if(b.parent){p.push(b);}else if(!b.parentNode){p.push(b);if(this.rootNodeId){b.parent=this.rootNodeId;}}if(this.nodeSidsForPartialTree.has(b.sid)){a.push(b);}}}this.nodeSidsForPartialTree.clear();if(!a.length){return p;}p=[];for(j=0;j<a.length;j++){var n=a[j];var e=n.parentNode;while(e){if(this.sceneBuilder.getNode(e.sid,this.sceneId)){n.parent=e.sid;p.push(n);break;}else{n=e;e=e.parentNode;}}}return p.length?p:a;};S.prototype.buildTree=function(){var r={};if(!this.treeNodes||!this.treeNodes.length){r.error="no tree information";return r;}var t=this.treeNodes;var p=this.getPartialTreeNodes(t);this.replacedNodes.clear();var a=[];var i;var b;for(i=0;i<p.length;i++){b=p[i].parent;if(this.sceneBuilder.getNode(b,this.sceneId)){this.buildNode(p[i],b);}else{a.push(p[i]);}}for(i=0;i<a.length;i++){b=a[i].parent;if(this.sceneBuilder.getNode(b,this.sceneId)){this.buildNode(p[i],b);}else{r.error=(r.error||"")+"parent ${parentSid} does not exist in the scene. \n";}}this.treeNodes=[];this.progressCount.mesh.total=this.requestQueue.meshes.globalList.size;return r;};S.prototype.buildNode=function(t,p){if(!t||!p){this.loader.reportError(this,"SceneContext - buildNode - invalid args");return;}var e=this.sceneBuilder.getNode(t.sid,this.sceneId);if(e){this.sceneBuilder.remove(t.sid,this.sceneId);}if(t.suppressed===true){return;}if(!t.sid){this.loader.reportError(this,"sid is missing in treeNode");return;}t.parentId=p;this.sceneBuilder.createNode(t,this.sceneId);if(t.meshId&&!this.sceneBuilder.hasMesh(t.meshId)){this.requestQueue.meshes.push(t.meshId);}if(t.annotationId){this.annotationNodeMap.set(t.annotationId,t.sid);this.requestQueue.annotations.push(t.annotationId);}var n=this.sceneBuilder.getNode(t.sid,this.sceneId);if(e&&n){this.replacedNodes.set(e,n);}if(t.children){var a=this.treeNodes;for(var i=0;i<t.children.length;i++){var b=t.children[i];this.buildNode(a[b],t.sid);}}};S.prototype.setTree=function(j){if(j.sid){var r=this.sceneBuilder.getNode(j.sid,this.sceneId);if(!r||r!==this.root){var a=this.root;a.userData.treeNode={sid:j.sid,name:this.root.name?this.root.name:"root"};a.userData.skipIt=!this.root.name;this.sceneBuilder.setRootNode(a,j.sid,this.sceneId,this.vkScene);this.rootNodeId=j.sid;}}if(j.camera){j.camera.id="initial";var c=this.setCameraSingle(j.camera);if(c){this.onActiveCameraCallbacks.execute(c);}}T.measure("setTreeMeasure-"+this.sceneId,"setTree-"+this.sceneId);};S.prototype.setTreeNode=function(j){if(!Array.isArray(j.nodes)){return{error:"setTreeNode error: nodes are not properly defined"};}this.treeNodes=this.treeNodes.concat(j.nodes);return{};};S.prototype.notifyFinishedTree=function(c){this.buildTree();this.phase=S.Phase.FinishedHierarchy;if(!this.loader._pushMesh){if(!this.requestQueue.meshes.isWaiting()){if(this.retrievalType===S.RetrievalType.Initial){this.onInitialSceneFinishedCallbacks.execute(this.initialView);}if(this.retrievalType===S.RetrievalType.Partial){this.onPartialRetrievalFinishedCallbacks.execute();}this.onViewPartialRetrievalFinishedCallbacks.execute();this._checkSceneCompletion();}}return{};};S.prototype.setViewGroup=function(j){this.sceneBuilder.insertViewGroup(j,this.sceneId);if(!Array.isArray(j.views)){return;}var v=j.id;var i,a;if(!this.currentViewGroupId){if(this.currentViewId){for(i=0;i<j.views.length;i++){a=j.views[i];if(a.id===this.currentViewId){this.currentViewGroupId=v;break;}}}else{this.currentViewGroupId=v;}}if(this.currentViewGroupId!==v){return;}for(i=0;i<j.views.length;i++){a=j.views[i];var e=this.sceneBuilder.getView(a.id,this.sceneId);for(var t=0;t<1;t++){var p=["thumbnailId","animatedThumbnailId"][t];var b=a[p];if(b!==undefined){a[p]=b=b.toString();if(this.sceneBuilder.hasImage(b)){this.sceneBuilder.setViewThumbnail(b,a.id,this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();}else{this.thumbnailViewMap.set(b,a.id);this.requestQueue.images.push(b,{imageId:b,viewId:a.id});}if(!e){this[["viewThumbnailMap","viewAnimatedThumbnailMap"][t]].set(a.id,b);}}}if(e){e.userData.viewInfo.thumbnailId=a.thumbnailId;continue;}this.requestQueue.views.push(a.id,{viewId:a.id,viewGroupId:v});}if(!this.requestQueue.views.isWaiting()){this.sceneBuilder.finalizeViewGroups(this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();if(this.requestQueue.sequences.isEmpty()){this.onViewGroupFinishedCallbacks.execute();}this.sceneBuilder.finalizeHighlightsInViews();}T.measure("setViewGroupMeasure-"+v,"setViewGroup-"+v);};S.prototype.setView=function(j){var v=j.viewId;if(!v){this.setTree(j);this.initialViewDecided=true;return;}if(!this.initialViewId&&!this.initialViewDecided){this.initialViewId=v;this.currentViewId=v;this.initialViewDecided=true;}var c;if(this.initialViewId===v){if(j.camera){c=j.camera.id;}this.setTree(j);}var t=this.viewThumbnailMap.get(v);if(t){this.viewThumbnailMap.delete(v);j.thumbnailId=t;}var a=this.viewAnimatedThumbnailMap.get(v);if(a){this.viewAnimatedThumbnailMap.delete(v);j.animatedThumbnailId=a;}this.sceneBuilder.insertView(j,this.sceneId);var b=[];this.viewIdTreeNodesMap.set(v,b);if(j.camera){if(c){j.camera.id=c;}this.setCameraSingle(j.camera);this.sceneBuilder.setViewCamera(j.camera.id,v,this.sceneId);}this.logPerformance("setView");T.measure("setViewMeasure-"+v,"setView-"+v);};S.prototype.setViewNode=function(c){var r={context:this};if(!c.viewId){this.setTreeNode(c);return r;}if(this.initialViewId===c.viewId){this.setTreeNode(c);}var v=this.sceneBuilder.getView(c.viewId,c.sceneId);if(!v){r.error="setViewNode error: setViewNode - no setView was in the chain";return r;}if(this.initialViewId===c.viewId){this.initialView=v;}var t=this.viewIdTreeNodesMap.get(c.viewId);t=t.concat(c.nodes);this.viewIdTreeNodesMap.set(c.viewId,t);return r;};S.prototype.notifyFinishedView=function(j){var v=j.viewId;if(!v){return this.notifyFinishedTree(j);}this.requestQueue.views.pop(v);if(this.initialViewId===v){this.notifyFinishedTree(j);this.initialViewId=null;}var a=this.sceneBuilder.getView(v,this.sceneId);if(!a){return{error:"notifyFinishedView error: setViewNode - no setView was in the chain"};}if(a.activeCameraId!==undefined){a.camera=this.sceneBuilder.getCamera(a.activeCameraId);}this.updatedNodes.clear();var b=this.buildView(v);this.sceneBuilder.setViewNodeInfos(b.nodeInfos,v,this.sceneId);a.updatedNodes=Array.from(this.updatedNodes);if(!this.requestQueue.views.isWaiting()){this.sceneBuilder.finalizeViewGroups(this.sceneId);this.loader.onViewGroupUpdatedCallbacks.execute();if(this.requestQueue.sequences.isEmpty()){this.onViewGroupFinishedCallbacks.execute();}this.sceneBuilder.finalizeHighlightsInViews();}if(!this.requestQueue.meshes.isWaiting()){this.onViewFinishedCallbacks.execute(a);}else{var c=function(){setTimeout(function(){this.onViewPartialRetrievalFinishedCallbacks.detach(c);}.bind(this),0);this.onViewFinishedCallbacks.execute(a);}.bind(this);this.onViewPartialRetrievalFinishedCallbacks.attach(c);this.logPerformance("notifyFinishedView");}};S.prototype.buildView=function(v){var r={};this.treeNodes=this.viewIdTreeNodesMap.get(v);if(!this.treeNodes||!this.treeNodes.length){r.error="no tree information in view";return r;}var p=this.getPartialTreeNodes(this.treeNodes);var n=[];for(var i=0;i<p.length;i++){var a=p[i].parent;this.processNode(v,p[i],n,a);}r.nodeInfos=n;this.treeNodes=[];this.viewIdTreeNodesMap.delete(v);return r;};S.prototype.buildViewNode=function(v,t,n){if(!t){this.loader.reportError(this,"ViewBuilder - buildViewNode - invalid args");return;}var a=this.sceneBuilder.getNode(t.sid,this.sceneId);if(t.materialId){if(!this.sceneBuilder.checkMaterialExists(t.materialId,true)){this.requestQueue.materials.push(t.materialId);}}var b={target:a,visible:t.visible!==undefined?t.visible:true,materialId:t.materialId,opacity:t.opacity,meshId:t.meshId,transform:Array.isArray(t.transform)?T.arrayToColumnMajorMatrixArray16(t.transform):[1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0]};n.push(b);var c=this.treeNodes;var e=this.sceneBuilder.getChildNodeIds(t.sid,this.sceneId);var d=t.children?t.children.map(function(o){return c[o].sid;}):[];var f;var i;for(i=0;i<e.length;i++){f=e[i];for(var j=0;j<d.length;j++){if(f===d[j]){e[i]=undefined;break;}}}for(i=0;i<e.length;i++){var g=e[i];if(g!==undefined){var h=this.sceneBuilder.getNode(g,this.sceneId);var k=false;n.push({target:h,visible:k});}}if(t.children){for(i=0;i<t.children.length;i++){var l=t.children[i];var m=this.treeNodes[l];this.processNode(v,m,n,t.sid);}}};S.prototype.processNode=function(v,t,n,p){var a=this.sceneBuilder.getNode(t.sid,this.sceneId);if(a){this.buildViewNode(v,t,n);}else{this.buildNode(t,p);var b=this.sceneBuilder.getNode(t.sid,this.sceneId);if(b){b.visible=false;n.push({target:b,visible:t.visible===undefined?true:t.visible});}}if(t.highlightStyleId){this.sceneBuilder.recordHighlightedNodeInView(t.highlightStyleId,t.sid,v,this.sceneId);if(!this.sceneBuilder.highlightStyleExists(t.highlightStyleId)){this.requestQueue.highlights.push(t.highlightStyleId);}}};S.prototype.setAnnotationSingle=function(a){var n=this.annotationNodeMap.get(a.id);if(n){a.nodeId=n;if(a.detailView||a.cutaway){this.sceneBuilder.createDetailView(a,this.sceneId);}else if(a.labelMaterialId||(a.label&&a.label.materialId)){var m=a.labelMaterialId||a.label.materialId;if(this.sceneBuilder.checkMaterialExists(m,false)){this.sceneBuilder.createImageNote(a,this.sceneId);}else{this.requestQueue.materials.push(m);T.pushElementIntoMapArray(this.imageNoteMaterialIdMap,m,a);}}else{this.sceneBuilder.createAnnotation(a,this.sceneId);var b=a.leaderLines;if(b){for(var i=0,l=b.length;i<l;i++){var c=b[i];c.annotationId=a.id;if(this.sceneBuilder.checkMaterialExists(c.materialId,false)){this.sceneBuilder.insertLeaderLine(c,this.sceneId);}else{this.requestQueue.materials.push(c.materialId);T.pushElementIntoMapArray(this.leaderLineMaterialIdMap,c.materialId,{annotationId:a.id,leaderLine:c});}}}}this.annotationNodeMap.delete(a.id);this.requestQueue.annotations.pop(a.id);}};S.prototype.setCamera=function(j){if(!Array.isArray(j.cameras)){return{error:"setCamera error: cameras are not properly defined"};}j.cameras.forEach(this.setCameraSingle.bind(this));};S.prototype.setMeshSingle=function(m){var a=m.id;if(this.requestQueue.meshes.pop(a)){if(Array.isArray(m.submeshes)){var b=new THREE.Box3();var p=new THREE.Vector3();for(var i=0;i<m.submeshes.length;i++){var s=m.submeshes[i];s.meshId=a;if(!this.sceneBuilder.checkMaterialExists(s.materialId,true)){this.requestQueue.materials.push(s.materialId);}this.sceneBuilder.insertSubmesh(s);var l=s.lods;if(Array.isArray(l)){for(var c=0;c<l.length;c++){var d=l[c].boundingBox;if(Array.isArray(d)&&d.length===6){b.min.min(p.fromArray(d));b.max.max(p.fromArray(d,3));}}}}b.getSize(p);this.requestQueue.geomMeshes.push(a,p.length());}this.progressCount.mesh.count++;if(!this.requestQueue.meshes.isWaiting()){this.phase=S.Phase.FinishedMesh;this.logPerformance("meshFinished");if(this.retrievalType===S.RetrievalType.Initial){this.onInitialSceneFinishedCallbacks.execute(this.initialView);}else if(this.retrievalType===S.RetrievalType.Partial){this.onPartialRetrievalFinishedCallbacks.execute();}this.onViewPartialRetrievalFinishedCallbacks.execute();this.progressCount.geometry.total=this.requestQueue.geometries.globalList.size;}}else{this.requestQueue.geomMeshes.pop(a);}};S.prototype.setMesh=function(j,b){if(!Array.isArray(j.meshes)){return{error:"setMesh error: meshes are not properly defined"};}if(b){var d=new DataView(b.buffer);var a=d.getUint16(2,true),o=0;while(a-->0&&o<b.byteLength){var g={sceneId:this.sceneId,id:d.getUint32(o+4,true).toString(),box:[d.getFloat32(o+14,true),d.getFloat32(o+18,true),d.getFloat32(o+22,true),d.getFloat32(o+26,true),d.getFloat32(o+30,true),d.getFloat32(o+34,true)]};var c=d.getUint16(o+12,true);o+=38;if(c!==3){g.flags=d.getUint16(o,true);g.quality=d.getFloat32(o+4,true);g.pointCount=d.getUint16(o+8,true);g.elementCount=d.getUint16(o+10,true);o+=14;}var e=d.getUint32(o,true);var f=b.subarray(o+4,o+4+e);o+=e;this.setGeometry(g,f);}}j.meshes.forEach(this.setMeshSingle.bind(this));T.measure("setMeshMeasure-"+this.sceneId,"setMesh-"+this.sceneId);this._checkSceneCompletion();};S.prototype.setMaterialSingle=function(m){var a=m.id;this.requestQueue.materials.pop(a);var t=this.sceneBuilder.createMaterial(m);var b=this.sceneBuilder.getMaterial(a);if(!b.userData.idsOfImagesToRead){b.userData.idsOfImagesToRead=new Set();}else{b.userData.idsOfImagesToRead.clear();}if(t.length){for(var c=0;c<t.length;c++){var p=t[c];var d=this.texturesToUpdate;var e=d.get(p.imageId);if(!e){e=[];d.set(p.imageId,e);}e.push({textureType:p.textureType,materialId:a});if(!this.sceneBuilder.hasImage(p.imageId)){this.requestQueue.images.push(p.imageId,{imageId:p.imageId,materialId:a});b.userData.idsOfImagesToRead.add(p.imageId);}}}var i;var l=this.leaderLineMaterialIdMap.get(a);if(l){this.leaderLineMaterialIdMap.delete(a);for(i=0;i<l.length;i++){this.sceneBuilder.insertLeaderLine(l[i].leaderLine,this.sceneId);}}var f=this.imageNoteMaterialIdMap.get(a);if(f){this.imageNoteMaterialIdMap.delete(a);for(i=0;i<f.length;i++){this.sceneBuilder.createImageNote(f[i],this.sceneId);}}this.loader.onMaterialFinishedCallbacks.execute(a);};S.prototype.setMaterial=function(j){if(!Array.isArray(j.materials)){return{error:"setMaterial error: materials are not properly defined"};}j.materials.forEach(this.setMaterialSingle.bind(this));T.measure("setMaterialMeasure-"+this.sceneId,"setMaterial-"+this.sceneId);this._checkSceneCompletion();};S.prototype.setGeometry=function(j,b){var g=j.id;this.requestQueue.geometries.pop(g);if(j.data&&!b){b=T.base64ToUint8Array(j.data);}if(!b||b.length===0){return{error:"setGeometry error: no data for geometry "+g};}var a=G.getGeometryInfo(j,b);if(!a){return{error:"setGeometry error: failed to parse geometry "+g+" data"};}this.sceneBuilder.setGeometry(a);this.loader.onSetGeometryCallbacks.execute({id:g});if(!this.requestQueue.geometries.isWaiting()){this.phase=S.Phase.FinishedGeometry;this.logPerformance("geometryFinished");}this.progressCount.geometry.count++;T.measure("setGeometryMeasure-"+g,"setGeometry-"+g);this._checkSceneCompletion();};S.prototype.setImage=function(j,b){var a=j.id;var t=j.tileWidth;this.requestQueue.images.pop(a);if(!b){return{error:"setImage error: no image content for "+a};}j.binaryData=b;this.sceneBuilder.createImage(j);var v=this.thumbnailViewMap.get(a);if(v){this.thumbnailViewMap.delete(a);this.sceneBuilder.setViewThumbnail(a,v,this.sceneId,t);this.loader.onViewGroupUpdatedCallbacks.execute();}if(t){this.sceneBuilder._imageIdsAndTileWidths.set(a,t);}var c=this.texturesToUpdate.get(a);if(c){this.texturesToUpdate.delete(a);for(var i=0,l=c.length;i<l;i++){var d=c[i];this.sceneBuilder.updateTextureMap(d.materialId,d.textureType);}}this.loader.onImageFinishedCallbacks.execute({id:a});T.measure("setImageMeasure-"+a,"setImage-"+a);this._checkSceneCompletion();};S.prototype.setAnnotation=function(j){if(!Array.isArray(j.annotations)){return{error:"setAnnotation error: annotations are not properly defined"};}j.annotations.forEach(this.setAnnotationSingle.bind(this));};S.prototype.setHighlightStyle=function(j){this.sceneBuilder.insertHighlightStyle(j);this.requestQueue.highlights.pop(j.id);if(!this.requestQueue.highlights.isWaiting()){this.sceneBuilder.finalizeHighlightsInViews();}};S.prototype.setPlayback=function(a){if(!Array.isArray(a.playbacks)){return{error:"setPlayback error: playbacks are not properly defined"};}var v=this.sceneBuilder.getView(a.viewId,this.sceneId);var o=false;var i,p;if(this.playbackIds){for(i=0;i<a.playbacks.length;i++){p=a.playbacks[i];for(var j=0;j<this.playbackIds.length;j++){if(p.id===this.playbackIds[j]){p.notLoading=false;break;}}if(p.notLoading===undefined){p.notLoading=true;}}delete this.playbackIds;o=true;}for(i=0;i<a.playbacks.length;i++){p=a.playbacks[i];if(p.notLoading){continue;}if(p.id==null){p.id=a.viewId+"-playback";p.sequence.id=a.viewId+"-cont";p.sequenceId=p.sequence.id;this.setSequence({sequences:[p.sequence]});}this.sceneBuilder.insertPlayback(p,a.viewId,this.sceneId);if(p.sequenceId){var e=this.sceneBuilder.getSequence(p.sequenceId);if(e){continue;}else{this.requestQueue.sequences.push(p.sequenceId);}}}if(!this.requestQueue.sequences.isEmpty()){this.loader.hasAnimation=true;}else{this.sceneBuilder.finalizeAnimation();this.sceneBuilder.finalizePlaybacks();this.sceneBuilder.finalizeHighlightsInViews();this.loader.hasAnimation=false;if(o){this.onSetPlaybackCallbacks.execute(v);}}};S.prototype.setSequenceSingle=function(s){var a=s.id;this.requestQueue.sequences.pop(a);if(s.nodes){var n=[];var i=[];for(var b=0;b<s.nodes.length;b++){var c=s.nodes[b];if(c.rotate){var r={};if(c.rotate.trackId){r.trackId=c.rotate.trackId;this.requestQueue.tracks.push(c.rotate.trackId);}else{r.trackId=a+"ROTATE"+c.sid;c.rotate.id=r.trackId;i.push(c.rotate);}r.sid=c.sid;r.binding="ROTATE";if(c.rotate.pivot){r.pivot=c.rotate.pivot;}n.push(r);}if(c.translate){var t={};if(c.translate.trackId){t.trackId=c.translate.trackId;this.requestQueue.tracks.push(c.translate.trackId);}else{t.trackId=a+"TRANSLATE"+c.sid;c.translate.id=t.trackId;i.push(c.translate);}t.sid=c.sid;t.binding="TRANSLATE";if(c.translate.pivot){t.pivot=c.translate.pivot;}n.push(t);}if(c.scale){var d={};if(c.scale.trackId){d.trackId=c.scale.trackId;this.requestQueue.tracks.push(c.scale.trackId);}else{d.trackId=a+"SCALE"+c.sid;c.scale.id=d.trackId;i.push(c.scale);}d.sid=c.sid;d.binding="SCALE";if(c.scale.pivot){d.pivot=c.scale.pivot;}n.push(d);}if(c.opacity){var o={};if(c.opacity.trackId){o.trackId=c.opacity.trackId;this.requestQueue.tracks.push(c.opacity.trackId);}else{o.trackId=a+"OPACITY"+c.sid;c.opacity.id=o.trackId;i.push(c.opacity);}o.sid=c.sid;o.binding="OPACITY";n.push(o);}}if(i.length>0){this.setTrack({tracks:i});}s.nodes=n;}this.sceneBuilder.insertSequence(s);};S.prototype.setSequence=function(j){if(!Array.isArray(j.sequences)){return{error:"setSequence error: sequences are not properly defined"};}j.sequences.forEach(this.setSequenceSingle.bind(this));if(this.requestQueue.tracks.isEmpty()){this.loader.hasAnimation=false;this.loader.onSetSequenceCallbacks.execute();if(!this.requestQueue.views.isWaiting()){this.onViewGroupFinishedCallbacks.execute();}}};S.prototype.setTrack=function(j){if(!Array.isArray(j.tracks)){return{error:"setTrack error: tracks are not properly defined"};}var t=[];for(var a=0;a<j.tracks.length;a++){var b=j.tracks[a];this.requestQueue.tracks.pop(b.id);b.times=b.time;if(b.vector3){b.values=b.vector3;}else if(b.quaternion){b.values=b.quaternion;b.rotateType="quaternion";for(var v=3;v<b.values.length;v=v+4){b.values[v]=-b.values[v];}}else if(b.angleAxis){b.values=b.angleAxis;b.rotateType="angleAxis";}else if(b.euler){b.values=b.euler;b.rotateType="euler";}else if(b.scalar){b.values=b.scalar;}b.cyclicInfo={};b.cyclicInfo.cyclicStart=b.cyclicStart;b.cyclicInfo.cyclicEnd=b.cyclicEnd;t.push(b);}this.sceneBuilder.insertTracks(t);if(!this.requestQueue.tracks.isWaiting()){this.sceneBuilder.finalizeAnimation();this.sceneBuilder.finalizePlaybacks();this.sceneBuilder.finalizeHighlightsInViews();this.loader.onSetTrackCallbacks.execute();if(!this.requestQueue.views.isWaiting()&&!this.requestQueue.sequences.isWaiting()){this.onViewGroupFinishedCallbacks.execute();}}};S.prototype.notifyError=function(j){if(!j.error){j.error="Unknown error";}return j;};return S;});
