/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)
 *  (C) 2016 SAP SE or an SAP affiliate company. All rights reserved.
 */

var sap = sap || {};
sap.ve = sap.ve || {};
sap.ve.dvl = sap.ve.dvl || {};
sap.ve.dvl.createRuntime = function(options) {
	return new Promise(function(resolve, reject) {
		function createModule(options) {
			// Emscripten module definition begins here. It ends in module_end.js.

			var mergeOption = function(optionName, defaultOptionValue) {
				if (!options) {
					return defaultOptionValue;
				}
				return typeof options[optionName] === "undefined" ? defaultOptionValue : options[optionName];
			};

			// Merge any input options with defaults.
			var mergedOptions = {
				totalMemory:          mergeOption("totalMemory",          128 * 1024 * 1024), // 128 MB
				logElementId:         mergeOption("logElementId",         null),
				statusElementId:      mergeOption("statusElementId",      null),
				prefixURL:            mergeOption("filePackagePrefixURL", "")
			};

			//Create initial Module object with defaults
			var Module = {
				TOTAL_MEMORY: mergedOptions.totalMemory,
				prefixURL: mergedOptions.prefixURL,
				preInit: [],
				postRun: [],
				totalDependencies: 0,
				monitorRunDependencies: null,
				noInitialRun: true,
				noFSInit: true, // NB: Do not initialize standard streams (a workaround for cases when a file is opened before standard streams are initialized).
				print: function() {
					var args = Array.prototype.slice.call(arguments);
					var text = args.join(" ");
					if (mergedOptions.logElementId) {
						var element = document.getElementById(mergedOptions.logElementId);
						element.value += text + "\n";
						element.scrollTop = 99999;
					} else if (window.console) {
						console.log("print: " + text);
					}
				},
				printf: function() {
					var args = Array.prototype.slice.call(arguments);
					args.push("(printf)");
					Module.print(args);
				},
				printErr: function() {
					var args = Array.prototype.slice.call(arguments);
					args.push("(printErr)");
					Module.print(args);
				},
				// setStatus is called from Emscripten libraries.
				setStatus: function(text) {
					if (mergedOptions.statusElementId) {
						if (Module.setStatus.interval) {
							clearInterval(Module.setStatus.interval);
						}
						var statusElement = document.getElementById(mergedOptions.statusElementId);
						statusElement.innerHTML = text;
					} else if (Module.logElementId) {
						var args = Array.prototype.slice.call(arguments);
						args.push("(setStatus)");
						Module.print(args);
					}
				},
				locateFile: function(path, scriptDirectory) {
					return this.prefixURL + path;
				}
			};

			// NB: Emscripten generated code will be inserted after this line.

var Module=typeof Module!=="undefined"?Module:{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}Module["arguments"]=[];Module["thisProgram"]="./this.program";Module["quit"]=(function(status,toThrow){throw toThrow});Module["preRun"]=[];Module["postRun"]=[];var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}else{return scriptDirectory+path}}if(ENVIRONMENT_IS_NODE){scriptDirectory=__dirname+"/";var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){var ret;ret=tryParseAsDataURI(filename);if(!ret){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);ret=nodeFS["readFileSync"](filename)}return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));process["on"]("unhandledRejection",(function(reason,p){process["exit"](1)}));Module["quit"]=(function(status){process["exit"](status)});Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(typeof read!="undefined"){Module["read"]=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}Module["readBinary"]=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WEB){if(document.currentScript){scriptDirectory=document.currentScript.src}}else{scriptDirectory=self.location.href}if(scriptDirectory.indexOf("blob:")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf("/")+1)}else{scriptDirectory=""}Module["read"]=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)};Module["setWindowTitle"]=(function(title){document.title=title})}else{}var out=Module["print"]||(typeof console!=="undefined"?console.log.bind(console):typeof print!=="undefined"?print:null);var err=Module["printErr"]||(typeof printErr!=="undefined"?printErr:typeof console!=="undefined"&&console.warn.bind(console)||out);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var STACK_ALIGN=16;function staticAlloc(size){var ret=STATICTOP;STATICTOP=STATICTOP+size+15&-16;return ret}function dynamicAlloc(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=ret+size+15&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}function alignMemory(size,factor){if(!factor)factor=STACK_ALIGN;var ret=size=Math.ceil(size/factor)*factor;return ret}function getNativeTypeSize(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return 4}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}function warnOnce(text){if(!warnOnce.shown)warnOnce.shown={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;err(text)}}var jsCallStartIndex=1;var functionPointers=new Array(0);function addFunction(func,sig){var base=0;for(var i=base;i<base+0;i++){if(!functionPointers[i]){functionPointers[i]=func;return jsCallStartIndex+i}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}var funcWrappers={};function dynCall(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}var GLOBAL_BASE=8;var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];assert(func,"Cannot call unknown function "+ident+", make sure it is exported");return func}var JSfuncs={"stackSave":(function(){stackSave()}),"stackRestore":(function(){stackRestore()}),"arrayToC":(function(arr){var ret=stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};function ccall(ident,returnType,argTypes,args,opts){function convertReturnValue(ret){if(returnType==="string")return Pointer_stringify(ret);if(returnType==="boolean")return Boolean(ret);return ret}var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);ret=convertReturnValue(ret);if(stack!==0)stackRestore(stack);return ret}function cwrap(ident,returnType,argTypes,opts){argTypes=argTypes||[];var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs&&!opts){return getCFunc(ident)}return(function(){return ccall(ident,returnType,argTypes,arguments,opts)})}function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for getValue: "+type)}return null}var ALLOC_NORMAL=0;var ALLOC_STATIC=2;var ALLOC_NONE=4;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:staticAlloc,stackAlloc,staticAlloc,dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var stop;ptr=ret;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function getMemory(size){if(!staticSealed)return staticAlloc(size);if(!runtimeInitialized)return dynamicAlloc(size);return _malloc(size)}function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return UTF8ToString(ptr)}var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|u1&1023}if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function allocateUTF8(str){var size=lengthBytesUTF8(str)+1;var ret=_malloc(size);if(ret)stringToUTF8Array(str,HEAP8,ret,size);return ret}function demangle(func){return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}var PAGE_SIZE=16384;var WASM_PAGE_SIZE=65536;var ASMJS_PAGE_SIZE=16777216;var MIN_TOTAL_MEMORY=16777216;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}if(!Module["reallocBuffer"])Module["reallocBuffer"]=(function(size){var ret;try{var oldHEAP8=HEAP8;ret=new ArrayBuffer(size);var temp=new Int8Array(ret);temp.set(oldHEAP8)}catch(e){return false}var success=_emscripten_replace_memory(ret);if(!success)return false;return ret});function enlargeMemory(){var PAGE_MULTIPLE=Module["usingWasm"]?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE;var LIMIT=2147483648-PAGE_MULTIPLE;if(HEAP32[DYNAMICTOP_PTR>>2]>LIMIT){return false}var OLD_TOTAL_MEMORY=TOTAL_MEMORY;TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);while(TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2]){if(TOTAL_MEMORY<=536870912){TOTAL_MEMORY=alignUp(2*TOTAL_MEMORY,PAGE_MULTIPLE)}else{TOTAL_MEMORY=Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=Module["reallocBuffer"](TOTAL_MEMORY);if(!replacement||replacement.byteLength!=TOTAL_MEMORY){TOTAL_MEMORY=OLD_TOTAL_MEMORY;return false}updateGlobalBuffer(replacement);updateGlobalBufferViews();return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;if(TOTAL_MEMORY<TOTAL_STACK)err("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}Module["buffer"]=buffer}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var dataURIPrefix="data:application/octet-stream;base64,";function isDataURI(filename){return String.prototype.startsWith?filename.startsWith(dataURIPrefix):filename.indexOf(dataURIPrefix)===0}var ASM_CONSTS=[(function($0){jDVLClient_Constructor(Pointer_stringify($0));return 0}),(function($0){console.log("DVLRESULT",$0)}),(function($0){console.log("DVLRESULT",$0)}),(function($0){console.log("SetDynamicLabel",$0)}),(function($0,$1){var canvas=window.jDVLDynamicLabelPOIIconCanvas;var id=canvas.getContext("2d").getImageData(0,0,canvas.width,canvas.height);var p=$0;var n=$1;for(var i=0;i<n;++i)setValue(p++,id.data[i],"i8");return DvlEnums.DVLRESULT.OK}),(function($0){jDVLClient_Destructor(Pointer_stringify($0));return 0}),(function($0,$1,$2){jDVLClient_NotifySceneGeometryFailed(Pointer_stringify($0),Pointer_stringify($1),$2);return 0}),(function($0,$1){jDVLClient_NotifySceneGeometryLoaded(Pointer_stringify($0),Pointer_stringify($1));return 0}),(function($0){return jDVLClient_RequestCallback($0)}),(function($0,$1){jDVLClient_NotifyFrameFinished(Pointer_stringify($0),Pointer_stringify($1));return 0}),(function($0,$1){jDVLClient_NotifyFrameStarted(Pointer_stringify($0),Pointer_stringify($1));return 0}),(function($0,$1){return jDVLClient_NotifyFileLoadProgress(Pointer_stringify($0),$1)}),(function($0,$1,$2){jDVLClient_OnUrlClick(Pointer_stringify($0),Pointer_stringify($1),Pointer_stringify($2));return 0}),(function($0,$1,$2){jDVLClient_OnStepEvent(Pointer_stringify($0),$1,Pointer_stringify($2));return 0}),(function($0,$1,$2,$3){jDVLClient_LogMessage(Pointer_stringify($0),$1,Pointer_stringify($2),Pointer_stringify($3));return 0}),(function($0,$1,$2,$3,$4){jDVLClient_OnNodeVisibilityChanged(Pointer_stringify($0),Pointer_stringify($1),Pointer_stringify($2),$3,Pointer_stringify($4));return 0}),(function($0,$1,$2,$3,$4){jDVLClient_OnNodeSelectionChanged(Pointer_stringify($0),Pointer_stringify($1),$2,Pointer_stringify($3),Pointer_stringify($4));return 0}),(function($0,$1,$2,$3){var text=Pointer_stringify($0);var sceneId=Pointer_stringify($1);var mode3D=$2;var dpr=window.devicePixelRatio;var dpi=96*dpr;var poiIconImage=Pointer_stringify($3);var poiIconSize="64,64";if(window.DOMParser){var parser=new DOMParser;xmlDoc=parser.parseFromString(text,"text/xml")}else{xmlDoc=new ActiveXObject("Microsoft.XMLDOM");xmlDoc.async=false;xmlDoc.loadXML(text)}if(!xmlDoc)return DvlEnums.DVLRESULT.NOINTERFACE;var errors=xmlDoc.getElementsByTagName("parsererror");if(errors.length>0){for(var ei=0;ei<errors.length;++ei)console.log(errors[ei].innerText);return DvlEnums.DVLRESULT.BADFORMAT}if(xmlDoc.childNodes.length==0||xmlDoc.childNodes[0].nodeName!="dynamic-labels")return DvlEnums.DVLRESULT.BADARG;if(!window.hasOwnProperty("DynamicLabels"))window.DynamicLabels=[];var DynamicLabels=window.DynamicLabels;var root=xmlDoc.childNodes[0];var poiColors=[];var labelCrop=root.getAttribute("label-crop");labelCrop=labelCrop?!(labelCrop.toLowerCase()=="false"||parseInt(labelCrop)==0):true;console.log("label-crop",labelCrop);for(var ni=0;ni<root.childNodes.length;++ni){var node=root.childNodes[ni];if(node.nodeName=="dynamic-label"){var o={};o.id=node.getAttribute("id");o.name=node.getAttribute("name");o.image=node.getAttribute("image");o.text=node.getAttribute("text");o.font=node.getAttribute("font");o.fontSize=node.getAttribute("font-size");o.textColor=node.getAttribute("text-color");o.bgColor=node.getAttribute("bg-color");o.frameColor=node.getAttribute("frame-color");o.opacity=node.getAttribute("opacity");o.size=node.getAttribute("size");o.pos=node.getAttribute("position");o.pivotPoint=node.getAttribute("pivot-point");o.margin=node.getAttribute("margin");o.alignment=node.getAttribute("alignment");o.poiColorIndex=node.getAttribute("poi-color");o.size=(o.size?o.size:"_").split(",").map(Number);if(isNaN(o.size[0])||isNaN(o.size[1])){if(mode3D){o.size[0]=4;o.size[1]=3}else{o.size[0]=1;o.size[1]=1}}if(o.size[0]<=0||o.size[1]<=0)continue;o.pos=(o.pos?o.pos:"0,0").split(",").map(Number);if(isNaN(o.pos[0])||isNaN(o.pos[1])){o.pos[0]=0;o.pos[1]=0}o.pivotPoint=(o.pivotPoint?o.pivotPoint:"0.5,0.5").split(",").map(Number);if(isNaN(o.pivotPoint[0])||isNaN(o.pivotPoint[1])){o.pivotPoint[0]=.5;o.pivotPoint[1]=.5}o.margin=(o.margin?o.margin:"0,0").split(",").map(Number);if(isNaN(o.margin[0])||isNaN(o.margin[1])){o.margin[0]=0;o.margin[1]=0}o.alignment=(o.alignment?o.alignment:"0,0").split(",").map((function(value){return parseInt(value,10)}));if(isNaN(o.alignment[0])||isNaN(o.alignment[1])){o.alignment[0]=0;o.alignment[1]=0}o.fontSize=o.fontSize?parseFloat(o.fontSize):12;if(isNaN(o.fontSize)||o.fontSize<4)o.fontSize=4;if(o.textColor)o.textColor="#"+o.textColor;if(o.bgColor)o.bgColor="#"+o.bgColor;if(o.frameColor)o.frameColor="#"+o.frameColor;if(o.opacity)o.opacity=parseFloat(o.opacity);o.poiColorIndex=o.poiColorIndex?parseInt(o.poiColorIndex):0;o.poiColor=o.poiColorIndex<poiColors.length?poiColors[o.poiColorIndex]:4294967295;o.fontSize*=dpr;o.margin[0]=Math.ceil(o.margin[0]*dpr);o.margin[1]=Math.ceil(o.margin[1]*dpr);if(mode3D){o.size[0]=Math.ceil(o.size[0]*dpi/2.54);o.size[1]=Math.ceil(o.size[1]*dpi/2.54);if(labelCrop&&!o.image&&o.text&&o.fontSize>0){var borderThickness=Math.ceil(2*dpr);var maxWidth=o.size[0]-(o.margin[0]+borderThickness)*2;var maxHeight=o.size[1]-(o.margin[1]+borderThickness)*2;if(maxWidth>0||maxHeight>0){var rowHeight=Math.ceil(o.fontSize*96/72);var rows=o.text.split("\n");var numRows=Math.min(rows.length,maxHeight/rowHeight|0);if(numRows>0){var canvas=document.createElement("canvas");canvas.id="jDVLDynamicLabelCanvas";canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=maxWidth;canvas.height=maxHeight;var ctx=canvas.getContext("2d");ctx.font=o.fontSize+"pt "+(o.font?o.font:"Arial");o.size[0]=0;o.size[1]=Math.ceil(numRows*rowHeight+(o.margin[1]+borderThickness)*2);for(var i=0;i<numRows;i++){var rowText=rows[i];while(ctx.measureText(rowText).width>maxWidth&&rowText.length>0)rowText=rowText.substr(0,rowText.length-1);if(rowText.length<rows[i].length)rowText=rowText.substr(0,rowText.length-3)+"...";o.size[0]=Math.max(o.size[0],ctx.measureText(rowText).width)}o.size[0]=Math.ceil(o.size[0]+(o.margin[0]+borderThickness)*2);delete canvas}}}}var index=-1;if(o.text!==null&&o.text!==undefined||o.opacity>0){index=DynamicLabels.length;for(var ti=0;ti<DynamicLabels.length;++ti){if(typeof DynamicLabels[ti]=="undefined"){index=ti;break}}}index=Module.ccall("jDVLScene_SetDynamicLabel","number",["string","string","string","number","number","number","number","number","number","number","number","number"],[sceneId,o.id,o.name,index,o.size[0],o.size[1],o.pos[0],o.pos[1],o.pivotPoint[0],o.pivotPoint[1],o.poiColorIndex,o.poiColor]);if(index>=0)DynamicLabels[index]=o;if(o.image&&index>=0){var image=document.createElement("img");image.sceneId=sceneId;image.index=index;image.dynamicLabel=o;image.id="img_"+Math.random().toString(36).substr(2,9);image.style.visibility="hidden";image.style.display="none";image.onerror=(function(){console.log("jDVL: Error loading image for texture.");DynamicLabels[this.index].image=null;Module.ccall("jDVLScene_UpdateDynamicLabel","number",["string","number"],[this.sceneId,this.index])});image.onload=(function(){console.log("UpdateDynamicLabel",this.index,this.width+"x"+this.height);Module.ccall("jDVLScene_UpdateDynamicLabel","number",["string","number"],[this.sceneId,this.index])});image.src="data:image/png;base64,"+o.image;o.image=image}}else if(node.nodeName=="poi-color"){if(node.textContent){var c=parseInt(node.textContent,16);if(!isNaN(c))poiColors.push(c|4278190080)}}else if(node.nodeName=="poi-icon"){poiIconImage=node.getAttribute("image");poiIconSize=node.getAttribute("size")}}if(poiIconImage){var image=document.createElement("img");image.sceneId=sceneId;image.iconSize=poiIconSize;image.id="img_"+Math.random().toString(36).substr(2,9);image.style.visibility="hidden";image.style.display="none";image.onerror=(function(){console.log("jDVL: Error loading image for POI icon.");Module.ccall("jDVLScene_SetPOIIcon","number",["string","number","number","number","number"],[this.sceneId,0,0,0,0])});image.onload=(function(){console.log("POI icon image size",this.width+"x"+this.height);var size=(this.iconSize?this.iconSize:"_").split(",").map(Number);if(isNaN(size[0])||isNaN(size[1])){size[0]=this.width;size[1]=this.height}console.log("POI icon size",size[0]+"x"+size[1]);size[0]*=dpr;size[1]*=dpr;var canvas=window.jDVLDynamicLabelPOIIconCanvas=document.createElement("canvas");canvas.id="jDVLDynamicLabelPOIIconCanvas";canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=Math.pow(2,Math.round(Math.log(size[0])/Math.LN2));canvas.height=Math.pow(2,Math.round(Math.log(size[1])/Math.LN2));console.log("POI icon texture size",canvas.width+"x"+canvas.height);document.body.appendChild(canvas);canvas.getContext("2d").drawImage(this,0,0,this.width,this.height,0,0,canvas.width,canvas.height);Module.ccall("jDVLScene_SetPOIIcon","number",["string","number","number","number","number"],[this.sceneId,size[0],size[1],canvas.width,canvas.height]);document.body.removeChild(canvas);delete window.jDVLDynamicLabelPOIIconCanvas});image.src="data:image/png;base64,"+poiIconImage;window.POIIconImage=image}console.log(DynamicLabels);return DvlEnums.DVLRESULT.OK}),(function($0,$1,$2){var js1=encodeURIComponent(escape(Pointer_stringify($0)));var js2=encodeURIComponent(escape(Pointer_stringify($1)));if($2){js1=js1.toLocaleUpperCase();js2=js2.toLocaleUpperCase()}return js1.localeCompare(js2)}),(function($0,$1,$2){var js1=encodeURIComponent(escape(Pointer_stringify($0)));var js2=encodeURIComponent(escape(Pointer_stringify($1)));if($2){js1=js1.toLocaleUpperCase();js2=js2.toLocaleUpperCase()}return js1.indexOf(js2)>=0}),(function($0,$1,$2){var js1=encodeURIComponent(escape(Pointer_stringify($0)));var js2=encodeURIComponent(escape(Pointer_stringify($1)));if($2){js1=js1.toLocaleUpperCase();js2=js2.toLocaleUpperCase()}return js1.indexOf(js2)==0}),(function($0,$1,$2){var jspattern=new RegExp(encodeURIComponent(escape(Pointer_stringify($0))));var jstext=encodeURIComponent(escape(Pointer_stringify($1)));return $2?jspattern.exec(jstext)==jstext:jspattern.test(jstext)}),(function($0,$1,$2,$3){var p=$0;var w=$1;var h=$2;var n=w*h*4;var canvasId=Pointer_stringify($3);var canvas=document.getElementById(canvasId);var id=canvas.getContext("2d").getImageData(0,0,w,h);for(var i=0;i<n;++i)setValue(p++,id.data[i],"i8");return DvlEnums.DVLRESULT.OK}),(function($0,$1,$2,$3){var image=document.createElement("img");image.bitmap=Pointer_stringify($0);image.maxSize=$3;image.id="img_"+Math.random().toString(36).substr(2,9);image.style.visibility="hidden";image.style.display="none";image.onerror=(function(){console.log("jDVL: Error loading image for texture."+" ("+(new Date).getTime()+")")});image.onload=(function(){var width=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2));var height=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));width=Math.min(width,this.maxSize);height=Math.min(height,this.maxSize);console.log("image.onload: bitmap='"+image.bitmap+"' "+this.width+"x"+this.height+" -> "+width+"x"+height);var canvas=document.createElement("canvas");canvas.id="jDVLBitmapCanvas-"+Math.random().toString(36).substr(2,9);canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=width;canvas.height=height;document.body.appendChild(canvas);var ctx=canvas.getContext("2d");ctx.imageSmoothingQuality="high";ctx.drawImage(this,0,0,this.width,this.height,0,0,canvas.width,canvas.height);Module.ccall("jDVLBitmap_CreateTexture","null",["string","string","number","number"],[this.bitmap,canvas.id,canvas.width,canvas.height]);document.body.removeChild(canvas);delete canvas});image.src="data:image/"+Pointer_stringify($2)+";base64,"+Pointer_stringify($1);return DvlEnums.DVLRESULT.OK}),(function($0){delete window.DynamicLabels[$0]}),(function($0,$1,$2,$3,$4,$5,$6){console.log("DynamicLabel::Draw:",$0,$3+"x"+$4);var canvas=window.jDVLDynamicLabelCanvas;var ctx=canvas.getContext("2d");var dl=window.DynamicLabels[$0];var image=dl.image;var dpr=window.devicePixelRatio;var cr=$5*dpr;var ft=Math.ceil($6*dpr);if(image){ctx.globalAlpha=dl.opacity?dl.opacity:1;if(image.width>0&&image.height>0&&ctx.globalAlpha>0){cr=0;var iw=$3;var ih=$4;if(iw*image.height>ih*image.width)iw=ih*image.width/image.height;else ih=iw*image.height/image.width;ctx.drawImage(image,0,0,image.width,image.height,$1+($3-iw)*.5,$2+($4-ih)*.5,iw,ih)}}else if(dl.bgColor||dl.opacity){ctx.globalAlpha=dl.opacity?dl.opacity:.5;if(ctx.globalAlpha>0){ctx.fillStyle=dl.bgColor?dl.bgColor:"#000000";if(cr>0){var x=$1;var y=$2;var w=$3;var h=$4;ctx.beginPath();ctx.moveTo(x+cr,y);ctx.lineTo(x+w-cr,y);ctx.quadraticCurveTo(x+w,y,x+w,y+cr);ctx.lineTo(x+w,y+h-cr);ctx.quadraticCurveTo(x+w,y+h,x+w-cr,y+h);ctx.lineTo(x+cr,y+h);ctx.quadraticCurveTo(x,y+h,x,y+h-cr);ctx.lineTo(x,y+cr);ctx.quadraticCurveTo(x,y,x+cr,y);ctx.closePath();ctx.fill()}else ctx.fillRect($1,$2,$3,$4)}}ctx.globalAlpha=1;if(dl.frameColor){ctx.strokeStyle=dl.frameColor;for(var i=0;i<ft;i++){var x=$1+.5+i;var y=$2+.5+i;var w=$3-1-i*2;var h=$4-1-i*2;if(cr>0){var r=cr-i;ctx.beginPath();ctx.moveTo(x+r,y);ctx.lineTo(x+w-r,y);ctx.quadraticCurveTo(x+w,y,x+w,y+r);ctx.lineTo(x+w,y+h-r);ctx.quadraticCurveTo(x+w,y+h,x+w-r,y+h);ctx.lineTo(x+r,y+h);ctx.quadraticCurveTo(x,y+h,x,y+h-r);ctx.lineTo(x,y+r);ctx.quadraticCurveTo(x,y,x+r,y);ctx.closePath();ctx.stroke()}else ctx.strokeRect(x,y,w,h)}}if(dl.text&&dl.fontSize>0){var maxWidth=$3-(dl.margin[0]+ft)*2;var maxHeight=$4-(dl.margin[1]+ft)*2;if(maxWidth<=0||maxHeight<=0)return DvlEnums.DVLRESULT.OK;var rowHeight=Math.ceil(dl.fontSize*96/72);var rows=dl.text.split("\n");var numRows=Math.min(rows.length,maxHeight/rowHeight|0);if(numRows<=0)return DvlEnums.DVLRESULT.OK;ctx.font=dl.fontSize+"pt "+(dl.font?dl.font:"Arial");ctx.fillStyle=dl.textColor?dl.textColor:"#FFFFFF";var posX=$1+dl.margin[0]+ft;var posY=$2+dl.margin[1]+ft;switch(dl.alignment[0]){default:case 0:ctx.textAlign="left";break;case 1:ctx.textAlign="center";posX+=maxWidth/2;break;case 2:ctx.textAlign="right";posX+=maxWidth;break}switch(dl.alignment[1]){default:case 0:ctx.textBaseline="top";break;case 1:ctx.textBaseline="middle";posY+=(maxHeight-(numRows-1)*rowHeight)*.5;break;case 2:ctx.textBaseline="bottom";posY+=maxHeight-(numRows-1)*rowHeight;break}for(var i=0;i<numRows;i++){var rowText=rows[i];while(ctx.measureText(rowText).width>maxWidth&&rowText.length>0)rowText=rowText.substr(0,rowText.length-1);if(rowText.length<rows[i].length)rowText=rowText.substr(0,rowText.length-3)+"...";ctx.fillText(rowText,posX,posY);posY+=rowHeight}}return DvlEnums.DVLRESULT.OK}),(function($0,$1){var canvas=window.jDVLDynamicLabelCanvas=document.createElement("canvas");canvas.id="jDVLDynamicLabelCanvas";canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=$0;canvas.height=$1;document.body.appendChild(canvas);return DvlEnums.DVLRESULT.OK}),(function($0,$1){var canvas=window.jDVLDynamicLabelCanvas;var id=canvas.getContext("2d").getImageData(0,0,canvas.width,canvas.height);var p=$0;var n=$1;for(var i=0;i<n;++i)setValue(p++,id.data[i],"i8");document.body.removeChild(canvas);delete window.jDVLDynamicLabelCanvas;return DvlEnums.DVLRESULT.OK}),(function($0,$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$20,$21,$22){var bitmap=Pointer_stringify($0);var size=$1;var rcTexCoords=$2;var w=$3;var h=$4;var pixelRatio=$5;var style=$6;var bgOpacity=$7;var bgColor=$8;var borderOpacity=$9;var borderColor=$10;var borderLineStyle=$11;var bw=$12;var text=Pointer_stringify($13);var textColor=$14;var font=Pointer_stringify($15)||"Arial";var fontSize=$16;var fontWeight=$17;var fontItalic=$18;var encoding=$19;var link=Pointer_stringify($22);var canvas=document.createElement("canvas");canvas.id="jDVLAnnotationCanvas-"+Math.random().toString(36).substr(2,9);canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=1024;canvas.height=1024;document.body.appendChild(canvas);var ctx=canvas.getContext("2d");fontWeight=Math.min(Math.max(Math.round(fontWeight/100),1),9)*100;ctx.font=fontWeight+(fontItalic?" italic ":" ")+fontSize+"px "+font;var hp=fontSize*.2;var vp=fontSize*.2;var lineSpacing=Math.ceil(fontSize);var maxLineWidth=(encoding==0?1024:w)-(hp+bw)*2;var maxLines=((encoding==0?1024:h)-(vp+bw)*2)/lineSpacing|0;var textWidth=0;var linkWidth=0;var textLines=encoding==0?text.split("\n"):[];textLines.length=Math.min(textLines.length,link.length>0?maxLines-1:maxLines);function truncate(str){return str.substr(0,str.length-2)+"\u2026"}var linkLines=[];if(link.length>0){var maxLinkLines=maxLines-textLines.length;while(link.length>0&&textLines.length<maxLinkLines){var rowText=link;while(ctx.measureText(rowText).width>maxLineWidth&&rowText.length>1){rowText=rowText.substring(0,rowText.length-1)}linkLines.push(rowText);link=link.substring(rowText.length,link.length)}if(link.length>0){linkLines[linkLines.length-1]=truncate(linkLines[linkLines.length-1])}for(var i=0;i<linkLines.length;i++){linkWidth=Math.max(ctx.measureText(linkLines[i]).width,linkWidth)}}if(encoding==0){for(var i=0;i<textLines.length;i++){textWidth=Math.max(ctx.measureText(textLines[i]).width,textWidth)}w=Math.max(textWidth,linkWidth)+hp*2;h=(textLines.length+linkLines.length)*lineSpacing+vp*2}w=Math.ceil(w+2*bw);h=Math.ceil(h+2*bw);if(style==1){w=h=Math.max(w,h)}setValue(size,w,"float");setValue(size+4,h,"float");w*=pixelRatio;h*=pixelRatio;var tw=Math.pow(2,Math.ceil(Math.log(w)/Math.LN2));var th=Math.pow(2,Math.ceil(Math.log(h)/Math.LN2));tw=Math.min(tw,canvas.width);th=Math.min(th,canvas.height);if(w>tw||h>th){var scale=Math.min(tw/w,th/h);w*=scale;h*=scale;pixelRatio*=scale}hp*=pixelRatio;vp*=pixelRatio;bw*=pixelRatio;fontSize*=pixelRatio;lineSpacing*=pixelRatio;textWidth*=pixelRatio;setValue(rcTexCoords,0,"float");setValue(rcTexCoords+4,1-h/th,"float");setValue(rcTexCoords+8,w/tw,"float");setValue(rcTexCoords+12,1,"float");bgColor=bgColor.toString(16);bgColor="#"+"000000".substring(bgColor.length)+bgColor;ctx.fillStyle=bgColor;borderColor=borderColor.toString(16);borderColor="#"+"000000".substring(borderColor.length)+borderColor;ctx.strokeStyle=borderColor;ctx.lineWidth=bw;var bw2=bw/2;switch(borderLineStyle){case 2:ctx.setLineDash([bw*5,bw]);break;case 3:ctx.setLineDash([bw*2,bw]);break;case 4:ctx.setLineDash([bw*5,bw,bw*2,bw]);break;case 5:ctx.setLineDash([bw*5,bw,bw*2,bw,bw*2,bw]);break}if(style==0){if(bgOpacity>0){ctx.globalAlpha=bgOpacity;ctx.fillRect(0,0,w,h)}if(borderOpacity>0){ctx.globalAlpha=borderOpacity;ctx.strokeRect(bw2,bw2,w-bw,h-bw)}}else if(style==1){var xc=w/2;var yc=h/2;var radius=Math.min(xc,yc);ctx.beginPath();ctx.arc(xc,yc,radius-bw2,0,2*Math.PI);ctx.closePath();if(bgOpacity>0){ctx.globalAlpha=bgOpacity;ctx.fill()}if(borderOpacity>0){ctx.globalAlpha=borderOpacity;ctx.stroke()}}ctx.globalAlpha=1;ctx.setLineDash([]);ctx.font=fontWeight+(fontItalic?" italic ":" ")+fontSize+"px "+font;ctx.textAlign="left";ctx.textBaseline="middle";function renderLink(){if(linkLines.length>0){ctx.fillStyle="#0000FF";h-=linkLines.length*lineSpacing;var x=(w-linkWidth)*.5;var y=h-bw-vp+lineSpacing*.5;for(var i=0;i<linkLines.length;i++){ctx.fillText(linkLines[i],x,y);y+=lineSpacing}}}if(encoding==0){renderLink();textColor=textColor.toString(16);ctx.fillStyle="#"+"000000".substring(textColor.length)+textColor;ctx.strokeStyle=bgColor;ctx.lineWidth=3;var x=(w-textWidth)*.5;var y=(h-(textLines.length-1)*lineSpacing)*.5;if(textLines.length==1){x=w*.5;ctx.textAlign="center"}for(var i=0;i<textLines.length;i++){if(style==3){ctx.strokeText(textLines[i],x,y)}ctx.fillText(textLines[i],x,y);y+=lineSpacing}Module.ccall("jDVLBitmap_CreateTexture","null",["string","string","number","number"],[bitmap,canvas.id,tw,th]);document.body.removeChild(canvas)}else if(encoding==1&&typeof html2canvas!="undefined"){renderLink();var iframe=document.createElement("iframe");iframe.style.visibility="hidden";iframe.width=(w-bw*2)/pixelRatio;iframe.height=(h-bw*2)/pixelRatio;iframe.scale=pixelRatio/window.devicePixelRatio;document.body.appendChild(iframe);var doc=iframe.contentDocument||iframe.contentWindow.document;doc.open();doc.close();doc.body.innerHTML=text;var htmlCanvas=document.createElement("canvas");htmlCanvas.width=iframe.width*pixelRatio;htmlCanvas.height=iframe.height*pixelRatio;htmlCanvas.style.width=iframe.width+"px";htmlCanvas.style.height=iframe.height+"px";var context=htmlCanvas.getContext("2d");context.scale(pixelRatio,pixelRatio);html2canvas(doc.body,{canvas:htmlCanvas,backgroundColor:null}).then((function(htmlCanvas){if(htmlCanvas.width>0&&htmlCanvas.height>0){var ctx=canvas.getContext("2d");ctx.scale(iframe.scale,iframe.scale);ctx.drawImage(htmlCanvas,bw,bw)}Module.ccall("jDVLBitmap_CreateTexture","null",["string","string","number","number"],[bitmap,canvas.id,tw,th]);document.body.removeChild(iframe);document.body.removeChild(canvas)}))}else{Module.ccall("jDVLBitmap_CreateTexture","null",["string","string","number","number"],[bitmap,canvas.id,tw,th]);document.body.removeChild(canvas)}return DvlEnums.DVLRESULT.OK}),(function($0,$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$20,$21,$22){var bitmap=Pointer_stringify($0);var size=$1;var rcTexCoords=$2;var w=$3;var h=$4;var pixelRatio=$5;var style=$6;var bgOpacity=$7;var bgColor=$8;var borderOpacity=$9;var borderColor=$10;var borderLineStyle=$11;var bw=$12;var text=Pointer_stringify($13);var textColor=$14;var font=Pointer_stringify($15);var fontSize=$16;var fontWeight=$17;var fontItalic=$18;var encoding=$19;var link=Pointer_stringify($22);var canvas=document.createElement("canvas");canvas.id="jDVLAnnotationCanvas-"+Math.random().toString(36).substr(2,9);canvas.style.visibility="hidden";canvas.style.display="none";canvas.width=1024;canvas.height=1024;document.body.appendChild(canvas);var ctx=canvas.getContext("2d");fontWeight=Math.min(Math.max(Math.round(fontWeight/100),1),9)*100;ctx.font=fontWeight+(fontItalic?" italic ":" ")+fontSize+"px "+font;var hp=fontSize*.2;var vp=fontSize*.2;var lineSpacing=Math.ceil(fontSize);var maxLines=((encoding==0?1024:h)-(vp+bw)*2)/lineSpacing|0;var textWidth=0;var textLines=encoding==0?text.split("\n"):[];textLines.length=Math.min(textLines.length,link.length>0?maxLines-1:maxLines);var dimensionWidth=0;var toleralanceWidth=0;var space=0;if(encoding==0){dimensionWidth=ctx.measureText(textLines[0]).width;var toleralanceWidth1=ctx.measureText(textLines[1]).width;var toleralanceWidth2=ctx.measureText(textLines[1]).width;toleralanceWidth=toleralanceWidth1>toleralanceWidth2?toleralanceWidth1:toleralanceWidth2;textWidth=dimensionWidth+toleralanceWidth;space=toleralanceWidth*.2;w=textWidth+space+4*hp;h=2*lineSpacing+vp*2}w=Math.ceil(w+2*bw);h=Math.ceil(h+2*bw);if(style==1){w=h=Math.max(w,h)}setValue(size,w,"float");setValue(size+4,h,"float");w*=pixelRatio;h*=pixelRatio;var tw=Math.pow(2,Math.ceil(Math.log(w)/Math.LN2));var th=Math.pow(2,Math.ceil(Math.log(h)/Math.LN2));tw=Math.min(tw,canvas.width);th=Math.min(th,canvas.height);if(w>tw||h>th){var scale=Math.min(tw/w,th/h);w*=scale;h*=scale;pixelRatio*=scale}hp*=pixelRatio;vp*=pixelRatio;bw*=pixelRatio;fontSize*=pixelRatio;lineSpacing*=pixelRatio;textWidth*=pixelRatio;dimensionWidth*=pixelRatio;toleralanceWidth*=pixelRatio;space*=pixelRatio;setValue(rcTexCoords,0,"float");setValue(rcTexCoords+4,1-h/th,"float");setValue(rcTexCoords+8,w/tw,"float");setValue(rcTexCoords+12,1,"float");bgColor=bgColor.toString(16);bgColor="#"+"000000".substring(bgColor.length)+bgColor;ctx.fillStyle=bgColor;borderColor=borderColor.toString(16);borderColor="#"+"000000".substring(borderColor.length)+borderColor;ctx.strokeStyle=borderColor;ctx.lineWidth=bw;var bw2=bw/2;switch(borderLineStyle){case 2:ctx.setLineDash([bw*5,bw]);break;case 3:ctx.setLineDash([bw*2,bw]);break;case 4:ctx.setLineDash([bw*5,bw,bw*2,bw]);break;case 5:ctx.setLineDash([bw*5,bw,bw*2,bw,bw*2,bw]);break}if(style==0){if(bgOpacity>0){ctx.globalAlpha=bgOpacity;ctx.fillRect(0,0,w,h)}if(borderOpacity>0){ctx.globalAlpha=borderOpacity;ctx.strokeRect(bw2,bw2,w-bw,h-bw)}}else if(style==1){var xc=w/2;var yc=h/2;var radius=Math.min(xc,yc);ctx.beginPath();ctx.arc(xc,yc,radius-bw2,0,2*Math.PI);ctx.closePath();if(bgOpacity>0){ctx.globalAlpha=bgOpacity;ctx.fill()}if(borderOpacity>0){ctx.globalAlpha=borderOpacity;ctx.stroke()}}ctx.globalAlpha=1;ctx.setLineDash([]);ctx.font=fontWeight+(fontItalic?" italic ":" ")+fontSize+"px "+font;ctx.textAlign="left";ctx.textBaseline="middle";if(encoding==0){textColor=textColor.toString(16);ctx.fillStyle="#"+"000000".substring(textColor.length)+textColor;ctx.strokeStyle=bgColor;ctx.lineWidth=3;x=dimensionWidth+space;y=lineSpacing*.5;ctx.fillText(textLines[1],x,y);x=hp;y=lineSpacing;ctx.fillText(textLines[0],x,y);x=dimensionWidth+space;y=lineSpacing*1.5;ctx.fillText(textLines[2],x,y);Module.ccall("jDVLBitmap_CreateTexture","null",["string","string","number","number"],[bitmap,canvas.id,tw,th]);document.body.removeChild(canvas)}return DvlEnums.DVLRESULT.OK})];function _emscripten_asm_const_ii(code,a0){return ASM_CONSTS[code](a0)}function _emscripten_asm_const_iidddddd(code,a0,a1,a2,a3,a4,a5,a6){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6)}function _emscripten_asm_const_iiiii(code,a0,a1,a2,a3){return ASM_CONSTS[code](a0,a1,a2,a3)}function _emscripten_asm_const_iii(code,a0,a1){return ASM_CONSTS[code](a0,a1)}function _emscripten_asm_const_iiii(code,a0,a1,a2){return ASM_CONSTS[code](a0,a1,a2)}function _emscripten_asm_const_iiiiii(code,a0,a1,a2,a3,a4){return ASM_CONSTS[code](a0,a1,a2,a3,a4)}function _emscripten_asm_const_iid(code,a0,a1){return ASM_CONSTS[code](a0,a1)}function _emscripten_asm_const_iiiidddididiiiiiiiiiiiii(code,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19,a20,a21,a22){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19,a20,a21,a22)}STATIC_BASE=GLOBAL_BASE;STATICTOP=STATIC_BASE+438320;__ATINIT__.push({func:(function(){__GLOBAL__I_000101()})},{func:(function(){__GLOBAL__sub_I_LineRenderer_cpp()})},{func:(function(){__GLOBAL__sub_I_VDSReader_cpp()})},{func:(function(){__GLOBAL__sub_I_CoreImp_cpp()})},{func:(function(){__GLOBAL__sub_I_query_cpp()})},{func:(function(){__GLOBAL__sub_I_Math_cpp()})},{func:(function(){__GLOBAL__sub_I_MathConstants_cpp()})},{func:(function(){__GLOBAL__sub_I_ActiveOperationFactory_cpp()})},{func:(function(){__GLOBAL__sub_I_ChangeManager_cpp()})},{func:(function(){__GLOBAL__sub_I_GraphSelectorResolver_cpp()})},{func:(function(){__GLOBAL__sub_I_Id_cpp()})},{func:(function(){__GLOBAL__sub_I_LabelDefinition_cpp()})},{func:(function(){__GLOBAL__sub_I_Material_cpp()})},{func:(function(){__GLOBAL__sub_I_ParametricText_cpp()})},{func:(function(){__GLOBAL__sub_I_Drawing_cpp()})},{func:(function(){__GLOBAL__sub_I_DataModelSQLiteReader_cpp()})},{func:(function(){__GLOBAL__sub_I_ZIPVFSCompression_cpp()})},{func:(function(){___emscripten_environ_constructor()})},{func:(function(){__GLOBAL__sub_I_iostream_cpp()})});memoryInitializer="data:application/octet-stream;base64,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";var tempDoublePtr=STATICTOP;STATICTOP+=16;function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){var timeUntilNextTick=Math.max(0,Browser.mainLoop.tickStartTime+value-_emscripten_get_now())|0;setTimeout(Browser.mainLoop.runner,timeUntilNextTick)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(typeof setImmediate==="undefined"){var setImmediates=[];var emscriptenMainLoopMessageId="setimmediate";function Browser_setImmediate_messageHandler(event){if(event.data===emscriptenMainLoopMessageId||event.data.target===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}addEventListener("message",Browser_setImmediate_messageHandler,true);setImmediate=function Browser_emulated_setImmediate(func){setImmediates.push(func);if(ENVIRONMENT_IS_WORKER){if(Module["setImmediates"]===undefined)Module["setImmediates"]=[];Module["setImmediates"].push(func);postMessage({target:emscriptenMainLoopMessageId})}else postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){setImmediate(Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_get_now(){abort()}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var browserIterationFunc;if(typeof arg!=="undefined"){browserIterationFunc=(function(){Module["dynCall_vi"](func,arg)})}else{browserIterationFunc=(function(){Module["dynCall_v"](func)})}var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}else if(Browser.mainLoop.timingMode==0){Browser.mainLoop.tickStartTime=_emscripten_get_now()}if(Browser.mainLoop.method==="timeout"&&Module.ctx){err("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter(browserIterationFunc);if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)err("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullscreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===Module["canvas"]||document["mozPointerLockElement"]===Module["canvas"]||document["webkitPointerLockElement"]===Module["canvas"]||document["msPointerLockElement"]===Module["canvas"]}var canvas=Module["canvas"];if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&Module["canvas"].requestPointerLock){Module["canvas"].requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullscreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullscreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullscreenChange(){Browser.isFullscreen=false;var canvasContainer=canvas.parentNode;if((document["fullscreenElement"]||document["mozFullScreenElement"]||document["msFullscreenElement"]||document["webkitFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.exitFullscreen=document["exitFullscreen"]||document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["msExitFullscreen"]||document["webkitCancelFullScreen"]||(function(){});canvas.exitFullscreen=canvas.exitFullscreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullscreen=true;if(Browser.resizeCanvas){Browser.setFullscreenCanvasSize()}else{Browser.updateCanvasDimensions(canvas)}}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas){Browser.setWindowedCanvasSize()}else{Browser.updateCanvasDimensions(canvas)}}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullscreen);if(Module["onFullscreen"])Module["onFullscreen"](Browser.isFullscreen)}if(!Browser.fullscreenHandlersInstalled){Browser.fullscreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullscreenChange,false);document.addEventListener("mozfullscreenchange",fullscreenChange,false);document.addEventListener("webkitfullscreenchange",fullscreenChange,false);document.addEventListener("MSFullscreenChange",fullscreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullscreen=canvasContainer["requestFullscreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullscreen"]?(function(){canvasContainer["webkitRequestFullscreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null)||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullscreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullscreen()}}),requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){err("Browser.requestFullScreen() is deprecated. Please call Browser.requestFullscreen instead.");Browser.requestFullScreen=(function(lockPointer,resizeCanvas,vrDevice){return Browser.requestFullscreen(lockPointer,resizeCanvas,vrDevice)});return Browser.requestFullscreen(lockPointer,resizeCanvas,vrDevice)}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),asyncLoad:(function(url,onload,onerror,noRunDep){var dep=!noRunDep?getUniqueRunDependency("al "+url):"";Module["readAsync"](url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(dep)removeRunDependency(dep)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(dep)addRunDependency(dep)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullscreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen>>2];flags=flags|8388608;HEAP32[SDL.screen>>2]=flags}Browser.updateCanvasDimensions(Module["canvas"]);Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen>>2];flags=flags&~8388608;HEAP32[SDL.screen>>2]=flags}Browser.updateCanvasDimensions(Module["canvas"]);Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["fullscreenElement"]||document["mozFullScreenElement"]||document["msFullscreenElement"]||document["webkitFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function __ZN3dvl11Abstraction12DynamicLabel8SetImageEPKvj(){err("missing function: _ZN3dvl11Abstraction12DynamicLabel8SetImageEPKvj");abort(-1)}function ___block_all_sigs(){err("missing function: __block_all_sigs");abort(-1)}var ENV={};function ___buildEnvironment(environ){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C.UTF-8";ENV["_"]=Module["thisProgram"];poolPtr=getMemory(TOTAL_ENV_SIZE);envPtr=getMemory(MAX_ENV_VALUES*4);HEAP32[envPtr>>2]=poolPtr;HEAP32[environ>>2]=envPtr}else{envPtr=HEAP32[environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in ENV){if(typeof ENV[key]==="string"){var line=key+"="+ENV[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}function _emscripten_get_now_is_monotonic(){return ENVIRONMENT_IS_NODE||typeof dateNow!=="undefined"||(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}function _clock_gettime(clk_id,tp){var now;if(clk_id===0){now=Date.now()}else if(clk_id===1&&_emscripten_get_now_is_monotonic()){now=_emscripten_get_now()}else{___setErrNo(ERRNO_CODES.EINVAL);return-1}HEAP32[tp>>2]=now/1e3|0;HEAP32[tp+4>>2]=now%1e3*1e3*1e3|0;return 0}function ___clock_gettime(){return _clock_gettime.apply(null,arguments)}function ___clone(){err("missing function: __clone");abort(-1)}function ___cxa_allocate_exception(size){return _malloc(size)}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var key in EXCEPTIONS.infos){var ptr=+key;var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0&&!info.rethrown){if(info.destructor){Module["dynCall_vi"](info.destructor,ptr)}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___cxa_begin_catch(ptr){var info=EXCEPTIONS.infos[ptr];if(info&&!info.caught){info.caught=true;__ZSt18uncaught_exceptionv.uncaught_exception--}if(info)info.rethrown=false;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function ___cxa_current_primary_exception(){var ret=EXCEPTIONS.caught[EXCEPTIONS.caught.length-1]||0;if(ret)EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ret));return ret}function ___cxa_decrement_exception_refcount(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr))}function ___cxa_increment_exception_refcount(ptr){EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr))}function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}function ___cxa_end_catch(){Module["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function ___cxa_rethrow(){var ptr=EXCEPTIONS.caught.pop();ptr=EXCEPTIONS.deAdjust(ptr);if(!EXCEPTIONS.infos[ptr].rethrown){EXCEPTIONS.caught.push(ptr);EXCEPTIONS.infos[ptr].rethrown=true}EXCEPTIONS.last=ptr;throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_rethrow_primary_exception(ptr){if(!ptr)return;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.infos[ptr].rethrown=true;___cxa_rethrow()}function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(setTempRet0(0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(setTempRet0(0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(setTempRet0(typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(setTempRet0(throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0,caught:false,rethrown:false};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_uncaught_exception(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}function ___gxx_personality_v0(){}function ___lock(){}function ___map_file(pathname,size){___setErrNo(ERRNO_CODES.EPERM);return-1}function ___muldc3(){err("missing function: __muldc3");abort(-1)}function ___mulsc3(){err("missing function: __mulsc3");abort(-1)}function ___restore_sigs(){err("missing function: __restore_sigs");abort(-1)}var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var isPosixPlatform=process.platform!="win32";var fd=process.stdin.fd;if(isPosixPlatform){var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}}try{bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null)}catch(e){if(e.toString().indexOf("EOF")!=-1)bytesRead=0;else throw e}if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){out(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){out(UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){err(UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){err(UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}if(!req){return callback("Unable to connect to IndexedDB")}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);try{var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}catch(e){return callback(e)}}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/);var flags=process["binding"]("constants");if(flags["fs"]){flags=flags["fs"]}NODEFS.flagsForNodeMap={"1024":flags["O_APPEND"],"64":flags["O_CREAT"],"128":flags["O_EXCL"],"0":flags["O_RDONLY"],"2":flags["O_RDWR"],"4096":flags["O_SYNC"],"512":flags["O_TRUNC"],"1":flags["O_WRONLY"]}}),bufferFrom:(function(arrayBuffer){return Buffer.alloc?Buffer.from(arrayBuffer):new Buffer(arrayBuffer)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&292)>>2}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsForNode:(function(flags){flags&=~2097152;flags&=~2048;flags&=~32768;flags&=~524288;var newFlags=0;for(var k in NODEFS.flagsForNodeMap){if(flags&k){newFlags|=NODEFS.flagsForNodeMap[k];flags^=k}}if(!flags){return newFlags}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsForNode(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;try{return fs.readSync(stream.nfd,NODEFS.bufferFrom(buffer.buffer),offset,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),write:(function(stream,buffer,offset,length,position){try{return fs.writeSync(stream.nfd,NODEFS.bufferFrom(buffer.buffer),offset,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,parts[i],WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};STATICTOP+=16;STATICTOP+=16;STATICTOP+=16;var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){console.log("warning: "+FS.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work")}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(err){assert(FS.syncFSRequests>0);FS.syncFSRequests--;return callback(err)}function done(err){if(err){if(!done.errored){done.errored=true;return doCallback(err)}return}if(++completed>=mounts.length){doCallback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdirTree:(function(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=ERRNO_CODES.EEXIST)throw e}}}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;err("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}stream.fd=null}),isClosed:(function(stream){return stream.fd===null}),llseek:(function(stream,offset,whence){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=typeof position!=="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(FS.isClosed(stream)){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";var stream=FS.open(path,opts.flags,opts.mode);if(typeof data==="string"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,undefined,opts.canOwn)}else if(ArrayBuffer.isView(data)){FS.write(stream,data,0,data.byteLength,undefined,opts.canOwn)}else{throw new Error("Unsupported data type")}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto")["randomBytes"](1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno];if(this.stack)Object.defineProperty(this,"stack",{value:(new Error).stack,writable:true})};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;console.log("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})},chunkSize:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:(function(){return this.contents.length})}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);var len=Math.min(bufsize,lengthBytesUTF8(ret));var endChar=HEAP8[buf+len];stringToUTF8(ret,buf,bufsize+1);HEAP8[buf+len]=endChar;return len}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall1(which,varargs){SYSCALLS.varargs=varargs;try{var status=SYSCALLS.get();exit(status);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall10(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var SOCKFS={mount:(function(mount){Module["websocket"]=Module["websocket"]&&"object"===typeof Module["websocket"]?Module["websocket"]:{};Module["websocket"]._callbacks={};Module["websocket"]["on"]=(function(event,callback){if("function"===typeof callback){this._callbacks[event]=callback}return this});Module["websocket"].emit=(function(event,param){if("function"===typeof this._callbacks[event]){this._callbacks[event].call(this,param)}});return FS.createNode(null,"/",16384|511,0)}),createSocket:(function(family,type,protocol){var streaming=type==1;if(protocol){assert(streaming==(protocol==6))}var sock={family:family,type:type,protocol:protocol,server:null,error:null,peers:{},pending:[],recv_queue:[],sock_ops:SOCKFS.websocket_sock_ops};var name=SOCKFS.nextname();var node=FS.createNode(SOCKFS.root,name,49152,0);node.sock=sock;var stream=FS.createStream({path:name,node:node,flags:FS.modeStringToFlags("r+"),seekable:false,stream_ops:SOCKFS.stream_ops});sock.stream=stream;return sock}),getSocket:(function(fd){var stream=FS.getStream(fd);if(!stream||!FS.isSocket(stream.node.mode)){return null}return stream.node.sock}),stream_ops:{poll:(function(stream){var sock=stream.node.sock;return sock.sock_ops.poll(sock)}),ioctl:(function(stream,request,varargs){var sock=stream.node.sock;return sock.sock_ops.ioctl(sock,request,varargs)}),read:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;var msg=sock.sock_ops.recvmsg(sock,length);if(!msg){return 0}buffer.set(msg.buffer,offset);return msg.buffer.length}),write:(function(stream,buffer,offset,length,position){var sock=stream.node.sock;return sock.sock_ops.sendmsg(sock,buffer,offset,length)}),close:(function(stream){var sock=stream.node.sock;sock.sock_ops.close(sock)})},nextname:(function(){if(!SOCKFS.nextname.current){SOCKFS.nextname.current=0}return"socket["+SOCKFS.nextname.current++ +"]"}),websocket_sock_ops:{createPeer:(function(sock,addr,port){var ws;if(typeof addr==="object"){ws=addr;addr=null;port=null}if(ws){if(ws._socket){addr=ws._socket.remoteAddress;port=ws._socket.remotePort}else{var result=/ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);if(!result){throw new Error("WebSocket URL must be in the format ws(s)://address:port")}addr=result[1];port=parseInt(result[2],10)}}else{try{var runtimeConfig=Module["websocket"]&&"object"===typeof Module["websocket"];var url="ws:#".replace("#","//");if(runtimeConfig){if("string"===typeof Module["websocket"]["url"]){url=Module["websocket"]["url"]}}if(url==="ws://"||url==="wss://"){var parts=addr.split("/");url=url+parts[0]+":"+port+"/"+parts.slice(1).join("/")}var subProtocols="binary";if(runtimeConfig){if("string"===typeof Module["websocket"]["subprotocol"]){subProtocols=Module["websocket"]["subprotocol"]}}subProtocols=subProtocols.replace(/^ +| +$/g,"").split(/ *, */);var opts=ENVIRONMENT_IS_NODE?{"protocol":subProtocols.toString()}:subProtocols;if(runtimeConfig&&null===Module["websocket"]["subprotocol"]){subProtocols="null";opts=undefined}var WebSocketConstructor;if(ENVIRONMENT_IS_NODE){WebSocketConstructor=require("ws")}else if(ENVIRONMENT_IS_WEB){WebSocketConstructor=window["WebSocket"]}else{WebSocketConstructor=WebSocket}ws=new WebSocketConstructor(url,opts);ws.binaryType="arraybuffer"}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH)}}var peer={addr:addr,port:port,socket:ws,dgram_send_queue:[]};SOCKFS.websocket_sock_ops.addPeer(sock,peer);SOCKFS.websocket_sock_ops.handlePeerEvents(sock,peer);if(sock.type===2&&typeof sock.sport!=="undefined"){peer.dgram_send_queue.push(new Uint8Array([255,255,255,255,"p".charCodeAt(0),"o".charCodeAt(0),"r".charCodeAt(0),"t".charCodeAt(0),(sock.sport&65280)>>8,sock.sport&255]))}return peer}),getPeer:(function(sock,addr,port){return sock.peers[addr+":"+port]}),addPeer:(function(sock,peer){sock.peers[peer.addr+":"+peer.port]=peer}),removePeer:(function(sock,peer){delete sock.peers[peer.addr+":"+peer.port]}),handlePeerEvents:(function(sock,peer){var first=true;var handleOpen=(function(){Module["websocket"].emit("open",sock.stream.fd);try{var queued=peer.dgram_send_queue.shift();while(queued){peer.socket.send(queued);queued=peer.dgram_send_queue.shift()}}catch(e){peer.socket.close()}});function handleMessage(data){assert(typeof data!=="string"&&data.byteLength!==undefined);if(data.byteLength==0){return}data=new Uint8Array(data);var wasfirst=first;first=false;if(wasfirst&&data.length===10&&data[0]===255&&data[1]===255&&data[2]===255&&data[3]===255&&data[4]==="p".charCodeAt(0)&&data[5]==="o".charCodeAt(0)&&data[6]==="r".charCodeAt(0)&&data[7]==="t".charCodeAt(0)){var newport=data[8]<<8|data[9];SOCKFS.websocket_sock_ops.removePeer(sock,peer);peer.port=newport;SOCKFS.websocket_sock_ops.addPeer(sock,peer);return}sock.recv_queue.push({addr:peer.addr,port:peer.port,data:data});Module["websocket"].emit("message",sock.stream.fd)}if(ENVIRONMENT_IS_NODE){peer.socket.on("open",handleOpen);peer.socket.on("message",(function(data,flags){if(!flags.binary){return}handleMessage((new Uint8Array(data)).buffer)}));peer.socket.on("close",(function(){Module["websocket"].emit("close",sock.stream.fd)}));peer.socket.on("error",(function(error){sock.error=ERRNO_CODES.ECONNREFUSED;Module["websocket"].emit("error",[sock.stream.fd,sock.error,"ECONNREFUSED: Connection refused"])}))}else{peer.socket.onopen=handleOpen;peer.socket.onclose=(function(){Module["websocket"].emit("close",sock.stream.fd)});peer.socket.onmessage=function peer_socket_onmessage(event){handleMessage(event.data)};peer.socket.onerror=(function(error){sock.error=ERRNO_CODES.ECONNREFUSED;Module["websocket"].emit("error",[sock.stream.fd,sock.error,"ECONNREFUSED: Connection refused"])})}}),poll:(function(sock){if(sock.type===1&&sock.server){return sock.pending.length?64|1:0}var mask=0;var dest=sock.type===1?SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport):null;if(sock.recv_queue.length||!dest||dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=64|1}if(!dest||dest&&dest.socket.readyState===dest.socket.OPEN){mask|=4}if(dest&&dest.socket.readyState===dest.socket.CLOSING||dest&&dest.socket.readyState===dest.socket.CLOSED){mask|=16}return mask}),ioctl:(function(sock,request,arg){switch(request){case 21531:var bytes=0;if(sock.recv_queue.length){bytes=sock.recv_queue[0].data.length}HEAP32[arg>>2]=bytes;return 0;default:return ERRNO_CODES.EINVAL}}),close:(function(sock){if(sock.server){try{sock.server.close()}catch(e){}sock.server=null}var peers=Object.keys(sock.peers);for(var i=0;i<peers.length;i++){var peer=sock.peers[peers[i]];try{peer.socket.close()}catch(e){}SOCKFS.websocket_sock_ops.removePeer(sock,peer)}return 0}),bind:(function(sock,addr,port){if(typeof sock.saddr!=="undefined"||typeof sock.sport!=="undefined"){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}sock.saddr=addr;sock.sport=port;if(sock.type===2){if(sock.server){sock.server.close();sock.server=null}try{sock.sock_ops.listen(sock,0)}catch(e){if(!(e instanceof FS.ErrnoError))throw e;if(e.errno!==ERRNO_CODES.EOPNOTSUPP)throw e}}}),connect:(function(sock,addr,port){if(sock.server){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}if(typeof sock.daddr!=="undefined"&&typeof sock.dport!=="undefined"){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(dest){if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EALREADY)}else{throw new FS.ErrnoError(ERRNO_CODES.EISCONN)}}}var peer=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port);sock.daddr=peer.addr;sock.dport=peer.port;throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS)}),listen:(function(sock,backlog){if(!ENVIRONMENT_IS_NODE){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}if(sock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var WebSocketServer=require("ws").Server;var host=sock.saddr;sock.server=new WebSocketServer({host:host,port:sock.sport});Module["websocket"].emit("listen",sock.stream.fd);sock.server.on("connection",(function(ws){if(sock.type===1){var newsock=SOCKFS.createSocket(sock.family,sock.type,sock.protocol);var peer=SOCKFS.websocket_sock_ops.createPeer(newsock,ws);newsock.daddr=peer.addr;newsock.dport=peer.port;sock.pending.push(newsock);Module["websocket"].emit("connection",newsock.stream.fd)}else{SOCKFS.websocket_sock_ops.createPeer(sock,ws);Module["websocket"].emit("connection",sock.stream.fd)}}));sock.server.on("closed",(function(){Module["websocket"].emit("close",sock.stream.fd);sock.server=null}));sock.server.on("error",(function(error){sock.error=ERRNO_CODES.EHOSTUNREACH;Module["websocket"].emit("error",[sock.stream.fd,sock.error,"EHOSTUNREACH: Host is unreachable"])}))}),accept:(function(listensock){if(!listensock.server){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var newsock=listensock.pending.shift();newsock.stream.flags=listensock.stream.flags;return newsock}),getname:(function(sock,peer){var addr,port;if(peer){if(sock.daddr===undefined||sock.dport===undefined){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}addr=sock.daddr;port=sock.dport}else{addr=sock.saddr||0;port=sock.sport||0}return{addr:addr,port:port}}),sendmsg:(function(sock,buffer,offset,length,addr,port){if(sock.type===2){if(addr===undefined||port===undefined){addr=sock.daddr;port=sock.dport}if(addr===undefined||port===undefined){throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ)}}else{addr=sock.daddr;port=sock.dport}var dest=SOCKFS.websocket_sock_ops.getPeer(sock,addr,port);if(sock.type===1){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CONNECTING){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}if(ArrayBuffer.isView(buffer)){offset+=buffer.byteOffset;buffer=buffer.buffer}var data;data=buffer.slice(offset,offset+length);if(sock.type===2){if(!dest||dest.socket.readyState!==dest.socket.OPEN){if(!dest||dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){dest=SOCKFS.websocket_sock_ops.createPeer(sock,addr,port)}dest.dgram_send_queue.push(data);return length}}try{dest.socket.send(data);return length}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),recvmsg:(function(sock,length){if(sock.type===1&&sock.server){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}var queued=sock.recv_queue.shift();if(!queued){if(sock.type===1){var dest=SOCKFS.websocket_sock_ops.getPeer(sock,sock.daddr,sock.dport);if(!dest){throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)}else if(dest.socket.readyState===dest.socket.CLOSING||dest.socket.readyState===dest.socket.CLOSED){return null}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}else{throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}}var queuedLength=queued.data.byteLength||queued.data.length;var queuedOffset=queued.data.byteOffset||0;var queuedBuffer=queued.data.buffer||queued.data;var bytesRead=Math.min(length,queuedLength);var res={buffer:new Uint8Array(queuedBuffer,queuedOffset,bytesRead),addr:queued.addr,port:queued.port};if(sock.type===1&&bytesRead<queuedLength){var bytesRemaining=queuedLength-bytesRead;queued.data=new Uint8Array(queuedBuffer,queuedOffset+bytesRead,bytesRemaining);sock.recv_queue.unshift(queued)}return res})}};function __inet_pton4_raw(str){var b=str.split(".");for(var i=0;i<4;i++){var tmp=Number(b[i]);if(isNaN(tmp))return null;b[i]=tmp}return(b[0]|b[1]<<8|b[2]<<16|b[3]<<24)>>>0}function __inet_pton6_raw(str){var words;var w,offset,z;var valid6regx=/^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i;var parts=[];if(!valid6regx.test(str)){return null}if(str==="::"){return[0,0,0,0,0,0,0,0]}if(str.indexOf("::")===0){str=str.replace("::","Z:")}else{str=str.replace("::",":Z:")}if(str.indexOf(".")>0){str=str.replace(new RegExp("[.]","g"),":");words=str.split(":");words[words.length-4]=parseInt(words[words.length-4])+parseInt(words[words.length-3])*256;words[words.length-3]=parseInt(words[words.length-2])+parseInt(words[words.length-1])*256;words=words.slice(0,words.length-2)}else{words=str.split(":")}offset=0;z=0;for(w=0;w<words.length;w++){if(typeof words[w]==="string"){if(words[w]==="Z"){for(z=0;z<8-words.length+1;z++){parts[w+z]=0}offset=z-1}else{parts[w+offset]=_htons(parseInt(words[w],16))}}else{parts[w+offset]=words[w]}}return[parts[1]<<16|parts[0],parts[3]<<16|parts[2],parts[5]<<16|parts[4],parts[7]<<16|parts[6]]}var DNS={address_map:{id:1,addrs:{},names:{}},lookup_name:(function(name){var res=__inet_pton4_raw(name);if(res!==null){return name}res=__inet_pton6_raw(name);if(res!==null){return name}var addr;if(DNS.address_map.addrs[name]){addr=DNS.address_map.addrs[name]}else{var id=DNS.address_map.id++;assert(id<65535,"exceeded max address mappings of 65535");addr="172.29."+(id&255)+"."+(id&65280);DNS.address_map.names[addr]=name;DNS.address_map.addrs[name]=addr}return addr}),lookup_addr:(function(addr){if(DNS.address_map.names[addr]){return DNS.address_map.names[addr]}return null})};function __inet_ntop4_raw(addr){return(addr&255)+"."+(addr>>8&255)+"."+(addr>>16&255)+"."+(addr>>24&255)}function __inet_ntop6_raw(ints){var str="";var word=0;var longest=0;var lastzero=0;var zstart=0;var len=0;var i=0;var parts=[ints[0]&65535,ints[0]>>16,ints[1]&65535,ints[1]>>16,ints[2]&65535,ints[2]>>16,ints[3]&65535,ints[3]>>16];var hasipv4=true;var v4part="";for(i=0;i<5;i++){if(parts[i]!==0){hasipv4=false;break}}if(hasipv4){v4part=__inet_ntop4_raw(parts[6]|parts[7]<<16);if(parts[5]===-1){str="::ffff:";str+=v4part;return str}if(parts[5]===0){str="::";if(v4part==="0.0.0.0")v4part="";if(v4part==="0.0.0.1")v4part="1";str+=v4part;return str}}for(word=0;word<8;word++){if(parts[word]===0){if(word-lastzero>1){len=0}lastzero=word;len++}if(len>longest){longest=len;zstart=word-longest+1}}for(word=0;word<8;word++){if(longest>1){if(parts[word]===0&&word>=zstart&&word<zstart+longest){if(word===zstart){str+=":";if(zstart===0)str+=":"}continue}}str+=Number(_ntohs(parts[word]&65535)).toString(16);str+=word<7?":":""}return str}function __read_sockaddr(sa,salen){var family=HEAP16[sa>>1];var port=_ntohs(HEAP16[sa+2>>1]);var addr;switch(family){case 2:if(salen!==16){return{errno:ERRNO_CODES.EINVAL}}addr=HEAP32[sa+4>>2];addr=__inet_ntop4_raw(addr);break;case 10:if(salen!==28){return{errno:ERRNO_CODES.EINVAL}}addr=[HEAP32[sa+8>>2],HEAP32[sa+12>>2],HEAP32[sa+16>>2],HEAP32[sa+20>>2]];addr=__inet_ntop6_raw(addr);break;default:return{errno:ERRNO_CODES.EAFNOSUPPORT}}return{family:family,addr:addr,port:port}}function __write_sockaddr(sa,family,addr,port){switch(family){case 2:addr=__inet_pton4_raw(addr);HEAP16[sa>>1]=family;HEAP32[sa+4>>2]=addr;HEAP16[sa+2>>1]=_htons(port);break;case 10:addr=__inet_pton6_raw(addr);HEAP32[sa>>2]=family;HEAP32[sa+8>>2]=addr[0];HEAP32[sa+12>>2]=addr[1];HEAP32[sa+16>>2]=addr[2];HEAP32[sa+20>>2]=addr[3];HEAP16[sa+2>>1]=_htons(port);HEAP32[sa+4>>2]=0;HEAP32[sa+24>>2]=0;break;default:return{errno:ERRNO_CODES.EAFNOSUPPORT}}return{}}function ___syscall102(which,varargs){SYSCALLS.varargs=varargs;try{var call=SYSCALLS.get(),socketvararg=SYSCALLS.get();SYSCALLS.varargs=socketvararg;switch(call){case 1:{var domain=SYSCALLS.get(),type=SYSCALLS.get(),protocol=SYSCALLS.get();var sock=SOCKFS.createSocket(domain,type,protocol);assert(sock.stream.fd<64);return sock.stream.fd};case 2:{var sock=SYSCALLS.getSocketFromFD(),info=SYSCALLS.getSocketAddress();sock.sock_ops.bind(sock,info.addr,info.port);return 0};case 3:{var sock=SYSCALLS.getSocketFromFD(),info=SYSCALLS.getSocketAddress();sock.sock_ops.connect(sock,info.addr,info.port);return 0};case 4:{var sock=SYSCALLS.getSocketFromFD(),backlog=SYSCALLS.get();sock.sock_ops.listen(sock,backlog);return 0};case 5:{var sock=SYSCALLS.getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var newsock=sock.sock_ops.accept(sock);if(addr){var res=__write_sockaddr(addr,newsock.family,DNS.lookup_name(newsock.daddr),newsock.dport);assert(!res.errno)}return newsock.stream.fd};case 6:{var sock=SYSCALLS.getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(sock.saddr||"0.0.0.0"),sock.sport);assert(!res.errno);return 0};case 7:{var sock=SYSCALLS.getSocketFromFD(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();if(!sock.daddr){return-ERRNO_CODES.ENOTCONN}var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(sock.daddr),sock.dport);assert(!res.errno);return 0};case 11:{var sock=SYSCALLS.getSocketFromFD(),message=SYSCALLS.get(),length=SYSCALLS.get(),flags=SYSCALLS.get(),dest=SYSCALLS.getSocketAddress(true);if(!dest){return FS.write(sock.stream,HEAP8,message,length)}else{return sock.sock_ops.sendmsg(sock,HEAP8,message,length,dest.addr,dest.port)}};case 12:{var sock=SYSCALLS.getSocketFromFD(),buf=SYSCALLS.get(),len=SYSCALLS.get(),flags=SYSCALLS.get(),addr=SYSCALLS.get(),addrlen=SYSCALLS.get();var msg=sock.sock_ops.recvmsg(sock,len);if(!msg)return 0;if(addr){var res=__write_sockaddr(addr,sock.family,DNS.lookup_name(msg.addr),msg.port);assert(!res.errno)}HEAPU8.set(msg.buffer,buf);return msg.buffer.byteLength};case 14:{return-ERRNO_CODES.ENOPROTOOPT};case 15:{var sock=SYSCALLS.getSocketFromFD(),level=SYSCALLS.get(),optname=SYSCALLS.get(),optval=SYSCALLS.get(),optlen=SYSCALLS.get();if(level===1){if(optname===4){HEAP32[optval>>2]=sock.error;HEAP32[optlen>>2]=4;sock.error=null;return 0}}return-ERRNO_CODES.ENOPROTOOPT};case 16:{var sock=SYSCALLS.getSocketFromFD(),message=SYSCALLS.get(),flags=SYSCALLS.get();var iov=HEAP32[message+8>>2];var num=HEAP32[message+12>>2];var addr,port;var name=HEAP32[message>>2];var namelen=HEAP32[message+4>>2];if(name){var info=__read_sockaddr(name,namelen);if(info.errno)return-info.errno;port=info.port;addr=DNS.lookup_addr(info.addr)||info.addr}var total=0;for(var i=0;i<num;i++){total+=HEAP32[iov+(8*i+4)>>2]}var view=new Uint8Array(total);var offset=0;for(var i=0;i<num;i++){var iovbase=HEAP32[iov+(8*i+0)>>2];var iovlen=HEAP32[iov+(8*i+4)>>2];for(var j=0;j<iovlen;j++){view[offset++]=HEAP8[iovbase+j>>0]}}return sock.sock_ops.sendmsg(sock,view,0,total,addr,port)};case 17:{var sock=SYSCALLS.getSocketFromFD(),message=SYSCALLS.get(),flags=SYSCALLS.get();var iov=HEAP32[message+8>>2];var num=HEAP32[message+12>>2];var total=0;for(var i=0;i<num;i++){total+=HEAP32[iov+(8*i+4)>>2]}var msg=sock.sock_ops.recvmsg(sock,total);if(!msg)return 0;var name=HEAP32[message>>2];if(name){var res=__write_sockaddr(name,sock.family,DNS.lookup_name(msg.addr),msg.port);assert(!res.errno)}var bytesRead=0;var bytesRemaining=msg.buffer.byteLength;for(var i=0;bytesRemaining>0&&i<num;i++){var iovbase=HEAP32[iov+(8*i+0)>>2];var iovlen=HEAP32[iov+(8*i+4)>>2];if(!iovlen){continue}var length=Math.min(iovlen,bytesRemaining);var buf=msg.buffer.subarray(bytesRead,bytesRead+length);HEAPU8.set(buf,iovbase+bytesRead);bytesRead+=length;bytesRemaining-=length}return bytesRead};default:abort("unsupported socketcall syscall "+call)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall114(which,varargs){SYSCALLS.varargs=varargs;try{abort("cannot wait on child processes")}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall118(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall12(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.chdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall121(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.EPERM}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall122(which,varargs){SYSCALLS.varargs=varargs;try{var buf=SYSCALLS.get();if(!buf)return-ERRNO_CODES.EFAULT;var layout={"sysname":0,"nodename":65,"domainname":325,"machine":260,"version":195,"release":130,"__size__":390};function copyString(element,value){var offset=layout[element];writeAsciiToMemory(value,buf+offset)}copyString("sysname","Emscripten");copyString("nodename","emscripten");copyString("release","1.0");copyString("version","#1");copyString("machine","x86-JS");return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall125(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var PROCINFO={ppid:1,pid:42,sid:42,pgid:42};function ___syscall132(which,varargs){SYSCALLS.varargs=varargs;try{var pid=SYSCALLS.get();if(pid&&pid!==PROCINFO.pid)return-ERRNO_CODES.ESRCH;return PROCINFO.pgid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall133(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.chdir(stream.path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall14(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get(),dev=SYSCALLS.get();return SYSCALLS.doMknod(path,mode,dev)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall142(which,varargs){SYSCALLS.varargs=varargs;try{var nfds=SYSCALLS.get(),readfds=SYSCALLS.get(),writefds=SYSCALLS.get(),exceptfds=SYSCALLS.get(),timeout=SYSCALLS.get();assert(nfds<=64,"nfds must be less than or equal to 64");assert(!exceptfds,"exceptfds not supported");var total=0;var srcReadLow=readfds?HEAP32[readfds>>2]:0,srcReadHigh=readfds?HEAP32[readfds+4>>2]:0;var srcWriteLow=writefds?HEAP32[writefds>>2]:0,srcWriteHigh=writefds?HEAP32[writefds+4>>2]:0;var srcExceptLow=exceptfds?HEAP32[exceptfds>>2]:0,srcExceptHigh=exceptfds?HEAP32[exceptfds+4>>2]:0;var dstReadLow=0,dstReadHigh=0;var dstWriteLow=0,dstWriteHigh=0;var dstExceptLow=0,dstExceptHigh=0;var allLow=(readfds?HEAP32[readfds>>2]:0)|(writefds?HEAP32[writefds>>2]:0)|(exceptfds?HEAP32[exceptfds>>2]:0);var allHigh=(readfds?HEAP32[readfds+4>>2]:0)|(writefds?HEAP32[writefds+4>>2]:0)|(exceptfds?HEAP32[exceptfds+4>>2]:0);function check(fd,low,high,val){return fd<32?low&val:high&val}for(var fd=0;fd<nfds;fd++){var mask=1<<fd%32;if(!check(fd,allLow,allHigh,mask)){continue}var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var flags=SYSCALLS.DEFAULT_POLLMASK;if(stream.stream_ops.poll){flags=stream.stream_ops.poll(stream)}if(flags&1&&check(fd,srcReadLow,srcReadHigh,mask)){fd<32?dstReadLow=dstReadLow|mask:dstReadHigh=dstReadHigh|mask;total++}if(flags&4&&check(fd,srcWriteLow,srcWriteHigh,mask)){fd<32?dstWriteLow=dstWriteLow|mask:dstWriteHigh=dstWriteHigh|mask;total++}if(flags&2&&check(fd,srcExceptLow,srcExceptHigh,mask)){fd<32?dstExceptLow=dstExceptLow|mask:dstExceptHigh=dstExceptHigh|mask;total++}}if(readfds){HEAP32[readfds>>2]=dstReadLow;HEAP32[readfds+4>>2]=dstReadHigh}if(writefds){HEAP32[writefds>>2]=dstWriteLow;HEAP32[writefds+4>>2]=dstWriteHigh}if(exceptfds){HEAP32[exceptfds>>2]=dstExceptLow;HEAP32[exceptfds+4>>2]=dstExceptHigh}return total}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall144(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get(),flags=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;SYSCALLS.doMsync(addr,FS.getStream(info.fd),len,info.flags);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall147(which,varargs){SYSCALLS.varargs=varargs;try{var pid=SYSCALLS.get();if(pid&&pid!==PROCINFO.pid)return-ERRNO_CODES.ESRCH;return PROCINFO.sid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall148(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall15(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();FS.chmod(path,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall153(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall150(){return ___syscall153.apply(null,arguments)}function ___syscall151(){return ___syscall153.apply(null,arguments)}function ___syscall152(){return ___syscall153.apply(null,arguments)}function ___syscall163(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.ENOMEM}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall168(which,varargs){SYSCALLS.varargs=varargs;try{var fds=SYSCALLS.get(),nfds=SYSCALLS.get(),timeout=SYSCALLS.get();var nonzero=0;for(var i=0;i<nfds;i++){var pollfd=fds+8*i;var fd=HEAP32[pollfd>>2];var events=HEAP16[pollfd+4>>1];var mask=32;var stream=FS.getStream(fd);if(stream){mask=SYSCALLS.DEFAULT_POLLMASK;if(stream.stream_ops.poll){mask=stream.stream_ops.poll(stream)}}mask&=events|8|16;if(mask)nonzero++;HEAP16[pollfd+6>>1]=mask}return nonzero}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall180(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get(),zero=SYSCALLS.getZero(),offset=SYSCALLS.get64();return FS.read(stream,HEAP8,buf,count,offset)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall181(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get(),zero=SYSCALLS.getZero(),offset=SYSCALLS.get64();return FS.write(stream,HEAP8,buf,count,offset)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall183(which,varargs){SYSCALLS.varargs=varargs;try{var buf=SYSCALLS.get(),size=SYSCALLS.get();if(size===0)return-ERRNO_CODES.EINVAL;var cwd=FS.cwd();var cwdLengthInBytes=lengthBytesUTF8(cwd);if(size<cwdLengthInBytes+1)return-ERRNO_CODES.ERANGE;stringToUTF8(cwd,buf,size);return buf}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall191(which,varargs){SYSCALLS.varargs=varargs;try{var resource=SYSCALLS.get(),rlim=SYSCALLS.get();HEAP32[rlim>>2]=-1;HEAP32[rlim+4>>2]=-1;HEAP32[rlim+8>>2]=-1;HEAP32[rlim+12>>2]=-1;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall192(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get(),prot=SYSCALLS.get(),flags=SYSCALLS.get(),fd=SYSCALLS.get(),off=SYSCALLS.get();off<<=12;var ptr;var allocated=false;if(fd===-1){ptr=_memalign(PAGE_SIZE,len);if(!ptr)return-ERRNO_CODES.ENOMEM;_memset(ptr,0,len);allocated=true}else{var info=FS.getStream(fd);if(!info)return-ERRNO_CODES.EBADF;var res=FS.mmap(info,HEAPU8,addr,len,off,prot,flags);ptr=res.ptr;allocated=res.allocated}SYSCALLS.mappings[ptr]={malloc:ptr,len:len,allocated:allocated,fd:fd,flags:flags};return ptr}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall193(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),zero=SYSCALLS.getZero(),length=SYSCALLS.get64();FS.truncate(path,length);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall194(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),zero=SYSCALLS.getZero(),length=SYSCALLS.get64();FS.ftruncate(fd,length);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall196(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.lstat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall197(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall198(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),owner=SYSCALLS.get(),group=SYSCALLS.get();FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall202(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall199(){return ___syscall202.apply(null,arguments)}function ___syscall20(which,varargs){SYSCALLS.varargs=varargs;try{return PROCINFO.pid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall200(){return ___syscall202.apply(null,arguments)}function ___syscall201(){return ___syscall202.apply(null,arguments)}function ___syscall214(which,varargs){SYSCALLS.varargs=varargs;try{var uid=SYSCALLS.get();if(uid!==0)return-ERRNO_CODES.EPERM;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall203(){return ___syscall214.apply(null,arguments)}function ___syscall204(){return ___syscall214.apply(null,arguments)}function ___syscall205(which,varargs){SYSCALLS.varargs=varargs;try{var size=SYSCALLS.get(),list=SYSCALLS.get();if(size<1)return-ERRNO_CODES.EINVAL;HEAP32[list>>2]=0;return 1}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall207(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),owner=SYSCALLS.get(),group=SYSCALLS.get();FS.fchown(fd,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall211(which,varargs){SYSCALLS.varargs=varargs;try{var ruid=SYSCALLS.get(),euid=SYSCALLS.get(),suid=SYSCALLS.get();HEAP32[ruid>>2]=0;HEAP32[euid>>2]=0;HEAP32[suid>>2]=0;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall209(){return ___syscall211.apply(null,arguments)}function ___syscall212(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),owner=SYSCALLS.get(),group=SYSCALLS.get();FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall218(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.ENOSYS}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall219(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall220(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),dirp=SYSCALLS.get(),count=SYSCALLS.get();if(!stream.getdents){stream.getdents=FS.readdir(stream.path)}var pos=0;while(stream.getdents.length>0&&pos+268<=count){var id;var type;var name=stream.getdents.pop();if(name[0]==="."){id=1;type=4}else{var child=FS.lookupNode(stream.node,name);id=child.id;type=FS.isChrdev(child.mode)?2:FS.isDir(child.mode)?4:FS.isLink(child.mode)?10:8}HEAP32[dirp+pos>>2]=id;HEAP32[dirp+pos+4>>2]=stream.position;HEAP16[dirp+pos+8>>1]=268;HEAP8[dirp+pos+10>>0]=type;stringToUTF8(name,dirp+pos+11,256);pos+=268}return pos}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall268(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),size=SYSCALLS.get(),buf=SYSCALLS.get();assert(size===64);HEAP32[buf+4>>2]=4096;HEAP32[buf+40>>2]=4096;HEAP32[buf+8>>2]=1e6;HEAP32[buf+12>>2]=5e5;HEAP32[buf+16>>2]=5e5;HEAP32[buf+20>>2]=FS.nextInode;HEAP32[buf+24>>2]=1e6;HEAP32[buf+28>>2]=42;HEAP32[buf+44>>2]=2;HEAP32[buf+36>>2]=255;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall269(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),size=SYSCALLS.get(),buf=SYSCALLS.get();return ___syscall([268,0,size,buf],0)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall272(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall29(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.EINTR}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall295(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();path=SYSCALLS.calculateAt(dirfd,path);return FS.open(path,flags,mode).fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall296(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),mode=SYSCALLS.get();path=SYSCALLS.calculateAt(dirfd,path);return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall297(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),mode=SYSCALLS.get(),dev=SYSCALLS.get();path=SYSCALLS.calculateAt(dirfd,path);return SYSCALLS.doMknod(path,mode,dev)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall298(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),owner=SYSCALLS.get(),group=SYSCALLS.get(),flags=SYSCALLS.get();assert(flags===0);path=SYSCALLS.calculateAt(dirfd,path);FS.chown(path,owner,group);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall3(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.read(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall300(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),buf=SYSCALLS.get(),flags=SYSCALLS.get();var nofollow=flags&256;flags=flags&~256;assert(!flags,flags);path=SYSCALLS.calculateAt(dirfd,path);return SYSCALLS.doStat(nofollow?FS.lstat:FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall301(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),flags=SYSCALLS.get();path=SYSCALLS.calculateAt(dirfd,path);if(flags===0){FS.unlink(path)}else if(flags===512){FS.rmdir(path)}else{abort("Invalid flags passed to unlinkat")}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall302(which,varargs){SYSCALLS.varargs=varargs;try{var olddirfd=SYSCALLS.get(),oldpath=SYSCALLS.getStr(),newdirfd=SYSCALLS.get(),newpath=SYSCALLS.getStr();oldpath=SYSCALLS.calculateAt(olddirfd,oldpath);newpath=SYSCALLS.calculateAt(newdirfd,newpath);FS.rename(oldpath,newpath);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall303(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.EMLINK}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall304(which,varargs){SYSCALLS.varargs=varargs;try{var target=SYSCALLS.get(),newdirfd=SYSCALLS.get(),linkpath=SYSCALLS.get();linkpath=SYSCALLS.calculateAt(newdirfd,linkpath);FS.symlink(target,linkpath);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall305(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),buf=SYSCALLS.get(),bufsize=SYSCALLS.get();path=SYSCALLS.calculateAt(dirfd,path);return SYSCALLS.doReadlink(path,buf,bufsize)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall306(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),mode=SYSCALLS.get(),flags=SYSCALLS.get();assert(flags===0);path=SYSCALLS.calculateAt(dirfd,path);FS.chmod(path,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall307(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),amode=SYSCALLS.get(),flags=SYSCALLS.get();assert(flags===0);path=SYSCALLS.calculateAt(dirfd,path);return SYSCALLS.doAccess(path,amode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall308(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.ENOSYS}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall320(which,varargs){SYSCALLS.varargs=varargs;try{var dirfd=SYSCALLS.get(),path=SYSCALLS.getStr(),times=SYSCALLS.get(),flags=SYSCALLS.get();assert(flags===0);path=SYSCALLS.calculateAt(dirfd,path);var seconds=HEAP32[times>>2];var nanoseconds=HEAP32[times+4>>2];var atime=seconds*1e3+nanoseconds/(1e3*1e3);times+=8;seconds=HEAP32[times>>2];nanoseconds=HEAP32[times+4>>2];var mtime=seconds*1e3+nanoseconds/(1e3*1e3);FS.utime(path,atime,mtime);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall324(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),mode=SYSCALLS.get(),offset=SYSCALLS.get64(),len=SYSCALLS.get64();assert(mode===0);FS.allocate(stream,offset,len);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall33(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),amode=SYSCALLS.get();return SYSCALLS.doAccess(path,amode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall330(which,varargs){SYSCALLS.varargs=varargs;try{var old=SYSCALLS.getStreamFromFD(),suggestFD=SYSCALLS.get(),flags=SYSCALLS.get();assert(!flags);if(old.fd===suggestFD)return-ERRNO_CODES.EINVAL;return SYSCALLS.doDup(old.path,old.flags,suggestFD)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall331(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.ENOSYS}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall333(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get(),offset=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt,offset)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall334(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get(),offset=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt,offset)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall337(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall34(which,varargs){SYSCALLS.varargs=varargs;try{var inc=SYSCALLS.get();return-ERRNO_CODES.EPERM}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall340(which,varargs){SYSCALLS.varargs=varargs;try{var pid=SYSCALLS.get(),resource=SYSCALLS.get(),new_limit=SYSCALLS.get(),old_limit=SYSCALLS.get();if(old_limit){HEAP32[old_limit>>2]=-1;HEAP32[old_limit+4>>2]=-1;HEAP32[old_limit+8>>2]=-1;HEAP32[old_limit+12>>2]=-1}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall345(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall36(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall38(which,varargs){SYSCALLS.varargs=varargs;try{var old_path=SYSCALLS.getStr(),new_path=SYSCALLS.getStr();FS.rename(old_path,new_path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall39(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),mode=SYSCALLS.get();return SYSCALLS.doMkdir(path,mode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall4(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get(),count=SYSCALLS.get();return FS.write(stream,HEAP8,buf,count)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall40(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.rmdir(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall41(which,varargs){SYSCALLS.varargs=varargs;try{var old=SYSCALLS.getStreamFromFD();return FS.open(old.path,old.flags,0).fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var PIPEFS={BUCKET_BUFFER_SIZE:8192,mount:(function(mount){return FS.createNode(null,"/",16384|511,0)}),createPipe:(function(){var pipe={buckets:[]};pipe.buckets.push({buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:0,roffset:0});var rName=PIPEFS.nextname();var wName=PIPEFS.nextname();var rNode=FS.createNode(PIPEFS.root,rName,4096,0);var wNode=FS.createNode(PIPEFS.root,wName,4096,0);rNode.pipe=pipe;wNode.pipe=pipe;var readableStream=FS.createStream({path:rName,node:rNode,flags:FS.modeStringToFlags("r"),seekable:false,stream_ops:PIPEFS.stream_ops});rNode.stream=readableStream;var writableStream=FS.createStream({path:wName,node:wNode,flags:FS.modeStringToFlags("w"),seekable:false,stream_ops:PIPEFS.stream_ops});wNode.stream=writableStream;return{readable_fd:readableStream.fd,writable_fd:writableStream.fd}}),stream_ops:{poll:(function(stream){var pipe=stream.node.pipe;if((stream.flags&2097155)===1){return 256|4}else{if(pipe.buckets.length>0){for(var i=0;i<pipe.buckets.length;i++){var bucket=pipe.buckets[i];if(bucket.offset-bucket.roffset>0){return 64|1}}}}return 0}),ioctl:(function(stream,request,varargs){return ERRNO_CODES.EINVAL}),read:(function(stream,buffer,offset,length,position){var pipe=stream.node.pipe;var currentLength=0;for(var i=0;i<pipe.buckets.length;i++){var bucket=pipe.buckets[i];currentLength+=bucket.offset-bucket.roffset}assert(buffer instanceof ArrayBuffer||ArrayBuffer.isView(buffer));var data=buffer.subarray(offset,offset+length);if(length<=0){return 0}if(currentLength==0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}var toRead=Math.min(currentLength,length);var totalRead=toRead;var toRemove=0;for(var i=0;i<pipe.buckets.length;i++){var currBucket=pipe.buckets[i];var bucketSize=currBucket.offset-currBucket.roffset;if(toRead<=bucketSize){var tmpSlice=currBucket.buffer.subarray(currBucket.roffset,currBucket.offset);if(toRead<bucketSize){tmpSlice=tmpSlice.subarray(0,toRead);currBucket.roffset+=toRead}else{toRemove++}data.set(tmpSlice);break}else{var tmpSlice=currBucket.buffer.subarray(currBucket.roffset,currBucket.offset);data.set(tmpSlice);data=data.subarray(tmpSlice.byteLength);toRead-=tmpSlice.byteLength;toRemove++}}if(toRemove&&toRemove==pipe.buckets.length){toRemove--;pipe.buckets[toRemove].offset=0;pipe.buckets[toRemove].roffset=0}pipe.buckets.splice(0,toRemove);return totalRead}),write:(function(stream,buffer,offset,length,position){var pipe=stream.node.pipe;assert(buffer instanceof ArrayBuffer||ArrayBuffer.isView(buffer));var data=buffer.subarray(offset,offset+length);var dataLen=data.byteLength;if(dataLen<=0){return 0}var currBucket=null;if(pipe.buckets.length==0){currBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:0,roffset:0};pipe.buckets.push(currBucket)}else{currBucket=pipe.buckets[pipe.buckets.length-1]}assert(currBucket.offset<=PIPEFS.BUCKET_BUFFER_SIZE);var freeBytesInCurrBuffer=PIPEFS.BUCKET_BUFFER_SIZE-currBucket.offset;if(freeBytesInCurrBuffer>=dataLen){currBucket.buffer.set(data,currBucket.offset);currBucket.offset+=dataLen;return dataLen}else if(freeBytesInCurrBuffer>0){currBucket.buffer.set(data.subarray(0,freeBytesInCurrBuffer),currBucket.offset);currBucket.offset+=freeBytesInCurrBuffer;data=data.subarray(freeBytesInCurrBuffer,data.byteLength)}var numBuckets=data.byteLength/PIPEFS.BUCKET_BUFFER_SIZE|0;var remElements=data.byteLength%PIPEFS.BUCKET_BUFFER_SIZE;for(var i=0;i<numBuckets;i++){var newBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:PIPEFS.BUCKET_BUFFER_SIZE,roffset:0};pipe.buckets.push(newBucket);newBucket.buffer.set(data.subarray(0,PIPEFS.BUCKET_BUFFER_SIZE));data=data.subarray(PIPEFS.BUCKET_BUFFER_SIZE,data.byteLength)}if(remElements>0){var newBucket={buffer:new Uint8Array(PIPEFS.BUCKET_BUFFER_SIZE),offset:data.byteLength,roffset:0};pipe.buckets.push(newBucket);newBucket.buffer.set(data)}return dataLen}),close:(function(stream){var pipe=stream.node.pipe;pipe.buckets=null})},nextname:(function(){if(!PIPEFS.nextname.current){PIPEFS.nextname.current=0}return"pipe["+PIPEFS.nextname.current++ +"]"})};function ___syscall42(which,varargs){SYSCALLS.varargs=varargs;try{var fdPtr=SYSCALLS.get();if(fdPtr==0){throw new FS.ErrnoError(ERRNO_CODES.EFAULT)}var res=PIPEFS.createPipe();HEAP32[fdPtr>>2]=res.readable_fd;HEAP32[fdPtr+4>>2]=res.writable_fd;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall51(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.ENOSYS}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21509:case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21510:case 21511:case 21512:case 21506:case 21507:case 21508:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};case 21523:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21524:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall57(which,varargs){SYSCALLS.varargs=varargs;try{var pid=SYSCALLS.get(),pgid=SYSCALLS.get();if(pid&&pid!==PROCINFO.pid)return-ERRNO_CODES.ESRCH;if(pgid&&pgid!==PROCINFO.pgid)return-ERRNO_CODES.EPERM;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall60(which,varargs){SYSCALLS.varargs=varargs;try{var mask=SYSCALLS.get();var old=SYSCALLS.umask;SYSCALLS.umask=mask;return old}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall63(which,varargs){SYSCALLS.varargs=varargs;try{var old=SYSCALLS.getStreamFromFD(),suggestFD=SYSCALLS.get();if(old.fd===suggestFD)return suggestFD;return SYSCALLS.doDup(old.path,old.flags,suggestFD)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall64(which,varargs){SYSCALLS.varargs=varargs;try{return PROCINFO.ppid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall66(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall75(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall77(which,varargs){SYSCALLS.varargs=varargs;try{var who=SYSCALLS.get(),usage=SYSCALLS.get();_memset(usage,0,136);HEAP32[usage>>2]=1;HEAP32[usage+4>>2]=2;HEAP32[usage+8>>2]=3;HEAP32[usage+12>>2]=4;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall83(which,varargs){SYSCALLS.varargs=varargs;try{var target=SYSCALLS.getStr(),linkpath=SYSCALLS.getStr();FS.symlink(target,linkpath);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall85(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get(),bufsize=SYSCALLS.get();return SYSCALLS.doReadlink(path,buf,bufsize)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall9(which,varargs){SYSCALLS.varargs=varargs;try{var oldpath=SYSCALLS.get(),newpath=SYSCALLS.get();return-ERRNO_CODES.EMLINK}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall91(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);SYSCALLS.doMsync(addr,stream,len,info.flags);FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall94(which,varargs){SYSCALLS.varargs=varargs;try{var fd=SYSCALLS.get(),mode=SYSCALLS.get();FS.fchmod(fd,mode);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall96(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall97(which,varargs){SYSCALLS.varargs=varargs;try{return-ERRNO_CODES.EPERM}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___unlock(){}function ___wait(){}function __exit(status){exit(status)}function _abort(){Module["abort"]()}function _clock(){if(_clock.start===undefined)_clock.start=Date.now();return(Date.now()-_clock.start)*(1e6/1e3)|0}function _decrypt(bufIn,sizeIn,bufOut,sizeOut){var handler=Module.Client.getDecryptionHandler();if(handler&&Module._dvlDerivedKey){var iv=Module.HEAPU8.subarray(bufIn,bufIn+16);var input=Module.HEAPU8.subarray(bufIn+16,bufIn+sizeIn);var decrypted=handler.decrypt(Module._dvlDerivedKey,iv,input);if(decrypted&&decrypted.length!==0&&decrypted.length<=sizeOut){Module.HEAPU8.set(decrypted,bufOut);return decrypted.length}}return 0}function _derive_key(salt,password){function strlen(ptr){var i=0;while(Module.HEAPU8[ptr+i>>0]!==0){i++}return i}var handler=Module.Client.getDecryptionHandler();if(handler){var saltArray=Module.HEAPU8.subarray(salt,salt+16);var passwordArray=Module.HEAPU8.subarray(password,password+strlen(password));Module._dvlDerivedKey=handler.deriveKey(saltArray,passwordArray);return!!Module._dvlDerivedKey}return false}var DLFCN={error:null,errorMsg:null,loadedLibs:{},loadedLibNames:{}};function _dlclose(handle){if(!DLFCN.loadedLibs[handle]){DLFCN.errorMsg="Tried to dlclose() unopened handle: "+handle;return 1}else{var lib_record=DLFCN.loadedLibs[handle];if(--lib_record.refcount==0){if(lib_record.module.cleanups){lib_record.module.cleanups.forEach((function(cleanup){cleanup()}))}delete DLFCN.loadedLibNames[lib_record.name];delete DLFCN.loadedLibs[handle]}return 0}}function _dlerror(){if(DLFCN.errorMsg===null){return 0}else{if(DLFCN.error)_free(DLFCN.error);var msgArr=intArrayFromString(DLFCN.errorMsg);DLFCN.error=allocate(msgArr,"i8",ALLOC_NORMAL);DLFCN.errorMsg=null;return DLFCN.error}}function _dlopen(filenameAddr,flag){abort("To use dlopen, you need to use Emscripten's linking support, see https://github.com/kripken/emscripten/wiki/Linking");var searchpaths=[];var filename;if(filenameAddr===0){filename="__self__"}else{filename=Pointer_stringify(filenameAddr);var isValidFile=(function(filename){var target=FS.findObject(filename);return target&&!target.isFolder&&!target.isDevice});if(!isValidFile(filename)){if(ENV["LD_LIBRARY_PATH"]){searchpaths=ENV["LD_LIBRARY_PATH"].split(":")}for(var ident in searchpaths){var searchfile=PATH.join2(searchpaths[ident],filename);if(isValidFile(searchfile)){filename=searchfile;break}}}}if(DLFCN.loadedLibNames[filename]){var handle=DLFCN.loadedLibNames[filename];DLFCN.loadedLibs[handle].refcount++;return handle}var lib_module;if(filename==="__self__"){var handle=-1;lib_module=Module}else{if(Module["preloadedWasm"]!==undefined&&Module["preloadedWasm"][filename]!==undefined){lib_module=Module["preloadedWasm"][filename]}else{var target=FS.findObject(filename);if(!target||target.isFolder||target.isDevice){DLFCN.errorMsg="Could not find dynamic lib: "+filename;return 0}FS.forceLoadFile(target);try{var lib_data=FS.readFile(filename,{encoding:"utf8"});lib_module=eval(lib_data)(alignFunctionTables(),Module)}catch(e){DLFCN.errorMsg="Could not evaluate dynamic lib: "+filename+"\n"+e;return 0}}var handle=1;for(var key in DLFCN.loadedLibs){if(DLFCN.loadedLibs.hasOwnProperty(key))handle++}if(flag&256){for(var ident in lib_module){if(lib_module.hasOwnProperty(ident)){if(ident[0]=="_"){Module[ident]=lib_module[ident]}}}}}DLFCN.loadedLibs[handle]={refcount:1,name:filename,module:lib_module};DLFCN.loadedLibNames[filename]=handle;return handle}function _dlsym(handle,symbol){symbol=Pointer_stringify(symbol);if(!DLFCN.loadedLibs[handle]){DLFCN.errorMsg="Tried to dlsym() from an unopened handle: "+handle;return 0}else{var lib=DLFCN.loadedLibs[handle];symbol="_"+symbol;if(!lib.module.hasOwnProperty(symbol)){DLFCN.errorMsg='Tried to lookup unknown symbol "'+symbol+'" in dynamic lib: '+lib.name;return 0}else{var result=lib.module[symbol];if(typeof result==="function"){return addFunction(result)}return result}}}function _endgrent(){err("missing function: endgrent");abort(-1)}function _execl(){___setErrNo(ERRNO_CODES.ENOEXEC);return-1}function _fork(){___setErrNo(ERRNO_CODES.EAGAIN);return-1}var VSM={Property:{StateMask:{Offset:0,Type:"i32"},NodeFlags:{Mask:1,Offset:4,Type:"i32"},NodeFlagsMask:{Offset:8,Type:"i32"},Opacity:{Mask:2,Offset:12,Type:"float"},HighlightColor:{Mask:4,Offset:16,Type:"i32"}},data:[],getByDvlVsm:(function(dvlVsm){for(var data=VSM.data,i=0,count=data.length;i<count;++i){if(data[i].dvlVsm===dvlVsm){return data[i]}}return null}),getByNativeVsm:(function(nativeVsm){for(var data=VSM.data,i=0,count=data.length;i<count;++i){if(data[i].nativeVsm===nativeVsm){return data[i]}}return null}),getByRenderer:(function(renderer){for(var data=VSM.data,i=0,count=data.length;i<count;++i){if(data[i].dvlRenderers.indexOf(renderer)>=0){return data[i]}}return null}),add:(function(nativeVsm,dvlVsm,renderer){var item=VSM.getByNativeVsm(nativeVsm);if(item){if(item.dvlRenderers.indexOf(renderer)<0){item.dvlRenderers.push(renderer)}}else{VSM.data.push({nativeVsm:nativeVsm,dvlVsm:dvlVsm,dvlRenderers:[renderer]})}}),deleteRenderer:(function(renderer){for(var data=VSM.data,i=0,count=data.length;i<count;++i){var rendererIndex=data[i].dvlRenderers.indexOf(renderer);if(rendererIndex>=0){if(data[i].dvlRenderers.length===1){if(data[i].nativeVsm){data[i].nativeVsm.detachVisibilityChanged(VSM.handleVisibilityChanged,VSM);data[i].nativeVsm.detachSelectionChanged(VSM.handleSelectionChanged,VSM);data[i].nativeVsm.detachOpacityChanged(VSM.handleOpacityChanged,VSM);data[i].nativeVsm.detachTintColorChanged(VSM.handleTintColorChanged,VSM)}Module.ccall("jDVL_DeleteViewStateManager",null,["number"],[data[i].dvlVsm]);data.splice(i,1)}else{data[i].dvlRenderers.splice(rendererIndex,1)}return}}}),getProperty:(function(buffer,property){return getValue(buffer+property.Offset,property.Type)}),setProperty:(function(buffer,property,value){setValue(buffer+property.Offset,value,property.Type)}),handleVisibilityChanged:(function(event){var nativeVsm=event.getSource(),item=VSM.getByNativeVsm(nativeVsm);if(item){var dvlVsm=item.dvlVsm;visible=event.getParameter("visible"),hidden=event.getParameter("hidden");visible.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeVisibilityChanged",null,["number","number","boolean"],[dvlVsm,id,true])}));hidden.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeVisibilityChanged",null,["number","number","boolean"],[dvlVsm,id,false])}))}}),handleSelectionChanged:(function(event){var nativeVsm=event.getSource(),item=VSM.getByNativeVsm(nativeVsm);if(item){var dvlVsm=item.dvlVsm;selected=event.getParameter("selected"),unselected=event.getParameter("unselected");selected.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeSelectionChanged",null,["number","number","boolean"],[dvlVsm,id,true])}));unselected.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeSelectionChanged",null,["number","number","boolean"],[dvlVsm,id,false])}))}}),handleOpacityChanged:(function(event){var nativeVsm=event.getSource(),item=VSM.getByNativeVsm(nativeVsm);if(item){var dvlVsm=item.dvlVsm;changed=event.getParameter("changed"),opacity=event.getParameter("opacity");changed.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeOpacityChanged",null,["number","number","number"],[dvlVsm,id,opacity])}))}}),handleTintColorChanged:(function(event){var nativeVsm=event.getSource(),item=VSM.getByNativeVsm(nativeVsm);if(item){var dvlVsm=item.dvlVsm;changed=event.getParameter("changed"),highlightColor=event.getParameter("tintColorABGR");changed.forEach((function(nodeId){var id=stringIdToPtr(nodeId);Module.ccall("jDVL_FireNodeHighlightColorChanged",null,["number","number","number"],[dvlVsm,id,highlightColor])}))}})};function repeatString(string,count){if(string.length===0){return""}var result="";while(true){if(count&1){result+=string}count>>>=1;if(count===0){break}string+=string}return result}function padStart(string,targetLength,padString){return repeatString(padString||" ",Math.max(0,targetLength-string.length))+string}function ptrToStringId(ptrOrDvlId,prefix){return prefix+"ffffffff"+padStart(ptrOrDvlId.toString(16),8,"0")}function nodeIdToStringId(nodeId){return ptrToStringId(nodeId,"i")}function stringIdToPtr(str){return parseInt(str.substr(9),16)}function setViewStateManager(rendererId,nativeVsm){var renderer=stringIdToPtr(rendererId),result;if(nativeVsm){var item=VSM.getByNativeVsm(nativeVsm),dvlVsm=item&&item.dvlVsm;if(!item){dvlVsm=Module.ccall("jDVL_CreateViewStateManager","number",[],[]);nativeVsm.attachVisibilityChanged(VSM.handleVisibilityChanged,VSM);nativeVsm.attachSelectionChanged(VSM.handleSelectionChanged,VSM);nativeVsm.attachOpacityChanged(VSM.handleOpacityChanged,VSM);nativeVsm.attachTintColorChanged(VSM.handleTintColorChanged,VSM)}VSM.add(nativeVsm,dvlVsm,renderer);result=Module.ccall("jDVLRenderer_SetViewStateManager","number",["number","number"],[renderer,dvlVsm])}else{result=Module.ccall("jDVLRenderer_SetViewStateManager","number",["number","number"],[renderer,0]);VSM.deleteRenderer(renderer)}return result}function _getNodeState(dvlViewStateManager,nodeId,state){var item=VSM.getByDvlVsm(dvlViewStateManager),nativeVsm=item?item.nativeVsm:null,newStateMask=0;if(nativeVsm){var stateMask=VSM.getProperty(state,VSM.Property.StateMask),id=nodeIdToStringId(nodeId);if(stateMask&VSM.Property.NodeFlags.Mask){var nodeFlagsMask=VSM.getProperty(state,VSM.Property.NodeFlagsMask),nodeFlags=(nativeVsm.getImplementation&&nativeVsm.getImplementation()||nativeVsm)._getFlags(id,nodeFlagsMask);if(nodeFlags===null){VSM.setProperty(state,VSM.Property.NodeFlagsMask,0)}else{newStateMask|=VSM.Property.NodeFlags.Mask;VSM.setProperty(state,VSM.Property.NodeFlags,nodeFlags)}}if(stateMask&VSM.Property.Opacity.Mask){var opacity=nativeVsm.getOpacity(id);if(opacity!==null){newStateMask|=VSM.Property.Opacity.Mask;VSM.setProperty(state,VSM.Property.Opacity,opacity)}}if(stateMask&VSM.Property.HighlightColor.Mask){var highlightColor=(nativeVsm.getImplementation&&nativeVsm.getImplementation()||nativeVsm)._getTintColorABGR(id);if(highlightColor!==null){newStateMask|=VSM.Property.HighlightColor.Mask;VSM.setProperty(state,VSM.Property.HighlightColor,highlightColor)}}}VSM.setProperty(state,VSM.Property.StateMask,newStateMask)}function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocateUTF8(ENV[name]);return _getenv.ret}function _getgrent(){err("missing function: getgrent");abort(-1)}function _getnameinfo(sa,salen,node,nodelen,serv,servlen,flags){var info=__read_sockaddr(sa,salen);if(info.errno){return-6}var port=info.port;var addr=info.addr;var overflowed=false;if(node&&nodelen){var lookup;if(flags&1||!(lookup=DNS.lookup_addr(addr))){if(flags&8){return-2}}else{addr=lookup}var numBytesWrittenExclNull=stringToUTF8(addr,node,nodelen);if(numBytesWrittenExclNull+1>=nodelen){overflowed=true}}if(serv&&servlen){port=""+port;var numBytesWrittenExclNull=stringToUTF8(port,serv,servlen);if(numBytesWrittenExclNull+1>=servlen){overflowed=true}}if(overflowed){return-12}return 0}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}var GL={counter:1,lastError:0,buffers:[],mappedBuffers:{},programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:[],currentContext:null,offscreenCanvases:{},timerQueriesEXT:[],byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},tempFixedLengthArray:[],packAlignment:4,unpackAlignment:4,init:(function(){GL.miniTempBuffer=new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);for(var i=0;i<GL.MINI_TEMP_BUFFER_SIZE;i++){GL.miniTempBufferViews[i]=GL.miniTempBuffer.subarray(0,i+1)}for(var i=0;i<32;i++){GL.tempFixedLengthArray.push(new Array(i))}}),recordError:function recordError(errorCode){if(!GL.lastError){GL.lastError=errorCode}},getNewId:(function(table){var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}return ret}),MINI_TEMP_BUFFER_SIZE:256,miniTempBuffer:null,miniTempBufferViews:[0],getSource:(function(shader,count,string,length){var source="";for(var i=0;i<count;++i){var frag;if(length){var len=HEAP32[length+i*4>>2];if(len<0){frag=Pointer_stringify(HEAP32[string+i*4>>2])}else{frag=Pointer_stringify(HEAP32[string+i*4>>2],len)}}else{frag=Pointer_stringify(HEAP32[string+i*4>>2])}source+=frag}return source}),createContext:(function(canvas,webGLContextAttributes){if(typeof webGLContextAttributes["majorVersion"]==="undefined"&&typeof webGLContextAttributes["minorVersion"]==="undefined"){webGLContextAttributes["majorVersion"]=1;webGLContextAttributes["minorVersion"]=0}var ctx;var errorInfo="?";function onContextCreationError(event){errorInfo=event.statusMessage||errorInfo}try{canvas.addEventListener("webglcontextcreationerror",onContextCreationError,false);try{if(webGLContextAttributes["majorVersion"]==1&&webGLContextAttributes["minorVersion"]==0){ctx=canvas.getContext("webgl",webGLContextAttributes)||canvas.getContext("experimental-webgl",webGLContextAttributes)}else if(webGLContextAttributes["majorVersion"]==2&&webGLContextAttributes["minorVersion"]==0){ctx=canvas.getContext("webgl2",webGLContextAttributes)}else{throw"Unsupported WebGL context version "+majorVersion+"."+minorVersion+"!"}}finally{canvas.removeEventListener("webglcontextcreationerror",onContextCreationError,false)}if(!ctx)throw":("}catch(e){out("Could not create canvas: "+[errorInfo,e,JSON.stringify(webGLContextAttributes)]);return 0}if(!ctx)return 0;var context=GL.registerContext(ctx,webGLContextAttributes);return context}),registerContext:(function(ctx,webGLContextAttributes){var handle=GL.getNewId(GL.contexts);var context={handle:handle,attributes:webGLContextAttributes,version:webGLContextAttributes["majorVersion"],GLctx:ctx};if(ctx.canvas)ctx.canvas.GLctxObject=context;GL.contexts[handle]=context;if(typeof webGLContextAttributes["enableExtensionsByDefault"]==="undefined"||webGLContextAttributes["enableExtensionsByDefault"]){GL.initExtensions(context)}return handle}),makeContextCurrent:(function(contextHandle){var context=GL.contexts[contextHandle];if(!context)return false;GLctx=Module.ctx=context.GLctx;GL.currentContext=context;return true}),getContext:(function(contextHandle){return GL.contexts[contextHandle]}),deleteContext:(function(contextHandle){if(GL.currentContext===GL.contexts[contextHandle])GL.currentContext=null;if(typeof JSEvents==="object")JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas);if(GL.contexts[contextHandle]&&GL.contexts[contextHandle].GLctx.canvas)GL.contexts[contextHandle].GLctx.canvas.GLctxObject=undefined;GL.contexts[contextHandle]=null}),initExtensions:(function(context){if(!context)context=GL.currentContext;if(context.initExtensionsDone)return;context.initExtensionsDone=true;var GLctx=context.GLctx;context.maxVertexAttribs=GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);if(context.version<2){var instancedArraysExt=GLctx.getExtension("ANGLE_instanced_arrays");if(instancedArraysExt){GLctx["vertexAttribDivisor"]=(function(index,divisor){instancedArraysExt["vertexAttribDivisorANGLE"](index,divisor)});GLctx["drawArraysInstanced"]=(function(mode,first,count,primcount){instancedArraysExt["drawArraysInstancedANGLE"](mode,first,count,primcount)});GLctx["drawElementsInstanced"]=(function(mode,count,type,indices,primcount){instancedArraysExt["drawElementsInstancedANGLE"](mode,count,type,indices,primcount)})}var vaoExt=GLctx.getExtension("OES_vertex_array_object");if(vaoExt){GLctx["createVertexArray"]=(function(){return vaoExt["createVertexArrayOES"]()});GLctx["deleteVertexArray"]=(function(vao){vaoExt["deleteVertexArrayOES"](vao)});GLctx["bindVertexArray"]=(function(vao){vaoExt["bindVertexArrayOES"](vao)});GLctx["isVertexArray"]=(function(vao){return vaoExt["isVertexArrayOES"](vao)})}var drawBuffersExt=GLctx.getExtension("WEBGL_draw_buffers");if(drawBuffersExt){GLctx["drawBuffers"]=(function(n,bufs){drawBuffersExt["drawBuffersWEBGL"](n,bufs)})}}GLctx.disjointTimerQueryExt=GLctx.getExtension("EXT_disjoint_timer_query");var automaticallyEnabledExtensions=["OES_texture_float","OES_texture_half_float","OES_standard_derivatives","OES_vertex_array_object","WEBGL_compressed_texture_s3tc","WEBGL_depth_texture","OES_element_index_uint","EXT_texture_filter_anisotropic","EXT_frag_depth","WEBGL_draw_buffers","ANGLE_instanced_arrays","OES_texture_float_linear","OES_texture_half_float_linear","EXT_blend_minmax","EXT_shader_texture_lod","WEBGL_compressed_texture_pvrtc","EXT_color_buffer_half_float","WEBGL_color_buffer_float","EXT_sRGB","WEBGL_compressed_texture_etc1","EXT_disjoint_timer_query","WEBGL_compressed_texture_etc","WEBGL_compressed_texture_astc","EXT_color_buffer_float","WEBGL_compressed_texture_s3tc_srgb","EXT_disjoint_timer_query_webgl2"];var exts=GLctx.getSupportedExtensions();if(exts&&exts.length>0){GLctx.getSupportedExtensions().forEach((function(ext){if(automaticallyEnabledExtensions.indexOf(ext)!=-1){GLctx.getExtension(ext)}}))}}),populateUniformTable:(function(program){var p=GL.programs[program];GL.programInfos[program]={uniforms:{},maxUniformLength:0,maxAttributeLength:-1,maxUniformBlockNameLength:-1};var ptable=GL.programInfos[program];var utable=ptable.uniforms;var numUniforms=GLctx.getProgramParameter(p,GLctx.ACTIVE_UNIFORMS);for(var i=0;i<numUniforms;++i){var u=GLctx.getActiveUniform(p,i);var name=u.name;ptable.maxUniformLength=Math.max(ptable.maxUniformLength,name.length+1);if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");name=name.slice(0,ls)}var loc=GLctx.getUniformLocation(p,name);if(loc!=null){var id=GL.getNewId(GL.uniforms);utable[name]=[u.size,id];GL.uniforms[id]=loc;for(var j=1;j<u.size;++j){var n=name+"["+j+"]";loc=GLctx.getUniformLocation(p,n);id=GL.getNewId(GL.uniforms);GL.uniforms[id]=loc}}}})};function _glActiveTexture(x0){GLctx["activeTexture"](x0)}function _glAttachShader(program,shader){GLctx.attachShader(GL.programs[program],GL.shaders[shader])}function _glBindBuffer(target,buffer){var bufferObj=buffer?GL.buffers[buffer]:null;GLctx.bindBuffer(target,bufferObj)}function _glBindFramebuffer(target,framebuffer){GLctx.bindFramebuffer(target,framebuffer?GL.framebuffers[framebuffer]:null)}function _glBindRenderbuffer(target,renderbuffer){GLctx.bindRenderbuffer(target,renderbuffer?GL.renderbuffers[renderbuffer]:null)}function _glBindTexture(target,texture){GLctx.bindTexture(target,texture?GL.textures[texture]:null)}function _glBlendFuncSeparate(x0,x1,x2,x3){GLctx["blendFuncSeparate"](x0,x1,x2,x3)}function _glBufferData(target,size,data,usage){if(!data){GLctx.bufferData(target,size,usage)}else{GLctx.bufferData(target,HEAPU8.subarray(data,data+size),usage)}}function _glBufferSubData(target,offset,size,data){GLctx.bufferSubData(target,offset,HEAPU8.subarray(data,data+size))}function _glCheckFramebufferStatus(x0){return GLctx["checkFramebufferStatus"](x0)}function _glClear(x0){GLctx["clear"](x0)}function _glClearColor(x0,x1,x2,x3){GLctx["clearColor"](x0,x1,x2,x3)}function _glClearDepthf(x0){GLctx["clearDepth"](x0)}function _glColorMask(red,green,blue,alpha){GLctx.colorMask(!!red,!!green,!!blue,!!alpha)}function _glCompileShader(shader){GLctx.compileShader(GL.shaders[shader])}function _glCreateProgram(){var id=GL.getNewId(GL.programs);var program=GLctx.createProgram();program.name=id;GL.programs[id]=program;return id}function _glCreateShader(shaderType){var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id}function _glDeleteBuffers(n,buffers){for(var i=0;i<n;i++){var id=HEAP32[buffers+i*4>>2];var buffer=GL.buffers[id];if(!buffer)continue;GLctx.deleteBuffer(buffer);buffer.name=0;GL.buffers[id]=null;if(id==GL.currArrayBuffer)GL.currArrayBuffer=0;if(id==GL.currElementArrayBuffer)GL.currElementArrayBuffer=0}}function _glDeleteFramebuffers(n,framebuffers){for(var i=0;i<n;++i){var id=HEAP32[framebuffers+i*4>>2];var framebuffer=GL.framebuffers[id];if(!framebuffer)continue;GLctx.deleteFramebuffer(framebuffer);framebuffer.name=0;GL.framebuffers[id]=null}}function _glDeleteProgram(id){if(!id)return;var program=GL.programs[id];if(!program){GL.recordError(1281);return}GLctx.deleteProgram(program);program.name=0;GL.programs[id]=null;GL.programInfos[id]=null}function _glDeleteRenderbuffers(n,renderbuffers){for(var i=0;i<n;i++){var id=HEAP32[renderbuffers+i*4>>2];var renderbuffer=GL.renderbuffers[id];if(!renderbuffer)continue;GLctx.deleteRenderbuffer(renderbuffer);renderbuffer.name=0;GL.renderbuffers[id]=null}}function _glDeleteShader(id){if(!id)return;var shader=GL.shaders[id];if(!shader){GL.recordError(1281);return}GLctx.deleteShader(shader);GL.shaders[id]=null}function _glDeleteTextures(n,textures){for(var i=0;i<n;i++){var id=HEAP32[textures+i*4>>2];var texture=GL.textures[id];if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}}function _glDepthFunc(x0){GLctx["depthFunc"](x0)}function _glDepthMask(flag){GLctx.depthMask(!!flag)}function _glDisable(x0){GLctx["disable"](x0)}function _glDisableVertexAttribArray(index){GLctx.disableVertexAttribArray(index)}function _glDrawArrays(mode,first,count){GLctx.drawArrays(mode,first,count)}function _glDrawElements(mode,count,type,indices){GLctx.drawElements(mode,count,type,indices)}function _glEnable(x0){GLctx["enable"](x0)}function _glEnableVertexAttribArray(index){GLctx.enableVertexAttribArray(index)}function _glFramebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer){GLctx.framebufferRenderbuffer(target,attachment,renderbuffertarget,GL.renderbuffers[renderbuffer])}function _glFramebufferTexture2D(target,attachment,textarget,texture,level){GLctx.framebufferTexture2D(target,attachment,textarget,GL.textures[texture],level)}function _glFrontFace(x0){GLctx["frontFace"](x0)}function _glGenBuffers(n,buffers){for(var i=0;i<n;i++){var buffer=GLctx.createBuffer();if(!buffer){GL.recordError(1282);while(i<n)HEAP32[buffers+i++*4>>2]=0;return}var id=GL.getNewId(GL.buffers);buffer.name=id;GL.buffers[id]=buffer;HEAP32[buffers+i*4>>2]=id}}function _glGenFramebuffers(n,ids){for(var i=0;i<n;++i){var framebuffer=GLctx.createFramebuffer();if(!framebuffer){GL.recordError(1282);while(i<n)HEAP32[ids+i++*4>>2]=0;return}var id=GL.getNewId(GL.framebuffers);framebuffer.name=id;GL.framebuffers[id]=framebuffer;HEAP32[ids+i*4>>2]=id}}function _glGenRenderbuffers(n,renderbuffers){for(var i=0;i<n;i++){var renderbuffer=GLctx.createRenderbuffer();if(!renderbuffer){GL.recordError(1282);while(i<n)HEAP32[renderbuffers+i++*4>>2]=0;return}var id=GL.getNewId(GL.renderbuffers);renderbuffer.name=id;GL.renderbuffers[id]=renderbuffer;HEAP32[renderbuffers+i*4>>2]=id}}function _glGenTextures(n,textures){for(var i=0;i<n;i++){var texture=GLctx.createTexture();if(!texture){GL.recordError(1282);while(i<n)HEAP32[textures+i++*4>>2]=0;return}var id=GL.getNewId(GL.textures);texture.name=id;GL.textures[id]=texture;HEAP32[textures+i*4>>2]=id}}function _glGenerateMipmap(x0){GLctx["generateMipmap"](x0)}function _glGetAttribLocation(program,name){program=GL.programs[program];name=Pointer_stringify(name);return GLctx.getAttribLocation(program,name)}function _glGetError(){if(GL.lastError){var error=GL.lastError;GL.lastError=0;return error}else{return GLctx.getError()}}function emscriptenWebGLGet(name_,p,type){if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){case 36346:ret=1;break;case 36344:if(type!=="Integer"&&type!=="Integer64"){GL.recordError(1280)}return;case 36345:ret=0;break;case 34466:var formats=GLctx.getParameter(34467);ret=formats.length;break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);return;case"object":if(result===null){switch(name_){case 34964:case 35725:case 34965:case 36006:case 36007:case 32873:case 34068:{ret=0;break};default:{GL.recordError(1280);return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case"Integer":HEAP32[p+i*4>>2]=result[i];break;case"Float":HEAPF32[p+i*4>>2]=result[i];break;case"Boolean":HEAP8[p+i>>0]=result[i]?1:0;break;default:throw"internal glGet error, bad type: "+type}}return}else if(result instanceof WebGLBuffer||result instanceof WebGLProgram||result instanceof WebGLFramebuffer||result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){ret=result.name|0}else{GL.recordError(1280);return}break;default:GL.recordError(1280);return}}switch(type){case"Integer64":tempI64=[ret>>>0,(tempDouble=ret,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[p>>2]=tempI64[0],HEAP32[p+4>>2]=tempI64[1];break;case"Integer":HEAP32[p>>2]=ret;break;case"Float":HEAPF32[p>>2]=ret;break;case"Boolean":HEAP8[p>>0]=ret?1:0;break;default:throw"internal glGet error, bad type: "+type}}function _glGetFloatv(name_,p){emscriptenWebGLGet(name_,p,"Float")}function _glGetIntegerv(name_,p){emscriptenWebGLGet(name_,p,"Integer")}function _glGetProgramInfoLog(program,maxLength,length,infoLog){var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";if(maxLength>0&&infoLog){var numBytesWrittenExclNull=stringToUTF8(log,infoLog,maxLength);if(length)HEAP32[length>>2]=numBytesWrittenExclNull}else{if(length)HEAP32[length>>2]=0}}function _glGetProgramiv(program,pname,p){if(!p){GL.recordError(1281);return}if(program>=GL.counter){GL.recordError(1281);return}var ptable=GL.programInfos[program];if(!ptable){GL.recordError(1282);return}if(pname==35716){var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";HEAP32[p>>2]=log.length+1}else if(pname==35719){HEAP32[p>>2]=ptable.maxUniformLength}else if(pname==35722){if(ptable.maxAttributeLength==-1){program=GL.programs[program];var numAttribs=GLctx.getProgramParameter(program,GLctx.ACTIVE_ATTRIBUTES);ptable.maxAttributeLength=0;for(var i=0;i<numAttribs;++i){var activeAttrib=GLctx.getActiveAttrib(program,i);ptable.maxAttributeLength=Math.max(ptable.maxAttributeLength,activeAttrib.name.length+1)}}HEAP32[p>>2]=ptable.maxAttributeLength}else if(pname==35381){if(ptable.maxUniformBlockNameLength==-1){program=GL.programs[program];var numBlocks=GLctx.getProgramParameter(program,GLctx.ACTIVE_UNIFORM_BLOCKS);ptable.maxUniformBlockNameLength=0;for(var i=0;i<numBlocks;++i){var activeBlockName=GLctx.getActiveUniformBlockName(program,i);ptable.maxUniformBlockNameLength=Math.max(ptable.maxUniformBlockNameLength,activeBlockName.length+1)}}HEAP32[p>>2]=ptable.maxUniformBlockNameLength}else{HEAP32[p>>2]=GLctx.getProgramParameter(GL.programs[program],pname)}}function _glGetShaderInfoLog(shader,maxLength,length,infoLog){var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";if(maxLength>0&&infoLog){var numBytesWrittenExclNull=stringToUTF8(log,infoLog,maxLength);if(length)HEAP32[length>>2]=numBytesWrittenExclNull}else{if(length)HEAP32[length>>2]=0}}function _glGetShaderiv(shader,pname,p){if(!p){GL.recordError(1281);return}if(pname==35716){var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";HEAP32[p>>2]=log.length+1}else if(pname==35720){var source=GLctx.getShaderSource(GL.shaders[shader]);var sourceLength=source===null||source.length==0?0:source.length+1;HEAP32[p>>2]=sourceLength}else{HEAP32[p>>2]=GLctx.getShaderParameter(GL.shaders[shader],pname)}}function _glGetString(name_){if(GL.stringCache[name_])return GL.stringCache[name_];var ret;switch(name_){case 7936:case 7937:case 37445:case 37446:ret=allocate(intArrayFromString(GLctx.getParameter(name_)),"i8",ALLOC_NORMAL);break;case 7938:var glVersion=GLctx.getParameter(GLctx.VERSION);{glVersion="OpenGL ES 2.0 ("+glVersion+")"}ret=allocate(intArrayFromString(glVersion),"i8",ALLOC_NORMAL);break;case 7939:var exts=GLctx.getSupportedExtensions();var gl_exts=[];for(var i=0;i<exts.length;++i){gl_exts.push(exts[i]);gl_exts.push("GL_"+exts[i])}ret=allocate(intArrayFromString(gl_exts.join(" ")),"i8",ALLOC_NORMAL);break;case 35724:var glslVersion=GLctx.getParameter(GLctx.SHADING_LANGUAGE_VERSION);var ver_re=/^WebGL GLSL ES ([0-9]\.[0-9][0-9]?)(?:$| .*)/;var ver_num=glslVersion.match(ver_re);if(ver_num!==null){if(ver_num[1].length==3)ver_num[1]=ver_num[1]+"0";glslVersion="OpenGL ES GLSL ES "+ver_num[1]+" ("+glslVersion+")"}ret=allocate(intArrayFromString(glslVersion),"i8",ALLOC_NORMAL);break;default:GL.recordError(1280);return 0}GL.stringCache[name_]=ret;return ret}function _glGetUniformLocation(program,name){name=Pointer_stringify(name);var arrayOffset=0;if(name.indexOf("]",name.length-1)!==-1){var ls=name.lastIndexOf("[");var arrayIndex=name.slice(ls+1,-1);if(arrayIndex.length>0){arrayOffset=parseInt(arrayIndex);if(arrayOffset<0){return-1}}name=name.slice(0,ls)}var ptable=GL.programInfos[program];if(!ptable){return-1}var utable=ptable.uniforms;var uniformInfo=utable[name];if(uniformInfo&&arrayOffset<uniformInfo[0]){return uniformInfo[1]+arrayOffset}else{return-1}}function _glLineWidth(x0){GLctx["lineWidth"](x0)}function _glLinkProgram(program){GLctx.linkProgram(GL.programs[program]);GL.programInfos[program]=null;GL.populateUniformTable(program)}function _glPolygonOffset(x0,x1){GLctx["polygonOffset"](x0,x1)}function emscriptenWebGLComputeImageSize(width,height,sizePerPixel,alignment){function roundedToNextMultipleOf(x,y){return Math.floor((x+y-1)/y)*y}var plainRowSize=width*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,alignment);return height<=0?0:(height-1)*alignedRowSize+plainRowSize}function emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat){var sizePerPixel;var numChannels;switch(format){case 6406:case 6409:case 6402:numChannels=1;break;case 6410:numChannels=2;break;case 6407:case 35904:numChannels=3;break;case 6408:case 35906:numChannels=4;break;default:GL.recordError(1280);return null}switch(type){case 5121:sizePerPixel=numChannels*1;break;case 5123:case 36193:sizePerPixel=numChannels*2;break;case 5125:case 5126:sizePerPixel=numChannels*4;break;case 34042:sizePerPixel=4;break;case 33635:case 32819:case 32820:sizePerPixel=2;break;default:GL.recordError(1280);return null}var bytes=emscriptenWebGLComputeImageSize(width,height,sizePerPixel,GL.unpackAlignment);switch(type){case 5121:return HEAPU8.subarray(pixels,pixels+bytes);case 5126:return HEAPF32.subarray(pixels>>2,pixels+bytes>>2);case 5125:case 34042:return HEAPU32.subarray(pixels>>2,pixels+bytes>>2);case 5123:case 33635:case 32819:case 32820:case 36193:return HEAPU16.subarray(pixels>>1,pixels+bytes>>1);default:GL.recordError(1280);return null}}function _glReadPixels(x,y,width,height,format,type,pixels){var pixelData=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,format);if(!pixelData){GL.recordError(1280);return}GLctx.readPixels(x,y,width,height,format,type,pixelData)}function _glRenderbufferStorage(x0,x1,x2,x3){GLctx["renderbufferStorage"](x0,x1,x2,x3)}function _glScissor(x0,x1,x2,x3){GLctx["scissor"](x0,x1,x2,x3)}function _glShaderSource(shader,count,string,length){var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)}function _glStencilMask(x0){GLctx["stencilMask"](x0)}function _glTexImage2D(target,level,internalFormat,width,height,border,format,type,pixels){var pixelData=null;if(pixels)pixelData=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat);GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixelData)}function _glTexParameterf(x0,x1,x2){GLctx["texParameterf"](x0,x1,x2)}function _glTexParameteri(x0,x1,x2){GLctx["texParameteri"](x0,x1,x2)}function _glTexSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixels){var pixelData=null;if(pixels)pixelData=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,0);GLctx.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixelData)}function _glUniform1f(location,v0){GLctx.uniform1f(GL.uniforms[location],v0)}function _glUniform1i(location,v0){GLctx.uniform1i(GL.uniforms[location],v0)}function _glUniform2fv(location,count,value){var view;if(2*count<=GL.MINI_TEMP_BUFFER_SIZE){view=GL.miniTempBufferViews[2*count-1];for(var i=0;i<2*count;i+=2){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2]}}else{view=HEAPF32.subarray(value>>2,value+count*8>>2)}GLctx.uniform2fv(GL.uniforms[location],view)}function _glUniform3fv(location,count,value){var view;if(3*count<=GL.MINI_TEMP_BUFFER_SIZE){view=GL.miniTempBufferViews[3*count-1];for(var i=0;i<3*count;i+=3){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2]}}else{view=HEAPF32.subarray(value>>2,value+count*12>>2)}GLctx.uniform3fv(GL.uniforms[location],view)}function _glUniform4fv(location,count,value){var view;if(4*count<=GL.MINI_TEMP_BUFFER_SIZE){view=GL.miniTempBufferViews[4*count-1];for(var i=0;i<4*count;i+=4){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2];view[i+3]=HEAPF32[value+(4*i+12)>>2]}}else{view=HEAPF32.subarray(value>>2,value+count*16>>2)}GLctx.uniform4fv(GL.uniforms[location],view)}function _glUniformMatrix4fv(location,count,transpose,value){var view;if(16*count<=GL.MINI_TEMP_BUFFER_SIZE){view=GL.miniTempBufferViews[16*count-1];for(var i=0;i<16*count;i+=16){view[i]=HEAPF32[value+4*i>>2];view[i+1]=HEAPF32[value+(4*i+4)>>2];view[i+2]=HEAPF32[value+(4*i+8)>>2];view[i+3]=HEAPF32[value+(4*i+12)>>2];view[i+4]=HEAPF32[value+(4*i+16)>>2];view[i+5]=HEAPF32[value+(4*i+20)>>2];view[i+6]=HEAPF32[value+(4*i+24)>>2];view[i+7]=HEAPF32[value+(4*i+28)>>2];view[i+8]=HEAPF32[value+(4*i+32)>>2];view[i+9]=HEAPF32[value+(4*i+36)>>2];view[i+10]=HEAPF32[value+(4*i+40)>>2];view[i+11]=HEAPF32[value+(4*i+44)>>2];view[i+12]=HEAPF32[value+(4*i+48)>>2];view[i+13]=HEAPF32[value+(4*i+52)>>2];view[i+14]=HEAPF32[value+(4*i+56)>>2];view[i+15]=HEAPF32[value+(4*i+60)>>2]}}else{view=HEAPF32.subarray(value>>2,value+count*64>>2)}GLctx.uniformMatrix4fv(GL.uniforms[location],!!transpose,view)}function _glUseProgram(program){GLctx.useProgram(program?GL.programs[program]:null)}function _glVertexAttribPointer(index,size,type,normalized,stride,ptr){GLctx.vertexAttribPointer(index,size,type,!!normalized,stride,ptr)}function _glViewport(x0,x1,x2,x3){GLctx["viewport"](x0,x1,x2,x3)}var ___tm_timezone=allocate(intArrayFromString("GMT"),"i8",ALLOC_STATIC);function _gmtime_r(time,tmPtr){var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getUTCSeconds();HEAP32[tmPtr+4>>2]=date.getUTCMinutes();HEAP32[tmPtr+8>>2]=date.getUTCHours();HEAP32[tmPtr+12>>2]=date.getUTCDate();HEAP32[tmPtr+16>>2]=date.getUTCMonth();HEAP32[tmPtr+20>>2]=date.getUTCFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getUTCDay();HEAP32[tmPtr+36>>2]=0;HEAP32[tmPtr+32>>2]=0;var start=Date.UTC(date.getUTCFullYear(),0,1,0,0,0,0);var yday=(date.getTime()-start)/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+40>>2]=___tm_timezone;return tmPtr}function _inet_addr(ptr){var addr=__inet_pton4_raw(Pointer_stringify(ptr));if(addr===null){return-1}return addr}function _is_decryption_handler_installed(){return!!Module.Client.getDecryptionHandler()}function _kill(pid,sig){___setErrNo(ERRNO_CODES.EPERM);return-1}var _llvm_ceil_f32=Math_ceil;var _llvm_fabs_f32=Math_abs;var _llvm_fabs_f64=Math_abs;var _llvm_floor_f32=Math_floor;var _llvm_floor_f64=Math_floor;function _llvm_log10_f32(x){return Math.log(x)/Math.LN10}function _llvm_log10_f64(){return _llvm_log10_f32.apply(null,arguments)}function _llvm_stackrestore(p){var self=_llvm_stacksave;var ret=self.LLVM_SAVEDSTACKS[p];self.LLVM_SAVEDSTACKS.splice(p,1);stackRestore(ret)}function _llvm_stacksave(){var self=_llvm_stacksave;if(!self.LLVM_SAVEDSTACKS){self.LLVM_SAVEDSTACKS=[]}self.LLVM_SAVEDSTACKS.push(stackSave());return self.LLVM_SAVEDSTACKS.length-1}function _llvm_trap(){abort("trap!")}var ___tm_current=STATICTOP;STATICTOP+=48;function _tzset(){if(_tzset.called)return;_tzset.called=true;HEAP32[__get_timezone()>>2]=(new Date).getTimezoneOffset()*60;var winter=new Date(2e3,0,1);var summer=new Date(2e3,6,1);HEAP32[__get_daylight()>>2]=Number(winter.getTimezoneOffset()!=summer.getTimezoneOffset());function extractZone(date){var match=date.toTimeString().match(/\(([A-Za-z ]+)\)$/);return match?match[1]:"GMT"}var winterName=extractZone(winter);var summerName=extractZone(summer);var winterNamePtr=allocate(intArrayFromString(winterName),"i8",ALLOC_NORMAL);var summerNamePtr=allocate(intArrayFromString(summerName),"i8",ALLOC_NORMAL);if(summer.getTimezoneOffset()<winter.getTimezoneOffset()){HEAP32[__get_tzname()>>2]=winterNamePtr;HEAP32[__get_tzname()+4>>2]=summerNamePtr}else{HEAP32[__get_tzname()>>2]=summerNamePtr;HEAP32[__get_tzname()+4>>2]=winterNamePtr}}function _localtime_r(time,tmPtr){_tzset();var date=new Date(HEAP32[time>>2]*1e3);HEAP32[tmPtr>>2]=date.getSeconds();HEAP32[tmPtr+4>>2]=date.getMinutes();HEAP32[tmPtr+8>>2]=date.getHours();HEAP32[tmPtr+12>>2]=date.getDate();HEAP32[tmPtr+16>>2]=date.getMonth();HEAP32[tmPtr+20>>2]=date.getFullYear()-1900;HEAP32[tmPtr+24>>2]=date.getDay();var start=new Date(date.getFullYear(),0,1);var yday=(date.getTime()-start.getTime())/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;HEAP32[tmPtr+36>>2]=-(date.getTimezoneOffset()*60);var summerOffset=(new Date(2e3,6,1)).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=(summerOffset!=winterOffset&&date.getTimezoneOffset()==Math.min(winterOffset,summerOffset))|0;HEAP32[tmPtr+32>>2]=dst;var zonePtr=HEAP32[__get_tzname()+(dst?4:0)>>2];HEAP32[tmPtr+40>>2]=zonePtr;return tmPtr}function _localtime(time){return _localtime_r(time,___tm_current)}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}function _usleep(useconds){var msec=useconds/1e3;if((ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&self["performance"]&&self["performance"]["now"]){var start=self["performance"]["now"]();while(self["performance"]["now"]()-start<msec){}}else{var start=Date.now();while(Date.now()-start<msec){}}return 0}Module["_usleep"]=_usleep;function _nanosleep(rqtp,rmtp){var seconds=HEAP32[rqtp>>2];var nanoseconds=HEAP32[rqtp+4>>2];if(rmtp!==0){HEAP32[rmtp>>2]=0;HEAP32[rmtp+4>>2]=0}return _usleep(seconds*1e6+nanoseconds/1e3)}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Module["dynCall_vi"](routine,arg)}));_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cond_destroy(){return 0}function _pthread_cond_signal(){return 0}function _pthread_cond_timedwait(){return 0}function _pthread_cond_wait(){return 0}function _pthread_create(){return 11}function _pthread_detach(){}function _pthread_equal(x,y){return x==y}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function _pthread_join(){}var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}function _pthread_mutex_destroy(){}function _pthread_mutex_init(){}function _pthread_mutexattr_destroy(){}function _pthread_mutexattr_init(){}function _pthread_mutexattr_settype(){}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Module["dynCall_v"](func);_pthread_once.seen[ptr]=1}function _pthread_setcancelstate(){return 0}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _pthread_sigmask(){err("missing function: pthread_sigmask");abort(-1)}function _res_query(){err("missing function: res_query");abort(-1)}function _sched_yield(){return 0}function _setNodeState(dvlViewStateManager,nodeId,state){var item=VSM.getByDvlVsm(dvlViewStateManager),nativeVsm=item?item.nativeVsm:null;if(nativeVsm){var stateMask=VSM.getProperty(state,VSM.Property.StateMask),id=nodeIdToStringId(nodeId);if(stateMask&VSM.Property.NodeFlags.Mask){var nodeFlagsMask=VSM.getProperty(state,VSM.Property.NodeFlagsMask),nodeFlags=VSM.getProperty(state,VSM.Property.NodeFlags);(nativeVsm.getImplementation&&nativeVsm.getImplementation()||nativeVsm)._setFlags(id,nodeFlags,nodeFlagsMask)}if(stateMask&VSM.Property.Opacity.Mask){var opacity=VSM.getProperty(state,VSM.Property.Opacity);nativeVsm.setOpacity(id,opacity)}if(stateMask&VSM.Property.HighlightColor.Mask){var highlightColor=VSM.getProperty(state,VSM.Property.HighlightColor);nativeVsm.setTintColor(id,highlightColor)}}}function _setgrent(){err("missing function: setgrent");abort(-1)}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:var maxHeapSize=2*1024*1024*1024-16777216;return maxHeapSize/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function _setgroups(ngroups,gidset){if(ngroups<1||ngroups>_sysconf(3)){___setErrNo(ERRNO_CODES.EINVAL);return-1}else{___setErrNo(ERRNO_CODES.EPERM);return-1}}function _setitimer(){throw"setitimer() is not implemented yet"}function _sigfillset(set){HEAP32[set>>2]=-1>>>0;return 0}function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){var twelveHour=date.tm_hour;if(twelveHour==0)twelveHour=12;else if(twelveHour>12)twelveHour-=12;return leadingNulls(twelveHour,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>=0&&date.tm_hour<12){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _timegm(tmPtr){_tzset();var time=Date.UTC(HEAP32[tmPtr+20>>2]+1900,HEAP32[tmPtr+16>>2],HEAP32[tmPtr+12>>2],HEAP32[tmPtr+8>>2],HEAP32[tmPtr+4>>2],HEAP32[tmPtr>>2],0);var date=new Date(time);HEAP32[tmPtr+24>>2]=date.getUTCDay();var start=Date.UTC(date.getUTCFullYear(),0,1,0,0,0,0);var yday=(date.getTime()-start)/(1e3*60*60*24)|0;HEAP32[tmPtr+28>>2]=yday;return date.getTime()/1e3|0}function _utimes(path,times){var time;if(times){var offset=8+0;time=HEAP32[times+offset>>2]*1e3;offset=8+4;time+=HEAP32[times+offset>>2]/1e3}else{time=Date.now()}path=Pointer_stringify(path);try{FS.utime(path,time,time);return 0}catch(e){FS.handleFSError(e);return-1}}function _wait(stat_loc){___setErrNo(ERRNO_CODES.ECHILD);return-1}function _waitpid(){return _wait.apply(null,arguments)}Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){err("Module.requestFullScreen is deprecated. Please call Module.requestFullscreen instead.");Module["requestFullScreen"]=Module["requestFullscreen"];Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestFullscreen"]=function Module_requestFullscreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullscreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};if(ENVIRONMENT_IS_NODE){_emscripten_get_now=function _emscripten_get_now_actual(){var t=process["hrtime"]();return t[0]*1e3+t[1]/1e6}}else if(typeof dateNow!=="undefined"){_emscripten_get_now=dateNow}else if(typeof self==="object"&&self["performance"]&&typeof self["performance"]["now"]==="function"){_emscripten_get_now=(function(){return self["performance"]["now"]()})}else if(typeof performance==="object"&&typeof performance["now"]==="function"){_emscripten_get_now=(function(){return performance["now"]()})}else{_emscripten_get_now=Date.now}FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}__ATINIT__.push((function(){SOCKFS.root=FS.mount(SOCKFS,{},null)}));__ATINIT__.push((function(){PIPEFS.root=FS.mount(PIPEFS,{},null)}));var GLctx;GL.init();DYNAMICTOP_PTR=staticAlloc(4);STACK_BASE=STACKTOP=alignMemory(STATICTOP);STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=alignMemory(STACK_MAX);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;staticSealed=true;var ASSERTIONS=false;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,"Character code "+chr+" ("+String.fromCharCode(chr)+")  at offset "+i+" not in 0x00-0xFF.")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}var decodeBase64=typeof atob==="function"?atob:(function(input){var keyStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var output="";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output});function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE==="boolean"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,"base64")}catch(_){buf=new Buffer(s,"base64")}return new Uint8Array(buf.buffer,buf.byteOffset,buf.byteLength)}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error("Converting base64 string to bytes failed.")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}function invoke_di(index,a1){var sp=stackSave();try{return Module["dynCall_di"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_dii(index,a1,a2){var sp=stackSave();try{return Module["dynCall_dii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_i(index){var sp=stackSave();try{return Module["dynCall_i"](index)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_ii(index,a1){var sp=stackSave();try{return Module["dynCall_ii"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iid(index,a1,a2){var sp=stackSave();try{return Module["dynCall_iid"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iidd(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_iidd"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iidddd(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iidddd"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiddddii(index,a1,a2,a3,a4,a5,a6,a7){var sp=stackSave();try{return Module["dynCall_iiddddii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiddii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iiddii"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iii(index,a1,a2){var sp=stackSave();try{return Module["dynCall_iii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){var sp=stackSave();try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiid(index,a1,a2,a3,a4){var sp=stackSave();try{return Module["dynCall_iiiid"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiidii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiidiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){var sp=stackSave();try{return Module["dynCall_iiiidiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){var sp=stackSave();try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiid(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiidd(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiiidd"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){var sp=stackSave();try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){var sp=stackSave();try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){var sp=stackSave();try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){var sp=stackSave();try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_iiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){var sp=stackSave();try{return Module["dynCall_iiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_v(index){var sp=stackSave();try{Module["dynCall_v"](index)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vi(index,a1){var sp=stackSave();try{Module["dynCall_vi"](index,a1)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vid(index,a1,a2){var sp=stackSave();try{Module["dynCall_vid"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vidd(index,a1,a2,a3){var sp=stackSave();try{Module["dynCall_vidd"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vidddddd(index,a1,a2,a3,a4,a5,a6,a7){var sp=stackSave();try{Module["dynCall_vidddddd"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_vii(index,a1,a2){var sp=stackSave();try{Module["dynCall_vii"](index,a1,a2)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){var sp=stackSave();try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viidddiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13){var sp=stackSave();try{Module["dynCall_viidddiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){var sp=stackSave();try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){var sp=stackSave();try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiddddidiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){var sp=stackSave();try{Module["dynCall_viiiddddidiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiidi(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiidi"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){var sp=stackSave();try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiidiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){var sp=stackSave();try{Module["dynCall_viiiidiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){var sp=stackSave();try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){var sp=stackSave();try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){var sp=stackSave();try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiid(index,a1,a2,a3,a4,a5,a6,a7,a8){var sp=stackSave();try{Module["dynCall_viiiiiiid"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){var sp=stackSave();try{Module["dynCall_viiiiiiiiiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}function invoke_viiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13){var sp=stackSave();try{Module["dynCall_viiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13)}catch(e){stackRestore(sp);if(typeof e!=="number"&&e!=="longjmp")throw e;Module["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity,"byteLength":byteLength};Module.asmLibraryArg={"abort":abort,"assert":assert,"enlargeMemory":enlargeMemory,"getTotalMemory":getTotalMemory,"abortOnCannotGrowMemory":abortOnCannotGrowMemory,"invoke_di":invoke_di,"invoke_dii":invoke_dii,"invoke_diii":invoke_diii,"invoke_i":invoke_i,"invoke_ii":invoke_ii,"invoke_iid":invoke_iid,"invoke_iidd":invoke_iidd,"invoke_iidddd":invoke_iidddd,"invoke_iiddddii":invoke_iiddddii,"invoke_iiddii":invoke_iiddii,"invoke_iii":invoke_iii,"invoke_iiid":invoke_iiid,"invoke_iiii":invoke_iiii,"invoke_iiiid":invoke_iiiid,"invoke_iiiidii":invoke_iiiidii,"invoke_iiiidiiiiii":invoke_iiiidiiiiii,"invoke_iiiii":invoke_iiiii,"invoke_iiiiid":invoke_iiiiid,"invoke_iiiiidd":invoke_iiiiidd,"invoke_iiiiii":invoke_iiiiii,"invoke_iiiiiid":invoke_iiiiiid,"invoke_iiiiiii":invoke_iiiiiii,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_iiiiiiiii":invoke_iiiiiiiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_iiiiiiiiiiiii":invoke_iiiiiiiiiiiii,"invoke_v":invoke_v,"invoke_vi":invoke_vi,"invoke_vid":invoke_vid,"invoke_vidd":invoke_vidd,"invoke_vidddddd":invoke_vidddddd,"invoke_vii":invoke_vii,"invoke_viid":invoke_viid,"invoke_viidddiiiiiiii":invoke_viidddiiiiiiii,"invoke_viii":invoke_viii,"invoke_viiid":invoke_viiid,"invoke_viiiddddidiii":invoke_viiiddddidiii,"invoke_viiidi":invoke_viiidi,"invoke_viiii":invoke_viiii,"invoke_viiiid":invoke_viiiid,"invoke_viiiidiiiii":invoke_viiiidiiiii,"invoke_viiiii":invoke_viiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiid":invoke_viiiiiiid,"invoke_viiiiiiiiiid":invoke_viiiiiiiiiid,"invoke_viiiiiiiiiiiii":invoke_viiiiiiiiiiiii,"__ZN3dvl11Abstraction12DynamicLabel8SetImageEPKvj":__ZN3dvl11Abstraction12DynamicLabel8SetImageEPKvj,"___block_all_sigs":___block_all_sigs,"___buildEnvironment":___buildEnvironment,"___clock_gettime":___clock_gettime,"___clone":___clone,"___cxa_allocate_exception":___cxa_allocate_exception,"___cxa_begin_catch":___cxa_begin_catch,"___cxa_current_primary_exception":___cxa_current_primary_exception,"___cxa_decrement_exception_refcount":___cxa_decrement_exception_refcount,"___cxa_end_catch":___cxa_end_catch,"___cxa_find_matching_catch":___cxa_find_matching_catch,"___cxa_free_exception":___cxa_free_exception,"___cxa_increment_exception_refcount":___cxa_increment_exception_refcount,"___cxa_pure_virtual":___cxa_pure_virtual,"___cxa_rethrow":___cxa_rethrow,"___cxa_rethrow_primary_exception":___cxa_rethrow_primary_exception,"___cxa_throw":___cxa_throw,"___cxa_uncaught_exception":___cxa_uncaught_exception,"___gxx_personality_v0":___gxx_personality_v0,"___lock":___lock,"___map_file":___map_file,"___muldc3":___muldc3,"___mulsc3":___mulsc3,"___restore_sigs":___restore_sigs,"___resumeException":___resumeException,"___setErrNo":___setErrNo,"___syscall1":___syscall1,"___syscall10":___syscall10,"___syscall102":___syscall102,"___syscall114":___syscall114,"___syscall118":___syscall118,"___syscall12":___syscall12,"___syscall121":___syscall121,"___syscall122":___syscall122,"___syscall125":___syscall125,"___syscall132":___syscall132,"___syscall133":___syscall133,"___syscall14":___syscall14,"___syscall140":___syscall140,"___syscall142":___syscall142,"___syscall144":___syscall144,"___syscall145":___syscall145,"___syscall146":___syscall146,"___syscall147":___syscall147,"___syscall148":___syscall148,"___syscall15":___syscall15,"___syscall150":___syscall150,"___syscall151":___syscall151,"___syscall152":___syscall152,"___syscall153":___syscall153,"___syscall163":___syscall163,"___syscall168":___syscall168,"___syscall180":___syscall180,"___syscall181":___syscall181,"___syscall183":___syscall183,"___syscall191":___syscall191,"___syscall192":___syscall192,"___syscall193":___syscall193,"___syscall194":___syscall194,"___syscall195":___syscall195,"___syscall196":___syscall196,"___syscall197":___syscall197,"___syscall198":___syscall198,"___syscall199":___syscall199,"___syscall20":___syscall20,"___syscall200":___syscall200,"___syscall201":___syscall201,"___syscall202":___syscall202,"___syscall203":___syscall203,"___syscall204":___syscall204,"___syscall205":___syscall205,"___syscall207":___syscall207,"___syscall209":___syscall209,"___syscall211":___syscall211,"___syscall212":___syscall212,"___syscall214":___syscall214,"___syscall218":___syscall218,"___syscall219":___syscall219,"___syscall220":___syscall220,"___syscall221":___syscall221,"___syscall268":___syscall268,"___syscall269":___syscall269,"___syscall272":___syscall272,"___syscall29":___syscall29,"___syscall295":___syscall295,"___syscall296":___syscall296,"___syscall297":___syscall297,"___syscall298":___syscall298,"___syscall3":___syscall3,"___syscall300":___syscall300,"___syscall301":___syscall301,"___syscall302":___syscall302,"___syscall303":___syscall303,"___syscall304":___syscall304,"___syscall305":___syscall305,"___syscall306":___syscall306,"___syscall307":___syscall307,"___syscall308":___syscall308,"___syscall320":___syscall320,"___syscall324":___syscall324,"___syscall33":___syscall33,"___syscall330":___syscall330,"___syscall331":___syscall331,"___syscall333":___syscall333,"___syscall334":___syscall334,"___syscall337":___syscall337,"___syscall34":___syscall34,"___syscall340":___syscall340,"___syscall345":___syscall345,"___syscall36":___syscall36,"___syscall38":___syscall38,"___syscall39":___syscall39,"___syscall4":___syscall4,"___syscall40":___syscall40,"___syscall41":___syscall41,"___syscall42":___syscall42,"___syscall5":___syscall5,"___syscall51":___syscall51,"___syscall54":___syscall54,"___syscall57":___syscall57,"___syscall6":___syscall6,"___syscall60":___syscall60,"___syscall63":___syscall63,"___syscall64":___syscall64,"___syscall66":___syscall66,"___syscall75":___syscall75,"___syscall77":___syscall77,"___syscall83":___syscall83,"___syscall85":___syscall85,"___syscall9":___syscall9,"___syscall91":___syscall91,"___syscall94":___syscall94,"___syscall96":___syscall96,"___syscall97":___syscall97,"___unlock":___unlock,"___wait":___wait,"__addDays":__addDays,"__arraySum":__arraySum,"__exit":__exit,"__inet_ntop4_raw":__inet_ntop4_raw,"__inet_ntop6_raw":__inet_ntop6_raw,"__inet_pton4_raw":__inet_pton4_raw,"__inet_pton6_raw":__inet_pton6_raw,"__isLeapYear":__isLeapYear,"__read_sockaddr":__read_sockaddr,"__write_sockaddr":__write_sockaddr,"_abort":_abort,"_clock":_clock,"_clock_gettime":_clock_gettime,"_decrypt":_decrypt,"_derive_key":_derive_key,"_dlclose":_dlclose,"_dlerror":_dlerror,"_dlopen":_dlopen,"_dlsym":_dlsym,"_emscripten_asm_const_ii":_emscripten_asm_const_ii,"_emscripten_asm_const_iid":_emscripten_asm_const_iid,"_emscripten_asm_const_iidddddd":_emscripten_asm_const_iidddddd,"_emscripten_asm_const_iii":_emscripten_asm_const_iii,"_emscripten_asm_const_iiii":_emscripten_asm_const_iiii,"_emscripten_asm_const_iiiidddididiiiiiiiiiiiii":_emscripten_asm_const_iiiidddididiiiiiiiiiiiii,"_emscripten_asm_const_iiiii":_emscripten_asm_const_iiiii,"_emscripten_asm_const_iiiiii":_emscripten_asm_const_iiiiii,"_emscripten_get_now":_emscripten_get_now,"_emscripten_get_now_is_monotonic":_emscripten_get_now_is_monotonic,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_emscripten_set_main_loop":_emscripten_set_main_loop,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_endgrent":_endgrent,"_execl":_execl,"_fork":_fork,"_getNodeState":_getNodeState,"_getenv":_getenv,"_getgrent":_getgrent,"_getnameinfo":_getnameinfo,"_gettimeofday":_gettimeofday,"_glActiveTexture":_glActiveTexture,"_glAttachShader":_glAttachShader,"_glBindBuffer":_glBindBuffer,"_glBindFramebuffer":_glBindFramebuffer,"_glBindRenderbuffer":_glBindRenderbuffer,"_glBindTexture":_glBindTexture,"_glBlendFuncSeparate":_glBlendFuncSeparate,"_glBufferData":_glBufferData,"_glBufferSubData":_glBufferSubData,"_glCheckFramebufferStatus":_glCheckFramebufferStatus,"_glClear":_glClear,"_glClearColor":_glClearColor,"_glClearDepthf":_glClearDepthf,"_glColorMask":_glColorMask,"_glCompileShader":_glCompileShader,"_glCreateProgram":_glCreateProgram,"_glCreateShader":_glCreateShader,"_glDeleteBuffers":_glDeleteBuffers,"_glDeleteFramebuffers":_glDeleteFramebuffers,"_glDeleteProgram":_glDeleteProgram,"_glDeleteRenderbuffers":_glDeleteRenderbuffers,"_glDeleteShader":_glDeleteShader,"_glDeleteTextures":_glDeleteTextures,"_glDepthFunc":_glDepthFunc,"_glDepthMask":_glDepthMask,"_glDisable":_glDisable,"_glDisableVertexAttribArray":_glDisableVertexAttribArray,"_glDrawArrays":_glDrawArrays,"_glDrawElements":_glDrawElements,"_glEnable":_glEnable,"_glEnableVertexAttribArray":_glEnableVertexAttribArray,"_glFramebufferRenderbuffer":_glFramebufferRenderbuffer,"_glFramebufferTexture2D":_glFramebufferTexture2D,"_glFrontFace":_glFrontFace,"_glGenBuffers":_glGenBuffers,"_glGenFramebuffers":_glGenFramebuffers,"_glGenRenderbuffers":_glGenRenderbuffers,"_glGenTextures":_glGenTextures,"_glGenerateMipmap":_glGenerateMipmap,"_glGetAttribLocation":_glGetAttribLocation,"_glGetError":_glGetError,"_glGetFloatv":_glGetFloatv,"_glGetIntegerv":_glGetIntegerv,"_glGetProgramInfoLog":_glGetProgramInfoLog,"_glGetProgramiv":_glGetProgramiv,"_glGetShaderInfoLog":_glGetShaderInfoLog,"_glGetShaderiv":_glGetShaderiv,"_glGetString":_glGetString,"_glGetUniformLocation":_glGetUniformLocation,"_glLineWidth":_glLineWidth,"_glLinkProgram":_glLinkProgram,"_glPolygonOffset":_glPolygonOffset,"_glReadPixels":_glReadPixels,"_glRenderbufferStorage":_glRenderbufferStorage,"_glScissor":_glScissor,"_glShaderSource":_glShaderSource,"_glStencilMask":_glStencilMask,"_glTexImage2D":_glTexImage2D,"_glTexParameterf":_glTexParameterf,"_glTexParameteri":_glTexParameteri,"_glTexSubImage2D":_glTexSubImage2D,"_glUniform1f":_glUniform1f,"_glUniform1i":_glUniform1i,"_glUniform2fv":_glUniform2fv,"_glUniform3fv":_glUniform3fv,"_glUniform4fv":_glUniform4fv,"_glUniformMatrix4fv":_glUniformMatrix4fv,"_glUseProgram":_glUseProgram,"_glVertexAttribPointer":_glVertexAttribPointer,"_glViewport":_glViewport,"_gmtime_r":_gmtime_r,"_inet_addr":_inet_addr,"_is_decryption_handler_installed":_is_decryption_handler_installed,"_kill":_kill,"_llvm_ceil_f32":_llvm_ceil_f32,"_llvm_fabs_f32":_llvm_fabs_f32,"_llvm_fabs_f64":_llvm_fabs_f64,"_llvm_floor_f32":_llvm_floor_f32,"_llvm_floor_f64":_llvm_floor_f64,"_llvm_log10_f32":_llvm_log10_f32,"_llvm_log10_f64":_llvm_log10_f64,"_llvm_stackrestore":_llvm_stackrestore,"_llvm_stacksave":_llvm_stacksave,"_llvm_trap":_llvm_trap,"_localtime":_localtime,"_localtime_r":_localtime_r,"_nanosleep":_nanosleep,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_pthread_cleanup_push":_pthread_cleanup_push,"_pthread_cond_destroy":_pthread_cond_destroy,"_pthread_cond_signal":_pthread_cond_signal,"_pthread_cond_timedwait":_pthread_cond_timedwait,"_pthread_cond_wait":_pthread_cond_wait,"_pthread_create":_pthread_create,"_pthread_detach":_pthread_detach,"_pthread_equal":_pthread_equal,"_pthread_getspecific":_pthread_getspecific,"_pthread_join":_pthread_join,"_pthread_key_create":_pthread_key_create,"_pthread_mutex_destroy":_pthread_mutex_destroy,"_pthread_mutex_init":_pthread_mutex_init,"_pthread_mutexattr_destroy":_pthread_mutexattr_destroy,"_pthread_mutexattr_init":_pthread_mutexattr_init,"_pthread_mutexattr_settype":_pthread_mutexattr_settype,"_pthread_once":_pthread_once,"_pthread_setcancelstate":_pthread_setcancelstate,"_pthread_setspecific":_pthread_setspecific,"_pthread_sigmask":_pthread_sigmask,"_res_query":_res_query,"_sched_yield":_sched_yield,"_setNodeState":_setNodeState,"_setgrent":_setgrent,"_setgroups":_setgroups,"_setitimer":_setitimer,"_sigfillset":_sigfillset,"_strftime":_strftime,"_strftime_l":_strftime_l,"_sysconf":_sysconf,"_time":_time,"_timegm":_timegm,"_tzset":_tzset,"_usleep":_usleep,"_utimes":_utimes,"_wait":_wait,"_waitpid":_waitpid,"emscriptenWebGLComputeImageSize":emscriptenWebGLComputeImageSize,"emscriptenWebGLGet":emscriptenWebGLGet,"emscriptenWebGLGetTexPixelData":emscriptenWebGLGetTexPixelData,"nodeIdToStringId":nodeIdToStringId,"padStart":padStart,"ptrToStringId":ptrToStringId,"repeatString":repeatString,"setViewStateManager":setViewStateManager,"stringIdToPtr":stringIdToPtr,"DYNAMICTOP_PTR":DYNAMICTOP_PTR,"tempDoublePtr":tempDoublePtr,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX};// EMSCRIPTEN_START_ASM
var asm=(/** @suppress {uselessCode} */ function(global,env,buffer) {
"almost asm";var a=global.Int8Array;var b=new a(buffer);var c=global.Int16Array;var d=new c(buffer);var e=global.Int32Array;var f=new e(buffer);var g=global.Uint8Array;var h=new g(buffer);var i=global.Uint16Array;var j=new i(buffer);var k=global.Uint32Array;var l=new k(buffer);var m=global.Float32Array;var n=new m(buffer);var o=global.Float64Array;var p=new o(buffer);var q=global.byteLength;var r=env.DYNAMICTOP_PTR|0;var s=env.tempDoublePtr|0;var t=env.STACKTOP|0;var u=env.STACK_MAX|0;var v=0;var w=0;var x=0;var y=0;var z=global.NaN,A=global.Infinity;var B=0,C=0,D=0,E=0,F=0.0;var G=0;var H=global.Math.floor;var I=global.Math.abs;var J=global.Math.sqrt;var K=global.Math.pow;var L=global.Math.cos;var M=global.Math.sin;var N=global.Math.tan;var O=global.Math.acos;var P=global.Math.asin;var Q=global.Math.atan;var R=global.Math.atan2;var S=global.Math.exp;var T=global.Math.log;var U=global.Math.ceil;var V=global.Math.imul;var W=global.Math.min;var X=global.Math.max;var Y=global.Math.clz32;var Z=env.abort;var _=env.assert;var $=env.enlargeMemory;var aa=env.getTotalMemory;var ba=env.abortOnCannotGrowMemory;var ca=env.invoke_di;var da=env.invoke_dii;var ea=env.invoke_diii;var fa=env.invoke_i;var ga=env.invoke_ii;var ha=env.invoke_iid;var ia=env.invoke_iidd;var ja=env.invoke_iidddd;var ka=env.invoke_iiddddii;var la=env.invoke_iiddii;var ma=env.invoke_iii;var na=env.invoke_iiid;var oa=env.invoke_iiii;var pa=env.invoke_iiiid;var qa=env.invoke_iiiidii;var ra=env.invoke_iiiidiiiiii;var sa=env.invoke_iiiii;var ta=env.invoke_iiiiid;var ua=env.invoke_iiiiidd;var va=env.invoke_iiiiii;var wa=env.invoke_iiiiiid;var xa=env.invoke_iiiiiii;var ya=env.invoke_iiiiiiii;var za=env.invoke_iiiiiiiii;var Aa=env.invoke_iiiiiiiiii;var Ba=env.invoke_iiiiiiiiiii;var Ca=env.invoke_iiiiiiiiiiiii;var Da=env.invoke_v;var Ea=env.invoke_vi;var Fa=env.invoke_vid;var Ga=env.invoke_vidd;var Ha=env.invoke_vidddddd;var Ia=env.invoke_vii;var Ja=env.invoke_viid;var Ka=env.invoke_viidddiiiiiiii;var La=env.invoke_viii;var Ma=env.invoke_viiid;var Na=env.invoke_viiiddddidiii;var Oa=env.invoke_viiidi;var Pa=env.invoke_viiii;var Qa=env.invoke_viiiid;var Ra=env.invoke_viiiidiiiii;var Sa=env.invoke_viiiii;var Ta=env.invoke_viiiiii;var Ua=env.invoke_viiiiiii;var Va=env.invoke_viiiiiiid;var Wa=env.invoke_viiiiiiiiiid;var Xa=env.invoke_viiiiiiiiiiiii;var Ya=env.__ZN3dvl11Abstraction12DynamicLabel8SetImageEPKvj;var Za=env.___block_all_sigs;var _a=env.___buildEnvironment;var $a=env.___clock_gettime;var ab=env.___clone;var bb=env.___cxa_allocate_exception;var cb=env.___cxa_begin_catch;var db=env.___cxa_current_primary_exception;var eb=env.___cxa_decrement_exception_refcount;var fb=env.___cxa_end_catch;var gb=env.___cxa_find_matching_catch;var hb=env.___cxa_free_exception;var ib=env.___cxa_increment_exception_refcount;var jb=env.___cxa_pure_virtual;var kb=env.___cxa_rethrow;var lb=env.___cxa_rethrow_primary_exception;var mb=env.___cxa_throw;var nb=env.___cxa_uncaught_exception;var ob=env.___gxx_personality_v0;var pb=env.___lock;var qb=env.___map_file;var rb=env.___muldc3;var sb=env.___mulsc3;var tb=env.___restore_sigs;var ub=env.___resumeException;var vb=env.___setErrNo;var wb=env.___syscall1;var xb=env.___syscall10;var yb=env.___syscall102;var zb=env.___syscall114;var Ab=env.___syscall118;var Bb=env.___syscall12;var Cb=env.___syscall121;var Db=env.___syscall122;var Eb=env.___syscall125;var Fb=env.___syscall132;var Gb=env.___syscall133;var Hb=env.___syscall14;var Ib=env.___syscall140;var Jb=env.___syscall142;var Kb=env.___syscall144;var Lb=env.___syscall145;var Mb=env.___syscall146;var Nb=env.___syscall147;var Ob=env.___syscall148;var Pb=env.___syscall15;var Qb=env.___syscall150;var Rb=env.___syscall151;var Sb=env.___syscall152;var Tb=env.___syscall153;var Ub=env.___syscall163;var Vb=env.___syscall168;var Wb=env.___syscall180;var Xb=env.___syscall181;var Yb=env.___syscall183;var Zb=env.___syscall191;var _b=env.___syscall192;var $b=env.___syscall193;var ac=env.___syscall194;var bc=env.___syscall195;var cc=env.___syscall196;var dc=env.___syscall197;var ec=env.___syscall198;var fc=env.___syscall199;var gc=env.___syscall20;var hc=env.___syscall200;var ic=env.___syscall201;var jc=env.___syscall202;var kc=env.___syscall203;var lc=env.___syscall204;var mc=env.___syscall205;var nc=env.___syscall207;var oc=env.___syscall209;var pc=env.___syscall211;var qc=env.___syscall212;var rc=env.___syscall214;var sc=env.___syscall218;var tc=env.___syscall219;var uc=env.___syscall220;var vc=env.___syscall221;var wc=env.___syscall268;var xc=env.___syscall269;var yc=env.___syscall272;var zc=env.___syscall29;var Ac=env.___syscall295;var Bc=env.___syscall296;var Cc=env.___syscall297;var Dc=env.___syscall298;var Ec=env.___syscall3;var Fc=env.___syscall300;var Gc=env.___syscall301;var Hc=env.___syscall302;var Ic=env.___syscall303;var Jc=env.___syscall304;var Kc=env.___syscall305;var Lc=env.___syscall306;var Mc=env.___syscall307;var Nc=env.___syscall308;var Oc=env.___syscall320;var Pc=env.___syscall324;var Qc=env.___syscall33;var Rc=env.___syscall330;var Sc=env.___syscall331;var Tc=env.___syscall333;var Uc=env.___syscall334;var Vc=env.___syscall337;var Wc=env.___syscall34;var Xc=env.___syscall340;var Yc=env.___syscall345;var Zc=env.___syscall36;var _c=env.___syscall38;var $c=env.___syscall39;var ad=env.___syscall4;var bd=env.___syscall40;var cd=env.___syscall41;var dd=env.___syscall42;var ed=env.___syscall5;var fd=env.___syscall51;var gd=env.___syscall54;var hd=env.___syscall57;var id=env.___syscall6;var jd=env.___syscall60;var kd=env.___syscall63;var ld=env.___syscall64;var md=env.___syscall66;var nd=env.___syscall75;var od=env.___syscall77;var pd=env.___syscall83;var qd=env.___syscall85;var rd=env.___syscall9;var sd=env.___syscall91;var td=env.___syscall94;var ud=env.___syscall96;var vd=env.___syscall97;var wd=env.___unlock;var xd=env.___wait;var yd=env.__addDays;var zd=env.__arraySum;var Ad=env.__exit;var Bd=env.__inet_ntop4_raw;var Cd=env.__inet_ntop6_raw;var Dd=env.__inet_pton4_raw;var Ed=env.__inet_pton6_raw;var Fd=env.__isLeapYear;var Gd=env.__read_sockaddr;var Hd=env.__write_sockaddr;var Id=env._abort;var Jd=env._clock;var Kd=env._clock_gettime;var Ld=env._decrypt;var Md=env._derive_key;var Nd=env._dlclose;var Od=env._dlerror;var Pd=env._dlopen;var Qd=env._dlsym;var Rd=env._emscripten_asm_const_ii;var Sd=env._emscripten_asm_const_iid;var Td=env._emscripten_asm_const_iidddddd;var Ud=env._emscripten_asm_const_iii;var Vd=env._emscripten_asm_const_iiii;var Wd=env._emscripten_asm_const_iiiidddididiiiiiiiiiiiii;var Xd=env._emscripten_asm_const_iiiii;var Yd=env._emscripten_asm_const_iiiiii;var Zd=env._emscripten_get_now;var _d=env._emscripten_get_now_is_monotonic;var $d=env._emscripten_memcpy_big;var ae=env._emscripten_set_main_loop;var be=env._emscripten_set_main_loop_timing;var ce=env._endgrent;var de=env._execl;var ee=env._fork;var fe=env._getNodeState;var ge=env._getenv;var he=env._getgrent;var ie=env._getnameinfo;var je=env._gettimeofday;var ke=env._glActiveTexture;var le=env._glAttachShader;var me=env._glBindBuffer;var ne=env._glBindFramebuffer;var oe=env._glBindRenderbuffer;var pe=env._glBindTexture;var qe=env._glBlendFuncSeparate;var re=env._glBufferData;var se=env._glBufferSubData;var te=env._glCheckFramebufferStatus;var ue=env._glClear;var ve=env._glClearColor;var we=env._glClearDepthf;var xe=env._glColorMask;var ye=env._glCompileShader;var ze=env._glCreateProgram;var Ae=env._glCreateShader;var Be=env._glDeleteBuffers;var Ce=env._glDeleteFramebuffers;var De=env._glDeleteProgram;var Ee=env._glDeleteRenderbuffers;var Fe=env._glDeleteShader;var Ge=env._glDeleteTextures;var He=env._glDepthFunc;var Ie=env._glDepthMask;var Je=env._glDisable;var Ke=env._glDisableVertexAttribArray;var Le=env._glDrawArrays;var Me=env._glDrawElements;var Ne=env._glEnable;var Oe=env._glEnableVertexAttribArray;var Pe=env._glFramebufferRenderbuffer;var Qe=env._glFramebufferTexture2D;var Re=env._glFrontFace;var Se=env._glGenBuffers;var Te=env._glGenFramebuffers;var Ue=env._glGenRenderbuffers;var Ve=env._glGenTextures;var We=env._glGenerateMipmap;var Xe=env._glGetAttribLocation;var Ye=env._glGetError;var Ze=env._glGetFloatv;var _e=env._glGetIntegerv;var $e=env._glGetProgramInfoLog;var af=env._glGetProgramiv;var bf=env._glGetShaderInfoLog;var cf=env._glGetShaderiv;var df=env._glGetString;var ef=env._glGetUniformLocation;var ff=env._glLineWidth;var gf=env._glLinkProgram;var hf=env._glPolygonOffset;var jf=env._glReadPixels;var kf=env._glRenderbufferStorage;var lf=env._glScissor;var mf=env._glShaderSource;var nf=env._glStencilMask;var of=env._glTexImage2D;var pf=env._glTexParameterf;var qf=env._glTexParameteri;var rf=env._glTexSubImage2D;var sf=env._glUniform1f;var tf=env._glUniform1i;var uf=env._glUniform2fv;var vf=env._glUniform3fv;var wf=env._glUniform4fv;var xf=env._glUniformMatrix4fv;var yf=env._glUseProgram;var zf=env._glVertexAttribPointer;var Af=env._glViewport;var Bf=env._gmtime_r;var Cf=env._inet_addr;var Df=env._is_decryption_handler_installed;var Ef=env._kill;var Ff=env._llvm_ceil_f32;var Gf=env._llvm_fabs_f32;var Hf=env._llvm_fabs_f64;var If=env._llvm_floor_f32;var Jf=env._llvm_floor_f64;var Kf=env._llvm_log10_f32;var Lf=env._llvm_log10_f64;var Mf=env._llvm_stackrestore;var Nf=env._llvm_stacksave;var Of=env._llvm_trap;var Pf=env._localtime;var Qf=env._localtime_r;var Rf=env._nanosleep;var Sf=env._pthread_cleanup_pop;var Tf=env._pthread_cleanup_push;var Uf=env._pthread_cond_destroy;var Vf=env._pthread_cond_signal;var Wf=env._pthread_cond_timedwait;var Xf=env._pthread_cond_wait;var Yf=env._pthread_create;var Zf=env._pthread_detach;var _f=env._pthread_equal;var $f=env._pthread_getspecific;var ag=env._pthread_join;var bg=env._pthread_key_create;var cg=env._pthread_mutex_destroy;var dg=env._pthread_mutex_init;var eg=env._pthread_mutexattr_destroy;var fg=env._pthread_mutexattr_init;var gg=env._pthread_mutexattr_settype;var hg=env._pthread_once;var ig=env._pthread_setcancelstate;var jg=env._pthread_setspecific;var kg=env._pthread_sigmask;var lg=env._res_query;var mg=env._sched_yield;var ng=env._setNodeState;var og=env._setgrent;var pg=env._setgroups;var qg=env._setitimer;var rg=env._sigfillset;var sg=env._strftime;var tg=env._strftime_l;var ug=env._sysconf;var vg=env._time;var wg=env._timegm;var xg=env._tzset;var yg=env._usleep;var zg=env._utimes;var Ag=env._wait;var Bg=env._waitpid;var Cg=env.emscriptenWebGLComputeImageSize;var Dg=env.emscriptenWebGLGet;var Eg=env.emscriptenWebGLGetTexPixelData;var Fg=env.nodeIdToStringId;var Gg=env.padStart;var Hg=env.ptrToStringId;var Ig=env.repeatString;var Jg=env.setViewStateManager;var Kg=env.stringIdToPtr;var Lg=0.0;function Mg(newBuffer){if(q(newBuffer)&16777215||q(newBuffer)<=16777215||q(newBuffer)>2147483648)return false;b=new a(newBuffer);d=new c(newBuffer);f=new e(newBuffer);h=new g(newBuffer);j=new i(newBuffer);l=new k(newBuffer);n=new m(newBuffer);p=new o(newBuffer);buffer=newBuffer;return true}
// EMSCRIPTEN_START_FUNCS
function Yha(a,b,c,d,e,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0.0,m=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0,V=0,W=0,X=0,Y=0.0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0,na=0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0;Ba=t;t=t+16|0;A=Ba;ka=+n[d>>2];Y=+n[g>>2];C=ka-Y;Z=d+4|0;oa=+n[Z>>2];_=g+4|0;fa=+n[_>>2];D=oa-fa;$=d+8|0;qa=+n[$>>2];aa=g+8|0;ia=+n[aa>>2];E=qa-ia;la=+n[e>>2];F=la-Y;ba=e+4|0;pa=+n[ba>>2];G=pa-fa;ca=e+8|0;ra=+n[ca>>2];H=ra-ia;va=D*H-E*G;wa=E*F-C*H;xa=C*G-D*F;T=+n[a>>2];U=a+4|0;ga=+n[U>>2];V=a+8|0;ja=+n[V>>2];u=(T-Y)*va+(ga-fa)*wa+xa*(ja-ia);sa=+n[b>>2];ma=b+4|0;ta=+n[ma>>2];na=b+8|0;ua=+n[na>>2];B=va*(sa-Y)+wa*(ta-fa)+xa*(ua-ia);da=+n[c>>2];W=c+4|0;ea=+n[W>>2];X=c+8|0;ha=+n[X>>2];p=va*(da-Y)+wa*(ea-fa)+xa*(ha-ia);do if(!(u*B>=0.0)|!(u*p>=0.0)?(Q=sa-T,R=ta-ga,S=ua-ja,N=da-T,O=ea-ga,P=ha-ja,ya=R*P-S*O,n[A>>2]=ya,za=S*N-Q*P,n[A+4>>2]=za,Aa=Q*O-R*N,n[A+8>>2]=Aa,v=ka-da,w=oa-ea,x=qa-ha,q=x*Aa+(v*ya+w*za),y=la-da,I=pa-ea,J=ra-ha,r=J*Aa+(y*ya+I*za),K=Y-da,L=fa-ea,M=ia-ha,s=M*Aa+(K*ya+L*za),!(q*r>=0.0)|!(q*s>=0.0)):0){if(u>0.0){if(B>0.0){if(q>0.0){if(s>0.0){o=sa-da;m=ta-ea;l=ua-ha;if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<=0.0)){k=0;break}if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=r/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(J*(ua*w-v*sa)+(y*(sa*x-w*ta)+I*(v*ta-ua*x))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=r/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(r>0.0){o=sa-da;m=ta-ea;l=ua-ha;if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<=0.0)){k=0;break}if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){ua=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(M*(ua*I-y*sa)+(K*(sa*J-I*ta)+L*(y*ta-ua*J))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=s/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=T-da;m=ga-ea;l=ja-ha;if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(x*(l*I-y*m)+(v*(m*J-I*o)+w*(y*o-l*J))<=0.0)){k=0;break}if(x*(l*L-K*m)+(v*(m*M-L*o)+w*(K*o-l*M))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<0.0){k=0;break}ra=sa-da;la=ta-ea;pa=ua-ha;if(!(x*(ra*L-K*la)+(v*(la*M-L*pa)+w*(K*pa-ra*M))>=0.0)){ta=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}}k=s<0.0;if(q<0.0){if(k){o=T-da;m=ga-ea;l=ja-ha;if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(J*(l*L-K*m)+(y*(m*M-L*o)+I*(K*o-l*M))<=0.0)){k=0;break}if(J*(l*w-v*m)+(y*(m*x-w*o)+I*(v*o-l*x))>0.0){qa=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=da-qa*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=r/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<0.0){k=0;break}ja=sa-da;ga=ta-ea;ia=ua-ha;if(!(J*(ja*w-v*ga)+(y*(ga*x-w*ia)+I*(v*ia-ja*x))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=r/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(r<0.0){o=T-da;m=ga-ea;l=ja-ha;if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(M*(l*w-v*m)+(K*(m*x-w*o)+L*(v*o-l*x))<=0.0)){k=0;break}if(M*(l*I-y*m)+(K*(m*J-I*o)+L*(y*o-l*J))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=p/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<0.0){k=0;break}qa=sa-da;ka=ta-ea;oa=ua-ha;if(!(M*(qa*I-y*ka)+(K*(ka*J-I*oa)+L*(y*oa-qa*J))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=s/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=p/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=sa-da;m=ta-ea;l=ua-ha;if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<=0.0)){k=0;break}if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(x*(ua*L-K*sa)+(v*(sa*M-L*ta)+w*(K*ta-ua*M))>=0.0)){ta=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}}if(k)if(!(r>=0.0)){o=T-da;m=ga-ea;l=ja-ha;if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(x*(l*I-y*m)+(v*(m*J-I*o)+w*(y*o-l*J))<=0.0)){k=0;break}if(x*(l*L-K*m)+(v*(m*M-L*o)+w*(K*o-l*M))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<0.0){k=0;break}ra=sa-da;la=ta-ea;pa=ua-ha;if(!(x*(ra*L-K*la)+(v*(la*M-L*pa)+w*(K*pa-ra*M))>=0.0)){ta=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=sa-da;m=ta-ea;l=ua-ha;if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<=0.0)){k=0;break}if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){ua=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(M*(ua*I-y*sa)+(K*(sa*J-I*ta)+L*(y*ta-ua*J))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=s/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}k=r>0.0;if(s>0.0)if(k){o=sa-da;m=ta-ea;l=ua-ha;if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<=0.0)){k=0;break}if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(x*(ua*L-K*sa)+(v*(sa*M-L*ta)+w*(K*ta-ua*M))>=0.0)){ta=q/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=T-da;m=ga-ea;l=ja-ha;if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(M*(l*w-v*m)+(K*(m*x-w*o)+L*(v*o-l*x))<=0.0)){k=0;break}if(M*(l*I-y*m)+(K*(m*J-I*o)+L*(y*o-l*J))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=p/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<0.0){k=0;break}qa=sa-da;ka=ta-ea;oa=ua-ha;if(!(M*(qa*I-y*ka)+(K*(ka*J-I*oa)+L*(y*oa-qa*J))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=s/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=p/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(k){o=T-da;m=ga-ea;l=ja-ha;if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(J*(l*L-K*m)+(y*(m*M-L*o)+I*(K*o-l*M))<=0.0)){k=0;break}if(J*(l*w-v*m)+(y*(m*x-w*o)+I*(v*o-l*x))>0.0){qa=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=da-qa*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=r/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<0.0){k=0;break}ja=sa-da;ga=ta-ea;ia=ua-ha;if(!(J*(ja*w-v*ga)+(y*(ga*x-w*ia)+I*(v*ia-ja*x))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=r/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(!(r<0.0)){f[h>>2]=1;k=Vha(c,a,b,d,g,e,A,0)|0;break}o=sa-da;m=ta-ea;l=ua-ha;if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<=0.0)){k=0;break}if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=r/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(J*(ua*w-v*sa)+(y*(sa*x-w*ta)+I*(v*ta-ua*x))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=r/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}k=q>0.0;if(p>0.0){if(k){if(s>0.0){y=T-sa;x=ga-ta;s=ja-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}ia=ka-sa;ga=oa-ta;ja=qa-ua;if(w*(ga*l-ia*m)+(u*(ja*m-ga*o)+v*(ia*o-ja*l))>0.0){ka=sa-da;oa=ta-ea;qa=ua-ha;ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*ka+wa*oa+xa*qa);n[i>>2]=sa-ka*ua;n[i+4>>2]=+n[ma>>2]-oa*ua;n[i+8>>2]=+n[na>>2]-qa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ja=da-sa;ga=ea-ta;ia=ha-ua;if(!(w*(m*ja-l*ga)+(u*(o*ga-m*ia)+v*(l*ia-o*ja))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(r>0.0){y=T-sa;x=ga-ta;s=ja-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}oa=la-sa;ka=pa-ta;qa=ra-ua;if(w*(ka*l-oa*m)+(u*(qa*m-ka*o)+v*(oa*o-qa*l))>0.0){qa=sa-da;ra=ta-ea;ta=ua-ha;ua=B/(va*qa+wa*ra+xa*ta);n[i>>2]=sa-qa*ua;n[i+4>>2]=+n[ma>>2]-ra*ua;n[i+8>>2]=+n[na>>2]-ta*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}qa=da-sa;ka=ea-ta;oa=ha-ua;if(!(w*(m*qa-l*ka)+(u*(o*ka-m*oa)+v*(l*oa-o*qa))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=B/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=da-sa;x=ea-ta;s=ha-ua;r=la-sa;q=pa-ta;p=ra-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}pa=Y-sa;la=fa-ta;ra=ia-ua;if(w*(o*la-pa*m)+(u*(m*ra-la*l)+v*(pa*l-o*ra))>0.0){ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(m*y-o*x)+(u*(l*x-m*s)+v*(o*s-l*y))<0.0){k=0;break}ra=T-sa;la=ga-ta;pa=ja-ua;if(!(w*(ra*m-o*la)+(u*(la*l-m*pa)+v*(o*pa-ra*l))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}}k=s<0.0;if(q<0.0){if(k){y=da-sa;x=ea-ta;s=ha-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ia=ka-sa;ha=oa-ta;ja=qa-ua;if(w*(o*ha-ia*m)+(u*(m*ja-ha*l)+v*(ia*l-o*ja))>0.0){ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ia=T-sa;ha=ga-ta;ja=ja-ua;if(!(w*(ia*m-l*ha)+(u*(ha*o-m*ja)+v*(l*ja-ia*o))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(r<0.0){y=da-sa;x=ea-ta;s=ha-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}qa=la-sa;ta=pa-ta;ua=ra-ua;if(w*(o*ta-qa*m)+(u*(m*ua-ta*l)+v*(qa*l-o*ua))>0.0){ua=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}qa=T-sa;ta=ga-ta;ua=ja-ua;if(!(w*(qa*m-l*ta)+(u*(ta*o-m*ua)+v*(l*ua-qa*o))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=T-sa;x=ga-ta;s=ja-ua;r=la-sa;q=pa-ta;p=ra-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}pa=Y-sa;la=fa-ta;ra=ia-ua;if(w*(la*l-pa*m)+(u*(ra*m-la*o)+v*(pa*o-ra*l))>0.0){la=sa-da;pa=ta-ea;ra=ua-ha;ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*la+wa*pa+xa*ra);n[i>>2]=sa-la*ua;n[i+4>>2]=+n[ma>>2]-pa*ua;n[i+8>>2]=+n[na>>2]-ra*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(y*m-o*x)+(u*(x*l-m*s)+v*(o*s-y*l))<0.0){k=0;break}ra=da-sa;la=ea-ta;pa=ha-ua;if(!(w*(m*ra-o*la)+(u*(l*la-m*pa)+v*(o*pa-l*ra))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}}if(k)if(!(r>=0.0)){y=da-sa;x=ea-ta;s=ha-ua;r=la-sa;q=pa-ta;p=ra-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}pa=Y-sa;la=fa-ta;ra=ia-ua;if(w*(o*la-pa*m)+(u*(m*ra-la*l)+v*(pa*l-o*ra))>0.0){ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(m*y-o*x)+(u*(l*x-m*s)+v*(o*s-l*y))<0.0){k=0;break}ra=T-sa;la=ga-ta;pa=ja-ua;if(!(w*(ra*m-o*la)+(u*(la*l-m*pa)+v*(o*pa-ra*l))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=T-sa;x=ga-ta;s=ja-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}oa=la-sa;ka=pa-ta;qa=ra-ua;if(w*(ka*l-oa*m)+(u*(qa*m-ka*o)+v*(oa*o-qa*l))>0.0){qa=sa-da;ra=ta-ea;ta=ua-ha;ua=B/(va*qa+wa*ra+xa*ta);n[i>>2]=sa-qa*ua;n[i+4>>2]=+n[ma>>2]-ra*ua;n[i+8>>2]=+n[na>>2]-ta*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}qa=da-sa;ka=ea-ta;oa=ha-ua;if(!(w*(m*qa-l*ka)+(u*(o*ka-m*oa)+v*(l*oa-o*qa))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=B/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}k=r>0.0;if(s>0.0)if(k){y=T-sa;x=ga-ta;s=ja-ua;r=la-sa;q=pa-ta;p=ra-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}pa=Y-sa;la=fa-ta;ra=ia-ua;if(w*(la*l-pa*m)+(u*(ra*m-la*o)+v*(pa*o-ra*l))>0.0){la=sa-da;pa=ta-ea;ra=ua-ha;ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*la+wa*pa+xa*ra);n[i>>2]=sa-la*ua;n[i+4>>2]=+n[ma>>2]-pa*ua;n[i+8>>2]=+n[na>>2]-ra*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(y*m-o*x)+(u*(x*l-m*s)+v*(o*s-y*l))<0.0){k=0;break}ra=da-sa;la=ea-ta;pa=ha-ua;if(!(w*(m*ra-o*la)+(u*(l*la-m*pa)+v*(o*pa-l*ra))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=da-sa;x=ea-ta;s=ha-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}qa=la-sa;ta=pa-ta;ua=ra-ua;if(w*(o*ta-qa*m)+(u*(m*ua-ta*l)+v*(qa*l-o*ua))>0.0){ua=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}qa=T-sa;ta=ga-ta;ua=ja-ua;if(!(w*(qa*m-l*ta)+(u*(ta*o-m*ua)+v*(l*ua-qa*o))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(k){y=da-sa;x=ea-ta;s=ha-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ia=ka-sa;ha=oa-ta;ja=qa-ua;if(w*(o*ha-ia*m)+(u*(m*ja-ha*l)+v*(ia*l-o*ja))>0.0){ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ia=T-sa;ha=ga-ta;ja=ja-ua;if(!(w*(ia*m-l*ha)+(u*(ha*o-m*ja)+v*(l*ja-ia*o))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(!(r<0.0)){f[h>>2]=1;k=Vha(b,c,a,d,g,e,A,0)|0;break}y=T-sa;x=ga-ta;s=ja-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}ia=ka-sa;ga=oa-ta;ja=qa-ua;if(w*(ga*l-ia*m)+(u*(ja*m-ga*o)+v*(ia*o-ja*l))>0.0){ka=sa-da;oa=ta-ea;qa=ua-ha;ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*ka+wa*oa+xa*qa);n[i>>2]=sa-ka*ua;n[i+4>>2]=+n[ma>>2]-oa*ua;n[i+8>>2]=+n[na>>2]-qa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ja=da-sa;ga=ea-ta;ia=ha-ua;if(!(w*(m*ja-l*ga)+(u*(o*ga-m*ia)+v*(l*ia-o*ja))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{if(k){if(r>0.0){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=ka-T;la=oa-ga;ra=qa-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(s>0.0){o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=Y-T;ka=fa-ga;qa=ia-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}k=r<0.0;if(q<0.0){if(k){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(s<0.0){o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=la-T;fa=pa-ga;ia=ra-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}if(k)if(!(s>=0.0)){o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=Y-T;ka=fa-ga;qa=ia-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}k=s>0.0;if(r>0.0)if(k){o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=la-T;fa=pa-ga;ia=ra-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(k){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(!(s<0.0)){f[h>>2]=1;k=Vha(a,b,c,d,e,g,A,0)|0;break}o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=ka-T;la=oa-ga;ra=qa-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}k=B<0.0;if(u<0.0){if(k){if(q>0.0){if(r>0.0){o=sa-da;m=ta-ea;l=ua-ha;if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<=0.0)){k=0;break}if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){ua=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(M*(ua*w-v*sa)+(K*(sa*x-w*ta)+L*(v*ta-ua*x))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=s/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(s>0.0){o=sa-da;m=ta-ea;l=ua-ha;if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<=0.0)){k=0;break}if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(J*(ua*L-K*sa)+(y*(sa*M-L*ta)+I*(K*ta-ua*M))>=0.0)){ta=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=T-da;m=ga-ea;l=ja-ha;if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(x*(l*L-K*m)+(v*(m*M-L*o)+w*(K*o-l*M))<=0.0)){k=0;break}if(x*(l*I-y*m)+(v*(m*J-I*o)+w*(y*o-l*J))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=q/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<0.0){k=0;break}ja=sa-da;ga=ta-ea;ia=ua-ha;if(!(x*(ja*I-y*ga)+(v*(ga*J-I*ia)+w*(y*ia-ja*J))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=q/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}}k=r<0.0;if(q<0.0){if(k){o=T-da;m=ga-ea;l=ja-ha;if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(M*(l*I-y*m)+(K*(m*J-I*o)+L*(y*o-l*J))<=0.0)){k=0;break}if(M*(l*w-v*m)+(K*(m*x-w*o)+L*(v*o-l*x))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=p/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<0.0){k=0;break}ra=sa-da;la=ta-ea;pa=ua-ha;if(!(M*(ra*w-v*la)+(K*(la*x-w*pa)+L*(v*pa-ra*x))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=s/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=p/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(s<0.0){o=T-da;m=ga-ea;l=ja-ha;if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(J*(l*w-v*m)+(y*(m*x-w*o)+I*(v*o-l*x))<=0.0)){k=0;break}if(J*(l*L-K*m)+(y*(m*M-L*o)+I*(K*o-l*M))>0.0){qa=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=da-qa*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<0.0){k=0;break}qa=sa-da;ka=ta-ea;oa=ua-ha;if(!(J*(qa*L-K*ka)+(y*(ka*M-L*oa)+I*(K*oa-qa*M))>=0.0)){ta=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=sa-da;m=ta-ea;l=ua-ha;if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<=0.0)){k=0;break}if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=q/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(x*(ua*I-y*sa)+(v*(sa*J-I*ta)+w*(y*ta-ua*J))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=q/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}}if(k)if(!(s>=0.0)){o=T-da;m=ga-ea;l=ja-ha;if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(x*(l*L-K*m)+(v*(m*M-L*o)+w*(K*o-l*M))<=0.0)){k=0;break}if(x*(l*I-y*m)+(v*(m*J-I*o)+w*(y*o-l*J))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=q/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<0.0){k=0;break}ja=sa-da;ga=ta-ea;ia=ua-ha;if(!(x*(ja*I-y*ga)+(v*(ga*J-I*ia)+w*(y*ia-ja*J))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=q/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=sa-da;m=ta-ea;l=ua-ha;if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))<=0.0)){k=0;break}if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))>0.0){ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(J*(ua*L-K*sa)+(y*(sa*M-L*ta)+I*(K*ta-ua*M))>=0.0)){ta=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}k=s>0.0;if(r>0.0)if(k){o=sa-da;m=ta-ea;l=ua-ha;if(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(x*(o*L-K*m)+(v*(m*M-L*l)+w*(K*l-o*M))<=0.0)){k=0;break}if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))>0.0){ua=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=q/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{if(x*(o*I-y*m)+(v*(m*J-I*l)+w*(y*l-o*J))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(x*(ua*I-y*sa)+(v*(sa*J-I*ta)+w*(y*ta-ua*J))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=q/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=(va*(da-ka)+wa*(ea-oa)+xa*(ha-qa))/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}else{o=T-da;m=ga-ea;l=ja-ha;if(J*(o*w-v*m)+(y*(m*x-w*l)+I*(v*l-o*x))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(J*(l*w-v*m)+(y*(m*x-w*o)+I*(v*o-l*x))<=0.0)){k=0;break}if(J*(l*L-K*m)+(y*(m*M-L*o)+I*(K*o-l*M))>0.0){qa=da-sa;ta=ea-ta;sa=ha-ua;ua=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=da-qa*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{if(J*(o*L-K*m)+(y*(m*M-L*l)+I*(K*l-o*M))<0.0){k=0;break}qa=sa-da;ka=ta-ea;oa=ua-ha;if(!(J*(qa*L-K*ka)+(y*(ka*M-L*oa)+I*(K*oa-qa*M))>=0.0)){ta=r/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=(va*(da-la)+wa*(ea-pa)+xa*(ha-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(k){o=T-da;m=ga-ea;l=ja-ha;if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){l=sa-da;m=ta-ea;o=ua-ha;if(!(M*(l*I-y*m)+(K*(m*J-I*o)+L*(y*o-l*J))<=0.0)){k=0;break}if(M*(l*w-v*m)+(K*(m*x-w*o)+L*(v*o-l*x))>0.0){ra=da-sa;ta=ea-ta;sa=ha-ua;ua=p/(va*ra+wa*ta+xa*sa);n[i>>2]=da-ra*ua;n[i+4>>2]=+n[W>>2]-ta*ua;n[i+8>>2]=+n[X>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<0.0){k=0;break}ra=sa-da;la=ta-ea;pa=ua-ha;if(!(M*(ra*w-v*la)+(K*(la*x-w*pa)+L*(v*pa-ra*x))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=s/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ya=da-sa;Aa=ea-ta;sa=ha-ua;ta=p/(va*ya+wa*Aa+xa*sa);n[i>>2]=da-ya*ta;n[i+4>>2]=+n[W>>2]-Aa*ta;n[i+8>>2]=+n[X>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}if(!(s<0.0)){f[h>>2]=1;k=Vha(c,a,b,d,e,g,A,0)|0;break}o=sa-da;m=ta-ea;l=ua-ha;if(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))>0.0){o=T-da;m=ga-ea;l=ja-ha;if(!(M*(o*I-y*m)+(K*(m*J-I*l)+L*(y*l-o*J))<=0.0)){k=0;break}if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))>0.0){ua=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ua;n[i+4>>2]=+n[W>>2]-O*ua;n[i+8>>2]=+n[X>>2]-P*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=s/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[c>>2])+za*(sa-+n[W>>2])+Aa*(ta-+n[X>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{if(M*(o*w-v*m)+(K*(m*x-w*l)+L*(v*l-o*x))<0.0){k=0;break}ua=T-da;sa=ga-ea;ta=ja-ha;if(!(M*(ua*w-v*sa)+(K*(sa*x-w*ta)+L*(v*ta-ua*x))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=s/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}else{ta=p/(va*N+wa*O+xa*P);n[i>>2]=da-N*ta;n[i+4>>2]=+n[W>>2]-O*ta;n[i+8>>2]=+n[X>>2]-P*ta;ta=+n[c>>2];sa=+n[W>>2];Aa=+n[X>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[W>>2]-ya*Aa;n[j+8>>2]=+n[X>>2]-za*Aa;k=1;break}}}k=q>0.0;if(p<0.0){if(k){if(r>0.0){y=T-sa;x=ga-ta;s=ja-ua;r=la-sa;q=pa-ta;p=ra-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}pa=ka-sa;la=oa-ta;ra=qa-ua;if(w*(la*l-pa*m)+(u*(ra*m-la*o)+v*(pa*o-ra*l))>0.0){qa=sa-da;ra=ta-ea;ta=ua-ha;ua=B/(va*qa+wa*ra+xa*ta);n[i>>2]=sa-qa*ua;n[i+4>>2]=+n[ma>>2]-ra*ua;n[i+8>>2]=+n[na>>2]-ta*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ra=da-sa;la=ea-ta;pa=ha-ua;if(!(w*(m*ra-l*la)+(u*(o*la-m*pa)+v*(l*pa-o*ra))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=B/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(s>0.0){y=T-sa;x=ga-ta;s=ja-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}oa=Y-sa;ka=fa-ta;qa=ia-ua;if(w*(ka*l-oa*m)+(u*(qa*m-ka*o)+v*(oa*o-qa*l))>0.0){ka=sa-da;oa=ta-ea;qa=ua-ha;ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*ka+wa*oa+xa*qa);n[i>>2]=sa-ka*ua;n[i+4>>2]=+n[ma>>2]-oa*ua;n[i+8>>2]=+n[na>>2]-qa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(y*m-o*x)+(u*(x*l-m*s)+v*(o*s-y*l))<0.0){k=0;break}qa=da-sa;ka=ea-ta;oa=ha-ua;if(!(w*(m*qa-o*ka)+(u*(l*ka-m*oa)+v*(o*oa-l*qa))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=da-sa;x=ea-ta;s=ha-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ia=la-sa;ha=pa-ta;ja=ra-ua;if(w*(o*ha-ia*m)+(u*(m*ja-ha*l)+v*(ia*l-o*ja))>0.0){ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ia=T-sa;ha=ga-ta;ja=ja-ua;if(!(w*(ia*m-l*ha)+(u*(ha*o-m*ja)+v*(l*ja-ia*o))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}}k=r<0.0;if(q<0.0){if(k){y=da-sa;x=ea-ta;s=ha-ua;r=la-sa;q=pa-ta;p=ra-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ra=ka-sa;ta=oa-ta;ua=qa-ua;if(w*(o*ta-ra*m)+(u*(m*ua-ta*l)+v*(ra*l-o*ua))>0.0){ua=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ra=T-sa;ta=ga-ta;ua=ja-ua;if(!(w*(ra*m-l*ta)+(u*(ta*o-m*ua)+v*(l*ua-ra*o))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(s<0.0){y=da-sa;x=ea-ta;s=ha-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}oa=Y-sa;ka=fa-ta;qa=ia-ua;if(w*(o*ka-oa*m)+(u*(m*qa-ka*l)+v*(oa*l-o*qa))>0.0){ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(m*y-o*x)+(u*(l*x-m*s)+v*(o*s-l*y))<0.0){k=0;break}qa=T-sa;ka=ga-ta;oa=ja-ua;if(!(w*(qa*m-o*ka)+(u*(ka*l-m*oa)+v*(o*oa-qa*l))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=T-sa;x=ga-ta;s=ja-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}ia=la-sa;ga=pa-ta;ja=ra-ua;if(w*(ga*l-ia*m)+(u*(ja*m-ga*o)+v*(ia*o-ja*l))>0.0){la=sa-da;pa=ta-ea;ra=ua-ha;ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*la+wa*pa+xa*ra);n[i>>2]=sa-la*ua;n[i+4>>2]=+n[ma>>2]-pa*ua;n[i+8>>2]=+n[na>>2]-ra*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ja=da-sa;ga=ea-ta;ia=ha-ua;if(!(w*(m*ja-l*ga)+(u*(o*ga-m*ia)+v*(l*ia-o*ja))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}}if(k)if(!(s>=0.0)){y=da-sa;x=ea-ta;s=ha-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ia=la-sa;ha=pa-ta;ja=ra-ua;if(w*(o*ha-ia*m)+(u*(m*ja-ha*l)+v*(ia*l-o*ja))>0.0){ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ia=T-sa;ha=ga-ta;ja=ja-ua;if(!(w*(ia*m-l*ha)+(u*(ha*o-m*ja)+v*(l*ja-ia*o))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=T-sa;x=ga-ta;s=ja-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}oa=Y-sa;ka=fa-ta;qa=ia-ua;if(w*(ka*l-oa*m)+(u*(qa*m-ka*o)+v*(oa*o-qa*l))>0.0){ka=sa-da;oa=ta-ea;qa=ua-ha;ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*ka+wa*oa+xa*qa);n[i>>2]=sa-ka*ua;n[i+4>>2]=+n[ma>>2]-oa*ua;n[i+8>>2]=+n[na>>2]-qa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(y*m-o*x)+(u*(x*l-m*s)+v*(o*s-y*l))<0.0){k=0;break}qa=da-sa;ka=ea-ta;oa=ha-ua;if(!(w*(m*qa-o*ka)+(u*(l*ka-m*oa)+v*(o*oa-l*qa))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}k=s>0.0;if(r>0.0)if(k){y=T-sa;x=ga-ta;s=ja-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=ka-sa;v=oa-ta;w=qa-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}ia=la-sa;ga=pa-ta;ja=ra-ua;if(w*(ga*l-ia*m)+(u*(ja*m-ga*o)+v*(ia*o-ja*l))>0.0){la=sa-da;pa=ta-ea;ra=ua-ha;ua=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*la+wa*pa+xa*ra);n[i>>2]=sa-la*ua;n[i+4>>2]=+n[ma>>2]-pa*ua;n[i+8>>2]=+n[na>>2]-ra*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-sa;m=pa-ta;o=ra-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ja=da-sa;ga=ea-ta;ia=ha-ua;if(!(w*(m*ja-l*ga)+(u*(o*ga-m*ia)+v*(l*ia-o*ja))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=(va*(sa-ka)+wa*(ta-oa)+xa*(ua-qa))/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{y=da-sa;x=ea-ta;s=ha-ua;r=ka-sa;q=oa-ta;p=qa-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}oa=Y-sa;ka=fa-ta;qa=ia-ua;if(w*(o*ka-oa*m)+(u*(m*qa-ka*l)+v*(oa*l-o*qa))>0.0){ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-sa;m=fa-ta;l=ia-ua;if(w*(m*y-o*x)+(u*(l*x-m*s)+v*(o*s-l*y))<0.0){k=0;break}qa=T-sa;ka=ga-ta;oa=ja-ua;if(!(w*(qa*m-o*ka)+(u*(ka*l-m*oa)+v*(o*oa-qa*l))>=0.0)){ta=(w*Aa+(u*ya+v*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(k){y=da-sa;x=ea-ta;s=ha-ua;r=la-sa;q=pa-ta;p=ra-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(q*y-r*x)+(u*(p*x-q*s)+v*(r*s-p*y))>0.0){o=T-sa;m=ga-ta;l=ja-ua;if(!(w*(o*q-r*m)+(u*(m*p-q*l)+v*(r*l-o*p))<=0.0)){k=0;break}ra=ka-sa;ta=oa-ta;ua=qa-ua;if(w*(o*ta-ra*m)+(u*(m*ua-ta*l)+v*(ra*l-o*ua))>0.0){ua=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ua;n[i+4>>2]=+n[ma>>2]-R*ua;n[i+8>>2]=+n[na>>2]-S*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(m*y-l*x)+(u*(o*x-m*s)+v*(l*s-o*y))<0.0){k=0;break}ra=T-sa;ta=ga-ta;ua=ja-ua;if(!(w*(ra*m-l*ta)+(u*(ta*o-m*ua)+v*(l*ua-ra*o))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{ta=B/(va*Q+wa*R+xa*S);n[i>>2]=sa-Q*ta;n[i+4>>2]=+n[ma>>2]-R*ta;n[i+8>>2]=+n[na>>2]-S*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}if(!(s<0.0)){f[h>>2]=1;k=Vha(b,c,a,d,e,g,A,0)|0;break}y=T-sa;x=ga-ta;s=ja-ua;r=la-sa;q=pa-ta;p=ra-ua;u=Y-sa;v=fa-ta;w=ia-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}pa=ka-sa;la=oa-ta;ra=qa-ua;if(w*(la*l-pa*m)+(u*(ra*m-la*o)+v*(pa*o-ra*l))>0.0){qa=sa-da;ra=ta-ea;ta=ua-ha;ua=B/(va*qa+wa*ra+xa*ta);n[i>>2]=sa-qa*ua;n[i+4>>2]=+n[ma>>2]-ra*ua;n[i+8>>2]=+n[na>>2]-ta*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-sa;m=oa-ta;o=qa-ua;if(w*(y*m-l*x)+(u*(x*o-m*s)+v*(l*s-y*o))<0.0){k=0;break}ra=da-sa;la=ea-ta;pa=ha-ua;if(!(w*(m*ra-l*la)+(u*(o*la-m*pa)+v*(l*pa-o*ra))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(w*Aa+(u*ya+v*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}else{za=sa-da;ya=ta-ea;Aa=ua-ha;ta=B/(va*za+wa*ya+xa*Aa);n[i>>2]=sa-za*ta;n[i+4>>2]=+n[ma>>2]-ya*ta;n[i+8>>2]=+n[na>>2]-Aa*ta;ta=+n[b>>2];sa=+n[ma>>2];Aa=+n[na>>2];ua=ta-+n[a>>2];ya=sa-+n[U>>2];za=Aa-+n[V>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[ma>>2]-ya*Aa;n[j+8>>2]=+n[na>>2]-za*Aa;k=1;break}}}else{if(k){if(s>0.0){o=Y-T;m=fa-ga;l=ia-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=ka-T;fa=oa-ga;ia=qa-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(r>0.0){o=ka-T;m=oa-ga;l=qa-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=la-T;ka=pa-ga;qa=ra-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=la-T;m=pa-ga;l=ra-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}k=s<0.0;if(q<0.0){if(k){o=Y-T;m=fa-ga;l=ia-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(r<0.0){o=ka-T;m=oa-ga;l=qa-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=la-T;m=pa-ga;l=ra-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=Y-T;la=fa-ga;ra=ia-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}if(k)if(!(r>=0.0)){o=la-T;m=pa-ga;l=ra-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=la-T;ka=pa-ga;qa=ra-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}k=r>0.0;if(s>0.0)if(k){o=la-T;m=pa-ga;l=ra-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=Y-T;la=fa-ga;ra=ia-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ua;n[i+4>>2]=+n[Z>>2]-D*ua;n[i+8>>2]=+n[$>>2]-E*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(E*Aa+(C*ya+D*za));n[i>>2]=ka-C*ta;n[i+4>>2]=+n[Z>>2]-D*ta;n[i+8>>2]=+n[$>>2]-E*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-la;ta=fa-pa;sa=ia-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){qa=Y-la;ua=fa-pa;sa=ia-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(qa*ya+ua*za));n[i>>2]=Y-qa*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(k){o=Y-T;m=fa-ga;l=ia-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(!(r<0.0)){f[h>>2]=1;k=Vha(a,b,c,d,g,e,A,0)|0;break}o=Y-T;m=fa-ga;l=ia-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=ka-T;fa=oa-ga;ia=qa-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ka=la-ka;ua=pa-oa;sa=ra-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ka*ya+ua*za));n[i>>2]=la-ka*ta;n[i+4>>2]=+n[ba>>2]-ua*ta;n[i+8>>2]=+n[ca>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}if(k){k=q>0.0;if(!(p>=0.0)){if(k){if(r>0.0){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=ka-T;la=oa-ga;ra=qa-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(s>0.0){o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=Y-T;ka=fa-ga;qa=ia-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}k=r<0.0;if(q<0.0){if(k){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(s<0.0){o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=la-T;fa=pa-ga;ia=ra-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}}if(k)if(!(s>=0.0)){o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=la-T;sa=pa-ga;ua=ra-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}oa=Y-T;ka=fa-ga;qa=ia-ja;if(r*(ka*Q-oa*R)+(p*(qa*R-ka*S)+q*(oa*S-qa*Q))>0.0){qa=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<0.0){k=0;break}if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}k=s>0.0;if(r>0.0)if(k){o=Y-T;m=fa-ga;l=ia-ja;p=ka-T;q=oa-ga;r=qa-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}ha=la-T;fa=pa-ga;ia=ra-ja;if(r*(fa*Q-ha*R)+(p*(ia*R-fa*S)+q*(ha*S-ia*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}else{va=ka-la;ta=oa-pa;sa=qa-ra;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=ka-va*ua;n[i+4>>2]=+n[Z>>2]-ta*ua;n[i+8>>2]=+n[$>>2]-sa*ua;ua=+n[d>>2];sa=+n[Z>>2];ta=+n[$>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[Z>>2]-wa*Aa;n[j+8>>2]=+n[$>>2]-xa*Aa;k=1;break}}else{l=la-T;m=pa-ga;o=ra-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){la=ka-la;ua=oa-pa;sa=qa-ra;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(la*ya+ua*za));n[i>>2]=ka-la*ta;n[i+4>>2]=+n[Z>>2]-ua*ta;n[i+8>>2]=+n[$>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=((T-ka)*va+(ga-oa)*wa+xa*(ja-qa))/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[d>>2])+wa*(sa-+n[Z>>2])+xa*(Aa-+n[$>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{o=ka-T;m=oa-ga;l=qa-ja;p=la-T;q=pa-ga;r=ra-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=Y-T;sa=fa-ga;ua=ia-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){qa=T-da;ta=ga-ea;sa=ja-ha;ua=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*qa+wa*ta+xa*sa);n[i>>2]=T-qa*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{ua=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ua;n[i+4>>2]=+n[ba>>2]-G*ua;n[i+8>>2]=+n[ca>>2]-H*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[d>>2];wa=sa-+n[Z>>2];xa=ta-+n[$>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}}else{o=Y-T;m=fa-ga;l=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<0.0){k=0;break}if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>=0.0)){ta=(r*Aa+(p*ya+q*za))/(H*Aa+(F*ya+G*za));n[i>>2]=la-F*ta;n[i+4>>2]=+n[ba>>2]-G*ta;n[i+8>>2]=+n[ca>>2]-H*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=((T-la)*va+(ga-pa)*wa+xa*(ja-ra))/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[e>>2])+wa*(sa-+n[ba>>2])+xa*(Aa-+n[ca>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(k){o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))>0.0){if(!(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))<=0.0)){k=0;break}ta=ka-T;sa=oa-ga;ua=qa-ja;if(r*(sa*N-ta*O)+(p*(ua*O-sa*P)+q*(ta*P-ua*N))>0.0){ra=T-da;ta=ga-ea;sa=ja-ha;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))<0.0){k=0;break}if(!(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ua=T-da;Aa=ga-ea;sa=ja-ha;ta=u/(va*ua+wa*Aa+xa*sa);n[i>>2]=T-ua*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[b>>2];ya=sa-+n[ma>>2];za=Aa-+n[na>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}if(!(s<0.0)){f[h>>2]=1;k=Vha(a,b,c,d,e,g,A,0)|0;break}o=la-T;m=pa-ga;l=ra-ja;p=Y-T;q=fa-ga;r=ia-ja;if(r*(m*N-o*O)+(p*(l*O-m*P)+q*(o*P-l*N))>0.0){if(!(r*(m*Q-o*R)+(p*(l*R-m*S)+q*(o*S-l*Q))<=0.0)){k=0;break}pa=ka-T;la=oa-ga;ra=qa-ja;if(r*(la*Q-pa*R)+(p*(ra*R-la*S)+q*(pa*S-ra*Q))>0.0){ra=T-sa;ta=ga-ta;sa=ja-ua;ua=u/(va*ra+wa*ta+xa*sa);n[i>>2]=T-ra*ua;n[i+4>>2]=+n[U>>2]-ta*ua;n[i+8>>2]=+n[V>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}else{va=Y-ka;ta=fa-oa;sa=ia-qa;ua=(r*Aa+(p*ya+q*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=Y-va*ua;n[i+4>>2]=+n[_>>2]-ta*ua;n[i+8>>2]=+n[aa>>2]-sa*ua;ua=+n[g>>2];sa=+n[_>>2];ta=+n[aa>>2];va=ua-+n[e>>2];wa=sa-+n[ba>>2];xa=ta-+n[ca>>2];Aa=(ya*(ua-+n[a>>2])+za*(sa-+n[U>>2])+Aa*(ta-+n[V>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[_>>2]-wa*Aa;n[j+8>>2]=+n[aa>>2]-xa*Aa;k=1;break}}else{l=ka-T;m=oa-ga;o=qa-ja;if(r*(m*N-l*O)+(p*(o*O-m*P)+q*(l*P-o*N))<0.0){k=0;break}if(!(r*(m*Q-l*R)+(p*(o*R-m*S)+q*(l*S-o*Q))>=0.0)){ra=Y-ka;ua=fa-oa;sa=ia-qa;ta=(r*Aa+(p*ya+q*za))/(sa*Aa+(ra*ya+ua*za));n[i>>2]=Y-ra*ta;n[i+4>>2]=+n[_>>2]-ua*ta;n[i+8>>2]=+n[aa>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}else{ya=T-sa;Aa=ga-ta;sa=ja-ua;ta=u/(va*ya+wa*Aa+xa*sa);n[i>>2]=T-ya*ta;n[i+4>>2]=+n[U>>2]-Aa*ta;n[i+8>>2]=+n[V>>2]-sa*ta;ta=+n[a>>2];sa=+n[U>>2];Aa=+n[V>>2];ua=ta-+n[c>>2];ya=sa-+n[W>>2];za=Aa-+n[X>>2];Aa=(va*(ta-+n[g>>2])+wa*(sa-+n[_>>2])+xa*(Aa-+n[aa>>2]))/(va*ua+wa*ya+xa*za);n[j>>2]=ta-ua*Aa;n[j+4>>2]=+n[U>>2]-ya*Aa;n[j+8>>2]=+n[V>>2]-za*Aa;k=1;break}}}else{if(k){if(s>0.0){y=T-sa;x=ga-ta;s=ja-ua;r=Y-sa;q=fa-ta;p=ia-ua;u=la-sa;v=pa-ta;w=ra-ua;if(w*(y*q-r*x)+(u*(x*p-q*s)+v*(r*s-y*p))>0.0){l=da-sa;m=ea-ta;o=ha-ua;if(!(w*(q*l-r*m)+(u*(p*m-q*o)+v*(r*o-p*l))<=0.0)){k=0;break}ia=ka-sa;ga=oa-ta;ja=qa-ua;if(w*(ga*l-ia*m)+(u*(ja*m-ga*o)+v*(ia*o-ja*l))>0.0){ka=sa-da;oa=ta-ea;qa=ua-ha;ua=(va*(sa-la)+wa*(ta-pa)+xa*(ua-ra))/(va*ka+wa*oa+xa*qa);n[i>>2]=sa-ka*ua;n[i+4>>2]=+n[ma>>2]-oa*ua;n[i+8>>2]=+n[na>>2]-qa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[_>>2];xa=ta-+n[aa>>2];Aa=(ya*(ua-+n[b>>2])+za*(sa-+n[ma>>2])+Aa*(ta-+n[na>>2]))/(ya*va+za*wa+Aa*xa);n[j>>2]=ua-va*Aa;n[j+4>>2]=+n[ba>>2]-wa*Aa;n[j+8>>2]=+n[ca>>2]-xa*Aa;k=1;break}else{va=la-ka;ta=pa-oa;sa=ra-qa;ua=(w*Aa+(u*ya+v*za))/(sa*Aa+(va*ya+ta*za));n[i>>2]=la-va*ua;n[i+4>>2]=+n[ba>>2]-ta*ua;n[i+8>>2]=+n[ca>>2]-sa*ua;ua=+n[e>>2];sa=+n[ba>>2];ta=+n[ca>>2];va=ua-+n[g>>2];wa=sa-+n[