/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/commons/Panel","sap/ui/core/Title","sap/m/VBox","sap/ui/layout/Splitter","./Tree","./Viewport"],function(q,S,a,b,c,d,e,f){"use strict";var P=S.extend("sap.ui.vtm.Panel",{metadata:{properties:{title:{type:"string"},showViewport:{type:"boolean",defaultValue:true},treeWidth:{type:"sap.ui.core.CSSSize",defaultValue:"50%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"inherit"}},aggregations:{_panel:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},titleControls:{type:"sap.ui.core.Control",multiple:"true"},treeHeaderControls:{type:"sap.ui.core.Control",multiple:"true"},viewportHeaderControls:{type:"sap.ui.core.Control",multiple:"true"}},associations:{vtmId:{type:"sap.ui.vtm.Vtm",multiple:false}},events:{initialized:{},contextMenu:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pageX:{type:"int"},pageY:{type:"int"},screenX:{type:"int"},screenY:{type:"int"},eventData:{type:"object"}},allowPreventDefault:true}}},init:function(){var i=this.getId();var t=this._tree=new sap.ui.vtm.Tree(i+"_tree");var v=this._viewport=new sap.ui.vtm.Viewport(i+"_viewport");var g=this._title=new sap.m.Title({textAlign:sap.ui.core.TextAlign.Begin});var p=this._panelHeader=new sap.m.Bar({contentLeft:[g]});this._treeLayout=new sap.ui.layout.SplitterLayoutData({minSize:10});var h=new sap.ui.layout.SplitPane({content:t,demandPane:false,requiredParentWidth:50,layoutData:this._treeLayout});this._viewportLayout=new sap.ui.layout.SplitterLayoutData({minSize:10});var j=new sap.ui.layout.SplitPane({content:v,demandPane:false,requiredParentWidth:50,layoutData:this._viewportLayout});var r=new sap.ui.layout.PaneContainer({panes:[h,j]});var s=this._splitter=new sap.ui.layout.ResponsiveSplitter({rootPaneContainer:r,defaultPane:h});var k=this._page=new sap.m.Page({content:[s],customHeader:p,layoutData:new sap.m.FlexItemData({minHeight:"100%",maxHeight:"100%"})});var l=function(n){var o;sap.ui.vtm.measure(this,"fireContextMenu",function(){o=this.fireContextMenu({clientX:n.clientX,clientY:n.clientY,pageX:n.pageX,pageY:n.pageY,screenX:n.screenX,screenY:n.screenY,eventData:n});}.bind(this));if(!o){n.preventDefault();}}.bind(this);k.addEventDelegate({oncontextmenu:l},k);var m=new sap.m.VBox({fitContainer:true,renderType:sap.m.FlexRendertype.Bare,items:[k]});this.setAggregation("_panel",m);this.data("notUsed","just a bug workaround");this._oldPanes=[];this._setIsActive(false);},onAfterRendering:function(){if(!this._initialized){this._initialize();}},_initialize:function(){var v=this.getVtm();if(v){v._addPanel(this);this._initialized=true;sap.ui.vtm.measure(this,"fireInitialized",function(){this.fireInitialized();}.bind(this));}},destroy:function(){S.prototype.destroy.apply(this);this._destroyed=true;var g=this.getVtm().getPanels().every(function(p){return p._destroyed===true;});if(g){this.getVtm().getScene().destroy();}},onmousedown:function(E){this.getVtm()._setActivePanel(this,false);},onfocusin:function(E){this.getVtm()._setActivePanel(this,false);},onfocusout:function(E){var v=this.getVtm();if(v.getActivePanel()===this){v._setActivePanel(null,false);}},addTreeHeaderControl:function(t){return this.getTree().addHeaderControl(t);},addViewportHeaderControl:function(v){return this.getViewport().addHeaderControl(v);},destroyTreeHeaderControls:function(){return this;},destroyViewportHeaderControls:function(){return this;},getTreeHeaderControls:function(){return this.getTree().getHeaderControls();},getViewportHeaderControls:function(){return this.getViewport().getHeaderControls();},indexOfTreeHeaderControl:function(t){return this.getTree().indexOfHeaderControl(t);},indexOfViewportHeaderControl:function(v){return this.getViewport().indexOfHeaderControl(v);},insertTreeHeaderControl:function(t,i){return this.getTree().insertHeaderControl(t,i);},insertViewportHeaderControl:function(v,i){return this.getViewport().insertHeaderControl(v,i);},removeAllTreeHeaderControls:function(){return this.getTree().removeAllControls();},removeAllViewportHeaderControls:function(){return this.getViewport().removeAllControls();},removeTreeHeaderControl:function(t){return this.getTree().removeControl(t);},removeViewportHeaderControl:function(v){return this.getViewport().removeControl(v);},_getDelegatedAggregation:function(A){switch(A){case"treeHeaderControls":return{control:this.getTree(),aggregationName:A};case"viewportHeaderControls":return{control:this.getViewport(),aggregationName:A};case"titleControls":return{control:this._panelHeader,name:"contentRight"};default:return null;}},addAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.addAggregation(g.name,o,s);}else{return S.prototype.addAggregation.apply(this,[A,o,s]);}},bindAggregation:function(A,B){var g=this._getDelegatedAggregation(A);if(g){return g.control.bindAggregation(g.name);}else{return S.prototype.bindAggregation.apply(this,[A]);}},destroyAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return this;}else{return S.prototype.destroyAggregation.apply(this,[A,s]);}},getAggregation:function(A,D){var g=this._getDelegatedAggregation(A);if(g){return g.control.getAggregation(g.name,D);}else{return S.prototype.getAggregation.apply(this,[A,D]);}},indexOfAggregation:function(A,o){var g=this._getDelegatedAggregation(A);if(g){return g.control.indexOfAggregation(g.name,o);}else{return S.prototype.indexOfAggregation.apply(this,[A,o]);}},insertAggregation:function(A,o,i,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.insertAggregation(g.name,o,i,s);}else{return S.prototype.insertAggregation.apply(this,[A,o,i,s]);}},removeAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.removeAggregation(g.name,A,o,s);}else{return S.prototype.removeAggregation.apply(this,[A,o,s]);}},removeAllAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.removeAllAggregation(g.name,A,s);}else{return S.prototype.removeAllAggregation.apply(this,[A,s]);}},setAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.setAggregation(g.name,o,s);}else{return S.prototype.setAggregation.apply(this,[A,o,s]);}},unbindAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.unbindAggregation(g.name,s);}else{return S.prototype.unbindAggregation.apply(this,[A,s]);}},validateAggregation:function(A,o,m){var g=this._getDelegatedAggregation(A);if(g){return g.control.validateAggregation(g.name,o,m);}else{return S.prototype.validateAggregation.apply(this,[A,o,m]);}},_getPanel:function(){return this.getAggregation("_panel");},_getTreeLayoutData:function(){return this._treeLayout;},_getViewportLayoutData:function(){return this._viewportLayout;},renderer:function(r,C){r.write("<div");r.writeControlData(C);r.addStyle("height",C.getHeight());r.writeStyles();r.writeClasses();r.write(">");var p=C._getPanel();r.renderControl(p);r.write("</div>");},setTitle:function(t){this._title.setText(t);this.setProperty("title",t);return this;},getTree:function(){return this._tree;},getViewport:function(){return this._viewport;},setShowViewport:function(s){if(s===this.getShowViewport()){return this;}var _=this.getTreeWidth();this.setProperty("showViewport",s);var g=this._splitter.getDefaultPane();var r=this._splitter.getRootPaneContainer();var p=r.getPanes();if(!s){this._oldTreeWidth=_;p.forEach(function(h){if(h.getId()!==g){r.removePane(h);this._oldPanes.push(h);}}.bind(this));this.setTreeWidth("auto");}else{this._oldPanes.forEach(function(h){r.addPane(h);});this._oldPanes=[];this.setTreeWidth(this._oldTreeWidth);this._oldTreeWidth=null;}return this;},getVtm:function(){if(!this._vtm){this._vtm=sap.ui.getCore().byId(this.getVtmId());}return this._vtm;},_setIsActive:function(i){var g=this._isActive;if(g!==i){this._isActive=i;var p=this._getPanel();if(i){p.addStyleClass("sapUiVtmPanel_ActiveBorder");p.removeStyleClass("sapUiVtmPanel_InactiveBorder");}else{p.addStyleClass("sapUiVtmPanel_InactiveBorder");p.removeStyleClass("sapUiVtmPanel_ActiveBorder");}}return this;},getIsActive:function(){return this._isActive;},getTreeWidth:function(){if(!this.getShowViewport()){return"100%";}var t=this._getTreeLayoutData();var s=t.getSize();if(s==="auto"){return"50%";}return s;},setTreeWidth:function(t){if(!t){return this;}if(t==="auto"){t=this.getShowViewport()?"50%":"100%";}var p=t.indexOf("%")>-1;var g=this._getTreeLayoutData();var v=this._getViewportLayoutData();if(t.indexOf("px")>-1||p){var s=parseInt(t,10);if(s<0){q.sap.log.error("Negative treeWidth values are not permitted",null,"sap.ui.vtm.Panel");return this;}if(p&&s>100){t="100%";}}else{var m="Illegal treeWidth value: "+t;q.sap.log.error(m,null,"sap.ui.vtm.Panel");return this;}g.setSize(t);v.setSize("auto");return this;}});return P;});
