/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/table/TreeTable","./SelectionMode","./InternalColumnDescriptor","./ArrayUtilities","./MatrixUtilities","./TreeItemUtilities","./Column","./Lookup","./library","./Text","./ColumnType","./InternalColumns","sap/ui/model/json/JSONModel","sap/ui/commons/TextView","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","./CheckEye"],function(q,S,c,d,f,g,h,j,k,l,m,n,o,p,r,s,t,u,v,w){"use strict";var T=S.extend("sap.ui.vtm.Tree",{metadata:{properties:{selectionMode:{type:"sap.ui.vtm.SelectionMode",defaultValue:"Single"}},aggregations:{_treeTable:{type:"sap.ui.table.TreeTable",multiple:false,visibility:"hidden"},headerControls:{type:"sap.ui.core.Control",multiple:true}},events:{dragStart:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"}},allowPreventDefault:true},dragOver:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"},dragOverItem:{type:"object"},dragOverTree:{type:"sap.ui.vtm.Tree"}},allowPreventDefault:true},drop:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"},dropItem:{type:"object"},dropTree:{type:"sap.ui.vtm.Tree"}}},selectionChanged:{parameters:{addedItems:{type:"object[]"},removedItems:{type:"object[]"},userInteraction:{type:"boolean"}}},visibilityHeaderIconClicked:{parameters:{visibility:{type:"boolean"},control:{type:"sap.ui.core.Control"}}},visibilityIconClicked:{parameters:{item:{type:"object"},visibility:{type:"boolean"},control:{type:"sap.ui.core.Control"}}},expandedChanged:{parameters:{item:{type:"object"},expanded:{type:"boolean"},userInteraction:{type:"boolean"}}},fixedColumnsChanged:{},dataColumnsChanged:{},beforeModelUpdated:{},modelUpdated:{},messageStatusIconClicked:{parameters:{items:{type:"object"},control:{type:"sap.ui.core.Control"}}},messageStatusHeaderIconClicked:{control:{type:"sap.ui.core.Control"}},hierarchyChanged:{}}},constructor:function(i,x){S.apply(this,arguments);this._rb=sap.ui.vtm.getResourceBundle();this._treeCollections=new sap.ui.vtm.TreeCollections();this._selectedItems=[];var y=new sap.ui.table.TreeTable({enableColumnReordering:true,selectionMode:sap.ui.table.SelectionMode.Single,showNoData:false,visibleRowCountMode:sap.ui.table.VisibleRowCountMode.Auto,minAutoRowCount:4,selectionBehavior:sap.ui.table.SelectionBehavior.RowOnly});this.setAggregation("_treeTable",y);y.allowTextSelection(false);var z=sap.ui.vtm.InternalColumns.createTreeColumn();var A=sap.ui.vtm.InternalColumns.createVisibilityColumn();var B=sap.ui.vtm.InternalColumns.createMessageStatusColumn();this._fixedColumns=[z,A,B];this._setColumns(this._fixedColumns);this.setRootItems([]);this.updateCollections(false);this._updateModel();y.setCollapseRecursive(false);y.attachToggleOpenState(this._handleToggleOpenState.bind(this));y.attachCellClick(function(e){if(this.getSelectionMode()==sap.ui.vtm.SelectionMode.MultiToggleWithSingleSelect){var a=e.getParameter("rowIndex");var b=this._getItemByRowIndex(a);if(b){this._selectedItems=[b];y.setSelectedIndex(a);}else{this._selectedItems=[];y.clearSelection();}}}.bind(this));var C=function(a,e){if(a.getVisible&&!a.getVisible()||a.getEnabled&&!a.getEnabled()){return false;}if(a.ontap){a.ontap(e);}else if(a.userToggle){a.userToggle(e);}else if(a.onclick){a.onclick(e);}return true;};var D=function(e){var a=sap.ui.table.TableUtils.getFocusedItemInfo(y);var b=this.getSelectionMode()===sap.ui.vtm.SelectionMode.MultiToggle;var E=b?a.cellInRow-1:a.cellInRow;var F=y.getColumns();var G=F[E];if(!G){return;}var H=G.data("definition");var I=H.getType();var J=H.getDescriptor();var K=a.row===0;if(K){if(I===sap.ui.vtm.ColumnType.Internal&&J===sap.ui.vtm.InternalColumnDescriptor.Visibility){var L=G.getLabel();C(L,e);}}else if(I===sap.ui.vtm.ColumnType.Internal){var M=y.getRows()[a.row-1].getCells()[E];switch(J){case sap.ui.vtm.InternalColumnDescriptor.Tree:sap.ui.table.TableUtils.toggleRowSelection(y,e.target);e.preventDefault();e.stopImmediatePropagation();break;case sap.ui.vtm.InternalColumnDescriptor.Visibility:case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:C(M,e);e.preventDefault();e.stopImmediatePropagation();break;default:break;}}}.bind(this);y.attachBrowserEvent("keyup",function(e){if(e.which===q.sap.KeyCodes.SPACE){D(e);}});y.attachRowSelectionChange(function(e){var E=e.getParameter("userInteraction");var F=e.getParameter("rowIndices");var G=y.getSelectedIndices();var H=[];var I=[];F.forEach(function(a){if(G.indexOf(a)!=-1){H.push(a);}else{I.push(a);}});var J=this._getTreeItemsFromRowIndices(H);var K=this._getTreeItemsFromRowIndices(I);if(E){var L=K.map(function(a){return a.id;});var M=function(a,b){return a.id==b.id;};var N=function(a){return L.indexOf(a.id)==-1;};this._selectedItems=g.union([this._selectedItems.filter(N),J],M);}sap.ui.vtm.measure(this,"fireSelectionChanged",function(){this.fireSelectionChanged({addedItems:J,removedItems:K,userInteraction:E});}.bind(this));if(E){this.fireEvent("vtmInternalSetTreeSelectionComplete");}}.bind(this));},renderer:function(R,C){R.write("<div");R.writeControlData(C);R.addClass("sapUiVtmTree");R.writeStyles();R.writeClasses();R.write(">");var a=C.getHeaderControls();a.forEach(function(e){if(e){R.renderControl(e);}});var b=C._getTreeTable();R.renderControl(b);R.write("</div>");},_raiseExpandedChanged:function(e){sap.ui.vtm.measure(this,"fireExpandedChanged",function(){this.fireExpandedChanged(e);}.bind(this));},_handleToggleOpenState:function(e){var a=e.getParameter("rowContext");var b=e.getParameter("expanded");var i=a.getPath();var x=this.getItemByBindingContextPath(i);this._raiseExpandedChanged({item:x,expanded:b,userInteraction:true});},_getAncestor:function(a){var b=this.getParent();while(b&&b.getMetadata().getName()!==a){b=b.getParent();}return b;},getPanel:function(){if(!this._panel){this._panel=this._getAncestor("sap.ui.vtm.Panel");}return this._panel;},setExpanded:function(a,e){var b=this._getTreeTable();var i=function(){var x=this._getRowIndexForTreeItem(b,a);if(x!==-1){var y;if(e){if(!b.isExpanded(x)){y=true;b.expand(x);}}else if(b.isExpanded(x)){y=true;b.collapse(x);}if(y){this._raiseExpandedChanged({item:a,expanded:e,userInteraction:false});}}}.bind(this);if(e){this._expandToTreeItem(a,false,i);}else{i();}return this;},getExpanded:function(a){var b=this._getTreeTable();var e=this._getRowIndexForTreeItem(b,a);if(e!==-1){return b.isExpanded(e);}return false;},getFixedColumns:function(){var a=[];var b=this._getTreeTable();var e=b.getColumns();for(var i=0;i<this._fixedColumns.length;i++){var x=e[i];var y=x.data("definition");y.setWidth(x.getWidth());y.setHAlign(x.getHAlign());a.push(y);}return a;},setFixedColumns:function(a){if(!a){throw"fixedColumns not specified";}this._fixedColumns=a;var b=this.getDataColumns();var e=this._fixedColumns.concat(b);this._setColumns(e);this.fireFixedColumnsChanged();return this;},getDataColumns:function(){var a=[];var b=this._getTreeTable();var e=b.getColumns();for(var i=this._fixedColumns.length;i<e.length;i++){var x=e[i];var y=x.data("definition");y.setWidth(x.getWidth());y.setHAlign(x.getHAlign());a.push(y);}return a;},setDataColumns:function(a){if(!a){throw"dataColumns not specified";}var b=this._fixedColumns.concat(a);this._setColumns(b);this.fireDataColumnsChanged();return this;},_setColumns:function(a){var b=this._getTreeTable();b.removeAllColumns();a.forEach(function(e){var i=this._createColumn(e);b.addColumn(i);}.bind(this));b.setFixedColumnCount(this._fixedColumns.length);},_getTreeItemsFromRowIndices:function(a){return a.map(function(b){return this._getItemByRowIndex(b);}.bind(this)).filter(function(b){return!!b;});},_getTreeTable:function(){return this.getAggregation("_treeTable");},getRootItems:function(){return this._rootItems;},setRootItems:function(a){this._rootItems=a;return this;},isEmpty:function(){return this._rootItems.length===0;},getSelectedItems:function(){return this._selectedItems;},_expandToTreeItem:function(a,b){return new Promise(function(e,i){var x=this._getTreeTable();var y=function(E,F,G){var H;if((F<E)||(F>=(E+G))){H=F-(G/2);}else{H=E;}H=H>0?Math.floor(H):0;return H;};var z=this.getAncestorItems(a.id,false);var A=function(E,z,F){if(F.getParameter("reason")==="expand"){E(z);}};var B=null;var C=0;var D=function(z){var E=function(){x.getBinding("rows").detachChange(B);var F=this._getRowIndexForTreeItem(x,a,C);if(F===-1){throw"Tree item with id '"+a.id+"' not found in treeTable";}if(b){var G=x.getVisibleRowCount(),H=x.getFirstVisibleRow(),I=y(H,F,G);if(I!==H){x.setFirstVisibleRow(I);}}e();}.bind(this);setTimeout(function(){if(z.length){while(z.length){var F=z[0];var G=this._getRowIndexForTreeItem(x,F,C);if(G===-1){return;}else{z.shift();C=G+1;if(!x.isExpanded(G)){x.expand(G);this._raiseExpandedChanged({item:F,expanded:true,userInteraction:false});return;}else if(!z.length){E();}}}}else{E();}}.bind(this),0);}.bind(this);B=A.bind(this,D,z);x.getBinding("rows").attachChange(B);D(z);}.bind(this));},_getRowIndexForTreeItem:function(a,b,e){var i=-1;sap.ui.vtm.measure(this,"_getRowIndexForTreeItem",function(){if(!e){e=0;}var x=function(C,B){B.forEach(function(E){C=C[E];});return C;};var y=this.getAllItems();for(var z=e;z<y.length;z++){var A=a.getContextByIndex(z);if(A){var B=A.getPath().split("/");B.shift();var C=A.getModel().getData();var D=x(C,B);if(D===b){i=z;break;}}}}.bind(this));return i;},expandAncestors:function(a){sap.ui.vtm.measure(this,"expandAncestors",function(){this._expandToTreeItem(a,false);}.bind(this));return this;},expandAll:function(){sap.ui.vtm.measure(this,"expandAll",function(){this._getTreeTable().expandToLevel(1000*1000*1000);}.bind(this));return this;},collapseAll:function(){sap.ui.vtm.measure(this,"collapseAll",function(){this._getTreeTable().collapseAll();}.bind(this));return this;},expandToLevel:function(L){sap.ui.vtm.measure(this,"expandToLevel",function(){this._getTreeTable().expandToLevel(L);}.bind(this));return this;},scrollIntoView:function(a){sap.ui.vtm.measure(this,"scrollIntoView",function(){this._expandToTreeItem(a,true);}.bind(this));return this;},setSelectedItems:function(a,b){a=sap.ui.vtm.ArrayUtilities.wrap(a);if(b!==true&&b!==false){b=true;}if(this.getSelectionMode()==sap.ui.vtm.SelectionMode.Single&&a.length>1){a=a.slice(0,1);}if(a.length){var e=[];this.traverseTree(function(i){e.push(i.id);});a=a.filter(function(i){return e.indexOf(i.id)!=-1;});}this._selectedItems=a;if(!a.length){this._getTreeTable().clearSelection();this.fireEvent("vtmInternalSetTreeSelectionComplete");return this;}var x=function(A){var B=this._getTreeTable();for(var i=0;;i++){var C=this._getItemByRowIndex(i);if(!C){break;}var D=A.indexOf(C)!==-1;if(D!=B.isIndexSelected(i)){if(D){B.addSelectionInterval(i,i);}else{B.removeSelectionInterval(i,i);}}}this.fireEvent("vtmInternalSetTreeSelectionComplete");}.bind(this);var y=function(){x(a);};var z=null;a.forEach(function(i){if(!z){z=this._expandToTreeItem(i,b);}else{z=z.then(function(){return this._expandToTreeItem(i,b);}.bind(this));}}.bind(this));z.then(y);return this;},validateTree:function(){sap.ui.vtm.measure(this,"validateTree",function(){var e=sap.ui.vtm.TreeItemUtilities.validateTree(this.getRootItems());if(e.length!==0){e.forEach(function(a){var b="Tree error in "+this.getId()+": "+a;q.sap.log.error(b,null,"sap.ui.vtm.Tree");});throw"There were errors in the "+this.getId()+" tree. See the console trace for details";}}.bind(this));return this;},updateModel:function(a){sap.ui.vtm.measure(this,"updateModel",function(){sap.ui.vtm.measure(this,"fireBeforeModelUpdated",function(){this.fireBeforeModelUpdated();}.bind(this));this._updateModel(a);this.setSelectedItems(this._selectedItems,false);sap.ui.vtm.measure(this,"fireModelUpdated",function(){this.fireModelUpdated();}.bind(this));}.bind(this));return this;},_updateModel:function(a){var b=this._getTreeTable();var e=b.getModel();if(!e||a){e=new sap.ui.model.json.JSONModel();e.setSizeLimit(1000000);b.bindRows({path:"/rootItems",key:"id",parameters:{arrayNames:["includedChildren"],numberOfExpandedLevels:1}});e.setData({rootItems:this.getRootItems()});b.setModel(e);}else{e.setData({rootItems:this.getRootItems()});this._updateBindings(true);}},_updateBindings:function(){this._getTreeTable().getModel().updateBindings(true);},updateCollections:function(a){sap.ui.vtm.measure(this,"updateCollections",function(){if(this._treeCollections.updateCollections(this.getRootItems(),a)){sap.ui.vtm.measure(this,"fireHierarchyChanged",function(){this.fireHierarchyChanged();}.bind(this));}}.bind(this));return this;},updateTreeItemsBySceneNodeId:function(){sap.ui.vtm.measure(this,"updateTreeItemsBySceneNodeId",function(){this._treeCollections.updateTreeItemsBySceneNodeId(this.getRootItems());}.bind(this));return this;},getItemByBindingContextPath:function(b){return this._getTreeTable().getModel().getProperty(b)||undefined;},getItem:function(a){return this._treeCollections.getItem(a);},isIncludedItem:function(a){return this._treeCollections.isIncludedItem(a);},isExcludedItem:function(a){return this._treeCollections.isExcludedItem(a);},getItemsBySceneNodeId:function(a,b){return this._treeCollections.getItemsBySceneNodeId(a,b);},getParentItem:function(a){return this._treeCollections.getParentItem(a);},getDescendantItems:function(a,b){return this._treeCollections.getDescendantItems(a,b);},getAncestorItems:function(a){return this._treeCollections.getAncestorItems(a);},getAllItems:function(a){return this._treeCollections.getAllItems(a);},_modifyDisplayState:function(a,b,e,i,x){a=sap.ui.vtm.ArrayUtilities.wrap(a);e=e==null?true:e;x=x==null?true:x;i=i==null?true:i;var y=function(z){if(!i||sap.ui.vtm.TreeItemUtilities.hasVisibility(z)){b(z);}return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;};a.forEach(function(z){if(e){sap.ui.vtm.TreeItemUtilities.traverseBranch(z,y);}else{y(z);}});if(x){this.updateModel();this.getPanel().getViewport().refresh();}},_getTreeItemData:function(a,b){if(Array.isArray(a)){return a.map(b);}else{return b(a);}},setVisibility:function(a,b,e,i,x){var y=function(z){if(b==undefined){delete z.visibility;}else{z.visibility=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},getVisibility:function(a){return this._getTreeItemData(a,function(b){return b.visibility;});},setOpacity:function(a,b,e,i,x){var y=function(z){if(b==undefined){delete z.opacity;}else{z.opacity=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},getOpacity:function(a){return this._getTreeItemData(a,function(b){return b.opacity;});},setHighlightColor:function(a,b,e,i,x){var y=function(z){if(b==null){delete z.highlightColor;}else{z.highlightColor=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},getHighlightColor:function(a){return this._getTreeItemData(a,function(b){return b.highlightColor;});},_getItemByRowIndex:function(i){var a=this._getTreeTable();var b=a.getContextByIndex(i);var e=b?b.sPath:"";return this.getItemByBindingContextPath(e);},onAfterRendering:function(){var a=this._getTreeTable();if(a.setFixedColumnCount()!=this._fixedColumns.length){a.setFixedColumnCount(this._fixedColumns.length);}this._addDragHandlers();this._addMutationObserver();},setSelectionMode:function(a){if(a===this.getSelectionMode()){return this;}var b=this._getTreeTable();this._selectedItems=[];b.clearSelection();var e;var i;switch(a){case sap.ui.vtm.SelectionMode.Single:e=sap.ui.table.SelectionMode.Single;i=sap.ui.table.SelectionBehavior.RowOnly;break;case sap.ui.vtm.SelectionMode.MultiToggle:e=sap.ui.table.SelectionMode.MultiToggle;i=sap.ui.table.SelectionBehavior.Row;break;case sap.ui.vtm.SelectionMode.MultiToggleWithSingleSelect:e=sap.ui.table.SelectionMode.MultiToggle;i=sap.ui.table.SelectionBehavior.RowSelector;break;default:throw"Unknown selection mode: '"+a+"'";}b.setSelectionBehavior(i);b.setSelectionMode(e);this.setProperty("selectionMode",a);return this;},_addMutationObserver:function(){var i=false;var a=new MutationObserver(function(e){if(i){return;}i=true;var x=false;e.forEach(function(y){if(x){return;}if(y.type==="childList"){this._addDragHandlers();x=true;}}.bind(this));i=false;}.bind(this));var b={subtree:true,childList:true};q("#"+this.getId()).each(function(e,x){a.observe(x,b);});},_getRowIndexForTableRow:function(a){var b=q(a).attr("data-sap-ui-rowindex");var R=this._getTreeTable().getFirstVisibleRow()+parseInt(b,10);return R;},_addDragHandlers:function(){var i=this.getId();var a="#"+i+" tr.sapUiTableTr";if(q(a).attr("draggable")){return;}var b=this.getPanel().getVtm();var e=function(A){A.dataTransfer.setData("text","");var B=A.currentTarget;var C=this._getRowIndexForTableRow(B);var D=this._getItemByRowIndex(C);if(!D){A.preventDefault();return;}var E=this.getSelectedItems();if(E&&E.length&&E.indexOf(D)<0){A.preventDefault();return;}b._dragStartParameters={dragItem:D,dragTree:this};var F;sap.ui.vtm.measure(this,"fireDragStart",function(){F=this.fireDragStart(b._dragStartParameters);}.bind(this));if(!F){A.preventDefault();}}.bind(this);var x=function(A){var B=b._dragStartParameters;if(!B){return;}var C=A.currentTarget;var D=this._getRowIndexForTableRow(C);var E={dragItem:B.dragItem,dragTree:B.dragTree,dragOverItem:this._getItemByRowIndex(D),dragOverTree:this};var F;sap.ui.vtm.measure(this,"fireDragOver",function(){F=this.fireDragOver(E);}.bind(this));if(!F){A.preventDefault();}}.bind(this);var y=function(A){var B=b._dragStartParameters;if(!B){return;}var C=A.currentTarget;var D=this._getRowIndexForTableRow(C);var E={dragItem:B.dragItem,dragTree:B.dragTree,dropItem:this._getItemByRowIndex(D),dropTree:this};b._dragStartParameters=null;sap.ui.vtm.measure(this,"fireDrop",function(){this.fireDrop(E);}.bind(this));}.bind(this);var z=function(A){A.addEventListener("dragstart",e,false);A.addEventListener("dragover",x,false);A.addEventListener("drop",y,false);};q(a).each(function(){var A=q(this);A.attr("draggable","true");A.attr("droppable","true");z(this);});},_createColumn:function(a){var b=a.getTemplate()||this._createColumnTemplate(a);var e=a.getLabel();var i=a.getLabelControl();this._attachColumnHeaderEvents(a);var x={label:i?i:e,tooltip:a.getTooltip()||e,hAlign:a.getHAlign()||sap.ui.core.HorizontalAlign.Left,width:a.getWidth()||"auto",resizable:a.getResizable(),template:b};var y=new sap.ui.table.Column(x);y.setTemplate(b);y.data("definition",a);return y;},traverseBranch:function(a,b){var e=this.getAncestorItems(a);sap.ui.vtm.TreeItemUtilities.traverseBranch(a,b,e);return this;},traverseTree:function(a){this.getRootItems().forEach(function(b){this.traverseBranch(b,a,[]);}.bind(this));return this;},removeRoot:function(a){return sap.ui.vtm.TreeItemUtilities.removeRoot(this._rootItems,a);},addRoot:function(a){sap.ui.vtm.TreeItemUtilities.addRoot(this._rootItems,a);return this;},_attachColumnHeaderEvents:function(a){var b=a.getLabelControl();if(!b){return;}var e=a.getType();if(!e){throw"Column type not specified";}switch(e){case sap.ui.vtm.ColumnType.Internal:{var i=a.getDescriptor();if(!i){throw"Column descriptor not specified";}switch(i){case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:b.attachPress(function(){this.fireMessageStatusHeaderIconClicked({control:b});}.bind(this));break;case sap.ui.vtm.InternalColumnDescriptor.Visibility:b.attachPress(function(){this.fireVisibilityHeaderIconClicked({visibility:b.getVisibility(),control:b});}.bind(this));break;default:break;}switch(i){case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:case sap.ui.vtm.InternalColumnDescriptor.Visibility:b.addEventDelegate({onfocusin:function(x){b.getDomRef().blur();}},b);break;default:break;}}break;default:break;}return b;},_createColumnTemplate:function(a){var C=sap.ui.vtm.ColumnTemplates;var b=a.getType();if(!b){throw"Column type not specified";}switch(b){case sap.ui.vtm.ColumnType.Internal:{var e=a.getDescriptor();switch(e){case sap.ui.vtm.InternalColumnDescriptor.TreeItemId:return C.createTreeItemIdColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.Tree:return C.createTreeColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:var i=C.createMessageStatusColumnTemplate();i.attachPress(function(E){var z=E.getSource();var A=z.getBindingContext();var P=A.getPath();var B=this.getItemByBindingContextPath(P);this.fireMessageStatusIconClicked({item:B,control:z});}.bind(this));i.addEventDelegate({onfocusin:function(z){var A=sap.ui.getCore();var B=A.getCurrentFocusedControlId();var D=A.byId(B);if(D){var E=D.getDomRef();if(E){E.blur();}}}},i);return i;case sap.ui.vtm.InternalColumnDescriptor.AbsoluteMatrix:return C.createAbsoluteMatrixColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.RelativeMatrix:return C.createRelativeMatrixColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.SceneNodeIds:return C.createSceneNodeIdsColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.Visibility:var x=C.createVisibilityColumnTemplate();var y=function(z){var P=z.getBindingContext().getPath();var A=this.getItemByBindingContextPath(P);if(A){sap.ui.vtm.measure(this,"fireVisibilityIconClicked",function(){this.fireVisibilityIconClicked({item:A,visibility:A.visibility,control:z});}.bind(this));}}.bind(this);x.attachPress(function(z){var A=z.getSource();y(A);});x.addEventDelegate({onfocusin:function(z){var A=sap.ui.getCore();var B=A.getCurrentFocusedControlId();var D=A.byId(B);if(D){var E=D.getDomRef();if(E){E.blur();}}}},x);return x;case sap.ui.vtm.InternalColumnDescriptor.Opacity:return C.createOpacityColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.HighlightColor:return C.createHighlightColorColumnTemplate();default:throw"Unknown internal column type: "+e;}break;}case sap.ui.vtm.ColumnType.Metadata:return C.createMetadataColumnTemplate(a);case sap.ui.vtm.ColumnType.Identifier:return C.createIdentifierColumnTemplate(a);case sap.ui.vtm.ColumnType.AppData:return C.createAppDataColumnTemplate(a);default:throw"Invalid column type: "+b;}}});return T;});
