//@ui5-bundle sap/ui/vtm/library-preload.js
/*
 * ! SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.predefine('sap/ui/vtm/ArrayUtilities',['jquery.sap.global'],function(q){"use strict";var A={};
A.haveIntersection=function(c,e){switch(c.length){case 0:case 1:throw"At least two arrays expected when finding intersection";default:var d=c.slice();d.sort(function(a,b){return a.length-b.length;});var s=d[0];var i;var f=function(a){return e(a,i);};for(var j=0;j<s.length;j++){i=s[j];var g=true;for(var k=1;k<d.length;k++){var h=e?d[k].some(f):d[k].indexOf(i)!==-1;if(!h){g=false;break;}}if(g){return true;}}return false;}};
A.intersect=function(c,e){switch(c.length){case 0:case 1:throw"At least two arrays expected when finding intersection";default:var d=c.slice();d.sort(function(a,b){return a.length-b.length;});var i=[];var s=d[0];var f;var g=function(a){return e(a,f);};for(var j=0;j<s.length;j++){f=s[j];var h=true;for(var k=1;k<d.length;k++){var l=e?d[k].some(g):d[k].indexOf(f)!==-1;if(!l){h=false;break;}}if(h){if(i.indexOf(f)===-1){i.push(f);}}}return i;}};
A.union=function(a,e){var u=[];var b;var c=function(g){return e(g,b);};for(var j=0;j<a.length;j++){var d=a[j];for(var i=0;i<d.length;i++){b=d[i];var f=e?u.some(c):u.indexOf(b)!==-1;if(!f){u.push(b);}}}return u;};
A.toSet=function(a){var s=new Set();a.forEach(function(i){s.add(i);});return s;};
A.fromSet=function(s){var a=[];s.forEach(function(i){a.push(i);});return a;};
A.fromArrayLike=function(a){var b=[];for(var i=0;i<a.length;i++){b.push(a[i]);}return b;};
A.wrap=function(i){if(i===undefined){return[];}else if(Array.isArray(i)){return i;}return[i];};
A.unwrap=function(i){if(Array.isArray(i)){if(i.length==0){return undefined;}else if(i.length==1){return i[0];}else{return i;}}else{return i;}};
A.areEqual=function(a,e){if(!e){e=function(i,c){return i===c;};}var f=a[0];var r=a.slice(1);var l=f.length;var b=r.every(function(c){return l===c.length;});if(!b){return false;}return r.every(function(c){return c.every(function(i,d){return e(i,f[d]);});});};
A.shallowClone=function(a){return a.slice(0);};
A.deepClone=function(a,i){if(!i){return undefined;}return a.map(function(b){return i(b);});};
A.find=function(a,p){for(var i=0;i<a.length;i++){var b=a[i];if(p(b)){return b;}}return undefined;};
A.findIndex=function(a,p){for(var i=0;i<a.length;i++){if(p(a[i])){return i;}}return-1;};
A.flatten=function(a){return[].concat.apply([],a);};
return A;},true);
sap.ui.predefine('sap/ui/vtm/ChildCollectionType',[],function(){"use strict";sap.ui.vtm.ChildCollectionType={None:"None",Included:"Included",Excluded:"Excluded",IncludedAndExcluded:"IncludedAndExcluded"};return sap.ui.vtm.ChildCollectionType;},true);
sap.ui.predefine('sap/ui/vtm/Column',["jquery.sap.global","sap/ui/core/Element","sap/ui/commons/Label"],function(q,S,a){"use strict";
var C=S.extend("sap.ui.vtm.Column",{
metadata:{properties:{type:{type:"sap.ui.vtm.ColumnType"},descriptor:{type:"string"},tooltip:{type:"string",defaultValue:null},hAlign:{type:"sap.ui.core.HorizontalAlign",defaultValue:"Left"},width:{type:"sap.ui.core.CSSSize",defaultValue:"200px"},resizable:{type:"boolean",defaultValue:true},label:{type:"string"},labelControl:{type:"object"},valueFormatter:{type:"any"},tooltipFormatter:{type:"any"},template:{type:"sap.ui.core.Control"}}},
constructor:function(i,s){if(q.type(i)=="object"){s=i;i=s.id;}S.apply(this,[i,{}]);if(s){if(s.type){this.setType(s.type);}if(s.descriptor){this.setDescriptor(s.descriptor);}if(s.label){this.setLabel(s.label);}if(s.labelControl){this.setLabelControl(s.labelControl);}if(s.tooltip){this.setTooltip(s.tooltip);}if(s.hAlign){this.setHAlign(s.hAlign);}if(s.width){this.setWidth(s.width);}if(s.resizable===true||s.resizable===false){this.setResizable(s.resizable);}if(s.valueFormatter){this.setValueFormatter(s.valueFormatter);}if(s.tooltipFormatter){this.setTooltipFormatter(s.tooltipFormatter);}if(s.template){this.setTemplate(s.template);}}}
});
return C;});
sap.ui.predefine('sap/ui/vtm/ColumnTemplates',['jquery.sap.global'],function(q){"use strict";var C={};
C.createBasicColumnTemplate=function(l,a,t,b){if(!t){t=l;}if(!b){b=a;}var c=new sap.m.Text({wrapping:false});c.bindProperty("text",{path:l,formatter:a});c.bindProperty("tooltip",{path:t,formatter:b});return c;};
C.createTreeColumnTemplate=function(){var i=new sap.ui.core.Icon({decorative:false,src:"{iconUrl}",color:"{iconColor}",tooltip:"{iconTooltip}"});i.addStyleClass("sapUiVtmTree_TreeColumn_Icon");i.bindProperty("visible",{path:"iconUrl",formatter:function(b){return b?true:false;}});var n=new sap.ui.vtm.Text({wrapping:false,text:"{name}",tooltip:"{name}",textColor:"{textColor}"});n.addStyleClass("sapUiVtmTree_TreeColumn_NameText");var a=new sap.m.HBox({items:[i,n],alignContent:sap.m.FlexAlignContent.Center,alignItems:sap.m.FlexAlignItems.Center});return a;};
C.createMessageStatusColumnTemplate=function(){var m=new sap.ui.core.Icon({decorative:false,useIconTooltip:false,src:"{messageStatusIconUrl}",color:"{messageStatusIconColor}",tooltip:"{messageStatusIconTooltip}"});return m;};
C.createVisibilityColumnTemplate=function(){var r=sap.ui.vtm.getResourceBundle();var c=r.getText("COLUMNCELLTOOLTIP_VISIBILITY_CLICK_TO_SHOW");var a=r.getText("COLUMNCELLTOOLTIP_VISIBILITY_CLICK_TO_HIDE");var b=new sap.ui.vtm.CheckEye({visibility:{path:"",formatter:function(t){if(!t||t.visibility==null){return null;}return t.visibility;}},tooltip:{path:"",formatter:function(t){if(!t||t.visibility==null){return null;}return t.visibility?a:c;}}});return b;};
C.createTreeItemIdColumnTemplate=function(){return C.createBasicColumnTemplate("id");};
C._formatValue=function(v){if(v==undefined||v===null){return null;}switch(typeof v){case"string":return v;case"number":return v.toLocaleString();case"boolean":if(!C._true||!C._false){var r=sap.ui.vtm.getResourceBundle();C._trueString=r.getText("BOOLEAN_TRUE");C._falseString=r.getText("BOOLEAN_FALSE");}return v?C._trueString:C._falseString;default:return JSON.stringify(v);}};
C.metadataFormatterFactory=function(d,v){return function(t){if(!t||!t.metadata){return null;}var a=sap.ui.vtm.ArrayUtilities.wrap(t.metadata[d]);var f=a.map(C._formatValue);return f.join(v);};};
C.createMetadataColumnTemplate=function(c){var l=c.getValueFormatter()||C.metadataFormatterFactory(c.getDescriptor(),", ");var t=c.getTooltipFormatter()||C.metadataFormatterFactory(c.getDescriptor(),"\n");return C.createBasicColumnTemplate("",l,"",t);};
C.identifierFormatterFactory=function(d,v){return function(t){if(!t||!t.identifiers){return null;}var a=t.identifiers[d];return(a instanceof Array)?a.join(v):a;};};
C.createIdentifierColumnTemplate=function(c){var l=c.getValueFormatter()||C.identifierFormatterFactory(c.getDescriptor(),", ");var t=c.getTooltipFormatter()||C.identifierFormatterFactory(c.getDescriptor(),"\n");return C.createBasicColumnTemplate("",l,"",t);};
C.appDataFormatterFactory=function(d,v){return function(t){if(!t||!t.appData){return null;}var a=sap.ui.vtm.ArrayUtilities.wrap(t.appData[d]);var f=a.map(C._formatValue);return f.join(v);};};
C.createAppDataColumnTemplate=function(c){var l=c.getValueFormatter()||C.appDataFormatterFactory(c.getDescriptor(),", ");var t=c.getTooltipFormatter()||C.appDataFormatterFactory(c.getDescriptor(),"\n");return C.createBasicColumnTemplate("",l,"",t);};
C.matrixFormatterFactory=function(c,a){return function(m){if(!m){return null;}var b=sap.ui.vtm.MatrixUtilities.getMatrixComponentNames();var p=m.map(function(d,i){var e=d.toLocaleString();return q.sap.formatMessage(c,[b[i],e]);});return p.join(a);};};
C.createAbsoluteMatrixColumnTemplate=function(){return C.createBasicColumnTemplate("absoluteMatrix",C.matrixFormatterFactory("{1}"," "),"absoluteMatrix",C.matrixFormatterFactory("{0}:\t{1}","\n"));};
C.createRelativeMatrixColumnTemplate=function(){return C.createBasicColumnTemplate("relativeMatrix",C.matrixFormatterFactory("{1}"," "),"relativeMatrix",C.matrixFormatterFactory("{0}:\t{1}","\n"));};
C.createSceneNodeIdsColumnTemplate=function(){var f=function(t){if(!t){return null;}return sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(t).join(", ");};return C.createBasicColumnTemplate("",f);};
C.createOpacityColumnTemplate=function(){var f=function(t){if(!t||t.opacity===undefined||t.opacity===null){return null;}return""+t.opacity*100+"%";};return C.createBasicColumnTemplate("",f);};
C.createHighlightColorColumnTemplate=function(){var f=function(t){if(!t||t.highlightColor===undefined||t.sceneHighlightColor===null){return null;}return t.highlightColor;};return C.createBasicColumnTemplate("",f);};
return C;},true);
sap.ui.predefine('sap/ui/vtm/ColumnType',[],function(){"use strict";sap.ui.vtm.ColumnType={Metadata:"Metadata",Identifier:"Identifier",AppData:"AppData",Internal:"Internal"};return sap.ui.vtm.ColumnType;},true);
sap.ui.predefine('sap/ui/vtm/DescriptorUtilities',['jquery.sap.global'],function(q){"use strict";var D={};
D.createMetadataDescriptor=function(c,f){return JSON.stringify({category:c,field:f});};
D.createIdentifierDescriptor=function(s,t){return JSON.stringify({source:s,type:t});};
return D;},true);
sap.ui.predefine('sap/ui/vtm/DisplayGroup',["jquery.sap.global","sap/ui/core/Element"],function(q,S){"use strict";
var D=S.extend("sap.ui.vtm.DisplayGroup",{metadata:{properties:{displayStatesBySceneNodeId:{type:"object",defaultValue:{}}}}});
return D;},true);
sap.ui.predefine('sap/ui/vtm/Extension',["jquery.sap.global","sap/ui/core/Element"],function(q,S){"use strict";
var E=S.extend("sap.ui.vtm.Extension",{
metadata:{properties:{enabled:{type:"boolean",defaultValue:true,bindable:true}},events:{enabledChanged:{},initialized:{}}},
constructor:function(i,s){S.apply(this,arguments);var f=this.setParent;this.setParent=function(p,a,b){var r=f.apply(this,arguments);this.fireEvent("parentSet",{parent:p});return r;}.bind(this);},
init:function(){this.getVtmPromise().then(function(v){this._vtm=v;this.initialize(v);this.fireInitialized();}.bind(this));},
initialize:function(v){throw"initialize() needs to be redefined";},
setEnabled:function(e){this.setProperty("enabled",e);this.fireEnabledChanged();},
applyPanelHandler:function(p){var a=this._vtm.getPanels();a.forEach(p);this._vtm.attachPanelAdded(function(b){p(b.getParameter("panel"));});},
getVtmPromise:function(){return new Promise(function(r,a){this.attachEventOnce("parentSet",function(e){var p=e.getParameter("parent");if(p.getMetadata().getName()==="sap.ui.vtm.Vtm"){sap.ui.vtm.measure(this,"getVtmPromise resolve",function(){r(p);});}else{sap.ui.vtm.measure(this,"getVtmPromise reject",function(){a(p);});}}.bind(this));}.bind(this));},
getInitializedPromise:function(){return new Promise(function(r,a){this.attachInitialized(function(e){sap.ui.vtm.measure(this,"getInitializedPromise resolve",function(){r();});}.bind(this));}.bind(this));}
});
return E;});
sap.ui.predefine('sap/ui/vtm/HashUtilities',['jquery.sap.global'],function(q){"use strict";var H={};
H.hashString=function(s){var h=0xC716A2B2;for(var i=0;i<s.length;i++){h=((h+s.charCodeAt(i))*7)|0;}return h;};
H.hashMatrix=function(v){var h=0x16C7;for(var i=0;i<v.length;i++){var c=Math.round(Math.round(v[i]*10.0)/10.0);h=((c+h)*7)|0;}return h;};
H.normalizeHash=function(h,u){if(!u){u=50000;}return Math.abs(h)%u;};
H.combineHashes=function(h,u){var a=0xF23916C7;for(var i=0;i<h.length;i++){a=((h[i]+a)*3)|0;}return H.normalizeHash(a,u);};
return H;},true);
sap.ui.predefine('sap/ui/vtm/InternalColumnDescriptor',[],function(){"use strict";sap.ui.vtm.InternalColumnDescriptor={Tree:"Tree",MessageStatus:"MessageStatus",Visibility:"Visibility",TreeItemId:"TreeItemId",AbsoluteMatrix:"AbsoluteMatrix",RelativeMatrix:"RelativeMatrix",SceneNodeIds:"SceneNodeIds",Opacity:"Opacity",HighlightColor:"HighlightColor"};return sap.ui.vtm.InternalColumnDescriptor;},true);
sap.ui.predefine('sap/ui/vtm/InternalColumns',['jquery.sap.global',"./ColumnType","./InternalColumnDescriptor"],function(q,S,a){"use strict";var g=function(){return{type:S.Internal};};var I={};
I.createTreeColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.Tree,label:r.getText("COLUMNNAME_TREE"),tooltip:r.getText("COLUMNNAME_TREE"),width:"250px"});return new sap.ui.vtm.Column(s);};
I.createVisibilityColumn=function(){var r=sap.ui.vtm.getResourceBundle();var h=r.getText("COLUMNTOOLTIP_VISIBILITY_CLICK_TO_HIDE_ALL");var s=r.getText("COLUMNTOOLTIP_VISIBILITY_CLICK_TO_SHOW_ALL");var c=new sap.ui.vtm.CheckEye({visibility:true,decorative:false,tooltip:{path:"",formatter:function(){return c.visibility?h:s;}}});c.addEventDelegate({onfocusin:function(e){c.getDomRef().blur();}},c);var b=q.extend(g(),{descriptor:a.Visibility,labelControl:c,hAlign:sap.ui.core.HorizontalAlign.Center,width:"2.5em",resizable:false});return new sap.ui.vtm.Column(b);};
I.createMessageStatusColumn=function(){var r=sap.ui.vtm.getResourceBundle();var m=new sap.ui.core.Icon({src:"sap-icon://message-warning",tooltip:r.getText("COLUMNTOOLTIP_MESSAGESTATUS"),decorative:false});m.addEventDelegate({onfocusin:function(e){m.getDomRef().blur();}},m);var s=q.extend(g(),{descriptor:a.MessageStatus,labelControl:m,hAlign:sap.ui.core.HorizontalAlign.Center,width:"2.5em",resizable:false});s.labelControl.addStyleClass("sapUiVtmTree_StatusColumn_HeaderIcon");return new sap.ui.vtm.Column(s);};
I.createTreeItemIdColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.TreeItemId,label:r.getText("COLUMNNAME_TREEITEMID"),tooltip:r.getText("COLUMNNAME_TREEITEMID")});return new sap.ui.vtm.Column(s);};
I.createAbsoluteMatrixColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.AbsoluteMatrix,label:r.getText("COLUMNNAME_ABSOLUTEMATRIX"),tooltip:r.getText("COLUMNNAME_ABSOLUTEMATRIX")});return new sap.ui.vtm.Column(s);};
I.createRelativeMatrixColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.RelativeMatrix,label:r.getText("COLUMNNAME_RELATIVEMATRIX"),tooltip:r.getText("COLUMNNAME_RELATIVEMATRIX")});return new sap.ui.vtm.Column(s);};
I.createSceneNodeIdsColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.SceneNodeIds,label:r.getText("COLUMNNAME_SCENENODEIDS"),tooltip:r.getText("COLUMNNAME_SCENENODEIDS")});return new sap.ui.vtm.Column(s);};
I.createOpacityColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.Opacity,label:r.getText("COLUMNNAME_OPACITY"),tooltip:r.getText("COLUMNNAME_OPACITY")});return new sap.ui.vtm.Column(s);};
I.createHighlightColorColumn=function(){var r=sap.ui.vtm.getResourceBundle();var s=q.extend(g(),{descriptor:a.HighlightColor,label:r.getText("COLUMNNAME_HIGHLIGHTCOLOR"),tooltip:r.getText("COLUMNNAME_HIGHLIGHTCOLOR")});return new sap.ui.vtm.Column(s);};
return I;},true);
sap.ui.predefine('sap/ui/vtm/Lookup',["jquery.sap.global","sap/ui/core/Element","./ArrayUtilities"],function(q,S,a){"use strict";
var L=S.extend("sap.ui.vtm.Lookup",{
init:function(){this.clear();},
addValue:function(k,v){var b=this._valuesByKey;var c=b.get(k);if(c){c.push(v);}else{b.set(k,[v]);}return this;},
removeValue:function(k,v,e){if(!e){e=function(c,d){return c===d;};}var b=this._valuesByKey.get(k);if(b){var i=sap.ui.vtm.ArrayUtilities.findIndex(b,function(c){return e(v,c);});if(i>=0){b.splice(i,1);if(b.length==0){this._valuesByKey.delete(k);}}}return this;},
clear:function(){this._valuesByKey=new Map();return this;},
hasValue:function(k){return this._valuesByKey.has(k);},
getValues:function(k){var v=this._valuesByKey.get(k);if(v){v=v.slice();}return v||[];},
forEach:function(c){this._valuesByKey.forEach(c);return this;}
});
return L;});
sap.ui.predefine('sap/ui/vtm/MatrixComponent',[],function(){"use strict";sap.ui.vtm.MatrixComponent={LOCX:0,LOCY:1,LOCZ:2,AXIS1X:3,AXIS1Y:4,AXIS1Z:5,AXIS2X:6,AXIS2Y:7,AXIS2Z:8,AXIS3X:9,AXIS3Y:10,AXIS3Z:11,SCALE:12};return sap.ui.vtm.MatrixComponent;},true);
sap.ui.predefine('sap/ui/vtm/MatrixUtilities',['jquery.sap.global'],function(q){"use strict";var L=0,a=1,b=2,A=3,c=4,d=5,e=6,f=7,g=8,h=9,j=10,k=11,S=12,V=0,l=1,m=2,n=3,o=4,p=5,r=6,s=7,u=8,v=9,w=10,x=11,y=12;var M={};
M.isValid=function(i,t){if(!i||!Array.isArray(i)||i.length!==13){return false;}if(t){return M.isInvertible(i);}return true;};
M.createIdentity=function(){return[0,0,0,1,0,0,0,1,0,0,0,1,1];};
M.areEqual=function(t,z){for(var i=0;i<t.length;i++){if(Math.abs(t[i]-z[i])>0.01){return false;}}return true;};
M.isInvertible=function(i){var z=0.0,B=0.0,C=i[A],D=i[c],E=i[d],F=i[e],G=i[f],H=i[g],I=i[h],J=i[j],K=i[k],t=C*G*K;if(t>=0.0){z+=t;}else{B+=t;}t=F*J*E;if(t>=0.0){z+=t;}else{B+=t;}t=I*D*H;if(t>=0.0){z+=t;}else{B+=t;}t=-I*G*E;if(t>=0.0){z+=t;}else{B+=t;}t=-F*D*K;if(t>=0.0){z+=t;}else{B+=t;}t=-C*J*H;if(t>=0.0){z+=t;}else{B+=t;}var N=z+B;if(N==0||Math.abs(N)<((z-B)*1.0e-12)){return false;}return true;};
M.invert=function(i){var z=0.0,B=0.0,C=i[L],D=i[a],E=i[b],F=i[A],G=i[c],H=i[d],I=i[e],J=i[f],K=i[g],N=i[h],O=i[j],P=i[k],t=F*J*P,Q=M.createIdentity();if(t>=0.0){z+=t;}else{B+=t;}t=I*O*H;if(t>=0.0){z+=t;}else{B+=t;}t=N*G*K;if(t>=0.0){z+=t;}else{B+=t;}t=-N*J*H;if(t>=0.0){z+=t;}else{B+=t;}t=-I*G*P;if(t>=0.0){z+=t;}else{B+=t;}t=-F*O*K;if(t>=0.0){z+=t;}else{B+=t;}var R=z+B;if(R==0||Math.abs(R)<((z-B)*1.0e-12)){return Q;}var T=1.0/R;Q[A]=((J*P-O*K)*T);Q[c]=(-(G*P-O*H)*T);Q[d]=((G*K-J*H)*T);Q[e]=(-(I*P-N*K)*T);Q[f]=((F*P-N*H)*T);Q[g]=(-(F*K-I*H)*T);Q[h]=((I*O-N*J)*T);Q[j]=(-(F*O-N*G)*T);Q[k]=((F*J-I*G)*T);Q[L]=-(C*Q[A]+D*Q[e]+E*Q[h]);Q[a]=-(C*Q[c]+D*Q[f]+E*Q[j]);Q[b]=-(C*Q[d]+D*Q[g]+E*Q[k]);return Q;};
M.to4x4Matrix=function(i){var t=[];t[0]=[i[A],i[c],i[d],0];t[1]=[i[e],i[f],i[g],0];t[2]=[i[h],i[j],i[k],0];t[3]=[i[L],i[a],i[b],i[S]];return t;};
M.from4x4Matrix=function(i){var t=[];t[A]=i[0][0];t[c]=i[0][1];t[d]=i[0][2];t[e]=i[1][0];t[f]=i[1][1];t[g]=i[1][2];t[h]=i[2][0];t[j]=i[2][1];t[k]=i[2][2];t[L]=i[3][0];t[a]=i[3][1];t[b]=i[3][2];t[S]=i[3][3];return t;};
M.fromVkMatrix=function(i){var t=[];t[A]=i[0];t[c]=i[1];t[d]=i[2];t[e]=i[3];t[f]=i[4];t[g]=i[5];t[h]=i[6];t[j]=i[7];t[k]=i[8];t[L]=i[9];t[a]=i[10];t[b]=i[11];t[S]=1;return t;};
M.toVkMatrix=function(i){var t=[];t[0]=i[A];t[1]=i[c];t[2]=i[d];t[3]=i[e];t[4]=i[f];t[5]=i[g];t[6]=i[h];t[7]=i[j];t[8]=i[k];t[9]=i[L];t[10]=i[a];t[11]=i[b];return t;};
M.fromVsmMatrixString=function(i){var t=i.split(" ").map(function(B){return parseFloat(B);});var z=[];z[A]=t[V];z[c]=t[l];z[d]=t[m];z[e]=t[n];z[f]=t[o];z[g]=t[p];z[h]=t[r];z[j]=t[s];z[k]=t[u];z[L]=t[v];z[a]=t[w];z[b]=t[x];z[S]=t[y];return z;};
M.toVsmMatrixString=function(i){var t=[];t[V]=i[A];t[l]=i[c];t[m]=i[d];t[n]=i[e];t[o]=i[f];t[p]=i[g];t[r]=i[h];t[s]=i[j];t[u]=i[k];t[v]=i[L];t[w]=i[a];t[x]=i[b];t[y]=i[S];return t.join(" ");};
M.multiply=function(i,t){var z=[],B=i[L],C=i[a],D=i[b],E=i[A],F=i[c],G=i[d],H=i[e],I=i[f],J=i[g],K=i[h],N=i[j],O=i[k],P=i[S],Q=t[L],R=t[a],T=t[b],U=t[A],W=t[c],X=t[d],Y=t[e],Z=t[f],$=t[g],_=t[h],a1=t[j],b1=t[k],c1=t[S];z[A]=E*U+F*Y+G*_;z[c]=E*W+F*Z+G*a1;z[d]=E*X+F*$+G*b1;z[e]=H*U+I*Y+J*_;z[f]=H*W+I*Z+J*a1;z[g]=H*X+I*$+J*b1;z[h]=K*U+N*Y+O*_;z[j]=K*W+N*Z+O*a1;z[k]=K*X+N*$+O*b1;z[L]=B*U+C*Y+D*_+P*Q;z[a]=B*W+C*Z+D*a1+P*R;z[b]=B*X+C*$+D*b1+P*T;z[S]=P*c1;return z;};
M.getMatrixComponentNames=function(){if(!M._matrixComponentNames){var i=sap.ui.vtm.getResourceBundle();M._matrixComponentNames=[i.getText("TMATRIXCOMPONENT_LOCX"),i.getText("TMATRIXCOMPONENT_LOCY"),i.getText("TMATRIXCOMPONENT_LOCZ"),i.getText("TMATRIXCOMPONENT_AXIS1X"),i.getText("TMATRIXCOMPONENT_AXIS1Y"),i.getText("TMATRIXCOMPONENT_AXIS1Z"),i.getText("TMATRIXCOMPONENT_AXIS2X"),i.getText("TMATRIXCOMPONENT_AXIS2Y"),i.getText("TMATRIXCOMPONENT_AXIS2Z"),i.getText("TMATRIXCOMPONENT_AXIS3X"),i.getText("TMATRIXCOMPONENT_AXIS3Y"),i.getText("TMATRIXCOMPONENT_AXIS3Z"),i.getText("TMATRIXCOMPONENT_SCALE")];}return M._matrixComponentNames;};
return M;},true);
sap.ui.predefine('sap/ui/vtm/MessagesPopover',["jquery.sap.global","./library","sap/m/Popover","sap/m/PopoverRenderer","sap/m/List"],function(q,S,a,b,c){"use strict";
var M=sap.m.Popover.extend("sap.ui.vtm.MessagesPopover",{
metadata:{properties:{messages:{type:"object[]"},maxHeight:{type:"sap.ui.core.CSSSize",defaultValue:null}}},
init:function(){a.prototype.init.apply(this);this._rb=sap.ui.vtm.getResourceBundle();this.setShowHeader(false);this.attachAfterOpen(this._onAfterOpen,this);},
renderer:function(r,C){b.render.call(this,r,C);},
onAfterRendering:function(){var d=this.getDomRef();var m=parseInt(this.getMaxHeight(),10);if(m>0&&d.clientHeight>m){this.setContentHeight(this.getMaxHeight());}},
setMessages:function(m){var d=[];m.forEach(function(g){var h={text:g.getText()};var t=g.getLevel();var i=g.getIcon();switch(t){case sap.ui.core.MessageType.Error:h.iconUrl=i||"sap-icon://error";h.iconColor=sap.ui.core.IconColor.Negative;h.iconTooltip=this._rb.getText("MESSAGESTATUS_ERROR");break;case sap.ui.core.MessageType.Warning:h.iconUrl=i||"sap-icon://alert";h.iconColor=sap.ui.core.IconColor.Critical;h.iconTooltip=this._rb.getText("MESSAGESTATUS_WARNING");break;case sap.ui.core.MessageType.Success:h.iconUrl=i||"sap-icon://sys-enter-2";h.iconColor=sap.ui.core.IconColor.Positive;h.iconTooltip=this._rb.getText("MESSAGESTATUS_SUCCESS");break;case sap.ui.core.MessageType.Information:h.iconUrl=i||"sap-icon://message-information";h.iconColor=sap.ui.core.IconColor.Neutral;h.iconUrl=i||"sap-icon://message-information";h.iconTooltip=this._rb.getText("MESSAGESTATUS_INFORMATION");break;default:g.color=sap.ui.core.IconColor.Default;}d.push(h);}.bind(this));var e=new sap.ui.model.json.JSONModel();var f={messages:d};e.setData(f);var l=new sap.m.List();l.setModel(e,"model");l.bindItems("model>/messages",new sap.m.CustomListItem({content:[new sap.ui.layout.HorizontalLayout({content:[new sap.ui.core.Icon({src:"{model>iconUrl}",color:"{model>iconColor}",tooltip:"{model>iconTooltip}"}).addStyleClass("sapUiVtmTreeStatusItem"),new sap.m.Text({text:"{model>text}",tooltip:"{model>text}",wrapping:true}).addStyleClass("sapUiVtmTreeStatusItem")]})]}));this.addContent(l);return this;},
_onModelContextChanged:function(){this.close();},
_onAfterOpen:function(e){var C=e.getParameter("openBy");if(C){C.attachModelContextChange(this._onModelContextChanged,this);this.attachAfterClose(this._onAfterClose,this);}this.detachAfterOpen(this._onAfterOpen,this);},
_onAfterClose:function(e){var C=e.getParameter("openBy");if(C){C.detachModelContextChange(this._onModelContextChanged,this);this.detachAfterClose(this._onAfterClose,this);}setTimeout(function(){this.destroy();}.bind(this),0);}
});
return M;});
sap.ui.predefine('sap/ui/vtm/Panel',["jquery.sap.global","sap/ui/core/Control","sap/ui/commons/Panel","sap/ui/core/Title","sap/m/VBox","sap/ui/layout/Splitter","./Tree","./Viewport"],function(q,S,a,b,c,d,e,f){"use strict";
var P=S.extend("sap.ui.vtm.Panel",{
metadata:{properties:{title:{type:"string"},showViewport:{type:"boolean",defaultValue:true},treeWidth:{type:"sap.ui.core.CSSSize",defaultValue:"50%"},height:{type:"sap.ui.core.CSSSize",defaultValue:"inherit"}},aggregations:{_panel:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},titleControls:{type:"sap.ui.core.Control",multiple:"true"},treeHeaderControls:{type:"sap.ui.core.Control",multiple:"true"},viewportHeaderControls:{type:"sap.ui.core.Control",multiple:"true"}},associations:{vtmId:{type:"sap.ui.vtm.Vtm",multiple:false}},events:{initialized:{},contextMenu:{parameters:{clientX:{type:"int"},clientY:{type:"int"},pageX:{type:"int"},pageY:{type:"int"},screenX:{type:"int"},screenY:{type:"int"},eventData:{type:"object"}},allowPreventDefault:true}}},
init:function(){var i=this.getId();var t=this._tree=new sap.ui.vtm.Tree(i+"_tree");var v=this._viewport=new sap.ui.vtm.Viewport(i+"_viewport");var g=this._title=new sap.m.Title({textAlign:sap.ui.core.TextAlign.Begin});var p=this._panelHeader=new sap.m.Bar({contentLeft:[g]});this._treeLayout=new sap.ui.layout.SplitterLayoutData({minSize:10});var h=new sap.ui.layout.SplitPane({content:t,demandPane:false,requiredParentWidth:50,layoutData:this._treeLayout});this._viewportLayout=new sap.ui.layout.SplitterLayoutData({minSize:10});var j=new sap.ui.layout.SplitPane({content:v,demandPane:false,requiredParentWidth:50,layoutData:this._viewportLayout});var r=new sap.ui.layout.PaneContainer({panes:[h,j]});var s=this._splitter=new sap.ui.layout.ResponsiveSplitter({rootPaneContainer:r,defaultPane:h});var k=this._page=new sap.m.Page({content:[s],customHeader:p,layoutData:new sap.m.FlexItemData({minHeight:"100%",maxHeight:"100%"})});var l=function(n){var o;sap.ui.vtm.measure(this,"fireContextMenu",function(){o=this.fireContextMenu({clientX:n.clientX,clientY:n.clientY,pageX:n.pageX,pageY:n.pageY,screenX:n.screenX,screenY:n.screenY,eventData:n});}.bind(this));if(!o){n.preventDefault();}}.bind(this);k.addEventDelegate({oncontextmenu:l},k);var m=new sap.m.VBox({fitContainer:true,renderType:sap.m.FlexRendertype.Bare,items:[k]});this.setAggregation("_panel",m);this.data("notUsed","just a bug workaround");this._oldPanes=[];this._setIsActive(false);},
onAfterRendering:function(){if(!this._initialized){this._initialize();}},
_initialize:function(){var v=this.getVtm();if(v){v._addPanel(this);this._initialized=true;sap.ui.vtm.measure(this,"fireInitialized",function(){this.fireInitialized();}.bind(this));}},
destroy:function(){S.prototype.destroy.apply(this);this._destroyed=true;var g=this.getVtm().getPanels().every(function(p){return p._destroyed===true;});if(g){this.getVtm().getScene().destroy();}},
onmousedown:function(E){this.getVtm()._setActivePanel(this,false);},
onfocusin:function(E){this.getVtm()._setActivePanel(this,false);},
onfocusout:function(E){var v=this.getVtm();if(v.getActivePanel()===this){v._setActivePanel(null,false);}},
addTreeHeaderControl:function(t){return this.getTree().addHeaderControl(t);},
addViewportHeaderControl:function(v){return this.getViewport().addHeaderControl(v);},
destroyTreeHeaderControls:function(){return this;},
destroyViewportHeaderControls:function(){return this;},
getTreeHeaderControls:function(){return this.getTree().getHeaderControls();},
getViewportHeaderControls:function(){return this.getViewport().getHeaderControls();},
indexOfTreeHeaderControl:function(t){return this.getTree().indexOfHeaderControl(t);},
indexOfViewportHeaderControl:function(v){return this.getViewport().indexOfHeaderControl(v);},
insertTreeHeaderControl:function(t,i){return this.getTree().insertHeaderControl(t,i);},
insertViewportHeaderControl:function(v,i){return this.getViewport().insertHeaderControl(v,i);},
removeAllTreeHeaderControls:function(){return this.getTree().removeAllControls();},
removeAllViewportHeaderControls:function(){return this.getViewport().removeAllControls();},
removeTreeHeaderControl:function(t){return this.getTree().removeControl(t);},
removeViewportHeaderControl:function(v){return this.getViewport().removeControl(v);},
_getDelegatedAggregation:function(A){switch(A){case"treeHeaderControls":return{control:this.getTree(),aggregationName:A};case"viewportHeaderControls":return{control:this.getViewport(),aggregationName:A};case"titleControls":return{control:this._panelHeader,name:"contentRight"};default:return null;}},
addAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.addAggregation(g.name,o,s);}else{return S.prototype.addAggregation.apply(this,[A,o,s]);}},
bindAggregation:function(A,B){var g=this._getDelegatedAggregation(A);if(g){return g.control.bindAggregation(g.name);}else{return S.prototype.bindAggregation.apply(this,[A]);}},
destroyAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return this;}else{return S.prototype.destroyAggregation.apply(this,[A,s]);}},
getAggregation:function(A,D){var g=this._getDelegatedAggregation(A);if(g){return g.control.getAggregation(g.name,D);}else{return S.prototype.getAggregation.apply(this,[A,D]);}},
indexOfAggregation:function(A,o){var g=this._getDelegatedAggregation(A);if(g){return g.control.indexOfAggregation(g.name,o);}else{return S.prototype.indexOfAggregation.apply(this,[A,o]);}},
insertAggregation:function(A,o,i,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.insertAggregation(g.name,o,i,s);}else{return S.prototype.insertAggregation.apply(this,[A,o,i,s]);}},
removeAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.removeAggregation(g.name,A,o,s);}else{return S.prototype.removeAggregation.apply(this,[A,o,s]);}},
removeAllAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.removeAllAggregation(g.name,A,s);}else{return S.prototype.removeAllAggregation.apply(this,[A,s]);}},
setAggregation:function(A,o,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.setAggregation(g.name,o,s);}else{return S.prototype.setAggregation.apply(this,[A,o,s]);}},
unbindAggregation:function(A,s){var g=this._getDelegatedAggregation(A);if(g){return g.control.unbindAggregation(g.name,s);}else{return S.prototype.unbindAggregation.apply(this,[A,s]);}},
validateAggregation:function(A,o,m){var g=this._getDelegatedAggregation(A);if(g){return g.control.validateAggregation(g.name,o,m);}else{return S.prototype.validateAggregation.apply(this,[A,o,m]);}},
_getPanel:function(){return this.getAggregation("_panel");},
_getTreeLayoutData:function(){return this._treeLayout;},
_getViewportLayoutData:function(){return this._viewportLayout;},
renderer:function(r,C){r.write("<div");r.writeControlData(C);r.addStyle("height",C.getHeight());r.writeStyles();r.writeClasses();r.write(">");var p=C._getPanel();r.renderControl(p);r.write("</div>");},
setTitle:function(t){this._title.setText(t);this.setProperty("title",t);return this;},
getTree:function(){return this._tree;},
getViewport:function(){return this._viewport;},
setShowViewport:function(s){if(s===this.getShowViewport()){return this;}var _=this.getTreeWidth();this.setProperty("showViewport",s);var g=this._splitter.getDefaultPane();var r=this._splitter.getRootPaneContainer();var p=r.getPanes();if(!s){this._oldTreeWidth=_;p.forEach(function(h){if(h.getId()!==g){r.removePane(h);this._oldPanes.push(h);}}.bind(this));this.setTreeWidth("auto");}else{this._oldPanes.forEach(function(h){r.addPane(h);});this._oldPanes=[];this.setTreeWidth(this._oldTreeWidth);this._oldTreeWidth=null;}return this;},
getVtm:function(){if(!this._vtm){this._vtm=sap.ui.getCore().byId(this.getVtmId());}return this._vtm;},
_setIsActive:function(i){var g=this._isActive;if(g!==i){this._isActive=i;var p=this._getPanel();if(i){p.addStyleClass("sapUiVtmPanel_ActiveBorder");p.removeStyleClass("sapUiVtmPanel_InactiveBorder");}else{p.addStyleClass("sapUiVtmPanel_InactiveBorder");p.removeStyleClass("sapUiVtmPanel_ActiveBorder");}}return this;},
getIsActive:function(){return this._isActive;},
getTreeWidth:function(){if(!this.getShowViewport()){return"100%";}var t=this._getTreeLayoutData();var s=t.getSize();if(s==="auto"){return"50%";}return s;},
setTreeWidth:function(t){if(!t){return this;}if(t==="auto"){t=this.getShowViewport()?"50%":"100%";}var p=t.indexOf("%")>-1;var g=this._getTreeLayoutData();var v=this._getViewportLayoutData();if(t.indexOf("px")>-1||p){var s=parseInt(t,10);if(s<0){q.sap.log.error("Negative treeWidth values are not permitted",null,"sap.ui.vtm.Panel");return this;}if(p&&s>100){t="100%";}}else{var m="Illegal treeWidth value: "+t;q.sap.log.error(m,null,"sap.ui.vtm.Panel");return this;}g.setSize(t);v.setSize("auto");return this;}
});
return P;});
sap.ui.predefine('sap/ui/vtm/PredefinedView',[],function(){"use strict";var P={Top:"Top",Bottom:"Bottom",Front:"Front",Back:"Back",Left:"Left",Right:"Right"};return P;},true);
sap.ui.predefine('sap/ui/vtm/Progress',["jquery.sap.global","sap/ui/core/Control","sap/m/Text","sap/m/ProgressIndicator"],function(q,S,a,b){"use strict";
var P=S.extend("sap.ui.vtm.Progress",{
metadata:{aggregations:{progressText:{type:"sap.m.Title",multiple:false},progressBar:{type:"sap.m.ProgressIndicator",multiple:false}}},
init:function(){var p=new sap.m.ProgressIndicator({width:"100%"});p.addStyleClass("sapUiVtmProgress_progressBar");this.setProgressBar(p);var c=new sap.m.Title({width:"100%",titleStyle:sap.ui.core.TitleLevel.H3,textAlign:sap.ui.core.TextAlign.Center});c.addStyleClass("sapUiVtmProgress_progressText");this.setProgressText(c);this.addStyleClass("sapUiVtmProgress");},
renderer:function(r,c){r.write("<div");r.writeControlData(c);r.addStyle("height","inherit");r.writeStyles();r.writeClasses();r.write(">");r.renderControl(c.getProgressText());r.renderControl(c.getProgressBar());r.write("</div>");}
});
return P;});
sap.ui.predefine('sap/ui/vtm/ProgressDialog',["jquery.sap.global","./library","sap/ui/core/Control","sap/m/Dialog","./Progress"],function(q,S,a,b,c){"use strict";
var P=a.extend("sap.ui.vtm.ProgressDialog",{
metadata:{properties:{progressText:{type:"string"},percentComplete:{type:"int",defaultValue:0},progressBarVisible:{type:"boolean",defaultValue:"true"}}},
init:function(){this._oProgress=new sap.ui.vtm.Progress();this._oDialog=new sap.m.Dialog(this.getId()+'-Dialog',{showHeader:false,content:[this._oProgress],verticalScrolling:false,horizontalScrolling:false});},
renderer:function(r,C){},
open:function(){return this._oDialog.open();},
isOpen:function(){return this._oDialog.isOpen();},
close:function(){return this._oDialog.close();},
setPercentComplete:function(p){this.setProperty("percentComplete",p);this._oProgress.getProgressBar().setPercentValue(p);sap.ui.getCore().applyChanges();},
setProgressText:function(p){this.setProperty("progressText",p);this._oProgress.getProgressText().setText(p);sap.ui.getCore().applyChanges();},
setProgressBarVisible:function(p){this.setProperty("progressBarVisible",p);this._oProgress.getProgressBar().setVisible(p);}
});
return P;});
sap.ui.predefine('sap/ui/vtm/Scene',["jquery.sap.global","sap/ui/core/Element","sap/ui/vk/dvl/GraphicsCore","sap/ui/vk/Scene","sap/ui/vk/NodeHierarchy","./ViewableLoadInfo","./SceneNode","./ArrayUtilities"],function(q,S,a,b,c,d,e,f){"use strict";
var g=S.extend("sap.ui.vtm.Scene",{
metadata:{events:{downloadProgress:{parameters:{viewable:{type:"sap.ui.vtm.Viewable"},downloadedBytes:{type:"int"},totalBytes:{type:"int"}}},downloadStarted:{parameters:{viewableLoadInfos:{type:"sap.ui.vtm.ViewableLoadInfo[]"}}},downloadCompleted:{parameters:{viewableLoadInfos:{type:"sap.ui.vtm.ViewableLoadInfo[]"},downloadedViewables:{type:"sap.ui.vtm.Viewable[]"}}},loadStarted:{parameters:{viewableLoadInfos:{type:"sap.ui.vtm.ViewableLoadInfo[]"}}},loadProgress:{viewable:{type:"sap.ui.vtm.Viewable"},percentage:{type:"float"}},loadCompleted:{parameters:{succeeeded:{type:"boolean"},viewableLoadInfos:{type:"sap.ui.vtm.ViewableLoadInfo[]"},loadedViewables:{type:"sap.ui.vtm.Viewable[]"}}},hierarchyChanged:{}}},
init:function(){var v=new a({},{antialias:true,alpha:true,premultipliedAlpha:false});this._viewablesBySource=new Map();this._viewableLoadInfosByViewable=new Map();this._vkGraphicsCore=v;this._rootContentResource=new sap.ui.vk.ContentResource({localMatrix:sap.ui.vtm.MatrixUtilities.toVkMatrix(sap.ui.vtm.MatrixUtilities.createIdentity())});v.attachEvent("sceneLoadingProgress",function(h){var s=h.getParameter("sourceName"),p=h.getParameter("percentage")*100,i=this._viewablesBySource.get(s);this.fireLoadProgress({viewable:i,percentage:p});}.bind(this));},
destroy:function(){if(this._vkGraphicsCore!==null){this._vkGraphicsCore.destroy();this._vkGraphicsCore=null;}S.prototype.destroy.apply(this);},
_raiseHierarchyChanged:function(){sap.ui.vtm.measure(this,"fireHierarchyChanged",function(){this.fireHierarchyChanged();}.bind(this));},
_getViewableLoadInfos:function(v){var h=[];v.forEach(function(i){var j=this._viewableLoadInfosByViewable.get(i);h.push(j);}.bind(this));return h;},
_raiseDownloadStarted:function(v){sap.ui.vtm.measure(this,"fireDownloadStarted",function(){var h=this._getViewableLoadInfos(v);this.fireDownloadStarted({viewableLoadInfos:h});}.bind(this));},
_raiseDownloadCompleted:function(v){sap.ui.vtm.measure(this,"fireDownloadCompleted",function(){var h=this._getViewableLoadInfos(v);var i=h.filter(function(j){return j.getStatus()===sap.ui.vtm.ViewableLoadStatus.Downloaded;}).map(function(j){return j.getViewable();});this.fireDownloadCompleted({viewableLoadInfos:h,downloadedViewables:i});}.bind(this));},
_raiseLoadStarted:function(v){sap.ui.vtm.measure(this,"fireLoadStarted",function(){var h=this._getViewableLoadInfos(v);this.fireLoadStarted({viewableLoadInfos:h});}.bind(this));},
_raiseLoadCompleted:function(s,v){sap.ui.vtm.measure(this,"fireLoadCompleted",function(){var h=this._getViewableLoadInfos(v);var l=h.filter(function(i){return i.getStatus()===sap.ui.vtm.ViewableLoadStatus.Loaded;}).map(function(i){return i.getViewable();});this.fireLoadCompleted({succeeded:s,viewableLoadInfos:h,loadedViewables:l});}.bind(this));},
getRootIds:function(){if(this._vkNodeHierarchy){var r=this._vkNodeHierarchy.getChildren();this.addCachedIds(r);return r;}return[];},
_getSceneNode:function(s){if(!this._vkNodeHierarchy){throw"Scene hierarchy is empty";}var h=new sap.ui.vtm.SceneNode({sceneNodeId:s,scene:this});return h;},
_getNodeHierarchy:function(){return this._vkNodeHierarchy;},
_traverseBranch:function(s,h,i,j){i.setSceneNodeId(s);if(h(i,j)===false){return;}j.push(s);if(!i.getClosed()){var k=this.getChildIds(s);k.forEach(function(l){this._traverseBranch(l,h,i,j);}.bind(this));}j.pop();},
traverseBranch:function(s,h){if(!s){throw"sceneNodeId not defined";}if(!h){throw"callback not defined";}sap.ui.vtm.measure(this,"traverseBranch ("+s+")",function(){var i=this._getSceneNode(s);var j=this.getAncestorIds(s);this._traverseBranch(s,h,i,j);i._destroy();}.bind(this));return this;},
traverseTree:function(h){if(!h){throw"callback not defined";}if(!this._vkNodeHierarchy){return this;}sap.ui.vtm.measure(this,"traverseTree",function(){var r=this.getRootIds();var s=this._getSceneNode(null);r.forEach(function(i){this._traverseBranch(i,h,s,[]);}.bind(this));s._destroy();}.bind(this));return this;},
traverseNodes:function(s,h){if(!s){throw"sceneNodeIds not defined";}if(!h){throw"callback not defined";}if(!Array.isArray(s)){s=[s];}sap.ui.vtm.measure(this,"traverseNodes ("+s.join(",")+")",function(){var j=this._getSceneNode(null);for(var i=0;i<s.length;i++){j.setSceneNodeId(s[i]);if(h(j,i)===false){break;}}j._destroy();}.bind(this));return this;},
_handleLoadContentResourcesAsyncCompleted:function(h,v){v.forEach(function(i){var s=i.getSource();var j=sap.ui.vtm.ArrayUtilities.find(h,function(j){return j.source===s;});var k=this._viewableLoadInfosByViewable.get(i);if(j){k.setStatus(sap.ui.vtm.ViewableLoadStatus.DownloadFailed);k.setErrorCode(j.status);k.setErrorText(j.statusText);}else{k.setStatus(sap.ui.vtm.ViewableLoadStatus.Downloaded);}}.bind(this));this._raiseDownloadCompleted(v);if(this.getDownloadedViewables().length!=0){this._raiseLoadStarted(v);setTimeout(function(){var u=function(){v.forEach(function(n){var o=this._viewableLoadInfosByViewable.get(n);var p=o.getStatus();if(p===sap.ui.vtm.ViewableLoadStatus.Loaded&&!n.getRootNodeIds()){var r=n._getContentResource().getNodeProxy();if(r){var t=r.getNodeId();this.addCachedIds(t);var w=this.getChildIds(t);n.setRootNodeIds(w);}}}.bind(this));}.bind(this);var i=function(n){var o=sap.ui.vtm.ArrayUtilities.find(v,function(o){return o.getSource()===n;});if(o){var p=this._viewableLoadInfosByViewable.get(o);p.setStatus(sap.ui.vtm.ViewableLoadStatus.Loaded);}}.bind(this);var j=function(n){var o=sap.ui.vtm.ArrayUtilities.find(v,function(o){return o.getSource()===n;});if(o){var p=this._viewableLoadInfosByViewable.get(o);p.setStatus(sap.ui.vtm.ViewableLoadStatus.LoadFailed);}}.bind(this);var s=function(n){var o=n.getParameter("source");var p=n.getParameter("sceneId");if(p){i(o);}else{j(o);}};this._vkGraphicsCore.attachSceneLoadingFinished(s);var k=v.filter(function(n){var o=this._viewableLoadInfosByViewable.get(n);switch(o.getStatus()){case sap.ui.vtm.ViewableLoadStatus.Downloading:case sap.ui.vtm.ViewableLoadStatus.DownloadFailed:return false;default:return true;}}.bind(this));k.forEach(function(n){var o=n._getContentResource();if(this._rootContentResource.getContentResources().indexOf(o)<0){this._rootContentResource.addContentResource(o);}}.bind(this));if(!this._sceneCreated){var l=sap.ui.vtm.createMeasureId(this,"Building scene tree");q.sap.measure.start(l,"",["sap.ui.vtm"]);this._vkGraphicsCore.buildSceneTreeAsync([this._rootContentResource]).then(function(n){q.sap.measure.end(l);this._vkGraphicsCore.detachSceneLoadingFinished(s);this._vkScene=n.scene;this._vkNodeHierarchy=this._vkScene.getDefaultNodeHierarchy();var r=this.getRootIds();this.addCachedIds(r);u();this._sceneCreated=true;this.fireEvent("sceneCreated");this._raiseHierarchyChanged();this._raiseLoadCompleted(true,v);}.bind(this)).catch(function(r){q.sap.measure.end(l);this._vkGraphicsCore.detachSceneLoadingFinished(s);this._raiseLoadCompleted(false,v);}.bind(this));}else{var m=sap.ui.vtm.createMeasureId(this,"Updating scene tree");q.sap.measure.start(m,"",["sap.ui.vtm"]);this._vkGraphicsCore.updateSceneTreeAsync(this._vkScene,[this._rootContentResource]).then(function(n){q.sap.measure.end(m);this._vkGraphicsCore.detachSceneLoadingFinished(s);u();this._raiseHierarchyChanged();this._raiseLoadCompleted(true,v);}.bind(this)).catch(function(r){q.sap.measure.end(m);this._vkGraphicsCore.detachSceneLoadingFinished(s);if(r.contentResourcesWithEncryptedVds3){r.contentResourcesWithEncryptedVds3.forEach(function(n){var o=n.getSource();j(o);});}if(r.contentResourcesWithMissingPasswords){r.contentResourcesWithMissingPasswords.forEach(function(n){var o=n.getSource();j(o);});}this._raiseLoadCompleted(false,v);}.bind(this));}}.bind(this),50);}},
_handleLoadContentResourcesAsyncProgress:function(p,v){var s=p.getParameter("source");var h=p.getParameter("loaded");var t=p.getParameter("total");var i=sap.ui.vtm.ArrayUtilities.find(v,function(i){return s===i.getSourceString();});sap.ui.vtm.measure(this,"fireDownloadProgress",function(){this.fireDownloadProgress({viewable:i,downloadedBytes:h,totalBytes:t});}.bind(this));},
loadViewablesAsync:function(v){if(!v){throw"viewables not specified";}v=sap.ui.vtm.ArrayUtilities.wrap(v);if(!v.length){throw"viewables is empty";}v.forEach(function(h){var s=h.getSourceString();if(!this._viewablesBySource.has(s)){this._viewablesBySource.set(s,h);}var i=new sap.ui.vtm.ViewableLoadInfo({viewable:h,status:sap.ui.vtm.ViewableLoadStatus.Downloading});this._viewableLoadInfosByViewable.set(h,i);}.bind(this));this._raiseDownloadStarted(v);setTimeout(function(){var s=v.map(function(j){return j.getSourceString();});var h=v.map(function(j){return j._getContentResource();});var i=sap.ui.vtm.createMeasureId(this,"Downloading "+s.join(", "));q.sap.measure.start(i,"",["sap.ui.vtm"]);this._vkGraphicsCore.loadContentResourcesAsync(h,function(j){q.sap.measure.end(i);j=j=j||[];this._handleLoadContentResourcesAsyncCompleted(j,v);}.bind(this),function(p){this._handleLoadContentResourcesAsyncProgress(p,v);}.bind(this));}.bind(this),50);return this;},
getDownloadedViewables:function(){var h=[];this._viewableLoadInfosByViewable.forEach(function(v,i){switch(v.getStatus()){case sap.ui.vtm.ViewableLoadStatus.Downloading:case sap.ui.vtm.ViewableLoadStatus.DownloadFailed:break;default:h.push(i);break;}});return h;},
getLoadedViewables:function(){var l=[];this._viewableLoadInfosByViewable.forEach(function(v,h){if(v.getStatus()===sap.ui.vtm.ViewableLoadStatus.Loaded){l.push(h);}});return l;},
getViewableLoadInfos:function(){var v;this._viewableLoadInfosByViewable.forEach(function(h,i){v.push(h);});return v;},
getAncestorIds:function(s){if(this._vkNodeHierarchy){var h=this._vkNodeHierarchy.getAncestors(s);this.addCachedIds(h);return h;}return[];},
getParentId:function(s){var h=this.getAncestorIds(s);if(h&&h.length){return h[h.length-1];}return null;},
getChildIds:function(s){if(this._vkNodeHierarchy){var h=this._vkNodeHierarchy.getChildren(s,true);this.addCachedIds(h);return h;}return[];},
getDescendantIds:function(s){var h=[];sap.ui.vtm.measure(this,"getDescendantIds ("+s+")",function(){var i=function(s){var j=this.getChildIds(s);j.forEach(function(k){h.push(k);i(k);});}.bind(this);i(s);}.bind(this));this.addCachedIds(h);return h;},
getAllIds:function(){var r=this.getRootIds();var h=[];r.forEach(function(i){h.push(i);var j=this.getDescendantIds(i);h=h.concat(j);}.bind(this));this.setCachedIds(h);return h;},
getCachedIds:function(){if(!this._cachedIds||!this._cachedIds.length){this._cachedIds=this.getAllIds();}return this._cachedIds;},
setCachedIds:function(s){this._cachedIds=s;return this;},
addCachedIds:function(s){if(!this._cachedIds){this._cachedIds=[];}s=sap.ui.vtm.ArrayUtilities.wrap(s);s.forEach(function(h){if(this._cachedIds.indexOf(h)===-1){this._cachedIds.push(h);}}.bind(this));return this;},
removeCachedIds:function(s){if(this._cachedIds){s=sap.ui.vtm.ArrayUtilities.wrap(s);this._cachedIds=this._cachedIds.filter(function(h){return s.indexOf(h)===-1;});}return this;},
createNode:function(p,i,n){var h=this._vkNodeHierarchy.createNode(p,n,i);this.addCachedIds(h);this._raiseHierarchyChanged();return h;},
cloneNode:function(n,p,i,h,r){var j=this._vkNodeHierarchy.createNodeCopy(n,p,h,i);r=r===undefined||r===null?true:r;this.addCachedIds(j);if(!r){var k=this.getChildIds(j);k.forEach(function(l){this.deleteNode(l);}.bind(this));}else{this.addCachedIds(this.getDescendantIds(j));}this._raiseHierarchyChanged();return j;},
deleteNode:function(n){this.removeCachedIds(n);this.removeCachedIds(this.getDescendantIds(n));this._vkNodeHierarchy.removeNode(n);this._raiseHierarchyChanged();return this;},
getVtm:function(){return this.getParent();}
});
return g;});
sap.ui.predefine('sap/ui/vtm/SceneNode',["jquery.sap.global","sap/ui/core/Element","sap/ui/vk/NodeProxy","./ArrayUtilities","./MatrixUtilities"],function(q,S,a,b,c){"use strict";
var d=S.extend("sap.ui.vtm.SceneNode",{
metadata:{properties:{sceneNodeId:{type:"string"},scene:{type:"object"}}},
_destroy:function(){if(this._vkNodeProxy){this.getScene()._getNodeHierarchy().destroyNodeProxy(this.getSceneNodeId());this._vkNodeProxy=null;}},
exit:function(){this._destroy();},
_checkValidity:function(){if(!this._vkNodeProxy){throw"Node has been destroyed";}},
setSceneNodeId:function(s){this._destroy();this.setProperty("sceneNodeId",s);var o=this.getScene();if(o){this._vkNodeProxy=o._getNodeHierarchy().createNodeProxy(s);}return this;},
setScene:function(s){this._destroy();this.setProperty("scene",s);var e=this.getSceneNodeId();if(e){this._vkNodeProxy=s._getNodeHierarchy().createNodeProxy(e);}return this;},
getName:function(){this._checkValidity();return this._vkNodeProxy.getName();},
getClosed:function(){this._checkValidity();return this._vkNodeProxy.getClosed();},
getRelativeMatrix:function(){this._checkValidity();var v=this._vkNodeProxy.getLocalMatrix();return v?sap.ui.vtm.MatrixUtilities.fromVkMatrix(v):null;},
setRelativeMatrix:function(m){this._checkValidity();var v=sap.ui.vtm.MatrixUtilities.toVkMatrix(m);this._vkNodeProxy.setLocalMatrix(v);return this;},
getAbsoluteMatrix:function(){this._checkValidity();var v=this._vkNodeProxy.getWorldMatrix();return v?sap.ui.vtm.MatrixUtilities.fromVkMatrix(v):null;},
setAbsoluteMatrix:function(m){this._checkValidity();var v=sap.ui.vtm.MatrixUtilities.toVkMatrix(m);this._vkNodeProxy.setWorldMatrix(v);return this;},
_fromVkMetadata:function(v){var r={};var e=Object.getOwnPropertyNames(v);e.forEach(function(f){var m=v[f];var g=Object.getOwnPropertyNames(m);g.forEach(function(h){var i=m[h];var j={category:f,field:h};r[JSON.stringify(j)]=i;});});return r;},
getNodeMetadata:function(){this._checkValidity();var v=this._vkNodeProxy.getNodeMetadata();return v?this._fromVkMetadata(v):{};},
_fromVkVeIds:function(v){var r={};v.forEach(function(i){var k=JSON.stringify({source:i.source,type:i.type});var e=JSON.stringify(i.fields);var f=r[k];if(f){var g=sap.ui.vtm.ArrayUtilities.wrap(f);g.push(e);r[k]=g;}else{r[k]=e;}});return r;},
getIdentifiers:function(){this._checkValidity();var v=this._vkNodeProxy.getVeIds();return v?this._fromVkVeIds(v):{};}
});
return d;},true);
sap.ui.predefine('sap/ui/vtm/SelectColumnsDialog',["jquery.sap.global","./library","./ColumnType","sap/ui/core/Control","sap/m/TableSelectDialog","./Progress","./InternalColumns"],function(q,S,a,b,c,d,e){"use strict";
var f=b.extend("sap.ui.vtm.SelectColumnsDialog",{
metadata:{properties:{tree:{type:"object"},selectableColumns:{type:"sap.ui.vtm.Column[]"}}},
init:function(){this._oDialog=this._createDialog();},
renderer:function(r,C){},
_createDialog:function(){var r=sap.ui.vtm.getResourceBundle();var s=new sap.m.TableSelectDialog(this.getId()+'-Dialog',{multiSelect:true,columns:[new sap.m.Column({visible:false}),new sap.m.Column({visible:false}),new sap.m.Column({header:new sap.m.Label({text:r.getText("COLUMNNAME_NAME")})})],noDataText:r.getText("SELECTCOLUMNSDIALOG_NOCOLUMNSAVAILABLE")});var i=new sap.m.ColumnListItem({type:"Active",unread:false,cells:[new sap.m.Label({text:"{mProperties/type}"}),new sap.m.Label({text:"{mProperties/descriptor}"}),new sap.m.Label({text:"{mProperties/label}"})]});s.bindItems({path:"/items",template:i});return s;},
open:function(){var t=this.getTree();if(!t){throw"The tree property has not been set";}var s=this.getSelectableColumns();if(!s){throw"The selectableColumns property has not been set";}s=s.slice();var g=this._oDialog;var r=sap.ui.vtm.getResourceBundle();var h=q.sap.debug();if(h){var i=s.filter(function(A){return A.type===sap.ui.vtm.ColumnType.Internal;}).map(function(A){return A.id;});var j=[sap.ui.vtm.InternalColumns.createTreeItemIdColumn(),sap.ui.vtm.InternalColumns.createAbsoluteMatrixColumn(),sap.ui.vtm.InternalColumns.createRelativeMatrixColumn(),sap.ui.vtm.InternalColumns.createSceneNodeIdsColumn(),sap.ui.vtm.InternalColumns.createOpacityColumn(),sap.ui.vtm.InternalColumns.createHighlightColorColumn()];j.forEach(function(A){if(i.indexOf(A.id)==-1){s.push(A);}});}var k=function(A,B){return A.getLabel().localeCompare(B.getLabel());};s.sort(k);var l=function(A,B){return JSON.stringify({type:A,descriptor:B});};var m=new Map();s.forEach(function(A){var B=l(A.getType(),A.getDescriptor());m.set(B,A);});var n=function(A){var B=A.getParameter("value");var C=A.getParameter("itemsBinding");if(B!==undefined&&B.length>0){var D=[new sap.ui.model.Filter("mProperties/label",sap.ui.model.FilterOperator.Contains,B)];C.filter(new sap.ui.model.Filter(D,false),"Application");}else{C.filter([]);}};var o=function(A){var B=t.getDataColumns().map(function(D){return l(D.getType(),D.getDescriptor());});var C=g.getItems();C.forEach(function(D){var E=D.getCells();var F=l(E[0].getText(),E[1].getText());var G=B.indexOf(F)!=-1;D.setSelected(G);});};var p,u;var v=function(t){g.attachConfirm(t,p);g.attachCancel(t,u);g.attachSearch(t,n);g.attachModelContextChange(t,o);};var w=function(){g.detachConfirm(p);g.detachCancel(u);g.detachSearch(n);g.detachModelContextChange(o);};p=function(A){w();var B=A.getParameter("selectedItems");var C=t.getDataColumns().map(function(J){return l(J.getType(),J.getDescriptor());});var D=B.map(function(J){var K=J.getCells();return l(K[0].getText(),K[1].getText());});var E=D.filter(function(J){return C.indexOf(J)===-1;});var F=C.filter(function(J){return D.indexOf(J)!==-1;});var G=F.map(function(J){return m.get(J);});var H=E.map(function(J){return m.get(J);});H.sort(k);var I=G.concat(H);t.setDataColumns(I);};u=function(A){w();};var x=t.getPanel().getTitle();var y=r.getText("SELECTCOLUMNSDIALOG_SELECT_0_COLUMNS",[x]);g.setTitle(y);v(t);var z=new sap.ui.model.json.JSONModel();z.setData({items:s});g.setModel(z);g.open();return this;}
});
return f;});
sap.ui.predefine('sap/ui/vtm/SelectionMode',[],function(){"use strict";sap.ui.vtm.SelectionMode={Single:"Single",MultiToggle:"MultiToggle",MultiToggleWithSingleSelect:"MultiToggleWithSingleSelect"};return sap.ui.vtm.SelectionMode;},true);
sap.ui.predefine('sap/ui/vtm/Text',["jquery.sap.global","sap/m/Text","sap/m/TextRenderer","./TextColor"],function(q,S,a,b){"use strict";sap.ui.vtm.Text=S.extend("sap.ui.vtm.Text",{metadata:{properties:{textColor:{type:"sap.ui.vtm.TextColor",defaultValue:b.Default,bindable:true}}},renderer:function(r,c){var t=c.getTextColor();switch(t){case b.Default:break;case b.Grey:case b.Gray:r.addClass("sapUiVtmText_TextColor_Gray");break;default:throw"Unexpected text color: '"+t+"'.";}a.render(r,c);}});return sap.ui.vtm.Text;});
sap.ui.predefine('sap/ui/vtm/TextColor',[],function(){"use strict";sap.ui.vtm.TextColor={Default:"Default",Gray:"Gray",Grey:"Grey"};return sap.ui.vtm.TextColor;},true);
sap.ui.predefine('sap/ui/vtm/Tree',["jquery.sap.global","sap/ui/core/Control","sap/ui/table/TreeTable","./SelectionMode","./InternalColumnDescriptor","./ArrayUtilities","./MatrixUtilities","./TreeItemUtilities","./Column","./Lookup","./library","./Text","./ColumnType","./InternalColumns","sap/ui/model/json/JSONModel","sap/ui/commons/TextView","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","./CheckEye"],function(q,S,c,d,f,g,h,j,k,l,m,n,o,p,r,s,t,u,v,w){"use strict";
var T=S.extend("sap.ui.vtm.Tree",{
metadata:{properties:{selectionMode:{type:"sap.ui.vtm.SelectionMode",defaultValue:"Single"}},aggregations:{_treeTable:{type:"sap.ui.table.TreeTable",multiple:false,visibility:"hidden"},headerControls:{type:"sap.ui.core.Control",multiple:true}},events:{dragStart:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"}},allowPreventDefault:true},dragOver:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"},dragOverItem:{type:"object"},dragOverTree:{type:"sap.ui.vtm.Tree"}},allowPreventDefault:true},drop:{parameters:{dragItem:{type:"object"},dragTree:{type:"sap.ui.vtm.Tree"},dropItem:{type:"object"},dropTree:{type:"sap.ui.vtm.Tree"}}},selectionChanged:{parameters:{addedItems:{type:"object[]"},removedItems:{type:"object[]"},userInteraction:{type:"boolean"}}},visibilityHeaderIconClicked:{parameters:{visibility:{type:"boolean"},control:{type:"sap.ui.core.Control"}}},visibilityIconClicked:{parameters:{item:{type:"object"},visibility:{type:"boolean"},control:{type:"sap.ui.core.Control"}}},expandedChanged:{parameters:{item:{type:"object"},expanded:{type:"boolean"},userInteraction:{type:"boolean"}}},fixedColumnsChanged:{},dataColumnsChanged:{},beforeModelUpdated:{},modelUpdated:{},messageStatusIconClicked:{parameters:{items:{type:"object"},control:{type:"sap.ui.core.Control"}}},messageStatusHeaderIconClicked:{control:{type:"sap.ui.core.Control"}},hierarchyChanged:{}}},
constructor:function(i,x){S.apply(this,arguments);this._rb=sap.ui.vtm.getResourceBundle();this._treeCollections=new sap.ui.vtm.TreeCollections();this._selectedItems=[];var y=new sap.ui.table.TreeTable({enableColumnReordering:true,selectionMode:sap.ui.table.SelectionMode.Single,showNoData:false,visibleRowCountMode:sap.ui.table.VisibleRowCountMode.Auto,minAutoRowCount:4,selectionBehavior:sap.ui.table.SelectionBehavior.RowOnly});this.setAggregation("_treeTable",y);y.allowTextSelection(false);var z=sap.ui.vtm.InternalColumns.createTreeColumn();var A=sap.ui.vtm.InternalColumns.createVisibilityColumn();var B=sap.ui.vtm.InternalColumns.createMessageStatusColumn();this._fixedColumns=[z,A,B];this._setColumns(this._fixedColumns);this.setRootItems([]);this.updateCollections(false);this._updateModel();y.setCollapseRecursive(false);y.attachToggleOpenState(this._handleToggleOpenState.bind(this));y.attachCellClick(function(e){if(this.getSelectionMode()==sap.ui.vtm.SelectionMode.MultiToggleWithSingleSelect){var a=e.getParameter("rowIndex");var b=this._getItemByRowIndex(a);if(b){this._selectedItems=[b];y.setSelectedIndex(a);}else{this._selectedItems=[];y.clearSelection();}}}.bind(this));var C=function(a,e){if(a.getVisible&&!a.getVisible()||a.getEnabled&&!a.getEnabled()){return false;}if(a.ontap){a.ontap(e);}else if(a.userToggle){a.userToggle(e);}else if(a.onclick){a.onclick(e);}return true;};var D=function(e){var a=sap.ui.table.TableUtils.getFocusedItemInfo(y);var b=this.getSelectionMode()===sap.ui.vtm.SelectionMode.MultiToggle;var E=b?a.cellInRow-1:a.cellInRow;var F=y.getColumns();var G=F[E];if(!G){return;}var H=G.data("definition");var I=H.getType();var J=H.getDescriptor();var K=a.row===0;if(K){if(I===sap.ui.vtm.ColumnType.Internal&&J===sap.ui.vtm.InternalColumnDescriptor.Visibility){var L=G.getLabel();C(L,e);}}else if(I===sap.ui.vtm.ColumnType.Internal){var M=y.getRows()[a.row-1].getCells()[E];switch(J){case sap.ui.vtm.InternalColumnDescriptor.Tree:sap.ui.table.TableUtils.toggleRowSelection(y,e.target);e.preventDefault();e.stopImmediatePropagation();break;case sap.ui.vtm.InternalColumnDescriptor.Visibility:case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:C(M,e);e.preventDefault();e.stopImmediatePropagation();break;default:break;}}}.bind(this);y.attachBrowserEvent("keyup",function(e){if(e.which===q.sap.KeyCodes.SPACE){D(e);}});y.attachRowSelectionChange(function(e){var E=e.getParameter("userInteraction");var F=e.getParameter("rowIndices");var G=y.getSelectedIndices();var H=[];var I=[];F.forEach(function(a){if(G.indexOf(a)!=-1){H.push(a);}else{I.push(a);}});var J=this._getTreeItemsFromRowIndices(H);var K=this._getTreeItemsFromRowIndices(I);if(E){var L=K.map(function(a){return a.id;});var M=function(a,b){return a.id==b.id;};var N=function(a){return L.indexOf(a.id)==-1;};this._selectedItems=g.union([this._selectedItems.filter(N),J],M);}sap.ui.vtm.measure(this,"fireSelectionChanged",function(){this.fireSelectionChanged({addedItems:J,removedItems:K,userInteraction:E});}.bind(this));if(E){this.fireEvent("vtmInternalSetTreeSelectionComplete");}}.bind(this));},
renderer:function(R,C){R.write("<div");R.writeControlData(C);R.addClass("sapUiVtmTree");R.writeStyles();R.writeClasses();R.write(">");var a=C.getHeaderControls();a.forEach(function(e){if(e){R.renderControl(e);}});var b=C._getTreeTable();R.renderControl(b);R.write("</div>");},
_raiseExpandedChanged:function(e){sap.ui.vtm.measure(this,"fireExpandedChanged",function(){this.fireExpandedChanged(e);}.bind(this));},
_handleToggleOpenState:function(e){var a=e.getParameter("rowContext");var b=e.getParameter("expanded");var i=a.getPath();var x=this.getItemByBindingContextPath(i);this._raiseExpandedChanged({item:x,expanded:b,userInteraction:true});},
_getAncestor:function(a){var b=this.getParent();while(b&&b.getMetadata().getName()!==a){b=b.getParent();}return b;},
getPanel:function(){if(!this._panel){this._panel=this._getAncestor("sap.ui.vtm.Panel");}return this._panel;},
setExpanded:function(a,e){var b=this._getTreeTable();var i=function(){var x=this._getRowIndexForTreeItem(b,a);if(x!==-1){var y;if(e){if(!b.isExpanded(x)){y=true;b.expand(x);}}else if(b.isExpanded(x)){y=true;b.collapse(x);}if(y){this._raiseExpandedChanged({item:a,expanded:e,userInteraction:false});}}}.bind(this);if(e){this._expandToTreeItem(a,false,i);}else{i();}return this;},
getExpanded:function(a){var b=this._getTreeTable();var e=this._getRowIndexForTreeItem(b,a);if(e!==-1){return b.isExpanded(e);}return false;},
getFixedColumns:function(){var a=[];var b=this._getTreeTable();var e=b.getColumns();for(var i=0;i<this._fixedColumns.length;i++){var x=e[i];var y=x.data("definition");y.setWidth(x.getWidth());y.setHAlign(x.getHAlign());a.push(y);}return a;},
setFixedColumns:function(a){if(!a){throw"fixedColumns not specified";}this._fixedColumns=a;var b=this.getDataColumns();var e=this._fixedColumns.concat(b);this._setColumns(e);this.fireFixedColumnsChanged();return this;},
getDataColumns:function(){var a=[];var b=this._getTreeTable();var e=b.getColumns();for(var i=this._fixedColumns.length;i<e.length;i++){var x=e[i];var y=x.data("definition");y.setWidth(x.getWidth());y.setHAlign(x.getHAlign());a.push(y);}return a;},
setDataColumns:function(a){if(!a){throw"dataColumns not specified";}var b=this._fixedColumns.concat(a);this._setColumns(b);this.fireDataColumnsChanged();return this;},
_setColumns:function(a){var b=this._getTreeTable();b.removeAllColumns();a.forEach(function(e){var i=this._createColumn(e);b.addColumn(i);}.bind(this));b.setFixedColumnCount(this._fixedColumns.length);},
_getTreeItemsFromRowIndices:function(a){return a.map(function(b){return this._getItemByRowIndex(b);}.bind(this)).filter(function(b){return!!b;});},
_getTreeTable:function(){return this.getAggregation("_treeTable");},
getRootItems:function(){return this._rootItems;},
setRootItems:function(a){this._rootItems=a;return this;},
isEmpty:function(){return this._rootItems.length===0;},
getSelectedItems:function(){return this._selectedItems;},
_expandToTreeItem:function(a,b){return new Promise(function(e,i){var x=this._getTreeTable();var y=function(E,F,G){var H;if((F<E)||(F>=(E+G))){H=F-(G/2);}else{H=E;}H=H>0?Math.floor(H):0;return H;};var z=this.getAncestorItems(a.id,false);var A=function(E,z,F){if(F.getParameter("reason")==="expand"){E(z);}};var B=null;var C=0;var D=function(z){var E=function(){x.getBinding("rows").detachChange(B);var F=this._getRowIndexForTreeItem(x,a,C);if(F===-1){throw"Tree item with id '"+a.id+"' not found in treeTable";}if(b){var G=x.getVisibleRowCount(),H=x.getFirstVisibleRow(),I=y(H,F,G);if(I!==H){x.setFirstVisibleRow(I);}}e();}.bind(this);setTimeout(function(){if(z.length){while(z.length){var F=z[0];var G=this._getRowIndexForTreeItem(x,F,C);if(G===-1){return;}else{z.shift();C=G+1;if(!x.isExpanded(G)){x.expand(G);this._raiseExpandedChanged({item:F,expanded:true,userInteraction:false});return;}else if(!z.length){E();}}}}else{E();}}.bind(this),0);}.bind(this);B=A.bind(this,D,z);x.getBinding("rows").attachChange(B);D(z);}.bind(this));},
_getRowIndexForTreeItem:function(a,b,e){var i=-1;sap.ui.vtm.measure(this,"_getRowIndexForTreeItem",function(){if(!e){e=0;}var x=function(C,B){B.forEach(function(E){C=C[E];});return C;};var y=this.getAllItems();for(var z=e;z<y.length;z++){var A=a.getContextByIndex(z);if(A){var B=A.getPath().split("/");B.shift();var C=A.getModel().getData();var D=x(C,B);if(D===b){i=z;break;}}}}.bind(this));return i;},
expandAncestors:function(a){sap.ui.vtm.measure(this,"expandAncestors",function(){this._expandToTreeItem(a,false);}.bind(this));return this;},
expandAll:function(){sap.ui.vtm.measure(this,"expandAll",function(){this._getTreeTable().expandToLevel(1000*1000*1000);}.bind(this));return this;},
collapseAll:function(){sap.ui.vtm.measure(this,"collapseAll",function(){this._getTreeTable().collapseAll();}.bind(this));return this;},
expandToLevel:function(L){sap.ui.vtm.measure(this,"expandToLevel",function(){this._getTreeTable().expandToLevel(L);}.bind(this));return this;},
scrollIntoView:function(a){sap.ui.vtm.measure(this,"scrollIntoView",function(){this._expandToTreeItem(a,true);}.bind(this));return this;},
setSelectedItems:function(a,b){a=sap.ui.vtm.ArrayUtilities.wrap(a);if(b!==true&&b!==false){b=true;}if(this.getSelectionMode()==sap.ui.vtm.SelectionMode.Single&&a.length>1){a=a.slice(0,1);}if(a.length){var e=[];this.traverseTree(function(i){e.push(i.id);});a=a.filter(function(i){return e.indexOf(i.id)!=-1;});}this._selectedItems=a;if(!a.length){this._getTreeTable().clearSelection();this.fireEvent("vtmInternalSetTreeSelectionComplete");return this;}var x=function(A){var B=this._getTreeTable();for(var i=0;;i++){var C=this._getItemByRowIndex(i);if(!C){break;}var D=A.indexOf(C)!==-1;if(D!=B.isIndexSelected(i)){if(D){B.addSelectionInterval(i,i);}else{B.removeSelectionInterval(i,i);}}}this.fireEvent("vtmInternalSetTreeSelectionComplete");}.bind(this);var y=function(){x(a);};var z=null;a.forEach(function(i){if(!z){z=this._expandToTreeItem(i,b);}else{z=z.then(function(){return this._expandToTreeItem(i,b);}.bind(this));}}.bind(this));z.then(y);return this;},
validateTree:function(){sap.ui.vtm.measure(this,"validateTree",function(){var e=sap.ui.vtm.TreeItemUtilities.validateTree(this.getRootItems());if(e.length!==0){e.forEach(function(a){var b="Tree error in "+this.getId()+": "+a;q.sap.log.error(b,null,"sap.ui.vtm.Tree");});throw"There were errors in the "+this.getId()+" tree. See the console trace for details";}}.bind(this));return this;},
updateModel:function(a){sap.ui.vtm.measure(this,"updateModel",function(){sap.ui.vtm.measure(this,"fireBeforeModelUpdated",function(){this.fireBeforeModelUpdated();}.bind(this));this._updateModel(a);this.setSelectedItems(this._selectedItems,false);sap.ui.vtm.measure(this,"fireModelUpdated",function(){this.fireModelUpdated();}.bind(this));}.bind(this));return this;},
_updateModel:function(a){var b=this._getTreeTable();var e=b.getModel();if(!e||a){e=new sap.ui.model.json.JSONModel();e.setSizeLimit(1000000);b.bindRows({path:"/rootItems",key:"id",parameters:{arrayNames:["includedChildren"],numberOfExpandedLevels:1}});e.setData({rootItems:this.getRootItems()});b.setModel(e);}else{e.setData({rootItems:this.getRootItems()});this._updateBindings(true);}},
_updateBindings:function(){this._getTreeTable().getModel().updateBindings(true);},
updateCollections:function(a){sap.ui.vtm.measure(this,"updateCollections",function(){if(this._treeCollections.updateCollections(this.getRootItems(),a)){sap.ui.vtm.measure(this,"fireHierarchyChanged",function(){this.fireHierarchyChanged();}.bind(this));}}.bind(this));return this;},
updateTreeItemsBySceneNodeId:function(){sap.ui.vtm.measure(this,"updateTreeItemsBySceneNodeId",function(){this._treeCollections.updateTreeItemsBySceneNodeId(this.getRootItems());}.bind(this));return this;},
getItemByBindingContextPath:function(b){return this._getTreeTable().getModel().getProperty(b)||undefined;},
getItem:function(a){return this._treeCollections.getItem(a);},
isIncludedItem:function(a){return this._treeCollections.isIncludedItem(a);},
isExcludedItem:function(a){return this._treeCollections.isExcludedItem(a);},
getItemsBySceneNodeId:function(a,b){return this._treeCollections.getItemsBySceneNodeId(a,b);},
getParentItem:function(a){return this._treeCollections.getParentItem(a);},
getDescendantItems:function(a,b){return this._treeCollections.getDescendantItems(a,b);},
getAncestorItems:function(a){return this._treeCollections.getAncestorItems(a);},
getAllItems:function(a){return this._treeCollections.getAllItems(a);},
_modifyDisplayState:function(a,b,e,i,x){a=sap.ui.vtm.ArrayUtilities.wrap(a);e=e==null?true:e;x=x==null?true:x;i=i==null?true:i;var y=function(z){if(!i||sap.ui.vtm.TreeItemUtilities.hasVisibility(z)){b(z);}return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;};a.forEach(function(z){if(e){sap.ui.vtm.TreeItemUtilities.traverseBranch(z,y);}else{y(z);}});if(x){this.updateModel();this.getPanel().getViewport().refresh();}},
_getTreeItemData:function(a,b){if(Array.isArray(a)){return a.map(b);}else{return b(a);}},
setVisibility:function(a,b,e,i,x){var y=function(z){if(b==undefined){delete z.visibility;}else{z.visibility=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},
getVisibility:function(a){return this._getTreeItemData(a,function(b){return b.visibility;});},
setOpacity:function(a,b,e,i,x){var y=function(z){if(b==undefined){delete z.opacity;}else{z.opacity=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},
getOpacity:function(a){return this._getTreeItemData(a,function(b){return b.opacity;});},
setHighlightColor:function(a,b,e,i,x){var y=function(z){if(b==null){delete z.highlightColor;}else{z.highlightColor=b;}};this._modifyDisplayState(a,y,e,i,x);return this;},
getHighlightColor:function(a){return this._getTreeItemData(a,function(b){return b.highlightColor;});},
_getItemByRowIndex:function(i){var a=this._getTreeTable();var b=a.getContextByIndex(i);var e=b?b.sPath:"";return this.getItemByBindingContextPath(e);},
onAfterRendering:function(){var a=this._getTreeTable();if(a.setFixedColumnCount()!=this._fixedColumns.length){a.setFixedColumnCount(this._fixedColumns.length);}this._addDragHandlers();this._addMutationObserver();},
setSelectionMode:function(a){if(a===this.getSelectionMode()){return this;}var b=this._getTreeTable();this._selectedItems=[];b.clearSelection();var e;var i;switch(a){case sap.ui.vtm.SelectionMode.Single:e=sap.ui.table.SelectionMode.Single;i=sap.ui.table.SelectionBehavior.RowOnly;break;case sap.ui.vtm.SelectionMode.MultiToggle:e=sap.ui.table.SelectionMode.MultiToggle;i=sap.ui.table.SelectionBehavior.Row;break;case sap.ui.vtm.SelectionMode.MultiToggleWithSingleSelect:e=sap.ui.table.SelectionMode.MultiToggle;i=sap.ui.table.SelectionBehavior.RowSelector;break;default:throw"Unknown selection mode: '"+a+"'";}b.setSelectionBehavior(i);b.setSelectionMode(e);this.setProperty("selectionMode",a);return this;},
_addMutationObserver:function(){var i=false;var a=new MutationObserver(function(e){if(i){return;}i=true;var x=false;e.forEach(function(y){if(x){return;}if(y.type==="childList"){this._addDragHandlers();x=true;}}.bind(this));i=false;}.bind(this));var b={subtree:true,childList:true};q("#"+this.getId()).each(function(e,x){a.observe(x,b);});},
_getRowIndexForTableRow:function(a){var b=q(a).attr("data-sap-ui-rowindex");var R=this._getTreeTable().getFirstVisibleRow()+parseInt(b,10);return R;},
_addDragHandlers:function(){var i=this.getId();var a="#"+i+" tr.sapUiTableTr";if(q(a).attr("draggable")){return;}var b=this.getPanel().getVtm();var e=function(A){A.dataTransfer.setData("text","");var B=A.currentTarget;var C=this._getRowIndexForTableRow(B);var D=this._getItemByRowIndex(C);if(!D){A.preventDefault();return;}var E=this.getSelectedItems();if(E&&E.length&&E.indexOf(D)<0){A.preventDefault();return;}b._dragStartParameters={dragItem:D,dragTree:this};var F;sap.ui.vtm.measure(this,"fireDragStart",function(){F=this.fireDragStart(b._dragStartParameters);}.bind(this));if(!F){A.preventDefault();}}.bind(this);var x=function(A){var B=b._dragStartParameters;if(!B){return;}var C=A.currentTarget;var D=this._getRowIndexForTableRow(C);var E={dragItem:B.dragItem,dragTree:B.dragTree,dragOverItem:this._getItemByRowIndex(D),dragOverTree:this};var F;sap.ui.vtm.measure(this,"fireDragOver",function(){F=this.fireDragOver(E);}.bind(this));if(!F){A.preventDefault();}}.bind(this);var y=function(A){var B=b._dragStartParameters;if(!B){return;}var C=A.currentTarget;var D=this._getRowIndexForTableRow(C);var E={dragItem:B.dragItem,dragTree:B.dragTree,dropItem:this._getItemByRowIndex(D),dropTree:this};b._dragStartParameters=null;sap.ui.vtm.measure(this,"fireDrop",function(){this.fireDrop(E);}.bind(this));}.bind(this);var z=function(A){A.addEventListener("dragstart",e,false);A.addEventListener("dragover",x,false);A.addEventListener("drop",y,false);};q(a).each(function(){var A=q(this);A.attr("draggable","true");A.attr("droppable","true");z(this);});},
_createColumn:function(a){var b=a.getTemplate()||this._createColumnTemplate(a);var e=a.getLabel();var i=a.getLabelControl();this._attachColumnHeaderEvents(a);var x={label:i?i:e,tooltip:a.getTooltip()||e,hAlign:a.getHAlign()||sap.ui.core.HorizontalAlign.Left,width:a.getWidth()||"auto",resizable:a.getResizable(),template:b};var y=new sap.ui.table.Column(x);y.setTemplate(b);y.data("definition",a);return y;},
traverseBranch:function(a,b){var e=this.getAncestorItems(a);sap.ui.vtm.TreeItemUtilities.traverseBranch(a,b,e);return this;},
traverseTree:function(a){this.getRootItems().forEach(function(b){this.traverseBranch(b,a,[]);}.bind(this));return this;},
removeRoot:function(a){return sap.ui.vtm.TreeItemUtilities.removeRoot(this._rootItems,a);},
addRoot:function(a){sap.ui.vtm.TreeItemUtilities.addRoot(this._rootItems,a);return this;},
_attachColumnHeaderEvents:function(a){var b=a.getLabelControl();if(!b){return;}var e=a.getType();if(!e){throw"Column type not specified";}switch(e){case sap.ui.vtm.ColumnType.Internal:{var i=a.getDescriptor();if(!i){throw"Column descriptor not specified";}switch(i){case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:b.attachPress(function(){this.fireMessageStatusHeaderIconClicked({control:b});}.bind(this));break;case sap.ui.vtm.InternalColumnDescriptor.Visibility:b.attachPress(function(){this.fireVisibilityHeaderIconClicked({visibility:b.getVisibility(),control:b});}.bind(this));break;default:break;}switch(i){case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:case sap.ui.vtm.InternalColumnDescriptor.Visibility:b.addEventDelegate({onfocusin:function(x){b.getDomRef().blur();}},b);break;default:break;}}break;default:break;}return b;},
_createColumnTemplate:function(a){var C=sap.ui.vtm.ColumnTemplates;var b=a.getType();if(!b){throw"Column type not specified";}switch(b){case sap.ui.vtm.ColumnType.Internal:{var e=a.getDescriptor();switch(e){case sap.ui.vtm.InternalColumnDescriptor.TreeItemId:return C.createTreeItemIdColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.Tree:return C.createTreeColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.MessageStatus:var i=C.createMessageStatusColumnTemplate();i.attachPress(function(E){var z=E.getSource();var A=z.getBindingContext();var P=A.getPath();var B=this.getItemByBindingContextPath(P);this.fireMessageStatusIconClicked({item:B,control:z});}.bind(this));i.addEventDelegate({onfocusin:function(z){var A=sap.ui.getCore();var B=A.getCurrentFocusedControlId();var D=A.byId(B);if(D){var E=D.getDomRef();if(E){E.blur();}}}},i);return i;case sap.ui.vtm.InternalColumnDescriptor.AbsoluteMatrix:return C.createAbsoluteMatrixColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.RelativeMatrix:return C.createRelativeMatrixColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.SceneNodeIds:return C.createSceneNodeIdsColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.Visibility:var x=C.createVisibilityColumnTemplate();var y=function(z){var P=z.getBindingContext().getPath();var A=this.getItemByBindingContextPath(P);if(A){sap.ui.vtm.measure(this,"fireVisibilityIconClicked",function(){this.fireVisibilityIconClicked({item:A,visibility:A.visibility,control:z});}.bind(this));}}.bind(this);x.attachPress(function(z){var A=z.getSource();y(A);});x.addEventDelegate({onfocusin:function(z){var A=sap.ui.getCore();var B=A.getCurrentFocusedControlId();var D=A.byId(B);if(D){var E=D.getDomRef();if(E){E.blur();}}}},x);return x;case sap.ui.vtm.InternalColumnDescriptor.Opacity:return C.createOpacityColumnTemplate();case sap.ui.vtm.InternalColumnDescriptor.HighlightColor:return C.createHighlightColorColumnTemplate();default:throw"Unknown internal column type: "+e;}break;}case sap.ui.vtm.ColumnType.Metadata:return C.createMetadataColumnTemplate(a);case sap.ui.vtm.ColumnType.Identifier:return C.createIdentifierColumnTemplate(a);case sap.ui.vtm.ColumnType.AppData:return C.createAppDataColumnTemplate(a);default:throw"Invalid column type: "+b;}}
});
return T;});
sap.ui.predefine('sap/ui/vtm/TreeCollections',["jquery.sap.global","sap/ui/core/Element","./ArrayUtilities"],function(q,S,a){"use strict";
var T=S.extend("sap.ui.vtm.TreeCollections",{
getTreeItem:function(t){if(!t){return null;}if(typeof t==="string"){var b=this._treeItemsById.get(t);if(!b){throw t+" was not found in tree with tree id "+this.getId();}return b;}return t;},
getTreeItemId:function(t){if(!t){return null;}return typeof t==="string"?t:t.id;},
updateCollections:function(r,c){c=c!==false;var o=this._parentIdsById;var b=this._includedTreeItems;var d=this._excludedTreeItems;this._treeItemsById=new Map();this._parentIdsById=new Map();this._treeItemsBySceneNodeId=new sap.ui.vtm.Lookup();this._includedTreeItems=[];this._excludedTreeItems=[];var p=this._parentIdsById;var h=false;var u=function(i,e,f){var g=i.id;if(!g){throw"id is not set for tree item with name "+i.name;}if(this._treeItemsById.has(g)){throw g+" is not unique in the tree";}var j;if(f){this._excludedTreeItems.push(i);if(c&&d&&!h){j=this._excludedTreeItems.length-1;if(j>=d.length||d[j]!=i){h=true;}}}else{this._includedTreeItems.push(i);if(c&&b&&!h){j=this._includedTreeItems.length-1;if(j>=b.length||b[j]!=i){h=true;}}}this._treeItemsById.set(g,i);if(e){if(!e.id){throw"id is not set for tree item with name "+e.name;}p.set(g,e.id);if(c&&o&&!h){if(o.get(g)!==e.id){h=true;}}}else if(c&&o&&!h){if(o.get(g)){h=true;}}if(i.includedChildren){i.includedChildren.forEach(function(k){u(k,i,f);});}if(i.excludedChildren){i.excludedChildren.forEach(function(k){u(k,i,true);});}if(i.sceneNodeIds){sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(i).forEach(function(s){this._treeItemsBySceneNodeId.addValue(s,i);}.bind(this));}}.bind(this);r.forEach(function(e){u(e,null);});if(c&&!h){if(b&&b.length!==this._includedTreeItems.length){h=true;}if(d&&d.length!==this._excludedTreeItems.length){h=true;}}return c&&h;},
updateTreeItemsBySceneNodeId:function(r){this._treeItemsBySceneNodeId=new sap.ui.vtm.Lookup();sap.ui.vtm.TreeItemUtilities.traverseTree(r,function(t){sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(t).forEach(function(s){this._treeItemsBySceneNodeId.addValue(s,t);}.bind(this));return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;}.bind(this));},
getItem:function(t){return this._treeItemsById.get(t);},
isIncludedItem:function(t){t=this.getTreeItem(t);return this._includedTreeItems.indexOf(t)!==-1;},
isExcludedItem:function(t){t=this.getTreeItem(t);return this._excludedTreeItems.indexOf(t)!==-1;},
getItemsBySceneNodeId:function(s,t){s=sap.ui.vtm.ArrayUtilities.wrap(s);if(!s.length){return[];}t=t||sap.ui.vtm.TreeItemType.Included;var b=function(d,t){switch(t){case sap.ui.vtm.TreeItemType.IncludedOrExcluded:return true;case sap.ui.vtm.TreeItemType.Included:return this.isIncludedItem(d);case sap.ui.vtm.TreeItemType.Excluded:return this.isExcludedItem(d);default:throw"Unexpected sap.ui.vtm.TreeItemType value "+t;}}.bind(this);var c=[];s.forEach(function(d){var e=this._treeItemsBySceneNodeId.getValues(d);e.forEach(function(f){if(c.indexOf(f)===-1&&b(f,t)){c.push(f);}});}.bind(this));return c;},
getParentItem:function(t){var b=this.getTreeItemId(t);var p=this._parentIdsById.get(b);if(!p){return undefined;}return this._treeItemsById.get(p);},
getDescendantItems:function(t,b){t=this.getTreeItem(t);b=b||sap.ui.vtm.TreeItemType.Included;var d=[];switch(b){case sap.ui.vtm.TreeItemType.IncludedOrExcluded:sap.ui.vtm.TreeItemUtilities.traverseBranch(t,function(c){if(c!==t){d.push(c);}return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;});break;case sap.ui.vtm.TreeItemType.Included:sap.ui.vtm.TreeItemUtilities.traverseBranch(t,function(c){if(c===t){return this.isIncludedItem(c)?sap.ui.vtm.ChildCollectionType.Included:sap.ui.vtm.ChildCollectionType.None;}else{d.push(c);return sap.ui.vtm.ChildCollectionType.Included;}}.bind(this));break;case sap.ui.vtm.TreeItemType.Excluded:sap.ui.vtm.TreeItemUtilities.traverseBranch(t,function(c){if(c===t){return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;}else{if(this.isExcludedItem(c)){d.push(c);}return sap.ui.vtm.ChildCollectionType.IncludedAndExcluded;}}.bind(this));break;default:throw"Unexpected sap.ui.vtm.TreeItemType value "+b;}return d;},
getAncestorItems:function(t){t=this.getTreeItem(t);var b=[];var c=this.getParentItem(t.id);while(c){b.push(c);c=this.getParentItem(c.id);}return b.reverse();},
getAllItems:function(t){t=t||sap.ui.vtm.TreeItemType.Included;switch(t){case sap.ui.vtm.TreeItemType.IncludedOrExcluded:return this._includedTreeItems.concat(this._excludedTreeItems);case sap.ui.vtm.TreeItemType.Included:return this._includedTreeItems.slice();case sap.ui.vtm.TreeItemType.Excluded:return this._excludedTreeItems.slice();default:throw"Unexpected sap.ui.vtm.TreeItemType value "+t;}}
});
return T;});
sap.ui.predefine('sap/ui/vtm/TreeItemType',[],function(){"use strict";sap.ui.vtm.TreeItemType={Included:"Included",Excluded:"Excluded",IncludedOrExcluded:"IncludedOrExcluded"};return sap.ui.vtm.TreeItemType;},true);
sap.ui.predefine('sap/ui/vtm/TreeItemUtilities',['jquery.sap.global',"sap/ui/core/Message","./ArrayUtilities"],function(q,S,a){"use strict";var T={};
T.mapBranch=function(t,b){var c=b(t);if(t.includedChildren){c.includedChildren=t.includedChildren.map(function(d){return T.mapBranch(d,b);});}if(t.excludedChildren){c.excludedChildren=t.excludedChildren.map(function(d){return T.mapBranch(d,b);});}return c;};
T.mapTree=function(r,b){var c=[];r.forEach(function(d){c.push(T.mapBranch(d,b));});return c;};
var v=function(i){return Array.isArray(i)?sap.ui.vtm.ArrayUtilities.shallowClone(i):i;};var m=function(b){if(b===null||b===undefined){return b;}var c={};var k=Object.keys(b);k.forEach(function(d){c[d]=v(b[d]);});return c;};
T.cloneMetadata=function(t){return m(t.metadata);};
T.cloneIdentifiers=function(t){return m(t.identifiers);};
T.cloneAppData=function(t){return m(t.appData);};
T.hasVisibility=function(t){return t.visibility===true||t.visibility===false;};
T.getAppDataDescriptors=function(t){if(!t.appData){return[];}return Object.keys(t.appData);};
T.getAppDataValues=function(t,d){if(!t.appData){return[];}return a.wrap(t.appData[d]);};
T.setAppDataValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.appData){delete t.appData[d];}}else{if(!t.appData){t.appData={};}t.appData[d]=b;}};
T.getMetadataDescriptors=function(t){if(!t.metadata){return[];}return Object.keys(t.metadata);};
T.getMetadataValues=function(t,d){if(!t.metadata){return[];}return a.wrap(t.metadata[d]);};
T.setMetadataValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.metadata){delete t.metadata[d];}}else{if(!t.metadata){t.metadata={};}t.metadata[d]=b;}};
T.getIdentifierDescriptors=function(t){if(!t||!t.identifiers){return[];}return Object.keys(t.identifiers);};
T.getIdentifierValues=function(t,d){if(!t.identifiers){return[];}return a.wrap(t.identifiers[d]);};
T.setIdentifierValues=function(t,d,b){var c=a.unwrap(b);if(c===undefined){if(t.identifiers){delete t.identifiers[d];}}else{if(!t.identifiers){t.identifiers={};}t.identifiers[d]=b;}};
T.getSceneNodeIds=function(t){if(!t.sceneNodeIds){return[];}return a.wrap(t.sceneNodeIds);};
T.setSceneNodeIds=function(t,s){s=a.unwrap(s);if(s===undefined){if(t.sceneNodeIds){delete t.sceneNodeIds;}}else{t.sceneNodeIds=s;}};
T.getIncludedChildren=function(t){if(!t.includedChildren){return[];}return t.includedChildren;};
T.getExcludedChildren=function(t){if(!t.excludedChildren){return[];}return t.excludedChildren;};
T.getChildren=function(t,c){switch(c){case sap.ui.vtm.ChildCollectionType.None:return[];case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.getIncludedChildren(t);case sap.ui.vtm.ChildCollectionType.Excluded:return T.getExcludedChildren(t);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.getIncludedChildren(t).concat(T.getExcludedChildren(t));default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+c;}};
T.setIncludedChildren=function(t,i){i=sap.ui.vtm.ArrayUtilities.wrap(i);if(i.length==0){delete t.includedChildren;}else{t.includedChildren=i;}};
T.setExcludedChildren=function(t,e){e=sap.ui.vtm.ArrayUtilities.wrap(e);if(e.length==0){delete t.excludedChildren;}else{t.excludedChildren=e;}};
T.setChildren=function(t,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:T.setIncludedChildren(t,c);break;case sap.ui.vtm.ChildCollectionType.Excluded:T.setExcludedChildren(t,c);break;case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:throw"sap.ui.vtm.ChildCollectionType.IncludedAndExcluded cannot be used in sap.ui.vtm.TreeItemUtilities.setChildren";default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};
T.hasIncludedChildren=function(t){return t.includedChildren&&t.includedChildren.length;};
T.hasExcludedChildren=function(t){return t.excludedChildren&&t.excludedChildren.length;};
T.hasChildren=function(t,c){switch(c){case sap.ui.vtm.ChildCollectionType.None:return false;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.hasIncludedChildren(t);case sap.ui.vtm.ChildCollectionType.Excluded:return T.hasExcludedChildren(t);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.hasIncludedChildren(t)||T.hasExcludedChildren(t);default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+c;}};
T.calculateAbsoluteMatrix=function(r,p){if(!r){return p||sap.ui.vtm.MatrixUtilities.createIdentity();}return p?sap.ui.vtm.MatrixUtilities.multiply(r,p):r;};
T.calculateRelativeMatrix=function(b,p){if(!b){throw"An absolute matrix value is needed to calculate a relative matrix value";}return p?sap.ui.vtm.MatrixUtilities.multiply(b,sap.ui.vtm.MatrixUtilities.invert(p)):b;};
T.addIncludedChild=function(i,c){if(i.includedChildren){i.includedChildren.push(c);}else{i.includedChildren=[c];}};
T.addExcludedChild=function(i,c){if(i.excludedChildren){i.excludedChildren.push(c);}else{i.excludedChildren=[c];}};
T.addChild=function(i,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:T.addIncludedChild(i,c);break;case sap.ui.vtm.ChildCollectionType.Excluded:T.addExcludedChild(i,c);break;case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:throw"sap.ui.vtm.ChildCollectionType.IncludedAndExcluded cannot be used in sap.ui.vtm.TreeItemUtilities.addChild";default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};
T.removeIncludedChild=function(i,c){var b=(typeof c==='string')?c:c.id;if(i.includedChildren){var d=sap.ui.vtm.ArrayUtilities.findIndex(i.includedChildren,function(f){return f.id===b;});if(d!==undefined){var e=i.includedChildren[d];i.includedChildren.splice(d,1);if(i.includedChildren.length==0){delete i.includedChildren;}return e;}}return undefined;};
T.removeExcludedChild=function(i,c){var b=(typeof c==='string')?c:c.id;if(i.excludedChildren){var d=sap.ui.vtm.ArrayUtilities.findIndex(i.excludedChildren,function(f){return f.id===b;});if(d!==undefined){var e=i.excludedChildren[d];i.excludedChildren.splice(d,1);if(i.excludedChildren.length==0){delete i.excludedChildren;}return e;}}return undefined;};
T.removeChild=function(i,c,b){switch(b){case sap.ui.vtm.ChildCollectionType.None:break;case null:case undefined:case sap.ui.vtm.ChildCollectionType.Included:return T.removeIncludedChild(i,c);case sap.ui.vtm.ChildCollectionType.Excluded:return T.removeExcludedChild(i,c);case sap.ui.vtm.ChildCollectionType.IncludedAndExcluded:return T.removeIncludedChild(i,c)||T.removeExcludedChild(i,c);default:throw"Unknown sap.ui.vtm.ChildCollectionType value: "+b;}};
T.includeAllChildren=function(t,r){t=sap.ui.vtm.ArrayUtilities.wrap(t);t.forEach(function(i){var b=T.getChildren(i,sap.ui.vtm.ChildCollectionType.IncludedAndExcluded);T.setIncludedChildren(i,b);T.setExcludedChildren(i,[]);if(r){b.forEach(function(c){T.includeAllChildren(c,true);});}});};
T.excludeAllChildren=function(t,r){t=sap.ui.vtm.ArrayUtilities.wrap(t);t.forEach(function(i){var b=T.getChildren(i,sap.ui.vtm.ChildCollectionType.IncludedAndExcluded);T.setChildren(i,[]);T.setExcludedChildren(i,b);if(r){b.forEach(function(c){T.excludeAllChildren(c,true);});}});};
T.removeRoot=function(r,b){var c=(typeof b==='string')?b:b.id;var i=sap.ui.vtm.ArrayUtilities.findIndex(r,function(e){return e.id===c;});if(i!==undefined){var d=r[i];r.splice(i,1);return d;}return undefined;};
T.addRoot=function(r,b){r.push(b);};
T.validateTreeItem=function(t){var i=function(o){return o===null||o===undefined;};var e=[];if(t){if(i(t.id)){e.push("id is not specified");}if(!i(t.absoluteMatrix)){if(!sap.ui.vtm.MatrixUtilities.isValid(t.absoluteMatrix,true)){e.push("absoluteMatrix is not valid");}}if(!i(t.relativeMatrix)){if(!sap.ui.vtm.MatrixUtilities.isValid(t.relativeMatrix,true)){e.push("relativeMatrix is not valid");}}}return e;};
T.validateTree=function(r){var e=[];var p=function(t,b){var c=T.validateTreeItem(t);if(c&&c.length!==0){var d=b+": "+c.join(", ");e.push(d);}var i;var f=t.includedChildren;if(f){for(i=0;i<f.length;i++){p(f[i],b+"/includedChildren/"+i);}}var g=t.excludedChildren;if(g){for(i=0;i<g.length;i++){p(g[i],b+"/excludedChildren/"+i);}}};for(var j=0;j<r.length;j++){p(r[j],""+j);}return e;};
T.traverseBranch=function(t,c,b){if(!t){return;}var d=c(t,b)||sap.ui.vtm.ChildCollectionType.Included;if(b&&d!==sap.ui.vtm.ChildCollectionType.None){b.push(t);}if(d===sap.ui.vtm.ChildCollectionType.IncludedAndExcluded||d===sap.ui.vtm.ChildCollectionType.Included){var i=t.includedChildren;if(i){i.forEach(function(f){T.traverseBranch(f,c,b);});}}if(d===sap.ui.vtm.ChildCollectionType.IncludedAndExcluded||d===sap.ui.vtm.ChildCollectionType.Excluded){var e=t.excludedChildren;if(e){e.forEach(function(f){T.traverseBranch(f,c,b);});}}if(b&&d!==sap.ui.vtm.ChildCollectionType.None){b.pop();}};
T.traverseTree=function(r,c){if(r){r.forEach(function(b){T.traverseBranch(b,c,[]);});}};
T.getMessages=function(t){if(!t.messages||!t.messages.length){return[];}var p=JSON.parse(t.messages);var c=p.map(function(b){return new sap.ui.core.Message(b);});return c;};
T.setMessages=function(t,b){if(!b||!b.length){delete t.messages;return;}var c=b.map(function(d){var e={};var l=d.getLevel();if(l){e.level=l;}var f=d.getText();if(f){e.text=f;}var i=d.getIcon();if(i){e.icon=i;}var g=d.getTimestamp();if(g){e.timestamp=g;}var r=d.getReadOnly();if(r){e.readOnly=r;}return e;});t.messages=JSON.stringify(c);};
return T;},true);
sap.ui.predefine('sap/ui/vtm/Viewable',["jquery.sap.global","sap/ui/core/Element","sap/ui/vk/ContentResource"],function(q,S,a){"use strict";
var V=S.extend("sap.ui.vtm.Viewable",{
metadata:{properties:{source:{type:"any"},name:{type:"string"},rootNodeIds:{type:"string[]"},relativeMatrix:{type:"sap.ui.vtm.Matrix"}}},
init:function(){this._vkContentResource=new sap.ui.vk.ContentResource({sourceId:this.getId(),sourceType:"vds"});this.setRelativeMatrix(sap.ui.vtm.MatrixUtilities.createIdentity());},
getSourceId:function(){return this.getId();},
setSource:function(s){this.setProperty("source",s);this._vkContentResource.setSource(s);return this;},
setName:function(n){this.setProperty("name",n);this._vkContentResource.setName(n);return this;},
setRelativeMatrix:function(m){this.setProperty("relativeMatrix",m);this._vkContentResource.setLocalMatrix(sap.ui.vtm.MatrixUtilities.toVkMatrix(m));},
_getContentResource:function(){return this._vkContentResource;},
getSourceString:function(){var s=this.getSource();return typeof s==="string"?s:s.name;}
});
return V;});
sap.ui.predefine('sap/ui/vtm/ViewableLoadInfo',["jquery.sap.global","sap/ui/core/Element"],function(q,S){"use strict";
var V=S.extend("sap.ui.vtm.ViewableLoadInfo",{metadata:{properties:{viewable:{type:"object"},status:{type:"sap.ui.vtm.ViewableLoadStatus"},errorCode:{type:"string"},errorText:{type:"string"}}}});
return V;});
sap.ui.predefine('sap/ui/vtm/ViewableLoadStatus',[],function(){"use strict";sap.ui.vtm.ViewableLoadStatus={Downloading:"Downloading",Downloaded:"Downloaded",DownloadFailed:"DownloadFailed",Loading:"Loading",Loaded:"Loaded",LoadFailed:"LoadFailed"};return sap.ui.vtm.ViewableLoadStatus;},true);
sap.ui.predefine('sap/ui/vtm/Viewport',["jquery.sap.global","sap/ui/core/Control","sap/ui/vk/dvl/Viewport","sap/m/OverflowToolbar","./ViewportHandler","sap/ui/vk/FlexibleControl","sap/ui/vk/FlexibleControlLayoutData"],function(q,S,a,b,c,d,e){"use strict";
var V=S.extend("sap.ui.vtm.Viewport",{
metadata:{properties:{backgroundGradientTopColor:{type:"sap.ui.core.CSSColor",defaultValue:"black"},backgroundGradientBottomColor:{type:"sap.ui.core.CSSColor",defaultValue:"white"},overrideDisplayGroups:{type:"object[]",defaultValue:[]},contextDisplayGroups:{type:"object[]",defaultValue:[]}},aggregations:{_container:{type:"sap.m.VBox",multiple:false,visibility:"hidden"}},associations:{headerControls:{type:"sap.ui.core.Control",multiple:true}},events:{selectionChanged:{parameters:{selectedIds:{type:"string[]"},unselectedIds:{type:"string[]"},userInteraction:{type:"boolean"}}},nodeClicked:{sceneNode:{type:"sap.ui.vtm.SceneNode"}},visibilityChanged:{parameters:{visibleIds:{type:"string[]"},hiddenIds:{type:"string[]"},userInteraction:{type:"boolean"}}},viewChanged:{parameters:{cameraInfo:{type:"object"}}},refreshRequested:{},hover:{parameters:{x:{type:"float"},y:{type:"float"},nodeId:{type:"string"}}},beginGesture:{},endGesture:{}}},
_getVkViewport:function(){return this.vkViewport;},
_getContainer:function(){return this.getAggregation("_container");},
init:function(){this._programmaticSelectionChangeInProgress=false;this._programmaticVisibilityChangeInProgress=false;},
_initialize:function(){var v=this.getPanel().getVtm();if(v){var s=v.getScene();this._setScene(s);var f=this._getVkViewport();var l=f._loco;if(f._viewportHandler){l.removeHandler(f._viewportHandler);}if(f._smart2DHandler){l.removeHandler(f._smart2DHandler);}var g=new c(this);l.addHandler(g);s.attachEvent("sceneCreated",function(){this._onSceneCreated();}.bind(this));}},
renderer:function(r,C){r.write("<div");r.writeControlData(C);r.addStyle("height","inherit");r.addStyle("overflow","hidden");r.writeStyles();r.writeClasses();r.write(">");var f=C._getContainer();r.renderControl(f);r.write("</div>");},
onBeforeRendering:function(){if(!this._initialized){this._initialized=true;this._initialize();}},
getInitialized:function(){return this._initialized;},
refresh:function(){sap.ui.vtm.measure(this,"fireRefreshRequested",function(){this.fireRefreshRequested();}.bind(this));return this;},
_raiseHover:function(x,y,n){this.fireHover({x:x,y:y,nodeId:n});},
_raiseBeginGesture:function(){this.fireBeginGesture();},
_raiseEndGesture:function(){this.fireEndGesture();},
setBackgroundGradientTopColor:function(C){this.setProperty("backgroundGradientTopColor",C);this._getVkViewport().setBackgroundColorTop(C);return this;},
setBackgroundGradientBottomColor:function(C){this.setProperty("backgroundGradientBottomColor",C);this._getVkViewport().setBackgroundColorBottom(C);return this;},
_getAncestor:function(f){var g=this.getParent();while(g&&g.getMetadata().getName()!==f){g=g.getParent();}return g;},
getPanel:function(){if(!this._panel){this._panel=this._getAncestor("sap.ui.vtm.Panel");}return this._panel;},
getScene:function(){return this._scene;},
_onSceneCreated:function(f){var s=this.getScene();var v=s._vkScene;if(!this._vkScene&&v){var g=this._getVkViewport();this._vkScene=v;g.setScene(v);this._vkDefaultNodeHierarchy=v.getDefaultNodeHierarchy();if(this._vkDefaultNodeHierarchy&&this._vkGraphicsCore){this._vkViewStateManager=this._vkGraphicsCore.createViewStateManager(this._vkDefaultNodeHierarchy,true,true);if(this._vkViewStateManager){g.setViewStateManager(this._vkViewStateManager);this._vkViewStateManager.attachSelectionChanged(function(f){var h=f.getParameter("selected");var u=f.getParameter("unselected");sap.ui.vtm.measure(this,"fireSelectionChanged",function(){this.fireSelectionChanged({selectedIds:h,unselectedIds:u,userInteraction:!this._programmaticSelectionChangeInProgress});}.bind(this));}.bind(this));this._vkViewStateManager.attachVisibilityChanged(function(f){var h=f.getParameter("visible");var i=f.getParameter("hidden");sap.ui.vtm.measure(this,"fireVisibilityChanged",function(){this.fireVisibilityChanged({visibleIds:h,hiddenIds:i,userInteraction:!this._programmaticVisibilityChangeInProgress});}.bind(this));}.bind(this));var o=function(){sap.ui.vtm.measure(this,"fireViewChanged",function(){this.fireViewChanged({cameraInfo:this.getCameraInfo()});}.bind(this));}.bind(this);g.attachZoom(o);g.attachPan(o);g.attachRotate(o);g.attachNodeClicked(function(f){var n=f.getParameters().nodeId;sap.ui.vtm.measure(this,"fireNodeClicked",function(){var h=s._getSceneNode(n);try{this.fireNodeClicked({sceneNode:h});}finally{h.destroy();}}.bind(this));}.bind(this));g.attachFrameRenderingFinished(function(f){this.fireEvent("frameRenderingFinished",f);}.bind(this));}}}},
getHeaderControls:function(){var i=this.getAssociation("headerControls");var f=[];if(i){i.forEach(function(g){var h=sap.ui.getCore().byId(g);if(h){f.push(h);}});}return f;},
_setScene:function(s){if(!s||this._scene){return this;}var v=new sap.ui.vk.dvl.Viewport(this.getId()+"_sapUiVkViewport",{height:"100%"});this.vkViewport=v;this._scene=s;if(s){this._vkGraphicsCore=this._scene._vkGraphicsCore;if(this._vkGraphicsCore){v.setGraphicsCore(this._vkGraphicsCore);v.setBackgroundColorTop(this.getBackgroundGradientTopColor());v.setBackgroundColorBottom(this.getBackgroundGradientBottomColor());}}var h=this.getHeaderControls();h.forEach(function(g){if(g){g.setLayoutData(new sap.m.FlexItemData({growFactor:0,shrinkFactor:0}));}});v.setLayoutData(new sap.m.FlexItemData({growFactor:1,shrinkFactor:1,minHeight:"10px"}));var f=new sap.m.VBox({fitContainer:true,renderType:sap.ui.Device.browser.msie?sap.m.FlexRendertype.Div:sap.m.FlexRendertype.Bare,items:[h,v]});this.setAggregation("_container",f);return this;},
zoomToSelected:function(f){sap.ui.vtm.measure(this,"zoomToSelected",function(){if(f===null||f===undefined){f=0.2;}this._getVkViewport().zoomTo(sap.ui.vk.ZoomTo.Selected,null,f,0);}.bind(this));return this;},
zoomToVisible:function(f){sap.ui.vtm.measure(this,"zoomToVisible",function(){if(f===null||f===undefined){f=0.2;}this._getVkViewport().zoomTo(sap.ui.vk.ZoomTo.Visible,null,f,0);}.bind(this));return this;},
zoomToFit:function(f){var g=false;if(this._vkViewStateManager){this._vkViewStateManager.enumerateSelection(function(){g=true;});}if(g){this.zoomToSelected(f);}else{this.zoomToVisible(f);}return this;},
zoomToAll:function(f){sap.ui.vtm.measure(this,"zoomToAll",function(){if(f===null||f===undefined){f=0.2;}this._getVkViewport().zoomTo(sap.ui.vk.ZoomTo.All,null,f,0);}.bind(this));return this;},
getVisibility:function(s){var v;sap.ui.vtm.measure(this,"getVisibility",function(){if(this._vkViewStateManager){v=this._vkViewStateManager.getVisibilityState(s);}}.bind(this));return v;},
setVisibility:function(s,v,r){if(q.sap.debug()){var p={viewport:this.getId(),visibility:v,recursive:r,sceneNodeIds:s};q.sap.log.warning("setVisibility "+JSON.stringify(p));}sap.ui.vtm.measure(this,"setVisibility",function(){if(Array.isArray(s)&&!s.length){return this;}if(this._vkViewStateManager){try{this._programmaticVisibilityChangeInProgress=true;this._vkViewStateManager.setVisibilityState(s,v,r);}finally{this._programmaticVisibilityChangeInProgress=false;}}}.bind(this));return this;},
getOpacity:function(s){var o;sap.ui.vtm.measure(this,"getOpacity",function(){if(this._vkViewStateManager){o=this._vkViewStateManager.getOpacity(s);this._scene.traverseNodes(s,function(f,i){if(Array.isArray(s)){if(o[i]==null){o[i]=f._vkNodeProxy.getOpacity();}}else if(o==null){o=f._vkNodeProxy.getOpacity();}});}}.bind(this));return o;},
setOpacity:function(s,o,r){if(q.sap.debug()){var p={viewport:this.getId(),opacity:o,recursive:r,sceneNodeIds:s};q.sap.log.warning("setOpacity "+JSON.stringify(p));}sap.ui.vtm.measure(this,"setOpacity",function(){if(Array.isArray(s)&&!s.length){return this;}if(this._vkViewStateManager){this._vkViewStateManager.setOpacity(s,o,r);}}.bind(this));return this;},
getHighlightColor:function(s){var h;sap.ui.vtm.measure(this,"getHighlightColor",function(){if(this._vkViewStateManager){h=this._vkViewStateManager.getTintColor(s);this._scene.traverseNodes(s,function(f,i){if(Array.isArray(s)){if(h[i]==null){h[i]=f._vkNodeProxy.getTintColor();}}else if(h==null){h=f._vkNodeProxy.getTintColor();}});}}.bind(this));return h;},
setHighlightColor:function(s,f,r){if(q.sap.debug()){var p={viewport:this.getId(),color:f,recursive:r,sceneNodeIds:s};q.sap.log.warning("setHighlightColor "+JSON.stringify(p));}sap.ui.vtm.measure(this,"setHighlightColor",function(){if(Array.isArray(s)&&!s.length){return this;}if(this._vkViewStateManager){this._vkViewStateManager.setTintColor(s,f,r);}}.bind(this));return this;},
getSelected:function(s){var f;sap.ui.vtm.measure(this,"getSelected",function(){if(this._vkViewStateManager){f=this._vkViewStateManager.getSelectionState(s);}}.bind(this));return f;},
setSelected:function(s,f,r){if(q.sap.debug()){var p={viewport:this.getId(),selected:f,recursive:r,sceneNodeIds:s};q.sap.log.warning("setSelected "+JSON.stringify(p));}sap.ui.vtm.measure(this,"setSelected",function(){if(Array.isArray(s)&&!s.length){return this;}if(this._vkViewStateManager){try{this._programmaticSelectionChangeInProgress=true;this._vkViewStateManager.setSelectionState(s,f,r);}finally{this._programmaticSelectionChangeInProgress=false;}}}.bind(this));return this;},
getSelectedIds:function(){var i=[];sap.ui.vtm.measure(this,"getSelectedIds",function(){if(this._vkViewStateManager){this._vkViewStateManager.enumerateSelection(function(f){i.push(f);});}}.bind(this));return i;},
setPredefinedView:function(v){var z;switch(v){case sap.ui.vtm.PredefinedView.Top:z=sap.ui.vk.ZoomTo.ViewTop;break;case sap.ui.vtm.PredefinedView.Bottom:z=sap.ui.vk.ZoomTo.ViewBottom;break;case sap.ui.vtm.PredefinedView.Front:z=sap.ui.vk.ZoomTo.ViewFront;break;case sap.ui.vtm.PredefinedView.Back:z=sap.ui.vk.ZoomTo.ViewBack;break;case sap.ui.vtm.PredefinedView.Left:z=sap.ui.vk.ZoomTo.ViewLeft;break;case sap.ui.vtm.PredefinedView.Right:z=sap.ui.vk.ZoomTo.ViewRight;break;default:throw"Unexpected view value: '"+v+"'.";}this._getVkViewport().zoomTo(z,null,0.2,0);return this;},
getCameraInfo:function(){var v=this._getVkViewport().getViewInfo({camera:{useTransitionCamera:true},animation:false});return v.camera;},
setCameraInfo:function(f,g){var v={camera:f,flyToDuration:g||0};this._getVkViewport().setViewInfo(v);return this;},
addOverrideDisplayGroup:function(o){var f=this.getOverrideDisplayGroups();f.push(o);this.setOverrideDisplayGroups(f);return this;},
addContextDisplayGroup:function(f){var g=this.getContextDisplayGroups();g.push(f);this.setContextDisplayGroups(g);return this;}
});
return V;});
sap.ui.predefine('sap/ui/vtm/ViewportHandler',["jquery.sap.global","sap/ui/vk/ViewportHandler"],function(q,S){"use strict";
var V=sap.ui.vk.ViewportHandler.extend("sap.ui.vtm.ViewportHandler",{
constructor:function(v){sap.ui.vk.ViewportHandler.prototype.constructor.call(this,v._getVkViewport());this._vtmViewport=v;},
hover:function(e){if(e.n==1&&this._inside(e)&&this._rect){var x=e.x-this._rect.x,y=e.y-this._rect.y;var n=this._viewport.hitTest(x,y);this._vtmViewport._raiseHover(x,y,n);}},
beginGesture:function(e){this._vtmViewport._raiseBeginGesture();S.prototype.beginGesture.call(this,e);},
endGesture:function(e){this._vtmViewport._raiseEndGesture();S.prototype.endGesture.call(this,e);}
});
return V;});
sap.ui.predefine('sap/ui/vtm/Vtm',["jquery.sap.global","sap/ui/core/Element","./Panel","./Scene","./ArrayUtilities","./Viewable","sap/m/Toolbar"],function(q,S,a,b,c,d,e){"use strict";
var V=S.extend("sap.ui.vtm.Vtm",{
metadata:{properties:{addDefaultExtensions:{type:"boolean"}},events:{panelAdded:{parameters:{panel:{type:"sap.ui.vtm.Panel"}}},activePanelChanged:{},initialized:{}},aggregations:{extensions:{type:"sap.ui.vtm.Extension",multiple:true}},defaultAggregation:"extensions"},
constructor:function(i,s){S.apply(this,arguments);this._panels=[];this._scene=new sap.ui.vtm.Scene(this.getId()+"_scene");this.addDependent(this._scene);this._dragStartParameters={};var f=this.getExtensions().map(function(g){return g.getInitializedPromise();});Promise.all(f).then(function(){sap.ui.vtm.measure(this,"fireInitialized",function(){this.fireInitialized();}.bind(this));}.bind(this));},
setAddDefaultExtensions:function(A){if(A){[new sap.ui.vtm.extensions.LoadProgressExtension(),new sap.ui.vtm.extensions.MessageStatusCalculationExtension(),new sap.ui.vtm.extensions.MessageStatusIconClickExtension(),new sap.ui.vtm.extensions.ViewportSelectionLinkingExtension(),new sap.ui.vtm.extensions.VisibilityIconClickExtension(),new sap.ui.vtm.extensions.DisplayStateCalculationExtension(),new sap.ui.vtm.extensions.SelectionLinkingExtension({enabled:false}),new sap.ui.vtm.extensions.ViewLinkingExtension({enabled:false}),new sap.ui.vtm.extensions.InitialViewExtension(),new sap.ui.vtm.extensions.SceneNodeHoverHighlightExtension(),new sap.ui.vtm.extensions.SceneNodeHoverTooltipExtension()].forEach(function(f){this.addExtension(f);}.bind(this));}},
getPanels:function(){return this._panels;},
getPanel:function(p){return sap.ui.vtm.ArrayUtilities.find(this._panels,function(f){return f.getId()===p;});},
getScene:function(){return this._scene;},
createPanel:function(i,s){s=q.extend(s,{vtmId:this});return new sap.ui.vtm.Panel(i,s);},
_setActivePanel:function(A,s){if(this._activePanel===A){return;}this._activePanel=A;var p=this.getPanels();p.forEach(function(f){var i=f===A;f._setIsActive(i);if(s){A.focus();}});sap.ui.vtm.measure(this,"fireActivePanelChanged",function(){this.fireActivePanelChanged();}.bind(this));},
getActivePanel:function(){return this._activePanel||null;},
setActivePanel:function(A){this._setActivePanel(A,true);return this;},
_addPanel:function(p){var f=this.getPanels();f.push(p);sap.ui.vtm.measure(this,"firePanelAdded",function(){this.firePanelAdded({panel:p});}.bind(this));return this;},
getExtensionsByName:function(E){return this.getExtensions().filter(function(f){return f.getMetadata().getName()===E;});},
getExtensionByName:function(E){var f=this.getExtensionsByName(E);return f.length===1?f[0]:undefined;},
getExtensionsByInterface:function(i){return this.getExtensions().filter(function(f){return f.getMetadata().isInstanceOf(i);});},
getExtensionByInterface:function(i){var f=this.getExtensionsByInterface(i);return f.length===1?f[0]:undefined;}
});
return V;});
sap.ui.predefine('sap/ui/vtm/extensions/DisplayStateCalculationExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var D=a.extend("sap.ui.vtm.extensions.DisplayStateCalculationExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IDisplayStateCalculationExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this._handlingEvent=false;this._defaultVisibility=false;this._defaultOpacity=null;this._defaultHighlightColor=null;this.applyPanelHandler(function(p){var v=p.getViewport();v.attachRefreshRequested(function(e){if(!this.getEnabled()){return;}this._updateDisplayStates(p);}.bind(this));}.bind(this));},
_updateDisplayStates:function(p){var s=new sap.ui.vtm.Lookup(),b=new sap.ui.vtm.Lookup(),h=[],v=[];this._calculateDisplayStates(p,h,v,s,b);this._applyDisplayStates(p,h,v,s,b);},
_applyContextUpdates:function(p,d){var v=p.getViewport();var s=v.getScene();var c=v.getContextDisplayGroups();c.reverse().forEach(function(b){var e=b.getDisplayStatesBySceneNodeId();if(e){var f=Object.getOwnPropertyNames(e);f.forEach(function(g){var h=e[g];var i=h.visibility;var o=h.opacity;var j=h.highlightColor;var r=h.recursive;var k=[g];if(r===true){Array.prototype.push.apply(k,s.getDescendantIds(g));}k.forEach(function(l){var m=d.get(l);if(i!==null&&i!==undefined){m.visibility=i;}if(o!==null&&o!==undefined){m.opacity=o;}if(j!==null&&j!==undefined){m.highlightColor=j===""?this._defaultHighlightColor:j;}});});}});},
_applyTreeItemUpdates:function(p,d){var t=p.getTree();var b=t.getAllItems();b.forEach(function(c){var v=c.visibility===true;if(v){var s=sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(c);var o=c.opacity;var h=c.highlightColor;s.forEach(function(e){var f=d.get(e);f.visibility=v;f.opacity=o||this._defaultOpacity;f.highlightColor=h||this._defaultHighlightColor;}.bind(this));}}.bind(this));},
_applyOverrideUpdates:function(p,d){var v=p.getViewport();var s=v.getScene();var o=v.getOverrideDisplayGroups();o.reverse().forEach(function(b){var c=b.getDisplayStatesBySceneNodeId();if(c){var e=Object.getOwnPropertyNames(c);e.forEach(function(f){var g=c[f];var h=g.visibility;var i=g.opacity;var j=g.highlightColor;var r=g.recursive;var k=[f];if(r===true){Array.prototype.push.apply(k,s.getDescendantIds(f));}k.forEach(function(l){var m=d.get(l);if(h!==null&&h!==undefined){m.visibility=h;}if(i!==null&&i!==undefined){m.opacity=i;}if(j!==null&&j!==undefined){m.highlightColor=j===""?this._defaultHighlightColor:j;}});});}});},
_calculateDisplayStates:function(p,h,v,s,b){sap.ui.vtm.measure(this,"_calculateDisplayStates",function(){var c;var d=new Map();sap.ui.vtm.measure(this,"_calculateDisplayStates - Get all ids",function(){c=this._vtm.getScene().getCachedIds();}.bind(this));sap.ui.vtm.measure(this,"creating display states",function(){c.forEach(function(e){d.set(e,{visibility:this._defaultVisibility,opacity:this._defaultOpacity,highlightColor:this._defaultHighlightColor});}.bind(this));}.bind(this));sap.ui.vtm.measure(this,"_applyContextUpdates ("+p.getId()+")",function(){this._applyContextUpdates(p,d);}.bind(this));sap.ui.vtm.measure(this,"_applyTreeItemUpdates ("+p.getId()+")",function(){this._applyTreeItemUpdates(p,d);}.bind(this));sap.ui.vtm.measure(this,"_applyOverrideUpdates ("+p.getId()+")",function(){this._applyOverrideUpdates(p,d);}.bind(this));sap.ui.vtm.measure(this,"_calculateDisplayStates - Populating lookups",function(){d.forEach(function(e,f){if(e.visibility){v.push(f);s.addValue(e.opacity,f);b.addValue(e.highlightColor,f);}else{h.push(f);}});});}.bind(this));},
_applyDisplayStates:function(p,h,v,s,b){sap.ui.vtm.measure(this,"_applyDisplayStates",function(){var c=p.getViewport();c.setVisibility(h,false,false);if(v.length){c.setVisibility(v,true,false);s.forEach(function(d,o){c.setOpacity(d,o,false);});b.forEach(function(d,e){c.setHighlightColor(d,e,false);});}});}
});
return D;});
sap.ui.predefine('sap/ui/vtm/extensions/InitialViewExtension',["jquery.sap.global","../Extension"],function(q,S){"use strict";
var I=S.extend("sap.ui.vtm.extensions.InitialViewExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IInitialViewExtension"],properties:{predefinedView:{type:"sap.ui.vtm.PredefinedView"}}},
constructor:function(i,s){S.apply(this,arguments);},
initialize:function(v){var i=false;v.getScene().attachLoadCompleted(function(e){var p=v.getPanels();var l=e.getParameter("succeeded");if(!this.getEnabled()||!l||i||!p.length){return;}i=true;var a=v.getExtensionByInterface("sap.ui.vtm.interfaces.IViewLinkingExtension");var b=a&&a.getEnabled();var c=this.getPredefinedView();var s=function(d){var f=d.getViewport();if(c){f.setPredefinedView(c);}else{f.zoomToAll(0);}};if(b){var d=v.getActivePanel()||p[0];s(d);}else{p.forEach(s);}}.bind(this));}
});
return I;});
sap.ui.predefine('sap/ui/vtm/extensions/LoadProgressExtension',["jquery.sap.global","../Extension"],function(q,S){"use strict";
var L=S.extend("sap.ui.vtm.extensions.LoadProgressExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IDownloadProgressExtension","sap.ui.vtm.interfaces.ILoadProgressExtension"]},
constructor:function(i,s){S.apply(this,arguments);},
initialize:function(v){this._scene=v.getScene();this._rb=sap.ui.vtm.getResourceBundle();this._oDialog=new sap.ui.vtm.ProgressDialog({progressBarVisible:false});this._downloadInfoByViewable=new Map();this._loadInfoByViewable=new Map();this._boundDownloadStartedHandler=this._downloadStartedHandler.bind(this);this._boundDownloadProgressHandler=this._downloadProgressHandler.bind(this);this._boundDownloadCompletedHandler=this._downloadCompletedHandler.bind(this);this._boundLoadStartedHandler=this._loadStartedHandler.bind(this);this._boundLoadProgressHandler=this._loadProgressHandler.bind(this);this._boundLoadCompletedHandler=this._loadCompletedHandler.bind(this);this._scene.attachDownloadStarted(this._boundDownloadStartedHandler);},
_setDownloadPercentComplete:function(p){if(this._oDialog.getPercentComplete()!==p){this._oDialog.setPercentComplete(p);this._oDialog.setProgressText(this._rb.getText("PROGRESS_DOWNLOADING_0",[p]));sap.ui.getCore().applyChanges();}},
_downloadProgressHandler:function(e){if(!this.getEnabled()){return;}var v=e.getParameter("viewable");var d=e.getParameter("downloadedBytes");var t=e.getParameter("totalBytes");this._downloadInfoByViewable.set(v,{downloadedBytes:d,totalBytes:t});var b=0,a=0;this._downloadInfoByViewable.forEach(function(c){b+=c.downloadedBytes;a+=c.totalBytes;});var p=a==0?0.0:Math.floor(b/a*100);this._setDownloadPercentComplete(p);},
_downloadStartedHandler:function(e){if(!this.getEnabled()){return;}this._openDialog();},
_setLoadPercentComplete:function(p){if(this._oDialog.getPercentComplete()!==p){this._oDialog.setPercentComplete(p);this._oDialog.setProgressText(this._rb.getText("PROGRESS_LOADING_0",[p]));sap.ui.getCore().applyChanges();}},
_loadProgressHandler:function(e){if(!this.getEnabled()){return;}var v=e.getParameter("viewable");var p=e.getParameter("percentage");this._loadInfoByViewable.set(v,{percentComplete:p});var a=0;var l=0;this._loadInfoByViewable.forEach(function(b){a+=b.percentComplete;l++;});var o=l==0?0:Math.floor(a/l);this._setLoadPercentComplete(o);},
_downloadCompletedHandler:function(e){this._downloadInfoByViewable.clear();var v=e.getParameter("viewableLoadInfos");var a=v.every(function(b){return b.getStatus()===sap.ui.vtm.ViewableLoadStatus.DownloadFailed;});if(a){this._closeDialog();}},
_loadStartedHandler:function(e){this._oDialog.setProgressText(this._rb.getText("PROGRESS_LOADING"));sap.ui.getCore().applyChanges();},
_loadCompletedHandler:function(e){this._loadInfoByViewable.clear();this._closeDialog();},
_openDialog:function(){if(!this._oDialog.isOpen()){this._scene.attachDownloadProgress(this._boundDownloadProgressHandler);this._scene.attachDownloadCompleted(this._boundDownloadCompletedHandler);this._scene.attachLoadStarted(this._boundLoadStartedHandler);this._scene.attachLoadProgress(this._boundLoadProgressHandler);this._scene.attachLoadCompleted(this._boundLoadCompletedHandler);this._oDialog.open();this._setDownloadPercentComplete(0);}},
_closeDialog:function(){this._scene.detachDownloadProgress(this._boundDownloadProgressHandler);this._scene.detachDownloadCompleted(this._boundDownloadCompletedHandler);this._scene.detachLoadStarted(this._boundLoadStartedHandler);this._scene.detachLoadProgress(this._boundLoadProgressHandler);this._scene.detachLoadCompleted(this._boundLoadCompletedHandler);this._oDialog.close();}
});
return L;});
sap.ui.predefine('sap/ui/vtm/extensions/MessageStatusCalculationExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";var M={Error:"Error",ErrorOnDescendant:"ErrorOnDescendant",Warning:"Warning",WarningOnDescendant:"WarningOnDescendant",Information:"Information",None:"None"};
var b=a.extend("sap.ui.vtm.extensions.MessageStatusCalculationExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IMessageStatusCalculationExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this._rb=sap.ui.vtm.getResourceBundle();this.applyPanelHandler(function(p){var t=p.getTree();t.attachBeforeModelUpdated(function(e){this._handleBeforeModelUpdated(p);}.bind(this));this._handleBeforeModelUpdated(p);}.bind(this));},
_getMessageStatusPriority:function(m){switch(m){case M.Error:return 1;case M.ErrorOnDescendant:return 2;case M.Warning:return 3;case M.WarningOnDescendant:return 4;case M.Information:return 5;case M.None:return 6;default:throw"Unknown message status: '"+m+"'";}},
_makeCascadedMessageStatus:function(m){switch(m){case M.Error:case M.ErrorOnDescendant:return M.ErrorOnDescendant;case M.Warning:case M.WarningOnDescendant:return M.WarningOnDescendant;case M.Information:case M.None:return M.None;default:throw"Unknown message status: '"+m+"'";}},
_messageStatusCompareFunction:function(m,c){return this._getMessageStatusPriority(m)-this._getMessageStatusPriority(c);},
_calculateHighestPriorityMessageStatus:function(t){var m=t.messages;if(m){var c=sap.ui.vtm.TreeItemUtilities.getMessages(t);c.sort(sap.ui.core.Message.compareByType).reverse();return c[0].getLevel();}else{return sap.ui.core.MessageType.None;}},
_calculateHighestPriorityChildMessageStatus:function(t){var c=sap.ui.vtm.TreeItemUtilities.getIncludedChildren(t);if(c.length){var d=c.filter(function(e){return e.messageStatus;});if(d.length){d.sort(function(e,f){return this._getMessageStatusPriority(e.messageStatus)-this._getMessageStatusPriority(f.messageStatus);}.bind(this));return d[0].messageStatus;}}return sap.ui.core.MessageType.None;},
_calculateMessageStatus:function(t){var h=this._calculateHighestPriorityMessageStatus(t);var c=this._calculateHighestPriorityChildMessageStatus(t);if(this._messageStatusCompareFunction(h,c)>0){if(c===sap.ui.core.MessageType.None){if(t.messageStatus){delete t.messageStatus;}}else{t.messageStatus=this._makeCascadedMessageStatus(c);}}else if(h===sap.ui.core.MessageType.None){if(t.messageStatus){delete t.messageStatus;}}else{t.messageStatus=h;}if(c===sap.ui.core.MessageType.None){if(t.childMessageStatus){delete t.childMessageStatus;}else{t.childMessageStatus=c;}}},
_getIconSource:function(m){switch(m){case M.Error:return"sap-icon://error";case M.ErrorOnDescendant:return"sap-icon://message-error";case M.Warning:return"sap-icon://alert";case M.WarningOnDescendant:return"sap-icon://message-warning";case M.Information:return"sap-icon://message-information";case M.None:return null;default:throw"Unknown message type: '"+m+"'";}},
_getStatusTooltip:function(m){switch(m){case M.Error:return this._rb.getText("MESSAGESTATUS_ERROR");case M.ErrorOnDescendant:return this._rb.getText("MESSAGESTATUS_ERRORONDESCENDANT");case M.Warning:return this._rb.getText("MESSAGESTATUS_WARNING");case M.WarningOnDescendant:return this._rb.getText("MESSAGESTATUS_WARNINGONDESCENDANT");case M.Information:return this._rb.getText("MESSAGESTATUS_INFORMATION");case M.None:return null;default:throw"Unknown message type: '"+m+"'";}},
_getMessagesToShowTootip:function(t){if(t.messages){return this._rb.getText("MESSAGESTATUS_CLICKTOSHOWMESSAGES");}else{return this._rb.getText("MESSAGESTATUS_NOMESSAGESONTHISITEM");}},
_getIconColor:function(m){switch(m){case M.Error:case M.ErrorOnDescendant:return sap.ui.core.IconColor.Negative;case M.Warning:case M.WarningOnDescendant:return sap.ui.core.IconColor.Critical;case M.Information:return sap.ui.core.IconColor.Neutral;case M.None:return null;default:throw"Unknown message type: '"+m+"'";}},
_calculateMessageStatusForTree:function(t){var c=this._calculateMessageStatus.bind(this);var d=function(e,f){var g=sap.ui.vtm.TreeItemUtilities.getChildren(e);g.forEach(function(h){d(h,f);});if(f){f(e);}};t.getRootItems().forEach(function(e){d(e,c);});var r=false;sap.ui.vtm.TreeItemUtilities.traverseTree(t.getRootItems(),function(e){if(e.messageStatus){var m=this._getIconSource(e.messageStatus);if(e.messageStatusIconUrl!==m){e.messageStatusIconUrl=m;r=true;}var f=this._getIconColor(e.messageStatus);if(e.messageStatusIconColor!==f){e.messageStatusIconColor=f;r=true;}var g=this._getMessagesToShowTootip(e);var s=this._getStatusTooltip(e.messageStatus);var h=s?s+"\n"+g:g;if(e.messageStatusIconTooltip!=h){e.messageStatusIconTooltip=h;r=true;}}else if(e.messageStatusIconUrl||e.messageStatusIconColor||e.messageStatusIconTooltip){delete e.messageStatusIconUrl;delete e.messageStatusIconColor;delete e.messageStatusIconTooltip;r=true;}delete e.messageStatus;delete e.childMessageStatus;}.bind(this));if(r){t._updateBindings();}},
_handleBeforeModelUpdated:function(p){if(!this.getEnabled()){return;}var t=p.getTree();this._calculateMessageStatusForTree(t);}
});
return b;});
sap.ui.predefine('sap/ui/vtm/extensions/MessageStatusIconClickExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var M=a.extend("sap.ui.vtm.extensions.MessageStatusIconClickExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IMessageStatusIconClickExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this.applyPanelHandler(function(p){var t=p.getTree();var m;t.attachMessageStatusIconClicked(function(e){if(!this.getEnabled()){return;}if(m&&m.isOpen()){m.close();}var i=e.getParameter("item");var s=e.getParameter("control");var b=sap.ui.vtm.TreeItemUtilities.getMessages(i);if(b.length){b.sort(sap.ui.core.Message.compareByType).reverse();m=new sap.ui.vtm.MessagesPopover({messages:b,maxHeight:"300px"});m.openBy(s);}}.bind(this));}.bind(this));}
});
return M;});
sap.ui.predefine('sap/ui/vtm/extensions/SceneNodeHoverHighlightExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var b=a.extend("sap.ui.vtm.extensions.SceneNodeHoverHighlightExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.ISceneNodeHoverHighlightExtension"],properties:{highlightColor:{type:"sap.ui.core.CSSColor",defaultValue:"rgba(0, 0, 255, 0.7)"}}},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this._panelPanelInitialized=new Map();this.applyPanelHandler(function(p){var v=p.getViewport();var s=this._vtm.getScene();s.attachLoadCompleted(function(e){if(!e.getParameter("succeeded")){return;}if(this._panelPanelInitialized.get(p)){return;}this._panelPanelInitialized.set(p,true);var h=new sap.ui.vtm.DisplayGroup();var d=h.getDisplayStatesBySceneNodeId();var c=sap.ve.dvl.DVLID_INVALID;v.addOverrideDisplayGroup(h);var r=function(){if(c){if(d[c]){delete d[c];}}};var f=function(n,g){if(n!==sap.ve.dvl.DVLID_INVALID){d[n]={highlightColor:g};}};this.attachEnabledChanged(function(e){if(this.getEnabled()&&c){f(c,this.getHighlightColor());}else{r();}v.refresh();}.bind(this));v.addEventDelegate({onmouseout:function(){r();c=sap.ve.dvl.DVLID_INVALID;v.refresh();}},v);v.attachHover(function(e){var n=e.getParameter("nodeId");if(!this.getEnabled()){c=n;return;}if(n!==c){r();c=n;f(n,this.getHighlightColor());v.refresh();}}.bind(this));v.attachBeginGesture(function(e){r();c=sap.ve.dvl.DVLID_INVALID;v.refresh();});}.bind(this));}.bind(this));}
});
return b;});
sap.ui.predefine('sap/ui/vtm/extensions/SceneNodeHoverTooltipExtension',["jquery.sap.global","sap/ui/core/Control","../Extension","../ViewportHandler"],function(q,S,a,b){"use strict";
var c=a.extend("sap.ui.vtm.extensions.SceneNodeHoverTooltipExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.ISceneNodeHoverTooltipExtension"],properties:{tooltipCallback:{type:"any",group:"Behavior",defaultValue:null}}},
constructor:function(i,s){a.apply(this,arguments);},
createTooltip:function(i,t){var d=document.createElement("div");d.className="sapUiVtmSceneNode-Tooltip";d.innerText=t;return d;},
initialize:function(){this._panelPanelInitialized=new Map();this.applyPanelHandler(function(p){var v=p.getViewport();var s=this._vtm.getScene();s.attachLoadCompleted(function(e){if(!e.getParameter("succeeded")){return;}if(this._panelPanelInitialized.get(p)){return;}this._panelPanelInitialized.set(p,true);var d=sap.ve.dvl.DVLID_INVALID;var f=v._getVkViewport();var x,y;var t;var g=function(k){return{text:k.getName()};};var h=new sap.ui.vtm.SceneNode({scene:s});var i=function(){if(t){f.getDomRef().removeChild(t);t=undefined;}};var j=function(n,x,y){if(n!==sap.ve.dvl.DVLID_INVALID){h.setSceneNodeId(n);var k=this.getTooltipCallback()||g;var l=k(h);if(l){t=this.createTooltip(n,l.text);t.style.left="calc("+Math.floor(x)+"px + 1em)";t.style.top="calc("+Math.floor(y)+"px + 1.5em)";f.getDomRef().appendChild(t);}}}.bind(this);this.attachEnabledChanged(function(e){if(this.getEnabled()&&d){j(d,x,y);}else{i();}f.renderFrame();}.bind(this));v.addEventDelegate({onmouseout:function(){i();d=sap.ve.dvl.DVLID_INVALID;x=y=null;v.refresh();}},v);v.attachHover(function(e){var n=e.getParameter("nodeId");x=e.getParameter("x");y=e.getParameter("y");if(!this.getEnabled()){d=n;return;}if(n!==d){i();d=n;j(n,x,y);}f.renderFrame();}.bind(this));v.attachBeginGesture(function(e){i();d=sap.ve.dvl.DVLID_INVALID;x=y=null;v.refresh();});}.bind(this));}.bind(this));}
});
return c;});
sap.ui.predefine('sap/ui/vtm/extensions/SelectionLinkingExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var b=a.extend("sap.ui.vtm.extensions.SelectionLinkingExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.ISelectionLinkingExtension"],properties:{findMatchingTreeItems:{type:"any",group:"Behavior",defaultValue:null}}},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this._handlingEvent=new Map();this.applyPanelHandler(function(p){var t=p.getTree();t.attachSelectionChanged(function(e){if(!this.getEnabled()){return;}if(this._handlingEvent.get(p)){return;}this._onSelectionChanged(t.getPanel());}.bind(this));t.attachEvent("vtmInternalSetTreeSelectionComplete",function(e){this._handlingEvent.set(p,false);}.bind(this));t.attachModelUpdated(function(e){if(!this.getEnabled()){return;}var c=this._getPrimaryPanel();if(c){this._onSelectionChanged(c);}}.bind(this));}.bind(this));this.attachEnabledChanged(function(){if(this.getEnabled()){var p=this._getPrimaryPanel();if(p){this._onSelectionChanged(p);}}});},
_getPrimaryPanel:function(){var p=this._vtm.getPanels();if(!p||!p.length){return null;}return this._vtm.getActivePanel()||p[0];},
_onSelectionChanged:function(s){var c=s.getTree();var d=c.getSelectedItems();var p=this._vtm.getPanels();var f=this.getFindMatchingTreeItems();if(!f){return;}p.forEach(function(t){var e=t.getTree();var g=[];if(t!==s){d.forEach(function(h){var m=f(h,c,e);Array.prototype.push.apply(g,m);});this._handlingEvent.set(t,true);e.setSelectedItems(g);}}.bind(this));return;}
});
return b;});
sap.ui.predefine('sap/ui/vtm/extensions/ViewLinkingExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var V=a.extend("sap.ui.vtm.extensions.ViewLinkingExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IViewLinkingExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this._skipCount=new Map();this.applyPanelHandler(function(p){var v=p.getViewport();v.attachEvent("frameRenderingFinished",function(e){if(!this.getEnabled()){return;}var b=this._getPrimaryPanel();if(e.getSource()!=b.getViewport()){return;}this._updateViews(p);}.bind(this));}.bind(this));this.attachEnabledChanged(function(e){if(this.getEnabled()){var p=this._getPrimaryPanel();if(p){this._updateViews(p);}}}.bind(this));},
_getPrimaryPanel:function(){var p=this._vtm.getPanels();if(!p||!p.length){return null;}return this._vtm.getActivePanel()||p[0];},
_updateViews:function(s){var b=s.getViewport();if(!b.getInitialized()){return;}var c=b.getCameraInfo();var p=this._vtm.getPanels();p.forEach(function(t){if(t!==s){var d=t.getViewport();if(d.getInitialized()){d.setCameraInfo(c);}}});}
});
return V;});
sap.ui.predefine('sap/ui/vtm/extensions/ViewportSelectionLinkingExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var V=a.extend("sap.ui.vtm.extensions.ViewportSelectionLinkingExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IViewportSelectionLinkingExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this.applyPanelHandler(function(p){var t=p.getTree();var v=p.getViewport();var h=false;t.attachSelectionChanged(function(e){if(!this.getEnabled()){return;}if(h){return;}h=true;var i=e.getParameter("addedItems");var b=e.getParameter("removedItems");var s=[];b.forEach(function(d){if(d.sceneNodeIds){Array.prototype.push.apply(s,sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(d));}});v.setSelected(s,false,false);var c=[];i.forEach(function(d){if(d.sceneNodeIds){Array.prototype.push.apply(c,sap.ui.vtm.TreeItemUtilities.getSceneNodeIds(d));}});v.setSelected(c,true,false);h=false;}.bind(this));t.attachEvent("vtmInternalSetTreeSelectionComplete",function(e){h=false;});v.attachSelectionChanged(function(e){if(!this.getEnabled()){return;}var s=e.getParameter("selectedIds");var u=e.getParameter("userInteraction");if(u){var b=t.getItemsBySceneNodeId(s);t.setSelectedItems(b);}}.bind(this));}.bind(this));}
});
return V;});
sap.ui.predefine('sap/ui/vtm/extensions/VisibilityIconClickExtension',["jquery.sap.global","sap/ui/core/Control","../Extension"],function(q,S,a){"use strict";
var V=a.extend("sap.ui.vtm.extensions.VisibilityIconClickExtension",{
metadata:{interfaces:["sap.ui.vtm.interfaces.IVisibilityIconClickExtension","sap.ui.vtm.interfaces.IVisibilityHeaderIconClickExtension"]},
constructor:function(i,s){a.apply(this,arguments);},
initialize:function(){this.applyPanelHandler(function(p){var t=p.getTree();var v=p.getViewport();t.attachVisibilityIconClicked(function(e){if(!this.getEnabled()){return;}var i=e.getParameter("item");var b=e.getParameter("visibility");var n=!b;var c=e.getParameter("control");c.setVisibility(n);this._onTreeItemVisibilityClicked(t,v,i,n);}.bind(this));t.attachVisibilityHeaderIconClicked(function(e){if(!this.getEnabled()){return;}var b=e.getParameter("visibility");var n=!b;var c=e.getParameter("control");c.setVisibility(n);t.setVisibility(t.getRootItems(),n,true);}.bind(this));}.bind(this));},
_onTreeItemVisibilityClicked:function(t,v,i,b){var s=t.getSelectedItems();var c=(s&&s.indexOf(i)>=0);if(!c){s=[i];}t.setVisibility(s,b,true);}
});
return V;});
sap.ui.predefine('sap/ui/vtm/library',["jquery.sap.global",'sap/ui/base/DataType',"./ArrayUtilities","./MatrixComponent","./MatrixUtilities","./TreeItemUtilities","./HashUtilities","./DescriptorUtilities","./InternalColumns","./ColumnType","./PredefinedView","./TextColor","./SelectionMode","./InternalColumnDescriptor","./ChildCollectionType","./TreeItemType","./ColumnTemplates","./ViewableLoadStatus"],function(q,S,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.vtm",dependencies:["sap.ui.core","sap.ui.table","sap.m","sap.ui.vk"],interfaces:["sap.ui.vtm.interfaces.IDisplayStateCalculationExtension","sap.ui.vtm.interfaces.IInitialViewExtension","sap.ui.vtm.interfaces.IDownloadProgressExtension","sap.ui.vtm.interfaces.ILoadProgressExtension","sap.ui.vtm.interfaces.IMessageStatusCalculationExtension","sap.ui.vtm.interfaces.IMessageStatusIconClickExtension","sap.ui.vtm.interfaces.IMessageStatusHeaderIconClickExtension","sap.ui.vtm.interfaces.ISelectionLinkingExtension","sap.ui.vtm.interfaces.ISceneNodeHoverHighlightExtension","sap.ui.vtm.interfaces.ISceneNodeHoverTooltipExtension","sap.ui.vtm.interfaces.IViewLinkingExtension","sap.ui.vtm.interfaces.IViewportSelectionLinkingExtension","sap.ui.vtm.interfaces.IVisibilityIconClickExtension","sap.ui.vtm.interfaces.IVisibilityHeaderIconClickExtension"],types:["sap.ui.vtm.Matrix"],controls:["sap.ui.vtm.Panel","sap.ui.vtm.Tree","sap.ui.vtm.Text","sap.ui.vtm.Viewport","sap.ui.vtm.MessagesPopover","sap.ui.vtm.Progress","sap.ui.vtm.ProgressDialog","sap.ui.vtm.SelectColumnsDialog"],elements:["sap.ui.vtm.Vtm","sap.ui.vtm.Column","sap.ui.vtm.Lookup","sap.ui.vtm.ViewableLoadInfo","sap.ui.vtm.Viewable","sap.ui.vtm.Scene","sap.ui.vtm.SceneNode","sap.ui.vtm.Extension","sap.ui.vtm.DisplayGroup","sap.ui.vtm.TreeCollections","sap.ui.vtm.extensions.MessageStatusCalculationExtension","sap.ui.vtm.extensions.MessageStatusIconClickExtension","sap.ui.vtm.extensions.ViewportSelectionLinkingExtension","sap.ui.vtm.extensions.SelectionLinkingExtension","sap.ui.vtm.extensions.VisibilityIconClickExtension","sap.ui.vtm.extensions.DisplayStateCalculationExtension","sap.ui.vtm.extensions.ViewLinkingExtension","sap.ui.vtm.extensions.InitialViewExtension","sap.ui.vtm.extensions.LoadProgressExtension","sap.ui.vtm.extensions.SceneNodeHoverHighlightExtension","sap.ui.vtm.extensions.SceneNodeHoverTooltipExtension"],noLibraryCSS:false,version:"1.71.0"});
sap.ui.vtm.createVtm=function(I,s){return new sap.ui.vtm.Vtm(I,q.extend(s,{addDefaultExtensions:true}));};
var r;
sap.ui.vtm.getResourceBundle=function(){if(!r){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.vtm.i18n");}return r;};
sap.ui.vtm.createMeasureId=function(s,t){return(typeof s==="string")?s+"#"+t:s.getMetadata().getName()+"#"+t+" "+s.getId();};
sap.ui.vtm.measure=function(s,t,u){var v=sap.ui.vtm.createMeasureId(s,t);q.sap.measure.start(v,"",["sap.ui.vtm"]);try{u();}finally{q.sap.measure.end(v);}return v;};
sap.ui.vtm.Matrix=S.createType("sap.ui.vtm.Matrix",{isValid:function(v){return sap.ui.vtm.Matrix.getBaseType().isValid(v)&&v.length===13;}},S.getType("float[]"));return sap.ui.vtm;});
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5)

        (c) Copyright 2009-2015 SAP SE. All rights reserved
    
 */
sap.ui.predefine('sap/ui/vtm/CheckEye',["jquery.sap.global","sap/ui/core/Icon","sap/ui/core/IconRenderer","./library"],function(q,I,a,l){"use strict";
var C=I.extend("sap.ui.vtm.CheckEye",{
metadata:{library:"sap.ui.vtm",properties:{visibility:{type:"boolean"}}},
onAfterRendering:function(){var $=this.$();$.addClass("sapUiVtmCheckEye");},
renderer:a.render,
setVisibility:function(v){this.setProperty("visibility",v);switch(v){case true:this.setSrc("sap-icon://show");this.setVisible(true);break;case false:this.setSrc("sap-icon://hide");this.setVisible(true);break;default:this.setVisible(false);break;}}
});
return C;},true);
sap.ui.require.preload({
	"sap/ui/vtm/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.vtm","type":"library","embeds":[],"applicationVersion":{"version":"1.71.0"},"title":"SAPUI5 Visual Tree Mapper.","description":"SAPUI5 Visual Tree Mapper.","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_plus","sap_bluecrystal","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.0"},"sap.ui.unified":{"minVersion":"1.71.0","lazy":true},"sap.m":{"minVersion":"1.71.0","lazy":true},"sap.ui.layout":{"minVersion":"1.71.0","lazy":true}}},"library":{"i18n":false,"content":{"controls":["sap.ui.vtm.Panel","sap.ui.vtm.Tree","sap.ui.vtm.Text","sap.ui.vtm.Viewport","sap.ui.vtm.MessagesPopover","sap.ui.vtm.Progress","sap.ui.vtm.ProgressDialog","sap.ui.vtm.SelectColumnsDialog"],"elements":["sap.ui.vtm.Vtm","sap.ui.vtm.Column","sap.ui.vtm.Lookup","sap.ui.vtm.ViewableLoadInfo","sap.ui.vtm.Viewable","sap.ui.vtm.Scene","sap.ui.vtm.SceneNode","sap.ui.vtm.Extension","sap.ui.vtm.DisplayGroup","sap.ui.vtm.TreeCollections","sap.ui.vtm.extensions.MessageStatusCalculationExtension","sap.ui.vtm.extensions.MessageStatusIconClickExtension","sap.ui.vtm.extensions.ViewportSelectionLinkingExtension","sap.ui.vtm.extensions.SelectionLinkingExtension","sap.ui.vtm.extensions.VisibilityIconClickExtension","sap.ui.vtm.extensions.DisplayStateCalculationExtension","sap.ui.vtm.extensions.ViewLinkingExtension","sap.ui.vtm.extensions.InitialViewExtension","sap.ui.vtm.extensions.LoadProgressExtension","sap.ui.vtm.extensions.SceneNodeHoverHighlightExtension","sap.ui.vtm.extensions.SceneNodeHoverTooltipExtension"],"types":["sap.ui.vtm.Matrix"],"interfaces":["sap.ui.vtm.interfaces.IDisplayStateCalculationExtension","sap.ui.vtm.interfaces.IInitialViewExtension","sap.ui.vtm.interfaces.IDownloadProgressExtension","sap.ui.vtm.interfaces.ILoadProgressExtension","sap.ui.vtm.interfaces.IMessageStatusCalculationExtension","sap.ui.vtm.interfaces.IMessageStatusIconClickExtension","sap.ui.vtm.interfaces.IMessageStatusHeaderIconClickExtension","sap.ui.vtm.interfaces.ISelectionLinkingExtension","sap.ui.vtm.interfaces.ISceneNodeHoverHighlightExtension","sap.ui.vtm.interfaces.ISceneNodeHoverTooltipExtension","sap.ui.vtm.interfaces.IViewLinkingExtension","sap.ui.vtm.interfaces.IViewportSelectionLinkingExtension","sap.ui.vtm.interfaces.IVisibilityIconClickExtension","sap.ui.vtm.interfaces.IVisibilityHeaderIconClickExtension"]}}}}'
},"sap/ui/vtm/library-preload"
);
//# sourceMappingURL=library-preload.js.map