/*
 * canvg.js - Javascript SVG parser and renderer on Canvas
 * MIT Licensed 
 * Gabe Lerner (gabelerner@gmail.com)
 * http://code.google.com/p/canvg/
 *
 * Requires: rgbcolor.js - http://www.phpied.com/rgb-color-parser-in-javascript/
 */
(function(){this.canvg=function(t,s,o){if(t==null&&s==null&&o==null){var a=document.getElementsByTagName('svg');for(var i=0;i<a.length;i++){var b=a[i];var c=document.createElement('canvas');c.width=b.clientWidth;c.height=b.clientHeight;b.parentNode.insertBefore(c,b);b.parentNode.removeChild(b);var d=document.createElement('div');d.appendChild(b);canvg(c,d.innerHTML);}return;}o=o||{};if(typeof t=='string'){t=document.getElementById(t);}if(t.svg!=null)t.svg.stop();t.svg=svg=h();svg.opts=o;var e=t.getContext('2d');if(typeof(s.documentElement)!='undefined'){svg.loadXmlDoc(e,s);}else if(s.substr(0,1)=='<'){svg.loadXml(e,s);}else{svg.load(e,s);}};function h(){var o={};o.FRAMERATE=30;o.MAX_VIRTUAL_PIXELS=30000;o.init=function(c){o.Definitions={};o.Styles={};o.Animations=[];o.Images=[];o.ctx=c;o.ViewPort=new(function(){this.viewPorts=[];this.Clear=function(){this.viewPorts=[];};this.SetCurrent=function(w,a){this.viewPorts.push({width:w,height:a});};this.RemoveCurrent=function(){this.viewPorts.pop();};this.Current=function(){return this.viewPorts[this.viewPorts.length-1];};this.width=function(){return this.Current().width;};this.height=function(){return this.Current().height;};this.ComputeSize=function(d){if(d!=null&&typeof(d)=='number')return d;if(d=='x')return this.width();if(d=='y')return this.height();return Math.sqrt(Math.pow(this.width(),2)+Math.pow(this.height(),2))/Math.sqrt(2);}});};o.init();o.ImagesLoaded=function(){for(var i=0;i<o.Images.length;i++){if(!o.Images[i].loaded)return false;}return true;};o.trim=function(s){return s.replace(/^\s+|\s+$/g,'');};o.compressSpaces=function(s){return s.replace(/[\s\r\t\n]+/gm,' ');};o.ajax=function(u){var A;if(window.XMLHttpRequest){A=new XMLHttpRequest();}else{A=new ActiveXObject('Microsoft.XMLHTTP');}if(A){A.open('GET',u,false);A.send(null);return A.responseText;}return null;};o.parseXml=function(x){if(window.DOMParser){var p=new DOMParser();return p.parseFromString(x,'text/xml');}else{x=x.replace(/<!DOCTYPE svg[^>]*>/,'');var a=new ActiveXObject('Microsoft.XMLDOM');a.async='false';a.loadXML(x);return a;}};o.Property=function(n,v){this.name=n;this.value=v;};o.Property.prototype.getValue=function(){return this.value;};o.Property.prototype.hasValue=function(){return(this.value!=null&&this.value!=='');};o.Property.prototype.numValue=function(){if(!this.hasValue())return 0;var n=parseFloat(this.value);if((this.value+'').match(/%$/)){n=n/100.0;}return n;};o.Property.prototype.valueOrDefault=function(d){if(this.hasValue())return this.value;return d;};o.Property.prototype.numValueOrDefault=function(d){if(this.hasValue())return this.numValue();return d;};o.Property.prototype.addOpacity=function(a){var n=this.value;if(a!=null&&a!=''&&typeof(this.value)=='string'){var c=new RGBColor(this.value);if(c.ok){n='rgba('+c.r+', '+c.g+', '+c.b+', '+a+')';}}return new o.Property(this.name,n);};o.Property.prototype.getDefinition=function(){var n=this.value.replace(/^(url\()?#([^\)]+)\)?$/,'$2');return o.Definitions[n];};o.Property.prototype.isUrlDefinition=function(){return this.value.indexOf('url(')==0};o.Property.prototype.getFillStyleDefinition=function(e){var d=this.getDefinition();if(d!=null&&d.createGradient){return d.createGradient(o.ctx,e);}if(d!=null&&d.createPattern){return d.createPattern(o.ctx,e);}return null;};o.Property.prototype.getDPI=function(v){return 96.0;};o.Property.prototype.getEM=function(v){var e=12;var f=new o.Property('fontSize',o.Font.Parse(o.ctx.font).fontSize);if(f.hasValue())e=f.toPixels(v);return e;};o.Property.prototype.getUnits=function(){var s=this.value+'';return s.replace(/[0-9\.\-]/g,'');};o.Property.prototype.toPixels=function(v){if(!this.hasValue())return 0;var s=this.value+'';if(s.match(/em$/))return this.numValue()*this.getEM(v);if(s.match(/ex$/))return this.numValue()*this.getEM(v)/2.0;if(s.match(/px$/))return this.numValue();if(s.match(/pt$/))return this.numValue()*this.getDPI(v)*(1.0/72.0);if(s.match(/pc$/))return this.numValue()*15;if(s.match(/cm$/))return this.numValue()*this.getDPI(v)/2.54;if(s.match(/mm$/))return this.numValue()*this.getDPI(v)/25.4;if(s.match(/in$/))return this.numValue()*this.getDPI(v);if(s.match(/%$/))return this.numValue()*o.ViewPort.ComputeSize(v);return this.numValue();};o.Property.prototype.toMilliseconds=function(){if(!this.hasValue())return 0;var s=this.value+'';if(s.match(/s$/))return this.numValue()*1000;if(s.match(/ms$/))return this.numValue();return this.numValue();};o.Property.prototype.toRadians=function(){if(!this.hasValue())return 0;var s=this.value+'';if(s.match(/deg$/))return this.numValue()*(Math.PI/180.0);if(s.match(/grad$/))return this.numValue()*(Math.PI/200.0);if(s.match(/rad$/))return this.numValue();return this.numValue()*(Math.PI/180.0);};o.Font=new(function(){this.Styles='normal|italic|oblique|inherit';this.Variants='normal|small-caps|inherit';this.Weights='normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit';this.CreateFont=function(a,b,c,d,e,g){var f=g!=null?this.Parse(g):this.CreateFont('','','','','',o.ctx.font);return{fontFamily:e||f.fontFamily,fontSize:d||f.fontSize,fontStyle:a||f.fontStyle,fontWeight:c||f.fontWeight,fontVariant:b||f.fontVariant,toString:function(){return[this.fontStyle,this.fontVariant,this.fontWeight,this.fontSize,this.fontFamily].join(' ')}}};var t=this;this.Parse=function(s){var f={};var d=o.trim(o.compressSpaces(s||'')).split(' ');var a={fontSize:false,fontStyle:false,fontWeight:false,fontVariant:false};var b='';for(var i=0;i<d.length;i++){if(!a.fontStyle&&t.Styles.indexOf(d[i])!=-1){if(d[i]!='inherit')f.fontStyle=d[i];a.fontStyle=true;}else if(!a.fontVariant&&t.Variants.indexOf(d[i])!=-1){if(d[i]!='inherit')f.fontVariant=d[i];a.fontStyle=a.fontVariant=true;}else if(!a.fontWeight&&t.Weights.indexOf(d[i])!=-1){if(d[i]!='inherit')f.fontWeight=d[i];a.fontStyle=a.fontVariant=a.fontWeight=true;}else if(!a.fontSize){if(d[i]!='inherit')f.fontSize=d[i].split('/')[0];a.fontStyle=a.fontVariant=a.fontWeight=a.fontSize=true;}else{if(d[i]!='inherit')b+=d[i];}}if(b!='')f.fontFamily=b;return f;}});o.ToNumberArray=function(s){var a=o.trim(o.compressSpaces((s||'').replace(/,/g,' '))).split(' ');for(var i=0;i<a.length;i++){a[i]=parseFloat(a[i]);}return a;};o.Point=function(x,y){this.x=x;this.y=y;};o.Point.prototype.angleTo=function(p){return Math.atan2(p.y-this.y,p.x-this.x);};o.Point.prototype.applyTransform=function(v){var x=this.x*v[0]+this.y*v[2]+v[4];var y=this.x*v[1]+this.y*v[3]+v[5];this.x=x;this.y=y;};o.CreatePoint=function(s){var a=o.ToNumberArray(s);return new o.Point(a[0],a[1]);};o.CreatePath=function(s){var a=o.ToNumberArray(s);var p=[];for(var i=0;i<a.length;i+=2){p.push(new o.Point(a[i],a[i+1]));}return p;};o.BoundingBox=function(d,e,g,j){this.x1=Number.NaN;this.y1=Number.NaN;this.x2=Number.NaN;this.y2=Number.NaN;this.x=function(){return this.x1;};this.y=function(){return this.y1;};this.width=function(){return this.x2-this.x1;};this.height=function(){return this.y2-this.y1;};this.addPoint=function(x,y){if(x!=null){if(isNaN(this.x1)||isNaN(this.x2)){this.x1=x;this.x2=x;}if(x<this.x1)this.x1=x;if(x>this.x2)this.x2=x;}if(y!=null){if(isNaN(this.y1)||isNaN(this.y2)){this.y1=y;this.y2=y;}if(y<this.y1)this.y1=y;if(y>this.y2)this.y2=y;}};this.addX=function(x){this.addPoint(x,null);};this.addY=function(y){this.addPoint(null,y);};this.addBoundingBox=function(b){this.addPoint(b.x1,b.y1);this.addPoint(b.x2,b.y2);};this.addQuadraticCurve=function(p,a,b,c,f,k){var l=p+2/3*(b-p);var m=a+2/3*(c-a);var n=l+1/3*(f-p);var q=m+1/3*(k-a);this.addBezierCurve(p,a,l,n,m,q,f,k);};this.addBezierCurve=function(p,k,l,m,n,q,r,s){var u=[p,k],v=[l,m],w=[n,q],x=[r,s];this.addPoint(u[0],u[1]);this.addPoint(x[0],x[1]);for(i=0;i<=1;i++){var f=function(t){return Math.pow(1-t,3)*u[i]+3*Math.pow(1-t,2)*t*v[i]+3*(1-t)*Math.pow(t,2)*w[i]+Math.pow(t,3)*x[i];};var b=6*u[i]-12*v[i]+6*w[i];var a=-3*u[i]+9*v[i]-9*w[i]+3*x[i];var c=3*v[i]-3*u[i];if(a==0){if(b==0)continue;var t=-c/b;if(0<t&&t<1){if(i==0)this.addX(f(t));if(i==1)this.addY(f(t));}continue;}var y=Math.pow(b,2)-4*c*a;if(y<0)continue;var z=(-b+Math.sqrt(y))/(2*a);if(0<z&&z<1){if(i==0)this.addX(f(z));if(i==1)this.addY(f(z));}var A=(-b-Math.sqrt(y))/(2*a);if(0<A&&A<1){if(i==0)this.addX(f(A));if(i==1)this.addY(f(A));}}};this.isPointInBox=function(x,y){return(this.x1<=x&&x<=this.x2&&this.y1<=y&&y<=this.y2);};this.addPoint(d,e);this.addPoint(g,j);};o.Transform=function(v){var t=this;this.Type={};this.Type.translate=function(s){this.p=o.CreatePoint(s);this.apply=function(a){a.translate(this.p.x||0.0,this.p.y||0.0);};this.applyToPoint=function(p){p.applyTransform([1,0,0,1,this.p.x||0.0,this.p.y||0.0]);}};this.Type.rotate=function(s){var a=o.ToNumberArray(s);this.angle=new o.Property('angle',a[0]);this.cx=a[1]||0;this.cy=a[2]||0;this.apply=function(e){e.translate(this.cx,this.cy);e.rotate(this.angle.toRadians());e.translate(-this.cx,-this.cy);};this.applyToPoint=function(p){var a=this.angle.toRadians();p.applyTransform([1,0,0,1,this.p.x||0.0,this.p.y||0.0]);p.applyTransform([Math.cos(a),Math.sin(a),-Math.sin(a),Math.cos(a),0,0]);p.applyTransform([1,0,0,1,-this.p.x||0.0,-this.p.y||0.0]);}};this.Type.scale=function(s){this.p=o.CreatePoint(s);this.apply=function(a){a.scale(this.p.x||1.0,this.p.y||this.p.x||1.0);};this.applyToPoint=function(p){p.applyTransform([this.p.x||0.0,0,0,this.p.y||0.0,0,0]);}};this.Type.matrix=function(s){this.m=o.ToNumberArray(s);this.apply=function(a){a.transform(this.m[0],this.m[1],this.m[2],this.m[3],this.m[4],this.m[5]);};this.applyToPoint=function(p){p.applyTransform(this.m);}};this.Type.SkewBase=function(s){this.base=t.Type.matrix;this.base(s);this.angle=new o.Property('angle',s);};this.Type.SkewBase.prototype=new this.Type.matrix;this.Type.skewX=function(s){this.base=t.Type.SkewBase;this.base(s);this.m=[1,0,Math.tan(this.angle.toRadians()),1,0,0];};this.Type.skewX.prototype=new this.Type.SkewBase;this.Type.skewY=function(s){this.base=t.Type.SkewBase;this.base(s);this.m=[1,Math.tan(this.angle.toRadians()),0,1,0,0];};this.Type.skewY.prototype=new this.Type.SkewBase;this.transforms=[];this.apply=function(a){for(var i=0;i<this.transforms.length;i++){this.transforms[i].apply(a);}};this.applyToPoint=function(p){for(var i=0;i<this.transforms.length;i++){this.transforms[i].applyToPoint(p);}};var d=o.trim(o.compressSpaces(v)).split(/\s(?=[a-z])/);for(var i=0;i<d.length;i++){var b=d[i].split('(')[0];var s=d[i].split('(')[1].replace(')','');var c=new this.Type[b](s);this.transforms.push(c);}};o.AspectRatio=function(c,a,w,d,b,e,m,f,r,g){a=o.compressSpaces(a);a=a.replace(/^defer\s/,'');var j=a.split(' ')[0]||'xMidYMid';var k=a.split(' ')[1]||'meet';var s=w/d;var l=b/e;var n=Math.min(s,l);var p=Math.max(s,l);if(k=='meet'){d*=n;e*=n;}if(k=='slice'){d*=p;e*=p;}r=new o.Property('refX',r);g=new o.Property('refY',g);if(r.hasValue()&&g.hasValue()){c.translate(-n*r.toPixels('x'),-n*g.toPixels('y'));}else{if(j.match(/^xMid/)&&((k=='meet'&&n==l)||(k=='slice'&&p==l)))c.translate(w/2.0-d/2.0,0);if(j.match(/YMid$/)&&((k=='meet'&&n==s)||(k=='slice'&&p==s)))c.translate(0,b/2.0-e/2.0);if(j.match(/^xMax/)&&((k=='meet'&&n==l)||(k=='slice'&&p==l)))c.translate(w-d,0);if(j.match(/YMax$/)&&((k=='meet'&&n==s)||(k=='slice'&&p==s)))c.translate(0,b-e);}if(j=='none')c.scale(s,l);else if(k=='meet')c.scale(n,n);else if(k=='slice')c.scale(p,p);c.translate(m==null?0:-m,f==null?0:-f);};o.Element={};o.EmptyProperty=new o.Property('EMPTY','');o.Element.ElementBase=function(n){this.attributes={};this.styles={};this.children=[];this.attribute=function(e,k){var a=this.attributes[e];if(a!=null)return a;if(k==true){a=new o.Property(e,'');this.attributes[e]=a;}return a||o.EmptyProperty;};this.style=function(e,k){var s=this.styles[e];if(s!=null)return s;var a=this.attribute(e);if(a!=null&&a.hasValue()){this.styles[e]=a;return a;}var p=this.parent;if(p!=null){var l=p.style(e);if(l!=null&&l.hasValue()){return l;}}if(k==true){s=new o.Property(e,'');this.styles[e]=s;}return s||o.EmptyProperty;};this.render=function(a){if(this.style('display').value=='none')return;if(this.attribute('visibility').value=='hidden')return;a.save();this.setContext(a);if(this.attribute('mask').hasValue()){var m=this.attribute('mask').getDefinition();if(m!=null)m.apply(a,this);}else if(this.style('filter').hasValue()){var k=this.style('filter').getDefinition();if(k!=null)k.apply(a,this);}else this.renderChildren(a);this.clearContext(a);a.restore();};this.setContext=function(a){};this.clearContext=function(a){};this.renderChildren=function(a){for(var i=0;i<this.children.length;i++){this.children[i].render(a);}};this.addChild=function(c,a){var k=c;if(a)k=o.CreateElement(c);k.parent=this;this.children.push(k);};if(n!=null&&n.nodeType==1){for(var i=0;i<n.childNodes.length;i++){var c=n.childNodes[i];if(c.nodeType==1)this.addChild(c,true);}for(var i=0;i<n.attributes.length;i++){var b=n.attributes[i];this.attributes[b.nodeName]=new o.Property(b.nodeName,b.nodeValue);}var d=o.Styles[n.nodeName];if(d!=null){for(var e in d){this.styles[e]=d[e];}}if(this.attribute('class').hasValue()){var f=o.compressSpaces(this.attribute('class').value).split(' ');for(var j=0;j<f.length;j++){d=o.Styles['.'+f[j]];if(d!=null){for(var e in d){this.styles[e]=d[e];}}d=o.Styles[n.nodeName+'.'+f[j]];if(d!=null){for(var e in d){this.styles[e]=d[e];}}}}if(this.attribute('id').hasValue()){var d=o.Styles['#'+this.attribute('id').value];if(d!=null){for(var e in d){this.styles[e]=d[e];}}}if(this.attribute('style').hasValue()){var d=this.attribute('style').value.split(';');for(var i=0;i<d.length;i++){if(o.trim(d[i])!=''){var g=d[i].split(':');var e=o.trim(g[0]);var v=o.trim(g[1]);this.styles[e]=new o.Property(e,v);}}}if(this.attribute('id').hasValue()){if(o.Definitions[this.attribute('id').value]==null){o.Definitions[this.attribute('id').value]=this;}}}};o.Element.RenderedElementBase=function(n){this.base=o.Element.ElementBase;this.base(n);this.setContext=function(c){if(this.style('fill').isUrlDefinition()){var f=this.style('fill').getFillStyleDefinition(this);if(f!=null)c.fillStyle=f;}else if(this.style('fill').hasValue()){var a=this.style('fill');if(a.value=='currentColor')a.value=this.style('color').value;c.fillStyle=(a.value=='none'?'rgba(0,0,0,0)':a.value);}if(this.style('fill-opacity').hasValue()){var a=new o.Property('fill',c.fillStyle);a=a.addOpacity(this.style('fill-opacity').value);c.fillStyle=a.value;}if(this.style('stroke').isUrlDefinition()){var f=this.style('stroke').getFillStyleDefinition(this);if(f!=null)c.strokeStyle=f;}else if(this.style('stroke').hasValue()){var s=this.style('stroke');if(s.value=='currentColor')s.value=this.style('color').value;c.strokeStyle=(s.value=='none'?'rgba(0,0,0,0)':s.value);}if(this.style('stroke-opacity').hasValue()){var s=new o.Property('stroke',c.strokeStyle);s=s.addOpacity(this.style('stroke-opacity').value);c.strokeStyle=s.value;}if(this.style('stroke-width').hasValue())c.lineWidth=this.style('stroke-width').toPixels();if(this.style('stroke-linecap').hasValue())c.lineCap=this.style('stroke-linecap').value;if(this.style('stroke-linejoin').hasValue())c.lineJoin=this.style('stroke-linejoin').value;if(this.style('stroke-miterlimit').hasValue())c.miterLimit=this.style('stroke-miterlimit').value;if(typeof(c.font)!='undefined'){c.font=o.Font.CreateFont(this.style('font-style').value,this.style('font-variant').value,this.style('font-weight').value,this.style('font-size').hasValue()?this.style('font-size').toPixels()+'px':'',this.style('font-family').value).toString();}if(this.attribute('transform').hasValue()){var t=new o.Transform(this.attribute('transform').value);t.apply(c);}if(this.attribute('clip-path').hasValue()){var b=this.attribute('clip-path').getDefinition();if(b!=null)b.apply(c);}if(this.style('opacity').hasValue()){c.globalAlpha=this.style('opacity').numValue();}}};o.Element.RenderedElementBase.prototype=new o.Element.ElementBase;o.Element.PathElementBase=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.path=function(c){if(c!=null)c.beginPath();return new o.BoundingBox();};this.renderChildren=function(c){this.path(c);o.Mouse.checkPath(this,c);if(c.fillStyle!='')c.fill();if(c.strokeStyle!='')c.stroke();var m=this.getMarkers();if(m!=null){if(this.style('marker-start').isUrlDefinition()){var a=this.style('marker-start').getDefinition();a.render(c,m[0][0],m[0][1]);}if(this.style('marker-mid').isUrlDefinition()){var a=this.style('marker-mid').getDefinition();for(var i=1;i<m.length-1;i++){a.render(c,m[i][0],m[i][1]);}}if(this.style('marker-end').isUrlDefinition()){var a=this.style('marker-end').getDefinition();a.render(c,m[m.length-1][0],m[m.length-1][1]);}}};this.getBoundingBox=function(){return this.path();};this.getMarkers=function(){return null;}};o.Element.PathElementBase.prototype=new o.Element.RenderedElementBase;o.Element.svg=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.baseClearContext=this.clearContext;this.clearContext=function(c){this.baseClearContext(c);o.ViewPort.RemoveCurrent();};this.baseSetContext=this.setContext;this.setContext=function(c){c.strokeStyle='rgba(0,0,0,0)';c.lineCap='butt';c.lineJoin='miter';c.miterLimit=4;this.baseSetContext(c);if(!this.attribute('x').hasValue())this.attribute('x',true).value=0;if(!this.attribute('y').hasValue())this.attribute('y',true).value=0;c.translate(this.attribute('x').toPixels('x'),this.attribute('y').toPixels('y'));var w=o.ViewPort.width();var a=o.ViewPort.height();if(!this.attribute('width').hasValue())this.attribute('width',true).value='100%';if(!this.attribute('height').hasValue())this.attribute('height',true).value='100%';if(typeof(this.root)=='undefined'){w=this.attribute('width').toPixels('x');a=this.attribute('height').toPixels('y');var x=0;var y=0;if(this.attribute('refX').hasValue()&&this.attribute('refY').hasValue()){x=-this.attribute('refX').toPixels('x');y=-this.attribute('refY').toPixels('y');}c.beginPath();c.moveTo(x,y);c.lineTo(w,y);c.lineTo(w,a);c.lineTo(x,a);c.closePath();c.clip();}o.ViewPort.SetCurrent(w,a);if(this.attribute('viewBox').hasValue()){var v=o.ToNumberArray(this.attribute('viewBox').value);var m=v[0];var b=v[1];w=v[2];a=v[3];o.AspectRatio(c,this.attribute('preserveAspectRatio').value,o.ViewPort.width(),w,o.ViewPort.height(),a,m,b,this.attribute('refX').value,this.attribute('refY').value);o.ViewPort.RemoveCurrent();o.ViewPort.SetCurrent(v[2],v[3]);}}};o.Element.svg.prototype=new o.Element.RenderedElementBase;o.Element.rect=function(n){this.base=o.Element.PathElementBase;this.base(n);this.path=function(c){var x=this.attribute('x').toPixels('x');var y=this.attribute('y').toPixels('y');var w=this.attribute('width').toPixels('x');var a=this.attribute('height').toPixels('y');var r=this.attribute('rx').toPixels('x');var b=this.attribute('ry').toPixels('y');if(this.attribute('rx').hasValue()&&!this.attribute('ry').hasValue())b=r;if(this.attribute('ry').hasValue()&&!this.attribute('rx').hasValue())r=b;if(c!=null){c.beginPath();c.moveTo(x+r,y);c.lineTo(x+w-r,y);c.quadraticCurveTo(x+w,y,x+w,y+b);c.lineTo(x+w,y+a-b);c.quadraticCurveTo(x+w,y+a,x+w-r,y+a);c.lineTo(x+r,y+a);c.quadraticCurveTo(x,y+a,x,y+a-b);c.lineTo(x,y+b);c.quadraticCurveTo(x,y,x+r,y);c.closePath();}return new o.BoundingBox(x,y,x+w,y+a);}};o.Element.rect.prototype=new o.Element.PathElementBase;o.Element.circle=function(n){this.base=o.Element.PathElementBase;this.base(n);this.path=function(c){var a=this.attribute('cx').toPixels('x');var b=this.attribute('cy').toPixels('y');var r=this.attribute('r').toPixels();if(c!=null){c.beginPath();c.arc(a,b,r,0,Math.PI*2,true);c.closePath();}return new o.BoundingBox(a-r,b-r,a+r,b+r);}};o.Element.circle.prototype=new o.Element.PathElementBase;o.Element.ellipse=function(n){this.base=o.Element.PathElementBase;this.base(n);this.path=function(c){var K=4*((Math.sqrt(2)-1)/3);var r=this.attribute('rx').toPixels('x');var a=this.attribute('ry').toPixels('y');var b=this.attribute('cx').toPixels('x');var d=this.attribute('cy').toPixels('y');if(c!=null){c.beginPath();c.moveTo(b,d-a);c.bezierCurveTo(b+(K*r),d-a,b+r,d-(K*a),b+r,d);c.bezierCurveTo(b+r,d+(K*a),b+(K*r),d+a,b,d+a);c.bezierCurveTo(b-(K*r),d+a,b-r,d+(K*a),b-r,d);c.bezierCurveTo(b-r,d-(K*a),b-(K*r),d-a,b,d-a);c.closePath();}return new o.BoundingBox(b-r,d-a,b+r,d+a);}};o.Element.ellipse.prototype=new o.Element.PathElementBase;o.Element.line=function(n){this.base=o.Element.PathElementBase;this.base(n);this.getPoints=function(){return[new o.Point(this.attribute('x1').toPixels('x'),this.attribute('y1').toPixels('y')),new o.Point(this.attribute('x2').toPixels('x'),this.attribute('y2').toPixels('y'))];};this.path=function(c){var p=this.getPoints();if(c!=null){c.beginPath();c.moveTo(p[0].x,p[0].y);c.lineTo(p[1].x,p[1].y);}return new o.BoundingBox(p[0].x,p[0].y,p[1].x,p[1].y);};this.getMarkers=function(){var p=this.getPoints();var a=p[0].angleTo(p[1]);return[[p[0],a],[p[1],a]];}};o.Element.line.prototype=new o.Element.PathElementBase;o.Element.polyline=function(n){this.base=o.Element.PathElementBase;this.base(n);this.points=o.CreatePath(this.attribute('points').value);this.path=function(c){var b=new o.BoundingBox(this.points[0].x,this.points[0].y);if(c!=null){c.beginPath();c.moveTo(this.points[0].x,this.points[0].y);}for(var i=1;i<this.points.length;i++){b.addPoint(this.points[i].x,this.points[i].y);if(c!=null)c.lineTo(this.points[i].x,this.points[i].y);}return b;};this.getMarkers=function(){var m=[];for(var i=0;i<this.points.length-1;i++){m.push([this.points[i],this.points[i].angleTo(this.points[i+1])]);}m.push([this.points[this.points.length-1],m[m.length-1][1]]);return m;}};o.Element.polyline.prototype=new o.Element.PathElementBase;o.Element.polygon=function(n){this.base=o.Element.polyline;this.base(n);this.basePath=this.path;this.path=function(c){var b=this.basePath(c);if(c!=null){c.lineTo(this.points[0].x,this.points[0].y);c.closePath();}return b;}};o.Element.polygon.prototype=new o.Element.polyline;o.Element.path=function(n){this.base=o.Element.PathElementBase;this.base(n);var d=this.attribute('d').value;d=d.replace(/,/gm,' ');d=d.replace(/([MmZzLlHhVvCcSsQqTtAa])([MmZzLlHhVvCcSsQqTtAa])/gm,'$1 $2');d=d.replace(/([MmZzLlHhVvCcSsQqTtAa])([MmZzLlHhVvCcSsQqTtAa])/gm,'$1 $2');d=d.replace(/([MmZzLlHhVvCcSsQqTtAa])([^\s])/gm,'$1 $2');d=d.replace(/([^\s])([MmZzLlHhVvCcSsQqTtAa])/gm,'$1 $2');d=d.replace(/([0-9])([+\-])/gm,'$1 $2');d=d.replace(/(\.[0-9]*)(\.)/gm,'$1 $2');d=d.replace(/([Aa](\s+[0-9]+){3})\s+([01])\s*([01])/gm,'$1 $3 $4 ');d=o.compressSpaces(d);d=o.trim(d);this.PathParser=new(function(d){this.tokens=d.split(' ');this.reset=function(){this.i=-1;this.command='';this.previousCommand='';this.start=new o.Point(0,0);this.control=new o.Point(0,0);this.current=new o.Point(0,0);this.points=[];this.angles=[];};this.isEnd=function(){return this.i>=this.tokens.length-1;};this.isCommandOrEnd=function(){if(this.isEnd())return true;return this.tokens[this.i+1].match(/^[A-Za-z]$/)!=null;};this.isRelativeCommand=function(){switch(this.command){case'm':case'l':case'h':case'v':case'c':case's':case'q':case't':case'a':case'z':return true;break;}return false;};this.getToken=function(){this.i++;return this.tokens[this.i];};this.getScalar=function(){return parseFloat(this.getToken());};this.nextCommand=function(){this.previousCommand=this.command;this.command=this.getToken();};this.getPoint=function(){var p=new o.Point(this.getScalar(),this.getScalar());return this.makeAbsolute(p);};this.getAsControlPoint=function(){var p=this.getPoint();this.control=p;return p;};this.getAsCurrentPoint=function(){var p=this.getPoint();this.current=p;return p;};this.getReflectedControlPoint=function(){if(this.previousCommand.toLowerCase()!='c'&&this.previousCommand.toLowerCase()!='s'){return this.current;}var p=new o.Point(2*this.current.x-this.control.x,2*this.current.y-this.control.y);return p;};this.makeAbsolute=function(p){if(this.isRelativeCommand()){p.x+=this.current.x;p.y+=this.current.y;}return p;};this.addMarker=function(p,f,a){if(a!=null&&this.angles.length>0&&this.angles[this.angles.length-1]==null){this.angles[this.angles.length-1]=this.points[this.points.length-1].angleTo(a);}this.addMarkerAngle(p,f==null?null:f.angleTo(p));};this.addMarkerAngle=function(p,a){this.points.push(p);this.angles.push(a);};this.getMarkerPoints=function(){return this.points;};this.getMarkerAngles=function(){for(var i=0;i<this.angles.length;i++){if(this.angles[i]==null){for(var j=i+1;j<this.angles.length;j++){if(this.angles[j]!=null){this.angles[i]=this.angles[j];break;}}}}return this.angles;}})(d);this.path=function(b){var e=this.PathParser;e.reset();var f=new o.BoundingBox();if(b!=null)b.beginPath();while(!e.isEnd()){e.nextCommand();switch(e.command){case'M':case'm':var p=e.getAsCurrentPoint();e.addMarker(p);f.addPoint(p.x,p.y);if(b!=null)b.moveTo(p.x,p.y);e.start=e.current;while(!e.isCommandOrEnd()){var p=e.getAsCurrentPoint();e.addMarker(p,e.start);f.addPoint(p.x,p.y);if(b!=null)b.lineTo(p.x,p.y);}break;case'L':case'l':while(!e.isCommandOrEnd()){var c=e.current;var p=e.getAsCurrentPoint();e.addMarker(p,c);f.addPoint(p.x,p.y);if(b!=null)b.lineTo(p.x,p.y);}break;case'H':case'h':while(!e.isCommandOrEnd()){var g=new o.Point((e.isRelativeCommand()?e.current.x:0)+e.getScalar(),e.current.y);e.addMarker(g,e.current);e.current=g;f.addPoint(e.current.x,e.current.y);if(b!=null)b.lineTo(e.current.x,e.current.y);}break;case'V':case'v':while(!e.isCommandOrEnd()){var g=new o.Point(e.current.x,(e.isRelativeCommand()?e.current.y:0)+e.getScalar());e.addMarker(g,e.current);e.current=g;f.addPoint(e.current.x,e.current.y);if(b!=null)b.lineTo(e.current.x,e.current.y);}break;case'C':case'c':while(!e.isCommandOrEnd()){var j=e.current;var k=e.getPoint();var q=e.getAsControlPoint();var t=e.getAsCurrentPoint();e.addMarker(t,q,k);f.addBezierCurve(j.x,j.y,k.x,k.y,q.x,q.y,t.x,t.y);if(b!=null)b.bezierCurveTo(k.x,k.y,q.x,q.y,t.x,t.y);}break;case'S':case's':while(!e.isCommandOrEnd()){var j=e.current;var k=e.getReflectedControlPoint();var q=e.getAsControlPoint();var t=e.getAsCurrentPoint();e.addMarker(t,q,k);f.addBezierCurve(j.x,j.y,k.x,k.y,q.x,q.y,t.x,t.y);if(b!=null)b.bezierCurveTo(k.x,k.y,q.x,q.y,t.x,t.y);}break;case'Q':case'q':while(!e.isCommandOrEnd()){var j=e.current;var q=e.getAsControlPoint();var t=e.getAsCurrentPoint();e.addMarker(t,q,q);f.addQuadraticCurve(j.x,j.y,q.x,q.y,t.x,t.y);if(b!=null)b.quadraticCurveTo(q.x,q.y,t.x,t.y);}break;case'T':case't':while(!e.isCommandOrEnd()){var j=e.current;var q=e.getReflectedControlPoint();e.control=q;var t=e.getAsCurrentPoint();e.addMarker(t,q,q);f.addQuadraticCurve(j.x,j.y,q.x,q.y,t.x,t.y);if(b!=null)b.quadraticCurveTo(q.x,q.y,t.x,t.y);}break;case'A':case'a':while(!e.isCommandOrEnd()){var j=e.current;var w=e.getScalar();var x=e.getScalar();var y=e.getScalar()*(Math.PI/180.0);var z=e.getScalar();var A=e.getScalar();var t=e.getAsCurrentPoint();var B=new o.Point(Math.cos(y)*(j.x-t.x)/2.0+Math.sin(y)*(j.y-t.y)/2.0,-Math.sin(y)*(j.x-t.x)/2.0+Math.cos(y)*(j.y-t.y)/2.0);var l=Math.pow(B.x,2)/Math.pow(w,2)+Math.pow(B.y,2)/Math.pow(x,2);if(l>1){w*=Math.sqrt(l);x*=Math.sqrt(l);}var s=(z==A?-1:1)*Math.sqrt(((Math.pow(w,2)*Math.pow(x,2))-(Math.pow(w,2)*Math.pow(B.y,2))-(Math.pow(x,2)*Math.pow(B.x,2)))/(Math.pow(w,2)*Math.pow(B.y,2)+Math.pow(x,2)*Math.pow(B.x,2)));if(isNaN(s))s=0;var C=new o.Point(s*w*B.y/x,s*-x*B.x/w);var D=new o.Point((j.x+t.x)/2.0+Math.cos(y)*C.x-Math.sin(y)*C.y,(j.y+t.y)/2.0+Math.sin(y)*C.x+Math.cos(y)*C.y);var m=function(v){return Math.sqrt(Math.pow(v[0],2)+Math.pow(v[1],2));};var r=function(u,v){return(u[0]*v[0]+u[1]*v[1])/(m(u)*m(v))};var a=function(u,v){return(u[0]*v[1]<u[1]*v[0]?-1:1)*Math.acos(r(u,v));};var E=a([1,0],[(B.x-C.x)/w,(B.y-C.y)/x]);var u=[(B.x-C.x)/w,(B.y-C.y)/x];var v=[(-B.x-C.x)/w,(-B.y-C.y)/x];var F=a(u,v);if(r(u,v)<=-1)F=Math.PI;if(r(u,v)>=1)F=0;if(A==0&&F>0)F=F-2*Math.PI;if(A==1&&F<0)F=F+2*Math.PI;var G=new o.Point(D.x+w*Math.cos((E+(E+F))/2),D.y+x*Math.sin((E+(E+F))/2));e.addMarkerAngle(G,(E+(E+F))/2+(A==0?-1:1)*Math.PI/2);e.addMarkerAngle(t,(E+F)+(A==0?-1:1)*Math.PI/2);f.addPoint(t.x,t.y);if(b!=null){var r=w>x?w:x;var H=w>x?1:w/x;var I=w>x?x/w:1;b.translate(D.x,D.y);b.rotate(y);b.scale(H,I);b.arc(0,0,r,E,E+F,1-A);b.scale(1/H,1/I);b.rotate(-y);b.translate(-D.x,-D.y);}}break;case'Z':case'z':if(b!=null)b.closePath();e.current=e.start;}}return f;};this.getMarkers=function(){var p=this.PathParser.getMarkerPoints();var a=this.PathParser.getMarkerAngles();var m=[];for(var i=0;i<p.length;i++){m.push([p[i],a[i]]);}return m;}};o.Element.path.prototype=new o.Element.PathElementBase;o.Element.pattern=function(n){this.base=o.Element.ElementBase;this.base(n);this.createPattern=function(a,e){var t=new o.Element.svg();t.attributes['viewBox']=new o.Property('viewBox',this.attribute('viewBox').value);t.attributes['x']=new o.Property('x',this.attribute('x').value);t.attributes['y']=new o.Property('y',this.attribute('y').value);t.attributes['width']=new o.Property('width',this.attribute('width').value);t.attributes['height']=new o.Property('height',this.attribute('height').value);t.children=this.children;var c=document.createElement('canvas');document.body.appendChild(c);c.width=this.attribute('width').toPixels('x')+this.attribute('x').toPixels('x');c.height=this.attribute('height').toPixels('y')+this.attribute('y').toPixels('y');t.render(c.getContext('2d'));return a.createPattern(c,'repeat');}};o.Element.pattern.prototype=new o.Element.ElementBase;o.Element.marker=function(n){this.base=o.Element.ElementBase;this.base(n);this.baseRender=this.render;this.render=function(c,p,a){c.translate(p.x,p.y);if(this.attribute('orient').valueOrDefault('auto')=='auto')c.rotate(a);if(this.attribute('markerUnits').valueOrDefault('strokeWidth')=='strokeWidth')c.scale(c.lineWidth,c.lineWidth);c.save();var t=new o.Element.svg();t.attributes['viewBox']=new o.Property('viewBox',this.attribute('viewBox').value);t.attributes['refX']=new o.Property('refX',this.attribute('refX').value);t.attributes['refY']=new o.Property('refY',this.attribute('refY').value);t.attributes['width']=new o.Property('width',this.attribute('markerWidth').value);t.attributes['height']=new o.Property('height',this.attribute('markerHeight').value);t.attributes['fill']=new o.Property('fill',this.attribute('fill').valueOrDefault('black'));t.attributes['stroke']=new o.Property('stroke',this.attribute('stroke').valueOrDefault('none'));t.children=this.children;t.render(c);c.restore();if(this.attribute('markerUnits').valueOrDefault('strokeWidth')=='strokeWidth')c.scale(1/c.lineWidth,1/c.lineWidth);if(this.attribute('orient').valueOrDefault('auto')=='auto')c.rotate(-a);c.translate(-p.x,-p.y);}};o.Element.marker.prototype=new o.Element.ElementBase;o.Element.defs=function(n){this.base=o.Element.ElementBase;this.base(n);this.render=function(c){}};o.Element.defs.prototype=new o.Element.ElementBase;o.Element.GradientBase=function(n){this.base=o.Element.ElementBase;this.base(n);this.gradientUnits=this.attribute('gradientUnits').valueOrDefault('objectBoundingBox');this.stops=[];for(var i=0;i<this.children.length;i++){var a=this.children[i];this.stops.push(a);}this.getGradient=function(){};this.createGradient=function(b,e){var s=this;if(this.attribute('xlink:href').hasValue()){s=this.attribute('xlink:href').getDefinition();}var g=this.getGradient(b,e);if(g==null)return s.stops[s.stops.length-1].color;for(var i=0;i<s.stops.length;i++){g.addColorStop(s.stops[i].offset,s.stops[i].color);}if(this.attribute('gradientTransform').hasValue()){var r=o.ViewPort.viewPorts[0];var d=new o.Element.rect();d.attributes['x']=new o.Property('x',-o.MAX_VIRTUAL_PIXELS/3.0);d.attributes['y']=new o.Property('y',-o.MAX_VIRTUAL_PIXELS/3.0);d.attributes['width']=new o.Property('width',o.MAX_VIRTUAL_PIXELS);d.attributes['height']=new o.Property('height',o.MAX_VIRTUAL_PIXELS);var f=new o.Element.g();f.attributes['transform']=new o.Property('transform',this.attribute('gradientTransform').value);f.children=[d];var t=new o.Element.svg();t.attributes['x']=new o.Property('x',0);t.attributes['y']=new o.Property('y',0);t.attributes['width']=new o.Property('width',r.width);t.attributes['height']=new o.Property('height',r.height);t.children=[f];var c=document.createElement('canvas');c.width=r.width;c.height=r.height;var j=c.getContext('2d');j.fillStyle=g;t.render(j);return j.createPattern(c,'no-repeat');}return g;}};o.Element.GradientBase.prototype=new o.Element.ElementBase;o.Element.linearGradient=function(n){this.base=o.Element.GradientBase;this.base(n);this.getGradient=function(c,e){var b=e.getBoundingBox();var x=(this.gradientUnits=='objectBoundingBox'?b.x()+b.width()*this.attribute('x1').numValue():this.attribute('x1').toPixels('x'));var y=(this.gradientUnits=='objectBoundingBox'?b.y()+b.height()*this.attribute('y1').numValue():this.attribute('y1').toPixels('y'));var a=(this.gradientUnits=='objectBoundingBox'?b.x()+b.width()*this.attribute('x2').numValue():this.attribute('x2').toPixels('x'));var d=(this.gradientUnits=='objectBoundingBox'?b.y()+b.height()*this.attribute('y2').numValue():this.attribute('y2').toPixels('y'));if(x==a&&y==d)return null;return c.createLinearGradient(x,y,a,d);}};o.Element.linearGradient.prototype=new o.Element.GradientBase;o.Element.radialGradient=function(n){this.base=o.Element.GradientBase;this.base(n);this.getGradient=function(c,e){var b=e.getBoundingBox();if(!this.attribute('cx').hasValue())this.attribute('cx',true).value='50%';if(!this.attribute('cy').hasValue())this.attribute('cy',true).value='50%';if(!this.attribute('r').hasValue())this.attribute('r',true).value='50%';var a=(this.gradientUnits=='objectBoundingBox'?b.x()+b.width()*this.attribute('cx').numValue():this.attribute('cx').toPixels('x'));var d=(this.gradientUnits=='objectBoundingBox'?b.y()+b.height()*this.attribute('cy').numValue():this.attribute('cy').toPixels('y'));var f=a;var g=d;if(this.attribute('fx').hasValue()){f=(this.gradientUnits=='objectBoundingBox'?b.x()+b.width()*this.attribute('fx').numValue():this.attribute('fx').toPixels('x'));}if(this.attribute('fy').hasValue()){g=(this.gradientUnits=='objectBoundingBox'?b.y()+b.height()*this.attribute('fy').numValue():this.attribute('fy').toPixels('y'));}var r=(this.gradientUnits=='objectBoundingBox'?(b.width()+b.height())/2.0*this.attribute('r').numValue():this.attribute('r').toPixels());return c.createRadialGradient(f,g,0,a,d,r);}};o.Element.radialGradient.prototype=new o.Element.GradientBase;o.Element.stop=function(n){this.base=o.Element.ElementBase;this.base(n);this.offset=this.attribute('offset').numValue();var s=this.style('stop-color');if(this.style('stop-opacity').hasValue())s=s.addOpacity(this.style('stop-opacity').value);this.color=s.value;};o.Element.stop.prototype=new o.Element.ElementBase;o.Element.AnimateBase=function(n){this.base=o.Element.ElementBase;this.base(n);o.Animations.push(this);this.duration=0.0;this.begin=this.attribute('begin').toMilliseconds();this.maxDuration=this.begin+this.attribute('dur').toMilliseconds();this.getProperty=function(){var a=this.attribute('attributeType').value;var b=this.attribute('attributeName').value;if(a=='CSS'){return this.parent.style(b,true);}return this.parent.attribute(b,true);};this.initialValue=null;this.initialUnits='';this.removed=false;this.calcValue=function(){return'';};this.update=function(d){if(this.initialValue==null){this.initialValue=this.getProperty().value;this.initialUnits=this.getProperty().getUnits();}if(this.duration>this.maxDuration){if(this.attribute('repeatCount').value=='indefinite'){this.duration=0.0}else if(this.attribute('fill').valueOrDefault('remove')=='remove'&&!this.removed){this.removed=true;this.getProperty().value=this.initialValue;return true;}else{return false;}}this.duration=this.duration+d;var u=false;if(this.begin<this.duration){var a=this.calcValue();if(this.attribute('type').hasValue()){var t=this.attribute('type').value;a=t+'('+a+')';}this.getProperty().value=a;u=true;}return u;};this.from=this.attribute('from');this.to=this.attribute('to');this.values=this.attribute('values');if(this.values.hasValue())this.values.value=this.values.value.split(';');this.progress=function(){var r={progress:(this.duration-this.begin)/(this.maxDuration-this.begin)};if(this.values.hasValue()){var p=r.progress*(this.values.value.length-1);var l=Math.floor(p),u=Math.ceil(p);r.from=new o.Property('from',parseFloat(this.values.value[l]));r.to=new o.Property('to',parseFloat(this.values.value[u]));r.progress=(p-l)/(u-l);}else{r.from=this.from;r.to=this.to;}return r;}};o.Element.AnimateBase.prototype=new o.Element.ElementBase;o.Element.animate=function(n){this.base=o.Element.AnimateBase;this.base(n);this.calcValue=function(){var p=this.progress();var a=p.from.numValue()+(p.to.numValue()-p.from.numValue())*p.progress;return a+this.initialUnits;};};o.Element.animate.prototype=new o.Element.AnimateBase;o.Element.animateColor=function(n){this.base=o.Element.AnimateBase;this.base(n);this.calcValue=function(){var p=this.progress();var f=new RGBColor(p.from.value);var t=new RGBColor(p.to.value);if(f.ok&&t.ok){var r=f.r+(t.r-f.r)*p.progress;var g=f.g+(t.g-f.g)*p.progress;var b=f.b+(t.b-f.b)*p.progress;return'rgb('+parseInt(r,10)+','+parseInt(g,10)+','+parseInt(b,10)+')';}return this.attribute('from').value;};};o.Element.animateColor.prototype=new o.Element.AnimateBase;o.Element.animateTransform=function(n){this.base=o.Element.animate;this.base(n);};o.Element.animateTransform.prototype=new o.Element.animate;o.Element.font=function(n){this.base=o.Element.ElementBase;this.base(n);this.horizAdvX=this.attribute('horiz-adv-x').numValue();this.isRTL=false;this.isArabic=false;this.fontFace=null;this.missingGlyph=null;this.glyphs=[];for(var i=0;i<this.children.length;i++){var c=this.children[i];if(c.type=='font-face'){this.fontFace=c;if(c.style('font-family').hasValue()){o.Definitions[c.style('font-family').value]=this;}}else if(c.type=='missing-glyph')this.missingGlyph=c;else if(c.type=='glyph'){if(c.arabicForm!=''){this.isRTL=true;this.isArabic=true;if(typeof(this.glyphs[c.unicode])=='undefined')this.glyphs[c.unicode]=[];this.glyphs[c.unicode][c.arabicForm]=c;}else{this.glyphs[c.unicode]=c;}}}};o.Element.font.prototype=new o.Element.ElementBase;o.Element.fontface=function(n){this.base=o.Element.ElementBase;this.base(n);this.ascent=this.attribute('ascent').value;this.descent=this.attribute('descent').value;this.unitsPerEm=this.attribute('units-per-em').numValue();};o.Element.fontface.prototype=new o.Element.ElementBase;o.Element.missingglyph=function(n){this.base=o.Element.path;this.base(n);this.horizAdvX=0;};o.Element.missingglyph.prototype=new o.Element.path;o.Element.glyph=function(n){this.base=o.Element.path;this.base(n);this.horizAdvX=this.attribute('horiz-adv-x').numValue();this.unicode=this.attribute('unicode').value;this.arabicForm=this.attribute('arabic-form').value;};o.Element.glyph.prototype=new o.Element.path;o.Element.text=function(n){this.base=o.Element.RenderedElementBase;this.base(n);if(n!=null){this.children=[];for(var i=0;i<n.childNodes.length;i++){var c=n.childNodes[i];if(c.nodeType==1){this.addChild(c,true);}else if(c.nodeType==3){this.addChild(new o.Element.tspan(c),false);}}}this.baseSetContext=this.setContext;this.setContext=function(a){this.baseSetContext(a);if(this.style('dominant-baseline').hasValue())a.textBaseline=this.style('dominant-baseline').value;if(this.style('alignment-baseline').hasValue())a.textBaseline=this.style('alignment-baseline').value;};this.renderChildren=function(a){var t=this.style('text-anchor').valueOrDefault('start');var x=this.attribute('x').toPixels('x');var y=this.attribute('y').toPixels('y');for(var i=0;i<this.children.length;i++){var b=this.children[i];if(b.attribute('x').hasValue()){b.x=b.attribute('x').toPixels('x');}else{if(this.attribute('dx').hasValue())y+=this.attribute('dx').toPixels('x');if(b.attribute('dx').hasValue())x+=b.attribute('dx').toPixels('x');b.x=x;}var d=b.measureText(a);if(t!='start'&&(i==0||b.attribute('x').hasValue())){var g=d;for(var j=i+1;j<this.children.length;j++){var e=this.children[j];if(e.attribute('x').hasValue())break;g+=e.measureText(a);}b.x-=(t=='end'?g:g/2.0);}x=b.x+d;if(b.attribute('y').hasValue()){b.y=b.attribute('y').toPixels('y');}else{if(this.attribute('dy').hasValue())y+=this.attribute('dy').toPixels('y');if(b.attribute('dy').hasValue())y+=b.attribute('dy').toPixels('y');b.y=y;}y=b.y;b.render(a);}}};o.Element.text.prototype=new o.Element.RenderedElementBase;o.Element.TextElementBase=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.getGlyph=function(f,t,i){var c=t[i];var g=null;if(f.isArabic){var a='isolated';if((i==0||t[i-1]==' ')&&i<t.length-2&&t[i+1]!=' ')a='terminal';if(i>0&&t[i-1]!=' '&&i<t.length-2&&t[i+1]!=' ')a='medial';if(i>0&&t[i-1]!=' '&&(i==t.length-1||t[i+1]==' '))a='initial';if(typeof(f.glyphs[c])!='undefined'){g=f.glyphs[c][a];if(g==null&&f.glyphs[c].type=='glyph')g=f.glyphs[c];}}else{g=f.glyphs[c];}if(g==null)g=f.missingGlyph;return g;};this.renderChildren=function(c){var a=this.parent.style('font-family').getDefinition();if(a!=null){var f=this.parent.style('font-size').numValueOrDefault(o.Font.Parse(o.ctx.font).fontSize);var b=this.parent.style('font-style').valueOrDefault(o.Font.Parse(o.ctx.font).fontStyle);var t=this.getText();if(a.isRTL)t=t.split("").reverse().join("");var d=o.ToNumberArray(this.parent.attribute('dx').value);for(var i=0;i<t.length;i++){var g=this.getGlyph(a,t,i);var s=f/a.fontFace.unitsPerEm;c.translate(this.x,this.y);c.scale(s,-s);var l=c.lineWidth;c.lineWidth=c.lineWidth*a.fontFace.unitsPerEm/f;if(b=='italic')c.transform(1,0,.4,1,0,0);g.render(c);if(b=='italic')c.transform(1,0,-.4,1,0,0);c.lineWidth=l;c.scale(1/s,-1/s);c.translate(-this.x,-this.y);this.x+=f*(g.horizAdvX||a.horizAdvX)/a.fontFace.unitsPerEm;if(typeof(d[i])!='undefined'&&!isNaN(d[i])){this.x+=d[i];}}return;}if(c.strokeStyle!='')c.strokeText(o.compressSpaces(this.getText()),this.x,this.y);if(c.fillStyle!='')c.fillText(o.compressSpaces(this.getText()),this.x,this.y);};this.getText=function(){};this.measureText=function(c){var a=this.parent.style('font-family').getDefinition();if(a!=null){var f=this.parent.style('font-size').numValueOrDefault(o.Font.Parse(o.ctx.font).fontSize);var m=0;var t=this.getText();if(a.isRTL)t=t.split("").reverse().join("");var d=o.ToNumberArray(this.parent.attribute('dx').value);for(var i=0;i<t.length;i++){var g=this.getGlyph(a,t,i);m+=(g.horizAdvX||a.horizAdvX)*f/a.fontFace.unitsPerEm;if(typeof(d[i])!='undefined'&&!isNaN(d[i])){m+=d[i];}}return m;}var b=o.compressSpaces(this.getText());if(!c.measureText)return b.length*10;c.save();this.setContext(c);var w=c.measureText(b).width;c.restore();return w;}};o.Element.TextElementBase.prototype=new o.Element.RenderedElementBase;o.Element.tspan=function(n){this.base=o.Element.TextElementBase;this.base(n);this.text=n.nodeType==3?n.nodeValue:n.childNodes.length>0?n.childNodes[0].nodeValue:n.text;this.getText=function(){return this.text;}};o.Element.tspan.prototype=new o.Element.TextElementBase;o.Element.tref=function(n){this.base=o.Element.TextElementBase;this.base(n);this.getText=function(){var e=this.attribute('xlink:href').getDefinition();if(e!=null)return e.children[0].getText();}};o.Element.tref.prototype=new o.Element.TextElementBase;o.Element.a=function(n){this.base=o.Element.TextElementBase;this.base(n);this.hasText=true;for(var i=0;i<n.childNodes.length;i++){if(n.childNodes[i].nodeType!=3)this.hasText=false;}this.text=this.hasText?n.childNodes[0].nodeValue:'';this.getText=function(){return this.text;};this.baseRenderChildren=this.renderChildren;this.renderChildren=function(c){if(this.hasText){this.baseRenderChildren(c);var f=new o.Property('fontSize',o.Font.Parse(o.ctx.font).fontSize);o.Mouse.checkBoundingBox(this,new o.BoundingBox(this.x,this.y-f.toPixels('y'),this.x+this.measureText(c),this.y));}else{var g=new o.Element.g();g.children=this.children;g.parent=this;g.render(c);}};this.onclick=function(){var w="noopener,noreferrer";var u=window.navigator.userAgent;if(/MSIE|Trident|Edge/.test(u)){var N=window.open("about:blank",undefined,w);if(N){N.opener=null;N.location.href=this.attribute('xlink:href').value;}}else{window.open(this.attribute('xlink:href').value,undefined,w);}};this.onmousemove=function(){o.ctx.canvas.style.cursor='pointer';}};o.Element.a.prototype=new o.Element.TextElementBase;o.Element.image=function(n){this.base=o.Element.RenderedElementBase;this.base(n);var a=this.attribute('xlink:href').value;var b=a.match(/\.svg$/);o.Images.push(this);this.loaded=false;if(!b){this.img=document.createElement('img');var s=this;this.img.onload=function(){s.loaded=true;};this.img.onerror=function(){if(console)console.log('ERROR: image "'+a+'" not found');s.loaded=true;};this.img.src=a;}else{this.img=o.ajax(a);this.loaded=true;}this.renderChildren=function(c){var x=this.attribute('x').toPixels('x');var y=this.attribute('y').toPixels('y');var w=this.attribute('width').toPixels('x');var d=this.attribute('height').toPixels('y');if(w==0||d==0)return;c.save();if(b){c.drawSvg(this.img,x,y,w,d);}else{c.translate(x,y);o.AspectRatio(c,this.attribute('preserveAspectRatio').value,w,this.img.width,d,this.img.height,0,0);c.drawImage(this.img,0,0);}c.restore();}};o.Element.image.prototype=new o.Element.RenderedElementBase;o.Element.g=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.getBoundingBox=function(){var b=new o.BoundingBox();for(var i=0;i<this.children.length;i++){b.addBoundingBox(this.children[i].getBoundingBox());}return b;};};o.Element.g.prototype=new o.Element.RenderedElementBase;o.Element.symbol=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.baseSetContext=this.setContext;this.setContext=function(c){this.baseSetContext(c);if(this.attribute('viewBox').hasValue()){var v=o.ToNumberArray(this.attribute('viewBox').value);var m=v[0];var a=v[1];width=v[2];height=v[3];o.AspectRatio(c,this.attribute('preserveAspectRatio').value,this.attribute('width').toPixels('x'),width,this.attribute('height').toPixels('y'),height,m,a);o.ViewPort.SetCurrent(v[2],v[3]);}}};o.Element.symbol.prototype=new o.Element.RenderedElementBase;o.Element.style=function(n){this.base=o.Element.ElementBase;this.base(n);var c=n.childNodes[0].nodeValue+(n.childNodes.length>1?n.childNodes[1].nodeValue:'');c=c.replace(/(\/\*([^*]|[\r\n]|(\*+([^*\/]|[\r\n])))*\*+\/)|(^[\s]*\/\/.*)/gm,'');c=o.compressSpaces(c);var a=c.split('}');for(var i=0;i<a.length;i++){if(o.trim(a[i])!=''){var b=a[i].split('{');var d=b[0].split(',');var e=b[1].split(';');for(var j=0;j<d.length;j++){var g=o.trim(d[j]);if(g!=''){var p={};for(var k=0;k<e.length;k++){var l=e[k].indexOf(':');var m=e[k].substr(0,l);var v=e[k].substr(l+1,e[k].length-l);if(m!=null&&v!=null){p[o.trim(m)]=new o.Property(o.trim(m),o.trim(v));}}o.Styles[g]=p;if(g=='@font-face'){var q=p['font-family'].value.replace(/"/g,'');var r=p['src'].value.split(',');for(var s=0;s<r.length;s++){if(r[s].indexOf('format("svg")')>0){var u=r[s].indexOf('url');var t=r[s].indexOf(')',u);var w=r[s].substr(u+5,t-u-6);var x=o.parseXml(o.ajax(w));var y=x.getElementsByTagName('font');for(var f=0;f<y.length;f++){var z=o.CreateElement(y[f]);o.Definitions[q]=z;}}}}}}}}};o.Element.style.prototype=new o.Element.ElementBase;o.Element.use=function(n){this.base=o.Element.RenderedElementBase;this.base(n);this.baseSetContext=this.setContext;this.setContext=function(c){this.baseSetContext(c);if(this.attribute('x').hasValue())c.translate(this.attribute('x').toPixels('x'),0);if(this.attribute('y').hasValue())c.translate(0,this.attribute('y').toPixels('y'));};this.getDefinition=function(){var e=this.attribute('xlink:href').getDefinition();if(this.attribute('width').hasValue())e.attribute('width',true).value=this.attribute('width').value;if(this.attribute('height').hasValue())e.attribute('height',true).value=this.attribute('height').value;return e;};this.path=function(c){var e=this.getDefinition();if(e!=null)e.path(c);};this.renderChildren=function(c){var e=this.getDefinition();if(e!=null){var a=e.parent;e.parent=null;e.render(c);e.parent=a;}}};o.Element.use.prototype=new o.Element.RenderedElementBase;o.Element.mask=function(n){this.base=o.Element.ElementBase;this.base(n);this.apply=function(a,e){var x=this.attribute('x').toPixels('x');var y=this.attribute('y').toPixels('y');var w=this.attribute('width').toPixels('x');var b=this.attribute('height').toPixels('y');var m=e.attribute('mask').value;e.attribute('mask').value='';var d=document.createElement('canvas');d.width=x+w;d.height=y+b;var f=d.getContext('2d');this.renderChildren(f);var c=document.createElement('canvas');c.width=x+w;c.height=y+b;var t=c.getContext('2d');e.render(t);t.globalCompositeOperation='destination-in';t.fillStyle=f.createPattern(d,'no-repeat');t.fillRect(0,0,x+w,y+b);a.fillStyle=t.createPattern(c,'no-repeat');a.fillRect(0,0,x+w,y+b);e.attribute('mask').value=m;};this.render=function(c){}};o.Element.mask.prototype=new o.Element.ElementBase;o.Element.clipPath=function(n){this.base=o.Element.ElementBase;this.base(n);this.apply=function(c){for(var i=0;i<this.children.length;i++){if(this.children[i].path){this.children[i].path(c);c.clip();}}};this.render=function(c){}};o.Element.clipPath.prototype=new o.Element.ElementBase;o.Element.filter=function(n){this.base=o.Element.ElementBase;this.base(n);this.apply=function(a,e){var b=e.getBoundingBox();var x=this.attribute('x').toPixels('x');var y=this.attribute('y').toPixels('y');if(x==0||y==0){x=b.x1;y=b.y1;}var w=this.attribute('width').toPixels('x');var d=this.attribute('height').toPixels('y');if(w==0||d==0){w=b.width();d=b.height();}var f=e.style('filter').value;e.style('filter').value='';var g=.20;var p=g*w;var j=g*d;var c=document.createElement('canvas');c.width=w+2*p;c.height=d+2*j;var t=c.getContext('2d');t.translate(-x+p,-y+j);e.render(t);for(var i=0;i<this.children.length;i++){this.children[i].apply(t,0,0,w+2*p,d+2*j);}a.drawImage(c,0,0,w+2*p,d+2*j,x-p,y-j,w+2*p,d+2*j);e.style('filter',true).value=f;};this.render=function(c){}};o.Element.filter.prototype=new o.Element.ElementBase;o.Element.feGaussianBlur=function(n){this.base=o.Element.ElementBase;this.base(n);function m(s){s=Math.max(s,0.01);var l=Math.ceil(s*4.0)+1;mask=[];for(var i=0;i<l;i++){mask[i]=Math.exp(-0.5*(i/s)*(i/s));}return mask;}function b(a){var s=0;for(var i=1;i<a.length;i++){s+=Math.abs(a[i]);}s=2*s+Math.abs(a[0]);for(var i=0;i<a.length;i++){a[i]/=s;}return a;}function c(s,g,j,w,k){for(var y=0;y<k;y++){for(var x=0;x<w;x++){var a=d(s,x,y,w,k,3)/255;for(var r=0;r<4;r++){var l=j[0]*(a==0?255:d(s,x,y,w,k,r))*(a==0||r==3?1:a);for(var i=1;i<j.length;i++){var p=d(s,Math.max(x-i,0),y,w,k,3)/255;var q=d(s,Math.min(x+i,w-1),y,w,k,3)/255;l+=j[i]*((p==0?255:d(s,Math.max(x-i,0),y,w,k,r))*(p==0||r==3?1:p)+(q==0?255:d(s,Math.min(x+i,w-1),y,w,k,r))*(q==0||r==3?1:q));}e(g,y,x,k,w,r,l);}}}}function d(a,x,y,w,g,r){return a[y*w*4+x*4+r];}function e(a,x,y,w,g,r,v){a[y*w*4+x*4+r]=v;}function f(a,w,g,s){var j=a.getImageData(0,0,w,g);var k=m(s);k=b(k);tmp=[];c(j.data,tmp,k,w,g);c(tmp,j.data,k,g,w);a.clearRect(0,0,w,g);a.putImageData(j,0,0);}this.apply=function(a,x,y,w,g){f(a,w,g,this.attribute('stdDeviation').numValue());}};o.Element.filter.prototype=new o.Element.feGaussianBlur;o.Element.title=function(n){};o.Element.title.prototype=new o.Element.ElementBase;o.Element.desc=function(n){};o.Element.desc.prototype=new o.Element.ElementBase;o.Element.MISSING=function(n){if(console)console.log('ERROR: Element \''+n.nodeName+'\' not yet implemented.');};o.Element.MISSING.prototype=new o.Element.ElementBase;o.CreateElement=function(n){var c=n.nodeName.replace(/^[^:]+:/,'');c=c.replace(/\-/g,'');var e=null;if(typeof(o.Element[c])!='undefined'){e=new o.Element[c](n);}else{e=new o.Element.MISSING(n);}e.type=n.nodeName;return e;};o.load=function(c,u){o.loadXml(c,o.ajax(u));};o.loadXml=function(c,x){o.loadXmlDoc(c,o.parseXml(x));};o.loadXmlDoc=function(c,d){o.init(c);var m=function(p){var e=c.canvas;while(e){p.x-=e.offsetLeft;p.y-=e.offsetTop;e=e.offsetParent;}if(window.scrollX)p.x+=window.scrollX;if(window.scrollY)p.y+=window.scrollY;return p;};if(o.opts['ignoreMouse']!=true){c.canvas.onclick=function(e){var p=m(new o.Point(e!=null?e.clientX:event.clientX,e!=null?e.clientY:event.clientY));o.Mouse.onclick(p.x,p.y);};c.canvas.onmousemove=function(e){var p=m(new o.Point(e!=null?e.clientX:event.clientX,e!=null?e.clientY:event.clientY));o.Mouse.onmousemove(p.x,p.y);};}var e=o.CreateElement(d.documentElement);e.root=true;var a=true;var b=function(){o.ViewPort.Clear();if(c.canvas.parentNode)o.ViewPort.SetCurrent(c.canvas.parentNode.clientWidth,c.canvas.parentNode.clientHeight);if(o.opts['ignoreDimensions']!=true){if(e.style('width').hasValue()){c.canvas.width=e.style('width').toPixels('x');c.canvas.style.width=c.canvas.width+'px';}if(e.style('height').hasValue()){c.canvas.height=e.style('height').toPixels('y');c.canvas.style.height=c.canvas.height+'px';}}var f=c.canvas.clientWidth||c.canvas.width;var g=c.canvas.clientHeight||c.canvas.height;if(o.opts['ignoreDimensions']==true&&e.style('width').hasValue()&&e.style('height').hasValue()){f=e.style('width').toPixels('x');g=e.style('height').toPixels('y');}o.ViewPort.SetCurrent(f,g);if(o.opts['offsetX']!=null)e.attribute('x',true).value=o.opts['offsetX'];if(o.opts['offsetY']!=null)e.attribute('y',true).value=o.opts['offsetY'];if(o.opts['scaleWidth']!=null&&o.opts['scaleHeight']!=null){var x=1,y=1,v=o.ToNumberArray(e.attribute('viewBox').value);if(e.attribute('width').hasValue())x=e.attribute('width').toPixels('x')/o.opts['scaleWidth'];else if(!isNaN(v[2]))x=v[2]/o.opts['scaleWidth'];if(e.attribute('height').hasValue())y=e.attribute('height').toPixels('y')/o.opts['scaleHeight'];else if(!isNaN(v[3]))y=v[3]/o.opts['scaleHeight'];e.attribute('width',true).value=o.opts['scaleWidth'];e.attribute('height',true).value=o.opts['scaleHeight'];e.attribute('viewBox',true).value='0 0 '+(f*x)+' '+(g*y);e.attribute('preserveAspectRatio',true).value='none';}if(o.opts['ignoreClear']!=true){c.clearRect(0,0,f,g);}e.render(c);if(a){a=false;if(typeof(o.opts['renderCallback'])=='function')o.opts['renderCallback']();}};var w=true;if(o.ImagesLoaded()){w=false;b();}o.intervalID=setInterval(function(){var n=false;if(w&&o.ImagesLoaded()){w=false;n=true;}if(o.opts['ignoreMouse']!=true){n=n|o.Mouse.hasEvents();}if(o.opts['ignoreAnimation']!=true){for(var i=0;i<o.Animations.length;i++){n=n|o.Animations[i].update(1000/o.FRAMERATE);}}if(typeof(o.opts['forceRedraw'])=='function'){if(o.opts['forceRedraw']()==true)n=true;}if(n){b();o.Mouse.runEvents();}},1000/o.FRAMERATE);};o.stop=function(){if(o.intervalID){clearInterval(o.intervalID);}};o.Mouse=new(function(){this.events=[];this.hasEvents=function(){return this.events.length!=0;};this.onclick=function(x,y){this.events.push({type:'onclick',x:x,y:y,run:function(e){if(e.onclick)e.onclick();}});};this.onmousemove=function(x,y){this.events.push({type:'onmousemove',x:x,y:y,run:function(e){if(e.onmousemove)e.onmousemove();}});};this.eventElements=[];this.checkPath=function(a,c){for(var i=0;i<this.events.length;i++){var e=this.events[i];if(c.isPointInPath&&c.isPointInPath(e.x,e.y))this.eventElements[i]=a;}};this.checkBoundingBox=function(a,b){for(var i=0;i<this.events.length;i++){var e=this.events[i];if(b.isPointInBox(e.x,e.y))this.eventElements[i]=a;}};this.runEvents=function(){o.ctx.canvas.style.cursor='';for(var i=0;i<this.events.length;i++){var e=this.events[i];var a=this.eventElements[i];while(a){e.run(a);a=a.parent;}}this.events=[];this.eventElements=[];}});return o;}})();if(CanvasRenderingContext2D){CanvasRenderingContext2D.prototype.drawSvg=function(s,d,a,b,c){canvg(this.canvas,s,{ignoreMouse:true,ignoreAnimation:true,ignoreDimensions:true,ignoreClear:true,offsetX:d,offsetY:a,scaleWidth:b,scaleHeight:c});}}
