jQuery.sap.declare("utils.Formatter");

utils.Formatter = {
    nameFormatter: function (sProcessName, sSubProcessName, sStepName) {
        if (sStepName) {
            return sStepName;
        } else if (sSubProcessName) {
            return sSubProcessName;
        } else if (sProcessName) {
            return sProcessName;
        }

        return "";
    },
    typeFormatter: function (sProcessType, sSubProcessType, sStepType) {
        if (sStepType) {
            return sStepType;
        } else if (sSubProcessType) {
            return sSubProcessType;
        } else if (sProcessType) {
            return sProcessType;
        }

        return "";
    },
    tmStpFormatter: function (tmStp) {
        if (tmStp) return tmStp.substr(0, 10) + " " + tmStp.substr(11);
    },
    sizeFormatter: function (size) {
        if (size != null) return size + " Bytes";
    },
    checkboxEnabled: function (enabled) {
        if (enabled != null) return Boolean(enabled !== "0");
		return false;
    },
    numFormatter: function (number) {
        if (number === -1) {
            return "N/A";
        } else {
            return number;
        }
    },
    yesFormatter: function (sFeedback) {
        if (sFeedback) {
            return "sap-icon://accept";
        }

        return "";
    },
    yesNoNAFormatter: function (sFeedback) {
        switch (sFeedback) {
            case 0:
                return "No";
            case 1:
                return "Yes";
            default:
                return "N/A";
        }
    },
    yesNoNAFIconFormatter: function (sFeedback) {
        switch (sFeedback) {
            case "RED"	:
                return "sap-icon://error";
            case "GREEN":
                return "sap-icon://accept";
            default		:
                return sFeedback;
        }
    },
    taskIconFormatter: function (taskType) {
        var imgSrc = gSUMGlobals.pathsTaskImages;
        switch (taskType) {
            case "slp.task.type.PROCESS":
                imgSrc = imgSrc + "/process.png";
                break;
            case "slp.task.type.STEP":
                imgSrc = imgSrc + "/step.png";
                break;
            case "slp.task.type.ROADMAP.TECH":
                imgSrc = imgSrc + "/roadmaptech.png";
                break;
            case "slp.task.type.ROADMAP.USER":
                imgSrc = imgSrc + "/roadmapuser.png";
                break;
            case "slp.task.type.TASK":
                imgSrc = imgSrc + "/task.png";
                break;
            case "slp.task.type.SERVICE":
                imgSrc = imgSrc + "/service.png";
                break;
            default:
                imgSrc = imgSrc + "/step.png";
                break;
        }
        return imgSrc;
    },
    taskIconTtipFormatter: function (taskType) {
        var ttip;
        switch (taskType) {
            case "slp.task.type.PROCESS":
                ttip = "Process";
                break;
            case "slp.task.type.STEP":
                ttip = "Task Step";
                break;
            case "slp.task.type.ROADMAP.TECH":
                ttip = "Technical Roadmap";
                break;
            case "slp.task.type.ROADMAP.USER":
                ttip = "User Roadmap";
                break;
            case "slp.task.type.TASK":
                ttip = "Task";
                break;
            case "slp.task.type.SERVICE":
                ttip = "Service";
                break;
            default:
                ttip = "";
                break;
        }
        return ttip;
    },
    taskTypeIconFormatter: function (taskType) {
        var iconSrc = "sap-icon://";
        switch (taskType) {
            case "slp.task.state.ABORTED":
                iconSrc = iconSrc + "sys-cancel";
                break;
            case "slp.task.state.FINISHED":
                iconSrc = iconSrc + "status-completed";
                break;
            case "slp.task.state.SKIPPED":
                iconSrc = iconSrc + "overlay";
                break;
            case "slp.task.state.ERROR":
                iconSrc = iconSrc + "message-error";
                break;
            case "slp.task.state.RUNNING":
                iconSrc = iconSrc + "media-play";
                break;
            case "slp.task.state.DIALOG":
                iconSrc = iconSrc + "status-inactive";
                break;
            case "slp.task.state.ACTION_REQUIRED":
                iconSrc = iconSrc + "to-be-reviewed";
                break;
            case "slp.task.state.BREAKPOINT":
                iconSrc = iconSrc + "navigation-right-arrow";
                break;
            case "slp.task.state.INITIAL":
                iconSrc = iconSrc + "status-negative";
                break;
            case "slp.task.state.UNKNOWN":
                iconSrc = iconSrc + "refresh";
                break;
            default:
                iconSrc = iconSrc + "status-negative";
                break;
        }
        return iconSrc;
    },
    taskTypeIconColorFormatter: function (taskType) {
        var iconColor = "#000000";
    	var _b = (document.URL.indexOf("suihcb=true")>0);
    	var _w = (document.URL.indexOf("suihcw=true")>0);
        switch (taskType) {
            case "slp.task.state.ABORTED":
                iconColor = _b ? "#ff6666" : _w ? "#800000" : "#cc0000";
                break;
            case "slp.task.state.FINISHED":
                iconColor = _b ? "#66ff66" : _w ? "#006600" : "#008b00";
                break;
            case "slp.task.state.SKIPPED":
                iconColor = _b ? "#b3e4ff" : _w ? "#006399" : "#007dc0";
                break;
            case "slp.task.state.ERROR":
                iconColor = _b ? "#ff6666" : _w ? "#800000" : "#cc0000";
                break;
            case "slp.task.state.RUNNING":
                iconColor = _b ? "#b3e4ff" : _w ? "#006399" : "#007dc0";
                break;
            case "slp.task.state.DIALOG":
                iconColor = _b ? "#fee79a" : _w ? "#7e6101" : "#fdc411";
                break;
            case "slp.task.state.ACTION_REQUIRED":
                iconColor = _b ? "#b3e4ff" : _w ? "#006399" : "#007dc0";
                break;
            case "slp.task.state.BREAKPOINT":
                iconColor = _b ? "#fee79a" : _w ? "#7e6101" : "#fdc411";
                break;
            case "slp.task.state.INITIAL":
                iconColor = _b ? "#d9d9d9" : _w ? "#4d4d4d" : "#8F8F8F";
                break;
            case "slp.task.state.UNKNOWN":
                iconColor = _b ? "#cae8ca" : _w ? "#2f6a2f" : "#70c070";
                break;
            default:
                iconColor = _b ? "#d9d9d9" : _w ? "#4d4d4d" : "#8F8F8F";
                break;
        } 
        return iconColor;
    },
    taskTypeIconTtipFormatter: function (taskType) {
        var ttip;
        switch (taskType) {
            case "slp.task.state.ABORTED":
                ttip = "Aborted";
                break;
            case "slp.task.state.FINISHED":
                ttip = "Finished";
                break;
            case "slp.task.state.SKIPPED":
                ttip = "Skipped";
                break;
            case "slp.task.state.ERROR":
                ttip = "Error";
                break;
            case "slp.task.state.RUNNING":
                ttip = "Running";
                break;
            case "slp.task.state.DIALOG":
                ttip = "Waiting for User Input";
                break;
            case "slp.task.state.ACTION_REQUIRED":
                ttip = "Action Required";
                break;
            case "slp.task.state.BREAKPOINT":
                ttip = "Breakpoint";
                break;
            case "slp.task.state.INITIAL":
                ttip = "Initial";
                break;
            case "slp.task.state.UNKNOWN":
                ttip = "Unknown";
                break;
            default:
                ttip = "";
                break;
        }
        return ttip;
    },
    monitorStatusFormatter: function(monitorState) {
        var valueState = sap.ui.core.ValueState.None;
        switch (monitorState) {
            case "slp.task.state.ABORTED":
            case "slp.task.state.ERROR":
                valueState = sap.ui.core.ValueState.Error;
                break;
            case "slp.task.state.DIALOG":
                valueState = sap.ui.core.ValueState.Warning;
                break;
            case "slp.task.state.RUNNING":
            case "slp.task.state.FINISHED":
            case "slp.task.state.INITIAL":
                valueState = sap.ui.core.ValueState.Success;
                break;
        }
        return valueState;
    },
    monitorStatusTtipFormatter: function(monitorState, estimate, left) {
        var ttip = "";
        switch (monitorState) {
            case "slp.task.state.ABORTED":
                ttip = "Process has aborted";
                break;
            case "slp.task.state.FINISHED":
                ttip = "Process has finished";
                break;
            case "slp.task.state.ERROR":
                ttip = "Process stopped with error";
                break;
            case "slp.task.state.RUNNING":
                ttip = "Process is running";
                break;
            case "slp.task.state.DIALOG":
                ttip = "Process is in a dialog";
                break;
            case "slp.task.state.INITIAL":
                ttip = "Process is initial";
                break;
            case "slp.task.state.ACTION_REQUIRED":
                ttip = "Process stopped with 'action required'";
                break;
            case "slp.task.state.BREAKPOINT":
                ttip = "Process reached breakpoint";
                break;
            default:     
                ttip = "Process is in an unknown state";
            	break;
        }
        return ttip + (left && (left !== "") ? "\nEstimated remaining runtime: " + left + ((left.length > 5) ? " [hh:mm:ss]" : " [mm:ss]") : "") + (estimate && (estimate !== "") ? "\nETA: " + estimate : "");
    },
    monitorProgressFormatter: function(progress, state) {
    	return progress + "% - " + utils.Formatter.monitorStatusTtipFormatter(state, "", "");
    },
    
    generateStatusIcon: function (bpStatus) {
        var iconSrc = "sap-icon://";
        switch (bpStatus) {
            case "slp.breakpoint.status.AT":
                iconSrc = iconSrc + "present";
                break;
            case "slp.breakpoint.status.AFTER":
                iconSrc = iconSrc + "past";
                break;
            case "slp.breakpoint.status.BEFORE":
                iconSrc = iconSrc + "future";
                break;
            default:
                iconSrc = iconSrc + "past";
                break;
        }
        return iconSrc;
    },
    generateStatusColor: function (bpStatus) {
    	var color;
    	var _b = (document.URL.indexOf("suihcb=true")>0);
    	var _w = (document.URL.indexOf("suihcw=true")>0);
    	switch (bpStatus) {
	        case "slp.breakpoint.status.AT":
	            color = _b ? "#fee181" : _w ? "#977402" : "#fdc411"; // like (old) @sapUiCriticalElement
	            break;
	        case "slp.breakpoint.status.AFTER":
	            color = _b ? "#b3ffc4" : _w ? "#00801e" : "#009823"; // like @sapUiPositiveElement but more green
	            break;
	        case "slp.breakpoint.status.BEFORE":
	            color = _b ? "#b3d5ff" : _w ? "#002e66" : "#005cd0"; // like @sapUiNeutralElement but more blue
	            break;
	        default:
	            color = _b ? "#66c9ff" : _w ? "#005380" : "#007cc0"; // @sapUiNeutralElement;
	            break;
    	}
        return color;
    },
    generateStatusTtip: function (bpStatus) {
    	var ttip;
        switch (bpStatus) {
            case "slp.breakpoint.status.AT":
                ttip = "Breakpoint is at the current step";
                break;
            case "slp.breakpoint.status.AFTER":
                ttip = "Breakpoint has already been passed";
                break;
            case "slp.breakpoint.status.BEFORE":
                ttip = "Breakpoint has not yet been reached";
                break;
            default:
                ttip = "";
                break;
        }
        return ttip;
    },
    
    getCheckboxStatusTrueFalse: function (trueFalseInt) {
        var trueFalseBoolean = new sap.ui.model.type.Boolean();
        switch (trueFalseInt) {
            case "1":
                trueFalseBoolean=true;
                break;
            case "0":
                trueFalseBoolean=false;
                break;
            default:
                trueFalseBoolean=false;
                break;
        }
        return trueFalseBoolean;
    }
};