jQuery.sap.require("jquery.sap.resources");
jQuery.sap.require("sap.ui.core.IconPool");
jQuery.sap.require("sap.m.Popover");
jQuery.sap.require("sap.m.MessageListItem");
jQuery.sap.require("sap.m.ListItemBase");
jQuery.sap.require("sap.m.MessageView");

var Globals = function(){
        
        /*** Path parameters ************************************************************************************/
		this.urlEndPoint	= "/slui";
        this.fullUrl        = document.location.href;
        var tempUrl         = this.fullUrl;
        this.sumProtocol    = this.fullUrl.substring(0, this.fullUrl.indexOf("://") + 3);
        tempUrl             = tempUrl.substring(tempUrl.indexOf(this.sumProtocol) + this.sumProtocol.length);

        if (tempUrl.indexOf(":") > 0) {
        	this.clientHost     = tempUrl.substring(0, tempUrl.indexOf(":"), 4);
        	this.sumPort        = tempUrl.substring(tempUrl.indexOf(":") + 1, tempUrl.indexOf(":")+5);
        }else{ //k8s
        	this.clientHost     = tempUrl.substring(0, tempUrl.indexOf("/"), 4);
        	this.sumPort        = "";
        }
        
        this.pathBase       = this.sumProtocol + this.clientHost;
        if (tempUrl.indexOf(":") > 0) {
        	this.pathBase   = this.pathBase + ":" + this.sumPort;
        }    
		this.sid            = tempUrl.substring(tempUrl.indexOf(this.urlEndPoint)-3, tempUrl.indexOf(this.urlEndPoint));
        this.tooltype       = tempUrl.substring(tempUrl.indexOf("/lmsl")+6, tempUrl.indexOf("/" + this.sid + "/"));
    
        this.sumUiUrlExt    = tempUrl.substring(tempUrl.indexOf("/lmsl"));
        this.sumAbapUrl     = this.pathBase + this.sumUiUrlExt;
        this.pathSlpJava    = "";
        this.pathSlpAbap    = this.pathBase + "/slp/" + this.tooltype + "/" + this.sid;
        this.pathLmslAbap   = this.pathBase + "/lmsl/" + this.tooltype + "/" + this.sid;
        this.slpResBPs      = "breakpoints";
        this.tableLimit		= 10000;
        this.version 		= "";
        this.extVersion		= "";

        
        this.pathsTaskImages = "resources/img/tasktype";
        
        this.popupError = function(message) {
        	alert(message);	//eslint-disable-line
			gSUMGlobals.busy = false;
//			console.log("busy = false\n");
        };
        this.genericError = function(xhr, status) {
        	if (xhr) {
        		if ((xhr.status == 0) && !xhr.responseText) xhr.responseText = "No response from server.";
        		gSUMGlobals.popupError('Cannot load Resource from URL: '+xhr.status+'\n\n'+xhr.responseText);
        	}
        	else gSUMGlobals.popupError("General Failure - please retry (press F5) or inform SAP Support if this error persists!");
        };
        
		/*** check for valid url **********************************************************************************/
		this.blacklisted = blacklistedXSS();
		this.whitelisted = whitelistedXSS();
		try {
			if (this.blacklisted || !this.whitelisted) throw "@ERROR: Not a valid URL!";
		} catch(e) {
			this.popupError(e);
		}
		
		/*** switch user theme if selected ****************************************************/
		if ($(location).attr('href').indexOf("suihcb=true") > -1) sap.ui.getCore().applyTheme("sap_belize_hcb");
		else if ($(location).attr('href').indexOf("suihcw=true") > -1) sap.ui.getCore().applyTheme("sap_belize_hcw");
		else if ($(location).attr('href').indexOf("suiplus=true") > -1) sap.ui.getCore().applyTheme("sap_belize_plus");
    
        /*** Menu/Buttons vars ************************************************************************************/
        this.activeMenuItem = "";    
        
        /*** config resource **************************************************************************************/
        this.diaParamMap = [];
        this.osDirSeparator = "/";

        /*** text resource ****************************************************************************************/
		//var localLang = sap.ui.getCore().getConfiguration().getLanguage();
		//this.oBundle = jQuery.sap.resources({url: "slui/resources/uitext/slui.properties", locale: localLang});
		//this.oBundle = jQuery.sap.resources({url: "../resources/uitext/slui.properties", locale: localLang});
				
		this.oSLPAPI = {};	//SLP interface - once it is instantiated
		this.oLMSLAPI = {};	//LMSL interface - once it is instantiated
		this.guideInfo = {db: "HDB", opt: "std", loio: "", section: ""};
		document.title = this.sid+": "+document.title;

		this.mdtArry = [];
		this.optOut = [];
		if (document.cookie) {
			var cookies = document.cookie.split(';');
			cookies.forEach(function(cookie) {
				if (cookie.substr(0, 1) == ' ') cookie = cookie.substr(1);
				if (cookie.substring(0, 6) == "optout") this.optOut = cookie.substring(cookie.indexOf("=") + 1, cookie.length).split(',');
				if (cookie.substring(0, 6) == "cookie") this.cookies = true;
				if ((cookie.substring(0, 3) == "sui") && (document.URL.indexOf(cookie) == -1)) {
					var ind = document.URL.indexOf("?sui"), sep = "?";
					if (ind < 0) {ind = document.URL.indexOf("&sui"); if (document.URL.indexOf("?") > 0) sep = "&";}
					if (ind > 0) document.location.href = document.URL.slice(0, ind) + sep + cookie;
					else document.location.href = document.URL + sep + cookie;
				}
			}, this);
			if (!this.cookies) this.optOut = [];
		} 
		this.handleNext = function() {
			for (var i = 0; i < this.mdtArry.length; i++) {
				if (typeof this.mdtArry[i].fulfilled !== 'undefined' && !this.mdtArry[i].fulfilled) {
					this.nextButton.setEnabled(false); 
					return;
				}
			}
			this.nextButton.setEnabled(true);
		};
		this.handleMdt = function() {
			this.mdtArry = $(document.getElementsByClassName("sapMLabelRequired"));
			if (this.nextButton) this.nextButton.setEnabled(true);
			var evInp = function(a) {
				gSUMGlobals.mdtArry[a.data].fulfilled = (a.target.value !== ""); 
				if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
			};
			for (i = 0; i < this.mdtArry.length; i++) {
				var xx = this.mdtArry[i].getAttribute("for");
				if (xx) {
					var y = document.getElementById(xx);
					if (y) {
						this.mdtArry[i].inpId = xx;
						if (y.attributes.role && y.attributes.role.value === "checkbox")
							this.mdtArry[i].fulfilled = y.firstChild.firstChild.checked;
						else this.mdtArry[i].fulfilled = true;
						if (this.nextButton) this.handleNext();
					} else {						
						var yy = xx.search("--");
						if (yy == -1) this.popupError("ERROR: unexpected Situation (1) - Mandatory field "+xx+" not expected in function 'handleMdt'!");
						var x = xx.slice(yy+2);
						var z = findRecursiveItemMode(this.oFragment, x, 3);
						y = document.getElementById(z) || document.getElementById(z+"_1");
						if (y) {
							this.mdtArry[i].inpId = y.id;
							var z = document.getElementById(y.id+"-inner");
							var b = {}; b.data = i; b.target = z;
							evInp(b);
							$(y).on("input", i, evInp);
						} else {
							this.popupError("ERROR: unexpected Situation (2) - Mandatory field "+x+" not found in function 'handleMdt'!");
						}
					}
				} else if (this.mdtArry[i].attributes.role.value === "radiogroup") { // this is for RadioButtonGroups that have no default selection (DownConfBck)
						this.mdtArry[i].fulfilled = false;
						$(this.mdtArry[i].children).each($.proxy(function(a,b){if (b.firstChild.firstChild.getAttribute("aria-checked") == "true") this.fulfilled = true;}, this.mdtArry[i]));
						this.mdtArry[i].inpId = this.mdtArry[i].id;
						if (this.nextButton) this.handleNext();
				} else {
					this.popupError("ERROR: unexpected Situation (3) - Mandatory element "+ this.mdtArry[i].id +" not expected in function 'handleMdt'!");
				}
			} 
		};
};

var gSUMGlobals = new Globals();

//this is to extend the Array functionality by the .find() and the .findIndex() methods which might be missing in some browsers
if (typeof Array.prototype.find !== 'function') Array.prototype.find = function(funct) {
		var array = Object(this);
		for (var i = 0; i < array.length; i++) if (funct.call(arguments[1], array[i], i, array)) return array[i];
		return undefined;
};

if (typeof Array.prototype.findIndex !== 'function') Array.prototype.findIndex = function(funct) {
		var array = Object(this);
		for (var i = 0; i < array.length; i++) if (funct.call(arguments[1], array[i], i, array)) return i;
		return -1;
};

if (typeof Math.sign !== 'function') Math.sign = function(x){if (!x) return 0; return x > 0 ? 1 : -1;};
if (typeof Math.log10 !== 'function') Math.log10 = function(x) {return Math.log(x) * Math.LOG10E;};

/* change default popover resize handler from top right corner to bottom roght corner */
sap.m.Popover.prototype.onmousedown = function (oEvent) {
	var bRTL = sap.ui.getCore().getConfiguration().getRTL();
	if (!oEvent.target.classList.contains("sapMPopoverResizeHandle")) {
		return;
	}

	var $d = jQuery(document);
	var $popover = this.$();
	var that = this;
	$popover.addClass('sapMPopoverResizing');

	oEvent.preventDefault();
	oEvent.stopPropagation();

	var initial = {
		x: oEvent.pageX,
		y: oEvent.pageY,

		width: $popover.width(),
		height: $popover.height()
	};

	$d.on("mousemove.sapMPopover", function (e) {
		var width, height;

		if (bRTL) {
			width = initial.width + initial.x - e.pageX;
			height = initial.height + e.pageY - initial.y;
		} else {
			width = initial.width + e.pageX - initial.x;
			height = initial.height + e.pageY - initial.y;
		}

		that.setContentWidth(Math.max(width, that._minDimensions.width) + 'px');
		that.setContentHeight(Math.max(height, that._minDimensions.height) + 'px');
	});

	$d.on("mouseup.sapMPopover", function () {
		$popover.removeClass("sapMPopoverResizing");
		$d.off("mouseup.sapMPopover, mousemove.sapMPopover");
	});
};

/* modify the 'counter' attribute of sap.m.MessageListItem to be used for 'hide' feature */
sap.m.MessageListItem.prototype.onBeforeRendering = function () {
	sap.m.StandardListItem.prototype.onBeforeRendering.apply(this, arguments);
	
	if (gSUMGlobals.optOut.indexOf(this.getDescription()) != -1) this.setVisible(false);	//mod
//	if (this.getMessageType() == "Error") this.setCounter(0);								//mod
	
	var oLink = this.getLink(), oDescribedByText;

	if (!oLink) {
		return;
	}

	//prevent unneeded creation of sap.ui.core.InvisibleText
	if (!oLink.getAriaDescribedBy().length) {
		oDescribedByText = this._getLinkAriaDescribedBy();

		oLink.setProperty("text", this.getTitle(), true);
		oLink.addAssociation('ariaDescribedBy', oDescribedByText.getId(), true);

		this.setAggregation("linkAriaDescribedBy", oDescribedByText, true);
	}
};

sap.m.ListItemBase.prototype.init = function() {
	this._active = false;
	this._bGroupHeader = false;
	this._bNeedsHighlight = false;
	if (this.getMetadata()._sClassName == "sap.m.MessageListItem")							//mod
		this._hideBtn = new sap.m.Button({													//mod
				id: this.getId() + "-imgHide",												//mod
				icon: "sap-icon://hide",													//mod
				type: "Transparent",														//mod
				tooltip: "Hide this message"												//mod
			}).setParent(this, null, true).attachPress(function(oEvent) {					//mod
				sap.ui.getCore().byId("idRst").setVisible(true);							//mod
				gSUMGlobals.optOut.push(oEvent.getSource().getParent().getDescription());	//mod
				if (gSUMGlobals.cookies) {
					var expir = new Date((new Date()).getTime() + 1000 * 60 * 60 * 24 * 30);
					document.cookie = "optout=" + gSUMGlobals.optOut.toString() + "; expires=" + expir.toGMTString() + ";";
				}
				oEvent.getSource().getParent().invalidate();								//mod
			}, this).addStyleClass("sapUiSizeCompact");										//mod
};

sap.m.ListItemBase.prototype.getRenderer().renderCounterContent = function(rm, oLI, iCounter) {
	rm.write("<div");
	rm.writeAttribute("id", oLI.getId() + "-counter");
	var sAriaLabel = sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER", iCounter);
	rm.writeAttribute("aria-label", sAriaLabel);
	rm.addClass("sapMLIBCounter");
	rm.writeClasses();
	rm.write(">");
	if (oLI._hideBtn) rm.renderControl(oLI._hideBtn);										//mod
	else rm.write(iCounter);																//mod
	rm.write("</div>");
};

sap.m.StandardListItem.prototype.getRenderer().renderDescription = function(){};

/* this "if (oListItem.getVisible())" is necessary to avoid an exception in the browser console  */ 
sap.m.MessageView.prototype._restoreItemsType = function () {
	if (this._isListPage() && this.getItems().length) {
		var that = this;
		this._oLists[this._sCurrentList || 'all'].getItems().forEach(function (oListItem) {
			if (oListItem.getVisible()) that._setItemType(oListItem);						//mod
		});
	}
};
