var Grep = function(that) {
	this.timeoutID = false;
	this.view = that.getView();
	this.logPtn = "*";
	var fileflt = this.view.byId("idFileCol").getFilterValue();
	if (fileflt) this.logPtn = "*"+fileflt+"*";
	this.searchPtn = "";
	this.xhr = null;

	this._oModel = new sap.ui.model.json.JSONModel();
	this._oModel.setSizeLimit(gSUMGlobals.tableLimit);

	this.oGrepDialog = sap.ui.xmlfragment("SoftwareUpdateManager.view.Grep", this);
	this.view.addDependent(this.oGrepDialog);
	this.oGrepDialog.setModel(this._oModel, "grep");
	this.oGrepDialog.oPopup.setModal(false);
	this.oGrepDialog.getButtons().forEach(function(a){seleniumizeObj(a);});
	this.oGrepDialog.getSubHeader().getContent().forEach(function(a){if (a.data("sumid")) seleniumizeObj(a);});
	this.oGrepDialog.setTitle("Search Text in " + (fileflt ? "Filtered ("+this.logPtn+")" : "All") + " Log Files (case-insensitive)");
	this.oGrepDialog.attachBeforeClose($.proxy(function() {this.stopPoll();}, this));
	this.oGrepDialog.attachAfterClose($.proxy(function() {
		this.oGrepDialog.destroy();
		delete this.oGrepDialog;
	}, this));
	this.oGrepDialog.open();
};

function prefmt(sstr) {
	return "*"+sstr+"*"; // .replace(/\[/g,'\\[').replace(/\]/g,'\\]')+"*";
}

function doEval(e) {
	var srchp = e.getParameter("value");
	if (srchp.indexOf("[") + srchp.indexOf("]") === -2) {
		e.getSource().setValueState(sap.ui.core.ValueState.Success);
		e.getSource().getParent().getContent()[2].setEnabled(true);		// enable button
	} else {
		e.getSource().setValueState(sap.ui.core.ValueState.Error);
		e.getSource().getParent().getContent()[2].setEnabled(false);	// disable button
		sap.m.MessageToast.show("Search text must neither contain '[' nor ']'.", {duration: 3000});
	}
}

function doGrep(e) {
	if (e && (typeof e.getSource === "function") && (typeof e.getSource().getValueState === "function") && (e.getSource().getValueState() === "Error")) return;
	if (this.searchPtn) this.stopPoll();
	if (!(this.searchPtn = this.oGrepDialog.getSubHeader().getContent()[1].getValue())) return;
	this.oTree = this.oGrepDialog.getContent()[0].getItems()[0];
	this.oTree.collapseAll();
	this._oModel.setData({});
	this.oLabel = this.oGrepDialog.getContent()[0].getItems()[1];	
	this.oLabel.setText("");
	this.oTree.setShowNoData(true);
	this.oGrepDialog.getContent()[0].setBusy(true);
	
	// stop prior grep process, otherwise old results are shown
    gSUMGlobals.oLMSLAPI.postGrepStop(
   		$.proxy(function(result, sts, xhr) {
		    this.xhr = gSUMGlobals.oLMSLAPI.postGrepPoll(
				$.proxy(function(result, sts, xhr) {
					this.poll();
				}, this), 
				$.proxy(function(xhr, options, errorText) {
					this.xhr = null;
					this.oGrepDialog.getContent()[0].setBusy(false);
					this.oLabel.setText("Error: " + errorText);
				}, this), 
				this.logPtn, 
				prefmt(this.searchPtn),
				this
			);
		}, this), 
		$.proxy(function(xhr, options, errorText) {
			this.oLabel.setText("Error: " + errorText);
		}, this), 
    	this.logPtn, 
    	prefmt(this.searchPtn),
		this
    );
	this.xhr = null;
}

function _xml2json(xmlObj) {
	var retObj = {};
	// do attributes
	if (xmlObj.hasAttributes && xmlObj.hasAttributes()) {
		for (var i = 0; i < xmlObj.attributes.length; i++) {
			var attr = xmlObj.attributes[i];
			var nodeName = attr.name;
			retObj[nodeName] = attr.nodeValue;
		}
		retObj["out"] = (xmlObj.nodeName === "Log" ? xmlObj.attributes.name.value : (xmlObj.nodeName === "Line" ? "Line " + xmlObj.attributes.number.value + ": " + xmlObj.textContent: ""));
	}
	// do children
	if (xmlObj.hasChildNodes()) {
		for (var i = 0; i < xmlObj.childNodes.length; i++) {
			var item = xmlObj.childNodes.item(i);
			var nodeName = item.nodeName;
			if (typeof(retObj[nodeName]) === "undefined") retObj[nodeName] = _xml2json(item);
            else {
				if (typeof(retObj[nodeName].push) === "undefined") {
					var old = retObj[nodeName];
					retObj[nodeName] = [];
					retObj[nodeName].push(old);
				}
				retObj[nodeName].push(_xml2json(item));
			}
		}
	}
    else retObj = xmlObj.textContent; 
	return retObj;
}

function closeGrep() {
	this.oGrepDialog.close();
}

function onSelGrep(evt) {
	if (evt.getParameter("listItem").getLevel()){
		var it = evt.getParameter("listItem");
		var line = it.getBindingContext("grep").getObject().number;
		var nd = it.getParentNode();
		var file = nd.getTitle();
		var size = nd.getBindingContext("grep").getObject().size;
	//	var tr = it.getTree();
	//	var ord = tr.indexOfItem(it) - tr.indexOfItem(nd);	
		if (size > 1000000) {
			sap.m.MessageBox.confirm("The file " + file + " has a size of " + size + " Bytes.\n\nThis might result in a longer download time.\nDo you really want to display this file?", {
				title: "Display large log file",
				onClose: $.proxy(function(oAct){if (oAct === sap.m.MessageBox.Action.OK) this.view.getController().showLogWindow(null, null, file, line, this.searchPtn);}, this)
			});
		}
		else this.view.getController().showLogWindow(null, null, file, line, this.searchPtn);
		evt.getSource().removeSelections();
	}
}

Grep.prototype.poll = function() {
    this.xhr = gSUMGlobals.oLMSLAPI.postGrepPoll(
    	$.proxy(function(result, sts, xhr) {
			if (xhr.status === 200) {
				try {
					this._oModel.setData(_xml2json($.parseXML(result)));
					this._oModel.refresh(true);
				} catch(e) {};
				if (this.oGrepDialog) this.oGrepDialog.getContent()[0].setBusy(false); 
				if (!this._oModel.getData().Logs) this.oTree.setNoDataText("Search text \""+this.searchPtn+"\" not found in the selected scope");
			}
			else if (xhr.status === 202) {
				this.timeoutID = setTimeout($.proxy(this.poll, this), 2000); 
			}
		}, this), 
		$.proxy(function(xhr, options, errorText) {
			if (this.oGrepDialog) this.oGrepDialog.getContent()[0].setBusy(false);
			this.oLabel.setText("Error: " + errorText);
		}, this), 
		this.logPtn, 
		prefmt(this.searchPtn),
		this
	);
};

Grep.prototype.stopPoll = function() {
	if (this.timeoutID != false) clearTimeout(this.timeoutID);
	if (this.oGrepDialog) this.oGrepDialog.getContent()[0].setBusy(false);
	this.timeoutID = false;
	gSUMGlobals.oLMSLAPI.postGrepStop(
		$.proxy(function(result, sts, xhr) {
//			this.oLabel.setText(result);
		}, this), 
		$.proxy(function(xhr, options, errorText) {
			this.oLabel.setText("Error: " + errorText);
		}, this), 
		this.logPtn, 
		prefmt(this.searchPtn),
		this
	);
	this.xhr = null;
};          
