jQuery.sap.require("sap.m.Dialog");
jQuery.sap.require("sap.ui.layout.HorizontalLayout");
jQuery.sap.require("sap.ui.table.Table");


var legendDialog = function() { 
	var _b = (document.URL.indexOf("suihcb=true")>0);
	var _w = (document.URL.indexOf("suihcw=true")>0);
	//--------------------------------------------------------------------------------------------------------------
	//Task Status Icons
	//-------------------------------------------------------------------------------------------------------------- 
	var statusData = [{
		statusName: 	"Initial Status",
		src: 			"sap-icon://status-negative",
		color: 			_b ? "#FFFFFF" : _w ? "#000000" : "#8F8F8F"
	}, {
		statusName: 	"Running status",
		src: 			"sap-icon://media-play",
		color: 			_b ? "#b3e4ff" : _w ? "#006399" : "#007dc0"
	}, {
		statusName: 	"Error status",
		src: 			"sap-icon://message-error",
		color: 			_b ? "#ff6666" : _w ? "#800000" : "#cc0000"
	}, {
		statusName: 	"Waiting for user input",
		src: 			"sap-icon://status-inactive",
		color: 			_b ? "#fee79a" : _w ? "#7e6101" : "#fdc411"
	}, {
		statusName: 	"Finished status",
		src: 			"sap-icon://status-completed",
		color: 			_b ? "#66ff66" : _w ? "#006600" : "#008b00"
	}, {
		statusName: 	"Aborted status",
		src: 			"sap-icon://sys-cancel",
		color: 			_b ? "#ff6666" : _w ? "#800000" : "#cc0000"
	}, {
		statusName: 	"Skipped status",
		src: 			"sap-icon://overlay",
		color: 			_b ? "#b3e4ff" : _w ? "#006399" : "#007dc0"
	}, {
		statusName: 	"Action required status",
		src: 			"sap-icon://to-be-reviewed",
		color: 			_b ? "#b3e4ff" : _w ? "#006399" : "#007dc0"
	}, {
		statusName: 	"Breakpoint status",
		src: 			"sap-icon://navigation-right-arrow",
		color: 			_b ? "#fee79a" : _w ? "#7e6101" : "#fdc411"
	}, {
		statusName: 	"Changed status (press Refresh)",
		src: 			"sap-icon://refresh",
		color: 			_b ? "#cae8ca" : _w ? "#2f6a2f" : "#70c070"
	}];
	var oStatusTable = new sap.ui.table.Table({
		visibleRowCount:	 	11,
		selectionMode: 			"None",
		editable: 				false,
		width: 					"255px",
		
		enableColumnReordering:	false
	});
	var oStatusIcon = new sap.ui.core.Icon( {   
	    size: 					"15px",  
	    activeColor: 			"white",  
	    activeBackgroundColor: 	"transparent",  
	    width: 					"15px"
	});
	oStatusIcon.bindProperty("src", "src");
	oStatusIcon.bindProperty("color", "color");
	oStatusTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Icon"}),
		template: 	oStatusIcon,
		width: 		"50px",
		hAlign: 	"Center",
		resizable: 	false
	}));
	oStatusTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Meaning"}),
		template: 	new sap.m.Text().bindProperty("text", "statusName").addStyleClass("LegendText"),
		width: 		"auto",
		resizable: 	false
	}));
	var oStatusModel = new sap.ui.model.json.JSONModel();
	oStatusModel.setData({modelData: statusData});
	oStatusTable.setModel(oStatusModel);
	oStatusTable.bindRows("/modelData");
	//--------------------------------------------------------------------------------------------------------------
	// Task type images
	//--------------------------------------------------------------------------------------------------------------
	var typeData = [{
		typeName: 	"Process",
		src: 		"resources/img/tasktype/ico_process.png",
		color: 		_b ? "#FFFFFF" : _w ? "#000000" : "#66a800"
	}, {
		typeName: 	"Task",
		src: 		"resources/img/tasktype/ico_task.png",
		color: 		_b ? "#FFFFFF" : _w ? "#000000" : "#eeeeee"
	}, {
		typeName: 	"Service",
		src: 		"resources/img/tasktype/ico_service.png",
		color: 		_b ? "#FFFFFF" : _w ? "#000000" : "#eeeeee"
	}, {
		typeName: 	"Technical Roadmap",
		src: 		"resources/img/tasktype/ico_roadmap.png",
		color: 		_b ? "#FFFFFF" : _w ? "#000000" : "#eeeeee"
	}];
	var oTypeTable = new sap.ui.table.Table({
		visibleRowCount: 			11,
		selectionMode: 				"None",
		editable: 					false,
		width: 						"255px",
		enableColumnReordering: 	false
	});
	oTypeTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Icon"}),
		template: 	new sap.m.Image({width:"16px",height:"16px"}).bindProperty("src", "src"),
		width: 		"50px",
		hAlign: 	"Center",
		resizable: 	false
	}));
	oTypeTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Meaning"}),
		template: 	new sap.m.Text().bindProperty("text", "typeName").addStyleClass("LegendText"),
		width: 		"auto",
		resizable: 	false
	}));
	var oTypeModel = new sap.ui.model.json.JSONModel();
	oTypeModel.setData({modelData: typeData});
	oTypeTable.setModel(oTypeModel);
	oTypeTable.bindRows("/modelData");
	//--------------------------------------------------------------------------------------------------------------
	// breakpoint status types
	//--------------------------------------------------------------------------------------------------------------
	var brkStatusData = [{
		statusName: 	"BP has already been passed",
		src: 			"sap-icon://past",
		color: 			_b ? "#b3ffc4" : _w ? "#00801e" : "#009823"
	}, {
		statusName: 	"BP is at the current step",
		src: 			"sap-icon://present",
		color: 			_b ? "#fee181" : _w ? "#977402" : "#fdc411"
	}, {
		statusName: 	"BP has not yet been reached",
		src: 			"sap-icon://future",
		color: 			_b ? "#b3d5ff" : _w ? "#002e66" : "#005cd0"
	}];
	var obrkStatTable = new sap.ui.table.Table({
		visibleRowCount: 			4,
		selectionMode: 				"None",
		editable: 					false,
		width: 						"255px",
		enableColumnReordering: 	false
	});
	var oBrkStatusIcon = new sap.ui.core.Icon({  
		size:					"15px",  
		activeColor: 			"white",  
		activeBackgroundColor: 	"transparent",  
		width: 					"15px"
	});
	oBrkStatusIcon.bindProperty("src", "src");
	oBrkStatusIcon.bindProperty("color", "color");
	obrkStatTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Icon"}),
		template: 	oBrkStatusIcon,
		width: 		"50px",
		hAlign: 	"Center",
		resizable: 	false
	}));
	obrkStatTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Meaning"}),
		template: 	new sap.m.Text().bindProperty("text", "statusName").addStyleClass("LegendText"),
		width: 		"auto",
		resizable: 	false
	}));
	var oBrkStatModel = new sap.ui.model.json.JSONModel();
	oBrkStatModel.setData({modelData: brkStatusData});
	obrkStatTable.setModel(oBrkStatModel);
	obrkStatTable.bindRows("/modelData");
	//--------------------------------------------------------------------------------------------------------------
	// divers elements
	//--------------------------------------------------------------------------------------------------------------
	var ctx = {};
	var diversData = [{
		statusName: 	"Mandatory entry",
		src: 			"sap-icon://map",
		color: 			_b ? "#ffffff" : _w ? "#000000" : "#c14646"
	}, {
		statusName: 	"Supplementary information",
		src: 			"sap-icon://message-information",
		color: 			_b ? "#ffffff" : _w ? "#000000" : "green"
	}];
	ctx.oDiversTable = new sap.ui.table.Table({
		visibleRowCount: 			3,
		selectionMode: 				"None",
		editable: 					false,
		width: 						"255px",
		enableColumnReordering: 	false
	});
	var oDiversIcon = new sap.ui.core.Icon({  
		size:					"15px",  
		activeColor: 			"white",  
		activeBackgroundColor: 	"transparent",  
		width: 					"15px"
	});
	oDiversIcon.bindProperty("src", "src");
	oDiversIcon.bindProperty("color", "color");
	ctx.oDiversTable.addColumn(ctx.oCol = new sap.ui.table.Column({
		label: 		(ctx.oLbl = new sap.m.Label({text: "Symbol"})),
		template: 	oDiversIcon,
		width: 		"50px",
		hAlign: 	"Center",
		resizable: 	false
	}));
	ctx.oDiversTable.addColumn(new sap.ui.table.Column({
		label: 		new sap.m.Label({text: "Meaning"}),
		template: 	new sap.m.Text().bindProperty("text", "statusName").addStyleClass("LegendText"),
		width: 		"auto",
		resizable: 	false
	}));
	var oDiversModel = new sap.ui.model.json.JSONModel();
	oDiversModel.setData({modelData: diversData});
	ctx.oDiversTable.setModel(oDiversModel);
	ctx.oDiversTable.bindRows("/modelData");
	//--------------------------------------------------------------------------------------------------------------
	//assign to root container
	//--------------------------------------------------------------------------------------------------------------
	ctx.oVLytStatusIcons = new sap.m.VBox({
		items: [new sap.m.HBox({items: [new sap.m.Text({text: "Status Icons"})]}).addStyleClass("sapUiTinyMarginBegin"), oStatusTable]
	});
	ctx.oVLytTypeIcons = new sap.m.VBox({
		items: [new sap.m.HBox({items: [new sap.m.Text({text: "Type Icons"})]}).addStyleClass("sapUiTinyMarginBegin"), oTypeTable]
	});
	ctx.oVLytTabs = new sap.m.VBox({height: "auto", alignContent:"SpaceBetween", justifyContent: "SpaceBetween", fitContainer: true,
		items: [ new sap.m.VBox({items: [new sap.m.HBox({items: [new sap.m.Text({text: "Breakpoint Status Icons"})]}).addStyleClass("sapUiTinyMarginBegin"), obrkStatTable]}),  //eslint-disable-line
			     new sap.m.VBox({items: [new sap.m.HBox({items: [new sap.m.Text({text: "Dialog Text"})]}).addStyleClass("sapUiTinyMarginBegin"), ctx.oDiversTable]})]});
	var oHLytIcons = new sap.ui.layout.HorizontalLayout();
	
	oHLytIcons.addContent(ctx.oVLytStatusIcons);
	oHLytIcons.addContent(ctx.oVLytTypeIcons);
	oHLytIcons.addContent(ctx.oVLytTabs);
	
	var oCloseBtn = new sap.m.Button({text: "Close", press: function(evt) {
		evt.getSource().getParent().close();
	}});
	var obj = new sap.m.Dialog({
		title:			"Legend",
		horizontalScrolling: 	false,
		verticalScrolling: 		false,
		resizable: 		false,
		draggable:		true,
		endButton: 		seleniumizeObj(oCloseBtn.data("sumid", "idCloseBtn"))
	});
	
	obj.oPopup.setModal(false);
	obj.addStyleClass("sapUiSizeCompact");
	obj.addContent(oHLytIcons);
	obj.addEventDelegate({onAfterRendering: $.proxy(function(evt) {
		this.oVLytTabs.setHeight($("#"+this.oVLytStatusIcons.getId()).height()+"px");
		$("#"+this.oLbl.getId()).css("font-size", "13px"); 
		$("#"+this.oCol.getId()+"-inner").css("padding", "0");
		$("#"+this.oDiversTable.getRows()[0].getCells()[0].getId()).get(0).attributes["data-sap-ui-icon-content"].value="*";
	}, ctx)});
	return obj;
};

var gLegendDialog = new legendDialog();

