var LogTail = function() {
	this.timeoutID = false;
	this.sapupLogFilesXML = "";
    this.selector = new sap.m.ComboBox({width: "200px", tooltip: "Logfile to tail"});
	
	$.ajax({
		type: "GET",
		url: gSUMGlobals.pathSlpAbap + "/logs?mainlogs=on",
		dataType: "xml",
		async: false,
		success: $.proxy(function(xml) {
					this.sapupLogFilesXML = xml;
				},this),
		error: function(xhr, options, errorText) {
					return("<logs><Log><displayName>No log files available ...</displayName><Log><logs>");
				}
	});

	/*** get main log files ***/
	var logs = this.sapupLogFilesXML.getElementsByTagName("Log");
	for (var i = 0; i < logs.length; i++) {
		var singleLogElement = $(logs[i]).find('displayName').first().text();
		if ((singleLogElement === "SAPup.log") || (singleLogElement.startsWith("SAPup_") && singleLogElement.endsWith(".log"))) {
			this.selector.setValue(singleLogElement	);
		}
		this.selector.addItem(new sap.ui.core.ListItem({text: singleLogElement}));
	}
	
    var obj = new sap.m.Dialog({
		title:			"Log Tail Viewer",
		resizable: 		true,
		draggable:		true,
		contentWidth: 	"600px",
		contentHeight:	"350px",
		subHeader: 		new sap.m.Toolbar({content: [this.selector]}),
		beginButton: 	new sap.m.Button({icon: "sap-icon://pause", tooltip: "Pause", press: $.proxy(function(evt) {
							if (evt.getSource().getIcon() === "sap-icon://pause") {                	     
								window.clearInterval(this.timeoutID);
								evt.getSource().setIcon("sap-icon://play").setTooltip("Continue");
							} else {
								this.timeoutID = window.setInterval($.proxy(this.poll, this), 2000);
								evt.getSource().setIcon("sap-icon://pause").setTooltip("Pause");
							} 
						}, this)}),
		endButton: 		new sap.m.Button({text: "Close", press: $.proxy(function() {
								window.clearInterval(this.timeoutID);
								obj.close();
						}, this)}),
		beforeClose: 	$.proxy(function() {this.stopPoll();}, this)
	});
	
	obj.oPopup.setModal(false);
	obj.addStyleClass("sapUiSizeCompact");
	
	this.logArea = new sap.m.Text().addStyleClass("monospc");
	var logBox = new sap.m.VBox({fitContainer: true, items: [this.logArea]});
	logBox.addStyleClass("sapUiSmallMargin");
    obj.addContent(logBox);
	obj.open();

	this.stopPoll();
	this.poll();
	this.timeoutID = window.setInterval($.proxy(this.poll, this), 2000);
	
	return obj;
};


LogTail.prototype.poll = function() {
	if (Boolean(this.selector.getValue())) $.ajax({
		type: "GET",
		url: gSUMGlobals.pathSlpAbap + "/logs/" + encodeURIComponent(this.selector.getValue()) + "?lineoffset=-100",
		cache: false,
		dataType: "text",
		success: $.proxy(function(logcontent) {
			var logAreaId = this.logArea.getId();
			this.logArea.setText(logcontent);
			$('#' + logAreaId).parent().parent().parent().parent().parent().scrollTop($('#' + logAreaId)[0].scrollHeight);
		}, this),
		error: $.proxy(function(xhr, options, errorText) {
			this.logArea.setText("Error: " + errorText);
		}, this)
	});
	else this.logArea.setText("No data available");
};

LogTail.prototype.stopPoll = function() {
	if (this.timeoutID != false) {
		window.clearInterval(this.timeoutID);
		this.timeoutID = false;
	}
};          
