function loadConfigSuccess(dta) {	
	/* here, parse the CONFIG resource and build a configParams array */
	if (dta) {
		this.configParams = [];
		var sCnfgDta = $(dta).children(suiCnst.SLP_PARAM_HEADER);
		if (sCnfgDta) {
			$.each($(sCnfgDta).children(suiCnst.SLP_PARAM_NAME),
					$.proxy(function(ind, prm) {
						var cnfprm = new SLUIConfigParameter("xml", prm);
						this.configParams.push(cnfprm);
//						if ((gSUMGlobals.diaParamMap[cnfprm.getId()] != undefined && gSUMGlobals.diaParamMap[cnfprm.getId()].uiId == undefined) || gSUMGlobals.diaParamMap[cnfprm.getId()] == undefined) 
							gSUMGlobals.diaParamMap[cnfprm.getId()] = {uiId: "", value: "", uiAttrMap: null, currentValue: ""};								
					}, this));
		}
		this.valErr = [];
		$.each($(dta).find(suiCnst.SLP_PARAM_NAME),
			$.proxy(function(ind, prm) {
				if (($(prm).find(suiCnst.SLP_PARAM_VAL_RESULT) != null)&& $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children().length > 0) {
					var lenVR = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).length;
					for (var z = 0; z < lenVR; z++) {
						var oVStatus = $(prm).find(suiCnst.SLP_PARAM_VAL_RESULT).children()[z];
						if (oVStatus) {
						    othis.valErr.push({
								paramId : $(prm).find(suiCnst.SLP_COMMON_ID)[0].textContent,
								status : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_STATUS)[0].textContent,
								message : $(oVStatus).find(suiCnst.SLP_PARAM_VAL_MESSAGE)[0].textContent});
						}
					}
				}
			}, this)
		);
	}
	else gSUMGlobals.popupError("Config resource loaded successfully with empty data element");
    this.getModel("currentConfig").setData({xmlContent: new XMLSerializer().serializeToString(dta)});
    if (gSUMGlobals.nextButton) gSUMGlobals.nextButton.focus();
}


function checkConfigParams(context) {
	var that = context;
	var xml = "<config xmlns=\"http:\/\/www.sap.com/lmsl/slp\">";  
	for (var x = 0; x < that.configParams.length; x++) {
		var param = that.configParams[x];
		var sUqId = gSUMGlobals.diaParamMap[param.getId()].uiId;

		if ((sUqId != null) && (sUqId != undefined)) {
			if (sUqId === "") {
				sUqId = gSUMGlobals.diaParamMap[param.getId()].uiId = findRecursiveItemMode(that.getView().byId("vbox0"), param.getId(), 3);
			}
			var ctrl;
			if (Boolean(ctrl = sap.ui.getCore().byId(sUqId))) {
				var uiElem = ctrl.getMetadata().getElementName();
				switch (uiElem) {
					case "sap.m.VBox": gSUMGlobals.popupError("A VBox has the same ID as a config-parameter. This is fatal. Contact SAP Support!"); break;
					case "SUMControls.Group": gSUMGlobals.popupError("A group has the same ID as a config-parameter. This is fatal. Contact SAP Support!"); break;
					case "SUMControls.RadioButtonBox": 
						var choice = ctrl.getSelectedButton();
						if (!choice) choice = ctrl.getButtons().find(function(a){return a.getSelected();});
						if (!choice) choice = ctrl.getButtons()[0];
						gSUMGlobals.diaParamMap[param.getId()].value = stripId(choice.getValue());
						break;
					case "sap.m.CheckBox": 
					case "SUMControls.CheckBox":
						gSUMGlobals.diaParamMap[param.getId()].value = ctrl.getSelected(); 
						break;
					case "sap.m.List":
						gSUMGlobals.diaParamMap[param.getId()].value = ctrl.getSelectedItem();
						break;
					case "sap.m.Table":
					case "SUMControls.Table":
						var sXMLValue = "";
						var cnfTblVal = param.getTableValue(); 
						var tupColl = cnfTblVal.children();
						var struct = param.getStructure();
						var columns = sap.ui.getCore().byId(sUqId).getColumns(); 
						var rows = sap.ui.getCore().byId(sUqId).getItems();
						if (cnfTblVal && rows && tupColl) {
							if (rows.length == tupColl.length) {
								for (var tupCnt = 0; tupCnt < tupColl.length; tupCnt++) {
									var tuple = tupColl[tupCnt];
									var tPrms = $(tuple).find("Parameter");
									var rowChilds = rows[tupCnt].getCells();
									sXMLValue += "<Tuple><id>" + tuple.childNodes[0].textContent + "</id><value>";
									if (tPrms && tPrms.length>0) 
										for (var t=0; t < tPrms.length; t++) {
											var prm=tPrms[t];
											var id = $(prm).find("id")[0].textContent;
											var value = getValFromTable(rowChilds, columns, id);
											var cnfprm = new SLUIConfigParameter("xml", prm);
											sXMLValue = sXMLValue + prepareParamXML(cnfprm, value);
										}
									sXMLValue += "</value></Tuple>";
								}
							} else {
								var start = 1;
								if (rows.length<tupColl.length) start = 1;
								else if (rows.length>tupColl.length) start = tupColl.length+1;
								var idCount = 1;
								for (var tupCnt = 0; tupCnt<rows.length; tupCnt++) {
									var row = rows[tupCnt];
									var tPrms = $(struct).find("Parameter");
									var rowChilds = rows[tupCnt].getCells();
									//sXMLValue += "<Tuple><id>" + tupCnt + "</id><value>";
									sXMLValue += "<Tuple><id>" + idCount + "</id><value>";
									if (tPrms && tPrms.length>0) 
										for (var t=0; t < tPrms.length; t++) {
											var prm=tPrms[t];
											var id = $(prm).find("id")[0].textContent;
											var value = getValFromTable(rowChilds, columns, id);
											var cnfprm = new SLUIConfigParameter("xml", prm);
											sXMLValue = sXMLValue + prepareParamXML(cnfprm, value);
										}
									sXMLValue += "</value></Tuple>";
									idCount++;
								}
							}
						}
						gSUMGlobals.diaParamMap[param.getId()].value = sXMLValue;
						break;
					case "SUMControls.PwdCnfrmInput":
						gSUMGlobals.diaParamMap[param.getId()].value = sap.ui.getCore().byId(sUqId+"_1").getValue();
						break;
					default:
						if (typeof ctrl.getValue != "function") gSUMGlobals.popupError("This input control does not support the method getValue(). UI developers must fix it!");
						gSUMGlobals.diaParamMap[param.getId()].value = ctrl.getValue();
				} 
				xml += prepareParamXML(param, gSUMGlobals.diaParamMap[param.getId()].value);	
			}
			else xml += prepareParamXML(param, "");
		}
		else xml += prepareParamXML(param, "");
	}
	xml += "</config>"; // </parameters>
	return xml;
}


function getValFromTable(rowChilds, columns, id) {
	var x = 0;
	while (x < columns.length) {
		var colId = columns[x].data("sumid") || columns[x].getId();
		var pos = colId.lastIndexOf("_"+id);
		if ((pos !== -1) && (pos+id.length+1 === colId.length)) break;
		else x++;
	}
	if (x >= columns.length) {
		gSUMGlobals.popupError("Could not find the requested column in the table!");
		return "";		
	}
	return (typeof rowChilds[x].getValue === "function") ? rowChilds[x].getValue() : rowChilds[x].getSelected();
};


function prepareParamXML(param, value) {
	var xml = "<Parameter>";
	if (param.getId()) xml += "<id>"+param.getId()+ "</id>"; 
	if (param.getType()) xml += "<type>"+param.getType()+ "</type>";
	if (param.getDefaultValue()) xml += "<default>"+htmlEncode(param.getDefaultValue())+"</default>";
	if (param.getRequired()) xml += "<required>"+param.getRequired()+"</required>";
	if (param.getSecure()) xml += "<secure>"+param.getSecure()+"</secure>";
	
	if (param.getType()===suiCnst.SLP_PARAM_TYPE_SCALAR) {
		if (value) 	xml += "<value>"+htmlEncode(value)+"</value>";
		else 		xml += "<value></value>";
		if (param.getStructure()) 	xml += "<structure>"+param.getStructure().text()+"</structure>";
		else 						xml += "<structure></structure>";
		if (param.getTupleValue()) 		xml += "<tuplevalue>"+param.getTupleValue().text()+"</tuplevalue>";
		else 							xml += "<tuplevalue></tuplevalue>";
		if (param.getTableValue()) 	xml += "<tablevalue>"+param.getTableValue().text()+"</tablevalue>";
		else 						xml += "<tablevalue></tablevalue>";
	} else if (param.getType() === suiCnst.SLP_PARAM_TYPE_TABLE) {
		if (param.getValue()) 	xml += "<value>"+htmlEncode(param.getValue())+"</value>";
		else 					xml += "<value></value>";
		if (param.getStructure())
		{
			var xmlsr = new XMLSerializer();
			var dta = param.getStructure();
			if (dta && dta.length>0) {
				dta = dta[0];	
				xml += xmlsr.serializeToString(dta);
			}			
		} 
		else xml += "<structure></structure>";
		if (param.getTupleValue()) 	xml += "<tuplevalue>"+param.getTupleValue().text()+"</tuplevalue>";
		else 						xml += "<tuplevalue></tuplevalue>";
		if (value) 	xml += "<tablevalue>"+value+"</tablevalue>";
		else 		xml += "<tablevalue></tablevalue>";
	}
	xml += "<validationResult/></Parameter>";
	return xml;
}


