jQuery.sap.require("sap.m.MessageBox");

function slpxml2json(xmlObj, calcHash) {
	
	function _hash(str) {
	    var hsh = 0;
		if (calcHash) 
		    for (var i = 0; i < str.length; i++) {
		        hsh = ((hsh<<5)-hsh)+str.charCodeAt(i);
		        hsh = hsh & hsh;
		}
	    return hsh;
	}
	
	// Create the return object
	var retObj = {};
	var hash = 0;
	if (xmlObj.nodeType === 3) hash = _hash(retObj = xmlObj.nodeValue); 	// text

	// do children
	if (xmlObj.hasChildNodes()) {
		for (var i = 0; i < xmlObj.childNodes.length; i++) {
			var item = xmlObj.childNodes.item(i);
			var nodeName = item.nodeName;
            if (nodeName === "#text") return {json: item.nodeValue, hash: _hash(item.nodeValue)};
			if (typeof(retObj[nodeName]) === "undefined") {
				var obj = slpxml2json(item, calcHash);
				retObj[nodeName] = obj.json;
				hash += obj.hash;
			}
            else {
				if (typeof(retObj[nodeName].push) === "undefined") {
					var old = retObj[nodeName];
					retObj[nodeName] = [];
					retObj[nodeName].push(old);
				}
				var obj = slpxml2json(item, calcHash);
				retObj[nodeName].push(obj.json);
				hash += obj.hash;
			}
		}
	}
    else if(xmlObj.nodeValue === null) return {json: "", hash: 0}; 
	return {json: retObj, hash: hash};
}

function arrayify(element) {
    var retAr = [];
    if (element === undefined) return retAr;
    else if (element.constructor === Array) return element;        
    else { 
        retAr.push(element);
        return retAr;
    }    
}

function postToResource(action, context, successFunc, failFunc) {
	context.getView().byId("idMoreMenuItemReset").setVisible(false);
	context.getView().byId("idMoreMenuItemCleanup").setVisible(false);
	context.getView().byId("idMoreMenuItemExit").setVisible(false);
	context.semaDlg = false;		// release semaphore for refreshDialog()
	context.getView().setBusy(true);
    switch (action) {
    	case "next": 
	        /* hier muss erstmal der vom Anwender modifizierte Dialog ausgelesen und die Werte in das CONFIG-Model geschrieben werden.
	         * Das machen wir im alten UI in der Process.js::SLUIProcess.prototype.checkConfigParams()
	         */
    		context.oSLPAPI.postConfig(successFunc, failFunc, checkConfigParams(context));
	        break;
    	case "back":
    		context.oSLPAPI.postAction(action, successFunc, failFunc);
    		break;
    }
}

function logHandler(data) {
    var jsonLogs = slpxml2json(data).json;
    var logModel = new sap.ui.model.json.JSONModel(jsonLogs);
	var fileCol  = this.getView().byId("idFileCol");
	var fileflt  = fileCol && this.getView().byId("idFileCol").getFilterValue();
	logModel.setSizeLimit(gSUMGlobals.tableLimit);
    this.getView().setModel(logModel, "logs");
	if (fileflt) fileCol.filter(fileflt);
}

function breakpointHandler(func, data) {
    var jsonBreakpoints = slpxml2json(data).json;
    var breakpointModel = new sap.ui.model.json.JSONModel(jsonBreakpoints);
	breakpointModel.setSizeLimit(gSUMGlobals.tableLimit);
    this.getView().setModel(breakpointModel, "breakpoints");
    if (gSUMGlobals.activeMenuItem === "idMenuBreakpoints") gSUMGlobals.resizeBox.rerender();
	if (func) func();
}

function tasklistHandler(data) {
    var jsonTasklist = slpxml2json(data).json;
    var tasklistModel = new sap.ui.model.json.JSONModel(jsonTasklist);
	tasklistModel.setSizeLimit(gSUMGlobals.tableLimit);
    this.getView().setModel(tasklistModel, "tasklist");
    if (this.autoScroll) simulateTasklist(this, this.getModel("roadmapModel").getData().roadmap.selectedKey);
}

function handleSpecialButtons(data) {
    var actions = arrayify(slpxml2json(data).json.actions.Action);
	this.getView().byId("idMoreMenuItemReset").setVisible(false);
	this.getView().byId("idMoreMenuItemCleanup").setVisible(false);
	this.getView().byId("idMoreMenuItemExit").setVisible(false);
	this.getView().byId("back").setEnabled(false).setTooltip("Not possible now...");
	this.getView().byId("next").setEnabled(false);
	gSUMGlobals.nextButton = null;
    if (actions.length !== 0)
    {
        for (var n = 0; n < actions.length; n++) {
        	switch (actions[n].id) {
        	case "IMMEDIATERESET":
        		/* do nothing */
        		break;
        	case "reset":
        		this.getView().byId("idMoreMenuItemReset").setVisible(true);
        		break;
        	case "cleanup":
        		this.getView().byId("idMoreMenuItemCleanup").setVisible(true);
        		break;
        	case "exit":
        		this.getView().byId("idMoreMenuItemExit").setVisible(true);
        		break;
        	case "back":
 				var ttip = "Back";
				if (this.dialogId) switch(this.dialogId[this.dialogId.length-1]) {
					case "UnitWizard": 		ttip = "Back to Beginning of Roadmap Step" + (this.dialogId.length > 2 ? " '"+this.dialogId[1]+"'" : ""); break;
					case "PhaseDecision":	ttip = "Back" + (this.dialogId.length > 2 ? " to Beginning of '"+this.dialogId[2]+"'" : ""); break;
					default:				ttip = "Back to Beginning of Phase" + (this.dialogId.length > 2 ? " '"+this.dialogId[this.dialogId.length-2]+"'" : ""); break;
				}
        		this.getView().byId("back").setEnabled(true).setTooltip(ttip);
        		break;
			case "next":
        		gSUMGlobals.nextButton = this.getView().byId("next");
				gSUMGlobals.handleNext();
        		break;
        	}
        }
		gSUMGlobals.busy = false;
    }
}

function updateBreakpoints(that, refresh, func) {
	if (gSUMGlobals.activeMenuItem !== "idMenuBreakpoints") return;
	if (refresh || !that.getModel("breakpoints")) {that.oSLPAPI.getBreakpoints(breakpointHandler.bind(that, func), gSUMGlobals.genericError);}
	else if (gSUMGlobals.resizeBox) gSUMGlobals.resizeBox.rerender();
}

function simulateTasklist(that, filter) {
	if ((gSUMGlobals.activeMenuItem !== "idMenuTasklist") || !gSUMGlobals.resizeBox) return;
    if (!that.getModel("tasklist")) that.oSLPAPI.getTasklist($.proxy(tasklistHandler, that), gSUMGlobals.genericError, filter);
    else {
		var taskList = that.getModel("tasklist").getData().tasklist.Task;
		if (!taskList) return;
	
		// identify index of current phase in tasklist
	    var stepID = that.getModel("monitorModel").getData().currentStep;
	    var idx = -1;
	
	    for (var t = 0; t < taskList.length; t++) {
			if (stepID === "") {
				if ((taskList[t].id === that.getModel("monitorModel").getData().currentModule) && (taskList[t].type === "slp.task.type.ROADMAP.TECH")) {
					idx = t;
					break;
				}
			} else if ((((taskList[t].id === stepID) && (taskList[t].parent === that.getModel("monitorModel").getData().currentModule)) || ((taskList[t].id.split(stepID).length > 1) && (taskList[t].id.split(stepID)[1] === "") && (taskList[t].id.split(stepID)[0] !== "") && (taskList[t].id.split(stepID)[0][taskList[t].id.split(stepID)[0].length-1] === "/") && (!taskList[t+1] || (taskList[t+1].status === "slp.task.state.INITIAL")))) && (taskList[t].type === "slp.task.type.STEP")) {
				idx = t;
				break;
			}
		}
	    if (idx < 0) for (var t = 0; t < taskList.length; t++) {
				if ((taskList[t].id === that.getModel("monitorModel").getData().currentModule) && (taskList[t].type === "slp.task.type.ROADMAP.TECH")) {
					idx = t;
					break;
				}
		}
	
		if ((idx > -1) && (taskList[idx].status === "slp.task.state.INITIAL")) {
			taskList[idx].status = "slp.task.state.RUNNING";
			for (i = idx-1; i >= 0; i--) {
				if (    (taskList[i].status === "slp.task.state.INITIAL")
						|| (taskList[i].status === "slp.task.state.RUNNING")
						|| (taskList[i].status === "slp.task.state.DIALOG")) {  
					taskList[i].status = "slp.task.state.UNKNOWN";
				}
				else if (    (taskList[i].status === "slp.task.state.FINISHED")
						|| (taskList[i].status === "slp.task.state.UNKNOWN") ) break;
			}
		}
		gSUMGlobals.resizeBox.getModel("tasklist").refresh();
//		gSUMGlobals.resizeBox.rerender();    
		$("#"+gSUMGlobals.resizeBox.getId()+"-vsb").off('scroll');
	    if (that.autoScroll) gSUMGlobals.resizeBox.setFirstVisibleRow((idx>2) ? idx-3 : 0);
	    setTimeout($.proxy(function(){if (gSUMGlobals.resizeBox) $("#"+gSUMGlobals.resizeBox.getId()+"-vsb").scroll($.proxy(function(evt){this.autoScroll = false;}, this));}, that), 1500);
    }
}

function processRoadmap(data) {
    var obj = slpxml2json(data, true);
	if (processRoadmap.hash !== obj.hash) {
	    var jsonRoadmap = obj.json;
	    jsonRoadmap.roadmap.selectedKey = "";
	    
	    var roadMapTasks = arrayify(jsonRoadmap.roadmap.Task);
	    
		if (roadMapTasks.length === 0) {
	        var roadmap = {Task: [{id:"DETROADMAP", displayName: "Get Roadmap", icon:"question-mark"}]};
	        jsonRoadmap.roadmap = roadmap;
	    } else {
		    if (!jsonRoadmap.roadmap.Task.length) jsonRoadmap.roadmap.Task= [jsonRoadmap.roadmap.Task];
			var roadmapInitialLength = jsonRoadmap.roadmap.Task.length;
	        for (var i = 0; i < jsonRoadmap.roadmap.Task.length; i++)
	        {
	            if (jsonRoadmap.roadmap.Task[i].status !== "slp.task.state.INITIAL" && jsonRoadmap.roadmap.Task[i].status !== "slp.task.state.FINISHED") 
	                jsonRoadmap.roadmap.selectedKey = jsonRoadmap.roadmap.Task[i].id;
	            if (jsonRoadmap.roadmap.Task[i].id == "EXTRACT")
	                jsonRoadmap.roadmap.Task[i].icon = "download";
	            else if (jsonRoadmap.roadmap.Task[i].id == "CONFIGURE")
	                jsonRoadmap.roadmap.Task[i].icon = "action-settings";
	            else if (jsonRoadmap.roadmap.Task[i].id == "CHECK")
	                jsonRoadmap.roadmap.Task[i].icon = "task";
	            else if (jsonRoadmap.roadmap.Task[i].id == "PRE-EXECUTE")
	                jsonRoadmap.roadmap.Task[i].icon = "workflow-tasks";
	            else if (jsonRoadmap.roadmap.Task[i].id == "EXECUTE")
	                jsonRoadmap.roadmap.Task[i].icon = "media-play";
	            else if (jsonRoadmap.roadmap.Task[i].id == "POST-EXECUTE")
	                jsonRoadmap.roadmap.Task[i].icon = "instance";
	            else if (jsonRoadmap.roadmap.Task[i].id == "PREPROCESSING")
	                jsonRoadmap.roadmap.Task[i].icon = "workflow-tasks";
	            else if (jsonRoadmap.roadmap.Task[i].id == "POSTPROCESSING")
	                jsonRoadmap.roadmap.Task[i].icon = "instance";
	            else
	                jsonRoadmap.roadmap.Task[i].icon = "navigation-right-arrow";
	        }
	    }
		var itb = this.getView().byId("idIconTabBar");
		var itbit = itb.getItems();
		for (var i=itbit.length-2; i>0; i--) if (itbit[i].getMetadata().getElementName() === "sap.m.IconTabSeparator") itb.removeItem(i);
	    this.getModel("roadmapModel").setData(jsonRoadmap);
		for (var i=0; i<roadMapTasks.length-1; i++) itb.insertItem(new sap.m.IconTabSeparator({icon:"sap-icon://step"}), 2*i+1);
	    this.getView().getController().selectRoadMapStep();
//	    get (pre-filtered) tasklist
	    if (jsonRoadmap.roadmap.selectedKey === "DETROADMAP") this.monitorActPoll = 0;
	    if (this.monitorActPoll === 1) this.onSecContentRefresh();
	    else {
		    simulateTasklist(this, jsonRoadmap.roadmap.selectedKey);
		    updateBreakpoints(this, false);
	    }
	    processRoadmap.hash = obj.hash;
//	    console.log("...Processing RoadMap due to unknown Hash...");
	}
//	else console.log("...Skipping RoadMap due to known Hash...");
}

function xml2String(xml)
{
    var serializer = new XMLSerializer();
    var string = serializer.serializeToString(xml);
    return string;
}

//htmlencode and htmldecode stuff
function htmlEncode(str) {
    return String(str)
            .replace(/&/g, '&amp;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
}

function htmlDecode(value) {
    return String(value)
        .replace(/&quot;/g, '"')
        .replace(/&#39;/g, "'")
        .replace(/&lt;/g, '<')
        .replace(/&gt;/g, '>')
        .replace(/&amp;/g, '&');
}

function stripId(inId) {
	return inId.substr(((i = inId.lastIndexOf("--")) === -1) ? 0 : i+2);
}

String.prototype.startsWith = String.prototype.startsWith || function(s, p) {p = p || 0; return this.indexOf(s, p) === p;};

function findChildren(children, filter) {
	var list = [];
	for (var i = 0 ; i < children.length ; i++) {
		if (children[i].getMetadata().getElementName() !== filter) continue;		
		list.push(children[i]);
	}
	return list;
}

function findRecursiveItemMode(fragment, searchId, mode) {
	/*
	 * mode = 0: fragment id == searchId
	 * mode = 1: fragment id starts with searchId (or contains "--"+searchId in case of prefix!)
	 * mode = 2: fragment id ends with searchId
	 * mode = 3: fragment id ends with "--"+searchId
	 * mode = 4: fragment id == searchId, but use DOM IDs only
	 */
	var foundId = "";
	var found = false;
	var mapId = fragment.getId();
	if (mode != 4) mapId = fragment.data("sumid") || mapId;
	switch (mode) {
		case 0: 
		case 4: found = (mapId === searchId); break; 
		case 1: found = (mapId.lastIndexOf("--"+searchId) > -1) || mapId.startsWith(searchId); break;
		case 2: found = mapId.endsWith(searchId); break;
		case 3: found = fragment.data("sumid") ? mapId === searchId : mapId.endsWith("--"+searchId); break;
	}
	if (!found) {
		var items = null;
		if (typeof fragment.getItems === "function") items = fragment.getItems();
		if (items) for (var i=0; i < items.length; i++) if ((foundId = findRecursiveItemMode(items[i], searchId, mode)) !== "") break;
		var gcontent = null;
		if (fragment.oGrid && typeof fragment.oGrid.getContent  === "function") gcontent = fragment.oGrid.getContent();
		if (gcontent) for (var c=0; c < gcontent.length; c++) if ((foundId = findRecursiveItemMode(gcontent[c], searchId, mode)) !== "") break;
		var content = null;
		if (typeof fragment.getContent  === "function") content = fragment.getContent();
		if (content) for (var c=0; c < content.length; c++) if ((foundId = findRecursiveItemMode(content[c], searchId, mode)) !== "") break;
		var buttons = null;
		if (typeof fragment.getButtons  === "function") buttons = fragment.getButtons();
		if (buttons) for (var c=0; c < buttons.length; c++) if ((foundId = findRecursiveItemMode(buttons[c], searchId, mode)) !== "") break;
		var children = null;
		if (typeof fragment.getChildren  === "function") children = fragment.getChildren();
		if (children) for (var c=0; c < children.length; c++) if ((foundId = findRecursiveItemMode(children[c], searchId, mode)) !== "") break;
		if (fragment.oCheckBox) foundId = findRecursiveItemMode(fragment.oCheckBox, searchId, mode);
	}
	else foundId = fragment.getId();
	return foundId;
}

function blacklistedXSS() {
   	var host = $(location).attr('host');
   	var href = $(location).attr('href');
   	var str = href.slice(href.search(host)+host.length);
   	return Boolean(str.match(/(javascript|src|onerror|%|<|>)/g));    	
}
    
function whitelistedXSS() {
   	return Boolean($(location).attr('href').match(/\/lmsl\/(sumabap)\/([A-Z]|[a-z]|[0-9]){3}(([A-Z]|[a-z]|[0-9])?){5}(\/doc)?\/slui((\/\?)|(\/?$))/g));
}

function checkFileExists(url) {
	var httpRequest = new XMLHttpRequest();
	httpRequest.open('GET', url, false);
	httpRequest.send();
	if (httpRequest.status == 404) return false;
	else return true;
}

function createFeedbackDialog(tit, sURL) {
	function w(){var w = $(document).width()-100; if (w > 1000) w = 1000; if (w < 400) w = 400; return w;}
	function h(){var h = $(document).height()-250; if (h < 200) h = 200; if (h > 1200) h = 1200; return h;}
	var oDialog;
	if (!(oDialog = sap.ui.getCore().byId("feedbackDialog"))) {
	    oDialog = new sap.m.Dialog('feedbackDialog', {
	    	title: 				tit,
			verticalScrolling: 	false
	    });
		oDialog.oPopup.setModal(false);
	    feedbackHTML = new sap.ui.core.HTML({
	    	content: "<iframe width=\"" + w() + "px\" height=\"" + h() + "px\" src=\"" + sURL + "\" ></iframe>",
	    	sanitizeContent: true
	    });
	    oDialog.addContent(feedbackHTML);
		oDialog.setEscapeHandler(function(o){o.reject();});
 	}
	else window.$('#feedbackDialog').fadeIn();
	gSUMGlobals.feedbackItem.setVisible(true);
	$(window).resize(function(){
		var oDialog = sap.ui.getCore().byId("feedbackDialog");
		oDialog.getContent()[0].getDomRef().height = h()+"px";
		oDialog.getContent()[0].getDomRef().width = w()+"px";
	});
    return oDialog;
}

function launchFeedbackFormDialog(mode) {
	// kb: I removed the error popup when file not found because there are situations (e.g. check tool) where no feedback dialog is desired
	var feedbackURL = "../eval/EvalForm.html";
	if (checkFileExists(feedbackURL)) {
		if (!sap.ui.getCore().byId("feedbackDialog") || (mode !== "once")) createFeedbackDialog("Feedback to SAP", feedbackURL).open(); 
	} 
}

function saveFile(fileName) {
	var that = {};
	that.file = fileName;
	var xhr = new XMLHttpRequest(); 
	xhr.open("GET", "../log/" + encodeURIComponent(fileName)); 
	xhr.responseType = "blob";
	xhr.onload = $.proxy(function() { 
		if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(xhr.response, this.file);
		else {
			var elem = window.document.createElement('a');
			elem.href = window.URL.createObjectURL(xhr.response);
			elem.download = this.file;        
			document.body.appendChild(elem);
			elem.click();        
			document.body.removeChild(elem);
		}    		
	}, that);
	xhr.send();          	
}

function openHelpWindow() {
    var url = gSUMGlobals.pathLmslAbap + "/guide/" + ((["zdo", "cnv", "doc"].indexOf(gSUMGlobals.guideInfo.opt.substr(0, 3)) >= 0) ? "" : ((gSUMGlobals.guideInfo.db ? gSUMGlobals.guideInfo.db : "HDB") + "/")) + (gSUMGlobals.guideInfo.opt ? gSUMGlobals.guideInfo.opt : "std") + "/" + (gSUMGlobals.guideInfo.loio ? gSUMGlobals.guideInfo.loio : "index") + ".html";
    if ((gSUMGlobals.guideInfo.db === "DB4") && !checkFileExists(url)) url = url.replace(/\/DB4\//, "/HDB/"); //Fallback for DB4 with Windows dialog instance, see BCP 2280113059
	if (gSUMGlobals.guideInfo.section && gSUMGlobals.guideInfo.loio) url += "#loio" + gSUMGlobals.guideInfo.loio + "__" + gSUMGlobals.guideInfo.section;
    window.open(url, "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");
}

function isIE() {
    try {
        var agt = navigator.userAgent.toLowerCase();
        if 		(agt.indexOf("msie") != -1)  return true;  		//IE 10
        else if (agt.indexOf("trident") != -1) return true;		//IE 11
        else if (agt.indexOf("edge") != -1) return true;		//Edge
    }
    catch (e) {return false;}
}

function logout() {
	var mozMessage = "<div><b>Logout done...<br/>Firefox users be advised to restart the browser to be able to logon again successfully.</b><br/><a href=\"javascript:void(0);\" onclick=\"document.location.reload();\" >Reload Page</a></div>";
	var ieMessage = "<div><b>Logout done...<br/>You can re-logon by entering your credentials again.</b><br/><a href=\"javascript:void(0);\" onclick=\"document.location.reload();\" >Reload Page</a></div>";
	if (isIE()) {
		document.getElementById("content").innerHTML = ieMessage;
		setTimeout(function() {
			document.execCommand("ClearAuthenticationCache");
			location.reload();
		});
	} else {
		document.getElementById("content").innerHTML = mozMessage;
		//default: logout for abap realm
		var url = document.URL.split("//")[0] + "//" + "logout:logout@" + document.URL.split("//")[1];
		$.ajax({
			type: 		"GET",
			url: 		url,
			dataType: 	"text",
			async: 		false,
			cache: 		false,
			success: 	function() {sap.m.MessageBox.error("Error Logout: The server could not terminate the session, you might still be logged on!");},
			error: 		function(xhr, options, errorText) {location.reload();}
		});
	}
}

function getVersionString(xml) {

	function trimString(string) {
	    var ar = string.split(": ");
	    var res = ar[1];
	    res = res.replace(/[\n\r]+/g, '');
	    return res;
	}
	
	gSUMGlobals.extVersion = $($.parseXML(xml)).find("slui-metaInfo extendedVersion").text();
	$.ajax({
        type: "GET",
        url: "../summanifest.mf",
        dataType: "text",
        cache: false,
        success: $.proxy(function(mfcontent) {
            var st1 = "release: ";
            var st2 = "support package: ";
            var st3 = "patch number: ";
            var ar = mfcontent.split("\n");
            gSUMGlobals.version = "";
            for (i = 0; i < ar.length; i++) {
                if (ar[i].indexOf(st1) > -1) 		gSUMGlobals.version += trimString(ar[i]);
                else if (ar[i].indexOf(st2) > -1) 	gSUMGlobals.version += " SP" + trimString(ar[i]);
                else if (ar[i].indexOf(st3) > -1) 	gSUMGlobals.version += " (PL" + trimString(ar[i]) + ")";
            }
			var vLabel = this.getView().byId("idOTBLabel");
			vLabel.setText(vLabel.getText() + " " + gSUMGlobals.version);            
        }, this),
        error: function(xhr, options, errorText) {
            gSUMGlobals.popupError("SUM Version Info: " + errorText);
        }
    });
}

function createAboutDialog() {
	var oCloseBtn = new sap.m.Button({text: "Close", press: function(evt) {
		evt.getSource().getParent().close();
		evt.getSource().getParent().destroy();
	}});
    var oDia = new sap.m.Dialog({
    	customHeader:	new sap.m.Toolbar({content: [new sap.m.Image({src: "resources/img/saplogo.png", width: "64px", alt: "SAP"}),
    	             	                             new sap.m.ToolbarSpacer(),
    	             	                             new sap.m.Title({text: "Information"}),
    	             	                             new sap.m.ToolbarSpacer()]}),
		resizable: 		false,
		draggable:		true,
		endButton:		seleniumizeObj(oCloseBtn.data("sumid", "idCloseBtn"))
	});
	oDia.addStyleClass("sapUiSizeCompact sapUiContentPadding");
	var oForm1 = new sap.ui.layout.VerticalLayout({
								content: [new sap.ui.layout.Grid({defaultSpan: "XL6 L6 M6 S6", 
													content: [new sap.m.HBox({width: "30em", items: [new sap.m.Text({text: "Software Update Manager"})]}), new sap.m.HBox({items: [new sap.m.Text({id: "sum_RL_SP_PL", text: gSUMGlobals.version})]}),
													          new sap.m.HBox({width: "30em", items: [new sap.m.Text({text: "Software Logistics Protocol"})]}), new sap.m.HBox({items: [new sap.m.Text({text: "1.5.0"})]}),
													          new sap.m.HBox({width: "30em", items: [new sap.m.Text({text: "Software Logistics UI Client"})]}), new sap.m.HBox({items: [new sap.m.Text({text: gSUMGlobals.extVersion})]}),
	                                                          new sap.m.Text({text: "SAP SE "+new Date().getFullYear()+".", textAlign: "Right"})]})]});
	oDia.addContent(oForm1);
    if (oDia) oDia.open();
}

var hist = [[0,0],[0,0],[0,0],[0,0],[0,0]];
var grad = [0,0,0,0,0];
var histPtr = 0;
var lastTmStp = "";
var _5GB = 5*1048576;
var dfNote = 2*_5GB;
var dfUrgnt = _5GB;
//var dfThres = 2.5*dfNote;

function updateDiskStatus(ctrl, /*diskUsed,*/ diskFreeKB, tmStp) {	
	function fmtSpc(vKB, dec) {
		var exp = vKB && Math.floor(Math.log(vKB)/Math.log(1024));
		var mant = Math.round(vKB/(Math.pow(1024,exp)/Math.pow(10,dec)))/Math.pow(10,dec);
		switch(exp) {
			case 0: return mant + " KB";
			case 1: return mant + " MB";
			case 2: return mant + " GB";
			case 3: return mant + " TB";
			case 4: return mant + " PB";
			case 5: return mant + " EB"; //Exabyte
			case 6: return mant + " ZB"; //Zettabyte (Angeber!)
			default: return "---";
		}
	}
	if (lastTmStp !== tmStp) {
		lastTmStp = tmStp;
		var sek = (parseFloat(tmStp.slice(0,4))-1940)*31556952 + parseFloat(tmStp.slice(4,6))*2629746 + parseFloat(tmStp.slice(6,8))*86400 + parseFloat(tmStp.slice(8,10))*3600 + parseFloat(tmStp.slice(10,12))*60 + parseFloat(tmStp.slice(12,14)); 
		var gradSum = 0.0;
		var tendencyIcon = "";
//		var percent = 100 * diskUsed / (diskUsed + diskFreeKB);
		hist[(histPtr >= 4) ? (histPtr = 0) : ++histPtr] = [diskFreeKB, sek];
		var dt = hist[histPtr][1] - hist[(histPtr-1 < 0) ? histPtr+4 : histPtr-1][1];
		grad[histPtr] = dt > 0.0 ? (hist[histPtr][0] - hist[(histPtr-1 < 0) ? histPtr+4 : histPtr-1][0]) / dt : 0.0; 
		ctrl.setText(fmtSpc(diskFreeKB, 1) + " free");
		if      (diskFreeKB > dfNote)  ctrl.setColorScheme(7);
		else if (diskFreeKB > dfUrgnt) ctrl.setColorScheme(1);
		else                         ctrl.setColorScheme(3);
		for (var n = 0; n < 5; n++) gradSum += grad[n];  
		var strong = (Math.abs(gradSum) > 500) ? 2 : (Math.abs(gradSum) > 10) ? 1 : 0;
		var dir = Math.sign(gradSum);
		if 		(strong === 0) tendencyIcon = "sap-icon://arrow-right";
		else if	(strong === 1) tendencyIcon = (dir > 0) ? "sap-icon://trend-up" : "sap-icon://trend-down";
		else tendencyIcon = (dir > 0) ? "sap-icon://arrow-top" : "sap-icon://arrow-bottom";
		if (!this.ttip) {
			this.ttip = new sap.m.Popover({
				showHeader: false,
				content: [new sap.m.HBox({items: [(this.free = new sap.m.Text()), (this.icon = new sap.ui.core.Icon({size: ".8em"})), new sap.m.Text({text: "]"})], alignItems: sap.m.FlexAlignItems.Baseline}), (this.note = new sap.m.FormattedText())],
				placement: sap.m.PlacementType.Bottom
			});    
			ttip.addStyleClass("sapUiContentPadding");
			ctrl.addEventDelegate({
				onmouseover: function(evt){if (!this.delayedOn) this.delayedOn = setTimeout($.proxy(function(){if (!ttip.isOpen()) ttip.openBy(evt.srcControl); this.delayedOn = 0;}, this), 200);},
				onmouseout: function(evt){if (!(this.delayedOff || this.delayedOn)) this.delayedOff = setTimeout($.proxy(function(){if (ttip.isOpen()) ttip.close(); else clearTimeout(this.delayedOn); this.delayedOn = 0; this.delayedOff = 0;}, this), 200);}
			});
		} 
		this.icon.setSrc(tendencyIcon).invalidate(); 
		this.free.setText("\nSUM partition free: " + fmtSpc(diskFreeKB, 2) + " [").invalidate();
		this.note.setHtmlText(diskFreeKB < dfNote ? "<span style=\"color: red\"><br/>You should " + (diskFreeKB < dfUrgnt ? "urgently increase" : "consider increasing") + "<br/>the SUM partition size!</span>" : "").invalidate();
	}
}

function seleniumize(id, that) {
	seleniumizeObj(that.getView().byId(id));
}

function seleniumizeObj(obj) {
	obj.addEventDelegate({onAfterRendering: function(oEvt){$("#"+oEvt.srcControl.getId()).attr(oEvt.srcControl.data());}});
	return obj;
}

function resErr(oCtrl) {
	oCtrl.getSource().setValueState(sap.ui.core.ValueState.None);
}

function regexyfy(ctrl) {
	var str = ctrl && ctrl.getValue();
	var regexp = null;
	if (str) {
		var pat;
		var mod = "gi";
		if (str[0] === "/") {
			var e = str.lastIndexOf('/');
			mod = str.substr(e+1);
			pat = str.substr(1, e-1);
		} else pat = str;
		try {
			regexp = new RegExp(pat, mod);
			ctrl.setValueState(sap.ui.core.ValueState.None);
		} catch(e) {
			ctrl.setValueState(sap.ui.core.ValueState.Error).setValueStateText("Invalid regular expression");
		}
	}
	return regexp;
}

function hlight(expr, el) {
	function ampEnc(str) {
		return String(str)
				.replace(/&/g, '&amp;')
				.replace(/"/g, '&quot;')
				.replace(/</g, '&lt;')
				.replace(/>/g, '&gt;')
				.replace(/&lt;span style=&quot;(.+?)&quot;&gt;(.+?)&lt;\/span&gt;/g, "<span style=\"$1\">$2</span>");
	}
	function ampDec(str) {
		return String(str)
				.replace(/&amp;/g, '&')
				.replace(/&quot;/g, '"')
				.replace(/&lt;/g, '<')
				.replace(/&gt;/g, '>');
	}
	function preCnv(str) {
		return String(str)
				.replace(/\*/g, '.*?')
				.replace(/(\.\*\?)$/, '.*');
	}
	var style;
	if ($(location).attr('href').indexOf("suihcb=true") > -1) style = "background-color: white; color: black;";
	else if ($(location).attr('href').indexOf("suihcw=true") > -1) style = "background-color: black; color: white;";
	else style = "background-color: yellow";
	el.innerHTML = ampEnc(ampDec(el.innerHTML).replace(new RegExp(preCnv(expr.replace(/[+?^${}()|[\]\\]/g, '\\$&')), "gi"), function(a,b,c){return "<span style=\"" + style +"\">"+a+"</span>";}));
}

function lmslToolWakeUp() {
	var xhr = new XMLHttpRequest(); 
	xhr.onreadystatechange = function() {
		if (this.readyState == 4 && this.status == 500) gSUMGlobals.popupError(this.responseText);
	};
	xhr.open("GET", gSUMGlobals.pathLmslAbap + "/");     // the trailing slash is important for authentication realm in the internal browser logic!
	xhr.send();          	
}
