/* global sap jQuery util */
/* eslint-disable strict */
jQuery.sap.declare("Application");

jQuery.sap.require("sap.ui.app.Application");
jQuery.sap.require("util.Navigation");

sap.ui.app.Application.extend("Application", {

	metadata: {
		includes: [
			"../css/style.css"
		]
	},

	init: function() {
		// set global models
		var model = new sap.ui.model.json.JSONModel(util.Navigation);
		sap.ui.getCore().setModel(model);

		// set device model
		var deviceModel = new sap.ui.model.json.JSONModel({
			listMode: (jQuery.device.is.phone) ? "None" : "SingleSelectMaster",
			listItemType: (jQuery.device.is.phone) ? "Active" : "Inactive"
		});
		sap.ui.getCore().setModel(deviceModel, "device");
	},

	main: function() {
		// create app view and put to html root element
		var root = this.getRoot();
		var oHelpBtn = new sap.m.Button({	text:"Help",
											tooltip: "Click to open the guide",
											type: "Transparent",
											press: openHelpWindow
										});
		var oMenuBtn = new sap.m.MenuButton({	icon:"sap-icon://menu2",
												tooltip: "Click for displaying more information and menu options",
												type: "Transparent",
												menu: new sap.m.Menu({items: [
													new sap.m.MenuItem({text: "Color Schema", items: [
														new sap.m.MenuItem({text: "Standard", press: function(){
															var ind = document.URL.indexOf("?sui");
															var ind2 = document.URL.indexOf("#");
															if (ind > 0) document.location.href = document.URL.slice(0, ind) + ((ind2 > ind) ? document.URL.slice(ind2) : "");
														}}),
														new sap.m.MenuItem({text: "Belize Plus", press: function(){
															var ind = document.URL.indexOf("?sui");
															var ind2 = document.URL.indexOf("#");
															if (ind > 0) document.location.href = document.URL.slice(0, ind) + "?suiplus=true" + ((ind2 > ind) ? document.URL.slice(ind2) : "");
															else if (ind2 > 0) document.location.href = document.URL.slice(0, ind2) + "?suiplus=true" + document.URL.slice(ind2);
															else document.location.href = document.URL + "?suiplus=true";
														}}),
														new sap.m.MenuItem({text: "High Contrast Black", press: function(){
															var ind = document.URL.indexOf("?sui");
															var ind2 = document.URL.indexOf("#");
															if (ind > 0) document.location.href = document.URL.slice(0, ind) + "?suihcb=true" + ((ind2 > ind) ? document.URL.slice(ind2) : "");
															else if (ind2 > 0) document.location.href = document.URL.slice(0, ind2) + "?suihcb=true" + document.URL.slice(ind2);
															else document.location.href = document.URL + "?suihcb=true";
														}}),
														new sap.m.MenuItem({text: "High Contrast White", press: function(){
															var ind = document.URL.indexOf("?sui");
															var ind2 = document.URL.indexOf("#");
															if (ind > 0) document.location.href = document.URL.slice(0, ind) + "?suihcw=true" + ((ind2 > ind) ? document.URL.slice(ind2) : "");
															else if (ind2 > 0) document.location.href = document.URL.slice(0, ind2) + "?suihcw=true" + document.URL.slice(ind2);
															else document.location.href = document.URL + "?suihcw=true";
														}})
													]}),
													new sap.m.MenuItem({text: "SUM Guide", press: function(){window.open("https://help.sap.com/viewer/c4ebc2b5d928446180d9ad2667f11faa/1.0/en-US/a151c8571e0c46b0a4098eda8d34303a.html", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");}}),
													new sap.m.MenuItem({text: "SUM Note", press: function(){window.open("https://launchpad.support.sap.com/#/notes/3146834", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");}}),
													new sap.m.MenuItem({text: "SAP Help Portal", press: function(){window.open("https://help.sap.com", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");}}),
													new sap.m.MenuItem({text: "Exit", press: function(){
														window.close();
														/* if rejected from browser, show 'close' screen */
														document.getElementById('content').outerHTML = "<HEAD></HEAD><body bgcolor=\"#DDEDF1\"><hr>You may close the browser page now.<hr></body>";
														if (isIE()) document.execCommand('Stop');
														else window.stop();		            				            																		
													}})
												]})
										});
		var oOTB = new sap.m.OverflowToolbar({
			content:[
				new sap.m.Image({src:"../slui/resources/img/saplogo.png", densityAware:true, height:"35px"}), 
//				new sap.m.VBox({items: [new sap.ui.core.Icon({src: "sap-icon://it-host", size: "34px", color: "#C0C0C0"}), new sap.m.FormattedText({id: "idSID", htmlText: "<span style=\"position:absolute;width:100%;font-size:9px;font-weight:bold;margin:-23px 0 0 -3px;text-align:center;\">" + sid + "</span>"})]}).addStyleClass("sid"),
				new sap.m.Text({text: sid}).addStyleClass("sid"),
				new sap.m.Label({text:"Software Update Manager"}),			
				new sap.m.ToolbarSpacer(), 
				oHelpBtn,
				oMenuBtn
		    ], height: "40px"});
		var oView = sap.ui.jsview("app", "views.app");
		oView.addStyleClass("shellHeight");
		var vBox = new sap.m.VBox({items:[oOTB, oView]});
		vBox.placeAt(root);
		this.assignF1KeyForHelp();
	},
	
    assignF1KeyForHelp: function() {
    	$(document).keydown(function(e){
    		if (e && (e.key === "F1")) {
    			window.onhelp = function() {return false;};
    			e.cancelable = true;
    			e.stopPropagation();
    			e.preventDefault();
    			e.returnValue = false;
    			openHelpWindow();
    		}
    	}); 
    }
});
