sap.ui.define([
    "sap/m/CheckBox"
], function(CheckBox) {
  "use strict";

	var ChkBox = CheckBox.extend("SUMControls.CheckBox", {	// call the new Control type "CheckBox" 
															// and let it inherit from sap.m.CheckBox
		metadata: {
			properties: {
				selected: 	{type: "boolean", defaultValue: false},
				required:   {type: "boolean", defaultValue: false},
				enables:	{type: "string"},
				disables:	{type: "string"},
				text:		{type: "string"}
			},
			aggregations: {
				children: {type: "sap.ui.core.Control", multiple: true}
			},
			defaultAggregation: "children"
		},
		
	    renderer: function(oRm, oControl) {
	        oRm.write("<div style=\"width: 100%;\">");
			oRm.write("<div style=\"display:flex; flex-direction: row; \">");
			sap.m.CheckBoxRenderer.render(oRm, oControl);
			findChildren(oControl.getChildren(), "SUMControls.Hint").forEach(function(a){oRm.renderControl(a);});
			oRm.write("</div>");	
			findChildren(oControl.getChildren(), "SUMControls.Group").forEach(function(a) {
				if ( (!oControl.getEnables() || (a.data("sumid") !== oControl.getEnables()) || oControl.getSelected() )
				||   (!oControl.getDisables() || (a.data("sumid") !== oControl.getDisables()) || !oControl.getSelected() )){
					oRm.write("<div style=\"margin-left: 40px;\">");
					oRm.renderControl(a);
					oRm.write("</div>");
				}
			});
		    oRm.write("</div>");
	    }
	});
	
  return ChkBox;
});  