sap.ui.define([
	"sap/ui/core/Control",
	"sap/ui/core/Fragment"
], function(Control, Fragment) {
	"use strict";

	/**
	 * Base class for controls which use XML fragments for rendering
     */
	var FragmentControl = Control.extend("SUMControls.FragmentControl", {

		metadata: {
			properties: {
				_aFragmentControls: {
					type: "sap.ui.core.Control[]",
					defaultValue: null
				}
			}
		},
		
		initFragmentControls: function() {
			this._aFragmentControls = this._loadFragmentControls();
			this._aFragmentControls.forEach(function(oFragmentControl) {
				this.addDependent(oFragmentControl);
			}, this);
		},

		_loadFragmentControls: function() {
			var vFragment = sap.ui.xmlfragment(this.getId(), this.getFragmentName(), this);
			var aFragmentControls = Array.isArray(vFragment) ? vFragment : [vFragment];
			return aFragmentControls;
		},

		getFragmentName: function() {
			return this.getMetadata().getName();
		},
		
		byId: function(sControlId) {
			return Fragment.byId(this.getId(), sControlId);
		},
		
		doRendering: function(oRenderManager, oControl) {
			if (!oControl.getVisible()) {
				return;
			}
			
			if(Array.isArray(oControl._aFragmentControls)) {
				oControl._aFragmentControls.forEach(function(oFragmentControl) {
					oRenderManager.renderControl(oFragmentControl);
				});
			}
		},
		
		renderer: function(oRenderManager, oControl) {
			return; /* will be overridden by sub class */
		}
		
	});

	return FragmentControl;
});